/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_ECNR_DBUGPROXY_H
#define ORG_BOSCH_ECNR_DBUGPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "org/bosch/ecnr/dbug.h"
#include <dbus/dbus.h>

namespace org {
namespace bosch {
namespace ecnr {
namespace dbug {

class DbugProxy;

class EcnrEndDebugDataCallbackIF {
public:
    virtual ~EcnrEndDebugDataCallbackIF() {}

    virtual void onEcnrEndDebugDataError(const ::boost::shared_ptr< DbugProxy >& proxy, const ::boost::shared_ptr< EcnrEndDebugDataError >& error) = 0;

    virtual void onEcnrEndDebugDataResponse(const ::boost::shared_ptr< DbugProxy >& proxy, const ::boost::shared_ptr< EcnrEndDebugDataResponse >& response) = 0;
};

class EcnrStartDebugDataCallbackIF {
public:
    virtual ~EcnrStartDebugDataCallbackIF() {}

    virtual void onEcnrStartDebugDataError(const ::boost::shared_ptr< DbugProxy >& proxy, const ::boost::shared_ptr< EcnrStartDebugDataError >& error) = 0;

    virtual void onEcnrStartDebugDataResponse(const ::boost::shared_ptr< DbugProxy >& proxy, const ::boost::shared_ptr< EcnrStartDebugDataResponse >& response) = 0;
};


/**
 * DbugProxy is the client side representation of the D-Bus service
 * interface 'org.bosch.ecnr.dbug' (specified in file
 * ecnr-sse-introspection.xml).
 *
 * If the meaning of "org.bosch.ecnr.dbug" isn't clear, then there should be a description here.
 */
class DbugProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of DbugProxy.
     */
    static ::boost::shared_ptr< DbugProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of DbugProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< DbugProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of DbugProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< DbugProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< DbugProxy > proxyNew(new DbugProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(false);
        return proxyNew;
    }

    virtual ~DbugProxy ();




    // Method 'ecnrStartDebugData'

    /**
     * Call the method 'ecnrStartDebugData'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'ecnrStartDebugData'</b>:
     *
     * If the meaning of "ecnrStartDebugData" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param ecnrDebugMode If the meaning of "ecnrDebugMode" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendEcnrStartDebugDataRequest(EcnrStartDebugDataCallbackIF& cb, uint8 ecnrDebugMode) const;

    // Method 'ecnrEndDebugData'

    /**
     * Call the method 'ecnrEndDebugData'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'ecnrEndDebugData'</b>:
     *
     * If the meaning of "ecnrEndDebugData" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param ecnrDebugMode If the meaning of "ecnrDebugMode" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendEcnrEndDebugDataRequest(EcnrEndDebugDataCallbackIF& cb, uint8 ecnrDebugMode) const;


private:

    DbugProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;


    DECLARE_CLASS_LOGGER();

    friend class DbugProxyCallback;
};

} // namespace dbug
} // namespace ecnr
} // namespace bosch
} // namespace org

#endif // ORG_BOSCH_ECNR_DBUGPROXY_H
