/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/audproc/service.h"
#include "org/bosch/audproc/serviceDBus.h"
#include "org/bosch/audproc/serviceJson.h"
#include "org/bosch/audproc/serviceStub.h"
#include <string>
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bosch {
namespace audproc {
namespace service {

DEFINE_CLASS_LOGGER("///org/bosch/audproc/service", ServiceStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 11, "AudprocMute", 14 },
    { 13, "AudprocCreate", 4 },
    { 14, "AudprocDestroy", 7 },
    { 15, "AudprocReadData", 10 },
    { 15, "AudprocSetParam", 8 },
    { 16, "AudprocGetStatus", 1 },
    { 16, "AudprocStopAudio", 13 },
    { 16, "AudprocTerminate", 2 },
    { 16, "AudprocWriteData", 9 },
    { 17, "AudprocGetVersion", 0 },
    { 17, "AudprocInitialize", 5 },
    { 17, "AudprocSetupDebug", 3 },
    { 17, "AudprocStartAudio", 12 },
    { 19, "AudprocSourceSelect", 16 },
    { 21, "AudprocSourceActivity", 15 },
    { 23, "AudprocSetConfiguration", 6 },
    { 30, "AudprocGetAudprocConfiguration", 11 },
};

static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 9, "aplMicLvl", 11 },
    { 12, "aplAudioMode", 12 },
    { 15, "aplArkamysFlush", 9 },
    { 19, "aplArkamysLevelLoss", 6 },
    { 19, "aplLoopbackActivate", 13 },
    { 20, "aplMicLvlWatchRefInt", 10 },
    { 21, "aplArkamysAvcActivate", 0 },
    { 22, "aplArkamysCurrentSpeed", 3 },
    { 24, "aplArkamysAmbienceSelect", 5 },
    { 24, "aplArkamysByPassActivate", 1 },
    { 24, "aplArkamysLibraryVersion", 7 },
    { 27, "aplArkamysCurrentVolumeStep", 4 },
    { 28, "aplArkamysCurrVolAttenuation", 8 },
    { 29, "aplArkamysInputLevelDeviation", 2 },
};

class ServiceStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    ServiceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    ServiceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    ServiceStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.bosch.audproc.service"),
          _logger(logger) {}

    virtual ~ServiceStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void ServiceStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 17, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'AudprocGetVersion'

            LOG_DEBUG_STUB("process method '%s'", "AudprocGetVersion");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AudprocGetVersionRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "AudprocGetVersion", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< AudprocGetVersionRequest > payload = ::boost::static_pointer_cast<AudprocGetVersionRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onAudprocGetVersionRequest(payload);
            return;
        }
        case 1: {

            // method 'AudprocGetStatus'

            LOG_DEBUG_STUB("process method '%s'", "AudprocGetStatus");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AudprocGetStatusRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "AudprocGetStatus", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< AudprocGetStatusRequest > payload = ::boost::static_pointer_cast<AudprocGetStatusRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onAudprocGetStatusRequest(payload);
            return;
        }
        case 2: {

            // method 'AudprocTerminate'

            LOG_DEBUG_STUB("process method '%s'", "AudprocTerminate");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AudprocTerminateRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "AudprocTerminate", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< AudprocTerminateRequest > payload = ::boost::static_pointer_cast<AudprocTerminateRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onAudprocTerminateRequest(payload);
            return;
        }
        case 3: {

            // method 'AudprocSetupDebug'

            LOG_DEBUG_STUB("process method '%s'", "AudprocSetupDebug");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AudprocSetupDebugRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "AudprocSetupDebug", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< AudprocSetupDebugRequest > payload = ::boost::static_pointer_cast<AudprocSetupDebugRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onAudprocSetupDebugRequest(payload);
            return;
        }
        case 4: {

            // method 'AudprocCreate'

            LOG_DEBUG_STUB("process method '%s'", "AudprocCreate");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AudprocCreateRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "AudprocCreate", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< AudprocCreateRequest > payload = ::boost::static_pointer_cast<AudprocCreateRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onAudprocCreateRequest(payload);
            return;
        }
        case 5: {

            // method 'AudprocInitialize'

            LOG_DEBUG_STUB("process method '%s'", "AudprocInitialize");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AudprocInitializeRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "AudprocInitialize", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< AudprocInitializeRequest > payload = ::boost::static_pointer_cast<AudprocInitializeRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onAudprocInitializeRequest(payload);
            return;
        }
        case 6: {

            // method 'AudprocSetConfiguration'

            LOG_DEBUG_STUB("process method '%s'", "AudprocSetConfiguration");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AudprocSetConfigurationRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "AudprocSetConfiguration", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< AudprocSetConfigurationRequest > payload = ::boost::static_pointer_cast<AudprocSetConfigurationRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onAudprocSetConfigurationRequest(payload);
            return;
        }
        case 7: {

            // method 'AudprocDestroy'

            LOG_DEBUG_STUB("process method '%s'", "AudprocDestroy");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AudprocDestroyRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "AudprocDestroy", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< AudprocDestroyRequest > payload = ::boost::static_pointer_cast<AudprocDestroyRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onAudprocDestroyRequest(payload);
            return;
        }
        case 8: {

            // method 'AudprocSetParam'

            LOG_DEBUG_STUB("process method '%s'", "AudprocSetParam");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AudprocSetParamRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "AudprocSetParam", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< AudprocSetParamRequest > payload = ::boost::static_pointer_cast<AudprocSetParamRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onAudprocSetParamRequest(payload);
            return;
        }
        case 9: {

            // method 'AudprocWriteData'

            LOG_DEBUG_STUB("process method '%s'", "AudprocWriteData");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AudprocWriteDataRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "AudprocWriteData", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< AudprocWriteDataRequest > payload = ::boost::static_pointer_cast<AudprocWriteDataRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onAudprocWriteDataRequest(payload);
            return;
        }
        case 10: {

            // method 'AudprocReadData'

            LOG_DEBUG_STUB("process method '%s'", "AudprocReadData");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AudprocReadDataRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "AudprocReadData", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< AudprocReadDataRequest > payload = ::boost::static_pointer_cast<AudprocReadDataRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onAudprocReadDataRequest(payload);
            return;
        }
        case 11: {

            // method 'AudprocGetAudprocConfiguration'

            LOG_DEBUG_STUB("process method '%s'", "AudprocGetAudprocConfiguration");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AudprocGetAudprocConfigurationRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "AudprocGetAudprocConfiguration", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< AudprocGetAudprocConfigurationRequest > payload = ::boost::static_pointer_cast<AudprocGetAudprocConfigurationRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onAudprocGetAudprocConfigurationRequest(payload);
            return;
        }
        case 12: {

            // method 'AudprocStartAudio'

            LOG_DEBUG_STUB("process method '%s'", "AudprocStartAudio");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AudprocStartAudioRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "AudprocStartAudio", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< AudprocStartAudioRequest > payload = ::boost::static_pointer_cast<AudprocStartAudioRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onAudprocStartAudioRequest(payload);
            return;
        }
        case 13: {

            // method 'AudprocStopAudio'

            LOG_DEBUG_STUB("process method '%s'", "AudprocStopAudio");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AudprocStopAudioRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "AudprocStopAudio", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< AudprocStopAudioRequest > payload = ::boost::static_pointer_cast<AudprocStopAudioRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onAudprocStopAudioRequest(payload);
            return;
        }
        case 14: {

            // method 'AudprocMute'

            LOG_DEBUG_STUB("process method '%s'", "AudprocMute");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AudprocMuteRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "AudprocMute", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< AudprocMuteRequest > payload = ::boost::static_pointer_cast<AudprocMuteRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onAudprocMuteRequest(payload);
            return;
        }
        case 15: {

            // method 'AudprocSourceActivity'

            LOG_DEBUG_STUB("process method '%s'", "AudprocSourceActivity");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AudprocSourceActivityRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "AudprocSourceActivity", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< AudprocSourceActivityRequest > payload = ::boost::static_pointer_cast<AudprocSourceActivityRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onAudprocSourceActivityRequest(payload);
            return;
        }
        case 16: {

            // method 'AudprocSourceSelect'

            LOG_DEBUG_STUB("process method '%s'", "AudprocSourceSelect");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AudprocSourceSelectRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "AudprocSourceSelect", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< AudprocSourceSelectRequest > payload = ::boost::static_pointer_cast<AudprocSourceSelectRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onAudprocSourceSelectRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* ServiceStubDelegate::introspect() const {
    return     "<interface name=\"org.bosch.audproc.service\">\n"
            "      <doc>\n"
            "        <line>List of statusEntSrcActiveState, statusVoiceSrcActiveState, statusinfoSrcActiveState  </line>\n"
            "        <line>AUDPROC_AS_STREAM_SILENCE         = 0,     </line>\n"
            "        <line>AUDPROC_AS_STREAM_INIT            = 1,    </line>\n"
            "        <line>AUDPROC_AS_STREAM_WAIT_DATA       = 2,    </line>\n"
            "        <line>AUDPROC_AS_STREAM_RUNNING         = 3,    </line>\n"
            "        <line>AUDPROC_AS_STREAM_WAIT_RECOVER    = 4,    </line>\n"
            "        <line>AUDPROC_AS_STREAM_TERMINATED      = 6,    </line>\n"
            "        <line>AUDPROC_AS_STREAM_ERROR           = 7,    </line>\n"
            "        <line>AUDPROC_AS_STREAM_SILENCE_PRELOAD = 8,    </line>\n"
            "      </doc>\n"
            "      <method name=\"AudprocGetVersion\">\n"
            "        <arg direction=\"out\" name=\"Version\" type=\"au\"/>\n"
            "        <arg direction=\"out\" name=\"VersionString\" type=\"s\"/>\n"
            "        <arg direction=\"out\" name=\"VersionComment\" type=\"s\"/>\n"
            "      </method>\n"
            "      <method name=\"AudprocGetStatus\"/>\n"
            "      <method name=\"AudprocTerminate\"/>\n"
            "      <method name=\"AudprocSetupDebug\">\n"
            "        <arg direction=\"in\" name=\"AudprocSelectMode\" type=\"y\"/>\n"
            "      </method>\n"
            "      <method name=\"AudprocCreate\"/>\n"
            "      <method name=\"AudprocInitialize\">\n"
            "        <arg direction=\"in\" name=\"AudprocSourceId\" type=\"y\"/>\n"
            "        <arg direction=\"in\" name=\"AudprocConfigurationFile\" type=\"s\"/>\n"
            "      </method>\n"
            "      <method name=\"AudprocSetConfiguration\">\n"
            "        <arg direction=\"in\" name=\"AudprocSourceId\" type=\"y\"/>\n"
            "        <arg direction=\"in\" name=\"AudprocConfigurationFile\" type=\"s\"/>\n"
            "      </method>\n"
            "      <method name=\"AudprocDestroy\">\n"
            "        <doc>\n"
            "          <line> - stop stream instance if currently running </line>\n"
            "          <line> - the audioprocess takes care for a mute smoothly fading if the streaming is still active </line>\n"
            "          <line> - Current apl library instance and all associated setting are destroyed, maybe a storing is done (tbd) </line>\n"
            "          <line> - based on configuratio, the alsa deviec associated to eth source is closed </line>\n"
            "        </doc>\n"
            "        <arg direction=\"in\" name=\"AudprocSourceId\" type=\"y\"/>\n"
            "      </method>\n"
            "      <method name=\"AudprocSetParam\">\n"
            "        <arg direction=\"in\" name=\"AudprocSourceId\" type=\"y\"/>\n"
            "        <arg direction=\"in\" name=\"ParameterId\" type=\"u\"/>\n"
            "        <arg direction=\"in\" name=\"ParamType\" type=\"y\"/>\n"
            "        <arg direction=\"in\" name=\"uParameter\" type=\"u\"/>\n"
            "        <arg direction=\"in\" name=\"sParameter\" type=\"i\"/>\n"
            "      </method>\n"
            "      <method name=\"AudprocWriteData\">\n"
            "        <arg direction=\"in\" name=\"AudprocSourceId\" type=\"y\"/>\n"
            "        <arg direction=\"in\" name=\"ParameterId\" type=\"u\"/>\n"
            "        <arg direction=\"in\" name=\"data\" type=\"ay\"/>\n"
            "        <arg direction=\"out\" name=\"result\" type=\"ay\"/>\n"
            "      </method>\n"
            "      <method name=\"AudprocReadData\">\n"
            "        <arg direction=\"in\" name=\"AudprocSourceId\" type=\"y\"/>\n"
            "        <arg direction=\"in\" name=\"ParameterId\" type=\"u\"/>\n"
            "        <arg direction=\"in\" name=\"ReadInfos\" type=\"ay\"/>\n"
            "        <arg direction=\"out\" name=\"data\" type=\"ay\"/>\n"
            "      </method>\n"
            "      <method name=\"AudprocGetAudprocConfiguration\">\n"
            "        <arg direction=\"out\" name=\"DatasetName\" type=\"s\"/>\n"
            "        <arg direction=\"out\" name=\"AudprocProperties\" type=\"u\"/>\n"
            "      </method>\n"
            "      <method name=\"AudprocStartAudio\">\n"
            "        <arg direction=\"in\" name=\"AudprocSourceId\" type=\"y\"/>\n"
            "      </method>\n"
            "      <method name=\"AudprocStopAudio\">\n"
            "        <arg direction=\"in\" name=\"AudprocSourceId\" type=\"y\"/>\n"
            "      </method>\n"
            "      <method name=\"AudprocMute\"/>\n"
            "      <method name=\"AudprocSourceActivity\">\n"
            "        <arg direction=\"in\" name=\"AudprocSourceMapId\" type=\"y\"/>\n"
            "        <arg direction=\"in\" name=\"AudprocSourceActivity\" type=\"y\"/>\n"
            "      </method>\n"
            "      <method name=\"AudprocSourceSelect\">\n"
            "        <doc>\n"
            "          <line> setup of an audio connection source -> senk </line>\n"
            "        </doc>\n"
            "        <arg direction=\"in\" name=\"AudprocSourceSelectMode\" type=\"y\"/>\n"
            "        <arg direction=\"in\" name=\"AudprocSourceId\" type=\"y\"/>\n"
            "        <arg direction=\"in\" name=\"AudprocAlsaDev\" type=\"s\"/>\n"
            "      </method>\n"
            "      <signal name=\"AudprocStatus\">\n"
            "        <arg direction=\"out\" name=\"statusEntSrcEnum\" type=\"y\"/>\n"
            "        <arg direction=\"out\" name=\"statusEntSrcActiveState\" type=\"y\"/>\n"
            "        <arg direction=\"out\" name=\"statusVoiceSrcEnum\" type=\"y\"/>\n"
            "        <arg direction=\"out\" name=\"statusVoiceSrcActiveState\" type=\"y\"/>\n"
            "        <arg direction=\"out\" name=\"statusInfoSrcEnum\" type=\"y\"/>\n"
            "        <arg direction=\"out\" name=\"statusinfoSrcActiveState\" type=\"y\"/>\n"
            "      </signal>\n"
            "      <signal name=\"AudprocMicrolevelStatus\">\n"
            "        <arg direction=\"out\" name=\"StatusMicroLevel\" type=\"n\"/>\n"
            "      </signal>\n"
            "      <signal name=\"AudprocArkamysLevelLoss\">\n"
            "        <doc>\n"
            "          <line> notify new value of property aplArkamysLevelLoss </line>\n"
            "        </doc>\n"
            "        <arg direction=\"out\" name=\"StatusArkamysLevelLoss\" type=\"i\"/>\n"
            "      </signal>\n"
            "      <property access=\"readwrite\" name=\"aplArkamysAvcActivate\" type=\"i\"/>\n"
            "      <property access=\"readwrite\" name=\"aplArkamysByPassActivate\" type=\"i\"/>\n"
            "      <property access=\"readwrite\" name=\"aplArkamysInputLevelDeviation\" type=\"i\"/>\n"
            "      <property access=\"readwrite\" name=\"aplArkamysCurrentSpeed\" type=\"i\"/>\n"
            "      <property access=\"readwrite\" name=\"aplArkamysCurrentVolumeStep\" type=\"i\"/>\n"
            "      <property access=\"readwrite\" name=\"aplArkamysAmbienceSelect\" type=\"i\"/>\n"
            "      <property access=\"readwrite\" name=\"aplArkamysLevelLoss\" type=\"i\"/>\n"
            "      <property access=\"readwrite\" name=\"aplArkamysLibraryVersion\" type=\"ai\"/>\n"
            "      <property access=\"readwrite\" name=\"aplArkamysCurrVolAttenuation\" type=\"i\"/>\n"
            "      <property access=\"readwrite\" name=\"aplArkamysFlush\" type=\"i\"/>\n"
            "      <property access=\"readwrite\" name=\"aplMicLvlWatchRefInt\" type=\"u\"/>\n"
            "      <property access=\"readwrite\" name=\"aplMicLvl\" type=\"i\"/>\n"
            "      <property access=\"readwrite\" name=\"aplAudioMode\" type=\"i\"/>\n"
            "      <property access=\"readwrite\" name=\"aplLoopbackActivate\" type=\"i\"/>\n"
            "</interface>\n";
}

void ServiceStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<ServiceStub*>(getStub()))->onGetAll (properties);
}

void ServiceStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 14, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "aplArkamysAvcActivate");
            ::boost::shared_ptr< AplArkamysAvcActivateSet > payload(new AplArkamysAvcActivateSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<ServiceStub*>(getStub())->onAplArkamysAvcActivateSet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "aplArkamysByPassActivate");
            ::boost::shared_ptr< AplArkamysByPassActivateSet > payload(new AplArkamysByPassActivateSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<ServiceStub*>(getStub())->onAplArkamysByPassActivateSet (payload);
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "aplArkamysInputLevelDeviation");
            ::boost::shared_ptr< AplArkamysInputLevelDeviationSet > payload(new AplArkamysInputLevelDeviationSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<ServiceStub*>(getStub())->onAplArkamysInputLevelDeviationSet (payload);
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "aplArkamysCurrentSpeed");
            ::boost::shared_ptr< AplArkamysCurrentSpeedSet > payload(new AplArkamysCurrentSpeedSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<ServiceStub*>(getStub())->onAplArkamysCurrentSpeedSet (payload);
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "aplArkamysCurrentVolumeStep");
            ::boost::shared_ptr< AplArkamysCurrentVolumeStepSet > payload(new AplArkamysCurrentVolumeStepSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<ServiceStub*>(getStub())->onAplArkamysCurrentVolumeStepSet (payload);
            return;
        }
        case 5: {
            LOG_DEBUG_STUB("process property '%s'", "aplArkamysAmbienceSelect");
            ::boost::shared_ptr< AplArkamysAmbienceSelectSet > payload(new AplArkamysAmbienceSelectSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<ServiceStub*>(getStub())->onAplArkamysAmbienceSelectSet (payload);
            return;
        }
        case 6: {
            LOG_DEBUG_STUB("process property '%s'", "aplArkamysLevelLoss");
            ::boost::shared_ptr< AplArkamysLevelLossSet > payload(new AplArkamysLevelLossSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<ServiceStub*>(getStub())->onAplArkamysLevelLossSet (payload);
            return;
        }
        case 7: {
            LOG_DEBUG_STUB("process property '%s'", "aplArkamysLibraryVersion");
            ::boost::shared_ptr< AplArkamysLibraryVersionSet > payload(new AplArkamysLibraryVersionSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<ServiceStub*>(getStub())->onAplArkamysLibraryVersionSet (payload);
            return;
        }
        case 8: {
            LOG_DEBUG_STUB("process property '%s'", "aplArkamysCurrVolAttenuation");
            ::boost::shared_ptr< AplArkamysCurrVolAttenuationSet > payload(new AplArkamysCurrVolAttenuationSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<ServiceStub*>(getStub())->onAplArkamysCurrVolAttenuationSet (payload);
            return;
        }
        case 9: {
            LOG_DEBUG_STUB("process property '%s'", "aplArkamysFlush");
            ::boost::shared_ptr< AplArkamysFlushSet > payload(new AplArkamysFlushSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<ServiceStub*>(getStub())->onAplArkamysFlushSet (payload);
            return;
        }
        case 10: {
            LOG_DEBUG_STUB("process property '%s'", "aplMicLvlWatchRefInt");
            ::boost::shared_ptr< AplMicLvlWatchRefIntSet > payload(new AplMicLvlWatchRefIntSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<ServiceStub*>(getStub())->onAplMicLvlWatchRefIntSet (payload);
            return;
        }
        case 11: {
            LOG_DEBUG_STUB("process property '%s'", "aplMicLvl");
            ::boost::shared_ptr< AplMicLvlSet > payload(new AplMicLvlSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<ServiceStub*>(getStub())->onAplMicLvlSet (payload);
            return;
        }
        case 12: {
            LOG_DEBUG_STUB("process property '%s'", "aplAudioMode");
            ::boost::shared_ptr< AplAudioModeSet > payload(new AplAudioModeSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<ServiceStub*>(getStub())->onAplAudioModeSet (payload);
            return;
        }
        case 13: {
            LOG_DEBUG_STUB("process property '%s'", "aplLoopbackActivate");
            ::boost::shared_ptr< AplLoopbackActivateSet > payload(new AplLoopbackActivateSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<ServiceStub*>(getStub())->onAplLoopbackActivateSet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void ServiceStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 14, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "aplArkamysAvcActivate");
            ::boost::shared_ptr< AplArkamysAvcActivateGet > payload(new AplArkamysAvcActivateGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onAplArkamysAvcActivateGet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "aplArkamysByPassActivate");
            ::boost::shared_ptr< AplArkamysByPassActivateGet > payload(new AplArkamysByPassActivateGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onAplArkamysByPassActivateGet (payload);
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "aplArkamysInputLevelDeviation");
            ::boost::shared_ptr< AplArkamysInputLevelDeviationGet > payload(new AplArkamysInputLevelDeviationGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onAplArkamysInputLevelDeviationGet (payload);
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "aplArkamysCurrentSpeed");
            ::boost::shared_ptr< AplArkamysCurrentSpeedGet > payload(new AplArkamysCurrentSpeedGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onAplArkamysCurrentSpeedGet (payload);
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "aplArkamysCurrentVolumeStep");
            ::boost::shared_ptr< AplArkamysCurrentVolumeStepGet > payload(new AplArkamysCurrentVolumeStepGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onAplArkamysCurrentVolumeStepGet (payload);
            return;
        }
        case 5: {
            LOG_DEBUG_STUB("process property '%s'", "aplArkamysAmbienceSelect");
            ::boost::shared_ptr< AplArkamysAmbienceSelectGet > payload(new AplArkamysAmbienceSelectGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onAplArkamysAmbienceSelectGet (payload);
            return;
        }
        case 6: {
            LOG_DEBUG_STUB("process property '%s'", "aplArkamysLevelLoss");
            ::boost::shared_ptr< AplArkamysLevelLossGet > payload(new AplArkamysLevelLossGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onAplArkamysLevelLossGet (payload);
            return;
        }
        case 7: {
            LOG_DEBUG_STUB("process property '%s'", "aplArkamysLibraryVersion");
            ::boost::shared_ptr< AplArkamysLibraryVersionGet > payload(new AplArkamysLibraryVersionGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onAplArkamysLibraryVersionGet (payload);
            return;
        }
        case 8: {
            LOG_DEBUG_STUB("process property '%s'", "aplArkamysCurrVolAttenuation");
            ::boost::shared_ptr< AplArkamysCurrVolAttenuationGet > payload(new AplArkamysCurrVolAttenuationGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onAplArkamysCurrVolAttenuationGet (payload);
            return;
        }
        case 9: {
            LOG_DEBUG_STUB("process property '%s'", "aplArkamysFlush");
            ::boost::shared_ptr< AplArkamysFlushGet > payload(new AplArkamysFlushGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onAplArkamysFlushGet (payload);
            return;
        }
        case 10: {
            LOG_DEBUG_STUB("process property '%s'", "aplMicLvlWatchRefInt");
            ::boost::shared_ptr< AplMicLvlWatchRefIntGet > payload(new AplMicLvlWatchRefIntGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onAplMicLvlWatchRefIntGet (payload);
            return;
        }
        case 11: {
            LOG_DEBUG_STUB("process property '%s'", "aplMicLvl");
            ::boost::shared_ptr< AplMicLvlGet > payload(new AplMicLvlGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onAplMicLvlGet (payload);
            return;
        }
        case 12: {
            LOG_DEBUG_STUB("process property '%s'", "aplAudioMode");
            ::boost::shared_ptr< AplAudioModeGet > payload(new AplAudioModeGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onAplAudioModeGet (payload);
            return;
        }
        case 13: {
            LOG_DEBUG_STUB("process property '%s'", "aplLoopbackActivate");
            ::boost::shared_ptr< AplLoopbackActivateGet > payload(new AplLoopbackActivateGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onAplLoopbackActivateGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

ServiceStub::ServiceStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new ServiceStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

ServiceStub::ServiceStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new ServiceStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

ServiceStub::~ServiceStub() {
    delete _stubDelegate;
}

void ServiceStub::sendAudprocStatusSignal(uint8 statusEntSrcEnum, uint8 statusEntSrcActiveState, uint8 statusVoiceSrcEnum, uint8 statusVoiceSrcActiveState, uint8 statusInfoSrcEnum, uint8 statusinfoSrcActiveState) {
    if (_stubDelegate->isConnected()) {
        AudprocStatusSignal* payload = new AudprocStatusSignal(statusEntSrcEnum, statusEntSrcActiveState, statusVoiceSrcEnum, statusVoiceSrcActiveState, statusInfoSrcEnum, statusinfoSrcActiveState);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "AudprocStatus", AudprocStatusSignal, payload)
        LOG_INFO ("-> send%sSignal", "AudprocStatus");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "AudprocStatus");
    }
}

void ServiceStub::sendAudprocMicrolevelStatusSignal(int16 statusMicroLevel) {
    if (_stubDelegate->isConnected()) {
        AudprocMicrolevelStatusSignal* payload = new AudprocMicrolevelStatusSignal(statusMicroLevel);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "AudprocMicrolevelStatus", AudprocMicrolevelStatusSignal, payload)
        LOG_INFO ("-> send%sSignal", "AudprocMicrolevelStatus");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "AudprocMicrolevelStatus");
    }
}

void ServiceStub::sendAudprocArkamysLevelLossSignal(int32 statusArkamysLevelLoss) {
    if (_stubDelegate->isConnected()) {
        AudprocArkamysLevelLossSignal* payload = new AudprocArkamysLevelLossSignal(statusArkamysLevelLoss);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "AudprocArkamysLevelLoss", AudprocArkamysLevelLossSignal, payload)
        LOG_INFO ("-> send%sSignal", "AudprocArkamysLevelLoss");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "AudprocArkamysLevelLoss");
    }
}

void ServiceStub::sendAplArkamysAvcActivateUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        AplArkamysAvcActivateUpdate payload(_aplArkamysAvcActivateProperty);

        LOG_INFO ("-> send%s", "AplArkamysAvcActivateUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("aplArkamysAvcActivate", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.audproc.service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "AplArkamysAvcActivateUpdate");
    }
}

void ServiceStub::onAplArkamysAvcActivateGet(const ::boost::shared_ptr< AplArkamysAvcActivateGet >& aplArkamysAvcActivate) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AplArkamysAvcActivateGet", aplArkamysAvcActivate->getAct());
    sendAplArkamysAvcActivateGetUpdate(_aplArkamysAvcActivateProperty.getAplArkamysAvcActivate(), aplArkamysAvcActivate->getAct());
}

void ServiceStub::sendAplArkamysAvcActivateGetUpdate(int32 aplArkamysAvcActivate, act_t act) {
    ::asf::dbus::DBusVariant variant;
    AplArkamysAvcActivateGet payload(aplArkamysAvcActivate);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AplArkamysAvcActivateGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::onAplArkamysAvcActivateSet(const ::boost::shared_ptr< AplArkamysAvcActivateSet >& aplArkamysAvcActivate) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AplArkamysAvcActivateSet", aplArkamysAvcActivate->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*aplArkamysAvcActivate, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setAplArkamysAvcActivate (aplArkamysAvcActivate->getAplArkamysAvcActivate());
    sendAplArkamysAvcActivateSetUpdate(aplArkamysAvcActivate->getAct());
}

void ServiceStub::sendAplArkamysAvcActivateSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AplArkamysAvcActivateSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void ServiceStub::setAplArkamysAvcActivate(int32 aplArkamysAvcActivate) {
    if(aplArkamysAvcActivate!=_aplArkamysAvcActivateProperty.getAplArkamysAvcActivate()) {
        _aplArkamysAvcActivateProperty.setAplArkamysAvcActivate(aplArkamysAvcActivate);
        sendAplArkamysAvcActivateUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

int32 ServiceStub::getAplArkamysAvcActivate() const {
    return _aplArkamysAvcActivateProperty.getAplArkamysAvcActivate();
}

void ServiceStub::sendAplArkamysByPassActivateUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        AplArkamysByPassActivateUpdate payload(_aplArkamysByPassActivateProperty);

        LOG_INFO ("-> send%s", "AplArkamysByPassActivateUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("aplArkamysByPassActivate", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.audproc.service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "AplArkamysByPassActivateUpdate");
    }
}

void ServiceStub::onAplArkamysByPassActivateGet(const ::boost::shared_ptr< AplArkamysByPassActivateGet >& aplArkamysByPassActivate) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AplArkamysByPassActivateGet", aplArkamysByPassActivate->getAct());
    sendAplArkamysByPassActivateGetUpdate(_aplArkamysByPassActivateProperty.getAplArkamysByPassActivate(), aplArkamysByPassActivate->getAct());
}

void ServiceStub::sendAplArkamysByPassActivateGetUpdate(int32 aplArkamysByPassActivate, act_t act) {
    ::asf::dbus::DBusVariant variant;
    AplArkamysByPassActivateGet payload(aplArkamysByPassActivate);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AplArkamysByPassActivateGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::onAplArkamysByPassActivateSet(const ::boost::shared_ptr< AplArkamysByPassActivateSet >& aplArkamysByPassActivate) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AplArkamysByPassActivateSet", aplArkamysByPassActivate->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*aplArkamysByPassActivate, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setAplArkamysByPassActivate (aplArkamysByPassActivate->getAplArkamysByPassActivate());
    sendAplArkamysByPassActivateSetUpdate(aplArkamysByPassActivate->getAct());
}

void ServiceStub::sendAplArkamysByPassActivateSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AplArkamysByPassActivateSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void ServiceStub::setAplArkamysByPassActivate(int32 aplArkamysByPassActivate) {
    if(aplArkamysByPassActivate!=_aplArkamysByPassActivateProperty.getAplArkamysByPassActivate()) {
        _aplArkamysByPassActivateProperty.setAplArkamysByPassActivate(aplArkamysByPassActivate);
        sendAplArkamysByPassActivateUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

int32 ServiceStub::getAplArkamysByPassActivate() const {
    return _aplArkamysByPassActivateProperty.getAplArkamysByPassActivate();
}

void ServiceStub::sendAplArkamysInputLevelDeviationUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        AplArkamysInputLevelDeviationUpdate payload(_aplArkamysInputLevelDeviationProperty);

        LOG_INFO ("-> send%s", "AplArkamysInputLevelDeviationUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("aplArkamysInputLevelDeviation", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.audproc.service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "AplArkamysInputLevelDeviationUpdate");
    }
}

void ServiceStub::onAplArkamysInputLevelDeviationGet(const ::boost::shared_ptr< AplArkamysInputLevelDeviationGet >& aplArkamysInputLevelDeviation) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AplArkamysInputLevelDeviationGet", aplArkamysInputLevelDeviation->getAct());
    sendAplArkamysInputLevelDeviationGetUpdate(_aplArkamysInputLevelDeviationProperty.getAplArkamysInputLevelDeviation(), aplArkamysInputLevelDeviation->getAct());
}

void ServiceStub::sendAplArkamysInputLevelDeviationGetUpdate(int32 aplArkamysInputLevelDeviation, act_t act) {
    ::asf::dbus::DBusVariant variant;
    AplArkamysInputLevelDeviationGet payload(aplArkamysInputLevelDeviation);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AplArkamysInputLevelDeviationGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::onAplArkamysInputLevelDeviationSet(const ::boost::shared_ptr< AplArkamysInputLevelDeviationSet >& aplArkamysInputLevelDeviation) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AplArkamysInputLevelDeviationSet", aplArkamysInputLevelDeviation->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*aplArkamysInputLevelDeviation, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setAplArkamysInputLevelDeviation (aplArkamysInputLevelDeviation->getAplArkamysInputLevelDeviation());
    sendAplArkamysInputLevelDeviationSetUpdate(aplArkamysInputLevelDeviation->getAct());
}

void ServiceStub::sendAplArkamysInputLevelDeviationSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AplArkamysInputLevelDeviationSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void ServiceStub::setAplArkamysInputLevelDeviation(int32 aplArkamysInputLevelDeviation) {
    if(aplArkamysInputLevelDeviation!=_aplArkamysInputLevelDeviationProperty.getAplArkamysInputLevelDeviation()) {
        _aplArkamysInputLevelDeviationProperty.setAplArkamysInputLevelDeviation(aplArkamysInputLevelDeviation);
        sendAplArkamysInputLevelDeviationUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

int32 ServiceStub::getAplArkamysInputLevelDeviation() const {
    return _aplArkamysInputLevelDeviationProperty.getAplArkamysInputLevelDeviation();
}

void ServiceStub::sendAplArkamysCurrentSpeedUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        AplArkamysCurrentSpeedUpdate payload(_aplArkamysCurrentSpeedProperty);

        LOG_INFO ("-> send%s", "AplArkamysCurrentSpeedUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("aplArkamysCurrentSpeed", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.audproc.service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "AplArkamysCurrentSpeedUpdate");
    }
}

void ServiceStub::onAplArkamysCurrentSpeedGet(const ::boost::shared_ptr< AplArkamysCurrentSpeedGet >& aplArkamysCurrentSpeed) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AplArkamysCurrentSpeedGet", aplArkamysCurrentSpeed->getAct());
    sendAplArkamysCurrentSpeedGetUpdate(_aplArkamysCurrentSpeedProperty.getAplArkamysCurrentSpeed(), aplArkamysCurrentSpeed->getAct());
}

void ServiceStub::sendAplArkamysCurrentSpeedGetUpdate(int32 aplArkamysCurrentSpeed, act_t act) {
    ::asf::dbus::DBusVariant variant;
    AplArkamysCurrentSpeedGet payload(aplArkamysCurrentSpeed);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AplArkamysCurrentSpeedGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::onAplArkamysCurrentSpeedSet(const ::boost::shared_ptr< AplArkamysCurrentSpeedSet >& aplArkamysCurrentSpeed) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AplArkamysCurrentSpeedSet", aplArkamysCurrentSpeed->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*aplArkamysCurrentSpeed, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setAplArkamysCurrentSpeed (aplArkamysCurrentSpeed->getAplArkamysCurrentSpeed());
    sendAplArkamysCurrentSpeedSetUpdate(aplArkamysCurrentSpeed->getAct());
}

void ServiceStub::sendAplArkamysCurrentSpeedSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AplArkamysCurrentSpeedSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void ServiceStub::setAplArkamysCurrentSpeed(int32 aplArkamysCurrentSpeed) {
    if(aplArkamysCurrentSpeed!=_aplArkamysCurrentSpeedProperty.getAplArkamysCurrentSpeed()) {
        _aplArkamysCurrentSpeedProperty.setAplArkamysCurrentSpeed(aplArkamysCurrentSpeed);
        sendAplArkamysCurrentSpeedUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

int32 ServiceStub::getAplArkamysCurrentSpeed() const {
    return _aplArkamysCurrentSpeedProperty.getAplArkamysCurrentSpeed();
}

void ServiceStub::sendAplArkamysCurrentVolumeStepUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        AplArkamysCurrentVolumeStepUpdate payload(_aplArkamysCurrentVolumeStepProperty);

        LOG_INFO ("-> send%s", "AplArkamysCurrentVolumeStepUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("aplArkamysCurrentVolumeStep", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.audproc.service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "AplArkamysCurrentVolumeStepUpdate");
    }
}

void ServiceStub::onAplArkamysCurrentVolumeStepGet(const ::boost::shared_ptr< AplArkamysCurrentVolumeStepGet >& aplArkamysCurrentVolumeStep) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AplArkamysCurrentVolumeStepGet", aplArkamysCurrentVolumeStep->getAct());
    sendAplArkamysCurrentVolumeStepGetUpdate(_aplArkamysCurrentVolumeStepProperty.getAplArkamysCurrentVolumeStep(), aplArkamysCurrentVolumeStep->getAct());
}

void ServiceStub::sendAplArkamysCurrentVolumeStepGetUpdate(int32 aplArkamysCurrentVolumeStep, act_t act) {
    ::asf::dbus::DBusVariant variant;
    AplArkamysCurrentVolumeStepGet payload(aplArkamysCurrentVolumeStep);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AplArkamysCurrentVolumeStepGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::onAplArkamysCurrentVolumeStepSet(const ::boost::shared_ptr< AplArkamysCurrentVolumeStepSet >& aplArkamysCurrentVolumeStep) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AplArkamysCurrentVolumeStepSet", aplArkamysCurrentVolumeStep->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*aplArkamysCurrentVolumeStep, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setAplArkamysCurrentVolumeStep (aplArkamysCurrentVolumeStep->getAplArkamysCurrentVolumeStep());
    sendAplArkamysCurrentVolumeStepSetUpdate(aplArkamysCurrentVolumeStep->getAct());
}

void ServiceStub::sendAplArkamysCurrentVolumeStepSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AplArkamysCurrentVolumeStepSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void ServiceStub::setAplArkamysCurrentVolumeStep(int32 aplArkamysCurrentVolumeStep) {
    if(aplArkamysCurrentVolumeStep!=_aplArkamysCurrentVolumeStepProperty.getAplArkamysCurrentVolumeStep()) {
        _aplArkamysCurrentVolumeStepProperty.setAplArkamysCurrentVolumeStep(aplArkamysCurrentVolumeStep);
        sendAplArkamysCurrentVolumeStepUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

int32 ServiceStub::getAplArkamysCurrentVolumeStep() const {
    return _aplArkamysCurrentVolumeStepProperty.getAplArkamysCurrentVolumeStep();
}

void ServiceStub::sendAplArkamysAmbienceSelectUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        AplArkamysAmbienceSelectUpdate payload(_aplArkamysAmbienceSelectProperty);

        LOG_INFO ("-> send%s", "AplArkamysAmbienceSelectUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("aplArkamysAmbienceSelect", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.audproc.service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "AplArkamysAmbienceSelectUpdate");
    }
}

void ServiceStub::onAplArkamysAmbienceSelectGet(const ::boost::shared_ptr< AplArkamysAmbienceSelectGet >& aplArkamysAmbienceSelect) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AplArkamysAmbienceSelectGet", aplArkamysAmbienceSelect->getAct());
    sendAplArkamysAmbienceSelectGetUpdate(_aplArkamysAmbienceSelectProperty.getAplArkamysAmbienceSelect(), aplArkamysAmbienceSelect->getAct());
}

void ServiceStub::sendAplArkamysAmbienceSelectGetUpdate(int32 aplArkamysAmbienceSelect, act_t act) {
    ::asf::dbus::DBusVariant variant;
    AplArkamysAmbienceSelectGet payload(aplArkamysAmbienceSelect);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AplArkamysAmbienceSelectGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::onAplArkamysAmbienceSelectSet(const ::boost::shared_ptr< AplArkamysAmbienceSelectSet >& aplArkamysAmbienceSelect) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AplArkamysAmbienceSelectSet", aplArkamysAmbienceSelect->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*aplArkamysAmbienceSelect, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setAplArkamysAmbienceSelect (aplArkamysAmbienceSelect->getAplArkamysAmbienceSelect());
    sendAplArkamysAmbienceSelectSetUpdate(aplArkamysAmbienceSelect->getAct());
}

void ServiceStub::sendAplArkamysAmbienceSelectSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AplArkamysAmbienceSelectSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void ServiceStub::setAplArkamysAmbienceSelect(int32 aplArkamysAmbienceSelect) {
    if(aplArkamysAmbienceSelect!=_aplArkamysAmbienceSelectProperty.getAplArkamysAmbienceSelect()) {
        _aplArkamysAmbienceSelectProperty.setAplArkamysAmbienceSelect(aplArkamysAmbienceSelect);
        sendAplArkamysAmbienceSelectUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

int32 ServiceStub::getAplArkamysAmbienceSelect() const {
    return _aplArkamysAmbienceSelectProperty.getAplArkamysAmbienceSelect();
}

void ServiceStub::sendAplArkamysLevelLossUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        AplArkamysLevelLossUpdate payload(_aplArkamysLevelLossProperty);

        LOG_INFO ("-> send%s", "AplArkamysLevelLossUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("aplArkamysLevelLoss", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.audproc.service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "AplArkamysLevelLossUpdate");
    }
}

void ServiceStub::onAplArkamysLevelLossGet(const ::boost::shared_ptr< AplArkamysLevelLossGet >& aplArkamysLevelLoss) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AplArkamysLevelLossGet", aplArkamysLevelLoss->getAct());
    sendAplArkamysLevelLossGetUpdate(_aplArkamysLevelLossProperty.getAplArkamysLevelLoss(), aplArkamysLevelLoss->getAct());
}

void ServiceStub::sendAplArkamysLevelLossGetUpdate(int32 aplArkamysLevelLoss, act_t act) {
    ::asf::dbus::DBusVariant variant;
    AplArkamysLevelLossGet payload(aplArkamysLevelLoss);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AplArkamysLevelLossGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::onAplArkamysLevelLossSet(const ::boost::shared_ptr< AplArkamysLevelLossSet >& aplArkamysLevelLoss) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AplArkamysLevelLossSet", aplArkamysLevelLoss->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*aplArkamysLevelLoss, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setAplArkamysLevelLoss (aplArkamysLevelLoss->getAplArkamysLevelLoss());
    sendAplArkamysLevelLossSetUpdate(aplArkamysLevelLoss->getAct());
}

void ServiceStub::sendAplArkamysLevelLossSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AplArkamysLevelLossSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void ServiceStub::setAplArkamysLevelLoss(int32 aplArkamysLevelLoss) {
    if(aplArkamysLevelLoss!=_aplArkamysLevelLossProperty.getAplArkamysLevelLoss()) {
        _aplArkamysLevelLossProperty.setAplArkamysLevelLoss(aplArkamysLevelLoss);
        sendAplArkamysLevelLossUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

int32 ServiceStub::getAplArkamysLevelLoss() const {
    return _aplArkamysLevelLossProperty.getAplArkamysLevelLoss();
}

void ServiceStub::sendAplArkamysLibraryVersionUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        AplArkamysLibraryVersionUpdate payload(_aplArkamysLibraryVersionProperty);

        LOG_INFO ("-> send%s", "AplArkamysLibraryVersionUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("aplArkamysLibraryVersion", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.audproc.service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "AplArkamysLibraryVersionUpdate");
    }
}

void ServiceStub::onAplArkamysLibraryVersionGet(const ::boost::shared_ptr< AplArkamysLibraryVersionGet >& aplArkamysLibraryVersion) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AplArkamysLibraryVersionGet", aplArkamysLibraryVersion->getAct());
    sendAplArkamysLibraryVersionGetUpdate(_aplArkamysLibraryVersionProperty.getAplArkamysLibraryVersion(), aplArkamysLibraryVersion->getAct());
}

void ServiceStub::sendAplArkamysLibraryVersionGetUpdate(const ::std::vector< int32 >& aplArkamysLibraryVersion, act_t act) {
    ::asf::dbus::DBusVariant variant;
    AplArkamysLibraryVersionGet payload(aplArkamysLibraryVersion);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AplArkamysLibraryVersionGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::onAplArkamysLibraryVersionSet(const ::boost::shared_ptr< AplArkamysLibraryVersionSet >& aplArkamysLibraryVersion) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AplArkamysLibraryVersionSet", aplArkamysLibraryVersion->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*aplArkamysLibraryVersion, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setAplArkamysLibraryVersion (aplArkamysLibraryVersion->getAplArkamysLibraryVersion());
    sendAplArkamysLibraryVersionSetUpdate(aplArkamysLibraryVersion->getAct());
}

void ServiceStub::sendAplArkamysLibraryVersionSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AplArkamysLibraryVersionSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void ServiceStub::setAplArkamysLibraryVersion(const ::std::vector< int32 >& aplArkamysLibraryVersion) {
    if(aplArkamysLibraryVersion!=_aplArkamysLibraryVersionProperty.getAplArkamysLibraryVersion()) {
        _aplArkamysLibraryVersionProperty.setAplArkamysLibraryVersion(aplArkamysLibraryVersion);
        sendAplArkamysLibraryVersionUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< int32 >& ServiceStub::getAplArkamysLibraryVersion() const {
    return _aplArkamysLibraryVersionProperty.getAplArkamysLibraryVersion();
}

::std::vector< int32 >& ServiceStub::getAplArkamysLibraryVersionMutable() {
    return _aplArkamysLibraryVersionProperty.getAplArkamysLibraryVersionMutable();
}

void ServiceStub::sendAplArkamysCurrVolAttenuationUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        AplArkamysCurrVolAttenuationUpdate payload(_aplArkamysCurrVolAttenuationProperty);

        LOG_INFO ("-> send%s", "AplArkamysCurrVolAttenuationUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("aplArkamysCurrVolAttenuation", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.audproc.service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "AplArkamysCurrVolAttenuationUpdate");
    }
}

void ServiceStub::onAplArkamysCurrVolAttenuationGet(const ::boost::shared_ptr< AplArkamysCurrVolAttenuationGet >& aplArkamysCurrVolAttenuation) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AplArkamysCurrVolAttenuationGet", aplArkamysCurrVolAttenuation->getAct());
    sendAplArkamysCurrVolAttenuationGetUpdate(_aplArkamysCurrVolAttenuationProperty.getAplArkamysCurrVolAttenuation(), aplArkamysCurrVolAttenuation->getAct());
}

void ServiceStub::sendAplArkamysCurrVolAttenuationGetUpdate(int32 aplArkamysCurrVolAttenuation, act_t act) {
    ::asf::dbus::DBusVariant variant;
    AplArkamysCurrVolAttenuationGet payload(aplArkamysCurrVolAttenuation);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AplArkamysCurrVolAttenuationGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::onAplArkamysCurrVolAttenuationSet(const ::boost::shared_ptr< AplArkamysCurrVolAttenuationSet >& aplArkamysCurrVolAttenuation) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AplArkamysCurrVolAttenuationSet", aplArkamysCurrVolAttenuation->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*aplArkamysCurrVolAttenuation, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setAplArkamysCurrVolAttenuation (aplArkamysCurrVolAttenuation->getAplArkamysCurrVolAttenuation());
    sendAplArkamysCurrVolAttenuationSetUpdate(aplArkamysCurrVolAttenuation->getAct());
}

void ServiceStub::sendAplArkamysCurrVolAttenuationSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AplArkamysCurrVolAttenuationSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void ServiceStub::setAplArkamysCurrVolAttenuation(int32 aplArkamysCurrVolAttenuation) {
    if(aplArkamysCurrVolAttenuation!=_aplArkamysCurrVolAttenuationProperty.getAplArkamysCurrVolAttenuation()) {
        _aplArkamysCurrVolAttenuationProperty.setAplArkamysCurrVolAttenuation(aplArkamysCurrVolAttenuation);
        sendAplArkamysCurrVolAttenuationUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

int32 ServiceStub::getAplArkamysCurrVolAttenuation() const {
    return _aplArkamysCurrVolAttenuationProperty.getAplArkamysCurrVolAttenuation();
}

void ServiceStub::sendAplArkamysFlushUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        AplArkamysFlushUpdate payload(_aplArkamysFlushProperty);

        LOG_INFO ("-> send%s", "AplArkamysFlushUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("aplArkamysFlush", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.audproc.service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "AplArkamysFlushUpdate");
    }
}

void ServiceStub::onAplArkamysFlushGet(const ::boost::shared_ptr< AplArkamysFlushGet >& aplArkamysFlush) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AplArkamysFlushGet", aplArkamysFlush->getAct());
    sendAplArkamysFlushGetUpdate(_aplArkamysFlushProperty.getAplArkamysFlush(), aplArkamysFlush->getAct());
}

void ServiceStub::sendAplArkamysFlushGetUpdate(int32 aplArkamysFlush, act_t act) {
    ::asf::dbus::DBusVariant variant;
    AplArkamysFlushGet payload(aplArkamysFlush);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AplArkamysFlushGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::onAplArkamysFlushSet(const ::boost::shared_ptr< AplArkamysFlushSet >& aplArkamysFlush) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AplArkamysFlushSet", aplArkamysFlush->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*aplArkamysFlush, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setAplArkamysFlush (aplArkamysFlush->getAplArkamysFlush());
    sendAplArkamysFlushSetUpdate(aplArkamysFlush->getAct());
}

void ServiceStub::sendAplArkamysFlushSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AplArkamysFlushSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void ServiceStub::setAplArkamysFlush(int32 aplArkamysFlush) {
    if(aplArkamysFlush!=_aplArkamysFlushProperty.getAplArkamysFlush()) {
        _aplArkamysFlushProperty.setAplArkamysFlush(aplArkamysFlush);
        sendAplArkamysFlushUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

int32 ServiceStub::getAplArkamysFlush() const {
    return _aplArkamysFlushProperty.getAplArkamysFlush();
}

void ServiceStub::sendAplMicLvlWatchRefIntUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        AplMicLvlWatchRefIntUpdate payload(_aplMicLvlWatchRefIntProperty);

        LOG_INFO ("-> send%s", "AplMicLvlWatchRefIntUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("aplMicLvlWatchRefInt", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.audproc.service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "AplMicLvlWatchRefIntUpdate");
    }
}

void ServiceStub::onAplMicLvlWatchRefIntGet(const ::boost::shared_ptr< AplMicLvlWatchRefIntGet >& aplMicLvlWatchRefInt) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AplMicLvlWatchRefIntGet", aplMicLvlWatchRefInt->getAct());
    sendAplMicLvlWatchRefIntGetUpdate(_aplMicLvlWatchRefIntProperty.getAplMicLvlWatchRefInt(), aplMicLvlWatchRefInt->getAct());
}

void ServiceStub::sendAplMicLvlWatchRefIntGetUpdate(uint32 aplMicLvlWatchRefInt, act_t act) {
    ::asf::dbus::DBusVariant variant;
    AplMicLvlWatchRefIntGet payload(aplMicLvlWatchRefInt);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AplMicLvlWatchRefIntGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::onAplMicLvlWatchRefIntSet(const ::boost::shared_ptr< AplMicLvlWatchRefIntSet >& aplMicLvlWatchRefInt) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AplMicLvlWatchRefIntSet", aplMicLvlWatchRefInt->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*aplMicLvlWatchRefInt, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setAplMicLvlWatchRefInt (aplMicLvlWatchRefInt->getAplMicLvlWatchRefInt());
    sendAplMicLvlWatchRefIntSetUpdate(aplMicLvlWatchRefInt->getAct());
}

void ServiceStub::sendAplMicLvlWatchRefIntSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AplMicLvlWatchRefIntSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void ServiceStub::setAplMicLvlWatchRefInt(uint32 aplMicLvlWatchRefInt) {
    if(aplMicLvlWatchRefInt!=_aplMicLvlWatchRefIntProperty.getAplMicLvlWatchRefInt()) {
        _aplMicLvlWatchRefIntProperty.setAplMicLvlWatchRefInt(aplMicLvlWatchRefInt);
        sendAplMicLvlWatchRefIntUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint32 ServiceStub::getAplMicLvlWatchRefInt() const {
    return _aplMicLvlWatchRefIntProperty.getAplMicLvlWatchRefInt();
}

void ServiceStub::sendAplMicLvlUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        AplMicLvlUpdate payload(_aplMicLvlProperty);

        LOG_INFO ("-> send%s", "AplMicLvlUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("aplMicLvl", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.audproc.service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "AplMicLvlUpdate");
    }
}

void ServiceStub::onAplMicLvlGet(const ::boost::shared_ptr< AplMicLvlGet >& aplMicLvl) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AplMicLvlGet", aplMicLvl->getAct());
    sendAplMicLvlGetUpdate(_aplMicLvlProperty.getAplMicLvl(), aplMicLvl->getAct());
}

void ServiceStub::sendAplMicLvlGetUpdate(int32 aplMicLvl, act_t act) {
    ::asf::dbus::DBusVariant variant;
    AplMicLvlGet payload(aplMicLvl);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AplMicLvlGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::onAplMicLvlSet(const ::boost::shared_ptr< AplMicLvlSet >& aplMicLvl) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AplMicLvlSet", aplMicLvl->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*aplMicLvl, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setAplMicLvl (aplMicLvl->getAplMicLvl());
    sendAplMicLvlSetUpdate(aplMicLvl->getAct());
}

void ServiceStub::sendAplMicLvlSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AplMicLvlSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void ServiceStub::setAplMicLvl(int32 aplMicLvl) {
    if(aplMicLvl!=_aplMicLvlProperty.getAplMicLvl()) {
        _aplMicLvlProperty.setAplMicLvl(aplMicLvl);
        sendAplMicLvlUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

int32 ServiceStub::getAplMicLvl() const {
    return _aplMicLvlProperty.getAplMicLvl();
}

void ServiceStub::sendAplAudioModeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        AplAudioModeUpdate payload(_aplAudioModeProperty);

        LOG_INFO ("-> send%s", "AplAudioModeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("aplAudioMode", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.audproc.service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "AplAudioModeUpdate");
    }
}

void ServiceStub::onAplAudioModeGet(const ::boost::shared_ptr< AplAudioModeGet >& aplAudioMode) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AplAudioModeGet", aplAudioMode->getAct());
    sendAplAudioModeGetUpdate(_aplAudioModeProperty.getAplAudioMode(), aplAudioMode->getAct());
}

void ServiceStub::sendAplAudioModeGetUpdate(int32 aplAudioMode, act_t act) {
    ::asf::dbus::DBusVariant variant;
    AplAudioModeGet payload(aplAudioMode);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AplAudioModeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::onAplAudioModeSet(const ::boost::shared_ptr< AplAudioModeSet >& aplAudioMode) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AplAudioModeSet", aplAudioMode->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*aplAudioMode, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setAplAudioMode (aplAudioMode->getAplAudioMode());
    sendAplAudioModeSetUpdate(aplAudioMode->getAct());
}

void ServiceStub::sendAplAudioModeSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AplAudioModeSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void ServiceStub::setAplAudioMode(int32 aplAudioMode) {
    if(aplAudioMode!=_aplAudioModeProperty.getAplAudioMode()) {
        _aplAudioModeProperty.setAplAudioMode(aplAudioMode);
        sendAplAudioModeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

int32 ServiceStub::getAplAudioMode() const {
    return _aplAudioModeProperty.getAplAudioMode();
}

void ServiceStub::sendAplLoopbackActivateUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        AplLoopbackActivateUpdate payload(_aplLoopbackActivateProperty);

        LOG_INFO ("-> send%s", "AplLoopbackActivateUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("aplLoopbackActivate", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.audproc.service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "AplLoopbackActivateUpdate");
    }
}

void ServiceStub::onAplLoopbackActivateGet(const ::boost::shared_ptr< AplLoopbackActivateGet >& aplLoopbackActivate) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AplLoopbackActivateGet", aplLoopbackActivate->getAct());
    sendAplLoopbackActivateGetUpdate(_aplLoopbackActivateProperty.getAplLoopbackActivate(), aplLoopbackActivate->getAct());
}

void ServiceStub::sendAplLoopbackActivateGetUpdate(int32 aplLoopbackActivate, act_t act) {
    ::asf::dbus::DBusVariant variant;
    AplLoopbackActivateGet payload(aplLoopbackActivate);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AplLoopbackActivateGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::onAplLoopbackActivateSet(const ::boost::shared_ptr< AplLoopbackActivateSet >& aplLoopbackActivate) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AplLoopbackActivateSet", aplLoopbackActivate->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*aplLoopbackActivate, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setAplLoopbackActivate (aplLoopbackActivate->getAplLoopbackActivate());
    sendAplLoopbackActivateSetUpdate(aplLoopbackActivate->getAct());
}

void ServiceStub::sendAplLoopbackActivateSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AplLoopbackActivateSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void ServiceStub::setAplLoopbackActivate(int32 aplLoopbackActivate) {
    if(aplLoopbackActivate!=_aplLoopbackActivateProperty.getAplLoopbackActivate()) {
        _aplLoopbackActivateProperty.setAplLoopbackActivate(aplLoopbackActivate);
        sendAplLoopbackActivateUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

int32 ServiceStub::getAplLoopbackActivate() const {
    return _aplLoopbackActivateProperty.getAplLoopbackActivate();
}

void  ServiceStub::sendAudprocGetVersionResponse (const ::std::vector< uint32 >& version, const ::std::string& versionString, const ::std::string& versionComment, act_t act) {
    AudprocGetVersionResponse* payload = new AudprocGetVersionResponse(version, versionString, versionComment);
    DBUS_MESSAGE_REPLY(dbusMessage, "AudprocGetVersion", AudprocGetVersionResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "AudprocGetVersion", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendAudprocGetVersionError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    AudprocGetVersionError* payload = new AudprocGetVersionError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "AudprocGetVersion", AudprocGetVersionError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "AudprocGetVersion", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendAudprocGetStatusResponse (act_t act) {
    AudprocGetStatusResponse* payload = new AudprocGetStatusResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "AudprocGetStatus", AudprocGetStatusResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "AudprocGetStatus", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendAudprocGetStatusError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    AudprocGetStatusError* payload = new AudprocGetStatusError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "AudprocGetStatus", AudprocGetStatusError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "AudprocGetStatus", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendAudprocTerminateResponse (act_t act) {
    AudprocTerminateResponse* payload = new AudprocTerminateResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "AudprocTerminate", AudprocTerminateResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "AudprocTerminate", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendAudprocTerminateError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    AudprocTerminateError* payload = new AudprocTerminateError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "AudprocTerminate", AudprocTerminateError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "AudprocTerminate", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendAudprocSetupDebugResponse (act_t act) {
    AudprocSetupDebugResponse* payload = new AudprocSetupDebugResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "AudprocSetupDebug", AudprocSetupDebugResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "AudprocSetupDebug", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendAudprocSetupDebugError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    AudprocSetupDebugError* payload = new AudprocSetupDebugError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "AudprocSetupDebug", AudprocSetupDebugError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "AudprocSetupDebug", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendAudprocCreateResponse (act_t act) {
    AudprocCreateResponse* payload = new AudprocCreateResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "AudprocCreate", AudprocCreateResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "AudprocCreate", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendAudprocCreateError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    AudprocCreateError* payload = new AudprocCreateError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "AudprocCreate", AudprocCreateError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "AudprocCreate", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendAudprocInitializeResponse (act_t act) {
    AudprocInitializeResponse* payload = new AudprocInitializeResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "AudprocInitialize", AudprocInitializeResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "AudprocInitialize", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendAudprocInitializeError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    AudprocInitializeError* payload = new AudprocInitializeError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "AudprocInitialize", AudprocInitializeError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "AudprocInitialize", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendAudprocSetConfigurationResponse (act_t act) {
    AudprocSetConfigurationResponse* payload = new AudprocSetConfigurationResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "AudprocSetConfiguration", AudprocSetConfigurationResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "AudprocSetConfiguration", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendAudprocSetConfigurationError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    AudprocSetConfigurationError* payload = new AudprocSetConfigurationError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "AudprocSetConfiguration", AudprocSetConfigurationError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "AudprocSetConfiguration", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendAudprocDestroyResponse (act_t act) {
    AudprocDestroyResponse* payload = new AudprocDestroyResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "AudprocDestroy", AudprocDestroyResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "AudprocDestroy", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendAudprocDestroyError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    AudprocDestroyError* payload = new AudprocDestroyError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "AudprocDestroy", AudprocDestroyError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "AudprocDestroy", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendAudprocSetParamResponse (act_t act) {
    AudprocSetParamResponse* payload = new AudprocSetParamResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "AudprocSetParam", AudprocSetParamResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "AudprocSetParam", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendAudprocSetParamError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    AudprocSetParamError* payload = new AudprocSetParamError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "AudprocSetParam", AudprocSetParamError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "AudprocSetParam", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendAudprocWriteDataResponse (const ::std::vector< uint8 >& result, act_t act) {
    AudprocWriteDataResponse* payload = new AudprocWriteDataResponse(result);
    DBUS_MESSAGE_REPLY(dbusMessage, "AudprocWriteData", AudprocWriteDataResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "AudprocWriteData", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendAudprocWriteDataError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    AudprocWriteDataError* payload = new AudprocWriteDataError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "AudprocWriteData", AudprocWriteDataError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "AudprocWriteData", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendAudprocReadDataResponse (const ::std::vector< uint8 >& data, act_t act) {
    AudprocReadDataResponse* payload = new AudprocReadDataResponse(data);
    DBUS_MESSAGE_REPLY(dbusMessage, "AudprocReadData", AudprocReadDataResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "AudprocReadData", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendAudprocReadDataError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    AudprocReadDataError* payload = new AudprocReadDataError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "AudprocReadData", AudprocReadDataError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "AudprocReadData", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendAudprocGetAudprocConfigurationResponse (const ::std::string& datasetName, uint32 audprocProperties, act_t act) {
    AudprocGetAudprocConfigurationResponse* payload = new AudprocGetAudprocConfigurationResponse(datasetName, audprocProperties);
    DBUS_MESSAGE_REPLY(dbusMessage, "AudprocGetAudprocConfiguration", AudprocGetAudprocConfigurationResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "AudprocGetAudprocConfiguration", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendAudprocGetAudprocConfigurationError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    AudprocGetAudprocConfigurationError* payload = new AudprocGetAudprocConfigurationError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "AudprocGetAudprocConfiguration", AudprocGetAudprocConfigurationError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "AudprocGetAudprocConfiguration", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendAudprocStartAudioResponse (act_t act) {
    AudprocStartAudioResponse* payload = new AudprocStartAudioResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "AudprocStartAudio", AudprocStartAudioResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "AudprocStartAudio", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendAudprocStartAudioError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    AudprocStartAudioError* payload = new AudprocStartAudioError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "AudprocStartAudio", AudprocStartAudioError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "AudprocStartAudio", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendAudprocStopAudioResponse (act_t act) {
    AudprocStopAudioResponse* payload = new AudprocStopAudioResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "AudprocStopAudio", AudprocStopAudioResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "AudprocStopAudio", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendAudprocStopAudioError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    AudprocStopAudioError* payload = new AudprocStopAudioError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "AudprocStopAudio", AudprocStopAudioError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "AudprocStopAudio", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendAudprocMuteResponse (act_t act) {
    AudprocMuteResponse* payload = new AudprocMuteResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "AudprocMute", AudprocMuteResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "AudprocMute", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendAudprocMuteError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    AudprocMuteError* payload = new AudprocMuteError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "AudprocMute", AudprocMuteError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "AudprocMute", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendAudprocSourceActivityResponse (act_t act) {
    AudprocSourceActivityResponse* payload = new AudprocSourceActivityResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "AudprocSourceActivity", AudprocSourceActivityResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "AudprocSourceActivity", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendAudprocSourceActivityError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    AudprocSourceActivityError* payload = new AudprocSourceActivityError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "AudprocSourceActivity", AudprocSourceActivityError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "AudprocSourceActivity", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendAudprocSourceSelectResponse (act_t act) {
    AudprocSourceSelectResponse* payload = new AudprocSourceSelectResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "AudprocSourceSelect", AudprocSourceSelectResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "AudprocSourceSelect", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendAudprocSourceSelectError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    AudprocSourceSelectError* payload = new AudprocSourceSelectError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "AudprocSourceSelect", AudprocSourceSelectError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "AudprocSourceSelect", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void ServiceStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'aplArkamysAvcActivate'
    {
        ::asf::dbus::DBusVariant variant;
        AplArkamysAvcActivateGet payload(_aplArkamysAvcActivateProperty.getAplArkamysAvcActivate());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("aplArkamysAvcActivate", variant));
    }

    //property 'aplArkamysByPassActivate'
    {
        ::asf::dbus::DBusVariant variant;
        AplArkamysByPassActivateGet payload(_aplArkamysByPassActivateProperty.getAplArkamysByPassActivate());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("aplArkamysByPassActivate", variant));
    }

    //property 'aplArkamysInputLevelDeviation'
    {
        ::asf::dbus::DBusVariant variant;
        AplArkamysInputLevelDeviationGet payload(_aplArkamysInputLevelDeviationProperty.getAplArkamysInputLevelDeviation());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("aplArkamysInputLevelDeviation", variant));
    }

    //property 'aplArkamysCurrentSpeed'
    {
        ::asf::dbus::DBusVariant variant;
        AplArkamysCurrentSpeedGet payload(_aplArkamysCurrentSpeedProperty.getAplArkamysCurrentSpeed());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("aplArkamysCurrentSpeed", variant));
    }

    //property 'aplArkamysCurrentVolumeStep'
    {
        ::asf::dbus::DBusVariant variant;
        AplArkamysCurrentVolumeStepGet payload(_aplArkamysCurrentVolumeStepProperty.getAplArkamysCurrentVolumeStep());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("aplArkamysCurrentVolumeStep", variant));
    }

    //property 'aplArkamysAmbienceSelect'
    {
        ::asf::dbus::DBusVariant variant;
        AplArkamysAmbienceSelectGet payload(_aplArkamysAmbienceSelectProperty.getAplArkamysAmbienceSelect());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("aplArkamysAmbienceSelect", variant));
    }

    //property 'aplArkamysLevelLoss'
    {
        ::asf::dbus::DBusVariant variant;
        AplArkamysLevelLossGet payload(_aplArkamysLevelLossProperty.getAplArkamysLevelLoss());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("aplArkamysLevelLoss", variant));
    }

    //property 'aplArkamysLibraryVersion'
    {
        ::asf::dbus::DBusVariant variant;
        AplArkamysLibraryVersionGet payload(_aplArkamysLibraryVersionProperty.getAplArkamysLibraryVersion());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("aplArkamysLibraryVersion", variant));
    }

    //property 'aplArkamysCurrVolAttenuation'
    {
        ::asf::dbus::DBusVariant variant;
        AplArkamysCurrVolAttenuationGet payload(_aplArkamysCurrVolAttenuationProperty.getAplArkamysCurrVolAttenuation());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("aplArkamysCurrVolAttenuation", variant));
    }

    //property 'aplArkamysFlush'
    {
        ::asf::dbus::DBusVariant variant;
        AplArkamysFlushGet payload(_aplArkamysFlushProperty.getAplArkamysFlush());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("aplArkamysFlush", variant));
    }

    //property 'aplMicLvlWatchRefInt'
    {
        ::asf::dbus::DBusVariant variant;
        AplMicLvlWatchRefIntGet payload(_aplMicLvlWatchRefIntProperty.getAplMicLvlWatchRefInt());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("aplMicLvlWatchRefInt", variant));
    }

    //property 'aplMicLvl'
    {
        ::asf::dbus::DBusVariant variant;
        AplMicLvlGet payload(_aplMicLvlProperty.getAplMicLvl());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("aplMicLvl", variant));
    }

    //property 'aplAudioMode'
    {
        ::asf::dbus::DBusVariant variant;
        AplAudioModeGet payload(_aplAudioModeProperty.getAplAudioMode());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("aplAudioMode", variant));
    }

    //property 'aplLoopbackActivate'
    {
        ::asf::dbus::DBusVariant variant;
        AplLoopbackActivateGet payload(_aplLoopbackActivateProperty.getAplLoopbackActivate());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("aplLoopbackActivate", variant));
    }
}

} // namespace service
} // namespace audproc
} // namespace bosch
} // namespace org
