#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef MOST_PHONBK_FI_TYPES_H
#define MOST_PHONBK_FI_TYPES_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "fi_basetypes_most.h"
#include "most_PhonBk_fi_typesConst.h"
#include <cstring>
#include <vector>

/**
 * Types most_PhonBk_fi_types
 */

namespace most_PhonBk_fi_types {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class T_PhonBkSearchKeyboardListItem;

class T_PhonBkHomeAddressLatLong;

class T_PhonBkWorkAddressLatLong;

class T_PhonBkOtherAddressLatLong;

class T_PhonBkContactDetails;

class T_PhonBkCallDate;

class T_PhonBkCallTime;

class T_PhonBkCallDateTime;

class T_PhonBkCallHistoryListSliceResultItem;

class T_PhonBkCallHistoryTypeSupport;

class T_PhonBkAutocompleteMultipleMatchListItem;

class T_PhonBkPhoneBookListSliceResultItem;

class T_PhonBkDownloadStateStreamItem;

// type definitions
/**
 * If the meaning of "T_PhonBkSearchKeyboardList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_PhonBkSearchKeyboardListItem > T_PhonBkSearchKeyboardList;

/**
 * If the meaning of "T_PhonBkContactPhoto" isn't clear, then there should be a description here.
 */
typedef ::std::vector< uint8 > T_PhonBkContactPhoto;

/**
 * If the meaning of "T_PhonBkChangeItems" isn't clear, then there should be a description here.
 */
typedef ::std::vector< uint32 > T_PhonBkChangeItems;

/**
 * If the meaning of "T_PhonBkCallHistoryListSliceResult" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_PhonBkCallHistoryListSliceResultItem > T_PhonBkCallHistoryListSliceResult;

/**
 * If the meaning of "T_PhonBkAutocompleteMultipleMatchList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_PhonBkAutocompleteMultipleMatchListItem > T_PhonBkAutocompleteMultipleMatchList;

/**
 * If the meaning of "T_PhonBkPhoneBookListSliceResult" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_PhonBkPhoneBookListSliceResultItem > T_PhonBkPhoneBookListSliceResult;

/**
 * If the meaning of "T_PhonBkDownloadStateStream" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_PhonBkDownloadStateStreamItem > T_PhonBkDownloadStateStream;


class T_PhonBkSearchKeyboardListItem {
public:

    /**
     * Default constructor
     */
    inline  T_PhonBkSearchKeyboardListItem ();

    /**
     * Copy constructor
     */
    inline  T_PhonBkSearchKeyboardListItem (const T_PhonBkSearchKeyboardListItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_PhonBkSearchKeyboardListItem (const ::fi_basetypes_most::T_String& sSearchKeyboardLetter_, bool bLetterAvailable_, uint32 u32LetterStartIndex_, uint32 u32LetterEndIndex_);

    /**
     * Destructor
     */
    inline  ~T_PhonBkSearchKeyboardListItem();

    /**
     * Assignment operator
     */
    inline T_PhonBkSearchKeyboardListItem& operator = (const T_PhonBkSearchKeyboardListItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_PhonBkSearchKeyboardListItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_PhonBkSearchKeyboardListItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_PhonBkSearchKeyboardListItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_PhonBkSearchKeyboardListItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sSearchKeyboardLetter"

    static const int kSSearchKeyboardLetter = 0;

    /**
     * Clears the field "sSearchKeyboardLetter".
     *
     * The field will be set to its default value. The hasSSearchKeyboardLetter()
     * method will return false.
     */
    inline void clearSSearchKeyboardLetter();

    /**
     * Checks whether the field "sSearchKeyboardLetter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSSearchKeyboardLetter()). Otherwise it will return false.
     */
    inline bool hasSSearchKeyboardLetter () const;

    /**
     * Returns the value of the member "sSearchKeyboardLetter".
     *
     * Letter of the alphabet.
     *
     * @return The value of the field "sSearchKeyboardLetter"
     */
    inline const ::fi_basetypes_most::T_String& getSSearchKeyboardLetter () const;

    /**
     * Retrieves the value of the field "sSearchKeyboardLetter" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sSearchKeyboardLetter".
     */
    inline ::fi_basetypes_most::T_String& getSSearchKeyboardLetterMutable ();

    /**
     * Sets the value of the member "sSearchKeyboardLetter".
     *
     * Letter of the alphabet.
     *
     * @param sSearchKeyboardLetter The value which will be set
     */
    inline void setSSearchKeyboardLetter (const ::fi_basetypes_most::T_String& sSearchKeyboardLetter_);

    // API of field "bLetterAvailable"

    static const int kBLetterAvailable = 1;

    /**
     * Clears the field "bLetterAvailable".
     *
     * The field will be set to its default value. The hasBLetterAvailable()
     * method will return false.
     */
    inline void clearBLetterAvailable();

    /**
     * Checks whether the field "bLetterAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBLetterAvailable()). Otherwise it will return false.
     */
    inline bool hasBLetterAvailable () const;

    /**
     * Returns the value of the member "bLetterAvailable".
     *
     * Identifies if the letter has any contacts associated with it.
     *
     * @return The value of the field "bLetterAvailable"
     */
    inline bool getBLetterAvailable () const;

    /**
     * Sets the value of the member "bLetterAvailable".
     *
     * Identifies if the letter has any contacts associated with it.
     *
     * @param bLetterAvailable The value which will be set
     */
    inline void setBLetterAvailable (bool bLetterAvailable_);

    // API of field "u32LetterStartIndex"

    static const int kU32LetterStartIndex = 2;

    /**
     * Clears the field "u32LetterStartIndex".
     *
     * The field will be set to its default value. The hasU32LetterStartIndex()
     * method will return false.
     */
    inline void clearU32LetterStartIndex();

    /**
     * Checks whether the field "u32LetterStartIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32LetterStartIndex()). Otherwise it will return false.
     */
    inline bool hasU32LetterStartIndex () const;

    /**
     * Returns the value of the member "u32LetterStartIndex".
     *
     * Specifies the index for the first contact that begins with the selected letter.
     *
     * @return The value of the field "u32LetterStartIndex"
     */
    inline uint32 getU32LetterStartIndex () const;

    /**
     * Sets the value of the member "u32LetterStartIndex".
     *
     * Specifies the index for the first contact that begins with the selected letter.
     *
     * @param u32LetterStartIndex The value which will be set
     */
    inline void setU32LetterStartIndex (uint32 u32LetterStartIndex_);

    // API of field "u32LetterEndIndex"

    static const int kU32LetterEndIndex = 3;

    /**
     * Clears the field "u32LetterEndIndex".
     *
     * The field will be set to its default value. The hasU32LetterEndIndex()
     * method will return false.
     */
    inline void clearU32LetterEndIndex();

    /**
     * Checks whether the field "u32LetterEndIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32LetterEndIndex()). Otherwise it will return false.
     */
    inline bool hasU32LetterEndIndex () const;

    /**
     * Returns the value of the member "u32LetterEndIndex".
     *
     * Specifies the index for the last contact that begins with the selected letter.
     *
     * @return The value of the field "u32LetterEndIndex"
     */
    inline uint32 getU32LetterEndIndex () const;

    /**
     * Sets the value of the member "u32LetterEndIndex".
     *
     * Specifies the index for the last contact that begins with the selected letter.
     *
     * @param u32LetterEndIndex The value which will be set
     */
    inline void setU32LetterEndIndex (uint32 u32LetterEndIndex_);

    static const T_PhonBkSearchKeyboardListItem &getDefaultInstance();

private:

    inline void set_has_sSearchKeyboardLetter ();

    inline void clear_has_sSearchKeyboardLetter ();

    inline void set_has_bLetterAvailable ();

    inline void clear_has_bLetterAvailable ();

    inline void set_has_u32LetterStartIndex ();

    inline void clear_has_u32LetterStartIndex ();

    inline void set_has_u32LetterEndIndex ();

    inline void clear_has_u32LetterEndIndex ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::fi_basetypes_most::T_String _sSearchKeyboardLetter;

    bool _bLetterAvailable;

    uint32 _u32LetterStartIndex;

    uint32 _u32LetterEndIndex;

};

class T_PhonBkHomeAddressLatLong {
public:

    /**
     * Default constructor
     */
    inline  T_PhonBkHomeAddressLatLong ();

    /**
     * Copy constructor
     */
    inline  T_PhonBkHomeAddressLatLong (const T_PhonBkHomeAddressLatLong &rhs);

    /**
     * All fields constructor
     */
    inline  T_PhonBkHomeAddressLatLong (bool bLatLongValidity_, int32 s32Latitude_, int32 s32Longitude_);

    /**
     * Destructor
     */
    inline  ~T_PhonBkHomeAddressLatLong();

    /**
     * Assignment operator
     */
    inline T_PhonBkHomeAddressLatLong& operator = (const T_PhonBkHomeAddressLatLong& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_PhonBkHomeAddressLatLong& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_PhonBkHomeAddressLatLong& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_PhonBkHomeAddressLatLong& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_PhonBkHomeAddressLatLong& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bLatLongValidity"

    static const int kBLatLongValidity = 0;

    /**
     * Clears the field "bLatLongValidity".
     *
     * The field will be set to its default value. The hasBLatLongValidity()
     * method will return false.
     */
    inline void clearBLatLongValidity();

    /**
     * Checks whether the field "bLatLongValidity" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBLatLongValidity()). Otherwise it will return false.
     */
    inline bool hasBLatLongValidity () const;

    /**
     * Returns the value of the member "bLatLongValidity".
     *
     * Validity flag for associated Latitude and Longitude parameters.  When this flag is True, the LatLong fields are valid, when this flag is False, both fields are invalid and should be ignored.
     *
     * @return The value of the field "bLatLongValidity"
     */
    inline bool getBLatLongValidity () const;

    /**
     * Sets the value of the member "bLatLongValidity".
     *
     * Validity flag for associated Latitude and Longitude parameters.  When this flag is True, the LatLong fields are valid, when this flag is False, both fields are invalid and should be ignored.
     *
     * @param bLatLongValidity The value which will be set
     */
    inline void setBLatLongValidity (bool bLatLongValidity_);

    // API of field "s32Latitude"

    static const int kS32Latitude = 1;

    /**
     * Clears the field "s32Latitude".
     *
     * The field will be set to its default value. The hasS32Latitude()
     * method will return false.
     */
    inline void clearS32Latitude();

    /**
     * Checks whether the field "s32Latitude" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32Latitude()). Otherwise it will return false.
     */
    inline bool hasS32Latitude () const;

    /**
     * Returns the value of the member "s32Latitude".
     *
     * Latitude for use in search requests and in the search response.  The encoding is in units of milliseconds of angle as follows:
     *
     * -536870912 to 536870911 ms arc
     *
     * @return The value of the field "s32Latitude"
     */
    inline int32 getS32Latitude () const;

    /**
     * Sets the value of the member "s32Latitude".
     *
     * Latitude for use in search requests and in the search response.  The encoding is in units of milliseconds of angle as follows:
     *
     * -536870912 to 536870911 ms arc
     *
     * @param s32Latitude The value which will be set
     */
    inline void setS32Latitude (int32 s32Latitude_);

    // API of field "s32Longitude"

    static const int kS32Longitude = 2;

    /**
     * Clears the field "s32Longitude".
     *
     * The field will be set to its default value. The hasS32Longitude()
     * method will return false.
     */
    inline void clearS32Longitude();

    /**
     * Checks whether the field "s32Longitude" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32Longitude()). Otherwise it will return false.
     */
    inline bool hasS32Longitude () const;

    /**
     * Returns the value of the member "s32Longitude".
     *
     * Longitude for use in search requests and in the search response.  The encoding is in units of milliseconds of angle as follows:
     *
     * -1073741824 - 1073741823 ms arc
     *
     * @return The value of the field "s32Longitude"
     */
    inline int32 getS32Longitude () const;

    /**
     * Sets the value of the member "s32Longitude".
     *
     * Longitude for use in search requests and in the search response.  The encoding is in units of milliseconds of angle as follows:
     *
     * -1073741824 - 1073741823 ms arc
     *
     * @param s32Longitude The value which will be set
     */
    inline void setS32Longitude (int32 s32Longitude_);

    static const T_PhonBkHomeAddressLatLong &getDefaultInstance();

private:

    inline void set_has_bLatLongValidity ();

    inline void clear_has_bLatLongValidity ();

    inline void set_has_s32Latitude ();

    inline void clear_has_s32Latitude ();

    inline void set_has_s32Longitude ();

    inline void clear_has_s32Longitude ();

    uint32 _has_bits_[ (3 + 31) / 32];

    bool _bLatLongValidity;

    int32 _s32Latitude;

    int32 _s32Longitude;

};

class T_PhonBkWorkAddressLatLong {
public:

    /**
     * Default constructor
     */
    inline  T_PhonBkWorkAddressLatLong ();

    /**
     * Copy constructor
     */
    inline  T_PhonBkWorkAddressLatLong (const T_PhonBkWorkAddressLatLong &rhs);

    /**
     * All fields constructor
     */
    inline  T_PhonBkWorkAddressLatLong (bool bLatLongValidity_, int32 s32Latitude_, int32 s32Longitude_);

    /**
     * Destructor
     */
    inline  ~T_PhonBkWorkAddressLatLong();

    /**
     * Assignment operator
     */
    inline T_PhonBkWorkAddressLatLong& operator = (const T_PhonBkWorkAddressLatLong& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_PhonBkWorkAddressLatLong& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_PhonBkWorkAddressLatLong& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_PhonBkWorkAddressLatLong& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_PhonBkWorkAddressLatLong& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bLatLongValidity"

    static const int kBLatLongValidity = 0;

    /**
     * Clears the field "bLatLongValidity".
     *
     * The field will be set to its default value. The hasBLatLongValidity()
     * method will return false.
     */
    inline void clearBLatLongValidity();

    /**
     * Checks whether the field "bLatLongValidity" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBLatLongValidity()). Otherwise it will return false.
     */
    inline bool hasBLatLongValidity () const;

    /**
     * Returns the value of the member "bLatLongValidity".
     *
     * Validity flag for associated Latitude and Longitude parameters.  When this flag is True, the LatLong fields are valid, when this flag is False, both fields are invalid and should be ignored.
     *
     * @return The value of the field "bLatLongValidity"
     */
    inline bool getBLatLongValidity () const;

    /**
     * Sets the value of the member "bLatLongValidity".
     *
     * Validity flag for associated Latitude and Longitude parameters.  When this flag is True, the LatLong fields are valid, when this flag is False, both fields are invalid and should be ignored.
     *
     * @param bLatLongValidity The value which will be set
     */
    inline void setBLatLongValidity (bool bLatLongValidity_);

    // API of field "s32Latitude"

    static const int kS32Latitude = 1;

    /**
     * Clears the field "s32Latitude".
     *
     * The field will be set to its default value. The hasS32Latitude()
     * method will return false.
     */
    inline void clearS32Latitude();

    /**
     * Checks whether the field "s32Latitude" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32Latitude()). Otherwise it will return false.
     */
    inline bool hasS32Latitude () const;

    /**
     * Returns the value of the member "s32Latitude".
     *
     * Latitude for use in search requests and in the search response.  The encoding is in units of milliseconds of angle as follows:
     *
     * -536870912 to 536870911 ms arc
     *
     * @return The value of the field "s32Latitude"
     */
    inline int32 getS32Latitude () const;

    /**
     * Sets the value of the member "s32Latitude".
     *
     * Latitude for use in search requests and in the search response.  The encoding is in units of milliseconds of angle as follows:
     *
     * -536870912 to 536870911 ms arc
     *
     * @param s32Latitude The value which will be set
     */
    inline void setS32Latitude (int32 s32Latitude_);

    // API of field "s32Longitude"

    static const int kS32Longitude = 2;

    /**
     * Clears the field "s32Longitude".
     *
     * The field will be set to its default value. The hasS32Longitude()
     * method will return false.
     */
    inline void clearS32Longitude();

    /**
     * Checks whether the field "s32Longitude" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32Longitude()). Otherwise it will return false.
     */
    inline bool hasS32Longitude () const;

    /**
     * Returns the value of the member "s32Longitude".
     *
     * Longitude for use in search requests and in the search response.  The encoding is in units of milliseconds of angle as follows:
     *
     * -1073741824 - 1073741823 ms arc
     *
     * @return The value of the field "s32Longitude"
     */
    inline int32 getS32Longitude () const;

    /**
     * Sets the value of the member "s32Longitude".
     *
     * Longitude for use in search requests and in the search response.  The encoding is in units of milliseconds of angle as follows:
     *
     * -1073741824 - 1073741823 ms arc
     *
     * @param s32Longitude The value which will be set
     */
    inline void setS32Longitude (int32 s32Longitude_);

    static const T_PhonBkWorkAddressLatLong &getDefaultInstance();

private:

    inline void set_has_bLatLongValidity ();

    inline void clear_has_bLatLongValidity ();

    inline void set_has_s32Latitude ();

    inline void clear_has_s32Latitude ();

    inline void set_has_s32Longitude ();

    inline void clear_has_s32Longitude ();

    uint32 _has_bits_[ (3 + 31) / 32];

    bool _bLatLongValidity;

    int32 _s32Latitude;

    int32 _s32Longitude;

};

class T_PhonBkOtherAddressLatLong {
public:

    /**
     * Default constructor
     */
    inline  T_PhonBkOtherAddressLatLong ();

    /**
     * Copy constructor
     */
    inline  T_PhonBkOtherAddressLatLong (const T_PhonBkOtherAddressLatLong &rhs);

    /**
     * All fields constructor
     */
    inline  T_PhonBkOtherAddressLatLong (bool bLatLongValidity_, int32 s32Latitude_, int32 s32Longitude_);

    /**
     * Destructor
     */
    inline  ~T_PhonBkOtherAddressLatLong();

    /**
     * Assignment operator
     */
    inline T_PhonBkOtherAddressLatLong& operator = (const T_PhonBkOtherAddressLatLong& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_PhonBkOtherAddressLatLong& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_PhonBkOtherAddressLatLong& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_PhonBkOtherAddressLatLong& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_PhonBkOtherAddressLatLong& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bLatLongValidity"

    static const int kBLatLongValidity = 0;

    /**
     * Clears the field "bLatLongValidity".
     *
     * The field will be set to its default value. The hasBLatLongValidity()
     * method will return false.
     */
    inline void clearBLatLongValidity();

    /**
     * Checks whether the field "bLatLongValidity" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBLatLongValidity()). Otherwise it will return false.
     */
    inline bool hasBLatLongValidity () const;

    /**
     * Returns the value of the member "bLatLongValidity".
     *
     * Validity flag for associated Latitude and Longitude parameters.  When this flag is True, the LatLong fields are valid, when this flag is False, both fields are invalid and should be ignored.
     *
     * @return The value of the field "bLatLongValidity"
     */
    inline bool getBLatLongValidity () const;

    /**
     * Sets the value of the member "bLatLongValidity".
     *
     * Validity flag for associated Latitude and Longitude parameters.  When this flag is True, the LatLong fields are valid, when this flag is False, both fields are invalid and should be ignored.
     *
     * @param bLatLongValidity The value which will be set
     */
    inline void setBLatLongValidity (bool bLatLongValidity_);

    // API of field "s32Latitude"

    static const int kS32Latitude = 1;

    /**
     * Clears the field "s32Latitude".
     *
     * The field will be set to its default value. The hasS32Latitude()
     * method will return false.
     */
    inline void clearS32Latitude();

    /**
     * Checks whether the field "s32Latitude" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32Latitude()). Otherwise it will return false.
     */
    inline bool hasS32Latitude () const;

    /**
     * Returns the value of the member "s32Latitude".
     *
     * Latitude for use in search requests and in the search response.  The encoding is in units of milliseconds of angle as follows:
     *
     * -536870912 to 536870911 ms arc
     *
     * @return The value of the field "s32Latitude"
     */
    inline int32 getS32Latitude () const;

    /**
     * Sets the value of the member "s32Latitude".
     *
     * Latitude for use in search requests and in the search response.  The encoding is in units of milliseconds of angle as follows:
     *
     * -536870912 to 536870911 ms arc
     *
     * @param s32Latitude The value which will be set
     */
    inline void setS32Latitude (int32 s32Latitude_);

    // API of field "s32Longitude"

    static const int kS32Longitude = 2;

    /**
     * Clears the field "s32Longitude".
     *
     * The field will be set to its default value. The hasS32Longitude()
     * method will return false.
     */
    inline void clearS32Longitude();

    /**
     * Checks whether the field "s32Longitude" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32Longitude()). Otherwise it will return false.
     */
    inline bool hasS32Longitude () const;

    /**
     * Returns the value of the member "s32Longitude".
     *
     * Longitude for use in search requests and in the search response.  The encoding is in units of milliseconds of angle as follows:
     *
     * -1073741824 - 1073741823 ms arc
     *
     * @return The value of the field "s32Longitude"
     */
    inline int32 getS32Longitude () const;

    /**
     * Sets the value of the member "s32Longitude".
     *
     * Longitude for use in search requests and in the search response.  The encoding is in units of milliseconds of angle as follows:
     *
     * -1073741824 - 1073741823 ms arc
     *
     * @param s32Longitude The value which will be set
     */
    inline void setS32Longitude (int32 s32Longitude_);

    static const T_PhonBkOtherAddressLatLong &getDefaultInstance();

private:

    inline void set_has_bLatLongValidity ();

    inline void clear_has_bLatLongValidity ();

    inline void set_has_s32Latitude ();

    inline void clear_has_s32Latitude ();

    inline void set_has_s32Longitude ();

    inline void clear_has_s32Longitude ();

    uint32 _has_bits_[ (3 + 31) / 32];

    bool _bLatLongValidity;

    int32 _s32Latitude;

    int32 _s32Longitude;

};

class T_PhonBkContactDetails {
public:

    /**
     * Default constructor
     */
    inline  T_PhonBkContactDetails ();

    /**
     * Copy constructor
     */
    inline  T_PhonBkContactDetails (const T_PhonBkContactDetails &rhs);

    /**
     * All fields constructor
     */
    inline  T_PhonBkContactDetails (const ::fi_basetypes_most::T_String& sFirstName_, const ::fi_basetypes_most::T_String& sLastName_, const ::fi_basetypes_most::T_String& sPOIName_, const ::fi_basetypes_most::T_String& sPreferredNumber_, const ::fi_basetypes_most::T_String& sCellNumber1_, const ::fi_basetypes_most::T_String& sCellNumber2_, const ::fi_basetypes_most::T_String& sHomeNumber1_, const ::fi_basetypes_most::T_String& sHomeNumber2_, const ::fi_basetypes_most::T_String& sWorkNumber1_, const ::fi_basetypes_most::T_String& sWorkNumber2_, const ::fi_basetypes_most::T_String& sOtherNumber_, const ::fi_basetypes_most::T_String& sEmailAddress1_, const ::fi_basetypes_most::T_String& sEmailAddress2_, const ::fi_basetypes_most::T_String& sEmailAddress3_, const ::fi_basetypes_most::T_String& sHomeAddress_, const ::fi_basetypes_most::T_String& sWorkAddress_, const ::fi_basetypes_most::T_String& sOtherAddress_, const ::fi_basetypes_most::T_String& sCategory_, const ::fi_basetypes_most::T_String& sNotes_, uint32 u32FirstNameTag_, uint32 u32LastNameTag_, uint32 u32POINameTag_, uint32 u32PrefNumTag_, uint32 u32CellNum1Tag_, uint32 u32CellNum2Tag_, uint32 u32HomeNum1Tag_, uint32 u32HomeNum2Tag_, uint32 u32WorkNum1Tag_, uint32 u32WorkNum2Tag_, uint32 u32OtherNumTag_, uint32 u32EmailAdd1Tag_, uint32 u32EmailAdd2Tag_, uint32 u32EmailAdd3Tag_, uint32 u32HomeAddTag_, uint32 u32WorkAddTag_, uint32 u32OtherAddTag_, uint32 u32CategoryTag_, uint32 u32NotesTag_, bool bPhotoAvailable_, const T_PhonBkHomeAddressLatLong& oHomeAddressLatLong_, const T_PhonBkWorkAddressLatLong& oWorkAddressLatLong_, const T_PhonBkOtherAddressLatLong& oOtherAddressLatLong_);

    /**
     * Destructor
     */
    inline  ~T_PhonBkContactDetails();

    /**
     * Assignment operator
     */
    inline T_PhonBkContactDetails& operator = (const T_PhonBkContactDetails& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_PhonBkContactDetails& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_PhonBkContactDetails& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_PhonBkContactDetails& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_PhonBkContactDetails& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sFirstName"

    static const int kSFirstName = 0;

    /**
     * Clears the field "sFirstName".
     *
     * The field will be set to its default value. The hasSFirstName()
     * method will return false.
     */
    inline void clearSFirstName();

    /**
     * Checks whether the field "sFirstName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSFirstName()). Otherwise it will return false.
     */
    inline bool hasSFirstName () const;

    /**
     * Returns the value of the member "sFirstName".
     *
     *
     *
     * @return The value of the field "sFirstName"
     */
    inline const ::fi_basetypes_most::T_String& getSFirstName () const;

    /**
     * Retrieves the value of the field "sFirstName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sFirstName".
     */
    inline ::fi_basetypes_most::T_String& getSFirstNameMutable ();

    /**
     * Sets the value of the member "sFirstName".
     *
     *
     *
     * @param sFirstName The value which will be set
     */
    inline void setSFirstName (const ::fi_basetypes_most::T_String& sFirstName_);

    // API of field "sLastName"

    static const int kSLastName = 1;

    /**
     * Clears the field "sLastName".
     *
     * The field will be set to its default value. The hasSLastName()
     * method will return false.
     */
    inline void clearSLastName();

    /**
     * Checks whether the field "sLastName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSLastName()). Otherwise it will return false.
     */
    inline bool hasSLastName () const;

    /**
     * Returns the value of the member "sLastName".
     *
     *
     *
     * @return The value of the field "sLastName"
     */
    inline const ::fi_basetypes_most::T_String& getSLastName () const;

    /**
     * Retrieves the value of the field "sLastName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sLastName".
     */
    inline ::fi_basetypes_most::T_String& getSLastNameMutable ();

    /**
     * Sets the value of the member "sLastName".
     *
     *
     *
     * @param sLastName The value which will be set
     */
    inline void setSLastName (const ::fi_basetypes_most::T_String& sLastName_);

    // API of field "sPOIName"

    static const int kSPOIName = 2;

    /**
     * Clears the field "sPOIName".
     *
     * The field will be set to its default value. The hasSPOIName()
     * method will return false.
     */
    inline void clearSPOIName();

    /**
     * Checks whether the field "sPOIName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSPOIName()). Otherwise it will return false.
     */
    inline bool hasSPOIName () const;

    /**
     * Returns the value of the member "sPOIName".
     *
     *
     *
     * @return The value of the field "sPOIName"
     */
    inline const ::fi_basetypes_most::T_String& getSPOIName () const;

    /**
     * Retrieves the value of the field "sPOIName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sPOIName".
     */
    inline ::fi_basetypes_most::T_String& getSPOINameMutable ();

    /**
     * Sets the value of the member "sPOIName".
     *
     *
     *
     * @param sPOIName The value which will be set
     */
    inline void setSPOIName (const ::fi_basetypes_most::T_String& sPOIName_);

    // API of field "sPreferredNumber"

    static const int kSPreferredNumber = 3;

    /**
     * Clears the field "sPreferredNumber".
     *
     * The field will be set to its default value. The hasSPreferredNumber()
     * method will return false.
     */
    inline void clearSPreferredNumber();

    /**
     * Checks whether the field "sPreferredNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSPreferredNumber()). Otherwise it will return false.
     */
    inline bool hasSPreferredNumber () const;

    /**
     * Returns the value of the member "sPreferredNumber".
     *
     *
     *
     * @return The value of the field "sPreferredNumber"
     */
    inline const ::fi_basetypes_most::T_String& getSPreferredNumber () const;

    /**
     * Retrieves the value of the field "sPreferredNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sPreferredNumber".
     */
    inline ::fi_basetypes_most::T_String& getSPreferredNumberMutable ();

    /**
     * Sets the value of the member "sPreferredNumber".
     *
     *
     *
     * @param sPreferredNumber The value which will be set
     */
    inline void setSPreferredNumber (const ::fi_basetypes_most::T_String& sPreferredNumber_);

    // API of field "sCellNumber1"

    static const int kSCellNumber1 = 4;

    /**
     * Clears the field "sCellNumber1".
     *
     * The field will be set to its default value. The hasSCellNumber1()
     * method will return false.
     */
    inline void clearSCellNumber1();

    /**
     * Checks whether the field "sCellNumber1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSCellNumber1()). Otherwise it will return false.
     */
    inline bool hasSCellNumber1 () const;

    /**
     * Returns the value of the member "sCellNumber1".
     *
     *
     *
     * @return The value of the field "sCellNumber1"
     */
    inline const ::fi_basetypes_most::T_String& getSCellNumber1 () const;

    /**
     * Retrieves the value of the field "sCellNumber1" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sCellNumber1".
     */
    inline ::fi_basetypes_most::T_String& getSCellNumber1Mutable ();

    /**
     * Sets the value of the member "sCellNumber1".
     *
     *
     *
     * @param sCellNumber1 The value which will be set
     */
    inline void setSCellNumber1 (const ::fi_basetypes_most::T_String& sCellNumber1_);

    // API of field "sCellNumber2"

    static const int kSCellNumber2 = 5;

    /**
     * Clears the field "sCellNumber2".
     *
     * The field will be set to its default value. The hasSCellNumber2()
     * method will return false.
     */
    inline void clearSCellNumber2();

    /**
     * Checks whether the field "sCellNumber2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSCellNumber2()). Otherwise it will return false.
     */
    inline bool hasSCellNumber2 () const;

    /**
     * Returns the value of the member "sCellNumber2".
     *
     *
     *
     * @return The value of the field "sCellNumber2"
     */
    inline const ::fi_basetypes_most::T_String& getSCellNumber2 () const;

    /**
     * Retrieves the value of the field "sCellNumber2" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sCellNumber2".
     */
    inline ::fi_basetypes_most::T_String& getSCellNumber2Mutable ();

    /**
     * Sets the value of the member "sCellNumber2".
     *
     *
     *
     * @param sCellNumber2 The value which will be set
     */
    inline void setSCellNumber2 (const ::fi_basetypes_most::T_String& sCellNumber2_);

    // API of field "sHomeNumber1"

    static const int kSHomeNumber1 = 6;

    /**
     * Clears the field "sHomeNumber1".
     *
     * The field will be set to its default value. The hasSHomeNumber1()
     * method will return false.
     */
    inline void clearSHomeNumber1();

    /**
     * Checks whether the field "sHomeNumber1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSHomeNumber1()). Otherwise it will return false.
     */
    inline bool hasSHomeNumber1 () const;

    /**
     * Returns the value of the member "sHomeNumber1".
     *
     *
     *
     * @return The value of the field "sHomeNumber1"
     */
    inline const ::fi_basetypes_most::T_String& getSHomeNumber1 () const;

    /**
     * Retrieves the value of the field "sHomeNumber1" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sHomeNumber1".
     */
    inline ::fi_basetypes_most::T_String& getSHomeNumber1Mutable ();

    /**
     * Sets the value of the member "sHomeNumber1".
     *
     *
     *
     * @param sHomeNumber1 The value which will be set
     */
    inline void setSHomeNumber1 (const ::fi_basetypes_most::T_String& sHomeNumber1_);

    // API of field "sHomeNumber2"

    static const int kSHomeNumber2 = 7;

    /**
     * Clears the field "sHomeNumber2".
     *
     * The field will be set to its default value. The hasSHomeNumber2()
     * method will return false.
     */
    inline void clearSHomeNumber2();

    /**
     * Checks whether the field "sHomeNumber2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSHomeNumber2()). Otherwise it will return false.
     */
    inline bool hasSHomeNumber2 () const;

    /**
     * Returns the value of the member "sHomeNumber2".
     *
     *
     *
     * @return The value of the field "sHomeNumber2"
     */
    inline const ::fi_basetypes_most::T_String& getSHomeNumber2 () const;

    /**
     * Retrieves the value of the field "sHomeNumber2" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sHomeNumber2".
     */
    inline ::fi_basetypes_most::T_String& getSHomeNumber2Mutable ();

    /**
     * Sets the value of the member "sHomeNumber2".
     *
     *
     *
     * @param sHomeNumber2 The value which will be set
     */
    inline void setSHomeNumber2 (const ::fi_basetypes_most::T_String& sHomeNumber2_);

    // API of field "sWorkNumber1"

    static const int kSWorkNumber1 = 8;

    /**
     * Clears the field "sWorkNumber1".
     *
     * The field will be set to its default value. The hasSWorkNumber1()
     * method will return false.
     */
    inline void clearSWorkNumber1();

    /**
     * Checks whether the field "sWorkNumber1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSWorkNumber1()). Otherwise it will return false.
     */
    inline bool hasSWorkNumber1 () const;

    /**
     * Returns the value of the member "sWorkNumber1".
     *
     *
     *
     * @return The value of the field "sWorkNumber1"
     */
    inline const ::fi_basetypes_most::T_String& getSWorkNumber1 () const;

    /**
     * Retrieves the value of the field "sWorkNumber1" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sWorkNumber1".
     */
    inline ::fi_basetypes_most::T_String& getSWorkNumber1Mutable ();

    /**
     * Sets the value of the member "sWorkNumber1".
     *
     *
     *
     * @param sWorkNumber1 The value which will be set
     */
    inline void setSWorkNumber1 (const ::fi_basetypes_most::T_String& sWorkNumber1_);

    // API of field "sWorkNumber2"

    static const int kSWorkNumber2 = 9;

    /**
     * Clears the field "sWorkNumber2".
     *
     * The field will be set to its default value. The hasSWorkNumber2()
     * method will return false.
     */
    inline void clearSWorkNumber2();

    /**
     * Checks whether the field "sWorkNumber2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSWorkNumber2()). Otherwise it will return false.
     */
    inline bool hasSWorkNumber2 () const;

    /**
     * Returns the value of the member "sWorkNumber2".
     *
     *
     *
     * @return The value of the field "sWorkNumber2"
     */
    inline const ::fi_basetypes_most::T_String& getSWorkNumber2 () const;

    /**
     * Retrieves the value of the field "sWorkNumber2" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sWorkNumber2".
     */
    inline ::fi_basetypes_most::T_String& getSWorkNumber2Mutable ();

    /**
     * Sets the value of the member "sWorkNumber2".
     *
     *
     *
     * @param sWorkNumber2 The value which will be set
     */
    inline void setSWorkNumber2 (const ::fi_basetypes_most::T_String& sWorkNumber2_);

    // API of field "sOtherNumber"

    static const int kSOtherNumber = 10;

    /**
     * Clears the field "sOtherNumber".
     *
     * The field will be set to its default value. The hasSOtherNumber()
     * method will return false.
     */
    inline void clearSOtherNumber();

    /**
     * Checks whether the field "sOtherNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSOtherNumber()). Otherwise it will return false.
     */
    inline bool hasSOtherNumber () const;

    /**
     * Returns the value of the member "sOtherNumber".
     *
     *
     *
     * @return The value of the field "sOtherNumber"
     */
    inline const ::fi_basetypes_most::T_String& getSOtherNumber () const;

    /**
     * Retrieves the value of the field "sOtherNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sOtherNumber".
     */
    inline ::fi_basetypes_most::T_String& getSOtherNumberMutable ();

    /**
     * Sets the value of the member "sOtherNumber".
     *
     *
     *
     * @param sOtherNumber The value which will be set
     */
    inline void setSOtherNumber (const ::fi_basetypes_most::T_String& sOtherNumber_);

    // API of field "sEmailAddress1"

    static const int kSEmailAddress1 = 11;

    /**
     * Clears the field "sEmailAddress1".
     *
     * The field will be set to its default value. The hasSEmailAddress1()
     * method will return false.
     */
    inline void clearSEmailAddress1();

    /**
     * Checks whether the field "sEmailAddress1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSEmailAddress1()). Otherwise it will return false.
     */
    inline bool hasSEmailAddress1 () const;

    /**
     * Returns the value of the member "sEmailAddress1".
     *
     *
     *
     * @return The value of the field "sEmailAddress1"
     */
    inline const ::fi_basetypes_most::T_String& getSEmailAddress1 () const;

    /**
     * Retrieves the value of the field "sEmailAddress1" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sEmailAddress1".
     */
    inline ::fi_basetypes_most::T_String& getSEmailAddress1Mutable ();

    /**
     * Sets the value of the member "sEmailAddress1".
     *
     *
     *
     * @param sEmailAddress1 The value which will be set
     */
    inline void setSEmailAddress1 (const ::fi_basetypes_most::T_String& sEmailAddress1_);

    // API of field "sEmailAddress2"

    static const int kSEmailAddress2 = 12;

    /**
     * Clears the field "sEmailAddress2".
     *
     * The field will be set to its default value. The hasSEmailAddress2()
     * method will return false.
     */
    inline void clearSEmailAddress2();

    /**
     * Checks whether the field "sEmailAddress2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSEmailAddress2()). Otherwise it will return false.
     */
    inline bool hasSEmailAddress2 () const;

    /**
     * Returns the value of the member "sEmailAddress2".
     *
     *
     *
     * @return The value of the field "sEmailAddress2"
     */
    inline const ::fi_basetypes_most::T_String& getSEmailAddress2 () const;

    /**
     * Retrieves the value of the field "sEmailAddress2" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sEmailAddress2".
     */
    inline ::fi_basetypes_most::T_String& getSEmailAddress2Mutable ();

    /**
     * Sets the value of the member "sEmailAddress2".
     *
     *
     *
     * @param sEmailAddress2 The value which will be set
     */
    inline void setSEmailAddress2 (const ::fi_basetypes_most::T_String& sEmailAddress2_);

    // API of field "sEmailAddress3"

    static const int kSEmailAddress3 = 13;

    /**
     * Clears the field "sEmailAddress3".
     *
     * The field will be set to its default value. The hasSEmailAddress3()
     * method will return false.
     */
    inline void clearSEmailAddress3();

    /**
     * Checks whether the field "sEmailAddress3" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSEmailAddress3()). Otherwise it will return false.
     */
    inline bool hasSEmailAddress3 () const;

    /**
     * Returns the value of the member "sEmailAddress3".
     *
     *
     *
     * @return The value of the field "sEmailAddress3"
     */
    inline const ::fi_basetypes_most::T_String& getSEmailAddress3 () const;

    /**
     * Retrieves the value of the field "sEmailAddress3" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sEmailAddress3".
     */
    inline ::fi_basetypes_most::T_String& getSEmailAddress3Mutable ();

    /**
     * Sets the value of the member "sEmailAddress3".
     *
     *
     *
     * @param sEmailAddress3 The value which will be set
     */
    inline void setSEmailAddress3 (const ::fi_basetypes_most::T_String& sEmailAddress3_);

    // API of field "sHomeAddress"

    static const int kSHomeAddress = 14;

    /**
     * Clears the field "sHomeAddress".
     *
     * The field will be set to its default value. The hasSHomeAddress()
     * method will return false.
     */
    inline void clearSHomeAddress();

    /**
     * Checks whether the field "sHomeAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSHomeAddress()). Otherwise it will return false.
     */
    inline bool hasSHomeAddress () const;

    /**
     * Returns the value of the member "sHomeAddress".
     *
     *
     *
     * @return The value of the field "sHomeAddress"
     */
    inline const ::fi_basetypes_most::T_String& getSHomeAddress () const;

    /**
     * Retrieves the value of the field "sHomeAddress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sHomeAddress".
     */
    inline ::fi_basetypes_most::T_String& getSHomeAddressMutable ();

    /**
     * Sets the value of the member "sHomeAddress".
     *
     *
     *
     * @param sHomeAddress The value which will be set
     */
    inline void setSHomeAddress (const ::fi_basetypes_most::T_String& sHomeAddress_);

    // API of field "sWorkAddress"

    static const int kSWorkAddress = 15;

    /**
     * Clears the field "sWorkAddress".
     *
     * The field will be set to its default value. The hasSWorkAddress()
     * method will return false.
     */
    inline void clearSWorkAddress();

    /**
     * Checks whether the field "sWorkAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSWorkAddress()). Otherwise it will return false.
     */
    inline bool hasSWorkAddress () const;

    /**
     * Returns the value of the member "sWorkAddress".
     *
     *
     *
     * @return The value of the field "sWorkAddress"
     */
    inline const ::fi_basetypes_most::T_String& getSWorkAddress () const;

    /**
     * Retrieves the value of the field "sWorkAddress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sWorkAddress".
     */
    inline ::fi_basetypes_most::T_String& getSWorkAddressMutable ();

    /**
     * Sets the value of the member "sWorkAddress".
     *
     *
     *
     * @param sWorkAddress The value which will be set
     */
    inline void setSWorkAddress (const ::fi_basetypes_most::T_String& sWorkAddress_);

    // API of field "sOtherAddress"

    static const int kSOtherAddress = 16;

    /**
     * Clears the field "sOtherAddress".
     *
     * The field will be set to its default value. The hasSOtherAddress()
     * method will return false.
     */
    inline void clearSOtherAddress();

    /**
     * Checks whether the field "sOtherAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSOtherAddress()). Otherwise it will return false.
     */
    inline bool hasSOtherAddress () const;

    /**
     * Returns the value of the member "sOtherAddress".
     *
     *
     *
     * @return The value of the field "sOtherAddress"
     */
    inline const ::fi_basetypes_most::T_String& getSOtherAddress () const;

    /**
     * Retrieves the value of the field "sOtherAddress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sOtherAddress".
     */
    inline ::fi_basetypes_most::T_String& getSOtherAddressMutable ();

    /**
     * Sets the value of the member "sOtherAddress".
     *
     *
     *
     * @param sOtherAddress The value which will be set
     */
    inline void setSOtherAddress (const ::fi_basetypes_most::T_String& sOtherAddress_);

    // API of field "sCategory"

    static const int kSCategory = 17;

    /**
     * Clears the field "sCategory".
     *
     * The field will be set to its default value. The hasSCategory()
     * method will return false.
     */
    inline void clearSCategory();

    /**
     * Checks whether the field "sCategory" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSCategory()). Otherwise it will return false.
     */
    inline bool hasSCategory () const;

    /**
     * Returns the value of the member "sCategory".
     *
     *
     *
     * @return The value of the field "sCategory"
     */
    inline const ::fi_basetypes_most::T_String& getSCategory () const;

    /**
     * Retrieves the value of the field "sCategory" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sCategory".
     */
    inline ::fi_basetypes_most::T_String& getSCategoryMutable ();

    /**
     * Sets the value of the member "sCategory".
     *
     *
     *
     * @param sCategory The value which will be set
     */
    inline void setSCategory (const ::fi_basetypes_most::T_String& sCategory_);

    // API of field "sNotes"

    static const int kSNotes = 18;

    /**
     * Clears the field "sNotes".
     *
     * The field will be set to its default value. The hasSNotes()
     * method will return false.
     */
    inline void clearSNotes();

    /**
     * Checks whether the field "sNotes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSNotes()). Otherwise it will return false.
     */
    inline bool hasSNotes () const;

    /**
     * Returns the value of the member "sNotes".
     *
     *
     *
     * @return The value of the field "sNotes"
     */
    inline const ::fi_basetypes_most::T_String& getSNotes () const;

    /**
     * Retrieves the value of the field "sNotes" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sNotes".
     */
    inline ::fi_basetypes_most::T_String& getSNotesMutable ();

    /**
     * Sets the value of the member "sNotes".
     *
     *
     *
     * @param sNotes The value which will be set
     */
    inline void setSNotes (const ::fi_basetypes_most::T_String& sNotes_);

    // API of field "u32FirstNameTag"

    static const int kU32FirstNameTag = 19;

    /**
     * Clears the field "u32FirstNameTag".
     *
     * The field will be set to its default value. The hasU32FirstNameTag()
     * method will return false.
     */
    inline void clearU32FirstNameTag();

    /**
     * Checks whether the field "u32FirstNameTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32FirstNameTag()). Otherwise it will return false.
     */
    inline bool hasU32FirstNameTag () const;

    /**
     * Returns the value of the member "u32FirstNameTag".
     *
     * Unique tag identifies the contact first name
     *
     * @return The value of the field "u32FirstNameTag"
     */
    inline uint32 getU32FirstNameTag () const;

    /**
     * Sets the value of the member "u32FirstNameTag".
     *
     * Unique tag identifies the contact first name
     *
     * @param u32FirstNameTag The value which will be set
     */
    inline void setU32FirstNameTag (uint32 u32FirstNameTag_);

    // API of field "u32LastNameTag"

    static const int kU32LastNameTag = 20;

    /**
     * Clears the field "u32LastNameTag".
     *
     * The field will be set to its default value. The hasU32LastNameTag()
     * method will return false.
     */
    inline void clearU32LastNameTag();

    /**
     * Checks whether the field "u32LastNameTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32LastNameTag()). Otherwise it will return false.
     */
    inline bool hasU32LastNameTag () const;

    /**
     * Returns the value of the member "u32LastNameTag".
     *
     * Unique tag identifies the contact last name
     *
     * @return The value of the field "u32LastNameTag"
     */
    inline uint32 getU32LastNameTag () const;

    /**
     * Sets the value of the member "u32LastNameTag".
     *
     * Unique tag identifies the contact last name
     *
     * @param u32LastNameTag The value which will be set
     */
    inline void setU32LastNameTag (uint32 u32LastNameTag_);

    // API of field "u32POINameTag"

    static const int kU32POINameTag = 21;

    /**
     * Clears the field "u32POINameTag".
     *
     * The field will be set to its default value. The hasU32POINameTag()
     * method will return false.
     */
    inline void clearU32POINameTag();

    /**
     * Checks whether the field "u32POINameTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32POINameTag()). Otherwise it will return false.
     */
    inline bool hasU32POINameTag () const;

    /**
     * Returns the value of the member "u32POINameTag".
     *
     * Unique tag identifies the POI name
     *
     * @return The value of the field "u32POINameTag"
     */
    inline uint32 getU32POINameTag () const;

    /**
     * Sets the value of the member "u32POINameTag".
     *
     * Unique tag identifies the POI name
     *
     * @param u32POINameTag The value which will be set
     */
    inline void setU32POINameTag (uint32 u32POINameTag_);

    // API of field "u32PrefNumTag"

    static const int kU32PrefNumTag = 22;

    /**
     * Clears the field "u32PrefNumTag".
     *
     * The field will be set to its default value. The hasU32PrefNumTag()
     * method will return false.
     */
    inline void clearU32PrefNumTag();

    /**
     * Checks whether the field "u32PrefNumTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32PrefNumTag()). Otherwise it will return false.
     */
    inline bool hasU32PrefNumTag () const;

    /**
     * Returns the value of the member "u32PrefNumTag".
     *
     * Unique tag identifies the contact preferred number
     *
     * @return The value of the field "u32PrefNumTag"
     */
    inline uint32 getU32PrefNumTag () const;

    /**
     * Sets the value of the member "u32PrefNumTag".
     *
     * Unique tag identifies the contact preferred number
     *
     * @param u32PrefNumTag The value which will be set
     */
    inline void setU32PrefNumTag (uint32 u32PrefNumTag_);

    // API of field "u32CellNum1Tag"

    static const int kU32CellNum1Tag = 23;

    /**
     * Clears the field "u32CellNum1Tag".
     *
     * The field will be set to its default value. The hasU32CellNum1Tag()
     * method will return false.
     */
    inline void clearU32CellNum1Tag();

    /**
     * Checks whether the field "u32CellNum1Tag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32CellNum1Tag()). Otherwise it will return false.
     */
    inline bool hasU32CellNum1Tag () const;

    /**
     * Returns the value of the member "u32CellNum1Tag".
     *
     * Unique tag identifies the contact cell 1 number
     *
     * @return The value of the field "u32CellNum1Tag"
     */
    inline uint32 getU32CellNum1Tag () const;

    /**
     * Sets the value of the member "u32CellNum1Tag".
     *
     * Unique tag identifies the contact cell 1 number
     *
     * @param u32CellNum1Tag The value which will be set
     */
    inline void setU32CellNum1Tag (uint32 u32CellNum1Tag_);

    // API of field "u32CellNum2Tag"

    static const int kU32CellNum2Tag = 24;

    /**
     * Clears the field "u32CellNum2Tag".
     *
     * The field will be set to its default value. The hasU32CellNum2Tag()
     * method will return false.
     */
    inline void clearU32CellNum2Tag();

    /**
     * Checks whether the field "u32CellNum2Tag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32CellNum2Tag()). Otherwise it will return false.
     */
    inline bool hasU32CellNum2Tag () const;

    /**
     * Returns the value of the member "u32CellNum2Tag".
     *
     * Unique tag identifies the contact cell 2 number
     *
     * @return The value of the field "u32CellNum2Tag"
     */
    inline uint32 getU32CellNum2Tag () const;

    /**
     * Sets the value of the member "u32CellNum2Tag".
     *
     * Unique tag identifies the contact cell 2 number
     *
     * @param u32CellNum2Tag The value which will be set
     */
    inline void setU32CellNum2Tag (uint32 u32CellNum2Tag_);

    // API of field "u32HomeNum1Tag"

    static const int kU32HomeNum1Tag = 25;

    /**
     * Clears the field "u32HomeNum1Tag".
     *
     * The field will be set to its default value. The hasU32HomeNum1Tag()
     * method will return false.
     */
    inline void clearU32HomeNum1Tag();

    /**
     * Checks whether the field "u32HomeNum1Tag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32HomeNum1Tag()). Otherwise it will return false.
     */
    inline bool hasU32HomeNum1Tag () const;

    /**
     * Returns the value of the member "u32HomeNum1Tag".
     *
     * Unique tag identifies the contact home 1 number
     *
     * @return The value of the field "u32HomeNum1Tag"
     */
    inline uint32 getU32HomeNum1Tag () const;

    /**
     * Sets the value of the member "u32HomeNum1Tag".
     *
     * Unique tag identifies the contact home 1 number
     *
     * @param u32HomeNum1Tag The value which will be set
     */
    inline void setU32HomeNum1Tag (uint32 u32HomeNum1Tag_);

    // API of field "u32HomeNum2Tag"

    static const int kU32HomeNum2Tag = 26;

    /**
     * Clears the field "u32HomeNum2Tag".
     *
     * The field will be set to its default value. The hasU32HomeNum2Tag()
     * method will return false.
     */
    inline void clearU32HomeNum2Tag();

    /**
     * Checks whether the field "u32HomeNum2Tag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32HomeNum2Tag()). Otherwise it will return false.
     */
    inline bool hasU32HomeNum2Tag () const;

    /**
     * Returns the value of the member "u32HomeNum2Tag".
     *
     * Unique tag identifies the contact home 2 number
     *
     * @return The value of the field "u32HomeNum2Tag"
     */
    inline uint32 getU32HomeNum2Tag () const;

    /**
     * Sets the value of the member "u32HomeNum2Tag".
     *
     * Unique tag identifies the contact home 2 number
     *
     * @param u32HomeNum2Tag The value which will be set
     */
    inline void setU32HomeNum2Tag (uint32 u32HomeNum2Tag_);

    // API of field "u32WorkNum1Tag"

    static const int kU32WorkNum1Tag = 27;

    /**
     * Clears the field "u32WorkNum1Tag".
     *
     * The field will be set to its default value. The hasU32WorkNum1Tag()
     * method will return false.
     */
    inline void clearU32WorkNum1Tag();

    /**
     * Checks whether the field "u32WorkNum1Tag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32WorkNum1Tag()). Otherwise it will return false.
     */
    inline bool hasU32WorkNum1Tag () const;

    /**
     * Returns the value of the member "u32WorkNum1Tag".
     *
     * Unique tag identifies the contact work 1 number
     *
     * @return The value of the field "u32WorkNum1Tag"
     */
    inline uint32 getU32WorkNum1Tag () const;

    /**
     * Sets the value of the member "u32WorkNum1Tag".
     *
     * Unique tag identifies the contact work 1 number
     *
     * @param u32WorkNum1Tag The value which will be set
     */
    inline void setU32WorkNum1Tag (uint32 u32WorkNum1Tag_);

    // API of field "u32WorkNum2Tag"

    static const int kU32WorkNum2Tag = 28;

    /**
     * Clears the field "u32WorkNum2Tag".
     *
     * The field will be set to its default value. The hasU32WorkNum2Tag()
     * method will return false.
     */
    inline void clearU32WorkNum2Tag();

    /**
     * Checks whether the field "u32WorkNum2Tag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32WorkNum2Tag()). Otherwise it will return false.
     */
    inline bool hasU32WorkNum2Tag () const;

    /**
     * Returns the value of the member "u32WorkNum2Tag".
     *
     * Unique tag identifies the contact work 2 number
     *
     * @return The value of the field "u32WorkNum2Tag"
     */
    inline uint32 getU32WorkNum2Tag () const;

    /**
     * Sets the value of the member "u32WorkNum2Tag".
     *
     * Unique tag identifies the contact work 2 number
     *
     * @param u32WorkNum2Tag The value which will be set
     */
    inline void setU32WorkNum2Tag (uint32 u32WorkNum2Tag_);

    // API of field "u32OtherNumTag"

    static const int kU32OtherNumTag = 29;

    /**
     * Clears the field "u32OtherNumTag".
     *
     * The field will be set to its default value. The hasU32OtherNumTag()
     * method will return false.
     */
    inline void clearU32OtherNumTag();

    /**
     * Checks whether the field "u32OtherNumTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32OtherNumTag()). Otherwise it will return false.
     */
    inline bool hasU32OtherNumTag () const;

    /**
     * Returns the value of the member "u32OtherNumTag".
     *
     * Unique tag identifies the contact other number
     *
     * @return The value of the field "u32OtherNumTag"
     */
    inline uint32 getU32OtherNumTag () const;

    /**
     * Sets the value of the member "u32OtherNumTag".
     *
     * Unique tag identifies the contact other number
     *
     * @param u32OtherNumTag The value which will be set
     */
    inline void setU32OtherNumTag (uint32 u32OtherNumTag_);

    // API of field "u32EmailAdd1Tag"

    static const int kU32EmailAdd1Tag = 30;

    /**
     * Clears the field "u32EmailAdd1Tag".
     *
     * The field will be set to its default value. The hasU32EmailAdd1Tag()
     * method will return false.
     */
    inline void clearU32EmailAdd1Tag();

    /**
     * Checks whether the field "u32EmailAdd1Tag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32EmailAdd1Tag()). Otherwise it will return false.
     */
    inline bool hasU32EmailAdd1Tag () const;

    /**
     * Returns the value of the member "u32EmailAdd1Tag".
     *
     * Unique tag identifies the contact email address 1
     *
     * @return The value of the field "u32EmailAdd1Tag"
     */
    inline uint32 getU32EmailAdd1Tag () const;

    /**
     * Sets the value of the member "u32EmailAdd1Tag".
     *
     * Unique tag identifies the contact email address 1
     *
     * @param u32EmailAdd1Tag The value which will be set
     */
    inline void setU32EmailAdd1Tag (uint32 u32EmailAdd1Tag_);

    // API of field "u32EmailAdd2Tag"

    static const int kU32EmailAdd2Tag = 31;

    /**
     * Clears the field "u32EmailAdd2Tag".
     *
     * The field will be set to its default value. The hasU32EmailAdd2Tag()
     * method will return false.
     */
    inline void clearU32EmailAdd2Tag();

    /**
     * Checks whether the field "u32EmailAdd2Tag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32EmailAdd2Tag()). Otherwise it will return false.
     */
    inline bool hasU32EmailAdd2Tag () const;

    /**
     * Returns the value of the member "u32EmailAdd2Tag".
     *
     * Unique tag identifies the contact email address 2
     *
     * @return The value of the field "u32EmailAdd2Tag"
     */
    inline uint32 getU32EmailAdd2Tag () const;

    /**
     * Sets the value of the member "u32EmailAdd2Tag".
     *
     * Unique tag identifies the contact email address 2
     *
     * @param u32EmailAdd2Tag The value which will be set
     */
    inline void setU32EmailAdd2Tag (uint32 u32EmailAdd2Tag_);

    // API of field "u32EmailAdd3Tag"

    static const int kU32EmailAdd3Tag = 32;

    /**
     * Clears the field "u32EmailAdd3Tag".
     *
     * The field will be set to its default value. The hasU32EmailAdd3Tag()
     * method will return false.
     */
    inline void clearU32EmailAdd3Tag();

    /**
     * Checks whether the field "u32EmailAdd3Tag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32EmailAdd3Tag()). Otherwise it will return false.
     */
    inline bool hasU32EmailAdd3Tag () const;

    /**
     * Returns the value of the member "u32EmailAdd3Tag".
     *
     * Unique tag identifies the contact email address 3
     *
     * @return The value of the field "u32EmailAdd3Tag"
     */
    inline uint32 getU32EmailAdd3Tag () const;

    /**
     * Sets the value of the member "u32EmailAdd3Tag".
     *
     * Unique tag identifies the contact email address 3
     *
     * @param u32EmailAdd3Tag The value which will be set
     */
    inline void setU32EmailAdd3Tag (uint32 u32EmailAdd3Tag_);

    // API of field "u32HomeAddTag"

    static const int kU32HomeAddTag = 33;

    /**
     * Clears the field "u32HomeAddTag".
     *
     * The field will be set to its default value. The hasU32HomeAddTag()
     * method will return false.
     */
    inline void clearU32HomeAddTag();

    /**
     * Checks whether the field "u32HomeAddTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32HomeAddTag()). Otherwise it will return false.
     */
    inline bool hasU32HomeAddTag () const;

    /**
     * Returns the value of the member "u32HomeAddTag".
     *
     * Unique tag identifies the contact home address
     *
     * @return The value of the field "u32HomeAddTag"
     */
    inline uint32 getU32HomeAddTag () const;

    /**
     * Sets the value of the member "u32HomeAddTag".
     *
     * Unique tag identifies the contact home address
     *
     * @param u32HomeAddTag The value which will be set
     */
    inline void setU32HomeAddTag (uint32 u32HomeAddTag_);

    // API of field "u32WorkAddTag"

    static const int kU32WorkAddTag = 34;

    /**
     * Clears the field "u32WorkAddTag".
     *
     * The field will be set to its default value. The hasU32WorkAddTag()
     * method will return false.
     */
    inline void clearU32WorkAddTag();

    /**
     * Checks whether the field "u32WorkAddTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32WorkAddTag()). Otherwise it will return false.
     */
    inline bool hasU32WorkAddTag () const;

    /**
     * Returns the value of the member "u32WorkAddTag".
     *
     * Unique tag identifies the contact work address
     *
     * @return The value of the field "u32WorkAddTag"
     */
    inline uint32 getU32WorkAddTag () const;

    /**
     * Sets the value of the member "u32WorkAddTag".
     *
     * Unique tag identifies the contact work address
     *
     * @param u32WorkAddTag The value which will be set
     */
    inline void setU32WorkAddTag (uint32 u32WorkAddTag_);

    // API of field "u32OtherAddTag"

    static const int kU32OtherAddTag = 35;

    /**
     * Clears the field "u32OtherAddTag".
     *
     * The field will be set to its default value. The hasU32OtherAddTag()
     * method will return false.
     */
    inline void clearU32OtherAddTag();

    /**
     * Checks whether the field "u32OtherAddTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32OtherAddTag()). Otherwise it will return false.
     */
    inline bool hasU32OtherAddTag () const;

    /**
     * Returns the value of the member "u32OtherAddTag".
     *
     * Unique tag identifies the contact other address
     *
     * @return The value of the field "u32OtherAddTag"
     */
    inline uint32 getU32OtherAddTag () const;

    /**
     * Sets the value of the member "u32OtherAddTag".
     *
     * Unique tag identifies the contact other address
     *
     * @param u32OtherAddTag The value which will be set
     */
    inline void setU32OtherAddTag (uint32 u32OtherAddTag_);

    // API of field "u32CategoryTag"

    static const int kU32CategoryTag = 36;

    /**
     * Clears the field "u32CategoryTag".
     *
     * The field will be set to its default value. The hasU32CategoryTag()
     * method will return false.
     */
    inline void clearU32CategoryTag();

    /**
     * Checks whether the field "u32CategoryTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32CategoryTag()). Otherwise it will return false.
     */
    inline bool hasU32CategoryTag () const;

    /**
     * Returns the value of the member "u32CategoryTag".
     *
     * Unique tag identifies the contact category
     *
     * @return The value of the field "u32CategoryTag"
     */
    inline uint32 getU32CategoryTag () const;

    /**
     * Sets the value of the member "u32CategoryTag".
     *
     * Unique tag identifies the contact category
     *
     * @param u32CategoryTag The value which will be set
     */
    inline void setU32CategoryTag (uint32 u32CategoryTag_);

    // API of field "u32NotesTag"

    static const int kU32NotesTag = 37;

    /**
     * Clears the field "u32NotesTag".
     *
     * The field will be set to its default value. The hasU32NotesTag()
     * method will return false.
     */
    inline void clearU32NotesTag();

    /**
     * Checks whether the field "u32NotesTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32NotesTag()). Otherwise it will return false.
     */
    inline bool hasU32NotesTag () const;

    /**
     * Returns the value of the member "u32NotesTag".
     *
     * Unique tag identifies the contact notes
     *
     * @return The value of the field "u32NotesTag"
     */
    inline uint32 getU32NotesTag () const;

    /**
     * Sets the value of the member "u32NotesTag".
     *
     * Unique tag identifies the contact notes
     *
     * @param u32NotesTag The value which will be set
     */
    inline void setU32NotesTag (uint32 u32NotesTag_);

    // API of field "bPhotoAvailable"

    static const int kBPhotoAvailable = 38;

    /**
     * Clears the field "bPhotoAvailable".
     *
     * The field will be set to its default value. The hasBPhotoAvailable()
     * method will return false.
     */
    inline void clearBPhotoAvailable();

    /**
     * Checks whether the field "bPhotoAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBPhotoAvailable()). Otherwise it will return false.
     */
    inline bool hasBPhotoAvailable () const;

    /**
     * Returns the value of the member "bPhotoAvailable".
     *
     * Flag indicated whether or not this contact also has an associated photo.  If True, then the photo information can be retrieved via GetContactPhotoInfo and the image from GetContactPhoto.
     *
     * @return The value of the field "bPhotoAvailable"
     */
    inline bool getBPhotoAvailable () const;

    /**
     * Sets the value of the member "bPhotoAvailable".
     *
     * Flag indicated whether or not this contact also has an associated photo.  If True, then the photo information can be retrieved via GetContactPhotoInfo and the image from GetContactPhoto.
     *
     * @param bPhotoAvailable The value which will be set
     */
    inline void setBPhotoAvailable (bool bPhotoAvailable_);

    // API of field "oHomeAddressLatLong"

    static const int kOHomeAddressLatLong = 39;

    /**
     * Clears the field "oHomeAddressLatLong".
     *
     * The field will be set to its default value. The hasOHomeAddressLatLong()
     * method will return false.
     */
    inline void clearOHomeAddressLatLong();

    /**
     * Checks whether the field "oHomeAddressLatLong" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOHomeAddressLatLong()). Otherwise it will return false.
     */
    inline bool hasOHomeAddressLatLong () const;

    /**
     * Returns the value of the member "oHomeAddressLatLong".
     *
     * This is the latitude and longitude associated with the home address.
     *
     * @return The value of the field "oHomeAddressLatLong"
     */
    inline const T_PhonBkHomeAddressLatLong& getOHomeAddressLatLong () const;

    /**
     * Retrieves the value of the field "oHomeAddressLatLong" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oHomeAddressLatLong".
     */
    inline T_PhonBkHomeAddressLatLong& getOHomeAddressLatLongMutable ();

    /**
     * Sets the value of the member "oHomeAddressLatLong".
     *
     * This is the latitude and longitude associated with the home address.
     *
     * @param oHomeAddressLatLong The value which will be set
     */
    inline void setOHomeAddressLatLong (const T_PhonBkHomeAddressLatLong& oHomeAddressLatLong_);

    // API of field "oWorkAddressLatLong"

    static const int kOWorkAddressLatLong = 40;

    /**
     * Clears the field "oWorkAddressLatLong".
     *
     * The field will be set to its default value. The hasOWorkAddressLatLong()
     * method will return false.
     */
    inline void clearOWorkAddressLatLong();

    /**
     * Checks whether the field "oWorkAddressLatLong" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOWorkAddressLatLong()). Otherwise it will return false.
     */
    inline bool hasOWorkAddressLatLong () const;

    /**
     * Returns the value of the member "oWorkAddressLatLong".
     *
     * This is the latitude and longitude associated with the work address.
     *
     * @return The value of the field "oWorkAddressLatLong"
     */
    inline const T_PhonBkWorkAddressLatLong& getOWorkAddressLatLong () const;

    /**
     * Retrieves the value of the field "oWorkAddressLatLong" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oWorkAddressLatLong".
     */
    inline T_PhonBkWorkAddressLatLong& getOWorkAddressLatLongMutable ();

    /**
     * Sets the value of the member "oWorkAddressLatLong".
     *
     * This is the latitude and longitude associated with the work address.
     *
     * @param oWorkAddressLatLong The value which will be set
     */
    inline void setOWorkAddressLatLong (const T_PhonBkWorkAddressLatLong& oWorkAddressLatLong_);

    // API of field "oOtherAddressLatLong"

    static const int kOOtherAddressLatLong = 41;

    /**
     * Clears the field "oOtherAddressLatLong".
     *
     * The field will be set to its default value. The hasOOtherAddressLatLong()
     * method will return false.
     */
    inline void clearOOtherAddressLatLong();

    /**
     * Checks whether the field "oOtherAddressLatLong" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOOtherAddressLatLong()). Otherwise it will return false.
     */
    inline bool hasOOtherAddressLatLong () const;

    /**
     * Returns the value of the member "oOtherAddressLatLong".
     *
     * This is the latitude and longitude associated with the other address.
     *
     * @return The value of the field "oOtherAddressLatLong"
     */
    inline const T_PhonBkOtherAddressLatLong& getOOtherAddressLatLong () const;

    /**
     * Retrieves the value of the field "oOtherAddressLatLong" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oOtherAddressLatLong".
     */
    inline T_PhonBkOtherAddressLatLong& getOOtherAddressLatLongMutable ();

    /**
     * Sets the value of the member "oOtherAddressLatLong".
     *
     * This is the latitude and longitude associated with the other address.
     *
     * @param oOtherAddressLatLong The value which will be set
     */
    inline void setOOtherAddressLatLong (const T_PhonBkOtherAddressLatLong& oOtherAddressLatLong_);

    static const T_PhonBkContactDetails &getDefaultInstance();

private:

    inline void set_has_sFirstName ();

    inline void clear_has_sFirstName ();

    inline void set_has_sLastName ();

    inline void clear_has_sLastName ();

    inline void set_has_sPOIName ();

    inline void clear_has_sPOIName ();

    inline void set_has_sPreferredNumber ();

    inline void clear_has_sPreferredNumber ();

    inline void set_has_sCellNumber1 ();

    inline void clear_has_sCellNumber1 ();

    inline void set_has_sCellNumber2 ();

    inline void clear_has_sCellNumber2 ();

    inline void set_has_sHomeNumber1 ();

    inline void clear_has_sHomeNumber1 ();

    inline void set_has_sHomeNumber2 ();

    inline void clear_has_sHomeNumber2 ();

    inline void set_has_sWorkNumber1 ();

    inline void clear_has_sWorkNumber1 ();

    inline void set_has_sWorkNumber2 ();

    inline void clear_has_sWorkNumber2 ();

    inline void set_has_sOtherNumber ();

    inline void clear_has_sOtherNumber ();

    inline void set_has_sEmailAddress1 ();

    inline void clear_has_sEmailAddress1 ();

    inline void set_has_sEmailAddress2 ();

    inline void clear_has_sEmailAddress2 ();

    inline void set_has_sEmailAddress3 ();

    inline void clear_has_sEmailAddress3 ();

    inline void set_has_sHomeAddress ();

    inline void clear_has_sHomeAddress ();

    inline void set_has_sWorkAddress ();

    inline void clear_has_sWorkAddress ();

    inline void set_has_sOtherAddress ();

    inline void clear_has_sOtherAddress ();

    inline void set_has_sCategory ();

    inline void clear_has_sCategory ();

    inline void set_has_sNotes ();

    inline void clear_has_sNotes ();

    inline void set_has_u32FirstNameTag ();

    inline void clear_has_u32FirstNameTag ();

    inline void set_has_u32LastNameTag ();

    inline void clear_has_u32LastNameTag ();

    inline void set_has_u32POINameTag ();

    inline void clear_has_u32POINameTag ();

    inline void set_has_u32PrefNumTag ();

    inline void clear_has_u32PrefNumTag ();

    inline void set_has_u32CellNum1Tag ();

    inline void clear_has_u32CellNum1Tag ();

    inline void set_has_u32CellNum2Tag ();

    inline void clear_has_u32CellNum2Tag ();

    inline void set_has_u32HomeNum1Tag ();

    inline void clear_has_u32HomeNum1Tag ();

    inline void set_has_u32HomeNum2Tag ();

    inline void clear_has_u32HomeNum2Tag ();

    inline void set_has_u32WorkNum1Tag ();

    inline void clear_has_u32WorkNum1Tag ();

    inline void set_has_u32WorkNum2Tag ();

    inline void clear_has_u32WorkNum2Tag ();

    inline void set_has_u32OtherNumTag ();

    inline void clear_has_u32OtherNumTag ();

    inline void set_has_u32EmailAdd1Tag ();

    inline void clear_has_u32EmailAdd1Tag ();

    inline void set_has_u32EmailAdd2Tag ();

    inline void clear_has_u32EmailAdd2Tag ();

    inline void set_has_u32EmailAdd3Tag ();

    inline void clear_has_u32EmailAdd3Tag ();

    inline void set_has_u32HomeAddTag ();

    inline void clear_has_u32HomeAddTag ();

    inline void set_has_u32WorkAddTag ();

    inline void clear_has_u32WorkAddTag ();

    inline void set_has_u32OtherAddTag ();

    inline void clear_has_u32OtherAddTag ();

    inline void set_has_u32CategoryTag ();

    inline void clear_has_u32CategoryTag ();

    inline void set_has_u32NotesTag ();

    inline void clear_has_u32NotesTag ();

    inline void set_has_bPhotoAvailable ();

    inline void clear_has_bPhotoAvailable ();

    inline void set_has_oHomeAddressLatLong ();

    inline void clear_has_oHomeAddressLatLong ();

    inline void set_has_oWorkAddressLatLong ();

    inline void clear_has_oWorkAddressLatLong ();

    inline void set_has_oOtherAddressLatLong ();

    inline void clear_has_oOtherAddressLatLong ();

    uint32 _has_bits_[ (42 + 31) / 32];

    ::fi_basetypes_most::T_String _sFirstName;

    ::fi_basetypes_most::T_String _sLastName;

    ::fi_basetypes_most::T_String _sPOIName;

    ::fi_basetypes_most::T_String _sPreferredNumber;

    ::fi_basetypes_most::T_String _sCellNumber1;

    ::fi_basetypes_most::T_String _sCellNumber2;

    ::fi_basetypes_most::T_String _sHomeNumber1;

    ::fi_basetypes_most::T_String _sHomeNumber2;

    ::fi_basetypes_most::T_String _sWorkNumber1;

    ::fi_basetypes_most::T_String _sWorkNumber2;

    ::fi_basetypes_most::T_String _sOtherNumber;

    ::fi_basetypes_most::T_String _sEmailAddress1;

    ::fi_basetypes_most::T_String _sEmailAddress2;

    ::fi_basetypes_most::T_String _sEmailAddress3;

    ::fi_basetypes_most::T_String _sHomeAddress;

    ::fi_basetypes_most::T_String _sWorkAddress;

    ::fi_basetypes_most::T_String _sOtherAddress;

    ::fi_basetypes_most::T_String _sCategory;

    ::fi_basetypes_most::T_String _sNotes;

    uint32 _u32FirstNameTag;

    uint32 _u32LastNameTag;

    uint32 _u32POINameTag;

    uint32 _u32PrefNumTag;

    uint32 _u32CellNum1Tag;

    uint32 _u32CellNum2Tag;

    uint32 _u32HomeNum1Tag;

    uint32 _u32HomeNum2Tag;

    uint32 _u32WorkNum1Tag;

    uint32 _u32WorkNum2Tag;

    uint32 _u32OtherNumTag;

    uint32 _u32EmailAdd1Tag;

    uint32 _u32EmailAdd2Tag;

    uint32 _u32EmailAdd3Tag;

    uint32 _u32HomeAddTag;

    uint32 _u32WorkAddTag;

    uint32 _u32OtherAddTag;

    uint32 _u32CategoryTag;

    uint32 _u32NotesTag;

    bool _bPhotoAvailable;

    T_PhonBkHomeAddressLatLong _oHomeAddressLatLong;

    T_PhonBkWorkAddressLatLong _oWorkAddressLatLong;

    T_PhonBkOtherAddressLatLong _oOtherAddressLatLong;

};

class T_PhonBkCallDate {
public:

    /**
     * Default constructor
     */
    inline  T_PhonBkCallDate ();

    /**
     * Copy constructor
     */
    inline  T_PhonBkCallDate (const T_PhonBkCallDate &rhs);

    /**
     * All fields constructor
     */
    inline  T_PhonBkCallDate (const ::fi_basetypes_most::T_String& sCldrYear_, const ::fi_basetypes_most::T_String& sCldrMonth_, const ::fi_basetypes_most::T_String& sCldrDay_);

    /**
     * Destructor
     */
    inline  ~T_PhonBkCallDate();

    /**
     * Assignment operator
     */
    inline T_PhonBkCallDate& operator = (const T_PhonBkCallDate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_PhonBkCallDate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_PhonBkCallDate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_PhonBkCallDate& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_PhonBkCallDate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sCldrYear"

    static const int kSCldrYear = 0;

    /**
     * Clears the field "sCldrYear".
     *
     * The field will be set to its default value. The hasSCldrYear()
     * method will return false.
     */
    inline void clearSCldrYear();

    /**
     * Checks whether the field "sCldrYear" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSCldrYear()). Otherwise it will return false.
     */
    inline bool hasSCldrYear () const;

    /**
     * Returns the value of the member "sCldrYear".
     *
     * Identifies the calendar year; 0000 = unknown calendar year.
     *
     * @return The value of the field "sCldrYear"
     */
    inline const ::fi_basetypes_most::T_String& getSCldrYear () const;

    /**
     * Retrieves the value of the field "sCldrYear" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sCldrYear".
     */
    inline ::fi_basetypes_most::T_String& getSCldrYearMutable ();

    /**
     * Sets the value of the member "sCldrYear".
     *
     * Identifies the calendar year; 0000 = unknown calendar year.
     *
     * @param sCldrYear The value which will be set
     */
    inline void setSCldrYear (const ::fi_basetypes_most::T_String& sCldrYear_);

    // API of field "sCldrMonth"

    static const int kSCldrMonth = 1;

    /**
     * Clears the field "sCldrMonth".
     *
     * The field will be set to its default value. The hasSCldrMonth()
     * method will return false.
     */
    inline void clearSCldrMonth();

    /**
     * Checks whether the field "sCldrMonth" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSCldrMonth()). Otherwise it will return false.
     */
    inline bool hasSCldrMonth () const;

    /**
     * Returns the value of the member "sCldrMonth".
     *
     * Identifies the calendar month.00 = Unknown01 = January02 = February03 = March04 = April05 = May06 = June07 = July08 = August09 = September10 = October11 = November12 = December
     *
     * @return The value of the field "sCldrMonth"
     */
    inline const ::fi_basetypes_most::T_String& getSCldrMonth () const;

    /**
     * Retrieves the value of the field "sCldrMonth" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sCldrMonth".
     */
    inline ::fi_basetypes_most::T_String& getSCldrMonthMutable ();

    /**
     * Sets the value of the member "sCldrMonth".
     *
     * Identifies the calendar month.00 = Unknown01 = January02 = February03 = March04 = April05 = May06 = June07 = July08 = August09 = September10 = October11 = November12 = December
     *
     * @param sCldrMonth The value which will be set
     */
    inline void setSCldrMonth (const ::fi_basetypes_most::T_String& sCldrMonth_);

    // API of field "sCldrDay"

    static const int kSCldrDay = 2;

    /**
     * Clears the field "sCldrDay".
     *
     * The field will be set to its default value. The hasSCldrDay()
     * method will return false.
     */
    inline void clearSCldrDay();

    /**
     * Checks whether the field "sCldrDay" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSCldrDay()). Otherwise it will return false.
     */
    inline bool hasSCldrDay () const;

    /**
     * Returns the value of the member "sCldrDay".
     *
     * Identifies the calendar day; 00 = unknown calendar day.
     *
     * @return The value of the field "sCldrDay"
     */
    inline const ::fi_basetypes_most::T_String& getSCldrDay () const;

    /**
     * Retrieves the value of the field "sCldrDay" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sCldrDay".
     */
    inline ::fi_basetypes_most::T_String& getSCldrDayMutable ();

    /**
     * Sets the value of the member "sCldrDay".
     *
     * Identifies the calendar day; 00 = unknown calendar day.
     *
     * @param sCldrDay The value which will be set
     */
    inline void setSCldrDay (const ::fi_basetypes_most::T_String& sCldrDay_);

    static const T_PhonBkCallDate &getDefaultInstance();

private:

    inline void set_has_sCldrYear ();

    inline void clear_has_sCldrYear ();

    inline void set_has_sCldrMonth ();

    inline void clear_has_sCldrMonth ();

    inline void set_has_sCldrDay ();

    inline void clear_has_sCldrDay ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::fi_basetypes_most::T_String _sCldrYear;

    ::fi_basetypes_most::T_String _sCldrMonth;

    ::fi_basetypes_most::T_String _sCldrDay;

};

class T_PhonBkCallTime {
public:

    /**
     * Default constructor
     */
    inline  T_PhonBkCallTime ();

    /**
     * Copy constructor
     */
    inline  T_PhonBkCallTime (const T_PhonBkCallTime &rhs);

    /**
     * All fields constructor
     */
    inline  T_PhonBkCallTime (const ::fi_basetypes_most::T_String& sHours_, const ::fi_basetypes_most::T_String& sMinutes_, const ::fi_basetypes_most::T_String& sSeconds_);

    /**
     * Destructor
     */
    inline  ~T_PhonBkCallTime();

    /**
     * Assignment operator
     */
    inline T_PhonBkCallTime& operator = (const T_PhonBkCallTime& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_PhonBkCallTime& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_PhonBkCallTime& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_PhonBkCallTime& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_PhonBkCallTime& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sHours"

    static const int kSHours = 0;

    /**
     * Clears the field "sHours".
     *
     * The field will be set to its default value. The hasSHours()
     * method will return false.
     */
    inline void clearSHours();

    /**
     * Checks whether the field "sHours" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSHours()). Otherwise it will return false.
     */
    inline bool hasSHours () const;

    /**
     * Returns the value of the member "sHours".
     *
     * Identifies the hour. Formated as 24 hour mode; 99 = unknown.
     *
     * @return The value of the field "sHours"
     */
    inline const ::fi_basetypes_most::T_String& getSHours () const;

    /**
     * Retrieves the value of the field "sHours" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sHours".
     */
    inline ::fi_basetypes_most::T_String& getSHoursMutable ();

    /**
     * Sets the value of the member "sHours".
     *
     * Identifies the hour. Formated as 24 hour mode; 99 = unknown.
     *
     * @param sHours The value which will be set
     */
    inline void setSHours (const ::fi_basetypes_most::T_String& sHours_);

    // API of field "sMinutes"

    static const int kSMinutes = 1;

    /**
     * Clears the field "sMinutes".
     *
     * The field will be set to its default value. The hasSMinutes()
     * method will return false.
     */
    inline void clearSMinutes();

    /**
     * Checks whether the field "sMinutes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSMinutes()). Otherwise it will return false.
     */
    inline bool hasSMinutes () const;

    /**
     * Returns the value of the member "sMinutes".
     *
     * Identifies the minutes; 99 = unknown.
     *
     * @return The value of the field "sMinutes"
     */
    inline const ::fi_basetypes_most::T_String& getSMinutes () const;

    /**
     * Retrieves the value of the field "sMinutes" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sMinutes".
     */
    inline ::fi_basetypes_most::T_String& getSMinutesMutable ();

    /**
     * Sets the value of the member "sMinutes".
     *
     * Identifies the minutes; 99 = unknown.
     *
     * @param sMinutes The value which will be set
     */
    inline void setSMinutes (const ::fi_basetypes_most::T_String& sMinutes_);

    // API of field "sSeconds"

    static const int kSSeconds = 2;

    /**
     * Clears the field "sSeconds".
     *
     * The field will be set to its default value. The hasSSeconds()
     * method will return false.
     */
    inline void clearSSeconds();

    /**
     * Checks whether the field "sSeconds" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSSeconds()). Otherwise it will return false.
     */
    inline bool hasSSeconds () const;

    /**
     * Returns the value of the member "sSeconds".
     *
     * Identifies the seconds; 99 = unknown.
     *
     * @return The value of the field "sSeconds"
     */
    inline const ::fi_basetypes_most::T_String& getSSeconds () const;

    /**
     * Retrieves the value of the field "sSeconds" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sSeconds".
     */
    inline ::fi_basetypes_most::T_String& getSSecondsMutable ();

    /**
     * Sets the value of the member "sSeconds".
     *
     * Identifies the seconds; 99 = unknown.
     *
     * @param sSeconds The value which will be set
     */
    inline void setSSeconds (const ::fi_basetypes_most::T_String& sSeconds_);

    static const T_PhonBkCallTime &getDefaultInstance();

private:

    inline void set_has_sHours ();

    inline void clear_has_sHours ();

    inline void set_has_sMinutes ();

    inline void clear_has_sMinutes ();

    inline void set_has_sSeconds ();

    inline void clear_has_sSeconds ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::fi_basetypes_most::T_String _sHours;

    ::fi_basetypes_most::T_String _sMinutes;

    ::fi_basetypes_most::T_String _sSeconds;

};

class T_PhonBkCallDateTime {
public:

    /**
     * Default constructor
     */
    inline  T_PhonBkCallDateTime ();

    /**
     * Copy constructor
     */
    inline  T_PhonBkCallDateTime (const T_PhonBkCallDateTime &rhs);

    /**
     * All fields constructor
     */
    inline  T_PhonBkCallDateTime (const T_PhonBkCallDate& oCallDate_, const T_PhonBkCallTime& oCallTime_);

    /**
     * Destructor
     */
    inline  ~T_PhonBkCallDateTime();

    /**
     * Assignment operator
     */
    inline T_PhonBkCallDateTime& operator = (const T_PhonBkCallDateTime& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_PhonBkCallDateTime& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_PhonBkCallDateTime& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_PhonBkCallDateTime& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_PhonBkCallDateTime& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oCallDate"

    static const int kOCallDate = 0;

    /**
     * Clears the field "oCallDate".
     *
     * The field will be set to its default value. The hasOCallDate()
     * method will return false.
     */
    inline void clearOCallDate();

    /**
     * Checks whether the field "oCallDate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOCallDate()). Otherwise it will return false.
     */
    inline bool hasOCallDate () const;

    /**
     * Returns the value of the member "oCallDate".
     *
     * Date of the call.Formatted as YYYYMMDD where YYYY = CldrYear; MM = CldrMonth; DD = CldrDay
     *
     * @return The value of the field "oCallDate"
     */
    inline const T_PhonBkCallDate& getOCallDate () const;

    /**
     * Retrieves the value of the field "oCallDate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oCallDate".
     */
    inline T_PhonBkCallDate& getOCallDateMutable ();

    /**
     * Sets the value of the member "oCallDate".
     *
     * Date of the call.Formatted as YYYYMMDD where YYYY = CldrYear; MM = CldrMonth; DD = CldrDay
     *
     * @param oCallDate The value which will be set
     */
    inline void setOCallDate (const T_PhonBkCallDate& oCallDate_);

    // API of field "oCallTime"

    static const int kOCallTime = 1;

    /**
     * Clears the field "oCallTime".
     *
     * The field will be set to its default value. The hasOCallTime()
     * method will return false.
     */
    inline void clearOCallTime();

    /**
     * Checks whether the field "oCallTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOCallTime()). Otherwise it will return false.
     */
    inline bool hasOCallTime () const;

    /**
     * Returns the value of the member "oCallTime".
     *
     * Time of the call.Formated as 24 hour mode.Formatted as HHMMSS where HH = Hours; MM = Minutes; SS = Seconds.
     *
     * @return The value of the field "oCallTime"
     */
    inline const T_PhonBkCallTime& getOCallTime () const;

    /**
     * Retrieves the value of the field "oCallTime" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oCallTime".
     */
    inline T_PhonBkCallTime& getOCallTimeMutable ();

    /**
     * Sets the value of the member "oCallTime".
     *
     * Time of the call.Formated as 24 hour mode.Formatted as HHMMSS where HH = Hours; MM = Minutes; SS = Seconds.
     *
     * @param oCallTime The value which will be set
     */
    inline void setOCallTime (const T_PhonBkCallTime& oCallTime_);

    static const T_PhonBkCallDateTime &getDefaultInstance();

private:

    inline void set_has_oCallDate ();

    inline void clear_has_oCallDate ();

    inline void set_has_oCallTime ();

    inline void clear_has_oCallTime ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_PhonBkCallDate _oCallDate;

    T_PhonBkCallTime _oCallTime;

};

class T_PhonBkCallHistoryListSliceResultItem {
public:

    /**
     * Default constructor
     */
    inline  T_PhonBkCallHistoryListSliceResultItem ();

    /**
     * Copy constructor
     */
    inline  T_PhonBkCallHistoryListSliceResultItem (const T_PhonBkCallHistoryListSliceResultItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_PhonBkCallHistoryListSliceResultItem (uint32 u32ContactHandle_, const ::fi_basetypes_most::T_String& sFirstName_, const ::fi_basetypes_most::T_String& sLastName_, const ::fi_basetypes_most::T_String& sPhoneNumber_, T_e8_PhonBkCallPhoneType e8CallPhoneType_, T_e8_PhonBkCallHistoryType e8CallHistoryType_, const T_PhonBkCallDateTime& oCallDateTime_);

    /**
     * Destructor
     */
    inline  ~T_PhonBkCallHistoryListSliceResultItem();

    /**
     * Assignment operator
     */
    inline T_PhonBkCallHistoryListSliceResultItem& operator = (const T_PhonBkCallHistoryListSliceResultItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_PhonBkCallHistoryListSliceResultItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_PhonBkCallHistoryListSliceResultItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_PhonBkCallHistoryListSliceResultItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_PhonBkCallHistoryListSliceResultItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32ContactHandle"

    static const int kU32ContactHandle = 0;

    /**
     * Clears the field "u32ContactHandle".
     *
     * The field will be set to its default value. The hasU32ContactHandle()
     * method will return false.
     */
    inline void clearU32ContactHandle();

    /**
     * Checks whether the field "u32ContactHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ContactHandle()). Otherwise it will return false.
     */
    inline bool hasU32ContactHandle () const;

    /**
     * Returns the value of the member "u32ContactHandle".
     *
     * This is the globally unique ID for a particular contact. The ID is unique across all currently connected devices.
     *
     * @return The value of the field "u32ContactHandle"
     */
    inline uint32 getU32ContactHandle () const;

    /**
     * Sets the value of the member "u32ContactHandle".
     *
     * This is the globally unique ID for a particular contact. The ID is unique across all currently connected devices.
     *
     * @param u32ContactHandle The value which will be set
     */
    inline void setU32ContactHandle (uint32 u32ContactHandle_);

    // API of field "sFirstName"

    static const int kSFirstName = 1;

    /**
     * Clears the field "sFirstName".
     *
     * The field will be set to its default value. The hasSFirstName()
     * method will return false.
     */
    inline void clearSFirstName();

    /**
     * Checks whether the field "sFirstName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSFirstName()). Otherwise it will return false.
     */
    inline bool hasSFirstName () const;

    /**
     * Returns the value of the member "sFirstName".
     *
     *
     *
     * @return The value of the field "sFirstName"
     */
    inline const ::fi_basetypes_most::T_String& getSFirstName () const;

    /**
     * Retrieves the value of the field "sFirstName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sFirstName".
     */
    inline ::fi_basetypes_most::T_String& getSFirstNameMutable ();

    /**
     * Sets the value of the member "sFirstName".
     *
     *
     *
     * @param sFirstName The value which will be set
     */
    inline void setSFirstName (const ::fi_basetypes_most::T_String& sFirstName_);

    // API of field "sLastName"

    static const int kSLastName = 2;

    /**
     * Clears the field "sLastName".
     *
     * The field will be set to its default value. The hasSLastName()
     * method will return false.
     */
    inline void clearSLastName();

    /**
     * Checks whether the field "sLastName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSLastName()). Otherwise it will return false.
     */
    inline bool hasSLastName () const;

    /**
     * Returns the value of the member "sLastName".
     *
     *
     *
     * @return The value of the field "sLastName"
     */
    inline const ::fi_basetypes_most::T_String& getSLastName () const;

    /**
     * Retrieves the value of the field "sLastName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sLastName".
     */
    inline ::fi_basetypes_most::T_String& getSLastNameMutable ();

    /**
     * Sets the value of the member "sLastName".
     *
     *
     *
     * @param sLastName The value which will be set
     */
    inline void setSLastName (const ::fi_basetypes_most::T_String& sLastName_);

    // API of field "sPhoneNumber"

    static const int kSPhoneNumber = 3;

    /**
     * Clears the field "sPhoneNumber".
     *
     * The field will be set to its default value. The hasSPhoneNumber()
     * method will return false.
     */
    inline void clearSPhoneNumber();

    /**
     * Checks whether the field "sPhoneNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSPhoneNumber()). Otherwise it will return false.
     */
    inline bool hasSPhoneNumber () const;

    /**
     * Returns the value of the member "sPhoneNumber".
     *
     *
     *
     * @return The value of the field "sPhoneNumber"
     */
    inline const ::fi_basetypes_most::T_String& getSPhoneNumber () const;

    /**
     * Retrieves the value of the field "sPhoneNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sPhoneNumber".
     */
    inline ::fi_basetypes_most::T_String& getSPhoneNumberMutable ();

    /**
     * Sets the value of the member "sPhoneNumber".
     *
     *
     *
     * @param sPhoneNumber The value which will be set
     */
    inline void setSPhoneNumber (const ::fi_basetypes_most::T_String& sPhoneNumber_);

    // API of field "e8CallPhoneType"

    static const int kE8CallPhoneType = 4;

    /**
     * Clears the field "e8CallPhoneType".
     *
     * The field will be set to its default value. The hasE8CallPhoneType()
     * method will return false.
     */
    inline void clearE8CallPhoneType();

    /**
     * Checks whether the field "e8CallPhoneType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8CallPhoneType()). Otherwise it will return false.
     */
    inline bool hasE8CallPhoneType () const;

    /**
     * Returns the value of the member "e8CallPhoneType".
     *
     * The phone type of the call (i.e. cell, work, home, other, unknown)
     *
     * @return The value of the field "e8CallPhoneType"
     */
    inline T_e8_PhonBkCallPhoneType getE8CallPhoneType () const;

    /**
     * Sets the value of the member "e8CallPhoneType".
     *
     * The phone type of the call (i.e. cell, work, home, other, unknown)
     *
     * @param e8CallPhoneType The value which will be set
     */
    inline void setE8CallPhoneType (T_e8_PhonBkCallPhoneType e8CallPhoneType_);

    // API of field "e8CallHistoryType"

    static const int kE8CallHistoryType = 5;

    /**
     * Clears the field "e8CallHistoryType".
     *
     * The field will be set to its default value. The hasE8CallHistoryType()
     * method will return false.
     */
    inline void clearE8CallHistoryType();

    /**
     * Checks whether the field "e8CallHistoryType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8CallHistoryType()). Otherwise it will return false.
     */
    inline bool hasE8CallHistoryType () const;

    /**
     * Returns the value of the member "e8CallHistoryType".
     *
     * Type of recent call or call history list.
     *
     * @return The value of the field "e8CallHistoryType"
     */
    inline T_e8_PhonBkCallHistoryType getE8CallHistoryType () const;

    /**
     * Sets the value of the member "e8CallHistoryType".
     *
     * Type of recent call or call history list.
     *
     * @param e8CallHistoryType The value which will be set
     */
    inline void setE8CallHistoryType (T_e8_PhonBkCallHistoryType e8CallHistoryType_);

    // API of field "oCallDateTime"

    static const int kOCallDateTime = 6;

    /**
     * Clears the field "oCallDateTime".
     *
     * The field will be set to its default value. The hasOCallDateTime()
     * method will return false.
     */
    inline void clearOCallDateTime();

    /**
     * Checks whether the field "oCallDateTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOCallDateTime()). Otherwise it will return false.
     */
    inline bool hasOCallDateTime () const;

    /**
     * Returns the value of the member "oCallDateTime".
     *
     * The call date and time formatted as YYYYMMDDHHMMSS. The CallDateTime is made up of the CallDate stream and the CallTime stream.
     *
     * @return The value of the field "oCallDateTime"
     */
    inline const T_PhonBkCallDateTime& getOCallDateTime () const;

    /**
     * Retrieves the value of the field "oCallDateTime" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oCallDateTime".
     */
    inline T_PhonBkCallDateTime& getOCallDateTimeMutable ();

    /**
     * Sets the value of the member "oCallDateTime".
     *
     * The call date and time formatted as YYYYMMDDHHMMSS. The CallDateTime is made up of the CallDate stream and the CallTime stream.
     *
     * @param oCallDateTime The value which will be set
     */
    inline void setOCallDateTime (const T_PhonBkCallDateTime& oCallDateTime_);

    static const T_PhonBkCallHistoryListSliceResultItem &getDefaultInstance();

private:

    inline void set_has_u32ContactHandle ();

    inline void clear_has_u32ContactHandle ();

    inline void set_has_sFirstName ();

    inline void clear_has_sFirstName ();

    inline void set_has_sLastName ();

    inline void clear_has_sLastName ();

    inline void set_has_sPhoneNumber ();

    inline void clear_has_sPhoneNumber ();

    inline void set_has_e8CallPhoneType ();

    inline void clear_has_e8CallPhoneType ();

    inline void set_has_e8CallHistoryType ();

    inline void clear_has_e8CallHistoryType ();

    inline void set_has_oCallDateTime ();

    inline void clear_has_oCallDateTime ();

    uint32 _has_bits_[ (7 + 31) / 32];

    uint32 _u32ContactHandle;

    ::fi_basetypes_most::T_String _sFirstName;

    ::fi_basetypes_most::T_String _sLastName;

    ::fi_basetypes_most::T_String _sPhoneNumber;

    T_e8_PhonBkCallPhoneType _e8CallPhoneType;

    T_e8_PhonBkCallHistoryType _e8CallHistoryType;

    T_PhonBkCallDateTime _oCallDateTime;

};

class T_PhonBkCallHistoryTypeSupport {
public:

    /**
     * Default constructor
     */
    inline  T_PhonBkCallHistoryTypeSupport ();

    /**
     * Copy constructor
     */
    inline  T_PhonBkCallHistoryTypeSupport (const T_PhonBkCallHistoryTypeSupport &rhs);

    /**
     * All fields constructor
     */
    inline  T_PhonBkCallHistoryTypeSupport (bool bCCHSupport_, bool bMCHSupport_, bool bICHSupport_, bool bOCHSupport_);

    /**
     * Destructor
     */
    inline  ~T_PhonBkCallHistoryTypeSupport();

    /**
     * Assignment operator
     */
    inline T_PhonBkCallHistoryTypeSupport& operator = (const T_PhonBkCallHistoryTypeSupport& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_PhonBkCallHistoryTypeSupport& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_PhonBkCallHistoryTypeSupport& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_PhonBkCallHistoryTypeSupport& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_PhonBkCallHistoryTypeSupport& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bCCHSupport"

    static const int kBCCHSupport = 0;

    /**
     * Clears the field "bCCHSupport".
     *
     * The field will be set to its default value. The hasBCCHSupport()
     * method will return false.
     */
    inline void clearBCCHSupport();

    /**
     * Checks whether the field "bCCHSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBCCHSupport()). Otherwise it will return false.
     */
    inline bool hasBCCHSupport () const;

    /**
     * Returns the value of the member "bCCHSupport".
     *
     * Identifies if the device supports the Combined Call History list.
     *
     * @return The value of the field "bCCHSupport"
     */
    inline bool getBCCHSupport () const;

    /**
     * Sets the value of the member "bCCHSupport".
     *
     * Identifies if the device supports the Combined Call History list.
     *
     * @param bCCHSupport The value which will be set
     */
    inline void setBCCHSupport (bool bCCHSupport_);

    // API of field "bMCHSupport"

    static const int kBMCHSupport = 1;

    /**
     * Clears the field "bMCHSupport".
     *
     * The field will be set to its default value. The hasBMCHSupport()
     * method will return false.
     */
    inline void clearBMCHSupport();

    /**
     * Checks whether the field "bMCHSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBMCHSupport()). Otherwise it will return false.
     */
    inline bool hasBMCHSupport () const;

    /**
     * Returns the value of the member "bMCHSupport".
     *
     * Identifies if the device supports the Missed Call History list.
     *
     * @return The value of the field "bMCHSupport"
     */
    inline bool getBMCHSupport () const;

    /**
     * Sets the value of the member "bMCHSupport".
     *
     * Identifies if the device supports the Missed Call History list.
     *
     * @param bMCHSupport The value which will be set
     */
    inline void setBMCHSupport (bool bMCHSupport_);

    // API of field "bICHSupport"

    static const int kBICHSupport = 2;

    /**
     * Clears the field "bICHSupport".
     *
     * The field will be set to its default value. The hasBICHSupport()
     * method will return false.
     */
    inline void clearBICHSupport();

    /**
     * Checks whether the field "bICHSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBICHSupport()). Otherwise it will return false.
     */
    inline bool hasBICHSupport () const;

    /**
     * Returns the value of the member "bICHSupport".
     *
     * Identifies if the device supports the Incoming Call History list.
     *
     * @return The value of the field "bICHSupport"
     */
    inline bool getBICHSupport () const;

    /**
     * Sets the value of the member "bICHSupport".
     *
     * Identifies if the device supports the Incoming Call History list.
     *
     * @param bICHSupport The value which will be set
     */
    inline void setBICHSupport (bool bICHSupport_);

    // API of field "bOCHSupport"

    static const int kBOCHSupport = 3;

    /**
     * Clears the field "bOCHSupport".
     *
     * The field will be set to its default value. The hasBOCHSupport()
     * method will return false.
     */
    inline void clearBOCHSupport();

    /**
     * Checks whether the field "bOCHSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBOCHSupport()). Otherwise it will return false.
     */
    inline bool hasBOCHSupport () const;

    /**
     * Returns the value of the member "bOCHSupport".
     *
     * Identifies if the device supports the Outgoing Call History list.
     *
     * @return The value of the field "bOCHSupport"
     */
    inline bool getBOCHSupport () const;

    /**
     * Sets the value of the member "bOCHSupport".
     *
     * Identifies if the device supports the Outgoing Call History list.
     *
     * @param bOCHSupport The value which will be set
     */
    inline void setBOCHSupport (bool bOCHSupport_);

    static const T_PhonBkCallHistoryTypeSupport &getDefaultInstance();

private:

    inline void set_has_bCCHSupport ();

    inline void clear_has_bCCHSupport ();

    inline void set_has_bMCHSupport ();

    inline void clear_has_bMCHSupport ();

    inline void set_has_bICHSupport ();

    inline void clear_has_bICHSupport ();

    inline void set_has_bOCHSupport ();

    inline void clear_has_bOCHSupport ();

    uint32 _has_bits_[ (4 + 31) / 32];

    bool _bCCHSupport;

    bool _bMCHSupport;

    bool _bICHSupport;

    bool _bOCHSupport;

};

class T_PhonBkAutocompleteMultipleMatchListItem {
public:

    /**
     * Default constructor
     */
    inline  T_PhonBkAutocompleteMultipleMatchListItem ();

    /**
     * Copy constructor
     */
    inline  T_PhonBkAutocompleteMultipleMatchListItem (const T_PhonBkAutocompleteMultipleMatchListItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_PhonBkAutocompleteMultipleMatchListItem (const ::fi_basetypes_most::T_String& sFirstName_, const ::fi_basetypes_most::T_String& sLastName_, const ::fi_basetypes_most::T_String& sPhoneNumber_);

    /**
     * Destructor
     */
    inline  ~T_PhonBkAutocompleteMultipleMatchListItem();

    /**
     * Assignment operator
     */
    inline T_PhonBkAutocompleteMultipleMatchListItem& operator = (const T_PhonBkAutocompleteMultipleMatchListItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_PhonBkAutocompleteMultipleMatchListItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_PhonBkAutocompleteMultipleMatchListItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_PhonBkAutocompleteMultipleMatchListItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_PhonBkAutocompleteMultipleMatchListItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sFirstName"

    static const int kSFirstName = 0;

    /**
     * Clears the field "sFirstName".
     *
     * The field will be set to its default value. The hasSFirstName()
     * method will return false.
     */
    inline void clearSFirstName();

    /**
     * Checks whether the field "sFirstName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSFirstName()). Otherwise it will return false.
     */
    inline bool hasSFirstName () const;

    /**
     * Returns the value of the member "sFirstName".
     *
     *
     *
     * @return The value of the field "sFirstName"
     */
    inline const ::fi_basetypes_most::T_String& getSFirstName () const;

    /**
     * Retrieves the value of the field "sFirstName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sFirstName".
     */
    inline ::fi_basetypes_most::T_String& getSFirstNameMutable ();

    /**
     * Sets the value of the member "sFirstName".
     *
     *
     *
     * @param sFirstName The value which will be set
     */
    inline void setSFirstName (const ::fi_basetypes_most::T_String& sFirstName_);

    // API of field "sLastName"

    static const int kSLastName = 1;

    /**
     * Clears the field "sLastName".
     *
     * The field will be set to its default value. The hasSLastName()
     * method will return false.
     */
    inline void clearSLastName();

    /**
     * Checks whether the field "sLastName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSLastName()). Otherwise it will return false.
     */
    inline bool hasSLastName () const;

    /**
     * Returns the value of the member "sLastName".
     *
     *
     *
     * @return The value of the field "sLastName"
     */
    inline const ::fi_basetypes_most::T_String& getSLastName () const;

    /**
     * Retrieves the value of the field "sLastName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sLastName".
     */
    inline ::fi_basetypes_most::T_String& getSLastNameMutable ();

    /**
     * Sets the value of the member "sLastName".
     *
     *
     *
     * @param sLastName The value which will be set
     */
    inline void setSLastName (const ::fi_basetypes_most::T_String& sLastName_);

    // API of field "sPhoneNumber"

    static const int kSPhoneNumber = 2;

    /**
     * Clears the field "sPhoneNumber".
     *
     * The field will be set to its default value. The hasSPhoneNumber()
     * method will return false.
     */
    inline void clearSPhoneNumber();

    /**
     * Checks whether the field "sPhoneNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSPhoneNumber()). Otherwise it will return false.
     */
    inline bool hasSPhoneNumber () const;

    /**
     * Returns the value of the member "sPhoneNumber".
     *
     *
     *
     * @return The value of the field "sPhoneNumber"
     */
    inline const ::fi_basetypes_most::T_String& getSPhoneNumber () const;

    /**
     * Retrieves the value of the field "sPhoneNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sPhoneNumber".
     */
    inline ::fi_basetypes_most::T_String& getSPhoneNumberMutable ();

    /**
     * Sets the value of the member "sPhoneNumber".
     *
     *
     *
     * @param sPhoneNumber The value which will be set
     */
    inline void setSPhoneNumber (const ::fi_basetypes_most::T_String& sPhoneNumber_);

    static const T_PhonBkAutocompleteMultipleMatchListItem &getDefaultInstance();

private:

    inline void set_has_sFirstName ();

    inline void clear_has_sFirstName ();

    inline void set_has_sLastName ();

    inline void clear_has_sLastName ();

    inline void set_has_sPhoneNumber ();

    inline void clear_has_sPhoneNumber ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::fi_basetypes_most::T_String _sFirstName;

    ::fi_basetypes_most::T_String _sLastName;

    ::fi_basetypes_most::T_String _sPhoneNumber;

};

class T_PhonBkPhoneBookListSliceResultItem {
public:

    /**
     * Default constructor
     */
    inline  T_PhonBkPhoneBookListSliceResultItem ();

    /**
     * Copy constructor
     */
    inline  T_PhonBkPhoneBookListSliceResultItem (const T_PhonBkPhoneBookListSliceResultItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_PhonBkPhoneBookListSliceResultItem (uint32 u32ContactHandle_, uint32 u32ContactNameTag_, const ::fi_basetypes_most::T_String& sFirstName_, const ::fi_basetypes_most::T_String& sLastName_, const ::fi_basetypes_most::T_String& sPOIName_, bool bQuickDial_, bool bQuickRoute_, bool bQuickText_);

    /**
     * Destructor
     */
    inline  ~T_PhonBkPhoneBookListSliceResultItem();

    /**
     * Assignment operator
     */
    inline T_PhonBkPhoneBookListSliceResultItem& operator = (const T_PhonBkPhoneBookListSliceResultItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_PhonBkPhoneBookListSliceResultItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_PhonBkPhoneBookListSliceResultItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_PhonBkPhoneBookListSliceResultItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_PhonBkPhoneBookListSliceResultItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32ContactHandle"

    static const int kU32ContactHandle = 0;

    /**
     * Clears the field "u32ContactHandle".
     *
     * The field will be set to its default value. The hasU32ContactHandle()
     * method will return false.
     */
    inline void clearU32ContactHandle();

    /**
     * Checks whether the field "u32ContactHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ContactHandle()). Otherwise it will return false.
     */
    inline bool hasU32ContactHandle () const;

    /**
     * Returns the value of the member "u32ContactHandle".
     *
     * This is the globally unique ID for a particular contact. The ID is unique across all currently connected devices.
     *
     * @return The value of the field "u32ContactHandle"
     */
    inline uint32 getU32ContactHandle () const;

    /**
     * Sets the value of the member "u32ContactHandle".
     *
     * This is the globally unique ID for a particular contact. The ID is unique across all currently connected devices.
     *
     * @param u32ContactHandle The value which will be set
     */
    inline void setU32ContactHandle (uint32 u32ContactHandle_);

    // API of field "u32ContactNameTag"

    static const int kU32ContactNameTag = 1;

    /**
     * Clears the field "u32ContactNameTag".
     *
     * The field will be set to its default value. The hasU32ContactNameTag()
     * method will return false.
     */
    inline void clearU32ContactNameTag();

    /**
     * Checks whether the field "u32ContactNameTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ContactNameTag()). Otherwise it will return false.
     */
    inline bool hasU32ContactNameTag () const;

    /**
     * Returns the value of the member "u32ContactNameTag".
     *
     * Unique tag identifies the contact name
     *
     * @return The value of the field "u32ContactNameTag"
     */
    inline uint32 getU32ContactNameTag () const;

    /**
     * Sets the value of the member "u32ContactNameTag".
     *
     * Unique tag identifies the contact name
     *
     * @param u32ContactNameTag The value which will be set
     */
    inline void setU32ContactNameTag (uint32 u32ContactNameTag_);

    // API of field "sFirstName"

    static const int kSFirstName = 2;

    /**
     * Clears the field "sFirstName".
     *
     * The field will be set to its default value. The hasSFirstName()
     * method will return false.
     */
    inline void clearSFirstName();

    /**
     * Checks whether the field "sFirstName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSFirstName()). Otherwise it will return false.
     */
    inline bool hasSFirstName () const;

    /**
     * Returns the value of the member "sFirstName".
     *
     *
     *
     * @return The value of the field "sFirstName"
     */
    inline const ::fi_basetypes_most::T_String& getSFirstName () const;

    /**
     * Retrieves the value of the field "sFirstName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sFirstName".
     */
    inline ::fi_basetypes_most::T_String& getSFirstNameMutable ();

    /**
     * Sets the value of the member "sFirstName".
     *
     *
     *
     * @param sFirstName The value which will be set
     */
    inline void setSFirstName (const ::fi_basetypes_most::T_String& sFirstName_);

    // API of field "sLastName"

    static const int kSLastName = 3;

    /**
     * Clears the field "sLastName".
     *
     * The field will be set to its default value. The hasSLastName()
     * method will return false.
     */
    inline void clearSLastName();

    /**
     * Checks whether the field "sLastName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSLastName()). Otherwise it will return false.
     */
    inline bool hasSLastName () const;

    /**
     * Returns the value of the member "sLastName".
     *
     *
     *
     * @return The value of the field "sLastName"
     */
    inline const ::fi_basetypes_most::T_String& getSLastName () const;

    /**
     * Retrieves the value of the field "sLastName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sLastName".
     */
    inline ::fi_basetypes_most::T_String& getSLastNameMutable ();

    /**
     * Sets the value of the member "sLastName".
     *
     *
     *
     * @param sLastName The value which will be set
     */
    inline void setSLastName (const ::fi_basetypes_most::T_String& sLastName_);

    // API of field "sPOIName"

    static const int kSPOIName = 4;

    /**
     * Clears the field "sPOIName".
     *
     * The field will be set to its default value. The hasSPOIName()
     * method will return false.
     */
    inline void clearSPOIName();

    /**
     * Checks whether the field "sPOIName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSPOIName()). Otherwise it will return false.
     */
    inline bool hasSPOIName () const;

    /**
     * Returns the value of the member "sPOIName".
     *
     *
     *
     * @return The value of the field "sPOIName"
     */
    inline const ::fi_basetypes_most::T_String& getSPOIName () const;

    /**
     * Retrieves the value of the field "sPOIName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sPOIName".
     */
    inline ::fi_basetypes_most::T_String& getSPOINameMutable ();

    /**
     * Sets the value of the member "sPOIName".
     *
     *
     *
     * @param sPOIName The value which will be set
     */
    inline void setSPOIName (const ::fi_basetypes_most::T_String& sPOIName_);

    // API of field "bQuickDial"

    static const int kBQuickDial = 5;

    /**
     * Clears the field "bQuickDial".
     *
     * The field will be set to its default value. The hasBQuickDial()
     * method will return false.
     */
    inline void clearBQuickDial();

    /**
     * Checks whether the field "bQuickDial" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBQuickDial()). Otherwise it will return false.
     */
    inline bool hasBQuickDial () const;

    /**
     * Returns the value of the member "bQuickDial".
     *
     * This parameter shall be set to True if a contact has only one number associated with it or the contact has a preferred number.  False otherwise
     *
     * @return The value of the field "bQuickDial"
     */
    inline bool getBQuickDial () const;

    /**
     * Sets the value of the member "bQuickDial".
     *
     * This parameter shall be set to True if a contact has only one number associated with it or the contact has a preferred number.  False otherwise
     *
     * @param bQuickDial The value which will be set
     */
    inline void setBQuickDial (bool bQuickDial_);

    // API of field "bQuickRoute"

    static const int kBQuickRoute = 6;

    /**
     * Clears the field "bQuickRoute".
     *
     * The field will be set to its default value. The hasBQuickRoute()
     * method will return false.
     */
    inline void clearBQuickRoute();

    /**
     * Checks whether the field "bQuickRoute" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBQuickRoute()). Otherwise it will return false.
     */
    inline bool hasBQuickRoute () const;

    /**
     * Returns the value of the member "bQuickRoute".
     *
     * This parameter shall be set to True if a single address is associated with this contact.  Used within HMI controllers to show features such as a QuickRoute icon that can be used to automatically navigate to this address.  False if no address or more than one address is associated with this contact.
     *
     * @return The value of the field "bQuickRoute"
     */
    inline bool getBQuickRoute () const;

    /**
     * Sets the value of the member "bQuickRoute".
     *
     * This parameter shall be set to True if a single address is associated with this contact.  Used within HMI controllers to show features such as a QuickRoute icon that can be used to automatically navigate to this address.  False if no address or more than one address is associated with this contact.
     *
     * @param bQuickRoute The value which will be set
     */
    inline void setBQuickRoute (bool bQuickRoute_);

    // API of field "bQuickText"

    static const int kBQuickText = 7;

    /**
     * Clears the field "bQuickText".
     *
     * The field will be set to its default value. The hasBQuickText()
     * method will return false.
     */
    inline void clearBQuickText();

    /**
     * Checks whether the field "bQuickText" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBQuickText()). Otherwise it will return false.
     */
    inline bool hasBQuickText () const;

    /**
     * Returns the value of the member "bQuickText".
     *
     * This parameter shall be set to True if a contact has only one number associated with it or the contact has a preferred number.  Used by HMI controllers to show a QuickText icon that allows the user to automatically go to a text message view.  False otherwise
     *
     * @return The value of the field "bQuickText"
     */
    inline bool getBQuickText () const;

    /**
     * Sets the value of the member "bQuickText".
     *
     * This parameter shall be set to True if a contact has only one number associated with it or the contact has a preferred number.  Used by HMI controllers to show a QuickText icon that allows the user to automatically go to a text message view.  False otherwise
     *
     * @param bQuickText The value which will be set
     */
    inline void setBQuickText (bool bQuickText_);

    static const T_PhonBkPhoneBookListSliceResultItem &getDefaultInstance();

private:

    inline void set_has_u32ContactHandle ();

    inline void clear_has_u32ContactHandle ();

    inline void set_has_u32ContactNameTag ();

    inline void clear_has_u32ContactNameTag ();

    inline void set_has_sFirstName ();

    inline void clear_has_sFirstName ();

    inline void set_has_sLastName ();

    inline void clear_has_sLastName ();

    inline void set_has_sPOIName ();

    inline void clear_has_sPOIName ();

    inline void set_has_bQuickDial ();

    inline void clear_has_bQuickDial ();

    inline void set_has_bQuickRoute ();

    inline void clear_has_bQuickRoute ();

    inline void set_has_bQuickText ();

    inline void clear_has_bQuickText ();

    uint32 _has_bits_[ (8 + 31) / 32];

    uint32 _u32ContactHandle;

    uint32 _u32ContactNameTag;

    ::fi_basetypes_most::T_String _sFirstName;

    ::fi_basetypes_most::T_String _sLastName;

    ::fi_basetypes_most::T_String _sPOIName;

    bool _bQuickDial;

    bool _bQuickRoute;

    bool _bQuickText;

};

class T_PhonBkDownloadStateStreamItem {
public:

    /**
     * Default constructor
     */
    inline  T_PhonBkDownloadStateStreamItem ();

    /**
     * Copy constructor
     */
    inline  T_PhonBkDownloadStateStreamItem (const T_PhonBkDownloadStateStreamItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_PhonBkDownloadStateStreamItem (uint8 u8DeviceHandle_, T_e8_PhonBkRecentCallListDownloadState e8RecentCallListDownloadState_, T_e8_PhonBkPhoneBookDownloadState e8PhoneBookDownloadState_);

    /**
     * Destructor
     */
    inline  ~T_PhonBkDownloadStateStreamItem();

    /**
     * Assignment operator
     */
    inline T_PhonBkDownloadStateStreamItem& operator = (const T_PhonBkDownloadStateStreamItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_PhonBkDownloadStateStreamItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_PhonBkDownloadStateStreamItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_PhonBkDownloadStateStreamItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_PhonBkDownloadStateStreamItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Handle of the device for the phone book source. The vehicle phone book has a DeviceHandle = 1.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Handle of the device for the phone book source. The vehicle phone book has a DeviceHandle = 1.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    // API of field "e8RecentCallListDownloadState"

    static const int kE8RecentCallListDownloadState = 1;

    /**
     * Clears the field "e8RecentCallListDownloadState".
     *
     * The field will be set to its default value. The hasE8RecentCallListDownloadState()
     * method will return false.
     */
    inline void clearE8RecentCallListDownloadState();

    /**
     * Checks whether the field "e8RecentCallListDownloadState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8RecentCallListDownloadState()). Otherwise it will return false.
     */
    inline bool hasE8RecentCallListDownloadState () const;

    /**
     * Returns the value of the member "e8RecentCallListDownloadState".
     *
     * This is the state of the recent call list download.
     *
     * @return The value of the field "e8RecentCallListDownloadState"
     */
    inline T_e8_PhonBkRecentCallListDownloadState getE8RecentCallListDownloadState () const;

    /**
     * Sets the value of the member "e8RecentCallListDownloadState".
     *
     * This is the state of the recent call list download.
     *
     * @param e8RecentCallListDownloadState The value which will be set
     */
    inline void setE8RecentCallListDownloadState (T_e8_PhonBkRecentCallListDownloadState e8RecentCallListDownloadState_);

    // API of field "e8PhoneBookDownloadState"

    static const int kE8PhoneBookDownloadState = 2;

    /**
     * Clears the field "e8PhoneBookDownloadState".
     *
     * The field will be set to its default value. The hasE8PhoneBookDownloadState()
     * method will return false.
     */
    inline void clearE8PhoneBookDownloadState();

    /**
     * Checks whether the field "e8PhoneBookDownloadState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8PhoneBookDownloadState()). Otherwise it will return false.
     */
    inline bool hasE8PhoneBookDownloadState () const;

    /**
     * Returns the value of the member "e8PhoneBookDownloadState".
     *
     * This is the state of the phone book download.
     *
     * @return The value of the field "e8PhoneBookDownloadState"
     */
    inline T_e8_PhonBkPhoneBookDownloadState getE8PhoneBookDownloadState () const;

    /**
     * Sets the value of the member "e8PhoneBookDownloadState".
     *
     * This is the state of the phone book download.
     *
     * @param e8PhoneBookDownloadState The value which will be set
     */
    inline void setE8PhoneBookDownloadState (T_e8_PhonBkPhoneBookDownloadState e8PhoneBookDownloadState_);

    static const T_PhonBkDownloadStateStreamItem &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    inline void set_has_e8RecentCallListDownloadState ();

    inline void clear_has_e8RecentCallListDownloadState ();

    inline void set_has_e8PhoneBookDownloadState ();

    inline void clear_has_e8PhoneBookDownloadState ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _u8DeviceHandle;

    T_e8_PhonBkRecentCallListDownloadState _e8RecentCallListDownloadState;

    T_e8_PhonBkPhoneBookDownloadState _e8PhoneBookDownloadState;

};

inline  T_PhonBkSearchKeyboardListItem::T_PhonBkSearchKeyboardListItem ()  :
    _sSearchKeyboardLetter (),
    _bLetterAvailable (false),
    _u32LetterStartIndex (0u),
    _u32LetterEndIndex (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_PhonBkSearchKeyboardListItem::T_PhonBkSearchKeyboardListItem (const T_PhonBkSearchKeyboardListItem &rhs)  :
    _sSearchKeyboardLetter (),
    _bLetterAvailable (false),
    _u32LetterStartIndex (0u),
    _u32LetterEndIndex (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_PhonBkSearchKeyboardListItem::T_PhonBkSearchKeyboardListItem (const ::fi_basetypes_most::T_String& sSearchKeyboardLetter_, bool bLetterAvailable_, uint32 u32LetterStartIndex_, uint32 u32LetterEndIndex_)  :
    _sSearchKeyboardLetter (sSearchKeyboardLetter_),
    _bLetterAvailable (bLetterAvailable_),
    _u32LetterStartIndex (u32LetterStartIndex_),
    _u32LetterEndIndex (u32LetterEndIndex_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sSearchKeyboardLetter_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_PhonBkSearchKeyboardListItem::~T_PhonBkSearchKeyboardListItem() {
}

inline T_PhonBkSearchKeyboardListItem& T_PhonBkSearchKeyboardListItem::operator = (const T_PhonBkSearchKeyboardListItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSSearchKeyboardLetter()) {
            setSSearchKeyboardLetter(rhs.getSSearchKeyboardLetter());
        } else {
            clearSSearchKeyboardLetter();
        }
        if (rhs.hasBLetterAvailable()) {
            setBLetterAvailable(rhs.getBLetterAvailable());
        } else {
            clearBLetterAvailable();
        }
        if (rhs.hasU32LetterStartIndex()) {
            setU32LetterStartIndex(rhs.getU32LetterStartIndex());
        } else {
            clearU32LetterStartIndex();
        }
        if (rhs.hasU32LetterEndIndex()) {
            setU32LetterEndIndex(rhs.getU32LetterEndIndex());
        } else {
            clearU32LetterEndIndex();
        }
    }
    return *this;
}

inline bool T_PhonBkSearchKeyboardListItem::operator == (const T_PhonBkSearchKeyboardListItem& rhs) const {
    return (((!hasSSearchKeyboardLetter() && !rhs.hasSSearchKeyboardLetter()) || getSSearchKeyboardLetter() == rhs.getSSearchKeyboardLetter()) &&
        ((!hasBLetterAvailable() && !rhs.hasBLetterAvailable()) || getBLetterAvailable() == rhs.getBLetterAvailable()) &&
        ((!hasU32LetterStartIndex() && !rhs.hasU32LetterStartIndex()) || getU32LetterStartIndex() == rhs.getU32LetterStartIndex()) &&
        ((!hasU32LetterEndIndex() && !rhs.hasU32LetterEndIndex()) || getU32LetterEndIndex() == rhs.getU32LetterEndIndex()));
}

inline bool T_PhonBkSearchKeyboardListItem::operator != (const T_PhonBkSearchKeyboardListItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_PhonBkSearchKeyboardListItem::operator < (const T_PhonBkSearchKeyboardListItem& rhs) const {
    if (hasSSearchKeyboardLetter() || rhs.hasSSearchKeyboardLetter()) {
        if (getSSearchKeyboardLetter() < rhs.getSSearchKeyboardLetter()) return true;
        if (getSSearchKeyboardLetter() > rhs.getSSearchKeyboardLetter()) return false;
    }
    if (hasBLetterAvailable() || rhs.hasBLetterAvailable()) {
        if (getBLetterAvailable() < rhs.getBLetterAvailable()) return true;
        if (getBLetterAvailable() > rhs.getBLetterAvailable()) return false;
    }
    if (hasU32LetterStartIndex() || rhs.hasU32LetterStartIndex()) {
        if (getU32LetterStartIndex() < rhs.getU32LetterStartIndex()) return true;
        if (getU32LetterStartIndex() > rhs.getU32LetterStartIndex()) return false;
    }
    if (hasU32LetterEndIndex() || rhs.hasU32LetterEndIndex()) {
        if (getU32LetterEndIndex() < rhs.getU32LetterEndIndex()) return true;
        if (getU32LetterEndIndex() > rhs.getU32LetterEndIndex()) return false;
    }
    return false;
}

inline bool T_PhonBkSearchKeyboardListItem::operator > (const T_PhonBkSearchKeyboardListItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_PhonBkSearchKeyboardListItem::clear() {
    clearSSearchKeyboardLetter();
    clearBLetterAvailable();
    clearU32LetterStartIndex();
    clearU32LetterEndIndex();
}

inline void T_PhonBkSearchKeyboardListItem::clearSSearchKeyboardLetter() {
    if (hasSSearchKeyboardLetter()) {
         clear_has_sSearchKeyboardLetter();
        _sSearchKeyboardLetter.clear();
     }
}

inline bool T_PhonBkSearchKeyboardListItem::hasSSearchKeyboardLetter () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_PhonBkSearchKeyboardListItem::getSSearchKeyboardLetter () const {
    return _sSearchKeyboardLetter;
}

inline ::fi_basetypes_most::T_String& T_PhonBkSearchKeyboardListItem::getSSearchKeyboardLetterMutable () {
    set_has_sSearchKeyboardLetter();
    return _sSearchKeyboardLetter;
}

inline void T_PhonBkSearchKeyboardListItem::setSSearchKeyboardLetter (const ::fi_basetypes_most::T_String& sSearchKeyboardLetter_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sSearchKeyboardLetter_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sSearchKeyboardLetter();
    this->_sSearchKeyboardLetter = sSearchKeyboardLetter_;
}

inline void T_PhonBkSearchKeyboardListItem::clearBLetterAvailable() {
    if (hasBLetterAvailable()) {
         clear_has_bLetterAvailable();
        _bLetterAvailable = false;
     }
}

inline bool T_PhonBkSearchKeyboardListItem::hasBLetterAvailable () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool T_PhonBkSearchKeyboardListItem::getBLetterAvailable () const {
    return _bLetterAvailable;
}

inline void T_PhonBkSearchKeyboardListItem::setBLetterAvailable (bool bLetterAvailable_) {
    set_has_bLetterAvailable();
    this->_bLetterAvailable = bLetterAvailable_;
}

inline void T_PhonBkSearchKeyboardListItem::clearU32LetterStartIndex() {
    if (hasU32LetterStartIndex()) {
         clear_has_u32LetterStartIndex();
        _u32LetterStartIndex = 0u;
     }
}

inline bool T_PhonBkSearchKeyboardListItem::hasU32LetterStartIndex () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 T_PhonBkSearchKeyboardListItem::getU32LetterStartIndex () const {
    return _u32LetterStartIndex;
}

inline void T_PhonBkSearchKeyboardListItem::setU32LetterStartIndex (uint32 u32LetterStartIndex_) {
    set_has_u32LetterStartIndex();
    this->_u32LetterStartIndex = u32LetterStartIndex_;
}

inline void T_PhonBkSearchKeyboardListItem::clearU32LetterEndIndex() {
    if (hasU32LetterEndIndex()) {
         clear_has_u32LetterEndIndex();
        _u32LetterEndIndex = 0u;
     }
}

inline bool T_PhonBkSearchKeyboardListItem::hasU32LetterEndIndex () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 T_PhonBkSearchKeyboardListItem::getU32LetterEndIndex () const {
    return _u32LetterEndIndex;
}

inline void T_PhonBkSearchKeyboardListItem::setU32LetterEndIndex (uint32 u32LetterEndIndex_) {
    set_has_u32LetterEndIndex();
    this->_u32LetterEndIndex = u32LetterEndIndex_;
}

inline void T_PhonBkSearchKeyboardListItem::set_has_sSearchKeyboardLetter () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_PhonBkSearchKeyboardListItem::clear_has_sSearchKeyboardLetter () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_PhonBkSearchKeyboardListItem::set_has_bLetterAvailable () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_PhonBkSearchKeyboardListItem::clear_has_bLetterAvailable () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_PhonBkSearchKeyboardListItem::set_has_u32LetterStartIndex () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_PhonBkSearchKeyboardListItem::clear_has_u32LetterStartIndex () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_PhonBkSearchKeyboardListItem::set_has_u32LetterEndIndex () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_PhonBkSearchKeyboardListItem::clear_has_u32LetterEndIndex () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  T_PhonBkHomeAddressLatLong::T_PhonBkHomeAddressLatLong ()  :
    _bLatLongValidity (false),
    _s32Latitude (0),
    _s32Longitude (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_PhonBkHomeAddressLatLong::T_PhonBkHomeAddressLatLong (const T_PhonBkHomeAddressLatLong &rhs)  :
    _bLatLongValidity (false),
    _s32Latitude (0),
    _s32Longitude (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_PhonBkHomeAddressLatLong::T_PhonBkHomeAddressLatLong (bool bLatLongValidity_, int32 s32Latitude_, int32 s32Longitude_)  :
    _bLatLongValidity (bLatLongValidity_),
    _s32Latitude (s32Latitude_),
    _s32Longitude (s32Longitude_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_PhonBkHomeAddressLatLong::~T_PhonBkHomeAddressLatLong() {
}

inline T_PhonBkHomeAddressLatLong& T_PhonBkHomeAddressLatLong::operator = (const T_PhonBkHomeAddressLatLong& rhs) {
    if( this != &rhs ) {
        if (rhs.hasBLatLongValidity()) {
            setBLatLongValidity(rhs.getBLatLongValidity());
        } else {
            clearBLatLongValidity();
        }
        if (rhs.hasS32Latitude()) {
            setS32Latitude(rhs.getS32Latitude());
        } else {
            clearS32Latitude();
        }
        if (rhs.hasS32Longitude()) {
            setS32Longitude(rhs.getS32Longitude());
        } else {
            clearS32Longitude();
        }
    }
    return *this;
}

inline bool T_PhonBkHomeAddressLatLong::operator == (const T_PhonBkHomeAddressLatLong& rhs) const {
    return (((!hasBLatLongValidity() && !rhs.hasBLatLongValidity()) || getBLatLongValidity() == rhs.getBLatLongValidity()) &&
        ((!hasS32Latitude() && !rhs.hasS32Latitude()) || getS32Latitude() == rhs.getS32Latitude()) &&
        ((!hasS32Longitude() && !rhs.hasS32Longitude()) || getS32Longitude() == rhs.getS32Longitude()));
}

inline bool T_PhonBkHomeAddressLatLong::operator != (const T_PhonBkHomeAddressLatLong& rhs) const {
    return ! (*this == rhs);
}

inline bool T_PhonBkHomeAddressLatLong::operator < (const T_PhonBkHomeAddressLatLong& rhs) const {
    if (hasBLatLongValidity() || rhs.hasBLatLongValidity()) {
        if (getBLatLongValidity() < rhs.getBLatLongValidity()) return true;
        if (getBLatLongValidity() > rhs.getBLatLongValidity()) return false;
    }
    if (hasS32Latitude() || rhs.hasS32Latitude()) {
        if (getS32Latitude() < rhs.getS32Latitude()) return true;
        if (getS32Latitude() > rhs.getS32Latitude()) return false;
    }
    if (hasS32Longitude() || rhs.hasS32Longitude()) {
        if (getS32Longitude() < rhs.getS32Longitude()) return true;
        if (getS32Longitude() > rhs.getS32Longitude()) return false;
    }
    return false;
}

inline bool T_PhonBkHomeAddressLatLong::operator > (const T_PhonBkHomeAddressLatLong& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_PhonBkHomeAddressLatLong::clear() {
    clearBLatLongValidity();
    clearS32Latitude();
    clearS32Longitude();
}

inline void T_PhonBkHomeAddressLatLong::clearBLatLongValidity() {
    if (hasBLatLongValidity()) {
         clear_has_bLatLongValidity();
        _bLatLongValidity = false;
     }
}

inline bool T_PhonBkHomeAddressLatLong::hasBLatLongValidity () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool T_PhonBkHomeAddressLatLong::getBLatLongValidity () const {
    return _bLatLongValidity;
}

inline void T_PhonBkHomeAddressLatLong::setBLatLongValidity (bool bLatLongValidity_) {
    set_has_bLatLongValidity();
    this->_bLatLongValidity = bLatLongValidity_;
}

inline void T_PhonBkHomeAddressLatLong::clearS32Latitude() {
    if (hasS32Latitude()) {
         clear_has_s32Latitude();
        _s32Latitude = 0;
     }
}

inline bool T_PhonBkHomeAddressLatLong::hasS32Latitude () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int32 T_PhonBkHomeAddressLatLong::getS32Latitude () const {
    return _s32Latitude;
}

inline void T_PhonBkHomeAddressLatLong::setS32Latitude (int32 s32Latitude_) {
    set_has_s32Latitude();
    this->_s32Latitude = s32Latitude_;
}

inline void T_PhonBkHomeAddressLatLong::clearS32Longitude() {
    if (hasS32Longitude()) {
         clear_has_s32Longitude();
        _s32Longitude = 0;
     }
}

inline bool T_PhonBkHomeAddressLatLong::hasS32Longitude () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline int32 T_PhonBkHomeAddressLatLong::getS32Longitude () const {
    return _s32Longitude;
}

inline void T_PhonBkHomeAddressLatLong::setS32Longitude (int32 s32Longitude_) {
    set_has_s32Longitude();
    this->_s32Longitude = s32Longitude_;
}

inline void T_PhonBkHomeAddressLatLong::set_has_bLatLongValidity () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_PhonBkHomeAddressLatLong::clear_has_bLatLongValidity () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_PhonBkHomeAddressLatLong::set_has_s32Latitude () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_PhonBkHomeAddressLatLong::clear_has_s32Latitude () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_PhonBkHomeAddressLatLong::set_has_s32Longitude () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_PhonBkHomeAddressLatLong::clear_has_s32Longitude () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_PhonBkWorkAddressLatLong::T_PhonBkWorkAddressLatLong ()  :
    _bLatLongValidity (false),
    _s32Latitude (0),
    _s32Longitude (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_PhonBkWorkAddressLatLong::T_PhonBkWorkAddressLatLong (const T_PhonBkWorkAddressLatLong &rhs)  :
    _bLatLongValidity (false),
    _s32Latitude (0),
    _s32Longitude (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_PhonBkWorkAddressLatLong::T_PhonBkWorkAddressLatLong (bool bLatLongValidity_, int32 s32Latitude_, int32 s32Longitude_)  :
    _bLatLongValidity (bLatLongValidity_),
    _s32Latitude (s32Latitude_),
    _s32Longitude (s32Longitude_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_PhonBkWorkAddressLatLong::~T_PhonBkWorkAddressLatLong() {
}

inline T_PhonBkWorkAddressLatLong& T_PhonBkWorkAddressLatLong::operator = (const T_PhonBkWorkAddressLatLong& rhs) {
    if( this != &rhs ) {
        if (rhs.hasBLatLongValidity()) {
            setBLatLongValidity(rhs.getBLatLongValidity());
        } else {
            clearBLatLongValidity();
        }
        if (rhs.hasS32Latitude()) {
            setS32Latitude(rhs.getS32Latitude());
        } else {
            clearS32Latitude();
        }
        if (rhs.hasS32Longitude()) {
            setS32Longitude(rhs.getS32Longitude());
        } else {
            clearS32Longitude();
        }
    }
    return *this;
}

inline bool T_PhonBkWorkAddressLatLong::operator == (const T_PhonBkWorkAddressLatLong& rhs) const {
    return (((!hasBLatLongValidity() && !rhs.hasBLatLongValidity()) || getBLatLongValidity() == rhs.getBLatLongValidity()) &&
        ((!hasS32Latitude() && !rhs.hasS32Latitude()) || getS32Latitude() == rhs.getS32Latitude()) &&
        ((!hasS32Longitude() && !rhs.hasS32Longitude()) || getS32Longitude() == rhs.getS32Longitude()));
}

inline bool T_PhonBkWorkAddressLatLong::operator != (const T_PhonBkWorkAddressLatLong& rhs) const {
    return ! (*this == rhs);
}

inline bool T_PhonBkWorkAddressLatLong::operator < (const T_PhonBkWorkAddressLatLong& rhs) const {
    if (hasBLatLongValidity() || rhs.hasBLatLongValidity()) {
        if (getBLatLongValidity() < rhs.getBLatLongValidity()) return true;
        if (getBLatLongValidity() > rhs.getBLatLongValidity()) return false;
    }
    if (hasS32Latitude() || rhs.hasS32Latitude()) {
        if (getS32Latitude() < rhs.getS32Latitude()) return true;
        if (getS32Latitude() > rhs.getS32Latitude()) return false;
    }
    if (hasS32Longitude() || rhs.hasS32Longitude()) {
        if (getS32Longitude() < rhs.getS32Longitude()) return true;
        if (getS32Longitude() > rhs.getS32Longitude()) return false;
    }
    return false;
}

inline bool T_PhonBkWorkAddressLatLong::operator > (const T_PhonBkWorkAddressLatLong& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_PhonBkWorkAddressLatLong::clear() {
    clearBLatLongValidity();
    clearS32Latitude();
    clearS32Longitude();
}

inline void T_PhonBkWorkAddressLatLong::clearBLatLongValidity() {
    if (hasBLatLongValidity()) {
         clear_has_bLatLongValidity();
        _bLatLongValidity = false;
     }
}

inline bool T_PhonBkWorkAddressLatLong::hasBLatLongValidity () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool T_PhonBkWorkAddressLatLong::getBLatLongValidity () const {
    return _bLatLongValidity;
}

inline void T_PhonBkWorkAddressLatLong::setBLatLongValidity (bool bLatLongValidity_) {
    set_has_bLatLongValidity();
    this->_bLatLongValidity = bLatLongValidity_;
}

inline void T_PhonBkWorkAddressLatLong::clearS32Latitude() {
    if (hasS32Latitude()) {
         clear_has_s32Latitude();
        _s32Latitude = 0;
     }
}

inline bool T_PhonBkWorkAddressLatLong::hasS32Latitude () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int32 T_PhonBkWorkAddressLatLong::getS32Latitude () const {
    return _s32Latitude;
}

inline void T_PhonBkWorkAddressLatLong::setS32Latitude (int32 s32Latitude_) {
    set_has_s32Latitude();
    this->_s32Latitude = s32Latitude_;
}

inline void T_PhonBkWorkAddressLatLong::clearS32Longitude() {
    if (hasS32Longitude()) {
         clear_has_s32Longitude();
        _s32Longitude = 0;
     }
}

inline bool T_PhonBkWorkAddressLatLong::hasS32Longitude () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline int32 T_PhonBkWorkAddressLatLong::getS32Longitude () const {
    return _s32Longitude;
}

inline void T_PhonBkWorkAddressLatLong::setS32Longitude (int32 s32Longitude_) {
    set_has_s32Longitude();
    this->_s32Longitude = s32Longitude_;
}

inline void T_PhonBkWorkAddressLatLong::set_has_bLatLongValidity () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_PhonBkWorkAddressLatLong::clear_has_bLatLongValidity () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_PhonBkWorkAddressLatLong::set_has_s32Latitude () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_PhonBkWorkAddressLatLong::clear_has_s32Latitude () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_PhonBkWorkAddressLatLong::set_has_s32Longitude () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_PhonBkWorkAddressLatLong::clear_has_s32Longitude () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_PhonBkOtherAddressLatLong::T_PhonBkOtherAddressLatLong ()  :
    _bLatLongValidity (false),
    _s32Latitude (0),
    _s32Longitude (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_PhonBkOtherAddressLatLong::T_PhonBkOtherAddressLatLong (const T_PhonBkOtherAddressLatLong &rhs)  :
    _bLatLongValidity (false),
    _s32Latitude (0),
    _s32Longitude (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_PhonBkOtherAddressLatLong::T_PhonBkOtherAddressLatLong (bool bLatLongValidity_, int32 s32Latitude_, int32 s32Longitude_)  :
    _bLatLongValidity (bLatLongValidity_),
    _s32Latitude (s32Latitude_),
    _s32Longitude (s32Longitude_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_PhonBkOtherAddressLatLong::~T_PhonBkOtherAddressLatLong() {
}

inline T_PhonBkOtherAddressLatLong& T_PhonBkOtherAddressLatLong::operator = (const T_PhonBkOtherAddressLatLong& rhs) {
    if( this != &rhs ) {
        if (rhs.hasBLatLongValidity()) {
            setBLatLongValidity(rhs.getBLatLongValidity());
        } else {
            clearBLatLongValidity();
        }
        if (rhs.hasS32Latitude()) {
            setS32Latitude(rhs.getS32Latitude());
        } else {
            clearS32Latitude();
        }
        if (rhs.hasS32Longitude()) {
            setS32Longitude(rhs.getS32Longitude());
        } else {
            clearS32Longitude();
        }
    }
    return *this;
}

inline bool T_PhonBkOtherAddressLatLong::operator == (const T_PhonBkOtherAddressLatLong& rhs) const {
    return (((!hasBLatLongValidity() && !rhs.hasBLatLongValidity()) || getBLatLongValidity() == rhs.getBLatLongValidity()) &&
        ((!hasS32Latitude() && !rhs.hasS32Latitude()) || getS32Latitude() == rhs.getS32Latitude()) &&
        ((!hasS32Longitude() && !rhs.hasS32Longitude()) || getS32Longitude() == rhs.getS32Longitude()));
}

inline bool T_PhonBkOtherAddressLatLong::operator != (const T_PhonBkOtherAddressLatLong& rhs) const {
    return ! (*this == rhs);
}

inline bool T_PhonBkOtherAddressLatLong::operator < (const T_PhonBkOtherAddressLatLong& rhs) const {
    if (hasBLatLongValidity() || rhs.hasBLatLongValidity()) {
        if (getBLatLongValidity() < rhs.getBLatLongValidity()) return true;
        if (getBLatLongValidity() > rhs.getBLatLongValidity()) return false;
    }
    if (hasS32Latitude() || rhs.hasS32Latitude()) {
        if (getS32Latitude() < rhs.getS32Latitude()) return true;
        if (getS32Latitude() > rhs.getS32Latitude()) return false;
    }
    if (hasS32Longitude() || rhs.hasS32Longitude()) {
        if (getS32Longitude() < rhs.getS32Longitude()) return true;
        if (getS32Longitude() > rhs.getS32Longitude()) return false;
    }
    return false;
}

inline bool T_PhonBkOtherAddressLatLong::operator > (const T_PhonBkOtherAddressLatLong& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_PhonBkOtherAddressLatLong::clear() {
    clearBLatLongValidity();
    clearS32Latitude();
    clearS32Longitude();
}

inline void T_PhonBkOtherAddressLatLong::clearBLatLongValidity() {
    if (hasBLatLongValidity()) {
         clear_has_bLatLongValidity();
        _bLatLongValidity = false;
     }
}

inline bool T_PhonBkOtherAddressLatLong::hasBLatLongValidity () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool T_PhonBkOtherAddressLatLong::getBLatLongValidity () const {
    return _bLatLongValidity;
}

inline void T_PhonBkOtherAddressLatLong::setBLatLongValidity (bool bLatLongValidity_) {
    set_has_bLatLongValidity();
    this->_bLatLongValidity = bLatLongValidity_;
}

inline void T_PhonBkOtherAddressLatLong::clearS32Latitude() {
    if (hasS32Latitude()) {
         clear_has_s32Latitude();
        _s32Latitude = 0;
     }
}

inline bool T_PhonBkOtherAddressLatLong::hasS32Latitude () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int32 T_PhonBkOtherAddressLatLong::getS32Latitude () const {
    return _s32Latitude;
}

inline void T_PhonBkOtherAddressLatLong::setS32Latitude (int32 s32Latitude_) {
    set_has_s32Latitude();
    this->_s32Latitude = s32Latitude_;
}

inline void T_PhonBkOtherAddressLatLong::clearS32Longitude() {
    if (hasS32Longitude()) {
         clear_has_s32Longitude();
        _s32Longitude = 0;
     }
}

inline bool T_PhonBkOtherAddressLatLong::hasS32Longitude () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline int32 T_PhonBkOtherAddressLatLong::getS32Longitude () const {
    return _s32Longitude;
}

inline void T_PhonBkOtherAddressLatLong::setS32Longitude (int32 s32Longitude_) {
    set_has_s32Longitude();
    this->_s32Longitude = s32Longitude_;
}

inline void T_PhonBkOtherAddressLatLong::set_has_bLatLongValidity () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_PhonBkOtherAddressLatLong::clear_has_bLatLongValidity () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_PhonBkOtherAddressLatLong::set_has_s32Latitude () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_PhonBkOtherAddressLatLong::clear_has_s32Latitude () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_PhonBkOtherAddressLatLong::set_has_s32Longitude () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_PhonBkOtherAddressLatLong::clear_has_s32Longitude () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_PhonBkContactDetails::T_PhonBkContactDetails ()  :
    _sFirstName (),
    _sLastName (),
    _sPOIName (),
    _sPreferredNumber (),
    _sCellNumber1 (),
    _sCellNumber2 (),
    _sHomeNumber1 (),
    _sHomeNumber2 (),
    _sWorkNumber1 (),
    _sWorkNumber2 (),
    _sOtherNumber (),
    _sEmailAddress1 (),
    _sEmailAddress2 (),
    _sEmailAddress3 (),
    _sHomeAddress (),
    _sWorkAddress (),
    _sOtherAddress (),
    _sCategory (),
    _sNotes (),
    _u32FirstNameTag (0u),
    _u32LastNameTag (0u),
    _u32POINameTag (0u),
    _u32PrefNumTag (0u),
    _u32CellNum1Tag (0u),
    _u32CellNum2Tag (0u),
    _u32HomeNum1Tag (0u),
    _u32HomeNum2Tag (0u),
    _u32WorkNum1Tag (0u),
    _u32WorkNum2Tag (0u),
    _u32OtherNumTag (0u),
    _u32EmailAdd1Tag (0u),
    _u32EmailAdd2Tag (0u),
    _u32EmailAdd3Tag (0u),
    _u32HomeAddTag (0u),
    _u32WorkAddTag (0u),
    _u32OtherAddTag (0u),
    _u32CategoryTag (0u),
    _u32NotesTag (0u),
    _bPhotoAvailable (false),
    _oHomeAddressLatLong (),
    _oWorkAddressLatLong (),
    _oOtherAddressLatLong ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_PhonBkContactDetails::T_PhonBkContactDetails (const T_PhonBkContactDetails &rhs)  :
    _sFirstName (),
    _sLastName (),
    _sPOIName (),
    _sPreferredNumber (),
    _sCellNumber1 (),
    _sCellNumber2 (),
    _sHomeNumber1 (),
    _sHomeNumber2 (),
    _sWorkNumber1 (),
    _sWorkNumber2 (),
    _sOtherNumber (),
    _sEmailAddress1 (),
    _sEmailAddress2 (),
    _sEmailAddress3 (),
    _sHomeAddress (),
    _sWorkAddress (),
    _sOtherAddress (),
    _sCategory (),
    _sNotes (),
    _u32FirstNameTag (0u),
    _u32LastNameTag (0u),
    _u32POINameTag (0u),
    _u32PrefNumTag (0u),
    _u32CellNum1Tag (0u),
    _u32CellNum2Tag (0u),
    _u32HomeNum1Tag (0u),
    _u32HomeNum2Tag (0u),
    _u32WorkNum1Tag (0u),
    _u32WorkNum2Tag (0u),
    _u32OtherNumTag (0u),
    _u32EmailAdd1Tag (0u),
    _u32EmailAdd2Tag (0u),
    _u32EmailAdd3Tag (0u),
    _u32HomeAddTag (0u),
    _u32WorkAddTag (0u),
    _u32OtherAddTag (0u),
    _u32CategoryTag (0u),
    _u32NotesTag (0u),
    _bPhotoAvailable (false),
    _oHomeAddressLatLong (),
    _oWorkAddressLatLong (),
    _oOtherAddressLatLong ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_PhonBkContactDetails::T_PhonBkContactDetails (const ::fi_basetypes_most::T_String& sFirstName_, const ::fi_basetypes_most::T_String& sLastName_, const ::fi_basetypes_most::T_String& sPOIName_, const ::fi_basetypes_most::T_String& sPreferredNumber_, const ::fi_basetypes_most::T_String& sCellNumber1_, const ::fi_basetypes_most::T_String& sCellNumber2_, const ::fi_basetypes_most::T_String& sHomeNumber1_, const ::fi_basetypes_most::T_String& sHomeNumber2_, const ::fi_basetypes_most::T_String& sWorkNumber1_, const ::fi_basetypes_most::T_String& sWorkNumber2_, const ::fi_basetypes_most::T_String& sOtherNumber_, const ::fi_basetypes_most::T_String& sEmailAddress1_, const ::fi_basetypes_most::T_String& sEmailAddress2_, const ::fi_basetypes_most::T_String& sEmailAddress3_, const ::fi_basetypes_most::T_String& sHomeAddress_, const ::fi_basetypes_most::T_String& sWorkAddress_, const ::fi_basetypes_most::T_String& sOtherAddress_, const ::fi_basetypes_most::T_String& sCategory_, const ::fi_basetypes_most::T_String& sNotes_, uint32 u32FirstNameTag_, uint32 u32LastNameTag_, uint32 u32POINameTag_, uint32 u32PrefNumTag_, uint32 u32CellNum1Tag_, uint32 u32CellNum2Tag_, uint32 u32HomeNum1Tag_, uint32 u32HomeNum2Tag_, uint32 u32WorkNum1Tag_, uint32 u32WorkNum2Tag_, uint32 u32OtherNumTag_, uint32 u32EmailAdd1Tag_, uint32 u32EmailAdd2Tag_, uint32 u32EmailAdd3Tag_, uint32 u32HomeAddTag_, uint32 u32WorkAddTag_, uint32 u32OtherAddTag_, uint32 u32CategoryTag_, uint32 u32NotesTag_, bool bPhotoAvailable_, const T_PhonBkHomeAddressLatLong& oHomeAddressLatLong_, const T_PhonBkWorkAddressLatLong& oWorkAddressLatLong_, const T_PhonBkOtherAddressLatLong& oOtherAddressLatLong_)  :
    _sFirstName (sFirstName_),
    _sLastName (sLastName_),
    _sPOIName (sPOIName_),
    _sPreferredNumber (sPreferredNumber_),
    _sCellNumber1 (sCellNumber1_),
    _sCellNumber2 (sCellNumber2_),
    _sHomeNumber1 (sHomeNumber1_),
    _sHomeNumber2 (sHomeNumber2_),
    _sWorkNumber1 (sWorkNumber1_),
    _sWorkNumber2 (sWorkNumber2_),
    _sOtherNumber (sOtherNumber_),
    _sEmailAddress1 (sEmailAddress1_),
    _sEmailAddress2 (sEmailAddress2_),
    _sEmailAddress3 (sEmailAddress3_),
    _sHomeAddress (sHomeAddress_),
    _sWorkAddress (sWorkAddress_),
    _sOtherAddress (sOtherAddress_),
    _sCategory (sCategory_),
    _sNotes (sNotes_),
    _u32FirstNameTag (u32FirstNameTag_),
    _u32LastNameTag (u32LastNameTag_),
    _u32POINameTag (u32POINameTag_),
    _u32PrefNumTag (u32PrefNumTag_),
    _u32CellNum1Tag (u32CellNum1Tag_),
    _u32CellNum2Tag (u32CellNum2Tag_),
    _u32HomeNum1Tag (u32HomeNum1Tag_),
    _u32HomeNum2Tag (u32HomeNum2Tag_),
    _u32WorkNum1Tag (u32WorkNum1Tag_),
    _u32WorkNum2Tag (u32WorkNum2Tag_),
    _u32OtherNumTag (u32OtherNumTag_),
    _u32EmailAdd1Tag (u32EmailAdd1Tag_),
    _u32EmailAdd2Tag (u32EmailAdd2Tag_),
    _u32EmailAdd3Tag (u32EmailAdd3Tag_),
    _u32HomeAddTag (u32HomeAddTag_),
    _u32WorkAddTag (u32WorkAddTag_),
    _u32OtherAddTag (u32OtherAddTag_),
    _u32CategoryTag (u32CategoryTag_),
    _u32NotesTag (u32NotesTag_),
    _bPhotoAvailable (bPhotoAvailable_),
    _oHomeAddressLatLong (oHomeAddressLatLong_),
    _oWorkAddressLatLong (oWorkAddressLatLong_),
    _oOtherAddressLatLong (oOtherAddressLatLong_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sFirstName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sLastName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sPOIName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sPreferredNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sCellNumber1_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sCellNumber2_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sHomeNumber1_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sHomeNumber2_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sWorkNumber1_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sWorkNumber2_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sOtherNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sEmailAddress1_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sEmailAddress2_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sEmailAddress3_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sHomeAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sWorkAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sOtherAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sCategory_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sNotes_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_PhonBkContactDetails::~T_PhonBkContactDetails() {
}

inline T_PhonBkContactDetails& T_PhonBkContactDetails::operator = (const T_PhonBkContactDetails& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSFirstName()) {
            setSFirstName(rhs.getSFirstName());
        } else {
            clearSFirstName();
        }
        if (rhs.hasSLastName()) {
            setSLastName(rhs.getSLastName());
        } else {
            clearSLastName();
        }
        if (rhs.hasSPOIName()) {
            setSPOIName(rhs.getSPOIName());
        } else {
            clearSPOIName();
        }
        if (rhs.hasSPreferredNumber()) {
            setSPreferredNumber(rhs.getSPreferredNumber());
        } else {
            clearSPreferredNumber();
        }
        if (rhs.hasSCellNumber1()) {
            setSCellNumber1(rhs.getSCellNumber1());
        } else {
            clearSCellNumber1();
        }
        if (rhs.hasSCellNumber2()) {
            setSCellNumber2(rhs.getSCellNumber2());
        } else {
            clearSCellNumber2();
        }
        if (rhs.hasSHomeNumber1()) {
            setSHomeNumber1(rhs.getSHomeNumber1());
        } else {
            clearSHomeNumber1();
        }
        if (rhs.hasSHomeNumber2()) {
            setSHomeNumber2(rhs.getSHomeNumber2());
        } else {
            clearSHomeNumber2();
        }
        if (rhs.hasSWorkNumber1()) {
            setSWorkNumber1(rhs.getSWorkNumber1());
        } else {
            clearSWorkNumber1();
        }
        if (rhs.hasSWorkNumber2()) {
            setSWorkNumber2(rhs.getSWorkNumber2());
        } else {
            clearSWorkNumber2();
        }
        if (rhs.hasSOtherNumber()) {
            setSOtherNumber(rhs.getSOtherNumber());
        } else {
            clearSOtherNumber();
        }
        if (rhs.hasSEmailAddress1()) {
            setSEmailAddress1(rhs.getSEmailAddress1());
        } else {
            clearSEmailAddress1();
        }
        if (rhs.hasSEmailAddress2()) {
            setSEmailAddress2(rhs.getSEmailAddress2());
        } else {
            clearSEmailAddress2();
        }
        if (rhs.hasSEmailAddress3()) {
            setSEmailAddress3(rhs.getSEmailAddress3());
        } else {
            clearSEmailAddress3();
        }
        if (rhs.hasSHomeAddress()) {
            setSHomeAddress(rhs.getSHomeAddress());
        } else {
            clearSHomeAddress();
        }
        if (rhs.hasSWorkAddress()) {
            setSWorkAddress(rhs.getSWorkAddress());
        } else {
            clearSWorkAddress();
        }
        if (rhs.hasSOtherAddress()) {
            setSOtherAddress(rhs.getSOtherAddress());
        } else {
            clearSOtherAddress();
        }
        if (rhs.hasSCategory()) {
            setSCategory(rhs.getSCategory());
        } else {
            clearSCategory();
        }
        if (rhs.hasSNotes()) {
            setSNotes(rhs.getSNotes());
        } else {
            clearSNotes();
        }
        if (rhs.hasU32FirstNameTag()) {
            setU32FirstNameTag(rhs.getU32FirstNameTag());
        } else {
            clearU32FirstNameTag();
        }
        if (rhs.hasU32LastNameTag()) {
            setU32LastNameTag(rhs.getU32LastNameTag());
        } else {
            clearU32LastNameTag();
        }
        if (rhs.hasU32POINameTag()) {
            setU32POINameTag(rhs.getU32POINameTag());
        } else {
            clearU32POINameTag();
        }
        if (rhs.hasU32PrefNumTag()) {
            setU32PrefNumTag(rhs.getU32PrefNumTag());
        } else {
            clearU32PrefNumTag();
        }
        if (rhs.hasU32CellNum1Tag()) {
            setU32CellNum1Tag(rhs.getU32CellNum1Tag());
        } else {
            clearU32CellNum1Tag();
        }
        if (rhs.hasU32CellNum2Tag()) {
            setU32CellNum2Tag(rhs.getU32CellNum2Tag());
        } else {
            clearU32CellNum2Tag();
        }
        if (rhs.hasU32HomeNum1Tag()) {
            setU32HomeNum1Tag(rhs.getU32HomeNum1Tag());
        } else {
            clearU32HomeNum1Tag();
        }
        if (rhs.hasU32HomeNum2Tag()) {
            setU32HomeNum2Tag(rhs.getU32HomeNum2Tag());
        } else {
            clearU32HomeNum2Tag();
        }
        if (rhs.hasU32WorkNum1Tag()) {
            setU32WorkNum1Tag(rhs.getU32WorkNum1Tag());
        } else {
            clearU32WorkNum1Tag();
        }
        if (rhs.hasU32WorkNum2Tag()) {
            setU32WorkNum2Tag(rhs.getU32WorkNum2Tag());
        } else {
            clearU32WorkNum2Tag();
        }
        if (rhs.hasU32OtherNumTag()) {
            setU32OtherNumTag(rhs.getU32OtherNumTag());
        } else {
            clearU32OtherNumTag();
        }
        if (rhs.hasU32EmailAdd1Tag()) {
            setU32EmailAdd1Tag(rhs.getU32EmailAdd1Tag());
        } else {
            clearU32EmailAdd1Tag();
        }
        if (rhs.hasU32EmailAdd2Tag()) {
            setU32EmailAdd2Tag(rhs.getU32EmailAdd2Tag());
        } else {
            clearU32EmailAdd2Tag();
        }
        if (rhs.hasU32EmailAdd3Tag()) {
            setU32EmailAdd3Tag(rhs.getU32EmailAdd3Tag());
        } else {
            clearU32EmailAdd3Tag();
        }
        if (rhs.hasU32HomeAddTag()) {
            setU32HomeAddTag(rhs.getU32HomeAddTag());
        } else {
            clearU32HomeAddTag();
        }
        if (rhs.hasU32WorkAddTag()) {
            setU32WorkAddTag(rhs.getU32WorkAddTag());
        } else {
            clearU32WorkAddTag();
        }
        if (rhs.hasU32OtherAddTag()) {
            setU32OtherAddTag(rhs.getU32OtherAddTag());
        } else {
            clearU32OtherAddTag();
        }
        if (rhs.hasU32CategoryTag()) {
            setU32CategoryTag(rhs.getU32CategoryTag());
        } else {
            clearU32CategoryTag();
        }
        if (rhs.hasU32NotesTag()) {
            setU32NotesTag(rhs.getU32NotesTag());
        } else {
            clearU32NotesTag();
        }
        if (rhs.hasBPhotoAvailable()) {
            setBPhotoAvailable(rhs.getBPhotoAvailable());
        } else {
            clearBPhotoAvailable();
        }
        if (rhs.hasOHomeAddressLatLong()) {
            setOHomeAddressLatLong(rhs.getOHomeAddressLatLong());
        } else {
            clearOHomeAddressLatLong();
        }
        if (rhs.hasOWorkAddressLatLong()) {
            setOWorkAddressLatLong(rhs.getOWorkAddressLatLong());
        } else {
            clearOWorkAddressLatLong();
        }
        if (rhs.hasOOtherAddressLatLong()) {
            setOOtherAddressLatLong(rhs.getOOtherAddressLatLong());
        } else {
            clearOOtherAddressLatLong();
        }
    }
    return *this;
}

inline bool T_PhonBkContactDetails::operator == (const T_PhonBkContactDetails& rhs) const {
    return (((!hasSFirstName() && !rhs.hasSFirstName()) || getSFirstName() == rhs.getSFirstName()) &&
        ((!hasSLastName() && !rhs.hasSLastName()) || getSLastName() == rhs.getSLastName()) &&
        ((!hasSPOIName() && !rhs.hasSPOIName()) || getSPOIName() == rhs.getSPOIName()) &&
        ((!hasSPreferredNumber() && !rhs.hasSPreferredNumber()) || getSPreferredNumber() == rhs.getSPreferredNumber()) &&
        ((!hasSCellNumber1() && !rhs.hasSCellNumber1()) || getSCellNumber1() == rhs.getSCellNumber1()) &&
        ((!hasSCellNumber2() && !rhs.hasSCellNumber2()) || getSCellNumber2() == rhs.getSCellNumber2()) &&
        ((!hasSHomeNumber1() && !rhs.hasSHomeNumber1()) || getSHomeNumber1() == rhs.getSHomeNumber1()) &&
        ((!hasSHomeNumber2() && !rhs.hasSHomeNumber2()) || getSHomeNumber2() == rhs.getSHomeNumber2()) &&
        ((!hasSWorkNumber1() && !rhs.hasSWorkNumber1()) || getSWorkNumber1() == rhs.getSWorkNumber1()) &&
        ((!hasSWorkNumber2() && !rhs.hasSWorkNumber2()) || getSWorkNumber2() == rhs.getSWorkNumber2()) &&
        ((!hasSOtherNumber() && !rhs.hasSOtherNumber()) || getSOtherNumber() == rhs.getSOtherNumber()) &&
        ((!hasSEmailAddress1() && !rhs.hasSEmailAddress1()) || getSEmailAddress1() == rhs.getSEmailAddress1()) &&
        ((!hasSEmailAddress2() && !rhs.hasSEmailAddress2()) || getSEmailAddress2() == rhs.getSEmailAddress2()) &&
        ((!hasSEmailAddress3() && !rhs.hasSEmailAddress3()) || getSEmailAddress3() == rhs.getSEmailAddress3()) &&
        ((!hasSHomeAddress() && !rhs.hasSHomeAddress()) || getSHomeAddress() == rhs.getSHomeAddress()) &&
        ((!hasSWorkAddress() && !rhs.hasSWorkAddress()) || getSWorkAddress() == rhs.getSWorkAddress()) &&
        ((!hasSOtherAddress() && !rhs.hasSOtherAddress()) || getSOtherAddress() == rhs.getSOtherAddress()) &&
        ((!hasSCategory() && !rhs.hasSCategory()) || getSCategory() == rhs.getSCategory()) &&
        ((!hasSNotes() && !rhs.hasSNotes()) || getSNotes() == rhs.getSNotes()) &&
        ((!hasU32FirstNameTag() && !rhs.hasU32FirstNameTag()) || getU32FirstNameTag() == rhs.getU32FirstNameTag()) &&
        ((!hasU32LastNameTag() && !rhs.hasU32LastNameTag()) || getU32LastNameTag() == rhs.getU32LastNameTag()) &&
        ((!hasU32POINameTag() && !rhs.hasU32POINameTag()) || getU32POINameTag() == rhs.getU32POINameTag()) &&
        ((!hasU32PrefNumTag() && !rhs.hasU32PrefNumTag()) || getU32PrefNumTag() == rhs.getU32PrefNumTag()) &&
        ((!hasU32CellNum1Tag() && !rhs.hasU32CellNum1Tag()) || getU32CellNum1Tag() == rhs.getU32CellNum1Tag()) &&
        ((!hasU32CellNum2Tag() && !rhs.hasU32CellNum2Tag()) || getU32CellNum2Tag() == rhs.getU32CellNum2Tag()) &&
        ((!hasU32HomeNum1Tag() && !rhs.hasU32HomeNum1Tag()) || getU32HomeNum1Tag() == rhs.getU32HomeNum1Tag()) &&
        ((!hasU32HomeNum2Tag() && !rhs.hasU32HomeNum2Tag()) || getU32HomeNum2Tag() == rhs.getU32HomeNum2Tag()) &&
        ((!hasU32WorkNum1Tag() && !rhs.hasU32WorkNum1Tag()) || getU32WorkNum1Tag() == rhs.getU32WorkNum1Tag()) &&
        ((!hasU32WorkNum2Tag() && !rhs.hasU32WorkNum2Tag()) || getU32WorkNum2Tag() == rhs.getU32WorkNum2Tag()) &&
        ((!hasU32OtherNumTag() && !rhs.hasU32OtherNumTag()) || getU32OtherNumTag() == rhs.getU32OtherNumTag()) &&
        ((!hasU32EmailAdd1Tag() && !rhs.hasU32EmailAdd1Tag()) || getU32EmailAdd1Tag() == rhs.getU32EmailAdd1Tag()) &&
        ((!hasU32EmailAdd2Tag() && !rhs.hasU32EmailAdd2Tag()) || getU32EmailAdd2Tag() == rhs.getU32EmailAdd2Tag()) &&
        ((!hasU32EmailAdd3Tag() && !rhs.hasU32EmailAdd3Tag()) || getU32EmailAdd3Tag() == rhs.getU32EmailAdd3Tag()) &&
        ((!hasU32HomeAddTag() && !rhs.hasU32HomeAddTag()) || getU32HomeAddTag() == rhs.getU32HomeAddTag()) &&
        ((!hasU32WorkAddTag() && !rhs.hasU32WorkAddTag()) || getU32WorkAddTag() == rhs.getU32WorkAddTag()) &&
        ((!hasU32OtherAddTag() && !rhs.hasU32OtherAddTag()) || getU32OtherAddTag() == rhs.getU32OtherAddTag()) &&
        ((!hasU32CategoryTag() && !rhs.hasU32CategoryTag()) || getU32CategoryTag() == rhs.getU32CategoryTag()) &&
        ((!hasU32NotesTag() && !rhs.hasU32NotesTag()) || getU32NotesTag() == rhs.getU32NotesTag()) &&
        ((!hasBPhotoAvailable() && !rhs.hasBPhotoAvailable()) || getBPhotoAvailable() == rhs.getBPhotoAvailable()) &&
        ((!hasOHomeAddressLatLong() && !rhs.hasOHomeAddressLatLong()) || getOHomeAddressLatLong() == rhs.getOHomeAddressLatLong()) &&
        ((!hasOWorkAddressLatLong() && !rhs.hasOWorkAddressLatLong()) || getOWorkAddressLatLong() == rhs.getOWorkAddressLatLong()) &&
        ((!hasOOtherAddressLatLong() && !rhs.hasOOtherAddressLatLong()) || getOOtherAddressLatLong() == rhs.getOOtherAddressLatLong()));
}

inline bool T_PhonBkContactDetails::operator != (const T_PhonBkContactDetails& rhs) const {
    return ! (*this == rhs);
}

inline bool T_PhonBkContactDetails::operator < (const T_PhonBkContactDetails& rhs) const {
    if (hasSFirstName() || rhs.hasSFirstName()) {
        if (getSFirstName() < rhs.getSFirstName()) return true;
        if (getSFirstName() > rhs.getSFirstName()) return false;
    }
    if (hasSLastName() || rhs.hasSLastName()) {
        if (getSLastName() < rhs.getSLastName()) return true;
        if (getSLastName() > rhs.getSLastName()) return false;
    }
    if (hasSPOIName() || rhs.hasSPOIName()) {
        if (getSPOIName() < rhs.getSPOIName()) return true;
        if (getSPOIName() > rhs.getSPOIName()) return false;
    }
    if (hasSPreferredNumber() || rhs.hasSPreferredNumber()) {
        if (getSPreferredNumber() < rhs.getSPreferredNumber()) return true;
        if (getSPreferredNumber() > rhs.getSPreferredNumber()) return false;
    }
    if (hasSCellNumber1() || rhs.hasSCellNumber1()) {
        if (getSCellNumber1() < rhs.getSCellNumber1()) return true;
        if (getSCellNumber1() > rhs.getSCellNumber1()) return false;
    }
    if (hasSCellNumber2() || rhs.hasSCellNumber2()) {
        if (getSCellNumber2() < rhs.getSCellNumber2()) return true;
        if (getSCellNumber2() > rhs.getSCellNumber2()) return false;
    }
    if (hasSHomeNumber1() || rhs.hasSHomeNumber1()) {
        if (getSHomeNumber1() < rhs.getSHomeNumber1()) return true;
        if (getSHomeNumber1() > rhs.getSHomeNumber1()) return false;
    }
    if (hasSHomeNumber2() || rhs.hasSHomeNumber2()) {
        if (getSHomeNumber2() < rhs.getSHomeNumber2()) return true;
        if (getSHomeNumber2() > rhs.getSHomeNumber2()) return false;
    }
    if (hasSWorkNumber1() || rhs.hasSWorkNumber1()) {
        if (getSWorkNumber1() < rhs.getSWorkNumber1()) return true;
        if (getSWorkNumber1() > rhs.getSWorkNumber1()) return false;
    }
    if (hasSWorkNumber2() || rhs.hasSWorkNumber2()) {
        if (getSWorkNumber2() < rhs.getSWorkNumber2()) return true;
        if (getSWorkNumber2() > rhs.getSWorkNumber2()) return false;
    }
    if (hasSOtherNumber() || rhs.hasSOtherNumber()) {
        if (getSOtherNumber() < rhs.getSOtherNumber()) return true;
        if (getSOtherNumber() > rhs.getSOtherNumber()) return false;
    }
    if (hasSEmailAddress1() || rhs.hasSEmailAddress1()) {
        if (getSEmailAddress1() < rhs.getSEmailAddress1()) return true;
        if (getSEmailAddress1() > rhs.getSEmailAddress1()) return false;
    }
    if (hasSEmailAddress2() || rhs.hasSEmailAddress2()) {
        if (getSEmailAddress2() < rhs.getSEmailAddress2()) return true;
        if (getSEmailAddress2() > rhs.getSEmailAddress2()) return false;
    }
    if (hasSEmailAddress3() || rhs.hasSEmailAddress3()) {
        if (getSEmailAddress3() < rhs.getSEmailAddress3()) return true;
        if (getSEmailAddress3() > rhs.getSEmailAddress3()) return false;
    }
    if (hasSHomeAddress() || rhs.hasSHomeAddress()) {
        if (getSHomeAddress() < rhs.getSHomeAddress()) return true;
        if (getSHomeAddress() > rhs.getSHomeAddress()) return false;
    }
    if (hasSWorkAddress() || rhs.hasSWorkAddress()) {
        if (getSWorkAddress() < rhs.getSWorkAddress()) return true;
        if (getSWorkAddress() > rhs.getSWorkAddress()) return false;
    }
    if (hasSOtherAddress() || rhs.hasSOtherAddress()) {
        if (getSOtherAddress() < rhs.getSOtherAddress()) return true;
        if (getSOtherAddress() > rhs.getSOtherAddress()) return false;
    }
    if (hasSCategory() || rhs.hasSCategory()) {
        if (getSCategory() < rhs.getSCategory()) return true;
        if (getSCategory() > rhs.getSCategory()) return false;
    }
    if (hasSNotes() || rhs.hasSNotes()) {
        if (getSNotes() < rhs.getSNotes()) return true;
        if (getSNotes() > rhs.getSNotes()) return false;
    }
    if (hasU32FirstNameTag() || rhs.hasU32FirstNameTag()) {
        if (getU32FirstNameTag() < rhs.getU32FirstNameTag()) return true;
        if (getU32FirstNameTag() > rhs.getU32FirstNameTag()) return false;
    }
    if (hasU32LastNameTag() || rhs.hasU32LastNameTag()) {
        if (getU32LastNameTag() < rhs.getU32LastNameTag()) return true;
        if (getU32LastNameTag() > rhs.getU32LastNameTag()) return false;
    }
    if (hasU32POINameTag() || rhs.hasU32POINameTag()) {
        if (getU32POINameTag() < rhs.getU32POINameTag()) return true;
        if (getU32POINameTag() > rhs.getU32POINameTag()) return false;
    }
    if (hasU32PrefNumTag() || rhs.hasU32PrefNumTag()) {
        if (getU32PrefNumTag() < rhs.getU32PrefNumTag()) return true;
        if (getU32PrefNumTag() > rhs.getU32PrefNumTag()) return false;
    }
    if (hasU32CellNum1Tag() || rhs.hasU32CellNum1Tag()) {
        if (getU32CellNum1Tag() < rhs.getU32CellNum1Tag()) return true;
        if (getU32CellNum1Tag() > rhs.getU32CellNum1Tag()) return false;
    }
    if (hasU32CellNum2Tag() || rhs.hasU32CellNum2Tag()) {
        if (getU32CellNum2Tag() < rhs.getU32CellNum2Tag()) return true;
        if (getU32CellNum2Tag() > rhs.getU32CellNum2Tag()) return false;
    }
    if (hasU32HomeNum1Tag() || rhs.hasU32HomeNum1Tag()) {
        if (getU32HomeNum1Tag() < rhs.getU32HomeNum1Tag()) return true;
        if (getU32HomeNum1Tag() > rhs.getU32HomeNum1Tag()) return false;
    }
    if (hasU32HomeNum2Tag() || rhs.hasU32HomeNum2Tag()) {
        if (getU32HomeNum2Tag() < rhs.getU32HomeNum2Tag()) return true;
        if (getU32HomeNum2Tag() > rhs.getU32HomeNum2Tag()) return false;
    }
    if (hasU32WorkNum1Tag() || rhs.hasU32WorkNum1Tag()) {
        if (getU32WorkNum1Tag() < rhs.getU32WorkNum1Tag()) return true;
        if (getU32WorkNum1Tag() > rhs.getU32WorkNum1Tag()) return false;
    }
    if (hasU32WorkNum2Tag() || rhs.hasU32WorkNum2Tag()) {
        if (getU32WorkNum2Tag() < rhs.getU32WorkNum2Tag()) return true;
        if (getU32WorkNum2Tag() > rhs.getU32WorkNum2Tag()) return false;
    }
    if (hasU32OtherNumTag() || rhs.hasU32OtherNumTag()) {
        if (getU32OtherNumTag() < rhs.getU32OtherNumTag()) return true;
        if (getU32OtherNumTag() > rhs.getU32OtherNumTag()) return false;
    }
    if (hasU32EmailAdd1Tag() || rhs.hasU32EmailAdd1Tag()) {
        if (getU32EmailAdd1Tag() < rhs.getU32EmailAdd1Tag()) return true;
        if (getU32EmailAdd1Tag() > rhs.getU32EmailAdd1Tag()) return false;
    }
    if (hasU32EmailAdd2Tag() || rhs.hasU32EmailAdd2Tag()) {
        if (getU32EmailAdd2Tag() < rhs.getU32EmailAdd2Tag()) return true;
        if (getU32EmailAdd2Tag() > rhs.getU32EmailAdd2Tag()) return false;
    }
    if (hasU32EmailAdd3Tag() || rhs.hasU32EmailAdd3Tag()) {
        if (getU32EmailAdd3Tag() < rhs.getU32EmailAdd3Tag()) return true;
        if (getU32EmailAdd3Tag() > rhs.getU32EmailAdd3Tag()) return false;
    }
    if (hasU32HomeAddTag() || rhs.hasU32HomeAddTag()) {
        if (getU32HomeAddTag() < rhs.getU32HomeAddTag()) return true;
        if (getU32HomeAddTag() > rhs.getU32HomeAddTag()) return false;
    }
    if (hasU32WorkAddTag() || rhs.hasU32WorkAddTag()) {
        if (getU32WorkAddTag() < rhs.getU32WorkAddTag()) return true;
        if (getU32WorkAddTag() > rhs.getU32WorkAddTag()) return false;
    }
    if (hasU32OtherAddTag() || rhs.hasU32OtherAddTag()) {
        if (getU32OtherAddTag() < rhs.getU32OtherAddTag()) return true;
        if (getU32OtherAddTag() > rhs.getU32OtherAddTag()) return false;
    }
    if (hasU32CategoryTag() || rhs.hasU32CategoryTag()) {
        if (getU32CategoryTag() < rhs.getU32CategoryTag()) return true;
        if (getU32CategoryTag() > rhs.getU32CategoryTag()) return false;
    }
    if (hasU32NotesTag() || rhs.hasU32NotesTag()) {
        if (getU32NotesTag() < rhs.getU32NotesTag()) return true;
        if (getU32NotesTag() > rhs.getU32NotesTag()) return false;
    }
    if (hasBPhotoAvailable() || rhs.hasBPhotoAvailable()) {
        if (getBPhotoAvailable() < rhs.getBPhotoAvailable()) return true;
        if (getBPhotoAvailable() > rhs.getBPhotoAvailable()) return false;
    }
    if (hasOHomeAddressLatLong() || rhs.hasOHomeAddressLatLong()) {
        if (getOHomeAddressLatLong() < rhs.getOHomeAddressLatLong()) return true;
        if (getOHomeAddressLatLong() > rhs.getOHomeAddressLatLong()) return false;
    }
    if (hasOWorkAddressLatLong() || rhs.hasOWorkAddressLatLong()) {
        if (getOWorkAddressLatLong() < rhs.getOWorkAddressLatLong()) return true;
        if (getOWorkAddressLatLong() > rhs.getOWorkAddressLatLong()) return false;
    }
    if (hasOOtherAddressLatLong() || rhs.hasOOtherAddressLatLong()) {
        if (getOOtherAddressLatLong() < rhs.getOOtherAddressLatLong()) return true;
        if (getOOtherAddressLatLong() > rhs.getOOtherAddressLatLong()) return false;
    }
    return false;
}

inline bool T_PhonBkContactDetails::operator > (const T_PhonBkContactDetails& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_PhonBkContactDetails::clear() {
    clearSFirstName();
    clearSLastName();
    clearSPOIName();
    clearSPreferredNumber();
    clearSCellNumber1();
    clearSCellNumber2();
    clearSHomeNumber1();
    clearSHomeNumber2();
    clearSWorkNumber1();
    clearSWorkNumber2();
    clearSOtherNumber();
    clearSEmailAddress1();
    clearSEmailAddress2();
    clearSEmailAddress3();
    clearSHomeAddress();
    clearSWorkAddress();
    clearSOtherAddress();
    clearSCategory();
    clearSNotes();
    clearU32FirstNameTag();
    clearU32LastNameTag();
    clearU32POINameTag();
    clearU32PrefNumTag();
    clearU32CellNum1Tag();
    clearU32CellNum2Tag();
    clearU32HomeNum1Tag();
    clearU32HomeNum2Tag();
    clearU32WorkNum1Tag();
    clearU32WorkNum2Tag();
    clearU32OtherNumTag();
    clearU32EmailAdd1Tag();
    clearU32EmailAdd2Tag();
    clearU32EmailAdd3Tag();
    clearU32HomeAddTag();
    clearU32WorkAddTag();
    clearU32OtherAddTag();
    clearU32CategoryTag();
    clearU32NotesTag();
    clearBPhotoAvailable();
    clearOHomeAddressLatLong();
    clearOWorkAddressLatLong();
    clearOOtherAddressLatLong();
}

inline void T_PhonBkContactDetails::clearSFirstName() {
    if (hasSFirstName()) {
         clear_has_sFirstName();
        _sFirstName.clear();
     }
}

inline bool T_PhonBkContactDetails::hasSFirstName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_PhonBkContactDetails::getSFirstName () const {
    return _sFirstName;
}

inline ::fi_basetypes_most::T_String& T_PhonBkContactDetails::getSFirstNameMutable () {
    set_has_sFirstName();
    return _sFirstName;
}

inline void T_PhonBkContactDetails::setSFirstName (const ::fi_basetypes_most::T_String& sFirstName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sFirstName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sFirstName();
    this->_sFirstName = sFirstName_;
}

inline void T_PhonBkContactDetails::clearSLastName() {
    if (hasSLastName()) {
         clear_has_sLastName();
        _sLastName.clear();
     }
}

inline bool T_PhonBkContactDetails::hasSLastName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_PhonBkContactDetails::getSLastName () const {
    return _sLastName;
}

inline ::fi_basetypes_most::T_String& T_PhonBkContactDetails::getSLastNameMutable () {
    set_has_sLastName();
    return _sLastName;
}

inline void T_PhonBkContactDetails::setSLastName (const ::fi_basetypes_most::T_String& sLastName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sLastName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sLastName();
    this->_sLastName = sLastName_;
}

inline void T_PhonBkContactDetails::clearSPOIName() {
    if (hasSPOIName()) {
         clear_has_sPOIName();
        _sPOIName.clear();
     }
}

inline bool T_PhonBkContactDetails::hasSPOIName () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_PhonBkContactDetails::getSPOIName () const {
    return _sPOIName;
}

inline ::fi_basetypes_most::T_String& T_PhonBkContactDetails::getSPOINameMutable () {
    set_has_sPOIName();
    return _sPOIName;
}

inline void T_PhonBkContactDetails::setSPOIName (const ::fi_basetypes_most::T_String& sPOIName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sPOIName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sPOIName();
    this->_sPOIName = sPOIName_;
}

inline void T_PhonBkContactDetails::clearSPreferredNumber() {
    if (hasSPreferredNumber()) {
         clear_has_sPreferredNumber();
        _sPreferredNumber.clear();
     }
}

inline bool T_PhonBkContactDetails::hasSPreferredNumber () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_PhonBkContactDetails::getSPreferredNumber () const {
    return _sPreferredNumber;
}

inline ::fi_basetypes_most::T_String& T_PhonBkContactDetails::getSPreferredNumberMutable () {
    set_has_sPreferredNumber();
    return _sPreferredNumber;
}

inline void T_PhonBkContactDetails::setSPreferredNumber (const ::fi_basetypes_most::T_String& sPreferredNumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sPreferredNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sPreferredNumber();
    this->_sPreferredNumber = sPreferredNumber_;
}

inline void T_PhonBkContactDetails::clearSCellNumber1() {
    if (hasSCellNumber1()) {
         clear_has_sCellNumber1();
        _sCellNumber1.clear();
     }
}

inline bool T_PhonBkContactDetails::hasSCellNumber1 () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_PhonBkContactDetails::getSCellNumber1 () const {
    return _sCellNumber1;
}

inline ::fi_basetypes_most::T_String& T_PhonBkContactDetails::getSCellNumber1Mutable () {
    set_has_sCellNumber1();
    return _sCellNumber1;
}

inline void T_PhonBkContactDetails::setSCellNumber1 (const ::fi_basetypes_most::T_String& sCellNumber1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sCellNumber1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sCellNumber1();
    this->_sCellNumber1 = sCellNumber1_;
}

inline void T_PhonBkContactDetails::clearSCellNumber2() {
    if (hasSCellNumber2()) {
         clear_has_sCellNumber2();
        _sCellNumber2.clear();
     }
}

inline bool T_PhonBkContactDetails::hasSCellNumber2 () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_PhonBkContactDetails::getSCellNumber2 () const {
    return _sCellNumber2;
}

inline ::fi_basetypes_most::T_String& T_PhonBkContactDetails::getSCellNumber2Mutable () {
    set_has_sCellNumber2();
    return _sCellNumber2;
}

inline void T_PhonBkContactDetails::setSCellNumber2 (const ::fi_basetypes_most::T_String& sCellNumber2_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sCellNumber2_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sCellNumber2();
    this->_sCellNumber2 = sCellNumber2_;
}

inline void T_PhonBkContactDetails::clearSHomeNumber1() {
    if (hasSHomeNumber1()) {
         clear_has_sHomeNumber1();
        _sHomeNumber1.clear();
     }
}

inline bool T_PhonBkContactDetails::hasSHomeNumber1 () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_PhonBkContactDetails::getSHomeNumber1 () const {
    return _sHomeNumber1;
}

inline ::fi_basetypes_most::T_String& T_PhonBkContactDetails::getSHomeNumber1Mutable () {
    set_has_sHomeNumber1();
    return _sHomeNumber1;
}

inline void T_PhonBkContactDetails::setSHomeNumber1 (const ::fi_basetypes_most::T_String& sHomeNumber1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sHomeNumber1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sHomeNumber1();
    this->_sHomeNumber1 = sHomeNumber1_;
}

inline void T_PhonBkContactDetails::clearSHomeNumber2() {
    if (hasSHomeNumber2()) {
         clear_has_sHomeNumber2();
        _sHomeNumber2.clear();
     }
}

inline bool T_PhonBkContactDetails::hasSHomeNumber2 () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_PhonBkContactDetails::getSHomeNumber2 () const {
    return _sHomeNumber2;
}

inline ::fi_basetypes_most::T_String& T_PhonBkContactDetails::getSHomeNumber2Mutable () {
    set_has_sHomeNumber2();
    return _sHomeNumber2;
}

inline void T_PhonBkContactDetails::setSHomeNumber2 (const ::fi_basetypes_most::T_String& sHomeNumber2_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sHomeNumber2_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sHomeNumber2();
    this->_sHomeNumber2 = sHomeNumber2_;
}

inline void T_PhonBkContactDetails::clearSWorkNumber1() {
    if (hasSWorkNumber1()) {
         clear_has_sWorkNumber1();
        _sWorkNumber1.clear();
     }
}

inline bool T_PhonBkContactDetails::hasSWorkNumber1 () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_PhonBkContactDetails::getSWorkNumber1 () const {
    return _sWorkNumber1;
}

inline ::fi_basetypes_most::T_String& T_PhonBkContactDetails::getSWorkNumber1Mutable () {
    set_has_sWorkNumber1();
    return _sWorkNumber1;
}

inline void T_PhonBkContactDetails::setSWorkNumber1 (const ::fi_basetypes_most::T_String& sWorkNumber1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sWorkNumber1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sWorkNumber1();
    this->_sWorkNumber1 = sWorkNumber1_;
}

inline void T_PhonBkContactDetails::clearSWorkNumber2() {
    if (hasSWorkNumber2()) {
         clear_has_sWorkNumber2();
        _sWorkNumber2.clear();
     }
}

inline bool T_PhonBkContactDetails::hasSWorkNumber2 () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_PhonBkContactDetails::getSWorkNumber2 () const {
    return _sWorkNumber2;
}

inline ::fi_basetypes_most::T_String& T_PhonBkContactDetails::getSWorkNumber2Mutable () {
    set_has_sWorkNumber2();
    return _sWorkNumber2;
}

inline void T_PhonBkContactDetails::setSWorkNumber2 (const ::fi_basetypes_most::T_String& sWorkNumber2_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sWorkNumber2_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sWorkNumber2();
    this->_sWorkNumber2 = sWorkNumber2_;
}

inline void T_PhonBkContactDetails::clearSOtherNumber() {
    if (hasSOtherNumber()) {
         clear_has_sOtherNumber();
        _sOtherNumber.clear();
     }
}

inline bool T_PhonBkContactDetails::hasSOtherNumber () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_PhonBkContactDetails::getSOtherNumber () const {
    return _sOtherNumber;
}

inline ::fi_basetypes_most::T_String& T_PhonBkContactDetails::getSOtherNumberMutable () {
    set_has_sOtherNumber();
    return _sOtherNumber;
}

inline void T_PhonBkContactDetails::setSOtherNumber (const ::fi_basetypes_most::T_String& sOtherNumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sOtherNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sOtherNumber();
    this->_sOtherNumber = sOtherNumber_;
}

inline void T_PhonBkContactDetails::clearSEmailAddress1() {
    if (hasSEmailAddress1()) {
         clear_has_sEmailAddress1();
        _sEmailAddress1.clear();
     }
}

inline bool T_PhonBkContactDetails::hasSEmailAddress1 () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_PhonBkContactDetails::getSEmailAddress1 () const {
    return _sEmailAddress1;
}

inline ::fi_basetypes_most::T_String& T_PhonBkContactDetails::getSEmailAddress1Mutable () {
    set_has_sEmailAddress1();
    return _sEmailAddress1;
}

inline void T_PhonBkContactDetails::setSEmailAddress1 (const ::fi_basetypes_most::T_String& sEmailAddress1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sEmailAddress1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sEmailAddress1();
    this->_sEmailAddress1 = sEmailAddress1_;
}

inline void T_PhonBkContactDetails::clearSEmailAddress2() {
    if (hasSEmailAddress2()) {
         clear_has_sEmailAddress2();
        _sEmailAddress2.clear();
     }
}

inline bool T_PhonBkContactDetails::hasSEmailAddress2 () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_PhonBkContactDetails::getSEmailAddress2 () const {
    return _sEmailAddress2;
}

inline ::fi_basetypes_most::T_String& T_PhonBkContactDetails::getSEmailAddress2Mutable () {
    set_has_sEmailAddress2();
    return _sEmailAddress2;
}

inline void T_PhonBkContactDetails::setSEmailAddress2 (const ::fi_basetypes_most::T_String& sEmailAddress2_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sEmailAddress2_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sEmailAddress2();
    this->_sEmailAddress2 = sEmailAddress2_;
}

inline void T_PhonBkContactDetails::clearSEmailAddress3() {
    if (hasSEmailAddress3()) {
         clear_has_sEmailAddress3();
        _sEmailAddress3.clear();
     }
}

inline bool T_PhonBkContactDetails::hasSEmailAddress3 () const {
    return (_has_bits_[0] & (1u << 13)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_PhonBkContactDetails::getSEmailAddress3 () const {
    return _sEmailAddress3;
}

inline ::fi_basetypes_most::T_String& T_PhonBkContactDetails::getSEmailAddress3Mutable () {
    set_has_sEmailAddress3();
    return _sEmailAddress3;
}

inline void T_PhonBkContactDetails::setSEmailAddress3 (const ::fi_basetypes_most::T_String& sEmailAddress3_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sEmailAddress3_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sEmailAddress3();
    this->_sEmailAddress3 = sEmailAddress3_;
}

inline void T_PhonBkContactDetails::clearSHomeAddress() {
    if (hasSHomeAddress()) {
         clear_has_sHomeAddress();
        _sHomeAddress.clear();
     }
}

inline bool T_PhonBkContactDetails::hasSHomeAddress () const {
    return (_has_bits_[0] & (1u << 14)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_PhonBkContactDetails::getSHomeAddress () const {
    return _sHomeAddress;
}

inline ::fi_basetypes_most::T_String& T_PhonBkContactDetails::getSHomeAddressMutable () {
    set_has_sHomeAddress();
    return _sHomeAddress;
}

inline void T_PhonBkContactDetails::setSHomeAddress (const ::fi_basetypes_most::T_String& sHomeAddress_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sHomeAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sHomeAddress();
    this->_sHomeAddress = sHomeAddress_;
}

inline void T_PhonBkContactDetails::clearSWorkAddress() {
    if (hasSWorkAddress()) {
         clear_has_sWorkAddress();
        _sWorkAddress.clear();
     }
}

inline bool T_PhonBkContactDetails::hasSWorkAddress () const {
    return (_has_bits_[0] & (1u << 15)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_PhonBkContactDetails::getSWorkAddress () const {
    return _sWorkAddress;
}

inline ::fi_basetypes_most::T_String& T_PhonBkContactDetails::getSWorkAddressMutable () {
    set_has_sWorkAddress();
    return _sWorkAddress;
}

inline void T_PhonBkContactDetails::setSWorkAddress (const ::fi_basetypes_most::T_String& sWorkAddress_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sWorkAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sWorkAddress();
    this->_sWorkAddress = sWorkAddress_;
}

inline void T_PhonBkContactDetails::clearSOtherAddress() {
    if (hasSOtherAddress()) {
         clear_has_sOtherAddress();
        _sOtherAddress.clear();
     }
}

inline bool T_PhonBkContactDetails::hasSOtherAddress () const {
    return (_has_bits_[0] & (1u << 16)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_PhonBkContactDetails::getSOtherAddress () const {
    return _sOtherAddress;
}

inline ::fi_basetypes_most::T_String& T_PhonBkContactDetails::getSOtherAddressMutable () {
    set_has_sOtherAddress();
    return _sOtherAddress;
}

inline void T_PhonBkContactDetails::setSOtherAddress (const ::fi_basetypes_most::T_String& sOtherAddress_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sOtherAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sOtherAddress();
    this->_sOtherAddress = sOtherAddress_;
}

inline void T_PhonBkContactDetails::clearSCategory() {
    if (hasSCategory()) {
         clear_has_sCategory();
        _sCategory.clear();
     }
}

inline bool T_PhonBkContactDetails::hasSCategory () const {
    return (_has_bits_[0] & (1u << 17)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_PhonBkContactDetails::getSCategory () const {
    return _sCategory;
}

inline ::fi_basetypes_most::T_String& T_PhonBkContactDetails::getSCategoryMutable () {
    set_has_sCategory();
    return _sCategory;
}

inline void T_PhonBkContactDetails::setSCategory (const ::fi_basetypes_most::T_String& sCategory_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sCategory_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sCategory();
    this->_sCategory = sCategory_;
}

inline void T_PhonBkContactDetails::clearSNotes() {
    if (hasSNotes()) {
         clear_has_sNotes();
        _sNotes.clear();
     }
}

inline bool T_PhonBkContactDetails::hasSNotes () const {
    return (_has_bits_[0] & (1u << 18)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_PhonBkContactDetails::getSNotes () const {
    return _sNotes;
}

inline ::fi_basetypes_most::T_String& T_PhonBkContactDetails::getSNotesMutable () {
    set_has_sNotes();
    return _sNotes;
}

inline void T_PhonBkContactDetails::setSNotes (const ::fi_basetypes_most::T_String& sNotes_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sNotes_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sNotes();
    this->_sNotes = sNotes_;
}

inline void T_PhonBkContactDetails::clearU32FirstNameTag() {
    if (hasU32FirstNameTag()) {
         clear_has_u32FirstNameTag();
        _u32FirstNameTag = 0u;
     }
}

inline bool T_PhonBkContactDetails::hasU32FirstNameTag () const {
    return (_has_bits_[0] & (1u << 19)) > 0;
}

inline uint32 T_PhonBkContactDetails::getU32FirstNameTag () const {
    return _u32FirstNameTag;
}

inline void T_PhonBkContactDetails::setU32FirstNameTag (uint32 u32FirstNameTag_) {
    set_has_u32FirstNameTag();
    this->_u32FirstNameTag = u32FirstNameTag_;
}

inline void T_PhonBkContactDetails::clearU32LastNameTag() {
    if (hasU32LastNameTag()) {
         clear_has_u32LastNameTag();
        _u32LastNameTag = 0u;
     }
}

inline bool T_PhonBkContactDetails::hasU32LastNameTag () const {
    return (_has_bits_[0] & (1u << 20)) > 0;
}

inline uint32 T_PhonBkContactDetails::getU32LastNameTag () const {
    return _u32LastNameTag;
}

inline void T_PhonBkContactDetails::setU32LastNameTag (uint32 u32LastNameTag_) {
    set_has_u32LastNameTag();
    this->_u32LastNameTag = u32LastNameTag_;
}

inline void T_PhonBkContactDetails::clearU32POINameTag() {
    if (hasU32POINameTag()) {
         clear_has_u32POINameTag();
        _u32POINameTag = 0u;
     }
}

inline bool T_PhonBkContactDetails::hasU32POINameTag () const {
    return (_has_bits_[0] & (1u << 21)) > 0;
}

inline uint32 T_PhonBkContactDetails::getU32POINameTag () const {
    return _u32POINameTag;
}

inline void T_PhonBkContactDetails::setU32POINameTag (uint32 u32POINameTag_) {
    set_has_u32POINameTag();
    this->_u32POINameTag = u32POINameTag_;
}

inline void T_PhonBkContactDetails::clearU32PrefNumTag() {
    if (hasU32PrefNumTag()) {
         clear_has_u32PrefNumTag();
        _u32PrefNumTag = 0u;
     }
}

inline bool T_PhonBkContactDetails::hasU32PrefNumTag () const {
    return (_has_bits_[0] & (1u << 22)) > 0;
}

inline uint32 T_PhonBkContactDetails::getU32PrefNumTag () const {
    return _u32PrefNumTag;
}

inline void T_PhonBkContactDetails::setU32PrefNumTag (uint32 u32PrefNumTag_) {
    set_has_u32PrefNumTag();
    this->_u32PrefNumTag = u32PrefNumTag_;
}

inline void T_PhonBkContactDetails::clearU32CellNum1Tag() {
    if (hasU32CellNum1Tag()) {
         clear_has_u32CellNum1Tag();
        _u32CellNum1Tag = 0u;
     }
}

inline bool T_PhonBkContactDetails::hasU32CellNum1Tag () const {
    return (_has_bits_[0] & (1u << 23)) > 0;
}

inline uint32 T_PhonBkContactDetails::getU32CellNum1Tag () const {
    return _u32CellNum1Tag;
}

inline void T_PhonBkContactDetails::setU32CellNum1Tag (uint32 u32CellNum1Tag_) {
    set_has_u32CellNum1Tag();
    this->_u32CellNum1Tag = u32CellNum1Tag_;
}

inline void T_PhonBkContactDetails::clearU32CellNum2Tag() {
    if (hasU32CellNum2Tag()) {
         clear_has_u32CellNum2Tag();
        _u32CellNum2Tag = 0u;
     }
}

inline bool T_PhonBkContactDetails::hasU32CellNum2Tag () const {
    return (_has_bits_[0] & (1u << 24)) > 0;
}

inline uint32 T_PhonBkContactDetails::getU32CellNum2Tag () const {
    return _u32CellNum2Tag;
}

inline void T_PhonBkContactDetails::setU32CellNum2Tag (uint32 u32CellNum2Tag_) {
    set_has_u32CellNum2Tag();
    this->_u32CellNum2Tag = u32CellNum2Tag_;
}

inline void T_PhonBkContactDetails::clearU32HomeNum1Tag() {
    if (hasU32HomeNum1Tag()) {
         clear_has_u32HomeNum1Tag();
        _u32HomeNum1Tag = 0u;
     }
}

inline bool T_PhonBkContactDetails::hasU32HomeNum1Tag () const {
    return (_has_bits_[0] & (1u << 25)) > 0;
}

inline uint32 T_PhonBkContactDetails::getU32HomeNum1Tag () const {
    return _u32HomeNum1Tag;
}

inline void T_PhonBkContactDetails::setU32HomeNum1Tag (uint32 u32HomeNum1Tag_) {
    set_has_u32HomeNum1Tag();
    this->_u32HomeNum1Tag = u32HomeNum1Tag_;
}

inline void T_PhonBkContactDetails::clearU32HomeNum2Tag() {
    if (hasU32HomeNum2Tag()) {
         clear_has_u32HomeNum2Tag();
        _u32HomeNum2Tag = 0u;
     }
}

inline bool T_PhonBkContactDetails::hasU32HomeNum2Tag () const {
    return (_has_bits_[0] & (1u << 26)) > 0;
}

inline uint32 T_PhonBkContactDetails::getU32HomeNum2Tag () const {
    return _u32HomeNum2Tag;
}

inline void T_PhonBkContactDetails::setU32HomeNum2Tag (uint32 u32HomeNum2Tag_) {
    set_has_u32HomeNum2Tag();
    this->_u32HomeNum2Tag = u32HomeNum2Tag_;
}

inline void T_PhonBkContactDetails::clearU32WorkNum1Tag() {
    if (hasU32WorkNum1Tag()) {
         clear_has_u32WorkNum1Tag();
        _u32WorkNum1Tag = 0u;
     }
}

inline bool T_PhonBkContactDetails::hasU32WorkNum1Tag () const {
    return (_has_bits_[0] & (1u << 27)) > 0;
}

inline uint32 T_PhonBkContactDetails::getU32WorkNum1Tag () const {
    return _u32WorkNum1Tag;
}

inline void T_PhonBkContactDetails::setU32WorkNum1Tag (uint32 u32WorkNum1Tag_) {
    set_has_u32WorkNum1Tag();
    this->_u32WorkNum1Tag = u32WorkNum1Tag_;
}

inline void T_PhonBkContactDetails::clearU32WorkNum2Tag() {
    if (hasU32WorkNum2Tag()) {
         clear_has_u32WorkNum2Tag();
        _u32WorkNum2Tag = 0u;
     }
}

inline bool T_PhonBkContactDetails::hasU32WorkNum2Tag () const {
    return (_has_bits_[0] & (1u << 28)) > 0;
}

inline uint32 T_PhonBkContactDetails::getU32WorkNum2Tag () const {
    return _u32WorkNum2Tag;
}

inline void T_PhonBkContactDetails::setU32WorkNum2Tag (uint32 u32WorkNum2Tag_) {
    set_has_u32WorkNum2Tag();
    this->_u32WorkNum2Tag = u32WorkNum2Tag_;
}

inline void T_PhonBkContactDetails::clearU32OtherNumTag() {
    if (hasU32OtherNumTag()) {
         clear_has_u32OtherNumTag();
        _u32OtherNumTag = 0u;
     }
}

inline bool T_PhonBkContactDetails::hasU32OtherNumTag () const {
    return (_has_bits_[0] & (1u << 29)) > 0;
}

inline uint32 T_PhonBkContactDetails::getU32OtherNumTag () const {
    return _u32OtherNumTag;
}

inline void T_PhonBkContactDetails::setU32OtherNumTag (uint32 u32OtherNumTag_) {
    set_has_u32OtherNumTag();
    this->_u32OtherNumTag = u32OtherNumTag_;
}

inline void T_PhonBkContactDetails::clearU32EmailAdd1Tag() {
    if (hasU32EmailAdd1Tag()) {
         clear_has_u32EmailAdd1Tag();
        _u32EmailAdd1Tag = 0u;
     }
}

inline bool T_PhonBkContactDetails::hasU32EmailAdd1Tag () const {
    return (_has_bits_[0] & (1u << 30)) > 0;
}

inline uint32 T_PhonBkContactDetails::getU32EmailAdd1Tag () const {
    return _u32EmailAdd1Tag;
}

inline void T_PhonBkContactDetails::setU32EmailAdd1Tag (uint32 u32EmailAdd1Tag_) {
    set_has_u32EmailAdd1Tag();
    this->_u32EmailAdd1Tag = u32EmailAdd1Tag_;
}

inline void T_PhonBkContactDetails::clearU32EmailAdd2Tag() {
    if (hasU32EmailAdd2Tag()) {
         clear_has_u32EmailAdd2Tag();
        _u32EmailAdd2Tag = 0u;
     }
}

inline bool T_PhonBkContactDetails::hasU32EmailAdd2Tag () const {
    return (_has_bits_[0] & (1u << 31)) > 0;
}

inline uint32 T_PhonBkContactDetails::getU32EmailAdd2Tag () const {
    return _u32EmailAdd2Tag;
}

inline void T_PhonBkContactDetails::setU32EmailAdd2Tag (uint32 u32EmailAdd2Tag_) {
    set_has_u32EmailAdd2Tag();
    this->_u32EmailAdd2Tag = u32EmailAdd2Tag_;
}

inline void T_PhonBkContactDetails::clearU32EmailAdd3Tag() {
    if (hasU32EmailAdd3Tag()) {
         clear_has_u32EmailAdd3Tag();
        _u32EmailAdd3Tag = 0u;
     }
}

inline bool T_PhonBkContactDetails::hasU32EmailAdd3Tag () const {
    return (_has_bits_[1] & (1u << 0)) > 0;
}

inline uint32 T_PhonBkContactDetails::getU32EmailAdd3Tag () const {
    return _u32EmailAdd3Tag;
}

inline void T_PhonBkContactDetails::setU32EmailAdd3Tag (uint32 u32EmailAdd3Tag_) {
    set_has_u32EmailAdd3Tag();
    this->_u32EmailAdd3Tag = u32EmailAdd3Tag_;
}

inline void T_PhonBkContactDetails::clearU32HomeAddTag() {
    if (hasU32HomeAddTag()) {
         clear_has_u32HomeAddTag();
        _u32HomeAddTag = 0u;
     }
}

inline bool T_PhonBkContactDetails::hasU32HomeAddTag () const {
    return (_has_bits_[1] & (1u << 1)) > 0;
}

inline uint32 T_PhonBkContactDetails::getU32HomeAddTag () const {
    return _u32HomeAddTag;
}

inline void T_PhonBkContactDetails::setU32HomeAddTag (uint32 u32HomeAddTag_) {
    set_has_u32HomeAddTag();
    this->_u32HomeAddTag = u32HomeAddTag_;
}

inline void T_PhonBkContactDetails::clearU32WorkAddTag() {
    if (hasU32WorkAddTag()) {
         clear_has_u32WorkAddTag();
        _u32WorkAddTag = 0u;
     }
}

inline bool T_PhonBkContactDetails::hasU32WorkAddTag () const {
    return (_has_bits_[1] & (1u << 2)) > 0;
}

inline uint32 T_PhonBkContactDetails::getU32WorkAddTag () const {
    return _u32WorkAddTag;
}

inline void T_PhonBkContactDetails::setU32WorkAddTag (uint32 u32WorkAddTag_) {
    set_has_u32WorkAddTag();
    this->_u32WorkAddTag = u32WorkAddTag_;
}

inline void T_PhonBkContactDetails::clearU32OtherAddTag() {
    if (hasU32OtherAddTag()) {
         clear_has_u32OtherAddTag();
        _u32OtherAddTag = 0u;
     }
}

inline bool T_PhonBkContactDetails::hasU32OtherAddTag () const {
    return (_has_bits_[1] & (1u << 3)) > 0;
}

inline uint32 T_PhonBkContactDetails::getU32OtherAddTag () const {
    return _u32OtherAddTag;
}

inline void T_PhonBkContactDetails::setU32OtherAddTag (uint32 u32OtherAddTag_) {
    set_has_u32OtherAddTag();
    this->_u32OtherAddTag = u32OtherAddTag_;
}

inline void T_PhonBkContactDetails::clearU32CategoryTag() {
    if (hasU32CategoryTag()) {
         clear_has_u32CategoryTag();
        _u32CategoryTag = 0u;
     }
}

inline bool T_PhonBkContactDetails::hasU32CategoryTag () const {
    return (_has_bits_[1] & (1u << 4)) > 0;
}

inline uint32 T_PhonBkContactDetails::getU32CategoryTag () const {
    return _u32CategoryTag;
}

inline void T_PhonBkContactDetails::setU32CategoryTag (uint32 u32CategoryTag_) {
    set_has_u32CategoryTag();
    this->_u32CategoryTag = u32CategoryTag_;
}

inline void T_PhonBkContactDetails::clearU32NotesTag() {
    if (hasU32NotesTag()) {
         clear_has_u32NotesTag();
        _u32NotesTag = 0u;
     }
}

inline bool T_PhonBkContactDetails::hasU32NotesTag () const {
    return (_has_bits_[1] & (1u << 5)) > 0;
}

inline uint32 T_PhonBkContactDetails::getU32NotesTag () const {
    return _u32NotesTag;
}

inline void T_PhonBkContactDetails::setU32NotesTag (uint32 u32NotesTag_) {
    set_has_u32NotesTag();
    this->_u32NotesTag = u32NotesTag_;
}

inline void T_PhonBkContactDetails::clearBPhotoAvailable() {
    if (hasBPhotoAvailable()) {
         clear_has_bPhotoAvailable();
        _bPhotoAvailable = false;
     }
}

inline bool T_PhonBkContactDetails::hasBPhotoAvailable () const {
    return (_has_bits_[1] & (1u << 6)) > 0;
}

inline bool T_PhonBkContactDetails::getBPhotoAvailable () const {
    return _bPhotoAvailable;
}

inline void T_PhonBkContactDetails::setBPhotoAvailable (bool bPhotoAvailable_) {
    set_has_bPhotoAvailable();
    this->_bPhotoAvailable = bPhotoAvailable_;
}

inline void T_PhonBkContactDetails::clearOHomeAddressLatLong() {
    if (hasOHomeAddressLatLong()) {
         clear_has_oHomeAddressLatLong();
        _oHomeAddressLatLong.clear();
     }
}

inline bool T_PhonBkContactDetails::hasOHomeAddressLatLong () const {
    return (_has_bits_[1] & (1u << 7)) > 0;
}

inline const T_PhonBkHomeAddressLatLong& T_PhonBkContactDetails::getOHomeAddressLatLong () const {
    return _oHomeAddressLatLong;
}

inline T_PhonBkHomeAddressLatLong& T_PhonBkContactDetails::getOHomeAddressLatLongMutable () {
    set_has_oHomeAddressLatLong();
    return _oHomeAddressLatLong;
}

inline void T_PhonBkContactDetails::setOHomeAddressLatLong (const T_PhonBkHomeAddressLatLong& oHomeAddressLatLong_) {
    set_has_oHomeAddressLatLong();
    this->_oHomeAddressLatLong = oHomeAddressLatLong_;
}

inline void T_PhonBkContactDetails::clearOWorkAddressLatLong() {
    if (hasOWorkAddressLatLong()) {
         clear_has_oWorkAddressLatLong();
        _oWorkAddressLatLong.clear();
     }
}

inline bool T_PhonBkContactDetails::hasOWorkAddressLatLong () const {
    return (_has_bits_[1] & (1u << 8)) > 0;
}

inline const T_PhonBkWorkAddressLatLong& T_PhonBkContactDetails::getOWorkAddressLatLong () const {
    return _oWorkAddressLatLong;
}

inline T_PhonBkWorkAddressLatLong& T_PhonBkContactDetails::getOWorkAddressLatLongMutable () {
    set_has_oWorkAddressLatLong();
    return _oWorkAddressLatLong;
}

inline void T_PhonBkContactDetails::setOWorkAddressLatLong (const T_PhonBkWorkAddressLatLong& oWorkAddressLatLong_) {
    set_has_oWorkAddressLatLong();
    this->_oWorkAddressLatLong = oWorkAddressLatLong_;
}

inline void T_PhonBkContactDetails::clearOOtherAddressLatLong() {
    if (hasOOtherAddressLatLong()) {
         clear_has_oOtherAddressLatLong();
        _oOtherAddressLatLong.clear();
     }
}

inline bool T_PhonBkContactDetails::hasOOtherAddressLatLong () const {
    return (_has_bits_[1] & (1u << 9)) > 0;
}

inline const T_PhonBkOtherAddressLatLong& T_PhonBkContactDetails::getOOtherAddressLatLong () const {
    return _oOtherAddressLatLong;
}

inline T_PhonBkOtherAddressLatLong& T_PhonBkContactDetails::getOOtherAddressLatLongMutable () {
    set_has_oOtherAddressLatLong();
    return _oOtherAddressLatLong;
}

inline void T_PhonBkContactDetails::setOOtherAddressLatLong (const T_PhonBkOtherAddressLatLong& oOtherAddressLatLong_) {
    set_has_oOtherAddressLatLong();
    this->_oOtherAddressLatLong = oOtherAddressLatLong_;
}

inline void T_PhonBkContactDetails::set_has_sFirstName () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_PhonBkContactDetails::clear_has_sFirstName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_PhonBkContactDetails::set_has_sLastName () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_PhonBkContactDetails::clear_has_sLastName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_PhonBkContactDetails::set_has_sPOIName () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_PhonBkContactDetails::clear_has_sPOIName () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_PhonBkContactDetails::set_has_sPreferredNumber () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_PhonBkContactDetails::clear_has_sPreferredNumber () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_PhonBkContactDetails::set_has_sCellNumber1 () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_PhonBkContactDetails::clear_has_sCellNumber1 () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_PhonBkContactDetails::set_has_sCellNumber2 () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_PhonBkContactDetails::clear_has_sCellNumber2 () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_PhonBkContactDetails::set_has_sHomeNumber1 () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_PhonBkContactDetails::clear_has_sHomeNumber1 () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_PhonBkContactDetails::set_has_sHomeNumber2 () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_PhonBkContactDetails::clear_has_sHomeNumber2 () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_PhonBkContactDetails::set_has_sWorkNumber1 () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_PhonBkContactDetails::clear_has_sWorkNumber1 () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_PhonBkContactDetails::set_has_sWorkNumber2 () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_PhonBkContactDetails::clear_has_sWorkNumber2 () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_PhonBkContactDetails::set_has_sOtherNumber () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_PhonBkContactDetails::clear_has_sOtherNumber () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void T_PhonBkContactDetails::set_has_sEmailAddress1 () {
    _has_bits_[0] |= 1u << 11;
}

inline void T_PhonBkContactDetails::clear_has_sEmailAddress1 () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void T_PhonBkContactDetails::set_has_sEmailAddress2 () {
    _has_bits_[0] |= 1u << 12;
}

inline void T_PhonBkContactDetails::clear_has_sEmailAddress2 () {
    _has_bits_[0] &= ~ (1u << 12);
}

inline void T_PhonBkContactDetails::set_has_sEmailAddress3 () {
    _has_bits_[0] |= 1u << 13;
}

inline void T_PhonBkContactDetails::clear_has_sEmailAddress3 () {
    _has_bits_[0] &= ~ (1u << 13);
}

inline void T_PhonBkContactDetails::set_has_sHomeAddress () {
    _has_bits_[0] |= 1u << 14;
}

inline void T_PhonBkContactDetails::clear_has_sHomeAddress () {
    _has_bits_[0] &= ~ (1u << 14);
}

inline void T_PhonBkContactDetails::set_has_sWorkAddress () {
    _has_bits_[0] |= 1u << 15;
}

inline void T_PhonBkContactDetails::clear_has_sWorkAddress () {
    _has_bits_[0] &= ~ (1u << 15);
}

inline void T_PhonBkContactDetails::set_has_sOtherAddress () {
    _has_bits_[0] |= 1u << 16;
}

inline void T_PhonBkContactDetails::clear_has_sOtherAddress () {
    _has_bits_[0] &= ~ (1u << 16);
}

inline void T_PhonBkContactDetails::set_has_sCategory () {
    _has_bits_[0] |= 1u << 17;
}

inline void T_PhonBkContactDetails::clear_has_sCategory () {
    _has_bits_[0] &= ~ (1u << 17);
}

inline void T_PhonBkContactDetails::set_has_sNotes () {
    _has_bits_[0] |= 1u << 18;
}

inline void T_PhonBkContactDetails::clear_has_sNotes () {
    _has_bits_[0] &= ~ (1u << 18);
}

inline void T_PhonBkContactDetails::set_has_u32FirstNameTag () {
    _has_bits_[0] |= 1u << 19;
}

inline void T_PhonBkContactDetails::clear_has_u32FirstNameTag () {
    _has_bits_[0] &= ~ (1u << 19);
}

inline void T_PhonBkContactDetails::set_has_u32LastNameTag () {
    _has_bits_[0] |= 1u << 20;
}

inline void T_PhonBkContactDetails::clear_has_u32LastNameTag () {
    _has_bits_[0] &= ~ (1u << 20);
}

inline void T_PhonBkContactDetails::set_has_u32POINameTag () {
    _has_bits_[0] |= 1u << 21;
}

inline void T_PhonBkContactDetails::clear_has_u32POINameTag () {
    _has_bits_[0] &= ~ (1u << 21);
}

inline void T_PhonBkContactDetails::set_has_u32PrefNumTag () {
    _has_bits_[0] |= 1u << 22;
}

inline void T_PhonBkContactDetails::clear_has_u32PrefNumTag () {
    _has_bits_[0] &= ~ (1u << 22);
}

inline void T_PhonBkContactDetails::set_has_u32CellNum1Tag () {
    _has_bits_[0] |= 1u << 23;
}

inline void T_PhonBkContactDetails::clear_has_u32CellNum1Tag () {
    _has_bits_[0] &= ~ (1u << 23);
}

inline void T_PhonBkContactDetails::set_has_u32CellNum2Tag () {
    _has_bits_[0] |= 1u << 24;
}

inline void T_PhonBkContactDetails::clear_has_u32CellNum2Tag () {
    _has_bits_[0] &= ~ (1u << 24);
}

inline void T_PhonBkContactDetails::set_has_u32HomeNum1Tag () {
    _has_bits_[0] |= 1u << 25;
}

inline void T_PhonBkContactDetails::clear_has_u32HomeNum1Tag () {
    _has_bits_[0] &= ~ (1u << 25);
}

inline void T_PhonBkContactDetails::set_has_u32HomeNum2Tag () {
    _has_bits_[0] |= 1u << 26;
}

inline void T_PhonBkContactDetails::clear_has_u32HomeNum2Tag () {
    _has_bits_[0] &= ~ (1u << 26);
}

inline void T_PhonBkContactDetails::set_has_u32WorkNum1Tag () {
    _has_bits_[0] |= 1u << 27;
}

inline void T_PhonBkContactDetails::clear_has_u32WorkNum1Tag () {
    _has_bits_[0] &= ~ (1u << 27);
}

inline void T_PhonBkContactDetails::set_has_u32WorkNum2Tag () {
    _has_bits_[0] |= 1u << 28;
}

inline void T_PhonBkContactDetails::clear_has_u32WorkNum2Tag () {
    _has_bits_[0] &= ~ (1u << 28);
}

inline void T_PhonBkContactDetails::set_has_u32OtherNumTag () {
    _has_bits_[0] |= 1u << 29;
}

inline void T_PhonBkContactDetails::clear_has_u32OtherNumTag () {
    _has_bits_[0] &= ~ (1u << 29);
}

inline void T_PhonBkContactDetails::set_has_u32EmailAdd1Tag () {
    _has_bits_[0] |= 1u << 30;
}

inline void T_PhonBkContactDetails::clear_has_u32EmailAdd1Tag () {
    _has_bits_[0] &= ~ (1u << 30);
}

inline void T_PhonBkContactDetails::set_has_u32EmailAdd2Tag () {
    _has_bits_[0] |= 1u << 31;
}

inline void T_PhonBkContactDetails::clear_has_u32EmailAdd2Tag () {
    _has_bits_[0] &= ~ (1u << 31);
}

inline void T_PhonBkContactDetails::set_has_u32EmailAdd3Tag () {
    _has_bits_[1] |= 1u << 0;
}

inline void T_PhonBkContactDetails::clear_has_u32EmailAdd3Tag () {
    _has_bits_[1] &= ~ (1u << 0);
}

inline void T_PhonBkContactDetails::set_has_u32HomeAddTag () {
    _has_bits_[1] |= 1u << 1;
}

inline void T_PhonBkContactDetails::clear_has_u32HomeAddTag () {
    _has_bits_[1] &= ~ (1u << 1);
}

inline void T_PhonBkContactDetails::set_has_u32WorkAddTag () {
    _has_bits_[1] |= 1u << 2;
}

inline void T_PhonBkContactDetails::clear_has_u32WorkAddTag () {
    _has_bits_[1] &= ~ (1u << 2);
}

inline void T_PhonBkContactDetails::set_has_u32OtherAddTag () {
    _has_bits_[1] |= 1u << 3;
}

inline void T_PhonBkContactDetails::clear_has_u32OtherAddTag () {
    _has_bits_[1] &= ~ (1u << 3);
}

inline void T_PhonBkContactDetails::set_has_u32CategoryTag () {
    _has_bits_[1] |= 1u << 4;
}

inline void T_PhonBkContactDetails::clear_has_u32CategoryTag () {
    _has_bits_[1] &= ~ (1u << 4);
}

inline void T_PhonBkContactDetails::set_has_u32NotesTag () {
    _has_bits_[1] |= 1u << 5;
}

inline void T_PhonBkContactDetails::clear_has_u32NotesTag () {
    _has_bits_[1] &= ~ (1u << 5);
}

inline void T_PhonBkContactDetails::set_has_bPhotoAvailable () {
    _has_bits_[1] |= 1u << 6;
}

inline void T_PhonBkContactDetails::clear_has_bPhotoAvailable () {
    _has_bits_[1] &= ~ (1u << 6);
}

inline void T_PhonBkContactDetails::set_has_oHomeAddressLatLong () {
    _has_bits_[1] |= 1u << 7;
}

inline void T_PhonBkContactDetails::clear_has_oHomeAddressLatLong () {
    _has_bits_[1] &= ~ (1u << 7);
}

inline void T_PhonBkContactDetails::set_has_oWorkAddressLatLong () {
    _has_bits_[1] |= 1u << 8;
}

inline void T_PhonBkContactDetails::clear_has_oWorkAddressLatLong () {
    _has_bits_[1] &= ~ (1u << 8);
}

inline void T_PhonBkContactDetails::set_has_oOtherAddressLatLong () {
    _has_bits_[1] |= 1u << 9;
}

inline void T_PhonBkContactDetails::clear_has_oOtherAddressLatLong () {
    _has_bits_[1] &= ~ (1u << 9);
}

inline  T_PhonBkCallDate::T_PhonBkCallDate ()  :
    _sCldrYear (),
    _sCldrMonth (),
    _sCldrDay ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_PhonBkCallDate::T_PhonBkCallDate (const T_PhonBkCallDate &rhs)  :
    _sCldrYear (),
    _sCldrMonth (),
    _sCldrDay ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_PhonBkCallDate::T_PhonBkCallDate (const ::fi_basetypes_most::T_String& sCldrYear_, const ::fi_basetypes_most::T_String& sCldrMonth_, const ::fi_basetypes_most::T_String& sCldrDay_)  :
    _sCldrYear (sCldrYear_),
    _sCldrMonth (sCldrMonth_),
    _sCldrDay (sCldrDay_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sCldrYear_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sCldrMonth_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sCldrDay_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_PhonBkCallDate::~T_PhonBkCallDate() {
}

inline T_PhonBkCallDate& T_PhonBkCallDate::operator = (const T_PhonBkCallDate& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSCldrYear()) {
            setSCldrYear(rhs.getSCldrYear());
        } else {
            clearSCldrYear();
        }
        if (rhs.hasSCldrMonth()) {
            setSCldrMonth(rhs.getSCldrMonth());
        } else {
            clearSCldrMonth();
        }
        if (rhs.hasSCldrDay()) {
            setSCldrDay(rhs.getSCldrDay());
        } else {
            clearSCldrDay();
        }
    }
    return *this;
}

inline bool T_PhonBkCallDate::operator == (const T_PhonBkCallDate& rhs) const {
    return (((!hasSCldrYear() && !rhs.hasSCldrYear()) || getSCldrYear() == rhs.getSCldrYear()) &&
        ((!hasSCldrMonth() && !rhs.hasSCldrMonth()) || getSCldrMonth() == rhs.getSCldrMonth()) &&
        ((!hasSCldrDay() && !rhs.hasSCldrDay()) || getSCldrDay() == rhs.getSCldrDay()));
}

inline bool T_PhonBkCallDate::operator != (const T_PhonBkCallDate& rhs) const {
    return ! (*this == rhs);
}

inline bool T_PhonBkCallDate::operator < (const T_PhonBkCallDate& rhs) const {
    if (hasSCldrYear() || rhs.hasSCldrYear()) {
        if (getSCldrYear() < rhs.getSCldrYear()) return true;
        if (getSCldrYear() > rhs.getSCldrYear()) return false;
    }
    if (hasSCldrMonth() || rhs.hasSCldrMonth()) {
        if (getSCldrMonth() < rhs.getSCldrMonth()) return true;
        if (getSCldrMonth() > rhs.getSCldrMonth()) return false;
    }
    if (hasSCldrDay() || rhs.hasSCldrDay()) {
        if (getSCldrDay() < rhs.getSCldrDay()) return true;
        if (getSCldrDay() > rhs.getSCldrDay()) return false;
    }
    return false;
}

inline bool T_PhonBkCallDate::operator > (const T_PhonBkCallDate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_PhonBkCallDate::clear() {
    clearSCldrYear();
    clearSCldrMonth();
    clearSCldrDay();
}

inline void T_PhonBkCallDate::clearSCldrYear() {
    if (hasSCldrYear()) {
         clear_has_sCldrYear();
        _sCldrYear.clear();
     }
}

inline bool T_PhonBkCallDate::hasSCldrYear () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_PhonBkCallDate::getSCldrYear () const {
    return _sCldrYear;
}

inline ::fi_basetypes_most::T_String& T_PhonBkCallDate::getSCldrYearMutable () {
    set_has_sCldrYear();
    return _sCldrYear;
}

inline void T_PhonBkCallDate::setSCldrYear (const ::fi_basetypes_most::T_String& sCldrYear_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sCldrYear_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sCldrYear();
    this->_sCldrYear = sCldrYear_;
}

inline void T_PhonBkCallDate::clearSCldrMonth() {
    if (hasSCldrMonth()) {
         clear_has_sCldrMonth();
        _sCldrMonth.clear();
     }
}

inline bool T_PhonBkCallDate::hasSCldrMonth () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_PhonBkCallDate::getSCldrMonth () const {
    return _sCldrMonth;
}

inline ::fi_basetypes_most::T_String& T_PhonBkCallDate::getSCldrMonthMutable () {
    set_has_sCldrMonth();
    return _sCldrMonth;
}

inline void T_PhonBkCallDate::setSCldrMonth (const ::fi_basetypes_most::T_String& sCldrMonth_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sCldrMonth_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sCldrMonth();
    this->_sCldrMonth = sCldrMonth_;
}

inline void T_PhonBkCallDate::clearSCldrDay() {
    if (hasSCldrDay()) {
         clear_has_sCldrDay();
        _sCldrDay.clear();
     }
}

inline bool T_PhonBkCallDate::hasSCldrDay () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_PhonBkCallDate::getSCldrDay () const {
    return _sCldrDay;
}

inline ::fi_basetypes_most::T_String& T_PhonBkCallDate::getSCldrDayMutable () {
    set_has_sCldrDay();
    return _sCldrDay;
}

inline void T_PhonBkCallDate::setSCldrDay (const ::fi_basetypes_most::T_String& sCldrDay_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sCldrDay_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sCldrDay();
    this->_sCldrDay = sCldrDay_;
}

inline void T_PhonBkCallDate::set_has_sCldrYear () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_PhonBkCallDate::clear_has_sCldrYear () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_PhonBkCallDate::set_has_sCldrMonth () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_PhonBkCallDate::clear_has_sCldrMonth () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_PhonBkCallDate::set_has_sCldrDay () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_PhonBkCallDate::clear_has_sCldrDay () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_PhonBkCallTime::T_PhonBkCallTime ()  :
    _sHours (),
    _sMinutes (),
    _sSeconds ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_PhonBkCallTime::T_PhonBkCallTime (const T_PhonBkCallTime &rhs)  :
    _sHours (),
    _sMinutes (),
    _sSeconds ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_PhonBkCallTime::T_PhonBkCallTime (const ::fi_basetypes_most::T_String& sHours_, const ::fi_basetypes_most::T_String& sMinutes_, const ::fi_basetypes_most::T_String& sSeconds_)  :
    _sHours (sHours_),
    _sMinutes (sMinutes_),
    _sSeconds (sSeconds_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sHours_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sMinutes_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sSeconds_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_PhonBkCallTime::~T_PhonBkCallTime() {
}

inline T_PhonBkCallTime& T_PhonBkCallTime::operator = (const T_PhonBkCallTime& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSHours()) {
            setSHours(rhs.getSHours());
        } else {
            clearSHours();
        }
        if (rhs.hasSMinutes()) {
            setSMinutes(rhs.getSMinutes());
        } else {
            clearSMinutes();
        }
        if (rhs.hasSSeconds()) {
            setSSeconds(rhs.getSSeconds());
        } else {
            clearSSeconds();
        }
    }
    return *this;
}

inline bool T_PhonBkCallTime::operator == (const T_PhonBkCallTime& rhs) const {
    return (((!hasSHours() && !rhs.hasSHours()) || getSHours() == rhs.getSHours()) &&
        ((!hasSMinutes() && !rhs.hasSMinutes()) || getSMinutes() == rhs.getSMinutes()) &&
        ((!hasSSeconds() && !rhs.hasSSeconds()) || getSSeconds() == rhs.getSSeconds()));
}

inline bool T_PhonBkCallTime::operator != (const T_PhonBkCallTime& rhs) const {
    return ! (*this == rhs);
}

inline bool T_PhonBkCallTime::operator < (const T_PhonBkCallTime& rhs) const {
    if (hasSHours() || rhs.hasSHours()) {
        if (getSHours() < rhs.getSHours()) return true;
        if (getSHours() > rhs.getSHours()) return false;
    }
    if (hasSMinutes() || rhs.hasSMinutes()) {
        if (getSMinutes() < rhs.getSMinutes()) return true;
        if (getSMinutes() > rhs.getSMinutes()) return false;
    }
    if (hasSSeconds() || rhs.hasSSeconds()) {
        if (getSSeconds() < rhs.getSSeconds()) return true;
        if (getSSeconds() > rhs.getSSeconds()) return false;
    }
    return false;
}

inline bool T_PhonBkCallTime::operator > (const T_PhonBkCallTime& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_PhonBkCallTime::clear() {
    clearSHours();
    clearSMinutes();
    clearSSeconds();
}

inline void T_PhonBkCallTime::clearSHours() {
    if (hasSHours()) {
         clear_has_sHours();
        _sHours.clear();
     }
}

inline bool T_PhonBkCallTime::hasSHours () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_PhonBkCallTime::getSHours () const {
    return _sHours;
}

inline ::fi_basetypes_most::T_String& T_PhonBkCallTime::getSHoursMutable () {
    set_has_sHours();
    return _sHours;
}

inline void T_PhonBkCallTime::setSHours (const ::fi_basetypes_most::T_String& sHours_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sHours_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sHours();
    this->_sHours = sHours_;
}

inline void T_PhonBkCallTime::clearSMinutes() {
    if (hasSMinutes()) {
         clear_has_sMinutes();
        _sMinutes.clear();
     }
}

inline bool T_PhonBkCallTime::hasSMinutes () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_PhonBkCallTime::getSMinutes () const {
    return _sMinutes;
}

inline ::fi_basetypes_most::T_String& T_PhonBkCallTime::getSMinutesMutable () {
    set_has_sMinutes();
    return _sMinutes;
}

inline void T_PhonBkCallTime::setSMinutes (const ::fi_basetypes_most::T_String& sMinutes_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sMinutes_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sMinutes();
    this->_sMinutes = sMinutes_;
}

inline void T_PhonBkCallTime::clearSSeconds() {
    if (hasSSeconds()) {
         clear_has_sSeconds();
        _sSeconds.clear();
     }
}

inline bool T_PhonBkCallTime::hasSSeconds () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_PhonBkCallTime::getSSeconds () const {
    return _sSeconds;
}

inline ::fi_basetypes_most::T_String& T_PhonBkCallTime::getSSecondsMutable () {
    set_has_sSeconds();
    return _sSeconds;
}

inline void T_PhonBkCallTime::setSSeconds (const ::fi_basetypes_most::T_String& sSeconds_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sSeconds_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sSeconds();
    this->_sSeconds = sSeconds_;
}

inline void T_PhonBkCallTime::set_has_sHours () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_PhonBkCallTime::clear_has_sHours () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_PhonBkCallTime::set_has_sMinutes () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_PhonBkCallTime::clear_has_sMinutes () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_PhonBkCallTime::set_has_sSeconds () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_PhonBkCallTime::clear_has_sSeconds () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_PhonBkCallDateTime::T_PhonBkCallDateTime ()  :
    _oCallDate (),
    _oCallTime ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_PhonBkCallDateTime::T_PhonBkCallDateTime (const T_PhonBkCallDateTime &rhs)  :
    _oCallDate (),
    _oCallTime ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_PhonBkCallDateTime::T_PhonBkCallDateTime (const T_PhonBkCallDate& oCallDate_, const T_PhonBkCallTime& oCallTime_)  :
    _oCallDate (oCallDate_),
    _oCallTime (oCallTime_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_PhonBkCallDateTime::~T_PhonBkCallDateTime() {
}

inline T_PhonBkCallDateTime& T_PhonBkCallDateTime::operator = (const T_PhonBkCallDateTime& rhs) {
    if( this != &rhs ) {
        if (rhs.hasOCallDate()) {
            setOCallDate(rhs.getOCallDate());
        } else {
            clearOCallDate();
        }
        if (rhs.hasOCallTime()) {
            setOCallTime(rhs.getOCallTime());
        } else {
            clearOCallTime();
        }
    }
    return *this;
}

inline bool T_PhonBkCallDateTime::operator == (const T_PhonBkCallDateTime& rhs) const {
    return (((!hasOCallDate() && !rhs.hasOCallDate()) || getOCallDate() == rhs.getOCallDate()) &&
        ((!hasOCallTime() && !rhs.hasOCallTime()) || getOCallTime() == rhs.getOCallTime()));
}

inline bool T_PhonBkCallDateTime::operator != (const T_PhonBkCallDateTime& rhs) const {
    return ! (*this == rhs);
}

inline bool T_PhonBkCallDateTime::operator < (const T_PhonBkCallDateTime& rhs) const {
    if (hasOCallDate() || rhs.hasOCallDate()) {
        if (getOCallDate() < rhs.getOCallDate()) return true;
        if (getOCallDate() > rhs.getOCallDate()) return false;
    }
    if (hasOCallTime() || rhs.hasOCallTime()) {
        if (getOCallTime() < rhs.getOCallTime()) return true;
        if (getOCallTime() > rhs.getOCallTime()) return false;
    }
    return false;
}

inline bool T_PhonBkCallDateTime::operator > (const T_PhonBkCallDateTime& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_PhonBkCallDateTime::clear() {
    clearOCallDate();
    clearOCallTime();
}

inline void T_PhonBkCallDateTime::clearOCallDate() {
    if (hasOCallDate()) {
         clear_has_oCallDate();
        _oCallDate.clear();
     }
}

inline bool T_PhonBkCallDateTime::hasOCallDate () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const T_PhonBkCallDate& T_PhonBkCallDateTime::getOCallDate () const {
    return _oCallDate;
}

inline T_PhonBkCallDate& T_PhonBkCallDateTime::getOCallDateMutable () {
    set_has_oCallDate();
    return _oCallDate;
}

inline void T_PhonBkCallDateTime::setOCallDate (const T_PhonBkCallDate& oCallDate_) {
    set_has_oCallDate();
    this->_oCallDate = oCallDate_;
}

inline void T_PhonBkCallDateTime::clearOCallTime() {
    if (hasOCallTime()) {
         clear_has_oCallTime();
        _oCallTime.clear();
     }
}

inline bool T_PhonBkCallDateTime::hasOCallTime () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const T_PhonBkCallTime& T_PhonBkCallDateTime::getOCallTime () const {
    return _oCallTime;
}

inline T_PhonBkCallTime& T_PhonBkCallDateTime::getOCallTimeMutable () {
    set_has_oCallTime();
    return _oCallTime;
}

inline void T_PhonBkCallDateTime::setOCallTime (const T_PhonBkCallTime& oCallTime_) {
    set_has_oCallTime();
    this->_oCallTime = oCallTime_;
}

inline void T_PhonBkCallDateTime::set_has_oCallDate () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_PhonBkCallDateTime::clear_has_oCallDate () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_PhonBkCallDateTime::set_has_oCallTime () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_PhonBkCallDateTime::clear_has_oCallTime () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_PhonBkCallHistoryListSliceResultItem::T_PhonBkCallHistoryListSliceResultItem ()  :
    _u32ContactHandle (0u),
    _sFirstName (),
    _sLastName (),
    _sPhoneNumber (),
    _e8CallPhoneType (::most_PhonBk_fi_types::T_e8_PhonBkCallPhoneType__e8Preferred),
    _e8CallHistoryType (::most_PhonBk_fi_types::T_e8_PhonBkCallHistoryType__e8CCH),
    _oCallDateTime ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_PhonBkCallHistoryListSliceResultItem::T_PhonBkCallHistoryListSliceResultItem (const T_PhonBkCallHistoryListSliceResultItem &rhs)  :
    _u32ContactHandle (0u),
    _sFirstName (),
    _sLastName (),
    _sPhoneNumber (),
    _e8CallPhoneType (::most_PhonBk_fi_types::T_e8_PhonBkCallPhoneType__e8Preferred),
    _e8CallHistoryType (::most_PhonBk_fi_types::T_e8_PhonBkCallHistoryType__e8CCH),
    _oCallDateTime ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_PhonBkCallHistoryListSliceResultItem::T_PhonBkCallHistoryListSliceResultItem (uint32 u32ContactHandle_, const ::fi_basetypes_most::T_String& sFirstName_, const ::fi_basetypes_most::T_String& sLastName_, const ::fi_basetypes_most::T_String& sPhoneNumber_, T_e8_PhonBkCallPhoneType e8CallPhoneType_, T_e8_PhonBkCallHistoryType e8CallHistoryType_, const T_PhonBkCallDateTime& oCallDateTime_)  :
    _u32ContactHandle (u32ContactHandle_),
    _sFirstName (sFirstName_),
    _sLastName (sLastName_),
    _sPhoneNumber (sPhoneNumber_),
    _e8CallPhoneType (e8CallPhoneType_),
    _e8CallHistoryType (e8CallHistoryType_),
    _oCallDateTime (oCallDateTime_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sFirstName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sLastName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sPhoneNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e8_PhonBkCallPhoneType_IsValid(e8CallPhoneType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8CallPhoneType_, "T_e8_PhonBkCallPhoneType", "e8CallPhoneType", "T_PhonBkCallHistoryListSliceResultItem");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_PhonBkCallHistoryType_IsValid(e8CallHistoryType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8CallHistoryType_, "T_e8_PhonBkCallHistoryType", "e8CallHistoryType", "T_PhonBkCallHistoryListSliceResultItem");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_PhonBkCallHistoryListSliceResultItem::~T_PhonBkCallHistoryListSliceResultItem() {
}

inline T_PhonBkCallHistoryListSliceResultItem& T_PhonBkCallHistoryListSliceResultItem::operator = (const T_PhonBkCallHistoryListSliceResultItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU32ContactHandle()) {
            setU32ContactHandle(rhs.getU32ContactHandle());
        } else {
            clearU32ContactHandle();
        }
        if (rhs.hasSFirstName()) {
            setSFirstName(rhs.getSFirstName());
        } else {
            clearSFirstName();
        }
        if (rhs.hasSLastName()) {
            setSLastName(rhs.getSLastName());
        } else {
            clearSLastName();
        }
        if (rhs.hasSPhoneNumber()) {
            setSPhoneNumber(rhs.getSPhoneNumber());
        } else {
            clearSPhoneNumber();
        }
        if (rhs.hasE8CallPhoneType()) {
            setE8CallPhoneType(rhs.getE8CallPhoneType());
        } else {
            clearE8CallPhoneType();
        }
        if (rhs.hasE8CallHistoryType()) {
            setE8CallHistoryType(rhs.getE8CallHistoryType());
        } else {
            clearE8CallHistoryType();
        }
        if (rhs.hasOCallDateTime()) {
            setOCallDateTime(rhs.getOCallDateTime());
        } else {
            clearOCallDateTime();
        }
    }
    return *this;
}

inline bool T_PhonBkCallHistoryListSliceResultItem::operator == (const T_PhonBkCallHistoryListSliceResultItem& rhs) const {
    return (((!hasU32ContactHandle() && !rhs.hasU32ContactHandle()) || getU32ContactHandle() == rhs.getU32ContactHandle()) &&
        ((!hasSFirstName() && !rhs.hasSFirstName()) || getSFirstName() == rhs.getSFirstName()) &&
        ((!hasSLastName() && !rhs.hasSLastName()) || getSLastName() == rhs.getSLastName()) &&
        ((!hasSPhoneNumber() && !rhs.hasSPhoneNumber()) || getSPhoneNumber() == rhs.getSPhoneNumber()) &&
        ((!hasE8CallPhoneType() && !rhs.hasE8CallPhoneType()) || getE8CallPhoneType() == rhs.getE8CallPhoneType()) &&
        ((!hasE8CallHistoryType() && !rhs.hasE8CallHistoryType()) || getE8CallHistoryType() == rhs.getE8CallHistoryType()) &&
        ((!hasOCallDateTime() && !rhs.hasOCallDateTime()) || getOCallDateTime() == rhs.getOCallDateTime()));
}

inline bool T_PhonBkCallHistoryListSliceResultItem::operator != (const T_PhonBkCallHistoryListSliceResultItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_PhonBkCallHistoryListSliceResultItem::operator < (const T_PhonBkCallHistoryListSliceResultItem& rhs) const {
    if (hasU32ContactHandle() || rhs.hasU32ContactHandle()) {
        if (getU32ContactHandle() < rhs.getU32ContactHandle()) return true;
        if (getU32ContactHandle() > rhs.getU32ContactHandle()) return false;
    }
    if (hasSFirstName() || rhs.hasSFirstName()) {
        if (getSFirstName() < rhs.getSFirstName()) return true;
        if (getSFirstName() > rhs.getSFirstName()) return false;
    }
    if (hasSLastName() || rhs.hasSLastName()) {
        if (getSLastName() < rhs.getSLastName()) return true;
        if (getSLastName() > rhs.getSLastName()) return false;
    }
    if (hasSPhoneNumber() || rhs.hasSPhoneNumber()) {
        if (getSPhoneNumber() < rhs.getSPhoneNumber()) return true;
        if (getSPhoneNumber() > rhs.getSPhoneNumber()) return false;
    }
    if (hasE8CallPhoneType() || rhs.hasE8CallPhoneType()) {
        if ((uint32)getE8CallPhoneType() < (uint32)rhs.getE8CallPhoneType()) return true;
        if ((uint32)getE8CallPhoneType() > (uint32)rhs.getE8CallPhoneType()) return false;
    }
    if (hasE8CallHistoryType() || rhs.hasE8CallHistoryType()) {
        if ((uint32)getE8CallHistoryType() < (uint32)rhs.getE8CallHistoryType()) return true;
        if ((uint32)getE8CallHistoryType() > (uint32)rhs.getE8CallHistoryType()) return false;
    }
    if (hasOCallDateTime() || rhs.hasOCallDateTime()) {
        if (getOCallDateTime() < rhs.getOCallDateTime()) return true;
        if (getOCallDateTime() > rhs.getOCallDateTime()) return false;
    }
    return false;
}

inline bool T_PhonBkCallHistoryListSliceResultItem::operator > (const T_PhonBkCallHistoryListSliceResultItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_PhonBkCallHistoryListSliceResultItem::clear() {
    clearU32ContactHandle();
    clearSFirstName();
    clearSLastName();
    clearSPhoneNumber();
    clearE8CallPhoneType();
    clearE8CallHistoryType();
    clearOCallDateTime();
}

inline void T_PhonBkCallHistoryListSliceResultItem::clearU32ContactHandle() {
    if (hasU32ContactHandle()) {
         clear_has_u32ContactHandle();
        _u32ContactHandle = 0u;
     }
}

inline bool T_PhonBkCallHistoryListSliceResultItem::hasU32ContactHandle () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_PhonBkCallHistoryListSliceResultItem::getU32ContactHandle () const {
    return _u32ContactHandle;
}

inline void T_PhonBkCallHistoryListSliceResultItem::setU32ContactHandle (uint32 u32ContactHandle_) {
    set_has_u32ContactHandle();
    this->_u32ContactHandle = u32ContactHandle_;
}

inline void T_PhonBkCallHistoryListSliceResultItem::clearSFirstName() {
    if (hasSFirstName()) {
         clear_has_sFirstName();
        _sFirstName.clear();
     }
}

inline bool T_PhonBkCallHistoryListSliceResultItem::hasSFirstName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_PhonBkCallHistoryListSliceResultItem::getSFirstName () const {
    return _sFirstName;
}

inline ::fi_basetypes_most::T_String& T_PhonBkCallHistoryListSliceResultItem::getSFirstNameMutable () {
    set_has_sFirstName();
    return _sFirstName;
}

inline void T_PhonBkCallHistoryListSliceResultItem::setSFirstName (const ::fi_basetypes_most::T_String& sFirstName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sFirstName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sFirstName();
    this->_sFirstName = sFirstName_;
}

inline void T_PhonBkCallHistoryListSliceResultItem::clearSLastName() {
    if (hasSLastName()) {
         clear_has_sLastName();
        _sLastName.clear();
     }
}

inline bool T_PhonBkCallHistoryListSliceResultItem::hasSLastName () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_PhonBkCallHistoryListSliceResultItem::getSLastName () const {
    return _sLastName;
}

inline ::fi_basetypes_most::T_String& T_PhonBkCallHistoryListSliceResultItem::getSLastNameMutable () {
    set_has_sLastName();
    return _sLastName;
}

inline void T_PhonBkCallHistoryListSliceResultItem::setSLastName (const ::fi_basetypes_most::T_String& sLastName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sLastName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sLastName();
    this->_sLastName = sLastName_;
}

inline void T_PhonBkCallHistoryListSliceResultItem::clearSPhoneNumber() {
    if (hasSPhoneNumber()) {
         clear_has_sPhoneNumber();
        _sPhoneNumber.clear();
     }
}

inline bool T_PhonBkCallHistoryListSliceResultItem::hasSPhoneNumber () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_PhonBkCallHistoryListSliceResultItem::getSPhoneNumber () const {
    return _sPhoneNumber;
}

inline ::fi_basetypes_most::T_String& T_PhonBkCallHistoryListSliceResultItem::getSPhoneNumberMutable () {
    set_has_sPhoneNumber();
    return _sPhoneNumber;
}

inline void T_PhonBkCallHistoryListSliceResultItem::setSPhoneNumber (const ::fi_basetypes_most::T_String& sPhoneNumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sPhoneNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sPhoneNumber();
    this->_sPhoneNumber = sPhoneNumber_;
}

inline void T_PhonBkCallHistoryListSliceResultItem::clearE8CallPhoneType() {
    if (hasE8CallPhoneType()) {
         clear_has_e8CallPhoneType();
        _e8CallPhoneType = ::most_PhonBk_fi_types::T_e8_PhonBkCallPhoneType__e8Preferred;
     }
}

inline bool T_PhonBkCallHistoryListSliceResultItem::hasE8CallPhoneType () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline T_e8_PhonBkCallPhoneType T_PhonBkCallHistoryListSliceResultItem::getE8CallPhoneType () const {
    return _e8CallPhoneType;
}

inline void T_PhonBkCallHistoryListSliceResultItem::setE8CallPhoneType (T_e8_PhonBkCallPhoneType e8CallPhoneType_) {
    #ifndef NDEBUG
    if (!(T_e8_PhonBkCallPhoneType_IsValid(e8CallPhoneType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8CallPhoneType_, "T_e8_PhonBkCallPhoneType", "e8CallPhoneType", "T_PhonBkCallHistoryListSliceResultItem");
    }
    #endif
    set_has_e8CallPhoneType();
    this->_e8CallPhoneType = e8CallPhoneType_;
}

inline void T_PhonBkCallHistoryListSliceResultItem::clearE8CallHistoryType() {
    if (hasE8CallHistoryType()) {
         clear_has_e8CallHistoryType();
        _e8CallHistoryType = ::most_PhonBk_fi_types::T_e8_PhonBkCallHistoryType__e8CCH;
     }
}

inline bool T_PhonBkCallHistoryListSliceResultItem::hasE8CallHistoryType () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline T_e8_PhonBkCallHistoryType T_PhonBkCallHistoryListSliceResultItem::getE8CallHistoryType () const {
    return _e8CallHistoryType;
}

inline void T_PhonBkCallHistoryListSliceResultItem::setE8CallHistoryType (T_e8_PhonBkCallHistoryType e8CallHistoryType_) {
    #ifndef NDEBUG
    if (!(T_e8_PhonBkCallHistoryType_IsValid(e8CallHistoryType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8CallHistoryType_, "T_e8_PhonBkCallHistoryType", "e8CallHistoryType", "T_PhonBkCallHistoryListSliceResultItem");
    }
    #endif
    set_has_e8CallHistoryType();
    this->_e8CallHistoryType = e8CallHistoryType_;
}

inline void T_PhonBkCallHistoryListSliceResultItem::clearOCallDateTime() {
    if (hasOCallDateTime()) {
         clear_has_oCallDateTime();
        _oCallDateTime.clear();
     }
}

inline bool T_PhonBkCallHistoryListSliceResultItem::hasOCallDateTime () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline const T_PhonBkCallDateTime& T_PhonBkCallHistoryListSliceResultItem::getOCallDateTime () const {
    return _oCallDateTime;
}

inline T_PhonBkCallDateTime& T_PhonBkCallHistoryListSliceResultItem::getOCallDateTimeMutable () {
    set_has_oCallDateTime();
    return _oCallDateTime;
}

inline void T_PhonBkCallHistoryListSliceResultItem::setOCallDateTime (const T_PhonBkCallDateTime& oCallDateTime_) {
    set_has_oCallDateTime();
    this->_oCallDateTime = oCallDateTime_;
}

inline void T_PhonBkCallHistoryListSliceResultItem::set_has_u32ContactHandle () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_PhonBkCallHistoryListSliceResultItem::clear_has_u32ContactHandle () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_PhonBkCallHistoryListSliceResultItem::set_has_sFirstName () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_PhonBkCallHistoryListSliceResultItem::clear_has_sFirstName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_PhonBkCallHistoryListSliceResultItem::set_has_sLastName () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_PhonBkCallHistoryListSliceResultItem::clear_has_sLastName () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_PhonBkCallHistoryListSliceResultItem::set_has_sPhoneNumber () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_PhonBkCallHistoryListSliceResultItem::clear_has_sPhoneNumber () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_PhonBkCallHistoryListSliceResultItem::set_has_e8CallPhoneType () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_PhonBkCallHistoryListSliceResultItem::clear_has_e8CallPhoneType () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_PhonBkCallHistoryListSliceResultItem::set_has_e8CallHistoryType () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_PhonBkCallHistoryListSliceResultItem::clear_has_e8CallHistoryType () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_PhonBkCallHistoryListSliceResultItem::set_has_oCallDateTime () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_PhonBkCallHistoryListSliceResultItem::clear_has_oCallDateTime () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline  T_PhonBkCallHistoryTypeSupport::T_PhonBkCallHistoryTypeSupport ()  :
    _bCCHSupport (false),
    _bMCHSupport (false),
    _bICHSupport (false),
    _bOCHSupport (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_PhonBkCallHistoryTypeSupport::T_PhonBkCallHistoryTypeSupport (const T_PhonBkCallHistoryTypeSupport &rhs)  :
    _bCCHSupport (false),
    _bMCHSupport (false),
    _bICHSupport (false),
    _bOCHSupport (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_PhonBkCallHistoryTypeSupport::T_PhonBkCallHistoryTypeSupport (bool bCCHSupport_, bool bMCHSupport_, bool bICHSupport_, bool bOCHSupport_)  :
    _bCCHSupport (bCCHSupport_),
    _bMCHSupport (bMCHSupport_),
    _bICHSupport (bICHSupport_),
    _bOCHSupport (bOCHSupport_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_PhonBkCallHistoryTypeSupport::~T_PhonBkCallHistoryTypeSupport() {
}

inline T_PhonBkCallHistoryTypeSupport& T_PhonBkCallHistoryTypeSupport::operator = (const T_PhonBkCallHistoryTypeSupport& rhs) {
    if( this != &rhs ) {
        if (rhs.hasBCCHSupport()) {
            setBCCHSupport(rhs.getBCCHSupport());
        } else {
            clearBCCHSupport();
        }
        if (rhs.hasBMCHSupport()) {
            setBMCHSupport(rhs.getBMCHSupport());
        } else {
            clearBMCHSupport();
        }
        if (rhs.hasBICHSupport()) {
            setBICHSupport(rhs.getBICHSupport());
        } else {
            clearBICHSupport();
        }
        if (rhs.hasBOCHSupport()) {
            setBOCHSupport(rhs.getBOCHSupport());
        } else {
            clearBOCHSupport();
        }
    }
    return *this;
}

inline bool T_PhonBkCallHistoryTypeSupport::operator == (const T_PhonBkCallHistoryTypeSupport& rhs) const {
    return (((!hasBCCHSupport() && !rhs.hasBCCHSupport()) || getBCCHSupport() == rhs.getBCCHSupport()) &&
        ((!hasBMCHSupport() && !rhs.hasBMCHSupport()) || getBMCHSupport() == rhs.getBMCHSupport()) &&
        ((!hasBICHSupport() && !rhs.hasBICHSupport()) || getBICHSupport() == rhs.getBICHSupport()) &&
        ((!hasBOCHSupport() && !rhs.hasBOCHSupport()) || getBOCHSupport() == rhs.getBOCHSupport()));
}

inline bool T_PhonBkCallHistoryTypeSupport::operator != (const T_PhonBkCallHistoryTypeSupport& rhs) const {
    return ! (*this == rhs);
}

inline bool T_PhonBkCallHistoryTypeSupport::operator < (const T_PhonBkCallHistoryTypeSupport& rhs) const {
    if (hasBCCHSupport() || rhs.hasBCCHSupport()) {
        if (getBCCHSupport() < rhs.getBCCHSupport()) return true;
        if (getBCCHSupport() > rhs.getBCCHSupport()) return false;
    }
    if (hasBMCHSupport() || rhs.hasBMCHSupport()) {
        if (getBMCHSupport() < rhs.getBMCHSupport()) return true;
        if (getBMCHSupport() > rhs.getBMCHSupport()) return false;
    }
    if (hasBICHSupport() || rhs.hasBICHSupport()) {
        if (getBICHSupport() < rhs.getBICHSupport()) return true;
        if (getBICHSupport() > rhs.getBICHSupport()) return false;
    }
    if (hasBOCHSupport() || rhs.hasBOCHSupport()) {
        if (getBOCHSupport() < rhs.getBOCHSupport()) return true;
        if (getBOCHSupport() > rhs.getBOCHSupport()) return false;
    }
    return false;
}

inline bool T_PhonBkCallHistoryTypeSupport::operator > (const T_PhonBkCallHistoryTypeSupport& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_PhonBkCallHistoryTypeSupport::clear() {
    clearBCCHSupport();
    clearBMCHSupport();
    clearBICHSupport();
    clearBOCHSupport();
}

inline void T_PhonBkCallHistoryTypeSupport::clearBCCHSupport() {
    if (hasBCCHSupport()) {
         clear_has_bCCHSupport();
        _bCCHSupport = false;
     }
}

inline bool T_PhonBkCallHistoryTypeSupport::hasBCCHSupport () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool T_PhonBkCallHistoryTypeSupport::getBCCHSupport () const {
    return _bCCHSupport;
}

inline void T_PhonBkCallHistoryTypeSupport::setBCCHSupport (bool bCCHSupport_) {
    set_has_bCCHSupport();
    this->_bCCHSupport = bCCHSupport_;
}

inline void T_PhonBkCallHistoryTypeSupport::clearBMCHSupport() {
    if (hasBMCHSupport()) {
         clear_has_bMCHSupport();
        _bMCHSupport = false;
     }
}

inline bool T_PhonBkCallHistoryTypeSupport::hasBMCHSupport () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool T_PhonBkCallHistoryTypeSupport::getBMCHSupport () const {
    return _bMCHSupport;
}

inline void T_PhonBkCallHistoryTypeSupport::setBMCHSupport (bool bMCHSupport_) {
    set_has_bMCHSupport();
    this->_bMCHSupport = bMCHSupport_;
}

inline void T_PhonBkCallHistoryTypeSupport::clearBICHSupport() {
    if (hasBICHSupport()) {
         clear_has_bICHSupport();
        _bICHSupport = false;
     }
}

inline bool T_PhonBkCallHistoryTypeSupport::hasBICHSupport () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline bool T_PhonBkCallHistoryTypeSupport::getBICHSupport () const {
    return _bICHSupport;
}

inline void T_PhonBkCallHistoryTypeSupport::setBICHSupport (bool bICHSupport_) {
    set_has_bICHSupport();
    this->_bICHSupport = bICHSupport_;
}

inline void T_PhonBkCallHistoryTypeSupport::clearBOCHSupport() {
    if (hasBOCHSupport()) {
         clear_has_bOCHSupport();
        _bOCHSupport = false;
     }
}

inline bool T_PhonBkCallHistoryTypeSupport::hasBOCHSupport () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline bool T_PhonBkCallHistoryTypeSupport::getBOCHSupport () const {
    return _bOCHSupport;
}

inline void T_PhonBkCallHistoryTypeSupport::setBOCHSupport (bool bOCHSupport_) {
    set_has_bOCHSupport();
    this->_bOCHSupport = bOCHSupport_;
}

inline void T_PhonBkCallHistoryTypeSupport::set_has_bCCHSupport () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_PhonBkCallHistoryTypeSupport::clear_has_bCCHSupport () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_PhonBkCallHistoryTypeSupport::set_has_bMCHSupport () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_PhonBkCallHistoryTypeSupport::clear_has_bMCHSupport () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_PhonBkCallHistoryTypeSupport::set_has_bICHSupport () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_PhonBkCallHistoryTypeSupport::clear_has_bICHSupport () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_PhonBkCallHistoryTypeSupport::set_has_bOCHSupport () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_PhonBkCallHistoryTypeSupport::clear_has_bOCHSupport () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  T_PhonBkAutocompleteMultipleMatchListItem::T_PhonBkAutocompleteMultipleMatchListItem ()  :
    _sFirstName (),
    _sLastName (),
    _sPhoneNumber ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_PhonBkAutocompleteMultipleMatchListItem::T_PhonBkAutocompleteMultipleMatchListItem (const T_PhonBkAutocompleteMultipleMatchListItem &rhs)  :
    _sFirstName (),
    _sLastName (),
    _sPhoneNumber ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_PhonBkAutocompleteMultipleMatchListItem::T_PhonBkAutocompleteMultipleMatchListItem (const ::fi_basetypes_most::T_String& sFirstName_, const ::fi_basetypes_most::T_String& sLastName_, const ::fi_basetypes_most::T_String& sPhoneNumber_)  :
    _sFirstName (sFirstName_),
    _sLastName (sLastName_),
    _sPhoneNumber (sPhoneNumber_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sFirstName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sLastName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sPhoneNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_PhonBkAutocompleteMultipleMatchListItem::~T_PhonBkAutocompleteMultipleMatchListItem() {
}

inline T_PhonBkAutocompleteMultipleMatchListItem& T_PhonBkAutocompleteMultipleMatchListItem::operator = (const T_PhonBkAutocompleteMultipleMatchListItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSFirstName()) {
            setSFirstName(rhs.getSFirstName());
        } else {
            clearSFirstName();
        }
        if (rhs.hasSLastName()) {
            setSLastName(rhs.getSLastName());
        } else {
            clearSLastName();
        }
        if (rhs.hasSPhoneNumber()) {
            setSPhoneNumber(rhs.getSPhoneNumber());
        } else {
            clearSPhoneNumber();
        }
    }
    return *this;
}

inline bool T_PhonBkAutocompleteMultipleMatchListItem::operator == (const T_PhonBkAutocompleteMultipleMatchListItem& rhs) const {
    return (((!hasSFirstName() && !rhs.hasSFirstName()) || getSFirstName() == rhs.getSFirstName()) &&
        ((!hasSLastName() && !rhs.hasSLastName()) || getSLastName() == rhs.getSLastName()) &&
        ((!hasSPhoneNumber() && !rhs.hasSPhoneNumber()) || getSPhoneNumber() == rhs.getSPhoneNumber()));
}

inline bool T_PhonBkAutocompleteMultipleMatchListItem::operator != (const T_PhonBkAutocompleteMultipleMatchListItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_PhonBkAutocompleteMultipleMatchListItem::operator < (const T_PhonBkAutocompleteMultipleMatchListItem& rhs) const {
    if (hasSFirstName() || rhs.hasSFirstName()) {
        if (getSFirstName() < rhs.getSFirstName()) return true;
        if (getSFirstName() > rhs.getSFirstName()) return false;
    }
    if (hasSLastName() || rhs.hasSLastName()) {
        if (getSLastName() < rhs.getSLastName()) return true;
        if (getSLastName() > rhs.getSLastName()) return false;
    }
    if (hasSPhoneNumber() || rhs.hasSPhoneNumber()) {
        if (getSPhoneNumber() < rhs.getSPhoneNumber()) return true;
        if (getSPhoneNumber() > rhs.getSPhoneNumber()) return false;
    }
    return false;
}

inline bool T_PhonBkAutocompleteMultipleMatchListItem::operator > (const T_PhonBkAutocompleteMultipleMatchListItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_PhonBkAutocompleteMultipleMatchListItem::clear() {
    clearSFirstName();
    clearSLastName();
    clearSPhoneNumber();
}

inline void T_PhonBkAutocompleteMultipleMatchListItem::clearSFirstName() {
    if (hasSFirstName()) {
         clear_has_sFirstName();
        _sFirstName.clear();
     }
}

inline bool T_PhonBkAutocompleteMultipleMatchListItem::hasSFirstName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_PhonBkAutocompleteMultipleMatchListItem::getSFirstName () const {
    return _sFirstName;
}

inline ::fi_basetypes_most::T_String& T_PhonBkAutocompleteMultipleMatchListItem::getSFirstNameMutable () {
    set_has_sFirstName();
    return _sFirstName;
}

inline void T_PhonBkAutocompleteMultipleMatchListItem::setSFirstName (const ::fi_basetypes_most::T_String& sFirstName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sFirstName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sFirstName();
    this->_sFirstName = sFirstName_;
}

inline void T_PhonBkAutocompleteMultipleMatchListItem::clearSLastName() {
    if (hasSLastName()) {
         clear_has_sLastName();
        _sLastName.clear();
     }
}

inline bool T_PhonBkAutocompleteMultipleMatchListItem::hasSLastName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_PhonBkAutocompleteMultipleMatchListItem::getSLastName () const {
    return _sLastName;
}

inline ::fi_basetypes_most::T_String& T_PhonBkAutocompleteMultipleMatchListItem::getSLastNameMutable () {
    set_has_sLastName();
    return _sLastName;
}

inline void T_PhonBkAutocompleteMultipleMatchListItem::setSLastName (const ::fi_basetypes_most::T_String& sLastName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sLastName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sLastName();
    this->_sLastName = sLastName_;
}

inline void T_PhonBkAutocompleteMultipleMatchListItem::clearSPhoneNumber() {
    if (hasSPhoneNumber()) {
         clear_has_sPhoneNumber();
        _sPhoneNumber.clear();
     }
}

inline bool T_PhonBkAutocompleteMultipleMatchListItem::hasSPhoneNumber () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_PhonBkAutocompleteMultipleMatchListItem::getSPhoneNumber () const {
    return _sPhoneNumber;
}

inline ::fi_basetypes_most::T_String& T_PhonBkAutocompleteMultipleMatchListItem::getSPhoneNumberMutable () {
    set_has_sPhoneNumber();
    return _sPhoneNumber;
}

inline void T_PhonBkAutocompleteMultipleMatchListItem::setSPhoneNumber (const ::fi_basetypes_most::T_String& sPhoneNumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sPhoneNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sPhoneNumber();
    this->_sPhoneNumber = sPhoneNumber_;
}

inline void T_PhonBkAutocompleteMultipleMatchListItem::set_has_sFirstName () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_PhonBkAutocompleteMultipleMatchListItem::clear_has_sFirstName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_PhonBkAutocompleteMultipleMatchListItem::set_has_sLastName () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_PhonBkAutocompleteMultipleMatchListItem::clear_has_sLastName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_PhonBkAutocompleteMultipleMatchListItem::set_has_sPhoneNumber () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_PhonBkAutocompleteMultipleMatchListItem::clear_has_sPhoneNumber () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_PhonBkPhoneBookListSliceResultItem::T_PhonBkPhoneBookListSliceResultItem ()  :
    _u32ContactHandle (0u),
    _u32ContactNameTag (0u),
    _sFirstName (),
    _sLastName (),
    _sPOIName (),
    _bQuickDial (false),
    _bQuickRoute (false),
    _bQuickText (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_PhonBkPhoneBookListSliceResultItem::T_PhonBkPhoneBookListSliceResultItem (const T_PhonBkPhoneBookListSliceResultItem &rhs)  :
    _u32ContactHandle (0u),
    _u32ContactNameTag (0u),
    _sFirstName (),
    _sLastName (),
    _sPOIName (),
    _bQuickDial (false),
    _bQuickRoute (false),
    _bQuickText (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_PhonBkPhoneBookListSliceResultItem::T_PhonBkPhoneBookListSliceResultItem (uint32 u32ContactHandle_, uint32 u32ContactNameTag_, const ::fi_basetypes_most::T_String& sFirstName_, const ::fi_basetypes_most::T_String& sLastName_, const ::fi_basetypes_most::T_String& sPOIName_, bool bQuickDial_, bool bQuickRoute_, bool bQuickText_)  :
    _u32ContactHandle (u32ContactHandle_),
    _u32ContactNameTag (u32ContactNameTag_),
    _sFirstName (sFirstName_),
    _sLastName (sLastName_),
    _sPOIName (sPOIName_),
    _bQuickDial (bQuickDial_),
    _bQuickRoute (bQuickRoute_),
    _bQuickText (bQuickText_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sFirstName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sLastName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sPOIName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_PhonBkPhoneBookListSliceResultItem::~T_PhonBkPhoneBookListSliceResultItem() {
}

inline T_PhonBkPhoneBookListSliceResultItem& T_PhonBkPhoneBookListSliceResultItem::operator = (const T_PhonBkPhoneBookListSliceResultItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU32ContactHandle()) {
            setU32ContactHandle(rhs.getU32ContactHandle());
        } else {
            clearU32ContactHandle();
        }
        if (rhs.hasU32ContactNameTag()) {
            setU32ContactNameTag(rhs.getU32ContactNameTag());
        } else {
            clearU32ContactNameTag();
        }
        if (rhs.hasSFirstName()) {
            setSFirstName(rhs.getSFirstName());
        } else {
            clearSFirstName();
        }
        if (rhs.hasSLastName()) {
            setSLastName(rhs.getSLastName());
        } else {
            clearSLastName();
        }
        if (rhs.hasSPOIName()) {
            setSPOIName(rhs.getSPOIName());
        } else {
            clearSPOIName();
        }
        if (rhs.hasBQuickDial()) {
            setBQuickDial(rhs.getBQuickDial());
        } else {
            clearBQuickDial();
        }
        if (rhs.hasBQuickRoute()) {
            setBQuickRoute(rhs.getBQuickRoute());
        } else {
            clearBQuickRoute();
        }
        if (rhs.hasBQuickText()) {
            setBQuickText(rhs.getBQuickText());
        } else {
            clearBQuickText();
        }
    }
    return *this;
}

inline bool T_PhonBkPhoneBookListSliceResultItem::operator == (const T_PhonBkPhoneBookListSliceResultItem& rhs) const {
    return (((!hasU32ContactHandle() && !rhs.hasU32ContactHandle()) || getU32ContactHandle() == rhs.getU32ContactHandle()) &&
        ((!hasU32ContactNameTag() && !rhs.hasU32ContactNameTag()) || getU32ContactNameTag() == rhs.getU32ContactNameTag()) &&
        ((!hasSFirstName() && !rhs.hasSFirstName()) || getSFirstName() == rhs.getSFirstName()) &&
        ((!hasSLastName() && !rhs.hasSLastName()) || getSLastName() == rhs.getSLastName()) &&
        ((!hasSPOIName() && !rhs.hasSPOIName()) || getSPOIName() == rhs.getSPOIName()) &&
        ((!hasBQuickDial() && !rhs.hasBQuickDial()) || getBQuickDial() == rhs.getBQuickDial()) &&
        ((!hasBQuickRoute() && !rhs.hasBQuickRoute()) || getBQuickRoute() == rhs.getBQuickRoute()) &&
        ((!hasBQuickText() && !rhs.hasBQuickText()) || getBQuickText() == rhs.getBQuickText()));
}

inline bool T_PhonBkPhoneBookListSliceResultItem::operator != (const T_PhonBkPhoneBookListSliceResultItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_PhonBkPhoneBookListSliceResultItem::operator < (const T_PhonBkPhoneBookListSliceResultItem& rhs) const {
    if (hasU32ContactHandle() || rhs.hasU32ContactHandle()) {
        if (getU32ContactHandle() < rhs.getU32ContactHandle()) return true;
        if (getU32ContactHandle() > rhs.getU32ContactHandle()) return false;
    }
    if (hasU32ContactNameTag() || rhs.hasU32ContactNameTag()) {
        if (getU32ContactNameTag() < rhs.getU32ContactNameTag()) return true;
        if (getU32ContactNameTag() > rhs.getU32ContactNameTag()) return false;
    }
    if (hasSFirstName() || rhs.hasSFirstName()) {
        if (getSFirstName() < rhs.getSFirstName()) return true;
        if (getSFirstName() > rhs.getSFirstName()) return false;
    }
    if (hasSLastName() || rhs.hasSLastName()) {
        if (getSLastName() < rhs.getSLastName()) return true;
        if (getSLastName() > rhs.getSLastName()) return false;
    }
    if (hasSPOIName() || rhs.hasSPOIName()) {
        if (getSPOIName() < rhs.getSPOIName()) return true;
        if (getSPOIName() > rhs.getSPOIName()) return false;
    }
    if (hasBQuickDial() || rhs.hasBQuickDial()) {
        if (getBQuickDial() < rhs.getBQuickDial()) return true;
        if (getBQuickDial() > rhs.getBQuickDial()) return false;
    }
    if (hasBQuickRoute() || rhs.hasBQuickRoute()) {
        if (getBQuickRoute() < rhs.getBQuickRoute()) return true;
        if (getBQuickRoute() > rhs.getBQuickRoute()) return false;
    }
    if (hasBQuickText() || rhs.hasBQuickText()) {
        if (getBQuickText() < rhs.getBQuickText()) return true;
        if (getBQuickText() > rhs.getBQuickText()) return false;
    }
    return false;
}

inline bool T_PhonBkPhoneBookListSliceResultItem::operator > (const T_PhonBkPhoneBookListSliceResultItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_PhonBkPhoneBookListSliceResultItem::clear() {
    clearU32ContactHandle();
    clearU32ContactNameTag();
    clearSFirstName();
    clearSLastName();
    clearSPOIName();
    clearBQuickDial();
    clearBQuickRoute();
    clearBQuickText();
}

inline void T_PhonBkPhoneBookListSliceResultItem::clearU32ContactHandle() {
    if (hasU32ContactHandle()) {
         clear_has_u32ContactHandle();
        _u32ContactHandle = 0u;
     }
}

inline bool T_PhonBkPhoneBookListSliceResultItem::hasU32ContactHandle () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_PhonBkPhoneBookListSliceResultItem::getU32ContactHandle () const {
    return _u32ContactHandle;
}

inline void T_PhonBkPhoneBookListSliceResultItem::setU32ContactHandle (uint32 u32ContactHandle_) {
    set_has_u32ContactHandle();
    this->_u32ContactHandle = u32ContactHandle_;
}

inline void T_PhonBkPhoneBookListSliceResultItem::clearU32ContactNameTag() {
    if (hasU32ContactNameTag()) {
         clear_has_u32ContactNameTag();
        _u32ContactNameTag = 0u;
     }
}

inline bool T_PhonBkPhoneBookListSliceResultItem::hasU32ContactNameTag () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 T_PhonBkPhoneBookListSliceResultItem::getU32ContactNameTag () const {
    return _u32ContactNameTag;
}

inline void T_PhonBkPhoneBookListSliceResultItem::setU32ContactNameTag (uint32 u32ContactNameTag_) {
    set_has_u32ContactNameTag();
    this->_u32ContactNameTag = u32ContactNameTag_;
}

inline void T_PhonBkPhoneBookListSliceResultItem::clearSFirstName() {
    if (hasSFirstName()) {
         clear_has_sFirstName();
        _sFirstName.clear();
     }
}

inline bool T_PhonBkPhoneBookListSliceResultItem::hasSFirstName () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_PhonBkPhoneBookListSliceResultItem::getSFirstName () const {
    return _sFirstName;
}

inline ::fi_basetypes_most::T_String& T_PhonBkPhoneBookListSliceResultItem::getSFirstNameMutable () {
    set_has_sFirstName();
    return _sFirstName;
}

inline void T_PhonBkPhoneBookListSliceResultItem::setSFirstName (const ::fi_basetypes_most::T_String& sFirstName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sFirstName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sFirstName();
    this->_sFirstName = sFirstName_;
}

inline void T_PhonBkPhoneBookListSliceResultItem::clearSLastName() {
    if (hasSLastName()) {
         clear_has_sLastName();
        _sLastName.clear();
     }
}

inline bool T_PhonBkPhoneBookListSliceResultItem::hasSLastName () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_PhonBkPhoneBookListSliceResultItem::getSLastName () const {
    return _sLastName;
}

inline ::fi_basetypes_most::T_String& T_PhonBkPhoneBookListSliceResultItem::getSLastNameMutable () {
    set_has_sLastName();
    return _sLastName;
}

inline void T_PhonBkPhoneBookListSliceResultItem::setSLastName (const ::fi_basetypes_most::T_String& sLastName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sLastName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sLastName();
    this->_sLastName = sLastName_;
}

inline void T_PhonBkPhoneBookListSliceResultItem::clearSPOIName() {
    if (hasSPOIName()) {
         clear_has_sPOIName();
        _sPOIName.clear();
     }
}

inline bool T_PhonBkPhoneBookListSliceResultItem::hasSPOIName () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_PhonBkPhoneBookListSliceResultItem::getSPOIName () const {
    return _sPOIName;
}

inline ::fi_basetypes_most::T_String& T_PhonBkPhoneBookListSliceResultItem::getSPOINameMutable () {
    set_has_sPOIName();
    return _sPOIName;
}

inline void T_PhonBkPhoneBookListSliceResultItem::setSPOIName (const ::fi_basetypes_most::T_String& sPOIName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sPOIName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sPOIName();
    this->_sPOIName = sPOIName_;
}

inline void T_PhonBkPhoneBookListSliceResultItem::clearBQuickDial() {
    if (hasBQuickDial()) {
         clear_has_bQuickDial();
        _bQuickDial = false;
     }
}

inline bool T_PhonBkPhoneBookListSliceResultItem::hasBQuickDial () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline bool T_PhonBkPhoneBookListSliceResultItem::getBQuickDial () const {
    return _bQuickDial;
}

inline void T_PhonBkPhoneBookListSliceResultItem::setBQuickDial (bool bQuickDial_) {
    set_has_bQuickDial();
    this->_bQuickDial = bQuickDial_;
}

inline void T_PhonBkPhoneBookListSliceResultItem::clearBQuickRoute() {
    if (hasBQuickRoute()) {
         clear_has_bQuickRoute();
        _bQuickRoute = false;
     }
}

inline bool T_PhonBkPhoneBookListSliceResultItem::hasBQuickRoute () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline bool T_PhonBkPhoneBookListSliceResultItem::getBQuickRoute () const {
    return _bQuickRoute;
}

inline void T_PhonBkPhoneBookListSliceResultItem::setBQuickRoute (bool bQuickRoute_) {
    set_has_bQuickRoute();
    this->_bQuickRoute = bQuickRoute_;
}

inline void T_PhonBkPhoneBookListSliceResultItem::clearBQuickText() {
    if (hasBQuickText()) {
         clear_has_bQuickText();
        _bQuickText = false;
     }
}

inline bool T_PhonBkPhoneBookListSliceResultItem::hasBQuickText () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline bool T_PhonBkPhoneBookListSliceResultItem::getBQuickText () const {
    return _bQuickText;
}

inline void T_PhonBkPhoneBookListSliceResultItem::setBQuickText (bool bQuickText_) {
    set_has_bQuickText();
    this->_bQuickText = bQuickText_;
}

inline void T_PhonBkPhoneBookListSliceResultItem::set_has_u32ContactHandle () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_PhonBkPhoneBookListSliceResultItem::clear_has_u32ContactHandle () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_PhonBkPhoneBookListSliceResultItem::set_has_u32ContactNameTag () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_PhonBkPhoneBookListSliceResultItem::clear_has_u32ContactNameTag () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_PhonBkPhoneBookListSliceResultItem::set_has_sFirstName () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_PhonBkPhoneBookListSliceResultItem::clear_has_sFirstName () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_PhonBkPhoneBookListSliceResultItem::set_has_sLastName () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_PhonBkPhoneBookListSliceResultItem::clear_has_sLastName () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_PhonBkPhoneBookListSliceResultItem::set_has_sPOIName () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_PhonBkPhoneBookListSliceResultItem::clear_has_sPOIName () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_PhonBkPhoneBookListSliceResultItem::set_has_bQuickDial () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_PhonBkPhoneBookListSliceResultItem::clear_has_bQuickDial () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_PhonBkPhoneBookListSliceResultItem::set_has_bQuickRoute () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_PhonBkPhoneBookListSliceResultItem::clear_has_bQuickRoute () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_PhonBkPhoneBookListSliceResultItem::set_has_bQuickText () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_PhonBkPhoneBookListSliceResultItem::clear_has_bQuickText () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline  T_PhonBkDownloadStateStreamItem::T_PhonBkDownloadStateStreamItem ()  :
    _u8DeviceHandle (0u),
    _e8RecentCallListDownloadState (::most_PhonBk_fi_types::T_e8_PhonBkRecentCallListDownloadState__e8RCDS_NOT_STARTED),
    _e8PhoneBookDownloadState (::most_PhonBk_fi_types::T_e8_PhonBkPhoneBookDownloadState__e8PBDS_NOT_STARTED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_PhonBkDownloadStateStreamItem::T_PhonBkDownloadStateStreamItem (const T_PhonBkDownloadStateStreamItem &rhs)  :
    _u8DeviceHandle (0u),
    _e8RecentCallListDownloadState (::most_PhonBk_fi_types::T_e8_PhonBkRecentCallListDownloadState__e8RCDS_NOT_STARTED),
    _e8PhoneBookDownloadState (::most_PhonBk_fi_types::T_e8_PhonBkPhoneBookDownloadState__e8PBDS_NOT_STARTED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_PhonBkDownloadStateStreamItem::T_PhonBkDownloadStateStreamItem (uint8 u8DeviceHandle_, T_e8_PhonBkRecentCallListDownloadState e8RecentCallListDownloadState_, T_e8_PhonBkPhoneBookDownloadState e8PhoneBookDownloadState_)  :
    _u8DeviceHandle (u8DeviceHandle_),
    _e8RecentCallListDownloadState (e8RecentCallListDownloadState_),
    _e8PhoneBookDownloadState (e8PhoneBookDownloadState_)
{
    #ifndef NDEBUG
    if (!(T_e8_PhonBkRecentCallListDownloadState_IsValid(e8RecentCallListDownloadState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8RecentCallListDownloadState_, "T_e8_PhonBkRecentCallListDownloadState", "e8RecentCallListDownloadState", "T_PhonBkDownloadStateStreamItem");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_PhonBkPhoneBookDownloadState_IsValid(e8PhoneBookDownloadState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8PhoneBookDownloadState_, "T_e8_PhonBkPhoneBookDownloadState", "e8PhoneBookDownloadState", "T_PhonBkDownloadStateStreamItem");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_PhonBkDownloadStateStreamItem::~T_PhonBkDownloadStateStreamItem() {
}

inline T_PhonBkDownloadStateStreamItem& T_PhonBkDownloadStateStreamItem::operator = (const T_PhonBkDownloadStateStreamItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8DeviceHandle()) {
            setU8DeviceHandle(rhs.getU8DeviceHandle());
        } else {
            clearU8DeviceHandle();
        }
        if (rhs.hasE8RecentCallListDownloadState()) {
            setE8RecentCallListDownloadState(rhs.getE8RecentCallListDownloadState());
        } else {
            clearE8RecentCallListDownloadState();
        }
        if (rhs.hasE8PhoneBookDownloadState()) {
            setE8PhoneBookDownloadState(rhs.getE8PhoneBookDownloadState());
        } else {
            clearE8PhoneBookDownloadState();
        }
    }
    return *this;
}

inline bool T_PhonBkDownloadStateStreamItem::operator == (const T_PhonBkDownloadStateStreamItem& rhs) const {
    return (((!hasU8DeviceHandle() && !rhs.hasU8DeviceHandle()) || getU8DeviceHandle() == rhs.getU8DeviceHandle()) &&
        ((!hasE8RecentCallListDownloadState() && !rhs.hasE8RecentCallListDownloadState()) || getE8RecentCallListDownloadState() == rhs.getE8RecentCallListDownloadState()) &&
        ((!hasE8PhoneBookDownloadState() && !rhs.hasE8PhoneBookDownloadState()) || getE8PhoneBookDownloadState() == rhs.getE8PhoneBookDownloadState()));
}

inline bool T_PhonBkDownloadStateStreamItem::operator != (const T_PhonBkDownloadStateStreamItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_PhonBkDownloadStateStreamItem::operator < (const T_PhonBkDownloadStateStreamItem& rhs) const {
    if (hasU8DeviceHandle() || rhs.hasU8DeviceHandle()) {
        if (getU8DeviceHandle() < rhs.getU8DeviceHandle()) return true;
        if (getU8DeviceHandle() > rhs.getU8DeviceHandle()) return false;
    }
    if (hasE8RecentCallListDownloadState() || rhs.hasE8RecentCallListDownloadState()) {
        if ((uint32)getE8RecentCallListDownloadState() < (uint32)rhs.getE8RecentCallListDownloadState()) return true;
        if ((uint32)getE8RecentCallListDownloadState() > (uint32)rhs.getE8RecentCallListDownloadState()) return false;
    }
    if (hasE8PhoneBookDownloadState() || rhs.hasE8PhoneBookDownloadState()) {
        if ((uint32)getE8PhoneBookDownloadState() < (uint32)rhs.getE8PhoneBookDownloadState()) return true;
        if ((uint32)getE8PhoneBookDownloadState() > (uint32)rhs.getE8PhoneBookDownloadState()) return false;
    }
    return false;
}

inline bool T_PhonBkDownloadStateStreamItem::operator > (const T_PhonBkDownloadStateStreamItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_PhonBkDownloadStateStreamItem::clear() {
    clearU8DeviceHandle();
    clearE8RecentCallListDownloadState();
    clearE8PhoneBookDownloadState();
}

inline void T_PhonBkDownloadStateStreamItem::clearU8DeviceHandle() {
    if (hasU8DeviceHandle()) {
         clear_has_u8DeviceHandle();
        _u8DeviceHandle = 0u;
     }
}

inline bool T_PhonBkDownloadStateStreamItem::hasU8DeviceHandle () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_PhonBkDownloadStateStreamItem::getU8DeviceHandle () const {
    return _u8DeviceHandle;
}

inline void T_PhonBkDownloadStateStreamItem::setU8DeviceHandle (uint8 u8DeviceHandle_) {
    set_has_u8DeviceHandle();
    this->_u8DeviceHandle = u8DeviceHandle_;
}

inline void T_PhonBkDownloadStateStreamItem::clearE8RecentCallListDownloadState() {
    if (hasE8RecentCallListDownloadState()) {
         clear_has_e8RecentCallListDownloadState();
        _e8RecentCallListDownloadState = ::most_PhonBk_fi_types::T_e8_PhonBkRecentCallListDownloadState__e8RCDS_NOT_STARTED;
     }
}

inline bool T_PhonBkDownloadStateStreamItem::hasE8RecentCallListDownloadState () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_PhonBkRecentCallListDownloadState T_PhonBkDownloadStateStreamItem::getE8RecentCallListDownloadState () const {
    return _e8RecentCallListDownloadState;
}

inline void T_PhonBkDownloadStateStreamItem::setE8RecentCallListDownloadState (T_e8_PhonBkRecentCallListDownloadState e8RecentCallListDownloadState_) {
    #ifndef NDEBUG
    if (!(T_e8_PhonBkRecentCallListDownloadState_IsValid(e8RecentCallListDownloadState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8RecentCallListDownloadState_, "T_e8_PhonBkRecentCallListDownloadState", "e8RecentCallListDownloadState", "T_PhonBkDownloadStateStreamItem");
    }
    #endif
    set_has_e8RecentCallListDownloadState();
    this->_e8RecentCallListDownloadState = e8RecentCallListDownloadState_;
}

inline void T_PhonBkDownloadStateStreamItem::clearE8PhoneBookDownloadState() {
    if (hasE8PhoneBookDownloadState()) {
         clear_has_e8PhoneBookDownloadState();
        _e8PhoneBookDownloadState = ::most_PhonBk_fi_types::T_e8_PhonBkPhoneBookDownloadState__e8PBDS_NOT_STARTED;
     }
}

inline bool T_PhonBkDownloadStateStreamItem::hasE8PhoneBookDownloadState () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_PhonBkPhoneBookDownloadState T_PhonBkDownloadStateStreamItem::getE8PhoneBookDownloadState () const {
    return _e8PhoneBookDownloadState;
}

inline void T_PhonBkDownloadStateStreamItem::setE8PhoneBookDownloadState (T_e8_PhonBkPhoneBookDownloadState e8PhoneBookDownloadState_) {
    #ifndef NDEBUG
    if (!(T_e8_PhonBkPhoneBookDownloadState_IsValid(e8PhoneBookDownloadState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8PhoneBookDownloadState_, "T_e8_PhonBkPhoneBookDownloadState", "e8PhoneBookDownloadState", "T_PhonBkDownloadStateStreamItem");
    }
    #endif
    set_has_e8PhoneBookDownloadState();
    this->_e8PhoneBookDownloadState = e8PhoneBookDownloadState_;
}

inline void T_PhonBkDownloadStateStreamItem::set_has_u8DeviceHandle () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_PhonBkDownloadStateStreamItem::clear_has_u8DeviceHandle () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_PhonBkDownloadStateStreamItem::set_has_e8RecentCallListDownloadState () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_PhonBkDownloadStateStreamItem::clear_has_e8RecentCallListDownloadState () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_PhonBkDownloadStateStreamItem::set_has_e8PhoneBookDownloadState () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_PhonBkDownloadStateStreamItem::clear_has_e8PhoneBookDownloadState () {
    _has_bits_[0] &= ~ (1u << 2);
}

} // namespace most_PhonBk_fi_types

#endif // MOST_PHONBK_FI_TYPES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
