#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef MOST_FAVPRV_FI_TYPES_H
#define MOST_FAVPRV_FI_TYPES_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "fi_basetypes_most.h"
#include "most_FavPrv_fi_typesConst.h"
#include <cstring>
#include <vector>

/**
 * Types most_FavPrv_fi_types
 */

namespace most_FavPrv_fi_types {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class T_FavPrvFavoriteInfoItem;

// type definitions
/**
 * If the meaning of "T_FavPrvFavoriteInfo" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_FavPrvFavoriteInfoItem > T_FavPrvFavoriteInfo;

/**
 * If the meaning of "T_FavPrvChangedFavorites" isn't clear, then there should be a description here.
 */
typedef ::std::vector< uint16 > T_FavPrvChangedFavorites;


/**
 * Active, Available, FavoriteID, LabelText, DescriptorText, FavoriteType, HasIcon {, Active, Available, FavoriteID, LabelText, DescriptorText, FavoriteType, HasIcon}
 */
class T_FavPrvFavoriteInfoItem {
public:

    /**
     * Default constructor
     */
    inline  T_FavPrvFavoriteInfoItem ();

    /**
     * Copy constructor
     */
    inline  T_FavPrvFavoriteInfoItem (const T_FavPrvFavoriteInfoItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_FavPrvFavoriteInfoItem (bool bActive_, bool bAvailable_, uint16 u16FavoriteID_, const ::fi_basetypes_most::T_String& sLabelText_, const ::fi_basetypes_most::T_String& sDescriptorText_, T_e8_FavPrvFavoriteType e8FavoriteType_);

    /**
     * Destructor
     */
    inline  ~T_FavPrvFavoriteInfoItem();

    /**
     * Assignment operator
     */
    inline T_FavPrvFavoriteInfoItem& operator = (const T_FavPrvFavoriteInfoItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_FavPrvFavoriteInfoItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_FavPrvFavoriteInfoItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_FavPrvFavoriteInfoItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_FavPrvFavoriteInfoItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bActive"

    static const int kBActive = 0;

    /**
     * Clears the field "bActive".
     *
     * The field will be set to its default value. The hasBActive()
     * method will return false.
     */
    inline void clearBActive();

    /**
     * Checks whether the field "bActive" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBActive()). Otherwise it will return false.
     */
    inline bool hasBActive () const;

    /**
     * Returns the value of the member "bActive".
     *
     * <p>
     * The Active parameter indicates whether or not the favorite is active.  For example, if a favorite song is playing then this parameter is True.
     * </p>
     *
     * @return The value of the field "bActive"
     */
    inline bool getBActive () const;

    /**
     * Sets the value of the member "bActive".
     *
     * <p>
     * The Active parameter indicates whether or not the favorite is active.  For example, if a favorite song is playing then this parameter is True.
     * </p>
     *
     * @param bActive The value which will be set
     */
    inline void setBActive (bool bActive_);

    // API of field "bAvailable"

    static const int kBAvailable = 1;

    /**
     * Clears the field "bAvailable".
     *
     * The field will be set to its default value. The hasBAvailable()
     * method will return false.
     */
    inline void clearBAvailable();

    /**
     * Checks whether the field "bAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBAvailable()). Otherwise it will return false.
     */
    inline bool hasBAvailable () const;

    /**
     * Returns the value of the member "bAvailable".
     *
     * <p>
     * The Available parameter indicates whether or not the favorite is available.  Example of when a favorite is not available:  The favorite is a song and the media device containing the song is not connected.
     * </p>
     *
     * @return The value of the field "bAvailable"
     */
    inline bool getBAvailable () const;

    /**
     * Sets the value of the member "bAvailable".
     *
     * <p>
     * The Available parameter indicates whether or not the favorite is available.  Example of when a favorite is not available:  The favorite is a song and the media device containing the song is not connected.
     * </p>
     *
     * @param bAvailable The value which will be set
     */
    inline void setBAvailable (bool bAvailable_);

    // API of field "u16FavoriteID"

    static const int kU16FavoriteID = 2;

    /**
     * Clears the field "u16FavoriteID".
     *
     * The field will be set to its default value. The hasU16FavoriteID()
     * method will return false.
     */
    inline void clearU16FavoriteID();

    /**
     * Checks whether the field "u16FavoriteID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16FavoriteID()). Otherwise it will return false.
     */
    inline bool hasU16FavoriteID () const;

    /**
     * Returns the value of the member "u16FavoriteID".
     *
     * <p>
     * The FavoriteID uniquely identifies a stored favorite. The value of
     * 0x0000 is reserved for a special case. A FavoriteID = 0x0000 refers to
     * all favorites stored.
     * </p>
     *
     * @return The value of the field "u16FavoriteID"
     */
    inline uint16 getU16FavoriteID () const;

    /**
     * Sets the value of the member "u16FavoriteID".
     *
     * <p>
     * The FavoriteID uniquely identifies a stored favorite. The value of
     * 0x0000 is reserved for a special case. A FavoriteID = 0x0000 refers to
     * all favorites stored.
     * </p>
     *
     * @param u16FavoriteID The value which will be set
     */
    inline void setU16FavoriteID (uint16 u16FavoriteID_);

    // API of field "sLabelText"

    static const int kSLabelText = 3;

    /**
     * Clears the field "sLabelText".
     *
     * The field will be set to its default value. The hasSLabelText()
     * method will return false.
     */
    inline void clearSLabelText();

    /**
     * Checks whether the field "sLabelText" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSLabelText()). Otherwise it will return false.
     */
    inline bool hasSLabelText () const;

    /**
     * Returns the value of the member "sLabelText".
     *
     * <p>
     * The LabelText parameter is the text string that is displayed on a label
     * for the favorite. The content of LabelText will depend upon the type of
     * favorite.
     * </p>
     *
     * @return The value of the field "sLabelText"
     */
    inline const ::fi_basetypes_most::T_String& getSLabelText () const;

    /**
     * Retrieves the value of the field "sLabelText" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sLabelText".
     */
    inline ::fi_basetypes_most::T_String& getSLabelTextMutable ();

    /**
     * Sets the value of the member "sLabelText".
     *
     * <p>
     * The LabelText parameter is the text string that is displayed on a label
     * for the favorite. The content of LabelText will depend upon the type of
     * favorite.
     * </p>
     *
     * @param sLabelText The value which will be set
     */
    inline void setSLabelText (const ::fi_basetypes_most::T_String& sLabelText_);

    // API of field "sDescriptorText"

    static const int kSDescriptorText = 4;

    /**
     * Clears the field "sDescriptorText".
     *
     * The field will be set to its default value. The hasSDescriptorText()
     * method will return false.
     */
    inline void clearSDescriptorText();

    /**
     * Checks whether the field "sDescriptorText" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDescriptorText()). Otherwise it will return false.
     */
    inline bool hasSDescriptorText () const;

    /**
     * Returns the value of the member "sDescriptorText".
     *
     * <p>
     * The DescriptorText parameter is a text string describing the favorite.
     * The content of ActionText will depend upon the type of favorite.
     * </p>
     *
     * @return The value of the field "sDescriptorText"
     */
    inline const ::fi_basetypes_most::T_String& getSDescriptorText () const;

    /**
     * Retrieves the value of the field "sDescriptorText" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDescriptorText".
     */
    inline ::fi_basetypes_most::T_String& getSDescriptorTextMutable ();

    /**
     * Sets the value of the member "sDescriptorText".
     *
     * <p>
     * The DescriptorText parameter is a text string describing the favorite.
     * The content of ActionText will depend upon the type of favorite.
     * </p>
     *
     * @param sDescriptorText The value which will be set
     */
    inline void setSDescriptorText (const ::fi_basetypes_most::T_String& sDescriptorText_);

    // API of field "e8FavoriteType"

    static const int kE8FavoriteType = 5;

    /**
     * Clears the field "e8FavoriteType".
     *
     * The field will be set to its default value. The hasE8FavoriteType()
     * method will return false.
     */
    inline void clearE8FavoriteType();

    /**
     * Checks whether the field "e8FavoriteType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8FavoriteType()). Otherwise it will return false.
     */
    inline bool hasE8FavoriteType () const;

    /**
     * Returns the value of the member "e8FavoriteType".
     *
     * The FavoriteType parameter indicates what type the favorite is. For e.g. it may indicate that the favorite is a phone number.
     *
     * Note: The enumerations defined for this parameter must be the same as the enumerations defined for the parameter with the same name in the IFavoritesManager interface FBlock.
     *
     * @return The value of the field "e8FavoriteType"
     */
    inline T_e8_FavPrvFavoriteType getE8FavoriteType () const;

    /**
     * Sets the value of the member "e8FavoriteType".
     *
     * The FavoriteType parameter indicates what type the favorite is. For e.g. it may indicate that the favorite is a phone number.
     *
     * Note: The enumerations defined for this parameter must be the same as the enumerations defined for the parameter with the same name in the IFavoritesManager interface FBlock.
     *
     * @param e8FavoriteType The value which will be set
     */
    inline void setE8FavoriteType (T_e8_FavPrvFavoriteType e8FavoriteType_);

    static const T_FavPrvFavoriteInfoItem &getDefaultInstance();

private:

    inline void set_has_bActive ();

    inline void clear_has_bActive ();

    inline void set_has_bAvailable ();

    inline void clear_has_bAvailable ();

    inline void set_has_u16FavoriteID ();

    inline void clear_has_u16FavoriteID ();

    inline void set_has_sLabelText ();

    inline void clear_has_sLabelText ();

    inline void set_has_sDescriptorText ();

    inline void clear_has_sDescriptorText ();

    inline void set_has_e8FavoriteType ();

    inline void clear_has_e8FavoriteType ();

    uint32 _has_bits_[ (6 + 31) / 32];

    bool _bActive;

    bool _bAvailable;

    uint16 _u16FavoriteID;

    ::fi_basetypes_most::T_String _sLabelText;

    ::fi_basetypes_most::T_String _sDescriptorText;

    T_e8_FavPrvFavoriteType _e8FavoriteType;

};

inline  T_FavPrvFavoriteInfoItem::T_FavPrvFavoriteInfoItem ()  :
    _bActive (false),
    _bAvailable (false),
    _u16FavoriteID (0u),
    _sLabelText (),
    _sDescriptorText (),
    _e8FavoriteType (::most_FavPrv_fi_types::T_e8_FavPrvFavoriteType__e8FT_ALL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_FavPrvFavoriteInfoItem::T_FavPrvFavoriteInfoItem (const T_FavPrvFavoriteInfoItem &rhs)  :
    _bActive (false),
    _bAvailable (false),
    _u16FavoriteID (0u),
    _sLabelText (),
    _sDescriptorText (),
    _e8FavoriteType (::most_FavPrv_fi_types::T_e8_FavPrvFavoriteType__e8FT_ALL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_FavPrvFavoriteInfoItem::T_FavPrvFavoriteInfoItem (bool bActive_, bool bAvailable_, uint16 u16FavoriteID_, const ::fi_basetypes_most::T_String& sLabelText_, const ::fi_basetypes_most::T_String& sDescriptorText_, T_e8_FavPrvFavoriteType e8FavoriteType_)  :
    _bActive (bActive_),
    _bAvailable (bAvailable_),
    _u16FavoriteID (u16FavoriteID_),
    _sLabelText (sLabelText_),
    _sDescriptorText (sDescriptorText_),
    _e8FavoriteType (e8FavoriteType_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sLabelText_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDescriptorText_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e8_FavPrvFavoriteType_IsValid(e8FavoriteType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8FavoriteType_, "T_e8_FavPrvFavoriteType", "e8FavoriteType", "T_FavPrvFavoriteInfoItem");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_FavPrvFavoriteInfoItem::~T_FavPrvFavoriteInfoItem() {
}

inline T_FavPrvFavoriteInfoItem& T_FavPrvFavoriteInfoItem::operator = (const T_FavPrvFavoriteInfoItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasBActive()) {
            setBActive(rhs.getBActive());
        } else {
            clearBActive();
        }
        if (rhs.hasBAvailable()) {
            setBAvailable(rhs.getBAvailable());
        } else {
            clearBAvailable();
        }
        if (rhs.hasU16FavoriteID()) {
            setU16FavoriteID(rhs.getU16FavoriteID());
        } else {
            clearU16FavoriteID();
        }
        if (rhs.hasSLabelText()) {
            setSLabelText(rhs.getSLabelText());
        } else {
            clearSLabelText();
        }
        if (rhs.hasSDescriptorText()) {
            setSDescriptorText(rhs.getSDescriptorText());
        } else {
            clearSDescriptorText();
        }
        if (rhs.hasE8FavoriteType()) {
            setE8FavoriteType(rhs.getE8FavoriteType());
        } else {
            clearE8FavoriteType();
        }
    }
    return *this;
}

inline bool T_FavPrvFavoriteInfoItem::operator == (const T_FavPrvFavoriteInfoItem& rhs) const {
    return (((!hasBActive() && !rhs.hasBActive()) || getBActive() == rhs.getBActive()) &&
        ((!hasBAvailable() && !rhs.hasBAvailable()) || getBAvailable() == rhs.getBAvailable()) &&
        ((!hasU16FavoriteID() && !rhs.hasU16FavoriteID()) || getU16FavoriteID() == rhs.getU16FavoriteID()) &&
        ((!hasSLabelText() && !rhs.hasSLabelText()) || getSLabelText() == rhs.getSLabelText()) &&
        ((!hasSDescriptorText() && !rhs.hasSDescriptorText()) || getSDescriptorText() == rhs.getSDescriptorText()) &&
        ((!hasE8FavoriteType() && !rhs.hasE8FavoriteType()) || getE8FavoriteType() == rhs.getE8FavoriteType()));
}

inline bool T_FavPrvFavoriteInfoItem::operator != (const T_FavPrvFavoriteInfoItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_FavPrvFavoriteInfoItem::operator < (const T_FavPrvFavoriteInfoItem& rhs) const {
    if (hasBActive() || rhs.hasBActive()) {
        if (getBActive() < rhs.getBActive()) return true;
        if (getBActive() > rhs.getBActive()) return false;
    }
    if (hasBAvailable() || rhs.hasBAvailable()) {
        if (getBAvailable() < rhs.getBAvailable()) return true;
        if (getBAvailable() > rhs.getBAvailable()) return false;
    }
    if (hasU16FavoriteID() || rhs.hasU16FavoriteID()) {
        if (getU16FavoriteID() < rhs.getU16FavoriteID()) return true;
        if (getU16FavoriteID() > rhs.getU16FavoriteID()) return false;
    }
    if (hasSLabelText() || rhs.hasSLabelText()) {
        if (getSLabelText() < rhs.getSLabelText()) return true;
        if (getSLabelText() > rhs.getSLabelText()) return false;
    }
    if (hasSDescriptorText() || rhs.hasSDescriptorText()) {
        if (getSDescriptorText() < rhs.getSDescriptorText()) return true;
        if (getSDescriptorText() > rhs.getSDescriptorText()) return false;
    }
    if (hasE8FavoriteType() || rhs.hasE8FavoriteType()) {
        if ((uint32)getE8FavoriteType() < (uint32)rhs.getE8FavoriteType()) return true;
        if ((uint32)getE8FavoriteType() > (uint32)rhs.getE8FavoriteType()) return false;
    }
    return false;
}

inline bool T_FavPrvFavoriteInfoItem::operator > (const T_FavPrvFavoriteInfoItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_FavPrvFavoriteInfoItem::clear() {
    clearBActive();
    clearBAvailable();
    clearU16FavoriteID();
    clearSLabelText();
    clearSDescriptorText();
    clearE8FavoriteType();
}

inline void T_FavPrvFavoriteInfoItem::clearBActive() {
    if (hasBActive()) {
         clear_has_bActive();
        _bActive = false;
     }
}

inline bool T_FavPrvFavoriteInfoItem::hasBActive () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool T_FavPrvFavoriteInfoItem::getBActive () const {
    return _bActive;
}

inline void T_FavPrvFavoriteInfoItem::setBActive (bool bActive_) {
    set_has_bActive();
    this->_bActive = bActive_;
}

inline void T_FavPrvFavoriteInfoItem::clearBAvailable() {
    if (hasBAvailable()) {
         clear_has_bAvailable();
        _bAvailable = false;
     }
}

inline bool T_FavPrvFavoriteInfoItem::hasBAvailable () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool T_FavPrvFavoriteInfoItem::getBAvailable () const {
    return _bAvailable;
}

inline void T_FavPrvFavoriteInfoItem::setBAvailable (bool bAvailable_) {
    set_has_bAvailable();
    this->_bAvailable = bAvailable_;
}

inline void T_FavPrvFavoriteInfoItem::clearU16FavoriteID() {
    if (hasU16FavoriteID()) {
         clear_has_u16FavoriteID();
        _u16FavoriteID = 0u;
     }
}

inline bool T_FavPrvFavoriteInfoItem::hasU16FavoriteID () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 T_FavPrvFavoriteInfoItem::getU16FavoriteID () const {
    return _u16FavoriteID;
}

inline void T_FavPrvFavoriteInfoItem::setU16FavoriteID (uint16 u16FavoriteID_) {
    set_has_u16FavoriteID();
    this->_u16FavoriteID = u16FavoriteID_;
}

inline void T_FavPrvFavoriteInfoItem::clearSLabelText() {
    if (hasSLabelText()) {
         clear_has_sLabelText();
        _sLabelText.clear();
     }
}

inline bool T_FavPrvFavoriteInfoItem::hasSLabelText () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_FavPrvFavoriteInfoItem::getSLabelText () const {
    return _sLabelText;
}

inline ::fi_basetypes_most::T_String& T_FavPrvFavoriteInfoItem::getSLabelTextMutable () {
    set_has_sLabelText();
    return _sLabelText;
}

inline void T_FavPrvFavoriteInfoItem::setSLabelText (const ::fi_basetypes_most::T_String& sLabelText_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sLabelText_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sLabelText();
    this->_sLabelText = sLabelText_;
}

inline void T_FavPrvFavoriteInfoItem::clearSDescriptorText() {
    if (hasSDescriptorText()) {
         clear_has_sDescriptorText();
        _sDescriptorText.clear();
     }
}

inline bool T_FavPrvFavoriteInfoItem::hasSDescriptorText () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_FavPrvFavoriteInfoItem::getSDescriptorText () const {
    return _sDescriptorText;
}

inline ::fi_basetypes_most::T_String& T_FavPrvFavoriteInfoItem::getSDescriptorTextMutable () {
    set_has_sDescriptorText();
    return _sDescriptorText;
}

inline void T_FavPrvFavoriteInfoItem::setSDescriptorText (const ::fi_basetypes_most::T_String& sDescriptorText_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDescriptorText_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDescriptorText();
    this->_sDescriptorText = sDescriptorText_;
}

inline void T_FavPrvFavoriteInfoItem::clearE8FavoriteType() {
    if (hasE8FavoriteType()) {
         clear_has_e8FavoriteType();
        _e8FavoriteType = ::most_FavPrv_fi_types::T_e8_FavPrvFavoriteType__e8FT_ALL;
     }
}

inline bool T_FavPrvFavoriteInfoItem::hasE8FavoriteType () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline T_e8_FavPrvFavoriteType T_FavPrvFavoriteInfoItem::getE8FavoriteType () const {
    return _e8FavoriteType;
}

inline void T_FavPrvFavoriteInfoItem::setE8FavoriteType (T_e8_FavPrvFavoriteType e8FavoriteType_) {
    #ifndef NDEBUG
    if (!(T_e8_FavPrvFavoriteType_IsValid(e8FavoriteType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8FavoriteType_, "T_e8_FavPrvFavoriteType", "e8FavoriteType", "T_FavPrvFavoriteInfoItem");
    }
    #endif
    set_has_e8FavoriteType();
    this->_e8FavoriteType = e8FavoriteType_;
}

inline void T_FavPrvFavoriteInfoItem::set_has_bActive () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_FavPrvFavoriteInfoItem::clear_has_bActive () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_FavPrvFavoriteInfoItem::set_has_bAvailable () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_FavPrvFavoriteInfoItem::clear_has_bAvailable () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_FavPrvFavoriteInfoItem::set_has_u16FavoriteID () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_FavPrvFavoriteInfoItem::clear_has_u16FavoriteID () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_FavPrvFavoriteInfoItem::set_has_sLabelText () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_FavPrvFavoriteInfoItem::clear_has_sLabelText () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_FavPrvFavoriteInfoItem::set_has_sDescriptorText () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_FavPrvFavoriteInfoItem::clear_has_sDescriptorText () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_FavPrvFavoriteInfoItem::set_has_e8FavoriteType () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_FavPrvFavoriteInfoItem::clear_has_e8FavoriteType () {
    _has_bits_[0] &= ~ (1u << 5);
}

} // namespace most_FavPrv_fi_types

#endif // MOST_FAVPRV_FI_TYPES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
