/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/cca/CcaMostStream.h"
#include "asf/core/Types.h"
#include "asf/stream/MemoryStream.h"
#include "most_Msg_fi_typesCcaMost.h"
#include "most_Msg_fi_typesConst.h"
#include "most_Msg_fi_types_Extended.h"
#include "most_Msg_fi_types_ExtendedCcaMost.h"
#include "most_Msg_fi_types_ExtendedConst.h"


// --------------------------------------------------------------------------
// MemoryStream functions
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// CcaMostStream functions
// --------------------------------------------------------------------------

// Serialize T_MsgPredefinedMessageListExtendedResultItem

void serializeCcaMost(const ::most_Msg_fi_types_Extended::T_MsgPredefinedMessageListExtendedResultItem& in, ::asf::cca::CcaMostStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU8DeviceHandle();
    out << in.getU16PredefinedMessageHandle();
    out << (uint8) in.getE8PredefinedMessageType();
    out << (uint8) in.getE8PredefinedMessageCategory();
    out << (uint8) in.getE8PredefinedMessageSubCategory();
    out.writeMostString(in.getSPredefinedMessageText());
}

void deserializeCcaMost(::asf::cca::CcaMostStream& in, ::most_Msg_fi_types_Extended::T_MsgPredefinedMessageListExtendedResultItem& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o0;
    in >> o0;
    out.setU8DeviceHandle(o0);
    uint16 o1;
    in >> o1;
    out.setU16PredefinedMessageHandle(o1);
    uint8 o2;
    in >> o2;
    out.setE8PredefinedMessageType((::most_Msg_fi_types::T_e8_MsgPredefinedMessageType)o2);
    uint8 o3;
    in >> o3;
    out.setE8PredefinedMessageCategory((::most_Msg_fi_types_Extended::T_e8_MsgPredefinedMessageCategory)o3);
    uint8 o4;
    in >> o4;
    out.setE8PredefinedMessageSubCategory((::most_Msg_fi_types_Extended::T_e8_MsgPredefinedMessageSubCategory)o4);
    in.readMostString(out.getSPredefinedMessageTextMutable());
}

// Serialize T_SignatureTextStreamItem

void serializeCcaMost(const ::most_Msg_fi_types_Extended::T_SignatureTextStreamItem& in, ::asf::cca::CcaMostStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU8DeviceHandle();
    out << (uint8) in.getBSignatureOnOff();
    out.writeMostString(in.getSSignatureText());
}

void deserializeCcaMost(::asf::cca::CcaMostStream& in, ::most_Msg_fi_types_Extended::T_SignatureTextStreamItem& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o5;
    in >> o5;
    out.setU8DeviceHandle(o5);
    bool o6;
    in >> o6;
    out.setBSignatureOnOff(o6);
    in.readMostString(out.getSSignatureTextMutable());
}

// Serialize T_MsgConversationListSliceResultItem

void serializeCcaMost(const ::most_Msg_fi_types_Extended::T_MsgConversationListSliceResultItem& in, ::asf::cca::CcaMostStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCcaMost(in.getOConversationHandle(), out, majorVersion);
    serializeCcaMost(in.getOLastActivity(), out, majorVersion);
    out.writeMostString(in.getSSubject());
    out << in.getU32AttachmentSize();
    out << (uint8) in.getE8MessageType();
    out << in.getU32NumberOfMessages();
    out << in.getU8UnreadMessageCount();
    serializeCcaMost(in.getOAddressField(), out, majorVersion);
    out << in.getU32ContactHandle();
}

void deserializeCcaMost(::asf::cca::CcaMostStream& in, ::most_Msg_fi_types_Extended::T_MsgConversationListSliceResultItem& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCcaMost(in, out.getOConversationHandleMutable(), majorVersion);
    deserializeCcaMost(in, out.getOLastActivityMutable(), majorVersion);
    in.readMostString(out.getSSubjectMutable());
    uint32 o7;
    in >> o7;
    out.setU32AttachmentSize(o7);
    uint8 o8;
    in >> o8;
    out.setE8MessageType((::most_Msg_fi_types::T_e8_MsgMessageType)o8);
    uint32 o9;
    in >> o9;
    out.setU32NumberOfMessages(o9);
    uint8 o10;
    in >> o10;
    out.setU8UnreadMessageCount(o10);
    deserializeCcaMost(in, out.getOAddressFieldMutable(), majorVersion);
    uint32 o11;
    in >> o11;
    out.setU32ContactHandle(o11);
}

// Serialize T_MsgConversationDetailListItem

void serializeCcaMost(const ::most_Msg_fi_types_Extended::T_MsgConversationDetailListItem& in, ::asf::cca::CcaMostStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCcaMost(in.getOMessageHandle(), out, majorVersion);
    serializeCcaMost(in.getOMessageDateTime(), out, majorVersion);
    out.writeMostString(in.getSMessageContent());
    out << in.getU32AttachmentSize();
    out << (uint8) in.getE8MessageType();
    out << (uint8) in.getE8MessageStatus();
    out << (uint8) in.getBReadStatusFlag();
    serializeCcaMost(in.getOAddressField(), out, majorVersion);
    out << in.getU32ContactHandle();
}

void deserializeCcaMost(::asf::cca::CcaMostStream& in, ::most_Msg_fi_types_Extended::T_MsgConversationDetailListItem& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCcaMost(in, out.getOMessageHandleMutable(), majorVersion);
    deserializeCcaMost(in, out.getOMessageDateTimeMutable(), majorVersion);
    in.readMostString(out.getSMessageContentMutable());
    uint32 o12;
    in >> o12;
    out.setU32AttachmentSize(o12);
    uint8 o13;
    in >> o13;
    out.setE8MessageType((::most_Msg_fi_types::T_e8_MsgMessageType)o13);
    uint8 o14;
    in >> o14;
    out.setE8MessageStatus((::most_Msg_fi_types_Extended::T_e8_MsgMessageStatus)o14);
    bool o15;
    in >> o15;
    out.setBReadStatusFlag(o15);
    deserializeCcaMost(in, out.getOAddressFieldMutable(), majorVersion);
    uint32 o16;
    in >> o16;
    out.setU32ContactHandle(o16);
}

// Serialize T_MsgConversationHandle

void serializeCcaMost(const ::most_Msg_fi_types_Extended::T_MsgConversationHandle& in, ::asf::cca::CcaMostStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8* positionContentLength = out.getCurrentWritePos();
    uint8 contentLength = 0;
    out << contentLength;
    uint8* positionStartList = out.getCurrentWritePos();
    out << in.getU8DeviceHandle();
    out << in.getU32ConversationID();
    uint8* positionEndList = out.getCurrentWritePos();
    contentLength = static_cast<uint8>(positionEndList - positionStartList);
    assert(contentLength <= 255);
    out.writeToPosUint8( positionContentLength, contentLength);
}

void deserializeCcaMost(::asf::cca::CcaMostStream& in, ::most_Msg_fi_types_Extended::T_MsgConversationHandle& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 contentLength = 0;
    in >> contentLength;
    uint8* positionStreamEnd = in.getCurrentReadPos() + contentLength;
    uint8 o17;
    in >> o17;
    out.setU8DeviceHandle(o17);
    uint32 o18;
    in >> o18;
    out.setU32ConversationID(o18);
    assert(in.getCurrentReadPos() == positionStreamEnd);
    (void)positionStreamEnd; // make release build happy
}

// Serialize T_OnOffListItem

void serializeCcaMost(const ::most_Msg_fi_types_Extended::T_OnOffListItem& in, ::asf::cca::CcaMostStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU8DeviceHandle();
    out << (uint8) in.getBOnOffState();
}

void deserializeCcaMost(::asf::cca::CcaMostStream& in, ::most_Msg_fi_types_Extended::T_OnOffListItem& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o19;
    in >> o19;
    out.setU8DeviceHandle(o19);
    bool o20;
    in >> o20;
    out.setBOnOffState(o20);
}

// Serialize T_AutoReplyTextListItem

void serializeCcaMost(const ::most_Msg_fi_types_Extended::T_AutoReplyTextListItem& in, ::asf::cca::CcaMostStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU8DeviceHandle();
    out << in.getU16PredefinedMsgHandle();
}

void deserializeCcaMost(::asf::cca::CcaMostStream& in, ::most_Msg_fi_types_Extended::T_AutoReplyTextListItem& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o21;
    in >> o21;
    out.setU8DeviceHandle(o21);
    uint16 o22;
    in >> o22;
    out.setU16PredefinedMsgHandle(o22);
}

// Serialize T_MapDeviceCapabilitiesListItem

void serializeCcaMost(const ::most_Msg_fi_types_Extended::T_MapDeviceCapabilitiesListItem& in, ::asf::cca::CcaMostStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU8DeviceHandle();
    out << in.getU16SupportedMessageTypes();
    out << in.getU16SupportedMapFeatures();
    out << (uint8) in.getE8MapConnectionState();
    serializeCcaMost(in.getOActiveAccount(), out, majorVersion);
}

void deserializeCcaMost(::asf::cca::CcaMostStream& in, ::most_Msg_fi_types_Extended::T_MapDeviceCapabilitiesListItem& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o23;
    in >> o23;
    out.setU8DeviceHandle(o23);
    uint16 o24;
    in >> o24;
    out.setU16SupportedMessageTypes(o24);
    uint16 o25;
    in >> o25;
    out.setU16SupportedMapFeatures(o25);
    uint8 o26;
    in >> o26;
    out.setE8MapConnectionState((::most_Msg_fi_types_Extended::T_e8_MapConnectionStatus)o26);
    deserializeCcaMost(in, out.getOActiveAccountMutable(), majorVersion);
}

