#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef MOST_MSG_FI_TYPES_EXTENDED_H
#define MOST_MSG_FI_TYPES_EXTENDED_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "fi_basetypes_most.h"
#include "most_Msg_fi_types.h"
#include "most_Msg_fi_typesConst.h"
#include "most_Msg_fi_types_ExtendedConst.h"
#include <cstring>
#include <vector>

/**
 * Types most_Msg_fi_types_Extended
 */

namespace most_Msg_fi_types_Extended {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class T_MsgPredefinedMessageListExtendedResultItem;

class T_SignatureTextStreamItem;

class T_MsgConversationHandle;

class T_MsgConversationListSliceResultItem;

class T_MsgConversationDetailListItem;

class T_OnOffListItem;

class T_AutoReplyTextListItem;

class T_MapDeviceCapabilitiesListItem;

// type definitions
/**
 * If the meaning of "T_MsgPredefinedMessageListExtendedResult" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_MsgPredefinedMessageListExtendedResultItem > T_MsgPredefinedMessageListExtendedResult;

/**
 * If the meaning of "T_SignatureTextStream" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_SignatureTextStreamItem > T_SignatureTextStream;

/**
 * If the meaning of "T_MsgConversationListSliceResult" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_MsgConversationListSliceResultItem > T_MsgConversationListSliceResult;

/**
 * If the meaning of "T_MsgConversationDetailList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_MsgConversationDetailListItem > T_MsgConversationDetailList;

/**
 * If the meaning of "T_OnOffList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_OnOffListItem > T_OnOffList;

/**
 * If the meaning of "T_AutoReplyTextList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_AutoReplyTextListItem > T_AutoReplyTextList;

/**
 * If the meaning of "T_MapDeviceCapabilitiesList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_MapDeviceCapabilitiesListItem > T_MapDeviceCapabilitiesList;


class T_MsgPredefinedMessageListExtendedResultItem {
public:

    /**
     * Default constructor
     */
    inline  T_MsgPredefinedMessageListExtendedResultItem ();

    /**
     * Copy constructor
     */
    inline  T_MsgPredefinedMessageListExtendedResultItem (const T_MsgPredefinedMessageListExtendedResultItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_MsgPredefinedMessageListExtendedResultItem (uint8 u8DeviceHandle_, uint16 u16PredefinedMessageHandle_, ::most_Msg_fi_types::T_e8_MsgPredefinedMessageType e8PredefinedMessageType_, T_e8_MsgPredefinedMessageCategory e8PredefinedMessageCategory_, T_e8_MsgPredefinedMessageSubCategory e8PredefinedMessageSubCategory_, const ::fi_basetypes_most::T_String& sPredefinedMessageText_);

    /**
     * Destructor
     */
    inline  ~T_MsgPredefinedMessageListExtendedResultItem();

    /**
     * Assignment operator
     */
    inline T_MsgPredefinedMessageListExtendedResultItem& operator = (const T_MsgPredefinedMessageListExtendedResultItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_MsgPredefinedMessageListExtendedResultItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_MsgPredefinedMessageListExtendedResultItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_MsgPredefinedMessageListExtendedResultItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_MsgPredefinedMessageListExtendedResultItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of devices that could be paired. The maximum value is project specific.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of devices that could be paired. The maximum value is project specific.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    // API of field "u16PredefinedMessageHandle"

    static const int kU16PredefinedMessageHandle = 1;

    /**
     * Clears the field "u16PredefinedMessageHandle".
     *
     * The field will be set to its default value. The hasU16PredefinedMessageHandle()
     * method will return false.
     */
    inline void clearU16PredefinedMessageHandle();

    /**
     * Checks whether the field "u16PredefinedMessageHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16PredefinedMessageHandle()). Otherwise it will return false.
     */
    inline bool hasU16PredefinedMessageHandle () const;

    /**
     * Returns the value of the member "u16PredefinedMessageHandle".
     *
     * This is the unique ID for a particular predefined message text.
     *
     * @return The value of the field "u16PredefinedMessageHandle"
     */
    inline uint16 getU16PredefinedMessageHandle () const;

    /**
     * Sets the value of the member "u16PredefinedMessageHandle".
     *
     * This is the unique ID for a particular predefined message text.
     *
     * @param u16PredefinedMessageHandle The value which will be set
     */
    inline void setU16PredefinedMessageHandle (uint16 u16PredefinedMessageHandle_);

    // API of field "e8PredefinedMessageType"

    static const int kE8PredefinedMessageType = 2;

    /**
     * Clears the field "e8PredefinedMessageType".
     *
     * The field will be set to its default value. The hasE8PredefinedMessageType()
     * method will return false.
     */
    inline void clearE8PredefinedMessageType();

    /**
     * Checks whether the field "e8PredefinedMessageType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8PredefinedMessageType()). Otherwise it will return false.
     */
    inline bool hasE8PredefinedMessageType () const;

    /**
     * Returns the value of the member "e8PredefinedMessageType".
     *
     *
     *
     * @return The value of the field "e8PredefinedMessageType"
     */
    inline ::most_Msg_fi_types::T_e8_MsgPredefinedMessageType getE8PredefinedMessageType () const;

    /**
     * Sets the value of the member "e8PredefinedMessageType".
     *
     *
     *
     * @param e8PredefinedMessageType The value which will be set
     */
    inline void setE8PredefinedMessageType (::most_Msg_fi_types::T_e8_MsgPredefinedMessageType e8PredefinedMessageType_);

    // API of field "e8PredefinedMessageCategory"

    static const int kE8PredefinedMessageCategory = 3;

    /**
     * Clears the field "e8PredefinedMessageCategory".
     *
     * The field will be set to its default value. The hasE8PredefinedMessageCategory()
     * method will return false.
     */
    inline void clearE8PredefinedMessageCategory();

    /**
     * Checks whether the field "e8PredefinedMessageCategory" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8PredefinedMessageCategory()). Otherwise it will return false.
     */
    inline bool hasE8PredefinedMessageCategory () const;

    /**
     * Returns the value of the member "e8PredefinedMessageCategory".
     *
     *
     *
     * @return The value of the field "e8PredefinedMessageCategory"
     */
    inline T_e8_MsgPredefinedMessageCategory getE8PredefinedMessageCategory () const;

    /**
     * Sets the value of the member "e8PredefinedMessageCategory".
     *
     *
     *
     * @param e8PredefinedMessageCategory The value which will be set
     */
    inline void setE8PredefinedMessageCategory (T_e8_MsgPredefinedMessageCategory e8PredefinedMessageCategory_);

    // API of field "e8PredefinedMessageSubCategory"

    static const int kE8PredefinedMessageSubCategory = 4;

    /**
     * Clears the field "e8PredefinedMessageSubCategory".
     *
     * The field will be set to its default value. The hasE8PredefinedMessageSubCategory()
     * method will return false.
     */
    inline void clearE8PredefinedMessageSubCategory();

    /**
     * Checks whether the field "e8PredefinedMessageSubCategory" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8PredefinedMessageSubCategory()). Otherwise it will return false.
     */
    inline bool hasE8PredefinedMessageSubCategory () const;

    /**
     * Returns the value of the member "e8PredefinedMessageSubCategory".
     *
     *
     *
     * @return The value of the field "e8PredefinedMessageSubCategory"
     */
    inline T_e8_MsgPredefinedMessageSubCategory getE8PredefinedMessageSubCategory () const;

    /**
     * Sets the value of the member "e8PredefinedMessageSubCategory".
     *
     *
     *
     * @param e8PredefinedMessageSubCategory The value which will be set
     */
    inline void setE8PredefinedMessageSubCategory (T_e8_MsgPredefinedMessageSubCategory e8PredefinedMessageSubCategory_);

    // API of field "sPredefinedMessageText"

    static const int kSPredefinedMessageText = 5;

    /**
     * Clears the field "sPredefinedMessageText".
     *
     * The field will be set to its default value. The hasSPredefinedMessageText()
     * method will return false.
     */
    inline void clearSPredefinedMessageText();

    /**
     * Checks whether the field "sPredefinedMessageText" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSPredefinedMessageText()). Otherwise it will return false.
     */
    inline bool hasSPredefinedMessageText () const;

    /**
     * Returns the value of the member "sPredefinedMessageText".
     *
     * The text of the predefined message.
     *
     * @return The value of the field "sPredefinedMessageText"
     */
    inline const ::fi_basetypes_most::T_String& getSPredefinedMessageText () const;

    /**
     * Retrieves the value of the field "sPredefinedMessageText" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sPredefinedMessageText".
     */
    inline ::fi_basetypes_most::T_String& getSPredefinedMessageTextMutable ();

    /**
     * Sets the value of the member "sPredefinedMessageText".
     *
     * The text of the predefined message.
     *
     * @param sPredefinedMessageText The value which will be set
     */
    inline void setSPredefinedMessageText (const ::fi_basetypes_most::T_String& sPredefinedMessageText_);

    static const T_MsgPredefinedMessageListExtendedResultItem &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    inline void set_has_u16PredefinedMessageHandle ();

    inline void clear_has_u16PredefinedMessageHandle ();

    inline void set_has_e8PredefinedMessageType ();

    inline void clear_has_e8PredefinedMessageType ();

    inline void set_has_e8PredefinedMessageCategory ();

    inline void clear_has_e8PredefinedMessageCategory ();

    inline void set_has_e8PredefinedMessageSubCategory ();

    inline void clear_has_e8PredefinedMessageSubCategory ();

    inline void set_has_sPredefinedMessageText ();

    inline void clear_has_sPredefinedMessageText ();

    uint32 _has_bits_[ (6 + 31) / 32];

    uint8 _u8DeviceHandle;

    uint16 _u16PredefinedMessageHandle;

    ::most_Msg_fi_types::T_e8_MsgPredefinedMessageType _e8PredefinedMessageType;

    T_e8_MsgPredefinedMessageCategory _e8PredefinedMessageCategory;

    T_e8_MsgPredefinedMessageSubCategory _e8PredefinedMessageSubCategory;

    ::fi_basetypes_most::T_String _sPredefinedMessageText;

};

class T_SignatureTextStreamItem {
public:

    /**
     * Default constructor
     */
    inline  T_SignatureTextStreamItem ();

    /**
     * Copy constructor
     */
    inline  T_SignatureTextStreamItem (const T_SignatureTextStreamItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_SignatureTextStreamItem (uint8 u8DeviceHandle_, bool bSignatureOnOff_, const ::fi_basetypes_most::T_String& sSignatureText_);

    /**
     * Destructor
     */
    inline  ~T_SignatureTextStreamItem();

    /**
     * Assignment operator
     */
    inline T_SignatureTextStreamItem& operator = (const T_SignatureTextStreamItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SignatureTextStreamItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SignatureTextStreamItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SignatureTextStreamItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SignatureTextStreamItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of devices that could be paired. The maximum value is project specific.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of devices that could be paired. The maximum value is project specific.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    // API of field "bSignatureOnOff"

    static const int kBSignatureOnOff = 1;

    /**
     * Clears the field "bSignatureOnOff".
     *
     * The field will be set to its default value. The hasBSignatureOnOff()
     * method will return false.
     */
    inline void clearBSignatureOnOff();

    /**
     * Checks whether the field "bSignatureOnOff" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBSignatureOnOff()). Otherwise it will return false.
     */
    inline bool hasBSignatureOnOff () const;

    /**
     * Returns the value of the member "bSignatureOnOff".
     *
     * Indicates whether signature setting is ON/OFF for the given device handle
     *
     * @return The value of the field "bSignatureOnOff"
     */
    inline bool getBSignatureOnOff () const;

    /**
     * Sets the value of the member "bSignatureOnOff".
     *
     * Indicates whether signature setting is ON/OFF for the given device handle
     *
     * @param bSignatureOnOff The value which will be set
     */
    inline void setBSignatureOnOff (bool bSignatureOnOff_);

    // API of field "sSignatureText"

    static const int kSSignatureText = 2;

    /**
     * Clears the field "sSignatureText".
     *
     * The field will be set to its default value. The hasSSignatureText()
     * method will return false.
     */
    inline void clearSSignatureText();

    /**
     * Checks whether the field "sSignatureText" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSSignatureText()). Otherwise it will return false.
     */
    inline bool hasSSignatureText () const;

    /**
     * Returns the value of the member "sSignatureText".
     *
     * The text of the signature to be appended to messages sent from the vehicle.
     *
     * @return The value of the field "sSignatureText"
     */
    inline const ::fi_basetypes_most::T_String& getSSignatureText () const;

    /**
     * Retrieves the value of the field "sSignatureText" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sSignatureText".
     */
    inline ::fi_basetypes_most::T_String& getSSignatureTextMutable ();

    /**
     * Sets the value of the member "sSignatureText".
     *
     * The text of the signature to be appended to messages sent from the vehicle.
     *
     * @param sSignatureText The value which will be set
     */
    inline void setSSignatureText (const ::fi_basetypes_most::T_String& sSignatureText_);

    static const T_SignatureTextStreamItem &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    inline void set_has_bSignatureOnOff ();

    inline void clear_has_bSignatureOnOff ();

    inline void set_has_sSignatureText ();

    inline void clear_has_sSignatureText ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _u8DeviceHandle;

    bool _bSignatureOnOff;

    ::fi_basetypes_most::T_String _sSignatureText;

};

class T_MsgConversationHandle {
public:

    /**
     * Default constructor
     */
    inline  T_MsgConversationHandle ();

    /**
     * Copy constructor
     */
    inline  T_MsgConversationHandle (const T_MsgConversationHandle &rhs);

    /**
     * All fields constructor
     */
    inline  T_MsgConversationHandle (uint8 u8DeviceHandle_, uint32 u32ConversationID_);

    /**
     * Destructor
     */
    inline  ~T_MsgConversationHandle();

    /**
     * Assignment operator
     */
    inline T_MsgConversationHandle& operator = (const T_MsgConversationHandle& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_MsgConversationHandle& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_MsgConversationHandle& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_MsgConversationHandle& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_MsgConversationHandle& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Unique handle for each paired device. Maximum value is project specific.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Unique handle for each paired device. Maximum value is project specific.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    // API of field "u32ConversationID"

    static const int kU32ConversationID = 1;

    /**
     * Clears the field "u32ConversationID".
     *
     * The field will be set to its default value. The hasU32ConversationID()
     * method will return false.
     */
    inline void clearU32ConversationID();

    /**
     * Checks whether the field "u32ConversationID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ConversationID()). Otherwise it will return false.
     */
    inline bool hasU32ConversationID () const;

    /**
     * Returns the value of the member "u32ConversationID".
     *
     * A unique ID to represent a conversation in the conversation list.
     *
     * @return The value of the field "u32ConversationID"
     */
    inline uint32 getU32ConversationID () const;

    /**
     * Sets the value of the member "u32ConversationID".
     *
     * A unique ID to represent a conversation in the conversation list.
     *
     * @param u32ConversationID The value which will be set
     */
    inline void setU32ConversationID (uint32 u32ConversationID_);

    static const T_MsgConversationHandle &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    inline void set_has_u32ConversationID ();

    inline void clear_has_u32ConversationID ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8DeviceHandle;

    uint32 _u32ConversationID;

};

class T_MsgConversationListSliceResultItem {
public:

    /**
     * Default constructor
     */
    inline  T_MsgConversationListSliceResultItem ();

    /**
     * Copy constructor
     */
    inline  T_MsgConversationListSliceResultItem (const T_MsgConversationListSliceResultItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_MsgConversationListSliceResultItem (const T_MsgConversationHandle& oConversationHandle_, const ::most_Msg_fi_types::T_MsgMessageDateTime& oLastActivity_, const ::fi_basetypes_most::T_String& sSubject_, uint32 u32AttachmentSize_, ::most_Msg_fi_types::T_e8_MsgMessageType e8MessageType_, uint32 u32NumberOfMessages_, uint8 u8UnreadMessageCount_, const ::most_Msg_fi_types::T_MsgAddressFieldItem& oAddressField_, uint32 u32ContactHandle_);

    /**
     * Destructor
     */
    inline  ~T_MsgConversationListSliceResultItem();

    /**
     * Assignment operator
     */
    inline T_MsgConversationListSliceResultItem& operator = (const T_MsgConversationListSliceResultItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_MsgConversationListSliceResultItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_MsgConversationListSliceResultItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_MsgConversationListSliceResultItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_MsgConversationListSliceResultItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oConversationHandle"

    static const int kOConversationHandle = 0;

    /**
     * Clears the field "oConversationHandle".
     *
     * The field will be set to its default value. The hasOConversationHandle()
     * method will return false.
     */
    inline void clearOConversationHandle();

    /**
     * Checks whether the field "oConversationHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOConversationHandle()). Otherwise it will return false.
     */
    inline bool hasOConversationHandle () const;

    /**
     * Returns the value of the member "oConversationHandle".
     *
     * This is the unique ID for a conversation. It comprises of DeviceHandle and ConversationID.
     *
     * @return The value of the field "oConversationHandle"
     */
    inline const T_MsgConversationHandle& getOConversationHandle () const;

    /**
     * Retrieves the value of the field "oConversationHandle" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oConversationHandle".
     */
    inline T_MsgConversationHandle& getOConversationHandleMutable ();

    /**
     * Sets the value of the member "oConversationHandle".
     *
     * This is the unique ID for a conversation. It comprises of DeviceHandle and ConversationID.
     *
     * @param oConversationHandle The value which will be set
     */
    inline void setOConversationHandle (const T_MsgConversationHandle& oConversationHandle_);

    // API of field "oLastActivity"

    static const int kOLastActivity = 1;

    /**
     * Clears the field "oLastActivity".
     *
     * The field will be set to its default value. The hasOLastActivity()
     * method will return false.
     */
    inline void clearOLastActivity();

    /**
     * Checks whether the field "oLastActivity" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOLastActivity()). Otherwise it will return false.
     */
    inline bool hasOLastActivity () const;

    /**
     * Returns the value of the member "oLastActivity".
     *
     * Indicates the date and time of the last activity in the particular conversation. The message date and time formatted as YYYYMMDDHHMMSS. LastActivity is made up of the MessageDate stream and the MessageTime stream.
     *
     * @return The value of the field "oLastActivity"
     */
    inline const ::most_Msg_fi_types::T_MsgMessageDateTime& getOLastActivity () const;

    /**
     * Retrieves the value of the field "oLastActivity" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oLastActivity".
     */
    inline ::most_Msg_fi_types::T_MsgMessageDateTime& getOLastActivityMutable ();

    /**
     * Sets the value of the member "oLastActivity".
     *
     * Indicates the date and time of the last activity in the particular conversation. The message date and time formatted as YYYYMMDDHHMMSS. LastActivity is made up of the MessageDate stream and the MessageTime stream.
     *
     * @param oLastActivity The value which will be set
     */
    inline void setOLastActivity (const ::most_Msg_fi_types::T_MsgMessageDateTime& oLastActivity_);

    // API of field "sSubject"

    static const int kSSubject = 2;

    /**
     * Clears the field "sSubject".
     *
     * The field will be set to its default value. The hasSSubject()
     * method will return false.
     */
    inline void clearSSubject();

    /**
     * Checks whether the field "sSubject" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSSubject()). Otherwise it will return false.
     */
    inline bool hasSSubject () const;

    /**
     * Returns the value of the member "sSubject".
     *
     * In case of SMS or MMS it provides the message content. In case of Email it provides the subject of the message. It is limited to 160 characters
     *
     * @return The value of the field "sSubject"
     */
    inline const ::fi_basetypes_most::T_String& getSSubject () const;

    /**
     * Retrieves the value of the field "sSubject" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sSubject".
     */
    inline ::fi_basetypes_most::T_String& getSSubjectMutable ();

    /**
     * Sets the value of the member "sSubject".
     *
     * In case of SMS or MMS it provides the message content. In case of Email it provides the subject of the message. It is limited to 160 characters
     *
     * @param sSubject The value which will be set
     */
    inline void setSSubject (const ::fi_basetypes_most::T_String& sSubject_);

    // API of field "u32AttachmentSize"

    static const int kU32AttachmentSize = 3;

    /**
     * Clears the field "u32AttachmentSize".
     *
     * The field will be set to its default value. The hasU32AttachmentSize()
     * method will return false.
     */
    inline void clearU32AttachmentSize();

    /**
     * Checks whether the field "u32AttachmentSize" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32AttachmentSize()). Otherwise it will return false.
     */
    inline bool hasU32AttachmentSize () const;

    /**
     * Returns the value of the member "u32AttachmentSize".
     *
     * Provides the size of the attachments received in the latest message in bytes. If there are no attachments then size will be zero.
     *
     * @return The value of the field "u32AttachmentSize"
     */
    inline uint32 getU32AttachmentSize () const;

    /**
     * Sets the value of the member "u32AttachmentSize".
     *
     * Provides the size of the attachments received in the latest message in bytes. If there are no attachments then size will be zero.
     *
     * @param u32AttachmentSize The value which will be set
     */
    inline void setU32AttachmentSize (uint32 u32AttachmentSize_);

    // API of field "e8MessageType"

    static const int kE8MessageType = 4;

    /**
     * Clears the field "e8MessageType".
     *
     * The field will be set to its default value. The hasE8MessageType()
     * method will return false.
     */
    inline void clearE8MessageType();

    /**
     * Checks whether the field "e8MessageType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MessageType()). Otherwise it will return false.
     */
    inline bool hasE8MessageType () const;

    /**
     * Returns the value of the member "e8MessageType".
     *
     * Identifies the type of message: SMS, MMS, or Email.
     *
     * @return The value of the field "e8MessageType"
     */
    inline ::most_Msg_fi_types::T_e8_MsgMessageType getE8MessageType () const;

    /**
     * Sets the value of the member "e8MessageType".
     *
     * Identifies the type of message: SMS, MMS, or Email.
     *
     * @param e8MessageType The value which will be set
     */
    inline void setE8MessageType (::most_Msg_fi_types::T_e8_MsgMessageType e8MessageType_);

    // API of field "u32NumberOfMessages"

    static const int kU32NumberOfMessages = 5;

    /**
     * Clears the field "u32NumberOfMessages".
     *
     * The field will be set to its default value. The hasU32NumberOfMessages()
     * method will return false.
     */
    inline void clearU32NumberOfMessages();

    /**
     * Checks whether the field "u32NumberOfMessages" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32NumberOfMessages()). Otherwise it will return false.
     */
    inline bool hasU32NumberOfMessages () const;

    /**
     * Returns the value of the member "u32NumberOfMessages".
     *
     * Total number of messages in a particular conversation.
     *
     * @return The value of the field "u32NumberOfMessages"
     */
    inline uint32 getU32NumberOfMessages () const;

    /**
     * Sets the value of the member "u32NumberOfMessages".
     *
     * Total number of messages in a particular conversation.
     *
     * @param u32NumberOfMessages The value which will be set
     */
    inline void setU32NumberOfMessages (uint32 u32NumberOfMessages_);

    // API of field "u8UnreadMessageCount"

    static const int kU8UnreadMessageCount = 6;

    /**
     * Clears the field "u8UnreadMessageCount".
     *
     * The field will be set to its default value. The hasU8UnreadMessageCount()
     * method will return false.
     */
    inline void clearU8UnreadMessageCount();

    /**
     * Checks whether the field "u8UnreadMessageCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8UnreadMessageCount()). Otherwise it will return false.
     */
    inline bool hasU8UnreadMessageCount () const;

    /**
     * Returns the value of the member "u8UnreadMessageCount".
     *
     * Number of unread messages in the particular conversation message group.
     *
     * @return The value of the field "u8UnreadMessageCount"
     */
    inline uint8 getU8UnreadMessageCount () const;

    /**
     * Sets the value of the member "u8UnreadMessageCount".
     *
     * Number of unread messages in the particular conversation message group.
     *
     * @param u8UnreadMessageCount The value which will be set
     */
    inline void setU8UnreadMessageCount (uint8 u8UnreadMessageCount_);

    // API of field "oAddressField"

    static const int kOAddressField = 7;

    /**
     * Clears the field "oAddressField".
     *
     * The field will be set to its default value. The hasOAddressField()
     * method will return false.
     */
    inline void clearOAddressField();

    /**
     * Checks whether the field "oAddressField" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOAddressField()). Otherwise it will return false.
     */
    inline bool hasOAddressField () const;

    /**
     * Returns the value of the member "oAddressField".
     *
     * Provides the field type (From, To, CC) and the sender or recipient contact information.
     *
     * @return The value of the field "oAddressField"
     */
    inline const ::most_Msg_fi_types::T_MsgAddressFieldItem& getOAddressField () const;

    /**
     * Retrieves the value of the field "oAddressField" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oAddressField".
     */
    inline ::most_Msg_fi_types::T_MsgAddressFieldItem& getOAddressFieldMutable ();

    /**
     * Sets the value of the member "oAddressField".
     *
     * Provides the field type (From, To, CC) and the sender or recipient contact information.
     *
     * @param oAddressField The value which will be set
     */
    inline void setOAddressField (const ::most_Msg_fi_types::T_MsgAddressFieldItem& oAddressField_);

    // API of field "u32ContactHandle"

    static const int kU32ContactHandle = 8;

    /**
     * Clears the field "u32ContactHandle".
     *
     * The field will be set to its default value. The hasU32ContactHandle()
     * method will return false.
     */
    inline void clearU32ContactHandle();

    /**
     * Checks whether the field "u32ContactHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ContactHandle()). Otherwise it will return false.
     */
    inline bool hasU32ContactHandle () const;

    /**
     * Returns the value of the member "u32ContactHandle".
     *
     * This is the globally unique ID for a particular contact. The ID is unique across all currently connected devices.
     *
     * @return The value of the field "u32ContactHandle"
     */
    inline uint32 getU32ContactHandle () const;

    /**
     * Sets the value of the member "u32ContactHandle".
     *
     * This is the globally unique ID for a particular contact. The ID is unique across all currently connected devices.
     *
     * @param u32ContactHandle The value which will be set
     */
    inline void setU32ContactHandle (uint32 u32ContactHandle_);

    static const T_MsgConversationListSliceResultItem &getDefaultInstance();

private:

    inline void set_has_oConversationHandle ();

    inline void clear_has_oConversationHandle ();

    inline void set_has_oLastActivity ();

    inline void clear_has_oLastActivity ();

    inline void set_has_sSubject ();

    inline void clear_has_sSubject ();

    inline void set_has_u32AttachmentSize ();

    inline void clear_has_u32AttachmentSize ();

    inline void set_has_e8MessageType ();

    inline void clear_has_e8MessageType ();

    inline void set_has_u32NumberOfMessages ();

    inline void clear_has_u32NumberOfMessages ();

    inline void set_has_u8UnreadMessageCount ();

    inline void clear_has_u8UnreadMessageCount ();

    inline void set_has_oAddressField ();

    inline void clear_has_oAddressField ();

    inline void set_has_u32ContactHandle ();

    inline void clear_has_u32ContactHandle ();

    uint32 _has_bits_[ (9 + 31) / 32];

    T_MsgConversationHandle _oConversationHandle;

    ::most_Msg_fi_types::T_MsgMessageDateTime _oLastActivity;

    ::fi_basetypes_most::T_String _sSubject;

    uint32 _u32AttachmentSize;

    ::most_Msg_fi_types::T_e8_MsgMessageType _e8MessageType;

    uint32 _u32NumberOfMessages;

    uint8 _u8UnreadMessageCount;

    ::most_Msg_fi_types::T_MsgAddressFieldItem _oAddressField;

    uint32 _u32ContactHandle;

};

class T_MsgConversationDetailListItem {
public:

    /**
     * Default constructor
     */
    inline  T_MsgConversationDetailListItem ();

    /**
     * Copy constructor
     */
    inline  T_MsgConversationDetailListItem (const T_MsgConversationDetailListItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_MsgConversationDetailListItem (const ::most_Msg_fi_types::T_MsgMessageHandle& oMessageHandle_, const ::most_Msg_fi_types::T_MsgMessageDateTime& oMessageDateTime_, const ::fi_basetypes_most::T_String& sMessageContent_, uint32 u32AttachmentSize_, ::most_Msg_fi_types::T_e8_MsgMessageType e8MessageType_, T_e8_MsgMessageStatus e8MessageStatus_, bool bReadStatusFlag_, const ::most_Msg_fi_types::T_MsgAddressFieldItem& oAddressField_, uint32 u32ContactHandle_);

    /**
     * Destructor
     */
    inline  ~T_MsgConversationDetailListItem();

    /**
     * Assignment operator
     */
    inline T_MsgConversationDetailListItem& operator = (const T_MsgConversationDetailListItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_MsgConversationDetailListItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_MsgConversationDetailListItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_MsgConversationDetailListItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_MsgConversationDetailListItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oMessageHandle"

    static const int kOMessageHandle = 0;

    /**
     * Clears the field "oMessageHandle".
     *
     * The field will be set to its default value. The hasOMessageHandle()
     * method will return false.
     */
    inline void clearOMessageHandle();

    /**
     * Checks whether the field "oMessageHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOMessageHandle()). Otherwise it will return false.
     */
    inline bool hasOMessageHandle () const;

    /**
     * Returns the value of the member "oMessageHandle".
     *
     * This is the globally unique ID for a particular message. The ID is unique across all currently connected devices and accounts. It is made up of the DeviceHandle, MsgHandleUpper and MsgHandleLower.
     *
     * @return The value of the field "oMessageHandle"
     */
    inline const ::most_Msg_fi_types::T_MsgMessageHandle& getOMessageHandle () const;

    /**
     * Retrieves the value of the field "oMessageHandle" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oMessageHandle".
     */
    inline ::most_Msg_fi_types::T_MsgMessageHandle& getOMessageHandleMutable ();

    /**
     * Sets the value of the member "oMessageHandle".
     *
     * This is the globally unique ID for a particular message. The ID is unique across all currently connected devices and accounts. It is made up of the DeviceHandle, MsgHandleUpper and MsgHandleLower.
     *
     * @param oMessageHandle The value which will be set
     */
    inline void setOMessageHandle (const ::most_Msg_fi_types::T_MsgMessageHandle& oMessageHandle_);

    // API of field "oMessageDateTime"

    static const int kOMessageDateTime = 1;

    /**
     * Clears the field "oMessageDateTime".
     *
     * The field will be set to its default value. The hasOMessageDateTime()
     * method will return false.
     */
    inline void clearOMessageDateTime();

    /**
     * Checks whether the field "oMessageDateTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOMessageDateTime()). Otherwise it will return false.
     */
    inline bool hasOMessageDateTime () const;

    /**
     * Returns the value of the member "oMessageDateTime".
     *
     * The message date and time formatted as YYYYMMDDHHMMSS. The MessageDateTime is made up of the MessageDate stream and the MessageTime stream.
     *
     * @return The value of the field "oMessageDateTime"
     */
    inline const ::most_Msg_fi_types::T_MsgMessageDateTime& getOMessageDateTime () const;

    /**
     * Retrieves the value of the field "oMessageDateTime" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oMessageDateTime".
     */
    inline ::most_Msg_fi_types::T_MsgMessageDateTime& getOMessageDateTimeMutable ();

    /**
     * Sets the value of the member "oMessageDateTime".
     *
     * The message date and time formatted as YYYYMMDDHHMMSS. The MessageDateTime is made up of the MessageDate stream and the MessageTime stream.
     *
     * @param oMessageDateTime The value which will be set
     */
    inline void setOMessageDateTime (const ::most_Msg_fi_types::T_MsgMessageDateTime& oMessageDateTime_);

    // API of field "sMessageContent"

    static const int kSMessageContent = 2;

    /**
     * Clears the field "sMessageContent".
     *
     * The field will be set to its default value. The hasSMessageContent()
     * method will return false.
     */
    inline void clearSMessageContent();

    /**
     * Checks whether the field "sMessageContent" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSMessageContent()). Otherwise it will return false.
     */
    inline bool hasSMessageContent () const;

    /**
     * Returns the value of the member "sMessageContent".
     *
     * Provides the content of the message. It is limited to 1000 characters
     *
     * @return The value of the field "sMessageContent"
     */
    inline const ::fi_basetypes_most::T_String& getSMessageContent () const;

    /**
     * Retrieves the value of the field "sMessageContent" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sMessageContent".
     */
    inline ::fi_basetypes_most::T_String& getSMessageContentMutable ();

    /**
     * Sets the value of the member "sMessageContent".
     *
     * Provides the content of the message. It is limited to 1000 characters
     *
     * @param sMessageContent The value which will be set
     */
    inline void setSMessageContent (const ::fi_basetypes_most::T_String& sMessageContent_);

    // API of field "u32AttachmentSize"

    static const int kU32AttachmentSize = 3;

    /**
     * Clears the field "u32AttachmentSize".
     *
     * The field will be set to its default value. The hasU32AttachmentSize()
     * method will return false.
     */
    inline void clearU32AttachmentSize();

    /**
     * Checks whether the field "u32AttachmentSize" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32AttachmentSize()). Otherwise it will return false.
     */
    inline bool hasU32AttachmentSize () const;

    /**
     * Returns the value of the member "u32AttachmentSize".
     *
     * Provides the size of the attachments received in the message in bytes. If there are no attachments then size will be zero.
     *
     * @return The value of the field "u32AttachmentSize"
     */
    inline uint32 getU32AttachmentSize () const;

    /**
     * Sets the value of the member "u32AttachmentSize".
     *
     * Provides the size of the attachments received in the message in bytes. If there are no attachments then size will be zero.
     *
     * @param u32AttachmentSize The value which will be set
     */
    inline void setU32AttachmentSize (uint32 u32AttachmentSize_);

    // API of field "e8MessageType"

    static const int kE8MessageType = 4;

    /**
     * Clears the field "e8MessageType".
     *
     * The field will be set to its default value. The hasE8MessageType()
     * method will return false.
     */
    inline void clearE8MessageType();

    /**
     * Checks whether the field "e8MessageType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MessageType()). Otherwise it will return false.
     */
    inline bool hasE8MessageType () const;

    /**
     * Returns the value of the member "e8MessageType".
     *
     * Identifies the type of message: SMS, MMS, or Email.
     *
     * @return The value of the field "e8MessageType"
     */
    inline ::most_Msg_fi_types::T_e8_MsgMessageType getE8MessageType () const;

    /**
     * Sets the value of the member "e8MessageType".
     *
     * Identifies the type of message: SMS, MMS, or Email.
     *
     * @param e8MessageType The value which will be set
     */
    inline void setE8MessageType (::most_Msg_fi_types::T_e8_MsgMessageType e8MessageType_);

    // API of field "e8MessageStatus"

    static const int kE8MessageStatus = 5;

    /**
     * Clears the field "e8MessageStatus".
     *
     * The field will be set to its default value. The hasE8MessageStatus()
     * method will return false.
     */
    inline void clearE8MessageStatus();

    /**
     * Checks whether the field "e8MessageStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MessageStatus()). Otherwise it will return false.
     */
    inline bool hasE8MessageStatus () const;

    /**
     * Returns the value of the member "e8MessageStatus".
     *
     * This field indicates the message status of the received message in the Inbox folder and sent message in the Sent folder.
     *
     * @return The value of the field "e8MessageStatus"
     */
    inline T_e8_MsgMessageStatus getE8MessageStatus () const;

    /**
     * Sets the value of the member "e8MessageStatus".
     *
     * This field indicates the message status of the received message in the Inbox folder and sent message in the Sent folder.
     *
     * @param e8MessageStatus The value which will be set
     */
    inline void setE8MessageStatus (T_e8_MsgMessageStatus e8MessageStatus_);

    // API of field "bReadStatusFlag"

    static const int kBReadStatusFlag = 6;

    /**
     * Clears the field "bReadStatusFlag".
     *
     * The field will be set to its default value. The hasBReadStatusFlag()
     * method will return false.
     */
    inline void clearBReadStatusFlag();

    /**
     * Checks whether the field "bReadStatusFlag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBReadStatusFlag()). Otherwise it will return false.
     */
    inline bool hasBReadStatusFlag () const;

    /**
     * Returns the value of the member "bReadStatusFlag".
     *
     * Indicates whether the message has been read or not.
     *
     * @return The value of the field "bReadStatusFlag"
     */
    inline bool getBReadStatusFlag () const;

    /**
     * Sets the value of the member "bReadStatusFlag".
     *
     * Indicates whether the message has been read or not.
     *
     * @param bReadStatusFlag The value which will be set
     */
    inline void setBReadStatusFlag (bool bReadStatusFlag_);

    // API of field "oAddressField"

    static const int kOAddressField = 7;

    /**
     * Clears the field "oAddressField".
     *
     * The field will be set to its default value. The hasOAddressField()
     * method will return false.
     */
    inline void clearOAddressField();

    /**
     * Checks whether the field "oAddressField" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOAddressField()). Otherwise it will return false.
     */
    inline bool hasOAddressField () const;

    /**
     * Returns the value of the member "oAddressField".
     *
     * Provides the field type (From, To, CC) and the sender or recipient contact information.
     *
     * @return The value of the field "oAddressField"
     */
    inline const ::most_Msg_fi_types::T_MsgAddressFieldItem& getOAddressField () const;

    /**
     * Retrieves the value of the field "oAddressField" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oAddressField".
     */
    inline ::most_Msg_fi_types::T_MsgAddressFieldItem& getOAddressFieldMutable ();

    /**
     * Sets the value of the member "oAddressField".
     *
     * Provides the field type (From, To, CC) and the sender or recipient contact information.
     *
     * @param oAddressField The value which will be set
     */
    inline void setOAddressField (const ::most_Msg_fi_types::T_MsgAddressFieldItem& oAddressField_);

    // API of field "u32ContactHandle"

    static const int kU32ContactHandle = 8;

    /**
     * Clears the field "u32ContactHandle".
     *
     * The field will be set to its default value. The hasU32ContactHandle()
     * method will return false.
     */
    inline void clearU32ContactHandle();

    /**
     * Checks whether the field "u32ContactHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ContactHandle()). Otherwise it will return false.
     */
    inline bool hasU32ContactHandle () const;

    /**
     * Returns the value of the member "u32ContactHandle".
     *
     * This is the globally unique ID for a particular contact. The ID is unique across all currently connected devices.
     *
     * @return The value of the field "u32ContactHandle"
     */
    inline uint32 getU32ContactHandle () const;

    /**
     * Sets the value of the member "u32ContactHandle".
     *
     * This is the globally unique ID for a particular contact. The ID is unique across all currently connected devices.
     *
     * @param u32ContactHandle The value which will be set
     */
    inline void setU32ContactHandle (uint32 u32ContactHandle_);

    static const T_MsgConversationDetailListItem &getDefaultInstance();

private:

    inline void set_has_oMessageHandle ();

    inline void clear_has_oMessageHandle ();

    inline void set_has_oMessageDateTime ();

    inline void clear_has_oMessageDateTime ();

    inline void set_has_sMessageContent ();

    inline void clear_has_sMessageContent ();

    inline void set_has_u32AttachmentSize ();

    inline void clear_has_u32AttachmentSize ();

    inline void set_has_e8MessageType ();

    inline void clear_has_e8MessageType ();

    inline void set_has_e8MessageStatus ();

    inline void clear_has_e8MessageStatus ();

    inline void set_has_bReadStatusFlag ();

    inline void clear_has_bReadStatusFlag ();

    inline void set_has_oAddressField ();

    inline void clear_has_oAddressField ();

    inline void set_has_u32ContactHandle ();

    inline void clear_has_u32ContactHandle ();

    uint32 _has_bits_[ (9 + 31) / 32];

    ::most_Msg_fi_types::T_MsgMessageHandle _oMessageHandle;

    ::most_Msg_fi_types::T_MsgMessageDateTime _oMessageDateTime;

    ::fi_basetypes_most::T_String _sMessageContent;

    uint32 _u32AttachmentSize;

    ::most_Msg_fi_types::T_e8_MsgMessageType _e8MessageType;

    T_e8_MsgMessageStatus _e8MessageStatus;

    bool _bReadStatusFlag;

    ::most_Msg_fi_types::T_MsgAddressFieldItem _oAddressField;

    uint32 _u32ContactHandle;

};

class T_OnOffListItem {
public:

    /**
     * Default constructor
     */
    inline  T_OnOffListItem ();

    /**
     * Copy constructor
     */
    inline  T_OnOffListItem (const T_OnOffListItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_OnOffListItem (uint8 u8DeviceHandle_, bool bOnOffState_);

    /**
     * Destructor
     */
    inline  ~T_OnOffListItem();

    /**
     * Assignment operator
     */
    inline T_OnOffListItem& operator = (const T_OnOffListItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_OnOffListItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_OnOffListItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_OnOffListItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_OnOffListItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Unique handle for each paired device. The maximum value is project specific.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Unique handle for each paired device. The maximum value is project specific.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    // API of field "bOnOffState"

    static const int kBOnOffState = 1;

    /**
     * Clears the field "bOnOffState".
     *
     * The field will be set to its default value. The hasBOnOffState()
     * method will return false.
     */
    inline void clearBOnOffState();

    /**
     * Checks whether the field "bOnOffState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBOnOffState()). Otherwise it will return false.
     */
    inline bool hasBOnOffState () const;

    /**
     * Returns the value of the member "bOnOffState".
     *
     * Indicates whether particular MAP setting is ON/OFF for the given device handle
     *
     * @return The value of the field "bOnOffState"
     */
    inline bool getBOnOffState () const;

    /**
     * Sets the value of the member "bOnOffState".
     *
     * Indicates whether particular MAP setting is ON/OFF for the given device handle
     *
     * @param bOnOffState The value which will be set
     */
    inline void setBOnOffState (bool bOnOffState_);

    static const T_OnOffListItem &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    inline void set_has_bOnOffState ();

    inline void clear_has_bOnOffState ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8DeviceHandle;

    bool _bOnOffState;

};

class T_AutoReplyTextListItem {
public:

    /**
     * Default constructor
     */
    inline  T_AutoReplyTextListItem ();

    /**
     * Copy constructor
     */
    inline  T_AutoReplyTextListItem (const T_AutoReplyTextListItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_AutoReplyTextListItem (uint8 u8DeviceHandle_, uint16 u16PredefinedMsgHandle_);

    /**
     * Destructor
     */
    inline  ~T_AutoReplyTextListItem();

    /**
     * Assignment operator
     */
    inline T_AutoReplyTextListItem& operator = (const T_AutoReplyTextListItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_AutoReplyTextListItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_AutoReplyTextListItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_AutoReplyTextListItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_AutoReplyTextListItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of devices that could be paired. The maximum value is project specific.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of devices that could be paired. The maximum value is project specific.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    // API of field "u16PredefinedMsgHandle"

    static const int kU16PredefinedMsgHandle = 1;

    /**
     * Clears the field "u16PredefinedMsgHandle".
     *
     * The field will be set to its default value. The hasU16PredefinedMsgHandle()
     * method will return false.
     */
    inline void clearU16PredefinedMsgHandle();

    /**
     * Checks whether the field "u16PredefinedMsgHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16PredefinedMsgHandle()). Otherwise it will return false.
     */
    inline bool hasU16PredefinedMsgHandle () const;

    /**
     * Returns the value of the member "u16PredefinedMsgHandle".
     *
     * This is the unique ID for a particular predefined message text.
     *
     * @return The value of the field "u16PredefinedMsgHandle"
     */
    inline uint16 getU16PredefinedMsgHandle () const;

    /**
     * Sets the value of the member "u16PredefinedMsgHandle".
     *
     * This is the unique ID for a particular predefined message text.
     *
     * @param u16PredefinedMsgHandle The value which will be set
     */
    inline void setU16PredefinedMsgHandle (uint16 u16PredefinedMsgHandle_);

    static const T_AutoReplyTextListItem &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    inline void set_has_u16PredefinedMsgHandle ();

    inline void clear_has_u16PredefinedMsgHandle ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8DeviceHandle;

    uint16 _u16PredefinedMsgHandle;

};

class T_MapDeviceCapabilitiesListItem {
public:

    /**
     * Default constructor
     */
    inline  T_MapDeviceCapabilitiesListItem ();

    /**
     * Copy constructor
     */
    inline  T_MapDeviceCapabilitiesListItem (const T_MapDeviceCapabilitiesListItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_MapDeviceCapabilitiesListItem (uint8 u8DeviceHandle_, uint16 u16SupportedMessageTypes_, uint16 u16SupportedMapFeatures_, T_e8_MapConnectionStatus e8MapConnectionState_, const ::most_Msg_fi_types::T_MsgActiveAccount& oActiveAccount_);

    /**
     * Destructor
     */
    inline  ~T_MapDeviceCapabilitiesListItem();

    /**
     * Assignment operator
     */
    inline T_MapDeviceCapabilitiesListItem& operator = (const T_MapDeviceCapabilitiesListItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_MapDeviceCapabilitiesListItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_MapDeviceCapabilitiesListItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_MapDeviceCapabilitiesListItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_MapDeviceCapabilitiesListItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Unique handle for each paired device. The maximum value is project specific.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Unique handle for each paired device. The maximum value is project specific.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    // API of field "u16SupportedMessageTypes"

    static const int kU16SupportedMessageTypes = 1;

    /**
     * Clears the field "u16SupportedMessageTypes".
     *
     * The field will be set to its default value. The hasU16SupportedMessageTypes()
     * method will return false.
     */
    inline void clearU16SupportedMessageTypes();

    /**
     * Checks whether the field "u16SupportedMessageTypes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16SupportedMessageTypes()). Otherwise it will return false.
     */
    inline bool hasU16SupportedMessageTypes () const;

    /**
     * Returns the value of the member "u16SupportedMessageTypes".
     *
     * The Supported Message types indicate what all message types are supported like SMS, MMS, etc.
     *
     * @return The value of the field "u16SupportedMessageTypes"
     */
    inline uint16 getU16SupportedMessageTypes () const;

    /**
     * Sets the value of the member "u16SupportedMessageTypes".
     *
     * The Supported Message types indicate what all message types are supported like SMS, MMS, etc.
     *
     * @param u16SupportedMessageTypes The value which will be set
     */
    inline void setU16SupportedMessageTypes (uint16 u16SupportedMessageTypes_);

    // API of field "u16SupportedMapFeatures"

    static const int kU16SupportedMapFeatures = 2;

    /**
     * Clears the field "u16SupportedMapFeatures".
     *
     * The field will be set to its default value. The hasU16SupportedMapFeatures()
     * method will return false.
     */
    inline void clearU16SupportedMapFeatures();

    /**
     * Checks whether the field "u16SupportedMapFeatures" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16SupportedMapFeatures()). Otherwise it will return false.
     */
    inline bool hasU16SupportedMapFeatures () const;

    /**
     * Returns the value of the member "u16SupportedMapFeatures".
     *
     * The Supported MAP features indicate the MAP supported features in the connected device.
     *
     * @return The value of the field "u16SupportedMapFeatures"
     */
    inline uint16 getU16SupportedMapFeatures () const;

    /**
     * Sets the value of the member "u16SupportedMapFeatures".
     *
     * The Supported MAP features indicate the MAP supported features in the connected device.
     *
     * @param u16SupportedMapFeatures The value which will be set
     */
    inline void setU16SupportedMapFeatures (uint16 u16SupportedMapFeatures_);

    // API of field "e8MapConnectionState"

    static const int kE8MapConnectionState = 3;

    /**
     * Clears the field "e8MapConnectionState".
     *
     * The field will be set to its default value. The hasE8MapConnectionState()
     * method will return false.
     */
    inline void clearE8MapConnectionState();

    /**
     * Checks whether the field "e8MapConnectionState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MapConnectionState()). Otherwise it will return false.
     */
    inline bool hasE8MapConnectionState () const;

    /**
     * Returns the value of the member "e8MapConnectionState".
     *
     * Indicates the MAP connection status in the connection device.
     *
     * @return The value of the field "e8MapConnectionState"
     */
    inline T_e8_MapConnectionStatus getE8MapConnectionState () const;

    /**
     * Sets the value of the member "e8MapConnectionState".
     *
     * Indicates the MAP connection status in the connection device.
     *
     * @param e8MapConnectionState The value which will be set
     */
    inline void setE8MapConnectionState (T_e8_MapConnectionStatus e8MapConnectionState_);

    // API of field "oActiveAccount"

    static const int kOActiveAccount = 4;

    /**
     * Clears the field "oActiveAccount".
     *
     * The field will be set to its default value. The hasOActiveAccount()
     * method will return false.
     */
    inline void clearOActiveAccount();

    /**
     * Checks whether the field "oActiveAccount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOActiveAccount()). Otherwise it will return false.
     */
    inline bool hasOActiveAccount () const;

    /**
     * Returns the value of the member "oActiveAccount".
     *
     * Identifies the active email account.
     *
     * @return The value of the field "oActiveAccount"
     */
    inline const ::most_Msg_fi_types::T_MsgActiveAccount& getOActiveAccount () const;

    /**
     * Retrieves the value of the field "oActiveAccount" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oActiveAccount".
     */
    inline ::most_Msg_fi_types::T_MsgActiveAccount& getOActiveAccountMutable ();

    /**
     * Sets the value of the member "oActiveAccount".
     *
     * Identifies the active email account.
     *
     * @param oActiveAccount The value which will be set
     */
    inline void setOActiveAccount (const ::most_Msg_fi_types::T_MsgActiveAccount& oActiveAccount_);

    static const T_MapDeviceCapabilitiesListItem &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    inline void set_has_u16SupportedMessageTypes ();

    inline void clear_has_u16SupportedMessageTypes ();

    inline void set_has_u16SupportedMapFeatures ();

    inline void clear_has_u16SupportedMapFeatures ();

    inline void set_has_e8MapConnectionState ();

    inline void clear_has_e8MapConnectionState ();

    inline void set_has_oActiveAccount ();

    inline void clear_has_oActiveAccount ();

    uint32 _has_bits_[ (5 + 31) / 32];

    uint8 _u8DeviceHandle;

    uint16 _u16SupportedMessageTypes;

    uint16 _u16SupportedMapFeatures;

    T_e8_MapConnectionStatus _e8MapConnectionState;

    ::most_Msg_fi_types::T_MsgActiveAccount _oActiveAccount;

};

inline  T_MsgPredefinedMessageListExtendedResultItem::T_MsgPredefinedMessageListExtendedResultItem ()  :
    _u8DeviceHandle (0u),
    _u16PredefinedMessageHandle (0u),
    _e8PredefinedMessageType (::most_Msg_fi_types::T_e8_MsgPredefinedMessageType__e8PRE_MSG_STATIC),
    _e8PredefinedMessageCategory (::most_Msg_fi_types_Extended::T_e8_MsgPredefinedMessageCategory__e8PRE_MSG_CAT_USER_DEF),
    _e8PredefinedMessageSubCategory (::most_Msg_fi_types_Extended::T_e8_MsgPredefinedMessageSubCategory__e8NO_SUB_CATEGORY),
    _sPredefinedMessageText ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_MsgPredefinedMessageListExtendedResultItem::T_MsgPredefinedMessageListExtendedResultItem (const T_MsgPredefinedMessageListExtendedResultItem &rhs)  :
    _u8DeviceHandle (0u),
    _u16PredefinedMessageHandle (0u),
    _e8PredefinedMessageType (::most_Msg_fi_types::T_e8_MsgPredefinedMessageType__e8PRE_MSG_STATIC),
    _e8PredefinedMessageCategory (::most_Msg_fi_types_Extended::T_e8_MsgPredefinedMessageCategory__e8PRE_MSG_CAT_USER_DEF),
    _e8PredefinedMessageSubCategory (::most_Msg_fi_types_Extended::T_e8_MsgPredefinedMessageSubCategory__e8NO_SUB_CATEGORY),
    _sPredefinedMessageText ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_MsgPredefinedMessageListExtendedResultItem::T_MsgPredefinedMessageListExtendedResultItem (uint8 u8DeviceHandle_, uint16 u16PredefinedMessageHandle_, ::most_Msg_fi_types::T_e8_MsgPredefinedMessageType e8PredefinedMessageType_, T_e8_MsgPredefinedMessageCategory e8PredefinedMessageCategory_, T_e8_MsgPredefinedMessageSubCategory e8PredefinedMessageSubCategory_, const ::fi_basetypes_most::T_String& sPredefinedMessageText_)  :
    _u8DeviceHandle (u8DeviceHandle_),
    _u16PredefinedMessageHandle (u16PredefinedMessageHandle_),
    _e8PredefinedMessageType (e8PredefinedMessageType_),
    _e8PredefinedMessageCategory (e8PredefinedMessageCategory_),
    _e8PredefinedMessageSubCategory (e8PredefinedMessageSubCategory_),
    _sPredefinedMessageText (sPredefinedMessageText_)
{
    #ifndef NDEBUG
    if (!(::most_Msg_fi_types::T_e8_MsgPredefinedMessageType_IsValid(e8PredefinedMessageType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8PredefinedMessageType_, "T_e8_MsgPredefinedMessageType", "e8PredefinedMessageType", "T_MsgPredefinedMessageListExtendedResultItem");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_MsgPredefinedMessageCategory_IsValid(e8PredefinedMessageCategory_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8PredefinedMessageCategory_, "T_e8_MsgPredefinedMessageCategory", "e8PredefinedMessageCategory", "T_MsgPredefinedMessageListExtendedResultItem");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_MsgPredefinedMessageSubCategory_IsValid(e8PredefinedMessageSubCategory_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8PredefinedMessageSubCategory_, "T_e8_MsgPredefinedMessageSubCategory", "e8PredefinedMessageSubCategory", "T_MsgPredefinedMessageListExtendedResultItem");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sPredefinedMessageText_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_MsgPredefinedMessageListExtendedResultItem::~T_MsgPredefinedMessageListExtendedResultItem() {
}

inline T_MsgPredefinedMessageListExtendedResultItem& T_MsgPredefinedMessageListExtendedResultItem::operator = (const T_MsgPredefinedMessageListExtendedResultItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8DeviceHandle()) {
            setU8DeviceHandle(rhs.getU8DeviceHandle());
        } else {
            clearU8DeviceHandle();
        }
        if (rhs.hasU16PredefinedMessageHandle()) {
            setU16PredefinedMessageHandle(rhs.getU16PredefinedMessageHandle());
        } else {
            clearU16PredefinedMessageHandle();
        }
        if (rhs.hasE8PredefinedMessageType()) {
            setE8PredefinedMessageType(rhs.getE8PredefinedMessageType());
        } else {
            clearE8PredefinedMessageType();
        }
        if (rhs.hasE8PredefinedMessageCategory()) {
            setE8PredefinedMessageCategory(rhs.getE8PredefinedMessageCategory());
        } else {
            clearE8PredefinedMessageCategory();
        }
        if (rhs.hasE8PredefinedMessageSubCategory()) {
            setE8PredefinedMessageSubCategory(rhs.getE8PredefinedMessageSubCategory());
        } else {
            clearE8PredefinedMessageSubCategory();
        }
        if (rhs.hasSPredefinedMessageText()) {
            setSPredefinedMessageText(rhs.getSPredefinedMessageText());
        } else {
            clearSPredefinedMessageText();
        }
    }
    return *this;
}

inline bool T_MsgPredefinedMessageListExtendedResultItem::operator == (const T_MsgPredefinedMessageListExtendedResultItem& rhs) const {
    return (((!hasU8DeviceHandle() && !rhs.hasU8DeviceHandle()) || getU8DeviceHandle() == rhs.getU8DeviceHandle()) &&
        ((!hasU16PredefinedMessageHandle() && !rhs.hasU16PredefinedMessageHandle()) || getU16PredefinedMessageHandle() == rhs.getU16PredefinedMessageHandle()) &&
        ((!hasE8PredefinedMessageType() && !rhs.hasE8PredefinedMessageType()) || getE8PredefinedMessageType() == rhs.getE8PredefinedMessageType()) &&
        ((!hasE8PredefinedMessageCategory() && !rhs.hasE8PredefinedMessageCategory()) || getE8PredefinedMessageCategory() == rhs.getE8PredefinedMessageCategory()) &&
        ((!hasE8PredefinedMessageSubCategory() && !rhs.hasE8PredefinedMessageSubCategory()) || getE8PredefinedMessageSubCategory() == rhs.getE8PredefinedMessageSubCategory()) &&
        ((!hasSPredefinedMessageText() && !rhs.hasSPredefinedMessageText()) || getSPredefinedMessageText() == rhs.getSPredefinedMessageText()));
}

inline bool T_MsgPredefinedMessageListExtendedResultItem::operator != (const T_MsgPredefinedMessageListExtendedResultItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_MsgPredefinedMessageListExtendedResultItem::operator < (const T_MsgPredefinedMessageListExtendedResultItem& rhs) const {
    if (hasU8DeviceHandle() || rhs.hasU8DeviceHandle()) {
        if (getU8DeviceHandle() < rhs.getU8DeviceHandle()) return true;
        if (getU8DeviceHandle() > rhs.getU8DeviceHandle()) return false;
    }
    if (hasU16PredefinedMessageHandle() || rhs.hasU16PredefinedMessageHandle()) {
        if (getU16PredefinedMessageHandle() < rhs.getU16PredefinedMessageHandle()) return true;
        if (getU16PredefinedMessageHandle() > rhs.getU16PredefinedMessageHandle()) return false;
    }
    if (hasE8PredefinedMessageType() || rhs.hasE8PredefinedMessageType()) {
        if ((uint32)getE8PredefinedMessageType() < (uint32)rhs.getE8PredefinedMessageType()) return true;
        if ((uint32)getE8PredefinedMessageType() > (uint32)rhs.getE8PredefinedMessageType()) return false;
    }
    if (hasE8PredefinedMessageCategory() || rhs.hasE8PredefinedMessageCategory()) {
        if ((uint32)getE8PredefinedMessageCategory() < (uint32)rhs.getE8PredefinedMessageCategory()) return true;
        if ((uint32)getE8PredefinedMessageCategory() > (uint32)rhs.getE8PredefinedMessageCategory()) return false;
    }
    if (hasE8PredefinedMessageSubCategory() || rhs.hasE8PredefinedMessageSubCategory()) {
        if ((uint32)getE8PredefinedMessageSubCategory() < (uint32)rhs.getE8PredefinedMessageSubCategory()) return true;
        if ((uint32)getE8PredefinedMessageSubCategory() > (uint32)rhs.getE8PredefinedMessageSubCategory()) return false;
    }
    if (hasSPredefinedMessageText() || rhs.hasSPredefinedMessageText()) {
        if (getSPredefinedMessageText() < rhs.getSPredefinedMessageText()) return true;
        if (getSPredefinedMessageText() > rhs.getSPredefinedMessageText()) return false;
    }
    return false;
}

inline bool T_MsgPredefinedMessageListExtendedResultItem::operator > (const T_MsgPredefinedMessageListExtendedResultItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_MsgPredefinedMessageListExtendedResultItem::clear() {
    clearU8DeviceHandle();
    clearU16PredefinedMessageHandle();
    clearE8PredefinedMessageType();
    clearE8PredefinedMessageCategory();
    clearE8PredefinedMessageSubCategory();
    clearSPredefinedMessageText();
}

inline void T_MsgPredefinedMessageListExtendedResultItem::clearU8DeviceHandle() {
    if (hasU8DeviceHandle()) {
         clear_has_u8DeviceHandle();
        _u8DeviceHandle = 0u;
     }
}

inline bool T_MsgPredefinedMessageListExtendedResultItem::hasU8DeviceHandle () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_MsgPredefinedMessageListExtendedResultItem::getU8DeviceHandle () const {
    return _u8DeviceHandle;
}

inline void T_MsgPredefinedMessageListExtendedResultItem::setU8DeviceHandle (uint8 u8DeviceHandle_) {
    set_has_u8DeviceHandle();
    this->_u8DeviceHandle = u8DeviceHandle_;
}

inline void T_MsgPredefinedMessageListExtendedResultItem::clearU16PredefinedMessageHandle() {
    if (hasU16PredefinedMessageHandle()) {
         clear_has_u16PredefinedMessageHandle();
        _u16PredefinedMessageHandle = 0u;
     }
}

inline bool T_MsgPredefinedMessageListExtendedResultItem::hasU16PredefinedMessageHandle () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 T_MsgPredefinedMessageListExtendedResultItem::getU16PredefinedMessageHandle () const {
    return _u16PredefinedMessageHandle;
}

inline void T_MsgPredefinedMessageListExtendedResultItem::setU16PredefinedMessageHandle (uint16 u16PredefinedMessageHandle_) {
    set_has_u16PredefinedMessageHandle();
    this->_u16PredefinedMessageHandle = u16PredefinedMessageHandle_;
}

inline void T_MsgPredefinedMessageListExtendedResultItem::clearE8PredefinedMessageType() {
    if (hasE8PredefinedMessageType()) {
         clear_has_e8PredefinedMessageType();
        _e8PredefinedMessageType = ::most_Msg_fi_types::T_e8_MsgPredefinedMessageType__e8PRE_MSG_STATIC;
     }
}

inline bool T_MsgPredefinedMessageListExtendedResultItem::hasE8PredefinedMessageType () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline ::most_Msg_fi_types::T_e8_MsgPredefinedMessageType T_MsgPredefinedMessageListExtendedResultItem::getE8PredefinedMessageType () const {
    return _e8PredefinedMessageType;
}

inline void T_MsgPredefinedMessageListExtendedResultItem::setE8PredefinedMessageType (::most_Msg_fi_types::T_e8_MsgPredefinedMessageType e8PredefinedMessageType_) {
    #ifndef NDEBUG
    if (!(::most_Msg_fi_types::T_e8_MsgPredefinedMessageType_IsValid(e8PredefinedMessageType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8PredefinedMessageType_, "T_e8_MsgPredefinedMessageType", "e8PredefinedMessageType", "T_MsgPredefinedMessageListExtendedResultItem");
    }
    #endif
    set_has_e8PredefinedMessageType();
    this->_e8PredefinedMessageType = e8PredefinedMessageType_;
}

inline void T_MsgPredefinedMessageListExtendedResultItem::clearE8PredefinedMessageCategory() {
    if (hasE8PredefinedMessageCategory()) {
         clear_has_e8PredefinedMessageCategory();
        _e8PredefinedMessageCategory = ::most_Msg_fi_types_Extended::T_e8_MsgPredefinedMessageCategory__e8PRE_MSG_CAT_USER_DEF;
     }
}

inline bool T_MsgPredefinedMessageListExtendedResultItem::hasE8PredefinedMessageCategory () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline T_e8_MsgPredefinedMessageCategory T_MsgPredefinedMessageListExtendedResultItem::getE8PredefinedMessageCategory () const {
    return _e8PredefinedMessageCategory;
}

inline void T_MsgPredefinedMessageListExtendedResultItem::setE8PredefinedMessageCategory (T_e8_MsgPredefinedMessageCategory e8PredefinedMessageCategory_) {
    #ifndef NDEBUG
    if (!(T_e8_MsgPredefinedMessageCategory_IsValid(e8PredefinedMessageCategory_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8PredefinedMessageCategory_, "T_e8_MsgPredefinedMessageCategory", "e8PredefinedMessageCategory", "T_MsgPredefinedMessageListExtendedResultItem");
    }
    #endif
    set_has_e8PredefinedMessageCategory();
    this->_e8PredefinedMessageCategory = e8PredefinedMessageCategory_;
}

inline void T_MsgPredefinedMessageListExtendedResultItem::clearE8PredefinedMessageSubCategory() {
    if (hasE8PredefinedMessageSubCategory()) {
         clear_has_e8PredefinedMessageSubCategory();
        _e8PredefinedMessageSubCategory = ::most_Msg_fi_types_Extended::T_e8_MsgPredefinedMessageSubCategory__e8NO_SUB_CATEGORY;
     }
}

inline bool T_MsgPredefinedMessageListExtendedResultItem::hasE8PredefinedMessageSubCategory () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline T_e8_MsgPredefinedMessageSubCategory T_MsgPredefinedMessageListExtendedResultItem::getE8PredefinedMessageSubCategory () const {
    return _e8PredefinedMessageSubCategory;
}

inline void T_MsgPredefinedMessageListExtendedResultItem::setE8PredefinedMessageSubCategory (T_e8_MsgPredefinedMessageSubCategory e8PredefinedMessageSubCategory_) {
    #ifndef NDEBUG
    if (!(T_e8_MsgPredefinedMessageSubCategory_IsValid(e8PredefinedMessageSubCategory_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8PredefinedMessageSubCategory_, "T_e8_MsgPredefinedMessageSubCategory", "e8PredefinedMessageSubCategory", "T_MsgPredefinedMessageListExtendedResultItem");
    }
    #endif
    set_has_e8PredefinedMessageSubCategory();
    this->_e8PredefinedMessageSubCategory = e8PredefinedMessageSubCategory_;
}

inline void T_MsgPredefinedMessageListExtendedResultItem::clearSPredefinedMessageText() {
    if (hasSPredefinedMessageText()) {
         clear_has_sPredefinedMessageText();
        _sPredefinedMessageText.clear();
     }
}

inline bool T_MsgPredefinedMessageListExtendedResultItem::hasSPredefinedMessageText () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_MsgPredefinedMessageListExtendedResultItem::getSPredefinedMessageText () const {
    return _sPredefinedMessageText;
}

inline ::fi_basetypes_most::T_String& T_MsgPredefinedMessageListExtendedResultItem::getSPredefinedMessageTextMutable () {
    set_has_sPredefinedMessageText();
    return _sPredefinedMessageText;
}

inline void T_MsgPredefinedMessageListExtendedResultItem::setSPredefinedMessageText (const ::fi_basetypes_most::T_String& sPredefinedMessageText_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sPredefinedMessageText_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sPredefinedMessageText();
    this->_sPredefinedMessageText = sPredefinedMessageText_;
}

inline void T_MsgPredefinedMessageListExtendedResultItem::set_has_u8DeviceHandle () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_MsgPredefinedMessageListExtendedResultItem::clear_has_u8DeviceHandle () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_MsgPredefinedMessageListExtendedResultItem::set_has_u16PredefinedMessageHandle () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_MsgPredefinedMessageListExtendedResultItem::clear_has_u16PredefinedMessageHandle () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_MsgPredefinedMessageListExtendedResultItem::set_has_e8PredefinedMessageType () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_MsgPredefinedMessageListExtendedResultItem::clear_has_e8PredefinedMessageType () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_MsgPredefinedMessageListExtendedResultItem::set_has_e8PredefinedMessageCategory () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_MsgPredefinedMessageListExtendedResultItem::clear_has_e8PredefinedMessageCategory () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_MsgPredefinedMessageListExtendedResultItem::set_has_e8PredefinedMessageSubCategory () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_MsgPredefinedMessageListExtendedResultItem::clear_has_e8PredefinedMessageSubCategory () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_MsgPredefinedMessageListExtendedResultItem::set_has_sPredefinedMessageText () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_MsgPredefinedMessageListExtendedResultItem::clear_has_sPredefinedMessageText () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline  T_SignatureTextStreamItem::T_SignatureTextStreamItem ()  :
    _u8DeviceHandle (0u),
    _bSignatureOnOff (false),
    _sSignatureText ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SignatureTextStreamItem::T_SignatureTextStreamItem (const T_SignatureTextStreamItem &rhs)  :
    _u8DeviceHandle (0u),
    _bSignatureOnOff (false),
    _sSignatureText ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SignatureTextStreamItem::T_SignatureTextStreamItem (uint8 u8DeviceHandle_, bool bSignatureOnOff_, const ::fi_basetypes_most::T_String& sSignatureText_)  :
    _u8DeviceHandle (u8DeviceHandle_),
    _bSignatureOnOff (bSignatureOnOff_),
    _sSignatureText (sSignatureText_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sSignatureText_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SignatureTextStreamItem::~T_SignatureTextStreamItem() {
}

inline T_SignatureTextStreamItem& T_SignatureTextStreamItem::operator = (const T_SignatureTextStreamItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8DeviceHandle()) {
            setU8DeviceHandle(rhs.getU8DeviceHandle());
        } else {
            clearU8DeviceHandle();
        }
        if (rhs.hasBSignatureOnOff()) {
            setBSignatureOnOff(rhs.getBSignatureOnOff());
        } else {
            clearBSignatureOnOff();
        }
        if (rhs.hasSSignatureText()) {
            setSSignatureText(rhs.getSSignatureText());
        } else {
            clearSSignatureText();
        }
    }
    return *this;
}

inline bool T_SignatureTextStreamItem::operator == (const T_SignatureTextStreamItem& rhs) const {
    return (((!hasU8DeviceHandle() && !rhs.hasU8DeviceHandle()) || getU8DeviceHandle() == rhs.getU8DeviceHandle()) &&
        ((!hasBSignatureOnOff() && !rhs.hasBSignatureOnOff()) || getBSignatureOnOff() == rhs.getBSignatureOnOff()) &&
        ((!hasSSignatureText() && !rhs.hasSSignatureText()) || getSSignatureText() == rhs.getSSignatureText()));
}

inline bool T_SignatureTextStreamItem::operator != (const T_SignatureTextStreamItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SignatureTextStreamItem::operator < (const T_SignatureTextStreamItem& rhs) const {
    if (hasU8DeviceHandle() || rhs.hasU8DeviceHandle()) {
        if (getU8DeviceHandle() < rhs.getU8DeviceHandle()) return true;
        if (getU8DeviceHandle() > rhs.getU8DeviceHandle()) return false;
    }
    if (hasBSignatureOnOff() || rhs.hasBSignatureOnOff()) {
        if (getBSignatureOnOff() < rhs.getBSignatureOnOff()) return true;
        if (getBSignatureOnOff() > rhs.getBSignatureOnOff()) return false;
    }
    if (hasSSignatureText() || rhs.hasSSignatureText()) {
        if (getSSignatureText() < rhs.getSSignatureText()) return true;
        if (getSSignatureText() > rhs.getSSignatureText()) return false;
    }
    return false;
}

inline bool T_SignatureTextStreamItem::operator > (const T_SignatureTextStreamItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SignatureTextStreamItem::clear() {
    clearU8DeviceHandle();
    clearBSignatureOnOff();
    clearSSignatureText();
}

inline void T_SignatureTextStreamItem::clearU8DeviceHandle() {
    if (hasU8DeviceHandle()) {
         clear_has_u8DeviceHandle();
        _u8DeviceHandle = 0u;
     }
}

inline bool T_SignatureTextStreamItem::hasU8DeviceHandle () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_SignatureTextStreamItem::getU8DeviceHandle () const {
    return _u8DeviceHandle;
}

inline void T_SignatureTextStreamItem::setU8DeviceHandle (uint8 u8DeviceHandle_) {
    set_has_u8DeviceHandle();
    this->_u8DeviceHandle = u8DeviceHandle_;
}

inline void T_SignatureTextStreamItem::clearBSignatureOnOff() {
    if (hasBSignatureOnOff()) {
         clear_has_bSignatureOnOff();
        _bSignatureOnOff = false;
     }
}

inline bool T_SignatureTextStreamItem::hasBSignatureOnOff () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool T_SignatureTextStreamItem::getBSignatureOnOff () const {
    return _bSignatureOnOff;
}

inline void T_SignatureTextStreamItem::setBSignatureOnOff (bool bSignatureOnOff_) {
    set_has_bSignatureOnOff();
    this->_bSignatureOnOff = bSignatureOnOff_;
}

inline void T_SignatureTextStreamItem::clearSSignatureText() {
    if (hasSSignatureText()) {
         clear_has_sSignatureText();
        _sSignatureText.clear();
     }
}

inline bool T_SignatureTextStreamItem::hasSSignatureText () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_SignatureTextStreamItem::getSSignatureText () const {
    return _sSignatureText;
}

inline ::fi_basetypes_most::T_String& T_SignatureTextStreamItem::getSSignatureTextMutable () {
    set_has_sSignatureText();
    return _sSignatureText;
}

inline void T_SignatureTextStreamItem::setSSignatureText (const ::fi_basetypes_most::T_String& sSignatureText_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sSignatureText_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sSignatureText();
    this->_sSignatureText = sSignatureText_;
}

inline void T_SignatureTextStreamItem::set_has_u8DeviceHandle () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SignatureTextStreamItem::clear_has_u8DeviceHandle () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SignatureTextStreamItem::set_has_bSignatureOnOff () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SignatureTextStreamItem::clear_has_bSignatureOnOff () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_SignatureTextStreamItem::set_has_sSignatureText () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_SignatureTextStreamItem::clear_has_sSignatureText () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_MsgConversationHandle::T_MsgConversationHandle ()  :
    _u8DeviceHandle (0u),
    _u32ConversationID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_MsgConversationHandle::T_MsgConversationHandle (const T_MsgConversationHandle &rhs)  :
    _u8DeviceHandle (0u),
    _u32ConversationID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_MsgConversationHandle::T_MsgConversationHandle (uint8 u8DeviceHandle_, uint32 u32ConversationID_)  :
    _u8DeviceHandle (u8DeviceHandle_),
    _u32ConversationID (u32ConversationID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_MsgConversationHandle::~T_MsgConversationHandle() {
}

inline T_MsgConversationHandle& T_MsgConversationHandle::operator = (const T_MsgConversationHandle& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8DeviceHandle()) {
            setU8DeviceHandle(rhs.getU8DeviceHandle());
        } else {
            clearU8DeviceHandle();
        }
        if (rhs.hasU32ConversationID()) {
            setU32ConversationID(rhs.getU32ConversationID());
        } else {
            clearU32ConversationID();
        }
    }
    return *this;
}

inline bool T_MsgConversationHandle::operator == (const T_MsgConversationHandle& rhs) const {
    return (((!hasU8DeviceHandle() && !rhs.hasU8DeviceHandle()) || getU8DeviceHandle() == rhs.getU8DeviceHandle()) &&
        ((!hasU32ConversationID() && !rhs.hasU32ConversationID()) || getU32ConversationID() == rhs.getU32ConversationID()));
}

inline bool T_MsgConversationHandle::operator != (const T_MsgConversationHandle& rhs) const {
    return ! (*this == rhs);
}

inline bool T_MsgConversationHandle::operator < (const T_MsgConversationHandle& rhs) const {
    if (hasU8DeviceHandle() || rhs.hasU8DeviceHandle()) {
        if (getU8DeviceHandle() < rhs.getU8DeviceHandle()) return true;
        if (getU8DeviceHandle() > rhs.getU8DeviceHandle()) return false;
    }
    if (hasU32ConversationID() || rhs.hasU32ConversationID()) {
        if (getU32ConversationID() < rhs.getU32ConversationID()) return true;
        if (getU32ConversationID() > rhs.getU32ConversationID()) return false;
    }
    return false;
}

inline bool T_MsgConversationHandle::operator > (const T_MsgConversationHandle& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_MsgConversationHandle::clear() {
    clearU8DeviceHandle();
    clearU32ConversationID();
}

inline void T_MsgConversationHandle::clearU8DeviceHandle() {
    if (hasU8DeviceHandle()) {
         clear_has_u8DeviceHandle();
        _u8DeviceHandle = 0u;
     }
}

inline bool T_MsgConversationHandle::hasU8DeviceHandle () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_MsgConversationHandle::getU8DeviceHandle () const {
    return _u8DeviceHandle;
}

inline void T_MsgConversationHandle::setU8DeviceHandle (uint8 u8DeviceHandle_) {
    set_has_u8DeviceHandle();
    this->_u8DeviceHandle = u8DeviceHandle_;
}

inline void T_MsgConversationHandle::clearU32ConversationID() {
    if (hasU32ConversationID()) {
         clear_has_u32ConversationID();
        _u32ConversationID = 0u;
     }
}

inline bool T_MsgConversationHandle::hasU32ConversationID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 T_MsgConversationHandle::getU32ConversationID () const {
    return _u32ConversationID;
}

inline void T_MsgConversationHandle::setU32ConversationID (uint32 u32ConversationID_) {
    set_has_u32ConversationID();
    this->_u32ConversationID = u32ConversationID_;
}

inline void T_MsgConversationHandle::set_has_u8DeviceHandle () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_MsgConversationHandle::clear_has_u8DeviceHandle () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_MsgConversationHandle::set_has_u32ConversationID () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_MsgConversationHandle::clear_has_u32ConversationID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_MsgConversationListSliceResultItem::T_MsgConversationListSliceResultItem ()  :
    _oConversationHandle (),
    _oLastActivity (),
    _sSubject (),
    _u32AttachmentSize (0u),
    _e8MessageType (::most_Msg_fi_types::T_e8_MsgMessageType__e8MSG_TYPE_SMS),
    _u32NumberOfMessages (0u),
    _u8UnreadMessageCount (0u),
    _oAddressField (),
    _u32ContactHandle (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_MsgConversationListSliceResultItem::T_MsgConversationListSliceResultItem (const T_MsgConversationListSliceResultItem &rhs)  :
    _oConversationHandle (),
    _oLastActivity (),
    _sSubject (),
    _u32AttachmentSize (0u),
    _e8MessageType (::most_Msg_fi_types::T_e8_MsgMessageType__e8MSG_TYPE_SMS),
    _u32NumberOfMessages (0u),
    _u8UnreadMessageCount (0u),
    _oAddressField (),
    _u32ContactHandle (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_MsgConversationListSliceResultItem::T_MsgConversationListSliceResultItem (const T_MsgConversationHandle& oConversationHandle_, const ::most_Msg_fi_types::T_MsgMessageDateTime& oLastActivity_, const ::fi_basetypes_most::T_String& sSubject_, uint32 u32AttachmentSize_, ::most_Msg_fi_types::T_e8_MsgMessageType e8MessageType_, uint32 u32NumberOfMessages_, uint8 u8UnreadMessageCount_, const ::most_Msg_fi_types::T_MsgAddressFieldItem& oAddressField_, uint32 u32ContactHandle_)  :
    _oConversationHandle (oConversationHandle_),
    _oLastActivity (oLastActivity_),
    _sSubject (sSubject_),
    _u32AttachmentSize (u32AttachmentSize_),
    _e8MessageType (e8MessageType_),
    _u32NumberOfMessages (u32NumberOfMessages_),
    _u8UnreadMessageCount (u8UnreadMessageCount_),
    _oAddressField (oAddressField_),
    _u32ContactHandle (u32ContactHandle_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sSubject_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(::most_Msg_fi_types::T_e8_MsgMessageType_IsValid(e8MessageType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8MessageType_, "T_e8_MsgMessageType", "e8MessageType", "T_MsgConversationListSliceResultItem");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_MsgConversationListSliceResultItem::~T_MsgConversationListSliceResultItem() {
}

inline T_MsgConversationListSliceResultItem& T_MsgConversationListSliceResultItem::operator = (const T_MsgConversationListSliceResultItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasOConversationHandle()) {
            setOConversationHandle(rhs.getOConversationHandle());
        } else {
            clearOConversationHandle();
        }
        if (rhs.hasOLastActivity()) {
            setOLastActivity(rhs.getOLastActivity());
        } else {
            clearOLastActivity();
        }
        if (rhs.hasSSubject()) {
            setSSubject(rhs.getSSubject());
        } else {
            clearSSubject();
        }
        if (rhs.hasU32AttachmentSize()) {
            setU32AttachmentSize(rhs.getU32AttachmentSize());
        } else {
            clearU32AttachmentSize();
        }
        if (rhs.hasE8MessageType()) {
            setE8MessageType(rhs.getE8MessageType());
        } else {
            clearE8MessageType();
        }
        if (rhs.hasU32NumberOfMessages()) {
            setU32NumberOfMessages(rhs.getU32NumberOfMessages());
        } else {
            clearU32NumberOfMessages();
        }
        if (rhs.hasU8UnreadMessageCount()) {
            setU8UnreadMessageCount(rhs.getU8UnreadMessageCount());
        } else {
            clearU8UnreadMessageCount();
        }
        if (rhs.hasOAddressField()) {
            setOAddressField(rhs.getOAddressField());
        } else {
            clearOAddressField();
        }
        if (rhs.hasU32ContactHandle()) {
            setU32ContactHandle(rhs.getU32ContactHandle());
        } else {
            clearU32ContactHandle();
        }
    }
    return *this;
}

inline bool T_MsgConversationListSliceResultItem::operator == (const T_MsgConversationListSliceResultItem& rhs) const {
    return (((!hasOConversationHandle() && !rhs.hasOConversationHandle()) || getOConversationHandle() == rhs.getOConversationHandle()) &&
        ((!hasOLastActivity() && !rhs.hasOLastActivity()) || getOLastActivity() == rhs.getOLastActivity()) &&
        ((!hasSSubject() && !rhs.hasSSubject()) || getSSubject() == rhs.getSSubject()) &&
        ((!hasU32AttachmentSize() && !rhs.hasU32AttachmentSize()) || getU32AttachmentSize() == rhs.getU32AttachmentSize()) &&
        ((!hasE8MessageType() && !rhs.hasE8MessageType()) || getE8MessageType() == rhs.getE8MessageType()) &&
        ((!hasU32NumberOfMessages() && !rhs.hasU32NumberOfMessages()) || getU32NumberOfMessages() == rhs.getU32NumberOfMessages()) &&
        ((!hasU8UnreadMessageCount() && !rhs.hasU8UnreadMessageCount()) || getU8UnreadMessageCount() == rhs.getU8UnreadMessageCount()) &&
        ((!hasOAddressField() && !rhs.hasOAddressField()) || getOAddressField() == rhs.getOAddressField()) &&
        ((!hasU32ContactHandle() && !rhs.hasU32ContactHandle()) || getU32ContactHandle() == rhs.getU32ContactHandle()));
}

inline bool T_MsgConversationListSliceResultItem::operator != (const T_MsgConversationListSliceResultItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_MsgConversationListSliceResultItem::operator < (const T_MsgConversationListSliceResultItem& rhs) const {
    if (hasOConversationHandle() || rhs.hasOConversationHandle()) {
        if (getOConversationHandle() < rhs.getOConversationHandle()) return true;
        if (getOConversationHandle() > rhs.getOConversationHandle()) return false;
    }
    if (hasOLastActivity() || rhs.hasOLastActivity()) {
        if (getOLastActivity() < rhs.getOLastActivity()) return true;
        if (getOLastActivity() > rhs.getOLastActivity()) return false;
    }
    if (hasSSubject() || rhs.hasSSubject()) {
        if (getSSubject() < rhs.getSSubject()) return true;
        if (getSSubject() > rhs.getSSubject()) return false;
    }
    if (hasU32AttachmentSize() || rhs.hasU32AttachmentSize()) {
        if (getU32AttachmentSize() < rhs.getU32AttachmentSize()) return true;
        if (getU32AttachmentSize() > rhs.getU32AttachmentSize()) return false;
    }
    if (hasE8MessageType() || rhs.hasE8MessageType()) {
        if ((uint32)getE8MessageType() < (uint32)rhs.getE8MessageType()) return true;
        if ((uint32)getE8MessageType() > (uint32)rhs.getE8MessageType()) return false;
    }
    if (hasU32NumberOfMessages() || rhs.hasU32NumberOfMessages()) {
        if (getU32NumberOfMessages() < rhs.getU32NumberOfMessages()) return true;
        if (getU32NumberOfMessages() > rhs.getU32NumberOfMessages()) return false;
    }
    if (hasU8UnreadMessageCount() || rhs.hasU8UnreadMessageCount()) {
        if (getU8UnreadMessageCount() < rhs.getU8UnreadMessageCount()) return true;
        if (getU8UnreadMessageCount() > rhs.getU8UnreadMessageCount()) return false;
    }
    if (hasOAddressField() || rhs.hasOAddressField()) {
        if (getOAddressField() < rhs.getOAddressField()) return true;
        if (getOAddressField() > rhs.getOAddressField()) return false;
    }
    if (hasU32ContactHandle() || rhs.hasU32ContactHandle()) {
        if (getU32ContactHandle() < rhs.getU32ContactHandle()) return true;
        if (getU32ContactHandle() > rhs.getU32ContactHandle()) return false;
    }
    return false;
}

inline bool T_MsgConversationListSliceResultItem::operator > (const T_MsgConversationListSliceResultItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_MsgConversationListSliceResultItem::clear() {
    clearOConversationHandle();
    clearOLastActivity();
    clearSSubject();
    clearU32AttachmentSize();
    clearE8MessageType();
    clearU32NumberOfMessages();
    clearU8UnreadMessageCount();
    clearOAddressField();
    clearU32ContactHandle();
}

inline void T_MsgConversationListSliceResultItem::clearOConversationHandle() {
    if (hasOConversationHandle()) {
         clear_has_oConversationHandle();
        _oConversationHandle.clear();
     }
}

inline bool T_MsgConversationListSliceResultItem::hasOConversationHandle () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const T_MsgConversationHandle& T_MsgConversationListSliceResultItem::getOConversationHandle () const {
    return _oConversationHandle;
}

inline T_MsgConversationHandle& T_MsgConversationListSliceResultItem::getOConversationHandleMutable () {
    set_has_oConversationHandle();
    return _oConversationHandle;
}

inline void T_MsgConversationListSliceResultItem::setOConversationHandle (const T_MsgConversationHandle& oConversationHandle_) {
    set_has_oConversationHandle();
    this->_oConversationHandle = oConversationHandle_;
}

inline void T_MsgConversationListSliceResultItem::clearOLastActivity() {
    if (hasOLastActivity()) {
         clear_has_oLastActivity();
        _oLastActivity.clear();
     }
}

inline bool T_MsgConversationListSliceResultItem::hasOLastActivity () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::most_Msg_fi_types::T_MsgMessageDateTime& T_MsgConversationListSliceResultItem::getOLastActivity () const {
    return _oLastActivity;
}

inline ::most_Msg_fi_types::T_MsgMessageDateTime& T_MsgConversationListSliceResultItem::getOLastActivityMutable () {
    set_has_oLastActivity();
    return _oLastActivity;
}

inline void T_MsgConversationListSliceResultItem::setOLastActivity (const ::most_Msg_fi_types::T_MsgMessageDateTime& oLastActivity_) {
    set_has_oLastActivity();
    this->_oLastActivity = oLastActivity_;
}

inline void T_MsgConversationListSliceResultItem::clearSSubject() {
    if (hasSSubject()) {
         clear_has_sSubject();
        _sSubject.clear();
     }
}

inline bool T_MsgConversationListSliceResultItem::hasSSubject () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_MsgConversationListSliceResultItem::getSSubject () const {
    return _sSubject;
}

inline ::fi_basetypes_most::T_String& T_MsgConversationListSliceResultItem::getSSubjectMutable () {
    set_has_sSubject();
    return _sSubject;
}

inline void T_MsgConversationListSliceResultItem::setSSubject (const ::fi_basetypes_most::T_String& sSubject_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sSubject_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sSubject();
    this->_sSubject = sSubject_;
}

inline void T_MsgConversationListSliceResultItem::clearU32AttachmentSize() {
    if (hasU32AttachmentSize()) {
         clear_has_u32AttachmentSize();
        _u32AttachmentSize = 0u;
     }
}

inline bool T_MsgConversationListSliceResultItem::hasU32AttachmentSize () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 T_MsgConversationListSliceResultItem::getU32AttachmentSize () const {
    return _u32AttachmentSize;
}

inline void T_MsgConversationListSliceResultItem::setU32AttachmentSize (uint32 u32AttachmentSize_) {
    set_has_u32AttachmentSize();
    this->_u32AttachmentSize = u32AttachmentSize_;
}

inline void T_MsgConversationListSliceResultItem::clearE8MessageType() {
    if (hasE8MessageType()) {
         clear_has_e8MessageType();
        _e8MessageType = ::most_Msg_fi_types::T_e8_MsgMessageType__e8MSG_TYPE_SMS;
     }
}

inline bool T_MsgConversationListSliceResultItem::hasE8MessageType () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline ::most_Msg_fi_types::T_e8_MsgMessageType T_MsgConversationListSliceResultItem::getE8MessageType () const {
    return _e8MessageType;
}

inline void T_MsgConversationListSliceResultItem::setE8MessageType (::most_Msg_fi_types::T_e8_MsgMessageType e8MessageType_) {
    #ifndef NDEBUG
    if (!(::most_Msg_fi_types::T_e8_MsgMessageType_IsValid(e8MessageType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8MessageType_, "T_e8_MsgMessageType", "e8MessageType", "T_MsgConversationListSliceResultItem");
    }
    #endif
    set_has_e8MessageType();
    this->_e8MessageType = e8MessageType_;
}

inline void T_MsgConversationListSliceResultItem::clearU32NumberOfMessages() {
    if (hasU32NumberOfMessages()) {
         clear_has_u32NumberOfMessages();
        _u32NumberOfMessages = 0u;
     }
}

inline bool T_MsgConversationListSliceResultItem::hasU32NumberOfMessages () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint32 T_MsgConversationListSliceResultItem::getU32NumberOfMessages () const {
    return _u32NumberOfMessages;
}

inline void T_MsgConversationListSliceResultItem::setU32NumberOfMessages (uint32 u32NumberOfMessages_) {
    set_has_u32NumberOfMessages();
    this->_u32NumberOfMessages = u32NumberOfMessages_;
}

inline void T_MsgConversationListSliceResultItem::clearU8UnreadMessageCount() {
    if (hasU8UnreadMessageCount()) {
         clear_has_u8UnreadMessageCount();
        _u8UnreadMessageCount = 0u;
     }
}

inline bool T_MsgConversationListSliceResultItem::hasU8UnreadMessageCount () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint8 T_MsgConversationListSliceResultItem::getU8UnreadMessageCount () const {
    return _u8UnreadMessageCount;
}

inline void T_MsgConversationListSliceResultItem::setU8UnreadMessageCount (uint8 u8UnreadMessageCount_) {
    set_has_u8UnreadMessageCount();
    this->_u8UnreadMessageCount = u8UnreadMessageCount_;
}

inline void T_MsgConversationListSliceResultItem::clearOAddressField() {
    if (hasOAddressField()) {
         clear_has_oAddressField();
        _oAddressField.clear();
     }
}

inline bool T_MsgConversationListSliceResultItem::hasOAddressField () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline const ::most_Msg_fi_types::T_MsgAddressFieldItem& T_MsgConversationListSliceResultItem::getOAddressField () const {
    return _oAddressField;
}

inline ::most_Msg_fi_types::T_MsgAddressFieldItem& T_MsgConversationListSliceResultItem::getOAddressFieldMutable () {
    set_has_oAddressField();
    return _oAddressField;
}

inline void T_MsgConversationListSliceResultItem::setOAddressField (const ::most_Msg_fi_types::T_MsgAddressFieldItem& oAddressField_) {
    set_has_oAddressField();
    this->_oAddressField = oAddressField_;
}

inline void T_MsgConversationListSliceResultItem::clearU32ContactHandle() {
    if (hasU32ContactHandle()) {
         clear_has_u32ContactHandle();
        _u32ContactHandle = 0u;
     }
}

inline bool T_MsgConversationListSliceResultItem::hasU32ContactHandle () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline uint32 T_MsgConversationListSliceResultItem::getU32ContactHandle () const {
    return _u32ContactHandle;
}

inline void T_MsgConversationListSliceResultItem::setU32ContactHandle (uint32 u32ContactHandle_) {
    set_has_u32ContactHandle();
    this->_u32ContactHandle = u32ContactHandle_;
}

inline void T_MsgConversationListSliceResultItem::set_has_oConversationHandle () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_MsgConversationListSliceResultItem::clear_has_oConversationHandle () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_MsgConversationListSliceResultItem::set_has_oLastActivity () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_MsgConversationListSliceResultItem::clear_has_oLastActivity () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_MsgConversationListSliceResultItem::set_has_sSubject () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_MsgConversationListSliceResultItem::clear_has_sSubject () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_MsgConversationListSliceResultItem::set_has_u32AttachmentSize () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_MsgConversationListSliceResultItem::clear_has_u32AttachmentSize () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_MsgConversationListSliceResultItem::set_has_e8MessageType () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_MsgConversationListSliceResultItem::clear_has_e8MessageType () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_MsgConversationListSliceResultItem::set_has_u32NumberOfMessages () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_MsgConversationListSliceResultItem::clear_has_u32NumberOfMessages () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_MsgConversationListSliceResultItem::set_has_u8UnreadMessageCount () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_MsgConversationListSliceResultItem::clear_has_u8UnreadMessageCount () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_MsgConversationListSliceResultItem::set_has_oAddressField () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_MsgConversationListSliceResultItem::clear_has_oAddressField () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_MsgConversationListSliceResultItem::set_has_u32ContactHandle () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_MsgConversationListSliceResultItem::clear_has_u32ContactHandle () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline  T_MsgConversationDetailListItem::T_MsgConversationDetailListItem ()  :
    _oMessageHandle (),
    _oMessageDateTime (),
    _sMessageContent (),
    _u32AttachmentSize (0u),
    _e8MessageType (::most_Msg_fi_types::T_e8_MsgMessageType__e8MSG_TYPE_SMS),
    _e8MessageStatus (::most_Msg_fi_types_Extended::T_e8_MsgMessageStatus__e8DELIVERY_SUCCESS),
    _bReadStatusFlag (false),
    _oAddressField (),
    _u32ContactHandle (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_MsgConversationDetailListItem::T_MsgConversationDetailListItem (const T_MsgConversationDetailListItem &rhs)  :
    _oMessageHandle (),
    _oMessageDateTime (),
    _sMessageContent (),
    _u32AttachmentSize (0u),
    _e8MessageType (::most_Msg_fi_types::T_e8_MsgMessageType__e8MSG_TYPE_SMS),
    _e8MessageStatus (::most_Msg_fi_types_Extended::T_e8_MsgMessageStatus__e8DELIVERY_SUCCESS),
    _bReadStatusFlag (false),
    _oAddressField (),
    _u32ContactHandle (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_MsgConversationDetailListItem::T_MsgConversationDetailListItem (const ::most_Msg_fi_types::T_MsgMessageHandle& oMessageHandle_, const ::most_Msg_fi_types::T_MsgMessageDateTime& oMessageDateTime_, const ::fi_basetypes_most::T_String& sMessageContent_, uint32 u32AttachmentSize_, ::most_Msg_fi_types::T_e8_MsgMessageType e8MessageType_, T_e8_MsgMessageStatus e8MessageStatus_, bool bReadStatusFlag_, const ::most_Msg_fi_types::T_MsgAddressFieldItem& oAddressField_, uint32 u32ContactHandle_)  :
    _oMessageHandle (oMessageHandle_),
    _oMessageDateTime (oMessageDateTime_),
    _sMessageContent (sMessageContent_),
    _u32AttachmentSize (u32AttachmentSize_),
    _e8MessageType (e8MessageType_),
    _e8MessageStatus (e8MessageStatus_),
    _bReadStatusFlag (bReadStatusFlag_),
    _oAddressField (oAddressField_),
    _u32ContactHandle (u32ContactHandle_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sMessageContent_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(::most_Msg_fi_types::T_e8_MsgMessageType_IsValid(e8MessageType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8MessageType_, "T_e8_MsgMessageType", "e8MessageType", "T_MsgConversationDetailListItem");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_MsgMessageStatus_IsValid(e8MessageStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8MessageStatus_, "T_e8_MsgMessageStatus", "e8MessageStatus", "T_MsgConversationDetailListItem");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_MsgConversationDetailListItem::~T_MsgConversationDetailListItem() {
}

inline T_MsgConversationDetailListItem& T_MsgConversationDetailListItem::operator = (const T_MsgConversationDetailListItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasOMessageHandle()) {
            setOMessageHandle(rhs.getOMessageHandle());
        } else {
            clearOMessageHandle();
        }
        if (rhs.hasOMessageDateTime()) {
            setOMessageDateTime(rhs.getOMessageDateTime());
        } else {
            clearOMessageDateTime();
        }
        if (rhs.hasSMessageContent()) {
            setSMessageContent(rhs.getSMessageContent());
        } else {
            clearSMessageContent();
        }
        if (rhs.hasU32AttachmentSize()) {
            setU32AttachmentSize(rhs.getU32AttachmentSize());
        } else {
            clearU32AttachmentSize();
        }
        if (rhs.hasE8MessageType()) {
            setE8MessageType(rhs.getE8MessageType());
        } else {
            clearE8MessageType();
        }
        if (rhs.hasE8MessageStatus()) {
            setE8MessageStatus(rhs.getE8MessageStatus());
        } else {
            clearE8MessageStatus();
        }
        if (rhs.hasBReadStatusFlag()) {
            setBReadStatusFlag(rhs.getBReadStatusFlag());
        } else {
            clearBReadStatusFlag();
        }
        if (rhs.hasOAddressField()) {
            setOAddressField(rhs.getOAddressField());
        } else {
            clearOAddressField();
        }
        if (rhs.hasU32ContactHandle()) {
            setU32ContactHandle(rhs.getU32ContactHandle());
        } else {
            clearU32ContactHandle();
        }
    }
    return *this;
}

inline bool T_MsgConversationDetailListItem::operator == (const T_MsgConversationDetailListItem& rhs) const {
    return (((!hasOMessageHandle() && !rhs.hasOMessageHandle()) || getOMessageHandle() == rhs.getOMessageHandle()) &&
        ((!hasOMessageDateTime() && !rhs.hasOMessageDateTime()) || getOMessageDateTime() == rhs.getOMessageDateTime()) &&
        ((!hasSMessageContent() && !rhs.hasSMessageContent()) || getSMessageContent() == rhs.getSMessageContent()) &&
        ((!hasU32AttachmentSize() && !rhs.hasU32AttachmentSize()) || getU32AttachmentSize() == rhs.getU32AttachmentSize()) &&
        ((!hasE8MessageType() && !rhs.hasE8MessageType()) || getE8MessageType() == rhs.getE8MessageType()) &&
        ((!hasE8MessageStatus() && !rhs.hasE8MessageStatus()) || getE8MessageStatus() == rhs.getE8MessageStatus()) &&
        ((!hasBReadStatusFlag() && !rhs.hasBReadStatusFlag()) || getBReadStatusFlag() == rhs.getBReadStatusFlag()) &&
        ((!hasOAddressField() && !rhs.hasOAddressField()) || getOAddressField() == rhs.getOAddressField()) &&
        ((!hasU32ContactHandle() && !rhs.hasU32ContactHandle()) || getU32ContactHandle() == rhs.getU32ContactHandle()));
}

inline bool T_MsgConversationDetailListItem::operator != (const T_MsgConversationDetailListItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_MsgConversationDetailListItem::operator < (const T_MsgConversationDetailListItem& rhs) const {
    if (hasOMessageHandle() || rhs.hasOMessageHandle()) {
        if (getOMessageHandle() < rhs.getOMessageHandle()) return true;
        if (getOMessageHandle() > rhs.getOMessageHandle()) return false;
    }
    if (hasOMessageDateTime() || rhs.hasOMessageDateTime()) {
        if (getOMessageDateTime() < rhs.getOMessageDateTime()) return true;
        if (getOMessageDateTime() > rhs.getOMessageDateTime()) return false;
    }
    if (hasSMessageContent() || rhs.hasSMessageContent()) {
        if (getSMessageContent() < rhs.getSMessageContent()) return true;
        if (getSMessageContent() > rhs.getSMessageContent()) return false;
    }
    if (hasU32AttachmentSize() || rhs.hasU32AttachmentSize()) {
        if (getU32AttachmentSize() < rhs.getU32AttachmentSize()) return true;
        if (getU32AttachmentSize() > rhs.getU32AttachmentSize()) return false;
    }
    if (hasE8MessageType() || rhs.hasE8MessageType()) {
        if ((uint32)getE8MessageType() < (uint32)rhs.getE8MessageType()) return true;
        if ((uint32)getE8MessageType() > (uint32)rhs.getE8MessageType()) return false;
    }
    if (hasE8MessageStatus() || rhs.hasE8MessageStatus()) {
        if ((uint32)getE8MessageStatus() < (uint32)rhs.getE8MessageStatus()) return true;
        if ((uint32)getE8MessageStatus() > (uint32)rhs.getE8MessageStatus()) return false;
    }
    if (hasBReadStatusFlag() || rhs.hasBReadStatusFlag()) {
        if (getBReadStatusFlag() < rhs.getBReadStatusFlag()) return true;
        if (getBReadStatusFlag() > rhs.getBReadStatusFlag()) return false;
    }
    if (hasOAddressField() || rhs.hasOAddressField()) {
        if (getOAddressField() < rhs.getOAddressField()) return true;
        if (getOAddressField() > rhs.getOAddressField()) return false;
    }
    if (hasU32ContactHandle() || rhs.hasU32ContactHandle()) {
        if (getU32ContactHandle() < rhs.getU32ContactHandle()) return true;
        if (getU32ContactHandle() > rhs.getU32ContactHandle()) return false;
    }
    return false;
}

inline bool T_MsgConversationDetailListItem::operator > (const T_MsgConversationDetailListItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_MsgConversationDetailListItem::clear() {
    clearOMessageHandle();
    clearOMessageDateTime();
    clearSMessageContent();
    clearU32AttachmentSize();
    clearE8MessageType();
    clearE8MessageStatus();
    clearBReadStatusFlag();
    clearOAddressField();
    clearU32ContactHandle();
}

inline void T_MsgConversationDetailListItem::clearOMessageHandle() {
    if (hasOMessageHandle()) {
         clear_has_oMessageHandle();
        _oMessageHandle.clear();
     }
}

inline bool T_MsgConversationDetailListItem::hasOMessageHandle () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::most_Msg_fi_types::T_MsgMessageHandle& T_MsgConversationDetailListItem::getOMessageHandle () const {
    return _oMessageHandle;
}

inline ::most_Msg_fi_types::T_MsgMessageHandle& T_MsgConversationDetailListItem::getOMessageHandleMutable () {
    set_has_oMessageHandle();
    return _oMessageHandle;
}

inline void T_MsgConversationDetailListItem::setOMessageHandle (const ::most_Msg_fi_types::T_MsgMessageHandle& oMessageHandle_) {
    set_has_oMessageHandle();
    this->_oMessageHandle = oMessageHandle_;
}

inline void T_MsgConversationDetailListItem::clearOMessageDateTime() {
    if (hasOMessageDateTime()) {
         clear_has_oMessageDateTime();
        _oMessageDateTime.clear();
     }
}

inline bool T_MsgConversationDetailListItem::hasOMessageDateTime () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::most_Msg_fi_types::T_MsgMessageDateTime& T_MsgConversationDetailListItem::getOMessageDateTime () const {
    return _oMessageDateTime;
}

inline ::most_Msg_fi_types::T_MsgMessageDateTime& T_MsgConversationDetailListItem::getOMessageDateTimeMutable () {
    set_has_oMessageDateTime();
    return _oMessageDateTime;
}

inline void T_MsgConversationDetailListItem::setOMessageDateTime (const ::most_Msg_fi_types::T_MsgMessageDateTime& oMessageDateTime_) {
    set_has_oMessageDateTime();
    this->_oMessageDateTime = oMessageDateTime_;
}

inline void T_MsgConversationDetailListItem::clearSMessageContent() {
    if (hasSMessageContent()) {
         clear_has_sMessageContent();
        _sMessageContent.clear();
     }
}

inline bool T_MsgConversationDetailListItem::hasSMessageContent () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_MsgConversationDetailListItem::getSMessageContent () const {
    return _sMessageContent;
}

inline ::fi_basetypes_most::T_String& T_MsgConversationDetailListItem::getSMessageContentMutable () {
    set_has_sMessageContent();
    return _sMessageContent;
}

inline void T_MsgConversationDetailListItem::setSMessageContent (const ::fi_basetypes_most::T_String& sMessageContent_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sMessageContent_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sMessageContent();
    this->_sMessageContent = sMessageContent_;
}

inline void T_MsgConversationDetailListItem::clearU32AttachmentSize() {
    if (hasU32AttachmentSize()) {
         clear_has_u32AttachmentSize();
        _u32AttachmentSize = 0u;
     }
}

inline bool T_MsgConversationDetailListItem::hasU32AttachmentSize () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 T_MsgConversationDetailListItem::getU32AttachmentSize () const {
    return _u32AttachmentSize;
}

inline void T_MsgConversationDetailListItem::setU32AttachmentSize (uint32 u32AttachmentSize_) {
    set_has_u32AttachmentSize();
    this->_u32AttachmentSize = u32AttachmentSize_;
}

inline void T_MsgConversationDetailListItem::clearE8MessageType() {
    if (hasE8MessageType()) {
         clear_has_e8MessageType();
        _e8MessageType = ::most_Msg_fi_types::T_e8_MsgMessageType__e8MSG_TYPE_SMS;
     }
}

inline bool T_MsgConversationDetailListItem::hasE8MessageType () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline ::most_Msg_fi_types::T_e8_MsgMessageType T_MsgConversationDetailListItem::getE8MessageType () const {
    return _e8MessageType;
}

inline void T_MsgConversationDetailListItem::setE8MessageType (::most_Msg_fi_types::T_e8_MsgMessageType e8MessageType_) {
    #ifndef NDEBUG
    if (!(::most_Msg_fi_types::T_e8_MsgMessageType_IsValid(e8MessageType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8MessageType_, "T_e8_MsgMessageType", "e8MessageType", "T_MsgConversationDetailListItem");
    }
    #endif
    set_has_e8MessageType();
    this->_e8MessageType = e8MessageType_;
}

inline void T_MsgConversationDetailListItem::clearE8MessageStatus() {
    if (hasE8MessageStatus()) {
         clear_has_e8MessageStatus();
        _e8MessageStatus = ::most_Msg_fi_types_Extended::T_e8_MsgMessageStatus__e8DELIVERY_SUCCESS;
     }
}

inline bool T_MsgConversationDetailListItem::hasE8MessageStatus () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline T_e8_MsgMessageStatus T_MsgConversationDetailListItem::getE8MessageStatus () const {
    return _e8MessageStatus;
}

inline void T_MsgConversationDetailListItem::setE8MessageStatus (T_e8_MsgMessageStatus e8MessageStatus_) {
    #ifndef NDEBUG
    if (!(T_e8_MsgMessageStatus_IsValid(e8MessageStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8MessageStatus_, "T_e8_MsgMessageStatus", "e8MessageStatus", "T_MsgConversationDetailListItem");
    }
    #endif
    set_has_e8MessageStatus();
    this->_e8MessageStatus = e8MessageStatus_;
}

inline void T_MsgConversationDetailListItem::clearBReadStatusFlag() {
    if (hasBReadStatusFlag()) {
         clear_has_bReadStatusFlag();
        _bReadStatusFlag = false;
     }
}

inline bool T_MsgConversationDetailListItem::hasBReadStatusFlag () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline bool T_MsgConversationDetailListItem::getBReadStatusFlag () const {
    return _bReadStatusFlag;
}

inline void T_MsgConversationDetailListItem::setBReadStatusFlag (bool bReadStatusFlag_) {
    set_has_bReadStatusFlag();
    this->_bReadStatusFlag = bReadStatusFlag_;
}

inline void T_MsgConversationDetailListItem::clearOAddressField() {
    if (hasOAddressField()) {
         clear_has_oAddressField();
        _oAddressField.clear();
     }
}

inline bool T_MsgConversationDetailListItem::hasOAddressField () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline const ::most_Msg_fi_types::T_MsgAddressFieldItem& T_MsgConversationDetailListItem::getOAddressField () const {
    return _oAddressField;
}

inline ::most_Msg_fi_types::T_MsgAddressFieldItem& T_MsgConversationDetailListItem::getOAddressFieldMutable () {
    set_has_oAddressField();
    return _oAddressField;
}

inline void T_MsgConversationDetailListItem::setOAddressField (const ::most_Msg_fi_types::T_MsgAddressFieldItem& oAddressField_) {
    set_has_oAddressField();
    this->_oAddressField = oAddressField_;
}

inline void T_MsgConversationDetailListItem::clearU32ContactHandle() {
    if (hasU32ContactHandle()) {
         clear_has_u32ContactHandle();
        _u32ContactHandle = 0u;
     }
}

inline bool T_MsgConversationDetailListItem::hasU32ContactHandle () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline uint32 T_MsgConversationDetailListItem::getU32ContactHandle () const {
    return _u32ContactHandle;
}

inline void T_MsgConversationDetailListItem::setU32ContactHandle (uint32 u32ContactHandle_) {
    set_has_u32ContactHandle();
    this->_u32ContactHandle = u32ContactHandle_;
}

inline void T_MsgConversationDetailListItem::set_has_oMessageHandle () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_MsgConversationDetailListItem::clear_has_oMessageHandle () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_MsgConversationDetailListItem::set_has_oMessageDateTime () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_MsgConversationDetailListItem::clear_has_oMessageDateTime () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_MsgConversationDetailListItem::set_has_sMessageContent () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_MsgConversationDetailListItem::clear_has_sMessageContent () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_MsgConversationDetailListItem::set_has_u32AttachmentSize () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_MsgConversationDetailListItem::clear_has_u32AttachmentSize () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_MsgConversationDetailListItem::set_has_e8MessageType () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_MsgConversationDetailListItem::clear_has_e8MessageType () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_MsgConversationDetailListItem::set_has_e8MessageStatus () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_MsgConversationDetailListItem::clear_has_e8MessageStatus () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_MsgConversationDetailListItem::set_has_bReadStatusFlag () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_MsgConversationDetailListItem::clear_has_bReadStatusFlag () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_MsgConversationDetailListItem::set_has_oAddressField () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_MsgConversationDetailListItem::clear_has_oAddressField () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_MsgConversationDetailListItem::set_has_u32ContactHandle () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_MsgConversationDetailListItem::clear_has_u32ContactHandle () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline  T_OnOffListItem::T_OnOffListItem ()  :
    _u8DeviceHandle (0u),
    _bOnOffState (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_OnOffListItem::T_OnOffListItem (const T_OnOffListItem &rhs)  :
    _u8DeviceHandle (0u),
    _bOnOffState (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_OnOffListItem::T_OnOffListItem (uint8 u8DeviceHandle_, bool bOnOffState_)  :
    _u8DeviceHandle (u8DeviceHandle_),
    _bOnOffState (bOnOffState_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_OnOffListItem::~T_OnOffListItem() {
}

inline T_OnOffListItem& T_OnOffListItem::operator = (const T_OnOffListItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8DeviceHandle()) {
            setU8DeviceHandle(rhs.getU8DeviceHandle());
        } else {
            clearU8DeviceHandle();
        }
        if (rhs.hasBOnOffState()) {
            setBOnOffState(rhs.getBOnOffState());
        } else {
            clearBOnOffState();
        }
    }
    return *this;
}

inline bool T_OnOffListItem::operator == (const T_OnOffListItem& rhs) const {
    return (((!hasU8DeviceHandle() && !rhs.hasU8DeviceHandle()) || getU8DeviceHandle() == rhs.getU8DeviceHandle()) &&
        ((!hasBOnOffState() && !rhs.hasBOnOffState()) || getBOnOffState() == rhs.getBOnOffState()));
}

inline bool T_OnOffListItem::operator != (const T_OnOffListItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_OnOffListItem::operator < (const T_OnOffListItem& rhs) const {
    if (hasU8DeviceHandle() || rhs.hasU8DeviceHandle()) {
        if (getU8DeviceHandle() < rhs.getU8DeviceHandle()) return true;
        if (getU8DeviceHandle() > rhs.getU8DeviceHandle()) return false;
    }
    if (hasBOnOffState() || rhs.hasBOnOffState()) {
        if (getBOnOffState() < rhs.getBOnOffState()) return true;
        if (getBOnOffState() > rhs.getBOnOffState()) return false;
    }
    return false;
}

inline bool T_OnOffListItem::operator > (const T_OnOffListItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_OnOffListItem::clear() {
    clearU8DeviceHandle();
    clearBOnOffState();
}

inline void T_OnOffListItem::clearU8DeviceHandle() {
    if (hasU8DeviceHandle()) {
         clear_has_u8DeviceHandle();
        _u8DeviceHandle = 0u;
     }
}

inline bool T_OnOffListItem::hasU8DeviceHandle () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_OnOffListItem::getU8DeviceHandle () const {
    return _u8DeviceHandle;
}

inline void T_OnOffListItem::setU8DeviceHandle (uint8 u8DeviceHandle_) {
    set_has_u8DeviceHandle();
    this->_u8DeviceHandle = u8DeviceHandle_;
}

inline void T_OnOffListItem::clearBOnOffState() {
    if (hasBOnOffState()) {
         clear_has_bOnOffState();
        _bOnOffState = false;
     }
}

inline bool T_OnOffListItem::hasBOnOffState () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool T_OnOffListItem::getBOnOffState () const {
    return _bOnOffState;
}

inline void T_OnOffListItem::setBOnOffState (bool bOnOffState_) {
    set_has_bOnOffState();
    this->_bOnOffState = bOnOffState_;
}

inline void T_OnOffListItem::set_has_u8DeviceHandle () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_OnOffListItem::clear_has_u8DeviceHandle () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_OnOffListItem::set_has_bOnOffState () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_OnOffListItem::clear_has_bOnOffState () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_AutoReplyTextListItem::T_AutoReplyTextListItem ()  :
    _u8DeviceHandle (0u),
    _u16PredefinedMsgHandle (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_AutoReplyTextListItem::T_AutoReplyTextListItem (const T_AutoReplyTextListItem &rhs)  :
    _u8DeviceHandle (0u),
    _u16PredefinedMsgHandle (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_AutoReplyTextListItem::T_AutoReplyTextListItem (uint8 u8DeviceHandle_, uint16 u16PredefinedMsgHandle_)  :
    _u8DeviceHandle (u8DeviceHandle_),
    _u16PredefinedMsgHandle (u16PredefinedMsgHandle_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_AutoReplyTextListItem::~T_AutoReplyTextListItem() {
}

inline T_AutoReplyTextListItem& T_AutoReplyTextListItem::operator = (const T_AutoReplyTextListItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8DeviceHandle()) {
            setU8DeviceHandle(rhs.getU8DeviceHandle());
        } else {
            clearU8DeviceHandle();
        }
        if (rhs.hasU16PredefinedMsgHandle()) {
            setU16PredefinedMsgHandle(rhs.getU16PredefinedMsgHandle());
        } else {
            clearU16PredefinedMsgHandle();
        }
    }
    return *this;
}

inline bool T_AutoReplyTextListItem::operator == (const T_AutoReplyTextListItem& rhs) const {
    return (((!hasU8DeviceHandle() && !rhs.hasU8DeviceHandle()) || getU8DeviceHandle() == rhs.getU8DeviceHandle()) &&
        ((!hasU16PredefinedMsgHandle() && !rhs.hasU16PredefinedMsgHandle()) || getU16PredefinedMsgHandle() == rhs.getU16PredefinedMsgHandle()));
}

inline bool T_AutoReplyTextListItem::operator != (const T_AutoReplyTextListItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_AutoReplyTextListItem::operator < (const T_AutoReplyTextListItem& rhs) const {
    if (hasU8DeviceHandle() || rhs.hasU8DeviceHandle()) {
        if (getU8DeviceHandle() < rhs.getU8DeviceHandle()) return true;
        if (getU8DeviceHandle() > rhs.getU8DeviceHandle()) return false;
    }
    if (hasU16PredefinedMsgHandle() || rhs.hasU16PredefinedMsgHandle()) {
        if (getU16PredefinedMsgHandle() < rhs.getU16PredefinedMsgHandle()) return true;
        if (getU16PredefinedMsgHandle() > rhs.getU16PredefinedMsgHandle()) return false;
    }
    return false;
}

inline bool T_AutoReplyTextListItem::operator > (const T_AutoReplyTextListItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_AutoReplyTextListItem::clear() {
    clearU8DeviceHandle();
    clearU16PredefinedMsgHandle();
}

inline void T_AutoReplyTextListItem::clearU8DeviceHandle() {
    if (hasU8DeviceHandle()) {
         clear_has_u8DeviceHandle();
        _u8DeviceHandle = 0u;
     }
}

inline bool T_AutoReplyTextListItem::hasU8DeviceHandle () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_AutoReplyTextListItem::getU8DeviceHandle () const {
    return _u8DeviceHandle;
}

inline void T_AutoReplyTextListItem::setU8DeviceHandle (uint8 u8DeviceHandle_) {
    set_has_u8DeviceHandle();
    this->_u8DeviceHandle = u8DeviceHandle_;
}

inline void T_AutoReplyTextListItem::clearU16PredefinedMsgHandle() {
    if (hasU16PredefinedMsgHandle()) {
         clear_has_u16PredefinedMsgHandle();
        _u16PredefinedMsgHandle = 0u;
     }
}

inline bool T_AutoReplyTextListItem::hasU16PredefinedMsgHandle () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 T_AutoReplyTextListItem::getU16PredefinedMsgHandle () const {
    return _u16PredefinedMsgHandle;
}

inline void T_AutoReplyTextListItem::setU16PredefinedMsgHandle (uint16 u16PredefinedMsgHandle_) {
    set_has_u16PredefinedMsgHandle();
    this->_u16PredefinedMsgHandle = u16PredefinedMsgHandle_;
}

inline void T_AutoReplyTextListItem::set_has_u8DeviceHandle () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_AutoReplyTextListItem::clear_has_u8DeviceHandle () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_AutoReplyTextListItem::set_has_u16PredefinedMsgHandle () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_AutoReplyTextListItem::clear_has_u16PredefinedMsgHandle () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_MapDeviceCapabilitiesListItem::T_MapDeviceCapabilitiesListItem ()  :
    _u8DeviceHandle (0u),
    _u16SupportedMessageTypes (0u),
    _u16SupportedMapFeatures (0u),
    _e8MapConnectionState (::most_Msg_fi_types_Extended::T_e8_MapConnectionStatus__e8MAP_DISCONNECTED),
    _oActiveAccount ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_MapDeviceCapabilitiesListItem::T_MapDeviceCapabilitiesListItem (const T_MapDeviceCapabilitiesListItem &rhs)  :
    _u8DeviceHandle (0u),
    _u16SupportedMessageTypes (0u),
    _u16SupportedMapFeatures (0u),
    _e8MapConnectionState (::most_Msg_fi_types_Extended::T_e8_MapConnectionStatus__e8MAP_DISCONNECTED),
    _oActiveAccount ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_MapDeviceCapabilitiesListItem::T_MapDeviceCapabilitiesListItem (uint8 u8DeviceHandle_, uint16 u16SupportedMessageTypes_, uint16 u16SupportedMapFeatures_, T_e8_MapConnectionStatus e8MapConnectionState_, const ::most_Msg_fi_types::T_MsgActiveAccount& oActiveAccount_)  :
    _u8DeviceHandle (u8DeviceHandle_),
    _u16SupportedMessageTypes (u16SupportedMessageTypes_),
    _u16SupportedMapFeatures (u16SupportedMapFeatures_),
    _e8MapConnectionState (e8MapConnectionState_),
    _oActiveAccount (oActiveAccount_)
{
    #ifndef NDEBUG
    if (!(T_e8_MapConnectionStatus_IsValid(e8MapConnectionState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8MapConnectionState_, "T_e8_MapConnectionStatus", "e8MapConnectionState", "T_MapDeviceCapabilitiesListItem");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_MapDeviceCapabilitiesListItem::~T_MapDeviceCapabilitiesListItem() {
}

inline T_MapDeviceCapabilitiesListItem& T_MapDeviceCapabilitiesListItem::operator = (const T_MapDeviceCapabilitiesListItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8DeviceHandle()) {
            setU8DeviceHandle(rhs.getU8DeviceHandle());
        } else {
            clearU8DeviceHandle();
        }
        if (rhs.hasU16SupportedMessageTypes()) {
            setU16SupportedMessageTypes(rhs.getU16SupportedMessageTypes());
        } else {
            clearU16SupportedMessageTypes();
        }
        if (rhs.hasU16SupportedMapFeatures()) {
            setU16SupportedMapFeatures(rhs.getU16SupportedMapFeatures());
        } else {
            clearU16SupportedMapFeatures();
        }
        if (rhs.hasE8MapConnectionState()) {
            setE8MapConnectionState(rhs.getE8MapConnectionState());
        } else {
            clearE8MapConnectionState();
        }
        if (rhs.hasOActiveAccount()) {
            setOActiveAccount(rhs.getOActiveAccount());
        } else {
            clearOActiveAccount();
        }
    }
    return *this;
}

inline bool T_MapDeviceCapabilitiesListItem::operator == (const T_MapDeviceCapabilitiesListItem& rhs) const {
    return (((!hasU8DeviceHandle() && !rhs.hasU8DeviceHandle()) || getU8DeviceHandle() == rhs.getU8DeviceHandle()) &&
        ((!hasU16SupportedMessageTypes() && !rhs.hasU16SupportedMessageTypes()) || getU16SupportedMessageTypes() == rhs.getU16SupportedMessageTypes()) &&
        ((!hasU16SupportedMapFeatures() && !rhs.hasU16SupportedMapFeatures()) || getU16SupportedMapFeatures() == rhs.getU16SupportedMapFeatures()) &&
        ((!hasE8MapConnectionState() && !rhs.hasE8MapConnectionState()) || getE8MapConnectionState() == rhs.getE8MapConnectionState()) &&
        ((!hasOActiveAccount() && !rhs.hasOActiveAccount()) || getOActiveAccount() == rhs.getOActiveAccount()));
}

inline bool T_MapDeviceCapabilitiesListItem::operator != (const T_MapDeviceCapabilitiesListItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_MapDeviceCapabilitiesListItem::operator < (const T_MapDeviceCapabilitiesListItem& rhs) const {
    if (hasU8DeviceHandle() || rhs.hasU8DeviceHandle()) {
        if (getU8DeviceHandle() < rhs.getU8DeviceHandle()) return true;
        if (getU8DeviceHandle() > rhs.getU8DeviceHandle()) return false;
    }
    if (hasU16SupportedMessageTypes() || rhs.hasU16SupportedMessageTypes()) {
        if (getU16SupportedMessageTypes() < rhs.getU16SupportedMessageTypes()) return true;
        if (getU16SupportedMessageTypes() > rhs.getU16SupportedMessageTypes()) return false;
    }
    if (hasU16SupportedMapFeatures() || rhs.hasU16SupportedMapFeatures()) {
        if (getU16SupportedMapFeatures() < rhs.getU16SupportedMapFeatures()) return true;
        if (getU16SupportedMapFeatures() > rhs.getU16SupportedMapFeatures()) return false;
    }
    if (hasE8MapConnectionState() || rhs.hasE8MapConnectionState()) {
        if ((uint32)getE8MapConnectionState() < (uint32)rhs.getE8MapConnectionState()) return true;
        if ((uint32)getE8MapConnectionState() > (uint32)rhs.getE8MapConnectionState()) return false;
    }
    if (hasOActiveAccount() || rhs.hasOActiveAccount()) {
        if (getOActiveAccount() < rhs.getOActiveAccount()) return true;
        if (getOActiveAccount() > rhs.getOActiveAccount()) return false;
    }
    return false;
}

inline bool T_MapDeviceCapabilitiesListItem::operator > (const T_MapDeviceCapabilitiesListItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_MapDeviceCapabilitiesListItem::clear() {
    clearU8DeviceHandle();
    clearU16SupportedMessageTypes();
    clearU16SupportedMapFeatures();
    clearE8MapConnectionState();
    clearOActiveAccount();
}

inline void T_MapDeviceCapabilitiesListItem::clearU8DeviceHandle() {
    if (hasU8DeviceHandle()) {
         clear_has_u8DeviceHandle();
        _u8DeviceHandle = 0u;
     }
}

inline bool T_MapDeviceCapabilitiesListItem::hasU8DeviceHandle () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_MapDeviceCapabilitiesListItem::getU8DeviceHandle () const {
    return _u8DeviceHandle;
}

inline void T_MapDeviceCapabilitiesListItem::setU8DeviceHandle (uint8 u8DeviceHandle_) {
    set_has_u8DeviceHandle();
    this->_u8DeviceHandle = u8DeviceHandle_;
}

inline void T_MapDeviceCapabilitiesListItem::clearU16SupportedMessageTypes() {
    if (hasU16SupportedMessageTypes()) {
         clear_has_u16SupportedMessageTypes();
        _u16SupportedMessageTypes = 0u;
     }
}

inline bool T_MapDeviceCapabilitiesListItem::hasU16SupportedMessageTypes () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 T_MapDeviceCapabilitiesListItem::getU16SupportedMessageTypes () const {
    return _u16SupportedMessageTypes;
}

inline void T_MapDeviceCapabilitiesListItem::setU16SupportedMessageTypes (uint16 u16SupportedMessageTypes_) {
    set_has_u16SupportedMessageTypes();
    this->_u16SupportedMessageTypes = u16SupportedMessageTypes_;
}

inline void T_MapDeviceCapabilitiesListItem::clearU16SupportedMapFeatures() {
    if (hasU16SupportedMapFeatures()) {
         clear_has_u16SupportedMapFeatures();
        _u16SupportedMapFeatures = 0u;
     }
}

inline bool T_MapDeviceCapabilitiesListItem::hasU16SupportedMapFeatures () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 T_MapDeviceCapabilitiesListItem::getU16SupportedMapFeatures () const {
    return _u16SupportedMapFeatures;
}

inline void T_MapDeviceCapabilitiesListItem::setU16SupportedMapFeatures (uint16 u16SupportedMapFeatures_) {
    set_has_u16SupportedMapFeatures();
    this->_u16SupportedMapFeatures = u16SupportedMapFeatures_;
}

inline void T_MapDeviceCapabilitiesListItem::clearE8MapConnectionState() {
    if (hasE8MapConnectionState()) {
         clear_has_e8MapConnectionState();
        _e8MapConnectionState = ::most_Msg_fi_types_Extended::T_e8_MapConnectionStatus__e8MAP_DISCONNECTED;
     }
}

inline bool T_MapDeviceCapabilitiesListItem::hasE8MapConnectionState () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline T_e8_MapConnectionStatus T_MapDeviceCapabilitiesListItem::getE8MapConnectionState () const {
    return _e8MapConnectionState;
}

inline void T_MapDeviceCapabilitiesListItem::setE8MapConnectionState (T_e8_MapConnectionStatus e8MapConnectionState_) {
    #ifndef NDEBUG
    if (!(T_e8_MapConnectionStatus_IsValid(e8MapConnectionState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8MapConnectionState_, "T_e8_MapConnectionStatus", "e8MapConnectionState", "T_MapDeviceCapabilitiesListItem");
    }
    #endif
    set_has_e8MapConnectionState();
    this->_e8MapConnectionState = e8MapConnectionState_;
}

inline void T_MapDeviceCapabilitiesListItem::clearOActiveAccount() {
    if (hasOActiveAccount()) {
         clear_has_oActiveAccount();
        _oActiveAccount.clear();
     }
}

inline bool T_MapDeviceCapabilitiesListItem::hasOActiveAccount () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::most_Msg_fi_types::T_MsgActiveAccount& T_MapDeviceCapabilitiesListItem::getOActiveAccount () const {
    return _oActiveAccount;
}

inline ::most_Msg_fi_types::T_MsgActiveAccount& T_MapDeviceCapabilitiesListItem::getOActiveAccountMutable () {
    set_has_oActiveAccount();
    return _oActiveAccount;
}

inline void T_MapDeviceCapabilitiesListItem::setOActiveAccount (const ::most_Msg_fi_types::T_MsgActiveAccount& oActiveAccount_) {
    set_has_oActiveAccount();
    this->_oActiveAccount = oActiveAccount_;
}

inline void T_MapDeviceCapabilitiesListItem::set_has_u8DeviceHandle () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_MapDeviceCapabilitiesListItem::clear_has_u8DeviceHandle () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_MapDeviceCapabilitiesListItem::set_has_u16SupportedMessageTypes () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_MapDeviceCapabilitiesListItem::clear_has_u16SupportedMessageTypes () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_MapDeviceCapabilitiesListItem::set_has_u16SupportedMapFeatures () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_MapDeviceCapabilitiesListItem::clear_has_u16SupportedMapFeatures () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_MapDeviceCapabilitiesListItem::set_has_e8MapConnectionState () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_MapDeviceCapabilitiesListItem::clear_has_e8MapConnectionState () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_MapDeviceCapabilitiesListItem::set_has_oActiveAccount () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_MapDeviceCapabilitiesListItem::clear_has_oActiveAccount () {
    _has_bits_[0] &= ~ (1u << 4);
}

} // namespace most_Msg_fi_types_Extended

#endif // MOST_MSG_FI_TYPES_EXTENDED_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
