#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef MOST_MSG_FI_TYPES_H
#define MOST_MSG_FI_TYPES_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "fi_basetypes_most.h"
#include "most_Msg_fi_typesConst.h"
#include <cstring>
#include <vector>

/**
 * Types most_Msg_fi_types
 */

namespace most_Msg_fi_types {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class T_MsgMessageHandle;

class T_MsgMessageDate;

class T_MsgMessageTime;

class T_MsgMessageDateTime;

class T_MsgMessageListSliceResultItem;

class T_MsgFolderListResultItem;

class T_MsgAccountListResultItem;

class T_MsgActiveAccount;

class T_MsgAddressFieldItem;

class T_MsgMessageDetailsResult;

class T_MsgAttachmentListItem;

class T_MsgBodyPartListItem;

class T_MsgPredefinedMessageListResultItem;

// type definitions
/**
 * If the meaning of "T_MsgMessageListSliceResult" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_MsgMessageListSliceResultItem > T_MsgMessageListSliceResult;

/**
 * If the meaning of "T_MsgChangeItems" isn't clear, then there should be a description here.
 */
typedef ::std::vector< uint32 > T_MsgChangeItems;

/**
 * If the meaning of "T_MsgFolderListResult" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_MsgFolderListResultItem > T_MsgFolderListResult;

/**
 * If the meaning of "T_MsgDeleteMessageHandles" isn't clear, then there should be a description here.
 */
typedef ::std::vector< ::fi_basetypes_most::T_ShortStream > T_MsgDeleteMessageHandles;

/**
 * If the meaning of "T_MsgAccountListResult" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_MsgAccountListResultItem > T_MsgAccountListResult;

/**
 * If the meaning of "T_MsgMsgBodyActionElementTags" isn't clear, then there should be a description here.
 */
typedef ::std::vector< uint8 > T_MsgMsgBodyActionElementTags;

/**
 * If the meaning of "T_MsgAddressField" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_MsgAddressFieldItem > T_MsgAddressField;

/**
 * If the meaning of "T_MsgAttachmentList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_MsgAttachmentListItem > T_MsgAttachmentList;

/**
 * If the meaning of "T_MsgBodyPartList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_MsgBodyPartListItem > T_MsgBodyPartList;

/**
 * If the meaning of "T_MsgPredefinedMessageListResult" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_MsgPredefinedMessageListResultItem > T_MsgPredefinedMessageListResult;

/**
 * If the meaning of "T_MsgConversationMessages" isn't clear, then there should be a description here.
 */
typedef ::std::vector< ::fi_basetypes_most::T_ShortStream > T_MsgConversationMessages;

/**
 * If the meaning of "T_MsgAttachmentHandleStream" isn't clear, then there should be a description here.
 */
typedef ::std::vector< uint16 > T_MsgAttachmentHandleStream;

/**
 * If the meaning of "T_MsgMessageBodyText" isn't clear, then there should be a description here.
 */
typedef ::std::vector< ::fi_basetypes_most::T_String > T_MsgMessageBodyText;


class T_MsgMessageHandle {
public:

    /**
     * Default constructor
     */
    inline  T_MsgMessageHandle ();

    /**
     * Copy constructor
     */
    inline  T_MsgMessageHandle (const T_MsgMessageHandle &rhs);

    /**
     * All fields constructor
     */
    inline  T_MsgMessageHandle (uint8 u8DeviceHandle_, uint32 u32MsgHandleUpper_, uint32 u32MsgHandleLower_);

    /**
     * Destructor
     */
    inline  ~T_MsgMessageHandle();

    /**
     * Assignment operator
     */
    inline T_MsgMessageHandle& operator = (const T_MsgMessageHandle& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_MsgMessageHandle& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_MsgMessageHandle& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_MsgMessageHandle& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_MsgMessageHandle& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    // API of field "u32MsgHandleUpper"

    static const int kU32MsgHandleUpper = 1;

    /**
     * Clears the field "u32MsgHandleUpper".
     *
     * The field will be set to its default value. The hasU32MsgHandleUpper()
     * method will return false.
     */
    inline void clearU32MsgHandleUpper();

    /**
     * Checks whether the field "u32MsgHandleUpper" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32MsgHandleUpper()). Otherwise it will return false.
     */
    inline bool hasU32MsgHandleUpper () const;

    /**
     * Returns the value of the member "u32MsgHandleUpper".
     *
     * The upper 4bytes (32-bits) of the message handle (64-bit) as received from the Bluetooth device.
     *
     * @return The value of the field "u32MsgHandleUpper"
     */
    inline uint32 getU32MsgHandleUpper () const;

    /**
     * Sets the value of the member "u32MsgHandleUpper".
     *
     * The upper 4bytes (32-bits) of the message handle (64-bit) as received from the Bluetooth device.
     *
     * @param u32MsgHandleUpper The value which will be set
     */
    inline void setU32MsgHandleUpper (uint32 u32MsgHandleUpper_);

    // API of field "u32MsgHandleLower"

    static const int kU32MsgHandleLower = 2;

    /**
     * Clears the field "u32MsgHandleLower".
     *
     * The field will be set to its default value. The hasU32MsgHandleLower()
     * method will return false.
     */
    inline void clearU32MsgHandleLower();

    /**
     * Checks whether the field "u32MsgHandleLower" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32MsgHandleLower()). Otherwise it will return false.
     */
    inline bool hasU32MsgHandleLower () const;

    /**
     * Returns the value of the member "u32MsgHandleLower".
     *
     * The lower 4bytes (32-bits) of the message handle (64-bit) as received from the Bluetooth device.
     *
     * @return The value of the field "u32MsgHandleLower"
     */
    inline uint32 getU32MsgHandleLower () const;

    /**
     * Sets the value of the member "u32MsgHandleLower".
     *
     * The lower 4bytes (32-bits) of the message handle (64-bit) as received from the Bluetooth device.
     *
     * @param u32MsgHandleLower The value which will be set
     */
    inline void setU32MsgHandleLower (uint32 u32MsgHandleLower_);

    static const T_MsgMessageHandle &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    inline void set_has_u32MsgHandleUpper ();

    inline void clear_has_u32MsgHandleUpper ();

    inline void set_has_u32MsgHandleLower ();

    inline void clear_has_u32MsgHandleLower ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _u8DeviceHandle;

    uint32 _u32MsgHandleUpper;

    uint32 _u32MsgHandleLower;

};

class T_MsgMessageDate {
public:

    /**
     * Default constructor
     */
    inline  T_MsgMessageDate ();

    /**
     * Copy constructor
     */
    inline  T_MsgMessageDate (const T_MsgMessageDate &rhs);

    /**
     * All fields constructor
     */
    inline  T_MsgMessageDate (const ::fi_basetypes_most::T_String& sCldrYear_, const ::fi_basetypes_most::T_String& sCldrMonth_, const ::fi_basetypes_most::T_String& sCldrDay_);

    /**
     * Destructor
     */
    inline  ~T_MsgMessageDate();

    /**
     * Assignment operator
     */
    inline T_MsgMessageDate& operator = (const T_MsgMessageDate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_MsgMessageDate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_MsgMessageDate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_MsgMessageDate& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_MsgMessageDate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sCldrYear"

    static const int kSCldrYear = 0;

    /**
     * Clears the field "sCldrYear".
     *
     * The field will be set to its default value. The hasSCldrYear()
     * method will return false.
     */
    inline void clearSCldrYear();

    /**
     * Checks whether the field "sCldrYear" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSCldrYear()). Otherwise it will return false.
     */
    inline bool hasSCldrYear () const;

    /**
     * Returns the value of the member "sCldrYear".
     *
     * Identifies the calendar year; 0000 = unknown calendar year.
     *
     * @return The value of the field "sCldrYear"
     */
    inline const ::fi_basetypes_most::T_String& getSCldrYear () const;

    /**
     * Retrieves the value of the field "sCldrYear" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sCldrYear".
     */
    inline ::fi_basetypes_most::T_String& getSCldrYearMutable ();

    /**
     * Sets the value of the member "sCldrYear".
     *
     * Identifies the calendar year; 0000 = unknown calendar year.
     *
     * @param sCldrYear The value which will be set
     */
    inline void setSCldrYear (const ::fi_basetypes_most::T_String& sCldrYear_);

    // API of field "sCldrMonth"

    static const int kSCldrMonth = 1;

    /**
     * Clears the field "sCldrMonth".
     *
     * The field will be set to its default value. The hasSCldrMonth()
     * method will return false.
     */
    inline void clearSCldrMonth();

    /**
     * Checks whether the field "sCldrMonth" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSCldrMonth()). Otherwise it will return false.
     */
    inline bool hasSCldrMonth () const;

    /**
     * Returns the value of the member "sCldrMonth".
     *
     * Identifies the calendar month.00 = Unknown01 = January02 = February03 = March04 = April05 = May06 = June07 = July08 = August09 = September10 = October11 = November12 = December
     *
     * @return The value of the field "sCldrMonth"
     */
    inline const ::fi_basetypes_most::T_String& getSCldrMonth () const;

    /**
     * Retrieves the value of the field "sCldrMonth" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sCldrMonth".
     */
    inline ::fi_basetypes_most::T_String& getSCldrMonthMutable ();

    /**
     * Sets the value of the member "sCldrMonth".
     *
     * Identifies the calendar month.00 = Unknown01 = January02 = February03 = March04 = April05 = May06 = June07 = July08 = August09 = September10 = October11 = November12 = December
     *
     * @param sCldrMonth The value which will be set
     */
    inline void setSCldrMonth (const ::fi_basetypes_most::T_String& sCldrMonth_);

    // API of field "sCldrDay"

    static const int kSCldrDay = 2;

    /**
     * Clears the field "sCldrDay".
     *
     * The field will be set to its default value. The hasSCldrDay()
     * method will return false.
     */
    inline void clearSCldrDay();

    /**
     * Checks whether the field "sCldrDay" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSCldrDay()). Otherwise it will return false.
     */
    inline bool hasSCldrDay () const;

    /**
     * Returns the value of the member "sCldrDay".
     *
     * Identifies the calendar day; 00 = unknown calendar day.
     *
     * @return The value of the field "sCldrDay"
     */
    inline const ::fi_basetypes_most::T_String& getSCldrDay () const;

    /**
     * Retrieves the value of the field "sCldrDay" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sCldrDay".
     */
    inline ::fi_basetypes_most::T_String& getSCldrDayMutable ();

    /**
     * Sets the value of the member "sCldrDay".
     *
     * Identifies the calendar day; 00 = unknown calendar day.
     *
     * @param sCldrDay The value which will be set
     */
    inline void setSCldrDay (const ::fi_basetypes_most::T_String& sCldrDay_);

    static const T_MsgMessageDate &getDefaultInstance();

private:

    inline void set_has_sCldrYear ();

    inline void clear_has_sCldrYear ();

    inline void set_has_sCldrMonth ();

    inline void clear_has_sCldrMonth ();

    inline void set_has_sCldrDay ();

    inline void clear_has_sCldrDay ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::fi_basetypes_most::T_String _sCldrYear;

    ::fi_basetypes_most::T_String _sCldrMonth;

    ::fi_basetypes_most::T_String _sCldrDay;

};

class T_MsgMessageTime {
public:

    /**
     * Default constructor
     */
    inline  T_MsgMessageTime ();

    /**
     * Copy constructor
     */
    inline  T_MsgMessageTime (const T_MsgMessageTime &rhs);

    /**
     * All fields constructor
     */
    inline  T_MsgMessageTime (const ::fi_basetypes_most::T_String& sHours_, const ::fi_basetypes_most::T_String& sMinutes_, const ::fi_basetypes_most::T_String& sSeconds_);

    /**
     * Destructor
     */
    inline  ~T_MsgMessageTime();

    /**
     * Assignment operator
     */
    inline T_MsgMessageTime& operator = (const T_MsgMessageTime& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_MsgMessageTime& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_MsgMessageTime& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_MsgMessageTime& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_MsgMessageTime& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sHours"

    static const int kSHours = 0;

    /**
     * Clears the field "sHours".
     *
     * The field will be set to its default value. The hasSHours()
     * method will return false.
     */
    inline void clearSHours();

    /**
     * Checks whether the field "sHours" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSHours()). Otherwise it will return false.
     */
    inline bool hasSHours () const;

    /**
     * Returns the value of the member "sHours".
     *
     * Identifies the hour. Formated as 24 hour mode; 99 = unknown.
     *
     * @return The value of the field "sHours"
     */
    inline const ::fi_basetypes_most::T_String& getSHours () const;

    /**
     * Retrieves the value of the field "sHours" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sHours".
     */
    inline ::fi_basetypes_most::T_String& getSHoursMutable ();

    /**
     * Sets the value of the member "sHours".
     *
     * Identifies the hour. Formated as 24 hour mode; 99 = unknown.
     *
     * @param sHours The value which will be set
     */
    inline void setSHours (const ::fi_basetypes_most::T_String& sHours_);

    // API of field "sMinutes"

    static const int kSMinutes = 1;

    /**
     * Clears the field "sMinutes".
     *
     * The field will be set to its default value. The hasSMinutes()
     * method will return false.
     */
    inline void clearSMinutes();

    /**
     * Checks whether the field "sMinutes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSMinutes()). Otherwise it will return false.
     */
    inline bool hasSMinutes () const;

    /**
     * Returns the value of the member "sMinutes".
     *
     * Identifies the minutes; 99 = unknown.
     *
     * @return The value of the field "sMinutes"
     */
    inline const ::fi_basetypes_most::T_String& getSMinutes () const;

    /**
     * Retrieves the value of the field "sMinutes" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sMinutes".
     */
    inline ::fi_basetypes_most::T_String& getSMinutesMutable ();

    /**
     * Sets the value of the member "sMinutes".
     *
     * Identifies the minutes; 99 = unknown.
     *
     * @param sMinutes The value which will be set
     */
    inline void setSMinutes (const ::fi_basetypes_most::T_String& sMinutes_);

    // API of field "sSeconds"

    static const int kSSeconds = 2;

    /**
     * Clears the field "sSeconds".
     *
     * The field will be set to its default value. The hasSSeconds()
     * method will return false.
     */
    inline void clearSSeconds();

    /**
     * Checks whether the field "sSeconds" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSSeconds()). Otherwise it will return false.
     */
    inline bool hasSSeconds () const;

    /**
     * Returns the value of the member "sSeconds".
     *
     * Identifies the seconds; 99 = unknown.
     *
     * @return The value of the field "sSeconds"
     */
    inline const ::fi_basetypes_most::T_String& getSSeconds () const;

    /**
     * Retrieves the value of the field "sSeconds" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sSeconds".
     */
    inline ::fi_basetypes_most::T_String& getSSecondsMutable ();

    /**
     * Sets the value of the member "sSeconds".
     *
     * Identifies the seconds; 99 = unknown.
     *
     * @param sSeconds The value which will be set
     */
    inline void setSSeconds (const ::fi_basetypes_most::T_String& sSeconds_);

    static const T_MsgMessageTime &getDefaultInstance();

private:

    inline void set_has_sHours ();

    inline void clear_has_sHours ();

    inline void set_has_sMinutes ();

    inline void clear_has_sMinutes ();

    inline void set_has_sSeconds ();

    inline void clear_has_sSeconds ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::fi_basetypes_most::T_String _sHours;

    ::fi_basetypes_most::T_String _sMinutes;

    ::fi_basetypes_most::T_String _sSeconds;

};

class T_MsgMessageDateTime {
public:

    /**
     * Default constructor
     */
    inline  T_MsgMessageDateTime ();

    /**
     * Copy constructor
     */
    inline  T_MsgMessageDateTime (const T_MsgMessageDateTime &rhs);

    /**
     * All fields constructor
     */
    inline  T_MsgMessageDateTime (const T_MsgMessageDate& oMessageDate_, const T_MsgMessageTime& oMessageTime_);

    /**
     * Destructor
     */
    inline  ~T_MsgMessageDateTime();

    /**
     * Assignment operator
     */
    inline T_MsgMessageDateTime& operator = (const T_MsgMessageDateTime& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_MsgMessageDateTime& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_MsgMessageDateTime& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_MsgMessageDateTime& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_MsgMessageDateTime& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oMessageDate"

    static const int kOMessageDate = 0;

    /**
     * Clears the field "oMessageDate".
     *
     * The field will be set to its default value. The hasOMessageDate()
     * method will return false.
     */
    inline void clearOMessageDate();

    /**
     * Checks whether the field "oMessageDate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOMessageDate()). Otherwise it will return false.
     */
    inline bool hasOMessageDate () const;

    /**
     * Returns the value of the member "oMessageDate".
     *
     * Date of the message.Formatted as YYYYMMDD where YYYY = CldrYear; MM = CldrMonth; DD = CldrDay
     *
     * @return The value of the field "oMessageDate"
     */
    inline const T_MsgMessageDate& getOMessageDate () const;

    /**
     * Retrieves the value of the field "oMessageDate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oMessageDate".
     */
    inline T_MsgMessageDate& getOMessageDateMutable ();

    /**
     * Sets the value of the member "oMessageDate".
     *
     * Date of the message.Formatted as YYYYMMDD where YYYY = CldrYear; MM = CldrMonth; DD = CldrDay
     *
     * @param oMessageDate The value which will be set
     */
    inline void setOMessageDate (const T_MsgMessageDate& oMessageDate_);

    // API of field "oMessageTime"

    static const int kOMessageTime = 1;

    /**
     * Clears the field "oMessageTime".
     *
     * The field will be set to its default value. The hasOMessageTime()
     * method will return false.
     */
    inline void clearOMessageTime();

    /**
     * Checks whether the field "oMessageTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOMessageTime()). Otherwise it will return false.
     */
    inline bool hasOMessageTime () const;

    /**
     * Returns the value of the member "oMessageTime".
     *
     * Time of the message.Formated as 24 hour mode.Formatted as HHMMSS where HH = Hours; MM = Minutes; SS = Seconds.
     *
     * @return The value of the field "oMessageTime"
     */
    inline const T_MsgMessageTime& getOMessageTime () const;

    /**
     * Retrieves the value of the field "oMessageTime" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oMessageTime".
     */
    inline T_MsgMessageTime& getOMessageTimeMutable ();

    /**
     * Sets the value of the member "oMessageTime".
     *
     * Time of the message.Formated as 24 hour mode.Formatted as HHMMSS where HH = Hours; MM = Minutes; SS = Seconds.
     *
     * @param oMessageTime The value which will be set
     */
    inline void setOMessageTime (const T_MsgMessageTime& oMessageTime_);

    static const T_MsgMessageDateTime &getDefaultInstance();

private:

    inline void set_has_oMessageDate ();

    inline void clear_has_oMessageDate ();

    inline void set_has_oMessageTime ();

    inline void clear_has_oMessageTime ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_MsgMessageDate _oMessageDate;

    T_MsgMessageTime _oMessageTime;

};

class T_MsgMessageListSliceResultItem {
public:

    /**
     * Default constructor
     */
    inline  T_MsgMessageListSliceResultItem ();

    /**
     * Copy constructor
     */
    inline  T_MsgMessageListSliceResultItem (const T_MsgMessageListSliceResultItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_MsgMessageListSliceResultItem (const T_MsgMessageHandle& oMessageHandle_, const T_MsgMessageDateTime& oMessageDateTime_, const ::fi_basetypes_most::T_String& sSubject_, const ::fi_basetypes_most::T_String& sShortMessage_, bool bAttachmentFlag_, T_e8_MsgMessageType e8MessageType_, T_e8_MsgSendMessageResultType e8SendMessageResultType_, bool bReadStatusFlag_, const ::fi_basetypes_most::T_String& sFirstName_, const ::fi_basetypes_most::T_String& sLastName_, const ::fi_basetypes_most::T_String& sEmailAddress_, const ::fi_basetypes_most::T_String& sPhoneNumber_, uint32 u32ContactHandle_, T_e8_MsgPlaybackState e8PlaybackState_);

    /**
     * Destructor
     */
    inline  ~T_MsgMessageListSliceResultItem();

    /**
     * Assignment operator
     */
    inline T_MsgMessageListSliceResultItem& operator = (const T_MsgMessageListSliceResultItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_MsgMessageListSliceResultItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_MsgMessageListSliceResultItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_MsgMessageListSliceResultItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_MsgMessageListSliceResultItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oMessageHandle"

    static const int kOMessageHandle = 0;

    /**
     * Clears the field "oMessageHandle".
     *
     * The field will be set to its default value. The hasOMessageHandle()
     * method will return false.
     */
    inline void clearOMessageHandle();

    /**
     * Checks whether the field "oMessageHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOMessageHandle()). Otherwise it will return false.
     */
    inline bool hasOMessageHandle () const;

    /**
     * Returns the value of the member "oMessageHandle".
     *
     * This is the globally unique ID for a particular message. The ID is unique across all currently connected devices and accounts.It is made up of the DeviceHandle, MsgHandleUpper, and MsgHandleLower.
     *
     * @return The value of the field "oMessageHandle"
     */
    inline const T_MsgMessageHandle& getOMessageHandle () const;

    /**
     * Retrieves the value of the field "oMessageHandle" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oMessageHandle".
     */
    inline T_MsgMessageHandle& getOMessageHandleMutable ();

    /**
     * Sets the value of the member "oMessageHandle".
     *
     * This is the globally unique ID for a particular message. The ID is unique across all currently connected devices and accounts.It is made up of the DeviceHandle, MsgHandleUpper, and MsgHandleLower.
     *
     * @param oMessageHandle The value which will be set
     */
    inline void setOMessageHandle (const T_MsgMessageHandle& oMessageHandle_);

    // API of field "oMessageDateTime"

    static const int kOMessageDateTime = 1;

    /**
     * Clears the field "oMessageDateTime".
     *
     * The field will be set to its default value. The hasOMessageDateTime()
     * method will return false.
     */
    inline void clearOMessageDateTime();

    /**
     * Checks whether the field "oMessageDateTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOMessageDateTime()). Otherwise it will return false.
     */
    inline bool hasOMessageDateTime () const;

    /**
     * Returns the value of the member "oMessageDateTime".
     *
     * The message date and time formatted as YYYYMMDDHHMMSS. The MessageDateTime is made up of the MessageDate stream and the MessageTime stream.
     *
     * @return The value of the field "oMessageDateTime"
     */
    inline const T_MsgMessageDateTime& getOMessageDateTime () const;

    /**
     * Retrieves the value of the field "oMessageDateTime" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oMessageDateTime".
     */
    inline T_MsgMessageDateTime& getOMessageDateTimeMutable ();

    /**
     * Sets the value of the member "oMessageDateTime".
     *
     * The message date and time formatted as YYYYMMDDHHMMSS. The MessageDateTime is made up of the MessageDate stream and the MessageTime stream.
     *
     * @param oMessageDateTime The value which will be set
     */
    inline void setOMessageDateTime (const T_MsgMessageDateTime& oMessageDateTime_);

    // API of field "sSubject"

    static const int kSSubject = 2;

    /**
     * Clears the field "sSubject".
     *
     * The field will be set to its default value. The hasSSubject()
     * method will return false.
     */
    inline void clearSSubject();

    /**
     * Checks whether the field "sSubject" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSSubject()). Otherwise it will return false.
     */
    inline bool hasSSubject () const;

    /**
     * Returns the value of the member "sSubject".
     *
     * The subject of the email message.
     *
     * @return The value of the field "sSubject"
     */
    inline const ::fi_basetypes_most::T_String& getSSubject () const;

    /**
     * Retrieves the value of the field "sSubject" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sSubject".
     */
    inline ::fi_basetypes_most::T_String& getSSubjectMutable ();

    /**
     * Sets the value of the member "sSubject".
     *
     * The subject of the email message.
     *
     * @param sSubject The value which will be set
     */
    inline void setSSubject (const ::fi_basetypes_most::T_String& sSubject_);

    // API of field "sShortMessage"

    static const int kSShortMessage = 3;

    /**
     * Clears the field "sShortMessage".
     *
     * The field will be set to its default value. The hasSShortMessage()
     * method will return false.
     */
    inline void clearSShortMessage();

    /**
     * Checks whether the field "sShortMessage" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSShortMessage()). Otherwise it will return false.
     */
    inline bool hasSShortMessage () const;

    /**
     * Returns the value of the member "sShortMessage".
     *
     * Provides the message content of an SMS or MMS message. Limited to 160 characters.
     *
     * @return The value of the field "sShortMessage"
     */
    inline const ::fi_basetypes_most::T_String& getSShortMessage () const;

    /**
     * Retrieves the value of the field "sShortMessage" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sShortMessage".
     */
    inline ::fi_basetypes_most::T_String& getSShortMessageMutable ();

    /**
     * Sets the value of the member "sShortMessage".
     *
     * Provides the message content of an SMS or MMS message. Limited to 160 characters.
     *
     * @param sShortMessage The value which will be set
     */
    inline void setSShortMessage (const ::fi_basetypes_most::T_String& sShortMessage_);

    // API of field "bAttachmentFlag"

    static const int kBAttachmentFlag = 4;

    /**
     * Clears the field "bAttachmentFlag".
     *
     * The field will be set to its default value. The hasBAttachmentFlag()
     * method will return false.
     */
    inline void clearBAttachmentFlag();

    /**
     * Checks whether the field "bAttachmentFlag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBAttachmentFlag()). Otherwise it will return false.
     */
    inline bool hasBAttachmentFlag () const;

    /**
     * Returns the value of the member "bAttachmentFlag".
     *
     * Set if there is at least one attachment in a particular message.
     *
     * @return The value of the field "bAttachmentFlag"
     */
    inline bool getBAttachmentFlag () const;

    /**
     * Sets the value of the member "bAttachmentFlag".
     *
     * Set if there is at least one attachment in a particular message.
     *
     * @param bAttachmentFlag The value which will be set
     */
    inline void setBAttachmentFlag (bool bAttachmentFlag_);

    // API of field "e8MessageType"

    static const int kE8MessageType = 5;

    /**
     * Clears the field "e8MessageType".
     *
     * The field will be set to its default value. The hasE8MessageType()
     * method will return false.
     */
    inline void clearE8MessageType();

    /**
     * Checks whether the field "e8MessageType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MessageType()). Otherwise it will return false.
     */
    inline bool hasE8MessageType () const;

    /**
     * Returns the value of the member "e8MessageType".
     *
     * Identifies the type of message: SMS, MMS, or Email.
     *
     * @return The value of the field "e8MessageType"
     */
    inline T_e8_MsgMessageType getE8MessageType () const;

    /**
     * Sets the value of the member "e8MessageType".
     *
     * Identifies the type of message: SMS, MMS, or Email.
     *
     * @param e8MessageType The value which will be set
     */
    inline void setE8MessageType (T_e8_MsgMessageType e8MessageType_);

    // API of field "e8SendMessageResultType"

    static const int kE8SendMessageResultType = 6;

    /**
     * Clears the field "e8SendMessageResultType".
     *
     * The field will be set to its default value. The hasE8SendMessageResultType()
     * method will return false.
     */
    inline void clearE8SendMessageResultType();

    /**
     * Checks whether the field "e8SendMessageResultType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8SendMessageResultType()). Otherwise it will return false.
     */
    inline bool hasE8SendMessageResultType () const;

    /**
     * Returns the value of the member "e8SendMessageResultType".
     *
     *
     *
     * @return The value of the field "e8SendMessageResultType"
     */
    inline T_e8_MsgSendMessageResultType getE8SendMessageResultType () const;

    /**
     * Sets the value of the member "e8SendMessageResultType".
     *
     *
     *
     * @param e8SendMessageResultType The value which will be set
     */
    inline void setE8SendMessageResultType (T_e8_MsgSendMessageResultType e8SendMessageResultType_);

    // API of field "bReadStatusFlag"

    static const int kBReadStatusFlag = 7;

    /**
     * Clears the field "bReadStatusFlag".
     *
     * The field will be set to its default value. The hasBReadStatusFlag()
     * method will return false.
     */
    inline void clearBReadStatusFlag();

    /**
     * Checks whether the field "bReadStatusFlag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBReadStatusFlag()). Otherwise it will return false.
     */
    inline bool hasBReadStatusFlag () const;

    /**
     * Returns the value of the member "bReadStatusFlag".
     *
     * Indicates whether the message has been read or not.
     *
     * @return The value of the field "bReadStatusFlag"
     */
    inline bool getBReadStatusFlag () const;

    /**
     * Sets the value of the member "bReadStatusFlag".
     *
     * Indicates whether the message has been read or not.
     *
     * @param bReadStatusFlag The value which will be set
     */
    inline void setBReadStatusFlag (bool bReadStatusFlag_);

    // API of field "sFirstName"

    static const int kSFirstName = 8;

    /**
     * Clears the field "sFirstName".
     *
     * The field will be set to its default value. The hasSFirstName()
     * method will return false.
     */
    inline void clearSFirstName();

    /**
     * Checks whether the field "sFirstName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSFirstName()). Otherwise it will return false.
     */
    inline bool hasSFirstName () const;

    /**
     * Returns the value of the member "sFirstName".
     *
     *
     *
     * @return The value of the field "sFirstName"
     */
    inline const ::fi_basetypes_most::T_String& getSFirstName () const;

    /**
     * Retrieves the value of the field "sFirstName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sFirstName".
     */
    inline ::fi_basetypes_most::T_String& getSFirstNameMutable ();

    /**
     * Sets the value of the member "sFirstName".
     *
     *
     *
     * @param sFirstName The value which will be set
     */
    inline void setSFirstName (const ::fi_basetypes_most::T_String& sFirstName_);

    // API of field "sLastName"

    static const int kSLastName = 9;

    /**
     * Clears the field "sLastName".
     *
     * The field will be set to its default value. The hasSLastName()
     * method will return false.
     */
    inline void clearSLastName();

    /**
     * Checks whether the field "sLastName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSLastName()). Otherwise it will return false.
     */
    inline bool hasSLastName () const;

    /**
     * Returns the value of the member "sLastName".
     *
     *
     *
     * @return The value of the field "sLastName"
     */
    inline const ::fi_basetypes_most::T_String& getSLastName () const;

    /**
     * Retrieves the value of the field "sLastName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sLastName".
     */
    inline ::fi_basetypes_most::T_String& getSLastNameMutable ();

    /**
     * Sets the value of the member "sLastName".
     *
     *
     *
     * @param sLastName The value which will be set
     */
    inline void setSLastName (const ::fi_basetypes_most::T_String& sLastName_);

    // API of field "sEmailAddress"

    static const int kSEmailAddress = 10;

    /**
     * Clears the field "sEmailAddress".
     *
     * The field will be set to its default value. The hasSEmailAddress()
     * method will return false.
     */
    inline void clearSEmailAddress();

    /**
     * Checks whether the field "sEmailAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSEmailAddress()). Otherwise it will return false.
     */
    inline bool hasSEmailAddress () const;

    /**
     * Returns the value of the member "sEmailAddress".
     *
     *
     *
     * @return The value of the field "sEmailAddress"
     */
    inline const ::fi_basetypes_most::T_String& getSEmailAddress () const;

    /**
     * Retrieves the value of the field "sEmailAddress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sEmailAddress".
     */
    inline ::fi_basetypes_most::T_String& getSEmailAddressMutable ();

    /**
     * Sets the value of the member "sEmailAddress".
     *
     *
     *
     * @param sEmailAddress The value which will be set
     */
    inline void setSEmailAddress (const ::fi_basetypes_most::T_String& sEmailAddress_);

    // API of field "sPhoneNumber"

    static const int kSPhoneNumber = 11;

    /**
     * Clears the field "sPhoneNumber".
     *
     * The field will be set to its default value. The hasSPhoneNumber()
     * method will return false.
     */
    inline void clearSPhoneNumber();

    /**
     * Checks whether the field "sPhoneNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSPhoneNumber()). Otherwise it will return false.
     */
    inline bool hasSPhoneNumber () const;

    /**
     * Returns the value of the member "sPhoneNumber".
     *
     *
     *
     * @return The value of the field "sPhoneNumber"
     */
    inline const ::fi_basetypes_most::T_String& getSPhoneNumber () const;

    /**
     * Retrieves the value of the field "sPhoneNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sPhoneNumber".
     */
    inline ::fi_basetypes_most::T_String& getSPhoneNumberMutable ();

    /**
     * Sets the value of the member "sPhoneNumber".
     *
     *
     *
     * @param sPhoneNumber The value which will be set
     */
    inline void setSPhoneNumber (const ::fi_basetypes_most::T_String& sPhoneNumber_);

    // API of field "u32ContactHandle"

    static const int kU32ContactHandle = 12;

    /**
     * Clears the field "u32ContactHandle".
     *
     * The field will be set to its default value. The hasU32ContactHandle()
     * method will return false.
     */
    inline void clearU32ContactHandle();

    /**
     * Checks whether the field "u32ContactHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ContactHandle()). Otherwise it will return false.
     */
    inline bool hasU32ContactHandle () const;

    /**
     * Returns the value of the member "u32ContactHandle".
     *
     *
     *
     * @return The value of the field "u32ContactHandle"
     */
    inline uint32 getU32ContactHandle () const;

    /**
     * Sets the value of the member "u32ContactHandle".
     *
     *
     *
     * @param u32ContactHandle The value which will be set
     */
    inline void setU32ContactHandle (uint32 u32ContactHandle_);

    // API of field "e8PlaybackState"

    static const int kE8PlaybackState = 13;

    /**
     * Clears the field "e8PlaybackState".
     *
     * The field will be set to its default value. The hasE8PlaybackState()
     * method will return false.
     */
    inline void clearE8PlaybackState();

    /**
     * Checks whether the field "e8PlaybackState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8PlaybackState()). Otherwise it will return false.
     */
    inline bool hasE8PlaybackState () const;

    /**
     * Returns the value of the member "e8PlaybackState".
     *
     *
     *
     * @return The value of the field "e8PlaybackState"
     */
    inline T_e8_MsgPlaybackState getE8PlaybackState () const;

    /**
     * Sets the value of the member "e8PlaybackState".
     *
     *
     *
     * @param e8PlaybackState The value which will be set
     */
    inline void setE8PlaybackState (T_e8_MsgPlaybackState e8PlaybackState_);

    static const T_MsgMessageListSliceResultItem &getDefaultInstance();

private:

    inline void set_has_oMessageHandle ();

    inline void clear_has_oMessageHandle ();

    inline void set_has_oMessageDateTime ();

    inline void clear_has_oMessageDateTime ();

    inline void set_has_sSubject ();

    inline void clear_has_sSubject ();

    inline void set_has_sShortMessage ();

    inline void clear_has_sShortMessage ();

    inline void set_has_bAttachmentFlag ();

    inline void clear_has_bAttachmentFlag ();

    inline void set_has_e8MessageType ();

    inline void clear_has_e8MessageType ();

    inline void set_has_e8SendMessageResultType ();

    inline void clear_has_e8SendMessageResultType ();

    inline void set_has_bReadStatusFlag ();

    inline void clear_has_bReadStatusFlag ();

    inline void set_has_sFirstName ();

    inline void clear_has_sFirstName ();

    inline void set_has_sLastName ();

    inline void clear_has_sLastName ();

    inline void set_has_sEmailAddress ();

    inline void clear_has_sEmailAddress ();

    inline void set_has_sPhoneNumber ();

    inline void clear_has_sPhoneNumber ();

    inline void set_has_u32ContactHandle ();

    inline void clear_has_u32ContactHandle ();

    inline void set_has_e8PlaybackState ();

    inline void clear_has_e8PlaybackState ();

    uint32 _has_bits_[ (14 + 31) / 32];

    T_MsgMessageHandle _oMessageHandle;

    T_MsgMessageDateTime _oMessageDateTime;

    ::fi_basetypes_most::T_String _sSubject;

    ::fi_basetypes_most::T_String _sShortMessage;

    bool _bAttachmentFlag;

    T_e8_MsgMessageType _e8MessageType;

    T_e8_MsgSendMessageResultType _e8SendMessageResultType;

    bool _bReadStatusFlag;

    ::fi_basetypes_most::T_String _sFirstName;

    ::fi_basetypes_most::T_String _sLastName;

    ::fi_basetypes_most::T_String _sEmailAddress;

    ::fi_basetypes_most::T_String _sPhoneNumber;

    uint32 _u32ContactHandle;

    T_e8_MsgPlaybackState _e8PlaybackState;

};

class T_MsgFolderListResultItem {
public:

    /**
     * Default constructor
     */
    inline  T_MsgFolderListResultItem ();

    /**
     * Copy constructor
     */
    inline  T_MsgFolderListResultItem (const T_MsgFolderListResultItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_MsgFolderListResultItem (uint32 u32FolderHandle_, const ::fi_basetypes_most::T_String& sFolderName_, T_e8_MsgFolderType e8FolderType_, uint8 u8NumSubfolders_, uint16 u16NumMessages_, uint16 u16NumUnreadMessages_);

    /**
     * Destructor
     */
    inline  ~T_MsgFolderListResultItem();

    /**
     * Assignment operator
     */
    inline T_MsgFolderListResultItem& operator = (const T_MsgFolderListResultItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_MsgFolderListResultItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_MsgFolderListResultItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_MsgFolderListResultItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_MsgFolderListResultItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32FolderHandle"

    static const int kU32FolderHandle = 0;

    /**
     * Clears the field "u32FolderHandle".
     *
     * The field will be set to its default value. The hasU32FolderHandle()
     * method will return false.
     */
    inline void clearU32FolderHandle();

    /**
     * Checks whether the field "u32FolderHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32FolderHandle()). Otherwise it will return false.
     */
    inline bool hasU32FolderHandle () const;

    /**
     * Returns the value of the member "u32FolderHandle".
     *
     * This is the unique handle for a particular folder.
     *
     * @return The value of the field "u32FolderHandle"
     */
    inline uint32 getU32FolderHandle () const;

    /**
     * Sets the value of the member "u32FolderHandle".
     *
     * This is the unique handle for a particular folder.
     *
     * @param u32FolderHandle The value which will be set
     */
    inline void setU32FolderHandle (uint32 u32FolderHandle_);

    // API of field "sFolderName"

    static const int kSFolderName = 1;

    /**
     * Clears the field "sFolderName".
     *
     * The field will be set to its default value. The hasSFolderName()
     * method will return false.
     */
    inline void clearSFolderName();

    /**
     * Checks whether the field "sFolderName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSFolderName()). Otherwise it will return false.
     */
    inline bool hasSFolderName () const;

    /**
     * Returns the value of the member "sFolderName".
     *
     * Name of the folder.
     *
     * @return The value of the field "sFolderName"
     */
    inline const ::fi_basetypes_most::T_String& getSFolderName () const;

    /**
     * Retrieves the value of the field "sFolderName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sFolderName".
     */
    inline ::fi_basetypes_most::T_String& getSFolderNameMutable ();

    /**
     * Sets the value of the member "sFolderName".
     *
     * Name of the folder.
     *
     * @param sFolderName The value which will be set
     */
    inline void setSFolderName (const ::fi_basetypes_most::T_String& sFolderName_);

    // API of field "e8FolderType"

    static const int kE8FolderType = 2;

    /**
     * Clears the field "e8FolderType".
     *
     * The field will be set to its default value. The hasE8FolderType()
     * method will return false.
     */
    inline void clearE8FolderType();

    /**
     * Checks whether the field "e8FolderType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8FolderType()). Otherwise it will return false.
     */
    inline bool hasE8FolderType () const;

    /**
     * Returns the value of the member "e8FolderType".
     *
     * Defines the type of folder: Inbox, Deleted, Drafts, Sent, User defined, and inaccessible.
     * The user defined folders require the FolderName to identify the name of the folder.
     * The inaccessible folders are cannot be accessed from the vehicle.
     *
     * @return The value of the field "e8FolderType"
     */
    inline T_e8_MsgFolderType getE8FolderType () const;

    /**
     * Sets the value of the member "e8FolderType".
     *
     * Defines the type of folder: Inbox, Deleted, Drafts, Sent, User defined, and inaccessible.
     * The user defined folders require the FolderName to identify the name of the folder.
     * The inaccessible folders are cannot be accessed from the vehicle.
     *
     * @param e8FolderType The value which will be set
     */
    inline void setE8FolderType (T_e8_MsgFolderType e8FolderType_);

    // API of field "u8NumSubfolders"

    static const int kU8NumSubfolders = 3;

    /**
     * Clears the field "u8NumSubfolders".
     *
     * The field will be set to its default value. The hasU8NumSubfolders()
     * method will return false.
     */
    inline void clearU8NumSubfolders();

    /**
     * Checks whether the field "u8NumSubfolders" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8NumSubfolders()). Otherwise it will return false.
     */
    inline bool hasU8NumSubfolders () const;

    /**
     * Returns the value of the member "u8NumSubfolders".
     *
     * This is the number of subfolders within a particular folder
     *
     * @return The value of the field "u8NumSubfolders"
     */
    inline uint8 getU8NumSubfolders () const;

    /**
     * Sets the value of the member "u8NumSubfolders".
     *
     * This is the number of subfolders within a particular folder
     *
     * @param u8NumSubfolders The value which will be set
     */
    inline void setU8NumSubfolders (uint8 u8NumSubfolders_);

    // API of field "u16NumMessages"

    static const int kU16NumMessages = 4;

    /**
     * Clears the field "u16NumMessages".
     *
     * The field will be set to its default value. The hasU16NumMessages()
     * method will return false.
     */
    inline void clearU16NumMessages();

    /**
     * Checks whether the field "u16NumMessages" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16NumMessages()). Otherwise it will return false.
     */
    inline bool hasU16NumMessages () const;

    /**
     * Returns the value of the member "u16NumMessages".
     *
     * This is the total number of messages in a folder (not including the subfolder count).
     *
     * @return The value of the field "u16NumMessages"
     */
    inline uint16 getU16NumMessages () const;

    /**
     * Sets the value of the member "u16NumMessages".
     *
     * This is the total number of messages in a folder (not including the subfolder count).
     *
     * @param u16NumMessages The value which will be set
     */
    inline void setU16NumMessages (uint16 u16NumMessages_);

    // API of field "u16NumUnreadMessages"

    static const int kU16NumUnreadMessages = 5;

    /**
     * Clears the field "u16NumUnreadMessages".
     *
     * The field will be set to its default value. The hasU16NumUnreadMessages()
     * method will return false.
     */
    inline void clearU16NumUnreadMessages();

    /**
     * Checks whether the field "u16NumUnreadMessages" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16NumUnreadMessages()). Otherwise it will return false.
     */
    inline bool hasU16NumUnreadMessages () const;

    /**
     * Returns the value of the member "u16NumUnreadMessages".
     *
     * This is the number of unread messages within a particular folder or list.
     *
     * @return The value of the field "u16NumUnreadMessages"
     */
    inline uint16 getU16NumUnreadMessages () const;

    /**
     * Sets the value of the member "u16NumUnreadMessages".
     *
     * This is the number of unread messages within a particular folder or list.
     *
     * @param u16NumUnreadMessages The value which will be set
     */
    inline void setU16NumUnreadMessages (uint16 u16NumUnreadMessages_);

    static const T_MsgFolderListResultItem &getDefaultInstance();

private:

    inline void set_has_u32FolderHandle ();

    inline void clear_has_u32FolderHandle ();

    inline void set_has_sFolderName ();

    inline void clear_has_sFolderName ();

    inline void set_has_e8FolderType ();

    inline void clear_has_e8FolderType ();

    inline void set_has_u8NumSubfolders ();

    inline void clear_has_u8NumSubfolders ();

    inline void set_has_u16NumMessages ();

    inline void clear_has_u16NumMessages ();

    inline void set_has_u16NumUnreadMessages ();

    inline void clear_has_u16NumUnreadMessages ();

    uint32 _has_bits_[ (6 + 31) / 32];

    uint32 _u32FolderHandle;

    ::fi_basetypes_most::T_String _sFolderName;

    T_e8_MsgFolderType _e8FolderType;

    uint8 _u8NumSubfolders;

    uint16 _u16NumMessages;

    uint16 _u16NumUnreadMessages;

};

class T_MsgAccountListResultItem {
public:

    /**
     * Default constructor
     */
    inline  T_MsgAccountListResultItem ();

    /**
     * Copy constructor
     */
    inline  T_MsgAccountListResultItem (const T_MsgAccountListResultItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_MsgAccountListResultItem (uint16 u16AccountHandle_, const ::fi_basetypes_most::T_String& sAccountName_, bool bActiveAccountStatus_);

    /**
     * Destructor
     */
    inline  ~T_MsgAccountListResultItem();

    /**
     * Assignment operator
     */
    inline T_MsgAccountListResultItem& operator = (const T_MsgAccountListResultItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_MsgAccountListResultItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_MsgAccountListResultItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_MsgAccountListResultItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_MsgAccountListResultItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16AccountHandle"

    static const int kU16AccountHandle = 0;

    /**
     * Clears the field "u16AccountHandle".
     *
     * The field will be set to its default value. The hasU16AccountHandle()
     * method will return false.
     */
    inline void clearU16AccountHandle();

    /**
     * Checks whether the field "u16AccountHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16AccountHandle()). Otherwise it will return false.
     */
    inline bool hasU16AccountHandle () const;

    /**
     * Returns the value of the member "u16AccountHandle".
     *
     * This is the globally unique ID for a particular account.  The ID is unique across all currently connected devices.
     *
     * @return The value of the field "u16AccountHandle"
     */
    inline uint16 getU16AccountHandle () const;

    /**
     * Sets the value of the member "u16AccountHandle".
     *
     * This is the globally unique ID for a particular account.  The ID is unique across all currently connected devices.
     *
     * @param u16AccountHandle The value which will be set
     */
    inline void setU16AccountHandle (uint16 u16AccountHandle_);

    // API of field "sAccountName"

    static const int kSAccountName = 1;

    /**
     * Clears the field "sAccountName".
     *
     * The field will be set to its default value. The hasSAccountName()
     * method will return false.
     */
    inline void clearSAccountName();

    /**
     * Checks whether the field "sAccountName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSAccountName()). Otherwise it will return false.
     */
    inline bool hasSAccountName () const;

    /**
     * Returns the value of the member "sAccountName".
     *
     * The name of the email account.
     *
     * @return The value of the field "sAccountName"
     */
    inline const ::fi_basetypes_most::T_String& getSAccountName () const;

    /**
     * Retrieves the value of the field "sAccountName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sAccountName".
     */
    inline ::fi_basetypes_most::T_String& getSAccountNameMutable ();

    /**
     * Sets the value of the member "sAccountName".
     *
     * The name of the email account.
     *
     * @param sAccountName The value which will be set
     */
    inline void setSAccountName (const ::fi_basetypes_most::T_String& sAccountName_);

    // API of field "bActiveAccountStatus"

    static const int kBActiveAccountStatus = 2;

    /**
     * Clears the field "bActiveAccountStatus".
     *
     * The field will be set to its default value. The hasBActiveAccountStatus()
     * method will return false.
     */
    inline void clearBActiveAccountStatus();

    /**
     * Checks whether the field "bActiveAccountStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBActiveAccountStatus()). Otherwise it will return false.
     */
    inline bool hasBActiveAccountStatus () const;

    /**
     * Returns the value of the member "bActiveAccountStatus".
     *
     * Identifies if the account is the currently active account or not.
     *
     * @return The value of the field "bActiveAccountStatus"
     */
    inline bool getBActiveAccountStatus () const;

    /**
     * Sets the value of the member "bActiveAccountStatus".
     *
     * Identifies if the account is the currently active account or not.
     *
     * @param bActiveAccountStatus The value which will be set
     */
    inline void setBActiveAccountStatus (bool bActiveAccountStatus_);

    static const T_MsgAccountListResultItem &getDefaultInstance();

private:

    inline void set_has_u16AccountHandle ();

    inline void clear_has_u16AccountHandle ();

    inline void set_has_sAccountName ();

    inline void clear_has_sAccountName ();

    inline void set_has_bActiveAccountStatus ();

    inline void clear_has_bActiveAccountStatus ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint16 _u16AccountHandle;

    ::fi_basetypes_most::T_String _sAccountName;

    bool _bActiveAccountStatus;

};

class T_MsgActiveAccount {
public:

    /**
     * Default constructor
     */
    inline  T_MsgActiveAccount ();

    /**
     * Copy constructor
     */
    inline  T_MsgActiveAccount (const T_MsgActiveAccount &rhs);

    /**
     * All fields constructor
     */
    inline  T_MsgActiveAccount (uint16 u16AccountHandle_, const ::fi_basetypes_most::T_String& sAccountName_);

    /**
     * Destructor
     */
    inline  ~T_MsgActiveAccount();

    /**
     * Assignment operator
     */
    inline T_MsgActiveAccount& operator = (const T_MsgActiveAccount& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_MsgActiveAccount& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_MsgActiveAccount& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_MsgActiveAccount& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_MsgActiveAccount& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16AccountHandle"

    static const int kU16AccountHandle = 0;

    /**
     * Clears the field "u16AccountHandle".
     *
     * The field will be set to its default value. The hasU16AccountHandle()
     * method will return false.
     */
    inline void clearU16AccountHandle();

    /**
     * Checks whether the field "u16AccountHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16AccountHandle()). Otherwise it will return false.
     */
    inline bool hasU16AccountHandle () const;

    /**
     * Returns the value of the member "u16AccountHandle".
     *
     * This is the globally unique ID for a particular account.  The ID is unique across all currently connected devices.
     *
     * @return The value of the field "u16AccountHandle"
     */
    inline uint16 getU16AccountHandle () const;

    /**
     * Sets the value of the member "u16AccountHandle".
     *
     * This is the globally unique ID for a particular account.  The ID is unique across all currently connected devices.
     *
     * @param u16AccountHandle The value which will be set
     */
    inline void setU16AccountHandle (uint16 u16AccountHandle_);

    // API of field "sAccountName"

    static const int kSAccountName = 1;

    /**
     * Clears the field "sAccountName".
     *
     * The field will be set to its default value. The hasSAccountName()
     * method will return false.
     */
    inline void clearSAccountName();

    /**
     * Checks whether the field "sAccountName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSAccountName()). Otherwise it will return false.
     */
    inline bool hasSAccountName () const;

    /**
     * Returns the value of the member "sAccountName".
     *
     * The name of the email account.
     *
     * @return The value of the field "sAccountName"
     */
    inline const ::fi_basetypes_most::T_String& getSAccountName () const;

    /**
     * Retrieves the value of the field "sAccountName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sAccountName".
     */
    inline ::fi_basetypes_most::T_String& getSAccountNameMutable ();

    /**
     * Sets the value of the member "sAccountName".
     *
     * The name of the email account.
     *
     * @param sAccountName The value which will be set
     */
    inline void setSAccountName (const ::fi_basetypes_most::T_String& sAccountName_);

    static const T_MsgActiveAccount &getDefaultInstance();

private:

    inline void set_has_u16AccountHandle ();

    inline void clear_has_u16AccountHandle ();

    inline void set_has_sAccountName ();

    inline void clear_has_sAccountName ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _u16AccountHandle;

    ::fi_basetypes_most::T_String _sAccountName;

};

class T_MsgAddressFieldItem {
public:

    /**
     * Default constructor
     */
    inline  T_MsgAddressFieldItem ();

    /**
     * Copy constructor
     */
    inline  T_MsgAddressFieldItem (const T_MsgAddressFieldItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_MsgAddressFieldItem (T_e8_MsgAddressFieldType e8AddressFieldType_, const ::fi_basetypes_most::T_String& sFirstName_, const ::fi_basetypes_most::T_String& sLastName_, const ::fi_basetypes_most::T_String& sEmailAddress_, const ::fi_basetypes_most::T_String& sPhoneNumber_);

    /**
     * Destructor
     */
    inline  ~T_MsgAddressFieldItem();

    /**
     * Assignment operator
     */
    inline T_MsgAddressFieldItem& operator = (const T_MsgAddressFieldItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_MsgAddressFieldItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_MsgAddressFieldItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_MsgAddressFieldItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_MsgAddressFieldItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8AddressFieldType"

    static const int kE8AddressFieldType = 0;

    /**
     * Clears the field "e8AddressFieldType".
     *
     * The field will be set to its default value. The hasE8AddressFieldType()
     * method will return false.
     */
    inline void clearE8AddressFieldType();

    /**
     * Checks whether the field "e8AddressFieldType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8AddressFieldType()). Otherwise it will return false.
     */
    inline bool hasE8AddressFieldType () const;

    /**
     * Returns the value of the member "e8AddressFieldType".
     *
     * Identifies if the address field type is: From, To, or CC
     *
     * @return The value of the field "e8AddressFieldType"
     */
    inline T_e8_MsgAddressFieldType getE8AddressFieldType () const;

    /**
     * Sets the value of the member "e8AddressFieldType".
     *
     * Identifies if the address field type is: From, To, or CC
     *
     * @param e8AddressFieldType The value which will be set
     */
    inline void setE8AddressFieldType (T_e8_MsgAddressFieldType e8AddressFieldType_);

    // API of field "sFirstName"

    static const int kSFirstName = 1;

    /**
     * Clears the field "sFirstName".
     *
     * The field will be set to its default value. The hasSFirstName()
     * method will return false.
     */
    inline void clearSFirstName();

    /**
     * Checks whether the field "sFirstName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSFirstName()). Otherwise it will return false.
     */
    inline bool hasSFirstName () const;

    /**
     * Returns the value of the member "sFirstName".
     *
     *
     *
     * @return The value of the field "sFirstName"
     */
    inline const ::fi_basetypes_most::T_String& getSFirstName () const;

    /**
     * Retrieves the value of the field "sFirstName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sFirstName".
     */
    inline ::fi_basetypes_most::T_String& getSFirstNameMutable ();

    /**
     * Sets the value of the member "sFirstName".
     *
     *
     *
     * @param sFirstName The value which will be set
     */
    inline void setSFirstName (const ::fi_basetypes_most::T_String& sFirstName_);

    // API of field "sLastName"

    static const int kSLastName = 2;

    /**
     * Clears the field "sLastName".
     *
     * The field will be set to its default value. The hasSLastName()
     * method will return false.
     */
    inline void clearSLastName();

    /**
     * Checks whether the field "sLastName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSLastName()). Otherwise it will return false.
     */
    inline bool hasSLastName () const;

    /**
     * Returns the value of the member "sLastName".
     *
     *
     *
     * @return The value of the field "sLastName"
     */
    inline const ::fi_basetypes_most::T_String& getSLastName () const;

    /**
     * Retrieves the value of the field "sLastName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sLastName".
     */
    inline ::fi_basetypes_most::T_String& getSLastNameMutable ();

    /**
     * Sets the value of the member "sLastName".
     *
     *
     *
     * @param sLastName The value which will be set
     */
    inline void setSLastName (const ::fi_basetypes_most::T_String& sLastName_);

    // API of field "sEmailAddress"

    static const int kSEmailAddress = 3;

    /**
     * Clears the field "sEmailAddress".
     *
     * The field will be set to its default value. The hasSEmailAddress()
     * method will return false.
     */
    inline void clearSEmailAddress();

    /**
     * Checks whether the field "sEmailAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSEmailAddress()). Otherwise it will return false.
     */
    inline bool hasSEmailAddress () const;

    /**
     * Returns the value of the member "sEmailAddress".
     *
     *
     *
     * @return The value of the field "sEmailAddress"
     */
    inline const ::fi_basetypes_most::T_String& getSEmailAddress () const;

    /**
     * Retrieves the value of the field "sEmailAddress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sEmailAddress".
     */
    inline ::fi_basetypes_most::T_String& getSEmailAddressMutable ();

    /**
     * Sets the value of the member "sEmailAddress".
     *
     *
     *
     * @param sEmailAddress The value which will be set
     */
    inline void setSEmailAddress (const ::fi_basetypes_most::T_String& sEmailAddress_);

    // API of field "sPhoneNumber"

    static const int kSPhoneNumber = 4;

    /**
     * Clears the field "sPhoneNumber".
     *
     * The field will be set to its default value. The hasSPhoneNumber()
     * method will return false.
     */
    inline void clearSPhoneNumber();

    /**
     * Checks whether the field "sPhoneNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSPhoneNumber()). Otherwise it will return false.
     */
    inline bool hasSPhoneNumber () const;

    /**
     * Returns the value of the member "sPhoneNumber".
     *
     *
     *
     * @return The value of the field "sPhoneNumber"
     */
    inline const ::fi_basetypes_most::T_String& getSPhoneNumber () const;

    /**
     * Retrieves the value of the field "sPhoneNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sPhoneNumber".
     */
    inline ::fi_basetypes_most::T_String& getSPhoneNumberMutable ();

    /**
     * Sets the value of the member "sPhoneNumber".
     *
     *
     *
     * @param sPhoneNumber The value which will be set
     */
    inline void setSPhoneNumber (const ::fi_basetypes_most::T_String& sPhoneNumber_);

    static const T_MsgAddressFieldItem &getDefaultInstance();

private:

    inline void set_has_e8AddressFieldType ();

    inline void clear_has_e8AddressFieldType ();

    inline void set_has_sFirstName ();

    inline void clear_has_sFirstName ();

    inline void set_has_sLastName ();

    inline void clear_has_sLastName ();

    inline void set_has_sEmailAddress ();

    inline void clear_has_sEmailAddress ();

    inline void set_has_sPhoneNumber ();

    inline void clear_has_sPhoneNumber ();

    uint32 _has_bits_[ (5 + 31) / 32];

    T_e8_MsgAddressFieldType _e8AddressFieldType;

    ::fi_basetypes_most::T_String _sFirstName;

    ::fi_basetypes_most::T_String _sLastName;

    ::fi_basetypes_most::T_String _sEmailAddress;

    ::fi_basetypes_most::T_String _sPhoneNumber;

};

class T_MsgMessageDetailsResult {
public:

    /**
     * Default constructor
     */
    inline  T_MsgMessageDetailsResult ();

    /**
     * Copy constructor
     */
    inline  T_MsgMessageDetailsResult (const T_MsgMessageDetailsResult &rhs);

    /**
     * All fields constructor
     */
    inline  T_MsgMessageDetailsResult (const T_MsgMessageDateTime& oMessageDateTime_, const ::fi_basetypes_most::T_String& sSubject_, const ::fi_basetypes_most::T_String& sShortMessage_, uint8 u8NumAttachments_, uint8 u8NumBodyParts_, const T_MsgMsgBodyActionElementTags& oMsgBodyActionElementTags_, const T_MsgAddressField& oAddressField_);

    /**
     * Destructor
     */
    inline  ~T_MsgMessageDetailsResult();

    /**
     * Assignment operator
     */
    inline T_MsgMessageDetailsResult& operator = (const T_MsgMessageDetailsResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_MsgMessageDetailsResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_MsgMessageDetailsResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_MsgMessageDetailsResult& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_MsgMessageDetailsResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oMessageDateTime"

    static const int kOMessageDateTime = 0;

    /**
     * Clears the field "oMessageDateTime".
     *
     * The field will be set to its default value. The hasOMessageDateTime()
     * method will return false.
     */
    inline void clearOMessageDateTime();

    /**
     * Checks whether the field "oMessageDateTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOMessageDateTime()). Otherwise it will return false.
     */
    inline bool hasOMessageDateTime () const;

    /**
     * Returns the value of the member "oMessageDateTime".
     *
     * The message date and time formatted as YYYYMMDDHHMMSS. The MessageDateTime is made up of the MessageDate stream and the MessageTime stream.
     *
     * @return The value of the field "oMessageDateTime"
     */
    inline const T_MsgMessageDateTime& getOMessageDateTime () const;

    /**
     * Retrieves the value of the field "oMessageDateTime" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oMessageDateTime".
     */
    inline T_MsgMessageDateTime& getOMessageDateTimeMutable ();

    /**
     * Sets the value of the member "oMessageDateTime".
     *
     * The message date and time formatted as YYYYMMDDHHMMSS. The MessageDateTime is made up of the MessageDate stream and the MessageTime stream.
     *
     * @param oMessageDateTime The value which will be set
     */
    inline void setOMessageDateTime (const T_MsgMessageDateTime& oMessageDateTime_);

    // API of field "sSubject"

    static const int kSSubject = 1;

    /**
     * Clears the field "sSubject".
     *
     * The field will be set to its default value. The hasSSubject()
     * method will return false.
     */
    inline void clearSSubject();

    /**
     * Checks whether the field "sSubject" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSSubject()). Otherwise it will return false.
     */
    inline bool hasSSubject () const;

    /**
     * Returns the value of the member "sSubject".
     *
     * The subject of the email message.
     *
     * @return The value of the field "sSubject"
     */
    inline const ::fi_basetypes_most::T_String& getSSubject () const;

    /**
     * Retrieves the value of the field "sSubject" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sSubject".
     */
    inline ::fi_basetypes_most::T_String& getSSubjectMutable ();

    /**
     * Sets the value of the member "sSubject".
     *
     * The subject of the email message.
     *
     * @param sSubject The value which will be set
     */
    inline void setSSubject (const ::fi_basetypes_most::T_String& sSubject_);

    // API of field "sShortMessage"

    static const int kSShortMessage = 2;

    /**
     * Clears the field "sShortMessage".
     *
     * The field will be set to its default value. The hasSShortMessage()
     * method will return false.
     */
    inline void clearSShortMessage();

    /**
     * Checks whether the field "sShortMessage" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSShortMessage()). Otherwise it will return false.
     */
    inline bool hasSShortMessage () const;

    /**
     * Returns the value of the member "sShortMessage".
     *
     * Provides the message content of an SMS or MMS message. Limited to 160 characters.
     *
     * @return The value of the field "sShortMessage"
     */
    inline const ::fi_basetypes_most::T_String& getSShortMessage () const;

    /**
     * Retrieves the value of the field "sShortMessage" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sShortMessage".
     */
    inline ::fi_basetypes_most::T_String& getSShortMessageMutable ();

    /**
     * Sets the value of the member "sShortMessage".
     *
     * Provides the message content of an SMS or MMS message. Limited to 160 characters.
     *
     * @param sShortMessage The value which will be set
     */
    inline void setSShortMessage (const ::fi_basetypes_most::T_String& sShortMessage_);

    // API of field "u8NumAttachments"

    static const int kU8NumAttachments = 3;

    /**
     * Clears the field "u8NumAttachments".
     *
     * The field will be set to its default value. The hasU8NumAttachments()
     * method will return false.
     */
    inline void clearU8NumAttachments();

    /**
     * Checks whether the field "u8NumAttachments" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8NumAttachments()). Otherwise it will return false.
     */
    inline bool hasU8NumAttachments () const;

    /**
     * Returns the value of the member "u8NumAttachments".
     *
     * The number of attachments within a particular message.
     *
     * @return The value of the field "u8NumAttachments"
     */
    inline uint8 getU8NumAttachments () const;

    /**
     * Sets the value of the member "u8NumAttachments".
     *
     * The number of attachments within a particular message.
     *
     * @param u8NumAttachments The value which will be set
     */
    inline void setU8NumAttachments (uint8 u8NumAttachments_);

    // API of field "u8NumBodyParts"

    static const int kU8NumBodyParts = 4;

    /**
     * Clears the field "u8NumBodyParts".
     *
     * The field will be set to its default value. The hasU8NumBodyParts()
     * method will return false.
     */
    inline void clearU8NumBodyParts();

    /**
     * Checks whether the field "u8NumBodyParts" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8NumBodyParts()). Otherwise it will return false.
     */
    inline bool hasU8NumBodyParts () const;

    /**
     * Returns the value of the member "u8NumBodyParts".
     *
     *
     *
     * @return The value of the field "u8NumBodyParts"
     */
    inline uint8 getU8NumBodyParts () const;

    /**
     * Sets the value of the member "u8NumBodyParts".
     *
     *
     *
     * @param u8NumBodyParts The value which will be set
     */
    inline void setU8NumBodyParts (uint8 u8NumBodyParts_);

    // API of field "oMsgBodyActionElementTags"

    static const int kOMsgBodyActionElementTags = 5;

    /**
     * Clears the field "oMsgBodyActionElementTags".
     *
     * The field will be set to its default value. The hasOMsgBodyActionElementTags()
     * method will return false.
     */
    inline void clearOMsgBodyActionElementTags();

    /**
     * Checks whether the field "oMsgBodyActionElementTags" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOMsgBodyActionElementTags()). Otherwise it will return false.
     */
    inline bool hasOMsgBodyActionElementTags () const;

    /**
     * Returns the value of the member "oMsgBodyActionElementTags".
     *
     * Provides all the action element (i.e. phone numbers, email addresses, and addresses) tags within the message body.
     *
     * @return The value of the field "oMsgBodyActionElementTags"
     */
    inline const T_MsgMsgBodyActionElementTags& getOMsgBodyActionElementTags () const;

    /**
     * Retrieves the value of the field "oMsgBodyActionElementTags" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oMsgBodyActionElementTags".
     */
    inline T_MsgMsgBodyActionElementTags& getOMsgBodyActionElementTagsMutable ();

    /**
     * Sets the value of the member "oMsgBodyActionElementTags".
     *
     * Provides all the action element (i.e. phone numbers, email addresses, and addresses) tags within the message body.
     *
     * @param oMsgBodyActionElementTags The value which will be set
     */
    inline void setOMsgBodyActionElementTags (const T_MsgMsgBodyActionElementTags& oMsgBodyActionElementTags_);

    // API of field "oAddressField"

    static const int kOAddressField = 6;

    /**
     * Clears the field "oAddressField".
     *
     * The field will be set to its default value. The hasOAddressField()
     * method will return false.
     */
    inline void clearOAddressField();

    /**
     * Checks whether the field "oAddressField" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOAddressField()). Otherwise it will return false.
     */
    inline bool hasOAddressField () const;

    /**
     * Returns the value of the member "oAddressField".
     *
     * Provides the field type (From, To, CC) and the sender or recipient contact information.
     *
     * @return The value of the field "oAddressField"
     */
    inline const T_MsgAddressField& getOAddressField () const;

    /**
     * Retrieves the value of the field "oAddressField" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oAddressField".
     */
    inline T_MsgAddressField& getOAddressFieldMutable ();

    /**
     * Sets the value of the member "oAddressField".
     *
     * Provides the field type (From, To, CC) and the sender or recipient contact information.
     *
     * @param oAddressField The value which will be set
     */
    inline void setOAddressField (const T_MsgAddressField& oAddressField_);

    static const T_MsgMessageDetailsResult &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    static const ::std::vector< T_MsgAddressFieldItem >& getT_MsgAddressFieldItemList_DefaultInstance ();

    inline void set_has_oMessageDateTime ();

    inline void clear_has_oMessageDateTime ();

    inline void set_has_sSubject ();

    inline void clear_has_sSubject ();

    inline void set_has_sShortMessage ();

    inline void clear_has_sShortMessage ();

    inline void set_has_u8NumAttachments ();

    inline void clear_has_u8NumAttachments ();

    inline void set_has_u8NumBodyParts ();

    inline void clear_has_u8NumBodyParts ();

    inline void set_has_oMsgBodyActionElementTags ();

    inline void clear_has_oMsgBodyActionElementTags ();

    inline void set_has_oAddressField ();

    inline void clear_has_oAddressField ();

    uint32 _has_bits_[ (7 + 31) / 32];

    T_MsgMessageDateTime _oMessageDateTime;

    ::fi_basetypes_most::T_String _sSubject;

    ::fi_basetypes_most::T_String _sShortMessage;

    uint8 _u8NumAttachments;

    uint8 _u8NumBodyParts;

    T_MsgMsgBodyActionElementTags _oMsgBodyActionElementTags;

    T_MsgAddressField _oAddressField;

};

class T_MsgAttachmentListItem {
public:

    /**
     * Default constructor
     */
    inline  T_MsgAttachmentListItem ();

    /**
     * Copy constructor
     */
    inline  T_MsgAttachmentListItem (const T_MsgAttachmentListItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_MsgAttachmentListItem (uint16 u16AttachmentHandle_, T_e8_MsgAttachmentType e8AttachmentType_, const ::fi_basetypes_most::T_String& sFilename_);

    /**
     * Destructor
     */
    inline  ~T_MsgAttachmentListItem();

    /**
     * Assignment operator
     */
    inline T_MsgAttachmentListItem& operator = (const T_MsgAttachmentListItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_MsgAttachmentListItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_MsgAttachmentListItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_MsgAttachmentListItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_MsgAttachmentListItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16AttachmentHandle"

    static const int kU16AttachmentHandle = 0;

    /**
     * Clears the field "u16AttachmentHandle".
     *
     * The field will be set to its default value. The hasU16AttachmentHandle()
     * method will return false.
     */
    inline void clearU16AttachmentHandle();

    /**
     * Checks whether the field "u16AttachmentHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16AttachmentHandle()). Otherwise it will return false.
     */
    inline bool hasU16AttachmentHandle () const;

    /**
     * Returns the value of the member "u16AttachmentHandle".
     *
     * This is the handle for a particular attachment.  The handle is locally unique only for a particular message and is not required to be globally unique.
     *
     * @return The value of the field "u16AttachmentHandle"
     */
    inline uint16 getU16AttachmentHandle () const;

    /**
     * Sets the value of the member "u16AttachmentHandle".
     *
     * This is the handle for a particular attachment.  The handle is locally unique only for a particular message and is not required to be globally unique.
     *
     * @param u16AttachmentHandle The value which will be set
     */
    inline void setU16AttachmentHandle (uint16 u16AttachmentHandle_);

    // API of field "e8AttachmentType"

    static const int kE8AttachmentType = 1;

    /**
     * Clears the field "e8AttachmentType".
     *
     * The field will be set to its default value. The hasE8AttachmentType()
     * method will return false.
     */
    inline void clearE8AttachmentType();

    /**
     * Checks whether the field "e8AttachmentType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8AttachmentType()). Otherwise it will return false.
     */
    inline bool hasE8AttachmentType () const;

    /**
     * Returns the value of the member "e8AttachmentType".
     *
     * Identifies whether the attachment is an audio file, image file, or unsupported.
     *
     * @return The value of the field "e8AttachmentType"
     */
    inline T_e8_MsgAttachmentType getE8AttachmentType () const;

    /**
     * Sets the value of the member "e8AttachmentType".
     *
     * Identifies whether the attachment is an audio file, image file, or unsupported.
     *
     * @param e8AttachmentType The value which will be set
     */
    inline void setE8AttachmentType (T_e8_MsgAttachmentType e8AttachmentType_);

    // API of field "sFilename"

    static const int kSFilename = 2;

    /**
     * Clears the field "sFilename".
     *
     * The field will be set to its default value. The hasSFilename()
     * method will return false.
     */
    inline void clearSFilename();

    /**
     * Checks whether the field "sFilename" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSFilename()). Otherwise it will return false.
     */
    inline bool hasSFilename () const;

    /**
     * Returns the value of the member "sFilename".
     *
     * The filename for an attachment.
     *
     * @return The value of the field "sFilename"
     */
    inline const ::fi_basetypes_most::T_String& getSFilename () const;

    /**
     * Retrieves the value of the field "sFilename" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sFilename".
     */
    inline ::fi_basetypes_most::T_String& getSFilenameMutable ();

    /**
     * Sets the value of the member "sFilename".
     *
     * The filename for an attachment.
     *
     * @param sFilename The value which will be set
     */
    inline void setSFilename (const ::fi_basetypes_most::T_String& sFilename_);

    static const T_MsgAttachmentListItem &getDefaultInstance();

private:

    inline void set_has_u16AttachmentHandle ();

    inline void clear_has_u16AttachmentHandle ();

    inline void set_has_e8AttachmentType ();

    inline void clear_has_e8AttachmentType ();

    inline void set_has_sFilename ();

    inline void clear_has_sFilename ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint16 _u16AttachmentHandle;

    T_e8_MsgAttachmentType _e8AttachmentType;

    ::fi_basetypes_most::T_String _sFilename;

};

class T_MsgBodyPartListItem {
public:

    /**
     * Default constructor
     */
    inline  T_MsgBodyPartListItem ();

    /**
     * Copy constructor
     */
    inline  T_MsgBodyPartListItem (const T_MsgBodyPartListItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_MsgBodyPartListItem (const ::fi_basetypes_most::T_String& sBodyTitle_, const ::fi_basetypes_most::T_String& sBodyText_);

    /**
     * Destructor
     */
    inline  ~T_MsgBodyPartListItem();

    /**
     * Assignment operator
     */
    inline T_MsgBodyPartListItem& operator = (const T_MsgBodyPartListItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_MsgBodyPartListItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_MsgBodyPartListItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_MsgBodyPartListItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_MsgBodyPartListItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sBodyTitle"

    static const int kSBodyTitle = 0;

    /**
     * Clears the field "sBodyTitle".
     *
     * The field will be set to its default value. The hasSBodyTitle()
     * method will return false.
     */
    inline void clearSBodyTitle();

    /**
     * Checks whether the field "sBodyTitle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSBodyTitle()). Otherwise it will return false.
     */
    inline bool hasSBodyTitle () const;

    /**
     * Returns the value of the member "sBodyTitle".
     *
     * This is the title for a message BodyText element.  It may be the subject of the message (if there is only one BodyText part) or a title identifying that piece fo the message.
     *
     * @return The value of the field "sBodyTitle"
     */
    inline const ::fi_basetypes_most::T_String& getSBodyTitle () const;

    /**
     * Retrieves the value of the field "sBodyTitle" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sBodyTitle".
     */
    inline ::fi_basetypes_most::T_String& getSBodyTitleMutable ();

    /**
     * Sets the value of the member "sBodyTitle".
     *
     * This is the title for a message BodyText element.  It may be the subject of the message (if there is only one BodyText part) or a title identifying that piece fo the message.
     *
     * @param sBodyTitle The value which will be set
     */
    inline void setSBodyTitle (const ::fi_basetypes_most::T_String& sBodyTitle_);

    // API of field "sBodyText"

    static const int kSBodyText = 1;

    /**
     * Clears the field "sBodyText".
     *
     * The field will be set to its default value. The hasSBodyText()
     * method will return false.
     */
    inline void clearSBodyText();

    /**
     * Checks whether the field "sBodyText" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSBodyText()). Otherwise it will return false.
     */
    inline bool hasSBodyText () const;

    /**
     * Returns the value of the member "sBodyText".
     *
     * This is the text of a message BodyPart.
     *
     * @return The value of the field "sBodyText"
     */
    inline const ::fi_basetypes_most::T_String& getSBodyText () const;

    /**
     * Retrieves the value of the field "sBodyText" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sBodyText".
     */
    inline ::fi_basetypes_most::T_String& getSBodyTextMutable ();

    /**
     * Sets the value of the member "sBodyText".
     *
     * This is the text of a message BodyPart.
     *
     * @param sBodyText The value which will be set
     */
    inline void setSBodyText (const ::fi_basetypes_most::T_String& sBodyText_);

    static const T_MsgBodyPartListItem &getDefaultInstance();

private:

    inline void set_has_sBodyTitle ();

    inline void clear_has_sBodyTitle ();

    inline void set_has_sBodyText ();

    inline void clear_has_sBodyText ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_String _sBodyTitle;

    ::fi_basetypes_most::T_String _sBodyText;

};

class T_MsgPredefinedMessageListResultItem {
public:

    /**
     * Default constructor
     */
    inline  T_MsgPredefinedMessageListResultItem ();

    /**
     * Copy constructor
     */
    inline  T_MsgPredefinedMessageListResultItem (const T_MsgPredefinedMessageListResultItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_MsgPredefinedMessageListResultItem (uint16 u16PredefinedMessageHandle_, T_e8_MsgPredefinedMessageType e8PredefinedMessageType_, const ::fi_basetypes_most::T_String& sPredefinedMessageText_);

    /**
     * Destructor
     */
    inline  ~T_MsgPredefinedMessageListResultItem();

    /**
     * Assignment operator
     */
    inline T_MsgPredefinedMessageListResultItem& operator = (const T_MsgPredefinedMessageListResultItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_MsgPredefinedMessageListResultItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_MsgPredefinedMessageListResultItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_MsgPredefinedMessageListResultItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_MsgPredefinedMessageListResultItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16PredefinedMessageHandle"

    static const int kU16PredefinedMessageHandle = 0;

    /**
     * Clears the field "u16PredefinedMessageHandle".
     *
     * The field will be set to its default value. The hasU16PredefinedMessageHandle()
     * method will return false.
     */
    inline void clearU16PredefinedMessageHandle();

    /**
     * Checks whether the field "u16PredefinedMessageHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16PredefinedMessageHandle()). Otherwise it will return false.
     */
    inline bool hasU16PredefinedMessageHandle () const;

    /**
     * Returns the value of the member "u16PredefinedMessageHandle".
     *
     * This is the unique ID for a particular predefined message text.
     *
     * @return The value of the field "u16PredefinedMessageHandle"
     */
    inline uint16 getU16PredefinedMessageHandle () const;

    /**
     * Sets the value of the member "u16PredefinedMessageHandle".
     *
     * This is the unique ID for a particular predefined message text.
     *
     * @param u16PredefinedMessageHandle The value which will be set
     */
    inline void setU16PredefinedMessageHandle (uint16 u16PredefinedMessageHandle_);

    // API of field "e8PredefinedMessageType"

    static const int kE8PredefinedMessageType = 1;

    /**
     * Clears the field "e8PredefinedMessageType".
     *
     * The field will be set to its default value. The hasE8PredefinedMessageType()
     * method will return false.
     */
    inline void clearE8PredefinedMessageType();

    /**
     * Checks whether the field "e8PredefinedMessageType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8PredefinedMessageType()). Otherwise it will return false.
     */
    inline bool hasE8PredefinedMessageType () const;

    /**
     * Returns the value of the member "e8PredefinedMessageType".
     *
     *
     *
     * @return The value of the field "e8PredefinedMessageType"
     */
    inline T_e8_MsgPredefinedMessageType getE8PredefinedMessageType () const;

    /**
     * Sets the value of the member "e8PredefinedMessageType".
     *
     *
     *
     * @param e8PredefinedMessageType The value which will be set
     */
    inline void setE8PredefinedMessageType (T_e8_MsgPredefinedMessageType e8PredefinedMessageType_);

    // API of field "sPredefinedMessageText"

    static const int kSPredefinedMessageText = 2;

    /**
     * Clears the field "sPredefinedMessageText".
     *
     * The field will be set to its default value. The hasSPredefinedMessageText()
     * method will return false.
     */
    inline void clearSPredefinedMessageText();

    /**
     * Checks whether the field "sPredefinedMessageText" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSPredefinedMessageText()). Otherwise it will return false.
     */
    inline bool hasSPredefinedMessageText () const;

    /**
     * Returns the value of the member "sPredefinedMessageText".
     *
     * The text of the predefined message.
     *
     * @return The value of the field "sPredefinedMessageText"
     */
    inline const ::fi_basetypes_most::T_String& getSPredefinedMessageText () const;

    /**
     * Retrieves the value of the field "sPredefinedMessageText" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sPredefinedMessageText".
     */
    inline ::fi_basetypes_most::T_String& getSPredefinedMessageTextMutable ();

    /**
     * Sets the value of the member "sPredefinedMessageText".
     *
     * The text of the predefined message.
     *
     * @param sPredefinedMessageText The value which will be set
     */
    inline void setSPredefinedMessageText (const ::fi_basetypes_most::T_String& sPredefinedMessageText_);

    static const T_MsgPredefinedMessageListResultItem &getDefaultInstance();

private:

    inline void set_has_u16PredefinedMessageHandle ();

    inline void clear_has_u16PredefinedMessageHandle ();

    inline void set_has_e8PredefinedMessageType ();

    inline void clear_has_e8PredefinedMessageType ();

    inline void set_has_sPredefinedMessageText ();

    inline void clear_has_sPredefinedMessageText ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint16 _u16PredefinedMessageHandle;

    T_e8_MsgPredefinedMessageType _e8PredefinedMessageType;

    ::fi_basetypes_most::T_String _sPredefinedMessageText;

};

inline  T_MsgMessageHandle::T_MsgMessageHandle ()  :
    _u8DeviceHandle (0u),
    _u32MsgHandleUpper (0u),
    _u32MsgHandleLower (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_MsgMessageHandle::T_MsgMessageHandle (const T_MsgMessageHandle &rhs)  :
    _u8DeviceHandle (0u),
    _u32MsgHandleUpper (0u),
    _u32MsgHandleLower (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_MsgMessageHandle::T_MsgMessageHandle (uint8 u8DeviceHandle_, uint32 u32MsgHandleUpper_, uint32 u32MsgHandleLower_)  :
    _u8DeviceHandle (u8DeviceHandle_),
    _u32MsgHandleUpper (u32MsgHandleUpper_),
    _u32MsgHandleLower (u32MsgHandleLower_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_MsgMessageHandle::~T_MsgMessageHandle() {
}

inline T_MsgMessageHandle& T_MsgMessageHandle::operator = (const T_MsgMessageHandle& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8DeviceHandle()) {
            setU8DeviceHandle(rhs.getU8DeviceHandle());
        } else {
            clearU8DeviceHandle();
        }
        if (rhs.hasU32MsgHandleUpper()) {
            setU32MsgHandleUpper(rhs.getU32MsgHandleUpper());
        } else {
            clearU32MsgHandleUpper();
        }
        if (rhs.hasU32MsgHandleLower()) {
            setU32MsgHandleLower(rhs.getU32MsgHandleLower());
        } else {
            clearU32MsgHandleLower();
        }
    }
    return *this;
}

inline bool T_MsgMessageHandle::operator == (const T_MsgMessageHandle& rhs) const {
    return (((!hasU8DeviceHandle() && !rhs.hasU8DeviceHandle()) || getU8DeviceHandle() == rhs.getU8DeviceHandle()) &&
        ((!hasU32MsgHandleUpper() && !rhs.hasU32MsgHandleUpper()) || getU32MsgHandleUpper() == rhs.getU32MsgHandleUpper()) &&
        ((!hasU32MsgHandleLower() && !rhs.hasU32MsgHandleLower()) || getU32MsgHandleLower() == rhs.getU32MsgHandleLower()));
}

inline bool T_MsgMessageHandle::operator != (const T_MsgMessageHandle& rhs) const {
    return ! (*this == rhs);
}

inline bool T_MsgMessageHandle::operator < (const T_MsgMessageHandle& rhs) const {
    if (hasU8DeviceHandle() || rhs.hasU8DeviceHandle()) {
        if (getU8DeviceHandle() < rhs.getU8DeviceHandle()) return true;
        if (getU8DeviceHandle() > rhs.getU8DeviceHandle()) return false;
    }
    if (hasU32MsgHandleUpper() || rhs.hasU32MsgHandleUpper()) {
        if (getU32MsgHandleUpper() < rhs.getU32MsgHandleUpper()) return true;
        if (getU32MsgHandleUpper() > rhs.getU32MsgHandleUpper()) return false;
    }
    if (hasU32MsgHandleLower() || rhs.hasU32MsgHandleLower()) {
        if (getU32MsgHandleLower() < rhs.getU32MsgHandleLower()) return true;
        if (getU32MsgHandleLower() > rhs.getU32MsgHandleLower()) return false;
    }
    return false;
}

inline bool T_MsgMessageHandle::operator > (const T_MsgMessageHandle& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_MsgMessageHandle::clear() {
    clearU8DeviceHandle();
    clearU32MsgHandleUpper();
    clearU32MsgHandleLower();
}

inline void T_MsgMessageHandle::clearU8DeviceHandle() {
    if (hasU8DeviceHandle()) {
         clear_has_u8DeviceHandle();
        _u8DeviceHandle = 0u;
     }
}

inline bool T_MsgMessageHandle::hasU8DeviceHandle () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_MsgMessageHandle::getU8DeviceHandle () const {
    return _u8DeviceHandle;
}

inline void T_MsgMessageHandle::setU8DeviceHandle (uint8 u8DeviceHandle_) {
    set_has_u8DeviceHandle();
    this->_u8DeviceHandle = u8DeviceHandle_;
}

inline void T_MsgMessageHandle::clearU32MsgHandleUpper() {
    if (hasU32MsgHandleUpper()) {
         clear_has_u32MsgHandleUpper();
        _u32MsgHandleUpper = 0u;
     }
}

inline bool T_MsgMessageHandle::hasU32MsgHandleUpper () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 T_MsgMessageHandle::getU32MsgHandleUpper () const {
    return _u32MsgHandleUpper;
}

inline void T_MsgMessageHandle::setU32MsgHandleUpper (uint32 u32MsgHandleUpper_) {
    set_has_u32MsgHandleUpper();
    this->_u32MsgHandleUpper = u32MsgHandleUpper_;
}

inline void T_MsgMessageHandle::clearU32MsgHandleLower() {
    if (hasU32MsgHandleLower()) {
         clear_has_u32MsgHandleLower();
        _u32MsgHandleLower = 0u;
     }
}

inline bool T_MsgMessageHandle::hasU32MsgHandleLower () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 T_MsgMessageHandle::getU32MsgHandleLower () const {
    return _u32MsgHandleLower;
}

inline void T_MsgMessageHandle::setU32MsgHandleLower (uint32 u32MsgHandleLower_) {
    set_has_u32MsgHandleLower();
    this->_u32MsgHandleLower = u32MsgHandleLower_;
}

inline void T_MsgMessageHandle::set_has_u8DeviceHandle () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_MsgMessageHandle::clear_has_u8DeviceHandle () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_MsgMessageHandle::set_has_u32MsgHandleUpper () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_MsgMessageHandle::clear_has_u32MsgHandleUpper () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_MsgMessageHandle::set_has_u32MsgHandleLower () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_MsgMessageHandle::clear_has_u32MsgHandleLower () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_MsgMessageDate::T_MsgMessageDate ()  :
    _sCldrYear (),
    _sCldrMonth (),
    _sCldrDay ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_MsgMessageDate::T_MsgMessageDate (const T_MsgMessageDate &rhs)  :
    _sCldrYear (),
    _sCldrMonth (),
    _sCldrDay ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_MsgMessageDate::T_MsgMessageDate (const ::fi_basetypes_most::T_String& sCldrYear_, const ::fi_basetypes_most::T_String& sCldrMonth_, const ::fi_basetypes_most::T_String& sCldrDay_)  :
    _sCldrYear (sCldrYear_),
    _sCldrMonth (sCldrMonth_),
    _sCldrDay (sCldrDay_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sCldrYear_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sCldrMonth_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sCldrDay_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_MsgMessageDate::~T_MsgMessageDate() {
}

inline T_MsgMessageDate& T_MsgMessageDate::operator = (const T_MsgMessageDate& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSCldrYear()) {
            setSCldrYear(rhs.getSCldrYear());
        } else {
            clearSCldrYear();
        }
        if (rhs.hasSCldrMonth()) {
            setSCldrMonth(rhs.getSCldrMonth());
        } else {
            clearSCldrMonth();
        }
        if (rhs.hasSCldrDay()) {
            setSCldrDay(rhs.getSCldrDay());
        } else {
            clearSCldrDay();
        }
    }
    return *this;
}

inline bool T_MsgMessageDate::operator == (const T_MsgMessageDate& rhs) const {
    return (((!hasSCldrYear() && !rhs.hasSCldrYear()) || getSCldrYear() == rhs.getSCldrYear()) &&
        ((!hasSCldrMonth() && !rhs.hasSCldrMonth()) || getSCldrMonth() == rhs.getSCldrMonth()) &&
        ((!hasSCldrDay() && !rhs.hasSCldrDay()) || getSCldrDay() == rhs.getSCldrDay()));
}

inline bool T_MsgMessageDate::operator != (const T_MsgMessageDate& rhs) const {
    return ! (*this == rhs);
}

inline bool T_MsgMessageDate::operator < (const T_MsgMessageDate& rhs) const {
    if (hasSCldrYear() || rhs.hasSCldrYear()) {
        if (getSCldrYear() < rhs.getSCldrYear()) return true;
        if (getSCldrYear() > rhs.getSCldrYear()) return false;
    }
    if (hasSCldrMonth() || rhs.hasSCldrMonth()) {
        if (getSCldrMonth() < rhs.getSCldrMonth()) return true;
        if (getSCldrMonth() > rhs.getSCldrMonth()) return false;
    }
    if (hasSCldrDay() || rhs.hasSCldrDay()) {
        if (getSCldrDay() < rhs.getSCldrDay()) return true;
        if (getSCldrDay() > rhs.getSCldrDay()) return false;
    }
    return false;
}

inline bool T_MsgMessageDate::operator > (const T_MsgMessageDate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_MsgMessageDate::clear() {
    clearSCldrYear();
    clearSCldrMonth();
    clearSCldrDay();
}

inline void T_MsgMessageDate::clearSCldrYear() {
    if (hasSCldrYear()) {
         clear_has_sCldrYear();
        _sCldrYear.clear();
     }
}

inline bool T_MsgMessageDate::hasSCldrYear () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_MsgMessageDate::getSCldrYear () const {
    return _sCldrYear;
}

inline ::fi_basetypes_most::T_String& T_MsgMessageDate::getSCldrYearMutable () {
    set_has_sCldrYear();
    return _sCldrYear;
}

inline void T_MsgMessageDate::setSCldrYear (const ::fi_basetypes_most::T_String& sCldrYear_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sCldrYear_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sCldrYear();
    this->_sCldrYear = sCldrYear_;
}

inline void T_MsgMessageDate::clearSCldrMonth() {
    if (hasSCldrMonth()) {
         clear_has_sCldrMonth();
        _sCldrMonth.clear();
     }
}

inline bool T_MsgMessageDate::hasSCldrMonth () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_MsgMessageDate::getSCldrMonth () const {
    return _sCldrMonth;
}

inline ::fi_basetypes_most::T_String& T_MsgMessageDate::getSCldrMonthMutable () {
    set_has_sCldrMonth();
    return _sCldrMonth;
}

inline void T_MsgMessageDate::setSCldrMonth (const ::fi_basetypes_most::T_String& sCldrMonth_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sCldrMonth_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sCldrMonth();
    this->_sCldrMonth = sCldrMonth_;
}

inline void T_MsgMessageDate::clearSCldrDay() {
    if (hasSCldrDay()) {
         clear_has_sCldrDay();
        _sCldrDay.clear();
     }
}

inline bool T_MsgMessageDate::hasSCldrDay () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_MsgMessageDate::getSCldrDay () const {
    return _sCldrDay;
}

inline ::fi_basetypes_most::T_String& T_MsgMessageDate::getSCldrDayMutable () {
    set_has_sCldrDay();
    return _sCldrDay;
}

inline void T_MsgMessageDate::setSCldrDay (const ::fi_basetypes_most::T_String& sCldrDay_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sCldrDay_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sCldrDay();
    this->_sCldrDay = sCldrDay_;
}

inline void T_MsgMessageDate::set_has_sCldrYear () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_MsgMessageDate::clear_has_sCldrYear () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_MsgMessageDate::set_has_sCldrMonth () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_MsgMessageDate::clear_has_sCldrMonth () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_MsgMessageDate::set_has_sCldrDay () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_MsgMessageDate::clear_has_sCldrDay () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_MsgMessageTime::T_MsgMessageTime ()  :
    _sHours (),
    _sMinutes (),
    _sSeconds ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_MsgMessageTime::T_MsgMessageTime (const T_MsgMessageTime &rhs)  :
    _sHours (),
    _sMinutes (),
    _sSeconds ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_MsgMessageTime::T_MsgMessageTime (const ::fi_basetypes_most::T_String& sHours_, const ::fi_basetypes_most::T_String& sMinutes_, const ::fi_basetypes_most::T_String& sSeconds_)  :
    _sHours (sHours_),
    _sMinutes (sMinutes_),
    _sSeconds (sSeconds_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sHours_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sMinutes_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sSeconds_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_MsgMessageTime::~T_MsgMessageTime() {
}

inline T_MsgMessageTime& T_MsgMessageTime::operator = (const T_MsgMessageTime& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSHours()) {
            setSHours(rhs.getSHours());
        } else {
            clearSHours();
        }
        if (rhs.hasSMinutes()) {
            setSMinutes(rhs.getSMinutes());
        } else {
            clearSMinutes();
        }
        if (rhs.hasSSeconds()) {
            setSSeconds(rhs.getSSeconds());
        } else {
            clearSSeconds();
        }
    }
    return *this;
}

inline bool T_MsgMessageTime::operator == (const T_MsgMessageTime& rhs) const {
    return (((!hasSHours() && !rhs.hasSHours()) || getSHours() == rhs.getSHours()) &&
        ((!hasSMinutes() && !rhs.hasSMinutes()) || getSMinutes() == rhs.getSMinutes()) &&
        ((!hasSSeconds() && !rhs.hasSSeconds()) || getSSeconds() == rhs.getSSeconds()));
}

inline bool T_MsgMessageTime::operator != (const T_MsgMessageTime& rhs) const {
    return ! (*this == rhs);
}

inline bool T_MsgMessageTime::operator < (const T_MsgMessageTime& rhs) const {
    if (hasSHours() || rhs.hasSHours()) {
        if (getSHours() < rhs.getSHours()) return true;
        if (getSHours() > rhs.getSHours()) return false;
    }
    if (hasSMinutes() || rhs.hasSMinutes()) {
        if (getSMinutes() < rhs.getSMinutes()) return true;
        if (getSMinutes() > rhs.getSMinutes()) return false;
    }
    if (hasSSeconds() || rhs.hasSSeconds()) {
        if (getSSeconds() < rhs.getSSeconds()) return true;
        if (getSSeconds() > rhs.getSSeconds()) return false;
    }
    return false;
}

inline bool T_MsgMessageTime::operator > (const T_MsgMessageTime& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_MsgMessageTime::clear() {
    clearSHours();
    clearSMinutes();
    clearSSeconds();
}

inline void T_MsgMessageTime::clearSHours() {
    if (hasSHours()) {
         clear_has_sHours();
        _sHours.clear();
     }
}

inline bool T_MsgMessageTime::hasSHours () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_MsgMessageTime::getSHours () const {
    return _sHours;
}

inline ::fi_basetypes_most::T_String& T_MsgMessageTime::getSHoursMutable () {
    set_has_sHours();
    return _sHours;
}

inline void T_MsgMessageTime::setSHours (const ::fi_basetypes_most::T_String& sHours_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sHours_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sHours();
    this->_sHours = sHours_;
}

inline void T_MsgMessageTime::clearSMinutes() {
    if (hasSMinutes()) {
         clear_has_sMinutes();
        _sMinutes.clear();
     }
}

inline bool T_MsgMessageTime::hasSMinutes () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_MsgMessageTime::getSMinutes () const {
    return _sMinutes;
}

inline ::fi_basetypes_most::T_String& T_MsgMessageTime::getSMinutesMutable () {
    set_has_sMinutes();
    return _sMinutes;
}

inline void T_MsgMessageTime::setSMinutes (const ::fi_basetypes_most::T_String& sMinutes_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sMinutes_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sMinutes();
    this->_sMinutes = sMinutes_;
}

inline void T_MsgMessageTime::clearSSeconds() {
    if (hasSSeconds()) {
         clear_has_sSeconds();
        _sSeconds.clear();
     }
}

inline bool T_MsgMessageTime::hasSSeconds () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_MsgMessageTime::getSSeconds () const {
    return _sSeconds;
}

inline ::fi_basetypes_most::T_String& T_MsgMessageTime::getSSecondsMutable () {
    set_has_sSeconds();
    return _sSeconds;
}

inline void T_MsgMessageTime::setSSeconds (const ::fi_basetypes_most::T_String& sSeconds_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sSeconds_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sSeconds();
    this->_sSeconds = sSeconds_;
}

inline void T_MsgMessageTime::set_has_sHours () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_MsgMessageTime::clear_has_sHours () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_MsgMessageTime::set_has_sMinutes () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_MsgMessageTime::clear_has_sMinutes () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_MsgMessageTime::set_has_sSeconds () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_MsgMessageTime::clear_has_sSeconds () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_MsgMessageDateTime::T_MsgMessageDateTime ()  :
    _oMessageDate (),
    _oMessageTime ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_MsgMessageDateTime::T_MsgMessageDateTime (const T_MsgMessageDateTime &rhs)  :
    _oMessageDate (),
    _oMessageTime ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_MsgMessageDateTime::T_MsgMessageDateTime (const T_MsgMessageDate& oMessageDate_, const T_MsgMessageTime& oMessageTime_)  :
    _oMessageDate (oMessageDate_),
    _oMessageTime (oMessageTime_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_MsgMessageDateTime::~T_MsgMessageDateTime() {
}

inline T_MsgMessageDateTime& T_MsgMessageDateTime::operator = (const T_MsgMessageDateTime& rhs) {
    if( this != &rhs ) {
        if (rhs.hasOMessageDate()) {
            setOMessageDate(rhs.getOMessageDate());
        } else {
            clearOMessageDate();
        }
        if (rhs.hasOMessageTime()) {
            setOMessageTime(rhs.getOMessageTime());
        } else {
            clearOMessageTime();
        }
    }
    return *this;
}

inline bool T_MsgMessageDateTime::operator == (const T_MsgMessageDateTime& rhs) const {
    return (((!hasOMessageDate() && !rhs.hasOMessageDate()) || getOMessageDate() == rhs.getOMessageDate()) &&
        ((!hasOMessageTime() && !rhs.hasOMessageTime()) || getOMessageTime() == rhs.getOMessageTime()));
}

inline bool T_MsgMessageDateTime::operator != (const T_MsgMessageDateTime& rhs) const {
    return ! (*this == rhs);
}

inline bool T_MsgMessageDateTime::operator < (const T_MsgMessageDateTime& rhs) const {
    if (hasOMessageDate() || rhs.hasOMessageDate()) {
        if (getOMessageDate() < rhs.getOMessageDate()) return true;
        if (getOMessageDate() > rhs.getOMessageDate()) return false;
    }
    if (hasOMessageTime() || rhs.hasOMessageTime()) {
        if (getOMessageTime() < rhs.getOMessageTime()) return true;
        if (getOMessageTime() > rhs.getOMessageTime()) return false;
    }
    return false;
}

inline bool T_MsgMessageDateTime::operator > (const T_MsgMessageDateTime& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_MsgMessageDateTime::clear() {
    clearOMessageDate();
    clearOMessageTime();
}

inline void T_MsgMessageDateTime::clearOMessageDate() {
    if (hasOMessageDate()) {
         clear_has_oMessageDate();
        _oMessageDate.clear();
     }
}

inline bool T_MsgMessageDateTime::hasOMessageDate () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const T_MsgMessageDate& T_MsgMessageDateTime::getOMessageDate () const {
    return _oMessageDate;
}

inline T_MsgMessageDate& T_MsgMessageDateTime::getOMessageDateMutable () {
    set_has_oMessageDate();
    return _oMessageDate;
}

inline void T_MsgMessageDateTime::setOMessageDate (const T_MsgMessageDate& oMessageDate_) {
    set_has_oMessageDate();
    this->_oMessageDate = oMessageDate_;
}

inline void T_MsgMessageDateTime::clearOMessageTime() {
    if (hasOMessageTime()) {
         clear_has_oMessageTime();
        _oMessageTime.clear();
     }
}

inline bool T_MsgMessageDateTime::hasOMessageTime () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const T_MsgMessageTime& T_MsgMessageDateTime::getOMessageTime () const {
    return _oMessageTime;
}

inline T_MsgMessageTime& T_MsgMessageDateTime::getOMessageTimeMutable () {
    set_has_oMessageTime();
    return _oMessageTime;
}

inline void T_MsgMessageDateTime::setOMessageTime (const T_MsgMessageTime& oMessageTime_) {
    set_has_oMessageTime();
    this->_oMessageTime = oMessageTime_;
}

inline void T_MsgMessageDateTime::set_has_oMessageDate () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_MsgMessageDateTime::clear_has_oMessageDate () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_MsgMessageDateTime::set_has_oMessageTime () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_MsgMessageDateTime::clear_has_oMessageTime () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_MsgMessageListSliceResultItem::T_MsgMessageListSliceResultItem ()  :
    _oMessageHandle (),
    _oMessageDateTime (),
    _sSubject (),
    _sShortMessage (),
    _bAttachmentFlag (false),
    _e8MessageType (::most_Msg_fi_types::T_e8_MsgMessageType__e8MSG_TYPE_SMS),
    _e8SendMessageResultType (::most_Msg_fi_types::T_e8_MsgSendMessageResultType__e8DELIVERY_SUCCESS),
    _bReadStatusFlag (false),
    _sFirstName (),
    _sLastName (),
    _sEmailAddress (),
    _sPhoneNumber (),
    _u32ContactHandle (0u),
    _e8PlaybackState (::most_Msg_fi_types::T_e8_MsgPlaybackState__e8PBS_PLAYING)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_MsgMessageListSliceResultItem::T_MsgMessageListSliceResultItem (const T_MsgMessageListSliceResultItem &rhs)  :
    _oMessageHandle (),
    _oMessageDateTime (),
    _sSubject (),
    _sShortMessage (),
    _bAttachmentFlag (false),
    _e8MessageType (::most_Msg_fi_types::T_e8_MsgMessageType__e8MSG_TYPE_SMS),
    _e8SendMessageResultType (::most_Msg_fi_types::T_e8_MsgSendMessageResultType__e8DELIVERY_SUCCESS),
    _bReadStatusFlag (false),
    _sFirstName (),
    _sLastName (),
    _sEmailAddress (),
    _sPhoneNumber (),
    _u32ContactHandle (0u),
    _e8PlaybackState (::most_Msg_fi_types::T_e8_MsgPlaybackState__e8PBS_PLAYING)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_MsgMessageListSliceResultItem::T_MsgMessageListSliceResultItem (const T_MsgMessageHandle& oMessageHandle_, const T_MsgMessageDateTime& oMessageDateTime_, const ::fi_basetypes_most::T_String& sSubject_, const ::fi_basetypes_most::T_String& sShortMessage_, bool bAttachmentFlag_, T_e8_MsgMessageType e8MessageType_, T_e8_MsgSendMessageResultType e8SendMessageResultType_, bool bReadStatusFlag_, const ::fi_basetypes_most::T_String& sFirstName_, const ::fi_basetypes_most::T_String& sLastName_, const ::fi_basetypes_most::T_String& sEmailAddress_, const ::fi_basetypes_most::T_String& sPhoneNumber_, uint32 u32ContactHandle_, T_e8_MsgPlaybackState e8PlaybackState_)  :
    _oMessageHandle (oMessageHandle_),
    _oMessageDateTime (oMessageDateTime_),
    _sSubject (sSubject_),
    _sShortMessage (sShortMessage_),
    _bAttachmentFlag (bAttachmentFlag_),
    _e8MessageType (e8MessageType_),
    _e8SendMessageResultType (e8SendMessageResultType_),
    _bReadStatusFlag (bReadStatusFlag_),
    _sFirstName (sFirstName_),
    _sLastName (sLastName_),
    _sEmailAddress (sEmailAddress_),
    _sPhoneNumber (sPhoneNumber_),
    _u32ContactHandle (u32ContactHandle_),
    _e8PlaybackState (e8PlaybackState_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sSubject_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sShortMessage_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e8_MsgMessageType_IsValid(e8MessageType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8MessageType_, "T_e8_MsgMessageType", "e8MessageType", "T_MsgMessageListSliceResultItem");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_MsgSendMessageResultType_IsValid(e8SendMessageResultType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8SendMessageResultType_, "T_e8_MsgSendMessageResultType", "e8SendMessageResultType", "T_MsgMessageListSliceResultItem");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sFirstName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sLastName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sEmailAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sPhoneNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e8_MsgPlaybackState_IsValid(e8PlaybackState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8PlaybackState_, "T_e8_MsgPlaybackState", "e8PlaybackState", "T_MsgMessageListSliceResultItem");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_MsgMessageListSliceResultItem::~T_MsgMessageListSliceResultItem() {
}

inline T_MsgMessageListSliceResultItem& T_MsgMessageListSliceResultItem::operator = (const T_MsgMessageListSliceResultItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasOMessageHandle()) {
            setOMessageHandle(rhs.getOMessageHandle());
        } else {
            clearOMessageHandle();
        }
        if (rhs.hasOMessageDateTime()) {
            setOMessageDateTime(rhs.getOMessageDateTime());
        } else {
            clearOMessageDateTime();
        }
        if (rhs.hasSSubject()) {
            setSSubject(rhs.getSSubject());
        } else {
            clearSSubject();
        }
        if (rhs.hasSShortMessage()) {
            setSShortMessage(rhs.getSShortMessage());
        } else {
            clearSShortMessage();
        }
        if (rhs.hasBAttachmentFlag()) {
            setBAttachmentFlag(rhs.getBAttachmentFlag());
        } else {
            clearBAttachmentFlag();
        }
        if (rhs.hasE8MessageType()) {
            setE8MessageType(rhs.getE8MessageType());
        } else {
            clearE8MessageType();
        }
        if (rhs.hasE8SendMessageResultType()) {
            setE8SendMessageResultType(rhs.getE8SendMessageResultType());
        } else {
            clearE8SendMessageResultType();
        }
        if (rhs.hasBReadStatusFlag()) {
            setBReadStatusFlag(rhs.getBReadStatusFlag());
        } else {
            clearBReadStatusFlag();
        }
        if (rhs.hasSFirstName()) {
            setSFirstName(rhs.getSFirstName());
        } else {
            clearSFirstName();
        }
        if (rhs.hasSLastName()) {
            setSLastName(rhs.getSLastName());
        } else {
            clearSLastName();
        }
        if (rhs.hasSEmailAddress()) {
            setSEmailAddress(rhs.getSEmailAddress());
        } else {
            clearSEmailAddress();
        }
        if (rhs.hasSPhoneNumber()) {
            setSPhoneNumber(rhs.getSPhoneNumber());
        } else {
            clearSPhoneNumber();
        }
        if (rhs.hasU32ContactHandle()) {
            setU32ContactHandle(rhs.getU32ContactHandle());
        } else {
            clearU32ContactHandle();
        }
        if (rhs.hasE8PlaybackState()) {
            setE8PlaybackState(rhs.getE8PlaybackState());
        } else {
            clearE8PlaybackState();
        }
    }
    return *this;
}

inline bool T_MsgMessageListSliceResultItem::operator == (const T_MsgMessageListSliceResultItem& rhs) const {
    return (((!hasOMessageHandle() && !rhs.hasOMessageHandle()) || getOMessageHandle() == rhs.getOMessageHandle()) &&
        ((!hasOMessageDateTime() && !rhs.hasOMessageDateTime()) || getOMessageDateTime() == rhs.getOMessageDateTime()) &&
        ((!hasSSubject() && !rhs.hasSSubject()) || getSSubject() == rhs.getSSubject()) &&
        ((!hasSShortMessage() && !rhs.hasSShortMessage()) || getSShortMessage() == rhs.getSShortMessage()) &&
        ((!hasBAttachmentFlag() && !rhs.hasBAttachmentFlag()) || getBAttachmentFlag() == rhs.getBAttachmentFlag()) &&
        ((!hasE8MessageType() && !rhs.hasE8MessageType()) || getE8MessageType() == rhs.getE8MessageType()) &&
        ((!hasE8SendMessageResultType() && !rhs.hasE8SendMessageResultType()) || getE8SendMessageResultType() == rhs.getE8SendMessageResultType()) &&
        ((!hasBReadStatusFlag() && !rhs.hasBReadStatusFlag()) || getBReadStatusFlag() == rhs.getBReadStatusFlag()) &&
        ((!hasSFirstName() && !rhs.hasSFirstName()) || getSFirstName() == rhs.getSFirstName()) &&
        ((!hasSLastName() && !rhs.hasSLastName()) || getSLastName() == rhs.getSLastName()) &&
        ((!hasSEmailAddress() && !rhs.hasSEmailAddress()) || getSEmailAddress() == rhs.getSEmailAddress()) &&
        ((!hasSPhoneNumber() && !rhs.hasSPhoneNumber()) || getSPhoneNumber() == rhs.getSPhoneNumber()) &&
        ((!hasU32ContactHandle() && !rhs.hasU32ContactHandle()) || getU32ContactHandle() == rhs.getU32ContactHandle()) &&
        ((!hasE8PlaybackState() && !rhs.hasE8PlaybackState()) || getE8PlaybackState() == rhs.getE8PlaybackState()));
}

inline bool T_MsgMessageListSliceResultItem::operator != (const T_MsgMessageListSliceResultItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_MsgMessageListSliceResultItem::operator < (const T_MsgMessageListSliceResultItem& rhs) const {
    if (hasOMessageHandle() || rhs.hasOMessageHandle()) {
        if (getOMessageHandle() < rhs.getOMessageHandle()) return true;
        if (getOMessageHandle() > rhs.getOMessageHandle()) return false;
    }
    if (hasOMessageDateTime() || rhs.hasOMessageDateTime()) {
        if (getOMessageDateTime() < rhs.getOMessageDateTime()) return true;
        if (getOMessageDateTime() > rhs.getOMessageDateTime()) return false;
    }
    if (hasSSubject() || rhs.hasSSubject()) {
        if (getSSubject() < rhs.getSSubject()) return true;
        if (getSSubject() > rhs.getSSubject()) return false;
    }
    if (hasSShortMessage() || rhs.hasSShortMessage()) {
        if (getSShortMessage() < rhs.getSShortMessage()) return true;
        if (getSShortMessage() > rhs.getSShortMessage()) return false;
    }
    if (hasBAttachmentFlag() || rhs.hasBAttachmentFlag()) {
        if (getBAttachmentFlag() < rhs.getBAttachmentFlag()) return true;
        if (getBAttachmentFlag() > rhs.getBAttachmentFlag()) return false;
    }
    if (hasE8MessageType() || rhs.hasE8MessageType()) {
        if ((uint32)getE8MessageType() < (uint32)rhs.getE8MessageType()) return true;
        if ((uint32)getE8MessageType() > (uint32)rhs.getE8MessageType()) return false;
    }
    if (hasE8SendMessageResultType() || rhs.hasE8SendMessageResultType()) {
        if ((uint32)getE8SendMessageResultType() < (uint32)rhs.getE8SendMessageResultType()) return true;
        if ((uint32)getE8SendMessageResultType() > (uint32)rhs.getE8SendMessageResultType()) return false;
    }
    if (hasBReadStatusFlag() || rhs.hasBReadStatusFlag()) {
        if (getBReadStatusFlag() < rhs.getBReadStatusFlag()) return true;
        if (getBReadStatusFlag() > rhs.getBReadStatusFlag()) return false;
    }
    if (hasSFirstName() || rhs.hasSFirstName()) {
        if (getSFirstName() < rhs.getSFirstName()) return true;
        if (getSFirstName() > rhs.getSFirstName()) return false;
    }
    if (hasSLastName() || rhs.hasSLastName()) {
        if (getSLastName() < rhs.getSLastName()) return true;
        if (getSLastName() > rhs.getSLastName()) return false;
    }
    if (hasSEmailAddress() || rhs.hasSEmailAddress()) {
        if (getSEmailAddress() < rhs.getSEmailAddress()) return true;
        if (getSEmailAddress() > rhs.getSEmailAddress()) return false;
    }
    if (hasSPhoneNumber() || rhs.hasSPhoneNumber()) {
        if (getSPhoneNumber() < rhs.getSPhoneNumber()) return true;
        if (getSPhoneNumber() > rhs.getSPhoneNumber()) return false;
    }
    if (hasU32ContactHandle() || rhs.hasU32ContactHandle()) {
        if (getU32ContactHandle() < rhs.getU32ContactHandle()) return true;
        if (getU32ContactHandle() > rhs.getU32ContactHandle()) return false;
    }
    if (hasE8PlaybackState() || rhs.hasE8PlaybackState()) {
        if ((uint32)getE8PlaybackState() < (uint32)rhs.getE8PlaybackState()) return true;
        if ((uint32)getE8PlaybackState() > (uint32)rhs.getE8PlaybackState()) return false;
    }
    return false;
}

inline bool T_MsgMessageListSliceResultItem::operator > (const T_MsgMessageListSliceResultItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_MsgMessageListSliceResultItem::clear() {
    clearOMessageHandle();
    clearOMessageDateTime();
    clearSSubject();
    clearSShortMessage();
    clearBAttachmentFlag();
    clearE8MessageType();
    clearE8SendMessageResultType();
    clearBReadStatusFlag();
    clearSFirstName();
    clearSLastName();
    clearSEmailAddress();
    clearSPhoneNumber();
    clearU32ContactHandle();
    clearE8PlaybackState();
}

inline void T_MsgMessageListSliceResultItem::clearOMessageHandle() {
    if (hasOMessageHandle()) {
         clear_has_oMessageHandle();
        _oMessageHandle.clear();
     }
}

inline bool T_MsgMessageListSliceResultItem::hasOMessageHandle () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const T_MsgMessageHandle& T_MsgMessageListSliceResultItem::getOMessageHandle () const {
    return _oMessageHandle;
}

inline T_MsgMessageHandle& T_MsgMessageListSliceResultItem::getOMessageHandleMutable () {
    set_has_oMessageHandle();
    return _oMessageHandle;
}

inline void T_MsgMessageListSliceResultItem::setOMessageHandle (const T_MsgMessageHandle& oMessageHandle_) {
    set_has_oMessageHandle();
    this->_oMessageHandle = oMessageHandle_;
}

inline void T_MsgMessageListSliceResultItem::clearOMessageDateTime() {
    if (hasOMessageDateTime()) {
         clear_has_oMessageDateTime();
        _oMessageDateTime.clear();
     }
}

inline bool T_MsgMessageListSliceResultItem::hasOMessageDateTime () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const T_MsgMessageDateTime& T_MsgMessageListSliceResultItem::getOMessageDateTime () const {
    return _oMessageDateTime;
}

inline T_MsgMessageDateTime& T_MsgMessageListSliceResultItem::getOMessageDateTimeMutable () {
    set_has_oMessageDateTime();
    return _oMessageDateTime;
}

inline void T_MsgMessageListSliceResultItem::setOMessageDateTime (const T_MsgMessageDateTime& oMessageDateTime_) {
    set_has_oMessageDateTime();
    this->_oMessageDateTime = oMessageDateTime_;
}

inline void T_MsgMessageListSliceResultItem::clearSSubject() {
    if (hasSSubject()) {
         clear_has_sSubject();
        _sSubject.clear();
     }
}

inline bool T_MsgMessageListSliceResultItem::hasSSubject () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_MsgMessageListSliceResultItem::getSSubject () const {
    return _sSubject;
}

inline ::fi_basetypes_most::T_String& T_MsgMessageListSliceResultItem::getSSubjectMutable () {
    set_has_sSubject();
    return _sSubject;
}

inline void T_MsgMessageListSliceResultItem::setSSubject (const ::fi_basetypes_most::T_String& sSubject_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sSubject_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sSubject();
    this->_sSubject = sSubject_;
}

inline void T_MsgMessageListSliceResultItem::clearSShortMessage() {
    if (hasSShortMessage()) {
         clear_has_sShortMessage();
        _sShortMessage.clear();
     }
}

inline bool T_MsgMessageListSliceResultItem::hasSShortMessage () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_MsgMessageListSliceResultItem::getSShortMessage () const {
    return _sShortMessage;
}

inline ::fi_basetypes_most::T_String& T_MsgMessageListSliceResultItem::getSShortMessageMutable () {
    set_has_sShortMessage();
    return _sShortMessage;
}

inline void T_MsgMessageListSliceResultItem::setSShortMessage (const ::fi_basetypes_most::T_String& sShortMessage_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sShortMessage_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sShortMessage();
    this->_sShortMessage = sShortMessage_;
}

inline void T_MsgMessageListSliceResultItem::clearBAttachmentFlag() {
    if (hasBAttachmentFlag()) {
         clear_has_bAttachmentFlag();
        _bAttachmentFlag = false;
     }
}

inline bool T_MsgMessageListSliceResultItem::hasBAttachmentFlag () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline bool T_MsgMessageListSliceResultItem::getBAttachmentFlag () const {
    return _bAttachmentFlag;
}

inline void T_MsgMessageListSliceResultItem::setBAttachmentFlag (bool bAttachmentFlag_) {
    set_has_bAttachmentFlag();
    this->_bAttachmentFlag = bAttachmentFlag_;
}

inline void T_MsgMessageListSliceResultItem::clearE8MessageType() {
    if (hasE8MessageType()) {
         clear_has_e8MessageType();
        _e8MessageType = ::most_Msg_fi_types::T_e8_MsgMessageType__e8MSG_TYPE_SMS;
     }
}

inline bool T_MsgMessageListSliceResultItem::hasE8MessageType () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline T_e8_MsgMessageType T_MsgMessageListSliceResultItem::getE8MessageType () const {
    return _e8MessageType;
}

inline void T_MsgMessageListSliceResultItem::setE8MessageType (T_e8_MsgMessageType e8MessageType_) {
    #ifndef NDEBUG
    if (!(T_e8_MsgMessageType_IsValid(e8MessageType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8MessageType_, "T_e8_MsgMessageType", "e8MessageType", "T_MsgMessageListSliceResultItem");
    }
    #endif
    set_has_e8MessageType();
    this->_e8MessageType = e8MessageType_;
}

inline void T_MsgMessageListSliceResultItem::clearE8SendMessageResultType() {
    if (hasE8SendMessageResultType()) {
         clear_has_e8SendMessageResultType();
        _e8SendMessageResultType = ::most_Msg_fi_types::T_e8_MsgSendMessageResultType__e8DELIVERY_SUCCESS;
     }
}

inline bool T_MsgMessageListSliceResultItem::hasE8SendMessageResultType () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline T_e8_MsgSendMessageResultType T_MsgMessageListSliceResultItem::getE8SendMessageResultType () const {
    return _e8SendMessageResultType;
}

inline void T_MsgMessageListSliceResultItem::setE8SendMessageResultType (T_e8_MsgSendMessageResultType e8SendMessageResultType_) {
    #ifndef NDEBUG
    if (!(T_e8_MsgSendMessageResultType_IsValid(e8SendMessageResultType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8SendMessageResultType_, "T_e8_MsgSendMessageResultType", "e8SendMessageResultType", "T_MsgMessageListSliceResultItem");
    }
    #endif
    set_has_e8SendMessageResultType();
    this->_e8SendMessageResultType = e8SendMessageResultType_;
}

inline void T_MsgMessageListSliceResultItem::clearBReadStatusFlag() {
    if (hasBReadStatusFlag()) {
         clear_has_bReadStatusFlag();
        _bReadStatusFlag = false;
     }
}

inline bool T_MsgMessageListSliceResultItem::hasBReadStatusFlag () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline bool T_MsgMessageListSliceResultItem::getBReadStatusFlag () const {
    return _bReadStatusFlag;
}

inline void T_MsgMessageListSliceResultItem::setBReadStatusFlag (bool bReadStatusFlag_) {
    set_has_bReadStatusFlag();
    this->_bReadStatusFlag = bReadStatusFlag_;
}

inline void T_MsgMessageListSliceResultItem::clearSFirstName() {
    if (hasSFirstName()) {
         clear_has_sFirstName();
        _sFirstName.clear();
     }
}

inline bool T_MsgMessageListSliceResultItem::hasSFirstName () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_MsgMessageListSliceResultItem::getSFirstName () const {
    return _sFirstName;
}

inline ::fi_basetypes_most::T_String& T_MsgMessageListSliceResultItem::getSFirstNameMutable () {
    set_has_sFirstName();
    return _sFirstName;
}

inline void T_MsgMessageListSliceResultItem::setSFirstName (const ::fi_basetypes_most::T_String& sFirstName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sFirstName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sFirstName();
    this->_sFirstName = sFirstName_;
}

inline void T_MsgMessageListSliceResultItem::clearSLastName() {
    if (hasSLastName()) {
         clear_has_sLastName();
        _sLastName.clear();
     }
}

inline bool T_MsgMessageListSliceResultItem::hasSLastName () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_MsgMessageListSliceResultItem::getSLastName () const {
    return _sLastName;
}

inline ::fi_basetypes_most::T_String& T_MsgMessageListSliceResultItem::getSLastNameMutable () {
    set_has_sLastName();
    return _sLastName;
}

inline void T_MsgMessageListSliceResultItem::setSLastName (const ::fi_basetypes_most::T_String& sLastName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sLastName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sLastName();
    this->_sLastName = sLastName_;
}

inline void T_MsgMessageListSliceResultItem::clearSEmailAddress() {
    if (hasSEmailAddress()) {
         clear_has_sEmailAddress();
        _sEmailAddress.clear();
     }
}

inline bool T_MsgMessageListSliceResultItem::hasSEmailAddress () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_MsgMessageListSliceResultItem::getSEmailAddress () const {
    return _sEmailAddress;
}

inline ::fi_basetypes_most::T_String& T_MsgMessageListSliceResultItem::getSEmailAddressMutable () {
    set_has_sEmailAddress();
    return _sEmailAddress;
}

inline void T_MsgMessageListSliceResultItem::setSEmailAddress (const ::fi_basetypes_most::T_String& sEmailAddress_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sEmailAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sEmailAddress();
    this->_sEmailAddress = sEmailAddress_;
}

inline void T_MsgMessageListSliceResultItem::clearSPhoneNumber() {
    if (hasSPhoneNumber()) {
         clear_has_sPhoneNumber();
        _sPhoneNumber.clear();
     }
}

inline bool T_MsgMessageListSliceResultItem::hasSPhoneNumber () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_MsgMessageListSliceResultItem::getSPhoneNumber () const {
    return _sPhoneNumber;
}

inline ::fi_basetypes_most::T_String& T_MsgMessageListSliceResultItem::getSPhoneNumberMutable () {
    set_has_sPhoneNumber();
    return _sPhoneNumber;
}

inline void T_MsgMessageListSliceResultItem::setSPhoneNumber (const ::fi_basetypes_most::T_String& sPhoneNumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sPhoneNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sPhoneNumber();
    this->_sPhoneNumber = sPhoneNumber_;
}

inline void T_MsgMessageListSliceResultItem::clearU32ContactHandle() {
    if (hasU32ContactHandle()) {
         clear_has_u32ContactHandle();
        _u32ContactHandle = 0u;
     }
}

inline bool T_MsgMessageListSliceResultItem::hasU32ContactHandle () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline uint32 T_MsgMessageListSliceResultItem::getU32ContactHandle () const {
    return _u32ContactHandle;
}

inline void T_MsgMessageListSliceResultItem::setU32ContactHandle (uint32 u32ContactHandle_) {
    set_has_u32ContactHandle();
    this->_u32ContactHandle = u32ContactHandle_;
}

inline void T_MsgMessageListSliceResultItem::clearE8PlaybackState() {
    if (hasE8PlaybackState()) {
         clear_has_e8PlaybackState();
        _e8PlaybackState = ::most_Msg_fi_types::T_e8_MsgPlaybackState__e8PBS_PLAYING;
     }
}

inline bool T_MsgMessageListSliceResultItem::hasE8PlaybackState () const {
    return (_has_bits_[0] & (1u << 13)) > 0;
}

inline T_e8_MsgPlaybackState T_MsgMessageListSliceResultItem::getE8PlaybackState () const {
    return _e8PlaybackState;
}

inline void T_MsgMessageListSliceResultItem::setE8PlaybackState (T_e8_MsgPlaybackState e8PlaybackState_) {
    #ifndef NDEBUG
    if (!(T_e8_MsgPlaybackState_IsValid(e8PlaybackState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8PlaybackState_, "T_e8_MsgPlaybackState", "e8PlaybackState", "T_MsgMessageListSliceResultItem");
    }
    #endif
    set_has_e8PlaybackState();
    this->_e8PlaybackState = e8PlaybackState_;
}

inline void T_MsgMessageListSliceResultItem::set_has_oMessageHandle () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_MsgMessageListSliceResultItem::clear_has_oMessageHandle () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_MsgMessageListSliceResultItem::set_has_oMessageDateTime () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_MsgMessageListSliceResultItem::clear_has_oMessageDateTime () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_MsgMessageListSliceResultItem::set_has_sSubject () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_MsgMessageListSliceResultItem::clear_has_sSubject () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_MsgMessageListSliceResultItem::set_has_sShortMessage () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_MsgMessageListSliceResultItem::clear_has_sShortMessage () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_MsgMessageListSliceResultItem::set_has_bAttachmentFlag () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_MsgMessageListSliceResultItem::clear_has_bAttachmentFlag () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_MsgMessageListSliceResultItem::set_has_e8MessageType () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_MsgMessageListSliceResultItem::clear_has_e8MessageType () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_MsgMessageListSliceResultItem::set_has_e8SendMessageResultType () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_MsgMessageListSliceResultItem::clear_has_e8SendMessageResultType () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_MsgMessageListSliceResultItem::set_has_bReadStatusFlag () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_MsgMessageListSliceResultItem::clear_has_bReadStatusFlag () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_MsgMessageListSliceResultItem::set_has_sFirstName () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_MsgMessageListSliceResultItem::clear_has_sFirstName () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_MsgMessageListSliceResultItem::set_has_sLastName () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_MsgMessageListSliceResultItem::clear_has_sLastName () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_MsgMessageListSliceResultItem::set_has_sEmailAddress () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_MsgMessageListSliceResultItem::clear_has_sEmailAddress () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void T_MsgMessageListSliceResultItem::set_has_sPhoneNumber () {
    _has_bits_[0] |= 1u << 11;
}

inline void T_MsgMessageListSliceResultItem::clear_has_sPhoneNumber () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void T_MsgMessageListSliceResultItem::set_has_u32ContactHandle () {
    _has_bits_[0] |= 1u << 12;
}

inline void T_MsgMessageListSliceResultItem::clear_has_u32ContactHandle () {
    _has_bits_[0] &= ~ (1u << 12);
}

inline void T_MsgMessageListSliceResultItem::set_has_e8PlaybackState () {
    _has_bits_[0] |= 1u << 13;
}

inline void T_MsgMessageListSliceResultItem::clear_has_e8PlaybackState () {
    _has_bits_[0] &= ~ (1u << 13);
}

inline  T_MsgFolderListResultItem::T_MsgFolderListResultItem ()  :
    _u32FolderHandle (0u),
    _sFolderName (),
    _e8FolderType (::most_Msg_fi_types::T_e8_MsgFolderType__e8MSG_FOLDER_INBOX),
    _u8NumSubfolders (0u),
    _u16NumMessages (0u),
    _u16NumUnreadMessages (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_MsgFolderListResultItem::T_MsgFolderListResultItem (const T_MsgFolderListResultItem &rhs)  :
    _u32FolderHandle (0u),
    _sFolderName (),
    _e8FolderType (::most_Msg_fi_types::T_e8_MsgFolderType__e8MSG_FOLDER_INBOX),
    _u8NumSubfolders (0u),
    _u16NumMessages (0u),
    _u16NumUnreadMessages (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_MsgFolderListResultItem::T_MsgFolderListResultItem (uint32 u32FolderHandle_, const ::fi_basetypes_most::T_String& sFolderName_, T_e8_MsgFolderType e8FolderType_, uint8 u8NumSubfolders_, uint16 u16NumMessages_, uint16 u16NumUnreadMessages_)  :
    _u32FolderHandle (u32FolderHandle_),
    _sFolderName (sFolderName_),
    _e8FolderType (e8FolderType_),
    _u8NumSubfolders (u8NumSubfolders_),
    _u16NumMessages (u16NumMessages_),
    _u16NumUnreadMessages (u16NumUnreadMessages_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sFolderName_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e8_MsgFolderType_IsValid(e8FolderType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8FolderType_, "T_e8_MsgFolderType", "e8FolderType", "T_MsgFolderListResultItem");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_MsgFolderListResultItem::~T_MsgFolderListResultItem() {
}

inline T_MsgFolderListResultItem& T_MsgFolderListResultItem::operator = (const T_MsgFolderListResultItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU32FolderHandle()) {
            setU32FolderHandle(rhs.getU32FolderHandle());
        } else {
            clearU32FolderHandle();
        }
        if (rhs.hasSFolderName()) {
            setSFolderName(rhs.getSFolderName());
        } else {
            clearSFolderName();
        }
        if (rhs.hasE8FolderType()) {
            setE8FolderType(rhs.getE8FolderType());
        } else {
            clearE8FolderType();
        }
        if (rhs.hasU8NumSubfolders()) {
            setU8NumSubfolders(rhs.getU8NumSubfolders());
        } else {
            clearU8NumSubfolders();
        }
        if (rhs.hasU16NumMessages()) {
            setU16NumMessages(rhs.getU16NumMessages());
        } else {
            clearU16NumMessages();
        }
        if (rhs.hasU16NumUnreadMessages()) {
            setU16NumUnreadMessages(rhs.getU16NumUnreadMessages());
        } else {
            clearU16NumUnreadMessages();
        }
    }
    return *this;
}

inline bool T_MsgFolderListResultItem::operator == (const T_MsgFolderListResultItem& rhs) const {
    return (((!hasU32FolderHandle() && !rhs.hasU32FolderHandle()) || getU32FolderHandle() == rhs.getU32FolderHandle()) &&
        ((!hasSFolderName() && !rhs.hasSFolderName()) || getSFolderName() == rhs.getSFolderName()) &&
        ((!hasE8FolderType() && !rhs.hasE8FolderType()) || getE8FolderType() == rhs.getE8FolderType()) &&
        ((!hasU8NumSubfolders() && !rhs.hasU8NumSubfolders()) || getU8NumSubfolders() == rhs.getU8NumSubfolders()) &&
        ((!hasU16NumMessages() && !rhs.hasU16NumMessages()) || getU16NumMessages() == rhs.getU16NumMessages()) &&
        ((!hasU16NumUnreadMessages() && !rhs.hasU16NumUnreadMessages()) || getU16NumUnreadMessages() == rhs.getU16NumUnreadMessages()));
}

inline bool T_MsgFolderListResultItem::operator != (const T_MsgFolderListResultItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_MsgFolderListResultItem::operator < (const T_MsgFolderListResultItem& rhs) const {
    if (hasU32FolderHandle() || rhs.hasU32FolderHandle()) {
        if (getU32FolderHandle() < rhs.getU32FolderHandle()) return true;
        if (getU32FolderHandle() > rhs.getU32FolderHandle()) return false;
    }
    if (hasSFolderName() || rhs.hasSFolderName()) {
        if (getSFolderName() < rhs.getSFolderName()) return true;
        if (getSFolderName() > rhs.getSFolderName()) return false;
    }
    if (hasE8FolderType() || rhs.hasE8FolderType()) {
        if ((uint32)getE8FolderType() < (uint32)rhs.getE8FolderType()) return true;
        if ((uint32)getE8FolderType() > (uint32)rhs.getE8FolderType()) return false;
    }
    if (hasU8NumSubfolders() || rhs.hasU8NumSubfolders()) {
        if (getU8NumSubfolders() < rhs.getU8NumSubfolders()) return true;
        if (getU8NumSubfolders() > rhs.getU8NumSubfolders()) return false;
    }
    if (hasU16NumMessages() || rhs.hasU16NumMessages()) {
        if (getU16NumMessages() < rhs.getU16NumMessages()) return true;
        if (getU16NumMessages() > rhs.getU16NumMessages()) return false;
    }
    if (hasU16NumUnreadMessages() || rhs.hasU16NumUnreadMessages()) {
        if (getU16NumUnreadMessages() < rhs.getU16NumUnreadMessages()) return true;
        if (getU16NumUnreadMessages() > rhs.getU16NumUnreadMessages()) return false;
    }
    return false;
}

inline bool T_MsgFolderListResultItem::operator > (const T_MsgFolderListResultItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_MsgFolderListResultItem::clear() {
    clearU32FolderHandle();
    clearSFolderName();
    clearE8FolderType();
    clearU8NumSubfolders();
    clearU16NumMessages();
    clearU16NumUnreadMessages();
}

inline void T_MsgFolderListResultItem::clearU32FolderHandle() {
    if (hasU32FolderHandle()) {
         clear_has_u32FolderHandle();
        _u32FolderHandle = 0u;
     }
}

inline bool T_MsgFolderListResultItem::hasU32FolderHandle () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_MsgFolderListResultItem::getU32FolderHandle () const {
    return _u32FolderHandle;
}

inline void T_MsgFolderListResultItem::setU32FolderHandle (uint32 u32FolderHandle_) {
    set_has_u32FolderHandle();
    this->_u32FolderHandle = u32FolderHandle_;
}

inline void T_MsgFolderListResultItem::clearSFolderName() {
    if (hasSFolderName()) {
         clear_has_sFolderName();
        _sFolderName.clear();
     }
}

inline bool T_MsgFolderListResultItem::hasSFolderName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_MsgFolderListResultItem::getSFolderName () const {
    return _sFolderName;
}

inline ::fi_basetypes_most::T_String& T_MsgFolderListResultItem::getSFolderNameMutable () {
    set_has_sFolderName();
    return _sFolderName;
}

inline void T_MsgFolderListResultItem::setSFolderName (const ::fi_basetypes_most::T_String& sFolderName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sFolderName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sFolderName();
    this->_sFolderName = sFolderName_;
}

inline void T_MsgFolderListResultItem::clearE8FolderType() {
    if (hasE8FolderType()) {
         clear_has_e8FolderType();
        _e8FolderType = ::most_Msg_fi_types::T_e8_MsgFolderType__e8MSG_FOLDER_INBOX;
     }
}

inline bool T_MsgFolderListResultItem::hasE8FolderType () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_MsgFolderType T_MsgFolderListResultItem::getE8FolderType () const {
    return _e8FolderType;
}

inline void T_MsgFolderListResultItem::setE8FolderType (T_e8_MsgFolderType e8FolderType_) {
    #ifndef NDEBUG
    if (!(T_e8_MsgFolderType_IsValid(e8FolderType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8FolderType_, "T_e8_MsgFolderType", "e8FolderType", "T_MsgFolderListResultItem");
    }
    #endif
    set_has_e8FolderType();
    this->_e8FolderType = e8FolderType_;
}

inline void T_MsgFolderListResultItem::clearU8NumSubfolders() {
    if (hasU8NumSubfolders()) {
         clear_has_u8NumSubfolders();
        _u8NumSubfolders = 0u;
     }
}

inline bool T_MsgFolderListResultItem::hasU8NumSubfolders () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 T_MsgFolderListResultItem::getU8NumSubfolders () const {
    return _u8NumSubfolders;
}

inline void T_MsgFolderListResultItem::setU8NumSubfolders (uint8 u8NumSubfolders_) {
    set_has_u8NumSubfolders();
    this->_u8NumSubfolders = u8NumSubfolders_;
}

inline void T_MsgFolderListResultItem::clearU16NumMessages() {
    if (hasU16NumMessages()) {
         clear_has_u16NumMessages();
        _u16NumMessages = 0u;
     }
}

inline bool T_MsgFolderListResultItem::hasU16NumMessages () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint16 T_MsgFolderListResultItem::getU16NumMessages () const {
    return _u16NumMessages;
}

inline void T_MsgFolderListResultItem::setU16NumMessages (uint16 u16NumMessages_) {
    set_has_u16NumMessages();
    this->_u16NumMessages = u16NumMessages_;
}

inline void T_MsgFolderListResultItem::clearU16NumUnreadMessages() {
    if (hasU16NumUnreadMessages()) {
         clear_has_u16NumUnreadMessages();
        _u16NumUnreadMessages = 0u;
     }
}

inline bool T_MsgFolderListResultItem::hasU16NumUnreadMessages () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint16 T_MsgFolderListResultItem::getU16NumUnreadMessages () const {
    return _u16NumUnreadMessages;
}

inline void T_MsgFolderListResultItem::setU16NumUnreadMessages (uint16 u16NumUnreadMessages_) {
    set_has_u16NumUnreadMessages();
    this->_u16NumUnreadMessages = u16NumUnreadMessages_;
}

inline void T_MsgFolderListResultItem::set_has_u32FolderHandle () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_MsgFolderListResultItem::clear_has_u32FolderHandle () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_MsgFolderListResultItem::set_has_sFolderName () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_MsgFolderListResultItem::clear_has_sFolderName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_MsgFolderListResultItem::set_has_e8FolderType () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_MsgFolderListResultItem::clear_has_e8FolderType () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_MsgFolderListResultItem::set_has_u8NumSubfolders () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_MsgFolderListResultItem::clear_has_u8NumSubfolders () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_MsgFolderListResultItem::set_has_u16NumMessages () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_MsgFolderListResultItem::clear_has_u16NumMessages () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_MsgFolderListResultItem::set_has_u16NumUnreadMessages () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_MsgFolderListResultItem::clear_has_u16NumUnreadMessages () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline  T_MsgAccountListResultItem::T_MsgAccountListResultItem ()  :
    _u16AccountHandle (0u),
    _sAccountName (),
    _bActiveAccountStatus (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_MsgAccountListResultItem::T_MsgAccountListResultItem (const T_MsgAccountListResultItem &rhs)  :
    _u16AccountHandle (0u),
    _sAccountName (),
    _bActiveAccountStatus (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_MsgAccountListResultItem::T_MsgAccountListResultItem (uint16 u16AccountHandle_, const ::fi_basetypes_most::T_String& sAccountName_, bool bActiveAccountStatus_)  :
    _u16AccountHandle (u16AccountHandle_),
    _sAccountName (sAccountName_),
    _bActiveAccountStatus (bActiveAccountStatus_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sAccountName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_MsgAccountListResultItem::~T_MsgAccountListResultItem() {
}

inline T_MsgAccountListResultItem& T_MsgAccountListResultItem::operator = (const T_MsgAccountListResultItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU16AccountHandle()) {
            setU16AccountHandle(rhs.getU16AccountHandle());
        } else {
            clearU16AccountHandle();
        }
        if (rhs.hasSAccountName()) {
            setSAccountName(rhs.getSAccountName());
        } else {
            clearSAccountName();
        }
        if (rhs.hasBActiveAccountStatus()) {
            setBActiveAccountStatus(rhs.getBActiveAccountStatus());
        } else {
            clearBActiveAccountStatus();
        }
    }
    return *this;
}

inline bool T_MsgAccountListResultItem::operator == (const T_MsgAccountListResultItem& rhs) const {
    return (((!hasU16AccountHandle() && !rhs.hasU16AccountHandle()) || getU16AccountHandle() == rhs.getU16AccountHandle()) &&
        ((!hasSAccountName() && !rhs.hasSAccountName()) || getSAccountName() == rhs.getSAccountName()) &&
        ((!hasBActiveAccountStatus() && !rhs.hasBActiveAccountStatus()) || getBActiveAccountStatus() == rhs.getBActiveAccountStatus()));
}

inline bool T_MsgAccountListResultItem::operator != (const T_MsgAccountListResultItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_MsgAccountListResultItem::operator < (const T_MsgAccountListResultItem& rhs) const {
    if (hasU16AccountHandle() || rhs.hasU16AccountHandle()) {
        if (getU16AccountHandle() < rhs.getU16AccountHandle()) return true;
        if (getU16AccountHandle() > rhs.getU16AccountHandle()) return false;
    }
    if (hasSAccountName() || rhs.hasSAccountName()) {
        if (getSAccountName() < rhs.getSAccountName()) return true;
        if (getSAccountName() > rhs.getSAccountName()) return false;
    }
    if (hasBActiveAccountStatus() || rhs.hasBActiveAccountStatus()) {
        if (getBActiveAccountStatus() < rhs.getBActiveAccountStatus()) return true;
        if (getBActiveAccountStatus() > rhs.getBActiveAccountStatus()) return false;
    }
    return false;
}

inline bool T_MsgAccountListResultItem::operator > (const T_MsgAccountListResultItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_MsgAccountListResultItem::clear() {
    clearU16AccountHandle();
    clearSAccountName();
    clearBActiveAccountStatus();
}

inline void T_MsgAccountListResultItem::clearU16AccountHandle() {
    if (hasU16AccountHandle()) {
         clear_has_u16AccountHandle();
        _u16AccountHandle = 0u;
     }
}

inline bool T_MsgAccountListResultItem::hasU16AccountHandle () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 T_MsgAccountListResultItem::getU16AccountHandle () const {
    return _u16AccountHandle;
}

inline void T_MsgAccountListResultItem::setU16AccountHandle (uint16 u16AccountHandle_) {
    set_has_u16AccountHandle();
    this->_u16AccountHandle = u16AccountHandle_;
}

inline void T_MsgAccountListResultItem::clearSAccountName() {
    if (hasSAccountName()) {
         clear_has_sAccountName();
        _sAccountName.clear();
     }
}

inline bool T_MsgAccountListResultItem::hasSAccountName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_MsgAccountListResultItem::getSAccountName () const {
    return _sAccountName;
}

inline ::fi_basetypes_most::T_String& T_MsgAccountListResultItem::getSAccountNameMutable () {
    set_has_sAccountName();
    return _sAccountName;
}

inline void T_MsgAccountListResultItem::setSAccountName (const ::fi_basetypes_most::T_String& sAccountName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sAccountName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sAccountName();
    this->_sAccountName = sAccountName_;
}

inline void T_MsgAccountListResultItem::clearBActiveAccountStatus() {
    if (hasBActiveAccountStatus()) {
         clear_has_bActiveAccountStatus();
        _bActiveAccountStatus = false;
     }
}

inline bool T_MsgAccountListResultItem::hasBActiveAccountStatus () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline bool T_MsgAccountListResultItem::getBActiveAccountStatus () const {
    return _bActiveAccountStatus;
}

inline void T_MsgAccountListResultItem::setBActiveAccountStatus (bool bActiveAccountStatus_) {
    set_has_bActiveAccountStatus();
    this->_bActiveAccountStatus = bActiveAccountStatus_;
}

inline void T_MsgAccountListResultItem::set_has_u16AccountHandle () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_MsgAccountListResultItem::clear_has_u16AccountHandle () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_MsgAccountListResultItem::set_has_sAccountName () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_MsgAccountListResultItem::clear_has_sAccountName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_MsgAccountListResultItem::set_has_bActiveAccountStatus () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_MsgAccountListResultItem::clear_has_bActiveAccountStatus () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_MsgActiveAccount::T_MsgActiveAccount ()  :
    _u16AccountHandle (0u),
    _sAccountName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_MsgActiveAccount::T_MsgActiveAccount (const T_MsgActiveAccount &rhs)  :
    _u16AccountHandle (0u),
    _sAccountName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_MsgActiveAccount::T_MsgActiveAccount (uint16 u16AccountHandle_, const ::fi_basetypes_most::T_String& sAccountName_)  :
    _u16AccountHandle (u16AccountHandle_),
    _sAccountName (sAccountName_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sAccountName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_MsgActiveAccount::~T_MsgActiveAccount() {
}

inline T_MsgActiveAccount& T_MsgActiveAccount::operator = (const T_MsgActiveAccount& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU16AccountHandle()) {
            setU16AccountHandle(rhs.getU16AccountHandle());
        } else {
            clearU16AccountHandle();
        }
        if (rhs.hasSAccountName()) {
            setSAccountName(rhs.getSAccountName());
        } else {
            clearSAccountName();
        }
    }
    return *this;
}

inline bool T_MsgActiveAccount::operator == (const T_MsgActiveAccount& rhs) const {
    return (((!hasU16AccountHandle() && !rhs.hasU16AccountHandle()) || getU16AccountHandle() == rhs.getU16AccountHandle()) &&
        ((!hasSAccountName() && !rhs.hasSAccountName()) || getSAccountName() == rhs.getSAccountName()));
}

inline bool T_MsgActiveAccount::operator != (const T_MsgActiveAccount& rhs) const {
    return ! (*this == rhs);
}

inline bool T_MsgActiveAccount::operator < (const T_MsgActiveAccount& rhs) const {
    if (hasU16AccountHandle() || rhs.hasU16AccountHandle()) {
        if (getU16AccountHandle() < rhs.getU16AccountHandle()) return true;
        if (getU16AccountHandle() > rhs.getU16AccountHandle()) return false;
    }
    if (hasSAccountName() || rhs.hasSAccountName()) {
        if (getSAccountName() < rhs.getSAccountName()) return true;
        if (getSAccountName() > rhs.getSAccountName()) return false;
    }
    return false;
}

inline bool T_MsgActiveAccount::operator > (const T_MsgActiveAccount& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_MsgActiveAccount::clear() {
    clearU16AccountHandle();
    clearSAccountName();
}

inline void T_MsgActiveAccount::clearU16AccountHandle() {
    if (hasU16AccountHandle()) {
         clear_has_u16AccountHandle();
        _u16AccountHandle = 0u;
     }
}

inline bool T_MsgActiveAccount::hasU16AccountHandle () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 T_MsgActiveAccount::getU16AccountHandle () const {
    return _u16AccountHandle;
}

inline void T_MsgActiveAccount::setU16AccountHandle (uint16 u16AccountHandle_) {
    set_has_u16AccountHandle();
    this->_u16AccountHandle = u16AccountHandle_;
}

inline void T_MsgActiveAccount::clearSAccountName() {
    if (hasSAccountName()) {
         clear_has_sAccountName();
        _sAccountName.clear();
     }
}

inline bool T_MsgActiveAccount::hasSAccountName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_MsgActiveAccount::getSAccountName () const {
    return _sAccountName;
}

inline ::fi_basetypes_most::T_String& T_MsgActiveAccount::getSAccountNameMutable () {
    set_has_sAccountName();
    return _sAccountName;
}

inline void T_MsgActiveAccount::setSAccountName (const ::fi_basetypes_most::T_String& sAccountName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sAccountName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sAccountName();
    this->_sAccountName = sAccountName_;
}

inline void T_MsgActiveAccount::set_has_u16AccountHandle () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_MsgActiveAccount::clear_has_u16AccountHandle () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_MsgActiveAccount::set_has_sAccountName () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_MsgActiveAccount::clear_has_sAccountName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_MsgAddressFieldItem::T_MsgAddressFieldItem ()  :
    _e8AddressFieldType (::most_Msg_fi_types::T_e8_MsgAddressFieldType__e8ADDRESS_FIELD_FROM),
    _sFirstName (),
    _sLastName (),
    _sEmailAddress (),
    _sPhoneNumber ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_MsgAddressFieldItem::T_MsgAddressFieldItem (const T_MsgAddressFieldItem &rhs)  :
    _e8AddressFieldType (::most_Msg_fi_types::T_e8_MsgAddressFieldType__e8ADDRESS_FIELD_FROM),
    _sFirstName (),
    _sLastName (),
    _sEmailAddress (),
    _sPhoneNumber ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_MsgAddressFieldItem::T_MsgAddressFieldItem (T_e8_MsgAddressFieldType e8AddressFieldType_, const ::fi_basetypes_most::T_String& sFirstName_, const ::fi_basetypes_most::T_String& sLastName_, const ::fi_basetypes_most::T_String& sEmailAddress_, const ::fi_basetypes_most::T_String& sPhoneNumber_)  :
    _e8AddressFieldType (e8AddressFieldType_),
    _sFirstName (sFirstName_),
    _sLastName (sLastName_),
    _sEmailAddress (sEmailAddress_),
    _sPhoneNumber (sPhoneNumber_)
{
    #ifndef NDEBUG
    if (!(T_e8_MsgAddressFieldType_IsValid(e8AddressFieldType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8AddressFieldType_, "T_e8_MsgAddressFieldType", "e8AddressFieldType", "T_MsgAddressFieldItem");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sFirstName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sLastName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sEmailAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sPhoneNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_MsgAddressFieldItem::~T_MsgAddressFieldItem() {
}

inline T_MsgAddressFieldItem& T_MsgAddressFieldItem::operator = (const T_MsgAddressFieldItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE8AddressFieldType()) {
            setE8AddressFieldType(rhs.getE8AddressFieldType());
        } else {
            clearE8AddressFieldType();
        }
        if (rhs.hasSFirstName()) {
            setSFirstName(rhs.getSFirstName());
        } else {
            clearSFirstName();
        }
        if (rhs.hasSLastName()) {
            setSLastName(rhs.getSLastName());
        } else {
            clearSLastName();
        }
        if (rhs.hasSEmailAddress()) {
            setSEmailAddress(rhs.getSEmailAddress());
        } else {
            clearSEmailAddress();
        }
        if (rhs.hasSPhoneNumber()) {
            setSPhoneNumber(rhs.getSPhoneNumber());
        } else {
            clearSPhoneNumber();
        }
    }
    return *this;
}

inline bool T_MsgAddressFieldItem::operator == (const T_MsgAddressFieldItem& rhs) const {
    return (((!hasE8AddressFieldType() && !rhs.hasE8AddressFieldType()) || getE8AddressFieldType() == rhs.getE8AddressFieldType()) &&
        ((!hasSFirstName() && !rhs.hasSFirstName()) || getSFirstName() == rhs.getSFirstName()) &&
        ((!hasSLastName() && !rhs.hasSLastName()) || getSLastName() == rhs.getSLastName()) &&
        ((!hasSEmailAddress() && !rhs.hasSEmailAddress()) || getSEmailAddress() == rhs.getSEmailAddress()) &&
        ((!hasSPhoneNumber() && !rhs.hasSPhoneNumber()) || getSPhoneNumber() == rhs.getSPhoneNumber()));
}

inline bool T_MsgAddressFieldItem::operator != (const T_MsgAddressFieldItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_MsgAddressFieldItem::operator < (const T_MsgAddressFieldItem& rhs) const {
    if (hasE8AddressFieldType() || rhs.hasE8AddressFieldType()) {
        if ((uint32)getE8AddressFieldType() < (uint32)rhs.getE8AddressFieldType()) return true;
        if ((uint32)getE8AddressFieldType() > (uint32)rhs.getE8AddressFieldType()) return false;
    }
    if (hasSFirstName() || rhs.hasSFirstName()) {
        if (getSFirstName() < rhs.getSFirstName()) return true;
        if (getSFirstName() > rhs.getSFirstName()) return false;
    }
    if (hasSLastName() || rhs.hasSLastName()) {
        if (getSLastName() < rhs.getSLastName()) return true;
        if (getSLastName() > rhs.getSLastName()) return false;
    }
    if (hasSEmailAddress() || rhs.hasSEmailAddress()) {
        if (getSEmailAddress() < rhs.getSEmailAddress()) return true;
        if (getSEmailAddress() > rhs.getSEmailAddress()) return false;
    }
    if (hasSPhoneNumber() || rhs.hasSPhoneNumber()) {
        if (getSPhoneNumber() < rhs.getSPhoneNumber()) return true;
        if (getSPhoneNumber() > rhs.getSPhoneNumber()) return false;
    }
    return false;
}

inline bool T_MsgAddressFieldItem::operator > (const T_MsgAddressFieldItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_MsgAddressFieldItem::clear() {
    clearE8AddressFieldType();
    clearSFirstName();
    clearSLastName();
    clearSEmailAddress();
    clearSPhoneNumber();
}

inline void T_MsgAddressFieldItem::clearE8AddressFieldType() {
    if (hasE8AddressFieldType()) {
         clear_has_e8AddressFieldType();
        _e8AddressFieldType = ::most_Msg_fi_types::T_e8_MsgAddressFieldType__e8ADDRESS_FIELD_FROM;
     }
}

inline bool T_MsgAddressFieldItem::hasE8AddressFieldType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_MsgAddressFieldType T_MsgAddressFieldItem::getE8AddressFieldType () const {
    return _e8AddressFieldType;
}

inline void T_MsgAddressFieldItem::setE8AddressFieldType (T_e8_MsgAddressFieldType e8AddressFieldType_) {
    #ifndef NDEBUG
    if (!(T_e8_MsgAddressFieldType_IsValid(e8AddressFieldType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8AddressFieldType_, "T_e8_MsgAddressFieldType", "e8AddressFieldType", "T_MsgAddressFieldItem");
    }
    #endif
    set_has_e8AddressFieldType();
    this->_e8AddressFieldType = e8AddressFieldType_;
}

inline void T_MsgAddressFieldItem::clearSFirstName() {
    if (hasSFirstName()) {
         clear_has_sFirstName();
        _sFirstName.clear();
     }
}

inline bool T_MsgAddressFieldItem::hasSFirstName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_MsgAddressFieldItem::getSFirstName () const {
    return _sFirstName;
}

inline ::fi_basetypes_most::T_String& T_MsgAddressFieldItem::getSFirstNameMutable () {
    set_has_sFirstName();
    return _sFirstName;
}

inline void T_MsgAddressFieldItem::setSFirstName (const ::fi_basetypes_most::T_String& sFirstName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sFirstName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sFirstName();
    this->_sFirstName = sFirstName_;
}

inline void T_MsgAddressFieldItem::clearSLastName() {
    if (hasSLastName()) {
         clear_has_sLastName();
        _sLastName.clear();
     }
}

inline bool T_MsgAddressFieldItem::hasSLastName () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_MsgAddressFieldItem::getSLastName () const {
    return _sLastName;
}

inline ::fi_basetypes_most::T_String& T_MsgAddressFieldItem::getSLastNameMutable () {
    set_has_sLastName();
    return _sLastName;
}

inline void T_MsgAddressFieldItem::setSLastName (const ::fi_basetypes_most::T_String& sLastName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sLastName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sLastName();
    this->_sLastName = sLastName_;
}

inline void T_MsgAddressFieldItem::clearSEmailAddress() {
    if (hasSEmailAddress()) {
         clear_has_sEmailAddress();
        _sEmailAddress.clear();
     }
}

inline bool T_MsgAddressFieldItem::hasSEmailAddress () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_MsgAddressFieldItem::getSEmailAddress () const {
    return _sEmailAddress;
}

inline ::fi_basetypes_most::T_String& T_MsgAddressFieldItem::getSEmailAddressMutable () {
    set_has_sEmailAddress();
    return _sEmailAddress;
}

inline void T_MsgAddressFieldItem::setSEmailAddress (const ::fi_basetypes_most::T_String& sEmailAddress_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sEmailAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sEmailAddress();
    this->_sEmailAddress = sEmailAddress_;
}

inline void T_MsgAddressFieldItem::clearSPhoneNumber() {
    if (hasSPhoneNumber()) {
         clear_has_sPhoneNumber();
        _sPhoneNumber.clear();
     }
}

inline bool T_MsgAddressFieldItem::hasSPhoneNumber () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_MsgAddressFieldItem::getSPhoneNumber () const {
    return _sPhoneNumber;
}

inline ::fi_basetypes_most::T_String& T_MsgAddressFieldItem::getSPhoneNumberMutable () {
    set_has_sPhoneNumber();
    return _sPhoneNumber;
}

inline void T_MsgAddressFieldItem::setSPhoneNumber (const ::fi_basetypes_most::T_String& sPhoneNumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sPhoneNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sPhoneNumber();
    this->_sPhoneNumber = sPhoneNumber_;
}

inline void T_MsgAddressFieldItem::set_has_e8AddressFieldType () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_MsgAddressFieldItem::clear_has_e8AddressFieldType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_MsgAddressFieldItem::set_has_sFirstName () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_MsgAddressFieldItem::clear_has_sFirstName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_MsgAddressFieldItem::set_has_sLastName () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_MsgAddressFieldItem::clear_has_sLastName () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_MsgAddressFieldItem::set_has_sEmailAddress () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_MsgAddressFieldItem::clear_has_sEmailAddress () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_MsgAddressFieldItem::set_has_sPhoneNumber () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_MsgAddressFieldItem::clear_has_sPhoneNumber () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  T_MsgMessageDetailsResult::T_MsgMessageDetailsResult ()  :
    _oMessageDateTime (),
    _sSubject (),
    _sShortMessage (),
    _u8NumAttachments (0u),
    _u8NumBodyParts (0u),
    _oMsgBodyActionElementTags (),
    _oAddressField ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_MsgMessageDetailsResult::T_MsgMessageDetailsResult (const T_MsgMessageDetailsResult &rhs)  :
    _oMessageDateTime (),
    _sSubject (),
    _sShortMessage (),
    _u8NumAttachments (0u),
    _u8NumBodyParts (0u),
    _oMsgBodyActionElementTags (),
    _oAddressField ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_MsgMessageDetailsResult::T_MsgMessageDetailsResult (const T_MsgMessageDateTime& oMessageDateTime_, const ::fi_basetypes_most::T_String& sSubject_, const ::fi_basetypes_most::T_String& sShortMessage_, uint8 u8NumAttachments_, uint8 u8NumBodyParts_, const T_MsgMsgBodyActionElementTags& oMsgBodyActionElementTags_, const T_MsgAddressField& oAddressField_)  :
    _oMessageDateTime (oMessageDateTime_),
    _sSubject (sSubject_),
    _sShortMessage (sShortMessage_),
    _u8NumAttachments (u8NumAttachments_),
    _u8NumBodyParts (u8NumBodyParts_),
    _oMsgBodyActionElementTags (oMsgBodyActionElementTags_),
    _oAddressField (oAddressField_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sSubject_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sShortMessage_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_MsgMessageDetailsResult::~T_MsgMessageDetailsResult() {
}

inline T_MsgMessageDetailsResult& T_MsgMessageDetailsResult::operator = (const T_MsgMessageDetailsResult& rhs) {
    if( this != &rhs ) {
        if (rhs.hasOMessageDateTime()) {
            setOMessageDateTime(rhs.getOMessageDateTime());
        } else {
            clearOMessageDateTime();
        }
        if (rhs.hasSSubject()) {
            setSSubject(rhs.getSSubject());
        } else {
            clearSSubject();
        }
        if (rhs.hasSShortMessage()) {
            setSShortMessage(rhs.getSShortMessage());
        } else {
            clearSShortMessage();
        }
        if (rhs.hasU8NumAttachments()) {
            setU8NumAttachments(rhs.getU8NumAttachments());
        } else {
            clearU8NumAttachments();
        }
        if (rhs.hasU8NumBodyParts()) {
            setU8NumBodyParts(rhs.getU8NumBodyParts());
        } else {
            clearU8NumBodyParts();
        }
        if (rhs.hasOMsgBodyActionElementTags()) {
            setOMsgBodyActionElementTags(rhs.getOMsgBodyActionElementTags());
        } else {
            clearOMsgBodyActionElementTags();
        }
        if (rhs.hasOAddressField()) {
            setOAddressField(rhs.getOAddressField());
        } else {
            clearOAddressField();
        }
    }
    return *this;
}

inline bool T_MsgMessageDetailsResult::operator == (const T_MsgMessageDetailsResult& rhs) const {
    return (((!hasOMessageDateTime() && !rhs.hasOMessageDateTime()) || getOMessageDateTime() == rhs.getOMessageDateTime()) &&
        ((!hasSSubject() && !rhs.hasSSubject()) || getSSubject() == rhs.getSSubject()) &&
        ((!hasSShortMessage() && !rhs.hasSShortMessage()) || getSShortMessage() == rhs.getSShortMessage()) &&
        ((!hasU8NumAttachments() && !rhs.hasU8NumAttachments()) || getU8NumAttachments() == rhs.getU8NumAttachments()) &&
        ((!hasU8NumBodyParts() && !rhs.hasU8NumBodyParts()) || getU8NumBodyParts() == rhs.getU8NumBodyParts()) &&
        ((!hasOMsgBodyActionElementTags() && !rhs.hasOMsgBodyActionElementTags()) || getOMsgBodyActionElementTags() == rhs.getOMsgBodyActionElementTags()) &&
        ((!hasOAddressField() && !rhs.hasOAddressField()) || getOAddressField() == rhs.getOAddressField()));
}

inline bool T_MsgMessageDetailsResult::operator != (const T_MsgMessageDetailsResult& rhs) const {
    return ! (*this == rhs);
}

inline bool T_MsgMessageDetailsResult::operator < (const T_MsgMessageDetailsResult& rhs) const {
    if (hasOMessageDateTime() || rhs.hasOMessageDateTime()) {
        if (getOMessageDateTime() < rhs.getOMessageDateTime()) return true;
        if (getOMessageDateTime() > rhs.getOMessageDateTime()) return false;
    }
    if (hasSSubject() || rhs.hasSSubject()) {
        if (getSSubject() < rhs.getSSubject()) return true;
        if (getSSubject() > rhs.getSSubject()) return false;
    }
    if (hasSShortMessage() || rhs.hasSShortMessage()) {
        if (getSShortMessage() < rhs.getSShortMessage()) return true;
        if (getSShortMessage() > rhs.getSShortMessage()) return false;
    }
    if (hasU8NumAttachments() || rhs.hasU8NumAttachments()) {
        if (getU8NumAttachments() < rhs.getU8NumAttachments()) return true;
        if (getU8NumAttachments() > rhs.getU8NumAttachments()) return false;
    }
    if (hasU8NumBodyParts() || rhs.hasU8NumBodyParts()) {
        if (getU8NumBodyParts() < rhs.getU8NumBodyParts()) return true;
        if (getU8NumBodyParts() > rhs.getU8NumBodyParts()) return false;
    }
    if (hasOMsgBodyActionElementTags() || rhs.hasOMsgBodyActionElementTags()) {
        if (getOMsgBodyActionElementTags() < rhs.getOMsgBodyActionElementTags()) return true;
        if (getOMsgBodyActionElementTags() > rhs.getOMsgBodyActionElementTags()) return false;
    }
    if (hasOAddressField() || rhs.hasOAddressField()) {
        if (getOAddressField() < rhs.getOAddressField()) return true;
        if (getOAddressField() > rhs.getOAddressField()) return false;
    }
    return false;
}

inline bool T_MsgMessageDetailsResult::operator > (const T_MsgMessageDetailsResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_MsgMessageDetailsResult::clear() {
    clearOMessageDateTime();
    clearSSubject();
    clearSShortMessage();
    clearU8NumAttachments();
    clearU8NumBodyParts();
    clearOMsgBodyActionElementTags();
    clearOAddressField();
}

inline void T_MsgMessageDetailsResult::clearOMessageDateTime() {
    if (hasOMessageDateTime()) {
         clear_has_oMessageDateTime();
        _oMessageDateTime.clear();
     }
}

inline bool T_MsgMessageDetailsResult::hasOMessageDateTime () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const T_MsgMessageDateTime& T_MsgMessageDetailsResult::getOMessageDateTime () const {
    return _oMessageDateTime;
}

inline T_MsgMessageDateTime& T_MsgMessageDetailsResult::getOMessageDateTimeMutable () {
    set_has_oMessageDateTime();
    return _oMessageDateTime;
}

inline void T_MsgMessageDetailsResult::setOMessageDateTime (const T_MsgMessageDateTime& oMessageDateTime_) {
    set_has_oMessageDateTime();
    this->_oMessageDateTime = oMessageDateTime_;
}

inline void T_MsgMessageDetailsResult::clearSSubject() {
    if (hasSSubject()) {
         clear_has_sSubject();
        _sSubject.clear();
     }
}

inline bool T_MsgMessageDetailsResult::hasSSubject () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_MsgMessageDetailsResult::getSSubject () const {
    return _sSubject;
}

inline ::fi_basetypes_most::T_String& T_MsgMessageDetailsResult::getSSubjectMutable () {
    set_has_sSubject();
    return _sSubject;
}

inline void T_MsgMessageDetailsResult::setSSubject (const ::fi_basetypes_most::T_String& sSubject_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sSubject_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sSubject();
    this->_sSubject = sSubject_;
}

inline void T_MsgMessageDetailsResult::clearSShortMessage() {
    if (hasSShortMessage()) {
         clear_has_sShortMessage();
        _sShortMessage.clear();
     }
}

inline bool T_MsgMessageDetailsResult::hasSShortMessage () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_MsgMessageDetailsResult::getSShortMessage () const {
    return _sShortMessage;
}

inline ::fi_basetypes_most::T_String& T_MsgMessageDetailsResult::getSShortMessageMutable () {
    set_has_sShortMessage();
    return _sShortMessage;
}

inline void T_MsgMessageDetailsResult::setSShortMessage (const ::fi_basetypes_most::T_String& sShortMessage_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sShortMessage_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sShortMessage();
    this->_sShortMessage = sShortMessage_;
}

inline void T_MsgMessageDetailsResult::clearU8NumAttachments() {
    if (hasU8NumAttachments()) {
         clear_has_u8NumAttachments();
        _u8NumAttachments = 0u;
     }
}

inline bool T_MsgMessageDetailsResult::hasU8NumAttachments () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 T_MsgMessageDetailsResult::getU8NumAttachments () const {
    return _u8NumAttachments;
}

inline void T_MsgMessageDetailsResult::setU8NumAttachments (uint8 u8NumAttachments_) {
    set_has_u8NumAttachments();
    this->_u8NumAttachments = u8NumAttachments_;
}

inline void T_MsgMessageDetailsResult::clearU8NumBodyParts() {
    if (hasU8NumBodyParts()) {
         clear_has_u8NumBodyParts();
        _u8NumBodyParts = 0u;
     }
}

inline bool T_MsgMessageDetailsResult::hasU8NumBodyParts () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 T_MsgMessageDetailsResult::getU8NumBodyParts () const {
    return _u8NumBodyParts;
}

inline void T_MsgMessageDetailsResult::setU8NumBodyParts (uint8 u8NumBodyParts_) {
    set_has_u8NumBodyParts();
    this->_u8NumBodyParts = u8NumBodyParts_;
}

inline void T_MsgMessageDetailsResult::clearOMsgBodyActionElementTags() {
    if (hasOMsgBodyActionElementTags()) {
         clear_has_oMsgBodyActionElementTags();
        _oMsgBodyActionElementTags.clear();
     }
}

inline bool T_MsgMessageDetailsResult::hasOMsgBodyActionElementTags () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const T_MsgMsgBodyActionElementTags& T_MsgMessageDetailsResult::getOMsgBodyActionElementTags () const {
    return _oMsgBodyActionElementTags;
}

inline T_MsgMsgBodyActionElementTags& T_MsgMessageDetailsResult::getOMsgBodyActionElementTagsMutable () {
    set_has_oMsgBodyActionElementTags();
    return _oMsgBodyActionElementTags;
}

inline void T_MsgMessageDetailsResult::setOMsgBodyActionElementTags (const T_MsgMsgBodyActionElementTags& oMsgBodyActionElementTags_) {
    set_has_oMsgBodyActionElementTags();
    this->_oMsgBodyActionElementTags = oMsgBodyActionElementTags_;
}

inline void T_MsgMessageDetailsResult::clearOAddressField() {
    if (hasOAddressField()) {
         clear_has_oAddressField();
        _oAddressField.clear();
     }
}

inline bool T_MsgMessageDetailsResult::hasOAddressField () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline const T_MsgAddressField& T_MsgMessageDetailsResult::getOAddressField () const {
    return _oAddressField;
}

inline T_MsgAddressField& T_MsgMessageDetailsResult::getOAddressFieldMutable () {
    set_has_oAddressField();
    return _oAddressField;
}

inline void T_MsgMessageDetailsResult::setOAddressField (const T_MsgAddressField& oAddressField_) {
    set_has_oAddressField();
    this->_oAddressField = oAddressField_;
}

inline void T_MsgMessageDetailsResult::set_has_oMessageDateTime () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_MsgMessageDetailsResult::clear_has_oMessageDateTime () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_MsgMessageDetailsResult::set_has_sSubject () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_MsgMessageDetailsResult::clear_has_sSubject () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_MsgMessageDetailsResult::set_has_sShortMessage () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_MsgMessageDetailsResult::clear_has_sShortMessage () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_MsgMessageDetailsResult::set_has_u8NumAttachments () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_MsgMessageDetailsResult::clear_has_u8NumAttachments () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_MsgMessageDetailsResult::set_has_u8NumBodyParts () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_MsgMessageDetailsResult::clear_has_u8NumBodyParts () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_MsgMessageDetailsResult::set_has_oMsgBodyActionElementTags () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_MsgMessageDetailsResult::clear_has_oMsgBodyActionElementTags () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_MsgMessageDetailsResult::set_has_oAddressField () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_MsgMessageDetailsResult::clear_has_oAddressField () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline  T_MsgAttachmentListItem::T_MsgAttachmentListItem ()  :
    _u16AttachmentHandle (0u),
    _e8AttachmentType (::most_Msg_fi_types::T_e8_MsgAttachmentType__e8MSG_ATT_TYPE_UNSUPPORTED),
    _sFilename ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_MsgAttachmentListItem::T_MsgAttachmentListItem (const T_MsgAttachmentListItem &rhs)  :
    _u16AttachmentHandle (0u),
    _e8AttachmentType (::most_Msg_fi_types::T_e8_MsgAttachmentType__e8MSG_ATT_TYPE_UNSUPPORTED),
    _sFilename ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_MsgAttachmentListItem::T_MsgAttachmentListItem (uint16 u16AttachmentHandle_, T_e8_MsgAttachmentType e8AttachmentType_, const ::fi_basetypes_most::T_String& sFilename_)  :
    _u16AttachmentHandle (u16AttachmentHandle_),
    _e8AttachmentType (e8AttachmentType_),
    _sFilename (sFilename_)
{
    #ifndef NDEBUG
    if (!(T_e8_MsgAttachmentType_IsValid(e8AttachmentType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8AttachmentType_, "T_e8_MsgAttachmentType", "e8AttachmentType", "T_MsgAttachmentListItem");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sFilename_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_MsgAttachmentListItem::~T_MsgAttachmentListItem() {
}

inline T_MsgAttachmentListItem& T_MsgAttachmentListItem::operator = (const T_MsgAttachmentListItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU16AttachmentHandle()) {
            setU16AttachmentHandle(rhs.getU16AttachmentHandle());
        } else {
            clearU16AttachmentHandle();
        }
        if (rhs.hasE8AttachmentType()) {
            setE8AttachmentType(rhs.getE8AttachmentType());
        } else {
            clearE8AttachmentType();
        }
        if (rhs.hasSFilename()) {
            setSFilename(rhs.getSFilename());
        } else {
            clearSFilename();
        }
    }
    return *this;
}

inline bool T_MsgAttachmentListItem::operator == (const T_MsgAttachmentListItem& rhs) const {
    return (((!hasU16AttachmentHandle() && !rhs.hasU16AttachmentHandle()) || getU16AttachmentHandle() == rhs.getU16AttachmentHandle()) &&
        ((!hasE8AttachmentType() && !rhs.hasE8AttachmentType()) || getE8AttachmentType() == rhs.getE8AttachmentType()) &&
        ((!hasSFilename() && !rhs.hasSFilename()) || getSFilename() == rhs.getSFilename()));
}

inline bool T_MsgAttachmentListItem::operator != (const T_MsgAttachmentListItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_MsgAttachmentListItem::operator < (const T_MsgAttachmentListItem& rhs) const {
    if (hasU16AttachmentHandle() || rhs.hasU16AttachmentHandle()) {
        if (getU16AttachmentHandle() < rhs.getU16AttachmentHandle()) return true;
        if (getU16AttachmentHandle() > rhs.getU16AttachmentHandle()) return false;
    }
    if (hasE8AttachmentType() || rhs.hasE8AttachmentType()) {
        if ((uint32)getE8AttachmentType() < (uint32)rhs.getE8AttachmentType()) return true;
        if ((uint32)getE8AttachmentType() > (uint32)rhs.getE8AttachmentType()) return false;
    }
    if (hasSFilename() || rhs.hasSFilename()) {
        if (getSFilename() < rhs.getSFilename()) return true;
        if (getSFilename() > rhs.getSFilename()) return false;
    }
    return false;
}

inline bool T_MsgAttachmentListItem::operator > (const T_MsgAttachmentListItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_MsgAttachmentListItem::clear() {
    clearU16AttachmentHandle();
    clearE8AttachmentType();
    clearSFilename();
}

inline void T_MsgAttachmentListItem::clearU16AttachmentHandle() {
    if (hasU16AttachmentHandle()) {
         clear_has_u16AttachmentHandle();
        _u16AttachmentHandle = 0u;
     }
}

inline bool T_MsgAttachmentListItem::hasU16AttachmentHandle () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 T_MsgAttachmentListItem::getU16AttachmentHandle () const {
    return _u16AttachmentHandle;
}

inline void T_MsgAttachmentListItem::setU16AttachmentHandle (uint16 u16AttachmentHandle_) {
    set_has_u16AttachmentHandle();
    this->_u16AttachmentHandle = u16AttachmentHandle_;
}

inline void T_MsgAttachmentListItem::clearE8AttachmentType() {
    if (hasE8AttachmentType()) {
         clear_has_e8AttachmentType();
        _e8AttachmentType = ::most_Msg_fi_types::T_e8_MsgAttachmentType__e8MSG_ATT_TYPE_UNSUPPORTED;
     }
}

inline bool T_MsgAttachmentListItem::hasE8AttachmentType () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_MsgAttachmentType T_MsgAttachmentListItem::getE8AttachmentType () const {
    return _e8AttachmentType;
}

inline void T_MsgAttachmentListItem::setE8AttachmentType (T_e8_MsgAttachmentType e8AttachmentType_) {
    #ifndef NDEBUG
    if (!(T_e8_MsgAttachmentType_IsValid(e8AttachmentType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8AttachmentType_, "T_e8_MsgAttachmentType", "e8AttachmentType", "T_MsgAttachmentListItem");
    }
    #endif
    set_has_e8AttachmentType();
    this->_e8AttachmentType = e8AttachmentType_;
}

inline void T_MsgAttachmentListItem::clearSFilename() {
    if (hasSFilename()) {
         clear_has_sFilename();
        _sFilename.clear();
     }
}

inline bool T_MsgAttachmentListItem::hasSFilename () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_MsgAttachmentListItem::getSFilename () const {
    return _sFilename;
}

inline ::fi_basetypes_most::T_String& T_MsgAttachmentListItem::getSFilenameMutable () {
    set_has_sFilename();
    return _sFilename;
}

inline void T_MsgAttachmentListItem::setSFilename (const ::fi_basetypes_most::T_String& sFilename_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sFilename_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sFilename();
    this->_sFilename = sFilename_;
}

inline void T_MsgAttachmentListItem::set_has_u16AttachmentHandle () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_MsgAttachmentListItem::clear_has_u16AttachmentHandle () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_MsgAttachmentListItem::set_has_e8AttachmentType () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_MsgAttachmentListItem::clear_has_e8AttachmentType () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_MsgAttachmentListItem::set_has_sFilename () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_MsgAttachmentListItem::clear_has_sFilename () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_MsgBodyPartListItem::T_MsgBodyPartListItem ()  :
    _sBodyTitle (),
    _sBodyText ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_MsgBodyPartListItem::T_MsgBodyPartListItem (const T_MsgBodyPartListItem &rhs)  :
    _sBodyTitle (),
    _sBodyText ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_MsgBodyPartListItem::T_MsgBodyPartListItem (const ::fi_basetypes_most::T_String& sBodyTitle_, const ::fi_basetypes_most::T_String& sBodyText_)  :
    _sBodyTitle (sBodyTitle_),
    _sBodyText (sBodyText_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sBodyTitle_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sBodyText_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_MsgBodyPartListItem::~T_MsgBodyPartListItem() {
}

inline T_MsgBodyPartListItem& T_MsgBodyPartListItem::operator = (const T_MsgBodyPartListItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSBodyTitle()) {
            setSBodyTitle(rhs.getSBodyTitle());
        } else {
            clearSBodyTitle();
        }
        if (rhs.hasSBodyText()) {
            setSBodyText(rhs.getSBodyText());
        } else {
            clearSBodyText();
        }
    }
    return *this;
}

inline bool T_MsgBodyPartListItem::operator == (const T_MsgBodyPartListItem& rhs) const {
    return (((!hasSBodyTitle() && !rhs.hasSBodyTitle()) || getSBodyTitle() == rhs.getSBodyTitle()) &&
        ((!hasSBodyText() && !rhs.hasSBodyText()) || getSBodyText() == rhs.getSBodyText()));
}

inline bool T_MsgBodyPartListItem::operator != (const T_MsgBodyPartListItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_MsgBodyPartListItem::operator < (const T_MsgBodyPartListItem& rhs) const {
    if (hasSBodyTitle() || rhs.hasSBodyTitle()) {
        if (getSBodyTitle() < rhs.getSBodyTitle()) return true;
        if (getSBodyTitle() > rhs.getSBodyTitle()) return false;
    }
    if (hasSBodyText() || rhs.hasSBodyText()) {
        if (getSBodyText() < rhs.getSBodyText()) return true;
        if (getSBodyText() > rhs.getSBodyText()) return false;
    }
    return false;
}

inline bool T_MsgBodyPartListItem::operator > (const T_MsgBodyPartListItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_MsgBodyPartListItem::clear() {
    clearSBodyTitle();
    clearSBodyText();
}

inline void T_MsgBodyPartListItem::clearSBodyTitle() {
    if (hasSBodyTitle()) {
         clear_has_sBodyTitle();
        _sBodyTitle.clear();
     }
}

inline bool T_MsgBodyPartListItem::hasSBodyTitle () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_MsgBodyPartListItem::getSBodyTitle () const {
    return _sBodyTitle;
}

inline ::fi_basetypes_most::T_String& T_MsgBodyPartListItem::getSBodyTitleMutable () {
    set_has_sBodyTitle();
    return _sBodyTitle;
}

inline void T_MsgBodyPartListItem::setSBodyTitle (const ::fi_basetypes_most::T_String& sBodyTitle_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sBodyTitle_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sBodyTitle();
    this->_sBodyTitle = sBodyTitle_;
}

inline void T_MsgBodyPartListItem::clearSBodyText() {
    if (hasSBodyText()) {
         clear_has_sBodyText();
        _sBodyText.clear();
     }
}

inline bool T_MsgBodyPartListItem::hasSBodyText () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_MsgBodyPartListItem::getSBodyText () const {
    return _sBodyText;
}

inline ::fi_basetypes_most::T_String& T_MsgBodyPartListItem::getSBodyTextMutable () {
    set_has_sBodyText();
    return _sBodyText;
}

inline void T_MsgBodyPartListItem::setSBodyText (const ::fi_basetypes_most::T_String& sBodyText_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sBodyText_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sBodyText();
    this->_sBodyText = sBodyText_;
}

inline void T_MsgBodyPartListItem::set_has_sBodyTitle () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_MsgBodyPartListItem::clear_has_sBodyTitle () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_MsgBodyPartListItem::set_has_sBodyText () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_MsgBodyPartListItem::clear_has_sBodyText () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_MsgPredefinedMessageListResultItem::T_MsgPredefinedMessageListResultItem ()  :
    _u16PredefinedMessageHandle (0u),
    _e8PredefinedMessageType (::most_Msg_fi_types::T_e8_MsgPredefinedMessageType__e8PRE_MSG_STATIC),
    _sPredefinedMessageText ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_MsgPredefinedMessageListResultItem::T_MsgPredefinedMessageListResultItem (const T_MsgPredefinedMessageListResultItem &rhs)  :
    _u16PredefinedMessageHandle (0u),
    _e8PredefinedMessageType (::most_Msg_fi_types::T_e8_MsgPredefinedMessageType__e8PRE_MSG_STATIC),
    _sPredefinedMessageText ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_MsgPredefinedMessageListResultItem::T_MsgPredefinedMessageListResultItem (uint16 u16PredefinedMessageHandle_, T_e8_MsgPredefinedMessageType e8PredefinedMessageType_, const ::fi_basetypes_most::T_String& sPredefinedMessageText_)  :
    _u16PredefinedMessageHandle (u16PredefinedMessageHandle_),
    _e8PredefinedMessageType (e8PredefinedMessageType_),
    _sPredefinedMessageText (sPredefinedMessageText_)
{
    #ifndef NDEBUG
    if (!(T_e8_MsgPredefinedMessageType_IsValid(e8PredefinedMessageType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8PredefinedMessageType_, "T_e8_MsgPredefinedMessageType", "e8PredefinedMessageType", "T_MsgPredefinedMessageListResultItem");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sPredefinedMessageText_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_MsgPredefinedMessageListResultItem::~T_MsgPredefinedMessageListResultItem() {
}

inline T_MsgPredefinedMessageListResultItem& T_MsgPredefinedMessageListResultItem::operator = (const T_MsgPredefinedMessageListResultItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU16PredefinedMessageHandle()) {
            setU16PredefinedMessageHandle(rhs.getU16PredefinedMessageHandle());
        } else {
            clearU16PredefinedMessageHandle();
        }
        if (rhs.hasE8PredefinedMessageType()) {
            setE8PredefinedMessageType(rhs.getE8PredefinedMessageType());
        } else {
            clearE8PredefinedMessageType();
        }
        if (rhs.hasSPredefinedMessageText()) {
            setSPredefinedMessageText(rhs.getSPredefinedMessageText());
        } else {
            clearSPredefinedMessageText();
        }
    }
    return *this;
}

inline bool T_MsgPredefinedMessageListResultItem::operator == (const T_MsgPredefinedMessageListResultItem& rhs) const {
    return (((!hasU16PredefinedMessageHandle() && !rhs.hasU16PredefinedMessageHandle()) || getU16PredefinedMessageHandle() == rhs.getU16PredefinedMessageHandle()) &&
        ((!hasE8PredefinedMessageType() && !rhs.hasE8PredefinedMessageType()) || getE8PredefinedMessageType() == rhs.getE8PredefinedMessageType()) &&
        ((!hasSPredefinedMessageText() && !rhs.hasSPredefinedMessageText()) || getSPredefinedMessageText() == rhs.getSPredefinedMessageText()));
}

inline bool T_MsgPredefinedMessageListResultItem::operator != (const T_MsgPredefinedMessageListResultItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_MsgPredefinedMessageListResultItem::operator < (const T_MsgPredefinedMessageListResultItem& rhs) const {
    if (hasU16PredefinedMessageHandle() || rhs.hasU16PredefinedMessageHandle()) {
        if (getU16PredefinedMessageHandle() < rhs.getU16PredefinedMessageHandle()) return true;
        if (getU16PredefinedMessageHandle() > rhs.getU16PredefinedMessageHandle()) return false;
    }
    if (hasE8PredefinedMessageType() || rhs.hasE8PredefinedMessageType()) {
        if ((uint32)getE8PredefinedMessageType() < (uint32)rhs.getE8PredefinedMessageType()) return true;
        if ((uint32)getE8PredefinedMessageType() > (uint32)rhs.getE8PredefinedMessageType()) return false;
    }
    if (hasSPredefinedMessageText() || rhs.hasSPredefinedMessageText()) {
        if (getSPredefinedMessageText() < rhs.getSPredefinedMessageText()) return true;
        if (getSPredefinedMessageText() > rhs.getSPredefinedMessageText()) return false;
    }
    return false;
}

inline bool T_MsgPredefinedMessageListResultItem::operator > (const T_MsgPredefinedMessageListResultItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_MsgPredefinedMessageListResultItem::clear() {
    clearU16PredefinedMessageHandle();
    clearE8PredefinedMessageType();
    clearSPredefinedMessageText();
}

inline void T_MsgPredefinedMessageListResultItem::clearU16PredefinedMessageHandle() {
    if (hasU16PredefinedMessageHandle()) {
         clear_has_u16PredefinedMessageHandle();
        _u16PredefinedMessageHandle = 0u;
     }
}

inline bool T_MsgPredefinedMessageListResultItem::hasU16PredefinedMessageHandle () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 T_MsgPredefinedMessageListResultItem::getU16PredefinedMessageHandle () const {
    return _u16PredefinedMessageHandle;
}

inline void T_MsgPredefinedMessageListResultItem::setU16PredefinedMessageHandle (uint16 u16PredefinedMessageHandle_) {
    set_has_u16PredefinedMessageHandle();
    this->_u16PredefinedMessageHandle = u16PredefinedMessageHandle_;
}

inline void T_MsgPredefinedMessageListResultItem::clearE8PredefinedMessageType() {
    if (hasE8PredefinedMessageType()) {
         clear_has_e8PredefinedMessageType();
        _e8PredefinedMessageType = ::most_Msg_fi_types::T_e8_MsgPredefinedMessageType__e8PRE_MSG_STATIC;
     }
}

inline bool T_MsgPredefinedMessageListResultItem::hasE8PredefinedMessageType () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_MsgPredefinedMessageType T_MsgPredefinedMessageListResultItem::getE8PredefinedMessageType () const {
    return _e8PredefinedMessageType;
}

inline void T_MsgPredefinedMessageListResultItem::setE8PredefinedMessageType (T_e8_MsgPredefinedMessageType e8PredefinedMessageType_) {
    #ifndef NDEBUG
    if (!(T_e8_MsgPredefinedMessageType_IsValid(e8PredefinedMessageType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8PredefinedMessageType_, "T_e8_MsgPredefinedMessageType", "e8PredefinedMessageType", "T_MsgPredefinedMessageListResultItem");
    }
    #endif
    set_has_e8PredefinedMessageType();
    this->_e8PredefinedMessageType = e8PredefinedMessageType_;
}

inline void T_MsgPredefinedMessageListResultItem::clearSPredefinedMessageText() {
    if (hasSPredefinedMessageText()) {
         clear_has_sPredefinedMessageText();
        _sPredefinedMessageText.clear();
     }
}

inline bool T_MsgPredefinedMessageListResultItem::hasSPredefinedMessageText () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_MsgPredefinedMessageListResultItem::getSPredefinedMessageText () const {
    return _sPredefinedMessageText;
}

inline ::fi_basetypes_most::T_String& T_MsgPredefinedMessageListResultItem::getSPredefinedMessageTextMutable () {
    set_has_sPredefinedMessageText();
    return _sPredefinedMessageText;
}

inline void T_MsgPredefinedMessageListResultItem::setSPredefinedMessageText (const ::fi_basetypes_most::T_String& sPredefinedMessageText_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sPredefinedMessageText_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sPredefinedMessageText();
    this->_sPredefinedMessageText = sPredefinedMessageText_;
}

inline void T_MsgPredefinedMessageListResultItem::set_has_u16PredefinedMessageHandle () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_MsgPredefinedMessageListResultItem::clear_has_u16PredefinedMessageHandle () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_MsgPredefinedMessageListResultItem::set_has_e8PredefinedMessageType () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_MsgPredefinedMessageListResultItem::clear_has_e8PredefinedMessageType () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_MsgPredefinedMessageListResultItem::set_has_sPredefinedMessageText () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_MsgPredefinedMessageListResultItem::clear_has_sPredefinedMessageText () {
    _has_bits_[0] &= ~ (1u << 2);
}

} // namespace most_Msg_fi_types

#endif // MOST_MSG_FI_TYPES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
