#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef MOST_BTSET_FI_TYPES_EXTENDED_H
#define MOST_BTSET_FI_TYPES_EXTENDED_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "fi_basetypes_most.h"
#include "most_BTSet_fi_types.h"
#include "most_BTSet_fi_typesConst.h"
#include "most_BTSet_fi_types_ExtendedConst.h"
#include <cstring>
#include <vector>

/**
 * Types most_BTSet_fi_types_Extended
 */

namespace most_BTSet_fi_types_Extended {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class T_BTSetSupportedProfiles;

class T_BTSetDeviceIdentification;

class T_BTServiceType;

class T_BTProfileConnectionStatus;

class T_BTProfileDisconnectedReason;

class T_BTProfileFavoriteIndex;

class T_BTSetDeviceListExtendedResultItem;

class T_BTSPPServiceConnectionStatusListItem;

class T_BTSetVisibleDeviceItem;

class T_BTSetSignalStrengthItem;

class T_BTSetDeviceListChangeExtended;

class T_BTLimitationModeListItem;

class T_BTLimitationMode;

class T_BTProfilesUsageInfo;

class T_BTProfilesUsageInfoList;

class T_BTConflictInfo;

// type definitions
/**
 * If the meaning of "T_BTSetDeviceListExtendedResult" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_BTSetDeviceListExtendedResultItem > T_BTSetDeviceListExtendedResult;

/**
 * If the meaning of "T_BTSPPServiceConnectionStatusList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_BTSPPServiceConnectionStatusListItem > T_BTSPPServiceConnectionStatusList;

/**
 * If the meaning of "T_BTSetVisibleDevicesList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_BTSetVisibleDeviceItem > T_BTSetVisibleDevicesList;

/**
 * If the meaning of "T_BTSetSignalStrengthList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_BTSetSignalStrengthItem > T_BTSetSignalStrengthList;

/**
 * If the meaning of "T_BTLimitationModeList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_BTLimitationModeListItem > T_BTLimitationModeList;

/**
 * If the meaning of "T_BTProfilesUsageList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_BTProfilesUsageInfoList > T_BTProfilesUsageList;

/**
 * If the meaning of "T_BTConflictInfoList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_BTConflictInfo > T_BTConflictInfoList;


class T_BTSetSupportedProfiles {
public:

    /**
     * Default constructor
     */
    inline  T_BTSetSupportedProfiles ();

    /**
     * Copy constructor
     */
    inline  T_BTSetSupportedProfiles (const T_BTSetSupportedProfiles &rhs);

    /**
     * All fields constructor
     */
    inline  T_BTSetSupportedProfiles (bool bSPPSupport_, bool bHFPSupport_, bool bA2DPSupport_, bool bAVRCPSupport_, bool bMAPSupport_, bool bDUNSupport_, bool bPANSupport_, bool bPBAPSuport_, bool bOPPSupport_, bool bDIPSupport_);

    /**
     * Destructor
     */
    inline  ~T_BTSetSupportedProfiles();

    /**
     * Assignment operator
     */
    inline T_BTSetSupportedProfiles& operator = (const T_BTSetSupportedProfiles& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_BTSetSupportedProfiles& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_BTSetSupportedProfiles& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_BTSetSupportedProfiles& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_BTSetSupportedProfiles& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bSPPSupport"

    static const int kBSPPSupport = 0;

    /**
     * Clears the field "bSPPSupport".
     *
     * The field will be set to its default value. The hasBSPPSupport()
     * method will return false.
     */
    inline void clearBSPPSupport();

    /**
     * Checks whether the field "bSPPSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBSPPSupport()). Otherwise it will return false.
     */
    inline bool hasBSPPSupport () const;

    /**
     * Returns the value of the member "bSPPSupport".
     *
     * Identifies if the device supports the Serial port profile feature.
     *
     * @return The value of the field "bSPPSupport"
     */
    inline bool getBSPPSupport () const;

    /**
     * Sets the value of the member "bSPPSupport".
     *
     * Identifies if the device supports the Serial port profile feature.
     *
     * @param bSPPSupport The value which will be set
     */
    inline void setBSPPSupport (bool bSPPSupport_);

    // API of field "bHFPSupport"

    static const int kBHFPSupport = 1;

    /**
     * Clears the field "bHFPSupport".
     *
     * The field will be set to its default value. The hasBHFPSupport()
     * method will return false.
     */
    inline void clearBHFPSupport();

    /**
     * Checks whether the field "bHFPSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBHFPSupport()). Otherwise it will return false.
     */
    inline bool hasBHFPSupport () const;

    /**
     * Returns the value of the member "bHFPSupport".
     *
     * Identifies if the device supports the Handsfree feature.
     *
     * @return The value of the field "bHFPSupport"
     */
    inline bool getBHFPSupport () const;

    /**
     * Sets the value of the member "bHFPSupport".
     *
     * Identifies if the device supports the Handsfree feature.
     *
     * @param bHFPSupport The value which will be set
     */
    inline void setBHFPSupport (bool bHFPSupport_);

    // API of field "bA2DPSupport"

    static const int kBA2DPSupport = 2;

    /**
     * Clears the field "bA2DPSupport".
     *
     * The field will be set to its default value. The hasBA2DPSupport()
     * method will return false.
     */
    inline void clearBA2DPSupport();

    /**
     * Checks whether the field "bA2DPSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBA2DPSupport()). Otherwise it will return false.
     */
    inline bool hasBA2DPSupport () const;

    /**
     * Returns the value of the member "bA2DPSupport".
     *
     * Identifies if the device supports the A2DP feature.
     *
     * @return The value of the field "bA2DPSupport"
     */
    inline bool getBA2DPSupport () const;

    /**
     * Sets the value of the member "bA2DPSupport".
     *
     * Identifies if the device supports the A2DP feature.
     *
     * @param bA2DPSupport The value which will be set
     */
    inline void setBA2DPSupport (bool bA2DPSupport_);

    // API of field "bAVRCPSupport"

    static const int kBAVRCPSupport = 3;

    /**
     * Clears the field "bAVRCPSupport".
     *
     * The field will be set to its default value. The hasBAVRCPSupport()
     * method will return false.
     */
    inline void clearBAVRCPSupport();

    /**
     * Checks whether the field "bAVRCPSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBAVRCPSupport()). Otherwise it will return false.
     */
    inline bool hasBAVRCPSupport () const;

    /**
     * Returns the value of the member "bAVRCPSupport".
     *
     * Identifies if the device supports the AVRCP feature.
     *
     * @return The value of the field "bAVRCPSupport"
     */
    inline bool getBAVRCPSupport () const;

    /**
     * Sets the value of the member "bAVRCPSupport".
     *
     * Identifies if the device supports the AVRCP feature.
     *
     * @param bAVRCPSupport The value which will be set
     */
    inline void setBAVRCPSupport (bool bAVRCPSupport_);

    // API of field "bMAPSupport"

    static const int kBMAPSupport = 4;

    /**
     * Clears the field "bMAPSupport".
     *
     * The field will be set to its default value. The hasBMAPSupport()
     * method will return false.
     */
    inline void clearBMAPSupport();

    /**
     * Checks whether the field "bMAPSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBMAPSupport()). Otherwise it will return false.
     */
    inline bool hasBMAPSupport () const;

    /**
     * Returns the value of the member "bMAPSupport".
     *
     * Identifies if the device supports the Messaging feature.
     *
     * @return The value of the field "bMAPSupport"
     */
    inline bool getBMAPSupport () const;

    /**
     * Sets the value of the member "bMAPSupport".
     *
     * Identifies if the device supports the Messaging feature.
     *
     * @param bMAPSupport The value which will be set
     */
    inline void setBMAPSupport (bool bMAPSupport_);

    // API of field "bDUNSupport"

    static const int kBDUNSupport = 5;

    /**
     * Clears the field "bDUNSupport".
     *
     * The field will be set to its default value. The hasBDUNSupport()
     * method will return false.
     */
    inline void clearBDUNSupport();

    /**
     * Checks whether the field "bDUNSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDUNSupport()). Otherwise it will return false.
     */
    inline bool hasBDUNSupport () const;

    /**
     * Returns the value of the member "bDUNSupport".
     *
     * Identifies if the device supports the Dial Up Network profile feature
     *
     * @return The value of the field "bDUNSupport"
     */
    inline bool getBDUNSupport () const;

    /**
     * Sets the value of the member "bDUNSupport".
     *
     * Identifies if the device supports the Dial Up Network profile feature
     *
     * @param bDUNSupport The value which will be set
     */
    inline void setBDUNSupport (bool bDUNSupport_);

    // API of field "bPANSupport"

    static const int kBPANSupport = 6;

    /**
     * Clears the field "bPANSupport".
     *
     * The field will be set to its default value. The hasBPANSupport()
     * method will return false.
     */
    inline void clearBPANSupport();

    /**
     * Checks whether the field "bPANSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBPANSupport()). Otherwise it will return false.
     */
    inline bool hasBPANSupport () const;

    /**
     * Returns the value of the member "bPANSupport".
     *
     * Identifies if the device supports the Personal Area Network profile feature.
     *
     * @return The value of the field "bPANSupport"
     */
    inline bool getBPANSupport () const;

    /**
     * Sets the value of the member "bPANSupport".
     *
     * Identifies if the device supports the Personal Area Network profile feature.
     *
     * @param bPANSupport The value which will be set
     */
    inline void setBPANSupport (bool bPANSupport_);

    // API of field "bPBAPSuport"

    static const int kBPBAPSuport = 7;

    /**
     * Clears the field "bPBAPSuport".
     *
     * The field will be set to its default value. The hasBPBAPSuport()
     * method will return false.
     */
    inline void clearBPBAPSuport();

    /**
     * Checks whether the field "bPBAPSuport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBPBAPSuport()). Otherwise it will return false.
     */
    inline bool hasBPBAPSuport () const;

    /**
     * Returns the value of the member "bPBAPSuport".
     *
     * Identifies if the device supports the Phonebook download feature.
     *
     * @return The value of the field "bPBAPSuport"
     */
    inline bool getBPBAPSuport () const;

    /**
     * Sets the value of the member "bPBAPSuport".
     *
     * Identifies if the device supports the Phonebook download feature.
     *
     * @param bPBAPSuport The value which will be set
     */
    inline void setBPBAPSuport (bool bPBAPSuport_);

    // API of field "bOPPSupport"

    static const int kBOPPSupport = 8;

    /**
     * Clears the field "bOPPSupport".
     *
     * The field will be set to its default value. The hasBOPPSupport()
     * method will return false.
     */
    inline void clearBOPPSupport();

    /**
     * Checks whether the field "bOPPSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBOPPSupport()). Otherwise it will return false.
     */
    inline bool hasBOPPSupport () const;

    /**
     * Returns the value of the member "bOPPSupport".
     *
     * Identifies if the device supports the OPP feature.
     *
     * @return The value of the field "bOPPSupport"
     */
    inline bool getBOPPSupport () const;

    /**
     * Sets the value of the member "bOPPSupport".
     *
     * Identifies if the device supports the OPP feature.
     *
     * @param bOPPSupport The value which will be set
     */
    inline void setBOPPSupport (bool bOPPSupport_);

    // API of field "bDIPSupport"

    static const int kBDIPSupport = 9;

    /**
     * Clears the field "bDIPSupport".
     *
     * The field will be set to its default value. The hasBDIPSupport()
     * method will return false.
     */
    inline void clearBDIPSupport();

    /**
     * Checks whether the field "bDIPSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDIPSupport()). Otherwise it will return false.
     */
    inline bool hasBDIPSupport () const;

    /**
     * Returns the value of the member "bDIPSupport".
     *
     * Identifies if the device supports the Device Identification profile feature.
     *
     * @return The value of the field "bDIPSupport"
     */
    inline bool getBDIPSupport () const;

    /**
     * Sets the value of the member "bDIPSupport".
     *
     * Identifies if the device supports the Device Identification profile feature.
     *
     * @param bDIPSupport The value which will be set
     */
    inline void setBDIPSupport (bool bDIPSupport_);

    static const T_BTSetSupportedProfiles &getDefaultInstance();

private:

    inline void set_has_bSPPSupport ();

    inline void clear_has_bSPPSupport ();

    inline void set_has_bHFPSupport ();

    inline void clear_has_bHFPSupport ();

    inline void set_has_bA2DPSupport ();

    inline void clear_has_bA2DPSupport ();

    inline void set_has_bAVRCPSupport ();

    inline void clear_has_bAVRCPSupport ();

    inline void set_has_bMAPSupport ();

    inline void clear_has_bMAPSupport ();

    inline void set_has_bDUNSupport ();

    inline void clear_has_bDUNSupport ();

    inline void set_has_bPANSupport ();

    inline void clear_has_bPANSupport ();

    inline void set_has_bPBAPSuport ();

    inline void clear_has_bPBAPSuport ();

    inline void set_has_bOPPSupport ();

    inline void clear_has_bOPPSupport ();

    inline void set_has_bDIPSupport ();

    inline void clear_has_bDIPSupport ();

    uint32 _has_bits_[ (10 + 31) / 32];

    bool _bSPPSupport;

    bool _bHFPSupport;

    bool _bA2DPSupport;

    bool _bAVRCPSupport;

    bool _bMAPSupport;

    bool _bDUNSupport;

    bool _bPANSupport;

    bool _bPBAPSuport;

    bool _bOPPSupport;

    bool _bDIPSupport;

};

/**
 * All the parameters are only valid, if the device supports Device Identification Profile (DIP), [see method GetDeviceInfoExtended::oSupportedProfiles: bDIPSupport]. All parameters should be set to 0x00 if device does not support DIP
 */
class T_BTSetDeviceIdentification {
public:

    /**
     * Default constructor
     */
    inline  T_BTSetDeviceIdentification ();

    /**
     * Copy constructor
     */
    inline  T_BTSetDeviceIdentification (const T_BTSetDeviceIdentification &rhs);

    /**
     * All fields constructor
     */
    inline  T_BTSetDeviceIdentification (uint16 u16VendorIDSource_, uint16 u16VendorID_, uint16 u16ProductID_, uint16 u16ProductVersion_);

    /**
     * Destructor
     */
    inline  ~T_BTSetDeviceIdentification();

    /**
     * Assignment operator
     */
    inline T_BTSetDeviceIdentification& operator = (const T_BTSetDeviceIdentification& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_BTSetDeviceIdentification& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_BTSetDeviceIdentification& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_BTSetDeviceIdentification& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_BTSetDeviceIdentification& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16VendorIDSource"

    static const int kU16VendorIDSource = 0;

    /**
     * Clears the field "u16VendorIDSource".
     *
     * The field will be set to its default value. The hasU16VendorIDSource()
     * method will return false.
     */
    inline void clearU16VendorIDSource();

    /**
     * Checks whether the field "u16VendorIDSource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16VendorIDSource()). Otherwise it will return false.
     */
    inline bool hasU16VendorIDSource () const;

    /**
     * Returns the value of the member "u16VendorIDSource".
     *
     * Describes the
     * Organization, which has defined the VendorID:
     * 0x0001 : 'u16VendorID' stems from Bluetooth SIG
     * 0x0002 : 'u16VendorID' stems USB Implementers Forum
     *
     * @return The value of the field "u16VendorIDSource"
     */
    inline uint16 getU16VendorIDSource () const;

    /**
     * Sets the value of the member "u16VendorIDSource".
     *
     * Describes the
     * Organization, which has defined the VendorID:
     * 0x0001 : 'u16VendorID' stems from Bluetooth SIG
     * 0x0002 : 'u16VendorID' stems USB Implementers Forum
     *
     * @param u16VendorIDSource The value which will be set
     */
    inline void setU16VendorIDSource (uint16 u16VendorIDSource_);

    // API of field "u16VendorID"

    static const int kU16VendorID = 1;

    /**
     * Clears the field "u16VendorID".
     *
     * The field will be set to its default value. The hasU16VendorID()
     * method will return false.
     */
    inline void clearU16VendorID();

    /**
     * Checks whether the field "u16VendorID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16VendorID()). Otherwise it will return false.
     */
    inline bool hasU16VendorID () const;

    /**
     * Returns the value of the member "u16VendorID".
     *
     * The Parameters 'u16VendorID' and 'u16VendorIDSource' describe in combination the unique "Vendor ID".
     * 'u16VendorID' represents the "Vendor ID" value.
     * 'u16VendorIDSource' describes the "table" in which 'u16VendorID' is defined uniquely (0x0001: Bluetooth SIG company, u16VendorIDSource = 0x0002: USB vendor).
     *
     * @return The value of the field "u16VendorID"
     */
    inline uint16 getU16VendorID () const;

    /**
     * Sets the value of the member "u16VendorID".
     *
     * The Parameters 'u16VendorID' and 'u16VendorIDSource' describe in combination the unique "Vendor ID".
     * 'u16VendorID' represents the "Vendor ID" value.
     * 'u16VendorIDSource' describes the "table" in which 'u16VendorID' is defined uniquely (0x0001: Bluetooth SIG company, u16VendorIDSource = 0x0002: USB vendor).
     *
     * @param u16VendorID The value which will be set
     */
    inline void setU16VendorID (uint16 u16VendorID_);

    // API of field "u16ProductID"

    static const int kU16ProductID = 2;

    /**
     * Clears the field "u16ProductID".
     *
     * The field will be set to its default value. The hasU16ProductID()
     * method will return false.
     */
    inline void clearU16ProductID();

    /**
     * Checks whether the field "u16ProductID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ProductID()). Otherwise it will return false.
     */
    inline bool hasU16ProductID () const;

    /**
     * Returns the value of the member "u16ProductID".
     *
     * Identifies Vendor's product ID.
     *
     * @return The value of the field "u16ProductID"
     */
    inline uint16 getU16ProductID () const;

    /**
     * Sets the value of the member "u16ProductID".
     *
     * Identifies Vendor's product ID.
     *
     * @param u16ProductID The value which will be set
     */
    inline void setU16ProductID (uint16 u16ProductID_);

    // API of field "u16ProductVersion"

    static const int kU16ProductVersion = 3;

    /**
     * Clears the field "u16ProductVersion".
     *
     * The field will be set to its default value. The hasU16ProductVersion()
     * method will return false.
     */
    inline void clearU16ProductVersion();

    /**
     * Checks whether the field "u16ProductVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ProductVersion()). Otherwise it will return false.
     */
    inline bool hasU16ProductVersion () const;

    /**
     * Returns the value of the member "u16ProductVersion".
     *
     * Version of the product.
     *
     * @return The value of the field "u16ProductVersion"
     */
    inline uint16 getU16ProductVersion () const;

    /**
     * Sets the value of the member "u16ProductVersion".
     *
     * Version of the product.
     *
     * @param u16ProductVersion The value which will be set
     */
    inline void setU16ProductVersion (uint16 u16ProductVersion_);

    static const T_BTSetDeviceIdentification &getDefaultInstance();

private:

    inline void set_has_u16VendorIDSource ();

    inline void clear_has_u16VendorIDSource ();

    inline void set_has_u16VendorID ();

    inline void clear_has_u16VendorID ();

    inline void set_has_u16ProductID ();

    inline void clear_has_u16ProductID ();

    inline void set_has_u16ProductVersion ();

    inline void clear_has_u16ProductVersion ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint16 _u16VendorIDSource;

    uint16 _u16VendorID;

    uint16 _u16ProductID;

    uint16 _u16ProductVersion;

};

class T_BTServiceType {
public:

    /**
     * Default constructor
     */
    inline  T_BTServiceType ();

    /**
     * Copy constructor
     */
    inline  T_BTServiceType (const T_BTServiceType &rhs);

    /**
     * All fields constructor
     */
    inline  T_BTServiceType (bool bHFP_, bool bAVP_, bool bPAN_, bool bPBAP_, bool bMAP_);

    /**
     * Destructor
     */
    inline  ~T_BTServiceType();

    /**
     * Assignment operator
     */
    inline T_BTServiceType& operator = (const T_BTServiceType& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_BTServiceType& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_BTServiceType& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_BTServiceType& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_BTServiceType& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bHFP"

    static const int kBHFP = 0;

    /**
     * Clears the field "bHFP".
     *
     * The field will be set to its default value. The hasBHFP()
     * method will return false.
     */
    inline void clearBHFP();

    /**
     * Checks whether the field "bHFP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBHFP()). Otherwise it will return false.
     */
    inline bool hasBHFP () const;

    /**
     * Returns the value of the member "bHFP".
     *
     * 0x01 - TRUE 0x00 - FALSE.
     *
     * @return The value of the field "bHFP"
     */
    inline bool getBHFP () const;

    /**
     * Sets the value of the member "bHFP".
     *
     * 0x01 - TRUE 0x00 - FALSE.
     *
     * @param bHFP The value which will be set
     */
    inline void setBHFP (bool bHFP_);

    // API of field "bAVP"

    static const int kBAVP = 1;

    /**
     * Clears the field "bAVP".
     *
     * The field will be set to its default value. The hasBAVP()
     * method will return false.
     */
    inline void clearBAVP();

    /**
     * Checks whether the field "bAVP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBAVP()). Otherwise it will return false.
     */
    inline bool hasBAVP () const;

    /**
     * Returns the value of the member "bAVP".
     *
     * 0x01 - TRUE 0x00 - FALSE.
     *
     * @return The value of the field "bAVP"
     */
    inline bool getBAVP () const;

    /**
     * Sets the value of the member "bAVP".
     *
     * 0x01 - TRUE 0x00 - FALSE.
     *
     * @param bAVP The value which will be set
     */
    inline void setBAVP (bool bAVP_);

    // API of field "bPAN"

    static const int kBPAN = 2;

    /**
     * Clears the field "bPAN".
     *
     * The field will be set to its default value. The hasBPAN()
     * method will return false.
     */
    inline void clearBPAN();

    /**
     * Checks whether the field "bPAN" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBPAN()). Otherwise it will return false.
     */
    inline bool hasBPAN () const;

    /**
     * Returns the value of the member "bPAN".
     *
     * 0x01 - TRUE 0x00 - FALSE.
     *
     * @return The value of the field "bPAN"
     */
    inline bool getBPAN () const;

    /**
     * Sets the value of the member "bPAN".
     *
     * 0x01 - TRUE 0x00 - FALSE.
     *
     * @param bPAN The value which will be set
     */
    inline void setBPAN (bool bPAN_);

    // API of field "bPBAP"

    static const int kBPBAP = 3;

    /**
     * Clears the field "bPBAP".
     *
     * The field will be set to its default value. The hasBPBAP()
     * method will return false.
     */
    inline void clearBPBAP();

    /**
     * Checks whether the field "bPBAP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBPBAP()). Otherwise it will return false.
     */
    inline bool hasBPBAP () const;

    /**
     * Returns the value of the member "bPBAP".
     *
     * 0x01 - TRUE 0x00 - FALSE.
     *
     * @return The value of the field "bPBAP"
     */
    inline bool getBPBAP () const;

    /**
     * Sets the value of the member "bPBAP".
     *
     * 0x01 - TRUE 0x00 - FALSE.
     *
     * @param bPBAP The value which will be set
     */
    inline void setBPBAP (bool bPBAP_);

    // API of field "bMAP"

    static const int kBMAP = 4;

    /**
     * Clears the field "bMAP".
     *
     * The field will be set to its default value. The hasBMAP()
     * method will return false.
     */
    inline void clearBMAP();

    /**
     * Checks whether the field "bMAP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBMAP()). Otherwise it will return false.
     */
    inline bool hasBMAP () const;

    /**
     * Returns the value of the member "bMAP".
     *
     * 0x01 - TRUE 0x00 - FALSE.
     *
     * @return The value of the field "bMAP"
     */
    inline bool getBMAP () const;

    /**
     * Sets the value of the member "bMAP".
     *
     * 0x01 - TRUE 0x00 - FALSE.
     *
     * @param bMAP The value which will be set
     */
    inline void setBMAP (bool bMAP_);

    static const T_BTServiceType &getDefaultInstance();

private:

    inline void set_has_bHFP ();

    inline void clear_has_bHFP ();

    inline void set_has_bAVP ();

    inline void clear_has_bAVP ();

    inline void set_has_bPAN ();

    inline void clear_has_bPAN ();

    inline void set_has_bPBAP ();

    inline void clear_has_bPBAP ();

    inline void set_has_bMAP ();

    inline void clear_has_bMAP ();

    uint32 _has_bits_[ (5 + 31) / 32];

    bool _bHFP;

    bool _bAVP;

    bool _bPAN;

    bool _bPBAP;

    bool _bMAP;

};

class T_BTProfileConnectionStatus {
public:

    /**
     * Default constructor
     */
    inline  T_BTProfileConnectionStatus ();

    /**
     * Copy constructor
     */
    inline  T_BTProfileConnectionStatus (const T_BTProfileConnectionStatus &rhs);

    /**
     * All fields constructor
     */
    inline  T_BTProfileConnectionStatus (T_e8_BTConnectionStatus e8HFP_, T_e8_BTConnectionStatus e8AVP_, T_e8_BTConnectionStatus e8PAN_, T_e8_BTConnectionStatus e8PBAP_, T_e8_BTConnectionStatus e8MAP_);

    /**
     * Destructor
     */
    inline  ~T_BTProfileConnectionStatus();

    /**
     * Assignment operator
     */
    inline T_BTProfileConnectionStatus& operator = (const T_BTProfileConnectionStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_BTProfileConnectionStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_BTProfileConnectionStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_BTProfileConnectionStatus& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_BTProfileConnectionStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8HFP"

    static const int kE8HFP = 0;

    /**
     * Clears the field "e8HFP".
     *
     * The field will be set to its default value. The hasE8HFP()
     * method will return false.
     */
    inline void clearE8HFP();

    /**
     * Checks whether the field "e8HFP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8HFP()). Otherwise it will return false.
     */
    inline bool hasE8HFP () const;

    /**
     * Returns the value of the member "e8HFP".
     *
     * connection status of HFP.
     *
     * @return The value of the field "e8HFP"
     */
    inline T_e8_BTConnectionStatus getE8HFP () const;

    /**
     * Sets the value of the member "e8HFP".
     *
     * connection status of HFP.
     *
     * @param e8HFP The value which will be set
     */
    inline void setE8HFP (T_e8_BTConnectionStatus e8HFP_);

    // API of field "e8AVP"

    static const int kE8AVP = 1;

    /**
     * Clears the field "e8AVP".
     *
     * The field will be set to its default value. The hasE8AVP()
     * method will return false.
     */
    inline void clearE8AVP();

    /**
     * Checks whether the field "e8AVP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8AVP()). Otherwise it will return false.
     */
    inline bool hasE8AVP () const;

    /**
     * Returns the value of the member "e8AVP".
     *
     * connection status of AVP.
     *
     * @return The value of the field "e8AVP"
     */
    inline T_e8_BTConnectionStatus getE8AVP () const;

    /**
     * Sets the value of the member "e8AVP".
     *
     * connection status of AVP.
     *
     * @param e8AVP The value which will be set
     */
    inline void setE8AVP (T_e8_BTConnectionStatus e8AVP_);

    // API of field "e8PAN"

    static const int kE8PAN = 2;

    /**
     * Clears the field "e8PAN".
     *
     * The field will be set to its default value. The hasE8PAN()
     * method will return false.
     */
    inline void clearE8PAN();

    /**
     * Checks whether the field "e8PAN" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8PAN()). Otherwise it will return false.
     */
    inline bool hasE8PAN () const;

    /**
     * Returns the value of the member "e8PAN".
     *
     * connection status of PAN.
     *
     * @return The value of the field "e8PAN"
     */
    inline T_e8_BTConnectionStatus getE8PAN () const;

    /**
     * Sets the value of the member "e8PAN".
     *
     * connection status of PAN.
     *
     * @param e8PAN The value which will be set
     */
    inline void setE8PAN (T_e8_BTConnectionStatus e8PAN_);

    // API of field "e8PBAP"

    static const int kE8PBAP = 3;

    /**
     * Clears the field "e8PBAP".
     *
     * The field will be set to its default value. The hasE8PBAP()
     * method will return false.
     */
    inline void clearE8PBAP();

    /**
     * Checks whether the field "e8PBAP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8PBAP()). Otherwise it will return false.
     */
    inline bool hasE8PBAP () const;

    /**
     * Returns the value of the member "e8PBAP".
     *
     * connection status of PBAP.
     *
     * @return The value of the field "e8PBAP"
     */
    inline T_e8_BTConnectionStatus getE8PBAP () const;

    /**
     * Sets the value of the member "e8PBAP".
     *
     * connection status of PBAP.
     *
     * @param e8PBAP The value which will be set
     */
    inline void setE8PBAP (T_e8_BTConnectionStatus e8PBAP_);

    // API of field "e8MAP"

    static const int kE8MAP = 4;

    /**
     * Clears the field "e8MAP".
     *
     * The field will be set to its default value. The hasE8MAP()
     * method will return false.
     */
    inline void clearE8MAP();

    /**
     * Checks whether the field "e8MAP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MAP()). Otherwise it will return false.
     */
    inline bool hasE8MAP () const;

    /**
     * Returns the value of the member "e8MAP".
     *
     * connection status of MAP.
     *
     * @return The value of the field "e8MAP"
     */
    inline T_e8_BTConnectionStatus getE8MAP () const;

    /**
     * Sets the value of the member "e8MAP".
     *
     * connection status of MAP.
     *
     * @param e8MAP The value which will be set
     */
    inline void setE8MAP (T_e8_BTConnectionStatus e8MAP_);

    static const T_BTProfileConnectionStatus &getDefaultInstance();

private:

    inline void set_has_e8HFP ();

    inline void clear_has_e8HFP ();

    inline void set_has_e8AVP ();

    inline void clear_has_e8AVP ();

    inline void set_has_e8PAN ();

    inline void clear_has_e8PAN ();

    inline void set_has_e8PBAP ();

    inline void clear_has_e8PBAP ();

    inline void set_has_e8MAP ();

    inline void clear_has_e8MAP ();

    uint32 _has_bits_[ (5 + 31) / 32];

    T_e8_BTConnectionStatus _e8HFP;

    T_e8_BTConnectionStatus _e8AVP;

    T_e8_BTConnectionStatus _e8PAN;

    T_e8_BTConnectionStatus _e8PBAP;

    T_e8_BTConnectionStatus _e8MAP;

};

class T_BTProfileDisconnectedReason {
public:

    /**
     * Default constructor
     */
    inline  T_BTProfileDisconnectedReason ();

    /**
     * Copy constructor
     */
    inline  T_BTProfileDisconnectedReason (const T_BTProfileDisconnectedReason &rhs);

    /**
     * All fields constructor
     */
    inline  T_BTProfileDisconnectedReason (T_e8_BTSetDeviceDisconnectedReason e8HFP_, T_e8_BTSetDeviceDisconnectedReason e8AVP_, T_e8_BTSetDeviceDisconnectedReason e8PAN_, T_e8_BTSetDeviceDisconnectedReason e8PBAP_, T_e8_BTSetDeviceDisconnectedReason e8MAP_);

    /**
     * Destructor
     */
    inline  ~T_BTProfileDisconnectedReason();

    /**
     * Assignment operator
     */
    inline T_BTProfileDisconnectedReason& operator = (const T_BTProfileDisconnectedReason& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_BTProfileDisconnectedReason& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_BTProfileDisconnectedReason& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_BTProfileDisconnectedReason& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_BTProfileDisconnectedReason& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8HFP"

    static const int kE8HFP = 0;

    /**
     * Clears the field "e8HFP".
     *
     * The field will be set to its default value. The hasE8HFP()
     * method will return false.
     */
    inline void clearE8HFP();

    /**
     * Checks whether the field "e8HFP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8HFP()). Otherwise it will return false.
     */
    inline bool hasE8HFP () const;

    /**
     * Returns the value of the member "e8HFP".
     *
     * Disconnected reason for HFP.
     *
     * @return The value of the field "e8HFP"
     */
    inline T_e8_BTSetDeviceDisconnectedReason getE8HFP () const;

    /**
     * Sets the value of the member "e8HFP".
     *
     * Disconnected reason for HFP.
     *
     * @param e8HFP The value which will be set
     */
    inline void setE8HFP (T_e8_BTSetDeviceDisconnectedReason e8HFP_);

    // API of field "e8AVP"

    static const int kE8AVP = 1;

    /**
     * Clears the field "e8AVP".
     *
     * The field will be set to its default value. The hasE8AVP()
     * method will return false.
     */
    inline void clearE8AVP();

    /**
     * Checks whether the field "e8AVP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8AVP()). Otherwise it will return false.
     */
    inline bool hasE8AVP () const;

    /**
     * Returns the value of the member "e8AVP".
     *
     * Identifies the reason for the disconnected profile.
     *
     * @return The value of the field "e8AVP"
     */
    inline T_e8_BTSetDeviceDisconnectedReason getE8AVP () const;

    /**
     * Sets the value of the member "e8AVP".
     *
     * Identifies the reason for the disconnected profile.
     *
     * @param e8AVP The value which will be set
     */
    inline void setE8AVP (T_e8_BTSetDeviceDisconnectedReason e8AVP_);

    // API of field "e8PAN"

    static const int kE8PAN = 2;

    /**
     * Clears the field "e8PAN".
     *
     * The field will be set to its default value. The hasE8PAN()
     * method will return false.
     */
    inline void clearE8PAN();

    /**
     * Checks whether the field "e8PAN" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8PAN()). Otherwise it will return false.
     */
    inline bool hasE8PAN () const;

    /**
     * Returns the value of the member "e8PAN".
     *
     * Disconnected reason for PAN.
     *
     * @return The value of the field "e8PAN"
     */
    inline T_e8_BTSetDeviceDisconnectedReason getE8PAN () const;

    /**
     * Sets the value of the member "e8PAN".
     *
     * Disconnected reason for PAN.
     *
     * @param e8PAN The value which will be set
     */
    inline void setE8PAN (T_e8_BTSetDeviceDisconnectedReason e8PAN_);

    // API of field "e8PBAP"

    static const int kE8PBAP = 3;

    /**
     * Clears the field "e8PBAP".
     *
     * The field will be set to its default value. The hasE8PBAP()
     * method will return false.
     */
    inline void clearE8PBAP();

    /**
     * Checks whether the field "e8PBAP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8PBAP()). Otherwise it will return false.
     */
    inline bool hasE8PBAP () const;

    /**
     * Returns the value of the member "e8PBAP".
     *
     * Disconnected reason for PBAP.
     *
     * @return The value of the field "e8PBAP"
     */
    inline T_e8_BTSetDeviceDisconnectedReason getE8PBAP () const;

    /**
     * Sets the value of the member "e8PBAP".
     *
     * Disconnected reason for PBAP.
     *
     * @param e8PBAP The value which will be set
     */
    inline void setE8PBAP (T_e8_BTSetDeviceDisconnectedReason e8PBAP_);

    // API of field "e8MAP"

    static const int kE8MAP = 4;

    /**
     * Clears the field "e8MAP".
     *
     * The field will be set to its default value. The hasE8MAP()
     * method will return false.
     */
    inline void clearE8MAP();

    /**
     * Checks whether the field "e8MAP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MAP()). Otherwise it will return false.
     */
    inline bool hasE8MAP () const;

    /**
     * Returns the value of the member "e8MAP".
     *
     * Disconnected reason for MAP.
     *
     * @return The value of the field "e8MAP"
     */
    inline T_e8_BTSetDeviceDisconnectedReason getE8MAP () const;

    /**
     * Sets the value of the member "e8MAP".
     *
     * Disconnected reason for MAP.
     *
     * @param e8MAP The value which will be set
     */
    inline void setE8MAP (T_e8_BTSetDeviceDisconnectedReason e8MAP_);

    static const T_BTProfileDisconnectedReason &getDefaultInstance();

private:

    inline void set_has_e8HFP ();

    inline void clear_has_e8HFP ();

    inline void set_has_e8AVP ();

    inline void clear_has_e8AVP ();

    inline void set_has_e8PAN ();

    inline void clear_has_e8PAN ();

    inline void set_has_e8PBAP ();

    inline void clear_has_e8PBAP ();

    inline void set_has_e8MAP ();

    inline void clear_has_e8MAP ();

    uint32 _has_bits_[ (5 + 31) / 32];

    T_e8_BTSetDeviceDisconnectedReason _e8HFP;

    T_e8_BTSetDeviceDisconnectedReason _e8AVP;

    T_e8_BTSetDeviceDisconnectedReason _e8PAN;

    T_e8_BTSetDeviceDisconnectedReason _e8PBAP;

    T_e8_BTSetDeviceDisconnectedReason _e8MAP;

};

class T_BTProfileFavoriteIndex {
public:

    /**
     * Default constructor
     */
    inline  T_BTProfileFavoriteIndex ();

    /**
     * Copy constructor
     */
    inline  T_BTProfileFavoriteIndex (const T_BTProfileFavoriteIndex &rhs);

    /**
     * All fields constructor
     */
    inline  T_BTProfileFavoriteIndex (uint8 u8HFP_, uint8 u8AVP_);

    /**
     * Destructor
     */
    inline  ~T_BTProfileFavoriteIndex();

    /**
     * Assignment operator
     */
    inline T_BTProfileFavoriteIndex& operator = (const T_BTProfileFavoriteIndex& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_BTProfileFavoriteIndex& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_BTProfileFavoriteIndex& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_BTProfileFavoriteIndex& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_BTProfileFavoriteIndex& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8HFP"

    static const int kU8HFP = 0;

    /**
     * Clears the field "u8HFP".
     *
     * The field will be set to its default value. The hasU8HFP()
     * method will return false.
     */
    inline void clearU8HFP();

    /**
     * Checks whether the field "u8HFP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8HFP()). Otherwise it will return false.
     */
    inline bool hasU8HFP () const;

    /**
     * Returns the value of the member "u8HFP".
     *
     * Favorite index of HFP(favorite index - 0 means protocol is not favorite, favorite index - 1 represents the most favorite, etc.,).
     *
     * @return The value of the field "u8HFP"
     */
    inline uint8 getU8HFP () const;

    /**
     * Sets the value of the member "u8HFP".
     *
     * Favorite index of HFP(favorite index - 0 means protocol is not favorite, favorite index - 1 represents the most favorite, etc.,).
     *
     * @param u8HFP The value which will be set
     */
    inline void setU8HFP (uint8 u8HFP_);

    // API of field "u8AVP"

    static const int kU8AVP = 1;

    /**
     * Clears the field "u8AVP".
     *
     * The field will be set to its default value. The hasU8AVP()
     * method will return false.
     */
    inline void clearU8AVP();

    /**
     * Checks whether the field "u8AVP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8AVP()). Otherwise it will return false.
     */
    inline bool hasU8AVP () const;

    /**
     * Returns the value of the member "u8AVP".
     *
     * Favorite index of AVP(favorite index - 0 means protocol is not favorite, favorite index - 1 represents the most favorite, etc.,).
     *
     * @return The value of the field "u8AVP"
     */
    inline uint8 getU8AVP () const;

    /**
     * Sets the value of the member "u8AVP".
     *
     * Favorite index of AVP(favorite index - 0 means protocol is not favorite, favorite index - 1 represents the most favorite, etc.,).
     *
     * @param u8AVP The value which will be set
     */
    inline void setU8AVP (uint8 u8AVP_);

    static const T_BTProfileFavoriteIndex &getDefaultInstance();

private:

    inline void set_has_u8HFP ();

    inline void clear_has_u8HFP ();

    inline void set_has_u8AVP ();

    inline void clear_has_u8AVP ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8HFP;

    uint8 _u8AVP;

};

class T_BTSetDeviceListExtendedResultItem {
public:

    /**
     * Default constructor
     */
    inline  T_BTSetDeviceListExtendedResultItem ();

    /**
     * Copy constructor
     */
    inline  T_BTSetDeviceListExtendedResultItem (const T_BTSetDeviceListExtendedResultItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_BTSetDeviceListExtendedResultItem (const ::fi_basetypes_most::T_String& sDeviceAddress_, uint8 u8DeviceHandle_, const ::fi_basetypes_most::T_String& sDeviceName_, bool bDeviceConnectedStatus_, T_e8_BTSetDeviceDisconnectedReason e8DeviceDisconnectedReason_, const T_BTServiceType& oDeviceProfileStatus_, const T_BTProfileDisconnectedReason& oDeviceProfileDisconnectedReason_, const T_BTSetSupportedProfiles& oDeviceSupportedProfiles_, bool bOutgoingSourceDeviceStatus_, const ::most_BTSet_fi_types::T_BTSetDateTimeStamp& oDateTimeStamp_, const T_BTSetDeviceIdentification& oDeviceInfo_, T_e8_BTConnectionStatus e8DeviceConnectionStatus_, const T_BTProfileConnectionStatus& oDeviceProfileConnectionStatus_, uint8 u8DeviceFavoriteIndex_, const T_BTProfileFavoriteIndex& oDeviceProfileFavoriteIndex_, T_e8_BTUsagePreference e8DeviceUsagePreference_, const ::most_BTSet_fi_types::T_BTSetDateTimeStamp& oDevicePairedDateTimeStamp_, bool biAPoverBTSupport_);

    /**
     * Destructor
     */
    inline  ~T_BTSetDeviceListExtendedResultItem();

    /**
     * Assignment operator
     */
    inline T_BTSetDeviceListExtendedResultItem& operator = (const T_BTSetDeviceListExtendedResultItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_BTSetDeviceListExtendedResultItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_BTSetDeviceListExtendedResultItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_BTSetDeviceListExtendedResultItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_BTSetDeviceListExtendedResultItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sDeviceAddress"

    static const int kSDeviceAddress = 0;

    /**
     * Clears the field "sDeviceAddress".
     *
     * The field will be set to its default value. The hasSDeviceAddress()
     * method will return false.
     */
    inline void clearSDeviceAddress();

    /**
     * Checks whether the field "sDeviceAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDeviceAddress()). Otherwise it will return false.
     */
    inline bool hasSDeviceAddress () const;

    /**
     * Returns the value of the member "sDeviceAddress".
     *
     * Unique address for each one of the up to 10 devices that can be paired.
     *
     * @return The value of the field "sDeviceAddress"
     */
    inline const ::fi_basetypes_most::T_String& getSDeviceAddress () const;

    /**
     * Retrieves the value of the field "sDeviceAddress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDeviceAddress".
     */
    inline ::fi_basetypes_most::T_String& getSDeviceAddressMutable ();

    /**
     * Sets the value of the member "sDeviceAddress".
     *
     * Unique address for each one of the up to 10 devices that can be paired.
     *
     * @param sDeviceAddress The value which will be set
     */
    inline void setSDeviceAddress (const ::fi_basetypes_most::T_String& sDeviceAddress_);

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 1;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    // API of field "sDeviceName"

    static const int kSDeviceName = 2;

    /**
     * Clears the field "sDeviceName".
     *
     * The field will be set to its default value. The hasSDeviceName()
     * method will return false.
     */
    inline void clearSDeviceName();

    /**
     * Checks whether the field "sDeviceName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDeviceName()). Otherwise it will return false.
     */
    inline bool hasSDeviceName () const;

    /**
     * Returns the value of the member "sDeviceName".
     *
     * Name of the device (the Bluetooth friendly name).
     *
     * @return The value of the field "sDeviceName"
     */
    inline const ::fi_basetypes_most::T_String& getSDeviceName () const;

    /**
     * Retrieves the value of the field "sDeviceName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDeviceName".
     */
    inline ::fi_basetypes_most::T_String& getSDeviceNameMutable ();

    /**
     * Sets the value of the member "sDeviceName".
     *
     * Name of the device (the Bluetooth friendly name).
     *
     * @param sDeviceName The value which will be set
     */
    inline void setSDeviceName (const ::fi_basetypes_most::T_String& sDeviceName_);

    // API of field "bDeviceConnectedStatus"

    static const int kBDeviceConnectedStatus = 3;

    /**
     * Clears the field "bDeviceConnectedStatus".
     *
     * The field will be set to its default value. The hasBDeviceConnectedStatus()
     * method will return false.
     */
    inline void clearBDeviceConnectedStatus();

    /**
     * Checks whether the field "bDeviceConnectedStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDeviceConnectedStatus()). Otherwise it will return false.
     */
    inline bool hasBDeviceConnectedStatus () const;

    /**
     * Returns the value of the member "bDeviceConnectedStatus".
     *
     * Provides the status of whether the device is connected or not connected.
     *
     * @return The value of the field "bDeviceConnectedStatus"
     */
    inline bool getBDeviceConnectedStatus () const;

    /**
     * Sets the value of the member "bDeviceConnectedStatus".
     *
     * Provides the status of whether the device is connected or not connected.
     *
     * @param bDeviceConnectedStatus The value which will be set
     */
    inline void setBDeviceConnectedStatus (bool bDeviceConnectedStatus_);

    // API of field "e8DeviceDisconnectedReason"

    static const int kE8DeviceDisconnectedReason = 4;

    /**
     * Clears the field "e8DeviceDisconnectedReason".
     *
     * The field will be set to its default value. The hasE8DeviceDisconnectedReason()
     * method will return false.
     */
    inline void clearE8DeviceDisconnectedReason();

    /**
     * Checks whether the field "e8DeviceDisconnectedReason" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DeviceDisconnectedReason()). Otherwise it will return false.
     */
    inline bool hasE8DeviceDisconnectedReason () const;

    /**
     * Returns the value of the member "e8DeviceDisconnectedReason".
     *
     * Identifies the reason for the disconnected phone.
     *
     * @return The value of the field "e8DeviceDisconnectedReason"
     */
    inline T_e8_BTSetDeviceDisconnectedReason getE8DeviceDisconnectedReason () const;

    /**
     * Sets the value of the member "e8DeviceDisconnectedReason".
     *
     * Identifies the reason for the disconnected phone.
     *
     * @param e8DeviceDisconnectedReason The value which will be set
     */
    inline void setE8DeviceDisconnectedReason (T_e8_BTSetDeviceDisconnectedReason e8DeviceDisconnectedReason_);

    // API of field "oDeviceProfileStatus"

    static const int kODeviceProfileStatus = 5;

    /**
     * Clears the field "oDeviceProfileStatus".
     *
     * The field will be set to its default value. The hasODeviceProfileStatus()
     * method will return false.
     */
    inline void clearODeviceProfileStatus();

    /**
     * Checks whether the field "oDeviceProfileStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setODeviceProfileStatus()). Otherwise it will return false.
     */
    inline bool hasODeviceProfileStatus () const;

    /**
     * Returns the value of the member "oDeviceProfileStatus".
     *
     * Provides the status of profiles of the device which are connected(TRUE) / not connected(FALSE).
     *
     * @return The value of the field "oDeviceProfileStatus"
     */
    inline const T_BTServiceType& getODeviceProfileStatus () const;

    /**
     * Retrieves the value of the field "oDeviceProfileStatus" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oDeviceProfileStatus".
     */
    inline T_BTServiceType& getODeviceProfileStatusMutable ();

    /**
     * Sets the value of the member "oDeviceProfileStatus".
     *
     * Provides the status of profiles of the device which are connected(TRUE) / not connected(FALSE).
     *
     * @param oDeviceProfileStatus The value which will be set
     */
    inline void setODeviceProfileStatus (const T_BTServiceType& oDeviceProfileStatus_);

    // API of field "oDeviceProfileDisconnectedReason"

    static const int kODeviceProfileDisconnectedReason = 6;

    /**
     * Clears the field "oDeviceProfileDisconnectedReason".
     *
     * The field will be set to its default value. The hasODeviceProfileDisconnectedReason()
     * method will return false.
     */
    inline void clearODeviceProfileDisconnectedReason();

    /**
     * Checks whether the field "oDeviceProfileDisconnectedReason" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setODeviceProfileDisconnectedReason()). Otherwise it will return false.
     */
    inline bool hasODeviceProfileDisconnectedReason () const;

    /**
     * Returns the value of the member "oDeviceProfileDisconnectedReason".
     *
     * Identifies the reason for the disconnected profile.
     *
     * @return The value of the field "oDeviceProfileDisconnectedReason"
     */
    inline const T_BTProfileDisconnectedReason& getODeviceProfileDisconnectedReason () const;

    /**
     * Retrieves the value of the field "oDeviceProfileDisconnectedReason" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oDeviceProfileDisconnectedReason".
     */
    inline T_BTProfileDisconnectedReason& getODeviceProfileDisconnectedReasonMutable ();

    /**
     * Sets the value of the member "oDeviceProfileDisconnectedReason".
     *
     * Identifies the reason for the disconnected profile.
     *
     * @param oDeviceProfileDisconnectedReason The value which will be set
     */
    inline void setODeviceProfileDisconnectedReason (const T_BTProfileDisconnectedReason& oDeviceProfileDisconnectedReason_);

    // API of field "oDeviceSupportedProfiles"

    static const int kODeviceSupportedProfiles = 7;

    /**
     * Clears the field "oDeviceSupportedProfiles".
     *
     * The field will be set to its default value. The hasODeviceSupportedProfiles()
     * method will return false.
     */
    inline void clearODeviceSupportedProfiles();

    /**
     * Checks whether the field "oDeviceSupportedProfiles" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setODeviceSupportedProfiles()). Otherwise it will return false.
     */
    inline bool hasODeviceSupportedProfiles () const;

    /**
     * Returns the value of the member "oDeviceSupportedProfiles".
     *
     * Provides the supported profiles of the device.
     *
     * @return The value of the field "oDeviceSupportedProfiles"
     */
    inline const T_BTSetSupportedProfiles& getODeviceSupportedProfiles () const;

    /**
     * Retrieves the value of the field "oDeviceSupportedProfiles" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oDeviceSupportedProfiles".
     */
    inline T_BTSetSupportedProfiles& getODeviceSupportedProfilesMutable ();

    /**
     * Sets the value of the member "oDeviceSupportedProfiles".
     *
     * Provides the supported profiles of the device.
     *
     * @param oDeviceSupportedProfiles The value which will be set
     */
    inline void setODeviceSupportedProfiles (const T_BTSetSupportedProfiles& oDeviceSupportedProfiles_);

    // API of field "bOutgoingSourceDeviceStatus"

    static const int kBOutgoingSourceDeviceStatus = 8;

    /**
     * Clears the field "bOutgoingSourceDeviceStatus".
     *
     * The field will be set to its default value. The hasBOutgoingSourceDeviceStatus()
     * method will return false.
     */
    inline void clearBOutgoingSourceDeviceStatus();

    /**
     * Checks whether the field "bOutgoingSourceDeviceStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBOutgoingSourceDeviceStatus()). Otherwise it will return false.
     */
    inline bool hasBOutgoingSourceDeviceStatus () const;

    /**
     * Returns the value of the member "bOutgoingSourceDeviceStatus".
     *
     * Identifies if the device is an Outgoing Source Device.
     *
     * @return The value of the field "bOutgoingSourceDeviceStatus"
     */
    inline bool getBOutgoingSourceDeviceStatus () const;

    /**
     * Sets the value of the member "bOutgoingSourceDeviceStatus".
     *
     * Identifies if the device is an Outgoing Source Device.
     *
     * @param bOutgoingSourceDeviceStatus The value which will be set
     */
    inline void setBOutgoingSourceDeviceStatus (bool bOutgoingSourceDeviceStatus_);

    // API of field "oDateTimeStamp"

    static const int kODateTimeStamp = 9;

    /**
     * Clears the field "oDateTimeStamp".
     *
     * The field will be set to its default value. The hasODateTimeStamp()
     * method will return false.
     */
    inline void clearODateTimeStamp();

    /**
     * Checks whether the field "oDateTimeStamp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setODateTimeStamp()). Otherwise it will return false.
     */
    inline bool hasODateTimeStamp () const;

    /**
     * Returns the value of the member "oDateTimeStamp".
     *
     * Provides the date and time stamp of the last Bluetooth connection to the particular Bluetooth device. Formatted as: YYYYMMDDTHHMMSS
     *
     * @return The value of the field "oDateTimeStamp"
     */
    inline const ::most_BTSet_fi_types::T_BTSetDateTimeStamp& getODateTimeStamp () const;

    /**
     * Retrieves the value of the field "oDateTimeStamp" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oDateTimeStamp".
     */
    inline ::most_BTSet_fi_types::T_BTSetDateTimeStamp& getODateTimeStampMutable ();

    /**
     * Sets the value of the member "oDateTimeStamp".
     *
     * Provides the date and time stamp of the last Bluetooth connection to the particular Bluetooth device. Formatted as: YYYYMMDDTHHMMSS
     *
     * @param oDateTimeStamp The value which will be set
     */
    inline void setODateTimeStamp (const ::most_BTSet_fi_types::T_BTSetDateTimeStamp& oDateTimeStamp_);

    // API of field "oDeviceInfo"

    static const int kODeviceInfo = 10;

    /**
     * Clears the field "oDeviceInfo".
     *
     * The field will be set to its default value. The hasODeviceInfo()
     * method will return false.
     */
    inline void clearODeviceInfo();

    /**
     * Checks whether the field "oDeviceInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setODeviceInfo()). Otherwise it will return false.
     */
    inline bool hasODeviceInfo () const;

    /**
     * Returns the value of the member "oDeviceInfo".
     *
     * Provides the DeviceInfo of the device, Such as u16VendorIDSource, u16VendorID, u16ProductID and u16ProductVersion.
     *
     * @return The value of the field "oDeviceInfo"
     */
    inline const T_BTSetDeviceIdentification& getODeviceInfo () const;

    /**
     * Retrieves the value of the field "oDeviceInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oDeviceInfo".
     */
    inline T_BTSetDeviceIdentification& getODeviceInfoMutable ();

    /**
     * Sets the value of the member "oDeviceInfo".
     *
     * Provides the DeviceInfo of the device, Such as u16VendorIDSource, u16VendorID, u16ProductID and u16ProductVersion.
     *
     * @param oDeviceInfo The value which will be set
     */
    inline void setODeviceInfo (const T_BTSetDeviceIdentification& oDeviceInfo_);

    // API of field "e8DeviceConnectionStatus"

    static const int kE8DeviceConnectionStatus = 11;

    /**
     * Clears the field "e8DeviceConnectionStatus".
     *
     * The field will be set to its default value. The hasE8DeviceConnectionStatus()
     * method will return false.
     */
    inline void clearE8DeviceConnectionStatus();

    /**
     * Checks whether the field "e8DeviceConnectionStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DeviceConnectionStatus()). Otherwise it will return false.
     */
    inline bool hasE8DeviceConnectionStatus () const;

    /**
     * Returns the value of the member "e8DeviceConnectionStatus".
     *
     * Provides the connection status of the device.
     *
     * @return The value of the field "e8DeviceConnectionStatus"
     */
    inline T_e8_BTConnectionStatus getE8DeviceConnectionStatus () const;

    /**
     * Sets the value of the member "e8DeviceConnectionStatus".
     *
     * Provides the connection status of the device.
     *
     * @param e8DeviceConnectionStatus The value which will be set
     */
    inline void setE8DeviceConnectionStatus (T_e8_BTConnectionStatus e8DeviceConnectionStatus_);

    // API of field "oDeviceProfileConnectionStatus"

    static const int kODeviceProfileConnectionStatus = 12;

    /**
     * Clears the field "oDeviceProfileConnectionStatus".
     *
     * The field will be set to its default value. The hasODeviceProfileConnectionStatus()
     * method will return false.
     */
    inline void clearODeviceProfileConnectionStatus();

    /**
     * Checks whether the field "oDeviceProfileConnectionStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setODeviceProfileConnectionStatus()). Otherwise it will return false.
     */
    inline bool hasODeviceProfileConnectionStatus () const;

    /**
     * Returns the value of the member "oDeviceProfileConnectionStatus".
     *
     * Provides the device profile connection status of the device.
     *
     * @return The value of the field "oDeviceProfileConnectionStatus"
     */
    inline const T_BTProfileConnectionStatus& getODeviceProfileConnectionStatus () const;

    /**
     * Retrieves the value of the field "oDeviceProfileConnectionStatus" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oDeviceProfileConnectionStatus".
     */
    inline T_BTProfileConnectionStatus& getODeviceProfileConnectionStatusMutable ();

    /**
     * Sets the value of the member "oDeviceProfileConnectionStatus".
     *
     * Provides the device profile connection status of the device.
     *
     * @param oDeviceProfileConnectionStatus The value which will be set
     */
    inline void setODeviceProfileConnectionStatus (const T_BTProfileConnectionStatus& oDeviceProfileConnectionStatus_);

    // API of field "u8DeviceFavoriteIndex"

    static const int kU8DeviceFavoriteIndex = 13;

    /**
     * Clears the field "u8DeviceFavoriteIndex".
     *
     * The field will be set to its default value. The hasU8DeviceFavoriteIndex()
     * method will return false.
     */
    inline void clearU8DeviceFavoriteIndex();

    /**
     * Checks whether the field "u8DeviceFavoriteIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceFavoriteIndex()). Otherwise it will return false.
     */
    inline bool hasU8DeviceFavoriteIndex () const;

    /**
     * Returns the value of the member "u8DeviceFavoriteIndex".
     *
     * Provides the device favorite index(favorite index - 0 means device is not favorite, favorite index - 1 represents the most favorite, etc.,).
     *
     * @return The value of the field "u8DeviceFavoriteIndex"
     */
    inline uint8 getU8DeviceFavoriteIndex () const;

    /**
     * Sets the value of the member "u8DeviceFavoriteIndex".
     *
     * Provides the device favorite index(favorite index - 0 means device is not favorite, favorite index - 1 represents the most favorite, etc.,).
     *
     * @param u8DeviceFavoriteIndex The value which will be set
     */
    inline void setU8DeviceFavoriteIndex (uint8 u8DeviceFavoriteIndex_);

    // API of field "oDeviceProfileFavoriteIndex"

    static const int kODeviceProfileFavoriteIndex = 14;

    /**
     * Clears the field "oDeviceProfileFavoriteIndex".
     *
     * The field will be set to its default value. The hasODeviceProfileFavoriteIndex()
     * method will return false.
     */
    inline void clearODeviceProfileFavoriteIndex();

    /**
     * Checks whether the field "oDeviceProfileFavoriteIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setODeviceProfileFavoriteIndex()). Otherwise it will return false.
     */
    inline bool hasODeviceProfileFavoriteIndex () const;

    /**
     * Returns the value of the member "oDeviceProfileFavoriteIndex".
     *
     * Provides the profiles favorite index.
     *
     * @return The value of the field "oDeviceProfileFavoriteIndex"
     */
    inline const T_BTProfileFavoriteIndex& getODeviceProfileFavoriteIndex () const;

    /**
     * Retrieves the value of the field "oDeviceProfileFavoriteIndex" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oDeviceProfileFavoriteIndex".
     */
    inline T_BTProfileFavoriteIndex& getODeviceProfileFavoriteIndexMutable ();

    /**
     * Sets the value of the member "oDeviceProfileFavoriteIndex".
     *
     * Provides the profiles favorite index.
     *
     * @param oDeviceProfileFavoriteIndex The value which will be set
     */
    inline void setODeviceProfileFavoriteIndex (const T_BTProfileFavoriteIndex& oDeviceProfileFavoriteIndex_);

    // API of field "e8DeviceUsagePreference"

    static const int kE8DeviceUsagePreference = 15;

    /**
     * Clears the field "e8DeviceUsagePreference".
     *
     * The field will be set to its default value. The hasE8DeviceUsagePreference()
     * method will return false.
     */
    inline void clearE8DeviceUsagePreference();

    /**
     * Checks whether the field "e8DeviceUsagePreference" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DeviceUsagePreference()). Otherwise it will return false.
     */
    inline bool hasE8DeviceUsagePreference () const;

    /**
     * Returns the value of the member "e8DeviceUsagePreference".
     *
     * Provides the device usage preference.
     *
     * @return The value of the field "e8DeviceUsagePreference"
     */
    inline T_e8_BTUsagePreference getE8DeviceUsagePreference () const;

    /**
     * Sets the value of the member "e8DeviceUsagePreference".
     *
     * Provides the device usage preference.
     *
     * @param e8DeviceUsagePreference The value which will be set
     */
    inline void setE8DeviceUsagePreference (T_e8_BTUsagePreference e8DeviceUsagePreference_);

    // API of field "oDevicePairedDateTimeStamp"

    static const int kODevicePairedDateTimeStamp = 16;

    /**
     * Clears the field "oDevicePairedDateTimeStamp".
     *
     * The field will be set to its default value. The hasODevicePairedDateTimeStamp()
     * method will return false.
     */
    inline void clearODevicePairedDateTimeStamp();

    /**
     * Checks whether the field "oDevicePairedDateTimeStamp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setODevicePairedDateTimeStamp()). Otherwise it will return false.
     */
    inline bool hasODevicePairedDateTimeStamp () const;

    /**
     * Returns the value of the member "oDevicePairedDateTimeStamp".
     *
     * Provides the date and time stamp of the Bluetooth pairing to the particular Bluetooth device. Formatted as: YYYYMMDDTHHMMSS
     *
     * @return The value of the field "oDevicePairedDateTimeStamp"
     */
    inline const ::most_BTSet_fi_types::T_BTSetDateTimeStamp& getODevicePairedDateTimeStamp () const;

    /**
     * Retrieves the value of the field "oDevicePairedDateTimeStamp" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oDevicePairedDateTimeStamp".
     */
    inline ::most_BTSet_fi_types::T_BTSetDateTimeStamp& getODevicePairedDateTimeStampMutable ();

    /**
     * Sets the value of the member "oDevicePairedDateTimeStamp".
     *
     * Provides the date and time stamp of the Bluetooth pairing to the particular Bluetooth device. Formatted as: YYYYMMDDTHHMMSS
     *
     * @param oDevicePairedDateTimeStamp The value which will be set
     */
    inline void setODevicePairedDateTimeStamp (const ::most_BTSet_fi_types::T_BTSetDateTimeStamp& oDevicePairedDateTimeStamp_);

    // API of field "biAPoverBTSupport"

    static const int kBiAPoverBTSupport = 17;

    /**
     * Clears the field "biAPoverBTSupport".
     *
     * The field will be set to its default value. The hasBiAPoverBTSupport()
     * method will return false.
     */
    inline void clearBiAPoverBTSupport();

    /**
     * Checks whether the field "biAPoverBTSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBiAPoverBTSupport()). Otherwise it will return false.
     */
    inline bool hasBiAPoverBTSupport () const;

    /**
     * Returns the value of the member "biAPoverBTSupport".
     *
     * Identifies if the device supports the iAP over BT profile feature.
     *
     * @return The value of the field "biAPoverBTSupport"
     */
    inline bool getBiAPoverBTSupport () const;

    /**
     * Sets the value of the member "biAPoverBTSupport".
     *
     * Identifies if the device supports the iAP over BT profile feature.
     *
     * @param biAPoverBTSupport The value which will be set
     */
    inline void setBiAPoverBTSupport (bool biAPoverBTSupport_);

    static const T_BTSetDeviceListExtendedResultItem &getDefaultInstance();

private:

    inline void set_has_sDeviceAddress ();

    inline void clear_has_sDeviceAddress ();

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    inline void set_has_sDeviceName ();

    inline void clear_has_sDeviceName ();

    inline void set_has_bDeviceConnectedStatus ();

    inline void clear_has_bDeviceConnectedStatus ();

    inline void set_has_e8DeviceDisconnectedReason ();

    inline void clear_has_e8DeviceDisconnectedReason ();

    inline void set_has_oDeviceProfileStatus ();

    inline void clear_has_oDeviceProfileStatus ();

    inline void set_has_oDeviceProfileDisconnectedReason ();

    inline void clear_has_oDeviceProfileDisconnectedReason ();

    inline void set_has_oDeviceSupportedProfiles ();

    inline void clear_has_oDeviceSupportedProfiles ();

    inline void set_has_bOutgoingSourceDeviceStatus ();

    inline void clear_has_bOutgoingSourceDeviceStatus ();

    inline void set_has_oDateTimeStamp ();

    inline void clear_has_oDateTimeStamp ();

    inline void set_has_oDeviceInfo ();

    inline void clear_has_oDeviceInfo ();

    inline void set_has_e8DeviceConnectionStatus ();

    inline void clear_has_e8DeviceConnectionStatus ();

    inline void set_has_oDeviceProfileConnectionStatus ();

    inline void clear_has_oDeviceProfileConnectionStatus ();

    inline void set_has_u8DeviceFavoriteIndex ();

    inline void clear_has_u8DeviceFavoriteIndex ();

    inline void set_has_oDeviceProfileFavoriteIndex ();

    inline void clear_has_oDeviceProfileFavoriteIndex ();

    inline void set_has_e8DeviceUsagePreference ();

    inline void clear_has_e8DeviceUsagePreference ();

    inline void set_has_oDevicePairedDateTimeStamp ();

    inline void clear_has_oDevicePairedDateTimeStamp ();

    inline void set_has_biAPoverBTSupport ();

    inline void clear_has_biAPoverBTSupport ();

    uint32 _has_bits_[ (18 + 31) / 32];

    ::fi_basetypes_most::T_String _sDeviceAddress;

    uint8 _u8DeviceHandle;

    ::fi_basetypes_most::T_String _sDeviceName;

    bool _bDeviceConnectedStatus;

    T_e8_BTSetDeviceDisconnectedReason _e8DeviceDisconnectedReason;

    T_BTServiceType _oDeviceProfileStatus;

    T_BTProfileDisconnectedReason _oDeviceProfileDisconnectedReason;

    T_BTSetSupportedProfiles _oDeviceSupportedProfiles;

    bool _bOutgoingSourceDeviceStatus;

    ::most_BTSet_fi_types::T_BTSetDateTimeStamp _oDateTimeStamp;

    T_BTSetDeviceIdentification _oDeviceInfo;

    T_e8_BTConnectionStatus _e8DeviceConnectionStatus;

    T_BTProfileConnectionStatus _oDeviceProfileConnectionStatus;

    uint8 _u8DeviceFavoriteIndex;

    T_BTProfileFavoriteIndex _oDeviceProfileFavoriteIndex;

    T_e8_BTUsagePreference _e8DeviceUsagePreference;

    ::most_BTSet_fi_types::T_BTSetDateTimeStamp _oDevicePairedDateTimeStamp;

    bool _biAPoverBTSupport;

};

class T_BTSPPServiceConnectionStatusListItem {
public:

    /**
     * Default constructor
     */
    inline  T_BTSPPServiceConnectionStatusListItem ();

    /**
     * Copy constructor
     */
    inline  T_BTSPPServiceConnectionStatusListItem (const T_BTSPPServiceConnectionStatusListItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_BTSPPServiceConnectionStatusListItem (uint8 u8DeviceHandle_, const ::fi_basetypes_most::T_String& sUUID_, T_e8_BTConnectionStatus e8SPPConnectionStatus_, T_e8_BTDisconnectionReason e8SPPDisconnectionReason_, const ::fi_basetypes_most::T_String& sRFCommID_);

    /**
     * Destructor
     */
    inline  ~T_BTSPPServiceConnectionStatusListItem();

    /**
     * Assignment operator
     */
    inline T_BTSPPServiceConnectionStatusListItem& operator = (const T_BTSPPServiceConnectionStatusListItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_BTSPPServiceConnectionStatusListItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_BTSPPServiceConnectionStatusListItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_BTSPPServiceConnectionStatusListItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_BTSPPServiceConnectionStatusListItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the device, up to 10 devices that can be paired.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the device, up to 10 devices that can be paired.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    // API of field "sUUID"

    static const int kSUUID = 1;

    /**
     * Clears the field "sUUID".
     *
     * The field will be set to its default value. The hasSUUID()
     * method will return false.
     */
    inline void clearSUUID();

    /**
     * Checks whether the field "sUUID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSUUID()). Otherwise it will return false.
     */
    inline bool hasSUUID () const;

    /**
     * Returns the value of the member "sUUID".
     *
     * The UUID for the Device handle, for which the RFCommID is been requested.
     *
     * @return The value of the field "sUUID"
     */
    inline const ::fi_basetypes_most::T_String& getSUUID () const;

    /**
     * Retrieves the value of the field "sUUID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sUUID".
     */
    inline ::fi_basetypes_most::T_String& getSUUIDMutable ();

    /**
     * Sets the value of the member "sUUID".
     *
     * The UUID for the Device handle, for which the RFCommID is been requested.
     *
     * @param sUUID The value which will be set
     */
    inline void setSUUID (const ::fi_basetypes_most::T_String& sUUID_);

    // API of field "e8SPPConnectionStatus"

    static const int kE8SPPConnectionStatus = 2;

    /**
     * Clears the field "e8SPPConnectionStatus".
     *
     * The field will be set to its default value. The hasE8SPPConnectionStatus()
     * method will return false.
     */
    inline void clearE8SPPConnectionStatus();

    /**
     * Checks whether the field "e8SPPConnectionStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8SPPConnectionStatus()). Otherwise it will return false.
     */
    inline bool hasE8SPPConnectionStatus () const;

    /**
     * Returns the value of the member "e8SPPConnectionStatus".
     *
     * Connection status to SPP service running on the remote device.
     *
     * @return The value of the field "e8SPPConnectionStatus"
     */
    inline T_e8_BTConnectionStatus getE8SPPConnectionStatus () const;

    /**
     * Sets the value of the member "e8SPPConnectionStatus".
     *
     * Connection status to SPP service running on the remote device.
     *
     * @param e8SPPConnectionStatus The value which will be set
     */
    inline void setE8SPPConnectionStatus (T_e8_BTConnectionStatus e8SPPConnectionStatus_);

    // API of field "e8SPPDisconnectionReason"

    static const int kE8SPPDisconnectionReason = 3;

    /**
     * Clears the field "e8SPPDisconnectionReason".
     *
     * The field will be set to its default value. The hasE8SPPDisconnectionReason()
     * method will return false.
     */
    inline void clearE8SPPDisconnectionReason();

    /**
     * Checks whether the field "e8SPPDisconnectionReason" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8SPPDisconnectionReason()). Otherwise it will return false.
     */
    inline bool hasE8SPPDisconnectionReason () const;

    /**
     * Returns the value of the member "e8SPPDisconnectionReason".
     *
     * Reason why the connection to SPP service running on the remote device is disconnected.
     *
     * @return The value of the field "e8SPPDisconnectionReason"
     */
    inline T_e8_BTDisconnectionReason getE8SPPDisconnectionReason () const;

    /**
     * Sets the value of the member "e8SPPDisconnectionReason".
     *
     * Reason why the connection to SPP service running on the remote device is disconnected.
     *
     * @param e8SPPDisconnectionReason The value which will be set
     */
    inline void setE8SPPDisconnectionReason (T_e8_BTDisconnectionReason e8SPPDisconnectionReason_);

    // API of field "sRFCommID"

    static const int kSRFCommID = 4;

    /**
     * Clears the field "sRFCommID".
     *
     * The field will be set to its default value. The hasSRFCommID()
     * method will return false.
     */
    inline void clearSRFCommID();

    /**
     * Checks whether the field "sRFCommID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSRFCommID()). Otherwise it will return false.
     */
    inline bool hasSRFCommID () const;

    /**
     * Returns the value of the member "sRFCommID".
     *
     * The requested RFComm ID path.
     *
     * @return The value of the field "sRFCommID"
     */
    inline const ::fi_basetypes_most::T_String& getSRFCommID () const;

    /**
     * Retrieves the value of the field "sRFCommID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sRFCommID".
     */
    inline ::fi_basetypes_most::T_String& getSRFCommIDMutable ();

    /**
     * Sets the value of the member "sRFCommID".
     *
     * The requested RFComm ID path.
     *
     * @param sRFCommID The value which will be set
     */
    inline void setSRFCommID (const ::fi_basetypes_most::T_String& sRFCommID_);

    static const T_BTSPPServiceConnectionStatusListItem &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    inline void set_has_sUUID ();

    inline void clear_has_sUUID ();

    inline void set_has_e8SPPConnectionStatus ();

    inline void clear_has_e8SPPConnectionStatus ();

    inline void set_has_e8SPPDisconnectionReason ();

    inline void clear_has_e8SPPDisconnectionReason ();

    inline void set_has_sRFCommID ();

    inline void clear_has_sRFCommID ();

    uint32 _has_bits_[ (5 + 31) / 32];

    uint8 _u8DeviceHandle;

    ::fi_basetypes_most::T_String _sUUID;

    T_e8_BTConnectionStatus _e8SPPConnectionStatus;

    T_e8_BTDisconnectionReason _e8SPPDisconnectionReason;

    ::fi_basetypes_most::T_String _sRFCommID;

};

/**
 * Each visible device item consists of Bluetooth Device Address, Device Name,
 * Supported profiles by the visible device and Connection Status of the visible device.
 */
class T_BTSetVisibleDeviceItem {
public:

    /**
     * Default constructor
     */
    inline  T_BTSetVisibleDeviceItem ();

    /**
     * Copy constructor
     */
    inline  T_BTSetVisibleDeviceItem (const T_BTSetVisibleDeviceItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_BTSetVisibleDeviceItem (const ::fi_basetypes_most::T_String& sBluetoothDeviceAddress_, const ::fi_basetypes_most::T_String& sDeviceName_, const T_BTSetSupportedProfiles& oSupportedProfiles_, T_e8_BTSetVisibleDeviceConnectionStatus e8VisibleDeviceConnectionStatus_);

    /**
     * Destructor
     */
    inline  ~T_BTSetVisibleDeviceItem();

    /**
     * Assignment operator
     */
    inline T_BTSetVisibleDeviceItem& operator = (const T_BTSetVisibleDeviceItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_BTSetVisibleDeviceItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_BTSetVisibleDeviceItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_BTSetVisibleDeviceItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_BTSetVisibleDeviceItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sBluetoothDeviceAddress"

    static const int kSBluetoothDeviceAddress = 0;

    /**
     * Clears the field "sBluetoothDeviceAddress".
     *
     * The field will be set to its default value. The hasSBluetoothDeviceAddress()
     * method will return false.
     */
    inline void clearSBluetoothDeviceAddress();

    /**
     * Checks whether the field "sBluetoothDeviceAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSBluetoothDeviceAddress()). Otherwise it will return false.
     */
    inline bool hasSBluetoothDeviceAddress () const;

    /**
     * Returns the value of the member "sBluetoothDeviceAddress".
     *
     * Identifies the Bluetooth device address. It is represented as 12 hexidecimal characters.
     *
     * @return The value of the field "sBluetoothDeviceAddress"
     */
    inline const ::fi_basetypes_most::T_String& getSBluetoothDeviceAddress () const;

    /**
     * Retrieves the value of the field "sBluetoothDeviceAddress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sBluetoothDeviceAddress".
     */
    inline ::fi_basetypes_most::T_String& getSBluetoothDeviceAddressMutable ();

    /**
     * Sets the value of the member "sBluetoothDeviceAddress".
     *
     * Identifies the Bluetooth device address. It is represented as 12 hexidecimal characters.
     *
     * @param sBluetoothDeviceAddress The value which will be set
     */
    inline void setSBluetoothDeviceAddress (const ::fi_basetypes_most::T_String& sBluetoothDeviceAddress_);

    // API of field "sDeviceName"

    static const int kSDeviceName = 1;

    /**
     * Clears the field "sDeviceName".
     *
     * The field will be set to its default value. The hasSDeviceName()
     * method will return false.
     */
    inline void clearSDeviceName();

    /**
     * Checks whether the field "sDeviceName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDeviceName()). Otherwise it will return false.
     */
    inline bool hasSDeviceName () const;

    /**
     * Returns the value of the member "sDeviceName".
     *
     * Bluetooth friendly name of the visible/discoverable device.
     *
     * @return The value of the field "sDeviceName"
     */
    inline const ::fi_basetypes_most::T_String& getSDeviceName () const;

    /**
     * Retrieves the value of the field "sDeviceName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDeviceName".
     */
    inline ::fi_basetypes_most::T_String& getSDeviceNameMutable ();

    /**
     * Sets the value of the member "sDeviceName".
     *
     * Bluetooth friendly name of the visible/discoverable device.
     *
     * @param sDeviceName The value which will be set
     */
    inline void setSDeviceName (const ::fi_basetypes_most::T_String& sDeviceName_);

    // API of field "oSupportedProfiles"

    static const int kOSupportedProfiles = 2;

    /**
     * Clears the field "oSupportedProfiles".
     *
     * The field will be set to its default value. The hasOSupportedProfiles()
     * method will return false.
     */
    inline void clearOSupportedProfiles();

    /**
     * Checks whether the field "oSupportedProfiles" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOSupportedProfiles()). Otherwise it will return false.
     */
    inline bool hasOSupportedProfiles () const;

    /**
     * Returns the value of the member "oSupportedProfiles".
     *
     * Bluetooth supported profiles.
     *
     * @return The value of the field "oSupportedProfiles"
     */
    inline const T_BTSetSupportedProfiles& getOSupportedProfiles () const;

    /**
     * Retrieves the value of the field "oSupportedProfiles" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oSupportedProfiles".
     */
    inline T_BTSetSupportedProfiles& getOSupportedProfilesMutable ();

    /**
     * Sets the value of the member "oSupportedProfiles".
     *
     * Bluetooth supported profiles.
     *
     * @param oSupportedProfiles The value which will be set
     */
    inline void setOSupportedProfiles (const T_BTSetSupportedProfiles& oSupportedProfiles_);

    // API of field "e8VisibleDeviceConnectionStatus"

    static const int kE8VisibleDeviceConnectionStatus = 3;

    /**
     * Clears the field "e8VisibleDeviceConnectionStatus".
     *
     * The field will be set to its default value. The hasE8VisibleDeviceConnectionStatus()
     * method will return false.
     */
    inline void clearE8VisibleDeviceConnectionStatus();

    /**
     * Checks whether the field "e8VisibleDeviceConnectionStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8VisibleDeviceConnectionStatus()). Otherwise it will return false.
     */
    inline bool hasE8VisibleDeviceConnectionStatus () const;

    /**
     * Returns the value of the member "e8VisibleDeviceConnectionStatus".
     *
     * Provides the connection status of the discovered visible device.
     *
     * @return The value of the field "e8VisibleDeviceConnectionStatus"
     */
    inline T_e8_BTSetVisibleDeviceConnectionStatus getE8VisibleDeviceConnectionStatus () const;

    /**
     * Sets the value of the member "e8VisibleDeviceConnectionStatus".
     *
     * Provides the connection status of the discovered visible device.
     *
     * @param e8VisibleDeviceConnectionStatus The value which will be set
     */
    inline void setE8VisibleDeviceConnectionStatus (T_e8_BTSetVisibleDeviceConnectionStatus e8VisibleDeviceConnectionStatus_);

    static const T_BTSetVisibleDeviceItem &getDefaultInstance();

private:

    inline void set_has_sBluetoothDeviceAddress ();

    inline void clear_has_sBluetoothDeviceAddress ();

    inline void set_has_sDeviceName ();

    inline void clear_has_sDeviceName ();

    inline void set_has_oSupportedProfiles ();

    inline void clear_has_oSupportedProfiles ();

    inline void set_has_e8VisibleDeviceConnectionStatus ();

    inline void clear_has_e8VisibleDeviceConnectionStatus ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::fi_basetypes_most::T_String _sBluetoothDeviceAddress;

    ::fi_basetypes_most::T_String _sDeviceName;

    T_BTSetSupportedProfiles _oSupportedProfiles;

    T_e8_BTSetVisibleDeviceConnectionStatus _e8VisibleDeviceConnectionStatus;

};

/**
 * If the meaning of "T_BTSetSignalStrengthItem" isn't clear, then there should be a description here.
 */
class T_BTSetSignalStrengthItem {
public:

    /**
     * Default constructor
     */
    inline  T_BTSetSignalStrengthItem ();

    /**
     * Copy constructor
     */
    inline  T_BTSetSignalStrengthItem (const T_BTSetSignalStrengthItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_BTSetSignalStrengthItem (uint8 u8DeviceHandle_, int8 s8SignalStrength_);

    /**
     * Destructor
     */
    inline  ~T_BTSetSignalStrengthItem();

    /**
     * Assignment operator
     */
    inline T_BTSetSignalStrengthItem& operator = (const T_BTSetSignalStrengthItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_BTSetSignalStrengthItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_BTSetSignalStrengthItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_BTSetSignalStrengthItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_BTSetSignalStrengthItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * If the meaning of "u8DeviceHandle" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * If the meaning of "u8DeviceHandle" isn't clear, then there should be a description here.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    // API of field "s8SignalStrength"

    static const int kS8SignalStrength = 1;

    /**
     * Clears the field "s8SignalStrength".
     *
     * The field will be set to its default value. The hasS8SignalStrength()
     * method will return false.
     */
    inline void clearS8SignalStrength();

    /**
     * Checks whether the field "s8SignalStrength" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS8SignalStrength()). Otherwise it will return false.
     */
    inline bool hasS8SignalStrength () const;

    /**
     * Returns the value of the member "s8SignalStrength".
     *
     * If the meaning of "s8SignalStrength" isn't clear, then there should be a description here.
     *
     * @return The value of the field "s8SignalStrength"
     */
    inline int8 getS8SignalStrength () const;

    /**
     * Sets the value of the member "s8SignalStrength".
     *
     * If the meaning of "s8SignalStrength" isn't clear, then there should be a description here.
     *
     * @param s8SignalStrength The value which will be set
     */
    inline void setS8SignalStrength (int8 s8SignalStrength_);

    static const T_BTSetSignalStrengthItem &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    inline void set_has_s8SignalStrength ();

    inline void clear_has_s8SignalStrength ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8DeviceHandle;

    int8 _s8SignalStrength;

};

class T_BTSetDeviceListChangeExtended {
public:

    /**
     * Default constructor
     */
    inline  T_BTSetDeviceListChangeExtended ();

    /**
     * Copy constructor
     */
    inline  T_BTSetDeviceListChangeExtended (const T_BTSetDeviceListChangeExtended &rhs);

    /**
     * All fields constructor
     */
    inline  T_BTSetDeviceListChangeExtended (uint8 u8DeviceHandle_, ::most_BTSet_fi_types::T_e8_BTSetDeviceStatus e8DeviceStatus_, T_e8_BTSetDeviceDisconnectedReason e8DeviceDisconnectedReason_);

    /**
     * Destructor
     */
    inline  ~T_BTSetDeviceListChangeExtended();

    /**
     * Assignment operator
     */
    inline T_BTSetDeviceListChangeExtended& operator = (const T_BTSetDeviceListChangeExtended& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_BTSetDeviceListChangeExtended& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_BTSetDeviceListChangeExtended& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_BTSetDeviceListChangeExtended& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_BTSetDeviceListChangeExtended& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    // API of field "e8DeviceStatus"

    static const int kE8DeviceStatus = 1;

    /**
     * Clears the field "e8DeviceStatus".
     *
     * The field will be set to its default value. The hasE8DeviceStatus()
     * method will return false.
     */
    inline void clearE8DeviceStatus();

    /**
     * Checks whether the field "e8DeviceStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DeviceStatus()). Otherwise it will return false.
     */
    inline bool hasE8DeviceStatus () const;

    /**
     * Returns the value of the member "e8DeviceStatus".
     *
     * Identifies the changed status of a specific DeviceHandle.
     *
     * @return The value of the field "e8DeviceStatus"
     */
    inline ::most_BTSet_fi_types::T_e8_BTSetDeviceStatus getE8DeviceStatus () const;

    /**
     * Sets the value of the member "e8DeviceStatus".
     *
     * Identifies the changed status of a specific DeviceHandle.
     *
     * @param e8DeviceStatus The value which will be set
     */
    inline void setE8DeviceStatus (::most_BTSet_fi_types::T_e8_BTSetDeviceStatus e8DeviceStatus_);

    // API of field "e8DeviceDisconnectedReason"

    static const int kE8DeviceDisconnectedReason = 2;

    /**
     * Clears the field "e8DeviceDisconnectedReason".
     *
     * The field will be set to its default value. The hasE8DeviceDisconnectedReason()
     * method will return false.
     */
    inline void clearE8DeviceDisconnectedReason();

    /**
     * Checks whether the field "e8DeviceDisconnectedReason" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DeviceDisconnectedReason()). Otherwise it will return false.
     */
    inline bool hasE8DeviceDisconnectedReason () const;

    /**
     * Returns the value of the member "e8DeviceDisconnectedReason".
     *
     * Identifies the reason for the disconnected phone.
     *
     * @return The value of the field "e8DeviceDisconnectedReason"
     */
    inline T_e8_BTSetDeviceDisconnectedReason getE8DeviceDisconnectedReason () const;

    /**
     * Sets the value of the member "e8DeviceDisconnectedReason".
     *
     * Identifies the reason for the disconnected phone.
     *
     * @param e8DeviceDisconnectedReason The value which will be set
     */
    inline void setE8DeviceDisconnectedReason (T_e8_BTSetDeviceDisconnectedReason e8DeviceDisconnectedReason_);

    static const T_BTSetDeviceListChangeExtended &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    inline void set_has_e8DeviceStatus ();

    inline void clear_has_e8DeviceStatus ();

    inline void set_has_e8DeviceDisconnectedReason ();

    inline void clear_has_e8DeviceDisconnectedReason ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _u8DeviceHandle;

    ::most_BTSet_fi_types::T_e8_BTSetDeviceStatus _e8DeviceStatus;

    T_e8_BTSetDeviceDisconnectedReason _e8DeviceDisconnectedReason;

};

/**
 * If the meaning of "T_BTLimitationModeListItem" isn't clear, then there should be a description here.
 */
class T_BTLimitationModeListItem {
public:

    /**
     * Default constructor
     */
    inline  T_BTLimitationModeListItem ();

    /**
     * Copy constructor
     */
    inline  T_BTLimitationModeListItem (const T_BTLimitationModeListItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_BTLimitationModeListItem (const ::fi_basetypes_most::T_String& sBdAddress_, const ::fi_basetypes_most::T_String& sBdDeviceName_, T_e8_BTTechnology e8Technology_, T_e8_BTCommunicationChannel e8CommunicationChannel_, T_e8_BTLimitationActionState e8ActionState_);

    /**
     * Destructor
     */
    inline  ~T_BTLimitationModeListItem();

    /**
     * Assignment operator
     */
    inline T_BTLimitationModeListItem& operator = (const T_BTLimitationModeListItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_BTLimitationModeListItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_BTLimitationModeListItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_BTLimitationModeListItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_BTLimitationModeListItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sBdAddress"

    static const int kSBdAddress = 0;

    /**
     * Clears the field "sBdAddress".
     *
     * The field will be set to its default value. The hasSBdAddress()
     * method will return false.
     */
    inline void clearSBdAddress();

    /**
     * Checks whether the field "sBdAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSBdAddress()). Otherwise it will return false.
     */
    inline bool hasSBdAddress () const;

    /**
     * Returns the value of the member "sBdAddress".
     *
     * Bluetooth device address. In special cases (address not yet known) this parameter can be an empty string.
     *
     * @return The value of the field "sBdAddress"
     */
    inline const ::fi_basetypes_most::T_String& getSBdAddress () const;

    /**
     * Retrieves the value of the field "sBdAddress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sBdAddress".
     */
    inline ::fi_basetypes_most::T_String& getSBdAddressMutable ();

    /**
     * Sets the value of the member "sBdAddress".
     *
     * Bluetooth device address. In special cases (address not yet known) this parameter can be an empty string.
     *
     * @param sBdAddress The value which will be set
     */
    inline void setSBdAddress (const ::fi_basetypes_most::T_String& sBdAddress_);

    // API of field "sBdDeviceName"

    static const int kSBdDeviceName = 1;

    /**
     * Clears the field "sBdDeviceName".
     *
     * The field will be set to its default value. The hasSBdDeviceName()
     * method will return false.
     */
    inline void clearSBdDeviceName();

    /**
     * Checks whether the field "sBdDeviceName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSBdDeviceName()). Otherwise it will return false.
     */
    inline bool hasSBdDeviceName () const;

    /**
     * Returns the value of the member "sBdDeviceName".
     *
     * Bluetooth device name should be used when BT address is not available.
     * In cases (name not known, BT address is available) this parameter should be an empty string.
     *
     * @return The value of the field "sBdDeviceName"
     */
    inline const ::fi_basetypes_most::T_String& getSBdDeviceName () const;

    /**
     * Retrieves the value of the field "sBdDeviceName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sBdDeviceName".
     */
    inline ::fi_basetypes_most::T_String& getSBdDeviceNameMutable ();

    /**
     * Sets the value of the member "sBdDeviceName".
     *
     * Bluetooth device name should be used when BT address is not available.
     * In cases (name not known, BT address is available) this parameter should be an empty string.
     *
     * @param sBdDeviceName The value which will be set
     */
    inline void setSBdDeviceName (const ::fi_basetypes_most::T_String& sBdDeviceName_);

    // API of field "e8Technology"

    static const int kE8Technology = 2;

    /**
     * Clears the field "e8Technology".
     *
     * The field will be set to its default value. The hasE8Technology()
     * method will return false.
     */
    inline void clearE8Technology();

    /**
     * Checks whether the field "e8Technology" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Technology()). Otherwise it will return false.
     */
    inline bool hasE8Technology () const;

    /**
     * Returns the value of the member "e8Technology".
     *
     * Technology that specifies the limitation/restriction.
     *
     * @return The value of the field "e8Technology"
     */
    inline T_e8_BTTechnology getE8Technology () const;

    /**
     * Sets the value of the member "e8Technology".
     *
     * Technology that specifies the limitation/restriction.
     *
     * @param e8Technology The value which will be set
     */
    inline void setE8Technology (T_e8_BTTechnology e8Technology_);

    // API of field "e8CommunicationChannel"

    static const int kE8CommunicationChannel = 3;

    /**
     * Clears the field "e8CommunicationChannel".
     *
     * The field will be set to its default value. The hasE8CommunicationChannel()
     * method will return false.
     */
    inline void clearE8CommunicationChannel();

    /**
     * Checks whether the field "e8CommunicationChannel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8CommunicationChannel()). Otherwise it will return false.
     */
    inline bool hasE8CommunicationChannel () const;

    /**
     * Returns the value of the member "e8CommunicationChannel".
     *
     * Communication channel.
     *
     * @return The value of the field "e8CommunicationChannel"
     */
    inline T_e8_BTCommunicationChannel getE8CommunicationChannel () const;

    /**
     * Sets the value of the member "e8CommunicationChannel".
     *
     * Communication channel.
     *
     * @param e8CommunicationChannel The value which will be set
     */
    inline void setE8CommunicationChannel (T_e8_BTCommunicationChannel e8CommunicationChannel_);

    // API of field "e8ActionState"

    static const int kE8ActionState = 4;

    /**
     * Clears the field "e8ActionState".
     *
     * The field will be set to its default value. The hasE8ActionState()
     * method will return false.
     */
    inline void clearE8ActionState();

    /**
     * Checks whether the field "e8ActionState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ActionState()). Otherwise it will return false.
     */
    inline bool hasE8ActionState () const;

    /**
     * Returns the value of the member "e8ActionState".
     *
     * Action state of the limitation/restriction.
     *
     * @return The value of the field "e8ActionState"
     */
    inline T_e8_BTLimitationActionState getE8ActionState () const;

    /**
     * Sets the value of the member "e8ActionState".
     *
     * Action state of the limitation/restriction.
     *
     * @param e8ActionState The value which will be set
     */
    inline void setE8ActionState (T_e8_BTLimitationActionState e8ActionState_);

    static const T_BTLimitationModeListItem &getDefaultInstance();

private:

    inline void set_has_sBdAddress ();

    inline void clear_has_sBdAddress ();

    inline void set_has_sBdDeviceName ();

    inline void clear_has_sBdDeviceName ();

    inline void set_has_e8Technology ();

    inline void clear_has_e8Technology ();

    inline void set_has_e8CommunicationChannel ();

    inline void clear_has_e8CommunicationChannel ();

    inline void set_has_e8ActionState ();

    inline void clear_has_e8ActionState ();

    uint32 _has_bits_[ (5 + 31) / 32];

    ::fi_basetypes_most::T_String _sBdAddress;

    ::fi_basetypes_most::T_String _sBdDeviceName;

    T_e8_BTTechnology _e8Technology;

    T_e8_BTCommunicationChannel _e8CommunicationChannel;

    T_e8_BTLimitationActionState _e8ActionState;

};

/**
 * If the meaning of "T_BTLimitationMode" isn't clear, then there should be a description here.
 */
class T_BTLimitationMode {
public:

    /**
     * Default constructor
     */
    inline  T_BTLimitationMode ();

    /**
     * Copy constructor
     */
    inline  T_BTLimitationMode (const T_BTLimitationMode &rhs);

    /**
     * All fields constructor
     */
    inline  T_BTLimitationMode (const ::fi_basetypes_most::T_String& sBdAddress_, const ::fi_basetypes_most::T_String& sBdDeviceName_, T_e8_BTTechnology e8Technology_, T_e8_BTCommunicationChannel e8CommunicationChannel_, T_e8_BTLimitationAction e8Action_);

    /**
     * Destructor
     */
    inline  ~T_BTLimitationMode();

    /**
     * Assignment operator
     */
    inline T_BTLimitationMode& operator = (const T_BTLimitationMode& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_BTLimitationMode& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_BTLimitationMode& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_BTLimitationMode& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_BTLimitationMode& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sBdAddress"

    static const int kSBdAddress = 0;

    /**
     * Clears the field "sBdAddress".
     *
     * The field will be set to its default value. The hasSBdAddress()
     * method will return false.
     */
    inline void clearSBdAddress();

    /**
     * Checks whether the field "sBdAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSBdAddress()). Otherwise it will return false.
     */
    inline bool hasSBdAddress () const;

    /**
     * Returns the value of the member "sBdAddress".
     *
     * Bluetooth device address. In special cases (address not yet known) this parameter can be an empty string.
     *
     * @return The value of the field "sBdAddress"
     */
    inline const ::fi_basetypes_most::T_String& getSBdAddress () const;

    /**
     * Retrieves the value of the field "sBdAddress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sBdAddress".
     */
    inline ::fi_basetypes_most::T_String& getSBdAddressMutable ();

    /**
     * Sets the value of the member "sBdAddress".
     *
     * Bluetooth device address. In special cases (address not yet known) this parameter can be an empty string.
     *
     * @param sBdAddress The value which will be set
     */
    inline void setSBdAddress (const ::fi_basetypes_most::T_String& sBdAddress_);

    // API of field "sBdDeviceName"

    static const int kSBdDeviceName = 1;

    /**
     * Clears the field "sBdDeviceName".
     *
     * The field will be set to its default value. The hasSBdDeviceName()
     * method will return false.
     */
    inline void clearSBdDeviceName();

    /**
     * Checks whether the field "sBdDeviceName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSBdDeviceName()). Otherwise it will return false.
     */
    inline bool hasSBdDeviceName () const;

    /**
     * Returns the value of the member "sBdDeviceName".
     *
     * Bluetooth device name is an optional parameter and should be used when BT address is not available.
     * In cases (name not known, BT address is available) this parameter should be an empty string.
     *
     * @return The value of the field "sBdDeviceName"
     */
    inline const ::fi_basetypes_most::T_String& getSBdDeviceName () const;

    /**
     * Retrieves the value of the field "sBdDeviceName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sBdDeviceName".
     */
    inline ::fi_basetypes_most::T_String& getSBdDeviceNameMutable ();

    /**
     * Sets the value of the member "sBdDeviceName".
     *
     * Bluetooth device name is an optional parameter and should be used when BT address is not available.
     * In cases (name not known, BT address is available) this parameter should be an empty string.
     *
     * @param sBdDeviceName The value which will be set
     */
    inline void setSBdDeviceName (const ::fi_basetypes_most::T_String& sBdDeviceName_);

    // API of field "e8Technology"

    static const int kE8Technology = 2;

    /**
     * Clears the field "e8Technology".
     *
     * The field will be set to its default value. The hasE8Technology()
     * method will return false.
     */
    inline void clearE8Technology();

    /**
     * Checks whether the field "e8Technology" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Technology()). Otherwise it will return false.
     */
    inline bool hasE8Technology () const;

    /**
     * Returns the value of the member "e8Technology".
     *
     * Technology that specifies the limitation/restriction.
     *
     * @return The value of the field "e8Technology"
     */
    inline T_e8_BTTechnology getE8Technology () const;

    /**
     * Sets the value of the member "e8Technology".
     *
     * Technology that specifies the limitation/restriction.
     *
     * @param e8Technology The value which will be set
     */
    inline void setE8Technology (T_e8_BTTechnology e8Technology_);

    // API of field "e8CommunicationChannel"

    static const int kE8CommunicationChannel = 3;

    /**
     * Clears the field "e8CommunicationChannel".
     *
     * The field will be set to its default value. The hasE8CommunicationChannel()
     * method will return false.
     */
    inline void clearE8CommunicationChannel();

    /**
     * Checks whether the field "e8CommunicationChannel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8CommunicationChannel()). Otherwise it will return false.
     */
    inline bool hasE8CommunicationChannel () const;

    /**
     * Returns the value of the member "e8CommunicationChannel".
     *
     * Communication channel.
     *
     * @return The value of the field "e8CommunicationChannel"
     */
    inline T_e8_BTCommunicationChannel getE8CommunicationChannel () const;

    /**
     * Sets the value of the member "e8CommunicationChannel".
     *
     * Communication channel.
     *
     * @param e8CommunicationChannel The value which will be set
     */
    inline void setE8CommunicationChannel (T_e8_BTCommunicationChannel e8CommunicationChannel_);

    // API of field "e8Action"

    static const int kE8Action = 4;

    /**
     * Clears the field "e8Action".
     *
     * The field will be set to its default value. The hasE8Action()
     * method will return false.
     */
    inline void clearE8Action();

    /**
     * Checks whether the field "e8Action" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Action()). Otherwise it will return false.
     */
    inline bool hasE8Action () const;

    /**
     * Returns the value of the member "e8Action".
     *
     * Requested limitation/restriction action..
     *
     * @return The value of the field "e8Action"
     */
    inline T_e8_BTLimitationAction getE8Action () const;

    /**
     * Sets the value of the member "e8Action".
     *
     * Requested limitation/restriction action..
     *
     * @param e8Action The value which will be set
     */
    inline void setE8Action (T_e8_BTLimitationAction e8Action_);

    static const T_BTLimitationMode &getDefaultInstance();

private:

    inline void set_has_sBdAddress ();

    inline void clear_has_sBdAddress ();

    inline void set_has_sBdDeviceName ();

    inline void clear_has_sBdDeviceName ();

    inline void set_has_e8Technology ();

    inline void clear_has_e8Technology ();

    inline void set_has_e8CommunicationChannel ();

    inline void clear_has_e8CommunicationChannel ();

    inline void set_has_e8Action ();

    inline void clear_has_e8Action ();

    uint32 _has_bits_[ (5 + 31) / 32];

    ::fi_basetypes_most::T_String _sBdAddress;

    ::fi_basetypes_most::T_String _sBdDeviceName;

    T_e8_BTTechnology _e8Technology;

    T_e8_BTCommunicationChannel _e8CommunicationChannel;

    T_e8_BTLimitationAction _e8Action;

};

class T_BTProfilesUsageInfo {
public:

    /**
     * Default constructor
     */
    inline  T_BTProfilesUsageInfo ();

    /**
     * Copy constructor
     */
    inline  T_BTProfilesUsageInfo (const T_BTProfilesUsageInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_BTProfilesUsageInfo (T_e8_BTProfile e8BTProfile_, const ::fi_basetypes_most::T_String& sUUID_, T_e8_BTProfileUsageType e8BTProfileUsageType_, bool bInUse_);

    /**
     * Destructor
     */
    inline  ~T_BTProfilesUsageInfo();

    /**
     * Assignment operator
     */
    inline T_BTProfilesUsageInfo& operator = (const T_BTProfilesUsageInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_BTProfilesUsageInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_BTProfilesUsageInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_BTProfilesUsageInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_BTProfilesUsageInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8BTProfile"

    static const int kE8BTProfile = 0;

    /**
     * Clears the field "e8BTProfile".
     *
     * The field will be set to its default value. The hasE8BTProfile()
     * method will return false.
     */
    inline void clearE8BTProfile();

    /**
     * Checks whether the field "e8BTProfile" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8BTProfile()). Otherwise it will return false.
     */
    inline bool hasE8BTProfile () const;

    /**
     * Returns the value of the member "e8BTProfile".
     *
     * Profile that specifies the UsageType.
     *
     * @return The value of the field "e8BTProfile"
     */
    inline T_e8_BTProfile getE8BTProfile () const;

    /**
     * Sets the value of the member "e8BTProfile".
     *
     * Profile that specifies the UsageType.
     *
     * @param e8BTProfile The value which will be set
     */
    inline void setE8BTProfile (T_e8_BTProfile e8BTProfile_);

    // API of field "sUUID"

    static const int kSUUID = 1;

    /**
     * Clears the field "sUUID".
     *
     * The field will be set to its default value. The hasSUUID()
     * method will return false.
     */
    inline void clearSUUID();

    /**
     * Checks whether the field "sUUID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSUUID()). Otherwise it will return false.
     */
    inline bool hasSUUID () const;

    /**
     * Returns the value of the member "sUUID".
     *
     * UUID(Set if u8BTProfile is BT_PROFILE_SPP else NULL).
     *
     * @return The value of the field "sUUID"
     */
    inline const ::fi_basetypes_most::T_String& getSUUID () const;

    /**
     * Retrieves the value of the field "sUUID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sUUID".
     */
    inline ::fi_basetypes_most::T_String& getSUUIDMutable ();

    /**
     * Sets the value of the member "sUUID".
     *
     * UUID(Set if u8BTProfile is BT_PROFILE_SPP else NULL).
     *
     * @param sUUID The value which will be set
     */
    inline void setSUUID (const ::fi_basetypes_most::T_String& sUUID_);

    // API of field "e8BTProfileUsageType"

    static const int kE8BTProfileUsageType = 2;

    /**
     * Clears the field "e8BTProfileUsageType".
     *
     * The field will be set to its default value. The hasE8BTProfileUsageType()
     * method will return false.
     */
    inline void clearE8BTProfileUsageType();

    /**
     * Checks whether the field "e8BTProfileUsageType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8BTProfileUsageType()). Otherwise it will return false.
     */
    inline bool hasE8BTProfileUsageType () const;

    /**
     * Returns the value of the member "e8BTProfileUsageType".
     *
     * Profile usage type.
     *
     * @return The value of the field "e8BTProfileUsageType"
     */
    inline T_e8_BTProfileUsageType getE8BTProfileUsageType () const;

    /**
     * Sets the value of the member "e8BTProfileUsageType".
     *
     * Profile usage type.
     *
     * @param e8BTProfileUsageType The value which will be set
     */
    inline void setE8BTProfileUsageType (T_e8_BTProfileUsageType e8BTProfileUsageType_);

    // API of field "bInUse"

    static const int kBInUse = 3;

    /**
     * Clears the field "bInUse".
     *
     * The field will be set to its default value. The hasBInUse()
     * method will return false.
     */
    inline void clearBInUse();

    /**
     * Checks whether the field "bInUse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBInUse()). Otherwise it will return false.
     */
    inline bool hasBInUse () const;

    /**
     * Returns the value of the member "bInUse".
     *
     * Usage of the profile(1 = Profile in use, 0 = Profile is not in use).
     *
     * @return The value of the field "bInUse"
     */
    inline bool getBInUse () const;

    /**
     * Sets the value of the member "bInUse".
     *
     * Usage of the profile(1 = Profile in use, 0 = Profile is not in use).
     *
     * @param bInUse The value which will be set
     */
    inline void setBInUse (bool bInUse_);

    static const T_BTProfilesUsageInfo &getDefaultInstance();

private:

    inline void set_has_e8BTProfile ();

    inline void clear_has_e8BTProfile ();

    inline void set_has_sUUID ();

    inline void clear_has_sUUID ();

    inline void set_has_e8BTProfileUsageType ();

    inline void clear_has_e8BTProfileUsageType ();

    inline void set_has_bInUse ();

    inline void clear_has_bInUse ();

    uint32 _has_bits_[ (4 + 31) / 32];

    T_e8_BTProfile _e8BTProfile;

    ::fi_basetypes_most::T_String _sUUID;

    T_e8_BTProfileUsageType _e8BTProfileUsageType;

    bool _bInUse;

};

class T_BTProfilesUsageInfoList {
public:

    /**
     * Default constructor
     */
    inline  T_BTProfilesUsageInfoList ();

    /**
     * Copy constructor
     */
    inline  T_BTProfilesUsageInfoList (const T_BTProfilesUsageInfoList &rhs);

    /**
     * All fields constructor
     */
    inline  T_BTProfilesUsageInfoList (uint8 u8DeviceHandle_, const T_BTProfilesUsageInfo& oBTProfilesUsageInfo_);

    /**
     * Destructor
     */
    inline  ~T_BTProfilesUsageInfoList();

    /**
     * Assignment operator
     */
    inline T_BTProfilesUsageInfoList& operator = (const T_BTProfilesUsageInfoList& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_BTProfilesUsageInfoList& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_BTProfilesUsageInfoList& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_BTProfilesUsageInfoList& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_BTProfilesUsageInfoList& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the device.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the device.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    // API of field "oBTProfilesUsageInfo"

    static const int kOBTProfilesUsageInfo = 1;

    /**
     * Clears the field "oBTProfilesUsageInfo".
     *
     * The field will be set to its default value. The hasOBTProfilesUsageInfo()
     * method will return false.
     */
    inline void clearOBTProfilesUsageInfo();

    /**
     * Checks whether the field "oBTProfilesUsageInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOBTProfilesUsageInfo()). Otherwise it will return false.
     */
    inline bool hasOBTProfilesUsageInfo () const;

    /**
     * Returns the value of the member "oBTProfilesUsageInfo".
     *
     * List of profiles Usage.
     *
     * @return The value of the field "oBTProfilesUsageInfo"
     */
    inline const T_BTProfilesUsageInfo& getOBTProfilesUsageInfo () const;

    /**
     * Retrieves the value of the field "oBTProfilesUsageInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oBTProfilesUsageInfo".
     */
    inline T_BTProfilesUsageInfo& getOBTProfilesUsageInfoMutable ();

    /**
     * Sets the value of the member "oBTProfilesUsageInfo".
     *
     * List of profiles Usage.
     *
     * @param oBTProfilesUsageInfo The value which will be set
     */
    inline void setOBTProfilesUsageInfo (const T_BTProfilesUsageInfo& oBTProfilesUsageInfo_);

    static const T_BTProfilesUsageInfoList &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    inline void set_has_oBTProfilesUsageInfo ();

    inline void clear_has_oBTProfilesUsageInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8DeviceHandle;

    T_BTProfilesUsageInfo _oBTProfilesUsageInfo;

};

class T_BTConflictInfo {
public:

    /**
     * Default constructor
     */
    inline  T_BTConflictInfo ();

    /**
     * Copy constructor
     */
    inline  T_BTConflictInfo (const T_BTConflictInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_BTConflictInfo (T_e8_BTConflictType e8ConflictType_, uint8 u8DeviceHandle_, T_e8_BTProfile e8BTProfile_, const ::fi_basetypes_most::T_String& sUUID_, T_e8_BTProfileUsageType e8BTProfileUsageType_, T_e8_BTConflictState e8ConflictState_);

    /**
     * Destructor
     */
    inline  ~T_BTConflictInfo();

    /**
     * Assignment operator
     */
    inline T_BTConflictInfo& operator = (const T_BTConflictInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_BTConflictInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_BTConflictInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_BTConflictInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_BTConflictInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ConflictType"

    static const int kE8ConflictType = 0;

    /**
     * Clears the field "e8ConflictType".
     *
     * The field will be set to its default value. The hasE8ConflictType()
     * method will return false.
     */
    inline void clearE8ConflictType();

    /**
     * Checks whether the field "e8ConflictType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ConflictType()). Otherwise it will return false.
     */
    inline bool hasE8ConflictType () const;

    /**
     * Returns the value of the member "e8ConflictType".
     *
     * Provides the conflict type.
     *
     * @return The value of the field "e8ConflictType"
     */
    inline T_e8_BTConflictType getE8ConflictType () const;

    /**
     * Sets the value of the member "e8ConflictType".
     *
     * Provides the conflict type.
     *
     * @param e8ConflictType The value which will be set
     */
    inline void setE8ConflictType (T_e8_BTConflictType e8ConflictType_);

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 1;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the device(Set to 0 if the
     * ConflictType is MAX_NUM_OF_PAIRED_DEVICES or CHECK_MAX_NUM_OF_PAIRED_DEVICES).
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the device(Set to 0 if the
     * ConflictType is MAX_NUM_OF_PAIRED_DEVICES or CHECK_MAX_NUM_OF_PAIRED_DEVICES).
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    // API of field "e8BTProfile"

    static const int kE8BTProfile = 2;

    /**
     * Clears the field "e8BTProfile".
     *
     * The field will be set to its default value. The hasE8BTProfile()
     * method will return false.
     */
    inline void clearE8BTProfile();

    /**
     * Checks whether the field "e8BTProfile" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8BTProfile()). Otherwise it will return false.
     */
    inline bool hasE8BTProfile () const;

    /**
     * Returns the value of the member "e8BTProfile".
     *
     * Profile that specifies the UsageType(Set to BT_PROFILE_NONE if ConflictType is not PROFILE_IN_USE).
     *
     * @return The value of the field "e8BTProfile"
     */
    inline T_e8_BTProfile getE8BTProfile () const;

    /**
     * Sets the value of the member "e8BTProfile".
     *
     * Profile that specifies the UsageType(Set to BT_PROFILE_NONE if ConflictType is not PROFILE_IN_USE).
     *
     * @param e8BTProfile The value which will be set
     */
    inline void setE8BTProfile (T_e8_BTProfile e8BTProfile_);

    // API of field "sUUID"

    static const int kSUUID = 3;

    /**
     * Clears the field "sUUID".
     *
     * The field will be set to its default value. The hasSUUID()
     * method will return false.
     */
    inline void clearSUUID();

    /**
     * Checks whether the field "sUUID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSUUID()). Otherwise it will return false.
     */
    inline bool hasSUUID () const;

    /**
     * Returns the value of the member "sUUID".
     *
     * UUID(Set if u8BTProfile is BT_PROFILE_SPP else NULL).
     *
     * @return The value of the field "sUUID"
     */
    inline const ::fi_basetypes_most::T_String& getSUUID () const;

    /**
     * Retrieves the value of the field "sUUID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sUUID".
     */
    inline ::fi_basetypes_most::T_String& getSUUIDMutable ();

    /**
     * Sets the value of the member "sUUID".
     *
     * UUID(Set if u8BTProfile is BT_PROFILE_SPP else NULL).
     *
     * @param sUUID The value which will be set
     */
    inline void setSUUID (const ::fi_basetypes_most::T_String& sUUID_);

    // API of field "e8BTProfileUsageType"

    static const int kE8BTProfileUsageType = 4;

    /**
     * Clears the field "e8BTProfileUsageType".
     *
     * The field will be set to its default value. The hasE8BTProfileUsageType()
     * method will return false.
     */
    inline void clearE8BTProfileUsageType();

    /**
     * Checks whether the field "e8BTProfileUsageType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8BTProfileUsageType()). Otherwise it will return false.
     */
    inline bool hasE8BTProfileUsageType () const;

    /**
     * Returns the value of the member "e8BTProfileUsageType".
     *
     * Profile usage type(Set to PROFILE_USAGE_NONE if ConflictType is not PROFILE_IN_USE).
     *
     * @return The value of the field "e8BTProfileUsageType"
     */
    inline T_e8_BTProfileUsageType getE8BTProfileUsageType () const;

    /**
     * Sets the value of the member "e8BTProfileUsageType".
     *
     * Profile usage type(Set to PROFILE_USAGE_NONE if ConflictType is not PROFILE_IN_USE).
     *
     * @param e8BTProfileUsageType The value which will be set
     */
    inline void setE8BTProfileUsageType (T_e8_BTProfileUsageType e8BTProfileUsageType_);

    // API of field "e8ConflictState"

    static const int kE8ConflictState = 5;

    /**
     * Clears the field "e8ConflictState".
     *
     * The field will be set to its default value. The hasE8ConflictState()
     * method will return false.
     */
    inline void clearE8ConflictState();

    /**
     * Checks whether the field "e8ConflictState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ConflictState()). Otherwise it will return false.
     */
    inline bool hasE8ConflictState () const;

    /**
     * Returns the value of the member "e8ConflictState".
     *
     * conflict state.
     *
     * @return The value of the field "e8ConflictState"
     */
    inline T_e8_BTConflictState getE8ConflictState () const;

    /**
     * Sets the value of the member "e8ConflictState".
     *
     * conflict state.
     *
     * @param e8ConflictState The value which will be set
     */
    inline void setE8ConflictState (T_e8_BTConflictState e8ConflictState_);

    static const T_BTConflictInfo &getDefaultInstance();

private:

    inline void set_has_e8ConflictType ();

    inline void clear_has_e8ConflictType ();

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    inline void set_has_e8BTProfile ();

    inline void clear_has_e8BTProfile ();

    inline void set_has_sUUID ();

    inline void clear_has_sUUID ();

    inline void set_has_e8BTProfileUsageType ();

    inline void clear_has_e8BTProfileUsageType ();

    inline void set_has_e8ConflictState ();

    inline void clear_has_e8ConflictState ();

    uint32 _has_bits_[ (6 + 31) / 32];

    T_e8_BTConflictType _e8ConflictType;

    uint8 _u8DeviceHandle;

    T_e8_BTProfile _e8BTProfile;

    ::fi_basetypes_most::T_String _sUUID;

    T_e8_BTProfileUsageType _e8BTProfileUsageType;

    T_e8_BTConflictState _e8ConflictState;

};

inline  T_BTSetSupportedProfiles::T_BTSetSupportedProfiles ()  :
    _bSPPSupport (false),
    _bHFPSupport (false),
    _bA2DPSupport (false),
    _bAVRCPSupport (false),
    _bMAPSupport (false),
    _bDUNSupport (false),
    _bPANSupport (false),
    _bPBAPSuport (false),
    _bOPPSupport (false),
    _bDIPSupport (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_BTSetSupportedProfiles::T_BTSetSupportedProfiles (const T_BTSetSupportedProfiles &rhs)  :
    _bSPPSupport (false),
    _bHFPSupport (false),
    _bA2DPSupport (false),
    _bAVRCPSupport (false),
    _bMAPSupport (false),
    _bDUNSupport (false),
    _bPANSupport (false),
    _bPBAPSuport (false),
    _bOPPSupport (false),
    _bDIPSupport (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_BTSetSupportedProfiles::T_BTSetSupportedProfiles (bool bSPPSupport_, bool bHFPSupport_, bool bA2DPSupport_, bool bAVRCPSupport_, bool bMAPSupport_, bool bDUNSupport_, bool bPANSupport_, bool bPBAPSuport_, bool bOPPSupport_, bool bDIPSupport_)  :
    _bSPPSupport (bSPPSupport_),
    _bHFPSupport (bHFPSupport_),
    _bA2DPSupport (bA2DPSupport_),
    _bAVRCPSupport (bAVRCPSupport_),
    _bMAPSupport (bMAPSupport_),
    _bDUNSupport (bDUNSupport_),
    _bPANSupport (bPANSupport_),
    _bPBAPSuport (bPBAPSuport_),
    _bOPPSupport (bOPPSupport_),
    _bDIPSupport (bDIPSupport_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_BTSetSupportedProfiles::~T_BTSetSupportedProfiles() {
}

inline T_BTSetSupportedProfiles& T_BTSetSupportedProfiles::operator = (const T_BTSetSupportedProfiles& rhs) {
    if( this != &rhs ) {
        if (rhs.hasBSPPSupport()) {
            setBSPPSupport(rhs.getBSPPSupport());
        } else {
            clearBSPPSupport();
        }
        if (rhs.hasBHFPSupport()) {
            setBHFPSupport(rhs.getBHFPSupport());
        } else {
            clearBHFPSupport();
        }
        if (rhs.hasBA2DPSupport()) {
            setBA2DPSupport(rhs.getBA2DPSupport());
        } else {
            clearBA2DPSupport();
        }
        if (rhs.hasBAVRCPSupport()) {
            setBAVRCPSupport(rhs.getBAVRCPSupport());
        } else {
            clearBAVRCPSupport();
        }
        if (rhs.hasBMAPSupport()) {
            setBMAPSupport(rhs.getBMAPSupport());
        } else {
            clearBMAPSupport();
        }
        if (rhs.hasBDUNSupport()) {
            setBDUNSupport(rhs.getBDUNSupport());
        } else {
            clearBDUNSupport();
        }
        if (rhs.hasBPANSupport()) {
            setBPANSupport(rhs.getBPANSupport());
        } else {
            clearBPANSupport();
        }
        if (rhs.hasBPBAPSuport()) {
            setBPBAPSuport(rhs.getBPBAPSuport());
        } else {
            clearBPBAPSuport();
        }
        if (rhs.hasBOPPSupport()) {
            setBOPPSupport(rhs.getBOPPSupport());
        } else {
            clearBOPPSupport();
        }
        if (rhs.hasBDIPSupport()) {
            setBDIPSupport(rhs.getBDIPSupport());
        } else {
            clearBDIPSupport();
        }
    }
    return *this;
}

inline bool T_BTSetSupportedProfiles::operator == (const T_BTSetSupportedProfiles& rhs) const {
    return (((!hasBSPPSupport() && !rhs.hasBSPPSupport()) || getBSPPSupport() == rhs.getBSPPSupport()) &&
        ((!hasBHFPSupport() && !rhs.hasBHFPSupport()) || getBHFPSupport() == rhs.getBHFPSupport()) &&
        ((!hasBA2DPSupport() && !rhs.hasBA2DPSupport()) || getBA2DPSupport() == rhs.getBA2DPSupport()) &&
        ((!hasBAVRCPSupport() && !rhs.hasBAVRCPSupport()) || getBAVRCPSupport() == rhs.getBAVRCPSupport()) &&
        ((!hasBMAPSupport() && !rhs.hasBMAPSupport()) || getBMAPSupport() == rhs.getBMAPSupport()) &&
        ((!hasBDUNSupport() && !rhs.hasBDUNSupport()) || getBDUNSupport() == rhs.getBDUNSupport()) &&
        ((!hasBPANSupport() && !rhs.hasBPANSupport()) || getBPANSupport() == rhs.getBPANSupport()) &&
        ((!hasBPBAPSuport() && !rhs.hasBPBAPSuport()) || getBPBAPSuport() == rhs.getBPBAPSuport()) &&
        ((!hasBOPPSupport() && !rhs.hasBOPPSupport()) || getBOPPSupport() == rhs.getBOPPSupport()) &&
        ((!hasBDIPSupport() && !rhs.hasBDIPSupport()) || getBDIPSupport() == rhs.getBDIPSupport()));
}

inline bool T_BTSetSupportedProfiles::operator != (const T_BTSetSupportedProfiles& rhs) const {
    return ! (*this == rhs);
}

inline bool T_BTSetSupportedProfiles::operator < (const T_BTSetSupportedProfiles& rhs) const {
    if (hasBSPPSupport() || rhs.hasBSPPSupport()) {
        if (getBSPPSupport() < rhs.getBSPPSupport()) return true;
        if (getBSPPSupport() > rhs.getBSPPSupport()) return false;
    }
    if (hasBHFPSupport() || rhs.hasBHFPSupport()) {
        if (getBHFPSupport() < rhs.getBHFPSupport()) return true;
        if (getBHFPSupport() > rhs.getBHFPSupport()) return false;
    }
    if (hasBA2DPSupport() || rhs.hasBA2DPSupport()) {
        if (getBA2DPSupport() < rhs.getBA2DPSupport()) return true;
        if (getBA2DPSupport() > rhs.getBA2DPSupport()) return false;
    }
    if (hasBAVRCPSupport() || rhs.hasBAVRCPSupport()) {
        if (getBAVRCPSupport() < rhs.getBAVRCPSupport()) return true;
        if (getBAVRCPSupport() > rhs.getBAVRCPSupport()) return false;
    }
    if (hasBMAPSupport() || rhs.hasBMAPSupport()) {
        if (getBMAPSupport() < rhs.getBMAPSupport()) return true;
        if (getBMAPSupport() > rhs.getBMAPSupport()) return false;
    }
    if (hasBDUNSupport() || rhs.hasBDUNSupport()) {
        if (getBDUNSupport() < rhs.getBDUNSupport()) return true;
        if (getBDUNSupport() > rhs.getBDUNSupport()) return false;
    }
    if (hasBPANSupport() || rhs.hasBPANSupport()) {
        if (getBPANSupport() < rhs.getBPANSupport()) return true;
        if (getBPANSupport() > rhs.getBPANSupport()) return false;
    }
    if (hasBPBAPSuport() || rhs.hasBPBAPSuport()) {
        if (getBPBAPSuport() < rhs.getBPBAPSuport()) return true;
        if (getBPBAPSuport() > rhs.getBPBAPSuport()) return false;
    }
    if (hasBOPPSupport() || rhs.hasBOPPSupport()) {
        if (getBOPPSupport() < rhs.getBOPPSupport()) return true;
        if (getBOPPSupport() > rhs.getBOPPSupport()) return false;
    }
    if (hasBDIPSupport() || rhs.hasBDIPSupport()) {
        if (getBDIPSupport() < rhs.getBDIPSupport()) return true;
        if (getBDIPSupport() > rhs.getBDIPSupport()) return false;
    }
    return false;
}

inline bool T_BTSetSupportedProfiles::operator > (const T_BTSetSupportedProfiles& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_BTSetSupportedProfiles::clear() {
    clearBSPPSupport();
    clearBHFPSupport();
    clearBA2DPSupport();
    clearBAVRCPSupport();
    clearBMAPSupport();
    clearBDUNSupport();
    clearBPANSupport();
    clearBPBAPSuport();
    clearBOPPSupport();
    clearBDIPSupport();
}

inline void T_BTSetSupportedProfiles::clearBSPPSupport() {
    if (hasBSPPSupport()) {
         clear_has_bSPPSupport();
        _bSPPSupport = false;
     }
}

inline bool T_BTSetSupportedProfiles::hasBSPPSupport () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool T_BTSetSupportedProfiles::getBSPPSupport () const {
    return _bSPPSupport;
}

inline void T_BTSetSupportedProfiles::setBSPPSupport (bool bSPPSupport_) {
    set_has_bSPPSupport();
    this->_bSPPSupport = bSPPSupport_;
}

inline void T_BTSetSupportedProfiles::clearBHFPSupport() {
    if (hasBHFPSupport()) {
         clear_has_bHFPSupport();
        _bHFPSupport = false;
     }
}

inline bool T_BTSetSupportedProfiles::hasBHFPSupport () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool T_BTSetSupportedProfiles::getBHFPSupport () const {
    return _bHFPSupport;
}

inline void T_BTSetSupportedProfiles::setBHFPSupport (bool bHFPSupport_) {
    set_has_bHFPSupport();
    this->_bHFPSupport = bHFPSupport_;
}

inline void T_BTSetSupportedProfiles::clearBA2DPSupport() {
    if (hasBA2DPSupport()) {
         clear_has_bA2DPSupport();
        _bA2DPSupport = false;
     }
}

inline bool T_BTSetSupportedProfiles::hasBA2DPSupport () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline bool T_BTSetSupportedProfiles::getBA2DPSupport () const {
    return _bA2DPSupport;
}

inline void T_BTSetSupportedProfiles::setBA2DPSupport (bool bA2DPSupport_) {
    set_has_bA2DPSupport();
    this->_bA2DPSupport = bA2DPSupport_;
}

inline void T_BTSetSupportedProfiles::clearBAVRCPSupport() {
    if (hasBAVRCPSupport()) {
         clear_has_bAVRCPSupport();
        _bAVRCPSupport = false;
     }
}

inline bool T_BTSetSupportedProfiles::hasBAVRCPSupport () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline bool T_BTSetSupportedProfiles::getBAVRCPSupport () const {
    return _bAVRCPSupport;
}

inline void T_BTSetSupportedProfiles::setBAVRCPSupport (bool bAVRCPSupport_) {
    set_has_bAVRCPSupport();
    this->_bAVRCPSupport = bAVRCPSupport_;
}

inline void T_BTSetSupportedProfiles::clearBMAPSupport() {
    if (hasBMAPSupport()) {
         clear_has_bMAPSupport();
        _bMAPSupport = false;
     }
}

inline bool T_BTSetSupportedProfiles::hasBMAPSupport () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline bool T_BTSetSupportedProfiles::getBMAPSupport () const {
    return _bMAPSupport;
}

inline void T_BTSetSupportedProfiles::setBMAPSupport (bool bMAPSupport_) {
    set_has_bMAPSupport();
    this->_bMAPSupport = bMAPSupport_;
}

inline void T_BTSetSupportedProfiles::clearBDUNSupport() {
    if (hasBDUNSupport()) {
         clear_has_bDUNSupport();
        _bDUNSupport = false;
     }
}

inline bool T_BTSetSupportedProfiles::hasBDUNSupport () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline bool T_BTSetSupportedProfiles::getBDUNSupport () const {
    return _bDUNSupport;
}

inline void T_BTSetSupportedProfiles::setBDUNSupport (bool bDUNSupport_) {
    set_has_bDUNSupport();
    this->_bDUNSupport = bDUNSupport_;
}

inline void T_BTSetSupportedProfiles::clearBPANSupport() {
    if (hasBPANSupport()) {
         clear_has_bPANSupport();
        _bPANSupport = false;
     }
}

inline bool T_BTSetSupportedProfiles::hasBPANSupport () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline bool T_BTSetSupportedProfiles::getBPANSupport () const {
    return _bPANSupport;
}

inline void T_BTSetSupportedProfiles::setBPANSupport (bool bPANSupport_) {
    set_has_bPANSupport();
    this->_bPANSupport = bPANSupport_;
}

inline void T_BTSetSupportedProfiles::clearBPBAPSuport() {
    if (hasBPBAPSuport()) {
         clear_has_bPBAPSuport();
        _bPBAPSuport = false;
     }
}

inline bool T_BTSetSupportedProfiles::hasBPBAPSuport () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline bool T_BTSetSupportedProfiles::getBPBAPSuport () const {
    return _bPBAPSuport;
}

inline void T_BTSetSupportedProfiles::setBPBAPSuport (bool bPBAPSuport_) {
    set_has_bPBAPSuport();
    this->_bPBAPSuport = bPBAPSuport_;
}

inline void T_BTSetSupportedProfiles::clearBOPPSupport() {
    if (hasBOPPSupport()) {
         clear_has_bOPPSupport();
        _bOPPSupport = false;
     }
}

inline bool T_BTSetSupportedProfiles::hasBOPPSupport () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline bool T_BTSetSupportedProfiles::getBOPPSupport () const {
    return _bOPPSupport;
}

inline void T_BTSetSupportedProfiles::setBOPPSupport (bool bOPPSupport_) {
    set_has_bOPPSupport();
    this->_bOPPSupport = bOPPSupport_;
}

inline void T_BTSetSupportedProfiles::clearBDIPSupport() {
    if (hasBDIPSupport()) {
         clear_has_bDIPSupport();
        _bDIPSupport = false;
     }
}

inline bool T_BTSetSupportedProfiles::hasBDIPSupport () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline bool T_BTSetSupportedProfiles::getBDIPSupport () const {
    return _bDIPSupport;
}

inline void T_BTSetSupportedProfiles::setBDIPSupport (bool bDIPSupport_) {
    set_has_bDIPSupport();
    this->_bDIPSupport = bDIPSupport_;
}

inline void T_BTSetSupportedProfiles::set_has_bSPPSupport () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_BTSetSupportedProfiles::clear_has_bSPPSupport () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_BTSetSupportedProfiles::set_has_bHFPSupport () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_BTSetSupportedProfiles::clear_has_bHFPSupport () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_BTSetSupportedProfiles::set_has_bA2DPSupport () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_BTSetSupportedProfiles::clear_has_bA2DPSupport () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_BTSetSupportedProfiles::set_has_bAVRCPSupport () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_BTSetSupportedProfiles::clear_has_bAVRCPSupport () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_BTSetSupportedProfiles::set_has_bMAPSupport () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_BTSetSupportedProfiles::clear_has_bMAPSupport () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_BTSetSupportedProfiles::set_has_bDUNSupport () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_BTSetSupportedProfiles::clear_has_bDUNSupport () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_BTSetSupportedProfiles::set_has_bPANSupport () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_BTSetSupportedProfiles::clear_has_bPANSupport () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_BTSetSupportedProfiles::set_has_bPBAPSuport () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_BTSetSupportedProfiles::clear_has_bPBAPSuport () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_BTSetSupportedProfiles::set_has_bOPPSupport () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_BTSetSupportedProfiles::clear_has_bOPPSupport () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_BTSetSupportedProfiles::set_has_bDIPSupport () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_BTSetSupportedProfiles::clear_has_bDIPSupport () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline  T_BTSetDeviceIdentification::T_BTSetDeviceIdentification ()  :
    _u16VendorIDSource (0u),
    _u16VendorID (0u),
    _u16ProductID (0u),
    _u16ProductVersion (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_BTSetDeviceIdentification::T_BTSetDeviceIdentification (const T_BTSetDeviceIdentification &rhs)  :
    _u16VendorIDSource (0u),
    _u16VendorID (0u),
    _u16ProductID (0u),
    _u16ProductVersion (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_BTSetDeviceIdentification::T_BTSetDeviceIdentification (uint16 u16VendorIDSource_, uint16 u16VendorID_, uint16 u16ProductID_, uint16 u16ProductVersion_)  :
    _u16VendorIDSource (u16VendorIDSource_),
    _u16VendorID (u16VendorID_),
    _u16ProductID (u16ProductID_),
    _u16ProductVersion (u16ProductVersion_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_BTSetDeviceIdentification::~T_BTSetDeviceIdentification() {
}

inline T_BTSetDeviceIdentification& T_BTSetDeviceIdentification::operator = (const T_BTSetDeviceIdentification& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU16VendorIDSource()) {
            setU16VendorIDSource(rhs.getU16VendorIDSource());
        } else {
            clearU16VendorIDSource();
        }
        if (rhs.hasU16VendorID()) {
            setU16VendorID(rhs.getU16VendorID());
        } else {
            clearU16VendorID();
        }
        if (rhs.hasU16ProductID()) {
            setU16ProductID(rhs.getU16ProductID());
        } else {
            clearU16ProductID();
        }
        if (rhs.hasU16ProductVersion()) {
            setU16ProductVersion(rhs.getU16ProductVersion());
        } else {
            clearU16ProductVersion();
        }
    }
    return *this;
}

inline bool T_BTSetDeviceIdentification::operator == (const T_BTSetDeviceIdentification& rhs) const {
    return (((!hasU16VendorIDSource() && !rhs.hasU16VendorIDSource()) || getU16VendorIDSource() == rhs.getU16VendorIDSource()) &&
        ((!hasU16VendorID() && !rhs.hasU16VendorID()) || getU16VendorID() == rhs.getU16VendorID()) &&
        ((!hasU16ProductID() && !rhs.hasU16ProductID()) || getU16ProductID() == rhs.getU16ProductID()) &&
        ((!hasU16ProductVersion() && !rhs.hasU16ProductVersion()) || getU16ProductVersion() == rhs.getU16ProductVersion()));
}

inline bool T_BTSetDeviceIdentification::operator != (const T_BTSetDeviceIdentification& rhs) const {
    return ! (*this == rhs);
}

inline bool T_BTSetDeviceIdentification::operator < (const T_BTSetDeviceIdentification& rhs) const {
    if (hasU16VendorIDSource() || rhs.hasU16VendorIDSource()) {
        if (getU16VendorIDSource() < rhs.getU16VendorIDSource()) return true;
        if (getU16VendorIDSource() > rhs.getU16VendorIDSource()) return false;
    }
    if (hasU16VendorID() || rhs.hasU16VendorID()) {
        if (getU16VendorID() < rhs.getU16VendorID()) return true;
        if (getU16VendorID() > rhs.getU16VendorID()) return false;
    }
    if (hasU16ProductID() || rhs.hasU16ProductID()) {
        if (getU16ProductID() < rhs.getU16ProductID()) return true;
        if (getU16ProductID() > rhs.getU16ProductID()) return false;
    }
    if (hasU16ProductVersion() || rhs.hasU16ProductVersion()) {
        if (getU16ProductVersion() < rhs.getU16ProductVersion()) return true;
        if (getU16ProductVersion() > rhs.getU16ProductVersion()) return false;
    }
    return false;
}

inline bool T_BTSetDeviceIdentification::operator > (const T_BTSetDeviceIdentification& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_BTSetDeviceIdentification::clear() {
    clearU16VendorIDSource();
    clearU16VendorID();
    clearU16ProductID();
    clearU16ProductVersion();
}

inline void T_BTSetDeviceIdentification::clearU16VendorIDSource() {
    if (hasU16VendorIDSource()) {
         clear_has_u16VendorIDSource();
        _u16VendorIDSource = 0u;
     }
}

inline bool T_BTSetDeviceIdentification::hasU16VendorIDSource () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 T_BTSetDeviceIdentification::getU16VendorIDSource () const {
    return _u16VendorIDSource;
}

inline void T_BTSetDeviceIdentification::setU16VendorIDSource (uint16 u16VendorIDSource_) {
    set_has_u16VendorIDSource();
    this->_u16VendorIDSource = u16VendorIDSource_;
}

inline void T_BTSetDeviceIdentification::clearU16VendorID() {
    if (hasU16VendorID()) {
         clear_has_u16VendorID();
        _u16VendorID = 0u;
     }
}

inline bool T_BTSetDeviceIdentification::hasU16VendorID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 T_BTSetDeviceIdentification::getU16VendorID () const {
    return _u16VendorID;
}

inline void T_BTSetDeviceIdentification::setU16VendorID (uint16 u16VendorID_) {
    set_has_u16VendorID();
    this->_u16VendorID = u16VendorID_;
}

inline void T_BTSetDeviceIdentification::clearU16ProductID() {
    if (hasU16ProductID()) {
         clear_has_u16ProductID();
        _u16ProductID = 0u;
     }
}

inline bool T_BTSetDeviceIdentification::hasU16ProductID () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 T_BTSetDeviceIdentification::getU16ProductID () const {
    return _u16ProductID;
}

inline void T_BTSetDeviceIdentification::setU16ProductID (uint16 u16ProductID_) {
    set_has_u16ProductID();
    this->_u16ProductID = u16ProductID_;
}

inline void T_BTSetDeviceIdentification::clearU16ProductVersion() {
    if (hasU16ProductVersion()) {
         clear_has_u16ProductVersion();
        _u16ProductVersion = 0u;
     }
}

inline bool T_BTSetDeviceIdentification::hasU16ProductVersion () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 T_BTSetDeviceIdentification::getU16ProductVersion () const {
    return _u16ProductVersion;
}

inline void T_BTSetDeviceIdentification::setU16ProductVersion (uint16 u16ProductVersion_) {
    set_has_u16ProductVersion();
    this->_u16ProductVersion = u16ProductVersion_;
}

inline void T_BTSetDeviceIdentification::set_has_u16VendorIDSource () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_BTSetDeviceIdentification::clear_has_u16VendorIDSource () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_BTSetDeviceIdentification::set_has_u16VendorID () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_BTSetDeviceIdentification::clear_has_u16VendorID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_BTSetDeviceIdentification::set_has_u16ProductID () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_BTSetDeviceIdentification::clear_has_u16ProductID () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_BTSetDeviceIdentification::set_has_u16ProductVersion () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_BTSetDeviceIdentification::clear_has_u16ProductVersion () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  T_BTServiceType::T_BTServiceType ()  :
    _bHFP (false),
    _bAVP (false),
    _bPAN (false),
    _bPBAP (false),
    _bMAP (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_BTServiceType::T_BTServiceType (const T_BTServiceType &rhs)  :
    _bHFP (false),
    _bAVP (false),
    _bPAN (false),
    _bPBAP (false),
    _bMAP (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_BTServiceType::T_BTServiceType (bool bHFP_, bool bAVP_, bool bPAN_, bool bPBAP_, bool bMAP_)  :
    _bHFP (bHFP_),
    _bAVP (bAVP_),
    _bPAN (bPAN_),
    _bPBAP (bPBAP_),
    _bMAP (bMAP_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_BTServiceType::~T_BTServiceType() {
}

inline T_BTServiceType& T_BTServiceType::operator = (const T_BTServiceType& rhs) {
    if( this != &rhs ) {
        if (rhs.hasBHFP()) {
            setBHFP(rhs.getBHFP());
        } else {
            clearBHFP();
        }
        if (rhs.hasBAVP()) {
            setBAVP(rhs.getBAVP());
        } else {
            clearBAVP();
        }
        if (rhs.hasBPAN()) {
            setBPAN(rhs.getBPAN());
        } else {
            clearBPAN();
        }
        if (rhs.hasBPBAP()) {
            setBPBAP(rhs.getBPBAP());
        } else {
            clearBPBAP();
        }
        if (rhs.hasBMAP()) {
            setBMAP(rhs.getBMAP());
        } else {
            clearBMAP();
        }
    }
    return *this;
}

inline bool T_BTServiceType::operator == (const T_BTServiceType& rhs) const {
    return (((!hasBHFP() && !rhs.hasBHFP()) || getBHFP() == rhs.getBHFP()) &&
        ((!hasBAVP() && !rhs.hasBAVP()) || getBAVP() == rhs.getBAVP()) &&
        ((!hasBPAN() && !rhs.hasBPAN()) || getBPAN() == rhs.getBPAN()) &&
        ((!hasBPBAP() && !rhs.hasBPBAP()) || getBPBAP() == rhs.getBPBAP()) &&
        ((!hasBMAP() && !rhs.hasBMAP()) || getBMAP() == rhs.getBMAP()));
}

inline bool T_BTServiceType::operator != (const T_BTServiceType& rhs) const {
    return ! (*this == rhs);
}

inline bool T_BTServiceType::operator < (const T_BTServiceType& rhs) const {
    if (hasBHFP() || rhs.hasBHFP()) {
        if (getBHFP() < rhs.getBHFP()) return true;
        if (getBHFP() > rhs.getBHFP()) return false;
    }
    if (hasBAVP() || rhs.hasBAVP()) {
        if (getBAVP() < rhs.getBAVP()) return true;
        if (getBAVP() > rhs.getBAVP()) return false;
    }
    if (hasBPAN() || rhs.hasBPAN()) {
        if (getBPAN() < rhs.getBPAN()) return true;
        if (getBPAN() > rhs.getBPAN()) return false;
    }
    if (hasBPBAP() || rhs.hasBPBAP()) {
        if (getBPBAP() < rhs.getBPBAP()) return true;
        if (getBPBAP() > rhs.getBPBAP()) return false;
    }
    if (hasBMAP() || rhs.hasBMAP()) {
        if (getBMAP() < rhs.getBMAP()) return true;
        if (getBMAP() > rhs.getBMAP()) return false;
    }
    return false;
}

inline bool T_BTServiceType::operator > (const T_BTServiceType& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_BTServiceType::clear() {
    clearBHFP();
    clearBAVP();
    clearBPAN();
    clearBPBAP();
    clearBMAP();
}

inline void T_BTServiceType::clearBHFP() {
    if (hasBHFP()) {
         clear_has_bHFP();
        _bHFP = false;
     }
}

inline bool T_BTServiceType::hasBHFP () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool T_BTServiceType::getBHFP () const {
    return _bHFP;
}

inline void T_BTServiceType::setBHFP (bool bHFP_) {
    set_has_bHFP();
    this->_bHFP = bHFP_;
}

inline void T_BTServiceType::clearBAVP() {
    if (hasBAVP()) {
         clear_has_bAVP();
        _bAVP = false;
     }
}

inline bool T_BTServiceType::hasBAVP () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool T_BTServiceType::getBAVP () const {
    return _bAVP;
}

inline void T_BTServiceType::setBAVP (bool bAVP_) {
    set_has_bAVP();
    this->_bAVP = bAVP_;
}

inline void T_BTServiceType::clearBPAN() {
    if (hasBPAN()) {
         clear_has_bPAN();
        _bPAN = false;
     }
}

inline bool T_BTServiceType::hasBPAN () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline bool T_BTServiceType::getBPAN () const {
    return _bPAN;
}

inline void T_BTServiceType::setBPAN (bool bPAN_) {
    set_has_bPAN();
    this->_bPAN = bPAN_;
}

inline void T_BTServiceType::clearBPBAP() {
    if (hasBPBAP()) {
         clear_has_bPBAP();
        _bPBAP = false;
     }
}

inline bool T_BTServiceType::hasBPBAP () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline bool T_BTServiceType::getBPBAP () const {
    return _bPBAP;
}

inline void T_BTServiceType::setBPBAP (bool bPBAP_) {
    set_has_bPBAP();
    this->_bPBAP = bPBAP_;
}

inline void T_BTServiceType::clearBMAP() {
    if (hasBMAP()) {
         clear_has_bMAP();
        _bMAP = false;
     }
}

inline bool T_BTServiceType::hasBMAP () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline bool T_BTServiceType::getBMAP () const {
    return _bMAP;
}

inline void T_BTServiceType::setBMAP (bool bMAP_) {
    set_has_bMAP();
    this->_bMAP = bMAP_;
}

inline void T_BTServiceType::set_has_bHFP () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_BTServiceType::clear_has_bHFP () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_BTServiceType::set_has_bAVP () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_BTServiceType::clear_has_bAVP () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_BTServiceType::set_has_bPAN () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_BTServiceType::clear_has_bPAN () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_BTServiceType::set_has_bPBAP () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_BTServiceType::clear_has_bPBAP () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_BTServiceType::set_has_bMAP () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_BTServiceType::clear_has_bMAP () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  T_BTProfileConnectionStatus::T_BTProfileConnectionStatus ()  :
    _e8HFP (::most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus__e8STATUS_NOT_CONNECT),
    _e8AVP (::most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus__e8STATUS_NOT_CONNECT),
    _e8PAN (::most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus__e8STATUS_NOT_CONNECT),
    _e8PBAP (::most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus__e8STATUS_NOT_CONNECT),
    _e8MAP (::most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus__e8STATUS_NOT_CONNECT)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_BTProfileConnectionStatus::T_BTProfileConnectionStatus (const T_BTProfileConnectionStatus &rhs)  :
    _e8HFP (::most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus__e8STATUS_NOT_CONNECT),
    _e8AVP (::most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus__e8STATUS_NOT_CONNECT),
    _e8PAN (::most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus__e8STATUS_NOT_CONNECT),
    _e8PBAP (::most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus__e8STATUS_NOT_CONNECT),
    _e8MAP (::most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus__e8STATUS_NOT_CONNECT)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_BTProfileConnectionStatus::T_BTProfileConnectionStatus (T_e8_BTConnectionStatus e8HFP_, T_e8_BTConnectionStatus e8AVP_, T_e8_BTConnectionStatus e8PAN_, T_e8_BTConnectionStatus e8PBAP_, T_e8_BTConnectionStatus e8MAP_)  :
    _e8HFP (e8HFP_),
    _e8AVP (e8AVP_),
    _e8PAN (e8PAN_),
    _e8PBAP (e8PBAP_),
    _e8MAP (e8MAP_)
{
    #ifndef NDEBUG
    if (!(T_e8_BTConnectionStatus_IsValid(e8HFP_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8HFP_, "T_e8_BTConnectionStatus", "e8HFP", "T_BTProfileConnectionStatus");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_BTConnectionStatus_IsValid(e8AVP_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8AVP_, "T_e8_BTConnectionStatus", "e8AVP", "T_BTProfileConnectionStatus");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_BTConnectionStatus_IsValid(e8PAN_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8PAN_, "T_e8_BTConnectionStatus", "e8PAN", "T_BTProfileConnectionStatus");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_BTConnectionStatus_IsValid(e8PBAP_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8PBAP_, "T_e8_BTConnectionStatus", "e8PBAP", "T_BTProfileConnectionStatus");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_BTConnectionStatus_IsValid(e8MAP_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8MAP_, "T_e8_BTConnectionStatus", "e8MAP", "T_BTProfileConnectionStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_BTProfileConnectionStatus::~T_BTProfileConnectionStatus() {
}

inline T_BTProfileConnectionStatus& T_BTProfileConnectionStatus::operator = (const T_BTProfileConnectionStatus& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE8HFP()) {
            setE8HFP(rhs.getE8HFP());
        } else {
            clearE8HFP();
        }
        if (rhs.hasE8AVP()) {
            setE8AVP(rhs.getE8AVP());
        } else {
            clearE8AVP();
        }
        if (rhs.hasE8PAN()) {
            setE8PAN(rhs.getE8PAN());
        } else {
            clearE8PAN();
        }
        if (rhs.hasE8PBAP()) {
            setE8PBAP(rhs.getE8PBAP());
        } else {
            clearE8PBAP();
        }
        if (rhs.hasE8MAP()) {
            setE8MAP(rhs.getE8MAP());
        } else {
            clearE8MAP();
        }
    }
    return *this;
}

inline bool T_BTProfileConnectionStatus::operator == (const T_BTProfileConnectionStatus& rhs) const {
    return (((!hasE8HFP() && !rhs.hasE8HFP()) || getE8HFP() == rhs.getE8HFP()) &&
        ((!hasE8AVP() && !rhs.hasE8AVP()) || getE8AVP() == rhs.getE8AVP()) &&
        ((!hasE8PAN() && !rhs.hasE8PAN()) || getE8PAN() == rhs.getE8PAN()) &&
        ((!hasE8PBAP() && !rhs.hasE8PBAP()) || getE8PBAP() == rhs.getE8PBAP()) &&
        ((!hasE8MAP() && !rhs.hasE8MAP()) || getE8MAP() == rhs.getE8MAP()));
}

inline bool T_BTProfileConnectionStatus::operator != (const T_BTProfileConnectionStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool T_BTProfileConnectionStatus::operator < (const T_BTProfileConnectionStatus& rhs) const {
    if (hasE8HFP() || rhs.hasE8HFP()) {
        if ((uint32)getE8HFP() < (uint32)rhs.getE8HFP()) return true;
        if ((uint32)getE8HFP() > (uint32)rhs.getE8HFP()) return false;
    }
    if (hasE8AVP() || rhs.hasE8AVP()) {
        if ((uint32)getE8AVP() < (uint32)rhs.getE8AVP()) return true;
        if ((uint32)getE8AVP() > (uint32)rhs.getE8AVP()) return false;
    }
    if (hasE8PAN() || rhs.hasE8PAN()) {
        if ((uint32)getE8PAN() < (uint32)rhs.getE8PAN()) return true;
        if ((uint32)getE8PAN() > (uint32)rhs.getE8PAN()) return false;
    }
    if (hasE8PBAP() || rhs.hasE8PBAP()) {
        if ((uint32)getE8PBAP() < (uint32)rhs.getE8PBAP()) return true;
        if ((uint32)getE8PBAP() > (uint32)rhs.getE8PBAP()) return false;
    }
    if (hasE8MAP() || rhs.hasE8MAP()) {
        if ((uint32)getE8MAP() < (uint32)rhs.getE8MAP()) return true;
        if ((uint32)getE8MAP() > (uint32)rhs.getE8MAP()) return false;
    }
    return false;
}

inline bool T_BTProfileConnectionStatus::operator > (const T_BTProfileConnectionStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_BTProfileConnectionStatus::clear() {
    clearE8HFP();
    clearE8AVP();
    clearE8PAN();
    clearE8PBAP();
    clearE8MAP();
}

inline void T_BTProfileConnectionStatus::clearE8HFP() {
    if (hasE8HFP()) {
         clear_has_e8HFP();
        _e8HFP = ::most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus__e8STATUS_NOT_CONNECT;
     }
}

inline bool T_BTProfileConnectionStatus::hasE8HFP () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_BTConnectionStatus T_BTProfileConnectionStatus::getE8HFP () const {
    return _e8HFP;
}

inline void T_BTProfileConnectionStatus::setE8HFP (T_e8_BTConnectionStatus e8HFP_) {
    #ifndef NDEBUG
    if (!(T_e8_BTConnectionStatus_IsValid(e8HFP_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8HFP_, "T_e8_BTConnectionStatus", "e8HFP", "T_BTProfileConnectionStatus");
    }
    #endif
    set_has_e8HFP();
    this->_e8HFP = e8HFP_;
}

inline void T_BTProfileConnectionStatus::clearE8AVP() {
    if (hasE8AVP()) {
         clear_has_e8AVP();
        _e8AVP = ::most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus__e8STATUS_NOT_CONNECT;
     }
}

inline bool T_BTProfileConnectionStatus::hasE8AVP () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_BTConnectionStatus T_BTProfileConnectionStatus::getE8AVP () const {
    return _e8AVP;
}

inline void T_BTProfileConnectionStatus::setE8AVP (T_e8_BTConnectionStatus e8AVP_) {
    #ifndef NDEBUG
    if (!(T_e8_BTConnectionStatus_IsValid(e8AVP_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8AVP_, "T_e8_BTConnectionStatus", "e8AVP", "T_BTProfileConnectionStatus");
    }
    #endif
    set_has_e8AVP();
    this->_e8AVP = e8AVP_;
}

inline void T_BTProfileConnectionStatus::clearE8PAN() {
    if (hasE8PAN()) {
         clear_has_e8PAN();
        _e8PAN = ::most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus__e8STATUS_NOT_CONNECT;
     }
}

inline bool T_BTProfileConnectionStatus::hasE8PAN () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_BTConnectionStatus T_BTProfileConnectionStatus::getE8PAN () const {
    return _e8PAN;
}

inline void T_BTProfileConnectionStatus::setE8PAN (T_e8_BTConnectionStatus e8PAN_) {
    #ifndef NDEBUG
    if (!(T_e8_BTConnectionStatus_IsValid(e8PAN_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8PAN_, "T_e8_BTConnectionStatus", "e8PAN", "T_BTProfileConnectionStatus");
    }
    #endif
    set_has_e8PAN();
    this->_e8PAN = e8PAN_;
}

inline void T_BTProfileConnectionStatus::clearE8PBAP() {
    if (hasE8PBAP()) {
         clear_has_e8PBAP();
        _e8PBAP = ::most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus__e8STATUS_NOT_CONNECT;
     }
}

inline bool T_BTProfileConnectionStatus::hasE8PBAP () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline T_e8_BTConnectionStatus T_BTProfileConnectionStatus::getE8PBAP () const {
    return _e8PBAP;
}

inline void T_BTProfileConnectionStatus::setE8PBAP (T_e8_BTConnectionStatus e8PBAP_) {
    #ifndef NDEBUG
    if (!(T_e8_BTConnectionStatus_IsValid(e8PBAP_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8PBAP_, "T_e8_BTConnectionStatus", "e8PBAP", "T_BTProfileConnectionStatus");
    }
    #endif
    set_has_e8PBAP();
    this->_e8PBAP = e8PBAP_;
}

inline void T_BTProfileConnectionStatus::clearE8MAP() {
    if (hasE8MAP()) {
         clear_has_e8MAP();
        _e8MAP = ::most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus__e8STATUS_NOT_CONNECT;
     }
}

inline bool T_BTProfileConnectionStatus::hasE8MAP () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline T_e8_BTConnectionStatus T_BTProfileConnectionStatus::getE8MAP () const {
    return _e8MAP;
}

inline void T_BTProfileConnectionStatus::setE8MAP (T_e8_BTConnectionStatus e8MAP_) {
    #ifndef NDEBUG
    if (!(T_e8_BTConnectionStatus_IsValid(e8MAP_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8MAP_, "T_e8_BTConnectionStatus", "e8MAP", "T_BTProfileConnectionStatus");
    }
    #endif
    set_has_e8MAP();
    this->_e8MAP = e8MAP_;
}

inline void T_BTProfileConnectionStatus::set_has_e8HFP () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_BTProfileConnectionStatus::clear_has_e8HFP () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_BTProfileConnectionStatus::set_has_e8AVP () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_BTProfileConnectionStatus::clear_has_e8AVP () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_BTProfileConnectionStatus::set_has_e8PAN () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_BTProfileConnectionStatus::clear_has_e8PAN () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_BTProfileConnectionStatus::set_has_e8PBAP () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_BTProfileConnectionStatus::clear_has_e8PBAP () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_BTProfileConnectionStatus::set_has_e8MAP () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_BTProfileConnectionStatus::clear_has_e8MAP () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  T_BTProfileDisconnectedReason::T_BTProfileDisconnectedReason ()  :
    _e8HFP (::most_BTSet_fi_types_Extended::T_e8_BTSetDeviceDisconnectedReason__e8NOT_APPLICABLE),
    _e8AVP (::most_BTSet_fi_types_Extended::T_e8_BTSetDeviceDisconnectedReason__e8NOT_APPLICABLE),
    _e8PAN (::most_BTSet_fi_types_Extended::T_e8_BTSetDeviceDisconnectedReason__e8NOT_APPLICABLE),
    _e8PBAP (::most_BTSet_fi_types_Extended::T_e8_BTSetDeviceDisconnectedReason__e8NOT_APPLICABLE),
    _e8MAP (::most_BTSet_fi_types_Extended::T_e8_BTSetDeviceDisconnectedReason__e8NOT_APPLICABLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_BTProfileDisconnectedReason::T_BTProfileDisconnectedReason (const T_BTProfileDisconnectedReason &rhs)  :
    _e8HFP (::most_BTSet_fi_types_Extended::T_e8_BTSetDeviceDisconnectedReason__e8NOT_APPLICABLE),
    _e8AVP (::most_BTSet_fi_types_Extended::T_e8_BTSetDeviceDisconnectedReason__e8NOT_APPLICABLE),
    _e8PAN (::most_BTSet_fi_types_Extended::T_e8_BTSetDeviceDisconnectedReason__e8NOT_APPLICABLE),
    _e8PBAP (::most_BTSet_fi_types_Extended::T_e8_BTSetDeviceDisconnectedReason__e8NOT_APPLICABLE),
    _e8MAP (::most_BTSet_fi_types_Extended::T_e8_BTSetDeviceDisconnectedReason__e8NOT_APPLICABLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_BTProfileDisconnectedReason::T_BTProfileDisconnectedReason (T_e8_BTSetDeviceDisconnectedReason e8HFP_, T_e8_BTSetDeviceDisconnectedReason e8AVP_, T_e8_BTSetDeviceDisconnectedReason e8PAN_, T_e8_BTSetDeviceDisconnectedReason e8PBAP_, T_e8_BTSetDeviceDisconnectedReason e8MAP_)  :
    _e8HFP (e8HFP_),
    _e8AVP (e8AVP_),
    _e8PAN (e8PAN_),
    _e8PBAP (e8PBAP_),
    _e8MAP (e8MAP_)
{
    #ifndef NDEBUG
    if (!(T_e8_BTSetDeviceDisconnectedReason_IsValid(e8HFP_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8HFP_, "T_e8_BTSetDeviceDisconnectedReason", "e8HFP", "T_BTProfileDisconnectedReason");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_BTSetDeviceDisconnectedReason_IsValid(e8AVP_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8AVP_, "T_e8_BTSetDeviceDisconnectedReason", "e8AVP", "T_BTProfileDisconnectedReason");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_BTSetDeviceDisconnectedReason_IsValid(e8PAN_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8PAN_, "T_e8_BTSetDeviceDisconnectedReason", "e8PAN", "T_BTProfileDisconnectedReason");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_BTSetDeviceDisconnectedReason_IsValid(e8PBAP_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8PBAP_, "T_e8_BTSetDeviceDisconnectedReason", "e8PBAP", "T_BTProfileDisconnectedReason");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_BTSetDeviceDisconnectedReason_IsValid(e8MAP_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8MAP_, "T_e8_BTSetDeviceDisconnectedReason", "e8MAP", "T_BTProfileDisconnectedReason");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_BTProfileDisconnectedReason::~T_BTProfileDisconnectedReason() {
}

inline T_BTProfileDisconnectedReason& T_BTProfileDisconnectedReason::operator = (const T_BTProfileDisconnectedReason& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE8HFP()) {
            setE8HFP(rhs.getE8HFP());
        } else {
            clearE8HFP();
        }
        if (rhs.hasE8AVP()) {
            setE8AVP(rhs.getE8AVP());
        } else {
            clearE8AVP();
        }
        if (rhs.hasE8PAN()) {
            setE8PAN(rhs.getE8PAN());
        } else {
            clearE8PAN();
        }
        if (rhs.hasE8PBAP()) {
            setE8PBAP(rhs.getE8PBAP());
        } else {
            clearE8PBAP();
        }
        if (rhs.hasE8MAP()) {
            setE8MAP(rhs.getE8MAP());
        } else {
            clearE8MAP();
        }
    }
    return *this;
}

inline bool T_BTProfileDisconnectedReason::operator == (const T_BTProfileDisconnectedReason& rhs) const {
    return (((!hasE8HFP() && !rhs.hasE8HFP()) || getE8HFP() == rhs.getE8HFP()) &&
        ((!hasE8AVP() && !rhs.hasE8AVP()) || getE8AVP() == rhs.getE8AVP()) &&
        ((!hasE8PAN() && !rhs.hasE8PAN()) || getE8PAN() == rhs.getE8PAN()) &&
        ((!hasE8PBAP() && !rhs.hasE8PBAP()) || getE8PBAP() == rhs.getE8PBAP()) &&
        ((!hasE8MAP() && !rhs.hasE8MAP()) || getE8MAP() == rhs.getE8MAP()));
}

inline bool T_BTProfileDisconnectedReason::operator != (const T_BTProfileDisconnectedReason& rhs) const {
    return ! (*this == rhs);
}

inline bool T_BTProfileDisconnectedReason::operator < (const T_BTProfileDisconnectedReason& rhs) const {
    if (hasE8HFP() || rhs.hasE8HFP()) {
        if ((uint32)getE8HFP() < (uint32)rhs.getE8HFP()) return true;
        if ((uint32)getE8HFP() > (uint32)rhs.getE8HFP()) return false;
    }
    if (hasE8AVP() || rhs.hasE8AVP()) {
        if ((uint32)getE8AVP() < (uint32)rhs.getE8AVP()) return true;
        if ((uint32)getE8AVP() > (uint32)rhs.getE8AVP()) return false;
    }
    if (hasE8PAN() || rhs.hasE8PAN()) {
        if ((uint32)getE8PAN() < (uint32)rhs.getE8PAN()) return true;
        if ((uint32)getE8PAN() > (uint32)rhs.getE8PAN()) return false;
    }
    if (hasE8PBAP() || rhs.hasE8PBAP()) {
        if ((uint32)getE8PBAP() < (uint32)rhs.getE8PBAP()) return true;
        if ((uint32)getE8PBAP() > (uint32)rhs.getE8PBAP()) return false;
    }
    if (hasE8MAP() || rhs.hasE8MAP()) {
        if ((uint32)getE8MAP() < (uint32)rhs.getE8MAP()) return true;
        if ((uint32)getE8MAP() > (uint32)rhs.getE8MAP()) return false;
    }
    return false;
}

inline bool T_BTProfileDisconnectedReason::operator > (const T_BTProfileDisconnectedReason& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_BTProfileDisconnectedReason::clear() {
    clearE8HFP();
    clearE8AVP();
    clearE8PAN();
    clearE8PBAP();
    clearE8MAP();
}

inline void T_BTProfileDisconnectedReason::clearE8HFP() {
    if (hasE8HFP()) {
         clear_has_e8HFP();
        _e8HFP = ::most_BTSet_fi_types_Extended::T_e8_BTSetDeviceDisconnectedReason__e8NOT_APPLICABLE;
     }
}

inline bool T_BTProfileDisconnectedReason::hasE8HFP () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_BTSetDeviceDisconnectedReason T_BTProfileDisconnectedReason::getE8HFP () const {
    return _e8HFP;
}

inline void T_BTProfileDisconnectedReason::setE8HFP (T_e8_BTSetDeviceDisconnectedReason e8HFP_) {
    #ifndef NDEBUG
    if (!(T_e8_BTSetDeviceDisconnectedReason_IsValid(e8HFP_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8HFP_, "T_e8_BTSetDeviceDisconnectedReason", "e8HFP", "T_BTProfileDisconnectedReason");
    }
    #endif
    set_has_e8HFP();
    this->_e8HFP = e8HFP_;
}

inline void T_BTProfileDisconnectedReason::clearE8AVP() {
    if (hasE8AVP()) {
         clear_has_e8AVP();
        _e8AVP = ::most_BTSet_fi_types_Extended::T_e8_BTSetDeviceDisconnectedReason__e8NOT_APPLICABLE;
     }
}

inline bool T_BTProfileDisconnectedReason::hasE8AVP () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_BTSetDeviceDisconnectedReason T_BTProfileDisconnectedReason::getE8AVP () const {
    return _e8AVP;
}

inline void T_BTProfileDisconnectedReason::setE8AVP (T_e8_BTSetDeviceDisconnectedReason e8AVP_) {
    #ifndef NDEBUG
    if (!(T_e8_BTSetDeviceDisconnectedReason_IsValid(e8AVP_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8AVP_, "T_e8_BTSetDeviceDisconnectedReason", "e8AVP", "T_BTProfileDisconnectedReason");
    }
    #endif
    set_has_e8AVP();
    this->_e8AVP = e8AVP_;
}

inline void T_BTProfileDisconnectedReason::clearE8PAN() {
    if (hasE8PAN()) {
         clear_has_e8PAN();
        _e8PAN = ::most_BTSet_fi_types_Extended::T_e8_BTSetDeviceDisconnectedReason__e8NOT_APPLICABLE;
     }
}

inline bool T_BTProfileDisconnectedReason::hasE8PAN () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_BTSetDeviceDisconnectedReason T_BTProfileDisconnectedReason::getE8PAN () const {
    return _e8PAN;
}

inline void T_BTProfileDisconnectedReason::setE8PAN (T_e8_BTSetDeviceDisconnectedReason e8PAN_) {
    #ifndef NDEBUG
    if (!(T_e8_BTSetDeviceDisconnectedReason_IsValid(e8PAN_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8PAN_, "T_e8_BTSetDeviceDisconnectedReason", "e8PAN", "T_BTProfileDisconnectedReason");
    }
    #endif
    set_has_e8PAN();
    this->_e8PAN = e8PAN_;
}

inline void T_BTProfileDisconnectedReason::clearE8PBAP() {
    if (hasE8PBAP()) {
         clear_has_e8PBAP();
        _e8PBAP = ::most_BTSet_fi_types_Extended::T_e8_BTSetDeviceDisconnectedReason__e8NOT_APPLICABLE;
     }
}

inline bool T_BTProfileDisconnectedReason::hasE8PBAP () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline T_e8_BTSetDeviceDisconnectedReason T_BTProfileDisconnectedReason::getE8PBAP () const {
    return _e8PBAP;
}

inline void T_BTProfileDisconnectedReason::setE8PBAP (T_e8_BTSetDeviceDisconnectedReason e8PBAP_) {
    #ifndef NDEBUG
    if (!(T_e8_BTSetDeviceDisconnectedReason_IsValid(e8PBAP_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8PBAP_, "T_e8_BTSetDeviceDisconnectedReason", "e8PBAP", "T_BTProfileDisconnectedReason");
    }
    #endif
    set_has_e8PBAP();
    this->_e8PBAP = e8PBAP_;
}

inline void T_BTProfileDisconnectedReason::clearE8MAP() {
    if (hasE8MAP()) {
         clear_has_e8MAP();
        _e8MAP = ::most_BTSet_fi_types_Extended::T_e8_BTSetDeviceDisconnectedReason__e8NOT_APPLICABLE;
     }
}

inline bool T_BTProfileDisconnectedReason::hasE8MAP () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline T_e8_BTSetDeviceDisconnectedReason T_BTProfileDisconnectedReason::getE8MAP () const {
    return _e8MAP;
}

inline void T_BTProfileDisconnectedReason::setE8MAP (T_e8_BTSetDeviceDisconnectedReason e8MAP_) {
    #ifndef NDEBUG
    if (!(T_e8_BTSetDeviceDisconnectedReason_IsValid(e8MAP_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8MAP_, "T_e8_BTSetDeviceDisconnectedReason", "e8MAP", "T_BTProfileDisconnectedReason");
    }
    #endif
    set_has_e8MAP();
    this->_e8MAP = e8MAP_;
}

inline void T_BTProfileDisconnectedReason::set_has_e8HFP () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_BTProfileDisconnectedReason::clear_has_e8HFP () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_BTProfileDisconnectedReason::set_has_e8AVP () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_BTProfileDisconnectedReason::clear_has_e8AVP () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_BTProfileDisconnectedReason::set_has_e8PAN () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_BTProfileDisconnectedReason::clear_has_e8PAN () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_BTProfileDisconnectedReason::set_has_e8PBAP () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_BTProfileDisconnectedReason::clear_has_e8PBAP () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_BTProfileDisconnectedReason::set_has_e8MAP () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_BTProfileDisconnectedReason::clear_has_e8MAP () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  T_BTProfileFavoriteIndex::T_BTProfileFavoriteIndex ()  :
    _u8HFP (0u),
    _u8AVP (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_BTProfileFavoriteIndex::T_BTProfileFavoriteIndex (const T_BTProfileFavoriteIndex &rhs)  :
    _u8HFP (0u),
    _u8AVP (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_BTProfileFavoriteIndex::T_BTProfileFavoriteIndex (uint8 u8HFP_, uint8 u8AVP_)  :
    _u8HFP (u8HFP_),
    _u8AVP (u8AVP_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_BTProfileFavoriteIndex::~T_BTProfileFavoriteIndex() {
}

inline T_BTProfileFavoriteIndex& T_BTProfileFavoriteIndex::operator = (const T_BTProfileFavoriteIndex& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8HFP()) {
            setU8HFP(rhs.getU8HFP());
        } else {
            clearU8HFP();
        }
        if (rhs.hasU8AVP()) {
            setU8AVP(rhs.getU8AVP());
        } else {
            clearU8AVP();
        }
    }
    return *this;
}

inline bool T_BTProfileFavoriteIndex::operator == (const T_BTProfileFavoriteIndex& rhs) const {
    return (((!hasU8HFP() && !rhs.hasU8HFP()) || getU8HFP() == rhs.getU8HFP()) &&
        ((!hasU8AVP() && !rhs.hasU8AVP()) || getU8AVP() == rhs.getU8AVP()));
}

inline bool T_BTProfileFavoriteIndex::operator != (const T_BTProfileFavoriteIndex& rhs) const {
    return ! (*this == rhs);
}

inline bool T_BTProfileFavoriteIndex::operator < (const T_BTProfileFavoriteIndex& rhs) const {
    if (hasU8HFP() || rhs.hasU8HFP()) {
        if (getU8HFP() < rhs.getU8HFP()) return true;
        if (getU8HFP() > rhs.getU8HFP()) return false;
    }
    if (hasU8AVP() || rhs.hasU8AVP()) {
        if (getU8AVP() < rhs.getU8AVP()) return true;
        if (getU8AVP() > rhs.getU8AVP()) return false;
    }
    return false;
}

inline bool T_BTProfileFavoriteIndex::operator > (const T_BTProfileFavoriteIndex& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_BTProfileFavoriteIndex::clear() {
    clearU8HFP();
    clearU8AVP();
}

inline void T_BTProfileFavoriteIndex::clearU8HFP() {
    if (hasU8HFP()) {
         clear_has_u8HFP();
        _u8HFP = 0u;
     }
}

inline bool T_BTProfileFavoriteIndex::hasU8HFP () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_BTProfileFavoriteIndex::getU8HFP () const {
    return _u8HFP;
}

inline void T_BTProfileFavoriteIndex::setU8HFP (uint8 u8HFP_) {
    set_has_u8HFP();
    this->_u8HFP = u8HFP_;
}

inline void T_BTProfileFavoriteIndex::clearU8AVP() {
    if (hasU8AVP()) {
         clear_has_u8AVP();
        _u8AVP = 0u;
     }
}

inline bool T_BTProfileFavoriteIndex::hasU8AVP () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_BTProfileFavoriteIndex::getU8AVP () const {
    return _u8AVP;
}

inline void T_BTProfileFavoriteIndex::setU8AVP (uint8 u8AVP_) {
    set_has_u8AVP();
    this->_u8AVP = u8AVP_;
}

inline void T_BTProfileFavoriteIndex::set_has_u8HFP () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_BTProfileFavoriteIndex::clear_has_u8HFP () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_BTProfileFavoriteIndex::set_has_u8AVP () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_BTProfileFavoriteIndex::clear_has_u8AVP () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_BTSetDeviceListExtendedResultItem::T_BTSetDeviceListExtendedResultItem ()  :
    _sDeviceAddress (),
    _u8DeviceHandle (0u),
    _sDeviceName (),
    _bDeviceConnectedStatus (false),
    _e8DeviceDisconnectedReason (::most_BTSet_fi_types_Extended::T_e8_BTSetDeviceDisconnectedReason__e8NOT_APPLICABLE),
    _oDeviceProfileStatus (),
    _oDeviceProfileDisconnectedReason (),
    _oDeviceSupportedProfiles (),
    _bOutgoingSourceDeviceStatus (false),
    _oDateTimeStamp (),
    _oDeviceInfo (),
    _e8DeviceConnectionStatus (::most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus__e8STATUS_NOT_CONNECT),
    _oDeviceProfileConnectionStatus (),
    _u8DeviceFavoriteIndex (0u),
    _oDeviceProfileFavoriteIndex (),
    _e8DeviceUsagePreference (::most_BTSet_fi_types_Extended::T_e8_BTUsagePreference__e8UNDECIDED),
    _oDevicePairedDateTimeStamp (),
    _biAPoverBTSupport (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_BTSetDeviceListExtendedResultItem::T_BTSetDeviceListExtendedResultItem (const T_BTSetDeviceListExtendedResultItem &rhs)  :
    _sDeviceAddress (),
    _u8DeviceHandle (0u),
    _sDeviceName (),
    _bDeviceConnectedStatus (false),
    _e8DeviceDisconnectedReason (::most_BTSet_fi_types_Extended::T_e8_BTSetDeviceDisconnectedReason__e8NOT_APPLICABLE),
    _oDeviceProfileStatus (),
    _oDeviceProfileDisconnectedReason (),
    _oDeviceSupportedProfiles (),
    _bOutgoingSourceDeviceStatus (false),
    _oDateTimeStamp (),
    _oDeviceInfo (),
    _e8DeviceConnectionStatus (::most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus__e8STATUS_NOT_CONNECT),
    _oDeviceProfileConnectionStatus (),
    _u8DeviceFavoriteIndex (0u),
    _oDeviceProfileFavoriteIndex (),
    _e8DeviceUsagePreference (::most_BTSet_fi_types_Extended::T_e8_BTUsagePreference__e8UNDECIDED),
    _oDevicePairedDateTimeStamp (),
    _biAPoverBTSupport (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_BTSetDeviceListExtendedResultItem::T_BTSetDeviceListExtendedResultItem (const ::fi_basetypes_most::T_String& sDeviceAddress_, uint8 u8DeviceHandle_, const ::fi_basetypes_most::T_String& sDeviceName_, bool bDeviceConnectedStatus_, T_e8_BTSetDeviceDisconnectedReason e8DeviceDisconnectedReason_, const T_BTServiceType& oDeviceProfileStatus_, const T_BTProfileDisconnectedReason& oDeviceProfileDisconnectedReason_, const T_BTSetSupportedProfiles& oDeviceSupportedProfiles_, bool bOutgoingSourceDeviceStatus_, const ::most_BTSet_fi_types::T_BTSetDateTimeStamp& oDateTimeStamp_, const T_BTSetDeviceIdentification& oDeviceInfo_, T_e8_BTConnectionStatus e8DeviceConnectionStatus_, const T_BTProfileConnectionStatus& oDeviceProfileConnectionStatus_, uint8 u8DeviceFavoriteIndex_, const T_BTProfileFavoriteIndex& oDeviceProfileFavoriteIndex_, T_e8_BTUsagePreference e8DeviceUsagePreference_, const ::most_BTSet_fi_types::T_BTSetDateTimeStamp& oDevicePairedDateTimeStamp_, bool biAPoverBTSupport_)  :
    _sDeviceAddress (sDeviceAddress_),
    _u8DeviceHandle (u8DeviceHandle_),
    _sDeviceName (sDeviceName_),
    _bDeviceConnectedStatus (bDeviceConnectedStatus_),
    _e8DeviceDisconnectedReason (e8DeviceDisconnectedReason_),
    _oDeviceProfileStatus (oDeviceProfileStatus_),
    _oDeviceProfileDisconnectedReason (oDeviceProfileDisconnectedReason_),
    _oDeviceSupportedProfiles (oDeviceSupportedProfiles_),
    _bOutgoingSourceDeviceStatus (bOutgoingSourceDeviceStatus_),
    _oDateTimeStamp (oDateTimeStamp_),
    _oDeviceInfo (oDeviceInfo_),
    _e8DeviceConnectionStatus (e8DeviceConnectionStatus_),
    _oDeviceProfileConnectionStatus (oDeviceProfileConnectionStatus_),
    _u8DeviceFavoriteIndex (u8DeviceFavoriteIndex_),
    _oDeviceProfileFavoriteIndex (oDeviceProfileFavoriteIndex_),
    _e8DeviceUsagePreference (e8DeviceUsagePreference_),
    _oDevicePairedDateTimeStamp (oDevicePairedDateTimeStamp_),
    _biAPoverBTSupport (biAPoverBTSupport_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e8_BTSetDeviceDisconnectedReason_IsValid(e8DeviceDisconnectedReason_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DeviceDisconnectedReason_, "T_e8_BTSetDeviceDisconnectedReason", "e8DeviceDisconnectedReason", "T_BTSetDeviceListExtendedResultItem");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_BTConnectionStatus_IsValid(e8DeviceConnectionStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DeviceConnectionStatus_, "T_e8_BTConnectionStatus", "e8DeviceConnectionStatus", "T_BTSetDeviceListExtendedResultItem");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_BTUsagePreference_IsValid(e8DeviceUsagePreference_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DeviceUsagePreference_, "T_e8_BTUsagePreference", "e8DeviceUsagePreference", "T_BTSetDeviceListExtendedResultItem");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_BTSetDeviceListExtendedResultItem::~T_BTSetDeviceListExtendedResultItem() {
}

inline T_BTSetDeviceListExtendedResultItem& T_BTSetDeviceListExtendedResultItem::operator = (const T_BTSetDeviceListExtendedResultItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSDeviceAddress()) {
            setSDeviceAddress(rhs.getSDeviceAddress());
        } else {
            clearSDeviceAddress();
        }
        if (rhs.hasU8DeviceHandle()) {
            setU8DeviceHandle(rhs.getU8DeviceHandle());
        } else {
            clearU8DeviceHandle();
        }
        if (rhs.hasSDeviceName()) {
            setSDeviceName(rhs.getSDeviceName());
        } else {
            clearSDeviceName();
        }
        if (rhs.hasBDeviceConnectedStatus()) {
            setBDeviceConnectedStatus(rhs.getBDeviceConnectedStatus());
        } else {
            clearBDeviceConnectedStatus();
        }
        if (rhs.hasE8DeviceDisconnectedReason()) {
            setE8DeviceDisconnectedReason(rhs.getE8DeviceDisconnectedReason());
        } else {
            clearE8DeviceDisconnectedReason();
        }
        if (rhs.hasODeviceProfileStatus()) {
            setODeviceProfileStatus(rhs.getODeviceProfileStatus());
        } else {
            clearODeviceProfileStatus();
        }
        if (rhs.hasODeviceProfileDisconnectedReason()) {
            setODeviceProfileDisconnectedReason(rhs.getODeviceProfileDisconnectedReason());
        } else {
            clearODeviceProfileDisconnectedReason();
        }
        if (rhs.hasODeviceSupportedProfiles()) {
            setODeviceSupportedProfiles(rhs.getODeviceSupportedProfiles());
        } else {
            clearODeviceSupportedProfiles();
        }
        if (rhs.hasBOutgoingSourceDeviceStatus()) {
            setBOutgoingSourceDeviceStatus(rhs.getBOutgoingSourceDeviceStatus());
        } else {
            clearBOutgoingSourceDeviceStatus();
        }
        if (rhs.hasODateTimeStamp()) {
            setODateTimeStamp(rhs.getODateTimeStamp());
        } else {
            clearODateTimeStamp();
        }
        if (rhs.hasODeviceInfo()) {
            setODeviceInfo(rhs.getODeviceInfo());
        } else {
            clearODeviceInfo();
        }
        if (rhs.hasE8DeviceConnectionStatus()) {
            setE8DeviceConnectionStatus(rhs.getE8DeviceConnectionStatus());
        } else {
            clearE8DeviceConnectionStatus();
        }
        if (rhs.hasODeviceProfileConnectionStatus()) {
            setODeviceProfileConnectionStatus(rhs.getODeviceProfileConnectionStatus());
        } else {
            clearODeviceProfileConnectionStatus();
        }
        if (rhs.hasU8DeviceFavoriteIndex()) {
            setU8DeviceFavoriteIndex(rhs.getU8DeviceFavoriteIndex());
        } else {
            clearU8DeviceFavoriteIndex();
        }
        if (rhs.hasODeviceProfileFavoriteIndex()) {
            setODeviceProfileFavoriteIndex(rhs.getODeviceProfileFavoriteIndex());
        } else {
            clearODeviceProfileFavoriteIndex();
        }
        if (rhs.hasE8DeviceUsagePreference()) {
            setE8DeviceUsagePreference(rhs.getE8DeviceUsagePreference());
        } else {
            clearE8DeviceUsagePreference();
        }
        if (rhs.hasODevicePairedDateTimeStamp()) {
            setODevicePairedDateTimeStamp(rhs.getODevicePairedDateTimeStamp());
        } else {
            clearODevicePairedDateTimeStamp();
        }
        if (rhs.hasBiAPoverBTSupport()) {
            setBiAPoverBTSupport(rhs.getBiAPoverBTSupport());
        } else {
            clearBiAPoverBTSupport();
        }
    }
    return *this;
}

inline bool T_BTSetDeviceListExtendedResultItem::operator == (const T_BTSetDeviceListExtendedResultItem& rhs) const {
    return (((!hasSDeviceAddress() && !rhs.hasSDeviceAddress()) || getSDeviceAddress() == rhs.getSDeviceAddress()) &&
        ((!hasU8DeviceHandle() && !rhs.hasU8DeviceHandle()) || getU8DeviceHandle() == rhs.getU8DeviceHandle()) &&
        ((!hasSDeviceName() && !rhs.hasSDeviceName()) || getSDeviceName() == rhs.getSDeviceName()) &&
        ((!hasBDeviceConnectedStatus() && !rhs.hasBDeviceConnectedStatus()) || getBDeviceConnectedStatus() == rhs.getBDeviceConnectedStatus()) &&
        ((!hasE8DeviceDisconnectedReason() && !rhs.hasE8DeviceDisconnectedReason()) || getE8DeviceDisconnectedReason() == rhs.getE8DeviceDisconnectedReason()) &&
        ((!hasODeviceProfileStatus() && !rhs.hasODeviceProfileStatus()) || getODeviceProfileStatus() == rhs.getODeviceProfileStatus()) &&
        ((!hasODeviceProfileDisconnectedReason() && !rhs.hasODeviceProfileDisconnectedReason()) || getODeviceProfileDisconnectedReason() == rhs.getODeviceProfileDisconnectedReason()) &&
        ((!hasODeviceSupportedProfiles() && !rhs.hasODeviceSupportedProfiles()) || getODeviceSupportedProfiles() == rhs.getODeviceSupportedProfiles()) &&
        ((!hasBOutgoingSourceDeviceStatus() && !rhs.hasBOutgoingSourceDeviceStatus()) || getBOutgoingSourceDeviceStatus() == rhs.getBOutgoingSourceDeviceStatus()) &&
        ((!hasODateTimeStamp() && !rhs.hasODateTimeStamp()) || getODateTimeStamp() == rhs.getODateTimeStamp()) &&
        ((!hasODeviceInfo() && !rhs.hasODeviceInfo()) || getODeviceInfo() == rhs.getODeviceInfo()) &&
        ((!hasE8DeviceConnectionStatus() && !rhs.hasE8DeviceConnectionStatus()) || getE8DeviceConnectionStatus() == rhs.getE8DeviceConnectionStatus()) &&
        ((!hasODeviceProfileConnectionStatus() && !rhs.hasODeviceProfileConnectionStatus()) || getODeviceProfileConnectionStatus() == rhs.getODeviceProfileConnectionStatus()) &&
        ((!hasU8DeviceFavoriteIndex() && !rhs.hasU8DeviceFavoriteIndex()) || getU8DeviceFavoriteIndex() == rhs.getU8DeviceFavoriteIndex()) &&
        ((!hasODeviceProfileFavoriteIndex() && !rhs.hasODeviceProfileFavoriteIndex()) || getODeviceProfileFavoriteIndex() == rhs.getODeviceProfileFavoriteIndex()) &&
        ((!hasE8DeviceUsagePreference() && !rhs.hasE8DeviceUsagePreference()) || getE8DeviceUsagePreference() == rhs.getE8DeviceUsagePreference()) &&
        ((!hasODevicePairedDateTimeStamp() && !rhs.hasODevicePairedDateTimeStamp()) || getODevicePairedDateTimeStamp() == rhs.getODevicePairedDateTimeStamp()) &&
        ((!hasBiAPoverBTSupport() && !rhs.hasBiAPoverBTSupport()) || getBiAPoverBTSupport() == rhs.getBiAPoverBTSupport()));
}

inline bool T_BTSetDeviceListExtendedResultItem::operator != (const T_BTSetDeviceListExtendedResultItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_BTSetDeviceListExtendedResultItem::operator < (const T_BTSetDeviceListExtendedResultItem& rhs) const {
    if (hasSDeviceAddress() || rhs.hasSDeviceAddress()) {
        if (getSDeviceAddress() < rhs.getSDeviceAddress()) return true;
        if (getSDeviceAddress() > rhs.getSDeviceAddress()) return false;
    }
    if (hasU8DeviceHandle() || rhs.hasU8DeviceHandle()) {
        if (getU8DeviceHandle() < rhs.getU8DeviceHandle()) return true;
        if (getU8DeviceHandle() > rhs.getU8DeviceHandle()) return false;
    }
    if (hasSDeviceName() || rhs.hasSDeviceName()) {
        if (getSDeviceName() < rhs.getSDeviceName()) return true;
        if (getSDeviceName() > rhs.getSDeviceName()) return false;
    }
    if (hasBDeviceConnectedStatus() || rhs.hasBDeviceConnectedStatus()) {
        if (getBDeviceConnectedStatus() < rhs.getBDeviceConnectedStatus()) return true;
        if (getBDeviceConnectedStatus() > rhs.getBDeviceConnectedStatus()) return false;
    }
    if (hasE8DeviceDisconnectedReason() || rhs.hasE8DeviceDisconnectedReason()) {
        if ((uint32)getE8DeviceDisconnectedReason() < (uint32)rhs.getE8DeviceDisconnectedReason()) return true;
        if ((uint32)getE8DeviceDisconnectedReason() > (uint32)rhs.getE8DeviceDisconnectedReason()) return false;
    }
    if (hasODeviceProfileStatus() || rhs.hasODeviceProfileStatus()) {
        if (getODeviceProfileStatus() < rhs.getODeviceProfileStatus()) return true;
        if (getODeviceProfileStatus() > rhs.getODeviceProfileStatus()) return false;
    }
    if (hasODeviceProfileDisconnectedReason() || rhs.hasODeviceProfileDisconnectedReason()) {
        if (getODeviceProfileDisconnectedReason() < rhs.getODeviceProfileDisconnectedReason()) return true;
        if (getODeviceProfileDisconnectedReason() > rhs.getODeviceProfileDisconnectedReason()) return false;
    }
    if (hasODeviceSupportedProfiles() || rhs.hasODeviceSupportedProfiles()) {
        if (getODeviceSupportedProfiles() < rhs.getODeviceSupportedProfiles()) return true;
        if (getODeviceSupportedProfiles() > rhs.getODeviceSupportedProfiles()) return false;
    }
    if (hasBOutgoingSourceDeviceStatus() || rhs.hasBOutgoingSourceDeviceStatus()) {
        if (getBOutgoingSourceDeviceStatus() < rhs.getBOutgoingSourceDeviceStatus()) return true;
        if (getBOutgoingSourceDeviceStatus() > rhs.getBOutgoingSourceDeviceStatus()) return false;
    }
    if (hasODateTimeStamp() || rhs.hasODateTimeStamp()) {
        if (getODateTimeStamp() < rhs.getODateTimeStamp()) return true;
        if (getODateTimeStamp() > rhs.getODateTimeStamp()) return false;
    }
    if (hasODeviceInfo() || rhs.hasODeviceInfo()) {
        if (getODeviceInfo() < rhs.getODeviceInfo()) return true;
        if (getODeviceInfo() > rhs.getODeviceInfo()) return false;
    }
    if (hasE8DeviceConnectionStatus() || rhs.hasE8DeviceConnectionStatus()) {
        if ((uint32)getE8DeviceConnectionStatus() < (uint32)rhs.getE8DeviceConnectionStatus()) return true;
        if ((uint32)getE8DeviceConnectionStatus() > (uint32)rhs.getE8DeviceConnectionStatus()) return false;
    }
    if (hasODeviceProfileConnectionStatus() || rhs.hasODeviceProfileConnectionStatus()) {
        if (getODeviceProfileConnectionStatus() < rhs.getODeviceProfileConnectionStatus()) return true;
        if (getODeviceProfileConnectionStatus() > rhs.getODeviceProfileConnectionStatus()) return false;
    }
    if (hasU8DeviceFavoriteIndex() || rhs.hasU8DeviceFavoriteIndex()) {
        if (getU8DeviceFavoriteIndex() < rhs.getU8DeviceFavoriteIndex()) return true;
        if (getU8DeviceFavoriteIndex() > rhs.getU8DeviceFavoriteIndex()) return false;
    }
    if (hasODeviceProfileFavoriteIndex() || rhs.hasODeviceProfileFavoriteIndex()) {
        if (getODeviceProfileFavoriteIndex() < rhs.getODeviceProfileFavoriteIndex()) return true;
        if (getODeviceProfileFavoriteIndex() > rhs.getODeviceProfileFavoriteIndex()) return false;
    }
    if (hasE8DeviceUsagePreference() || rhs.hasE8DeviceUsagePreference()) {
        if ((uint32)getE8DeviceUsagePreference() < (uint32)rhs.getE8DeviceUsagePreference()) return true;
        if ((uint32)getE8DeviceUsagePreference() > (uint32)rhs.getE8DeviceUsagePreference()) return false;
    }
    if (hasODevicePairedDateTimeStamp() || rhs.hasODevicePairedDateTimeStamp()) {
        if (getODevicePairedDateTimeStamp() < rhs.getODevicePairedDateTimeStamp()) return true;
        if (getODevicePairedDateTimeStamp() > rhs.getODevicePairedDateTimeStamp()) return false;
    }
    if (hasBiAPoverBTSupport() || rhs.hasBiAPoverBTSupport()) {
        if (getBiAPoverBTSupport() < rhs.getBiAPoverBTSupport()) return true;
        if (getBiAPoverBTSupport() > rhs.getBiAPoverBTSupport()) return false;
    }
    return false;
}

inline bool T_BTSetDeviceListExtendedResultItem::operator > (const T_BTSetDeviceListExtendedResultItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_BTSetDeviceListExtendedResultItem::clear() {
    clearSDeviceAddress();
    clearU8DeviceHandle();
    clearSDeviceName();
    clearBDeviceConnectedStatus();
    clearE8DeviceDisconnectedReason();
    clearODeviceProfileStatus();
    clearODeviceProfileDisconnectedReason();
    clearODeviceSupportedProfiles();
    clearBOutgoingSourceDeviceStatus();
    clearODateTimeStamp();
    clearODeviceInfo();
    clearE8DeviceConnectionStatus();
    clearODeviceProfileConnectionStatus();
    clearU8DeviceFavoriteIndex();
    clearODeviceProfileFavoriteIndex();
    clearE8DeviceUsagePreference();
    clearODevicePairedDateTimeStamp();
    clearBiAPoverBTSupport();
}

inline void T_BTSetDeviceListExtendedResultItem::clearSDeviceAddress() {
    if (hasSDeviceAddress()) {
         clear_has_sDeviceAddress();
        _sDeviceAddress.clear();
     }
}

inline bool T_BTSetDeviceListExtendedResultItem::hasSDeviceAddress () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_BTSetDeviceListExtendedResultItem::getSDeviceAddress () const {
    return _sDeviceAddress;
}

inline ::fi_basetypes_most::T_String& T_BTSetDeviceListExtendedResultItem::getSDeviceAddressMutable () {
    set_has_sDeviceAddress();
    return _sDeviceAddress;
}

inline void T_BTSetDeviceListExtendedResultItem::setSDeviceAddress (const ::fi_basetypes_most::T_String& sDeviceAddress_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceAddress();
    this->_sDeviceAddress = sDeviceAddress_;
}

inline void T_BTSetDeviceListExtendedResultItem::clearU8DeviceHandle() {
    if (hasU8DeviceHandle()) {
         clear_has_u8DeviceHandle();
        _u8DeviceHandle = 0u;
     }
}

inline bool T_BTSetDeviceListExtendedResultItem::hasU8DeviceHandle () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_BTSetDeviceListExtendedResultItem::getU8DeviceHandle () const {
    return _u8DeviceHandle;
}

inline void T_BTSetDeviceListExtendedResultItem::setU8DeviceHandle (uint8 u8DeviceHandle_) {
    set_has_u8DeviceHandle();
    this->_u8DeviceHandle = u8DeviceHandle_;
}

inline void T_BTSetDeviceListExtendedResultItem::clearSDeviceName() {
    if (hasSDeviceName()) {
         clear_has_sDeviceName();
        _sDeviceName.clear();
     }
}

inline bool T_BTSetDeviceListExtendedResultItem::hasSDeviceName () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_BTSetDeviceListExtendedResultItem::getSDeviceName () const {
    return _sDeviceName;
}

inline ::fi_basetypes_most::T_String& T_BTSetDeviceListExtendedResultItem::getSDeviceNameMutable () {
    set_has_sDeviceName();
    return _sDeviceName;
}

inline void T_BTSetDeviceListExtendedResultItem::setSDeviceName (const ::fi_basetypes_most::T_String& sDeviceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceName();
    this->_sDeviceName = sDeviceName_;
}

inline void T_BTSetDeviceListExtendedResultItem::clearBDeviceConnectedStatus() {
    if (hasBDeviceConnectedStatus()) {
         clear_has_bDeviceConnectedStatus();
        _bDeviceConnectedStatus = false;
     }
}

inline bool T_BTSetDeviceListExtendedResultItem::hasBDeviceConnectedStatus () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline bool T_BTSetDeviceListExtendedResultItem::getBDeviceConnectedStatus () const {
    return _bDeviceConnectedStatus;
}

inline void T_BTSetDeviceListExtendedResultItem::setBDeviceConnectedStatus (bool bDeviceConnectedStatus_) {
    set_has_bDeviceConnectedStatus();
    this->_bDeviceConnectedStatus = bDeviceConnectedStatus_;
}

inline void T_BTSetDeviceListExtendedResultItem::clearE8DeviceDisconnectedReason() {
    if (hasE8DeviceDisconnectedReason()) {
         clear_has_e8DeviceDisconnectedReason();
        _e8DeviceDisconnectedReason = ::most_BTSet_fi_types_Extended::T_e8_BTSetDeviceDisconnectedReason__e8NOT_APPLICABLE;
     }
}

inline bool T_BTSetDeviceListExtendedResultItem::hasE8DeviceDisconnectedReason () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline T_e8_BTSetDeviceDisconnectedReason T_BTSetDeviceListExtendedResultItem::getE8DeviceDisconnectedReason () const {
    return _e8DeviceDisconnectedReason;
}

inline void T_BTSetDeviceListExtendedResultItem::setE8DeviceDisconnectedReason (T_e8_BTSetDeviceDisconnectedReason e8DeviceDisconnectedReason_) {
    #ifndef NDEBUG
    if (!(T_e8_BTSetDeviceDisconnectedReason_IsValid(e8DeviceDisconnectedReason_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DeviceDisconnectedReason_, "T_e8_BTSetDeviceDisconnectedReason", "e8DeviceDisconnectedReason", "T_BTSetDeviceListExtendedResultItem");
    }
    #endif
    set_has_e8DeviceDisconnectedReason();
    this->_e8DeviceDisconnectedReason = e8DeviceDisconnectedReason_;
}

inline void T_BTSetDeviceListExtendedResultItem::clearODeviceProfileStatus() {
    if (hasODeviceProfileStatus()) {
         clear_has_oDeviceProfileStatus();
        _oDeviceProfileStatus.clear();
     }
}

inline bool T_BTSetDeviceListExtendedResultItem::hasODeviceProfileStatus () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const T_BTServiceType& T_BTSetDeviceListExtendedResultItem::getODeviceProfileStatus () const {
    return _oDeviceProfileStatus;
}

inline T_BTServiceType& T_BTSetDeviceListExtendedResultItem::getODeviceProfileStatusMutable () {
    set_has_oDeviceProfileStatus();
    return _oDeviceProfileStatus;
}

inline void T_BTSetDeviceListExtendedResultItem::setODeviceProfileStatus (const T_BTServiceType& oDeviceProfileStatus_) {
    set_has_oDeviceProfileStatus();
    this->_oDeviceProfileStatus = oDeviceProfileStatus_;
}

inline void T_BTSetDeviceListExtendedResultItem::clearODeviceProfileDisconnectedReason() {
    if (hasODeviceProfileDisconnectedReason()) {
         clear_has_oDeviceProfileDisconnectedReason();
        _oDeviceProfileDisconnectedReason.clear();
     }
}

inline bool T_BTSetDeviceListExtendedResultItem::hasODeviceProfileDisconnectedReason () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline const T_BTProfileDisconnectedReason& T_BTSetDeviceListExtendedResultItem::getODeviceProfileDisconnectedReason () const {
    return _oDeviceProfileDisconnectedReason;
}

inline T_BTProfileDisconnectedReason& T_BTSetDeviceListExtendedResultItem::getODeviceProfileDisconnectedReasonMutable () {
    set_has_oDeviceProfileDisconnectedReason();
    return _oDeviceProfileDisconnectedReason;
}

inline void T_BTSetDeviceListExtendedResultItem::setODeviceProfileDisconnectedReason (const T_BTProfileDisconnectedReason& oDeviceProfileDisconnectedReason_) {
    set_has_oDeviceProfileDisconnectedReason();
    this->_oDeviceProfileDisconnectedReason = oDeviceProfileDisconnectedReason_;
}

inline void T_BTSetDeviceListExtendedResultItem::clearODeviceSupportedProfiles() {
    if (hasODeviceSupportedProfiles()) {
         clear_has_oDeviceSupportedProfiles();
        _oDeviceSupportedProfiles.clear();
     }
}

inline bool T_BTSetDeviceListExtendedResultItem::hasODeviceSupportedProfiles () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline const T_BTSetSupportedProfiles& T_BTSetDeviceListExtendedResultItem::getODeviceSupportedProfiles () const {
    return _oDeviceSupportedProfiles;
}

inline T_BTSetSupportedProfiles& T_BTSetDeviceListExtendedResultItem::getODeviceSupportedProfilesMutable () {
    set_has_oDeviceSupportedProfiles();
    return _oDeviceSupportedProfiles;
}

inline void T_BTSetDeviceListExtendedResultItem::setODeviceSupportedProfiles (const T_BTSetSupportedProfiles& oDeviceSupportedProfiles_) {
    set_has_oDeviceSupportedProfiles();
    this->_oDeviceSupportedProfiles = oDeviceSupportedProfiles_;
}

inline void T_BTSetDeviceListExtendedResultItem::clearBOutgoingSourceDeviceStatus() {
    if (hasBOutgoingSourceDeviceStatus()) {
         clear_has_bOutgoingSourceDeviceStatus();
        _bOutgoingSourceDeviceStatus = false;
     }
}

inline bool T_BTSetDeviceListExtendedResultItem::hasBOutgoingSourceDeviceStatus () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline bool T_BTSetDeviceListExtendedResultItem::getBOutgoingSourceDeviceStatus () const {
    return _bOutgoingSourceDeviceStatus;
}

inline void T_BTSetDeviceListExtendedResultItem::setBOutgoingSourceDeviceStatus (bool bOutgoingSourceDeviceStatus_) {
    set_has_bOutgoingSourceDeviceStatus();
    this->_bOutgoingSourceDeviceStatus = bOutgoingSourceDeviceStatus_;
}

inline void T_BTSetDeviceListExtendedResultItem::clearODateTimeStamp() {
    if (hasODateTimeStamp()) {
         clear_has_oDateTimeStamp();
        _oDateTimeStamp.clear();
     }
}

inline bool T_BTSetDeviceListExtendedResultItem::hasODateTimeStamp () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline const ::most_BTSet_fi_types::T_BTSetDateTimeStamp& T_BTSetDeviceListExtendedResultItem::getODateTimeStamp () const {
    return _oDateTimeStamp;
}

inline ::most_BTSet_fi_types::T_BTSetDateTimeStamp& T_BTSetDeviceListExtendedResultItem::getODateTimeStampMutable () {
    set_has_oDateTimeStamp();
    return _oDateTimeStamp;
}

inline void T_BTSetDeviceListExtendedResultItem::setODateTimeStamp (const ::most_BTSet_fi_types::T_BTSetDateTimeStamp& oDateTimeStamp_) {
    set_has_oDateTimeStamp();
    this->_oDateTimeStamp = oDateTimeStamp_;
}

inline void T_BTSetDeviceListExtendedResultItem::clearODeviceInfo() {
    if (hasODeviceInfo()) {
         clear_has_oDeviceInfo();
        _oDeviceInfo.clear();
     }
}

inline bool T_BTSetDeviceListExtendedResultItem::hasODeviceInfo () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline const T_BTSetDeviceIdentification& T_BTSetDeviceListExtendedResultItem::getODeviceInfo () const {
    return _oDeviceInfo;
}

inline T_BTSetDeviceIdentification& T_BTSetDeviceListExtendedResultItem::getODeviceInfoMutable () {
    set_has_oDeviceInfo();
    return _oDeviceInfo;
}

inline void T_BTSetDeviceListExtendedResultItem::setODeviceInfo (const T_BTSetDeviceIdentification& oDeviceInfo_) {
    set_has_oDeviceInfo();
    this->_oDeviceInfo = oDeviceInfo_;
}

inline void T_BTSetDeviceListExtendedResultItem::clearE8DeviceConnectionStatus() {
    if (hasE8DeviceConnectionStatus()) {
         clear_has_e8DeviceConnectionStatus();
        _e8DeviceConnectionStatus = ::most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus__e8STATUS_NOT_CONNECT;
     }
}

inline bool T_BTSetDeviceListExtendedResultItem::hasE8DeviceConnectionStatus () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline T_e8_BTConnectionStatus T_BTSetDeviceListExtendedResultItem::getE8DeviceConnectionStatus () const {
    return _e8DeviceConnectionStatus;
}

inline void T_BTSetDeviceListExtendedResultItem::setE8DeviceConnectionStatus (T_e8_BTConnectionStatus e8DeviceConnectionStatus_) {
    #ifndef NDEBUG
    if (!(T_e8_BTConnectionStatus_IsValid(e8DeviceConnectionStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DeviceConnectionStatus_, "T_e8_BTConnectionStatus", "e8DeviceConnectionStatus", "T_BTSetDeviceListExtendedResultItem");
    }
    #endif
    set_has_e8DeviceConnectionStatus();
    this->_e8DeviceConnectionStatus = e8DeviceConnectionStatus_;
}

inline void T_BTSetDeviceListExtendedResultItem::clearODeviceProfileConnectionStatus() {
    if (hasODeviceProfileConnectionStatus()) {
         clear_has_oDeviceProfileConnectionStatus();
        _oDeviceProfileConnectionStatus.clear();
     }
}

inline bool T_BTSetDeviceListExtendedResultItem::hasODeviceProfileConnectionStatus () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline const T_BTProfileConnectionStatus& T_BTSetDeviceListExtendedResultItem::getODeviceProfileConnectionStatus () const {
    return _oDeviceProfileConnectionStatus;
}

inline T_BTProfileConnectionStatus& T_BTSetDeviceListExtendedResultItem::getODeviceProfileConnectionStatusMutable () {
    set_has_oDeviceProfileConnectionStatus();
    return _oDeviceProfileConnectionStatus;
}

inline void T_BTSetDeviceListExtendedResultItem::setODeviceProfileConnectionStatus (const T_BTProfileConnectionStatus& oDeviceProfileConnectionStatus_) {
    set_has_oDeviceProfileConnectionStatus();
    this->_oDeviceProfileConnectionStatus = oDeviceProfileConnectionStatus_;
}

inline void T_BTSetDeviceListExtendedResultItem::clearU8DeviceFavoriteIndex() {
    if (hasU8DeviceFavoriteIndex()) {
         clear_has_u8DeviceFavoriteIndex();
        _u8DeviceFavoriteIndex = 0u;
     }
}

inline bool T_BTSetDeviceListExtendedResultItem::hasU8DeviceFavoriteIndex () const {
    return (_has_bits_[0] & (1u << 13)) > 0;
}

inline uint8 T_BTSetDeviceListExtendedResultItem::getU8DeviceFavoriteIndex () const {
    return _u8DeviceFavoriteIndex;
}

inline void T_BTSetDeviceListExtendedResultItem::setU8DeviceFavoriteIndex (uint8 u8DeviceFavoriteIndex_) {
    set_has_u8DeviceFavoriteIndex();
    this->_u8DeviceFavoriteIndex = u8DeviceFavoriteIndex_;
}

inline void T_BTSetDeviceListExtendedResultItem::clearODeviceProfileFavoriteIndex() {
    if (hasODeviceProfileFavoriteIndex()) {
         clear_has_oDeviceProfileFavoriteIndex();
        _oDeviceProfileFavoriteIndex.clear();
     }
}

inline bool T_BTSetDeviceListExtendedResultItem::hasODeviceProfileFavoriteIndex () const {
    return (_has_bits_[0] & (1u << 14)) > 0;
}

inline const T_BTProfileFavoriteIndex& T_BTSetDeviceListExtendedResultItem::getODeviceProfileFavoriteIndex () const {
    return _oDeviceProfileFavoriteIndex;
}

inline T_BTProfileFavoriteIndex& T_BTSetDeviceListExtendedResultItem::getODeviceProfileFavoriteIndexMutable () {
    set_has_oDeviceProfileFavoriteIndex();
    return _oDeviceProfileFavoriteIndex;
}

inline void T_BTSetDeviceListExtendedResultItem::setODeviceProfileFavoriteIndex (const T_BTProfileFavoriteIndex& oDeviceProfileFavoriteIndex_) {
    set_has_oDeviceProfileFavoriteIndex();
    this->_oDeviceProfileFavoriteIndex = oDeviceProfileFavoriteIndex_;
}

inline void T_BTSetDeviceListExtendedResultItem::clearE8DeviceUsagePreference() {
    if (hasE8DeviceUsagePreference()) {
         clear_has_e8DeviceUsagePreference();
        _e8DeviceUsagePreference = ::most_BTSet_fi_types_Extended::T_e8_BTUsagePreference__e8UNDECIDED;
     }
}

inline bool T_BTSetDeviceListExtendedResultItem::hasE8DeviceUsagePreference () const {
    return (_has_bits_[0] & (1u << 15)) > 0;
}

inline T_e8_BTUsagePreference T_BTSetDeviceListExtendedResultItem::getE8DeviceUsagePreference () const {
    return _e8DeviceUsagePreference;
}

inline void T_BTSetDeviceListExtendedResultItem::setE8DeviceUsagePreference (T_e8_BTUsagePreference e8DeviceUsagePreference_) {
    #ifndef NDEBUG
    if (!(T_e8_BTUsagePreference_IsValid(e8DeviceUsagePreference_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DeviceUsagePreference_, "T_e8_BTUsagePreference", "e8DeviceUsagePreference", "T_BTSetDeviceListExtendedResultItem");
    }
    #endif
    set_has_e8DeviceUsagePreference();
    this->_e8DeviceUsagePreference = e8DeviceUsagePreference_;
}

inline void T_BTSetDeviceListExtendedResultItem::clearODevicePairedDateTimeStamp() {
    if (hasODevicePairedDateTimeStamp()) {
         clear_has_oDevicePairedDateTimeStamp();
        _oDevicePairedDateTimeStamp.clear();
     }
}

inline bool T_BTSetDeviceListExtendedResultItem::hasODevicePairedDateTimeStamp () const {
    return (_has_bits_[0] & (1u << 16)) > 0;
}

inline const ::most_BTSet_fi_types::T_BTSetDateTimeStamp& T_BTSetDeviceListExtendedResultItem::getODevicePairedDateTimeStamp () const {
    return _oDevicePairedDateTimeStamp;
}

inline ::most_BTSet_fi_types::T_BTSetDateTimeStamp& T_BTSetDeviceListExtendedResultItem::getODevicePairedDateTimeStampMutable () {
    set_has_oDevicePairedDateTimeStamp();
    return _oDevicePairedDateTimeStamp;
}

inline void T_BTSetDeviceListExtendedResultItem::setODevicePairedDateTimeStamp (const ::most_BTSet_fi_types::T_BTSetDateTimeStamp& oDevicePairedDateTimeStamp_) {
    set_has_oDevicePairedDateTimeStamp();
    this->_oDevicePairedDateTimeStamp = oDevicePairedDateTimeStamp_;
}

inline void T_BTSetDeviceListExtendedResultItem::clearBiAPoverBTSupport() {
    if (hasBiAPoverBTSupport()) {
         clear_has_biAPoverBTSupport();
        _biAPoverBTSupport = false;
     }
}

inline bool T_BTSetDeviceListExtendedResultItem::hasBiAPoverBTSupport () const {
    return (_has_bits_[0] & (1u << 17)) > 0;
}

inline bool T_BTSetDeviceListExtendedResultItem::getBiAPoverBTSupport () const {
    return _biAPoverBTSupport;
}

inline void T_BTSetDeviceListExtendedResultItem::setBiAPoverBTSupport (bool biAPoverBTSupport_) {
    set_has_biAPoverBTSupport();
    this->_biAPoverBTSupport = biAPoverBTSupport_;
}

inline void T_BTSetDeviceListExtendedResultItem::set_has_sDeviceAddress () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_BTSetDeviceListExtendedResultItem::clear_has_sDeviceAddress () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_BTSetDeviceListExtendedResultItem::set_has_u8DeviceHandle () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_BTSetDeviceListExtendedResultItem::clear_has_u8DeviceHandle () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_BTSetDeviceListExtendedResultItem::set_has_sDeviceName () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_BTSetDeviceListExtendedResultItem::clear_has_sDeviceName () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_BTSetDeviceListExtendedResultItem::set_has_bDeviceConnectedStatus () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_BTSetDeviceListExtendedResultItem::clear_has_bDeviceConnectedStatus () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_BTSetDeviceListExtendedResultItem::set_has_e8DeviceDisconnectedReason () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_BTSetDeviceListExtendedResultItem::clear_has_e8DeviceDisconnectedReason () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_BTSetDeviceListExtendedResultItem::set_has_oDeviceProfileStatus () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_BTSetDeviceListExtendedResultItem::clear_has_oDeviceProfileStatus () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_BTSetDeviceListExtendedResultItem::set_has_oDeviceProfileDisconnectedReason () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_BTSetDeviceListExtendedResultItem::clear_has_oDeviceProfileDisconnectedReason () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_BTSetDeviceListExtendedResultItem::set_has_oDeviceSupportedProfiles () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_BTSetDeviceListExtendedResultItem::clear_has_oDeviceSupportedProfiles () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_BTSetDeviceListExtendedResultItem::set_has_bOutgoingSourceDeviceStatus () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_BTSetDeviceListExtendedResultItem::clear_has_bOutgoingSourceDeviceStatus () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_BTSetDeviceListExtendedResultItem::set_has_oDateTimeStamp () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_BTSetDeviceListExtendedResultItem::clear_has_oDateTimeStamp () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_BTSetDeviceListExtendedResultItem::set_has_oDeviceInfo () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_BTSetDeviceListExtendedResultItem::clear_has_oDeviceInfo () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void T_BTSetDeviceListExtendedResultItem::set_has_e8DeviceConnectionStatus () {
    _has_bits_[0] |= 1u << 11;
}

inline void T_BTSetDeviceListExtendedResultItem::clear_has_e8DeviceConnectionStatus () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void T_BTSetDeviceListExtendedResultItem::set_has_oDeviceProfileConnectionStatus () {
    _has_bits_[0] |= 1u << 12;
}

inline void T_BTSetDeviceListExtendedResultItem::clear_has_oDeviceProfileConnectionStatus () {
    _has_bits_[0] &= ~ (1u << 12);
}

inline void T_BTSetDeviceListExtendedResultItem::set_has_u8DeviceFavoriteIndex () {
    _has_bits_[0] |= 1u << 13;
}

inline void T_BTSetDeviceListExtendedResultItem::clear_has_u8DeviceFavoriteIndex () {
    _has_bits_[0] &= ~ (1u << 13);
}

inline void T_BTSetDeviceListExtendedResultItem::set_has_oDeviceProfileFavoriteIndex () {
    _has_bits_[0] |= 1u << 14;
}

inline void T_BTSetDeviceListExtendedResultItem::clear_has_oDeviceProfileFavoriteIndex () {
    _has_bits_[0] &= ~ (1u << 14);
}

inline void T_BTSetDeviceListExtendedResultItem::set_has_e8DeviceUsagePreference () {
    _has_bits_[0] |= 1u << 15;
}

inline void T_BTSetDeviceListExtendedResultItem::clear_has_e8DeviceUsagePreference () {
    _has_bits_[0] &= ~ (1u << 15);
}

inline void T_BTSetDeviceListExtendedResultItem::set_has_oDevicePairedDateTimeStamp () {
    _has_bits_[0] |= 1u << 16;
}

inline void T_BTSetDeviceListExtendedResultItem::clear_has_oDevicePairedDateTimeStamp () {
    _has_bits_[0] &= ~ (1u << 16);
}

inline void T_BTSetDeviceListExtendedResultItem::set_has_biAPoverBTSupport () {
    _has_bits_[0] |= 1u << 17;
}

inline void T_BTSetDeviceListExtendedResultItem::clear_has_biAPoverBTSupport () {
    _has_bits_[0] &= ~ (1u << 17);
}

inline  T_BTSPPServiceConnectionStatusListItem::T_BTSPPServiceConnectionStatusListItem ()  :
    _u8DeviceHandle (0u),
    _sUUID (),
    _e8SPPConnectionStatus (::most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus__e8STATUS_NOT_CONNECT),
    _e8SPPDisconnectionReason (::most_BTSet_fi_types_Extended::T_e8_BTDisconnectionReason__e8NOT_APPLICABLE),
    _sRFCommID ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_BTSPPServiceConnectionStatusListItem::T_BTSPPServiceConnectionStatusListItem (const T_BTSPPServiceConnectionStatusListItem &rhs)  :
    _u8DeviceHandle (0u),
    _sUUID (),
    _e8SPPConnectionStatus (::most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus__e8STATUS_NOT_CONNECT),
    _e8SPPDisconnectionReason (::most_BTSet_fi_types_Extended::T_e8_BTDisconnectionReason__e8NOT_APPLICABLE),
    _sRFCommID ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_BTSPPServiceConnectionStatusListItem::T_BTSPPServiceConnectionStatusListItem (uint8 u8DeviceHandle_, const ::fi_basetypes_most::T_String& sUUID_, T_e8_BTConnectionStatus e8SPPConnectionStatus_, T_e8_BTDisconnectionReason e8SPPDisconnectionReason_, const ::fi_basetypes_most::T_String& sRFCommID_)  :
    _u8DeviceHandle (u8DeviceHandle_),
    _sUUID (sUUID_),
    _e8SPPConnectionStatus (e8SPPConnectionStatus_),
    _e8SPPDisconnectionReason (e8SPPDisconnectionReason_),
    _sRFCommID (sRFCommID_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sUUID_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e8_BTConnectionStatus_IsValid(e8SPPConnectionStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8SPPConnectionStatus_, "T_e8_BTConnectionStatus", "e8SPPConnectionStatus", "T_BTSPPServiceConnectionStatusListItem");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_BTDisconnectionReason_IsValid(e8SPPDisconnectionReason_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8SPPDisconnectionReason_, "T_e8_BTDisconnectionReason", "e8SPPDisconnectionReason", "T_BTSPPServiceConnectionStatusListItem");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sRFCommID_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_BTSPPServiceConnectionStatusListItem::~T_BTSPPServiceConnectionStatusListItem() {
}

inline T_BTSPPServiceConnectionStatusListItem& T_BTSPPServiceConnectionStatusListItem::operator = (const T_BTSPPServiceConnectionStatusListItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8DeviceHandle()) {
            setU8DeviceHandle(rhs.getU8DeviceHandle());
        } else {
            clearU8DeviceHandle();
        }
        if (rhs.hasSUUID()) {
            setSUUID(rhs.getSUUID());
        } else {
            clearSUUID();
        }
        if (rhs.hasE8SPPConnectionStatus()) {
            setE8SPPConnectionStatus(rhs.getE8SPPConnectionStatus());
        } else {
            clearE8SPPConnectionStatus();
        }
        if (rhs.hasE8SPPDisconnectionReason()) {
            setE8SPPDisconnectionReason(rhs.getE8SPPDisconnectionReason());
        } else {
            clearE8SPPDisconnectionReason();
        }
        if (rhs.hasSRFCommID()) {
            setSRFCommID(rhs.getSRFCommID());
        } else {
            clearSRFCommID();
        }
    }
    return *this;
}

inline bool T_BTSPPServiceConnectionStatusListItem::operator == (const T_BTSPPServiceConnectionStatusListItem& rhs) const {
    return (((!hasU8DeviceHandle() && !rhs.hasU8DeviceHandle()) || getU8DeviceHandle() == rhs.getU8DeviceHandle()) &&
        ((!hasSUUID() && !rhs.hasSUUID()) || getSUUID() == rhs.getSUUID()) &&
        ((!hasE8SPPConnectionStatus() && !rhs.hasE8SPPConnectionStatus()) || getE8SPPConnectionStatus() == rhs.getE8SPPConnectionStatus()) &&
        ((!hasE8SPPDisconnectionReason() && !rhs.hasE8SPPDisconnectionReason()) || getE8SPPDisconnectionReason() == rhs.getE8SPPDisconnectionReason()) &&
        ((!hasSRFCommID() && !rhs.hasSRFCommID()) || getSRFCommID() == rhs.getSRFCommID()));
}

inline bool T_BTSPPServiceConnectionStatusListItem::operator != (const T_BTSPPServiceConnectionStatusListItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_BTSPPServiceConnectionStatusListItem::operator < (const T_BTSPPServiceConnectionStatusListItem& rhs) const {
    if (hasU8DeviceHandle() || rhs.hasU8DeviceHandle()) {
        if (getU8DeviceHandle() < rhs.getU8DeviceHandle()) return true;
        if (getU8DeviceHandle() > rhs.getU8DeviceHandle()) return false;
    }
    if (hasSUUID() || rhs.hasSUUID()) {
        if (getSUUID() < rhs.getSUUID()) return true;
        if (getSUUID() > rhs.getSUUID()) return false;
    }
    if (hasE8SPPConnectionStatus() || rhs.hasE8SPPConnectionStatus()) {
        if ((uint32)getE8SPPConnectionStatus() < (uint32)rhs.getE8SPPConnectionStatus()) return true;
        if ((uint32)getE8SPPConnectionStatus() > (uint32)rhs.getE8SPPConnectionStatus()) return false;
    }
    if (hasE8SPPDisconnectionReason() || rhs.hasE8SPPDisconnectionReason()) {
        if ((uint32)getE8SPPDisconnectionReason() < (uint32)rhs.getE8SPPDisconnectionReason()) return true;
        if ((uint32)getE8SPPDisconnectionReason() > (uint32)rhs.getE8SPPDisconnectionReason()) return false;
    }
    if (hasSRFCommID() || rhs.hasSRFCommID()) {
        if (getSRFCommID() < rhs.getSRFCommID()) return true;
        if (getSRFCommID() > rhs.getSRFCommID()) return false;
    }
    return false;
}

inline bool T_BTSPPServiceConnectionStatusListItem::operator > (const T_BTSPPServiceConnectionStatusListItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_BTSPPServiceConnectionStatusListItem::clear() {
    clearU8DeviceHandle();
    clearSUUID();
    clearE8SPPConnectionStatus();
    clearE8SPPDisconnectionReason();
    clearSRFCommID();
}

inline void T_BTSPPServiceConnectionStatusListItem::clearU8DeviceHandle() {
    if (hasU8DeviceHandle()) {
         clear_has_u8DeviceHandle();
        _u8DeviceHandle = 0u;
     }
}

inline bool T_BTSPPServiceConnectionStatusListItem::hasU8DeviceHandle () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_BTSPPServiceConnectionStatusListItem::getU8DeviceHandle () const {
    return _u8DeviceHandle;
}

inline void T_BTSPPServiceConnectionStatusListItem::setU8DeviceHandle (uint8 u8DeviceHandle_) {
    set_has_u8DeviceHandle();
    this->_u8DeviceHandle = u8DeviceHandle_;
}

inline void T_BTSPPServiceConnectionStatusListItem::clearSUUID() {
    if (hasSUUID()) {
         clear_has_sUUID();
        _sUUID.clear();
     }
}

inline bool T_BTSPPServiceConnectionStatusListItem::hasSUUID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_BTSPPServiceConnectionStatusListItem::getSUUID () const {
    return _sUUID;
}

inline ::fi_basetypes_most::T_String& T_BTSPPServiceConnectionStatusListItem::getSUUIDMutable () {
    set_has_sUUID();
    return _sUUID;
}

inline void T_BTSPPServiceConnectionStatusListItem::setSUUID (const ::fi_basetypes_most::T_String& sUUID_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sUUID_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sUUID();
    this->_sUUID = sUUID_;
}

inline void T_BTSPPServiceConnectionStatusListItem::clearE8SPPConnectionStatus() {
    if (hasE8SPPConnectionStatus()) {
         clear_has_e8SPPConnectionStatus();
        _e8SPPConnectionStatus = ::most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus__e8STATUS_NOT_CONNECT;
     }
}

inline bool T_BTSPPServiceConnectionStatusListItem::hasE8SPPConnectionStatus () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_BTConnectionStatus T_BTSPPServiceConnectionStatusListItem::getE8SPPConnectionStatus () const {
    return _e8SPPConnectionStatus;
}

inline void T_BTSPPServiceConnectionStatusListItem::setE8SPPConnectionStatus (T_e8_BTConnectionStatus e8SPPConnectionStatus_) {
    #ifndef NDEBUG
    if (!(T_e8_BTConnectionStatus_IsValid(e8SPPConnectionStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8SPPConnectionStatus_, "T_e8_BTConnectionStatus", "e8SPPConnectionStatus", "T_BTSPPServiceConnectionStatusListItem");
    }
    #endif
    set_has_e8SPPConnectionStatus();
    this->_e8SPPConnectionStatus = e8SPPConnectionStatus_;
}

inline void T_BTSPPServiceConnectionStatusListItem::clearE8SPPDisconnectionReason() {
    if (hasE8SPPDisconnectionReason()) {
         clear_has_e8SPPDisconnectionReason();
        _e8SPPDisconnectionReason = ::most_BTSet_fi_types_Extended::T_e8_BTDisconnectionReason__e8NOT_APPLICABLE;
     }
}

inline bool T_BTSPPServiceConnectionStatusListItem::hasE8SPPDisconnectionReason () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline T_e8_BTDisconnectionReason T_BTSPPServiceConnectionStatusListItem::getE8SPPDisconnectionReason () const {
    return _e8SPPDisconnectionReason;
}

inline void T_BTSPPServiceConnectionStatusListItem::setE8SPPDisconnectionReason (T_e8_BTDisconnectionReason e8SPPDisconnectionReason_) {
    #ifndef NDEBUG
    if (!(T_e8_BTDisconnectionReason_IsValid(e8SPPDisconnectionReason_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8SPPDisconnectionReason_, "T_e8_BTDisconnectionReason", "e8SPPDisconnectionReason", "T_BTSPPServiceConnectionStatusListItem");
    }
    #endif
    set_has_e8SPPDisconnectionReason();
    this->_e8SPPDisconnectionReason = e8SPPDisconnectionReason_;
}

inline void T_BTSPPServiceConnectionStatusListItem::clearSRFCommID() {
    if (hasSRFCommID()) {
         clear_has_sRFCommID();
        _sRFCommID.clear();
     }
}

inline bool T_BTSPPServiceConnectionStatusListItem::hasSRFCommID () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_BTSPPServiceConnectionStatusListItem::getSRFCommID () const {
    return _sRFCommID;
}

inline ::fi_basetypes_most::T_String& T_BTSPPServiceConnectionStatusListItem::getSRFCommIDMutable () {
    set_has_sRFCommID();
    return _sRFCommID;
}

inline void T_BTSPPServiceConnectionStatusListItem::setSRFCommID (const ::fi_basetypes_most::T_String& sRFCommID_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sRFCommID_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sRFCommID();
    this->_sRFCommID = sRFCommID_;
}

inline void T_BTSPPServiceConnectionStatusListItem::set_has_u8DeviceHandle () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_BTSPPServiceConnectionStatusListItem::clear_has_u8DeviceHandle () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_BTSPPServiceConnectionStatusListItem::set_has_sUUID () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_BTSPPServiceConnectionStatusListItem::clear_has_sUUID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_BTSPPServiceConnectionStatusListItem::set_has_e8SPPConnectionStatus () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_BTSPPServiceConnectionStatusListItem::clear_has_e8SPPConnectionStatus () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_BTSPPServiceConnectionStatusListItem::set_has_e8SPPDisconnectionReason () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_BTSPPServiceConnectionStatusListItem::clear_has_e8SPPDisconnectionReason () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_BTSPPServiceConnectionStatusListItem::set_has_sRFCommID () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_BTSPPServiceConnectionStatusListItem::clear_has_sRFCommID () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  T_BTSetVisibleDeviceItem::T_BTSetVisibleDeviceItem ()  :
    _sBluetoothDeviceAddress (),
    _sDeviceName (),
    _oSupportedProfiles (),
    _e8VisibleDeviceConnectionStatus (::most_BTSet_fi_types_Extended::T_e8_BTSetVisibleDeviceConnectionStatus__e8UNKNOWN)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_BTSetVisibleDeviceItem::T_BTSetVisibleDeviceItem (const T_BTSetVisibleDeviceItem &rhs)  :
    _sBluetoothDeviceAddress (),
    _sDeviceName (),
    _oSupportedProfiles (),
    _e8VisibleDeviceConnectionStatus (::most_BTSet_fi_types_Extended::T_e8_BTSetVisibleDeviceConnectionStatus__e8UNKNOWN)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_BTSetVisibleDeviceItem::T_BTSetVisibleDeviceItem (const ::fi_basetypes_most::T_String& sBluetoothDeviceAddress_, const ::fi_basetypes_most::T_String& sDeviceName_, const T_BTSetSupportedProfiles& oSupportedProfiles_, T_e8_BTSetVisibleDeviceConnectionStatus e8VisibleDeviceConnectionStatus_)  :
    _sBluetoothDeviceAddress (sBluetoothDeviceAddress_),
    _sDeviceName (sDeviceName_),
    _oSupportedProfiles (oSupportedProfiles_),
    _e8VisibleDeviceConnectionStatus (e8VisibleDeviceConnectionStatus_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sBluetoothDeviceAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e8_BTSetVisibleDeviceConnectionStatus_IsValid(e8VisibleDeviceConnectionStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8VisibleDeviceConnectionStatus_, "T_e8_BTSetVisibleDeviceConnectionStatus", "e8VisibleDeviceConnectionStatus", "T_BTSetVisibleDeviceItem");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_BTSetVisibleDeviceItem::~T_BTSetVisibleDeviceItem() {
}

inline T_BTSetVisibleDeviceItem& T_BTSetVisibleDeviceItem::operator = (const T_BTSetVisibleDeviceItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSBluetoothDeviceAddress()) {
            setSBluetoothDeviceAddress(rhs.getSBluetoothDeviceAddress());
        } else {
            clearSBluetoothDeviceAddress();
        }
        if (rhs.hasSDeviceName()) {
            setSDeviceName(rhs.getSDeviceName());
        } else {
            clearSDeviceName();
        }
        if (rhs.hasOSupportedProfiles()) {
            setOSupportedProfiles(rhs.getOSupportedProfiles());
        } else {
            clearOSupportedProfiles();
        }
        if (rhs.hasE8VisibleDeviceConnectionStatus()) {
            setE8VisibleDeviceConnectionStatus(rhs.getE8VisibleDeviceConnectionStatus());
        } else {
            clearE8VisibleDeviceConnectionStatus();
        }
    }
    return *this;
}

inline bool T_BTSetVisibleDeviceItem::operator == (const T_BTSetVisibleDeviceItem& rhs) const {
    return (((!hasSBluetoothDeviceAddress() && !rhs.hasSBluetoothDeviceAddress()) || getSBluetoothDeviceAddress() == rhs.getSBluetoothDeviceAddress()) &&
        ((!hasSDeviceName() && !rhs.hasSDeviceName()) || getSDeviceName() == rhs.getSDeviceName()) &&
        ((!hasOSupportedProfiles() && !rhs.hasOSupportedProfiles()) || getOSupportedProfiles() == rhs.getOSupportedProfiles()) &&
        ((!hasE8VisibleDeviceConnectionStatus() && !rhs.hasE8VisibleDeviceConnectionStatus()) || getE8VisibleDeviceConnectionStatus() == rhs.getE8VisibleDeviceConnectionStatus()));
}

inline bool T_BTSetVisibleDeviceItem::operator != (const T_BTSetVisibleDeviceItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_BTSetVisibleDeviceItem::operator < (const T_BTSetVisibleDeviceItem& rhs) const {
    if (hasSBluetoothDeviceAddress() || rhs.hasSBluetoothDeviceAddress()) {
        if (getSBluetoothDeviceAddress() < rhs.getSBluetoothDeviceAddress()) return true;
        if (getSBluetoothDeviceAddress() > rhs.getSBluetoothDeviceAddress()) return false;
    }
    if (hasSDeviceName() || rhs.hasSDeviceName()) {
        if (getSDeviceName() < rhs.getSDeviceName()) return true;
        if (getSDeviceName() > rhs.getSDeviceName()) return false;
    }
    if (hasOSupportedProfiles() || rhs.hasOSupportedProfiles()) {
        if (getOSupportedProfiles() < rhs.getOSupportedProfiles()) return true;
        if (getOSupportedProfiles() > rhs.getOSupportedProfiles()) return false;
    }
    if (hasE8VisibleDeviceConnectionStatus() || rhs.hasE8VisibleDeviceConnectionStatus()) {
        if ((uint32)getE8VisibleDeviceConnectionStatus() < (uint32)rhs.getE8VisibleDeviceConnectionStatus()) return true;
        if ((uint32)getE8VisibleDeviceConnectionStatus() > (uint32)rhs.getE8VisibleDeviceConnectionStatus()) return false;
    }
    return false;
}

inline bool T_BTSetVisibleDeviceItem::operator > (const T_BTSetVisibleDeviceItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_BTSetVisibleDeviceItem::clear() {
    clearSBluetoothDeviceAddress();
    clearSDeviceName();
    clearOSupportedProfiles();
    clearE8VisibleDeviceConnectionStatus();
}

inline void T_BTSetVisibleDeviceItem::clearSBluetoothDeviceAddress() {
    if (hasSBluetoothDeviceAddress()) {
         clear_has_sBluetoothDeviceAddress();
        _sBluetoothDeviceAddress.clear();
     }
}

inline bool T_BTSetVisibleDeviceItem::hasSBluetoothDeviceAddress () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_BTSetVisibleDeviceItem::getSBluetoothDeviceAddress () const {
    return _sBluetoothDeviceAddress;
}

inline ::fi_basetypes_most::T_String& T_BTSetVisibleDeviceItem::getSBluetoothDeviceAddressMutable () {
    set_has_sBluetoothDeviceAddress();
    return _sBluetoothDeviceAddress;
}

inline void T_BTSetVisibleDeviceItem::setSBluetoothDeviceAddress (const ::fi_basetypes_most::T_String& sBluetoothDeviceAddress_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sBluetoothDeviceAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sBluetoothDeviceAddress();
    this->_sBluetoothDeviceAddress = sBluetoothDeviceAddress_;
}

inline void T_BTSetVisibleDeviceItem::clearSDeviceName() {
    if (hasSDeviceName()) {
         clear_has_sDeviceName();
        _sDeviceName.clear();
     }
}

inline bool T_BTSetVisibleDeviceItem::hasSDeviceName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_BTSetVisibleDeviceItem::getSDeviceName () const {
    return _sDeviceName;
}

inline ::fi_basetypes_most::T_String& T_BTSetVisibleDeviceItem::getSDeviceNameMutable () {
    set_has_sDeviceName();
    return _sDeviceName;
}

inline void T_BTSetVisibleDeviceItem::setSDeviceName (const ::fi_basetypes_most::T_String& sDeviceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceName();
    this->_sDeviceName = sDeviceName_;
}

inline void T_BTSetVisibleDeviceItem::clearOSupportedProfiles() {
    if (hasOSupportedProfiles()) {
         clear_has_oSupportedProfiles();
        _oSupportedProfiles.clear();
     }
}

inline bool T_BTSetVisibleDeviceItem::hasOSupportedProfiles () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const T_BTSetSupportedProfiles& T_BTSetVisibleDeviceItem::getOSupportedProfiles () const {
    return _oSupportedProfiles;
}

inline T_BTSetSupportedProfiles& T_BTSetVisibleDeviceItem::getOSupportedProfilesMutable () {
    set_has_oSupportedProfiles();
    return _oSupportedProfiles;
}

inline void T_BTSetVisibleDeviceItem::setOSupportedProfiles (const T_BTSetSupportedProfiles& oSupportedProfiles_) {
    set_has_oSupportedProfiles();
    this->_oSupportedProfiles = oSupportedProfiles_;
}

inline void T_BTSetVisibleDeviceItem::clearE8VisibleDeviceConnectionStatus() {
    if (hasE8VisibleDeviceConnectionStatus()) {
         clear_has_e8VisibleDeviceConnectionStatus();
        _e8VisibleDeviceConnectionStatus = ::most_BTSet_fi_types_Extended::T_e8_BTSetVisibleDeviceConnectionStatus__e8UNKNOWN;
     }
}

inline bool T_BTSetVisibleDeviceItem::hasE8VisibleDeviceConnectionStatus () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline T_e8_BTSetVisibleDeviceConnectionStatus T_BTSetVisibleDeviceItem::getE8VisibleDeviceConnectionStatus () const {
    return _e8VisibleDeviceConnectionStatus;
}

inline void T_BTSetVisibleDeviceItem::setE8VisibleDeviceConnectionStatus (T_e8_BTSetVisibleDeviceConnectionStatus e8VisibleDeviceConnectionStatus_) {
    #ifndef NDEBUG
    if (!(T_e8_BTSetVisibleDeviceConnectionStatus_IsValid(e8VisibleDeviceConnectionStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8VisibleDeviceConnectionStatus_, "T_e8_BTSetVisibleDeviceConnectionStatus", "e8VisibleDeviceConnectionStatus", "T_BTSetVisibleDeviceItem");
    }
    #endif
    set_has_e8VisibleDeviceConnectionStatus();
    this->_e8VisibleDeviceConnectionStatus = e8VisibleDeviceConnectionStatus_;
}

inline void T_BTSetVisibleDeviceItem::set_has_sBluetoothDeviceAddress () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_BTSetVisibleDeviceItem::clear_has_sBluetoothDeviceAddress () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_BTSetVisibleDeviceItem::set_has_sDeviceName () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_BTSetVisibleDeviceItem::clear_has_sDeviceName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_BTSetVisibleDeviceItem::set_has_oSupportedProfiles () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_BTSetVisibleDeviceItem::clear_has_oSupportedProfiles () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_BTSetVisibleDeviceItem::set_has_e8VisibleDeviceConnectionStatus () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_BTSetVisibleDeviceItem::clear_has_e8VisibleDeviceConnectionStatus () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  T_BTSetSignalStrengthItem::T_BTSetSignalStrengthItem ()  :
    _u8DeviceHandle (0u),
    _s8SignalStrength (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_BTSetSignalStrengthItem::T_BTSetSignalStrengthItem (const T_BTSetSignalStrengthItem &rhs)  :
    _u8DeviceHandle (0u),
    _s8SignalStrength (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_BTSetSignalStrengthItem::T_BTSetSignalStrengthItem (uint8 u8DeviceHandle_, int8 s8SignalStrength_)  :
    _u8DeviceHandle (u8DeviceHandle_),
    _s8SignalStrength (s8SignalStrength_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_BTSetSignalStrengthItem::~T_BTSetSignalStrengthItem() {
}

inline T_BTSetSignalStrengthItem& T_BTSetSignalStrengthItem::operator = (const T_BTSetSignalStrengthItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8DeviceHandle()) {
            setU8DeviceHandle(rhs.getU8DeviceHandle());
        } else {
            clearU8DeviceHandle();
        }
        if (rhs.hasS8SignalStrength()) {
            setS8SignalStrength(rhs.getS8SignalStrength());
        } else {
            clearS8SignalStrength();
        }
    }
    return *this;
}

inline bool T_BTSetSignalStrengthItem::operator == (const T_BTSetSignalStrengthItem& rhs) const {
    return (((!hasU8DeviceHandle() && !rhs.hasU8DeviceHandle()) || getU8DeviceHandle() == rhs.getU8DeviceHandle()) &&
        ((!hasS8SignalStrength() && !rhs.hasS8SignalStrength()) || getS8SignalStrength() == rhs.getS8SignalStrength()));
}

inline bool T_BTSetSignalStrengthItem::operator != (const T_BTSetSignalStrengthItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_BTSetSignalStrengthItem::operator < (const T_BTSetSignalStrengthItem& rhs) const {
    if (hasU8DeviceHandle() || rhs.hasU8DeviceHandle()) {
        if (getU8DeviceHandle() < rhs.getU8DeviceHandle()) return true;
        if (getU8DeviceHandle() > rhs.getU8DeviceHandle()) return false;
    }
    if (hasS8SignalStrength() || rhs.hasS8SignalStrength()) {
        if (getS8SignalStrength() < rhs.getS8SignalStrength()) return true;
        if (getS8SignalStrength() > rhs.getS8SignalStrength()) return false;
    }
    return false;
}

inline bool T_BTSetSignalStrengthItem::operator > (const T_BTSetSignalStrengthItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_BTSetSignalStrengthItem::clear() {
    clearU8DeviceHandle();
    clearS8SignalStrength();
}

inline void T_BTSetSignalStrengthItem::clearU8DeviceHandle() {
    if (hasU8DeviceHandle()) {
         clear_has_u8DeviceHandle();
        _u8DeviceHandle = 0u;
     }
}

inline bool T_BTSetSignalStrengthItem::hasU8DeviceHandle () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_BTSetSignalStrengthItem::getU8DeviceHandle () const {
    return _u8DeviceHandle;
}

inline void T_BTSetSignalStrengthItem::setU8DeviceHandle (uint8 u8DeviceHandle_) {
    set_has_u8DeviceHandle();
    this->_u8DeviceHandle = u8DeviceHandle_;
}

inline void T_BTSetSignalStrengthItem::clearS8SignalStrength() {
    if (hasS8SignalStrength()) {
         clear_has_s8SignalStrength();
        _s8SignalStrength = 0;
     }
}

inline bool T_BTSetSignalStrengthItem::hasS8SignalStrength () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int8 T_BTSetSignalStrengthItem::getS8SignalStrength () const {
    return _s8SignalStrength;
}

inline void T_BTSetSignalStrengthItem::setS8SignalStrength (int8 s8SignalStrength_) {
    set_has_s8SignalStrength();
    this->_s8SignalStrength = s8SignalStrength_;
}

inline void T_BTSetSignalStrengthItem::set_has_u8DeviceHandle () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_BTSetSignalStrengthItem::clear_has_u8DeviceHandle () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_BTSetSignalStrengthItem::set_has_s8SignalStrength () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_BTSetSignalStrengthItem::clear_has_s8SignalStrength () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_BTSetDeviceListChangeExtended::T_BTSetDeviceListChangeExtended ()  :
    _u8DeviceHandle (0u),
    _e8DeviceStatus (::most_BTSet_fi_types::T_e8_BTSetDeviceStatus__e8DEVICE_CONNECTED),
    _e8DeviceDisconnectedReason (::most_BTSet_fi_types_Extended::T_e8_BTSetDeviceDisconnectedReason__e8NOT_APPLICABLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_BTSetDeviceListChangeExtended::T_BTSetDeviceListChangeExtended (const T_BTSetDeviceListChangeExtended &rhs)  :
    _u8DeviceHandle (0u),
    _e8DeviceStatus (::most_BTSet_fi_types::T_e8_BTSetDeviceStatus__e8DEVICE_CONNECTED),
    _e8DeviceDisconnectedReason (::most_BTSet_fi_types_Extended::T_e8_BTSetDeviceDisconnectedReason__e8NOT_APPLICABLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_BTSetDeviceListChangeExtended::T_BTSetDeviceListChangeExtended (uint8 u8DeviceHandle_, ::most_BTSet_fi_types::T_e8_BTSetDeviceStatus e8DeviceStatus_, T_e8_BTSetDeviceDisconnectedReason e8DeviceDisconnectedReason_)  :
    _u8DeviceHandle (u8DeviceHandle_),
    _e8DeviceStatus (e8DeviceStatus_),
    _e8DeviceDisconnectedReason (e8DeviceDisconnectedReason_)
{
    #ifndef NDEBUG
    if (!(::most_BTSet_fi_types::T_e8_BTSetDeviceStatus_IsValid(e8DeviceStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DeviceStatus_, "T_e8_BTSetDeviceStatus", "e8DeviceStatus", "T_BTSetDeviceListChangeExtended");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_BTSetDeviceDisconnectedReason_IsValid(e8DeviceDisconnectedReason_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DeviceDisconnectedReason_, "T_e8_BTSetDeviceDisconnectedReason", "e8DeviceDisconnectedReason", "T_BTSetDeviceListChangeExtended");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_BTSetDeviceListChangeExtended::~T_BTSetDeviceListChangeExtended() {
}

inline T_BTSetDeviceListChangeExtended& T_BTSetDeviceListChangeExtended::operator = (const T_BTSetDeviceListChangeExtended& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8DeviceHandle()) {
            setU8DeviceHandle(rhs.getU8DeviceHandle());
        } else {
            clearU8DeviceHandle();
        }
        if (rhs.hasE8DeviceStatus()) {
            setE8DeviceStatus(rhs.getE8DeviceStatus());
        } else {
            clearE8DeviceStatus();
        }
        if (rhs.hasE8DeviceDisconnectedReason()) {
            setE8DeviceDisconnectedReason(rhs.getE8DeviceDisconnectedReason());
        } else {
            clearE8DeviceDisconnectedReason();
        }
    }
    return *this;
}

inline bool T_BTSetDeviceListChangeExtended::operator == (const T_BTSetDeviceListChangeExtended& rhs) const {
    return (((!hasU8DeviceHandle() && !rhs.hasU8DeviceHandle()) || getU8DeviceHandle() == rhs.getU8DeviceHandle()) &&
        ((!hasE8DeviceStatus() && !rhs.hasE8DeviceStatus()) || getE8DeviceStatus() == rhs.getE8DeviceStatus()) &&
        ((!hasE8DeviceDisconnectedReason() && !rhs.hasE8DeviceDisconnectedReason()) || getE8DeviceDisconnectedReason() == rhs.getE8DeviceDisconnectedReason()));
}

inline bool T_BTSetDeviceListChangeExtended::operator != (const T_BTSetDeviceListChangeExtended& rhs) const {
    return ! (*this == rhs);
}

inline bool T_BTSetDeviceListChangeExtended::operator < (const T_BTSetDeviceListChangeExtended& rhs) const {
    if (hasU8DeviceHandle() || rhs.hasU8DeviceHandle()) {
        if (getU8DeviceHandle() < rhs.getU8DeviceHandle()) return true;
        if (getU8DeviceHandle() > rhs.getU8DeviceHandle()) return false;
    }
    if (hasE8DeviceStatus() || rhs.hasE8DeviceStatus()) {
        if ((uint32)getE8DeviceStatus() < (uint32)rhs.getE8DeviceStatus()) return true;
        if ((uint32)getE8DeviceStatus() > (uint32)rhs.getE8DeviceStatus()) return false;
    }
    if (hasE8DeviceDisconnectedReason() || rhs.hasE8DeviceDisconnectedReason()) {
        if ((uint32)getE8DeviceDisconnectedReason() < (uint32)rhs.getE8DeviceDisconnectedReason()) return true;
        if ((uint32)getE8DeviceDisconnectedReason() > (uint32)rhs.getE8DeviceDisconnectedReason()) return false;
    }
    return false;
}

inline bool T_BTSetDeviceListChangeExtended::operator > (const T_BTSetDeviceListChangeExtended& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_BTSetDeviceListChangeExtended::clear() {
    clearU8DeviceHandle();
    clearE8DeviceStatus();
    clearE8DeviceDisconnectedReason();
}

inline void T_BTSetDeviceListChangeExtended::clearU8DeviceHandle() {
    if (hasU8DeviceHandle()) {
         clear_has_u8DeviceHandle();
        _u8DeviceHandle = 0u;
     }
}

inline bool T_BTSetDeviceListChangeExtended::hasU8DeviceHandle () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_BTSetDeviceListChangeExtended::getU8DeviceHandle () const {
    return _u8DeviceHandle;
}

inline void T_BTSetDeviceListChangeExtended::setU8DeviceHandle (uint8 u8DeviceHandle_) {
    set_has_u8DeviceHandle();
    this->_u8DeviceHandle = u8DeviceHandle_;
}

inline void T_BTSetDeviceListChangeExtended::clearE8DeviceStatus() {
    if (hasE8DeviceStatus()) {
         clear_has_e8DeviceStatus();
        _e8DeviceStatus = ::most_BTSet_fi_types::T_e8_BTSetDeviceStatus__e8DEVICE_CONNECTED;
     }
}

inline bool T_BTSetDeviceListChangeExtended::hasE8DeviceStatus () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::most_BTSet_fi_types::T_e8_BTSetDeviceStatus T_BTSetDeviceListChangeExtended::getE8DeviceStatus () const {
    return _e8DeviceStatus;
}

inline void T_BTSetDeviceListChangeExtended::setE8DeviceStatus (::most_BTSet_fi_types::T_e8_BTSetDeviceStatus e8DeviceStatus_) {
    #ifndef NDEBUG
    if (!(::most_BTSet_fi_types::T_e8_BTSetDeviceStatus_IsValid(e8DeviceStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DeviceStatus_, "T_e8_BTSetDeviceStatus", "e8DeviceStatus", "T_BTSetDeviceListChangeExtended");
    }
    #endif
    set_has_e8DeviceStatus();
    this->_e8DeviceStatus = e8DeviceStatus_;
}

inline void T_BTSetDeviceListChangeExtended::clearE8DeviceDisconnectedReason() {
    if (hasE8DeviceDisconnectedReason()) {
         clear_has_e8DeviceDisconnectedReason();
        _e8DeviceDisconnectedReason = ::most_BTSet_fi_types_Extended::T_e8_BTSetDeviceDisconnectedReason__e8NOT_APPLICABLE;
     }
}

inline bool T_BTSetDeviceListChangeExtended::hasE8DeviceDisconnectedReason () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_BTSetDeviceDisconnectedReason T_BTSetDeviceListChangeExtended::getE8DeviceDisconnectedReason () const {
    return _e8DeviceDisconnectedReason;
}

inline void T_BTSetDeviceListChangeExtended::setE8DeviceDisconnectedReason (T_e8_BTSetDeviceDisconnectedReason e8DeviceDisconnectedReason_) {
    #ifndef NDEBUG
    if (!(T_e8_BTSetDeviceDisconnectedReason_IsValid(e8DeviceDisconnectedReason_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DeviceDisconnectedReason_, "T_e8_BTSetDeviceDisconnectedReason", "e8DeviceDisconnectedReason", "T_BTSetDeviceListChangeExtended");
    }
    #endif
    set_has_e8DeviceDisconnectedReason();
    this->_e8DeviceDisconnectedReason = e8DeviceDisconnectedReason_;
}

inline void T_BTSetDeviceListChangeExtended::set_has_u8DeviceHandle () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_BTSetDeviceListChangeExtended::clear_has_u8DeviceHandle () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_BTSetDeviceListChangeExtended::set_has_e8DeviceStatus () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_BTSetDeviceListChangeExtended::clear_has_e8DeviceStatus () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_BTSetDeviceListChangeExtended::set_has_e8DeviceDisconnectedReason () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_BTSetDeviceListChangeExtended::clear_has_e8DeviceDisconnectedReason () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_BTLimitationModeListItem::T_BTLimitationModeListItem ()  :
    _sBdAddress (),
    _sBdDeviceName (),
    _e8Technology (::most_BTSet_fi_types_Extended::T_e8_BTTechnology__IAP),
    _e8CommunicationChannel (::most_BTSet_fi_types_Extended::T_e8_BTCommunicationChannel__USB),
    _e8ActionState (::most_BTSet_fi_types_Extended::T_e8_BTLimitationActionState__IDLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_BTLimitationModeListItem::T_BTLimitationModeListItem (const T_BTLimitationModeListItem &rhs)  :
    _sBdAddress (),
    _sBdDeviceName (),
    _e8Technology (::most_BTSet_fi_types_Extended::T_e8_BTTechnology__IAP),
    _e8CommunicationChannel (::most_BTSet_fi_types_Extended::T_e8_BTCommunicationChannel__USB),
    _e8ActionState (::most_BTSet_fi_types_Extended::T_e8_BTLimitationActionState__IDLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_BTLimitationModeListItem::T_BTLimitationModeListItem (const ::fi_basetypes_most::T_String& sBdAddress_, const ::fi_basetypes_most::T_String& sBdDeviceName_, T_e8_BTTechnology e8Technology_, T_e8_BTCommunicationChannel e8CommunicationChannel_, T_e8_BTLimitationActionState e8ActionState_)  :
    _sBdAddress (sBdAddress_),
    _sBdDeviceName (sBdDeviceName_),
    _e8Technology (e8Technology_),
    _e8CommunicationChannel (e8CommunicationChannel_),
    _e8ActionState (e8ActionState_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sBdAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sBdDeviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e8_BTTechnology_IsValid(e8Technology_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Technology_, "T_e8_BTTechnology", "e8Technology", "T_BTLimitationModeListItem");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_BTCommunicationChannel_IsValid(e8CommunicationChannel_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8CommunicationChannel_, "T_e8_BTCommunicationChannel", "e8CommunicationChannel", "T_BTLimitationModeListItem");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_BTLimitationActionState_IsValid(e8ActionState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8ActionState_, "T_e8_BTLimitationActionState", "e8ActionState", "T_BTLimitationModeListItem");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_BTLimitationModeListItem::~T_BTLimitationModeListItem() {
}

inline T_BTLimitationModeListItem& T_BTLimitationModeListItem::operator = (const T_BTLimitationModeListItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSBdAddress()) {
            setSBdAddress(rhs.getSBdAddress());
        } else {
            clearSBdAddress();
        }
        if (rhs.hasSBdDeviceName()) {
            setSBdDeviceName(rhs.getSBdDeviceName());
        } else {
            clearSBdDeviceName();
        }
        if (rhs.hasE8Technology()) {
            setE8Technology(rhs.getE8Technology());
        } else {
            clearE8Technology();
        }
        if (rhs.hasE8CommunicationChannel()) {
            setE8CommunicationChannel(rhs.getE8CommunicationChannel());
        } else {
            clearE8CommunicationChannel();
        }
        if (rhs.hasE8ActionState()) {
            setE8ActionState(rhs.getE8ActionState());
        } else {
            clearE8ActionState();
        }
    }
    return *this;
}

inline bool T_BTLimitationModeListItem::operator == (const T_BTLimitationModeListItem& rhs) const {
    return (((!hasSBdAddress() && !rhs.hasSBdAddress()) || getSBdAddress() == rhs.getSBdAddress()) &&
        ((!hasSBdDeviceName() && !rhs.hasSBdDeviceName()) || getSBdDeviceName() == rhs.getSBdDeviceName()) &&
        ((!hasE8Technology() && !rhs.hasE8Technology()) || getE8Technology() == rhs.getE8Technology()) &&
        ((!hasE8CommunicationChannel() && !rhs.hasE8CommunicationChannel()) || getE8CommunicationChannel() == rhs.getE8CommunicationChannel()) &&
        ((!hasE8ActionState() && !rhs.hasE8ActionState()) || getE8ActionState() == rhs.getE8ActionState()));
}

inline bool T_BTLimitationModeListItem::operator != (const T_BTLimitationModeListItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_BTLimitationModeListItem::operator < (const T_BTLimitationModeListItem& rhs) const {
    if (hasSBdAddress() || rhs.hasSBdAddress()) {
        if (getSBdAddress() < rhs.getSBdAddress()) return true;
        if (getSBdAddress() > rhs.getSBdAddress()) return false;
    }
    if (hasSBdDeviceName() || rhs.hasSBdDeviceName()) {
        if (getSBdDeviceName() < rhs.getSBdDeviceName()) return true;
        if (getSBdDeviceName() > rhs.getSBdDeviceName()) return false;
    }
    if (hasE8Technology() || rhs.hasE8Technology()) {
        if ((uint32)getE8Technology() < (uint32)rhs.getE8Technology()) return true;
        if ((uint32)getE8Technology() > (uint32)rhs.getE8Technology()) return false;
    }
    if (hasE8CommunicationChannel() || rhs.hasE8CommunicationChannel()) {
        if ((uint32)getE8CommunicationChannel() < (uint32)rhs.getE8CommunicationChannel()) return true;
        if ((uint32)getE8CommunicationChannel() > (uint32)rhs.getE8CommunicationChannel()) return false;
    }
    if (hasE8ActionState() || rhs.hasE8ActionState()) {
        if ((uint32)getE8ActionState() < (uint32)rhs.getE8ActionState()) return true;
        if ((uint32)getE8ActionState() > (uint32)rhs.getE8ActionState()) return false;
    }
    return false;
}

inline bool T_BTLimitationModeListItem::operator > (const T_BTLimitationModeListItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_BTLimitationModeListItem::clear() {
    clearSBdAddress();
    clearSBdDeviceName();
    clearE8Technology();
    clearE8CommunicationChannel();
    clearE8ActionState();
}

inline void T_BTLimitationModeListItem::clearSBdAddress() {
    if (hasSBdAddress()) {
         clear_has_sBdAddress();
        _sBdAddress.clear();
     }
}

inline bool T_BTLimitationModeListItem::hasSBdAddress () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_BTLimitationModeListItem::getSBdAddress () const {
    return _sBdAddress;
}

inline ::fi_basetypes_most::T_String& T_BTLimitationModeListItem::getSBdAddressMutable () {
    set_has_sBdAddress();
    return _sBdAddress;
}

inline void T_BTLimitationModeListItem::setSBdAddress (const ::fi_basetypes_most::T_String& sBdAddress_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sBdAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sBdAddress();
    this->_sBdAddress = sBdAddress_;
}

inline void T_BTLimitationModeListItem::clearSBdDeviceName() {
    if (hasSBdDeviceName()) {
         clear_has_sBdDeviceName();
        _sBdDeviceName.clear();
     }
}

inline bool T_BTLimitationModeListItem::hasSBdDeviceName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_BTLimitationModeListItem::getSBdDeviceName () const {
    return _sBdDeviceName;
}

inline ::fi_basetypes_most::T_String& T_BTLimitationModeListItem::getSBdDeviceNameMutable () {
    set_has_sBdDeviceName();
    return _sBdDeviceName;
}

inline void T_BTLimitationModeListItem::setSBdDeviceName (const ::fi_basetypes_most::T_String& sBdDeviceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sBdDeviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sBdDeviceName();
    this->_sBdDeviceName = sBdDeviceName_;
}

inline void T_BTLimitationModeListItem::clearE8Technology() {
    if (hasE8Technology()) {
         clear_has_e8Technology();
        _e8Technology = ::most_BTSet_fi_types_Extended::T_e8_BTTechnology__IAP;
     }
}

inline bool T_BTLimitationModeListItem::hasE8Technology () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_BTTechnology T_BTLimitationModeListItem::getE8Technology () const {
    return _e8Technology;
}

inline void T_BTLimitationModeListItem::setE8Technology (T_e8_BTTechnology e8Technology_) {
    #ifndef NDEBUG
    if (!(T_e8_BTTechnology_IsValid(e8Technology_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Technology_, "T_e8_BTTechnology", "e8Technology", "T_BTLimitationModeListItem");
    }
    #endif
    set_has_e8Technology();
    this->_e8Technology = e8Technology_;
}

inline void T_BTLimitationModeListItem::clearE8CommunicationChannel() {
    if (hasE8CommunicationChannel()) {
         clear_has_e8CommunicationChannel();
        _e8CommunicationChannel = ::most_BTSet_fi_types_Extended::T_e8_BTCommunicationChannel__USB;
     }
}

inline bool T_BTLimitationModeListItem::hasE8CommunicationChannel () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline T_e8_BTCommunicationChannel T_BTLimitationModeListItem::getE8CommunicationChannel () const {
    return _e8CommunicationChannel;
}

inline void T_BTLimitationModeListItem::setE8CommunicationChannel (T_e8_BTCommunicationChannel e8CommunicationChannel_) {
    #ifndef NDEBUG
    if (!(T_e8_BTCommunicationChannel_IsValid(e8CommunicationChannel_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8CommunicationChannel_, "T_e8_BTCommunicationChannel", "e8CommunicationChannel", "T_BTLimitationModeListItem");
    }
    #endif
    set_has_e8CommunicationChannel();
    this->_e8CommunicationChannel = e8CommunicationChannel_;
}

inline void T_BTLimitationModeListItem::clearE8ActionState() {
    if (hasE8ActionState()) {
         clear_has_e8ActionState();
        _e8ActionState = ::most_BTSet_fi_types_Extended::T_e8_BTLimitationActionState__IDLE;
     }
}

inline bool T_BTLimitationModeListItem::hasE8ActionState () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline T_e8_BTLimitationActionState T_BTLimitationModeListItem::getE8ActionState () const {
    return _e8ActionState;
}

inline void T_BTLimitationModeListItem::setE8ActionState (T_e8_BTLimitationActionState e8ActionState_) {
    #ifndef NDEBUG
    if (!(T_e8_BTLimitationActionState_IsValid(e8ActionState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8ActionState_, "T_e8_BTLimitationActionState", "e8ActionState", "T_BTLimitationModeListItem");
    }
    #endif
    set_has_e8ActionState();
    this->_e8ActionState = e8ActionState_;
}

inline void T_BTLimitationModeListItem::set_has_sBdAddress () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_BTLimitationModeListItem::clear_has_sBdAddress () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_BTLimitationModeListItem::set_has_sBdDeviceName () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_BTLimitationModeListItem::clear_has_sBdDeviceName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_BTLimitationModeListItem::set_has_e8Technology () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_BTLimitationModeListItem::clear_has_e8Technology () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_BTLimitationModeListItem::set_has_e8CommunicationChannel () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_BTLimitationModeListItem::clear_has_e8CommunicationChannel () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_BTLimitationModeListItem::set_has_e8ActionState () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_BTLimitationModeListItem::clear_has_e8ActionState () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  T_BTLimitationMode::T_BTLimitationMode ()  :
    _sBdAddress (),
    _sBdDeviceName (),
    _e8Technology (::most_BTSet_fi_types_Extended::T_e8_BTTechnology__IAP),
    _e8CommunicationChannel (::most_BTSet_fi_types_Extended::T_e8_BTCommunicationChannel__USB),
    _e8Action (::most_BTSet_fi_types_Extended::T_e8_BTLimitationAction__PREPARE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_BTLimitationMode::T_BTLimitationMode (const T_BTLimitationMode &rhs)  :
    _sBdAddress (),
    _sBdDeviceName (),
    _e8Technology (::most_BTSet_fi_types_Extended::T_e8_BTTechnology__IAP),
    _e8CommunicationChannel (::most_BTSet_fi_types_Extended::T_e8_BTCommunicationChannel__USB),
    _e8Action (::most_BTSet_fi_types_Extended::T_e8_BTLimitationAction__PREPARE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_BTLimitationMode::T_BTLimitationMode (const ::fi_basetypes_most::T_String& sBdAddress_, const ::fi_basetypes_most::T_String& sBdDeviceName_, T_e8_BTTechnology e8Technology_, T_e8_BTCommunicationChannel e8CommunicationChannel_, T_e8_BTLimitationAction e8Action_)  :
    _sBdAddress (sBdAddress_),
    _sBdDeviceName (sBdDeviceName_),
    _e8Technology (e8Technology_),
    _e8CommunicationChannel (e8CommunicationChannel_),
    _e8Action (e8Action_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sBdAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sBdDeviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e8_BTTechnology_IsValid(e8Technology_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Technology_, "T_e8_BTTechnology", "e8Technology", "T_BTLimitationMode");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_BTCommunicationChannel_IsValid(e8CommunicationChannel_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8CommunicationChannel_, "T_e8_BTCommunicationChannel", "e8CommunicationChannel", "T_BTLimitationMode");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_BTLimitationAction_IsValid(e8Action_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Action_, "T_e8_BTLimitationAction", "e8Action", "T_BTLimitationMode");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_BTLimitationMode::~T_BTLimitationMode() {
}

inline T_BTLimitationMode& T_BTLimitationMode::operator = (const T_BTLimitationMode& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSBdAddress()) {
            setSBdAddress(rhs.getSBdAddress());
        } else {
            clearSBdAddress();
        }
        if (rhs.hasSBdDeviceName()) {
            setSBdDeviceName(rhs.getSBdDeviceName());
        } else {
            clearSBdDeviceName();
        }
        if (rhs.hasE8Technology()) {
            setE8Technology(rhs.getE8Technology());
        } else {
            clearE8Technology();
        }
        if (rhs.hasE8CommunicationChannel()) {
            setE8CommunicationChannel(rhs.getE8CommunicationChannel());
        } else {
            clearE8CommunicationChannel();
        }
        if (rhs.hasE8Action()) {
            setE8Action(rhs.getE8Action());
        } else {
            clearE8Action();
        }
    }
    return *this;
}

inline bool T_BTLimitationMode::operator == (const T_BTLimitationMode& rhs) const {
    return (((!hasSBdAddress() && !rhs.hasSBdAddress()) || getSBdAddress() == rhs.getSBdAddress()) &&
        ((!hasSBdDeviceName() && !rhs.hasSBdDeviceName()) || getSBdDeviceName() == rhs.getSBdDeviceName()) &&
        ((!hasE8Technology() && !rhs.hasE8Technology()) || getE8Technology() == rhs.getE8Technology()) &&
        ((!hasE8CommunicationChannel() && !rhs.hasE8CommunicationChannel()) || getE8CommunicationChannel() == rhs.getE8CommunicationChannel()) &&
        ((!hasE8Action() && !rhs.hasE8Action()) || getE8Action() == rhs.getE8Action()));
}

inline bool T_BTLimitationMode::operator != (const T_BTLimitationMode& rhs) const {
    return ! (*this == rhs);
}

inline bool T_BTLimitationMode::operator < (const T_BTLimitationMode& rhs) const {
    if (hasSBdAddress() || rhs.hasSBdAddress()) {
        if (getSBdAddress() < rhs.getSBdAddress()) return true;
        if (getSBdAddress() > rhs.getSBdAddress()) return false;
    }
    if (hasSBdDeviceName() || rhs.hasSBdDeviceName()) {
        if (getSBdDeviceName() < rhs.getSBdDeviceName()) return true;
        if (getSBdDeviceName() > rhs.getSBdDeviceName()) return false;
    }
    if (hasE8Technology() || rhs.hasE8Technology()) {
        if ((uint32)getE8Technology() < (uint32)rhs.getE8Technology()) return true;
        if ((uint32)getE8Technology() > (uint32)rhs.getE8Technology()) return false;
    }
    if (hasE8CommunicationChannel() || rhs.hasE8CommunicationChannel()) {
        if ((uint32)getE8CommunicationChannel() < (uint32)rhs.getE8CommunicationChannel()) return true;
        if ((uint32)getE8CommunicationChannel() > (uint32)rhs.getE8CommunicationChannel()) return false;
    }
    if (hasE8Action() || rhs.hasE8Action()) {
        if ((uint32)getE8Action() < (uint32)rhs.getE8Action()) return true;
        if ((uint32)getE8Action() > (uint32)rhs.getE8Action()) return false;
    }
    return false;
}

inline bool T_BTLimitationMode::operator > (const T_BTLimitationMode& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_BTLimitationMode::clear() {
    clearSBdAddress();
    clearSBdDeviceName();
    clearE8Technology();
    clearE8CommunicationChannel();
    clearE8Action();
}

inline void T_BTLimitationMode::clearSBdAddress() {
    if (hasSBdAddress()) {
         clear_has_sBdAddress();
        _sBdAddress.clear();
     }
}

inline bool T_BTLimitationMode::hasSBdAddress () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_BTLimitationMode::getSBdAddress () const {
    return _sBdAddress;
}

inline ::fi_basetypes_most::T_String& T_BTLimitationMode::getSBdAddressMutable () {
    set_has_sBdAddress();
    return _sBdAddress;
}

inline void T_BTLimitationMode::setSBdAddress (const ::fi_basetypes_most::T_String& sBdAddress_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sBdAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sBdAddress();
    this->_sBdAddress = sBdAddress_;
}

inline void T_BTLimitationMode::clearSBdDeviceName() {
    if (hasSBdDeviceName()) {
         clear_has_sBdDeviceName();
        _sBdDeviceName.clear();
     }
}

inline bool T_BTLimitationMode::hasSBdDeviceName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_BTLimitationMode::getSBdDeviceName () const {
    return _sBdDeviceName;
}

inline ::fi_basetypes_most::T_String& T_BTLimitationMode::getSBdDeviceNameMutable () {
    set_has_sBdDeviceName();
    return _sBdDeviceName;
}

inline void T_BTLimitationMode::setSBdDeviceName (const ::fi_basetypes_most::T_String& sBdDeviceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sBdDeviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sBdDeviceName();
    this->_sBdDeviceName = sBdDeviceName_;
}

inline void T_BTLimitationMode::clearE8Technology() {
    if (hasE8Technology()) {
         clear_has_e8Technology();
        _e8Technology = ::most_BTSet_fi_types_Extended::T_e8_BTTechnology__IAP;
     }
}

inline bool T_BTLimitationMode::hasE8Technology () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_BTTechnology T_BTLimitationMode::getE8Technology () const {
    return _e8Technology;
}

inline void T_BTLimitationMode::setE8Technology (T_e8_BTTechnology e8Technology_) {
    #ifndef NDEBUG
    if (!(T_e8_BTTechnology_IsValid(e8Technology_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Technology_, "T_e8_BTTechnology", "e8Technology", "T_BTLimitationMode");
    }
    #endif
    set_has_e8Technology();
    this->_e8Technology = e8Technology_;
}

inline void T_BTLimitationMode::clearE8CommunicationChannel() {
    if (hasE8CommunicationChannel()) {
         clear_has_e8CommunicationChannel();
        _e8CommunicationChannel = ::most_BTSet_fi_types_Extended::T_e8_BTCommunicationChannel__USB;
     }
}

inline bool T_BTLimitationMode::hasE8CommunicationChannel () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline T_e8_BTCommunicationChannel T_BTLimitationMode::getE8CommunicationChannel () const {
    return _e8CommunicationChannel;
}

inline void T_BTLimitationMode::setE8CommunicationChannel (T_e8_BTCommunicationChannel e8CommunicationChannel_) {
    #ifndef NDEBUG
    if (!(T_e8_BTCommunicationChannel_IsValid(e8CommunicationChannel_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8CommunicationChannel_, "T_e8_BTCommunicationChannel", "e8CommunicationChannel", "T_BTLimitationMode");
    }
    #endif
    set_has_e8CommunicationChannel();
    this->_e8CommunicationChannel = e8CommunicationChannel_;
}

inline void T_BTLimitationMode::clearE8Action() {
    if (hasE8Action()) {
         clear_has_e8Action();
        _e8Action = ::most_BTSet_fi_types_Extended::T_e8_BTLimitationAction__PREPARE;
     }
}

inline bool T_BTLimitationMode::hasE8Action () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline T_e8_BTLimitationAction T_BTLimitationMode::getE8Action () const {
    return _e8Action;
}

inline void T_BTLimitationMode::setE8Action (T_e8_BTLimitationAction e8Action_) {
    #ifndef NDEBUG
    if (!(T_e8_BTLimitationAction_IsValid(e8Action_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Action_, "T_e8_BTLimitationAction", "e8Action", "T_BTLimitationMode");
    }
    #endif
    set_has_e8Action();
    this->_e8Action = e8Action_;
}

inline void T_BTLimitationMode::set_has_sBdAddress () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_BTLimitationMode::clear_has_sBdAddress () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_BTLimitationMode::set_has_sBdDeviceName () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_BTLimitationMode::clear_has_sBdDeviceName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_BTLimitationMode::set_has_e8Technology () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_BTLimitationMode::clear_has_e8Technology () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_BTLimitationMode::set_has_e8CommunicationChannel () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_BTLimitationMode::clear_has_e8CommunicationChannel () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_BTLimitationMode::set_has_e8Action () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_BTLimitationMode::clear_has_e8Action () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  T_BTProfilesUsageInfo::T_BTProfilesUsageInfo ()  :
    _e8BTProfile (::most_BTSet_fi_types_Extended::T_e8_BTProfile__e8BT_PROFILE_NONE),
    _sUUID (),
    _e8BTProfileUsageType (::most_BTSet_fi_types_Extended::T_e8_BTProfileUsageType__e8PROFILE_USAGE_NONE),
    _bInUse (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_BTProfilesUsageInfo::T_BTProfilesUsageInfo (const T_BTProfilesUsageInfo &rhs)  :
    _e8BTProfile (::most_BTSet_fi_types_Extended::T_e8_BTProfile__e8BT_PROFILE_NONE),
    _sUUID (),
    _e8BTProfileUsageType (::most_BTSet_fi_types_Extended::T_e8_BTProfileUsageType__e8PROFILE_USAGE_NONE),
    _bInUse (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_BTProfilesUsageInfo::T_BTProfilesUsageInfo (T_e8_BTProfile e8BTProfile_, const ::fi_basetypes_most::T_String& sUUID_, T_e8_BTProfileUsageType e8BTProfileUsageType_, bool bInUse_)  :
    _e8BTProfile (e8BTProfile_),
    _sUUID (sUUID_),
    _e8BTProfileUsageType (e8BTProfileUsageType_),
    _bInUse (bInUse_)
{
    #ifndef NDEBUG
    if (!(T_e8_BTProfile_IsValid(e8BTProfile_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8BTProfile_, "T_e8_BTProfile", "e8BTProfile", "T_BTProfilesUsageInfo");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sUUID_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e8_BTProfileUsageType_IsValid(e8BTProfileUsageType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8BTProfileUsageType_, "T_e8_BTProfileUsageType", "e8BTProfileUsageType", "T_BTProfilesUsageInfo");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_BTProfilesUsageInfo::~T_BTProfilesUsageInfo() {
}

inline T_BTProfilesUsageInfo& T_BTProfilesUsageInfo::operator = (const T_BTProfilesUsageInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE8BTProfile()) {
            setE8BTProfile(rhs.getE8BTProfile());
        } else {
            clearE8BTProfile();
        }
        if (rhs.hasSUUID()) {
            setSUUID(rhs.getSUUID());
        } else {
            clearSUUID();
        }
        if (rhs.hasE8BTProfileUsageType()) {
            setE8BTProfileUsageType(rhs.getE8BTProfileUsageType());
        } else {
            clearE8BTProfileUsageType();
        }
        if (rhs.hasBInUse()) {
            setBInUse(rhs.getBInUse());
        } else {
            clearBInUse();
        }
    }
    return *this;
}

inline bool T_BTProfilesUsageInfo::operator == (const T_BTProfilesUsageInfo& rhs) const {
    return (((!hasE8BTProfile() && !rhs.hasE8BTProfile()) || getE8BTProfile() == rhs.getE8BTProfile()) &&
        ((!hasSUUID() && !rhs.hasSUUID()) || getSUUID() == rhs.getSUUID()) &&
        ((!hasE8BTProfileUsageType() && !rhs.hasE8BTProfileUsageType()) || getE8BTProfileUsageType() == rhs.getE8BTProfileUsageType()) &&
        ((!hasBInUse() && !rhs.hasBInUse()) || getBInUse() == rhs.getBInUse()));
}

inline bool T_BTProfilesUsageInfo::operator != (const T_BTProfilesUsageInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_BTProfilesUsageInfo::operator < (const T_BTProfilesUsageInfo& rhs) const {
    if (hasE8BTProfile() || rhs.hasE8BTProfile()) {
        if ((uint32)getE8BTProfile() < (uint32)rhs.getE8BTProfile()) return true;
        if ((uint32)getE8BTProfile() > (uint32)rhs.getE8BTProfile()) return false;
    }
    if (hasSUUID() || rhs.hasSUUID()) {
        if (getSUUID() < rhs.getSUUID()) return true;
        if (getSUUID() > rhs.getSUUID()) return false;
    }
    if (hasE8BTProfileUsageType() || rhs.hasE8BTProfileUsageType()) {
        if ((uint32)getE8BTProfileUsageType() < (uint32)rhs.getE8BTProfileUsageType()) return true;
        if ((uint32)getE8BTProfileUsageType() > (uint32)rhs.getE8BTProfileUsageType()) return false;
    }
    if (hasBInUse() || rhs.hasBInUse()) {
        if (getBInUse() < rhs.getBInUse()) return true;
        if (getBInUse() > rhs.getBInUse()) return false;
    }
    return false;
}

inline bool T_BTProfilesUsageInfo::operator > (const T_BTProfilesUsageInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_BTProfilesUsageInfo::clear() {
    clearE8BTProfile();
    clearSUUID();
    clearE8BTProfileUsageType();
    clearBInUse();
}

inline void T_BTProfilesUsageInfo::clearE8BTProfile() {
    if (hasE8BTProfile()) {
         clear_has_e8BTProfile();
        _e8BTProfile = ::most_BTSet_fi_types_Extended::T_e8_BTProfile__e8BT_PROFILE_NONE;
     }
}

inline bool T_BTProfilesUsageInfo::hasE8BTProfile () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_BTProfile T_BTProfilesUsageInfo::getE8BTProfile () const {
    return _e8BTProfile;
}

inline void T_BTProfilesUsageInfo::setE8BTProfile (T_e8_BTProfile e8BTProfile_) {
    #ifndef NDEBUG
    if (!(T_e8_BTProfile_IsValid(e8BTProfile_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8BTProfile_, "T_e8_BTProfile", "e8BTProfile", "T_BTProfilesUsageInfo");
    }
    #endif
    set_has_e8BTProfile();
    this->_e8BTProfile = e8BTProfile_;
}

inline void T_BTProfilesUsageInfo::clearSUUID() {
    if (hasSUUID()) {
         clear_has_sUUID();
        _sUUID.clear();
     }
}

inline bool T_BTProfilesUsageInfo::hasSUUID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_BTProfilesUsageInfo::getSUUID () const {
    return _sUUID;
}

inline ::fi_basetypes_most::T_String& T_BTProfilesUsageInfo::getSUUIDMutable () {
    set_has_sUUID();
    return _sUUID;
}

inline void T_BTProfilesUsageInfo::setSUUID (const ::fi_basetypes_most::T_String& sUUID_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sUUID_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sUUID();
    this->_sUUID = sUUID_;
}

inline void T_BTProfilesUsageInfo::clearE8BTProfileUsageType() {
    if (hasE8BTProfileUsageType()) {
         clear_has_e8BTProfileUsageType();
        _e8BTProfileUsageType = ::most_BTSet_fi_types_Extended::T_e8_BTProfileUsageType__e8PROFILE_USAGE_NONE;
     }
}

inline bool T_BTProfilesUsageInfo::hasE8BTProfileUsageType () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_BTProfileUsageType T_BTProfilesUsageInfo::getE8BTProfileUsageType () const {
    return _e8BTProfileUsageType;
}

inline void T_BTProfilesUsageInfo::setE8BTProfileUsageType (T_e8_BTProfileUsageType e8BTProfileUsageType_) {
    #ifndef NDEBUG
    if (!(T_e8_BTProfileUsageType_IsValid(e8BTProfileUsageType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8BTProfileUsageType_, "T_e8_BTProfileUsageType", "e8BTProfileUsageType", "T_BTProfilesUsageInfo");
    }
    #endif
    set_has_e8BTProfileUsageType();
    this->_e8BTProfileUsageType = e8BTProfileUsageType_;
}

inline void T_BTProfilesUsageInfo::clearBInUse() {
    if (hasBInUse()) {
         clear_has_bInUse();
        _bInUse = false;
     }
}

inline bool T_BTProfilesUsageInfo::hasBInUse () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline bool T_BTProfilesUsageInfo::getBInUse () const {
    return _bInUse;
}

inline void T_BTProfilesUsageInfo::setBInUse (bool bInUse_) {
    set_has_bInUse();
    this->_bInUse = bInUse_;
}

inline void T_BTProfilesUsageInfo::set_has_e8BTProfile () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_BTProfilesUsageInfo::clear_has_e8BTProfile () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_BTProfilesUsageInfo::set_has_sUUID () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_BTProfilesUsageInfo::clear_has_sUUID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_BTProfilesUsageInfo::set_has_e8BTProfileUsageType () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_BTProfilesUsageInfo::clear_has_e8BTProfileUsageType () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_BTProfilesUsageInfo::set_has_bInUse () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_BTProfilesUsageInfo::clear_has_bInUse () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  T_BTProfilesUsageInfoList::T_BTProfilesUsageInfoList ()  :
    _u8DeviceHandle (0u),
    _oBTProfilesUsageInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_BTProfilesUsageInfoList::T_BTProfilesUsageInfoList (const T_BTProfilesUsageInfoList &rhs)  :
    _u8DeviceHandle (0u),
    _oBTProfilesUsageInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_BTProfilesUsageInfoList::T_BTProfilesUsageInfoList (uint8 u8DeviceHandle_, const T_BTProfilesUsageInfo& oBTProfilesUsageInfo_)  :
    _u8DeviceHandle (u8DeviceHandle_),
    _oBTProfilesUsageInfo (oBTProfilesUsageInfo_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_BTProfilesUsageInfoList::~T_BTProfilesUsageInfoList() {
}

inline T_BTProfilesUsageInfoList& T_BTProfilesUsageInfoList::operator = (const T_BTProfilesUsageInfoList& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8DeviceHandle()) {
            setU8DeviceHandle(rhs.getU8DeviceHandle());
        } else {
            clearU8DeviceHandle();
        }
        if (rhs.hasOBTProfilesUsageInfo()) {
            setOBTProfilesUsageInfo(rhs.getOBTProfilesUsageInfo());
        } else {
            clearOBTProfilesUsageInfo();
        }
    }
    return *this;
}

inline bool T_BTProfilesUsageInfoList::operator == (const T_BTProfilesUsageInfoList& rhs) const {
    return (((!hasU8DeviceHandle() && !rhs.hasU8DeviceHandle()) || getU8DeviceHandle() == rhs.getU8DeviceHandle()) &&
        ((!hasOBTProfilesUsageInfo() && !rhs.hasOBTProfilesUsageInfo()) || getOBTProfilesUsageInfo() == rhs.getOBTProfilesUsageInfo()));
}

inline bool T_BTProfilesUsageInfoList::operator != (const T_BTProfilesUsageInfoList& rhs) const {
    return ! (*this == rhs);
}

inline bool T_BTProfilesUsageInfoList::operator < (const T_BTProfilesUsageInfoList& rhs) const {
    if (hasU8DeviceHandle() || rhs.hasU8DeviceHandle()) {
        if (getU8DeviceHandle() < rhs.getU8DeviceHandle()) return true;
        if (getU8DeviceHandle() > rhs.getU8DeviceHandle()) return false;
    }
    if (hasOBTProfilesUsageInfo() || rhs.hasOBTProfilesUsageInfo()) {
        if (getOBTProfilesUsageInfo() < rhs.getOBTProfilesUsageInfo()) return true;
        if (getOBTProfilesUsageInfo() > rhs.getOBTProfilesUsageInfo()) return false;
    }
    return false;
}

inline bool T_BTProfilesUsageInfoList::operator > (const T_BTProfilesUsageInfoList& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_BTProfilesUsageInfoList::clear() {
    clearU8DeviceHandle();
    clearOBTProfilesUsageInfo();
}

inline void T_BTProfilesUsageInfoList::clearU8DeviceHandle() {
    if (hasU8DeviceHandle()) {
         clear_has_u8DeviceHandle();
        _u8DeviceHandle = 0u;
     }
}

inline bool T_BTProfilesUsageInfoList::hasU8DeviceHandle () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_BTProfilesUsageInfoList::getU8DeviceHandle () const {
    return _u8DeviceHandle;
}

inline void T_BTProfilesUsageInfoList::setU8DeviceHandle (uint8 u8DeviceHandle_) {
    set_has_u8DeviceHandle();
    this->_u8DeviceHandle = u8DeviceHandle_;
}

inline void T_BTProfilesUsageInfoList::clearOBTProfilesUsageInfo() {
    if (hasOBTProfilesUsageInfo()) {
         clear_has_oBTProfilesUsageInfo();
        _oBTProfilesUsageInfo.clear();
     }
}

inline bool T_BTProfilesUsageInfoList::hasOBTProfilesUsageInfo () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const T_BTProfilesUsageInfo& T_BTProfilesUsageInfoList::getOBTProfilesUsageInfo () const {
    return _oBTProfilesUsageInfo;
}

inline T_BTProfilesUsageInfo& T_BTProfilesUsageInfoList::getOBTProfilesUsageInfoMutable () {
    set_has_oBTProfilesUsageInfo();
    return _oBTProfilesUsageInfo;
}

inline void T_BTProfilesUsageInfoList::setOBTProfilesUsageInfo (const T_BTProfilesUsageInfo& oBTProfilesUsageInfo_) {
    set_has_oBTProfilesUsageInfo();
    this->_oBTProfilesUsageInfo = oBTProfilesUsageInfo_;
}

inline void T_BTProfilesUsageInfoList::set_has_u8DeviceHandle () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_BTProfilesUsageInfoList::clear_has_u8DeviceHandle () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_BTProfilesUsageInfoList::set_has_oBTProfilesUsageInfo () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_BTProfilesUsageInfoList::clear_has_oBTProfilesUsageInfo () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_BTConflictInfo::T_BTConflictInfo ()  :
    _e8ConflictType (::most_BTSet_fi_types_Extended::T_e8_BTConflictType__e8GENERIC),
    _u8DeviceHandle (0u),
    _e8BTProfile (::most_BTSet_fi_types_Extended::T_e8_BTProfile__e8BT_PROFILE_NONE),
    _sUUID (),
    _e8BTProfileUsageType (::most_BTSet_fi_types_Extended::T_e8_BTProfileUsageType__e8PROFILE_USAGE_NONE),
    _e8ConflictState (::most_BTSet_fi_types_Extended::T_e8_BTConflictState__e8CONFLICT_STATE_NEW)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_BTConflictInfo::T_BTConflictInfo (const T_BTConflictInfo &rhs)  :
    _e8ConflictType (::most_BTSet_fi_types_Extended::T_e8_BTConflictType__e8GENERIC),
    _u8DeviceHandle (0u),
    _e8BTProfile (::most_BTSet_fi_types_Extended::T_e8_BTProfile__e8BT_PROFILE_NONE),
    _sUUID (),
    _e8BTProfileUsageType (::most_BTSet_fi_types_Extended::T_e8_BTProfileUsageType__e8PROFILE_USAGE_NONE),
    _e8ConflictState (::most_BTSet_fi_types_Extended::T_e8_BTConflictState__e8CONFLICT_STATE_NEW)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_BTConflictInfo::T_BTConflictInfo (T_e8_BTConflictType e8ConflictType_, uint8 u8DeviceHandle_, T_e8_BTProfile e8BTProfile_, const ::fi_basetypes_most::T_String& sUUID_, T_e8_BTProfileUsageType e8BTProfileUsageType_, T_e8_BTConflictState e8ConflictState_)  :
    _e8ConflictType (e8ConflictType_),
    _u8DeviceHandle (u8DeviceHandle_),
    _e8BTProfile (e8BTProfile_),
    _sUUID (sUUID_),
    _e8BTProfileUsageType (e8BTProfileUsageType_),
    _e8ConflictState (e8ConflictState_)
{
    #ifndef NDEBUG
    if (!(T_e8_BTConflictType_IsValid(e8ConflictType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8ConflictType_, "T_e8_BTConflictType", "e8ConflictType", "T_BTConflictInfo");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_BTProfile_IsValid(e8BTProfile_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8BTProfile_, "T_e8_BTProfile", "e8BTProfile", "T_BTConflictInfo");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sUUID_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e8_BTProfileUsageType_IsValid(e8BTProfileUsageType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8BTProfileUsageType_, "T_e8_BTProfileUsageType", "e8BTProfileUsageType", "T_BTConflictInfo");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_BTConflictState_IsValid(e8ConflictState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8ConflictState_, "T_e8_BTConflictState", "e8ConflictState", "T_BTConflictInfo");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_BTConflictInfo::~T_BTConflictInfo() {
}

inline T_BTConflictInfo& T_BTConflictInfo::operator = (const T_BTConflictInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE8ConflictType()) {
            setE8ConflictType(rhs.getE8ConflictType());
        } else {
            clearE8ConflictType();
        }
        if (rhs.hasU8DeviceHandle()) {
            setU8DeviceHandle(rhs.getU8DeviceHandle());
        } else {
            clearU8DeviceHandle();
        }
        if (rhs.hasE8BTProfile()) {
            setE8BTProfile(rhs.getE8BTProfile());
        } else {
            clearE8BTProfile();
        }
        if (rhs.hasSUUID()) {
            setSUUID(rhs.getSUUID());
        } else {
            clearSUUID();
        }
        if (rhs.hasE8BTProfileUsageType()) {
            setE8BTProfileUsageType(rhs.getE8BTProfileUsageType());
        } else {
            clearE8BTProfileUsageType();
        }
        if (rhs.hasE8ConflictState()) {
            setE8ConflictState(rhs.getE8ConflictState());
        } else {
            clearE8ConflictState();
        }
    }
    return *this;
}

inline bool T_BTConflictInfo::operator == (const T_BTConflictInfo& rhs) const {
    return (((!hasE8ConflictType() && !rhs.hasE8ConflictType()) || getE8ConflictType() == rhs.getE8ConflictType()) &&
        ((!hasU8DeviceHandle() && !rhs.hasU8DeviceHandle()) || getU8DeviceHandle() == rhs.getU8DeviceHandle()) &&
        ((!hasE8BTProfile() && !rhs.hasE8BTProfile()) || getE8BTProfile() == rhs.getE8BTProfile()) &&
        ((!hasSUUID() && !rhs.hasSUUID()) || getSUUID() == rhs.getSUUID()) &&
        ((!hasE8BTProfileUsageType() && !rhs.hasE8BTProfileUsageType()) || getE8BTProfileUsageType() == rhs.getE8BTProfileUsageType()) &&
        ((!hasE8ConflictState() && !rhs.hasE8ConflictState()) || getE8ConflictState() == rhs.getE8ConflictState()));
}

inline bool T_BTConflictInfo::operator != (const T_BTConflictInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_BTConflictInfo::operator < (const T_BTConflictInfo& rhs) const {
    if (hasE8ConflictType() || rhs.hasE8ConflictType()) {
        if ((uint32)getE8ConflictType() < (uint32)rhs.getE8ConflictType()) return true;
        if ((uint32)getE8ConflictType() > (uint32)rhs.getE8ConflictType()) return false;
    }
    if (hasU8DeviceHandle() || rhs.hasU8DeviceHandle()) {
        if (getU8DeviceHandle() < rhs.getU8DeviceHandle()) return true;
        if (getU8DeviceHandle() > rhs.getU8DeviceHandle()) return false;
    }
    if (hasE8BTProfile() || rhs.hasE8BTProfile()) {
        if ((uint32)getE8BTProfile() < (uint32)rhs.getE8BTProfile()) return true;
        if ((uint32)getE8BTProfile() > (uint32)rhs.getE8BTProfile()) return false;
    }
    if (hasSUUID() || rhs.hasSUUID()) {
        if (getSUUID() < rhs.getSUUID()) return true;
        if (getSUUID() > rhs.getSUUID()) return false;
    }
    if (hasE8BTProfileUsageType() || rhs.hasE8BTProfileUsageType()) {
        if ((uint32)getE8BTProfileUsageType() < (uint32)rhs.getE8BTProfileUsageType()) return true;
        if ((uint32)getE8BTProfileUsageType() > (uint32)rhs.getE8BTProfileUsageType()) return false;
    }
    if (hasE8ConflictState() || rhs.hasE8ConflictState()) {
        if ((uint32)getE8ConflictState() < (uint32)rhs.getE8ConflictState()) return true;
        if ((uint32)getE8ConflictState() > (uint32)rhs.getE8ConflictState()) return false;
    }
    return false;
}

inline bool T_BTConflictInfo::operator > (const T_BTConflictInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_BTConflictInfo::clear() {
    clearE8ConflictType();
    clearU8DeviceHandle();
    clearE8BTProfile();
    clearSUUID();
    clearE8BTProfileUsageType();
    clearE8ConflictState();
}

inline void T_BTConflictInfo::clearE8ConflictType() {
    if (hasE8ConflictType()) {
         clear_has_e8ConflictType();
        _e8ConflictType = ::most_BTSet_fi_types_Extended::T_e8_BTConflictType__e8GENERIC;
     }
}

inline bool T_BTConflictInfo::hasE8ConflictType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_BTConflictType T_BTConflictInfo::getE8ConflictType () const {
    return _e8ConflictType;
}

inline void T_BTConflictInfo::setE8ConflictType (T_e8_BTConflictType e8ConflictType_) {
    #ifndef NDEBUG
    if (!(T_e8_BTConflictType_IsValid(e8ConflictType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8ConflictType_, "T_e8_BTConflictType", "e8ConflictType", "T_BTConflictInfo");
    }
    #endif
    set_has_e8ConflictType();
    this->_e8ConflictType = e8ConflictType_;
}

inline void T_BTConflictInfo::clearU8DeviceHandle() {
    if (hasU8DeviceHandle()) {
         clear_has_u8DeviceHandle();
        _u8DeviceHandle = 0u;
     }
}

inline bool T_BTConflictInfo::hasU8DeviceHandle () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_BTConflictInfo::getU8DeviceHandle () const {
    return _u8DeviceHandle;
}

inline void T_BTConflictInfo::setU8DeviceHandle (uint8 u8DeviceHandle_) {
    set_has_u8DeviceHandle();
    this->_u8DeviceHandle = u8DeviceHandle_;
}

inline void T_BTConflictInfo::clearE8BTProfile() {
    if (hasE8BTProfile()) {
         clear_has_e8BTProfile();
        _e8BTProfile = ::most_BTSet_fi_types_Extended::T_e8_BTProfile__e8BT_PROFILE_NONE;
     }
}

inline bool T_BTConflictInfo::hasE8BTProfile () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_BTProfile T_BTConflictInfo::getE8BTProfile () const {
    return _e8BTProfile;
}

inline void T_BTConflictInfo::setE8BTProfile (T_e8_BTProfile e8BTProfile_) {
    #ifndef NDEBUG
    if (!(T_e8_BTProfile_IsValid(e8BTProfile_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8BTProfile_, "T_e8_BTProfile", "e8BTProfile", "T_BTConflictInfo");
    }
    #endif
    set_has_e8BTProfile();
    this->_e8BTProfile = e8BTProfile_;
}

inline void T_BTConflictInfo::clearSUUID() {
    if (hasSUUID()) {
         clear_has_sUUID();
        _sUUID.clear();
     }
}

inline bool T_BTConflictInfo::hasSUUID () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_BTConflictInfo::getSUUID () const {
    return _sUUID;
}

inline ::fi_basetypes_most::T_String& T_BTConflictInfo::getSUUIDMutable () {
    set_has_sUUID();
    return _sUUID;
}

inline void T_BTConflictInfo::setSUUID (const ::fi_basetypes_most::T_String& sUUID_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sUUID_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sUUID();
    this->_sUUID = sUUID_;
}

inline void T_BTConflictInfo::clearE8BTProfileUsageType() {
    if (hasE8BTProfileUsageType()) {
         clear_has_e8BTProfileUsageType();
        _e8BTProfileUsageType = ::most_BTSet_fi_types_Extended::T_e8_BTProfileUsageType__e8PROFILE_USAGE_NONE;
     }
}

inline bool T_BTConflictInfo::hasE8BTProfileUsageType () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline T_e8_BTProfileUsageType T_BTConflictInfo::getE8BTProfileUsageType () const {
    return _e8BTProfileUsageType;
}

inline void T_BTConflictInfo::setE8BTProfileUsageType (T_e8_BTProfileUsageType e8BTProfileUsageType_) {
    #ifndef NDEBUG
    if (!(T_e8_BTProfileUsageType_IsValid(e8BTProfileUsageType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8BTProfileUsageType_, "T_e8_BTProfileUsageType", "e8BTProfileUsageType", "T_BTConflictInfo");
    }
    #endif
    set_has_e8BTProfileUsageType();
    this->_e8BTProfileUsageType = e8BTProfileUsageType_;
}

inline void T_BTConflictInfo::clearE8ConflictState() {
    if (hasE8ConflictState()) {
         clear_has_e8ConflictState();
        _e8ConflictState = ::most_BTSet_fi_types_Extended::T_e8_BTConflictState__e8CONFLICT_STATE_NEW;
     }
}

inline bool T_BTConflictInfo::hasE8ConflictState () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline T_e8_BTConflictState T_BTConflictInfo::getE8ConflictState () const {
    return _e8ConflictState;
}

inline void T_BTConflictInfo::setE8ConflictState (T_e8_BTConflictState e8ConflictState_) {
    #ifndef NDEBUG
    if (!(T_e8_BTConflictState_IsValid(e8ConflictState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8ConflictState_, "T_e8_BTConflictState", "e8ConflictState", "T_BTConflictInfo");
    }
    #endif
    set_has_e8ConflictState();
    this->_e8ConflictState = e8ConflictState_;
}

inline void T_BTConflictInfo::set_has_e8ConflictType () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_BTConflictInfo::clear_has_e8ConflictType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_BTConflictInfo::set_has_u8DeviceHandle () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_BTConflictInfo::clear_has_u8DeviceHandle () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_BTConflictInfo::set_has_e8BTProfile () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_BTConflictInfo::clear_has_e8BTProfile () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_BTConflictInfo::set_has_sUUID () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_BTConflictInfo::clear_has_sUUID () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_BTConflictInfo::set_has_e8BTProfileUsageType () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_BTConflictInfo::clear_has_e8BTProfileUsageType () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_BTConflictInfo::set_has_e8ConflictState () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_BTConflictInfo::clear_has_e8ConflictState () {
    _has_bits_[0] &= ~ (1u << 5);
}

} // namespace most_BTSet_fi_types_Extended

#endif // MOST_BTSET_FI_TYPES_EXTENDED_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
