/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/cca/CcaMostStream.h"
#include "asf/core/Types.h"
#include "asf/stream/MemoryStream.h"
#include "most_BTSet_fi_types.h"
#include "most_BTSet_fi_typesCcaMost.h"
#include "most_BTSet_fi_typesConst.h"


// --------------------------------------------------------------------------
// MemoryStream functions
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// CcaMostStream functions
// --------------------------------------------------------------------------

// Serialize T_BTSetDateTimeStamp

void serializeCcaMost(const ::most_BTSet_fi_types::T_BTSetDateTimeStamp& in, ::asf::cca::CcaMostStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8* positionContentLength = out.getCurrentWritePos();
    uint8 contentLength = 0;
    out << contentLength;
    uint8* positionStartList = out.getCurrentWritePos();
    serializeCcaMost(in.getODateStamp(), out, majorVersion);
    serializeCcaMost(in.getOTimeStamp(), out, majorVersion);
    uint8* positionEndList = out.getCurrentWritePos();
    contentLength = static_cast<uint8>(positionEndList - positionStartList);
    assert(contentLength <= 255);
    out.writeToPosUint8( positionContentLength, contentLength);
}

void deserializeCcaMost(::asf::cca::CcaMostStream& in, ::most_BTSet_fi_types::T_BTSetDateTimeStamp& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 contentLength = 0;
    in >> contentLength;
    uint8* positionStreamEnd = in.getCurrentReadPos() + contentLength;
    deserializeCcaMost(in, out.getODateStampMutable(), majorVersion);
    deserializeCcaMost(in, out.getOTimeStampMutable(), majorVersion);
    assert(in.getCurrentReadPos() == positionStreamEnd);
    (void)positionStreamEnd; // make release build happy
}

// Serialize T_BTSetDateStamp

void serializeCcaMost(const ::most_BTSet_fi_types::T_BTSetDateStamp& in, ::asf::cca::CcaMostStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8* positionContentLength = out.getCurrentWritePos();
    uint8 contentLength = 0;
    out << contentLength;
    uint8* positionStartList = out.getCurrentWritePos();
    out.writeMostString(in.getSCldrYear());
    out.writeMostString(in.getSCldrMonth());
    out.writeMostString(in.getSCldrDay());
    uint8* positionEndList = out.getCurrentWritePos();
    contentLength = static_cast<uint8>(positionEndList - positionStartList);
    assert(contentLength <= 255);
    out.writeToPosUint8( positionContentLength, contentLength);
}

void deserializeCcaMost(::asf::cca::CcaMostStream& in, ::most_BTSet_fi_types::T_BTSetDateStamp& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 contentLength = 0;
    in >> contentLength;
    uint8* positionStreamEnd = in.getCurrentReadPos() + contentLength;
    in.readMostString(out.getSCldrYearMutable());
    in.readMostString(out.getSCldrMonthMutable());
    in.readMostString(out.getSCldrDayMutable());
    assert(in.getCurrentReadPos() == positionStreamEnd);
    (void)positionStreamEnd; // make release build happy
}

// Serialize T_BTSetTimeStamp

void serializeCcaMost(const ::most_BTSet_fi_types::T_BTSetTimeStamp& in, ::asf::cca::CcaMostStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8* positionContentLength = out.getCurrentWritePos();
    uint8 contentLength = 0;
    out << contentLength;
    uint8* positionStartList = out.getCurrentWritePos();
    out.writeMostString(in.getSHours());
    out.writeMostString(in.getSMinutes());
    out.writeMostString(in.getSSeconds());
    uint8* positionEndList = out.getCurrentWritePos();
    contentLength = static_cast<uint8>(positionEndList - positionStartList);
    assert(contentLength <= 255);
    out.writeToPosUint8( positionContentLength, contentLength);
}

void deserializeCcaMost(::asf::cca::CcaMostStream& in, ::most_BTSet_fi_types::T_BTSetTimeStamp& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 contentLength = 0;
    in >> contentLength;
    uint8* positionStreamEnd = in.getCurrentReadPos() + contentLength;
    in.readMostString(out.getSHoursMutable());
    in.readMostString(out.getSMinutesMutable());
    in.readMostString(out.getSSecondsMutable());
    assert(in.getCurrentReadPos() == positionStreamEnd);
    (void)positionStreamEnd; // make release build happy
}

// Serialize T_BTSetDeviceRingtoneListResultItem

void serializeCcaMost(const ::most_BTSet_fi_types::T_BTSetDeviceRingtoneListResultItem& in, ::asf::cca::CcaMostStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU8DeviceHandle();
    out.writeMostString(in.getSDeviceName());
    out << in.getU16RingtoneID();
    out.writeMostString(in.getSRingtoneName());
}

void deserializeCcaMost(::asf::cca::CcaMostStream& in, ::most_BTSet_fi_types::T_BTSetDeviceRingtoneListResultItem& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o0;
    in >> o0;
    out.setU8DeviceHandle(o0);
    in.readMostString(out.getSDeviceNameMutable());
    uint16 o1;
    in >> o1;
    out.setU16RingtoneID(o1);
    in.readMostString(out.getSRingtoneNameMutable());
}

// Serialize T_BTSetRingtoneListItem

void serializeCcaMost(const ::most_BTSet_fi_types::T_BTSetRingtoneListItem& in, ::asf::cca::CcaMostStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU16RingtoneID();
    out.writeMostString(in.getSRingtoneName());
    out << (uint8) in.getBRingtoneAvailable();
    out << (uint8) in.getBPlayRingtoneAvailable();
    out << (uint8) in.getBActiveRingtone();
}

void deserializeCcaMost(::asf::cca::CcaMostStream& in, ::most_BTSet_fi_types::T_BTSetRingtoneListItem& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o2;
    in >> o2;
    out.setU16RingtoneID(o2);
    in.readMostString(out.getSRingtoneNameMutable());
    bool o3;
    in >> o3;
    out.setBRingtoneAvailable(o3);
    bool o4;
    in >> o4;
    out.setBPlayRingtoneAvailable(o4);
    bool o5;
    in >> o5;
    out.setBActiveRingtone(o5);
}

// Serialize T_BTSetDeviceControlSupport

void serializeCcaMost(const ::most_BTSet_fi_types::T_BTSetDeviceControlSupport& in, ::asf::cca::CcaMostStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getBPlaySupport();
    out << (uint8) in.getBPauseSupport();
    out << (uint8) in.getBNextTrackSupport();
    out << (uint8) in.getBPreviousTrackSupport();
    out << (uint8) in.getBShuffleSupport();
    out << (uint8) in.getBRepeatSupport();
    out << (uint8) in.getBPlaytimeSupport();
    out << (uint8) in.getBMetadataSupport();
    out << (uint8) in.getBFolderBrowseSupport();
    out << (uint8) in.getBMediaAggregrationSupport();
    out << (uint8) in.getBFastForwardSupport();
    out << (uint8) in.getBRewindSupport();
}

void deserializeCcaMost(::asf::cca::CcaMostStream& in, ::most_BTSet_fi_types::T_BTSetDeviceControlSupport& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    bool o6;
    in >> o6;
    out.setBPlaySupport(o6);
    bool o7;
    in >> o7;
    out.setBPauseSupport(o7);
    bool o8;
    in >> o8;
    out.setBNextTrackSupport(o8);
    bool o9;
    in >> o9;
    out.setBPreviousTrackSupport(o9);
    bool o10;
    in >> o10;
    out.setBShuffleSupport(o10);
    bool o11;
    in >> o11;
    out.setBRepeatSupport(o11);
    bool o12;
    in >> o12;
    out.setBPlaytimeSupport(o12);
    bool o13;
    in >> o13;
    out.setBMetadataSupport(o13);
    bool o14;
    in >> o14;
    out.setBFolderBrowseSupport(o14);
    bool o15;
    in >> o15;
    out.setBMediaAggregrationSupport(o15);
    bool o16;
    in >> o16;
    out.setBFastForwardSupport(o16);
    bool o17;
    in >> o17;
    out.setBRewindSupport(o17);
}

// Serialize T_BTSetBluetoothFeatureSupport

void serializeCcaMost(const ::most_BTSet_fi_types::T_BTSetBluetoothFeatureSupport& in, ::asf::cca::CcaMostStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8* positionContentLength = out.getCurrentWritePos();
    uint8 contentLength = 0;
    out << contentLength;
    uint8* positionStartList = out.getCurrentWritePos();
    out << (uint8) in.getBHandsFreeSupport();
    out << (uint8) in.getBPhoneBookSupport();
    out << (uint8) in.getBAudioStreamingSupport();
    out << (uint8) in.getE8AudioStreamingSupportType();
    out << (uint8) in.getBMessagingSupport();
    out << (uint8) in.getBInternetAccessSupport();
    out << (uint8) in.getE8InternetAccessSupportType();
    out << (uint8) in.getBPortableNavigationSupport();
    out << (uint8) in.getBSerialPortSupport();
    uint8* positionEndList = out.getCurrentWritePos();
    contentLength = static_cast<uint8>(positionEndList - positionStartList);
    assert(contentLength <= 255);
    out.writeToPosUint8( positionContentLength, contentLength);
}

void deserializeCcaMost(::asf::cca::CcaMostStream& in, ::most_BTSet_fi_types::T_BTSetBluetoothFeatureSupport& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 contentLength = 0;
    in >> contentLength;
    uint8* positionStreamEnd = in.getCurrentReadPos() + contentLength;
    bool o18;
    in >> o18;
    out.setBHandsFreeSupport(o18);
    bool o19;
    in >> o19;
    out.setBPhoneBookSupport(o19);
    bool o20;
    in >> o20;
    out.setBAudioStreamingSupport(o20);
    uint8 o21;
    in >> o21;
    out.setE8AudioStreamingSupportType((::most_BTSet_fi_types::T_e8_BTSetAudioStreamingSupportType)o21);
    bool o22;
    in >> o22;
    out.setBMessagingSupport(o22);
    bool o23;
    in >> o23;
    out.setBInternetAccessSupport(o23);
    uint8 o24;
    in >> o24;
    out.setE8InternetAccessSupportType((::most_BTSet_fi_types::T_e8_BTSetInternetAccessSupportType)o24);
    bool o25;
    in >> o25;
    out.setBPortableNavigationSupport(o25);
    bool o26;
    in >> o26;
    out.setBSerialPortSupport(o26);
    assert(in.getCurrentReadPos() == positionStreamEnd);
    (void)positionStreamEnd; // make release build happy
}

