/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "acr_fi_types.h"
#include "acr_fi_typesCca.h"
#include "acr_fi_typesConst.h"
#include "asf/core/Types.h"
#include "asf/stream/MemoryStream.h"
#include <string>
#include <vector>


void serializeCca(const ::acr_fi_types::T_AudioChannelAdvice& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getChannelAdvice();
    out << in.getIndex();
    out << in.getDevice();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::acr_fi_types::T_AudioChannelAdvice& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o0;
    in >> o0;
    out.setChannelAdvice((::acr_fi_types::T_e8_AudioChannelAdvice)o0);
    uint8 o1;
    in >> o1;
    out.setIndex(o1);
    ::std::string o2;
    in >> o2;
    out.setDevice(o2);
}

void serializeCca(const ::acr_fi_types::T_ChannelRequestStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getCategory();
    out << in.getIndex();
    out << (uint8) in.getStatus();
    serializeCca(in.getAudioFormat(), out, majorVersion);
    serializeCca(in.getAudioOutputLocation(), out, majorVersion);
    if (2 <= majorVersion) {
        serializeCca(in.getRequestAddInfo(), out, majorVersion);
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::acr_fi_types::T_ChannelRequestStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o3;
    in >> o3;
    out.setCategory((::acr_fi_types::T_e8_VoiceCategory)o3);
    uint8 o4;
    in >> o4;
    out.setIndex(o4);
    uint8 o5;
    in >> o5;
    out.setStatus((::acr_fi_types::T_e8_CatStatus)o5);
    deserializeCca(in, out.getAudioFormatMutable(), majorVersion);
    deserializeCca(in, out.getAudioOutputLocationMutable(), majorVersion);
    if (2 <= majorVersion) {
        deserializeCca(in, out.getRequestAddInfoMutable(), majorVersion);
    }
}

void serializeCca(const ::acr_fi_types::T_InstancesPerCategory& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getVoiceCategory();
    out << in.getNumberOfInstances();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::acr_fi_types::T_InstancesPerCategory& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o6;
    in >> o6;
    out.setVoiceCategory((::acr_fi_types::T_e8_VoiceCategory)o6);
    uint8 o7;
    in >> o7;
    out.setNumberOfInstances(o7);
}

void serializeCca(const ::acr_fi_types::T_InstancesPerCategoryList& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    {
        uint32 o8 = static_cast<uint32>(in.getInstancesPerCategory().size());
        out << o8;
        ::std::vector< ::acr_fi_types::T_InstancesPerCategory >::const_iterator o9;
        for (o9 = in.getInstancesPerCategory().begin(); o9 != in.getInstancesPerCategory().end(); ++o9) {
            serializeCca((*o9), out, majorVersion);
        }
    }
    out << in.getMaxAmountInstances();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::acr_fi_types::T_InstancesPerCategoryList& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    {
        uint32 o10;
        in >> o10;
        out.getInstancesPerCategoryMutable().clear ();
        out.getInstancesPerCategoryMutable().reserve (o10);
        for (uint32 o11 = 0; o11 < o10; o11++) {
            ::acr_fi_types::T_InstancesPerCategory o12;
            deserializeCca(in, o12, majorVersion);
            out.getInstancesPerCategoryMutable().push_back (o12);
        }
    }
    uint8 o13;
    in >> o13;
    out.setMaxAmountInstances(o13);
}

void serializeCca(const ::acr_fi_types::T_b8_AudioOutputLocation& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 bitmask = 0;
    if (in.getStandard()) {
        bitmask |= (1 << 0);
    }
    if (in.getFrontLeft()) {
        bitmask |= (1 << 1);
    }
    if (in.getFrontRight()) {
        bitmask |= (1 << 2);
    }
    if (in.getBackRight()) {
        bitmask |= (1 << 3);
    }
    if (in.getBackLeft()) {
        bitmask |= (1 << 4);
    }
    out << bitmask;
}

void deserializeCca(::asf::stream::MemoryStream& in, ::acr_fi_types::T_b8_AudioOutputLocation& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o14;
    in >> o14;
    uint8 bitmask(o14);

    if (bitmask & (1 << 0)) {
        out.setStandard (true);
    }
    if (bitmask & (1 << 1)) {
        out.setFrontLeft (true);
    }
    if (bitmask & (1 << 2)) {
        out.setFrontRight (true);
    }
    if (bitmask & (1 << 3)) {
        out.setBackRight (true);
    }
    if (bitmask & (1 << 4)) {
        out.setBackLeft (true);
    }
}

void serializeCca(const ::acr_fi_types::T_b8_AudioFormat& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 bitmask = 0;
    if (in.getPCM()) {
        bitmask |= (1 << 0);
    }
    if (in.getAMR()) {
        bitmask |= (1 << 1);
    }
    if (in.getAMR_WB()) {
        bitmask |= (1 << 2);
    }
    if (in.getMP3()) {
        bitmask |= (1 << 3);
    }
    out << bitmask;
}

void deserializeCca(::asf::stream::MemoryStream& in, ::acr_fi_types::T_b8_AudioFormat& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o15;
    in >> o15;
    uint8 bitmask(o15);

    if (bitmask & (1 << 0)) {
        out.setPCM (true);
    }
    if (bitmask & (1 << 1)) {
        out.setAMR (true);
    }
    if (bitmask & (1 << 2)) {
        out.setAMR_WB (true);
    }
    if (bitmask & (1 << 3)) {
        out.setMP3 (true);
    }
}

void serializeCca(const ::acr_fi_types::T_b16_RequestAddInfo& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 bitmask = 0;
    if (in.getUser()) {
        bitmask |= (1 << 0);
    }
    if (in.getLong()) {
        bitmask |= (1 << 1);
    }
    if (in.getShort()) {
        bitmask |= (1 << 2);
    }
    out << bitmask;
}

void deserializeCca(::asf::stream::MemoryStream& in, ::acr_fi_types::T_b16_RequestAddInfo& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o16;
    in >> o16;
    uint16 bitmask(o16);

    if (bitmask & (1 << 0)) {
        out.setUser (true);
    }
    if (bitmask & (1 << 1)) {
        out.setLong (true);
    }
    if (bitmask & (1 << 2)) {
        out.setShort (true);
    }
}

