#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef CMB_ACR_FI_H
#define CMB_ACR_FI_H

#include "CMB_ACR_FIConst.h"
#include "acr_fi_types.h"
#include "asf/cca/CcaTypes.h"
#include "asf/cca/CcaTypesConst.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/VersionCheck.h"
#include <cstring>
#include <vector>

/**
 * CCA Functional Interface 'CMB_ACR_FI'
 *
 * Fullname: Acoustic Channel Request Functional Interface
 *
 * Version: $Revision: 2.0$
 *
 * Author:
 *          Marc Rï¿½ber, TMS Joachim Schneider
 *
 * Date: $Date: 17.04.2009$
 *
 * Department: CM-AI / PJ-CF14
 *
 * Title: CMB_ACR_FI
 *
 * <b>Description of 'CMB_ACR_FI':</b>
 */

namespace CMB_ACR_FI {

static const int SERVICE_ID = 520;

static const int FID_VoiceAdvice = 257;

static const int FID_ChannelRequest = 513;

static const int FID_InstancesPerCategory = 514;


ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 2;

static const int VERSION_MINOR = 0;

static const int VERSION_PATCH = 0;

// forward declarations
class VoiceAdviceStart;

class VoiceAdviceError;

class ChannelRequestStatus;

class InstancesPerCategoryStatus;

// type definitions
/**
 * The result message of the method "VoiceAdvice"
 * With this method, the AudioManagement is able to start/stop an audio advice,
 * if the audio channel is free/engaged. Further information can be found in the last chapter "MSCs".
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VoiceAdviceResult;

/**
 * The abort error message of the method "VoiceAdvice"
 * With this method, the AudioManagement is able to start/stop an audio advice,
 * if the audio channel is free/engaged. Further information can be found in the last chapter "MSCs".
 */
typedef ::asf::cca::CcaTypes::DefaultError VoiceAdviceAbortError;

/**
 * The get message of the property "ChannelRequest"
 * With this property, the component using this service is able to request
 * a voice advice from the AudioManagement. Additionally, the AudioManagement is informed, if
 * a job is being played. Further information can be found in the MSCs below.
 * The property contains only the current change of this status, not the complete status.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ChannelRequestGet;

/**
 * The upreg message of the property "ChannelRequest"
 * With this property, the component using this service is able to request
 * a voice advice from the AudioManagement. Additionally, the AudioManagement is informed, if
 * a job is being played. Further information can be found in the MSCs below.
 * The property contains only the current change of this status, not the complete status.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ChannelRequestUpReg;

/**
 * The relUpReg message of the property "ChannelRequest"
 * With this property, the component using this service is able to request
 * a voice advice from the AudioManagement. Additionally, the AudioManagement is informed, if
 * a job is being played. Further information can be found in the MSCs below.
 * The property contains only the current change of this status, not the complete status.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ChannelRequestRelUpReg;

/**
 * The error message of 'ChannelRequest'
 */
typedef ::asf::cca::CcaTypes::DefaultError ChannelRequestError;

/**
 * The get message of the property "InstancesPerCategory"
 * This property informs the client (particularly the AudioManegement)
 * about the maximum amount of instances that can run simultaneously for
 * each category. Additionally the maximum amount of instances overall is
 * given. Further information can be found in the MSCs below.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage InstancesPerCategoryGet;

/**
 * The upreg message of the property "InstancesPerCategory"
 * This property informs the client (particularly the AudioManegement)
 * about the maximum amount of instances that can run simultaneously for
 * each category. Additionally the maximum amount of instances overall is
 * given. Further information can be found in the MSCs below.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage InstancesPerCategoryUpReg;

/**
 * The relUpReg message of the property "InstancesPerCategory"
 * This property informs the client (particularly the AudioManegement)
 * about the maximum amount of instances that can run simultaneously for
 * each category. Additionally the maximum amount of instances overall is
 * given. Further information can be found in the MSCs below.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage InstancesPerCategoryRelUpReg;

/**
 * The error message of 'InstancesPerCategory'
 */
typedef ::asf::cca::CcaTypes::DefaultError InstancesPerCategoryError;


/**
 * The start message of the method "VoiceAdvice"
 * With this method, the AudioManagement is able to start/stop an audio advice,
 * if the audio channel is free/engaged. Further information can be found in the last chapter "MSCs".
 */
class VoiceAdviceStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VoiceAdviceStart ();

    /**
     * Copy constructor
     */
    inline  VoiceAdviceStart (const VoiceAdviceStart &rhs);

    /**
     * All fields constructor
     */
    inline  VoiceAdviceStart (const ::acr_fi_types::T_AudioChannelAdvice& AudioChannelAdvice_);

    /**
     * Destructor
     */
    inline virtual  ~VoiceAdviceStart();

    /**
     * Assignment operator
     */
    inline VoiceAdviceStart& operator = (const VoiceAdviceStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VoiceAdviceStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VoiceAdviceStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VoiceAdviceStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VoiceAdviceStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AudioChannelAdvice"

    static const int kAudioChannelAdvice = 0;

    /**
     * Clears the field "AudioChannelAdvice".
     *
     * The field will be set to its default value. The hasAudioChannelAdvice()
     * method will return false.
     */
    inline void clearAudioChannelAdvice();

    /**
     * Checks whether the field "AudioChannelAdvice" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudioChannelAdvice()). Otherwise it will return false.
     */
    inline bool hasAudioChannelAdvice () const;

    /**
     * Returns the value of the member "AudioChannelAdvice".
     *
     *
     *
     * @return The value of the field "AudioChannelAdvice"
     */
    inline const ::acr_fi_types::T_AudioChannelAdvice& getAudioChannelAdvice () const;

    /**
     * Retrieves the value of the field "AudioChannelAdvice" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AudioChannelAdvice".
     */
    inline ::acr_fi_types::T_AudioChannelAdvice& getAudioChannelAdviceMutable ();

    /**
     * Sets the value of the member "AudioChannelAdvice".
     *
     *
     *
     * @param AudioChannelAdvice The value which will be set
     */
    inline void setAudioChannelAdvice (const ::acr_fi_types::T_AudioChannelAdvice& AudioChannelAdvice_);

    static const VoiceAdviceStart &getDefaultInstance();

private:

    inline void set_has_AudioChannelAdvice ();

    inline void clear_has_AudioChannelAdvice ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::acr_fi_types::T_AudioChannelAdvice _AudioChannelAdvice;

};

/**
 * The error message of 'VoiceAdvice'
 */
class VoiceAdviceError  : public ::asf::core::Payload {
public:

    enum VoiceAdviceErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  VoiceAdviceError ();

   /**
     * Copy constructor
     */
    inline  VoiceAdviceError (const VoiceAdviceError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~VoiceAdviceError();

    /**
     * Assigns a new value to this object.
     */
    inline VoiceAdviceError& operator = (const VoiceAdviceError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VoiceAdviceError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VoiceAdviceError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VoiceAdviceError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VoiceAdviceError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline VoiceAdviceError::VoiceAdviceErrorField getField () const;

    inline void setField(VoiceAdviceError::VoiceAdviceErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "VoiceAdviceErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "VoiceAdviceErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline VoiceAdviceErrorCode getCcaErrorCode() const ;

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "VoiceAdviceErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (VoiceAdviceErrorCode value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const VoiceAdviceError &getDefaultInstance();

private:

    inline void cloneData (const VoiceAdviceError& rhs);

    inline void deleteData ();

    VoiceAdviceErrorField __field;

    union {
        int32 ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "ChannelRequest"
 * With this property, the component using this service is able to request
 * a voice advice from the AudioManagement. Additionally, the AudioManagement is informed, if
 * a job is being played. Further information can be found in the MSCs below.
 * The property contains only the current change of this status, not the complete status.
 */
class ChannelRequestStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ChannelRequestStatus ();

    /**
     * Copy constructor
     */
    inline  ChannelRequestStatus (const ChannelRequestStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ChannelRequestStatus (const ::acr_fi_types::T_ChannelRequestStatusList& ChannelRequestStatusList_);

    /**
     * Destructor
     */
    inline virtual  ~ChannelRequestStatus();

    /**
     * Assignment operator
     */
    inline ChannelRequestStatus& operator = (const ChannelRequestStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChannelRequestStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChannelRequestStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChannelRequestStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChannelRequestStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ChannelRequestStatusList"

    static const int kChannelRequestStatusList = 0;

    /**
     * Clears the field "ChannelRequestStatusList".
     *
     * The field will be set to its default value. The hasChannelRequestStatusList()
     * method will return false.
     */
    inline void clearChannelRequestStatusList();

    /**
     * Checks whether the field "ChannelRequestStatusList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelRequestStatusList()). Otherwise it will return false.
     */
    inline bool hasChannelRequestStatusList () const;

    /**
     * Returns the value of the member "ChannelRequestStatusList".
     *
     *
     *
     * @return The value of the field "ChannelRequestStatusList"
     */
    inline const ::acr_fi_types::T_ChannelRequestStatusList& getChannelRequestStatusList () const;

    /**
     * Retrieves the value of the field "ChannelRequestStatusList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ChannelRequestStatusList".
     */
    inline ::acr_fi_types::T_ChannelRequestStatusList& getChannelRequestStatusListMutable ();

    /**
     * Sets the value of the member "ChannelRequestStatusList".
     *
     *
     *
     * @param ChannelRequestStatusList The value which will be set
     */
    inline void setChannelRequestStatusList (const ::acr_fi_types::T_ChannelRequestStatusList& ChannelRequestStatusList_);

    static const ChannelRequestStatus &getDefaultInstance();

private:

    static const ::std::vector< ::acr_fi_types::T_ChannelRequestStatus >& getT_ChannelRequestStatusList_DefaultInstance ();

    inline void set_has_ChannelRequestStatusList ();

    inline void clear_has_ChannelRequestStatusList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::acr_fi_types::T_ChannelRequestStatusList _ChannelRequestStatusList;

};

/**
 * The status message of the property "InstancesPerCategory"
 * This property informs the client (particularly the AudioManegement)
 * about the maximum amount of instances that can run simultaneously for
 * each category. Additionally the maximum amount of instances overall is
 * given. Further information can be found in the MSCs below.
 */
class InstancesPerCategoryStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  InstancesPerCategoryStatus ();

    /**
     * Copy constructor
     */
    inline  InstancesPerCategoryStatus (const InstancesPerCategoryStatus &rhs);

    /**
     * All fields constructor
     */
    inline  InstancesPerCategoryStatus (const ::acr_fi_types::T_InstancesPerCategoryList& InstancesPerCategoryList_);

    /**
     * Destructor
     */
    inline virtual  ~InstancesPerCategoryStatus();

    /**
     * Assignment operator
     */
    inline InstancesPerCategoryStatus& operator = (const InstancesPerCategoryStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const InstancesPerCategoryStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const InstancesPerCategoryStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const InstancesPerCategoryStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const InstancesPerCategoryStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "InstancesPerCategoryList"

    static const int kInstancesPerCategoryList = 0;

    /**
     * Clears the field "InstancesPerCategoryList".
     *
     * The field will be set to its default value. The hasInstancesPerCategoryList()
     * method will return false.
     */
    inline void clearInstancesPerCategoryList();

    /**
     * Checks whether the field "InstancesPerCategoryList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInstancesPerCategoryList()). Otherwise it will return false.
     */
    inline bool hasInstancesPerCategoryList () const;

    /**
     * Returns the value of the member "InstancesPerCategoryList".
     *
     *
     *
     * @return The value of the field "InstancesPerCategoryList"
     */
    inline const ::acr_fi_types::T_InstancesPerCategoryList& getInstancesPerCategoryList () const;

    /**
     * Retrieves the value of the field "InstancesPerCategoryList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "InstancesPerCategoryList".
     */
    inline ::acr_fi_types::T_InstancesPerCategoryList& getInstancesPerCategoryListMutable ();

    /**
     * Sets the value of the member "InstancesPerCategoryList".
     *
     *
     *
     * @param InstancesPerCategoryList The value which will be set
     */
    inline void setInstancesPerCategoryList (const ::acr_fi_types::T_InstancesPerCategoryList& InstancesPerCategoryList_);

    static const InstancesPerCategoryStatus &getDefaultInstance();

private:

    inline void set_has_InstancesPerCategoryList ();

    inline void clear_has_InstancesPerCategoryList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::acr_fi_types::T_InstancesPerCategoryList _InstancesPerCategoryList;

};

inline  VoiceAdviceStart::VoiceAdviceStart ()  :
    _AudioChannelAdvice ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  VoiceAdviceStart::VoiceAdviceStart (const VoiceAdviceStart &rhs)  :
    ::asf::core::Payload(rhs),
    _AudioChannelAdvice ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  VoiceAdviceStart::VoiceAdviceStart (const ::acr_fi_types::T_AudioChannelAdvice& AudioChannelAdvice_)  :
    _AudioChannelAdvice (AudioChannelAdvice_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  VoiceAdviceStart::~VoiceAdviceStart() {
}

inline VoiceAdviceStart& VoiceAdviceStart::operator = (const VoiceAdviceStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAudioChannelAdvice()) {
            setAudioChannelAdvice(rhs.getAudioChannelAdvice());
        } else {
            clearAudioChannelAdvice();
        }
    }
    return *this;
}

inline bool VoiceAdviceStart::operator == (const VoiceAdviceStart& rhs) const {
    return (((!hasAudioChannelAdvice() && !rhs.hasAudioChannelAdvice()) || getAudioChannelAdvice() == rhs.getAudioChannelAdvice()));
}

inline bool VoiceAdviceStart::operator != (const VoiceAdviceStart& rhs) const {
    return ! (*this == rhs);
}

inline bool VoiceAdviceStart::operator < (const VoiceAdviceStart& rhs) const {
    if (hasAudioChannelAdvice() || rhs.hasAudioChannelAdvice()) {
        if (getAudioChannelAdvice() < rhs.getAudioChannelAdvice()) return true;
        if (getAudioChannelAdvice() > rhs.getAudioChannelAdvice()) return false;
    }
    return false;
}

inline ::asf::core::Payload* VoiceAdviceStart::clone() {
    return new VoiceAdviceStart(*this);
}

inline bool VoiceAdviceStart::operator > (const VoiceAdviceStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void VoiceAdviceStart::clear() {
    clearAudioChannelAdvice();
}

inline void VoiceAdviceStart::clearAudioChannelAdvice() {
    if (hasAudioChannelAdvice()) {
         clear_has_AudioChannelAdvice();
        _AudioChannelAdvice.clear();
     }
}

inline bool VoiceAdviceStart::hasAudioChannelAdvice () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::acr_fi_types::T_AudioChannelAdvice& VoiceAdviceStart::getAudioChannelAdvice () const {
    return _AudioChannelAdvice;
}

inline ::acr_fi_types::T_AudioChannelAdvice& VoiceAdviceStart::getAudioChannelAdviceMutable () {
    set_has_AudioChannelAdvice();
    return _AudioChannelAdvice;
}

inline void VoiceAdviceStart::setAudioChannelAdvice (const ::acr_fi_types::T_AudioChannelAdvice& AudioChannelAdvice_) {
    set_has_AudioChannelAdvice();
    this->_AudioChannelAdvice = AudioChannelAdvice_;
}

inline void VoiceAdviceStart::set_has_AudioChannelAdvice () {
    _has_bits_[0] |= 1u << 0;
}

inline void VoiceAdviceStart::clear_has_AudioChannelAdvice () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  VoiceAdviceError::VoiceAdviceError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = ::CMB_ACR_FI::VoiceAdviceErrorCode__Unspecified;
}

inline  VoiceAdviceError::VoiceAdviceError (const VoiceAdviceError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = ::CMB_ACR_FI::VoiceAdviceErrorCode__Unspecified;
    *this = rhs;
}

inline  VoiceAdviceError::~VoiceAdviceError() {
    deleteData ();
}

inline VoiceAdviceError& VoiceAdviceError::operator = (const VoiceAdviceError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool VoiceAdviceError::operator == (const VoiceAdviceError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool VoiceAdviceError::operator != (const VoiceAdviceError& rhs) const {
    return ! (*this == rhs);
}

inline bool VoiceAdviceError::operator < (const VoiceAdviceError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if ((uint32)getCcaErrorCode() < (uint32)rhs.getCcaErrorCode()) return true;
        if ((uint32)getCcaErrorCode() > (uint32)rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool VoiceAdviceError::operator > (const VoiceAdviceError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline VoiceAdviceError::VoiceAdviceErrorField VoiceAdviceError::getField () const {
    return __field;
}

inline void VoiceAdviceError::setField(VoiceAdviceError::VoiceAdviceErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = ::CMB_ACR_FI::VoiceAdviceErrorCode__Unspecified;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* VoiceAdviceError::clone() {
    return new VoiceAdviceError(*this);
}

inline bool VoiceAdviceError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline VoiceAdviceErrorCode VoiceAdviceError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "VoiceAdviceError", getField());
    }
    return (VoiceAdviceErrorCode) _data.ccaErrorCode_;
}

inline void VoiceAdviceError::setCcaErrorCode (VoiceAdviceErrorCode value) {
    #ifndef NDEBUG
    if (!(VoiceAdviceErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "VoiceAdviceErrorCode", "ccaErrorCode", "VoiceAdviceError");
    }
    #endif
    if (__field != E_CCA_ERROR_CODE) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
    }
    _data.ccaErrorCode_ = (int32)value;
}

inline bool VoiceAdviceError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode VoiceAdviceError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "VoiceAdviceError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void VoiceAdviceError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "VoiceAdviceError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void VoiceAdviceError::cloneData (const VoiceAdviceError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = rhs._data.ccaErrorCode_;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void VoiceAdviceError::deleteData () {
}

inline  ChannelRequestStatus::ChannelRequestStatus ()  :
    _ChannelRequestStatusList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ChannelRequestStatus::ChannelRequestStatus (const ChannelRequestStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _ChannelRequestStatusList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ChannelRequestStatus::ChannelRequestStatus (const ::acr_fi_types::T_ChannelRequestStatusList& ChannelRequestStatusList_)  :
    _ChannelRequestStatusList (ChannelRequestStatusList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ChannelRequestStatus::~ChannelRequestStatus() {
}

inline ChannelRequestStatus& ChannelRequestStatus::operator = (const ChannelRequestStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasChannelRequestStatusList()) {
            setChannelRequestStatusList(rhs.getChannelRequestStatusList());
        } else {
            clearChannelRequestStatusList();
        }
    }
    return *this;
}

inline bool ChannelRequestStatus::operator == (const ChannelRequestStatus& rhs) const {
    return (((!hasChannelRequestStatusList() && !rhs.hasChannelRequestStatusList()) || getChannelRequestStatusList() == rhs.getChannelRequestStatusList()));
}

inline bool ChannelRequestStatus::operator != (const ChannelRequestStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool ChannelRequestStatus::operator < (const ChannelRequestStatus& rhs) const {
    if (hasChannelRequestStatusList() || rhs.hasChannelRequestStatusList()) {
        if (getChannelRequestStatusList() < rhs.getChannelRequestStatusList()) return true;
        if (getChannelRequestStatusList() > rhs.getChannelRequestStatusList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ChannelRequestStatus::clone() {
    return new ChannelRequestStatus(*this);
}

inline bool ChannelRequestStatus::operator > (const ChannelRequestStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ChannelRequestStatus::clear() {
    clearChannelRequestStatusList();
}

inline void ChannelRequestStatus::clearChannelRequestStatusList() {
    if (hasChannelRequestStatusList()) {
         clear_has_ChannelRequestStatusList();
        _ChannelRequestStatusList.clear();
     }
}

inline bool ChannelRequestStatus::hasChannelRequestStatusList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::acr_fi_types::T_ChannelRequestStatusList& ChannelRequestStatus::getChannelRequestStatusList () const {
    return _ChannelRequestStatusList;
}

inline ::acr_fi_types::T_ChannelRequestStatusList& ChannelRequestStatus::getChannelRequestStatusListMutable () {
    set_has_ChannelRequestStatusList();
    return _ChannelRequestStatusList;
}

inline void ChannelRequestStatus::setChannelRequestStatusList (const ::acr_fi_types::T_ChannelRequestStatusList& ChannelRequestStatusList_) {
    set_has_ChannelRequestStatusList();
    this->_ChannelRequestStatusList = ChannelRequestStatusList_;
}

inline void ChannelRequestStatus::set_has_ChannelRequestStatusList () {
    _has_bits_[0] |= 1u << 0;
}

inline void ChannelRequestStatus::clear_has_ChannelRequestStatusList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  InstancesPerCategoryStatus::InstancesPerCategoryStatus ()  :
    _InstancesPerCategoryList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  InstancesPerCategoryStatus::InstancesPerCategoryStatus (const InstancesPerCategoryStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _InstancesPerCategoryList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  InstancesPerCategoryStatus::InstancesPerCategoryStatus (const ::acr_fi_types::T_InstancesPerCategoryList& InstancesPerCategoryList_)  :
    _InstancesPerCategoryList (InstancesPerCategoryList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  InstancesPerCategoryStatus::~InstancesPerCategoryStatus() {
}

inline InstancesPerCategoryStatus& InstancesPerCategoryStatus::operator = (const InstancesPerCategoryStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasInstancesPerCategoryList()) {
            setInstancesPerCategoryList(rhs.getInstancesPerCategoryList());
        } else {
            clearInstancesPerCategoryList();
        }
    }
    return *this;
}

inline bool InstancesPerCategoryStatus::operator == (const InstancesPerCategoryStatus& rhs) const {
    return (((!hasInstancesPerCategoryList() && !rhs.hasInstancesPerCategoryList()) || getInstancesPerCategoryList() == rhs.getInstancesPerCategoryList()));
}

inline bool InstancesPerCategoryStatus::operator != (const InstancesPerCategoryStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool InstancesPerCategoryStatus::operator < (const InstancesPerCategoryStatus& rhs) const {
    if (hasInstancesPerCategoryList() || rhs.hasInstancesPerCategoryList()) {
        if (getInstancesPerCategoryList() < rhs.getInstancesPerCategoryList()) return true;
        if (getInstancesPerCategoryList() > rhs.getInstancesPerCategoryList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* InstancesPerCategoryStatus::clone() {
    return new InstancesPerCategoryStatus(*this);
}

inline bool InstancesPerCategoryStatus::operator > (const InstancesPerCategoryStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void InstancesPerCategoryStatus::clear() {
    clearInstancesPerCategoryList();
}

inline void InstancesPerCategoryStatus::clearInstancesPerCategoryList() {
    if (hasInstancesPerCategoryList()) {
         clear_has_InstancesPerCategoryList();
        _InstancesPerCategoryList.clear();
     }
}

inline bool InstancesPerCategoryStatus::hasInstancesPerCategoryList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::acr_fi_types::T_InstancesPerCategoryList& InstancesPerCategoryStatus::getInstancesPerCategoryList () const {
    return _InstancesPerCategoryList;
}

inline ::acr_fi_types::T_InstancesPerCategoryList& InstancesPerCategoryStatus::getInstancesPerCategoryListMutable () {
    set_has_InstancesPerCategoryList();
    return _InstancesPerCategoryList;
}

inline void InstancesPerCategoryStatus::setInstancesPerCategoryList (const ::acr_fi_types::T_InstancesPerCategoryList& InstancesPerCategoryList_) {
    set_has_InstancesPerCategoryList();
    this->_InstancesPerCategoryList = InstancesPerCategoryList_;
}

inline void InstancesPerCategoryStatus::set_has_InstancesPerCategoryList () {
    _has_bits_[0] |= 1u << 0;
}

inline void InstancesPerCategoryStatus::clear_has_InstancesPerCategoryList () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace CMB_ACR_FI

#endif // CMB_ACR_FI_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
