#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef MIDW_STREAMROUTER_FI_TYPES_H
#define MIDW_STREAMROUTER_FI_TYPES_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/VersionCheck.h"
#include "midw_streamrouter_fi_typesConst.h"
#include <cstring>
#include <string>
#include <vector>

/**
 * Types midw_streamrouter_fi_types
 */

namespace midw_streamrouter_fi_types {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class T_streamrouter_route_entry;

// type definitions
/**
 * If the meaning of "T_streamrouter_routing_list" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_streamrouter_route_entry > T_streamrouter_routing_list;

/**
 * If the meaning of "T_streamrouter_device_list" isn't clear, then there should be a description here.
 */
typedef ::std::vector< ::std::string > T_streamrouter_device_list;


/**
 * This structure holds information about a routing table entry. (u8BlkWidth represented in Bit.)
 */
class T_streamrouter_route_entry {
public:

    /**
     * Default constructor
     */
    inline  T_streamrouter_route_entry ();

    /**
     * Copy constructor
     */
    inline  T_streamrouter_route_entry (const T_streamrouter_route_entry &rhs);

    /**
     * All fields constructor
     */
    inline  T_streamrouter_route_entry (uint32 u32UCID_, uint16 u16AppID_, uint16 u16MLBChannelAddress_, uint8 u8BlkWidth_, T_e8_streamrouter_routestate e8Routestate_);

    /**
     * Destructor
     */
    inline  ~T_streamrouter_route_entry();

    /**
     * Assignment operator
     */
    inline T_streamrouter_route_entry& operator = (const T_streamrouter_route_entry& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_streamrouter_route_entry& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_streamrouter_route_entry& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_streamrouter_route_entry& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_streamrouter_route_entry& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32UCID"

    static const int kU32UCID = 0;

    /**
     * Clears the field "u32UCID".
     *
     * The field will be set to its default value. The hasU32UCID()
     * method will return false.
     */
    inline void clearU32UCID();

    /**
     * Checks whether the field "u32UCID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32UCID()). Otherwise it will return false.
     */
    inline bool hasU32UCID () const;

    /**
     * Returns the value of the member "u32UCID".
     *
     * UCID.
     *
     * @return The value of the field "u32UCID"
     */
    inline uint32 getU32UCID () const;

    /**
     * Sets the value of the member "u32UCID".
     *
     * UCID.
     *
     * @param u32UCID The value which will be set
     */
    inline void setU32UCID (uint32 u32UCID_);

    // API of field "u16AppID"

    static const int kU16AppID = 1;

    /**
     * Clears the field "u16AppID".
     *
     * The field will be set to its default value. The hasU16AppID()
     * method will return false.
     */
    inline void clearU16AppID();

    /**
     * Checks whether the field "u16AppID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16AppID()). Otherwise it will return false.
     */
    inline bool hasU16AppID () const;

    /**
     * Returns the value of the member "u16AppID".
     *
     * AppID which requested the route.
     *
     * @return The value of the field "u16AppID"
     */
    inline uint16 getU16AppID () const;

    /**
     * Sets the value of the member "u16AppID".
     *
     * AppID which requested the route.
     *
     * @param u16AppID The value which will be set
     */
    inline void setU16AppID (uint16 u16AppID_);

    // API of field "u16MLBChannelAddress"

    static const int kU16MLBChannelAddress = 2;

    /**
     * Clears the field "u16MLBChannelAddress".
     *
     * The field will be set to its default value. The hasU16MLBChannelAddress()
     * method will return false.
     */
    inline void clearU16MLBChannelAddress();

    /**
     * Checks whether the field "u16MLBChannelAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16MLBChannelAddress()). Otherwise it will return false.
     */
    inline bool hasU16MLBChannelAddress () const;

    /**
     * Returns the value of the member "u16MLBChannelAddress".
     *
     * MLB channel address assigned to UCID.
     *
     * @return The value of the field "u16MLBChannelAddress"
     */
    inline uint16 getU16MLBChannelAddress () const;

    /**
     * Sets the value of the member "u16MLBChannelAddress".
     *
     * MLB channel address assigned to UCID.
     *
     * @param u16MLBChannelAddress The value which will be set
     */
    inline void setU16MLBChannelAddress (uint16 u16MLBChannelAddress_);

    // API of field "u8BlkWidth"

    static const int kU8BlkWidth = 3;

    /**
     * Clears the field "u8BlkWidth".
     *
     * The field will be set to its default value. The hasU8BlkWidth()
     * method will return false.
     */
    inline void clearU8BlkWidth();

    /**
     * Checks whether the field "u8BlkWidth" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8BlkWidth()). Otherwise it will return false.
     */
    inline bool hasU8BlkWidth () const;

    /**
     * Returns the value of the member "u8BlkWidth".
     *
     * Block width for transmission.
     *
     * @return The value of the field "u8BlkWidth"
     */
    inline uint8 getU8BlkWidth () const;

    /**
     * Sets the value of the member "u8BlkWidth".
     *
     * Block width for transmission.
     *
     * @param u8BlkWidth The value which will be set
     */
    inline void setU8BlkWidth (uint8 u8BlkWidth_);

    // API of field "e8Routestate"

    static const int kE8Routestate = 4;

    /**
     * Clears the field "e8Routestate".
     *
     * The field will be set to its default value. The hasE8Routestate()
     * method will return false.
     */
    inline void clearE8Routestate();

    /**
     * Checks whether the field "e8Routestate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Routestate()). Otherwise it will return false.
     */
    inline bool hasE8Routestate () const;

    /**
     * Returns the value of the member "e8Routestate".
     *
     * State of routing.
     *
     * @return The value of the field "e8Routestate"
     */
    inline T_e8_streamrouter_routestate getE8Routestate () const;

    /**
     * Sets the value of the member "e8Routestate".
     *
     * State of routing.
     *
     * @param e8Routestate The value which will be set
     */
    inline void setE8Routestate (T_e8_streamrouter_routestate e8Routestate_);

    static const T_streamrouter_route_entry &getDefaultInstance();

private:

    inline void set_has_u32UCID ();

    inline void clear_has_u32UCID ();

    inline void set_has_u16AppID ();

    inline void clear_has_u16AppID ();

    inline void set_has_u16MLBChannelAddress ();

    inline void clear_has_u16MLBChannelAddress ();

    inline void set_has_u8BlkWidth ();

    inline void clear_has_u8BlkWidth ();

    inline void set_has_e8Routestate ();

    inline void clear_has_e8Routestate ();

    uint32 _has_bits_[ (5 + 31) / 32];

    uint32 _u32UCID;

    uint16 _u16AppID;

    uint16 _u16MLBChannelAddress;

    uint8 _u8BlkWidth;

    T_e8_streamrouter_routestate _e8Routestate;

};

inline  T_streamrouter_route_entry::T_streamrouter_route_entry ()  :
    _u32UCID (0u),
    _u16AppID (0u),
    _u16MLBChannelAddress (0u),
    _u8BlkWidth (0u),
    _e8Routestate (::midw_streamrouter_fi_types::T_e8_streamrouter_routestate__INIT)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_streamrouter_route_entry::T_streamrouter_route_entry (const T_streamrouter_route_entry &rhs)  :
    _u32UCID (0u),
    _u16AppID (0u),
    _u16MLBChannelAddress (0u),
    _u8BlkWidth (0u),
    _e8Routestate (::midw_streamrouter_fi_types::T_e8_streamrouter_routestate__INIT)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_streamrouter_route_entry::T_streamrouter_route_entry (uint32 u32UCID_, uint16 u16AppID_, uint16 u16MLBChannelAddress_, uint8 u8BlkWidth_, T_e8_streamrouter_routestate e8Routestate_)  :
    _u32UCID (u32UCID_),
    _u16AppID (u16AppID_),
    _u16MLBChannelAddress (u16MLBChannelAddress_),
    _u8BlkWidth (u8BlkWidth_),
    _e8Routestate (e8Routestate_)
{
    #ifndef NDEBUG
    if (!(T_e8_streamrouter_routestate_IsValid(e8Routestate_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Routestate_, "T_e8_streamrouter_routestate", "e8Routestate", "T_streamrouter_route_entry");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_streamrouter_route_entry::~T_streamrouter_route_entry() {
}

inline T_streamrouter_route_entry& T_streamrouter_route_entry::operator = (const T_streamrouter_route_entry& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU32UCID()) {
            setU32UCID(rhs.getU32UCID());
        } else {
            clearU32UCID();
        }
        if (rhs.hasU16AppID()) {
            setU16AppID(rhs.getU16AppID());
        } else {
            clearU16AppID();
        }
        if (rhs.hasU16MLBChannelAddress()) {
            setU16MLBChannelAddress(rhs.getU16MLBChannelAddress());
        } else {
            clearU16MLBChannelAddress();
        }
        if (rhs.hasU8BlkWidth()) {
            setU8BlkWidth(rhs.getU8BlkWidth());
        } else {
            clearU8BlkWidth();
        }
        if (rhs.hasE8Routestate()) {
            setE8Routestate(rhs.getE8Routestate());
        } else {
            clearE8Routestate();
        }
    }
    return *this;
}

inline bool T_streamrouter_route_entry::operator == (const T_streamrouter_route_entry& rhs) const {
    return (((!hasU32UCID() && !rhs.hasU32UCID()) || getU32UCID() == rhs.getU32UCID()) &&
        ((!hasU16AppID() && !rhs.hasU16AppID()) || getU16AppID() == rhs.getU16AppID()) &&
        ((!hasU16MLBChannelAddress() && !rhs.hasU16MLBChannelAddress()) || getU16MLBChannelAddress() == rhs.getU16MLBChannelAddress()) &&
        ((!hasU8BlkWidth() && !rhs.hasU8BlkWidth()) || getU8BlkWidth() == rhs.getU8BlkWidth()) &&
        ((!hasE8Routestate() && !rhs.hasE8Routestate()) || getE8Routestate() == rhs.getE8Routestate()));
}

inline bool T_streamrouter_route_entry::operator != (const T_streamrouter_route_entry& rhs) const {
    return ! (*this == rhs);
}

inline bool T_streamrouter_route_entry::operator < (const T_streamrouter_route_entry& rhs) const {
    if (hasU32UCID() || rhs.hasU32UCID()) {
        if (getU32UCID() < rhs.getU32UCID()) return true;
        if (getU32UCID() > rhs.getU32UCID()) return false;
    }
    if (hasU16AppID() || rhs.hasU16AppID()) {
        if (getU16AppID() < rhs.getU16AppID()) return true;
        if (getU16AppID() > rhs.getU16AppID()) return false;
    }
    if (hasU16MLBChannelAddress() || rhs.hasU16MLBChannelAddress()) {
        if (getU16MLBChannelAddress() < rhs.getU16MLBChannelAddress()) return true;
        if (getU16MLBChannelAddress() > rhs.getU16MLBChannelAddress()) return false;
    }
    if (hasU8BlkWidth() || rhs.hasU8BlkWidth()) {
        if (getU8BlkWidth() < rhs.getU8BlkWidth()) return true;
        if (getU8BlkWidth() > rhs.getU8BlkWidth()) return false;
    }
    if (hasE8Routestate() || rhs.hasE8Routestate()) {
        if ((uint32)getE8Routestate() < (uint32)rhs.getE8Routestate()) return true;
        if ((uint32)getE8Routestate() > (uint32)rhs.getE8Routestate()) return false;
    }
    return false;
}

inline bool T_streamrouter_route_entry::operator > (const T_streamrouter_route_entry& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_streamrouter_route_entry::clear() {
    clearU32UCID();
    clearU16AppID();
    clearU16MLBChannelAddress();
    clearU8BlkWidth();
    clearE8Routestate();
}

inline void T_streamrouter_route_entry::clearU32UCID() {
    if (hasU32UCID()) {
         clear_has_u32UCID();
        _u32UCID = 0u;
     }
}

inline bool T_streamrouter_route_entry::hasU32UCID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_streamrouter_route_entry::getU32UCID () const {
    return _u32UCID;
}

inline void T_streamrouter_route_entry::setU32UCID (uint32 u32UCID_) {
    set_has_u32UCID();
    this->_u32UCID = u32UCID_;
}

inline void T_streamrouter_route_entry::clearU16AppID() {
    if (hasU16AppID()) {
         clear_has_u16AppID();
        _u16AppID = 0u;
     }
}

inline bool T_streamrouter_route_entry::hasU16AppID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 T_streamrouter_route_entry::getU16AppID () const {
    return _u16AppID;
}

inline void T_streamrouter_route_entry::setU16AppID (uint16 u16AppID_) {
    set_has_u16AppID();
    this->_u16AppID = u16AppID_;
}

inline void T_streamrouter_route_entry::clearU16MLBChannelAddress() {
    if (hasU16MLBChannelAddress()) {
         clear_has_u16MLBChannelAddress();
        _u16MLBChannelAddress = 0u;
     }
}

inline bool T_streamrouter_route_entry::hasU16MLBChannelAddress () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 T_streamrouter_route_entry::getU16MLBChannelAddress () const {
    return _u16MLBChannelAddress;
}

inline void T_streamrouter_route_entry::setU16MLBChannelAddress (uint16 u16MLBChannelAddress_) {
    set_has_u16MLBChannelAddress();
    this->_u16MLBChannelAddress = u16MLBChannelAddress_;
}

inline void T_streamrouter_route_entry::clearU8BlkWidth() {
    if (hasU8BlkWidth()) {
         clear_has_u8BlkWidth();
        _u8BlkWidth = 0u;
     }
}

inline bool T_streamrouter_route_entry::hasU8BlkWidth () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 T_streamrouter_route_entry::getU8BlkWidth () const {
    return _u8BlkWidth;
}

inline void T_streamrouter_route_entry::setU8BlkWidth (uint8 u8BlkWidth_) {
    set_has_u8BlkWidth();
    this->_u8BlkWidth = u8BlkWidth_;
}

inline void T_streamrouter_route_entry::clearE8Routestate() {
    if (hasE8Routestate()) {
         clear_has_e8Routestate();
        _e8Routestate = ::midw_streamrouter_fi_types::T_e8_streamrouter_routestate__INIT;
     }
}

inline bool T_streamrouter_route_entry::hasE8Routestate () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline T_e8_streamrouter_routestate T_streamrouter_route_entry::getE8Routestate () const {
    return _e8Routestate;
}

inline void T_streamrouter_route_entry::setE8Routestate (T_e8_streamrouter_routestate e8Routestate_) {
    #ifndef NDEBUG
    if (!(T_e8_streamrouter_routestate_IsValid(e8Routestate_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Routestate_, "T_e8_streamrouter_routestate", "e8Routestate", "T_streamrouter_route_entry");
    }
    #endif
    set_has_e8Routestate();
    this->_e8Routestate = e8Routestate_;
}

inline void T_streamrouter_route_entry::set_has_u32UCID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_streamrouter_route_entry::clear_has_u32UCID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_streamrouter_route_entry::set_has_u16AppID () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_streamrouter_route_entry::clear_has_u16AppID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_streamrouter_route_entry::set_has_u16MLBChannelAddress () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_streamrouter_route_entry::clear_has_u16MLBChannelAddress () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_streamrouter_route_entry::set_has_u8BlkWidth () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_streamrouter_route_entry::clear_has_u8BlkWidth () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_streamrouter_route_entry::set_has_e8Routestate () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_streamrouter_route_entry::clear_has_e8Routestate () {
    _has_bits_[0] &= ~ (1u << 4);
}

} // namespace midw_streamrouter_fi_types

#endif // MIDW_STREAMROUTER_FI_TYPES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
