/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef MIDW_STREAMROUTER_FIPROXY_H
#define MIDW_STREAMROUTER_FIPROXY_H

#include "asf/cca/CcaProxy.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "midw_streamrouter_fi.h"
#include "midw_streamrouter_fi_typesConst.h"

namespace midw_streamrouter_fi {

class Midw_streamrouter_fiProxy;

class AllocateRouteCallbackIF {
public:
    virtual ~AllocateRouteCallbackIF() {}

    virtual void onAllocateRouteError(const ::boost::shared_ptr< Midw_streamrouter_fiProxy >& proxy, const ::boost::shared_ptr< AllocateRouteError >& error) = 0;

    virtual void onAllocateRouteResult(const ::boost::shared_ptr< Midw_streamrouter_fiProxy >& proxy, const ::boost::shared_ptr< AllocateRouteResult >& result) = 0;
};

class DeAllocateRouteCallbackIF {
public:
    virtual ~DeAllocateRouteCallbackIF() {}

    virtual void onDeAllocateRouteError(const ::boost::shared_ptr< Midw_streamrouter_fiProxy >& proxy, const ::boost::shared_ptr< DeAllocateRouteError >& error) = 0;

    virtual void onDeAllocateRouteResult(const ::boost::shared_ptr< Midw_streamrouter_fiProxy >& proxy, const ::boost::shared_ptr< DeAllocateRouteResult >& result) = 0;
};

class RoutingStateCallbackIF {
public:
    virtual ~RoutingStateCallbackIF() {}

    virtual void onRoutingStateError(const ::boost::shared_ptr< Midw_streamrouter_fiProxy >& proxy, const ::boost::shared_ptr< RoutingStateError >& error) = 0;

    virtual void onRoutingStateStatus(const ::boost::shared_ptr< Midw_streamrouter_fiProxy >& proxy, const ::boost::shared_ptr< RoutingStateStatus >& status) = 0;
};

class SendFGCommandCallbackIF {
public:
    virtual ~SendFGCommandCallbackIF() {}

    virtual void onSendFGCommandError(const ::boost::shared_ptr< Midw_streamrouter_fiProxy >& proxy, const ::boost::shared_ptr< SendFGCommandError >& error) = 0;

    virtual void onSendFGCommandResult(const ::boost::shared_ptr< Midw_streamrouter_fiProxy >& proxy, const ::boost::shared_ptr< SendFGCommandResult >& result) = 0;
};

class SetPlayCallbackIF {
public:
    virtual ~SetPlayCallbackIF() {}

    virtual void onSetPlayError(const ::boost::shared_ptr< Midw_streamrouter_fiProxy >& proxy, const ::boost::shared_ptr< SetPlayError >& error) = 0;

    virtual void onSetPlayResult(const ::boost::shared_ptr< Midw_streamrouter_fiProxy >& proxy, const ::boost::shared_ptr< SetPlayResult >& result) = 0;
};

class SetStopCallbackIF {
public:
    virtual ~SetStopCallbackIF() {}

    virtual void onSetStopError(const ::boost::shared_ptr< Midw_streamrouter_fiProxy >& proxy, const ::boost::shared_ptr< SetStopError >& error) = 0;

    virtual void onSetStopResult(const ::boost::shared_ptr< Midw_streamrouter_fiProxy >& proxy, const ::boost::shared_ptr< SetStopResult >& result) = 0;
};

class Midw_streamrouter_fiProxyCallback;

/**
 * Midw_streamrouter_fiProxy is the client side representation of the CCA
 * Functional Interface 'midw_streamrouter_fi' (specified in file
 * midw_streamrouter_fi.xml).
 *
 * CCA Functional Interface 'midw_streamrouter_fi'
 *
 * Fullname: Stream Router Service, Application Functional Interface
 *
 * Version: $Revision:   1.0  $
 *
 * Author: Marcus Benthin / Roland Jensch
 *
 * Date: $Date:  25.06.2009  $
 *
 * Department:
 *
 * Title: midw_streamrouter_fi
 *
 * <b>Description of 'midw_streamrouter_fi':</b>
 *
 * ..
 */
class Midw_streamrouter_fiProxy : public ::asf::cca::CcaProxy
{
public:

    /**
     * Create a new instance of Midw_streamrouter_fiProxy. The caller has to
     * pass the port name and the service information. It is only possible to
     * use this function if the port is defined in the CMC model as "wired at
     * runtime"-port. The application id of the CCA Server will be determined
     * with help of the CCA SrvSupplier messages. It's guranteed that the
     * corresponding CCA server will have the specified major version and at
     * least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Midw_streamrouter_fiProxy > createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Midw_streamrouter_fiProxy. The caller has to
     * pass the port name and the service information. It is only possible to
     * use this function if the port is defined in the CMC model as "wired at
     * runtime"-port. The proxy will connect to the CCA application specified
     * by appId. The CCA SrvSupplier messages will be used to determine the
     * availability of this application and the service. It's guranteed that
     * the corresponding CCA server will have the specified major version and
     * at least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Midw_streamrouter_fiProxy > createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Midw_streamrouter_fiProxy. The caller has to
     * pass the port name. The port name is defined in the "Car Multimedia
     * Component" model. With the help of the port name it is possible to
     * address the concrete proxy, which is defined in the CMC model
     * description.
     */
    static ::boost::shared_ptr< Midw_streamrouter_fiProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Destructor of Midw_streamrouter_fiProxy. The destructor will send
     * RelUpReg messages for all property notifications and call the error
     * callback of all pending method invocations.
     */
    ~Midw_streamrouter_fiProxy();

    // Method 'AllocateRoute'

    /**
     * Call the method 'AllocateRoute'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'AllocateRoute'</b>:
     *
     * Allocate a route.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u16UCID If the meaning of "u16UCID" isn't clear, then there should be a description here.
     *
     * @param s32STM_MsgBufID If the meaning of "s32STM_MsgBufID" isn't clear, then there should be a description here.
     *
     * @param u16Sink If the meaning of "u16Sink" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAllocateRouteStart(AllocateRouteCallbackIF& cb, uint16 u16UCID, int32 s32STM_MsgBufID, uint16 u16Sink);

    // Method 'DeAllocateRoute'

    /**
     * Call the method 'DeAllocateRoute'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'DeAllocateRoute'</b>:
     *
     * Deallocate a route.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u16UCID If the meaning of "u16UCID" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDeAllocateRouteStart(DeAllocateRouteCallbackIF& cb, uint16 u16UCID);

    // Method 'SetPlay'

    /**
     * Call the method 'SetPlay'. This method sends a MethodStart message to
     * the CCA server.
     *
     * <b>Documentation of 'SetPlay'</b>:
     *
     * Start streaming.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u16UCID If the meaning of "u16UCID" isn't clear, then there should be a description here.
     *
     * @param eRampType Ramp type used to start playing.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetPlayStart(SetPlayCallbackIF& cb, uint16 u16UCID, ::midw_streamrouter_fi_types::T_e8_streamrouter_ramptype eRampType);

    // Method 'SetStop'

    /**
     * Call the method 'SetStop'. This method sends a MethodStart message to
     * the CCA server.
     *
     * <b>Documentation of 'SetStop'</b>:
     *
     * Stop streaming.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u16UCID If the meaning of "u16UCID" isn't clear, then there should be a description here.
     *
     * @param eRampType Ramp type used to stop.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetStopStart(SetStopCallbackIF& cb, uint16 u16UCID, ::midw_streamrouter_fi_types::T_e8_streamrouter_ramptype eRampType);

    // Method 'SendFGCommand'

    /**
     * Call the method 'SendFGCommand'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SendFGCommand'</b>:
     *
     * Mute/Demute mic directly on Streammanager Route ID.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u16UCID If the meaning of "u16UCID" isn't clear, then there should be a description here.
     *
     * @param u16FGRouteID Streammanager Route ID. If 0, StreamRouter will try to figure out.
     *
     * @param eCmd Command to be send to Streammanager.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSendFGCommandStart(SendFGCommandCallbackIF& cb, uint16 u16UCID, uint16 u16FGRouteID, ::midw_streamrouter_fi_types::T_e8_streamrouter_fgcommand eCmd);

    // Property 'RoutingState'

    /**
     * Notify on the property 'RoutingState'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'RoutingState'</b>:
     *
     * informs about routing state
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRoutingStateUpReg(RoutingStateCallbackIF& cb);

    /**
     * Remove the notifcation on property 'RoutingState'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'RoutingState'</b>:
     *
     * informs about routing state
     *
     * @param act The act which was previously returned by the
     * sendRoutingStateUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendRoutingStateRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'RoutingState'.
     */
    void sendRoutingStateRelUpRegAll ();

    /**
     * Returns the current value of the property 'RoutingState' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasRoutingState() returns true.
     *
     * @return the previously received value of the property 'RoutingState'.
     */
    const RoutingStateStatus& getRoutingState() const;

    /**
     * Determines whether a status message for the property 'RoutingState' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasRoutingState() const;

    /**
     * Request the value of the property 'RoutingState' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'RoutingState'</b>:
     *
     * informs about routing state
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     * @param s32UCID <p>Get routing state for specific UCID. If negative, all active routes returned.</p>
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRoutingStateGet(RoutingStateCallbackIF& cb, int32 s32UCID);

    /**
     * Release all property notifications (on all properties).
     */
    void sendRelUpRegAll ();

private:

    Midw_streamrouter_fiProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags);

    virtual void clearAllProperties ();

    ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > createCallback (uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb);

    // Property 'RoutingState'

    ::asf::core::nullable< RoutingStateStatus > _routingState;

    DECLARE_CLASS_LOGGER();

    friend class Midw_streamrouter_fiProxyCallback;
};

} // namespace midw_streamrouter_fi

#endif // MIDW_STREAMROUTER_FIPROXY_H
