/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/cca/CcaTypesConst.h"
#include "asf/stream/json.h"
#include "midw_streamrouter_fi.h"
#include "midw_streamrouter_fiJson.h"
#include "midw_streamrouter_fiJsonPrivate.h"
#include "midw_streamrouter_fi_types.h"
#include "midw_streamrouter_fi_typesConst.h"
#include "midw_streamrouter_fi_typesJsonPrivate.h"
#include "yajl/yajl_gen.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

using namespace ::asf::stream::json;


// Json serialization of "RoutingStateStatus"

void serializeJson (const ::midw_streamrouter_fi::RoutingStateStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRouting_list()) {
        yajl_gen_string(g, (const unsigned char*)  "routing_list" , 12);
        yajl_gen_array_open(g);
        const ::std::vector< ::midw_streamrouter_fi_types::T_streamrouter_route_entry >& o1 = value.getRouting_list();
        {
            ::std::vector< ::midw_streamrouter_fi_types::T_streamrouter_route_entry >::const_iterator o0;
            for (o0 = o1.begin(); o0 != o1.end(); ++o0) {
                serializeJson((*o0), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_streamrouter_fi::RoutingStateStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RoutingStateGet"

void serializeJson (const ::midw_streamrouter_fi::RoutingStateGet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasS32UCID()) {
        yajl_gen_string(g, (const unsigned char*)  "s32UCID" , 7);
        yajl_gen_integer(g, (long long)value.getS32UCID());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_streamrouter_fi::RoutingStateGet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RoutingStateErrorStructure"

void serializeJson (const ::midw_streamrouter_fi::RoutingStateErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU16ErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "u16ErrorCode" , 12);
        yajl_gen_integer(g, (long long)value.getU16ErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_streamrouter_fi::RoutingStateErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RoutingStateError"

void serializeJson (const ::midw_streamrouter_fi::RoutingStateError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::midw_streamrouter_fi::RoutingStateError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::midw_streamrouter_fi::RoutingStateError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::midw_streamrouter_fi::RoutingStateError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AllocateRouteStart"

void serializeJson (const ::midw_streamrouter_fi::AllocateRouteStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU16UCID()) {
        yajl_gen_string(g, (const unsigned char*)  "u16UCID" , 7);
        yajl_gen_integer(g, (long long)value.getU16UCID());
    }
    if (!isSparse || value.hasS32STM_MsgBufID()) {
        yajl_gen_string(g, (const unsigned char*)  "s32STM_MsgBufID" , 15);
        yajl_gen_integer(g, (long long)value.getS32STM_MsgBufID());
    }
    if (!isSparse || value.hasU16Sink()) {
        yajl_gen_string(g, (const unsigned char*)  "u16Sink" , 7);
        yajl_gen_integer(g, (long long)value.getU16Sink());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_streamrouter_fi::AllocateRouteStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AllocateRouteResult"

void serializeJson (const ::midw_streamrouter_fi::AllocateRouteResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU16UCID()) {
        yajl_gen_string(g, (const unsigned char*)  "u16UCID" , 7);
        yajl_gen_integer(g, (long long)value.getU16UCID());
    }
    if (!isSparse || value.hasU32STM_MsgBufID()) {
        yajl_gen_string(g, (const unsigned char*)  "u32STM_MsgBufID" , 15);
        yajl_gen_integer(g, (long long)value.getU32STM_MsgBufID());
    }
    if (!isSparse || value.hasU16MOSTConnectionLabel()) {
        yajl_gen_string(g, (const unsigned char*)  "u16MOSTConnectionLabel" , 22);
        yajl_gen_integer(g, (long long)value.getU16MOSTConnectionLabel());
    }
    if (!isSparse || value.hasU16MLBChannelAddress()) {
        yajl_gen_string(g, (const unsigned char*)  "u16MLBChannelAddress" , 20);
        yajl_gen_integer(g, (long long)value.getU16MLBChannelAddress());
    }
    if (!isSparse || value.hasU8BlkWidth()) {
        yajl_gen_string(g, (const unsigned char*)  "u8BlkWidth" , 10);
        yajl_gen_integer(g, (long long)value.getU8BlkWidth());
    }
    if (!isSparse || value.hasU32SmHandle()) {
        yajl_gen_string(g, (const unsigned char*)  "u32SmHandle" , 11);
        yajl_gen_integer(g, (long long)value.getU32SmHandle());
    }
    if (!isSparse || value.hasListInputDev()) {
        yajl_gen_string(g, (const unsigned char*)  "listInputDev" , 12);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o3 = value.getListInputDev();
        {
            ::std::vector< ::std::string >::const_iterator o2;
            for (o2 = o3.begin(); o2 != o3.end(); ++o2) {
                const char *s = (*o2).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasListOutputDev()) {
        yajl_gen_string(g, (const unsigned char*)  "listOutputDev" , 13);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o5 = value.getListOutputDev();
        {
            ::std::vector< ::std::string >::const_iterator o4;
            for (o4 = o5.begin(); o4 != o5.end(); ++o4) {
                const char *s = (*o4).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_streamrouter_fi::AllocateRouteResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AllocateRouteErrorStructure"

void serializeJson (const ::midw_streamrouter_fi::AllocateRouteErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU16ErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "u16ErrorCode" , 12);
        yajl_gen_integer(g, (long long)value.getU16ErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_streamrouter_fi::AllocateRouteErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AllocateRouteError"

void serializeJson (const ::midw_streamrouter_fi::AllocateRouteError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::midw_streamrouter_fi::AllocateRouteError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::midw_streamrouter_fi::AllocateRouteError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::midw_streamrouter_fi::AllocateRouteError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DeAllocateRouteStart"

void serializeJson (const ::midw_streamrouter_fi::DeAllocateRouteStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU16UCID()) {
        yajl_gen_string(g, (const unsigned char*)  "u16UCID" , 7);
        yajl_gen_integer(g, (long long)value.getU16UCID());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_streamrouter_fi::DeAllocateRouteStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DeAllocateRouteResult"

void serializeJson (const ::midw_streamrouter_fi::DeAllocateRouteResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU16UCID()) {
        yajl_gen_string(g, (const unsigned char*)  "u16UCID" , 7);
        yajl_gen_integer(g, (long long)value.getU16UCID());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_streamrouter_fi::DeAllocateRouteResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DeAllocateRouteErrorStructure"

void serializeJson (const ::midw_streamrouter_fi::DeAllocateRouteErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU16ErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "u16ErrorCode" , 12);
        yajl_gen_integer(g, (long long)value.getU16ErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_streamrouter_fi::DeAllocateRouteErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DeAllocateRouteError"

void serializeJson (const ::midw_streamrouter_fi::DeAllocateRouteError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::midw_streamrouter_fi::DeAllocateRouteError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::midw_streamrouter_fi::DeAllocateRouteError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::midw_streamrouter_fi::DeAllocateRouteError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetPlayStart"

void serializeJson (const ::midw_streamrouter_fi::SetPlayStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU16UCID()) {
        yajl_gen_string(g, (const unsigned char*)  "u16UCID" , 7);
        yajl_gen_integer(g, (long long)value.getU16UCID());
    }
    if (!isSparse || value.hasERampType()) {
        yajl_gen_string(g, (const unsigned char*)  "eRampType" , 9);
        const char* s = ::midw_streamrouter_fi_types::T_e8_streamrouter_ramptype_Name(value.getERampType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getERampType());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_streamrouter_fi::SetPlayStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetPlayResult"

void serializeJson (const ::midw_streamrouter_fi::SetPlayResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU16UCID()) {
        yajl_gen_string(g, (const unsigned char*)  "u16UCID" , 7);
        yajl_gen_integer(g, (long long)value.getU16UCID());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_streamrouter_fi::SetPlayResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetPlayErrorStructure"

void serializeJson (const ::midw_streamrouter_fi::SetPlayErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU16ErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "u16ErrorCode" , 12);
        yajl_gen_integer(g, (long long)value.getU16ErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_streamrouter_fi::SetPlayErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetPlayError"

void serializeJson (const ::midw_streamrouter_fi::SetPlayError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::midw_streamrouter_fi::SetPlayError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::midw_streamrouter_fi::SetPlayError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::midw_streamrouter_fi::SetPlayError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetStopStart"

void serializeJson (const ::midw_streamrouter_fi::SetStopStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU16UCID()) {
        yajl_gen_string(g, (const unsigned char*)  "u16UCID" , 7);
        yajl_gen_integer(g, (long long)value.getU16UCID());
    }
    if (!isSparse || value.hasERampType()) {
        yajl_gen_string(g, (const unsigned char*)  "eRampType" , 9);
        const char* s = ::midw_streamrouter_fi_types::T_e8_streamrouter_ramptype_Name(value.getERampType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getERampType());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_streamrouter_fi::SetStopStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetStopResult"

void serializeJson (const ::midw_streamrouter_fi::SetStopResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU16UCID()) {
        yajl_gen_string(g, (const unsigned char*)  "u16UCID" , 7);
        yajl_gen_integer(g, (long long)value.getU16UCID());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_streamrouter_fi::SetStopResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetStopErrorStructure"

void serializeJson (const ::midw_streamrouter_fi::SetStopErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU16ErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "u16ErrorCode" , 12);
        yajl_gen_integer(g, (long long)value.getU16ErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_streamrouter_fi::SetStopErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetStopError"

void serializeJson (const ::midw_streamrouter_fi::SetStopError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::midw_streamrouter_fi::SetStopError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::midw_streamrouter_fi::SetStopError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::midw_streamrouter_fi::SetStopError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SendFGCommandStart"

void serializeJson (const ::midw_streamrouter_fi::SendFGCommandStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU16UCID()) {
        yajl_gen_string(g, (const unsigned char*)  "u16UCID" , 7);
        yajl_gen_integer(g, (long long)value.getU16UCID());
    }
    if (!isSparse || value.hasU16FGRouteID()) {
        yajl_gen_string(g, (const unsigned char*)  "u16FGRouteID" , 12);
        yajl_gen_integer(g, (long long)value.getU16FGRouteID());
    }
    if (!isSparse || value.hasECmd()) {
        yajl_gen_string(g, (const unsigned char*)  "eCmd" , 4);
        const char* s = ::midw_streamrouter_fi_types::T_e8_streamrouter_fgcommand_Name(value.getECmd());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getECmd());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_streamrouter_fi::SendFGCommandStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SendFGCommandResult"

void serializeJson (const ::midw_streamrouter_fi::SendFGCommandResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU16UCID()) {
        yajl_gen_string(g, (const unsigned char*)  "u16UCID" , 7);
        yajl_gen_integer(g, (long long)value.getU16UCID());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_streamrouter_fi::SendFGCommandResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SendFGCommandErrorStructure"

void serializeJson (const ::midw_streamrouter_fi::SendFGCommandErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU16ErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "u16ErrorCode" , 12);
        yajl_gen_integer(g, (long long)value.getU16ErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_streamrouter_fi::SendFGCommandErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SendFGCommandError"

void serializeJson (const ::midw_streamrouter_fi::SendFGCommandError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::midw_streamrouter_fi::SendFGCommandError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::midw_streamrouter_fi::SendFGCommandError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::midw_streamrouter_fi::SendFGCommandError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

using namespace ::asf::stream::json;

namespace midw_streamrouter_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_streamrouter_fi::RoutingStateStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_streamrouter_fi
using namespace ::asf::stream::json;

namespace midw_streamrouter_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_streamrouter_fi::RoutingStateGet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_streamrouter_fi
using namespace ::asf::stream::json;

namespace midw_streamrouter_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_streamrouter_fi::RoutingStateErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_streamrouter_fi
using namespace ::asf::stream::json;

namespace midw_streamrouter_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_streamrouter_fi::RoutingStateError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_streamrouter_fi
using namespace ::asf::stream::json;

namespace midw_streamrouter_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_streamrouter_fi::AllocateRouteStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_streamrouter_fi
using namespace ::asf::stream::json;

namespace midw_streamrouter_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_streamrouter_fi::AllocateRouteResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_streamrouter_fi
using namespace ::asf::stream::json;

namespace midw_streamrouter_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_streamrouter_fi::AllocateRouteErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_streamrouter_fi
using namespace ::asf::stream::json;

namespace midw_streamrouter_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_streamrouter_fi::AllocateRouteError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_streamrouter_fi
using namespace ::asf::stream::json;

namespace midw_streamrouter_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_streamrouter_fi::DeAllocateRouteStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_streamrouter_fi
using namespace ::asf::stream::json;

namespace midw_streamrouter_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_streamrouter_fi::DeAllocateRouteResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_streamrouter_fi
using namespace ::asf::stream::json;

namespace midw_streamrouter_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_streamrouter_fi::DeAllocateRouteErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_streamrouter_fi
using namespace ::asf::stream::json;

namespace midw_streamrouter_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_streamrouter_fi::DeAllocateRouteError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_streamrouter_fi
using namespace ::asf::stream::json;

namespace midw_streamrouter_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_streamrouter_fi::SetPlayStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_streamrouter_fi
using namespace ::asf::stream::json;

namespace midw_streamrouter_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_streamrouter_fi::SetPlayResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_streamrouter_fi
using namespace ::asf::stream::json;

namespace midw_streamrouter_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_streamrouter_fi::SetPlayErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_streamrouter_fi
using namespace ::asf::stream::json;

namespace midw_streamrouter_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_streamrouter_fi::SetPlayError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_streamrouter_fi
using namespace ::asf::stream::json;

namespace midw_streamrouter_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_streamrouter_fi::SetStopStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_streamrouter_fi
using namespace ::asf::stream::json;

namespace midw_streamrouter_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_streamrouter_fi::SetStopResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_streamrouter_fi
using namespace ::asf::stream::json;

namespace midw_streamrouter_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_streamrouter_fi::SetStopErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_streamrouter_fi
using namespace ::asf::stream::json;

namespace midw_streamrouter_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_streamrouter_fi::SetStopError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_streamrouter_fi
using namespace ::asf::stream::json;

namespace midw_streamrouter_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_streamrouter_fi::SendFGCommandStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_streamrouter_fi
using namespace ::asf::stream::json;

namespace midw_streamrouter_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_streamrouter_fi::SendFGCommandResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_streamrouter_fi
using namespace ::asf::stream::json;

namespace midw_streamrouter_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_streamrouter_fi::SendFGCommandErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_streamrouter_fi
using namespace ::asf::stream::json;

namespace midw_streamrouter_fi {

std::ostream& operator<<(std::ostream& o, const ::midw_streamrouter_fi::SendFGCommandError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_streamrouter_fi

