#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef MIDW_STREAMROUTER_FI_H
#define MIDW_STREAMROUTER_FI_H

#include "asf/cca/CcaTypes.h"
#include "asf/cca/CcaTypesConst.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/VersionCheck.h"
#include "midw_streamrouter_fi_types.h"
#include "midw_streamrouter_fi_typesConst.h"
#include <cstring>
#include <string>
#include <vector>

/**
 * CCA Functional Interface 'midw_streamrouter_fi'
 *
 * Fullname: Stream Router Service, Application Functional Interface
 *
 * Version: $Revision:   1.0  $
 *
 * Author: Marcus Benthin / Roland Jensch
 *
 * Date: $Date:  25.06.2009  $
 *
 * Department:
 *
 * Title: midw_streamrouter_fi
 *
 * <b>Description of 'midw_streamrouter_fi':</b>
 *
 * ..
 */

namespace midw_streamrouter_fi {

static const int SERVICE_ID = 609;

static const int FID_RoutingState = 1;

static const int FID_AllocateRoute = 32784;

static const int FID_DeAllocateRoute = 32785;

static const int FID_SetPlay = 32786;

static const int FID_SetStop = 32787;

static const int FID_SendFGCommand = 32790;


ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 1;

static const int VERSION_MINOR = 0;

static const int VERSION_PATCH = 0;

// forward declarations
class RoutingStateStatus;

class RoutingStateGet;

class RoutingStateErrorStructure;

class RoutingStateError;

class AllocateRouteStart;

class AllocateRouteResult;

class AllocateRouteErrorStructure;

class AllocateRouteError;

class DeAllocateRouteStart;

class DeAllocateRouteResult;

class DeAllocateRouteErrorStructure;

class DeAllocateRouteError;

class SetPlayStart;

class SetPlayResult;

class SetPlayErrorStructure;

class SetPlayError;

class SetStopStart;

class SetStopResult;

class SetStopErrorStructure;

class SetStopError;

class SendFGCommandStart;

class SendFGCommandResult;

class SendFGCommandErrorStructure;

class SendFGCommandError;

// type definitions
/**
 * The upreg message of the property "RoutingState"
 * informs about routing state
 * Status is sent on change to the registered clients.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RoutingStateUpReg;

/**
 * The relUpReg message of the property "RoutingState"
 * informs about routing state
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RoutingStateRelUpReg;

/**
 * The abort error message of the method "AllocateRoute"
 * Allocate a route.
 */
typedef ::asf::cca::CcaTypes::DefaultError AllocateRouteAbortError;

/**
 * The abort error message of the method "DeAllocateRoute"
 * Deallocate a route.
 */
typedef ::asf::cca::CcaTypes::DefaultError DeAllocateRouteAbortError;

/**
 * The abort error message of the method "SetPlay"
 * Start streaming.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetPlayAbortError;

/**
 * The abort error message of the method "SetStop"
 * Stop streaming.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetStopAbortError;

/**
 * The abort error message of the method "SendFGCommand"
 * Mute/Demute mic directly on Streammanager Route ID.
 */
typedef ::asf::cca::CcaTypes::DefaultError SendFGCommandAbortError;


/**
 * The status message of the property "RoutingState"
 * informs about routing state
 */
class RoutingStateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RoutingStateStatus ();

    /**
     * Copy constructor
     */
    inline  RoutingStateStatus (const RoutingStateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  RoutingStateStatus (const ::midw_streamrouter_fi_types::T_streamrouter_routing_list& routing_list_);

    /**
     * Destructor
     */
    inline virtual  ~RoutingStateStatus();

    /**
     * Assignment operator
     */
    inline RoutingStateStatus& operator = (const RoutingStateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RoutingStateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RoutingStateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RoutingStateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RoutingStateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "routing_list"

    static const int kRouting_list = 0;

    /**
     * Clears the field "routing_list".
     *
     * The field will be set to its default value. The hasRouting_list()
     * method will return false.
     */
    inline void clearRouting_list();

    /**
     * Checks whether the field "routing_list" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRouting_list()). Otherwise it will return false.
     */
    inline bool hasRouting_list () const;

    /**
     * Returns the value of the member "routing_list".
     *
     * Routing List contains the routing infos for each route set up. If no route, the list is empty.
     *
     * @return The value of the field "routing_list"
     */
    inline const ::midw_streamrouter_fi_types::T_streamrouter_routing_list& getRouting_list () const;

    /**
     * Retrieves the value of the field "routing_list" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "routing_list".
     */
    inline ::midw_streamrouter_fi_types::T_streamrouter_routing_list& getRouting_listMutable ();

    /**
     * Sets the value of the member "routing_list".
     *
     * Routing List contains the routing infos for each route set up. If no route, the list is empty.
     *
     * @param routing_list The value which will be set
     */
    inline void setRouting_list (const ::midw_streamrouter_fi_types::T_streamrouter_routing_list& routing_list_);

    static const RoutingStateStatus &getDefaultInstance();

private:

    static const ::std::vector< ::midw_streamrouter_fi_types::T_streamrouter_route_entry >& getT_streamrouter_route_entryList_DefaultInstance ();

    inline void set_has_routing_list ();

    inline void clear_has_routing_list ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::midw_streamrouter_fi_types::T_streamrouter_routing_list _routing_list;

};

/**
 * The get message of the property "RoutingState"
 * informs about routing state
 */
class RoutingStateGet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RoutingStateGet ();

    /**
     * Copy constructor
     */
    inline  RoutingStateGet (const RoutingStateGet &rhs);

    /**
     * All fields constructor
     */
    inline  RoutingStateGet (int32 s32UCID_);

    /**
     * Destructor
     */
    inline virtual  ~RoutingStateGet();

    /**
     * Assignment operator
     */
    inline RoutingStateGet& operator = (const RoutingStateGet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RoutingStateGet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RoutingStateGet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RoutingStateGet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RoutingStateGet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s32UCID"

    static const int kS32UCID = 0;

    /**
     * Clears the field "s32UCID".
     *
     * The field will be set to its default value. The hasS32UCID()
     * method will return false.
     */
    inline void clearS32UCID();

    /**
     * Checks whether the field "s32UCID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32UCID()). Otherwise it will return false.
     */
    inline bool hasS32UCID () const;

    /**
     * Returns the value of the member "s32UCID".
     *
     * <p>Get routing state for specific UCID. If negative, all active routes returned.</p>
     *
     * @return The value of the field "s32UCID"
     */
    inline int32 getS32UCID () const;

    /**
     * Sets the value of the member "s32UCID".
     *
     * <p>Get routing state for specific UCID. If negative, all active routes returned.</p>
     *
     * @param s32UCID The value which will be set
     */
    inline void setS32UCID (int32 s32UCID_);

    static const RoutingStateGet &getDefaultInstance();

private:

    inline void set_has_s32UCID ();

    inline void clear_has_s32UCID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _s32UCID;

};

/**
 * The error message of 'RoutingState'
 */
class RoutingStateErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  RoutingStateErrorStructure ();

    /**
     * Copy constructor
     */
    inline  RoutingStateErrorStructure (const RoutingStateErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  RoutingStateErrorStructure (uint16 u16ErrorCode_);

    /**
     * Destructor
     */
    inline  ~RoutingStateErrorStructure();

    /**
     * Assignment operator
     */
    inline RoutingStateErrorStructure& operator = (const RoutingStateErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RoutingStateErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RoutingStateErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RoutingStateErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RoutingStateErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ErrorCode"

    static const int kU16ErrorCode = 0;

    /**
     * Clears the field "u16ErrorCode".
     *
     * The field will be set to its default value. The hasU16ErrorCode()
     * method will return false.
     */
    inline void clearU16ErrorCode();

    /**
     * Checks whether the field "u16ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ErrorCode()). Otherwise it will return false.
     */
    inline bool hasU16ErrorCode () const;

    /**
     * Returns the value of the member "u16ErrorCode".
     *
     * this is a description
     *
     * @return The value of the field "u16ErrorCode"
     */
    inline uint16 getU16ErrorCode () const;

    /**
     * Sets the value of the member "u16ErrorCode".
     *
     * this is a description
     *
     * @param u16ErrorCode The value which will be set
     */
    inline void setU16ErrorCode (uint16 u16ErrorCode_);

    static const RoutingStateErrorStructure &getDefaultInstance();

private:

    inline void set_has_u16ErrorCode ();

    inline void clear_has_u16ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ErrorCode;

};

/**
 * The error message of 'RoutingState'
 */
class RoutingStateError  : public ::asf::core::Payload {
public:

    enum RoutingStateErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  RoutingStateError ();

   /**
     * Copy constructor
     */
    inline  RoutingStateError (const RoutingStateError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~RoutingStateError();

    /**
     * Assigns a new value to this object.
     */
    inline RoutingStateError& operator = (const RoutingStateError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RoutingStateError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RoutingStateError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RoutingStateError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RoutingStateError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline RoutingStateError::RoutingStateErrorField getField () const;

    inline void setField(RoutingStateError::RoutingStateErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "RoutingStateErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "RoutingStateErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const RoutingStateErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline RoutingStateErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline RoutingStateErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (RoutingStateErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "RoutingStateErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const RoutingStateErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const RoutingStateError &getDefaultInstance();

private:

    inline void cloneData (const RoutingStateError& rhs);

    inline void deleteData ();

    RoutingStateErrorField __field;

    union {
        RoutingStateErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "AllocateRoute"
 * Allocate a route.
 */
class AllocateRouteStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AllocateRouteStart ();

    /**
     * Copy constructor
     */
    inline  AllocateRouteStart (const AllocateRouteStart &rhs);

    /**
     * All fields constructor
     */
    inline  AllocateRouteStart (uint16 u16UCID_, int32 s32STM_MsgBufID_, uint16 u16Sink_);

    /**
     * Destructor
     */
    inline virtual  ~AllocateRouteStart();

    /**
     * Assignment operator
     */
    inline AllocateRouteStart& operator = (const AllocateRouteStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AllocateRouteStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AllocateRouteStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AllocateRouteStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AllocateRouteStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16UCID"

    static const int kU16UCID = 0;

    /**
     * Clears the field "u16UCID".
     *
     * The field will be set to its default value. The hasU16UCID()
     * method will return false.
     */
    inline void clearU16UCID();

    /**
     * Checks whether the field "u16UCID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16UCID()). Otherwise it will return false.
     */
    inline bool hasU16UCID () const;

    /**
     * Returns the value of the member "u16UCID".
     *
     * If the meaning of "u16UCID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u16UCID"
     */
    inline uint16 getU16UCID () const;

    /**
     * Sets the value of the member "u16UCID".
     *
     * If the meaning of "u16UCID" isn't clear, then there should be a description here.
     *
     * @param u16UCID The value which will be set
     */
    inline void setU16UCID (uint16 u16UCID_);

    // API of field "s32STM_MsgBufID"

    static const int kS32STM_MsgBufID = 1;

    /**
     * Clears the field "s32STM_MsgBufID".
     *
     * The field will be set to its default value. The hasS32STM_MsgBufID()
     * method will return false.
     */
    inline void clearS32STM_MsgBufID();

    /**
     * Checks whether the field "s32STM_MsgBufID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32STM_MsgBufID()). Otherwise it will return false.
     */
    inline bool hasS32STM_MsgBufID () const;

    /**
     * Returns the value of the member "s32STM_MsgBufID".
     *
     * If the meaning of "s32STM_MsgBufID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "s32STM_MsgBufID"
     */
    inline int32 getS32STM_MsgBufID () const;

    /**
     * Sets the value of the member "s32STM_MsgBufID".
     *
     * If the meaning of "s32STM_MsgBufID" isn't clear, then there should be a description here.
     *
     * @param s32STM_MsgBufID The value which will be set
     */
    inline void setS32STM_MsgBufID (int32 s32STM_MsgBufID_);

    // API of field "u16Sink"

    static const int kU16Sink = 2;

    /**
     * Clears the field "u16Sink".
     *
     * The field will be set to its default value. The hasU16Sink()
     * method will return false.
     */
    inline void clearU16Sink();

    /**
     * Checks whether the field "u16Sink" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16Sink()). Otherwise it will return false.
     */
    inline bool hasU16Sink () const;

    /**
     * Returns the value of the member "u16Sink".
     *
     * If the meaning of "u16Sink" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u16Sink"
     */
    inline uint16 getU16Sink () const;

    /**
     * Sets the value of the member "u16Sink".
     *
     * If the meaning of "u16Sink" isn't clear, then there should be a description here.
     *
     * @param u16Sink The value which will be set
     */
    inline void setU16Sink (uint16 u16Sink_);

    static const AllocateRouteStart &getDefaultInstance();

private:

    inline void set_has_u16UCID ();

    inline void clear_has_u16UCID ();

    inline void set_has_s32STM_MsgBufID ();

    inline void clear_has_s32STM_MsgBufID ();

    inline void set_has_u16Sink ();

    inline void clear_has_u16Sink ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint16 _u16UCID;

    int32 _s32STM_MsgBufID;

    uint16 _u16Sink;

};

/**
 * The result message of the method "AllocateRoute"
 * Allocate a route.
 */
class AllocateRouteResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AllocateRouteResult ();

    /**
     * Copy constructor
     */
    inline  AllocateRouteResult (const AllocateRouteResult &rhs);

    /**
     * All fields constructor
     */
    inline  AllocateRouteResult (uint16 u16UCID_, uint32 u32STM_MsgBufID_, uint16 u16MOSTConnectionLabel_, uint16 u16MLBChannelAddress_, uint8 u8BlkWidth_, uint32 u32SmHandle_, const ::midw_streamrouter_fi_types::T_streamrouter_device_list& listInputDev_, const ::midw_streamrouter_fi_types::T_streamrouter_device_list& listOutputDev_);

    /**
     * Destructor
     */
    inline virtual  ~AllocateRouteResult();

    /**
     * Assignment operator
     */
    inline AllocateRouteResult& operator = (const AllocateRouteResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AllocateRouteResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AllocateRouteResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AllocateRouteResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AllocateRouteResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16UCID"

    static const int kU16UCID = 0;

    /**
     * Clears the field "u16UCID".
     *
     * The field will be set to its default value. The hasU16UCID()
     * method will return false.
     */
    inline void clearU16UCID();

    /**
     * Checks whether the field "u16UCID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16UCID()). Otherwise it will return false.
     */
    inline bool hasU16UCID () const;

    /**
     * Returns the value of the member "u16UCID".
     *
     * UCID from the request.
     *
     * @return The value of the field "u16UCID"
     */
    inline uint16 getU16UCID () const;

    /**
     * Sets the value of the member "u16UCID".
     *
     * UCID from the request.
     *
     * @param u16UCID The value which will be set
     */
    inline void setU16UCID (uint16 u16UCID_);

    // API of field "u32STM_MsgBufID"

    static const int kU32STM_MsgBufID = 1;

    /**
     * Clears the field "u32STM_MsgBufID".
     *
     * The field will be set to its default value. The hasU32STM_MsgBufID()
     * method will return false.
     */
    inline void clearU32STM_MsgBufID();

    /**
     * Checks whether the field "u32STM_MsgBufID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32STM_MsgBufID()). Otherwise it will return false.
     */
    inline bool hasU32STM_MsgBufID () const;

    /**
     * Returns the value of the member "u32STM_MsgBufID".
     *
     * Streammanager Message Buffer ID.
     *
     * @return The value of the field "u32STM_MsgBufID"
     */
    inline uint32 getU32STM_MsgBufID () const;

    /**
     * Sets the value of the member "u32STM_MsgBufID".
     *
     * Streammanager Message Buffer ID.
     *
     * @param u32STM_MsgBufID The value which will be set
     */
    inline void setU32STM_MsgBufID (uint32 u32STM_MsgBufID_);

    // API of field "u16MOSTConnectionLabel"

    static const int kU16MOSTConnectionLabel = 2;

    /**
     * Clears the field "u16MOSTConnectionLabel".
     *
     * The field will be set to its default value. The hasU16MOSTConnectionLabel()
     * method will return false.
     */
    inline void clearU16MOSTConnectionLabel();

    /**
     * Checks whether the field "u16MOSTConnectionLabel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16MOSTConnectionLabel()). Otherwise it will return false.
     */
    inline bool hasU16MOSTConnectionLabel () const;

    /**
     * Returns the value of the member "u16MOSTConnectionLabel".
     *
     * MOST connection label.
     *
     * @return The value of the field "u16MOSTConnectionLabel"
     */
    inline uint16 getU16MOSTConnectionLabel () const;

    /**
     * Sets the value of the member "u16MOSTConnectionLabel".
     *
     * MOST connection label.
     *
     * @param u16MOSTConnectionLabel The value which will be set
     */
    inline void setU16MOSTConnectionLabel (uint16 u16MOSTConnectionLabel_);

    // API of field "u16MLBChannelAddress"

    static const int kU16MLBChannelAddress = 3;

    /**
     * Clears the field "u16MLBChannelAddress".
     *
     * The field will be set to its default value. The hasU16MLBChannelAddress()
     * method will return false.
     */
    inline void clearU16MLBChannelAddress();

    /**
     * Checks whether the field "u16MLBChannelAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16MLBChannelAddress()). Otherwise it will return false.
     */
    inline bool hasU16MLBChannelAddress () const;

    /**
     * Returns the value of the member "u16MLBChannelAddress".
     *
     * MOST channel address.
     *
     * @return The value of the field "u16MLBChannelAddress"
     */
    inline uint16 getU16MLBChannelAddress () const;

    /**
     * Sets the value of the member "u16MLBChannelAddress".
     *
     * MOST channel address.
     *
     * @param u16MLBChannelAddress The value which will be set
     */
    inline void setU16MLBChannelAddress (uint16 u16MLBChannelAddress_);

    // API of field "u8BlkWidth"

    static const int kU8BlkWidth = 4;

    /**
     * Clears the field "u8BlkWidth".
     *
     * The field will be set to its default value. The hasU8BlkWidth()
     * method will return false.
     */
    inline void clearU8BlkWidth();

    /**
     * Checks whether the field "u8BlkWidth" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8BlkWidth()). Otherwise it will return false.
     */
    inline bool hasU8BlkWidth () const;

    /**
     * Returns the value of the member "u8BlkWidth".
     *
     * Block width in Bits.
     *
     * @return The value of the field "u8BlkWidth"
     */
    inline uint8 getU8BlkWidth () const;

    /**
     * Sets the value of the member "u8BlkWidth".
     *
     * Block width in Bits.
     *
     * @param u8BlkWidth The value which will be set
     */
    inline void setU8BlkWidth (uint8 u8BlkWidth_);

    // API of field "u32SmHandle"

    static const int kU32SmHandle = 5;

    /**
     * Clears the field "u32SmHandle".
     *
     * The field will be set to its default value. The hasU32SmHandle()
     * method will return false.
     */
    inline void clearU32SmHandle();

    /**
     * Checks whether the field "u32SmHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32SmHandle()). Otherwise it will return false.
     */
    inline bool hasU32SmHandle () const;

    /**
     * Returns the value of the member "u32SmHandle".
     *
     * Stream Manager Handle.
     *
     * @return The value of the field "u32SmHandle"
     */
    inline uint32 getU32SmHandle () const;

    /**
     * Sets the value of the member "u32SmHandle".
     *
     * Stream Manager Handle.
     *
     * @param u32SmHandle The value which will be set
     */
    inline void setU32SmHandle (uint32 u32SmHandle_);

    // API of field "listInputDev"

    static const int kListInputDev = 6;

    /**
     * Clears the field "listInputDev".
     *
     * The field will be set to its default value. The hasListInputDev()
     * method will return false.
     */
    inline void clearListInputDev();

    /**
     * Checks whether the field "listInputDev" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListInputDev()). Otherwise it will return false.
     */
    inline bool hasListInputDev () const;

    /**
     * Returns the value of the member "listInputDev".
     *
     * ALSA device string(s) for input devices.
     *
     * @return The value of the field "listInputDev"
     */
    inline const ::midw_streamrouter_fi_types::T_streamrouter_device_list& getListInputDev () const;

    /**
     * Retrieves the value of the field "listInputDev" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "listInputDev".
     */
    inline ::midw_streamrouter_fi_types::T_streamrouter_device_list& getListInputDevMutable ();

    /**
     * Sets the value of the member "listInputDev".
     *
     * ALSA device string(s) for input devices.
     *
     * @param listInputDev The value which will be set
     */
    inline void setListInputDev (const ::midw_streamrouter_fi_types::T_streamrouter_device_list& listInputDev_);

    // API of field "listOutputDev"

    static const int kListOutputDev = 7;

    /**
     * Clears the field "listOutputDev".
     *
     * The field will be set to its default value. The hasListOutputDev()
     * method will return false.
     */
    inline void clearListOutputDev();

    /**
     * Checks whether the field "listOutputDev" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListOutputDev()). Otherwise it will return false.
     */
    inline bool hasListOutputDev () const;

    /**
     * Returns the value of the member "listOutputDev".
     *
     * ALSA device string(s) for output devices.
     *
     * @return The value of the field "listOutputDev"
     */
    inline const ::midw_streamrouter_fi_types::T_streamrouter_device_list& getListOutputDev () const;

    /**
     * Retrieves the value of the field "listOutputDev" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "listOutputDev".
     */
    inline ::midw_streamrouter_fi_types::T_streamrouter_device_list& getListOutputDevMutable ();

    /**
     * Sets the value of the member "listOutputDev".
     *
     * ALSA device string(s) for output devices.
     *
     * @param listOutputDev The value which will be set
     */
    inline void setListOutputDev (const ::midw_streamrouter_fi_types::T_streamrouter_device_list& listOutputDev_);

    static const AllocateRouteResult &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_u16UCID ();

    inline void clear_has_u16UCID ();

    inline void set_has_u32STM_MsgBufID ();

    inline void clear_has_u32STM_MsgBufID ();

    inline void set_has_u16MOSTConnectionLabel ();

    inline void clear_has_u16MOSTConnectionLabel ();

    inline void set_has_u16MLBChannelAddress ();

    inline void clear_has_u16MLBChannelAddress ();

    inline void set_has_u8BlkWidth ();

    inline void clear_has_u8BlkWidth ();

    inline void set_has_u32SmHandle ();

    inline void clear_has_u32SmHandle ();

    inline void set_has_listInputDev ();

    inline void clear_has_listInputDev ();

    inline void set_has_listOutputDev ();

    inline void clear_has_listOutputDev ();

    uint32 _has_bits_[ (8 + 31) / 32];

    uint16 _u16UCID;

    uint32 _u32STM_MsgBufID;

    uint16 _u16MOSTConnectionLabel;

    uint16 _u16MLBChannelAddress;

    uint8 _u8BlkWidth;

    uint32 _u32SmHandle;

    ::midw_streamrouter_fi_types::T_streamrouter_device_list _listInputDev;

    ::midw_streamrouter_fi_types::T_streamrouter_device_list _listOutputDev;

};

/**
 * The error message of 'AllocateRoute'
 */
class AllocateRouteErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  AllocateRouteErrorStructure ();

    /**
     * Copy constructor
     */
    inline  AllocateRouteErrorStructure (const AllocateRouteErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  AllocateRouteErrorStructure (uint16 u16ErrorCode_);

    /**
     * Destructor
     */
    inline  ~AllocateRouteErrorStructure();

    /**
     * Assignment operator
     */
    inline AllocateRouteErrorStructure& operator = (const AllocateRouteErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AllocateRouteErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AllocateRouteErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AllocateRouteErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AllocateRouteErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ErrorCode"

    static const int kU16ErrorCode = 0;

    /**
     * Clears the field "u16ErrorCode".
     *
     * The field will be set to its default value. The hasU16ErrorCode()
     * method will return false.
     */
    inline void clearU16ErrorCode();

    /**
     * Checks whether the field "u16ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ErrorCode()). Otherwise it will return false.
     */
    inline bool hasU16ErrorCode () const;

    /**
     * Returns the value of the member "u16ErrorCode".
     *
     * Possible errors sent from this server or the framework. The range from
     * 0x0000 to 0x00FF is reserved for 'General Errors'. The range from
     * 0x0100 to 0xFFFF can be used for specific errors of this server.
     *
     * @return The value of the field "u16ErrorCode"
     */
    inline uint16 getU16ErrorCode () const;

    /**
     * Sets the value of the member "u16ErrorCode".
     *
     * Possible errors sent from this server or the framework. The range from
     * 0x0000 to 0x00FF is reserved for 'General Errors'. The range from
     * 0x0100 to 0xFFFF can be used for specific errors of this server.
     *
     * @param u16ErrorCode The value which will be set
     */
    inline void setU16ErrorCode (uint16 u16ErrorCode_);

    static const AllocateRouteErrorStructure &getDefaultInstance();

private:

    inline void set_has_u16ErrorCode ();

    inline void clear_has_u16ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ErrorCode;

};

/**
 * The error message of 'AllocateRoute'
 */
class AllocateRouteError  : public ::asf::core::Payload {
public:

    enum AllocateRouteErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  AllocateRouteError ();

   /**
     * Copy constructor
     */
    inline  AllocateRouteError (const AllocateRouteError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~AllocateRouteError();

    /**
     * Assigns a new value to this object.
     */
    inline AllocateRouteError& operator = (const AllocateRouteError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AllocateRouteError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AllocateRouteError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AllocateRouteError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AllocateRouteError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline AllocateRouteError::AllocateRouteErrorField getField () const;

    inline void setField(AllocateRouteError::AllocateRouteErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "AllocateRouteErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "AllocateRouteErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const AllocateRouteErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline AllocateRouteErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline AllocateRouteErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (AllocateRouteErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "AllocateRouteErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const AllocateRouteErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const AllocateRouteError &getDefaultInstance();

private:

    inline void cloneData (const AllocateRouteError& rhs);

    inline void deleteData ();

    AllocateRouteErrorField __field;

    union {
        AllocateRouteErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "DeAllocateRoute"
 * Deallocate a route.
 */
class DeAllocateRouteStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeAllocateRouteStart ();

    /**
     * Copy constructor
     */
    inline  DeAllocateRouteStart (const DeAllocateRouteStart &rhs);

    /**
     * All fields constructor
     */
    inline  DeAllocateRouteStart (uint16 u16UCID_);

    /**
     * Destructor
     */
    inline virtual  ~DeAllocateRouteStart();

    /**
     * Assignment operator
     */
    inline DeAllocateRouteStart& operator = (const DeAllocateRouteStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeAllocateRouteStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeAllocateRouteStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeAllocateRouteStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeAllocateRouteStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16UCID"

    static const int kU16UCID = 0;

    /**
     * Clears the field "u16UCID".
     *
     * The field will be set to its default value. The hasU16UCID()
     * method will return false.
     */
    inline void clearU16UCID();

    /**
     * Checks whether the field "u16UCID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16UCID()). Otherwise it will return false.
     */
    inline bool hasU16UCID () const;

    /**
     * Returns the value of the member "u16UCID".
     *
     * If the meaning of "u16UCID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u16UCID"
     */
    inline uint16 getU16UCID () const;

    /**
     * Sets the value of the member "u16UCID".
     *
     * If the meaning of "u16UCID" isn't clear, then there should be a description here.
     *
     * @param u16UCID The value which will be set
     */
    inline void setU16UCID (uint16 u16UCID_);

    static const DeAllocateRouteStart &getDefaultInstance();

private:

    inline void set_has_u16UCID ();

    inline void clear_has_u16UCID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16UCID;

};

/**
 * The result message of the method "DeAllocateRoute"
 * Deallocate a route.
 */
class DeAllocateRouteResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeAllocateRouteResult ();

    /**
     * Copy constructor
     */
    inline  DeAllocateRouteResult (const DeAllocateRouteResult &rhs);

    /**
     * All fields constructor
     */
    inline  DeAllocateRouteResult (uint16 u16UCID_);

    /**
     * Destructor
     */
    inline virtual  ~DeAllocateRouteResult();

    /**
     * Assignment operator
     */
    inline DeAllocateRouteResult& operator = (const DeAllocateRouteResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeAllocateRouteResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeAllocateRouteResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeAllocateRouteResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeAllocateRouteResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16UCID"

    static const int kU16UCID = 0;

    /**
     * Clears the field "u16UCID".
     *
     * The field will be set to its default value. The hasU16UCID()
     * method will return false.
     */
    inline void clearU16UCID();

    /**
     * Checks whether the field "u16UCID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16UCID()). Otherwise it will return false.
     */
    inline bool hasU16UCID () const;

    /**
     * Returns the value of the member "u16UCID".
     *
     * UCID from the request.
     *
     * @return The value of the field "u16UCID"
     */
    inline uint16 getU16UCID () const;

    /**
     * Sets the value of the member "u16UCID".
     *
     * UCID from the request.
     *
     * @param u16UCID The value which will be set
     */
    inline void setU16UCID (uint16 u16UCID_);

    static const DeAllocateRouteResult &getDefaultInstance();

private:

    inline void set_has_u16UCID ();

    inline void clear_has_u16UCID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16UCID;

};

/**
 * The error message of 'DeAllocateRoute'
 */
class DeAllocateRouteErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DeAllocateRouteErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DeAllocateRouteErrorStructure (const DeAllocateRouteErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DeAllocateRouteErrorStructure (uint16 u16ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DeAllocateRouteErrorStructure();

    /**
     * Assignment operator
     */
    inline DeAllocateRouteErrorStructure& operator = (const DeAllocateRouteErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeAllocateRouteErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeAllocateRouteErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeAllocateRouteErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeAllocateRouteErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ErrorCode"

    static const int kU16ErrorCode = 0;

    /**
     * Clears the field "u16ErrorCode".
     *
     * The field will be set to its default value. The hasU16ErrorCode()
     * method will return false.
     */
    inline void clearU16ErrorCode();

    /**
     * Checks whether the field "u16ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ErrorCode()). Otherwise it will return false.
     */
    inline bool hasU16ErrorCode () const;

    /**
     * Returns the value of the member "u16ErrorCode".
     *
     * Possible errors sent from this server or the framework. The range from
     * 0x0000 to 0x00FF is reserved for 'General Errors'. The range from
     * 0x0100 to 0xFFFF can be used for specific errors of this server.
     *
     * @return The value of the field "u16ErrorCode"
     */
    inline uint16 getU16ErrorCode () const;

    /**
     * Sets the value of the member "u16ErrorCode".
     *
     * Possible errors sent from this server or the framework. The range from
     * 0x0000 to 0x00FF is reserved for 'General Errors'. The range from
     * 0x0100 to 0xFFFF can be used for specific errors of this server.
     *
     * @param u16ErrorCode The value which will be set
     */
    inline void setU16ErrorCode (uint16 u16ErrorCode_);

    static const DeAllocateRouteErrorStructure &getDefaultInstance();

private:

    inline void set_has_u16ErrorCode ();

    inline void clear_has_u16ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ErrorCode;

};

/**
 * The error message of 'DeAllocateRoute'
 */
class DeAllocateRouteError  : public ::asf::core::Payload {
public:

    enum DeAllocateRouteErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DeAllocateRouteError ();

   /**
     * Copy constructor
     */
    inline  DeAllocateRouteError (const DeAllocateRouteError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DeAllocateRouteError();

    /**
     * Assigns a new value to this object.
     */
    inline DeAllocateRouteError& operator = (const DeAllocateRouteError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeAllocateRouteError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeAllocateRouteError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeAllocateRouteError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeAllocateRouteError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DeAllocateRouteError::DeAllocateRouteErrorField getField () const;

    inline void setField(DeAllocateRouteError::DeAllocateRouteErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DeAllocateRouteErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DeAllocateRouteErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DeAllocateRouteErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DeAllocateRouteErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DeAllocateRouteErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DeAllocateRouteErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DeAllocateRouteErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DeAllocateRouteErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DeAllocateRouteError &getDefaultInstance();

private:

    inline void cloneData (const DeAllocateRouteError& rhs);

    inline void deleteData ();

    DeAllocateRouteErrorField __field;

    union {
        DeAllocateRouteErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SetPlay"
 * Start streaming.
 */
class SetPlayStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetPlayStart ();

    /**
     * Copy constructor
     */
    inline  SetPlayStart (const SetPlayStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetPlayStart (uint16 u16UCID_, ::midw_streamrouter_fi_types::T_e8_streamrouter_ramptype eRampType_);

    /**
     * Destructor
     */
    inline virtual  ~SetPlayStart();

    /**
     * Assignment operator
     */
    inline SetPlayStart& operator = (const SetPlayStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetPlayStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetPlayStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetPlayStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetPlayStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16UCID"

    static const int kU16UCID = 0;

    /**
     * Clears the field "u16UCID".
     *
     * The field will be set to its default value. The hasU16UCID()
     * method will return false.
     */
    inline void clearU16UCID();

    /**
     * Checks whether the field "u16UCID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16UCID()). Otherwise it will return false.
     */
    inline bool hasU16UCID () const;

    /**
     * Returns the value of the member "u16UCID".
     *
     * If the meaning of "u16UCID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u16UCID"
     */
    inline uint16 getU16UCID () const;

    /**
     * Sets the value of the member "u16UCID".
     *
     * If the meaning of "u16UCID" isn't clear, then there should be a description here.
     *
     * @param u16UCID The value which will be set
     */
    inline void setU16UCID (uint16 u16UCID_);

    // API of field "eRampType"

    static const int kERampType = 1;

    /**
     * Clears the field "eRampType".
     *
     * The field will be set to its default value. The hasERampType()
     * method will return false.
     */
    inline void clearERampType();

    /**
     * Checks whether the field "eRampType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setERampType()). Otherwise it will return false.
     */
    inline bool hasERampType () const;

    /**
     * Returns the value of the member "eRampType".
     *
     * Ramp type used to start playing.
     *
     * @return The value of the field "eRampType"
     */
    inline ::midw_streamrouter_fi_types::T_e8_streamrouter_ramptype getERampType () const;

    /**
     * Sets the value of the member "eRampType".
     *
     * Ramp type used to start playing.
     *
     * @param eRampType The value which will be set
     */
    inline void setERampType (::midw_streamrouter_fi_types::T_e8_streamrouter_ramptype eRampType_);

    static const SetPlayStart &getDefaultInstance();

private:

    inline void set_has_u16UCID ();

    inline void clear_has_u16UCID ();

    inline void set_has_eRampType ();

    inline void clear_has_eRampType ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _u16UCID;

    ::midw_streamrouter_fi_types::T_e8_streamrouter_ramptype _eRampType;

};

/**
 * The result message of the method "SetPlay"
 * Start streaming.
 */
class SetPlayResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetPlayResult ();

    /**
     * Copy constructor
     */
    inline  SetPlayResult (const SetPlayResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetPlayResult (uint16 u16UCID_);

    /**
     * Destructor
     */
    inline virtual  ~SetPlayResult();

    /**
     * Assignment operator
     */
    inline SetPlayResult& operator = (const SetPlayResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetPlayResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetPlayResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetPlayResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetPlayResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16UCID"

    static const int kU16UCID = 0;

    /**
     * Clears the field "u16UCID".
     *
     * The field will be set to its default value. The hasU16UCID()
     * method will return false.
     */
    inline void clearU16UCID();

    /**
     * Checks whether the field "u16UCID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16UCID()). Otherwise it will return false.
     */
    inline bool hasU16UCID () const;

    /**
     * Returns the value of the member "u16UCID".
     *
     * UCID from the request.
     *
     * @return The value of the field "u16UCID"
     */
    inline uint16 getU16UCID () const;

    /**
     * Sets the value of the member "u16UCID".
     *
     * UCID from the request.
     *
     * @param u16UCID The value which will be set
     */
    inline void setU16UCID (uint16 u16UCID_);

    static const SetPlayResult &getDefaultInstance();

private:

    inline void set_has_u16UCID ();

    inline void clear_has_u16UCID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16UCID;

};

/**
 * The error message of 'SetPlay'
 */
class SetPlayErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SetPlayErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SetPlayErrorStructure (const SetPlayErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SetPlayErrorStructure (uint16 u16ErrorCode_);

    /**
     * Destructor
     */
    inline  ~SetPlayErrorStructure();

    /**
     * Assignment operator
     */
    inline SetPlayErrorStructure& operator = (const SetPlayErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetPlayErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetPlayErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetPlayErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetPlayErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ErrorCode"

    static const int kU16ErrorCode = 0;

    /**
     * Clears the field "u16ErrorCode".
     *
     * The field will be set to its default value. The hasU16ErrorCode()
     * method will return false.
     */
    inline void clearU16ErrorCode();

    /**
     * Checks whether the field "u16ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ErrorCode()). Otherwise it will return false.
     */
    inline bool hasU16ErrorCode () const;

    /**
     * Returns the value of the member "u16ErrorCode".
     *
     * Possible errors sent from this server or the framework. The range from
     * 0x0000 to 0x00FF is reserved for 'General Errors'. The range from
     * 0x0100 to 0xFFFF can be used for specific errors of this server.
     *
     * @return The value of the field "u16ErrorCode"
     */
    inline uint16 getU16ErrorCode () const;

    /**
     * Sets the value of the member "u16ErrorCode".
     *
     * Possible errors sent from this server or the framework. The range from
     * 0x0000 to 0x00FF is reserved for 'General Errors'. The range from
     * 0x0100 to 0xFFFF can be used for specific errors of this server.
     *
     * @param u16ErrorCode The value which will be set
     */
    inline void setU16ErrorCode (uint16 u16ErrorCode_);

    static const SetPlayErrorStructure &getDefaultInstance();

private:

    inline void set_has_u16ErrorCode ();

    inline void clear_has_u16ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ErrorCode;

};

/**
 * The error message of 'SetPlay'
 */
class SetPlayError  : public ::asf::core::Payload {
public:

    enum SetPlayErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SetPlayError ();

   /**
     * Copy constructor
     */
    inline  SetPlayError (const SetPlayError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SetPlayError();

    /**
     * Assigns a new value to this object.
     */
    inline SetPlayError& operator = (const SetPlayError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetPlayError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetPlayError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetPlayError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetPlayError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SetPlayError::SetPlayErrorField getField () const;

    inline void setField(SetPlayError::SetPlayErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SetPlayErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SetPlayErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SetPlayErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SetPlayErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SetPlayErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SetPlayErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SetPlayErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SetPlayErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SetPlayError &getDefaultInstance();

private:

    inline void cloneData (const SetPlayError& rhs);

    inline void deleteData ();

    SetPlayErrorField __field;

    union {
        SetPlayErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SetStop"
 * Stop streaming.
 */
class SetStopStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetStopStart ();

    /**
     * Copy constructor
     */
    inline  SetStopStart (const SetStopStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetStopStart (uint16 u16UCID_, ::midw_streamrouter_fi_types::T_e8_streamrouter_ramptype eRampType_);

    /**
     * Destructor
     */
    inline virtual  ~SetStopStart();

    /**
     * Assignment operator
     */
    inline SetStopStart& operator = (const SetStopStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetStopStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetStopStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetStopStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetStopStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16UCID"

    static const int kU16UCID = 0;

    /**
     * Clears the field "u16UCID".
     *
     * The field will be set to its default value. The hasU16UCID()
     * method will return false.
     */
    inline void clearU16UCID();

    /**
     * Checks whether the field "u16UCID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16UCID()). Otherwise it will return false.
     */
    inline bool hasU16UCID () const;

    /**
     * Returns the value of the member "u16UCID".
     *
     * If the meaning of "u16UCID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u16UCID"
     */
    inline uint16 getU16UCID () const;

    /**
     * Sets the value of the member "u16UCID".
     *
     * If the meaning of "u16UCID" isn't clear, then there should be a description here.
     *
     * @param u16UCID The value which will be set
     */
    inline void setU16UCID (uint16 u16UCID_);

    // API of field "eRampType"

    static const int kERampType = 1;

    /**
     * Clears the field "eRampType".
     *
     * The field will be set to its default value. The hasERampType()
     * method will return false.
     */
    inline void clearERampType();

    /**
     * Checks whether the field "eRampType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setERampType()). Otherwise it will return false.
     */
    inline bool hasERampType () const;

    /**
     * Returns the value of the member "eRampType".
     *
     * Ramp type used to stop.
     *
     * @return The value of the field "eRampType"
     */
    inline ::midw_streamrouter_fi_types::T_e8_streamrouter_ramptype getERampType () const;

    /**
     * Sets the value of the member "eRampType".
     *
     * Ramp type used to stop.
     *
     * @param eRampType The value which will be set
     */
    inline void setERampType (::midw_streamrouter_fi_types::T_e8_streamrouter_ramptype eRampType_);

    static const SetStopStart &getDefaultInstance();

private:

    inline void set_has_u16UCID ();

    inline void clear_has_u16UCID ();

    inline void set_has_eRampType ();

    inline void clear_has_eRampType ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _u16UCID;

    ::midw_streamrouter_fi_types::T_e8_streamrouter_ramptype _eRampType;

};

/**
 * The result message of the method "SetStop"
 * Stop streaming.
 */
class SetStopResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetStopResult ();

    /**
     * Copy constructor
     */
    inline  SetStopResult (const SetStopResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetStopResult (uint16 u16UCID_);

    /**
     * Destructor
     */
    inline virtual  ~SetStopResult();

    /**
     * Assignment operator
     */
    inline SetStopResult& operator = (const SetStopResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetStopResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetStopResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetStopResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetStopResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16UCID"

    static const int kU16UCID = 0;

    /**
     * Clears the field "u16UCID".
     *
     * The field will be set to its default value. The hasU16UCID()
     * method will return false.
     */
    inline void clearU16UCID();

    /**
     * Checks whether the field "u16UCID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16UCID()). Otherwise it will return false.
     */
    inline bool hasU16UCID () const;

    /**
     * Returns the value of the member "u16UCID".
     *
     * UCID from the request.
     *
     * @return The value of the field "u16UCID"
     */
    inline uint16 getU16UCID () const;

    /**
     * Sets the value of the member "u16UCID".
     *
     * UCID from the request.
     *
     * @param u16UCID The value which will be set
     */
    inline void setU16UCID (uint16 u16UCID_);

    static const SetStopResult &getDefaultInstance();

private:

    inline void set_has_u16UCID ();

    inline void clear_has_u16UCID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16UCID;

};

/**
 * The error message of 'SetStop'
 */
class SetStopErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SetStopErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SetStopErrorStructure (const SetStopErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SetStopErrorStructure (uint16 u16ErrorCode_);

    /**
     * Destructor
     */
    inline  ~SetStopErrorStructure();

    /**
     * Assignment operator
     */
    inline SetStopErrorStructure& operator = (const SetStopErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetStopErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetStopErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetStopErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetStopErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ErrorCode"

    static const int kU16ErrorCode = 0;

    /**
     * Clears the field "u16ErrorCode".
     *
     * The field will be set to its default value. The hasU16ErrorCode()
     * method will return false.
     */
    inline void clearU16ErrorCode();

    /**
     * Checks whether the field "u16ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ErrorCode()). Otherwise it will return false.
     */
    inline bool hasU16ErrorCode () const;

    /**
     * Returns the value of the member "u16ErrorCode".
     *
     * Possible errors sent from this server or the framework. The range from
     * 0x0000 to 0x00FF is reserved for 'General Errors'. The range from
     * 0x0100 to 0xFFFF can be used for specific errors of this server.
     *
     * @return The value of the field "u16ErrorCode"
     */
    inline uint16 getU16ErrorCode () const;

    /**
     * Sets the value of the member "u16ErrorCode".
     *
     * Possible errors sent from this server or the framework. The range from
     * 0x0000 to 0x00FF is reserved for 'General Errors'. The range from
     * 0x0100 to 0xFFFF can be used for specific errors of this server.
     *
     * @param u16ErrorCode The value which will be set
     */
    inline void setU16ErrorCode (uint16 u16ErrorCode_);

    static const SetStopErrorStructure &getDefaultInstance();

private:

    inline void set_has_u16ErrorCode ();

    inline void clear_has_u16ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ErrorCode;

};

/**
 * The error message of 'SetStop'
 */
class SetStopError  : public ::asf::core::Payload {
public:

    enum SetStopErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SetStopError ();

   /**
     * Copy constructor
     */
    inline  SetStopError (const SetStopError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SetStopError();

    /**
     * Assigns a new value to this object.
     */
    inline SetStopError& operator = (const SetStopError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetStopError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetStopError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetStopError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetStopError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SetStopError::SetStopErrorField getField () const;

    inline void setField(SetStopError::SetStopErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SetStopErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SetStopErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SetStopErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SetStopErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SetStopErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SetStopErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SetStopErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SetStopErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SetStopError &getDefaultInstance();

private:

    inline void cloneData (const SetStopError& rhs);

    inline void deleteData ();

    SetStopErrorField __field;

    union {
        SetStopErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SendFGCommand"
 * Mute/Demute mic directly on Streammanager Route ID.
 */
class SendFGCommandStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendFGCommandStart ();

    /**
     * Copy constructor
     */
    inline  SendFGCommandStart (const SendFGCommandStart &rhs);

    /**
     * All fields constructor
     */
    inline  SendFGCommandStart (uint16 u16UCID_, uint16 u16FGRouteID_, ::midw_streamrouter_fi_types::T_e8_streamrouter_fgcommand eCmd_);

    /**
     * Destructor
     */
    inline virtual  ~SendFGCommandStart();

    /**
     * Assignment operator
     */
    inline SendFGCommandStart& operator = (const SendFGCommandStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendFGCommandStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendFGCommandStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendFGCommandStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendFGCommandStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16UCID"

    static const int kU16UCID = 0;

    /**
     * Clears the field "u16UCID".
     *
     * The field will be set to its default value. The hasU16UCID()
     * method will return false.
     */
    inline void clearU16UCID();

    /**
     * Checks whether the field "u16UCID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16UCID()). Otherwise it will return false.
     */
    inline bool hasU16UCID () const;

    /**
     * Returns the value of the member "u16UCID".
     *
     * If the meaning of "u16UCID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u16UCID"
     */
    inline uint16 getU16UCID () const;

    /**
     * Sets the value of the member "u16UCID".
     *
     * If the meaning of "u16UCID" isn't clear, then there should be a description here.
     *
     * @param u16UCID The value which will be set
     */
    inline void setU16UCID (uint16 u16UCID_);

    // API of field "u16FGRouteID"

    static const int kU16FGRouteID = 1;

    /**
     * Clears the field "u16FGRouteID".
     *
     * The field will be set to its default value. The hasU16FGRouteID()
     * method will return false.
     */
    inline void clearU16FGRouteID();

    /**
     * Checks whether the field "u16FGRouteID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16FGRouteID()). Otherwise it will return false.
     */
    inline bool hasU16FGRouteID () const;

    /**
     * Returns the value of the member "u16FGRouteID".
     *
     * Streammanager Route ID. If 0, StreamRouter will try to figure out.
     *
     * @return The value of the field "u16FGRouteID"
     */
    inline uint16 getU16FGRouteID () const;

    /**
     * Sets the value of the member "u16FGRouteID".
     *
     * Streammanager Route ID. If 0, StreamRouter will try to figure out.
     *
     * @param u16FGRouteID The value which will be set
     */
    inline void setU16FGRouteID (uint16 u16FGRouteID_);

    // API of field "eCmd"

    static const int kECmd = 2;

    /**
     * Clears the field "eCmd".
     *
     * The field will be set to its default value. The hasECmd()
     * method will return false.
     */
    inline void clearECmd();

    /**
     * Checks whether the field "eCmd" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setECmd()). Otherwise it will return false.
     */
    inline bool hasECmd () const;

    /**
     * Returns the value of the member "eCmd".
     *
     * Command to be send to Streammanager.
     *
     * @return The value of the field "eCmd"
     */
    inline ::midw_streamrouter_fi_types::T_e8_streamrouter_fgcommand getECmd () const;

    /**
     * Sets the value of the member "eCmd".
     *
     * Command to be send to Streammanager.
     *
     * @param eCmd The value which will be set
     */
    inline void setECmd (::midw_streamrouter_fi_types::T_e8_streamrouter_fgcommand eCmd_);

    static const SendFGCommandStart &getDefaultInstance();

private:

    inline void set_has_u16UCID ();

    inline void clear_has_u16UCID ();

    inline void set_has_u16FGRouteID ();

    inline void clear_has_u16FGRouteID ();

    inline void set_has_eCmd ();

    inline void clear_has_eCmd ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint16 _u16UCID;

    uint16 _u16FGRouteID;

    ::midw_streamrouter_fi_types::T_e8_streamrouter_fgcommand _eCmd;

};

/**
 * The result message of the method "SendFGCommand"
 * Mute/Demute mic directly on Streammanager Route ID.
 */
class SendFGCommandResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendFGCommandResult ();

    /**
     * Copy constructor
     */
    inline  SendFGCommandResult (const SendFGCommandResult &rhs);

    /**
     * All fields constructor
     */
    inline  SendFGCommandResult (uint16 u16UCID_);

    /**
     * Destructor
     */
    inline virtual  ~SendFGCommandResult();

    /**
     * Assignment operator
     */
    inline SendFGCommandResult& operator = (const SendFGCommandResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendFGCommandResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendFGCommandResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendFGCommandResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendFGCommandResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16UCID"

    static const int kU16UCID = 0;

    /**
     * Clears the field "u16UCID".
     *
     * The field will be set to its default value. The hasU16UCID()
     * method will return false.
     */
    inline void clearU16UCID();

    /**
     * Checks whether the field "u16UCID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16UCID()). Otherwise it will return false.
     */
    inline bool hasU16UCID () const;

    /**
     * Returns the value of the member "u16UCID".
     *
     * UCID from the request.
     *
     * @return The value of the field "u16UCID"
     */
    inline uint16 getU16UCID () const;

    /**
     * Sets the value of the member "u16UCID".
     *
     * UCID from the request.
     *
     * @param u16UCID The value which will be set
     */
    inline void setU16UCID (uint16 u16UCID_);

    static const SendFGCommandResult &getDefaultInstance();

private:

    inline void set_has_u16UCID ();

    inline void clear_has_u16UCID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16UCID;

};

/**
 * The error message of 'SendFGCommand'
 */
class SendFGCommandErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SendFGCommandErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SendFGCommandErrorStructure (const SendFGCommandErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SendFGCommandErrorStructure (uint16 u16ErrorCode_);

    /**
     * Destructor
     */
    inline  ~SendFGCommandErrorStructure();

    /**
     * Assignment operator
     */
    inline SendFGCommandErrorStructure& operator = (const SendFGCommandErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendFGCommandErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendFGCommandErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendFGCommandErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendFGCommandErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ErrorCode"

    static const int kU16ErrorCode = 0;

    /**
     * Clears the field "u16ErrorCode".
     *
     * The field will be set to its default value. The hasU16ErrorCode()
     * method will return false.
     */
    inline void clearU16ErrorCode();

    /**
     * Checks whether the field "u16ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ErrorCode()). Otherwise it will return false.
     */
    inline bool hasU16ErrorCode () const;

    /**
     * Returns the value of the member "u16ErrorCode".
     *
     * Possible errors sent from this server or the framework. The range from
     * 0x0000 to 0x00FF is reserved for 'General Errors'. The range from
     * 0x0100 to 0xFFFF can be used for specific errors of this server.
     *
     * @return The value of the field "u16ErrorCode"
     */
    inline uint16 getU16ErrorCode () const;

    /**
     * Sets the value of the member "u16ErrorCode".
     *
     * Possible errors sent from this server or the framework. The range from
     * 0x0000 to 0x00FF is reserved for 'General Errors'. The range from
     * 0x0100 to 0xFFFF can be used for specific errors of this server.
     *
     * @param u16ErrorCode The value which will be set
     */
    inline void setU16ErrorCode (uint16 u16ErrorCode_);

    static const SendFGCommandErrorStructure &getDefaultInstance();

private:

    inline void set_has_u16ErrorCode ();

    inline void clear_has_u16ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ErrorCode;

};

/**
 * The error message of 'SendFGCommand'
 */
class SendFGCommandError  : public ::asf::core::Payload {
public:

    enum SendFGCommandErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SendFGCommandError ();

   /**
     * Copy constructor
     */
    inline  SendFGCommandError (const SendFGCommandError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SendFGCommandError();

    /**
     * Assigns a new value to this object.
     */
    inline SendFGCommandError& operator = (const SendFGCommandError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendFGCommandError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendFGCommandError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendFGCommandError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendFGCommandError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SendFGCommandError::SendFGCommandErrorField getField () const;

    inline void setField(SendFGCommandError::SendFGCommandErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SendFGCommandErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SendFGCommandErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SendFGCommandErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SendFGCommandErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SendFGCommandErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SendFGCommandErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SendFGCommandErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SendFGCommandErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SendFGCommandError &getDefaultInstance();

private:

    inline void cloneData (const SendFGCommandError& rhs);

    inline void deleteData ();

    SendFGCommandErrorField __field;

    union {
        SendFGCommandErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

inline  RoutingStateStatus::RoutingStateStatus ()  :
    _routing_list ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RoutingStateStatus::RoutingStateStatus (const RoutingStateStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _routing_list ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RoutingStateStatus::RoutingStateStatus (const ::midw_streamrouter_fi_types::T_streamrouter_routing_list& routing_list_)  :
    _routing_list (routing_list_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RoutingStateStatus::~RoutingStateStatus() {
}

inline RoutingStateStatus& RoutingStateStatus::operator = (const RoutingStateStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRouting_list()) {
            setRouting_list(rhs.getRouting_list());
        } else {
            clearRouting_list();
        }
    }
    return *this;
}

inline bool RoutingStateStatus::operator == (const RoutingStateStatus& rhs) const {
    return (((!hasRouting_list() && !rhs.hasRouting_list()) || getRouting_list() == rhs.getRouting_list()));
}

inline bool RoutingStateStatus::operator != (const RoutingStateStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool RoutingStateStatus::operator < (const RoutingStateStatus& rhs) const {
    if (hasRouting_list() || rhs.hasRouting_list()) {
        if (getRouting_list() < rhs.getRouting_list()) return true;
        if (getRouting_list() > rhs.getRouting_list()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RoutingStateStatus::clone() {
    return new RoutingStateStatus(*this);
}

inline bool RoutingStateStatus::operator > (const RoutingStateStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RoutingStateStatus::clear() {
    clearRouting_list();
}

inline void RoutingStateStatus::clearRouting_list() {
    if (hasRouting_list()) {
         clear_has_routing_list();
        _routing_list.clear();
     }
}

inline bool RoutingStateStatus::hasRouting_list () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::midw_streamrouter_fi_types::T_streamrouter_routing_list& RoutingStateStatus::getRouting_list () const {
    return _routing_list;
}

inline ::midw_streamrouter_fi_types::T_streamrouter_routing_list& RoutingStateStatus::getRouting_listMutable () {
    set_has_routing_list();
    return _routing_list;
}

inline void RoutingStateStatus::setRouting_list (const ::midw_streamrouter_fi_types::T_streamrouter_routing_list& routing_list_) {
    set_has_routing_list();
    this->_routing_list = routing_list_;
}

inline void RoutingStateStatus::set_has_routing_list () {
    _has_bits_[0] |= 1u << 0;
}

inline void RoutingStateStatus::clear_has_routing_list () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RoutingStateGet::RoutingStateGet ()  :
    _s32UCID (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RoutingStateGet::RoutingStateGet (const RoutingStateGet &rhs)  :
    ::asf::core::Payload(rhs),
    _s32UCID (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RoutingStateGet::RoutingStateGet (int32 s32UCID_)  :
    _s32UCID (s32UCID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RoutingStateGet::~RoutingStateGet() {
}

inline RoutingStateGet& RoutingStateGet::operator = (const RoutingStateGet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasS32UCID()) {
            setS32UCID(rhs.getS32UCID());
        } else {
            clearS32UCID();
        }
    }
    return *this;
}

inline bool RoutingStateGet::operator == (const RoutingStateGet& rhs) const {
    return (((!hasS32UCID() && !rhs.hasS32UCID()) || getS32UCID() == rhs.getS32UCID()));
}

inline bool RoutingStateGet::operator != (const RoutingStateGet& rhs) const {
    return ! (*this == rhs);
}

inline bool RoutingStateGet::operator < (const RoutingStateGet& rhs) const {
    if (hasS32UCID() || rhs.hasS32UCID()) {
        if (getS32UCID() < rhs.getS32UCID()) return true;
        if (getS32UCID() > rhs.getS32UCID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RoutingStateGet::clone() {
    return new RoutingStateGet(*this);
}

inline bool RoutingStateGet::operator > (const RoutingStateGet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RoutingStateGet::clear() {
    clearS32UCID();
}

inline void RoutingStateGet::clearS32UCID() {
    if (hasS32UCID()) {
         clear_has_s32UCID();
        _s32UCID = 0;
     }
}

inline bool RoutingStateGet::hasS32UCID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 RoutingStateGet::getS32UCID () const {
    return _s32UCID;
}

inline void RoutingStateGet::setS32UCID (int32 s32UCID_) {
    set_has_s32UCID();
    this->_s32UCID = s32UCID_;
}

inline void RoutingStateGet::set_has_s32UCID () {
    _has_bits_[0] |= 1u << 0;
}

inline void RoutingStateGet::clear_has_s32UCID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RoutingStateErrorStructure::RoutingStateErrorStructure ()  :
    _u16ErrorCode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RoutingStateErrorStructure::RoutingStateErrorStructure (const RoutingStateErrorStructure &rhs)  :
    _u16ErrorCode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RoutingStateErrorStructure::RoutingStateErrorStructure (uint16 u16ErrorCode_)  :
    _u16ErrorCode (u16ErrorCode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RoutingStateErrorStructure::~RoutingStateErrorStructure() {
}

inline RoutingStateErrorStructure& RoutingStateErrorStructure::operator = (const RoutingStateErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU16ErrorCode()) {
            setU16ErrorCode(rhs.getU16ErrorCode());
        } else {
            clearU16ErrorCode();
        }
    }
    return *this;
}

inline bool RoutingStateErrorStructure::operator == (const RoutingStateErrorStructure& rhs) const {
    return (((!hasU16ErrorCode() && !rhs.hasU16ErrorCode()) || getU16ErrorCode() == rhs.getU16ErrorCode()));
}

inline bool RoutingStateErrorStructure::operator != (const RoutingStateErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool RoutingStateErrorStructure::operator < (const RoutingStateErrorStructure& rhs) const {
    if (hasU16ErrorCode() || rhs.hasU16ErrorCode()) {
        if (getU16ErrorCode() < rhs.getU16ErrorCode()) return true;
        if (getU16ErrorCode() > rhs.getU16ErrorCode()) return false;
    }
    return false;
}

inline bool RoutingStateErrorStructure::operator > (const RoutingStateErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RoutingStateErrorStructure::clear() {
    clearU16ErrorCode();
}

inline void RoutingStateErrorStructure::clearU16ErrorCode() {
    if (hasU16ErrorCode()) {
         clear_has_u16ErrorCode();
        _u16ErrorCode = 0u;
     }
}

inline bool RoutingStateErrorStructure::hasU16ErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 RoutingStateErrorStructure::getU16ErrorCode () const {
    return _u16ErrorCode;
}

inline void RoutingStateErrorStructure::setU16ErrorCode (uint16 u16ErrorCode_) {
    set_has_u16ErrorCode();
    this->_u16ErrorCode = u16ErrorCode_;
}

inline void RoutingStateErrorStructure::set_has_u16ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void RoutingStateErrorStructure::clear_has_u16ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RoutingStateError::RoutingStateError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  RoutingStateError::RoutingStateError (const RoutingStateError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  RoutingStateError::~RoutingStateError() {
    deleteData ();
}

inline RoutingStateError& RoutingStateError::operator = (const RoutingStateError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool RoutingStateError::operator == (const RoutingStateError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool RoutingStateError::operator != (const RoutingStateError& rhs) const {
    return ! (*this == rhs);
}

inline bool RoutingStateError::operator < (const RoutingStateError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool RoutingStateError::operator > (const RoutingStateError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline RoutingStateError::RoutingStateErrorField RoutingStateError::getField () const {
    return __field;
}

inline void RoutingStateError::setField(RoutingStateError::RoutingStateErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* RoutingStateError::clone() {
    return new RoutingStateError(*this);
}

inline bool RoutingStateError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const RoutingStateErrorStructure& RoutingStateError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "RoutingStateError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return RoutingStateErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline RoutingStateErrorStructure& RoutingStateError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "RoutingStateError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new RoutingStateErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline RoutingStateErrorStructure* RoutingStateError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'RoutingStateError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new RoutingStateErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        RoutingStateErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void RoutingStateError::replaceCcaErrorCode (RoutingStateErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void RoutingStateError::setCcaErrorCode (const RoutingStateErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new RoutingStateErrorStructure(value);
    }
}

inline bool RoutingStateError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode RoutingStateError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "RoutingStateError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void RoutingStateError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "RoutingStateError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void RoutingStateError::cloneData (const RoutingStateError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new RoutingStateErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new RoutingStateErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void RoutingStateError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  AllocateRouteStart::AllocateRouteStart ()  :
    _u16UCID (0u),
    _s32STM_MsgBufID (0),
    _u16Sink (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AllocateRouteStart::AllocateRouteStart (const AllocateRouteStart &rhs)  :
    ::asf::core::Payload(rhs),
    _u16UCID (0u),
    _s32STM_MsgBufID (0),
    _u16Sink (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AllocateRouteStart::AllocateRouteStart (uint16 u16UCID_, int32 s32STM_MsgBufID_, uint16 u16Sink_)  :
    _u16UCID (u16UCID_),
    _s32STM_MsgBufID (s32STM_MsgBufID_),
    _u16Sink (u16Sink_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AllocateRouteStart::~AllocateRouteStart() {
}

inline AllocateRouteStart& AllocateRouteStart::operator = (const AllocateRouteStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasU16UCID()) {
            setU16UCID(rhs.getU16UCID());
        } else {
            clearU16UCID();
        }
        if (rhs.hasS32STM_MsgBufID()) {
            setS32STM_MsgBufID(rhs.getS32STM_MsgBufID());
        } else {
            clearS32STM_MsgBufID();
        }
        if (rhs.hasU16Sink()) {
            setU16Sink(rhs.getU16Sink());
        } else {
            clearU16Sink();
        }
    }
    return *this;
}

inline bool AllocateRouteStart::operator == (const AllocateRouteStart& rhs) const {
    return (((!hasU16UCID() && !rhs.hasU16UCID()) || getU16UCID() == rhs.getU16UCID()) &&
        ((!hasS32STM_MsgBufID() && !rhs.hasS32STM_MsgBufID()) || getS32STM_MsgBufID() == rhs.getS32STM_MsgBufID()) &&
        ((!hasU16Sink() && !rhs.hasU16Sink()) || getU16Sink() == rhs.getU16Sink()));
}

inline bool AllocateRouteStart::operator != (const AllocateRouteStart& rhs) const {
    return ! (*this == rhs);
}

inline bool AllocateRouteStart::operator < (const AllocateRouteStart& rhs) const {
    if (hasU16UCID() || rhs.hasU16UCID()) {
        if (getU16UCID() < rhs.getU16UCID()) return true;
        if (getU16UCID() > rhs.getU16UCID()) return false;
    }
    if (hasS32STM_MsgBufID() || rhs.hasS32STM_MsgBufID()) {
        if (getS32STM_MsgBufID() < rhs.getS32STM_MsgBufID()) return true;
        if (getS32STM_MsgBufID() > rhs.getS32STM_MsgBufID()) return false;
    }
    if (hasU16Sink() || rhs.hasU16Sink()) {
        if (getU16Sink() < rhs.getU16Sink()) return true;
        if (getU16Sink() > rhs.getU16Sink()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AllocateRouteStart::clone() {
    return new AllocateRouteStart(*this);
}

inline bool AllocateRouteStart::operator > (const AllocateRouteStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AllocateRouteStart::clear() {
    clearU16UCID();
    clearS32STM_MsgBufID();
    clearU16Sink();
}

inline void AllocateRouteStart::clearU16UCID() {
    if (hasU16UCID()) {
         clear_has_u16UCID();
        _u16UCID = 0u;
     }
}

inline bool AllocateRouteStart::hasU16UCID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 AllocateRouteStart::getU16UCID () const {
    return _u16UCID;
}

inline void AllocateRouteStart::setU16UCID (uint16 u16UCID_) {
    set_has_u16UCID();
    this->_u16UCID = u16UCID_;
}

inline void AllocateRouteStart::clearS32STM_MsgBufID() {
    if (hasS32STM_MsgBufID()) {
         clear_has_s32STM_MsgBufID();
        _s32STM_MsgBufID = 0;
     }
}

inline bool AllocateRouteStart::hasS32STM_MsgBufID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int32 AllocateRouteStart::getS32STM_MsgBufID () const {
    return _s32STM_MsgBufID;
}

inline void AllocateRouteStart::setS32STM_MsgBufID (int32 s32STM_MsgBufID_) {
    set_has_s32STM_MsgBufID();
    this->_s32STM_MsgBufID = s32STM_MsgBufID_;
}

inline void AllocateRouteStart::clearU16Sink() {
    if (hasU16Sink()) {
         clear_has_u16Sink();
        _u16Sink = 0u;
     }
}

inline bool AllocateRouteStart::hasU16Sink () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 AllocateRouteStart::getU16Sink () const {
    return _u16Sink;
}

inline void AllocateRouteStart::setU16Sink (uint16 u16Sink_) {
    set_has_u16Sink();
    this->_u16Sink = u16Sink_;
}

inline void AllocateRouteStart::set_has_u16UCID () {
    _has_bits_[0] |= 1u << 0;
}

inline void AllocateRouteStart::clear_has_u16UCID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void AllocateRouteStart::set_has_s32STM_MsgBufID () {
    _has_bits_[0] |= 1u << 1;
}

inline void AllocateRouteStart::clear_has_s32STM_MsgBufID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void AllocateRouteStart::set_has_u16Sink () {
    _has_bits_[0] |= 1u << 2;
}

inline void AllocateRouteStart::clear_has_u16Sink () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  AllocateRouteResult::AllocateRouteResult ()  :
    _u16UCID (0u),
    _u32STM_MsgBufID (0u),
    _u16MOSTConnectionLabel (0u),
    _u16MLBChannelAddress (0u),
    _u8BlkWidth (0u),
    _u32SmHandle (0u),
    _listInputDev (),
    _listOutputDev ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AllocateRouteResult::AllocateRouteResult (const AllocateRouteResult &rhs)  :
    ::asf::core::Payload(rhs),
    _u16UCID (0u),
    _u32STM_MsgBufID (0u),
    _u16MOSTConnectionLabel (0u),
    _u16MLBChannelAddress (0u),
    _u8BlkWidth (0u),
    _u32SmHandle (0u),
    _listInputDev (),
    _listOutputDev ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AllocateRouteResult::AllocateRouteResult (uint16 u16UCID_, uint32 u32STM_MsgBufID_, uint16 u16MOSTConnectionLabel_, uint16 u16MLBChannelAddress_, uint8 u8BlkWidth_, uint32 u32SmHandle_, const ::midw_streamrouter_fi_types::T_streamrouter_device_list& listInputDev_, const ::midw_streamrouter_fi_types::T_streamrouter_device_list& listOutputDev_)  :
    _u16UCID (u16UCID_),
    _u32STM_MsgBufID (u32STM_MsgBufID_),
    _u16MOSTConnectionLabel (u16MOSTConnectionLabel_),
    _u16MLBChannelAddress (u16MLBChannelAddress_),
    _u8BlkWidth (u8BlkWidth_),
    _u32SmHandle (u32SmHandle_),
    _listInputDev (listInputDev_),
    _listOutputDev (listOutputDev_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AllocateRouteResult::~AllocateRouteResult() {
}

inline AllocateRouteResult& AllocateRouteResult::operator = (const AllocateRouteResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasU16UCID()) {
            setU16UCID(rhs.getU16UCID());
        } else {
            clearU16UCID();
        }
        if (rhs.hasU32STM_MsgBufID()) {
            setU32STM_MsgBufID(rhs.getU32STM_MsgBufID());
        } else {
            clearU32STM_MsgBufID();
        }
        if (rhs.hasU16MOSTConnectionLabel()) {
            setU16MOSTConnectionLabel(rhs.getU16MOSTConnectionLabel());
        } else {
            clearU16MOSTConnectionLabel();
        }
        if (rhs.hasU16MLBChannelAddress()) {
            setU16MLBChannelAddress(rhs.getU16MLBChannelAddress());
        } else {
            clearU16MLBChannelAddress();
        }
        if (rhs.hasU8BlkWidth()) {
            setU8BlkWidth(rhs.getU8BlkWidth());
        } else {
            clearU8BlkWidth();
        }
        if (rhs.hasU32SmHandle()) {
            setU32SmHandle(rhs.getU32SmHandle());
        } else {
            clearU32SmHandle();
        }
        if (rhs.hasListInputDev()) {
            setListInputDev(rhs.getListInputDev());
        } else {
            clearListInputDev();
        }
        if (rhs.hasListOutputDev()) {
            setListOutputDev(rhs.getListOutputDev());
        } else {
            clearListOutputDev();
        }
    }
    return *this;
}

inline bool AllocateRouteResult::operator == (const AllocateRouteResult& rhs) const {
    return (((!hasU16UCID() && !rhs.hasU16UCID()) || getU16UCID() == rhs.getU16UCID()) &&
        ((!hasU32STM_MsgBufID() && !rhs.hasU32STM_MsgBufID()) || getU32STM_MsgBufID() == rhs.getU32STM_MsgBufID()) &&
        ((!hasU16MOSTConnectionLabel() && !rhs.hasU16MOSTConnectionLabel()) || getU16MOSTConnectionLabel() == rhs.getU16MOSTConnectionLabel()) &&
        ((!hasU16MLBChannelAddress() && !rhs.hasU16MLBChannelAddress()) || getU16MLBChannelAddress() == rhs.getU16MLBChannelAddress()) &&
        ((!hasU8BlkWidth() && !rhs.hasU8BlkWidth()) || getU8BlkWidth() == rhs.getU8BlkWidth()) &&
        ((!hasU32SmHandle() && !rhs.hasU32SmHandle()) || getU32SmHandle() == rhs.getU32SmHandle()) &&
        ((!hasListInputDev() && !rhs.hasListInputDev()) || getListInputDev() == rhs.getListInputDev()) &&
        ((!hasListOutputDev() && !rhs.hasListOutputDev()) || getListOutputDev() == rhs.getListOutputDev()));
}

inline bool AllocateRouteResult::operator != (const AllocateRouteResult& rhs) const {
    return ! (*this == rhs);
}

inline bool AllocateRouteResult::operator < (const AllocateRouteResult& rhs) const {
    if (hasU16UCID() || rhs.hasU16UCID()) {
        if (getU16UCID() < rhs.getU16UCID()) return true;
        if (getU16UCID() > rhs.getU16UCID()) return false;
    }
    if (hasU32STM_MsgBufID() || rhs.hasU32STM_MsgBufID()) {
        if (getU32STM_MsgBufID() < rhs.getU32STM_MsgBufID()) return true;
        if (getU32STM_MsgBufID() > rhs.getU32STM_MsgBufID()) return false;
    }
    if (hasU16MOSTConnectionLabel() || rhs.hasU16MOSTConnectionLabel()) {
        if (getU16MOSTConnectionLabel() < rhs.getU16MOSTConnectionLabel()) return true;
        if (getU16MOSTConnectionLabel() > rhs.getU16MOSTConnectionLabel()) return false;
    }
    if (hasU16MLBChannelAddress() || rhs.hasU16MLBChannelAddress()) {
        if (getU16MLBChannelAddress() < rhs.getU16MLBChannelAddress()) return true;
        if (getU16MLBChannelAddress() > rhs.getU16MLBChannelAddress()) return false;
    }
    if (hasU8BlkWidth() || rhs.hasU8BlkWidth()) {
        if (getU8BlkWidth() < rhs.getU8BlkWidth()) return true;
        if (getU8BlkWidth() > rhs.getU8BlkWidth()) return false;
    }
    if (hasU32SmHandle() || rhs.hasU32SmHandle()) {
        if (getU32SmHandle() < rhs.getU32SmHandle()) return true;
        if (getU32SmHandle() > rhs.getU32SmHandle()) return false;
    }
    if (hasListInputDev() || rhs.hasListInputDev()) {
        if (getListInputDev() < rhs.getListInputDev()) return true;
        if (getListInputDev() > rhs.getListInputDev()) return false;
    }
    if (hasListOutputDev() || rhs.hasListOutputDev()) {
        if (getListOutputDev() < rhs.getListOutputDev()) return true;
        if (getListOutputDev() > rhs.getListOutputDev()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AllocateRouteResult::clone() {
    return new AllocateRouteResult(*this);
}

inline bool AllocateRouteResult::operator > (const AllocateRouteResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AllocateRouteResult::clear() {
    clearU16UCID();
    clearU32STM_MsgBufID();
    clearU16MOSTConnectionLabel();
    clearU16MLBChannelAddress();
    clearU8BlkWidth();
    clearU32SmHandle();
    clearListInputDev();
    clearListOutputDev();
}

inline void AllocateRouteResult::clearU16UCID() {
    if (hasU16UCID()) {
         clear_has_u16UCID();
        _u16UCID = 0u;
     }
}

inline bool AllocateRouteResult::hasU16UCID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 AllocateRouteResult::getU16UCID () const {
    return _u16UCID;
}

inline void AllocateRouteResult::setU16UCID (uint16 u16UCID_) {
    set_has_u16UCID();
    this->_u16UCID = u16UCID_;
}

inline void AllocateRouteResult::clearU32STM_MsgBufID() {
    if (hasU32STM_MsgBufID()) {
         clear_has_u32STM_MsgBufID();
        _u32STM_MsgBufID = 0u;
     }
}

inline bool AllocateRouteResult::hasU32STM_MsgBufID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 AllocateRouteResult::getU32STM_MsgBufID () const {
    return _u32STM_MsgBufID;
}

inline void AllocateRouteResult::setU32STM_MsgBufID (uint32 u32STM_MsgBufID_) {
    set_has_u32STM_MsgBufID();
    this->_u32STM_MsgBufID = u32STM_MsgBufID_;
}

inline void AllocateRouteResult::clearU16MOSTConnectionLabel() {
    if (hasU16MOSTConnectionLabel()) {
         clear_has_u16MOSTConnectionLabel();
        _u16MOSTConnectionLabel = 0u;
     }
}

inline bool AllocateRouteResult::hasU16MOSTConnectionLabel () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 AllocateRouteResult::getU16MOSTConnectionLabel () const {
    return _u16MOSTConnectionLabel;
}

inline void AllocateRouteResult::setU16MOSTConnectionLabel (uint16 u16MOSTConnectionLabel_) {
    set_has_u16MOSTConnectionLabel();
    this->_u16MOSTConnectionLabel = u16MOSTConnectionLabel_;
}

inline void AllocateRouteResult::clearU16MLBChannelAddress() {
    if (hasU16MLBChannelAddress()) {
         clear_has_u16MLBChannelAddress();
        _u16MLBChannelAddress = 0u;
     }
}

inline bool AllocateRouteResult::hasU16MLBChannelAddress () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 AllocateRouteResult::getU16MLBChannelAddress () const {
    return _u16MLBChannelAddress;
}

inline void AllocateRouteResult::setU16MLBChannelAddress (uint16 u16MLBChannelAddress_) {
    set_has_u16MLBChannelAddress();
    this->_u16MLBChannelAddress = u16MLBChannelAddress_;
}

inline void AllocateRouteResult::clearU8BlkWidth() {
    if (hasU8BlkWidth()) {
         clear_has_u8BlkWidth();
        _u8BlkWidth = 0u;
     }
}

inline bool AllocateRouteResult::hasU8BlkWidth () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 AllocateRouteResult::getU8BlkWidth () const {
    return _u8BlkWidth;
}

inline void AllocateRouteResult::setU8BlkWidth (uint8 u8BlkWidth_) {
    set_has_u8BlkWidth();
    this->_u8BlkWidth = u8BlkWidth_;
}

inline void AllocateRouteResult::clearU32SmHandle() {
    if (hasU32SmHandle()) {
         clear_has_u32SmHandle();
        _u32SmHandle = 0u;
     }
}

inline bool AllocateRouteResult::hasU32SmHandle () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint32 AllocateRouteResult::getU32SmHandle () const {
    return _u32SmHandle;
}

inline void AllocateRouteResult::setU32SmHandle (uint32 u32SmHandle_) {
    set_has_u32SmHandle();
    this->_u32SmHandle = u32SmHandle_;
}

inline void AllocateRouteResult::clearListInputDev() {
    if (hasListInputDev()) {
         clear_has_listInputDev();
        _listInputDev.clear();
     }
}

inline bool AllocateRouteResult::hasListInputDev () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline const ::midw_streamrouter_fi_types::T_streamrouter_device_list& AllocateRouteResult::getListInputDev () const {
    return _listInputDev;
}

inline ::midw_streamrouter_fi_types::T_streamrouter_device_list& AllocateRouteResult::getListInputDevMutable () {
    set_has_listInputDev();
    return _listInputDev;
}

inline void AllocateRouteResult::setListInputDev (const ::midw_streamrouter_fi_types::T_streamrouter_device_list& listInputDev_) {
    set_has_listInputDev();
    this->_listInputDev = listInputDev_;
}

inline void AllocateRouteResult::clearListOutputDev() {
    if (hasListOutputDev()) {
         clear_has_listOutputDev();
        _listOutputDev.clear();
     }
}

inline bool AllocateRouteResult::hasListOutputDev () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline const ::midw_streamrouter_fi_types::T_streamrouter_device_list& AllocateRouteResult::getListOutputDev () const {
    return _listOutputDev;
}

inline ::midw_streamrouter_fi_types::T_streamrouter_device_list& AllocateRouteResult::getListOutputDevMutable () {
    set_has_listOutputDev();
    return _listOutputDev;
}

inline void AllocateRouteResult::setListOutputDev (const ::midw_streamrouter_fi_types::T_streamrouter_device_list& listOutputDev_) {
    set_has_listOutputDev();
    this->_listOutputDev = listOutputDev_;
}

inline void AllocateRouteResult::set_has_u16UCID () {
    _has_bits_[0] |= 1u << 0;
}

inline void AllocateRouteResult::clear_has_u16UCID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void AllocateRouteResult::set_has_u32STM_MsgBufID () {
    _has_bits_[0] |= 1u << 1;
}

inline void AllocateRouteResult::clear_has_u32STM_MsgBufID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void AllocateRouteResult::set_has_u16MOSTConnectionLabel () {
    _has_bits_[0] |= 1u << 2;
}

inline void AllocateRouteResult::clear_has_u16MOSTConnectionLabel () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void AllocateRouteResult::set_has_u16MLBChannelAddress () {
    _has_bits_[0] |= 1u << 3;
}

inline void AllocateRouteResult::clear_has_u16MLBChannelAddress () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void AllocateRouteResult::set_has_u8BlkWidth () {
    _has_bits_[0] |= 1u << 4;
}

inline void AllocateRouteResult::clear_has_u8BlkWidth () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void AllocateRouteResult::set_has_u32SmHandle () {
    _has_bits_[0] |= 1u << 5;
}

inline void AllocateRouteResult::clear_has_u32SmHandle () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void AllocateRouteResult::set_has_listInputDev () {
    _has_bits_[0] |= 1u << 6;
}

inline void AllocateRouteResult::clear_has_listInputDev () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void AllocateRouteResult::set_has_listOutputDev () {
    _has_bits_[0] |= 1u << 7;
}

inline void AllocateRouteResult::clear_has_listOutputDev () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline  AllocateRouteErrorStructure::AllocateRouteErrorStructure ()  :
    _u16ErrorCode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AllocateRouteErrorStructure::AllocateRouteErrorStructure (const AllocateRouteErrorStructure &rhs)  :
    _u16ErrorCode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AllocateRouteErrorStructure::AllocateRouteErrorStructure (uint16 u16ErrorCode_)  :
    _u16ErrorCode (u16ErrorCode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AllocateRouteErrorStructure::~AllocateRouteErrorStructure() {
}

inline AllocateRouteErrorStructure& AllocateRouteErrorStructure::operator = (const AllocateRouteErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU16ErrorCode()) {
            setU16ErrorCode(rhs.getU16ErrorCode());
        } else {
            clearU16ErrorCode();
        }
    }
    return *this;
}

inline bool AllocateRouteErrorStructure::operator == (const AllocateRouteErrorStructure& rhs) const {
    return (((!hasU16ErrorCode() && !rhs.hasU16ErrorCode()) || getU16ErrorCode() == rhs.getU16ErrorCode()));
}

inline bool AllocateRouteErrorStructure::operator != (const AllocateRouteErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool AllocateRouteErrorStructure::operator < (const AllocateRouteErrorStructure& rhs) const {
    if (hasU16ErrorCode() || rhs.hasU16ErrorCode()) {
        if (getU16ErrorCode() < rhs.getU16ErrorCode()) return true;
        if (getU16ErrorCode() > rhs.getU16ErrorCode()) return false;
    }
    return false;
}

inline bool AllocateRouteErrorStructure::operator > (const AllocateRouteErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AllocateRouteErrorStructure::clear() {
    clearU16ErrorCode();
}

inline void AllocateRouteErrorStructure::clearU16ErrorCode() {
    if (hasU16ErrorCode()) {
         clear_has_u16ErrorCode();
        _u16ErrorCode = 0u;
     }
}

inline bool AllocateRouteErrorStructure::hasU16ErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 AllocateRouteErrorStructure::getU16ErrorCode () const {
    return _u16ErrorCode;
}

inline void AllocateRouteErrorStructure::setU16ErrorCode (uint16 u16ErrorCode_) {
    set_has_u16ErrorCode();
    this->_u16ErrorCode = u16ErrorCode_;
}

inline void AllocateRouteErrorStructure::set_has_u16ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void AllocateRouteErrorStructure::clear_has_u16ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AllocateRouteError::AllocateRouteError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  AllocateRouteError::AllocateRouteError (const AllocateRouteError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  AllocateRouteError::~AllocateRouteError() {
    deleteData ();
}

inline AllocateRouteError& AllocateRouteError::operator = (const AllocateRouteError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool AllocateRouteError::operator == (const AllocateRouteError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool AllocateRouteError::operator != (const AllocateRouteError& rhs) const {
    return ! (*this == rhs);
}

inline bool AllocateRouteError::operator < (const AllocateRouteError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool AllocateRouteError::operator > (const AllocateRouteError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline AllocateRouteError::AllocateRouteErrorField AllocateRouteError::getField () const {
    return __field;
}

inline void AllocateRouteError::setField(AllocateRouteError::AllocateRouteErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* AllocateRouteError::clone() {
    return new AllocateRouteError(*this);
}

inline bool AllocateRouteError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const AllocateRouteErrorStructure& AllocateRouteError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "AllocateRouteError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return AllocateRouteErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline AllocateRouteErrorStructure& AllocateRouteError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "AllocateRouteError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new AllocateRouteErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline AllocateRouteErrorStructure* AllocateRouteError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'AllocateRouteError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new AllocateRouteErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        AllocateRouteErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void AllocateRouteError::replaceCcaErrorCode (AllocateRouteErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void AllocateRouteError::setCcaErrorCode (const AllocateRouteErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new AllocateRouteErrorStructure(value);
    }
}

inline bool AllocateRouteError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode AllocateRouteError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "AllocateRouteError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void AllocateRouteError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "AllocateRouteError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void AllocateRouteError::cloneData (const AllocateRouteError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new AllocateRouteErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new AllocateRouteErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void AllocateRouteError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  DeAllocateRouteStart::DeAllocateRouteStart ()  :
    _u16UCID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DeAllocateRouteStart::DeAllocateRouteStart (const DeAllocateRouteStart &rhs)  :
    ::asf::core::Payload(rhs),
    _u16UCID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DeAllocateRouteStart::DeAllocateRouteStart (uint16 u16UCID_)  :
    _u16UCID (u16UCID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DeAllocateRouteStart::~DeAllocateRouteStart() {
}

inline DeAllocateRouteStart& DeAllocateRouteStart::operator = (const DeAllocateRouteStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasU16UCID()) {
            setU16UCID(rhs.getU16UCID());
        } else {
            clearU16UCID();
        }
    }
    return *this;
}

inline bool DeAllocateRouteStart::operator == (const DeAllocateRouteStart& rhs) const {
    return (((!hasU16UCID() && !rhs.hasU16UCID()) || getU16UCID() == rhs.getU16UCID()));
}

inline bool DeAllocateRouteStart::operator != (const DeAllocateRouteStart& rhs) const {
    return ! (*this == rhs);
}

inline bool DeAllocateRouteStart::operator < (const DeAllocateRouteStart& rhs) const {
    if (hasU16UCID() || rhs.hasU16UCID()) {
        if (getU16UCID() < rhs.getU16UCID()) return true;
        if (getU16UCID() > rhs.getU16UCID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DeAllocateRouteStart::clone() {
    return new DeAllocateRouteStart(*this);
}

inline bool DeAllocateRouteStart::operator > (const DeAllocateRouteStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DeAllocateRouteStart::clear() {
    clearU16UCID();
}

inline void DeAllocateRouteStart::clearU16UCID() {
    if (hasU16UCID()) {
         clear_has_u16UCID();
        _u16UCID = 0u;
     }
}

inline bool DeAllocateRouteStart::hasU16UCID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 DeAllocateRouteStart::getU16UCID () const {
    return _u16UCID;
}

inline void DeAllocateRouteStart::setU16UCID (uint16 u16UCID_) {
    set_has_u16UCID();
    this->_u16UCID = u16UCID_;
}

inline void DeAllocateRouteStart::set_has_u16UCID () {
    _has_bits_[0] |= 1u << 0;
}

inline void DeAllocateRouteStart::clear_has_u16UCID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DeAllocateRouteResult::DeAllocateRouteResult ()  :
    _u16UCID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DeAllocateRouteResult::DeAllocateRouteResult (const DeAllocateRouteResult &rhs)  :
    ::asf::core::Payload(rhs),
    _u16UCID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DeAllocateRouteResult::DeAllocateRouteResult (uint16 u16UCID_)  :
    _u16UCID (u16UCID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DeAllocateRouteResult::~DeAllocateRouteResult() {
}

inline DeAllocateRouteResult& DeAllocateRouteResult::operator = (const DeAllocateRouteResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasU16UCID()) {
            setU16UCID(rhs.getU16UCID());
        } else {
            clearU16UCID();
        }
    }
    return *this;
}

inline bool DeAllocateRouteResult::operator == (const DeAllocateRouteResult& rhs) const {
    return (((!hasU16UCID() && !rhs.hasU16UCID()) || getU16UCID() == rhs.getU16UCID()));
}

inline bool DeAllocateRouteResult::operator != (const DeAllocateRouteResult& rhs) const {
    return ! (*this == rhs);
}

inline bool DeAllocateRouteResult::operator < (const DeAllocateRouteResult& rhs) const {
    if (hasU16UCID() || rhs.hasU16UCID()) {
        if (getU16UCID() < rhs.getU16UCID()) return true;
        if (getU16UCID() > rhs.getU16UCID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DeAllocateRouteResult::clone() {
    return new DeAllocateRouteResult(*this);
}

inline bool DeAllocateRouteResult::operator > (const DeAllocateRouteResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DeAllocateRouteResult::clear() {
    clearU16UCID();
}

inline void DeAllocateRouteResult::clearU16UCID() {
    if (hasU16UCID()) {
         clear_has_u16UCID();
        _u16UCID = 0u;
     }
}

inline bool DeAllocateRouteResult::hasU16UCID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 DeAllocateRouteResult::getU16UCID () const {
    return _u16UCID;
}

inline void DeAllocateRouteResult::setU16UCID (uint16 u16UCID_) {
    set_has_u16UCID();
    this->_u16UCID = u16UCID_;
}

inline void DeAllocateRouteResult::set_has_u16UCID () {
    _has_bits_[0] |= 1u << 0;
}

inline void DeAllocateRouteResult::clear_has_u16UCID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DeAllocateRouteErrorStructure::DeAllocateRouteErrorStructure ()  :
    _u16ErrorCode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DeAllocateRouteErrorStructure::DeAllocateRouteErrorStructure (const DeAllocateRouteErrorStructure &rhs)  :
    _u16ErrorCode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DeAllocateRouteErrorStructure::DeAllocateRouteErrorStructure (uint16 u16ErrorCode_)  :
    _u16ErrorCode (u16ErrorCode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DeAllocateRouteErrorStructure::~DeAllocateRouteErrorStructure() {
}

inline DeAllocateRouteErrorStructure& DeAllocateRouteErrorStructure::operator = (const DeAllocateRouteErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU16ErrorCode()) {
            setU16ErrorCode(rhs.getU16ErrorCode());
        } else {
            clearU16ErrorCode();
        }
    }
    return *this;
}

inline bool DeAllocateRouteErrorStructure::operator == (const DeAllocateRouteErrorStructure& rhs) const {
    return (((!hasU16ErrorCode() && !rhs.hasU16ErrorCode()) || getU16ErrorCode() == rhs.getU16ErrorCode()));
}

inline bool DeAllocateRouteErrorStructure::operator != (const DeAllocateRouteErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool DeAllocateRouteErrorStructure::operator < (const DeAllocateRouteErrorStructure& rhs) const {
    if (hasU16ErrorCode() || rhs.hasU16ErrorCode()) {
        if (getU16ErrorCode() < rhs.getU16ErrorCode()) return true;
        if (getU16ErrorCode() > rhs.getU16ErrorCode()) return false;
    }
    return false;
}

inline bool DeAllocateRouteErrorStructure::operator > (const DeAllocateRouteErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DeAllocateRouteErrorStructure::clear() {
    clearU16ErrorCode();
}

inline void DeAllocateRouteErrorStructure::clearU16ErrorCode() {
    if (hasU16ErrorCode()) {
         clear_has_u16ErrorCode();
        _u16ErrorCode = 0u;
     }
}

inline bool DeAllocateRouteErrorStructure::hasU16ErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 DeAllocateRouteErrorStructure::getU16ErrorCode () const {
    return _u16ErrorCode;
}

inline void DeAllocateRouteErrorStructure::setU16ErrorCode (uint16 u16ErrorCode_) {
    set_has_u16ErrorCode();
    this->_u16ErrorCode = u16ErrorCode_;
}

inline void DeAllocateRouteErrorStructure::set_has_u16ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void DeAllocateRouteErrorStructure::clear_has_u16ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DeAllocateRouteError::DeAllocateRouteError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  DeAllocateRouteError::DeAllocateRouteError (const DeAllocateRouteError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  DeAllocateRouteError::~DeAllocateRouteError() {
    deleteData ();
}

inline DeAllocateRouteError& DeAllocateRouteError::operator = (const DeAllocateRouteError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool DeAllocateRouteError::operator == (const DeAllocateRouteError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool DeAllocateRouteError::operator != (const DeAllocateRouteError& rhs) const {
    return ! (*this == rhs);
}

inline bool DeAllocateRouteError::operator < (const DeAllocateRouteError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool DeAllocateRouteError::operator > (const DeAllocateRouteError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline DeAllocateRouteError::DeAllocateRouteErrorField DeAllocateRouteError::getField () const {
    return __field;
}

inline void DeAllocateRouteError::setField(DeAllocateRouteError::DeAllocateRouteErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* DeAllocateRouteError::clone() {
    return new DeAllocateRouteError(*this);
}

inline bool DeAllocateRouteError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const DeAllocateRouteErrorStructure& DeAllocateRouteError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "DeAllocateRouteError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return DeAllocateRouteErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline DeAllocateRouteErrorStructure& DeAllocateRouteError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "DeAllocateRouteError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new DeAllocateRouteErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline DeAllocateRouteErrorStructure* DeAllocateRouteError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'DeAllocateRouteError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new DeAllocateRouteErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        DeAllocateRouteErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void DeAllocateRouteError::replaceCcaErrorCode (DeAllocateRouteErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void DeAllocateRouteError::setCcaErrorCode (const DeAllocateRouteErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new DeAllocateRouteErrorStructure(value);
    }
}

inline bool DeAllocateRouteError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode DeAllocateRouteError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "DeAllocateRouteError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void DeAllocateRouteError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "DeAllocateRouteError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void DeAllocateRouteError::cloneData (const DeAllocateRouteError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new DeAllocateRouteErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new DeAllocateRouteErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void DeAllocateRouteError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  SetPlayStart::SetPlayStart ()  :
    _u16UCID (0u),
    _eRampType (::midw_streamrouter_fi_types::T_e8_streamrouter_ramptype__NO)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetPlayStart::SetPlayStart (const SetPlayStart &rhs)  :
    ::asf::core::Payload(rhs),
    _u16UCID (0u),
    _eRampType (::midw_streamrouter_fi_types::T_e8_streamrouter_ramptype__NO)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetPlayStart::SetPlayStart (uint16 u16UCID_, ::midw_streamrouter_fi_types::T_e8_streamrouter_ramptype eRampType_)  :
    _u16UCID (u16UCID_),
    _eRampType (eRampType_)
{
    #ifndef NDEBUG
    if (!(::midw_streamrouter_fi_types::T_e8_streamrouter_ramptype_IsValid(eRampType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eRampType_, "T_e8_streamrouter_ramptype", "eRampType", "SetPlayStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetPlayStart::~SetPlayStart() {
}

inline SetPlayStart& SetPlayStart::operator = (const SetPlayStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasU16UCID()) {
            setU16UCID(rhs.getU16UCID());
        } else {
            clearU16UCID();
        }
        if (rhs.hasERampType()) {
            setERampType(rhs.getERampType());
        } else {
            clearERampType();
        }
    }
    return *this;
}

inline bool SetPlayStart::operator == (const SetPlayStart& rhs) const {
    return (((!hasU16UCID() && !rhs.hasU16UCID()) || getU16UCID() == rhs.getU16UCID()) &&
        ((!hasERampType() && !rhs.hasERampType()) || getERampType() == rhs.getERampType()));
}

inline bool SetPlayStart::operator != (const SetPlayStart& rhs) const {
    return ! (*this == rhs);
}

inline bool SetPlayStart::operator < (const SetPlayStart& rhs) const {
    if (hasU16UCID() || rhs.hasU16UCID()) {
        if (getU16UCID() < rhs.getU16UCID()) return true;
        if (getU16UCID() > rhs.getU16UCID()) return false;
    }
    if (hasERampType() || rhs.hasERampType()) {
        if ((uint32)getERampType() < (uint32)rhs.getERampType()) return true;
        if ((uint32)getERampType() > (uint32)rhs.getERampType()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetPlayStart::clone() {
    return new SetPlayStart(*this);
}

inline bool SetPlayStart::operator > (const SetPlayStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetPlayStart::clear() {
    clearU16UCID();
    clearERampType();
}

inline void SetPlayStart::clearU16UCID() {
    if (hasU16UCID()) {
         clear_has_u16UCID();
        _u16UCID = 0u;
     }
}

inline bool SetPlayStart::hasU16UCID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 SetPlayStart::getU16UCID () const {
    return _u16UCID;
}

inline void SetPlayStart::setU16UCID (uint16 u16UCID_) {
    set_has_u16UCID();
    this->_u16UCID = u16UCID_;
}

inline void SetPlayStart::clearERampType() {
    if (hasERampType()) {
         clear_has_eRampType();
        _eRampType = ::midw_streamrouter_fi_types::T_e8_streamrouter_ramptype__NO;
     }
}

inline bool SetPlayStart::hasERampType () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::midw_streamrouter_fi_types::T_e8_streamrouter_ramptype SetPlayStart::getERampType () const {
    return _eRampType;
}

inline void SetPlayStart::setERampType (::midw_streamrouter_fi_types::T_e8_streamrouter_ramptype eRampType_) {
    #ifndef NDEBUG
    if (!(::midw_streamrouter_fi_types::T_e8_streamrouter_ramptype_IsValid(eRampType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eRampType_, "T_e8_streamrouter_ramptype", "eRampType", "SetPlayStart");
    }
    #endif
    set_has_eRampType();
    this->_eRampType = eRampType_;
}

inline void SetPlayStart::set_has_u16UCID () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetPlayStart::clear_has_u16UCID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetPlayStart::set_has_eRampType () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetPlayStart::clear_has_eRampType () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SetPlayResult::SetPlayResult ()  :
    _u16UCID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetPlayResult::SetPlayResult (const SetPlayResult &rhs)  :
    ::asf::core::Payload(rhs),
    _u16UCID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetPlayResult::SetPlayResult (uint16 u16UCID_)  :
    _u16UCID (u16UCID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetPlayResult::~SetPlayResult() {
}

inline SetPlayResult& SetPlayResult::operator = (const SetPlayResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasU16UCID()) {
            setU16UCID(rhs.getU16UCID());
        } else {
            clearU16UCID();
        }
    }
    return *this;
}

inline bool SetPlayResult::operator == (const SetPlayResult& rhs) const {
    return (((!hasU16UCID() && !rhs.hasU16UCID()) || getU16UCID() == rhs.getU16UCID()));
}

inline bool SetPlayResult::operator != (const SetPlayResult& rhs) const {
    return ! (*this == rhs);
}

inline bool SetPlayResult::operator < (const SetPlayResult& rhs) const {
    if (hasU16UCID() || rhs.hasU16UCID()) {
        if (getU16UCID() < rhs.getU16UCID()) return true;
        if (getU16UCID() > rhs.getU16UCID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetPlayResult::clone() {
    return new SetPlayResult(*this);
}

inline bool SetPlayResult::operator > (const SetPlayResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetPlayResult::clear() {
    clearU16UCID();
}

inline void SetPlayResult::clearU16UCID() {
    if (hasU16UCID()) {
         clear_has_u16UCID();
        _u16UCID = 0u;
     }
}

inline bool SetPlayResult::hasU16UCID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 SetPlayResult::getU16UCID () const {
    return _u16UCID;
}

inline void SetPlayResult::setU16UCID (uint16 u16UCID_) {
    set_has_u16UCID();
    this->_u16UCID = u16UCID_;
}

inline void SetPlayResult::set_has_u16UCID () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetPlayResult::clear_has_u16UCID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetPlayErrorStructure::SetPlayErrorStructure ()  :
    _u16ErrorCode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetPlayErrorStructure::SetPlayErrorStructure (const SetPlayErrorStructure &rhs)  :
    _u16ErrorCode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetPlayErrorStructure::SetPlayErrorStructure (uint16 u16ErrorCode_)  :
    _u16ErrorCode (u16ErrorCode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetPlayErrorStructure::~SetPlayErrorStructure() {
}

inline SetPlayErrorStructure& SetPlayErrorStructure::operator = (const SetPlayErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU16ErrorCode()) {
            setU16ErrorCode(rhs.getU16ErrorCode());
        } else {
            clearU16ErrorCode();
        }
    }
    return *this;
}

inline bool SetPlayErrorStructure::operator == (const SetPlayErrorStructure& rhs) const {
    return (((!hasU16ErrorCode() && !rhs.hasU16ErrorCode()) || getU16ErrorCode() == rhs.getU16ErrorCode()));
}

inline bool SetPlayErrorStructure::operator != (const SetPlayErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool SetPlayErrorStructure::operator < (const SetPlayErrorStructure& rhs) const {
    if (hasU16ErrorCode() || rhs.hasU16ErrorCode()) {
        if (getU16ErrorCode() < rhs.getU16ErrorCode()) return true;
        if (getU16ErrorCode() > rhs.getU16ErrorCode()) return false;
    }
    return false;
}

inline bool SetPlayErrorStructure::operator > (const SetPlayErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetPlayErrorStructure::clear() {
    clearU16ErrorCode();
}

inline void SetPlayErrorStructure::clearU16ErrorCode() {
    if (hasU16ErrorCode()) {
         clear_has_u16ErrorCode();
        _u16ErrorCode = 0u;
     }
}

inline bool SetPlayErrorStructure::hasU16ErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 SetPlayErrorStructure::getU16ErrorCode () const {
    return _u16ErrorCode;
}

inline void SetPlayErrorStructure::setU16ErrorCode (uint16 u16ErrorCode_) {
    set_has_u16ErrorCode();
    this->_u16ErrorCode = u16ErrorCode_;
}

inline void SetPlayErrorStructure::set_has_u16ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetPlayErrorStructure::clear_has_u16ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetPlayError::SetPlayError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  SetPlayError::SetPlayError (const SetPlayError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  SetPlayError::~SetPlayError() {
    deleteData ();
}

inline SetPlayError& SetPlayError::operator = (const SetPlayError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool SetPlayError::operator == (const SetPlayError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool SetPlayError::operator != (const SetPlayError& rhs) const {
    return ! (*this == rhs);
}

inline bool SetPlayError::operator < (const SetPlayError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool SetPlayError::operator > (const SetPlayError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline SetPlayError::SetPlayErrorField SetPlayError::getField () const {
    return __field;
}

inline void SetPlayError::setField(SetPlayError::SetPlayErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* SetPlayError::clone() {
    return new SetPlayError(*this);
}

inline bool SetPlayError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const SetPlayErrorStructure& SetPlayError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "SetPlayError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return SetPlayErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline SetPlayErrorStructure& SetPlayError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "SetPlayError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new SetPlayErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline SetPlayErrorStructure* SetPlayError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'SetPlayError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new SetPlayErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        SetPlayErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void SetPlayError::replaceCcaErrorCode (SetPlayErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void SetPlayError::setCcaErrorCode (const SetPlayErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new SetPlayErrorStructure(value);
    }
}

inline bool SetPlayError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode SetPlayError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "SetPlayError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void SetPlayError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "SetPlayError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void SetPlayError::cloneData (const SetPlayError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new SetPlayErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new SetPlayErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void SetPlayError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  SetStopStart::SetStopStart ()  :
    _u16UCID (0u),
    _eRampType (::midw_streamrouter_fi_types::T_e8_streamrouter_ramptype__NO)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetStopStart::SetStopStart (const SetStopStart &rhs)  :
    ::asf::core::Payload(rhs),
    _u16UCID (0u),
    _eRampType (::midw_streamrouter_fi_types::T_e8_streamrouter_ramptype__NO)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetStopStart::SetStopStart (uint16 u16UCID_, ::midw_streamrouter_fi_types::T_e8_streamrouter_ramptype eRampType_)  :
    _u16UCID (u16UCID_),
    _eRampType (eRampType_)
{
    #ifndef NDEBUG
    if (!(::midw_streamrouter_fi_types::T_e8_streamrouter_ramptype_IsValid(eRampType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eRampType_, "T_e8_streamrouter_ramptype", "eRampType", "SetStopStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetStopStart::~SetStopStart() {
}

inline SetStopStart& SetStopStart::operator = (const SetStopStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasU16UCID()) {
            setU16UCID(rhs.getU16UCID());
        } else {
            clearU16UCID();
        }
        if (rhs.hasERampType()) {
            setERampType(rhs.getERampType());
        } else {
            clearERampType();
        }
    }
    return *this;
}

inline bool SetStopStart::operator == (const SetStopStart& rhs) const {
    return (((!hasU16UCID() && !rhs.hasU16UCID()) || getU16UCID() == rhs.getU16UCID()) &&
        ((!hasERampType() && !rhs.hasERampType()) || getERampType() == rhs.getERampType()));
}

inline bool SetStopStart::operator != (const SetStopStart& rhs) const {
    return ! (*this == rhs);
}

inline bool SetStopStart::operator < (const SetStopStart& rhs) const {
    if (hasU16UCID() || rhs.hasU16UCID()) {
        if (getU16UCID() < rhs.getU16UCID()) return true;
        if (getU16UCID() > rhs.getU16UCID()) return false;
    }
    if (hasERampType() || rhs.hasERampType()) {
        if ((uint32)getERampType() < (uint32)rhs.getERampType()) return true;
        if ((uint32)getERampType() > (uint32)rhs.getERampType()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetStopStart::clone() {
    return new SetStopStart(*this);
}

inline bool SetStopStart::operator > (const SetStopStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetStopStart::clear() {
    clearU16UCID();
    clearERampType();
}

inline void SetStopStart::clearU16UCID() {
    if (hasU16UCID()) {
         clear_has_u16UCID();
        _u16UCID = 0u;
     }
}

inline bool SetStopStart::hasU16UCID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 SetStopStart::getU16UCID () const {
    return _u16UCID;
}

inline void SetStopStart::setU16UCID (uint16 u16UCID_) {
    set_has_u16UCID();
    this->_u16UCID = u16UCID_;
}

inline void SetStopStart::clearERampType() {
    if (hasERampType()) {
         clear_has_eRampType();
        _eRampType = ::midw_streamrouter_fi_types::T_e8_streamrouter_ramptype__NO;
     }
}

inline bool SetStopStart::hasERampType () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::midw_streamrouter_fi_types::T_e8_streamrouter_ramptype SetStopStart::getERampType () const {
    return _eRampType;
}

inline void SetStopStart::setERampType (::midw_streamrouter_fi_types::T_e8_streamrouter_ramptype eRampType_) {
    #ifndef NDEBUG
    if (!(::midw_streamrouter_fi_types::T_e8_streamrouter_ramptype_IsValid(eRampType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eRampType_, "T_e8_streamrouter_ramptype", "eRampType", "SetStopStart");
    }
    #endif
    set_has_eRampType();
    this->_eRampType = eRampType_;
}

inline void SetStopStart::set_has_u16UCID () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetStopStart::clear_has_u16UCID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetStopStart::set_has_eRampType () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetStopStart::clear_has_eRampType () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SetStopResult::SetStopResult ()  :
    _u16UCID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetStopResult::SetStopResult (const SetStopResult &rhs)  :
    ::asf::core::Payload(rhs),
    _u16UCID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetStopResult::SetStopResult (uint16 u16UCID_)  :
    _u16UCID (u16UCID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetStopResult::~SetStopResult() {
}

inline SetStopResult& SetStopResult::operator = (const SetStopResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasU16UCID()) {
            setU16UCID(rhs.getU16UCID());
        } else {
            clearU16UCID();
        }
    }
    return *this;
}

inline bool SetStopResult::operator == (const SetStopResult& rhs) const {
    return (((!hasU16UCID() && !rhs.hasU16UCID()) || getU16UCID() == rhs.getU16UCID()));
}

inline bool SetStopResult::operator != (const SetStopResult& rhs) const {
    return ! (*this == rhs);
}

inline bool SetStopResult::operator < (const SetStopResult& rhs) const {
    if (hasU16UCID() || rhs.hasU16UCID()) {
        if (getU16UCID() < rhs.getU16UCID()) return true;
        if (getU16UCID() > rhs.getU16UCID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetStopResult::clone() {
    return new SetStopResult(*this);
}

inline bool SetStopResult::operator > (const SetStopResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetStopResult::clear() {
    clearU16UCID();
}

inline void SetStopResult::clearU16UCID() {
    if (hasU16UCID()) {
         clear_has_u16UCID();
        _u16UCID = 0u;
     }
}

inline bool SetStopResult::hasU16UCID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 SetStopResult::getU16UCID () const {
    return _u16UCID;
}

inline void SetStopResult::setU16UCID (uint16 u16UCID_) {
    set_has_u16UCID();
    this->_u16UCID = u16UCID_;
}

inline void SetStopResult::set_has_u16UCID () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetStopResult::clear_has_u16UCID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetStopErrorStructure::SetStopErrorStructure ()  :
    _u16ErrorCode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetStopErrorStructure::SetStopErrorStructure (const SetStopErrorStructure &rhs)  :
    _u16ErrorCode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetStopErrorStructure::SetStopErrorStructure (uint16 u16ErrorCode_)  :
    _u16ErrorCode (u16ErrorCode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetStopErrorStructure::~SetStopErrorStructure() {
}

inline SetStopErrorStructure& SetStopErrorStructure::operator = (const SetStopErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU16ErrorCode()) {
            setU16ErrorCode(rhs.getU16ErrorCode());
        } else {
            clearU16ErrorCode();
        }
    }
    return *this;
}

inline bool SetStopErrorStructure::operator == (const SetStopErrorStructure& rhs) const {
    return (((!hasU16ErrorCode() && !rhs.hasU16ErrorCode()) || getU16ErrorCode() == rhs.getU16ErrorCode()));
}

inline bool SetStopErrorStructure::operator != (const SetStopErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool SetStopErrorStructure::operator < (const SetStopErrorStructure& rhs) const {
    if (hasU16ErrorCode() || rhs.hasU16ErrorCode()) {
        if (getU16ErrorCode() < rhs.getU16ErrorCode()) return true;
        if (getU16ErrorCode() > rhs.getU16ErrorCode()) return false;
    }
    return false;
}

inline bool SetStopErrorStructure::operator > (const SetStopErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetStopErrorStructure::clear() {
    clearU16ErrorCode();
}

inline void SetStopErrorStructure::clearU16ErrorCode() {
    if (hasU16ErrorCode()) {
         clear_has_u16ErrorCode();
        _u16ErrorCode = 0u;
     }
}

inline bool SetStopErrorStructure::hasU16ErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 SetStopErrorStructure::getU16ErrorCode () const {
    return _u16ErrorCode;
}

inline void SetStopErrorStructure::setU16ErrorCode (uint16 u16ErrorCode_) {
    set_has_u16ErrorCode();
    this->_u16ErrorCode = u16ErrorCode_;
}

inline void SetStopErrorStructure::set_has_u16ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetStopErrorStructure::clear_has_u16ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetStopError::SetStopError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  SetStopError::SetStopError (const SetStopError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  SetStopError::~SetStopError() {
    deleteData ();
}

inline SetStopError& SetStopError::operator = (const SetStopError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool SetStopError::operator == (const SetStopError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool SetStopError::operator != (const SetStopError& rhs) const {
    return ! (*this == rhs);
}

inline bool SetStopError::operator < (const SetStopError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool SetStopError::operator > (const SetStopError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline SetStopError::SetStopErrorField SetStopError::getField () const {
    return __field;
}

inline void SetStopError::setField(SetStopError::SetStopErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* SetStopError::clone() {
    return new SetStopError(*this);
}

inline bool SetStopError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const SetStopErrorStructure& SetStopError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "SetStopError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return SetStopErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline SetStopErrorStructure& SetStopError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "SetStopError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new SetStopErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline SetStopErrorStructure* SetStopError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'SetStopError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new SetStopErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        SetStopErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void SetStopError::replaceCcaErrorCode (SetStopErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void SetStopError::setCcaErrorCode (const SetStopErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new SetStopErrorStructure(value);
    }
}

inline bool SetStopError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode SetStopError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "SetStopError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void SetStopError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "SetStopError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void SetStopError::cloneData (const SetStopError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new SetStopErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new SetStopErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void SetStopError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  SendFGCommandStart::SendFGCommandStart ()  :
    _u16UCID (0u),
    _u16FGRouteID (0u),
    _eCmd (::midw_streamrouter_fi_types::T_e8_streamrouter_fgcommand__ECNR_MICMUTE_ON)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SendFGCommandStart::SendFGCommandStart (const SendFGCommandStart &rhs)  :
    ::asf::core::Payload(rhs),
    _u16UCID (0u),
    _u16FGRouteID (0u),
    _eCmd (::midw_streamrouter_fi_types::T_e8_streamrouter_fgcommand__ECNR_MICMUTE_ON)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SendFGCommandStart::SendFGCommandStart (uint16 u16UCID_, uint16 u16FGRouteID_, ::midw_streamrouter_fi_types::T_e8_streamrouter_fgcommand eCmd_)  :
    _u16UCID (u16UCID_),
    _u16FGRouteID (u16FGRouteID_),
    _eCmd (eCmd_)
{
    #ifndef NDEBUG
    if (!(::midw_streamrouter_fi_types::T_e8_streamrouter_fgcommand_IsValid(eCmd_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eCmd_, "T_e8_streamrouter_fgcommand", "eCmd", "SendFGCommandStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SendFGCommandStart::~SendFGCommandStart() {
}

inline SendFGCommandStart& SendFGCommandStart::operator = (const SendFGCommandStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasU16UCID()) {
            setU16UCID(rhs.getU16UCID());
        } else {
            clearU16UCID();
        }
        if (rhs.hasU16FGRouteID()) {
            setU16FGRouteID(rhs.getU16FGRouteID());
        } else {
            clearU16FGRouteID();
        }
        if (rhs.hasECmd()) {
            setECmd(rhs.getECmd());
        } else {
            clearECmd();
        }
    }
    return *this;
}

inline bool SendFGCommandStart::operator == (const SendFGCommandStart& rhs) const {
    return (((!hasU16UCID() && !rhs.hasU16UCID()) || getU16UCID() == rhs.getU16UCID()) &&
        ((!hasU16FGRouteID() && !rhs.hasU16FGRouteID()) || getU16FGRouteID() == rhs.getU16FGRouteID()) &&
        ((!hasECmd() && !rhs.hasECmd()) || getECmd() == rhs.getECmd()));
}

inline bool SendFGCommandStart::operator != (const SendFGCommandStart& rhs) const {
    return ! (*this == rhs);
}

inline bool SendFGCommandStart::operator < (const SendFGCommandStart& rhs) const {
    if (hasU16UCID() || rhs.hasU16UCID()) {
        if (getU16UCID() < rhs.getU16UCID()) return true;
        if (getU16UCID() > rhs.getU16UCID()) return false;
    }
    if (hasU16FGRouteID() || rhs.hasU16FGRouteID()) {
        if (getU16FGRouteID() < rhs.getU16FGRouteID()) return true;
        if (getU16FGRouteID() > rhs.getU16FGRouteID()) return false;
    }
    if (hasECmd() || rhs.hasECmd()) {
        if ((uint32)getECmd() < (uint32)rhs.getECmd()) return true;
        if ((uint32)getECmd() > (uint32)rhs.getECmd()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SendFGCommandStart::clone() {
    return new SendFGCommandStart(*this);
}

inline bool SendFGCommandStart::operator > (const SendFGCommandStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SendFGCommandStart::clear() {
    clearU16UCID();
    clearU16FGRouteID();
    clearECmd();
}

inline void SendFGCommandStart::clearU16UCID() {
    if (hasU16UCID()) {
         clear_has_u16UCID();
        _u16UCID = 0u;
     }
}

inline bool SendFGCommandStart::hasU16UCID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 SendFGCommandStart::getU16UCID () const {
    return _u16UCID;
}

inline void SendFGCommandStart::setU16UCID (uint16 u16UCID_) {
    set_has_u16UCID();
    this->_u16UCID = u16UCID_;
}

inline void SendFGCommandStart::clearU16FGRouteID() {
    if (hasU16FGRouteID()) {
         clear_has_u16FGRouteID();
        _u16FGRouteID = 0u;
     }
}

inline bool SendFGCommandStart::hasU16FGRouteID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 SendFGCommandStart::getU16FGRouteID () const {
    return _u16FGRouteID;
}

inline void SendFGCommandStart::setU16FGRouteID (uint16 u16FGRouteID_) {
    set_has_u16FGRouteID();
    this->_u16FGRouteID = u16FGRouteID_;
}

inline void SendFGCommandStart::clearECmd() {
    if (hasECmd()) {
         clear_has_eCmd();
        _eCmd = ::midw_streamrouter_fi_types::T_e8_streamrouter_fgcommand__ECNR_MICMUTE_ON;
     }
}

inline bool SendFGCommandStart::hasECmd () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline ::midw_streamrouter_fi_types::T_e8_streamrouter_fgcommand SendFGCommandStart::getECmd () const {
    return _eCmd;
}

inline void SendFGCommandStart::setECmd (::midw_streamrouter_fi_types::T_e8_streamrouter_fgcommand eCmd_) {
    #ifndef NDEBUG
    if (!(::midw_streamrouter_fi_types::T_e8_streamrouter_fgcommand_IsValid(eCmd_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eCmd_, "T_e8_streamrouter_fgcommand", "eCmd", "SendFGCommandStart");
    }
    #endif
    set_has_eCmd();
    this->_eCmd = eCmd_;
}

inline void SendFGCommandStart::set_has_u16UCID () {
    _has_bits_[0] |= 1u << 0;
}

inline void SendFGCommandStart::clear_has_u16UCID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SendFGCommandStart::set_has_u16FGRouteID () {
    _has_bits_[0] |= 1u << 1;
}

inline void SendFGCommandStart::clear_has_u16FGRouteID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SendFGCommandStart::set_has_eCmd () {
    _has_bits_[0] |= 1u << 2;
}

inline void SendFGCommandStart::clear_has_eCmd () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  SendFGCommandResult::SendFGCommandResult ()  :
    _u16UCID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SendFGCommandResult::SendFGCommandResult (const SendFGCommandResult &rhs)  :
    ::asf::core::Payload(rhs),
    _u16UCID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SendFGCommandResult::SendFGCommandResult (uint16 u16UCID_)  :
    _u16UCID (u16UCID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SendFGCommandResult::~SendFGCommandResult() {
}

inline SendFGCommandResult& SendFGCommandResult::operator = (const SendFGCommandResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasU16UCID()) {
            setU16UCID(rhs.getU16UCID());
        } else {
            clearU16UCID();
        }
    }
    return *this;
}

inline bool SendFGCommandResult::operator == (const SendFGCommandResult& rhs) const {
    return (((!hasU16UCID() && !rhs.hasU16UCID()) || getU16UCID() == rhs.getU16UCID()));
}

inline bool SendFGCommandResult::operator != (const SendFGCommandResult& rhs) const {
    return ! (*this == rhs);
}

inline bool SendFGCommandResult::operator < (const SendFGCommandResult& rhs) const {
    if (hasU16UCID() || rhs.hasU16UCID()) {
        if (getU16UCID() < rhs.getU16UCID()) return true;
        if (getU16UCID() > rhs.getU16UCID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SendFGCommandResult::clone() {
    return new SendFGCommandResult(*this);
}

inline bool SendFGCommandResult::operator > (const SendFGCommandResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SendFGCommandResult::clear() {
    clearU16UCID();
}

inline void SendFGCommandResult::clearU16UCID() {
    if (hasU16UCID()) {
         clear_has_u16UCID();
        _u16UCID = 0u;
     }
}

inline bool SendFGCommandResult::hasU16UCID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 SendFGCommandResult::getU16UCID () const {
    return _u16UCID;
}

inline void SendFGCommandResult::setU16UCID (uint16 u16UCID_) {
    set_has_u16UCID();
    this->_u16UCID = u16UCID_;
}

inline void SendFGCommandResult::set_has_u16UCID () {
    _has_bits_[0] |= 1u << 0;
}

inline void SendFGCommandResult::clear_has_u16UCID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SendFGCommandErrorStructure::SendFGCommandErrorStructure ()  :
    _u16ErrorCode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SendFGCommandErrorStructure::SendFGCommandErrorStructure (const SendFGCommandErrorStructure &rhs)  :
    _u16ErrorCode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SendFGCommandErrorStructure::SendFGCommandErrorStructure (uint16 u16ErrorCode_)  :
    _u16ErrorCode (u16ErrorCode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SendFGCommandErrorStructure::~SendFGCommandErrorStructure() {
}

inline SendFGCommandErrorStructure& SendFGCommandErrorStructure::operator = (const SendFGCommandErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU16ErrorCode()) {
            setU16ErrorCode(rhs.getU16ErrorCode());
        } else {
            clearU16ErrorCode();
        }
    }
    return *this;
}

inline bool SendFGCommandErrorStructure::operator == (const SendFGCommandErrorStructure& rhs) const {
    return (((!hasU16ErrorCode() && !rhs.hasU16ErrorCode()) || getU16ErrorCode() == rhs.getU16ErrorCode()));
}

inline bool SendFGCommandErrorStructure::operator != (const SendFGCommandErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool SendFGCommandErrorStructure::operator < (const SendFGCommandErrorStructure& rhs) const {
    if (hasU16ErrorCode() || rhs.hasU16ErrorCode()) {
        if (getU16ErrorCode() < rhs.getU16ErrorCode()) return true;
        if (getU16ErrorCode() > rhs.getU16ErrorCode()) return false;
    }
    return false;
}

inline bool SendFGCommandErrorStructure::operator > (const SendFGCommandErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SendFGCommandErrorStructure::clear() {
    clearU16ErrorCode();
}

inline void SendFGCommandErrorStructure::clearU16ErrorCode() {
    if (hasU16ErrorCode()) {
         clear_has_u16ErrorCode();
        _u16ErrorCode = 0u;
     }
}

inline bool SendFGCommandErrorStructure::hasU16ErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 SendFGCommandErrorStructure::getU16ErrorCode () const {
    return _u16ErrorCode;
}

inline void SendFGCommandErrorStructure::setU16ErrorCode (uint16 u16ErrorCode_) {
    set_has_u16ErrorCode();
    this->_u16ErrorCode = u16ErrorCode_;
}

inline void SendFGCommandErrorStructure::set_has_u16ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void SendFGCommandErrorStructure::clear_has_u16ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SendFGCommandError::SendFGCommandError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  SendFGCommandError::SendFGCommandError (const SendFGCommandError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  SendFGCommandError::~SendFGCommandError() {
    deleteData ();
}

inline SendFGCommandError& SendFGCommandError::operator = (const SendFGCommandError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool SendFGCommandError::operator == (const SendFGCommandError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool SendFGCommandError::operator != (const SendFGCommandError& rhs) const {
    return ! (*this == rhs);
}

inline bool SendFGCommandError::operator < (const SendFGCommandError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool SendFGCommandError::operator > (const SendFGCommandError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline SendFGCommandError::SendFGCommandErrorField SendFGCommandError::getField () const {
    return __field;
}

inline void SendFGCommandError::setField(SendFGCommandError::SendFGCommandErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* SendFGCommandError::clone() {
    return new SendFGCommandError(*this);
}

inline bool SendFGCommandError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const SendFGCommandErrorStructure& SendFGCommandError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "SendFGCommandError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return SendFGCommandErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline SendFGCommandErrorStructure& SendFGCommandError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "SendFGCommandError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new SendFGCommandErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline SendFGCommandErrorStructure* SendFGCommandError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'SendFGCommandError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new SendFGCommandErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        SendFGCommandErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void SendFGCommandError::replaceCcaErrorCode (SendFGCommandErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void SendFGCommandError::setCcaErrorCode (const SendFGCommandErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new SendFGCommandErrorStructure(value);
    }
}

inline bool SendFGCommandError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode SendFGCommandError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "SendFGCommandError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void SendFGCommandError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "SendFGCommandError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void SendFGCommandError::cloneData (const SendFGCommandError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new SendFGCommandErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new SendFGCommandErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void SendFGCommandError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

} // namespace midw_streamrouter_fi

#endif // MIDW_STREAMROUTER_FI_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
