/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_AI_INTERCOMAUDIOSERVICESTUB_H
#define BOSCH_CM_AI_INTERCOMAUDIOSERVICESTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/ai/IntercomAudioService.h"

namespace bosch {
namespace cm {
namespace ai {
namespace IntercomAudioService {

class IntercomAudioServiceStubDelegate;

class IntercomAudioServiceStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the IntercomAudioServiceStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    IntercomAudioServiceStub (const std::string& portName);

    /**
     * Create an instance of the IntercomAudioServiceStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    IntercomAudioServiceStub (const std::string& portName, const std::string& objectPath);

    virtual ~IntercomAudioServiceStub();

    // signal 'incomingCall'

    /**
     * Raise the signal 'incomingCall' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'incomingCall'</b>:
     *
     * Phone No : 0 - Mic1, 1 - Rest Room  , 2 - Kitchen , 3 - Upper Deck
     *
     * @param phoneNo If the meaning of "phoneNo" isn't clear, then there should be a description here.
     */
    void sendIncomingCallSignal(int32 phoneNo);

    // signal 'cancelCall'

    /**
     * Raise the signal 'cancelCall' and send an update message to registered
     * clients.
     *
     * <b>Documentation of 'cancelCall'</b>:
     *
     * This Event will be generated when call is cancelled from Intercom Phone
     */
    void sendCancelCallSignal();

    // signal 'activeCallStatus'

    /**
     * Raise the signal 'activeCallStatus' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'activeCallStatus'</b>:
     *
     * This activeCallStatus will be sent when user picks up the phone
     */
    void sendActiveCallStatusSignal();

    // signal 'IntercomServiceAvailability'

    /**
     * Raise the signal 'IntercomServiceAvailability' and send an update
     * message to registered clients.
     *
     * <b>Documentation of 'IntercomServiceAvailability'</b>:
     *
     * This message is inteded to notify HMI about intercom service availability
     */
    void sendIntercomServiceAvailabilitySignal();

    // signal 'RspPhoneStatus'

    /**
     * Raise the signal 'RspPhoneStatus' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'RspPhoneStatus'</b>:
     *
     * BitSet of each PhoneStatus
     * 0th bit -- Disabled ( set ) / enabled  (reset  )
     * 1st bit -- Disconnected ( set ) / connected ( reset )
     * 2nd bit -- onHook ( set ) / Pickup   ( reset )
     * 3rd bit -- Ringing ( set ) / Not Ringing ( reset )
     *
     * @param RestRoomPhoneStatus RestRoom PhoneStatus
     *
     * @param KitchenPhoneStatus Kitchen PhoneStatus
     *
     * @param UpperDeckPhoneStatus UpperDeck PhoneStatus
     */
    void sendRspPhoneStatusSignal(uint8 restRoomPhoneStatus, uint8 kitchenPhoneStatus, uint8 upperDeckPhoneStatus);

    // signal 'EventPhoneStatusChanged'

    /**
     * Raise the signal 'EventPhoneStatusChanged' and send an update message
     * to registered clients.
     *
     * <b>Documentation of 'EventPhoneStatusChanged'</b>:
     *
     * If the meaning of "EventPhoneStatusChanged" isn't clear, then there should be a description here.
     *
     * @param PhoneStatus BitSet of each PhoneStatus
     * 0th bit -- Disabled ( set ) / enabled  (reset  )
     * 1st bit -- Disconnected ( set ) / connected ( reset )
     * 2nd bit -- onHook ( set ) / Pickup   ( reset )
     * 3rd bit -- Ringing ( set ) / Not Ringing ( reset )
     *
     * @param PhoneNumber Phone No : 0 - Mic1, 1 - Rest Room  , 2 - Kitchen , 3 - Upper Deck
     */
    void sendEventPhoneStatusChangedSignal(uint8 phoneStatus, uint8 phoneNumber);

    // signal 'EventNanoMessageErrorStatus'

    /**
     * Raise the signal 'EventNanoMessageErrorStatus' and send an update
     * message to registered clients.
     *
     * <b>Documentation of 'EventNanoMessageErrorStatus'</b>:
     *
     * If the meaning of "EventNanoMessageErrorStatus" isn't clear, then there should be a description here.
     *
     * @param ErrorCodes NanoMessage Error Codes are below
     * 0 - No Error
     * 1 - NANOMESSAGE COMMUNICATION ERROR
     * 2 - NANOMESSAGE SENDMESSAGE ERROR
     * 3 - NANOMESSAGE RECEIVEMESSAGE ERROR
     * 4 - NANOMESSAGE UNAVAILABLE ERROR
     * 5 - NANOMESSAGE COMMUNICATION LOST ERROR
     */
    void sendEventNanoMessageErrorStatusSignal(uint8 errorCodes);

    // signal 'EventRTPErrorStatus'

    /**
     * Raise the signal 'EventRTPErrorStatus' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'EventRTPErrorStatus'</b>:
     *
     * If the meaning of "EventRTPErrorStatus" isn't clear, then there should be a description here.
     *
     * @param ErrorCodes RTP Error Codes are below
     * 0 - No Error
     * 1 - RTP FACTORY FAILURE ERROR
     * 2 - RTP MAINLOOP FAILURE ERROR
     * 3 - RTP RECEIVE PLAYBACK FAILURE ERROR
     * 4 - RTP SEND PLAYBACK FAILURE ERROR
     * 5 - RTP THREAD FAILURE ERROR
     * 6 - RTP CLEAR PIPELINE ERROR
     * 7 - RTP  SEND PIPELINE PAUSED ERROR
     * 8 - RTP  RECEIVE PIPELINE PAUSED ERROR
     * 9 - RTP  SEND PIPELINE BUFFER ERROR
     * 10 - RTP  RECEIVE PIPELINE BUFFER ERROR
     * 11 - RTP  SEND PIPELINE EOS ERROR
     * 12 - RTP  RECEIVE PIPELINE EOS ERROR
     * 13 - RTP  SEND PIPELINE HOST NOT FOUND ERROR
     * 14 - RTP  RECEIVE  PIPELINE HOST NOT FOUND ERROR
     * 15 - RTP  SEND  PIPELINE ELEMENT LINK ERROR
     * 16 - RTP  RECEIVE  PIPELINE ELEMENT LINK ERROR
     * 17 - RTP  SEND  PIPELINE PARSE ERROR
     * 18 - RTP  RECEIVE  PIPELINE PARSE ERROR
     * 19 - RTP  SEND  PIPELINE STATE CHANGE ERROR
     * 20 - RTP  RECEIVE  PIPELINE STATE CHANGE ERROR
     */
    void sendEventRTPErrorStatusSignal(uint8 errorCodes);

    // signal 'EventInterComConfigError'

    /**
     * Raise the signal 'EventInterComConfigError' and send an update message
     * to registered clients.
     *
     * <b>Documentation of 'EventInterComConfigError'</b>:
     *
     * If the meaning of "EventInterComConfigError" isn't clear, then there should be a description here.
     *
     * @param ErrorCodes Intercom Config Error Codes are below
     * 0 - No Error
     * 1 - INTERCOM CONFIG OSAL REGISTRY READ ERROR
     * 2 - INTERCOM CONFIG OSAL REGISTRY PARSE ERROR
     * 3 - INTERCOM CONFIG AVROUTING ADAPTER PARSE ERROR
     * 4 - INTERCOM CONFIG AVROUTING ADAPTER CMA IP NOT FOUND ERROR
     * 5 - INTERCOM CONFIG CCA APP REGISTRATION ERROR
     * 6 - INTERCOM CONFIG AHL APP CREATION ERROR
     * 7 - INTERCOM CONFIG OSAL THREAD FAILURE ERROR
     */
    void sendEventInterComConfigErrorSignal(uint8 errorCodes);

    // signal 'EventAudioAllocationStatus'

    /**
     * Raise the signal 'EventAudioAllocationStatus' and send an update
     * message to registered clients.
     *
     * <b>Documentation of 'EventAudioAllocationStatus'</b>:
     *
     * If the meaning of "EventAudioAllocationStatus" isn't clear, then there should be a description here.
     *
     * @param AllocationStatus 0 - Audio Allocation OFF , 1 - Audio Allocation ON
     */
    void sendEventAudioAllocationStatusSignal(uint8 allocationStatus);

    // signal 'EventIntercomAvailable'

    /**
     * Raise the signal 'EventIntercomAvailable' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'EventIntercomAvailable'</b>:
     *
     * If the meaning of "EventIntercomAvailable" isn't clear, then there should be a description here.
     *
     * @param Available 0 - Intercom Unavailable , 1 - Intercom Available
     */
    void sendEventIntercomAvailableSignal(uint8 available);

    // signal 'RspIntercomAvailable'

    /**
     * Raise the signal 'RspIntercomAvailable' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'RspIntercomAvailable'</b>:
     *
     * If the meaning of "RspIntercomAvailable" isn't clear, then there should be a description here.
     *
     * @param Available 0 - Intercom Unavailable , 1 - Intercom Available
     */
    void sendRspIntercomAvailableSignal(uint8 available);

    // method 'outgoingCall'

    /**
     * The method onOutgoingCall() is called by ASF when a client invokes the
     * method 'outgoingCall'. A subclass has to implement this method and send
     * back a response to the client either with the sendOutgoingCall() or
     * sendOutgoingCallError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'outgoingCall'</b>:
     *
     * Phone No : 0 - Mic1, 1 - Rest Room  , 2 - Kitchen , 3 - Upper Deck
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onOutgoingCallRequest (const ::boost::shared_ptr< OutgoingCallRequest >& request) = 0;

    /**
     * The method sendOutgoingCallResponse() sends a response of a previous
     * method invocation of 'outgoingCall' back to the client.
     *
     * <b>Documentation of 'outgoingCall'</b>:
     *
     * Phone No : 0 - Mic1, 1 - Rest Room  , 2 - Kitchen , 3 - Upper Deck
     *
     * @param act The parameter act identifies a previous invocation of
     * onOutgoingCall(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendOutgoingCallResponse (act_t act = 0);

    /**
     * The method sendOutgoingCallError() sends an error response of a
     * previous method invocation of 'outgoingCall' back to the client.
     *
     * <b>Documentation of 'outgoingCall'</b>:
     *
     * Phone No : 0 - Mic1, 1 - Rest Room  , 2 - Kitchen , 3 - Upper Deck
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onOutgoingCall(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendOutgoingCallError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'getPhoneStatus'

    /**
     * The method onGetPhoneStatus() is called by ASF when a client invokes
     * the method 'getPhoneStatus'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendGetPhoneStatus() or sendGetPhoneStatusError() method. Do not invoke
     * this method on your own.
     *
     * <b>Documentation of 'getPhoneStatus'</b>:
     *
     * Method to request PhoneStatus
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetPhoneStatusRequest (const ::boost::shared_ptr< GetPhoneStatusRequest >& request) = 0;

    /**
     * The method sendGetPhoneStatusResponse() sends a response of a previous
     * method invocation of 'getPhoneStatus' back to the client.
     *
     * <b>Documentation of 'getPhoneStatus'</b>:
     *
     * Method to request PhoneStatus
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetPhoneStatus(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendGetPhoneStatusResponse (act_t act = 0);

    /**
     * The method sendGetPhoneStatusError() sends an error response of a
     * previous method invocation of 'getPhoneStatus' back to the client.
     *
     * <b>Documentation of 'getPhoneStatus'</b>:
     *
     * Method to request PhoneStatus
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGetPhoneStatus(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendGetPhoneStatusError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'CallAction'

    /**
     * The method onCallAction() is called by ASF when a client invokes the
     * method 'CallAction'. A subclass has to implement this method and send
     * back a response to the client either with the sendCallAction() or
     * sendCallActionError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'CallAction'</b>:
     *
     * Action : 1 - Accept , 2 - reject
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onCallActionRequest (const ::boost::shared_ptr< CallActionRequest >& request) = 0;

    /**
     * The method sendCallActionResponse() sends a response of a previous
     * method invocation of 'CallAction' back to the client.
     *
     * <b>Documentation of 'CallAction'</b>:
     *
     * Action : 1 - Accept , 2 - reject
     *
     * @param act The parameter act identifies a previous invocation of
     * onCallAction(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendCallActionResponse (act_t act = 0);

    /**
     * The method sendCallActionError() sends an error response of a previous
     * method invocation of 'CallAction' back to the client.
     *
     * <b>Documentation of 'CallAction'</b>:
     *
     * Action : 1 - Accept , 2 - reject
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onCallAction(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendCallActionError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'getAvailability'

    /**
     * The method onGetAvailability() is called by ASF when a client invokes
     * the method 'getAvailability'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendGetAvailability() or sendGetAvailabilityError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'getAvailability'</b>:
     *
     * get Intercom Availability Status
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetAvailabilityRequest (const ::boost::shared_ptr< GetAvailabilityRequest >& request) = 0;

    /**
     * The method sendGetAvailabilityResponse() sends a response of a previous
     * method invocation of 'getAvailability' back to the client.
     *
     * <b>Documentation of 'getAvailability'</b>:
     *
     * get Intercom Availability Status
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetAvailability(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendGetAvailabilityResponse (act_t act = 0);

    /**
     * The method sendGetAvailabilityError() sends an error response of a
     * previous method invocation of 'getAvailability' back to the client.
     *
     * <b>Documentation of 'getAvailability'</b>:
     *
     * get Intercom Availability Status
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGetAvailability(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendGetAvailabilityError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    friend class IntercomAudioServiceStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace IntercomAudioService
} // namespace ai
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_AI_INTERCOMAUDIOSERVICESTUB_H
