/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/ai/IntercomAudioService.h"
#include "bosch/cm/ai/IntercomAudioServiceDBus.h"
#include "bosch/cm/ai/IntercomAudioServiceJson.h"
#include "bosch/cm/ai/IntercomAudioServiceStub.h"

#include "asf/dbus/DBusMessage.h"

namespace bosch {
namespace cm {
namespace ai {
namespace IntercomAudioService {

DEFINE_CLASS_LOGGER("/bosch/cm/ai/IntercomAudioService", IntercomAudioServiceStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 10, "CallAction", 2 },
    { 12, "outgoingCall", 0 },
    { 14, "getPhoneStatus", 1 },
    { 15, "getAvailability", 3 },
};


class IntercomAudioServiceStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    IntercomAudioServiceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    IntercomAudioServiceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    IntercomAudioServiceStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "bosch.cm.ai.IntercomAudioService"),
          _logger(logger) {}

    virtual ~IntercomAudioServiceStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void IntercomAudioServiceStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 4, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'outgoingCall'

            LOG_DEBUG_STUB("process method '%s'", "outgoingCall");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), OutgoingCallRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "OutgoingCall", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< OutgoingCallRequest > payload = ::boost::static_pointer_cast<OutgoingCallRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<IntercomAudioServiceStub*>(getStub())->onOutgoingCallRequest(payload);
            return;
        }
        case 1: {

            // method 'getPhoneStatus'

            LOG_DEBUG_STUB("process method '%s'", "getPhoneStatus");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetPhoneStatusRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetPhoneStatus", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetPhoneStatusRequest > payload = ::boost::static_pointer_cast<GetPhoneStatusRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<IntercomAudioServiceStub*>(getStub())->onGetPhoneStatusRequest(payload);
            return;
        }
        case 2: {

            // method 'CallAction'

            LOG_DEBUG_STUB("process method '%s'", "CallAction");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CallActionRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "CallAction", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< CallActionRequest > payload = ::boost::static_pointer_cast<CallActionRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<IntercomAudioServiceStub*>(getStub())->onCallActionRequest(payload);
            return;
        }
        case 3: {

            // method 'getAvailability'

            LOG_DEBUG_STUB("process method '%s'", "getAvailability");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetAvailabilityRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetAvailability", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetAvailabilityRequest > payload = ::boost::static_pointer_cast<GetAvailabilityRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<IntercomAudioServiceStub*>(getStub())->onGetAvailabilityRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* IntercomAudioServiceStubDelegate::introspect() const {
    return     "<interface name=\"bosch.cm.ai.IntercomAudioService\">\n"
            "      <method name=\"outgoingCall\">\n"
            "        <doc>\n"
            "          <line>Phone No : 0 - Mic1, 1 - Rest Room  , 2 - Kitchen , 3 - Upper Deck</line>\n"
            "        </doc>\n"
            "        <arg direction=\"in\" name=\"phoneNo\" type=\"i\"/>\n"
            "      </method>\n"
            "      <method name=\"getPhoneStatus\">\n"
            "        <doc>\n"
            "          <line>Method to request PhoneStatus </line>\n"
            "        </doc>\n"
            "      </method>\n"
            "      <method name=\"CallAction\">\n"
            "        <doc>\n"
            "          <line>Action : 1 - Accept , 2 - reject </line>\n"
            "        </doc>\n"
            "        <arg direction=\"in\" name=\"Action\" type=\"i\"/>\n"
            "      </method>\n"
            "      <method name=\"getAvailability\">\n"
            "        <doc>\n"
            "          <line>get Intercom Availability Status </line>\n"
            "        </doc>\n"
            "      </method>\n"
            "      <signal name=\"incomingCall\">\n"
            "        <doc>\n"
            "          <line>Phone No : 0 - Mic1, 1 - Rest Room  , 2 - Kitchen , 3 - Upper Deck </line>\n"
            "        </doc>\n"
            "        <arg direction=\"out\" name=\"phoneNo\" type=\"i\"/>\n"
            "      </signal>\n"
            "      <signal name=\"cancelCall\">\n"
            "        <doc>\n"
            "          <line> This Event will be generated when call is cancelled from Intercom Phone </line>\n"
            "        </doc>\n"
            "      </signal>\n"
            "      <signal name=\"activeCallStatus\">\n"
            "        <doc>\n"
            "          <line> This activeCallStatus will be sent when user picks up the phone </line>\n"
            "        </doc>\n"
            "      </signal>\n"
            "      <signal name=\"IntercomServiceAvailability\">\n"
            "        <doc>\n"
            "          <line> This message is inteded to notify HMI about intercom service availability </line>\n"
            "        </doc>\n"
            "      </signal>\n"
            "      <signal name=\"RspPhoneStatus\">\n"
            "        <doc>\n"
            "          <line>  BitSet of each PhoneStatus                                  </line>\n"
            "          <line> 0th bit -- Disabled ( set ) / enabled  (reset  )             </line>\n"
            "          <line> 1st bit -- Disconnected ( set ) / connected ( reset )         </line>\n"
            "          <line> 2nd bit -- onHook ( set ) / Pickup   ( reset )                </line>\n"
            "          <line> 3rd bit -- Ringing ( set ) / Not Ringing ( reset )            </line>\n"
            "        </doc>\n"
            "        <arg direction=\"out\" name=\"RestRoomPhoneStatus\" type=\"y\">\n"
            "          <doc>\n"
            "            <line>RestRoom PhoneStatus</line>\n"
            "          </doc>\n"
            "        </arg>\n"
            "        <arg direction=\"out\" name=\"KitchenPhoneStatus\" type=\"y\">\n"
            "          <doc>\n"
            "            <line>Kitchen PhoneStatus</line>\n"
            "          </doc>\n"
            "        </arg>\n"
            "        <arg direction=\"out\" name=\"UpperDeckPhoneStatus\" type=\"y\">\n"
            "          <doc>\n"
            "            <line>UpperDeck PhoneStatus </line>\n"
            "          </doc>\n"
            "        </arg>\n"
            "      </signal>\n"
            "      <signal name=\"EventPhoneStatusChanged\">\n"
            "        <arg direction=\"out\" name=\"PhoneStatus\" type=\"y\">\n"
            "          <doc>\n"
            "            <line>  BitSet of each PhoneStatus                                  </line>\n"
            "            <line> 0th bit -- Disabled ( set ) / enabled  (reset  )             </line>\n"
            "            <line> 1st bit -- Disconnected ( set ) / connected ( reset )         </line>\n"
            "            <line> 2nd bit -- onHook ( set ) / Pickup   ( reset )                </line>\n"
            "            <line> 3rd bit -- Ringing ( set ) / Not Ringing ( reset )            </line>\n"
            "          </doc>\n"
            "        </arg>\n"
            "        <arg direction=\"out\" name=\"PhoneNumber\" type=\"y\">\n"
            "          <doc>\n"
            "            <line>Phone No : 0 - Mic1, 1 - Rest Room  , 2 - Kitchen , 3 - Upper Deck </line>\n"
            "          </doc>\n"
            "        </arg>\n"
            "      </signal>\n"
            "      <signal name=\"EventNanoMessageErrorStatus\">\n"
            "        <arg direction=\"out\" name=\"ErrorCodes\" type=\"y\">\n"
            "          <doc>\n"
            "            <line>  NanoMessage Error Codes are below                        </line>\n"
            "            <line>  0 - No Error                                             </line>\n"
            "            <line>  1 - NANOMESSAGE COMMUNICATION ERROR                      </line>\n"
            "            <line>  2 - NANOMESSAGE SENDMESSAGE ERROR                        </line>\n"
            "            <line>  3 - NANOMESSAGE RECEIVEMESSAGE ERROR                     </line>\n"
            "            <line>  4 - NANOMESSAGE UNAVAILABLE ERROR                        </line>\n"
            "            <line>  5 - NANOMESSAGE COMMUNICATION LOST ERROR                 </line>\n"
            "          </doc>\n"
            "        </arg>\n"
            "      </signal>\n"
            "      <signal name=\"EventRTPErrorStatus\">\n"
            "        <arg direction=\"out\" name=\"ErrorCodes\" type=\"y\">\n"
            "          <doc>\n"
            "            <line>  RTP Error Codes are below                                   </line>\n"
            "            <line>  0 - No Error                                                </line>\n"
            "            <line>  1 - RTP FACTORY FAILURE ERROR                               </line>\n"
            "            <line>  2 - RTP MAINLOOP FAILURE ERROR                              </line>\n"
            "            <line>  3 - RTP RECEIVE PLAYBACK FAILURE ERROR                      </line>\n"
            "            <line>  4 - RTP SEND PLAYBACK FAILURE ERROR                         </line>\n"
            "            <line>  5 - RTP THREAD FAILURE ERROR                                </line>\n"
            "            <line>  6 - RTP CLEAR PIPELINE ERROR                                </line>\n"
            "            <line>  7 - RTP  SEND PIPELINE PAUSED ERROR                         </line>\n"
            "            <line>  8 - RTP  RECEIVE PIPELINE PAUSED ERROR                      </line>\n"
            "            <line>  9 - RTP  SEND PIPELINE BUFFER ERROR                         </line>\n"
            "            <line>  10 - RTP  RECEIVE PIPELINE BUFFER ERROR                     </line>\n"
            "            <line>  11 - RTP  SEND PIPELINE EOS ERROR                           </line>\n"
            "            <line>  12 - RTP  RECEIVE PIPELINE EOS ERROR                        </line>\n"
            "            <line>  13 - RTP  SEND PIPELINE HOST NOT FOUND ERROR                </line>\n"
            "            <line>  14 - RTP  RECEIVE  PIPELINE HOST NOT FOUND ERROR            </line>\n"
            "            <line>  15 - RTP  SEND  PIPELINE ELEMENT LINK ERROR                 </line>\n"
            "            <line>  16 - RTP  RECEIVE  PIPELINE ELEMENT LINK ERROR              </line>\n"
            "            <line>  17 - RTP  SEND  PIPELINE PARSE ERROR                        </line>\n"
            "            <line>  18 - RTP  RECEIVE  PIPELINE PARSE ERROR                     </line>\n"
            "            <line>  19 - RTP  SEND  PIPELINE STATE CHANGE ERROR                 </line>\n"
            "            <line>  20 - RTP  RECEIVE  PIPELINE STATE CHANGE ERROR              </line>\n"
            "          </doc>\n"
            "        </arg>\n"
            "      </signal>\n"
            "      <signal name=\"EventInterComConfigError\">\n"
            "        <arg direction=\"out\" name=\"ErrorCodes\" type=\"y\">\n"
            "          <doc>\n"
            "            <line>  Intercom Config Error Codes are below                                   </line>\n"
            "            <line>  0 - No Error                                                            </line>\n"
            "            <line>  1 - INTERCOM CONFIG OSAL REGISTRY READ ERROR                             </line>\n"
            "            <line>  2 - INTERCOM CONFIG OSAL REGISTRY PARSE ERROR                            </line>\n"
            "            <line>  3 - INTERCOM CONFIG AVROUTING ADAPTER PARSE ERROR                        </line>\n"
            "            <line>  4 - INTERCOM CONFIG AVROUTING ADAPTER CMA IP NOT FOUND ERROR             </line>\n"
            "            <line>  5 - INTERCOM CONFIG CCA APP REGISTRATION ERROR                           </line>\n"
            "            <line>  6 - INTERCOM CONFIG AHL APP CREATION ERROR                               </line>\n"
            "            <line>  7 - INTERCOM CONFIG OSAL THREAD FAILURE ERROR                            </line>\n"
            "          </doc>\n"
            "        </arg>\n"
            "      </signal>\n"
            "      <signal name=\"EventAudioAllocationStatus\">\n"
            "        <arg direction=\"out\" name=\"AllocationStatus\" type=\"y\">\n"
            "          <doc>\n"
            "            <line>0 - Audio Allocation OFF , 1 - Audio Allocation ON </line>\n"
            "          </doc>\n"
            "        </arg>\n"
            "      </signal>\n"
            "      <signal name=\"EventIntercomAvailable\">\n"
            "        <arg direction=\"out\" name=\"Available\" type=\"y\">\n"
            "          <doc>\n"
            "            <line>0 - Intercom Unavailable , 1 - Intercom Available </line>\n"
            "          </doc>\n"
            "        </arg>\n"
            "      </signal>\n"
            "      <signal name=\"RspIntercomAvailable\">\n"
            "        <arg direction=\"out\" name=\"Available\" type=\"y\">\n"
            "          <doc>\n"
            "            <line>0 - Intercom Unavailable , 1 - Intercom Available </line>\n"
            "          </doc>\n"
            "        </arg>\n"
            "      </signal>\n"
            "</interface>\n";
}

void IntercomAudioServiceStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<IntercomAudioServiceStub*>(getStub()))->onGetAll (properties);
}

void IntercomAudioServiceStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void IntercomAudioServiceStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

IntercomAudioServiceStub::IntercomAudioServiceStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new IntercomAudioServiceStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

IntercomAudioServiceStub::IntercomAudioServiceStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new IntercomAudioServiceStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

IntercomAudioServiceStub::~IntercomAudioServiceStub() {
    delete _stubDelegate;
}

void IntercomAudioServiceStub::sendIncomingCallSignal(int32 phoneNo) {
    if (_stubDelegate->isConnected()) {
        IncomingCallSignal* payload = new IncomingCallSignal(phoneNo);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "incomingCall", IncomingCallSignal, payload)
        LOG_INFO ("-> send%sSignal", "IncomingCall");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "IncomingCall");
    }
}

void IntercomAudioServiceStub::sendCancelCallSignal() {
    if (_stubDelegate->isConnected()) {
        CancelCallSignal* payload = new CancelCallSignal;
        DBUS_MESSAGE_SIGNAL(dbusMessage, "cancelCall", CancelCallSignal, payload)
        LOG_INFO ("-> send%sSignal", "CancelCall");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "CancelCall");
    }
}

void IntercomAudioServiceStub::sendActiveCallStatusSignal() {
    if (_stubDelegate->isConnected()) {
        ActiveCallStatusSignal* payload = new ActiveCallStatusSignal;
        DBUS_MESSAGE_SIGNAL(dbusMessage, "activeCallStatus", ActiveCallStatusSignal, payload)
        LOG_INFO ("-> send%sSignal", "ActiveCallStatus");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "ActiveCallStatus");
    }
}

void IntercomAudioServiceStub::sendIntercomServiceAvailabilitySignal() {
    if (_stubDelegate->isConnected()) {
        IntercomServiceAvailabilitySignal* payload = new IntercomServiceAvailabilitySignal;
        DBUS_MESSAGE_SIGNAL(dbusMessage, "IntercomServiceAvailability", IntercomServiceAvailabilitySignal, payload)
        LOG_INFO ("-> send%sSignal", "IntercomServiceAvailability");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "IntercomServiceAvailability");
    }
}

void IntercomAudioServiceStub::sendRspPhoneStatusSignal(uint8 restRoomPhoneStatus, uint8 kitchenPhoneStatus, uint8 upperDeckPhoneStatus) {
    if (_stubDelegate->isConnected()) {
        RspPhoneStatusSignal* payload = new RspPhoneStatusSignal(restRoomPhoneStatus, kitchenPhoneStatus, upperDeckPhoneStatus);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "RspPhoneStatus", RspPhoneStatusSignal, payload)
        LOG_INFO ("-> send%sSignal", "RspPhoneStatus");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "RspPhoneStatus");
    }
}

void IntercomAudioServiceStub::sendEventPhoneStatusChangedSignal(uint8 phoneStatus, uint8 phoneNumber) {
    if (_stubDelegate->isConnected()) {
        EventPhoneStatusChangedSignal* payload = new EventPhoneStatusChangedSignal(phoneStatus, phoneNumber);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "EventPhoneStatusChanged", EventPhoneStatusChangedSignal, payload)
        LOG_INFO ("-> send%sSignal", "EventPhoneStatusChanged");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "EventPhoneStatusChanged");
    }
}

void IntercomAudioServiceStub::sendEventNanoMessageErrorStatusSignal(uint8 errorCodes) {
    if (_stubDelegate->isConnected()) {
        EventNanoMessageErrorStatusSignal* payload = new EventNanoMessageErrorStatusSignal(errorCodes);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "EventNanoMessageErrorStatus", EventNanoMessageErrorStatusSignal, payload)
        LOG_INFO ("-> send%sSignal", "EventNanoMessageErrorStatus");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "EventNanoMessageErrorStatus");
    }
}

void IntercomAudioServiceStub::sendEventRTPErrorStatusSignal(uint8 errorCodes) {
    if (_stubDelegate->isConnected()) {
        EventRTPErrorStatusSignal* payload = new EventRTPErrorStatusSignal(errorCodes);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "EventRTPErrorStatus", EventRTPErrorStatusSignal, payload)
        LOG_INFO ("-> send%sSignal", "EventRTPErrorStatus");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "EventRTPErrorStatus");
    }
}

void IntercomAudioServiceStub::sendEventInterComConfigErrorSignal(uint8 errorCodes) {
    if (_stubDelegate->isConnected()) {
        EventInterComConfigErrorSignal* payload = new EventInterComConfigErrorSignal(errorCodes);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "EventInterComConfigError", EventInterComConfigErrorSignal, payload)
        LOG_INFO ("-> send%sSignal", "EventInterComConfigError");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "EventInterComConfigError");
    }
}

void IntercomAudioServiceStub::sendEventAudioAllocationStatusSignal(uint8 allocationStatus) {
    if (_stubDelegate->isConnected()) {
        EventAudioAllocationStatusSignal* payload = new EventAudioAllocationStatusSignal(allocationStatus);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "EventAudioAllocationStatus", EventAudioAllocationStatusSignal, payload)
        LOG_INFO ("-> send%sSignal", "EventAudioAllocationStatus");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "EventAudioAllocationStatus");
    }
}

void IntercomAudioServiceStub::sendEventIntercomAvailableSignal(uint8 available) {
    if (_stubDelegate->isConnected()) {
        EventIntercomAvailableSignal* payload = new EventIntercomAvailableSignal(available);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "EventIntercomAvailable", EventIntercomAvailableSignal, payload)
        LOG_INFO ("-> send%sSignal", "EventIntercomAvailable");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "EventIntercomAvailable");
    }
}

void IntercomAudioServiceStub::sendRspIntercomAvailableSignal(uint8 available) {
    if (_stubDelegate->isConnected()) {
        RspIntercomAvailableSignal* payload = new RspIntercomAvailableSignal(available);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "RspIntercomAvailable", RspIntercomAvailableSignal, payload)
        LOG_INFO ("-> send%sSignal", "RspIntercomAvailable");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "RspIntercomAvailable");
    }
}

void  IntercomAudioServiceStub::sendOutgoingCallResponse (act_t act) {
    OutgoingCallResponse* payload = new OutgoingCallResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "outgoingCall", OutgoingCallResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "OutgoingCall", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  IntercomAudioServiceStub::sendOutgoingCallError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    OutgoingCallError* payload = new OutgoingCallError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "outgoingCall", OutgoingCallError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "OutgoingCall", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  IntercomAudioServiceStub::sendGetPhoneStatusResponse (act_t act) {
    GetPhoneStatusResponse* payload = new GetPhoneStatusResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "getPhoneStatus", GetPhoneStatusResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetPhoneStatus", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  IntercomAudioServiceStub::sendGetPhoneStatusError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetPhoneStatusError* payload = new GetPhoneStatusError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "getPhoneStatus", GetPhoneStatusError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetPhoneStatus", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  IntercomAudioServiceStub::sendCallActionResponse (act_t act) {
    CallActionResponse* payload = new CallActionResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "CallAction", CallActionResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "CallAction", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  IntercomAudioServiceStub::sendCallActionError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    CallActionError* payload = new CallActionError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "CallAction", CallActionError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "CallAction", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  IntercomAudioServiceStub::sendGetAvailabilityResponse (act_t act) {
    GetAvailabilityResponse* payload = new GetAvailabilityResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "getAvailability", GetAvailabilityResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetAvailability", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  IntercomAudioServiceStub::sendGetAvailabilityError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetAvailabilityError* payload = new GetAvailabilityError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "getAvailability", GetAvailabilityError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetAvailability", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void IntercomAudioServiceStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace IntercomAudioService
} // namespace ai
} // namespace cm
} // namespace bosch
