/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_AI_INTERCOMAUDIOSERVICEPROXY_H
#define BOSCH_CM_AI_INTERCOMAUDIOSERVICEPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/ai/IntercomAudioService.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include <dbus/dbus.h>

namespace bosch {
namespace cm {
namespace ai {
namespace IntercomAudioService {

class IntercomAudioServiceProxy;

class ActiveCallStatusCallbackIF {
public:
    virtual ~ActiveCallStatusCallbackIF() {}

    virtual void onActiveCallStatusError(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< ActiveCallStatusError >& error) = 0;

    virtual void onActiveCallStatusSignal(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< ActiveCallStatusSignal >& signal) = 0;
};

class CallActionCallbackIF {
public:
    virtual ~CallActionCallbackIF() {}

    virtual void onCallActionError(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< CallActionError >& error) = 0;

    virtual void onCallActionResponse(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< CallActionResponse >& response) = 0;
};

class CancelCallCallbackIF {
public:
    virtual ~CancelCallCallbackIF() {}

    virtual void onCancelCallError(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< CancelCallError >& error) = 0;

    virtual void onCancelCallSignal(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< CancelCallSignal >& signal) = 0;
};

class EventAudioAllocationStatusCallbackIF {
public:
    virtual ~EventAudioAllocationStatusCallbackIF() {}

    virtual void onEventAudioAllocationStatusError(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< EventAudioAllocationStatusError >& error) = 0;

    virtual void onEventAudioAllocationStatusSignal(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< EventAudioAllocationStatusSignal >& signal) = 0;
};

class EventInterComConfigErrorCallbackIF {
public:
    virtual ~EventInterComConfigErrorCallbackIF() {}

    virtual void onEventInterComConfigErrorError(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< EventInterComConfigErrorError >& error) = 0;

    virtual void onEventInterComConfigErrorSignal(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< EventInterComConfigErrorSignal >& signal) = 0;
};

class EventIntercomAvailableCallbackIF {
public:
    virtual ~EventIntercomAvailableCallbackIF() {}

    virtual void onEventIntercomAvailableError(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< EventIntercomAvailableError >& error) = 0;

    virtual void onEventIntercomAvailableSignal(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< EventIntercomAvailableSignal >& signal) = 0;
};

class EventNanoMessageErrorStatusCallbackIF {
public:
    virtual ~EventNanoMessageErrorStatusCallbackIF() {}

    virtual void onEventNanoMessageErrorStatusError(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< EventNanoMessageErrorStatusError >& error) = 0;

    virtual void onEventNanoMessageErrorStatusSignal(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< EventNanoMessageErrorStatusSignal >& signal) = 0;
};

class EventPhoneStatusChangedCallbackIF {
public:
    virtual ~EventPhoneStatusChangedCallbackIF() {}

    virtual void onEventPhoneStatusChangedError(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< EventPhoneStatusChangedError >& error) = 0;

    virtual void onEventPhoneStatusChangedSignal(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< EventPhoneStatusChangedSignal >& signal) = 0;
};

class EventRTPErrorStatusCallbackIF {
public:
    virtual ~EventRTPErrorStatusCallbackIF() {}

    virtual void onEventRTPErrorStatusError(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< EventRTPErrorStatusError >& error) = 0;

    virtual void onEventRTPErrorStatusSignal(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< EventRTPErrorStatusSignal >& signal) = 0;
};

class GetAvailabilityCallbackIF {
public:
    virtual ~GetAvailabilityCallbackIF() {}

    virtual void onGetAvailabilityError(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< GetAvailabilityError >& error) = 0;

    virtual void onGetAvailabilityResponse(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< GetAvailabilityResponse >& response) = 0;
};

class GetPhoneStatusCallbackIF {
public:
    virtual ~GetPhoneStatusCallbackIF() {}

    virtual void onGetPhoneStatusError(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< GetPhoneStatusError >& error) = 0;

    virtual void onGetPhoneStatusResponse(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< GetPhoneStatusResponse >& response) = 0;
};

class IncomingCallCallbackIF {
public:
    virtual ~IncomingCallCallbackIF() {}

    virtual void onIncomingCallError(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< IncomingCallError >& error) = 0;

    virtual void onIncomingCallSignal(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< IncomingCallSignal >& signal) = 0;
};

class IntercomServiceAvailabilityCallbackIF {
public:
    virtual ~IntercomServiceAvailabilityCallbackIF() {}

    virtual void onIntercomServiceAvailabilityError(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< IntercomServiceAvailabilityError >& error) = 0;

    virtual void onIntercomServiceAvailabilitySignal(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< IntercomServiceAvailabilitySignal >& signal) = 0;
};

class OutgoingCallCallbackIF {
public:
    virtual ~OutgoingCallCallbackIF() {}

    virtual void onOutgoingCallError(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< OutgoingCallError >& error) = 0;

    virtual void onOutgoingCallResponse(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< OutgoingCallResponse >& response) = 0;
};

class RspIntercomAvailableCallbackIF {
public:
    virtual ~RspIntercomAvailableCallbackIF() {}

    virtual void onRspIntercomAvailableError(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< RspIntercomAvailableError >& error) = 0;

    virtual void onRspIntercomAvailableSignal(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< RspIntercomAvailableSignal >& signal) = 0;
};

class RspPhoneStatusCallbackIF {
public:
    virtual ~RspPhoneStatusCallbackIF() {}

    virtual void onRspPhoneStatusError(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< RspPhoneStatusError >& error) = 0;

    virtual void onRspPhoneStatusSignal(const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxy, const ::boost::shared_ptr< RspPhoneStatusSignal >& signal) = 0;
};


/**
 * IntercomAudioServiceProxy is the client side representation of the
 * D-Bus service interface 'bosch.cm.ai.IntercomAudioService' (specified
 * in file IntercomAudioService.xml).
 *
 * If the meaning of "bosch.cm.ai.IntercomAudioService" isn't clear, then there should be a description here.
 */
class IntercomAudioServiceProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of IntercomAudioServiceProxy.
     */
    static ::boost::shared_ptr< IntercomAudioServiceProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of IntercomAudioServiceProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< IntercomAudioServiceProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of IntercomAudioServiceProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< IntercomAudioServiceProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< IntercomAudioServiceProxy > proxyNew(new IntercomAudioServiceProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(false);
        return proxyNew;
    }

    virtual ~IntercomAudioServiceProxy ();


    // Signal 'incomingCall'

    /**
     * Notify on the signal 'incomingCall'. This method registers for signal
     * changes by D-Bus service.
     *
     * <b>Documentation of 'incomingCall'</b>:
     *
     * Phone No : 0 - Mic1, 1 - Rest Room  , 2 - Kitchen , 3 - Upper Deck
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendIncomingCallRegister(IncomingCallCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'incomingCall'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'incomingCall'</b>:
     *
     * Phone No : 0 - Mic1, 1 - Rest Room  , 2 - Kitchen , 3 - Upper Deck
     *
     * @param act The act which was previously returned by the
     * sendIncomingCallRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendIncomingCallDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'incomingCall'.
     */
    void sendIncomingCallDeregisterAll () const;

    // Signal 'cancelCall'

    /**
     * Notify on the signal 'cancelCall'. This method registers for signal
     * changes by D-Bus service.
     *
     * <b>Documentation of 'cancelCall'</b>:
     *
     * This Event will be generated when call is cancelled from Intercom Phone
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCancelCallRegister(CancelCallCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'cancelCall'. This method deregisters
     * signal changes from the D-Bus service.
     *
     * <b>Documentation of 'cancelCall'</b>:
     *
     * This Event will be generated when call is cancelled from Intercom Phone
     *
     * @param act The act which was previously returned by the
     * sendCancelCallRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendCancelCallDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'cancelCall'.
     */
    void sendCancelCallDeregisterAll () const;

    // Signal 'activeCallStatus'

    /**
     * Notify on the signal 'activeCallStatus'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'activeCallStatus'</b>:
     *
     * This activeCallStatus will be sent when user picks up the phone
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendActiveCallStatusRegister(ActiveCallStatusCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'activeCallStatus'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'activeCallStatus'</b>:
     *
     * This activeCallStatus will be sent when user picks up the phone
     *
     * @param act The act which was previously returned by the
     * sendActiveCallStatusRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendActiveCallStatusDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'activeCallStatus'.
     */
    void sendActiveCallStatusDeregisterAll () const;

    // Signal 'IntercomServiceAvailability'

    /**
     * Notify on the signal 'IntercomServiceAvailability'. This method
     * registers for signal changes by D-Bus service.
     *
     * <b>Documentation of 'IntercomServiceAvailability'</b>:
     *
     * This message is inteded to notify HMI about intercom service availability
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendIntercomServiceAvailabilityRegister(IntercomServiceAvailabilityCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'IntercomServiceAvailability'. This
     * method deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'IntercomServiceAvailability'</b>:
     *
     * This message is inteded to notify HMI about intercom service availability
     *
     * @param act The act which was previously returned by the
     * sendIntercomServiceAvailabilityRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendIntercomServiceAvailabilityDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal
     * 'IntercomServiceAvailability'.
     */
    void sendIntercomServiceAvailabilityDeregisterAll () const;

    // Signal 'RspPhoneStatus'

    /**
     * Notify on the signal 'RspPhoneStatus'. This method registers for signal
     * changes by D-Bus service.
     *
     * <b>Documentation of 'RspPhoneStatus'</b>:
     *
     * BitSet of each PhoneStatus
     * 0th bit -- Disabled ( set ) / enabled  (reset  )
     * 1st bit -- Disconnected ( set ) / connected ( reset )
     * 2nd bit -- onHook ( set ) / Pickup   ( reset )
     * 3rd bit -- Ringing ( set ) / Not Ringing ( reset )
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRspPhoneStatusRegister(RspPhoneStatusCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'RspPhoneStatus'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'RspPhoneStatus'</b>:
     *
     * BitSet of each PhoneStatus
     * 0th bit -- Disabled ( set ) / enabled  (reset  )
     * 1st bit -- Disconnected ( set ) / connected ( reset )
     * 2nd bit -- onHook ( set ) / Pickup   ( reset )
     * 3rd bit -- Ringing ( set ) / Not Ringing ( reset )
     *
     * @param act The act which was previously returned by the
     * sendRspPhoneStatusRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendRspPhoneStatusDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'RspPhoneStatus'.
     */
    void sendRspPhoneStatusDeregisterAll () const;

    // Signal 'EventPhoneStatusChanged'

    /**
     * Notify on the signal 'EventPhoneStatusChanged'. This method registers
     * for signal changes by D-Bus service.
     *
     * <b>Documentation of 'EventPhoneStatusChanged'</b>:
     *
     * If the meaning of "EventPhoneStatusChanged" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendEventPhoneStatusChangedRegister(EventPhoneStatusChangedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'EventPhoneStatusChanged'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'EventPhoneStatusChanged'</b>:
     *
     * If the meaning of "EventPhoneStatusChanged" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendEventPhoneStatusChangedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendEventPhoneStatusChangedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'EventPhoneStatusChanged'.
     */
    void sendEventPhoneStatusChangedDeregisterAll () const;

    // Signal 'EventNanoMessageErrorStatus'

    /**
     * Notify on the signal 'EventNanoMessageErrorStatus'. This method
     * registers for signal changes by D-Bus service.
     *
     * <b>Documentation of 'EventNanoMessageErrorStatus'</b>:
     *
     * If the meaning of "EventNanoMessageErrorStatus" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendEventNanoMessageErrorStatusRegister(EventNanoMessageErrorStatusCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'EventNanoMessageErrorStatus'. This
     * method deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'EventNanoMessageErrorStatus'</b>:
     *
     * If the meaning of "EventNanoMessageErrorStatus" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendEventNanoMessageErrorStatusRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendEventNanoMessageErrorStatusDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal
     * 'EventNanoMessageErrorStatus'.
     */
    void sendEventNanoMessageErrorStatusDeregisterAll () const;

    // Signal 'EventRTPErrorStatus'

    /**
     * Notify on the signal 'EventRTPErrorStatus'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'EventRTPErrorStatus'</b>:
     *
     * If the meaning of "EventRTPErrorStatus" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendEventRTPErrorStatusRegister(EventRTPErrorStatusCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'EventRTPErrorStatus'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'EventRTPErrorStatus'</b>:
     *
     * If the meaning of "EventRTPErrorStatus" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendEventRTPErrorStatusRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendEventRTPErrorStatusDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'EventRTPErrorStatus'.
     */
    void sendEventRTPErrorStatusDeregisterAll () const;

    // Signal 'EventInterComConfigError'

    /**
     * Notify on the signal 'EventInterComConfigError'. This method registers
     * for signal changes by D-Bus service.
     *
     * <b>Documentation of 'EventInterComConfigError'</b>:
     *
     * If the meaning of "EventInterComConfigError" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendEventInterComConfigErrorRegister(EventInterComConfigErrorCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'EventInterComConfigError'. This
     * method deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'EventInterComConfigError'</b>:
     *
     * If the meaning of "EventInterComConfigError" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendEventInterComConfigErrorRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendEventInterComConfigErrorDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'EventInterComConfigError'.
     */
    void sendEventInterComConfigErrorDeregisterAll () const;

    // Signal 'EventAudioAllocationStatus'

    /**
     * Notify on the signal 'EventAudioAllocationStatus'. This method
     * registers for signal changes by D-Bus service.
     *
     * <b>Documentation of 'EventAudioAllocationStatus'</b>:
     *
     * If the meaning of "EventAudioAllocationStatus" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendEventAudioAllocationStatusRegister(EventAudioAllocationStatusCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'EventAudioAllocationStatus'. This
     * method deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'EventAudioAllocationStatus'</b>:
     *
     * If the meaning of "EventAudioAllocationStatus" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendEventAudioAllocationStatusRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendEventAudioAllocationStatusDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal
     * 'EventAudioAllocationStatus'.
     */
    void sendEventAudioAllocationStatusDeregisterAll () const;

    // Signal 'EventIntercomAvailable'

    /**
     * Notify on the signal 'EventIntercomAvailable'. This method registers
     * for signal changes by D-Bus service.
     *
     * <b>Documentation of 'EventIntercomAvailable'</b>:
     *
     * If the meaning of "EventIntercomAvailable" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendEventIntercomAvailableRegister(EventIntercomAvailableCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'EventIntercomAvailable'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'EventIntercomAvailable'</b>:
     *
     * If the meaning of "EventIntercomAvailable" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendEventIntercomAvailableRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendEventIntercomAvailableDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'EventIntercomAvailable'.
     */
    void sendEventIntercomAvailableDeregisterAll () const;

    // Signal 'RspIntercomAvailable'

    /**
     * Notify on the signal 'RspIntercomAvailable'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'RspIntercomAvailable'</b>:
     *
     * If the meaning of "RspIntercomAvailable" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRspIntercomAvailableRegister(RspIntercomAvailableCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'RspIntercomAvailable'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'RspIntercomAvailable'</b>:
     *
     * If the meaning of "RspIntercomAvailable" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendRspIntercomAvailableRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendRspIntercomAvailableDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'RspIntercomAvailable'.
     */
    void sendRspIntercomAvailableDeregisterAll () const;



    // Method 'outgoingCall'

    /**
     * Call the method 'outgoingCall'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'outgoingCall'</b>:
     *
     * Phone No : 0 - Mic1, 1 - Rest Room  , 2 - Kitchen , 3 - Upper Deck
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param phoneNo If the meaning of "phoneNo" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendOutgoingCallRequest(OutgoingCallCallbackIF& cb, int32 phoneNo) const;

    // Method 'getPhoneStatus'

    /**
     * Call the method 'getPhoneStatus'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'getPhoneStatus'</b>:
     *
     * Method to request PhoneStatus
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetPhoneStatusRequest(GetPhoneStatusCallbackIF& cb) const;

    // Method 'CallAction'

    /**
     * Call the method 'CallAction'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'CallAction'</b>:
     *
     * Action : 1 - Accept , 2 - reject
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param Action If the meaning of "Action" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCallActionRequest(CallActionCallbackIF& cb, int32 action) const;

    // Method 'getAvailability'

    /**
     * Call the method 'getAvailability'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'getAvailability'</b>:
     *
     * get Intercom Availability Status
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetAvailabilityRequest(GetAvailabilityCallbackIF& cb) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    IntercomAudioServiceProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;


    DECLARE_CLASS_LOGGER();

    friend class IntercomAudioServiceProxyCallback;
};

} // namespace IntercomAudioService
} // namespace ai
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_AI_INTERCOMAUDIOSERVICEPROXY_H
