/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/ai/HealthcareMonService.h"
#include "bosch/cm/ai/HealthcareMonServiceConst.h"
#include "bosch/cm/ai/HealthcareMonServiceDBus.h"
#include "bosch/cm/ai/HealthcareMonServiceJson.h"
#include "bosch/cm/ai/HealthcareMonServiceStub.h"
#include <string>

#include "asf/dbus/DBusMessage.h"

namespace bosch {
namespace cm {
namespace ai {
namespace HealthcareMonService {

DEFINE_CLASS_LOGGER("/bosch/cm/ai/bosch/cm/ai/HealthcareMonService", HealthcareMonServiceStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 18, "SendAcknowldgement", 0 },
};


class HealthcareMonServiceStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    HealthcareMonServiceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    HealthcareMonServiceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    HealthcareMonServiceStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "bosch.cm.ai.HealthcareMonService"),
          _logger(logger) {}

    virtual ~HealthcareMonServiceStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void HealthcareMonServiceStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 1, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'SendAcknowldgement'

            LOG_DEBUG_STUB("process method '%s'", "SendAcknowldgement");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SendAcknowldgementRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SendAcknowldgement", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SendAcknowldgementRequest > payload = ::boost::static_pointer_cast<SendAcknowldgementRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<HealthcareMonServiceStub*>(getStub())->onSendAcknowldgementRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* HealthcareMonServiceStubDelegate::introspect() const {
    return     "<interface name=\"bosch.cm.ai.HealthcareMonService\">\n"
            "    <method name=\"SendAcknowldgement\">\n"
            "      <doc>\n"
            "        <line>SendAcknowldgement = SendAck from HMI</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"Dev_ID\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>Dev_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Dev_Nr\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Dev_Nr = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"DtcCode\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>DtcCode = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Ack\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Ack = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"response\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>response = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <signal name=\"sig_ShowDTCPopup\">\n"
            "      <doc>\n"
            "        <line>sig_ShowDTCPopup = ReqShowDTCPopup = Method to request for Showing the Pop-Up</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"Dev_ID\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>Dev_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"Dev_Nr\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Dev_Nr = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"DtcCode\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>DtcCode = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"Text_ID\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>Text_ID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"Default_Text\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>Default_Text = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "</interface>\n";
}

void HealthcareMonServiceStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<HealthcareMonServiceStub*>(getStub()))->onGetAll (properties);
}

void HealthcareMonServiceStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void HealthcareMonServiceStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

HealthcareMonServiceStub::HealthcareMonServiceStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new HealthcareMonServiceStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

HealthcareMonServiceStub::HealthcareMonServiceStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new HealthcareMonServiceStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

HealthcareMonServiceStub::~HealthcareMonServiceStub() {
    delete _stubDelegate;
}

void HealthcareMonServiceStub::sendSig_ShowDTCPopupSignal(enDevID dev_ID, uint8 dev_Nr, uint32 dtcCode, uint16 text_ID, const ::std::string& default_Text) {
    if (_stubDelegate->isConnected()) {
        Sig_ShowDTCPopupSignal* payload = new Sig_ShowDTCPopupSignal(dev_ID, dev_Nr, dtcCode, text_ID, default_Text);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "sig_ShowDTCPopup", Sig_ShowDTCPopupSignal, payload)
        LOG_INFO ("-> send%sSignal", "Sig_ShowDTCPopup");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "Sig_ShowDTCPopup");
    }
}

void  HealthcareMonServiceStub::sendSendAcknowldgementResponse (bool response, act_t act) {
    SendAcknowldgementResponse* payload = new SendAcknowldgementResponse(response);
    DBUS_MESSAGE_REPLY(dbusMessage, "SendAcknowldgement", SendAcknowldgementResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SendAcknowldgement", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HealthcareMonServiceStub::sendSendAcknowldgementError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SendAcknowldgementError* payload = new SendAcknowldgementError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SendAcknowldgement", SendAcknowldgementError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SendAcknowldgement", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void HealthcareMonServiceStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace HealthcareMonService
} // namespace ai
} // namespace cm
} // namespace bosch
