/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_AI_HEALTHCAREMONSERVICEPROXY_H
#define BOSCH_CM_AI_HEALTHCAREMONSERVICEPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/ai/HealthcareMonService.h"
#include "bosch/cm/ai/HealthcareMonServiceConst.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include <dbus/dbus.h>

namespace bosch {
namespace cm {
namespace ai {
namespace HealthcareMonService {

class HealthcareMonServiceProxy;

class SendAcknowldgementCallbackIF {
public:
    virtual ~SendAcknowldgementCallbackIF() {}

    virtual void onSendAcknowldgementError(const ::boost::shared_ptr< HealthcareMonServiceProxy >& proxy, const ::boost::shared_ptr< SendAcknowldgementError >& error) = 0;

    virtual void onSendAcknowldgementResponse(const ::boost::shared_ptr< HealthcareMonServiceProxy >& proxy, const ::boost::shared_ptr< SendAcknowldgementResponse >& response) = 0;
};

class Sig_ShowDTCPopupCallbackIF {
public:
    virtual ~Sig_ShowDTCPopupCallbackIF() {}

    virtual void onSig_ShowDTCPopupError(const ::boost::shared_ptr< HealthcareMonServiceProxy >& proxy, const ::boost::shared_ptr< Sig_ShowDTCPopupError >& error) = 0;

    virtual void onSig_ShowDTCPopupSignal(const ::boost::shared_ptr< HealthcareMonServiceProxy >& proxy, const ::boost::shared_ptr< Sig_ShowDTCPopupSignal >& signal) = 0;
};


/**
 * HealthcareMonServiceProxy is the client side representation of the
 * D-Bus service interface 'bosch.cm.ai.HealthcareMonService' (specified
 * in file HealthcareMonService_.xml).
 *
 * If the meaning of "bosch.cm.ai.HealthcareMonService" isn't clear, then there should be a description here.
 */
class HealthcareMonServiceProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of HealthcareMonServiceProxy.
     */
    static ::boost::shared_ptr< HealthcareMonServiceProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of HealthcareMonServiceProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< HealthcareMonServiceProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of HealthcareMonServiceProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< HealthcareMonServiceProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< HealthcareMonServiceProxy > proxyNew(new HealthcareMonServiceProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(false);
        return proxyNew;
    }

    virtual ~HealthcareMonServiceProxy ();


    // Signal 'sig_ShowDTCPopup'

    /**
     * Notify on the signal 'sig_ShowDTCPopup'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'sig_ShowDTCPopup'</b>:
     *
     * ReqShowDTCPopup = Method to request for Showing the Pop-Up
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSig_ShowDTCPopupRegister(Sig_ShowDTCPopupCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'sig_ShowDTCPopup'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'sig_ShowDTCPopup'</b>:
     *
     * ReqShowDTCPopup = Method to request for Showing the Pop-Up
     *
     * @param act The act which was previously returned by the
     * sendSig_ShowDTCPopupRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSig_ShowDTCPopupDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'sig_ShowDTCPopup'.
     */
    void sendSig_ShowDTCPopupDeregisterAll () const;



    // Method 'SendAcknowldgement'

    /**
     * Call the method 'SendAcknowldgement'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'SendAcknowldgement'</b>:
     *
     * SendAck from HMI
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param Dev_ID If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param DtcCode If the meaning of "DtcCode" isn't clear, then there should be a description here.
     *
     * @param Ack If the meaning of "Ack" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSendAcknowldgementRequest(SendAcknowldgementCallbackIF& cb, enDevID dev_ID, uint8 dev_Nr, uint32 dtcCode, uint8 ack) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    HealthcareMonServiceProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;


    DECLARE_CLASS_LOGGER();

    friend class HealthcareMonServiceProxyCallback;
};

} // namespace HealthcareMonService
} // namespace ai
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_AI_HEALTHCAREMONSERVICEPROXY_H
