/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/cm/diagnosis/dbus/SubsystemDiagnosis.h"
#include "org/bosch/cm/diagnosis/dbus/SubsystemDiagnosisDBus.h"
#include "org/bosch/cm/diagnosis/dbus/SubsystemDiagnosisJson.h"
#include "org/bosch/cm/diagnosis/dbus/SubsystemDiagnosisStub.h"
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bosch {
namespace cm {
namespace diagnosis {
namespace dbus {
namespace SubsystemDiagnosis {

DEFINE_CLASS_LOGGER("/org/bosch/cm/diagnosis/dbus/SubsystemDiagnosis", SubsystemDiagnosisStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 16, "DiscoverEntities", 1 },
    { 17, "AvdeccFilesDelete", 3 },
    { 23, "DiscoverEntitiesResults", 2 },
    { 23, "StartUDPBroadcastClient", 0 },
};


class SubsystemDiagnosisStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    SubsystemDiagnosisStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    SubsystemDiagnosisStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    SubsystemDiagnosisStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.bosch.cm.diagnosis.dbus.SubsystemDiagnosis"),
          _logger(logger) {}

    virtual ~SubsystemDiagnosisStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void SubsystemDiagnosisStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 4, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'StartUDPBroadcastClient'

            LOG_DEBUG_STUB("process method '%s'", "StartUDPBroadcastClient");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartUDPBroadcastClientRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "StartUDPBroadcastClient", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< StartUDPBroadcastClientRequest > payload = ::boost::static_pointer_cast<StartUDPBroadcastClientRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SubsystemDiagnosisStub*>(getStub())->onStartUDPBroadcastClientRequest(payload);
            return;
        }
        case 1: {

            // method 'DiscoverEntities'

            LOG_DEBUG_STUB("process method '%s'", "DiscoverEntities");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DiscoverEntitiesRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "DiscoverEntities", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< DiscoverEntitiesRequest > payload = ::boost::static_pointer_cast<DiscoverEntitiesRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SubsystemDiagnosisStub*>(getStub())->onDiscoverEntitiesRequest(payload);
            return;
        }
        case 2: {

            // method 'DiscoverEntitiesResults'

            LOG_DEBUG_STUB("process method '%s'", "DiscoverEntitiesResults");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DiscoverEntitiesResultsRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "DiscoverEntitiesResults", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< DiscoverEntitiesResultsRequest > payload = ::boost::static_pointer_cast<DiscoverEntitiesResultsRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SubsystemDiagnosisStub*>(getStub())->onDiscoverEntitiesResultsRequest(payload);
            return;
        }
        case 3: {

            // method 'AvdeccFilesDelete'

            LOG_DEBUG_STUB("process method '%s'", "AvdeccFilesDelete");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AvdeccFilesDeleteRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "AvdeccFilesDelete", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< AvdeccFilesDeleteRequest > payload = ::boost::static_pointer_cast<AvdeccFilesDeleteRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SubsystemDiagnosisStub*>(getStub())->onAvdeccFilesDeleteRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* SubsystemDiagnosisStubDelegate::introspect() const {
    return     "<interface name=\"org.bosch.cm.diagnosis.dbus.SubsystemDiagnosis\">\n"
            "      <doc>\n"
            "        <line> interfaces exposed internally by the diagnosis slave for subsystem diagnosis. </line>\n"
            "      </doc>\n"
            "      <method name=\"StartUDPBroadcastClient\">\n"
            "        <arg direction=\"out\" name=\"status\" type=\"u\"/>\n"
            "      </method>\n"
            "      <method name=\"DiscoverEntities\"/>\n"
            "      <method name=\"DiscoverEntitiesResults\">\n"
            "        <arg direction=\"out\" name=\"status\" type=\"u\"/>\n"
            "        <arg direction=\"out\" name=\"NodeList\" type=\"a(iii(ay)i(ay)(ay)(ay))\"/>\n"
            "      </method>\n"
            "      <method name=\"AvdeccFilesDelete\">\n"
            "        <arg direction=\"out\" name=\"status\" type=\"u\"/>\n"
            "      </method>\n"
            "</interface>\n";
}

void SubsystemDiagnosisStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<SubsystemDiagnosisStub*>(getStub()))->onGetAll (properties);
}

void SubsystemDiagnosisStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void SubsystemDiagnosisStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

SubsystemDiagnosisStub::SubsystemDiagnosisStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new SubsystemDiagnosisStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

SubsystemDiagnosisStub::SubsystemDiagnosisStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new SubsystemDiagnosisStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

SubsystemDiagnosisStub::~SubsystemDiagnosisStub() {
    delete _stubDelegate;
}

void  SubsystemDiagnosisStub::sendStartUDPBroadcastClientResponse (uint32 status, act_t act) {
    StartUDPBroadcastClientResponse* payload = new StartUDPBroadcastClientResponse(status);
    DBUS_MESSAGE_REPLY(dbusMessage, "StartUDPBroadcastClient", StartUDPBroadcastClientResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "StartUDPBroadcastClient", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SubsystemDiagnosisStub::sendStartUDPBroadcastClientError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    StartUDPBroadcastClientError* payload = new StartUDPBroadcastClientError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "StartUDPBroadcastClient", StartUDPBroadcastClientError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "StartUDPBroadcastClient", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SubsystemDiagnosisStub::sendDiscoverEntitiesResponse (act_t act) {
    DiscoverEntitiesResponse* payload = new DiscoverEntitiesResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "DiscoverEntities", DiscoverEntitiesResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "DiscoverEntities", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SubsystemDiagnosisStub::sendDiscoverEntitiesError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    DiscoverEntitiesError* payload = new DiscoverEntitiesError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "DiscoverEntities", DiscoverEntitiesError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "DiscoverEntities", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SubsystemDiagnosisStub::sendDiscoverEntitiesResultsResponse (uint32 status, const ::std::vector< DiscoverEntitiesResultsResponseNodeListStruct >& nodeList, act_t act) {
    DiscoverEntitiesResultsResponse* payload = new DiscoverEntitiesResultsResponse(status, nodeList);
    DBUS_MESSAGE_REPLY(dbusMessage, "DiscoverEntitiesResults", DiscoverEntitiesResultsResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "DiscoverEntitiesResults", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SubsystemDiagnosisStub::sendDiscoverEntitiesResultsError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    DiscoverEntitiesResultsError* payload = new DiscoverEntitiesResultsError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "DiscoverEntitiesResults", DiscoverEntitiesResultsError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "DiscoverEntitiesResults", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SubsystemDiagnosisStub::sendAvdeccFilesDeleteResponse (uint32 status, act_t act) {
    AvdeccFilesDeleteResponse* payload = new AvdeccFilesDeleteResponse(status);
    DBUS_MESSAGE_REPLY(dbusMessage, "AvdeccFilesDelete", AvdeccFilesDeleteResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "AvdeccFilesDelete", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SubsystemDiagnosisStub::sendAvdeccFilesDeleteError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    AvdeccFilesDeleteError* payload = new AvdeccFilesDeleteError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "AvdeccFilesDelete", AvdeccFilesDeleteError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "AvdeccFilesDelete", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void SubsystemDiagnosisStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace SubsystemDiagnosis
} // namespace dbus
} // namespace diagnosis
} // namespace cm
} // namespace bosch
} // namespace org
