/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_WBL_WIFISETUPSTUB_H
#define ORG_BOSCH_WBL_WIFISETUPSTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/wbl/wifisetup.h"
#include <map>
#include <string>
#include <vector>

namespace org {
namespace bosch {
namespace wbl {
namespace wifisetup {

class WifisetupStubDelegate;

class WifisetupStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the WifisetupStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    WifisetupStub (const std::string& portName);

    /**
     * Create an instance of the WifisetupStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    WifisetupStub (const std::string& portName, const std::string& objectPath);

    virtual ~WifisetupStub();

    // property 'Mode'

    /**
     * The method onModeGet() is called by ASF when a client invokes the read
     * method for the property 'Mode'. The onModeGet() method returns by
     * default the current property value to the caller. In case this default
     * behavior doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'Mode'</b>:
     *
     * If the meaning of "Mode" isn't clear, then there should be a description here.
     */
    virtual void onModeGet(const ::boost::shared_ptr< ModeGet >& payload);

    /**
     * Sends back the update to a previous onModeGet().
     *
     * <b>Documentation of 'Mode'</b>:
     *
     * If the meaning of "Mode" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onModeGet(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendModeGetUpdate(const ::std::string& mode, act_t act = 0);

    /**
     * Set the value of the property 'Mode' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Mode'</b>:
     *
     * If the meaning of "Mode" isn't clear, then there should be a description here.
     */
    void setMode(const ::std::string& mode);

    /**
     * Returns the current value of the property 'Mode'.
     *
     * <b>Documentation of 'Mode'</b>:
     *
     * If the meaning of "Mode" isn't clear, then there should be a description here.
     */
    const ::std::string& getMode() const;

    /**
     * Returns the current value of the property 'Mode' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendModeUpdate() method.
     *
     * <b>Documentation of 'Mode'</b>:
     *
     * If the meaning of "Mode" isn't clear, then there should be a description here.
     */
    ::std::string& getModeMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendModeUpdate().
     *
     * <b>Documentation of 'Mode'</b>:
     *
     * If the meaning of "Mode" isn't clear, then there should be a description here.
     */
    void sendModeUpdate();

    // property 'Interface'

    /**
     * The method onInterfaceGet() is called by ASF when a client invokes the
     * read method for the property 'Interface'. The onInterfaceGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Interface'</b>:
     *
     * If the meaning of "Interface" isn't clear, then there should be a description here.
     */
    virtual void onInterfaceGet(const ::boost::shared_ptr< InterfaceGet >& payload);

    /**
     * Sends back the update to a previous onInterfaceGet().
     *
     * <b>Documentation of 'Interface'</b>:
     *
     * If the meaning of "Interface" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onInterfaceGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendInterfaceGetUpdate(const ::std::string& interface, act_t act = 0);

    /**
     * Set the value of the property 'Interface' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'Interface'</b>:
     *
     * If the meaning of "Interface" isn't clear, then there should be a description here.
     */
    void setInterface(const ::std::string& interface);

    /**
     * Returns the current value of the property 'Interface'.
     *
     * <b>Documentation of 'Interface'</b>:
     *
     * If the meaning of "Interface" isn't clear, then there should be a description here.
     */
    const ::std::string& getInterface() const;

    /**
     * Returns the current value of the property 'Interface' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendInterfaceUpdate() method.
     *
     * <b>Documentation of 'Interface'</b>:
     *
     * If the meaning of "Interface" isn't clear, then there should be a description here.
     */
    ::std::string& getInterfaceMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendInterfaceUpdate().
     *
     * <b>Documentation of 'Interface'</b>:
     *
     * If the meaning of "Interface" isn't clear, then there should be a description here.
     */
    void sendInterfaceUpdate();

    // property 'MacAddress'

    /**
     * The method onMacAddressGet() is called by ASF when a client invokes the
     * read method for the property 'MacAddress'. The onMacAddressGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'MacAddress'</b>:
     *
     * If the meaning of "MacAddress" isn't clear, then there should be a description here.
     */
    virtual void onMacAddressGet(const ::boost::shared_ptr< MacAddressGet >& payload);

    /**
     * Sends back the update to a previous onMacAddressGet().
     *
     * <b>Documentation of 'MacAddress'</b>:
     *
     * If the meaning of "MacAddress" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onMacAddressGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendMacAddressGetUpdate(const ::std::string& macAddress, act_t act = 0);

    /**
     * Set the value of the property 'MacAddress' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'MacAddress'</b>:
     *
     * If the meaning of "MacAddress" isn't clear, then there should be a description here.
     */
    void setMacAddress(const ::std::string& macAddress);

    /**
     * Returns the current value of the property 'MacAddress'.
     *
     * <b>Documentation of 'MacAddress'</b>:
     *
     * If the meaning of "MacAddress" isn't clear, then there should be a description here.
     */
    const ::std::string& getMacAddress() const;

    /**
     * Returns the current value of the property 'MacAddress' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendMacAddressUpdate() method.
     *
     * <b>Documentation of 'MacAddress'</b>:
     *
     * If the meaning of "MacAddress" isn't clear, then there should be a description here.
     */
    ::std::string& getMacAddressMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendMacAddressUpdate().
     *
     * <b>Documentation of 'MacAddress'</b>:
     *
     * If the meaning of "MacAddress" isn't clear, then there should be a description here.
     */
    void sendMacAddressUpdate();

    // property 'PowerState'

    /**
     * The method onPowerStateGet() is called by ASF when a client invokes the
     * read method for the property 'PowerState'. The onPowerStateGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'PowerState'</b>:
     *
     * If the meaning of "PowerState" isn't clear, then there should be a description here.
     */
    virtual void onPowerStateGet(const ::boost::shared_ptr< PowerStateGet >& payload);

    /**
     * Sends back the update to a previous onPowerStateGet().
     *
     * <b>Documentation of 'PowerState'</b>:
     *
     * If the meaning of "PowerState" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onPowerStateGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendPowerStateGetUpdate(const ::std::string& powerState, act_t act = 0);

    /**
     * Set the value of the property 'PowerState' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'PowerState'</b>:
     *
     * If the meaning of "PowerState" isn't clear, then there should be a description here.
     */
    void setPowerState(const ::std::string& powerState);

    /**
     * Returns the current value of the property 'PowerState'.
     *
     * <b>Documentation of 'PowerState'</b>:
     *
     * If the meaning of "PowerState" isn't clear, then there should be a description here.
     */
    const ::std::string& getPowerState() const;

    /**
     * Returns the current value of the property 'PowerState' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendPowerStateUpdate() method.
     *
     * <b>Documentation of 'PowerState'</b>:
     *
     * If the meaning of "PowerState" isn't clear, then there should be a description here.
     */
    ::std::string& getPowerStateMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendPowerStateUpdate().
     *
     * <b>Documentation of 'PowerState'</b>:
     *
     * If the meaning of "PowerState" isn't clear, then there should be a description here.
     */
    void sendPowerStateUpdate();

    // property 'PowerFailureReason'

    /**
     * The method onPowerFailureReasonGet() is called by ASF when a client
     * invokes the read method for the property 'PowerFailureReason'. The
     * onPowerFailureReasonGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'PowerFailureReason'</b>:
     *
     * If the meaning of "PowerFailureReason" isn't clear, then there should be a description here.
     */
    virtual void onPowerFailureReasonGet(const ::boost::shared_ptr< PowerFailureReasonGet >& payload);

    /**
     * Sends back the update to a previous onPowerFailureReasonGet().
     *
     * <b>Documentation of 'PowerFailureReason'</b>:
     *
     * If the meaning of "PowerFailureReason" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of
     * onPowerFailureReasonGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendPowerFailureReasonGetUpdate(const ::std::string& powerFailureReason, act_t act = 0);

    /**
     * Set the value of the property 'PowerFailureReason' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'PowerFailureReason'</b>:
     *
     * If the meaning of "PowerFailureReason" isn't clear, then there should be a description here.
     */
    void setPowerFailureReason(const ::std::string& powerFailureReason);

    /**
     * Returns the current value of the property 'PowerFailureReason'.
     *
     * <b>Documentation of 'PowerFailureReason'</b>:
     *
     * If the meaning of "PowerFailureReason" isn't clear, then there should be a description here.
     */
    const ::std::string& getPowerFailureReason() const;

    /**
     * Returns the current value of the property 'PowerFailureReason' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendPowerFailureReasonUpdate() method.
     *
     * <b>Documentation of 'PowerFailureReason'</b>:
     *
     * If the meaning of "PowerFailureReason" isn't clear, then there should be a description here.
     */
    ::std::string& getPowerFailureReasonMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendPowerFailureReasonUpdate().
     *
     * <b>Documentation of 'PowerFailureReason'</b>:
     *
     * If the meaning of "PowerFailureReason" isn't clear, then there should be a description here.
     */
    void sendPowerFailureReasonUpdate();

    // property 'Frequency'

    /**
     * The method onFrequencyGet() is called by ASF when a client invokes the
     * read method for the property 'Frequency'. The onFrequencyGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Frequency'</b>:
     *
     * If the meaning of "Frequency" isn't clear, then there should be a description here.
     */
    virtual void onFrequencyGet(const ::boost::shared_ptr< FrequencyGet >& payload);

    /**
     * Sends back the update to a previous onFrequencyGet().
     *
     * <b>Documentation of 'Frequency'</b>:
     *
     * If the meaning of "Frequency" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onFrequencyGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendFrequencyGetUpdate(const ::std::string& frequency, act_t act = 0);

    /**
     * Set the value of the property 'Frequency' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'Frequency'</b>:
     *
     * If the meaning of "Frequency" isn't clear, then there should be a description here.
     */
    void setFrequency(const ::std::string& frequency);

    /**
     * Returns the current value of the property 'Frequency'.
     *
     * <b>Documentation of 'Frequency'</b>:
     *
     * If the meaning of "Frequency" isn't clear, then there should be a description here.
     */
    const ::std::string& getFrequency() const;

    /**
     * Returns the current value of the property 'Frequency' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendFrequencyUpdate() method.
     *
     * <b>Documentation of 'Frequency'</b>:
     *
     * If the meaning of "Frequency" isn't clear, then there should be a description here.
     */
    ::std::string& getFrequencyMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendFrequencyUpdate().
     *
     * <b>Documentation of 'Frequency'</b>:
     *
     * If the meaning of "Frequency" isn't clear, then there should be a description here.
     */
    void sendFrequencyUpdate();

    // property 'CurrentOperatingChannel'

    /**
     * The method onCurrentOperatingChannelGet() is called by ASF when a
     * client invokes the read method for the property
     * 'CurrentOperatingChannel'. The onCurrentOperatingChannelGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'CurrentOperatingChannel'</b>:
     *
     * If the meaning of "CurrentOperatingChannel" isn't clear, then there should be a description here.
     */
    virtual void onCurrentOperatingChannelGet(const ::boost::shared_ptr< CurrentOperatingChannelGet >& payload);

    /**
     * Sends back the update to a previous onCurrentOperatingChannelGet().
     *
     * <b>Documentation of 'CurrentOperatingChannel'</b>:
     *
     * If the meaning of "CurrentOperatingChannel" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of
     * onCurrentOperatingChannelGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendCurrentOperatingChannelGetUpdate(int32 currentOperatingChannel, act_t act = 0);

    /**
     * Set the value of the property 'CurrentOperatingChannel' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'CurrentOperatingChannel'</b>:
     *
     * If the meaning of "CurrentOperatingChannel" isn't clear, then there should be a description here.
     */
    void setCurrentOperatingChannel(int32 currentOperatingChannel);

    /**
     * Returns the current value of the property 'CurrentOperatingChannel'.
     *
     * <b>Documentation of 'CurrentOperatingChannel'</b>:
     *
     * If the meaning of "CurrentOperatingChannel" isn't clear, then there should be a description here.
     */
    int32 getCurrentOperatingChannel() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendCurrentOperatingChannelUpdate().
     *
     * <b>Documentation of 'CurrentOperatingChannel'</b>:
     *
     * If the meaning of "CurrentOperatingChannel" isn't clear, then there should be a description here.
     */
    void sendCurrentOperatingChannelUpdate();

    // property 'APConfig'

    /**
     * The method onAPConfigGet() is called by ASF when a client invokes the
     * read method for the property 'APConfig'. The onAPConfigGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'APConfig'</b>:
     *
     * If the meaning of "APConfig" isn't clear, then there should be a description here.
     */
    virtual void onAPConfigGet(const ::boost::shared_ptr< APConfigGet >& payload);

    /**
     * Sends back the update to a previous onAPConfigGet().
     *
     * <b>Documentation of 'APConfig'</b>:
     *
     * If the meaning of "APConfig" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onAPConfigGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendAPConfigGetUpdate(const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& aPConfig, act_t act = 0);

    /**
     * Set the value of the property 'APConfig' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'APConfig'</b>:
     *
     * If the meaning of "APConfig" isn't clear, then there should be a description here.
     */
    void setAPConfig(const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& aPConfig);

    /**
     * Returns the current value of the property 'APConfig'.
     *
     * <b>Documentation of 'APConfig'</b>:
     *
     * If the meaning of "APConfig" isn't clear, then there should be a description here.
     */
    const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getAPConfig() const;

    /**
     * Returns the current value of the property 'APConfig' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendAPConfigUpdate() method.
     *
     * <b>Documentation of 'APConfig'</b>:
     *
     * If the meaning of "APConfig" isn't clear, then there should be a description here.
     */
    ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getAPConfigMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendAPConfigUpdate().
     *
     * <b>Documentation of 'APConfig'</b>:
     *
     * If the meaning of "APConfig" isn't clear, then there should be a description here.
     */
    void sendAPConfigUpdate();

    // property 'Restrictions'

    /**
     * The method onRestrictionsGet() is called by ASF when a client invokes
     * the read method for the property 'Restrictions'. The
     * onRestrictionsGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'Restrictions'</b>:
     *
     * If the meaning of "Restrictions" isn't clear, then there should be a description here.
     */
    virtual void onRestrictionsGet(const ::boost::shared_ptr< RestrictionsGet >& payload);

    /**
     * Sends back the update to a previous onRestrictionsGet().
     *
     * <b>Documentation of 'Restrictions'</b>:
     *
     * If the meaning of "Restrictions" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onRestrictionsGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendRestrictionsGetUpdate(const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& restrictions, act_t act = 0);

    /**
     * Set the value of the property 'Restrictions' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'Restrictions'</b>:
     *
     * If the meaning of "Restrictions" isn't clear, then there should be a description here.
     */
    void setRestrictions(const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& restrictions);

    /**
     * Returns the current value of the property 'Restrictions'.
     *
     * <b>Documentation of 'Restrictions'</b>:
     *
     * If the meaning of "Restrictions" isn't clear, then there should be a description here.
     */
    const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& getRestrictions() const;

    /**
     * Returns the current value of the property 'Restrictions' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendRestrictionsUpdate() method.
     *
     * <b>Documentation of 'Restrictions'</b>:
     *
     * If the meaning of "Restrictions" isn't clear, then there should be a description here.
     */
    ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& getRestrictionsMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendRestrictionsUpdate().
     *
     * <b>Documentation of 'Restrictions'</b>:
     *
     * If the meaning of "Restrictions" isn't clear, then there should be a description here.
     */
    void sendRestrictionsUpdate();

    // property 'SupportedFrequencies'

    /**
     * The method onSupportedFrequenciesGet() is called by ASF when a client
     * invokes the read method for the property 'SupportedFrequencies'. The
     * onSupportedFrequenciesGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'SupportedFrequencies'</b>:
     *
     * If the meaning of "SupportedFrequencies" isn't clear, then there should be a description here.
     */
    virtual void onSupportedFrequenciesGet(const ::boost::shared_ptr< SupportedFrequenciesGet >& payload);

    /**
     * Sends back the update to a previous onSupportedFrequenciesGet().
     *
     * <b>Documentation of 'SupportedFrequencies'</b>:
     *
     * If the meaning of "SupportedFrequencies" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of
     * onSupportedFrequenciesGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSupportedFrequenciesGetUpdate(const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& supportedFrequencies, act_t act = 0);

    /**
     * Set the value of the property 'SupportedFrequencies' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'SupportedFrequencies'</b>:
     *
     * If the meaning of "SupportedFrequencies" isn't clear, then there should be a description here.
     */
    void setSupportedFrequencies(const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& supportedFrequencies);

    /**
     * Returns the current value of the property 'SupportedFrequencies'.
     *
     * <b>Documentation of 'SupportedFrequencies'</b>:
     *
     * If the meaning of "SupportedFrequencies" isn't clear, then there should be a description here.
     */
    const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& getSupportedFrequencies() const;

    /**
     * Returns the current value of the property 'SupportedFrequencies' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendSupportedFrequenciesUpdate() method.
     *
     * <b>Documentation of 'SupportedFrequencies'</b>:
     *
     * If the meaning of "SupportedFrequencies" isn't clear, then there should be a description here.
     */
    ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& getSupportedFrequenciesMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSupportedFrequenciesUpdate().
     *
     * <b>Documentation of 'SupportedFrequencies'</b>:
     *
     * If the meaning of "SupportedFrequencies" isn't clear, then there should be a description here.
     */
    void sendSupportedFrequenciesUpdate();

    // property 'IPv4Configuration'

    /**
     * The method onIPv4ConfigurationGet() is called by ASF when a client
     * invokes the read method for the property 'IPv4Configuration'. The
     * onIPv4ConfigurationGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'IPv4Configuration'</b>:
     *
     * If the meaning of "IPv4Configuration" isn't clear, then there should be a description here.
     */
    virtual void onIPv4ConfigurationGet(const ::boost::shared_ptr< IPv4ConfigurationGet >& payload);

    /**
     * Sends back the update to a previous onIPv4ConfigurationGet().
     *
     * <b>Documentation of 'IPv4Configuration'</b>:
     *
     * If the meaning of "IPv4Configuration" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of
     * onIPv4ConfigurationGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendIPv4ConfigurationGetUpdate(const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& iPv4Configuration, act_t act = 0);

    /**
     * Set the value of the property 'IPv4Configuration' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'IPv4Configuration'</b>:
     *
     * If the meaning of "IPv4Configuration" isn't clear, then there should be a description here.
     */
    void setIPv4Configuration(const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& iPv4Configuration);

    /**
     * Returns the current value of the property 'IPv4Configuration'.
     *
     * <b>Documentation of 'IPv4Configuration'</b>:
     *
     * If the meaning of "IPv4Configuration" isn't clear, then there should be a description here.
     */
    const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& getIPv4Configuration() const;

    /**
     * Returns the current value of the property 'IPv4Configuration' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendIPv4ConfigurationUpdate() method.
     *
     * <b>Documentation of 'IPv4Configuration'</b>:
     *
     * If the meaning of "IPv4Configuration" isn't clear, then there should be a description here.
     */
    ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& getIPv4ConfigurationMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendIPv4ConfigurationUpdate().
     *
     * <b>Documentation of 'IPv4Configuration'</b>:
     *
     * If the meaning of "IPv4Configuration" isn't clear, then there should be a description here.
     */
    void sendIPv4ConfigurationUpdate();

    // property 'ConnectionStatus'

    /**
     * The method onConnectionStatusGet() is called by ASF when a client
     * invokes the read method for the property 'ConnectionStatus'. The
     * onConnectionStatusGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'ConnectionStatus'</b>:
     *
     * If the meaning of "ConnectionStatus" isn't clear, then there should be a description here.
     */
    virtual void onConnectionStatusGet(const ::boost::shared_ptr< ConnectionStatusGet >& payload);

    /**
     * Sends back the update to a previous onConnectionStatusGet().
     *
     * <b>Documentation of 'ConnectionStatus'</b>:
     *
     * If the meaning of "ConnectionStatus" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onConnectionStatusGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendConnectionStatusGetUpdate(const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& connectionStatus, act_t act = 0);

    /**
     * Set the value of the property 'ConnectionStatus' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'ConnectionStatus'</b>:
     *
     * If the meaning of "ConnectionStatus" isn't clear, then there should be a description here.
     */
    void setConnectionStatus(const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& connectionStatus);

    /**
     * Returns the current value of the property 'ConnectionStatus'.
     *
     * <b>Documentation of 'ConnectionStatus'</b>:
     *
     * If the meaning of "ConnectionStatus" isn't clear, then there should be a description here.
     */
    const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getConnectionStatus() const;

    /**
     * Returns the current value of the property 'ConnectionStatus' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendConnectionStatusUpdate() method.
     *
     * <b>Documentation of 'ConnectionStatus'</b>:
     *
     * If the meaning of "ConnectionStatus" isn't clear, then there should be a description here.
     */
    ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getConnectionStatusMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendConnectionStatusUpdate().
     *
     * <b>Documentation of 'ConnectionStatus'</b>:
     *
     * If the meaning of "ConnectionStatus" isn't clear, then there should be a description here.
     */
    void sendConnectionStatusUpdate();

    // method 'DeAuthenticateStation'

    /**
     * The method onDeAuthenticateStation() is called by ASF when a client
     * invokes the method 'DeAuthenticateStation'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendDeAuthenticateStation() or sendDeAuthenticateStationError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'DeAuthenticateStation'</b>:
     *
     * If the meaning of "DeAuthenticateStation" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onDeAuthenticateStationRequest (const ::boost::shared_ptr< DeAuthenticateStationRequest >& request) = 0;

    /**
     * The method sendDeAuthenticateStationResponse() sends a response of a
     * previous method invocation of 'DeAuthenticateStation' back to the
     * client.
     *
     * <b>Documentation of 'DeAuthenticateStation'</b>:
     *
     * If the meaning of "DeAuthenticateStation" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onDeAuthenticateStation(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendDeAuthenticateStationResponse (act_t act = 0);

    /**
     * The method sendDeAuthenticateStationError() sends an error response of
     * a previous method invocation of 'DeAuthenticateStation' back to the
     * client.
     *
     * <b>Documentation of 'DeAuthenticateStation'</b>:
     *
     * If the meaning of "DeAuthenticateStation" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onDeAuthenticateStation(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendDeAuthenticateStationError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ManageBandwidth'

    /**
     * The method onManageBandwidth() is called by ASF when a client invokes
     * the method 'ManageBandwidth'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendManageBandwidth() or sendManageBandwidthError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'ManageBandwidth'</b>:
     *
     * If the meaning of "ManageBandwidth" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onManageBandwidthRequest (const ::boost::shared_ptr< ManageBandwidthRequest >& request) = 0;

    /**
     * The method sendManageBandwidthResponse() sends a response of a previous
     * method invocation of 'ManageBandwidth' back to the client.
     *
     * <b>Documentation of 'ManageBandwidth'</b>:
     *
     * If the meaning of "ManageBandwidth" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onManageBandwidth(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendManageBandwidthResponse (act_t act = 0);

    /**
     * The method sendManageBandwidthError() sends an error response of a
     * previous method invocation of 'ManageBandwidth' back to the client.
     *
     * <b>Documentation of 'ManageBandwidth'</b>:
     *
     * If the meaning of "ManageBandwidth" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onManageBandwidth(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendManageBandwidthError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'SetRestrictions'

    /**
     * The method onSetRestrictions() is called by ASF when a client invokes
     * the method 'SetRestrictions'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendSetRestrictions() or sendSetRestrictionsError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'SetRestrictions'</b>:
     *
     * If the meaning of "SetRestrictions" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetRestrictionsRequest (const ::boost::shared_ptr< SetRestrictionsRequest >& request) = 0;

    /**
     * The method sendSetRestrictionsResponse() sends a response of a previous
     * method invocation of 'SetRestrictions' back to the client.
     *
     * <b>Documentation of 'SetRestrictions'</b>:
     *
     * If the meaning of "SetRestrictions" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetRestrictions(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendSetRestrictionsResponse (act_t act = 0);

    /**
     * The method sendSetRestrictionsError() sends an error response of a
     * previous method invocation of 'SetRestrictions' back to the client.
     *
     * <b>Documentation of 'SetRestrictions'</b>:
     *
     * If the meaning of "SetRestrictions" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSetRestrictions(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSetRestrictionsError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'RestoreFactorySettings'

    /**
     * The method onRestoreFactorySettings() is called by ASF when a client
     * invokes the method 'RestoreFactorySettings'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendRestoreFactorySettings() or
     * sendRestoreFactorySettingsError() method. Do not invoke this method on
     * your own.
     *
     * <b>Documentation of 'RestoreFactorySettings'</b>:
     *
     * If the meaning of "RestoreFactorySettings" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRestoreFactorySettingsRequest (const ::boost::shared_ptr< RestoreFactorySettingsRequest >& request) = 0;

    /**
     * The method sendRestoreFactorySettingsResponse() sends a response of a
     * previous method invocation of 'RestoreFactorySettings' back to the
     * client.
     *
     * <b>Documentation of 'RestoreFactorySettings'</b>:
     *
     * If the meaning of "RestoreFactorySettings" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onRestoreFactorySettings(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRestoreFactorySettingsResponse (act_t act = 0);

    /**
     * The method sendRestoreFactorySettingsError() sends an error response of
     * a previous method invocation of 'RestoreFactorySettings' back to the
     * client.
     *
     * <b>Documentation of 'RestoreFactorySettings'</b>:
     *
     * If the meaning of "RestoreFactorySettings" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onRestoreFactorySettings(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRestoreFactorySettingsError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    ModeUpdate _ModeProperty;

    InterfaceUpdate _InterfaceProperty;

    MacAddressUpdate _MacAddressProperty;

    PowerStateUpdate _PowerStateProperty;

    PowerFailureReasonUpdate _PowerFailureReasonProperty;

    FrequencyUpdate _FrequencyProperty;

    CurrentOperatingChannelUpdate _CurrentOperatingChannelProperty;

    APConfigUpdate _APConfigProperty;

    RestrictionsUpdate _RestrictionsProperty;

    SupportedFrequenciesUpdate _SupportedFrequenciesProperty;

    IPv4ConfigurationUpdate _IPv4ConfigurationProperty;

    ConnectionStatusUpdate _ConnectionStatusProperty;

    friend class WifisetupStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace wifisetup
} // namespace wbl
} // namespace bosch
} // namespace org

#endif // ORG_BOSCH_WBL_WIFISETUPSTUB_H
