/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/wbl/wifisetup.h"
#include "org/bosch/wbl/wifisetupDBus.h"
#include "org/bosch/wbl/wifisetupJson.h"
#include "org/bosch/wbl/wifisetupProxy.h"
#include <map>
#include <string>
#include <vector>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bosch {
namespace wbl {
namespace wifisetup {

DEFINE_CLASS_LOGGER("//org/bosch/wbl/wifisetup/org/bosch/wbl/wifisetup", WifisetupProxy);

class WifisetupProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    WifisetupProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< WifisetupProxy >& proxyShared = ::boost::static_pointer_cast< WifisetupProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_Mode:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ModeError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Mode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ModeError> payload = ::boost::static_pointer_cast<ModeError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ModeCallbackIF*) _callback)->onModeError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ModeUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Mode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ModeUpdate> payload = ::boost::static_pointer_cast<ModeUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ModeCallbackIF*) _callback)->onModeUpdate(proxyShared, payload);
                        proxyShared->_mode = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Interface:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), InterfaceError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Interface", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<InterfaceError> payload = ::boost::static_pointer_cast<InterfaceError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((InterfaceCallbackIF*) _callback)->onInterfaceError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), InterfaceUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Interface", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<InterfaceUpdate> payload = ::boost::static_pointer_cast<InterfaceUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((InterfaceCallbackIF*) _callback)->onInterfaceUpdate(proxyShared, payload);
                        proxyShared->_interface = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_MacAddress:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MacAddressError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "MacAddress", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MacAddressError> payload = ::boost::static_pointer_cast<MacAddressError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((MacAddressCallbackIF*) _callback)->onMacAddressError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MacAddressUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "MacAddress", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MacAddressUpdate> payload = ::boost::static_pointer_cast<MacAddressUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((MacAddressCallbackIF*) _callback)->onMacAddressUpdate(proxyShared, payload);
                        proxyShared->_macAddress = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_PowerState:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PowerStateError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PowerState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PowerStateError> payload = ::boost::static_pointer_cast<PowerStateError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((PowerStateCallbackIF*) _callback)->onPowerStateError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PowerStateUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PowerState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PowerStateUpdate> payload = ::boost::static_pointer_cast<PowerStateUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((PowerStateCallbackIF*) _callback)->onPowerStateUpdate(proxyShared, payload);
                        proxyShared->_powerState = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_PowerFailureReason:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PowerFailureReasonError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PowerFailureReason", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PowerFailureReasonError> payload = ::boost::static_pointer_cast<PowerFailureReasonError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((PowerFailureReasonCallbackIF*) _callback)->onPowerFailureReasonError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PowerFailureReasonUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PowerFailureReason", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PowerFailureReasonUpdate> payload = ::boost::static_pointer_cast<PowerFailureReasonUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((PowerFailureReasonCallbackIF*) _callback)->onPowerFailureReasonUpdate(proxyShared, payload);
                        proxyShared->_powerFailureReason = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Frequency:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FrequencyError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Frequency", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<FrequencyError> payload = ::boost::static_pointer_cast<FrequencyError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((FrequencyCallbackIF*) _callback)->onFrequencyError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FrequencyUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Frequency", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<FrequencyUpdate> payload = ::boost::static_pointer_cast<FrequencyUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((FrequencyCallbackIF*) _callback)->onFrequencyUpdate(proxyShared, payload);
                        proxyShared->_frequency = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_CurrentOperatingChannel:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CurrentOperatingChannelError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CurrentOperatingChannel", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CurrentOperatingChannelError> payload = ::boost::static_pointer_cast<CurrentOperatingChannelError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((CurrentOperatingChannelCallbackIF*) _callback)->onCurrentOperatingChannelError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CurrentOperatingChannelUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CurrentOperatingChannel", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CurrentOperatingChannelUpdate> payload = ::boost::static_pointer_cast<CurrentOperatingChannelUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((CurrentOperatingChannelCallbackIF*) _callback)->onCurrentOperatingChannelUpdate(proxyShared, payload);
                        proxyShared->_currentOperatingChannel = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_APConfig:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), APConfigError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "APConfig", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<APConfigError> payload = ::boost::static_pointer_cast<APConfigError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((APConfigCallbackIF*) _callback)->onAPConfigError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), APConfigUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "APConfig", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<APConfigUpdate> payload = ::boost::static_pointer_cast<APConfigUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((APConfigCallbackIF*) _callback)->onAPConfigUpdate(proxyShared, payload);
                        proxyShared->_aPConfig = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Restrictions:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RestrictionsError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Restrictions", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RestrictionsError> payload = ::boost::static_pointer_cast<RestrictionsError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((RestrictionsCallbackIF*) _callback)->onRestrictionsError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RestrictionsUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Restrictions", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RestrictionsUpdate> payload = ::boost::static_pointer_cast<RestrictionsUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((RestrictionsCallbackIF*) _callback)->onRestrictionsUpdate(proxyShared, payload);
                        proxyShared->_restrictions = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_SupportedFrequencies:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SupportedFrequenciesError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SupportedFrequencies", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SupportedFrequenciesError> payload = ::boost::static_pointer_cast<SupportedFrequenciesError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((SupportedFrequenciesCallbackIF*) _callback)->onSupportedFrequenciesError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SupportedFrequenciesUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SupportedFrequencies", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SupportedFrequenciesUpdate> payload = ::boost::static_pointer_cast<SupportedFrequenciesUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((SupportedFrequenciesCallbackIF*) _callback)->onSupportedFrequenciesUpdate(proxyShared, payload);
                        proxyShared->_supportedFrequencies = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_IPv4Configuration:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), IPv4ConfigurationError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "IPv4Configuration", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<IPv4ConfigurationError> payload = ::boost::static_pointer_cast<IPv4ConfigurationError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((IPv4ConfigurationCallbackIF*) _callback)->onIPv4ConfigurationError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), IPv4ConfigurationUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "IPv4Configuration", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<IPv4ConfigurationUpdate> payload = ::boost::static_pointer_cast<IPv4ConfigurationUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((IPv4ConfigurationCallbackIF*) _callback)->onIPv4ConfigurationUpdate(proxyShared, payload);
                        proxyShared->_iPv4Configuration = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_ConnectionStatus:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ConnectionStatusError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ConnectionStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ConnectionStatusError> payload = ::boost::static_pointer_cast<ConnectionStatusError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ConnectionStatusCallbackIF*) _callback)->onConnectionStatusError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ConnectionStatusUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ConnectionStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ConnectionStatusUpdate> payload = ::boost::static_pointer_cast<ConnectionStatusUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ConnectionStatusCallbackIF*) _callback)->onConnectionStatusUpdate(proxyShared, payload);
                        proxyShared->_connectionStatus = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_DeAuthenticateStation:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), DeAuthenticateStationError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DeAuthenticateStation", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DeAuthenticateStationError> payload = ::boost::static_pointer_cast<DeAuthenticateStationError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DeAuthenticateStationCallbackIF*) _callback)->onDeAuthenticateStationError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DeAuthenticateStationResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "DeAuthenticateStation", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DeAuthenticateStationResponse> payload = ::boost::static_pointer_cast<DeAuthenticateStationResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DeAuthenticateStationCallbackIF*) _callback)->onDeAuthenticateStationResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ManageBandwidth:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ManageBandwidthError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ManageBandwidth", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ManageBandwidthError> payload = ::boost::static_pointer_cast<ManageBandwidthError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ManageBandwidthCallbackIF*) _callback)->onManageBandwidthError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ManageBandwidthResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ManageBandwidth", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ManageBandwidthResponse> payload = ::boost::static_pointer_cast<ManageBandwidthResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ManageBandwidthCallbackIF*) _callback)->onManageBandwidthResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_SetRestrictions:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetRestrictionsError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetRestrictions", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetRestrictionsError> payload = ::boost::static_pointer_cast<SetRestrictionsError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetRestrictionsCallbackIF*) _callback)->onSetRestrictionsError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetRestrictionsResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetRestrictions", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetRestrictionsResponse> payload = ::boost::static_pointer_cast<SetRestrictionsResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetRestrictionsCallbackIF*) _callback)->onSetRestrictionsResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_RestoreFactorySettings:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), RestoreFactorySettingsError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RestoreFactorySettings", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RestoreFactorySettingsError> payload = ::boost::static_pointer_cast<RestoreFactorySettingsError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RestoreFactorySettingsCallbackIF*) _callback)->onRestoreFactorySettingsError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RestoreFactorySettingsResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "RestoreFactorySettings", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RestoreFactorySettingsResponse> payload = ::boost::static_pointer_cast<RestoreFactorySettingsResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RestoreFactorySettingsCallbackIF*) _callback)->onRestoreFactorySettingsResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_Mode: {
                ::boost::shared_ptr< ModeError > payload = ::boost::shared_ptr< ModeError >
                (new ModeError(DBUS_ERROR_NO_SERVER, "The DBus service Wifisetup is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Mode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<WifisetupProxy> proxyShared = ::boost::static_pointer_cast<WifisetupProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ModeCallbackIF*) _callback)->onModeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Interface: {
                ::boost::shared_ptr< InterfaceError > payload = ::boost::shared_ptr< InterfaceError >
                (new InterfaceError(DBUS_ERROR_NO_SERVER, "The DBus service Wifisetup is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Interface", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<WifisetupProxy> proxyShared = ::boost::static_pointer_cast<WifisetupProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((InterfaceCallbackIF*) _callback)->onInterfaceError (proxyShared,payload);
                return true;
            }
            break;
            case ID_MacAddress: {
                ::boost::shared_ptr< MacAddressError > payload = ::boost::shared_ptr< MacAddressError >
                (new MacAddressError(DBUS_ERROR_NO_SERVER, "The DBus service Wifisetup is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "MacAddress", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<WifisetupProxy> proxyShared = ::boost::static_pointer_cast<WifisetupProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((MacAddressCallbackIF*) _callback)->onMacAddressError (proxyShared,payload);
                return true;
            }
            break;
            case ID_PowerState: {
                ::boost::shared_ptr< PowerStateError > payload = ::boost::shared_ptr< PowerStateError >
                (new PowerStateError(DBUS_ERROR_NO_SERVER, "The DBus service Wifisetup is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "PowerState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<WifisetupProxy> proxyShared = ::boost::static_pointer_cast<WifisetupProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PowerStateCallbackIF*) _callback)->onPowerStateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_PowerFailureReason: {
                ::boost::shared_ptr< PowerFailureReasonError > payload = ::boost::shared_ptr< PowerFailureReasonError >
                (new PowerFailureReasonError(DBUS_ERROR_NO_SERVER, "The DBus service Wifisetup is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "PowerFailureReason", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<WifisetupProxy> proxyShared = ::boost::static_pointer_cast<WifisetupProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PowerFailureReasonCallbackIF*) _callback)->onPowerFailureReasonError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Frequency: {
                ::boost::shared_ptr< FrequencyError > payload = ::boost::shared_ptr< FrequencyError >
                (new FrequencyError(DBUS_ERROR_NO_SERVER, "The DBus service Wifisetup is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Frequency", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<WifisetupProxy> proxyShared = ::boost::static_pointer_cast<WifisetupProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((FrequencyCallbackIF*) _callback)->onFrequencyError (proxyShared,payload);
                return true;
            }
            break;
            case ID_CurrentOperatingChannel: {
                ::boost::shared_ptr< CurrentOperatingChannelError > payload = ::boost::shared_ptr< CurrentOperatingChannelError >
                (new CurrentOperatingChannelError(DBUS_ERROR_NO_SERVER, "The DBus service Wifisetup is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CurrentOperatingChannel", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<WifisetupProxy> proxyShared = ::boost::static_pointer_cast<WifisetupProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CurrentOperatingChannelCallbackIF*) _callback)->onCurrentOperatingChannelError (proxyShared,payload);
                return true;
            }
            break;
            case ID_APConfig: {
                ::boost::shared_ptr< APConfigError > payload = ::boost::shared_ptr< APConfigError >
                (new APConfigError(DBUS_ERROR_NO_SERVER, "The DBus service Wifisetup is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "APConfig", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<WifisetupProxy> proxyShared = ::boost::static_pointer_cast<WifisetupProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((APConfigCallbackIF*) _callback)->onAPConfigError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Restrictions: {
                ::boost::shared_ptr< RestrictionsError > payload = ::boost::shared_ptr< RestrictionsError >
                (new RestrictionsError(DBUS_ERROR_NO_SERVER, "The DBus service Wifisetup is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Restrictions", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<WifisetupProxy> proxyShared = ::boost::static_pointer_cast<WifisetupProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RestrictionsCallbackIF*) _callback)->onRestrictionsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SupportedFrequencies: {
                ::boost::shared_ptr< SupportedFrequenciesError > payload = ::boost::shared_ptr< SupportedFrequenciesError >
                (new SupportedFrequenciesError(DBUS_ERROR_NO_SERVER, "The DBus service Wifisetup is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SupportedFrequencies", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<WifisetupProxy> proxyShared = ::boost::static_pointer_cast<WifisetupProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SupportedFrequenciesCallbackIF*) _callback)->onSupportedFrequenciesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_IPv4Configuration: {
                ::boost::shared_ptr< IPv4ConfigurationError > payload = ::boost::shared_ptr< IPv4ConfigurationError >
                (new IPv4ConfigurationError(DBUS_ERROR_NO_SERVER, "The DBus service Wifisetup is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "IPv4Configuration", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<WifisetupProxy> proxyShared = ::boost::static_pointer_cast<WifisetupProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((IPv4ConfigurationCallbackIF*) _callback)->onIPv4ConfigurationError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ConnectionStatus: {
                ::boost::shared_ptr< ConnectionStatusError > payload = ::boost::shared_ptr< ConnectionStatusError >
                (new ConnectionStatusError(DBUS_ERROR_NO_SERVER, "The DBus service Wifisetup is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ConnectionStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<WifisetupProxy> proxyShared = ::boost::static_pointer_cast<WifisetupProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ConnectionStatusCallbackIF*) _callback)->onConnectionStatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_DeAuthenticateStation: {
                ::boost::shared_ptr< DeAuthenticateStationError > payload = ::boost::shared_ptr< DeAuthenticateStationError >
                (new DeAuthenticateStationError(DBUS_ERROR_NO_SERVER, "The DBus service Wifisetup is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DeAuthenticateStation", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<WifisetupProxy> proxyShared = ::boost::static_pointer_cast<WifisetupProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DeAuthenticateStationCallbackIF*) _callback)->onDeAuthenticateStationError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ManageBandwidth: {
                ::boost::shared_ptr< ManageBandwidthError > payload = ::boost::shared_ptr< ManageBandwidthError >
                (new ManageBandwidthError(DBUS_ERROR_NO_SERVER, "The DBus service Wifisetup is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ManageBandwidth", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<WifisetupProxy> proxyShared = ::boost::static_pointer_cast<WifisetupProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ManageBandwidthCallbackIF*) _callback)->onManageBandwidthError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SetRestrictions: {
                ::boost::shared_ptr< SetRestrictionsError > payload = ::boost::shared_ptr< SetRestrictionsError >
                (new SetRestrictionsError(DBUS_ERROR_NO_SERVER, "The DBus service Wifisetup is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetRestrictions", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<WifisetupProxy> proxyShared = ::boost::static_pointer_cast<WifisetupProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetRestrictionsCallbackIF*) _callback)->onSetRestrictionsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RestoreFactorySettings: {
                ::boost::shared_ptr< RestoreFactorySettingsError > payload = ::boost::shared_ptr< RestoreFactorySettingsError >
                (new RestoreFactorySettingsError(DBUS_ERROR_NO_SERVER, "The DBus service Wifisetup is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RestoreFactorySettings", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<WifisetupProxy> proxyShared = ::boost::static_pointer_cast<WifisetupProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RestoreFactorySettingsCallbackIF*) _callback)->onRestoreFactorySettingsError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& WifisetupProxyCallback::_logger (WifisetupProxy::_logger);

WifisetupProxy::WifisetupProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.bosch.wbl.wifisetup", serviceAvailable, _logger) {
}

WifisetupProxy::~WifisetupProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< WifisetupProxy > WifisetupProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<WifisetupProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< WifisetupProxy > proxyNew(new WifisetupProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t WifisetupProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    WifisetupProxyCallback* callback = new WifisetupProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t WifisetupProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    WifisetupProxyCallback* callback = new WifisetupProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void WifisetupProxy::clearAllProperties ()
{
    _mode = ::asf::core::nullable< ModeUpdate >();
    _interface = ::asf::core::nullable< InterfaceUpdate >();
    _macAddress = ::asf::core::nullable< MacAddressUpdate >();
    _powerState = ::asf::core::nullable< PowerStateUpdate >();
    _powerFailureReason = ::asf::core::nullable< PowerFailureReasonUpdate >();
    _frequency = ::asf::core::nullable< FrequencyUpdate >();
    _currentOperatingChannel = ::asf::core::nullable< CurrentOperatingChannelUpdate >();
    _aPConfig = ::asf::core::nullable< APConfigUpdate >();
    _restrictions = ::asf::core::nullable< RestrictionsUpdate >();
    _supportedFrequencies = ::asf::core::nullable< SupportedFrequenciesUpdate >();
    _iPv4Configuration = ::asf::core::nullable< IPv4ConfigurationUpdate >();
    _connectionStatus = ::asf::core::nullable< ConnectionStatusUpdate >();
}

void WifisetupProxy::sendDeregisterAll () const
{
    sendModeDeregisterAll();
    sendInterfaceDeregisterAll();
    sendMacAddressDeregisterAll();
    sendPowerStateDeregisterAll();
    sendPowerFailureReasonDeregisterAll();
    sendFrequencyDeregisterAll();
    sendCurrentOperatingChannelDeregisterAll();
    sendAPConfigDeregisterAll();
    sendRestrictionsDeregisterAll();
    sendSupportedFrequenciesDeregisterAll();
    sendIPv4ConfigurationDeregisterAll();
    sendConnectionStatusDeregisterAll();
}

act_t WifisetupProxy::sendModeRegister(ModeCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Mode, "Mode", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Mode", &cb, act);
    return act;
}

bool WifisetupProxy::sendModeDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Mode", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Mode", act, static_cast<int>(rv));
    return rv;
}

act_t WifisetupProxy::sendModeGet(ModeCallbackIF& cb) {
    WifisetupProxyCallback* callback = new WifisetupProxyCallback(ID_Mode, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Mode", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Mode", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& WifisetupProxy::getMode() const {
    return _mode.get().getMode();
}

bool WifisetupProxy::hasMode() const {
    return _mode.hasValue();
}

void WifisetupProxy::sendModeDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Mode");
    _dbusProxyDelegate->deregisterSignalCallback("Mode", 0, _dbusDaemonProxy.get(), true);
}

act_t WifisetupProxy::sendInterfaceRegister(InterfaceCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Interface, "Interface", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Interface", &cb, act);
    return act;
}

bool WifisetupProxy::sendInterfaceDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Interface", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Interface", act, static_cast<int>(rv));
    return rv;
}

act_t WifisetupProxy::sendInterfaceGet(InterfaceCallbackIF& cb) {
    WifisetupProxyCallback* callback = new WifisetupProxyCallback(ID_Interface, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Interface", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Interface", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& WifisetupProxy::getInterface() const {
    return _interface.get().getInterface();
}

bool WifisetupProxy::hasInterface() const {
    return _interface.hasValue();
}

void WifisetupProxy::sendInterfaceDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Interface");
    _dbusProxyDelegate->deregisterSignalCallback("Interface", 0, _dbusDaemonProxy.get(), true);
}

act_t WifisetupProxy::sendMacAddressRegister(MacAddressCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_MacAddress, "MacAddress", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "MacAddress", &cb, act);
    return act;
}

bool WifisetupProxy::sendMacAddressDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("MacAddress", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "MacAddress", act, static_cast<int>(rv));
    return rv;
}

act_t WifisetupProxy::sendMacAddressGet(MacAddressCallbackIF& cb) {
    WifisetupProxyCallback* callback = new WifisetupProxyCallback(ID_MacAddress, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "MacAddress", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("MacAddress", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& WifisetupProxy::getMacAddress() const {
    return _macAddress.get().getMacAddress();
}

bool WifisetupProxy::hasMacAddress() const {
    return _macAddress.hasValue();
}

void WifisetupProxy::sendMacAddressDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "MacAddress");
    _dbusProxyDelegate->deregisterSignalCallback("MacAddress", 0, _dbusDaemonProxy.get(), true);
}

act_t WifisetupProxy::sendPowerStateRegister(PowerStateCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_PowerState, "PowerState", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "PowerState", &cb, act);
    return act;
}

bool WifisetupProxy::sendPowerStateDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("PowerState", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "PowerState", act, static_cast<int>(rv));
    return rv;
}

act_t WifisetupProxy::sendPowerStateGet(PowerStateCallbackIF& cb) {
    WifisetupProxyCallback* callback = new WifisetupProxyCallback(ID_PowerState, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "PowerState", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("PowerState", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& WifisetupProxy::getPowerState() const {
    return _powerState.get().getPowerState();
}

bool WifisetupProxy::hasPowerState() const {
    return _powerState.hasValue();
}

void WifisetupProxy::sendPowerStateDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "PowerState");
    _dbusProxyDelegate->deregisterSignalCallback("PowerState", 0, _dbusDaemonProxy.get(), true);
}

act_t WifisetupProxy::sendPowerFailureReasonRegister(PowerFailureReasonCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_PowerFailureReason, "PowerFailureReason", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "PowerFailureReason", &cb, act);
    return act;
}

bool WifisetupProxy::sendPowerFailureReasonDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("PowerFailureReason", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "PowerFailureReason", act, static_cast<int>(rv));
    return rv;
}

act_t WifisetupProxy::sendPowerFailureReasonGet(PowerFailureReasonCallbackIF& cb) {
    WifisetupProxyCallback* callback = new WifisetupProxyCallback(ID_PowerFailureReason, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "PowerFailureReason", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("PowerFailureReason", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& WifisetupProxy::getPowerFailureReason() const {
    return _powerFailureReason.get().getPowerFailureReason();
}

bool WifisetupProxy::hasPowerFailureReason() const {
    return _powerFailureReason.hasValue();
}

void WifisetupProxy::sendPowerFailureReasonDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "PowerFailureReason");
    _dbusProxyDelegate->deregisterSignalCallback("PowerFailureReason", 0, _dbusDaemonProxy.get(), true);
}

act_t WifisetupProxy::sendFrequencyRegister(FrequencyCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Frequency, "Frequency", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Frequency", &cb, act);
    return act;
}

bool WifisetupProxy::sendFrequencyDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Frequency", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Frequency", act, static_cast<int>(rv));
    return rv;
}

act_t WifisetupProxy::sendFrequencyGet(FrequencyCallbackIF& cb) {
    WifisetupProxyCallback* callback = new WifisetupProxyCallback(ID_Frequency, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Frequency", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Frequency", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& WifisetupProxy::getFrequency() const {
    return _frequency.get().getFrequency();
}

bool WifisetupProxy::hasFrequency() const {
    return _frequency.hasValue();
}

void WifisetupProxy::sendFrequencyDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Frequency");
    _dbusProxyDelegate->deregisterSignalCallback("Frequency", 0, _dbusDaemonProxy.get(), true);
}

act_t WifisetupProxy::sendCurrentOperatingChannelRegister(CurrentOperatingChannelCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_CurrentOperatingChannel, "CurrentOperatingChannel", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "CurrentOperatingChannel", &cb, act);
    return act;
}

bool WifisetupProxy::sendCurrentOperatingChannelDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("CurrentOperatingChannel", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "CurrentOperatingChannel", act, static_cast<int>(rv));
    return rv;
}

act_t WifisetupProxy::sendCurrentOperatingChannelGet(CurrentOperatingChannelCallbackIF& cb) {
    WifisetupProxyCallback* callback = new WifisetupProxyCallback(ID_CurrentOperatingChannel, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "CurrentOperatingChannel", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("CurrentOperatingChannel", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


int32 WifisetupProxy::getCurrentOperatingChannel() const {
    return _currentOperatingChannel.get().getCurrentOperatingChannel();
}

bool WifisetupProxy::hasCurrentOperatingChannel() const {
    return _currentOperatingChannel.hasValue();
}

void WifisetupProxy::sendCurrentOperatingChannelDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "CurrentOperatingChannel");
    _dbusProxyDelegate->deregisterSignalCallback("CurrentOperatingChannel", 0, _dbusDaemonProxy.get(), true);
}

act_t WifisetupProxy::sendAPConfigRegister(APConfigCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_APConfig, "APConfig", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "APConfig", &cb, act);
    return act;
}

bool WifisetupProxy::sendAPConfigDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("APConfig", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "APConfig", act, static_cast<int>(rv));
    return rv;
}

act_t WifisetupProxy::sendAPConfigGet(APConfigCallbackIF& cb) {
    WifisetupProxyCallback* callback = new WifisetupProxyCallback(ID_APConfig, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "APConfig", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("APConfig", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& WifisetupProxy::getAPConfig() const {
    return _aPConfig.get().getAPConfig();
}

bool WifisetupProxy::hasAPConfig() const {
    return _aPConfig.hasValue();
}

void WifisetupProxy::sendAPConfigDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "APConfig");
    _dbusProxyDelegate->deregisterSignalCallback("APConfig", 0, _dbusDaemonProxy.get(), true);
}

act_t WifisetupProxy::sendRestrictionsRegister(RestrictionsCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Restrictions, "Restrictions", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Restrictions", &cb, act);
    return act;
}

bool WifisetupProxy::sendRestrictionsDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Restrictions", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Restrictions", act, static_cast<int>(rv));
    return rv;
}

act_t WifisetupProxy::sendRestrictionsGet(RestrictionsCallbackIF& cb) {
    WifisetupProxyCallback* callback = new WifisetupProxyCallback(ID_Restrictions, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Restrictions", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Restrictions", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& WifisetupProxy::getRestrictions() const {
    return _restrictions.get().getRestrictions();
}

bool WifisetupProxy::hasRestrictions() const {
    return _restrictions.hasValue();
}

void WifisetupProxy::sendRestrictionsDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Restrictions");
    _dbusProxyDelegate->deregisterSignalCallback("Restrictions", 0, _dbusDaemonProxy.get(), true);
}

act_t WifisetupProxy::sendSupportedFrequenciesRegister(SupportedFrequenciesCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_SupportedFrequencies, "SupportedFrequencies", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SupportedFrequencies", &cb, act);
    return act;
}

bool WifisetupProxy::sendSupportedFrequenciesDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SupportedFrequencies", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SupportedFrequencies", act, static_cast<int>(rv));
    return rv;
}

act_t WifisetupProxy::sendSupportedFrequenciesGet(SupportedFrequenciesCallbackIF& cb) {
    WifisetupProxyCallback* callback = new WifisetupProxyCallback(ID_SupportedFrequencies, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "SupportedFrequencies", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("SupportedFrequencies", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& WifisetupProxy::getSupportedFrequencies() const {
    return _supportedFrequencies.get().getSupportedFrequencies();
}

bool WifisetupProxy::hasSupportedFrequencies() const {
    return _supportedFrequencies.hasValue();
}

void WifisetupProxy::sendSupportedFrequenciesDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SupportedFrequencies");
    _dbusProxyDelegate->deregisterSignalCallback("SupportedFrequencies", 0, _dbusDaemonProxy.get(), true);
}

act_t WifisetupProxy::sendIPv4ConfigurationRegister(IPv4ConfigurationCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_IPv4Configuration, "IPv4Configuration", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "IPv4Configuration", &cb, act);
    return act;
}

bool WifisetupProxy::sendIPv4ConfigurationDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("IPv4Configuration", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "IPv4Configuration", act, static_cast<int>(rv));
    return rv;
}

act_t WifisetupProxy::sendIPv4ConfigurationGet(IPv4ConfigurationCallbackIF& cb) {
    WifisetupProxyCallback* callback = new WifisetupProxyCallback(ID_IPv4Configuration, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "IPv4Configuration", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("IPv4Configuration", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& WifisetupProxy::getIPv4Configuration() const {
    return _iPv4Configuration.get().getIPv4Configuration();
}

bool WifisetupProxy::hasIPv4Configuration() const {
    return _iPv4Configuration.hasValue();
}

void WifisetupProxy::sendIPv4ConfigurationDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "IPv4Configuration");
    _dbusProxyDelegate->deregisterSignalCallback("IPv4Configuration", 0, _dbusDaemonProxy.get(), true);
}

act_t WifisetupProxy::sendConnectionStatusRegister(ConnectionStatusCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_ConnectionStatus, "ConnectionStatus", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ConnectionStatus", &cb, act);
    return act;
}

bool WifisetupProxy::sendConnectionStatusDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ConnectionStatus", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ConnectionStatus", act, static_cast<int>(rv));
    return rv;
}

act_t WifisetupProxy::sendConnectionStatusGet(ConnectionStatusCallbackIF& cb) {
    WifisetupProxyCallback* callback = new WifisetupProxyCallback(ID_ConnectionStatus, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ConnectionStatus", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("ConnectionStatus", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& WifisetupProxy::getConnectionStatus() const {
    return _connectionStatus.get().getConnectionStatus();
}

bool WifisetupProxy::hasConnectionStatus() const {
    return _connectionStatus.hasValue();
}

void WifisetupProxy::sendConnectionStatusDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ConnectionStatus");
    _dbusProxyDelegate->deregisterSignalCallback("ConnectionStatus", 0, _dbusDaemonProxy.get(), true);
}

act_t WifisetupProxy::sendDeAuthenticateStationRequest(DeAuthenticateStationCallbackIF& cb, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& station) const {
    DeAuthenticateStationRequest* payload = new DeAuthenticateStationRequest();
    CHECK_ALLOCATION(payload);
    payload->setStation(station);
    DBUS_MESSAGE_CALL(dbusMessage, "DeAuthenticateStation", DeAuthenticateStationRequest, payload, true)
    act_t act = addMethodCallback(ID_DeAuthenticateStation, dbusMessage.getUniqueSerial(), "DeAuthenticateStation", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "DeAuthenticateStation", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t WifisetupProxy::sendManageBandwidthRequest(ManageBandwidthCallbackIF& cb, bool allocate, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& station) const {
    ManageBandwidthRequest* payload = new ManageBandwidthRequest();
    CHECK_ALLOCATION(payload);
    payload->setAllocate(allocate);
    payload->setStation(station);
    DBUS_MESSAGE_CALL(dbusMessage, "ManageBandwidth", ManageBandwidthRequest, payload, true)
    act_t act = addMethodCallback(ID_ManageBandwidth, dbusMessage.getUniqueSerial(), "ManageBandwidth", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ManageBandwidth", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t WifisetupProxy::sendSetRestrictionsRequest(SetRestrictionsCallbackIF& cb, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& technology, const ::std::string& restrict) const {
    SetRestrictionsRequest* payload = new SetRestrictionsRequest();
    CHECK_ALLOCATION(payload);
    payload->setTechnology(technology);
    payload->setRestrict(restrict);
    DBUS_MESSAGE_CALL(dbusMessage, "SetRestrictions", SetRestrictionsRequest, payload, true)
    act_t act = addMethodCallback(ID_SetRestrictions, dbusMessage.getUniqueSerial(), "SetRestrictions", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetRestrictions", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t WifisetupProxy::sendRestoreFactorySettingsRequest(RestoreFactorySettingsCallbackIF& cb) const {
    RestoreFactorySettingsRequest* payload = new RestoreFactorySettingsRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "RestoreFactorySettings", RestoreFactorySettingsRequest, payload, true)
    act_t act = addMethodCallback(ID_RestoreFactorySettings, dbusMessage.getUniqueSerial(), "RestoreFactorySettings", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "RestoreFactorySettings", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace wifisetup
} // namespace wbl
} // namespace bosch
} // namespace org
