/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_WBL_CONFLICTMANAGEMENTPROXY_H
#define ORG_BOSCH_WBL_CONFLICTMANAGEMENTPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "org/bosch/wbl/conflictmanagement.h"
#include <dbus/dbus.h>
#include <map>
#include <string>
#include <vector>

namespace org {
namespace bosch {
namespace wbl {
namespace conflictmanagement {

class ConflictmanagementProxy;

class ActiveWiFiSetupsCallbackIF {
public:
    virtual ~ActiveWiFiSetupsCallbackIF() {}

    virtual void onActiveWiFiSetupsError(const ::boost::shared_ptr< ConflictmanagementProxy >& proxy, const ::boost::shared_ptr< ActiveWiFiSetupsError >& error) = 0;

    virtual void onActiveWiFiSetupsUpdate(const ::boost::shared_ptr< ConflictmanagementProxy >& proxy, const ::boost::shared_ptr< ActiveWiFiSetupsUpdate >& update) = 0;
};

class ConfigurationTimerCallbackIF {
public:
    virtual ~ConfigurationTimerCallbackIF() {}

    virtual void onConfigurationTimerError(const ::boost::shared_ptr< ConflictmanagementProxy >& proxy, const ::boost::shared_ptr< ConfigurationTimerError >& error) = 0;

    virtual void onConfigurationTimerUpdate(const ::boost::shared_ptr< ConflictmanagementProxy >& proxy, const ::boost::shared_ptr< ConfigurationTimerUpdate >& update) = 0;
};

class ConflictDetectedCallbackIF {
public:
    virtual ~ConflictDetectedCallbackIF() {}

    virtual void onConflictDetectedError(const ::boost::shared_ptr< ConflictmanagementProxy >& proxy, const ::boost::shared_ptr< ConflictDetectedError >& error) = 0;

    virtual void onConflictDetectedSignal(const ::boost::shared_ptr< ConflictmanagementProxy >& proxy, const ::boost::shared_ptr< ConflictDetectedSignal >& signal) = 0;
};

class ConflictResolvedCallbackIF {
public:
    virtual ~ConflictResolvedCallbackIF() {}

    virtual void onConflictResolvedError(const ::boost::shared_ptr< ConflictmanagementProxy >& proxy, const ::boost::shared_ptr< ConflictResolvedError >& error) = 0;

    virtual void onConflictResolvedSignal(const ::boost::shared_ptr< ConflictmanagementProxy >& proxy, const ::boost::shared_ptr< ConflictResolvedSignal >& signal) = 0;
};

class DeActivateSetupCallbackIF {
public:
    virtual ~DeActivateSetupCallbackIF() {}

    virtual void onDeActivateSetupError(const ::boost::shared_ptr< ConflictmanagementProxy >& proxy, const ::boost::shared_ptr< DeActivateSetupError >& error) = 0;

    virtual void onDeActivateSetupResponse(const ::boost::shared_ptr< ConflictmanagementProxy >& proxy, const ::boost::shared_ptr< DeActivateSetupResponse >& response) = 0;
};

class PrepareSetupCallbackIF {
public:
    virtual ~PrepareSetupCallbackIF() {}

    virtual void onPrepareSetupError(const ::boost::shared_ptr< ConflictmanagementProxy >& proxy, const ::boost::shared_ptr< PrepareSetupError >& error) = 0;

    virtual void onPrepareSetupResponse(const ::boost::shared_ptr< ConflictmanagementProxy >& proxy, const ::boost::shared_ptr< PrepareSetupResponse >& response) = 0;
};

class ResolveConflictCallbackIF {
public:
    virtual ~ResolveConflictCallbackIF() {}

    virtual void onResolveConflictError(const ::boost::shared_ptr< ConflictmanagementProxy >& proxy, const ::boost::shared_ptr< ResolveConflictError >& error) = 0;

    virtual void onResolveConflictResponse(const ::boost::shared_ptr< ConflictmanagementProxy >& proxy, const ::boost::shared_ptr< ResolveConflictResponse >& response) = 0;
};

class WiFiPriorityListCallbackIF {
public:
    virtual ~WiFiPriorityListCallbackIF() {}

    virtual void onWiFiPriorityListError(const ::boost::shared_ptr< ConflictmanagementProxy >& proxy, const ::boost::shared_ptr< WiFiPriorityListError >& error) = 0;

    virtual void onWiFiPriorityListUpdate(const ::boost::shared_ptr< ConflictmanagementProxy >& proxy, const ::boost::shared_ptr< WiFiPriorityListUpdate >& update) = 0;
};

class WiFiStationModeUsageCallbackIF {
public:
    virtual ~WiFiStationModeUsageCallbackIF() {}

    virtual void onWiFiStationModeUsageError(const ::boost::shared_ptr< ConflictmanagementProxy >& proxy, const ::boost::shared_ptr< WiFiStationModeUsageError >& error) = 0;

    virtual void onWiFiStationModeUsageResponse(const ::boost::shared_ptr< ConflictmanagementProxy >& proxy, const ::boost::shared_ptr< WiFiStationModeUsageResponse >& response) = 0;
};


/**
 * ConflictmanagementProxy is the client side representation of the D-Bus
 * service interface 'org.bosch.wbl.conflictmanagement' (specified in file
 * org-bosch-wbl-conflictmanagement.xml).
 *
 * If the meaning of "org.bosch.wbl.conflictmanagement" isn't clear, then there should be a description here.
 */
class ConflictmanagementProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of ConflictmanagementProxy.
     */
    static ::boost::shared_ptr< ConflictmanagementProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of ConflictmanagementProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< ConflictmanagementProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of ConflictmanagementProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< ConflictmanagementProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< ConflictmanagementProxy > proxyNew(new ConflictmanagementProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(true);
        return proxyNew;
    }

    virtual ~ConflictmanagementProxy ();


    // Signal 'ConflictDetected'

    /**
     * Notify on the signal 'ConflictDetected'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'ConflictDetected'</b>:
     *
     * If the meaning of "ConflictDetected" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConflictDetectedRegister(ConflictDetectedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'ConflictDetected'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'ConflictDetected'</b>:
     *
     * If the meaning of "ConflictDetected" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendConflictDetectedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendConflictDetectedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'ConflictDetected'.
     */
    void sendConflictDetectedDeregisterAll () const;

    // Signal 'ConflictResolved'

    /**
     * Notify on the signal 'ConflictResolved'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'ConflictResolved'</b>:
     *
     * If the meaning of "ConflictResolved" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConflictResolvedRegister(ConflictResolvedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'ConflictResolved'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'ConflictResolved'</b>:
     *
     * If the meaning of "ConflictResolved" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendConflictResolvedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendConflictResolvedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'ConflictResolved'.
     */
    void sendConflictResolvedDeregisterAll () const;


    // Property 'ActiveWiFiSetups'

    /**
     * Notify on the property 'ActiveWiFiSetups'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'ActiveWiFiSetups'</b>:
     *
     * If the meaning of "ActiveWiFiSetups" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendActiveWiFiSetupsRegister(ActiveWiFiSetupsCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'ActiveWiFiSetups'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'ActiveWiFiSetups'</b>:
     *
     * If the meaning of "ActiveWiFiSetups" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendActiveWiFiSetupsRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendActiveWiFiSetupsDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'ActiveWiFiSetups'.
     */
    void sendActiveWiFiSetupsDeregisterAll() const;

    /**
     * Request the value of the property 'ActiveWiFiSetups' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'ActiveWiFiSetups'</b>:
     *
     * If the meaning of "ActiveWiFiSetups" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendActiveWiFiSetupsGet(ActiveWiFiSetupsCallbackIF& cb);


    /**
     * Returns the current value of the property 'ActiveWiFiSetups' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasActiveWiFiSetups() returns true.
     *
     * @return the previously received value of the property 'ActiveWiFiSetups'.
     */
    const ::std::vector< ActiveWiFiSetupsStruct >& getActiveWiFiSetups() const;

    /**
     * Determines whether a status message for the property 'ActiveWiFiSetups'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasActiveWiFiSetups() const;

    // Property 'WiFiPriorityList'

    /**
     * Notify on the property 'WiFiPriorityList'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'WiFiPriorityList'</b>:
     *
     * If the meaning of "WiFiPriorityList" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendWiFiPriorityListRegister(WiFiPriorityListCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'WiFiPriorityList'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'WiFiPriorityList'</b>:
     *
     * If the meaning of "WiFiPriorityList" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendWiFiPriorityListRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendWiFiPriorityListDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'WiFiPriorityList'.
     */
    void sendWiFiPriorityListDeregisterAll() const;

    /**
     * Request the value of the property 'WiFiPriorityList' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'WiFiPriorityList'</b>:
     *
     * If the meaning of "WiFiPriorityList" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendWiFiPriorityListGet(WiFiPriorityListCallbackIF& cb);

    /**
     * Set the value of the property 'WiFiPriorityList'. This method sends a
     * Set message to the D-Bus server.
     *
     * @deprecated use the sendWiFiPriorityListSet(WiFiPriorityListCallbackIF&
     * cb, const ::std::vector< ::std::string >& wiFiPriorityList) method
     * instead.
     *
     * <b>Documentation of 'WiFiPriorityList'</b>:
     *
     * If the meaning of "WiFiPriorityList" isn't clear, then there should be a description here.
     */
    void sendWiFiPriorityListSet(const ::std::vector< ::std::string >& wiFiPriorityList);

    /**
     * Set the value of the property 'WiFiPriorityList'. This method sends a
     * Set message to the D-Bus server.
     *
     * <b>Documentation of 'WiFiPriorityList'</b>:
     *
     * If the meaning of "WiFiPriorityList" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendWiFiPriorityListSet(WiFiPriorityListCallbackIF& cb, const ::std::vector< ::std::string >& wiFiPriorityList);

    /**
     * Returns the current value of the property 'WiFiPriorityList' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasWiFiPriorityList() returns true.
     *
     * @return the previously received value of the property 'WiFiPriorityList'.
     */
    const ::std::vector< ::std::string >& getWiFiPriorityList() const;

    /**
     * Determines whether a status message for the property 'WiFiPriorityList'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasWiFiPriorityList() const;

    // Property 'ConfigurationTimer'

    /**
     * Notify on the property 'ConfigurationTimer'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'ConfigurationTimer'</b>:
     *
     * If the meaning of "ConfigurationTimer" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConfigurationTimerRegister(ConfigurationTimerCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'ConfigurationTimer'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'ConfigurationTimer'</b>:
     *
     * If the meaning of "ConfigurationTimer" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendConfigurationTimerRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendConfigurationTimerDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'ConfigurationTimer'.
     */
    void sendConfigurationTimerDeregisterAll() const;

    /**
     * Request the value of the property 'ConfigurationTimer' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'ConfigurationTimer'</b>:
     *
     * If the meaning of "ConfigurationTimer" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConfigurationTimerGet(ConfigurationTimerCallbackIF& cb);

    /**
     * Set the value of the property 'ConfigurationTimer'. This method sends a
     * Set message to the D-Bus server.
     *
     * @deprecated use the
     * sendConfigurationTimerSet(ConfigurationTimerCallbackIF& cb, int32
     * configurationTimer) method instead.
     *
     * <b>Documentation of 'ConfigurationTimer'</b>:
     *
     * If the meaning of "ConfigurationTimer" isn't clear, then there should be a description here.
     */
    void sendConfigurationTimerSet(int32 configurationTimer);

    /**
     * Set the value of the property 'ConfigurationTimer'. This method sends a
     * Set message to the D-Bus server.
     *
     * <b>Documentation of 'ConfigurationTimer'</b>:
     *
     * If the meaning of "ConfigurationTimer" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConfigurationTimerSet(ConfigurationTimerCallbackIF& cb, int32 configurationTimer);

    /**
     * Returns the current value of the property 'ConfigurationTimer' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasConfigurationTimer() returns true.
     *
     * @return the previously received value of the property 'ConfigurationTimer'.
     */
    int32 getConfigurationTimer() const;

    /**
     * Determines whether a status message for the property
     * 'ConfigurationTimer' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasConfigurationTimer() const;


    // Method 'PrepareSetup'

    /**
     * Call the method 'PrepareSetup'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'PrepareSetup'</b>:
     *
     * If the meaning of "PrepareSetup" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param configuration If the meaning of "configuration" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPrepareSetupRequest(PrepareSetupCallbackIF& cb, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& configuration) const;

    // Method 'DeActivateSetup'

    /**
     * Call the method 'DeActivateSetup'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'DeActivateSetup'</b>:
     *
     * If the meaning of "DeActivateSetup" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param WiFiMode If the meaning of "WiFiMode" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDeActivateSetupRequest(DeActivateSetupCallbackIF& cb, const ::std::string& wiFiMode) const;

    // Method 'WiFiStationModeUsage'

    /**
     * Call the method 'WiFiStationModeUsage'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'WiFiStationModeUsage'</b>:
     *
     * If the meaning of "WiFiStationModeUsage" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param application If the meaning of "application" isn't clear, then there should be a description here.
     *
     * @param usage If the meaning of "usage" isn't clear, then there should be a description here.
     *
     * @param holding If the meaning of "holding" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendWiFiStationModeUsageRequest(WiFiStationModeUsageCallbackIF& cb, const ::std::string& application, const ::std::string& usage, bool holding) const;

    // Method 'ResolveConflict'

    /**
     * Call the method 'ResolveConflict'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'ResolveConflict'</b>:
     *
     * If the meaning of "ResolveConflict" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param conflictid If the meaning of "conflictid" isn't clear, then there should be a description here.
     *
     * @param action If the meaning of "action" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendResolveConflictRequest(ResolveConflictCallbackIF& cb, int32 conflictid, int32 action) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    ConflictmanagementProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;

    virtual void clearAllProperties ();

    // Property 'ActiveWiFiSetups'

    ::asf::core::nullable< ActiveWiFiSetupsUpdate > _activeWiFiSetups;

    // Property 'WiFiPriorityList'

    ::asf::core::nullable< WiFiPriorityListUpdate > _wiFiPriorityList;

    // Property 'ConfigurationTimer'

    ::asf::core::nullable< ConfigurationTimerUpdate > _configurationTimer;

    DECLARE_CLASS_LOGGER();

    friend class ConflictmanagementProxyCallback;
};

} // namespace conflictmanagement
} // namespace wbl
} // namespace bosch
} // namespace org

#endif // ORG_BOSCH_WBL_CONFLICTMANAGEMENTPROXY_H
