/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/wbl/conflictmanagement.h"
#include "org/bosch/wbl/conflictmanagementDBus.h"
#include "org/bosch/wbl/conflictmanagementJson.h"
#include "org/bosch/wbl/conflictmanagementProxy.h"
#include <map>
#include <string>
#include <vector>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bosch {
namespace wbl {
namespace conflictmanagement {

DEFINE_CLASS_LOGGER("//org/bosch/wbl/conflictmanagement/org/bosch/wbl/conflictmanagement", ConflictmanagementProxy);

class ConflictmanagementProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    ConflictmanagementProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< ConflictmanagementProxy >& proxyShared = ::boost::static_pointer_cast< ConflictmanagementProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_ConflictDetected:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ConflictDetectedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ConflictDetected", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<ConflictDetectedSignal> payload = ::boost::static_pointer_cast<ConflictDetectedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((ConflictDetectedCallbackIF*) _callback)->onConflictDetectedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_ConflictResolved:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ConflictResolvedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ConflictResolved", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<ConflictResolvedSignal> payload = ::boost::static_pointer_cast<ConflictResolvedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((ConflictResolvedCallbackIF*) _callback)->onConflictResolvedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_ActiveWiFiSetups:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ActiveWiFiSetupsError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ActiveWiFiSetups", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ActiveWiFiSetupsError> payload = ::boost::static_pointer_cast<ActiveWiFiSetupsError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ActiveWiFiSetupsCallbackIF*) _callback)->onActiveWiFiSetupsError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ActiveWiFiSetupsUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ActiveWiFiSetups", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ActiveWiFiSetupsUpdate> payload = ::boost::static_pointer_cast<ActiveWiFiSetupsUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ActiveWiFiSetupsCallbackIF*) _callback)->onActiveWiFiSetupsUpdate(proxyShared, payload);
                        proxyShared->_activeWiFiSetups = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_WiFiPriorityList:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), WiFiPriorityListError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "WiFiPriorityList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<WiFiPriorityListError> payload = ::boost::static_pointer_cast<WiFiPriorityListError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((WiFiPriorityListCallbackIF*) _callback)->onWiFiPriorityListError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), WiFiPriorityListUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "WiFiPriorityList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<WiFiPriorityListUpdate> payload = ::boost::static_pointer_cast<WiFiPriorityListUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((WiFiPriorityListCallbackIF*) _callback)->onWiFiPriorityListUpdate(proxyShared, payload);
                        proxyShared->_wiFiPriorityList = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_ConfigurationTimer:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ConfigurationTimerError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ConfigurationTimer", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ConfigurationTimerError> payload = ::boost::static_pointer_cast<ConfigurationTimerError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ConfigurationTimerCallbackIF*) _callback)->onConfigurationTimerError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ConfigurationTimerUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ConfigurationTimer", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ConfigurationTimerUpdate> payload = ::boost::static_pointer_cast<ConfigurationTimerUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ConfigurationTimerCallbackIF*) _callback)->onConfigurationTimerUpdate(proxyShared, payload);
                        proxyShared->_configurationTimer = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_PrepareSetup:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), PrepareSetupError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "PrepareSetup", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PrepareSetupError> payload = ::boost::static_pointer_cast<PrepareSetupError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((PrepareSetupCallbackIF*) _callback)->onPrepareSetupError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PrepareSetupResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "PrepareSetup", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PrepareSetupResponse> payload = ::boost::static_pointer_cast<PrepareSetupResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((PrepareSetupCallbackIF*) _callback)->onPrepareSetupResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_DeActivateSetup:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), DeActivateSetupError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DeActivateSetup", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DeActivateSetupError> payload = ::boost::static_pointer_cast<DeActivateSetupError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DeActivateSetupCallbackIF*) _callback)->onDeActivateSetupError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DeActivateSetupResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "DeActivateSetup", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DeActivateSetupResponse> payload = ::boost::static_pointer_cast<DeActivateSetupResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DeActivateSetupCallbackIF*) _callback)->onDeActivateSetupResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_WiFiStationModeUsage:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), WiFiStationModeUsageError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "WiFiStationModeUsage", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<WiFiStationModeUsageError> payload = ::boost::static_pointer_cast<WiFiStationModeUsageError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((WiFiStationModeUsageCallbackIF*) _callback)->onWiFiStationModeUsageError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), WiFiStationModeUsageResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "WiFiStationModeUsage", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<WiFiStationModeUsageResponse> payload = ::boost::static_pointer_cast<WiFiStationModeUsageResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((WiFiStationModeUsageCallbackIF*) _callback)->onWiFiStationModeUsageResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ResolveConflict:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ResolveConflictError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ResolveConflict", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ResolveConflictError> payload = ::boost::static_pointer_cast<ResolveConflictError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ResolveConflictCallbackIF*) _callback)->onResolveConflictError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ResolveConflictResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ResolveConflict", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ResolveConflictResponse> payload = ::boost::static_pointer_cast<ResolveConflictResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ResolveConflictCallbackIF*) _callback)->onResolveConflictResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_ConflictDetected: {
                ::boost::shared_ptr< ConflictDetectedError > payload = ::boost::shared_ptr< ConflictDetectedError >
                (new ConflictDetectedError(DBUS_ERROR_NO_SERVER, "The DBus service Conflictmanagement is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ConflictDetected", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ConflictmanagementProxy> proxyShared = ::boost::static_pointer_cast<ConflictmanagementProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ConflictDetectedCallbackIF*) _callback)->onConflictDetectedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ConflictResolved: {
                ::boost::shared_ptr< ConflictResolvedError > payload = ::boost::shared_ptr< ConflictResolvedError >
                (new ConflictResolvedError(DBUS_ERROR_NO_SERVER, "The DBus service Conflictmanagement is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ConflictResolved", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ConflictmanagementProxy> proxyShared = ::boost::static_pointer_cast<ConflictmanagementProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ConflictResolvedCallbackIF*) _callback)->onConflictResolvedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ActiveWiFiSetups: {
                ::boost::shared_ptr< ActiveWiFiSetupsError > payload = ::boost::shared_ptr< ActiveWiFiSetupsError >
                (new ActiveWiFiSetupsError(DBUS_ERROR_NO_SERVER, "The DBus service Conflictmanagement is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ActiveWiFiSetups", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ConflictmanagementProxy> proxyShared = ::boost::static_pointer_cast<ConflictmanagementProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ActiveWiFiSetupsCallbackIF*) _callback)->onActiveWiFiSetupsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_WiFiPriorityList: {
                ::boost::shared_ptr< WiFiPriorityListError > payload = ::boost::shared_ptr< WiFiPriorityListError >
                (new WiFiPriorityListError(DBUS_ERROR_NO_SERVER, "The DBus service Conflictmanagement is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "WiFiPriorityList", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ConflictmanagementProxy> proxyShared = ::boost::static_pointer_cast<ConflictmanagementProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((WiFiPriorityListCallbackIF*) _callback)->onWiFiPriorityListError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ConfigurationTimer: {
                ::boost::shared_ptr< ConfigurationTimerError > payload = ::boost::shared_ptr< ConfigurationTimerError >
                (new ConfigurationTimerError(DBUS_ERROR_NO_SERVER, "The DBus service Conflictmanagement is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ConfigurationTimer", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ConflictmanagementProxy> proxyShared = ::boost::static_pointer_cast<ConflictmanagementProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ConfigurationTimerCallbackIF*) _callback)->onConfigurationTimerError (proxyShared,payload);
                return true;
            }
            break;
            case ID_PrepareSetup: {
                ::boost::shared_ptr< PrepareSetupError > payload = ::boost::shared_ptr< PrepareSetupError >
                (new PrepareSetupError(DBUS_ERROR_NO_SERVER, "The DBus service Conflictmanagement is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "PrepareSetup", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ConflictmanagementProxy> proxyShared = ::boost::static_pointer_cast<ConflictmanagementProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PrepareSetupCallbackIF*) _callback)->onPrepareSetupError (proxyShared,payload);
                return true;
            }
            break;
            case ID_DeActivateSetup: {
                ::boost::shared_ptr< DeActivateSetupError > payload = ::boost::shared_ptr< DeActivateSetupError >
                (new DeActivateSetupError(DBUS_ERROR_NO_SERVER, "The DBus service Conflictmanagement is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DeActivateSetup", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ConflictmanagementProxy> proxyShared = ::boost::static_pointer_cast<ConflictmanagementProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DeActivateSetupCallbackIF*) _callback)->onDeActivateSetupError (proxyShared,payload);
                return true;
            }
            break;
            case ID_WiFiStationModeUsage: {
                ::boost::shared_ptr< WiFiStationModeUsageError > payload = ::boost::shared_ptr< WiFiStationModeUsageError >
                (new WiFiStationModeUsageError(DBUS_ERROR_NO_SERVER, "The DBus service Conflictmanagement is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "WiFiStationModeUsage", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ConflictmanagementProxy> proxyShared = ::boost::static_pointer_cast<ConflictmanagementProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((WiFiStationModeUsageCallbackIF*) _callback)->onWiFiStationModeUsageError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ResolveConflict: {
                ::boost::shared_ptr< ResolveConflictError > payload = ::boost::shared_ptr< ResolveConflictError >
                (new ResolveConflictError(DBUS_ERROR_NO_SERVER, "The DBus service Conflictmanagement is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ResolveConflict", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ConflictmanagementProxy> proxyShared = ::boost::static_pointer_cast<ConflictmanagementProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ResolveConflictCallbackIF*) _callback)->onResolveConflictError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& ConflictmanagementProxyCallback::_logger (ConflictmanagementProxy::_logger);

ConflictmanagementProxy::ConflictmanagementProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.bosch.wbl.conflictmanagement", serviceAvailable, _logger) {
}

ConflictmanagementProxy::~ConflictmanagementProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< ConflictmanagementProxy > ConflictmanagementProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<ConflictmanagementProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< ConflictmanagementProxy > proxyNew(new ConflictmanagementProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t ConflictmanagementProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    ConflictmanagementProxyCallback* callback = new ConflictmanagementProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t ConflictmanagementProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    ConflictmanagementProxyCallback* callback = new ConflictmanagementProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void ConflictmanagementProxy::clearAllProperties ()
{
    _activeWiFiSetups = ::asf::core::nullable< ActiveWiFiSetupsUpdate >();
    _wiFiPriorityList = ::asf::core::nullable< WiFiPriorityListUpdate >();
    _configurationTimer = ::asf::core::nullable< ConfigurationTimerUpdate >();
}

void ConflictmanagementProxy::sendDeregisterAll () const
{
    sendActiveWiFiSetupsDeregisterAll();
    sendWiFiPriorityListDeregisterAll();
    sendConfigurationTimerDeregisterAll();
    sendConflictDetectedDeregisterAll();
    sendConflictResolvedDeregisterAll();
}

act_t ConflictmanagementProxy::sendConflictDetectedRegister(ConflictDetectedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "ConflictDetected");
    act_t act = addSignalCallback(ID_ConflictDetected, "ConflictDetected", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ConflictDetected", &cb, act);
    return act;
}

bool ConflictmanagementProxy::sendConflictDetectedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ConflictDetected", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ConflictDetected", act, static_cast<int>(rv));
    return rv;
}

void ConflictmanagementProxy::sendConflictDetectedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ConflictDetected");
    _dbusProxyDelegate->deregisterSignalCallback("ConflictDetected", 0, _dbusDaemonProxy.get(), false);
}

act_t ConflictmanagementProxy::sendConflictResolvedRegister(ConflictResolvedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "ConflictResolved");
    act_t act = addSignalCallback(ID_ConflictResolved, "ConflictResolved", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ConflictResolved", &cb, act);
    return act;
}

bool ConflictmanagementProxy::sendConflictResolvedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ConflictResolved", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ConflictResolved", act, static_cast<int>(rv));
    return rv;
}

void ConflictmanagementProxy::sendConflictResolvedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ConflictResolved");
    _dbusProxyDelegate->deregisterSignalCallback("ConflictResolved", 0, _dbusDaemonProxy.get(), false);
}

act_t ConflictmanagementProxy::sendActiveWiFiSetupsRegister(ActiveWiFiSetupsCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_ActiveWiFiSetups, "ActiveWiFiSetups", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ActiveWiFiSetups", &cb, act);
    return act;
}

bool ConflictmanagementProxy::sendActiveWiFiSetupsDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ActiveWiFiSetups", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ActiveWiFiSetups", act, static_cast<int>(rv));
    return rv;
}

act_t ConflictmanagementProxy::sendActiveWiFiSetupsGet(ActiveWiFiSetupsCallbackIF& cb) {
    ConflictmanagementProxyCallback* callback = new ConflictmanagementProxyCallback(ID_ActiveWiFiSetups, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ActiveWiFiSetups", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("ActiveWiFiSetups", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ActiveWiFiSetupsStruct >& ConflictmanagementProxy::getActiveWiFiSetups() const {
    return _activeWiFiSetups.get().getActiveWiFiSetups();
}

bool ConflictmanagementProxy::hasActiveWiFiSetups() const {
    return _activeWiFiSetups.hasValue();
}

void ConflictmanagementProxy::sendActiveWiFiSetupsDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ActiveWiFiSetups");
    _dbusProxyDelegate->deregisterSignalCallback("ActiveWiFiSetups", 0, _dbusDaemonProxy.get(), true);
}

act_t ConflictmanagementProxy::sendWiFiPriorityListRegister(WiFiPriorityListCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_WiFiPriorityList, "WiFiPriorityList", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "WiFiPriorityList", &cb, act);
    return act;
}

bool ConflictmanagementProxy::sendWiFiPriorityListDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("WiFiPriorityList", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "WiFiPriorityList", act, static_cast<int>(rv));
    return rv;
}

act_t ConflictmanagementProxy::sendWiFiPriorityListGet(WiFiPriorityListCallbackIF& cb) {
    ConflictmanagementProxyCallback* callback = new ConflictmanagementProxyCallback(ID_WiFiPriorityList, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "WiFiPriorityList", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("WiFiPriorityList", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void ConflictmanagementProxy::sendWiFiPriorityListSet(const ::std::vector< ::std::string >& wiFiPriorityList) {
    WiFiPriorityListSet parameter(wiFiPriorityList);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "WiFiPriorityList");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "WiFiPriorityList", propertyContent);
}

act_t ConflictmanagementProxy::sendWiFiPriorityListSet(WiFiPriorityListCallbackIF& cb, const ::std::vector< ::std::string >& wiFiPriorityList) {
    ConflictmanagementProxyCallback* callback = new ConflictmanagementProxyCallback(ID_WiFiPriorityList, &cb);
    WiFiPriorityListSet parameter(wiFiPriorityList);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "WiFiPriorityList", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "WiFiPriorityList", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

const ::std::vector< ::std::string >& ConflictmanagementProxy::getWiFiPriorityList() const {
    return _wiFiPriorityList.get().getWiFiPriorityList();
}

bool ConflictmanagementProxy::hasWiFiPriorityList() const {
    return _wiFiPriorityList.hasValue();
}

void ConflictmanagementProxy::sendWiFiPriorityListDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "WiFiPriorityList");
    _dbusProxyDelegate->deregisterSignalCallback("WiFiPriorityList", 0, _dbusDaemonProxy.get(), true);
}

act_t ConflictmanagementProxy::sendConfigurationTimerRegister(ConfigurationTimerCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_ConfigurationTimer, "ConfigurationTimer", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ConfigurationTimer", &cb, act);
    return act;
}

bool ConflictmanagementProxy::sendConfigurationTimerDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ConfigurationTimer", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ConfigurationTimer", act, static_cast<int>(rv));
    return rv;
}

act_t ConflictmanagementProxy::sendConfigurationTimerGet(ConfigurationTimerCallbackIF& cb) {
    ConflictmanagementProxyCallback* callback = new ConflictmanagementProxyCallback(ID_ConfigurationTimer, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ConfigurationTimer", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("ConfigurationTimer", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void ConflictmanagementProxy::sendConfigurationTimerSet(int32 configurationTimer) {
    ConfigurationTimerSet parameter(configurationTimer);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "ConfigurationTimer");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "ConfigurationTimer", propertyContent);
}

act_t ConflictmanagementProxy::sendConfigurationTimerSet(ConfigurationTimerCallbackIF& cb, int32 configurationTimer) {
    ConflictmanagementProxyCallback* callback = new ConflictmanagementProxyCallback(ID_ConfigurationTimer, &cb);
    ConfigurationTimerSet parameter(configurationTimer);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "ConfigurationTimer", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "ConfigurationTimer", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

int32 ConflictmanagementProxy::getConfigurationTimer() const {
    return _configurationTimer.get().getConfigurationTimer();
}

bool ConflictmanagementProxy::hasConfigurationTimer() const {
    return _configurationTimer.hasValue();
}

void ConflictmanagementProxy::sendConfigurationTimerDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ConfigurationTimer");
    _dbusProxyDelegate->deregisterSignalCallback("ConfigurationTimer", 0, _dbusDaemonProxy.get(), true);
}

act_t ConflictmanagementProxy::sendPrepareSetupRequest(PrepareSetupCallbackIF& cb, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& configuration) const {
    PrepareSetupRequest* payload = new PrepareSetupRequest();
    CHECK_ALLOCATION(payload);
    payload->setConfiguration(configuration);
    DBUS_MESSAGE_CALL(dbusMessage, "PrepareSetup", PrepareSetupRequest, payload, true)
    act_t act = addMethodCallback(ID_PrepareSetup, dbusMessage.getUniqueSerial(), "PrepareSetup", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "PrepareSetup", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ConflictmanagementProxy::sendDeActivateSetupRequest(DeActivateSetupCallbackIF& cb, const ::std::string& wiFiMode) const {
    DeActivateSetupRequest* payload = new DeActivateSetupRequest();
    CHECK_ALLOCATION(payload);
    payload->setWiFiMode(wiFiMode);
    DBUS_MESSAGE_CALL(dbusMessage, "DeActivateSetup", DeActivateSetupRequest, payload, true)
    act_t act = addMethodCallback(ID_DeActivateSetup, dbusMessage.getUniqueSerial(), "DeActivateSetup", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "DeActivateSetup", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ConflictmanagementProxy::sendWiFiStationModeUsageRequest(WiFiStationModeUsageCallbackIF& cb, const ::std::string& application, const ::std::string& usage, bool holding) const {
    WiFiStationModeUsageRequest* payload = new WiFiStationModeUsageRequest();
    CHECK_ALLOCATION(payload);
    payload->setApplication(application);
    payload->setUsage(usage);
    payload->setHolding(holding);
    DBUS_MESSAGE_CALL(dbusMessage, "WiFiStationModeUsage", WiFiStationModeUsageRequest, payload, true)
    act_t act = addMethodCallback(ID_WiFiStationModeUsage, dbusMessage.getUniqueSerial(), "WiFiStationModeUsage", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "WiFiStationModeUsage", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ConflictmanagementProxy::sendResolveConflictRequest(ResolveConflictCallbackIF& cb, int32 conflictid, int32 action) const {
    ResolveConflictRequest* payload = new ResolveConflictRequest();
    CHECK_ALLOCATION(payload);
    payload->setConflictid(conflictid);
    payload->setAction(action);
    DBUS_MESSAGE_CALL(dbusMessage, "ResolveConflict", ResolveConflictRequest, payload, true)
    act_t act = addMethodCallback(ID_ResolveConflict, dbusMessage.getUniqueSerial(), "ResolveConflict", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ResolveConflict", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace conflictmanagement
} // namespace wbl
} // namespace bosch
} // namespace org
