/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/wbl/Regulations.h"
#include "org/bosch/wbl/RegulationsDBus.h"
#include "org/bosch/wbl/RegulationsJson.h"
#include "org/bosch/wbl/RegulationsStub.h"
#include <map>
#include <string>

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bosch {
namespace wbl {
namespace Regulations {

DEFINE_CLASS_LOGGER("//org/bosch/wbl/Regulations/org/bosch/wbl/Regulations", RegulationsStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 14, "SetCountryCode", 0 },
};

static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 11, "CountryCode", 0 },
};

class RegulationsStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    RegulationsStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    RegulationsStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    RegulationsStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.bosch.wbl.Regulations"),
          _logger(logger) {}

    virtual ~RegulationsStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void RegulationsStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 1, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'SetCountryCode'

            LOG_DEBUG_STUB("process method '%s'", "SetCountryCode");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetCountryCodeRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetCountryCode", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetCountryCodeRequest > payload = ::boost::static_pointer_cast<SetCountryCodeRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<RegulationsStub*>(getStub())->onSetCountryCodeRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* RegulationsStubDelegate::introspect() const {
    return     "<interface name=\"org.bosch.wbl.Regulations\">\n"
            "      <method name=\"SetCountryCode\">\n"
            "        <arg direction=\"in\" name=\"countrycode\" type=\"a{sv}\"/>\n"
            "      </method>\n"
            "      <property access=\"read\" name=\"CountryCode\" type=\"a{sv}\"/>\n"
            "</interface>\n";
}

void RegulationsStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<RegulationsStub*>(getStub()))->onGetAll (properties);
}

void RegulationsStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 1, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "CountryCode");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void RegulationsStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 1, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "CountryCode");
            ::boost::shared_ptr< CountryCodeGet > payload(new CountryCodeGet());
            payload->setAct(act);
            static_cast<RegulationsStub*>(getStub())->onCountryCodeGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

RegulationsStub::RegulationsStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new RegulationsStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

RegulationsStub::RegulationsStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new RegulationsStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

RegulationsStub::~RegulationsStub() {
    delete _stubDelegate;
}

void RegulationsStub::sendCountryCodeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        CountryCodeUpdate payload(_CountryCodeProperty);

        LOG_INFO ("-> send%s", "CountryCodeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("CountryCode", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.wbl.Regulations", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "CountryCodeUpdate");
    }
}

void RegulationsStub::onCountryCodeGet(const ::boost::shared_ptr< CountryCodeGet >& countryCode) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "CountryCodeGet", countryCode->getAct());
    sendCountryCodeGetUpdate(_CountryCodeProperty.getCountryCode(), countryCode->getAct());
}

void RegulationsStub::sendCountryCodeGetUpdate(const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& countryCode, act_t act) {
    ::asf::dbus::DBusVariant variant;
    CountryCodeGet payload(countryCode);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "CountryCodeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void RegulationsStub::setCountryCode(const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& countryCode) {
    if(countryCode!=_CountryCodeProperty.getCountryCode()) {
        _CountryCodeProperty.setCountryCode(countryCode);
        sendCountryCodeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& RegulationsStub::getCountryCode() const {
    return _CountryCodeProperty.getCountryCode();
}

::std::map< ::std::string, ::asf::dbus::DBusVariant >& RegulationsStub::getCountryCodeMutable() {
    return _CountryCodeProperty.getCountryCodeMutable();
}

void  RegulationsStub::sendSetCountryCodeResponse (act_t act) {
    SetCountryCodeResponse* payload = new SetCountryCodeResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "SetCountryCode", SetCountryCodeResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetCountryCode", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  RegulationsStub::sendSetCountryCodeError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetCountryCodeError* payload = new SetCountryCodeError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SetCountryCode", SetCountryCodeError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetCountryCode", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void RegulationsStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'CountryCode'
    {
        ::asf::dbus::DBusVariant variant;
        CountryCodeGet payload(_CountryCodeProperty.getCountryCode());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("CountryCode", variant));
    }
}

} // namespace Regulations
} // namespace wbl
} // namespace bosch
} // namespace org
