/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_WBL_REGULATIONSPROXY_H
#define ORG_BOSCH_WBL_REGULATIONSPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/nullable.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "org/bosch/wbl/Regulations.h"
#include <dbus/dbus.h>
#include <map>
#include <string>

namespace org {
namespace bosch {
namespace wbl {
namespace Regulations {

class RegulationsProxy;

class CountryCodeCallbackIF {
public:
    virtual ~CountryCodeCallbackIF() {}

    virtual void onCountryCodeError(const ::boost::shared_ptr< RegulationsProxy >& proxy, const ::boost::shared_ptr< CountryCodeError >& error) = 0;

    virtual void onCountryCodeUpdate(const ::boost::shared_ptr< RegulationsProxy >& proxy, const ::boost::shared_ptr< CountryCodeUpdate >& update) = 0;
};

class SetCountryCodeCallbackIF {
public:
    virtual ~SetCountryCodeCallbackIF() {}

    virtual void onSetCountryCodeError(const ::boost::shared_ptr< RegulationsProxy >& proxy, const ::boost::shared_ptr< SetCountryCodeError >& error) = 0;

    virtual void onSetCountryCodeResponse(const ::boost::shared_ptr< RegulationsProxy >& proxy, const ::boost::shared_ptr< SetCountryCodeResponse >& response) = 0;
};


/**
 * RegulationsProxy is the client side representation of the D-Bus service
 * interface 'org.bosch.wbl.Regulations' (specified in file
 * org-bosch-wbl-Regulations.xml).
 *
 * If the meaning of "org.bosch.wbl.Regulations" isn't clear, then there should be a description here.
 */
class RegulationsProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of RegulationsProxy.
     */
    static ::boost::shared_ptr< RegulationsProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of RegulationsProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< RegulationsProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of RegulationsProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< RegulationsProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< RegulationsProxy > proxyNew(new RegulationsProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(true);
        return proxyNew;
    }

    virtual ~RegulationsProxy ();



    // Property 'CountryCode'

    /**
     * Notify on the property 'CountryCode'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'CountryCode'</b>:
     *
     * If the meaning of "CountryCode" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCountryCodeRegister(CountryCodeCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'CountryCode'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'CountryCode'</b>:
     *
     * If the meaning of "CountryCode" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendCountryCodeRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendCountryCodeDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'CountryCode'.
     */
    void sendCountryCodeDeregisterAll() const;

    /**
     * Request the value of the property 'CountryCode' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'CountryCode'</b>:
     *
     * If the meaning of "CountryCode" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCountryCodeGet(CountryCodeCallbackIF& cb);


    /**
     * Returns the current value of the property 'CountryCode' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasCountryCode() returns true.
     *
     * @return the previously received value of the property 'CountryCode'.
     */
    const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getCountryCode() const;

    /**
     * Determines whether a status message for the property 'CountryCode' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasCountryCode() const;


    // Method 'SetCountryCode'

    /**
     * Call the method 'SetCountryCode'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'SetCountryCode'</b>:
     *
     * If the meaning of "SetCountryCode" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param countrycode If the meaning of "countrycode" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetCountryCodeRequest(SetCountryCodeCallbackIF& cb, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& countrycode) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    RegulationsProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;

    virtual void clearAllProperties ();

    // Property 'CountryCode'

    ::asf::core::nullable< CountryCodeUpdate > _countryCode;

    DECLARE_CLASS_LOGGER();

    friend class RegulationsProxyCallback;
};

} // namespace Regulations
} // namespace wbl
} // namespace bosch
} // namespace org

#endif // ORG_BOSCH_WBL_REGULATIONSPROXY_H
