/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/wbl/Regulations.h"
#include "org/bosch/wbl/RegulationsDBus.h"
#include "org/bosch/wbl/RegulationsJson.h"
#include "org/bosch/wbl/RegulationsProxy.h"
#include <map>
#include <string>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bosch {
namespace wbl {
namespace Regulations {

DEFINE_CLASS_LOGGER("//org/bosch/wbl/Regulations/org/bosch/wbl/Regulations", RegulationsProxy);

class RegulationsProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    RegulationsProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< RegulationsProxy >& proxyShared = ::boost::static_pointer_cast< RegulationsProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_CountryCode:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CountryCodeError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CountryCode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CountryCodeError> payload = ::boost::static_pointer_cast<CountryCodeError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((CountryCodeCallbackIF*) _callback)->onCountryCodeError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CountryCodeUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CountryCode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CountryCodeUpdate> payload = ::boost::static_pointer_cast<CountryCodeUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((CountryCodeCallbackIF*) _callback)->onCountryCodeUpdate(proxyShared, payload);
                        proxyShared->_countryCode = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_SetCountryCode:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetCountryCodeError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetCountryCode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetCountryCodeError> payload = ::boost::static_pointer_cast<SetCountryCodeError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetCountryCodeCallbackIF*) _callback)->onSetCountryCodeError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetCountryCodeResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetCountryCode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetCountryCodeResponse> payload = ::boost::static_pointer_cast<SetCountryCodeResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetCountryCodeCallbackIF*) _callback)->onSetCountryCodeResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_CountryCode: {
                ::boost::shared_ptr< CountryCodeError > payload = ::boost::shared_ptr< CountryCodeError >
                (new CountryCodeError(DBUS_ERROR_NO_SERVER, "The DBus service Regulations is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CountryCode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<RegulationsProxy> proxyShared = ::boost::static_pointer_cast<RegulationsProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CountryCodeCallbackIF*) _callback)->onCountryCodeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SetCountryCode: {
                ::boost::shared_ptr< SetCountryCodeError > payload = ::boost::shared_ptr< SetCountryCodeError >
                (new SetCountryCodeError(DBUS_ERROR_NO_SERVER, "The DBus service Regulations is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetCountryCode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<RegulationsProxy> proxyShared = ::boost::static_pointer_cast<RegulationsProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetCountryCodeCallbackIF*) _callback)->onSetCountryCodeError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& RegulationsProxyCallback::_logger (RegulationsProxy::_logger);

RegulationsProxy::RegulationsProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.bosch.wbl.Regulations", serviceAvailable, _logger) {
}

RegulationsProxy::~RegulationsProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< RegulationsProxy > RegulationsProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<RegulationsProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< RegulationsProxy > proxyNew(new RegulationsProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t RegulationsProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    RegulationsProxyCallback* callback = new RegulationsProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t RegulationsProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    RegulationsProxyCallback* callback = new RegulationsProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void RegulationsProxy::clearAllProperties ()
{
    _countryCode = ::asf::core::nullable< CountryCodeUpdate >();
}

void RegulationsProxy::sendDeregisterAll () const
{
    sendCountryCodeDeregisterAll();
}

act_t RegulationsProxy::sendCountryCodeRegister(CountryCodeCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_CountryCode, "CountryCode", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "CountryCode", &cb, act);
    return act;
}

bool RegulationsProxy::sendCountryCodeDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("CountryCode", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "CountryCode", act, static_cast<int>(rv));
    return rv;
}

act_t RegulationsProxy::sendCountryCodeGet(CountryCodeCallbackIF& cb) {
    RegulationsProxyCallback* callback = new RegulationsProxyCallback(ID_CountryCode, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "CountryCode", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("CountryCode", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& RegulationsProxy::getCountryCode() const {
    return _countryCode.get().getCountryCode();
}

bool RegulationsProxy::hasCountryCode() const {
    return _countryCode.hasValue();
}

void RegulationsProxy::sendCountryCodeDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "CountryCode");
    _dbusProxyDelegate->deregisterSignalCallback("CountryCode", 0, _dbusDaemonProxy.get(), true);
}

act_t RegulationsProxy::sendSetCountryCodeRequest(SetCountryCodeCallbackIF& cb, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& countrycode) const {
    SetCountryCodeRequest* payload = new SetCountryCodeRequest();
    CHECK_ALLOCATION(payload);
    payload->setCountrycode(countrycode);
    DBUS_MESSAGE_CALL(dbusMessage, "SetCountryCode", SetCountryCodeRequest, payload, true)
    act_t act = addMethodCallback(ID_SetCountryCode, dbusMessage.getUniqueSerial(), "SetCountryCode", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetCountryCode", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace Regulations
} // namespace wbl
} // namespace bosch
} // namespace org
