/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_WAPDMAN_MANAGERPROXY_H
#define ORG_BOSCH_WAPDMAN_MANAGERPROXY_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "org/bosch/wapdman/Manager.h"
#include <dbus/dbus.h>
#include <string>

namespace org {
namespace bosch {
namespace wapdman {
namespace Manager {

class ManagerProxy;

class AccessPointAddedCallbackIF {
public:
    virtual ~AccessPointAddedCallbackIF() {}

    virtual void onAccessPointAddedError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< AccessPointAddedError >& error) = 0;

    virtual void onAccessPointAddedSignal(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< AccessPointAddedSignal >& signal) = 0;
};

class AccessPointRemovedCallbackIF {
public:
    virtual ~AccessPointRemovedCallbackIF() {}

    virtual void onAccessPointRemovedError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< AccessPointRemovedError >& error) = 0;

    virtual void onAccessPointRemovedSignal(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< AccessPointRemovedSignal >& signal) = 0;
};

class FindAccessPointCallbackIF {
public:
    virtual ~FindAccessPointCallbackIF() {}

    virtual void onFindAccessPointError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< FindAccessPointError >& error) = 0;

    virtual void onFindAccessPointResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< FindAccessPointResponse >& response) = 0;
};

class GetAccessPointsCallbackIF {
public:
    virtual ~GetAccessPointsCallbackIF() {}

    virtual void onGetAccessPointsError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< GetAccessPointsError >& error) = 0;

    virtual void onGetAccessPointsResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< GetAccessPointsResponse >& response) = 0;
};

class RegisterAgentCallbackIF {
public:
    virtual ~RegisterAgentCallbackIF() {}

    virtual void onRegisterAgentError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< RegisterAgentError >& error) = 0;

    virtual void onRegisterAgentResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< RegisterAgentResponse >& response) = 0;
};

class UnregisterAgentCallbackIF {
public:
    virtual ~UnregisterAgentCallbackIF() {}

    virtual void onUnregisterAgentError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< UnregisterAgentError >& error) = 0;

    virtual void onUnregisterAgentResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< UnregisterAgentResponse >& response) = 0;
};


/**
 * ManagerProxy is the client side representation of the D-Bus service
 * interface 'org.bosch.wapdman.Manager' (specified in file
 * org-bosch-wapdmgr-manager-introspection.xml).
 *
 * If the meaning of "org.bosch.wapdman.Manager" isn't clear, then there should be a description here.
 */
class ManagerProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of ManagerProxy.
     */
    static ::boost::shared_ptr< ManagerProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of ManagerProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< ManagerProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of ManagerProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< ManagerProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< ManagerProxy > proxyNew(new ManagerProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(false);
        return proxyNew;
    }

    virtual ~ManagerProxy ();


    // Signal 'AccessPointAdded'

    /**
     * Notify on the signal 'AccessPointAdded'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'AccessPointAdded'</b>:
     *
     * If the meaning of "AccessPointAdded" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAccessPointAddedRegister(AccessPointAddedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'AccessPointAdded'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'AccessPointAdded'</b>:
     *
     * If the meaning of "AccessPointAdded" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendAccessPointAddedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendAccessPointAddedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'AccessPointAdded'.
     */
    void sendAccessPointAddedDeregisterAll () const;

    // Signal 'AccessPointRemoved'

    /**
     * Notify on the signal 'AccessPointRemoved'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'AccessPointRemoved'</b>:
     *
     * If the meaning of "AccessPointRemoved" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAccessPointRemovedRegister(AccessPointRemovedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'AccessPointRemoved'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'AccessPointRemoved'</b>:
     *
     * If the meaning of "AccessPointRemoved" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendAccessPointRemovedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendAccessPointRemovedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'AccessPointRemoved'.
     */
    void sendAccessPointRemovedDeregisterAll () const;



    // Method 'FindAccessPoint'

    /**
     * Call the method 'FindAccessPoint'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'FindAccessPoint'</b>:
     *
     * If the meaning of "FindAccessPoint" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param pattern If the meaning of "pattern" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFindAccessPointRequest(FindAccessPointCallbackIF& cb, const ::std::string& pattern) const;

    // Method 'RegisterAgent'

    /**
     * Call the method 'RegisterAgent'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'RegisterAgent'</b>:
     *
     * If the meaning of "RegisterAgent" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param path If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRegisterAgentRequest(RegisterAgentCallbackIF& cb, const ::std::string& path) const;

    // Method 'UnregisterAgent'

    /**
     * Call the method 'UnregisterAgent'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'UnregisterAgent'</b>:
     *
     * If the meaning of "UnregisterAgent" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param path If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUnregisterAgentRequest(UnregisterAgentCallbackIF& cb, const ::std::string& path) const;

    // Method 'GetAccessPoints'

    /**
     * Call the method 'GetAccessPoints'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'GetAccessPoints'</b>:
     *
     * If the meaning of "GetAccessPoints" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetAccessPointsRequest(GetAccessPointsCallbackIF& cb) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    ManagerProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;


    DECLARE_CLASS_LOGGER();

    friend class ManagerProxyCallback;
};

} // namespace Manager
} // namespace wapdman
} // namespace bosch
} // namespace org

#endif // ORG_BOSCH_WAPDMAN_MANAGERPROXY_H
