/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/wapdman/AssociatedStation.h"
#include "org/bosch/wapdman/AssociatedStationDBus.h"
#include "org/bosch/wapdman/AssociatedStationJson.h"
#include "org/bosch/wapdman/AssociatedStationStub.h"
#include <string>

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bosch {
namespace wapdman {
namespace AssociatedStation {

DEFINE_CLASS_LOGGER("//org/bosch/wapdman/accesspoint_XX_XX_XX_XX_XX_XX/AssociatedStation_XX_XX_XX_XX_XX_XX/org/bosch/wapdman/AssociatedStation", AssociatedStationStub);


static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 8, "Hostname", 4 },
    { 9, "IPAddress", 3 },
    { 9, "Interface", 2 },
    { 10, "MacAddress", 0 },
    { 11, "Accesspoint", 1 },
};

class AssociatedStationStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    AssociatedStationStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    AssociatedStationStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    AssociatedStationStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.bosch.wapdman.AssociatedStation"),
          _logger(logger) {}

    virtual ~AssociatedStationStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void AssociatedStationStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* AssociatedStationStubDelegate::introspect() const {
    return     "<interface name=\"org.bosch.wapdman.AssociatedStation\">\n"
            "      <property access=\"read\" name=\"MacAddress\" type=\"s\"/>\n"
            "      <property access=\"read\" name=\"Accesspoint\" type=\"o\"/>\n"
            "      <property access=\"read\" name=\"Interface\" type=\"s\"/>\n"
            "      <property access=\"read\" name=\"IPAddress\" type=\"s\"/>\n"
            "      <property access=\"read\" name=\"Hostname\" type=\"s\"/>\n"
            "</interface>\n";
}

void AssociatedStationStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<AssociatedStationStub*>(getStub()))->onGetAll (properties);
}

void AssociatedStationStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 5, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "MacAddress");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "Accesspoint");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "Interface");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "IPAddress");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "Hostname");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void AssociatedStationStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 5, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "MacAddress");
            ::boost::shared_ptr< MacAddressGet > payload(new MacAddressGet());
            payload->setAct(act);
            static_cast<AssociatedStationStub*>(getStub())->onMacAddressGet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "Accesspoint");
            ::boost::shared_ptr< AccesspointGet > payload(new AccesspointGet());
            payload->setAct(act);
            static_cast<AssociatedStationStub*>(getStub())->onAccesspointGet (payload);
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "Interface");
            ::boost::shared_ptr< InterfaceGet > payload(new InterfaceGet());
            payload->setAct(act);
            static_cast<AssociatedStationStub*>(getStub())->onInterfaceGet (payload);
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "IPAddress");
            ::boost::shared_ptr< IPAddressGet > payload(new IPAddressGet());
            payload->setAct(act);
            static_cast<AssociatedStationStub*>(getStub())->onIPAddressGet (payload);
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "Hostname");
            ::boost::shared_ptr< HostnameGet > payload(new HostnameGet());
            payload->setAct(act);
            static_cast<AssociatedStationStub*>(getStub())->onHostnameGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

AssociatedStationStub::AssociatedStationStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new AssociatedStationStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

AssociatedStationStub::AssociatedStationStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new AssociatedStationStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

AssociatedStationStub::~AssociatedStationStub() {
    delete _stubDelegate;
}

void AssociatedStationStub::sendMacAddressUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        MacAddressUpdate payload(_MacAddressProperty);

        LOG_INFO ("-> send%s", "MacAddressUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("MacAddress", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.wapdman.AssociatedStation", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "MacAddressUpdate");
    }
}

void AssociatedStationStub::onMacAddressGet(const ::boost::shared_ptr< MacAddressGet >& macAddress) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "MacAddressGet", macAddress->getAct());
    sendMacAddressGetUpdate(_MacAddressProperty.getMacAddress(), macAddress->getAct());
}

void AssociatedStationStub::sendMacAddressGetUpdate(const ::std::string& macAddress, act_t act) {
    ::asf::dbus::DBusVariant variant;
    MacAddressGet payload(macAddress);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "MacAddressGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void AssociatedStationStub::setMacAddress(const ::std::string& macAddress) {
    if(macAddress!=_MacAddressProperty.getMacAddress()) {
        _MacAddressProperty.setMacAddress(macAddress);
        sendMacAddressUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& AssociatedStationStub::getMacAddress() const {
    return _MacAddressProperty.getMacAddress();
}

::std::string& AssociatedStationStub::getMacAddressMutable() {
    return _MacAddressProperty.getMacAddressMutable();
}

void AssociatedStationStub::sendAccesspointUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        AccesspointUpdate payload(_AccesspointProperty);

        LOG_INFO ("-> send%s", "AccesspointUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Accesspoint", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.wapdman.AssociatedStation", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "AccesspointUpdate");
    }
}

void AssociatedStationStub::onAccesspointGet(const ::boost::shared_ptr< AccesspointGet >& accesspoint) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AccesspointGet", accesspoint->getAct());
    sendAccesspointGetUpdate(_AccesspointProperty.getAccesspoint(), accesspoint->getAct());
}

void AssociatedStationStub::sendAccesspointGetUpdate(const ::std::string& accesspoint, act_t act) {
    ::asf::dbus::DBusVariant variant;
    AccesspointGet payload(accesspoint);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AccesspointGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void AssociatedStationStub::setAccesspoint(const ::std::string& accesspoint) {
    if(accesspoint!=_AccesspointProperty.getAccesspoint()) {
        _AccesspointProperty.setAccesspoint(accesspoint);
        sendAccesspointUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& AssociatedStationStub::getAccesspoint() const {
    return _AccesspointProperty.getAccesspoint();
}

::std::string& AssociatedStationStub::getAccesspointMutable() {
    return _AccesspointProperty.getAccesspointMutable();
}

void AssociatedStationStub::sendInterfaceUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        InterfaceUpdate payload(_InterfaceProperty);

        LOG_INFO ("-> send%s", "InterfaceUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Interface", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.wapdman.AssociatedStation", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "InterfaceUpdate");
    }
}

void AssociatedStationStub::onInterfaceGet(const ::boost::shared_ptr< InterfaceGet >& interface) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "InterfaceGet", interface->getAct());
    sendInterfaceGetUpdate(_InterfaceProperty.getInterface(), interface->getAct());
}

void AssociatedStationStub::sendInterfaceGetUpdate(const ::std::string& interface, act_t act) {
    ::asf::dbus::DBusVariant variant;
    InterfaceGet payload(interface);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "InterfaceGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void AssociatedStationStub::setInterface(const ::std::string& interface) {
    if(interface!=_InterfaceProperty.getInterface()) {
        _InterfaceProperty.setInterface(interface);
        sendInterfaceUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& AssociatedStationStub::getInterface() const {
    return _InterfaceProperty.getInterface();
}

::std::string& AssociatedStationStub::getInterfaceMutable() {
    return _InterfaceProperty.getInterfaceMutable();
}

void AssociatedStationStub::sendIPAddressUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        IPAddressUpdate payload(_IPAddressProperty);

        LOG_INFO ("-> send%s", "IPAddressUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("IPAddress", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.wapdman.AssociatedStation", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "IPAddressUpdate");
    }
}

void AssociatedStationStub::onIPAddressGet(const ::boost::shared_ptr< IPAddressGet >& iPAddress) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "IPAddressGet", iPAddress->getAct());
    sendIPAddressGetUpdate(_IPAddressProperty.getIPAddress(), iPAddress->getAct());
}

void AssociatedStationStub::sendIPAddressGetUpdate(const ::std::string& iPAddress, act_t act) {
    ::asf::dbus::DBusVariant variant;
    IPAddressGet payload(iPAddress);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "IPAddressGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void AssociatedStationStub::setIPAddress(const ::std::string& iPAddress) {
    if(iPAddress!=_IPAddressProperty.getIPAddress()) {
        _IPAddressProperty.setIPAddress(iPAddress);
        sendIPAddressUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& AssociatedStationStub::getIPAddress() const {
    return _IPAddressProperty.getIPAddress();
}

::std::string& AssociatedStationStub::getIPAddressMutable() {
    return _IPAddressProperty.getIPAddressMutable();
}

void AssociatedStationStub::sendHostnameUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        HostnameUpdate payload(_HostnameProperty);

        LOG_INFO ("-> send%s", "HostnameUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Hostname", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.wapdman.AssociatedStation", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "HostnameUpdate");
    }
}

void AssociatedStationStub::onHostnameGet(const ::boost::shared_ptr< HostnameGet >& hostname) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "HostnameGet", hostname->getAct());
    sendHostnameGetUpdate(_HostnameProperty.getHostname(), hostname->getAct());
}

void AssociatedStationStub::sendHostnameGetUpdate(const ::std::string& hostname, act_t act) {
    ::asf::dbus::DBusVariant variant;
    HostnameGet payload(hostname);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "HostnameGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void AssociatedStationStub::setHostname(const ::std::string& hostname) {
    if(hostname!=_HostnameProperty.getHostname()) {
        _HostnameProperty.setHostname(hostname);
        sendHostnameUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& AssociatedStationStub::getHostname() const {
    return _HostnameProperty.getHostname();
}

::std::string& AssociatedStationStub::getHostnameMutable() {
    return _HostnameProperty.getHostnameMutable();
}

void AssociatedStationStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'MacAddress'
    {
        ::asf::dbus::DBusVariant variant;
        MacAddressGet payload(_MacAddressProperty.getMacAddress());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("MacAddress", variant));
    }

    //property 'Accesspoint'
    {
        ::asf::dbus::DBusVariant variant;
        AccesspointGet payload(_AccesspointProperty.getAccesspoint());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Accesspoint", variant));
    }

    //property 'Interface'
    {
        ::asf::dbus::DBusVariant variant;
        InterfaceGet payload(_InterfaceProperty.getInterface());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Interface", variant));
    }

    //property 'IPAddress'
    {
        ::asf::dbus::DBusVariant variant;
        IPAddressGet payload(_IPAddressProperty.getIPAddress());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("IPAddress", variant));
    }

    //property 'Hostname'
    {
        ::asf::dbus::DBusVariant variant;
        HostnameGet payload(_HostnameProperty.getHostname());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Hostname", variant));
    }
}

} // namespace AssociatedStation
} // namespace wapdman
} // namespace bosch
} // namespace org
