/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_WAPDMAN_ACCESSPOINTSTUB_H
#define ORG_BOSCH_WAPDMAN_ACCESSPOINTSTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/wapdman/Accesspoint.h"
#include <map>
#include <string>
#include <vector>

namespace org {
namespace bosch {
namespace wapdman {
namespace Accesspoint {

class AccesspointStubDelegate;

class AccesspointStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the AccesspointStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    AccesspointStub (const std::string& portName);

    /**
     * Create an instance of the AccesspointStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    AccesspointStub (const std::string& portName, const std::string& objectPath);

    virtual ~AccesspointStub();

    // signal 'AssociatedStationsChanged'

    /**
     * Raise the signal 'AssociatedStationsChanged' and send an update message
     * to registered clients.
     *
     * <b>Documentation of 'AssociatedStationsChanged'</b>:
     *
     * If the meaning of "AssociatedStationsChanged" isn't clear, then there should be a description here.
     */
    void sendAssociatedStationsChangedSignal(const ::std::vector< AssociatedStationsChangedSignalChangedstationsStruct >& changedstations, const ::std::vector< ::std::string >& removedstations);

    // signal 'AssociationRequestRejected'

    /**
     * Raise the signal 'AssociationRequestRejected' and send an update
     * message to registered clients.
     *
     * <b>Documentation of 'AssociationRequestRejected'</b>:
     *
     * If the meaning of "AssociationRequestRejected" isn't clear, then there should be a description here.
     */
    void sendAssociationRequestRejectedSignal(const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& station);

    // property 'MacAddress'

    /**
     * The method onMacAddressGet() is called by ASF when a client invokes the
     * read method for the property 'MacAddress'. The onMacAddressGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'MacAddress'</b>:
     *
     * If the meaning of "MacAddress" isn't clear, then there should be a description here.
     */
    virtual void onMacAddressGet(const ::boost::shared_ptr< MacAddressGet >& payload);

    /**
     * Sends back the update to a previous onMacAddressGet().
     *
     * <b>Documentation of 'MacAddress'</b>:
     *
     * If the meaning of "MacAddress" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onMacAddressGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendMacAddressGetUpdate(const ::std::string& macAddress, act_t act = 0);

    /**
     * Set the value of the property 'MacAddress' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'MacAddress'</b>:
     *
     * If the meaning of "MacAddress" isn't clear, then there should be a description here.
     */
    void setMacAddress(const ::std::string& macAddress);

    /**
     * Returns the current value of the property 'MacAddress'.
     *
     * <b>Documentation of 'MacAddress'</b>:
     *
     * If the meaning of "MacAddress" isn't clear, then there should be a description here.
     */
    const ::std::string& getMacAddress() const;

    /**
     * Returns the current value of the property 'MacAddress' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendMacAddressUpdate() method.
     *
     * <b>Documentation of 'MacAddress'</b>:
     *
     * If the meaning of "MacAddress" isn't clear, then there should be a description here.
     */
    ::std::string& getMacAddressMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendMacAddressUpdate().
     *
     * <b>Documentation of 'MacAddress'</b>:
     *
     * If the meaning of "MacAddress" isn't clear, then there should be a description here.
     */
    void sendMacAddressUpdate();

    // property 'SSID'

    /**
     * The method onSSIDGet() is called by ASF when a client invokes the read
     * method for the property 'SSID'. The onSSIDGet() method returns by
     * default the current property value to the caller. In case this default
     * behavior doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'SSID'</b>:
     *
     * If the meaning of "SSID" isn't clear, then there should be a description here.
     */
    virtual void onSSIDGet(const ::boost::shared_ptr< SSIDGet >& payload);

    /**
     * Sends back the update to a previous onSSIDGet().
     *
     * <b>Documentation of 'SSID'</b>:
     *
     * If the meaning of "SSID" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onSSIDGet(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendSSIDGetUpdate(const ::std::vector< uint8 >& sSID, act_t act = 0);

    /**
     * Set the value of the property 'SSID' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'SSID'</b>:
     *
     * If the meaning of "SSID" isn't clear, then there should be a description here.
     */
    void setSSID(const ::std::vector< uint8 >& sSID);

    /**
     * Returns the current value of the property 'SSID'.
     *
     * <b>Documentation of 'SSID'</b>:
     *
     * If the meaning of "SSID" isn't clear, then there should be a description here.
     */
    const ::std::vector< uint8 >& getSSID() const;

    /**
     * Returns the current value of the property 'SSID' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendSSIDUpdate() method.
     *
     * <b>Documentation of 'SSID'</b>:
     *
     * If the meaning of "SSID" isn't clear, then there should be a description here.
     */
    ::std::vector< uint8 >& getSSIDMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSSIDUpdate().
     *
     * <b>Documentation of 'SSID'</b>:
     *
     * If the meaning of "SSID" isn't clear, then there should be a description here.
     */
    void sendSSIDUpdate();

    // property 'Interface'

    /**
     * The method onInterfaceGet() is called by ASF when a client invokes the
     * read method for the property 'Interface'. The onInterfaceGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Interface'</b>:
     *
     * If the meaning of "Interface" isn't clear, then there should be a description here.
     */
    virtual void onInterfaceGet(const ::boost::shared_ptr< InterfaceGet >& payload);

    /**
     * Sends back the update to a previous onInterfaceGet().
     *
     * <b>Documentation of 'Interface'</b>:
     *
     * If the meaning of "Interface" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onInterfaceGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendInterfaceGetUpdate(const ::std::string& interface, act_t act = 0);

    /**
     * Set the value of the property 'Interface' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'Interface'</b>:
     *
     * If the meaning of "Interface" isn't clear, then there should be a description here.
     */
    void setInterface(const ::std::string& interface);

    /**
     * Returns the current value of the property 'Interface'.
     *
     * <b>Documentation of 'Interface'</b>:
     *
     * If the meaning of "Interface" isn't clear, then there should be a description here.
     */
    const ::std::string& getInterface() const;

    /**
     * Returns the current value of the property 'Interface' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendInterfaceUpdate() method.
     *
     * <b>Documentation of 'Interface'</b>:
     *
     * If the meaning of "Interface" isn't clear, then there should be a description here.
     */
    ::std::string& getInterfaceMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendInterfaceUpdate().
     *
     * <b>Documentation of 'Interface'</b>:
     *
     * If the meaning of "Interface" isn't clear, then there should be a description here.
     */
    void sendInterfaceUpdate();

    // property 'BlackListedStations'

    /**
     * The method onBlackListedStationsGet() is called by ASF when a client
     * invokes the read method for the property 'BlackListedStations'. The
     * onBlackListedStationsGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'BlackListedStations'</b>:
     *
     * If the meaning of "BlackListedStations" isn't clear, then there should be a description here.
     */
    virtual void onBlackListedStationsGet(const ::boost::shared_ptr< BlackListedStationsGet >& payload);

    /**
     * Sends back the update to a previous onBlackListedStationsGet().
     *
     * <b>Documentation of 'BlackListedStations'</b>:
     *
     * If the meaning of "BlackListedStations" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of
     * onBlackListedStationsGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendBlackListedStationsGetUpdate(const ::std::vector< ::std::string >& blackListedStations, act_t act = 0);

    /**
     * Set the value of the property 'BlackListedStations' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'BlackListedStations'</b>:
     *
     * If the meaning of "BlackListedStations" isn't clear, then there should be a description here.
     */
    void setBlackListedStations(const ::std::vector< ::std::string >& blackListedStations);

    /**
     * Returns the current value of the property 'BlackListedStations'.
     *
     * <b>Documentation of 'BlackListedStations'</b>:
     *
     * If the meaning of "BlackListedStations" isn't clear, then there should be a description here.
     */
    const ::std::vector< ::std::string >& getBlackListedStations() const;

    /**
     * Returns the current value of the property 'BlackListedStations' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendBlackListedStationsUpdate() method.
     *
     * <b>Documentation of 'BlackListedStations'</b>:
     *
     * If the meaning of "BlackListedStations" isn't clear, then there should be a description here.
     */
    ::std::vector< ::std::string >& getBlackListedStationsMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendBlackListedStationsUpdate().
     *
     * <b>Documentation of 'BlackListedStations'</b>:
     *
     * If the meaning of "BlackListedStations" isn't clear, then there should be a description here.
     */
    void sendBlackListedStationsUpdate();

    // property 'PowerState'

    /**
     * The method onPowerStateGet() is called by ASF when a client invokes the
     * read method for the property 'PowerState'. The onPowerStateGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'PowerState'</b>:
     *
     * If the meaning of "PowerState" isn't clear, then there should be a description here.
     */
    virtual void onPowerStateGet(const ::boost::shared_ptr< PowerStateGet >& payload);

    /**
     * Sends back the update to a previous onPowerStateGet().
     *
     * <b>Documentation of 'PowerState'</b>:
     *
     * If the meaning of "PowerState" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onPowerStateGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendPowerStateGetUpdate(const ::std::string& powerState, act_t act = 0);

    /**
     * Set the value of the property 'PowerState' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'PowerState'</b>:
     *
     * If the meaning of "PowerState" isn't clear, then there should be a description here.
     */
    void setPowerState(const ::std::string& powerState);

    /**
     * Returns the current value of the property 'PowerState'.
     *
     * <b>Documentation of 'PowerState'</b>:
     *
     * If the meaning of "PowerState" isn't clear, then there should be a description here.
     */
    const ::std::string& getPowerState() const;

    /**
     * Returns the current value of the property 'PowerState' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendPowerStateUpdate() method.
     *
     * <b>Documentation of 'PowerState'</b>:
     *
     * If the meaning of "PowerState" isn't clear, then there should be a description here.
     */
    ::std::string& getPowerStateMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendPowerStateUpdate().
     *
     * <b>Documentation of 'PowerState'</b>:
     *
     * If the meaning of "PowerState" isn't clear, then there should be a description here.
     */
    void sendPowerStateUpdate();

    // property 'PowerFailureReason'

    /**
     * The method onPowerFailureReasonGet() is called by ASF when a client
     * invokes the read method for the property 'PowerFailureReason'. The
     * onPowerFailureReasonGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'PowerFailureReason'</b>:
     *
     * If the meaning of "PowerFailureReason" isn't clear, then there should be a description here.
     */
    virtual void onPowerFailureReasonGet(const ::boost::shared_ptr< PowerFailureReasonGet >& payload);

    /**
     * Sends back the update to a previous onPowerFailureReasonGet().
     *
     * <b>Documentation of 'PowerFailureReason'</b>:
     *
     * If the meaning of "PowerFailureReason" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of
     * onPowerFailureReasonGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendPowerFailureReasonGetUpdate(const ::std::string& powerFailureReason, act_t act = 0);

    /**
     * Set the value of the property 'PowerFailureReason' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'PowerFailureReason'</b>:
     *
     * If the meaning of "PowerFailureReason" isn't clear, then there should be a description here.
     */
    void setPowerFailureReason(const ::std::string& powerFailureReason);

    /**
     * Returns the current value of the property 'PowerFailureReason'.
     *
     * <b>Documentation of 'PowerFailureReason'</b>:
     *
     * If the meaning of "PowerFailureReason" isn't clear, then there should be a description here.
     */
    const ::std::string& getPowerFailureReason() const;

    /**
     * Returns the current value of the property 'PowerFailureReason' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendPowerFailureReasonUpdate() method.
     *
     * <b>Documentation of 'PowerFailureReason'</b>:
     *
     * If the meaning of "PowerFailureReason" isn't clear, then there should be a description here.
     */
    ::std::string& getPowerFailureReasonMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendPowerFailureReasonUpdate().
     *
     * <b>Documentation of 'PowerFailureReason'</b>:
     *
     * If the meaning of "PowerFailureReason" isn't clear, then there should be a description here.
     */
    void sendPowerFailureReasonUpdate();

    // property 'Powered'

    /**
     * The method onPoweredGet() is called by ASF when a client invokes the
     * read method for the property 'Powered'. The onPoweredGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Powered'</b>:
     *
     * If the meaning of "Powered" isn't clear, then there should be a description here.
     */
    virtual void onPoweredGet(const ::boost::shared_ptr< PoweredGet >& payload);

    /**
     * Sends back the update to a previous onPoweredGet().
     *
     * <b>Documentation of 'Powered'</b>:
     *
     * If the meaning of "Powered" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onPoweredGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendPoweredGetUpdate(bool powered, act_t act = 0);

    /**
     * The method onPoweredSet() is called by ASF when a client invokes the
     * write method for the property 'Powered'. The onPoweredSet() method set
     * property value to the given parameter Powered by default. If this
     * default behavior doesn't match your needs feel free to override this
     * method.
     *
     * <b>Documentation of 'Powered'</b>:
     *
     * If the meaning of "Powered" isn't clear, then there should be a description here.
     */
    virtual void onPoweredSet(const ::boost::shared_ptr< PoweredSet >& payload);

    /**
     * Sends back the update to a previous onPoweredSet().
     *
     * <b>Documentation of 'Powered'</b>:
     *
     * If the meaning of "Powered" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onPoweredSet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendPoweredSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'Powered' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Powered'</b>:
     *
     * If the meaning of "Powered" isn't clear, then there should be a description here.
     */
    void setPowered(bool powered);

    /**
     * Returns the current value of the property 'Powered'.
     *
     * <b>Documentation of 'Powered'</b>:
     *
     * If the meaning of "Powered" isn't clear, then there should be a description here.
     */
    bool getPowered() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendPoweredUpdate().
     *
     * <b>Documentation of 'Powered'</b>:
     *
     * If the meaning of "Powered" isn't clear, then there should be a description here.
     */
    void sendPoweredUpdate();

    // property 'Hidden'

    /**
     * The method onHiddenGet() is called by ASF when a client invokes the
     * read method for the property 'Hidden'. The onHiddenGet() method returns
     * by default the current property value to the caller. In case this
     * default behavior doesn't match your needs feel free to override this
     * method.
     *
     * <b>Documentation of 'Hidden'</b>:
     *
     * If the meaning of "Hidden" isn't clear, then there should be a description here.
     */
    virtual void onHiddenGet(const ::boost::shared_ptr< HiddenGet >& payload);

    /**
     * Sends back the update to a previous onHiddenGet().
     *
     * <b>Documentation of 'Hidden'</b>:
     *
     * If the meaning of "Hidden" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onHiddenGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendHiddenGetUpdate(bool hidden, act_t act = 0);

    /**
     * The method onHiddenSet() is called by ASF when a client invokes the
     * write method for the property 'Hidden'. The onHiddenSet() method set
     * property value to the given parameter Hidden by default. If this
     * default behavior doesn't match your needs feel free to override this
     * method.
     *
     * <b>Documentation of 'Hidden'</b>:
     *
     * If the meaning of "Hidden" isn't clear, then there should be a description here.
     */
    virtual void onHiddenSet(const ::boost::shared_ptr< HiddenSet >& payload);

    /**
     * Sends back the update to a previous onHiddenSet().
     *
     * <b>Documentation of 'Hidden'</b>:
     *
     * If the meaning of "Hidden" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onHiddenSet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendHiddenSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'Hidden' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Hidden'</b>:
     *
     * If the meaning of "Hidden" isn't clear, then there should be a description here.
     */
    void setHidden(bool hidden);

    /**
     * Returns the current value of the property 'Hidden'.
     *
     * <b>Documentation of 'Hidden'</b>:
     *
     * If the meaning of "Hidden" isn't clear, then there should be a description here.
     */
    bool getHidden() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendHiddenUpdate().
     *
     * <b>Documentation of 'Hidden'</b>:
     *
     * If the meaning of "Hidden" isn't clear, then there should be a description here.
     */
    void sendHiddenUpdate();

    // property 'Security'

    /**
     * The method onSecurityGet() is called by ASF when a client invokes the
     * read method for the property 'Security'. The onSecurityGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Security'</b>:
     *
     * If the meaning of "Security" isn't clear, then there should be a description here.
     */
    virtual void onSecurityGet(const ::boost::shared_ptr< SecurityGet >& payload);

    /**
     * Sends back the update to a previous onSecurityGet().
     *
     * <b>Documentation of 'Security'</b>:
     *
     * If the meaning of "Security" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onSecurityGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendSecurityGetUpdate(const ::std::string& security, act_t act = 0);

    /**
     * The method onSecuritySet() is called by ASF when a client invokes the
     * write method for the property 'Security'. The onSecuritySet() method
     * set property value to the given parameter Security by default. If this
     * default behavior doesn't match your needs feel free to override this
     * method.
     *
     * <b>Documentation of 'Security'</b>:
     *
     * If the meaning of "Security" isn't clear, then there should be a description here.
     */
    virtual void onSecuritySet(const ::boost::shared_ptr< SecuritySet >& payload);

    /**
     * Sends back the update to a previous onSecuritySet().
     *
     * <b>Documentation of 'Security'</b>:
     *
     * If the meaning of "Security" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onSecuritySet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendSecuritySetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'Security' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Security'</b>:
     *
     * If the meaning of "Security" isn't clear, then there should be a description here.
     */
    void setSecurity(const ::std::string& security);

    /**
     * Returns the current value of the property 'Security'.
     *
     * <b>Documentation of 'Security'</b>:
     *
     * If the meaning of "Security" isn't clear, then there should be a description here.
     */
    const ::std::string& getSecurity() const;

    /**
     * Returns the current value of the property 'Security' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendSecurityUpdate() method.
     *
     * <b>Documentation of 'Security'</b>:
     *
     * If the meaning of "Security" isn't clear, then there should be a description here.
     */
    ::std::string& getSecurityMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSecurityUpdate().
     *
     * <b>Documentation of 'Security'</b>:
     *
     * If the meaning of "Security" isn't clear, then there should be a description here.
     */
    void sendSecurityUpdate();

    // property 'Passphrase'

    /**
     * The method onPassphraseGet() is called by ASF when a client invokes the
     * read method for the property 'Passphrase'. The onPassphraseGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Passphrase'</b>:
     *
     * If the meaning of "Passphrase" isn't clear, then there should be a description here.
     */
    virtual void onPassphraseGet(const ::boost::shared_ptr< PassphraseGet >& payload);

    /**
     * Sends back the update to a previous onPassphraseGet().
     *
     * <b>Documentation of 'Passphrase'</b>:
     *
     * If the meaning of "Passphrase" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onPassphraseGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendPassphraseGetUpdate(const ::std::string& passphrase, act_t act = 0);

    /**
     * The method onPassphraseSet() is called by ASF when a client invokes the
     * write method for the property 'Passphrase'. The onPassphraseSet()
     * method set property value to the given parameter Passphrase by default.
     * If this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Passphrase'</b>:
     *
     * If the meaning of "Passphrase" isn't clear, then there should be a description here.
     */
    virtual void onPassphraseSet(const ::boost::shared_ptr< PassphraseSet >& payload);

    /**
     * Sends back the update to a previous onPassphraseSet().
     *
     * <b>Documentation of 'Passphrase'</b>:
     *
     * If the meaning of "Passphrase" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onPassphraseSet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendPassphraseSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'Passphrase' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'Passphrase'</b>:
     *
     * If the meaning of "Passphrase" isn't clear, then there should be a description here.
     */
    void setPassphrase(const ::std::string& passphrase);

    /**
     * Returns the current value of the property 'Passphrase'.
     *
     * <b>Documentation of 'Passphrase'</b>:
     *
     * If the meaning of "Passphrase" isn't clear, then there should be a description here.
     */
    const ::std::string& getPassphrase() const;

    /**
     * Returns the current value of the property 'Passphrase' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendPassphraseUpdate() method.
     *
     * <b>Documentation of 'Passphrase'</b>:
     *
     * If the meaning of "Passphrase" isn't clear, then there should be a description here.
     */
    ::std::string& getPassphraseMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendPassphraseUpdate().
     *
     * <b>Documentation of 'Passphrase'</b>:
     *
     * If the meaning of "Passphrase" isn't clear, then there should be a description here.
     */
    void sendPassphraseUpdate();

    // property 'CurrentOperatingChannel'

    /**
     * The method onCurrentOperatingChannelGet() is called by ASF when a
     * client invokes the read method for the property
     * 'CurrentOperatingChannel'. The onCurrentOperatingChannelGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'CurrentOperatingChannel'</b>:
     *
     * If the meaning of "CurrentOperatingChannel" isn't clear, then there should be a description here.
     */
    virtual void onCurrentOperatingChannelGet(const ::boost::shared_ptr< CurrentOperatingChannelGet >& payload);

    /**
     * Sends back the update to a previous onCurrentOperatingChannelGet().
     *
     * <b>Documentation of 'CurrentOperatingChannel'</b>:
     *
     * If the meaning of "CurrentOperatingChannel" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of
     * onCurrentOperatingChannelGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendCurrentOperatingChannelGetUpdate(uint16 currentOperatingChannel, act_t act = 0);

    /**
     * Set the value of the property 'CurrentOperatingChannel' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'CurrentOperatingChannel'</b>:
     *
     * If the meaning of "CurrentOperatingChannel" isn't clear, then there should be a description here.
     */
    void setCurrentOperatingChannel(uint16 currentOperatingChannel);

    /**
     * Returns the current value of the property 'CurrentOperatingChannel'.
     *
     * <b>Documentation of 'CurrentOperatingChannel'</b>:
     *
     * If the meaning of "CurrentOperatingChannel" isn't clear, then there should be a description here.
     */
    uint16 getCurrentOperatingChannel() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendCurrentOperatingChannelUpdate().
     *
     * <b>Documentation of 'CurrentOperatingChannel'</b>:
     *
     * If the meaning of "CurrentOperatingChannel" isn't clear, then there should be a description here.
     */
    void sendCurrentOperatingChannelUpdate();

    // property 'HWFeatures'

    /**
     * The method onHWFeaturesGet() is called by ASF when a client invokes the
     * read method for the property 'HWFeatures'. The onHWFeaturesGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'HWFeatures'</b>:
     *
     * If the meaning of "HWFeatures" isn't clear, then there should be a description here.
     */
    virtual void onHWFeaturesGet(const ::boost::shared_ptr< HWFeaturesGet >& payload);

    /**
     * Sends back the update to a previous onHWFeaturesGet().
     *
     * <b>Documentation of 'HWFeatures'</b>:
     *
     * If the meaning of "HWFeatures" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onHWFeaturesGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendHWFeaturesGetUpdate(const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& hWFeatures, act_t act = 0);

    /**
     * Set the value of the property 'HWFeatures' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'HWFeatures'</b>:
     *
     * If the meaning of "HWFeatures" isn't clear, then there should be a description here.
     */
    void setHWFeatures(const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& hWFeatures);

    /**
     * Returns the current value of the property 'HWFeatures'.
     *
     * <b>Documentation of 'HWFeatures'</b>:
     *
     * If the meaning of "HWFeatures" isn't clear, then there should be a description here.
     */
    const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getHWFeatures() const;

    /**
     * Returns the current value of the property 'HWFeatures' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendHWFeaturesUpdate() method.
     *
     * <b>Documentation of 'HWFeatures'</b>:
     *
     * If the meaning of "HWFeatures" isn't clear, then there should be a description here.
     */
    ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getHWFeaturesMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendHWFeaturesUpdate().
     *
     * <b>Documentation of 'HWFeatures'</b>:
     *
     * If the meaning of "HWFeatures" isn't clear, then there should be a description here.
     */
    void sendHWFeaturesUpdate();

    // property 'MaximumStationsAllowed'

    /**
     * The method onMaximumStationsAllowedGet() is called by ASF when a client
     * invokes the read method for the property 'MaximumStationsAllowed'. The
     * onMaximumStationsAllowedGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'MaximumStationsAllowed'</b>:
     *
     * If the meaning of "MaximumStationsAllowed" isn't clear, then there should be a description here.
     */
    virtual void onMaximumStationsAllowedGet(const ::boost::shared_ptr< MaximumStationsAllowedGet >& payload);

    /**
     * Sends back the update to a previous onMaximumStationsAllowedGet().
     *
     * <b>Documentation of 'MaximumStationsAllowed'</b>:
     *
     * If the meaning of "MaximumStationsAllowed" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of
     * onMaximumStationsAllowedGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendMaximumStationsAllowedGetUpdate(uint16 maximumStationsAllowed, act_t act = 0);

    /**
     * The method onMaximumStationsAllowedSet() is called by ASF when a client
     * invokes the write method for the property 'MaximumStationsAllowed'. The
     * onMaximumStationsAllowedSet() method set property value to the given
     * parameter MaximumStationsAllowed by default. If this default behavior
     * doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'MaximumStationsAllowed'</b>:
     *
     * If the meaning of "MaximumStationsAllowed" isn't clear, then there should be a description here.
     */
    virtual void onMaximumStationsAllowedSet(const ::boost::shared_ptr< MaximumStationsAllowedSet >& payload);

    /**
     * Sends back the update to a previous onMaximumStationsAllowedSet().
     *
     * <b>Documentation of 'MaximumStationsAllowed'</b>:
     *
     * If the meaning of "MaximumStationsAllowed" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of
     * onMaximumStationsAllowedSet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendMaximumStationsAllowedSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'MaximumStationsAllowed' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'MaximumStationsAllowed'</b>:
     *
     * If the meaning of "MaximumStationsAllowed" isn't clear, then there should be a description here.
     */
    void setMaximumStationsAllowed(uint16 maximumStationsAllowed);

    /**
     * Returns the current value of the property 'MaximumStationsAllowed'.
     *
     * <b>Documentation of 'MaximumStationsAllowed'</b>:
     *
     * If the meaning of "MaximumStationsAllowed" isn't clear, then there should be a description here.
     */
    uint16 getMaximumStationsAllowed() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendMaximumStationsAllowedUpdate().
     *
     * <b>Documentation of 'MaximumStationsAllowed'</b>:
     *
     * If the meaning of "MaximumStationsAllowed" isn't clear, then there should be a description here.
     */
    void sendMaximumStationsAllowedUpdate();

    // property 'CountryCode'

    /**
     * The method onCountryCodeGet() is called by ASF when a client invokes
     * the read method for the property 'CountryCode'. The onCountryCodeGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'CountryCode'</b>:
     *
     * If the meaning of "CountryCode" isn't clear, then there should be a description here.
     */
    virtual void onCountryCodeGet(const ::boost::shared_ptr< CountryCodeGet >& payload);

    /**
     * Sends back the update to a previous onCountryCodeGet().
     *
     * <b>Documentation of 'CountryCode'</b>:
     *
     * If the meaning of "CountryCode" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onCountryCodeGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendCountryCodeGetUpdate(const ::std::string& countryCode, act_t act = 0);

    /**
     * The method onCountryCodeSet() is called by ASF when a client invokes
     * the write method for the property 'CountryCode'. The onCountryCodeSet()
     * method set property value to the given parameter CountryCode by
     * default. If this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'CountryCode'</b>:
     *
     * If the meaning of "CountryCode" isn't clear, then there should be a description here.
     */
    virtual void onCountryCodeSet(const ::boost::shared_ptr< CountryCodeSet >& payload);

    /**
     * Sends back the update to a previous onCountryCodeSet().
     *
     * <b>Documentation of 'CountryCode'</b>:
     *
     * If the meaning of "CountryCode" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onCountryCodeSet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendCountryCodeSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'CountryCode' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'CountryCode'</b>:
     *
     * If the meaning of "CountryCode" isn't clear, then there should be a description here.
     */
    void setCountryCode(const ::std::string& countryCode);

    /**
     * Returns the current value of the property 'CountryCode'.
     *
     * <b>Documentation of 'CountryCode'</b>:
     *
     * If the meaning of "CountryCode" isn't clear, then there should be a description here.
     */
    const ::std::string& getCountryCode() const;

    /**
     * Returns the current value of the property 'CountryCode' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendCountryCodeUpdate() method.
     *
     * <b>Documentation of 'CountryCode'</b>:
     *
     * If the meaning of "CountryCode" isn't clear, then there should be a description here.
     */
    ::std::string& getCountryCodeMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendCountryCodeUpdate().
     *
     * <b>Documentation of 'CountryCode'</b>:
     *
     * If the meaning of "CountryCode" isn't clear, then there should be a description here.
     */
    void sendCountryCodeUpdate();

    // property 'SupportedChannels'

    /**
     * The method onSupportedChannelsGet() is called by ASF when a client
     * invokes the read method for the property 'SupportedChannels'. The
     * onSupportedChannelsGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'SupportedChannels'</b>:
     *
     * If the meaning of "SupportedChannels" isn't clear, then there should be a description here.
     */
    virtual void onSupportedChannelsGet(const ::boost::shared_ptr< SupportedChannelsGet >& payload);

    /**
     * Sends back the update to a previous onSupportedChannelsGet().
     *
     * <b>Documentation of 'SupportedChannels'</b>:
     *
     * If the meaning of "SupportedChannels" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of
     * onSupportedChannelsGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSupportedChannelsGetUpdate(const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& supportedChannels, act_t act = 0);

    /**
     * Set the value of the property 'SupportedChannels' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'SupportedChannels'</b>:
     *
     * If the meaning of "SupportedChannels" isn't clear, then there should be a description here.
     */
    void setSupportedChannels(const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& supportedChannels);

    /**
     * Returns the current value of the property 'SupportedChannels'.
     *
     * <b>Documentation of 'SupportedChannels'</b>:
     *
     * If the meaning of "SupportedChannels" isn't clear, then there should be a description here.
     */
    const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getSupportedChannels() const;

    /**
     * Returns the current value of the property 'SupportedChannels' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendSupportedChannelsUpdate() method.
     *
     * <b>Documentation of 'SupportedChannels'</b>:
     *
     * If the meaning of "SupportedChannels" isn't clear, then there should be a description here.
     */
    ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getSupportedChannelsMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSupportedChannelsUpdate().
     *
     * <b>Documentation of 'SupportedChannels'</b>:
     *
     * If the meaning of "SupportedChannels" isn't clear, then there should be a description here.
     */
    void sendSupportedChannelsUpdate();

    // property 'AccessNetworkType'

    /**
     * The method onAccessNetworkTypeGet() is called by ASF when a client
     * invokes the read method for the property 'AccessNetworkType'. The
     * onAccessNetworkTypeGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'AccessNetworkType'</b>:
     *
     * If the meaning of "AccessNetworkType" isn't clear, then there should be a description here.
     */
    virtual void onAccessNetworkTypeGet(const ::boost::shared_ptr< AccessNetworkTypeGet >& payload);

    /**
     * Sends back the update to a previous onAccessNetworkTypeGet().
     *
     * <b>Documentation of 'AccessNetworkType'</b>:
     *
     * If the meaning of "AccessNetworkType" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of
     * onAccessNetworkTypeGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendAccessNetworkTypeGetUpdate(uint16 accessNetworkType, act_t act = 0);

    /**
     * The method onAccessNetworkTypeSet() is called by ASF when a client
     * invokes the write method for the property 'AccessNetworkType'. The
     * onAccessNetworkTypeSet() method set property value to the given
     * parameter AccessNetworkType by default. If this default behavior
     * doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'AccessNetworkType'</b>:
     *
     * If the meaning of "AccessNetworkType" isn't clear, then there should be a description here.
     */
    virtual void onAccessNetworkTypeSet(const ::boost::shared_ptr< AccessNetworkTypeSet >& payload);

    /**
     * Sends back the update to a previous onAccessNetworkTypeSet().
     *
     * <b>Documentation of 'AccessNetworkType'</b>:
     *
     * If the meaning of "AccessNetworkType" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of
     * onAccessNetworkTypeSet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendAccessNetworkTypeSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'AccessNetworkType' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'AccessNetworkType'</b>:
     *
     * If the meaning of "AccessNetworkType" isn't clear, then there should be a description here.
     */
    void setAccessNetworkType(uint16 accessNetworkType);

    /**
     * Returns the current value of the property 'AccessNetworkType'.
     *
     * <b>Documentation of 'AccessNetworkType'</b>:
     *
     * If the meaning of "AccessNetworkType" isn't clear, then there should be a description here.
     */
    uint16 getAccessNetworkType() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendAccessNetworkTypeUpdate().
     *
     * <b>Documentation of 'AccessNetworkType'</b>:
     *
     * If the meaning of "AccessNetworkType" isn't clear, then there should be a description here.
     */
    void sendAccessNetworkTypeUpdate();

    // method 'setSSID'

    /**
     * The method onSetSSID() is called by ASF when a client invokes the
     * method 'setSSID'. A subclass has to implement this method and send back
     * a response to the client either with the sendSetSSID() or
     * sendSetSSIDError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'setSSID'</b>:
     *
     * If the meaning of "setSSID" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetSSIDRequest (const ::boost::shared_ptr< SetSSIDRequest >& request) = 0;

    /**
     * The method sendSetSSIDResponse() sends a response of a previous method
     * invocation of 'setSSID' back to the client.
     *
     * <b>Documentation of 'setSSID'</b>:
     *
     * If the meaning of "setSSID" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetSSID(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendSetSSIDResponse (act_t act = 0);

    /**
     * The method sendSetSSIDError() sends an error response of a previous
     * method invocation of 'setSSID' back to the client.
     *
     * <b>Documentation of 'setSSID'</b>:
     *
     * If the meaning of "setSSID" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSetSSID(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendSetSSIDError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'DeAuthenticateStation'

    /**
     * The method onDeAuthenticateStation() is called by ASF when a client
     * invokes the method 'DeAuthenticateStation'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendDeAuthenticateStation() or sendDeAuthenticateStationError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'DeAuthenticateStation'</b>:
     *
     * If the meaning of "DeAuthenticateStation" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onDeAuthenticateStationRequest (const ::boost::shared_ptr< DeAuthenticateStationRequest >& request) = 0;

    /**
     * The method sendDeAuthenticateStationResponse() sends a response of a
     * previous method invocation of 'DeAuthenticateStation' back to the
     * client.
     *
     * <b>Documentation of 'DeAuthenticateStation'</b>:
     *
     * If the meaning of "DeAuthenticateStation" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onDeAuthenticateStation(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendDeAuthenticateStationResponse (act_t act = 0);

    /**
     * The method sendDeAuthenticateStationError() sends an error response of
     * a previous method invocation of 'DeAuthenticateStation' back to the
     * client.
     *
     * <b>Documentation of 'DeAuthenticateStation'</b>:
     *
     * If the meaning of "DeAuthenticateStation" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onDeAuthenticateStation(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendDeAuthenticateStationError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'BlacklistStation'

    /**
     * The method onBlacklistStation() is called by ASF when a client invokes
     * the method 'BlacklistStation'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendBlacklistStation() or sendBlacklistStationError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'BlacklistStation'</b>:
     *
     * If the meaning of "BlacklistStation" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onBlacklistStationRequest (const ::boost::shared_ptr< BlacklistStationRequest >& request) = 0;

    /**
     * The method sendBlacklistStationResponse() sends a response of a
     * previous method invocation of 'BlacklistStation' back to the client.
     *
     * <b>Documentation of 'BlacklistStation'</b>:
     *
     * If the meaning of "BlacklistStation" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onBlacklistStation(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendBlacklistStationResponse (act_t act = 0);

    /**
     * The method sendBlacklistStationError() sends an error response of a
     * previous method invocation of 'BlacklistStation' back to the client.
     *
     * <b>Documentation of 'BlacklistStation'</b>:
     *
     * If the meaning of "BlacklistStation" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onBlacklistStation(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendBlacklistStationError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'SetOperatingChannels'

    /**
     * The method onSetOperatingChannels() is called by ASF when a client
     * invokes the method 'SetOperatingChannels'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendSetOperatingChannels() or sendSetOperatingChannelsError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'SetOperatingChannels'</b>:
     *
     * If the meaning of "SetOperatingChannels" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetOperatingChannelsRequest (const ::boost::shared_ptr< SetOperatingChannelsRequest >& request) = 0;

    /**
     * The method sendSetOperatingChannelsResponse() sends a response of a
     * previous method invocation of 'SetOperatingChannels' back to the
     * client.
     *
     * <b>Documentation of 'SetOperatingChannels'</b>:
     *
     * If the meaning of "SetOperatingChannels" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetOperatingChannels(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSetOperatingChannelsResponse (act_t act = 0);

    /**
     * The method sendSetOperatingChannelsError() sends an error response of a
     * previous method invocation of 'SetOperatingChannels' back to the
     * client.
     *
     * <b>Documentation of 'SetOperatingChannels'</b>:
     *
     * If the meaning of "SetOperatingChannels" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onSetOperatingChannels(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSetOperatingChannelsError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'StartWPSPushButton'

    /**
     * The method onStartWPSPushButton() is called by ASF when a client
     * invokes the method 'StartWPSPushButton'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendStartWPSPushButton() or sendStartWPSPushButtonError() method. Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'StartWPSPushButton'</b>:
     *
     * If the meaning of "StartWPSPushButton" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onStartWPSPushButtonRequest (const ::boost::shared_ptr< StartWPSPushButtonRequest >& request) = 0;

    /**
     * The method sendStartWPSPushButtonResponse() sends a response of a
     * previous method invocation of 'StartWPSPushButton' back to the client.
     *
     * <b>Documentation of 'StartWPSPushButton'</b>:
     *
     * If the meaning of "StartWPSPushButton" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onStartWPSPushButton(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendStartWPSPushButtonResponse (act_t act = 0);

    /**
     * The method sendStartWPSPushButtonError() sends an error response of a
     * previous method invocation of 'StartWPSPushButton' back to the client.
     *
     * <b>Documentation of 'StartWPSPushButton'</b>:
     *
     * If the meaning of "StartWPSPushButton" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onStartWPSPushButton().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendStartWPSPushButtonError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'CancelWPS'

    /**
     * The method onCancelWPS() is called by ASF when a client invokes the
     * method 'CancelWPS'. A subclass has to implement this method and send
     * back a response to the client either with the sendCancelWPS() or
     * sendCancelWPSError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'CancelWPS'</b>:
     *
     * If the meaning of "CancelWPS" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onCancelWPSRequest (const ::boost::shared_ptr< CancelWPSRequest >& request) = 0;

    /**
     * The method sendCancelWPSResponse() sends a response of a previous
     * method invocation of 'CancelWPS' back to the client.
     *
     * <b>Documentation of 'CancelWPS'</b>:
     *
     * If the meaning of "CancelWPS" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onCancelWPS(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendCancelWPSResponse (act_t act = 0);

    /**
     * The method sendCancelWPSError() sends an error response of a previous
     * method invocation of 'CancelWPS' back to the client.
     *
     * <b>Documentation of 'CancelWPS'</b>:
     *
     * If the meaning of "CancelWPS" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onCancelWPS(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendCancelWPSError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'GetAssociatedStations'

    /**
     * The method onGetAssociatedStations() is called by ASF when a client
     * invokes the method 'GetAssociatedStations'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendGetAssociatedStations() or sendGetAssociatedStationsError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'GetAssociatedStations'</b>:
     *
     * If the meaning of "GetAssociatedStations" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetAssociatedStationsRequest (const ::boost::shared_ptr< GetAssociatedStationsRequest >& request) = 0;

    /**
     * The method sendGetAssociatedStationsResponse() sends a response of a
     * previous method invocation of 'GetAssociatedStations' back to the
     * client.
     *
     * <b>Documentation of 'GetAssociatedStations'</b>:
     *
     * If the meaning of "GetAssociatedStations" isn't clear, then there should be a description here.
     *
     * @param associatedstations If the meaning of "associatedstations" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetAssociatedStations(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendGetAssociatedStationsResponse (const ::std::vector< GetAssociatedStationsResponseAssociatedstationsStruct >& associatedstations, act_t act = 0);

    /**
     * The method sendGetAssociatedStationsError() sends an error response of
     * a previous method invocation of 'GetAssociatedStations' back to the
     * client.
     *
     * <b>Documentation of 'GetAssociatedStations'</b>:
     *
     * If the meaning of "GetAssociatedStations" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onGetAssociatedStations(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendGetAssociatedStationsError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'RegisterVendorService'

    /**
     * The method onRegisterVendorService() is called by ASF when a client
     * invokes the method 'RegisterVendorService'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendRegisterVendorService() or sendRegisterVendorServiceError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'RegisterVendorService'</b>:
     *
     * If the meaning of "RegisterVendorService" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRegisterVendorServiceRequest (const ::boost::shared_ptr< RegisterVendorServiceRequest >& request) = 0;

    /**
     * The method sendRegisterVendorServiceResponse() sends a response of a
     * previous method invocation of 'RegisterVendorService' back to the
     * client.
     *
     * <b>Documentation of 'RegisterVendorService'</b>:
     *
     * If the meaning of "RegisterVendorService" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onRegisterVendorService(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRegisterVendorServiceResponse (act_t act = 0);

    /**
     * The method sendRegisterVendorServiceError() sends an error response of
     * a previous method invocation of 'RegisterVendorService' back to the
     * client.
     *
     * <b>Documentation of 'RegisterVendorService'</b>:
     *
     * If the meaning of "RegisterVendorService" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onRegisterVendorService(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRegisterVendorServiceError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'UnregisterVendorService'

    /**
     * The method onUnregisterVendorService() is called by ASF when a client
     * invokes the method 'UnregisterVendorService'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendUnregisterVendorService() or
     * sendUnregisterVendorServiceError() method. Do not invoke this method on
     * your own.
     *
     * <b>Documentation of 'UnregisterVendorService'</b>:
     *
     * If the meaning of "UnregisterVendorService" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onUnregisterVendorServiceRequest (const ::boost::shared_ptr< UnregisterVendorServiceRequest >& request) = 0;

    /**
     * The method sendUnregisterVendorServiceResponse() sends a response of a
     * previous method invocation of 'UnregisterVendorService' back to the
     * client.
     *
     * <b>Documentation of 'UnregisterVendorService'</b>:
     *
     * If the meaning of "UnregisterVendorService" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onUnregisterVendorService(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendUnregisterVendorServiceResponse (act_t act = 0);

    /**
     * The method sendUnregisterVendorServiceError() sends an error response
     * of a previous method invocation of 'UnregisterVendorService' back to
     * the client.
     *
     * <b>Documentation of 'UnregisterVendorService'</b>:
     *
     * If the meaning of "UnregisterVendorService" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onUnregisterVendorService(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendUnregisterVendorServiceError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'GetDnsDhcpConf'

    /**
     * The method onGetDnsDhcpConf() is called by ASF when a client invokes
     * the method 'GetDnsDhcpConf'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendGetDnsDhcpConf() or sendGetDnsDhcpConfError() method. Do not invoke
     * this method on your own.
     *
     * <b>Documentation of 'GetDnsDhcpConf'</b>:
     *
     * If the meaning of "GetDnsDhcpConf" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetDnsDhcpConfRequest (const ::boost::shared_ptr< GetDnsDhcpConfRequest >& request) = 0;

    /**
     * The method sendGetDnsDhcpConfResponse() sends a response of a previous
     * method invocation of 'GetDnsDhcpConf' back to the client.
     *
     * <b>Documentation of 'GetDnsDhcpConf'</b>:
     *
     * If the meaning of "GetDnsDhcpConf" isn't clear, then there should be a description here.
     *
     * @param dnsdhcpserverconf If the meaning of "dnsdhcpserverconf" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetDnsDhcpConf(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendGetDnsDhcpConfResponse (const GetDnsDhcpConfResponseDnsdhcpserverconfStruct& dnsdhcpserverconf, act_t act = 0);

    /**
     * The method sendGetDnsDhcpConfError() sends an error response of a
     * previous method invocation of 'GetDnsDhcpConf' back to the client.
     *
     * <b>Documentation of 'GetDnsDhcpConf'</b>:
     *
     * If the meaning of "GetDnsDhcpConf" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGetDnsDhcpConf(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendGetDnsDhcpConfError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'RestoreDefaultAPSettings'

    /**
     * The method onRestoreDefaultAPSettings() is called by ASF when a client
     * invokes the method 'RestoreDefaultAPSettings'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendRestoreDefaultAPSettings() or
     * sendRestoreDefaultAPSettingsError() method. Do not invoke this method
     * on your own.
     *
     * <b>Documentation of 'RestoreDefaultAPSettings'</b>:
     *
     * If the meaning of "RestoreDefaultAPSettings" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRestoreDefaultAPSettingsRequest (const ::boost::shared_ptr< RestoreDefaultAPSettingsRequest >& request) = 0;

    /**
     * The method sendRestoreDefaultAPSettingsResponse() sends a response of a
     * previous method invocation of 'RestoreDefaultAPSettings' back to the
     * client.
     *
     * <b>Documentation of 'RestoreDefaultAPSettings'</b>:
     *
     * If the meaning of "RestoreDefaultAPSettings" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onRestoreDefaultAPSettings(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRestoreDefaultAPSettingsResponse (act_t act = 0);

    /**
     * The method sendRestoreDefaultAPSettingsError() sends an error response
     * of a previous method invocation of 'RestoreDefaultAPSettings' back to
     * the client.
     *
     * <b>Documentation of 'RestoreDefaultAPSettings'</b>:
     *
     * If the meaning of "RestoreDefaultAPSettings" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onRestoreDefaultAPSettings(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRestoreDefaultAPSettingsError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    MacAddressUpdate _MacAddressProperty;

    SSIDUpdate _SSIDProperty;

    InterfaceUpdate _InterfaceProperty;

    BlackListedStationsUpdate _BlackListedStationsProperty;

    PowerStateUpdate _PowerStateProperty;

    PowerFailureReasonUpdate _PowerFailureReasonProperty;

    PoweredUpdate _PoweredProperty;

    HiddenUpdate _HiddenProperty;

    SecurityUpdate _SecurityProperty;

    PassphraseUpdate _PassphraseProperty;

    CurrentOperatingChannelUpdate _CurrentOperatingChannelProperty;

    HWFeaturesUpdate _HWFeaturesProperty;

    MaximumStationsAllowedUpdate _MaximumStationsAllowedProperty;

    CountryCodeUpdate _CountryCodeProperty;

    SupportedChannelsUpdate _SupportedChannelsProperty;

    AccessNetworkTypeUpdate _AccessNetworkTypeProperty;

    friend class AccesspointStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace Accesspoint
} // namespace wapdman
} // namespace bosch
} // namespace org

#endif // ORG_BOSCH_WAPDMAN_ACCESSPOINTSTUB_H
