/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/wapdman/Accesspoint.h"
#include "org/bosch/wapdman/AccesspointDBus.h"
#include "org/bosch/wapdman/AccesspointJson.h"
#include "org/bosch/wapdman/AccesspointStub.h"
#include <map>
#include <string>
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bosch {
namespace wapdman {
namespace Accesspoint {

DEFINE_CLASS_LOGGER("//org/bosch/wapdman/accesspoint_XX_XX_XX_XX_XX_XX/org/bosch/wapdman/Accesspoint", AccesspointStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 7, "setSSID", 0 },
    { 9, "CancelWPS", 5 },
    { 14, "GetDnsDhcpConf", 9 },
    { 16, "BlacklistStation", 2 },
    { 18, "StartWPSPushButton", 4 },
    { 20, "SetOperatingChannels", 3 },
    { 21, "DeAuthenticateStation", 1 },
    { 21, "GetAssociatedStations", 6 },
    { 21, "RegisterVendorService", 7 },
    { 23, "UnregisterVendorService", 8 },
    { 24, "RestoreDefaultAPSettings", 10 },
};

static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 4, "SSID", 1 },
    { 6, "Hidden", 7 },
    { 7, "Powered", 6 },
    { 8, "Security", 8 },
    { 9, "Interface", 2 },
    { 10, "HWFeatures", 11 },
    { 10, "MacAddress", 0 },
    { 10, "Passphrase", 9 },
    { 10, "PowerState", 4 },
    { 11, "CountryCode", 13 },
    { 17, "AccessNetworkType", 15 },
    { 17, "SupportedChannels", 14 },
    { 18, "PowerFailureReason", 5 },
    { 19, "BlackListedStations", 3 },
    { 22, "MaximumStationsAllowed", 12 },
    { 23, "CurrentOperatingChannel", 10 },
};

class AccesspointStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    AccesspointStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    AccesspointStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    AccesspointStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.bosch.wapdman.Accesspoint"),
          _logger(logger) {}

    virtual ~AccesspointStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void AccesspointStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 11, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'setSSID'

            LOG_DEBUG_STUB("process method '%s'", "setSSID");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetSSIDRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetSSID", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetSSIDRequest > payload = ::boost::static_pointer_cast<SetSSIDRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<AccesspointStub*>(getStub())->onSetSSIDRequest(payload);
            return;
        }
        case 1: {

            // method 'DeAuthenticateStation'

            LOG_DEBUG_STUB("process method '%s'", "DeAuthenticateStation");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DeAuthenticateStationRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "DeAuthenticateStation", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< DeAuthenticateStationRequest > payload = ::boost::static_pointer_cast<DeAuthenticateStationRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<AccesspointStub*>(getStub())->onDeAuthenticateStationRequest(payload);
            return;
        }
        case 2: {

            // method 'BlacklistStation'

            LOG_DEBUG_STUB("process method '%s'", "BlacklistStation");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BlacklistStationRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "BlacklistStation", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< BlacklistStationRequest > payload = ::boost::static_pointer_cast<BlacklistStationRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<AccesspointStub*>(getStub())->onBlacklistStationRequest(payload);
            return;
        }
        case 3: {

            // method 'SetOperatingChannels'

            LOG_DEBUG_STUB("process method '%s'", "SetOperatingChannels");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetOperatingChannelsRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetOperatingChannels", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetOperatingChannelsRequest > payload = ::boost::static_pointer_cast<SetOperatingChannelsRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<AccesspointStub*>(getStub())->onSetOperatingChannelsRequest(payload);
            return;
        }
        case 4: {

            // method 'StartWPSPushButton'

            LOG_DEBUG_STUB("process method '%s'", "StartWPSPushButton");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartWPSPushButtonRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "StartWPSPushButton", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< StartWPSPushButtonRequest > payload = ::boost::static_pointer_cast<StartWPSPushButtonRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<AccesspointStub*>(getStub())->onStartWPSPushButtonRequest(payload);
            return;
        }
        case 5: {

            // method 'CancelWPS'

            LOG_DEBUG_STUB("process method '%s'", "CancelWPS");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CancelWPSRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "CancelWPS", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< CancelWPSRequest > payload = ::boost::static_pointer_cast<CancelWPSRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<AccesspointStub*>(getStub())->onCancelWPSRequest(payload);
            return;
        }
        case 6: {

            // method 'GetAssociatedStations'

            LOG_DEBUG_STUB("process method '%s'", "GetAssociatedStations");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetAssociatedStationsRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetAssociatedStations", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetAssociatedStationsRequest > payload = ::boost::static_pointer_cast<GetAssociatedStationsRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<AccesspointStub*>(getStub())->onGetAssociatedStationsRequest(payload);
            return;
        }
        case 7: {

            // method 'RegisterVendorService'

            LOG_DEBUG_STUB("process method '%s'", "RegisterVendorService");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RegisterVendorServiceRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RegisterVendorService", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RegisterVendorServiceRequest > payload = ::boost::static_pointer_cast<RegisterVendorServiceRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<AccesspointStub*>(getStub())->onRegisterVendorServiceRequest(payload);
            return;
        }
        case 8: {

            // method 'UnregisterVendorService'

            LOG_DEBUG_STUB("process method '%s'", "UnregisterVendorService");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UnregisterVendorServiceRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "UnregisterVendorService", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< UnregisterVendorServiceRequest > payload = ::boost::static_pointer_cast<UnregisterVendorServiceRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<AccesspointStub*>(getStub())->onUnregisterVendorServiceRequest(payload);
            return;
        }
        case 9: {

            // method 'GetDnsDhcpConf'

            LOG_DEBUG_STUB("process method '%s'", "GetDnsDhcpConf");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetDnsDhcpConfRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetDnsDhcpConf", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetDnsDhcpConfRequest > payload = ::boost::static_pointer_cast<GetDnsDhcpConfRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<AccesspointStub*>(getStub())->onGetDnsDhcpConfRequest(payload);
            return;
        }
        case 10: {

            // method 'RestoreDefaultAPSettings'

            LOG_DEBUG_STUB("process method '%s'", "RestoreDefaultAPSettings");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RestoreDefaultAPSettingsRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RestoreDefaultAPSettings", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RestoreDefaultAPSettingsRequest > payload = ::boost::static_pointer_cast<RestoreDefaultAPSettingsRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<AccesspointStub*>(getStub())->onRestoreDefaultAPSettingsRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* AccesspointStubDelegate::introspect() const {
    return     "<interface name=\"org.bosch.wapdman.Accesspoint\">\n"
            "      <method name=\"setSSID\">\n"
            "        <arg direction=\"in\" name=\"ssid\" type=\"ay\"/>\n"
            "        <arg direction=\"in\" name=\"utf_ssid\" type=\"b\"/>\n"
            "      </method>\n"
            "      <method name=\"DeAuthenticateStation\">\n"
            "        <annotation name=\"org.freedesktop.DBus.GLib.Async\" value=\"yes\"/>\n"
            "        <arg direction=\"in\" name=\"address\" type=\"s\"/>\n"
            "      </method>\n"
            "      <method name=\"BlacklistStation\">\n"
            "        <annotation name=\"org.freedesktop.DBus.GLib.Async\" value=\"yes\"/>\n"
            "        <arg direction=\"in\" name=\"address\" type=\"s\"/>\n"
            "        <arg direction=\"in\" name=\"allow\" type=\"b\"/>\n"
            "      </method>\n"
            "      <method name=\"SetOperatingChannels\">\n"
            "        <annotation name=\"org.freedesktop.DBus.GLib.Async\" value=\"yes\"/>\n"
            "        <arg direction=\"in\" name=\"channels\" type=\"aq\"/>\n"
            "      </method>\n"
            "      <method name=\"StartWPSPushButton\">\n"
            "        <annotation name=\"org.freedesktop.DBus.GLib.Async\" value=\"yes\"/>\n"
            "      </method>\n"
            "      <method name=\"CancelWPS\">\n"
            "        <annotation name=\"org.freedesktop.DBus.GLib.Async\" value=\"yes\"/>\n"
            "      </method>\n"
            "      <method name=\"GetAssociatedStations\">\n"
            "        <arg direction=\"out\" name=\"associatedstations\" type=\"a(oa{sv})\"/>\n"
            "      </method>\n"
            "      <method name=\"RegisterVendorService\">\n"
            "        <annotation name=\"org.freedesktop.DBus.GLib.Async\" value=\"yes\"/>\n"
            "        <arg direction=\"in\" name=\"IEs\" type=\"aay\"/>\n"
            "      </method>\n"
            "      <method name=\"UnregisterVendorService\">\n"
            "        <annotation name=\"org.freedesktop.DBus.GLib.Async\" value=\"yes\"/>\n"
            "        <arg direction=\"in\" name=\"IEs\" type=\"aay\"/>\n"
            "      </method>\n"
            "      <method name=\"GetDnsDhcpConf\">\n"
            "        <arg direction=\"out\" name=\"dnsdhcpserverconf\" type=\"(oa{sv})\"/>\n"
            "      </method>\n"
            "      <method name=\"RestoreDefaultAPSettings\">\n"
            "        <annotation name=\"org.freedesktop.DBus.GLib.Async\" value=\"yes\"/>\n"
            "      </method>\n"
            "      <signal name=\"AssociatedStationsChanged\">\n"
            "        <arg name=\"changedstations\" type=\"a(oa{sv})\"/>\n"
            "        <arg name=\"removedstations\" type=\"ao\"/>\n"
            "      </signal>\n"
            "      <signal name=\"AssociationRequestRejected\">\n"
            "        <arg name=\"station\" type=\"a{sv}\"/>\n"
            "      </signal>\n"
            "      <property access=\"read\" name=\"MacAddress\" type=\"s\"/>\n"
            "      <property access=\"read\" name=\"SSID\" type=\"ay\"/>\n"
            "      <property access=\"read\" name=\"Interface\" type=\"s\"/>\n"
            "      <property access=\"read\" name=\"BlackListedStations\" type=\"as\"/>\n"
            "      <property access=\"read\" name=\"PowerState\" type=\"s\"/>\n"
            "      <property access=\"read\" name=\"PowerFailureReason\" type=\"s\"/>\n"
            "      <property access=\"readwrite\" name=\"Powered\" type=\"b\"/>\n"
            "      <property access=\"readwrite\" name=\"Hidden\" type=\"b\"/>\n"
            "      <property access=\"readwrite\" name=\"Security\" type=\"s\"/>\n"
            "      <property access=\"readwrite\" name=\"Passphrase\" type=\"s\"/>\n"
            "      <property access=\"read\" name=\"CurrentOperatingChannel\" type=\"q\"/>\n"
            "      <property access=\"read\" name=\"HWFeatures\" type=\"a{sv}\"/>\n"
            "      <property access=\"readwrite\" name=\"MaximumStationsAllowed\" type=\"q\"/>\n"
            "      <property access=\"readwrite\" name=\"CountryCode\" type=\"s\"/>\n"
            "      <property access=\"read\" name=\"SupportedChannels\" type=\"a{sv}\"/>\n"
            "      <property access=\"readwrite\" name=\"AccessNetworkType\" type=\"q\"/>\n"
            "</interface>\n";
}

void AccesspointStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<AccesspointStub*>(getStub()))->onGetAll (properties);
}

void AccesspointStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 16, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "MacAddress");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "SSID");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "Interface");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "BlackListedStations");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "PowerState");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 5: {
            LOG_DEBUG_STUB("process property '%s'", "PowerFailureReason");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 6: {
            LOG_DEBUG_STUB("process property '%s'", "Powered");
            ::boost::shared_ptr< PoweredSet > payload(new PoweredSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<AccesspointStub*>(getStub())->onPoweredSet (payload);
            return;
        }
        case 7: {
            LOG_DEBUG_STUB("process property '%s'", "Hidden");
            ::boost::shared_ptr< HiddenSet > payload(new HiddenSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<AccesspointStub*>(getStub())->onHiddenSet (payload);
            return;
        }
        case 8: {
            LOG_DEBUG_STUB("process property '%s'", "Security");
            ::boost::shared_ptr< SecuritySet > payload(new SecuritySet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<AccesspointStub*>(getStub())->onSecuritySet (payload);
            return;
        }
        case 9: {
            LOG_DEBUG_STUB("process property '%s'", "Passphrase");
            ::boost::shared_ptr< PassphraseSet > payload(new PassphraseSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<AccesspointStub*>(getStub())->onPassphraseSet (payload);
            return;
        }
        case 10: {
            LOG_DEBUG_STUB("process property '%s'", "CurrentOperatingChannel");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 11: {
            LOG_DEBUG_STUB("process property '%s'", "HWFeatures");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 12: {
            LOG_DEBUG_STUB("process property '%s'", "MaximumStationsAllowed");
            ::boost::shared_ptr< MaximumStationsAllowedSet > payload(new MaximumStationsAllowedSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<AccesspointStub*>(getStub())->onMaximumStationsAllowedSet (payload);
            return;
        }
        case 13: {
            LOG_DEBUG_STUB("process property '%s'", "CountryCode");
            ::boost::shared_ptr< CountryCodeSet > payload(new CountryCodeSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<AccesspointStub*>(getStub())->onCountryCodeSet (payload);
            return;
        }
        case 14: {
            LOG_DEBUG_STUB("process property '%s'", "SupportedChannels");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 15: {
            LOG_DEBUG_STUB("process property '%s'", "AccessNetworkType");
            ::boost::shared_ptr< AccessNetworkTypeSet > payload(new AccessNetworkTypeSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<AccesspointStub*>(getStub())->onAccessNetworkTypeSet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void AccesspointStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 16, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "MacAddress");
            ::boost::shared_ptr< MacAddressGet > payload(new MacAddressGet());
            payload->setAct(act);
            static_cast<AccesspointStub*>(getStub())->onMacAddressGet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "SSID");
            ::boost::shared_ptr< SSIDGet > payload(new SSIDGet());
            payload->setAct(act);
            static_cast<AccesspointStub*>(getStub())->onSSIDGet (payload);
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "Interface");
            ::boost::shared_ptr< InterfaceGet > payload(new InterfaceGet());
            payload->setAct(act);
            static_cast<AccesspointStub*>(getStub())->onInterfaceGet (payload);
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "BlackListedStations");
            ::boost::shared_ptr< BlackListedStationsGet > payload(new BlackListedStationsGet());
            payload->setAct(act);
            static_cast<AccesspointStub*>(getStub())->onBlackListedStationsGet (payload);
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "PowerState");
            ::boost::shared_ptr< PowerStateGet > payload(new PowerStateGet());
            payload->setAct(act);
            static_cast<AccesspointStub*>(getStub())->onPowerStateGet (payload);
            return;
        }
        case 5: {
            LOG_DEBUG_STUB("process property '%s'", "PowerFailureReason");
            ::boost::shared_ptr< PowerFailureReasonGet > payload(new PowerFailureReasonGet());
            payload->setAct(act);
            static_cast<AccesspointStub*>(getStub())->onPowerFailureReasonGet (payload);
            return;
        }
        case 6: {
            LOG_DEBUG_STUB("process property '%s'", "Powered");
            ::boost::shared_ptr< PoweredGet > payload(new PoweredGet());
            payload->setAct(act);
            static_cast<AccesspointStub*>(getStub())->onPoweredGet (payload);
            return;
        }
        case 7: {
            LOG_DEBUG_STUB("process property '%s'", "Hidden");
            ::boost::shared_ptr< HiddenGet > payload(new HiddenGet());
            payload->setAct(act);
            static_cast<AccesspointStub*>(getStub())->onHiddenGet (payload);
            return;
        }
        case 8: {
            LOG_DEBUG_STUB("process property '%s'", "Security");
            ::boost::shared_ptr< SecurityGet > payload(new SecurityGet());
            payload->setAct(act);
            static_cast<AccesspointStub*>(getStub())->onSecurityGet (payload);
            return;
        }
        case 9: {
            LOG_DEBUG_STUB("process property '%s'", "Passphrase");
            ::boost::shared_ptr< PassphraseGet > payload(new PassphraseGet());
            payload->setAct(act);
            static_cast<AccesspointStub*>(getStub())->onPassphraseGet (payload);
            return;
        }
        case 10: {
            LOG_DEBUG_STUB("process property '%s'", "CurrentOperatingChannel");
            ::boost::shared_ptr< CurrentOperatingChannelGet > payload(new CurrentOperatingChannelGet());
            payload->setAct(act);
            static_cast<AccesspointStub*>(getStub())->onCurrentOperatingChannelGet (payload);
            return;
        }
        case 11: {
            LOG_DEBUG_STUB("process property '%s'", "HWFeatures");
            ::boost::shared_ptr< HWFeaturesGet > payload(new HWFeaturesGet());
            payload->setAct(act);
            static_cast<AccesspointStub*>(getStub())->onHWFeaturesGet (payload);
            return;
        }
        case 12: {
            LOG_DEBUG_STUB("process property '%s'", "MaximumStationsAllowed");
            ::boost::shared_ptr< MaximumStationsAllowedGet > payload(new MaximumStationsAllowedGet());
            payload->setAct(act);
            static_cast<AccesspointStub*>(getStub())->onMaximumStationsAllowedGet (payload);
            return;
        }
        case 13: {
            LOG_DEBUG_STUB("process property '%s'", "CountryCode");
            ::boost::shared_ptr< CountryCodeGet > payload(new CountryCodeGet());
            payload->setAct(act);
            static_cast<AccesspointStub*>(getStub())->onCountryCodeGet (payload);
            return;
        }
        case 14: {
            LOG_DEBUG_STUB("process property '%s'", "SupportedChannels");
            ::boost::shared_ptr< SupportedChannelsGet > payload(new SupportedChannelsGet());
            payload->setAct(act);
            static_cast<AccesspointStub*>(getStub())->onSupportedChannelsGet (payload);
            return;
        }
        case 15: {
            LOG_DEBUG_STUB("process property '%s'", "AccessNetworkType");
            ::boost::shared_ptr< AccessNetworkTypeGet > payload(new AccessNetworkTypeGet());
            payload->setAct(act);
            static_cast<AccesspointStub*>(getStub())->onAccessNetworkTypeGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

AccesspointStub::AccesspointStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new AccesspointStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

AccesspointStub::AccesspointStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new AccesspointStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

AccesspointStub::~AccesspointStub() {
    delete _stubDelegate;
}

void AccesspointStub::sendAssociatedStationsChangedSignal(const ::std::vector< AssociatedStationsChangedSignalChangedstationsStruct >& changedstations, const ::std::vector< ::std::string >& removedstations) {
    if (_stubDelegate->isConnected()) {
        AssociatedStationsChangedSignal* payload = new AssociatedStationsChangedSignal(changedstations, removedstations);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "AssociatedStationsChanged", AssociatedStationsChangedSignal, payload)
        LOG_INFO ("-> send%sSignal", "AssociatedStationsChanged");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "AssociatedStationsChanged");
    }
}

void AccesspointStub::sendAssociationRequestRejectedSignal(const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& station) {
    if (_stubDelegate->isConnected()) {
        AssociationRequestRejectedSignal* payload = new AssociationRequestRejectedSignal(station);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "AssociationRequestRejected", AssociationRequestRejectedSignal, payload)
        LOG_INFO ("-> send%sSignal", "AssociationRequestRejected");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "AssociationRequestRejected");
    }
}

void AccesspointStub::sendMacAddressUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        MacAddressUpdate payload(_MacAddressProperty);

        LOG_INFO ("-> send%s", "MacAddressUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("MacAddress", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.wapdman.Accesspoint", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "MacAddressUpdate");
    }
}

void AccesspointStub::onMacAddressGet(const ::boost::shared_ptr< MacAddressGet >& macAddress) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "MacAddressGet", macAddress->getAct());
    sendMacAddressGetUpdate(_MacAddressProperty.getMacAddress(), macAddress->getAct());
}

void AccesspointStub::sendMacAddressGetUpdate(const ::std::string& macAddress, act_t act) {
    ::asf::dbus::DBusVariant variant;
    MacAddressGet payload(macAddress);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "MacAddressGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void AccesspointStub::setMacAddress(const ::std::string& macAddress) {
    if(macAddress!=_MacAddressProperty.getMacAddress()) {
        _MacAddressProperty.setMacAddress(macAddress);
        sendMacAddressUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& AccesspointStub::getMacAddress() const {
    return _MacAddressProperty.getMacAddress();
}

::std::string& AccesspointStub::getMacAddressMutable() {
    return _MacAddressProperty.getMacAddressMutable();
}

void AccesspointStub::sendSSIDUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SSIDUpdate payload(_SSIDProperty);

        LOG_INFO ("-> send%s", "SSIDUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("SSID", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.wapdman.Accesspoint", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SSIDUpdate");
    }
}

void AccesspointStub::onSSIDGet(const ::boost::shared_ptr< SSIDGet >& sSID) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SSIDGet", sSID->getAct());
    sendSSIDGetUpdate(_SSIDProperty.getSSID(), sSID->getAct());
}

void AccesspointStub::sendSSIDGetUpdate(const ::std::vector< uint8 >& sSID, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SSIDGet payload(sSID);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SSIDGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void AccesspointStub::setSSID(const ::std::vector< uint8 >& sSID) {
    if(sSID!=_SSIDProperty.getSSID()) {
        _SSIDProperty.setSSID(sSID);
        sendSSIDUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< uint8 >& AccesspointStub::getSSID() const {
    return _SSIDProperty.getSSID();
}

::std::vector< uint8 >& AccesspointStub::getSSIDMutable() {
    return _SSIDProperty.getSSIDMutable();
}

void AccesspointStub::sendInterfaceUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        InterfaceUpdate payload(_InterfaceProperty);

        LOG_INFO ("-> send%s", "InterfaceUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Interface", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.wapdman.Accesspoint", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "InterfaceUpdate");
    }
}

void AccesspointStub::onInterfaceGet(const ::boost::shared_ptr< InterfaceGet >& interface) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "InterfaceGet", interface->getAct());
    sendInterfaceGetUpdate(_InterfaceProperty.getInterface(), interface->getAct());
}

void AccesspointStub::sendInterfaceGetUpdate(const ::std::string& interface, act_t act) {
    ::asf::dbus::DBusVariant variant;
    InterfaceGet payload(interface);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "InterfaceGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void AccesspointStub::setInterface(const ::std::string& interface) {
    if(interface!=_InterfaceProperty.getInterface()) {
        _InterfaceProperty.setInterface(interface);
        sendInterfaceUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& AccesspointStub::getInterface() const {
    return _InterfaceProperty.getInterface();
}

::std::string& AccesspointStub::getInterfaceMutable() {
    return _InterfaceProperty.getInterfaceMutable();
}

void AccesspointStub::sendBlackListedStationsUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        BlackListedStationsUpdate payload(_BlackListedStationsProperty);

        LOG_INFO ("-> send%s", "BlackListedStationsUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("BlackListedStations", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.wapdman.Accesspoint", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "BlackListedStationsUpdate");
    }
}

void AccesspointStub::onBlackListedStationsGet(const ::boost::shared_ptr< BlackListedStationsGet >& blackListedStations) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "BlackListedStationsGet", blackListedStations->getAct());
    sendBlackListedStationsGetUpdate(_BlackListedStationsProperty.getBlackListedStations(), blackListedStations->getAct());
}

void AccesspointStub::sendBlackListedStationsGetUpdate(const ::std::vector< ::std::string >& blackListedStations, act_t act) {
    ::asf::dbus::DBusVariant variant;
    BlackListedStationsGet payload(blackListedStations);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "BlackListedStationsGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void AccesspointStub::setBlackListedStations(const ::std::vector< ::std::string >& blackListedStations) {
    if(blackListedStations!=_BlackListedStationsProperty.getBlackListedStations()) {
        _BlackListedStationsProperty.setBlackListedStations(blackListedStations);
        sendBlackListedStationsUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::std::string >& AccesspointStub::getBlackListedStations() const {
    return _BlackListedStationsProperty.getBlackListedStations();
}

::std::vector< ::std::string >& AccesspointStub::getBlackListedStationsMutable() {
    return _BlackListedStationsProperty.getBlackListedStationsMutable();
}

void AccesspointStub::sendPowerStateUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        PowerStateUpdate payload(_PowerStateProperty);

        LOG_INFO ("-> send%s", "PowerStateUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("PowerState", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.wapdman.Accesspoint", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "PowerStateUpdate");
    }
}

void AccesspointStub::onPowerStateGet(const ::boost::shared_ptr< PowerStateGet >& powerState) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "PowerStateGet", powerState->getAct());
    sendPowerStateGetUpdate(_PowerStateProperty.getPowerState(), powerState->getAct());
}

void AccesspointStub::sendPowerStateGetUpdate(const ::std::string& powerState, act_t act) {
    ::asf::dbus::DBusVariant variant;
    PowerStateGet payload(powerState);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "PowerStateGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void AccesspointStub::setPowerState(const ::std::string& powerState) {
    if(powerState!=_PowerStateProperty.getPowerState()) {
        _PowerStateProperty.setPowerState(powerState);
        sendPowerStateUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& AccesspointStub::getPowerState() const {
    return _PowerStateProperty.getPowerState();
}

::std::string& AccesspointStub::getPowerStateMutable() {
    return _PowerStateProperty.getPowerStateMutable();
}

void AccesspointStub::sendPowerFailureReasonUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        PowerFailureReasonUpdate payload(_PowerFailureReasonProperty);

        LOG_INFO ("-> send%s", "PowerFailureReasonUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("PowerFailureReason", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.wapdman.Accesspoint", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "PowerFailureReasonUpdate");
    }
}

void AccesspointStub::onPowerFailureReasonGet(const ::boost::shared_ptr< PowerFailureReasonGet >& powerFailureReason) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "PowerFailureReasonGet", powerFailureReason->getAct());
    sendPowerFailureReasonGetUpdate(_PowerFailureReasonProperty.getPowerFailureReason(), powerFailureReason->getAct());
}

void AccesspointStub::sendPowerFailureReasonGetUpdate(const ::std::string& powerFailureReason, act_t act) {
    ::asf::dbus::DBusVariant variant;
    PowerFailureReasonGet payload(powerFailureReason);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "PowerFailureReasonGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void AccesspointStub::setPowerFailureReason(const ::std::string& powerFailureReason) {
    if(powerFailureReason!=_PowerFailureReasonProperty.getPowerFailureReason()) {
        _PowerFailureReasonProperty.setPowerFailureReason(powerFailureReason);
        sendPowerFailureReasonUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& AccesspointStub::getPowerFailureReason() const {
    return _PowerFailureReasonProperty.getPowerFailureReason();
}

::std::string& AccesspointStub::getPowerFailureReasonMutable() {
    return _PowerFailureReasonProperty.getPowerFailureReasonMutable();
}

void AccesspointStub::sendPoweredUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        PoweredUpdate payload(_PoweredProperty);

        LOG_INFO ("-> send%s", "PoweredUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Powered", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.wapdman.Accesspoint", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "PoweredUpdate");
    }
}

void AccesspointStub::onPoweredGet(const ::boost::shared_ptr< PoweredGet >& powered) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "PoweredGet", powered->getAct());
    sendPoweredGetUpdate(_PoweredProperty.getPowered(), powered->getAct());
}

void AccesspointStub::sendPoweredGetUpdate(bool powered, act_t act) {
    ::asf::dbus::DBusVariant variant;
    PoweredGet payload(powered);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "PoweredGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void AccesspointStub::onPoweredSet(const ::boost::shared_ptr< PoweredSet >& powered) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "PoweredSet", powered->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*powered, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setPowered (powered->getPowered());
    sendPoweredSetUpdate(powered->getAct());
}

void AccesspointStub::sendPoweredSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "PoweredSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void AccesspointStub::setPowered(bool powered) {
    if(powered!=_PoweredProperty.getPowered()) {
        _PoweredProperty.setPowered(powered);
        sendPoweredUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool AccesspointStub::getPowered() const {
    return _PoweredProperty.getPowered();
}

void AccesspointStub::sendHiddenUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        HiddenUpdate payload(_HiddenProperty);

        LOG_INFO ("-> send%s", "HiddenUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Hidden", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.wapdman.Accesspoint", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "HiddenUpdate");
    }
}

void AccesspointStub::onHiddenGet(const ::boost::shared_ptr< HiddenGet >& hidden) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "HiddenGet", hidden->getAct());
    sendHiddenGetUpdate(_HiddenProperty.getHidden(), hidden->getAct());
}

void AccesspointStub::sendHiddenGetUpdate(bool hidden, act_t act) {
    ::asf::dbus::DBusVariant variant;
    HiddenGet payload(hidden);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "HiddenGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void AccesspointStub::onHiddenSet(const ::boost::shared_ptr< HiddenSet >& hidden) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "HiddenSet", hidden->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*hidden, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setHidden (hidden->getHidden());
    sendHiddenSetUpdate(hidden->getAct());
}

void AccesspointStub::sendHiddenSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "HiddenSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void AccesspointStub::setHidden(bool hidden) {
    if(hidden!=_HiddenProperty.getHidden()) {
        _HiddenProperty.setHidden(hidden);
        sendHiddenUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool AccesspointStub::getHidden() const {
    return _HiddenProperty.getHidden();
}

void AccesspointStub::sendSecurityUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SecurityUpdate payload(_SecurityProperty);

        LOG_INFO ("-> send%s", "SecurityUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Security", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.wapdman.Accesspoint", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SecurityUpdate");
    }
}

void AccesspointStub::onSecurityGet(const ::boost::shared_ptr< SecurityGet >& security) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SecurityGet", security->getAct());
    sendSecurityGetUpdate(_SecurityProperty.getSecurity(), security->getAct());
}

void AccesspointStub::sendSecurityGetUpdate(const ::std::string& security, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SecurityGet payload(security);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SecurityGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void AccesspointStub::onSecuritySet(const ::boost::shared_ptr< SecuritySet >& security) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SecuritySet", security->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*security, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setSecurity (security->getSecurity());
    sendSecuritySetUpdate(security->getAct());
}

void AccesspointStub::sendSecuritySetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SecuritySetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void AccesspointStub::setSecurity(const ::std::string& security) {
    if(security!=_SecurityProperty.getSecurity()) {
        _SecurityProperty.setSecurity(security);
        sendSecurityUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& AccesspointStub::getSecurity() const {
    return _SecurityProperty.getSecurity();
}

::std::string& AccesspointStub::getSecurityMutable() {
    return _SecurityProperty.getSecurityMutable();
}

void AccesspointStub::sendPassphraseUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        PassphraseUpdate payload(_PassphraseProperty);

        LOG_INFO ("-> send%s", "PassphraseUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Passphrase", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.wapdman.Accesspoint", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "PassphraseUpdate");
    }
}

void AccesspointStub::onPassphraseGet(const ::boost::shared_ptr< PassphraseGet >& passphrase) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "PassphraseGet", passphrase->getAct());
    sendPassphraseGetUpdate(_PassphraseProperty.getPassphrase(), passphrase->getAct());
}

void AccesspointStub::sendPassphraseGetUpdate(const ::std::string& passphrase, act_t act) {
    ::asf::dbus::DBusVariant variant;
    PassphraseGet payload(passphrase);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "PassphraseGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void AccesspointStub::onPassphraseSet(const ::boost::shared_ptr< PassphraseSet >& passphrase) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "PassphraseSet", passphrase->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*passphrase, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setPassphrase (passphrase->getPassphrase());
    sendPassphraseSetUpdate(passphrase->getAct());
}

void AccesspointStub::sendPassphraseSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "PassphraseSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void AccesspointStub::setPassphrase(const ::std::string& passphrase) {
    if(passphrase!=_PassphraseProperty.getPassphrase()) {
        _PassphraseProperty.setPassphrase(passphrase);
        sendPassphraseUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& AccesspointStub::getPassphrase() const {
    return _PassphraseProperty.getPassphrase();
}

::std::string& AccesspointStub::getPassphraseMutable() {
    return _PassphraseProperty.getPassphraseMutable();
}

void AccesspointStub::sendCurrentOperatingChannelUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        CurrentOperatingChannelUpdate payload(_CurrentOperatingChannelProperty);

        LOG_INFO ("-> send%s", "CurrentOperatingChannelUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("CurrentOperatingChannel", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.wapdman.Accesspoint", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "CurrentOperatingChannelUpdate");
    }
}

void AccesspointStub::onCurrentOperatingChannelGet(const ::boost::shared_ptr< CurrentOperatingChannelGet >& currentOperatingChannel) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "CurrentOperatingChannelGet", currentOperatingChannel->getAct());
    sendCurrentOperatingChannelGetUpdate(_CurrentOperatingChannelProperty.getCurrentOperatingChannel(), currentOperatingChannel->getAct());
}

void AccesspointStub::sendCurrentOperatingChannelGetUpdate(uint16 currentOperatingChannel, act_t act) {
    ::asf::dbus::DBusVariant variant;
    CurrentOperatingChannelGet payload(currentOperatingChannel);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "CurrentOperatingChannelGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void AccesspointStub::setCurrentOperatingChannel(uint16 currentOperatingChannel) {
    if(currentOperatingChannel!=_CurrentOperatingChannelProperty.getCurrentOperatingChannel()) {
        _CurrentOperatingChannelProperty.setCurrentOperatingChannel(currentOperatingChannel);
        sendCurrentOperatingChannelUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint16 AccesspointStub::getCurrentOperatingChannel() const {
    return _CurrentOperatingChannelProperty.getCurrentOperatingChannel();
}

void AccesspointStub::sendHWFeaturesUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        HWFeaturesUpdate payload(_HWFeaturesProperty);

        LOG_INFO ("-> send%s", "HWFeaturesUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("HWFeatures", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.wapdman.Accesspoint", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "HWFeaturesUpdate");
    }
}

void AccesspointStub::onHWFeaturesGet(const ::boost::shared_ptr< HWFeaturesGet >& hWFeatures) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "HWFeaturesGet", hWFeatures->getAct());
    sendHWFeaturesGetUpdate(_HWFeaturesProperty.getHWFeatures(), hWFeatures->getAct());
}

void AccesspointStub::sendHWFeaturesGetUpdate(const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& hWFeatures, act_t act) {
    ::asf::dbus::DBusVariant variant;
    HWFeaturesGet payload(hWFeatures);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "HWFeaturesGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void AccesspointStub::setHWFeatures(const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& hWFeatures) {
    if(hWFeatures!=_HWFeaturesProperty.getHWFeatures()) {
        _HWFeaturesProperty.setHWFeatures(hWFeatures);
        sendHWFeaturesUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& AccesspointStub::getHWFeatures() const {
    return _HWFeaturesProperty.getHWFeatures();
}

::std::map< ::std::string, ::asf::dbus::DBusVariant >& AccesspointStub::getHWFeaturesMutable() {
    return _HWFeaturesProperty.getHWFeaturesMutable();
}

void AccesspointStub::sendMaximumStationsAllowedUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        MaximumStationsAllowedUpdate payload(_MaximumStationsAllowedProperty);

        LOG_INFO ("-> send%s", "MaximumStationsAllowedUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("MaximumStationsAllowed", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.wapdman.Accesspoint", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "MaximumStationsAllowedUpdate");
    }
}

void AccesspointStub::onMaximumStationsAllowedGet(const ::boost::shared_ptr< MaximumStationsAllowedGet >& maximumStationsAllowed) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "MaximumStationsAllowedGet", maximumStationsAllowed->getAct());
    sendMaximumStationsAllowedGetUpdate(_MaximumStationsAllowedProperty.getMaximumStationsAllowed(), maximumStationsAllowed->getAct());
}

void AccesspointStub::sendMaximumStationsAllowedGetUpdate(uint16 maximumStationsAllowed, act_t act) {
    ::asf::dbus::DBusVariant variant;
    MaximumStationsAllowedGet payload(maximumStationsAllowed);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "MaximumStationsAllowedGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void AccesspointStub::onMaximumStationsAllowedSet(const ::boost::shared_ptr< MaximumStationsAllowedSet >& maximumStationsAllowed) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "MaximumStationsAllowedSet", maximumStationsAllowed->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*maximumStationsAllowed, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setMaximumStationsAllowed (maximumStationsAllowed->getMaximumStationsAllowed());
    sendMaximumStationsAllowedSetUpdate(maximumStationsAllowed->getAct());
}

void AccesspointStub::sendMaximumStationsAllowedSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "MaximumStationsAllowedSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void AccesspointStub::setMaximumStationsAllowed(uint16 maximumStationsAllowed) {
    if(maximumStationsAllowed!=_MaximumStationsAllowedProperty.getMaximumStationsAllowed()) {
        _MaximumStationsAllowedProperty.setMaximumStationsAllowed(maximumStationsAllowed);
        sendMaximumStationsAllowedUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint16 AccesspointStub::getMaximumStationsAllowed() const {
    return _MaximumStationsAllowedProperty.getMaximumStationsAllowed();
}

void AccesspointStub::sendCountryCodeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        CountryCodeUpdate payload(_CountryCodeProperty);

        LOG_INFO ("-> send%s", "CountryCodeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("CountryCode", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.wapdman.Accesspoint", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "CountryCodeUpdate");
    }
}

void AccesspointStub::onCountryCodeGet(const ::boost::shared_ptr< CountryCodeGet >& countryCode) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "CountryCodeGet", countryCode->getAct());
    sendCountryCodeGetUpdate(_CountryCodeProperty.getCountryCode(), countryCode->getAct());
}

void AccesspointStub::sendCountryCodeGetUpdate(const ::std::string& countryCode, act_t act) {
    ::asf::dbus::DBusVariant variant;
    CountryCodeGet payload(countryCode);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "CountryCodeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void AccesspointStub::onCountryCodeSet(const ::boost::shared_ptr< CountryCodeSet >& countryCode) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "CountryCodeSet", countryCode->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*countryCode, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setCountryCode (countryCode->getCountryCode());
    sendCountryCodeSetUpdate(countryCode->getAct());
}

void AccesspointStub::sendCountryCodeSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "CountryCodeSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void AccesspointStub::setCountryCode(const ::std::string& countryCode) {
    if(countryCode!=_CountryCodeProperty.getCountryCode()) {
        _CountryCodeProperty.setCountryCode(countryCode);
        sendCountryCodeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& AccesspointStub::getCountryCode() const {
    return _CountryCodeProperty.getCountryCode();
}

::std::string& AccesspointStub::getCountryCodeMutable() {
    return _CountryCodeProperty.getCountryCodeMutable();
}

void AccesspointStub::sendSupportedChannelsUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SupportedChannelsUpdate payload(_SupportedChannelsProperty);

        LOG_INFO ("-> send%s", "SupportedChannelsUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("SupportedChannels", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.wapdman.Accesspoint", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SupportedChannelsUpdate");
    }
}

void AccesspointStub::onSupportedChannelsGet(const ::boost::shared_ptr< SupportedChannelsGet >& supportedChannels) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SupportedChannelsGet", supportedChannels->getAct());
    sendSupportedChannelsGetUpdate(_SupportedChannelsProperty.getSupportedChannels(), supportedChannels->getAct());
}

void AccesspointStub::sendSupportedChannelsGetUpdate(const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& supportedChannels, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SupportedChannelsGet payload(supportedChannels);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SupportedChannelsGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void AccesspointStub::setSupportedChannels(const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& supportedChannels) {
    if(supportedChannels!=_SupportedChannelsProperty.getSupportedChannels()) {
        _SupportedChannelsProperty.setSupportedChannels(supportedChannels);
        sendSupportedChannelsUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& AccesspointStub::getSupportedChannels() const {
    return _SupportedChannelsProperty.getSupportedChannels();
}

::std::map< ::std::string, ::asf::dbus::DBusVariant >& AccesspointStub::getSupportedChannelsMutable() {
    return _SupportedChannelsProperty.getSupportedChannelsMutable();
}

void AccesspointStub::sendAccessNetworkTypeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        AccessNetworkTypeUpdate payload(_AccessNetworkTypeProperty);

        LOG_INFO ("-> send%s", "AccessNetworkTypeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("AccessNetworkType", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.wapdman.Accesspoint", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "AccessNetworkTypeUpdate");
    }
}

void AccesspointStub::onAccessNetworkTypeGet(const ::boost::shared_ptr< AccessNetworkTypeGet >& accessNetworkType) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AccessNetworkTypeGet", accessNetworkType->getAct());
    sendAccessNetworkTypeGetUpdate(_AccessNetworkTypeProperty.getAccessNetworkType(), accessNetworkType->getAct());
}

void AccesspointStub::sendAccessNetworkTypeGetUpdate(uint16 accessNetworkType, act_t act) {
    ::asf::dbus::DBusVariant variant;
    AccessNetworkTypeGet payload(accessNetworkType);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AccessNetworkTypeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void AccesspointStub::onAccessNetworkTypeSet(const ::boost::shared_ptr< AccessNetworkTypeSet >& accessNetworkType) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AccessNetworkTypeSet", accessNetworkType->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*accessNetworkType, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setAccessNetworkType (accessNetworkType->getAccessNetworkType());
    sendAccessNetworkTypeSetUpdate(accessNetworkType->getAct());
}

void AccesspointStub::sendAccessNetworkTypeSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AccessNetworkTypeSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void AccesspointStub::setAccessNetworkType(uint16 accessNetworkType) {
    if(accessNetworkType!=_AccessNetworkTypeProperty.getAccessNetworkType()) {
        _AccessNetworkTypeProperty.setAccessNetworkType(accessNetworkType);
        sendAccessNetworkTypeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint16 AccesspointStub::getAccessNetworkType() const {
    return _AccessNetworkTypeProperty.getAccessNetworkType();
}

void  AccesspointStub::sendSetSSIDResponse (act_t act) {
    SetSSIDResponse* payload = new SetSSIDResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "setSSID", SetSSIDResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetSSID", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AccesspointStub::sendSetSSIDError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetSSIDError* payload = new SetSSIDError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "setSSID", SetSSIDError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetSSID", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AccesspointStub::sendDeAuthenticateStationResponse (act_t act) {
    DeAuthenticateStationResponse* payload = new DeAuthenticateStationResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "DeAuthenticateStation", DeAuthenticateStationResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "DeAuthenticateStation", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AccesspointStub::sendDeAuthenticateStationError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    DeAuthenticateStationError* payload = new DeAuthenticateStationError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "DeAuthenticateStation", DeAuthenticateStationError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "DeAuthenticateStation", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AccesspointStub::sendBlacklistStationResponse (act_t act) {
    BlacklistStationResponse* payload = new BlacklistStationResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "BlacklistStation", BlacklistStationResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "BlacklistStation", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AccesspointStub::sendBlacklistStationError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    BlacklistStationError* payload = new BlacklistStationError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "BlacklistStation", BlacklistStationError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "BlacklistStation", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AccesspointStub::sendSetOperatingChannelsResponse (act_t act) {
    SetOperatingChannelsResponse* payload = new SetOperatingChannelsResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "SetOperatingChannels", SetOperatingChannelsResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetOperatingChannels", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AccesspointStub::sendSetOperatingChannelsError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetOperatingChannelsError* payload = new SetOperatingChannelsError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SetOperatingChannels", SetOperatingChannelsError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetOperatingChannels", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AccesspointStub::sendStartWPSPushButtonResponse (act_t act) {
    StartWPSPushButtonResponse* payload = new StartWPSPushButtonResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "StartWPSPushButton", StartWPSPushButtonResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "StartWPSPushButton", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AccesspointStub::sendStartWPSPushButtonError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    StartWPSPushButtonError* payload = new StartWPSPushButtonError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "StartWPSPushButton", StartWPSPushButtonError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "StartWPSPushButton", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AccesspointStub::sendCancelWPSResponse (act_t act) {
    CancelWPSResponse* payload = new CancelWPSResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "CancelWPS", CancelWPSResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "CancelWPS", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AccesspointStub::sendCancelWPSError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    CancelWPSError* payload = new CancelWPSError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "CancelWPS", CancelWPSError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "CancelWPS", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AccesspointStub::sendGetAssociatedStationsResponse (const ::std::vector< GetAssociatedStationsResponseAssociatedstationsStruct >& associatedstations, act_t act) {
    GetAssociatedStationsResponse* payload = new GetAssociatedStationsResponse(associatedstations);
    DBUS_MESSAGE_REPLY(dbusMessage, "GetAssociatedStations", GetAssociatedStationsResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetAssociatedStations", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AccesspointStub::sendGetAssociatedStationsError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetAssociatedStationsError* payload = new GetAssociatedStationsError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "GetAssociatedStations", GetAssociatedStationsError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetAssociatedStations", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AccesspointStub::sendRegisterVendorServiceResponse (act_t act) {
    RegisterVendorServiceResponse* payload = new RegisterVendorServiceResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "RegisterVendorService", RegisterVendorServiceResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RegisterVendorService", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AccesspointStub::sendRegisterVendorServiceError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RegisterVendorServiceError* payload = new RegisterVendorServiceError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "RegisterVendorService", RegisterVendorServiceError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RegisterVendorService", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AccesspointStub::sendUnregisterVendorServiceResponse (act_t act) {
    UnregisterVendorServiceResponse* payload = new UnregisterVendorServiceResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "UnregisterVendorService", UnregisterVendorServiceResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "UnregisterVendorService", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AccesspointStub::sendUnregisterVendorServiceError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    UnregisterVendorServiceError* payload = new UnregisterVendorServiceError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "UnregisterVendorService", UnregisterVendorServiceError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "UnregisterVendorService", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AccesspointStub::sendGetDnsDhcpConfResponse (const GetDnsDhcpConfResponseDnsdhcpserverconfStruct& dnsdhcpserverconf, act_t act) {
    GetDnsDhcpConfResponse* payload = new GetDnsDhcpConfResponse(dnsdhcpserverconf);
    DBUS_MESSAGE_REPLY(dbusMessage, "GetDnsDhcpConf", GetDnsDhcpConfResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetDnsDhcpConf", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AccesspointStub::sendGetDnsDhcpConfError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetDnsDhcpConfError* payload = new GetDnsDhcpConfError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "GetDnsDhcpConf", GetDnsDhcpConfError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetDnsDhcpConf", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AccesspointStub::sendRestoreDefaultAPSettingsResponse (act_t act) {
    RestoreDefaultAPSettingsResponse* payload = new RestoreDefaultAPSettingsResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "RestoreDefaultAPSettings", RestoreDefaultAPSettingsResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RestoreDefaultAPSettings", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AccesspointStub::sendRestoreDefaultAPSettingsError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RestoreDefaultAPSettingsError* payload = new RestoreDefaultAPSettingsError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "RestoreDefaultAPSettings", RestoreDefaultAPSettingsError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RestoreDefaultAPSettings", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void AccesspointStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'MacAddress'
    {
        ::asf::dbus::DBusVariant variant;
        MacAddressGet payload(_MacAddressProperty.getMacAddress());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("MacAddress", variant));
    }

    //property 'SSID'
    {
        ::asf::dbus::DBusVariant variant;
        SSIDGet payload(_SSIDProperty.getSSID());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("SSID", variant));
    }

    //property 'Interface'
    {
        ::asf::dbus::DBusVariant variant;
        InterfaceGet payload(_InterfaceProperty.getInterface());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Interface", variant));
    }

    //property 'BlackListedStations'
    {
        ::asf::dbus::DBusVariant variant;
        BlackListedStationsGet payload(_BlackListedStationsProperty.getBlackListedStations());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("BlackListedStations", variant));
    }

    //property 'PowerState'
    {
        ::asf::dbus::DBusVariant variant;
        PowerStateGet payload(_PowerStateProperty.getPowerState());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("PowerState", variant));
    }

    //property 'PowerFailureReason'
    {
        ::asf::dbus::DBusVariant variant;
        PowerFailureReasonGet payload(_PowerFailureReasonProperty.getPowerFailureReason());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("PowerFailureReason", variant));
    }

    //property 'Powered'
    {
        ::asf::dbus::DBusVariant variant;
        PoweredGet payload(_PoweredProperty.getPowered());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Powered", variant));
    }

    //property 'Hidden'
    {
        ::asf::dbus::DBusVariant variant;
        HiddenGet payload(_HiddenProperty.getHidden());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Hidden", variant));
    }

    //property 'Security'
    {
        ::asf::dbus::DBusVariant variant;
        SecurityGet payload(_SecurityProperty.getSecurity());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Security", variant));
    }

    //property 'Passphrase'
    {
        ::asf::dbus::DBusVariant variant;
        PassphraseGet payload(_PassphraseProperty.getPassphrase());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Passphrase", variant));
    }

    //property 'CurrentOperatingChannel'
    {
        ::asf::dbus::DBusVariant variant;
        CurrentOperatingChannelGet payload(_CurrentOperatingChannelProperty.getCurrentOperatingChannel());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("CurrentOperatingChannel", variant));
    }

    //property 'HWFeatures'
    {
        ::asf::dbus::DBusVariant variant;
        HWFeaturesGet payload(_HWFeaturesProperty.getHWFeatures());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("HWFeatures", variant));
    }

    //property 'MaximumStationsAllowed'
    {
        ::asf::dbus::DBusVariant variant;
        MaximumStationsAllowedGet payload(_MaximumStationsAllowedProperty.getMaximumStationsAllowed());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("MaximumStationsAllowed", variant));
    }

    //property 'CountryCode'
    {
        ::asf::dbus::DBusVariant variant;
        CountryCodeGet payload(_CountryCodeProperty.getCountryCode());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("CountryCode", variant));
    }

    //property 'SupportedChannels'
    {
        ::asf::dbus::DBusVariant variant;
        SupportedChannelsGet payload(_SupportedChannelsProperty.getSupportedChannels());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("SupportedChannels", variant));
    }

    //property 'AccessNetworkType'
    {
        ::asf::dbus::DBusVariant variant;
        AccessNetworkTypeGet payload(_AccessNetworkTypeProperty.getAccessNetworkType());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("AccessNetworkType", variant));
    }
}

} // namespace Accesspoint
} // namespace wapdman
} // namespace bosch
} // namespace org
