/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/dbus/DBusAssert.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DBusVariantDBus.h"
#include "org/bosch/wapdman/Accesspoint.h"
#include "org/bosch/wapdman/AccesspointDBus.h"
#include <dbus/dbus.h>
#include <map>
#include <string>
#include <vector>

static ::asf::core::Logger& _logger =  ::asf::core::Logger::_systemLogger;


// D-Bus serialize and deserialize functions of SetSSIDRequest

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::SetSSIDRequest& in, DBusMessageIter* out) {
    DBusMessageIter o0ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "y", &o0ArrayIter));
    const ::std::vector< uint8 >* o1 = &in.getSsid();
    ::std::vector< uint8 >::const_iterator o2 = o1->end();
    for (::std::vector< uint8 >::const_iterator o3 = o1->begin(); o3 != o2; ++o3) {
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0ArrayIter, DBUS_TYPE_BYTE, &(*o3)));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o0ArrayIter));
    dbus_bool_t o4 = in.getUtf_ssid() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o4));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::SetSSIDRequest& out) {
    {
        ::std::vector< uint8 > ssidValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o5ArrayIter;
            dbus_message_iter_recurse (in, &o5ArrayIter);

            if(dbus_message_iter_get_arg_type(&o5ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    uint8 o6;
                    dbus_message_iter_get_basic(&o5ArrayIter, &o6);
                    ssidValue.push_back(o6);
                } while (dbus_message_iter_next(&o5ArrayIter));
            }
        }
        out.setSsid(ssidValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        bool utf_ssidValue;
        bool &utf_ssidTmpValue = utf_ssidValue;
        {
            dbus_bool_t o7;
            dbus_message_iter_get_basic(in, &o7);
            utf_ssidTmpValue = o7 ? true : false;
        }
        out.setUtf_ssid(utf_ssidValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DeAuthenticateStationRequest

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::DeAuthenticateStationRequest& in, DBusMessageIter* out) {
    const char* o8 = in.getAddress().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o8));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::DeAuthenticateStationRequest& out) {
    {
        ::std::string addressValue;
        ::std::string &addressTmpValue = addressValue;
        {
            char* o9 = 0;
            dbus_message_iter_get_basic(in, &o9);
            addressTmpValue.assign (o9);
        }
        out.setAddress(addressValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of BlacklistStationRequest

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::BlacklistStationRequest& in, DBusMessageIter* out) {
    const char* o10 = in.getAddress().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o10));
    dbus_bool_t o11 = in.getAllow() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o11));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::BlacklistStationRequest& out) {
    {
        ::std::string addressValue;
        ::std::string &addressTmpValue = addressValue;
        {
            char* o12 = 0;
            dbus_message_iter_get_basic(in, &o12);
            addressTmpValue.assign (o12);
        }
        out.setAddress(addressValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        bool allowValue;
        bool &allowTmpValue = allowValue;
        {
            dbus_bool_t o13;
            dbus_message_iter_get_basic(in, &o13);
            allowTmpValue = o13 ? true : false;
        }
        out.setAllow(allowValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetOperatingChannelsRequest

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::SetOperatingChannelsRequest& in, DBusMessageIter* out) {
    DBusMessageIter o14ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "q", &o14ArrayIter));
    const ::std::vector< uint16 >* o15 = &in.getChannels();
    ::std::vector< uint16 >::const_iterator o16 = o15->end();
    for (::std::vector< uint16 >::const_iterator o17 = o15->begin(); o17 != o16; ++o17) {
        DBUS_ASSERT(dbus_message_iter_append_basic(&o14ArrayIter, DBUS_TYPE_UINT16, &(*o17)));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o14ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::SetOperatingChannelsRequest& out) {
    {
        ::std::vector< uint16 > channelsValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o18ArrayIter;
            dbus_message_iter_recurse (in, &o18ArrayIter);

            if(dbus_message_iter_get_arg_type(&o18ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    uint16 o19;
                    dbus_message_iter_get_basic(&o18ArrayIter, &o19);
                    channelsValue.push_back(o19);
                } while (dbus_message_iter_next(&o18ArrayIter));
            }
        }
        out.setChannels(channelsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetAssociatedStationsResponse

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::GetAssociatedStationsResponse& in, DBusMessageIter* out) {
    DBusMessageIter o20ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(oa{sv})", &o20ArrayIter));
    const ::std::vector< ::org::bosch::wapdman::Accesspoint::GetAssociatedStationsResponseAssociatedstationsStruct >* o21 = &in.getAssociatedstations();
    ::std::vector< ::org::bosch::wapdman::Accesspoint::GetAssociatedStationsResponseAssociatedstationsStruct >::const_iterator o22 = o21->end();
    for (::std::vector< ::org::bosch::wapdman::Accesspoint::GetAssociatedStationsResponseAssociatedstationsStruct >::const_iterator o23 = o21->begin(); o23 != o22; ++o23) {
        {
            DBusMessageIter o24Struct;
            DBUS_ASSERT(dbus_message_iter_open_container(&o20ArrayIter, DBUS_TYPE_STRUCT, 0, &o24Struct));
            serializeDBus((*o23), &o24Struct);
            DBUS_ASSERT(dbus_message_iter_close_container(&o20ArrayIter, &o24Struct));
        }
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o20ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::GetAssociatedStationsResponse& out) {
    {
        ::std::vector< ::org::bosch::wapdman::Accesspoint::GetAssociatedStationsResponseAssociatedstationsStruct > associatedstationsValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o25ArrayIter;
            dbus_message_iter_recurse (in, &o25ArrayIter);

            if(dbus_message_iter_get_arg_type(&o25ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::bosch::wapdman::Accesspoint::GetAssociatedStationsResponseAssociatedstationsStruct o26;
                    {
                        DBusMessageIter o27;
                        char* signature = dbus_message_iter_get_signature(&o25ArrayIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o25ArrayIter)) {
                                dbus_message_iter_recurse (&o25ArrayIter, &o27);

                                if (!deserializeDBus(&o27, o26)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    associatedstationsValue.push_back(o26);
                } while (dbus_message_iter_next(&o25ArrayIter));
            }
        }
        out.setAssociatedstations(associatedstationsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RegisterVendorServiceRequest

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::RegisterVendorServiceRequest& in, DBusMessageIter* out) {
    DBusMessageIter o28ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "ay", &o28ArrayIter));
    const ::std::vector< ::std::vector< uint8 > >* o29 = &in.getIEs();
    ::std::vector< ::std::vector< uint8 > >::const_iterator o30 = o29->end();
    for (::std::vector< ::std::vector< uint8 > >::const_iterator o31 = o29->begin(); o31 != o30; ++o31) {
        DBusMessageIter o32ArrayIter;
        DBUS_ASSERT(dbus_message_iter_open_container(&o28ArrayIter, DBUS_TYPE_ARRAY, "y", &o32ArrayIter));
        const ::std::vector< uint8 >* o33 = &(*o31);
        ::std::vector< uint8 >::const_iterator o34 = o33->end();
        for (::std::vector< uint8 >::const_iterator o35 = o33->begin(); o35 != o34; ++o35) {
            DBUS_ASSERT(dbus_message_iter_append_basic(&o32ArrayIter, DBUS_TYPE_BYTE, &(*o35)));
        }
        DBUS_ASSERT(dbus_message_iter_close_container(&o28ArrayIter, &o32ArrayIter));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o28ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::RegisterVendorServiceRequest& out) {
    {
        ::std::vector< ::std::vector< uint8 > > IEsValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o36ArrayIter;
            dbus_message_iter_recurse (in, &o36ArrayIter);

            if(dbus_message_iter_get_arg_type(&o36ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::vector< uint8 > o37;

                    if (dbus_message_iter_get_arg_type(&o36ArrayIter) != DBUS_TYPE_INVALID) {
                        DBusMessageIter o38ArrayIter;
                        dbus_message_iter_recurse (&o36ArrayIter, &o38ArrayIter);

                        if(dbus_message_iter_get_arg_type(&o38ArrayIter) != DBUS_TYPE_INVALID) {
                            do {
                                uint8 o39;
                                dbus_message_iter_get_basic(&o38ArrayIter, &o39);
                                o37.push_back(o39);
                            } while (dbus_message_iter_next(&o38ArrayIter));
                        }
                    }
                    IEsValue.push_back(o37);
                } while (dbus_message_iter_next(&o36ArrayIter));
            }
        }
        out.setIEs(IEsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of UnregisterVendorServiceRequest

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::UnregisterVendorServiceRequest& in, DBusMessageIter* out) {
    DBusMessageIter o40ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "ay", &o40ArrayIter));
    const ::std::vector< ::std::vector< uint8 > >* o41 = &in.getIEs();
    ::std::vector< ::std::vector< uint8 > >::const_iterator o42 = o41->end();
    for (::std::vector< ::std::vector< uint8 > >::const_iterator o43 = o41->begin(); o43 != o42; ++o43) {
        DBusMessageIter o44ArrayIter;
        DBUS_ASSERT(dbus_message_iter_open_container(&o40ArrayIter, DBUS_TYPE_ARRAY, "y", &o44ArrayIter));
        const ::std::vector< uint8 >* o45 = &(*o43);
        ::std::vector< uint8 >::const_iterator o46 = o45->end();
        for (::std::vector< uint8 >::const_iterator o47 = o45->begin(); o47 != o46; ++o47) {
            DBUS_ASSERT(dbus_message_iter_append_basic(&o44ArrayIter, DBUS_TYPE_BYTE, &(*o47)));
        }
        DBUS_ASSERT(dbus_message_iter_close_container(&o40ArrayIter, &o44ArrayIter));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o40ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::UnregisterVendorServiceRequest& out) {
    {
        ::std::vector< ::std::vector< uint8 > > IEsValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o48ArrayIter;
            dbus_message_iter_recurse (in, &o48ArrayIter);

            if(dbus_message_iter_get_arg_type(&o48ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::vector< uint8 > o49;

                    if (dbus_message_iter_get_arg_type(&o48ArrayIter) != DBUS_TYPE_INVALID) {
                        DBusMessageIter o50ArrayIter;
                        dbus_message_iter_recurse (&o48ArrayIter, &o50ArrayIter);

                        if(dbus_message_iter_get_arg_type(&o50ArrayIter) != DBUS_TYPE_INVALID) {
                            do {
                                uint8 o51;
                                dbus_message_iter_get_basic(&o50ArrayIter, &o51);
                                o49.push_back(o51);
                            } while (dbus_message_iter_next(&o50ArrayIter));
                        }
                    }
                    IEsValue.push_back(o49);
                } while (dbus_message_iter_next(&o48ArrayIter));
            }
        }
        out.setIEs(IEsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetDnsDhcpConfResponse

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::GetDnsDhcpConfResponse& in, DBusMessageIter* out) {
    {
        DBusMessageIter o52Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o52Struct));
        serializeDBus(in.getDnsdhcpserverconf(), &o52Struct);
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o52Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::GetDnsDhcpConfResponse& out) {
    {
        ::org::bosch::wapdman::Accesspoint::GetDnsDhcpConfResponseDnsdhcpserverconfStruct dnsdhcpserverconfValue;
        {
            DBusMessageIter o53;
            char* signature = dbus_message_iter_get_signature(in);

            if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                    dbus_message_iter_recurse (in, &o53);

                    if (!deserializeDBus(&o53, dnsdhcpserverconfValue)) {
                        dbus_free(signature);
                        return false;
                    }
                }
            }
            dbus_free(signature);
        }
        out.setDnsdhcpserverconf(dnsdhcpserverconfValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of MacAddressUpdate

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::MacAddressUpdate& in, DBusMessageIter* out) {
    const char* o54 = in.getMacAddress().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o54));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::MacAddressUpdate& out) {
    {
        ::std::string MacAddressValue;
        ::std::string &MacAddressTmpValue = MacAddressValue;
        {
            char* o55 = 0;
            dbus_message_iter_get_basic(in, &o55);
            MacAddressTmpValue.assign (o55);
        }
        out.setMacAddress(MacAddressValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of MacAddressRegister

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::MacAddressRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::wapdman::Accesspoint::MacAddressRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of SSIDUpdate

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::SSIDUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o56ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "y", &o56ArrayIter));
    const ::std::vector< uint8 >* o57 = &in.getSSID();
    ::std::vector< uint8 >::const_iterator o58 = o57->end();
    for (::std::vector< uint8 >::const_iterator o59 = o57->begin(); o59 != o58; ++o59) {
        DBUS_ASSERT(dbus_message_iter_append_basic(&o56ArrayIter, DBUS_TYPE_BYTE, &(*o59)));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o56ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::SSIDUpdate& out) {
    {
        ::std::vector< uint8 > SSIDValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o60ArrayIter;
            dbus_message_iter_recurse (in, &o60ArrayIter);

            if(dbus_message_iter_get_arg_type(&o60ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    uint8 o61;
                    dbus_message_iter_get_basic(&o60ArrayIter, &o61);
                    SSIDValue.push_back(o61);
                } while (dbus_message_iter_next(&o60ArrayIter));
            }
        }
        out.setSSID(SSIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SSIDRegister

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::SSIDRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::wapdman::Accesspoint::SSIDRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of InterfaceUpdate

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::InterfaceUpdate& in, DBusMessageIter* out) {
    const char* o62 = in.getInterface().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o62));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::InterfaceUpdate& out) {
    {
        ::std::string InterfaceValue;
        ::std::string &InterfaceTmpValue = InterfaceValue;
        {
            char* o63 = 0;
            dbus_message_iter_get_basic(in, &o63);
            InterfaceTmpValue.assign (o63);
        }
        out.setInterface(InterfaceValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of InterfaceRegister

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::InterfaceRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::wapdman::Accesspoint::InterfaceRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of BlackListedStationsUpdate

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::BlackListedStationsUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o64ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o64ArrayIter));
    const ::std::vector< ::std::string >* o65 = &in.getBlackListedStations();
    ::std::vector< ::std::string >::const_iterator o66 = o65->end();
    for (::std::vector< ::std::string >::const_iterator o67 = o65->begin(); o67 != o66; ++o67) {
        const char* o68 = (*o67).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o64ArrayIter, DBUS_TYPE_STRING, &o68));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o64ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::BlackListedStationsUpdate& out) {
    {
        ::std::vector< ::std::string > BlackListedStationsValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o69ArrayIter;
            dbus_message_iter_recurse (in, &o69ArrayIter);

            if(dbus_message_iter_get_arg_type(&o69ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o70;
                    {
                        char* o71 = 0;
                        dbus_message_iter_get_basic(&o69ArrayIter, &o71);
                        o70.assign (o71);
                    }
                    BlackListedStationsValue.push_back(o70);
                } while (dbus_message_iter_next(&o69ArrayIter));
            }
        }
        out.setBlackListedStations(BlackListedStationsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of BlackListedStationsRegister

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::BlackListedStationsRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::wapdman::Accesspoint::BlackListedStationsRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of PowerStateUpdate

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::PowerStateUpdate& in, DBusMessageIter* out) {
    const char* o72 = in.getPowerState().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o72));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::PowerStateUpdate& out) {
    {
        ::std::string PowerStateValue;
        ::std::string &PowerStateTmpValue = PowerStateValue;
        {
            char* o73 = 0;
            dbus_message_iter_get_basic(in, &o73);
            PowerStateTmpValue.assign (o73);
        }
        out.setPowerState(PowerStateValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of PowerStateRegister

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::PowerStateRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::wapdman::Accesspoint::PowerStateRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of PowerFailureReasonUpdate

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::PowerFailureReasonUpdate& in, DBusMessageIter* out) {
    const char* o74 = in.getPowerFailureReason().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o74));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::PowerFailureReasonUpdate& out) {
    {
        ::std::string PowerFailureReasonValue;
        ::std::string &PowerFailureReasonTmpValue = PowerFailureReasonValue;
        {
            char* o75 = 0;
            dbus_message_iter_get_basic(in, &o75);
            PowerFailureReasonTmpValue.assign (o75);
        }
        out.setPowerFailureReason(PowerFailureReasonValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of PowerFailureReasonRegister

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::PowerFailureReasonRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::wapdman::Accesspoint::PowerFailureReasonRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of PoweredUpdate

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::PoweredUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o76 = in.getPowered() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o76));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::PoweredUpdate& out) {
    {
        bool PoweredValue;
        bool &PoweredTmpValue = PoweredValue;
        {
            dbus_bool_t o77;
            dbus_message_iter_get_basic(in, &o77);
            PoweredTmpValue = o77 ? true : false;
        }
        out.setPowered(PoweredValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of PoweredRegister

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::PoweredRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::wapdman::Accesspoint::PoweredRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of HiddenUpdate

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::HiddenUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o78 = in.getHidden() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o78));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::HiddenUpdate& out) {
    {
        bool HiddenValue;
        bool &HiddenTmpValue = HiddenValue;
        {
            dbus_bool_t o79;
            dbus_message_iter_get_basic(in, &o79);
            HiddenTmpValue = o79 ? true : false;
        }
        out.setHidden(HiddenValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of HiddenRegister

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::HiddenRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::wapdman::Accesspoint::HiddenRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of SecurityUpdate

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::SecurityUpdate& in, DBusMessageIter* out) {
    const char* o80 = in.getSecurity().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o80));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::SecurityUpdate& out) {
    {
        ::std::string SecurityValue;
        ::std::string &SecurityTmpValue = SecurityValue;
        {
            char* o81 = 0;
            dbus_message_iter_get_basic(in, &o81);
            SecurityTmpValue.assign (o81);
        }
        out.setSecurity(SecurityValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SecurityRegister

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::SecurityRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::wapdman::Accesspoint::SecurityRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of PassphraseUpdate

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::PassphraseUpdate& in, DBusMessageIter* out) {
    const char* o82 = in.getPassphrase().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o82));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::PassphraseUpdate& out) {
    {
        ::std::string PassphraseValue;
        ::std::string &PassphraseTmpValue = PassphraseValue;
        {
            char* o83 = 0;
            dbus_message_iter_get_basic(in, &o83);
            PassphraseTmpValue.assign (o83);
        }
        out.setPassphrase(PassphraseValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of PassphraseRegister

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::PassphraseRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::wapdman::Accesspoint::PassphraseRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of CurrentOperatingChannelUpdate

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::CurrentOperatingChannelUpdate& in, DBusMessageIter* out) {
    uint16 o84 = in.getCurrentOperatingChannel();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o84));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::CurrentOperatingChannelUpdate& out) {
    {
        uint16 CurrentOperatingChannelValue;
        uint16 &CurrentOperatingChannelTmpValue = CurrentOperatingChannelValue;
        dbus_message_iter_get_basic(in, &CurrentOperatingChannelTmpValue);
        out.setCurrentOperatingChannel(CurrentOperatingChannelValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of CurrentOperatingChannelRegister

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::CurrentOperatingChannelRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::wapdman::Accesspoint::CurrentOperatingChannelRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of HWFeaturesUpdate

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::HWFeaturesUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o85ArrayIter;
    DBusMessageIter o86DictIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "{sv}", &o85ArrayIter));
    const ::std::map< ::std::string, ::asf::dbus::DBusVariant >* o87 = &in.getHWFeatures();
    ::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o88 = o87->end();
    for (::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o89 = o87->begin(); o89 != o88; ++o89) {
        DBUS_ASSERT(dbus_message_iter_open_container(&o85ArrayIter, DBUS_TYPE_DICT_ENTRY, 0, &o86DictIter));
        const char* o90 = o89->first.c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o86DictIter, DBUS_TYPE_STRING, &o90));
        serializeDBus(o89->second, &o86DictIter);
        DBUS_ASSERT(dbus_message_iter_close_container(&o85ArrayIter, &o86DictIter)); // close dict container
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o85ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::HWFeaturesUpdate& out) {
    {
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > HWFeaturesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o91ArrayIter;
            DBusMessageIter o92DictIter;
            dbus_message_iter_recurse (in, &o91ArrayIter);

            if (dbus_message_iter_get_arg_type(&o91ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o93Key;
                    ::asf::dbus::DBusVariant o93Value;
                    dbus_message_iter_recurse (&o91ArrayIter, &o92DictIter);
                    {
                        char* o94 = 0;
                        dbus_message_iter_get_basic(&o92DictIter, &o94);
                        o93Key.assign (o94);
                    }
                    dbus_message_iter_next(&o92DictIter);
                    {
                        DBusMessageIter o95;
                        char* signature = dbus_message_iter_get_signature(&o92DictIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o92DictIter)) {
                                dbus_message_iter_recurse (&o92DictIter, &o95);

                                if (!deserializeDBus(&o95, o93Value)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    HWFeaturesValue.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant >(o93Key, o93Value));
                } while (dbus_message_iter_next(&o91ArrayIter));
            }
        }
        out.setHWFeatures(HWFeaturesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of HWFeaturesRegister

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::HWFeaturesRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::wapdman::Accesspoint::HWFeaturesRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of MaximumStationsAllowedUpdate

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::MaximumStationsAllowedUpdate& in, DBusMessageIter* out) {
    uint16 o96 = in.getMaximumStationsAllowed();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o96));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::MaximumStationsAllowedUpdate& out) {
    {
        uint16 MaximumStationsAllowedValue;
        uint16 &MaximumStationsAllowedTmpValue = MaximumStationsAllowedValue;
        dbus_message_iter_get_basic(in, &MaximumStationsAllowedTmpValue);
        out.setMaximumStationsAllowed(MaximumStationsAllowedValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of MaximumStationsAllowedRegister

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::MaximumStationsAllowedRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::wapdman::Accesspoint::MaximumStationsAllowedRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of CountryCodeUpdate

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::CountryCodeUpdate& in, DBusMessageIter* out) {
    const char* o97 = in.getCountryCode().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o97));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::CountryCodeUpdate& out) {
    {
        ::std::string CountryCodeValue;
        ::std::string &CountryCodeTmpValue = CountryCodeValue;
        {
            char* o98 = 0;
            dbus_message_iter_get_basic(in, &o98);
            CountryCodeTmpValue.assign (o98);
        }
        out.setCountryCode(CountryCodeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of CountryCodeRegister

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::CountryCodeRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::wapdman::Accesspoint::CountryCodeRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of SupportedChannelsUpdate

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::SupportedChannelsUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o99ArrayIter;
    DBusMessageIter o100DictIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "{sv}", &o99ArrayIter));
    const ::std::map< ::std::string, ::asf::dbus::DBusVariant >* o101 = &in.getSupportedChannels();
    ::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o102 = o101->end();
    for (::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o103 = o101->begin(); o103 != o102; ++o103) {
        DBUS_ASSERT(dbus_message_iter_open_container(&o99ArrayIter, DBUS_TYPE_DICT_ENTRY, 0, &o100DictIter));
        const char* o104 = o103->first.c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o100DictIter, DBUS_TYPE_STRING, &o104));
        serializeDBus(o103->second, &o100DictIter);
        DBUS_ASSERT(dbus_message_iter_close_container(&o99ArrayIter, &o100DictIter)); // close dict container
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o99ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::SupportedChannelsUpdate& out) {
    {
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > SupportedChannelsValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o105ArrayIter;
            DBusMessageIter o106DictIter;
            dbus_message_iter_recurse (in, &o105ArrayIter);

            if (dbus_message_iter_get_arg_type(&o105ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o107Key;
                    ::asf::dbus::DBusVariant o107Value;
                    dbus_message_iter_recurse (&o105ArrayIter, &o106DictIter);
                    {
                        char* o108 = 0;
                        dbus_message_iter_get_basic(&o106DictIter, &o108);
                        o107Key.assign (o108);
                    }
                    dbus_message_iter_next(&o106DictIter);
                    {
                        DBusMessageIter o109;
                        char* signature = dbus_message_iter_get_signature(&o106DictIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o106DictIter)) {
                                dbus_message_iter_recurse (&o106DictIter, &o109);

                                if (!deserializeDBus(&o109, o107Value)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    SupportedChannelsValue.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant >(o107Key, o107Value));
                } while (dbus_message_iter_next(&o105ArrayIter));
            }
        }
        out.setSupportedChannels(SupportedChannelsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SupportedChannelsRegister

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::SupportedChannelsRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::wapdman::Accesspoint::SupportedChannelsRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of AccessNetworkTypeUpdate

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::AccessNetworkTypeUpdate& in, DBusMessageIter* out) {
    uint16 o110 = in.getAccessNetworkType();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o110));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::AccessNetworkTypeUpdate& out) {
    {
        uint16 AccessNetworkTypeValue;
        uint16 &AccessNetworkTypeTmpValue = AccessNetworkTypeValue;
        dbus_message_iter_get_basic(in, &AccessNetworkTypeTmpValue);
        out.setAccessNetworkType(AccessNetworkTypeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of AccessNetworkTypeRegister

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::AccessNetworkTypeRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::wapdman::Accesspoint::AccessNetworkTypeRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of AssociatedStationsChangedSignal

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::AssociatedStationsChangedSignal& in, DBusMessageIter* out) {
    DBusMessageIter o111ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(oa{sv})", &o111ArrayIter));
    const ::std::vector< ::org::bosch::wapdman::Accesspoint::AssociatedStationsChangedSignalChangedstationsStruct >* o112 = &in.getChangedstations();
    ::std::vector< ::org::bosch::wapdman::Accesspoint::AssociatedStationsChangedSignalChangedstationsStruct >::const_iterator o113 = o112->end();
    for (::std::vector< ::org::bosch::wapdman::Accesspoint::AssociatedStationsChangedSignalChangedstationsStruct >::const_iterator o114 = o112->begin(); o114 != o113; ++o114) {
        {
            DBusMessageIter o115Struct;
            DBUS_ASSERT(dbus_message_iter_open_container(&o111ArrayIter, DBUS_TYPE_STRUCT, 0, &o115Struct));
            serializeDBus((*o114), &o115Struct);
            DBUS_ASSERT(dbus_message_iter_close_container(&o111ArrayIter, &o115Struct));
        }
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o111ArrayIter));
    DBusMessageIter o116ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "o", &o116ArrayIter));
    const ::std::vector< ::std::string >* o117 = &in.getRemovedstations();
    ::std::vector< ::std::string >::const_iterator o118 = o117->end();
    for (::std::vector< ::std::string >::const_iterator o119 = o117->begin(); o119 != o118; ++o119) {
        DBUS_ASSERT(::asf::dbus::DBusUtils::isObjectPathValid(std::string((*o119))));
        DBUS_ASSERT(dbus_message_iter_append_basic(&o116ArrayIter, DBUS_TYPE_OBJECT_PATH, &(*o119)));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o116ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::AssociatedStationsChangedSignal& out) {
    {
        ::std::vector< ::org::bosch::wapdman::Accesspoint::AssociatedStationsChangedSignalChangedstationsStruct > changedstationsValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o120ArrayIter;
            dbus_message_iter_recurse (in, &o120ArrayIter);

            if(dbus_message_iter_get_arg_type(&o120ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::bosch::wapdman::Accesspoint::AssociatedStationsChangedSignalChangedstationsStruct o121;
                    {
                        DBusMessageIter o122;
                        char* signature = dbus_message_iter_get_signature(&o120ArrayIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o120ArrayIter)) {
                                dbus_message_iter_recurse (&o120ArrayIter, &o122);

                                if (!deserializeDBus(&o122, o121)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    changedstationsValue.push_back(o121);
                } while (dbus_message_iter_next(&o120ArrayIter));
            }
        }
        out.setChangedstations(changedstationsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< ::std::string > removedstationsValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o123ArrayIter;
            dbus_message_iter_recurse (in, &o123ArrayIter);

            if(dbus_message_iter_get_arg_type(&o123ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o124;
                    {
                        char* o125 = 0;
                        dbus_message_iter_get_basic(&o123ArrayIter, &o125);
                        o124.assign (o125);
                    }
                    removedstationsValue.push_back(o124);
                } while (dbus_message_iter_next(&o123ArrayIter));
            }
        }
        out.setRemovedstations(removedstationsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of AssociationRequestRejectedSignal

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::AssociationRequestRejectedSignal& in, DBusMessageIter* out) {
    DBusMessageIter o126ArrayIter;
    DBusMessageIter o127DictIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "{sv}", &o126ArrayIter));
    const ::std::map< ::std::string, ::asf::dbus::DBusVariant >* o128 = &in.getStation();
    ::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o129 = o128->end();
    for (::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o130 = o128->begin(); o130 != o129; ++o130) {
        DBUS_ASSERT(dbus_message_iter_open_container(&o126ArrayIter, DBUS_TYPE_DICT_ENTRY, 0, &o127DictIter));
        const char* o131 = o130->first.c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o127DictIter, DBUS_TYPE_STRING, &o131));
        serializeDBus(o130->second, &o127DictIter);
        DBUS_ASSERT(dbus_message_iter_close_container(&o126ArrayIter, &o127DictIter)); // close dict container
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o126ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::AssociationRequestRejectedSignal& out) {
    {
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > stationValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o132ArrayIter;
            DBusMessageIter o133DictIter;
            dbus_message_iter_recurse (in, &o132ArrayIter);

            if (dbus_message_iter_get_arg_type(&o132ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o134Key;
                    ::asf::dbus::DBusVariant o134Value;
                    dbus_message_iter_recurse (&o132ArrayIter, &o133DictIter);
                    {
                        char* o135 = 0;
                        dbus_message_iter_get_basic(&o133DictIter, &o135);
                        o134Key.assign (o135);
                    }
                    dbus_message_iter_next(&o133DictIter);
                    {
                        DBusMessageIter o136;
                        char* signature = dbus_message_iter_get_signature(&o133DictIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o133DictIter)) {
                                dbus_message_iter_recurse (&o133DictIter, &o136);

                                if (!deserializeDBus(&o136, o134Value)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    stationValue.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant >(o134Key, o134Value));
                } while (dbus_message_iter_next(&o132ArrayIter));
            }
        }
        out.setStation(stationValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetAssociatedStationsResponseAssociatedstationsStruct

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::GetAssociatedStationsResponseAssociatedstationsStruct& in, DBusMessageIter* out) {
    DBUS_ASSERT(::asf::dbus::DBusUtils::isObjectPathValid(std::string(in.getElem1())));
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_OBJECT_PATH, &in.getElem1()));
    DBusMessageIter o137ArrayIter;
    DBusMessageIter o138DictIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "{sv}", &o137ArrayIter));
    const ::std::map< ::std::string, ::asf::dbus::DBusVariant >* o139 = &in.getElem2();
    ::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o140 = o139->end();
    for (::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o141 = o139->begin(); o141 != o140; ++o141) {
        DBUS_ASSERT(dbus_message_iter_open_container(&o137ArrayIter, DBUS_TYPE_DICT_ENTRY, 0, &o138DictIter));
        const char* o142 = o141->first.c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o138DictIter, DBUS_TYPE_STRING, &o142));
        serializeDBus(o141->second, &o138DictIter);
        DBUS_ASSERT(dbus_message_iter_close_container(&o137ArrayIter, &o138DictIter)); // close dict container
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o137ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::GetAssociatedStationsResponseAssociatedstationsStruct& out) {
    {
        ::std::string elem1Value;
        ::std::string &elem1TmpValue = elem1Value;
        {
            char* o143 = 0;
            dbus_message_iter_get_basic(in, &o143);
            elem1TmpValue.assign (o143);
        }
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > elem2Value;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o144ArrayIter;
            DBusMessageIter o145DictIter;
            dbus_message_iter_recurse (in, &o144ArrayIter);

            if (dbus_message_iter_get_arg_type(&o144ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o146Key;
                    ::asf::dbus::DBusVariant o146Value;
                    dbus_message_iter_recurse (&o144ArrayIter, &o145DictIter);
                    {
                        char* o147 = 0;
                        dbus_message_iter_get_basic(&o145DictIter, &o147);
                        o146Key.assign (o147);
                    }
                    dbus_message_iter_next(&o145DictIter);
                    {
                        DBusMessageIter o148;
                        char* signature = dbus_message_iter_get_signature(&o145DictIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o145DictIter)) {
                                dbus_message_iter_recurse (&o145DictIter, &o148);

                                if (!deserializeDBus(&o148, o146Value)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    elem2Value.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant >(o146Key, o146Value));
                } while (dbus_message_iter_next(&o144ArrayIter));
            }
        }
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetDnsDhcpConfResponseDnsdhcpserverconfStruct

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::GetDnsDhcpConfResponseDnsdhcpserverconfStruct& in, DBusMessageIter* out) {
    DBUS_ASSERT(::asf::dbus::DBusUtils::isObjectPathValid(std::string(in.getElem1())));
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_OBJECT_PATH, &in.getElem1()));
    DBusMessageIter o149ArrayIter;
    DBusMessageIter o150DictIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "{sv}", &o149ArrayIter));
    const ::std::map< ::std::string, ::asf::dbus::DBusVariant >* o151 = &in.getElem2();
    ::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o152 = o151->end();
    for (::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o153 = o151->begin(); o153 != o152; ++o153) {
        DBUS_ASSERT(dbus_message_iter_open_container(&o149ArrayIter, DBUS_TYPE_DICT_ENTRY, 0, &o150DictIter));
        const char* o154 = o153->first.c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o150DictIter, DBUS_TYPE_STRING, &o154));
        serializeDBus(o153->second, &o150DictIter);
        DBUS_ASSERT(dbus_message_iter_close_container(&o149ArrayIter, &o150DictIter)); // close dict container
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o149ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::GetDnsDhcpConfResponseDnsdhcpserverconfStruct& out) {
    {
        ::std::string elem1Value;
        ::std::string &elem1TmpValue = elem1Value;
        {
            char* o155 = 0;
            dbus_message_iter_get_basic(in, &o155);
            elem1TmpValue.assign (o155);
        }
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > elem2Value;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o156ArrayIter;
            DBusMessageIter o157DictIter;
            dbus_message_iter_recurse (in, &o156ArrayIter);

            if (dbus_message_iter_get_arg_type(&o156ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o158Key;
                    ::asf::dbus::DBusVariant o158Value;
                    dbus_message_iter_recurse (&o156ArrayIter, &o157DictIter);
                    {
                        char* o159 = 0;
                        dbus_message_iter_get_basic(&o157DictIter, &o159);
                        o158Key.assign (o159);
                    }
                    dbus_message_iter_next(&o157DictIter);
                    {
                        DBusMessageIter o160;
                        char* signature = dbus_message_iter_get_signature(&o157DictIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o157DictIter)) {
                                dbus_message_iter_recurse (&o157DictIter, &o160);

                                if (!deserializeDBus(&o160, o158Value)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    elem2Value.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant >(o158Key, o158Value));
                } while (dbus_message_iter_next(&o156ArrayIter));
            }
        }
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of AssociatedStationsChangedSignalChangedstationsStruct

void serializeDBus (const ::org::bosch::wapdman::Accesspoint::AssociatedStationsChangedSignalChangedstationsStruct& in, DBusMessageIter* out) {
    DBUS_ASSERT(::asf::dbus::DBusUtils::isObjectPathValid(std::string(in.getElem1())));
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_OBJECT_PATH, &in.getElem1()));
    DBusMessageIter o161ArrayIter;
    DBusMessageIter o162DictIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "{sv}", &o161ArrayIter));
    const ::std::map< ::std::string, ::asf::dbus::DBusVariant >* o163 = &in.getElem2();
    ::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o164 = o163->end();
    for (::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o165 = o163->begin(); o165 != o164; ++o165) {
        DBUS_ASSERT(dbus_message_iter_open_container(&o161ArrayIter, DBUS_TYPE_DICT_ENTRY, 0, &o162DictIter));
        const char* o166 = o165->first.c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o162DictIter, DBUS_TYPE_STRING, &o166));
        serializeDBus(o165->second, &o162DictIter);
        DBUS_ASSERT(dbus_message_iter_close_container(&o161ArrayIter, &o162DictIter)); // close dict container
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o161ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wapdman::Accesspoint::AssociatedStationsChangedSignalChangedstationsStruct& out) {
    {
        ::std::string elem1Value;
        ::std::string &elem1TmpValue = elem1Value;
        {
            char* o167 = 0;
            dbus_message_iter_get_basic(in, &o167);
            elem1TmpValue.assign (o167);
        }
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > elem2Value;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o168ArrayIter;
            DBusMessageIter o169DictIter;
            dbus_message_iter_recurse (in, &o168ArrayIter);

            if (dbus_message_iter_get_arg_type(&o168ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o170Key;
                    ::asf::dbus::DBusVariant o170Value;
                    dbus_message_iter_recurse (&o168ArrayIter, &o169DictIter);
                    {
                        char* o171 = 0;
                        dbus_message_iter_get_basic(&o169DictIter, &o171);
                        o170Key.assign (o171);
                    }
                    dbus_message_iter_next(&o169DictIter);
                    {
                        DBusMessageIter o172;
                        char* signature = dbus_message_iter_get_signature(&o169DictIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o169DictIter)) {
                                dbus_message_iter_recurse (&o169DictIter, &o172);

                                if (!deserializeDBus(&o172, o170Value)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    elem2Value.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant >(o170Key, o170Value));
                } while (dbus_message_iter_next(&o168ArrayIter));
            }
        }
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

