/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/wapdman/Accesspoint/DHCPDNSConfiguration.h"
#include "org/bosch/wapdman/Accesspoint/DHCPDNSConfigurationDBus.h"
#include "org/bosch/wapdman/Accesspoint/DHCPDNSConfigurationJson.h"
#include "org/bosch/wapdman/Accesspoint/DHCPDNSConfigurationProxy.h"
#include <map>
#include <string>
#include <vector>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bosch {
namespace wapdman {
namespace Accesspoint {
namespace DHCPDNSConfiguration {

DEFINE_CLASS_LOGGER("//org/bosch/wapdman/accesspoint_XX_XX_XX_XX_XX_XX/org/bosch/wapdman/Accesspoint/DHCPDNSConfiguration", DHCPDNSConfigurationProxy);

class DHCPDNSConfigurationProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    DHCPDNSConfigurationProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< DHCPDNSConfigurationProxy >& proxyShared = ::boost::static_pointer_cast< DHCPDNSConfigurationProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_IPv4Pool:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), IPv4PoolError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "IPv4Pool", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<IPv4PoolError> payload = ::boost::static_pointer_cast<IPv4PoolError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((IPv4PoolCallbackIF*) _callback)->onIPv4PoolError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), IPv4PoolUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "IPv4Pool", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<IPv4PoolUpdate> payload = ::boost::static_pointer_cast<IPv4PoolUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((IPv4PoolCallbackIF*) _callback)->onIPv4PoolUpdate(proxyShared, payload);
                        proxyShared->_iPv4Pool = *payload.get();
                        return true;
                    }
                }
                break;
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_IPv4Pool: {
                ::boost::shared_ptr< IPv4PoolError > payload = ::boost::shared_ptr< IPv4PoolError >
                (new IPv4PoolError(DBUS_ERROR_NO_SERVER, "The DBus service DHCPDNSConfiguration is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "IPv4Pool", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DHCPDNSConfigurationProxy> proxyShared = ::boost::static_pointer_cast<DHCPDNSConfigurationProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((IPv4PoolCallbackIF*) _callback)->onIPv4PoolError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& DHCPDNSConfigurationProxyCallback::_logger (DHCPDNSConfigurationProxy::_logger);

DHCPDNSConfigurationProxy::DHCPDNSConfigurationProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.bosch.wapdman.Accesspoint.DHCPDNSConfiguration", serviceAvailable, _logger) {
}

DHCPDNSConfigurationProxy::~DHCPDNSConfigurationProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< DHCPDNSConfigurationProxy > DHCPDNSConfigurationProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<DHCPDNSConfigurationProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< DHCPDNSConfigurationProxy > proxyNew(new DHCPDNSConfigurationProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t DHCPDNSConfigurationProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    DHCPDNSConfigurationProxyCallback* callback = new DHCPDNSConfigurationProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t DHCPDNSConfigurationProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    DHCPDNSConfigurationProxyCallback* callback = new DHCPDNSConfigurationProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void DHCPDNSConfigurationProxy::clearAllProperties ()
{
    _iPv4Pool = ::asf::core::nullable< IPv4PoolUpdate >();
}

void DHCPDNSConfigurationProxy::sendDeregisterAll () const
{
    sendIPv4PoolDeregisterAll();
}

act_t DHCPDNSConfigurationProxy::sendIPv4PoolRegister(IPv4PoolCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_IPv4Pool, "IPv4Pool", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "IPv4Pool", &cb, act);
    return act;
}

bool DHCPDNSConfigurationProxy::sendIPv4PoolDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("IPv4Pool", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "IPv4Pool", act, static_cast<int>(rv));
    return rv;
}

act_t DHCPDNSConfigurationProxy::sendIPv4PoolGet(IPv4PoolCallbackIF& cb) {
    DHCPDNSConfigurationProxyCallback* callback = new DHCPDNSConfigurationProxyCallback(ID_IPv4Pool, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "IPv4Pool", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("IPv4Pool", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& DHCPDNSConfigurationProxy::getIPv4Pool() const {
    return _iPv4Pool.get().getIPv4Pool();
}

bool DHCPDNSConfigurationProxy::hasIPv4Pool() const {
    return _iPv4Pool.hasValue();
}

void DHCPDNSConfigurationProxy::sendIPv4PoolDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "IPv4Pool");
    _dbusProxyDelegate->deregisterSignalCallback("IPv4Pool", 0, _dbusDaemonProxy.get(), true);
}

} // namespace DHCPDNSConfiguration
} // namespace Accesspoint
} // namespace wapdman
} // namespace bosch
} // namespace org
