/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef VIDEOMANAGER_MAIN_FIPROXY_H
#define VIDEOMANAGER_MAIN_FIPROXY_H

#include "asf/cca/CcaProxy.h"
#include "asf/core/Logger.h"
#include "asf/core/nullable.h"
#include "videomanager_main_fi.h"
#include "videomanager_main_fi_typesConst.h"

namespace videomanager_main_fi {

class Videomanager_main_fiProxy;

class AcknowledgeStateAbortCallbackIF {
public:
    virtual ~AcknowledgeStateAbortCallbackIF() {}

    virtual void onAcknowledgeStateAbortResult(const ::boost::shared_ptr< Videomanager_main_fiProxy >& proxy, const ::boost::shared_ptr< AcknowledgeStateAbortResult >& result) = 0;
};

class AcknowledgeStateCallbackIF {
public:
    virtual ~AcknowledgeStateCallbackIF() {}

    virtual void onAcknowledgeStateError(const ::boost::shared_ptr< Videomanager_main_fiProxy >& proxy, const ::boost::shared_ptr< AcknowledgeStateError >& error) = 0;

    virtual void onAcknowledgeStateResult(const ::boost::shared_ptr< Videomanager_main_fiProxy >& proxy, const ::boost::shared_ptr< AcknowledgeStateResult >& result) = 0;
};

class DTVCallbackIF {
public:
    virtual ~DTVCallbackIF() {}

    virtual void onDTVError(const ::boost::shared_ptr< Videomanager_main_fiProxy >& proxy, const ::boost::shared_ptr< DTVError >& error) = 0;

    virtual void onDTVStatus(const ::boost::shared_ptr< Videomanager_main_fiProxy >& proxy, const ::boost::shared_ptr< DTVStatus >& status) = 0;
};

class DVDCallbackIF {
public:
    virtual ~DVDCallbackIF() {}

    virtual void onDVDError(const ::boost::shared_ptr< Videomanager_main_fiProxy >& proxy, const ::boost::shared_ptr< DVDError >& error) = 0;

    virtual void onDVDStatus(const ::boost::shared_ptr< Videomanager_main_fiProxy >& proxy, const ::boost::shared_ptr< DVDStatus >& status) = 0;
};

class DeserializerUsedByCallbackIF {
public:
    virtual ~DeserializerUsedByCallbackIF() {}

    virtual void onDeserializerUsedByError(const ::boost::shared_ptr< Videomanager_main_fiProxy >& proxy, const ::boost::shared_ptr< DeserializerUsedByError >& error) = 0;

    virtual void onDeserializerUsedByStatus(const ::boost::shared_ptr< Videomanager_main_fiProxy >& proxy, const ::boost::shared_ptr< DeserializerUsedByStatus >& status) = 0;
};

class RVCACallbackIF {
public:
    virtual ~RVCACallbackIF() {}

    virtual void onRVCAError(const ::boost::shared_ptr< Videomanager_main_fiProxy >& proxy, const ::boost::shared_ptr< RVCAError >& error) = 0;

    virtual void onRVCAStatus(const ::boost::shared_ptr< Videomanager_main_fiProxy >& proxy, const ::boost::shared_ptr< RVCAStatus >& status) = 0;
};

class RVCDCallbackIF {
public:
    virtual ~RVCDCallbackIF() {}

    virtual void onRVCDError(const ::boost::shared_ptr< Videomanager_main_fiProxy >& proxy, const ::boost::shared_ptr< RVCDError >& error) = 0;

    virtual void onRVCDStatus(const ::boost::shared_ptr< Videomanager_main_fiProxy >& proxy, const ::boost::shared_ptr< RVCDStatus >& status) = 0;
};

class RequestAccessToDeserializerAbortCallbackIF {
public:
    virtual ~RequestAccessToDeserializerAbortCallbackIF() {}

    virtual void onRequestAccessToDeserializerAbortResult(const ::boost::shared_ptr< Videomanager_main_fiProxy >& proxy, const ::boost::shared_ptr< RequestAccessToDeserializerAbortResult >& result) = 0;
};

class RequestAccessToDeserializerCallbackIF {
public:
    virtual ~RequestAccessToDeserializerCallbackIF() {}

    virtual void onRequestAccessToDeserializerError(const ::boost::shared_ptr< Videomanager_main_fiProxy >& proxy, const ::boost::shared_ptr< RequestAccessToDeserializerError >& error) = 0;

    virtual void onRequestAccessToDeserializerResult(const ::boost::shared_ptr< Videomanager_main_fiProxy >& proxy, const ::boost::shared_ptr< RequestAccessToDeserializerResult >& result) = 0;
};

class RequestVideoSourceStateAbortCallbackIF {
public:
    virtual ~RequestVideoSourceStateAbortCallbackIF() {}

    virtual void onRequestVideoSourceStateAbortResult(const ::boost::shared_ptr< Videomanager_main_fiProxy >& proxy, const ::boost::shared_ptr< RequestVideoSourceStateAbortResult >& result) = 0;
};

class RequestVideoSourceStateCallbackIF {
public:
    virtual ~RequestVideoSourceStateCallbackIF() {}

    virtual void onRequestVideoSourceStateError(const ::boost::shared_ptr< Videomanager_main_fiProxy >& proxy, const ::boost::shared_ptr< RequestVideoSourceStateError >& error) = 0;

    virtual void onRequestVideoSourceStateResult(const ::boost::shared_ptr< Videomanager_main_fiProxy >& proxy, const ::boost::shared_ptr< RequestVideoSourceStateResult >& result) = 0;
};

class SPCXCallbackIF {
public:
    virtual ~SPCXCallbackIF() {}

    virtual void onSPCXError(const ::boost::shared_ptr< Videomanager_main_fiProxy >& proxy, const ::boost::shared_ptr< SPCXError >& error) = 0;

    virtual void onSPCXStatus(const ::boost::shared_ptr< Videomanager_main_fiProxy >& proxy, const ::boost::shared_ptr< SPCXStatus >& status) = 0;
};

class USBCallbackIF {
public:
    virtual ~USBCallbackIF() {}

    virtual void onUSBError(const ::boost::shared_ptr< Videomanager_main_fiProxy >& proxy, const ::boost::shared_ptr< USBError >& error) = 0;

    virtual void onUSBStatus(const ::boost::shared_ptr< Videomanager_main_fiProxy >& proxy, const ::boost::shared_ptr< USBStatus >& status) = 0;
};

class Videomanager_main_fiProxyCallback;

/**
 * Videomanager_main_fiProxy is the client side representation of the CCA
 * Functional Interface 'videomanager_main_fi' (specified in file
 * videomanager_main_fi.xml).
 *
 * CCA Functional Interface 'videomanager_main_fi'
 *
 * Fullname: Video manager component functional interface
 *
 * Version: $Revision:   1.1.0   $
 *
 * Author: CM-CI1/ERN4-E Schurig
 *
 * Date: $Date: 2017-13-01   $
 *
 * Department:
 *
 * Title: Video Manager FI
 *
 * <b>Description of 'videomanager_main_fi':</b>
 *
 * This functional interface is designed for the videomanager.
 */
class Videomanager_main_fiProxy : public ::asf::cca::CcaProxy
{
public:

    /**
     * Create a new instance of Videomanager_main_fiProxy. The caller has to
     * pass the port name and the service information. It is only possible to
     * use this function if the port is defined in the CMC model as "wired at
     * runtime"-port. The application id of the CCA Server will be determined
     * with help of the CCA SrvSupplier messages. It's guranteed that the
     * corresponding CCA server will have the specified major version and at
     * least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Videomanager_main_fiProxy > createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Videomanager_main_fiProxy. The caller has to
     * pass the port name and the service information. It is only possible to
     * use this function if the port is defined in the CMC model as "wired at
     * runtime"-port. The proxy will connect to the CCA application specified
     * by appId. The CCA SrvSupplier messages will be used to determine the
     * availability of this application and the service. It's guranteed that
     * the corresponding CCA server will have the specified major version and
     * at least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Videomanager_main_fiProxy > createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Videomanager_main_fiProxy. The caller has to
     * pass the port name. The port name is defined in the "Car Multimedia
     * Component" model. With the help of the port name it is possible to
     * address the concrete proxy, which is defined in the CMC model
     * description.
     */
    static ::boost::shared_ptr< Videomanager_main_fiProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Destructor of Videomanager_main_fiProxy. The destructor will send
     * RelUpReg messages for all property notifications and call the error
     * callback of all pending method invocations.
     */
    ~Videomanager_main_fiProxy();

    // Method 'RequestVideoSourceState'

    /**
     * Call the method 'RequestVideoSourceState'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'RequestVideoSourceState'</b>:
     *
     * This method is to allow the components to request a state they want to enter with a certain video source.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param tVideoSource 0=NONE, 1=RVCA, 2=RVCD, 3=DTV, 4=SPCX, 5=DVD, 6=USB
     *
     * @param tRequestedState 0=inactive, 1=active
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRequestVideoSourceStateStart(RequestVideoSourceStateCallbackIF& cb, ::videomanager_main_fi_types::T_e8_vdmVideoSource tVideoSource, ::videomanager_main_fi_types::T_e8_vdmRequestedSourceState tRequestedState);

    /**
     * Aborts a previous call of the method 'RequestVideoSourceState'. This
     * method sends a MethodAbort message to the CCA server.
     *
     * <b>Documentation of 'RequestVideoSourceState'</b>:
     *
     * This method is to allow the components to request a state they want to enter with a certain video source.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param act The act identifies the previously method call.
     *
     *
     * @return true if a MethodAbort message sent (i.e. the method call is still without a result), otherwise false.
     */
    bool sendRequestVideoSourceStateAbort(RequestVideoSourceStateAbortCallbackIF& cb, act_t act);

    // Method 'RequestAccessToDeserializer'

    /**
     * Call the method 'RequestAccessToDeserializer'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'RequestAccessToDeserializer'</b>:
     *
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param tVideoSource 0=NONE, 1=RVCA, 2=RVCD, 3=DTV, 4=SPCX, 5=DVD, 6=USB
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRequestAccessToDeserializerStart(RequestAccessToDeserializerCallbackIF& cb, ::videomanager_main_fi_types::T_e8_vdmVideoSource tVideoSource);

    /**
     * Aborts a previous call of the method 'RequestAccessToDeserializer'.
     * This method sends a MethodAbort message to the CCA server.
     *
     * <b>Documentation of 'RequestAccessToDeserializer'</b>:
     *
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param act The act identifies the previously method call.
     *
     *
     * @return true if a MethodAbort message sent (i.e. the method call is still without a result), otherwise false.
     */
    bool sendRequestAccessToDeserializerAbort(RequestAccessToDeserializerAbortCallbackIF& cb, act_t act);

    // Method 'AcknowledgeState'

    /**
     * Call the method 'AcknowledgeState'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'AcknowledgeState'</b>:
     *
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param tVideoSource 0=NONE, 1=RVCA, 2=RVCD, 3=DTV, 4=SPCX, 5=DVD, 6=USB
     *
     * @param tVideoState 0=unknown, 1=inactive, 2=prepare, 3=active, 4=blocked, 5=restricted (audio only), 6=error
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAcknowledgeStateStart(AcknowledgeStateCallbackIF& cb, ::videomanager_main_fi_types::T_e8_vdmVideoSource tVideoSource, ::videomanager_main_fi_types::T_e8_vdmSourceState tVideoState);

    /**
     * Aborts a previous call of the method 'AcknowledgeState'. This method
     * sends a MethodAbort message to the CCA server.
     *
     * <b>Documentation of 'AcknowledgeState'</b>:
     *
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param act The act identifies the previously method call.
     *
     *
     * @return true if a MethodAbort message sent (i.e. the method call is still without a result), otherwise false.
     */
    bool sendAcknowledgeStateAbort(AcknowledgeStateAbortCallbackIF& cb, act_t act);

    // Property 'RVCA'

    /**
     * Notify on the property 'RVCA'. This method sends a UpReg message to the
     * CCA server.
     *
     * <b>Documentation of 'RVCA'</b>:
     *
     * This property represents the current state of the rear view camera (analogue).
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRVCAUpReg(RVCACallbackIF& cb);

    /**
     * Remove the notifcation on property 'RVCA'. This method sends a RelUpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'RVCA'</b>:
     *
     * This property represents the current state of the rear view camera (analogue).
     *
     * @param act The act which was previously returned by the sendRVCAUpReg()
     * method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendRVCARelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'RVCA'.
     */
    void sendRVCARelUpRegAll ();

    /**
     * Returns the current value of the property 'RVCA' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasRVCA()
     * returns true.
     *
     * @return the previously received value of the property 'RVCA'.
     */
    const RVCAStatus& getRVCA() const;

    /**
     * Determines whether a status message for the property 'RVCA' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasRVCA() const;

    /**
     * Request the value of the property 'RVCA' from the CCA server. This
     * method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'RVCA'</b>:
     *
     * This property represents the current state of the rear view camera (analogue).
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRVCAGet(RVCACallbackIF& cb);

    /**
     * Set the value of the property 'RVCA'. This method sends a Set message
     * to the CCA server.
     *
     * <b>Documentation of 'RVCA'</b>:
     *
     * This property represents the current state of the rear view camera (analogue).
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRVCASet(RVCACallbackIF& cb);

    // Property 'RVCD'

    /**
     * Notify on the property 'RVCD'. This method sends a UpReg message to the
     * CCA server.
     *
     * <b>Documentation of 'RVCD'</b>:
     *
     * This property represents the current state of the rear view camera (digital).
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRVCDUpReg(RVCDCallbackIF& cb);

    /**
     * Remove the notifcation on property 'RVCD'. This method sends a RelUpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'RVCD'</b>:
     *
     * This property represents the current state of the rear view camera (digital).
     *
     * @param act The act which was previously returned by the sendRVCDUpReg()
     * method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendRVCDRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'RVCD'.
     */
    void sendRVCDRelUpRegAll ();

    /**
     * Returns the current value of the property 'RVCD' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasRVCD()
     * returns true.
     *
     * @return the previously received value of the property 'RVCD'.
     */
    const RVCDStatus& getRVCD() const;

    /**
     * Determines whether a status message for the property 'RVCD' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasRVCD() const;

    /**
     * Request the value of the property 'RVCD' from the CCA server. This
     * method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'RVCD'</b>:
     *
     * This property represents the current state of the rear view camera (digital).
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRVCDGet(RVCDCallbackIF& cb);

    /**
     * Set the value of the property 'RVCD'. This method sends a Set message
     * to the CCA server.
     *
     * <b>Documentation of 'RVCD'</b>:
     *
     * This property represents the current state of the rear view camera (digital).
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRVCDSet(RVCDCallbackIF& cb);

    // Property 'DTV'

    /**
     * Notify on the property 'DTV'. This method sends a UpReg message to the
     * CCA server.
     *
     * <b>Documentation of 'DTV'</b>:
     *
     * This property represents the current state of DTV source.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDTVUpReg(DTVCallbackIF& cb);

    /**
     * Remove the notifcation on property 'DTV'. This method sends a RelUpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'DTV'</b>:
     *
     * This property represents the current state of DTV source.
     *
     * @param act The act which was previously returned by the sendDTVUpReg()
     * method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDTVRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DTV'.
     */
    void sendDTVRelUpRegAll ();

    /**
     * Returns the current value of the property 'DTV' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasDTV()
     * returns true.
     *
     * @return the previously received value of the property 'DTV'.
     */
    const DTVStatus& getDTV() const;

    /**
     * Determines whether a status message for the property 'DTV' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDTV() const;

    /**
     * Request the value of the property 'DTV' from the CCA server. This
     * method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'DTV'</b>:
     *
     * This property represents the current state of DTV source.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDTVGet(DTVCallbackIF& cb);

    /**
     * Set the value of the property 'DTV'. This method sends a Set message to
     * the CCA server.
     *
     * <b>Documentation of 'DTV'</b>:
     *
     * This property represents the current state of DTV source.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDTVSet(DTVCallbackIF& cb);

    // Property 'SPCX'

    /**
     * Notify on the property 'SPCX'. This method sends a UpReg message to the
     * CCA server.
     *
     * <b>Documentation of 'SPCX'</b>:
     *
     * This property represents the current state of the smart phone video.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSPCXUpReg(SPCXCallbackIF& cb);

    /**
     * Remove the notifcation on property 'SPCX'. This method sends a RelUpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'SPCX'</b>:
     *
     * This property represents the current state of the smart phone video.
     *
     * @param act The act which was previously returned by the sendSPCXUpReg()
     * method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendSPCXRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'SPCX'.
     */
    void sendSPCXRelUpRegAll ();

    /**
     * Returns the current value of the property 'SPCX' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasSPCX()
     * returns true.
     *
     * @return the previously received value of the property 'SPCX'.
     */
    const SPCXStatus& getSPCX() const;

    /**
     * Determines whether a status message for the property 'SPCX' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSPCX() const;

    /**
     * Request the value of the property 'SPCX' from the CCA server. This
     * method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'SPCX'</b>:
     *
     * This property represents the current state of the smart phone video.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSPCXGet(SPCXCallbackIF& cb);

    /**
     * Set the value of the property 'SPCX'. This method sends a Set message
     * to the CCA server.
     *
     * <b>Documentation of 'SPCX'</b>:
     *
     * This property represents the current state of the smart phone video.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSPCXSet(SPCXCallbackIF& cb);

    // Property 'DVD'

    /**
     * Notify on the property 'DVD'. This method sends a UpReg message to the
     * CCA server.
     *
     * <b>Documentation of 'DVD'</b>:
     *
     * This property represents the current state of the DVD device.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDVDUpReg(DVDCallbackIF& cb);

    /**
     * Remove the notifcation on property 'DVD'. This method sends a RelUpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'DVD'</b>:
     *
     * This property represents the current state of the DVD device.
     *
     * @param act The act which was previously returned by the sendDVDUpReg()
     * method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDVDRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DVD'.
     */
    void sendDVDRelUpRegAll ();

    /**
     * Returns the current value of the property 'DVD' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasDVD()
     * returns true.
     *
     * @return the previously received value of the property 'DVD'.
     */
    const DVDStatus& getDVD() const;

    /**
     * Determines whether a status message for the property 'DVD' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDVD() const;

    /**
     * Request the value of the property 'DVD' from the CCA server. This
     * method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'DVD'</b>:
     *
     * This property represents the current state of the DVD device.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDVDGet(DVDCallbackIF& cb);

    /**
     * Set the value of the property 'DVD'. This method sends a Set message to
     * the CCA server.
     *
     * <b>Documentation of 'DVD'</b>:
     *
     * This property represents the current state of the DVD device.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDVDSet(DVDCallbackIF& cb);

    // Property 'USB'

    /**
     * Notify on the property 'USB'. This method sends a UpReg message to the
     * CCA server.
     *
     * <b>Documentation of 'USB'</b>:
     *
     * This property represents the current state of the USB video.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUSBUpReg(USBCallbackIF& cb);

    /**
     * Remove the notifcation on property 'USB'. This method sends a RelUpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'USB'</b>:
     *
     * This property represents the current state of the USB video.
     *
     * @param act The act which was previously returned by the sendUSBUpReg()
     * method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendUSBRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'USB'.
     */
    void sendUSBRelUpRegAll ();

    /**
     * Returns the current value of the property 'USB' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasUSB()
     * returns true.
     *
     * @return the previously received value of the property 'USB'.
     */
    const USBStatus& getUSB() const;

    /**
     * Determines whether a status message for the property 'USB' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasUSB() const;

    /**
     * Request the value of the property 'USB' from the CCA server. This
     * method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'USB'</b>:
     *
     * This property represents the current state of the USB video.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUSBGet(USBCallbackIF& cb);

    /**
     * Set the value of the property 'USB'. This method sends a Set message to
     * the CCA server.
     *
     * <b>Documentation of 'USB'</b>:
     *
     * This property represents the current state of the USB video.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUSBSet(USBCallbackIF& cb);

    // Property 'DeserializerUsedBy'

    /**
     * Notify on the property 'DeserializerUsedBy'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'DeserializerUsedBy'</b>:
     *
     * This property represents the current source who is using the deserializer.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDeserializerUsedByUpReg(DeserializerUsedByCallbackIF& cb);

    /**
     * Remove the notifcation on property 'DeserializerUsedBy'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DeserializerUsedBy'</b>:
     *
     * This property represents the current source who is using the deserializer.
     *
     * @param act The act which was previously returned by the
     * sendDeserializerUsedByUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDeserializerUsedByRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DeserializerUsedBy'.
     */
    void sendDeserializerUsedByRelUpRegAll ();

    /**
     * Returns the current value of the property 'DeserializerUsedBy' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasDeserializerUsedBy() returns true.
     *
     * @return the previously received value of the property 'DeserializerUsedBy'.
     */
    const DeserializerUsedByStatus& getDeserializerUsedBy() const;

    /**
     * Determines whether a status message for the property 'DeserializerUsedBy' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDeserializerUsedBy() const;

    /**
     * Request the value of the property 'DeserializerUsedBy' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'DeserializerUsedBy'</b>:
     *
     * This property represents the current source who is using the deserializer.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDeserializerUsedByGet(DeserializerUsedByCallbackIF& cb);

    /**
     * Set the value of the property 'DeserializerUsedBy'. This method sends a
     * Set message to the CCA server.
     *
     * <b>Documentation of 'DeserializerUsedBy'</b>:
     *
     * This property represents the current source who is using the deserializer.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDeserializerUsedBySet(DeserializerUsedByCallbackIF& cb);

    /**
     * Release all property notifications (on all properties).
     */
    void sendRelUpRegAll ();

private:

    Videomanager_main_fiProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags);

    virtual void clearAllProperties ();

    ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > createCallback (uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb);

    // Property 'RVCA'

    ::asf::core::nullable< RVCAStatus > _rVCA;

    // Property 'RVCD'

    ::asf::core::nullable< RVCDStatus > _rVCD;

    // Property 'DTV'

    ::asf::core::nullable< DTVStatus > _dTV;

    // Property 'SPCX'

    ::asf::core::nullable< SPCXStatus > _sPCX;

    // Property 'DVD'

    ::asf::core::nullable< DVDStatus > _dVD;

    // Property 'USB'

    ::asf::core::nullable< USBStatus > _uSB;

    // Property 'DeserializerUsedBy'

    ::asf::core::nullable< DeserializerUsedByStatus > _deserializerUsedBy;

    DECLARE_CLASS_LOGGER();

    friend class Videomanager_main_fiProxyCallback;
};

} // namespace videomanager_main_fi

#endif // VIDEOMANAGER_MAIN_FIPROXY_H
