/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/cca/DefaultTypesCca.h"
#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/stream/MemoryStream.h"
#include "asf/threading/Guard.h"
#include "videomanager_main_fiCca.h"
#include "videomanager_main_fiJson.h"
#include "videomanager_main_fiProxy.h"
#include "videomanager_main_fi_typesConst.h"

#include "asf/cca/CcaMessage.h"
#include "asf/cca/CcaProxyDelegate.h"
#include "asf/cca/CcaProxyRegistry.h"

namespace videomanager_main_fi {

/*static*/ ::asf::core::Logger Videomanager_main_fiProxy::_logger ("/videomanager_main_fi/Videomanager_main_fiProxy");


class Videomanager_main_fiProxyCallback : public ::asf::cca::CcaProxyCallback {
public:

    Videomanager_main_fiProxyCallback(uint16 functionId, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, void* callback) :
        ::asf::cca::CcaProxyCallback (functionId, opCode, (reinterpret_cast<act_t>(this)), callback)
    {}

    bool processMessage (::asf::cca::CcaMessage &message) {
        if (message.getHeader().getExtension().getField() == ::asf::cca::CcaTypes::CcaMessageExtension::E_SERVICE_DATA) {
            if (message.getHeader().getExtension().getServiceData().getFunctionId() == _functionId) {
                ::boost::shared_ptr<Videomanager_main_fiProxy> proxy = ::boost::static_pointer_cast<Videomanager_main_fiProxy>(message.getProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                switch (_functionId) {
                    case FID_RequestVideoSourceState: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::videomanager_main_fi::RequestVideoSourceStateResult);
                                setActAndLogResult(message, "RequestVideoSourceState", reinterpret_cast<act_t>(this), _logger);
                                ((RequestVideoSourceStateCallbackIF*) _callback)->onRequestVideoSourceStateResult (proxy, ::boost::static_pointer_cast<RequestVideoSourceStateResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__AbortResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::videomanager_main_fi::RequestVideoSourceStateAbortResult);
                                setActAndLogAbortResult(message, "RequestVideoSourceState", reinterpret_cast<act_t>(this), _logger);
                                ((RequestVideoSourceStateAbortCallbackIF*) _secondaryCallback)->onRequestVideoSourceStateAbortResult (proxy, ::boost::static_pointer_cast<RequestVideoSourceStateAbortResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::videomanager_main_fi::RequestVideoSourceStateError);
                                setActAndLogError(message, "RequestVideoSourceState", reinterpret_cast<act_t>(this), _logger);
                                ((RequestVideoSourceStateCallbackIF*) _callback)->onRequestVideoSourceStateError (proxy, ::boost::static_pointer_cast<RequestVideoSourceStateError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_RequestAccessToDeserializer: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::videomanager_main_fi::RequestAccessToDeserializerResult);
                                setActAndLogResult(message, "RequestAccessToDeserializer", reinterpret_cast<act_t>(this), _logger);
                                ((RequestAccessToDeserializerCallbackIF*) _callback)->onRequestAccessToDeserializerResult (proxy, ::boost::static_pointer_cast<RequestAccessToDeserializerResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__AbortResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::videomanager_main_fi::RequestAccessToDeserializerAbortResult);
                                setActAndLogAbortResult(message, "RequestAccessToDeserializer", reinterpret_cast<act_t>(this), _logger);
                                ((RequestAccessToDeserializerAbortCallbackIF*) _secondaryCallback)->onRequestAccessToDeserializerAbortResult (proxy, ::boost::static_pointer_cast<RequestAccessToDeserializerAbortResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::videomanager_main_fi::RequestAccessToDeserializerError);
                                setActAndLogError(message, "RequestAccessToDeserializer", reinterpret_cast<act_t>(this), _logger);
                                ((RequestAccessToDeserializerCallbackIF*) _callback)->onRequestAccessToDeserializerError (proxy, ::boost::static_pointer_cast<RequestAccessToDeserializerError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AcknowledgeState: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::videomanager_main_fi::AcknowledgeStateResult);
                                setActAndLogResult(message, "AcknowledgeState", reinterpret_cast<act_t>(this), _logger);
                                ((AcknowledgeStateCallbackIF*) _callback)->onAcknowledgeStateResult (proxy, ::boost::static_pointer_cast<AcknowledgeStateResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__AbortResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::videomanager_main_fi::AcknowledgeStateAbortResult);
                                setActAndLogAbortResult(message, "AcknowledgeState", reinterpret_cast<act_t>(this), _logger);
                                ((AcknowledgeStateAbortCallbackIF*) _secondaryCallback)->onAcknowledgeStateAbortResult (proxy, ::boost::static_pointer_cast<AcknowledgeStateAbortResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::videomanager_main_fi::AcknowledgeStateError);
                                setActAndLogError(message, "AcknowledgeState", reinterpret_cast<act_t>(this), _logger);
                                ((AcknowledgeStateCallbackIF*) _callback)->onAcknowledgeStateError (proxy, ::boost::static_pointer_cast<AcknowledgeStateError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_RVCA: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::videomanager_main_fi::RVCAStatus);
                                setActAndLogStatus(message, "RVCA", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<RVCAStatus> payload = ::boost::static_pointer_cast<RVCAStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< RVCAStatus >& refNullableStatus = proxy->_rVCA;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((RVCACallbackIF*) _callback)->onRVCAStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((RVCACallbackIF*) _callback)->onRVCAStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::videomanager_main_fi::RVCAError);
                                setActAndLogError(message, "RVCA", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((RVCACallbackIF*) _callback)->onRVCAError(proxy, ::boost::static_pointer_cast<RVCAError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_RVCD: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::videomanager_main_fi::RVCDStatus);
                                setActAndLogStatus(message, "RVCD", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<RVCDStatus> payload = ::boost::static_pointer_cast<RVCDStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< RVCDStatus >& refNullableStatus = proxy->_rVCD;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((RVCDCallbackIF*) _callback)->onRVCDStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((RVCDCallbackIF*) _callback)->onRVCDStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::videomanager_main_fi::RVCDError);
                                setActAndLogError(message, "RVCD", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((RVCDCallbackIF*) _callback)->onRVCDError(proxy, ::boost::static_pointer_cast<RVCDError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DTV: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::videomanager_main_fi::DTVStatus);
                                setActAndLogStatus(message, "DTV", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<DTVStatus> payload = ::boost::static_pointer_cast<DTVStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< DTVStatus >& refNullableStatus = proxy->_dTV;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((DTVCallbackIF*) _callback)->onDTVStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((DTVCallbackIF*) _callback)->onDTVStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::videomanager_main_fi::DTVError);
                                setActAndLogError(message, "DTV", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((DTVCallbackIF*) _callback)->onDTVError(proxy, ::boost::static_pointer_cast<DTVError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SPCX: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::videomanager_main_fi::SPCXStatus);
                                setActAndLogStatus(message, "SPCX", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<SPCXStatus> payload = ::boost::static_pointer_cast<SPCXStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< SPCXStatus >& refNullableStatus = proxy->_sPCX;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((SPCXCallbackIF*) _callback)->onSPCXStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((SPCXCallbackIF*) _callback)->onSPCXStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::videomanager_main_fi::SPCXError);
                                setActAndLogError(message, "SPCX", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((SPCXCallbackIF*) _callback)->onSPCXError(proxy, ::boost::static_pointer_cast<SPCXError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DVD: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::videomanager_main_fi::DVDStatus);
                                setActAndLogStatus(message, "DVD", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<DVDStatus> payload = ::boost::static_pointer_cast<DVDStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< DVDStatus >& refNullableStatus = proxy->_dVD;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((DVDCallbackIF*) _callback)->onDVDStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((DVDCallbackIF*) _callback)->onDVDStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::videomanager_main_fi::DVDError);
                                setActAndLogError(message, "DVD", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((DVDCallbackIF*) _callback)->onDVDError(proxy, ::boost::static_pointer_cast<DVDError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_USB: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::videomanager_main_fi::USBStatus);
                                setActAndLogStatus(message, "USB", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<USBStatus> payload = ::boost::static_pointer_cast<USBStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< USBStatus >& refNullableStatus = proxy->_uSB;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((USBCallbackIF*) _callback)->onUSBStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((USBCallbackIF*) _callback)->onUSBStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::videomanager_main_fi::USBError);
                                setActAndLogError(message, "USB", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((USBCallbackIF*) _callback)->onUSBError(proxy, ::boost::static_pointer_cast<USBError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DeserializerUsedBy: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::videomanager_main_fi::DeserializerUsedByStatus);
                                setActAndLogStatus(message, "DeserializerUsedBy", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<DeserializerUsedByStatus> payload = ::boost::static_pointer_cast<DeserializerUsedByStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< DeserializerUsedByStatus >& refNullableStatus = proxy->_deserializerUsedBy;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((DeserializerUsedByCallbackIF*) _callback)->onDeserializerUsedByStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((DeserializerUsedByCallbackIF*) _callback)->onDeserializerUsedByStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::videomanager_main_fi::DeserializerUsedByError);
                                setActAndLogError(message, "DeserializerUsedBy", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((DeserializerUsedByCallbackIF*) _callback)->onDeserializerUsedByError(proxy, ::boost::static_pointer_cast<DeserializerUsedByError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    default:
                        break;
                }
            }
            LOG_FATAL ("Can't process service data message, commandCounter %u belongs to functionId %u, but message has functionId %u (opcode '%s')",
                message.getHeader().getExtension().getServiceData().getCommandCounter(),
                _functionId,
                message.getHeader().getExtension().getServiceData().getFunctionId(),
                ServiceData_OpCode_Name(message.getHeader().getExtension().getServiceData().getOpCode()));
            return false;
        }
        LOG_FATAL("Can't process message of type: %d", message.getHeader().getExtension().getField());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy>& baseProxy) {
        ::boost::shared_ptr<Videomanager_main_fiProxy> proxy = ::boost::static_pointer_cast<Videomanager_main_fiProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case FID_RequestVideoSourceState: {
                ::boost::shared_ptr< RequestVideoSourceStateError > payload (new RequestVideoSourceStateError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RequestVideoSourceState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((RequestVideoSourceStateCallbackIF*) _callback)->onRequestVideoSourceStateError (proxy, payload);
                return true;
            }
            case FID_RequestAccessToDeserializer: {
                ::boost::shared_ptr< RequestAccessToDeserializerError > payload (new RequestAccessToDeserializerError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RequestAccessToDeserializer", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((RequestAccessToDeserializerCallbackIF*) _callback)->onRequestAccessToDeserializerError (proxy, payload);
                return true;
            }
            case FID_AcknowledgeState: {
                ::boost::shared_ptr< AcknowledgeStateError > payload (new AcknowledgeStateError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AcknowledgeState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((AcknowledgeStateCallbackIF*) _callback)->onAcknowledgeStateError (proxy, payload);
                return true;
            }
            case FID_RVCA: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< RVCAError > payload (new RVCAError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RVCA", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((RVCACallbackIF*) _callback)->onRVCAError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_RVCD: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< RVCDError > payload (new RVCDError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RVCD", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((RVCDCallbackIF*) _callback)->onRVCDError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_DTV: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< DTVError > payload (new DTVError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DTV", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((DTVCallbackIF*) _callback)->onDTVError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_SPCX: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< SPCXError > payload (new SPCXError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SPCX", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((SPCXCallbackIF*) _callback)->onSPCXError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_DVD: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< DVDError > payload (new DVDError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DVD", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((DVDCallbackIF*) _callback)->onDVDError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_USB: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< USBError > payload (new USBError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "USB", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((USBCallbackIF*) _callback)->onUSBError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_DeserializerUsedBy: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< DeserializerUsedByError > payload (new DeserializerUsedByError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DeserializerUsedBy", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((DeserializerUsedByCallbackIF*) _callback)->onDeserializerUsedByError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& Videomanager_main_fiProxyCallback::_logger (Videomanager_main_fiProxy::_logger);

/*static*/ ::boost::shared_ptr< Videomanager_main_fiProxy > Videomanager_main_fiProxy::createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< Videomanager_main_fiProxy >  proxyNew(new Videomanager_main_fiProxy(portName, 0, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, 0, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< Videomanager_main_fiProxy > Videomanager_main_fiProxy::createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< Videomanager_main_fiProxy >  proxyNew(new Videomanager_main_fiProxy(portName, appId, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, appId, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< Videomanager_main_fiProxy > Videomanager_main_fiProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::boost::shared_ptr< Proxy > proxyReuse = ::asf::cca::CcaProxyRegistry::getInstance().getProxy(portName, serviceAvailable);
        if(proxyReuse) {
            LOG_INFO_STATIC ("createProxy, reuse existing proxy");
            return ::boost::static_pointer_cast<Videomanager_main_fiProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        }
        // create new proxy object
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< Videomanager_main_fiProxy >  proxyNew(new Videomanager_main_fiProxy(portName, 0, 0, 0, serviceAvailable, 0));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew);
        return proxyNew;
    }

Videomanager_main_fiProxy::Videomanager_main_fiProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) :
    ::asf::cca::CcaProxy(portName, appId, SERVICE_ID, majorVersion, minorVersion, serviceAvailable, _logger, flags) {
}

Videomanager_main_fiProxy::~Videomanager_main_fiProxy()
{
    LOG_INFO ("Entering ~Videomanager_main_fiProxy");
    sendRelUpRegAll ();
}

act_t Videomanager_main_fiProxy::sendRequestVideoSourceStateStart(RequestVideoSourceStateCallbackIF& cb, ::videomanager_main_fi_types::T_e8_vdmVideoSource tVideoSource, ::videomanager_main_fi_types::T_e8_vdmRequestedSourceState tRequestedState) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_RequestVideoSourceState);
        ::boost::shared_ptr< RequestVideoSourceStateStart > payload (new RequestVideoSourceStateStart());
        payload->setTVideoSource(tVideoSource);
        payload->setTRequestedState(tRequestedState);
        CCA_MESSAGE(ccaMessage,header,RequestVideoSourceStateStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "RequestVideoSourceState", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RequestVideoSourceState);
        ::boost::shared_ptr< RequestVideoSourceStateError > payload (new RequestVideoSourceStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RequestVideoSourceStateError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "RequestVideoSourceState", &cb);
    }
}

bool Videomanager_main_fiProxy::sendRequestVideoSourceStateAbort(RequestVideoSourceStateAbortCallbackIF& cb, act_t act) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (!_ccaProxyDelegate->errorHandlingOfMethodAbort(FID_RequestVideoSourceState, "RequestVideoSourceState", act)) {
        ::asf::cca::CcaProxyCallback* callback = _ccaProxyDelegate->getPendingCallback (act, FID_RequestVideoSourceState, ::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart);
        ::asf::cca::CcaTypes::CcaMessageHeader *header = new ::asf::cca::CcaTypes::CcaMessageHeader();
        CHECK_ALLOCATION(header);
        _ccaProxyDelegate->setupCcaServiceDataMessage (*header, ::asf::cca::CcaTypes::ServiceData::OpCode__MethodAbort, FID_RequestVideoSourceState, _ccaProxyDelegate->getPendingCommandCounter (act, FID_RequestVideoSourceState, ::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart));
        ::boost::shared_ptr< RequestVideoSourceStateAbort > payload (new RequestVideoSourceStateAbort());
        CCA_MESSAGE(ccaMessage,header,RequestVideoSourceStateAbort,payload)
        callback->setSecondaryCallback (&cb);
        return _ccaProxyDelegate->sendMethodAbortMessage (ccaMessage, "RequestVideoSourceState", &cb, act);
    } else {
        return false;
    }
}

act_t Videomanager_main_fiProxy::sendRequestAccessToDeserializerStart(RequestAccessToDeserializerCallbackIF& cb, ::videomanager_main_fi_types::T_e8_vdmVideoSource tVideoSource) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_RequestAccessToDeserializer);
        ::boost::shared_ptr< RequestAccessToDeserializerStart > payload (new RequestAccessToDeserializerStart());
        payload->setTVideoSource(tVideoSource);
        CCA_MESSAGE(ccaMessage,header,RequestAccessToDeserializerStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "RequestAccessToDeserializer", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RequestAccessToDeserializer);
        ::boost::shared_ptr< RequestAccessToDeserializerError > payload (new RequestAccessToDeserializerError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RequestAccessToDeserializerError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "RequestAccessToDeserializer", &cb);
    }
}

bool Videomanager_main_fiProxy::sendRequestAccessToDeserializerAbort(RequestAccessToDeserializerAbortCallbackIF& cb, act_t act) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (!_ccaProxyDelegate->errorHandlingOfMethodAbort(FID_RequestAccessToDeserializer, "RequestAccessToDeserializer", act)) {
        ::asf::cca::CcaProxyCallback* callback = _ccaProxyDelegate->getPendingCallback (act, FID_RequestAccessToDeserializer, ::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart);
        ::asf::cca::CcaTypes::CcaMessageHeader *header = new ::asf::cca::CcaTypes::CcaMessageHeader();
        CHECK_ALLOCATION(header);
        _ccaProxyDelegate->setupCcaServiceDataMessage (*header, ::asf::cca::CcaTypes::ServiceData::OpCode__MethodAbort, FID_RequestAccessToDeserializer, _ccaProxyDelegate->getPendingCommandCounter (act, FID_RequestAccessToDeserializer, ::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart));
        ::boost::shared_ptr< RequestAccessToDeserializerAbort > payload (new RequestAccessToDeserializerAbort());
        CCA_MESSAGE(ccaMessage,header,RequestAccessToDeserializerAbort,payload)
        callback->setSecondaryCallback (&cb);
        return _ccaProxyDelegate->sendMethodAbortMessage (ccaMessage, "RequestAccessToDeserializer", &cb, act);
    } else {
        return false;
    }
}

act_t Videomanager_main_fiProxy::sendAcknowledgeStateStart(AcknowledgeStateCallbackIF& cb, ::videomanager_main_fi_types::T_e8_vdmVideoSource tVideoSource, ::videomanager_main_fi_types::T_e8_vdmSourceState tVideoState) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_AcknowledgeState);
        ::boost::shared_ptr< AcknowledgeStateStart > payload (new AcknowledgeStateStart());
        payload->setTVideoSource(tVideoSource);
        payload->setTVideoState(tVideoState);
        CCA_MESSAGE(ccaMessage,header,AcknowledgeStateStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "AcknowledgeState", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AcknowledgeState);
        ::boost::shared_ptr< AcknowledgeStateError > payload (new AcknowledgeStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AcknowledgeStateError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "AcknowledgeState", &cb);
    }
}

bool Videomanager_main_fiProxy::sendAcknowledgeStateAbort(AcknowledgeStateAbortCallbackIF& cb, act_t act) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (!_ccaProxyDelegate->errorHandlingOfMethodAbort(FID_AcknowledgeState, "AcknowledgeState", act)) {
        ::asf::cca::CcaProxyCallback* callback = _ccaProxyDelegate->getPendingCallback (act, FID_AcknowledgeState, ::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart);
        ::asf::cca::CcaTypes::CcaMessageHeader *header = new ::asf::cca::CcaTypes::CcaMessageHeader();
        CHECK_ALLOCATION(header);
        _ccaProxyDelegate->setupCcaServiceDataMessage (*header, ::asf::cca::CcaTypes::ServiceData::OpCode__MethodAbort, FID_AcknowledgeState, _ccaProxyDelegate->getPendingCommandCounter (act, FID_AcknowledgeState, ::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart));
        ::boost::shared_ptr< AcknowledgeStateAbort > payload (new AcknowledgeStateAbort());
        CCA_MESSAGE(ccaMessage,header,AcknowledgeStateAbort,payload)
        callback->setSecondaryCallback (&cb);
        return _ccaProxyDelegate->sendMethodAbortMessage (ccaMessage, "AcknowledgeState", &cb, act);
    } else {
        return false;
    }
}

act_t Videomanager_main_fiProxy::sendRVCAUpReg(RVCACallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_RVCA);
        ::boost::shared_ptr< RVCAUpReg > payload (new RVCAUpReg());
        CCA_MESSAGE(ccaMessage,header,RVCAUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< RVCARelUpReg > payloadRelUpRegHeap (new RVCARelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_RVCA, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::videomanager_main_fi::RVCARelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_RVCA, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "RVCA", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "RVCA", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasRVCA()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_RVCA, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< RVCAStatus > payloadLoopback (new RVCAStatus(getRVCA()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,RVCAStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RVCA);
        ::boost::shared_ptr< RVCAError > payload (new RVCAError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RVCAError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "RVCA", &cb);
    }
}

bool Videomanager_main_fiProxy::sendRVCARelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_RVCA,"RVCA");
}

void Videomanager_main_fiProxy::sendRVCARelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_RVCA);
}

const RVCAStatus& Videomanager_main_fiProxy::getRVCA() const {
    return _rVCA.get();
}

bool Videomanager_main_fiProxy::hasRVCA() const {
    return _rVCA.hasValue();
}

act_t Videomanager_main_fiProxy::sendRVCAGet(RVCACallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_RVCA);
        ::boost::shared_ptr< RVCAGet > payload (new RVCAGet());
        CCA_MESSAGE(ccaMessage,header,RVCAGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "RVCA", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RVCA);
        ::boost::shared_ptr< RVCAError > payload (new RVCAError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RVCAError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "RVCA", &cb);
    }
}

act_t Videomanager_main_fiProxy::sendRVCASet(RVCACallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_RVCA);
        ::boost::shared_ptr< RVCASet > payload (new RVCASet());
        CCA_MESSAGE(ccaMessage,header,RVCASet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "RVCA", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RVCA);
        ::boost::shared_ptr< RVCAError > payload (new RVCAError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RVCAError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "RVCA", &cb);
    }
}

act_t Videomanager_main_fiProxy::sendRVCDUpReg(RVCDCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_RVCD);
        ::boost::shared_ptr< RVCDUpReg > payload (new RVCDUpReg());
        CCA_MESSAGE(ccaMessage,header,RVCDUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< RVCDRelUpReg > payloadRelUpRegHeap (new RVCDRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_RVCD, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::videomanager_main_fi::RVCDRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_RVCD, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "RVCD", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "RVCD", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasRVCD()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_RVCD, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< RVCDStatus > payloadLoopback (new RVCDStatus(getRVCD()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,RVCDStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RVCD);
        ::boost::shared_ptr< RVCDError > payload (new RVCDError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RVCDError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "RVCD", &cb);
    }
}

bool Videomanager_main_fiProxy::sendRVCDRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_RVCD,"RVCD");
}

void Videomanager_main_fiProxy::sendRVCDRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_RVCD);
}

const RVCDStatus& Videomanager_main_fiProxy::getRVCD() const {
    return _rVCD.get();
}

bool Videomanager_main_fiProxy::hasRVCD() const {
    return _rVCD.hasValue();
}

act_t Videomanager_main_fiProxy::sendRVCDGet(RVCDCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_RVCD);
        ::boost::shared_ptr< RVCDGet > payload (new RVCDGet());
        CCA_MESSAGE(ccaMessage,header,RVCDGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "RVCD", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RVCD);
        ::boost::shared_ptr< RVCDError > payload (new RVCDError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RVCDError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "RVCD", &cb);
    }
}

act_t Videomanager_main_fiProxy::sendRVCDSet(RVCDCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_RVCD);
        ::boost::shared_ptr< RVCDSet > payload (new RVCDSet());
        CCA_MESSAGE(ccaMessage,header,RVCDSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "RVCD", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RVCD);
        ::boost::shared_ptr< RVCDError > payload (new RVCDError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RVCDError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "RVCD", &cb);
    }
}

act_t Videomanager_main_fiProxy::sendDTVUpReg(DTVCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_DTV);
        ::boost::shared_ptr< DTVUpReg > payload (new DTVUpReg());
        CCA_MESSAGE(ccaMessage,header,DTVUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< DTVRelUpReg > payloadRelUpRegHeap (new DTVRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_DTV, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::videomanager_main_fi::DTVRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_DTV, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "DTV", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "DTV", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasDTV()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_DTV, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< DTVStatus > payloadLoopback (new DTVStatus(getDTV()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,DTVStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DTV);
        ::boost::shared_ptr< DTVError > payload (new DTVError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DTVError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "DTV", &cb);
    }
}

bool Videomanager_main_fiProxy::sendDTVRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_DTV,"DTV");
}

void Videomanager_main_fiProxy::sendDTVRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_DTV);
}

const DTVStatus& Videomanager_main_fiProxy::getDTV() const {
    return _dTV.get();
}

bool Videomanager_main_fiProxy::hasDTV() const {
    return _dTV.hasValue();
}

act_t Videomanager_main_fiProxy::sendDTVGet(DTVCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_DTV);
        ::boost::shared_ptr< DTVGet > payload (new DTVGet());
        CCA_MESSAGE(ccaMessage,header,DTVGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "DTV", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DTV);
        ::boost::shared_ptr< DTVError > payload (new DTVError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DTVError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "DTV", &cb);
    }
}

act_t Videomanager_main_fiProxy::sendDTVSet(DTVCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_DTV);
        ::boost::shared_ptr< DTVSet > payload (new DTVSet());
        CCA_MESSAGE(ccaMessage,header,DTVSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "DTV", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DTV);
        ::boost::shared_ptr< DTVError > payload (new DTVError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DTVError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "DTV", &cb);
    }
}

act_t Videomanager_main_fiProxy::sendSPCXUpReg(SPCXCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_SPCX);
        ::boost::shared_ptr< SPCXUpReg > payload (new SPCXUpReg());
        CCA_MESSAGE(ccaMessage,header,SPCXUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< SPCXRelUpReg > payloadRelUpRegHeap (new SPCXRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_SPCX, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::videomanager_main_fi::SPCXRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_SPCX, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "SPCX", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "SPCX", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasSPCX()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_SPCX, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< SPCXStatus > payloadLoopback (new SPCXStatus(getSPCX()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,SPCXStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SPCX);
        ::boost::shared_ptr< SPCXError > payload (new SPCXError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SPCXError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "SPCX", &cb);
    }
}

bool Videomanager_main_fiProxy::sendSPCXRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_SPCX,"SPCX");
}

void Videomanager_main_fiProxy::sendSPCXRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_SPCX);
}

const SPCXStatus& Videomanager_main_fiProxy::getSPCX() const {
    return _sPCX.get();
}

bool Videomanager_main_fiProxy::hasSPCX() const {
    return _sPCX.hasValue();
}

act_t Videomanager_main_fiProxy::sendSPCXGet(SPCXCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_SPCX);
        ::boost::shared_ptr< SPCXGet > payload (new SPCXGet());
        CCA_MESSAGE(ccaMessage,header,SPCXGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "SPCX", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SPCX);
        ::boost::shared_ptr< SPCXError > payload (new SPCXError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SPCXError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "SPCX", &cb);
    }
}

act_t Videomanager_main_fiProxy::sendSPCXSet(SPCXCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_SPCX);
        ::boost::shared_ptr< SPCXSet > payload (new SPCXSet());
        CCA_MESSAGE(ccaMessage,header,SPCXSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "SPCX", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SPCX);
        ::boost::shared_ptr< SPCXError > payload (new SPCXError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SPCXError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "SPCX", &cb);
    }
}

act_t Videomanager_main_fiProxy::sendDVDUpReg(DVDCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_DVD);
        ::boost::shared_ptr< DVDUpReg > payload (new DVDUpReg());
        CCA_MESSAGE(ccaMessage,header,DVDUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< DVDRelUpReg > payloadRelUpRegHeap (new DVDRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_DVD, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::videomanager_main_fi::DVDRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_DVD, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "DVD", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "DVD", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasDVD()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_DVD, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< DVDStatus > payloadLoopback (new DVDStatus(getDVD()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,DVDStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DVD);
        ::boost::shared_ptr< DVDError > payload (new DVDError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DVDError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "DVD", &cb);
    }
}

bool Videomanager_main_fiProxy::sendDVDRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_DVD,"DVD");
}

void Videomanager_main_fiProxy::sendDVDRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_DVD);
}

const DVDStatus& Videomanager_main_fiProxy::getDVD() const {
    return _dVD.get();
}

bool Videomanager_main_fiProxy::hasDVD() const {
    return _dVD.hasValue();
}

act_t Videomanager_main_fiProxy::sendDVDGet(DVDCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_DVD);
        ::boost::shared_ptr< DVDGet > payload (new DVDGet());
        CCA_MESSAGE(ccaMessage,header,DVDGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "DVD", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DVD);
        ::boost::shared_ptr< DVDError > payload (new DVDError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DVDError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "DVD", &cb);
    }
}

act_t Videomanager_main_fiProxy::sendDVDSet(DVDCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_DVD);
        ::boost::shared_ptr< DVDSet > payload (new DVDSet());
        CCA_MESSAGE(ccaMessage,header,DVDSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "DVD", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DVD);
        ::boost::shared_ptr< DVDError > payload (new DVDError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DVDError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "DVD", &cb);
    }
}

act_t Videomanager_main_fiProxy::sendUSBUpReg(USBCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_USB);
        ::boost::shared_ptr< USBUpReg > payload (new USBUpReg());
        CCA_MESSAGE(ccaMessage,header,USBUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< USBRelUpReg > payloadRelUpRegHeap (new USBRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_USB, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::videomanager_main_fi::USBRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_USB, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "USB", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "USB", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasUSB()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_USB, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< USBStatus > payloadLoopback (new USBStatus(getUSB()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,USBStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_USB);
        ::boost::shared_ptr< USBError > payload (new USBError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,USBError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "USB", &cb);
    }
}

bool Videomanager_main_fiProxy::sendUSBRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_USB,"USB");
}

void Videomanager_main_fiProxy::sendUSBRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_USB);
}

const USBStatus& Videomanager_main_fiProxy::getUSB() const {
    return _uSB.get();
}

bool Videomanager_main_fiProxy::hasUSB() const {
    return _uSB.hasValue();
}

act_t Videomanager_main_fiProxy::sendUSBGet(USBCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_USB);
        ::boost::shared_ptr< USBGet > payload (new USBGet());
        CCA_MESSAGE(ccaMessage,header,USBGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "USB", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_USB);
        ::boost::shared_ptr< USBError > payload (new USBError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,USBError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "USB", &cb);
    }
}

act_t Videomanager_main_fiProxy::sendUSBSet(USBCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_USB);
        ::boost::shared_ptr< USBSet > payload (new USBSet());
        CCA_MESSAGE(ccaMessage,header,USBSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "USB", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_USB);
        ::boost::shared_ptr< USBError > payload (new USBError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,USBError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "USB", &cb);
    }
}

act_t Videomanager_main_fiProxy::sendDeserializerUsedByUpReg(DeserializerUsedByCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_DeserializerUsedBy);
        ::boost::shared_ptr< DeserializerUsedByUpReg > payload (new DeserializerUsedByUpReg());
        CCA_MESSAGE(ccaMessage,header,DeserializerUsedByUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< DeserializerUsedByRelUpReg > payloadRelUpRegHeap (new DeserializerUsedByRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_DeserializerUsedBy, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::videomanager_main_fi::DeserializerUsedByRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_DeserializerUsedBy, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "DeserializerUsedBy", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "DeserializerUsedBy", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasDeserializerUsedBy()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_DeserializerUsedBy, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< DeserializerUsedByStatus > payloadLoopback (new DeserializerUsedByStatus(getDeserializerUsedBy()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,DeserializerUsedByStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DeserializerUsedBy);
        ::boost::shared_ptr< DeserializerUsedByError > payload (new DeserializerUsedByError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DeserializerUsedByError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "DeserializerUsedBy", &cb);
    }
}

bool Videomanager_main_fiProxy::sendDeserializerUsedByRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_DeserializerUsedBy,"DeserializerUsedBy");
}

void Videomanager_main_fiProxy::sendDeserializerUsedByRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_DeserializerUsedBy);
}

const DeserializerUsedByStatus& Videomanager_main_fiProxy::getDeserializerUsedBy() const {
    return _deserializerUsedBy.get();
}

bool Videomanager_main_fiProxy::hasDeserializerUsedBy() const {
    return _deserializerUsedBy.hasValue();
}

act_t Videomanager_main_fiProxy::sendDeserializerUsedByGet(DeserializerUsedByCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_DeserializerUsedBy);
        ::boost::shared_ptr< DeserializerUsedByGet > payload (new DeserializerUsedByGet());
        CCA_MESSAGE(ccaMessage,header,DeserializerUsedByGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "DeserializerUsedBy", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DeserializerUsedBy);
        ::boost::shared_ptr< DeserializerUsedByError > payload (new DeserializerUsedByError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DeserializerUsedByError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "DeserializerUsedBy", &cb);
    }
}

act_t Videomanager_main_fiProxy::sendDeserializerUsedBySet(DeserializerUsedByCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_DeserializerUsedBy);
        ::boost::shared_ptr< DeserializerUsedBySet > payload (new DeserializerUsedBySet());
        CCA_MESSAGE(ccaMessage,header,DeserializerUsedBySet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "DeserializerUsedBy", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DeserializerUsedBy);
        ::boost::shared_ptr< DeserializerUsedByError > payload (new DeserializerUsedByError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DeserializerUsedByError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "DeserializerUsedBy", &cb);
    }
}


void Videomanager_main_fiProxy::clearAllProperties ()
{
    _rVCA = ::asf::core::nullable<RVCAStatus>();
    _rVCD = ::asf::core::nullable<RVCDStatus>();
    _dTV = ::asf::core::nullable<DTVStatus>();
    _sPCX = ::asf::core::nullable<SPCXStatus>();
    _dVD = ::asf::core::nullable<DVDStatus>();
    _uSB = ::asf::core::nullable<USBStatus>();
    _deserializerUsedBy = ::asf::core::nullable<DeserializerUsedByStatus>();
}

void Videomanager_main_fiProxy::sendRelUpRegAll()
{
    sendRVCARelUpRegAll();
    sendRVCDRelUpRegAll();
    sendDTVRelUpRegAll();
    sendSPCXRelUpRegAll();
    sendDVDRelUpRegAll();
    sendUSBRelUpRegAll();
    sendDeserializerUsedByRelUpRegAll();
}

::boost::shared_ptr< ::asf::cca::CcaProxyCallback > Videomanager_main_fiProxy::createCallback(uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb)
{
     ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback(new Videomanager_main_fiProxyCallback(fid, opCode, cb));
     _ccaProxyDelegate->addCallback (commandCounter, callback);
    return callback;
}

} // namespace videomanager_main_fi
