/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/stream/json.h"
#include "vehicle_main_fi_typesConst.h"
#include <cstddef>
#include <cstdlib>

/**
 * Types vehicle_main_fi_types
 */

using namespace ::asf::stream::json;

namespace vehicle_main_fi_types {

bool T_e8_Language_Code_Parse (const char *str, size_t length, T_e8_Language_Code &value)
{
    static stringEntry entries[] = {
        {4,"THAI", 51U},
        {5,"CZECH", 8U},
        {5,"DUTCH", 10U},
        {5,"GREEK", 24U},
        {5,"HINDI", 26U},
        {5,"MALAY", 34U},
        {6,"ARABIC", 2U},
        {6,"DANISH", 9U},
        {6,"FRENCH", 21U},
        {6,"GERMAN", 23U},
        {6,"HEBREW", 25U},
        {6,"KOREAN", 31U},
        {6,"POLISH", 38U},
        {6,"UNUSED", 254U},
        {7,"FINNISH", 19U},
        {7,"FLEMISH", 20U},
        {7,"ITALIAN", 29U},
        {7,"LATVIAN", 32U},
        {7,"RUSSIAN", 42U},
        {7,"SERBIAN", 43U},
        {7,"SPANISH", 46U},
        {7,"SWEDISH", 49U},
        {7,"TURKISH", 52U},
        {7,"UNKNOWN", 0U},
        {8,"ALBANESE", 1U},
        {8,"CROATIAN", 7U},
        {8,"ESTONIAN", 18U},
        {8,"JAPANESE", 30U},
        {8,"ROMANIAN", 41U},
        {9,"BULGARIAN", 3U},
        {9,"HUNGARIAN", 27U},
        {9,"NORWEGIAN", 35U},
        {9,"SLOVAKIAN", 44U},
        {9,"SLOVENIAN", 45U},
        {9,"TAIWANESE", 50U},
        {9,"UKRAINIAN", 53U},
        {10,"ENGLISH_UK", 12U},
        {10,"ENGLISH_US", 13U},
        {10,"INDONESIAN", 28U},
        {10,"LITHUANIAN", 33U},
        {10,"PORTUGUESE", 39U},
        {10,"VIETNAMESE", 54U},
        {11,"PHILIPPINES", 37U},
        {11,"UNSUPPORTED", 255U},
        {13,"ENGLISH_INDIA", 17U},
        {15,"FRENCH_CANADIAN", 22U},
        {15,"SPANISH_MEXICAN", 48U},
        {16,"ENGLISH_CANADIAN", 16U},
        {18,"ENGLISH_AUSTRALIAN", 11U},
        {18,"ENGLISH_US_FOR_JPN", 14U},
        {18,"ENGLISH_US_FOR_PRC", 15U},
        {20,"PORTUGUESE_BRAZILIAN", 40U},
        {21,"PERSIAN_FARSI_IRANIAN", 36U},
        {22,"SPANISH_LATIN_AMERICAN", 47U},
        {45,"CHINESE_MANDARIN_SIMPLIFIED_CHINESE_CHARACTER", 6U},
        {46,"CHINESE_CANTONESE_SIMPLIFIED_CHINESE_CHARACTER", 4U},
        {47,"CHINESE_CANTONESE_TRADITIONAL_CHINESE_CHARACTER", 5U},
    };

    return lookupInStringEntryTable (str, length, entries, 57, (unsigned int&) value);
}

const char* T_e8_Language_Code_Name (T_e8_Language_Code value)
{
    static const char* enumerationLiterals[] = {
        "Unknown",
        "Albanese",
        "Arabic",
        "Bulgarian",
        "Chinese_Cantonese_Simplified_Chinese_character",
        "Chinese_Cantonese_Traditional_Chinese_character",
        "Chinese_Mandarin_Simplified_Chinese_character",
        "Croatian",
        "Czech",
        "Danish",
        "Dutch",
        "English_Australian",
        "English_UK",
        "English_US",
        "English_US_for_JPN",
        "English_US_for_PRC",
        "English_Canadian",
        "English_India",
        "Estonian",
        "Finnish",
        "Flemish",
        "French",
        "French_Canadian",
        "German",
        "Greek",
        "Hebrew",
        "Hindi",
        "Hungarian",
        "Indonesian",
        "Italian",
        "Japanese",
        "Korean",
        "Latvian",
        "Lithuanian",
        "Malay",
        "Norwegian",
        "Persian_Farsi_Iranian",
        "Philippines",
        "Polish",
        "Portuguese",
        "Portuguese_Brazilian",
        "Romanian",
        "Russian",
        "Serbian",
        "Slovakian",
        "Slovenian",
        "Spanish",
        "Spanish_Latin_American",
        "Spanish_Mexican",
        "Swedish",
        "Taiwanese",
        "Thai",
        "Turkish",
        "Ukrainian",
        "Vietnamese",
        "Unused",
        "UnSupported",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        3U,
        4U,
        5U,
        6U,
        7U,
        8U,
        9U,
        10U,
        11U,
        12U,
        13U,
        14U,
        15U,
        16U,
        17U,
        18U,
        19U,
        20U,
        21U,
        22U,
        23U,
        24U,
        25U,
        26U,
        27U,
        28U,
        29U,
        30U,
        31U,
        32U,
        33U,
        34U,
        35U,
        36U,
        37U,
        38U,
        39U,
        40U,
        41U,
        42U,
        43U,
        44U,
        45U,
        46U,
        47U,
        48U,
        49U,
        50U,
        51U,
        52U,
        53U,
        54U,
        254U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 57, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_Language_Code_IsValid (T_e8_Language_Code value)
{
    switch (value) {
    case T_e8_Language_Code__Unknown:
    case T_e8_Language_Code__Albanese:
    case T_e8_Language_Code__Arabic:
    case T_e8_Language_Code__Bulgarian:
    case T_e8_Language_Code__Chinese_Cantonese_Simplified_Chinese_character:
    case T_e8_Language_Code__Chinese_Cantonese_Traditional_Chinese_character:
    case T_e8_Language_Code__Chinese_Mandarin_Simplified_Chinese_character:
    case T_e8_Language_Code__Croatian:
    case T_e8_Language_Code__Czech:
    case T_e8_Language_Code__Danish:
    case T_e8_Language_Code__Dutch:
    case T_e8_Language_Code__English_Australian:
    case T_e8_Language_Code__English_UK:
    case T_e8_Language_Code__English_US:
    case T_e8_Language_Code__English_US_for_JPN:
    case T_e8_Language_Code__English_US_for_PRC:
    case T_e8_Language_Code__English_Canadian:
    case T_e8_Language_Code__English_India:
    case T_e8_Language_Code__Estonian:
    case T_e8_Language_Code__Finnish:
    case T_e8_Language_Code__Flemish:
    case T_e8_Language_Code__French:
    case T_e8_Language_Code__French_Canadian:
    case T_e8_Language_Code__German:
    case T_e8_Language_Code__Greek:
    case T_e8_Language_Code__Hebrew:
    case T_e8_Language_Code__Hindi:
    case T_e8_Language_Code__Hungarian:
    case T_e8_Language_Code__Indonesian:
    case T_e8_Language_Code__Italian:
    case T_e8_Language_Code__Japanese:
    case T_e8_Language_Code__Korean:
    case T_e8_Language_Code__Latvian:
    case T_e8_Language_Code__Lithuanian:
    case T_e8_Language_Code__Malay:
    case T_e8_Language_Code__Norwegian:
    case T_e8_Language_Code__Persian_Farsi_Iranian:
    case T_e8_Language_Code__Philippines:
    case T_e8_Language_Code__Polish:
    case T_e8_Language_Code__Portuguese:
    case T_e8_Language_Code__Portuguese_Brazilian:
    case T_e8_Language_Code__Romanian:
    case T_e8_Language_Code__Russian:
    case T_e8_Language_Code__Serbian:
    case T_e8_Language_Code__Slovakian:
    case T_e8_Language_Code__Slovenian:
    case T_e8_Language_Code__Spanish:
    case T_e8_Language_Code__Spanish_Latin_American:
    case T_e8_Language_Code__Spanish_Mexican:
    case T_e8_Language_Code__Swedish:
    case T_e8_Language_Code__Taiwanese:
    case T_e8_Language_Code__Thai:
    case T_e8_Language_Code__Turkish:
    case T_e8_Language_Code__Ukrainian:
    case T_e8_Language_Code__Vietnamese:
    case T_e8_Language_Code__Unused:
    case T_e8_Language_Code__UnSupported:
        return true;
    default:
        return false;
    }
}

bool T_e8_Vehicle_DistanceUnit_Parse (const char *str, size_t length, T_e8_Vehicle_DistanceUnit &value)
{
    static stringEntry entries[] = {
        {2,"KM", 2U},
        {5,"MILES", 1U},
        {7,"UNKNOWN", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_Vehicle_DistanceUnit_Name (T_e8_Vehicle_DistanceUnit value)
{
    static const char* enumerationLiterals[] = {
        "Unknown",
        "Miles",
        "Km",
    };

    if (T_e8_Vehicle_DistanceUnit_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_Vehicle_DistanceUnit_IsValid (T_e8_Vehicle_DistanceUnit value)
{
    switch (value) {
    case T_e8_Vehicle_DistanceUnit__Unknown:
    case T_e8_Vehicle_DistanceUnit__Miles:
    case T_e8_Vehicle_DistanceUnit__Km:
        return true;
    default:
        return false;
    }
}

bool T_e8_Vehicle_FuelConsumptionUnit_Parse (const char *str, size_t length, T_e8_Vehicle_FuelConsumptionUnit &value)
{
    static stringEntry entries[] = {
        {6,"UK_MPG", 4U},
        {6,"US_MPG", 3U},
        {7,"UNKNOWN", 0U},
        {8,"KM_PER_L", 1U},
        {11,"L_PER_100KM", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 5, (unsigned int&) value);
}

const char* T_e8_Vehicle_FuelConsumptionUnit_Name (T_e8_Vehicle_FuelConsumptionUnit value)
{
    static const char* enumerationLiterals[] = {
        "Unknown",
        "km_per_l",
        "l_per_100km",
        "US_MPG",
        "UK_MPG",
    };

    if (T_e8_Vehicle_FuelConsumptionUnit_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_Vehicle_FuelConsumptionUnit_IsValid (T_e8_Vehicle_FuelConsumptionUnit value)
{
    switch (value) {
    case T_e8_Vehicle_FuelConsumptionUnit__Unknown:
    case T_e8_Vehicle_FuelConsumptionUnit__km_per_l:
    case T_e8_Vehicle_FuelConsumptionUnit__l_per_100km:
    case T_e8_Vehicle_FuelConsumptionUnit__US_MPG:
    case T_e8_Vehicle_FuelConsumptionUnit__UK_MPG:
        return true;
    default:
        return false;
    }
}

bool T_e8_Vehicle_TemperatureUnit_Parse (const char *str, size_t length, T_e8_Vehicle_TemperatureUnit &value)
{
    static stringEntry entries[] = {
        {5,"DEG_C", 2U},
        {5,"DEG_F", 1U},
        {7,"UNKNOWN", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_Vehicle_TemperatureUnit_Name (T_e8_Vehicle_TemperatureUnit value)
{
    static const char* enumerationLiterals[] = {
        "Unknown",
        "deg_F",
        "deg_C",
    };

    if (T_e8_Vehicle_TemperatureUnit_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_Vehicle_TemperatureUnit_IsValid (T_e8_Vehicle_TemperatureUnit value)
{
    switch (value) {
    case T_e8_Vehicle_TemperatureUnit__Unknown:
    case T_e8_Vehicle_TemperatureUnit__deg_F:
    case T_e8_Vehicle_TemperatureUnit__deg_C:
        return true;
    default:
        return false;
    }
}

bool T_e8_Vehicle_HandBrakeStatus_Parse (const char *str, size_t length, T_e8_Vehicle_HandBrakeStatus &value)
{
    static stringEntry entries[] = {
        {2,"ON", 2U},
        {3,"OFF", 1U},
        {7,"UNKNOWN", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_Vehicle_HandBrakeStatus_Name (T_e8_Vehicle_HandBrakeStatus value)
{
    static const char* enumerationLiterals[] = {
        "Unknown",
        "OFF",
        "ON",
    };

    if (T_e8_Vehicle_HandBrakeStatus_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_Vehicle_HandBrakeStatus_IsValid (T_e8_Vehicle_HandBrakeStatus value)
{
    switch (value) {
    case T_e8_Vehicle_HandBrakeStatus__Unknown:
    case T_e8_Vehicle_HandBrakeStatus__OFF:
    case T_e8_Vehicle_HandBrakeStatus__ON:
        return true;
    default:
        return false;
    }
}

bool T_e8_Vehicle_Ignition_Parse (const char *str, size_t length, T_e8_Vehicle_Ignition &value)
{
    static stringEntry entries[] = {
        {2,"ON", 2U},
        {3,"OFF", 1U},
        {7,"UNKNOWN", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_Vehicle_Ignition_Name (T_e8_Vehicle_Ignition value)
{
    static const char* enumerationLiterals[] = {
        "Unknown",
        "OFF",
        "ON",
    };

    if (T_e8_Vehicle_Ignition_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_Vehicle_Ignition_IsValid (T_e8_Vehicle_Ignition value)
{
    switch (value) {
    case T_e8_Vehicle_Ignition__Unknown:
    case T_e8_Vehicle_Ignition__OFF:
    case T_e8_Vehicle_Ignition__ON:
        return true;
    default:
        return false;
    }
}

bool T_e8_Language_SourceId_Parse (const char *str, size_t length, T_e8_Language_SourceId &value)
{
    static stringEntry entries[] = {
        {3,"HMI", 0U},
        {3,"SDS", 2U},
        {4,"DIAG", 4U},
        {5,"METER", 1U},
        {6,"SYSTEM", 3U},
        {7,"UNKNOWN", 255U},
    };

    return lookupInStringEntryTable (str, length, entries, 6, (unsigned int&) value);
}

const char* T_e8_Language_SourceId_Name (T_e8_Language_SourceId value)
{
    static const char* enumerationLiterals[] = {
        "HMI",
        "Meter",
        "SDS",
        "System",
        "Diag",
        "Unknown",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        3U,
        4U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 6, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_Language_SourceId_IsValid (T_e8_Language_SourceId value)
{
    switch (value) {
    case T_e8_Language_SourceId__HMI:
    case T_e8_Language_SourceId__Meter:
    case T_e8_Language_SourceId__SDS:
    case T_e8_Language_SourceId__System:
    case T_e8_Language_SourceId__Diag:
    case T_e8_Language_SourceId__Unknown:
        return true;
    default:
        return false;
    }
}

bool T_e8_Meter_SyncRequest_Parse (const char *str, size_t length, T_e8_Meter_SyncRequest &value)
{
    static stringEntry entries[] = {
        {7,"NO_SYNC", 2U},
        {9,"LIST_MENU", 3U},
        {10,"NO_REQUEST", 0U},
        {11,"SYNCHRONIZE", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_Meter_SyncRequest_Name (T_e8_Meter_SyncRequest value)
{
    static const char* enumerationLiterals[] = {
        "No_Request",
        "Synchronize",
        "No_Sync",
        "List_Menu",
    };

    if (T_e8_Meter_SyncRequest_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_Meter_SyncRequest_IsValid (T_e8_Meter_SyncRequest value)
{
    switch (value) {
    case T_e8_Meter_SyncRequest__No_Request:
    case T_e8_Meter_SyncRequest__Synchronize:
    case T_e8_Meter_SyncRequest__No_Sync:
    case T_e8_Meter_SyncRequest__List_Menu:
        return true;
    default:
        return false;
    }
}

bool T_e8_Meter_LangKnowledge_Parse (const char *str, size_t length, T_e8_Meter_LangKnowledge &value)
{
    static stringEntry entries[] = {
        {5,"KNOWN", 1U},
        {8,"NOT_USED", 3U},
        {9,"NOT_KNOWN", 2U},
        {10,"NO_REQUEST", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_Meter_LangKnowledge_Name (T_e8_Meter_LangKnowledge value)
{
    static const char* enumerationLiterals[] = {
        "No_Request",
        "Known",
        "Not_known",
        "Not_used",
    };

    if (T_e8_Meter_LangKnowledge_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_Meter_LangKnowledge_IsValid (T_e8_Meter_LangKnowledge value)
{
    switch (value) {
    case T_e8_Meter_LangKnowledge__No_Request:
    case T_e8_Meter_LangKnowledge__Known:
    case T_e8_Meter_LangKnowledge__Not_known:
    case T_e8_Meter_LangKnowledge__Not_used:
        return true;
    default:
        return false;
    }
}

bool T_e8_Vehicle_TPMSReset_Parse (const char *str, size_t length, T_e8_Vehicle_TPMSReset &value)
{
    static stringEntry entries[] = {
        {7,"SUPPORT", 1U},
        {13,"NO_DEFINITION", 3U},
        {17,"SUPPORT_AND_RESET", 2U},
        {25,"NOT_SUPPORT_THIS_FUNCTION", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_Vehicle_TPMSReset_Name (T_e8_Vehicle_TPMSReset value)
{
    static const char* enumerationLiterals[] = {
        "Not_Support_This_Function",
        "Support",
        "Support_And_Reset",
        "No_Definition",
    };

    if (T_e8_Vehicle_TPMSReset_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_Vehicle_TPMSReset_IsValid (T_e8_Vehicle_TPMSReset value)
{
    switch (value) {
    case T_e8_Vehicle_TPMSReset__Not_Support_This_Function:
    case T_e8_Vehicle_TPMSReset__Support:
    case T_e8_Vehicle_TPMSReset__Support_And_Reset:
    case T_e8_Vehicle_TPMSReset__No_Definition:
        return true;
    default:
        return false;
    }
}

bool T_e8_Vehicle_TirePressureInfo_Parse (const char *str, size_t length, T_e8_Vehicle_TirePressureInfo &value)
{
    static stringEntry entries[] = {
        {8,"NOT_USED", 33U},
        {10,"NO_REQUEST", 0U},
        {15,"200KPA_FOR_REAR", 17U},
        {15,"210KPA_FOR_REAR", 18U},
        {15,"220KPA_FOR_REAR", 19U},
        {15,"230KPA_FOR_REAR", 20U},
        {15,"240KPA_FOR_REAR", 21U},
        {15,"250KPA_FOR_REAR", 22U},
        {15,"260KPA_FOR_REAR", 23U},
        {15,"270KPA_FOR_REAR", 24U},
        {15,"280KPA_FOR_REAR", 25U},
        {15,"290KPA_FOR_REAR", 26U},
        {15,"300KPA_FOR_REAR", 27U},
        {15,"310KPA_FOR_REAR", 28U},
        {15,"320KPA_FOR_REAR", 29U},
        {15,"330KPA_FOR_REAR", 30U},
        {15,"340KPA_FOR_REAR", 31U},
        {16,"200KPA_FOR_FRONT", 1U},
        {16,"210KPA_FOR_FRONT", 2U},
        {16,"220KPA_FOR_FRONT", 3U},
        {16,"230KPA_FOR_FRONT", 4U},
        {16,"240KPA_FOR_FRONT", 5U},
        {16,"250KPA_FOR_FRONT", 6U},
        {16,"260KPA_FOR_FRONT", 7U},
        {16,"270KPA_FOR_FRONT", 8U},
        {16,"280KPA_FOR_FRONT", 9U},
        {16,"290KPA_FOR_FRONT", 10U},
        {16,"300KPA_FOR_FRONT", 11U},
        {16,"310KPA_FOR_FRONT", 12U},
        {16,"320KPA_FOR_FRONT", 13U},
        {16,"330KPA_FOR_FRONT", 14U},
        {16,"340KPA_FOR_FRONT", 15U},
        {18,"TPMS_RESET_REQUEST", 16U},
        {33,"TPMS_CHANGE_DEFAULT_STATUS_SIGNAL", 32U},
    };

    return lookupInStringEntryTable (str, length, entries, 34, (unsigned int&) value);
}

const char* T_e8_Vehicle_TirePressureInfo_Name (T_e8_Vehicle_TirePressureInfo value)
{
    static const char* enumerationLiterals[] = {
        "No_Request",
        "200kpa_For_Front",
        "210kpa_For_Front",
        "220kpa_For_Front",
        "230kpa_For_Front",
        "240kpa_For_Front",
        "250kpa_For_Front",
        "260kpa_For_Front",
        "270kpa_For_Front",
        "280kpa_For_Front",
        "290kpa_For_Front",
        "300kpa_For_Front",
        "310kpa_For_Front",
        "320kpa_For_Front",
        "330kpa_For_Front",
        "340kpa_For_Front",
        "TPMS_Reset_Request",
        "200kpa_For_Rear",
        "210kpa_For_Rear",
        "220kpa_For_Rear",
        "230kpa_For_Rear",
        "240kpa_For_Rear",
        "250kpa_For_Rear",
        "260kpa_For_Rear",
        "270kpa_For_Rear",
        "280kpa_For_Rear",
        "290kpa_For_Rear",
        "300kpa_For_Rear",
        "310kpa_For_Rear",
        "320kpa_For_Rear",
        "330kpa_For_Rear",
        "340kpa_For_Rear",
        "TPMS_Change_Default_Status_Signal",
        "Not_Used",
    };

    if (T_e8_Vehicle_TirePressureInfo_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_Vehicle_TirePressureInfo_IsValid (T_e8_Vehicle_TirePressureInfo value)
{
    switch (value) {
    case T_e8_Vehicle_TirePressureInfo__No_Request:
    case T_e8_Vehicle_TirePressureInfo__200kpa_For_Front:
    case T_e8_Vehicle_TirePressureInfo__210kpa_For_Front:
    case T_e8_Vehicle_TirePressureInfo__220kpa_For_Front:
    case T_e8_Vehicle_TirePressureInfo__230kpa_For_Front:
    case T_e8_Vehicle_TirePressureInfo__240kpa_For_Front:
    case T_e8_Vehicle_TirePressureInfo__250kpa_For_Front:
    case T_e8_Vehicle_TirePressureInfo__260kpa_For_Front:
    case T_e8_Vehicle_TirePressureInfo__270kpa_For_Front:
    case T_e8_Vehicle_TirePressureInfo__280kpa_For_Front:
    case T_e8_Vehicle_TirePressureInfo__290kpa_For_Front:
    case T_e8_Vehicle_TirePressureInfo__300kpa_For_Front:
    case T_e8_Vehicle_TirePressureInfo__310kpa_For_Front:
    case T_e8_Vehicle_TirePressureInfo__320kpa_For_Front:
    case T_e8_Vehicle_TirePressureInfo__330kpa_For_Front:
    case T_e8_Vehicle_TirePressureInfo__340kpa_For_Front:
    case T_e8_Vehicle_TirePressureInfo__TPMS_Reset_Request:
    case T_e8_Vehicle_TirePressureInfo__200kpa_For_Rear:
    case T_e8_Vehicle_TirePressureInfo__210kpa_For_Rear:
    case T_e8_Vehicle_TirePressureInfo__220kpa_For_Rear:
    case T_e8_Vehicle_TirePressureInfo__230kpa_For_Rear:
    case T_e8_Vehicle_TirePressureInfo__240kpa_For_Rear:
    case T_e8_Vehicle_TirePressureInfo__250kpa_For_Rear:
    case T_e8_Vehicle_TirePressureInfo__260kpa_For_Rear:
    case T_e8_Vehicle_TirePressureInfo__270kpa_For_Rear:
    case T_e8_Vehicle_TirePressureInfo__280kpa_For_Rear:
    case T_e8_Vehicle_TirePressureInfo__290kpa_For_Rear:
    case T_e8_Vehicle_TirePressureInfo__300kpa_For_Rear:
    case T_e8_Vehicle_TirePressureInfo__310kpa_For_Rear:
    case T_e8_Vehicle_TirePressureInfo__320kpa_For_Rear:
    case T_e8_Vehicle_TirePressureInfo__330kpa_For_Rear:
    case T_e8_Vehicle_TirePressureInfo__340kpa_For_Rear:
    case T_e8_Vehicle_TirePressureInfo__TPMS_Change_Default_Status_Signal:
    case T_e8_Vehicle_TirePressureInfo__Not_Used:
        return true;
    default:
        return false;
    }
}

bool T_e8_Vehicle_WarningState_Parse (const char *str, size_t length, T_e8_Vehicle_WarningState &value)
{
    static stringEntry entries[] = {
        {10,"SERV_ON_R3", 1U},
        {10,"STOP_ON_D3", 2U},
        {12,"SERV_STOP_ON", 3U},
        {23,"NO_GLOBAL_VEHICLE_FAULT", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_Vehicle_WarningState_Name (T_e8_Vehicle_WarningState value)
{
    static const char* enumerationLiterals[] = {
        "No_Global_Vehicle_Fault",
        "SERV_ON_R3",
        "STOP_ON_D3",
        "SERV_STOP_ON",
    };

    if (T_e8_Vehicle_WarningState_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_Vehicle_WarningState_IsValid (T_e8_Vehicle_WarningState value)
{
    switch (value) {
    case T_e8_Vehicle_WarningState__No_Global_Vehicle_Fault:
    case T_e8_Vehicle_WarningState__SERV_ON_R3:
    case T_e8_Vehicle_WarningState__STOP_ON_D3:
    case T_e8_Vehicle_WarningState__SERV_STOP_ON:
        return true;
    default:
        return false;
    }
}

bool T_e8_Vehicle_States_Parse (const char *str, size_t length, T_e8_Vehicle_States &value)
{
    static stringEntry entries[] = {
        {7,"AUTOACC", 3U},
        {7,"NOTUSED", 4U},
        {8,"NOTUSED1", 10U},
        {8,"NOTUSED2", 11U},
        {8,"NOTUSED3", 12U},
        {8,"NOTUSED4", 13U},
        {8,"NOTUSED5", 14U},
        {8,"SLEEPING", 0U},
        {9,"AUTOSTART", 8U},
        {11,"UNAVAILABLE", 15U},
        {13,"CUTOFFPENDING", 2U},
        {13,"IGNITIONLEVEL", 5U},
        {16,"ENGINESYSTEMSTOP", 9U},
        {16,"TECHNICAL_WAKEUP", 1U},
        {17,"POWERTRAINRUNNING", 7U},
        {18,"STARTINGINPROGRESS", 6U},
    };

    return lookupInStringEntryTable (str, length, entries, 16, (unsigned int&) value);
}

const char* T_e8_Vehicle_States_Name (T_e8_Vehicle_States value)
{
    static const char* enumerationLiterals[] = {
        "Sleeping",
        "Technical_WakeUp",
        "CutOffPending",
        "AutoAcc",
        "NotUsed",
        "IgnitionLevel",
        "StartingInProgress",
        "PowertrainRunning",
        "AutoStart",
        "EngineSystemStop",
        "NotUsed1",
        "NotUsed2",
        "NotUsed3",
        "NotUsed4",
        "NotUsed5",
        "Unavailable",
    };

    if (T_e8_Vehicle_States_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_Vehicle_States_IsValid (T_e8_Vehicle_States value)
{
    switch (value) {
    case T_e8_Vehicle_States__Sleeping:
    case T_e8_Vehicle_States__Technical_WakeUp:
    case T_e8_Vehicle_States__CutOffPending:
    case T_e8_Vehicle_States__AutoAcc:
    case T_e8_Vehicle_States__NotUsed:
    case T_e8_Vehicle_States__IgnitionLevel:
    case T_e8_Vehicle_States__StartingInProgress:
    case T_e8_Vehicle_States__PowertrainRunning:
    case T_e8_Vehicle_States__AutoStart:
    case T_e8_Vehicle_States__EngineSystemStop:
    case T_e8_Vehicle_States__NotUsed1:
    case T_e8_Vehicle_States__NotUsed2:
    case T_e8_Vehicle_States__NotUsed3:
    case T_e8_Vehicle_States__NotUsed4:
    case T_e8_Vehicle_States__NotUsed5:
    case T_e8_Vehicle_States__Unavailable:
        return true;
    default:
        return false;
    }
}

} // namespace vehicle_main_fi_types
