#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef VEHICLE_MAIN_FI_TYPES_H
#define VEHICLE_MAIN_FI_TYPES_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/VersionCheck.h"
#include "vehicle_main_fi_typesConst.h"
#include <cstring>
#include <vector>

/**
 * Types vehicle_main_fi_types
 */

namespace vehicle_main_fi_types {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class T_Language_SourceTable;

class T_CAN_Message;

class T_CAN_Mesg;

// type definitions
/**
 * If the meaning of "T_CAN_Navi_Mesg" isn't clear, then there should be a description here.
 */
typedef ::std::vector< uint8 > T_CAN_Navi_Mesg;


/**
 * Structure containing - Source Id, Language Set by that Source, and, Flag informing if it has been changed recently
 */
class T_Language_SourceTable {
public:

    /**
     * Default constructor
     */
    inline  T_Language_SourceTable ();

    /**
     * Copy constructor
     */
    inline  T_Language_SourceTable (const T_Language_SourceTable &rhs);

    /**
     * All fields constructor
     */
    inline  T_Language_SourceTable (T_e8_Language_SourceId enLangSrcId_, T_e8_Language_Code enLanguage_, bool bHasChanged_);

    /**
     * Destructor
     */
    inline  ~T_Language_SourceTable();

    /**
     * Assignment operator
     */
    inline T_Language_SourceTable& operator = (const T_Language_SourceTable& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_Language_SourceTable& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_Language_SourceTable& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_Language_SourceTable& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_Language_SourceTable& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "enLangSrcId"

    static const int kEnLangSrcId = 0;

    /**
     * Clears the field "enLangSrcId".
     *
     * The field will be set to its default value. The hasEnLangSrcId()
     * method will return false.
     */
    inline void clearEnLangSrcId();

    /**
     * Checks whether the field "enLangSrcId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnLangSrcId()). Otherwise it will return false.
     */
    inline bool hasEnLangSrcId () const;

    /**
     * Returns the value of the member "enLangSrcId".
     *
     * Source Component Id for the language change
     *
     * @return The value of the field "enLangSrcId"
     */
    inline T_e8_Language_SourceId getEnLangSrcId () const;

    /**
     * Sets the value of the member "enLangSrcId".
     *
     * Source Component Id for the language change
     *
     * @param enLangSrcId The value which will be set
     */
    inline void setEnLangSrcId (T_e8_Language_SourceId enLangSrcId_);

    // API of field "enLanguage"

    static const int kEnLanguage = 1;

    /**
     * Clears the field "enLanguage".
     *
     * The field will be set to its default value. The hasEnLanguage()
     * method will return false.
     */
    inline void clearEnLanguage();

    /**
     * Checks whether the field "enLanguage" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnLanguage()). Otherwise it will return false.
     */
    inline bool hasEnLanguage () const;

    /**
     * Returns the value of the member "enLanguage".
     *
     * Enumeration of Language code
     *
     * @return The value of the field "enLanguage"
     */
    inline T_e8_Language_Code getEnLanguage () const;

    /**
     * Sets the value of the member "enLanguage".
     *
     * Enumeration of Language code
     *
     * @param enLanguage The value which will be set
     */
    inline void setEnLanguage (T_e8_Language_Code enLanguage_);

    // API of field "bHasChanged"

    static const int kBHasChanged = 2;

    /**
     * Clears the field "bHasChanged".
     *
     * The field will be set to its default value. The hasBHasChanged()
     * method will return false.
     */
    inline void clearBHasChanged();

    /**
     * Checks whether the field "bHasChanged" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBHasChanged()). Otherwise it will return false.
     */
    inline bool hasBHasChanged () const;

    /**
     * Returns the value of the member "bHasChanged".
     *
     * Has been recently update (TRUE) or not (FALSE)
     *
     * @return The value of the field "bHasChanged"
     */
    inline bool getBHasChanged () const;

    /**
     * Sets the value of the member "bHasChanged".
     *
     * Has been recently update (TRUE) or not (FALSE)
     *
     * @param bHasChanged The value which will be set
     */
    inline void setBHasChanged (bool bHasChanged_);

    static const T_Language_SourceTable &getDefaultInstance();

private:

    inline void set_has_enLangSrcId ();

    inline void clear_has_enLangSrcId ();

    inline void set_has_enLanguage ();

    inline void clear_has_enLanguage ();

    inline void set_has_bHasChanged ();

    inline void clear_has_bHasChanged ();

    uint32 _has_bits_[ (3 + 31) / 32];

    T_e8_Language_SourceId _enLangSrcId;

    T_e8_Language_Code _enLanguage;

    bool _bHasChanged;

};

/**
 * If the meaning of "T_CAN_Message" isn't clear, then there should be a description here.
 */
class T_CAN_Message {
public:

    /**
     * Default constructor
     */
    inline  T_CAN_Message ();

    /**
     * Copy constructor
     */
    inline  T_CAN_Message (const T_CAN_Message &rhs);

    /**
     * All fields constructor
     */
    inline  T_CAN_Message (uint32 u32MessageStatus_, uint32 u32MessageId_, const ::std::vector< uint8 >& listData_);

    /**
     * Destructor
     */
    inline  ~T_CAN_Message();

    /**
     * Assignment operator
     */
    inline T_CAN_Message& operator = (const T_CAN_Message& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_CAN_Message& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_CAN_Message& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_CAN_Message& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_CAN_Message& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32MessageStatus"

    static const int kU32MessageStatus = 0;

    /**
     * Clears the field "u32MessageStatus".
     *
     * The field will be set to its default value. The hasU32MessageStatus()
     * method will return false.
     */
    inline void clearU32MessageStatus();

    /**
     * Checks whether the field "u32MessageStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32MessageStatus()). Otherwise it will return false.
     */
    inline bool hasU32MessageStatus () const;

    /**
     * Returns the value of the member "u32MessageStatus".
     *
     * Status of the received CAN message. For detailed information refer to the CSM specification (value is bit coded).
     *
     * @return The value of the field "u32MessageStatus"
     */
    inline uint32 getU32MessageStatus () const;

    /**
     * Sets the value of the member "u32MessageStatus".
     *
     * Status of the received CAN message. For detailed information refer to the CSM specification (value is bit coded).
     *
     * @param u32MessageStatus The value which will be set
     */
    inline void setU32MessageStatus (uint32 u32MessageStatus_);

    // API of field "u32MessageId"

    static const int kU32MessageId = 1;

    /**
     * Clears the field "u32MessageId".
     *
     * The field will be set to its default value. The hasU32MessageId()
     * method will return false.
     */
    inline void clearU32MessageId();

    /**
     * Checks whether the field "u32MessageId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32MessageId()). Otherwise it will return false.
     */
    inline bool hasU32MessageId () const;

    /**
     * Returns the value of the member "u32MessageId".
     *
     * ID of the received CAN message.
     *
     * @return The value of the field "u32MessageId"
     */
    inline uint32 getU32MessageId () const;

    /**
     * Sets the value of the member "u32MessageId".
     *
     * ID of the received CAN message.
     *
     * @param u32MessageId The value which will be set
     */
    inline void setU32MessageId (uint32 u32MessageId_);

    // API of field "listData"

    static const int kListData = 2;

    /**
     * Clears the field "listData".
     *
     * The field will be set to its default value. The hasListData()
     * method will return false.
     */
    inline void clearListData();

    /**
     * Checks whether the field "listData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListData()). Otherwise it will return false.
     */
    inline bool hasListData () const;

    /**
     * Returns the value of the member "listData".
     *
     * Data of the received CAN message.
     *
     * @return The value of the field "listData"
     */
    inline const ::std::vector< uint8 >& getListData () const;

    /**
     * Retrieves the value of the field "listData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "listData".
     */
    inline ::std::vector< uint8 >& getListDataMutable ();

    /**
     * Sets the value of the member "listData".
     *
     * Data of the received CAN message.
     *
     * @param listData The value which will be set
     */
    inline void setListData (const ::std::vector< uint8 >& listData_);

    static const T_CAN_Message &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_u32MessageStatus ();

    inline void clear_has_u32MessageStatus ();

    inline void set_has_u32MessageId ();

    inline void clear_has_u32MessageId ();

    inline void set_has_listData ();

    inline void clear_has_listData ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _u32MessageStatus;

    uint32 _u32MessageId;

    ::std::vector< uint8 > _listData;

};

/**
 * If the meaning of "T_CAN_Mesg" isn't clear, then there should be a description here.
 */
class T_CAN_Mesg {
public:

    /**
     * Default constructor
     */
    inline  T_CAN_Mesg ();

    /**
     * Copy constructor
     */
    inline  T_CAN_Mesg (const T_CAN_Mesg &rhs);

    /**
     * All fields constructor
     */
    inline  T_CAN_Mesg (uint8 u8MediaType_, const ::std::vector< uint8 >& listData_);

    /**
     * Destructor
     */
    inline  ~T_CAN_Mesg();

    /**
     * Assignment operator
     */
    inline T_CAN_Mesg& operator = (const T_CAN_Mesg& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_CAN_Mesg& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_CAN_Mesg& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_CAN_Mesg& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_CAN_Mesg& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8MediaType"

    static const int kU8MediaType = 0;

    /**
     * Clears the field "u8MediaType".
     *
     * The field will be set to its default value. The hasU8MediaType()
     * method will return false.
     */
    inline void clearU8MediaType();

    /**
     * Checks whether the field "u8MediaType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8MediaType()). Otherwise it will return false.
     */
    inline bool hasU8MediaType () const;

    /**
     * Returns the value of the member "u8MediaType".
     *
     * Indicates the type of the Received Media.
     *
     * @return The value of the field "u8MediaType"
     */
    inline uint8 getU8MediaType () const;

    /**
     * Sets the value of the member "u8MediaType".
     *
     * Indicates the type of the Received Media.
     *
     * @param u8MediaType The value which will be set
     */
    inline void setU8MediaType (uint8 u8MediaType_);

    // API of field "listData"

    static const int kListData = 1;

    /**
     * Clears the field "listData".
     *
     * The field will be set to its default value. The hasListData()
     * method will return false.
     */
    inline void clearListData();

    /**
     * Checks whether the field "listData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListData()). Otherwise it will return false.
     */
    inline bool hasListData () const;

    /**
     * Returns the value of the member "listData".
     *
     * The list content should be in UTF-8 format. The first element in the list should indicate the Media type followed by its data and it should be ended with /0.
     * Application could also concatenate multiple Media types and send it. Applications shall use the following numbers to specify the type of Media.
     *
     * 1: mainline
     * 2: current filename
     * 3: current title
     * 4: current folder
     * 5: current artist
     * 6: current album
     * 7: XM advisory
     * 8: call name
     * 9: call number
     * 10: phone name
     * 11: provider name
     * 12: XM channel
     * 13: XM category
     * For Navi Interfaces
     * 1: CurrentStreetName
     * 5:TurnToStreetName
     *
     * @return The value of the field "listData"
     */
    inline const ::std::vector< uint8 >& getListData () const;

    /**
     * Retrieves the value of the field "listData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "listData".
     */
    inline ::std::vector< uint8 >& getListDataMutable ();

    /**
     * Sets the value of the member "listData".
     *
     * The list content should be in UTF-8 format. The first element in the list should indicate the Media type followed by its data and it should be ended with /0.
     * Application could also concatenate multiple Media types and send it. Applications shall use the following numbers to specify the type of Media.
     *
     * 1: mainline
     * 2: current filename
     * 3: current title
     * 4: current folder
     * 5: current artist
     * 6: current album
     * 7: XM advisory
     * 8: call name
     * 9: call number
     * 10: phone name
     * 11: provider name
     * 12: XM channel
     * 13: XM category
     * For Navi Interfaces
     * 1: CurrentStreetName
     * 5:TurnToStreetName
     *
     * @param listData The value which will be set
     */
    inline void setListData (const ::std::vector< uint8 >& listData_);

    static const T_CAN_Mesg &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_u8MediaType ();

    inline void clear_has_u8MediaType ();

    inline void set_has_listData ();

    inline void clear_has_listData ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8MediaType;

    ::std::vector< uint8 > _listData;

};

inline  T_Language_SourceTable::T_Language_SourceTable ()  :
    _enLangSrcId (::vehicle_main_fi_types::T_e8_Language_SourceId__HMI),
    _enLanguage (::vehicle_main_fi_types::T_e8_Language_Code__Unknown),
    _bHasChanged (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_Language_SourceTable::T_Language_SourceTable (const T_Language_SourceTable &rhs)  :
    _enLangSrcId (::vehicle_main_fi_types::T_e8_Language_SourceId__HMI),
    _enLanguage (::vehicle_main_fi_types::T_e8_Language_Code__Unknown),
    _bHasChanged (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_Language_SourceTable::T_Language_SourceTable (T_e8_Language_SourceId enLangSrcId_, T_e8_Language_Code enLanguage_, bool bHasChanged_)  :
    _enLangSrcId (enLangSrcId_),
    _enLanguage (enLanguage_),
    _bHasChanged (bHasChanged_)
{
    #ifndef NDEBUG
    if (!(T_e8_Language_SourceId_IsValid(enLangSrcId_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enLangSrcId_, "T_e8_Language_SourceId", "enLangSrcId", "T_Language_SourceTable");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_Language_Code_IsValid(enLanguage_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enLanguage_, "T_e8_Language_Code", "enLanguage", "T_Language_SourceTable");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_Language_SourceTable::~T_Language_SourceTable() {
}

inline T_Language_SourceTable& T_Language_SourceTable::operator = (const T_Language_SourceTable& rhs) {
    if( this != &rhs ) {
        if (rhs.hasEnLangSrcId()) {
            setEnLangSrcId(rhs.getEnLangSrcId());
        } else {
            clearEnLangSrcId();
        }
        if (rhs.hasEnLanguage()) {
            setEnLanguage(rhs.getEnLanguage());
        } else {
            clearEnLanguage();
        }
        if (rhs.hasBHasChanged()) {
            setBHasChanged(rhs.getBHasChanged());
        } else {
            clearBHasChanged();
        }
    }
    return *this;
}

inline bool T_Language_SourceTable::operator == (const T_Language_SourceTable& rhs) const {
    return (((!hasEnLangSrcId() && !rhs.hasEnLangSrcId()) || getEnLangSrcId() == rhs.getEnLangSrcId()) &&
        ((!hasEnLanguage() && !rhs.hasEnLanguage()) || getEnLanguage() == rhs.getEnLanguage()) &&
        ((!hasBHasChanged() && !rhs.hasBHasChanged()) || getBHasChanged() == rhs.getBHasChanged()));
}

inline bool T_Language_SourceTable::operator != (const T_Language_SourceTable& rhs) const {
    return ! (*this == rhs);
}

inline bool T_Language_SourceTable::operator < (const T_Language_SourceTable& rhs) const {
    if (hasEnLangSrcId() || rhs.hasEnLangSrcId()) {
        if ((uint32)getEnLangSrcId() < (uint32)rhs.getEnLangSrcId()) return true;
        if ((uint32)getEnLangSrcId() > (uint32)rhs.getEnLangSrcId()) return false;
    }
    if (hasEnLanguage() || rhs.hasEnLanguage()) {
        if ((uint32)getEnLanguage() < (uint32)rhs.getEnLanguage()) return true;
        if ((uint32)getEnLanguage() > (uint32)rhs.getEnLanguage()) return false;
    }
    if (hasBHasChanged() || rhs.hasBHasChanged()) {
        if (getBHasChanged() < rhs.getBHasChanged()) return true;
        if (getBHasChanged() > rhs.getBHasChanged()) return false;
    }
    return false;
}

inline bool T_Language_SourceTable::operator > (const T_Language_SourceTable& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_Language_SourceTable::clear() {
    clearEnLangSrcId();
    clearEnLanguage();
    clearBHasChanged();
}

inline void T_Language_SourceTable::clearEnLangSrcId() {
    if (hasEnLangSrcId()) {
         clear_has_enLangSrcId();
        _enLangSrcId = ::vehicle_main_fi_types::T_e8_Language_SourceId__HMI;
     }
}

inline bool T_Language_SourceTable::hasEnLangSrcId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_Language_SourceId T_Language_SourceTable::getEnLangSrcId () const {
    return _enLangSrcId;
}

inline void T_Language_SourceTable::setEnLangSrcId (T_e8_Language_SourceId enLangSrcId_) {
    #ifndef NDEBUG
    if (!(T_e8_Language_SourceId_IsValid(enLangSrcId_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enLangSrcId_, "T_e8_Language_SourceId", "enLangSrcId", "T_Language_SourceTable");
    }
    #endif
    set_has_enLangSrcId();
    this->_enLangSrcId = enLangSrcId_;
}

inline void T_Language_SourceTable::clearEnLanguage() {
    if (hasEnLanguage()) {
         clear_has_enLanguage();
        _enLanguage = ::vehicle_main_fi_types::T_e8_Language_Code__Unknown;
     }
}

inline bool T_Language_SourceTable::hasEnLanguage () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_Language_Code T_Language_SourceTable::getEnLanguage () const {
    return _enLanguage;
}

inline void T_Language_SourceTable::setEnLanguage (T_e8_Language_Code enLanguage_) {
    #ifndef NDEBUG
    if (!(T_e8_Language_Code_IsValid(enLanguage_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", enLanguage_, "T_e8_Language_Code", "enLanguage", "T_Language_SourceTable");
    }
    #endif
    set_has_enLanguage();
    this->_enLanguage = enLanguage_;
}

inline void T_Language_SourceTable::clearBHasChanged() {
    if (hasBHasChanged()) {
         clear_has_bHasChanged();
        _bHasChanged = false;
     }
}

inline bool T_Language_SourceTable::hasBHasChanged () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline bool T_Language_SourceTable::getBHasChanged () const {
    return _bHasChanged;
}

inline void T_Language_SourceTable::setBHasChanged (bool bHasChanged_) {
    set_has_bHasChanged();
    this->_bHasChanged = bHasChanged_;
}

inline void T_Language_SourceTable::set_has_enLangSrcId () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_Language_SourceTable::clear_has_enLangSrcId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_Language_SourceTable::set_has_enLanguage () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_Language_SourceTable::clear_has_enLanguage () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_Language_SourceTable::set_has_bHasChanged () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_Language_SourceTable::clear_has_bHasChanged () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_CAN_Message::T_CAN_Message ()  :
    _u32MessageStatus (0u),
    _u32MessageId (0u),
    _listData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_CAN_Message::T_CAN_Message (const T_CAN_Message &rhs)  :
    _u32MessageStatus (0u),
    _u32MessageId (0u),
    _listData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_CAN_Message::T_CAN_Message (uint32 u32MessageStatus_, uint32 u32MessageId_, const ::std::vector< uint8 >& listData_)  :
    _u32MessageStatus (u32MessageStatus_),
    _u32MessageId (u32MessageId_),
    _listData (listData_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_CAN_Message::~T_CAN_Message() {
}

inline T_CAN_Message& T_CAN_Message::operator = (const T_CAN_Message& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU32MessageStatus()) {
            setU32MessageStatus(rhs.getU32MessageStatus());
        } else {
            clearU32MessageStatus();
        }
        if (rhs.hasU32MessageId()) {
            setU32MessageId(rhs.getU32MessageId());
        } else {
            clearU32MessageId();
        }
        if (rhs.hasListData()) {
            setListData(rhs.getListData());
        } else {
            clearListData();
        }
    }
    return *this;
}

inline bool T_CAN_Message::operator == (const T_CAN_Message& rhs) const {
    return (((!hasU32MessageStatus() && !rhs.hasU32MessageStatus()) || getU32MessageStatus() == rhs.getU32MessageStatus()) &&
        ((!hasU32MessageId() && !rhs.hasU32MessageId()) || getU32MessageId() == rhs.getU32MessageId()) &&
        ((!hasListData() && !rhs.hasListData()) || getListData() == rhs.getListData()));
}

inline bool T_CAN_Message::operator != (const T_CAN_Message& rhs) const {
    return ! (*this == rhs);
}

inline bool T_CAN_Message::operator < (const T_CAN_Message& rhs) const {
    if (hasU32MessageStatus() || rhs.hasU32MessageStatus()) {
        if (getU32MessageStatus() < rhs.getU32MessageStatus()) return true;
        if (getU32MessageStatus() > rhs.getU32MessageStatus()) return false;
    }
    if (hasU32MessageId() || rhs.hasU32MessageId()) {
        if (getU32MessageId() < rhs.getU32MessageId()) return true;
        if (getU32MessageId() > rhs.getU32MessageId()) return false;
    }
    if (hasListData() || rhs.hasListData()) {
        if (getListData() < rhs.getListData()) return true;
        if (getListData() > rhs.getListData()) return false;
    }
    return false;
}

inline bool T_CAN_Message::operator > (const T_CAN_Message& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_CAN_Message::clear() {
    clearU32MessageStatus();
    clearU32MessageId();
    clearListData();
}

inline void T_CAN_Message::clearU32MessageStatus() {
    if (hasU32MessageStatus()) {
         clear_has_u32MessageStatus();
        _u32MessageStatus = 0u;
     }
}

inline bool T_CAN_Message::hasU32MessageStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_CAN_Message::getU32MessageStatus () const {
    return _u32MessageStatus;
}

inline void T_CAN_Message::setU32MessageStatus (uint32 u32MessageStatus_) {
    set_has_u32MessageStatus();
    this->_u32MessageStatus = u32MessageStatus_;
}

inline void T_CAN_Message::clearU32MessageId() {
    if (hasU32MessageId()) {
         clear_has_u32MessageId();
        _u32MessageId = 0u;
     }
}

inline bool T_CAN_Message::hasU32MessageId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 T_CAN_Message::getU32MessageId () const {
    return _u32MessageId;
}

inline void T_CAN_Message::setU32MessageId (uint32 u32MessageId_) {
    set_has_u32MessageId();
    this->_u32MessageId = u32MessageId_;
}

inline void T_CAN_Message::clearListData() {
    if (hasListData()) {
         clear_has_listData();
        _listData.clear();
     }
}

inline bool T_CAN_Message::hasListData () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::vector< uint8 >& T_CAN_Message::getListData () const {
    return _listData;
}

inline ::std::vector< uint8 >& T_CAN_Message::getListDataMutable () {
    set_has_listData();
    return _listData;
}

inline void T_CAN_Message::setListData (const ::std::vector< uint8 >& listData_) {
    set_has_listData();
    this->_listData = listData_;
}

inline void T_CAN_Message::set_has_u32MessageStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_CAN_Message::clear_has_u32MessageStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_CAN_Message::set_has_u32MessageId () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_CAN_Message::clear_has_u32MessageId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_CAN_Message::set_has_listData () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_CAN_Message::clear_has_listData () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_CAN_Mesg::T_CAN_Mesg ()  :
    _u8MediaType (0u),
    _listData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_CAN_Mesg::T_CAN_Mesg (const T_CAN_Mesg &rhs)  :
    _u8MediaType (0u),
    _listData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_CAN_Mesg::T_CAN_Mesg (uint8 u8MediaType_, const ::std::vector< uint8 >& listData_)  :
    _u8MediaType (u8MediaType_),
    _listData (listData_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_CAN_Mesg::~T_CAN_Mesg() {
}

inline T_CAN_Mesg& T_CAN_Mesg::operator = (const T_CAN_Mesg& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8MediaType()) {
            setU8MediaType(rhs.getU8MediaType());
        } else {
            clearU8MediaType();
        }
        if (rhs.hasListData()) {
            setListData(rhs.getListData());
        } else {
            clearListData();
        }
    }
    return *this;
}

inline bool T_CAN_Mesg::operator == (const T_CAN_Mesg& rhs) const {
    return (((!hasU8MediaType() && !rhs.hasU8MediaType()) || getU8MediaType() == rhs.getU8MediaType()) &&
        ((!hasListData() && !rhs.hasListData()) || getListData() == rhs.getListData()));
}

inline bool T_CAN_Mesg::operator != (const T_CAN_Mesg& rhs) const {
    return ! (*this == rhs);
}

inline bool T_CAN_Mesg::operator < (const T_CAN_Mesg& rhs) const {
    if (hasU8MediaType() || rhs.hasU8MediaType()) {
        if (getU8MediaType() < rhs.getU8MediaType()) return true;
        if (getU8MediaType() > rhs.getU8MediaType()) return false;
    }
    if (hasListData() || rhs.hasListData()) {
        if (getListData() < rhs.getListData()) return true;
        if (getListData() > rhs.getListData()) return false;
    }
    return false;
}

inline bool T_CAN_Mesg::operator > (const T_CAN_Mesg& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_CAN_Mesg::clear() {
    clearU8MediaType();
    clearListData();
}

inline void T_CAN_Mesg::clearU8MediaType() {
    if (hasU8MediaType()) {
         clear_has_u8MediaType();
        _u8MediaType = 0u;
     }
}

inline bool T_CAN_Mesg::hasU8MediaType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_CAN_Mesg::getU8MediaType () const {
    return _u8MediaType;
}

inline void T_CAN_Mesg::setU8MediaType (uint8 u8MediaType_) {
    set_has_u8MediaType();
    this->_u8MediaType = u8MediaType_;
}

inline void T_CAN_Mesg::clearListData() {
    if (hasListData()) {
         clear_has_listData();
        _listData.clear();
     }
}

inline bool T_CAN_Mesg::hasListData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< uint8 >& T_CAN_Mesg::getListData () const {
    return _listData;
}

inline ::std::vector< uint8 >& T_CAN_Mesg::getListDataMutable () {
    set_has_listData();
    return _listData;
}

inline void T_CAN_Mesg::setListData (const ::std::vector< uint8 >& listData_) {
    set_has_listData();
    this->_listData = listData_;
}

inline void T_CAN_Mesg::set_has_u8MediaType () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_CAN_Mesg::clear_has_u8MediaType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_CAN_Mesg::set_has_listData () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_CAN_Mesg::clear_has_listData () {
    _has_bits_[0] &= ~ (1u << 1);
}

} // namespace vehicle_main_fi_types

#endif // VEHICLE_MAIN_FI_TYPES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
