#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef VEHICLE_MAIN_FI_H
#define VEHICLE_MAIN_FI_H

#include "asf/cca/CcaTypes.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/VersionCheck.h"
#include "vehicle_main_fi_types.h"
#include "vehicle_main_fi_typesConst.h"
#include <cstring>
#include <vector>

/**
 * CCA Functional Interface 'VEHICLE_MAIN_FI'
 *
 * Fullname: VD Vehicle Data Service, Application Functional Interface
 *
 * Version: $Revision:   1.2  $
 *
 * Author: Ravi Deora
 *
 * Date: $Date:  10.08.2015  $
 *
 * Department:
 *
 * Title: VEHICLE_MAIN_FI
 *
 * <b>Description of 'VEHICLE_MAIN_FI':</b>
 *
 * ..
 */

namespace VEHICLE_MAIN_FI {

static const int SERVICE_ID = 63;

static const int FID_DistanceUnit = 2;

static const int FID_FuelConsumptionUnit = 3;

static const int FID_TemperatureUnit = 4;

static const int FID_Language = 5;

static const int FID_LanguageSyncSource = 6;

static const int FID_MeterLanguageKnowledge = 7;

static const int FID_HandBrake = 4096;

static const int FID_Ignition = 4097;

static const int FID_Speed = 4098;

static const int FID_SpeedLimit = 4099;

static const int FID_ReverseGear = 4100;

static const int FID_SpeedLock = 4101;

static const int FID_DrivingState = 4102;

static const int FID_GlobalVehicleWarningState = 4103;

static const int FID_VehicleStates = 4104;

static const int FID_PartialMute = 4105;

static const int FID_SwivMonAutoOpen = 4106;

static const int FID_DateMode = 4107;

static const int FID_TmMode = 4108;

static const int FID_CamTxt = 4109;

static const int FID_ActCam1 = 4110;

static const int FID_ActCam2 = 4111;

static const int FID_ActCam3 = 4112;

static const int FID_ActCam4 = 4113;

static const int FID_ActCam5 = 4114;

static const int FID_ActCam6 = 4115;

static const int FID_ActCam7 = 4116;

static const int FID_DriverDoorOpen = 4151;

static const int FID_ActCam8 = 4138;

static const int FID_ActCam9 = 4139;

static const int FID_ActCam10 = 4140;

static const int FID_ActCam11 = 4141;

static const int FID_ActCam12 = 4142;

static const int FID_ActCam13 = 4143;

static const int FID_ActCam14 = 4144;

static const int FID_ActCam15 = 4145;

static const int FID_ActCam16 = 4146;

static const int FID_ActCam17 = 4147;

static const int FID_CamSplitQuad = 4117;

static const int FID_MuteDev = 4118;

static const int FID_SysVolt = 4119;

static const int FID_ParkingBreakSwitch = 4120;

static const int FID_RearCamReq = 4121;

static const int FID_VIN = 4122;

static const int FID_TimeDate = 4123;

static const int FID_PrivacyResetRequest = 4124;

static const int FID_PhoneCallCommand = 4125;

static const int FID_VolumeCommand = 4126;

static const int FID_VoiceRecgCommand = 4127;

static const int FID_DeviceInfoSWversion = 4128;

static const int FID_TrackCommand = 4129;

static const int FID_PhonePwrCmd = 4130;

static const int FID_RadioPwrCmd = 4131;

static const int FID_RCNextBtn = 4132;

static const int FID_RCPrevBtn = 4133;

static const int FID_SourceCommand = 4134;

static const int FID_TunerCommand = 4135;

static const int FID_TACommand = 4136;

static const int FID_RDSCommand = 4137;

static const int FID_SMARTVR = 4148;

static const int FID_TotalVehDistDiag = 4149;

static const int FID_VIN_64 = 4150;

static const int FID_CabinMediaSourceCommand = 4160;

static const int FID_CabinMediaVolumeCommand = 4161;

static const int FID_CabinMediaTunerCommand = 4162;

static const int FID_CabinMediaTrackCommand = 4163;

static const int FID_CabinMediaPlaylistCommand = 4164;

static const int FID_NetworkState = 8193;

static const int FID_DistanceTotalizer = 8194;

static const int FID_Mileage = 8195;

static const int FID_AvgFuelEconomy = 8196;

static const int FID_TirePressureSupport = 8197;

static const int FID_TPMSResetSupport = 8198;

static const int FID_TirePressureSetting = 8199;

static const int FID_SetLanguage = 32768;

static const int FID_RequestMeterLanguageSync = 32769;

static const int FID_PhoneBTLinkStatus = 37120;

static const int FID_PhoneBookSyncstatus = 37121;

static const int FID_CallHistorySyncStatus = 37122;

static const int FID_PhoneStatusRoaming = 37123;

static const int FID_CallDuration = 37124;

static const int FID_GSMSignalStrength = 37125;

static const int FID_PhoneAvailableStatus = 37126;

static const int FID_PhoneCallStatus = 37127;

static const int FID_PhoneBatteryLevelStatus = 37128;

static const int FID_PhoneVRAvailable = 37129;

static const int FID_DeviceStatusWifiAvailable = 36865;

static const int FID_DeviceStatusBTStatus = 36866;

static const int FID_DeviceStatusDABAvailStatus = 36867;

static const int FID_DeviceStatusRadioStatus = 36868;

static const int FID_DeviceStatusNavData = 36869;

static const int FID_DeviceStatusUSB1Present = 36870;

static const int FID_DeviceStatusUSB2Present = 36871;

static const int FID_DeviceStatusNaviAvail = 36872;

static const int FID_DeviceStatusUSB1Src = 36873;

static const int FID_DeviceStatusUSB2Src = 36874;

static const int FID_DeviceStatusAMFMAvail = 36875;

static const int FID_DeviceStatusBluetoothAvail = 36876;

static const int FID_Req_DeviceInfo = 36877;

static const int FID_HUS_DM1_Status = 37376;

static const int FID_VehicleNaviLatitude = 37632;

static const int FID_VehicleNaviLongitude = 37633;

static const int FID_MediaStatusAudioSource = 32781;

static const int FID_MediaStatusVolume = 32782;

static const int FID_CabinMediaStatusAudioSource = 32783;

static const int FID_CabinMediaStatusVolume = 32784;

static const int FID_MediaStatusMuteStatus = 32785;

static const int FID_CabinMediaStatusMuteStatus = 32786;

static const int FID_MediaStatusPlayStatus = 32787;

static const int FID_MediaStatusSeekStatus = 32788;

static const int FID_MediaStatusRepeatStatus = 32804;

static const int FID_MediaStatusDABFMStatus = 32805;

static const int FID_MediaStatusTREGStatus = 32806;

static const int FID_MediaStatusRDSStatus = 32807;

static const int FID_MediaStatusTAStatus = 32808;

static const int FID_MediaStatusTPStatus = 32809;

static const int FID_MediaStatusTunerBandStatus = 32810;

static const int FID_MediaStatusTunerPresetStatus = 32811;

static const int FID_MediaStatusMixState = 32812;

static const int FID_MediaStatusPlaylistMode = 32813;

static const int FID_MediaStatusTrackTime = 32814;

static const int FID_MediaStatusCurrTrackNum = 32815;

static const int FID_MediaStatusTREGRTMStatus = 32816;

static const int FID_CabinMediaStatusTunerBand = 32817;

static const int FID_CSMEngineeringData = 32770;

static const int FID_SetOSPAlertsStatus = 33024;

static const int FID_SendMediaInfo = 33025;

static const int FID_SendCallInfo = 33026;

static const int FID_SendPhoneInfo = 33027;

static const int FID_SendXMInfo = 33028;

static const int FID_SendMainlineInfo = 33029;

static const int FID_SendCabinAMediaInfo = 33030;

static const int FID_SendCabinAMainlineInfo = 33031;

static const int FID_SendCabinACallInfo = 33032;

static const int FID_SendCabinAPhoneInfo = 33033;

static const int FID_SendCabinAXMInfo = 33040;

static const int FID_SendNaviCurrentStreetNameInfo = 33041;

static const int FID_SendNaviTurnToStreetNameInfo = 33042;

static const int FID_SendNaviDestinationInfo = 33043;

static const int FID_SendNaviTurnToSymbolsInfo = 33044;

static const int FID_SendNaviLaneGuidanceInfo = 33045;

static const int FID_SendNaviNavigationWarningInfo = 33046;

static const int FID_Cam1ManAct = 32771;

static const int FID_Cam2ManAct = 32772;

static const int FID_Cam3ManAct = 32773;

static const int FID_Cam4ManAct = 32774;

static const int FID_Cam5ManAct = 32775;

static const int FID_Cam6ManAct = 32776;

static const int FID_Cam7ManAct = 32777;

static const int FID_Cam8ManAct = 32778;

static const int FID_Cam9ManAct = 32789;

static const int FID_Cam10ManAct = 32790;

static const int FID_Cam11ManAct = 32791;

static const int FID_Cam12ManAct = 32792;

static const int FID_Cam13ManAct = 32793;

static const int FID_Cam14ManAct = 32800;

static const int FID_Cam15ManAct = 32801;

static const int FID_Cam16ManAct = 32802;

static const int FID_Cam17ManAct = 32803;

static const int FID_PrivacyResetAck = 32779;

static const int FID_DispCamCls = 32780;


ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 1;

static const int VERSION_MINOR = 0;

static const int VERSION_PATCH = 0;

// forward declarations
class DistanceUnitStatus;

class DistanceUnitSet;

class FuelConsumptionUnitStatus;

class FuelConsumptionUnitSet;

class TemperatureUnitStatus;

class TemperatureUnitSet;

class LanguageStatus;

class LanguageSyncSourceStatus;

class LanguageSyncSourceSet;

class MeterLanguageKnowledgeStatus;

class HandBrakeStatus;

class IgnitionStatus;

class SpeedStatus;

class SpeedLimitStatus;

class ReverseGearStatus;

class SpeedLockStatus;

class DrivingStateStatus;

class GlobalVehicleWarningStateStatus;

class VehicleStatesStatus;

class PartialMuteStatus;

class SwivMonAutoOpenStatus;

class DateModeStatus;

class TmModeStatus;

class CamTxtStatus;

class ActCam1Status;

class ActCam2Status;

class ActCam3Status;

class ActCam4Status;

class ActCam5Status;

class ActCam6Status;

class ActCam7Status;

class DriverDoorOpenStatus;

class ActCam8Status;

class ActCam9Status;

class ActCam10Status;

class ActCam11Status;

class ActCam12Status;

class ActCam13Status;

class ActCam14Status;

class ActCam15Status;

class ActCam16Status;

class ActCam17Status;

class CamSplitQuadStatus;

class MuteDevStatus;

class SysVoltStatus;

class ParkingBreakSwitchStatus;

class RearCamReqStatus;

class VINStatus;

class TimeDateStatus;

class PrivacyResetRequestStatus;

class PhoneCallCommandStatus;

class VolumeCommandStatus;

class VoiceRecgCommandStatus;

class DeviceInfoSWversionStatus;

class TrackCommandStatus;

class PhonePwrCmdStatus;

class RadioPwrCmdStatus;

class RCNextBtnStatus;

class RCPrevBtnStatus;

class SourceCommandStatus;

class TunerCommandStatus;

class TACommandStatus;

class RDSCommandStatus;

class SMARTVRStatus;

class TotalVehDistDiagStatus;

class VIN_64Status;

class CabinMediaSourceCommandStatus;

class CabinMediaVolumeCommandStatus;

class CabinMediaTunerCommandStatus;

class CabinMediaTrackCommandStatus;

class CabinMediaPlaylistCommandStatus;

class NetworkStateStatus;

class DistanceTotalizerStatus;

class MileageStatus;

class AvgFuelEconomyStatus;

class TirePressureSupportStatus;

class TPMSResetSupportStatus;

class TirePressureSettingStatus;

class TirePressureSettingSet;

class SetLanguageStart;

class SetLanguageResult;

class RequestMeterLanguageSyncStart;

class RequestMeterLanguageSyncResult;

class PhoneBTLinkStatusStart;

class PhoneBTLinkStatusResult;

class PhoneBookSyncstatusStart;

class PhoneBookSyncstatusResult;

class CallHistorySyncStatusStart;

class CallHistorySyncStatusResult;

class PhoneStatusRoamingStart;

class PhoneStatusRoamingResult;

class CallDurationStart;

class CallDurationResult;

class GSMSignalStrengthStart;

class GSMSignalStrengthResult;

class PhoneAvailableStatusStart;

class PhoneAvailableStatusResult;

class PhoneCallStatusStart;

class PhoneCallStatusResult;

class PhoneBatteryLevelStatusStart;

class PhoneBatteryLevelStatusResult;

class PhoneVRAvailableStart;

class PhoneVRAvailableResult;

class DeviceStatusWifiAvailableStart;

class DeviceStatusWifiAvailableResult;

class DeviceStatusBTStatusStart;

class DeviceStatusBTStatusResult;

class DeviceStatusDABAvailStatusStart;

class DeviceStatusDABAvailStatusResult;

class DeviceStatusRadioStatusStart;

class DeviceStatusRadioStatusResult;

class DeviceStatusNavDataStart;

class DeviceStatusNavDataResult;

class DeviceStatusUSB1PresentStart;

class DeviceStatusUSB1PresentResult;

class DeviceStatusUSB2PresentStart;

class DeviceStatusUSB2PresentResult;

class DeviceStatusNaviAvailStart;

class DeviceStatusNaviAvailResult;

class DeviceStatusUSB1SrcStart;

class DeviceStatusUSB1SrcResult;

class DeviceStatusUSB2SrcStart;

class DeviceStatusUSB2SrcResult;

class DeviceStatusAMFMAvailStart;

class DeviceStatusAMFMAvailResult;

class DeviceStatusBluetoothAvailStart;

class DeviceStatusBluetoothAvailResult;

class Req_DeviceInfoStart;

class Req_DeviceInfoResult;

class HUS_DM1_StatusStart;

class HUS_DM1_StatusResult;

class VehicleNaviLatitudeStart;

class VehicleNaviLatitudeResult;

class VehicleNaviLongitudeStart;

class VehicleNaviLongitudeResult;

class MediaStatusAudioSourceStart;

class MediaStatusAudioSourceResult;

class MediaStatusVolumeStart;

class MediaStatusVolumeResult;

class CabinMediaStatusAudioSourceStart;

class CabinMediaStatusAudioSourceResult;

class CabinMediaStatusVolumeStart;

class CabinMediaStatusVolumeResult;

class MediaStatusMuteStatusStart;

class MediaStatusMuteStatusResult;

class CabinMediaStatusMuteStatusStart;

class CabinMediaStatusMuteStatusResult;

class MediaStatusPlayStatusStart;

class MediaStatusPlayStatusResult;

class MediaStatusSeekStatusStart;

class MediaStatusSeekStatusResult;

class MediaStatusRepeatStatusStart;

class MediaStatusRepeatStatusResult;

class MediaStatusDABFMStatusStart;

class MediaStatusDABFMStatusResult;

class MediaStatusTREGStatusStart;

class MediaStatusTREGStatusResult;

class MediaStatusRDSStatusStart;

class MediaStatusRDSStatusResult;

class MediaStatusTAStatusStart;

class MediaStatusTAStatusResult;

class MediaStatusTPStatusStart;

class MediaStatusTPStatusResult;

class MediaStatusTunerBandStatusStart;

class MediaStatusTunerBandStatusResult;

class MediaStatusTunerPresetStatusStart;

class MediaStatusTunerPresetStatusResult;

class MediaStatusMixStateStart;

class MediaStatusMixStateResult;

class MediaStatusPlaylistModeStart;

class MediaStatusPlaylistModeResult;

class MediaStatusTrackTimeStart;

class MediaStatusTrackTimeResult;

class MediaStatusCurrTrackNumStart;

class MediaStatusCurrTrackNumResult;

class MediaStatusTREGRTMStatusStart;

class MediaStatusTREGRTMStatusResult;

class CabinMediaStatusTunerBandStart;

class CabinMediaStatusTunerBandResult;

class CSMEngineeringDataResult;

class SetOSPAlertsStatusStart;

class SetOSPAlertsStatusResult;

class SendMediaInfoStart;

class SendMediaInfoResult;

class SendCallInfoStart;

class SendCallInfoResult;

class SendPhoneInfoStart;

class SendPhoneInfoResult;

class SendXMInfoStart;

class SendXMInfoResult;

class SendMainlineInfoStart;

class SendMainlineInfoResult;

class SendCabinAMediaInfoStart;

class SendCabinAMediaInfoResult;

class SendCabinAMainlineInfoStart;

class SendCabinAMainlineInfoResult;

class SendCabinACallInfoStart;

class SendCabinACallInfoResult;

class SendCabinAPhoneInfoStart;

class SendCabinAPhoneInfoResult;

class SendCabinAXMInfoStart;

class SendCabinAXMInfoResult;

class SendNaviCurrentStreetNameInfoStart;

class SendNaviCurrentStreetNameInfoResult;

class SendNaviTurnToStreetNameInfoStart;

class SendNaviTurnToStreetNameInfoResult;

class SendNaviDestinationInfoStart;

class SendNaviDestinationInfoResult;

class SendNaviTurnToSymbolsInfoStart;

class SendNaviTurnToSymbolsInfoResult;

class SendNaviLaneGuidanceInfoStart;

class SendNaviLaneGuidanceInfoResult;

class SendNaviNavigationWarningInfoStart;

class SendNaviNavigationWarningInfoResult;

class Cam1ManActStart;

class Cam1ManActResult;

class Cam2ManActStart;

class Cam2ManActResult;

class Cam3ManActStart;

class Cam3ManActResult;

class Cam4ManActStart;

class Cam4ManActResult;

class Cam5ManActStart;

class Cam5ManActResult;

class Cam6ManActStart;

class Cam6ManActResult;

class Cam7ManActStart;

class Cam7ManActResult;

class Cam8ManActStart;

class Cam8ManActResult;

class Cam9ManActStart;

class Cam9ManActResult;

class Cam10ManActStart;

class Cam10ManActResult;

class Cam11ManActStart;

class Cam11ManActResult;

class Cam12ManActStart;

class Cam12ManActResult;

class Cam13ManActStart;

class Cam13ManActResult;

class Cam14ManActStart;

class Cam14ManActResult;

class Cam15ManActStart;

class Cam15ManActResult;

class Cam16ManActStart;

class Cam16ManActResult;

class Cam17ManActStart;

class Cam17ManActResult;

class PrivacyResetAckStart;

class PrivacyResetAckResult;

class DispCamClsStart;

class DispCamClsResult;

// type definitions
/**
 * The get message of the property "DistanceUnit"
 * Distance Unit could be set to Metric (m/km) or Imperial (mile) Standard
 * <p>FUNCID = 0x0002,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DistanceUnitGet;

/**
 * The upreg message of the property "DistanceUnit"
 * Distance Unit could be set to Metric (m/km) or Imperial (mile) Standard
 * <p>FUNCID = 0x0002,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DistanceUnitUpReg;

/**
 * The relUpReg message of the property "DistanceUnit"
 * Distance Unit could be set to Metric (m/km) or Imperial (mile) Standard
 * <p>FUNCID = 0x0002,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DistanceUnitRelUpReg;

/**
 * The error message of 'DistanceUnit'
 */
typedef ::asf::cca::CcaTypes::DefaultError DistanceUnitError;

/**
 * The get message of the property "FuelConsumptionUnit"
 * Fuel Consumption Unit (Shall be only used for Hybrid Electric Vehicles)
 * <p>FUNCID = 0x0003,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FuelConsumptionUnitGet;

/**
 * The upreg message of the property "FuelConsumptionUnit"
 * Fuel Consumption Unit (Shall be only used for Hybrid Electric Vehicles)
 * <p>FUNCID = 0x0003,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FuelConsumptionUnitUpReg;

/**
 * The relUpReg message of the property "FuelConsumptionUnit"
 * Fuel Consumption Unit (Shall be only used for Hybrid Electric Vehicles)
 * <p>FUNCID = 0x0003,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FuelConsumptionUnitRelUpReg;

/**
 * The error message of 'FuelConsumptionUnit'
 */
typedef ::asf::cca::CcaTypes::DefaultError FuelConsumptionUnitError;

/**
 * The get message of the property "TemperatureUnit"
 * Temperature Unit (Centigrade or Fahrenheit)
 * <p>FUNCID = 0x0004,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TemperatureUnitGet;

/**
 * The upreg message of the property "TemperatureUnit"
 * Temperature Unit (Centigrade or Fahrenheit)
 * <p>FUNCID = 0x0004,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TemperatureUnitUpReg;

/**
 * The relUpReg message of the property "TemperatureUnit"
 * Temperature Unit (Centigrade or Fahrenheit)
 * <p>FUNCID = 0x0004,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TemperatureUnitRelUpReg;

/**
 * The error message of 'TemperatureUnit'
 */
typedef ::asf::cca::CcaTypes::DefaultError TemperatureUnitError;

/**
 * The get message of the property "Language"
 * Current System Language Update for all the applications
 * <p>FUNCID = 0x0005,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage LanguageGet;

/**
 * The upreg message of the property "Language"
 * Current System Language Update for all the applications
 * <p>FUNCID = 0x0005,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage LanguageUpReg;

/**
 * The relUpReg message of the property "Language"
 * Current System Language Update for all the applications
 * <p>FUNCID = 0x0005,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage LanguageRelUpReg;

/**
 * The error message of 'Language'
 */
typedef ::asf::cca::CcaTypes::DefaultError LanguageError;

/**
 * The get message of the property "LanguageSyncSource"
 * Sets and Notifies the Source which the System Language is in Sync with.
 * <p>FUNCID = 0x0006,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage LanguageSyncSourceGet;

/**
 * The upreg message of the property "LanguageSyncSource"
 * Sets and Notifies the Source which the System Language is in Sync with.
 * <p>FUNCID = 0x0006,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage LanguageSyncSourceUpReg;

/**
 * The relUpReg message of the property "LanguageSyncSource"
 * Sets and Notifies the Source which the System Language is in Sync with.
 * <p>FUNCID = 0x0006,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage LanguageSyncSourceRelUpReg;

/**
 * The error message of 'LanguageSyncSource'
 */
typedef ::asf::cca::CcaTypes::DefaultError LanguageSyncSourceError;

/**
 * The get message of the property "MeterLanguageKnowledge"
 * The reply received from Meter about the Requested Language only for Renault Scope 2.1
 * <p>FUNCID = 0x0007,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MeterLanguageKnowledgeGet;

/**
 * The upreg message of the property "MeterLanguageKnowledge"
 * The reply received from Meter about the Requested Language only for Renault Scope 2.1
 * <p>FUNCID = 0x0007,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MeterLanguageKnowledgeUpReg;

/**
 * The relUpReg message of the property "MeterLanguageKnowledge"
 * The reply received from Meter about the Requested Language only for Renault Scope 2.1
 * <p>FUNCID = 0x0007,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MeterLanguageKnowledgeRelUpReg;

/**
 * The error message of 'MeterLanguageKnowledge'
 */
typedef ::asf::cca::CcaTypes::DefaultError MeterLanguageKnowledgeError;

/**
 * The get message of the property "HandBrake"
 * HandBrake Switch Status received from V-CAN
 * <p>FUNCID = 0x1000,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage HandBrakeGet;

/**
 * The upreg message of the property "HandBrake"
 * HandBrake Switch Status received from V-CAN
 * <p>FUNCID = 0x1000,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage HandBrakeUpReg;

/**
 * The relUpReg message of the property "HandBrake"
 * HandBrake Switch Status received from V-CAN
 * <p>FUNCID = 0x1000,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage HandBrakeRelUpReg;

/**
 * The error message of 'HandBrake'
 */
typedef ::asf::cca::CcaTypes::DefaultError HandBrakeError;

/**
 * The get message of the property "Ignition"
 * Ignition Status received from SPM
 * <p>FUNCID = 0x1001,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage IgnitionGet;

/**
 * The upreg message of the property "Ignition"
 * Ignition Status received from SPM
 * <p>FUNCID = 0x1001,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage IgnitionUpReg;

/**
 * The relUpReg message of the property "Ignition"
 * Ignition Status received from SPM
 * <p>FUNCID = 0x1001,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage IgnitionRelUpReg;

/**
 * The error message of 'Ignition'
 */
typedef ::asf::cca::CcaTypes::DefaultError IgnitionError;

/**
 * The get message of the property "Speed"
 * Vehicle Speed Data and Status received from V-CAN
 * <p>FUNCID = 0x1002,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SpeedGet;

/**
 * The upreg message of the property "Speed"
 * Vehicle Speed Data and Status received from V-CAN
 * <p>FUNCID = 0x1002,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SpeedUpReg;

/**
 * The relUpReg message of the property "Speed"
 * Vehicle Speed Data and Status received from V-CAN
 * <p>FUNCID = 0x1002,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SpeedRelUpReg;

/**
 * The error message of 'Speed'
 */
typedef ::asf::cca::CcaTypes::DefaultError SpeedError;

/**
 * The get message of the property "SpeedLimit"
 * Speed Limit received over V-CAN from ISA unit
 * <p>FUNCID = 0x1003,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SpeedLimitGet;

/**
 * The upreg message of the property "SpeedLimit"
 * Speed Limit received over V-CAN from ISA unit
 * <p>FUNCID = 0x1003,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SpeedLimitUpReg;

/**
 * The relUpReg message of the property "SpeedLimit"
 * Speed Limit received over V-CAN from ISA unit
 * <p>FUNCID = 0x1003,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SpeedLimitRelUpReg;

/**
 * The error message of 'SpeedLimit'
 */
typedef ::asf::cca::CcaTypes::DefaultError SpeedLimitError;

/**
 * The get message of the property "ReverseGear"
 * ReverseGear Status read from the GPIO pin
 * <p>FUNCID = 0x1004,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ReverseGearGet;

/**
 * The upreg message of the property "ReverseGear"
 * ReverseGear Status read from the GPIO pin
 * <p>FUNCID = 0x1004,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ReverseGearUpReg;

/**
 * The relUpReg message of the property "ReverseGear"
 * ReverseGear Status read from the GPIO pin
 * <p>FUNCID = 0x1004,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ReverseGearRelUpReg;

/**
 * The error message of 'ReverseGear'
 */
typedef ::asf::cca::CcaTypes::DefaultError ReverseGearError;

/**
 * The get message of the property "SpeedLock"
 * SpeedLock status to the clients
 * <p>FUNCID = 0x1005,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SpeedLockGet;

/**
 * The upreg message of the property "SpeedLock"
 * SpeedLock status to the clients
 * <p>FUNCID = 0x1005,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SpeedLockUpReg;

/**
 * The relUpReg message of the property "SpeedLock"
 * SpeedLock status to the clients
 * <p>FUNCID = 0x1005,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SpeedLockRelUpReg;

/**
 * The error message of 'SpeedLock'
 */
typedef ::asf::cca::CcaTypes::DefaultError SpeedLockError;

/**
 * The get message of the property "DrivingState"
 * Driving status update to the clients
 * <p>FUNCID = 0x1006,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DrivingStateGet;

/**
 * The upreg message of the property "DrivingState"
 * Driving status update to the clients
 * <p>FUNCID = 0x1006,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DrivingStateUpReg;

/**
 * The relUpReg message of the property "DrivingState"
 * Driving status update to the clients
 * <p>FUNCID = 0x1006,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DrivingStateRelUpReg;

/**
 * The error message of 'DrivingState'
 */
typedef ::asf::cca::CcaTypes::DefaultError DrivingStateError;

/**
 * The get message of the property "GlobalVehicleWarningState"
 * GlobalVehicleWarning Status update to the clients
 * <p>FUNCID = 0x1007,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GlobalVehicleWarningStateGet;

/**
 * The upreg message of the property "GlobalVehicleWarningState"
 * GlobalVehicleWarning Status update to the clients
 * <p>FUNCID = 0x1007,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GlobalVehicleWarningStateUpReg;

/**
 * The relUpReg message of the property "GlobalVehicleWarningState"
 * GlobalVehicleWarning Status update to the clients
 * <p>FUNCID = 0x1007,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GlobalVehicleWarningStateRelUpReg;

/**
 * The error message of 'GlobalVehicleWarningState'
 */
typedef ::asf::cca::CcaTypes::DefaultError GlobalVehicleWarningStateError;

/**
 * The get message of the property "VehicleStates"
 * VehicleState status update to the clients
 * <p>FUNCID = 0x1008,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VehicleStatesGet;

/**
 * The upreg message of the property "VehicleStates"
 * VehicleState status update to the clients
 * <p>FUNCID = 0x1008,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VehicleStatesUpReg;

/**
 * The relUpReg message of the property "VehicleStates"
 * VehicleState status update to the clients
 * <p>FUNCID = 0x1008,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VehicleStatesRelUpReg;

/**
 * The error message of 'VehicleStates'
 */
typedef ::asf::cca::CcaTypes::DefaultError VehicleStatesError;

/**
 * The get message of the property "PartialMute"
 * PartialMute Status update to the clients
 * <p>FUNCID = 0x1009,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PartialMuteGet;

/**
 * The upreg message of the property "PartialMute"
 * PartialMute Status update to the clients
 * <p>FUNCID = 0x1009,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PartialMuteUpReg;

/**
 * The relUpReg message of the property "PartialMute"
 * PartialMute Status update to the clients
 * <p>FUNCID = 0x1009,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PartialMuteRelUpReg;

/**
 * The error message of 'PartialMute'
 */
typedef ::asf::cca::CcaTypes::DefaultError PartialMuteError;

/**
 * The get message of the property "SwivMonAutoOpen"
 * Door close/open Status
 * <p>FUNCID = 0x100A,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SwivMonAutoOpenGet;

/**
 * The upreg message of the property "SwivMonAutoOpen"
 * Door close/open Status
 * <p>FUNCID = 0x100A,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SwivMonAutoOpenUpReg;

/**
 * The relUpReg message of the property "SwivMonAutoOpen"
 * Door close/open Status
 * <p>FUNCID = 0x100A,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SwivMonAutoOpenRelUpReg;

/**
 * The error message of 'SwivMonAutoOpen'
 */
typedef ::asf::cca::CcaTypes::DefaultError SwivMonAutoOpenError;

/**
 * The get message of the property "DateMode"
 * Display Date Mode Current value
 * <p>FUNCID = 0x100B,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DateModeGet;

/**
 * The upreg message of the property "DateMode"
 * Display Date Mode Current value
 * <p>FUNCID = 0x100B,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DateModeUpReg;

/**
 * The relUpReg message of the property "DateMode"
 * Display Date Mode Current value
 * <p>FUNCID = 0x100B,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DateModeRelUpReg;

/**
 * The error message of 'DateMode'
 */
typedef ::asf::cca::CcaTypes::DefaultError DateModeError;

/**
 * The get message of the property "TmMode"
 * Display Time Mode Current value
 * <p>FUNCID = 0x100C,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TmModeGet;

/**
 * The upreg message of the property "TmMode"
 * Display Time Mode Current value
 * <p>FUNCID = 0x100C,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TmModeUpReg;

/**
 * The relUpReg message of the property "TmMode"
 * Display Time Mode Current value
 * <p>FUNCID = 0x100C,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TmModeRelUpReg;

/**
 * The error message of 'TmMode'
 */
typedef ::asf::cca::CcaTypes::DefaultError TmModeError;

/**
 * The get message of the property "CamTxt"
 * CamTxt value update to clients
 * <p>FUNCID = 0x100D,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CamTxtGet;

/**
 * The upreg message of the property "CamTxt"
 * CamTxt value update to clients
 * <p>FUNCID = 0x100D,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CamTxtUpReg;

/**
 * The relUpReg message of the property "CamTxt"
 * CamTxt value update to clients
 * <p>FUNCID = 0x100D,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CamTxtRelUpReg;

/**
 * The error message of 'CamTxt'
 */
typedef ::asf::cca::CcaTypes::DefaultError CamTxtError;

/**
 * The get message of the property "ActCam1"
 * Activate Cam1 requested state
 * <p>FUNCID = 0x100E,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActCam1Get;

/**
 * The upreg message of the property "ActCam1"
 * Activate Cam1 requested state
 * <p>FUNCID = 0x100E,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActCam1UpReg;

/**
 * The relUpReg message of the property "ActCam1"
 * Activate Cam1 requested state
 * <p>FUNCID = 0x100E,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActCam1RelUpReg;

/**
 * The error message of 'ActCam1'
 */
typedef ::asf::cca::CcaTypes::DefaultError ActCam1Error;

/**
 * The get message of the property "ActCam2"
 * Activate Cam2 requested state
 * <p>FUNCID = 0x100F,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActCam2Get;

/**
 * The upreg message of the property "ActCam2"
 * Activate Cam2 requested state
 * <p>FUNCID = 0x100F,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActCam2UpReg;

/**
 * The relUpReg message of the property "ActCam2"
 * Activate Cam2 requested state
 * <p>FUNCID = 0x100F,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActCam2RelUpReg;

/**
 * The error message of 'ActCam2'
 */
typedef ::asf::cca::CcaTypes::DefaultError ActCam2Error;

/**
 * The get message of the property "ActCam3"
 * Activate Cam3 requested state
 * <p>FUNCID = 0x1010,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActCam3Get;

/**
 * The upreg message of the property "ActCam3"
 * Activate Cam3 requested state
 * <p>FUNCID = 0x1010,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActCam3UpReg;

/**
 * The relUpReg message of the property "ActCam3"
 * Activate Cam3 requested state
 * <p>FUNCID = 0x1010,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActCam3RelUpReg;

/**
 * The error message of 'ActCam3'
 */
typedef ::asf::cca::CcaTypes::DefaultError ActCam3Error;

/**
 * The get message of the property "ActCam4"
 * Activate Cam4 requested state
 * <p>FUNCID = 0x1011,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActCam4Get;

/**
 * The upreg message of the property "ActCam4"
 * Activate Cam4 requested state
 * <p>FUNCID = 0x1011,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActCam4UpReg;

/**
 * The relUpReg message of the property "ActCam4"
 * Activate Cam4 requested state
 * <p>FUNCID = 0x1011,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActCam4RelUpReg;

/**
 * The error message of 'ActCam4'
 */
typedef ::asf::cca::CcaTypes::DefaultError ActCam4Error;

/**
 * The get message of the property "ActCam5"
 * Activate Cam5 requested state
 * <p>FUNCID = 0x1012,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActCam5Get;

/**
 * The upreg message of the property "ActCam5"
 * Activate Cam5 requested state
 * <p>FUNCID = 0x1012,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActCam5UpReg;

/**
 * The relUpReg message of the property "ActCam5"
 * Activate Cam5 requested state
 * <p>FUNCID = 0x1012,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActCam5RelUpReg;

/**
 * The error message of 'ActCam5'
 */
typedef ::asf::cca::CcaTypes::DefaultError ActCam5Error;

/**
 * The get message of the property "ActCam6"
 * Activate Cam6 requested state
 * <p>FUNCID = 0x1013,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActCam6Get;

/**
 * The upreg message of the property "ActCam6"
 * Activate Cam6 requested state
 * <p>FUNCID = 0x1013,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActCam6UpReg;

/**
 * The relUpReg message of the property "ActCam6"
 * Activate Cam6 requested state
 * <p>FUNCID = 0x1013,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActCam6RelUpReg;

/**
 * The error message of 'ActCam6'
 */
typedef ::asf::cca::CcaTypes::DefaultError ActCam6Error;

/**
 * The get message of the property "ActCam7"
 * Activate Cam7 requested state
 * <p>FUNCID = 0x1014,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActCam7Get;

/**
 * The upreg message of the property "ActCam7"
 * Activate Cam7 requested state
 * <p>FUNCID = 0x1014,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActCam7UpReg;

/**
 * The relUpReg message of the property "ActCam7"
 * Activate Cam7 requested state
 * <p>FUNCID = 0x1014,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActCam7RelUpReg;

/**
 * The error message of 'ActCam7'
 */
typedef ::asf::cca::CcaTypes::DefaultError ActCam7Error;

/**
 * The get message of the property "DriverDoorOpen"
 * Driver Door close/open Status
 * <p>FUNCID = 0x1037,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DriverDoorOpenGet;

/**
 * The upreg message of the property "DriverDoorOpen"
 * Driver Door close/open Status
 * <p>FUNCID = 0x1037,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DriverDoorOpenUpReg;

/**
 * The relUpReg message of the property "DriverDoorOpen"
 * Driver Door close/open Status
 * <p>FUNCID = 0x1037,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DriverDoorOpenRelUpReg;

/**
 * The error message of 'DriverDoorOpen'
 */
typedef ::asf::cca::CcaTypes::DefaultError DriverDoorOpenError;

/**
 * The get message of the property "ActCam8"
 * Activate Cam8 requested state
 * <p>FUNCID = 0x102A,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActCam8Get;

/**
 * The upreg message of the property "ActCam8"
 * Activate Cam8 requested state
 * <p>FUNCID = 0x102A,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActCam8UpReg;

/**
 * The relUpReg message of the property "ActCam8"
 * Activate Cam8 requested state
 * <p>FUNCID = 0x102A,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActCam8RelUpReg;

/**
 * The error message of 'ActCam8'
 */
typedef ::asf::cca::CcaTypes::DefaultError ActCam8Error;

/**
 * The get message of the property "ActCam9"
 * Activate Cam9 requested state
 * <p>FUNCID = 0x102B,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActCam9Get;

/**
 * The upreg message of the property "ActCam9"
 * Activate Cam9 requested state
 * <p>FUNCID = 0x102B,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActCam9UpReg;

/**
 * The relUpReg message of the property "ActCam9"
 * Activate Cam9 requested state
 * <p>FUNCID = 0x102B,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActCam9RelUpReg;

/**
 * The error message of 'ActCam9'
 */
typedef ::asf::cca::CcaTypes::DefaultError ActCam9Error;

/**
 * The get message of the property "ActCam10"
 * Activate Cam10 requested state
 * <p>FUNCID = 0x102C,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActCam10Get;

/**
 * The upreg message of the property "ActCam10"
 * Activate Cam10 requested state
 * <p>FUNCID = 0x102C,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActCam10UpReg;

/**
 * The relUpReg message of the property "ActCam10"
 * Activate Cam10 requested state
 * <p>FUNCID = 0x102C,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActCam10RelUpReg;

/**
 * The error message of 'ActCam10'
 */
typedef ::asf::cca::CcaTypes::DefaultError ActCam10Error;

/**
 * The get message of the property "ActCam11"
 * Activate Cam11 requested state
 * <p>FUNCID = 0x102D,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActCam11Get;

/**
 * The upreg message of the property "ActCam11"
 * Activate Cam11 requested state
 * <p>FUNCID = 0x102D,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActCam11UpReg;

/**
 * The relUpReg message of the property "ActCam11"
 * Activate Cam11 requested state
 * <p>FUNCID = 0x102D,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActCam11RelUpReg;

/**
 * The error message of 'ActCam11'
 */
typedef ::asf::cca::CcaTypes::DefaultError ActCam11Error;

/**
 * The get message of the property "ActCam12"
 * Activate Cam12 requested state
 * <p>FUNCID = 0x102E,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActCam12Get;

/**
 * The upreg message of the property "ActCam12"
 * Activate Cam12 requested state
 * <p>FUNCID = 0x102E,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActCam12UpReg;

/**
 * The relUpReg message of the property "ActCam12"
 * Activate Cam12 requested state
 * <p>FUNCID = 0x102E,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActCam12RelUpReg;

/**
 * The error message of 'ActCam12'
 */
typedef ::asf::cca::CcaTypes::DefaultError ActCam12Error;

/**
 * The get message of the property "ActCam13"
 * Activate Cam13 requested state
 * <p>FUNCID = 0x102F,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActCam13Get;

/**
 * The upreg message of the property "ActCam13"
 * Activate Cam13 requested state
 * <p>FUNCID = 0x102F,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActCam13UpReg;

/**
 * The relUpReg message of the property "ActCam13"
 * Activate Cam13 requested state
 * <p>FUNCID = 0x102F,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActCam13RelUpReg;

/**
 * The error message of 'ActCam13'
 */
typedef ::asf::cca::CcaTypes::DefaultError ActCam13Error;

/**
 * The get message of the property "ActCam14"
 * Activate Cam14 requested state
 * <p>FUNCID = 0x1030,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActCam14Get;

/**
 * The upreg message of the property "ActCam14"
 * Activate Cam14 requested state
 * <p>FUNCID = 0x1030,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActCam14UpReg;

/**
 * The relUpReg message of the property "ActCam14"
 * Activate Cam14 requested state
 * <p>FUNCID = 0x1030,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActCam14RelUpReg;

/**
 * The error message of 'ActCam14'
 */
typedef ::asf::cca::CcaTypes::DefaultError ActCam14Error;

/**
 * The get message of the property "ActCam15"
 * Activate Cam15 requested state
 * <p>FUNCID = 0x1031,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActCam15Get;

/**
 * The upreg message of the property "ActCam15"
 * Activate Cam15 requested state
 * <p>FUNCID = 0x1031,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActCam15UpReg;

/**
 * The relUpReg message of the property "ActCam15"
 * Activate Cam15 requested state
 * <p>FUNCID = 0x1031,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActCam15RelUpReg;

/**
 * The error message of 'ActCam15'
 */
typedef ::asf::cca::CcaTypes::DefaultError ActCam15Error;

/**
 * The get message of the property "ActCam16"
 * Activate Cam16 requested state
 * <p>FUNCID = 0x1032,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActCam16Get;

/**
 * The upreg message of the property "ActCam16"
 * Activate Cam16 requested state
 * <p>FUNCID = 0x1032,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActCam16UpReg;

/**
 * The relUpReg message of the property "ActCam16"
 * Activate Cam16 requested state
 * <p>FUNCID = 0x1032,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActCam16RelUpReg;

/**
 * The error message of 'ActCam16'
 */
typedef ::asf::cca::CcaTypes::DefaultError ActCam16Error;

/**
 * The get message of the property "ActCam17"
 * Activate Cam17 requested state
 * <p>FUNCID = 0x1033,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActCam17Get;

/**
 * The upreg message of the property "ActCam17"
 * Activate Cam17 requested state
 * <p>FUNCID = 0x1033,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActCam17UpReg;

/**
 * The relUpReg message of the property "ActCam17"
 * Activate Cam17 requested state
 * <p>FUNCID = 0x1033,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActCam17RelUpReg;

/**
 * The error message of 'ActCam17'
 */
typedef ::asf::cca::CcaTypes::DefaultError ActCam17Error;

/**
 * The get message of the property "CamSplitQuad"
 * CAM Split Quad Current Status
 * <p>FUNCID = 0x1015,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CamSplitQuadGet;

/**
 * The upreg message of the property "CamSplitQuad"
 * CAM Split Quad Current Status
 * <p>FUNCID = 0x1015,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CamSplitQuadUpReg;

/**
 * The relUpReg message of the property "CamSplitQuad"
 * CAM Split Quad Current Status
 * <p>FUNCID = 0x1015,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CamSplitQuadRelUpReg;

/**
 * The error message of 'CamSplitQuad'
 */
typedef ::asf::cca::CcaTypes::DefaultError CamSplitQuadError;

/**
 * The get message of the property "MuteDev"
 * MuteDev Status update to the clients
 * <p>FUNCID = 0x1016,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MuteDevGet;

/**
 * The upreg message of the property "MuteDev"
 * MuteDev Status update to the clients
 * <p>FUNCID = 0x1016,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MuteDevUpReg;

/**
 * The relUpReg message of the property "MuteDev"
 * MuteDev Status update to the clients
 * <p>FUNCID = 0x1016,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MuteDevRelUpReg;

/**
 * The error message of 'MuteDev'
 */
typedef ::asf::cca::CcaTypes::DefaultError MuteDevError;

/**
 * The get message of the property "SysVolt"
 * System voltage Status update to the clients
 * <p>FUNCID = 0x1017,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SysVoltGet;

/**
 * The upreg message of the property "SysVolt"
 * System voltage Status update to the clients
 * <p>FUNCID = 0x1017,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SysVoltUpReg;

/**
 * The relUpReg message of the property "SysVolt"
 * System voltage Status update to the clients
 * <p>FUNCID = 0x1017,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SysVoltRelUpReg;

/**
 * The error message of 'SysVolt'
 */
typedef ::asf::cca::CcaTypes::DefaultError SysVoltError;

/**
 * The get message of the property "ParkingBreakSwitch"
 * Parking Break Switch Status update to the clients
 * <p>FUNCID = 0x1018,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ParkingBreakSwitchGet;

/**
 * The upreg message of the property "ParkingBreakSwitch"
 * Parking Break Switch Status update to the clients
 * <p>FUNCID = 0x1018,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ParkingBreakSwitchUpReg;

/**
 * The relUpReg message of the property "ParkingBreakSwitch"
 * Parking Break Switch Status update to the clients
 * <p>FUNCID = 0x1018,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ParkingBreakSwitchRelUpReg;

/**
 * The error message of 'ParkingBreakSwitch'
 */
typedef ::asf::cca::CcaTypes::DefaultError ParkingBreakSwitchError;

/**
 * The get message of the property "RearCamReq"
 * RearCam Request Status update to the clients
 * <p>FUNCID = 0x1019,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RearCamReqGet;

/**
 * The upreg message of the property "RearCamReq"
 * RearCam Request Status update to the clients
 * <p>FUNCID = 0x1019,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RearCamReqUpReg;

/**
 * The relUpReg message of the property "RearCamReq"
 * RearCam Request Status update to the clients
 * <p>FUNCID = 0x1019,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RearCamReqRelUpReg;

/**
 * The error message of 'RearCamReq'
 */
typedef ::asf::cca::CcaTypes::DefaultError RearCamReqError;

/**
 * The get message of the property "VIN"
 * Display Vehicle ID
 * <p>FUNCID = 0x101A,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VINGet;

/**
 * The upreg message of the property "VIN"
 * Display Vehicle ID
 * <p>FUNCID = 0x101A,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VINUpReg;

/**
 * The relUpReg message of the property "VIN"
 * Display Vehicle ID
 * <p>FUNCID = 0x101A,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VINRelUpReg;

/**
 * The error message of 'VIN'
 */
typedef ::asf::cca::CcaTypes::DefaultError VINError;

/**
 * The get message of the property "TimeDate"
 * Display Current Time date
 * <p>FUNCID = 0x101B,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TimeDateGet;

/**
 * The upreg message of the property "TimeDate"
 * Display Current Time date
 * <p>FUNCID = 0x101B,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TimeDateUpReg;

/**
 * The relUpReg message of the property "TimeDate"
 * Display Current Time date
 * <p>FUNCID = 0x101B,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TimeDateRelUpReg;

/**
 * The error message of 'TimeDate'
 */
typedef ::asf::cca::CcaTypes::DefaultError TimeDateError;

/**
 * The get message of the property "PrivacyResetRequest"
 * Interface providing Privacy Reset Request. Receiver HMI(System Settings)
 * <p>FUNCID = 0x101C,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PrivacyResetRequestGet;

/**
 * The upreg message of the property "PrivacyResetRequest"
 * Interface providing Privacy Reset Request. Receiver HMI(System Settings)
 * <p>FUNCID = 0x101C,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PrivacyResetRequestUpReg;

/**
 * The relUpReg message of the property "PrivacyResetRequest"
 * Interface providing Privacy Reset Request. Receiver HMI(System Settings)
 * <p>FUNCID = 0x101C,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PrivacyResetRequestRelUpReg;

/**
 * The error message of 'PrivacyResetRequest'
 */
typedef ::asf::cca::CcaTypes::DefaultError PrivacyResetRequestError;

/**
 * The get message of the property "PhoneCallCommand"
 * Sends Phone Call Command signal values from CAN
 * <p>FUNCID = 0x101D,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PhoneCallCommandGet;

/**
 * The upreg message of the property "PhoneCallCommand"
 * Sends Phone Call Command signal values from CAN
 * <p>FUNCID = 0x101D,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PhoneCallCommandUpReg;

/**
 * The relUpReg message of the property "PhoneCallCommand"
 * Sends Phone Call Command signal values from CAN
 * <p>FUNCID = 0x101D,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PhoneCallCommandRelUpReg;

/**
 * The error message of 'PhoneCallCommand'
 */
typedef ::asf::cca::CcaTypes::DefaultError PhoneCallCommandError;

/**
 * The get message of the property "VolumeCommand"
 * Sends volume Command signal values from CAN
 * <p>FUNCID = 0x101E,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VolumeCommandGet;

/**
 * The upreg message of the property "VolumeCommand"
 * Sends volume Command signal values from CAN
 * <p>FUNCID = 0x101E,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VolumeCommandUpReg;

/**
 * The relUpReg message of the property "VolumeCommand"
 * Sends volume Command signal values from CAN
 * <p>FUNCID = 0x101E,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VolumeCommandRelUpReg;

/**
 * The error message of 'VolumeCommand'
 */
typedef ::asf::cca::CcaTypes::DefaultError VolumeCommandError;

/**
 * The get message of the property "VoiceRecgCommand"
 * Sends Voice Recognition Command signal values from CAN
 * <p>FUNCID = 0x101F,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VoiceRecgCommandGet;

/**
 * The upreg message of the property "VoiceRecgCommand"
 * Sends Voice Recognition Command signal values from CAN
 * <p>FUNCID = 0x101F,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VoiceRecgCommandUpReg;

/**
 * The relUpReg message of the property "VoiceRecgCommand"
 * Sends Voice Recognition Command signal values from CAN
 * <p>FUNCID = 0x101F,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VoiceRecgCommandRelUpReg;

/**
 * The error message of 'VoiceRecgCommand'
 */
typedef ::asf::cca::CcaTypes::DefaultError VoiceRecgCommandError;

/**
 * The get message of the property "DeviceInfoSWversion"
 * Sends SW Version values from CAN
 * <p>FUNCID = 0x1020,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DeviceInfoSWversionGet;

/**
 * The upreg message of the property "DeviceInfoSWversion"
 * Sends SW Version values from CAN
 * <p>FUNCID = 0x1020,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DeviceInfoSWversionUpReg;

/**
 * The relUpReg message of the property "DeviceInfoSWversion"
 * Sends SW Version values from CAN
 * <p>FUNCID = 0x1020,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DeviceInfoSWversionRelUpReg;

/**
 * The error message of 'DeviceInfoSWversion'
 */
typedef ::asf::cca::CcaTypes::DefaultError DeviceInfoSWversionError;

/**
 * The get message of the property "TrackCommand"
 * Sends track command from media command msg values from CAN
 * <p>FUNCID = 0x1021,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TrackCommandGet;

/**
 * The upreg message of the property "TrackCommand"
 * Sends track command from media command msg values from CAN
 * <p>FUNCID = 0x1021,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TrackCommandUpReg;

/**
 * The relUpReg message of the property "TrackCommand"
 * Sends track command from media command msg values from CAN
 * <p>FUNCID = 0x1021,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TrackCommandRelUpReg;

/**
 * The error message of 'TrackCommand'
 */
typedef ::asf::cca::CcaTypes::DefaultError TrackCommandError;

/**
 * The get message of the property "PhonePwrCmd"
 * Sends phone power command from media command msg values from CAN
 * <p>FUNCID = 0x1022,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PhonePwrCmdGet;

/**
 * The upreg message of the property "PhonePwrCmd"
 * Sends phone power command from media command msg values from CAN
 * <p>FUNCID = 0x1022,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PhonePwrCmdUpReg;

/**
 * The relUpReg message of the property "PhonePwrCmd"
 * Sends phone power command from media command msg values from CAN
 * <p>FUNCID = 0x1022,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PhonePwrCmdRelUpReg;

/**
 * The error message of 'PhonePwrCmd'
 */
typedef ::asf::cca::CcaTypes::DefaultError PhonePwrCmdError;

/**
 * The get message of the property "RadioPwrCmd"
 * Sends Radio power command from media command msg values from CAN
 * <p>FUNCID = 0x1023,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RadioPwrCmdGet;

/**
 * The upreg message of the property "RadioPwrCmd"
 * Sends Radio power command from media command msg values from CAN
 * <p>FUNCID = 0x1023,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RadioPwrCmdUpReg;

/**
 * The relUpReg message of the property "RadioPwrCmd"
 * Sends Radio power command from media command msg values from CAN
 * <p>FUNCID = 0x1023,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RadioPwrCmdRelUpReg;

/**
 * The error message of 'RadioPwrCmd'
 */
typedef ::asf::cca::CcaTypes::DefaultError RadioPwrCmdError;

/**
 * The get message of the property "RCNextBtn"
 * Sends Next Btn Status from remote control msg values from CAN
 * <p>FUNCID = 0x1024,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RCNextBtnGet;

/**
 * The upreg message of the property "RCNextBtn"
 * Sends Next Btn Status from remote control msg values from CAN
 * <p>FUNCID = 0x1024,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RCNextBtnUpReg;

/**
 * The relUpReg message of the property "RCNextBtn"
 * Sends Next Btn Status from remote control msg values from CAN
 * <p>FUNCID = 0x1024,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RCNextBtnRelUpReg;

/**
 * The error message of 'RCNextBtn'
 */
typedef ::asf::cca::CcaTypes::DefaultError RCNextBtnError;

/**
 * The get message of the property "RCPrevBtn"
 * Sends Prev Btn Status from remote control msg values from CAN
 * <p>FUNCID = 0x1025,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RCPrevBtnGet;

/**
 * The upreg message of the property "RCPrevBtn"
 * Sends Prev Btn Status from remote control msg values from CAN
 * <p>FUNCID = 0x1025,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RCPrevBtnUpReg;

/**
 * The relUpReg message of the property "RCPrevBtn"
 * Sends Prev Btn Status from remote control msg values from CAN
 * <p>FUNCID = 0x1025,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RCPrevBtnRelUpReg;

/**
 * The error message of 'RCPrevBtn'
 */
typedef ::asf::cca::CcaTypes::DefaultError RCPrevBtnError;

/**
 * The get message of the property "SourceCommand"
 * Sends Source Cmd values from  Media Command msg values from CAN
 * <p>FUNCID = 0x1026,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SourceCommandGet;

/**
 * The upreg message of the property "SourceCommand"
 * Sends Source Cmd values from  Media Command msg values from CAN
 * <p>FUNCID = 0x1026,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SourceCommandUpReg;

/**
 * The relUpReg message of the property "SourceCommand"
 * Sends Source Cmd values from  Media Command msg values from CAN
 * <p>FUNCID = 0x1026,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SourceCommandRelUpReg;

/**
 * The error message of 'SourceCommand'
 */
typedef ::asf::cca::CcaTypes::DefaultError SourceCommandError;

/**
 * The get message of the property "TunerCommand"
 * Sends Tuner Cmd values from  Media Command msg values from CAN
 * <p>FUNCID = 0x1027,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TunerCommandGet;

/**
 * The upreg message of the property "TunerCommand"
 * Sends Tuner Cmd values from  Media Command msg values from CAN
 * <p>FUNCID = 0x1027,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TunerCommandUpReg;

/**
 * The relUpReg message of the property "TunerCommand"
 * Sends Tuner Cmd values from  Media Command msg values from CAN
 * <p>FUNCID = 0x1027,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TunerCommandRelUpReg;

/**
 * The error message of 'TunerCommand'
 */
typedef ::asf::cca::CcaTypes::DefaultError TunerCommandError;

/**
 * The get message of the property "TACommand"
 * Sends TA Cmd values from  Media Command msg values from CAN
 * <p>FUNCID = 0x1028,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TACommandGet;

/**
 * The upreg message of the property "TACommand"
 * Sends TA Cmd values from  Media Command msg values from CAN
 * <p>FUNCID = 0x1028,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TACommandUpReg;

/**
 * The relUpReg message of the property "TACommand"
 * Sends TA Cmd values from  Media Command msg values from CAN
 * <p>FUNCID = 0x1028,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TACommandRelUpReg;

/**
 * The error message of 'TACommand'
 */
typedef ::asf::cca::CcaTypes::DefaultError TACommandError;

/**
 * The get message of the property "RDSCommand"
 * Sends TA Cmd values from  Media Command msg values from CAN
 * <p>FUNCID = 0x1029,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RDSCommandGet;

/**
 * The upreg message of the property "RDSCommand"
 * Sends TA Cmd values from  Media Command msg values from CAN
 * <p>FUNCID = 0x1029,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RDSCommandUpReg;

/**
 * The relUpReg message of the property "RDSCommand"
 * Sends TA Cmd values from  Media Command msg values from CAN
 * <p>FUNCID = 0x1029,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RDSCommandRelUpReg;

/**
 * The error message of 'RDSCommand'
 */
typedef ::asf::cca::CcaTypes::DefaultError RDSCommandError;

/**
 * The get message of the property "SMARTVR"
 * Sends Vr values from  Media Command msg values from CAN
 * <p>FUNCID = 0x1034,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SMARTVRGet;

/**
 * The upreg message of the property "SMARTVR"
 * Sends Vr values from  Media Command msg values from CAN
 * <p>FUNCID = 0x1034,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SMARTVRUpReg;

/**
 * The relUpReg message of the property "SMARTVR"
 * Sends Vr values from  Media Command msg values from CAN
 * <p>FUNCID = 0x1034,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SMARTVRRelUpReg;

/**
 * The error message of 'SMARTVR'
 */
typedef ::asf::cca::CcaTypes::DefaultError SMARTVRError;

/**
 * The get message of the property "TotalVehDistDiag"
 * Sends total distance info from CAN
 * <p>FUNCID = 0x1035,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TotalVehDistDiagGet;

/**
 * The upreg message of the property "TotalVehDistDiag"
 * Sends total distance info from CAN
 * <p>FUNCID = 0x1035,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TotalVehDistDiagUpReg;

/**
 * The relUpReg message of the property "TotalVehDistDiag"
 * Sends total distance info from CAN
 * <p>FUNCID = 0x1035,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TotalVehDistDiagRelUpReg;

/**
 * The error message of 'TotalVehDistDiag'
 */
typedef ::asf::cca::CcaTypes::DefaultError TotalVehDistDiagError;

/**
 * The get message of the property "VIN_64"
 * Sends VIN info from CAN
 * <p>FUNCID = 0x1036,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VIN_64Get;

/**
 * The upreg message of the property "VIN_64"
 * Sends VIN info from CAN
 * <p>FUNCID = 0x1036,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VIN_64UpReg;

/**
 * The relUpReg message of the property "VIN_64"
 * Sends VIN info from CAN
 * <p>FUNCID = 0x1036,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VIN_64RelUpReg;

/**
 * The error message of 'VIN_64'
 */
typedef ::asf::cca::CcaTypes::DefaultError VIN_64Error;

/**
 * The get message of the property "CabinMediaSourceCommand"
 * Sends Source cmd values from cabin media cmd message  from CAN
 * Sends Source cmd values from cabin media cmd message  from CAN
 * values:
 * 01-AMFMTuner
 * 02-CD
 * 03-USB1
 * 04-USB2
 * 05-BT1(audio)
 * 06-BT2(audio)
 * 09-Aux(rear)
 * 0A-Aux(front)
 * 0B-SDcard1
 * 0C-SDCard2
 * 0E-XM
 * 10-DABAvail
 * 1C-Next src
 * 1D-Prev Src
 * 3E-error
 * 3F- SNA
 * <p>FUNCID = 0x1040,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CabinMediaSourceCommandGet;

/**
 * The upreg message of the property "CabinMediaSourceCommand"
 * Sends Source cmd values from cabin media cmd message  from CAN
 * Sends Source cmd values from cabin media cmd message  from CAN
 * values:
 * 01-AMFMTuner
 * 02-CD
 * 03-USB1
 * 04-USB2
 * 05-BT1(audio)
 * 06-BT2(audio)
 * 09-Aux(rear)
 * 0A-Aux(front)
 * 0B-SDcard1
 * 0C-SDCard2
 * 0E-XM
 * 10-DABAvail
 * 1C-Next src
 * 1D-Prev Src
 * 3E-error
 * 3F- SNA
 * <p>FUNCID = 0x1040,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CabinMediaSourceCommandUpReg;

/**
 * The relUpReg message of the property "CabinMediaSourceCommand"
 * Sends Source cmd values from cabin media cmd message  from CAN
 * Sends Source cmd values from cabin media cmd message  from CAN
 * values:
 * 01-AMFMTuner
 * 02-CD
 * 03-USB1
 * 04-USB2
 * 05-BT1(audio)
 * 06-BT2(audio)
 * 09-Aux(rear)
 * 0A-Aux(front)
 * 0B-SDcard1
 * 0C-SDCard2
 * 0E-XM
 * 10-DABAvail
 * 1C-Next src
 * 1D-Prev Src
 * 3E-error
 * 3F- SNA
 * <p>FUNCID = 0x1040,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CabinMediaSourceCommandRelUpReg;

/**
 * The error message of 'CabinMediaSourceCommand'
 */
typedef ::asf::cca::CcaTypes::DefaultError CabinMediaSourceCommandError;

/**
 * The get message of the property "CabinMediaVolumeCommand"
 * Sends Volume cmd values from cabin media cmd message  from CAN
 * 01 -Demute
 * 02- Mute
 * 03- Volume Up
 * 04- Volume Down
 * 0E - Error
 * 0f - SNA
 * <p>FUNCID = 0x1041,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CabinMediaVolumeCommandGet;

/**
 * The upreg message of the property "CabinMediaVolumeCommand"
 * Sends Volume cmd values from cabin media cmd message  from CAN
 * 01 -Demute
 * 02- Mute
 * 03- Volume Up
 * 04- Volume Down
 * 0E - Error
 * 0f - SNA
 * <p>FUNCID = 0x1041,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CabinMediaVolumeCommandUpReg;

/**
 * The relUpReg message of the property "CabinMediaVolumeCommand"
 * Sends Volume cmd values from cabin media cmd message  from CAN
 * 01 -Demute
 * 02- Mute
 * 03- Volume Up
 * 04- Volume Down
 * 0E - Error
 * 0f - SNA
 * <p>FUNCID = 0x1041,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CabinMediaVolumeCommandRelUpReg;

/**
 * The error message of 'CabinMediaVolumeCommand'
 */
typedef ::asf::cca::CcaTypes::DefaultError CabinMediaVolumeCommandError;

/**
 * The get message of the property "CabinMediaTunerCommand"
 * Sends Tuner values from cabin media cmd message  from CAN
 * 01- Auto seek up
 * 02- Auto Seek Down
 * 03- Manual Step Up
 * 04- Manual Step Down
 * 05- Manual Seek Up
 * 06- Manual Seek Down
 * 07- Preset up
 * 08- Preset Down
 * 0E-Error
 * 0F- SNA
 * <p>FUNCID = 0x1042,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CabinMediaTunerCommandGet;

/**
 * The upreg message of the property "CabinMediaTunerCommand"
 * Sends Tuner values from cabin media cmd message  from CAN
 * 01- Auto seek up
 * 02- Auto Seek Down
 * 03- Manual Step Up
 * 04- Manual Step Down
 * 05- Manual Seek Up
 * 06- Manual Seek Down
 * 07- Preset up
 * 08- Preset Down
 * 0E-Error
 * 0F- SNA
 * <p>FUNCID = 0x1042,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CabinMediaTunerCommandUpReg;

/**
 * The relUpReg message of the property "CabinMediaTunerCommand"
 * Sends Tuner values from cabin media cmd message  from CAN
 * 01- Auto seek up
 * 02- Auto Seek Down
 * 03- Manual Step Up
 * 04- Manual Step Down
 * 05- Manual Seek Up
 * 06- Manual Seek Down
 * 07- Preset up
 * 08- Preset Down
 * 0E-Error
 * 0F- SNA
 * <p>FUNCID = 0x1042,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CabinMediaTunerCommandRelUpReg;

/**
 * The error message of 'CabinMediaTunerCommand'
 */
typedef ::asf::cca::CcaTypes::DefaultError CabinMediaTunerCommandError;

/**
 * The get message of the property "CabinMediaTrackCommand"
 * Sends Track values from cabin media cmd message  from CAN
 * 01- Scan
 * 02- Play
 * 03- Next TrackCommand
 * 04- Previous TrackCommand
 * 05- Fast Forward
 * 06- Fast Backward
 * 07- Next Folder
 * 08- Previous Folder
 * 09- Repeat/ Random off
 * 0A- Repear Track
 * 0B- Repeat All
 * 0C- Repeat Folder
 * 0D- Random All
 * 0E- Random Folder
 * 0F- Dont Care
 * <p>FUNCID = 0x1043,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CabinMediaTrackCommandGet;

/**
 * The upreg message of the property "CabinMediaTrackCommand"
 * Sends Track values from cabin media cmd message  from CAN
 * 01- Scan
 * 02- Play
 * 03- Next TrackCommand
 * 04- Previous TrackCommand
 * 05- Fast Forward
 * 06- Fast Backward
 * 07- Next Folder
 * 08- Previous Folder
 * 09- Repeat/ Random off
 * 0A- Repear Track
 * 0B- Repeat All
 * 0C- Repeat Folder
 * 0D- Random All
 * 0E- Random Folder
 * 0F- Dont Care
 * <p>FUNCID = 0x1043,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CabinMediaTrackCommandUpReg;

/**
 * The relUpReg message of the property "CabinMediaTrackCommand"
 * Sends Track values from cabin media cmd message  from CAN
 * 01- Scan
 * 02- Play
 * 03- Next TrackCommand
 * 04- Previous TrackCommand
 * 05- Fast Forward
 * 06- Fast Backward
 * 07- Next Folder
 * 08- Previous Folder
 * 09- Repeat/ Random off
 * 0A- Repear Track
 * 0B- Repeat All
 * 0C- Repeat Folder
 * 0D- Random All
 * 0E- Random Folder
 * 0F- Dont Care
 * <p>FUNCID = 0x1043,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CabinMediaTrackCommandRelUpReg;

/**
 * The error message of 'CabinMediaTrackCommand'
 */
typedef ::asf::cca::CcaTypes::DefaultError CabinMediaTrackCommandError;

/**
 * The get message of the property "CabinMediaPlaylistCommand"
 * Sends Playlist values from cabin media cmd message  from CAN
 * 01- Switch on
 * 02- Switch off
 * <p>FUNCID = 0x1044,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CabinMediaPlaylistCommandGet;

/**
 * The upreg message of the property "CabinMediaPlaylistCommand"
 * Sends Playlist values from cabin media cmd message  from CAN
 * 01- Switch on
 * 02- Switch off
 * <p>FUNCID = 0x1044,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CabinMediaPlaylistCommandUpReg;

/**
 * The relUpReg message of the property "CabinMediaPlaylistCommand"
 * Sends Playlist values from cabin media cmd message  from CAN
 * 01- Switch on
 * 02- Switch off
 * <p>FUNCID = 0x1044,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CabinMediaPlaylistCommandRelUpReg;

/**
 * The error message of 'CabinMediaPlaylistCommand'
 */
typedef ::asf::cca::CcaTypes::DefaultError CabinMediaPlaylistCommandError;

/**
 * The get message of the property "NetworkState"
 * V-CAN and M-CAN bus and ECU communication states
 * <p>FUNCID = 0x1001,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 * <p></p>
 * <p>Three types of failures may be detected by the RNAIVI while connected to the network.</p>
 * <p>Mute (Transmission failure): The node does not succeed in transmitting its own frames</p>
 * <p>Absent (Reception failure): The node no longer receives frames from other monitored nodes</p>
 * <p>BusOff: The CAN controller is in BusOff mode and the node is temporarily isolated from the network</p>
 * <p>The diagnosis results of the failure types for each monitored bus and each monitored ECU (node) will be checked through
 * the diagnosis services. The results consist of an "Current_fault" status and "Confirmed_fault" status. They will be transmitted
 * to the diagnostic tool by a CAN diagnosis byte structure already provided with the property "NetworkState".</p>
 * <p>For RNAIVI the diagnosis byte has following content:</p>
 * <p>1) For Bus Off diagnosis:</p>
 * <p>0x00 = Bus On</p>
 * <p>0x80 = Bus Off - Current_fault status</p>
 * <p>0xC0 = Bus Off - Confirmed_fault status</p>
 * <p>0xFF = Fault (monitoring of the bus) is masked or diagnosis has not been made</p>
 * <p>2) For Transmission diagnosis:</p>
 * <p>0x00 = not muted</p>
 * <p>0x80 = muted - Current_fault status</p>
 * <p>0xC0 = muted - Confirmed_fault status</p>
 * <p>0xFF = Fault is masked or diagnosis has not been made</p>
 * <p>The Bus is muted if we are not able to send a message.</p>
 * <p>2) For Reception diagnosis:</p>
 * <p>0x00 = ECU (node) is present</p>
 * <p>0x80 = absent - Current_fault status</p>
 * <p>0xC0 = absent - Confirmed_fault status</p>
 * <p>0xFF = Fault (monitoring of the ECU) is masked or diagnosis has not been made</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage NetworkStateGet;

/**
 * The upreg message of the property "NetworkState"
 * V-CAN and M-CAN bus and ECU communication states
 * <p>FUNCID = 0x1001,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 * <p></p>
 * <p>Three types of failures may be detected by the RNAIVI while connected to the network.</p>
 * <p>Mute (Transmission failure): The node does not succeed in transmitting its own frames</p>
 * <p>Absent (Reception failure): The node no longer receives frames from other monitored nodes</p>
 * <p>BusOff: The CAN controller is in BusOff mode and the node is temporarily isolated from the network</p>
 * <p>The diagnosis results of the failure types for each monitored bus and each monitored ECU (node) will be checked through
 * the diagnosis services. The results consist of an "Current_fault" status and "Confirmed_fault" status. They will be transmitted
 * to the diagnostic tool by a CAN diagnosis byte structure already provided with the property "NetworkState".</p>
 * <p>For RNAIVI the diagnosis byte has following content:</p>
 * <p>1) For Bus Off diagnosis:</p>
 * <p>0x00 = Bus On</p>
 * <p>0x80 = Bus Off - Current_fault status</p>
 * <p>0xC0 = Bus Off - Confirmed_fault status</p>
 * <p>0xFF = Fault (monitoring of the bus) is masked or diagnosis has not been made</p>
 * <p>2) For Transmission diagnosis:</p>
 * <p>0x00 = not muted</p>
 * <p>0x80 = muted - Current_fault status</p>
 * <p>0xC0 = muted - Confirmed_fault status</p>
 * <p>0xFF = Fault is masked or diagnosis has not been made</p>
 * <p>The Bus is muted if we are not able to send a message.</p>
 * <p>2) For Reception diagnosis:</p>
 * <p>0x00 = ECU (node) is present</p>
 * <p>0x80 = absent - Current_fault status</p>
 * <p>0xC0 = absent - Confirmed_fault status</p>
 * <p>0xFF = Fault (monitoring of the ECU) is masked or diagnosis has not been made</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage NetworkStateUpReg;

/**
 * The relUpReg message of the property "NetworkState"
 * V-CAN and M-CAN bus and ECU communication states
 * <p>FUNCID = 0x1001,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 * <p></p>
 * <p>Three types of failures may be detected by the RNAIVI while connected to the network.</p>
 * <p>Mute (Transmission failure): The node does not succeed in transmitting its own frames</p>
 * <p>Absent (Reception failure): The node no longer receives frames from other monitored nodes</p>
 * <p>BusOff: The CAN controller is in BusOff mode and the node is temporarily isolated from the network</p>
 * <p>The diagnosis results of the failure types for each monitored bus and each monitored ECU (node) will be checked through
 * the diagnosis services. The results consist of an "Current_fault" status and "Confirmed_fault" status. They will be transmitted
 * to the diagnostic tool by a CAN diagnosis byte structure already provided with the property "NetworkState".</p>
 * <p>For RNAIVI the diagnosis byte has following content:</p>
 * <p>1) For Bus Off diagnosis:</p>
 * <p>0x00 = Bus On</p>
 * <p>0x80 = Bus Off - Current_fault status</p>
 * <p>0xC0 = Bus Off - Confirmed_fault status</p>
 * <p>0xFF = Fault (monitoring of the bus) is masked or diagnosis has not been made</p>
 * <p>2) For Transmission diagnosis:</p>
 * <p>0x00 = not muted</p>
 * <p>0x80 = muted - Current_fault status</p>
 * <p>0xC0 = muted - Confirmed_fault status</p>
 * <p>0xFF = Fault is masked or diagnosis has not been made</p>
 * <p>The Bus is muted if we are not able to send a message.</p>
 * <p>2) For Reception diagnosis:</p>
 * <p>0x00 = ECU (node) is present</p>
 * <p>0x80 = absent - Current_fault status</p>
 * <p>0xC0 = absent - Confirmed_fault status</p>
 * <p>0xFF = Fault (monitoring of the ECU) is masked or diagnosis has not been made</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage NetworkStateRelUpReg;

/**
 * The error message of 'NetworkState'
 */
typedef ::asf::cca::CcaTypes::DefaultError NetworkStateError;

/**
 * The get message of the property "DistanceTotalizer"
 * DistanceTotalizer Status received from V-CAN
 * <p>FUNCID = 0x1002,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DistanceTotalizerGet;

/**
 * The upreg message of the property "DistanceTotalizer"
 * DistanceTotalizer Status received from V-CAN
 * <p>FUNCID = 0x1002,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DistanceTotalizerUpReg;

/**
 * The relUpReg message of the property "DistanceTotalizer"
 * DistanceTotalizer Status received from V-CAN
 * <p>FUNCID = 0x1002,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DistanceTotalizerRelUpReg;

/**
 * The error message of 'DistanceTotalizer'
 */
typedef ::asf::cca::CcaTypes::DefaultError DistanceTotalizerError;

/**
 * The get message of the property "Mileage"
 * Calculated Mileage(Distance travelled) data in meters
 * <p>FUNCID = 0x1003,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MileageGet;

/**
 * The upreg message of the property "Mileage"
 * Calculated Mileage(Distance travelled) data in meters
 * <p>FUNCID = 0x1003,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MileageUpReg;

/**
 * The relUpReg message of the property "Mileage"
 * Calculated Mileage(Distance travelled) data in meters
 * <p>FUNCID = 0x1003,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MileageRelUpReg;

/**
 * The error message of 'Mileage'
 */
typedef ::asf::cca::CcaTypes::DefaultError MileageError;

/**
 * The get message of the property "AvgFuelEconomy"
 * AvgFuelEconomy CAN data
 * <p>FUNCID = 0x1004,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AvgFuelEconomyGet;

/**
 * The upreg message of the property "AvgFuelEconomy"
 * AvgFuelEconomy CAN data
 * <p>FUNCID = 0x1004,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AvgFuelEconomyUpReg;

/**
 * The relUpReg message of the property "AvgFuelEconomy"
 * AvgFuelEconomy CAN data
 * <p>FUNCID = 0x1004,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AvgFuelEconomyRelUpReg;

/**
 * The error message of 'AvgFuelEconomy'
 */
typedef ::asf::cca::CcaTypes::DefaultError AvgFuelEconomyError;

/**
 * The get message of the property "TirePressureSupport"
 * Recommended Tire Pressure Support CAN Data
 * <p>FUNCID = 0x2005,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TirePressureSupportGet;

/**
 * The upreg message of the property "TirePressureSupport"
 * Recommended Tire Pressure Support CAN Data
 * <p>FUNCID = 0x2005,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TirePressureSupportUpReg;

/**
 * The relUpReg message of the property "TirePressureSupport"
 * Recommended Tire Pressure Support CAN Data
 * <p>FUNCID = 0x2005,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TirePressureSupportRelUpReg;

/**
 * The error message of 'TirePressureSupport'
 */
typedef ::asf::cca::CcaTypes::DefaultError TirePressureSupportError;

/**
 * The get message of the property "TPMSResetSupport"
 * TPMS Reset Support CAN Data
 * <p>FUNCID = 0x2006,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TPMSResetSupportGet;

/**
 * The upreg message of the property "TPMSResetSupport"
 * TPMS Reset Support CAN Data
 * <p>FUNCID = 0x2006,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TPMSResetSupportUpReg;

/**
 * The relUpReg message of the property "TPMSResetSupport"
 * TPMS Reset Support CAN Data
 * <p>FUNCID = 0x2006,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TPMSResetSupportRelUpReg;

/**
 * The error message of 'TPMSResetSupport'
 */
typedef ::asf::cca::CcaTypes::DefaultError TPMSResetSupportError;

/**
 * The get message of the property "TirePressureSetting"
 * Used to set tire pressure for front and rear tyres
 * <p>FUNCID = 0x2007,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TirePressureSettingGet;

/**
 * The upreg message of the property "TirePressureSetting"
 * Used to set tire pressure for front and rear tyres
 * <p>FUNCID = 0x2007,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TirePressureSettingUpReg;

/**
 * The relUpReg message of the property "TirePressureSetting"
 * Used to set tire pressure for front and rear tyres
 * <p>FUNCID = 0x2007,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TirePressureSettingRelUpReg;

/**
 * The error message of 'TirePressureSetting'
 */
typedef ::asf::cca::CcaTypes::DefaultError TirePressureSettingError;

/**
 * The abort error message of the method "SetLanguage"
 * This method should be called to set new current language from a particular source
 */
typedef ::asf::cca::CcaTypes::DefaultError SetLanguageAbortError;

/**
 * The error message of 'SetLanguage'
 */
typedef ::asf::cca::CcaTypes::DefaultError SetLanguageError;

/**
 * The abort error message of the method "RequestMeterLanguageSync"
 * This method should be used when Meter sync is requested by the user.
 * This will result in CAN Tx to Meter "MeterLanguageSyncMenu"
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestMeterLanguageSyncAbortError;

/**
 * The error message of 'RequestMeterLanguageSync'
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestMeterLanguageSyncError;

/**
 * The abort error message of the method "PhoneBTLinkStatus"
 * <p>CAN message to send the Phone BT  status  through CAN message PHONE status message</p>
 * <p>ID: 0x18FF114C</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError PhoneBTLinkStatusAbortError;

/**
 * The error message of 'PhoneBTLinkStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError PhoneBTLinkStatusError;

/**
 * The abort error message of the method "PhoneBookSyncstatus"
 * <p>CAN message to send the Phone book sync status  through CAN message PHONE status message</p>
 * <p>ID: 0x18FF114C</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError PhoneBookSyncstatusAbortError;

/**
 * The error message of 'PhoneBookSyncstatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError PhoneBookSyncstatusError;

/**
 * The abort error message of the method "CallHistorySyncStatus"
 * <p>CAN message to send the Phone book sync status  through CAN message PHONE status message</p>
 * <p>ID: 0x18FF114C</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError CallHistorySyncStatusAbortError;

/**
 * The error message of 'CallHistorySyncStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError CallHistorySyncStatusError;

/**
 * The abort error message of the method "PhoneStatusRoaming"
 * <p>CAN message to send the roaming status  through CAN message PHONE status message</p>
 * <p>ID: 0x18FF114C</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError PhoneStatusRoamingAbortError;

/**
 * The error message of 'PhoneStatusRoaming'
 */
typedef ::asf::cca::CcaTypes::DefaultError PhoneStatusRoamingError;

/**
 * The abort error message of the method "CallDuration"
 * <p>CAN message to send the call duration value  through CAN message PHONE status message</p>
 * <p>ID: 0x18FF114C</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError CallDurationAbortError;

/**
 * The error message of 'CallDuration'
 */
typedef ::asf::cca::CcaTypes::DefaultError CallDurationError;

/**
 * The abort error message of the method "GSMSignalStrength"
 * <p>CAN message to send the GSM Signal strength status through CAN message PHONE status message</p>
 * <p>ID: 0x18FF114C</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError GSMSignalStrengthAbortError;

/**
 * The error message of 'GSMSignalStrength'
 */
typedef ::asf::cca::CcaTypes::DefaultError GSMSignalStrengthError;

/**
 * The abort error message of the method "PhoneAvailableStatus"
 * <p>CAN message to send the Phone Availble status through CAN message PHONE status message</p>
 * <p>ID: 0x18FF114C</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError PhoneAvailableStatusAbortError;

/**
 * The error message of 'PhoneAvailableStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError PhoneAvailableStatusError;

/**
 * The abort error message of the method "PhoneCallStatus"
 * <p>CAN message to send the Phone call status through CAN message PHONE status message</p>
 * <p>ID: 0x18FF114C</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError PhoneCallStatusAbortError;

/**
 * The error message of 'PhoneCallStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError PhoneCallStatusError;

/**
 * The abort error message of the method "PhoneBatteryLevelStatus"
 * <p>CAN message to send the Phone Battery level status through CAN message PHONE status message</p>
 * <p>ID: 0x18FF114C</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError PhoneBatteryLevelStatusAbortError;

/**
 * The error message of 'PhoneBatteryLevelStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError PhoneBatteryLevelStatusError;

/**
 * The abort error message of the method "PhoneVRAvailable"
 * <p>CAN message to send the phone vr available status through CAN message PHONE status message</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError PhoneVRAvailableAbortError;

/**
 * The error message of 'PhoneVRAvailable'
 */
typedef ::asf::cca::CcaTypes::DefaultError PhoneVRAvailableError;

/**
 * The abort error message of the method "DeviceStatusWifiAvailable"
 * <p>CAN message to send the Wifi status  through CAN message Device status message</p>
 * <p>ID: 0x18FF114C</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError DeviceStatusWifiAvailableAbortError;

/**
 * The error message of 'DeviceStatusWifiAvailable'
 */
typedef ::asf::cca::CcaTypes::DefaultError DeviceStatusWifiAvailableError;

/**
 * The abort error message of the method "DeviceStatusBTStatus"
 * <p>CAN message to send the BT status  through CAN message Device status message</p>
 * <p>ID: 0x18FF114C</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError DeviceStatusBTStatusAbortError;

/**
 * The error message of 'DeviceStatusBTStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError DeviceStatusBTStatusError;

/**
 * The abort error message of the method "DeviceStatusDABAvailStatus"
 * <p>CAN message to send the DABAvail status  through CAN message Device status message</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError DeviceStatusDABAvailStatusAbortError;

/**
 * The error message of 'DeviceStatusDABAvailStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError DeviceStatusDABAvailStatusError;

/**
 * The abort error message of the method "DeviceStatusRadioStatus"
 * <p>CAN message to send the RadioStatus status  through CAN message Device status message</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError DeviceStatusRadioStatusAbortError;

/**
 * The error message of 'DeviceStatusRadioStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError DeviceStatusRadioStatusError;

/**
 * The abort error message of the method "DeviceStatusNavData"
 * <p>CAN message to send the DeviceStatusNavData status  through CAN message Device status message</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError DeviceStatusNavDataAbortError;

/**
 * The error message of 'DeviceStatusNavData'
 */
typedef ::asf::cca::CcaTypes::DefaultError DeviceStatusNavDataError;

/**
 * The abort error message of the method "DeviceStatusUSB1Present"
 * <p>CAN message to send the DeviceStatusUSB1Present status  through CAN message Device status message</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError DeviceStatusUSB1PresentAbortError;

/**
 * The error message of 'DeviceStatusUSB1Present'
 */
typedef ::asf::cca::CcaTypes::DefaultError DeviceStatusUSB1PresentError;

/**
 * The abort error message of the method "DeviceStatusUSB2Present"
 * <p>CAN message to send the DeviceStatusUSB2Present status  through CAN message Device status message</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError DeviceStatusUSB2PresentAbortError;

/**
 * The error message of 'DeviceStatusUSB2Present'
 */
typedef ::asf::cca::CcaTypes::DefaultError DeviceStatusUSB2PresentError;

/**
 * The abort error message of the method "DeviceStatusNaviAvail"
 * <p>CAN message to send the DeviceStatusNaviAvail status  through CAN message Device status message</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError DeviceStatusNaviAvailAbortError;

/**
 * The error message of 'DeviceStatusNaviAvail'
 */
typedef ::asf::cca::CcaTypes::DefaultError DeviceStatusNaviAvailError;

/**
 * The abort error message of the method "DeviceStatusUSB1Src"
 * <p>CAN message to send the DeviceStatusSourceUSB1 status  through CAN message Device status message</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError DeviceStatusUSB1SrcAbortError;

/**
 * The error message of 'DeviceStatusUSB1Src'
 */
typedef ::asf::cca::CcaTypes::DefaultError DeviceStatusUSB1SrcError;

/**
 * The abort error message of the method "DeviceStatusUSB2Src"
 * <p>CAN message to send the DeviceStatusSourceUSB2 status  through CAN message Device status message</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError DeviceStatusUSB2SrcAbortError;

/**
 * The error message of 'DeviceStatusUSB2Src'
 */
typedef ::asf::cca::CcaTypes::DefaultError DeviceStatusUSB2SrcError;

/**
 * The abort error message of the method "DeviceStatusAMFMAvail"
 * <p>CAN message to send the AMFMAvail status  through CAN message Device status message</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError DeviceStatusAMFMAvailAbortError;

/**
 * The error message of 'DeviceStatusAMFMAvail'
 */
typedef ::asf::cca::CcaTypes::DefaultError DeviceStatusAMFMAvailError;

/**
 * The abort error message of the method "DeviceStatusBluetoothAvail"
 * <p>CAN message to send the Bluetooth Avail status  through CAN message Device status message.</p>
 * <p>Value Descriptor : On-0x01, Off-0x00</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError DeviceStatusBluetoothAvailAbortError;

/**
 * The error message of 'DeviceStatusBluetoothAvail'
 */
typedef ::asf::cca::CcaTypes::DefaultError DeviceStatusBluetoothAvailError;

/**
 * The abort error message of the method "Req_DeviceInfo"
 * <p>CAN message to send the request for device info through CAN message Req_DeviceInformation message</p>
 * <p>Value Descriptors : Request= 0x01, No Request=0x00</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError Req_DeviceInfoAbortError;

/**
 * The error message of 'Req_DeviceInfo'
 */
typedef ::asf::cca::CcaTypes::DefaultError Req_DeviceInfoError;

/**
 * The abort error message of the method "HUS_DM1_Status"
 * <p>CAN message to send the DM1Status  through CAN message</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError HUS_DM1_StatusAbortError;

/**
 * The error message of 'HUS_DM1_Status'
 */
typedef ::asf::cca::CcaTypes::DefaultError HUS_DM1_StatusError;

/**
 * The abort error message of the method "VehicleNaviLatitude"
 * <p>CAN message to send the Latitude value  through CAN message</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError VehicleNaviLatitudeAbortError;

/**
 * The error message of 'VehicleNaviLatitude'
 */
typedef ::asf::cca::CcaTypes::DefaultError VehicleNaviLatitudeError;

/**
 * The abort error message of the method "VehicleNaviLongitude"
 * <p>CAN message to send the Longitude value  through CAN message</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError VehicleNaviLongitudeAbortError;

/**
 * The error message of 'VehicleNaviLongitude'
 */
typedef ::asf::cca::CcaTypes::DefaultError VehicleNaviLongitudeError;

/**
 * The abort error message of the method "MediaStatusAudioSource"
 * <p>CAN message to send the Audio Source through CAN message Media_status1</p>
 * <p>ID: 0x18FF124C</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError MediaStatusAudioSourceAbortError;

/**
 * The error message of 'MediaStatusAudioSource'
 */
typedef ::asf::cca::CcaTypes::DefaultError MediaStatusAudioSourceError;

/**
 * The abort error message of the method "MediaStatusVolume"
 * <p>CAN message to send the volume status through CAN message Media_status1</p>
 * <p>ID: 0x18FF124C</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError MediaStatusVolumeAbortError;

/**
 * The error message of 'MediaStatusVolume'
 */
typedef ::asf::cca::CcaTypes::DefaultError MediaStatusVolumeError;

/**
 * The abort error message of the method "CabinMediaStatusAudioSource"
 * <p>CAN message to send the Audio Source status through CAN message CabinMedia_Status</p>
 * <p>ID: 0x18FF154C</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError CabinMediaStatusAudioSourceAbortError;

/**
 * The error message of 'CabinMediaStatusAudioSource'
 */
typedef ::asf::cca::CcaTypes::DefaultError CabinMediaStatusAudioSourceError;

/**
 * The abort error message of the method "CabinMediaStatusVolume"
 * <p>CAN message to send the volume status through CAN message CabinMedia_Status</p>
 * <p>ID: 0x18FF154C</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError CabinMediaStatusVolumeAbortError;

/**
 * The error message of 'CabinMediaStatusVolume'
 */
typedef ::asf::cca::CcaTypes::DefaultError CabinMediaStatusVolumeError;

/**
 * The abort error message of the method "MediaStatusMuteStatus"
 * <p>CAN message to send the Mute status through CAN message CabinMedia_Status</p>
 * <p>ID: 0x18FF124C</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError MediaStatusMuteStatusAbortError;

/**
 * The error message of 'MediaStatusMuteStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError MediaStatusMuteStatusError;

/**
 * The abort error message of the method "CabinMediaStatusMuteStatus"
 * <p>CAN message to send the Mute status through CAN message CabinMedia_Status</p>
 * <p>ID: 0x18FF154C</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError CabinMediaStatusMuteStatusAbortError;

/**
 * The error message of 'CabinMediaStatusMuteStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError CabinMediaStatusMuteStatusError;

/**
 * The abort error message of the method "MediaStatusPlayStatus"
 * <p>CAN message to send the Play status through CAN message</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError MediaStatusPlayStatusAbortError;

/**
 * The error message of 'MediaStatusPlayStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError MediaStatusPlayStatusError;

/**
 * The abort error message of the method "MediaStatusSeekStatus"
 * <p>CAN message to send the Seek status through CAN message</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError MediaStatusSeekStatusAbortError;

/**
 * The error message of 'MediaStatusSeekStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError MediaStatusSeekStatusError;

/**
 * The abort error message of the method "MediaStatusRepeatStatus"
 * <p>CAN message to send the Repeat status through CAN message</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError MediaStatusRepeatStatusAbortError;

/**
 * The error message of 'MediaStatusRepeatStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError MediaStatusRepeatStatusError;

/**
 * The abort error message of the method "MediaStatusDABFMStatus"
 * <p>CAN message to send the DABFM status through CAN message</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError MediaStatusDABFMStatusAbortError;

/**
 * The error message of 'MediaStatusDABFMStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError MediaStatusDABFMStatusError;

/**
 * The abort error message of the method "MediaStatusTREGStatus"
 * <p>CAN message to send the TREG status through CAN message</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError MediaStatusTREGStatusAbortError;

/**
 * The error message of 'MediaStatusTREGStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError MediaStatusTREGStatusError;

/**
 * The abort error message of the method "MediaStatusRDSStatus"
 * <p>CAN message to send the RDS status through CAN message</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError MediaStatusRDSStatusAbortError;

/**
 * The error message of 'MediaStatusRDSStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError MediaStatusRDSStatusError;

/**
 * The abort error message of the method "MediaStatusTAStatus"
 * <p>CAN message to send the TA status through CAN message</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError MediaStatusTAStatusAbortError;

/**
 * The error message of 'MediaStatusTAStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError MediaStatusTAStatusError;

/**
 * The abort error message of the method "MediaStatusTPStatus"
 * <p>CAN message to send the TP status through CAN message</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError MediaStatusTPStatusAbortError;

/**
 * The error message of 'MediaStatusTPStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError MediaStatusTPStatusError;

/**
 * The abort error message of the method "MediaStatusTunerBandStatus"
 * <p>CAN message to send the TunerBand status through CAN message</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError MediaStatusTunerBandStatusAbortError;

/**
 * The error message of 'MediaStatusTunerBandStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError MediaStatusTunerBandStatusError;

/**
 * The abort error message of the method "MediaStatusTunerPresetStatus"
 * <p>CAN message to send the TunerPresetStation status through CAN message</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError MediaStatusTunerPresetStatusAbortError;

/**
 * The error message of 'MediaStatusTunerPresetStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError MediaStatusTunerPresetStatusError;

/**
 * The abort error message of the method "MediaStatusMixState"
 * <p>CAN message to send the TunerPresetStation status through CAN message</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError MediaStatusMixStateAbortError;

/**
 * The error message of 'MediaStatusMixState'
 */
typedef ::asf::cca::CcaTypes::DefaultError MediaStatusMixStateError;

/**
 * The abort error message of the method "MediaStatusPlaylistMode"
 * <p>CAN message to send the TunerPresetStation status through CAN message</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError MediaStatusPlaylistModeAbortError;

/**
 * The error message of 'MediaStatusPlaylistMode'
 */
typedef ::asf::cca::CcaTypes::DefaultError MediaStatusPlaylistModeError;

/**
 * The abort error message of the method "MediaStatusTrackTime"
 * <p>CAN message to send the TrackTime status through CAN message</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError MediaStatusTrackTimeAbortError;

/**
 * The error message of 'MediaStatusTrackTime'
 */
typedef ::asf::cca::CcaTypes::DefaultError MediaStatusTrackTimeError;

/**
 * The abort error message of the method "MediaStatusCurrTrackNum"
 * <p>CAN message to send the CurrTrackNumber status through CAN message</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError MediaStatusCurrTrackNumAbortError;

/**
 * The error message of 'MediaStatusCurrTrackNum'
 */
typedef ::asf::cca::CcaTypes::DefaultError MediaStatusCurrTrackNumError;

/**
 * The abort error message of the method "MediaStatusTREGRTMStatus"
 * <p>CAN message to send the TREGRTMStatus  through CAN MediaStatus message</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError MediaStatusTREGRTMStatusAbortError;

/**
 * The error message of 'MediaStatusTREGRTMStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError MediaStatusTREGRTMStatusError;

/**
 * The abort error message of the method "CabinMediaStatusTunerBand"
 * <p>CAN message to send the Cabin Tuner Band Status through CAN CabinMediaStatus message</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError CabinMediaStatusTunerBandAbortError;

/**
 * The error message of 'CabinMediaStatusTunerBand'
 */
typedef ::asf::cca::CcaTypes::DefaultError CabinMediaStatusTunerBandError;

/**
 * The start message of the method "CSMEngineeringData"
 * CAN messages (relevant to display in engineering test mode) will be collected by VD VehicleData.
 * To be initiated by a cyclic methodStart (e.g. every 2sec) must be triggered by the client.
 * CSM Engineering data could be displayed in the following way:
 * <p>ID: 0x000005C2, Status: 0x00000001, Data: 00 00 00 00 00 00 00 20</p>
 * <p>...</p>
 * Method Start could be triggered when entering the Service Test Mode Screen (Vehicle HALL)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CSMEngineeringDataStart;

/**
 * The abort error message of the method "CSMEngineeringData"
 * CAN messages (relevant to display in engineering test mode) will be collected by VD VehicleData.
 * To be initiated by a cyclic methodStart (e.g. every 2sec) must be triggered by the client.
 * CSM Engineering data could be displayed in the following way:
 * <p>ID: 0x000005C2, Status: 0x00000001, Data: 00 00 00 00 00 00 00 20</p>
 * <p>...</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError CSMEngineeringDataAbortError;

/**
 * The error message of 'CSMEngineeringData'
 */
typedef ::asf::cca::CcaTypes::DefaultError CSMEngineeringDataError;

/**
 * The abort error message of the method "SetOSPAlertsStatus"
 * OSP Alert and Dangerous area Alert setting to be sent over V-CAN
 */
typedef ::asf::cca::CcaTypes::DefaultError SetOSPAlertsStatusAbortError;

/**
 * The error message of 'SetOSPAlertsStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError SetOSPAlertsStatusError;

/**
 * The abort error message of the method "SendMediaInfo"
 * Send Media type and its data
 */
typedef ::asf::cca::CcaTypes::DefaultError SendMediaInfoAbortError;

/**
 * The error message of 'SendMediaInfo'
 */
typedef ::asf::cca::CcaTypes::DefaultError SendMediaInfoError;

/**
 * The abort error message of the method "SendCallInfo"
 * Send Call type and its data
 */
typedef ::asf::cca::CcaTypes::DefaultError SendCallInfoAbortError;

/**
 * The error message of 'SendCallInfo'
 */
typedef ::asf::cca::CcaTypes::DefaultError SendCallInfoError;

/**
 * The abort error message of the method "SendPhoneInfo"
 * Send Phone type and its data
 */
typedef ::asf::cca::CcaTypes::DefaultError SendPhoneInfoAbortError;

/**
 * The error message of 'SendPhoneInfo'
 */
typedef ::asf::cca::CcaTypes::DefaultError SendPhoneInfoError;

/**
 * The abort error message of the method "SendXMInfo"
 * Send XM type and its data
 */
typedef ::asf::cca::CcaTypes::DefaultError SendXMInfoAbortError;

/**
 * The error message of 'SendXMInfo'
 */
typedef ::asf::cca::CcaTypes::DefaultError SendXMInfoError;

/**
 * The abort error message of the method "SendMainlineInfo"
 * Send Mainline type and its data
 */
typedef ::asf::cca::CcaTypes::DefaultError SendMainlineInfoAbortError;

/**
 * The error message of 'SendMainlineInfo'
 */
typedef ::asf::cca::CcaTypes::DefaultError SendMainlineInfoError;

/**
 * The abort error message of the method "SendCabinAMediaInfo"
 * Send CabinAMedia type and its data
 */
typedef ::asf::cca::CcaTypes::DefaultError SendCabinAMediaInfoAbortError;

/**
 * The error message of 'SendCabinAMediaInfo'
 */
typedef ::asf::cca::CcaTypes::DefaultError SendCabinAMediaInfoError;

/**
 * The abort error message of the method "SendCabinAMainlineInfo"
 * Send CabinAMainline type and its data
 */
typedef ::asf::cca::CcaTypes::DefaultError SendCabinAMainlineInfoAbortError;

/**
 * The error message of 'SendCabinAMainlineInfo'
 */
typedef ::asf::cca::CcaTypes::DefaultError SendCabinAMainlineInfoError;

/**
 * The abort error message of the method "SendCabinACallInfo"
 * Send CabinACall type and its data
 */
typedef ::asf::cca::CcaTypes::DefaultError SendCabinACallInfoAbortError;

/**
 * The error message of 'SendCabinACallInfo'
 */
typedef ::asf::cca::CcaTypes::DefaultError SendCabinACallInfoError;

/**
 * The abort error message of the method "SendCabinAPhoneInfo"
 * Send CabinAPhone type and its data
 */
typedef ::asf::cca::CcaTypes::DefaultError SendCabinAPhoneInfoAbortError;

/**
 * The error message of 'SendCabinAPhoneInfo'
 */
typedef ::asf::cca::CcaTypes::DefaultError SendCabinAPhoneInfoError;

/**
 * The abort error message of the method "SendCabinAXMInfo"
 * Send CabinAXM type and its data
 */
typedef ::asf::cca::CcaTypes::DefaultError SendCabinAXMInfoAbortError;

/**
 * The error message of 'SendCabinAXMInfo'
 */
typedef ::asf::cca::CcaTypes::DefaultError SendCabinAXMInfoError;

/**
 * The abort error message of the method "SendNaviCurrentStreetNameInfo"
 * Send NaviCurrentStreetName type and its data
 */
typedef ::asf::cca::CcaTypes::DefaultError SendNaviCurrentStreetNameInfoAbortError;

/**
 * The error message of 'SendNaviCurrentStreetNameInfo'
 */
typedef ::asf::cca::CcaTypes::DefaultError SendNaviCurrentStreetNameInfoError;

/**
 * The abort error message of the method "SendNaviTurnToStreetNameInfo"
 * Send NaviTurnToStreetName type and its data
 */
typedef ::asf::cca::CcaTypes::DefaultError SendNaviTurnToStreetNameInfoAbortError;

/**
 * The error message of 'SendNaviTurnToStreetNameInfo'
 */
typedef ::asf::cca::CcaTypes::DefaultError SendNaviTurnToStreetNameInfoError;

/**
 * The abort error message of the method "SendNaviDestinationInfo"
 * Send NaviDestination type and its data
 */
typedef ::asf::cca::CcaTypes::DefaultError SendNaviDestinationInfoAbortError;

/**
 * The error message of 'SendNaviDestinationInfo'
 */
typedef ::asf::cca::CcaTypes::DefaultError SendNaviDestinationInfoError;

/**
 * The abort error message of the method "SendNaviTurnToSymbolsInfo"
 * Send NaviTurnToSymbols type and its data
 */
typedef ::asf::cca::CcaTypes::DefaultError SendNaviTurnToSymbolsInfoAbortError;

/**
 * The error message of 'SendNaviTurnToSymbolsInfo'
 */
typedef ::asf::cca::CcaTypes::DefaultError SendNaviTurnToSymbolsInfoError;

/**
 * The abort error message of the method "SendNaviLaneGuidanceInfo"
 * Send NaviLaneGuidance type and its data
 */
typedef ::asf::cca::CcaTypes::DefaultError SendNaviLaneGuidanceInfoAbortError;

/**
 * The error message of 'SendNaviLaneGuidanceInfo'
 */
typedef ::asf::cca::CcaTypes::DefaultError SendNaviLaneGuidanceInfoError;

/**
 * The abort error message of the method "SendNaviNavigationWarningInfo"
 * Send NaviNavigationWarning type and its data
 */
typedef ::asf::cca::CcaTypes::DefaultError SendNaviNavigationWarningInfoAbortError;

/**
 * The error message of 'SendNaviNavigationWarningInfo'
 */
typedef ::asf::cca::CcaTypes::DefaultError SendNaviNavigationWarningInfoError;

/**
 * The abort error message of the method "Cam1ManAct"
 * <p>Activated Cam1 status</p>
 * <p>...</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError Cam1ManActAbortError;

/**
 * The error message of 'Cam1ManAct'
 */
typedef ::asf::cca::CcaTypes::DefaultError Cam1ManActError;

/**
 * The abort error message of the method "Cam2ManAct"
 * <p>Activated Cam2 status</p>
 * <p>...</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError Cam2ManActAbortError;

/**
 * The error message of 'Cam2ManAct'
 */
typedef ::asf::cca::CcaTypes::DefaultError Cam2ManActError;

/**
 * The abort error message of the method "Cam3ManAct"
 * <p>Activated Cam3 status</p>
 * <p>...</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError Cam3ManActAbortError;

/**
 * The error message of 'Cam3ManAct'
 */
typedef ::asf::cca::CcaTypes::DefaultError Cam3ManActError;

/**
 * The abort error message of the method "Cam4ManAct"
 * <p>Activated Cam4 status</p>
 * <p>...</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError Cam4ManActAbortError;

/**
 * The error message of 'Cam4ManAct'
 */
typedef ::asf::cca::CcaTypes::DefaultError Cam4ManActError;

/**
 * The abort error message of the method "Cam5ManAct"
 * <p>Activated Cam5 status</p>
 * <p>...</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError Cam5ManActAbortError;

/**
 * The error message of 'Cam5ManAct'
 */
typedef ::asf::cca::CcaTypes::DefaultError Cam5ManActError;

/**
 * The abort error message of the method "Cam6ManAct"
 * <p>Activated Cam6 status</p>
 * <p>...</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError Cam6ManActAbortError;

/**
 * The error message of 'Cam6ManAct'
 */
typedef ::asf::cca::CcaTypes::DefaultError Cam6ManActError;

/**
 * The abort error message of the method "Cam7ManAct"
 * <p>Activated Cam7 status</p>
 * <p>...</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError Cam7ManActAbortError;

/**
 * The error message of 'Cam7ManAct'
 */
typedef ::asf::cca::CcaTypes::DefaultError Cam7ManActError;

/**
 * The abort error message of the method "Cam8ManAct"
 * <p>Activated Cam8 status</p>
 * <p>...</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError Cam8ManActAbortError;

/**
 * The error message of 'Cam8ManAct'
 */
typedef ::asf::cca::CcaTypes::DefaultError Cam8ManActError;

/**
 * The abort error message of the method "Cam9ManAct"
 * <p>Activated Cam9 status</p>
 * <p>...</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError Cam9ManActAbortError;

/**
 * The error message of 'Cam9ManAct'
 */
typedef ::asf::cca::CcaTypes::DefaultError Cam9ManActError;

/**
 * The abort error message of the method "Cam10ManAct"
 * <p>Activated Cam10 status</p>
 * <p>...</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError Cam10ManActAbortError;

/**
 * The error message of 'Cam10ManAct'
 */
typedef ::asf::cca::CcaTypes::DefaultError Cam10ManActError;

/**
 * The abort error message of the method "Cam11ManAct"
 * <p>Activated Cam11 status</p>
 * <p>...</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError Cam11ManActAbortError;

/**
 * The error message of 'Cam11ManAct'
 */
typedef ::asf::cca::CcaTypes::DefaultError Cam11ManActError;

/**
 * The abort error message of the method "Cam12ManAct"
 * <p>Activated Cam12 status</p>
 * <p>...</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError Cam12ManActAbortError;

/**
 * The error message of 'Cam12ManAct'
 */
typedef ::asf::cca::CcaTypes::DefaultError Cam12ManActError;

/**
 * The abort error message of the method "Cam13ManAct"
 * <p>Activated Cam13 status</p>
 * <p>...</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError Cam13ManActAbortError;

/**
 * The error message of 'Cam13ManAct'
 */
typedef ::asf::cca::CcaTypes::DefaultError Cam13ManActError;

/**
 * The abort error message of the method "Cam14ManAct"
 * <p>Activated Cam14 status</p>
 * <p>...</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError Cam14ManActAbortError;

/**
 * The error message of 'Cam14ManAct'
 */
typedef ::asf::cca::CcaTypes::DefaultError Cam14ManActError;

/**
 * The abort error message of the method "Cam15ManAct"
 * <p>Activated Cam15 status</p>
 * <p>...</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError Cam15ManActAbortError;

/**
 * The error message of 'Cam15ManAct'
 */
typedef ::asf::cca::CcaTypes::DefaultError Cam15ManActError;

/**
 * The abort error message of the method "Cam16ManAct"
 * <p>Activated Cam16 status</p>
 * <p>...</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError Cam16ManActAbortError;

/**
 * The error message of 'Cam16ManAct'
 */
typedef ::asf::cca::CcaTypes::DefaultError Cam16ManActError;

/**
 * The abort error message of the method "Cam17ManAct"
 * <p>Activated Cam17 status</p>
 * <p>...</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError Cam17ManActAbortError;

/**
 * The error message of 'Cam17ManAct'
 */
typedef ::asf::cca::CcaTypes::DefaultError Cam17ManActError;

/**
 * The abort error message of the method "PrivacyResetAck"
 * <p>Acknowledgement of privacy reset received from HMI(System Settings) which has inturn received from diagnosis</p>
 * <p>...</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError PrivacyResetAckAbortError;

/**
 * The error message of 'PrivacyResetAck'
 */
typedef ::asf::cca::CcaTypes::DefaultError PrivacyResetAckError;

/**
 * The abort error message of the method "DispCamCls"
 * <p>Display camera close signal update provided by camera component when swtiched between streaming(0) and non-streaming(1)</p>
 * <p>...</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError DispCamClsAbortError;

/**
 * The error message of 'DispCamCls'
 */
typedef ::asf::cca::CcaTypes::DefaultError DispCamClsError;


/**
 * The status message of the property "DistanceUnit"
 * Distance Unit could be set to Metric (m/km) or Imperial (mile) Standard
 * <p>FUNCID = 0x0002,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class DistanceUnitStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DistanceUnitStatus ();

    /**
     * Copy constructor
     */
    inline  DistanceUnitStatus (const DistanceUnitStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DistanceUnitStatus (::vehicle_main_fi_types::T_e8_Vehicle_DistanceUnit e8DistanceUnit_);

    /**
     * Destructor
     */
    inline virtual  ~DistanceUnitStatus();

    /**
     * Assignment operator
     */
    inline DistanceUnitStatus& operator = (const DistanceUnitStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DistanceUnitStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DistanceUnitStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DistanceUnitStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DistanceUnitStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8DistanceUnit"

    static const int kE8DistanceUnit = 0;

    /**
     * Clears the field "e8DistanceUnit".
     *
     * The field will be set to its default value. The hasE8DistanceUnit()
     * method will return false.
     */
    inline void clearE8DistanceUnit();

    /**
     * Checks whether the field "e8DistanceUnit" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DistanceUnit()). Otherwise it will return false.
     */
    inline bool hasE8DistanceUnit () const;

    /**
     * Returns the value of the member "e8DistanceUnit".
     *
     * Status update will be notified to all the registered clients as soon as the data is updated
     *
     * @return The value of the field "e8DistanceUnit"
     */
    inline ::vehicle_main_fi_types::T_e8_Vehicle_DistanceUnit getE8DistanceUnit () const;

    /**
     * Sets the value of the member "e8DistanceUnit".
     *
     * Status update will be notified to all the registered clients as soon as the data is updated
     *
     * @param e8DistanceUnit The value which will be set
     */
    inline void setE8DistanceUnit (::vehicle_main_fi_types::T_e8_Vehicle_DistanceUnit e8DistanceUnit_);

    static const DistanceUnitStatus &getDefaultInstance();

private:

    inline void set_has_e8DistanceUnit ();

    inline void clear_has_e8DistanceUnit ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::vehicle_main_fi_types::T_e8_Vehicle_DistanceUnit _e8DistanceUnit;

};

/**
 * The set message of the property "DistanceUnit"
 * Distance Unit could be set to Metric (m/km) or Imperial (mile) Standard
 * <p>FUNCID = 0x0002,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class DistanceUnitSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DistanceUnitSet ();

    /**
     * Copy constructor
     */
    inline  DistanceUnitSet (const DistanceUnitSet &rhs);

    /**
     * All fields constructor
     */
    inline  DistanceUnitSet (::vehicle_main_fi_types::T_e8_Vehicle_DistanceUnit e8DistanceUnit_);

    /**
     * Destructor
     */
    inline virtual  ~DistanceUnitSet();

    /**
     * Assignment operator
     */
    inline DistanceUnitSet& operator = (const DistanceUnitSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DistanceUnitSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DistanceUnitSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DistanceUnitSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DistanceUnitSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8DistanceUnit"

    static const int kE8DistanceUnit = 0;

    /**
     * Clears the field "e8DistanceUnit".
     *
     * The field will be set to its default value. The hasE8DistanceUnit()
     * method will return false.
     */
    inline void clearE8DistanceUnit();

    /**
     * Checks whether the field "e8DistanceUnit" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DistanceUnit()). Otherwise it will return false.
     */
    inline bool hasE8DistanceUnit () const;

    /**
     * Returns the value of the member "e8DistanceUnit".
     *
     * <p>To be called to Set the Distance Unit.</p>
     * <p>Updated Unit will be notified to all the registered clients</p>
     *
     * @return The value of the field "e8DistanceUnit"
     */
    inline ::vehicle_main_fi_types::T_e8_Vehicle_DistanceUnit getE8DistanceUnit () const;

    /**
     * Sets the value of the member "e8DistanceUnit".
     *
     * <p>To be called to Set the Distance Unit.</p>
     * <p>Updated Unit will be notified to all the registered clients</p>
     *
     * @param e8DistanceUnit The value which will be set
     */
    inline void setE8DistanceUnit (::vehicle_main_fi_types::T_e8_Vehicle_DistanceUnit e8DistanceUnit_);

    static const DistanceUnitSet &getDefaultInstance();

private:

    inline void set_has_e8DistanceUnit ();

    inline void clear_has_e8DistanceUnit ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::vehicle_main_fi_types::T_e8_Vehicle_DistanceUnit _e8DistanceUnit;

};

/**
 * The status message of the property "FuelConsumptionUnit"
 * Fuel Consumption Unit (Shall be only used for Hybrid Electric Vehicles)
 * <p>FUNCID = 0x0003,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class FuelConsumptionUnitStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FuelConsumptionUnitStatus ();

    /**
     * Copy constructor
     */
    inline  FuelConsumptionUnitStatus (const FuelConsumptionUnitStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FuelConsumptionUnitStatus (::vehicle_main_fi_types::T_e8_Vehicle_FuelConsumptionUnit e8FuelConsumpUnit_);

    /**
     * Destructor
     */
    inline virtual  ~FuelConsumptionUnitStatus();

    /**
     * Assignment operator
     */
    inline FuelConsumptionUnitStatus& operator = (const FuelConsumptionUnitStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FuelConsumptionUnitStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FuelConsumptionUnitStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FuelConsumptionUnitStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FuelConsumptionUnitStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8FuelConsumpUnit"

    static const int kE8FuelConsumpUnit = 0;

    /**
     * Clears the field "e8FuelConsumpUnit".
     *
     * The field will be set to its default value. The hasE8FuelConsumpUnit()
     * method will return false.
     */
    inline void clearE8FuelConsumpUnit();

    /**
     * Checks whether the field "e8FuelConsumpUnit" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8FuelConsumpUnit()). Otherwise it will return false.
     */
    inline bool hasE8FuelConsumpUnit () const;

    /**
     * Returns the value of the member "e8FuelConsumpUnit".
     *
     * Status will be updated to all the registered clients as soon as the data is updated
     *
     * @return The value of the field "e8FuelConsumpUnit"
     */
    inline ::vehicle_main_fi_types::T_e8_Vehicle_FuelConsumptionUnit getE8FuelConsumpUnit () const;

    /**
     * Sets the value of the member "e8FuelConsumpUnit".
     *
     * Status will be updated to all the registered clients as soon as the data is updated
     *
     * @param e8FuelConsumpUnit The value which will be set
     */
    inline void setE8FuelConsumpUnit (::vehicle_main_fi_types::T_e8_Vehicle_FuelConsumptionUnit e8FuelConsumpUnit_);

    static const FuelConsumptionUnitStatus &getDefaultInstance();

private:

    inline void set_has_e8FuelConsumpUnit ();

    inline void clear_has_e8FuelConsumpUnit ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::vehicle_main_fi_types::T_e8_Vehicle_FuelConsumptionUnit _e8FuelConsumpUnit;

};

/**
 * The set message of the property "FuelConsumptionUnit"
 * Fuel Consumption Unit (Shall be only used for Hybrid Electric Vehicles)
 * <p>FUNCID = 0x0003,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class FuelConsumptionUnitSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FuelConsumptionUnitSet ();

    /**
     * Copy constructor
     */
    inline  FuelConsumptionUnitSet (const FuelConsumptionUnitSet &rhs);

    /**
     * All fields constructor
     */
    inline  FuelConsumptionUnitSet (::vehicle_main_fi_types::T_e8_Vehicle_FuelConsumptionUnit e8FuelConsumpUnit_);

    /**
     * Destructor
     */
    inline virtual  ~FuelConsumptionUnitSet();

    /**
     * Assignment operator
     */
    inline FuelConsumptionUnitSet& operator = (const FuelConsumptionUnitSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FuelConsumptionUnitSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FuelConsumptionUnitSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FuelConsumptionUnitSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FuelConsumptionUnitSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8FuelConsumpUnit"

    static const int kE8FuelConsumpUnit = 0;

    /**
     * Clears the field "e8FuelConsumpUnit".
     *
     * The field will be set to its default value. The hasE8FuelConsumpUnit()
     * method will return false.
     */
    inline void clearE8FuelConsumpUnit();

    /**
     * Checks whether the field "e8FuelConsumpUnit" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8FuelConsumpUnit()). Otherwise it will return false.
     */
    inline bool hasE8FuelConsumpUnit () const;

    /**
     * Returns the value of the member "e8FuelConsumpUnit".
     *
     * <p>To be called to Set the Fuel Consumption Unit.</p>
     * <p>Updated Unit will be notified to all the registered clients</p>
     *
     * @return The value of the field "e8FuelConsumpUnit"
     */
    inline ::vehicle_main_fi_types::T_e8_Vehicle_FuelConsumptionUnit getE8FuelConsumpUnit () const;

    /**
     * Sets the value of the member "e8FuelConsumpUnit".
     *
     * <p>To be called to Set the Fuel Consumption Unit.</p>
     * <p>Updated Unit will be notified to all the registered clients</p>
     *
     * @param e8FuelConsumpUnit The value which will be set
     */
    inline void setE8FuelConsumpUnit (::vehicle_main_fi_types::T_e8_Vehicle_FuelConsumptionUnit e8FuelConsumpUnit_);

    static const FuelConsumptionUnitSet &getDefaultInstance();

private:

    inline void set_has_e8FuelConsumpUnit ();

    inline void clear_has_e8FuelConsumpUnit ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::vehicle_main_fi_types::T_e8_Vehicle_FuelConsumptionUnit _e8FuelConsumpUnit;

};

/**
 * The status message of the property "TemperatureUnit"
 * Temperature Unit (Centigrade or Fahrenheit)
 * <p>FUNCID = 0x0004,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class TemperatureUnitStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TemperatureUnitStatus ();

    /**
     * Copy constructor
     */
    inline  TemperatureUnitStatus (const TemperatureUnitStatus &rhs);

    /**
     * All fields constructor
     */
    inline  TemperatureUnitStatus (::vehicle_main_fi_types::T_e8_Vehicle_TemperatureUnit e8TempUnit_);

    /**
     * Destructor
     */
    inline virtual  ~TemperatureUnitStatus();

    /**
     * Assignment operator
     */
    inline TemperatureUnitStatus& operator = (const TemperatureUnitStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TemperatureUnitStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TemperatureUnitStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TemperatureUnitStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TemperatureUnitStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8TempUnit"

    static const int kE8TempUnit = 0;

    /**
     * Clears the field "e8TempUnit".
     *
     * The field will be set to its default value. The hasE8TempUnit()
     * method will return false.
     */
    inline void clearE8TempUnit();

    /**
     * Checks whether the field "e8TempUnit" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8TempUnit()). Otherwise it will return false.
     */
    inline bool hasE8TempUnit () const;

    /**
     * Returns the value of the member "e8TempUnit".
     *
     * Status will be updated to all the registered clients as soon as the data is updated
     *
     * @return The value of the field "e8TempUnit"
     */
    inline ::vehicle_main_fi_types::T_e8_Vehicle_TemperatureUnit getE8TempUnit () const;

    /**
     * Sets the value of the member "e8TempUnit".
     *
     * Status will be updated to all the registered clients as soon as the data is updated
     *
     * @param e8TempUnit The value which will be set
     */
    inline void setE8TempUnit (::vehicle_main_fi_types::T_e8_Vehicle_TemperatureUnit e8TempUnit_);

    static const TemperatureUnitStatus &getDefaultInstance();

private:

    inline void set_has_e8TempUnit ();

    inline void clear_has_e8TempUnit ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::vehicle_main_fi_types::T_e8_Vehicle_TemperatureUnit _e8TempUnit;

};

/**
 * The set message of the property "TemperatureUnit"
 * Temperature Unit (Centigrade or Fahrenheit)
 * <p>FUNCID = 0x0004,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class TemperatureUnitSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TemperatureUnitSet ();

    /**
     * Copy constructor
     */
    inline  TemperatureUnitSet (const TemperatureUnitSet &rhs);

    /**
     * All fields constructor
     */
    inline  TemperatureUnitSet (::vehicle_main_fi_types::T_e8_Vehicle_TemperatureUnit e8TempUnit_);

    /**
     * Destructor
     */
    inline virtual  ~TemperatureUnitSet();

    /**
     * Assignment operator
     */
    inline TemperatureUnitSet& operator = (const TemperatureUnitSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TemperatureUnitSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TemperatureUnitSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TemperatureUnitSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TemperatureUnitSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8TempUnit"

    static const int kE8TempUnit = 0;

    /**
     * Clears the field "e8TempUnit".
     *
     * The field will be set to its default value. The hasE8TempUnit()
     * method will return false.
     */
    inline void clearE8TempUnit();

    /**
     * Checks whether the field "e8TempUnit" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8TempUnit()). Otherwise it will return false.
     */
    inline bool hasE8TempUnit () const;

    /**
     * Returns the value of the member "e8TempUnit".
     *
     * <p>To be called to Set the Temperature Unit.</p>
     * <p>Updated Unit will be notified to all the registered clients</p>
     *
     * @return The value of the field "e8TempUnit"
     */
    inline ::vehicle_main_fi_types::T_e8_Vehicle_TemperatureUnit getE8TempUnit () const;

    /**
     * Sets the value of the member "e8TempUnit".
     *
     * <p>To be called to Set the Temperature Unit.</p>
     * <p>Updated Unit will be notified to all the registered clients</p>
     *
     * @param e8TempUnit The value which will be set
     */
    inline void setE8TempUnit (::vehicle_main_fi_types::T_e8_Vehicle_TemperatureUnit e8TempUnit_);

    static const TemperatureUnitSet &getDefaultInstance();

private:

    inline void set_has_e8TempUnit ();

    inline void clear_has_e8TempUnit ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::vehicle_main_fi_types::T_e8_Vehicle_TemperatureUnit _e8TempUnit;

};

/**
 * The status message of the property "Language"
 * Current System Language Update for all the applications
 * <p>FUNCID = 0x0005,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class LanguageStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LanguageStatus ();

    /**
     * Copy constructor
     */
    inline  LanguageStatus (const LanguageStatus &rhs);

    /**
     * All fields constructor
     */
    inline  LanguageStatus (::vehicle_main_fi_types::T_e8_Language_Code Language_, const ::std::vector< ::vehicle_main_fi_types::T_Language_SourceTable >& LangTable_);

    /**
     * Destructor
     */
    inline virtual  ~LanguageStatus();

    /**
     * Assignment operator
     */
    inline LanguageStatus& operator = (const LanguageStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LanguageStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LanguageStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LanguageStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LanguageStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Language"

    static const int kLanguage = 0;

    /**
     * Clears the field "Language".
     *
     * The field will be set to its default value. The hasLanguage()
     * method will return false.
     */
    inline void clearLanguage();

    /**
     * Checks whether the field "Language" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLanguage()). Otherwise it will return false.
     */
    inline bool hasLanguage () const;

    /**
     * Returns the value of the member "Language".
     *
     * <p>Currently selected Language on Head Unit</p>
     *
     * @return The value of the field "Language"
     */
    inline ::vehicle_main_fi_types::T_e8_Language_Code getLanguage () const;

    /**
     * Sets the value of the member "Language".
     *
     * <p>Currently selected Language on Head Unit</p>
     *
     * @param Language The value which will be set
     */
    inline void setLanguage (::vehicle_main_fi_types::T_e8_Language_Code Language_);

    // API of field "LangTable"

    static const int kLangTable = 1;

    /**
     * Clears the field "LangTable".
     *
     * The field will be set to its default value. The hasLangTable()
     * method will return false.
     */
    inline void clearLangTable();

    /**
     * Checks whether the field "LangTable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLangTable()). Otherwise it will return false.
     */
    inline bool hasLangTable () const;

    /**
     * Returns the value of the member "LangTable".
     *
     * <p>List of Language Source Structure</p>
     * <p>- Source Component Id eg. Meter, HMI, SDS, ...</p>
     * <p>- SelectedLanguage</p>
     * <p>- bHasChanged</p>
     *
     * @return The value of the field "LangTable"
     */
    inline const ::std::vector< ::vehicle_main_fi_types::T_Language_SourceTable >& getLangTable () const;

    /**
     * Retrieves the value of the field "LangTable" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "LangTable".
     */
    inline ::std::vector< ::vehicle_main_fi_types::T_Language_SourceTable >& getLangTableMutable ();

    /**
     * Sets the value of the member "LangTable".
     *
     * <p>List of Language Source Structure</p>
     * <p>- Source Component Id eg. Meter, HMI, SDS, ...</p>
     * <p>- SelectedLanguage</p>
     * <p>- bHasChanged</p>
     *
     * @param LangTable The value which will be set
     */
    inline void setLangTable (const ::std::vector< ::vehicle_main_fi_types::T_Language_SourceTable >& LangTable_);

    static const LanguageStatus &getDefaultInstance();

private:

    static const ::std::vector< ::vehicle_main_fi_types::T_Language_SourceTable >& getT_Language_SourceTableList_DefaultInstance ();

    inline void set_has_Language ();

    inline void clear_has_Language ();

    inline void set_has_LangTable ();

    inline void clear_has_LangTable ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::vehicle_main_fi_types::T_e8_Language_Code _Language;

    ::std::vector< ::vehicle_main_fi_types::T_Language_SourceTable > _LangTable;

};

/**
 * The status message of the property "LanguageSyncSource"
 * Sets and Notifies the Source which the System Language is in Sync with.
 * <p>FUNCID = 0x0006,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class LanguageSyncSourceStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LanguageSyncSourceStatus ();

    /**
     * Copy constructor
     */
    inline  LanguageSyncSourceStatus (const LanguageSyncSourceStatus &rhs);

    /**
     * All fields constructor
     */
    inline  LanguageSyncSourceStatus (::vehicle_main_fi_types::T_e8_Language_SourceId Language_);

    /**
     * Destructor
     */
    inline virtual  ~LanguageSyncSourceStatus();

    /**
     * Assignment operator
     */
    inline LanguageSyncSourceStatus& operator = (const LanguageSyncSourceStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LanguageSyncSourceStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LanguageSyncSourceStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LanguageSyncSourceStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LanguageSyncSourceStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Language"

    static const int kLanguage = 0;

    /**
     * Clears the field "Language".
     *
     * The field will be set to its default value. The hasLanguage()
     * method will return false.
     */
    inline void clearLanguage();

    /**
     * Checks whether the field "Language" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLanguage()). Otherwise it will return false.
     */
    inline bool hasLanguage () const;

    /**
     * Returns the value of the member "Language".
     *
     * <p>System language is in Synchronization with this Component</p>
     *
     * @return The value of the field "Language"
     */
    inline ::vehicle_main_fi_types::T_e8_Language_SourceId getLanguage () const;

    /**
     * Sets the value of the member "Language".
     *
     * <p>System language is in Synchronization with this Component</p>
     *
     * @param Language The value which will be set
     */
    inline void setLanguage (::vehicle_main_fi_types::T_e8_Language_SourceId Language_);

    static const LanguageSyncSourceStatus &getDefaultInstance();

private:

    inline void set_has_Language ();

    inline void clear_has_Language ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::vehicle_main_fi_types::T_e8_Language_SourceId _Language;

};

/**
 * The set message of the property "LanguageSyncSource"
 * Sets and Notifies the Source which the System Language is in Sync with.
 * <p>FUNCID = 0x0006,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class LanguageSyncSourceSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LanguageSyncSourceSet ();

    /**
     * Copy constructor
     */
    inline  LanguageSyncSourceSet (const LanguageSyncSourceSet &rhs);

    /**
     * All fields constructor
     */
    inline  LanguageSyncSourceSet (::vehicle_main_fi_types::T_e8_Language_SourceId Language_);

    /**
     * Destructor
     */
    inline virtual  ~LanguageSyncSourceSet();

    /**
     * Assignment operator
     */
    inline LanguageSyncSourceSet& operator = (const LanguageSyncSourceSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LanguageSyncSourceSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LanguageSyncSourceSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LanguageSyncSourceSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LanguageSyncSourceSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Language"

    static const int kLanguage = 0;

    /**
     * Clears the field "Language".
     *
     * The field will be set to its default value. The hasLanguage()
     * method will return false.
     */
    inline void clearLanguage();

    /**
     * Checks whether the field "Language" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLanguage()). Otherwise it will return false.
     */
    inline bool hasLanguage () const;

    /**
     * Returns the value of the member "Language".
     *
     * <p>Set the Language Synchronization source. This might result in the System Language Update</p>
     *
     * @return The value of the field "Language"
     */
    inline ::vehicle_main_fi_types::T_e8_Language_SourceId getLanguage () const;

    /**
     * Sets the value of the member "Language".
     *
     * <p>Set the Language Synchronization source. This might result in the System Language Update</p>
     *
     * @param Language The value which will be set
     */
    inline void setLanguage (::vehicle_main_fi_types::T_e8_Language_SourceId Language_);

    static const LanguageSyncSourceSet &getDefaultInstance();

private:

    inline void set_has_Language ();

    inline void clear_has_Language ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::vehicle_main_fi_types::T_e8_Language_SourceId _Language;

};

/**
 * The status message of the property "MeterLanguageKnowledge"
 * The reply received from Meter about the Requested Language only for Renault Scope 2.1
 * <p>FUNCID = 0x0007,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class MeterLanguageKnowledgeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MeterLanguageKnowledgeStatus ();

    /**
     * Copy constructor
     */
    inline  MeterLanguageKnowledgeStatus (const MeterLanguageKnowledgeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  MeterLanguageKnowledgeStatus (::vehicle_main_fi_types::T_e8_Meter_LangKnowledge State_);

    /**
     * Destructor
     */
    inline virtual  ~MeterLanguageKnowledgeStatus();

    /**
     * Assignment operator
     */
    inline MeterLanguageKnowledgeStatus& operator = (const MeterLanguageKnowledgeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MeterLanguageKnowledgeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MeterLanguageKnowledgeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MeterLanguageKnowledgeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MeterLanguageKnowledgeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "State"

    static const int kState = 0;

    /**
     * Clears the field "State".
     *
     * The field will be set to its default value. The hasState()
     * method will return false.
     */
    inline void clearState();

    /**
     * Checks whether the field "State" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setState()). Otherwise it will return false.
     */
    inline bool hasState () const;

    /**
     * Returns the value of the member "State".
     *
     * <p>Language available in Meter or not</p>
     *
     * @return The value of the field "State"
     */
    inline ::vehicle_main_fi_types::T_e8_Meter_LangKnowledge getState () const;

    /**
     * Sets the value of the member "State".
     *
     * <p>Language available in Meter or not</p>
     *
     * @param State The value which will be set
     */
    inline void setState (::vehicle_main_fi_types::T_e8_Meter_LangKnowledge State_);

    static const MeterLanguageKnowledgeStatus &getDefaultInstance();

private:

    inline void set_has_State ();

    inline void clear_has_State ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::vehicle_main_fi_types::T_e8_Meter_LangKnowledge _State;

};

/**
 * The status message of the property "HandBrake"
 * HandBrake Switch Status received from V-CAN
 * <p>FUNCID = 0x1000,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class HandBrakeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  HandBrakeStatus ();

    /**
     * Copy constructor
     */
    inline  HandBrakeStatus (const HandBrakeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  HandBrakeStatus (::vehicle_main_fi_types::T_e8_Vehicle_HandBrakeStatus e8Status_);

    /**
     * Destructor
     */
    inline virtual  ~HandBrakeStatus();

    /**
     * Assignment operator
     */
    inline HandBrakeStatus& operator = (const HandBrakeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HandBrakeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HandBrakeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HandBrakeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HandBrakeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Status"

    static const int kE8Status = 0;

    /**
     * Clears the field "e8Status".
     *
     * The field will be set to its default value. The hasE8Status()
     * method will return false.
     */
    inline void clearE8Status();

    /**
     * Checks whether the field "e8Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Status()). Otherwise it will return false.
     */
    inline bool hasE8Status () const;

    /**
     * Returns the value of the member "e8Status".
     *
     * Status will be updated to all the registered clients as soon as the data is updated
     *
     * @return The value of the field "e8Status"
     */
    inline ::vehicle_main_fi_types::T_e8_Vehicle_HandBrakeStatus getE8Status () const;

    /**
     * Sets the value of the member "e8Status".
     *
     * Status will be updated to all the registered clients as soon as the data is updated
     *
     * @param e8Status The value which will be set
     */
    inline void setE8Status (::vehicle_main_fi_types::T_e8_Vehicle_HandBrakeStatus e8Status_);

    static const HandBrakeStatus &getDefaultInstance();

private:

    inline void set_has_e8Status ();

    inline void clear_has_e8Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::vehicle_main_fi_types::T_e8_Vehicle_HandBrakeStatus _e8Status;

};

/**
 * The status message of the property "Ignition"
 * Ignition Status received from SPM
 * <p>FUNCID = 0x1001,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class IgnitionStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IgnitionStatus ();

    /**
     * Copy constructor
     */
    inline  IgnitionStatus (const IgnitionStatus &rhs);

    /**
     * All fields constructor
     */
    inline  IgnitionStatus (::vehicle_main_fi_types::T_e8_Vehicle_Ignition e8Status_);

    /**
     * Destructor
     */
    inline virtual  ~IgnitionStatus();

    /**
     * Assignment operator
     */
    inline IgnitionStatus& operator = (const IgnitionStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IgnitionStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IgnitionStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IgnitionStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IgnitionStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Status"

    static const int kE8Status = 0;

    /**
     * Clears the field "e8Status".
     *
     * The field will be set to its default value. The hasE8Status()
     * method will return false.
     */
    inline void clearE8Status();

    /**
     * Checks whether the field "e8Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Status()). Otherwise it will return false.
     */
    inline bool hasE8Status () const;

    /**
     * Returns the value of the member "e8Status".
     *
     * <p>Status will be updated to all the registered clients as soon as the data is updated</p>
     *
     * @return The value of the field "e8Status"
     */
    inline ::vehicle_main_fi_types::T_e8_Vehicle_Ignition getE8Status () const;

    /**
     * Sets the value of the member "e8Status".
     *
     * <p>Status will be updated to all the registered clients as soon as the data is updated</p>
     *
     * @param e8Status The value which will be set
     */
    inline void setE8Status (::vehicle_main_fi_types::T_e8_Vehicle_Ignition e8Status_);

    static const IgnitionStatus &getDefaultInstance();

private:

    inline void set_has_e8Status ();

    inline void clear_has_e8Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::vehicle_main_fi_types::T_e8_Vehicle_Ignition _e8Status;

};

/**
 * The status message of the property "Speed"
 * Vehicle Speed Data and Status received from V-CAN
 * <p>FUNCID = 0x1002,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class SpeedStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SpeedStatus ();

    /**
     * Copy constructor
     */
    inline  SpeedStatus (const SpeedStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SpeedStatus (uint16 SpeedValue_);

    /**
     * Destructor
     */
    inline virtual  ~SpeedStatus();

    /**
     * Assignment operator
     */
    inline SpeedStatus& operator = (const SpeedStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SpeedStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SpeedStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SpeedStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SpeedStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SpeedValue"

    static const int kSpeedValue = 0;

    /**
     * Clears the field "SpeedValue".
     *
     * The field will be set to its default value. The hasSpeedValue()
     * method will return false.
     */
    inline void clearSpeedValue();

    /**
     * Checks whether the field "SpeedValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSpeedValue()). Otherwise it will return false.
     */
    inline bool hasSpeedValue () const;

    /**
     * Returns the value of the member "SpeedValue".
     *
     * <p>Data Range (SpeedValue)- 0 ... 65535</p>
     * <p>Actual Value = SpeedValue * 0.00390625</p>
     * <p>Actual Speed range - 0 ... 655.34 km/hr</p>
     * <p>if SpeedValue = 65535 means Data is invalid</p>
     *
     * @return The value of the field "SpeedValue"
     */
    inline uint16 getSpeedValue () const;

    /**
     * Sets the value of the member "SpeedValue".
     *
     * <p>Data Range (SpeedValue)- 0 ... 65535</p>
     * <p>Actual Value = SpeedValue * 0.00390625</p>
     * <p>Actual Speed range - 0 ... 655.34 km/hr</p>
     * <p>if SpeedValue = 65535 means Data is invalid</p>
     *
     * @param SpeedValue The value which will be set
     */
    inline void setSpeedValue (uint16 SpeedValue_);

    static const SpeedStatus &getDefaultInstance();

private:

    inline void set_has_SpeedValue ();

    inline void clear_has_SpeedValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _SpeedValue;

};

/**
 * The status message of the property "SpeedLimit"
 * Speed Limit received over V-CAN from ISA unit
 * <p>FUNCID = 0x1003,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class SpeedLimitStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SpeedLimitStatus ();

    /**
     * Copy constructor
     */
    inline  SpeedLimitStatus (const SpeedLimitStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SpeedLimitStatus (uint8 SpeedLimit1_, uint8 SpeedLimit2_, uint8 Display_, ::vehicle_main_fi_types::T_e8_Vehicle_DistanceUnit DisplayUnit_, bool OverSpeed_, bool FreeSpeed_);

    /**
     * Destructor
     */
    inline virtual  ~SpeedLimitStatus();

    /**
     * Assignment operator
     */
    inline SpeedLimitStatus& operator = (const SpeedLimitStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SpeedLimitStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SpeedLimitStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SpeedLimitStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SpeedLimitStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SpeedLimit1"

    static const int kSpeedLimit1 = 0;

    /**
     * Clears the field "SpeedLimit1".
     *
     * The field will be set to its default value. The hasSpeedLimit1()
     * method will return false.
     */
    inline void clearSpeedLimit1();

    /**
     * Checks whether the field "SpeedLimit1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSpeedLimit1()). Otherwise it will return false.
     */
    inline bool hasSpeedLimit1 () const;

    /**
     * Returns the value of the member "SpeedLimit1".
     *
     * <p>Speed Limit value to be displayed</p>
     * <p>Scope2:</p>
     * <p>0 => SpeedLimit value not available</p>
     * <p>1-255 => Valid Values to be displayed</p>
     * <p>Scope2.1:</p>
     * <p>0 => SpeedLimit value not available. Don't display anything. Also Free Speed symbol.</p>
     * <p>1-255 =>  valid values to be displayed, unless FreeSpeed = TRUE.</p>
     *
     * @return The value of the field "SpeedLimit1"
     */
    inline uint8 getSpeedLimit1 () const;

    /**
     * Sets the value of the member "SpeedLimit1".
     *
     * <p>Speed Limit value to be displayed</p>
     * <p>Scope2:</p>
     * <p>0 => SpeedLimit value not available</p>
     * <p>1-255 => Valid Values to be displayed</p>
     * <p>Scope2.1:</p>
     * <p>0 => SpeedLimit value not available. Don't display anything. Also Free Speed symbol.</p>
     * <p>1-255 =>  valid values to be displayed, unless FreeSpeed = TRUE.</p>
     *
     * @param SpeedLimit1 The value which will be set
     */
    inline void setSpeedLimit1 (uint8 SpeedLimit1_);

    // API of field "SpeedLimit2"

    static const int kSpeedLimit2 = 1;

    /**
     * Clears the field "SpeedLimit2".
     *
     * The field will be set to its default value. The hasSpeedLimit2()
     * method will return false.
     */
    inline void clearSpeedLimit2();

    /**
     * Checks whether the field "SpeedLimit2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSpeedLimit2()). Otherwise it will return false.
     */
    inline bool hasSpeedLimit2 () const;

    /**
     * Returns the value of the member "SpeedLimit2".
     *
     * <p>Speed Limit value (not used)</p>
     * <p>Scope2:</p>
     * <p>0 => SpeedLimit value not available</p>
     * <p>1-255 => Valid Values to be displayed</p>
     * <p>Scope2.1: Not applicable</p>
     *
     * @return The value of the field "SpeedLimit2"
     */
    inline uint8 getSpeedLimit2 () const;

    /**
     * Sets the value of the member "SpeedLimit2".
     *
     * <p>Speed Limit value (not used)</p>
     * <p>Scope2:</p>
     * <p>0 => SpeedLimit value not available</p>
     * <p>1-255 => Valid Values to be displayed</p>
     * <p>Scope2.1: Not applicable</p>
     *
     * @param SpeedLimit2 The value which will be set
     */
    inline void setSpeedLimit2 (uint8 SpeedLimit2_);

    // API of field "Display"

    static const int kDisplay = 2;

    /**
     * Clears the field "Display".
     *
     * The field will be set to its default value. The hasDisplay()
     * method will return false.
     */
    inline void clearDisplay();

    /**
     * Checks whether the field "Display" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDisplay()). Otherwise it will return false.
     */
    inline bool hasDisplay () const;

    /**
     * Returns the value of the member "Display".
     *
     * <p>Indicates whether SpeedLimit value received on VCAN should be displayed or not</p>
     * <p>------</p>
     * <p>Scope2:</p>
     * <p>0 => Head unit should use speed limits from navigation database and
     * calculate the overspeed indication internally.</p>
     * <p>Condition:</p>
     * <p>- ISA is not Configured via KDS.</p>
     * <p>- VCAN Speed Limit Display Request value is False</p>
     * <p>- VCAN Data unavailable or invalid.</p>
     * <p>1 => Head unit should use the SpeedLimit value from SpeedLimit::SpeedLimit1</p>
     * <p>SpeedLimit::bOverSpeed and SpeedLimit::bFreeSpeed parameter
     * shall not be used or Both the values are always set to 'FALSE'.</p>
     * <p>Condition:</p>
     * <p>- ISA is configured via KDS.</p>
     * <p>- VCAN Speed Limit Display Request value is True</p>
     * <p>2 => Not applicable</p>
     * <p>------</p>
     * <p>Scope2.1:</p>
     * <p>0 => Head unit should use speed limits from navigation database and
     * calculate the overspeed indication internally.</p>
     * <p>CONDITION:</p>
     * <p>- OSP/TSR is not Configured via KDS.</p>
     * <p>- VCAN Customer Activation Status is Off.</p>
     * <p>- VCAN Data unavailable or invalid.</p>
     * <p>1 => Not applicable</p>
     * <p>2 => Head unit should use the below</p>
     * <p>- SpeedLimit value from SpeedLimit::SpeedLimit1.</p>
     * <p>- Over Speed indication from SpeedLimit::bOverSpeed.</p>
     * <p>- Free Speed indication from SpeedLimit::bFreeSpeed.</p>
     * <p>CONDITION:</p>
     * <p>- OSP/TSR is Configured via KDS.</p>
     * <p>- VCAN Customer Activation Status is On.</p>
     * <p>- VCAN Data unavailable or invalid.</p>
     *
     * @return The value of the field "Display"
     */
    inline uint8 getDisplay () const;

    /**
     * Sets the value of the member "Display".
     *
     * <p>Indicates whether SpeedLimit value received on VCAN should be displayed or not</p>
     * <p>------</p>
     * <p>Scope2:</p>
     * <p>0 => Head unit should use speed limits from navigation database and
     * calculate the overspeed indication internally.</p>
     * <p>Condition:</p>
     * <p>- ISA is not Configured via KDS.</p>
     * <p>- VCAN Speed Limit Display Request value is False</p>
     * <p>- VCAN Data unavailable or invalid.</p>
     * <p>1 => Head unit should use the SpeedLimit value from SpeedLimit::SpeedLimit1</p>
     * <p>SpeedLimit::bOverSpeed and SpeedLimit::bFreeSpeed parameter
     * shall not be used or Both the values are always set to 'FALSE'.</p>
     * <p>Condition:</p>
     * <p>- ISA is configured via KDS.</p>
     * <p>- VCAN Speed Limit Display Request value is True</p>
     * <p>2 => Not applicable</p>
     * <p>------</p>
     * <p>Scope2.1:</p>
     * <p>0 => Head unit should use speed limits from navigation database and
     * calculate the overspeed indication internally.</p>
     * <p>CONDITION:</p>
     * <p>- OSP/TSR is not Configured via KDS.</p>
     * <p>- VCAN Customer Activation Status is Off.</p>
     * <p>- VCAN Data unavailable or invalid.</p>
     * <p>1 => Not applicable</p>
     * <p>2 => Head unit should use the below</p>
     * <p>- SpeedLimit value from SpeedLimit::SpeedLimit1.</p>
     * <p>- Over Speed indication from SpeedLimit::bOverSpeed.</p>
     * <p>- Free Speed indication from SpeedLimit::bFreeSpeed.</p>
     * <p>CONDITION:</p>
     * <p>- OSP/TSR is Configured via KDS.</p>
     * <p>- VCAN Customer Activation Status is On.</p>
     * <p>- VCAN Data unavailable or invalid.</p>
     *
     * @param Display The value which will be set
     */
    inline void setDisplay (uint8 Display_);

    // API of field "DisplayUnit"

    static const int kDisplayUnit = 3;

    /**
     * Clears the field "DisplayUnit".
     *
     * The field will be set to its default value. The hasDisplayUnit()
     * method will return false.
     */
    inline void clearDisplayUnit();

    /**
     * Checks whether the field "DisplayUnit" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDisplayUnit()). Otherwise it will return false.
     */
    inline bool hasDisplayUnit () const;

    /**
     * Returns the value of the member "DisplayUnit".
     *
     * <p>Unit of SpeedLimit values received on VCAN</p>
     *
     * @return The value of the field "DisplayUnit"
     */
    inline ::vehicle_main_fi_types::T_e8_Vehicle_DistanceUnit getDisplayUnit () const;

    /**
     * Sets the value of the member "DisplayUnit".
     *
     * <p>Unit of SpeedLimit values received on VCAN</p>
     *
     * @param DisplayUnit The value which will be set
     */
    inline void setDisplayUnit (::vehicle_main_fi_types::T_e8_Vehicle_DistanceUnit DisplayUnit_);

    // API of field "OverSpeed"

    static const int kOverSpeed = 4;

    /**
     * Clears the field "OverSpeed".
     *
     * The field will be set to its default value. The hasOverSpeed()
     * method will return false.
     */
    inline void clearOverSpeed();

    /**
     * Checks whether the field "OverSpeed" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOverSpeed()). Otherwise it will return false.
     */
    inline bool hasOverSpeed () const;

    /**
     * Returns the value of the member "OverSpeed".
     *
     * <p>Inform whether the vehicle is in overspeed compared to OSP Speed limit</p>
     * <p>Scope 2:</p>
     * <p>Not Applicable (will be always set to FALSE meaning "No Over Speed alert")</p>
     * <p>Scope 2.1:</p>
     * <p>False => No overspeed alert</p>
     * <p>True  => Overspeed alert</p>
     *
     * @return The value of the field "OverSpeed"
     */
    inline bool getOverSpeed () const;

    /**
     * Sets the value of the member "OverSpeed".
     *
     * <p>Inform whether the vehicle is in overspeed compared to OSP Speed limit</p>
     * <p>Scope 2:</p>
     * <p>Not Applicable (will be always set to FALSE meaning "No Over Speed alert")</p>
     * <p>Scope 2.1:</p>
     * <p>False => No overspeed alert</p>
     * <p>True  => Overspeed alert</p>
     *
     * @param OverSpeed The value which will be set
     */
    inline void setOverSpeed (bool OverSpeed_);

    // API of field "FreeSpeed"

    static const int kFreeSpeed = 5;

    /**
     * Clears the field "FreeSpeed".
     *
     * The field will be set to its default value. The hasFreeSpeed()
     * method will return false.
     */
    inline void clearFreeSpeed();

    /**
     * Checks whether the field "FreeSpeed" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFreeSpeed()). Otherwise it will return false.
     */
    inline bool hasFreeSpeed () const;

    /**
     * Returns the value of the member "FreeSpeed".
     *
     * <p>Inform whether Free speed symbol to be shown or not</p>
     * <p>Scope 2:</p>
     * <p>Not Applicable (will be always set to FALSE meaning "Do not display Free Speed symbol")</p>
     * <p>Scope 2.1:</p>
     * <p>False => Display SpeedLimit1</p>
     * <p>True  => Display Free Speed symbol</p>
     *
     * @return The value of the field "FreeSpeed"
     */
    inline bool getFreeSpeed () const;

    /**
     * Sets the value of the member "FreeSpeed".
     *
     * <p>Inform whether Free speed symbol to be shown or not</p>
     * <p>Scope 2:</p>
     * <p>Not Applicable (will be always set to FALSE meaning "Do not display Free Speed symbol")</p>
     * <p>Scope 2.1:</p>
     * <p>False => Display SpeedLimit1</p>
     * <p>True  => Display Free Speed symbol</p>
     *
     * @param FreeSpeed The value which will be set
     */
    inline void setFreeSpeed (bool FreeSpeed_);

    static const SpeedLimitStatus &getDefaultInstance();

private:

    inline void set_has_SpeedLimit1 ();

    inline void clear_has_SpeedLimit1 ();

    inline void set_has_SpeedLimit2 ();

    inline void clear_has_SpeedLimit2 ();

    inline void set_has_Display ();

    inline void clear_has_Display ();

    inline void set_has_DisplayUnit ();

    inline void clear_has_DisplayUnit ();

    inline void set_has_OverSpeed ();

    inline void clear_has_OverSpeed ();

    inline void set_has_FreeSpeed ();

    inline void clear_has_FreeSpeed ();

    uint32 _has_bits_[ (6 + 31) / 32];

    uint8 _SpeedLimit1;

    uint8 _SpeedLimit2;

    uint8 _Display;

    ::vehicle_main_fi_types::T_e8_Vehicle_DistanceUnit _DisplayUnit;

    bool _OverSpeed;

    bool _FreeSpeed;

};

/**
 * The status message of the property "ReverseGear"
 * ReverseGear Status read from the GPIO pin
 * <p>FUNCID = 0x1004,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class ReverseGearStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReverseGearStatus ();

    /**
     * Copy constructor
     */
    inline  ReverseGearStatus (const ReverseGearStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ReverseGearStatus (uint8 State_);

    /**
     * Destructor
     */
    inline virtual  ~ReverseGearStatus();

    /**
     * Assignment operator
     */
    inline ReverseGearStatus& operator = (const ReverseGearStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReverseGearStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReverseGearStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReverseGearStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReverseGearStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "State"

    static const int kState = 0;

    /**
     * Clears the field "State".
     *
     * The field will be set to its default value. The hasState()
     * method will return false.
     */
    inline void clearState();

    /**
     * Checks whether the field "State" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setState()). Otherwise it will return false.
     */
    inline bool hasState () const;

    /**
     * Returns the value of the member "State".
     *
     * <p>Reverse gear Information read from GPIO states</p>
     * <p>0x00 = Reverse Off</p>
     * <p>0x01 = Reverse ON</p>
     * <p>0xFF = Unknown Data</p>
     *
     * @return The value of the field "State"
     */
    inline uint8 getState () const;

    /**
     * Sets the value of the member "State".
     *
     * <p>Reverse gear Information read from GPIO states</p>
     * <p>0x00 = Reverse Off</p>
     * <p>0x01 = Reverse ON</p>
     * <p>0xFF = Unknown Data</p>
     *
     * @param State The value which will be set
     */
    inline void setState (uint8 State_);

    static const ReverseGearStatus &getDefaultInstance();

private:

    inline void set_has_State ();

    inline void clear_has_State ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _State;

};

/**
 * The status message of the property "SpeedLock"
 * SpeedLock status to the clients
 * <p>FUNCID = 0x1005,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class SpeedLockStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SpeedLockStatus ();

    /**
     * Copy constructor
     */
    inline  SpeedLockStatus (const SpeedLockStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SpeedLockStatus (uint8 State_);

    /**
     * Destructor
     */
    inline virtual  ~SpeedLockStatus();

    /**
     * Assignment operator
     */
    inline SpeedLockStatus& operator = (const SpeedLockStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SpeedLockStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SpeedLockStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SpeedLockStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SpeedLockStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "State"

    static const int kState = 0;

    /**
     * Clears the field "State".
     *
     * The field will be set to its default value. The hasState()
     * method will return false.
     */
    inline void clearState();

    /**
     * Checks whether the field "State" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setState()). Otherwise it will return false.
     */
    inline bool hasState () const;

    /**
     * Returns the value of the member "State".
     *
     * <p>Speedlock value from speed and min/max values</p>
     * <p>0x00 = Speedlock Off</p>
     * <p>0x01 = Speedlock ON</p>
     * <p>0xFE = Undefined/wrong speed limits (min/max not configured or unlogical values)</p>
     * <p>0xFF = Unknown/invalid Speed Data</p>
     *
     * @return The value of the field "State"
     */
    inline uint8 getState () const;

    /**
     * Sets the value of the member "State".
     *
     * <p>Speedlock value from speed and min/max values</p>
     * <p>0x00 = Speedlock Off</p>
     * <p>0x01 = Speedlock ON</p>
     * <p>0xFE = Undefined/wrong speed limits (min/max not configured or unlogical values)</p>
     * <p>0xFF = Unknown/invalid Speed Data</p>
     *
     * @param State The value which will be set
     */
    inline void setState (uint8 State_);

    static const SpeedLockStatus &getDefaultInstance();

private:

    inline void set_has_State ();

    inline void clear_has_State ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _State;

};

/**
 * The status message of the property "DrivingState"
 * Driving status update to the clients
 * <p>FUNCID = 0x1006,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class DrivingStateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DrivingStateStatus ();

    /**
     * Copy constructor
     */
    inline  DrivingStateStatus (const DrivingStateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DrivingStateStatus (uint8 State_);

    /**
     * Destructor
     */
    inline virtual  ~DrivingStateStatus();

    /**
     * Assignment operator
     */
    inline DrivingStateStatus& operator = (const DrivingStateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DrivingStateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DrivingStateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DrivingStateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DrivingStateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "State"

    static const int kState = 0;

    /**
     * Clears the field "State".
     *
     * The field will be set to its default value. The hasState()
     * method will return false.
     */
    inline void clearState();

    /**
     * Checks whether the field "State" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setState()). Otherwise it will return false.
     */
    inline bool hasState () const;

    /**
     * Returns the value of the member "State".
     *
     * <p>Driving Speed computation from speed</p>
     * <p>0x00 = If the speed is equal 0 km/h</p>
     * <p>0x01 = If the speed is greater than 0 km/h</p>
     * <p>0xFF = Unknown/invalid Speed Data</p>
     *
     * @return The value of the field "State"
     */
    inline uint8 getState () const;

    /**
     * Sets the value of the member "State".
     *
     * <p>Driving Speed computation from speed</p>
     * <p>0x00 = If the speed is equal 0 km/h</p>
     * <p>0x01 = If the speed is greater than 0 km/h</p>
     * <p>0xFF = Unknown/invalid Speed Data</p>
     *
     * @param State The value which will be set
     */
    inline void setState (uint8 State_);

    static const DrivingStateStatus &getDefaultInstance();

private:

    inline void set_has_State ();

    inline void clear_has_State ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _State;

};

/**
 * The status message of the property "GlobalVehicleWarningState"
 * GlobalVehicleWarning Status update to the clients
 * <p>FUNCID = 0x1007,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class GlobalVehicleWarningStateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GlobalVehicleWarningStateStatus ();

    /**
     * Copy constructor
     */
    inline  GlobalVehicleWarningStateStatus (const GlobalVehicleWarningStateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  GlobalVehicleWarningStateStatus (::vehicle_main_fi_types::T_e8_Vehicle_WarningState State_);

    /**
     * Destructor
     */
    inline virtual  ~GlobalVehicleWarningStateStatus();

    /**
     * Assignment operator
     */
    inline GlobalVehicleWarningStateStatus& operator = (const GlobalVehicleWarningStateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GlobalVehicleWarningStateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GlobalVehicleWarningStateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GlobalVehicleWarningStateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GlobalVehicleWarningStateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "State"

    static const int kState = 0;

    /**
     * Clears the field "State".
     *
     * The field will be set to its default value. The hasState()
     * method will return false.
     */
    inline void clearState();

    /**
     * Checks whether the field "State" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setState()). Otherwise it will return false.
     */
    inline bool hasState () const;

    /**
     * Returns the value of the member "State".
     *
     * <p>0x00 = No Global Vehicle Fault</p>
     * <p>0x01 = "SERV" is ON (alert type R3)</p>
     * <p>0x02 = "STOP" is ON (alter type D3)</p>
     * <p>0x03 = "SERV" and "STOP" are ON (alter type R3 and D3)</p>
     *
     * @return The value of the field "State"
     */
    inline ::vehicle_main_fi_types::T_e8_Vehicle_WarningState getState () const;

    /**
     * Sets the value of the member "State".
     *
     * <p>0x00 = No Global Vehicle Fault</p>
     * <p>0x01 = "SERV" is ON (alert type R3)</p>
     * <p>0x02 = "STOP" is ON (alter type D3)</p>
     * <p>0x03 = "SERV" and "STOP" are ON (alter type R3 and D3)</p>
     *
     * @param State The value which will be set
     */
    inline void setState (::vehicle_main_fi_types::T_e8_Vehicle_WarningState State_);

    static const GlobalVehicleWarningStateStatus &getDefaultInstance();

private:

    inline void set_has_State ();

    inline void clear_has_State ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::vehicle_main_fi_types::T_e8_Vehicle_WarningState _State;

};

/**
 * The status message of the property "VehicleStates"
 * VehicleState status update to the clients
 * <p>FUNCID = 0x1008,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class VehicleStatesStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VehicleStatesStatus ();

    /**
     * Copy constructor
     */
    inline  VehicleStatesStatus (const VehicleStatesStatus &rhs);

    /**
     * All fields constructor
     */
    inline  VehicleStatesStatus (::vehicle_main_fi_types::T_e8_Vehicle_States State_);

    /**
     * Destructor
     */
    inline virtual  ~VehicleStatesStatus();

    /**
     * Assignment operator
     */
    inline VehicleStatesStatus& operator = (const VehicleStatesStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VehicleStatesStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VehicleStatesStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VehicleStatesStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VehicleStatesStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "State"

    static const int kState = 0;

    /**
     * Clears the field "State".
     *
     * The field will be set to its default value. The hasState()
     * method will return false.
     */
    inline void clearState();

    /**
     * Checks whether the field "State" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setState()). Otherwise it will return false.
     */
    inline bool hasState () const;

    /**
     * Returns the value of the member "State".
     *
     * <p>0x00 = Sleeping</p>
     * <p>0x01 = Techinical WakeUp</p>
     * <p>0x02 = CutOff Pending</p>
     * <p>0x03 = AutoACC</p>
     * <p>0x04 = Not Used</p>
     * <p>0x05 = IgnitionLevel</p>
     * <p>0x06 = Starting In Progress</p>
     * <p>0x07 = Power Train Running</p>
     * <p>0x08 = AutoStart</p>
     * <p>0x09 = EngineSystemStop</p>
     * <p>0x0a = Not Used</p>
     * <p>0x0b = Not Used</p>
     * <p>0x0c = Not Used</p>
     * <p>0x0d = Not Used</p>
     * <p>0x0e = Not Used</p>
     * <p>0x0f = Unavailable</p>
     *
     * @return The value of the field "State"
     */
    inline ::vehicle_main_fi_types::T_e8_Vehicle_States getState () const;

    /**
     * Sets the value of the member "State".
     *
     * <p>0x00 = Sleeping</p>
     * <p>0x01 = Techinical WakeUp</p>
     * <p>0x02 = CutOff Pending</p>
     * <p>0x03 = AutoACC</p>
     * <p>0x04 = Not Used</p>
     * <p>0x05 = IgnitionLevel</p>
     * <p>0x06 = Starting In Progress</p>
     * <p>0x07 = Power Train Running</p>
     * <p>0x08 = AutoStart</p>
     * <p>0x09 = EngineSystemStop</p>
     * <p>0x0a = Not Used</p>
     * <p>0x0b = Not Used</p>
     * <p>0x0c = Not Used</p>
     * <p>0x0d = Not Used</p>
     * <p>0x0e = Not Used</p>
     * <p>0x0f = Unavailable</p>
     *
     * @param State The value which will be set
     */
    inline void setState (::vehicle_main_fi_types::T_e8_Vehicle_States State_);

    static const VehicleStatesStatus &getDefaultInstance();

private:

    inline void set_has_State ();

    inline void clear_has_State ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::vehicle_main_fi_types::T_e8_Vehicle_States _State;

};

/**
 * The status message of the property "PartialMute"
 * PartialMute Status update to the clients
 * <p>FUNCID = 0x1009,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class PartialMuteStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PartialMuteStatus ();

    /**
     * Copy constructor
     */
    inline  PartialMuteStatus (const PartialMuteStatus &rhs);

    /**
     * All fields constructor
     */
    inline  PartialMuteStatus (uint8 PartialMuteValue_);

    /**
     * Destructor
     */
    inline virtual  ~PartialMuteStatus();

    /**
     * Assignment operator
     */
    inline PartialMuteStatus& operator = (const PartialMuteStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PartialMuteStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PartialMuteStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PartialMuteStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PartialMuteStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PartialMuteValue"

    static const int kPartialMuteValue = 0;

    /**
     * Clears the field "PartialMuteValue".
     *
     * The field will be set to its default value. The hasPartialMuteValue()
     * method will return false.
     */
    inline void clearPartialMuteValue();

    /**
     * Checks whether the field "PartialMuteValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPartialMuteValue()). Otherwise it will return false.
     */
    inline bool hasPartialMuteValue () const;

    /**
     * Returns the value of the member "PartialMuteValue".
     *
     * <p>values varies from 0 to 10</p>
     *
     * @return The value of the field "PartialMuteValue"
     */
    inline uint8 getPartialMuteValue () const;

    /**
     * Sets the value of the member "PartialMuteValue".
     *
     * <p>values varies from 0 to 10</p>
     *
     * @param PartialMuteValue The value which will be set
     */
    inline void setPartialMuteValue (uint8 PartialMuteValue_);

    static const PartialMuteStatus &getDefaultInstance();

private:

    inline void set_has_PartialMuteValue ();

    inline void clear_has_PartialMuteValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _PartialMuteValue;

};

/**
 * The status message of the property "SwivMonAutoOpen"
 * Door close/open Status
 * <p>FUNCID = 0x100A,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class SwivMonAutoOpenStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SwivMonAutoOpenStatus ();

    /**
     * Copy constructor
     */
    inline  SwivMonAutoOpenStatus (const SwivMonAutoOpenStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SwivMonAutoOpenStatus (uint8 SwivMonAutoOpenValue_);

    /**
     * Destructor
     */
    inline virtual  ~SwivMonAutoOpenStatus();

    /**
     * Assignment operator
     */
    inline SwivMonAutoOpenStatus& operator = (const SwivMonAutoOpenStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SwivMonAutoOpenStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SwivMonAutoOpenStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SwivMonAutoOpenStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SwivMonAutoOpenStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SwivMonAutoOpenValue"

    static const int kSwivMonAutoOpenValue = 0;

    /**
     * Clears the field "SwivMonAutoOpenValue".
     *
     * The field will be set to its default value. The hasSwivMonAutoOpenValue()
     * method will return false.
     */
    inline void clearSwivMonAutoOpenValue();

    /**
     * Checks whether the field "SwivMonAutoOpenValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSwivMonAutoOpenValue()). Otherwise it will return false.
     */
    inline bool hasSwivMonAutoOpenValue () const;

    /**
     * Returns the value of the member "SwivMonAutoOpenValue".
     *
     * <p>Door close/open Status</p>
     * <p>0x00 = Door close</p>
     * <p>0x01 = Door Open</p>
     * <p>0xFF = Unknown Data</p>
     *
     * @return The value of the field "SwivMonAutoOpenValue"
     */
    inline uint8 getSwivMonAutoOpenValue () const;

    /**
     * Sets the value of the member "SwivMonAutoOpenValue".
     *
     * <p>Door close/open Status</p>
     * <p>0x00 = Door close</p>
     * <p>0x01 = Door Open</p>
     * <p>0xFF = Unknown Data</p>
     *
     * @param SwivMonAutoOpenValue The value which will be set
     */
    inline void setSwivMonAutoOpenValue (uint8 SwivMonAutoOpenValue_);

    static const SwivMonAutoOpenStatus &getDefaultInstance();

private:

    inline void set_has_SwivMonAutoOpenValue ();

    inline void clear_has_SwivMonAutoOpenValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _SwivMonAutoOpenValue;

};

/**
 * The status message of the property "DateMode"
 * Display Date Mode Current value
 * <p>FUNCID = 0x100B,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class DateModeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DateModeStatus ();

    /**
     * Copy constructor
     */
    inline  DateModeStatus (const DateModeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DateModeStatus (uint8 DateModeValue_);

    /**
     * Destructor
     */
    inline virtual  ~DateModeStatus();

    /**
     * Assignment operator
     */
    inline DateModeStatus& operator = (const DateModeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DateModeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DateModeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DateModeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DateModeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DateModeValue"

    static const int kDateModeValue = 0;

    /**
     * Clears the field "DateModeValue".
     *
     * The field will be set to its default value. The hasDateModeValue()
     * method will return false.
     */
    inline void clearDateModeValue();

    /**
     * Checks whether the field "DateModeValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDateModeValue()). Otherwise it will return false.
     */
    inline bool hasDateModeValue () const;

    /**
     * Returns the value of the member "DateModeValue".
     *
     * <p>Display Date Mode Current value</p>
     *
     * @return The value of the field "DateModeValue"
     */
    inline uint8 getDateModeValue () const;

    /**
     * Sets the value of the member "DateModeValue".
     *
     * <p>Display Date Mode Current value</p>
     *
     * @param DateModeValue The value which will be set
     */
    inline void setDateModeValue (uint8 DateModeValue_);

    static const DateModeStatus &getDefaultInstance();

private:

    inline void set_has_DateModeValue ();

    inline void clear_has_DateModeValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _DateModeValue;

};

/**
 * The status message of the property "TmMode"
 * Display Time Mode Current value
 * <p>FUNCID = 0x100C,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class TmModeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TmModeStatus ();

    /**
     * Copy constructor
     */
    inline  TmModeStatus (const TmModeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  TmModeStatus (uint8 TmModeValue_);

    /**
     * Destructor
     */
    inline virtual  ~TmModeStatus();

    /**
     * Assignment operator
     */
    inline TmModeStatus& operator = (const TmModeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TmModeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TmModeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TmModeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TmModeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TmModeValue"

    static const int kTmModeValue = 0;

    /**
     * Clears the field "TmModeValue".
     *
     * The field will be set to its default value. The hasTmModeValue()
     * method will return false.
     */
    inline void clearTmModeValue();

    /**
     * Checks whether the field "TmModeValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTmModeValue()). Otherwise it will return false.
     */
    inline bool hasTmModeValue () const;

    /**
     * Returns the value of the member "TmModeValue".
     *
     * <p>Display Time Mode Current value</p>
     *
     * @return The value of the field "TmModeValue"
     */
    inline uint8 getTmModeValue () const;

    /**
     * Sets the value of the member "TmModeValue".
     *
     * <p>Display Time Mode Current value</p>
     *
     * @param TmModeValue The value which will be set
     */
    inline void setTmModeValue (uint8 TmModeValue_);

    static const TmModeStatus &getDefaultInstance();

private:

    inline void set_has_TmModeValue ();

    inline void clear_has_TmModeValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _TmModeValue;

};

/**
 * The status message of the property "CamTxt"
 * CamTxt value update to clients
 * <p>FUNCID = 0x100D,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class CamTxtStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CamTxtStatus ();

    /**
     * Copy constructor
     */
    inline  CamTxtStatus (const CamTxtStatus &rhs);

    /**
     * All fields constructor
     */
    inline  CamTxtStatus (uint64 CamTxtValue_);

    /**
     * Destructor
     */
    inline virtual  ~CamTxtStatus();

    /**
     * Assignment operator
     */
    inline CamTxtStatus& operator = (const CamTxtStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CamTxtStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CamTxtStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CamTxtStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CamTxtStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CamTxtValue"

    static const int kCamTxtValue = 0;

    /**
     * Clears the field "CamTxtValue".
     *
     * The field will be set to its default value. The hasCamTxtValue()
     * method will return false.
     */
    inline void clearCamTxtValue();

    /**
     * Checks whether the field "CamTxtValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCamTxtValue()). Otherwise it will return false.
     */
    inline bool hasCamTxtValue () const;

    /**
     * Returns the value of the member "CamTxtValue".
     *
     * <p>CamTxt value update to clients</p>
     *
     * @return The value of the field "CamTxtValue"
     */
    inline uint64 getCamTxtValue () const;

    /**
     * Sets the value of the member "CamTxtValue".
     *
     * <p>CamTxt value update to clients</p>
     *
     * @param CamTxtValue The value which will be set
     */
    inline void setCamTxtValue (uint64 CamTxtValue_);

    static const CamTxtStatus &getDefaultInstance();

private:

    inline void set_has_CamTxtValue ();

    inline void clear_has_CamTxtValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint64 _CamTxtValue;

};

/**
 * The status message of the property "ActCam1"
 * Activate Cam1 requested state
 * <p>FUNCID = 0x100E,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class ActCam1Status  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActCam1Status ();

    /**
     * Copy constructor
     */
    inline  ActCam1Status (const ActCam1Status &rhs);

    /**
     * All fields constructor
     */
    inline  ActCam1Status (uint8 ActCam1Value_);

    /**
     * Destructor
     */
    inline virtual  ~ActCam1Status();

    /**
     * Assignment operator
     */
    inline ActCam1Status& operator = (const ActCam1Status& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActCam1Status& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActCam1Status& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActCam1Status& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActCam1Status& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ActCam1Value"

    static const int kActCam1Value = 0;

    /**
     * Clears the field "ActCam1Value".
     *
     * The field will be set to its default value. The hasActCam1Value()
     * method will return false.
     */
    inline void clearActCam1Value();

    /**
     * Checks whether the field "ActCam1Value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActCam1Value()). Otherwise it will return false.
     */
    inline bool hasActCam1Value () const;

    /**
     * Returns the value of the member "ActCam1Value".
     *
     * <p>Activate Cam1 requested state</p>
     *
     * @return The value of the field "ActCam1Value"
     */
    inline uint8 getActCam1Value () const;

    /**
     * Sets the value of the member "ActCam1Value".
     *
     * <p>Activate Cam1 requested state</p>
     *
     * @param ActCam1Value The value which will be set
     */
    inline void setActCam1Value (uint8 ActCam1Value_);

    static const ActCam1Status &getDefaultInstance();

private:

    inline void set_has_ActCam1Value ();

    inline void clear_has_ActCam1Value ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ActCam1Value;

};

/**
 * The status message of the property "ActCam2"
 * Activate Cam2 requested state
 * <p>FUNCID = 0x100F,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class ActCam2Status  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActCam2Status ();

    /**
     * Copy constructor
     */
    inline  ActCam2Status (const ActCam2Status &rhs);

    /**
     * All fields constructor
     */
    inline  ActCam2Status (uint8 ActCam2Value_);

    /**
     * Destructor
     */
    inline virtual  ~ActCam2Status();

    /**
     * Assignment operator
     */
    inline ActCam2Status& operator = (const ActCam2Status& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActCam2Status& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActCam2Status& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActCam2Status& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActCam2Status& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ActCam2Value"

    static const int kActCam2Value = 0;

    /**
     * Clears the field "ActCam2Value".
     *
     * The field will be set to its default value. The hasActCam2Value()
     * method will return false.
     */
    inline void clearActCam2Value();

    /**
     * Checks whether the field "ActCam2Value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActCam2Value()). Otherwise it will return false.
     */
    inline bool hasActCam2Value () const;

    /**
     * Returns the value of the member "ActCam2Value".
     *
     * <p>Activate Cam2 requested state</p>
     *
     * @return The value of the field "ActCam2Value"
     */
    inline uint8 getActCam2Value () const;

    /**
     * Sets the value of the member "ActCam2Value".
     *
     * <p>Activate Cam2 requested state</p>
     *
     * @param ActCam2Value The value which will be set
     */
    inline void setActCam2Value (uint8 ActCam2Value_);

    static const ActCam2Status &getDefaultInstance();

private:

    inline void set_has_ActCam2Value ();

    inline void clear_has_ActCam2Value ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ActCam2Value;

};

/**
 * The status message of the property "ActCam3"
 * Activate Cam3 requested state
 * <p>FUNCID = 0x1010,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class ActCam3Status  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActCam3Status ();

    /**
     * Copy constructor
     */
    inline  ActCam3Status (const ActCam3Status &rhs);

    /**
     * All fields constructor
     */
    inline  ActCam3Status (uint8 ActCam3Value_);

    /**
     * Destructor
     */
    inline virtual  ~ActCam3Status();

    /**
     * Assignment operator
     */
    inline ActCam3Status& operator = (const ActCam3Status& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActCam3Status& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActCam3Status& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActCam3Status& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActCam3Status& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ActCam3Value"

    static const int kActCam3Value = 0;

    /**
     * Clears the field "ActCam3Value".
     *
     * The field will be set to its default value. The hasActCam3Value()
     * method will return false.
     */
    inline void clearActCam3Value();

    /**
     * Checks whether the field "ActCam3Value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActCam3Value()). Otherwise it will return false.
     */
    inline bool hasActCam3Value () const;

    /**
     * Returns the value of the member "ActCam3Value".
     *
     * <p>Activate Cam3 requested state</p>
     *
     * @return The value of the field "ActCam3Value"
     */
    inline uint8 getActCam3Value () const;

    /**
     * Sets the value of the member "ActCam3Value".
     *
     * <p>Activate Cam3 requested state</p>
     *
     * @param ActCam3Value The value which will be set
     */
    inline void setActCam3Value (uint8 ActCam3Value_);

    static const ActCam3Status &getDefaultInstance();

private:

    inline void set_has_ActCam3Value ();

    inline void clear_has_ActCam3Value ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ActCam3Value;

};

/**
 * The status message of the property "ActCam4"
 * Activate Cam4 requested state
 * <p>FUNCID = 0x1011,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class ActCam4Status  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActCam4Status ();

    /**
     * Copy constructor
     */
    inline  ActCam4Status (const ActCam4Status &rhs);

    /**
     * All fields constructor
     */
    inline  ActCam4Status (uint8 ActCam4Value_);

    /**
     * Destructor
     */
    inline virtual  ~ActCam4Status();

    /**
     * Assignment operator
     */
    inline ActCam4Status& operator = (const ActCam4Status& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActCam4Status& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActCam4Status& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActCam4Status& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActCam4Status& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ActCam4Value"

    static const int kActCam4Value = 0;

    /**
     * Clears the field "ActCam4Value".
     *
     * The field will be set to its default value. The hasActCam4Value()
     * method will return false.
     */
    inline void clearActCam4Value();

    /**
     * Checks whether the field "ActCam4Value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActCam4Value()). Otherwise it will return false.
     */
    inline bool hasActCam4Value () const;

    /**
     * Returns the value of the member "ActCam4Value".
     *
     * <p>Activate Cam4 requested state</p>
     *
     * @return The value of the field "ActCam4Value"
     */
    inline uint8 getActCam4Value () const;

    /**
     * Sets the value of the member "ActCam4Value".
     *
     * <p>Activate Cam4 requested state</p>
     *
     * @param ActCam4Value The value which will be set
     */
    inline void setActCam4Value (uint8 ActCam4Value_);

    static const ActCam4Status &getDefaultInstance();

private:

    inline void set_has_ActCam4Value ();

    inline void clear_has_ActCam4Value ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ActCam4Value;

};

/**
 * The status message of the property "ActCam5"
 * Activate Cam5 requested state
 * <p>FUNCID = 0x1012,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class ActCam5Status  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActCam5Status ();

    /**
     * Copy constructor
     */
    inline  ActCam5Status (const ActCam5Status &rhs);

    /**
     * All fields constructor
     */
    inline  ActCam5Status (uint8 ActCam5Value_);

    /**
     * Destructor
     */
    inline virtual  ~ActCam5Status();

    /**
     * Assignment operator
     */
    inline ActCam5Status& operator = (const ActCam5Status& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActCam5Status& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActCam5Status& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActCam5Status& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActCam5Status& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ActCam5Value"

    static const int kActCam5Value = 0;

    /**
     * Clears the field "ActCam5Value".
     *
     * The field will be set to its default value. The hasActCam5Value()
     * method will return false.
     */
    inline void clearActCam5Value();

    /**
     * Checks whether the field "ActCam5Value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActCam5Value()). Otherwise it will return false.
     */
    inline bool hasActCam5Value () const;

    /**
     * Returns the value of the member "ActCam5Value".
     *
     * <p>Activate Cam5 requested state</p>
     *
     * @return The value of the field "ActCam5Value"
     */
    inline uint8 getActCam5Value () const;

    /**
     * Sets the value of the member "ActCam5Value".
     *
     * <p>Activate Cam5 requested state</p>
     *
     * @param ActCam5Value The value which will be set
     */
    inline void setActCam5Value (uint8 ActCam5Value_);

    static const ActCam5Status &getDefaultInstance();

private:

    inline void set_has_ActCam5Value ();

    inline void clear_has_ActCam5Value ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ActCam5Value;

};

/**
 * The status message of the property "ActCam6"
 * Activate Cam6 requested state
 * <p>FUNCID = 0x1013,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class ActCam6Status  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActCam6Status ();

    /**
     * Copy constructor
     */
    inline  ActCam6Status (const ActCam6Status &rhs);

    /**
     * All fields constructor
     */
    inline  ActCam6Status (uint8 ActCam6Value_);

    /**
     * Destructor
     */
    inline virtual  ~ActCam6Status();

    /**
     * Assignment operator
     */
    inline ActCam6Status& operator = (const ActCam6Status& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActCam6Status& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActCam6Status& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActCam6Status& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActCam6Status& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ActCam6Value"

    static const int kActCam6Value = 0;

    /**
     * Clears the field "ActCam6Value".
     *
     * The field will be set to its default value. The hasActCam6Value()
     * method will return false.
     */
    inline void clearActCam6Value();

    /**
     * Checks whether the field "ActCam6Value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActCam6Value()). Otherwise it will return false.
     */
    inline bool hasActCam6Value () const;

    /**
     * Returns the value of the member "ActCam6Value".
     *
     * <p>Activate Cam6 requested state</p>
     *
     * @return The value of the field "ActCam6Value"
     */
    inline uint8 getActCam6Value () const;

    /**
     * Sets the value of the member "ActCam6Value".
     *
     * <p>Activate Cam6 requested state</p>
     *
     * @param ActCam6Value The value which will be set
     */
    inline void setActCam6Value (uint8 ActCam6Value_);

    static const ActCam6Status &getDefaultInstance();

private:

    inline void set_has_ActCam6Value ();

    inline void clear_has_ActCam6Value ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ActCam6Value;

};

/**
 * The status message of the property "ActCam7"
 * Activate Cam7 requested state
 * <p>FUNCID = 0x1014,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class ActCam7Status  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActCam7Status ();

    /**
     * Copy constructor
     */
    inline  ActCam7Status (const ActCam7Status &rhs);

    /**
     * All fields constructor
     */
    inline  ActCam7Status (uint8 ActCam7Value_);

    /**
     * Destructor
     */
    inline virtual  ~ActCam7Status();

    /**
     * Assignment operator
     */
    inline ActCam7Status& operator = (const ActCam7Status& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActCam7Status& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActCam7Status& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActCam7Status& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActCam7Status& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ActCam7Value"

    static const int kActCam7Value = 0;

    /**
     * Clears the field "ActCam7Value".
     *
     * The field will be set to its default value. The hasActCam7Value()
     * method will return false.
     */
    inline void clearActCam7Value();

    /**
     * Checks whether the field "ActCam7Value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActCam7Value()). Otherwise it will return false.
     */
    inline bool hasActCam7Value () const;

    /**
     * Returns the value of the member "ActCam7Value".
     *
     * <p>Activate Cam7 requested state</p>
     *
     * @return The value of the field "ActCam7Value"
     */
    inline uint8 getActCam7Value () const;

    /**
     * Sets the value of the member "ActCam7Value".
     *
     * <p>Activate Cam7 requested state</p>
     *
     * @param ActCam7Value The value which will be set
     */
    inline void setActCam7Value (uint8 ActCam7Value_);

    static const ActCam7Status &getDefaultInstance();

private:

    inline void set_has_ActCam7Value ();

    inline void clear_has_ActCam7Value ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ActCam7Value;

};

/**
 * The status message of the property "DriverDoorOpen"
 * Driver Door close/open Status
 * <p>FUNCID = 0x1037,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class DriverDoorOpenStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DriverDoorOpenStatus ();

    /**
     * Copy constructor
     */
    inline  DriverDoorOpenStatus (const DriverDoorOpenStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DriverDoorOpenStatus (uint8 DriverDoorOpenValue_);

    /**
     * Destructor
     */
    inline virtual  ~DriverDoorOpenStatus();

    /**
     * Assignment operator
     */
    inline DriverDoorOpenStatus& operator = (const DriverDoorOpenStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DriverDoorOpenStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DriverDoorOpenStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DriverDoorOpenStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DriverDoorOpenStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DriverDoorOpenValue"

    static const int kDriverDoorOpenValue = 0;

    /**
     * Clears the field "DriverDoorOpenValue".
     *
     * The field will be set to its default value. The hasDriverDoorOpenValue()
     * method will return false.
     */
    inline void clearDriverDoorOpenValue();

    /**
     * Checks whether the field "DriverDoorOpenValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDriverDoorOpenValue()). Otherwise it will return false.
     */
    inline bool hasDriverDoorOpenValue () const;

    /**
     * Returns the value of the member "DriverDoorOpenValue".
     *
     * <p>Driver Door close/open Status</p>
     * <p>0x00 = Door close</p>
     * <p>0x01 = Door Open</p>
     * <p>0xFF = Unknown Data</p>
     *
     * @return The value of the field "DriverDoorOpenValue"
     */
    inline uint8 getDriverDoorOpenValue () const;

    /**
     * Sets the value of the member "DriverDoorOpenValue".
     *
     * <p>Driver Door close/open Status</p>
     * <p>0x00 = Door close</p>
     * <p>0x01 = Door Open</p>
     * <p>0xFF = Unknown Data</p>
     *
     * @param DriverDoorOpenValue The value which will be set
     */
    inline void setDriverDoorOpenValue (uint8 DriverDoorOpenValue_);

    static const DriverDoorOpenStatus &getDefaultInstance();

private:

    inline void set_has_DriverDoorOpenValue ();

    inline void clear_has_DriverDoorOpenValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _DriverDoorOpenValue;

};

/**
 * The status message of the property "ActCam8"
 * Activate Cam8 requested state
 * <p>FUNCID = 0x102A,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class ActCam8Status  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActCam8Status ();

    /**
     * Copy constructor
     */
    inline  ActCam8Status (const ActCam8Status &rhs);

    /**
     * All fields constructor
     */
    inline  ActCam8Status (uint8 ActCam8Value_);

    /**
     * Destructor
     */
    inline virtual  ~ActCam8Status();

    /**
     * Assignment operator
     */
    inline ActCam8Status& operator = (const ActCam8Status& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActCam8Status& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActCam8Status& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActCam8Status& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActCam8Status& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ActCam8Value"

    static const int kActCam8Value = 0;

    /**
     * Clears the field "ActCam8Value".
     *
     * The field will be set to its default value. The hasActCam8Value()
     * method will return false.
     */
    inline void clearActCam8Value();

    /**
     * Checks whether the field "ActCam8Value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActCam8Value()). Otherwise it will return false.
     */
    inline bool hasActCam8Value () const;

    /**
     * Returns the value of the member "ActCam8Value".
     *
     * <p>Activate Cam8 requested state</p>
     *
     * @return The value of the field "ActCam8Value"
     */
    inline uint8 getActCam8Value () const;

    /**
     * Sets the value of the member "ActCam8Value".
     *
     * <p>Activate Cam8 requested state</p>
     *
     * @param ActCam8Value The value which will be set
     */
    inline void setActCam8Value (uint8 ActCam8Value_);

    static const ActCam8Status &getDefaultInstance();

private:

    inline void set_has_ActCam8Value ();

    inline void clear_has_ActCam8Value ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ActCam8Value;

};

/**
 * The status message of the property "ActCam9"
 * Activate Cam9 requested state
 * <p>FUNCID = 0x102B,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class ActCam9Status  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActCam9Status ();

    /**
     * Copy constructor
     */
    inline  ActCam9Status (const ActCam9Status &rhs);

    /**
     * All fields constructor
     */
    inline  ActCam9Status (uint8 ActCam9Value_);

    /**
     * Destructor
     */
    inline virtual  ~ActCam9Status();

    /**
     * Assignment operator
     */
    inline ActCam9Status& operator = (const ActCam9Status& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActCam9Status& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActCam9Status& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActCam9Status& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActCam9Status& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ActCam9Value"

    static const int kActCam9Value = 0;

    /**
     * Clears the field "ActCam9Value".
     *
     * The field will be set to its default value. The hasActCam9Value()
     * method will return false.
     */
    inline void clearActCam9Value();

    /**
     * Checks whether the field "ActCam9Value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActCam9Value()). Otherwise it will return false.
     */
    inline bool hasActCam9Value () const;

    /**
     * Returns the value of the member "ActCam9Value".
     *
     * <p>Activate Cam9 requested state</p>
     *
     * @return The value of the field "ActCam9Value"
     */
    inline uint8 getActCam9Value () const;

    /**
     * Sets the value of the member "ActCam9Value".
     *
     * <p>Activate Cam9 requested state</p>
     *
     * @param ActCam9Value The value which will be set
     */
    inline void setActCam9Value (uint8 ActCam9Value_);

    static const ActCam9Status &getDefaultInstance();

private:

    inline void set_has_ActCam9Value ();

    inline void clear_has_ActCam9Value ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ActCam9Value;

};

/**
 * The status message of the property "ActCam10"
 * Activate Cam10 requested state
 * <p>FUNCID = 0x102C,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class ActCam10Status  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActCam10Status ();

    /**
     * Copy constructor
     */
    inline  ActCam10Status (const ActCam10Status &rhs);

    /**
     * All fields constructor
     */
    inline  ActCam10Status (uint8 ActCam10Value_);

    /**
     * Destructor
     */
    inline virtual  ~ActCam10Status();

    /**
     * Assignment operator
     */
    inline ActCam10Status& operator = (const ActCam10Status& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActCam10Status& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActCam10Status& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActCam10Status& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActCam10Status& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ActCam10Value"

    static const int kActCam10Value = 0;

    /**
     * Clears the field "ActCam10Value".
     *
     * The field will be set to its default value. The hasActCam10Value()
     * method will return false.
     */
    inline void clearActCam10Value();

    /**
     * Checks whether the field "ActCam10Value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActCam10Value()). Otherwise it will return false.
     */
    inline bool hasActCam10Value () const;

    /**
     * Returns the value of the member "ActCam10Value".
     *
     * <p>Activate Cam10 requested state</p>
     *
     * @return The value of the field "ActCam10Value"
     */
    inline uint8 getActCam10Value () const;

    /**
     * Sets the value of the member "ActCam10Value".
     *
     * <p>Activate Cam10 requested state</p>
     *
     * @param ActCam10Value The value which will be set
     */
    inline void setActCam10Value (uint8 ActCam10Value_);

    static const ActCam10Status &getDefaultInstance();

private:

    inline void set_has_ActCam10Value ();

    inline void clear_has_ActCam10Value ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ActCam10Value;

};

/**
 * The status message of the property "ActCam11"
 * Activate Cam11 requested state
 * <p>FUNCID = 0x102D,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class ActCam11Status  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActCam11Status ();

    /**
     * Copy constructor
     */
    inline  ActCam11Status (const ActCam11Status &rhs);

    /**
     * All fields constructor
     */
    inline  ActCam11Status (uint8 ActCam11Value_);

    /**
     * Destructor
     */
    inline virtual  ~ActCam11Status();

    /**
     * Assignment operator
     */
    inline ActCam11Status& operator = (const ActCam11Status& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActCam11Status& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActCam11Status& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActCam11Status& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActCam11Status& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ActCam11Value"

    static const int kActCam11Value = 0;

    /**
     * Clears the field "ActCam11Value".
     *
     * The field will be set to its default value. The hasActCam11Value()
     * method will return false.
     */
    inline void clearActCam11Value();

    /**
     * Checks whether the field "ActCam11Value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActCam11Value()). Otherwise it will return false.
     */
    inline bool hasActCam11Value () const;

    /**
     * Returns the value of the member "ActCam11Value".
     *
     * <p>Activate Cam11 requested state</p>
     *
     * @return The value of the field "ActCam11Value"
     */
    inline uint8 getActCam11Value () const;

    /**
     * Sets the value of the member "ActCam11Value".
     *
     * <p>Activate Cam11 requested state</p>
     *
     * @param ActCam11Value The value which will be set
     */
    inline void setActCam11Value (uint8 ActCam11Value_);

    static const ActCam11Status &getDefaultInstance();

private:

    inline void set_has_ActCam11Value ();

    inline void clear_has_ActCam11Value ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ActCam11Value;

};

/**
 * The status message of the property "ActCam12"
 * Activate Cam12 requested state
 * <p>FUNCID = 0x102E,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class ActCam12Status  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActCam12Status ();

    /**
     * Copy constructor
     */
    inline  ActCam12Status (const ActCam12Status &rhs);

    /**
     * All fields constructor
     */
    inline  ActCam12Status (uint8 ActCam12Value_);

    /**
     * Destructor
     */
    inline virtual  ~ActCam12Status();

    /**
     * Assignment operator
     */
    inline ActCam12Status& operator = (const ActCam12Status& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActCam12Status& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActCam12Status& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActCam12Status& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActCam12Status& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ActCam12Value"

    static const int kActCam12Value = 0;

    /**
     * Clears the field "ActCam12Value".
     *
     * The field will be set to its default value. The hasActCam12Value()
     * method will return false.
     */
    inline void clearActCam12Value();

    /**
     * Checks whether the field "ActCam12Value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActCam12Value()). Otherwise it will return false.
     */
    inline bool hasActCam12Value () const;

    /**
     * Returns the value of the member "ActCam12Value".
     *
     * <p>Activate Cam12 requested state</p>
     *
     * @return The value of the field "ActCam12Value"
     */
    inline uint8 getActCam12Value () const;

    /**
     * Sets the value of the member "ActCam12Value".
     *
     * <p>Activate Cam12 requested state</p>
     *
     * @param ActCam12Value The value which will be set
     */
    inline void setActCam12Value (uint8 ActCam12Value_);

    static const ActCam12Status &getDefaultInstance();

private:

    inline void set_has_ActCam12Value ();

    inline void clear_has_ActCam12Value ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ActCam12Value;

};

/**
 * The status message of the property "ActCam13"
 * Activate Cam13 requested state
 * <p>FUNCID = 0x102F,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class ActCam13Status  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActCam13Status ();

    /**
     * Copy constructor
     */
    inline  ActCam13Status (const ActCam13Status &rhs);

    /**
     * All fields constructor
     */
    inline  ActCam13Status (uint8 ActCam13Value_);

    /**
     * Destructor
     */
    inline virtual  ~ActCam13Status();

    /**
     * Assignment operator
     */
    inline ActCam13Status& operator = (const ActCam13Status& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActCam13Status& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActCam13Status& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActCam13Status& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActCam13Status& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ActCam13Value"

    static const int kActCam13Value = 0;

    /**
     * Clears the field "ActCam13Value".
     *
     * The field will be set to its default value. The hasActCam13Value()
     * method will return false.
     */
    inline void clearActCam13Value();

    /**
     * Checks whether the field "ActCam13Value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActCam13Value()). Otherwise it will return false.
     */
    inline bool hasActCam13Value () const;

    /**
     * Returns the value of the member "ActCam13Value".
     *
     * <p>Activate Cam13 requested state</p>
     *
     * @return The value of the field "ActCam13Value"
     */
    inline uint8 getActCam13Value () const;

    /**
     * Sets the value of the member "ActCam13Value".
     *
     * <p>Activate Cam13 requested state</p>
     *
     * @param ActCam13Value The value which will be set
     */
    inline void setActCam13Value (uint8 ActCam13Value_);

    static const ActCam13Status &getDefaultInstance();

private:

    inline void set_has_ActCam13Value ();

    inline void clear_has_ActCam13Value ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ActCam13Value;

};

/**
 * The status message of the property "ActCam14"
 * Activate Cam14 requested state
 * <p>FUNCID = 0x1030,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class ActCam14Status  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActCam14Status ();

    /**
     * Copy constructor
     */
    inline  ActCam14Status (const ActCam14Status &rhs);

    /**
     * All fields constructor
     */
    inline  ActCam14Status (uint8 ActCam14Value_);

    /**
     * Destructor
     */
    inline virtual  ~ActCam14Status();

    /**
     * Assignment operator
     */
    inline ActCam14Status& operator = (const ActCam14Status& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActCam14Status& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActCam14Status& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActCam14Status& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActCam14Status& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ActCam14Value"

    static const int kActCam14Value = 0;

    /**
     * Clears the field "ActCam14Value".
     *
     * The field will be set to its default value. The hasActCam14Value()
     * method will return false.
     */
    inline void clearActCam14Value();

    /**
     * Checks whether the field "ActCam14Value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActCam14Value()). Otherwise it will return false.
     */
    inline bool hasActCam14Value () const;

    /**
     * Returns the value of the member "ActCam14Value".
     *
     * <p>Activate Cam14 requested state</p>
     *
     * @return The value of the field "ActCam14Value"
     */
    inline uint8 getActCam14Value () const;

    /**
     * Sets the value of the member "ActCam14Value".
     *
     * <p>Activate Cam14 requested state</p>
     *
     * @param ActCam14Value The value which will be set
     */
    inline void setActCam14Value (uint8 ActCam14Value_);

    static const ActCam14Status &getDefaultInstance();

private:

    inline void set_has_ActCam14Value ();

    inline void clear_has_ActCam14Value ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ActCam14Value;

};

/**
 * The status message of the property "ActCam15"
 * Activate Cam15 requested state
 * <p>FUNCID = 0x1031,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class ActCam15Status  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActCam15Status ();

    /**
     * Copy constructor
     */
    inline  ActCam15Status (const ActCam15Status &rhs);

    /**
     * All fields constructor
     */
    inline  ActCam15Status (uint8 ActCam15Value_);

    /**
     * Destructor
     */
    inline virtual  ~ActCam15Status();

    /**
     * Assignment operator
     */
    inline ActCam15Status& operator = (const ActCam15Status& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActCam15Status& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActCam15Status& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActCam15Status& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActCam15Status& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ActCam15Value"

    static const int kActCam15Value = 0;

    /**
     * Clears the field "ActCam15Value".
     *
     * The field will be set to its default value. The hasActCam15Value()
     * method will return false.
     */
    inline void clearActCam15Value();

    /**
     * Checks whether the field "ActCam15Value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActCam15Value()). Otherwise it will return false.
     */
    inline bool hasActCam15Value () const;

    /**
     * Returns the value of the member "ActCam15Value".
     *
     * <p>Activate Cam15 requested state</p>
     *
     * @return The value of the field "ActCam15Value"
     */
    inline uint8 getActCam15Value () const;

    /**
     * Sets the value of the member "ActCam15Value".
     *
     * <p>Activate Cam15 requested state</p>
     *
     * @param ActCam15Value The value which will be set
     */
    inline void setActCam15Value (uint8 ActCam15Value_);

    static const ActCam15Status &getDefaultInstance();

private:

    inline void set_has_ActCam15Value ();

    inline void clear_has_ActCam15Value ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ActCam15Value;

};

/**
 * The status message of the property "ActCam16"
 * Activate Cam16 requested state
 * <p>FUNCID = 0x1032,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class ActCam16Status  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActCam16Status ();

    /**
     * Copy constructor
     */
    inline  ActCam16Status (const ActCam16Status &rhs);

    /**
     * All fields constructor
     */
    inline  ActCam16Status (uint8 ActCam16Value_);

    /**
     * Destructor
     */
    inline virtual  ~ActCam16Status();

    /**
     * Assignment operator
     */
    inline ActCam16Status& operator = (const ActCam16Status& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActCam16Status& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActCam16Status& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActCam16Status& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActCam16Status& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ActCam16Value"

    static const int kActCam16Value = 0;

    /**
     * Clears the field "ActCam16Value".
     *
     * The field will be set to its default value. The hasActCam16Value()
     * method will return false.
     */
    inline void clearActCam16Value();

    /**
     * Checks whether the field "ActCam16Value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActCam16Value()). Otherwise it will return false.
     */
    inline bool hasActCam16Value () const;

    /**
     * Returns the value of the member "ActCam16Value".
     *
     * <p>Activate Cam16 requested state</p>
     *
     * @return The value of the field "ActCam16Value"
     */
    inline uint8 getActCam16Value () const;

    /**
     * Sets the value of the member "ActCam16Value".
     *
     * <p>Activate Cam16 requested state</p>
     *
     * @param ActCam16Value The value which will be set
     */
    inline void setActCam16Value (uint8 ActCam16Value_);

    static const ActCam16Status &getDefaultInstance();

private:

    inline void set_has_ActCam16Value ();

    inline void clear_has_ActCam16Value ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ActCam16Value;

};

/**
 * The status message of the property "ActCam17"
 * Activate Cam17 requested state
 * <p>FUNCID = 0x1033,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class ActCam17Status  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActCam17Status ();

    /**
     * Copy constructor
     */
    inline  ActCam17Status (const ActCam17Status &rhs);

    /**
     * All fields constructor
     */
    inline  ActCam17Status (uint8 ActCam17Value_);

    /**
     * Destructor
     */
    inline virtual  ~ActCam17Status();

    /**
     * Assignment operator
     */
    inline ActCam17Status& operator = (const ActCam17Status& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActCam17Status& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActCam17Status& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActCam17Status& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActCam17Status& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ActCam17Value"

    static const int kActCam17Value = 0;

    /**
     * Clears the field "ActCam17Value".
     *
     * The field will be set to its default value. The hasActCam17Value()
     * method will return false.
     */
    inline void clearActCam17Value();

    /**
     * Checks whether the field "ActCam17Value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActCam17Value()). Otherwise it will return false.
     */
    inline bool hasActCam17Value () const;

    /**
     * Returns the value of the member "ActCam17Value".
     *
     * <p>Activate Cam17 requested state</p>
     *
     * @return The value of the field "ActCam17Value"
     */
    inline uint8 getActCam17Value () const;

    /**
     * Sets the value of the member "ActCam17Value".
     *
     * <p>Activate Cam17 requested state</p>
     *
     * @param ActCam17Value The value which will be set
     */
    inline void setActCam17Value (uint8 ActCam17Value_);

    static const ActCam17Status &getDefaultInstance();

private:

    inline void set_has_ActCam17Value ();

    inline void clear_has_ActCam17Value ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ActCam17Value;

};

/**
 * The status message of the property "CamSplitQuad"
 * CAM Split Quad Current Status
 * <p>FUNCID = 0x1015,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class CamSplitQuadStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CamSplitQuadStatus ();

    /**
     * Copy constructor
     */
    inline  CamSplitQuadStatus (const CamSplitQuadStatus &rhs);

    /**
     * All fields constructor
     */
    inline  CamSplitQuadStatus (uint8 CamSplitQuadValue_);

    /**
     * Destructor
     */
    inline virtual  ~CamSplitQuadStatus();

    /**
     * Assignment operator
     */
    inline CamSplitQuadStatus& operator = (const CamSplitQuadStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CamSplitQuadStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CamSplitQuadStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CamSplitQuadStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CamSplitQuadStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CamSplitQuadValue"

    static const int kCamSplitQuadValue = 0;

    /**
     * Clears the field "CamSplitQuadValue".
     *
     * The field will be set to its default value. The hasCamSplitQuadValue()
     * method will return false.
     */
    inline void clearCamSplitQuadValue();

    /**
     * Checks whether the field "CamSplitQuadValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCamSplitQuadValue()). Otherwise it will return false.
     */
    inline bool hasCamSplitQuadValue () const;

    /**
     * Returns the value of the member "CamSplitQuadValue".
     *
     * <p>CAM Split Quad Current Status</p>
     *
     * @return The value of the field "CamSplitQuadValue"
     */
    inline uint8 getCamSplitQuadValue () const;

    /**
     * Sets the value of the member "CamSplitQuadValue".
     *
     * <p>CAM Split Quad Current Status</p>
     *
     * @param CamSplitQuadValue The value which will be set
     */
    inline void setCamSplitQuadValue (uint8 CamSplitQuadValue_);

    static const CamSplitQuadStatus &getDefaultInstance();

private:

    inline void set_has_CamSplitQuadValue ();

    inline void clear_has_CamSplitQuadValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _CamSplitQuadValue;

};

/**
 * The status message of the property "MuteDev"
 * MuteDev Status update to the clients
 * <p>FUNCID = 0x1016,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class MuteDevStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MuteDevStatus ();

    /**
     * Copy constructor
     */
    inline  MuteDevStatus (const MuteDevStatus &rhs);

    /**
     * All fields constructor
     */
    inline  MuteDevStatus (uint8 MuteDevStatus_);

    /**
     * Destructor
     */
    inline virtual  ~MuteDevStatus();

    /**
     * Assignment operator
     */
    inline MuteDevStatus& operator = (const MuteDevStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MuteDevStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MuteDevStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MuteDevStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MuteDevStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MuteDevStatus"

    static const int kMuteDevStatus = 0;

    /**
     * Clears the field "MuteDevStatus".
     *
     * The field will be set to its default value. The hasMuteDevStatus()
     * method will return false.
     */
    inline void clearMuteDevStatus();

    /**
     * Checks whether the field "MuteDevStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMuteDevStatus()). Otherwise it will return false.
     */
    inline bool hasMuteDevStatus () const;

    /**
     * Returns the value of the member "MuteDevStatus".
     *
     * <p>values varies between 0 and 1</p>
     *
     * @return The value of the field "MuteDevStatus"
     */
    inline uint8 getMuteDevStatus () const;

    /**
     * Sets the value of the member "MuteDevStatus".
     *
     * <p>values varies between 0 and 1</p>
     *
     * @param MuteDevStatus The value which will be set
     */
    inline void setMuteDevStatus (uint8 MuteDevStatus_);

    static const MuteDevStatus &getDefaultInstance();

private:

    inline void set_has_MuteDevStatus ();

    inline void clear_has_MuteDevStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _MuteDevStatus;

};

/**
 * The status message of the property "SysVolt"
 * System voltage Status update to the clients
 * <p>FUNCID = 0x1017,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class SysVoltStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SysVoltStatus ();

    /**
     * Copy constructor
     */
    inline  SysVoltStatus (const SysVoltStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SysVoltStatus (uint8 SysVoltStatus_);

    /**
     * Destructor
     */
    inline virtual  ~SysVoltStatus();

    /**
     * Assignment operator
     */
    inline SysVoltStatus& operator = (const SysVoltStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SysVoltStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SysVoltStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SysVoltStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SysVoltStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SysVoltStatus"

    static const int kSysVoltStatus = 0;

    /**
     * Clears the field "SysVoltStatus".
     *
     * The field will be set to its default value. The hasSysVoltStatus()
     * method will return false.
     */
    inline void clearSysVoltStatus();

    /**
     * Checks whether the field "SysVoltStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSysVoltStatus()). Otherwise it will return false.
     */
    inline bool hasSysVoltStatus () const;

    /**
     * Returns the value of the member "SysVoltStatus".
     *
     * <p>System voltage Status update to the clients</p>
     *
     * @return The value of the field "SysVoltStatus"
     */
    inline uint8 getSysVoltStatus () const;

    /**
     * Sets the value of the member "SysVoltStatus".
     *
     * <p>System voltage Status update to the clients</p>
     *
     * @param SysVoltStatus The value which will be set
     */
    inline void setSysVoltStatus (uint8 SysVoltStatus_);

    static const SysVoltStatus &getDefaultInstance();

private:

    inline void set_has_SysVoltStatus ();

    inline void clear_has_SysVoltStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _SysVoltStatus;

};

/**
 * The status message of the property "ParkingBreakSwitch"
 * Parking Break Switch Status update to the clients
 * <p>FUNCID = 0x1018,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class ParkingBreakSwitchStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ParkingBreakSwitchStatus ();

    /**
     * Copy constructor
     */
    inline  ParkingBreakSwitchStatus (const ParkingBreakSwitchStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ParkingBreakSwitchStatus (uint8 ParkingBreakSwitchValue_);

    /**
     * Destructor
     */
    inline virtual  ~ParkingBreakSwitchStatus();

    /**
     * Assignment operator
     */
    inline ParkingBreakSwitchStatus& operator = (const ParkingBreakSwitchStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ParkingBreakSwitchStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ParkingBreakSwitchStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ParkingBreakSwitchStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ParkingBreakSwitchStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ParkingBreakSwitchValue"

    static const int kParkingBreakSwitchValue = 0;

    /**
     * Clears the field "ParkingBreakSwitchValue".
     *
     * The field will be set to its default value. The hasParkingBreakSwitchValue()
     * method will return false.
     */
    inline void clearParkingBreakSwitchValue();

    /**
     * Checks whether the field "ParkingBreakSwitchValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setParkingBreakSwitchValue()). Otherwise it will return false.
     */
    inline bool hasParkingBreakSwitchValue () const;

    /**
     * Returns the value of the member "ParkingBreakSwitchValue".
     *
     * <p>Parking Break Switch Status update to the clients</p>
     *
     * @return The value of the field "ParkingBreakSwitchValue"
     */
    inline uint8 getParkingBreakSwitchValue () const;

    /**
     * Sets the value of the member "ParkingBreakSwitchValue".
     *
     * <p>Parking Break Switch Status update to the clients</p>
     *
     * @param ParkingBreakSwitchValue The value which will be set
     */
    inline void setParkingBreakSwitchValue (uint8 ParkingBreakSwitchValue_);

    static const ParkingBreakSwitchStatus &getDefaultInstance();

private:

    inline void set_has_ParkingBreakSwitchValue ();

    inline void clear_has_ParkingBreakSwitchValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ParkingBreakSwitchValue;

};

/**
 * The status message of the property "RearCamReq"
 * RearCam Request Status update to the clients
 * <p>FUNCID = 0x1019,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class RearCamReqStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RearCamReqStatus ();

    /**
     * Copy constructor
     */
    inline  RearCamReqStatus (const RearCamReqStatus &rhs);

    /**
     * All fields constructor
     */
    inline  RearCamReqStatus (uint8 RearCamReqValue_);

    /**
     * Destructor
     */
    inline virtual  ~RearCamReqStatus();

    /**
     * Assignment operator
     */
    inline RearCamReqStatus& operator = (const RearCamReqStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RearCamReqStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RearCamReqStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RearCamReqStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RearCamReqStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RearCamReqValue"

    static const int kRearCamReqValue = 0;

    /**
     * Clears the field "RearCamReqValue".
     *
     * The field will be set to its default value. The hasRearCamReqValue()
     * method will return false.
     */
    inline void clearRearCamReqValue();

    /**
     * Checks whether the field "RearCamReqValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRearCamReqValue()). Otherwise it will return false.
     */
    inline bool hasRearCamReqValue () const;

    /**
     * Returns the value of the member "RearCamReqValue".
     *
     * <p>RearCam Request Status update to the clients</p>
     *
     * @return The value of the field "RearCamReqValue"
     */
    inline uint8 getRearCamReqValue () const;

    /**
     * Sets the value of the member "RearCamReqValue".
     *
     * <p>RearCam Request Status update to the clients</p>
     *
     * @param RearCamReqValue The value which will be set
     */
    inline void setRearCamReqValue (uint8 RearCamReqValue_);

    static const RearCamReqStatus &getDefaultInstance();

private:

    inline void set_has_RearCamReqValue ();

    inline void clear_has_RearCamReqValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _RearCamReqValue;

};

/**
 * The status message of the property "VIN"
 * Display Vehicle ID
 * <p>FUNCID = 0x101A,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class VINStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VINStatus ();

    /**
     * Copy constructor
     */
    inline  VINStatus (const VINStatus &rhs);

    /**
     * All fields constructor
     */
    inline  VINStatus (uint32 VINValue_);

    /**
     * Destructor
     */
    inline virtual  ~VINStatus();

    /**
     * Assignment operator
     */
    inline VINStatus& operator = (const VINStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VINStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VINStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VINStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VINStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "VINValue"

    static const int kVINValue = 0;

    /**
     * Clears the field "VINValue".
     *
     * The field will be set to its default value. The hasVINValue()
     * method will return false.
     */
    inline void clearVINValue();

    /**
     * Checks whether the field "VINValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVINValue()). Otherwise it will return false.
     */
    inline bool hasVINValue () const;

    /**
     * Returns the value of the member "VINValue".
     *
     * <p>Display Vehicle id value</p>
     *
     * @return The value of the field "VINValue"
     */
    inline uint32 getVINValue () const;

    /**
     * Sets the value of the member "VINValue".
     *
     * <p>Display Vehicle id value</p>
     *
     * @param VINValue The value which will be set
     */
    inline void setVINValue (uint32 VINValue_);

    static const VINStatus &getDefaultInstance();

private:

    inline void set_has_VINValue ();

    inline void clear_has_VINValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _VINValue;

};

/**
 * The status message of the property "TimeDate"
 * Display Current Time date
 * <p>FUNCID = 0x101B,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class TimeDateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TimeDateStatus ();

    /**
     * Copy constructor
     */
    inline  TimeDateStatus (const TimeDateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  TimeDateStatus (uint64 TimeDateValue_);

    /**
     * Destructor
     */
    inline virtual  ~TimeDateStatus();

    /**
     * Assignment operator
     */
    inline TimeDateStatus& operator = (const TimeDateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TimeDateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TimeDateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TimeDateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TimeDateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TimeDateValue"

    static const int kTimeDateValue = 0;

    /**
     * Clears the field "TimeDateValue".
     *
     * The field will be set to its default value. The hasTimeDateValue()
     * method will return false.
     */
    inline void clearTimeDateValue();

    /**
     * Checks whether the field "TimeDateValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTimeDateValue()). Otherwise it will return false.
     */
    inline bool hasTimeDateValue () const;

    /**
     * Returns the value of the member "TimeDateValue".
     *
     * <p>Display Time Date value</p>
     *
     * @return The value of the field "TimeDateValue"
     */
    inline uint64 getTimeDateValue () const;

    /**
     * Sets the value of the member "TimeDateValue".
     *
     * <p>Display Time Date value</p>
     *
     * @param TimeDateValue The value which will be set
     */
    inline void setTimeDateValue (uint64 TimeDateValue_);

    static const TimeDateStatus &getDefaultInstance();

private:

    inline void set_has_TimeDateValue ();

    inline void clear_has_TimeDateValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint64 _TimeDateValue;

};

/**
 * The status message of the property "PrivacyResetRequest"
 * Interface providing Privacy Reset Request. Receiver HMI(System Settings)
 * <p>FUNCID = 0x101C,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class PrivacyResetRequestStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PrivacyResetRequestStatus ();

    /**
     * Copy constructor
     */
    inline  PrivacyResetRequestStatus (const PrivacyResetRequestStatus &rhs);

    /**
     * All fields constructor
     */
    inline  PrivacyResetRequestStatus (uint8 PrivacyResetRequestValue_);

    /**
     * Destructor
     */
    inline virtual  ~PrivacyResetRequestStatus();

    /**
     * Assignment operator
     */
    inline PrivacyResetRequestStatus& operator = (const PrivacyResetRequestStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PrivacyResetRequestStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PrivacyResetRequestStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PrivacyResetRequestStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PrivacyResetRequestStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PrivacyResetRequestValue"

    static const int kPrivacyResetRequestValue = 0;

    /**
     * Clears the field "PrivacyResetRequestValue".
     *
     * The field will be set to its default value. The hasPrivacyResetRequestValue()
     * method will return false.
     */
    inline void clearPrivacyResetRequestValue();

    /**
     * Checks whether the field "PrivacyResetRequestValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPrivacyResetRequestValue()). Otherwise it will return false.
     */
    inline bool hasPrivacyResetRequestValue () const;

    /**
     * Returns the value of the member "PrivacyResetRequestValue".
     *
     * <p>Interface providing Privacy Reset Request</p>
     *
     * @return The value of the field "PrivacyResetRequestValue"
     */
    inline uint8 getPrivacyResetRequestValue () const;

    /**
     * Sets the value of the member "PrivacyResetRequestValue".
     *
     * <p>Interface providing Privacy Reset Request</p>
     *
     * @param PrivacyResetRequestValue The value which will be set
     */
    inline void setPrivacyResetRequestValue (uint8 PrivacyResetRequestValue_);

    static const PrivacyResetRequestStatus &getDefaultInstance();

private:

    inline void set_has_PrivacyResetRequestValue ();

    inline void clear_has_PrivacyResetRequestValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _PrivacyResetRequestValue;

};

/**
 * The status message of the property "PhoneCallCommand"
 * Sends Phone Call Command signal values from CAN
 * <p>FUNCID = 0x101D,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class PhoneCallCommandStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PhoneCallCommandStatus ();

    /**
     * Copy constructor
     */
    inline  PhoneCallCommandStatus (const PhoneCallCommandStatus &rhs);

    /**
     * All fields constructor
     */
    inline  PhoneCallCommandStatus (uint8 PhoneCallCommandValue_);

    /**
     * Destructor
     */
    inline virtual  ~PhoneCallCommandStatus();

    /**
     * Assignment operator
     */
    inline PhoneCallCommandStatus& operator = (const PhoneCallCommandStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PhoneCallCommandStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PhoneCallCommandStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PhoneCallCommandStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PhoneCallCommandStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PhoneCallCommandValue"

    static const int kPhoneCallCommandValue = 0;

    /**
     * Clears the field "PhoneCallCommandValue".
     *
     * The field will be set to its default value. The hasPhoneCallCommandValue()
     * method will return false.
     */
    inline void clearPhoneCallCommandValue();

    /**
     * Checks whether the field "PhoneCallCommandValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhoneCallCommandValue()). Otherwise it will return false.
     */
    inline bool hasPhoneCallCommandValue () const;

    /**
     * Returns the value of the member "PhoneCallCommandValue".
     *
     * <p>Sends PhoneCall cmd value</p>
     *
     * @return The value of the field "PhoneCallCommandValue"
     */
    inline uint8 getPhoneCallCommandValue () const;

    /**
     * Sets the value of the member "PhoneCallCommandValue".
     *
     * <p>Sends PhoneCall cmd value</p>
     *
     * @param PhoneCallCommandValue The value which will be set
     */
    inline void setPhoneCallCommandValue (uint8 PhoneCallCommandValue_);

    static const PhoneCallCommandStatus &getDefaultInstance();

private:

    inline void set_has_PhoneCallCommandValue ();

    inline void clear_has_PhoneCallCommandValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _PhoneCallCommandValue;

};

/**
 * The status message of the property "VolumeCommand"
 * Sends volume Command signal values from CAN
 * <p>FUNCID = 0x101E,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class VolumeCommandStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VolumeCommandStatus ();

    /**
     * Copy constructor
     */
    inline  VolumeCommandStatus (const VolumeCommandStatus &rhs);

    /**
     * All fields constructor
     */
    inline  VolumeCommandStatus (uint8 VolumeCommandValue_);

    /**
     * Destructor
     */
    inline virtual  ~VolumeCommandStatus();

    /**
     * Assignment operator
     */
    inline VolumeCommandStatus& operator = (const VolumeCommandStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VolumeCommandStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VolumeCommandStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VolumeCommandStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VolumeCommandStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "VolumeCommandValue"

    static const int kVolumeCommandValue = 0;

    /**
     * Clears the field "VolumeCommandValue".
     *
     * The field will be set to its default value. The hasVolumeCommandValue()
     * method will return false.
     */
    inline void clearVolumeCommandValue();

    /**
     * Checks whether the field "VolumeCommandValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVolumeCommandValue()). Otherwise it will return false.
     */
    inline bool hasVolumeCommandValue () const;

    /**
     * Returns the value of the member "VolumeCommandValue".
     *
     * <p>Sends volume cmd value</p>
     *
     * @return The value of the field "VolumeCommandValue"
     */
    inline uint8 getVolumeCommandValue () const;

    /**
     * Sets the value of the member "VolumeCommandValue".
     *
     * <p>Sends volume cmd value</p>
     *
     * @param VolumeCommandValue The value which will be set
     */
    inline void setVolumeCommandValue (uint8 VolumeCommandValue_);

    static const VolumeCommandStatus &getDefaultInstance();

private:

    inline void set_has_VolumeCommandValue ();

    inline void clear_has_VolumeCommandValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _VolumeCommandValue;

};

/**
 * The status message of the property "VoiceRecgCommand"
 * Sends Voice Recognition Command signal values from CAN
 * <p>FUNCID = 0x101F,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class VoiceRecgCommandStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VoiceRecgCommandStatus ();

    /**
     * Copy constructor
     */
    inline  VoiceRecgCommandStatus (const VoiceRecgCommandStatus &rhs);

    /**
     * All fields constructor
     */
    inline  VoiceRecgCommandStatus (uint8 VoiceRecgCommandValue_);

    /**
     * Destructor
     */
    inline virtual  ~VoiceRecgCommandStatus();

    /**
     * Assignment operator
     */
    inline VoiceRecgCommandStatus& operator = (const VoiceRecgCommandStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VoiceRecgCommandStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VoiceRecgCommandStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VoiceRecgCommandStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VoiceRecgCommandStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "VoiceRecgCommandValue"

    static const int kVoiceRecgCommandValue = 0;

    /**
     * Clears the field "VoiceRecgCommandValue".
     *
     * The field will be set to its default value. The hasVoiceRecgCommandValue()
     * method will return false.
     */
    inline void clearVoiceRecgCommandValue();

    /**
     * Checks whether the field "VoiceRecgCommandValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVoiceRecgCommandValue()). Otherwise it will return false.
     */
    inline bool hasVoiceRecgCommandValue () const;

    /**
     * Returns the value of the member "VoiceRecgCommandValue".
     *
     * <p>Sends Voice Recognition cmd value</p>
     *
     * @return The value of the field "VoiceRecgCommandValue"
     */
    inline uint8 getVoiceRecgCommandValue () const;

    /**
     * Sets the value of the member "VoiceRecgCommandValue".
     *
     * <p>Sends Voice Recognition cmd value</p>
     *
     * @param VoiceRecgCommandValue The value which will be set
     */
    inline void setVoiceRecgCommandValue (uint8 VoiceRecgCommandValue_);

    static const VoiceRecgCommandStatus &getDefaultInstance();

private:

    inline void set_has_VoiceRecgCommandValue ();

    inline void clear_has_VoiceRecgCommandValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _VoiceRecgCommandValue;

};

/**
 * The status message of the property "DeviceInfoSWversion"
 * Sends SW Version values from CAN
 * <p>FUNCID = 0x1020,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class DeviceInfoSWversionStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeviceInfoSWversionStatus ();

    /**
     * Copy constructor
     */
    inline  DeviceInfoSWversionStatus (const DeviceInfoSWversionStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DeviceInfoSWversionStatus (uint32 SWversionValue_);

    /**
     * Destructor
     */
    inline virtual  ~DeviceInfoSWversionStatus();

    /**
     * Assignment operator
     */
    inline DeviceInfoSWversionStatus& operator = (const DeviceInfoSWversionStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceInfoSWversionStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceInfoSWversionStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceInfoSWversionStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceInfoSWversionStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SWversionValue"

    static const int kSWversionValue = 0;

    /**
     * Clears the field "SWversionValue".
     *
     * The field will be set to its default value. The hasSWversionValue()
     * method will return false.
     */
    inline void clearSWversionValue();

    /**
     * Checks whether the field "SWversionValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSWversionValue()). Otherwise it will return false.
     */
    inline bool hasSWversionValue () const;

    /**
     * Returns the value of the member "SWversionValue".
     *
     * <p>Sends SW Version  value</p>
     *
     * @return The value of the field "SWversionValue"
     */
    inline uint32 getSWversionValue () const;

    /**
     * Sets the value of the member "SWversionValue".
     *
     * <p>Sends SW Version  value</p>
     *
     * @param SWversionValue The value which will be set
     */
    inline void setSWversionValue (uint32 SWversionValue_);

    static const DeviceInfoSWversionStatus &getDefaultInstance();

private:

    inline void set_has_SWversionValue ();

    inline void clear_has_SWversionValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _SWversionValue;

};

/**
 * The status message of the property "TrackCommand"
 * Sends track command from media command msg values from CAN
 * <p>FUNCID = 0x1021,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class TrackCommandStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TrackCommandStatus ();

    /**
     * Copy constructor
     */
    inline  TrackCommandStatus (const TrackCommandStatus &rhs);

    /**
     * All fields constructor
     */
    inline  TrackCommandStatus (uint8 TrackCommandValue_);

    /**
     * Destructor
     */
    inline virtual  ~TrackCommandStatus();

    /**
     * Assignment operator
     */
    inline TrackCommandStatus& operator = (const TrackCommandStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TrackCommandStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TrackCommandStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TrackCommandStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TrackCommandStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TrackCommandValue"

    static const int kTrackCommandValue = 0;

    /**
     * Clears the field "TrackCommandValue".
     *
     * The field will be set to its default value. The hasTrackCommandValue()
     * method will return false.
     */
    inline void clearTrackCommandValue();

    /**
     * Checks whether the field "TrackCommandValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTrackCommandValue()). Otherwise it will return false.
     */
    inline bool hasTrackCommandValue () const;

    /**
     * Returns the value of the member "TrackCommandValue".
     *
     * <p>Sends track commands  value</p>
     *
     * @return The value of the field "TrackCommandValue"
     */
    inline uint8 getTrackCommandValue () const;

    /**
     * Sets the value of the member "TrackCommandValue".
     *
     * <p>Sends track commands  value</p>
     *
     * @param TrackCommandValue The value which will be set
     */
    inline void setTrackCommandValue (uint8 TrackCommandValue_);

    static const TrackCommandStatus &getDefaultInstance();

private:

    inline void set_has_TrackCommandValue ();

    inline void clear_has_TrackCommandValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _TrackCommandValue;

};

/**
 * The status message of the property "PhonePwrCmd"
 * Sends phone power command from media command msg values from CAN
 * <p>FUNCID = 0x1022,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class PhonePwrCmdStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PhonePwrCmdStatus ();

    /**
     * Copy constructor
     */
    inline  PhonePwrCmdStatus (const PhonePwrCmdStatus &rhs);

    /**
     * All fields constructor
     */
    inline  PhonePwrCmdStatus (uint8 PhonePwrCmdValue_);

    /**
     * Destructor
     */
    inline virtual  ~PhonePwrCmdStatus();

    /**
     * Assignment operator
     */
    inline PhonePwrCmdStatus& operator = (const PhonePwrCmdStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PhonePwrCmdStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PhonePwrCmdStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PhonePwrCmdStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PhonePwrCmdStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PhonePwrCmdValue"

    static const int kPhonePwrCmdValue = 0;

    /**
     * Clears the field "PhonePwrCmdValue".
     *
     * The field will be set to its default value. The hasPhonePwrCmdValue()
     * method will return false.
     */
    inline void clearPhonePwrCmdValue();

    /**
     * Checks whether the field "PhonePwrCmdValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhonePwrCmdValue()). Otherwise it will return false.
     */
    inline bool hasPhonePwrCmdValue () const;

    /**
     * Returns the value of the member "PhonePwrCmdValue".
     *
     * <p>Sends phone power commands  value</p>
     *
     * @return The value of the field "PhonePwrCmdValue"
     */
    inline uint8 getPhonePwrCmdValue () const;

    /**
     * Sets the value of the member "PhonePwrCmdValue".
     *
     * <p>Sends phone power commands  value</p>
     *
     * @param PhonePwrCmdValue The value which will be set
     */
    inline void setPhonePwrCmdValue (uint8 PhonePwrCmdValue_);

    static const PhonePwrCmdStatus &getDefaultInstance();

private:

    inline void set_has_PhonePwrCmdValue ();

    inline void clear_has_PhonePwrCmdValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _PhonePwrCmdValue;

};

/**
 * The status message of the property "RadioPwrCmd"
 * Sends Radio power command from media command msg values from CAN
 * <p>FUNCID = 0x1023,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class RadioPwrCmdStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RadioPwrCmdStatus ();

    /**
     * Copy constructor
     */
    inline  RadioPwrCmdStatus (const RadioPwrCmdStatus &rhs);

    /**
     * All fields constructor
     */
    inline  RadioPwrCmdStatus (uint8 RadioPwrCmdValue_);

    /**
     * Destructor
     */
    inline virtual  ~RadioPwrCmdStatus();

    /**
     * Assignment operator
     */
    inline RadioPwrCmdStatus& operator = (const RadioPwrCmdStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RadioPwrCmdStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RadioPwrCmdStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RadioPwrCmdStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RadioPwrCmdStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RadioPwrCmdValue"

    static const int kRadioPwrCmdValue = 0;

    /**
     * Clears the field "RadioPwrCmdValue".
     *
     * The field will be set to its default value. The hasRadioPwrCmdValue()
     * method will return false.
     */
    inline void clearRadioPwrCmdValue();

    /**
     * Checks whether the field "RadioPwrCmdValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRadioPwrCmdValue()). Otherwise it will return false.
     */
    inline bool hasRadioPwrCmdValue () const;

    /**
     * Returns the value of the member "RadioPwrCmdValue".
     *
     * <p>Sends Radio power commands  value</p>
     *
     * @return The value of the field "RadioPwrCmdValue"
     */
    inline uint8 getRadioPwrCmdValue () const;

    /**
     * Sets the value of the member "RadioPwrCmdValue".
     *
     * <p>Sends Radio power commands  value</p>
     *
     * @param RadioPwrCmdValue The value which will be set
     */
    inline void setRadioPwrCmdValue (uint8 RadioPwrCmdValue_);

    static const RadioPwrCmdStatus &getDefaultInstance();

private:

    inline void set_has_RadioPwrCmdValue ();

    inline void clear_has_RadioPwrCmdValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _RadioPwrCmdValue;

};

/**
 * The status message of the property "RCNextBtn"
 * Sends Next Btn Status from remote control msg values from CAN
 * <p>FUNCID = 0x1024,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class RCNextBtnStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RCNextBtnStatus ();

    /**
     * Copy constructor
     */
    inline  RCNextBtnStatus (const RCNextBtnStatus &rhs);

    /**
     * All fields constructor
     */
    inline  RCNextBtnStatus (uint8 RCNextBtnValue_);

    /**
     * Destructor
     */
    inline virtual  ~RCNextBtnStatus();

    /**
     * Assignment operator
     */
    inline RCNextBtnStatus& operator = (const RCNextBtnStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RCNextBtnStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RCNextBtnStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RCNextBtnStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RCNextBtnStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RCNextBtnValue"

    static const int kRCNextBtnValue = 0;

    /**
     * Clears the field "RCNextBtnValue".
     *
     * The field will be set to its default value. The hasRCNextBtnValue()
     * method will return false.
     */
    inline void clearRCNextBtnValue();

    /**
     * Checks whether the field "RCNextBtnValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRCNextBtnValue()). Otherwise it will return false.
     */
    inline bool hasRCNextBtnValue () const;

    /**
     * Returns the value of the member "RCNextBtnValue".
     *
     * <p>Sends Next Button value</p>
     *
     * @return The value of the field "RCNextBtnValue"
     */
    inline uint8 getRCNextBtnValue () const;

    /**
     * Sets the value of the member "RCNextBtnValue".
     *
     * <p>Sends Next Button value</p>
     *
     * @param RCNextBtnValue The value which will be set
     */
    inline void setRCNextBtnValue (uint8 RCNextBtnValue_);

    static const RCNextBtnStatus &getDefaultInstance();

private:

    inline void set_has_RCNextBtnValue ();

    inline void clear_has_RCNextBtnValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _RCNextBtnValue;

};

/**
 * The status message of the property "RCPrevBtn"
 * Sends Prev Btn Status from remote control msg values from CAN
 * <p>FUNCID = 0x1025,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class RCPrevBtnStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RCPrevBtnStatus ();

    /**
     * Copy constructor
     */
    inline  RCPrevBtnStatus (const RCPrevBtnStatus &rhs);

    /**
     * All fields constructor
     */
    inline  RCPrevBtnStatus (uint8 RCPrevBtnValue_);

    /**
     * Destructor
     */
    inline virtual  ~RCPrevBtnStatus();

    /**
     * Assignment operator
     */
    inline RCPrevBtnStatus& operator = (const RCPrevBtnStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RCPrevBtnStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RCPrevBtnStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RCPrevBtnStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RCPrevBtnStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RCPrevBtnValue"

    static const int kRCPrevBtnValue = 0;

    /**
     * Clears the field "RCPrevBtnValue".
     *
     * The field will be set to its default value. The hasRCPrevBtnValue()
     * method will return false.
     */
    inline void clearRCPrevBtnValue();

    /**
     * Checks whether the field "RCPrevBtnValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRCPrevBtnValue()). Otherwise it will return false.
     */
    inline bool hasRCPrevBtnValue () const;

    /**
     * Returns the value of the member "RCPrevBtnValue".
     *
     * <p>Sends Prev Button value</p>
     *
     * @return The value of the field "RCPrevBtnValue"
     */
    inline uint8 getRCPrevBtnValue () const;

    /**
     * Sets the value of the member "RCPrevBtnValue".
     *
     * <p>Sends Prev Button value</p>
     *
     * @param RCPrevBtnValue The value which will be set
     */
    inline void setRCPrevBtnValue (uint8 RCPrevBtnValue_);

    static const RCPrevBtnStatus &getDefaultInstance();

private:

    inline void set_has_RCPrevBtnValue ();

    inline void clear_has_RCPrevBtnValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _RCPrevBtnValue;

};

/**
 * The status message of the property "SourceCommand"
 * Sends Source Cmd values from  Media Command msg values from CAN
 * <p>FUNCID = 0x1026,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class SourceCommandStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SourceCommandStatus ();

    /**
     * Copy constructor
     */
    inline  SourceCommandStatus (const SourceCommandStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SourceCommandStatus (uint8 SourceCommandValue_);

    /**
     * Destructor
     */
    inline virtual  ~SourceCommandStatus();

    /**
     * Assignment operator
     */
    inline SourceCommandStatus& operator = (const SourceCommandStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SourceCommandStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SourceCommandStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SourceCommandStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SourceCommandStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SourceCommandValue"

    static const int kSourceCommandValue = 0;

    /**
     * Clears the field "SourceCommandValue".
     *
     * The field will be set to its default value. The hasSourceCommandValue()
     * method will return false.
     */
    inline void clearSourceCommandValue();

    /**
     * Checks whether the field "SourceCommandValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourceCommandValue()). Otherwise it will return false.
     */
    inline bool hasSourceCommandValue () const;

    /**
     * Returns the value of the member "SourceCommandValue".
     *
     * <p>Sends Src CMD value</p>
     *
     * @return The value of the field "SourceCommandValue"
     */
    inline uint8 getSourceCommandValue () const;

    /**
     * Sets the value of the member "SourceCommandValue".
     *
     * <p>Sends Src CMD value</p>
     *
     * @param SourceCommandValue The value which will be set
     */
    inline void setSourceCommandValue (uint8 SourceCommandValue_);

    static const SourceCommandStatus &getDefaultInstance();

private:

    inline void set_has_SourceCommandValue ();

    inline void clear_has_SourceCommandValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _SourceCommandValue;

};

/**
 * The status message of the property "TunerCommand"
 * Sends Tuner Cmd values from  Media Command msg values from CAN
 * <p>FUNCID = 0x1027,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class TunerCommandStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TunerCommandStatus ();

    /**
     * Copy constructor
     */
    inline  TunerCommandStatus (const TunerCommandStatus &rhs);

    /**
     * All fields constructor
     */
    inline  TunerCommandStatus (uint8 TunerCommandValue_);

    /**
     * Destructor
     */
    inline virtual  ~TunerCommandStatus();

    /**
     * Assignment operator
     */
    inline TunerCommandStatus& operator = (const TunerCommandStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TunerCommandStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TunerCommandStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TunerCommandStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TunerCommandStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerCommandValue"

    static const int kTunerCommandValue = 0;

    /**
     * Clears the field "TunerCommandValue".
     *
     * The field will be set to its default value. The hasTunerCommandValue()
     * method will return false.
     */
    inline void clearTunerCommandValue();

    /**
     * Checks whether the field "TunerCommandValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerCommandValue()). Otherwise it will return false.
     */
    inline bool hasTunerCommandValue () const;

    /**
     * Returns the value of the member "TunerCommandValue".
     *
     * <p>Sends Tuner CMD value</p>
     *
     * @return The value of the field "TunerCommandValue"
     */
    inline uint8 getTunerCommandValue () const;

    /**
     * Sets the value of the member "TunerCommandValue".
     *
     * <p>Sends Tuner CMD value</p>
     *
     * @param TunerCommandValue The value which will be set
     */
    inline void setTunerCommandValue (uint8 TunerCommandValue_);

    static const TunerCommandStatus &getDefaultInstance();

private:

    inline void set_has_TunerCommandValue ();

    inline void clear_has_TunerCommandValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _TunerCommandValue;

};

/**
 * The status message of the property "TACommand"
 * Sends TA Cmd values from  Media Command msg values from CAN
 * <p>FUNCID = 0x1028,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class TACommandStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TACommandStatus ();

    /**
     * Copy constructor
     */
    inline  TACommandStatus (const TACommandStatus &rhs);

    /**
     * All fields constructor
     */
    inline  TACommandStatus (uint8 TACommandValue_);

    /**
     * Destructor
     */
    inline virtual  ~TACommandStatus();

    /**
     * Assignment operator
     */
    inline TACommandStatus& operator = (const TACommandStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TACommandStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TACommandStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TACommandStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TACommandStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TACommandValue"

    static const int kTACommandValue = 0;

    /**
     * Clears the field "TACommandValue".
     *
     * The field will be set to its default value. The hasTACommandValue()
     * method will return false.
     */
    inline void clearTACommandValue();

    /**
     * Checks whether the field "TACommandValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTACommandValue()). Otherwise it will return false.
     */
    inline bool hasTACommandValue () const;

    /**
     * Returns the value of the member "TACommandValue".
     *
     * <p>Sends TA CMD value</p>
     *
     * @return The value of the field "TACommandValue"
     */
    inline uint8 getTACommandValue () const;

    /**
     * Sets the value of the member "TACommandValue".
     *
     * <p>Sends TA CMD value</p>
     *
     * @param TACommandValue The value which will be set
     */
    inline void setTACommandValue (uint8 TACommandValue_);

    static const TACommandStatus &getDefaultInstance();

private:

    inline void set_has_TACommandValue ();

    inline void clear_has_TACommandValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _TACommandValue;

};

/**
 * The status message of the property "RDSCommand"
 * Sends TA Cmd values from  Media Command msg values from CAN
 * <p>FUNCID = 0x1029,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class RDSCommandStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RDSCommandStatus ();

    /**
     * Copy constructor
     */
    inline  RDSCommandStatus (const RDSCommandStatus &rhs);

    /**
     * All fields constructor
     */
    inline  RDSCommandStatus (uint8 RDSCommandValue_);

    /**
     * Destructor
     */
    inline virtual  ~RDSCommandStatus();

    /**
     * Assignment operator
     */
    inline RDSCommandStatus& operator = (const RDSCommandStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RDSCommandStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RDSCommandStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RDSCommandStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RDSCommandStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RDSCommandValue"

    static const int kRDSCommandValue = 0;

    /**
     * Clears the field "RDSCommandValue".
     *
     * The field will be set to its default value. The hasRDSCommandValue()
     * method will return false.
     */
    inline void clearRDSCommandValue();

    /**
     * Checks whether the field "RDSCommandValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRDSCommandValue()). Otherwise it will return false.
     */
    inline bool hasRDSCommandValue () const;

    /**
     * Returns the value of the member "RDSCommandValue".
     *
     * <p>Sends TA CMD value</p>
     *
     * @return The value of the field "RDSCommandValue"
     */
    inline uint8 getRDSCommandValue () const;

    /**
     * Sets the value of the member "RDSCommandValue".
     *
     * <p>Sends TA CMD value</p>
     *
     * @param RDSCommandValue The value which will be set
     */
    inline void setRDSCommandValue (uint8 RDSCommandValue_);

    static const RDSCommandStatus &getDefaultInstance();

private:

    inline void set_has_RDSCommandValue ();

    inline void clear_has_RDSCommandValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _RDSCommandValue;

};

/**
 * The status message of the property "SMARTVR"
 * Sends Vr values from  Media Command msg values from CAN
 * <p>FUNCID = 0x1034,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class SMARTVRStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SMARTVRStatus ();

    /**
     * Copy constructor
     */
    inline  SMARTVRStatus (const SMARTVRStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SMARTVRStatus (uint8 SMARTVRValue_);

    /**
     * Destructor
     */
    inline virtual  ~SMARTVRStatus();

    /**
     * Assignment operator
     */
    inline SMARTVRStatus& operator = (const SMARTVRStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SMARTVRStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SMARTVRStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SMARTVRStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SMARTVRStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SMARTVRValue"

    static const int kSMARTVRValue = 0;

    /**
     * Clears the field "SMARTVRValue".
     *
     * The field will be set to its default value. The hasSMARTVRValue()
     * method will return false.
     */
    inline void clearSMARTVRValue();

    /**
     * Checks whether the field "SMARTVRValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSMARTVRValue()). Otherwise it will return false.
     */
    inline bool hasSMARTVRValue () const;

    /**
     * Returns the value of the member "SMARTVRValue".
     *
     * <p>Sends VR CMD value</p>
     *
     * @return The value of the field "SMARTVRValue"
     */
    inline uint8 getSMARTVRValue () const;

    /**
     * Sets the value of the member "SMARTVRValue".
     *
     * <p>Sends VR CMD value</p>
     *
     * @param SMARTVRValue The value which will be set
     */
    inline void setSMARTVRValue (uint8 SMARTVRValue_);

    static const SMARTVRStatus &getDefaultInstance();

private:

    inline void set_has_SMARTVRValue ();

    inline void clear_has_SMARTVRValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _SMARTVRValue;

};

/**
 * The status message of the property "TotalVehDistDiag"
 * Sends total distance info from CAN
 * <p>FUNCID = 0x1035,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class TotalVehDistDiagStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TotalVehDistDiagStatus ();

    /**
     * Copy constructor
     */
    inline  TotalVehDistDiagStatus (const TotalVehDistDiagStatus &rhs);

    /**
     * All fields constructor
     */
    inline  TotalVehDistDiagStatus (uint32 TotalVehDistDiagValue_);

    /**
     * Destructor
     */
    inline virtual  ~TotalVehDistDiagStatus();

    /**
     * Assignment operator
     */
    inline TotalVehDistDiagStatus& operator = (const TotalVehDistDiagStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TotalVehDistDiagStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TotalVehDistDiagStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TotalVehDistDiagStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TotalVehDistDiagStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TotalVehDistDiagValue"

    static const int kTotalVehDistDiagValue = 0;

    /**
     * Clears the field "TotalVehDistDiagValue".
     *
     * The field will be set to its default value. The hasTotalVehDistDiagValue()
     * method will return false.
     */
    inline void clearTotalVehDistDiagValue();

    /**
     * Checks whether the field "TotalVehDistDiagValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTotalVehDistDiagValue()). Otherwise it will return false.
     */
    inline bool hasTotalVehDistDiagValue () const;

    /**
     * Returns the value of the member "TotalVehDistDiagValue".
     *
     * <p>Sends TotalDist value</p>
     *
     * @return The value of the field "TotalVehDistDiagValue"
     */
    inline uint32 getTotalVehDistDiagValue () const;

    /**
     * Sets the value of the member "TotalVehDistDiagValue".
     *
     * <p>Sends TotalDist value</p>
     *
     * @param TotalVehDistDiagValue The value which will be set
     */
    inline void setTotalVehDistDiagValue (uint32 TotalVehDistDiagValue_);

    static const TotalVehDistDiagStatus &getDefaultInstance();

private:

    inline void set_has_TotalVehDistDiagValue ();

    inline void clear_has_TotalVehDistDiagValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _TotalVehDistDiagValue;

};

/**
 * The status message of the property "VIN_64"
 * Sends VIN info from CAN
 * <p>FUNCID = 0x1036,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class VIN_64Status  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VIN_64Status ();

    /**
     * Copy constructor
     */
    inline  VIN_64Status (const VIN_64Status &rhs);

    /**
     * All fields constructor
     */
    inline  VIN_64Status (uint64 VIN_64Value_);

    /**
     * Destructor
     */
    inline virtual  ~VIN_64Status();

    /**
     * Assignment operator
     */
    inline VIN_64Status& operator = (const VIN_64Status& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VIN_64Status& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VIN_64Status& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VIN_64Status& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VIN_64Status& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "VIN_64Value"

    static const int kVIN_64Value = 0;

    /**
     * Clears the field "VIN_64Value".
     *
     * The field will be set to its default value. The hasVIN_64Value()
     * method will return false.
     */
    inline void clearVIN_64Value();

    /**
     * Checks whether the field "VIN_64Value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVIN_64Value()). Otherwise it will return false.
     */
    inline bool hasVIN_64Value () const;

    /**
     * Returns the value of the member "VIN_64Value".
     *
     * <p>Sends VIN value</p>
     *
     * @return The value of the field "VIN_64Value"
     */
    inline uint64 getVIN_64Value () const;

    /**
     * Sets the value of the member "VIN_64Value".
     *
     * <p>Sends VIN value</p>
     *
     * @param VIN_64Value The value which will be set
     */
    inline void setVIN_64Value (uint64 VIN_64Value_);

    static const VIN_64Status &getDefaultInstance();

private:

    inline void set_has_VIN_64Value ();

    inline void clear_has_VIN_64Value ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint64 _VIN_64Value;

};

/**
 * The status message of the property "CabinMediaSourceCommand"
 * Sends Source cmd values from cabin media cmd message  from CAN
 * Sends Source cmd values from cabin media cmd message  from CAN
 * values:
 * 01-AMFMTuner
 * 02-CD
 * 03-USB1
 * 04-USB2
 * 05-BT1(audio)
 * 06-BT2(audio)
 * 09-Aux(rear)
 * 0A-Aux(front)
 * 0B-SDcard1
 * 0C-SDCard2
 * 0E-XM
 * 10-DABAvail
 * 1C-Next src
 * 1D-Prev Src
 * 3E-error
 * 3F- SNA
 * <p>FUNCID = 0x1040,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class CabinMediaSourceCommandStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CabinMediaSourceCommandStatus ();

    /**
     * Copy constructor
     */
    inline  CabinMediaSourceCommandStatus (const CabinMediaSourceCommandStatus &rhs);

    /**
     * All fields constructor
     */
    inline  CabinMediaSourceCommandStatus (uint8 CabinMediaSourceCommandValue_);

    /**
     * Destructor
     */
    inline virtual  ~CabinMediaSourceCommandStatus();

    /**
     * Assignment operator
     */
    inline CabinMediaSourceCommandStatus& operator = (const CabinMediaSourceCommandStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CabinMediaSourceCommandStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CabinMediaSourceCommandStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CabinMediaSourceCommandStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CabinMediaSourceCommandStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CabinMediaSourceCommandValue"

    static const int kCabinMediaSourceCommandValue = 0;

    /**
     * Clears the field "CabinMediaSourceCommandValue".
     *
     * The field will be set to its default value. The hasCabinMediaSourceCommandValue()
     * method will return false.
     */
    inline void clearCabinMediaSourceCommandValue();

    /**
     * Checks whether the field "CabinMediaSourceCommandValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCabinMediaSourceCommandValue()). Otherwise it will return false.
     */
    inline bool hasCabinMediaSourceCommandValue () const;

    /**
     * Returns the value of the member "CabinMediaSourceCommandValue".
     *
     * <p>Sends Cabin Src Cmd value</p>
     *
     * @return The value of the field "CabinMediaSourceCommandValue"
     */
    inline uint8 getCabinMediaSourceCommandValue () const;

    /**
     * Sets the value of the member "CabinMediaSourceCommandValue".
     *
     * <p>Sends Cabin Src Cmd value</p>
     *
     * @param CabinMediaSourceCommandValue The value which will be set
     */
    inline void setCabinMediaSourceCommandValue (uint8 CabinMediaSourceCommandValue_);

    static const CabinMediaSourceCommandStatus &getDefaultInstance();

private:

    inline void set_has_CabinMediaSourceCommandValue ();

    inline void clear_has_CabinMediaSourceCommandValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _CabinMediaSourceCommandValue;

};

/**
 * The status message of the property "CabinMediaVolumeCommand"
 * Sends Volume cmd values from cabin media cmd message  from CAN
 * 01 -Demute
 * 02- Mute
 * 03- Volume Up
 * 04- Volume Down
 * 0E - Error
 * 0f - SNA
 * <p>FUNCID = 0x1041,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class CabinMediaVolumeCommandStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CabinMediaVolumeCommandStatus ();

    /**
     * Copy constructor
     */
    inline  CabinMediaVolumeCommandStatus (const CabinMediaVolumeCommandStatus &rhs);

    /**
     * All fields constructor
     */
    inline  CabinMediaVolumeCommandStatus (uint8 CabinMediaVolumeCommandValue_);

    /**
     * Destructor
     */
    inline virtual  ~CabinMediaVolumeCommandStatus();

    /**
     * Assignment operator
     */
    inline CabinMediaVolumeCommandStatus& operator = (const CabinMediaVolumeCommandStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CabinMediaVolumeCommandStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CabinMediaVolumeCommandStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CabinMediaVolumeCommandStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CabinMediaVolumeCommandStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CabinMediaVolumeCommandValue"

    static const int kCabinMediaVolumeCommandValue = 0;

    /**
     * Clears the field "CabinMediaVolumeCommandValue".
     *
     * The field will be set to its default value. The hasCabinMediaVolumeCommandValue()
     * method will return false.
     */
    inline void clearCabinMediaVolumeCommandValue();

    /**
     * Checks whether the field "CabinMediaVolumeCommandValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCabinMediaVolumeCommandValue()). Otherwise it will return false.
     */
    inline bool hasCabinMediaVolumeCommandValue () const;

    /**
     * Returns the value of the member "CabinMediaVolumeCommandValue".
     *
     * <p>Sends Volume  Cmd value</p>
     *
     * @return The value of the field "CabinMediaVolumeCommandValue"
     */
    inline uint8 getCabinMediaVolumeCommandValue () const;

    /**
     * Sets the value of the member "CabinMediaVolumeCommandValue".
     *
     * <p>Sends Volume  Cmd value</p>
     *
     * @param CabinMediaVolumeCommandValue The value which will be set
     */
    inline void setCabinMediaVolumeCommandValue (uint8 CabinMediaVolumeCommandValue_);

    static const CabinMediaVolumeCommandStatus &getDefaultInstance();

private:

    inline void set_has_CabinMediaVolumeCommandValue ();

    inline void clear_has_CabinMediaVolumeCommandValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _CabinMediaVolumeCommandValue;

};

/**
 * The status message of the property "CabinMediaTunerCommand"
 * Sends Tuner values from cabin media cmd message  from CAN
 * 01- Auto seek up
 * 02- Auto Seek Down
 * 03- Manual Step Up
 * 04- Manual Step Down
 * 05- Manual Seek Up
 * 06- Manual Seek Down
 * 07- Preset up
 * 08- Preset Down
 * 0E-Error
 * 0F- SNA
 * <p>FUNCID = 0x1042,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class CabinMediaTunerCommandStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CabinMediaTunerCommandStatus ();

    /**
     * Copy constructor
     */
    inline  CabinMediaTunerCommandStatus (const CabinMediaTunerCommandStatus &rhs);

    /**
     * All fields constructor
     */
    inline  CabinMediaTunerCommandStatus (uint8 CabinMediaTunerCommandValue_);

    /**
     * Destructor
     */
    inline virtual  ~CabinMediaTunerCommandStatus();

    /**
     * Assignment operator
     */
    inline CabinMediaTunerCommandStatus& operator = (const CabinMediaTunerCommandStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CabinMediaTunerCommandStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CabinMediaTunerCommandStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CabinMediaTunerCommandStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CabinMediaTunerCommandStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CabinMediaTunerCommandValue"

    static const int kCabinMediaTunerCommandValue = 0;

    /**
     * Clears the field "CabinMediaTunerCommandValue".
     *
     * The field will be set to its default value. The hasCabinMediaTunerCommandValue()
     * method will return false.
     */
    inline void clearCabinMediaTunerCommandValue();

    /**
     * Checks whether the field "CabinMediaTunerCommandValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCabinMediaTunerCommandValue()). Otherwise it will return false.
     */
    inline bool hasCabinMediaTunerCommandValue () const;

    /**
     * Returns the value of the member "CabinMediaTunerCommandValue".
     *
     * <p>Sends Tuner  Cmd value</p>
     *
     * @return The value of the field "CabinMediaTunerCommandValue"
     */
    inline uint8 getCabinMediaTunerCommandValue () const;

    /**
     * Sets the value of the member "CabinMediaTunerCommandValue".
     *
     * <p>Sends Tuner  Cmd value</p>
     *
     * @param CabinMediaTunerCommandValue The value which will be set
     */
    inline void setCabinMediaTunerCommandValue (uint8 CabinMediaTunerCommandValue_);

    static const CabinMediaTunerCommandStatus &getDefaultInstance();

private:

    inline void set_has_CabinMediaTunerCommandValue ();

    inline void clear_has_CabinMediaTunerCommandValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _CabinMediaTunerCommandValue;

};

/**
 * The status message of the property "CabinMediaTrackCommand"
 * Sends Track values from cabin media cmd message  from CAN
 * 01- Scan
 * 02- Play
 * 03- Next TrackCommand
 * 04- Previous TrackCommand
 * 05- Fast Forward
 * 06- Fast Backward
 * 07- Next Folder
 * 08- Previous Folder
 * 09- Repeat/ Random off
 * 0A- Repear Track
 * 0B- Repeat All
 * 0C- Repeat Folder
 * 0D- Random All
 * 0E- Random Folder
 * 0F- Dont Care
 * <p>FUNCID = 0x1043,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class CabinMediaTrackCommandStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CabinMediaTrackCommandStatus ();

    /**
     * Copy constructor
     */
    inline  CabinMediaTrackCommandStatus (const CabinMediaTrackCommandStatus &rhs);

    /**
     * All fields constructor
     */
    inline  CabinMediaTrackCommandStatus (uint8 CabinMediaTrackCommandValue_);

    /**
     * Destructor
     */
    inline virtual  ~CabinMediaTrackCommandStatus();

    /**
     * Assignment operator
     */
    inline CabinMediaTrackCommandStatus& operator = (const CabinMediaTrackCommandStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CabinMediaTrackCommandStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CabinMediaTrackCommandStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CabinMediaTrackCommandStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CabinMediaTrackCommandStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CabinMediaTrackCommandValue"

    static const int kCabinMediaTrackCommandValue = 0;

    /**
     * Clears the field "CabinMediaTrackCommandValue".
     *
     * The field will be set to its default value. The hasCabinMediaTrackCommandValue()
     * method will return false.
     */
    inline void clearCabinMediaTrackCommandValue();

    /**
     * Checks whether the field "CabinMediaTrackCommandValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCabinMediaTrackCommandValue()). Otherwise it will return false.
     */
    inline bool hasCabinMediaTrackCommandValue () const;

    /**
     * Returns the value of the member "CabinMediaTrackCommandValue".
     *
     * <p>Sends Track  Cmd value</p>
     *
     * @return The value of the field "CabinMediaTrackCommandValue"
     */
    inline uint8 getCabinMediaTrackCommandValue () const;

    /**
     * Sets the value of the member "CabinMediaTrackCommandValue".
     *
     * <p>Sends Track  Cmd value</p>
     *
     * @param CabinMediaTrackCommandValue The value which will be set
     */
    inline void setCabinMediaTrackCommandValue (uint8 CabinMediaTrackCommandValue_);

    static const CabinMediaTrackCommandStatus &getDefaultInstance();

private:

    inline void set_has_CabinMediaTrackCommandValue ();

    inline void clear_has_CabinMediaTrackCommandValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _CabinMediaTrackCommandValue;

};

/**
 * The status message of the property "CabinMediaPlaylistCommand"
 * Sends Playlist values from cabin media cmd message  from CAN
 * 01- Switch on
 * 02- Switch off
 * <p>FUNCID = 0x1044,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class CabinMediaPlaylistCommandStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CabinMediaPlaylistCommandStatus ();

    /**
     * Copy constructor
     */
    inline  CabinMediaPlaylistCommandStatus (const CabinMediaPlaylistCommandStatus &rhs);

    /**
     * All fields constructor
     */
    inline  CabinMediaPlaylistCommandStatus (uint8 CabinMediaPlaylistCommandValue_);

    /**
     * Destructor
     */
    inline virtual  ~CabinMediaPlaylistCommandStatus();

    /**
     * Assignment operator
     */
    inline CabinMediaPlaylistCommandStatus& operator = (const CabinMediaPlaylistCommandStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CabinMediaPlaylistCommandStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CabinMediaPlaylistCommandStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CabinMediaPlaylistCommandStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CabinMediaPlaylistCommandStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CabinMediaPlaylistCommandValue"

    static const int kCabinMediaPlaylistCommandValue = 0;

    /**
     * Clears the field "CabinMediaPlaylistCommandValue".
     *
     * The field will be set to its default value. The hasCabinMediaPlaylistCommandValue()
     * method will return false.
     */
    inline void clearCabinMediaPlaylistCommandValue();

    /**
     * Checks whether the field "CabinMediaPlaylistCommandValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCabinMediaPlaylistCommandValue()). Otherwise it will return false.
     */
    inline bool hasCabinMediaPlaylistCommandValue () const;

    /**
     * Returns the value of the member "CabinMediaPlaylistCommandValue".
     *
     * <p>Sends Playlist  Cmd value</p>
     *
     * @return The value of the field "CabinMediaPlaylistCommandValue"
     */
    inline uint8 getCabinMediaPlaylistCommandValue () const;

    /**
     * Sets the value of the member "CabinMediaPlaylistCommandValue".
     *
     * <p>Sends Playlist  Cmd value</p>
     *
     * @param CabinMediaPlaylistCommandValue The value which will be set
     */
    inline void setCabinMediaPlaylistCommandValue (uint8 CabinMediaPlaylistCommandValue_);

    static const CabinMediaPlaylistCommandStatus &getDefaultInstance();

private:

    inline void set_has_CabinMediaPlaylistCommandValue ();

    inline void clear_has_CabinMediaPlaylistCommandValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _CabinMediaPlaylistCommandValue;

};

/**
 * The status message of the property "NetworkState"
 * V-CAN and M-CAN bus and ECU communication states
 * <p>FUNCID = 0x1001,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 * <p></p>
 * <p>Three types of failures may be detected by the RNAIVI while connected to the network.</p>
 * <p>Mute (Transmission failure): The node does not succeed in transmitting its own frames</p>
 * <p>Absent (Reception failure): The node no longer receives frames from other monitored nodes</p>
 * <p>BusOff: The CAN controller is in BusOff mode and the node is temporarily isolated from the network</p>
 * <p>The diagnosis results of the failure types for each monitored bus and each monitored ECU (node) will be checked through
 * the diagnosis services. The results consist of an "Current_fault" status and "Confirmed_fault" status. They will be transmitted
 * to the diagnostic tool by a CAN diagnosis byte structure already provided with the property "NetworkState".</p>
 * <p>For RNAIVI the diagnosis byte has following content:</p>
 * <p>1) For Bus Off diagnosis:</p>
 * <p>0x00 = Bus On</p>
 * <p>0x80 = Bus Off - Current_fault status</p>
 * <p>0xC0 = Bus Off - Confirmed_fault status</p>
 * <p>0xFF = Fault (monitoring of the bus) is masked or diagnosis has not been made</p>
 * <p>2) For Transmission diagnosis:</p>
 * <p>0x00 = not muted</p>
 * <p>0x80 = muted - Current_fault status</p>
 * <p>0xC0 = muted - Confirmed_fault status</p>
 * <p>0xFF = Fault is masked or diagnosis has not been made</p>
 * <p>The Bus is muted if we are not able to send a message.</p>
 * <p>2) For Reception diagnosis:</p>
 * <p>0x00 = ECU (node) is present</p>
 * <p>0x80 = absent - Current_fault status</p>
 * <p>0xC0 = absent - Confirmed_fault status</p>
 * <p>0xFF = Fault (monitoring of the ECU) is masked or diagnosis has not been made</p>
 */
class NetworkStateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NetworkStateStatus ();

    /**
     * Copy constructor
     */
    inline  NetworkStateStatus (const NetworkStateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  NetworkStateStatus (uint8 u8BusState_MCAN_, uint8 u8BusState_VCAN_, uint8 u8MuteState_MCAN_, uint8 u8MuteState_VCAN_, const ::std::vector< uint8 >& Listu8AbsentState_ECU_, const ::std::vector< uint8 >& Listu8MuteStateMCAN_Channel_, bool bBusOff_MCAN_, bool bBusOff_VCAN_, bool bBusOff_, bool bMute_MCAN_, bool bMute_VCAN_);

    /**
     * Destructor
     */
    inline virtual  ~NetworkStateStatus();

    /**
     * Assignment operator
     */
    inline NetworkStateStatus& operator = (const NetworkStateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NetworkStateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NetworkStateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NetworkStateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NetworkStateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8BusState_MCAN"

    static const int kU8BusState_MCAN = 0;

    /**
     * Clears the field "u8BusState_MCAN".
     *
     * The field will be set to its default value. The hasU8BusState_MCAN()
     * method will return false.
     */
    inline void clearU8BusState_MCAN();

    /**
     * Checks whether the field "u8BusState_MCAN" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8BusState_MCAN()). Otherwise it will return false.
     */
    inline bool hasU8BusState_MCAN () const;

    /**
     * Returns the value of the member "u8BusState_MCAN".
     *
     * Multimedia CAN Bus state
     * <p>byte content is project specific - see text above for details</p>
     *
     * @return The value of the field "u8BusState_MCAN"
     */
    inline uint8 getU8BusState_MCAN () const;

    /**
     * Sets the value of the member "u8BusState_MCAN".
     *
     * Multimedia CAN Bus state
     * <p>byte content is project specific - see text above for details</p>
     *
     * @param u8BusState_MCAN The value which will be set
     */
    inline void setU8BusState_MCAN (uint8 u8BusState_MCAN_);

    // API of field "u8BusState_VCAN"

    static const int kU8BusState_VCAN = 1;

    /**
     * Clears the field "u8BusState_VCAN".
     *
     * The field will be set to its default value. The hasU8BusState_VCAN()
     * method will return false.
     */
    inline void clearU8BusState_VCAN();

    /**
     * Checks whether the field "u8BusState_VCAN" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8BusState_VCAN()). Otherwise it will return false.
     */
    inline bool hasU8BusState_VCAN () const;

    /**
     * Returns the value of the member "u8BusState_VCAN".
     *
     * Vehicle CAN Bus state
     * <p>byte content is project specific - see text above for details</p>
     *
     * @return The value of the field "u8BusState_VCAN"
     */
    inline uint8 getU8BusState_VCAN () const;

    /**
     * Sets the value of the member "u8BusState_VCAN".
     *
     * Vehicle CAN Bus state
     * <p>byte content is project specific - see text above for details</p>
     *
     * @param u8BusState_VCAN The value which will be set
     */
    inline void setU8BusState_VCAN (uint8 u8BusState_VCAN_);

    // API of field "u8MuteState_MCAN"

    static const int kU8MuteState_MCAN = 2;

    /**
     * Clears the field "u8MuteState_MCAN".
     *
     * The field will be set to its default value. The hasU8MuteState_MCAN()
     * method will return false.
     */
    inline void clearU8MuteState_MCAN();

    /**
     * Checks whether the field "u8MuteState_MCAN" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8MuteState_MCAN()). Otherwise it will return false.
     */
    inline bool hasU8MuteState_MCAN () const;

    /**
     * Returns the value of the member "u8MuteState_MCAN".
     *
     * Multimedia CAN Mute state
     * <p>byte content is project specific - see text above for details</p>
     *
     * @return The value of the field "u8MuteState_MCAN"
     */
    inline uint8 getU8MuteState_MCAN () const;

    /**
     * Sets the value of the member "u8MuteState_MCAN".
     *
     * Multimedia CAN Mute state
     * <p>byte content is project specific - see text above for details</p>
     *
     * @param u8MuteState_MCAN The value which will be set
     */
    inline void setU8MuteState_MCAN (uint8 u8MuteState_MCAN_);

    // API of field "u8MuteState_VCAN"

    static const int kU8MuteState_VCAN = 3;

    /**
     * Clears the field "u8MuteState_VCAN".
     *
     * The field will be set to its default value. The hasU8MuteState_VCAN()
     * method will return false.
     */
    inline void clearU8MuteState_VCAN();

    /**
     * Checks whether the field "u8MuteState_VCAN" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8MuteState_VCAN()). Otherwise it will return false.
     */
    inline bool hasU8MuteState_VCAN () const;

    /**
     * Returns the value of the member "u8MuteState_VCAN".
     *
     * Vehicle CAN Mute state.
     * <p>byte content is project specific - see text above for details</p>
     *
     * @return The value of the field "u8MuteState_VCAN"
     */
    inline uint8 getU8MuteState_VCAN () const;

    /**
     * Sets the value of the member "u8MuteState_VCAN".
     *
     * Vehicle CAN Mute state.
     * <p>byte content is project specific - see text above for details</p>
     *
     * @param u8MuteState_VCAN The value which will be set
     */
    inline void setU8MuteState_VCAN (uint8 u8MuteState_VCAN_);

    // API of field "Listu8AbsentState_ECU"

    static const int kListu8AbsentState_ECU = 4;

    /**
     * Clears the field "Listu8AbsentState_ECU".
     *
     * The field will be set to its default value. The hasListu8AbsentState_ECU()
     * method will return false.
     */
    inline void clearListu8AbsentState_ECU();

    /**
     * Checks whether the field "Listu8AbsentState_ECU" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListu8AbsentState_ECU()). Otherwise it will return false.
     */
    inline bool hasListu8AbsentState_ECU () const;

    /**
     * Returns the value of the member "Listu8AbsentState_ECU".
     *
     * list which contains the absent states for each monitored ECU
     * <p>byte content for each ECU in this list is project specific - see text above for details</p>
     *
     * @return The value of the field "Listu8AbsentState_ECU"
     */
    inline const ::std::vector< uint8 >& getListu8AbsentState_ECU () const;

    /**
     * Retrieves the value of the field "Listu8AbsentState_ECU" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Listu8AbsentState_ECU".
     */
    inline ::std::vector< uint8 >& getListu8AbsentState_ECUMutable ();

    /**
     * Sets the value of the member "Listu8AbsentState_ECU".
     *
     * list which contains the absent states for each monitored ECU
     * <p>byte content for each ECU in this list is project specific - see text above for details</p>
     *
     * @param Listu8AbsentState_ECU The value which will be set
     */
    inline void setListu8AbsentState_ECU (const ::std::vector< uint8 >& Listu8AbsentState_ECU_);

    // API of field "Listu8MuteStateMCAN_Channel"

    static const int kListu8MuteStateMCAN_Channel = 5;

    /**
     * Clears the field "Listu8MuteStateMCAN_Channel".
     *
     * The field will be set to its default value. The hasListu8MuteStateMCAN_Channel()
     * method will return false.
     */
    inline void clearListu8MuteStateMCAN_Channel();

    /**
     * Checks whether the field "Listu8MuteStateMCAN_Channel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListu8MuteStateMCAN_Channel()). Otherwise it will return false.
     */
    inline bool hasListu8MuteStateMCAN_Channel () const;

    /**
     * Returns the value of the member "Listu8MuteStateMCAN_Channel".
     *
     * list which contains the Channel Management Frame Mute states for each monitored MCAN Channel
     * <p>byte content for each Channel in this list is project specific - see text above for details</p>
     *
     * @return The value of the field "Listu8MuteStateMCAN_Channel"
     */
    inline const ::std::vector< uint8 >& getListu8MuteStateMCAN_Channel () const;

    /**
     * Retrieves the value of the field "Listu8MuteStateMCAN_Channel" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Listu8MuteStateMCAN_Channel".
     */
    inline ::std::vector< uint8 >& getListu8MuteStateMCAN_ChannelMutable ();

    /**
     * Sets the value of the member "Listu8MuteStateMCAN_Channel".
     *
     * list which contains the Channel Management Frame Mute states for each monitored MCAN Channel
     * <p>byte content for each Channel in this list is project specific - see text above for details</p>
     *
     * @param Listu8MuteStateMCAN_Channel The value which will be set
     */
    inline void setListu8MuteStateMCAN_Channel (const ::std::vector< uint8 >& Listu8MuteStateMCAN_Channel_);

    // API of field "bBusOff_MCAN"

    static const int kBBusOff_MCAN = 6;

    /**
     * Clears the field "bBusOff_MCAN".
     *
     * The field will be set to its default value. The hasBBusOff_MCAN()
     * method will return false.
     */
    inline void clearBBusOff_MCAN();

    /**
     * Checks whether the field "bBusOff_MCAN" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBBusOff_MCAN()). Otherwise it will return false.
     */
    inline bool hasBBusOff_MCAN () const;

    /**
     * Returns the value of the member "bBusOff_MCAN".
     *
     * don't use, will be removed later
     *
     * @return The value of the field "bBusOff_MCAN"
     */
    inline bool getBBusOff_MCAN () const;

    /**
     * Sets the value of the member "bBusOff_MCAN".
     *
     * don't use, will be removed later
     *
     * @param bBusOff_MCAN The value which will be set
     */
    inline void setBBusOff_MCAN (bool bBusOff_MCAN_);

    // API of field "bBusOff_VCAN"

    static const int kBBusOff_VCAN = 7;

    /**
     * Clears the field "bBusOff_VCAN".
     *
     * The field will be set to its default value. The hasBBusOff_VCAN()
     * method will return false.
     */
    inline void clearBBusOff_VCAN();

    /**
     * Checks whether the field "bBusOff_VCAN" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBBusOff_VCAN()). Otherwise it will return false.
     */
    inline bool hasBBusOff_VCAN () const;

    /**
     * Returns the value of the member "bBusOff_VCAN".
     *
     * don't use, will be removed later
     *
     * @return The value of the field "bBusOff_VCAN"
     */
    inline bool getBBusOff_VCAN () const;

    /**
     * Sets the value of the member "bBusOff_VCAN".
     *
     * don't use, will be removed later
     *
     * @param bBusOff_VCAN The value which will be set
     */
    inline void setBBusOff_VCAN (bool bBusOff_VCAN_);

    // API of field "bBusOff"

    static const int kBBusOff = 8;

    /**
     * Clears the field "bBusOff".
     *
     * The field will be set to its default value. The hasBBusOff()
     * method will return false.
     */
    inline void clearBBusOff();

    /**
     * Checks whether the field "bBusOff" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBBusOff()). Otherwise it will return false.
     */
    inline bool hasBBusOff () const;

    /**
     * Returns the value of the member "bBusOff".
     *
     * don't use, will be removed later
     *
     * @return The value of the field "bBusOff"
     */
    inline bool getBBusOff () const;

    /**
     * Sets the value of the member "bBusOff".
     *
     * don't use, will be removed later
     *
     * @param bBusOff The value which will be set
     */
    inline void setBBusOff (bool bBusOff_);

    // API of field "bMute_MCAN"

    static const int kBMute_MCAN = 9;

    /**
     * Clears the field "bMute_MCAN".
     *
     * The field will be set to its default value. The hasBMute_MCAN()
     * method will return false.
     */
    inline void clearBMute_MCAN();

    /**
     * Checks whether the field "bMute_MCAN" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBMute_MCAN()). Otherwise it will return false.
     */
    inline bool hasBMute_MCAN () const;

    /**
     * Returns the value of the member "bMute_MCAN".
     *
     * don't use, will be removed later
     *
     * @return The value of the field "bMute_MCAN"
     */
    inline bool getBMute_MCAN () const;

    /**
     * Sets the value of the member "bMute_MCAN".
     *
     * don't use, will be removed later
     *
     * @param bMute_MCAN The value which will be set
     */
    inline void setBMute_MCAN (bool bMute_MCAN_);

    // API of field "bMute_VCAN"

    static const int kBMute_VCAN = 10;

    /**
     * Clears the field "bMute_VCAN".
     *
     * The field will be set to its default value. The hasBMute_VCAN()
     * method will return false.
     */
    inline void clearBMute_VCAN();

    /**
     * Checks whether the field "bMute_VCAN" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBMute_VCAN()). Otherwise it will return false.
     */
    inline bool hasBMute_VCAN () const;

    /**
     * Returns the value of the member "bMute_VCAN".
     *
     * don't use, will be removed later
     *
     * @return The value of the field "bMute_VCAN"
     */
    inline bool getBMute_VCAN () const;

    /**
     * Sets the value of the member "bMute_VCAN".
     *
     * don't use, will be removed later
     *
     * @param bMute_VCAN The value which will be set
     */
    inline void setBMute_VCAN (bool bMute_VCAN_);

    static const NetworkStateStatus &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_u8BusState_MCAN ();

    inline void clear_has_u8BusState_MCAN ();

    inline void set_has_u8BusState_VCAN ();

    inline void clear_has_u8BusState_VCAN ();

    inline void set_has_u8MuteState_MCAN ();

    inline void clear_has_u8MuteState_MCAN ();

    inline void set_has_u8MuteState_VCAN ();

    inline void clear_has_u8MuteState_VCAN ();

    inline void set_has_Listu8AbsentState_ECU ();

    inline void clear_has_Listu8AbsentState_ECU ();

    inline void set_has_Listu8MuteStateMCAN_Channel ();

    inline void clear_has_Listu8MuteStateMCAN_Channel ();

    inline void set_has_bBusOff_MCAN ();

    inline void clear_has_bBusOff_MCAN ();

    inline void set_has_bBusOff_VCAN ();

    inline void clear_has_bBusOff_VCAN ();

    inline void set_has_bBusOff ();

    inline void clear_has_bBusOff ();

    inline void set_has_bMute_MCAN ();

    inline void clear_has_bMute_MCAN ();

    inline void set_has_bMute_VCAN ();

    inline void clear_has_bMute_VCAN ();

    uint32 _has_bits_[ (11 + 31) / 32];

    uint8 _u8BusState_MCAN;

    uint8 _u8BusState_VCAN;

    uint8 _u8MuteState_MCAN;

    uint8 _u8MuteState_VCAN;

    ::std::vector< uint8 > _Listu8AbsentState_ECU;

    ::std::vector< uint8 > _Listu8MuteStateMCAN_Channel;

    bool _bBusOff_MCAN;

    bool _bBusOff_VCAN;

    bool _bBusOff;

    bool _bMute_MCAN;

    bool _bMute_VCAN;

};

/**
 * The status message of the property "DistanceTotalizer"
 * DistanceTotalizer Status received from V-CAN
 * <p>FUNCID = 0x1002,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class DistanceTotalizerStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DistanceTotalizerStatus ();

    /**
     * Copy constructor
     */
    inline  DistanceTotalizerStatus (const DistanceTotalizerStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DistanceTotalizerStatus (uint32 DisTotal_, uint32 lastValidDisTotal_, uint8 Unit_, bool DisTotalStatus_);

    /**
     * Destructor
     */
    inline virtual  ~DistanceTotalizerStatus();

    /**
     * Assignment operator
     */
    inline DistanceTotalizerStatus& operator = (const DistanceTotalizerStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DistanceTotalizerStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DistanceTotalizerStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DistanceTotalizerStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DistanceTotalizerStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DisTotal"

    static const int kDisTotal = 0;

    /**
     * Clears the field "DisTotal".
     *
     * The field will be set to its default value. The hasDisTotal()
     * method will return false.
     */
    inline void clearDisTotal();

    /**
     * Checks whether the field "DisTotal" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDisTotal()). Otherwise it will return false.
     */
    inline bool hasDisTotal () const;

    /**
     * Returns the value of the member "DisTotal".
     *
     * <p>Total Distance travelled - Current CAN data</p>
     * <p>Resolution of the data is 0.1 (Actual = Status * 0.1 kms)</p>
     * <p>If Value = 0xFFFFFFFF, Clients should ignore the data</p>
     *
     * @return The value of the field "DisTotal"
     */
    inline uint32 getDisTotal () const;

    /**
     * Sets the value of the member "DisTotal".
     *
     * <p>Total Distance travelled - Current CAN data</p>
     * <p>Resolution of the data is 0.1 (Actual = Status * 0.1 kms)</p>
     * <p>If Value = 0xFFFFFFFF, Clients should ignore the data</p>
     *
     * @param DisTotal The value which will be set
     */
    inline void setDisTotal (uint32 DisTotal_);

    // API of field "lastValidDisTotal"

    static const int kLastValidDisTotal = 1;

    /**
     * Clears the field "lastValidDisTotal".
     *
     * The field will be set to its default value. The hasLastValidDisTotal()
     * method will return false.
     */
    inline void clearLastValidDisTotal();

    /**
     * Checks whether the field "lastValidDisTotal" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLastValidDisTotal()). Otherwise it will return false.
     */
    inline bool hasLastValidDisTotal () const;

    /**
     * Returns the value of the member "lastValidDisTotal".
     *
     * <p>last Valid Total Distance travelled - persistently stored data updated on CAN updates</p>
     * <p>Resolution of the data is 0.1 (Actual = Status * 0.1 kms)</p>
     * <p>If Value = 0xFFFFFFFF, Clients should ignore the data</p>
     *
     * @return The value of the field "lastValidDisTotal"
     */
    inline uint32 getLastValidDisTotal () const;

    /**
     * Sets the value of the member "lastValidDisTotal".
     *
     * <p>last Valid Total Distance travelled - persistently stored data updated on CAN updates</p>
     * <p>Resolution of the data is 0.1 (Actual = Status * 0.1 kms)</p>
     * <p>If Value = 0xFFFFFFFF, Clients should ignore the data</p>
     *
     * @param lastValidDisTotal The value which will be set
     */
    inline void setLastValidDisTotal (uint32 lastValidDisTotal_);

    // API of field "Unit"

    static const int kUnit = 2;

    /**
     * Clears the field "Unit".
     *
     * The field will be set to its default value. The hasUnit()
     * method will return false.
     */
    inline void clearUnit();

    /**
     * Checks whether the field "Unit" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUnit()). Otherwise it will return false.
     */
    inline bool hasUnit () const;

    /**
     * Returns the value of the member "Unit".
     *
     * <p>Unit of the DisTotal - CAN data</p>
     * <p>0 = kms, 1 = miles</p>
     *
     * @return The value of the field "Unit"
     */
    inline uint8 getUnit () const;

    /**
     * Sets the value of the member "Unit".
     *
     * <p>Unit of the DisTotal - CAN data</p>
     * <p>0 = kms, 1 = miles</p>
     *
     * @param Unit The value which will be set
     */
    inline void setUnit (uint8 Unit_);

    // API of field "DisTotalStatus"

    static const int kDisTotalStatus = 3;

    /**
     * Clears the field "DisTotalStatus".
     *
     * The field will be set to its default value. The hasDisTotalStatus()
     * method will return false.
     */
    inline void clearDisTotalStatus();

    /**
     * Checks whether the field "DisTotalStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDisTotalStatus()). Otherwise it will return false.
     */
    inline bool hasDisTotalStatus () const;

    /**
     * Returns the value of the member "DisTotalStatus".
     *
     * <p>Current Status of CAN Message Status Valid = TRUE, InValid = FALSE</p>
     *
     * @return The value of the field "DisTotalStatus"
     */
    inline bool getDisTotalStatus () const;

    /**
     * Sets the value of the member "DisTotalStatus".
     *
     * <p>Current Status of CAN Message Status Valid = TRUE, InValid = FALSE</p>
     *
     * @param DisTotalStatus The value which will be set
     */
    inline void setDisTotalStatus (bool DisTotalStatus_);

    static const DistanceTotalizerStatus &getDefaultInstance();

private:

    inline void set_has_DisTotal ();

    inline void clear_has_DisTotal ();

    inline void set_has_lastValidDisTotal ();

    inline void clear_has_lastValidDisTotal ();

    inline void set_has_Unit ();

    inline void clear_has_Unit ();

    inline void set_has_DisTotalStatus ();

    inline void clear_has_DisTotalStatus ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _DisTotal;

    uint32 _lastValidDisTotal;

    uint8 _Unit;

    bool _DisTotalStatus;

};

/**
 * The status message of the property "Mileage"
 * Calculated Mileage(Distance travelled) data in meters
 * <p>FUNCID = 0x1003,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class MileageStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MileageStatus ();

    /**
     * Copy constructor
     */
    inline  MileageStatus (const MileageStatus &rhs);

    /**
     * All fields constructor
     */
    inline  MileageStatus (uint32 Mileage_);

    /**
     * Destructor
     */
    inline virtual  ~MileageStatus();

    /**
     * Assignment operator
     */
    inline MileageStatus& operator = (const MileageStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MileageStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MileageStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MileageStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MileageStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Mileage"

    static const int kMileage = 0;

    /**
     * Clears the field "Mileage".
     *
     * The field will be set to its default value. The hasMileage()
     * method will return false.
     */
    inline void clearMileage();

    /**
     * Checks whether the field "Mileage" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMileage()). Otherwise it will return false.
     */
    inline bool hasMileage () const;

    /**
     * Returns the value of the member "Mileage".
     *
     * <p>Calculated Mileage data in meters on the basis of speed</p>
     * <p>Accumulation mileage [m] = Last Accumulation mileage [m] + (Speed Information [km/h] x 1/3600 x 1000)</p>
     *
     * @return The value of the field "Mileage"
     */
    inline uint32 getMileage () const;

    /**
     * Sets the value of the member "Mileage".
     *
     * <p>Calculated Mileage data in meters on the basis of speed</p>
     * <p>Accumulation mileage [m] = Last Accumulation mileage [m] + (Speed Information [km/h] x 1/3600 x 1000)</p>
     *
     * @param Mileage The value which will be set
     */
    inline void setMileage (uint32 Mileage_);

    static const MileageStatus &getDefaultInstance();

private:

    inline void set_has_Mileage ();

    inline void clear_has_Mileage ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _Mileage;

};

/**
 * The status message of the property "AvgFuelEconomy"
 * AvgFuelEconomy CAN data
 * <p>FUNCID = 0x1004,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class AvgFuelEconomyStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AvgFuelEconomyStatus ();

    /**
     * Copy constructor
     */
    inline  AvgFuelEconomyStatus (const AvgFuelEconomyStatus &rhs);

    /**
     * All fields constructor
     */
    inline  AvgFuelEconomyStatus (uint16 FuelEcon_);

    /**
     * Destructor
     */
    inline virtual  ~AvgFuelEconomyStatus();

    /**
     * Assignment operator
     */
    inline AvgFuelEconomyStatus& operator = (const AvgFuelEconomyStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AvgFuelEconomyStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AvgFuelEconomyStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AvgFuelEconomyStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AvgFuelEconomyStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "FuelEcon"

    static const int kFuelEcon = 0;

    /**
     * Clears the field "FuelEcon".
     *
     * The field will be set to its default value. The hasFuelEcon()
     * method will return false.
     */
    inline void clearFuelEcon();

    /**
     * Checks whether the field "FuelEcon" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFuelEcon()). Otherwise it will return false.
     */
    inline bool hasFuelEcon () const;

    /**
     * Returns the value of the member "FuelEcon".
     *
     * <p>Resolution of the data is 0.1 (Actual = Status * 0.1 km/L)</p>
     *
     * @return The value of the field "FuelEcon"
     */
    inline uint16 getFuelEcon () const;

    /**
     * Sets the value of the member "FuelEcon".
     *
     * <p>Resolution of the data is 0.1 (Actual = Status * 0.1 km/L)</p>
     *
     * @param FuelEcon The value which will be set
     */
    inline void setFuelEcon (uint16 FuelEcon_);

    static const AvgFuelEconomyStatus &getDefaultInstance();

private:

    inline void set_has_FuelEcon ();

    inline void clear_has_FuelEcon ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _FuelEcon;

};

/**
 * The status message of the property "TirePressureSupport"
 * Recommended Tire Pressure Support CAN Data
 * <p>FUNCID = 0x2005,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class TirePressureSupportStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TirePressureSupportStatus ();

    /**
     * Copy constructor
     */
    inline  TirePressureSupportStatus (const TirePressureSupportStatus &rhs);

    /**
     * All fields constructor
     */
    inline  TirePressureSupportStatus (bool PressureSupport_);

    /**
     * Destructor
     */
    inline virtual  ~TirePressureSupportStatus();

    /**
     * Assignment operator
     */
    inline TirePressureSupportStatus& operator = (const TirePressureSupportStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TirePressureSupportStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TirePressureSupportStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TirePressureSupportStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TirePressureSupportStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PressureSupport"

    static const int kPressureSupport = 0;

    /**
     * Clears the field "PressureSupport".
     *
     * The field will be set to its default value. The hasPressureSupport()
     * method will return false.
     */
    inline void clearPressureSupport();

    /**
     * Checks whether the field "PressureSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPressureSupport()). Otherwise it will return false.
     */
    inline bool hasPressureSupport () const;

    /**
     * Returns the value of the member "PressureSupport".
     *
     * <p>Gives the information whether tire pressure is supported or not supported</p>
     * <p>0x00 - Not Supported</p>
     * <p>0x01 - Supported</p>
     *
     * @return The value of the field "PressureSupport"
     */
    inline bool getPressureSupport () const;

    /**
     * Sets the value of the member "PressureSupport".
     *
     * <p>Gives the information whether tire pressure is supported or not supported</p>
     * <p>0x00 - Not Supported</p>
     * <p>0x01 - Supported</p>
     *
     * @param PressureSupport The value which will be set
     */
    inline void setPressureSupport (bool PressureSupport_);

    static const TirePressureSupportStatus &getDefaultInstance();

private:

    inline void set_has_PressureSupport ();

    inline void clear_has_PressureSupport ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _PressureSupport;

};

/**
 * The status message of the property "TPMSResetSupport"
 * TPMS Reset Support CAN Data
 * <p>FUNCID = 0x2006,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class TPMSResetSupportStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TPMSResetSupportStatus ();

    /**
     * Copy constructor
     */
    inline  TPMSResetSupportStatus (const TPMSResetSupportStatus &rhs);

    /**
     * All fields constructor
     */
    inline  TPMSResetSupportStatus (::vehicle_main_fi_types::T_e8_Vehicle_TPMSReset TPMSResetInfo_);

    /**
     * Destructor
     */
    inline virtual  ~TPMSResetSupportStatus();

    /**
     * Assignment operator
     */
    inline TPMSResetSupportStatus& operator = (const TPMSResetSupportStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TPMSResetSupportStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TPMSResetSupportStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TPMSResetSupportStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TPMSResetSupportStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TPMSResetInfo"

    static const int kTPMSResetInfo = 0;

    /**
     * Clears the field "TPMSResetInfo".
     *
     * The field will be set to its default value. The hasTPMSResetInfo()
     * method will return false.
     */
    inline void clearTPMSResetInfo();

    /**
     * Checks whether the field "TPMSResetInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTPMSResetInfo()). Otherwise it will return false.
     */
    inline bool hasTPMSResetInfo () const;

    /**
     * Returns the value of the member "TPMSResetInfo".
     *
     * <p>Gives the information whether TPMS Reset is supported or not supported</p>
     * <p>0x00 - Not Support This Function</p>
     * <p>0x01 - Support</p>
     * <p>0x02 - Support and reset</p>
     * <p>0x03 - No Definition</p>
     *
     * @return The value of the field "TPMSResetInfo"
     */
    inline ::vehicle_main_fi_types::T_e8_Vehicle_TPMSReset getTPMSResetInfo () const;

    /**
     * Sets the value of the member "TPMSResetInfo".
     *
     * <p>Gives the information whether TPMS Reset is supported or not supported</p>
     * <p>0x00 - Not Support This Function</p>
     * <p>0x01 - Support</p>
     * <p>0x02 - Support and reset</p>
     * <p>0x03 - No Definition</p>
     *
     * @param TPMSResetInfo The value which will be set
     */
    inline void setTPMSResetInfo (::vehicle_main_fi_types::T_e8_Vehicle_TPMSReset TPMSResetInfo_);

    static const TPMSResetSupportStatus &getDefaultInstance();

private:

    inline void set_has_TPMSResetInfo ();

    inline void clear_has_TPMSResetInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::vehicle_main_fi_types::T_e8_Vehicle_TPMSReset _TPMSResetInfo;

};

/**
 * The status message of the property "TirePressureSetting"
 * Used to set tire pressure for front and rear tyres
 * <p>FUNCID = 0x2007,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class TirePressureSettingStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TirePressureSettingStatus ();

    /**
     * Copy constructor
     */
    inline  TirePressureSettingStatus (const TirePressureSettingStatus &rhs);

    /**
     * All fields constructor
     */
    inline  TirePressureSettingStatus (uint16 SettingPressureFront_, uint16 SettingPressureRear_);

    /**
     * Destructor
     */
    inline virtual  ~TirePressureSettingStatus();

    /**
     * Assignment operator
     */
    inline TirePressureSettingStatus& operator = (const TirePressureSettingStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TirePressureSettingStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TirePressureSettingStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TirePressureSettingStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TirePressureSettingStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SettingPressureFront"

    static const int kSettingPressureFront = 0;

    /**
     * Clears the field "SettingPressureFront".
     *
     * The field will be set to its default value. The hasSettingPressureFront()
     * method will return false.
     */
    inline void clearSettingPressureFront();

    /**
     * Checks whether the field "SettingPressureFront" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSettingPressureFront()). Otherwise it will return false.
     */
    inline bool hasSettingPressureFront () const;

    /**
     * Returns the value of the member "SettingPressureFront".
     *
     * Gives the status of pressure for front tyre
     *
     * @return The value of the field "SettingPressureFront"
     */
    inline uint16 getSettingPressureFront () const;

    /**
     * Sets the value of the member "SettingPressureFront".
     *
     * Gives the status of pressure for front tyre
     *
     * @param SettingPressureFront The value which will be set
     */
    inline void setSettingPressureFront (uint16 SettingPressureFront_);

    // API of field "SettingPressureRear"

    static const int kSettingPressureRear = 1;

    /**
     * Clears the field "SettingPressureRear".
     *
     * The field will be set to its default value. The hasSettingPressureRear()
     * method will return false.
     */
    inline void clearSettingPressureRear();

    /**
     * Checks whether the field "SettingPressureRear" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSettingPressureRear()). Otherwise it will return false.
     */
    inline bool hasSettingPressureRear () const;

    /**
     * Returns the value of the member "SettingPressureRear".
     *
     * Gives the status of pressure for rear tyre
     *
     * @return The value of the field "SettingPressureRear"
     */
    inline uint16 getSettingPressureRear () const;

    /**
     * Sets the value of the member "SettingPressureRear".
     *
     * Gives the status of pressure for rear tyre
     *
     * @param SettingPressureRear The value which will be set
     */
    inline void setSettingPressureRear (uint16 SettingPressureRear_);

    static const TirePressureSettingStatus &getDefaultInstance();

private:

    inline void set_has_SettingPressureFront ();

    inline void clear_has_SettingPressureFront ();

    inline void set_has_SettingPressureRear ();

    inline void clear_has_SettingPressureRear ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _SettingPressureFront;

    uint16 _SettingPressureRear;

};

/**
 * The set message of the property "TirePressureSetting"
 * Used to set tire pressure for front and rear tyres
 * <p>FUNCID = 0x2007,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_VEHICLE_DATA,</p>
 * <p>APPID = CCA_C_U16_APP_VD_VEHICLE_DATA,</p>
 */
class TirePressureSettingSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TirePressureSettingSet ();

    /**
     * Copy constructor
     */
    inline  TirePressureSettingSet (const TirePressureSettingSet &rhs);

    /**
     * All fields constructor
     */
    inline  TirePressureSettingSet (::vehicle_main_fi_types::T_e8_Vehicle_TirePressureInfo TirePressureRequestInfo_);

    /**
     * Destructor
     */
    inline virtual  ~TirePressureSettingSet();

    /**
     * Assignment operator
     */
    inline TirePressureSettingSet& operator = (const TirePressureSettingSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TirePressureSettingSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TirePressureSettingSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TirePressureSettingSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TirePressureSettingSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TirePressureRequestInfo"

    static const int kTirePressureRequestInfo = 0;

    /**
     * Clears the field "TirePressureRequestInfo".
     *
     * The field will be set to its default value. The hasTirePressureRequestInfo()
     * method will return false.
     */
    inline void clearTirePressureRequestInfo();

    /**
     * Checks whether the field "TirePressureRequestInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTirePressureRequestInfo()). Otherwise it will return false.
     */
    inline bool hasTirePressureRequestInfo () const;

    /**
     * Returns the value of the member "TirePressureRequestInfo".
     *
     * Requests to set pressure for front and rear tyres
     *
     * @return The value of the field "TirePressureRequestInfo"
     */
    inline ::vehicle_main_fi_types::T_e8_Vehicle_TirePressureInfo getTirePressureRequestInfo () const;

    /**
     * Sets the value of the member "TirePressureRequestInfo".
     *
     * Requests to set pressure for front and rear tyres
     *
     * @param TirePressureRequestInfo The value which will be set
     */
    inline void setTirePressureRequestInfo (::vehicle_main_fi_types::T_e8_Vehicle_TirePressureInfo TirePressureRequestInfo_);

    static const TirePressureSettingSet &getDefaultInstance();

private:

    inline void set_has_TirePressureRequestInfo ();

    inline void clear_has_TirePressureRequestInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::vehicle_main_fi_types::T_e8_Vehicle_TirePressureInfo _TirePressureRequestInfo;

};

/**
 * The start message of the method "SetLanguage"
 * This method should be called to set new current language from a particular source
 * Method Start should consist of the Source ID and New Current Language data
 */
class SetLanguageStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetLanguageStart ();

    /**
     * Copy constructor
     */
    inline  SetLanguageStart (const SetLanguageStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetLanguageStart (::vehicle_main_fi_types::T_e8_Language_SourceId SourceId_, ::vehicle_main_fi_types::T_e8_Language_Code Language_);

    /**
     * Destructor
     */
    inline virtual  ~SetLanguageStart();

    /**
     * Assignment operator
     */
    inline SetLanguageStart& operator = (const SetLanguageStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetLanguageStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetLanguageStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetLanguageStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetLanguageStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SourceId"

    static const int kSourceId = 0;

    /**
     * Clears the field "SourceId".
     *
     * The field will be set to its default value. The hasSourceId()
     * method will return false.
     */
    inline void clearSourceId();

    /**
     * Checks whether the field "SourceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourceId()). Otherwise it will return false.
     */
    inline bool hasSourceId () const;

    /**
     * Returns the value of the member "SourceId".
     *
     * Source Component Id for which this current language is been updated
     *
     * @return The value of the field "SourceId"
     */
    inline ::vehicle_main_fi_types::T_e8_Language_SourceId getSourceId () const;

    /**
     * Sets the value of the member "SourceId".
     *
     * Source Component Id for which this current language is been updated
     *
     * @param SourceId The value which will be set
     */
    inline void setSourceId (::vehicle_main_fi_types::T_e8_Language_SourceId SourceId_);

    // API of field "Language"

    static const int kLanguage = 1;

    /**
     * Clears the field "Language".
     *
     * The field will be set to its default value. The hasLanguage()
     * method will return false.
     */
    inline void clearLanguage();

    /**
     * Checks whether the field "Language" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLanguage()). Otherwise it will return false.
     */
    inline bool hasLanguage () const;

    /**
     * Returns the value of the member "Language".
     *
     * New Language data
     *
     * @return The value of the field "Language"
     */
    inline ::vehicle_main_fi_types::T_e8_Language_Code getLanguage () const;

    /**
     * Sets the value of the member "Language".
     *
     * New Language data
     *
     * @param Language The value which will be set
     */
    inline void setLanguage (::vehicle_main_fi_types::T_e8_Language_Code Language_);

    static const SetLanguageStart &getDefaultInstance();

private:

    inline void set_has_SourceId ();

    inline void clear_has_SourceId ();

    inline void set_has_Language ();

    inline void clear_has_Language ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::vehicle_main_fi_types::T_e8_Language_SourceId _SourceId;

    ::vehicle_main_fi_types::T_e8_Language_Code _Language;

};

/**
 * The result message of the method "SetLanguage"
 * This method should be called to set new current language from a particular source
 * If the Language been set is supported or not
 */
class SetLanguageResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetLanguageResult ();

    /**
     * Copy constructor
     */
    inline  SetLanguageResult (const SetLanguageResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetLanguageResult (bool Result_);

    /**
     * Destructor
     */
    inline virtual  ~SetLanguageResult();

    /**
     * Assignment operator
     */
    inline SetLanguageResult& operator = (const SetLanguageResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetLanguageResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetLanguageResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetLanguageResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetLanguageResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * <p>TRUE if Language is supported</p>
     * <p>FALSE if new language is not supported</p>
     *
     * @return The value of the field "Result"
     */
    inline bool getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * <p>TRUE if Language is supported</p>
     * <p>FALSE if new language is not supported</p>
     *
     * @param Result The value which will be set
     */
    inline void setResult (bool Result_);

    static const SetLanguageResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Result;

};

/**
 * The start message of the method "RequestMeterLanguageSync"
 * This method should be used when Meter sync is requested by the user.
 * This will result in CAN Tx to Meter "MeterLanguageSyncMenu"
 * Method Start should consist of the Source ID and New Current Language data
 */
class RequestMeterLanguageSyncStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestMeterLanguageSyncStart ();

    /**
     * Copy constructor
     */
    inline  RequestMeterLanguageSyncStart (const RequestMeterLanguageSyncStart &rhs);

    /**
     * All fields constructor
     */
    inline  RequestMeterLanguageSyncStart (::vehicle_main_fi_types::T_e8_Meter_SyncRequest RequestId_);

    /**
     * Destructor
     */
    inline virtual  ~RequestMeterLanguageSyncStart();

    /**
     * Assignment operator
     */
    inline RequestMeterLanguageSyncStart& operator = (const RequestMeterLanguageSyncStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestMeterLanguageSyncStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestMeterLanguageSyncStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestMeterLanguageSyncStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestMeterLanguageSyncStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RequestId"

    static const int kRequestId = 0;

    /**
     * Clears the field "RequestId".
     *
     * The field will be set to its default value. The hasRequestId()
     * method will return false.
     */
    inline void clearRequestId();

    /**
     * Checks whether the field "RequestId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequestId()). Otherwise it will return false.
     */
    inline bool hasRequestId () const;

    /**
     * Returns the value of the member "RequestId".
     *
     * Requesting Meter for Synchronization setting
     *
     * @return The value of the field "RequestId"
     */
    inline ::vehicle_main_fi_types::T_e8_Meter_SyncRequest getRequestId () const;

    /**
     * Sets the value of the member "RequestId".
     *
     * Requesting Meter for Synchronization setting
     *
     * @param RequestId The value which will be set
     */
    inline void setRequestId (::vehicle_main_fi_types::T_e8_Meter_SyncRequest RequestId_);

    static const RequestMeterLanguageSyncStart &getDefaultInstance();

private:

    inline void set_has_RequestId ();

    inline void clear_has_RequestId ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::vehicle_main_fi_types::T_e8_Meter_SyncRequest _RequestId;

};

/**
 * The result message of the method "RequestMeterLanguageSync"
 * This method should be used when Meter sync is requested by the user.
 * This will result in CAN Tx to Meter "MeterLanguageSyncMenu"
 * If the Sync is requested or not
 */
class RequestMeterLanguageSyncResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestMeterLanguageSyncResult ();

    /**
     * Copy constructor
     */
    inline  RequestMeterLanguageSyncResult (const RequestMeterLanguageSyncResult &rhs);

    /**
     * All fields constructor
     */
    inline  RequestMeterLanguageSyncResult (bool Result_);

    /**
     * Destructor
     */
    inline virtual  ~RequestMeterLanguageSyncResult();

    /**
     * Assignment operator
     */
    inline RequestMeterLanguageSyncResult& operator = (const RequestMeterLanguageSyncResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestMeterLanguageSyncResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestMeterLanguageSyncResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestMeterLanguageSyncResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestMeterLanguageSyncResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * <p>TRUE if Sync is requested successfully</p>
     * <p>FALSE if Sync is not requested</p>
     *
     * @return The value of the field "Result"
     */
    inline bool getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * <p>TRUE if Sync is requested successfully</p>
     * <p>FALSE if Sync is not requested</p>
     *
     * @param Result The value which will be set
     */
    inline void setResult (bool Result_);

    static const RequestMeterLanguageSyncResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Result;

};

/**
 * The start message of the method "PhoneBTLinkStatus"
 * <p>CAN message to send the Phone BT  status  through CAN message PHONE status message</p>
 * <p>ID: 0x18FF114C</p>
 * Method Start can be triggered from phone to send the phone  BT  status details over can message
 */
class PhoneBTLinkStatusStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PhoneBTLinkStatusStart ();

    /**
     * Copy constructor
     */
    inline  PhoneBTLinkStatusStart (const PhoneBTLinkStatusStart &rhs);

    /**
     * All fields constructor
     */
    inline  PhoneBTLinkStatusStart (uint8 BTLinkStatus_);

    /**
     * Destructor
     */
    inline virtual  ~PhoneBTLinkStatusStart();

    /**
     * Assignment operator
     */
    inline PhoneBTLinkStatusStart& operator = (const PhoneBTLinkStatusStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PhoneBTLinkStatusStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PhoneBTLinkStatusStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PhoneBTLinkStatusStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PhoneBTLinkStatusStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BTLinkStatus"

    static const int kBTLinkStatus = 0;

    /**
     * Clears the field "BTLinkStatus".
     *
     * The field will be set to its default value. The hasBTLinkStatus()
     * method will return false.
     */
    inline void clearBTLinkStatus();

    /**
     * Checks whether the field "BTLinkStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBTLinkStatus()). Otherwise it will return false.
     */
    inline bool hasBTLinkStatus () const;

    /**
     * Returns the value of the member "BTLinkStatus".
     *
     * If the meaning of "BTLinkStatus" isn't clear, then there should be a description here.
     *
     * @return The value of the field "BTLinkStatus"
     */
    inline uint8 getBTLinkStatus () const;

    /**
     * Sets the value of the member "BTLinkStatus".
     *
     * If the meaning of "BTLinkStatus" isn't clear, then there should be a description here.
     *
     * @param BTLinkStatus The value which will be set
     */
    inline void setBTLinkStatus (uint8 BTLinkStatus_);

    static const PhoneBTLinkStatusStart &getDefaultInstance();

private:

    inline void set_has_BTLinkStatus ();

    inline void clear_has_BTLinkStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _BTLinkStatus;

};

/**
 * The result message of the method "PhoneBTLinkStatus"
 * <p>CAN message to send the Phone BT  status  through CAN message PHONE status message</p>
 * <p>ID: 0x18FF114C</p>
 * CAN Message data is sent through.
 */
class PhoneBTLinkStatusResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PhoneBTLinkStatusResult ();

    /**
     * Copy constructor
     */
    inline  PhoneBTLinkStatusResult (const PhoneBTLinkStatusResult &rhs);

    /**
     * All fields constructor
     */
    inline  PhoneBTLinkStatusResult (uint8 Result_);

    /**
     * Destructor
     */
    inline virtual  ~PhoneBTLinkStatusResult();

    /**
     * Assignment operator
     */
    inline PhoneBTLinkStatusResult& operator = (const PhoneBTLinkStatusResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PhoneBTLinkStatusResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PhoneBTLinkStatusResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PhoneBTLinkStatusResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PhoneBTLinkStatusResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline uint8 getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (uint8 Result_);

    static const PhoneBTLinkStatusResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Result;

};

/**
 * The start message of the method "PhoneBookSyncstatus"
 * <p>CAN message to send the Phone book sync status  through CAN message PHONE status message</p>
 * <p>ID: 0x18FF114C</p>
 * Method Start can be triggered from phone to send the phone  BT  status details over can message
 */
class PhoneBookSyncstatusStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PhoneBookSyncstatusStart ();

    /**
     * Copy constructor
     */
    inline  PhoneBookSyncstatusStart (const PhoneBookSyncstatusStart &rhs);

    /**
     * All fields constructor
     */
    inline  PhoneBookSyncstatusStart (uint8 PhoneBookSyncStatusValue_);

    /**
     * Destructor
     */
    inline virtual  ~PhoneBookSyncstatusStart();

    /**
     * Assignment operator
     */
    inline PhoneBookSyncstatusStart& operator = (const PhoneBookSyncstatusStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PhoneBookSyncstatusStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PhoneBookSyncstatusStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PhoneBookSyncstatusStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PhoneBookSyncstatusStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PhoneBookSyncStatusValue"

    static const int kPhoneBookSyncStatusValue = 0;

    /**
     * Clears the field "PhoneBookSyncStatusValue".
     *
     * The field will be set to its default value. The hasPhoneBookSyncStatusValue()
     * method will return false.
     */
    inline void clearPhoneBookSyncStatusValue();

    /**
     * Checks whether the field "PhoneBookSyncStatusValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhoneBookSyncStatusValue()). Otherwise it will return false.
     */
    inline bool hasPhoneBookSyncStatusValue () const;

    /**
     * Returns the value of the member "PhoneBookSyncStatusValue".
     *
     * If the meaning of "PhoneBookSyncStatusValue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "PhoneBookSyncStatusValue"
     */
    inline uint8 getPhoneBookSyncStatusValue () const;

    /**
     * Sets the value of the member "PhoneBookSyncStatusValue".
     *
     * If the meaning of "PhoneBookSyncStatusValue" isn't clear, then there should be a description here.
     *
     * @param PhoneBookSyncStatusValue The value which will be set
     */
    inline void setPhoneBookSyncStatusValue (uint8 PhoneBookSyncStatusValue_);

    static const PhoneBookSyncstatusStart &getDefaultInstance();

private:

    inline void set_has_PhoneBookSyncStatusValue ();

    inline void clear_has_PhoneBookSyncStatusValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _PhoneBookSyncStatusValue;

};

/**
 * The result message of the method "PhoneBookSyncstatus"
 * <p>CAN message to send the Phone book sync status  through CAN message PHONE status message</p>
 * <p>ID: 0x18FF114C</p>
 * CAN Message data is sent through.
 */
class PhoneBookSyncstatusResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PhoneBookSyncstatusResult ();

    /**
     * Copy constructor
     */
    inline  PhoneBookSyncstatusResult (const PhoneBookSyncstatusResult &rhs);

    /**
     * All fields constructor
     */
    inline  PhoneBookSyncstatusResult (uint8 Result_);

    /**
     * Destructor
     */
    inline virtual  ~PhoneBookSyncstatusResult();

    /**
     * Assignment operator
     */
    inline PhoneBookSyncstatusResult& operator = (const PhoneBookSyncstatusResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PhoneBookSyncstatusResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PhoneBookSyncstatusResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PhoneBookSyncstatusResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PhoneBookSyncstatusResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline uint8 getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (uint8 Result_);

    static const PhoneBookSyncstatusResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Result;

};

/**
 * The start message of the method "CallHistorySyncStatus"
 * <p>CAN message to send the Phone book sync status  through CAN message PHONE status message</p>
 * <p>ID: 0x18FF114C</p>
 * Method Start can be triggered from phone to send the call history  status details over can message
 */
class CallHistorySyncStatusStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CallHistorySyncStatusStart ();

    /**
     * Copy constructor
     */
    inline  CallHistorySyncStatusStart (const CallHistorySyncStatusStart &rhs);

    /**
     * All fields constructor
     */
    inline  CallHistorySyncStatusStart (uint8 CallHistorySyncStatusValue_);

    /**
     * Destructor
     */
    inline virtual  ~CallHistorySyncStatusStart();

    /**
     * Assignment operator
     */
    inline CallHistorySyncStatusStart& operator = (const CallHistorySyncStatusStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CallHistorySyncStatusStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CallHistorySyncStatusStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CallHistorySyncStatusStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CallHistorySyncStatusStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CallHistorySyncStatusValue"

    static const int kCallHistorySyncStatusValue = 0;

    /**
     * Clears the field "CallHistorySyncStatusValue".
     *
     * The field will be set to its default value. The hasCallHistorySyncStatusValue()
     * method will return false.
     */
    inline void clearCallHistorySyncStatusValue();

    /**
     * Checks whether the field "CallHistorySyncStatusValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCallHistorySyncStatusValue()). Otherwise it will return false.
     */
    inline bool hasCallHistorySyncStatusValue () const;

    /**
     * Returns the value of the member "CallHistorySyncStatusValue".
     *
     * If the meaning of "CallHistorySyncStatusValue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "CallHistorySyncStatusValue"
     */
    inline uint8 getCallHistorySyncStatusValue () const;

    /**
     * Sets the value of the member "CallHistorySyncStatusValue".
     *
     * If the meaning of "CallHistorySyncStatusValue" isn't clear, then there should be a description here.
     *
     * @param CallHistorySyncStatusValue The value which will be set
     */
    inline void setCallHistorySyncStatusValue (uint8 CallHistorySyncStatusValue_);

    static const CallHistorySyncStatusStart &getDefaultInstance();

private:

    inline void set_has_CallHistorySyncStatusValue ();

    inline void clear_has_CallHistorySyncStatusValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _CallHistorySyncStatusValue;

};

/**
 * The result message of the method "CallHistorySyncStatus"
 * <p>CAN message to send the Phone book sync status  through CAN message PHONE status message</p>
 * <p>ID: 0x18FF114C</p>
 * CAN Message data is sent through.
 */
class CallHistorySyncStatusResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CallHistorySyncStatusResult ();

    /**
     * Copy constructor
     */
    inline  CallHistorySyncStatusResult (const CallHistorySyncStatusResult &rhs);

    /**
     * All fields constructor
     */
    inline  CallHistorySyncStatusResult (uint8 Result_);

    /**
     * Destructor
     */
    inline virtual  ~CallHistorySyncStatusResult();

    /**
     * Assignment operator
     */
    inline CallHistorySyncStatusResult& operator = (const CallHistorySyncStatusResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CallHistorySyncStatusResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CallHistorySyncStatusResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CallHistorySyncStatusResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CallHistorySyncStatusResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline uint8 getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (uint8 Result_);

    static const CallHistorySyncStatusResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Result;

};

/**
 * The start message of the method "PhoneStatusRoaming"
 * <p>CAN message to send the roaming status  through CAN message PHONE status message</p>
 * <p>ID: 0x18FF114C</p>
 * Method Start can be triggered from phone to send the Roamimg  status details over can message
 */
class PhoneStatusRoamingStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PhoneStatusRoamingStart ();

    /**
     * Copy constructor
     */
    inline  PhoneStatusRoamingStart (const PhoneStatusRoamingStart &rhs);

    /**
     * All fields constructor
     */
    inline  PhoneStatusRoamingStart (uint8 PhoneStatusRoamingValue_);

    /**
     * Destructor
     */
    inline virtual  ~PhoneStatusRoamingStart();

    /**
     * Assignment operator
     */
    inline PhoneStatusRoamingStart& operator = (const PhoneStatusRoamingStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PhoneStatusRoamingStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PhoneStatusRoamingStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PhoneStatusRoamingStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PhoneStatusRoamingStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PhoneStatusRoamingValue"

    static const int kPhoneStatusRoamingValue = 0;

    /**
     * Clears the field "PhoneStatusRoamingValue".
     *
     * The field will be set to its default value. The hasPhoneStatusRoamingValue()
     * method will return false.
     */
    inline void clearPhoneStatusRoamingValue();

    /**
     * Checks whether the field "PhoneStatusRoamingValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhoneStatusRoamingValue()). Otherwise it will return false.
     */
    inline bool hasPhoneStatusRoamingValue () const;

    /**
     * Returns the value of the member "PhoneStatusRoamingValue".
     *
     * If the meaning of "PhoneStatusRoamingValue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "PhoneStatusRoamingValue"
     */
    inline uint8 getPhoneStatusRoamingValue () const;

    /**
     * Sets the value of the member "PhoneStatusRoamingValue".
     *
     * If the meaning of "PhoneStatusRoamingValue" isn't clear, then there should be a description here.
     *
     * @param PhoneStatusRoamingValue The value which will be set
     */
    inline void setPhoneStatusRoamingValue (uint8 PhoneStatusRoamingValue_);

    static const PhoneStatusRoamingStart &getDefaultInstance();

private:

    inline void set_has_PhoneStatusRoamingValue ();

    inline void clear_has_PhoneStatusRoamingValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _PhoneStatusRoamingValue;

};

/**
 * The result message of the method "PhoneStatusRoaming"
 * <p>CAN message to send the roaming status  through CAN message PHONE status message</p>
 * <p>ID: 0x18FF114C</p>
 * CAN Message data is sent through.
 */
class PhoneStatusRoamingResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PhoneStatusRoamingResult ();

    /**
     * Copy constructor
     */
    inline  PhoneStatusRoamingResult (const PhoneStatusRoamingResult &rhs);

    /**
     * All fields constructor
     */
    inline  PhoneStatusRoamingResult (uint8 Result_);

    /**
     * Destructor
     */
    inline virtual  ~PhoneStatusRoamingResult();

    /**
     * Assignment operator
     */
    inline PhoneStatusRoamingResult& operator = (const PhoneStatusRoamingResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PhoneStatusRoamingResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PhoneStatusRoamingResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PhoneStatusRoamingResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PhoneStatusRoamingResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline uint8 getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (uint8 Result_);

    static const PhoneStatusRoamingResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Result;

};

/**
 * The start message of the method "CallDuration"
 * <p>CAN message to send the call duration value  through CAN message PHONE status message</p>
 * <p>ID: 0x18FF114C</p>
 * Method Start can be triggered from phone to send the Call duration value details over can message
 */
class CallDurationStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CallDurationStart ();

    /**
     * Copy constructor
     */
    inline  CallDurationStart (const CallDurationStart &rhs);

    /**
     * All fields constructor
     */
    inline  CallDurationStart (uint16 CallDurationValue_);

    /**
     * Destructor
     */
    inline virtual  ~CallDurationStart();

    /**
     * Assignment operator
     */
    inline CallDurationStart& operator = (const CallDurationStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CallDurationStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CallDurationStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CallDurationStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CallDurationStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CallDurationValue"

    static const int kCallDurationValue = 0;

    /**
     * Clears the field "CallDurationValue".
     *
     * The field will be set to its default value. The hasCallDurationValue()
     * method will return false.
     */
    inline void clearCallDurationValue();

    /**
     * Checks whether the field "CallDurationValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCallDurationValue()). Otherwise it will return false.
     */
    inline bool hasCallDurationValue () const;

    /**
     * Returns the value of the member "CallDurationValue".
     *
     * If the meaning of "CallDurationValue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "CallDurationValue"
     */
    inline uint16 getCallDurationValue () const;

    /**
     * Sets the value of the member "CallDurationValue".
     *
     * If the meaning of "CallDurationValue" isn't clear, then there should be a description here.
     *
     * @param CallDurationValue The value which will be set
     */
    inline void setCallDurationValue (uint16 CallDurationValue_);

    static const CallDurationStart &getDefaultInstance();

private:

    inline void set_has_CallDurationValue ();

    inline void clear_has_CallDurationValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _CallDurationValue;

};

/**
 * The result message of the method "CallDuration"
 * <p>CAN message to send the call duration value  through CAN message PHONE status message</p>
 * <p>ID: 0x18FF114C</p>
 * CAN Message data is sent through.
 */
class CallDurationResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CallDurationResult ();

    /**
     * Copy constructor
     */
    inline  CallDurationResult (const CallDurationResult &rhs);

    /**
     * All fields constructor
     */
    inline  CallDurationResult (uint8 Result_);

    /**
     * Destructor
     */
    inline virtual  ~CallDurationResult();

    /**
     * Assignment operator
     */
    inline CallDurationResult& operator = (const CallDurationResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CallDurationResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CallDurationResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CallDurationResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CallDurationResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline uint8 getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (uint8 Result_);

    static const CallDurationResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Result;

};

/**
 * The start message of the method "GSMSignalStrength"
 * <p>CAN message to send the GSM Signal strength status through CAN message PHONE status message</p>
 * <p>ID: 0x18FF114C</p>
 * Method Start can be triggered from phone to send the Call duration value details over can message
 */
class GSMSignalStrengthStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GSMSignalStrengthStart ();

    /**
     * Copy constructor
     */
    inline  GSMSignalStrengthStart (const GSMSignalStrengthStart &rhs);

    /**
     * All fields constructor
     */
    inline  GSMSignalStrengthStart (uint8 GSMSignalStrengthValue_);

    /**
     * Destructor
     */
    inline virtual  ~GSMSignalStrengthStart();

    /**
     * Assignment operator
     */
    inline GSMSignalStrengthStart& operator = (const GSMSignalStrengthStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GSMSignalStrengthStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GSMSignalStrengthStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GSMSignalStrengthStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GSMSignalStrengthStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "GSMSignalStrengthValue"

    static const int kGSMSignalStrengthValue = 0;

    /**
     * Clears the field "GSMSignalStrengthValue".
     *
     * The field will be set to its default value. The hasGSMSignalStrengthValue()
     * method will return false.
     */
    inline void clearGSMSignalStrengthValue();

    /**
     * Checks whether the field "GSMSignalStrengthValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGSMSignalStrengthValue()). Otherwise it will return false.
     */
    inline bool hasGSMSignalStrengthValue () const;

    /**
     * Returns the value of the member "GSMSignalStrengthValue".
     *
     * If the meaning of "GSMSignalStrengthValue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "GSMSignalStrengthValue"
     */
    inline uint8 getGSMSignalStrengthValue () const;

    /**
     * Sets the value of the member "GSMSignalStrengthValue".
     *
     * If the meaning of "GSMSignalStrengthValue" isn't clear, then there should be a description here.
     *
     * @param GSMSignalStrengthValue The value which will be set
     */
    inline void setGSMSignalStrengthValue (uint8 GSMSignalStrengthValue_);

    static const GSMSignalStrengthStart &getDefaultInstance();

private:

    inline void set_has_GSMSignalStrengthValue ();

    inline void clear_has_GSMSignalStrengthValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _GSMSignalStrengthValue;

};

/**
 * The result message of the method "GSMSignalStrength"
 * <p>CAN message to send the GSM Signal strength status through CAN message PHONE status message</p>
 * <p>ID: 0x18FF114C</p>
 * CAN Message data is sent through.
 */
class GSMSignalStrengthResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GSMSignalStrengthResult ();

    /**
     * Copy constructor
     */
    inline  GSMSignalStrengthResult (const GSMSignalStrengthResult &rhs);

    /**
     * All fields constructor
     */
    inline  GSMSignalStrengthResult (uint8 Result_);

    /**
     * Destructor
     */
    inline virtual  ~GSMSignalStrengthResult();

    /**
     * Assignment operator
     */
    inline GSMSignalStrengthResult& operator = (const GSMSignalStrengthResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GSMSignalStrengthResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GSMSignalStrengthResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GSMSignalStrengthResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GSMSignalStrengthResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline uint8 getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (uint8 Result_);

    static const GSMSignalStrengthResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Result;

};

/**
 * The start message of the method "PhoneAvailableStatus"
 * <p>CAN message to send the Phone Availble status through CAN message PHONE status message</p>
 * <p>ID: 0x18FF114C</p>
 * Method Start can be triggered from phone to send the Phone Availble status value details over can message
 */
class PhoneAvailableStatusStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PhoneAvailableStatusStart ();

    /**
     * Copy constructor
     */
    inline  PhoneAvailableStatusStart (const PhoneAvailableStatusStart &rhs);

    /**
     * All fields constructor
     */
    inline  PhoneAvailableStatusStart (uint8 PhoneAvailableStatusValue_);

    /**
     * Destructor
     */
    inline virtual  ~PhoneAvailableStatusStart();

    /**
     * Assignment operator
     */
    inline PhoneAvailableStatusStart& operator = (const PhoneAvailableStatusStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PhoneAvailableStatusStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PhoneAvailableStatusStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PhoneAvailableStatusStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PhoneAvailableStatusStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PhoneAvailableStatusValue"

    static const int kPhoneAvailableStatusValue = 0;

    /**
     * Clears the field "PhoneAvailableStatusValue".
     *
     * The field will be set to its default value. The hasPhoneAvailableStatusValue()
     * method will return false.
     */
    inline void clearPhoneAvailableStatusValue();

    /**
     * Checks whether the field "PhoneAvailableStatusValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhoneAvailableStatusValue()). Otherwise it will return false.
     */
    inline bool hasPhoneAvailableStatusValue () const;

    /**
     * Returns the value of the member "PhoneAvailableStatusValue".
     *
     * If the meaning of "PhoneAvailableStatusValue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "PhoneAvailableStatusValue"
     */
    inline uint8 getPhoneAvailableStatusValue () const;

    /**
     * Sets the value of the member "PhoneAvailableStatusValue".
     *
     * If the meaning of "PhoneAvailableStatusValue" isn't clear, then there should be a description here.
     *
     * @param PhoneAvailableStatusValue The value which will be set
     */
    inline void setPhoneAvailableStatusValue (uint8 PhoneAvailableStatusValue_);

    static const PhoneAvailableStatusStart &getDefaultInstance();

private:

    inline void set_has_PhoneAvailableStatusValue ();

    inline void clear_has_PhoneAvailableStatusValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _PhoneAvailableStatusValue;

};

/**
 * The result message of the method "PhoneAvailableStatus"
 * <p>CAN message to send the Phone Availble status through CAN message PHONE status message</p>
 * <p>ID: 0x18FF114C</p>
 * CAN Message data is sent through.
 */
class PhoneAvailableStatusResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PhoneAvailableStatusResult ();

    /**
     * Copy constructor
     */
    inline  PhoneAvailableStatusResult (const PhoneAvailableStatusResult &rhs);

    /**
     * All fields constructor
     */
    inline  PhoneAvailableStatusResult (uint8 Result_);

    /**
     * Destructor
     */
    inline virtual  ~PhoneAvailableStatusResult();

    /**
     * Assignment operator
     */
    inline PhoneAvailableStatusResult& operator = (const PhoneAvailableStatusResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PhoneAvailableStatusResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PhoneAvailableStatusResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PhoneAvailableStatusResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PhoneAvailableStatusResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline uint8 getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (uint8 Result_);

    static const PhoneAvailableStatusResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Result;

};

/**
 * The start message of the method "PhoneCallStatus"
 * <p>CAN message to send the Phone call status through CAN message PHONE status message</p>
 * <p>ID: 0x18FF114C</p>
 * Method Start can be triggered from phone to send the Phone call status value details over can message
 */
class PhoneCallStatusStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PhoneCallStatusStart ();

    /**
     * Copy constructor
     */
    inline  PhoneCallStatusStart (const PhoneCallStatusStart &rhs);

    /**
     * All fields constructor
     */
    inline  PhoneCallStatusStart (uint8 CallStatusValue_);

    /**
     * Destructor
     */
    inline virtual  ~PhoneCallStatusStart();

    /**
     * Assignment operator
     */
    inline PhoneCallStatusStart& operator = (const PhoneCallStatusStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PhoneCallStatusStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PhoneCallStatusStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PhoneCallStatusStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PhoneCallStatusStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CallStatusValue"

    static const int kCallStatusValue = 0;

    /**
     * Clears the field "CallStatusValue".
     *
     * The field will be set to its default value. The hasCallStatusValue()
     * method will return false.
     */
    inline void clearCallStatusValue();

    /**
     * Checks whether the field "CallStatusValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCallStatusValue()). Otherwise it will return false.
     */
    inline bool hasCallStatusValue () const;

    /**
     * Returns the value of the member "CallStatusValue".
     *
     * If the meaning of "CallStatusValue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "CallStatusValue"
     */
    inline uint8 getCallStatusValue () const;

    /**
     * Sets the value of the member "CallStatusValue".
     *
     * If the meaning of "CallStatusValue" isn't clear, then there should be a description here.
     *
     * @param CallStatusValue The value which will be set
     */
    inline void setCallStatusValue (uint8 CallStatusValue_);

    static const PhoneCallStatusStart &getDefaultInstance();

private:

    inline void set_has_CallStatusValue ();

    inline void clear_has_CallStatusValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _CallStatusValue;

};

/**
 * The result message of the method "PhoneCallStatus"
 * <p>CAN message to send the Phone call status through CAN message PHONE status message</p>
 * <p>ID: 0x18FF114C</p>
 * CAN Message data is sent through.
 */
class PhoneCallStatusResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PhoneCallStatusResult ();

    /**
     * Copy constructor
     */
    inline  PhoneCallStatusResult (const PhoneCallStatusResult &rhs);

    /**
     * All fields constructor
     */
    inline  PhoneCallStatusResult (uint8 Result_);

    /**
     * Destructor
     */
    inline virtual  ~PhoneCallStatusResult();

    /**
     * Assignment operator
     */
    inline PhoneCallStatusResult& operator = (const PhoneCallStatusResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PhoneCallStatusResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PhoneCallStatusResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PhoneCallStatusResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PhoneCallStatusResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline uint8 getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (uint8 Result_);

    static const PhoneCallStatusResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Result;

};

/**
 * The start message of the method "PhoneBatteryLevelStatus"
 * <p>CAN message to send the Phone Battery level status through CAN message PHONE status message</p>
 * <p>ID: 0x18FF114C</p>
 * Method Start can be triggered from phone to send the Phone call status value details over can message
 */
class PhoneBatteryLevelStatusStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PhoneBatteryLevelStatusStart ();

    /**
     * Copy constructor
     */
    inline  PhoneBatteryLevelStatusStart (const PhoneBatteryLevelStatusStart &rhs);

    /**
     * All fields constructor
     */
    inline  PhoneBatteryLevelStatusStart (uint8 PhoneBatteryLevelStatusValue_);

    /**
     * Destructor
     */
    inline virtual  ~PhoneBatteryLevelStatusStart();

    /**
     * Assignment operator
     */
    inline PhoneBatteryLevelStatusStart& operator = (const PhoneBatteryLevelStatusStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PhoneBatteryLevelStatusStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PhoneBatteryLevelStatusStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PhoneBatteryLevelStatusStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PhoneBatteryLevelStatusStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PhoneBatteryLevelStatusValue"

    static const int kPhoneBatteryLevelStatusValue = 0;

    /**
     * Clears the field "PhoneBatteryLevelStatusValue".
     *
     * The field will be set to its default value. The hasPhoneBatteryLevelStatusValue()
     * method will return false.
     */
    inline void clearPhoneBatteryLevelStatusValue();

    /**
     * Checks whether the field "PhoneBatteryLevelStatusValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhoneBatteryLevelStatusValue()). Otherwise it will return false.
     */
    inline bool hasPhoneBatteryLevelStatusValue () const;

    /**
     * Returns the value of the member "PhoneBatteryLevelStatusValue".
     *
     * If the meaning of "PhoneBatteryLevelStatusValue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "PhoneBatteryLevelStatusValue"
     */
    inline uint8 getPhoneBatteryLevelStatusValue () const;

    /**
     * Sets the value of the member "PhoneBatteryLevelStatusValue".
     *
     * If the meaning of "PhoneBatteryLevelStatusValue" isn't clear, then there should be a description here.
     *
     * @param PhoneBatteryLevelStatusValue The value which will be set
     */
    inline void setPhoneBatteryLevelStatusValue (uint8 PhoneBatteryLevelStatusValue_);

    static const PhoneBatteryLevelStatusStart &getDefaultInstance();

private:

    inline void set_has_PhoneBatteryLevelStatusValue ();

    inline void clear_has_PhoneBatteryLevelStatusValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _PhoneBatteryLevelStatusValue;

};

/**
 * The result message of the method "PhoneBatteryLevelStatus"
 * <p>CAN message to send the Phone Battery level status through CAN message PHONE status message</p>
 * <p>ID: 0x18FF114C</p>
 * CAN Message data is sent through.
 */
class PhoneBatteryLevelStatusResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PhoneBatteryLevelStatusResult ();

    /**
     * Copy constructor
     */
    inline  PhoneBatteryLevelStatusResult (const PhoneBatteryLevelStatusResult &rhs);

    /**
     * All fields constructor
     */
    inline  PhoneBatteryLevelStatusResult (uint8 Result_);

    /**
     * Destructor
     */
    inline virtual  ~PhoneBatteryLevelStatusResult();

    /**
     * Assignment operator
     */
    inline PhoneBatteryLevelStatusResult& operator = (const PhoneBatteryLevelStatusResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PhoneBatteryLevelStatusResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PhoneBatteryLevelStatusResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PhoneBatteryLevelStatusResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PhoneBatteryLevelStatusResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline uint8 getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (uint8 Result_);

    static const PhoneBatteryLevelStatusResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Result;

};

/**
 * The start message of the method "PhoneVRAvailable"
 * <p>CAN message to send the phone vr available status through CAN message PHONE status message</p>
 * Method Start can be triggered from phone to send the  phone vr availablestatus value details over can message
 */
class PhoneVRAvailableStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PhoneVRAvailableStart ();

    /**
     * Copy constructor
     */
    inline  PhoneVRAvailableStart (const PhoneVRAvailableStart &rhs);

    /**
     * All fields constructor
     */
    inline  PhoneVRAvailableStart (uint8 PhoneVRAvailableValue_);

    /**
     * Destructor
     */
    inline virtual  ~PhoneVRAvailableStart();

    /**
     * Assignment operator
     */
    inline PhoneVRAvailableStart& operator = (const PhoneVRAvailableStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PhoneVRAvailableStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PhoneVRAvailableStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PhoneVRAvailableStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PhoneVRAvailableStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PhoneVRAvailableValue"

    static const int kPhoneVRAvailableValue = 0;

    /**
     * Clears the field "PhoneVRAvailableValue".
     *
     * The field will be set to its default value. The hasPhoneVRAvailableValue()
     * method will return false.
     */
    inline void clearPhoneVRAvailableValue();

    /**
     * Checks whether the field "PhoneVRAvailableValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhoneVRAvailableValue()). Otherwise it will return false.
     */
    inline bool hasPhoneVRAvailableValue () const;

    /**
     * Returns the value of the member "PhoneVRAvailableValue".
     *
     * If the meaning of "PhoneVRAvailableValue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "PhoneVRAvailableValue"
     */
    inline uint8 getPhoneVRAvailableValue () const;

    /**
     * Sets the value of the member "PhoneVRAvailableValue".
     *
     * If the meaning of "PhoneVRAvailableValue" isn't clear, then there should be a description here.
     *
     * @param PhoneVRAvailableValue The value which will be set
     */
    inline void setPhoneVRAvailableValue (uint8 PhoneVRAvailableValue_);

    static const PhoneVRAvailableStart &getDefaultInstance();

private:

    inline void set_has_PhoneVRAvailableValue ();

    inline void clear_has_PhoneVRAvailableValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _PhoneVRAvailableValue;

};

/**
 * The result message of the method "PhoneVRAvailable"
 * <p>CAN message to send the phone vr available status through CAN message PHONE status message</p>
 * CAN Message data is sent through.
 */
class PhoneVRAvailableResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PhoneVRAvailableResult ();

    /**
     * Copy constructor
     */
    inline  PhoneVRAvailableResult (const PhoneVRAvailableResult &rhs);

    /**
     * All fields constructor
     */
    inline  PhoneVRAvailableResult (uint8 Result_);

    /**
     * Destructor
     */
    inline virtual  ~PhoneVRAvailableResult();

    /**
     * Assignment operator
     */
    inline PhoneVRAvailableResult& operator = (const PhoneVRAvailableResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PhoneVRAvailableResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PhoneVRAvailableResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PhoneVRAvailableResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PhoneVRAvailableResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline uint8 getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (uint8 Result_);

    static const PhoneVRAvailableResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Result;

};

/**
 * The start message of the method "DeviceStatusWifiAvailable"
 * <p>CAN message to send the Wifi status  through CAN message Device status message</p>
 * <p>ID: 0x18FF114C</p>
 * Method Start can be triggered from phone to send the wifi status details over can message
 */
class DeviceStatusWifiAvailableStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeviceStatusWifiAvailableStart ();

    /**
     * Copy constructor
     */
    inline  DeviceStatusWifiAvailableStart (const DeviceStatusWifiAvailableStart &rhs);

    /**
     * All fields constructor
     */
    inline  DeviceStatusWifiAvailableStart (uint8 DeviceStatusWifiStatus_);

    /**
     * Destructor
     */
    inline virtual  ~DeviceStatusWifiAvailableStart();

    /**
     * Assignment operator
     */
    inline DeviceStatusWifiAvailableStart& operator = (const DeviceStatusWifiAvailableStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceStatusWifiAvailableStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceStatusWifiAvailableStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceStatusWifiAvailableStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceStatusWifiAvailableStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceStatusWifiStatus"

    static const int kDeviceStatusWifiStatus = 0;

    /**
     * Clears the field "DeviceStatusWifiStatus".
     *
     * The field will be set to its default value. The hasDeviceStatusWifiStatus()
     * method will return false.
     */
    inline void clearDeviceStatusWifiStatus();

    /**
     * Checks whether the field "DeviceStatusWifiStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceStatusWifiStatus()). Otherwise it will return false.
     */
    inline bool hasDeviceStatusWifiStatus () const;

    /**
     * Returns the value of the member "DeviceStatusWifiStatus".
     *
     * If the meaning of "DeviceStatusWifiStatus" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DeviceStatusWifiStatus"
     */
    inline uint8 getDeviceStatusWifiStatus () const;

    /**
     * Sets the value of the member "DeviceStatusWifiStatus".
     *
     * If the meaning of "DeviceStatusWifiStatus" isn't clear, then there should be a description here.
     *
     * @param DeviceStatusWifiStatus The value which will be set
     */
    inline void setDeviceStatusWifiStatus (uint8 DeviceStatusWifiStatus_);

    static const DeviceStatusWifiAvailableStart &getDefaultInstance();

private:

    inline void set_has_DeviceStatusWifiStatus ();

    inline void clear_has_DeviceStatusWifiStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _DeviceStatusWifiStatus;

};

/**
 * The result message of the method "DeviceStatusWifiAvailable"
 * <p>CAN message to send the Wifi status  through CAN message Device status message</p>
 * <p>ID: 0x18FF114C</p>
 * CAN Message data is sent through.
 */
class DeviceStatusWifiAvailableResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeviceStatusWifiAvailableResult ();

    /**
     * Copy constructor
     */
    inline  DeviceStatusWifiAvailableResult (const DeviceStatusWifiAvailableResult &rhs);

    /**
     * All fields constructor
     */
    inline  DeviceStatusWifiAvailableResult (uint8 Result_);

    /**
     * Destructor
     */
    inline virtual  ~DeviceStatusWifiAvailableResult();

    /**
     * Assignment operator
     */
    inline DeviceStatusWifiAvailableResult& operator = (const DeviceStatusWifiAvailableResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceStatusWifiAvailableResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceStatusWifiAvailableResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceStatusWifiAvailableResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceStatusWifiAvailableResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline uint8 getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (uint8 Result_);

    static const DeviceStatusWifiAvailableResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Result;

};

/**
 * The start message of the method "DeviceStatusBTStatus"
 * <p>CAN message to send the BT status  through CAN message Device status message</p>
 * <p>ID: 0x18FF114C</p>
 * Method Start can be triggered from phone to send the BT status details over can message
 */
class DeviceStatusBTStatusStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeviceStatusBTStatusStart ();

    /**
     * Copy constructor
     */
    inline  DeviceStatusBTStatusStart (const DeviceStatusBTStatusStart &rhs);

    /**
     * All fields constructor
     */
    inline  DeviceStatusBTStatusStart (uint8 DeviceStatusBTStatusValue_);

    /**
     * Destructor
     */
    inline virtual  ~DeviceStatusBTStatusStart();

    /**
     * Assignment operator
     */
    inline DeviceStatusBTStatusStart& operator = (const DeviceStatusBTStatusStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceStatusBTStatusStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceStatusBTStatusStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceStatusBTStatusStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceStatusBTStatusStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceStatusBTStatusValue"

    static const int kDeviceStatusBTStatusValue = 0;

    /**
     * Clears the field "DeviceStatusBTStatusValue".
     *
     * The field will be set to its default value. The hasDeviceStatusBTStatusValue()
     * method will return false.
     */
    inline void clearDeviceStatusBTStatusValue();

    /**
     * Checks whether the field "DeviceStatusBTStatusValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceStatusBTStatusValue()). Otherwise it will return false.
     */
    inline bool hasDeviceStatusBTStatusValue () const;

    /**
     * Returns the value of the member "DeviceStatusBTStatusValue".
     *
     * If the meaning of "DeviceStatusBTStatusValue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DeviceStatusBTStatusValue"
     */
    inline uint8 getDeviceStatusBTStatusValue () const;

    /**
     * Sets the value of the member "DeviceStatusBTStatusValue".
     *
     * If the meaning of "DeviceStatusBTStatusValue" isn't clear, then there should be a description here.
     *
     * @param DeviceStatusBTStatusValue The value which will be set
     */
    inline void setDeviceStatusBTStatusValue (uint8 DeviceStatusBTStatusValue_);

    static const DeviceStatusBTStatusStart &getDefaultInstance();

private:

    inline void set_has_DeviceStatusBTStatusValue ();

    inline void clear_has_DeviceStatusBTStatusValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _DeviceStatusBTStatusValue;

};

/**
 * The result message of the method "DeviceStatusBTStatus"
 * <p>CAN message to send the BT status  through CAN message Device status message</p>
 * <p>ID: 0x18FF114C</p>
 * CAN Message data is sent through.
 */
class DeviceStatusBTStatusResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeviceStatusBTStatusResult ();

    /**
     * Copy constructor
     */
    inline  DeviceStatusBTStatusResult (const DeviceStatusBTStatusResult &rhs);

    /**
     * All fields constructor
     */
    inline  DeviceStatusBTStatusResult (uint8 Result_);

    /**
     * Destructor
     */
    inline virtual  ~DeviceStatusBTStatusResult();

    /**
     * Assignment operator
     */
    inline DeviceStatusBTStatusResult& operator = (const DeviceStatusBTStatusResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceStatusBTStatusResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceStatusBTStatusResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceStatusBTStatusResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceStatusBTStatusResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline uint8 getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (uint8 Result_);

    static const DeviceStatusBTStatusResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Result;

};

/**
 * The start message of the method "DeviceStatusDABAvailStatus"
 * <p>CAN message to send the DABAvail status  through CAN message Device status message</p>
 * Method Start can be triggered from phone to send the DABAvail status details over can message
 */
class DeviceStatusDABAvailStatusStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeviceStatusDABAvailStatusStart ();

    /**
     * Copy constructor
     */
    inline  DeviceStatusDABAvailStatusStart (const DeviceStatusDABAvailStatusStart &rhs);

    /**
     * All fields constructor
     */
    inline  DeviceStatusDABAvailStatusStart (uint8 DeviceStatusDABAvailStatusValue_);

    /**
     * Destructor
     */
    inline virtual  ~DeviceStatusDABAvailStatusStart();

    /**
     * Assignment operator
     */
    inline DeviceStatusDABAvailStatusStart& operator = (const DeviceStatusDABAvailStatusStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceStatusDABAvailStatusStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceStatusDABAvailStatusStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceStatusDABAvailStatusStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceStatusDABAvailStatusStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceStatusDABAvailStatusValue"

    static const int kDeviceStatusDABAvailStatusValue = 0;

    /**
     * Clears the field "DeviceStatusDABAvailStatusValue".
     *
     * The field will be set to its default value. The hasDeviceStatusDABAvailStatusValue()
     * method will return false.
     */
    inline void clearDeviceStatusDABAvailStatusValue();

    /**
     * Checks whether the field "DeviceStatusDABAvailStatusValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceStatusDABAvailStatusValue()). Otherwise it will return false.
     */
    inline bool hasDeviceStatusDABAvailStatusValue () const;

    /**
     * Returns the value of the member "DeviceStatusDABAvailStatusValue".
     *
     * If the meaning of "DeviceStatusDABAvailStatusValue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DeviceStatusDABAvailStatusValue"
     */
    inline uint8 getDeviceStatusDABAvailStatusValue () const;

    /**
     * Sets the value of the member "DeviceStatusDABAvailStatusValue".
     *
     * If the meaning of "DeviceStatusDABAvailStatusValue" isn't clear, then there should be a description here.
     *
     * @param DeviceStatusDABAvailStatusValue The value which will be set
     */
    inline void setDeviceStatusDABAvailStatusValue (uint8 DeviceStatusDABAvailStatusValue_);

    static const DeviceStatusDABAvailStatusStart &getDefaultInstance();

private:

    inline void set_has_DeviceStatusDABAvailStatusValue ();

    inline void clear_has_DeviceStatusDABAvailStatusValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _DeviceStatusDABAvailStatusValue;

};

/**
 * The result message of the method "DeviceStatusDABAvailStatus"
 * <p>CAN message to send the DABAvail status  through CAN message Device status message</p>
 * CAN Message data is sent through.
 */
class DeviceStatusDABAvailStatusResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeviceStatusDABAvailStatusResult ();

    /**
     * Copy constructor
     */
    inline  DeviceStatusDABAvailStatusResult (const DeviceStatusDABAvailStatusResult &rhs);

    /**
     * All fields constructor
     */
    inline  DeviceStatusDABAvailStatusResult (uint8 Result_);

    /**
     * Destructor
     */
    inline virtual  ~DeviceStatusDABAvailStatusResult();

    /**
     * Assignment operator
     */
    inline DeviceStatusDABAvailStatusResult& operator = (const DeviceStatusDABAvailStatusResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceStatusDABAvailStatusResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceStatusDABAvailStatusResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceStatusDABAvailStatusResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceStatusDABAvailStatusResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline uint8 getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (uint8 Result_);

    static const DeviceStatusDABAvailStatusResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Result;

};

/**
 * The start message of the method "DeviceStatusRadioStatus"
 * <p>CAN message to send the RadioStatus status  through CAN message Device status message</p>
 * Method Start can be triggered from phone to send the RadioStatus  details over can message
 */
class DeviceStatusRadioStatusStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeviceStatusRadioStatusStart ();

    /**
     * Copy constructor
     */
    inline  DeviceStatusRadioStatusStart (const DeviceStatusRadioStatusStart &rhs);

    /**
     * All fields constructor
     */
    inline  DeviceStatusRadioStatusStart (uint8 DeviceStatusRadioStatusValue_);

    /**
     * Destructor
     */
    inline virtual  ~DeviceStatusRadioStatusStart();

    /**
     * Assignment operator
     */
    inline DeviceStatusRadioStatusStart& operator = (const DeviceStatusRadioStatusStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceStatusRadioStatusStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceStatusRadioStatusStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceStatusRadioStatusStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceStatusRadioStatusStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceStatusRadioStatusValue"

    static const int kDeviceStatusRadioStatusValue = 0;

    /**
     * Clears the field "DeviceStatusRadioStatusValue".
     *
     * The field will be set to its default value. The hasDeviceStatusRadioStatusValue()
     * method will return false.
     */
    inline void clearDeviceStatusRadioStatusValue();

    /**
     * Checks whether the field "DeviceStatusRadioStatusValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceStatusRadioStatusValue()). Otherwise it will return false.
     */
    inline bool hasDeviceStatusRadioStatusValue () const;

    /**
     * Returns the value of the member "DeviceStatusRadioStatusValue".
     *
     * If the meaning of "DeviceStatusRadioStatusValue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DeviceStatusRadioStatusValue"
     */
    inline uint8 getDeviceStatusRadioStatusValue () const;

    /**
     * Sets the value of the member "DeviceStatusRadioStatusValue".
     *
     * If the meaning of "DeviceStatusRadioStatusValue" isn't clear, then there should be a description here.
     *
     * @param DeviceStatusRadioStatusValue The value which will be set
     */
    inline void setDeviceStatusRadioStatusValue (uint8 DeviceStatusRadioStatusValue_);

    static const DeviceStatusRadioStatusStart &getDefaultInstance();

private:

    inline void set_has_DeviceStatusRadioStatusValue ();

    inline void clear_has_DeviceStatusRadioStatusValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _DeviceStatusRadioStatusValue;

};

/**
 * The result message of the method "DeviceStatusRadioStatus"
 * <p>CAN message to send the RadioStatus status  through CAN message Device status message</p>
 * CAN Message data is sent through.
 */
class DeviceStatusRadioStatusResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeviceStatusRadioStatusResult ();

    /**
     * Copy constructor
     */
    inline  DeviceStatusRadioStatusResult (const DeviceStatusRadioStatusResult &rhs);

    /**
     * All fields constructor
     */
    inline  DeviceStatusRadioStatusResult (uint8 Result_);

    /**
     * Destructor
     */
    inline virtual  ~DeviceStatusRadioStatusResult();

    /**
     * Assignment operator
     */
    inline DeviceStatusRadioStatusResult& operator = (const DeviceStatusRadioStatusResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceStatusRadioStatusResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceStatusRadioStatusResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceStatusRadioStatusResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceStatusRadioStatusResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline uint8 getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (uint8 Result_);

    static const DeviceStatusRadioStatusResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Result;

};

/**
 * The start message of the method "DeviceStatusNavData"
 * <p>CAN message to send the DeviceStatusNavData status  through CAN message Device status message</p>
 * Method Start can be triggered from phone to send the DeviceStatusNavData  details over can message
 */
class DeviceStatusNavDataStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeviceStatusNavDataStart ();

    /**
     * Copy constructor
     */
    inline  DeviceStatusNavDataStart (const DeviceStatusNavDataStart &rhs);

    /**
     * All fields constructor
     */
    inline  DeviceStatusNavDataStart (uint8 DeviceStatusNavDataValue_);

    /**
     * Destructor
     */
    inline virtual  ~DeviceStatusNavDataStart();

    /**
     * Assignment operator
     */
    inline DeviceStatusNavDataStart& operator = (const DeviceStatusNavDataStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceStatusNavDataStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceStatusNavDataStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceStatusNavDataStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceStatusNavDataStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceStatusNavDataValue"

    static const int kDeviceStatusNavDataValue = 0;

    /**
     * Clears the field "DeviceStatusNavDataValue".
     *
     * The field will be set to its default value. The hasDeviceStatusNavDataValue()
     * method will return false.
     */
    inline void clearDeviceStatusNavDataValue();

    /**
     * Checks whether the field "DeviceStatusNavDataValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceStatusNavDataValue()). Otherwise it will return false.
     */
    inline bool hasDeviceStatusNavDataValue () const;

    /**
     * Returns the value of the member "DeviceStatusNavDataValue".
     *
     * If the meaning of "DeviceStatusNavDataValue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DeviceStatusNavDataValue"
     */
    inline uint8 getDeviceStatusNavDataValue () const;

    /**
     * Sets the value of the member "DeviceStatusNavDataValue".
     *
     * If the meaning of "DeviceStatusNavDataValue" isn't clear, then there should be a description here.
     *
     * @param DeviceStatusNavDataValue The value which will be set
     */
    inline void setDeviceStatusNavDataValue (uint8 DeviceStatusNavDataValue_);

    static const DeviceStatusNavDataStart &getDefaultInstance();

private:

    inline void set_has_DeviceStatusNavDataValue ();

    inline void clear_has_DeviceStatusNavDataValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _DeviceStatusNavDataValue;

};

/**
 * The result message of the method "DeviceStatusNavData"
 * <p>CAN message to send the DeviceStatusNavData status  through CAN message Device status message</p>
 * CAN Message data is sent through.
 */
class DeviceStatusNavDataResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeviceStatusNavDataResult ();

    /**
     * Copy constructor
     */
    inline  DeviceStatusNavDataResult (const DeviceStatusNavDataResult &rhs);

    /**
     * All fields constructor
     */
    inline  DeviceStatusNavDataResult (uint8 Result_);

    /**
     * Destructor
     */
    inline virtual  ~DeviceStatusNavDataResult();

    /**
     * Assignment operator
     */
    inline DeviceStatusNavDataResult& operator = (const DeviceStatusNavDataResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceStatusNavDataResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceStatusNavDataResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceStatusNavDataResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceStatusNavDataResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline uint8 getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (uint8 Result_);

    static const DeviceStatusNavDataResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Result;

};

/**
 * The start message of the method "DeviceStatusUSB1Present"
 * <p>CAN message to send the DeviceStatusUSB1Present status  through CAN message Device status message</p>
 * Method Start can be triggered from phone to send the DeviceStatusUSB1Present  details over can message
 */
class DeviceStatusUSB1PresentStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeviceStatusUSB1PresentStart ();

    /**
     * Copy constructor
     */
    inline  DeviceStatusUSB1PresentStart (const DeviceStatusUSB1PresentStart &rhs);

    /**
     * All fields constructor
     */
    inline  DeviceStatusUSB1PresentStart (uint8 DeviceStatusUSB1PresentValue_);

    /**
     * Destructor
     */
    inline virtual  ~DeviceStatusUSB1PresentStart();

    /**
     * Assignment operator
     */
    inline DeviceStatusUSB1PresentStart& operator = (const DeviceStatusUSB1PresentStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceStatusUSB1PresentStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceStatusUSB1PresentStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceStatusUSB1PresentStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceStatusUSB1PresentStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceStatusUSB1PresentValue"

    static const int kDeviceStatusUSB1PresentValue = 0;

    /**
     * Clears the field "DeviceStatusUSB1PresentValue".
     *
     * The field will be set to its default value. The hasDeviceStatusUSB1PresentValue()
     * method will return false.
     */
    inline void clearDeviceStatusUSB1PresentValue();

    /**
     * Checks whether the field "DeviceStatusUSB1PresentValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceStatusUSB1PresentValue()). Otherwise it will return false.
     */
    inline bool hasDeviceStatusUSB1PresentValue () const;

    /**
     * Returns the value of the member "DeviceStatusUSB1PresentValue".
     *
     * If the meaning of "DeviceStatusUSB1PresentValue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DeviceStatusUSB1PresentValue"
     */
    inline uint8 getDeviceStatusUSB1PresentValue () const;

    /**
     * Sets the value of the member "DeviceStatusUSB1PresentValue".
     *
     * If the meaning of "DeviceStatusUSB1PresentValue" isn't clear, then there should be a description here.
     *
     * @param DeviceStatusUSB1PresentValue The value which will be set
     */
    inline void setDeviceStatusUSB1PresentValue (uint8 DeviceStatusUSB1PresentValue_);

    static const DeviceStatusUSB1PresentStart &getDefaultInstance();

private:

    inline void set_has_DeviceStatusUSB1PresentValue ();

    inline void clear_has_DeviceStatusUSB1PresentValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _DeviceStatusUSB1PresentValue;

};

/**
 * The result message of the method "DeviceStatusUSB1Present"
 * <p>CAN message to send the DeviceStatusUSB1Present status  through CAN message Device status message</p>
 * CAN Message data is sent through.
 */
class DeviceStatusUSB1PresentResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeviceStatusUSB1PresentResult ();

    /**
     * Copy constructor
     */
    inline  DeviceStatusUSB1PresentResult (const DeviceStatusUSB1PresentResult &rhs);

    /**
     * All fields constructor
     */
    inline  DeviceStatusUSB1PresentResult (uint8 Result_);

    /**
     * Destructor
     */
    inline virtual  ~DeviceStatusUSB1PresentResult();

    /**
     * Assignment operator
     */
    inline DeviceStatusUSB1PresentResult& operator = (const DeviceStatusUSB1PresentResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceStatusUSB1PresentResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceStatusUSB1PresentResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceStatusUSB1PresentResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceStatusUSB1PresentResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline uint8 getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (uint8 Result_);

    static const DeviceStatusUSB1PresentResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Result;

};

/**
 * The start message of the method "DeviceStatusUSB2Present"
 * <p>CAN message to send the DeviceStatusUSB2Present status  through CAN message Device status message</p>
 * Method Start can be triggered from phone to send the DeviceStatusUSB2Present  details over can message
 */
class DeviceStatusUSB2PresentStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeviceStatusUSB2PresentStart ();

    /**
     * Copy constructor
     */
    inline  DeviceStatusUSB2PresentStart (const DeviceStatusUSB2PresentStart &rhs);

    /**
     * All fields constructor
     */
    inline  DeviceStatusUSB2PresentStart (uint8 DeviceStatusUSB2PresentValue_);

    /**
     * Destructor
     */
    inline virtual  ~DeviceStatusUSB2PresentStart();

    /**
     * Assignment operator
     */
    inline DeviceStatusUSB2PresentStart& operator = (const DeviceStatusUSB2PresentStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceStatusUSB2PresentStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceStatusUSB2PresentStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceStatusUSB2PresentStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceStatusUSB2PresentStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceStatusUSB2PresentValue"

    static const int kDeviceStatusUSB2PresentValue = 0;

    /**
     * Clears the field "DeviceStatusUSB2PresentValue".
     *
     * The field will be set to its default value. The hasDeviceStatusUSB2PresentValue()
     * method will return false.
     */
    inline void clearDeviceStatusUSB2PresentValue();

    /**
     * Checks whether the field "DeviceStatusUSB2PresentValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceStatusUSB2PresentValue()). Otherwise it will return false.
     */
    inline bool hasDeviceStatusUSB2PresentValue () const;

    /**
     * Returns the value of the member "DeviceStatusUSB2PresentValue".
     *
     * If the meaning of "DeviceStatusUSB2PresentValue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DeviceStatusUSB2PresentValue"
     */
    inline uint8 getDeviceStatusUSB2PresentValue () const;

    /**
     * Sets the value of the member "DeviceStatusUSB2PresentValue".
     *
     * If the meaning of "DeviceStatusUSB2PresentValue" isn't clear, then there should be a description here.
     *
     * @param DeviceStatusUSB2PresentValue The value which will be set
     */
    inline void setDeviceStatusUSB2PresentValue (uint8 DeviceStatusUSB2PresentValue_);

    static const DeviceStatusUSB2PresentStart &getDefaultInstance();

private:

    inline void set_has_DeviceStatusUSB2PresentValue ();

    inline void clear_has_DeviceStatusUSB2PresentValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _DeviceStatusUSB2PresentValue;

};

/**
 * The result message of the method "DeviceStatusUSB2Present"
 * <p>CAN message to send the DeviceStatusUSB2Present status  through CAN message Device status message</p>
 * CAN Message data is sent through.
 */
class DeviceStatusUSB2PresentResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeviceStatusUSB2PresentResult ();

    /**
     * Copy constructor
     */
    inline  DeviceStatusUSB2PresentResult (const DeviceStatusUSB2PresentResult &rhs);

    /**
     * All fields constructor
     */
    inline  DeviceStatusUSB2PresentResult (uint8 Result_);

    /**
     * Destructor
     */
    inline virtual  ~DeviceStatusUSB2PresentResult();

    /**
     * Assignment operator
     */
    inline DeviceStatusUSB2PresentResult& operator = (const DeviceStatusUSB2PresentResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceStatusUSB2PresentResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceStatusUSB2PresentResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceStatusUSB2PresentResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceStatusUSB2PresentResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline uint8 getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (uint8 Result_);

    static const DeviceStatusUSB2PresentResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Result;

};

/**
 * The start message of the method "DeviceStatusNaviAvail"
 * <p>CAN message to send the DeviceStatusNaviAvail status  through CAN message Device status message</p>
 * Method Start can be triggered from phone to send the DeviceStatusNaviAvail  details over can message
 */
class DeviceStatusNaviAvailStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeviceStatusNaviAvailStart ();

    /**
     * Copy constructor
     */
    inline  DeviceStatusNaviAvailStart (const DeviceStatusNaviAvailStart &rhs);

    /**
     * All fields constructor
     */
    inline  DeviceStatusNaviAvailStart (uint8 DeviceStatusNaviAvailValue_);

    /**
     * Destructor
     */
    inline virtual  ~DeviceStatusNaviAvailStart();

    /**
     * Assignment operator
     */
    inline DeviceStatusNaviAvailStart& operator = (const DeviceStatusNaviAvailStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceStatusNaviAvailStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceStatusNaviAvailStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceStatusNaviAvailStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceStatusNaviAvailStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceStatusNaviAvailValue"

    static const int kDeviceStatusNaviAvailValue = 0;

    /**
     * Clears the field "DeviceStatusNaviAvailValue".
     *
     * The field will be set to its default value. The hasDeviceStatusNaviAvailValue()
     * method will return false.
     */
    inline void clearDeviceStatusNaviAvailValue();

    /**
     * Checks whether the field "DeviceStatusNaviAvailValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceStatusNaviAvailValue()). Otherwise it will return false.
     */
    inline bool hasDeviceStatusNaviAvailValue () const;

    /**
     * Returns the value of the member "DeviceStatusNaviAvailValue".
     *
     * If the meaning of "DeviceStatusNaviAvailValue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DeviceStatusNaviAvailValue"
     */
    inline uint8 getDeviceStatusNaviAvailValue () const;

    /**
     * Sets the value of the member "DeviceStatusNaviAvailValue".
     *
     * If the meaning of "DeviceStatusNaviAvailValue" isn't clear, then there should be a description here.
     *
     * @param DeviceStatusNaviAvailValue The value which will be set
     */
    inline void setDeviceStatusNaviAvailValue (uint8 DeviceStatusNaviAvailValue_);

    static const DeviceStatusNaviAvailStart &getDefaultInstance();

private:

    inline void set_has_DeviceStatusNaviAvailValue ();

    inline void clear_has_DeviceStatusNaviAvailValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _DeviceStatusNaviAvailValue;

};

/**
 * The result message of the method "DeviceStatusNaviAvail"
 * <p>CAN message to send the DeviceStatusNaviAvail status  through CAN message Device status message</p>
 * CAN Message data is sent through.
 */
class DeviceStatusNaviAvailResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeviceStatusNaviAvailResult ();

    /**
     * Copy constructor
     */
    inline  DeviceStatusNaviAvailResult (const DeviceStatusNaviAvailResult &rhs);

    /**
     * All fields constructor
     */
    inline  DeviceStatusNaviAvailResult (uint8 Result_);

    /**
     * Destructor
     */
    inline virtual  ~DeviceStatusNaviAvailResult();

    /**
     * Assignment operator
     */
    inline DeviceStatusNaviAvailResult& operator = (const DeviceStatusNaviAvailResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceStatusNaviAvailResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceStatusNaviAvailResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceStatusNaviAvailResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceStatusNaviAvailResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline uint8 getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (uint8 Result_);

    static const DeviceStatusNaviAvailResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Result;

};

/**
 * The start message of the method "DeviceStatusUSB1Src"
 * <p>CAN message to send the DeviceStatusSourceUSB1 status  through CAN message Device status message</p>
 * Method Start can be triggered from phone to send the DeviceStatusSourceUSB1  details over can message
 */
class DeviceStatusUSB1SrcStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeviceStatusUSB1SrcStart ();

    /**
     * Copy constructor
     */
    inline  DeviceStatusUSB1SrcStart (const DeviceStatusUSB1SrcStart &rhs);

    /**
     * All fields constructor
     */
    inline  DeviceStatusUSB1SrcStart (uint8 DeviceStatusUSB1SrcValue_);

    /**
     * Destructor
     */
    inline virtual  ~DeviceStatusUSB1SrcStart();

    /**
     * Assignment operator
     */
    inline DeviceStatusUSB1SrcStart& operator = (const DeviceStatusUSB1SrcStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceStatusUSB1SrcStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceStatusUSB1SrcStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceStatusUSB1SrcStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceStatusUSB1SrcStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceStatusUSB1SrcValue"

    static const int kDeviceStatusUSB1SrcValue = 0;

    /**
     * Clears the field "DeviceStatusUSB1SrcValue".
     *
     * The field will be set to its default value. The hasDeviceStatusUSB1SrcValue()
     * method will return false.
     */
    inline void clearDeviceStatusUSB1SrcValue();

    /**
     * Checks whether the field "DeviceStatusUSB1SrcValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceStatusUSB1SrcValue()). Otherwise it will return false.
     */
    inline bool hasDeviceStatusUSB1SrcValue () const;

    /**
     * Returns the value of the member "DeviceStatusUSB1SrcValue".
     *
     * If the meaning of "DeviceStatusUSB1SrcValue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DeviceStatusUSB1SrcValue"
     */
    inline uint8 getDeviceStatusUSB1SrcValue () const;

    /**
     * Sets the value of the member "DeviceStatusUSB1SrcValue".
     *
     * If the meaning of "DeviceStatusUSB1SrcValue" isn't clear, then there should be a description here.
     *
     * @param DeviceStatusUSB1SrcValue The value which will be set
     */
    inline void setDeviceStatusUSB1SrcValue (uint8 DeviceStatusUSB1SrcValue_);

    static const DeviceStatusUSB1SrcStart &getDefaultInstance();

private:

    inline void set_has_DeviceStatusUSB1SrcValue ();

    inline void clear_has_DeviceStatusUSB1SrcValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _DeviceStatusUSB1SrcValue;

};

/**
 * The result message of the method "DeviceStatusUSB1Src"
 * <p>CAN message to send the DeviceStatusSourceUSB1 status  through CAN message Device status message</p>
 * CAN Message data is sent through.
 */
class DeviceStatusUSB1SrcResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeviceStatusUSB1SrcResult ();

    /**
     * Copy constructor
     */
    inline  DeviceStatusUSB1SrcResult (const DeviceStatusUSB1SrcResult &rhs);

    /**
     * All fields constructor
     */
    inline  DeviceStatusUSB1SrcResult (uint8 Result_);

    /**
     * Destructor
     */
    inline virtual  ~DeviceStatusUSB1SrcResult();

    /**
     * Assignment operator
     */
    inline DeviceStatusUSB1SrcResult& operator = (const DeviceStatusUSB1SrcResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceStatusUSB1SrcResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceStatusUSB1SrcResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceStatusUSB1SrcResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceStatusUSB1SrcResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline uint8 getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (uint8 Result_);

    static const DeviceStatusUSB1SrcResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Result;

};

/**
 * The start message of the method "DeviceStatusUSB2Src"
 * <p>CAN message to send the DeviceStatusSourceUSB2 status  through CAN message Device status message</p>
 * Method Start can be triggered from phone to send the DeviceStatusSourceUSB2  details over can message
 */
class DeviceStatusUSB2SrcStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeviceStatusUSB2SrcStart ();

    /**
     * Copy constructor
     */
    inline  DeviceStatusUSB2SrcStart (const DeviceStatusUSB2SrcStart &rhs);

    /**
     * All fields constructor
     */
    inline  DeviceStatusUSB2SrcStart (uint8 DeviceStatusUSB2SrcValue_);

    /**
     * Destructor
     */
    inline virtual  ~DeviceStatusUSB2SrcStart();

    /**
     * Assignment operator
     */
    inline DeviceStatusUSB2SrcStart& operator = (const DeviceStatusUSB2SrcStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceStatusUSB2SrcStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceStatusUSB2SrcStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceStatusUSB2SrcStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceStatusUSB2SrcStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceStatusUSB2SrcValue"

    static const int kDeviceStatusUSB2SrcValue = 0;

    /**
     * Clears the field "DeviceStatusUSB2SrcValue".
     *
     * The field will be set to its default value. The hasDeviceStatusUSB2SrcValue()
     * method will return false.
     */
    inline void clearDeviceStatusUSB2SrcValue();

    /**
     * Checks whether the field "DeviceStatusUSB2SrcValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceStatusUSB2SrcValue()). Otherwise it will return false.
     */
    inline bool hasDeviceStatusUSB2SrcValue () const;

    /**
     * Returns the value of the member "DeviceStatusUSB2SrcValue".
     *
     * <p>USB1 Src status value from component</p>
     *
     * @return The value of the field "DeviceStatusUSB2SrcValue"
     */
    inline uint8 getDeviceStatusUSB2SrcValue () const;

    /**
     * Sets the value of the member "DeviceStatusUSB2SrcValue".
     *
     * <p>USB1 Src status value from component</p>
     *
     * @param DeviceStatusUSB2SrcValue The value which will be set
     */
    inline void setDeviceStatusUSB2SrcValue (uint8 DeviceStatusUSB2SrcValue_);

    static const DeviceStatusUSB2SrcStart &getDefaultInstance();

private:

    inline void set_has_DeviceStatusUSB2SrcValue ();

    inline void clear_has_DeviceStatusUSB2SrcValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _DeviceStatusUSB2SrcValue;

};

/**
 * The result message of the method "DeviceStatusUSB2Src"
 * <p>CAN message to send the DeviceStatusSourceUSB2 status  through CAN message Device status message</p>
 * CAN Message data is sent through.
 */
class DeviceStatusUSB2SrcResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeviceStatusUSB2SrcResult ();

    /**
     * Copy constructor
     */
    inline  DeviceStatusUSB2SrcResult (const DeviceStatusUSB2SrcResult &rhs);

    /**
     * All fields constructor
     */
    inline  DeviceStatusUSB2SrcResult (uint8 Result_);

    /**
     * Destructor
     */
    inline virtual  ~DeviceStatusUSB2SrcResult();

    /**
     * Assignment operator
     */
    inline DeviceStatusUSB2SrcResult& operator = (const DeviceStatusUSB2SrcResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceStatusUSB2SrcResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceStatusUSB2SrcResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceStatusUSB2SrcResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceStatusUSB2SrcResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline uint8 getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (uint8 Result_);

    static const DeviceStatusUSB2SrcResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Result;

};

/**
 * The start message of the method "DeviceStatusAMFMAvail"
 * <p>CAN message to send the AMFMAvail status  through CAN message Device status message</p>
 * Method Start can be triggered from phone to send the AMFMAvail  details over can message
 */
class DeviceStatusAMFMAvailStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeviceStatusAMFMAvailStart ();

    /**
     * Copy constructor
     */
    inline  DeviceStatusAMFMAvailStart (const DeviceStatusAMFMAvailStart &rhs);

    /**
     * All fields constructor
     */
    inline  DeviceStatusAMFMAvailStart (uint8 DeviceStatusAMFMAvailValue_);

    /**
     * Destructor
     */
    inline virtual  ~DeviceStatusAMFMAvailStart();

    /**
     * Assignment operator
     */
    inline DeviceStatusAMFMAvailStart& operator = (const DeviceStatusAMFMAvailStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceStatusAMFMAvailStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceStatusAMFMAvailStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceStatusAMFMAvailStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceStatusAMFMAvailStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceStatusAMFMAvailValue"

    static const int kDeviceStatusAMFMAvailValue = 0;

    /**
     * Clears the field "DeviceStatusAMFMAvailValue".
     *
     * The field will be set to its default value. The hasDeviceStatusAMFMAvailValue()
     * method will return false.
     */
    inline void clearDeviceStatusAMFMAvailValue();

    /**
     * Checks whether the field "DeviceStatusAMFMAvailValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceStatusAMFMAvailValue()). Otherwise it will return false.
     */
    inline bool hasDeviceStatusAMFMAvailValue () const;

    /**
     * Returns the value of the member "DeviceStatusAMFMAvailValue".
     *
     * If the meaning of "DeviceStatusAMFMAvailValue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DeviceStatusAMFMAvailValue"
     */
    inline uint8 getDeviceStatusAMFMAvailValue () const;

    /**
     * Sets the value of the member "DeviceStatusAMFMAvailValue".
     *
     * If the meaning of "DeviceStatusAMFMAvailValue" isn't clear, then there should be a description here.
     *
     * @param DeviceStatusAMFMAvailValue The value which will be set
     */
    inline void setDeviceStatusAMFMAvailValue (uint8 DeviceStatusAMFMAvailValue_);

    static const DeviceStatusAMFMAvailStart &getDefaultInstance();

private:

    inline void set_has_DeviceStatusAMFMAvailValue ();

    inline void clear_has_DeviceStatusAMFMAvailValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _DeviceStatusAMFMAvailValue;

};

/**
 * The result message of the method "DeviceStatusAMFMAvail"
 * <p>CAN message to send the AMFMAvail status  through CAN message Device status message</p>
 * CAN Message data is sent through.
 */
class DeviceStatusAMFMAvailResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeviceStatusAMFMAvailResult ();

    /**
     * Copy constructor
     */
    inline  DeviceStatusAMFMAvailResult (const DeviceStatusAMFMAvailResult &rhs);

    /**
     * All fields constructor
     */
    inline  DeviceStatusAMFMAvailResult (uint8 Result_);

    /**
     * Destructor
     */
    inline virtual  ~DeviceStatusAMFMAvailResult();

    /**
     * Assignment operator
     */
    inline DeviceStatusAMFMAvailResult& operator = (const DeviceStatusAMFMAvailResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceStatusAMFMAvailResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceStatusAMFMAvailResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceStatusAMFMAvailResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceStatusAMFMAvailResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline uint8 getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (uint8 Result_);

    static const DeviceStatusAMFMAvailResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Result;

};

/**
 * The start message of the method "DeviceStatusBluetoothAvail"
 * <p>CAN message to send the Bluetooth Avail status  through CAN message Device status message.</p>
 * <p>Value Descriptor : On-0x01, Off-0x00</p>
 * Method Start can be triggered from phone to send the Bluetooth Avail status  details over can message
 */
class DeviceStatusBluetoothAvailStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeviceStatusBluetoothAvailStart ();

    /**
     * Copy constructor
     */
    inline  DeviceStatusBluetoothAvailStart (const DeviceStatusBluetoothAvailStart &rhs);

    /**
     * All fields constructor
     */
    inline  DeviceStatusBluetoothAvailStart (uint8 DeviceStatusBluetoothAvailValue_);

    /**
     * Destructor
     */
    inline virtual  ~DeviceStatusBluetoothAvailStart();

    /**
     * Assignment operator
     */
    inline DeviceStatusBluetoothAvailStart& operator = (const DeviceStatusBluetoothAvailStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceStatusBluetoothAvailStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceStatusBluetoothAvailStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceStatusBluetoothAvailStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceStatusBluetoothAvailStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceStatusBluetoothAvailValue"

    static const int kDeviceStatusBluetoothAvailValue = 0;

    /**
     * Clears the field "DeviceStatusBluetoothAvailValue".
     *
     * The field will be set to its default value. The hasDeviceStatusBluetoothAvailValue()
     * method will return false.
     */
    inline void clearDeviceStatusBluetoothAvailValue();

    /**
     * Checks whether the field "DeviceStatusBluetoothAvailValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceStatusBluetoothAvailValue()). Otherwise it will return false.
     */
    inline bool hasDeviceStatusBluetoothAvailValue () const;

    /**
     * Returns the value of the member "DeviceStatusBluetoothAvailValue".
     *
     * If the meaning of "DeviceStatusBluetoothAvailValue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DeviceStatusBluetoothAvailValue"
     */
    inline uint8 getDeviceStatusBluetoothAvailValue () const;

    /**
     * Sets the value of the member "DeviceStatusBluetoothAvailValue".
     *
     * If the meaning of "DeviceStatusBluetoothAvailValue" isn't clear, then there should be a description here.
     *
     * @param DeviceStatusBluetoothAvailValue The value which will be set
     */
    inline void setDeviceStatusBluetoothAvailValue (uint8 DeviceStatusBluetoothAvailValue_);

    static const DeviceStatusBluetoothAvailStart &getDefaultInstance();

private:

    inline void set_has_DeviceStatusBluetoothAvailValue ();

    inline void clear_has_DeviceStatusBluetoothAvailValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _DeviceStatusBluetoothAvailValue;

};

/**
 * The result message of the method "DeviceStatusBluetoothAvail"
 * <p>CAN message to send the Bluetooth Avail status  through CAN message Device status message.</p>
 * <p>Value Descriptor : On-0x01, Off-0x00</p>
 * CAN Message data is sent through.
 */
class DeviceStatusBluetoothAvailResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeviceStatusBluetoothAvailResult ();

    /**
     * Copy constructor
     */
    inline  DeviceStatusBluetoothAvailResult (const DeviceStatusBluetoothAvailResult &rhs);

    /**
     * All fields constructor
     */
    inline  DeviceStatusBluetoothAvailResult (uint8 Result_);

    /**
     * Destructor
     */
    inline virtual  ~DeviceStatusBluetoothAvailResult();

    /**
     * Assignment operator
     */
    inline DeviceStatusBluetoothAvailResult& operator = (const DeviceStatusBluetoothAvailResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceStatusBluetoothAvailResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceStatusBluetoothAvailResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceStatusBluetoothAvailResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceStatusBluetoothAvailResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline uint8 getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (uint8 Result_);

    static const DeviceStatusBluetoothAvailResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Result;

};

/**
 * The start message of the method "Req_DeviceInfo"
 * <p>CAN message to send the request for device info through CAN message Req_DeviceInformation message</p>
 * <p>Value Descriptors : Request= 0x01, No Request=0x00</p>
 * Method Start can be triggered from phone to send the device info details over can message
 */
class Req_DeviceInfoStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Req_DeviceInfoStart ();

    /**
     * Copy constructor
     */
    inline  Req_DeviceInfoStart (const Req_DeviceInfoStart &rhs);

    /**
     * All fields constructor
     */
    inline  Req_DeviceInfoStart (uint8 Req_DeviceInfoValue_);

    /**
     * Destructor
     */
    inline virtual  ~Req_DeviceInfoStart();

    /**
     * Assignment operator
     */
    inline Req_DeviceInfoStart& operator = (const Req_DeviceInfoStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Req_DeviceInfoStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Req_DeviceInfoStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Req_DeviceInfoStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Req_DeviceInfoStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Req_DeviceInfoValue"

    static const int kReq_DeviceInfoValue = 0;

    /**
     * Clears the field "Req_DeviceInfoValue".
     *
     * The field will be set to its default value. The hasReq_DeviceInfoValue()
     * method will return false.
     */
    inline void clearReq_DeviceInfoValue();

    /**
     * Checks whether the field "Req_DeviceInfoValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReq_DeviceInfoValue()). Otherwise it will return false.
     */
    inline bool hasReq_DeviceInfoValue () const;

    /**
     * Returns the value of the member "Req_DeviceInfoValue".
     *
     * If the meaning of "Req_DeviceInfoValue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Req_DeviceInfoValue"
     */
    inline uint8 getReq_DeviceInfoValue () const;

    /**
     * Sets the value of the member "Req_DeviceInfoValue".
     *
     * If the meaning of "Req_DeviceInfoValue" isn't clear, then there should be a description here.
     *
     * @param Req_DeviceInfoValue The value which will be set
     */
    inline void setReq_DeviceInfoValue (uint8 Req_DeviceInfoValue_);

    static const Req_DeviceInfoStart &getDefaultInstance();

private:

    inline void set_has_Req_DeviceInfoValue ();

    inline void clear_has_Req_DeviceInfoValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Req_DeviceInfoValue;

};

/**
 * The result message of the method "Req_DeviceInfo"
 * <p>CAN message to send the request for device info through CAN message Req_DeviceInformation message</p>
 * <p>Value Descriptors : Request= 0x01, No Request=0x00</p>
 * CAN Message data is sent through.
 */
class Req_DeviceInfoResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Req_DeviceInfoResult ();

    /**
     * Copy constructor
     */
    inline  Req_DeviceInfoResult (const Req_DeviceInfoResult &rhs);

    /**
     * All fields constructor
     */
    inline  Req_DeviceInfoResult (uint8 Result_);

    /**
     * Destructor
     */
    inline virtual  ~Req_DeviceInfoResult();

    /**
     * Assignment operator
     */
    inline Req_DeviceInfoResult& operator = (const Req_DeviceInfoResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Req_DeviceInfoResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Req_DeviceInfoResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Req_DeviceInfoResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Req_DeviceInfoResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline uint8 getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (uint8 Result_);

    static const Req_DeviceInfoResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Result;

};

/**
 * The start message of the method "HUS_DM1_Status"
 * <p>CAN message to send the DM1Status  through CAN message</p>
 * Method Start can be triggered from DIAG to send the status over can message
 */
class HUS_DM1_StatusStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  HUS_DM1_StatusStart ();

    /**
     * Copy constructor
     */
    inline  HUS_DM1_StatusStart (const HUS_DM1_StatusStart &rhs);

    /**
     * All fields constructor
     */
    inline  HUS_DM1_StatusStart (uint64 HUS_DM1_StatusValue_);

    /**
     * Destructor
     */
    inline virtual  ~HUS_DM1_StatusStart();

    /**
     * Assignment operator
     */
    inline HUS_DM1_StatusStart& operator = (const HUS_DM1_StatusStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HUS_DM1_StatusStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HUS_DM1_StatusStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HUS_DM1_StatusStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HUS_DM1_StatusStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "HUS_DM1_StatusValue"

    static const int kHUS_DM1_StatusValue = 0;

    /**
     * Clears the field "HUS_DM1_StatusValue".
     *
     * The field will be set to its default value. The hasHUS_DM1_StatusValue()
     * method will return false.
     */
    inline void clearHUS_DM1_StatusValue();

    /**
     * Checks whether the field "HUS_DM1_StatusValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHUS_DM1_StatusValue()). Otherwise it will return false.
     */
    inline bool hasHUS_DM1_StatusValue () const;

    /**
     * Returns the value of the member "HUS_DM1_StatusValue".
     *
     * If the meaning of "HUS_DM1_StatusValue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "HUS_DM1_StatusValue"
     */
    inline uint64 getHUS_DM1_StatusValue () const;

    /**
     * Sets the value of the member "HUS_DM1_StatusValue".
     *
     * If the meaning of "HUS_DM1_StatusValue" isn't clear, then there should be a description here.
     *
     * @param HUS_DM1_StatusValue The value which will be set
     */
    inline void setHUS_DM1_StatusValue (uint64 HUS_DM1_StatusValue_);

    static const HUS_DM1_StatusStart &getDefaultInstance();

private:

    inline void set_has_HUS_DM1_StatusValue ();

    inline void clear_has_HUS_DM1_StatusValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint64 _HUS_DM1_StatusValue;

};

/**
 * The result message of the method "HUS_DM1_Status"
 * <p>CAN message to send the DM1Status  through CAN message</p>
 * CAN Message data is sent through.
 */
class HUS_DM1_StatusResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  HUS_DM1_StatusResult ();

    /**
     * Copy constructor
     */
    inline  HUS_DM1_StatusResult (const HUS_DM1_StatusResult &rhs);

    /**
     * All fields constructor
     */
    inline  HUS_DM1_StatusResult (uint8 Result_);

    /**
     * Destructor
     */
    inline virtual  ~HUS_DM1_StatusResult();

    /**
     * Assignment operator
     */
    inline HUS_DM1_StatusResult& operator = (const HUS_DM1_StatusResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HUS_DM1_StatusResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HUS_DM1_StatusResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HUS_DM1_StatusResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HUS_DM1_StatusResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline uint8 getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (uint8 Result_);

    static const HUS_DM1_StatusResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Result;

};

/**
 * The start message of the method "VehicleNaviLatitude"
 * <p>CAN message to send the Latitude value  through CAN message</p>
 * Method Start can be triggered from Navi to send the status over can message.component to consider the offset value for the signal .
 */
class VehicleNaviLatitudeStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VehicleNaviLatitudeStart ();

    /**
     * Copy constructor
     */
    inline  VehicleNaviLatitudeStart (const VehicleNaviLatitudeStart &rhs);

    /**
     * All fields constructor
     */
    inline  VehicleNaviLatitudeStart (uint32 VehicleNaviLatitudeValue_);

    /**
     * Destructor
     */
    inline virtual  ~VehicleNaviLatitudeStart();

    /**
     * Assignment operator
     */
    inline VehicleNaviLatitudeStart& operator = (const VehicleNaviLatitudeStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VehicleNaviLatitudeStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VehicleNaviLatitudeStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VehicleNaviLatitudeStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VehicleNaviLatitudeStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "VehicleNaviLatitudeValue"

    static const int kVehicleNaviLatitudeValue = 0;

    /**
     * Clears the field "VehicleNaviLatitudeValue".
     *
     * The field will be set to its default value. The hasVehicleNaviLatitudeValue()
     * method will return false.
     */
    inline void clearVehicleNaviLatitudeValue();

    /**
     * Checks whether the field "VehicleNaviLatitudeValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVehicleNaviLatitudeValue()). Otherwise it will return false.
     */
    inline bool hasVehicleNaviLatitudeValue () const;

    /**
     * Returns the value of the member "VehicleNaviLatitudeValue".
     *
     * If the meaning of "VehicleNaviLatitudeValue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "VehicleNaviLatitudeValue"
     */
    inline uint32 getVehicleNaviLatitudeValue () const;

    /**
     * Sets the value of the member "VehicleNaviLatitudeValue".
     *
     * If the meaning of "VehicleNaviLatitudeValue" isn't clear, then there should be a description here.
     *
     * @param VehicleNaviLatitudeValue The value which will be set
     */
    inline void setVehicleNaviLatitudeValue (uint32 VehicleNaviLatitudeValue_);

    static const VehicleNaviLatitudeStart &getDefaultInstance();

private:

    inline void set_has_VehicleNaviLatitudeValue ();

    inline void clear_has_VehicleNaviLatitudeValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _VehicleNaviLatitudeValue;

};

/**
 * The result message of the method "VehicleNaviLatitude"
 * <p>CAN message to send the Latitude value  through CAN message</p>
 * CAN Message data is sent through.
 */
class VehicleNaviLatitudeResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VehicleNaviLatitudeResult ();

    /**
     * Copy constructor
     */
    inline  VehicleNaviLatitudeResult (const VehicleNaviLatitudeResult &rhs);

    /**
     * All fields constructor
     */
    inline  VehicleNaviLatitudeResult (uint8 Result_);

    /**
     * Destructor
     */
    inline virtual  ~VehicleNaviLatitudeResult();

    /**
     * Assignment operator
     */
    inline VehicleNaviLatitudeResult& operator = (const VehicleNaviLatitudeResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VehicleNaviLatitudeResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VehicleNaviLatitudeResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VehicleNaviLatitudeResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VehicleNaviLatitudeResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline uint8 getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (uint8 Result_);

    static const VehicleNaviLatitudeResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Result;

};

/**
 * The start message of the method "VehicleNaviLongitude"
 * <p>CAN message to send the Longitude value  through CAN message</p>
 * Method Start can be triggered from Navi to send the status over can message. component to consider the offset value for the signal .
 */
class VehicleNaviLongitudeStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VehicleNaviLongitudeStart ();

    /**
     * Copy constructor
     */
    inline  VehicleNaviLongitudeStart (const VehicleNaviLongitudeStart &rhs);

    /**
     * All fields constructor
     */
    inline  VehicleNaviLongitudeStart (uint32 VehicleNaviLongitudeValue_);

    /**
     * Destructor
     */
    inline virtual  ~VehicleNaviLongitudeStart();

    /**
     * Assignment operator
     */
    inline VehicleNaviLongitudeStart& operator = (const VehicleNaviLongitudeStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VehicleNaviLongitudeStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VehicleNaviLongitudeStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VehicleNaviLongitudeStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VehicleNaviLongitudeStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "VehicleNaviLongitudeValue"

    static const int kVehicleNaviLongitudeValue = 0;

    /**
     * Clears the field "VehicleNaviLongitudeValue".
     *
     * The field will be set to its default value. The hasVehicleNaviLongitudeValue()
     * method will return false.
     */
    inline void clearVehicleNaviLongitudeValue();

    /**
     * Checks whether the field "VehicleNaviLongitudeValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVehicleNaviLongitudeValue()). Otherwise it will return false.
     */
    inline bool hasVehicleNaviLongitudeValue () const;

    /**
     * Returns the value of the member "VehicleNaviLongitudeValue".
     *
     * If the meaning of "VehicleNaviLongitudeValue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "VehicleNaviLongitudeValue"
     */
    inline uint32 getVehicleNaviLongitudeValue () const;

    /**
     * Sets the value of the member "VehicleNaviLongitudeValue".
     *
     * If the meaning of "VehicleNaviLongitudeValue" isn't clear, then there should be a description here.
     *
     * @param VehicleNaviLongitudeValue The value which will be set
     */
    inline void setVehicleNaviLongitudeValue (uint32 VehicleNaviLongitudeValue_);

    static const VehicleNaviLongitudeStart &getDefaultInstance();

private:

    inline void set_has_VehicleNaviLongitudeValue ();

    inline void clear_has_VehicleNaviLongitudeValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _VehicleNaviLongitudeValue;

};

/**
 * The result message of the method "VehicleNaviLongitude"
 * <p>CAN message to send the Longitude value  through CAN message</p>
 * CAN Message data is sent through.
 */
class VehicleNaviLongitudeResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VehicleNaviLongitudeResult ();

    /**
     * Copy constructor
     */
    inline  VehicleNaviLongitudeResult (const VehicleNaviLongitudeResult &rhs);

    /**
     * All fields constructor
     */
    inline  VehicleNaviLongitudeResult (uint8 Result_);

    /**
     * Destructor
     */
    inline virtual  ~VehicleNaviLongitudeResult();

    /**
     * Assignment operator
     */
    inline VehicleNaviLongitudeResult& operator = (const VehicleNaviLongitudeResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VehicleNaviLongitudeResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VehicleNaviLongitudeResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VehicleNaviLongitudeResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VehicleNaviLongitudeResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline uint8 getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (uint8 Result_);

    static const VehicleNaviLongitudeResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Result;

};

/**
 * The start message of the method "MediaStatusAudioSource"
 * <p>CAN message to send the Audio Source through CAN message Media_status1</p>
 * <p>ID: 0x18FF124C</p>
 * Method Start can be triggered from HMI to send the audio src details over can message
 */
class MediaStatusAudioSourceStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MediaStatusAudioSourceStart ();

    /**
     * Copy constructor
     */
    inline  MediaStatusAudioSourceStart (const MediaStatusAudioSourceStart &rhs);

    /**
     * All fields constructor
     */
    inline  MediaStatusAudioSourceStart (uint8 AudioSource_);

    /**
     * Destructor
     */
    inline virtual  ~MediaStatusAudioSourceStart();

    /**
     * Assignment operator
     */
    inline MediaStatusAudioSourceStart& operator = (const MediaStatusAudioSourceStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MediaStatusAudioSourceStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MediaStatusAudioSourceStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MediaStatusAudioSourceStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MediaStatusAudioSourceStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AudioSource"

    static const int kAudioSource = 0;

    /**
     * Clears the field "AudioSource".
     *
     * The field will be set to its default value. The hasAudioSource()
     * method will return false.
     */
    inline void clearAudioSource();

    /**
     * Checks whether the field "AudioSource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudioSource()). Otherwise it will return false.
     */
    inline bool hasAudioSource () const;

    /**
     * Returns the value of the member "AudioSource".
     *
     * If the meaning of "AudioSource" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AudioSource"
     */
    inline uint8 getAudioSource () const;

    /**
     * Sets the value of the member "AudioSource".
     *
     * If the meaning of "AudioSource" isn't clear, then there should be a description here.
     *
     * @param AudioSource The value which will be set
     */
    inline void setAudioSource (uint8 AudioSource_);

    static const MediaStatusAudioSourceStart &getDefaultInstance();

private:

    inline void set_has_AudioSource ();

    inline void clear_has_AudioSource ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _AudioSource;

};

/**
 * The result message of the method "MediaStatusAudioSource"
 * <p>CAN message to send the Audio Source through CAN message Media_status1</p>
 * <p>ID: 0x18FF124C</p>
 * CAN Message data is sent through.
 */
class MediaStatusAudioSourceResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MediaStatusAudioSourceResult ();

    /**
     * Copy constructor
     */
    inline  MediaStatusAudioSourceResult (const MediaStatusAudioSourceResult &rhs);

    /**
     * All fields constructor
     */
    inline  MediaStatusAudioSourceResult (uint8 Result_);

    /**
     * Destructor
     */
    inline virtual  ~MediaStatusAudioSourceResult();

    /**
     * Assignment operator
     */
    inline MediaStatusAudioSourceResult& operator = (const MediaStatusAudioSourceResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MediaStatusAudioSourceResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MediaStatusAudioSourceResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MediaStatusAudioSourceResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MediaStatusAudioSourceResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline uint8 getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (uint8 Result_);

    static const MediaStatusAudioSourceResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Result;

};

/**
 * The start message of the method "MediaStatusVolume"
 * <p>CAN message to send the volume status through CAN message Media_status1</p>
 * <p>ID: 0x18FF124C</p>
 * Method Start can be triggered from HMI to send the audio src details over can message
 */
class MediaStatusVolumeStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MediaStatusVolumeStart ();

    /**
     * Copy constructor
     */
    inline  MediaStatusVolumeStart (const MediaStatusVolumeStart &rhs);

    /**
     * All fields constructor
     */
    inline  MediaStatusVolumeStart (uint8 volume_);

    /**
     * Destructor
     */
    inline virtual  ~MediaStatusVolumeStart();

    /**
     * Assignment operator
     */
    inline MediaStatusVolumeStart& operator = (const MediaStatusVolumeStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MediaStatusVolumeStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MediaStatusVolumeStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MediaStatusVolumeStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MediaStatusVolumeStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "volume"

    static const int kVolume = 0;

    /**
     * Clears the field "volume".
     *
     * The field will be set to its default value. The hasVolume()
     * method will return false.
     */
    inline void clearVolume();

    /**
     * Checks whether the field "volume" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVolume()). Otherwise it will return false.
     */
    inline bool hasVolume () const;

    /**
     * Returns the value of the member "volume".
     *
     * If the meaning of "volume" isn't clear, then there should be a description here.
     *
     * @return The value of the field "volume"
     */
    inline uint8 getVolume () const;

    /**
     * Sets the value of the member "volume".
     *
     * If the meaning of "volume" isn't clear, then there should be a description here.
     *
     * @param volume The value which will be set
     */
    inline void setVolume (uint8 volume_);

    static const MediaStatusVolumeStart &getDefaultInstance();

private:

    inline void set_has_volume ();

    inline void clear_has_volume ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _volume;

};

/**
 * The result message of the method "MediaStatusVolume"
 * <p>CAN message to send the volume status through CAN message Media_status1</p>
 * <p>ID: 0x18FF124C</p>
 * CAN Message data is sent through.
 */
class MediaStatusVolumeResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MediaStatusVolumeResult ();

    /**
     * Copy constructor
     */
    inline  MediaStatusVolumeResult (const MediaStatusVolumeResult &rhs);

    /**
     * All fields constructor
     */
    inline  MediaStatusVolumeResult (uint8 Result_);

    /**
     * Destructor
     */
    inline virtual  ~MediaStatusVolumeResult();

    /**
     * Assignment operator
     */
    inline MediaStatusVolumeResult& operator = (const MediaStatusVolumeResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MediaStatusVolumeResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MediaStatusVolumeResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MediaStatusVolumeResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MediaStatusVolumeResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline uint8 getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (uint8 Result_);

    static const MediaStatusVolumeResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Result;

};

/**
 * The start message of the method "CabinMediaStatusAudioSource"
 * <p>CAN message to send the Audio Source status through CAN message CabinMedia_Status</p>
 * <p>ID: 0x18FF154C</p>
 * Method Start can be triggered from HMI to send the audio src details over can message
 */
class CabinMediaStatusAudioSourceStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CabinMediaStatusAudioSourceStart ();

    /**
     * Copy constructor
     */
    inline  CabinMediaStatusAudioSourceStart (const CabinMediaStatusAudioSourceStart &rhs);

    /**
     * All fields constructor
     */
    inline  CabinMediaStatusAudioSourceStart (uint8 CabinAudioSource_);

    /**
     * Destructor
     */
    inline virtual  ~CabinMediaStatusAudioSourceStart();

    /**
     * Assignment operator
     */
    inline CabinMediaStatusAudioSourceStart& operator = (const CabinMediaStatusAudioSourceStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CabinMediaStatusAudioSourceStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CabinMediaStatusAudioSourceStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CabinMediaStatusAudioSourceStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CabinMediaStatusAudioSourceStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CabinAudioSource"

    static const int kCabinAudioSource = 0;

    /**
     * Clears the field "CabinAudioSource".
     *
     * The field will be set to its default value. The hasCabinAudioSource()
     * method will return false.
     */
    inline void clearCabinAudioSource();

    /**
     * Checks whether the field "CabinAudioSource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCabinAudioSource()). Otherwise it will return false.
     */
    inline bool hasCabinAudioSource () const;

    /**
     * Returns the value of the member "CabinAudioSource".
     *
     * If the meaning of "CabinAudioSource" isn't clear, then there should be a description here.
     *
     * @return The value of the field "CabinAudioSource"
     */
    inline uint8 getCabinAudioSource () const;

    /**
     * Sets the value of the member "CabinAudioSource".
     *
     * If the meaning of "CabinAudioSource" isn't clear, then there should be a description here.
     *
     * @param CabinAudioSource The value which will be set
     */
    inline void setCabinAudioSource (uint8 CabinAudioSource_);

    static const CabinMediaStatusAudioSourceStart &getDefaultInstance();

private:

    inline void set_has_CabinAudioSource ();

    inline void clear_has_CabinAudioSource ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _CabinAudioSource;

};

/**
 * The result message of the method "CabinMediaStatusAudioSource"
 * <p>CAN message to send the Audio Source status through CAN message CabinMedia_Status</p>
 * <p>ID: 0x18FF154C</p>
 * CAN Message data is sent through.
 */
class CabinMediaStatusAudioSourceResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CabinMediaStatusAudioSourceResult ();

    /**
     * Copy constructor
     */
    inline  CabinMediaStatusAudioSourceResult (const CabinMediaStatusAudioSourceResult &rhs);

    /**
     * All fields constructor
     */
    inline  CabinMediaStatusAudioSourceResult (uint8 Result_);

    /**
     * Destructor
     */
    inline virtual  ~CabinMediaStatusAudioSourceResult();

    /**
     * Assignment operator
     */
    inline CabinMediaStatusAudioSourceResult& operator = (const CabinMediaStatusAudioSourceResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CabinMediaStatusAudioSourceResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CabinMediaStatusAudioSourceResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CabinMediaStatusAudioSourceResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CabinMediaStatusAudioSourceResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline uint8 getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (uint8 Result_);

    static const CabinMediaStatusAudioSourceResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Result;

};

/**
 * The start message of the method "CabinMediaStatusVolume"
 * <p>CAN message to send the volume status through CAN message CabinMedia_Status</p>
 * <p>ID: 0x18FF154C</p>
 * Method Start can be triggered from HMI to send the audio src details over can message
 */
class CabinMediaStatusVolumeStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CabinMediaStatusVolumeStart ();

    /**
     * Copy constructor
     */
    inline  CabinMediaStatusVolumeStart (const CabinMediaStatusVolumeStart &rhs);

    /**
     * All fields constructor
     */
    inline  CabinMediaStatusVolumeStart (uint8 CabinVolume_);

    /**
     * Destructor
     */
    inline virtual  ~CabinMediaStatusVolumeStart();

    /**
     * Assignment operator
     */
    inline CabinMediaStatusVolumeStart& operator = (const CabinMediaStatusVolumeStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CabinMediaStatusVolumeStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CabinMediaStatusVolumeStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CabinMediaStatusVolumeStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CabinMediaStatusVolumeStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CabinVolume"

    static const int kCabinVolume = 0;

    /**
     * Clears the field "CabinVolume".
     *
     * The field will be set to its default value. The hasCabinVolume()
     * method will return false.
     */
    inline void clearCabinVolume();

    /**
     * Checks whether the field "CabinVolume" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCabinVolume()). Otherwise it will return false.
     */
    inline bool hasCabinVolume () const;

    /**
     * Returns the value of the member "CabinVolume".
     *
     * If the meaning of "CabinVolume" isn't clear, then there should be a description here.
     *
     * @return The value of the field "CabinVolume"
     */
    inline uint8 getCabinVolume () const;

    /**
     * Sets the value of the member "CabinVolume".
     *
     * If the meaning of "CabinVolume" isn't clear, then there should be a description here.
     *
     * @param CabinVolume The value which will be set
     */
    inline void setCabinVolume (uint8 CabinVolume_);

    static const CabinMediaStatusVolumeStart &getDefaultInstance();

private:

    inline void set_has_CabinVolume ();

    inline void clear_has_CabinVolume ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _CabinVolume;

};

/**
 * The result message of the method "CabinMediaStatusVolume"
 * <p>CAN message to send the volume status through CAN message CabinMedia_Status</p>
 * <p>ID: 0x18FF154C</p>
 * CAN Message data is sent through.
 */
class CabinMediaStatusVolumeResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CabinMediaStatusVolumeResult ();

    /**
     * Copy constructor
     */
    inline  CabinMediaStatusVolumeResult (const CabinMediaStatusVolumeResult &rhs);

    /**
     * All fields constructor
     */
    inline  CabinMediaStatusVolumeResult (uint8 Result_);

    /**
     * Destructor
     */
    inline virtual  ~CabinMediaStatusVolumeResult();

    /**
     * Assignment operator
     */
    inline CabinMediaStatusVolumeResult& operator = (const CabinMediaStatusVolumeResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CabinMediaStatusVolumeResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CabinMediaStatusVolumeResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CabinMediaStatusVolumeResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CabinMediaStatusVolumeResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline uint8 getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (uint8 Result_);

    static const CabinMediaStatusVolumeResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Result;

};

/**
 * The start message of the method "MediaStatusMuteStatus"
 * <p>CAN message to send the Mute status through CAN message CabinMedia_Status</p>
 * <p>ID: 0x18FF124C</p>
 * Method Start can be triggered from HMI to send the Mute status details over can message
 */
class MediaStatusMuteStatusStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MediaStatusMuteStatusStart ();

    /**
     * Copy constructor
     */
    inline  MediaStatusMuteStatusStart (const MediaStatusMuteStatusStart &rhs);

    /**
     * All fields constructor
     */
    inline  MediaStatusMuteStatusStart (uint8 MediaStatusMuteValue_);

    /**
     * Destructor
     */
    inline virtual  ~MediaStatusMuteStatusStart();

    /**
     * Assignment operator
     */
    inline MediaStatusMuteStatusStart& operator = (const MediaStatusMuteStatusStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MediaStatusMuteStatusStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MediaStatusMuteStatusStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MediaStatusMuteStatusStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MediaStatusMuteStatusStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MediaStatusMuteValue"

    static const int kMediaStatusMuteValue = 0;

    /**
     * Clears the field "MediaStatusMuteValue".
     *
     * The field will be set to its default value. The hasMediaStatusMuteValue()
     * method will return false.
     */
    inline void clearMediaStatusMuteValue();

    /**
     * Checks whether the field "MediaStatusMuteValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMediaStatusMuteValue()). Otherwise it will return false.
     */
    inline bool hasMediaStatusMuteValue () const;

    /**
     * Returns the value of the member "MediaStatusMuteValue".
     *
     * If the meaning of "MediaStatusMuteValue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "MediaStatusMuteValue"
     */
    inline uint8 getMediaStatusMuteValue () const;

    /**
     * Sets the value of the member "MediaStatusMuteValue".
     *
     * If the meaning of "MediaStatusMuteValue" isn't clear, then there should be a description here.
     *
     * @param MediaStatusMuteValue The value which will be set
     */
    inline void setMediaStatusMuteValue (uint8 MediaStatusMuteValue_);

    static const MediaStatusMuteStatusStart &getDefaultInstance();

private:

    inline void set_has_MediaStatusMuteValue ();

    inline void clear_has_MediaStatusMuteValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _MediaStatusMuteValue;

};

/**
 * The result message of the method "MediaStatusMuteStatus"
 * <p>CAN message to send the Mute status through CAN message CabinMedia_Status</p>
 * <p>ID: 0x18FF124C</p>
 * CAN Message data is sent through.
 */
class MediaStatusMuteStatusResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MediaStatusMuteStatusResult ();

    /**
     * Copy constructor
     */
    inline  MediaStatusMuteStatusResult (const MediaStatusMuteStatusResult &rhs);

    /**
     * All fields constructor
     */
    inline  MediaStatusMuteStatusResult (uint8 Result_);

    /**
     * Destructor
     */
    inline virtual  ~MediaStatusMuteStatusResult();

    /**
     * Assignment operator
     */
    inline MediaStatusMuteStatusResult& operator = (const MediaStatusMuteStatusResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MediaStatusMuteStatusResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MediaStatusMuteStatusResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MediaStatusMuteStatusResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MediaStatusMuteStatusResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline uint8 getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (uint8 Result_);

    static const MediaStatusMuteStatusResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Result;

};

/**
 * The start message of the method "CabinMediaStatusMuteStatus"
 * <p>CAN message to send the Mute status through CAN message CabinMedia_Status</p>
 * <p>ID: 0x18FF154C</p>
 * Method Start can be triggered from HMI to send the  cabin Mute status details over can message
 */
class CabinMediaStatusMuteStatusStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CabinMediaStatusMuteStatusStart ();

    /**
     * Copy constructor
     */
    inline  CabinMediaStatusMuteStatusStart (const CabinMediaStatusMuteStatusStart &rhs);

    /**
     * All fields constructor
     */
    inline  CabinMediaStatusMuteStatusStart (uint8 CabinMediaStatusMuteValue_);

    /**
     * Destructor
     */
    inline virtual  ~CabinMediaStatusMuteStatusStart();

    /**
     * Assignment operator
     */
    inline CabinMediaStatusMuteStatusStart& operator = (const CabinMediaStatusMuteStatusStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CabinMediaStatusMuteStatusStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CabinMediaStatusMuteStatusStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CabinMediaStatusMuteStatusStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CabinMediaStatusMuteStatusStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CabinMediaStatusMuteValue"

    static const int kCabinMediaStatusMuteValue = 0;

    /**
     * Clears the field "CabinMediaStatusMuteValue".
     *
     * The field will be set to its default value. The hasCabinMediaStatusMuteValue()
     * method will return false.
     */
    inline void clearCabinMediaStatusMuteValue();

    /**
     * Checks whether the field "CabinMediaStatusMuteValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCabinMediaStatusMuteValue()). Otherwise it will return false.
     */
    inline bool hasCabinMediaStatusMuteValue () const;

    /**
     * Returns the value of the member "CabinMediaStatusMuteValue".
     *
     * If the meaning of "CabinMediaStatusMuteValue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "CabinMediaStatusMuteValue"
     */
    inline uint8 getCabinMediaStatusMuteValue () const;

    /**
     * Sets the value of the member "CabinMediaStatusMuteValue".
     *
     * If the meaning of "CabinMediaStatusMuteValue" isn't clear, then there should be a description here.
     *
     * @param CabinMediaStatusMuteValue The value which will be set
     */
    inline void setCabinMediaStatusMuteValue (uint8 CabinMediaStatusMuteValue_);

    static const CabinMediaStatusMuteStatusStart &getDefaultInstance();

private:

    inline void set_has_CabinMediaStatusMuteValue ();

    inline void clear_has_CabinMediaStatusMuteValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _CabinMediaStatusMuteValue;

};

/**
 * The result message of the method "CabinMediaStatusMuteStatus"
 * <p>CAN message to send the Mute status through CAN message CabinMedia_Status</p>
 * <p>ID: 0x18FF154C</p>
 * CAN Message data is sent through.
 */
class CabinMediaStatusMuteStatusResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CabinMediaStatusMuteStatusResult ();

    /**
     * Copy constructor
     */
    inline  CabinMediaStatusMuteStatusResult (const CabinMediaStatusMuteStatusResult &rhs);

    /**
     * All fields constructor
     */
    inline  CabinMediaStatusMuteStatusResult (uint8 Result_);

    /**
     * Destructor
     */
    inline virtual  ~CabinMediaStatusMuteStatusResult();

    /**
     * Assignment operator
     */
    inline CabinMediaStatusMuteStatusResult& operator = (const CabinMediaStatusMuteStatusResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CabinMediaStatusMuteStatusResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CabinMediaStatusMuteStatusResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CabinMediaStatusMuteStatusResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CabinMediaStatusMuteStatusResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline uint8 getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (uint8 Result_);

    static const CabinMediaStatusMuteStatusResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Result;

};

/**
 * The start message of the method "MediaStatusPlayStatus"
 * <p>CAN message to send the Play status through CAN message</p>
 * Method Start can be triggered from HMI to send the  Play status details over can message
 */
class MediaStatusPlayStatusStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MediaStatusPlayStatusStart ();

    /**
     * Copy constructor
     */
    inline  MediaStatusPlayStatusStart (const MediaStatusPlayStatusStart &rhs);

    /**
     * All fields constructor
     */
    inline  MediaStatusPlayStatusStart (uint8 MediaStatusPlayStatusValue_);

    /**
     * Destructor
     */
    inline virtual  ~MediaStatusPlayStatusStart();

    /**
     * Assignment operator
     */
    inline MediaStatusPlayStatusStart& operator = (const MediaStatusPlayStatusStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MediaStatusPlayStatusStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MediaStatusPlayStatusStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MediaStatusPlayStatusStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MediaStatusPlayStatusStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MediaStatusPlayStatusValue"

    static const int kMediaStatusPlayStatusValue = 0;

    /**
     * Clears the field "MediaStatusPlayStatusValue".
     *
     * The field will be set to its default value. The hasMediaStatusPlayStatusValue()
     * method will return false.
     */
    inline void clearMediaStatusPlayStatusValue();

    /**
     * Checks whether the field "MediaStatusPlayStatusValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMediaStatusPlayStatusValue()). Otherwise it will return false.
     */
    inline bool hasMediaStatusPlayStatusValue () const;

    /**
     * Returns the value of the member "MediaStatusPlayStatusValue".
     *
     * If the meaning of "MediaStatusPlayStatusValue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "MediaStatusPlayStatusValue"
     */
    inline uint8 getMediaStatusPlayStatusValue () const;

    /**
     * Sets the value of the member "MediaStatusPlayStatusValue".
     *
     * If the meaning of "MediaStatusPlayStatusValue" isn't clear, then there should be a description here.
     *
     * @param MediaStatusPlayStatusValue The value which will be set
     */
    inline void setMediaStatusPlayStatusValue (uint8 MediaStatusPlayStatusValue_);

    static const MediaStatusPlayStatusStart &getDefaultInstance();

private:

    inline void set_has_MediaStatusPlayStatusValue ();

    inline void clear_has_MediaStatusPlayStatusValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _MediaStatusPlayStatusValue;

};

/**
 * The result message of the method "MediaStatusPlayStatus"
 * <p>CAN message to send the Play status through CAN message</p>
 * CAN Message data is sent through.
 */
class MediaStatusPlayStatusResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MediaStatusPlayStatusResult ();

    /**
     * Copy constructor
     */
    inline  MediaStatusPlayStatusResult (const MediaStatusPlayStatusResult &rhs);

    /**
     * All fields constructor
     */
    inline  MediaStatusPlayStatusResult (uint8 Result_);

    /**
     * Destructor
     */
    inline virtual  ~MediaStatusPlayStatusResult();

    /**
     * Assignment operator
     */
    inline MediaStatusPlayStatusResult& operator = (const MediaStatusPlayStatusResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MediaStatusPlayStatusResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MediaStatusPlayStatusResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MediaStatusPlayStatusResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MediaStatusPlayStatusResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline uint8 getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (uint8 Result_);

    static const MediaStatusPlayStatusResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Result;

};

/**
 * The start message of the method "MediaStatusSeekStatus"
 * <p>CAN message to send the Seek status through CAN message</p>
 * Method Start can be triggered from HMI to send the  Seek status details over can message
 */
class MediaStatusSeekStatusStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MediaStatusSeekStatusStart ();

    /**
     * Copy constructor
     */
    inline  MediaStatusSeekStatusStart (const MediaStatusSeekStatusStart &rhs);

    /**
     * All fields constructor
     */
    inline  MediaStatusSeekStatusStart (uint8 MediaStatusSeekStatusValue_);

    /**
     * Destructor
     */
    inline virtual  ~MediaStatusSeekStatusStart();

    /**
     * Assignment operator
     */
    inline MediaStatusSeekStatusStart& operator = (const MediaStatusSeekStatusStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MediaStatusSeekStatusStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MediaStatusSeekStatusStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MediaStatusSeekStatusStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MediaStatusSeekStatusStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MediaStatusSeekStatusValue"

    static const int kMediaStatusSeekStatusValue = 0;

    /**
     * Clears the field "MediaStatusSeekStatusValue".
     *
     * The field will be set to its default value. The hasMediaStatusSeekStatusValue()
     * method will return false.
     */
    inline void clearMediaStatusSeekStatusValue();

    /**
     * Checks whether the field "MediaStatusSeekStatusValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMediaStatusSeekStatusValue()). Otherwise it will return false.
     */
    inline bool hasMediaStatusSeekStatusValue () const;

    /**
     * Returns the value of the member "MediaStatusSeekStatusValue".
     *
     * If the meaning of "MediaStatusSeekStatusValue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "MediaStatusSeekStatusValue"
     */
    inline uint8 getMediaStatusSeekStatusValue () const;

    /**
     * Sets the value of the member "MediaStatusSeekStatusValue".
     *
     * If the meaning of "MediaStatusSeekStatusValue" isn't clear, then there should be a description here.
     *
     * @param MediaStatusSeekStatusValue The value which will be set
     */
    inline void setMediaStatusSeekStatusValue (uint8 MediaStatusSeekStatusValue_);

    static const MediaStatusSeekStatusStart &getDefaultInstance();

private:

    inline void set_has_MediaStatusSeekStatusValue ();

    inline void clear_has_MediaStatusSeekStatusValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _MediaStatusSeekStatusValue;

};

/**
 * The result message of the method "MediaStatusSeekStatus"
 * <p>CAN message to send the Seek status through CAN message</p>
 * CAN Message data is sent through.
 */
class MediaStatusSeekStatusResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MediaStatusSeekStatusResult ();

    /**
     * Copy constructor
     */
    inline  MediaStatusSeekStatusResult (const MediaStatusSeekStatusResult &rhs);

    /**
     * All fields constructor
     */
    inline  MediaStatusSeekStatusResult (uint8 Result_);

    /**
     * Destructor
     */
    inline virtual  ~MediaStatusSeekStatusResult();

    /**
     * Assignment operator
     */
    inline MediaStatusSeekStatusResult& operator = (const MediaStatusSeekStatusResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MediaStatusSeekStatusResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MediaStatusSeekStatusResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MediaStatusSeekStatusResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MediaStatusSeekStatusResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline uint8 getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (uint8 Result_);

    static const MediaStatusSeekStatusResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Result;

};

/**
 * The start message of the method "MediaStatusRepeatStatus"
 * <p>CAN message to send the Repeat status through CAN message</p>
 * Method Start can be triggered from HMI to send the  Repeat status details over can message
 */
class MediaStatusRepeatStatusStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MediaStatusRepeatStatusStart ();

    /**
     * Copy constructor
     */
    inline  MediaStatusRepeatStatusStart (const MediaStatusRepeatStatusStart &rhs);

    /**
     * All fields constructor
     */
    inline  MediaStatusRepeatStatusStart (uint8 MediaStatusRepeatStatusValue_);

    /**
     * Destructor
     */
    inline virtual  ~MediaStatusRepeatStatusStart();

    /**
     * Assignment operator
     */
    inline MediaStatusRepeatStatusStart& operator = (const MediaStatusRepeatStatusStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MediaStatusRepeatStatusStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MediaStatusRepeatStatusStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MediaStatusRepeatStatusStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MediaStatusRepeatStatusStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MediaStatusRepeatStatusValue"

    static const int kMediaStatusRepeatStatusValue = 0;

    /**
     * Clears the field "MediaStatusRepeatStatusValue".
     *
     * The field will be set to its default value. The hasMediaStatusRepeatStatusValue()
     * method will return false.
     */
    inline void clearMediaStatusRepeatStatusValue();

    /**
     * Checks whether the field "MediaStatusRepeatStatusValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMediaStatusRepeatStatusValue()). Otherwise it will return false.
     */
    inline bool hasMediaStatusRepeatStatusValue () const;

    /**
     * Returns the value of the member "MediaStatusRepeatStatusValue".
     *
     * If the meaning of "MediaStatusRepeatStatusValue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "MediaStatusRepeatStatusValue"
     */
    inline uint8 getMediaStatusRepeatStatusValue () const;

    /**
     * Sets the value of the member "MediaStatusRepeatStatusValue".
     *
     * If the meaning of "MediaStatusRepeatStatusValue" isn't clear, then there should be a description here.
     *
     * @param MediaStatusRepeatStatusValue The value which will be set
     */
    inline void setMediaStatusRepeatStatusValue (uint8 MediaStatusRepeatStatusValue_);

    static const MediaStatusRepeatStatusStart &getDefaultInstance();

private:

    inline void set_has_MediaStatusRepeatStatusValue ();

    inline void clear_has_MediaStatusRepeatStatusValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _MediaStatusRepeatStatusValue;

};

/**
 * The result message of the method "MediaStatusRepeatStatus"
 * <p>CAN message to send the Repeat status through CAN message</p>
 * CAN Message data is sent through.
 */
class MediaStatusRepeatStatusResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MediaStatusRepeatStatusResult ();

    /**
     * Copy constructor
     */
    inline  MediaStatusRepeatStatusResult (const MediaStatusRepeatStatusResult &rhs);

    /**
     * All fields constructor
     */
    inline  MediaStatusRepeatStatusResult (uint8 Result_);

    /**
     * Destructor
     */
    inline virtual  ~MediaStatusRepeatStatusResult();

    /**
     * Assignment operator
     */
    inline MediaStatusRepeatStatusResult& operator = (const MediaStatusRepeatStatusResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MediaStatusRepeatStatusResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MediaStatusRepeatStatusResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MediaStatusRepeatStatusResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MediaStatusRepeatStatusResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline uint8 getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (uint8 Result_);

    static const MediaStatusRepeatStatusResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Result;

};

/**
 * The start message of the method "MediaStatusDABFMStatus"
 * <p>CAN message to send the DABFM status through CAN message</p>
 * Method Start can be triggered from HMI to send the  DABFM status details over can message
 */
class MediaStatusDABFMStatusStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MediaStatusDABFMStatusStart ();

    /**
     * Copy constructor
     */
    inline  MediaStatusDABFMStatusStart (const MediaStatusDABFMStatusStart &rhs);

    /**
     * All fields constructor
     */
    inline  MediaStatusDABFMStatusStart (uint8 MediaStatusDABFMStatusValue_);

    /**
     * Destructor
     */
    inline virtual  ~MediaStatusDABFMStatusStart();

    /**
     * Assignment operator
     */
    inline MediaStatusDABFMStatusStart& operator = (const MediaStatusDABFMStatusStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MediaStatusDABFMStatusStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MediaStatusDABFMStatusStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MediaStatusDABFMStatusStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MediaStatusDABFMStatusStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MediaStatusDABFMStatusValue"

    static const int kMediaStatusDABFMStatusValue = 0;

    /**
     * Clears the field "MediaStatusDABFMStatusValue".
     *
     * The field will be set to its default value. The hasMediaStatusDABFMStatusValue()
     * method will return false.
     */
    inline void clearMediaStatusDABFMStatusValue();

    /**
     * Checks whether the field "MediaStatusDABFMStatusValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMediaStatusDABFMStatusValue()). Otherwise it will return false.
     */
    inline bool hasMediaStatusDABFMStatusValue () const;

    /**
     * Returns the value of the member "MediaStatusDABFMStatusValue".
     *
     * If the meaning of "MediaStatusDABFMStatusValue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "MediaStatusDABFMStatusValue"
     */
    inline uint8 getMediaStatusDABFMStatusValue () const;

    /**
     * Sets the value of the member "MediaStatusDABFMStatusValue".
     *
     * If the meaning of "MediaStatusDABFMStatusValue" isn't clear, then there should be a description here.
     *
     * @param MediaStatusDABFMStatusValue The value which will be set
     */
    inline void setMediaStatusDABFMStatusValue (uint8 MediaStatusDABFMStatusValue_);

    static const MediaStatusDABFMStatusStart &getDefaultInstance();

private:

    inline void set_has_MediaStatusDABFMStatusValue ();

    inline void clear_has_MediaStatusDABFMStatusValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _MediaStatusDABFMStatusValue;

};

/**
 * The result message of the method "MediaStatusDABFMStatus"
 * <p>CAN message to send the DABFM status through CAN message</p>
 * CAN Message data is sent through.
 */
class MediaStatusDABFMStatusResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MediaStatusDABFMStatusResult ();

    /**
     * Copy constructor
     */
    inline  MediaStatusDABFMStatusResult (const MediaStatusDABFMStatusResult &rhs);

    /**
     * All fields constructor
     */
    inline  MediaStatusDABFMStatusResult (uint8 Result_);

    /**
     * Destructor
     */
    inline virtual  ~MediaStatusDABFMStatusResult();

    /**
     * Assignment operator
     */
    inline MediaStatusDABFMStatusResult& operator = (const MediaStatusDABFMStatusResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MediaStatusDABFMStatusResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MediaStatusDABFMStatusResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MediaStatusDABFMStatusResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MediaStatusDABFMStatusResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline uint8 getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (uint8 Result_);

    static const MediaStatusDABFMStatusResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Result;

};

/**
 * The start message of the method "MediaStatusTREGStatus"
 * <p>CAN message to send the TREG status through CAN message</p>
 * Method Start can be triggered from HMI to send the  TREG status details over can message
 */
class MediaStatusTREGStatusStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MediaStatusTREGStatusStart ();

    /**
     * Copy constructor
     */
    inline  MediaStatusTREGStatusStart (const MediaStatusTREGStatusStart &rhs);

    /**
     * All fields constructor
     */
    inline  MediaStatusTREGStatusStart (uint8 MediaStatusTREGStatusValue_);

    /**
     * Destructor
     */
    inline virtual  ~MediaStatusTREGStatusStart();

    /**
     * Assignment operator
     */
    inline MediaStatusTREGStatusStart& operator = (const MediaStatusTREGStatusStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MediaStatusTREGStatusStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MediaStatusTREGStatusStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MediaStatusTREGStatusStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MediaStatusTREGStatusStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MediaStatusTREGStatusValue"

    static const int kMediaStatusTREGStatusValue = 0;

    /**
     * Clears the field "MediaStatusTREGStatusValue".
     *
     * The field will be set to its default value. The hasMediaStatusTREGStatusValue()
     * method will return false.
     */
    inline void clearMediaStatusTREGStatusValue();

    /**
     * Checks whether the field "MediaStatusTREGStatusValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMediaStatusTREGStatusValue()). Otherwise it will return false.
     */
    inline bool hasMediaStatusTREGStatusValue () const;

    /**
     * Returns the value of the member "MediaStatusTREGStatusValue".
     *
     * If the meaning of "MediaStatusTREGStatusValue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "MediaStatusTREGStatusValue"
     */
    inline uint8 getMediaStatusTREGStatusValue () const;

    /**
     * Sets the value of the member "MediaStatusTREGStatusValue".
     *
     * If the meaning of "MediaStatusTREGStatusValue" isn't clear, then there should be a description here.
     *
     * @param MediaStatusTREGStatusValue The value which will be set
     */
    inline void setMediaStatusTREGStatusValue (uint8 MediaStatusTREGStatusValue_);

    static const MediaStatusTREGStatusStart &getDefaultInstance();

private:

    inline void set_has_MediaStatusTREGStatusValue ();

    inline void clear_has_MediaStatusTREGStatusValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _MediaStatusTREGStatusValue;

};

/**
 * The result message of the method "MediaStatusTREGStatus"
 * <p>CAN message to send the TREG status through CAN message</p>
 * CAN Message data is sent through.
 */
class MediaStatusTREGStatusResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MediaStatusTREGStatusResult ();

    /**
     * Copy constructor
     */
    inline  MediaStatusTREGStatusResult (const MediaStatusTREGStatusResult &rhs);

    /**
     * All fields constructor
     */
    inline  MediaStatusTREGStatusResult (uint8 Result_);

    /**
     * Destructor
     */
    inline virtual  ~MediaStatusTREGStatusResult();

    /**
     * Assignment operator
     */
    inline MediaStatusTREGStatusResult& operator = (const MediaStatusTREGStatusResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MediaStatusTREGStatusResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MediaStatusTREGStatusResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MediaStatusTREGStatusResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MediaStatusTREGStatusResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline uint8 getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (uint8 Result_);

    static const MediaStatusTREGStatusResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Result;

};

/**
 * The start message of the method "MediaStatusRDSStatus"
 * <p>CAN message to send the RDS status through CAN message</p>
 * Method Start can be triggered from HMI to send the  RDS status details over can message
 */
class MediaStatusRDSStatusStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MediaStatusRDSStatusStart ();

    /**
     * Copy constructor
     */
    inline  MediaStatusRDSStatusStart (const MediaStatusRDSStatusStart &rhs);

    /**
     * All fields constructor
     */
    inline  MediaStatusRDSStatusStart (uint8 MediaStatusRDSStatusValue_);

    /**
     * Destructor
     */
    inline virtual  ~MediaStatusRDSStatusStart();

    /**
     * Assignment operator
     */
    inline MediaStatusRDSStatusStart& operator = (const MediaStatusRDSStatusStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MediaStatusRDSStatusStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MediaStatusRDSStatusStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MediaStatusRDSStatusStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MediaStatusRDSStatusStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MediaStatusRDSStatusValue"

    static const int kMediaStatusRDSStatusValue = 0;

    /**
     * Clears the field "MediaStatusRDSStatusValue".
     *
     * The field will be set to its default value. The hasMediaStatusRDSStatusValue()
     * method will return false.
     */
    inline void clearMediaStatusRDSStatusValue();

    /**
     * Checks whether the field "MediaStatusRDSStatusValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMediaStatusRDSStatusValue()). Otherwise it will return false.
     */
    inline bool hasMediaStatusRDSStatusValue () const;

    /**
     * Returns the value of the member "MediaStatusRDSStatusValue".
     *
     * If the meaning of "MediaStatusRDSStatusValue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "MediaStatusRDSStatusValue"
     */
    inline uint8 getMediaStatusRDSStatusValue () const;

    /**
     * Sets the value of the member "MediaStatusRDSStatusValue".
     *
     * If the meaning of "MediaStatusRDSStatusValue" isn't clear, then there should be a description here.
     *
     * @param MediaStatusRDSStatusValue The value which will be set
     */
    inline void setMediaStatusRDSStatusValue (uint8 MediaStatusRDSStatusValue_);

    static const MediaStatusRDSStatusStart &getDefaultInstance();

private:

    inline void set_has_MediaStatusRDSStatusValue ();

    inline void clear_has_MediaStatusRDSStatusValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _MediaStatusRDSStatusValue;

};

/**
 * The result message of the method "MediaStatusRDSStatus"
 * <p>CAN message to send the RDS status through CAN message</p>
 * CAN Message data is sent through.
 */
class MediaStatusRDSStatusResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MediaStatusRDSStatusResult ();

    /**
     * Copy constructor
     */
    inline  MediaStatusRDSStatusResult (const MediaStatusRDSStatusResult &rhs);

    /**
     * All fields constructor
     */
    inline  MediaStatusRDSStatusResult (uint8 Result_);

    /**
     * Destructor
     */
    inline virtual  ~MediaStatusRDSStatusResult();

    /**
     * Assignment operator
     */
    inline MediaStatusRDSStatusResult& operator = (const MediaStatusRDSStatusResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MediaStatusRDSStatusResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MediaStatusRDSStatusResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MediaStatusRDSStatusResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MediaStatusRDSStatusResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline uint8 getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (uint8 Result_);

    static const MediaStatusRDSStatusResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Result;

};

/**
 * The start message of the method "MediaStatusTAStatus"
 * <p>CAN message to send the TA status through CAN message</p>
 * Method Start can be triggered from HMI to send the  TA status details over can message
 */
class MediaStatusTAStatusStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MediaStatusTAStatusStart ();

    /**
     * Copy constructor
     */
    inline  MediaStatusTAStatusStart (const MediaStatusTAStatusStart &rhs);

    /**
     * All fields constructor
     */
    inline  MediaStatusTAStatusStart (uint8 MediaStatusTAStatusValue_);

    /**
     * Destructor
     */
    inline virtual  ~MediaStatusTAStatusStart();

    /**
     * Assignment operator
     */
    inline MediaStatusTAStatusStart& operator = (const MediaStatusTAStatusStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MediaStatusTAStatusStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MediaStatusTAStatusStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MediaStatusTAStatusStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MediaStatusTAStatusStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MediaStatusTAStatusValue"

    static const int kMediaStatusTAStatusValue = 0;

    /**
     * Clears the field "MediaStatusTAStatusValue".
     *
     * The field will be set to its default value. The hasMediaStatusTAStatusValue()
     * method will return false.
     */
    inline void clearMediaStatusTAStatusValue();

    /**
     * Checks whether the field "MediaStatusTAStatusValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMediaStatusTAStatusValue()). Otherwise it will return false.
     */
    inline bool hasMediaStatusTAStatusValue () const;

    /**
     * Returns the value of the member "MediaStatusTAStatusValue".
     *
     * If the meaning of "MediaStatusTAStatusValue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "MediaStatusTAStatusValue"
     */
    inline uint8 getMediaStatusTAStatusValue () const;

    /**
     * Sets the value of the member "MediaStatusTAStatusValue".
     *
     * If the meaning of "MediaStatusTAStatusValue" isn't clear, then there should be a description here.
     *
     * @param MediaStatusTAStatusValue The value which will be set
     */
    inline void setMediaStatusTAStatusValue (uint8 MediaStatusTAStatusValue_);

    static const MediaStatusTAStatusStart &getDefaultInstance();

private:

    inline void set_has_MediaStatusTAStatusValue ();

    inline void clear_has_MediaStatusTAStatusValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _MediaStatusTAStatusValue;

};

/**
 * The result message of the method "MediaStatusTAStatus"
 * <p>CAN message to send the TA status through CAN message</p>
 * CAN Message data is sent through.
 */
class MediaStatusTAStatusResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MediaStatusTAStatusResult ();

    /**
     * Copy constructor
     */
    inline  MediaStatusTAStatusResult (const MediaStatusTAStatusResult &rhs);

    /**
     * All fields constructor
     */
    inline  MediaStatusTAStatusResult (uint8 Result_);

    /**
     * Destructor
     */
    inline virtual  ~MediaStatusTAStatusResult();

    /**
     * Assignment operator
     */
    inline MediaStatusTAStatusResult& operator = (const MediaStatusTAStatusResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MediaStatusTAStatusResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MediaStatusTAStatusResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MediaStatusTAStatusResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MediaStatusTAStatusResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline uint8 getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (uint8 Result_);

    static const MediaStatusTAStatusResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Result;

};

/**
 * The start message of the method "MediaStatusTPStatus"
 * <p>CAN message to send the TP status through CAN message</p>
 * Method Start can be triggered from HMI to send the  TP status details over can message
 */
class MediaStatusTPStatusStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MediaStatusTPStatusStart ();

    /**
     * Copy constructor
     */
    inline  MediaStatusTPStatusStart (const MediaStatusTPStatusStart &rhs);

    /**
     * All fields constructor
     */
    inline  MediaStatusTPStatusStart (uint8 MediaStatusTPStatusValue_);

    /**
     * Destructor
     */
    inline virtual  ~MediaStatusTPStatusStart();

    /**
     * Assignment operator
     */
    inline MediaStatusTPStatusStart& operator = (const MediaStatusTPStatusStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MediaStatusTPStatusStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MediaStatusTPStatusStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MediaStatusTPStatusStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MediaStatusTPStatusStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MediaStatusTPStatusValue"

    static const int kMediaStatusTPStatusValue = 0;

    /**
     * Clears the field "MediaStatusTPStatusValue".
     *
     * The field will be set to its default value. The hasMediaStatusTPStatusValue()
     * method will return false.
     */
    inline void clearMediaStatusTPStatusValue();

    /**
     * Checks whether the field "MediaStatusTPStatusValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMediaStatusTPStatusValue()). Otherwise it will return false.
     */
    inline bool hasMediaStatusTPStatusValue () const;

    /**
     * Returns the value of the member "MediaStatusTPStatusValue".
     *
     * If the meaning of "MediaStatusTPStatusValue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "MediaStatusTPStatusValue"
     */
    inline uint8 getMediaStatusTPStatusValue () const;

    /**
     * Sets the value of the member "MediaStatusTPStatusValue".
     *
     * If the meaning of "MediaStatusTPStatusValue" isn't clear, then there should be a description here.
     *
     * @param MediaStatusTPStatusValue The value which will be set
     */
    inline void setMediaStatusTPStatusValue (uint8 MediaStatusTPStatusValue_);

    static const MediaStatusTPStatusStart &getDefaultInstance();

private:

    inline void set_has_MediaStatusTPStatusValue ();

    inline void clear_has_MediaStatusTPStatusValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _MediaStatusTPStatusValue;

};

/**
 * The result message of the method "MediaStatusTPStatus"
 * <p>CAN message to send the TP status through CAN message</p>
 * CAN Message data is sent through.
 */
class MediaStatusTPStatusResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MediaStatusTPStatusResult ();

    /**
     * Copy constructor
     */
    inline  MediaStatusTPStatusResult (const MediaStatusTPStatusResult &rhs);

    /**
     * All fields constructor
     */
    inline  MediaStatusTPStatusResult (uint8 Result_);

    /**
     * Destructor
     */
    inline virtual  ~MediaStatusTPStatusResult();

    /**
     * Assignment operator
     */
    inline MediaStatusTPStatusResult& operator = (const MediaStatusTPStatusResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MediaStatusTPStatusResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MediaStatusTPStatusResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MediaStatusTPStatusResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MediaStatusTPStatusResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline uint8 getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (uint8 Result_);

    static const MediaStatusTPStatusResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Result;

};

/**
 * The start message of the method "MediaStatusTunerBandStatus"
 * <p>CAN message to send the TunerBand status through CAN message</p>
 * Method Start can be triggered from HMI to send the  TunerBand status details over can message
 */
class MediaStatusTunerBandStatusStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MediaStatusTunerBandStatusStart ();

    /**
     * Copy constructor
     */
    inline  MediaStatusTunerBandStatusStart (const MediaStatusTunerBandStatusStart &rhs);

    /**
     * All fields constructor
     */
    inline  MediaStatusTunerBandStatusStart (uint8 MediaStatusTunerBandStatusValue_);

    /**
     * Destructor
     */
    inline virtual  ~MediaStatusTunerBandStatusStart();

    /**
     * Assignment operator
     */
    inline MediaStatusTunerBandStatusStart& operator = (const MediaStatusTunerBandStatusStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MediaStatusTunerBandStatusStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MediaStatusTunerBandStatusStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MediaStatusTunerBandStatusStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MediaStatusTunerBandStatusStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MediaStatusTunerBandStatusValue"

    static const int kMediaStatusTunerBandStatusValue = 0;

    /**
     * Clears the field "MediaStatusTunerBandStatusValue".
     *
     * The field will be set to its default value. The hasMediaStatusTunerBandStatusValue()
     * method will return false.
     */
    inline void clearMediaStatusTunerBandStatusValue();

    /**
     * Checks whether the field "MediaStatusTunerBandStatusValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMediaStatusTunerBandStatusValue()). Otherwise it will return false.
     */
    inline bool hasMediaStatusTunerBandStatusValue () const;

    /**
     * Returns the value of the member "MediaStatusTunerBandStatusValue".
     *
     * If the meaning of "MediaStatusTunerBandStatusValue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "MediaStatusTunerBandStatusValue"
     */
    inline uint8 getMediaStatusTunerBandStatusValue () const;

    /**
     * Sets the value of the member "MediaStatusTunerBandStatusValue".
     *
     * If the meaning of "MediaStatusTunerBandStatusValue" isn't clear, then there should be a description here.
     *
     * @param MediaStatusTunerBandStatusValue The value which will be set
     */
    inline void setMediaStatusTunerBandStatusValue (uint8 MediaStatusTunerBandStatusValue_);

    static const MediaStatusTunerBandStatusStart &getDefaultInstance();

private:

    inline void set_has_MediaStatusTunerBandStatusValue ();

    inline void clear_has_MediaStatusTunerBandStatusValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _MediaStatusTunerBandStatusValue;

};

/**
 * The result message of the method "MediaStatusTunerBandStatus"
 * <p>CAN message to send the TunerBand status through CAN message</p>
 * CAN Message data is sent through.
 */
class MediaStatusTunerBandStatusResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MediaStatusTunerBandStatusResult ();

    /**
     * Copy constructor
     */
    inline  MediaStatusTunerBandStatusResult (const MediaStatusTunerBandStatusResult &rhs);

    /**
     * All fields constructor
     */
    inline  MediaStatusTunerBandStatusResult (uint8 Result_);

    /**
     * Destructor
     */
    inline virtual  ~MediaStatusTunerBandStatusResult();

    /**
     * Assignment operator
     */
    inline MediaStatusTunerBandStatusResult& operator = (const MediaStatusTunerBandStatusResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MediaStatusTunerBandStatusResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MediaStatusTunerBandStatusResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MediaStatusTunerBandStatusResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MediaStatusTunerBandStatusResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline uint8 getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (uint8 Result_);

    static const MediaStatusTunerBandStatusResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Result;

};

/**
 * The start message of the method "MediaStatusTunerPresetStatus"
 * <p>CAN message to send the TunerPresetStation status through CAN message</p>
 * Method Start can be triggered from HMI to send the  TunerBand status details over can message
 */
class MediaStatusTunerPresetStatusStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MediaStatusTunerPresetStatusStart ();

    /**
     * Copy constructor
     */
    inline  MediaStatusTunerPresetStatusStart (const MediaStatusTunerPresetStatusStart &rhs);

    /**
     * All fields constructor
     */
    inline  MediaStatusTunerPresetStatusStart (uint8 MediaStatusTunerPresetStatusValue_);

    /**
     * Destructor
     */
    inline virtual  ~MediaStatusTunerPresetStatusStart();

    /**
     * Assignment operator
     */
    inline MediaStatusTunerPresetStatusStart& operator = (const MediaStatusTunerPresetStatusStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MediaStatusTunerPresetStatusStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MediaStatusTunerPresetStatusStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MediaStatusTunerPresetStatusStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MediaStatusTunerPresetStatusStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MediaStatusTunerPresetStatusValue"

    static const int kMediaStatusTunerPresetStatusValue = 0;

    /**
     * Clears the field "MediaStatusTunerPresetStatusValue".
     *
     * The field will be set to its default value. The hasMediaStatusTunerPresetStatusValue()
     * method will return false.
     */
    inline void clearMediaStatusTunerPresetStatusValue();

    /**
     * Checks whether the field "MediaStatusTunerPresetStatusValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMediaStatusTunerPresetStatusValue()). Otherwise it will return false.
     */
    inline bool hasMediaStatusTunerPresetStatusValue () const;

    /**
     * Returns the value of the member "MediaStatusTunerPresetStatusValue".
     *
     * If the meaning of "MediaStatusTunerPresetStatusValue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "MediaStatusTunerPresetStatusValue"
     */
    inline uint8 getMediaStatusTunerPresetStatusValue () const;

    /**
     * Sets the value of the member "MediaStatusTunerPresetStatusValue".
     *
     * If the meaning of "MediaStatusTunerPresetStatusValue" isn't clear, then there should be a description here.
     *
     * @param MediaStatusTunerPresetStatusValue The value which will be set
     */
    inline void setMediaStatusTunerPresetStatusValue (uint8 MediaStatusTunerPresetStatusValue_);

    static const MediaStatusTunerPresetStatusStart &getDefaultInstance();

private:

    inline void set_has_MediaStatusTunerPresetStatusValue ();

    inline void clear_has_MediaStatusTunerPresetStatusValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _MediaStatusTunerPresetStatusValue;

};

/**
 * The result message of the method "MediaStatusTunerPresetStatus"
 * <p>CAN message to send the TunerPresetStation status through CAN message</p>
 * CAN Message data is sent through.
 */
class MediaStatusTunerPresetStatusResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MediaStatusTunerPresetStatusResult ();

    /**
     * Copy constructor
     */
    inline  MediaStatusTunerPresetStatusResult (const MediaStatusTunerPresetStatusResult &rhs);

    /**
     * All fields constructor
     */
    inline  MediaStatusTunerPresetStatusResult (uint8 Result_);

    /**
     * Destructor
     */
    inline virtual  ~MediaStatusTunerPresetStatusResult();

    /**
     * Assignment operator
     */
    inline MediaStatusTunerPresetStatusResult& operator = (const MediaStatusTunerPresetStatusResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MediaStatusTunerPresetStatusResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MediaStatusTunerPresetStatusResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MediaStatusTunerPresetStatusResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MediaStatusTunerPresetStatusResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline uint8 getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (uint8 Result_);

    static const MediaStatusTunerPresetStatusResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Result;

};

/**
 * The start message of the method "MediaStatusMixState"
 * <p>CAN message to send the TunerPresetStation status through CAN message</p>
 * Method Start can be triggered from HMI to send the  mixstate details over can message
 */
class MediaStatusMixStateStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MediaStatusMixStateStart ();

    /**
     * Copy constructor
     */
    inline  MediaStatusMixStateStart (const MediaStatusMixStateStart &rhs);

    /**
     * All fields constructor
     */
    inline  MediaStatusMixStateStart (uint8 MediaStatusMixStateValue_);

    /**
     * Destructor
     */
    inline virtual  ~MediaStatusMixStateStart();

    /**
     * Assignment operator
     */
    inline MediaStatusMixStateStart& operator = (const MediaStatusMixStateStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MediaStatusMixStateStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MediaStatusMixStateStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MediaStatusMixStateStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MediaStatusMixStateStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MediaStatusMixStateValue"

    static const int kMediaStatusMixStateValue = 0;

    /**
     * Clears the field "MediaStatusMixStateValue".
     *
     * The field will be set to its default value. The hasMediaStatusMixStateValue()
     * method will return false.
     */
    inline void clearMediaStatusMixStateValue();

    /**
     * Checks whether the field "MediaStatusMixStateValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMediaStatusMixStateValue()). Otherwise it will return false.
     */
    inline bool hasMediaStatusMixStateValue () const;

    /**
     * Returns the value of the member "MediaStatusMixStateValue".
     *
     * If the meaning of "MediaStatusMixStateValue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "MediaStatusMixStateValue"
     */
    inline uint8 getMediaStatusMixStateValue () const;

    /**
     * Sets the value of the member "MediaStatusMixStateValue".
     *
     * If the meaning of "MediaStatusMixStateValue" isn't clear, then there should be a description here.
     *
     * @param MediaStatusMixStateValue The value which will be set
     */
    inline void setMediaStatusMixStateValue (uint8 MediaStatusMixStateValue_);

    static const MediaStatusMixStateStart &getDefaultInstance();

private:

    inline void set_has_MediaStatusMixStateValue ();

    inline void clear_has_MediaStatusMixStateValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _MediaStatusMixStateValue;

};

/**
 * The result message of the method "MediaStatusMixState"
 * <p>CAN message to send the TunerPresetStation status through CAN message</p>
 * CAN Message data is sent through.
 */
class MediaStatusMixStateResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MediaStatusMixStateResult ();

    /**
     * Copy constructor
     */
    inline  MediaStatusMixStateResult (const MediaStatusMixStateResult &rhs);

    /**
     * All fields constructor
     */
    inline  MediaStatusMixStateResult (uint8 Result_);

    /**
     * Destructor
     */
    inline virtual  ~MediaStatusMixStateResult();

    /**
     * Assignment operator
     */
    inline MediaStatusMixStateResult& operator = (const MediaStatusMixStateResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MediaStatusMixStateResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MediaStatusMixStateResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MediaStatusMixStateResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MediaStatusMixStateResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline uint8 getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (uint8 Result_);

    static const MediaStatusMixStateResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Result;

};

/**
 * The start message of the method "MediaStatusPlaylistMode"
 * <p>CAN message to send the TunerPresetStation status through CAN message</p>
 * Method Start can be triggered from HMI to send the  PlaylistStatus details over can message
 */
class MediaStatusPlaylistModeStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MediaStatusPlaylistModeStart ();

    /**
     * Copy constructor
     */
    inline  MediaStatusPlaylistModeStart (const MediaStatusPlaylistModeStart &rhs);

    /**
     * All fields constructor
     */
    inline  MediaStatusPlaylistModeStart (uint8 MediaStatusPlaylistModeValue_);

    /**
     * Destructor
     */
    inline virtual  ~MediaStatusPlaylistModeStart();

    /**
     * Assignment operator
     */
    inline MediaStatusPlaylistModeStart& operator = (const MediaStatusPlaylistModeStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MediaStatusPlaylistModeStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MediaStatusPlaylistModeStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MediaStatusPlaylistModeStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MediaStatusPlaylistModeStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MediaStatusPlaylistModeValue"

    static const int kMediaStatusPlaylistModeValue = 0;

    /**
     * Clears the field "MediaStatusPlaylistModeValue".
     *
     * The field will be set to its default value. The hasMediaStatusPlaylistModeValue()
     * method will return false.
     */
    inline void clearMediaStatusPlaylistModeValue();

    /**
     * Checks whether the field "MediaStatusPlaylistModeValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMediaStatusPlaylistModeValue()). Otherwise it will return false.
     */
    inline bool hasMediaStatusPlaylistModeValue () const;

    /**
     * Returns the value of the member "MediaStatusPlaylistModeValue".
     *
     * If the meaning of "MediaStatusPlaylistModeValue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "MediaStatusPlaylistModeValue"
     */
    inline uint8 getMediaStatusPlaylistModeValue () const;

    /**
     * Sets the value of the member "MediaStatusPlaylistModeValue".
     *
     * If the meaning of "MediaStatusPlaylistModeValue" isn't clear, then there should be a description here.
     *
     * @param MediaStatusPlaylistModeValue The value which will be set
     */
    inline void setMediaStatusPlaylistModeValue (uint8 MediaStatusPlaylistModeValue_);

    static const MediaStatusPlaylistModeStart &getDefaultInstance();

private:

    inline void set_has_MediaStatusPlaylistModeValue ();

    inline void clear_has_MediaStatusPlaylistModeValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _MediaStatusPlaylistModeValue;

};

/**
 * The result message of the method "MediaStatusPlaylistMode"
 * <p>CAN message to send the TunerPresetStation status through CAN message</p>
 * CAN Message data is sent through.
 */
class MediaStatusPlaylistModeResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MediaStatusPlaylistModeResult ();

    /**
     * Copy constructor
     */
    inline  MediaStatusPlaylistModeResult (const MediaStatusPlaylistModeResult &rhs);

    /**
     * All fields constructor
     */
    inline  MediaStatusPlaylistModeResult (uint8 Result_);

    /**
     * Destructor
     */
    inline virtual  ~MediaStatusPlaylistModeResult();

    /**
     * Assignment operator
     */
    inline MediaStatusPlaylistModeResult& operator = (const MediaStatusPlaylistModeResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MediaStatusPlaylistModeResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MediaStatusPlaylistModeResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MediaStatusPlaylistModeResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MediaStatusPlaylistModeResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline uint8 getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (uint8 Result_);

    static const MediaStatusPlaylistModeResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Result;

};

/**
 * The start message of the method "MediaStatusTrackTime"
 * <p>CAN message to send the TrackTime status through CAN message</p>
 * Method Start can be triggered from HMI to send the  TrackTime details over can message
 */
class MediaStatusTrackTimeStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MediaStatusTrackTimeStart ();

    /**
     * Copy constructor
     */
    inline  MediaStatusTrackTimeStart (const MediaStatusTrackTimeStart &rhs);

    /**
     * All fields constructor
     */
    inline  MediaStatusTrackTimeStart (uint16 MediaStatusTrackTimeValue_);

    /**
     * Destructor
     */
    inline virtual  ~MediaStatusTrackTimeStart();

    /**
     * Assignment operator
     */
    inline MediaStatusTrackTimeStart& operator = (const MediaStatusTrackTimeStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MediaStatusTrackTimeStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MediaStatusTrackTimeStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MediaStatusTrackTimeStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MediaStatusTrackTimeStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MediaStatusTrackTimeValue"

    static const int kMediaStatusTrackTimeValue = 0;

    /**
     * Clears the field "MediaStatusTrackTimeValue".
     *
     * The field will be set to its default value. The hasMediaStatusTrackTimeValue()
     * method will return false.
     */
    inline void clearMediaStatusTrackTimeValue();

    /**
     * Checks whether the field "MediaStatusTrackTimeValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMediaStatusTrackTimeValue()). Otherwise it will return false.
     */
    inline bool hasMediaStatusTrackTimeValue () const;

    /**
     * Returns the value of the member "MediaStatusTrackTimeValue".
     *
     * If the meaning of "MediaStatusTrackTimeValue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "MediaStatusTrackTimeValue"
     */
    inline uint16 getMediaStatusTrackTimeValue () const;

    /**
     * Sets the value of the member "MediaStatusTrackTimeValue".
     *
     * If the meaning of "MediaStatusTrackTimeValue" isn't clear, then there should be a description here.
     *
     * @param MediaStatusTrackTimeValue The value which will be set
     */
    inline void setMediaStatusTrackTimeValue (uint16 MediaStatusTrackTimeValue_);

    static const MediaStatusTrackTimeStart &getDefaultInstance();

private:

    inline void set_has_MediaStatusTrackTimeValue ();

    inline void clear_has_MediaStatusTrackTimeValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _MediaStatusTrackTimeValue;

};

/**
 * The result message of the method "MediaStatusTrackTime"
 * <p>CAN message to send the TrackTime status through CAN message</p>
 * CAN Message data is sent through.
 */
class MediaStatusTrackTimeResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MediaStatusTrackTimeResult ();

    /**
     * Copy constructor
     */
    inline  MediaStatusTrackTimeResult (const MediaStatusTrackTimeResult &rhs);

    /**
     * All fields constructor
     */
    inline  MediaStatusTrackTimeResult (uint8 Result_);

    /**
     * Destructor
     */
    inline virtual  ~MediaStatusTrackTimeResult();

    /**
     * Assignment operator
     */
    inline MediaStatusTrackTimeResult& operator = (const MediaStatusTrackTimeResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MediaStatusTrackTimeResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MediaStatusTrackTimeResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MediaStatusTrackTimeResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MediaStatusTrackTimeResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline uint8 getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (uint8 Result_);

    static const MediaStatusTrackTimeResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Result;

};

/**
 * The start message of the method "MediaStatusCurrTrackNum"
 * <p>CAN message to send the CurrTrackNumber status through CAN message</p>
 * Method Start can be triggered from HMI to send the  CurrTrackNumber details over can message
 */
class MediaStatusCurrTrackNumStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MediaStatusCurrTrackNumStart ();

    /**
     * Copy constructor
     */
    inline  MediaStatusCurrTrackNumStart (const MediaStatusCurrTrackNumStart &rhs);

    /**
     * All fields constructor
     */
    inline  MediaStatusCurrTrackNumStart (uint16 MediaStatusCurrTrackNumValue_);

    /**
     * Destructor
     */
    inline virtual  ~MediaStatusCurrTrackNumStart();

    /**
     * Assignment operator
     */
    inline MediaStatusCurrTrackNumStart& operator = (const MediaStatusCurrTrackNumStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MediaStatusCurrTrackNumStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MediaStatusCurrTrackNumStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MediaStatusCurrTrackNumStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MediaStatusCurrTrackNumStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MediaStatusCurrTrackNumValue"

    static const int kMediaStatusCurrTrackNumValue = 0;

    /**
     * Clears the field "MediaStatusCurrTrackNumValue".
     *
     * The field will be set to its default value. The hasMediaStatusCurrTrackNumValue()
     * method will return false.
     */
    inline void clearMediaStatusCurrTrackNumValue();

    /**
     * Checks whether the field "MediaStatusCurrTrackNumValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMediaStatusCurrTrackNumValue()). Otherwise it will return false.
     */
    inline bool hasMediaStatusCurrTrackNumValue () const;

    /**
     * Returns the value of the member "MediaStatusCurrTrackNumValue".
     *
     * If the meaning of "MediaStatusCurrTrackNumValue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "MediaStatusCurrTrackNumValue"
     */
    inline uint16 getMediaStatusCurrTrackNumValue () const;

    /**
     * Sets the value of the member "MediaStatusCurrTrackNumValue".
     *
     * If the meaning of "MediaStatusCurrTrackNumValue" isn't clear, then there should be a description here.
     *
     * @param MediaStatusCurrTrackNumValue The value which will be set
     */
    inline void setMediaStatusCurrTrackNumValue (uint16 MediaStatusCurrTrackNumValue_);

    static const MediaStatusCurrTrackNumStart &getDefaultInstance();

private:

    inline void set_has_MediaStatusCurrTrackNumValue ();

    inline void clear_has_MediaStatusCurrTrackNumValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _MediaStatusCurrTrackNumValue;

};

/**
 * The result message of the method "MediaStatusCurrTrackNum"
 * <p>CAN message to send the CurrTrackNumber status through CAN message</p>
 * CAN Message data is sent through.
 */
class MediaStatusCurrTrackNumResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MediaStatusCurrTrackNumResult ();

    /**
     * Copy constructor
     */
    inline  MediaStatusCurrTrackNumResult (const MediaStatusCurrTrackNumResult &rhs);

    /**
     * All fields constructor
     */
    inline  MediaStatusCurrTrackNumResult (uint8 Result_);

    /**
     * Destructor
     */
    inline virtual  ~MediaStatusCurrTrackNumResult();

    /**
     * Assignment operator
     */
    inline MediaStatusCurrTrackNumResult& operator = (const MediaStatusCurrTrackNumResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MediaStatusCurrTrackNumResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MediaStatusCurrTrackNumResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MediaStatusCurrTrackNumResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MediaStatusCurrTrackNumResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline uint8 getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (uint8 Result_);

    static const MediaStatusCurrTrackNumResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Result;

};

/**
 * The start message of the method "MediaStatusTREGRTMStatus"
 * <p>CAN message to send the TREGRTMStatus  through CAN MediaStatus message</p>
 * Method Start can be triggered from Tuner TREGRTM Status details over can message
 */
class MediaStatusTREGRTMStatusStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MediaStatusTREGRTMStatusStart ();

    /**
     * Copy constructor
     */
    inline  MediaStatusTREGRTMStatusStart (const MediaStatusTREGRTMStatusStart &rhs);

    /**
     * All fields constructor
     */
    inline  MediaStatusTREGRTMStatusStart (uint8 MediaStatusTREGRTMStatusValue_);

    /**
     * Destructor
     */
    inline virtual  ~MediaStatusTREGRTMStatusStart();

    /**
     * Assignment operator
     */
    inline MediaStatusTREGRTMStatusStart& operator = (const MediaStatusTREGRTMStatusStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MediaStatusTREGRTMStatusStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MediaStatusTREGRTMStatusStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MediaStatusTREGRTMStatusStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MediaStatusTREGRTMStatusStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MediaStatusTREGRTMStatusValue"

    static const int kMediaStatusTREGRTMStatusValue = 0;

    /**
     * Clears the field "MediaStatusTREGRTMStatusValue".
     *
     * The field will be set to its default value. The hasMediaStatusTREGRTMStatusValue()
     * method will return false.
     */
    inline void clearMediaStatusTREGRTMStatusValue();

    /**
     * Checks whether the field "MediaStatusTREGRTMStatusValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMediaStatusTREGRTMStatusValue()). Otherwise it will return false.
     */
    inline bool hasMediaStatusTREGRTMStatusValue () const;

    /**
     * Returns the value of the member "MediaStatusTREGRTMStatusValue".
     *
     * If the meaning of "MediaStatusTREGRTMStatusValue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "MediaStatusTREGRTMStatusValue"
     */
    inline uint8 getMediaStatusTREGRTMStatusValue () const;

    /**
     * Sets the value of the member "MediaStatusTREGRTMStatusValue".
     *
     * If the meaning of "MediaStatusTREGRTMStatusValue" isn't clear, then there should be a description here.
     *
     * @param MediaStatusTREGRTMStatusValue The value which will be set
     */
    inline void setMediaStatusTREGRTMStatusValue (uint8 MediaStatusTREGRTMStatusValue_);

    static const MediaStatusTREGRTMStatusStart &getDefaultInstance();

private:

    inline void set_has_MediaStatusTREGRTMStatusValue ();

    inline void clear_has_MediaStatusTREGRTMStatusValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _MediaStatusTREGRTMStatusValue;

};

/**
 * The result message of the method "MediaStatusTREGRTMStatus"
 * <p>CAN message to send the TREGRTMStatus  through CAN MediaStatus message</p>
 * CAN Message data is sent through.
 */
class MediaStatusTREGRTMStatusResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MediaStatusTREGRTMStatusResult ();

    /**
     * Copy constructor
     */
    inline  MediaStatusTREGRTMStatusResult (const MediaStatusTREGRTMStatusResult &rhs);

    /**
     * All fields constructor
     */
    inline  MediaStatusTREGRTMStatusResult (uint8 Result_);

    /**
     * Destructor
     */
    inline virtual  ~MediaStatusTREGRTMStatusResult();

    /**
     * Assignment operator
     */
    inline MediaStatusTREGRTMStatusResult& operator = (const MediaStatusTREGRTMStatusResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MediaStatusTREGRTMStatusResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MediaStatusTREGRTMStatusResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MediaStatusTREGRTMStatusResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MediaStatusTREGRTMStatusResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline uint8 getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (uint8 Result_);

    static const MediaStatusTREGRTMStatusResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Result;

};

/**
 * The start message of the method "CabinMediaStatusTunerBand"
 * <p>CAN message to send the Cabin Tuner Band Status through CAN CabinMediaStatus message</p>
 * Method Start can be triggered from Tuner TREGRTM Status details over can message
 */
class CabinMediaStatusTunerBandStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CabinMediaStatusTunerBandStart ();

    /**
     * Copy constructor
     */
    inline  CabinMediaStatusTunerBandStart (const CabinMediaStatusTunerBandStart &rhs);

    /**
     * All fields constructor
     */
    inline  CabinMediaStatusTunerBandStart (uint8 CabinMediaStatusTunerBandValue_);

    /**
     * Destructor
     */
    inline virtual  ~CabinMediaStatusTunerBandStart();

    /**
     * Assignment operator
     */
    inline CabinMediaStatusTunerBandStart& operator = (const CabinMediaStatusTunerBandStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CabinMediaStatusTunerBandStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CabinMediaStatusTunerBandStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CabinMediaStatusTunerBandStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CabinMediaStatusTunerBandStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CabinMediaStatusTunerBandValue"

    static const int kCabinMediaStatusTunerBandValue = 0;

    /**
     * Clears the field "CabinMediaStatusTunerBandValue".
     *
     * The field will be set to its default value. The hasCabinMediaStatusTunerBandValue()
     * method will return false.
     */
    inline void clearCabinMediaStatusTunerBandValue();

    /**
     * Checks whether the field "CabinMediaStatusTunerBandValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCabinMediaStatusTunerBandValue()). Otherwise it will return false.
     */
    inline bool hasCabinMediaStatusTunerBandValue () const;

    /**
     * Returns the value of the member "CabinMediaStatusTunerBandValue".
     *
     * If the meaning of "CabinMediaStatusTunerBandValue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "CabinMediaStatusTunerBandValue"
     */
    inline uint8 getCabinMediaStatusTunerBandValue () const;

    /**
     * Sets the value of the member "CabinMediaStatusTunerBandValue".
     *
     * If the meaning of "CabinMediaStatusTunerBandValue" isn't clear, then there should be a description here.
     *
     * @param CabinMediaStatusTunerBandValue The value which will be set
     */
    inline void setCabinMediaStatusTunerBandValue (uint8 CabinMediaStatusTunerBandValue_);

    static const CabinMediaStatusTunerBandStart &getDefaultInstance();

private:

    inline void set_has_CabinMediaStatusTunerBandValue ();

    inline void clear_has_CabinMediaStatusTunerBandValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _CabinMediaStatusTunerBandValue;

};

/**
 * The result message of the method "CabinMediaStatusTunerBand"
 * <p>CAN message to send the Cabin Tuner Band Status through CAN CabinMediaStatus message</p>
 * CAN Message data is sent through.
 */
class CabinMediaStatusTunerBandResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CabinMediaStatusTunerBandResult ();

    /**
     * Copy constructor
     */
    inline  CabinMediaStatusTunerBandResult (const CabinMediaStatusTunerBandResult &rhs);

    /**
     * All fields constructor
     */
    inline  CabinMediaStatusTunerBandResult (uint8 Result_);

    /**
     * Destructor
     */
    inline virtual  ~CabinMediaStatusTunerBandResult();

    /**
     * Assignment operator
     */
    inline CabinMediaStatusTunerBandResult& operator = (const CabinMediaStatusTunerBandResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CabinMediaStatusTunerBandResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CabinMediaStatusTunerBandResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CabinMediaStatusTunerBandResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CabinMediaStatusTunerBandResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline uint8 getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (uint8 Result_);

    static const CabinMediaStatusTunerBandResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Result;

};

/**
 * The result message of the method "CSMEngineeringData"
 * CAN messages (relevant to display in engineering test mode) will be collected by VD VehicleData.
 * To be initiated by a cyclic methodStart (e.g. every 2sec) must be triggered by the client.
 * CSM Engineering data could be displayed in the following way:
 * <p>ID: 0x000005C2, Status: 0x00000001, Data: 00 00 00 00 00 00 00 20</p>
 * <p>...</p>
 * CAN Message data is sent through this.
 */
class CSMEngineeringDataResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CSMEngineeringDataResult ();

    /**
     * Copy constructor
     */
    inline  CSMEngineeringDataResult (const CSMEngineeringDataResult &rhs);

    /**
     * All fields constructor
     */
    inline  CSMEngineeringDataResult (const ::std::vector< ::vehicle_main_fi_types::T_CAN_Message >& CanMessageList_);

    /**
     * Destructor
     */
    inline virtual  ~CSMEngineeringDataResult();

    /**
     * Assignment operator
     */
    inline CSMEngineeringDataResult& operator = (const CSMEngineeringDataResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CSMEngineeringDataResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CSMEngineeringDataResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CSMEngineeringDataResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CSMEngineeringDataResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CanMessageList"

    static const int kCanMessageList = 0;

    /**
     * Clears the field "CanMessageList".
     *
     * The field will be set to its default value. The hasCanMessageList()
     * method will return false.
     */
    inline void clearCanMessageList();

    /**
     * Checks whether the field "CanMessageList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCanMessageList()). Otherwise it will return false.
     */
    inline bool hasCanMessageList () const;

    /**
     * Returns the value of the member "CanMessageList".
     *
     * List of the CAN Messages along with the data
     *
     * @return The value of the field "CanMessageList"
     */
    inline const ::std::vector< ::vehicle_main_fi_types::T_CAN_Message >& getCanMessageList () const;

    /**
     * Retrieves the value of the field "CanMessageList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CanMessageList".
     */
    inline ::std::vector< ::vehicle_main_fi_types::T_CAN_Message >& getCanMessageListMutable ();

    /**
     * Sets the value of the member "CanMessageList".
     *
     * List of the CAN Messages along with the data
     *
     * @param CanMessageList The value which will be set
     */
    inline void setCanMessageList (const ::std::vector< ::vehicle_main_fi_types::T_CAN_Message >& CanMessageList_);

    static const CSMEngineeringDataResult &getDefaultInstance();

private:

    static const ::std::vector< ::vehicle_main_fi_types::T_CAN_Message >& getT_CAN_MessageList_DefaultInstance ();

    inline void set_has_CanMessageList ();

    inline void clear_has_CanMessageList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::vehicle_main_fi_types::T_CAN_Message > _CanMessageList;

};

/**
 * The start message of the method "SetOSPAlertsStatus"
 * OSP Alert and Dangerous area Alert setting to be sent over V-CAN
 * Method Start would be trigered with the current status of OSP and Dangerous Alert Status
 */
class SetOSPAlertsStatusStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetOSPAlertsStatusStart ();

    /**
     * Copy constructor
     */
    inline  SetOSPAlertsStatusStart (const SetOSPAlertsStatusStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetOSPAlertsStatusStart (bool OSPAlert_, bool DangerousAreaAlert_);

    /**
     * Destructor
     */
    inline virtual  ~SetOSPAlertsStatusStart();

    /**
     * Assignment operator
     */
    inline SetOSPAlertsStatusStart& operator = (const SetOSPAlertsStatusStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetOSPAlertsStatusStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetOSPAlertsStatusStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetOSPAlertsStatusStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetOSPAlertsStatusStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "OSPAlert"

    static const int kOSPAlert = 0;

    /**
     * Clears the field "OSPAlert".
     *
     * The field will be set to its default value. The hasOSPAlert()
     * method will return false.
     */
    inline void clearOSPAlert();

    /**
     * Checks whether the field "OSPAlert" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOSPAlert()). Otherwise it will return false.
     */
    inline bool hasOSPAlert () const;

    /**
     * Returns the value of the member "OSPAlert".
     *
     * OSP Alert Setting to be changed to OFF/ON
     *
     * @return The value of the field "OSPAlert"
     */
    inline bool getOSPAlert () const;

    /**
     * Sets the value of the member "OSPAlert".
     *
     * OSP Alert Setting to be changed to OFF/ON
     *
     * @param OSPAlert The value which will be set
     */
    inline void setOSPAlert (bool OSPAlert_);

    // API of field "DangerousAreaAlert"

    static const int kDangerousAreaAlert = 1;

    /**
     * Clears the field "DangerousAreaAlert".
     *
     * The field will be set to its default value. The hasDangerousAreaAlert()
     * method will return false.
     */
    inline void clearDangerousAreaAlert();

    /**
     * Checks whether the field "DangerousAreaAlert" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDangerousAreaAlert()). Otherwise it will return false.
     */
    inline bool hasDangerousAreaAlert () const;

    /**
     * Returns the value of the member "DangerousAreaAlert".
     *
     * Dangerous area Alert setting to be OFF/ON
     *
     * @return The value of the field "DangerousAreaAlert"
     */
    inline bool getDangerousAreaAlert () const;

    /**
     * Sets the value of the member "DangerousAreaAlert".
     *
     * Dangerous area Alert setting to be OFF/ON
     *
     * @param DangerousAreaAlert The value which will be set
     */
    inline void setDangerousAreaAlert (bool DangerousAreaAlert_);

    static const SetOSPAlertsStatusStart &getDefaultInstance();

private:

    inline void set_has_OSPAlert ();

    inline void clear_has_OSPAlert ();

    inline void set_has_DangerousAreaAlert ();

    inline void clear_has_DangerousAreaAlert ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _OSPAlert;

    bool _DangerousAreaAlert;

};

/**
 * The result message of the method "SetOSPAlertsStatus"
 * OSP Alert and Dangerous area Alert setting to be sent over V-CAN
 * CAN Message data is sent successfully or not
 */
class SetOSPAlertsStatusResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetOSPAlertsStatusResult ();

    /**
     * Copy constructor
     */
    inline  SetOSPAlertsStatusResult (const SetOSPAlertsStatusResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetOSPAlertsStatusResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~SetOSPAlertsStatusResult();

    /**
     * Assignment operator
     */
    inline SetOSPAlertsStatusResult& operator = (const SetOSPAlertsStatusResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetOSPAlertsStatusResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetOSPAlertsStatusResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetOSPAlertsStatusResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetOSPAlertsStatusResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Sent over V-CAN success/no success
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Sent over V-CAN success/no success
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const SetOSPAlertsStatusResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The start message of the method "SendMediaInfo"
 * Send Media type and its data
 * Method Start would be trigered with the current data of Media Info
 */
class SendMediaInfoStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendMediaInfoStart ();

    /**
     * Copy constructor
     */
    inline  SendMediaInfoStart (const SendMediaInfoStart &rhs);

    /**
     * All fields constructor
     */
    inline  SendMediaInfoStart (const ::vehicle_main_fi_types::T_CAN_Mesg& MediaInfo_);

    /**
     * Destructor
     */
    inline virtual  ~SendMediaInfoStart();

    /**
     * Assignment operator
     */
    inline SendMediaInfoStart& operator = (const SendMediaInfoStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendMediaInfoStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendMediaInfoStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendMediaInfoStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendMediaInfoStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MediaInfo"

    static const int kMediaInfo = 0;

    /**
     * Clears the field "MediaInfo".
     *
     * The field will be set to its default value. The hasMediaInfo()
     * method will return false.
     */
    inline void clearMediaInfo();

    /**
     * Checks whether the field "MediaInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMediaInfo()). Otherwise it will return false.
     */
    inline bool hasMediaInfo () const;

    /**
     * Returns the value of the member "MediaInfo".
     *
     * Media Info to be sent over CAN
     *
     * @return The value of the field "MediaInfo"
     */
    inline const ::vehicle_main_fi_types::T_CAN_Mesg& getMediaInfo () const;

    /**
     * Retrieves the value of the field "MediaInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "MediaInfo".
     */
    inline ::vehicle_main_fi_types::T_CAN_Mesg& getMediaInfoMutable ();

    /**
     * Sets the value of the member "MediaInfo".
     *
     * Media Info to be sent over CAN
     *
     * @param MediaInfo The value which will be set
     */
    inline void setMediaInfo (const ::vehicle_main_fi_types::T_CAN_Mesg& MediaInfo_);

    static const SendMediaInfoStart &getDefaultInstance();

private:

    inline void set_has_MediaInfo ();

    inline void clear_has_MediaInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::vehicle_main_fi_types::T_CAN_Mesg _MediaInfo;

};

/**
 * The result message of the method "SendMediaInfo"
 * Send Media type and its data
 * CAN Message data is sent successfully or not
 */
class SendMediaInfoResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendMediaInfoResult ();

    /**
     * Copy constructor
     */
    inline  SendMediaInfoResult (const SendMediaInfoResult &rhs);

    /**
     * All fields constructor
     */
    inline  SendMediaInfoResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~SendMediaInfoResult();

    /**
     * Assignment operator
     */
    inline SendMediaInfoResult& operator = (const SendMediaInfoResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendMediaInfoResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendMediaInfoResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendMediaInfoResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendMediaInfoResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Sent over V-CAN success/no success
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Sent over V-CAN success/no success
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const SendMediaInfoResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The start message of the method "SendCallInfo"
 * Send Call type and its data
 * Method Start would be trigered with the current data of Call Info
 */
class SendCallInfoStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendCallInfoStart ();

    /**
     * Copy constructor
     */
    inline  SendCallInfoStart (const SendCallInfoStart &rhs);

    /**
     * All fields constructor
     */
    inline  SendCallInfoStart (const ::vehicle_main_fi_types::T_CAN_Mesg& CallInfo_);

    /**
     * Destructor
     */
    inline virtual  ~SendCallInfoStart();

    /**
     * Assignment operator
     */
    inline SendCallInfoStart& operator = (const SendCallInfoStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendCallInfoStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendCallInfoStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendCallInfoStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendCallInfoStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CallInfo"

    static const int kCallInfo = 0;

    /**
     * Clears the field "CallInfo".
     *
     * The field will be set to its default value. The hasCallInfo()
     * method will return false.
     */
    inline void clearCallInfo();

    /**
     * Checks whether the field "CallInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCallInfo()). Otherwise it will return false.
     */
    inline bool hasCallInfo () const;

    /**
     * Returns the value of the member "CallInfo".
     *
     * Call Info to be sent over CAN
     *
     * @return The value of the field "CallInfo"
     */
    inline const ::vehicle_main_fi_types::T_CAN_Mesg& getCallInfo () const;

    /**
     * Retrieves the value of the field "CallInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CallInfo".
     */
    inline ::vehicle_main_fi_types::T_CAN_Mesg& getCallInfoMutable ();

    /**
     * Sets the value of the member "CallInfo".
     *
     * Call Info to be sent over CAN
     *
     * @param CallInfo The value which will be set
     */
    inline void setCallInfo (const ::vehicle_main_fi_types::T_CAN_Mesg& CallInfo_);

    static const SendCallInfoStart &getDefaultInstance();

private:

    inline void set_has_CallInfo ();

    inline void clear_has_CallInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::vehicle_main_fi_types::T_CAN_Mesg _CallInfo;

};

/**
 * The result message of the method "SendCallInfo"
 * Send Call type and its data
 * CAN Message data is sent successfully or not
 */
class SendCallInfoResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendCallInfoResult ();

    /**
     * Copy constructor
     */
    inline  SendCallInfoResult (const SendCallInfoResult &rhs);

    /**
     * All fields constructor
     */
    inline  SendCallInfoResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~SendCallInfoResult();

    /**
     * Assignment operator
     */
    inline SendCallInfoResult& operator = (const SendCallInfoResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendCallInfoResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendCallInfoResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendCallInfoResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendCallInfoResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Sent over V-CAN success/no success
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Sent over V-CAN success/no success
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const SendCallInfoResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The start message of the method "SendPhoneInfo"
 * Send Phone type and its data
 * Method Start would be trigered with the current data of Phone Info
 */
class SendPhoneInfoStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendPhoneInfoStart ();

    /**
     * Copy constructor
     */
    inline  SendPhoneInfoStart (const SendPhoneInfoStart &rhs);

    /**
     * All fields constructor
     */
    inline  SendPhoneInfoStart (const ::vehicle_main_fi_types::T_CAN_Mesg& PhoneInfo_);

    /**
     * Destructor
     */
    inline virtual  ~SendPhoneInfoStart();

    /**
     * Assignment operator
     */
    inline SendPhoneInfoStart& operator = (const SendPhoneInfoStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendPhoneInfoStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendPhoneInfoStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendPhoneInfoStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendPhoneInfoStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PhoneInfo"

    static const int kPhoneInfo = 0;

    /**
     * Clears the field "PhoneInfo".
     *
     * The field will be set to its default value. The hasPhoneInfo()
     * method will return false.
     */
    inline void clearPhoneInfo();

    /**
     * Checks whether the field "PhoneInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhoneInfo()). Otherwise it will return false.
     */
    inline bool hasPhoneInfo () const;

    /**
     * Returns the value of the member "PhoneInfo".
     *
     * Phone Info to be sent over CAN
     *
     * @return The value of the field "PhoneInfo"
     */
    inline const ::vehicle_main_fi_types::T_CAN_Mesg& getPhoneInfo () const;

    /**
     * Retrieves the value of the field "PhoneInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PhoneInfo".
     */
    inline ::vehicle_main_fi_types::T_CAN_Mesg& getPhoneInfoMutable ();

    /**
     * Sets the value of the member "PhoneInfo".
     *
     * Phone Info to be sent over CAN
     *
     * @param PhoneInfo The value which will be set
     */
    inline void setPhoneInfo (const ::vehicle_main_fi_types::T_CAN_Mesg& PhoneInfo_);

    static const SendPhoneInfoStart &getDefaultInstance();

private:

    inline void set_has_PhoneInfo ();

    inline void clear_has_PhoneInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::vehicle_main_fi_types::T_CAN_Mesg _PhoneInfo;

};

/**
 * The result message of the method "SendPhoneInfo"
 * Send Phone type and its data
 * CAN Message data is sent successfully or not
 */
class SendPhoneInfoResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendPhoneInfoResult ();

    /**
     * Copy constructor
     */
    inline  SendPhoneInfoResult (const SendPhoneInfoResult &rhs);

    /**
     * All fields constructor
     */
    inline  SendPhoneInfoResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~SendPhoneInfoResult();

    /**
     * Assignment operator
     */
    inline SendPhoneInfoResult& operator = (const SendPhoneInfoResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendPhoneInfoResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendPhoneInfoResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendPhoneInfoResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendPhoneInfoResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Sent over V-CAN success/no success
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Sent over V-CAN success/no success
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const SendPhoneInfoResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The start message of the method "SendXMInfo"
 * Send XM type and its data
 * Method Start would be trigered with the current data of XM Info
 */
class SendXMInfoStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendXMInfoStart ();

    /**
     * Copy constructor
     */
    inline  SendXMInfoStart (const SendXMInfoStart &rhs);

    /**
     * All fields constructor
     */
    inline  SendXMInfoStart (const ::vehicle_main_fi_types::T_CAN_Mesg& XMInfo_);

    /**
     * Destructor
     */
    inline virtual  ~SendXMInfoStart();

    /**
     * Assignment operator
     */
    inline SendXMInfoStart& operator = (const SendXMInfoStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendXMInfoStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendXMInfoStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendXMInfoStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendXMInfoStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "XMInfo"

    static const int kXMInfo = 0;

    /**
     * Clears the field "XMInfo".
     *
     * The field will be set to its default value. The hasXMInfo()
     * method will return false.
     */
    inline void clearXMInfo();

    /**
     * Checks whether the field "XMInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setXMInfo()). Otherwise it will return false.
     */
    inline bool hasXMInfo () const;

    /**
     * Returns the value of the member "XMInfo".
     *
     * XM Info to be sent over CAN
     *
     * @return The value of the field "XMInfo"
     */
    inline const ::vehicle_main_fi_types::T_CAN_Mesg& getXMInfo () const;

    /**
     * Retrieves the value of the field "XMInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "XMInfo".
     */
    inline ::vehicle_main_fi_types::T_CAN_Mesg& getXMInfoMutable ();

    /**
     * Sets the value of the member "XMInfo".
     *
     * XM Info to be sent over CAN
     *
     * @param XMInfo The value which will be set
     */
    inline void setXMInfo (const ::vehicle_main_fi_types::T_CAN_Mesg& XMInfo_);

    static const SendXMInfoStart &getDefaultInstance();

private:

    inline void set_has_XMInfo ();

    inline void clear_has_XMInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::vehicle_main_fi_types::T_CAN_Mesg _XMInfo;

};

/**
 * The result message of the method "SendXMInfo"
 * Send XM type and its data
 * CAN Message data is sent successfully or not
 */
class SendXMInfoResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendXMInfoResult ();

    /**
     * Copy constructor
     */
    inline  SendXMInfoResult (const SendXMInfoResult &rhs);

    /**
     * All fields constructor
     */
    inline  SendXMInfoResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~SendXMInfoResult();

    /**
     * Assignment operator
     */
    inline SendXMInfoResult& operator = (const SendXMInfoResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendXMInfoResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendXMInfoResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendXMInfoResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendXMInfoResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Sent over V-CAN success/no success
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Sent over V-CAN success/no success
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const SendXMInfoResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The start message of the method "SendMainlineInfo"
 * Send Mainline type and its data
 * Method Start would be trigered with the current data of Mainline Info
 */
class SendMainlineInfoStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendMainlineInfoStart ();

    /**
     * Copy constructor
     */
    inline  SendMainlineInfoStart (const SendMainlineInfoStart &rhs);

    /**
     * All fields constructor
     */
    inline  SendMainlineInfoStart (const ::vehicle_main_fi_types::T_CAN_Mesg& MainlineInfo_);

    /**
     * Destructor
     */
    inline virtual  ~SendMainlineInfoStart();

    /**
     * Assignment operator
     */
    inline SendMainlineInfoStart& operator = (const SendMainlineInfoStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendMainlineInfoStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendMainlineInfoStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendMainlineInfoStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendMainlineInfoStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MainlineInfo"

    static const int kMainlineInfo = 0;

    /**
     * Clears the field "MainlineInfo".
     *
     * The field will be set to its default value. The hasMainlineInfo()
     * method will return false.
     */
    inline void clearMainlineInfo();

    /**
     * Checks whether the field "MainlineInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMainlineInfo()). Otherwise it will return false.
     */
    inline bool hasMainlineInfo () const;

    /**
     * Returns the value of the member "MainlineInfo".
     *
     * Mainline Info to be sent over CAN
     *
     * @return The value of the field "MainlineInfo"
     */
    inline const ::vehicle_main_fi_types::T_CAN_Mesg& getMainlineInfo () const;

    /**
     * Retrieves the value of the field "MainlineInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "MainlineInfo".
     */
    inline ::vehicle_main_fi_types::T_CAN_Mesg& getMainlineInfoMutable ();

    /**
     * Sets the value of the member "MainlineInfo".
     *
     * Mainline Info to be sent over CAN
     *
     * @param MainlineInfo The value which will be set
     */
    inline void setMainlineInfo (const ::vehicle_main_fi_types::T_CAN_Mesg& MainlineInfo_);

    static const SendMainlineInfoStart &getDefaultInstance();

private:

    inline void set_has_MainlineInfo ();

    inline void clear_has_MainlineInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::vehicle_main_fi_types::T_CAN_Mesg _MainlineInfo;

};

/**
 * The result message of the method "SendMainlineInfo"
 * Send Mainline type and its data
 * CAN Message data is sent successfully or not
 */
class SendMainlineInfoResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendMainlineInfoResult ();

    /**
     * Copy constructor
     */
    inline  SendMainlineInfoResult (const SendMainlineInfoResult &rhs);

    /**
     * All fields constructor
     */
    inline  SendMainlineInfoResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~SendMainlineInfoResult();

    /**
     * Assignment operator
     */
    inline SendMainlineInfoResult& operator = (const SendMainlineInfoResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendMainlineInfoResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendMainlineInfoResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendMainlineInfoResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendMainlineInfoResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Sent over V-CAN success/no success
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Sent over V-CAN success/no success
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const SendMainlineInfoResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The start message of the method "SendCabinAMediaInfo"
 * Send CabinAMedia type and its data
 * Method Start would be trigered with the current data of CabinAMedia Info
 */
class SendCabinAMediaInfoStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendCabinAMediaInfoStart ();

    /**
     * Copy constructor
     */
    inline  SendCabinAMediaInfoStart (const SendCabinAMediaInfoStart &rhs);

    /**
     * All fields constructor
     */
    inline  SendCabinAMediaInfoStart (const ::vehicle_main_fi_types::T_CAN_Mesg& CabinAMediaInfo_);

    /**
     * Destructor
     */
    inline virtual  ~SendCabinAMediaInfoStart();

    /**
     * Assignment operator
     */
    inline SendCabinAMediaInfoStart& operator = (const SendCabinAMediaInfoStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendCabinAMediaInfoStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendCabinAMediaInfoStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendCabinAMediaInfoStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendCabinAMediaInfoStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CabinAMediaInfo"

    static const int kCabinAMediaInfo = 0;

    /**
     * Clears the field "CabinAMediaInfo".
     *
     * The field will be set to its default value. The hasCabinAMediaInfo()
     * method will return false.
     */
    inline void clearCabinAMediaInfo();

    /**
     * Checks whether the field "CabinAMediaInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCabinAMediaInfo()). Otherwise it will return false.
     */
    inline bool hasCabinAMediaInfo () const;

    /**
     * Returns the value of the member "CabinAMediaInfo".
     *
     * CabinAMedia Info to be sent over CAN
     *
     * @return The value of the field "CabinAMediaInfo"
     */
    inline const ::vehicle_main_fi_types::T_CAN_Mesg& getCabinAMediaInfo () const;

    /**
     * Retrieves the value of the field "CabinAMediaInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CabinAMediaInfo".
     */
    inline ::vehicle_main_fi_types::T_CAN_Mesg& getCabinAMediaInfoMutable ();

    /**
     * Sets the value of the member "CabinAMediaInfo".
     *
     * CabinAMedia Info to be sent over CAN
     *
     * @param CabinAMediaInfo The value which will be set
     */
    inline void setCabinAMediaInfo (const ::vehicle_main_fi_types::T_CAN_Mesg& CabinAMediaInfo_);

    static const SendCabinAMediaInfoStart &getDefaultInstance();

private:

    inline void set_has_CabinAMediaInfo ();

    inline void clear_has_CabinAMediaInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::vehicle_main_fi_types::T_CAN_Mesg _CabinAMediaInfo;

};

/**
 * The result message of the method "SendCabinAMediaInfo"
 * Send CabinAMedia type and its data
 * CAN Message data is sent successfully or not
 */
class SendCabinAMediaInfoResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendCabinAMediaInfoResult ();

    /**
     * Copy constructor
     */
    inline  SendCabinAMediaInfoResult (const SendCabinAMediaInfoResult &rhs);

    /**
     * All fields constructor
     */
    inline  SendCabinAMediaInfoResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~SendCabinAMediaInfoResult();

    /**
     * Assignment operator
     */
    inline SendCabinAMediaInfoResult& operator = (const SendCabinAMediaInfoResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendCabinAMediaInfoResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendCabinAMediaInfoResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendCabinAMediaInfoResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendCabinAMediaInfoResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Sent over V-CAN success/no success
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Sent over V-CAN success/no success
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const SendCabinAMediaInfoResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The start message of the method "SendCabinAMainlineInfo"
 * Send CabinAMainline type and its data
 * Method Start would be trigered with the current data of CabinAMainline Info
 */
class SendCabinAMainlineInfoStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendCabinAMainlineInfoStart ();

    /**
     * Copy constructor
     */
    inline  SendCabinAMainlineInfoStart (const SendCabinAMainlineInfoStart &rhs);

    /**
     * All fields constructor
     */
    inline  SendCabinAMainlineInfoStart (const ::vehicle_main_fi_types::T_CAN_Mesg& CabinAMainlineInfo_);

    /**
     * Destructor
     */
    inline virtual  ~SendCabinAMainlineInfoStart();

    /**
     * Assignment operator
     */
    inline SendCabinAMainlineInfoStart& operator = (const SendCabinAMainlineInfoStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendCabinAMainlineInfoStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendCabinAMainlineInfoStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendCabinAMainlineInfoStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendCabinAMainlineInfoStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CabinAMainlineInfo"

    static const int kCabinAMainlineInfo = 0;

    /**
     * Clears the field "CabinAMainlineInfo".
     *
     * The field will be set to its default value. The hasCabinAMainlineInfo()
     * method will return false.
     */
    inline void clearCabinAMainlineInfo();

    /**
     * Checks whether the field "CabinAMainlineInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCabinAMainlineInfo()). Otherwise it will return false.
     */
    inline bool hasCabinAMainlineInfo () const;

    /**
     * Returns the value of the member "CabinAMainlineInfo".
     *
     * CabinAMainline Info to be sent over CAN
     *
     * @return The value of the field "CabinAMainlineInfo"
     */
    inline const ::vehicle_main_fi_types::T_CAN_Mesg& getCabinAMainlineInfo () const;

    /**
     * Retrieves the value of the field "CabinAMainlineInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CabinAMainlineInfo".
     */
    inline ::vehicle_main_fi_types::T_CAN_Mesg& getCabinAMainlineInfoMutable ();

    /**
     * Sets the value of the member "CabinAMainlineInfo".
     *
     * CabinAMainline Info to be sent over CAN
     *
     * @param CabinAMainlineInfo The value which will be set
     */
    inline void setCabinAMainlineInfo (const ::vehicle_main_fi_types::T_CAN_Mesg& CabinAMainlineInfo_);

    static const SendCabinAMainlineInfoStart &getDefaultInstance();

private:

    inline void set_has_CabinAMainlineInfo ();

    inline void clear_has_CabinAMainlineInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::vehicle_main_fi_types::T_CAN_Mesg _CabinAMainlineInfo;

};

/**
 * The result message of the method "SendCabinAMainlineInfo"
 * Send CabinAMainline type and its data
 * CAN Message data is sent successfully or not
 */
class SendCabinAMainlineInfoResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendCabinAMainlineInfoResult ();

    /**
     * Copy constructor
     */
    inline  SendCabinAMainlineInfoResult (const SendCabinAMainlineInfoResult &rhs);

    /**
     * All fields constructor
     */
    inline  SendCabinAMainlineInfoResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~SendCabinAMainlineInfoResult();

    /**
     * Assignment operator
     */
    inline SendCabinAMainlineInfoResult& operator = (const SendCabinAMainlineInfoResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendCabinAMainlineInfoResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendCabinAMainlineInfoResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendCabinAMainlineInfoResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendCabinAMainlineInfoResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Sent over V-CAN success/no success
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Sent over V-CAN success/no success
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const SendCabinAMainlineInfoResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The start message of the method "SendCabinACallInfo"
 * Send CabinACall type and its data
 * Method Start would be trigered with the current data of CabinACall Info
 */
class SendCabinACallInfoStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendCabinACallInfoStart ();

    /**
     * Copy constructor
     */
    inline  SendCabinACallInfoStart (const SendCabinACallInfoStart &rhs);

    /**
     * All fields constructor
     */
    inline  SendCabinACallInfoStart (const ::vehicle_main_fi_types::T_CAN_Mesg& CabinACallInfo_);

    /**
     * Destructor
     */
    inline virtual  ~SendCabinACallInfoStart();

    /**
     * Assignment operator
     */
    inline SendCabinACallInfoStart& operator = (const SendCabinACallInfoStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendCabinACallInfoStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendCabinACallInfoStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendCabinACallInfoStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendCabinACallInfoStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CabinACallInfo"

    static const int kCabinACallInfo = 0;

    /**
     * Clears the field "CabinACallInfo".
     *
     * The field will be set to its default value. The hasCabinACallInfo()
     * method will return false.
     */
    inline void clearCabinACallInfo();

    /**
     * Checks whether the field "CabinACallInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCabinACallInfo()). Otherwise it will return false.
     */
    inline bool hasCabinACallInfo () const;

    /**
     * Returns the value of the member "CabinACallInfo".
     *
     * CabinACall Info to be sent over CAN
     *
     * @return The value of the field "CabinACallInfo"
     */
    inline const ::vehicle_main_fi_types::T_CAN_Mesg& getCabinACallInfo () const;

    /**
     * Retrieves the value of the field "CabinACallInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CabinACallInfo".
     */
    inline ::vehicle_main_fi_types::T_CAN_Mesg& getCabinACallInfoMutable ();

    /**
     * Sets the value of the member "CabinACallInfo".
     *
     * CabinACall Info to be sent over CAN
     *
     * @param CabinACallInfo The value which will be set
     */
    inline void setCabinACallInfo (const ::vehicle_main_fi_types::T_CAN_Mesg& CabinACallInfo_);

    static const SendCabinACallInfoStart &getDefaultInstance();

private:

    inline void set_has_CabinACallInfo ();

    inline void clear_has_CabinACallInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::vehicle_main_fi_types::T_CAN_Mesg _CabinACallInfo;

};

/**
 * The result message of the method "SendCabinACallInfo"
 * Send CabinACall type and its data
 * CAN Message data is sent successfully or not
 */
class SendCabinACallInfoResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendCabinACallInfoResult ();

    /**
     * Copy constructor
     */
    inline  SendCabinACallInfoResult (const SendCabinACallInfoResult &rhs);

    /**
     * All fields constructor
     */
    inline  SendCabinACallInfoResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~SendCabinACallInfoResult();

    /**
     * Assignment operator
     */
    inline SendCabinACallInfoResult& operator = (const SendCabinACallInfoResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendCabinACallInfoResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendCabinACallInfoResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendCabinACallInfoResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendCabinACallInfoResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Sent over V-CAN success/no success
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Sent over V-CAN success/no success
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const SendCabinACallInfoResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The start message of the method "SendCabinAPhoneInfo"
 * Send CabinAPhone type and its data
 * Method Start would be trigered with the current data of CabinAPhone Info
 */
class SendCabinAPhoneInfoStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendCabinAPhoneInfoStart ();

    /**
     * Copy constructor
     */
    inline  SendCabinAPhoneInfoStart (const SendCabinAPhoneInfoStart &rhs);

    /**
     * All fields constructor
     */
    inline  SendCabinAPhoneInfoStart (const ::vehicle_main_fi_types::T_CAN_Mesg& CabinAPhoneInfo_);

    /**
     * Destructor
     */
    inline virtual  ~SendCabinAPhoneInfoStart();

    /**
     * Assignment operator
     */
    inline SendCabinAPhoneInfoStart& operator = (const SendCabinAPhoneInfoStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendCabinAPhoneInfoStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendCabinAPhoneInfoStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendCabinAPhoneInfoStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendCabinAPhoneInfoStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CabinAPhoneInfo"

    static const int kCabinAPhoneInfo = 0;

    /**
     * Clears the field "CabinAPhoneInfo".
     *
     * The field will be set to its default value. The hasCabinAPhoneInfo()
     * method will return false.
     */
    inline void clearCabinAPhoneInfo();

    /**
     * Checks whether the field "CabinAPhoneInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCabinAPhoneInfo()). Otherwise it will return false.
     */
    inline bool hasCabinAPhoneInfo () const;

    /**
     * Returns the value of the member "CabinAPhoneInfo".
     *
     * CabinAPhone Info to be sent over CAN
     *
     * @return The value of the field "CabinAPhoneInfo"
     */
    inline const ::vehicle_main_fi_types::T_CAN_Mesg& getCabinAPhoneInfo () const;

    /**
     * Retrieves the value of the field "CabinAPhoneInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CabinAPhoneInfo".
     */
    inline ::vehicle_main_fi_types::T_CAN_Mesg& getCabinAPhoneInfoMutable ();

    /**
     * Sets the value of the member "CabinAPhoneInfo".
     *
     * CabinAPhone Info to be sent over CAN
     *
     * @param CabinAPhoneInfo The value which will be set
     */
    inline void setCabinAPhoneInfo (const ::vehicle_main_fi_types::T_CAN_Mesg& CabinAPhoneInfo_);

    static const SendCabinAPhoneInfoStart &getDefaultInstance();

private:

    inline void set_has_CabinAPhoneInfo ();

    inline void clear_has_CabinAPhoneInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::vehicle_main_fi_types::T_CAN_Mesg _CabinAPhoneInfo;

};

/**
 * The result message of the method "SendCabinAPhoneInfo"
 * Send CabinAPhone type and its data
 * CAN Message data is sent successfully or not
 */
class SendCabinAPhoneInfoResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendCabinAPhoneInfoResult ();

    /**
     * Copy constructor
     */
    inline  SendCabinAPhoneInfoResult (const SendCabinAPhoneInfoResult &rhs);

    /**
     * All fields constructor
     */
    inline  SendCabinAPhoneInfoResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~SendCabinAPhoneInfoResult();

    /**
     * Assignment operator
     */
    inline SendCabinAPhoneInfoResult& operator = (const SendCabinAPhoneInfoResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendCabinAPhoneInfoResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendCabinAPhoneInfoResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendCabinAPhoneInfoResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendCabinAPhoneInfoResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Sent over V-CAN success/no success
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Sent over V-CAN success/no success
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const SendCabinAPhoneInfoResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The start message of the method "SendCabinAXMInfo"
 * Send CabinAXM type and its data
 * Method Start would be trigered with the current data of CabinAXM Info
 */
class SendCabinAXMInfoStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendCabinAXMInfoStart ();

    /**
     * Copy constructor
     */
    inline  SendCabinAXMInfoStart (const SendCabinAXMInfoStart &rhs);

    /**
     * All fields constructor
     */
    inline  SendCabinAXMInfoStart (const ::vehicle_main_fi_types::T_CAN_Mesg& CabinAXMInfo_);

    /**
     * Destructor
     */
    inline virtual  ~SendCabinAXMInfoStart();

    /**
     * Assignment operator
     */
    inline SendCabinAXMInfoStart& operator = (const SendCabinAXMInfoStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendCabinAXMInfoStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendCabinAXMInfoStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendCabinAXMInfoStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendCabinAXMInfoStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CabinAXMInfo"

    static const int kCabinAXMInfo = 0;

    /**
     * Clears the field "CabinAXMInfo".
     *
     * The field will be set to its default value. The hasCabinAXMInfo()
     * method will return false.
     */
    inline void clearCabinAXMInfo();

    /**
     * Checks whether the field "CabinAXMInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCabinAXMInfo()). Otherwise it will return false.
     */
    inline bool hasCabinAXMInfo () const;

    /**
     * Returns the value of the member "CabinAXMInfo".
     *
     * CabinAXM Info to be sent over CAN
     *
     * @return The value of the field "CabinAXMInfo"
     */
    inline const ::vehicle_main_fi_types::T_CAN_Mesg& getCabinAXMInfo () const;

    /**
     * Retrieves the value of the field "CabinAXMInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CabinAXMInfo".
     */
    inline ::vehicle_main_fi_types::T_CAN_Mesg& getCabinAXMInfoMutable ();

    /**
     * Sets the value of the member "CabinAXMInfo".
     *
     * CabinAXM Info to be sent over CAN
     *
     * @param CabinAXMInfo The value which will be set
     */
    inline void setCabinAXMInfo (const ::vehicle_main_fi_types::T_CAN_Mesg& CabinAXMInfo_);

    static const SendCabinAXMInfoStart &getDefaultInstance();

private:

    inline void set_has_CabinAXMInfo ();

    inline void clear_has_CabinAXMInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::vehicle_main_fi_types::T_CAN_Mesg _CabinAXMInfo;

};

/**
 * The result message of the method "SendCabinAXMInfo"
 * Send CabinAXM type and its data
 * CAN Message data is sent successfully or not
 */
class SendCabinAXMInfoResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendCabinAXMInfoResult ();

    /**
     * Copy constructor
     */
    inline  SendCabinAXMInfoResult (const SendCabinAXMInfoResult &rhs);

    /**
     * All fields constructor
     */
    inline  SendCabinAXMInfoResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~SendCabinAXMInfoResult();

    /**
     * Assignment operator
     */
    inline SendCabinAXMInfoResult& operator = (const SendCabinAXMInfoResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendCabinAXMInfoResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendCabinAXMInfoResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendCabinAXMInfoResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendCabinAXMInfoResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Sent over V-CAN success/no success
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Sent over V-CAN success/no success
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const SendCabinAXMInfoResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The start message of the method "SendNaviCurrentStreetNameInfo"
 * Send NaviCurrentStreetName type and its data
 * Method Start would be trigered with the current data of NaviCurrentStreetName Info
 */
class SendNaviCurrentStreetNameInfoStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendNaviCurrentStreetNameInfoStart ();

    /**
     * Copy constructor
     */
    inline  SendNaviCurrentStreetNameInfoStart (const SendNaviCurrentStreetNameInfoStart &rhs);

    /**
     * All fields constructor
     */
    inline  SendNaviCurrentStreetNameInfoStart (const ::vehicle_main_fi_types::T_CAN_Mesg& NaviCurrentStreetNameInfo_);

    /**
     * Destructor
     */
    inline virtual  ~SendNaviCurrentStreetNameInfoStart();

    /**
     * Assignment operator
     */
    inline SendNaviCurrentStreetNameInfoStart& operator = (const SendNaviCurrentStreetNameInfoStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendNaviCurrentStreetNameInfoStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendNaviCurrentStreetNameInfoStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendNaviCurrentStreetNameInfoStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendNaviCurrentStreetNameInfoStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "NaviCurrentStreetNameInfo"

    static const int kNaviCurrentStreetNameInfo = 0;

    /**
     * Clears the field "NaviCurrentStreetNameInfo".
     *
     * The field will be set to its default value. The hasNaviCurrentStreetNameInfo()
     * method will return false.
     */
    inline void clearNaviCurrentStreetNameInfo();

    /**
     * Checks whether the field "NaviCurrentStreetNameInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNaviCurrentStreetNameInfo()). Otherwise it will return false.
     */
    inline bool hasNaviCurrentStreetNameInfo () const;

    /**
     * Returns the value of the member "NaviCurrentStreetNameInfo".
     *
     * NaviCurrentStreetName Info to be sent over CAN
     *
     * @return The value of the field "NaviCurrentStreetNameInfo"
     */
    inline const ::vehicle_main_fi_types::T_CAN_Mesg& getNaviCurrentStreetNameInfo () const;

    /**
     * Retrieves the value of the field "NaviCurrentStreetNameInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "NaviCurrentStreetNameInfo".
     */
    inline ::vehicle_main_fi_types::T_CAN_Mesg& getNaviCurrentStreetNameInfoMutable ();

    /**
     * Sets the value of the member "NaviCurrentStreetNameInfo".
     *
     * NaviCurrentStreetName Info to be sent over CAN
     *
     * @param NaviCurrentStreetNameInfo The value which will be set
     */
    inline void setNaviCurrentStreetNameInfo (const ::vehicle_main_fi_types::T_CAN_Mesg& NaviCurrentStreetNameInfo_);

    static const SendNaviCurrentStreetNameInfoStart &getDefaultInstance();

private:

    inline void set_has_NaviCurrentStreetNameInfo ();

    inline void clear_has_NaviCurrentStreetNameInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::vehicle_main_fi_types::T_CAN_Mesg _NaviCurrentStreetNameInfo;

};

/**
 * The result message of the method "SendNaviCurrentStreetNameInfo"
 * Send NaviCurrentStreetName type and its data
 * CAN Message data is sent successfully or not
 */
class SendNaviCurrentStreetNameInfoResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendNaviCurrentStreetNameInfoResult ();

    /**
     * Copy constructor
     */
    inline  SendNaviCurrentStreetNameInfoResult (const SendNaviCurrentStreetNameInfoResult &rhs);

    /**
     * All fields constructor
     */
    inline  SendNaviCurrentStreetNameInfoResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~SendNaviCurrentStreetNameInfoResult();

    /**
     * Assignment operator
     */
    inline SendNaviCurrentStreetNameInfoResult& operator = (const SendNaviCurrentStreetNameInfoResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendNaviCurrentStreetNameInfoResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendNaviCurrentStreetNameInfoResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendNaviCurrentStreetNameInfoResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendNaviCurrentStreetNameInfoResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Sent over V-CAN success/no success
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Sent over V-CAN success/no success
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const SendNaviCurrentStreetNameInfoResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The start message of the method "SendNaviTurnToStreetNameInfo"
 * Send NaviTurnToStreetName type and its data
 * Method Start would be trigered with the current data of NaviTurnToStreetName Info
 */
class SendNaviTurnToStreetNameInfoStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendNaviTurnToStreetNameInfoStart ();

    /**
     * Copy constructor
     */
    inline  SendNaviTurnToStreetNameInfoStart (const SendNaviTurnToStreetNameInfoStart &rhs);

    /**
     * All fields constructor
     */
    inline  SendNaviTurnToStreetNameInfoStart (const ::vehicle_main_fi_types::T_CAN_Mesg& NaviTurnToStreetNameInfo_);

    /**
     * Destructor
     */
    inline virtual  ~SendNaviTurnToStreetNameInfoStart();

    /**
     * Assignment operator
     */
    inline SendNaviTurnToStreetNameInfoStart& operator = (const SendNaviTurnToStreetNameInfoStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendNaviTurnToStreetNameInfoStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendNaviTurnToStreetNameInfoStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendNaviTurnToStreetNameInfoStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendNaviTurnToStreetNameInfoStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "NaviTurnToStreetNameInfo"

    static const int kNaviTurnToStreetNameInfo = 0;

    /**
     * Clears the field "NaviTurnToStreetNameInfo".
     *
     * The field will be set to its default value. The hasNaviTurnToStreetNameInfo()
     * method will return false.
     */
    inline void clearNaviTurnToStreetNameInfo();

    /**
     * Checks whether the field "NaviTurnToStreetNameInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNaviTurnToStreetNameInfo()). Otherwise it will return false.
     */
    inline bool hasNaviTurnToStreetNameInfo () const;

    /**
     * Returns the value of the member "NaviTurnToStreetNameInfo".
     *
     * NaviTurnToStreetName Info to be sent over CAN
     *
     * @return The value of the field "NaviTurnToStreetNameInfo"
     */
    inline const ::vehicle_main_fi_types::T_CAN_Mesg& getNaviTurnToStreetNameInfo () const;

    /**
     * Retrieves the value of the field "NaviTurnToStreetNameInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "NaviTurnToStreetNameInfo".
     */
    inline ::vehicle_main_fi_types::T_CAN_Mesg& getNaviTurnToStreetNameInfoMutable ();

    /**
     * Sets the value of the member "NaviTurnToStreetNameInfo".
     *
     * NaviTurnToStreetName Info to be sent over CAN
     *
     * @param NaviTurnToStreetNameInfo The value which will be set
     */
    inline void setNaviTurnToStreetNameInfo (const ::vehicle_main_fi_types::T_CAN_Mesg& NaviTurnToStreetNameInfo_);

    static const SendNaviTurnToStreetNameInfoStart &getDefaultInstance();

private:

    inline void set_has_NaviTurnToStreetNameInfo ();

    inline void clear_has_NaviTurnToStreetNameInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::vehicle_main_fi_types::T_CAN_Mesg _NaviTurnToStreetNameInfo;

};

/**
 * The result message of the method "SendNaviTurnToStreetNameInfo"
 * Send NaviTurnToStreetName type and its data
 * CAN Message data is sent successfully or not
 */
class SendNaviTurnToStreetNameInfoResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendNaviTurnToStreetNameInfoResult ();

    /**
     * Copy constructor
     */
    inline  SendNaviTurnToStreetNameInfoResult (const SendNaviTurnToStreetNameInfoResult &rhs);

    /**
     * All fields constructor
     */
    inline  SendNaviTurnToStreetNameInfoResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~SendNaviTurnToStreetNameInfoResult();

    /**
     * Assignment operator
     */
    inline SendNaviTurnToStreetNameInfoResult& operator = (const SendNaviTurnToStreetNameInfoResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendNaviTurnToStreetNameInfoResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendNaviTurnToStreetNameInfoResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendNaviTurnToStreetNameInfoResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendNaviTurnToStreetNameInfoResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Sent over V-CAN success/no success
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Sent over V-CAN success/no success
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const SendNaviTurnToStreetNameInfoResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The start message of the method "SendNaviDestinationInfo"
 * Send NaviDestination type and its data
 * Method Start would be trigered with the current data of NaviDestination Info
 */
class SendNaviDestinationInfoStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendNaviDestinationInfoStart ();

    /**
     * Copy constructor
     */
    inline  SendNaviDestinationInfoStart (const SendNaviDestinationInfoStart &rhs);

    /**
     * All fields constructor
     */
    inline  SendNaviDestinationInfoStart (const ::vehicle_main_fi_types::T_CAN_Navi_Mesg& NaviDestinationInfo_);

    /**
     * Destructor
     */
    inline virtual  ~SendNaviDestinationInfoStart();

    /**
     * Assignment operator
     */
    inline SendNaviDestinationInfoStart& operator = (const SendNaviDestinationInfoStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendNaviDestinationInfoStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendNaviDestinationInfoStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendNaviDestinationInfoStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendNaviDestinationInfoStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "NaviDestinationInfo"

    static const int kNaviDestinationInfo = 0;

    /**
     * Clears the field "NaviDestinationInfo".
     *
     * The field will be set to its default value. The hasNaviDestinationInfo()
     * method will return false.
     */
    inline void clearNaviDestinationInfo();

    /**
     * Checks whether the field "NaviDestinationInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNaviDestinationInfo()). Otherwise it will return false.
     */
    inline bool hasNaviDestinationInfo () const;

    /**
     * Returns the value of the member "NaviDestinationInfo".
     *
     * NaviDestination Info to be sent over CAN
     *
     * @return The value of the field "NaviDestinationInfo"
     */
    inline const ::vehicle_main_fi_types::T_CAN_Navi_Mesg& getNaviDestinationInfo () const;

    /**
     * Retrieves the value of the field "NaviDestinationInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "NaviDestinationInfo".
     */
    inline ::vehicle_main_fi_types::T_CAN_Navi_Mesg& getNaviDestinationInfoMutable ();

    /**
     * Sets the value of the member "NaviDestinationInfo".
     *
     * NaviDestination Info to be sent over CAN
     *
     * @param NaviDestinationInfo The value which will be set
     */
    inline void setNaviDestinationInfo (const ::vehicle_main_fi_types::T_CAN_Navi_Mesg& NaviDestinationInfo_);

    static const SendNaviDestinationInfoStart &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_NaviDestinationInfo ();

    inline void clear_has_NaviDestinationInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::vehicle_main_fi_types::T_CAN_Navi_Mesg _NaviDestinationInfo;

};

/**
 * The result message of the method "SendNaviDestinationInfo"
 * Send NaviDestination type and its data
 * CAN Message data is sent successfully or not
 */
class SendNaviDestinationInfoResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendNaviDestinationInfoResult ();

    /**
     * Copy constructor
     */
    inline  SendNaviDestinationInfoResult (const SendNaviDestinationInfoResult &rhs);

    /**
     * All fields constructor
     */
    inline  SendNaviDestinationInfoResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~SendNaviDestinationInfoResult();

    /**
     * Assignment operator
     */
    inline SendNaviDestinationInfoResult& operator = (const SendNaviDestinationInfoResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendNaviDestinationInfoResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendNaviDestinationInfoResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendNaviDestinationInfoResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendNaviDestinationInfoResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Sent over V-CAN success/no success
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Sent over V-CAN success/no success
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const SendNaviDestinationInfoResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The start message of the method "SendNaviTurnToSymbolsInfo"
 * Send NaviTurnToSymbols type and its data
 * Method Start would be trigered with the current data of NaviTurnToSymbols Info
 */
class SendNaviTurnToSymbolsInfoStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendNaviTurnToSymbolsInfoStart ();

    /**
     * Copy constructor
     */
    inline  SendNaviTurnToSymbolsInfoStart (const SendNaviTurnToSymbolsInfoStart &rhs);

    /**
     * All fields constructor
     */
    inline  SendNaviTurnToSymbolsInfoStart (const ::vehicle_main_fi_types::T_CAN_Navi_Mesg& NaviTurnToSymbolsInfo_);

    /**
     * Destructor
     */
    inline virtual  ~SendNaviTurnToSymbolsInfoStart();

    /**
     * Assignment operator
     */
    inline SendNaviTurnToSymbolsInfoStart& operator = (const SendNaviTurnToSymbolsInfoStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendNaviTurnToSymbolsInfoStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendNaviTurnToSymbolsInfoStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendNaviTurnToSymbolsInfoStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendNaviTurnToSymbolsInfoStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "NaviTurnToSymbolsInfo"

    static const int kNaviTurnToSymbolsInfo = 0;

    /**
     * Clears the field "NaviTurnToSymbolsInfo".
     *
     * The field will be set to its default value. The hasNaviTurnToSymbolsInfo()
     * method will return false.
     */
    inline void clearNaviTurnToSymbolsInfo();

    /**
     * Checks whether the field "NaviTurnToSymbolsInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNaviTurnToSymbolsInfo()). Otherwise it will return false.
     */
    inline bool hasNaviTurnToSymbolsInfo () const;

    /**
     * Returns the value of the member "NaviTurnToSymbolsInfo".
     *
     * NaviTurnToSymbols Info to be sent over CAN
     *
     * @return The value of the field "NaviTurnToSymbolsInfo"
     */
    inline const ::vehicle_main_fi_types::T_CAN_Navi_Mesg& getNaviTurnToSymbolsInfo () const;

    /**
     * Retrieves the value of the field "NaviTurnToSymbolsInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "NaviTurnToSymbolsInfo".
     */
    inline ::vehicle_main_fi_types::T_CAN_Navi_Mesg& getNaviTurnToSymbolsInfoMutable ();

    /**
     * Sets the value of the member "NaviTurnToSymbolsInfo".
     *
     * NaviTurnToSymbols Info to be sent over CAN
     *
     * @param NaviTurnToSymbolsInfo The value which will be set
     */
    inline void setNaviTurnToSymbolsInfo (const ::vehicle_main_fi_types::T_CAN_Navi_Mesg& NaviTurnToSymbolsInfo_);

    static const SendNaviTurnToSymbolsInfoStart &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_NaviTurnToSymbolsInfo ();

    inline void clear_has_NaviTurnToSymbolsInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::vehicle_main_fi_types::T_CAN_Navi_Mesg _NaviTurnToSymbolsInfo;

};

/**
 * The result message of the method "SendNaviTurnToSymbolsInfo"
 * Send NaviTurnToSymbols type and its data
 * CAN Message data is sent successfully or not
 */
class SendNaviTurnToSymbolsInfoResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendNaviTurnToSymbolsInfoResult ();

    /**
     * Copy constructor
     */
    inline  SendNaviTurnToSymbolsInfoResult (const SendNaviTurnToSymbolsInfoResult &rhs);

    /**
     * All fields constructor
     */
    inline  SendNaviTurnToSymbolsInfoResult (bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~SendNaviTurnToSymbolsInfoResult();

    /**
     * Assignment operator
     */
    inline SendNaviTurnToSymbolsInfoResult& operator = (const SendNaviTurnToSymbolsInfoResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendNaviTurnToSymbolsInfoResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendNaviTurnToSymbolsInfoResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendNaviTurnToSymbolsInfoResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendNaviTurnToSymbolsInfoResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Sent over V-CAN success/no success
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Sent over V-CAN success/no success
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const SendNaviTurnToSymbolsInfoResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Status;

};

/**
 * The start message of the method "SendNaviLaneGuidanceInfo"
 * Send NaviLaneGuidance type and its data
 * Method Start would be trigered with the current data of NaviLaneGuidance Info
 */
class SendNaviLaneGuidanceInfoStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendNaviLaneGuidanceInfoStart ();

    /**
     * Copy constructor
     */
    inline  SendNaviLaneGuidanceInfoStart (const SendNaviLaneGuidanceInfoStart &rhs);

    /**
     * All fields constructor
     */
    inline  SendNaviLaneGuidanceInfoStart (const ::vehicle_main_fi_types::T_CAN_Navi_Mesg& NaviLaneGuidanceInfo_);

    /**
     * Destructor
     */
    inline virtual  ~SendNaviLaneGuidanceInfoStart();

    /**
     * Assignment operator
     */
    inline SendNaviLaneGuidanceInfoStart& operator = (const SendNaviLaneGuidanceInfoStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendNaviLaneGuidanceInfoStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendNaviLaneGuidanceInfoStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendNaviLaneGuidanceInfoStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendNaviLaneGuidanceInfoStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "NaviLaneGuidanceInfo"

    static const int kNaviLaneGuidanceInfo = 0;

    /**
     * Clears the field "NaviLaneGuidanceInfo".
     *
     * The field will be set to its default value. The hasNaviLaneGuidanceInfo()
     * method will return false.
     */
    inline void clearNaviLaneGuidanceInfo();

    /**
     * Checks whether the field "NaviLaneGuidanceInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNaviLaneGuidanceInfo()). Otherwise it will return false.
     */
    inline bool hasNaviLaneGuidanceInfo () const;

    /**
     * Returns the value of the member "NaviLaneGuidanceInfo".
     *
     * NaviLaneGuidance Info to be sent over CAN
     *
     * @return The value of the field "NaviLaneGuidanceInfo"
     */
    inline const ::vehicle_main_fi_types::T_CAN_Navi_Mesg& getNa