/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/stream/json.h"
#include "tuner_main_fi_types.h"
#include "tuner_main_fi_typesConst.h"
#include "tuner_main_fi_typesJson.h"
#include "tuner_main_fi_typesJsonPrivate.h"
#include "yajl/yajl_gen.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

using namespace ::asf::stream::json;


// Json serialization of "T_b8_Tun_AFSwitch"

void serializeJson (const ::tuner_main_fi_types::T_b8_Tun_AFSwitch& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    if (value.getRDS_AFBEST()) {
        yajl_gen_string(g, (const unsigned char*)  "RDS_AFBEST" , 10);
        yajl_gen_bool(g, (bool)value.getRDS_AFBEST());
    }
    if (value.getUnused()) {
        yajl_gen_string(g, (const unsigned char*)  "unused" , 6);
        yajl_gen_bool(g, (bool)value.getUnused());
    }
    if (value.getDRM_AFBEST()) {
        yajl_gen_string(g, (const unsigned char*)  "DRM_AFBEST" , 10);
        yajl_gen_bool(g, (bool)value.getDRM_AFBEST());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_b8_Tun_AFSwitch& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_b8_Tun_AudioSink"

void serializeJson (const ::tuner_main_fi_types::T_b8_Tun_AudioSink& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    if (value.getUSR1_SWITCHED_TUN_TOFG()) {
        yajl_gen_string(g, (const unsigned char*)  "USR1_SWITCHED_TUN_TOFG" , 22);
        yajl_gen_bool(g, (bool)value.getUSR1_SWITCHED_TUN_TOFG());
    }
    if (value.getTA_SWITCHED_TUN_TOFG()) {
        yajl_gen_string(g, (const unsigned char*)  "TA_SWITCHED_TUN_TOFG" , 20);
        yajl_gen_bool(g, (bool)value.getTA_SWITCHED_TUN_TOFG());
    }
    if (value.getTIM_SWITCHED_TUN_TOFG()) {
        yajl_gen_string(g, (const unsigned char*)  "TIM_SWITCHED_TUN_TOFG" , 21);
        yajl_gen_bool(g, (bool)value.getTIM_SWITCHED_TUN_TOFG());
    }
    if (value.getPTY_SWITCHED_TUN_TOFG()) {
        yajl_gen_string(g, (const unsigned char*)  "PTY_SWITCHED_TUN_TOFG" , 21);
        yajl_gen_bool(g, (bool)value.getPTY_SWITCHED_TUN_TOFG());
    }
    if (value.getNEWS_SWITCHED_TUN_TOFG()) {
        yajl_gen_string(g, (const unsigned char*)  "NEWS_SWITCHED_TUN_TOFG" , 22);
        yajl_gen_bool(g, (bool)value.getNEWS_SWITCHED_TUN_TOFG());
    }
    if (value.getDABTEMP_SWITCHED_TUN_TOFG()) {
        yajl_gen_string(g, (const unsigned char*)  "DABTEMP_SWITCHED_TUN_TOFG" , 25);
        yajl_gen_bool(g, (bool)value.getDABTEMP_SWITCHED_TUN_TOFG());
    }
    if (value.getTEMPFM_SWITCHED_TUN_TOFG()) {
        yajl_gen_string(g, (const unsigned char*)  "TEMPFM_SWITCHED_TUN_TOFG" , 24);
        yajl_gen_bool(g, (bool)value.getTEMPFM_SWITCHED_TUN_TOFG());
    }
    if (value.getRESERVED1()) {
        yajl_gen_string(g, (const unsigned char*)  "RESERVED1" , 9);
        yajl_gen_bool(g, (bool)value.getRESERVED1());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_b8_Tun_AudioSink& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_b8_Tun_AtStationInfoBits"

void serializeJson (const ::tuner_main_fi_types::T_b8_Tun_AtStationInfoBits& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    if (value.getMONO_OR_STEREO_BIT()) {
        yajl_gen_string(g, (const unsigned char*)  "MONO_OR_STEREO_BIT" , 18);
        yajl_gen_bool(g, (bool)value.getMONO_OR_STEREO_BIT());
    }
    if (value.getSPEECH_OR_MUSIC_BIT()) {
        yajl_gen_string(g, (const unsigned char*)  "SPEECH_OR_MUSIC_BIT" , 19);
        yajl_gen_bool(g, (bool)value.getSPEECH_OR_MUSIC_BIT());
    }
    if (value.getRADIOTEXT_POSSIBLE_BIT()) {
        yajl_gen_string(g, (const unsigned char*)  "RADIOTEXT_POSSIBLE_BIT" , 22);
        yajl_gen_bool(g, (bool)value.getRADIOTEXT_POSSIBLE_BIT());
    }
    if (value.getALTERNATE_FREQUENCY_BIT()) {
        yajl_gen_string(g, (const unsigned char*)  "ALTERNATE_FREQUENCY_BIT" , 23);
        yajl_gen_bool(g, (bool)value.getALTERNATE_FREQUENCY_BIT());
    }
    if (value.getRADIOTEXT_AVAILABLE_BIT()) {
        yajl_gen_string(g, (const unsigned char*)  "RADIOTEXT_AVAILABLE_BIT" , 23);
        yajl_gen_bool(g, (bool)value.getRADIOTEXT_AVAILABLE_BIT());
    }
    if (value.getAF_AVAILABLE_BIT()) {
        yajl_gen_string(g, (const unsigned char*)  "AF_AVAILABLE_BIT" , 16);
        yajl_gen_bool(g, (bool)value.getAF_AVAILABLE_BIT());
    }
    if (value.getHD_STATION_DIGITAL_OR_ANALOGUE_SERVICE()) {
        yajl_gen_string(g, (const unsigned char*)  "HD_STATION_DIGITAL_OR_ANALOGUE_SERVICE" , 38);
        yajl_gen_bool(g, (bool)value.getHD_STATION_DIGITAL_OR_ANALOGUE_SERVICE());
    }
    if (value.getMONO_OR_STEREO_REPRODUCTION_OF_SIGNAL()) {
        yajl_gen_string(g, (const unsigned char*)  "MONO_OR_STEREO_REPRODUCTION_OF_SIGNAL" , 37);
        yajl_gen_bool(g, (bool)value.getMONO_OR_STEREO_REPRODUCTION_OF_SIGNAL());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_b8_Tun_AtStationInfoBits& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_b8_Tun_Tunerbandbits"

void serializeJson (const ::tuner_main_fi_types::T_b8_Tun_Tunerbandbits& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    if (value.getDDAMASTER_OR_NOT_A_DDAMASTER()) {
        yajl_gen_string(g, (const unsigned char*)  "DDAMASTER_OR_NOT_A_DDAMASTER" , 28);
        yajl_gen_bool(g, (bool)value.getDDAMASTER_OR_NOT_A_DDAMASTER());
    }
    if (value.getDDASLAVE_OR_NOT_A_DDASLAVE()) {
        yajl_gen_string(g, (const unsigned char*)  "DDASLAVE_OR_NOT_A_DDASLAVE" , 26);
        yajl_gen_bool(g, (bool)value.getDDASLAVE_OR_NOT_A_DDASLAVE());
    }
    if (value.getFM_SUPPORTED_OR_FM_NOTSUPPORTED()) {
        yajl_gen_string(g, (const unsigned char*)  "FM_SUPPORTED_OR_FM_NOTSUPPORTED" , 31);
        yajl_gen_bool(g, (bool)value.getFM_SUPPORTED_OR_FM_NOTSUPPORTED());
    }
    if (value.getAM_SUPPORTED_OR_AM_NOTSUPPORTED()) {
        yajl_gen_string(g, (const unsigned char*)  "AM_SUPPORTED_OR_AM_NOTSUPPORTED" , 31);
        yajl_gen_bool(g, (bool)value.getAM_SUPPORTED_OR_AM_NOTSUPPORTED());
    }
    if (value.getDAB3_SUPPORTED_OR_DAB3_NOTSUPPORTED()) {
        yajl_gen_string(g, (const unsigned char*)  "DAB3_SUPPORTED_OR_DAB3_NOTSUPPORTED" , 35);
        yajl_gen_bool(g, (bool)value.getDAB3_SUPPORTED_OR_DAB3_NOTSUPPORTED());
    }
    if (value.getDABL_SUPPORTED_OR_DABL_NOTSUPPORTED()) {
        yajl_gen_string(g, (const unsigned char*)  "DABL_SUPPORTED_OR_DABL_NOTSUPPORTED" , 35);
        yajl_gen_bool(g, (bool)value.getDABL_SUPPORTED_OR_DABL_NOTSUPPORTED());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_b8_Tun_Tunerbandbits& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_Audio_FG_BG"

void serializeJson (const ::tuner_main_fi_types::T_Audio_FG_BG& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8SubCommand()) {
        yajl_gen_string(g, (const unsigned char*)  "u8SubCommand" , 12);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_SubCommand_Name(value.getU8SubCommand());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getU8SubCommand());
    }
    if (!isSparse || value.hasU8AudioSink()) {
        yajl_gen_string(g, (const unsigned char*)  "u8AudioSink" , 11);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_AudioSink_Name(value.getU8AudioSink());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getU8AudioSink());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_Audio_FG_BG& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_u16CalibrationData"

void serializeJson (const ::tuner_main_fi_types::T_u16CalibrationData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8DataLength()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DataLength" , 12);
        yajl_gen_integer(g, (long long)value.getU8DataLength());
    }
    if (!isSparse || value.hasCalibrationValues()) {
        yajl_gen_string(g, (const unsigned char*)  "CalibrationValues" , 17);
        yajl_gen_array_open(g);
        const ::std::vector< uint16 >& o1 = value.getCalibrationValues();
        {
            ::std::vector< uint16 >::const_iterator o0;
            for (o0 = o1.begin(); o0 != o1.end(); ++o0) {
                yajl_gen_integer(g, (long long)(*o0));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_u16CalibrationData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_Aud_FGBG_New"

void serializeJson (const ::tuner_main_fi_types::T_Aud_FGBG_New& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8_TunerHeader()) {
        yajl_gen_string(g, (const unsigned char*)  "u8_TunerHeader" , 14);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_TunerHeader_Name(value.getU8_TunerHeader());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getU8_TunerHeader());
    }
    if (!isSparse || value.hasU8SubCommand()) {
        yajl_gen_string(g, (const unsigned char*)  "u8SubCommand" , 12);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_SubCommand_Name(value.getU8SubCommand());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getU8SubCommand());
    }
    if (!isSparse || value.hasU8AudioSink()) {
        yajl_gen_string(g, (const unsigned char*)  "u8AudioSink" , 11);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_AudioSink_Name(value.getU8AudioSink());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getU8AudioSink());
    }
    if (!isSparse || value.hasBTunerState()) {
        yajl_gen_string(g, (const unsigned char*)  "bTunerState" , 11);
        yajl_gen_bool(g, (bool)value.getBTunerState());
    }
    if (!isSparse || value.hasU8_PhysicalTuner()) {
        yajl_gen_string(g, (const unsigned char*)  "u8_PhysicalTuner" , 16);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_PhysicalTuner_Name(value.getU8_PhysicalTuner());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getU8_PhysicalTuner());
    }
    if (!isSparse || value.hasE8Band()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Band" , 6);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_TunerBand_Name(value.getE8Band());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Band());
    }
    if (!isSparse || value.hasE8MTCAudioSource()) {
        yajl_gen_string(g, (const unsigned char*)  "e8MTCAudioSource" , 16);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_MTCAudioSource_Name(value.getE8MTCAudioSource());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8MTCAudioSource());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_Aud_FGBG_New& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_AudFGBGStatus"

void serializeJson (const ::tuner_main_fi_types::T_AudFGBGStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8_TunerHeader()) {
        yajl_gen_string(g, (const unsigned char*)  "u8_TunerHeader" , 14);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_TunerHeader_Name(value.getU8_TunerHeader());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getU8_TunerHeader());
    }
    if (!isSparse || value.hasU8AudioSink()) {
        yajl_gen_string(g, (const unsigned char*)  "u8AudioSink" , 11);
        serializeJson(value.getU8AudioSink(), g, options);
    }
    if (!isSparse || value.hasE8MTCAudioSource()) {
        yajl_gen_string(g, (const unsigned char*)  "e8MTCAudioSource" , 16);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_MTCAudioSource_Name(value.getE8MTCAudioSource());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8MTCAudioSource());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_AudFGBGStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TunerServer_StatusResponse"

void serializeJson (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8TunerStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "u8TunerStatus" , 13);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_ResponseStatus_Name(value.getU8TunerStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getU8TunerStatus());
    }
    if (!isSparse || value.hasU8TunerState()) {
        yajl_gen_string(g, (const unsigned char*)  "u8TunerState" , 12);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_ResponseState_Name(value.getU8TunerState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getU8TunerState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_b32_Tun_AvailFlags"

void serializeJson (const ::tuner_main_fi_types::T_b32_Tun_AvailFlags& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    if (value.getTUN_FRQ_AVAILABLE()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_FRQ_AVAILABLE" , 17);
        yajl_gen_bool(g, (bool)value.getTUN_FRQ_AVAILABLE());
    }
    if (value.getTUN_PS_AVAILABLE()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_PS_AVAILABLE" , 16);
        yajl_gen_bool(g, (bool)value.getTUN_PS_AVAILABLE());
    }
    if (value.getTUN_PI_AVAILABLE()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_PI_AVAILABLE" , 16);
        yajl_gen_bool(g, (bool)value.getTUN_PI_AVAILABLE());
    }
    if (value.getTUN_PTY_AVAILABLE()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_PTY_AVAILABLE" , 17);
        yajl_gen_bool(g, (bool)value.getTUN_PTY_AVAILABLE());
    }
    if (value.getTUN_CT_AVAILABLE()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_CT_AVAILABLE" , 16);
        yajl_gen_bool(g, (bool)value.getTUN_CT_AVAILABLE());
    }
    if (value.getTUN_TMC_AVAILABLE()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_TMC_AVAILABLE" , 17);
        yajl_gen_bool(g, (bool)value.getTUN_TMC_AVAILABLE());
    }
    if (value.getTUN_RDS_AVAILABLE()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_RDS_AVAILABLE" , 17);
        yajl_gen_bool(g, (bool)value.getTUN_RDS_AVAILABLE());
    }
    if (value.getTUN_REG_AVAILABLE()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_REG_AVAILABLE" , 17);
        yajl_gen_bool(g, (bool)value.getTUN_REG_AVAILABLE());
    }
    if (value.getTUN_AF_AVAILABLE()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_AF_AVAILABLE" , 16);
        yajl_gen_bool(g, (bool)value.getTUN_AF_AVAILABLE());
    }
    if (value.getTUN_PTY_EON_AVAILABLE()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_PTY_EON_AVAILABLE" , 21);
        yajl_gen_bool(g, (bool)value.getTUN_PTY_EON_AVAILABLE());
    }
    if (value.getTUN_RT_AVAILABLE()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_RT_AVAILABLE" , 16);
        yajl_gen_bool(g, (bool)value.getTUN_RT_AVAILABLE());
    }
    if (value.getTUN_JAPAN_PS_AVAILABLE()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_JAPAN_PS_AVAILABLE" , 22);
        yajl_gen_bool(g, (bool)value.getTUN_JAPAN_PS_AVAILABLE());
    }
    if (value.getTUN_AUTO_COMPARE_AVAILABLE()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_AUTO_COMPARE_AVAILABLE" , 26);
        yajl_gen_bool(g, (bool)value.getTUN_AUTO_COMPARE_AVAILABLE());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_b32_Tun_AvailFlags& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_b32_Tun_Features"

void serializeJson (const ::tuner_main_fi_types::T_b32_Tun_Features& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    if (value.getTUN_FEATURE_AF_MODE()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_FEATURE_AF_MODE" , 19);
        yajl_gen_bool(g, (bool)value.getTUN_FEATURE_AF_MODE());
    }
    if (value.getTUN_FEATURE_CT_MODE()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_FEATURE_CT_MODE" , 19);
        yajl_gen_bool(g, (bool)value.getTUN_FEATURE_CT_MODE());
    }
    if (value.getTUN_FEATURE_LOC_MODE()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_FEATURE_LOC_MODE" , 20);
        yajl_gen_bool(g, (bool)value.getTUN_FEATURE_LOC_MODE());
    }
    if (value.getTUN_FEATURE_unused()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_FEATURE_unused" , 18);
        yajl_gen_bool(g, (bool)value.getTUN_FEATURE_unused());
    }
    if (value.getTUN_FEATURE_MONO_MODE()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_FEATURE_MONO_MODE" , 21);
        yajl_gen_bool(g, (bool)value.getTUN_FEATURE_MONO_MODE());
    }
    if (value.getTUN_FEATURE_PSFIX_MODE()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_FEATURE_PSFIX_MODE" , 22);
        yajl_gen_bool(g, (bool)value.getTUN_FEATURE_PSFIX_MODE());
    }
    if (value.getTUN_FEATURE_REG_MODE()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_FEATURE_REG_MODE" , 20);
        yajl_gen_bool(g, (bool)value.getTUN_FEATURE_REG_MODE());
    }
    if (value.getTUN_FEATURE_RT_MODE()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_FEATURE_RT_MODE" , 19);
        yajl_gen_bool(g, (bool)value.getTUN_FEATURE_RT_MODE());
    }
    if (value.getTUN_FEATURE_SEARCH_MODE()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_FEATURE_SEARCH_MODE" , 23);
        yajl_gen_bool(g, (bool)value.getTUN_FEATURE_SEARCH_MODE());
    }
    if (value.getTUN_FEATURE_SEEK_SENSE_MODE()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_FEATURE_SEEK_SENSE_MODE" , 27);
        yajl_gen_bool(g, (bool)value.getTUN_FEATURE_SEEK_SENSE_MODE());
    }
    if (value.getTUN_FEATURE_SHARX_MODE()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_FEATURE_SHARX_MODE" , 22);
        yajl_gen_bool(g, (bool)value.getTUN_FEATURE_SHARX_MODE());
    }
    if (value.getTUN_FEATURE_TM_DATA_MODE()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_FEATURE_TM_DATA_MODE" , 24);
        yajl_gen_bool(g, (bool)value.getTUN_FEATURE_TM_DATA_MODE());
    }
    if (value.getTUN_FEATURE_TMC_MODE()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_FEATURE_TMC_MODE" , 20);
        yajl_gen_bool(g, (bool)value.getTUN_FEATURE_TMC_MODE());
    }
    if (value.getTUN_FEATURE_KHZ50_MODE()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_FEATURE_KHZ50_MODE" , 22);
        yajl_gen_bool(g, (bool)value.getTUN_FEATURE_KHZ50_MODE());
    }
    if (value.getTUN_FEATURE_REG_AUTO_MODE()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_FEATURE_REG_AUTO_MODE" , 25);
        yajl_gen_bool(g, (bool)value.getTUN_FEATURE_REG_AUTO_MODE());
    }
    if (value.getTUN_FEATURE_NEWS_MODE()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_FEATURE_NEWS_MODE" , 21);
        yajl_gen_bool(g, (bool)value.getTUN_FEATURE_NEWS_MODE());
    }
    if (value.getTUN_FEATURE_RDS_AUTO_MODE()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_FEATURE_RDS_AUTO_MODE" , 25);
        yajl_gen_bool(g, (bool)value.getTUN_FEATURE_RDS_AUTO_MODE());
    }
    if (value.getTUN_FEATURE_DDA_MODE()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_FEATURE_DDA_MODE" , 20);
        yajl_gen_bool(g, (bool)value.getTUN_FEATURE_DDA_MODE());
    }
    if (value.getTUN_FEATURE_DDS_MODE()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_FEATURE_DDS_MODE" , 20);
        yajl_gen_bool(g, (bool)value.getTUN_FEATURE_DDS_MODE());
    }
    if (value.getTUN_FEATURE_reserved()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_FEATURE_reserved" , 20);
        yajl_gen_bool(g, (bool)value.getTUN_FEATURE_reserved());
    }
    if (value.getTUN_FEATURE_MEASURE_MODE()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_FEATURE_MEASURE_MODE" , 24);
        yajl_gen_bool(g, (bool)value.getTUN_FEATURE_MEASURE_MODE());
    }
    if (value.getTUN_FEATURE_AMFMSETUP_MODE()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_FEATURE_AMFMSETUP_MODE" , 26);
        yajl_gen_bool(g, (bool)value.getTUN_FEATURE_AMFMSETUP_MODE());
    }
    if (value.getTUN_FEATURE_PERSISTENTSTORAGE_MODE()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_FEATURE_PERSISTENTSTORAGE_MODE" , 34);
        yajl_gen_bool(g, (bool)value.getTUN_FEATURE_PERSISTENTSTORAGE_MODE());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_b32_Tun_Features& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_b8_Tun_Antenna"

void serializeJson (const ::tuner_main_fi_types::T_b8_Tun_Antenna& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    if (value.getTUNER_ANTENNA1()) {
        yajl_gen_string(g, (const unsigned char*)  "TUNER_ANTENNA1" , 14);
        yajl_gen_bool(g, (bool)value.getTUNER_ANTENNA1());
    }
    if (value.getTUNER_ANTENNA2()) {
        yajl_gen_string(g, (const unsigned char*)  "TUNER_ANTENNA2" , 14);
        yajl_gen_bool(g, (bool)value.getTUNER_ANTENNA2());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_b8_Tun_Antenna& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TunerStationData"

void serializeJson (const ::tuner_main_fi_types::T_TunerStationData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8TunerHeader()) {
        yajl_gen_string(g, (const unsigned char*)  "u8TunerHeader" , 13);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_TunerHeader_Name(value.getU8TunerHeader());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getU8TunerHeader());
    }
    if (!isSparse || value.hasU8PTY()) {
        yajl_gen_string(g, (const unsigned char*)  "u8PTY" , 5);
        yajl_gen_integer(g, (long long)value.getU8PTY());
    }
    if (!isSparse || value.hasU16PackedInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "u16PackedInfo" , 13);
        yajl_gen_integer(g, (long long)value.getU16PackedInfo());
    }
    if (!isSparse || value.hasU32AvailFlags()) {
        yajl_gen_string(g, (const unsigned char*)  "u32AvailFlags" , 13);
        serializeJson(value.getU32AvailFlags(), g, options);
    }
    if (!isSparse || value.hasU32Frequency()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Frequency" , 12);
        yajl_gen_integer(g, (long long)value.getU32Frequency());
    }
    if (!isSparse || value.hasU32PI()) {
        yajl_gen_string(g, (const unsigned char*)  "u32PI" , 5);
        yajl_gen_integer(g, (long long)value.getU32PI());
    }
    if (!isSparse || value.hasU8PSName1()) {
        yajl_gen_string(g, (const unsigned char*)  "u8PSName1" , 9);
        yajl_gen_integer(g, (long long)value.getU8PSName1());
    }
    if (!isSparse || value.hasU8PSName2()) {
        yajl_gen_string(g, (const unsigned char*)  "u8PSName2" , 9);
        yajl_gen_integer(g, (long long)value.getU8PSName2());
    }
    if (!isSparse || value.hasU8PSName3()) {
        yajl_gen_string(g, (const unsigned char*)  "u8PSName3" , 9);
        yajl_gen_integer(g, (long long)value.getU8PSName3());
    }
    if (!isSparse || value.hasU8PSName4()) {
        yajl_gen_string(g, (const unsigned char*)  "u8PSName4" , 9);
        yajl_gen_integer(g, (long long)value.getU8PSName4());
    }
    if (!isSparse || value.hasU8PSName5()) {
        yajl_gen_string(g, (const unsigned char*)  "u8PSName5" , 9);
        yajl_gen_integer(g, (long long)value.getU8PSName5());
    }
    if (!isSparse || value.hasU8PSName6()) {
        yajl_gen_string(g, (const unsigned char*)  "u8PSName6" , 9);
        yajl_gen_integer(g, (long long)value.getU8PSName6());
    }
    if (!isSparse || value.hasU8PSName7()) {
        yajl_gen_string(g, (const unsigned char*)  "u8PSName7" , 9);
        yajl_gen_integer(g, (long long)value.getU8PSName7());
    }
    if (!isSparse || value.hasU8PSName8()) {
        yajl_gen_string(g, (const unsigned char*)  "u8PSName8" , 9);
        yajl_gen_integer(g, (long long)value.getU8PSName8());
    }
    if (!isSparse || value.hasSPSName()) {
        yajl_gen_string(g, (const unsigned char*)  "sPSName" , 7);
        const char *s = value.getSPSName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_TunerStationData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TunerFeature"

void serializeJson (const ::tuner_main_fi_types::T_TunerFeature& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasB32Features()) {
        yajl_gen_string(g, (const unsigned char*)  "b32Features" , 11);
        serializeJson(value.getB32Features(), g, options);
    }
    if (!isSparse || value.hasB32MaskFeatures()) {
        yajl_gen_string(g, (const unsigned char*)  "b32MaskFeatures" , 15);
        serializeJson(value.getB32MaskFeatures(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_TunerFeature& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_b32_Tun_AvailableFlags"

void serializeJson (const ::tuner_main_fi_types::T_b32_Tun_AvailableFlags& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    if (value.getTUN_AVAILABLE_FLAGS_FRQ_AVAILABLE()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_AVAILABLE_FLAGS_FRQ_AVAILABLE" , 33);
        yajl_gen_bool(g, (bool)value.getTUN_AVAILABLE_FLAGS_FRQ_AVAILABLE());
    }
    if (value.getTUN_AVAILABLE_FLAGS_reserved()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_AVAILABLE_FLAGS_reserved" , 28);
        yajl_gen_bool(g, (bool)value.getTUN_AVAILABLE_FLAGS_reserved());
    }
    if (value.getTUN_AVAILABLE_FLAGS_PS_AVAILABLE()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_AVAILABLE_FLAGS_PS_AVAILABLE" , 32);
        yajl_gen_bool(g, (bool)value.getTUN_AVAILABLE_FLAGS_PS_AVAILABLE());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_b32_Tun_AvailableFlags& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TunerManualSingleStep"

void serializeJson (const ::tuner_main_fi_types::T_TunerManualSingleStep& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasManualFreqAdjustment()) {
        yajl_gen_string(g, (const unsigned char*)  "ManualFreqAdjustment" , 20);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_ManualFreqAdjustment_Name(value.getManualFreqAdjustment());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getManualFreqAdjustment());
    }
    if (!isSparse || value.hasU8NumberOfTicks()) {
        yajl_gen_string(g, (const unsigned char*)  "u8NumberOfTicks" , 15);
        yajl_gen_integer(g, (long long)value.getU8NumberOfTicks());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_TunerManualSingleStep& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_b8_Tun_OperationFlags"

void serializeJson (const ::tuner_main_fi_types::T_b8_Tun_OperationFlags& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    if (value.getTUN_OPERATION_AFBEST()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_OPERATION_AFBEST" , 20);
        yajl_gen_bool(g, (bool)value.getTUN_OPERATION_AFBEST());
    }
    if (value.getTUN_OPERATION_PTY()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_OPERATION_PTY" , 17);
        yajl_gen_bool(g, (bool)value.getTUN_OPERATION_PTY());
    }
    if (value.getTUN_OPERATION_SEARCH()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_OPERATION_SEARCH" , 20);
        yajl_gen_bool(g, (bool)value.getTUN_OPERATION_SEARCH());
    }
    if (value.getTUN_OPERATION_TA()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_OPERATION_TA" , 16);
        yajl_gen_bool(g, (bool)value.getTUN_OPERATION_TA());
    }
    if (value.getTUN_OPERATION_TPSEEK()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_OPERATION_TPSEEK" , 20);
        yajl_gen_bool(g, (bool)value.getTUN_OPERATION_TPSEEK());
    }
    if (value.getTUN_OPERATION_ACTION()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_OPERATION_ACTION" , 20);
        yajl_gen_bool(g, (bool)value.getTUN_OPERATION_ACTION());
    }
    if (value.getTUN_OPERATION_SEEK_LEVEL_LOGIC()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_OPERATION_SEEK_LEVEL_LOGIC" , 30);
        yajl_gen_bool(g, (bool)value.getTUN_OPERATION_SEEK_LEVEL_LOGIC());
    }
    if (value.getTUN_OPERATION_reserved()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_OPERATION_reserved" , 22);
        yajl_gen_bool(g, (bool)value.getTUN_OPERATION_reserved());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_b8_Tun_OperationFlags& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TunerOperation"

void serializeJson (const ::tuner_main_fi_types::T_TunerOperation& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8EnableOrDisable()) {
        yajl_gen_string(g, (const unsigned char*)  "u8EnableOrDisable" , 17);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_EnableOrDisable_Name(value.getU8EnableOrDisable());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getU8EnableOrDisable());
    }
    if (!isSparse || value.hasU8OperationFlags()) {
        yajl_gen_string(g, (const unsigned char*)  "u8OperationFlags" , 16);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_OperationFlags_Name(value.getU8OperationFlags());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getU8OperationFlags());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_TunerOperation& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TunerAFList"

void serializeJson (const ::tuner_main_fi_types::T_TunerAFList& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8TunerHeader()) {
        yajl_gen_string(g, (const unsigned char*)  "u8TunerHeader" , 13);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_TunerHeader_Name(value.getU8TunerHeader());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getU8TunerHeader());
    }
    if (!isSparse || value.hasU8AFListElementID()) {
        yajl_gen_string(g, (const unsigned char*)  "u8AFListElementID" , 17);
        yajl_gen_integer(g, (long long)value.getU8AFListElementID());
    }
    if (!isSparse || value.hasU32AFFrequency()) {
        yajl_gen_string(g, (const unsigned char*)  "u32AFFrequency" , 14);
        yajl_gen_integer(g, (long long)value.getU32AFFrequency());
    }
    if (!isSparse || value.hasU8AFQualityLevel()) {
        yajl_gen_string(g, (const unsigned char*)  "u8AFQualityLevel" , 16);
        yajl_gen_integer(g, (long long)value.getU8AFQualityLevel());
    }
    if (!isSparse || value.hasU8AFFieldStrength()) {
        yajl_gen_string(g, (const unsigned char*)  "u8AFFieldStrength" , 17);
        yajl_gen_integer(g, (long long)value.getU8AFFieldStrength());
    }
    if (!isSparse || value.hasU8AFBitErrorRate()) {
        yajl_gen_string(g, (const unsigned char*)  "u8AFBitErrorRate" , 16);
        yajl_gen_integer(g, (long long)value.getU8AFBitErrorRate());
    }
    if (!isSparse || value.hasU8AFInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "u8AFInfo" , 8);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_AFInformation_Name(value.getU8AFInfo());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getU8AFInfo());
    }
    if (!isSparse || value.hasU16AFPI()) {
        yajl_gen_string(g, (const unsigned char*)  "u16AFPI" , 7);
        yajl_gen_integer(g, (long long)value.getU16AFPI());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_TunerAFList& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_b8_Tun_TestmodeBits"

void serializeJson (const ::tuner_main_fi_types::T_b8_Tun_TestmodeBits& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    if (value.getTUN_TP_BIT()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_TP_BIT" , 10);
        yajl_gen_bool(g, (bool)value.getTUN_TP_BIT());
    }
    if (value.getTUN_TA_BIT()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_TA_BIT" , 10);
        yajl_gen_bool(g, (bool)value.getTUN_TA_BIT());
    }
    if (value.getTUN_TMC_BIT()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_TMC_BIT" , 11);
        yajl_gen_bool(g, (bool)value.getTUN_TMC_BIT());
    }
    if (value.getTUN_UNUSED_BIT()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_UNUSED_BIT" , 14);
        yajl_gen_bool(g, (bool)value.getTUN_UNUSED_BIT());
    }
    if (value.getTUN_AUDIO_TUNER_BIT()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_AUDIO_TUNER_BIT" , 19);
        yajl_gen_bool(g, (bool)value.getTUN_AUDIO_TUNER_BIT());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_b8_Tun_TestmodeBits& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TunerTestModeData"

void serializeJson (const ::tuner_main_fi_types::T_TunerTestModeData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8TunerHeader()) {
        yajl_gen_string(g, (const unsigned char*)  "u8TunerHeader" , 13);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_TunerHeader_Name(value.getU8TunerHeader());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getU8TunerHeader());
    }
    if (!isSparse || value.hasU8AdditionalInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "u8AdditionalInfo" , 16);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_AdditionalInfo_Name(value.getU8AdditionalInfo());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getU8AdditionalInfo());
    }
    if (!isSparse || value.hasU32AFFrequency()) {
        yajl_gen_string(g, (const unsigned char*)  "u32AFFrequency" , 14);
        yajl_gen_integer(g, (long long)value.getU32AFFrequency());
    }
    if (!isSparse || value.hasU32PI()) {
        yajl_gen_string(g, (const unsigned char*)  "u32PI" , 5);
        yajl_gen_integer(g, (long long)value.getU32PI());
    }
    if (!isSparse || value.hasU8Quality()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Quality" , 9);
        yajl_gen_integer(g, (long long)value.getU8Quality());
    }
    if (!isSparse || value.hasU8Fieldstrength()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Fieldstrength" , 15);
        yajl_gen_integer(g, (long long)value.getU8Fieldstrength());
    }
    if (!isSparse || value.hasU8Multipath()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Multipath" , 11);
        yajl_gen_integer(g, (long long)value.getU8Multipath());
    }
    if (!isSparse || value.hasU8Neighbour()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Neighbour" , 11);
        yajl_gen_integer(g, (long long)value.getU8Neighbour());
    }
    if (!isSparse || value.hasU8AFListLength()) {
        yajl_gen_string(g, (const unsigned char*)  "u8AFListLength" , 14);
        yajl_gen_integer(g, (long long)value.getU8AFListLength());
    }
    if (!isSparse || value.hasU8TestmodeBits()) {
        yajl_gen_string(g, (const unsigned char*)  "u8TestmodeBits" , 14);
        serializeJson(value.getU8TestmodeBits(), g, options);
    }
    if (!isSparse || value.hasU8TMCStationCount()) {
        yajl_gen_string(g, (const unsigned char*)  "u8TMCStationCount" , 17);
        yajl_gen_integer(g, (long long)value.getU8TMCStationCount());
    }
    if (!isSparse || value.hasU8TMCGroupState()) {
        yajl_gen_string(g, (const unsigned char*)  "u8TMCGroupState" , 15);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_TMCGroupState_Name(value.getU8TMCGroupState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getU8TMCGroupState());
    }
    if (!isSparse || value.hasU8AntennaState()) {
        yajl_gen_string(g, (const unsigned char*)  "u8AntennaState" , 14);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_AntennaState_Name(value.getU8AntennaState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getU8AntennaState());
    }
    if (!isSparse || value.hasU8PSName1()) {
        yajl_gen_string(g, (const unsigned char*)  "u8PSName1" , 9);
        yajl_gen_integer(g, (long long)value.getU8PSName1());
    }
    if (!isSparse || value.hasU8PSName2()) {
        yajl_gen_string(g, (const unsigned char*)  "u8PSName2" , 9);
        yajl_gen_integer(g, (long long)value.getU8PSName2());
    }
    if (!isSparse || value.hasU8PSName3()) {
        yajl_gen_string(g, (const unsigned char*)  "u8PSName3" , 9);
        yajl_gen_integer(g, (long long)value.getU8PSName3());
    }
    if (!isSparse || value.hasU8PSName4()) {
        yajl_gen_string(g, (const unsigned char*)  "u8PSName4" , 9);
        yajl_gen_integer(g, (long long)value.getU8PSName4());
    }
    if (!isSparse || value.hasU8PSName5()) {
        yajl_gen_string(g, (const unsigned char*)  "u8PSName5" , 9);
        yajl_gen_integer(g, (long long)value.getU8PSName5());
    }
    if (!isSparse || value.hasU8PSName6()) {
        yajl_gen_string(g, (const unsigned char*)  "u8PSName6" , 9);
        yajl_gen_integer(g, (long long)value.getU8PSName6());
    }
    if (!isSparse || value.hasU8PSName7()) {
        yajl_gen_string(g, (const unsigned char*)  "u8PSName7" , 9);
        yajl_gen_integer(g, (long long)value.getU8PSName7());
    }
    if (!isSparse || value.hasU8PSName8()) {
        yajl_gen_string(g, (const unsigned char*)  "u8PSName8" , 9);
        yajl_gen_integer(g, (long long)value.getU8PSName8());
    }
    if (!isSparse || value.hasSPSName()) {
        yajl_gen_string(g, (const unsigned char*)  "sPSName" , 7);
        const char *s = value.getSPSName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU8IFState()) {
        yajl_gen_string(g, (const unsigned char*)  "u8IFState" , 9);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_IfState_Name(value.getU8IFState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getU8IFState());
    }
    if (!isSparse || value.hasU8ChannelSeparation()) {
        yajl_gen_string(g, (const unsigned char*)  "u8ChannelSeparation" , 19);
        yajl_gen_integer(g, (long long)value.getU8ChannelSeparation());
    }
    if (!isSparse || value.hasU8Hub()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Hub" , 5);
        yajl_gen_integer(g, (long long)value.getU8Hub());
    }
    if (!isSparse || value.hasU8RdsErrorRate()) {
        yajl_gen_string(g, (const unsigned char*)  "u8RdsErrorRate" , 14);
        yajl_gen_integer(g, (long long)value.getU8RdsErrorRate());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_TunerTestModeData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_Sel_List_Elem"

void serializeJson (const ::tuner_main_fi_types::T_Sel_List_Elem& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8TunerHeader()) {
        yajl_gen_string(g, (const unsigned char*)  "u8TunerHeader" , 13);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_TunerHeader_Name(value.getU8TunerHeader());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getU8TunerHeader());
    }
    if (!isSparse || value.hasEConfigListID()) {
        yajl_gen_string(g, (const unsigned char*)  "eConfigListID" , 13);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_ConfigListID_Name(value.getEConfigListID());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEConfigListID());
    }
    if (!isSparse || value.hasU32Frequency()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Frequency" , 12);
        yajl_gen_integer(g, (long long)value.getU32Frequency());
    }
    if (!isSparse || value.hasU16PICode()) {
        yajl_gen_string(g, (const unsigned char*)  "u16PICode" , 9);
        yajl_gen_integer(g, (long long)value.getU16PICode());
    }
    if (!isSparse || value.hasU8ListElementID()) {
        yajl_gen_string(g, (const unsigned char*)  "u8ListElementID" , 15);
        yajl_gen_integer(g, (long long)value.getU8ListElementID());
    }
    if (!isSparse || value.hasU8Listtype()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Listtype" , 10);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_ListType_Name(value.getU8Listtype());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getU8Listtype());
    }
    if (!isSparse || value.hasU32HDStnID_DRMSrvID()) {
        yajl_gen_string(g, (const unsigned char*)  "u32HDStnID_DRMSrvID" , 19);
        yajl_gen_integer(g, (long long)value.getU32HDStnID_DRMSrvID());
    }
    if (!isSparse || value.hasE8ModulationType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ModulationType" , 16);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_ModulationType_Name(value.getE8ModulationType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ModulationType());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_Sel_List_Elem& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_Tun_MakeConfigList"

void serializeJson (const ::tuner_main_fi_types::T_Tun_MakeConfigList& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasEConfigListID()) {
        yajl_gen_string(g, (const unsigned char*)  "eConfigListID" , 13);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_ConfigListID_Name(value.getEConfigListID());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEConfigListID());
    }
    if (!isSparse || value.hasU32PTY()) {
        yajl_gen_string(g, (const unsigned char*)  "u32PTY" , 6);
        yajl_gen_integer(g, (long long)value.getU32PTY());
    }
    if (!isSparse || value.hasESortingCriteria()) {
        yajl_gen_string(g, (const unsigned char*)  "eSortingCriteria" , 16);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_SortingCriteria_Name(value.getESortingCriteria());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getESortingCriteria());
    }
    if (!isSparse || value.hasU8DigitalFilters()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DigitalFilters" , 16);
        serializeJson(value.getU8DigitalFilters(), g, options);
    }
    if (!isSparse || value.hasBFrozenList()) {
        yajl_gen_string(g, (const unsigned char*)  "bFrozenList" , 11);
        yajl_gen_bool(g, (bool)value.getBFrozenList());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_Tun_MakeConfigList& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_b8_Tun_Digital_Filters"

void serializeJson (const ::tuner_main_fi_types::T_b8_Tun_Digital_Filters& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    if (value.getSTATIONLIST_WITHONLY_HDMPS()) {
        yajl_gen_string(g, (const unsigned char*)  "STATIONLIST_WITHONLY_HDMPS" , 26);
        yajl_gen_bool(g, (bool)value.getSTATIONLIST_WITHONLY_HDMPS());
    }
    if (value.getSTATIONLIST_WITH_HDMPS_SPS()) {
        yajl_gen_string(g, (const unsigned char*)  "STATIONLIST_WITH_HDMPS_SPS" , 26);
        yajl_gen_bool(g, (bool)value.getSTATIONLIST_WITH_HDMPS_SPS());
    }
    if (value.getSTATIONLIST_WITH_DRM()) {
        yajl_gen_string(g, (const unsigned char*)  "STATIONLIST_WITH_DRM" , 20);
        yajl_gen_bool(g, (bool)value.getSTATIONLIST_WITH_DRM());
    }
    if (value.getRESERVED_1()) {
        yajl_gen_string(g, (const unsigned char*)  "RESERVED_1" , 10);
        yajl_gen_bool(g, (bool)value.getRESERVED_1());
    }
    if (value.getRESERVED_2()) {
        yajl_gen_string(g, (const unsigned char*)  "RESERVED_2" , 10);
        yajl_gen_bool(g, (bool)value.getRESERVED_2());
    }
    if (value.getRESERVED_3()) {
        yajl_gen_string(g, (const unsigned char*)  "RESERVED_3" , 10);
        yajl_gen_bool(g, (bool)value.getRESERVED_3());
    }
    if (value.getRESERVED_4()) {
        yajl_gen_string(g, (const unsigned char*)  "RESERVED_4" , 10);
        yajl_gen_bool(g, (bool)value.getRESERVED_4());
    }
    if (value.getRESERVED_5()) {
        yajl_gen_string(g, (const unsigned char*)  "RESERVED_5" , 10);
        yajl_gen_bool(g, (bool)value.getRESERVED_5());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_b8_Tun_Digital_Filters& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_Encryption"

void serializeJson (const ::tuner_main_fi_types::T_Encryption& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasEncrypted()) {
        yajl_gen_string(g, (const unsigned char*)  "Encrypted" , 9);
        yajl_gen_bool(g, (bool)value.getEncrypted());
    }
    if (!isSparse || value.hasEncid()) {
        yajl_gen_string(g, (const unsigned char*)  "Encid" , 5);
        yajl_gen_integer(g, (long long)value.getEncid());
    }
    if (!isSparse || value.hasTestBits()) {
        yajl_gen_string(g, (const unsigned char*)  "TestBits" , 8);
        yajl_gen_integer(g, (long long)value.getTestBits());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_Encryption& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_MsgSource"

void serializeJson (const ::tuner_main_fi_types::T_MsgSource& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasMediumTypeId()) {
        yajl_gen_string(g, (const unsigned char*)  "MediumTypeId" , 12);
        const char* s = ::tuner_main_fi_types::T_e8_TmcMediumType_Name(value.getMediumTypeId());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getMediumTypeId());
    }
    if (!isSparse || value.hasNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "Number" , 6);
        yajl_gen_integer(g, (long long)value.getNumber());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_MsgSource& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_Tun_RDBID_Value"

void serializeJson (const ::tuner_main_fi_types::T_Tun_RDBID_Value& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8RdbidCC()) {
        yajl_gen_string(g, (const unsigned char*)  "u8RdbidCC" , 9);
        yajl_gen_integer(g, (long long)value.getU8RdbidCC());
    }
    if (!isSparse || value.hasU8RdbidLTN()) {
        yajl_gen_string(g, (const unsigned char*)  "u8RdbidLTN" , 10);
        yajl_gen_integer(g, (long long)value.getU8RdbidLTN());
    }
    if (!isSparse || value.hasU8RdbidSID()) {
        yajl_gen_string(g, (const unsigned char*)  "u8RdbidSID" , 10);
        yajl_gen_integer(g, (long long)value.getU8RdbidSID());
    }
    if (!isSparse || value.hasBEncFlag()) {
        yajl_gen_string(g, (const unsigned char*)  "bEncFlag" , 8);
        yajl_gen_bool(g, (bool)value.getBEncFlag());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_Tun_RDBID_Value& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TunerRdbId"

void serializeJson (const ::tuner_main_fi_types::T_TunerRdbId& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTMCCountryCode()) {
        yajl_gen_string(g, (const unsigned char*)  "TMCCountryCode" , 14);
        yajl_gen_integer(g, (long long)value.getTMCCountryCode());
    }
    if (!isSparse || value.hasTableNo()) {
        yajl_gen_string(g, (const unsigned char*)  "TableNo" , 7);
        yajl_gen_integer(g, (long long)value.getTableNo());
    }
    if (!isSparse || value.hasServiceID()) {
        yajl_gen_string(g, (const unsigned char*)  "ServiceID" , 9);
        yajl_gen_integer(g, (long long)value.getServiceID());
    }
    if (!isSparse || value.hasEncrypted()) {
        yajl_gen_string(g, (const unsigned char*)  "Encrypted" , 9);
        yajl_gen_bool(g, (bool)value.getEncrypted());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_TunerRdbId& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TunerGetDataTMC"

void serializeJson (const ::tuner_main_fi_types::T_TunerGetDataTMC& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8TunerHeader()) {
        yajl_gen_string(g, (const unsigned char*)  "u8TunerHeader" , 13);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_TunerHeader_Name(value.getU8TunerHeader());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getU8TunerHeader());
    }
    if (!isSparse || value.hasU16TMCData1()) {
        yajl_gen_string(g, (const unsigned char*)  "u16TMCData1" , 11);
        yajl_gen_integer(g, (long long)value.getU16TMCData1());
    }
    if (!isSparse || value.hasU16TMCData2()) {
        yajl_gen_string(g, (const unsigned char*)  "u16TMCData2" , 11);
        yajl_gen_integer(g, (long long)value.getU16TMCData2());
    }
    if (!isSparse || value.hasU16TMCData3()) {
        yajl_gen_string(g, (const unsigned char*)  "u16TMCData3" , 11);
        yajl_gen_integer(g, (long long)value.getU16TMCData3());
    }
    if (!isSparse || value.hasU16TMCData4()) {
        yajl_gen_string(g, (const unsigned char*)  "u16TMCData4" , 11);
        yajl_gen_integer(g, (long long)value.getU16TMCData4());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_TunerGetDataTMC& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TrafficInfo"

void serializeJson (const ::tuner_main_fi_types::T_TrafficInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRDBId()) {
        yajl_gen_string(g, (const unsigned char*)  "RDBId" , 5);
        serializeJson(value.getRDBId(), g, options);
    }
    if (!isSparse || value.hasECC()) {
        yajl_gen_string(g, (const unsigned char*)  "ECC" , 3);
        yajl_gen_integer(g, (long long)value.getECC());
    }
    if (!isSparse || value.hasApplicationId()) {
        yajl_gen_string(g, (const unsigned char*)  "ApplicationId" , 13);
        const char* s = ::tuner_main_fi_types::T_e16_TmcApplicationId_Name(value.getApplicationId());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getApplicationId());
    }
    if (!isSparse || value.hasListOf8AData()) {
        yajl_gen_string(g, (const unsigned char*)  "ListOf8AData" , 12);
        yajl_gen_array_open(g);
        const ::std::vector< uint8 >& o3 = value.getListOf8AData();
        {
            ::std::vector< uint8 >::const_iterator o2;
            for (o2 = o3.begin(); o2 != o3.end(); ++o2) {
                yajl_gen_integer(g, (long long)(*o2));
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasProgramID()) {
        yajl_gen_string(g, (const unsigned char*)  "ProgramID" , 9);
        yajl_gen_integer(g, (long long)value.getProgramID());
    }
    if (!isSparse || value.hasEncryption()) {
        yajl_gen_string(g, (const unsigned char*)  "Encryption" , 10);
        serializeJson(value.getEncryption(), g, options);
    }
    if (!isSparse || value.hasMsgSource()) {
        yajl_gen_string(g, (const unsigned char*)  "MsgSource" , 9);
        serializeJson(value.getMsgSource(), g, options);
    }
    if (!isSparse || value.hasProgramServiceName()) {
        yajl_gen_string(g, (const unsigned char*)  "ProgramServiceName" , 18);
        const char *s = value.getProgramServiceName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasServiceProviderName()) {
        yajl_gen_string(g, (const unsigned char*)  "ServiceProviderName" , 19);
        const char *s = value.getServiceProviderName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_TrafficInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_b8_Tun_PackedInfo"

void serializeJson (const ::tuner_main_fi_types::T_b8_Tun_PackedInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    if (value.getTUN_TP()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_TP" , 6);
        yajl_gen_bool(g, (bool)value.getTUN_TP());
    }
    if (value.getTUN_TP_SELF()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_TP_SELF" , 11);
        yajl_gen_bool(g, (bool)value.getTUN_TP_SELF());
    }
    if (value.getTUN_PTY_DYNAMIC()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_PTY_DYNAMIC" , 15);
        yajl_gen_bool(g, (bool)value.getTUN_PTY_DYNAMIC());
    }
    if (value.getTUN_PS_DYNAMIC()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_PS_DYNAMIC" , 14);
        yajl_gen_bool(g, (bool)value.getTUN_PS_DYNAMIC());
    }
    if (value.getTUN_TMC_reserved()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_TMC_reserved" , 16);
        yajl_gen_bool(g, (bool)value.getTUN_TMC_reserved());
    }
    if (value.getTUN_TMC_YES()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_TMC_YES" , 11);
        yajl_gen_bool(g, (bool)value.getTUN_TMC_YES());
    }
    if (value.getTUN_TMC_NO()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_TMC_NO" , 10);
        yajl_gen_bool(g, (bool)value.getTUN_TMC_NO());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_b8_Tun_PackedInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_MakeConfigListElem"

void serializeJson (const ::tuner_main_fi_types::T_MakeConfigListElem& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ListID()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ListID" , 8);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_ConfigListID_Name(value.getE8ListID());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ListID());
    }
    if (!isSparse || value.hasU8NumOfElementsInList()) {
        yajl_gen_string(g, (const unsigned char*)  "u8NumOfElementsInList" , 21);
        yajl_gen_integer(g, (long long)value.getU8NumOfElementsInList());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_MakeConfigListElem& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_b8_Tun_AvailFlags"

void serializeJson (const ::tuner_main_fi_types::T_b8_Tun_AvailFlags& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    if (value.getTUN_AVAILABLE_FLAGS_FRQ_AVAILABLE()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_AVAILABLE_FLAGS_FRQ_AVAILABLE" , 33);
        yajl_gen_bool(g, (bool)value.getTUN_AVAILABLE_FLAGS_FRQ_AVAILABLE());
    }
    if (value.getTUN_AVAILABLE_FLAGS_PI_AVAILABLE()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_AVAILABLE_FLAGS_PI_AVAILABLE" , 32);
        yajl_gen_bool(g, (bool)value.getTUN_AVAILABLE_FLAGS_PI_AVAILABLE());
    }
    if (value.getTUN_AVAILABLE_FLAGS_PS_AVAILABLE()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_AVAILABLE_FLAGS_PS_AVAILABLE" , 32);
        yajl_gen_bool(g, (bool)value.getTUN_AVAILABLE_FLAGS_PS_AVAILABLE());
    }
    if (value.getTUN_AVAILABLE_FLAGS_PTY_AVAILABLE()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_AVAILABLE_FLAGS_PTY_AVAILABLE" , 33);
        yajl_gen_bool(g, (bool)value.getTUN_AVAILABLE_FLAGS_PTY_AVAILABLE());
    }
    if (value.getTUN_AVAILABLE_FLAGS_CT_AVAILABLE()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_AVAILABLE_FLAGS_CT_AVAILABLE" , 32);
        yajl_gen_bool(g, (bool)value.getTUN_AVAILABLE_FLAGS_CT_AVAILABLE());
    }
    if (value.getTUN_AVAILABLE_FLAGS_RT_AVAILABLE()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_AVAILABLE_FLAGS_RT_AVAILABLE" , 32);
        yajl_gen_bool(g, (bool)value.getTUN_AVAILABLE_FLAGS_RT_AVAILABLE());
    }
    if (value.getTUN_AVAILABLE_FLAGS_reserved()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_AVAILABLE_FLAGS_reserved" , 28);
        yajl_gen_bool(g, (bool)value.getTUN_AVAILABLE_FLAGS_reserved());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_b8_Tun_AvailFlags& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TunerConfigListElement"

void serializeJson (const ::tuner_main_fi_types::T_TunerConfigListElement& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ConfigListID()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ConfigListID" , 14);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_ConfigListID_Name(value.getE8ConfigListID());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ConfigListID());
    }
    if (!isSparse || value.hasU8ElementID()) {
        yajl_gen_string(g, (const unsigned char*)  "u8ElementID" , 11);
        yajl_gen_integer(g, (long long)value.getU8ElementID());
    }
    if (!isSparse || value.hasU8ElementSelected()) {
        yajl_gen_string(g, (const unsigned char*)  "u8ElementSelected" , 17);
        yajl_gen_integer(g, (long long)value.getU8ElementSelected());
    }
    if (!isSparse || value.hasU32Frequency()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Frequency" , 12);
        yajl_gen_integer(g, (long long)value.getU32Frequency());
    }
    if (!isSparse || value.hasU32PI()) {
        yajl_gen_string(g, (const unsigned char*)  "u32PI" , 5);
        yajl_gen_integer(g, (long long)value.getU32PI());
    }
    if (!isSparse || value.hasSPSName()) {
        yajl_gen_string(g, (const unsigned char*)  "sPSName" , 7);
        const char *s = value.getSPSName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU8PTY()) {
        yajl_gen_string(g, (const unsigned char*)  "u8PTY" , 5);
        yajl_gen_integer(g, (long long)value.getU8PTY());
    }
    if (!isSparse || value.hasU8ECC()) {
        yajl_gen_string(g, (const unsigned char*)  "u8ECC" , 5);
        yajl_gen_integer(g, (long long)value.getU8ECC());
    }
    if (!isSparse || value.hasU8SID()) {
        yajl_gen_string(g, (const unsigned char*)  "u8SID" , 5);
        yajl_gen_integer(g, (long long)value.getU8SID());
    }
    if (!isSparse || value.hasU8LTN()) {
        yajl_gen_string(g, (const unsigned char*)  "u8LTN" , 5);
        yajl_gen_integer(g, (long long)value.getU8LTN());
    }
    if (!isSparse || value.hasU8Quality()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Quality" , 9);
        yajl_gen_integer(g, (long long)value.getU8Quality());
    }
    if (!isSparse || value.hasU8PositionInPresetList()) {
        yajl_gen_string(g, (const unsigned char*)  "u8PositionInPresetList" , 22);
        yajl_gen_integer(g, (long long)value.getU8PositionInPresetList());
    }
    if (!isSparse || value.hasE8SendernameInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "e8SendernameInfo" , 16);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_SendernameInfo_Name(value.getE8SendernameInfo());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8SendernameInfo());
    }
    if (!isSparse || value.hasBTpInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "bTpInfo" , 7);
        yajl_gen_bool(g, (bool)value.getBTpInfo());
    }
    if (!isSparse || value.hasE8TMCType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8TMCType" , 9);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_TMCType_Name(value.getE8TMCType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8TMCType());
    }
    if (!isSparse || value.hasE8PresetListForAcmp()) {
        yajl_gen_string(g, (const unsigned char*)  "e8PresetListForAcmp" , 19);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_ListID_Name(value.getE8PresetListForAcmp());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8PresetListForAcmp());
    }
    if (!isSparse || value.hasS8LevelCompensation()) {
        yajl_gen_string(g, (const unsigned char*)  "s8LevelCompensation" , 19);
        yajl_gen_integer(g, (long long)value.getS8LevelCompensation());
    }
    if (!isSparse || value.hasStationLogo()) {
        yajl_gen_string(g, (const unsigned char*)  "StationLogo" , 11);
        const char *s = value.getStationLogo().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasE8ModulationType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ModulationType" , 16);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_ModulationType_Name(value.getE8ModulationType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ModulationType());
    }
    if (!isSparse || value.hasU8PTY_HDPTY_DRMPty()) {
        yajl_gen_string(g, (const unsigned char*)  "u8PTY_HDPTY_DRMPty" , 18);
        yajl_gen_integer(g, (long long)value.getU8PTY_HDPTY_DRMPty());
    }
    if (!isSparse || value.hasU32PI_HDStnId_DRMSrvId()) {
        yajl_gen_string(g, (const unsigned char*)  "u32PI_HDStnId_DRMSrvId" , 22);
        yajl_gen_integer(g, (long long)value.getU32PI_HDStnId_DRMSrvId());
    }
    if (!isSparse || value.hasB8StationInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "b8StationInfo" , 13);
        serializeJson(value.getB8StationInfo(), g, options);
    }
    if (!isSparse || value.hasE8HDTextEncoding()) {
        yajl_gen_string(g, (const unsigned char*)  "e8HDTextEncoding" , 16);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_HD_TextEncodingType_Name(value.getE8HDTextEncoding());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8HDTextEncoding());
    }
    if (!isSparse || value.hasB8HDNumOfAudioPrograms()) {
        yajl_gen_string(g, (const unsigned char*)  "b8HDNumOfAudioPrograms" , 22);
        serializeJson(value.getB8HDNumOfAudioPrograms(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_TunerConfigListElement& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_b8_Tun_StationInfo"

void serializeJson (const ::tuner_main_fi_types::T_b8_Tun_StationInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    if (value.getTP()) {
        yajl_gen_string(g, (const unsigned char*)  "TP" , 2);
        yajl_gen_bool(g, (bool)value.getTP());
    }
    if (value.getAF()) {
        yajl_gen_string(g, (const unsigned char*)  "AF" , 2);
        yajl_gen_bool(g, (bool)value.getAF());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_b8_Tun_StationInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_b8_Tun_HDNumOfAudioPrograms"

void serializeJson (const ::tuner_main_fi_types::T_b8_Tun_HDNumOfAudioPrograms& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    if (value.getTUN_HD_AUDIOPROGRAM_MPS()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_HD_AUDIOPROGRAM_MPS" , 23);
        yajl_gen_bool(g, (bool)value.getTUN_HD_AUDIOPROGRAM_MPS());
    }
    if (value.getTUN_HD_AUDIOPROGRAM_SPS1()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_HD_AUDIOPROGRAM_SPS1" , 24);
        yajl_gen_bool(g, (bool)value.getTUN_HD_AUDIOPROGRAM_SPS1());
    }
    if (value.getTUN_HD_AUDIOPROGRAM_SPS2()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_HD_AUDIOPROGRAM_SPS2" , 24);
        yajl_gen_bool(g, (bool)value.getTUN_HD_AUDIOPROGRAM_SPS2());
    }
    if (value.getTUN_HD_AUDIOPROGRAM_SPS3()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_HD_AUDIOPROGRAM_SPS3" , 24);
        yajl_gen_bool(g, (bool)value.getTUN_HD_AUDIOPROGRAM_SPS3());
    }
    if (value.getTUN_HD_AUDIOPROGRAM_SPS4()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_HD_AUDIOPROGRAM_SPS4" , 24);
        yajl_gen_bool(g, (bool)value.getTUN_HD_AUDIOPROGRAM_SPS4());
    }
    if (value.getTUN_HD_AUDIOPROGRAM_SPS5()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_HD_AUDIOPROGRAM_SPS5" , 24);
        yajl_gen_bool(g, (bool)value.getTUN_HD_AUDIOPROGRAM_SPS5());
    }
    if (value.getTUN_HD_AUDIOPROGRAM_SPS6()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_HD_AUDIOPROGRAM_SPS6" , 24);
        yajl_gen_bool(g, (bool)value.getTUN_HD_AUDIOPROGRAM_SPS6());
    }
    if (value.getTUN_HD_AUDIOPROGRAM_SPS7()) {
        yajl_gen_string(g, (const unsigned char*)  "TUN_HD_AUDIOPROGRAM_SPS7" , 24);
        yajl_gen_bool(g, (bool)value.getTUN_HD_AUDIOPROGRAM_SPS7());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_b8_Tun_HDNumOfAudioPrograms& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_Tun_Set_PI"

void serializeJson (const ::tuner_main_fi_types::T_Tun_Set_PI& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8AbsOrRel()) {
        yajl_gen_string(g, (const unsigned char*)  "u8AbsOrRel" , 10);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_Abs_Or_Rel_Name(value.getU8AbsOrRel());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getU8AbsOrRel());
    }
    if (!isSparse || value.hasU8RelSteps()) {
        yajl_gen_string(g, (const unsigned char*)  "u8RelSteps" , 10);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_Rel_Steps_Name(value.getU8RelSteps());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getU8RelSteps());
    }
    if (!isSparse || value.hasU8Direction()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Direction" , 11);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_Direction_Name(value.getU8Direction());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getU8Direction());
    }
    if (!isSparse || value.hasU8Nsteps()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Nsteps" , 8);
        yajl_gen_integer(g, (long long)value.getU8Nsteps());
    }
    if (!isSparse || value.hasU16PI()) {
        yajl_gen_string(g, (const unsigned char*)  "u16PI" , 5);
        yajl_gen_integer(g, (long long)value.getU16PI());
    }
    if (!isSparse || value.hasU32Frequency()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Frequency" , 12);
        yajl_gen_integer(g, (long long)value.getU32Frequency());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_Tun_Set_PI& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TunerStaticListElement"

void serializeJson (const ::tuner_main_fi_types::T_TunerStaticListElement& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ListID()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ListID" , 8);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_ListID_Name(value.getE8ListID());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ListID());
    }
    if (!isSparse || value.hasU8ElementID()) {
        yajl_gen_string(g, (const unsigned char*)  "u8ElementID" , 11);
        yajl_gen_integer(g, (long long)value.getU8ElementID());
    }
    if (!isSparse || value.hasBSelected()) {
        yajl_gen_string(g, (const unsigned char*)  "bSelected" , 9);
        yajl_gen_bool(g, (bool)value.getBSelected());
    }
    if (!isSparse || value.hasU32Frequency()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Frequency" , 12);
        yajl_gen_integer(g, (long long)value.getU32Frequency());
    }
    if (!isSparse || value.hasSPSName()) {
        yajl_gen_string(g, (const unsigned char*)  "sPSName" , 7);
        const char *s = value.getSPSName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU16PI()) {
        yajl_gen_string(g, (const unsigned char*)  "u16PI" , 5);
        yajl_gen_integer(g, (long long)value.getU16PI());
    }
    if (!isSparse || value.hasE8SendernameInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "e8SendernameInfo" , 16);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_SendernameInfo_Name(value.getE8SendernameInfo());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8SendernameInfo());
    }
    if (!isSparse || value.hasU8TpTmcInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "u8TpTmcInfo" , 11);
        yajl_gen_integer(g, (long long)value.getU8TpTmcInfo());
    }
    if (!isSparse || value.hasU32PTY()) {
        yajl_gen_string(g, (const unsigned char*)  "u32PTY" , 6);
        yajl_gen_integer(g, (long long)value.getU32PTY());
    }
    if (!isSparse || value.hasS8LevelCompensation()) {
        yajl_gen_string(g, (const unsigned char*)  "s8LevelCompensation" , 19);
        yajl_gen_integer(g, (long long)value.getS8LevelCompensation());
    }
    if (!isSparse || value.hasE8Modulation()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Modulation" , 12);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_ModulationType_Name(value.getE8Modulation());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Modulation());
    }
    if (!isSparse || value.hasU32HDStationId_DRMServiceId()) {
        yajl_gen_string(g, (const unsigned char*)  "u32HDStationId_DRMServiceId" , 27);
        yajl_gen_integer(g, (long long)value.getU32HDStationId_DRMServiceId());
    }
    if (!isSparse || value.hasSHDCallSign_DRMServiceLabel()) {
        yajl_gen_string(g, (const unsigned char*)  "sHDCallSign_DRMServiceLabel" , 27);
        const char *s = value.getSHDCallSign_DRMServiceLabel().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasE8HDTextEncoding()) {
        yajl_gen_string(g, (const unsigned char*)  "e8HDTextEncoding" , 16);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_HD_TextEncodingType_Name(value.getE8HDTextEncoding());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8HDTextEncoding());
    }
    if (!isSparse || value.hasU8HDStationGenre_DRMPty()) {
        yajl_gen_string(g, (const unsigned char*)  "u8HDStationGenre_DRMPty" , 23);
        yajl_gen_integer(g, (long long)value.getU8HDStationGenre_DRMPty());
    }
    if (!isSparse || value.hasU8HDAudioProgram_DRMShortID()) {
        yajl_gen_string(g, (const unsigned char*)  "u8HDAudioProgram_DRMShortID" , 27);
        yajl_gen_integer(g, (long long)value.getU8HDAudioProgram_DRMShortID());
    }
    if (!isSparse || value.hasStationLogo()) {
        yajl_gen_string(g, (const unsigned char*)  "StationLogo" , 11);
        const char *s = value.getStationLogo().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU32DRMServiceId()) {
        yajl_gen_string(g, (const unsigned char*)  "u32DRMServiceId" , 15);
        yajl_gen_integer(g, (long long)value.getU32DRMServiceId());
    }
    if (!isSparse || value.hasSDRMServiceLabel()) {
        yajl_gen_string(g, (const unsigned char*)  "sDRMServiceLabel" , 16);
        const char *s = value.getSDRMServiceLabel().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU8DRMPTY()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DRMPTY" , 8);
        yajl_gen_integer(g, (long long)value.getU8DRMPTY());
    }
    if (!isSparse || value.hasU8DRMServiceShortId()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DRMServiceShortId" , 19);
        yajl_gen_integer(g, (long long)value.getU8DRMServiceShortId());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_TunerStaticListElement& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TunerTestRoutineParameter"

void serializeJson (const ::tuner_main_fi_types::T_TunerTestRoutineParameter& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTroubleCode()) {
        yajl_gen_string(g, (const unsigned char*)  "TroubleCode" , 11);
        const char* s = ::tuner_main_fi_types::T_e16_Tun_TroubleCode_Name(value.getTroubleCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getTroubleCode());
    }
    if (!isSparse || value.hasWriteToRM()) {
        yajl_gen_string(g, (const unsigned char*)  "WriteToRM" , 9);
        yajl_gen_bool(g, (bool)value.getWriteToRM());
    }
    if (!isSparse || value.hasMonitoringMode()) {
        yajl_gen_string(g, (const unsigned char*)  "MonitoringMode" , 14);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_MonitoringMode_Name(value.getMonitoringMode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getMonitoringMode());
    }
    if (!isSparse || value.hasSupervisionControl()) {
        yajl_gen_string(g, (const unsigned char*)  "SupervisionControl" , 18);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_SupervisionControl_Name(value.getSupervisionControl());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getSupervisionControl());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_TunerTestRoutineParameter& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_Tun_TestTroubleCodeStatus"

void serializeJson (const ::tuner_main_fi_types::T_Tun_TestTroubleCodeStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTroubleCode()) {
        yajl_gen_string(g, (const unsigned char*)  "TroubleCode" , 11);
        const char* s = ::tuner_main_fi_types::T_e16_Tun_TroubleCode_Name(value.getTroubleCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getTroubleCode());
    }
    if (!isSparse || value.hasErrorStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorStatus" , 11);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_ErrorStatus_Name(value.getErrorStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorStatus());
    }
    if (!isSparse || value.hasRoutineStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "RoutineStatus" , 13);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_RoutineStatus_Name(value.getRoutineStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getRoutineStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_Tun_TestTroubleCodeStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TunerFieldstrength"

void serializeJson (const ::tuner_main_fi_types::T_TunerFieldstrength& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8Band()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Band" , 6);
        yajl_gen_integer(g, (long long)value.getU8Band());
    }
    if (!isSparse || value.hasU32Frequency()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Frequency" , 12);
        yajl_gen_integer(g, (long long)value.getU32Frequency());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_TunerFieldstrength& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TunerRadioText"

void serializeJson (const ::tuner_main_fi_types::T_TunerRadioText& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8TunerHeader()) {
        yajl_gen_string(g, (const unsigned char*)  "u8TunerHeader" , 13);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_TunerHeader_Name(value.getU8TunerHeader());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getU8TunerHeader());
    }
    if (!isSparse || value.hasU8TunerSource()) {
        yajl_gen_string(g, (const unsigned char*)  "u8TunerSource" , 13);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_Source_Name(value.getU8TunerSource());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getU8TunerSource());
    }
    if (!isSparse || value.hasU8TextType()) {
        yajl_gen_string(g, (const unsigned char*)  "u8TextType" , 10);
        yajl_gen_integer(g, (long long)value.getU8TextType());
    }
    if (!isSparse || value.hasSRadioTextData()) {
        yajl_gen_string(g, (const unsigned char*)  "sRadioTextData" , 14);
        const char *s = value.getSRadioTextData().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_TunerRadioText& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TunerBandAndStationInfo"

void serializeJson (const ::tuner_main_fi_types::T_TunerBandAndStationInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8Band()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Band" , 6);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_TunerBand_Name(value.getE8Band());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Band());
    }
    if (!isSparse || value.hasU32Frequency()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Frequency" , 12);
        yajl_gen_integer(g, (long long)value.getU32Frequency());
    }
    if (!isSparse || value.hasU16PI()) {
        yajl_gen_string(g, (const unsigned char*)  "u16PI" , 5);
        yajl_gen_integer(g, (long long)value.getU16PI());
    }
    if (!isSparse || value.hasSPSName()) {
        yajl_gen_string(g, (const unsigned char*)  "sPSName" , 7);
        const char *s = value.getSPSName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU16StaticListElementID()) {
        yajl_gen_string(g, (const unsigned char*)  "u16StaticListElementID" , 22);
        yajl_gen_integer(g, (long long)value.getU16StaticListElementID());
    }
    if (!isSparse || value.hasSHDCallSign()) {
        yajl_gen_string(g, (const unsigned char*)  "sHDCallSign" , 11);
        const char *s = value.getSHDCallSign().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU32HDStationId()) {
        yajl_gen_string(g, (const unsigned char*)  "u32HDStationId" , 14);
        yajl_gen_integer(g, (long long)value.getU32HDStationId());
    }
    if (!isSparse || value.hasE8HDAudioProgram()) {
        yajl_gen_string(g, (const unsigned char*)  "e8HDAudioProgram" , 16);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_HDAudioProgram_Name(value.getE8HDAudioProgram());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8HDAudioProgram());
    }
    if (!isSparse || value.hasU8PresetAutocompare()) {
        yajl_gen_string(g, (const unsigned char*)  "u8PresetAutocompare" , 19);
        yajl_gen_integer(g, (long long)value.getU8PresetAutocompare());
    }
    if (!isSparse || value.hasSDRMServiceLabel()) {
        yajl_gen_string(g, (const unsigned char*)  "sDRMServiceLabel" , 16);
        const char *s = value.getSDRMServiceLabel().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU32DRMServiceId()) {
        yajl_gen_string(g, (const unsigned char*)  "u32DRMServiceId" , 15);
        yajl_gen_integer(g, (long long)value.getU32DRMServiceId());
    }
    if (!isSparse || value.hasU8DRMServiceShortId()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DRMServiceShortId" , 19);
        yajl_gen_integer(g, (long long)value.getU8DRMServiceShortId());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_TunerBandAndStationInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_Tun_AutoCompParam"

void serializeJson (const ::tuner_main_fi_types::T_Tun_AutoCompParam& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8FirstElemId()) {
        yajl_gen_string(g, (const unsigned char*)  "u8FirstElemId" , 13);
        yajl_gen_integer(g, (long long)value.getU8FirstElemId());
    }
    if (!isSparse || value.hasU8LastElemID()) {
        yajl_gen_string(g, (const unsigned char*)  "u8LastElemID" , 12);
        yajl_gen_integer(g, (long long)value.getU8LastElemID());
    }
    if (!isSparse || value.hasU8Mode()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Mode" , 6);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_Autocompare_Mode_Name(value.getU8Mode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getU8Mode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_Tun_AutoCompParam& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_Component_Status"

void serializeJson (const ::tuner_main_fi_types::T_Component_Status& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8AudioSinkTUN1()) {
        yajl_gen_string(g, (const unsigned char*)  "u8AudioSinkTUN1" , 15);
        yajl_gen_integer(g, (long long)value.getU8AudioSinkTUN1());
    }
    if (!isSparse || value.hasU8BGModeTuner()) {
        yajl_gen_string(g, (const unsigned char*)  "u8BGModeTuner" , 13);
        yajl_gen_integer(g, (long long)value.getU8BGModeTuner());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_Component_Status& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_Atstationinfo"

void serializeJson (const ::tuner_main_fi_types::T_Atstationinfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8TunerHeader()) {
        yajl_gen_string(g, (const unsigned char*)  "u8TunerHeader" , 13);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_TunerHeader_Name(value.getU8TunerHeader());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getU8TunerHeader());
    }
    if (!isSparse || value.hasU32AvailFlags()) {
        yajl_gen_string(g, (const unsigned char*)  "u32AvailFlags" , 13);
        serializeJson(value.getU32AvailFlags(), g, options);
    }
    if (!isSparse || value.hasU32Frequency()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Frequency" , 12);
        yajl_gen_integer(g, (long long)value.getU32Frequency());
    }
    if (!isSparse || value.hasU16PI()) {
        yajl_gen_string(g, (const unsigned char*)  "u16PI" , 5);
        yajl_gen_integer(g, (long long)value.getU16PI());
    }
    if (!isSparse || value.hasSPSName()) {
        yajl_gen_string(g, (const unsigned char*)  "sPSName" , 7);
        const char *s = value.getSPSName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasE8Band()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Band" , 6);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_TunerBand_Name(value.getE8Band());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Band());
    }
    if (!isSparse || value.hasE8AtStationTPinfo()) {
        yajl_gen_string(g, (const unsigned char*)  "e8AtStationTPinfo" , 17);
        const char* s = ::tuner_main_fi_types::T_e8_AtStationTPinfo_Name(value.getE8AtStationTPinfo());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8AtStationTPinfo());
    }
    if (!isSparse || value.hasU16PresetListID()) {
        yajl_gen_string(g, (const unsigned char*)  "u16PresetListID" , 15);
        yajl_gen_integer(g, (long long)value.getU16PresetListID());
    }
    if (!isSparse || value.hasU8ActiveStationList()) {
        yajl_gen_string(g, (const unsigned char*)  "u8ActiveStationList" , 19);
        yajl_gen_integer(g, (long long)value.getU8ActiveStationList());
    }
    if (!isSparse || value.hasU16StaticListElementID()) {
        yajl_gen_string(g, (const unsigned char*)  "u16StaticListElementID" , 22);
        yajl_gen_integer(g, (long long)value.getU16StaticListElementID());
    }
    if (!isSparse || value.hasU16ConfigListElementID()) {
        yajl_gen_string(g, (const unsigned char*)  "u16ConfigListElementID" , 22);
        yajl_gen_integer(g, (long long)value.getU16ConfigListElementID());
    }
    if (!isSparse || value.hasU8AtStationInfoBits()) {
        yajl_gen_string(g, (const unsigned char*)  "u8AtStationInfoBits" , 19);
        serializeJson(value.getU8AtStationInfoBits(), g, options);
    }
    if (!isSparse || value.hasU8PTY()) {
        yajl_gen_string(g, (const unsigned char*)  "u8PTY" , 5);
        yajl_gen_integer(g, (long long)value.getU8PTY());
    }
    if (!isSparse || value.hasU8FieldStrngth()) {
        yajl_gen_string(g, (const unsigned char*)  "u8FieldStrngth" , 14);
        yajl_gen_integer(g, (long long)value.getU8FieldStrngth());
    }
    if (!isSparse || value.hasU8Quality()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Quality" , 9);
        yajl_gen_integer(g, (long long)value.getU8Quality());
    }
    if (!isSparse || value.hasB8HDStationInfoBits()) {
        yajl_gen_string(g, (const unsigned char*)  "b8HDStationInfoBits" , 19);
        serializeJson(value.getB8HDStationInfoBits(), g, options);
    }
    if (!isSparse || value.hasU32StationInfoHDStationID()) {
        yajl_gen_string(g, (const unsigned char*)  "u32StationInfoHDStationID" , 25);
        yajl_gen_integer(g, (long long)value.getU32StationInfoHDStationID());
    }
    if (!isSparse || value.hasSHDCallSign()) {
        yajl_gen_string(g, (const unsigned char*)  "sHDCallSign" , 11);
        const char *s = value.getSHDCallSign().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasE8HDCallSignTextEncoding()) {
        yajl_gen_string(g, (const unsigned char*)  "e8HDCallSignTextEncoding" , 24);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_HD_TextEncodingType_Name(value.getE8HDCallSignTextEncoding());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8HDCallSignTextEncoding());
    }
    if (!isSparse || value.hasU8HDStationGenre()) {
        yajl_gen_string(g, (const unsigned char*)  "u8HDStationGenre" , 16);
        yajl_gen_integer(g, (long long)value.getU8HDStationGenre());
    }
    if (!isSparse || value.hasB8HDAudioPrgmAvail()) {
        yajl_gen_string(g, (const unsigned char*)  "b8HDAudioPrgmAvail" , 18);
        serializeJson(value.getB8HDAudioPrgmAvail(), g, options);
    }
    if (!isSparse || value.hasU8HDQuality()) {
        yajl_gen_string(g, (const unsigned char*)  "u8HDQuality" , 11);
        yajl_gen_integer(g, (long long)value.getU8HDQuality());
    }
    if (!isSparse || value.hasE8ActiveHDAudPrgm()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ActiveHDAudPrgm" , 17);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_HDAudioProgram_Name(value.getE8ActiveHDAudPrgm());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ActiveHDAudPrgm());
    }
    if (!isSparse || value.hasStationLogo()) {
        yajl_gen_string(g, (const unsigned char*)  "StationLogo" , 11);
        const char *s = value.getStationLogo().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasB8DRMStationInfoBits()) {
        yajl_gen_string(g, (const unsigned char*)  "b8DRMStationInfoBits" , 20);
        serializeJson(value.getB8DRMStationInfoBits(), g, options);
    }
    if (!isSparse || value.hasU32DRMServiceId()) {
        yajl_gen_string(g, (const unsigned char*)  "u32DRMServiceId" , 15);
        yajl_gen_integer(g, (long long)value.getU32DRMServiceId());
    }
    if (!isSparse || value.hasSDRMServiceLabel()) {
        yajl_gen_string(g, (const unsigned char*)  "sDRMServiceLabel" , 16);
        const char *s = value.getSDRMServiceLabel().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU8DRMPTY()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DRMPTY" , 8);
        yajl_gen_integer(g, (long long)value.getU8DRMPTY());
    }
    if (!isSparse || value.hasB16DRMAnnouBits()) {
        yajl_gen_string(g, (const unsigned char*)  "b16DRMAnnouBits" , 15);
        serializeJson(value.getB16DRMAnnouBits(), g, options);
    }
    if (!isSparse || value.hasB8DRMNumberOfAudioServices()) {
        yajl_gen_string(g, (const unsigned char*)  "b8DRMNumberOfAudioServices" , 26);
        serializeJson(value.getB8DRMNumberOfAudioServices(), g, options);
    }
    if (!isSparse || value.hasU8DRMQuality()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DRMQuality" , 12);
        yajl_gen_integer(g, (long long)value.getU8DRMQuality());
    }
    if (!isSparse || value.hasU8DRMServiceShortId()) {
        yajl_gen_string(g, (const unsigned char*)  "u8DRMServiceShortId" , 19);
        yajl_gen_integer(g, (long long)value.getU8DRMServiceShortId());
    }
    if (!isSparse || value.hasU8Drmlanguage()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Drmlanguage" , 13);
        yajl_gen_integer(g, (long long)value.getU8Drmlanguage());
    }
    if (!isSparse || value.hasU32DrmlanguageCode()) {
        yajl_gen_string(g, (const unsigned char*)  "u32DrmlanguageCode" , 18);
        yajl_gen_integer(g, (long long)value.getU32DrmlanguageCode());
    }
    if (!isSparse || value.hasU16DrmCountryCode()) {
        yajl_gen_string(g, (const unsigned char*)  "u16DrmCountryCode" , 17);
        yajl_gen_integer(g, (long long)value.getU16DrmCountryCode());
    }
    if (!isSparse || value.hasS8DrmFrequencyCorrection()) {
        yajl_gen_string(g, (const unsigned char*)  "s8DrmFrequencyCorrection" , 24);
        yajl_gen_integer(g, (long long)value.getS8DrmFrequencyCorrection());
    }
    if (!isSparse || value.hasU8JapanStationCount()) {
        yajl_gen_string(g, (const unsigned char*)  "u8JapanStationCount" , 19);
        yajl_gen_integer(g, (long long)value.getU8JapanStationCount());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_Atstationinfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_b8_Tun_HDInfoBits"

void serializeJson (const ::tuner_main_fi_types::T_b8_Tun_HDInfoBits& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    if (value.getHD_MODULATION_DETECTION()) {
        yajl_gen_string(g, (const unsigned char*)  "HD_MODULATION_DETECTION" , 23);
        yajl_gen_bool(g, (bool)value.getHD_MODULATION_DETECTION());
    }
    if (value.getHD_DATA_DECODING()) {
        yajl_gen_string(g, (const unsigned char*)  "HD_DATA_DECODING" , 16);
        yajl_gen_bool(g, (bool)value.getHD_DATA_DECODING());
    }
    if (value.getHD_AUDIO_DECODING()) {
        yajl_gen_string(g, (const unsigned char*)  "HD_AUDIO_DECODING" , 17);
        yajl_gen_bool(g, (bool)value.getHD_AUDIO_DECODING());
    }
    if (value.getHD_BLEND_ANALOG()) {
        yajl_gen_string(g, (const unsigned char*)  "HD_BLEND_ANALOG" , 15);
        yajl_gen_bool(g, (bool)value.getHD_BLEND_ANALOG());
    }
    if (value.getHD_DIGITAL_AUDIO_MUTE()) {
        yajl_gen_string(g, (const unsigned char*)  "HD_DIGITAL_AUDIO_MUTE" , 21);
        yajl_gen_bool(g, (bool)value.getHD_DIGITAL_AUDIO_MUTE());
    }
    if (value.getHD_BALLGAME_MODE()) {
        yajl_gen_string(g, (const unsigned char*)  "HD_BALLGAME_MODE" , 16);
        yajl_gen_bool(g, (bool)value.getHD_BALLGAME_MODE());
    }
    if (value.getRESERVED_1()) {
        yajl_gen_string(g, (const unsigned char*)  "RESERVED_1" , 10);
        yajl_gen_bool(g, (bool)value.getRESERVED_1());
    }
    if (value.getRESERVED_2()) {
        yajl_gen_string(g, (const unsigned char*)  "RESERVED_2" , 10);
        yajl_gen_bool(g, (bool)value.getRESERVED_2());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_b8_Tun_HDInfoBits& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_b8_Tun_HDPrgmAvail"

void serializeJson (const ::tuner_main_fi_types::T_b8_Tun_HDPrgmAvail& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    if (value.getMPS_AVAIL()) {
        yajl_gen_string(g, (const unsigned char*)  "MPS_AVAIL" , 9);
        yajl_gen_bool(g, (bool)value.getMPS_AVAIL());
    }
    if (value.getSPS_1_AVAIL()) {
        yajl_gen_string(g, (const unsigned char*)  "SPS_1_AVAIL" , 11);
        yajl_gen_bool(g, (bool)value.getSPS_1_AVAIL());
    }
    if (value.getSPS_2_AVAIL()) {
        yajl_gen_string(g, (const unsigned char*)  "SPS_2_AVAIL" , 11);
        yajl_gen_bool(g, (bool)value.getSPS_2_AVAIL());
    }
    if (value.getSPS_3_AVAIL()) {
        yajl_gen_string(g, (const unsigned char*)  "SPS_3_AVAIL" , 11);
        yajl_gen_bool(g, (bool)value.getSPS_3_AVAIL());
    }
    if (value.getSPS_4_AVAIL()) {
        yajl_gen_string(g, (const unsigned char*)  "SPS_4_AVAIL" , 11);
        yajl_gen_bool(g, (bool)value.getSPS_4_AVAIL());
    }
    if (value.getSPS_5_AVAIL()) {
        yajl_gen_string(g, (const unsigned char*)  "SPS_5_AVAIL" , 11);
        yajl_gen_bool(g, (bool)value.getSPS_5_AVAIL());
    }
    if (value.getSPS_6_AVAIL()) {
        yajl_gen_string(g, (const unsigned char*)  "SPS_6_AVAIL" , 11);
        yajl_gen_bool(g, (bool)value.getSPS_6_AVAIL());
    }
    if (value.getSPS_7_AVAIL()) {
        yajl_gen_string(g, (const unsigned char*)  "SPS_7_AVAIL" , 11);
        yajl_gen_bool(g, (bool)value.getSPS_7_AVAIL());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_b8_Tun_HDPrgmAvail& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_b8_Tun_DRMStationInfoBits"

void serializeJson (const ::tuner_main_fi_types::T_b8_Tun_DRMStationInfoBits& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    if (value.getDRM_MODULATION_DETECTION()) {
        yajl_gen_string(g, (const unsigned char*)  "DRM_MODULATION_DETECTION" , 24);
        yajl_gen_bool(g, (bool)value.getDRM_MODULATION_DETECTION());
    }
    if (value.getDRM_MULTIPLEX_INFO_DECODING()) {
        yajl_gen_string(g, (const unsigned char*)  "DRM_MULTIPLEX_INFO_DECODING" , 27);
        yajl_gen_bool(g, (bool)value.getDRM_MULTIPLEX_INFO_DECODING());
    }
    if (value.getDRM_AUDIO_DECODING()) {
        yajl_gen_string(g, (const unsigned char*)  "DRM_AUDIO_DECODING" , 18);
        yajl_gen_bool(g, (bool)value.getDRM_AUDIO_DECODING());
    }
    if (value.getDRM_AUDIO_MUTE()) {
        yajl_gen_string(g, (const unsigned char*)  "DRM_AUDIO_MUTE" , 14);
        yajl_gen_bool(g, (bool)value.getDRM_AUDIO_MUTE());
    }
    if (value.getRESERVED_1()) {
        yajl_gen_string(g, (const unsigned char*)  "RESERVED_1" , 10);
        yajl_gen_bool(g, (bool)value.getRESERVED_1());
    }
    if (value.getRESERVED_2()) {
        yajl_gen_string(g, (const unsigned char*)  "RESERVED_2" , 10);
        yajl_gen_bool(g, (bool)value.getRESERVED_2());
    }
    if (value.getRESERVED_3()) {
        yajl_gen_string(g, (const unsigned char*)  "RESERVED_3" , 10);
        yajl_gen_bool(g, (bool)value.getRESERVED_3());
    }
    if (value.getRESERVED_4()) {
        yajl_gen_string(g, (const unsigned char*)  "RESERVED_4" , 10);
        yajl_gen_bool(g, (bool)value.getRESERVED_4());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_b8_Tun_DRMStationInfoBits& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_b16_Tun_DRMAnnouBits"

void serializeJson (const ::tuner_main_fi_types::T_b16_Tun_DRMAnnouBits& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    if (value.getRESERVED_1()) {
        yajl_gen_string(g, (const unsigned char*)  "RESERVED_1" , 10);
        yajl_gen_bool(g, (bool)value.getRESERVED_1());
    }
    if (value.getRESERVED_2()) {
        yajl_gen_string(g, (const unsigned char*)  "RESERVED_2" , 10);
        yajl_gen_bool(g, (bool)value.getRESERVED_2());
    }
    if (value.getRESERVED_3()) {
        yajl_gen_string(g, (const unsigned char*)  "RESERVED_3" , 10);
        yajl_gen_bool(g, (bool)value.getRESERVED_3());
    }
    if (value.getRESERVED_4()) {
        yajl_gen_string(g, (const unsigned char*)  "RESERVED_4" , 10);
        yajl_gen_bool(g, (bool)value.getRESERVED_4());
    }
    if (value.getRESERVED_5()) {
        yajl_gen_string(g, (const unsigned char*)  "RESERVED_5" , 10);
        yajl_gen_bool(g, (bool)value.getRESERVED_5());
    }
    if (value.getRESERVED_6()) {
        yajl_gen_string(g, (const unsigned char*)  "RESERVED_6" , 10);
        yajl_gen_bool(g, (bool)value.getRESERVED_6());
    }
    if (value.getRESERVED_7()) {
        yajl_gen_string(g, (const unsigned char*)  "RESERVED_7" , 10);
        yajl_gen_bool(g, (bool)value.getRESERVED_7());
    }
    if (value.getRESERVED_8()) {
        yajl_gen_string(g, (const unsigned char*)  "RESERVED_8" , 10);
        yajl_gen_bool(g, (bool)value.getRESERVED_8());
    }
    if (value.getRESERVED_9()) {
        yajl_gen_string(g, (const unsigned char*)  "RESERVED_9" , 10);
        yajl_gen_bool(g, (bool)value.getRESERVED_9());
    }
    if (value.getRESERVED_10()) {
        yajl_gen_string(g, (const unsigned char*)  "RESERVED_10" , 11);
        yajl_gen_bool(g, (bool)value.getRESERVED_10());
    }
    if (value.getRESERVED_11()) {
        yajl_gen_string(g, (const unsigned char*)  "RESERVED_11" , 11);
        yajl_gen_bool(g, (bool)value.getRESERVED_11());
    }
    if (value.getRESERVED_12()) {
        yajl_gen_string(g, (const unsigned char*)  "RESERVED_12" , 11);
        yajl_gen_bool(g, (bool)value.getRESERVED_12());
    }
    if (value.getRESERVED_13()) {
        yajl_gen_string(g, (const unsigned char*)  "RESERVED_13" , 11);
        yajl_gen_bool(g, (bool)value.getRESERVED_13());
    }
    if (value.getRESERVED_14()) {
        yajl_gen_string(g, (const unsigned char*)  "RESERVED_14" , 11);
        yajl_gen_bool(g, (bool)value.getRESERVED_14());
    }
    if (value.getRESERVED_15()) {
        yajl_gen_string(g, (const unsigned char*)  "RESERVED_15" , 11);
        yajl_gen_bool(g, (bool)value.getRESERVED_15());
    }
    if (value.getRESERVED_16()) {
        yajl_gen_string(g, (const unsigned char*)  "RESERVED_16" , 11);
        yajl_gen_bool(g, (bool)value.getRESERVED_16());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_b16_Tun_DRMAnnouBits& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_b8_Tun_DRMNumberOfAudioServices"

void serializeJson (const ::tuner_main_fi_types::T_b8_Tun_DRMNumberOfAudioServices& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    if (value.getAUDIO_PROGRAM_1()) {
        yajl_gen_string(g, (const unsigned char*)  "AUDIO_PROGRAM_1" , 15);
        yajl_gen_bool(g, (bool)value.getAUDIO_PROGRAM_1());
    }
    if (value.getAUDIO_PROGRAM_2()) {
        yajl_gen_string(g, (const unsigned char*)  "AUDIO_PROGRAM_2" , 15);
        yajl_gen_bool(g, (bool)value.getAUDIO_PROGRAM_2());
    }
    if (value.getAUDIO_PROGRAM_3()) {
        yajl_gen_string(g, (const unsigned char*)  "AUDIO_PROGRAM_3" , 15);
        yajl_gen_bool(g, (bool)value.getAUDIO_PROGRAM_3());
    }
    if (value.getAUDIO_PROGRAM_4()) {
        yajl_gen_string(g, (const unsigned char*)  "AUDIO_PROGRAM_4" , 15);
        yajl_gen_bool(g, (bool)value.getAUDIO_PROGRAM_4());
    }
    if (value.getRESERVED_1()) {
        yajl_gen_string(g, (const unsigned char*)  "RESERVED_1" , 10);
        yajl_gen_bool(g, (bool)value.getRESERVED_1());
    }
    if (value.getRESERVED_2()) {
        yajl_gen_string(g, (const unsigned char*)  "RESERVED_2" , 10);
        yajl_gen_bool(g, (bool)value.getRESERVED_2());
    }
    if (value.getRESERVED_3()) {
        yajl_gen_string(g, (const unsigned char*)  "RESERVED_3" , 10);
        yajl_gen_bool(g, (bool)value.getRESERVED_3());
    }
    if (value.getRESERVED_4()) {
        yajl_gen_string(g, (const unsigned char*)  "RESERVED_4" , 10);
        yajl_gen_bool(g, (bool)value.getRESERVED_4());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_b8_Tun_DRMNumberOfAudioServices& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TunerTestModeData_DDADDS"

void serializeJson (const ::tuner_main_fi_types::T_TunerTestModeData_DDADDS& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8PhysicalTuner()) {
        yajl_gen_string(g, (const unsigned char*)  "u8PhysicalTuner" , 15);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_PhysicalTuner_Name(value.getU8PhysicalTuner());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getU8PhysicalTuner());
    }
    if (!isSparse || value.hasU8Source()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Source" , 8);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_Testmode_TunerBand_Name(value.getU8Source());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getU8Source());
    }
    if (!isSparse || value.hasU32AFFrequency()) {
        yajl_gen_string(g, (const unsigned char*)  "u32AFFrequency" , 14);
        yajl_gen_integer(g, (long long)value.getU32AFFrequency());
    }
    if (!isSparse || value.hasU16CurrentPI()) {
        yajl_gen_string(g, (const unsigned char*)  "u16CurrentPI" , 12);
        yajl_gen_integer(g, (long long)value.getU16CurrentPI());
    }
    if (!isSparse || value.hasU16TargetPI()) {
        yajl_gen_string(g, (const unsigned char*)  "u16TargetPI" , 11);
        yajl_gen_integer(g, (long long)value.getU16TargetPI());
    }
    if (!isSparse || value.hasU8Quality()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Quality" , 9);
        yajl_gen_integer(g, (long long)value.getU8Quality());
    }
    if (!isSparse || value.hasU8Fieldstrength()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Fieldstrength" , 15);
        yajl_gen_integer(g, (long long)value.getU8Fieldstrength());
    }
    if (!isSparse || value.hasU8Multipath()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Multipath" , 11);
        yajl_gen_integer(g, (long long)value.getU8Multipath());
    }
    if (!isSparse || value.hasU8Neighbour()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Neighbour" , 11);
        yajl_gen_integer(g, (long long)value.getU8Neighbour());
    }
    if (!isSparse || value.hasU8AFListLength()) {
        yajl_gen_string(g, (const unsigned char*)  "u8AFListLength" , 14);
        yajl_gen_integer(g, (long long)value.getU8AFListLength());
    }
    if (!isSparse || value.hasU8HiCut()) {
        yajl_gen_string(g, (const unsigned char*)  "u8HiCut" , 7);
        yajl_gen_integer(g, (long long)value.getU8HiCut());
    }
    if (!isSparse || value.hasU8Sharx()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Sharx" , 7);
        yajl_gen_integer(g, (long long)value.getU8Sharx());
    }
    if (!isSparse || value.hasSCurrentStationName()) {
        yajl_gen_string(g, (const unsigned char*)  "sCurrentStationName" , 19);
        const char *s = value.getSCurrentStationName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSFixPSName()) {
        yajl_gen_string(g, (const unsigned char*)  "sFixPSName" , 10);
        const char *s = value.getSFixPSName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasBScrollPSStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "bScrollPSStatus" , 15);
        yajl_gen_bool(g, (bool)value.getBScrollPSStatus());
    }
    if (!isSparse || value.hasBAFStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "bAFStatus" , 9);
        yajl_gen_bool(g, (bool)value.getBAFStatus());
    }
    if (!isSparse || value.hasU8FMDeviation()) {
        yajl_gen_string(g, (const unsigned char*)  "u8FMDeviation" , 13);
        yajl_gen_integer(g, (long long)value.getU8FMDeviation());
    }
    if (!isSparse || value.hasU8RDSDeviation()) {
        yajl_gen_string(g, (const unsigned char*)  "u8RDSDeviation" , 14);
        yajl_gen_integer(g, (long long)value.getU8RDSDeviation());
    }
    if (!isSparse || value.hasS8IFOffset()) {
        yajl_gen_string(g, (const unsigned char*)  "s8IFOffset" , 10);
        yajl_gen_integer(g, (long long)value.getS8IFOffset());
    }
    if (!isSparse || value.hasS8RDSOffset()) {
        yajl_gen_string(g, (const unsigned char*)  "s8RDSOffset" , 11);
        yajl_gen_integer(g, (long long)value.getS8RDSOffset());
    }
    if (!isSparse || value.hasU8CoChannelStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "u8CoChannelStatus" , 17);
        yajl_gen_integer(g, (long long)value.getU8CoChannelStatus());
    }
    if (!isSparse || value.hasU8AGC()) {
        yajl_gen_string(g, (const unsigned char*)  "u8AGC" , 5);
        yajl_gen_integer(g, (long long)value.getU8AGC());
    }
    if (!isSparse || value.hasU8ChannelSeparation()) {
        yajl_gen_string(g, (const unsigned char*)  "u8ChannelSeparation" , 19);
        yajl_gen_integer(g, (long long)value.getU8ChannelSeparation());
    }
    if (!isSparse || value.hasU8RdsErrorRate()) {
        yajl_gen_string(g, (const unsigned char*)  "u8RdsErrorRate" , 14);
        yajl_gen_integer(g, (long long)value.getU8RdsErrorRate());
    }
    if (!isSparse || value.hasE8DiversityState()) {
        yajl_gen_string(g, (const unsigned char*)  "e8DiversityState" , 16);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_DiversityState_Name(value.getE8DiversityState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8DiversityState());
    }
    if (!isSparse || value.hasE8AntennaPathSwitch1()) {
        yajl_gen_string(g, (const unsigned char*)  "e8AntennaPathSwitch1" , 20);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_AntennaPathSwitch1_Name(value.getE8AntennaPathSwitch1());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8AntennaPathSwitch1());
    }
    if (!isSparse || value.hasE8AntennaPathSwitch2()) {
        yajl_gen_string(g, (const unsigned char*)  "e8AntennaPathSwitch2" , 20);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_AntennaPathSwitch2_Name(value.getE8AntennaPathSwitch2());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8AntennaPathSwitch2());
    }
    if (!isSparse || value.hasU8TestmodeBits()) {
        yajl_gen_string(g, (const unsigned char*)  "u8TestmodeBits" , 14);
        serializeJson(value.getU8TestmodeBits(), g, options);
    }
    if (!isSparse || value.hasU8HicutExtender()) {
        yajl_gen_string(g, (const unsigned char*)  "u8HicutExtender" , 15);
        yajl_gen_integer(g, (long long)value.getU8HicutExtender());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_TunerTestModeData_DDADDS& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TuningActionConfigParam"

void serializeJson (const ::tuner_main_fi_types::T_TuningActionConfigParam& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ConfigParamType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ConfigParamType" , 17);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_ConfigParam_Type_Name(value.getE8ConfigParamType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ConfigParamType());
    }
    if (!isSparse || value.hasU32ConfigParamValue()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ConfigParamValue" , 19);
        yajl_gen_integer(g, (long long)value.getU32ConfigParamValue());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_TuningActionConfigParam& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_b8_AnnoTypes"

void serializeJson (const ::tuner_main_fi_types::T_b8_AnnoTypes& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    if (value.getTP()) {
        yajl_gen_string(g, (const unsigned char*)  "TP" , 2);
        yajl_gen_bool(g, (bool)value.getTP());
    }
    if (value.getPTY()) {
        yajl_gen_string(g, (const unsigned char*)  "PTY" , 3);
        yajl_gen_bool(g, (bool)value.getPTY());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_b8_AnnoTypes& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_b8_Anno_Message"

void serializeJson (const ::tuner_main_fi_types::T_b8_Anno_Message& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    if (value.getTA()) {
        yajl_gen_string(g, (const unsigned char*)  "TA" , 2);
        yajl_gen_bool(g, (bool)value.getTA());
    }
    if (value.getPTY31()) {
        yajl_gen_string(g, (const unsigned char*)  "PTY31" , 5);
        yajl_gen_bool(g, (bool)value.getPTY31());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_b8_Anno_Message& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_AnnoInfostatus"

void serializeJson (const ::tuner_main_fi_types::T_AnnoInfostatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSAnnoStationName()) {
        yajl_gen_string(g, (const unsigned char*)  "sAnnoStationName" , 16);
        const char *s = value.getSAnnoStationName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU32Frequency()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Frequency" , 12);
        yajl_gen_integer(g, (long long)value.getU32Frequency());
    }
    if (!isSparse || value.hasU16PI()) {
        yajl_gen_string(g, (const unsigned char*)  "u16PI" , 5);
        yajl_gen_integer(g, (long long)value.getU16PI());
    }
    if (!isSparse || value.hasU8Quality()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Quality" , 9);
        yajl_gen_integer(g, (long long)value.getU8Quality());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_AnnoInfostatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_Tun_Engg_Param_List_Elem"

void serializeJson (const ::tuner_main_fi_types::T_Tun_Engg_Param_List_Elem& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ParameterID()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ParameterID" , 13);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_Engg_Param_ID_Name(value.getE8ParameterID());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ParameterID());
    }
    if (!isSparse || value.hasU32ParameterValue()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ParameterValue" , 17);
        yajl_gen_integer(g, (long long)value.getU32ParameterValue());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_Tun_Engg_Param_List_Elem& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_AvailableBandInfoElement"

void serializeJson (const ::tuner_main_fi_types::T_AvailableBandInfoElement& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8Band()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Band" , 6);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_TunerBand_Name(value.getE8Band());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Band());
    }
    if (!isSparse || value.hasU32HighFrequency()) {
        yajl_gen_string(g, (const unsigned char*)  "u32HighFrequency" , 16);
        yajl_gen_integer(g, (long long)value.getU32HighFrequency());
    }
    if (!isSparse || value.hasU32LowFrequency()) {
        yajl_gen_string(g, (const unsigned char*)  "u32LowFrequency" , 15);
        yajl_gen_integer(g, (long long)value.getU32LowFrequency());
    }
    if (!isSparse || value.hasU16AutoSeekStepWidth()) {
        yajl_gen_string(g, (const unsigned char*)  "u16AutoSeekStepWidth" , 20);
        yajl_gen_integer(g, (long long)value.getU16AutoSeekStepWidth());
    }
    if (!isSparse || value.hasU16ManualStepWidth()) {
        yajl_gen_string(g, (const unsigned char*)  "u16ManualStepWidth" , 18);
        yajl_gen_integer(g, (long long)value.getU16ManualStepWidth());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_AvailableBandInfoElement& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_b8_Tun_DemodSwitch"

void serializeJson (const ::tuner_main_fi_types::T_b8_Tun_DemodSwitch& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    if (value.getFM_AM()) {
        yajl_gen_string(g, (const unsigned char*)  "FM_AM" , 5);
        yajl_gen_bool(g, (bool)value.getFM_AM());
    }
    if (value.getFM_HD()) {
        yajl_gen_string(g, (const unsigned char*)  "FM_HD" , 5);
        yajl_gen_bool(g, (bool)value.getFM_HD());
    }
    if (value.getAM_HD()) {
        yajl_gen_string(g, (const unsigned char*)  "AM_HD" , 5);
        yajl_gen_bool(g, (bool)value.getAM_HD());
    }
    if (value.getDRM30()) {
        yajl_gen_string(g, (const unsigned char*)  "DRM30" , 5);
        yajl_gen_bool(g, (bool)value.getDRM30());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_b8_Tun_DemodSwitch& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TunerHDTestModeData"

void serializeJson (const ::tuner_main_fi_types::T_TunerHDTestModeData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8PhysicalTuner()) {
        yajl_gen_string(g, (const unsigned char*)  "e8PhysicalTuner" , 15);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_PhysicalTuner_Name(value.getE8PhysicalTuner());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8PhysicalTuner());
    }
    if (!isSparse || value.hasSHDCallSign()) {
        yajl_gen_string(g, (const unsigned char*)  "sHDCallSign" , 11);
        const char *s = value.getSHDCallSign().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU32HDStationId()) {
        yajl_gen_string(g, (const unsigned char*)  "u32HDStationId" , 14);
        yajl_gen_integer(g, (long long)value.getU32HDStationId());
    }
    if (!isSparse || value.hasB8HDAvailableAudioPrograms()) {
        yajl_gen_string(g, (const unsigned char*)  "b8HDAvailableAudioPrograms" , 26);
        serializeJson(value.getB8HDAvailableAudioPrograms(), g, options);
    }
    if (!isSparse || value.hasE8HDActiveAudioProgram()) {
        yajl_gen_string(g, (const unsigned char*)  "e8HDActiveAudioProgram" , 22);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_HDAudioProgram_Name(value.getE8HDActiveAudioProgram());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8HDActiveAudioProgram());
    }
    if (!isSparse || value.hasU8AudioQuality()) {
        yajl_gen_string(g, (const unsigned char*)  "u8AudioQuality" , 14);
        yajl_gen_integer(g, (long long)value.getU8AudioQuality());
    }
    if (!isSparse || value.hasB8HDStationInfoBits()) {
        yajl_gen_string(g, (const unsigned char*)  "b8HDStationInfoBits" , 19);
        serializeJson(value.getB8HDStationInfoBits(), g, options);
    }
    if (!isSparse || value.hasU8ACQStates()) {
        yajl_gen_string(g, (const unsigned char*)  "u8ACQStates" , 11);
        yajl_gen_integer(g, (long long)value.getU8ACQStates());
    }
    if (!isSparse || value.hasU8CD_NO()) {
        yajl_gen_string(g, (const unsigned char*)  "u8CD_NO" , 7);
        yajl_gen_integer(g, (long long)value.getU8CD_NO());
    }
    if (!isSparse || value.hasU8TransitionCount()) {
        yajl_gen_string(g, (const unsigned char*)  "u8TransitionCount" , 17);
        yajl_gen_integer(g, (long long)value.getU8TransitionCount());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_TunerHDTestModeData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_ImageFileInfo"

void serializeJson (const ::tuner_main_fi_types::T_ImageFileInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32HDStationId()) {
        yajl_gen_string(g, (const unsigned char*)  "u32HDStationId" , 14);
        yajl_gen_integer(g, (long long)value.getU32HDStationId());
    }
    if (!isSparse || value.hasE8HDImageType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8HDImageType" , 13);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_HDImageType_Name(value.getE8HDImageType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8HDImageType());
    }
    if (!isSparse || value.hasE8HDImageCoding()) {
        yajl_gen_string(g, (const unsigned char*)  "e8HDImageCoding" , 15);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_HDImageCoding_Name(value.getE8HDImageCoding());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8HDImageCoding());
    }
    if (!isSparse || value.hasE8HDAudioProgram()) {
        yajl_gen_string(g, (const unsigned char*)  "e8HDAudioProgram" , 16);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_HDAudioProgram_Name(value.getE8HDAudioProgram());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8HDAudioProgram());
    }
    if (!isSparse || value.hasU32NoOfImageFileBytes()) {
        yajl_gen_string(g, (const unsigned char*)  "u32NoOfImageFileBytes" , 21);
        yajl_gen_integer(g, (long long)value.getU32NoOfImageFileBytes());
    }
    if (!isSparse || value.hasImageFileBytes()) {
        yajl_gen_string(g, (const unsigned char*)  "ImageFileBytes" , 14);
        yajl_gen_array_open(g);
        const ::std::vector< uint8 >& o5 = value.getImageFileBytes();
        {
            ::std::vector< uint8 >::const_iterator o4;
            for (o4 = o5.begin(); o4 != o5.end(); ++o4) {
                yajl_gen_integer(g, (long long)(*o4));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_ImageFileInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TunPSDCommercial"

void serializeJson (const ::tuner_main_fi_types::T_TunPSDCommercial& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSPriceString()) {
        yajl_gen_string(g, (const unsigned char*)  "sPriceString" , 12);
        const char *s = value.getSPriceString().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSValidUntil()) {
        yajl_gen_string(g, (const unsigned char*)  "sValidUntil" , 11);
        const char *s = value.getSValidUntil().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSContactURL()) {
        yajl_gen_string(g, (const unsigned char*)  "sContactURL" , 11);
        const char *s = value.getSContactURL().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSReceivedAs()) {
        yajl_gen_string(g, (const unsigned char*)  "sReceivedAs" , 11);
        const char *s = value.getSReceivedAs().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSNameOfSeller()) {
        yajl_gen_string(g, (const unsigned char*)  "sNameOfSeller" , 13);
        const char *s = value.getSNameOfSeller().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSDescription()) {
        yajl_gen_string(g, (const unsigned char*)  "sDescription" , 12);
        const char *s = value.getSDescription().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_TunPSDCommercial& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TunPSDComment"

void serializeJson (const ::tuner_main_fi_types::T_TunPSDComment& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSLanguage()) {
        yajl_gen_string(g, (const unsigned char*)  "sLanguage" , 9);
        const char *s = value.getSLanguage().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSShortContentDescription()) {
        yajl_gen_string(g, (const unsigned char*)  "sShortContentDescription" , 24);
        const char *s = value.getSShortContentDescription().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSActualText()) {
        yajl_gen_string(g, (const unsigned char*)  "sActualText" , 11);
        const char *s = value.getSActualText().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_TunPSDComment& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TunPSDData"

void serializeJson (const ::tuner_main_fi_types::T_TunPSDData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8HDAudioProgram()) {
        yajl_gen_string(g, (const unsigned char*)  "e8HDAudioProgram" , 16);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_HDAudioProgram_Name(value.getE8HDAudioProgram());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8HDAudioProgram());
    }
    if (!isSparse || value.hasSTitle()) {
        yajl_gen_string(g, (const unsigned char*)  "sTitle" , 6);
        const char *s = value.getSTitle().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSArtist()) {
        yajl_gen_string(g, (const unsigned char*)  "sArtist" , 7);
        const char *s = value.getSArtist().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSAlbum()) {
        yajl_gen_string(g, (const unsigned char*)  "sAlbum" , 6);
        const char *s = value.getSAlbum().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSGenre()) {
        yajl_gen_string(g, (const unsigned char*)  "sGenre" , 6);
        const char *s = value.getSGenre().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasTunPSDCommercial()) {
        yajl_gen_string(g, (const unsigned char*)  "TunPSDCommercial" , 16);
        serializeJson(value.getTunPSDCommercial(), g, options);
    }
    if (!isSparse || value.hasTunPSDComment()) {
        yajl_gen_string(g, (const unsigned char*)  "TunPSDComment" , 13);
        serializeJson(value.getTunPSDComment(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_TunPSDData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_CalibrationData"

void serializeJson (const ::tuner_main_fi_types::T_CalibrationData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPhysicalTunerOne()) {
        yajl_gen_string(g, (const unsigned char*)  "PhysicalTunerOne" , 16);
        serializeJson(value.getPhysicalTunerOne(), g, options);
    }
    if (!isSparse || value.hasPhysicalTunerTwo()) {
        yajl_gen_string(g, (const unsigned char*)  "PhysicalTunerTwo" , 16);
        serializeJson(value.getPhysicalTunerTwo(), g, options);
    }
    if (!isSparse || value.hasPhysicalTunerThree()) {
        yajl_gen_string(g, (const unsigned char*)  "PhysicalTunerThree" , 18);
        serializeJson(value.getPhysicalTunerThree(), g, options);
    }
    if (!isSparse || value.hasPhysicalTunerFour()) {
        yajl_gen_string(g, (const unsigned char*)  "PhysicalTunerFour" , 17);
        serializeJson(value.getPhysicalTunerFour(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_CalibrationData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_PhysicalTunerCalibData"

void serializeJson (const ::tuner_main_fi_types::T_PhysicalTunerCalibData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasB8AvailableBands()) {
        yajl_gen_string(g, (const unsigned char*)  "b8AvailableBands" , 16);
        serializeJson(value.getB8AvailableBands(), g, options);
    }
    if (!isSparse || value.hasU16FMCalibrationValue()) {
        yajl_gen_string(g, (const unsigned char*)  "u16FMCalibrationValue" , 21);
        yajl_gen_integer(g, (long long)value.getU16FMCalibrationValue());
    }
    if (!isSparse || value.hasU16AMCalibrationValue()) {
        yajl_gen_string(g, (const unsigned char*)  "u16AMCalibrationValue" , 21);
        yajl_gen_integer(g, (long long)value.getU16AMCalibrationValue());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_PhysicalTunerCalibData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TunerJapanStationName"

void serializeJson (const ::tuner_main_fi_types::T_TunerJapanStationName& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU16IndexID()) {
        yajl_gen_string(g, (const unsigned char*)  "u16IndexID" , 10);
        yajl_gen_integer(g, (long long)value.getU16IndexID());
    }
    if (!isSparse || value.hasSJapanStationName()) {
        yajl_gen_string(g, (const unsigned char*)  "sJapanStationName" , 17);
        const char *s = value.getSJapanStationName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_TunerJapanStationName& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_DARCDataBlock"

void serializeJson (const ::tuner_main_fi_types::T_DARCDataBlock& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSTAT_Status_Register()) {
        yajl_gen_string(g, (const unsigned char*)  "STAT_Status_Register" , 20);
        serializeJson(value.getSTAT_Status_Register(), g, options);
    }
    if (!isSparse || value.hasBlock_Number_Register()) {
        yajl_gen_string(g, (const unsigned char*)  "Block_Number_Register" , 21);
        yajl_gen_integer(g, (long long)value.getBlock_Number_Register());
    }
    if (!isSparse || value.hasDARCDataList()) {
        yajl_gen_string(g, (const unsigned char*)  "DARCDataList" , 12);
        yajl_gen_array_open(g);
        const ::std::vector< uint8 >& o7 = value.getDARCDataList();
        {
            ::std::vector< uint8 >::const_iterator o6;
            for (o6 = o7.begin(); o6 != o7.end(); ++o6) {
                yajl_gen_integer(g, (long long)(*o6));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_DARCDataBlock& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_b8_Tun_STATStatusRegister"

void serializeJson (const ::tuner_main_fi_types::T_b8_Tun_STATStatusRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    if (value.getReserved()) {
        yajl_gen_string(g, (const unsigned char*)  "Reserved" , 8);
        yajl_gen_bool(g, (bool)value.getReserved());
    }
    if (value.getSTAT_CRC4()) {
        yajl_gen_string(g, (const unsigned char*)  "STAT_CRC4" , 9);
        yajl_gen_bool(g, (bool)value.getSTAT_CRC4());
    }
    if (value.getSTAT_HEAD()) {
        yajl_gen_string(g, (const unsigned char*)  "STAT_HEAD" , 9);
        yajl_gen_bool(g, (bool)value.getSTAT_HEAD());
    }
    if (value.getSTAT_PRI()) {
        yajl_gen_string(g, (const unsigned char*)  "STAT_PRI" , 8);
        yajl_gen_bool(g, (bool)value.getSTAT_PRI());
    }
    if (value.getSTAT_ERR()) {
        yajl_gen_string(g, (const unsigned char*)  "STAT_ERR" , 8);
        yajl_gen_bool(g, (bool)value.getSTAT_ERR());
    }
    if (value.getSTAT_FRM()) {
        yajl_gen_string(g, (const unsigned char*)  "STAT_FRM" , 8);
        yajl_gen_bool(g, (bool)value.getSTAT_FRM());
    }
    if (value.getSTAT_BLK()) {
        yajl_gen_string(g, (const unsigned char*)  "STAT_BLK" , 8);
        yajl_gen_bool(g, (bool)value.getSTAT_BLK());
    }
    if (value.getSTAT_VH()) {
        yajl_gen_string(g, (const unsigned char*)  "STAT_VH" , 7);
        yajl_gen_bool(g, (bool)value.getSTAT_VH());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_b8_Tun_STATStatusRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TunerListElement"

void serializeJson (const ::tuner_main_fi_types::T_TunerListElement& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ListID()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ListID" , 8);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_ListID_Name(value.getE8ListID());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ListID());
    }
    if (!isSparse || value.hasU8ElementID()) {
        yajl_gen_string(g, (const unsigned char*)  "u8ElementID" , 11);
        yajl_gen_integer(g, (long long)value.getU8ElementID());
    }
    if (!isSparse || value.hasE8Modulation()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Modulation" , 12);
        const char* s = ::tuner_main_fi_types::T_e8_Tun_ModulationType_Name(value.getE8Modulation());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Modulation());
    }
    if (!isSparse || value.hasU32Frequency()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Frequency" , 12);
        yajl_gen_integer(g, (long long)value.getU32Frequency());
    }
    if (!isSparse || value.hasU32SID()) {
        yajl_gen_string(g, (const unsigned char*)  "u32SID" , 6);
        yajl_gen_integer(g, (long long)value.getU32SID());
    }
    if (!isSparse || value.hasU8NumOfCharactersInStationName()) {
        yajl_gen_string(g, (const unsigned char*)  "u8NumOfCharactersInStationName" , 30);
        yajl_gen_integer(g, (long long)value.getU8NumOfCharactersInStationName());
    }
    if (!isSparse || value.hasSStationName()) {
        yajl_gen_string(g, (const unsigned char*)  "sStationName" , 12);
        const char *s = value.getSStationName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU8StationNameEncoding()) {
        yajl_gen_string(g, (const unsigned char*)  "u8StationNameEncoding" , 21);
        yajl_gen_integer(g, (long long)value.getU8StationNameEncoding());
    }
    if (!isSparse || value.hasU8ProgramService()) {
        yajl_gen_string(g, (const unsigned char*)  "u8ProgramService" , 16);
        yajl_gen_integer(g, (long long)value.getU8ProgramService());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tuner_main_fi_types::T_TunerListElement& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_b8_Tun_AFSwitch& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_b8_Tun_AudioSink& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_b8_Tun_AtStationInfoBits& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_b8_Tun_Tunerbandbits& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_Audio_FG_BG& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_u16CalibrationData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_Aud_FGBG_New& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_AudFGBGStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_TunerServer_StatusResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_b32_Tun_AvailFlags& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_b32_Tun_Features& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_b8_Tun_Antenna& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_TunerStationData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_TunerFeature& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_b32_Tun_AvailableFlags& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_TunerManualSingleStep& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_b8_Tun_OperationFlags& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_TunerOperation& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_TunerAFList& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_b8_Tun_TestmodeBits& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_TunerTestModeData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_Sel_List_Elem& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_Tun_MakeConfigList& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_b8_Tun_Digital_Filters& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_Encryption& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_MsgSource& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_Tun_RDBID_Value& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_TunerRdbId& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_TunerGetDataTMC& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_TrafficInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_b8_Tun_PackedInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_MakeConfigListElem& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_b8_Tun_AvailFlags& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_TunerConfigListElement& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_b8_Tun_StationInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_b8_Tun_HDNumOfAudioPrograms& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_Tun_Set_PI& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_TunerStaticListElement& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_TunerTestRoutineParameter& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_Tun_TestTroubleCodeStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_TunerFieldstrength& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_TunerRadioText& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_TunerBandAndStationInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_Tun_AutoCompParam& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_Component_Status& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_Atstationinfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_b8_Tun_HDInfoBits& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_b8_Tun_HDPrgmAvail& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_b8_Tun_DRMStationInfoBits& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_b16_Tun_DRMAnnouBits& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_b8_Tun_DRMNumberOfAudioServices& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_TunerTestModeData_DDADDS& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_TuningActionConfigParam& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_b8_AnnoTypes& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_b8_Anno_Message& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_AnnoInfostatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_Tun_Engg_Param_List_Elem& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_AvailableBandInfoElement& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_b8_Tun_DemodSwitch& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_TunerHDTestModeData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_ImageFileInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_TunPSDCommercial& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_TunPSDComment& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_TunPSDData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_CalibrationData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_PhysicalTunerCalibData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_TunerJapanStationName& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_DARCDataBlock& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_b8_Tun_STATStatusRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types
using namespace ::asf::stream::json;

namespace tuner_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tuner_main_fi_types::T_TunerListElement& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tuner_main_fi_types

