#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef TUNER_MAIN_FI_H
#define TUNER_MAIN_FI_H

#include "asf/cca/CcaTypes.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "tuner_main_fi_types.h"
#include "tuner_main_fi_typesConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * CCA Functional Interface 'tuner_main_fi'
 *
 * Fullname: Middleware Tuner Server Functional Interface
 *
 * Version: $Revision:   1.0  $
 *
 * Author: Kalyani R
 *
 * Date: $Date:   Sep 03 2013  $
 *
 * Department:
 *
 * Title: tuner_main_fi
 *
 * <b>Description of 'tuner_main_fi':</b>
 */

namespace tuner_main_fi {

static const int SERVICE_ID = 264;

static const int FID_FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADER = 1024;

static const int FID_FID_TUN_S_ATFREQUENCY = 64;

static const int FID_FID_TUN_S_ATSEEK_WITH_TUNERHEADER = 70;

static const int FID_FID_S_TUN_GET_FIELD_STRENGTH = 6;

static const int FID_FID_TUN_S_SET_ACTIVE_PRESETLIST = 278;

static const int FID_FID_TUN_S_SET_FEATURE = 118;

static const int FID_FID_TUN_S_SET_HICUT = 122;

static const int FID_FID_TUN_S_AFLIST_V2 = 92;

static const int FID_FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2 = 94;

static const int FID_FID_TUN_S_DIRECT_FREQUENCY = 50;

static const int FID_FID_TUN_S_AUTOSTORE = 130;

static const int FID_FID_TUN_S_SEL_LIST_ELEM = 134;

static const int FID_FID_TUN_S_GET_CONFIG_LIST = 140;

static const int FID_FID_TUN_S_AUDIO_FG_BG_NEW = 240;

static const int FID_FID_TUN_S_SET_PI = 66;

static const int FID_FID_TUN_S_SET_SHARXLEVEL = 166;

static const int FID_FID_TUN_S_GET_STATIC_LIST = 150;

static const int FID_FID_TUN_S_SETUP_DDADDS = 178;

static const int FID_FID_TUN_S_PRESET_HANDLING = 369;

static const int FID_FID_TUN_S_PS_FREEZE = 168;

static const int FID_FID_TUN_S_SET_AUTOCOMP_PARAM = 58;

static const int FID_FID_TUN_S_SET_RDBID = 156;

static const int FID_FID_TUN_S_CALIBRATION_DATA = 3;

static const int FID_FID_TUN_S_ACTIVE_TUNER = 4;

static const int FID_FID_TUN_S_STATIONLIST_EXIT = 5;

static const int FID_FID_TUN_S_SURVEIL_TP = 370;

static const int FID_FID_TUN_S_SET_ENGG_PARAMETER = 371;

static const int FID_FID_TUN_S_ANNOUNCEMENT_SWITCH = 374;

static const int FID_FID_TUN_S_ANNOUNCEMENT_ESCAPE = 375;

static const int FID_FID_TUN_S_PRESET_STORAGE_PS_FREEZE = 376;

static const int FID_FID_TUN_S_SPEED_INFO = 378;

static const int FID_FID_TUN_S_AUDIO_MUTEREQUEST = 394;

static const int FID_FID_TUN_S_CONFIGLIST_UPDATE = 379;

static const int FID_FID_TUN_S_DEFAULT_SETTING = 380;

static const int FID_FID_TUN_S_SET_DEMODULATION_SWITCH = 8;

static const int FID_FID_TUN_S_SELECT_DRM_AUDIOPRGM = 9;

static const int FID_FID_TUN_S_AUDIO_DEVICE = 10;

static const int FID_FID_TUN_S_SET_DRM_SRCACTIVITY = 12;

static const int FID_FID_TUN_S_SET_TESTMODE = 14;

static const int FID_FID_TUN_S_SELECT_HD_AUDIOPRGM = 513;

static const int FID_FID_TUN_S_SEL_HD_AUDIOPRGMDIRECT = 521;

static const int FID_FID_TUN_S_HD_RESET_TRANSITIONCOUNT = 528;

static const int FID_FID_TUN_S_SET_AUDIO_SPLIT_MODE = 529;

static const int FID_FID_TUN_S_SET_HD_SECTION_PARAMETER = 534;

static const int FID_FID_TUN_S_DRM_TESTMODE = 770;

static const int FID_FID_TUN_S_DRM_RESET_MUTECOUNTER = 775;

static const int FID_FID_TUN_S_SET_AF = 771;

static const int FID_FID_TUN_S_CHANGE_LSM = 772;

static const int FID_FID_TUN_S_DARC_NO_VICS_DATA_AVAILABLE = 773;

static const int FID_FID_TUN_S_DARC_VICS_FREQUENCY_LIST = 774;

static const int FID_FID_TUN_S_JAPAN_SET_AREA = 384;

static const int FID_FID_TUN_S_JAPAN_CHANGE_STATION_NAME = 386;

static const int FID_FID_TUN_S_LANGUAGE_SETTING = 387;

static const int FID_FID_TUN_S_JAPAN_SELECT_STATION_NAME = 392;

static const int FID_FID_TUN_S_USER_PROFILE_UPDATE = 388;

static const int FID_FID_TUN_S_PRESETLIST_CONTENT_UPDATE = 389;

static const int FID_FID_TUN_S_DISABLE_BAND = 13;

static const int FID_FID_TUN_G_CALIBRATION_DATA = 69;

static const int FID_FID_TUN_G_SET_FEATURE = 119;

static const int FID_FID_TUN_G_SET_HICUT = 123;

static const int FID_FID_TUN_G_AFLIST_V2 = 93;

static const int FID_FID_TUN_G_GET_CONFIG_LIST = 145;

static const int FID_FID_TUN_G_SET_SHARXLEVEL = 167;

static const int FID_FID_TUN_G_SET_DDA = 165;

static const int FID_FID_TUN_G_SET_AF = 164;

static const int FID_FID_TUN_G_SET_MEASUREMODE = 162;

static const int FID_FID_TUN_G_SET_RDSREG = 163;

static const int FID_FID_TUN_G_GET_STATIC_LIST = 151;

static const int FID_FID_TUN_G_RADIO_TEXT = 87;

static const int FID_FID_TUN_G_BAND_PLUS_STATION_INFO = 257;

static const int FID_FID_TUN_G_SETUP_DDADDS = 179;

static const int FID_FID_TUN_G_GET_DATA_TESTMODE_DDADDS = 304;

static const int FID_FID_TUN_G_TMC_INFO = 170;

static const int FID_FID_TUN_G_GET_DATA_TMC = 83;

static const int FID_FID_TUN_G_ATSTATIONINFO = 147;

static const int FID_FID_TUN_G_ATSEEK = 149;

static const int FID_FID_TUN_G_DIAG_REMOTE_CONTROL = 68;

static const int FID_FID_TUN_G_RdbIdActualList = 7;

static const int FID_FID_TUN_G_SET_RDS = 102;

static const int FID_FID_TUN_G_SET_ENGG_PARAMETER = 103;

static const int FID_FID_TUN_G_SET_TUNING_ACTION_CONFIG = 104;

static const int FID_FID_TUN_G_ANNOUNCEMENT_MESSAGE = 105;

static const int FID_FID_TUN_G_ANNOUNCEMENT_INFO = 112;

static const int FID_FID_TUN_G_ANNOUNCEMENT_SWITCH = 113;

static const int FID_FID_TUN_G_PI_PS_RELATION = 114;

static const int FID_FID_TUN_G_AVAILABLE_BAND_RANGE = 115;

static const int FID_FID_TUN_G_MUTE_REQUEST = 116;

static const int FID_FID_TUN_G_UPDATELANDSCAPE_PROGRESS = 117;

static const int FID_FID_TUN_G_DRM_RADIO_TEXT = 11;

static const int FID_FID_TUN_G_ATPISEARCH = 129;

static const int FID_FID_TUN_G_HD_AUDIOPRGM = 514;

static const int FID_FID_TUN_G_HD_PSD_DATA = 515;

static const int FID_FID_TUN_G_HD_TEST_MODE_DATA = 516;

static const int FID_FID_TUN_G_HD_AVISORY_INFO = 517;

static const int FID_FID_TUN_G_DEMODULATION_SWITCH_STATUS = 518;

static const int FID_FID_TUN_G_AUDIO_SPLIT_MODE = 530;

static const int FID_FID_TUN_G_HD_SECTION_PARAMETER = 535;

static const int FID_FID_TUN_G_DRM_TESTMODE = 769;

static const int FID_FID_TUN_G_HD_LONGNAME = 519;

static const int FID_FID_TUN_G_HD_IMAGEFILE_UPDATE = 520;

static const int FID_FID_TUN_G_HD_SIGNALLOST_TIMER = 536;

static const int FID_FID_TUN_G_SURVIELLANCE_LISTUPDATE = 531;

static const int FID_FID_TUN_G_LISTUPDATE_NOTIFICATION = 532;

static const int FID_FID_TUN_G_GET_DARC_DATA = 533;

static const int FID_FID_TUN_G_JAPAN_AREA = 385;

static const int FID_FID_TUN_G_GET_ACTIVE_PRESETLISTID = 390;

static const int FID_FID_TUN_G_JAPAN_STATION_NAME_LIST = 391;


ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 3;

static const int VERSION_MINOR = 1;

static const int VERSION_PATCH = 0;

// forward declarations
class FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERStart;

class FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERResult;

class FID_TUN_S_ATFREQUENCYStart;

class FID_TUN_S_ATFREQUENCYResult;

class FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart;

class FID_TUN_S_ATSEEK_WITH_TUNERHEADERResult;

class FID_S_TUN_GET_FIELD_STRENGTHResult;

class FID_TUN_S_SET_ACTIVE_PRESETLISTStart;

class FID_TUN_S_SET_ACTIVE_PRESETLISTResult;

class FID_TUN_S_SET_FEATUREStart;

class FID_TUN_S_SET_FEATUREResult;

class FID_TUN_S_SET_HICUTStart;

class FID_TUN_S_SET_HICUTResult;

class FID_TUN_S_AFLIST_V2Start;

class FID_TUN_S_AFLIST_V2Result;

class FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start;

class FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Result;

class FID_TUN_S_DIRECT_FREQUENCYStart;

class FID_TUN_S_DIRECT_FREQUENCYResult;

class FID_TUN_S_AUTOSTOREStart;

class FID_TUN_S_AUTOSTOREResult;

class FID_TUN_S_SEL_LIST_ELEMStart;

class FID_TUN_S_SEL_LIST_ELEMResult;

class FID_TUN_S_GET_CONFIG_LISTStart;

class FID_TUN_S_GET_CONFIG_LISTResult;

class FID_TUN_S_AUDIO_FG_BG_NEWStart;

class FID_TUN_S_AUDIO_FG_BG_NEWResult;

class FID_TUN_S_SET_PIStart;

class FID_TUN_S_SET_PIResult;

class FID_TUN_S_SET_SHARXLEVELStart;

class FID_TUN_S_SET_SHARXLEVELResult;

class FID_TUN_S_GET_STATIC_LISTStart;

class FID_TUN_S_GET_STATIC_LISTResult;

class FID_TUN_S_SETUP_DDADDSStart;

class FID_TUN_S_SETUP_DDADDSResult;

class FID_TUN_S_PRESET_HANDLINGStart;

class FID_TUN_S_PRESET_HANDLINGResult;

class FID_TUN_S_PS_FREEZEStart;

class FID_TUN_S_PS_FREEZEResult;

class FID_TUN_S_SET_AUTOCOMP_PARAMStart;

class FID_TUN_S_SET_AUTOCOMP_PARAMResult;

class FID_TUN_S_SET_RDBIDStart;

class FID_TUN_S_SET_RDBIDResult;

class FID_TUN_S_CALIBRATION_DATAResult;

class FID_TUN_S_ACTIVE_TUNERResult;

class FID_TUN_S_STATIONLIST_EXITStart;

class FID_TUN_S_STATIONLIST_EXITResult;

class FID_TUN_S_SURVEIL_TPStart;

class FID_TUN_S_SURVEIL_TPResult;

class FID_TUN_S_SET_ENGG_PARAMETERStart;

class FID_TUN_S_SET_ENGG_PARAMETERResult;

class FID_TUN_S_ANNOUNCEMENT_SWITCHStart;

class FID_TUN_S_ANNOUNCEMENT_SWITCHResult;

class FID_TUN_S_ANNOUNCEMENT_ESCAPEStart;

class FID_TUN_S_ANNOUNCEMENT_ESCAPEResult;

class FID_TUN_S_PRESET_STORAGE_PS_FREEZEStart;

class FID_TUN_S_PRESET_STORAGE_PS_FREEZEResult;

class FID_TUN_S_SPEED_INFOStart;

class FID_TUN_S_SPEED_INFOResult;

class FID_TUN_S_AUDIO_MUTEREQUESTResult;

class FID_TUN_S_CONFIGLIST_UPDATEStart;

class FID_TUN_S_CONFIGLIST_UPDATEResult;

class FID_TUN_S_DEFAULT_SETTINGStart;

class FID_TUN_S_DEFAULT_SETTINGResult;

class FID_TUN_S_SET_DEMODULATION_SWITCHStart;

class FID_TUN_S_SET_DEMODULATION_SWITCHResult;

class FID_TUN_S_SELECT_DRM_AUDIOPRGMStart;

class FID_TUN_S_SELECT_DRM_AUDIOPRGMResult;

class FID_TUN_S_AUDIO_DEVICEStart;

class FID_TUN_S_AUDIO_DEVICEResult;

class FID_TUN_S_SET_DRM_SRCACTIVITYStart;

class FID_TUN_S_SET_DRM_SRCACTIVITYResult;

class FID_TUN_S_SET_TESTMODEStart;

class FID_TUN_S_SET_TESTMODEResult;

class FID_TUN_S_SELECT_HD_AUDIOPRGMStart;

class FID_TUN_S_SELECT_HD_AUDIOPRGMResult;

class FID_TUN_S_SEL_HD_AUDIOPRGMDIRECTStart;

class FID_TUN_S_SEL_HD_AUDIOPRGMDIRECTResult;

class FID_TUN_S_SET_AUDIO_SPLIT_MODEStart;

class FID_TUN_S_SET_AUDIO_SPLIT_MODEResult;

class FID_TUN_S_SET_HD_SECTION_PARAMETERStart;

class FID_TUN_S_SET_HD_SECTION_PARAMETERResult;

class FID_TUN_S_DRM_TESTMODEStart;

class FID_TUN_S_DRM_TESTMODEResult;

class FID_TUN_S_DRM_RESET_MUTECOUNTERResult;

class FID_TUN_S_SET_AFStart;

class FID_TUN_S_SET_AFResult;

class FID_TUN_S_CHANGE_LSMStart;

class FID_TUN_S_CHANGE_LSMResult;

class FID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEResult;

class FID_TUN_S_DARC_VICS_FREQUENCY_LISTStart;

class FID_TUN_S_DARC_VICS_FREQUENCY_LISTResult;

class FID_TUN_S_JAPAN_SET_AREAStart;

class FID_TUN_S_JAPAN_SET_AREAResult;

class FID_TUN_S_JAPAN_CHANGE_STATION_NAMEStart;

class FID_TUN_S_JAPAN_CHANGE_STATION_NAMEResult;

class FID_TUN_S_LANGUAGE_SETTINGStart;

class FID_TUN_S_LANGUAGE_SETTINGResult;

class FID_TUN_S_JAPAN_SELECT_STATION_NAMEStart;

class FID_TUN_S_JAPAN_SELECT_STATION_NAMEResult;

class FID_TUN_S_USER_PROFILE_UPDATEStart;

class FID_TUN_S_USER_PROFILE_UPDATEResult;

class FID_TUN_S_PRESETLIST_CONTENT_UPDATEStart;

class FID_TUN_S_PRESETLIST_CONTENT_UPDATEResult;

class FID_TUN_S_DISABLE_BANDStart;

class FID_TUN_S_DISABLE_BANDResult;

class FID_TUN_G_CALIBRATION_DATAStatus;

class FID_TUN_G_SET_FEATUREStatus;

class FID_TUN_G_SET_HICUTStatus;

class FID_TUN_G_AFLIST_V2Status;

class FID_TUN_G_GET_CONFIG_LISTStatus;

class FID_TUN_G_GET_CONFIG_LISTGet;

class FID_TUN_G_SET_SHARXLEVELStatus;

class FID_TUN_G_SET_DDAStatus;

class FID_TUN_G_SET_AFStatus;

class FID_TUN_G_SET_MEASUREMODEStatus;

class FID_TUN_G_SET_RDSREGStatus;

class FID_TUN_G_GET_STATIC_LISTStatus;

class FID_TUN_G_RADIO_TEXTStatus;

class FID_TUN_G_BAND_PLUS_STATION_INFOStatus;

class FID_TUN_G_SETUP_DDADDSStatus;

class FID_TUN_G_GET_DATA_TESTMODE_DDADDSStatus;

class FID_TUN_G_TMC_INFOStatus;

class FID_TUN_G_GET_DATA_TMCStatus;

class FID_TUN_G_ATSTATIONINFOStatus;

class FID_TUN_G_ATSEEKStatus;

class FID_TUN_G_DIAG_REMOTE_CONTROLStatus;

class FID_TUN_G_RdbIdActualListStatus;

class FID_TUN_G_SET_RDSStatus;

class FID_TUN_G_SET_ENGG_PARAMETERStatus;

class FID_TUN_G_SET_ENGG_PARAMETERGet;

class FID_TUN_G_SET_TUNING_ACTION_CONFIGStatus;

class FID_TUN_G_SET_TUNING_ACTION_CONFIGGet;

class FID_TUN_G_ANNOUNCEMENT_MESSAGEStatus;

class FID_TUN_G_ANNOUNCEMENT_INFOStatus;

class FID_TUN_G_ANNOUNCEMENT_SWITCHStatus;

class FID_TUN_G_PI_PS_RELATIONStatus;

class FID_TUN_G_AVAILABLE_BAND_RANGEStatus;

class FID_TUN_G_MUTE_REQUESTStatus;

class FID_TUN_G_UPDATELANDSCAPE_PROGRESSStatus;

class FID_TUN_G_DRM_RADIO_TEXTStatus;

class FID_TUN_G_ATPISEARCHStatus;

class FID_TUN_G_HD_AUDIOPRGMStatus;

class FID_TUN_G_HD_PSD_DATAStatus;

class FID_TUN_G_HD_TEST_MODE_DATAStatus;

class FID_TUN_G_HD_AVISORY_INFOStatus;

class FID_TUN_G_DEMODULATION_SWITCH_STATUSStatus;

class FID_TUN_G_AUDIO_SPLIT_MODEStatus;

class FID_TUN_G_HD_SECTION_PARAMETERStatus;

class FID_TUN_G_HD_SECTION_PARAMETERGet;

class FID_TUN_G_DRM_TESTMODEStatus;

class FID_TUN_G_HD_LONGNAMEStatus;

class FID_TUN_G_HD_LONGNAMEGet;

class FID_TUN_G_HD_IMAGEFILE_UPDATEStatus;

class FID_TUN_G_HD_SIGNALLOST_TIMERStatus;

class FID_TUN_G_SURVIELLANCE_LISTUPDATEStatus;

class FID_TUN_G_SURVIELLANCE_LISTUPDATEGet;

class FID_TUN_G_LISTUPDATE_NOTIFICATIONStatus;

class FID_TUN_G_GET_DARC_DATAStatus;

class FID_TUN_G_JAPAN_AREAStatus;

class FID_TUN_G_GET_ACTIVE_PRESETLISTIDStatus;

class FID_TUN_G_JAPAN_STATION_NAME_LISTStatus;

// type definitions
/**
 * The abort error message of the method "FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADER"
 * Radio frequency can be manually adjusted in steps in the upward / downward direction.
 * FM: 87.5 - 108 MHz, Step 100 KHz, MW: 531 - 1620 kHz, Step 9 kHz, LW: 153 - 279 kHz, Step 3 kHz.
 * This is currently not used. It is just retained for removing the
 * build error till the FID is ported into HMI.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERAbortError;

/**
 * The error message of 'FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADER'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERError;

/**
 * The abort error message of the method "FID_TUN_S_ATFREQUENCY"
 * Radio frequency can be manually adjusted in steps in the upward / downward direction.
 * FM: 87.5 - 108 MHz, Step 100 KHz, MW: 531 - 1620 kHz, Step 9 kHz, LW: 153 - 279 kHz, Step 3 kHz.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_ATFREQUENCYAbortError;

/**
 * The error message of 'FID_TUN_S_ATFREQUENCY'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_ATFREQUENCYError;

/**
 * The abort error message of the method "FID_TUN_S_ATSEEK_WITH_TUNERHEADER"
 * With this command, different seeks can be started on
 * either Tuner1 or Tuner2.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_ATSEEK_WITH_TUNERHEADERAbortError;

/**
 * The error message of 'FID_TUN_S_ATSEEK_WITH_TUNERHEADER'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_ATSEEK_WITH_TUNERHEADERError;

/**
 * The start message of the method "FID_S_TUN_GET_FIELD_STRENGTH"
 * Through this method, FC_Diagnosis can ask for the current field strength.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_S_TUN_GET_FIELD_STRENGTHStart;

/**
 * The abort error message of the method "FID_S_TUN_GET_FIELD_STRENGTH"
 * Through this method, FC_Diagnosis can ask for the current field strength.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_S_TUN_GET_FIELD_STRENGTHAbortError;

/**
 * The error message of 'FID_S_TUN_GET_FIELD_STRENGTH'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_S_TUN_GET_FIELD_STRENGTHError;

/**
 * The abort error message of the method "FID_TUN_S_SET_ACTIVE_PRESETLIST"
 * With this command, Mixed preset  list can be selected.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_SET_ACTIVE_PRESETLISTAbortError;

/**
 * The error message of 'FID_TUN_S_SET_ACTIVE_PRESETLIST'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_SET_ACTIVE_PRESETLISTError;

/**
 * The abort error message of the method "FID_TUN_S_SET_FEATURE"
 * Tuner features can be switched ON OR OFF.
 * Note: This fi is to be used for one feature at a time.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_SET_FEATUREAbortError;

/**
 * The error message of 'FID_TUN_S_SET_FEATURE'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_SET_FEATUREError;

/**
 * The abort error message of the method "FID_TUN_S_SET_HICUT"
 * This method is used to set HICUT level.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_SET_HICUTAbortError;

/**
 * The error message of 'FID_TUN_S_SET_HICUT'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_SET_HICUTError;

/**
 * The abort error message of the method "FID_TUN_S_AFLIST_V2"
 * This method is used to get the contents of the Af-List and notifying a continuous update if the testmode is
 * enabled.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_AFLIST_V2AbortError;

/**
 * The error message of 'FID_TUN_S_AFLIST_V2'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_AFLIST_V2Error;

/**
 * The abort error message of the method "FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2"
 * This method is used to Select an element from Af-List.
 * While selecting element mode should be AFJUMP OFF.
 * While leaving TestMode this method should be called again with mode = AFJUMP ON
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2AbortError;

/**
 * The error message of 'FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Error;

/**
 * The abort error message of the method "FID_TUN_S_DIRECT_FREQUENCY"
 * This method is used to set the frequency directly input by the user.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_DIRECT_FREQUENCYAbortError;

/**
 * The error message of 'FID_TUN_S_DIRECT_FREQUENCY'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_DIRECT_FREQUENCYError;

/**
 * The abort error message of the method "FID_TUN_S_AUTOSTORE"
 * method to start an autostore process. autostore will automatic
 * store stations on preset list.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_AUTOSTOREAbortError;

/**
 * The error message of 'FID_TUN_S_AUTOSTORE'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_AUTOSTOREError;

/**
 * The abort error message of the method "FID_TUN_S_SEL_LIST_ELEM"
 * This method is used to select station from the preset/Config  list.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_SEL_LIST_ELEMAbortError;

/**
 * The error message of 'FID_TUN_S_SEL_LIST_ELEM'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_SEL_LIST_ELEMError;

/**
 * The abort error message of the method "FID_TUN_S_GET_CONFIG_LIST"
 * This method is used to Configure the dynamic list.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_GET_CONFIG_LISTAbortError;

/**
 * The error message of 'FID_TUN_S_GET_CONFIG_LIST'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_GET_CONFIG_LISTError;

/**
 * The abort error message of the method "FID_TUN_S_AUDIO_FG_BG_NEW"
 * The HMI can set, with this command who is listening to the tuner,
 * USR1, TA, TIM, PTY, NEWS, by enabling Foreground.  If the tuner is sent into
 * background (means that no one is listening), the tuner will mute it's audio signal.
 * Tuner 1 or Tuner 2 can be put into FG or BG.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_AUDIO_FG_BG_NEWAbortError;

/**
 * The error message of 'FID_TUN_S_AUDIO_FG_BG_NEW'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_AUDIO_FG_BG_NEWError;

/**
 * The abort error message of the method "FID_TUN_S_SET_PI"
 * This FI is used to set a particular PI,frequency or step the PI from the Currently tuned station.
 * The PI stepping can either be step-up or step-down. The number of steps have to be mentioned.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_SET_PIAbortError;

/**
 * The error message of 'FID_TUN_S_SET_PI'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_SET_PIError;

/**
 * The abort error message of the method "FID_TUN_S_SET_SHARXLEVEL"
 * The HMI can do a Sharx step, with this command the .
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_SET_SHARXLEVELAbortError;

/**
 * The error message of 'FID_TUN_S_SET_SHARXLEVEL'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_SET_SHARXLEVELError;

/**
 * The abort error message of the method "FID_TUN_S_GET_STATIC_LIST"
 * With this command we can get preset list elements based on request .
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_GET_STATIC_LISTAbortError;

/**
 * The error message of 'FID_TUN_S_GET_STATIC_LIST'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_GET_STATIC_LISTError;

/**
 * The abort error message of the method "FID_TUN_S_SETUP_DDADDS"
 * This command enable Setup for Mode.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_SETUP_DDADDSAbortError;

/**
 * The error message of 'FID_TUN_S_SETUP_DDADDS'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_SETUP_DDADDSError;

/**
 * The abort error message of the method "FID_TUN_S_PRESET_HANDLING"
 * This method is used to perform actions like delete, recall and store in preset list.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_PRESET_HANDLINGAbortError;

/**
 * The error message of 'FID_TUN_S_PRESET_HANDLING'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_PRESET_HANDLINGError;

/**
 * The abort error message of the method "FID_TUN_S_PS_FREEZE"
 * This Function is used to Freeze/Unfreeze the PS Name of
 * the currently playing FM station.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_PS_FREEZEAbortError;

/**
 * The error message of 'FID_TUN_S_PS_FREEZE'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_PS_FREEZEError;

/**
 * The abort error message of the method "FID_TUN_S_SET_AUTOCOMP_PARAM"
 * Through this method, the Parameters for autocompare can be set. This is
 * mainly used to divide the preset-list into different band ranges.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_SET_AUTOCOMP_PARAMAbortError;

/**
 * The error message of 'FID_TUN_S_SET_AUTOCOMP_PARAM'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_SET_AUTOCOMP_PARAMError;

/**
 * The abort error message of the method "FID_TUN_S_SET_RDBID"
 * This method is used to set RDBID parametres.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_SET_RDBIDAbortError;

/**
 * The error message of 'FID_TUN_S_SET_RDBID'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_SET_RDBIDError;

/**
 * The start message of the method "FID_TUN_S_CALIBRATION_DATA"
 * This method is used to set RDBID parametres.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_S_CALIBRATION_DATAStart;

/**
 * The abort error message of the method "FID_TUN_S_CALIBRATION_DATA"
 * This method is used to set RDBID parametres.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_CALIBRATION_DATAAbortError;

/**
 * The error message of 'FID_TUN_S_CALIBRATION_DATA'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_CALIBRATION_DATAError;

/**
 * The start message of the method "FID_TUN_S_ACTIVE_TUNER"
 * This method is used to get the current active physical tuner
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_S_ACTIVE_TUNERStart;

/**
 * The abort error message of the method "FID_TUN_S_ACTIVE_TUNER"
 * This method is used to get the current active physical tuner
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_ACTIVE_TUNERAbortError;

/**
 * The error message of 'FID_TUN_S_ACTIVE_TUNER'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_ACTIVE_TUNERError;

/**
 * The abort error message of the method "FID_TUN_S_STATIONLIST_EXIT"
 * This method is used to send station list exit info.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_STATIONLIST_EXITAbortError;

/**
 * The error message of 'FID_TUN_S_STATIONLIST_EXIT'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_STATIONLIST_EXITError;

/**
 * The abort error message of the method "FID_TUN_S_SURVEIL_TP"
 * Starts/Stops TA announcement data tuner (background) surveillance for a given station.
 * If tuned station is NON-TP then TP Search happens and starts monitoring
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_SURVEIL_TPAbortError;

/**
 * The error message of 'FID_TUN_S_SURVEIL_TP'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_SURVEIL_TPError;

/**
 * The abort error message of the method "FID_TUN_S_SET_ENGG_PARAMETER"
 * This allows to modify given Engineering parameter.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_SET_ENGG_PARAMETERAbortError;

/**
 * The error message of 'FID_TUN_S_SET_ENGG_PARAMETER'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_SET_ENGG_PARAMETERError;

/**
 * The abort error message of the method "FID_TUN_S_ANNOUNCEMENT_SWITCH"
 * Activates/Deactivates the signalling of a detected announcement
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_ANNOUNCEMENT_SWITCHAbortError;

/**
 * The error message of 'FID_TUN_S_ANNOUNCEMENT_SWITCH'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_ANNOUNCEMENT_SWITCHError;

/**
 * The abort error message of the method "FID_TUN_S_ANNOUNCEMENT_ESCAPE"
 * The given announcement will be cancelled for the given audio tuner
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_ANNOUNCEMENT_ESCAPEAbortError;

/**
 * The error message of 'FID_TUN_S_ANNOUNCEMENT_ESCAPE'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_ANNOUNCEMENT_ESCAPEError;

/**
 * The abort error message of the method "FID_TUN_S_PRESET_STORAGE_PS_FREEZE"
 * This is used to freeze / unfreeze the current PS of the audio tuner before saving Preset.
 * By this method sudden change of the PS short before the actual save is avoided.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_PRESET_STORAGE_PS_FREEZEAbortError;

/**
 * The error message of 'FID_TUN_S_PRESET_STORAGE_PS_FREEZE'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_PRESET_STORAGE_PS_FREEZEError;

/**
 * The abort error message of the method "FID_TUN_S_SPEED_INFO"
 * sets the speed information
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_SPEED_INFOAbortError;

/**
 * The error message of 'FID_TUN_S_SPEED_INFO'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_SPEED_INFOError;

/**
 * The start message of the method "FID_TUN_S_AUDIO_MUTEREQUEST"
 * This method is used to send mute status from Tunermaster to Tuner.
 * Will be extended if Mute Status to be sent from other clients.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_S_AUDIO_MUTEREQUESTStart;

/**
 * The abort error message of the method "FID_TUN_S_AUDIO_MUTEREQUEST"
 * This method is used to send mute status from Tunermaster to Tuner.
 * Will be extended if Mute Status to be sent from other clients.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_AUDIO_MUTEREQUESTAbortError;

/**
 * The error message of 'FID_TUN_S_AUDIO_MUTEREQUEST'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_AUDIO_MUTEREQUESTError;

/**
 * The abort error message of the method "FID_TUN_S_CONFIGLIST_UPDATE"
 * Checks if new stations are receivable for the given config list or if recently found
 * stations are no longer receivable.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_CONFIGLIST_UPDATEAbortError;

/**
 * The error message of 'FID_TUN_S_CONFIGLIST_UPDATE'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_CONFIGLIST_UPDATEError;

/**
 * The abort error message of the method "FID_TUN_S_DEFAULT_SETTING"
 * By this method the given default setting option is performed. The related parameters of the active
 * configuration are reset to the values as given by the original configuration.
 * Currently only one option is supported.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_DEFAULT_SETTINGAbortError;

/**
 * The error message of 'FID_TUN_S_DEFAULT_SETTING'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_DEFAULT_SETTINGError;

/**
 * The abort error message of the method "FID_TUN_S_SET_DEMODULATION_SWITCH"
 * Method to set Demodulation switch for FM/AM/HD/DRM
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_SET_DEMODULATION_SWITCHAbortError;

/**
 * The error message of 'FID_TUN_S_SET_DEMODULATION_SWITCH'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_SET_DEMODULATION_SWITCHError;

/**
 * The abort error message of the method "FID_TUN_S_SELECT_DRM_AUDIOPRGM"
 * Method to select DRM audio program by absolutely for by frequency or DRM Service ID.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_SELECT_DRM_AUDIOPRGMAbortError;

/**
 * The error message of 'FID_TUN_S_SELECT_DRM_AUDIOPRGM'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_SELECT_DRM_AUDIOPRGMError;

/**
 * The abort error message of the method "FID_TUN_S_AUDIO_DEVICE"
 * Method to set the Audio sink name for DRM  source
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_AUDIO_DEVICEAbortError;

/**
 * The error message of 'FID_TUN_S_AUDIO_DEVICE'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_AUDIO_DEVICEError;

/**
 * The abort error message of the method "FID_TUN_S_SET_DRM_SRCACTIVITY"
 * Method to request Source Activity of DRM source
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_SET_DRM_SRCACTIVITYAbortError;

/**
 * The error message of 'FID_TUN_S_SET_DRM_SRCACTIVITY'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_SET_DRM_SRCACTIVITYError;

/**
 * The abort error message of the method "FID_TUN_S_SET_TESTMODE"
 * This provides several data items for each available physical tuner
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_SET_TESTMODEAbortError;

/**
 * The error message of 'FID_TUN_S_SET_TESTMODE'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_SET_TESTMODEError;

/**
 * The abort error message of the method "FID_TUN_S_SELECT_HD_AUDIOPRGM"
 * Method to select HD audio program absolutely or relatively
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_SELECT_HD_AUDIOPRGMAbortError;

/**
 * The error message of 'FID_TUN_S_SELECT_HD_AUDIOPRGM'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_SELECT_HD_AUDIOPRGMError;

/**
 * The abort error message of the method "FID_TUN_S_SEL_HD_AUDIOPRGMDIRECT"
 * Method to select a HD audio program of a different frequency absolutely from the current tuned one.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_SEL_HD_AUDIOPRGMDIRECTAbortError;

/**
 * The error message of 'FID_TUN_S_SEL_HD_AUDIOPRGMDIRECT'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_SEL_HD_AUDIOPRGMDIRECTError;

/**
 * The start message of the method "FID_TUN_S_HD_RESET_TRANSITIONCOUNT"
 * Method to Reset HD Transition count in Testmode.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_S_HD_RESET_TRANSITIONCOUNTStart;

/**
 * The result message of the method "FID_TUN_S_HD_RESET_TRANSITIONCOUNT"
 * Method to Reset HD Transition count in Testmode.
 * .
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_S_HD_RESET_TRANSITIONCOUNTResult;

/**
 * The abort error message of the method "FID_TUN_S_HD_RESET_TRANSITIONCOUNT"
 * Method to Reset HD Transition count in Testmode.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_HD_RESET_TRANSITIONCOUNTAbortError;

/**
 * The error message of 'FID_TUN_S_HD_RESET_TRANSITIONCOUNT'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_HD_RESET_TRANSITIONCOUNTError;

/**
 * The abort error message of the method "FID_TUN_S_SET_AUDIO_SPLIT_MODE"
 * This allows to activate/deactivate audio split mode.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_SET_AUDIO_SPLIT_MODEAbortError;

/**
 * The error message of 'FID_TUN_S_SET_AUDIO_SPLIT_MODE'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_SET_AUDIO_SPLIT_MODEError;

/**
 * The abort error message of the method "FID_TUN_S_SET_HD_SECTION_PARAMETER"
 * This method allows to change HD Section parameters
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_SET_HD_SECTION_PARAMETERAbortError;

/**
 * The error message of 'FID_TUN_S_SET_HD_SECTION_PARAMETER'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_SET_HD_SECTION_PARAMETERError;

/**
 * The abort error message of the method "FID_TUN_S_DRM_TESTMODE"
 * This method is used to set DRM test mode notifications ON/OFF.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_DRM_TESTMODEAbortError;

/**
 * The error message of 'FID_TUN_S_DRM_TESTMODE'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_DRM_TESTMODEError;

/**
 * The start message of the method "FID_TUN_S_DRM_RESET_MUTECOUNTER"
 * This method is used to reset DRM mute counter to zero in DRM testmode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_S_DRM_RESET_MUTECOUNTERStart;

/**
 * The abort error message of the method "FID_TUN_S_DRM_RESET_MUTECOUNTER"
 * This method is used to reset DRM mute counter to zero in DRM testmode
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_DRM_RESET_MUTECOUNTERAbortError;

/**
 * The error message of 'FID_TUN_S_DRM_RESET_MUTECOUNTER'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_DRM_RESET_MUTECOUNTERError;

/**
 * The abort error message of the method "FID_TUN_S_SET_AF"
 * Activate/Deactivate the automatic tuning of the best known alternative frequency (AFBestSwitch)
 * For AF switch use this FID instead of FID_TUN_S_SET_FEATURE for new 3.30 APIversion.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_SET_AFAbortError;

/**
 * The error message of 'FID_TUN_S_SET_AF'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_SET_AFError;

/**
 * The abort error message of the method "FID_TUN_S_CHANGE_LSM"
 * This method is used to update the LSM with the requested data.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_CHANGE_LSMAbortError;

/**
 * The error message of 'FID_TUN_S_CHANGE_LSM'
 * .
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_CHANGE_LSMError;

/**
 * The start message of the method "FID_TUN_S_DARC_NO_VICS_DATA_AVAILABLE"
 * The method is used to set the next frequency for the FM DARC tuner
 * .
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEStart;

/**
 * The abort error message of the method "FID_TUN_S_DARC_NO_VICS_DATA_AVAILABLE"
 * The method is used to set the next frequency for the FM DARC tuner
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEAbortError;

/**
 * The error message of 'FID_TUN_S_DARC_NO_VICS_DATA_AVAILABLE'
 * .
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEError;

/**
 * The abort error message of the method "FID_TUN_S_DARC_VICS_FREQUENCY_LIST"
 * The method is used to receive the list of Freq's/stations which supports DARC/VICS data.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_DARC_VICS_FREQUENCY_LISTAbortError;

/**
 * The error message of 'FID_TUN_S_DARC_VICS_FREQUENCY_LIST'
 * .
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_DARC_VICS_FREQUENCY_LISTError;

/**
 * The abort error message of the method "FID_TUN_S_JAPAN_SET_AREA"
 * select the Japan region and also the mode of update.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_JAPAN_SET_AREAAbortError;

/**
 * The error message of 'FID_TUN_S_JAPAN_SET_AREA'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_JAPAN_SET_AREAError;

/**
 * The abort error message of the method "FID_TUN_S_JAPAN_CHANGE_STATION_NAME"
 * This method should not be used anymore and will be removed. Instead use FID_TUN_S_JAPAN_SELECT_STATION_NAME.
 * Switch station name to the next/previous station name that belongs to the current frequency in the selected area.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_JAPAN_CHANGE_STATION_NAMEAbortError;

/**
 * The error message of 'FID_TUN_S_JAPAN_CHANGE_STATION_NAME'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_JAPAN_CHANGE_STATION_NAMEError;

/**
 * The abort error message of the method "FID_TUN_S_LANGUAGE_SETTING"
 * HMI/Other clients can inform Tuner MIDW about the current language set on the target using this FI. Currently applicable only for AIVI JPN variant where based on the language set, the station name posted can be japanese/english name.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_LANGUAGE_SETTINGAbortError;

/**
 * The error message of 'FID_TUN_S_LANGUAGE_SETTING'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_LANGUAGE_SETTINGError;

/**
 * The abort error message of the method "FID_TUN_S_JAPAN_SELECT_STATION_NAME"
 * Select/Change station name (absolutely/relatively) that belongs to the current frequency in the selected area.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_JAPAN_SELECT_STATION_NAMEAbortError;

/**
 * The error message of 'FID_TUN_S_JAPAN_SELECT_STATION_NAME'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_JAPAN_SELECT_STATION_NAMEError;

/**
 * The abort error message of the method "FID_TUN_S_USER_PROFILE_UPDATE"
 * Method for TMC. This method is used to copy, delete or activate a user profile
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_USER_PROFILE_UPDATEAbortError;

/**
 * The error message of 'FID_TUN_S_USER_PROFILE_UPDATE'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_USER_PROFILE_UPDATEError;

/**
 * The abort error message of the method "FID_TUN_S_PRESETLIST_CONTENT_UPDATE"
 * This method is to be used only by fc_tunermaster only
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_PRESETLIST_CONTENT_UPDATEAbortError;

/**
 * The error message of 'FID_TUN_S_PRESETLIST_CONTENT_UPDATE'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_PRESETLIST_CONTENT_UPDATEError;

/**
 * The abort error message of the method "FID_TUN_S_DISABLE_BAND"
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_DISABLE_BANDAbortError;

/**
 * The error message of 'FID_TUN_S_DISABLE_BAND'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_S_DISABLE_BANDError;

/**
 * The get message of the property "FID_TUN_G_CALIBRATION_DATA"
 * Status response to Tuner Calibration Data.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_CALIBRATION_DATAGet;

/**
 * The upreg message of the property "FID_TUN_G_CALIBRATION_DATA"
 * Status response to Tuner Calibration Data.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_CALIBRATION_DATAUpReg;

/**
 * The relUpReg message of the property "FID_TUN_G_CALIBRATION_DATA"
 * Status response to Tuner Calibration Data.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_CALIBRATION_DATARelUpReg;

/**
 * The error message of 'FID_TUN_G_CALIBRATION_DATA'
 * possible erros of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_G_CALIBRATION_DATAError;

/**
 * The get message of the property "FID_TUN_G_SET_FEATURE"
 * Status response to MethodStart FID_TUN_S_SET_FEATURE.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_SET_FEATUREGet;

/**
 * The upreg message of the property "FID_TUN_G_SET_FEATURE"
 * Status response to MethodStart FID_TUN_S_SET_FEATURE.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_SET_FEATUREUpReg;

/**
 * The relUpReg message of the property "FID_TUN_G_SET_FEATURE"
 * Status response to MethodStart FID_TUN_S_SET_FEATURE.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_SET_FEATURERelUpReg;

/**
 * The error message of 'FID_TUN_G_SET_FEATURE'
 * possible erros of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_G_SET_FEATUREError;

/**
 * The get message of the property "FID_TUN_G_SET_HICUT"
 * Status response to MethodStart FID_TUN_S_SET_HICUT.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_SET_HICUTGet;

/**
 * The upreg message of the property "FID_TUN_G_SET_HICUT"
 * Status response to MethodStart FID_TUN_S_SET_HICUT.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_SET_HICUTUpReg;

/**
 * The relUpReg message of the property "FID_TUN_G_SET_HICUT"
 * Status response to MethodStart FID_TUN_S_SET_HICUT.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_SET_HICUTRelUpReg;

/**
 * The error message of 'FID_TUN_G_SET_HICUT'
 * possible erros of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_G_SET_HICUTError;

/**
 * The get message of the property "FID_TUN_G_AFLIST_V2"
 * Status response to MethodStart FID_TUN_S_AFLIST_V2 :list length and actual list is sent via this property.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_AFLIST_V2Get;

/**
 * The upreg message of the property "FID_TUN_G_AFLIST_V2"
 * Status response to MethodStart FID_TUN_S_AFLIST_V2 :list length and actual list is sent via this property.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_AFLIST_V2UpReg;

/**
 * The relUpReg message of the property "FID_TUN_G_AFLIST_V2"
 * Status response to MethodStart FID_TUN_S_AFLIST_V2 :list length and actual list is sent via this property.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_AFLIST_V2RelUpReg;

/**
 * The error message of 'FID_TUN_G_AFLIST_V2'
 * possible erros of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_G_AFLIST_V2Error;

/**
 * The upreg message of the property "FID_TUN_G_GET_CONFIG_LIST"
 * In response to the method start
 * FID_TUN_S_GET_CONFIG_LIST the number of config list
 * elements is given by this property.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_GET_CONFIG_LISTUpReg;

/**
 * The relUpReg message of the property "FID_TUN_G_GET_CONFIG_LIST"
 * In response to the method start
 * FID_TUN_S_GET_CONFIG_LIST the number of config list
 * elements is given by this property.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_GET_CONFIG_LISTRelUpReg;

/**
 * The error message of 'FID_TUN_G_GET_CONFIG_LIST'
 * possible erros of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_G_GET_CONFIG_LISTError;

/**
 * The get message of the property "FID_TUN_G_SET_SHARXLEVEL"
 * Status response to HMI regarding the Sharx Step.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_SET_SHARXLEVELGet;

/**
 * The upreg message of the property "FID_TUN_G_SET_SHARXLEVEL"
 * Status response to HMI regarding the Sharx Step.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_SET_SHARXLEVELUpReg;

/**
 * The relUpReg message of the property "FID_TUN_G_SET_SHARXLEVEL"
 * Status response to HMI regarding the Sharx Step.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_SET_SHARXLEVELRelUpReg;

/**
 * The error message of 'FID_TUN_G_SET_SHARXLEVEL'
 * possible erros of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_G_SET_SHARXLEVELError;

/**
 * The get message of the property "FID_TUN_G_SET_DDA"
 * Status response to HMI regarding the DDA.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_SET_DDAGet;

/**
 * The upreg message of the property "FID_TUN_G_SET_DDA"
 * Status response to HMI regarding the DDA.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_SET_DDAUpReg;

/**
 * The relUpReg message of the property "FID_TUN_G_SET_DDA"
 * Status response to HMI regarding the DDA.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_SET_DDARelUpReg;

/**
 * The error message of 'FID_TUN_G_SET_DDA'
 * possible erros of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_G_SET_DDAError;

/**
 * The get message of the property "FID_TUN_G_SET_AF"
 * Status response to HMI regarding the AF ON/OFF.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_SET_AFGet;

/**
 * The upreg message of the property "FID_TUN_G_SET_AF"
 * Status response to HMI regarding the AF ON/OFF.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_SET_AFUpReg;

/**
 * The relUpReg message of the property "FID_TUN_G_SET_AF"
 * Status response to HMI regarding the AF ON/OFF.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_SET_AFRelUpReg;

/**
 * The error message of 'FID_TUN_G_SET_AF'
 * possible erros of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_G_SET_AFError;

/**
 * The get message of the property "FID_TUN_G_SET_MEASUREMODE"
 * Status response to HMI regarding the Measuremode ON/OFF.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_SET_MEASUREMODEGet;

/**
 * The upreg message of the property "FID_TUN_G_SET_MEASUREMODE"
 * Status response to HMI regarding the Measuremode ON/OFF.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_SET_MEASUREMODEUpReg;

/**
 * The relUpReg message of the property "FID_TUN_G_SET_MEASUREMODE"
 * Status response to HMI regarding the Measuremode ON/OFF.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_SET_MEASUREMODERelUpReg;

/**
 * The error message of 'FID_TUN_G_SET_MEASUREMODE'
 * possible erros of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_G_SET_MEASUREMODEError;

/**
 * The get message of the property "FID_TUN_G_SET_RDSREG"
 * Status response to HMI regarding the REG ON/OFF.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_SET_RDSREGGet;

/**
 * The upreg message of the property "FID_TUN_G_SET_RDSREG"
 * Status response to HMI regarding the REG ON/OFF.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_SET_RDSREGUpReg;

/**
 * The relUpReg message of the property "FID_TUN_G_SET_RDSREG"
 * Status response to HMI regarding the REG ON/OFF.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_SET_RDSREGRelUpReg;

/**
 * The error message of 'FID_TUN_G_SET_RDSREG'
 * possible erros of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_G_SET_RDSREGError;

/**
 * The get message of the property "FID_TUN_G_GET_STATIC_LIST"
 * Status response to HMI regarding the Sharx Step.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_GET_STATIC_LISTGet;

/**
 * The upreg message of the property "FID_TUN_G_GET_STATIC_LIST"
 * Status response to HMI regarding the Sharx Step.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_GET_STATIC_LISTUpReg;

/**
 * The relUpReg message of the property "FID_TUN_G_GET_STATIC_LIST"
 * Status response to HMI regarding the Sharx Step.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_GET_STATIC_LISTRelUpReg;

/**
 * The error message of 'FID_TUN_G_GET_STATIC_LIST'
 * possible erros of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_G_GET_STATIC_LISTError;

/**
 * The get message of the property "FID_TUN_G_RADIO_TEXT"
 * This Property delivers latest received Radio text.
 * Status response to Radio text data .
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_RADIO_TEXTGet;

/**
 * The upreg message of the property "FID_TUN_G_RADIO_TEXT"
 * This Property delivers latest received Radio text.
 * Status response to Radio text data .
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_RADIO_TEXTUpReg;

/**
 * The relUpReg message of the property "FID_TUN_G_RADIO_TEXT"
 * This Property delivers latest received Radio text.
 * Status response to Radio text data .
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_RADIO_TEXTRelUpReg;

/**
 * The error message of 'FID_TUN_G_RADIO_TEXT'
 * possible erros of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_G_RADIO_TEXTError;

/**
 * The get message of the property "FID_TUN_G_BAND_PLUS_STATION_INFO"
 * Current band and station info are sent together. This is required if the clients
 * need to synchronise band and frequency information.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_BAND_PLUS_STATION_INFOGet;

/**
 * The upreg message of the property "FID_TUN_G_BAND_PLUS_STATION_INFO"
 * Current band and station info are sent together. This is required if the clients
 * need to synchronise band and frequency information.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_BAND_PLUS_STATION_INFOUpReg;

/**
 * The relUpReg message of the property "FID_TUN_G_BAND_PLUS_STATION_INFO"
 * Current band and station info are sent together. This is required if the clients
 * need to synchronise band and frequency information.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_BAND_PLUS_STATION_INFORelUpReg;

/**
 * The error message of 'FID_TUN_G_BAND_PLUS_STATION_INFO'
 * possible erros of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_G_BAND_PLUS_STATION_INFOError;

/**
 * The get message of the property "FID_TUN_G_SETUP_DDADDS"
 * Status response to MethodStart FID_TUN_S_SET_ANTENNA.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_SETUP_DDADDSGet;

/**
 * The upreg message of the property "FID_TUN_G_SETUP_DDADDS"
 * Status response to MethodStart FID_TUN_S_SET_ANTENNA.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_SETUP_DDADDSUpReg;

/**
 * The relUpReg message of the property "FID_TUN_G_SETUP_DDADDS"
 * Status response to MethodStart FID_TUN_S_SET_ANTENNA.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_SETUP_DDADDSRelUpReg;

/**
 * The error message of 'FID_TUN_G_SETUP_DDADDS'
 * possible erros of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_G_SETUP_DDADDSError;

/**
 * The get message of the property "FID_TUN_G_GET_DATA_TESTMODE_DDADDS"
 * In response when TM_DATA is enabled by using FID_TUN_S_SET_FEATURE this response will be sent every 250 ms
 * with the data of the currently tuned frequency for testmode applications.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_GET_DATA_TESTMODE_DDADDSGet;

/**
 * The upreg message of the property "FID_TUN_G_GET_DATA_TESTMODE_DDADDS"
 * In response when TM_DATA is enabled by using FID_TUN_S_SET_FEATURE this response will be sent every 250 ms
 * with the data of the currently tuned frequency for testmode applications.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_GET_DATA_TESTMODE_DDADDSUpReg;

/**
 * The relUpReg message of the property "FID_TUN_G_GET_DATA_TESTMODE_DDADDS"
 * In response when TM_DATA is enabled by using FID_TUN_S_SET_FEATURE this response will be sent every 250 ms
 * with the data of the currently tuned frequency for testmode applications.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_GET_DATA_TESTMODE_DDADDSRelUpReg;

/**
 * The error message of 'FID_TUN_G_GET_DATA_TESTMODE_DDADDS'
 * possible erros of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_G_GET_DATA_TESTMODE_DDADDSError;

/**
 * The get message of the property "FID_TUN_G_TMC_INFO"
 * This property is used to send information about TMC
 * reception from either Tuner 0 or Tuner 1.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_TMC_INFOGet;

/**
 * The upreg message of the property "FID_TUN_G_TMC_INFO"
 * This property is used to send information about TMC
 * reception from either Tuner 0 or Tuner 1.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_TMC_INFOUpReg;

/**
 * The relUpReg message of the property "FID_TUN_G_TMC_INFO"
 * This property is used to send information about TMC
 * reception from either Tuner 0 or Tuner 1.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_TMC_INFORelUpReg;

/**
 * The error message of 'FID_TUN_G_TMC_INFO'
 * possible erros of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_G_TMC_INFOError;

/**
 * The get message of the property "FID_TUN_G_GET_DATA_TMC"
 * This Property will give RDS groups data of Tuned TMC station.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_GET_DATA_TMCGet;

/**
 * The upreg message of the property "FID_TUN_G_GET_DATA_TMC"
 * This Property will give RDS groups data of Tuned TMC station.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_GET_DATA_TMCUpReg;

/**
 * The relUpReg message of the property "FID_TUN_G_GET_DATA_TMC"
 * This Property will give RDS groups data of Tuned TMC station.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_GET_DATA_TMCRelUpReg;

/**
 * The error message of 'FID_TUN_G_GET_DATA_TMC'
 * possible erros of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_G_GET_DATA_TMCError;

/**
 * The get message of the property "FID_TUN_G_ATSTATIONINFO"
 * Status response to CM_AtStationinfo .
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_ATSTATIONINFOGet;

/**
 * The upreg message of the property "FID_TUN_G_ATSTATIONINFO"
 * Status response to CM_AtStationinfo .
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_ATSTATIONINFOUpReg;

/**
 * The relUpReg message of the property "FID_TUN_G_ATSTATIONINFO"
 * Status response to CM_AtStationinfo .
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_ATSTATIONINFORelUpReg;

/**
 * The error message of 'FID_TUN_G_ATSTATIONINFO'
 * possible erros of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_G_ATSTATIONINFOError;

/**
 * The get message of the property "FID_TUN_G_ATSEEK"
 * Status Response
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_ATSEEKGet;

/**
 * The upreg message of the property "FID_TUN_G_ATSEEK"
 * Status Response
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_ATSEEKUpReg;

/**
 * The relUpReg message of the property "FID_TUN_G_ATSEEK"
 * Status Response
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_ATSEEKRelUpReg;

/**
 * The error message of 'FID_TUN_G_ATSEEK'
 * possible erros of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_G_ATSEEKError;

/**
 * The get message of the property "FID_TUN_G_DIAG_REMOTE_CONTROL"
 * Status response indicating if remote control session is ON or OFF .
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_DIAG_REMOTE_CONTROLGet;

/**
 * The upreg message of the property "FID_TUN_G_DIAG_REMOTE_CONTROL"
 * Status response indicating if remote control session is ON or OFF .
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_DIAG_REMOTE_CONTROLUpReg;

/**
 * The relUpReg message of the property "FID_TUN_G_DIAG_REMOTE_CONTROL"
 * Status response indicating if remote control session is ON or OFF .
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_DIAG_REMOTE_CONTROLRelUpReg;

/**
 * The error message of 'FID_TUN_G_DIAG_REMOTE_CONTROL'
 * possible errors of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_G_DIAG_REMOTE_CONTROLError;

/**
 * The get message of the property "FID_TUN_G_RdbIdActualList"
 * With this property the FC_TmcTuner informs FC_TIMA,
 * which RDB-IDs are received at the moment. So FC_TIMA is always
 * notified, if something changes with the received radio programs.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_RdbIdActualListGet;

/**
 * The upreg message of the property "FID_TUN_G_RdbIdActualList"
 * With this property the FC_TmcTuner informs FC_TIMA,
 * which RDB-IDs are received at the moment. So FC_TIMA is always
 * notified, if something changes with the received radio programs.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_RdbIdActualListUpReg;

/**
 * The relUpReg message of the property "FID_TUN_G_RdbIdActualList"
 * With this property the FC_TmcTuner informs FC_TIMA,
 * which RDB-IDs are received at the moment. So FC_TIMA is always
 * notified, if something changes with the received radio programs.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_RdbIdActualListRelUpReg;

/**
 * The error message of 'FID_TUN_G_RdbIdActualList'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_G_RdbIdActualListError;

/**
 * The get message of the property "FID_TUN_G_SET_RDS"
 * Status response to HMI regarding the RDS switch.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_SET_RDSGet;

/**
 * The upreg message of the property "FID_TUN_G_SET_RDS"
 * Status response to HMI regarding the RDS switch.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_SET_RDSUpReg;

/**
 * The relUpReg message of the property "FID_TUN_G_SET_RDS"
 * Status response to HMI regarding the RDS switch.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_SET_RDSRelUpReg;

/**
 * The error message of 'FID_TUN_G_SET_RDS'
 * possible erros of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_G_SET_RDSError;

/**
 * The upreg message of the property "FID_TUN_G_SET_ENGG_PARAMETER"
 * Status response to HMI regarding the Engineering parameter value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_SET_ENGG_PARAMETERUpReg;

/**
 * The relUpReg message of the property "FID_TUN_G_SET_ENGG_PARAMETER"
 * Status response to HMI regarding the Engineering parameter value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_SET_ENGG_PARAMETERRelUpReg;

/**
 * The error message of 'FID_TUN_G_SET_ENGG_PARAMETER'
 * possible erros of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_G_SET_ENGG_PARAMETERError;

/**
 * The upreg message of the property "FID_TUN_G_SET_TUNING_ACTION_CONFIG"
 * Status response to HMI regarding the Tuner Configuration Parameters values.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_SET_TUNING_ACTION_CONFIGUpReg;

/**
 * The relUpReg message of the property "FID_TUN_G_SET_TUNING_ACTION_CONFIG"
 * Status response to HMI regarding the Tuner Configuration Parameters values.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_SET_TUNING_ACTION_CONFIGRelUpReg;

/**
 * The error message of 'FID_TUN_G_SET_TUNING_ACTION_CONFIG'
 * possible erros of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_G_SET_TUNING_ACTION_CONFIGError;

/**
 * The upreg message of the property "FID_TUN_G_ANNOUNCEMENT_MESSAGE"
 * Notifies the start or end of an announcement
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_ANNOUNCEMENT_MESSAGEUpReg;

/**
 * The relUpReg message of the property "FID_TUN_G_ANNOUNCEMENT_MESSAGE"
 * Notifies the start or end of an announcement
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_ANNOUNCEMENT_MESSAGERelUpReg;

/**
 * The error message of 'FID_TUN_G_ANNOUNCEMENT_MESSAGE'
 * possible erros of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_G_ANNOUNCEMENT_MESSAGEError;

/**
 * The get message of the property "FID_TUN_G_ANNOUNCEMENT_INFO"
 * Provides the frequency, PI and stationname of the announcement station
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_ANNOUNCEMENT_INFOGet;

/**
 * The upreg message of the property "FID_TUN_G_ANNOUNCEMENT_INFO"
 * Provides the frequency, PI and stationname of the announcement station
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_ANNOUNCEMENT_INFOUpReg;

/**
 * The relUpReg message of the property "FID_TUN_G_ANNOUNCEMENT_INFO"
 * Provides the frequency, PI and stationname of the announcement station
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_ANNOUNCEMENT_INFORelUpReg;

/**
 * The error message of 'FID_TUN_G_ANNOUNCEMENT_INFO'
 * possible erros of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_G_ANNOUNCEMENT_INFOError;

/**
 * The get message of the property "FID_TUN_G_ANNOUNCEMENT_SWITCH"
 * Provides the TP/PTY announcement switch status
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_ANNOUNCEMENT_SWITCHGet;

/**
 * The upreg message of the property "FID_TUN_G_ANNOUNCEMENT_SWITCH"
 * Provides the TP/PTY announcement switch status
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_ANNOUNCEMENT_SWITCHUpReg;

/**
 * The relUpReg message of the property "FID_TUN_G_ANNOUNCEMENT_SWITCH"
 * Provides the TP/PTY announcement switch status
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_ANNOUNCEMENT_SWITCHRelUpReg;

/**
 * The error message of 'FID_TUN_G_ANNOUNCEMENT_SWITCH'
 * possible erros of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_G_ANNOUNCEMENT_SWITCHError;

/**
 * The upreg message of the property "FID_TUN_G_PI_PS_RELATION"
 * PI PS Relation status message
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_PI_PS_RELATIONUpReg;

/**
 * The relUpReg message of the property "FID_TUN_G_PI_PS_RELATION"
 * PI PS Relation status message
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_PI_PS_RELATIONRelUpReg;

/**
 * The error message of 'FID_TUN_G_PI_PS_RELATION'
 * possible erros of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_G_PI_PS_RELATIONError;

/**
 * The get message of the property "FID_TUN_G_AVAILABLE_BAND_RANGE"
 * Provides Range of Available Bands as status msg
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_AVAILABLE_BAND_RANGEGet;

/**
 * The upreg message of the property "FID_TUN_G_AVAILABLE_BAND_RANGE"
 * Provides Range of Available Bands as status msg
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_AVAILABLE_BAND_RANGEUpReg;

/**
 * The relUpReg message of the property "FID_TUN_G_AVAILABLE_BAND_RANGE"
 * Provides Range of Available Bands as status msg
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_AVAILABLE_BAND_RANGERelUpReg;

/**
 * The error message of 'FID_TUN_G_AVAILABLE_BAND_RANGE'
 * possible erros of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_G_AVAILABLE_BAND_RANGEError;

/**
 * The upreg message of the property "FID_TUN_G_MUTE_REQUEST"
 * Mute status message
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_MUTE_REQUESTUpReg;

/**
 * The relUpReg message of the property "FID_TUN_G_MUTE_REQUEST"
 * Mute status message
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_MUTE_REQUESTRelUpReg;

/**
 * The error message of 'FID_TUN_G_MUTE_REQUEST'
 * possible erros of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_G_MUTE_REQUESTError;

/**
 * The upreg message of the property "FID_TUN_G_UPDATELANDSCAPE_PROGRESS"
 * Provides ratio of the already scanned frequencies in percent during landscape update
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_UPDATELANDSCAPE_PROGRESSUpReg;

/**
 * The relUpReg message of the property "FID_TUN_G_UPDATELANDSCAPE_PROGRESS"
 * Provides ratio of the already scanned frequencies in percent during landscape update
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_UPDATELANDSCAPE_PROGRESSRelUpReg;

/**
 * The error message of 'FID_TUN_G_UPDATELANDSCAPE_PROGRESS'
 * possible erros of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_G_UPDATELANDSCAPE_PROGRESSError;

/**
 * The get message of the property "FID_TUN_G_DRM_RADIO_TEXT"
 * This Property delivers DRM Radio text
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_DRM_RADIO_TEXTGet;

/**
 * The upreg message of the property "FID_TUN_G_DRM_RADIO_TEXT"
 * This Property delivers DRM Radio text
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_DRM_RADIO_TEXTUpReg;

/**
 * The relUpReg message of the property "FID_TUN_G_DRM_RADIO_TEXT"
 * This Property delivers DRM Radio text
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_DRM_RADIO_TEXTRelUpReg;

/**
 * The error message of 'FID_TUN_G_DRM_RADIO_TEXT'
 * possible erros of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_G_DRM_RADIO_TEXTError;

/**
 * The upreg message of the property "FID_TUN_G_ATPISEARCH"
 * Provides the PI search status
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_ATPISEARCHUpReg;

/**
 * The relUpReg message of the property "FID_TUN_G_ATPISEARCH"
 * Provides the PI search status
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_ATPISEARCHRelUpReg;

/**
 * The error message of 'FID_TUN_G_ATPISEARCH'
 * possible erros of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_G_ATPISEARCHError;

/**
 * The upreg message of the property "FID_TUN_G_HD_AUDIOPRGM"
 * Provides Audio Program Number of current tuned HD Audio Program.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_HD_AUDIOPRGMUpReg;

/**
 * The relUpReg message of the property "FID_TUN_G_HD_AUDIOPRGM"
 * Provides Audio Program Number of current tuned HD Audio Program.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_HD_AUDIOPRGMRelUpReg;

/**
 * The error message of 'FID_TUN_G_HD_AUDIOPRGM'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_G_HD_AUDIOPRGMError;

/**
 * The upreg message of the property "FID_TUN_G_HD_PSD_DATA"
 * Provides the PSD data of the current tuned HD Audio Program
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_HD_PSD_DATAUpReg;

/**
 * The relUpReg message of the property "FID_TUN_G_HD_PSD_DATA"
 * Provides the PSD data of the current tuned HD Audio Program
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_HD_PSD_DATARelUpReg;

/**
 * The error message of 'FID_TUN_G_HD_PSD_DATA'
 * possible erros of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_G_HD_PSD_DATAError;

/**
 * The upreg message of the property "FID_TUN_G_HD_TEST_MODE_DATA"
 * Provides HD related testmode data for each available physical tuner
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_HD_TEST_MODE_DATAUpReg;

/**
 * The relUpReg message of the property "FID_TUN_G_HD_TEST_MODE_DATA"
 * Provides HD related testmode data for each available physical tuner
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_HD_TEST_MODE_DATARelUpReg;

/**
 * The error message of 'FID_TUN_G_HD_TEST_MODE_DATA'
 * possible erros of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_G_HD_TEST_MODE_DATAError;

/**
 * The upreg message of the property "FID_TUN_G_HD_AVISORY_INFO"
 * Provides information to clients about the advisory message to be displayed.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_HD_AVISORY_INFOUpReg;

/**
 * The relUpReg message of the property "FID_TUN_G_HD_AVISORY_INFO"
 * Provides information to clients about the advisory message to be displayed.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_HD_AVISORY_INFORelUpReg;

/**
 * The error message of 'FID_TUN_G_HD_AVISORY_INFO'
 * possible erros of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_G_HD_AVISORY_INFOError;

/**
 * The upreg message of the property "FID_TUN_G_DEMODULATION_SWITCH_STATUS"
 * With this property the AM, FM and HD demodulation switch status (ON/OFF) is updated.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_DEMODULATION_SWITCH_STATUSUpReg;

/**
 * The relUpReg message of the property "FID_TUN_G_DEMODULATION_SWITCH_STATUS"
 * With this property the AM, FM and HD demodulation switch status (ON/OFF) is updated.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_DEMODULATION_SWITCH_STATUSRelUpReg;

/**
 * The error message of 'FID_TUN_G_DEMODULATION_SWITCH_STATUS'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_G_DEMODULATION_SWITCH_STATUSError;

/**
 * The upreg message of the property "FID_TUN_G_AUDIO_SPLIT_MODE"
 * Provides Audio Split Mode status( Activated/Deactivated )
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_AUDIO_SPLIT_MODEUpReg;

/**
 * The relUpReg message of the property "FID_TUN_G_AUDIO_SPLIT_MODE"
 * Provides Audio Split Mode status( Activated/Deactivated )
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_AUDIO_SPLIT_MODERelUpReg;

/**
 * The error message of 'FID_TUN_G_AUDIO_SPLIT_MODE'
 * possible erros of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_G_AUDIO_SPLIT_MODEError;

/**
 * The upreg message of the property "FID_TUN_G_HD_SECTION_PARAMETER"
 * Provides HD Section parameter status
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_HD_SECTION_PARAMETERUpReg;

/**
 * The relUpReg message of the property "FID_TUN_G_HD_SECTION_PARAMETER"
 * Provides HD Section parameter status
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_HD_SECTION_PARAMETERRelUpReg;

/**
 * The error message of 'FID_TUN_G_HD_SECTION_PARAMETER'
 * possible erros of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_G_HD_SECTION_PARAMETERError;

/**
 * The upreg message of the property "FID_TUN_G_DRM_TESTMODE"
 * With this property the DRM TestMode status is updated.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_DRM_TESTMODEUpReg;

/**
 * The relUpReg message of the property "FID_TUN_G_DRM_TESTMODE"
 * With this property the DRM TestMode status is updated.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_DRM_TESTMODERelUpReg;

/**
 * The error message of 'FID_TUN_G_DRM_TESTMODE'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_G_DRM_TESTMODEError;

/**
 * The upreg message of the property "FID_TUN_G_HD_LONGNAME"
 * this property provides the HD long Name of the station described by the parameters.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_HD_LONGNAMEUpReg;

/**
 * The relUpReg message of the property "FID_TUN_G_HD_LONGNAME"
 * this property provides the HD long Name of the station described by the parameters.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_HD_LONGNAMERelUpReg;

/**
 * The error message of 'FID_TUN_G_HD_LONGNAME'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_G_HD_LONGNAMEError;

/**
 * The upreg message of the property "FID_TUN_G_HD_IMAGEFILE_UPDATE"
 * this property provides the Cover Art / HD station logo for the current played audio program.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_HD_IMAGEFILE_UPDATEUpReg;

/**
 * The relUpReg message of the property "FID_TUN_G_HD_IMAGEFILE_UPDATE"
 * this property provides the Cover Art / HD station logo for the current played audio program.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_HD_IMAGEFILE_UPDATERelUpReg;

/**
 * The error message of 'FID_TUN_G_HD_IMAGEFILE_UPDATE'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_G_HD_IMAGEFILE_UPDATEError;

/**
 * The upreg message of the property "FID_TUN_G_HD_SIGNALLOST_TIMER"
 * This property provides the status of hd signal lost timer.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_HD_SIGNALLOST_TIMERUpReg;

/**
 * The relUpReg message of the property "FID_TUN_G_HD_SIGNALLOST_TIMER"
 * This property provides the status of hd signal lost timer.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_HD_SIGNALLOST_TIMERRelUpReg;

/**
 * The error message of 'FID_TUN_G_HD_SIGNALLOST_TIMER'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_G_HD_SIGNALLOST_TIMERError;

/**
 * The upreg message of the property "FID_TUN_G_SURVIELLANCE_LISTUPDATE"
 * The number of config list elements is given by this property to SDS.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_SURVIELLANCE_LISTUPDATEUpReg;

/**
 * The relUpReg message of the property "FID_TUN_G_SURVIELLANCE_LISTUPDATE"
 * The number of config list elements is given by this property to SDS.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_SURVIELLANCE_LISTUPDATERelUpReg;

/**
 * The error message of 'FID_TUN_G_SURVIELLANCE_LISTUPDATE'
 * possible erros of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_G_SURVIELLANCE_LISTUPDATEError;

/**
 * The upreg message of the property "FID_TUN_G_LISTUPDATE_NOTIFICATION"
 * List update notification whenever there is a change in station list.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_LISTUPDATE_NOTIFICATIONUpReg;

/**
 * The relUpReg message of the property "FID_TUN_G_LISTUPDATE_NOTIFICATION"
 * List update notification whenever there is a change in station list.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_LISTUPDATE_NOTIFICATIONRelUpReg;

/**
 * The error message of 'FID_TUN_G_LISTUPDATE_NOTIFICATION'
 * possible erros of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_G_LISTUPDATE_NOTIFICATIONError;

/**
 * The upreg message of the property "FID_TUN_G_GET_DARC_DATA"
 * This provides the DARC data received for respective stations.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_GET_DARC_DATAUpReg;

/**
 * The relUpReg message of the property "FID_TUN_G_GET_DARC_DATA"
 * This provides the DARC data received for respective stations.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_GET_DARC_DATARelUpReg;

/**
 * The error message of 'FID_TUN_G_GET_DARC_DATA'
 * possible erros of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_G_GET_DARC_DATAError;

/**
 * The get message of the property "FID_TUN_G_JAPAN_AREA"
 * Provides the updated region of JAPAN and also the mode of update (if area is updated automatically by GPS data or manually by the user)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_JAPAN_AREAGet;

/**
 * The upreg message of the property "FID_TUN_G_JAPAN_AREA"
 * Provides the updated region of JAPAN and also the mode of update (if area is updated automatically by GPS data or manually by the user)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_JAPAN_AREAUpReg;

/**
 * The relUpReg message of the property "FID_TUN_G_JAPAN_AREA"
 * Provides the updated region of JAPAN and also the mode of update (if area is updated automatically by GPS data or manually by the user)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_JAPAN_AREARelUpReg;

/**
 * The error message of 'FID_TUN_G_JAPAN_AREA'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_G_JAPAN_AREAError;

/**
 * The upreg message of the property "FID_TUN_G_GET_ACTIVE_PRESETLISTID"
 * This provides the active preset list ID of FM and AM.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_GET_ACTIVE_PRESETLISTIDUpReg;

/**
 * The relUpReg message of the property "FID_TUN_G_GET_ACTIVE_PRESETLISTID"
 * This provides the active preset list ID of FM and AM.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_GET_ACTIVE_PRESETLISTIDRelUpReg;

/**
 * The error message of 'FID_TUN_G_GET_ACTIVE_PRESETLISTID'
 * possible erros of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_G_GET_ACTIVE_PRESETLISTIDError;

/**
 * The upreg message of the property "FID_TUN_G_JAPAN_STATION_NAME_LIST"
 * Provides the list of Japan station names available for selected area code and given frequency. Status update will be sent upon UpReg.
 * Until RelUpReg is triggered, status will be posted to clients whenever there is change in language, area code, frequency or station name selection. RelUpReg whenever update is not needed.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_JAPAN_STATION_NAME_LISTUpReg;

/**
 * The relUpReg message of the property "FID_TUN_G_JAPAN_STATION_NAME_LIST"
 * Provides the list of Japan station names available for selected area code and given frequency. Status update will be sent upon UpReg.
 * Until RelUpReg is triggered, status will be posted to clients whenever there is change in language, area code, frequency or station name selection. RelUpReg whenever update is not needed.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUN_G_JAPAN_STATION_NAME_LISTRelUpReg;

/**
 * The error message of 'FID_TUN_G_JAPAN_STATION_NAME_LIST'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUN_G_JAPAN_STATION_NAME_LISTError;


/**
 * The start message of the method "FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADER"
 * Radio frequency can be manually adjusted in steps in the upward / downward direction.
 * FM: 87.5 - 108 MHz, Step 100 KHz, MW: 531 - 1620 kHz, Step 9 kHz, LW: 153 - 279 kHz, Step 3 kHz.
 * This is currently not used. It is just retained for removing the
 * build error till the FID is ported into HMI.
 */
class FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERStart (const FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERStart (::tuner_main_fi_types::T_e8_Tun_ManualFreqAdjustment ManualFreqAdjustment_, ::tuner_main_fi_types::T_e8_Tun_TunerHeader TunerHeader_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERStart();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERStart& operator = (const FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ManualFreqAdjustment"

    static const int kManualFreqAdjustment = 0;

    /**
     * Clears the field "ManualFreqAdjustment".
     *
     * The field will be set to its default value. The hasManualFreqAdjustment()
     * method will return false.
     */
    inline void clearManualFreqAdjustment();

    /**
     * Checks whether the field "ManualFreqAdjustment" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setManualFreqAdjustment()). Otherwise it will return false.
     */
    inline bool hasManualFreqAdjustment () const;

    /**
     * Returns the value of the member "ManualFreqAdjustment".
     *
     * .
     *
     * @return The value of the field "ManualFreqAdjustment"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_ManualFreqAdjustment getManualFreqAdjustment () const;

    /**
     * Sets the value of the member "ManualFreqAdjustment".
     *
     * .
     *
     * @param ManualFreqAdjustment The value which will be set
     */
    inline void setManualFreqAdjustment (::tuner_main_fi_types::T_e8_Tun_ManualFreqAdjustment ManualFreqAdjustment_);

    // API of field "TunerHeader"

    static const int kTunerHeader = 1;

    /**
     * Clears the field "TunerHeader".
     *
     * The field will be set to its default value. The hasTunerHeader()
     * method will return false.
     */
    inline void clearTunerHeader();

    /**
     * Checks whether the field "TunerHeader" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerHeader()). Otherwise it will return false.
     */
    inline bool hasTunerHeader () const;

    /**
     * Returns the value of the member "TunerHeader".
     *
     * The tuner for which the Manual tuning has
     * to be performed.
     *
     * @return The value of the field "TunerHeader"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_TunerHeader getTunerHeader () const;

    /**
     * Sets the value of the member "TunerHeader".
     *
     * The tuner for which the Manual tuning has
     * to be performed.
     *
     * @param TunerHeader The value which will be set
     */
    inline void setTunerHeader (::tuner_main_fi_types::T_e8_Tun_TunerHeader TunerHeader_);

    static const FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERStart &getDefaultInstance();

private:

    inline void set_has_ManualFreqAdjustment ();

    inline void clear_has_ManualFreqAdjustment ();

    inline void set_has_TunerHeader ();

    inline void clear_has_TunerHeader ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::tuner_main_fi_types::T_e8_Tun_ManualFreqAdjustment _ManualFreqAdjustment;

    ::tuner_main_fi_types::T_e8_Tun_TunerHeader _TunerHeader;

};

/**
 * The result message of the method "FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADER"
 * Radio frequency can be manually adjusted in steps in the upward / downward direction.
 * FM: 87.5 - 108 MHz, Step 100 KHz, MW: 531 - 1620 kHz, Step 9 kHz, LW: 153 - 279 kHz, Step 3 kHz.
 * This is currently not used. It is just retained for removing the
 * build error till the FID is ported into HMI.
 * .
 */
class FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERResult (const FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERResult();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERResult& operator = (const FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerServer_StatusResponse"

    static const int kTunerServer_StatusResponse = 0;

    /**
     * Clears the field "TunerServer_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerServer_StatusResponse()
     * method will return false.
     */
    inline void clearTunerServer_StatusResponse();

    /**
     * Checks whether the field "TunerServer_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerServer_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerServer_StatusResponse () const;

    /**
     * Returns the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @return The value of the field "TunerServer_StatusResponse"
     */
    inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerServer_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerServer_StatusResponse".
     */
    inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @param TunerServer_StatusResponse The value which will be set
     */
    inline void setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    static const FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERResult &getDefaultInstance();

private:

    inline void set_has_TunerServer_StatusResponse ();

    inline void clear_has_TunerServer_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_TunerServer_StatusResponse _TunerServer_StatusResponse;

};

/**
 * The start message of the method "FID_TUN_S_ATFREQUENCY"
 * Radio frequency can be manually adjusted in steps in the upward / downward direction.
 * FM: 87.5 - 108 MHz, Step 100 KHz, MW: 531 - 1620 kHz, Step 9 kHz, LW: 153 - 279 kHz, Step 3 kHz.
 */
class FID_TUN_S_ATFREQUENCYStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_ATFREQUENCYStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_ATFREQUENCYStart (const FID_TUN_S_ATFREQUENCYStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_ATFREQUENCYStart (::tuner_main_fi_types::T_e8_Tun_TunerHeader TunerHeader_, const ::tuner_main_fi_types::T_TunerManualSingleStep& TunerManualSingleStep_, ::tuner_main_fi_types::T_e8_Tun_AcceptAF u8AcceptAF_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_ATFREQUENCYStart();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_ATFREQUENCYStart& operator = (const FID_TUN_S_ATFREQUENCYStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_ATFREQUENCYStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_ATFREQUENCYStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_ATFREQUENCYStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_ATFREQUENCYStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerHeader"

    static const int kTunerHeader = 0;

    /**
     * Clears the field "TunerHeader".
     *
     * The field will be set to its default value. The hasTunerHeader()
     * method will return false.
     */
    inline void clearTunerHeader();

    /**
     * Checks whether the field "TunerHeader" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerHeader()). Otherwise it will return false.
     */
    inline bool hasTunerHeader () const;

    /**
     * Returns the value of the member "TunerHeader".
     *
     * The tuner for which the Manual tuning has
     * to be performed.
     *
     * @return The value of the field "TunerHeader"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_TunerHeader getTunerHeader () const;

    /**
     * Sets the value of the member "TunerHeader".
     *
     * The tuner for which the Manual tuning has
     * to be performed.
     *
     * @param TunerHeader The value which will be set
     */
    inline void setTunerHeader (::tuner_main_fi_types::T_e8_Tun_TunerHeader TunerHeader_);

    // API of field "TunerManualSingleStep"

    static const int kTunerManualSingleStep = 1;

    /**
     * Clears the field "TunerManualSingleStep".
     *
     * The field will be set to its default value. The hasTunerManualSingleStep()
     * method will return false.
     */
    inline void clearTunerManualSingleStep();

    /**
     * Checks whether the field "TunerManualSingleStep" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerManualSingleStep()). Otherwise it will return false.
     */
    inline bool hasTunerManualSingleStep () const;

    /**
     * Returns the value of the member "TunerManualSingleStep".
     *
     * Includes the parameters number of ticks and
     * manual tune direction information.
     *
     * @return The value of the field "TunerManualSingleStep"
     */
    inline const ::tuner_main_fi_types::T_TunerManualSingleStep& getTunerManualSingleStep () const;

    /**
     * Retrieves the value of the field "TunerManualSingleStep" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerManualSingleStep".
     */
    inline ::tuner_main_fi_types::T_TunerManualSingleStep& getTunerManualSingleStepMutable ();

    /**
     * Sets the value of the member "TunerManualSingleStep".
     *
     * Includes the parameters number of ticks and
     * manual tune direction information.
     *
     * @param TunerManualSingleStep The value which will be set
     */
    inline void setTunerManualSingleStep (const ::tuner_main_fi_types::T_TunerManualSingleStep& TunerManualSingleStep_);

    // API of field "u8AcceptAF"

    static const int kU8AcceptAF = 2;

    /**
     * Clears the field "u8AcceptAF".
     *
     * The field will be set to its default value. The hasU8AcceptAF()
     * method will return false.
     */
    inline void clearU8AcceptAF();

    /**
     * Checks whether the field "u8AcceptAF" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8AcceptAF()). Otherwise it will return false.
     */
    inline bool hasU8AcceptAF () const;

    /**
     * Returns the value of the member "u8AcceptAF".
     *
     * This parameter indicates whether the Alternate
     * frequency should be accepted as the base frequency for
     * further manual tune or seek.
     *
     * @return The value of the field "u8AcceptAF"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_AcceptAF getU8AcceptAF () const;

    /**
     * Sets the value of the member "u8AcceptAF".
     *
     * This parameter indicates whether the Alternate
     * frequency should be accepted as the base frequency for
     * further manual tune or seek.
     *
     * @param u8AcceptAF The value which will be set
     */
    inline void setU8AcceptAF (::tuner_main_fi_types::T_e8_Tun_AcceptAF u8AcceptAF_);

    static const FID_TUN_S_ATFREQUENCYStart &getDefaultInstance();

private:

    inline void set_has_TunerHeader ();

    inline void clear_has_TunerHeader ();

    inline void set_has_TunerManualSingleStep ();

    inline void clear_has_TunerManualSingleStep ();

    inline void set_has_u8AcceptAF ();

    inline void clear_has_u8AcceptAF ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::tuner_main_fi_types::T_e8_Tun_TunerHeader _TunerHeader;

    ::tuner_main_fi_types::T_TunerManualSingleStep _TunerManualSingleStep;

    ::tuner_main_fi_types::T_e8_Tun_AcceptAF _u8AcceptAF;

};

/**
 * The result message of the method "FID_TUN_S_ATFREQUENCY"
 * Radio frequency can be manually adjusted in steps in the upward / downward direction.
 * FM: 87.5 - 108 MHz, Step 100 KHz, MW: 531 - 1620 kHz, Step 9 kHz, LW: 153 - 279 kHz, Step 3 kHz.
 * .
 */
class FID_TUN_S_ATFREQUENCYResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_ATFREQUENCYResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_ATFREQUENCYResult (const FID_TUN_S_ATFREQUENCYResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_ATFREQUENCYResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_ATFREQUENCYResult();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_ATFREQUENCYResult& operator = (const FID_TUN_S_ATFREQUENCYResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_ATFREQUENCYResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_ATFREQUENCYResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_ATFREQUENCYResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_ATFREQUENCYResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerServer_StatusResponse"

    static const int kTunerServer_StatusResponse = 0;

    /**
     * Clears the field "TunerServer_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerServer_StatusResponse()
     * method will return false.
     */
    inline void clearTunerServer_StatusResponse();

    /**
     * Checks whether the field "TunerServer_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerServer_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerServer_StatusResponse () const;

    /**
     * Returns the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @return The value of the field "TunerServer_StatusResponse"
     */
    inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerServer_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerServer_StatusResponse".
     */
    inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @param TunerServer_StatusResponse The value which will be set
     */
    inline void setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    static const FID_TUN_S_ATFREQUENCYResult &getDefaultInstance();

private:

    inline void set_has_TunerServer_StatusResponse ();

    inline void clear_has_TunerServer_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_TunerServer_StatusResponse _TunerServer_StatusResponse;

};

/**
 * The start message of the method "FID_TUN_S_ATSEEK_WITH_TUNERHEADER"
 * With this command, different seeks can be started on
 * either Tuner1 or Tuner2.
 */
class FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart (const FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart (::tuner_main_fi_types::T_e8_Tun_TunerSeek u8TunerSeek_, ::tuner_main_fi_types::T_e8_Tun_TunerHeader u8TunerHeader_, uint32 u32Frequency_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart& operator = (const FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8TunerSeek"

    static const int kU8TunerSeek = 0;

    /**
     * Clears the field "u8TunerSeek".
     *
     * The field will be set to its default value. The hasU8TunerSeek()
     * method will return false.
     */
    inline void clearU8TunerSeek();

    /**
     * Checks whether the field "u8TunerSeek" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8TunerSeek()). Otherwise it will return false.
     */
    inline bool hasU8TunerSeek () const;

    /**
     * Returns the value of the member "u8TunerSeek".
     *
     * .
     *
     * @return The value of the field "u8TunerSeek"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_TunerSeek getU8TunerSeek () const;

    /**
     * Sets the value of the member "u8TunerSeek".
     *
     * .
     *
     * @param u8TunerSeek The value which will be set
     */
    inline void setU8TunerSeek (::tuner_main_fi_types::T_e8_Tun_TunerSeek u8TunerSeek_);

    // API of field "u8TunerHeader"

    static const int kU8TunerHeader = 1;

    /**
     * Clears the field "u8TunerHeader".
     *
     * The field will be set to its default value. The hasU8TunerHeader()
     * method will return false.
     */
    inline void clearU8TunerHeader();

    /**
     * Checks whether the field "u8TunerHeader" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8TunerHeader()). Otherwise it will return false.
     */
    inline bool hasU8TunerHeader () const;

    /**
     * Returns the value of the member "u8TunerHeader".
     *
     * Tuner for which the seek has to be performed.
     *
     * @return The value of the field "u8TunerHeader"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_TunerHeader getU8TunerHeader () const;

    /**
     * Sets the value of the member "u8TunerHeader".
     *
     * Tuner for which the seek has to be performed.
     *
     * @param u8TunerHeader The value which will be set
     */
    inline void setU8TunerHeader (::tuner_main_fi_types::T_e8_Tun_TunerHeader u8TunerHeader_);

    // API of field "u32Frequency"

    static const int kU32Frequency = 2;

    /**
     * Clears the field "u32Frequency".
     *
     * The field will be set to its default value. The hasU32Frequency()
     * method will return false.
     */
    inline void clearU32Frequency();

    /**
     * Checks whether the field "u32Frequency" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Frequency()). Otherwise it will return false.
     */
    inline bool hasU32Frequency () const;

    /**
     * Returns the value of the member "u32Frequency".
     *
     * Frequency used by radio lib to perform seek
     * operation.
     *
     * @return The value of the field "u32Frequency"
     */
    inline uint32 getU32Frequency () const;

    /**
     * Sets the value of the member "u32Frequency".
     *
     * Frequency used by radio lib to perform seek
     * operation.
     *
     * @param u32Frequency The value which will be set
     */
    inline void setU32Frequency (uint32 u32Frequency_);

    static const FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart &getDefaultInstance();

private:

    inline void set_has_u8TunerSeek ();

    inline void clear_has_u8TunerSeek ();

    inline void set_has_u8TunerHeader ();

    inline void clear_has_u8TunerHeader ();

    inline void set_has_u32Frequency ();

    inline void clear_has_u32Frequency ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::tuner_main_fi_types::T_e8_Tun_TunerSeek _u8TunerSeek;

    ::tuner_main_fi_types::T_e8_Tun_TunerHeader _u8TunerHeader;

    uint32 _u32Frequency;

};

/**
 * The result message of the method "FID_TUN_S_ATSEEK_WITH_TUNERHEADER"
 * With this command, different seeks can be started on
 * either Tuner1 or Tuner2.
 * .
 */
class FID_TUN_S_ATSEEK_WITH_TUNERHEADERResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_ATSEEK_WITH_TUNERHEADERResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_ATSEEK_WITH_TUNERHEADERResult (const FID_TUN_S_ATSEEK_WITH_TUNERHEADERResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_ATSEEK_WITH_TUNERHEADERResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_ATSEEK_WITH_TUNERHEADERResult();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_ATSEEK_WITH_TUNERHEADERResult& operator = (const FID_TUN_S_ATSEEK_WITH_TUNERHEADERResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_ATSEEK_WITH_TUNERHEADERResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_ATSEEK_WITH_TUNERHEADERResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_ATSEEK_WITH_TUNERHEADERResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_ATSEEK_WITH_TUNERHEADERResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerServer_StatusResponse"

    static const int kTunerServer_StatusResponse = 0;

    /**
     * Clears the field "TunerServer_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerServer_StatusResponse()
     * method will return false.
     */
    inline void clearTunerServer_StatusResponse();

    /**
     * Checks whether the field "TunerServer_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerServer_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerServer_StatusResponse () const;

    /**
     * Returns the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @return The value of the field "TunerServer_StatusResponse"
     */
    inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerServer_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerServer_StatusResponse".
     */
    inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @param TunerServer_StatusResponse The value which will be set
     */
    inline void setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    static const FID_TUN_S_ATSEEK_WITH_TUNERHEADERResult &getDefaultInstance();

private:

    inline void set_has_TunerServer_StatusResponse ();

    inline void clear_has_TunerServer_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_TunerServer_StatusResponse _TunerServer_StatusResponse;

};

/**
 * The result message of the method "FID_S_TUN_GET_FIELD_STRENGTH"
 * Through this method, FC_Diagnosis can ask for the current field strength.
 * This indicates whether method start was accepted or rejected.
 */
class FID_S_TUN_GET_FIELD_STRENGTHResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_S_TUN_GET_FIELD_STRENGTHResult ();

    /**
     * Copy constructor
     */
    inline  FID_S_TUN_GET_FIELD_STRENGTHResult (const FID_S_TUN_GET_FIELD_STRENGTHResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_S_TUN_GET_FIELD_STRENGTHResult (uint8 Tuner_Field_Strength_);

    /**
     * Destructor
     */
    inline virtual  ~FID_S_TUN_GET_FIELD_STRENGTHResult();

    /**
     * Assignment operator
     */
    inline FID_S_TUN_GET_FIELD_STRENGTHResult& operator = (const FID_S_TUN_GET_FIELD_STRENGTHResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_S_TUN_GET_FIELD_STRENGTHResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_S_TUN_GET_FIELD_STRENGTHResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_S_TUN_GET_FIELD_STRENGTHResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_S_TUN_GET_FIELD_STRENGTHResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Tuner_Field_Strength"

    static const int kTuner_Field_Strength = 0;

    /**
     * Clears the field "Tuner_Field_Strength".
     *
     * The field will be set to its default value. The hasTuner_Field_Strength()
     * method will return false.
     */
    inline void clearTuner_Field_Strength();

    /**
     * Checks whether the field "Tuner_Field_Strength" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTuner_Field_Strength()). Otherwise it will return false.
     */
    inline bool hasTuner_Field_Strength () const;

    /**
     * Returns the value of the member "Tuner_Field_Strength".
     *
     * Holds the field strength value
     *
     * @return The value of the field "Tuner_Field_Strength"
     */
    inline uint8 getTuner_Field_Strength () const;

    /**
     * Sets the value of the member "Tuner_Field_Strength".
     *
     * Holds the field strength value
     *
     * @param Tuner_Field_Strength The value which will be set
     */
    inline void setTuner_Field_Strength (uint8 Tuner_Field_Strength_);

    static const FID_S_TUN_GET_FIELD_STRENGTHResult &getDefaultInstance();

private:

    inline void set_has_Tuner_Field_Strength ();

    inline void clear_has_Tuner_Field_Strength ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Tuner_Field_Strength;

};

/**
 * The start message of the method "FID_TUN_S_SET_ACTIVE_PRESETLIST"
 * With this command, Mixed preset  list can be selected.
 */
class FID_TUN_S_SET_ACTIVE_PRESETLISTStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_SET_ACTIVE_PRESETLISTStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_SET_ACTIVE_PRESETLISTStart (const FID_TUN_S_SET_ACTIVE_PRESETLISTStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_SET_ACTIVE_PRESETLISTStart (::tuner_main_fi_types::T_e8_Tun_ListID e8ListID_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_SET_ACTIVE_PRESETLISTStart();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_SET_ACTIVE_PRESETLISTStart& operator = (const FID_TUN_S_SET_ACTIVE_PRESETLISTStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_SET_ACTIVE_PRESETLISTStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_SET_ACTIVE_PRESETLISTStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_SET_ACTIVE_PRESETLISTStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_SET_ACTIVE_PRESETLISTStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ListID"

    static const int kE8ListID = 0;

    /**
     * Clears the field "e8ListID".
     *
     * The field will be set to its default value. The hasE8ListID()
     * method will return false.
     */
    inline void clearE8ListID();

    /**
     * Checks whether the field "e8ListID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ListID()). Otherwise it will return false.
     */
    inline bool hasE8ListID () const;

    /**
     * Returns the value of the member "e8ListID".
     *
     * .
     *
     * @return The value of the field "e8ListID"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_ListID getE8ListID () const;

    /**
     * Sets the value of the member "e8ListID".
     *
     * .
     *
     * @param e8ListID The value which will be set
     */
    inline void setE8ListID (::tuner_main_fi_types::T_e8_Tun_ListID e8ListID_);

    static const FID_TUN_S_SET_ACTIVE_PRESETLISTStart &getDefaultInstance();

private:

    inline void set_has_e8ListID ();

    inline void clear_has_e8ListID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_e8_Tun_ListID _e8ListID;

};

/**
 * The result message of the method "FID_TUN_S_SET_ACTIVE_PRESETLIST"
 * With this command, Mixed preset  list can be selected.
 * .
 */
class FID_TUN_S_SET_ACTIVE_PRESETLISTResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_SET_ACTIVE_PRESETLISTResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_SET_ACTIVE_PRESETLISTResult (const FID_TUN_S_SET_ACTIVE_PRESETLISTResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_SET_ACTIVE_PRESETLISTResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_SET_ACTIVE_PRESETLISTResult();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_SET_ACTIVE_PRESETLISTResult& operator = (const FID_TUN_S_SET_ACTIVE_PRESETLISTResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_SET_ACTIVE_PRESETLISTResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_SET_ACTIVE_PRESETLISTResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_SET_ACTIVE_PRESETLISTResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_SET_ACTIVE_PRESETLISTResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerServer_StatusResponse"

    static const int kTunerServer_StatusResponse = 0;

    /**
     * Clears the field "TunerServer_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerServer_StatusResponse()
     * method will return false.
     */
    inline void clearTunerServer_StatusResponse();

    /**
     * Checks whether the field "TunerServer_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerServer_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerServer_StatusResponse () const;

    /**
     * Returns the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @return The value of the field "TunerServer_StatusResponse"
     */
    inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerServer_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerServer_StatusResponse".
     */
    inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @param TunerServer_StatusResponse The value which will be set
     */
    inline void setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    static const FID_TUN_S_SET_ACTIVE_PRESETLISTResult &getDefaultInstance();

private:

    inline void set_has_TunerServer_StatusResponse ();

    inline void clear_has_TunerServer_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_TunerServer_StatusResponse _TunerServer_StatusResponse;

};

/**
 * The start message of the method "FID_TUN_S_SET_FEATURE"
 * Tuner features can be switched ON OR OFF.
 * Note: This fi is to be used for one feature at a time.
 */
class FID_TUN_S_SET_FEATUREStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_SET_FEATUREStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_SET_FEATUREStart (const FID_TUN_S_SET_FEATUREStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_SET_FEATUREStart (const ::tuner_main_fi_types::T_TunerFeature& TunerFeature_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_SET_FEATUREStart();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_SET_FEATUREStart& operator = (const FID_TUN_S_SET_FEATUREStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_SET_FEATUREStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_SET_FEATUREStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_SET_FEATUREStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_SET_FEATUREStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerFeature"

    static const int kTunerFeature = 0;

    /**
     * Clears the field "TunerFeature".
     *
     * The field will be set to its default value. The hasTunerFeature()
     * method will return false.
     */
    inline void clearTunerFeature();

    /**
     * Checks whether the field "TunerFeature" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerFeature()). Otherwise it will return false.
     */
    inline bool hasTunerFeature () const;

    /**
     * Returns the value of the member "TunerFeature".
     *
     * Class to be used: tunmsg_tclSetTunerFeature   from file: tun_hmi_if_message.h.
     *
     * @return The value of the field "TunerFeature"
     */
    inline const ::tuner_main_fi_types::T_TunerFeature& getTunerFeature () const;

    /**
     * Retrieves the value of the field "TunerFeature" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerFeature".
     */
    inline ::tuner_main_fi_types::T_TunerFeature& getTunerFeatureMutable ();

    /**
     * Sets the value of the member "TunerFeature".
     *
     * Class to be used: tunmsg_tclSetTunerFeature   from file: tun_hmi_if_message.h.
     *
     * @param TunerFeature The value which will be set
     */
    inline void setTunerFeature (const ::tuner_main_fi_types::T_TunerFeature& TunerFeature_);

    static const FID_TUN_S_SET_FEATUREStart &getDefaultInstance();

private:

    inline void set_has_TunerFeature ();

    inline void clear_has_TunerFeature ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_TunerFeature _TunerFeature;

};

/**
 * The result message of the method "FID_TUN_S_SET_FEATURE"
 * Tuner features can be switched ON OR OFF.
 * Note: This fi is to be used for one feature at a time.
 * .
 */
class FID_TUN_S_SET_FEATUREResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_SET_FEATUREResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_SET_FEATUREResult (const FID_TUN_S_SET_FEATUREResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_SET_FEATUREResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_SET_FEATUREResult();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_SET_FEATUREResult& operator = (const FID_TUN_S_SET_FEATUREResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_SET_FEATUREResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_SET_FEATUREResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_SET_FEATUREResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_SET_FEATUREResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerServer_StatusResponse"

    static const int kTunerServer_StatusResponse = 0;

    /**
     * Clears the field "TunerServer_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerServer_StatusResponse()
     * method will return false.
     */
    inline void clearTunerServer_StatusResponse();

    /**
     * Checks whether the field "TunerServer_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerServer_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerServer_StatusResponse () const;

    /**
     * Returns the value of the member "TunerServer_StatusResponse".
     *
     * Class to be used: gm_tclU16Message.
     *
     * @return The value of the field "TunerServer_StatusResponse"
     */
    inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerServer_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerServer_StatusResponse".
     */
    inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerServer_StatusResponse".
     *
     * Class to be used: gm_tclU16Message.
     *
     * @param TunerServer_StatusResponse The value which will be set
     */
    inline void setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    static const FID_TUN_S_SET_FEATUREResult &getDefaultInstance();

private:

    inline void set_has_TunerServer_StatusResponse ();

    inline void clear_has_TunerServer_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_TunerServer_StatusResponse _TunerServer_StatusResponse;

};

/**
 * The start message of the method "FID_TUN_S_SET_HICUT"
 * This method is used to set HICUT level.
 */
class FID_TUN_S_SET_HICUTStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_SET_HICUTStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_SET_HICUTStart (const FID_TUN_S_SET_HICUTStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_SET_HICUTStart (uint8 u8AbsVal_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_SET_HICUTStart();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_SET_HICUTStart& operator = (const FID_TUN_S_SET_HICUTStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_SET_HICUTStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_SET_HICUTStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_SET_HICUTStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_SET_HICUTStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8AbsVal"

    static const int kU8AbsVal = 0;

    /**
     * Clears the field "u8AbsVal".
     *
     * The field will be set to its default value. The hasU8AbsVal()
     * method will return false.
     */
    inline void clearU8AbsVal();

    /**
     * Checks whether the field "u8AbsVal" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8AbsVal()). Otherwise it will return false.
     */
    inline bool hasU8AbsVal () const;

    /**
     * Returns the value of the member "u8AbsVal".
     *
     * .
     *
     * @return The value of the field "u8AbsVal"
     */
    inline uint8 getU8AbsVal () const;

    /**
     * Sets the value of the member "u8AbsVal".
     *
     * .
     *
     * @param u8AbsVal The value which will be set
     */
    inline void setU8AbsVal (uint8 u8AbsVal_);

    static const FID_TUN_S_SET_HICUTStart &getDefaultInstance();

private:

    inline void set_has_u8AbsVal ();

    inline void clear_has_u8AbsVal ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8AbsVal;

};

/**
 * The result message of the method "FID_TUN_S_SET_HICUT"
 * This method is used to set HICUT level.
 * .
 */
class FID_TUN_S_SET_HICUTResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_SET_HICUTResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_SET_HICUTResult (const FID_TUN_S_SET_HICUTResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_SET_HICUTResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_SET_HICUTResult();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_SET_HICUTResult& operator = (const FID_TUN_S_SET_HICUTResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_SET_HICUTResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_SET_HICUTResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_SET_HICUTResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_SET_HICUTResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerServer_StatusResponse"

    static const int kTunerServer_StatusResponse = 0;

    /**
     * Clears the field "TunerServer_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerServer_StatusResponse()
     * method will return false.
     */
    inline void clearTunerServer_StatusResponse();

    /**
     * Checks whether the field "TunerServer_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerServer_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerServer_StatusResponse () const;

    /**
     * Returns the value of the member "TunerServer_StatusResponse".
     *
     * Class to be used: gm_tclU16Message.
     *
     * @return The value of the field "TunerServer_StatusResponse"
     */
    inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerServer_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerServer_StatusResponse".
     */
    inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerServer_StatusResponse".
     *
     * Class to be used: gm_tclU16Message.
     *
     * @param TunerServer_StatusResponse The value which will be set
     */
    inline void setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    static const FID_TUN_S_SET_HICUTResult &getDefaultInstance();

private:

    inline void set_has_TunerServer_StatusResponse ();

    inline void clear_has_TunerServer_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_TunerServer_StatusResponse _TunerServer_StatusResponse;

};

/**
 * The start message of the method "FID_TUN_S_AFLIST_V2"
 * This method is used to get the contents of the Af-List and notifying a continuous update if the testmode is
 * enabled.
 */
class FID_TUN_S_AFLIST_V2Start  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_AFLIST_V2Start ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_AFLIST_V2Start (const FID_TUN_S_AFLIST_V2Start &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_AFLIST_V2Start (::tuner_main_fi_types::T_e8_Tun_Notification u8Notification_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_AFLIST_V2Start();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_AFLIST_V2Start& operator = (const FID_TUN_S_AFLIST_V2Start& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_AFLIST_V2Start& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_AFLIST_V2Start& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_AFLIST_V2Start& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_AFLIST_V2Start& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8Notification"

    static const int kU8Notification = 0;

    /**
     * Clears the field "u8Notification".
     *
     * The field will be set to its default value. The hasU8Notification()
     * method will return false.
     */
    inline void clearU8Notification();

    /**
     * Checks whether the field "u8Notification" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Notification()). Otherwise it will return false.
     */
    inline bool hasU8Notification () const;

    /**
     * Returns the value of the member "u8Notification".
     *
     * .
     *
     * @return The value of the field "u8Notification"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_Notification getU8Notification () const;

    /**
     * Sets the value of the member "u8Notification".
     *
     * .
     *
     * @param u8Notification The value which will be set
     */
    inline void setU8Notification (::tuner_main_fi_types::T_e8_Tun_Notification u8Notification_);

    static const FID_TUN_S_AFLIST_V2Start &getDefaultInstance();

private:

    inline void set_has_u8Notification ();

    inline void clear_has_u8Notification ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_e8_Tun_Notification _u8Notification;

};

/**
 * The result message of the method "FID_TUN_S_AFLIST_V2"
 * This method is used to get the contents of the Af-List and notifying a continuous update if the testmode is
 * enabled.
 * .
 */
class FID_TUN_S_AFLIST_V2Result  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_AFLIST_V2Result ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_AFLIST_V2Result (const FID_TUN_S_AFLIST_V2Result &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_AFLIST_V2Result (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_AFLIST_V2Result();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_AFLIST_V2Result& operator = (const FID_TUN_S_AFLIST_V2Result& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_AFLIST_V2Result& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_AFLIST_V2Result& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_AFLIST_V2Result& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_AFLIST_V2Result& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerServer_StatusResponse"

    static const int kTunerServer_StatusResponse = 0;

    /**
     * Clears the field "TunerServer_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerServer_StatusResponse()
     * method will return false.
     */
    inline void clearTunerServer_StatusResponse();

    /**
     * Checks whether the field "TunerServer_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerServer_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerServer_StatusResponse () const;

    /**
     * Returns the value of the member "TunerServer_StatusResponse".
     *
     * Class to be used: gm_tclU16Message.
     *
     * @return The value of the field "TunerServer_StatusResponse"
     */
    inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerServer_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerServer_StatusResponse".
     */
    inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerServer_StatusResponse".
     *
     * Class to be used: gm_tclU16Message.
     *
     * @param TunerServer_StatusResponse The value which will be set
     */
    inline void setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    static const FID_TUN_S_AFLIST_V2Result &getDefaultInstance();

private:

    inline void set_has_TunerServer_StatusResponse ();

    inline void clear_has_TunerServer_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_TunerServer_StatusResponse _TunerServer_StatusResponse;

};

/**
 * The start message of the method "FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2"
 * This method is used to Select an element from Af-List.
 * While selecting element mode should be AFJUMP OFF.
 * While leaving TestMode this method should be called again with mode = AFJUMP ON
 */
class FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start (const FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start (::tuner_main_fi_types::T_e8_Tun_PhysicalTuner u8PhysicalTunerId_, ::tuner_main_fi_types::T_e8_Tun_TestTuneFrequencyMode u8Mode_, uint32 u32Frequency_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start& operator = (const FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8PhysicalTunerId"

    static const int kU8PhysicalTunerId = 0;

    /**
     * Clears the field "u8PhysicalTunerId".
     *
     * The field will be set to its default value. The hasU8PhysicalTunerId()
     * method will return false.
     */
    inline void clearU8PhysicalTunerId();

    /**
     * Checks whether the field "u8PhysicalTunerId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8PhysicalTunerId()). Otherwise it will return false.
     */
    inline bool hasU8PhysicalTunerId () const;

    /**
     * Returns the value of the member "u8PhysicalTunerId".
     *
     * Tuner Id to which the frequency must be tuned to. Range 0 - 3
     *
     * @return The value of the field "u8PhysicalTunerId"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_PhysicalTuner getU8PhysicalTunerId () const;

    /**
     * Sets the value of the member "u8PhysicalTunerId".
     *
     * Tuner Id to which the frequency must be tuned to. Range 0 - 3
     *
     * @param u8PhysicalTunerId The value which will be set
     */
    inline void setU8PhysicalTunerId (::tuner_main_fi_types::T_e8_Tun_PhysicalTuner u8PhysicalTunerId_);

    // API of field "u8Mode"

    static const int kU8Mode = 1;

    /**
     * Clears the field "u8Mode".
     *
     * The field will be set to its default value. The hasU8Mode()
     * method will return false.
     */
    inline void clearU8Mode();

    /**
     * Checks whether the field "u8Mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Mode()). Otherwise it will return false.
     */
    inline bool hasU8Mode () const;

    /**
     * Returns the value of the member "u8Mode".
     *
     * Mode (AF JUMP ON/OFF) of selection
     *
     * @return The value of the field "u8Mode"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_TestTuneFrequencyMode getU8Mode () const;

    /**
     * Sets the value of the member "u8Mode".
     *
     * Mode (AF JUMP ON/OFF) of selection
     *
     * @param u8Mode The value which will be set
     */
    inline void setU8Mode (::tuner_main_fi_types::T_e8_Tun_TestTuneFrequencyMode u8Mode_);

    // API of field "u32Frequency"

    static const int kU32Frequency = 2;

    /**
     * Clears the field "u32Frequency".
     *
     * The field will be set to its default value. The hasU32Frequency()
     * method will return false.
     */
    inline void clearU32Frequency();

    /**
     * Checks whether the field "u32Frequency" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Frequency()). Otherwise it will return false.
     */
    inline bool hasU32Frequency () const;

    /**
     * Returns the value of the member "u32Frequency".
     *
     * Frequency to be tuned.
     *
     * @return The value of the field "u32Frequency"
     */
    inline uint32 getU32Frequency () const;

    /**
     * Sets the value of the member "u32Frequency".
     *
     * Frequency to be tuned.
     *
     * @param u32Frequency The value which will be set
     */
    inline void setU32Frequency (uint32 u32Frequency_);

    static const FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start &getDefaultInstance();

private:

    inline void set_has_u8PhysicalTunerId ();

    inline void clear_has_u8PhysicalTunerId ();

    inline void set_has_u8Mode ();

    inline void clear_has_u8Mode ();

    inline void set_has_u32Frequency ();

    inline void clear_has_u32Frequency ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::tuner_main_fi_types::T_e8_Tun_PhysicalTuner _u8PhysicalTunerId;

    ::tuner_main_fi_types::T_e8_Tun_TestTuneFrequencyMode _u8Mode;

    uint32 _u32Frequency;

};

/**
 * The result message of the method "FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2"
 * This method is used to Select an element from Af-List.
 * While selecting element mode should be AFJUMP OFF.
 * While leaving TestMode this method should be called again with mode = AFJUMP ON
 * .
 */
class FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Result  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Result ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Result (const FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Result &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Result (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Result();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Result& operator = (const FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Result& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Result& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Result& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Result& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Result& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerServer_StatusResponse"

    static const int kTunerServer_StatusResponse = 0;

    /**
     * Clears the field "TunerServer_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerServer_StatusResponse()
     * method will return false.
     */
    inline void clearTunerServer_StatusResponse();

    /**
     * Checks whether the field "TunerServer_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerServer_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerServer_StatusResponse () const;

    /**
     * Returns the value of the member "TunerServer_StatusResponse".
     *
     * Class to be used: gm_tclU16Message.
     *
     * @return The value of the field "TunerServer_StatusResponse"
     */
    inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerServer_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerServer_StatusResponse".
     */
    inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerServer_StatusResponse".
     *
     * Class to be used: gm_tclU16Message.
     *
     * @param TunerServer_StatusResponse The value which will be set
     */
    inline void setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    static const FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Result &getDefaultInstance();

private:

    inline void set_has_TunerServer_StatusResponse ();

    inline void clear_has_TunerServer_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_TunerServer_StatusResponse _TunerServer_StatusResponse;

};

/**
 * The start message of the method "FID_TUN_S_DIRECT_FREQUENCY"
 * This method is used to set the frequency directly input by the user.
 */
class FID_TUN_S_DIRECT_FREQUENCYStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_DIRECT_FREQUENCYStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_DIRECT_FREQUENCYStart (const FID_TUN_S_DIRECT_FREQUENCYStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_DIRECT_FREQUENCYStart (uint32 u32Frequency_, ::tuner_main_fi_types::T_e8_Tun_TunerBand u8Band_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_DIRECT_FREQUENCYStart();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_DIRECT_FREQUENCYStart& operator = (const FID_TUN_S_DIRECT_FREQUENCYStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_DIRECT_FREQUENCYStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_DIRECT_FREQUENCYStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_DIRECT_FREQUENCYStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_DIRECT_FREQUENCYStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32Frequency"

    static const int kU32Frequency = 0;

    /**
     * Clears the field "u32Frequency".
     *
     * The field will be set to its default value. The hasU32Frequency()
     * method will return false.
     */
    inline void clearU32Frequency();

    /**
     * Checks whether the field "u32Frequency" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Frequency()). Otherwise it will return false.
     */
    inline bool hasU32Frequency () const;

    /**
     * Returns the value of the member "u32Frequency".
     *
     * Frequency in Khz. Frequency range of Bands ,
     * FM  : 87500-108000,
     * MW : 531-1620,
     * LW  : 153-279
     *
     * @return The value of the field "u32Frequency"
     */
    inline uint32 getU32Frequency () const;

    /**
     * Sets the value of the member "u32Frequency".
     *
     * Frequency in Khz. Frequency range of Bands ,
     * FM  : 87500-108000,
     * MW : 531-1620,
     * LW  : 153-279
     *
     * @param u32Frequency The value which will be set
     */
    inline void setU32Frequency (uint32 u32Frequency_);

    // API of field "u8Band"

    static const int kU8Band = 1;

    /**
     * Clears the field "u8Band".
     *
     * The field will be set to its default value. The hasU8Band()
     * method will return false.
     */
    inline void clearU8Band();

    /**
     * Checks whether the field "u8Band" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Band()). Otherwise it will return false.
     */
    inline bool hasU8Band () const;

    /**
     * Returns the value of the member "u8Band".
     *
     * .
     *
     * @return The value of the field "u8Band"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_TunerBand getU8Band () const;

    /**
     * Sets the value of the member "u8Band".
     *
     * .
     *
     * @param u8Band The value which will be set
     */
    inline void setU8Band (::tuner_main_fi_types::T_e8_Tun_TunerBand u8Band_);

    static const FID_TUN_S_DIRECT_FREQUENCYStart &getDefaultInstance();

private:

    inline void set_has_u32Frequency ();

    inline void clear_has_u32Frequency ();

    inline void set_has_u8Band ();

    inline void clear_has_u8Band ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _u32Frequency;

    ::tuner_main_fi_types::T_e8_Tun_TunerBand _u8Band;

};

/**
 * The result message of the method "FID_TUN_S_DIRECT_FREQUENCY"
 * This method is used to set the frequency directly input by the user.
 * .
 */
class FID_TUN_S_DIRECT_FREQUENCYResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_DIRECT_FREQUENCYResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_DIRECT_FREQUENCYResult (const FID_TUN_S_DIRECT_FREQUENCYResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_DIRECT_FREQUENCYResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_DIRECT_FREQUENCYResult();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_DIRECT_FREQUENCYResult& operator = (const FID_TUN_S_DIRECT_FREQUENCYResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_DIRECT_FREQUENCYResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_DIRECT_FREQUENCYResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_DIRECT_FREQUENCYResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_DIRECT_FREQUENCYResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerServer_StatusResponse"

    static const int kTunerServer_StatusResponse = 0;

    /**
     * Clears the field "TunerServer_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerServer_StatusResponse()
     * method will return false.
     */
    inline void clearTunerServer_StatusResponse();

    /**
     * Checks whether the field "TunerServer_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerServer_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerServer_StatusResponse () const;

    /**
     * Returns the value of the member "TunerServer_StatusResponse".
     *
     * Class to be used: gm_tclU16Message.
     *
     * @return The value of the field "TunerServer_StatusResponse"
     */
    inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerServer_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerServer_StatusResponse".
     */
    inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerServer_StatusResponse".
     *
     * Class to be used: gm_tclU16Message.
     *
     * @param TunerServer_StatusResponse The value which will be set
     */
    inline void setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    static const FID_TUN_S_DIRECT_FREQUENCYResult &getDefaultInstance();

private:

    inline void set_has_TunerServer_StatusResponse ();

    inline void clear_has_TunerServer_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_TunerServer_StatusResponse _TunerServer_StatusResponse;

};

/**
 * The start message of the method "FID_TUN_S_AUTOSTORE"
 * method to start an autostore process. autostore will automatic
 * store stations on preset list.
 */
class FID_TUN_S_AUTOSTOREStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_AUTOSTOREStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_AUTOSTOREStart (const FID_TUN_S_AUTOSTOREStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_AUTOSTOREStart (bool bStatus_, ::tuner_main_fi_types::T_e8_Tun_ListID e8ListID_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_AUTOSTOREStart();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_AUTOSTOREStart& operator = (const FID_TUN_S_AUTOSTOREStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_AUTOSTOREStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_AUTOSTOREStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_AUTOSTOREStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_AUTOSTOREStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bStatus"

    static const int kBStatus = 0;

    /**
     * Clears the field "bStatus".
     *
     * The field will be set to its default value. The hasBStatus()
     * method will return false.
     */
    inline void clearBStatus();

    /**
     * Checks whether the field "bStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBStatus()). Otherwise it will return false.
     */
    inline bool hasBStatus () const;

    /**
     * Returns the value of the member "bStatus".
     *
     * 1: Start Auto store 0: Stop Auto Store
     *
     * @return The value of the field "bStatus"
     */
    inline bool getBStatus () const;

    /**
     * Sets the value of the member "bStatus".
     *
     * 1: Start Auto store 0: Stop Auto Store
     *
     * @param bStatus The value which will be set
     */
    inline void setBStatus (bool bStatus_);

    // API of field "e8ListID"

    static const int kE8ListID = 1;

    /**
     * Clears the field "e8ListID".
     *
     * The field will be set to its default value. The hasE8ListID()
     * method will return false.
     */
    inline void clearE8ListID();

    /**
     * Checks whether the field "e8ListID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ListID()). Otherwise it will return false.
     */
    inline bool hasE8ListID () const;

    /**
     * Returns the value of the member "e8ListID".
     *
     * This parameter indicates to which list,station found during
     * AST should be updated
     *
     * @return The value of the field "e8ListID"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_ListID getE8ListID () const;

    /**
     * Sets the value of the member "e8ListID".
     *
     * This parameter indicates to which list,station found during
     * AST should be updated
     *
     * @param e8ListID The value which will be set
     */
    inline void setE8ListID (::tuner_main_fi_types::T_e8_Tun_ListID e8ListID_);

    static const FID_TUN_S_AUTOSTOREStart &getDefaultInstance();

private:

    inline void set_has_bStatus ();

    inline void clear_has_bStatus ();

    inline void set_has_e8ListID ();

    inline void clear_has_e8ListID ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _bStatus;

    ::tuner_main_fi_types::T_e8_Tun_ListID _e8ListID;

};

/**
 * The result message of the method "FID_TUN_S_AUTOSTORE"
 * method to start an autostore process. autostore will automatic
 * store stations on preset list.
 * .
 */
class FID_TUN_S_AUTOSTOREResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_AUTOSTOREResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_AUTOSTOREResult (const FID_TUN_S_AUTOSTOREResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_AUTOSTOREResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_AUTOSTOREResult();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_AUTOSTOREResult& operator = (const FID_TUN_S_AUTOSTOREResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_AUTOSTOREResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_AUTOSTOREResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_AUTOSTOREResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_AUTOSTOREResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerServer_StatusResponse"

    static const int kTunerServer_StatusResponse = 0;

    /**
     * Clears the field "TunerServer_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerServer_StatusResponse()
     * method will return false.
     */
    inline void clearTunerServer_StatusResponse();

    /**
     * Checks whether the field "TunerServer_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerServer_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerServer_StatusResponse () const;

    /**
     * Returns the value of the member "TunerServer_StatusResponse".
     *
     * Class to be used: gm_tclU16Message.
     *
     * @return The value of the field "TunerServer_StatusResponse"
     */
    inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerServer_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerServer_StatusResponse".
     */
    inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerServer_StatusResponse".
     *
     * Class to be used: gm_tclU16Message.
     *
     * @param TunerServer_StatusResponse The value which will be set
     */
    inline void setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    static const FID_TUN_S_AUTOSTOREResult &getDefaultInstance();

private:

    inline void set_has_TunerServer_StatusResponse ();

    inline void clear_has_TunerServer_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_TunerServer_StatusResponse _TunerServer_StatusResponse;

};

/**
 * The start message of the method "FID_TUN_S_SEL_LIST_ELEM"
 * This method is used to select station from the preset/Config  list.
 */
class FID_TUN_S_SEL_LIST_ELEMStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_SEL_LIST_ELEMStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_SEL_LIST_ELEMStart (const FID_TUN_S_SEL_LIST_ELEMStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_SEL_LIST_ELEMStart (const ::tuner_main_fi_types::T_Sel_List_Elem& Sel_List_Elem_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_SEL_LIST_ELEMStart();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_SEL_LIST_ELEMStart& operator = (const FID_TUN_S_SEL_LIST_ELEMStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_SEL_LIST_ELEMStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_SEL_LIST_ELEMStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_SEL_LIST_ELEMStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_SEL_LIST_ELEMStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Sel_List_Elem"

    static const int kSel_List_Elem = 0;

    /**
     * Clears the field "Sel_List_Elem".
     *
     * The field will be set to its default value. The hasSel_List_Elem()
     * method will return false.
     */
    inline void clearSel_List_Elem();

    /**
     * Checks whether the field "Sel_List_Elem" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSel_List_Elem()). Otherwise it will return false.
     */
    inline bool hasSel_List_Elem () const;

    /**
     * Returns the value of the member "Sel_List_Elem".
     *
     * The list type and the list element Id is given by this.
     *
     * @return The value of the field "Sel_List_Elem"
     */
    inline const ::tuner_main_fi_types::T_Sel_List_Elem& getSel_List_Elem () const;

    /**
     * Retrieves the value of the field "Sel_List_Elem" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Sel_List_Elem".
     */
    inline ::tuner_main_fi_types::T_Sel_List_Elem& getSel_List_ElemMutable ();

    /**
     * Sets the value of the member "Sel_List_Elem".
     *
     * The list type and the list element Id is given by this.
     *
     * @param Sel_List_Elem The value which will be set
     */
    inline void setSel_List_Elem (const ::tuner_main_fi_types::T_Sel_List_Elem& Sel_List_Elem_);

    static const FID_TUN_S_SEL_LIST_ELEMStart &getDefaultInstance();

private:

    inline void set_has_Sel_List_Elem ();

    inline void clear_has_Sel_List_Elem ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_Sel_List_Elem _Sel_List_Elem;

};

/**
 * The result message of the method "FID_TUN_S_SEL_LIST_ELEM"
 * This method is used to select station from the preset/Config  list.
 * .
 */
class FID_TUN_S_SEL_LIST_ELEMResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_SEL_LIST_ELEMResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_SEL_LIST_ELEMResult (const FID_TUN_S_SEL_LIST_ELEMResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_SEL_LIST_ELEMResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_SEL_LIST_ELEMResult();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_SEL_LIST_ELEMResult& operator = (const FID_TUN_S_SEL_LIST_ELEMResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_SEL_LIST_ELEMResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_SEL_LIST_ELEMResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_SEL_LIST_ELEMResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_SEL_LIST_ELEMResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerServer_StatusResponse"

    static const int kTunerServer_StatusResponse = 0;

    /**
     * Clears the field "TunerServer_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerServer_StatusResponse()
     * method will return false.
     */
    inline void clearTunerServer_StatusResponse();

    /**
     * Checks whether the field "TunerServer_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerServer_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerServer_StatusResponse () const;

    /**
     * Returns the value of the member "TunerServer_StatusResponse".
     *
     * Class to be used: gm_tclU16Message.
     *
     * @return The value of the field "TunerServer_StatusResponse"
     */
    inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerServer_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerServer_StatusResponse".
     */
    inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerServer_StatusResponse".
     *
     * Class to be used: gm_tclU16Message.
     *
     * @param TunerServer_StatusResponse The value which will be set
     */
    inline void setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    static const FID_TUN_S_SEL_LIST_ELEMResult &getDefaultInstance();

private:

    inline void set_has_TunerServer_StatusResponse ();

    inline void clear_has_TunerServer_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_TunerServer_StatusResponse _TunerServer_StatusResponse;

};

/**
 * The start message of the method "FID_TUN_S_GET_CONFIG_LIST"
 * This method is used to Configure the dynamic list.
 */
class FID_TUN_S_GET_CONFIG_LISTStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_GET_CONFIG_LISTStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_GET_CONFIG_LISTStart (const FID_TUN_S_GET_CONFIG_LISTStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_GET_CONFIG_LISTStart (const ::tuner_main_fi_types::T_Tun_MakeConfigList& TunMakeConfigList_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_GET_CONFIG_LISTStart();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_GET_CONFIG_LISTStart& operator = (const FID_TUN_S_GET_CONFIG_LISTStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_GET_CONFIG_LISTStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_GET_CONFIG_LISTStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_GET_CONFIG_LISTStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_GET_CONFIG_LISTStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunMakeConfigList"

    static const int kTunMakeConfigList = 0;

    /**
     * Clears the field "TunMakeConfigList".
     *
     * The field will be set to its default value. The hasTunMakeConfigList()
     * method will return false.
     */
    inline void clearTunMakeConfigList();

    /**
     * Checks whether the field "TunMakeConfigList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunMakeConfigList()). Otherwise it will return false.
     */
    inline bool hasTunMakeConfigList () const;

    /**
     * Returns the value of the member "TunMakeConfigList".
     *
     * Class to be used: gm_tclU8Message.
     *
     * @return The value of the field "TunMakeConfigList"
     */
    inline const ::tuner_main_fi_types::T_Tun_MakeConfigList& getTunMakeConfigList () const;

    /**
     * Retrieves the value of the field "TunMakeConfigList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunMakeConfigList".
     */
    inline ::tuner_main_fi_types::T_Tun_MakeConfigList& getTunMakeConfigListMutable ();

    /**
     * Sets the value of the member "TunMakeConfigList".
     *
     * Class to be used: gm_tclU8Message.
     *
     * @param TunMakeConfigList The value which will be set
     */
    inline void setTunMakeConfigList (const ::tuner_main_fi_types::T_Tun_MakeConfigList& TunMakeConfigList_);

    static const FID_TUN_S_GET_CONFIG_LISTStart &getDefaultInstance();

private:

    inline void set_has_TunMakeConfigList ();

    inline void clear_has_TunMakeConfigList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_Tun_MakeConfigList _TunMakeConfigList;

};

/**
 * The result message of the method "FID_TUN_S_GET_CONFIG_LIST"
 * This method is used to Configure the dynamic list.
 * .
 */
class FID_TUN_S_GET_CONFIG_LISTResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_GET_CONFIG_LISTResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_GET_CONFIG_LISTResult (const FID_TUN_S_GET_CONFIG_LISTResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_GET_CONFIG_LISTResult (const ::tuner_main_fi_types::T_MakeConfigListElem& TunMakeConfigListElem_, const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_GET_CONFIG_LISTResult();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_GET_CONFIG_LISTResult& operator = (const FID_TUN_S_GET_CONFIG_LISTResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_GET_CONFIG_LISTResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_GET_CONFIG_LISTResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_GET_CONFIG_LISTResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_GET_CONFIG_LISTResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunMakeConfigListElem"

    static const int kTunMakeConfigListElem = 0;

    /**
     * Clears the field "TunMakeConfigListElem".
     *
     * The field will be set to its default value. The hasTunMakeConfigListElem()
     * method will return false.
     */
    inline void clearTunMakeConfigListElem();

    /**
     * Checks whether the field "TunMakeConfigListElem" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunMakeConfigListElem()). Otherwise it will return false.
     */
    inline bool hasTunMakeConfigListElem () const;

    /**
     * Returns the value of the member "TunMakeConfigListElem".
     *
     * Returns the NoOfElements found in the list
     *
     * @return The value of the field "TunMakeConfigListElem"
     */
    inline const ::tuner_main_fi_types::T_MakeConfigListElem& getTunMakeConfigListElem () const;

    /**
     * Retrieves the value of the field "TunMakeConfigListElem" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunMakeConfigListElem".
     */
    inline ::tuner_main_fi_types::T_MakeConfigListElem& getTunMakeConfigListElemMutable ();

    /**
     * Sets the value of the member "TunMakeConfigListElem".
     *
     * Returns the NoOfElements found in the list
     *
     * @param TunMakeConfigListElem The value which will be set
     */
    inline void setTunMakeConfigListElem (const ::tuner_main_fi_types::T_MakeConfigListElem& TunMakeConfigListElem_);

    // API of field "TunerServer_StatusResponse"

    static const int kTunerServer_StatusResponse = 1;

    /**
     * Clears the field "TunerServer_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerServer_StatusResponse()
     * method will return false.
     */
    inline void clearTunerServer_StatusResponse();

    /**
     * Checks whether the field "TunerServer_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerServer_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerServer_StatusResponse () const;

    /**
     * Returns the value of the member "TunerServer_StatusResponse".
     *
     * Class to be used: gm_tclU16Message.
     *
     * @return The value of the field "TunerServer_StatusResponse"
     */
    inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerServer_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerServer_StatusResponse".
     */
    inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerServer_StatusResponse".
     *
     * Class to be used: gm_tclU16Message.
     *
     * @param TunerServer_StatusResponse The value which will be set
     */
    inline void setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    static const FID_TUN_S_GET_CONFIG_LISTResult &getDefaultInstance();

private:

    inline void set_has_TunMakeConfigListElem ();

    inline void clear_has_TunMakeConfigListElem ();

    inline void set_has_TunerServer_StatusResponse ();

    inline void clear_has_TunerServer_StatusResponse ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::tuner_main_fi_types::T_MakeConfigListElem _TunMakeConfigListElem;

    ::tuner_main_fi_types::T_TunerServer_StatusResponse _TunerServer_StatusResponse;

};

/**
 * The start message of the method "FID_TUN_S_AUDIO_FG_BG_NEW"
 * The HMI can set, with this command who is listening to the tuner,
 * USR1, TA, TIM, PTY, NEWS, by enabling Foreground.  If the tuner is sent into
 * background (means that no one is listening), the tuner will mute it's audio signal.
 * Tuner 1 or Tuner 2 can be put into FG or BG.
 */
class FID_TUN_S_AUDIO_FG_BG_NEWStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_AUDIO_FG_BG_NEWStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_AUDIO_FG_BG_NEWStart (const FID_TUN_S_AUDIO_FG_BG_NEWStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_AUDIO_FG_BG_NEWStart (const ::tuner_main_fi_types::T_Aud_FGBG_New& TunAudFGBGNew_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_AUDIO_FG_BG_NEWStart();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_AUDIO_FG_BG_NEWStart& operator = (const FID_TUN_S_AUDIO_FG_BG_NEWStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_AUDIO_FG_BG_NEWStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_AUDIO_FG_BG_NEWStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_AUDIO_FG_BG_NEWStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_AUDIO_FG_BG_NEWStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunAudFGBGNew"

    static const int kTunAudFGBGNew = 0;

    /**
     * Clears the field "TunAudFGBGNew".
     *
     * The field will be set to its default value. The hasTunAudFGBGNew()
     * method will return false.
     */
    inline void clearTunAudFGBGNew();

    /**
     * Checks whether the field "TunAudFGBGNew" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunAudFGBGNew()). Otherwise it will return false.
     */
    inline bool hasTunAudFGBGNew () const;

    /**
     * Returns the value of the member "TunAudFGBGNew".
     *
     * Class to be used: tunmsg_tclSetAudioFgBg from file:
     * tun_hmi_if_message.h.
     *
     * @return The value of the field "TunAudFGBGNew"
     */
    inline const ::tuner_main_fi_types::T_Aud_FGBG_New& getTunAudFGBGNew () const;

    /**
     * Retrieves the value of the field "TunAudFGBGNew" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunAudFGBGNew".
     */
    inline ::tuner_main_fi_types::T_Aud_FGBG_New& getTunAudFGBGNewMutable ();

    /**
     * Sets the value of the member "TunAudFGBGNew".
     *
     * Class to be used: tunmsg_tclSetAudioFgBg from file:
     * tun_hmi_if_message.h.
     *
     * @param TunAudFGBGNew The value which will be set
     */
    inline void setTunAudFGBGNew (const ::tuner_main_fi_types::T_Aud_FGBG_New& TunAudFGBGNew_);

    static const FID_TUN_S_AUDIO_FG_BG_NEWStart &getDefaultInstance();

private:

    inline void set_has_TunAudFGBGNew ();

    inline void clear_has_TunAudFGBGNew ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_Aud_FGBG_New _TunAudFGBGNew;

};

/**
 * The result message of the method "FID_TUN_S_AUDIO_FG_BG_NEW"
 * The HMI can set, with this command who is listening to the tuner,
 * USR1, TA, TIM, PTY, NEWS, by enabling Foreground.  If the tuner is sent into
 * background (means that no one is listening), the tuner will mute it's audio signal.
 * Tuner 1 or Tuner 2 can be put into FG or BG.
 * .
 */
class FID_TUN_S_AUDIO_FG_BG_NEWResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_AUDIO_FG_BG_NEWResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_AUDIO_FG_BG_NEWResult (const FID_TUN_S_AUDIO_FG_BG_NEWResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_AUDIO_FG_BG_NEWResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_, const ::tuner_main_fi_types::T_AudFGBGStatus& TunAudioFgBgStatus_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_AUDIO_FG_BG_NEWResult();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_AUDIO_FG_BG_NEWResult& operator = (const FID_TUN_S_AUDIO_FG_BG_NEWResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_AUDIO_FG_BG_NEWResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_AUDIO_FG_BG_NEWResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_AUDIO_FG_BG_NEWResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_AUDIO_FG_BG_NEWResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerServer_StatusResponse"

    static const int kTunerServer_StatusResponse = 0;

    /**
     * Clears the field "TunerServer_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerServer_StatusResponse()
     * method will return false.
     */
    inline void clearTunerServer_StatusResponse();

    /**
     * Checks whether the field "TunerServer_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerServer_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerServer_StatusResponse () const;

    /**
     * Returns the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @return The value of the field "TunerServer_StatusResponse"
     */
    inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerServer_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerServer_StatusResponse".
     */
    inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @param TunerServer_StatusResponse The value which will be set
     */
    inline void setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    // API of field "TunAudioFgBgStatus"

    static const int kTunAudioFgBgStatus = 1;

    /**
     * Clears the field "TunAudioFgBgStatus".
     *
     * The field will be set to its default value. The hasTunAudioFgBgStatus()
     * method will return false.
     */
    inline void clearTunAudioFgBgStatus();

    /**
     * Checks whether the field "TunAudioFgBgStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunAudioFgBgStatus()). Otherwise it will return false.
     */
    inline bool hasTunAudioFgBgStatus () const;

    /**
     * Returns the value of the member "TunAudioFgBgStatus".
     *
     * .
     *
     * @return The value of the field "TunAudioFgBgStatus"
     */
    inline const ::tuner_main_fi_types::T_AudFGBGStatus& getTunAudioFgBgStatus () const;

    /**
     * Retrieves the value of the field "TunAudioFgBgStatus" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunAudioFgBgStatus".
     */
    inline ::tuner_main_fi_types::T_AudFGBGStatus& getTunAudioFgBgStatusMutable ();

    /**
     * Sets the value of the member "TunAudioFgBgStatus".
     *
     * .
     *
     * @param TunAudioFgBgStatus The value which will be set
     */
    inline void setTunAudioFgBgStatus (const ::tuner_main_fi_types::T_AudFGBGStatus& TunAudioFgBgStatus_);

    static const FID_TUN_S_AUDIO_FG_BG_NEWResult &getDefaultInstance();

private:

    inline void set_has_TunerServer_StatusResponse ();

    inline void clear_has_TunerServer_StatusResponse ();

    inline void set_has_TunAudioFgBgStatus ();

    inline void clear_has_TunAudioFgBgStatus ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::tuner_main_fi_types::T_TunerServer_StatusResponse _TunerServer_StatusResponse;

    ::tuner_main_fi_types::T_AudFGBGStatus _TunAudioFgBgStatus;

};

/**
 * The start message of the method "FID_TUN_S_SET_PI"
 * This FI is used to set a particular PI,frequency or step the PI from the Currently tuned station.
 * The PI stepping can either be step-up or step-down. The number of steps have to be mentioned.
 */
class FID_TUN_S_SET_PIStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_SET_PIStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_SET_PIStart (const FID_TUN_S_SET_PIStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_SET_PIStart (const ::tuner_main_fi_types::T_Tun_Set_PI& TunSetPIPara_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_SET_PIStart();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_SET_PIStart& operator = (const FID_TUN_S_SET_PIStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_SET_PIStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_SET_PIStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_SET_PIStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_SET_PIStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunSetPIPara"

    static const int kTunSetPIPara = 0;

    /**
     * Clears the field "TunSetPIPara".
     *
     * The field will be set to its default value. The hasTunSetPIPara()
     * method will return false.
     */
    inline void clearTunSetPIPara();

    /**
     * Checks whether the field "TunSetPIPara" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunSetPIPara()). Otherwise it will return false.
     */
    inline bool hasTunSetPIPara () const;

    /**
     * Returns the value of the member "TunSetPIPara".
     *
     * Class to be used: tunmsg_tclSetPI from file:
     * tun_hmi_if_message.h.
     *
     * @return The value of the field "TunSetPIPara"
     */
    inline const ::tuner_main_fi_types::T_Tun_Set_PI& getTunSetPIPara () const;

    /**
     * Retrieves the value of the field "TunSetPIPara" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunSetPIPara".
     */
    inline ::tuner_main_fi_types::T_Tun_Set_PI& getTunSetPIParaMutable ();

    /**
     * Sets the value of the member "TunSetPIPara".
     *
     * Class to be used: tunmsg_tclSetPI from file:
     * tun_hmi_if_message.h.
     *
     * @param TunSetPIPara The value which will be set
     */
    inline void setTunSetPIPara (const ::tuner_main_fi_types::T_Tun_Set_PI& TunSetPIPara_);

    static const FID_TUN_S_SET_PIStart &getDefaultInstance();

private:

    inline void set_has_TunSetPIPara ();

    inline void clear_has_TunSetPIPara ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_Tun_Set_PI _TunSetPIPara;

};

/**
 * The result message of the method "FID_TUN_S_SET_PI"
 * This FI is used to set a particular PI,frequency or step the PI from the Currently tuned station.
 * The PI stepping can either be step-up or step-down. The number of steps have to be mentioned.
 * .
 */
class FID_TUN_S_SET_PIResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_SET_PIResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_SET_PIResult (const FID_TUN_S_SET_PIResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_SET_PIResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_SET_PIResult();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_SET_PIResult& operator = (const FID_TUN_S_SET_PIResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_SET_PIResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_SET_PIResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_SET_PIResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_SET_PIResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerServer_StatusResponse"

    static const int kTunerServer_StatusResponse = 0;

    /**
     * Clears the field "TunerServer_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerServer_StatusResponse()
     * method will return false.
     */
    inline void clearTunerServer_StatusResponse();

    /**
     * Checks whether the field "TunerServer_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerServer_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerServer_StatusResponse () const;

    /**
     * Returns the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @return The value of the field "TunerServer_StatusResponse"
     */
    inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerServer_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerServer_StatusResponse".
     */
    inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @param TunerServer_StatusResponse The value which will be set
     */
    inline void setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    static const FID_TUN_S_SET_PIResult &getDefaultInstance();

private:

    inline void set_has_TunerServer_StatusResponse ();

    inline void clear_has_TunerServer_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_TunerServer_StatusResponse _TunerServer_StatusResponse;

};

/**
 * The start message of the method "FID_TUN_S_SET_SHARXLEVEL"
 * The HMI can do a Sharx step, with this command the .
 */
class FID_TUN_S_SET_SHARXLEVELStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_SET_SHARXLEVELStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_SET_SHARXLEVELStart (const FID_TUN_S_SET_SHARXLEVELStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_SET_SHARXLEVELStart (uint8 u8SharxStep_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_SET_SHARXLEVELStart();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_SET_SHARXLEVELStart& operator = (const FID_TUN_S_SET_SHARXLEVELStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_SET_SHARXLEVELStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_SET_SHARXLEVELStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_SET_SHARXLEVELStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_SET_SHARXLEVELStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8SharxStep"

    static const int kU8SharxStep = 0;

    /**
     * Clears the field "u8SharxStep".
     *
     * The field will be set to its default value. The hasU8SharxStep()
     * method will return false.
     */
    inline void clearU8SharxStep();

    /**
     * Checks whether the field "u8SharxStep" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SharxStep()). Otherwise it will return false.
     */
    inline bool hasU8SharxStep () const;

    /**
     * Returns the value of the member "u8SharxStep".
     *
     * 00 - 0x03 For Automatics use 0xff.
     *
     * @return The value of the field "u8SharxStep"
     */
    inline uint8 getU8SharxStep () const;

    /**
     * Sets the value of the member "u8SharxStep".
     *
     * 00 - 0x03 For Automatics use 0xff.
     *
     * @param u8SharxStep The value which will be set
     */
    inline void setU8SharxStep (uint8 u8SharxStep_);

    static const FID_TUN_S_SET_SHARXLEVELStart &getDefaultInstance();

private:

    inline void set_has_u8SharxStep ();

    inline void clear_has_u8SharxStep ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8SharxStep;

};

/**
 * The result message of the method "FID_TUN_S_SET_SHARXLEVEL"
 * The HMI can do a Sharx step, with this command the .
 * .
 */
class FID_TUN_S_SET_SHARXLEVELResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_SET_SHARXLEVELResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_SET_SHARXLEVELResult (const FID_TUN_S_SET_SHARXLEVELResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_SET_SHARXLEVELResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_SET_SHARXLEVELResult();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_SET_SHARXLEVELResult& operator = (const FID_TUN_S_SET_SHARXLEVELResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_SET_SHARXLEVELResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_SET_SHARXLEVELResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_SET_SHARXLEVELResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_SET_SHARXLEVELResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerServer_StatusResponse"

    static const int kTunerServer_StatusResponse = 0;

    /**
     * Clears the field "TunerServer_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerServer_StatusResponse()
     * method will return false.
     */
    inline void clearTunerServer_StatusResponse();

    /**
     * Checks whether the field "TunerServer_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerServer_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerServer_StatusResponse () const;

    /**
     * Returns the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @return The value of the field "TunerServer_StatusResponse"
     */
    inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerServer_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerServer_StatusResponse".
     */
    inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @param TunerServer_StatusResponse The value which will be set
     */
    inline void setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    static const FID_TUN_S_SET_SHARXLEVELResult &getDefaultInstance();

private:

    inline void set_has_TunerServer_StatusResponse ();

    inline void clear_has_TunerServer_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_TunerServer_StatusResponse _TunerServer_StatusResponse;

};

/**
 * The start message of the method "FID_TUN_S_GET_STATIC_LIST"
 * With this command we can get preset list elements based on request .
 */
class FID_TUN_S_GET_STATIC_LISTStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_GET_STATIC_LISTStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_GET_STATIC_LISTStart (const FID_TUN_S_GET_STATIC_LISTStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_GET_STATIC_LISTStart (::tuner_main_fi_types::T_e8_Tun_ListID e8ListID_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_GET_STATIC_LISTStart();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_GET_STATIC_LISTStart& operator = (const FID_TUN_S_GET_STATIC_LISTStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_GET_STATIC_LISTStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_GET_STATIC_LISTStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_GET_STATIC_LISTStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_GET_STATIC_LISTStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ListID"

    static const int kE8ListID = 0;

    /**
     * Clears the field "e8ListID".
     *
     * The field will be set to its default value. The hasE8ListID()
     * method will return false.
     */
    inline void clearE8ListID();

    /**
     * Checks whether the field "e8ListID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ListID()). Otherwise it will return false.
     */
    inline bool hasE8ListID () const;

    /**
     * Returns the value of the member "e8ListID".
     *
     * .
     *
     * @return The value of the field "e8ListID"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_ListID getE8ListID () const;

    /**
     * Sets the value of the member "e8ListID".
     *
     * .
     *
     * @param e8ListID The value which will be set
     */
    inline void setE8ListID (::tuner_main_fi_types::T_e8_Tun_ListID e8ListID_);

    static const FID_TUN_S_GET_STATIC_LISTStart &getDefaultInstance();

private:

    inline void set_has_e8ListID ();

    inline void clear_has_e8ListID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_e8_Tun_ListID _e8ListID;

};

/**
 * The result message of the method "FID_TUN_S_GET_STATIC_LIST"
 * With this command we can get preset list elements based on request .
 * .
 */
class FID_TUN_S_GET_STATIC_LISTResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_GET_STATIC_LISTResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_GET_STATIC_LISTResult (const FID_TUN_S_GET_STATIC_LISTResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_GET_STATIC_LISTResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_GET_STATIC_LISTResult();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_GET_STATIC_LISTResult& operator = (const FID_TUN_S_GET_STATIC_LISTResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_GET_STATIC_LISTResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_GET_STATIC_LISTResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_GET_STATIC_LISTResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_GET_STATIC_LISTResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerServer_StatusResponse"

    static const int kTunerServer_StatusResponse = 0;

    /**
     * Clears the field "TunerServer_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerServer_StatusResponse()
     * method will return false.
     */
    inline void clearTunerServer_StatusResponse();

    /**
     * Checks whether the field "TunerServer_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerServer_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerServer_StatusResponse () const;

    /**
     * Returns the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @return The value of the field "TunerServer_StatusResponse"
     */
    inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerServer_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerServer_StatusResponse".
     */
    inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @param TunerServer_StatusResponse The value which will be set
     */
    inline void setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    static const FID_TUN_S_GET_STATIC_LISTResult &getDefaultInstance();

private:

    inline void set_has_TunerServer_StatusResponse ();

    inline void clear_has_TunerServer_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_TunerServer_StatusResponse _TunerServer_StatusResponse;

};

/**
 * The start message of the method "FID_TUN_S_SETUP_DDADDS"
 * This command enable Setup for Mode.
 */
class FID_TUN_S_SETUP_DDADDSStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_SETUP_DDADDSStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_SETUP_DDADDSStart (const FID_TUN_S_SETUP_DDADDSStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_SETUP_DDADDSStart (::tuner_main_fi_types::T_e8_DDADDS_Mode DDADDS_Mode_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_SETUP_DDADDSStart();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_SETUP_DDADDSStart& operator = (const FID_TUN_S_SETUP_DDADDSStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_SETUP_DDADDSStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_SETUP_DDADDSStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_SETUP_DDADDSStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_SETUP_DDADDSStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DDADDS_Mode"

    static const int kDDADDS_Mode = 0;

    /**
     * Clears the field "DDADDS_Mode".
     *
     * The field will be set to its default value. The hasDDADDS_Mode()
     * method will return false.
     */
    inline void clearDDADDS_Mode();

    /**
     * Checks whether the field "DDADDS_Mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDDADDS_Mode()). Otherwise it will return false.
     */
    inline bool hasDDADDS_Mode () const;

    /**
     * Returns the value of the member "DDADDS_Mode".
     *
     * .
     *
     * @return The value of the field "DDADDS_Mode"
     */
    inline ::tuner_main_fi_types::T_e8_DDADDS_Mode getDDADDS_Mode () const;

    /**
     * Sets the value of the member "DDADDS_Mode".
     *
     * .
     *
     * @param DDADDS_Mode The value which will be set
     */
    inline void setDDADDS_Mode (::tuner_main_fi_types::T_e8_DDADDS_Mode DDADDS_Mode_);

    static const FID_TUN_S_SETUP_DDADDSStart &getDefaultInstance();

private:

    inline void set_has_DDADDS_Mode ();

    inline void clear_has_DDADDS_Mode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_e8_DDADDS_Mode _DDADDS_Mode;

};

/**
 * The result message of the method "FID_TUN_S_SETUP_DDADDS"
 * This command enable Setup for Mode.
 * .
 */
class FID_TUN_S_SETUP_DDADDSResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_SETUP_DDADDSResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_SETUP_DDADDSResult (const FID_TUN_S_SETUP_DDADDSResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_SETUP_DDADDSResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_SETUP_DDADDSResult();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_SETUP_DDADDSResult& operator = (const FID_TUN_S_SETUP_DDADDSResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_SETUP_DDADDSResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_SETUP_DDADDSResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_SETUP_DDADDSResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_SETUP_DDADDSResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerServer_StatusResponse"

    static const int kTunerServer_StatusResponse = 0;

    /**
     * Clears the field "TunerServer_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerServer_StatusResponse()
     * method will return false.
     */
    inline void clearTunerServer_StatusResponse();

    /**
     * Checks whether the field "TunerServer_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerServer_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerServer_StatusResponse () const;

    /**
     * Returns the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @return The value of the field "TunerServer_StatusResponse"
     */
    inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerServer_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerServer_StatusResponse".
     */
    inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @param TunerServer_StatusResponse The value which will be set
     */
    inline void setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    static const FID_TUN_S_SETUP_DDADDSResult &getDefaultInstance();

private:

    inline void set_has_TunerServer_StatusResponse ();

    inline void clear_has_TunerServer_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_TunerServer_StatusResponse _TunerServer_StatusResponse;

};

/**
 * The start message of the method "FID_TUN_S_PRESET_HANDLING"
 * This method is used to perform actions like delete, recall and store in preset list.
 */
class FID_TUN_S_PRESET_HANDLINGStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_PRESET_HANDLINGStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_PRESET_HANDLINGStart (const FID_TUN_S_PRESET_HANDLINGStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_PRESET_HANDLINGStart (::tuner_main_fi_types::T_e8_Tun_PresetAction e8Action_, uint8 u8ListElementID_, ::tuner_main_fi_types::T_e8_Tun_ListID e8ListID_, uint32 u32Frequency_, uint16 u16PI_, uint16 u16SecondaryPI_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_PRESET_HANDLINGStart();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_PRESET_HANDLINGStart& operator = (const FID_TUN_S_PRESET_HANDLINGStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_PRESET_HANDLINGStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_PRESET_HANDLINGStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_PRESET_HANDLINGStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_PRESET_HANDLINGStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Action"

    static const int kE8Action = 0;

    /**
     * Clears the field "e8Action".
     *
     * The field will be set to its default value. The hasE8Action()
     * method will return false.
     */
    inline void clearE8Action();

    /**
     * Checks whether the field "e8Action" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Action()). Otherwise it will return false.
     */
    inline bool hasE8Action () const;

    /**
     * Returns the value of the member "e8Action".
     *
     * Defines if preset needs to be deleted, recalled or saved
     *
     * @return The value of the field "e8Action"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_PresetAction getE8Action () const;

    /**
     * Sets the value of the member "e8Action".
     *
     * Defines if preset needs to be deleted, recalled or saved
     *
     * @param e8Action The value which will be set
     */
    inline void setE8Action (::tuner_main_fi_types::T_e8_Tun_PresetAction e8Action_);

    // API of field "u8ListElementID"

    static const int kU8ListElementID = 1;

    /**
     * Clears the field "u8ListElementID".
     *
     * The field will be set to its default value. The hasU8ListElementID()
     * method will return false.
     */
    inline void clearU8ListElementID();

    /**
     * Checks whether the field "u8ListElementID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8ListElementID()). Otherwise it will return false.
     */
    inline bool hasU8ListElementID () const;

    /**
     * Returns the value of the member "u8ListElementID".
     *
     * Element ID in the preset list
     *
     * @return The value of the field "u8ListElementID"
     */
    inline uint8 getU8ListElementID () const;

    /**
     * Sets the value of the member "u8ListElementID".
     *
     * Element ID in the preset list
     *
     * @param u8ListElementID The value which will be set
     */
    inline void setU8ListElementID (uint8 u8ListElementID_);

    // API of field "e8ListID"

    static const int kE8ListID = 2;

    /**
     * Clears the field "e8ListID".
     *
     * The field will be set to its default value. The hasE8ListID()
     * method will return false.
     */
    inline void clearE8ListID();

    /**
     * Checks whether the field "e8ListID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ListID()). Otherwise it will return false.
     */
    inline bool hasE8ListID () const;

    /**
     * Returns the value of the member "e8ListID".
     *
     * Preset List ID
     *
     * @return The value of the field "e8ListID"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_ListID getE8ListID () const;

    /**
     * Sets the value of the member "e8ListID".
     *
     * Preset List ID
     *
     * @param e8ListID The value which will be set
     */
    inline void setE8ListID (::tuner_main_fi_types::T_e8_Tun_ListID e8ListID_);

    // API of field "u32Frequency"

    static const int kU32Frequency = 3;

    /**
     * Clears the field "u32Frequency".
     *
     * The field will be set to its default value. The hasU32Frequency()
     * method will return false.
     */
    inline void clearU32Frequency();

    /**
     * Checks whether the field "u32Frequency" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Frequency()). Otherwise it will return false.
     */
    inline bool hasU32Frequency () const;

    /**
     * Returns the value of the member "u32Frequency".
     *
     * This parameter indicates the frequency to be stored, used only in case of special preset save action.
     *
     * @return The value of the field "u32Frequency"
     */
    inline uint32 getU32Frequency () const;

    /**
     * Sets the value of the member "u32Frequency".
     *
     * This parameter indicates the frequency to be stored, used only in case of special preset save action.
     *
     * @param u32Frequency The value which will be set
     */
    inline void setU32Frequency (uint32 u32Frequency_);

    // API of field "u16PI"

    static const int kU16PI = 4;

    /**
     * Clears the field "u16PI".
     *
     * The field will be set to its default value. The hasU16PI()
     * method will return false.
     */
    inline void clearU16PI();

    /**
     * Checks whether the field "u16PI" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16PI()). Otherwise it will return false.
     */
    inline bool hasU16PI () const;

    /**
     * Returns the value of the member "u16PI".
     *
     * This parameter indicates the PI of the respective selected station, used only in case of special preset save action.
     *
     * @return The value of the field "u16PI"
     */
    inline uint16 getU16PI () const;

    /**
     * Sets the value of the member "u16PI".
     *
     * This parameter indicates the PI of the respective selected station, used only in case of special preset save action.
     *
     * @param u16PI The value which will be set
     */
    inline void setU16PI (uint16 u16PI_);

    // API of field "u16SecondaryPI"

    static const int kU16SecondaryPI = 5;

    /**
     * Clears the field "u16SecondaryPI".
     *
     * The field will be set to its default value. The hasU16SecondaryPI()
     * method will return false.
     */
    inline void clearU16SecondaryPI();

    /**
     * Checks whether the field "u16SecondaryPI" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16SecondaryPI()). Otherwise it will return false.
     */
    inline bool hasU16SecondaryPI () const;

    /**
     * Returns the value of the member "u16SecondaryPI".
     *
     * LSB is for SecondaryID, MSB can be used for ECC for DAB.
     *
     * @return The value of the field "u16SecondaryPI"
     */
    inline uint16 getU16SecondaryPI () const;

    /**
     * Sets the value of the member "u16SecondaryPI".
     *
     * LSB is for SecondaryID, MSB can be used for ECC for DAB.
     *
     * @param u16SecondaryPI The value which will be set
     */
    inline void setU16SecondaryPI (uint16 u16SecondaryPI_);

    static const FID_TUN_S_PRESET_HANDLINGStart &getDefaultInstance();

private:

    inline void set_has_e8Action ();

    inline void clear_has_e8Action ();

    inline void set_has_u8ListElementID ();

    inline void clear_has_u8ListElementID ();

    inline void set_has_e8ListID ();

    inline void clear_has_e8ListID ();

    inline void set_has_u32Frequency ();

    inline void clear_has_u32Frequency ();

    inline void set_has_u16PI ();

    inline void clear_has_u16PI ();

    inline void set_has_u16SecondaryPI ();

    inline void clear_has_u16SecondaryPI ();

    uint32 _has_bits_[ (6 + 31) / 32];

    ::tuner_main_fi_types::T_e8_Tun_PresetAction _e8Action;

    uint8 _u8ListElementID;

    ::tuner_main_fi_types::T_e8_Tun_ListID _e8ListID;

    uint32 _u32Frequency;

    uint16 _u16PI;

    uint16 _u16SecondaryPI;

};

/**
 * The result message of the method "FID_TUN_S_PRESET_HANDLING"
 * This method is used to perform actions like delete, recall and store in preset list.
 * .
 */
class FID_TUN_S_PRESET_HANDLINGResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_PRESET_HANDLINGResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_PRESET_HANDLINGResult (const FID_TUN_S_PRESET_HANDLINGResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_PRESET_HANDLINGResult (::tuner_main_fi_types::T_e8_Tun_PresetAction e8Action_, const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_PRESET_HANDLINGResult();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_PRESET_HANDLINGResult& operator = (const FID_TUN_S_PRESET_HANDLINGResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_PRESET_HANDLINGResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_PRESET_HANDLINGResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_PRESET_HANDLINGResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_PRESET_HANDLINGResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Action"

    static const int kE8Action = 0;

    /**
     * Clears the field "e8Action".
     *
     * The field will be set to its default value. The hasE8Action()
     * method will return false.
     */
    inline void clearE8Action();

    /**
     * Checks whether the field "e8Action" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Action()). Otherwise it will return false.
     */
    inline bool hasE8Action () const;

    /**
     * Returns the value of the member "e8Action".
     *
     * Defines if preset needs to be deleted, recalled or saved
     *
     * @return The value of the field "e8Action"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_PresetAction getE8Action () const;

    /**
     * Sets the value of the member "e8Action".
     *
     * Defines if preset needs to be deleted, recalled or saved
     *
     * @param e8Action The value which will be set
     */
    inline void setE8Action (::tuner_main_fi_types::T_e8_Tun_PresetAction e8Action_);

    // API of field "TunerServer_StatusResponse"

    static const int kTunerServer_StatusResponse = 1;

    /**
     * Clears the field "TunerServer_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerServer_StatusResponse()
     * method will return false.
     */
    inline void clearTunerServer_StatusResponse();

    /**
     * Checks whether the field "TunerServer_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerServer_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerServer_StatusResponse () const;

    /**
     * Returns the value of the member "TunerServer_StatusResponse".
     *
     * Class to be used: gm_tclU16Message.
     *
     * @return The value of the field "TunerServer_StatusResponse"
     */
    inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerServer_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerServer_StatusResponse".
     */
    inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerServer_StatusResponse".
     *
     * Class to be used: gm_tclU16Message.
     *
     * @param TunerServer_StatusResponse The value which will be set
     */
    inline void setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    static const FID_TUN_S_PRESET_HANDLINGResult &getDefaultInstance();

private:

    inline void set_has_e8Action ();

    inline void clear_has_e8Action ();

    inline void set_has_TunerServer_StatusResponse ();

    inline void clear_has_TunerServer_StatusResponse ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::tuner_main_fi_types::T_e8_Tun_PresetAction _e8Action;

    ::tuner_main_fi_types::T_TunerServer_StatusResponse _TunerServer_StatusResponse;

};

/**
 * The start message of the method "FID_TUN_S_PS_FREEZE"
 * This Function is used to Freeze/Unfreeze the PS Name of
 * the currently playing FM station.
 */
class FID_TUN_S_PS_FREEZEStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_PS_FREEZEStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_PS_FREEZEStart (const FID_TUN_S_PS_FREEZEStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_PS_FREEZEStart (bool bPSFreeze_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_PS_FREEZEStart();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_PS_FREEZEStart& operator = (const FID_TUN_S_PS_FREEZEStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_PS_FREEZEStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_PS_FREEZEStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_PS_FREEZEStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_PS_FREEZEStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bPSFreeze"

    static const int kBPSFreeze = 0;

    /**
     * Clears the field "bPSFreeze".
     *
     * The field will be set to its default value. The hasBPSFreeze()
     * method will return false.
     */
    inline void clearBPSFreeze();

    /**
     * Checks whether the field "bPSFreeze" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBPSFreeze()). Otherwise it will return false.
     */
    inline bool hasBPSFreeze () const;

    /**
     * Returns the value of the member "bPSFreeze".
     *
     * PS Name fix is ON/OFF
     *
     * @return The value of the field "bPSFreeze"
     */
    inline bool getBPSFreeze () const;

    /**
     * Sets the value of the member "bPSFreeze".
     *
     * PS Name fix is ON/OFF
     *
     * @param bPSFreeze The value which will be set
     */
    inline void setBPSFreeze (bool bPSFreeze_);

    static const FID_TUN_S_PS_FREEZEStart &getDefaultInstance();

private:

    inline void set_has_bPSFreeze ();

    inline void clear_has_bPSFreeze ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bPSFreeze;

};

/**
 * The result message of the method "FID_TUN_S_PS_FREEZE"
 * This Function is used to Freeze/Unfreeze the PS Name of
 * the currently playing FM station.
 * .
 */
class FID_TUN_S_PS_FREEZEResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_PS_FREEZEResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_PS_FREEZEResult (const FID_TUN_S_PS_FREEZEResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_PS_FREEZEResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_PS_FREEZEResult();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_PS_FREEZEResult& operator = (const FID_TUN_S_PS_FREEZEResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_PS_FREEZEResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_PS_FREEZEResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_PS_FREEZEResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_PS_FREEZEResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerServer_StatusResponse"

    static const int kTunerServer_StatusResponse = 0;

    /**
     * Clears the field "TunerServer_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerServer_StatusResponse()
     * method will return false.
     */
    inline void clearTunerServer_StatusResponse();

    /**
     * Checks whether the field "TunerServer_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerServer_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerServer_StatusResponse () const;

    /**
     * Returns the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @return The value of the field "TunerServer_StatusResponse"
     */
    inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerServer_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerServer_StatusResponse".
     */
    inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @param TunerServer_StatusResponse The value which will be set
     */
    inline void setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    static const FID_TUN_S_PS_FREEZEResult &getDefaultInstance();

private:

    inline void set_has_TunerServer_StatusResponse ();

    inline void clear_has_TunerServer_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_TunerServer_StatusResponse _TunerServer_StatusResponse;

};

/**
 * The start message of the method "FID_TUN_S_SET_AUTOCOMP_PARAM"
 * Through this method, the Parameters for autocompare can be set. This is
 * mainly used to divide the preset-list into different band ranges.
 */
class FID_TUN_S_SET_AUTOCOMP_PARAMStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_SET_AUTOCOMP_PARAMStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_SET_AUTOCOMP_PARAMStart (const FID_TUN_S_SET_AUTOCOMP_PARAMStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_SET_AUTOCOMP_PARAMStart (const ::tuner_main_fi_types::T_Tun_AutoCompParam& TunAutoCompParam_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_SET_AUTOCOMP_PARAMStart();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_SET_AUTOCOMP_PARAMStart& operator = (const FID_TUN_S_SET_AUTOCOMP_PARAMStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_SET_AUTOCOMP_PARAMStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_SET_AUTOCOMP_PARAMStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_SET_AUTOCOMP_PARAMStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_SET_AUTOCOMP_PARAMStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunAutoCompParam"

    static const int kTunAutoCompParam = 0;

    /**
     * Clears the field "TunAutoCompParam".
     *
     * The field will be set to its default value. The hasTunAutoCompParam()
     * method will return false.
     */
    inline void clearTunAutoCompParam();

    /**
     * Checks whether the field "TunAutoCompParam" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunAutoCompParam()). Otherwise it will return false.
     */
    inline bool hasTunAutoCompParam () const;

    /**
     * Returns the value of the member "TunAutoCompParam".
     *
     * The parameters include the first element id which has to
     * be greater than 0, the last element Id which is greater than
     * first element and the mode which is used when the same stations
     * are stored at different positions in the
     * preset list.
     *
     * @return The value of the field "TunAutoCompParam"
     */
    inline const ::tuner_main_fi_types::T_Tun_AutoCompParam& getTunAutoCompParam () const;

    /**
     * Retrieves the value of the field "TunAutoCompParam" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunAutoCompParam".
     */
    inline ::tuner_main_fi_types::T_Tun_AutoCompParam& getTunAutoCompParamMutable ();

    /**
     * Sets the value of the member "TunAutoCompParam".
     *
     * The parameters include the first element id which has to
     * be greater than 0, the last element Id which is greater than
     * first element and the mode which is used when the same stations
     * are stored at different positions in the
     * preset list.
     *
     * @param TunAutoCompParam The value which will be set
     */
    inline void setTunAutoCompParam (const ::tuner_main_fi_types::T_Tun_AutoCompParam& TunAutoCompParam_);

    static const FID_TUN_S_SET_AUTOCOMP_PARAMStart &getDefaultInstance();

private:

    inline void set_has_TunAutoCompParam ();

    inline void clear_has_TunAutoCompParam ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_Tun_AutoCompParam _TunAutoCompParam;

};

/**
 * The result message of the method "FID_TUN_S_SET_AUTOCOMP_PARAM"
 * Through this method, the Parameters for autocompare can be set. This is
 * mainly used to divide the preset-list into different band ranges.
 * This indicates whether method start was accepted or rejected.
 */
class FID_TUN_S_SET_AUTOCOMP_PARAMResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_SET_AUTOCOMP_PARAMResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_SET_AUTOCOMP_PARAMResult (const FID_TUN_S_SET_AUTOCOMP_PARAMResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_SET_AUTOCOMP_PARAMResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_SET_AUTOCOMP_PARAMResult();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_SET_AUTOCOMP_PARAMResult& operator = (const FID_TUN_S_SET_AUTOCOMP_PARAMResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_SET_AUTOCOMP_PARAMResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_SET_AUTOCOMP_PARAMResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_SET_AUTOCOMP_PARAMResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_SET_AUTOCOMP_PARAMResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerServer_StatusResponse"

    static const int kTunerServer_StatusResponse = 0;

    /**
     * Clears the field "TunerServer_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerServer_StatusResponse()
     * method will return false.
     */
    inline void clearTunerServer_StatusResponse();

    /**
     * Checks whether the field "TunerServer_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerServer_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerServer_StatusResponse () const;

    /**
     * Returns the value of the member "TunerServer_StatusResponse".
     *
     * This method result indicates whether the Method Start
     * initiated by HMI was accepted or rejected.
     *
     * @return The value of the field "TunerServer_StatusResponse"
     */
    inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerServer_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerServer_StatusResponse".
     */
    inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerServer_StatusResponse".
     *
     * This method result indicates whether the Method Start
     * initiated by HMI was accepted or rejected.
     *
     * @param TunerServer_StatusResponse The value which will be set
     */
    inline void setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    static const FID_TUN_S_SET_AUTOCOMP_PARAMResult &getDefaultInstance();

private:

    inline void set_has_TunerServer_StatusResponse ();

    inline void clear_has_TunerServer_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_TunerServer_StatusResponse _TunerServer_StatusResponse;

};

/**
 * The start message of the method "FID_TUN_S_SET_RDBID"
 * This method is used to set RDBID parametres.
 */
class FID_TUN_S_SET_RDBIDStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_SET_RDBIDStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_SET_RDBIDStart (const FID_TUN_S_SET_RDBIDStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_SET_RDBIDStart (uint8 u8NumOfRDBID_, const ::std::vector< ::tuner_main_fi_types::T_Tun_RDBID_Value >& TunRDBID_Value_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_SET_RDBIDStart();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_SET_RDBIDStart& operator = (const FID_TUN_S_SET_RDBIDStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_SET_RDBIDStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_SET_RDBIDStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_SET_RDBIDStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_SET_RDBIDStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8NumOfRDBID"

    static const int kU8NumOfRDBID = 0;

    /**
     * Clears the field "u8NumOfRDBID".
     *
     * The field will be set to its default value. The hasU8NumOfRDBID()
     * method will return false.
     */
    inline void clearU8NumOfRDBID();

    /**
     * Checks whether the field "u8NumOfRDBID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8NumOfRDBID()). Otherwise it will return false.
     */
    inline bool hasU8NumOfRDBID () const;

    /**
     * Returns the value of the member "u8NumOfRDBID".
     *
     * 0-20 Total number of RDBIDs.
     *
     * @return The value of the field "u8NumOfRDBID"
     */
    inline uint8 getU8NumOfRDBID () const;

    /**
     * Sets the value of the member "u8NumOfRDBID".
     *
     * 0-20 Total number of RDBIDs.
     *
     * @param u8NumOfRDBID The value which will be set
     */
    inline void setU8NumOfRDBID (uint8 u8NumOfRDBID_);

    // API of field "TunRDBID_Value"

    static const int kTunRDBID_Value = 1;

    /**
     * Clears the field "TunRDBID_Value".
     *
     * The field will be set to its default value. The hasTunRDBID_Value()
     * method will return false.
     */
    inline void clearTunRDBID_Value();

    /**
     * Checks whether the field "TunRDBID_Value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunRDBID_Value()). Otherwise it will return false.
     */
    inline bool hasTunRDBID_Value () const;

    /**
     * Returns the value of the member "TunRDBID_Value".
     *
     * Class to be used: gm_tclU8Message.
     *
     * @return The value of the field "TunRDBID_Value"
     */
    inline const ::std::vector< ::tuner_main_fi_types::T_Tun_RDBID_Value >& getTunRDBID_Value () const;

    /**
     * Retrieves the value of the field "TunRDBID_Value" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunRDBID_Value".
     */
    inline ::std::vector< ::tuner_main_fi_types::T_Tun_RDBID_Value >& getTunRDBID_ValueMutable ();

    /**
     * Sets the value of the member "TunRDBID_Value".
     *
     * Class to be used: gm_tclU8Message.
     *
     * @param TunRDBID_Value The value which will be set
     */
    inline void setTunRDBID_Value (const ::std::vector< ::tuner_main_fi_types::T_Tun_RDBID_Value >& TunRDBID_Value_);

    static const FID_TUN_S_SET_RDBIDStart &getDefaultInstance();

private:

    static const ::std::vector< ::tuner_main_fi_types::T_Tun_RDBID_Value >& getT_Tun_RDBID_ValueList_DefaultInstance ();

    inline void set_has_u8NumOfRDBID ();

    inline void clear_has_u8NumOfRDBID ();

    inline void set_has_TunRDBID_Value ();

    inline void clear_has_TunRDBID_Value ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8NumOfRDBID;

    ::std::vector< ::tuner_main_fi_types::T_Tun_RDBID_Value > _TunRDBID_Value;

};

/**
 * The result message of the method "FID_TUN_S_SET_RDBID"
 * This method is used to set RDBID parametres.
 * .
 */
class FID_TUN_S_SET_RDBIDResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_SET_RDBIDResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_SET_RDBIDResult (const FID_TUN_S_SET_RDBIDResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_SET_RDBIDResult (const ::std::vector< ::tuner_main_fi_types::T_Tun_RDBID_Value >& TunRDBID_Value_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_SET_RDBIDResult();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_SET_RDBIDResult& operator = (const FID_TUN_S_SET_RDBIDResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_SET_RDBIDResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_SET_RDBIDResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_SET_RDBIDResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_SET_RDBIDResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunRDBID_Value"

    static const int kTunRDBID_Value = 0;

    /**
     * Clears the field "TunRDBID_Value".
     *
     * The field will be set to its default value. The hasTunRDBID_Value()
     * method will return false.
     */
    inline void clearTunRDBID_Value();

    /**
     * Checks whether the field "TunRDBID_Value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunRDBID_Value()). Otherwise it will return false.
     */
    inline bool hasTunRDBID_Value () const;

    /**
     * Returns the value of the member "TunRDBID_Value".
     *
     * Class to be used: gm_tclU8Message.
     *
     * @return The value of the field "TunRDBID_Value"
     */
    inline const ::std::vector< ::tuner_main_fi_types::T_Tun_RDBID_Value >& getTunRDBID_Value () const;

    /**
     * Retrieves the value of the field "TunRDBID_Value" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunRDBID_Value".
     */
    inline ::std::vector< ::tuner_main_fi_types::T_Tun_RDBID_Value >& getTunRDBID_ValueMutable ();

    /**
     * Sets the value of the member "TunRDBID_Value".
     *
     * Class to be used: gm_tclU8Message.
     *
     * @param TunRDBID_Value The value which will be set
     */
    inline void setTunRDBID_Value (const ::std::vector< ::tuner_main_fi_types::T_Tun_RDBID_Value >& TunRDBID_Value_);

    static const FID_TUN_S_SET_RDBIDResult &getDefaultInstance();

private:

    static const ::std::vector< ::tuner_main_fi_types::T_Tun_RDBID_Value >& getT_Tun_RDBID_ValueList_DefaultInstance ();

    inline void set_has_TunRDBID_Value ();

    inline void clear_has_TunRDBID_Value ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::tuner_main_fi_types::T_Tun_RDBID_Value > _TunRDBID_Value;

};

/**
 * The result message of the method "FID_TUN_S_CALIBRATION_DATA"
 * This method is used to set RDBID parametres.
 * This indicates whether method start was accepted or rejected.
 */
class FID_TUN_S_CALIBRATION_DATAResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_CALIBRATION_DATAResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_CALIBRATION_DATAResult (const FID_TUN_S_CALIBRATION_DATAResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_CALIBRATION_DATAResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_CALIBRATION_DATAResult();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_CALIBRATION_DATAResult& operator = (const FID_TUN_S_CALIBRATION_DATAResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_CALIBRATION_DATAResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_CALIBRATION_DATAResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_CALIBRATION_DATAResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_CALIBRATION_DATAResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerServer_StatusResponse"

    static const int kTunerServer_StatusResponse = 0;

    /**
     * Clears the field "TunerServer_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerServer_StatusResponse()
     * method will return false.
     */
    inline void clearTunerServer_StatusResponse();

    /**
     * Checks whether the field "TunerServer_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerServer_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerServer_StatusResponse () const;

    /**
     * Returns the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @return The value of the field "TunerServer_StatusResponse"
     */
    inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerServer_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerServer_StatusResponse".
     */
    inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @param TunerServer_StatusResponse The value which will be set
     */
    inline void setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    static const FID_TUN_S_CALIBRATION_DATAResult &getDefaultInstance();

private:

    inline void set_has_TunerServer_StatusResponse ();

    inline void clear_has_TunerServer_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_TunerServer_StatusResponse _TunerServer_StatusResponse;

};

/**
 * The result message of the method "FID_TUN_S_ACTIVE_TUNER"
 * This method is used to get the current active physical tuner
 * Returns the active physical tuner
 */
class FID_TUN_S_ACTIVE_TUNERResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_ACTIVE_TUNERResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_ACTIVE_TUNERResult (const FID_TUN_S_ACTIVE_TUNERResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_ACTIVE_TUNERResult (::tuner_main_fi_types::T_e8_Tun_PhysicalTuner u8_PhysicalTuner_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_ACTIVE_TUNERResult();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_ACTIVE_TUNERResult& operator = (const FID_TUN_S_ACTIVE_TUNERResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_ACTIVE_TUNERResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_ACTIVE_TUNERResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_ACTIVE_TUNERResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_ACTIVE_TUNERResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8_PhysicalTuner"

    static const int kU8_PhysicalTuner = 0;

    /**
     * Clears the field "u8_PhysicalTuner".
     *
     * The field will be set to its default value. The hasU8_PhysicalTuner()
     * method will return false.
     */
    inline void clearU8_PhysicalTuner();

    /**
     * Checks whether the field "u8_PhysicalTuner" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8_PhysicalTuner()). Otherwise it will return false.
     */
    inline bool hasU8_PhysicalTuner () const;

    /**
     * Returns the value of the member "u8_PhysicalTuner".
     *
     * This element indicates which physical tuner is active
     *
     * @return The value of the field "u8_PhysicalTuner"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_PhysicalTuner getU8_PhysicalTuner () const;

    /**
     * Sets the value of the member "u8_PhysicalTuner".
     *
     * This element indicates which physical tuner is active
     *
     * @param u8_PhysicalTuner The value which will be set
     */
    inline void setU8_PhysicalTuner (::tuner_main_fi_types::T_e8_Tun_PhysicalTuner u8_PhysicalTuner_);

    static const FID_TUN_S_ACTIVE_TUNERResult &getDefaultInstance();

private:

    inline void set_has_u8_PhysicalTuner ();

    inline void clear_has_u8_PhysicalTuner ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_e8_Tun_PhysicalTuner _u8_PhysicalTuner;

};

/**
 * The start message of the method "FID_TUN_S_STATIONLIST_EXIT"
 * This method is used to send station list exit info.
 */
class FID_TUN_S_STATIONLIST_EXITStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_STATIONLIST_EXITStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_STATIONLIST_EXITStart (const FID_TUN_S_STATIONLIST_EXITStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_STATIONLIST_EXITStart (::tuner_main_fi_types::T_e8_Tun_ConfigListID e8ConfigListID_, bool bFrozenList_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_STATIONLIST_EXITStart();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_STATIONLIST_EXITStart& operator = (const FID_TUN_S_STATIONLIST_EXITStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_STATIONLIST_EXITStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_STATIONLIST_EXITStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_STATIONLIST_EXITStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_STATIONLIST_EXITStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ConfigListID"

    static const int kE8ConfigListID = 0;

    /**
     * Clears the field "e8ConfigListID".
     *
     * The field will be set to its default value. The hasE8ConfigListID()
     * method will return false.
     */
    inline void clearE8ConfigListID();

    /**
     * Checks whether the field "e8ConfigListID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ConfigListID()). Otherwise it will return false.
     */
    inline bool hasE8ConfigListID () const;

    /**
     * Returns the value of the member "e8ConfigListID".
     *
     * .
     *
     * @return The value of the field "e8ConfigListID"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_ConfigListID getE8ConfigListID () const;

    /**
     * Sets the value of the member "e8ConfigListID".
     *
     * .
     *
     * @param e8ConfigListID The value which will be set
     */
    inline void setE8ConfigListID (::tuner_main_fi_types::T_e8_Tun_ConfigListID e8ConfigListID_);

    // API of field "bFrozenList"

    static const int kBFrozenList = 1;

    /**
     * Clears the field "bFrozenList".
     *
     * The field will be set to its default value. The hasBFrozenList()
     * method will return false.
     */
    inline void clearBFrozenList();

    /**
     * Checks whether the field "bFrozenList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBFrozenList()). Otherwise it will return false.
     */
    inline bool hasBFrozenList () const;

    /**
     * Returns the value of the member "bFrozenList".
     *
     * Clients that use frozen station list should set this field to true.
     * And all others should set this field to false.
     *
     * @return The value of the field "bFrozenList"
     */
    inline bool getBFrozenList () const;

    /**
     * Sets the value of the member "bFrozenList".
     *
     * Clients that use frozen station list should set this field to true.
     * And all others should set this field to false.
     *
     * @param bFrozenList The value which will be set
     */
    inline void setBFrozenList (bool bFrozenList_);

    static const FID_TUN_S_STATIONLIST_EXITStart &getDefaultInstance();

private:

    inline void set_has_e8ConfigListID ();

    inline void clear_has_e8ConfigListID ();

    inline void set_has_bFrozenList ();

    inline void clear_has_bFrozenList ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::tuner_main_fi_types::T_e8_Tun_ConfigListID _e8ConfigListID;

    bool _bFrozenList;

};

/**
 * The result message of the method "FID_TUN_S_STATIONLIST_EXIT"
 * This method is used to send station list exit info.
 * This indicates whether method start was accepted or rejected.
 */
class FID_TUN_S_STATIONLIST_EXITResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_STATIONLIST_EXITResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_STATIONLIST_EXITResult (const FID_TUN_S_STATIONLIST_EXITResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_STATIONLIST_EXITResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_STATIONLIST_EXITResult();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_STATIONLIST_EXITResult& operator = (const FID_TUN_S_STATIONLIST_EXITResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_STATIONLIST_EXITResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_STATIONLIST_EXITResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_STATIONLIST_EXITResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_STATIONLIST_EXITResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerServer_StatusResponse"

    static const int kTunerServer_StatusResponse = 0;

    /**
     * Clears the field "TunerServer_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerServer_StatusResponse()
     * method will return false.
     */
    inline void clearTunerServer_StatusResponse();

    /**
     * Checks whether the field "TunerServer_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerServer_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerServer_StatusResponse () const;

    /**
     * Returns the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @return The value of the field "TunerServer_StatusResponse"
     */
    inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerServer_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerServer_StatusResponse".
     */
    inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @param TunerServer_StatusResponse The value which will be set
     */
    inline void setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    static const FID_TUN_S_STATIONLIST_EXITResult &getDefaultInstance();

private:

    inline void set_has_TunerServer_StatusResponse ();

    inline void clear_has_TunerServer_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_TunerServer_StatusResponse _TunerServer_StatusResponse;

};

/**
 * The start message of the method "FID_TUN_S_SURVEIL_TP"
 * Starts/Stops TA announcement data tuner (background) surveillance for a given station.
 * If tuned station is NON-TP then TP Search happens and starts monitoring
 */
class FID_TUN_S_SURVEIL_TPStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_SURVEIL_TPStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_SURVEIL_TPStart (const FID_TUN_S_SURVEIL_TPStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_SURVEIL_TPStart (bool bSurveilTP_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_SURVEIL_TPStart();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_SURVEIL_TPStart& operator = (const FID_TUN_S_SURVEIL_TPStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_SURVEIL_TPStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_SURVEIL_TPStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_SURVEIL_TPStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_SURVEIL_TPStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bSurveilTP"

    static const int kBSurveilTP = 0;

    /**
     * Clears the field "bSurveilTP".
     *
     * The field will be set to its default value. The hasBSurveilTP()
     * method will return false.
     */
    inline void clearBSurveilTP();

    /**
     * Checks whether the field "bSurveilTP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBSurveilTP()). Otherwise it will return false.
     */
    inline bool hasBSurveilTP () const;

    /**
     * Returns the value of the member "bSurveilTP".
     *
     * 0 - Start surveillance
     * 1 - Stop surveillance
     *
     * @return The value of the field "bSurveilTP"
     */
    inline bool getBSurveilTP () const;

    /**
     * Sets the value of the member "bSurveilTP".
     *
     * 0 - Start surveillance
     * 1 - Stop surveillance
     *
     * @param bSurveilTP The value which will be set
     */
    inline void setBSurveilTP (bool bSurveilTP_);

    static const FID_TUN_S_SURVEIL_TPStart &getDefaultInstance();

private:

    inline void set_has_bSurveilTP ();

    inline void clear_has_bSurveilTP ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bSurveilTP;

};

/**
 * The result message of the method "FID_TUN_S_SURVEIL_TP"
 * Starts/Stops TA announcement data tuner (background) surveillance for a given station.
 * If tuned station is NON-TP then TP Search happens and starts monitoring
 * This indicates whether method start was accepted or rejected.
 */
class FID_TUN_S_SURVEIL_TPResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_SURVEIL_TPResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_SURVEIL_TPResult (const FID_TUN_S_SURVEIL_TPResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_SURVEIL_TPResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_SURVEIL_TPResult();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_SURVEIL_TPResult& operator = (const FID_TUN_S_SURVEIL_TPResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_SURVEIL_TPResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_SURVEIL_TPResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_SURVEIL_TPResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_SURVEIL_TPResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerServer_StatusResponse"

    static const int kTunerServer_StatusResponse = 0;

    /**
     * Clears the field "TunerServer_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerServer_StatusResponse()
     * method will return false.
     */
    inline void clearTunerServer_StatusResponse();

    /**
     * Checks whether the field "TunerServer_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerServer_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerServer_StatusResponse () const;

    /**
     * Returns the value of the member "TunerServer_StatusResponse".
     *
     *
     *
     * @return The value of the field "TunerServer_StatusResponse"
     */
    inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerServer_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerServer_StatusResponse".
     */
    inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerServer_StatusResponse".
     *
     *
     *
     * @param TunerServer_StatusResponse The value which will be set
     */
    inline void setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    static const FID_TUN_S_SURVEIL_TPResult &getDefaultInstance();

private:

    inline void set_has_TunerServer_StatusResponse ();

    inline void clear_has_TunerServer_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_TunerServer_StatusResponse _TunerServer_StatusResponse;

};

/**
 * The start message of the method "FID_TUN_S_SET_ENGG_PARAMETER"
 * This allows to modify given Engineering parameter.
 */
class FID_TUN_S_SET_ENGG_PARAMETERStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_SET_ENGG_PARAMETERStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_SET_ENGG_PARAMETERStart (const FID_TUN_S_SET_ENGG_PARAMETERStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_SET_ENGG_PARAMETERStart (::tuner_main_fi_types::T_e8_Tun_Engg_Param_ID e8ParameterID_, uint32 u32ParameterValue_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_SET_ENGG_PARAMETERStart();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_SET_ENGG_PARAMETERStart& operator = (const FID_TUN_S_SET_ENGG_PARAMETERStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_SET_ENGG_PARAMETERStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_SET_ENGG_PARAMETERStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_SET_ENGG_PARAMETERStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_SET_ENGG_PARAMETERStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ParameterID"

    static const int kE8ParameterID = 0;

    /**
     * Clears the field "e8ParameterID".
     *
     * The field will be set to its default value. The hasE8ParameterID()
     * method will return false.
     */
    inline void clearE8ParameterID();

    /**
     * Checks whether the field "e8ParameterID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ParameterID()). Otherwise it will return false.
     */
    inline bool hasE8ParameterID () const;

    /**
     * Returns the value of the member "e8ParameterID".
     *
     * This Parameter indicates which Engg Parameter is selected for modification
     *
     * @return The value of the field "e8ParameterID"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_Engg_Param_ID getE8ParameterID () const;

    /**
     * Sets the value of the member "e8ParameterID".
     *
     * This Parameter indicates which Engg Parameter is selected for modification
     *
     * @param e8ParameterID The value which will be set
     */
    inline void setE8ParameterID (::tuner_main_fi_types::T_e8_Tun_Engg_Param_ID e8ParameterID_);

    // API of field "u32ParameterValue"

    static const int kU32ParameterValue = 1;

    /**
     * Clears the field "u32ParameterValue".
     *
     * The field will be set to its default value. The hasU32ParameterValue()
     * method will return false.
     */
    inline void clearU32ParameterValue();

    /**
     * Checks whether the field "u32ParameterValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ParameterValue()). Otherwise it will return false.
     */
    inline bool hasU32ParameterValue () const;

    /**
     * Returns the value of the member "u32ParameterValue".
     *
     * The value to be set to the Engineering Parameter selected for modification
     *
     * @return The value of the field "u32ParameterValue"
     */
    inline uint32 getU32ParameterValue () const;

    /**
     * Sets the value of the member "u32ParameterValue".
     *
     * The value to be set to the Engineering Parameter selected for modification
     *
     * @param u32ParameterValue The value which will be set
     */
    inline void setU32ParameterValue (uint32 u32ParameterValue_);

    static const FID_TUN_S_SET_ENGG_PARAMETERStart &getDefaultInstance();

private:

    inline void set_has_e8ParameterID ();

    inline void clear_has_e8ParameterID ();

    inline void set_has_u32ParameterValue ();

    inline void clear_has_u32ParameterValue ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::tuner_main_fi_types::T_e8_Tun_Engg_Param_ID _e8ParameterID;

    uint32 _u32ParameterValue;

};

/**
 * The result message of the method "FID_TUN_S_SET_ENGG_PARAMETER"
 * This allows to modify given Engineering parameter.
 * This indicates whether method start was accepted or rejected.
 */
class FID_TUN_S_SET_ENGG_PARAMETERResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_SET_ENGG_PARAMETERResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_SET_ENGG_PARAMETERResult (const FID_TUN_S_SET_ENGG_PARAMETERResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_SET_ENGG_PARAMETERResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_SET_ENGG_PARAMETERResult();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_SET_ENGG_PARAMETERResult& operator = (const FID_TUN_S_SET_ENGG_PARAMETERResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_SET_ENGG_PARAMETERResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_SET_ENGG_PARAMETERResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_SET_ENGG_PARAMETERResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_SET_ENGG_PARAMETERResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerServer_StatusResponse"

    static const int kTunerServer_StatusResponse = 0;

    /**
     * Clears the field "TunerServer_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerServer_StatusResponse()
     * method will return false.
     */
    inline void clearTunerServer_StatusResponse();

    /**
     * Checks whether the field "TunerServer_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerServer_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerServer_StatusResponse () const;

    /**
     * Returns the value of the member "TunerServer_StatusResponse".
     *
     *
     *
     * @return The value of the field "TunerServer_StatusResponse"
     */
    inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerServer_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerServer_StatusResponse".
     */
    inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerServer_StatusResponse".
     *
     *
     *
     * @param TunerServer_StatusResponse The value which will be set
     */
    inline void setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    static const FID_TUN_S_SET_ENGG_PARAMETERResult &getDefaultInstance();

private:

    inline void set_has_TunerServer_StatusResponse ();

    inline void clear_has_TunerServer_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_TunerServer_StatusResponse _TunerServer_StatusResponse;

};

/**
 * The start message of the method "FID_TUN_S_ANNOUNCEMENT_SWITCH"
 * Activates/Deactivates the signalling of a detected announcement
 */
class FID_TUN_S_ANNOUNCEMENT_SWITCHStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_ANNOUNCEMENT_SWITCHStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_ANNOUNCEMENT_SWITCHStart (const FID_TUN_S_ANNOUNCEMENT_SWITCHStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_ANNOUNCEMENT_SWITCHStart (const ::tuner_main_fi_types::T_b8_AnnoTypes& b8AnnoType_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_ANNOUNCEMENT_SWITCHStart();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_ANNOUNCEMENT_SWITCHStart& operator = (const FID_TUN_S_ANNOUNCEMENT_SWITCHStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_ANNOUNCEMENT_SWITCHStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_ANNOUNCEMENT_SWITCHStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_ANNOUNCEMENT_SWITCHStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_ANNOUNCEMENT_SWITCHStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "b8AnnoType"

    static const int kB8AnnoType = 0;

    /**
     * Clears the field "b8AnnoType".
     *
     * The field will be set to its default value. The hasB8AnnoType()
     * method will return false.
     */
    inline void clearB8AnnoType();

    /**
     * Checks whether the field "b8AnnoType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setB8AnnoType()). Otherwise it will return false.
     */
    inline bool hasB8AnnoType () const;

    /**
     * Returns the value of the member "b8AnnoType".
     *
     * This parameter will tell for which Anno type we need to monitor.
     *
     * @return The value of the field "b8AnnoType"
     */
    inline const ::tuner_main_fi_types::T_b8_AnnoTypes& getB8AnnoType () const;

    /**
     * Retrieves the value of the field "b8AnnoType" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "b8AnnoType".
     */
    inline ::tuner_main_fi_types::T_b8_AnnoTypes& getB8AnnoTypeMutable ();

    /**
     * Sets the value of the member "b8AnnoType".
     *
     * This parameter will tell for which Anno type we need to monitor.
     *
     * @param b8AnnoType The value which will be set
     */
    inline void setB8AnnoType (const ::tuner_main_fi_types::T_b8_AnnoTypes& b8AnnoType_);

    static const FID_TUN_S_ANNOUNCEMENT_SWITCHStart &getDefaultInstance();

private:

    inline void set_has_b8AnnoType ();

    inline void clear_has_b8AnnoType ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_b8_AnnoTypes _b8AnnoType;

};

/**
 * The result message of the method "FID_TUN_S_ANNOUNCEMENT_SWITCH"
 * Activates/Deactivates the signalling of a detected announcement
 * This indicates whether method start was accepted or rejected.
 */
class FID_TUN_S_ANNOUNCEMENT_SWITCHResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_ANNOUNCEMENT_SWITCHResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_ANNOUNCEMENT_SWITCHResult (const FID_TUN_S_ANNOUNCEMENT_SWITCHResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_ANNOUNCEMENT_SWITCHResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_ANNOUNCEMENT_SWITCHResult();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_ANNOUNCEMENT_SWITCHResult& operator = (const FID_TUN_S_ANNOUNCEMENT_SWITCHResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_ANNOUNCEMENT_SWITCHResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_ANNOUNCEMENT_SWITCHResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_ANNOUNCEMENT_SWITCHResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_ANNOUNCEMENT_SWITCHResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerServer_StatusResponse"

    static const int kTunerServer_StatusResponse = 0;

    /**
     * Clears the field "TunerServer_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerServer_StatusResponse()
     * method will return false.
     */
    inline void clearTunerServer_StatusResponse();

    /**
     * Checks whether the field "TunerServer_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerServer_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerServer_StatusResponse () const;

    /**
     * Returns the value of the member "TunerServer_StatusResponse".
     *
     *
     *
     * @return The value of the field "TunerServer_StatusResponse"
     */
    inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerServer_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerServer_StatusResponse".
     */
    inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerServer_StatusResponse".
     *
     *
     *
     * @param TunerServer_StatusResponse The value which will be set
     */
    inline void setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    static const FID_TUN_S_ANNOUNCEMENT_SWITCHResult &getDefaultInstance();

private:

    inline void set_has_TunerServer_StatusResponse ();

    inline void clear_has_TunerServer_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_TunerServer_StatusResponse _TunerServer_StatusResponse;

};

/**
 * The start message of the method "FID_TUN_S_ANNOUNCEMENT_ESCAPE"
 * The given announcement will be cancelled for the given audio tuner
 */
class FID_TUN_S_ANNOUNCEMENT_ESCAPEStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_ANNOUNCEMENT_ESCAPEStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_ANNOUNCEMENT_ESCAPEStart (const FID_TUN_S_ANNOUNCEMENT_ESCAPEStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_ANNOUNCEMENT_ESCAPEStart (::tuner_main_fi_types::T_e8_Tun_AnnoTypes e8AnnoType_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_ANNOUNCEMENT_ESCAPEStart();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_ANNOUNCEMENT_ESCAPEStart& operator = (const FID_TUN_S_ANNOUNCEMENT_ESCAPEStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_ANNOUNCEMENT_ESCAPEStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_ANNOUNCEMENT_ESCAPEStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_ANNOUNCEMENT_ESCAPEStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_ANNOUNCEMENT_ESCAPEStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8AnnoType"

    static const int kE8AnnoType = 0;

    /**
     * Clears the field "e8AnnoType".
     *
     * The field will be set to its default value. The hasE8AnnoType()
     * method will return false.
     */
    inline void clearE8AnnoType();

    /**
     * Checks whether the field "e8AnnoType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8AnnoType()). Otherwise it will return false.
     */
    inline bool hasE8AnnoType () const;

    /**
     * Returns the value of the member "e8AnnoType".
     *
     * 0: TP Switch
     * 1: PTY Switch
     *
     * @return The value of the field "e8AnnoType"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_AnnoTypes getE8AnnoType () const;

    /**
     * Sets the value of the member "e8AnnoType".
     *
     * 0: TP Switch
     * 1: PTY Switch
     *
     * @param e8AnnoType The value which will be set
     */
    inline void setE8AnnoType (::tuner_main_fi_types::T_e8_Tun_AnnoTypes e8AnnoType_);

    static const FID_TUN_S_ANNOUNCEMENT_ESCAPEStart &getDefaultInstance();

private:

    inline void set_has_e8AnnoType ();

    inline void clear_has_e8AnnoType ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_e8_Tun_AnnoTypes _e8AnnoType;

};

/**
 * The result message of the method "FID_TUN_S_ANNOUNCEMENT_ESCAPE"
 * The given announcement will be cancelled for the given audio tuner
 * .
 */
class FID_TUN_S_ANNOUNCEMENT_ESCAPEResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_ANNOUNCEMENT_ESCAPEResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_ANNOUNCEMENT_ESCAPEResult (const FID_TUN_S_ANNOUNCEMENT_ESCAPEResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_ANNOUNCEMENT_ESCAPEResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_ANNOUNCEMENT_ESCAPEResult();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_ANNOUNCEMENT_ESCAPEResult& operator = (const FID_TUN_S_ANNOUNCEMENT_ESCAPEResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_ANNOUNCEMENT_ESCAPEResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_ANNOUNCEMENT_ESCAPEResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_ANNOUNCEMENT_ESCAPEResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_ANNOUNCEMENT_ESCAPEResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerServer_StatusResponse"

    static const int kTunerServer_StatusResponse = 0;

    /**
     * Clears the field "TunerServer_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerServer_StatusResponse()
     * method will return false.
     */
    inline void clearTunerServer_StatusResponse();

    /**
     * Checks whether the field "TunerServer_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerServer_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerServer_StatusResponse () const;

    /**
     * Returns the value of the member "TunerServer_StatusResponse".
     *
     * Class to be used: gm_tclU16Message.
     *
     * @return The value of the field "TunerServer_StatusResponse"
     */
    inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerServer_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerServer_StatusResponse".
     */
    inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerServer_StatusResponse".
     *
     * Class to be used: gm_tclU16Message.
     *
     * @param TunerServer_StatusResponse The value which will be set
     */
    inline void setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    static const FID_TUN_S_ANNOUNCEMENT_ESCAPEResult &getDefaultInstance();

private:

    inline void set_has_TunerServer_StatusResponse ();

    inline void clear_has_TunerServer_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_TunerServer_StatusResponse _TunerServer_StatusResponse;

};

/**
 * The start message of the method "FID_TUN_S_PRESET_STORAGE_PS_FREEZE"
 * This is used to freeze / unfreeze the current PS of the audio tuner before saving Preset.
 * By this method sudden change of the PS short before the actual save is avoided.
 */
class FID_TUN_S_PRESET_STORAGE_PS_FREEZEStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_PRESET_STORAGE_PS_FREEZEStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_PRESET_STORAGE_PS_FREEZEStart (const FID_TUN_S_PRESET_STORAGE_PS_FREEZEStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_PRESET_STORAGE_PS_FREEZEStart (::tuner_main_fi_types::T_e8_PS_Freeze_Mode e8Mode_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_PRESET_STORAGE_PS_FREEZEStart();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_PRESET_STORAGE_PS_FREEZEStart& operator = (const FID_TUN_S_PRESET_STORAGE_PS_FREEZEStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_PRESET_STORAGE_PS_FREEZEStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_PRESET_STORAGE_PS_FREEZEStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_PRESET_STORAGE_PS_FREEZEStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_PRESET_STORAGE_PS_FREEZEStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Mode"

    static const int kE8Mode = 0;

    /**
     * Clears the field "e8Mode".
     *
     * The field will be set to its default value. The hasE8Mode()
     * method will return false.
     */
    inline void clearE8Mode();

    /**
     * Checks whether the field "e8Mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Mode()). Otherwise it will return false.
     */
    inline bool hasE8Mode () const;

    /**
     * Returns the value of the member "e8Mode".
     *
     * 0 Freeze
     * 1 Unfreeze
     *
     * @return The value of the field "e8Mode"
     */
    inline ::tuner_main_fi_types::T_e8_PS_Freeze_Mode getE8Mode () const;

    /**
     * Sets the value of the member "e8Mode".
     *
     * 0 Freeze
     * 1 Unfreeze
     *
     * @param e8Mode The value which will be set
     */
    inline void setE8Mode (::tuner_main_fi_types::T_e8_PS_Freeze_Mode e8Mode_);

    static const FID_TUN_S_PRESET_STORAGE_PS_FREEZEStart &getDefaultInstance();

private:

    inline void set_has_e8Mode ();

    inline void clear_has_e8Mode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_e8_PS_Freeze_Mode _e8Mode;

};

/**
 * The result message of the method "FID_TUN_S_PRESET_STORAGE_PS_FREEZE"
 * This is used to freeze / unfreeze the current PS of the audio tuner before saving Preset.
 * By this method sudden change of the PS short before the actual save is avoided.
 * .
 */
class FID_TUN_S_PRESET_STORAGE_PS_FREEZEResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_PRESET_STORAGE_PS_FREEZEResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_PRESET_STORAGE_PS_FREEZEResult (const FID_TUN_S_PRESET_STORAGE_PS_FREEZEResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_PRESET_STORAGE_PS_FREEZEResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_PRESET_STORAGE_PS_FREEZEResult();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_PRESET_STORAGE_PS_FREEZEResult& operator = (const FID_TUN_S_PRESET_STORAGE_PS_FREEZEResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_PRESET_STORAGE_PS_FREEZEResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_PRESET_STORAGE_PS_FREEZEResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_PRESET_STORAGE_PS_FREEZEResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_PRESET_STORAGE_PS_FREEZEResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerServer_StatusResponse"

    static const int kTunerServer_StatusResponse = 0;

    /**
     * Clears the field "TunerServer_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerServer_StatusResponse()
     * method will return false.
     */
    inline void clearTunerServer_StatusResponse();

    /**
     * Checks whether the field "TunerServer_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerServer_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerServer_StatusResponse () const;

    /**
     * Returns the value of the member "TunerServer_StatusResponse".
     *
     * Class to be used: gm_tclU16Message.
     *
     * @return The value of the field "TunerServer_StatusResponse"
     */
    inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerServer_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerServer_StatusResponse".
     */
    inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerServer_StatusResponse".
     *
     * Class to be used: gm_tclU16Message.
     *
     * @param TunerServer_StatusResponse The value which will be set
     */
    inline void setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    static const FID_TUN_S_PRESET_STORAGE_PS_FREEZEResult &getDefaultInstance();

private:

    inline void set_has_TunerServer_StatusResponse ();

    inline void clear_has_TunerServer_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_TunerServer_StatusResponse _TunerServer_StatusResponse;

};

/**
 * The start message of the method "FID_TUN_S_SPEED_INFO"
 * sets the speed information
 */
class FID_TUN_S_SPEED_INFOStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_SPEED_INFOStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_SPEED_INFOStart (const FID_TUN_S_SPEED_INFOStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_SPEED_INFOStart (uint8 u8Speed_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_SPEED_INFOStart();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_SPEED_INFOStart& operator = (const FID_TUN_S_SPEED_INFOStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_SPEED_INFOStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_SPEED_INFOStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_SPEED_INFOStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_SPEED_INFOStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8Speed"

    static const int kU8Speed = 0;

    /**
     * Clears the field "u8Speed".
     *
     * The field will be set to its default value. The hasU8Speed()
     * method will return false.
     */
    inline void clearU8Speed();

    /**
     * Checks whether the field "u8Speed" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Speed()). Otherwise it will return false.
     */
    inline bool hasU8Speed () const;

    /**
     * Returns the value of the member "u8Speed".
     *
     *
     *
     * @return The value of the field "u8Speed"
     */
    inline uint8 getU8Speed () const;

    /**
     * Sets the value of the member "u8Speed".
     *
     *
     *
     * @param u8Speed The value which will be set
     */
    inline void setU8Speed (uint8 u8Speed_);

    static const FID_TUN_S_SPEED_INFOStart &getDefaultInstance();

private:

    inline void set_has_u8Speed ();

    inline void clear_has_u8Speed ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8Speed;

};

/**
 * The result message of the method "FID_TUN_S_SPEED_INFO"
 * sets the speed information
 * .
 */
class FID_TUN_S_SPEED_INFOResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_SPEED_INFOResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_SPEED_INFOResult (const FID_TUN_S_SPEED_INFOResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_SPEED_INFOResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_SPEED_INFOResult();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_SPEED_INFOResult& operator = (const FID_TUN_S_SPEED_INFOResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_SPEED_INFOResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_SPEED_INFOResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_SPEED_INFOResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_SPEED_INFOResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerServer_StatusResponse"

    static const int kTunerServer_StatusResponse = 0;

    /**
     * Clears the field "TunerServer_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerServer_StatusResponse()
     * method will return false.
     */
    inline void clearTunerServer_StatusResponse();

    /**
     * Checks whether the field "TunerServer_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerServer_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerServer_StatusResponse () const;

    /**
     * Returns the value of the member "TunerServer_StatusResponse".
     *
     * Class to be used: gm_tclU16Message.
     *
     * @return The value of the field "TunerServer_StatusResponse"
     */
    inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerServer_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerServer_StatusResponse".
     */
    inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerServer_StatusResponse".
     *
     * Class to be used: gm_tclU16Message.
     *
     * @param TunerServer_StatusResponse The value which will be set
     */
    inline void setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    static const FID_TUN_S_SPEED_INFOResult &getDefaultInstance();

private:

    inline void set_has_TunerServer_StatusResponse ();

    inline void clear_has_TunerServer_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_TunerServer_StatusResponse _TunerServer_StatusResponse;

};

/**
 * The result message of the method "FID_TUN_S_AUDIO_MUTEREQUEST"
 * This method is used to send mute status from Tunermaster to Tuner.
 * Will be extended if Mute Status to be sent from other clients.
 * This indicates whether method start was accepted or rejected.
 */
class FID_TUN_S_AUDIO_MUTEREQUESTResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_AUDIO_MUTEREQUESTResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_AUDIO_MUTEREQUESTResult (const FID_TUN_S_AUDIO_MUTEREQUESTResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_AUDIO_MUTEREQUESTResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_AUDIO_MUTEREQUESTResult();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_AUDIO_MUTEREQUESTResult& operator = (const FID_TUN_S_AUDIO_MUTEREQUESTResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_AUDIO_MUTEREQUESTResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_AUDIO_MUTEREQUESTResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_AUDIO_MUTEREQUESTResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_AUDIO_MUTEREQUESTResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerServer_StatusResponse"

    static const int kTunerServer_StatusResponse = 0;

    /**
     * Clears the field "TunerServer_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerServer_StatusResponse()
     * method will return false.
     */
    inline void clearTunerServer_StatusResponse();

    /**
     * Checks whether the field "TunerServer_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerServer_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerServer_StatusResponse () const;

    /**
     * Returns the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @return The value of the field "TunerServer_StatusResponse"
     */
    inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerServer_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerServer_StatusResponse".
     */
    inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @param TunerServer_StatusResponse The value which will be set
     */
    inline void setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    static const FID_TUN_S_AUDIO_MUTEREQUESTResult &getDefaultInstance();

private:

    inline void set_has_TunerServer_StatusResponse ();

    inline void clear_has_TunerServer_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_TunerServer_StatusResponse _TunerServer_StatusResponse;

};

/**
 * The start message of the method "FID_TUN_S_CONFIGLIST_UPDATE"
 * Checks if new stations are receivable for the given config list or if recently found
 * stations are no longer receivable.
 */
class FID_TUN_S_CONFIGLIST_UPDATEStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_CONFIGLIST_UPDATEStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_CONFIGLIST_UPDATEStart (const FID_TUN_S_CONFIGLIST_UPDATEStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_CONFIGLIST_UPDATEStart (::tuner_main_fi_types::T_e8_Tun_ConfigListID e8ConfigListID_, bool bStatus_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_CONFIGLIST_UPDATEStart();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_CONFIGLIST_UPDATEStart& operator = (const FID_TUN_S_CONFIGLIST_UPDATEStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_CONFIGLIST_UPDATEStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_CONFIGLIST_UPDATEStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_CONFIGLIST_UPDATEStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_CONFIGLIST_UPDATEStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ConfigListID"

    static const int kE8ConfigListID = 0;

    /**
     * Clears the field "e8ConfigListID".
     *
     * The field will be set to its default value. The hasE8ConfigListID()
     * method will return false.
     */
    inline void clearE8ConfigListID();

    /**
     * Checks whether the field "e8ConfigListID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ConfigListID()). Otherwise it will return false.
     */
    inline bool hasE8ConfigListID () const;

    /**
     * Returns the value of the member "e8ConfigListID".
     *
     * ConfigList ID which needs to be updated
     *
     * @return The value of the field "e8ConfigListID"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_ConfigListID getE8ConfigListID () const;

    /**
     * Sets the value of the member "e8ConfigListID".
     *
     * ConfigList ID which needs to be updated
     *
     * @param e8ConfigListID The value which will be set
     */
    inline void setE8ConfigListID (::tuner_main_fi_types::T_e8_Tun_ConfigListID e8ConfigListID_);

    // API of field "bStatus"

    static const int kBStatus = 1;

    /**
     * Clears the field "bStatus".
     *
     * The field will be set to its default value. The hasBStatus()
     * method will return false.
     */
    inline void clearBStatus();

    /**
     * Checks whether the field "bStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBStatus()). Otherwise it will return false.
     */
    inline bool hasBStatus () const;

    /**
     * Returns the value of the member "bStatus".
     *
     * This indicates whether update landscape to be started or stopped
     *
     * @return The value of the field "bStatus"
     */
    inline bool getBStatus () const;

    /**
     * Sets the value of the member "bStatus".
     *
     * This indicates whether update landscape to be started or stopped
     *
     * @param bStatus The value which will be set
     */
    inline void setBStatus (bool bStatus_);

    static const FID_TUN_S_CONFIGLIST_UPDATEStart &getDefaultInstance();

private:

    inline void set_has_e8ConfigListID ();

    inline void clear_has_e8ConfigListID ();

    inline void set_has_bStatus ();

    inline void clear_has_bStatus ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::tuner_main_fi_types::T_e8_Tun_ConfigListID _e8ConfigListID;

    bool _bStatus;

};

/**
 * The result message of the method "FID_TUN_S_CONFIGLIST_UPDATE"
 * Checks if new stations are receivable for the given config list or if recently found
 * stations are no longer receivable.
 * This indicates whether method start was accepted or rejected.
 */
class FID_TUN_S_CONFIGLIST_UPDATEResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_CONFIGLIST_UPDATEResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_CONFIGLIST_UPDATEResult (const FID_TUN_S_CONFIGLIST_UPDATEResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_CONFIGLIST_UPDATEResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_CONFIGLIST_UPDATEResult();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_CONFIGLIST_UPDATEResult& operator = (const FID_TUN_S_CONFIGLIST_UPDATEResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_CONFIGLIST_UPDATEResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_CONFIGLIST_UPDATEResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_CONFIGLIST_UPDATEResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_CONFIGLIST_UPDATEResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerServer_StatusResponse"

    static const int kTunerServer_StatusResponse = 0;

    /**
     * Clears the field "TunerServer_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerServer_StatusResponse()
     * method will return false.
     */
    inline void clearTunerServer_StatusResponse();

    /**
     * Checks whether the field "TunerServer_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerServer_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerServer_StatusResponse () const;

    /**
     * Returns the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @return The value of the field "TunerServer_StatusResponse"
     */
    inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerServer_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerServer_StatusResponse".
     */
    inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @param TunerServer_StatusResponse The value which will be set
     */
    inline void setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    static const FID_TUN_S_CONFIGLIST_UPDATEResult &getDefaultInstance();

private:

    inline void set_has_TunerServer_StatusResponse ();

    inline void clear_has_TunerServer_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_TunerServer_StatusResponse _TunerServer_StatusResponse;

};

/**
 * The start message of the method "FID_TUN_S_DEFAULT_SETTING"
 * By this method the given default setting option is performed. The related parameters of the active
 * configuration are reset to the values as given by the original configuration.
 * Currently only one option is supported.
 */
class FID_TUN_S_DEFAULT_SETTINGStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_DEFAULT_SETTINGStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_DEFAULT_SETTINGStart (const FID_TUN_S_DEFAULT_SETTINGStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_DEFAULT_SETTINGStart (::tuner_main_fi_types::T_e8_Tun_DefaultSettingOption e8DefaultSettingOption_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_DEFAULT_SETTINGStart();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_DEFAULT_SETTINGStart& operator = (const FID_TUN_S_DEFAULT_SETTINGStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_DEFAULT_SETTINGStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_DEFAULT_SETTINGStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_DEFAULT_SETTINGStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_DEFAULT_SETTINGStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8DefaultSettingOption"

    static const int kE8DefaultSettingOption = 0;

    /**
     * Clears the field "e8DefaultSettingOption".
     *
     * The field will be set to its default value. The hasE8DefaultSettingOption()
     * method will return false.
     */
    inline void clearE8DefaultSettingOption();

    /**
     * Checks whether the field "e8DefaultSettingOption" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DefaultSettingOption()). Otherwise it will return false.
     */
    inline bool hasE8DefaultSettingOption () const;

    /**
     * Returns the value of the member "e8DefaultSettingOption".
     *
     * available options for sending default settings
     *
     * @return The value of the field "e8DefaultSettingOption"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_DefaultSettingOption getE8DefaultSettingOption () const;

    /**
     * Sets the value of the member "e8DefaultSettingOption".
     *
     * available options for sending default settings
     *
     * @param e8DefaultSettingOption The value which will be set
     */
    inline void setE8DefaultSettingOption (::tuner_main_fi_types::T_e8_Tun_DefaultSettingOption e8DefaultSettingOption_);

    static const FID_TUN_S_DEFAULT_SETTINGStart &getDefaultInstance();

private:

    inline void set_has_e8DefaultSettingOption ();

    inline void clear_has_e8DefaultSettingOption ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_e8_Tun_DefaultSettingOption _e8DefaultSettingOption;

};

/**
 * The result message of the method "FID_TUN_S_DEFAULT_SETTING"
 * By this method the given default setting option is performed. The related parameters of the active
 * configuration are reset to the values as given by the original configuration.
 * Currently only one option is supported.
 * This indicates whether method start was accepted or rejected.
 */
class FID_TUN_S_DEFAULT_SETTINGResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_DEFAULT_SETTINGResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_DEFAULT_SETTINGResult (const FID_TUN_S_DEFAULT_SETTINGResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_DEFAULT_SETTINGResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_DEFAULT_SETTINGResult();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_DEFAULT_SETTINGResult& operator = (const FID_TUN_S_DEFAULT_SETTINGResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_DEFAULT_SETTINGResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_DEFAULT_SETTINGResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_DEFAULT_SETTINGResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_DEFAULT_SETTINGResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerServer_StatusResponse"

    static const int kTunerServer_StatusResponse = 0;

    /**
     * Clears the field "TunerServer_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerServer_StatusResponse()
     * method will return false.
     */
    inline void clearTunerServer_StatusResponse();

    /**
     * Checks whether the field "TunerServer_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerServer_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerServer_StatusResponse () const;

    /**
     * Returns the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @return The value of the field "TunerServer_StatusResponse"
     */
    inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerServer_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerServer_StatusResponse".
     */
    inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @param TunerServer_StatusResponse The value which will be set
     */
    inline void setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    static const FID_TUN_S_DEFAULT_SETTINGResult &getDefaultInstance();

private:

    inline void set_has_TunerServer_StatusResponse ();

    inline void clear_has_TunerServer_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_TunerServer_StatusResponse _TunerServer_StatusResponse;

};

/**
 * The start message of the method "FID_TUN_S_SET_DEMODULATION_SWITCH"
 * Method to set Demodulation switch for FM/AM/HD/DRM
 */
class FID_TUN_S_SET_DEMODULATION_SWITCHStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_SET_DEMODULATION_SWITCHStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_SET_DEMODULATION_SWITCHStart (const FID_TUN_S_SET_DEMODULATION_SWITCHStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_SET_DEMODULATION_SWITCHStart (const ::tuner_main_fi_types::T_b8_Tun_DemodSwitch& DemodulationSwitch_, const ::tuner_main_fi_types::T_b8_Tun_DemodSwitch& b8DemodulationSwitchMask_, const ::tuner_main_fi_types::T_b8_Tun_DemodSwitch& b8DemodulationSwitchValue_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_SET_DEMODULATION_SWITCHStart();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_SET_DEMODULATION_SWITCHStart& operator = (const FID_TUN_S_SET_DEMODULATION_SWITCHStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_SET_DEMODULATION_SWITCHStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_SET_DEMODULATION_SWITCHStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_SET_DEMODULATION_SWITCHStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_SET_DEMODULATION_SWITCHStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DemodulationSwitch"

    static const int kDemodulationSwitch = 0;

    /**
     * Clears the field "DemodulationSwitch".
     *
     * The field will be set to its default value. The hasDemodulationSwitch()
     * method will return false.
     */
    inline void clearDemodulationSwitch();

    /**
     * Checks whether the field "DemodulationSwitch" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDemodulationSwitch()). Otherwise it will return false.
     */
    inline bool hasDemodulationSwitch () const;

    /**
     * Returns the value of the member "DemodulationSwitch".
     *
     * Do not use this parameter, use below two mask and value parameter
     * Will be removed in coming releases
     *
     * @return The value of the field "DemodulationSwitch"
     */
    inline const ::tuner_main_fi_types::T_b8_Tun_DemodSwitch& getDemodulationSwitch () const;

    /**
     * Retrieves the value of the field "DemodulationSwitch" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DemodulationSwitch".
     */
    inline ::tuner_main_fi_types::T_b8_Tun_DemodSwitch& getDemodulationSwitchMutable ();

    /**
     * Sets the value of the member "DemodulationSwitch".
     *
     * Do not use this parameter, use below two mask and value parameter
     * Will be removed in coming releases
     *
     * @param DemodulationSwitch The value which will be set
     */
    inline void setDemodulationSwitch (const ::tuner_main_fi_types::T_b8_Tun_DemodSwitch& DemodulationSwitch_);

    // API of field "b8DemodulationSwitchMask"

    static const int kB8DemodulationSwitchMask = 1;

    /**
     * Clears the field "b8DemodulationSwitchMask".
     *
     * The field will be set to its default value. The hasB8DemodulationSwitchMask()
     * method will return false.
     */
    inline void clearB8DemodulationSwitchMask();

    /**
     * Checks whether the field "b8DemodulationSwitchMask" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setB8DemodulationSwitchMask()). Otherwise it will return false.
     */
    inline bool hasB8DemodulationSwitchMask () const;

    /**
     * Returns the value of the member "b8DemodulationSwitchMask".
     *
     * .
     *
     * @return The value of the field "b8DemodulationSwitchMask"
     */
    inline const ::tuner_main_fi_types::T_b8_Tun_DemodSwitch& getB8DemodulationSwitchMask () const;

    /**
     * Retrieves the value of the field "b8DemodulationSwitchMask" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "b8DemodulationSwitchMask".
     */
    inline ::tuner_main_fi_types::T_b8_Tun_DemodSwitch& getB8DemodulationSwitchMaskMutable ();

    /**
     * Sets the value of the member "b8DemodulationSwitchMask".
     *
     * .
     *
     * @param b8DemodulationSwitchMask The value which will be set
     */
    inline void setB8DemodulationSwitchMask (const ::tuner_main_fi_types::T_b8_Tun_DemodSwitch& b8DemodulationSwitchMask_);

    // API of field "b8DemodulationSwitchValue"

    static const int kB8DemodulationSwitchValue = 2;

    /**
     * Clears the field "b8DemodulationSwitchValue".
     *
     * The field will be set to its default value. The hasB8DemodulationSwitchValue()
     * method will return false.
     */
    inline void clearB8DemodulationSwitchValue();

    /**
     * Checks whether the field "b8DemodulationSwitchValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setB8DemodulationSwitchValue()). Otherwise it will return false.
     */
    inline bool hasB8DemodulationSwitchValue () const;

    /**
     * Returns the value of the member "b8DemodulationSwitchValue".
     *
     * .
     *
     * @return The value of the field "b8DemodulationSwitchValue"
     */
    inline const ::tuner_main_fi_types::T_b8_Tun_DemodSwitch& getB8DemodulationSwitchValue () const;

    /**
     * Retrieves the value of the field "b8DemodulationSwitchValue" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "b8DemodulationSwitchValue".
     */
    inline ::tuner_main_fi_types::T_b8_Tun_DemodSwitch& getB8DemodulationSwitchValueMutable ();

    /**
     * Sets the value of the member "b8DemodulationSwitchValue".
     *
     * .
     *
     * @param b8DemodulationSwitchValue The value which will be set
     */
    inline void setB8DemodulationSwitchValue (const ::tuner_main_fi_types::T_b8_Tun_DemodSwitch& b8DemodulationSwitchValue_);

    static const FID_TUN_S_SET_DEMODULATION_SWITCHStart &getDefaultInstance();

private:

    inline void set_has_DemodulationSwitch ();

    inline void clear_has_DemodulationSwitch ();

    inline void set_has_b8DemodulationSwitchMask ();

    inline void clear_has_b8DemodulationSwitchMask ();

    inline void set_has_b8DemodulationSwitchValue ();

    inline void clear_has_b8DemodulationSwitchValue ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::tuner_main_fi_types::T_b8_Tun_DemodSwitch _DemodulationSwitch;

    ::tuner_main_fi_types::T_b8_Tun_DemodSwitch _b8DemodulationSwitchMask;

    ::tuner_main_fi_types::T_b8_Tun_DemodSwitch _b8DemodulationSwitchValue;

};

/**
 * The result message of the method "FID_TUN_S_SET_DEMODULATION_SWITCH"
 * Method to set Demodulation switch for FM/AM/HD/DRM
 * .
 */
class FID_TUN_S_SET_DEMODULATION_SWITCHResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_SET_DEMODULATION_SWITCHResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_SET_DEMODULATION_SWITCHResult (const FID_TUN_S_SET_DEMODULATION_SWITCHResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_SET_DEMODULATION_SWITCHResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_SET_DEMODULATION_SWITCHResult();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_SET_DEMODULATION_SWITCHResult& operator = (const FID_TUN_S_SET_DEMODULATION_SWITCHResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_SET_DEMODULATION_SWITCHResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_SET_DEMODULATION_SWITCHResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_SET_DEMODULATION_SWITCHResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_SET_DEMODULATION_SWITCHResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerServer_StatusResponse"

    static const int kTunerServer_StatusResponse = 0;

    /**
     * Clears the field "TunerServer_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerServer_StatusResponse()
     * method will return false.
     */
    inline void clearTunerServer_StatusResponse();

    /**
     * Checks whether the field "TunerServer_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerServer_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerServer_StatusResponse () const;

    /**
     * Returns the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @return The value of the field "TunerServer_StatusResponse"
     */
    inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerServer_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerServer_StatusResponse".
     */
    inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @param TunerServer_StatusResponse The value which will be set
     */
    inline void setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    static const FID_TUN_S_SET_DEMODULATION_SWITCHResult &getDefaultInstance();

private:

    inline void set_has_TunerServer_StatusResponse ();

    inline void clear_has_TunerServer_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_TunerServer_StatusResponse _TunerServer_StatusResponse;

};

/**
 * The start message of the method "FID_TUN_S_SELECT_DRM_AUDIOPRGM"
 * Method to select DRM audio program by absolutely for by frequency or DRM Service ID.
 */
class FID_TUN_S_SELECT_DRM_AUDIOPRGMStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_SELECT_DRM_AUDIOPRGMStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_SELECT_DRM_AUDIOPRGMStart (const FID_TUN_S_SELECT_DRM_AUDIOPRGMStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_SELECT_DRM_AUDIOPRGMStart (uint32 u32Frequency_, uint32 u32DRMServiceId_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_SELECT_DRM_AUDIOPRGMStart();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_SELECT_DRM_AUDIOPRGMStart& operator = (const FID_TUN_S_SELECT_DRM_AUDIOPRGMStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_SELECT_DRM_AUDIOPRGMStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_SELECT_DRM_AUDIOPRGMStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_SELECT_DRM_AUDIOPRGMStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_SELECT_DRM_AUDIOPRGMStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32Frequency"

    static const int kU32Frequency = 0;

    /**
     * Clears the field "u32Frequency".
     *
     * The field will be set to its default value. The hasU32Frequency()
     * method will return false.
     */
    inline void clearU32Frequency();

    /**
     * Checks whether the field "u32Frequency" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Frequency()). Otherwise it will return false.
     */
    inline bool hasU32Frequency () const;

    /**
     * Returns the value of the member "u32Frequency".
     *
     * Frequency used by ADR3 to tuned to DRM station
     *
     * @return The value of the field "u32Frequency"
     */
    inline uint32 getU32Frequency () const;

    /**
     * Sets the value of the member "u32Frequency".
     *
     * Frequency used by ADR3 to tuned to DRM station
     *
     * @param u32Frequency The value which will be set
     */
    inline void setU32Frequency (uint32 u32Frequency_);

    // API of field "u32DRMServiceId"

    static const int kU32DRMServiceId = 1;

    /**
     * Clears the field "u32DRMServiceId".
     *
     * The field will be set to its default value. The hasU32DRMServiceId()
     * method will return false.
     */
    inline void clearU32DRMServiceId();

    /**
     * Checks whether the field "u32DRMServiceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32DRMServiceId()). Otherwise it will return false.
     */
    inline bool hasU32DRMServiceId () const;

    /**
     * Returns the value of the member "u32DRMServiceId".
     *
     * DRMServiceId by ADR3 to tuned to DRM station
     *
     * @return The value of the field "u32DRMServiceId"
     */
    inline uint32 getU32DRMServiceId () const;

    /**
     * Sets the value of the member "u32DRMServiceId".
     *
     * DRMServiceId by ADR3 to tuned to DRM station
     *
     * @param u32DRMServiceId The value which will be set
     */
    inline void setU32DRMServiceId (uint32 u32DRMServiceId_);

    static const FID_TUN_S_SELECT_DRM_AUDIOPRGMStart &getDefaultInstance();

private:

    inline void set_has_u32Frequency ();

    inline void clear_has_u32Frequency ();

    inline void set_has_u32DRMServiceId ();

    inline void clear_has_u32DRMServiceId ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _u32Frequency;

    uint32 _u32DRMServiceId;

};

/**
 * The result message of the method "FID_TUN_S_SELECT_DRM_AUDIOPRGM"
 * Method to select DRM audio program by absolutely for by frequency or DRM Service ID.
 */
class FID_TUN_S_SELECT_DRM_AUDIOPRGMResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_SELECT_DRM_AUDIOPRGMResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_SELECT_DRM_AUDIOPRGMResult (const FID_TUN_S_SELECT_DRM_AUDIOPRGMResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_SELECT_DRM_AUDIOPRGMResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_SELECT_DRM_AUDIOPRGMResult();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_SELECT_DRM_AUDIOPRGMResult& operator = (const FID_TUN_S_SELECT_DRM_AUDIOPRGMResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_SELECT_DRM_AUDIOPRGMResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_SELECT_DRM_AUDIOPRGMResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_SELECT_DRM_AUDIOPRGMResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_SELECT_DRM_AUDIOPRGMResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerServer_StatusResponse"

    static const int kTunerServer_StatusResponse = 0;

    /**
     * Clears the field "TunerServer_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerServer_StatusResponse()
     * method will return false.
     */
    inline void clearTunerServer_StatusResponse();

    /**
     * Checks whether the field "TunerServer_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerServer_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerServer_StatusResponse () const;

    /**
     * Returns the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @return The value of the field "TunerServer_StatusResponse"
     */
    inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerServer_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerServer_StatusResponse".
     */
    inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @param TunerServer_StatusResponse The value which will be set
     */
    inline void setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    static const FID_TUN_S_SELECT_DRM_AUDIOPRGMResult &getDefaultInstance();

private:

    inline void set_has_TunerServer_StatusResponse ();

    inline void clear_has_TunerServer_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_TunerServer_StatusResponse _TunerServer_StatusResponse;

};

/**
 * The start message of the method "FID_TUN_S_AUDIO_DEVICE"
 * Method to set the Audio sink name for DRM  source
 */
class FID_TUN_S_AUDIO_DEVICEStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_AUDIO_DEVICEStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_AUDIO_DEVICEStart (const FID_TUN_S_AUDIO_DEVICEStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_AUDIO_DEVICEStart (const ::std::string& sDRMAudioSinkName_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_AUDIO_DEVICEStart();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_AUDIO_DEVICEStart& operator = (const FID_TUN_S_AUDIO_DEVICEStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_AUDIO_DEVICEStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_AUDIO_DEVICEStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_AUDIO_DEVICEStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_AUDIO_DEVICEStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sDRMAudioSinkName"

    static const int kSDRMAudioSinkName = 0;

    /**
     * Clears the field "sDRMAudioSinkName".
     *
     * The field will be set to its default value. The hasSDRMAudioSinkName()
     * method will return false.
     */
    inline void clearSDRMAudioSinkName();

    /**
     * Checks whether the field "sDRMAudioSinkName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDRMAudioSinkName()). Otherwise it will return false.
     */
    inline bool hasSDRMAudioSinkName () const;

    /**
     * Returns the value of the member "sDRMAudioSinkName".
     *
     * If the meaning of "sDRMAudioSinkName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sDRMAudioSinkName"
     */
    inline const ::std::string& getSDRMAudioSinkName () const;

    /**
     * Retrieves the value of the field "sDRMAudioSinkName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDRMAudioSinkName".
     */
    inline ::std::string& getSDRMAudioSinkNameMutable ();

    /**
     * Sets the value of the member "sDRMAudioSinkName".
     *
     * If the meaning of "sDRMAudioSinkName" isn't clear, then there should be a description here.
     *
     * @param sDRMAudioSinkName The value which will be set
     */
    inline void setSDRMAudioSinkName (const ::std::string& sDRMAudioSinkName_);

    /**
     * Sets the value of the member "sDRMAudioSinkName".
     *
     * If the meaning of "sDRMAudioSinkName" isn't clear, then there should be a description here.
     *
     * @param sDRMAudioSinkName The value which will be set
     */
    inline void setSDRMAudioSinkName (const char* sDRMAudioSinkName_);

    /**
     * Sets the value of the member "sDRMAudioSinkName".
     *
     * If the meaning of "sDRMAudioSinkName" isn't clear, then there should be a description here.
     *
     * @param sDRMAudioSinkName The value which will be set
     */
    inline void setSDRMAudioSinkName (const char* value, size_t size);

    static const FID_TUN_S_AUDIO_DEVICEStart &getDefaultInstance();

private:

    inline void set_has_sDRMAudioSinkName ();

    inline void clear_has_sDRMAudioSinkName ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _sDRMAudioSinkName;

};

/**
 * The result message of the method "FID_TUN_S_AUDIO_DEVICE"
 * Method to set the Audio sink name for DRM  source
 */
class FID_TUN_S_AUDIO_DEVICEResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_AUDIO_DEVICEResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_AUDIO_DEVICEResult (const FID_TUN_S_AUDIO_DEVICEResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_AUDIO_DEVICEResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_AUDIO_DEVICEResult();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_AUDIO_DEVICEResult& operator = (const FID_TUN_S_AUDIO_DEVICEResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_AUDIO_DEVICEResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_AUDIO_DEVICEResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_AUDIO_DEVICEResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_AUDIO_DEVICEResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerServer_StatusResponse"

    static const int kTunerServer_StatusResponse = 0;

    /**
     * Clears the field "TunerServer_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerServer_StatusResponse()
     * method will return false.
     */
    inline void clearTunerServer_StatusResponse();

    /**
     * Checks whether the field "TunerServer_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerServer_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerServer_StatusResponse () const;

    /**
     * Returns the value of the member "TunerServer_StatusResponse".
     *
     * If the meaning of "TunerServer_StatusResponse" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TunerServer_StatusResponse"
     */
    inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerServer_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerServer_StatusResponse".
     */
    inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerServer_StatusResponse".
     *
     * If the meaning of "TunerServer_StatusResponse" isn't clear, then there should be a description here.
     *
     * @param TunerServer_StatusResponse The value which will be set
     */
    inline void setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    static const FID_TUN_S_AUDIO_DEVICEResult &getDefaultInstance();

private:

    inline void set_has_TunerServer_StatusResponse ();

    inline void clear_has_TunerServer_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_TunerServer_StatusResponse _TunerServer_StatusResponse;

};

/**
 * The start message of the method "FID_TUN_S_SET_DRM_SRCACTIVITY"
 * Method to request Source Activity of DRM source
 */
class FID_TUN_S_SET_DRM_SRCACTIVITYStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_SET_DRM_SRCACTIVITYStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_SET_DRM_SRCACTIVITYStart (const FID_TUN_S_SET_DRM_SRCACTIVITYStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_SET_DRM_SRCACTIVITYStart (::tuner_main_fi_types::T_e8_Tun_DRMSourceActivity e8DRMSourceActivity_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_SET_DRM_SRCACTIVITYStart();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_SET_DRM_SRCACTIVITYStart& operator = (const FID_TUN_S_SET_DRM_SRCACTIVITYStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_SET_DRM_SRCACTIVITYStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_SET_DRM_SRCACTIVITYStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_SET_DRM_SRCACTIVITYStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_SET_DRM_SRCACTIVITYStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8DRMSourceActivity"

    static const int kE8DRMSourceActivity = 0;

    /**
     * Clears the field "e8DRMSourceActivity".
     *
     * The field will be set to its default value. The hasE8DRMSourceActivity()
     * method will return false.
     */
    inline void clearE8DRMSourceActivity();

    /**
     * Checks whether the field "e8DRMSourceActivity" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DRMSourceActivity()). Otherwise it will return false.
     */
    inline bool hasE8DRMSourceActivity () const;

    /**
     * Returns the value of the member "e8DRMSourceActivity".
     *
     * If the meaning of "e8DRMSourceActivity" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8DRMSourceActivity"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_DRMSourceActivity getE8DRMSourceActivity () const;

    /**
     * Sets the value of the member "e8DRMSourceActivity".
     *
     * If the meaning of "e8DRMSourceActivity" isn't clear, then there should be a description here.
     *
     * @param e8DRMSourceActivity The value which will be set
     */
    inline void setE8DRMSourceActivity (::tuner_main_fi_types::T_e8_Tun_DRMSourceActivity e8DRMSourceActivity_);

    static const FID_TUN_S_SET_DRM_SRCACTIVITYStart &getDefaultInstance();

private:

    inline void set_has_e8DRMSourceActivity ();

    inline void clear_has_e8DRMSourceActivity ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_e8_Tun_DRMSourceActivity _e8DRMSourceActivity;

};

/**
 * The result message of the method "FID_TUN_S_SET_DRM_SRCACTIVITY"
 * Method to request Source Activity of DRM source
 */
class FID_TUN_S_SET_DRM_SRCACTIVITYResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_SET_DRM_SRCACTIVITYResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_SET_DRM_SRCACTIVITYResult (const FID_TUN_S_SET_DRM_SRCACTIVITYResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_SET_DRM_SRCACTIVITYResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_SET_DRM_SRCACTIVITYResult();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_SET_DRM_SRCACTIVITYResult& operator = (const FID_TUN_S_SET_DRM_SRCACTIVITYResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_SET_DRM_SRCACTIVITYResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_SET_DRM_SRCACTIVITYResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_SET_DRM_SRCACTIVITYResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_SET_DRM_SRCACTIVITYResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerServer_StatusResponse"

    static const int kTunerServer_StatusResponse = 0;

    /**
     * Clears the field "TunerServer_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerServer_StatusResponse()
     * method will return false.
     */
    inline void clearTunerServer_StatusResponse();

    /**
     * Checks whether the field "TunerServer_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerServer_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerServer_StatusResponse () const;

    /**
     * Returns the value of the member "TunerServer_StatusResponse".
     *
     * If the meaning of "TunerServer_StatusResponse" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TunerServer_StatusResponse"
     */
    inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerServer_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerServer_StatusResponse".
     */
    inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerServer_StatusResponse".
     *
     * If the meaning of "TunerServer_StatusResponse" isn't clear, then there should be a description here.
     *
     * @param TunerServer_StatusResponse The value which will be set
     */
    inline void setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    static const FID_TUN_S_SET_DRM_SRCACTIVITYResult &getDefaultInstance();

private:

    inline void set_has_TunerServer_StatusResponse ();

    inline void clear_has_TunerServer_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_TunerServer_StatusResponse _TunerServer_StatusResponse;

};

/**
 * The start message of the method "FID_TUN_S_SET_TESTMODE"
 * This provides several data items for each available physical tuner
 */
class FID_TUN_S_SET_TESTMODEStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_SET_TESTMODEStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_SET_TESTMODEStart (const FID_TUN_S_SET_TESTMODEStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_SET_TESTMODEStart (::tuner_main_fi_types::T_e8_Tun_TestModeSource e8TestModeSource_, ::tuner_main_fi_types::T_e8_Tun_TestModeActivity e8TestModeActivity_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_SET_TESTMODEStart();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_SET_TESTMODEStart& operator = (const FID_TUN_S_SET_TESTMODEStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_SET_TESTMODEStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_SET_TESTMODEStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_SET_TESTMODEStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_SET_TESTMODEStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8TestModeSource"

    static const int kE8TestModeSource = 0;

    /**
     * Clears the field "e8TestModeSource".
     *
     * The field will be set to its default value. The hasE8TestModeSource()
     * method will return false.
     */
    inline void clearE8TestModeSource();

    /**
     * Checks whether the field "e8TestModeSource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8TestModeSource()). Otherwise it will return false.
     */
    inline bool hasE8TestModeSource () const;

    /**
     * Returns the value of the member "e8TestModeSource".
     *
     * Select the source of testmode
     *
     * @return The value of the field "e8TestModeSource"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_TestModeSource getE8TestModeSource () const;

    /**
     * Sets the value of the member "e8TestModeSource".
     *
     * Select the source of testmode
     *
     * @param e8TestModeSource The value which will be set
     */
    inline void setE8TestModeSource (::tuner_main_fi_types::T_e8_Tun_TestModeSource e8TestModeSource_);

    // API of field "e8TestModeActivity"

    static const int kE8TestModeActivity = 1;

    /**
     * Clears the field "e8TestModeActivity".
     *
     * The field will be set to its default value. The hasE8TestModeActivity()
     * method will return false.
     */
    inline void clearE8TestModeActivity();

    /**
     * Checks whether the field "e8TestModeActivity" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8TestModeActivity()). Otherwise it will return false.
     */
    inline bool hasE8TestModeActivity () const;

    /**
     * Returns the value of the member "e8TestModeActivity".
     *
     * Select the test mode type ON/OFF/AudioTunerOnly
     *
     * @return The value of the field "e8TestModeActivity"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_TestModeActivity getE8TestModeActivity () const;

    /**
     * Sets the value of the member "e8TestModeActivity".
     *
     * Select the test mode type ON/OFF/AudioTunerOnly
     *
     * @param e8TestModeActivity The value which will be set
     */
    inline void setE8TestModeActivity (::tuner_main_fi_types::T_e8_Tun_TestModeActivity e8TestModeActivity_);

    static const FID_TUN_S_SET_TESTMODEStart &getDefaultInstance();

private:

    inline void set_has_e8TestModeSource ();

    inline void clear_has_e8TestModeSource ();

    inline void set_has_e8TestModeActivity ();

    inline void clear_has_e8TestModeActivity ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::tuner_main_fi_types::T_e8_Tun_TestModeSource _e8TestModeSource;

    ::tuner_main_fi_types::T_e8_Tun_TestModeActivity _e8TestModeActivity;

};

/**
 * The result message of the method "FID_TUN_S_SET_TESTMODE"
 * This provides several data items for each available physical tuner
 * .
 */
class FID_TUN_S_SET_TESTMODEResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_SET_TESTMODEResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_SET_TESTMODEResult (const FID_TUN_S_SET_TESTMODEResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_SET_TESTMODEResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_SET_TESTMODEResult();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_SET_TESTMODEResult& operator = (const FID_TUN_S_SET_TESTMODEResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_SET_TESTMODEResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_SET_TESTMODEResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_SET_TESTMODEResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_SET_TESTMODEResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerServer_StatusResponse"

    static const int kTunerServer_StatusResponse = 0;

    /**
     * Clears the field "TunerServer_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerServer_StatusResponse()
     * method will return false.
     */
    inline void clearTunerServer_StatusResponse();

    /**
     * Checks whether the field "TunerServer_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerServer_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerServer_StatusResponse () const;

    /**
     * Returns the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @return The value of the field "TunerServer_StatusResponse"
     */
    inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerServer_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerServer_StatusResponse".
     */
    inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @param TunerServer_StatusResponse The value which will be set
     */
    inline void setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    static const FID_TUN_S_SET_TESTMODEResult &getDefaultInstance();

private:

    inline void set_has_TunerServer_StatusResponse ();

    inline void clear_has_TunerServer_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_TunerServer_StatusResponse _TunerServer_StatusResponse;

};

/**
 * The start message of the method "FID_TUN_S_SELECT_HD_AUDIOPRGM"
 * Method to select HD audio program absolutely or relatively
 */
class FID_TUN_S_SELECT_HD_AUDIOPRGMStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_SELECT_HD_AUDIOPRGMStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_SELECT_HD_AUDIOPRGMStart (const FID_TUN_S_SELECT_HD_AUDIOPRGMStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_SELECT_HD_AUDIOPRGMStart (::tuner_main_fi_types::T_e8_Tun_SelectMode SelectMode_, ::tuner_main_fi_types::T_e8_Tun_HDAudioProgram e8HDAudioPrg_, ::tuner_main_fi_types::T_e8_Tun_RelativeDirection e8Direction_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_SELECT_HD_AUDIOPRGMStart();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_SELECT_HD_AUDIOPRGMStart& operator = (const FID_TUN_S_SELECT_HD_AUDIOPRGMStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_SELECT_HD_AUDIOPRGMStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_SELECT_HD_AUDIOPRGMStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_SELECT_HD_AUDIOPRGMStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_SELECT_HD_AUDIOPRGMStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SelectMode"

    static const int kSelectMode = 0;

    /**
     * Clears the field "SelectMode".
     *
     * The field will be set to its default value. The hasSelectMode()
     * method will return false.
     */
    inline void clearSelectMode();

    /**
     * Checks whether the field "SelectMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSelectMode()). Otherwise it will return false.
     */
    inline bool hasSelectMode () const;

    /**
     * Returns the value of the member "SelectMode".
     *
     * Indicates if the HD Audio program needs to be selected absolutely or relatively
     *
     * @return The value of the field "SelectMode"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_SelectMode getSelectMode () const;

    /**
     * Sets the value of the member "SelectMode".
     *
     * Indicates if the HD Audio program needs to be selected absolutely or relatively
     *
     * @param SelectMode The value which will be set
     */
    inline void setSelectMode (::tuner_main_fi_types::T_e8_Tun_SelectMode SelectMode_);

    // API of field "e8HDAudioPrg"

    static const int kE8HDAudioPrg = 1;

    /**
     * Clears the field "e8HDAudioPrg".
     *
     * The field will be set to its default value. The hasE8HDAudioPrg()
     * method will return false.
     */
    inline void clearE8HDAudioPrg();

    /**
     * Checks whether the field "e8HDAudioPrg" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8HDAudioPrg()). Otherwise it will return false.
     */
    inline bool hasE8HDAudioPrg () const;

    /**
     * Returns the value of the member "e8HDAudioPrg".
     *
     * This parameter is considered if SelectMode is set to Absolute (SelectMode=0)
     *
     * @return The value of the field "e8HDAudioPrg"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_HDAudioProgram getE8HDAudioPrg () const;

    /**
     * Sets the value of the member "e8HDAudioPrg".
     *
     * This parameter is considered if SelectMode is set to Absolute (SelectMode=0)
     *
     * @param e8HDAudioPrg The value which will be set
     */
    inline void setE8HDAudioPrg (::tuner_main_fi_types::T_e8_Tun_HDAudioProgram e8HDAudioPrg_);

    // API of field "e8Direction"

    static const int kE8Direction = 2;

    /**
     * Clears the field "e8Direction".
     *
     * The field will be set to its default value. The hasE8Direction()
     * method will return false.
     */
    inline void clearE8Direction();

    /**
     * Checks whether the field "e8Direction" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Direction()). Otherwise it will return false.
     */
    inline bool hasE8Direction () const;

    /**
     * Returns the value of the member "e8Direction".
     *
     * This parameter is considered if SelectMode is set to Relative (SelectMode=1)
     * FALSE- Decrement : Tunes to HD audio program one less than the current playing audio program
     * TRUE- Increment : Tunes to a HD Audio program one greater than the current playing audio program
     *
     * @return The value of the field "e8Direction"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_RelativeDirection getE8Direction () const;

    /**
     * Sets the value of the member "e8Direction".
     *
     * This parameter is considered if SelectMode is set to Relative (SelectMode=1)
     * FALSE- Decrement : Tunes to HD audio program one less than the current playing audio program
     * TRUE- Increment : Tunes to a HD Audio program one greater than the current playing audio program
     *
     * @param e8Direction The value which will be set
     */
    inline void setE8Direction (::tuner_main_fi_types::T_e8_Tun_RelativeDirection e8Direction_);

    static const FID_TUN_S_SELECT_HD_AUDIOPRGMStart &getDefaultInstance();

private:

    inline void set_has_SelectMode ();

    inline void clear_has_SelectMode ();

    inline void set_has_e8HDAudioPrg ();

    inline void clear_has_e8HDAudioPrg ();

    inline void set_has_e8Direction ();

    inline void clear_has_e8Direction ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::tuner_main_fi_types::T_e8_Tun_SelectMode _SelectMode;

    ::tuner_main_fi_types::T_e8_Tun_HDAudioProgram _e8HDAudioPrg;

    ::tuner_main_fi_types::T_e8_Tun_RelativeDirection _e8Direction;

};

/**
 * The result message of the method "FID_TUN_S_SELECT_HD_AUDIOPRGM"
 * Method to select HD audio program absolutely or relatively
 * .
 */
class FID_TUN_S_SELECT_HD_AUDIOPRGMResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_SELECT_HD_AUDIOPRGMResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_SELECT_HD_AUDIOPRGMResult (const FID_TUN_S_SELECT_HD_AUDIOPRGMResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_SELECT_HD_AUDIOPRGMResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_SELECT_HD_AUDIOPRGMResult();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_SELECT_HD_AUDIOPRGMResult& operator = (const FID_TUN_S_SELECT_HD_AUDIOPRGMResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_SELECT_HD_AUDIOPRGMResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_SELECT_HD_AUDIOPRGMResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_SELECT_HD_AUDIOPRGMResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_SELECT_HD_AUDIOPRGMResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerServer_StatusResponse"

    static const int kTunerServer_StatusResponse = 0;

    /**
     * Clears the field "TunerServer_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerServer_StatusResponse()
     * method will return false.
     */
    inline void clearTunerServer_StatusResponse();

    /**
     * Checks whether the field "TunerServer_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerServer_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerServer_StatusResponse () const;

    /**
     * Returns the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @return The value of the field "TunerServer_StatusResponse"
     */
    inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerServer_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerServer_StatusResponse".
     */
    inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @param TunerServer_StatusResponse The value which will be set
     */
    inline void setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    static const FID_TUN_S_SELECT_HD_AUDIOPRGMResult &getDefaultInstance();

private:

    inline void set_has_TunerServer_StatusResponse ();

    inline void clear_has_TunerServer_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_TunerServer_StatusResponse _TunerServer_StatusResponse;

};

/**
 * The start message of the method "FID_TUN_S_SEL_HD_AUDIOPRGMDIRECT"
 * Method to select a HD audio program of a different frequency absolutely from the current tuned one.
 */
class FID_TUN_S_SEL_HD_AUDIOPRGMDIRECTStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_SEL_HD_AUDIOPRGMDIRECTStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_SEL_HD_AUDIOPRGMDIRECTStart (const FID_TUN_S_SEL_HD_AUDIOPRGMDIRECTStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_SEL_HD_AUDIOPRGMDIRECTStart (uint32 u32Frequency_, ::tuner_main_fi_types::T_e8_Tun_HDAudioProgram e8HDAudioPrg_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_SEL_HD_AUDIOPRGMDIRECTStart();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_SEL_HD_AUDIOPRGMDIRECTStart& operator = (const FID_TUN_S_SEL_HD_AUDIOPRGMDIRECTStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_SEL_HD_AUDIOPRGMDIRECTStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_SEL_HD_AUDIOPRGMDIRECTStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_SEL_HD_AUDIOPRGMDIRECTStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_SEL_HD_AUDIOPRGMDIRECTStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32Frequency"

    static const int kU32Frequency = 0;

    /**
     * Clears the field "u32Frequency".
     *
     * The field will be set to its default value. The hasU32Frequency()
     * method will return false.
     */
    inline void clearU32Frequency();

    /**
     * Checks whether the field "u32Frequency" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Frequency()). Otherwise it will return false.
     */
    inline bool hasU32Frequency () const;

    /**
     * Returns the value of the member "u32Frequency".
     *
     * This parameter indicates the frequency of the Audio program
     *
     * @return The value of the field "u32Frequency"
     */
    inline uint32 getU32Frequency () const;

    /**
     * Sets the value of the member "u32Frequency".
     *
     * This parameter indicates the frequency of the Audio program
     *
     * @param u32Frequency The value which will be set
     */
    inline void setU32Frequency (uint32 u32Frequency_);

    // API of field "e8HDAudioPrg"

    static const int kE8HDAudioPrg = 1;

    /**
     * Clears the field "e8HDAudioPrg".
     *
     * The field will be set to its default value. The hasE8HDAudioPrg()
     * method will return false.
     */
    inline void clearE8HDAudioPrg();

    /**
     * Checks whether the field "e8HDAudioPrg" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8HDAudioPrg()). Otherwise it will return false.
     */
    inline bool hasE8HDAudioPrg () const;

    /**
     * Returns the value of the member "e8HDAudioPrg".
     *
     * This parameter specifies the Audio program
     *
     * @return The value of the field "e8HDAudioPrg"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_HDAudioProgram getE8HDAudioPrg () const;

    /**
     * Sets the value of the member "e8HDAudioPrg".
     *
     * This parameter specifies the Audio program
     *
     * @param e8HDAudioPrg The value which will be set
     */
    inline void setE8HDAudioPrg (::tuner_main_fi_types::T_e8_Tun_HDAudioProgram e8HDAudioPrg_);

    static const FID_TUN_S_SEL_HD_AUDIOPRGMDIRECTStart &getDefaultInstance();

private:

    inline void set_has_u32Frequency ();

    inline void clear_has_u32Frequency ();

    inline void set_has_e8HDAudioPrg ();

    inline void clear_has_e8HDAudioPrg ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _u32Frequency;

    ::tuner_main_fi_types::T_e8_Tun_HDAudioProgram _e8HDAudioPrg;

};

/**
 * The result message of the method "FID_TUN_S_SEL_HD_AUDIOPRGMDIRECT"
 * Method to select a HD audio program of a different frequency absolutely from the current tuned one.
 * .
 */
class FID_TUN_S_SEL_HD_AUDIOPRGMDIRECTResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_SEL_HD_AUDIOPRGMDIRECTResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_SEL_HD_AUDIOPRGMDIRECTResult (const FID_TUN_S_SEL_HD_AUDIOPRGMDIRECTResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_SEL_HD_AUDIOPRGMDIRECTResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_SEL_HD_AUDIOPRGMDIRECTResult();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_SEL_HD_AUDIOPRGMDIRECTResult& operator = (const FID_TUN_S_SEL_HD_AUDIOPRGMDIRECTResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_SEL_HD_AUDIOPRGMDIRECTResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_SEL_HD_AUDIOPRGMDIRECTResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_SEL_HD_AUDIOPRGMDIRECTResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_SEL_HD_AUDIOPRGMDIRECTResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerServer_StatusResponse"

    static const int kTunerServer_StatusResponse = 0;

    /**
     * Clears the field "TunerServer_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerServer_StatusResponse()
     * method will return false.
     */
    inline void clearTunerServer_StatusResponse();

    /**
     * Checks whether the field "TunerServer_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerServer_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerServer_StatusResponse () const;

    /**
     * Returns the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @return The value of the field "TunerServer_StatusResponse"
     */
    inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerServer_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerServer_StatusResponse".
     */
    inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @param TunerServer_StatusResponse The value which will be set
     */
    inline void setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    static const FID_TUN_S_SEL_HD_AUDIOPRGMDIRECTResult &getDefaultInstance();

private:

    inline void set_has_TunerServer_StatusResponse ();

    inline void clear_has_TunerServer_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_TunerServer_StatusResponse _TunerServer_StatusResponse;

};

/**
 * The start message of the method "FID_TUN_S_SET_AUDIO_SPLIT_MODE"
 * This allows to activate/deactivate audio split mode.
 */
class FID_TUN_S_SET_AUDIO_SPLIT_MODEStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_SET_AUDIO_SPLIT_MODEStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_SET_AUDIO_SPLIT_MODEStart (const FID_TUN_S_SET_AUDIO_SPLIT_MODEStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_SET_AUDIO_SPLIT_MODEStart (::tuner_main_fi_types::T_e8_Tun_AudioSplitMode e8ParameterValue_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_SET_AUDIO_SPLIT_MODEStart();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_SET_AUDIO_SPLIT_MODEStart& operator = (const FID_TUN_S_SET_AUDIO_SPLIT_MODEStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_SET_AUDIO_SPLIT_MODEStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_SET_AUDIO_SPLIT_MODEStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_SET_AUDIO_SPLIT_MODEStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_SET_AUDIO_SPLIT_MODEStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ParameterValue"

    static const int kE8ParameterValue = 0;

    /**
     * Clears the field "e8ParameterValue".
     *
     * The field will be set to its default value. The hasE8ParameterValue()
     * method will return false.
     */
    inline void clearE8ParameterValue();

    /**
     * Checks whether the field "e8ParameterValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ParameterValue()). Otherwise it will return false.
     */
    inline bool hasE8ParameterValue () const;

    /**
     * Returns the value of the member "e8ParameterValue".
     *
     * The value is to be set to 1 to activate audio split mode.
     *
     * @return The value of the field "e8ParameterValue"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_AudioSplitMode getE8ParameterValue () const;

    /**
     * Sets the value of the member "e8ParameterValue".
     *
     * The value is to be set to 1 to activate audio split mode.
     *
     * @param e8ParameterValue The value which will be set
     */
    inline void setE8ParameterValue (::tuner_main_fi_types::T_e8_Tun_AudioSplitMode e8ParameterValue_);

    static const FID_TUN_S_SET_AUDIO_SPLIT_MODEStart &getDefaultInstance();

private:

    inline void set_has_e8ParameterValue ();

    inline void clear_has_e8ParameterValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_e8_Tun_AudioSplitMode _e8ParameterValue;

};

/**
 * The result message of the method "FID_TUN_S_SET_AUDIO_SPLIT_MODE"
 * This allows to activate/deactivate audio split mode.
 * This indicates whether method start was accepted or rejected.
 */
class FID_TUN_S_SET_AUDIO_SPLIT_MODEResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_SET_AUDIO_SPLIT_MODEResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_SET_AUDIO_SPLIT_MODEResult (const FID_TUN_S_SET_AUDIO_SPLIT_MODEResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_SET_AUDIO_SPLIT_MODEResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_SET_AUDIO_SPLIT_MODEResult();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_SET_AUDIO_SPLIT_MODEResult& operator = (const FID_TUN_S_SET_AUDIO_SPLIT_MODEResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_SET_AUDIO_SPLIT_MODEResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_SET_AUDIO_SPLIT_MODEResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_SET_AUDIO_SPLIT_MODEResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_SET_AUDIO_SPLIT_MODEResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerServer_StatusResponse"

    static const int kTunerServer_StatusResponse = 0;

    /**
     * Clears the field "TunerServer_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerServer_StatusResponse()
     * method will return false.
     */
    inline void clearTunerServer_StatusResponse();

    /**
     * Checks whether the field "TunerServer_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerServer_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerServer_StatusResponse () const;

    /**
     * Returns the value of the member "TunerServer_StatusResponse".
     *
     *
     *
     * @return The value of the field "TunerServer_StatusResponse"
     */
    inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerServer_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerServer_StatusResponse".
     */
    inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerServer_StatusResponse".
     *
     *
     *
     * @param TunerServer_StatusResponse The value which will be set
     */
    inline void setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    static const FID_TUN_S_SET_AUDIO_SPLIT_MODEResult &getDefaultInstance();

private:

    inline void set_has_TunerServer_StatusResponse ();

    inline void clear_has_TunerServer_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_TunerServer_StatusResponse _TunerServer_StatusResponse;

};

/**
 * The start message of the method "FID_TUN_S_SET_HD_SECTION_PARAMETER"
 * This method allows to change HD Section parameters
 */
class FID_TUN_S_SET_HD_SECTION_PARAMETERStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_SET_HD_SECTION_PARAMETERStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_SET_HD_SECTION_PARAMETERStart (const FID_TUN_S_SET_HD_SECTION_PARAMETERStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_SET_HD_SECTION_PARAMETERStart (::tuner_main_fi_types::T_e16_Tun_ParameterID e16Parameter_ID_, int8 s8ParameterValue_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_SET_HD_SECTION_PARAMETERStart();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_SET_HD_SECTION_PARAMETERStart& operator = (const FID_TUN_S_SET_HD_SECTION_PARAMETERStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_SET_HD_SECTION_PARAMETERStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_SET_HD_SECTION_PARAMETERStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_SET_HD_SECTION_PARAMETERStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_SET_HD_SECTION_PARAMETERStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e16Parameter_ID"

    static const int kE16Parameter_ID = 0;

    /**
     * Clears the field "e16Parameter_ID".
     *
     * The field will be set to its default value. The hasE16Parameter_ID()
     * method will return false.
     */
    inline void clearE16Parameter_ID();

    /**
     * Checks whether the field "e16Parameter_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE16Parameter_ID()). Otherwise it will return false.
     */
    inline bool hasE16Parameter_ID () const;

    /**
     * Returns the value of the member "e16Parameter_ID".
     *
     * .
     *
     * @return The value of the field "e16Parameter_ID"
     */
    inline ::tuner_main_fi_types::T_e16_Tun_ParameterID getE16Parameter_ID () const;

    /**
     * Sets the value of the member "e16Parameter_ID".
     *
     * .
     *
     * @param e16Parameter_ID The value which will be set
     */
    inline void setE16Parameter_ID (::tuner_main_fi_types::T_e16_Tun_ParameterID e16Parameter_ID_);

    // API of field "s8ParameterValue"

    static const int kS8ParameterValue = 1;

    /**
     * Clears the field "s8ParameterValue".
     *
     * The field will be set to its default value. The hasS8ParameterValue()
     * method will return false.
     */
    inline void clearS8ParameterValue();

    /**
     * Checks whether the field "s8ParameterValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS8ParameterValue()). Otherwise it will return false.
     */
    inline bool hasS8ParameterValue () const;

    /**
     * Returns the value of the member "s8ParameterValue".
     *
     * .
     *
     * @return The value of the field "s8ParameterValue"
     */
    inline int8 getS8ParameterValue () const;

    /**
     * Sets the value of the member "s8ParameterValue".
     *
     * .
     *
     * @param s8ParameterValue The value which will be set
     */
    inline void setS8ParameterValue (int8 s8ParameterValue_);

    static const FID_TUN_S_SET_HD_SECTION_PARAMETERStart &getDefaultInstance();

private:

    inline void set_has_e16Parameter_ID ();

    inline void clear_has_e16Parameter_ID ();

    inline void set_has_s8ParameterValue ();

    inline void clear_has_s8ParameterValue ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::tuner_main_fi_types::T_e16_Tun_ParameterID _e16Parameter_ID;

    int8 _s8ParameterValue;

};

/**
 * The result message of the method "FID_TUN_S_SET_HD_SECTION_PARAMETER"
 * This method allows to change HD Section parameters
 * This indicates whether method start was accepted or rejected.
 */
class FID_TUN_S_SET_HD_SECTION_PARAMETERResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_SET_HD_SECTION_PARAMETERResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_SET_HD_SECTION_PARAMETERResult (const FID_TUN_S_SET_HD_SECTION_PARAMETERResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_SET_HD_SECTION_PARAMETERResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_SET_HD_SECTION_PARAMETERResult();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_SET_HD_SECTION_PARAMETERResult& operator = (const FID_TUN_S_SET_HD_SECTION_PARAMETERResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_SET_HD_SECTION_PARAMETERResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_SET_HD_SECTION_PARAMETERResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_SET_HD_SECTION_PARAMETERResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_SET_HD_SECTION_PARAMETERResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerServer_StatusResponse"

    static const int kTunerServer_StatusResponse = 0;

    /**
     * Clears the field "TunerServer_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerServer_StatusResponse()
     * method will return false.
     */
    inline void clearTunerServer_StatusResponse();

    /**
     * Checks whether the field "TunerServer_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerServer_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerServer_StatusResponse () const;

    /**
     * Returns the value of the member "TunerServer_StatusResponse".
     *
     *
     *
     * @return The value of the field "TunerServer_StatusResponse"
     */
    inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerServer_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerServer_StatusResponse".
     */
    inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerServer_StatusResponse".
     *
     *
     *
     * @param TunerServer_StatusResponse The value which will be set
     */
    inline void setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    static const FID_TUN_S_SET_HD_SECTION_PARAMETERResult &getDefaultInstance();

private:

    inline void set_has_TunerServer_StatusResponse ();

    inline void clear_has_TunerServer_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_TunerServer_StatusResponse _TunerServer_StatusResponse;

};

/**
 * The start message of the method "FID_TUN_S_DRM_TESTMODE"
 * This method is used to set DRM test mode notifications ON/OFF.
 */
class FID_TUN_S_DRM_TESTMODEStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_DRM_TESTMODEStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_DRM_TESTMODEStart (const FID_TUN_S_DRM_TESTMODEStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_DRM_TESTMODEStart (::tuner_main_fi_types::T_e8_Tun_DRMTestModeActivity e8DRMTestModeActivity_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_DRM_TESTMODEStart();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_DRM_TESTMODEStart& operator = (const FID_TUN_S_DRM_TESTMODEStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_DRM_TESTMODEStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_DRM_TESTMODEStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_DRM_TESTMODEStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_DRM_TESTMODEStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8DRMTestModeActivity"

    static const int kE8DRMTestModeActivity = 0;

    /**
     * Clears the field "e8DRMTestModeActivity".
     *
     * The field will be set to its default value. The hasE8DRMTestModeActivity()
     * method will return false.
     */
    inline void clearE8DRMTestModeActivity();

    /**
     * Checks whether the field "e8DRMTestModeActivity" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DRMTestModeActivity()). Otherwise it will return false.
     */
    inline bool hasE8DRMTestModeActivity () const;

    /**
     * Returns the value of the member "e8DRMTestModeActivity".
     *
     *
     *
     * @return The value of the field "e8DRMTestModeActivity"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_DRMTestModeActivity getE8DRMTestModeActivity () const;

    /**
     * Sets the value of the member "e8DRMTestModeActivity".
     *
     *
     *
     * @param e8DRMTestModeActivity The value which will be set
     */
    inline void setE8DRMTestModeActivity (::tuner_main_fi_types::T_e8_Tun_DRMTestModeActivity e8DRMTestModeActivity_);

    static const FID_TUN_S_DRM_TESTMODEStart &getDefaultInstance();

private:

    inline void set_has_e8DRMTestModeActivity ();

    inline void clear_has_e8DRMTestModeActivity ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_e8_Tun_DRMTestModeActivity _e8DRMTestModeActivity;

};

/**
 * The result message of the method "FID_TUN_S_DRM_TESTMODE"
 * This method is used to set DRM test mode notifications ON/OFF.
 * .
 */
class FID_TUN_S_DRM_TESTMODEResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_DRM_TESTMODEResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_DRM_TESTMODEResult (const FID_TUN_S_DRM_TESTMODEResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_DRM_TESTMODEResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_DRM_TESTMODEResult();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_DRM_TESTMODEResult& operator = (const FID_TUN_S_DRM_TESTMODEResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_DRM_TESTMODEResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_DRM_TESTMODEResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_DRM_TESTMODEResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_DRM_TESTMODEResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerServer_StatusResponse"

    static const int kTunerServer_StatusResponse = 0;

    /**
     * Clears the field "TunerServer_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerServer_StatusResponse()
     * method will return false.
     */
    inline void clearTunerServer_StatusResponse();

    /**
     * Checks whether the field "TunerServer_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerServer_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerServer_StatusResponse () const;

    /**
     * Returns the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @return The value of the field "TunerServer_StatusResponse"
     */
    inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerServer_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerServer_StatusResponse".
     */
    inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @param TunerServer_StatusResponse The value which will be set
     */
    inline void setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    static const FID_TUN_S_DRM_TESTMODEResult &getDefaultInstance();

private:

    inline void set_has_TunerServer_StatusResponse ();

    inline void clear_has_TunerServer_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_TunerServer_StatusResponse _TunerServer_StatusResponse;

};

/**
 * The result message of the method "FID_TUN_S_DRM_RESET_MUTECOUNTER"
 * This method is used to reset DRM mute counter to zero in DRM testmode
 * .
 */
class FID_TUN_S_DRM_RESET_MUTECOUNTERResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_DRM_RESET_MUTECOUNTERResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_DRM_RESET_MUTECOUNTERResult (const FID_TUN_S_DRM_RESET_MUTECOUNTERResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_DRM_RESET_MUTECOUNTERResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_DRM_RESET_MUTECOUNTERResult();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_DRM_RESET_MUTECOUNTERResult& operator = (const FID_TUN_S_DRM_RESET_MUTECOUNTERResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_DRM_RESET_MUTECOUNTERResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_DRM_RESET_MUTECOUNTERResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_DRM_RESET_MUTECOUNTERResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_DRM_RESET_MUTECOUNTERResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerServer_StatusResponse"

    static const int kTunerServer_StatusResponse = 0;

    /**
     * Clears the field "TunerServer_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerServer_StatusResponse()
     * method will return false.
     */
    inline void clearTunerServer_StatusResponse();

    /**
     * Checks whether the field "TunerServer_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerServer_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerServer_StatusResponse () const;

    /**
     * Returns the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @return The value of the field "TunerServer_StatusResponse"
     */
    inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerServer_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerServer_StatusResponse".
     */
    inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @param TunerServer_StatusResponse The value which will be set
     */
    inline void setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    static const FID_TUN_S_DRM_RESET_MUTECOUNTERResult &getDefaultInstance();

private:

    inline void set_has_TunerServer_StatusResponse ();

    inline void clear_has_TunerServer_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_TunerServer_StatusResponse _TunerServer_StatusResponse;

};

/**
 * The start message of the method "FID_TUN_S_SET_AF"
 * Activate/Deactivate the automatic tuning of the best known alternative frequency (AFBestSwitch)
 * For AF switch use this FID instead of FID_TUN_S_SET_FEATURE for new 3.30 APIversion.
 */
class FID_TUN_S_SET_AFStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_SET_AFStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_SET_AFStart (const FID_TUN_S_SET_AFStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_SET_AFStart (const ::tuner_main_fi_types::T_b8_Tun_AFSwitch& b8AFSwitchMask_, const ::tuner_main_fi_types::T_b8_Tun_AFSwitch& b8AFSwitch_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_SET_AFStart();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_SET_AFStart& operator = (const FID_TUN_S_SET_AFStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_SET_AFStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_SET_AFStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_SET_AFStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_SET_AFStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "b8AFSwitchMask"

    static const int kB8AFSwitchMask = 0;

    /**
     * Clears the field "b8AFSwitchMask".
     *
     * The field will be set to its default value. The hasB8AFSwitchMask()
     * method will return false.
     */
    inline void clearB8AFSwitchMask();

    /**
     * Checks whether the field "b8AFSwitchMask" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setB8AFSwitchMask()). Otherwise it will return false.
     */
    inline bool hasB8AFSwitchMask () const;

    /**
     * Returns the value of the member "b8AFSwitchMask".
     *
     * Indicates whether value is sent for RDS/DRM AF
     *
     * @return The value of the field "b8AFSwitchMask"
     */
    inline const ::tuner_main_fi_types::T_b8_Tun_AFSwitch& getB8AFSwitchMask () const;

    /**
     * Retrieves the value of the field "b8AFSwitchMask" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "b8AFSwitchMask".
     */
    inline ::tuner_main_fi_types::T_b8_Tun_AFSwitch& getB8AFSwitchMaskMutable ();

    /**
     * Sets the value of the member "b8AFSwitchMask".
     *
     * Indicates whether value is sent for RDS/DRM AF
     *
     * @param b8AFSwitchMask The value which will be set
     */
    inline void setB8AFSwitchMask (const ::tuner_main_fi_types::T_b8_Tun_AFSwitch& b8AFSwitchMask_);

    // API of field "b8AFSwitch"

    static const int kB8AFSwitch = 1;

    /**
     * Clears the field "b8AFSwitch".
     *
     * The field will be set to its default value. The hasB8AFSwitch()
     * method will return false.
     */
    inline void clearB8AFSwitch();

    /**
     * Checks whether the field "b8AFSwitch" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setB8AFSwitch()). Otherwise it will return false.
     */
    inline bool hasB8AFSwitch () const;

    /**
     * Returns the value of the member "b8AFSwitch".
     *
     * Indicates what value (on/off) has to be set for b8AFSwitchMask
     *
     * @return The value of the field "b8AFSwitch"
     */
    inline const ::tuner_main_fi_types::T_b8_Tun_AFSwitch& getB8AFSwitch () const;

    /**
     * Retrieves the value of the field "b8AFSwitch" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "b8AFSwitch".
     */
    inline ::tuner_main_fi_types::T_b8_Tun_AFSwitch& getB8AFSwitchMutable ();

    /**
     * Sets the value of the member "b8AFSwitch".
     *
     * Indicates what value (on/off) has to be set for b8AFSwitchMask
     *
     * @param b8AFSwitch The value which will be set
     */
    inline void setB8AFSwitch (const ::tuner_main_fi_types::T_b8_Tun_AFSwitch& b8AFSwitch_);

    static const FID_TUN_S_SET_AFStart &getDefaultInstance();

private:

    inline void set_has_b8AFSwitchMask ();

    inline void clear_has_b8AFSwitchMask ();

    inline void set_has_b8AFSwitch ();

    inline void clear_has_b8AFSwitch ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::tuner_main_fi_types::T_b8_Tun_AFSwitch _b8AFSwitchMask;

    ::tuner_main_fi_types::T_b8_Tun_AFSwitch _b8AFSwitch;

};

/**
 * The result message of the method "FID_TUN_S_SET_AF"
 * Activate/Deactivate the automatic tuning of the best known alternative frequency (AFBestSwitch)
 * For AF switch use this FID instead of FID_TUN_S_SET_FEATURE for new 3.30 APIversion.
 * .
 */
class FID_TUN_S_SET_AFResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_SET_AFResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_SET_AFResult (const FID_TUN_S_SET_AFResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_SET_AFResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_SET_AFResult();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_SET_AFResult& operator = (const FID_TUN_S_SET_AFResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_SET_AFResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_SET_AFResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_SET_AFResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_SET_AFResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerServer_StatusResponse"

    static const int kTunerServer_StatusResponse = 0;

    /**
     * Clears the field "TunerServer_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerServer_StatusResponse()
     * method will return false.
     */
    inline void clearTunerServer_StatusResponse();

    /**
     * Checks whether the field "TunerServer_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerServer_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerServer_StatusResponse () const;

    /**
     * Returns the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @return The value of the field "TunerServer_StatusResponse"
     */
    inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerServer_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerServer_StatusResponse".
     */
    inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @param TunerServer_StatusResponse The value which will be set
     */
    inline void setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    static const FID_TUN_S_SET_AFResult &getDefaultInstance();

private:

    inline void set_has_TunerServer_StatusResponse ();

    inline void clear_has_TunerServer_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_TunerServer_StatusResponse _TunerServer_StatusResponse;

};

/**
 * The start message of the method "FID_TUN_S_CHANGE_LSM"
 * This method is used to update the LSM with the requested data.
 */
class FID_TUN_S_CHANGE_LSMStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_CHANGE_LSMStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_CHANGE_LSMStart (const FID_TUN_S_CHANGE_LSMStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_CHANGE_LSMStart (::tuner_main_fi_types::T_e8_StationSelectionOption Option_, ::tuner_main_fi_types::T_e8_Tun_TunerBand Band_, uint32 Frequency_, uint8 u8Element_ID_, ::tuner_main_fi_types::T_e8_Tun_ListID e8ListID_, uint32 PI_, uint8 HDProgramNumber_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_CHANGE_LSMStart();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_CHANGE_LSMStart& operator = (const FID_TUN_S_CHANGE_LSMStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_CHANGE_LSMStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_CHANGE_LSMStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_CHANGE_LSMStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_CHANGE_LSMStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Option"

    static const int kOption = 0;

    /**
     * Clears the field "Option".
     *
     * The field will be set to its default value. The hasOption()
     * method will return false.
     */
    inline void clearOption();

    /**
     * Checks whether the field "Option" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOption()). Otherwise it will return false.
     */
    inline bool hasOption () const;

    /**
     * Returns the value of the member "Option".
     *
     * This parameter will inform the options available for LSM change.
     *
     * @return The value of the field "Option"
     */
    inline ::tuner_main_fi_types::T_e8_StationSelectionOption getOption () const;

    /**
     * Sets the value of the member "Option".
     *
     * This parameter will inform the options available for LSM change.
     *
     * @param Option The value which will be set
     */
    inline void setOption (::tuner_main_fi_types::T_e8_StationSelectionOption Option_);

    // API of field "Band"

    static const int kBand = 1;

    /**
     * Clears the field "Band".
     *
     * The field will be set to its default value. The hasBand()
     * method will return false.
     */
    inline void clearBand();

    /**
     * Checks whether the field "Band" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBand()). Otherwise it will return false.
     */
    inline bool hasBand () const;

    /**
     * Returns the value of the member "Band".
     *
     * Which Band Frequency belongs to
     *
     * @return The value of the field "Band"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_TunerBand getBand () const;

    /**
     * Sets the value of the member "Band".
     *
     * Which Band Frequency belongs to
     *
     * @param Band The value which will be set
     */
    inline void setBand (::tuner_main_fi_types::T_e8_Tun_TunerBand Band_);

    // API of field "Frequency"

    static const int kFrequency = 2;

    /**
     * Clears the field "Frequency".
     *
     * The field will be set to its default value. The hasFrequency()
     * method will return false.
     */
    inline void clearFrequency();

    /**
     * Checks whether the field "Frequency" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFrequency()). Otherwise it will return false.
     */
    inline bool hasFrequency () const;

    /**
     * Returns the value of the member "Frequency".
     *
     * Frequency Value
     *
     * @return The value of the field "Frequency"
     */
    inline uint32 getFrequency () const;

    /**
     * Sets the value of the member "Frequency".
     *
     * Frequency Value
     *
     * @param Frequency The value which will be set
     */
    inline void setFrequency (uint32 Frequency_);

    // API of field "u8Element_ID"

    static const int kU8Element_ID = 3;

    /**
     * Clears the field "u8Element_ID".
     *
     * The field will be set to its default value. The hasU8Element_ID()
     * method will return false.
     */
    inline void clearU8Element_ID();

    /**
     * Checks whether the field "u8Element_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Element_ID()). Otherwise it will return false.
     */
    inline bool hasU8Element_ID () const;

    /**
     * Returns the value of the member "u8Element_ID".
     *
     * This parameter indicates to which element, requested action has to be performed
     *
     * @return The value of the field "u8Element_ID"
     */
    inline uint8 getU8Element_ID () const;

    /**
     * Sets the value of the member "u8Element_ID".
     *
     * This parameter indicates to which element, requested action has to be performed
     *
     * @param u8Element_ID The value which will be set
     */
    inline void setU8Element_ID (uint8 u8Element_ID_);

    // API of field "e8ListID"

    static const int kE8ListID = 4;

    /**
     * Clears the field "e8ListID".
     *
     * The field will be set to its default value. The hasE8ListID()
     * method will return false.
     */
    inline void clearE8ListID();

    /**
     * Checks whether the field "e8ListID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ListID()). Otherwise it will return false.
     */
    inline bool hasE8ListID () const;

    /**
     * Returns the value of the member "e8ListID".
     *
     * This parameter indicates to which list,requested action has to be performed
     *
     * @return The value of the field "e8ListID"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_ListID getE8ListID () const;

    /**
     * Sets the value of the member "e8ListID".
     *
     * This parameter indicates to which list,requested action has to be performed
     *
     * @param e8ListID The value which will be set
     */
    inline void setE8ListID (::tuner_main_fi_types::T_e8_Tun_ListID e8ListID_);

    // API of field "PI"

    static const int kPI = 5;

    /**
     * Clears the field "PI".
     *
     * The field will be set to its default value. The hasPI()
     * method will return false.
     */
    inline void clearPI();

    /**
     * Checks whether the field "PI" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPI()). Otherwise it will return false.
     */
    inline bool hasPI () const;

    /**
     * Returns the value of the member "PI".
     *
     * This parameter indicates the PI or HDStationID or DRMServiceID.
     *
     * @return The value of the field "PI"
     */
    inline uint32 getPI () const;

    /**
     * Sets the value of the member "PI".
     *
     * This parameter indicates the PI or HDStationID or DRMServiceID.
     *
     * @param PI The value which will be set
     */
    inline void setPI (uint32 PI_);

    // API of field "HDProgramNumber"

    static const int kHDProgramNumber = 6;

    /**
     * Clears the field "HDProgramNumber".
     *
     * The field will be set to its default value. The hasHDProgramNumber()
     * method will return false.
     */
    inline void clearHDProgramNumber();

    /**
     * Checks whether the field "HDProgramNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHDProgramNumber()). Otherwise it will return false.
     */
    inline bool hasHDProgramNumber () const;

    /**
     * Returns the value of the member "HDProgramNumber".
     *
     * This parameter indicates the HDProgramNumber of the respective station.
     *
     * @return The value of the field "HDProgramNumber"
     */
    inline uint8 getHDProgramNumber () const;

    /**
     * Sets the value of the member "HDProgramNumber".
     *
     * This parameter indicates the HDProgramNumber of the respective station.
     *
     * @param HDProgramNumber The value which will be set
     */
    inline void setHDProgramNumber (uint8 HDProgramNumber_);

    static const FID_TUN_S_CHANGE_LSMStart &getDefaultInstance();

private:

    inline void set_has_Option ();

    inline void clear_has_Option ();

    inline void set_has_Band ();

    inline void clear_has_Band ();

    inline void set_has_Frequency ();

    inline void clear_has_Frequency ();

    inline void set_has_u8Element_ID ();

    inline void clear_has_u8Element_ID ();

    inline void set_has_e8ListID ();

    inline void clear_has_e8ListID ();

    inline void set_has_PI ();

    inline void clear_has_PI ();

    inline void set_has_HDProgramNumber ();

    inline void clear_has_HDProgramNumber ();

    uint32 _has_bits_[ (7 + 31) / 32];

    ::tuner_main_fi_types::T_e8_StationSelectionOption _Option;

    ::tuner_main_fi_types::T_e8_Tun_TunerBand _Band;

    uint32 _Frequency;

    uint8 _u8Element_ID;

    ::tuner_main_fi_types::T_e8_Tun_ListID _e8ListID;

    uint32 _PI;

    uint8 _HDProgramNumber;

};

/**
 * The result message of the method "FID_TUN_S_CHANGE_LSM"
 * This method is used to update the LSM with the requested data.
 * .
 */
class FID_TUN_S_CHANGE_LSMResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_CHANGE_LSMResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_CHANGE_LSMResult (const FID_TUN_S_CHANGE_LSMResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_CHANGE_LSMResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_CHANGE_LSMResult();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_CHANGE_LSMResult& operator = (const FID_TUN_S_CHANGE_LSMResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_CHANGE_LSMResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_CHANGE_LSMResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_CHANGE_LSMResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_CHANGE_LSMResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerServer_StatusResponse"

    static const int kTunerServer_StatusResponse = 0;

    /**
     * Clears the field "TunerServer_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerServer_StatusResponse()
     * method will return false.
     */
    inline void clearTunerServer_StatusResponse();

    /**
     * Checks whether the field "TunerServer_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerServer_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerServer_StatusResponse () const;

    /**
     * Returns the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @return The value of the field "TunerServer_StatusResponse"
     */
    inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerServer_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerServer_StatusResponse".
     */
    inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @param TunerServer_StatusResponse The value which will be set
     */
    inline void setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    static const FID_TUN_S_CHANGE_LSMResult &getDefaultInstance();

private:

    inline void set_has_TunerServer_StatusResponse ();

    inline void clear_has_TunerServer_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_TunerServer_StatusResponse _TunerServer_StatusResponse;

};

/**
 * The result message of the method "FID_TUN_S_DARC_NO_VICS_DATA_AVAILABLE"
 * The method is used to set the next frequency for the FM DARC tuner
 * .
 */
class FID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEResult (const FID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEResult();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEResult& operator = (const FID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerServer_StatusResponse"

    static const int kTunerServer_StatusResponse = 0;

    /**
     * Clears the field "TunerServer_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerServer_StatusResponse()
     * method will return false.
     */
    inline void clearTunerServer_StatusResponse();

    /**
     * Checks whether the field "TunerServer_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerServer_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerServer_StatusResponse () const;

    /**
     * Returns the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @return The value of the field "TunerServer_StatusResponse"
     */
    inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerServer_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerServer_StatusResponse".
     */
    inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @param TunerServer_StatusResponse The value which will be set
     */
    inline void setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    static const FID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEResult &getDefaultInstance();

private:

    inline void set_has_TunerServer_StatusResponse ();

    inline void clear_has_TunerServer_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_TunerServer_StatusResponse _TunerServer_StatusResponse;

};

/**
 * The start message of the method "FID_TUN_S_DARC_VICS_FREQUENCY_LIST"
 * The method is used to receive the list of Freq's/stations which supports DARC/VICS data.
 */
class FID_TUN_S_DARC_VICS_FREQUENCY_LISTStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_DARC_VICS_FREQUENCY_LISTStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_DARC_VICS_FREQUENCY_LISTStart (const FID_TUN_S_DARC_VICS_FREQUENCY_LISTStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_DARC_VICS_FREQUENCY_LISTStart (const ::tuner_main_fi_types::T_u32FrequencyList& FrequencyData_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_DARC_VICS_FREQUENCY_LISTStart();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_DARC_VICS_FREQUENCY_LISTStart& operator = (const FID_TUN_S_DARC_VICS_FREQUENCY_LISTStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_DARC_VICS_FREQUENCY_LISTStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_DARC_VICS_FREQUENCY_LISTStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_DARC_VICS_FREQUENCY_LISTStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_DARC_VICS_FREQUENCY_LISTStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "FrequencyData"

    static const int kFrequencyData = 0;

    /**
     * Clears the field "FrequencyData".
     *
     * The field will be set to its default value. The hasFrequencyData()
     * method will return false.
     */
    inline void clearFrequencyData();

    /**
     * Checks whether the field "FrequencyData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFrequencyData()). Otherwise it will return false.
     */
    inline bool hasFrequencyData () const;

    /**
     * Returns the value of the member "FrequencyData".
     *
     *
     *
     * @return The value of the field "FrequencyData"
     */
    inline const ::tuner_main_fi_types::T_u32FrequencyList& getFrequencyData () const;

    /**
     * Retrieves the value of the field "FrequencyData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "FrequencyData".
     */
    inline ::tuner_main_fi_types::T_u32FrequencyList& getFrequencyDataMutable ();

    /**
     * Sets the value of the member "FrequencyData".
     *
     *
     *
     * @param FrequencyData The value which will be set
     */
    inline void setFrequencyData (const ::tuner_main_fi_types::T_u32FrequencyList& FrequencyData_);

    static const FID_TUN_S_DARC_VICS_FREQUENCY_LISTStart &getDefaultInstance();

private:

    static const ::std::vector< uint32 >& getUint32List_DefaultInstance ();

    inline void set_has_FrequencyData ();

    inline void clear_has_FrequencyData ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_u32FrequencyList _FrequencyData;

};

/**
 * The result message of the method "FID_TUN_S_DARC_VICS_FREQUENCY_LIST"
 * The method is used to receive the list of Freq's/stations which supports DARC/VICS data.
 * .
 */
class FID_TUN_S_DARC_VICS_FREQUENCY_LISTResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_DARC_VICS_FREQUENCY_LISTResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_DARC_VICS_FREQUENCY_LISTResult (const FID_TUN_S_DARC_VICS_FREQUENCY_LISTResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_DARC_VICS_FREQUENCY_LISTResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_DARC_VICS_FREQUENCY_LISTResult();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_DARC_VICS_FREQUENCY_LISTResult& operator = (const FID_TUN_S_DARC_VICS_FREQUENCY_LISTResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_DARC_VICS_FREQUENCY_LISTResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_DARC_VICS_FREQUENCY_LISTResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_DARC_VICS_FREQUENCY_LISTResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_DARC_VICS_FREQUENCY_LISTResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerServer_StatusResponse"

    static const int kTunerServer_StatusResponse = 0;

    /**
     * Clears the field "TunerServer_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerServer_StatusResponse()
     * method will return false.
     */
    inline void clearTunerServer_StatusResponse();

    /**
     * Checks whether the field "TunerServer_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerServer_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerServer_StatusResponse () const;

    /**
     * Returns the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @return The value of the field "TunerServer_StatusResponse"
     */
    inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerServer_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerServer_StatusResponse".
     */
    inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @param TunerServer_StatusResponse The value which will be set
     */
    inline void setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    static const FID_TUN_S_DARC_VICS_FREQUENCY_LISTResult &getDefaultInstance();

private:

    inline void set_has_TunerServer_StatusResponse ();

    inline void clear_has_TunerServer_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_TunerServer_StatusResponse _TunerServer_StatusResponse;

};

/**
 * The start message of the method "FID_TUN_S_JAPAN_SET_AREA"
 * select the Japan region and also the mode of update.
 */
class FID_TUN_S_JAPAN_SET_AREAStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_JAPAN_SET_AREAStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_JAPAN_SET_AREAStart (const FID_TUN_S_JAPAN_SET_AREAStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_JAPAN_SET_AREAStart (::tuner_main_fi_types::T_e8_Tun_Japan_Region e8SelectedRegion_, bool bAreaSelectionMode_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_JAPAN_SET_AREAStart();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_JAPAN_SET_AREAStart& operator = (const FID_TUN_S_JAPAN_SET_AREAStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_JAPAN_SET_AREAStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_JAPAN_SET_AREAStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_JAPAN_SET_AREAStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_JAPAN_SET_AREAStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8SelectedRegion"

    static const int kE8SelectedRegion = 0;

    /**
     * Clears the field "e8SelectedRegion".
     *
     * The field will be set to its default value. The hasE8SelectedRegion()
     * method will return false.
     */
    inline void clearE8SelectedRegion();

    /**
     * Checks whether the field "e8SelectedRegion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8SelectedRegion()). Otherwise it will return false.
     */
    inline bool hasE8SelectedRegion () const;

    /**
     * Returns the value of the member "e8SelectedRegion".
     *
     * Selected Japan area
     *
     * @return The value of the field "e8SelectedRegion"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_Japan_Region getE8SelectedRegion () const;

    /**
     * Sets the value of the member "e8SelectedRegion".
     *
     * Selected Japan area
     *
     * @param e8SelectedRegion The value which will be set
     */
    inline void setE8SelectedRegion (::tuner_main_fi_types::T_e8_Tun_Japan_Region e8SelectedRegion_);

    // API of field "bAreaSelectionMode"

    static const int kBAreaSelectionMode = 1;

    /**
     * Clears the field "bAreaSelectionMode".
     *
     * The field will be set to its default value. The hasBAreaSelectionMode()
     * method will return false.
     */
    inline void clearBAreaSelectionMode();

    /**
     * Checks whether the field "bAreaSelectionMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBAreaSelectionMode()). Otherwise it will return false.
     */
    inline bool hasBAreaSelectionMode () const;

    /**
     * Returns the value of the member "bAreaSelectionMode".
     *
     * true : Manual Update (From HMI)
     * false : Automatic Update (From GPS Data)
     *
     * @return The value of the field "bAreaSelectionMode"
     */
    inline bool getBAreaSelectionMode () const;

    /**
     * Sets the value of the member "bAreaSelectionMode".
     *
     * true : Manual Update (From HMI)
     * false : Automatic Update (From GPS Data)
     *
     * @param bAreaSelectionMode The value which will be set
     */
    inline void setBAreaSelectionMode (bool bAreaSelectionMode_);

    static const FID_TUN_S_JAPAN_SET_AREAStart &getDefaultInstance();

private:

    inline void set_has_e8SelectedRegion ();

    inline void clear_has_e8SelectedRegion ();

    inline void set_has_bAreaSelectionMode ();

    inline void clear_has_bAreaSelectionMode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::tuner_main_fi_types::T_e8_Tun_Japan_Region _e8SelectedRegion;

    bool _bAreaSelectionMode;

};

/**
 * The result message of the method "FID_TUN_S_JAPAN_SET_AREA"
 * select the Japan region and also the mode of update.
 * .
 */
class FID_TUN_S_JAPAN_SET_AREAResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_JAPAN_SET_AREAResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_JAPAN_SET_AREAResult (const FID_TUN_S_JAPAN_SET_AREAResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_JAPAN_SET_AREAResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_JAPAN_SET_AREAResult();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_JAPAN_SET_AREAResult& operator = (const FID_TUN_S_JAPAN_SET_AREAResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_JAPAN_SET_AREAResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_JAPAN_SET_AREAResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_JAPAN_SET_AREAResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_JAPAN_SET_AREAResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerServer_StatusResponse"

    static const int kTunerServer_StatusResponse = 0;

    /**
     * Clears the field "TunerServer_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerServer_StatusResponse()
     * method will return false.
     */
    inline void clearTunerServer_StatusResponse();

    /**
     * Checks whether the field "TunerServer_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerServer_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerServer_StatusResponse () const;

    /**
     * Returns the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @return The value of the field "TunerServer_StatusResponse"
     */
    inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerServer_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerServer_StatusResponse".
     */
    inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @param TunerServer_StatusResponse The value which will be set
     */
    inline void setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    static const FID_TUN_S_JAPAN_SET_AREAResult &getDefaultInstance();

private:

    inline void set_has_TunerServer_StatusResponse ();

    inline void clear_has_TunerServer_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_TunerServer_StatusResponse _TunerServer_StatusResponse;

};

/**
 * The start message of the method "FID_TUN_S_JAPAN_CHANGE_STATION_NAME"
 * This method should not be used anymore and will be removed. Instead use FID_TUN_S_JAPAN_SELECT_STATION_NAME.
 * Switch station name to the next/previous station name that belongs to the current frequency in the selected area.
 * .
 */
class FID_TUN_S_JAPAN_CHANGE_STATION_NAMEStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_JAPAN_CHANGE_STATION_NAMEStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_JAPAN_CHANGE_STATION_NAMEStart (const FID_TUN_S_JAPAN_CHANGE_STATION_NAMEStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_JAPAN_CHANGE_STATION_NAMEStart (::tuner_main_fi_types::T_e8_Tun_ChangeStationMode e8ChangeStationMode_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_JAPAN_CHANGE_STATION_NAMEStart();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_JAPAN_CHANGE_STATION_NAMEStart& operator = (const FID_TUN_S_JAPAN_CHANGE_STATION_NAMEStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_JAPAN_CHANGE_STATION_NAMEStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_JAPAN_CHANGE_STATION_NAMEStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_JAPAN_CHANGE_STATION_NAMEStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_JAPAN_CHANGE_STATION_NAMEStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ChangeStationMode"

    static const int kE8ChangeStationMode = 0;

    /**
     * Clears the field "e8ChangeStationMode".
     *
     * The field will be set to its default value. The hasE8ChangeStationMode()
     * method will return false.
     */
    inline void clearE8ChangeStationMode();

    /**
     * Checks whether the field "e8ChangeStationMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ChangeStationMode()). Otherwise it will return false.
     */
    inline bool hasE8ChangeStationMode () const;

    /**
     * Returns the value of the member "e8ChangeStationMode".
     *
     * Select the previous/next station name for given frequency and selected area
     *
     * @return The value of the field "e8ChangeStationMode"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_ChangeStationMode getE8ChangeStationMode () const;

    /**
     * Sets the value of the member "e8ChangeStationMode".
     *
     * Select the previous/next station name for given frequency and selected area
     *
     * @param e8ChangeStationMode The value which will be set
     */
    inline void setE8ChangeStationMode (::tuner_main_fi_types::T_e8_Tun_ChangeStationMode e8ChangeStationMode_);

    static const FID_TUN_S_JAPAN_CHANGE_STATION_NAMEStart &getDefaultInstance();

private:

    inline void set_has_e8ChangeStationMode ();

    inline void clear_has_e8ChangeStationMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_e8_Tun_ChangeStationMode _e8ChangeStationMode;

};

/**
 * The result message of the method "FID_TUN_S_JAPAN_CHANGE_STATION_NAME"
 * This method should not be used anymore and will be removed. Instead use FID_TUN_S_JAPAN_SELECT_STATION_NAME.
 * Switch station name to the next/previous station name that belongs to the current frequency in the selected area.
 * .
 */
class FID_TUN_S_JAPAN_CHANGE_STATION_NAMEResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_JAPAN_CHANGE_STATION_NAMEResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_JAPAN_CHANGE_STATION_NAMEResult (const FID_TUN_S_JAPAN_CHANGE_STATION_NAMEResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_JAPAN_CHANGE_STATION_NAMEResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_JAPAN_CHANGE_STATION_NAMEResult();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_JAPAN_CHANGE_STATION_NAMEResult& operator = (const FID_TUN_S_JAPAN_CHANGE_STATION_NAMEResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_JAPAN_CHANGE_STATION_NAMEResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_JAPAN_CHANGE_STATION_NAMEResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_JAPAN_CHANGE_STATION_NAMEResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_JAPAN_CHANGE_STATION_NAMEResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerServer_StatusResponse"

    static const int kTunerServer_StatusResponse = 0;

    /**
     * Clears the field "TunerServer_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerServer_StatusResponse()
     * method will return false.
     */
    inline void clearTunerServer_StatusResponse();

    /**
     * Checks whether the field "TunerServer_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerServer_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerServer_StatusResponse () const;

    /**
     * Returns the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @return The value of the field "TunerServer_StatusResponse"
     */
    inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerServer_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerServer_StatusResponse".
     */
    inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @param TunerServer_StatusResponse The value which will be set
     */
    inline void setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    static const FID_TUN_S_JAPAN_CHANGE_STATION_NAMEResult &getDefaultInstance();

private:

    inline void set_has_TunerServer_StatusResponse ();

    inline void clear_has_TunerServer_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_TunerServer_StatusResponse _TunerServer_StatusResponse;

};

/**
 * The start message of the method "FID_TUN_S_LANGUAGE_SETTING"
 * HMI/Other clients can inform Tuner MIDW about the current language set on the target using this FI. Currently applicable only for AIVI JPN variant where based on the language set, the station name posted can be japanese/english name.
 */
class FID_TUN_S_LANGUAGE_SETTINGStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_LANGUAGE_SETTINGStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_LANGUAGE_SETTINGStart (const FID_TUN_S_LANGUAGE_SETTINGStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_LANGUAGE_SETTINGStart (::tuner_main_fi_types::T_e8_Tun_Language e8Language_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_LANGUAGE_SETTINGStart();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_LANGUAGE_SETTINGStart& operator = (const FID_TUN_S_LANGUAGE_SETTINGStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_LANGUAGE_SETTINGStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_LANGUAGE_SETTINGStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_LANGUAGE_SETTINGStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_LANGUAGE_SETTINGStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Language"

    static const int kE8Language = 0;

    /**
     * Clears the field "e8Language".
     *
     * The field will be set to its default value. The hasE8Language()
     * method will return false.
     */
    inline void clearE8Language();

    /**
     * Checks whether the field "e8Language" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Language()). Otherwise it will return false.
     */
    inline bool hasE8Language () const;

    /**
     * Returns the value of the member "e8Language".
     *
     * Current language set on the target.
     *
     * @return The value of the field "e8Language"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_Language getE8Language () const;

    /**
     * Sets the value of the member "e8Language".
     *
     * Current language set on the target.
     *
     * @param e8Language The value which will be set
     */
    inline void setE8Language (::tuner_main_fi_types::T_e8_Tun_Language e8Language_);

    static const FID_TUN_S_LANGUAGE_SETTINGStart &getDefaultInstance();

private:

    inline void set_has_e8Language ();

    inline void clear_has_e8Language ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_e8_Tun_Language _e8Language;

};

/**
 * The result message of the method "FID_TUN_S_LANGUAGE_SETTING"
 * HMI/Other clients can inform Tuner MIDW about the current language set on the target using this FI. Currently applicable only for AIVI JPN variant where based on the language set, the station name posted can be japanese/english name.
 * .
 */
class FID_TUN_S_LANGUAGE_SETTINGResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_LANGUAGE_SETTINGResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_LANGUAGE_SETTINGResult (const FID_TUN_S_LANGUAGE_SETTINGResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_LANGUAGE_SETTINGResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_LANGUAGE_SETTINGResult();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_LANGUAGE_SETTINGResult& operator = (const FID_TUN_S_LANGUAGE_SETTINGResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_LANGUAGE_SETTINGResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_LANGUAGE_SETTINGResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_LANGUAGE_SETTINGResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_LANGUAGE_SETTINGResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerServer_StatusResponse"

    static const int kTunerServer_StatusResponse = 0;

    /**
     * Clears the field "TunerServer_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerServer_StatusResponse()
     * method will return false.
     */
    inline void clearTunerServer_StatusResponse();

    /**
     * Checks whether the field "TunerServer_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerServer_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerServer_StatusResponse () const;

    /**
     * Returns the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @return The value of the field "TunerServer_StatusResponse"
     */
    inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerServer_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerServer_StatusResponse".
     */
    inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @param TunerServer_StatusResponse The value which will be set
     */
    inline void setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    static const FID_TUN_S_LANGUAGE_SETTINGResult &getDefaultInstance();

private:

    inline void set_has_TunerServer_StatusResponse ();

    inline void clear_has_TunerServer_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_TunerServer_StatusResponse _TunerServer_StatusResponse;

};

/**
 * The start message of the method "FID_TUN_S_JAPAN_SELECT_STATION_NAME"
 * Select/Change station name (absolutely/relatively) that belongs to the current frequency in the selected area.
 */
class FID_TUN_S_JAPAN_SELECT_STATION_NAMEStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_JAPAN_SELECT_STATION_NAMEStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_JAPAN_SELECT_STATION_NAMEStart (const FID_TUN_S_JAPAN_SELECT_STATION_NAMEStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_JAPAN_SELECT_STATION_NAMEStart (::tuner_main_fi_types::T_e8_Tun_SelectMode e8SelectMode_, ::tuner_main_fi_types::T_e8_Tun_RelativeDirection e8Direction_, uint16 u16ElementID_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_JAPAN_SELECT_STATION_NAMEStart();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_JAPAN_SELECT_STATION_NAMEStart& operator = (const FID_TUN_S_JAPAN_SELECT_STATION_NAMEStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_JAPAN_SELECT_STATION_NAMEStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_JAPAN_SELECT_STATION_NAMEStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_JAPAN_SELECT_STATION_NAMEStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_JAPAN_SELECT_STATION_NAMEStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8SelectMode"

    static const int kE8SelectMode = 0;

    /**
     * Clears the field "e8SelectMode".
     *
     * The field will be set to its default value. The hasE8SelectMode()
     * method will return false.
     */
    inline void clearE8SelectMode();

    /**
     * Checks whether the field "e8SelectMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8SelectMode()). Otherwise it will return false.
     */
    inline bool hasE8SelectMode () const;

    /**
     * Returns the value of the member "e8SelectMode".
     *
     * Indicates if the Japan Station name needs to be selected absolutely or relatively.
     *
     * @return The value of the field "e8SelectMode"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_SelectMode getE8SelectMode () const;

    /**
     * Sets the value of the member "e8SelectMode".
     *
     * Indicates if the Japan Station name needs to be selected absolutely or relatively.
     *
     * @param e8SelectMode The value which will be set
     */
    inline void setE8SelectMode (::tuner_main_fi_types::T_e8_Tun_SelectMode e8SelectMode_);

    // API of field "e8Direction"

    static const int kE8Direction = 1;

    /**
     * Clears the field "e8Direction".
     *
     * The field will be set to its default value. The hasE8Direction()
     * method will return false.
     */
    inline void clearE8Direction();

    /**
     * Checks whether the field "e8Direction" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Direction()). Otherwise it will return false.
     */
    inline bool hasE8Direction () const;

    /**
     * Returns the value of the member "e8Direction".
     *
     * This parameter is considered if SelectMode is set to Relative (SelectMode=1).
     * Increment : Select one greater than available station name in the list for given frequency and selected area code. If the last station name is currently selected, and next is selected then first station name in the list will be used.
     * Decrement : Select one less than available station name for given frequency and selected area code. If the first station name is currently selected, and previous is selected then last station name in the list will be used.
     *
     * @return The value of the field "e8Direction"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_RelativeDirection getE8Direction () const;

    /**
     * Sets the value of the member "e8Direction".
     *
     * This parameter is considered if SelectMode is set to Relative (SelectMode=1).
     * Increment : Select one greater than available station name in the list for given frequency and selected area code. If the last station name is currently selected, and next is selected then first station name in the list will be used.
     * Decrement : Select one less than available station name for given frequency and selected area code. If the first station name is currently selected, and previous is selected then last station name in the list will be used.
     *
     * @param e8Direction The value which will be set
     */
    inline void setE8Direction (::tuner_main_fi_types::T_e8_Tun_RelativeDirection e8Direction_);

    // API of field "u16ElementID"

    static const int kU16ElementID = 2;

    /**
     * Clears the field "u16ElementID".
     *
     * The field will be set to its default value. The hasU16ElementID()
     * method will return false.
     */
    inline void clearU16ElementID();

    /**
     * Checks whether the field "u16ElementID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ElementID()). Otherwise it will return false.
     */
    inline bool hasU16ElementID () const;

    /**
     * Returns the value of the member "u16ElementID".
     *
     * This parameter is considered if SelectMode is set to Absolute (SelectMode=0). The requested element ID will be selected from the Japan station name list for given frequency and selected area code.
     * If invalid element ID is received from client then failed method result will be sent. The element ID should be present in FID_TUN_G_JAPAN_STATION_NAME_LIST update. Only then it is considered valid.
     *
     * @return The value of the field "u16ElementID"
     */
    inline uint16 getU16ElementID () const;

    /**
     * Sets the value of the member "u16ElementID".
     *
     * This parameter is considered if SelectMode is set to Absolute (SelectMode=0). The requested element ID will be selected from the Japan station name list for given frequency and selected area code.
     * If invalid element ID is received from client then failed method result will be sent. The element ID should be present in FID_TUN_G_JAPAN_STATION_NAME_LIST update. Only then it is considered valid.
     *
     * @param u16ElementID The value which will be set
     */
    inline void setU16ElementID (uint16 u16ElementID_);

    static const FID_TUN_S_JAPAN_SELECT_STATION_NAMEStart &getDefaultInstance();

private:

    inline void set_has_e8SelectMode ();

    inline void clear_has_e8SelectMode ();

    inline void set_has_e8Direction ();

    inline void clear_has_e8Direction ();

    inline void set_has_u16ElementID ();

    inline void clear_has_u16ElementID ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::tuner_main_fi_types::T_e8_Tun_SelectMode _e8SelectMode;

    ::tuner_main_fi_types::T_e8_Tun_RelativeDirection _e8Direction;

    uint16 _u16ElementID;

};

/**
 * The result message of the method "FID_TUN_S_JAPAN_SELECT_STATION_NAME"
 * Select/Change station name (absolutely/relatively) that belongs to the current frequency in the selected area.
 * .
 */
class FID_TUN_S_JAPAN_SELECT_STATION_NAMEResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_JAPAN_SELECT_STATION_NAMEResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_JAPAN_SELECT_STATION_NAMEResult (const FID_TUN_S_JAPAN_SELECT_STATION_NAMEResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_JAPAN_SELECT_STATION_NAMEResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_JAPAN_SELECT_STATION_NAMEResult();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_JAPAN_SELECT_STATION_NAMEResult& operator = (const FID_TUN_S_JAPAN_SELECT_STATION_NAMEResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_JAPAN_SELECT_STATION_NAMEResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_JAPAN_SELECT_STATION_NAMEResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_JAPAN_SELECT_STATION_NAMEResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_JAPAN_SELECT_STATION_NAMEResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerServer_StatusResponse"

    static const int kTunerServer_StatusResponse = 0;

    /**
     * Clears the field "TunerServer_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerServer_StatusResponse()
     * method will return false.
     */
    inline void clearTunerServer_StatusResponse();

    /**
     * Checks whether the field "TunerServer_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerServer_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerServer_StatusResponse () const;

    /**
     * Returns the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @return The value of the field "TunerServer_StatusResponse"
     */
    inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerServer_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerServer_StatusResponse".
     */
    inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @param TunerServer_StatusResponse The value which will be set
     */
    inline void setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    static const FID_TUN_S_JAPAN_SELECT_STATION_NAMEResult &getDefaultInstance();

private:

    inline void set_has_TunerServer_StatusResponse ();

    inline void clear_has_TunerServer_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_TunerServer_StatusResponse _TunerServer_StatusResponse;

};

/**
 * The start message of the method "FID_TUN_S_USER_PROFILE_UPDATE"
 * Method for TMC. This method is used to copy, delete or activate a user profile
 */
class FID_TUN_S_USER_PROFILE_UPDATEStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_USER_PROFILE_UPDATEStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_USER_PROFILE_UPDATEStart (const FID_TUN_S_USER_PROFILE_UPDATEStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_USER_PROFILE_UPDATEStart (::tuner_main_fi_types::T_Tun_UserProfileAction Action_, uint8 UserID_, uint8 DestinationUserID_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_USER_PROFILE_UPDATEStart();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_USER_PROFILE_UPDATEStart& operator = (const FID_TUN_S_USER_PROFILE_UPDATEStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_USER_PROFILE_UPDATEStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_USER_PROFILE_UPDATEStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_USER_PROFILE_UPDATEStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_USER_PROFILE_UPDATEStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Action"

    static const int kAction = 0;

    /**
     * Clears the field "Action".
     *
     * The field will be set to its default value. The hasAction()
     * method will return false.
     */
    inline void clearAction();

    /**
     * Checks whether the field "Action" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAction()). Otherwise it will return false.
     */
    inline bool hasAction () const;

    /**
     * Returns the value of the member "Action".
     *
     * Change: Changes the current user profile.
     * Copy: Copies a user profile to another user profile.
     * Delete: Deletes a user profile.
     *
     * @return The value of the field "Action"
     */
    inline ::tuner_main_fi_types::T_Tun_UserProfileAction getAction () const;

    /**
     * Sets the value of the member "Action".
     *
     * Change: Changes the current user profile.
     * Copy: Copies a user profile to another user profile.
     * Delete: Deletes a user profile.
     *
     * @param Action The value which will be set
     */
    inline void setAction (::tuner_main_fi_types::T_Tun_UserProfileAction Action_);

    // API of field "UserID"

    static const int kUserID = 1;

    /**
     * Clears the field "UserID".
     *
     * The field will be set to its default value. The hasUserID()
     * method will return false.
     */
    inline void clearUserID();

    /**
     * Checks whether the field "UserID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUserID()). Otherwise it will return false.
     */
    inline bool hasUserID () const;

    /**
     * Returns the value of the member "UserID".
     *
     * The user id to be changed, copied or deleted. Should contain the source user ID in case of copy profile. Supports 0 - 6.
     *
     * @return The value of the field "UserID"
     */
    inline uint8 getUserID () const;

    /**
     * Sets the value of the member "UserID".
     *
     * The user id to be changed, copied or deleted. Should contain the source user ID in case of copy profile. Supports 0 - 6.
     *
     * @param UserID The value which will be set
     */
    inline void setUserID (uint8 UserID_);

    // API of field "DestinationUserID"

    static const int kDestinationUserID = 2;

    /**
     * Clears the field "DestinationUserID".
     *
     * The field will be set to its default value. The hasDestinationUserID()
     * method will return false.
     */
    inline void clearDestinationUserID();

    /**
     * Checks whether the field "DestinationUserID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestinationUserID()). Otherwise it will return false.
     */
    inline bool hasDestinationUserID () const;

    /**
     * Returns the value of the member "DestinationUserID".
     *
     * Used only for copy profile. Should contain the destination user profile. Supports 0 - 6.
     *
     * @return The value of the field "DestinationUserID"
     */
    inline uint8 getDestinationUserID () const;

    /**
     * Sets the value of the member "DestinationUserID".
     *
     * Used only for copy profile. Should contain the destination user profile. Supports 0 - 6.
     *
     * @param DestinationUserID The value which will be set
     */
    inline void setDestinationUserID (uint8 DestinationUserID_);

    static const FID_TUN_S_USER_PROFILE_UPDATEStart &getDefaultInstance();

private:

    inline void set_has_Action ();

    inline void clear_has_Action ();

    inline void set_has_UserID ();

    inline void clear_has_UserID ();

    inline void set_has_DestinationUserID ();

    inline void clear_has_DestinationUserID ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::tuner_main_fi_types::T_Tun_UserProfileAction _Action;

    uint8 _UserID;

    uint8 _DestinationUserID;

};

/**
 * The result message of the method "FID_TUN_S_USER_PROFILE_UPDATE"
 * Method for TMC. This method is used to copy, delete or activate a user profile
 * .
 */
class FID_TUN_S_USER_PROFILE_UPDATEResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_USER_PROFILE_UPDATEResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_USER_PROFILE_UPDATEResult (const FID_TUN_S_USER_PROFILE_UPDATEResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_USER_PROFILE_UPDATEResult (::tuner_main_fi_types::T_Tun_UserProfileAction Action_, uint8 ActiveUserID_, const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_USER_PROFILE_UPDATEResult();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_USER_PROFILE_UPDATEResult& operator = (const FID_TUN_S_USER_PROFILE_UPDATEResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_USER_PROFILE_UPDATEResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_USER_PROFILE_UPDATEResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_USER_PROFILE_UPDATEResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_USER_PROFILE_UPDATEResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Action"

    static const int kAction = 0;

    /**
     * Clears the field "Action".
     *
     * The field will be set to its default value. The hasAction()
     * method will return false.
     */
    inline void clearAction();

    /**
     * Checks whether the field "Action" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAction()). Otherwise it will return false.
     */
    inline bool hasAction () const;

    /**
     * Returns the value of the member "Action".
     *
     * If the meaning of "Action" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Action"
     */
    inline ::tuner_main_fi_types::T_Tun_UserProfileAction getAction () const;

    /**
     * Sets the value of the member "Action".
     *
     * If the meaning of "Action" isn't clear, then there should be a description here.
     *
     * @param Action The value which will be set
     */
    inline void setAction (::tuner_main_fi_types::T_Tun_UserProfileAction Action_);

    // API of field "ActiveUserID"

    static const int kActiveUserID = 1;

    /**
     * Clears the field "ActiveUserID".
     *
     * The field will be set to its default value. The hasActiveUserID()
     * method will return false.
     */
    inline void clearActiveUserID();

    /**
     * Checks whether the field "ActiveUserID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActiveUserID()). Otherwise it will return false.
     */
    inline bool hasActiveUserID () const;

    /**
     * Returns the value of the member "ActiveUserID".
     *
     * If the meaning of "ActiveUserID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ActiveUserID"
     */
    inline uint8 getActiveUserID () const;

    /**
     * Sets the value of the member "ActiveUserID".
     *
     * If the meaning of "ActiveUserID" isn't clear, then there should be a description here.
     *
     * @param ActiveUserID The value which will be set
     */
    inline void setActiveUserID (uint8 ActiveUserID_);

    // API of field "TunerServer_StatusResponse"

    static const int kTunerServer_StatusResponse = 2;

    /**
     * Clears the field "TunerServer_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerServer_StatusResponse()
     * method will return false.
     */
    inline void clearTunerServer_StatusResponse();

    /**
     * Checks whether the field "TunerServer_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerServer_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerServer_StatusResponse () const;

    /**
     * Returns the value of the member "TunerServer_StatusResponse".
     *
     *
     *
     * @return The value of the field "TunerServer_StatusResponse"
     */
    inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerServer_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerServer_StatusResponse".
     */
    inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerServer_StatusResponse".
     *
     *
     *
     * @param TunerServer_StatusResponse The value which will be set
     */
    inline void setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    static const FID_TUN_S_USER_PROFILE_UPDATEResult &getDefaultInstance();

private:

    inline void set_has_Action ();

    inline void clear_has_Action ();

    inline void set_has_ActiveUserID ();

    inline void clear_has_ActiveUserID ();

    inline void set_has_TunerServer_StatusResponse ();

    inline void clear_has_TunerServer_StatusResponse ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::tuner_main_fi_types::T_Tun_UserProfileAction _Action;

    uint8 _ActiveUserID;

    ::tuner_main_fi_types::T_TunerServer_StatusResponse _TunerServer_StatusResponse;

};

/**
 * The start message of the method "FID_TUN_S_PRESETLIST_CONTENT_UPDATE"
 * This method is to be used only by fc_tunermaster only
 */
class FID_TUN_S_PRESETLIST_CONTENT_UPDATEStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_PRESETLIST_CONTENT_UPDATEStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_PRESETLIST_CONTENT_UPDATEStart (const FID_TUN_S_PRESETLIST_CONTENT_UPDATEStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_PRESETLIST_CONTENT_UPDATEStart (uint8 UserID_, const ::tuner_main_fi_types::T_TunerListElementList& Tun_ListElements_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_PRESETLIST_CONTENT_UPDATEStart();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_PRESETLIST_CONTENT_UPDATEStart& operator = (const FID_TUN_S_PRESETLIST_CONTENT_UPDATEStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_PRESETLIST_CONTENT_UPDATEStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_PRESETLIST_CONTENT_UPDATEStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_PRESETLIST_CONTENT_UPDATEStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_PRESETLIST_CONTENT_UPDATEStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "UserID"

    static const int kUserID = 0;

    /**
     * Clears the field "UserID".
     *
     * The field will be set to its default value. The hasUserID()
     * method will return false.
     */
    inline void clearUserID();

    /**
     * Checks whether the field "UserID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUserID()). Otherwise it will return false.
     */
    inline bool hasUserID () const;

    /**
     * Returns the value of the member "UserID".
     *
     *
     *
     * @return The value of the field "UserID"
     */
    inline uint8 getUserID () const;

    /**
     * Sets the value of the member "UserID".
     *
     *
     *
     * @param UserID The value which will be set
     */
    inline void setUserID (uint8 UserID_);

    // API of field "Tun_ListElements"

    static const int kTun_ListElements = 1;

    /**
     * Clears the field "Tun_ListElements".
     *
     * The field will be set to its default value. The hasTun_ListElements()
     * method will return false.
     */
    inline void clearTun_ListElements();

    /**
     * Checks whether the field "Tun_ListElements" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTun_ListElements()). Otherwise it will return false.
     */
    inline bool hasTun_ListElements () const;

    /**
     * Returns the value of the member "Tun_ListElements".
     *
     *
     *
     * @return The value of the field "Tun_ListElements"
     */
    inline const ::tuner_main_fi_types::T_TunerListElementList& getTun_ListElements () const;

    /**
     * Retrieves the value of the field "Tun_ListElements" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Tun_ListElements".
     */
    inline ::tuner_main_fi_types::T_TunerListElementList& getTun_ListElementsMutable ();

    /**
     * Sets the value of the member "Tun_ListElements".
     *
     *
     *
     * @param Tun_ListElements The value which will be set
     */
    inline void setTun_ListElements (const ::tuner_main_fi_types::T_TunerListElementList& Tun_ListElements_);

    static const FID_TUN_S_PRESETLIST_CONTENT_UPDATEStart &getDefaultInstance();

private:

    static const ::std::vector< ::tuner_main_fi_types::T_TunerListElement >& getT_TunerListElementList_DefaultInstance ();

    inline void set_has_UserID ();

    inline void clear_has_UserID ();

    inline void set_has_Tun_ListElements ();

    inline void clear_has_Tun_ListElements ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _UserID;

    ::tuner_main_fi_types::T_TunerListElementList _Tun_ListElements;

};

/**
 * The result message of the method "FID_TUN_S_PRESETLIST_CONTENT_UPDATE"
 * This method is to be used only by fc_tunermaster only
 * .
 */
class FID_TUN_S_PRESETLIST_CONTENT_UPDATEResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_PRESETLIST_CONTENT_UPDATEResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_PRESETLIST_CONTENT_UPDATEResult (const FID_TUN_S_PRESETLIST_CONTENT_UPDATEResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_PRESETLIST_CONTENT_UPDATEResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_PRESETLIST_CONTENT_UPDATEResult();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_PRESETLIST_CONTENT_UPDATEResult& operator = (const FID_TUN_S_PRESETLIST_CONTENT_UPDATEResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_PRESETLIST_CONTENT_UPDATEResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_PRESETLIST_CONTENT_UPDATEResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_PRESETLIST_CONTENT_UPDATEResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_PRESETLIST_CONTENT_UPDATEResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerServer_StatusResponse"

    static const int kTunerServer_StatusResponse = 0;

    /**
     * Clears the field "TunerServer_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerServer_StatusResponse()
     * method will return false.
     */
    inline void clearTunerServer_StatusResponse();

    /**
     * Checks whether the field "TunerServer_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerServer_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerServer_StatusResponse () const;

    /**
     * Returns the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @return The value of the field "TunerServer_StatusResponse"
     */
    inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerServer_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerServer_StatusResponse".
     */
    inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @param TunerServer_StatusResponse The value which will be set
     */
    inline void setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    static const FID_TUN_S_PRESETLIST_CONTENT_UPDATEResult &getDefaultInstance();

private:

    inline void set_has_TunerServer_StatusResponse ();

    inline void clear_has_TunerServer_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_TunerServer_StatusResponse _TunerServer_StatusResponse;

};

/**
 * The start message of the method "FID_TUN_S_DISABLE_BAND"
 */
class FID_TUN_S_DISABLE_BANDStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_DISABLE_BANDStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_DISABLE_BANDStart (const FID_TUN_S_DISABLE_BANDStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_DISABLE_BANDStart (::tuner_main_fi_types::T_e8_Tun_TunerBand u8Band_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_DISABLE_BANDStart();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_DISABLE_BANDStart& operator = (const FID_TUN_S_DISABLE_BANDStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_DISABLE_BANDStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_DISABLE_BANDStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_DISABLE_BANDStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_DISABLE_BANDStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8Band"

    static const int kU8Band = 0;

    /**
     * Clears the field "u8Band".
     *
     * The field will be set to its default value. The hasU8Band()
     * method will return false.
     */
    inline void clearU8Band();

    /**
     * Checks whether the field "u8Band" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Band()). Otherwise it will return false.
     */
    inline bool hasU8Band () const;

    /**
     * Returns the value of the member "u8Band".
     *
     * .
     *
     * @return The value of the field "u8Band"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_TunerBand getU8Band () const;

    /**
     * Sets the value of the member "u8Band".
     *
     * .
     *
     * @param u8Band The value which will be set
     */
    inline void setU8Band (::tuner_main_fi_types::T_e8_Tun_TunerBand u8Band_);

    static const FID_TUN_S_DISABLE_BANDStart &getDefaultInstance();

private:

    inline void set_has_u8Band ();

    inline void clear_has_u8Band ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_e8_Tun_TunerBand _u8Band;

};

/**
 * The result message of the method "FID_TUN_S_DISABLE_BAND"
 * .
 */
class FID_TUN_S_DISABLE_BANDResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_S_DISABLE_BANDResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_S_DISABLE_BANDResult (const FID_TUN_S_DISABLE_BANDResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_S_DISABLE_BANDResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_S_DISABLE_BANDResult();

    /**
     * Assignment operator
     */
    inline FID_TUN_S_DISABLE_BANDResult& operator = (const FID_TUN_S_DISABLE_BANDResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_S_DISABLE_BANDResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_S_DISABLE_BANDResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_S_DISABLE_BANDResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_S_DISABLE_BANDResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerServer_StatusResponse"

    static const int kTunerServer_StatusResponse = 0;

    /**
     * Clears the field "TunerServer_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerServer_StatusResponse()
     * method will return false.
     */
    inline void clearTunerServer_StatusResponse();

    /**
     * Checks whether the field "TunerServer_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerServer_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerServer_StatusResponse () const;

    /**
     * Returns the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @return The value of the field "TunerServer_StatusResponse"
     */
    inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerServer_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerServer_StatusResponse".
     */
    inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& getTunerServer_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerServer_StatusResponse".
     *
     * .
     *
     * @param TunerServer_StatusResponse The value which will be set
     */
    inline void setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_);

    static const FID_TUN_S_DISABLE_BANDResult &getDefaultInstance();

private:

    inline void set_has_TunerServer_StatusResponse ();

    inline void clear_has_TunerServer_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_TunerServer_StatusResponse _TunerServer_StatusResponse;

};

/**
 * The status message of the property "FID_TUN_G_CALIBRATION_DATA"
 * Status response to Tuner Calibration Data.
 */
class FID_TUN_G_CALIBRATION_DATAStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_CALIBRATION_DATAStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_CALIBRATION_DATAStatus (const FID_TUN_G_CALIBRATION_DATAStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_CALIBRATION_DATAStatus (const ::tuner_main_fi_types::T_u16CalibrationData& CalibrationData_, const ::tuner_main_fi_types::T_CalibrationData& CalibrationDataValues_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_CALIBRATION_DATAStatus();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_CALIBRATION_DATAStatus& operator = (const FID_TUN_G_CALIBRATION_DATAStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_CALIBRATION_DATAStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_CALIBRATION_DATAStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_CALIBRATION_DATAStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_CALIBRATION_DATAStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CalibrationData"

    static const int kCalibrationData = 0;

    /**
     * Clears the field "CalibrationData".
     *
     * The field will be set to its default value. The hasCalibrationData()
     * method will return false.
     */
    inline void clearCalibrationData();

    /**
     * Checks whether the field "CalibrationData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCalibrationData()). Otherwise it will return false.
     */
    inline bool hasCalibrationData () const;

    /**
     * Returns the value of the member "CalibrationData".
     *
     * This parameter will be removed soon. Hence use the parameter CalibrationDataValues.
     *
     * @return The value of the field "CalibrationData"
     */
    inline const ::tuner_main_fi_types::T_u16CalibrationData& getCalibrationData () const;

    /**
     * Retrieves the value of the field "CalibrationData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CalibrationData".
     */
    inline ::tuner_main_fi_types::T_u16CalibrationData& getCalibrationDataMutable ();

    /**
     * Sets the value of the member "CalibrationData".
     *
     * This parameter will be removed soon. Hence use the parameter CalibrationDataValues.
     *
     * @param CalibrationData The value which will be set
     */
    inline void setCalibrationData (const ::tuner_main_fi_types::T_u16CalibrationData& CalibrationData_);

    // API of field "CalibrationDataValues"

    static const int kCalibrationDataValues = 1;

    /**
     * Clears the field "CalibrationDataValues".
     *
     * The field will be set to its default value. The hasCalibrationDataValues()
     * method will return false.
     */
    inline void clearCalibrationDataValues();

    /**
     * Checks whether the field "CalibrationDataValues" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCalibrationDataValues()). Otherwise it will return false.
     */
    inline bool hasCalibrationDataValues () const;

    /**
     * Returns the value of the member "CalibrationDataValues".
     *
     *
     *
     * @return The value of the field "CalibrationDataValues"
     */
    inline const ::tuner_main_fi_types::T_CalibrationData& getCalibrationDataValues () const;

    /**
     * Retrieves the value of the field "CalibrationDataValues" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CalibrationDataValues".
     */
    inline ::tuner_main_fi_types::T_CalibrationData& getCalibrationDataValuesMutable ();

    /**
     * Sets the value of the member "CalibrationDataValues".
     *
     *
     *
     * @param CalibrationDataValues The value which will be set
     */
    inline void setCalibrationDataValues (const ::tuner_main_fi_types::T_CalibrationData& CalibrationDataValues_);

    static const FID_TUN_G_CALIBRATION_DATAStatus &getDefaultInstance();

private:

    inline void set_has_CalibrationData ();

    inline void clear_has_CalibrationData ();

    inline void set_has_CalibrationDataValues ();

    inline void clear_has_CalibrationDataValues ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::tuner_main_fi_types::T_u16CalibrationData _CalibrationData;

    ::tuner_main_fi_types::T_CalibrationData _CalibrationDataValues;

};

/**
 * The status message of the property "FID_TUN_G_SET_FEATURE"
 * Status response to MethodStart FID_TUN_S_SET_FEATURE.
 */
class FID_TUN_G_SET_FEATUREStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_SET_FEATUREStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_SET_FEATUREStatus (const FID_TUN_G_SET_FEATUREStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_SET_FEATUREStatus (const ::tuner_main_fi_types::T_b32_Tun_Features& b32_Features_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_SET_FEATUREStatus();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_SET_FEATUREStatus& operator = (const FID_TUN_G_SET_FEATUREStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_SET_FEATUREStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_SET_FEATUREStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_SET_FEATUREStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_SET_FEATUREStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "b32_Features"

    static const int kB32_Features = 0;

    /**
     * Clears the field "b32_Features".
     *
     * The field will be set to its default value. The hasB32_Features()
     * method will return false.
     */
    inline void clearB32_Features();

    /**
     * Checks whether the field "b32_Features" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setB32_Features()). Otherwise it will return false.
     */
    inline bool hasB32_Features () const;

    /**
     * Returns the value of the member "b32_Features".
     *
     * Actual Tuner features set in Radio unit. Use class:  tuner_fi_tcl_b32_Features   to access
     * bits from file: tun_Msg_types.h.
     *
     * @return The value of the field "b32_Features"
     */
    inline const ::tuner_main_fi_types::T_b32_Tun_Features& getB32_Features () const;

    /**
     * Retrieves the value of the field "b32_Features" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "b32_Features".
     */
    inline ::tuner_main_fi_types::T_b32_Tun_Features& getB32_FeaturesMutable ();

    /**
     * Sets the value of the member "b32_Features".
     *
     * Actual Tuner features set in Radio unit. Use class:  tuner_fi_tcl_b32_Features   to access
     * bits from file: tun_Msg_types.h.
     *
     * @param b32_Features The value which will be set
     */
    inline void setB32_Features (const ::tuner_main_fi_types::T_b32_Tun_Features& b32_Features_);

    static const FID_TUN_G_SET_FEATUREStatus &getDefaultInstance();

private:

    inline void set_has_b32_Features ();

    inline void clear_has_b32_Features ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_b32_Tun_Features _b32_Features;

};

/**
 * The status message of the property "FID_TUN_G_SET_HICUT"
 * Status response to MethodStart FID_TUN_S_SET_HICUT.
 */
class FID_TUN_G_SET_HICUTStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_SET_HICUTStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_SET_HICUTStatus (const FID_TUN_G_SET_HICUTStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_SET_HICUTStatus (uint8 u8AbsVal_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_SET_HICUTStatus();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_SET_HICUTStatus& operator = (const FID_TUN_G_SET_HICUTStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_SET_HICUTStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_SET_HICUTStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_SET_HICUTStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_SET_HICUTStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8AbsVal"

    static const int kU8AbsVal = 0;

    /**
     * Clears the field "u8AbsVal".
     *
     * The field will be set to its default value. The hasU8AbsVal()
     * method will return false.
     */
    inline void clearU8AbsVal();

    /**
     * Checks whether the field "u8AbsVal" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8AbsVal()). Otherwise it will return false.
     */
    inline bool hasU8AbsVal () const;

    /**
     * Returns the value of the member "u8AbsVal".
     *
     * .
     *
     * @return The value of the field "u8AbsVal"
     */
    inline uint8 getU8AbsVal () const;

    /**
     * Sets the value of the member "u8AbsVal".
     *
     * .
     *
     * @param u8AbsVal The value which will be set
     */
    inline void setU8AbsVal (uint8 u8AbsVal_);

    static const FID_TUN_G_SET_HICUTStatus &getDefaultInstance();

private:

    inline void set_has_u8AbsVal ();

    inline void clear_has_u8AbsVal ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8AbsVal;

};

/**
 * The status message of the property "FID_TUN_G_AFLIST_V2"
 * Status response to MethodStart FID_TUN_S_AFLIST_V2 :list length and actual list is sent via this property.
 */
class FID_TUN_G_AFLIST_V2Status  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_AFLIST_V2Status ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_AFLIST_V2Status (const FID_TUN_G_AFLIST_V2Status &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_AFLIST_V2Status (uint8 u8LengthOfAFList_, const ::std::vector< ::tuner_main_fi_types::T_TunerAFList >& TunerAFList_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_AFLIST_V2Status();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_AFLIST_V2Status& operator = (const FID_TUN_G_AFLIST_V2Status& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_AFLIST_V2Status& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_AFLIST_V2Status& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_AFLIST_V2Status& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_AFLIST_V2Status& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8LengthOfAFList"

    static const int kU8LengthOfAFList = 0;

    /**
     * Clears the field "u8LengthOfAFList".
     *
     * The field will be set to its default value. The hasU8LengthOfAFList()
     * method will return false.
     */
    inline void clearU8LengthOfAFList();

    /**
     * Checks whether the field "u8LengthOfAFList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8LengthOfAFList()). Otherwise it will return false.
     */
    inline bool hasU8LengthOfAFList () const;

    /**
     * Returns the value of the member "u8LengthOfAFList".
     *
     * .
     *
     * @return The value of the field "u8LengthOfAFList"
     */
    inline uint8 getU8LengthOfAFList () const;

    /**
     * Sets the value of the member "u8LengthOfAFList".
     *
     * .
     *
     * @param u8LengthOfAFList The value which will be set
     */
    inline void setU8LengthOfAFList (uint8 u8LengthOfAFList_);

    // API of field "TunerAFList"

    static const int kTunerAFList = 1;

    /**
     * Clears the field "TunerAFList".
     *
     * The field will be set to its default value. The hasTunerAFList()
     * method will return false.
     */
    inline void clearTunerAFList();

    /**
     * Checks whether the field "TunerAFList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerAFList()). Otherwise it will return false.
     */
    inline bool hasTunerAFList () const;

    /**
     * Returns the value of the member "TunerAFList".
     *
     * List of AF stations.
     *
     * @return The value of the field "TunerAFList"
     */
    inline const ::std::vector< ::tuner_main_fi_types::T_TunerAFList >& getTunerAFList () const;

    /**
     * Retrieves the value of the field "TunerAFList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerAFList".
     */
    inline ::std::vector< ::tuner_main_fi_types::T_TunerAFList >& getTunerAFListMutable ();

    /**
     * Sets the value of the member "TunerAFList".
     *
     * List of AF stations.
     *
     * @param TunerAFList The value which will be set
     */
    inline void setTunerAFList (const ::std::vector< ::tuner_main_fi_types::T_TunerAFList >& TunerAFList_);

    static const FID_TUN_G_AFLIST_V2Status &getDefaultInstance();

private:

    static const ::std::vector< ::tuner_main_fi_types::T_TunerAFList >& getT_TunerAFListList_DefaultInstance ();

    inline void set_has_u8LengthOfAFList ();

    inline void clear_has_u8LengthOfAFList ();

    inline void set_has_TunerAFList ();

    inline void clear_has_TunerAFList ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8LengthOfAFList;

    ::std::vector< ::tuner_main_fi_types::T_TunerAFList > _TunerAFList;

};

/**
 * The status message of the property "FID_TUN_G_GET_CONFIG_LIST"
 * In response to the method start
 * FID_TUN_S_GET_CONFIG_LIST the number of config list
 * elements is given by this property.
 */
class FID_TUN_G_GET_CONFIG_LISTStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_GET_CONFIG_LISTStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_GET_CONFIG_LISTStatus (const FID_TUN_G_GET_CONFIG_LISTStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_GET_CONFIG_LISTStatus (::tuner_main_fi_types::T_e8_Tun_ConfigListID e8ConfigListID_, const ::tuner_main_fi_types::T_TunerConfigListElementList& Tun_ConfigListElements_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_GET_CONFIG_LISTStatus();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_GET_CONFIG_LISTStatus& operator = (const FID_TUN_G_GET_CONFIG_LISTStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_GET_CONFIG_LISTStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_GET_CONFIG_LISTStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_GET_CONFIG_LISTStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_GET_CONFIG_LISTStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ConfigListID"

    static const int kE8ConfigListID = 0;

    /**
     * Clears the field "e8ConfigListID".
     *
     * The field will be set to its default value. The hasE8ConfigListID()
     * method will return false.
     */
    inline void clearE8ConfigListID();

    /**
     * Checks whether the field "e8ConfigListID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ConfigListID()). Otherwise it will return false.
     */
    inline bool hasE8ConfigListID () const;

    /**
     * Returns the value of the member "e8ConfigListID".
     *
     *
     *
     * @return The value of the field "e8ConfigListID"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_ConfigListID getE8ConfigListID () const;

    /**
     * Sets the value of the member "e8ConfigListID".
     *
     *
     *
     * @param e8ConfigListID The value which will be set
     */
    inline void setE8ConfigListID (::tuner_main_fi_types::T_e8_Tun_ConfigListID e8ConfigListID_);

    // API of field "Tun_ConfigListElements"

    static const int kTun_ConfigListElements = 1;

    /**
     * Clears the field "Tun_ConfigListElements".
     *
     * The field will be set to its default value. The hasTun_ConfigListElements()
     * method will return false.
     */
    inline void clearTun_ConfigListElements();

    /**
     * Checks whether the field "Tun_ConfigListElements" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTun_ConfigListElements()). Otherwise it will return false.
     */
    inline bool hasTun_ConfigListElements () const;

    /**
     * Returns the value of the member "Tun_ConfigListElements".
     *
     *
     *
     * @return The value of the field "Tun_ConfigListElements"
     */
    inline const ::tuner_main_fi_types::T_TunerConfigListElementList& getTun_ConfigListElements () const;

    /**
     * Retrieves the value of the field "Tun_ConfigListElements" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Tun_ConfigListElements".
     */
    inline ::tuner_main_fi_types::T_TunerConfigListElementList& getTun_ConfigListElementsMutable ();

    /**
     * Sets the value of the member "Tun_ConfigListElements".
     *
     *
     *
     * @param Tun_ConfigListElements The value which will be set
     */
    inline void setTun_ConfigListElements (const ::tuner_main_fi_types::T_TunerConfigListElementList& Tun_ConfigListElements_);

    static const FID_TUN_G_GET_CONFIG_LISTStatus &getDefaultInstance();

private:

    static const ::std::vector< ::tuner_main_fi_types::T_TunerConfigListElement >& getT_TunerConfigListElementList_DefaultInstance ();

    inline void set_has_e8ConfigListID ();

    inline void clear_has_e8ConfigListID ();

    inline void set_has_Tun_ConfigListElements ();

    inline void clear_has_Tun_ConfigListElements ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::tuner_main_fi_types::T_e8_Tun_ConfigListID _e8ConfigListID;

    ::tuner_main_fi_types::T_TunerConfigListElementList _Tun_ConfigListElements;

};

/**
 * The get message of the property "FID_TUN_G_GET_CONFIG_LIST"
 * In response to the method start
 * FID_TUN_S_GET_CONFIG_LIST the number of config list
 * elements is given by this property.
 */
class FID_TUN_G_GET_CONFIG_LISTGet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_GET_CONFIG_LISTGet ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_GET_CONFIG_LISTGet (const FID_TUN_G_GET_CONFIG_LISTGet &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_GET_CONFIG_LISTGet (::tuner_main_fi_types::T_e8_Tun_ConfigListID e8ConfigListID_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_GET_CONFIG_LISTGet();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_GET_CONFIG_LISTGet& operator = (const FID_TUN_G_GET_CONFIG_LISTGet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_GET_CONFIG_LISTGet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_GET_CONFIG_LISTGet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_GET_CONFIG_LISTGet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_GET_CONFIG_LISTGet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ConfigListID"

    static const int kE8ConfigListID = 0;

    /**
     * Clears the field "e8ConfigListID".
     *
     * The field will be set to its default value. The hasE8ConfigListID()
     * method will return false.
     */
    inline void clearE8ConfigListID();

    /**
     * Checks whether the field "e8ConfigListID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ConfigListID()). Otherwise it will return false.
     */
    inline bool hasE8ConfigListID () const;

    /**
     * Returns the value of the member "e8ConfigListID".
     *
     *
     *
     * @return The value of the field "e8ConfigListID"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_ConfigListID getE8ConfigListID () const;

    /**
     * Sets the value of the member "e8ConfigListID".
     *
     *
     *
     * @param e8ConfigListID The value which will be set
     */
    inline void setE8ConfigListID (::tuner_main_fi_types::T_e8_Tun_ConfigListID e8ConfigListID_);

    static const FID_TUN_G_GET_CONFIG_LISTGet &getDefaultInstance();

private:

    inline void set_has_e8ConfigListID ();

    inline void clear_has_e8ConfigListID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_e8_Tun_ConfigListID _e8ConfigListID;

};

/**
 * The status message of the property "FID_TUN_G_SET_SHARXLEVEL"
 * Status response to HMI regarding the Sharx Step.
 */
class FID_TUN_G_SET_SHARXLEVELStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_SET_SHARXLEVELStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_SET_SHARXLEVELStatus (const FID_TUN_G_SET_SHARXLEVELStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_SET_SHARXLEVELStatus (uint8 u8SharxStep_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_SET_SHARXLEVELStatus();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_SET_SHARXLEVELStatus& operator = (const FID_TUN_G_SET_SHARXLEVELStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_SET_SHARXLEVELStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_SET_SHARXLEVELStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_SET_SHARXLEVELStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_SET_SHARXLEVELStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8SharxStep"

    static const int kU8SharxStep = 0;

    /**
     * Clears the field "u8SharxStep".
     *
     * The field will be set to its default value. The hasU8SharxStep()
     * method will return false.
     */
    inline void clearU8SharxStep();

    /**
     * Checks whether the field "u8SharxStep" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SharxStep()). Otherwise it will return false.
     */
    inline bool hasU8SharxStep () const;

    /**
     * Returns the value of the member "u8SharxStep".
     *
     * Sharx Step    0x00 - 0x03
     * Automatic     0xff
     *
     * @return The value of the field "u8SharxStep"
     */
    inline uint8 getU8SharxStep () const;

    /**
     * Sets the value of the member "u8SharxStep".
     *
     * Sharx Step    0x00 - 0x03
     * Automatic     0xff
     *
     * @param u8SharxStep The value which will be set
     */
    inline void setU8SharxStep (uint8 u8SharxStep_);

    static const FID_TUN_G_SET_SHARXLEVELStatus &getDefaultInstance();

private:

    inline void set_has_u8SharxStep ();

    inline void clear_has_u8SharxStep ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8SharxStep;

};

/**
 * The status message of the property "FID_TUN_G_SET_DDA"
 * Status response to HMI regarding the DDA.
 */
class FID_TUN_G_SET_DDAStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_SET_DDAStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_SET_DDAStatus (const FID_TUN_G_SET_DDAStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_SET_DDAStatus (uint8 u8DDA_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_SET_DDAStatus();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_SET_DDAStatus& operator = (const FID_TUN_G_SET_DDAStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_SET_DDAStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_SET_DDAStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_SET_DDAStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_SET_DDAStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DDA"

    static const int kU8DDA = 0;

    /**
     * Clears the field "u8DDA".
     *
     * The field will be set to its default value. The hasU8DDA()
     * method will return false.
     */
    inline void clearU8DDA();

    /**
     * Checks whether the field "u8DDA" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DDA()). Otherwise it will return false.
     */
    inline bool hasU8DDA () const;

    /**
     * Returns the value of the member "u8DDA".
     *
     *
     *
     * @return The value of the field "u8DDA"
     */
    inline uint8 getU8DDA () const;

    /**
     * Sets the value of the member "u8DDA".
     *
     *
     *
     * @param u8DDA The value which will be set
     */
    inline void setU8DDA (uint8 u8DDA_);

    static const FID_TUN_G_SET_DDAStatus &getDefaultInstance();

private:

    inline void set_has_u8DDA ();

    inline void clear_has_u8DDA ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8DDA;

};

/**
 * The status message of the property "FID_TUN_G_SET_AF"
 * Status response to HMI regarding the AF ON/OFF.
 */
class FID_TUN_G_SET_AFStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_SET_AFStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_SET_AFStatus (const FID_TUN_G_SET_AFStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_SET_AFStatus (uint8 u8AF_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_SET_AFStatus();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_SET_AFStatus& operator = (const FID_TUN_G_SET_AFStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_SET_AFStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_SET_AFStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_SET_AFStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_SET_AFStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8AF"

    static const int kU8AF = 0;

    /**
     * Clears the field "u8AF".
     *
     * The field will be set to its default value. The hasU8AF()
     * method will return false.
     */
    inline void clearU8AF();

    /**
     * Checks whether the field "u8AF" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8AF()). Otherwise it will return false.
     */
    inline bool hasU8AF () const;

    /**
     * Returns the value of the member "u8AF".
     *
     * Values:
     * 00 - AF switch is OFF,
     * 01 - RDS AF is ON,
     * 04 - DRM AF is ON,
     * 05 - DRM and RDS AF both are ON.
     *
     * @return The value of the field "u8AF"
     */
    inline uint8 getU8AF () const;

    /**
     * Sets the value of the member "u8AF".
     *
     * Values:
     * 00 - AF switch is OFF,
     * 01 - RDS AF is ON,
     * 04 - DRM AF is ON,
     * 05 - DRM and RDS AF both are ON.
     *
     * @param u8AF The value which will be set
     */
    inline void setU8AF (uint8 u8AF_);

    static const FID_TUN_G_SET_AFStatus &getDefaultInstance();

private:

    inline void set_has_u8AF ();

    inline void clear_has_u8AF ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8AF;

};

/**
 * The status message of the property "FID_TUN_G_SET_MEASUREMODE"
 * Status response to HMI regarding the Measuremode ON/OFF.
 */
class FID_TUN_G_SET_MEASUREMODEStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_SET_MEASUREMODEStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_SET_MEASUREMODEStatus (const FID_TUN_G_SET_MEASUREMODEStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_SET_MEASUREMODEStatus (uint8 u8Measuremode_, ::tuner_main_fi_types::T_e8_Tun_PhysicalTuner e8PhysicalTunerId_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_SET_MEASUREMODEStatus();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_SET_MEASUREMODEStatus& operator = (const FID_TUN_G_SET_MEASUREMODEStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_SET_MEASUREMODEStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_SET_MEASUREMODEStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_SET_MEASUREMODEStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_SET_MEASUREMODEStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8Measuremode"

    static const int kU8Measuremode = 0;

    /**
     * Clears the field "u8Measuremode".
     *
     * The field will be set to its default value. The hasU8Measuremode()
     * method will return false.
     */
    inline void clearU8Measuremode();

    /**
     * Checks whether the field "u8Measuremode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Measuremode()). Otherwise it will return false.
     */
    inline bool hasU8Measuremode () const;

    /**
     * Returns the value of the member "u8Measuremode".
     *
     *
     *
     * @return The value of the field "u8Measuremode"
     */
    inline uint8 getU8Measuremode () const;

    /**
     * Sets the value of the member "u8Measuremode".
     *
     *
     *
     * @param u8Measuremode The value which will be set
     */
    inline void setU8Measuremode (uint8 u8Measuremode_);

    // API of field "e8PhysicalTunerId"

    static const int kE8PhysicalTunerId = 1;

    /**
     * Clears the field "e8PhysicalTunerId".
     *
     * The field will be set to its default value. The hasE8PhysicalTunerId()
     * method will return false.
     */
    inline void clearE8PhysicalTunerId();

    /**
     * Checks whether the field "e8PhysicalTunerId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8PhysicalTunerId()). Otherwise it will return false.
     */
    inline bool hasE8PhysicalTunerId () const;

    /**
     * Returns the value of the member "e8PhysicalTunerId".
     *
     *
     *
     * @return The value of the field "e8PhysicalTunerId"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_PhysicalTuner getE8PhysicalTunerId () const;

    /**
     * Sets the value of the member "e8PhysicalTunerId".
     *
     *
     *
     * @param e8PhysicalTunerId The value which will be set
     */
    inline void setE8PhysicalTunerId (::tuner_main_fi_types::T_e8_Tun_PhysicalTuner e8PhysicalTunerId_);

    static const FID_TUN_G_SET_MEASUREMODEStatus &getDefaultInstance();

private:

    inline void set_has_u8Measuremode ();

    inline void clear_has_u8Measuremode ();

    inline void set_has_e8PhysicalTunerId ();

    inline void clear_has_e8PhysicalTunerId ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8Measuremode;

    ::tuner_main_fi_types::T_e8_Tun_PhysicalTuner _e8PhysicalTunerId;

};

/**
 * The status message of the property "FID_TUN_G_SET_RDSREG"
 * Status response to HMI regarding the REG ON/OFF.
 */
class FID_TUN_G_SET_RDSREGStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_SET_RDSREGStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_SET_RDSREGStatus (const FID_TUN_G_SET_RDSREGStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_SET_RDSREGStatus (uint8 u8RDSreg_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_SET_RDSREGStatus();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_SET_RDSREGStatus& operator = (const FID_TUN_G_SET_RDSREGStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_SET_RDSREGStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_SET_RDSREGStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_SET_RDSREGStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_SET_RDSREGStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8RDSreg"

    static const int kU8RDSreg = 0;

    /**
     * Clears the field "u8RDSreg".
     *
     * The field will be set to its default value. The hasU8RDSreg()
     * method will return false.
     */
    inline void clearU8RDSreg();

    /**
     * Checks whether the field "u8RDSreg" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8RDSreg()). Otherwise it will return false.
     */
    inline bool hasU8RDSreg () const;

    /**
     * Returns the value of the member "u8RDSreg".
     *
     *
     *
     * @return The value of the field "u8RDSreg"
     */
    inline uint8 getU8RDSreg () const;

    /**
     * Sets the value of the member "u8RDSreg".
     *
     *
     *
     * @param u8RDSreg The value which will be set
     */
    inline void setU8RDSreg (uint8 u8RDSreg_);

    static const FID_TUN_G_SET_RDSREGStatus &getDefaultInstance();

private:

    inline void set_has_u8RDSreg ();

    inline void clear_has_u8RDSreg ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8RDSreg;

};

/**
 * The status message of the property "FID_TUN_G_GET_STATIC_LIST"
 * Status response to HMI regarding the Sharx Step.
 */
class FID_TUN_G_GET_STATIC_LISTStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_GET_STATIC_LISTStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_GET_STATIC_LISTStatus (const FID_TUN_G_GET_STATIC_LISTStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_GET_STATIC_LISTStatus (uint8 u8NumofElementsinList_, ::tuner_main_fi_types::T_e8_Tun_ListID e8ListID_, const ::tuner_main_fi_types::T_TunerStaticListElementList& Tun_StaticListElements_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_GET_STATIC_LISTStatus();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_GET_STATIC_LISTStatus& operator = (const FID_TUN_G_GET_STATIC_LISTStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_GET_STATIC_LISTStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_GET_STATIC_LISTStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_GET_STATIC_LISTStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_GET_STATIC_LISTStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8NumofElementsinList"

    static const int kU8NumofElementsinList = 0;

    /**
     * Clears the field "u8NumofElementsinList".
     *
     * The field will be set to its default value. The hasU8NumofElementsinList()
     * method will return false.
     */
    inline void clearU8NumofElementsinList();

    /**
     * Checks whether the field "u8NumofElementsinList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8NumofElementsinList()). Otherwise it will return false.
     */
    inline bool hasU8NumofElementsinList () const;

    /**
     * Returns the value of the member "u8NumofElementsinList".
     *
     *
     *
     * @return The value of the field "u8NumofElementsinList"
     */
    inline uint8 getU8NumofElementsinList () const;

    /**
     * Sets the value of the member "u8NumofElementsinList".
     *
     *
     *
     * @param u8NumofElementsinList The value which will be set
     */
    inline void setU8NumofElementsinList (uint8 u8NumofElementsinList_);

    // API of field "e8ListID"

    static const int kE8ListID = 1;

    /**
     * Clears the field "e8ListID".
     *
     * The field will be set to its default value. The hasE8ListID()
     * method will return false.
     */
    inline void clearE8ListID();

    /**
     * Checks whether the field "e8ListID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ListID()). Otherwise it will return false.
     */
    inline bool hasE8ListID () const;

    /**
     * Returns the value of the member "e8ListID".
     *
     *
     *
     * @return The value of the field "e8ListID"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_ListID getE8ListID () const;

    /**
     * Sets the value of the member "e8ListID".
     *
     *
     *
     * @param e8ListID The value which will be set
     */
    inline void setE8ListID (::tuner_main_fi_types::T_e8_Tun_ListID e8ListID_);

    // API of field "Tun_StaticListElements"

    static const int kTun_StaticListElements = 2;

    /**
     * Clears the field "Tun_StaticListElements".
     *
     * The field will be set to its default value. The hasTun_StaticListElements()
     * method will return false.
     */
    inline void clearTun_StaticListElements();

    /**
     * Checks whether the field "Tun_StaticListElements" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTun_StaticListElements()). Otherwise it will return false.
     */
    inline bool hasTun_StaticListElements () const;

    /**
     * Returns the value of the member "Tun_StaticListElements".
     *
     *
     *
     * @return The value of the field "Tun_StaticListElements"
     */
    inline const ::tuner_main_fi_types::T_TunerStaticListElementList& getTun_StaticListElements () const;

    /**
     * Retrieves the value of the field "Tun_StaticListElements" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Tun_StaticListElements".
     */
    inline ::tuner_main_fi_types::T_TunerStaticListElementList& getTun_StaticListElementsMutable ();

    /**
     * Sets the value of the member "Tun_StaticListElements".
     *
     *
     *
     * @param Tun_StaticListElements The value which will be set
     */
    inline void setTun_StaticListElements (const ::tuner_main_fi_types::T_TunerStaticListElementList& Tun_StaticListElements_);

    static const FID_TUN_G_GET_STATIC_LISTStatus &getDefaultInstance();

private:

    static const ::std::vector< ::tuner_main_fi_types::T_TunerStaticListElement >& getT_TunerStaticListElementList_DefaultInstance ();

    inline void set_has_u8NumofElementsinList ();

    inline void clear_has_u8NumofElementsinList ();

    inline void set_has_e8ListID ();

    inline void clear_has_e8ListID ();

    inline void set_has_Tun_StaticListElements ();

    inline void clear_has_Tun_StaticListElements ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _u8NumofElementsinList;

    ::tuner_main_fi_types::T_e8_Tun_ListID _e8ListID;

    ::tuner_main_fi_types::T_TunerStaticListElementList _Tun_StaticListElements;

};

/**
 * The status message of the property "FID_TUN_G_RADIO_TEXT"
 * This Property delivers latest received Radio text.
 * Status response to Radio text data .
 */
class FID_TUN_G_RADIO_TEXTStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_RADIO_TEXTStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_RADIO_TEXTStatus (const FID_TUN_G_RADIO_TEXTStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_RADIO_TEXTStatus (uint16 u16PICode_, const ::tuner_main_fi_types::T_TunerRadioText& TunerRadioText_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_RADIO_TEXTStatus();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_RADIO_TEXTStatus& operator = (const FID_TUN_G_RADIO_TEXTStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_RADIO_TEXTStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_RADIO_TEXTStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_RADIO_TEXTStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_RADIO_TEXTStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16PICode"

    static const int kU16PICode = 0;

    /**
     * Clears the field "u16PICode".
     *
     * The field will be set to its default value. The hasU16PICode()
     * method will return false.
     */
    inline void clearU16PICode();

    /**
     * Checks whether the field "u16PICode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16PICode()). Otherwise it will return false.
     */
    inline bool hasU16PICode () const;

    /**
     * Returns the value of the member "u16PICode".
     *
     * .
     *
     * @return The value of the field "u16PICode"
     */
    inline uint16 getU16PICode () const;

    /**
     * Sets the value of the member "u16PICode".
     *
     * .
     *
     * @param u16PICode The value which will be set
     */
    inline void setU16PICode (uint16 u16PICode_);

    // API of field "TunerRadioText"

    static const int kTunerRadioText = 1;

    /**
     * Clears the field "TunerRadioText".
     *
     * The field will be set to its default value. The hasTunerRadioText()
     * method will return false.
     */
    inline void clearTunerRadioText();

    /**
     * Checks whether the field "TunerRadioText" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerRadioText()). Otherwise it will return false.
     */
    inline bool hasTunerRadioText () const;

    /**
     * Returns the value of the member "TunerRadioText".
     *
     * .
     *
     * @return The value of the field "TunerRadioText"
     */
    inline const ::tuner_main_fi_types::T_TunerRadioText& getTunerRadioText () const;

    /**
     * Retrieves the value of the field "TunerRadioText" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerRadioText".
     */
    inline ::tuner_main_fi_types::T_TunerRadioText& getTunerRadioTextMutable ();

    /**
     * Sets the value of the member "TunerRadioText".
     *
     * .
     *
     * @param TunerRadioText The value which will be set
     */
    inline void setTunerRadioText (const ::tuner_main_fi_types::T_TunerRadioText& TunerRadioText_);

    static const FID_TUN_G_RADIO_TEXTStatus &getDefaultInstance();

private:

    inline void set_has_u16PICode ();

    inline void clear_has_u16PICode ();

    inline void set_has_TunerRadioText ();

    inline void clear_has_TunerRadioText ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _u16PICode;

    ::tuner_main_fi_types::T_TunerRadioText _TunerRadioText;

};

/**
 * The status message of the property "FID_TUN_G_BAND_PLUS_STATION_INFO"
 * Current band and station info are sent together. This is required if the clients
 * need to synchronise band and frequency information.
 */
class FID_TUN_G_BAND_PLUS_STATION_INFOStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_BAND_PLUS_STATION_INFOStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_BAND_PLUS_STATION_INFOStatus (const FID_TUN_G_BAND_PLUS_STATION_INFOStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_BAND_PLUS_STATION_INFOStatus (const ::tuner_main_fi_types::T_TunerBandAndStationInfo& TunerBandAndStationInfo_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_BAND_PLUS_STATION_INFOStatus();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_BAND_PLUS_STATION_INFOStatus& operator = (const FID_TUN_G_BAND_PLUS_STATION_INFOStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_BAND_PLUS_STATION_INFOStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_BAND_PLUS_STATION_INFOStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_BAND_PLUS_STATION_INFOStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_BAND_PLUS_STATION_INFOStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerBandAndStationInfo"

    static const int kTunerBandAndStationInfo = 0;

    /**
     * Clears the field "TunerBandAndStationInfo".
     *
     * The field will be set to its default value. The hasTunerBandAndStationInfo()
     * method will return false.
     */
    inline void clearTunerBandAndStationInfo();

    /**
     * Checks whether the field "TunerBandAndStationInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerBandAndStationInfo()). Otherwise it will return false.
     */
    inline bool hasTunerBandAndStationInfo () const;

    /**
     * Returns the value of the member "TunerBandAndStationInfo".
     *
     * .
     *
     * @return The value of the field "TunerBandAndStationInfo"
     */
    inline const ::tuner_main_fi_types::T_TunerBandAndStationInfo& getTunerBandAndStationInfo () const;

    /**
     * Retrieves the value of the field "TunerBandAndStationInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerBandAndStationInfo".
     */
    inline ::tuner_main_fi_types::T_TunerBandAndStationInfo& getTunerBandAndStationInfoMutable ();

    /**
     * Sets the value of the member "TunerBandAndStationInfo".
     *
     * .
     *
     * @param TunerBandAndStationInfo The value which will be set
     */
    inline void setTunerBandAndStationInfo (const ::tuner_main_fi_types::T_TunerBandAndStationInfo& TunerBandAndStationInfo_);

    static const FID_TUN_G_BAND_PLUS_STATION_INFOStatus &getDefaultInstance();

private:

    inline void set_has_TunerBandAndStationInfo ();

    inline void clear_has_TunerBandAndStationInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_TunerBandAndStationInfo _TunerBandAndStationInfo;

};

/**
 * The status message of the property "FID_TUN_G_SETUP_DDADDS"
 * Status response to MethodStart FID_TUN_S_SET_ANTENNA.
 */
class FID_TUN_G_SETUP_DDADDSStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_SETUP_DDADDSStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_SETUP_DDADDSStatus (const FID_TUN_G_SETUP_DDADDSStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_SETUP_DDADDSStatus (::tuner_main_fi_types::T_e8_DDADDS_Mode DDADDS_Mode_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_SETUP_DDADDSStatus();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_SETUP_DDADDSStatus& operator = (const FID_TUN_G_SETUP_DDADDSStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_SETUP_DDADDSStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_SETUP_DDADDSStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_SETUP_DDADDSStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_SETUP_DDADDSStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DDADDS_Mode"

    static const int kDDADDS_Mode = 0;

    /**
     * Clears the field "DDADDS_Mode".
     *
     * The field will be set to its default value. The hasDDADDS_Mode()
     * method will return false.
     */
    inline void clearDDADDS_Mode();

    /**
     * Checks whether the field "DDADDS_Mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDDADDS_Mode()). Otherwise it will return false.
     */
    inline bool hasDDADDS_Mode () const;

    /**
     * Returns the value of the member "DDADDS_Mode".
     *
     * .
     *
     * @return The value of the field "DDADDS_Mode"
     */
    inline ::tuner_main_fi_types::T_e8_DDADDS_Mode getDDADDS_Mode () const;

    /**
     * Sets the value of the member "DDADDS_Mode".
     *
     * .
     *
     * @param DDADDS_Mode The value which will be set
     */
    inline void setDDADDS_Mode (::tuner_main_fi_types::T_e8_DDADDS_Mode DDADDS_Mode_);

    static const FID_TUN_G_SETUP_DDADDSStatus &getDefaultInstance();

private:

    inline void set_has_DDADDS_Mode ();

    inline void clear_has_DDADDS_Mode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_e8_DDADDS_Mode _DDADDS_Mode;

};

/**
 * The status message of the property "FID_TUN_G_GET_DATA_TESTMODE_DDADDS"
 * In response when TM_DATA is enabled by using FID_TUN_S_SET_FEATURE this response will be sent every 250 ms
 * with the data of the currently tuned frequency for testmode applications.
 */
class FID_TUN_G_GET_DATA_TESTMODE_DDADDSStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_GET_DATA_TESTMODE_DDADDSStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_GET_DATA_TESTMODE_DDADDSStatus (const FID_TUN_G_GET_DATA_TESTMODE_DDADDSStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_GET_DATA_TESTMODE_DDADDSStatus (const ::tuner_main_fi_types::T_TunerTestModeData_DDADDS& TunerTestModeData_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_GET_DATA_TESTMODE_DDADDSStatus();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_GET_DATA_TESTMODE_DDADDSStatus& operator = (const FID_TUN_G_GET_DATA_TESTMODE_DDADDSStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_GET_DATA_TESTMODE_DDADDSStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_GET_DATA_TESTMODE_DDADDSStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_GET_DATA_TESTMODE_DDADDSStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_GET_DATA_TESTMODE_DDADDSStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerTestModeData"

    static const int kTunerTestModeData = 0;

    /**
     * Clears the field "TunerTestModeData".
     *
     * The field will be set to its default value. The hasTunerTestModeData()
     * method will return false.
     */
    inline void clearTunerTestModeData();

    /**
     * Checks whether the field "TunerTestModeData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerTestModeData()). Otherwise it will return false.
     */
    inline bool hasTunerTestModeData () const;

    /**
     * Returns the value of the member "TunerTestModeData".
     *
     * .
     *
     * @return The value of the field "TunerTestModeData"
     */
    inline const ::tuner_main_fi_types::T_TunerTestModeData_DDADDS& getTunerTestModeData () const;

    /**
     * Retrieves the value of the field "TunerTestModeData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerTestModeData".
     */
    inline ::tuner_main_fi_types::T_TunerTestModeData_DDADDS& getTunerTestModeDataMutable ();

    /**
     * Sets the value of the member "TunerTestModeData".
     *
     * .
     *
     * @param TunerTestModeData The value which will be set
     */
    inline void setTunerTestModeData (const ::tuner_main_fi_types::T_TunerTestModeData_DDADDS& TunerTestModeData_);

    static const FID_TUN_G_GET_DATA_TESTMODE_DDADDSStatus &getDefaultInstance();

private:

    inline void set_has_TunerTestModeData ();

    inline void clear_has_TunerTestModeData ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_TunerTestModeData_DDADDS _TunerTestModeData;

};

/**
 * The status message of the property "FID_TUN_G_TMC_INFO"
 * This property is used to send information about TMC
 * reception from either Tuner 0 or Tuner 1.
 */
class FID_TUN_G_TMC_INFOStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_TMC_INFOStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_TMC_INFOStatus (const FID_TUN_G_TMC_INFOStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_TMC_INFOStatus (uint8 bTMCAvailableFlag_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_TMC_INFOStatus();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_TMC_INFOStatus& operator = (const FID_TUN_G_TMC_INFOStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_TMC_INFOStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_TMC_INFOStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_TMC_INFOStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_TMC_INFOStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bTMCAvailableFlag"

    static const int kBTMCAvailableFlag = 0;

    /**
     * Clears the field "bTMCAvailableFlag".
     *
     * The field will be set to its default value. The hasBTMCAvailableFlag()
     * method will return false.
     */
    inline void clearBTMCAvailableFlag();

    /**
     * Checks whether the field "bTMCAvailableFlag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBTMCAvailableFlag()). Otherwise it will return false.
     */
    inline bool hasBTMCAvailableFlag () const;

    /**
     * Returns the value of the member "bTMCAvailableFlag".
     *
     * This flag indicates if the Radio currently
     * receives usable TMC data.
     * 1 = TMC data is received from Tuner 0 or Tuner 1
     * and Station RDBID matches one from the List sent
     * by Navigation Unit.
     * 0 = Either TMC data not recieved or No matching RDBID.
     *
     * @return The value of the field "bTMCAvailableFlag"
     */
    inline uint8 getBTMCAvailableFlag () const;

    /**
     * Sets the value of the member "bTMCAvailableFlag".
     *
     * This flag indicates if the Radio currently
     * receives usable TMC data.
     * 1 = TMC data is received from Tuner 0 or Tuner 1
     * and Station RDBID matches one from the List sent
     * by Navigation Unit.
     * 0 = Either TMC data not recieved or No matching RDBID.
     *
     * @param bTMCAvailableFlag The value which will be set
     */
    inline void setBTMCAvailableFlag (uint8 bTMCAvailableFlag_);

    static const FID_TUN_G_TMC_INFOStatus &getDefaultInstance();

private:

    inline void set_has_bTMCAvailableFlag ();

    inline void clear_has_bTMCAvailableFlag ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _bTMCAvailableFlag;

};

/**
 * The status message of the property "FID_TUN_G_GET_DATA_TMC"
 * This Property will give RDS groups data of Tuned TMC station.
 */
class FID_TUN_G_GET_DATA_TMCStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_GET_DATA_TMCStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_GET_DATA_TMCStatus (const FID_TUN_G_GET_DATA_TMCStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_GET_DATA_TMCStatus (const ::std::vector< ::tuner_main_fi_types::T_TrafficInfo >& ListOfTrafficInfo_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_GET_DATA_TMCStatus();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_GET_DATA_TMCStatus& operator = (const FID_TUN_G_GET_DATA_TMCStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_GET_DATA_TMCStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_GET_DATA_TMCStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_GET_DATA_TMCStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_GET_DATA_TMCStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ListOfTrafficInfo"

    static const int kListOfTrafficInfo = 0;

    /**
     * Clears the field "ListOfTrafficInfo".
     *
     * The field will be set to its default value. The hasListOfTrafficInfo()
     * method will return false.
     */
    inline void clearListOfTrafficInfo();

    /**
     * Checks whether the field "ListOfTrafficInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListOfTrafficInfo()). Otherwise it will return false.
     */
    inline bool hasListOfTrafficInfo () const;

    /**
     * Returns the value of the member "ListOfTrafficInfo".
     *
     * List of T_TrafficInfo objects, which contain the 8A-group(s)
     * and additional information
     * May be empty, if only CycleStart has to be indicated or only duplication was received for RdbId.
     *
     * @return The value of the field "ListOfTrafficInfo"
     */
    inline const ::std::vector< ::tuner_main_fi_types::T_TrafficInfo >& getListOfTrafficInfo () const;

    /**
     * Retrieves the value of the field "ListOfTrafficInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ListOfTrafficInfo".
     */
    inline ::std::vector< ::tuner_main_fi_types::T_TrafficInfo >& getListOfTrafficInfoMutable ();

    /**
     * Sets the value of the member "ListOfTrafficInfo".
     *
     * List of T_TrafficInfo objects, which contain the 8A-group(s)
     * and additional information
     * May be empty, if only CycleStart has to be indicated or only duplication was received for RdbId.
     *
     * @param ListOfTrafficInfo The value which will be set
     */
    inline void setListOfTrafficInfo (const ::std::vector< ::tuner_main_fi_types::T_TrafficInfo >& ListOfTrafficInfo_);

    static const FID_TUN_G_GET_DATA_TMCStatus &getDefaultInstance();

private:

    static const ::std::vector< ::tuner_main_fi_types::T_TrafficInfo >& getT_TrafficInfoList_DefaultInstance ();

    inline void set_has_ListOfTrafficInfo ();

    inline void clear_has_ListOfTrafficInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::tuner_main_fi_types::T_TrafficInfo > _ListOfTrafficInfo;

};

/**
 * The status message of the property "FID_TUN_G_ATSTATIONINFO"
 * Status response to CM_AtStationinfo .
 */
class FID_TUN_G_ATSTATIONINFOStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_ATSTATIONINFOStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_ATSTATIONINFOStatus (const FID_TUN_G_ATSTATIONINFOStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_ATSTATIONINFOStatus (const ::tuner_main_fi_types::T_Atstationinfo& Atstationinfo_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_ATSTATIONINFOStatus();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_ATSTATIONINFOStatus& operator = (const FID_TUN_G_ATSTATIONINFOStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_ATSTATIONINFOStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_ATSTATIONINFOStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_ATSTATIONINFOStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_ATSTATIONINFOStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Atstationinfo"

    static const int kAtstationinfo = 0;

    /**
     * Clears the field "Atstationinfo".
     *
     * The field will be set to its default value. The hasAtstationinfo()
     * method will return false.
     */
    inline void clearAtstationinfo();

    /**
     * Checks whether the field "Atstationinfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAtstationinfo()). Otherwise it will return false.
     */
    inline bool hasAtstationinfo () const;

    /**
     * Returns the value of the member "Atstationinfo".
     *
     * .
     *
     * @return The value of the field "Atstationinfo"
     */
    inline const ::tuner_main_fi_types::T_Atstationinfo& getAtstationinfo () const;

    /**
     * Retrieves the value of the field "Atstationinfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Atstationinfo".
     */
    inline ::tuner_main_fi_types::T_Atstationinfo& getAtstationinfoMutable ();

    /**
     * Sets the value of the member "Atstationinfo".
     *
     * .
     *
     * @param Atstationinfo The value which will be set
     */
    inline void setAtstationinfo (const ::tuner_main_fi_types::T_Atstationinfo& Atstationinfo_);

    static const FID_TUN_G_ATSTATIONINFOStatus &getDefaultInstance();

private:

    inline void set_has_Atstationinfo ();

    inline void clear_has_Atstationinfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_Atstationinfo _Atstationinfo;

};

/**
 * The status message of the property "FID_TUN_G_ATSEEK"
 * Status Response
 */
class FID_TUN_G_ATSEEKStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_ATSEEKStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_ATSEEKStatus (const FID_TUN_G_ATSEEKStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_ATSEEKStatus (::tuner_main_fi_types::T_e8_Tun_TunerSeek e8SeekState_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_ATSEEKStatus();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_ATSEEKStatus& operator = (const FID_TUN_G_ATSEEKStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_ATSEEKStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_ATSEEKStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_ATSEEKStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_ATSEEKStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8SeekState"

    static const int kE8SeekState = 0;

    /**
     * Clears the field "e8SeekState".
     *
     * The field will be set to its default value. The hasE8SeekState()
     * method will return false.
     */
    inline void clearE8SeekState();

    /**
     * Checks whether the field "e8SeekState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8SeekState()). Otherwise it will return false.
     */
    inline bool hasE8SeekState () const;

    /**
     * Returns the value of the member "e8SeekState".
     *
     * .
     *
     * @return The value of the field "e8SeekState"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_TunerSeek getE8SeekState () const;

    /**
     * Sets the value of the member "e8SeekState".
     *
     * .
     *
     * @param e8SeekState The value which will be set
     */
    inline void setE8SeekState (::tuner_main_fi_types::T_e8_Tun_TunerSeek e8SeekState_);

    static const FID_TUN_G_ATSEEKStatus &getDefaultInstance();

private:

    inline void set_has_e8SeekState ();

    inline void clear_has_e8SeekState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_e8_Tun_TunerSeek _e8SeekState;

};

/**
 * The status message of the property "FID_TUN_G_DIAG_REMOTE_CONTROL"
 * Status response indicating if remote control session is ON or OFF .
 */
class FID_TUN_G_DIAG_REMOTE_CONTROLStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_DIAG_REMOTE_CONTROLStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_DIAG_REMOTE_CONTROLStatus (const FID_TUN_G_DIAG_REMOTE_CONTROLStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_DIAG_REMOTE_CONTROLStatus (bool bRemoteCtrl_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_DIAG_REMOTE_CONTROLStatus();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_DIAG_REMOTE_CONTROLStatus& operator = (const FID_TUN_G_DIAG_REMOTE_CONTROLStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_DIAG_REMOTE_CONTROLStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_DIAG_REMOTE_CONTROLStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_DIAG_REMOTE_CONTROLStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_DIAG_REMOTE_CONTROLStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bRemoteCtrl"

    static const int kBRemoteCtrl = 0;

    /**
     * Clears the field "bRemoteCtrl".
     *
     * The field will be set to its default value. The hasBRemoteCtrl()
     * method will return false.
     */
    inline void clearBRemoteCtrl();

    /**
     * Checks whether the field "bRemoteCtrl" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBRemoteCtrl()). Otherwise it will return false.
     */
    inline bool hasBRemoteCtrl () const;

    /**
     * Returns the value of the member "bRemoteCtrl".
     *
     * Indicates if diag remote control session is ON or OFF
     *
     * @return The value of the field "bRemoteCtrl"
     */
    inline bool getBRemoteCtrl () const;

    /**
     * Sets the value of the member "bRemoteCtrl".
     *
     * Indicates if diag remote control session is ON or OFF
     *
     * @param bRemoteCtrl The value which will be set
     */
    inline void setBRemoteCtrl (bool bRemoteCtrl_);

    static const FID_TUN_G_DIAG_REMOTE_CONTROLStatus &getDefaultInstance();

private:

    inline void set_has_bRemoteCtrl ();

    inline void clear_has_bRemoteCtrl ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bRemoteCtrl;

};

/**
 * The status message of the property "FID_TUN_G_RdbIdActualList"
 * With this property the FC_TmcTuner informs FC_TIMA,
 * which RDB-IDs are received at the moment. So FC_TIMA is always
 * notified, if something changes with the received radio programs.
 */
class FID_TUN_G_RdbIdActualListStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_RdbIdActualListStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_RdbIdActualListStatus (const FID_TUN_G_RdbIdActualListStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_RdbIdActualListStatus (const ::std::vector< ::tuner_main_fi_types::T_TunerRdbId >& ListOfRdbIds_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_RdbIdActualListStatus();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_RdbIdActualListStatus& operator = (const FID_TUN_G_RdbIdActualListStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_RdbIdActualListStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_RdbIdActualListStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_RdbIdActualListStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_RdbIdActualListStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ListOfRdbIds"

    static const int kListOfRdbIds = 0;

    /**
     * Clears the field "ListOfRdbIds".
     *
     * The field will be set to its default value. The hasListOfRdbIds()
     * method will return false.
     */
    inline void clearListOfRdbIds();

    /**
     * Checks whether the field "ListOfRdbIds" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListOfRdbIds()). Otherwise it will return false.
     */
    inline bool hasListOfRdbIds () const;

    /**
     * Returns the value of the member "ListOfRdbIds".
     *
     * List of T_TunerRdbId objects, which are currently received by
     * FC_TmcTuner
     *
     * @return The value of the field "ListOfRdbIds"
     */
    inline const ::std::vector< ::tuner_main_fi_types::T_TunerRdbId >& getListOfRdbIds () const;

    /**
     * Retrieves the value of the field "ListOfRdbIds" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ListOfRdbIds".
     */
    inline ::std::vector< ::tuner_main_fi_types::T_TunerRdbId >& getListOfRdbIdsMutable ();

    /**
     * Sets the value of the member "ListOfRdbIds".
     *
     * List of T_TunerRdbId objects, which are currently received by
     * FC_TmcTuner
     *
     * @param ListOfRdbIds The value which will be set
     */
    inline void setListOfRdbIds (const ::std::vector< ::tuner_main_fi_types::T_TunerRdbId >& ListOfRdbIds_);

    static const FID_TUN_G_RdbIdActualListStatus &getDefaultInstance();

private:

    static const ::std::vector< ::tuner_main_fi_types::T_TunerRdbId >& getT_TunerRdbIdList_DefaultInstance ();

    inline void set_has_ListOfRdbIds ();

    inline void clear_has_ListOfRdbIds ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::tuner_main_fi_types::T_TunerRdbId > _ListOfRdbIds;

};

/**
 * The status message of the property "FID_TUN_G_SET_RDS"
 * Status response to HMI regarding the RDS switch.
 */
class FID_TUN_G_SET_RDSStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_SET_RDSStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_SET_RDSStatus (const FID_TUN_G_SET_RDSStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_SET_RDSStatus (uint8 u8RDS_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_SET_RDSStatus();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_SET_RDSStatus& operator = (const FID_TUN_G_SET_RDSStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_SET_RDSStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_SET_RDSStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_SET_RDSStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_SET_RDSStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8RDS"

    static const int kU8RDS = 0;

    /**
     * Clears the field "u8RDS".
     *
     * The field will be set to its default value. The hasU8RDS()
     * method will return false.
     */
    inline void clearU8RDS();

    /**
     * Checks whether the field "u8RDS" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8RDS()). Otherwise it will return false.
     */
    inline bool hasU8RDS () const;

    /**
     * Returns the value of the member "u8RDS".
     *
     *
     *
     * @return The value of the field "u8RDS"
     */
    inline uint8 getU8RDS () const;

    /**
     * Sets the value of the member "u8RDS".
     *
     *
     *
     * @param u8RDS The value which will be set
     */
    inline void setU8RDS (uint8 u8RDS_);

    static const FID_TUN_G_SET_RDSStatus &getDefaultInstance();

private:

    inline void set_has_u8RDS ();

    inline void clear_has_u8RDS ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8RDS;

};

/**
 * The status message of the property "FID_TUN_G_SET_ENGG_PARAMETER"
 * Status response to HMI regarding the Engineering parameter value.
 */
class FID_TUN_G_SET_ENGG_PARAMETERStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_SET_ENGG_PARAMETERStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_SET_ENGG_PARAMETERStatus (const FID_TUN_G_SET_ENGG_PARAMETERStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_SET_ENGG_PARAMETERStatus (::tuner_main_fi_types::T_e8_Tun_Engg_Param_ID e8ParameterID_, uint32 u32ParameterValue_, const ::std::vector< ::tuner_main_fi_types::T_Tun_Engg_Param_List_Elem >& ListOfEnggParamValues_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_SET_ENGG_PARAMETERStatus();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_SET_ENGG_PARAMETERStatus& operator = (const FID_TUN_G_SET_ENGG_PARAMETERStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_SET_ENGG_PARAMETERStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_SET_ENGG_PARAMETERStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_SET_ENGG_PARAMETERStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_SET_ENGG_PARAMETERStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ParameterID"

    static const int kE8ParameterID = 0;

    /**
     * Clears the field "e8ParameterID".
     *
     * The field will be set to its default value. The hasE8ParameterID()
     * method will return false.
     */
    inline void clearE8ParameterID();

    /**
     * Checks whether the field "e8ParameterID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ParameterID()). Otherwise it will return false.
     */
    inline bool hasE8ParameterID () const;

    /**
     * Returns the value of the member "e8ParameterID".
     *
     * This Parameter indicates which Engg Parameter was selected for modification
     *
     * @return The value of the field "e8ParameterID"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_Engg_Param_ID getE8ParameterID () const;

    /**
     * Sets the value of the member "e8ParameterID".
     *
     * This Parameter indicates which Engg Parameter was selected for modification
     *
     * @param e8ParameterID The value which will be set
     */
    inline void setE8ParameterID (::tuner_main_fi_types::T_e8_Tun_Engg_Param_ID e8ParameterID_);

    // API of field "u32ParameterValue"

    static const int kU32ParameterValue = 1;

    /**
     * Clears the field "u32ParameterValue".
     *
     * The field will be set to its default value. The hasU32ParameterValue()
     * method will return false.
     */
    inline void clearU32ParameterValue();

    /**
     * Checks whether the field "u32ParameterValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ParameterValue()). Otherwise it will return false.
     */
    inline bool hasU32ParameterValue () const;

    /**
     * Returns the value of the member "u32ParameterValue".
     *
     * The value set to the Engineering Parameter selected for modification.
     * This paramter is to be used only if e8ParameterID != 0xFF.
     *
     * @return The value of the field "u32ParameterValue"
     */
    inline uint32 getU32ParameterValue () const;

    /**
     * Sets the value of the member "u32ParameterValue".
     *
     * The value set to the Engineering Parameter selected for modification.
     * This paramter is to be used only if e8ParameterID != 0xFF.
     *
     * @param u32ParameterValue The value which will be set
     */
    inline void setU32ParameterValue (uint32 u32ParameterValue_);

    // API of field "ListOfEnggParamValues"

    static const int kListOfEnggParamValues = 2;

    /**
     * Clears the field "ListOfEnggParamValues".
     *
     * The field will be set to its default value. The hasListOfEnggParamValues()
     * method will return false.
     */
    inline void clearListOfEnggParamValues();

    /**
     * Checks whether the field "ListOfEnggParamValues" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListOfEnggParamValues()). Otherwise it will return false.
     */
    inline bool hasListOfEnggParamValues () const;

    /**
     * Returns the value of the member "ListOfEnggParamValues".
     *
     * List of u32 engineering Parameter values.
     * This parameter is to be used only if the e8ParameterID = 0xFF.
     * Otherwise use u32ParameterValue.
     *
     * @return The value of the field "ListOfEnggParamValues"
     */
    inline const ::std::vector< ::tuner_main_fi_types::T_Tun_Engg_Param_List_Elem >& getListOfEnggParamValues () const;

    /**
     * Retrieves the value of the field "ListOfEnggParamValues" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ListOfEnggParamValues".
     */
    inline ::std::vector< ::tuner_main_fi_types::T_Tun_Engg_Param_List_Elem >& getListOfEnggParamValuesMutable ();

    /**
     * Sets the value of the member "ListOfEnggParamValues".
     *
     * List of u32 engineering Parameter values.
     * This parameter is to be used only if the e8ParameterID = 0xFF.
     * Otherwise use u32ParameterValue.
     *
     * @param ListOfEnggParamValues The value which will be set
     */
    inline void setListOfEnggParamValues (const ::std::vector< ::tuner_main_fi_types::T_Tun_Engg_Param_List_Elem >& ListOfEnggParamValues_);

    static const FID_TUN_G_SET_ENGG_PARAMETERStatus &getDefaultInstance();

private:

    static const ::std::vector< ::tuner_main_fi_types::T_Tun_Engg_Param_List_Elem >& getT_Tun_Engg_Param_List_ElemList_DefaultInstance ();

    inline void set_has_e8ParameterID ();

    inline void clear_has_e8ParameterID ();

    inline void set_has_u32ParameterValue ();

    inline void clear_has_u32ParameterValue ();

    inline void set_has_ListOfEnggParamValues ();

    inline void clear_has_ListOfEnggParamValues ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::tuner_main_fi_types::T_e8_Tun_Engg_Param_ID _e8ParameterID;

    uint32 _u32ParameterValue;

    ::std::vector< ::tuner_main_fi_types::T_Tun_Engg_Param_List_Elem > _ListOfEnggParamValues;

};

/**
 * The get message of the property "FID_TUN_G_SET_ENGG_PARAMETER"
 * Status response to HMI regarding the Engineering parameter value.
 */
class FID_TUN_G_SET_ENGG_PARAMETERGet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_SET_ENGG_PARAMETERGet ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_SET_ENGG_PARAMETERGet (const FID_TUN_G_SET_ENGG_PARAMETERGet &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_SET_ENGG_PARAMETERGet (::tuner_main_fi_types::T_e8_Tun_Engg_Param_ID e8ParameterID_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_SET_ENGG_PARAMETERGet();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_SET_ENGG_PARAMETERGet& operator = (const FID_TUN_G_SET_ENGG_PARAMETERGet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_SET_ENGG_PARAMETERGet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_SET_ENGG_PARAMETERGet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_SET_ENGG_PARAMETERGet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_SET_ENGG_PARAMETERGet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ParameterID"

    static const int kE8ParameterID = 0;

    /**
     * Clears the field "e8ParameterID".
     *
     * The field will be set to its default value. The hasE8ParameterID()
     * method will return false.
     */
    inline void clearE8ParameterID();

    /**
     * Checks whether the field "e8ParameterID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ParameterID()). Otherwise it will return false.
     */
    inline bool hasE8ParameterID () const;

    /**
     * Returns the value of the member "e8ParameterID".
     *
     * Engg Parameter whos value is to be obtained.
     *
     * @return The value of the field "e8ParameterID"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_Engg_Param_ID getE8ParameterID () const;

    /**
     * Sets the value of the member "e8ParameterID".
     *
     * Engg Parameter whos value is to be obtained.
     *
     * @param e8ParameterID The value which will be set
     */
    inline void setE8ParameterID (::tuner_main_fi_types::T_e8_Tun_Engg_Param_ID e8ParameterID_);

    static const FID_TUN_G_SET_ENGG_PARAMETERGet &getDefaultInstance();

private:

    inline void set_has_e8ParameterID ();

    inline void clear_has_e8ParameterID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_e8_Tun_Engg_Param_ID _e8ParameterID;

};

/**
 * The status message of the property "FID_TUN_G_SET_TUNING_ACTION_CONFIG"
 * Status response to HMI regarding the Tuner Configuration Parameters values.
 */
class FID_TUN_G_SET_TUNING_ACTION_CONFIGStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_SET_TUNING_ACTION_CONFIGStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_SET_TUNING_ACTION_CONFIGStatus (const FID_TUN_G_SET_TUNING_ACTION_CONFIGStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_SET_TUNING_ACTION_CONFIGStatus (const ::std::vector< ::tuner_main_fi_types::T_TuningActionConfigParam >& ListOfTuningActionConfigParameters_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_SET_TUNING_ACTION_CONFIGStatus();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_SET_TUNING_ACTION_CONFIGStatus& operator = (const FID_TUN_G_SET_TUNING_ACTION_CONFIGStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_SET_TUNING_ACTION_CONFIGStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_SET_TUNING_ACTION_CONFIGStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_SET_TUNING_ACTION_CONFIGStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_SET_TUNING_ACTION_CONFIGStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ListOfTuningActionConfigParameters"

    static const int kListOfTuningActionConfigParameters = 0;

    /**
     * Clears the field "ListOfTuningActionConfigParameters".
     *
     * The field will be set to its default value. The hasListOfTuningActionConfigParameters()
     * method will return false.
     */
    inline void clearListOfTuningActionConfigParameters();

    /**
     * Checks whether the field "ListOfTuningActionConfigParameters" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListOfTuningActionConfigParameters()). Otherwise it will return false.
     */
    inline bool hasListOfTuningActionConfigParameters () const;

    /**
     * Returns the value of the member "ListOfTuningActionConfigParameters".
     *
     * List of T_TuningActionConfigParam objects, which contains various
     * configurable parameters and their value.
     *
     * @return The value of the field "ListOfTuningActionConfigParameters"
     */
    inline const ::std::vector< ::tuner_main_fi_types::T_TuningActionConfigParam >& getListOfTuningActionConfigParameters () const;

    /**
     * Retrieves the value of the field "ListOfTuningActionConfigParameters" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ListOfTuningActionConfigParameters".
     */
    inline ::std::vector< ::tuner_main_fi_types::T_TuningActionConfigParam >& getListOfTuningActionConfigParametersMutable ();

    /**
     * Sets the value of the member "ListOfTuningActionConfigParameters".
     *
     * List of T_TuningActionConfigParam objects, which contains various
     * configurable parameters and their value.
     *
     * @param ListOfTuningActionConfigParameters The value which will be set
     */
    inline void setListOfTuningActionConfigParameters (const ::std::vector< ::tuner_main_fi_types::T_TuningActionConfigParam >& ListOfTuningActionConfigParameters_);

    static const FID_TUN_G_SET_TUNING_ACTION_CONFIGStatus &getDefaultInstance();

private:

    static const ::std::vector< ::tuner_main_fi_types::T_TuningActionConfigParam >& getT_TuningActionConfigParamList_DefaultInstance ();

    inline void set_has_ListOfTuningActionConfigParameters ();

    inline void clear_has_ListOfTuningActionConfigParameters ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::tuner_main_fi_types::T_TuningActionConfigParam > _ListOfTuningActionConfigParameters;

};

/**
 * The get message of the property "FID_TUN_G_SET_TUNING_ACTION_CONFIG"
 * Status response to HMI regarding the Tuner Configuration Parameters values.
 */
class FID_TUN_G_SET_TUNING_ACTION_CONFIGGet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_SET_TUNING_ACTION_CONFIGGet ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_SET_TUNING_ACTION_CONFIGGet (const FID_TUN_G_SET_TUNING_ACTION_CONFIGGet &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_SET_TUNING_ACTION_CONFIGGet (::tuner_main_fi_types::T_e8_Tun_ConfigParam_Type e8ConfigParamType_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_SET_TUNING_ACTION_CONFIGGet();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_SET_TUNING_ACTION_CONFIGGet& operator = (const FID_TUN_G_SET_TUNING_ACTION_CONFIGGet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_SET_TUNING_ACTION_CONFIGGet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_SET_TUNING_ACTION_CONFIGGet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_SET_TUNING_ACTION_CONFIGGet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_SET_TUNING_ACTION_CONFIGGet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ConfigParamType"

    static const int kE8ConfigParamType = 0;

    /**
     * Clears the field "e8ConfigParamType".
     *
     * The field will be set to its default value. The hasE8ConfigParamType()
     * method will return false.
     */
    inline void clearE8ConfigParamType();

    /**
     * Checks whether the field "e8ConfigParamType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ConfigParamType()). Otherwise it will return false.
     */
    inline bool hasE8ConfigParamType () const;

    /**
     * Returns the value of the member "e8ConfigParamType".
     *
     * This Parameter whose value is to be fetched
     *
     * @return The value of the field "e8ConfigParamType"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_ConfigParam_Type getE8ConfigParamType () const;

    /**
     * Sets the value of the member "e8ConfigParamType".
     *
     * This Parameter whose value is to be fetched
     *
     * @param e8ConfigParamType The value which will be set
     */
    inline void setE8ConfigParamType (::tuner_main_fi_types::T_e8_Tun_ConfigParam_Type e8ConfigParamType_);

    static const FID_TUN_G_SET_TUNING_ACTION_CONFIGGet &getDefaultInstance();

private:

    inline void set_has_e8ConfigParamType ();

    inline void clear_has_e8ConfigParamType ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_e8_Tun_ConfigParam_Type _e8ConfigParamType;

};

/**
 * The status message of the property "FID_TUN_G_ANNOUNCEMENT_MESSAGE"
 * Notifies the start or end of an announcement
 */
class FID_TUN_G_ANNOUNCEMENT_MESSAGEStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_ANNOUNCEMENT_MESSAGEStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_ANNOUNCEMENT_MESSAGEStatus (const FID_TUN_G_ANNOUNCEMENT_MESSAGEStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_ANNOUNCEMENT_MESSAGEStatus (::tuner_main_fi_types::T_e8_Anno_Message e8AnnoMessage_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_ANNOUNCEMENT_MESSAGEStatus();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_ANNOUNCEMENT_MESSAGEStatus& operator = (const FID_TUN_G_ANNOUNCEMENT_MESSAGEStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_ANNOUNCEMENT_MESSAGEStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_ANNOUNCEMENT_MESSAGEStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_ANNOUNCEMENT_MESSAGEStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_ANNOUNCEMENT_MESSAGEStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8AnnoMessage"

    static const int kE8AnnoMessage = 0;

    /**
     * Clears the field "e8AnnoMessage".
     *
     * The field will be set to its default value. The hasE8AnnoMessage()
     * method will return false.
     */
    inline void clearE8AnnoMessage();

    /**
     * Checks whether the field "e8AnnoMessage" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8AnnoMessage()). Otherwise it will return false.
     */
    inline bool hasE8AnnoMessage () const;

    /**
     * Returns the value of the member "e8AnnoMessage".
     *
     * Indicates the type of Announcement active
     *
     * @return The value of the field "e8AnnoMessage"
     */
    inline ::tuner_main_fi_types::T_e8_Anno_Message getE8AnnoMessage () const;

    /**
     * Sets the value of the member "e8AnnoMessage".
     *
     * Indicates the type of Announcement active
     *
     * @param e8AnnoMessage The value which will be set
     */
    inline void setE8AnnoMessage (::tuner_main_fi_types::T_e8_Anno_Message e8AnnoMessage_);

    static const FID_TUN_G_ANNOUNCEMENT_MESSAGEStatus &getDefaultInstance();

private:

    inline void set_has_e8AnnoMessage ();

    inline void clear_has_e8AnnoMessage ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_e8_Anno_Message _e8AnnoMessage;

};

/**
 * The status message of the property "FID_TUN_G_ANNOUNCEMENT_INFO"
 * Provides the frequency, PI and stationname of the announcement station
 */
class FID_TUN_G_ANNOUNCEMENT_INFOStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_ANNOUNCEMENT_INFOStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_ANNOUNCEMENT_INFOStatus (const FID_TUN_G_ANNOUNCEMENT_INFOStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_ANNOUNCEMENT_INFOStatus (const ::tuner_main_fi_types::T_AnnoInfostatus& AnnoInfoStatus_, const ::tuner_main_fi_types::T_b8_Anno_Message& b8AnnoTypes_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_ANNOUNCEMENT_INFOStatus();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_ANNOUNCEMENT_INFOStatus& operator = (const FID_TUN_G_ANNOUNCEMENT_INFOStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_ANNOUNCEMENT_INFOStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_ANNOUNCEMENT_INFOStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_ANNOUNCEMENT_INFOStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_ANNOUNCEMENT_INFOStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AnnoInfoStatus"

    static const int kAnnoInfoStatus = 0;

    /**
     * Clears the field "AnnoInfoStatus".
     *
     * The field will be set to its default value. The hasAnnoInfoStatus()
     * method will return false.
     */
    inline void clearAnnoInfoStatus();

    /**
     * Checks whether the field "AnnoInfoStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAnnoInfoStatus()). Otherwise it will return false.
     */
    inline bool hasAnnoInfoStatus () const;

    /**
     * Returns the value of the member "AnnoInfoStatus".
     *
     * Provides the station info of the currently received by the given audio tuner or
     * currently surveilled by background
     *
     * @return The value of the field "AnnoInfoStatus"
     */
    inline const ::tuner_main_fi_types::T_AnnoInfostatus& getAnnoInfoStatus () const;

    /**
     * Retrieves the value of the field "AnnoInfoStatus" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AnnoInfoStatus".
     */
    inline ::tuner_main_fi_types::T_AnnoInfostatus& getAnnoInfoStatusMutable ();

    /**
     * Sets the value of the member "AnnoInfoStatus".
     *
     * Provides the station info of the currently received by the given audio tuner or
     * currently surveilled by background
     *
     * @param AnnoInfoStatus The value which will be set
     */
    inline void setAnnoInfoStatus (const ::tuner_main_fi_types::T_AnnoInfostatus& AnnoInfoStatus_);

    // API of field "b8AnnoTypes"

    static const int kB8AnnoTypes = 1;

    /**
     * Clears the field "b8AnnoTypes".
     *
     * The field will be set to its default value. The hasB8AnnoTypes()
     * method will return false.
     */
    inline void clearB8AnnoTypes();

    /**
     * Checks whether the field "b8AnnoTypes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setB8AnnoTypes()). Otherwise it will return false.
     */
    inline bool hasB8AnnoTypes () const;

    /**
     * Returns the value of the member "b8AnnoTypes".
     *
     * 0: TA
     * 1: PTY31
     *
     * @return The value of the field "b8AnnoTypes"
     */
    inline const ::tuner_main_fi_types::T_b8_Anno_Message& getB8AnnoTypes () const;

    /**
     * Retrieves the value of the field "b8AnnoTypes" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "b8AnnoTypes".
     */
    inline ::tuner_main_fi_types::T_b8_Anno_Message& getB8AnnoTypesMutable ();

    /**
     * Sets the value of the member "b8AnnoTypes".
     *
     * 0: TA
     * 1: PTY31
     *
     * @param b8AnnoTypes The value which will be set
     */
    inline void setB8AnnoTypes (const ::tuner_main_fi_types::T_b8_Anno_Message& b8AnnoTypes_);

    static const FID_TUN_G_ANNOUNCEMENT_INFOStatus &getDefaultInstance();

private:

    inline void set_has_AnnoInfoStatus ();

    inline void clear_has_AnnoInfoStatus ();

    inline void set_has_b8AnnoTypes ();

    inline void clear_has_b8AnnoTypes ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::tuner_main_fi_types::T_AnnoInfostatus _AnnoInfoStatus;

    ::tuner_main_fi_types::T_b8_Anno_Message _b8AnnoTypes;

};

/**
 * The status message of the property "FID_TUN_G_ANNOUNCEMENT_SWITCH"
 * Provides the TP/PTY announcement switch status
 */
class FID_TUN_G_ANNOUNCEMENT_SWITCHStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_ANNOUNCEMENT_SWITCHStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_ANNOUNCEMENT_SWITCHStatus (const FID_TUN_G_ANNOUNCEMENT_SWITCHStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_ANNOUNCEMENT_SWITCHStatus (bool bTPState_, bool bPTYState_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_ANNOUNCEMENT_SWITCHStatus();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_ANNOUNCEMENT_SWITCHStatus& operator = (const FID_TUN_G_ANNOUNCEMENT_SWITCHStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_ANNOUNCEMENT_SWITCHStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_ANNOUNCEMENT_SWITCHStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_ANNOUNCEMENT_SWITCHStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_ANNOUNCEMENT_SWITCHStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bTPState"

    static const int kBTPState = 0;

    /**
     * Clears the field "bTPState".
     *
     * The field will be set to its default value. The hasBTPState()
     * method will return false.
     */
    inline void clearBTPState();

    /**
     * Checks whether the field "bTPState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBTPState()). Otherwise it will return false.
     */
    inline bool hasBTPState () const;

    /**
     * Returns the value of the member "bTPState".
     *
     * 0: OFF
     * 1: ON
     *
     * @return The value of the field "bTPState"
     */
    inline bool getBTPState () const;

    /**
     * Sets the value of the member "bTPState".
     *
     * 0: OFF
     * 1: ON
     *
     * @param bTPState The value which will be set
     */
    inline void setBTPState (bool bTPState_);

    // API of field "bPTYState"

    static const int kBPTYState = 1;

    /**
     * Clears the field "bPTYState".
     *
     * The field will be set to its default value. The hasBPTYState()
     * method will return false.
     */
    inline void clearBPTYState();

    /**
     * Checks whether the field "bPTYState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBPTYState()). Otherwise it will return false.
     */
    inline bool hasBPTYState () const;

    /**
     * Returns the value of the member "bPTYState".
     *
     * 0: OFF
     * 1: ON
     *
     * @return The value of the field "bPTYState"
     */
    inline bool getBPTYState () const;

    /**
     * Sets the value of the member "bPTYState".
     *
     * 0: OFF
     * 1: ON
     *
     * @param bPTYState The value which will be set
     */
    inline void setBPTYState (bool bPTYState_);

    static const FID_TUN_G_ANNOUNCEMENT_SWITCHStatus &getDefaultInstance();

private:

    inline void set_has_bTPState ();

    inline void clear_has_bTPState ();

    inline void set_has_bPTYState ();

    inline void clear_has_bPTYState ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _bTPState;

    bool _bPTYState;

};

/**
 * The status message of the property "FID_TUN_G_PI_PS_RELATION"
 * PI PS Relation status message
 */
class FID_TUN_G_PI_PS_RELATIONStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_PI_PS_RELATIONStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_PI_PS_RELATIONStatus (const FID_TUN_G_PI_PS_RELATIONStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_PI_PS_RELATIONStatus (uint16 u16PI_, const ::std::string& sPSName_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_PI_PS_RELATIONStatus();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_PI_PS_RELATIONStatus& operator = (const FID_TUN_G_PI_PS_RELATIONStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_PI_PS_RELATIONStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_PI_PS_RELATIONStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_PI_PS_RELATIONStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_PI_PS_RELATIONStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16PI"

    static const int kU16PI = 0;

    /**
     * Clears the field "u16PI".
     *
     * The field will be set to its default value. The hasU16PI()
     * method will return false.
     */
    inline void clearU16PI();

    /**
     * Checks whether the field "u16PI" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16PI()). Otherwise it will return false.
     */
    inline bool hasU16PI () const;

    /**
     * Returns the value of the member "u16PI".
     *
     *
     *
     * @return The value of the field "u16PI"
     */
    inline uint16 getU16PI () const;

    /**
     * Sets the value of the member "u16PI".
     *
     *
     *
     * @param u16PI The value which will be set
     */
    inline void setU16PI (uint16 u16PI_);

    // API of field "sPSName"

    static const int kSPSName = 1;

    /**
     * Clears the field "sPSName".
     *
     * The field will be set to its default value. The hasSPSName()
     * method will return false.
     */
    inline void clearSPSName();

    /**
     * Checks whether the field "sPSName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSPSName()). Otherwise it will return false.
     */
    inline bool hasSPSName () const;

    /**
     * Returns the value of the member "sPSName".
     *
     * Gives the PSName of the station in UTF8 Format. Max Length: 32 + 1
     *
     * @return The value of the field "sPSName"
     */
    inline const ::std::string& getSPSName () const;

    /**
     * Retrieves the value of the field "sPSName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sPSName".
     */
    inline ::std::string& getSPSNameMutable ();

    /**
     * Sets the value of the member "sPSName".
     *
     * Gives the PSName of the station in UTF8 Format. Max Length: 32 + 1
     *
     * @param sPSName The value which will be set
     */
    inline void setSPSName (const ::std::string& sPSName_);

    /**
     * Sets the value of the member "sPSName".
     *
     * Gives the PSName of the station in UTF8 Format. Max Length: 32 + 1
     *
     * @param sPSName The value which will be set
     */
    inline void setSPSName (const char* sPSName_);

    /**
     * Sets the value of the member "sPSName".
     *
     * Gives the PSName of the station in UTF8 Format. Max Length: 32 + 1
     *
     * @param sPSName The value which will be set
     */
    inline void setSPSName (const char* value, size_t size);

    static const FID_TUN_G_PI_PS_RELATIONStatus &getDefaultInstance();

private:

    inline void set_has_u16PI ();

    inline void clear_has_u16PI ();

    inline void set_has_sPSName ();

    inline void clear_has_sPSName ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _u16PI;

    ::std::string _sPSName;

};

/**
 * The status message of the property "FID_TUN_G_AVAILABLE_BAND_RANGE"
 * Provides Range of Available Bands as status msg
 */
class FID_TUN_G_AVAILABLE_BAND_RANGEStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_AVAILABLE_BAND_RANGEStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_AVAILABLE_BAND_RANGEStatus (const FID_TUN_G_AVAILABLE_BAND_RANGEStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_AVAILABLE_BAND_RANGEStatus (uint32 u32AvailableBands_, const ::tuner_main_fi_types::T_AvailableBandInfoList& TunerAvailableBandInfoList_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_AVAILABLE_BAND_RANGEStatus();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_AVAILABLE_BAND_RANGEStatus& operator = (const FID_TUN_G_AVAILABLE_BAND_RANGEStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_AVAILABLE_BAND_RANGEStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_AVAILABLE_BAND_RANGEStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_AVAILABLE_BAND_RANGEStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_AVAILABLE_BAND_RANGEStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32AvailableBands"

    static const int kU32AvailableBands = 0;

    /**
     * Clears the field "u32AvailableBands".
     *
     * The field will be set to its default value. The hasU32AvailableBands()
     * method will return false.
     */
    inline void clearU32AvailableBands();

    /**
     * Checks whether the field "u32AvailableBands" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32AvailableBands()). Otherwise it will return false.
     */
    inline bool hasU32AvailableBands () const;

    /**
     * Returns the value of the member "u32AvailableBands".
     *
     *
     *
     * @return The value of the field "u32AvailableBands"
     */
    inline uint32 getU32AvailableBands () const;

    /**
     * Sets the value of the member "u32AvailableBands".
     *
     *
     *
     * @param u32AvailableBands The value which will be set
     */
    inline void setU32AvailableBands (uint32 u32AvailableBands_);

    // API of field "TunerAvailableBandInfoList"

    static const int kTunerAvailableBandInfoList = 1;

    /**
     * Clears the field "TunerAvailableBandInfoList".
     *
     * The field will be set to its default value. The hasTunerAvailableBandInfoList()
     * method will return false.
     */
    inline void clearTunerAvailableBandInfoList();

    /**
     * Checks whether the field "TunerAvailableBandInfoList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerAvailableBandInfoList()). Otherwise it will return false.
     */
    inline bool hasTunerAvailableBandInfoList () const;

    /**
     * Returns the value of the member "TunerAvailableBandInfoList".
     *
     * Provides list info regarding the available bands
     *
     * @return The value of the field "TunerAvailableBandInfoList"
     */
    inline const ::tuner_main_fi_types::T_AvailableBandInfoList& getTunerAvailableBandInfoList () const;

    /**
     * Retrieves the value of the field "TunerAvailableBandInfoList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerAvailableBandInfoList".
     */
    inline ::tuner_main_fi_types::T_AvailableBandInfoList& getTunerAvailableBandInfoListMutable ();

    /**
     * Sets the value of the member "TunerAvailableBandInfoList".
     *
     * Provides list info regarding the available bands
     *
     * @param TunerAvailableBandInfoList The value which will be set
     */
    inline void setTunerAvailableBandInfoList (const ::tuner_main_fi_types::T_AvailableBandInfoList& TunerAvailableBandInfoList_);

    static const FID_TUN_G_AVAILABLE_BAND_RANGEStatus &getDefaultInstance();

private:

    static const ::std::vector< ::tuner_main_fi_types::T_AvailableBandInfoElement >& getT_AvailableBandInfoElementList_DefaultInstance ();

    inline void set_has_u32AvailableBands ();

    inline void clear_has_u32AvailableBands ();

    inline void set_has_TunerAvailableBandInfoList ();

    inline void clear_has_TunerAvailableBandInfoList ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _u32AvailableBands;

    ::tuner_main_fi_types::T_AvailableBandInfoList _TunerAvailableBandInfoList;

};

/**
 * The status message of the property "FID_TUN_G_MUTE_REQUEST"
 * Mute status message
 */
class FID_TUN_G_MUTE_REQUESTStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_MUTE_REQUESTStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_MUTE_REQUESTStatus (const FID_TUN_G_MUTE_REQUESTStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_MUTE_REQUESTStatus (bool bMute_, uint8 u8Attenuation_, bool bMute_Interrupt_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_MUTE_REQUESTStatus();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_MUTE_REQUESTStatus& operator = (const FID_TUN_G_MUTE_REQUESTStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_MUTE_REQUESTStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_MUTE_REQUESTStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_MUTE_REQUESTStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_MUTE_REQUESTStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bMute"

    static const int kBMute = 0;

    /**
     * Clears the field "bMute".
     *
     * The field will be set to its default value. The hasBMute()
     * method will return false.
     */
    inline void clearBMute();

    /**
     * Checks whether the field "bMute" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBMute()). Otherwise it will return false.
     */
    inline bool hasBMute () const;

    /**
     * Returns the value of the member "bMute".
     *
     * Provides Mute or de-Mute requested
     *
     * @return The value of the field "bMute"
     */
    inline bool getBMute () const;

    /**
     * Sets the value of the member "bMute".
     *
     * Provides Mute or de-Mute requested
     *
     * @param bMute The value which will be set
     */
    inline void setBMute (bool bMute_);

    // API of field "u8Attenuation"

    static const int kU8Attenuation = 1;

    /**
     * Clears the field "u8Attenuation".
     *
     * The field will be set to its default value. The hasU8Attenuation()
     * method will return false.
     */
    inline void clearU8Attenuation();

    /**
     * Checks whether the field "u8Attenuation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Attenuation()). Otherwise it will return false.
     */
    inline bool hasU8Attenuation () const;

    /**
     * Returns the value of the member "u8Attenuation".
     *
     * Provides the Attenuation value
     *
     * @return The value of the field "u8Attenuation"
     */
    inline uint8 getU8Attenuation () const;

    /**
     * Sets the value of the member "u8Attenuation".
     *
     * Provides the Attenuation value
     *
     * @param u8Attenuation The value which will be set
     */
    inline void setU8Attenuation (uint8 u8Attenuation_);

    // API of field "bMute_Interrupt"

    static const int kBMute_Interrupt = 2;

    /**
     * Clears the field "bMute_Interrupt".
     *
     * The field will be set to its default value. The hasBMute_Interrupt()
     * method will return false.
     */
    inline void clearBMute_Interrupt();

    /**
     * Checks whether the field "bMute_Interrupt" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBMute_Interrupt()). Otherwise it will return false.
     */
    inline bool hasBMute_Interrupt () const;

    /**
     * Returns the value of the member "bMute_Interrupt".
     *
     * Provides whether the following Mute/DeMute request can be interrupted or not
     *
     * @return The value of the field "bMute_Interrupt"
     */
    inline bool getBMute_Interrupt () const;

    /**
     * Sets the value of the member "bMute_Interrupt".
     *
     * Provides whether the following Mute/DeMute request can be interrupted or not
     *
     * @param bMute_Interrupt The value which will be set
     */
    inline void setBMute_Interrupt (bool bMute_Interrupt_);

    static const FID_TUN_G_MUTE_REQUESTStatus &getDefaultInstance();

private:

    inline void set_has_bMute ();

    inline void clear_has_bMute ();

    inline void set_has_u8Attenuation ();

    inline void clear_has_u8Attenuation ();

    inline void set_has_bMute_Interrupt ();

    inline void clear_has_bMute_Interrupt ();

    uint32 _has_bits_[ (3 + 31) / 32];

    bool _bMute;

    uint8 _u8Attenuation;

    bool _bMute_Interrupt;

};

/**
 * The status message of the property "FID_TUN_G_UPDATELANDSCAPE_PROGRESS"
 * Provides ratio of the already scanned frequencies in percent during landscape update
 */
class FID_TUN_G_UPDATELANDSCAPE_PROGRESSStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_UPDATELANDSCAPE_PROGRESSStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_UPDATELANDSCAPE_PROGRESSStatus (const FID_TUN_G_UPDATELANDSCAPE_PROGRESSStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_UPDATELANDSCAPE_PROGRESSStatus (uint8 u8FreqPerc_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_UPDATELANDSCAPE_PROGRESSStatus();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_UPDATELANDSCAPE_PROGRESSStatus& operator = (const FID_TUN_G_UPDATELANDSCAPE_PROGRESSStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_UPDATELANDSCAPE_PROGRESSStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_UPDATELANDSCAPE_PROGRESSStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_UPDATELANDSCAPE_PROGRESSStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_UPDATELANDSCAPE_PROGRESSStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8FreqPerc"

    static const int kU8FreqPerc = 0;

    /**
     * Clears the field "u8FreqPerc".
     *
     * The field will be set to its default value. The hasU8FreqPerc()
     * method will return false.
     */
    inline void clearU8FreqPerc();

    /**
     * Checks whether the field "u8FreqPerc" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8FreqPerc()). Otherwise it will return false.
     */
    inline bool hasU8FreqPerc () const;

    /**
     * Returns the value of the member "u8FreqPerc".
     *
     * Provides the percentage of scanned frequencies
     *
     * @return The value of the field "u8FreqPerc"
     */
    inline uint8 getU8FreqPerc () const;

    /**
     * Sets the value of the member "u8FreqPerc".
     *
     * Provides the percentage of scanned frequencies
     *
     * @param u8FreqPerc The value which will be set
     */
    inline void setU8FreqPerc (uint8 u8FreqPerc_);

    static const FID_TUN_G_UPDATELANDSCAPE_PROGRESSStatus &getDefaultInstance();

private:

    inline void set_has_u8FreqPerc ();

    inline void clear_has_u8FreqPerc ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8FreqPerc;

};

/**
 * The status message of the property "FID_TUN_G_DRM_RADIO_TEXT"
 * This Property delivers DRM Radio text
 */
class FID_TUN_G_DRM_RADIO_TEXTStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_DRM_RADIO_TEXTStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_DRM_RADIO_TEXTStatus (const FID_TUN_G_DRM_RADIO_TEXTStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_DRM_RADIO_TEXTStatus (const ::std::string& sDRMRadioText_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_DRM_RADIO_TEXTStatus();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_DRM_RADIO_TEXTStatus& operator = (const FID_TUN_G_DRM_RADIO_TEXTStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_DRM_RADIO_TEXTStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_DRM_RADIO_TEXTStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_DRM_RADIO_TEXTStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_DRM_RADIO_TEXTStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sDRMRadioText"

    static const int kSDRMRadioText = 0;

    /**
     * Clears the field "sDRMRadioText".
     *
     * The field will be set to its default value. The hasSDRMRadioText()
     * method will return false.
     */
    inline void clearSDRMRadioText();

    /**
     * Checks whether the field "sDRMRadioText" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDRMRadioText()). Otherwise it will return false.
     */
    inline bool hasSDRMRadioText () const;

    /**
     * Returns the value of the member "sDRMRadioText".
     *
     * Gives the DRM Radio Text data in UTF8 Format
     *
     * @return The value of the field "sDRMRadioText"
     */
    inline const ::std::string& getSDRMRadioText () const;

    /**
     * Retrieves the value of the field "sDRMRadioText" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDRMRadioText".
     */
    inline ::std::string& getSDRMRadioTextMutable ();

    /**
     * Sets the value of the member "sDRMRadioText".
     *
     * Gives the DRM Radio Text data in UTF8 Format
     *
     * @param sDRMRadioText The value which will be set
     */
    inline void setSDRMRadioText (const ::std::string& sDRMRadioText_);

    /**
     * Sets the value of the member "sDRMRadioText".
     *
     * Gives the DRM Radio Text data in UTF8 Format
     *
     * @param sDRMRadioText The value which will be set
     */
    inline void setSDRMRadioText (const char* sDRMRadioText_);

    /**
     * Sets the value of the member "sDRMRadioText".
     *
     * Gives the DRM Radio Text data in UTF8 Format
     *
     * @param sDRMRadioText The value which will be set
     */
    inline void setSDRMRadioText (const char* value, size_t size);

    static const FID_TUN_G_DRM_RADIO_TEXTStatus &getDefaultInstance();

private:

    inline void set_has_sDRMRadioText ();

    inline void clear_has_sDRMRadioText ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _sDRMRadioText;

};

/**
 * The status message of the property "FID_TUN_G_ATPISEARCH"
 * Provides the PI search status
 */
class FID_TUN_G_ATPISEARCHStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_ATPISEARCHStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_ATPISEARCHStatus (const FID_TUN_G_ATPISEARCHStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_ATPISEARCHStatus (::tuner_main_fi_types::T_e8_PISearch_Status e8PISearchStatus_, uint16 u16PI_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_ATPISEARCHStatus();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_ATPISEARCHStatus& operator = (const FID_TUN_G_ATPISEARCHStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_ATPISEARCHStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_ATPISEARCHStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_ATPISEARCHStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_ATPISEARCHStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8PISearchStatus"

    static const int kE8PISearchStatus = 0;

    /**
     * Clears the field "e8PISearchStatus".
     *
     * The field will be set to its default value. The hasE8PISearchStatus()
     * method will return false.
     */
    inline void clearE8PISearchStatus();

    /**
     * Checks whether the field "e8PISearchStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8PISearchStatus()). Otherwise it will return false.
     */
    inline bool hasE8PISearchStatus () const;

    /**
     * Returns the value of the member "e8PISearchStatus".
     *
     * 0: PI search started , 1: PI search ended and PI found , 2: Pi search ended and PI not found
     *
     * @return The value of the field "e8PISearchStatus"
     */
    inline ::tuner_main_fi_types::T_e8_PISearch_Status getE8PISearchStatus () const;

    /**
     * Sets the value of the member "e8PISearchStatus".
     *
     * 0: PI search started , 1: PI search ended and PI found , 2: Pi search ended and PI not found
     *
     * @param e8PISearchStatus The value which will be set
     */
    inline void setE8PISearchStatus (::tuner_main_fi_types::T_e8_PISearch_Status e8PISearchStatus_);

    // API of field "u16PI"

    static const int kU16PI = 1;

    /**
     * Clears the field "u16PI".
     *
     * The field will be set to its default value. The hasU16PI()
     * method will return false.
     */
    inline void clearU16PI();

    /**
     * Checks whether the field "u16PI" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16PI()). Otherwise it will return false.
     */
    inline bool hasU16PI () const;

    /**
     * Returns the value of the member "u16PI".
     *
     * PI value
     *
     * @return The value of the field "u16PI"
     */
    inline uint16 getU16PI () const;

    /**
     * Sets the value of the member "u16PI".
     *
     * PI value
     *
     * @param u16PI The value which will be set
     */
    inline void setU16PI (uint16 u16PI_);

    static const FID_TUN_G_ATPISEARCHStatus &getDefaultInstance();

private:

    inline void set_has_e8PISearchStatus ();

    inline void clear_has_e8PISearchStatus ();

    inline void set_has_u16PI ();

    inline void clear_has_u16PI ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::tuner_main_fi_types::T_e8_PISearch_Status _e8PISearchStatus;

    uint16 _u16PI;

};

/**
 * The status message of the property "FID_TUN_G_HD_AUDIOPRGM"
 * Provides Audio Program Number of current tuned HD Audio Program.
 */
class FID_TUN_G_HD_AUDIOPRGMStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_HD_AUDIOPRGMStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_HD_AUDIOPRGMStatus (const FID_TUN_G_HD_AUDIOPRGMStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_HD_AUDIOPRGMStatus (::tuner_main_fi_types::T_e8_Tun_HDAudioProgram e8HDAudioPrgNo_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_HD_AUDIOPRGMStatus();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_HD_AUDIOPRGMStatus& operator = (const FID_TUN_G_HD_AUDIOPRGMStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_HD_AUDIOPRGMStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_HD_AUDIOPRGMStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_HD_AUDIOPRGMStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_HD_AUDIOPRGMStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8HDAudioPrgNo"

    static const int kE8HDAudioPrgNo = 0;

    /**
     * Clears the field "e8HDAudioPrgNo".
     *
     * The field will be set to its default value. The hasE8HDAudioPrgNo()
     * method will return false.
     */
    inline void clearE8HDAudioPrgNo();

    /**
     * Checks whether the field "e8HDAudioPrgNo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8HDAudioPrgNo()). Otherwise it will return false.
     */
    inline bool hasE8HDAudioPrgNo () const;

    /**
     * Returns the value of the member "e8HDAudioPrgNo".
     *
     * HD Audio Program number
     *
     * @return The value of the field "e8HDAudioPrgNo"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_HDAudioProgram getE8HDAudioPrgNo () const;

    /**
     * Sets the value of the member "e8HDAudioPrgNo".
     *
     * HD Audio Program number
     *
     * @param e8HDAudioPrgNo The value which will be set
     */
    inline void setE8HDAudioPrgNo (::tuner_main_fi_types::T_e8_Tun_HDAudioProgram e8HDAudioPrgNo_);

    static const FID_TUN_G_HD_AUDIOPRGMStatus &getDefaultInstance();

private:

    inline void set_has_e8HDAudioPrgNo ();

    inline void clear_has_e8HDAudioPrgNo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_e8_Tun_HDAudioProgram _e8HDAudioPrgNo;

};

/**
 * The status message of the property "FID_TUN_G_HD_PSD_DATA"
 * Provides the PSD data of the current tuned HD Audio Program
 */
class FID_TUN_G_HD_PSD_DATAStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_HD_PSD_DATAStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_HD_PSD_DATAStatus (const FID_TUN_G_HD_PSD_DATAStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_HD_PSD_DATAStatus (const ::tuner_main_fi_types::T_TunPSDData& TunPSDData_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_HD_PSD_DATAStatus();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_HD_PSD_DATAStatus& operator = (const FID_TUN_G_HD_PSD_DATAStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_HD_PSD_DATAStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_HD_PSD_DATAStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_HD_PSD_DATAStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_HD_PSD_DATAStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunPSDData"

    static const int kTunPSDData = 0;

    /**
     * Clears the field "TunPSDData".
     *
     * The field will be set to its default value. The hasTunPSDData()
     * method will return false.
     */
    inline void clearTunPSDData();

    /**
     * Checks whether the field "TunPSDData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunPSDData()). Otherwise it will return false.
     */
    inline bool hasTunPSDData () const;

    /**
     * Returns the value of the member "TunPSDData".
     *
     * HD Audio Program number
     *
     * @return The value of the field "TunPSDData"
     */
    inline const ::tuner_main_fi_types::T_TunPSDData& getTunPSDData () const;

    /**
     * Retrieves the value of the field "TunPSDData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunPSDData".
     */
    inline ::tuner_main_fi_types::T_TunPSDData& getTunPSDDataMutable ();

    /**
     * Sets the value of the member "TunPSDData".
     *
     * HD Audio Program number
     *
     * @param TunPSDData The value which will be set
     */
    inline void setTunPSDData (const ::tuner_main_fi_types::T_TunPSDData& TunPSDData_);

    static const FID_TUN_G_HD_PSD_DATAStatus &getDefaultInstance();

private:

    inline void set_has_TunPSDData ();

    inline void clear_has_TunPSDData ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_TunPSDData _TunPSDData;

};

/**
 * The status message of the property "FID_TUN_G_HD_TEST_MODE_DATA"
 * Provides HD related testmode data for each available physical tuner
 */
class FID_TUN_G_HD_TEST_MODE_DATAStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_HD_TEST_MODE_DATAStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_HD_TEST_MODE_DATAStatus (const FID_TUN_G_HD_TEST_MODE_DATAStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_HD_TEST_MODE_DATAStatus (const ::tuner_main_fi_types::T_TunerHDTestModeData& TunerHDTestModeData_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_HD_TEST_MODE_DATAStatus();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_HD_TEST_MODE_DATAStatus& operator = (const FID_TUN_G_HD_TEST_MODE_DATAStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_HD_TEST_MODE_DATAStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_HD_TEST_MODE_DATAStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_HD_TEST_MODE_DATAStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_HD_TEST_MODE_DATAStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerHDTestModeData"

    static const int kTunerHDTestModeData = 0;

    /**
     * Clears the field "TunerHDTestModeData".
     *
     * The field will be set to its default value. The hasTunerHDTestModeData()
     * method will return false.
     */
    inline void clearTunerHDTestModeData();

    /**
     * Checks whether the field "TunerHDTestModeData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerHDTestModeData()). Otherwise it will return false.
     */
    inline bool hasTunerHDTestModeData () const;

    /**
     * Returns the value of the member "TunerHDTestModeData".
     *
     * .
     *
     * @return The value of the field "TunerHDTestModeData"
     */
    inline const ::tuner_main_fi_types::T_TunerHDTestModeData& getTunerHDTestModeData () const;

    /**
     * Retrieves the value of the field "TunerHDTestModeData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerHDTestModeData".
     */
    inline ::tuner_main_fi_types::T_TunerHDTestModeData& getTunerHDTestModeDataMutable ();

    /**
     * Sets the value of the member "TunerHDTestModeData".
     *
     * .
     *
     * @param TunerHDTestModeData The value which will be set
     */
    inline void setTunerHDTestModeData (const ::tuner_main_fi_types::T_TunerHDTestModeData& TunerHDTestModeData_);

    static const FID_TUN_G_HD_TEST_MODE_DATAStatus &getDefaultInstance();

private:

    inline void set_has_TunerHDTestModeData ();

    inline void clear_has_TunerHDTestModeData ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_TunerHDTestModeData _TunerHDTestModeData;

};

/**
 * The status message of the property "FID_TUN_G_HD_AVISORY_INFO"
 * Provides information to clients about the advisory message to be displayed.
 */
class FID_TUN_G_HD_AVISORY_INFOStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_HD_AVISORY_INFOStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_HD_AVISORY_INFOStatus (const FID_TUN_G_HD_AVISORY_INFOStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_HD_AVISORY_INFOStatus (::tuner_main_fi_types::T_e8_Tun_HDAdvisoryInfo e8HDAdvisoryInfo_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_HD_AVISORY_INFOStatus();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_HD_AVISORY_INFOStatus& operator = (const FID_TUN_G_HD_AVISORY_INFOStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_HD_AVISORY_INFOStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_HD_AVISORY_INFOStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_HD_AVISORY_INFOStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_HD_AVISORY_INFOStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8HDAdvisoryInfo"

    static const int kE8HDAdvisoryInfo = 0;

    /**
     * Clears the field "e8HDAdvisoryInfo".
     *
     * The field will be set to its default value. The hasE8HDAdvisoryInfo()
     * method will return false.
     */
    inline void clearE8HDAdvisoryInfo();

    /**
     * Checks whether the field "e8HDAdvisoryInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8HDAdvisoryInfo()). Otherwise it will return false.
     */
    inline bool hasE8HDAdvisoryInfo () const;

    /**
     * Returns the value of the member "e8HDAdvisoryInfo".
     *
     * HD advisory info
     *
     * @return The value of the field "e8HDAdvisoryInfo"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_HDAdvisoryInfo getE8HDAdvisoryInfo () const;

    /**
     * Sets the value of the member "e8HDAdvisoryInfo".
     *
     * HD advisory info
     *
     * @param e8HDAdvisoryInfo The value which will be set
     */
    inline void setE8HDAdvisoryInfo (::tuner_main_fi_types::T_e8_Tun_HDAdvisoryInfo e8HDAdvisoryInfo_);

    static const FID_TUN_G_HD_AVISORY_INFOStatus &getDefaultInstance();

private:

    inline void set_has_e8HDAdvisoryInfo ();

    inline void clear_has_e8HDAdvisoryInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_e8_Tun_HDAdvisoryInfo _e8HDAdvisoryInfo;

};

/**
 * The status message of the property "FID_TUN_G_DEMODULATION_SWITCH_STATUS"
 * With this property the AM, FM and HD demodulation switch status (ON/OFF) is updated.
 */
class FID_TUN_G_DEMODULATION_SWITCH_STATUSStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_DEMODULATION_SWITCH_STATUSStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_DEMODULATION_SWITCH_STATUSStatus (const FID_TUN_G_DEMODULATION_SWITCH_STATUSStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_DEMODULATION_SWITCH_STATUSStatus (const ::tuner_main_fi_types::T_b8_Tun_DemodSwitch& DemodulationSwitch_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_DEMODULATION_SWITCH_STATUSStatus();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_DEMODULATION_SWITCH_STATUSStatus& operator = (const FID_TUN_G_DEMODULATION_SWITCH_STATUSStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_DEMODULATION_SWITCH_STATUSStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_DEMODULATION_SWITCH_STATUSStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_DEMODULATION_SWITCH_STATUSStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_DEMODULATION_SWITCH_STATUSStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DemodulationSwitch"

    static const int kDemodulationSwitch = 0;

    /**
     * Clears the field "DemodulationSwitch".
     *
     * The field will be set to its default value. The hasDemodulationSwitch()
     * method will return false.
     */
    inline void clearDemodulationSwitch();

    /**
     * Checks whether the field "DemodulationSwitch" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDemodulationSwitch()). Otherwise it will return false.
     */
    inline bool hasDemodulationSwitch () const;

    /**
     * Returns the value of the member "DemodulationSwitch".
     *
     * AM, FM, HD Demodulation switches
     *
     * @return The value of the field "DemodulationSwitch"
     */
    inline const ::tuner_main_fi_types::T_b8_Tun_DemodSwitch& getDemodulationSwitch () const;

    /**
     * Retrieves the value of the field "DemodulationSwitch" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DemodulationSwitch".
     */
    inline ::tuner_main_fi_types::T_b8_Tun_DemodSwitch& getDemodulationSwitchMutable ();

    /**
     * Sets the value of the member "DemodulationSwitch".
     *
     * AM, FM, HD Demodulation switches
     *
     * @param DemodulationSwitch The value which will be set
     */
    inline void setDemodulationSwitch (const ::tuner_main_fi_types::T_b8_Tun_DemodSwitch& DemodulationSwitch_);

    static const FID_TUN_G_DEMODULATION_SWITCH_STATUSStatus &getDefaultInstance();

private:

    inline void set_has_DemodulationSwitch ();

    inline void clear_has_DemodulationSwitch ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_b8_Tun_DemodSwitch _DemodulationSwitch;

};

/**
 * The status message of the property "FID_TUN_G_AUDIO_SPLIT_MODE"
 * Provides Audio Split Mode status( Activated/Deactivated )
 */
class FID_TUN_G_AUDIO_SPLIT_MODEStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_AUDIO_SPLIT_MODEStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_AUDIO_SPLIT_MODEStatus (const FID_TUN_G_AUDIO_SPLIT_MODEStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_AUDIO_SPLIT_MODEStatus (::tuner_main_fi_types::T_e8_Tun_AudioSplitMode e8ParameterValue_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_AUDIO_SPLIT_MODEStatus();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_AUDIO_SPLIT_MODEStatus& operator = (const FID_TUN_G_AUDIO_SPLIT_MODEStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_AUDIO_SPLIT_MODEStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_AUDIO_SPLIT_MODEStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_AUDIO_SPLIT_MODEStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_AUDIO_SPLIT_MODEStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ParameterValue"

    static const int kE8ParameterValue = 0;

    /**
     * Clears the field "e8ParameterValue".
     *
     * The field will be set to its default value. The hasE8ParameterValue()
     * method will return false.
     */
    inline void clearE8ParameterValue();

    /**
     * Checks whether the field "e8ParameterValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ParameterValue()). Otherwise it will return false.
     */
    inline bool hasE8ParameterValue () const;

    /**
     * Returns the value of the member "e8ParameterValue".
     *
     * .
     *
     * @return The value of the field "e8ParameterValue"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_AudioSplitMode getE8ParameterValue () const;

    /**
     * Sets the value of the member "e8ParameterValue".
     *
     * .
     *
     * @param e8ParameterValue The value which will be set
     */
    inline void setE8ParameterValue (::tuner_main_fi_types::T_e8_Tun_AudioSplitMode e8ParameterValue_);

    static const FID_TUN_G_AUDIO_SPLIT_MODEStatus &getDefaultInstance();

private:

    inline void set_has_e8ParameterValue ();

    inline void clear_has_e8ParameterValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_e8_Tun_AudioSplitMode _e8ParameterValue;

};

/**
 * The status message of the property "FID_TUN_G_HD_SECTION_PARAMETER"
 * Provides HD Section parameter status
 */
class FID_TUN_G_HD_SECTION_PARAMETERStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_HD_SECTION_PARAMETERStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_HD_SECTION_PARAMETERStatus (const FID_TUN_G_HD_SECTION_PARAMETERStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_HD_SECTION_PARAMETERStatus (::tuner_main_fi_types::T_e16_Tun_ParameterID e16Parameter_ID_, int8 s8ParameterValue_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_HD_SECTION_PARAMETERStatus();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_HD_SECTION_PARAMETERStatus& operator = (const FID_TUN_G_HD_SECTION_PARAMETERStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_HD_SECTION_PARAMETERStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_HD_SECTION_PARAMETERStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_HD_SECTION_PARAMETERStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_HD_SECTION_PARAMETERStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e16Parameter_ID"

    static const int kE16Parameter_ID = 0;

    /**
     * Clears the field "e16Parameter_ID".
     *
     * The field will be set to its default value. The hasE16Parameter_ID()
     * method will return false.
     */
    inline void clearE16Parameter_ID();

    /**
     * Checks whether the field "e16Parameter_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE16Parameter_ID()). Otherwise it will return false.
     */
    inline bool hasE16Parameter_ID () const;

    /**
     * Returns the value of the member "e16Parameter_ID".
     *
     * .
     *
     * @return The value of the field "e16Parameter_ID"
     */
    inline ::tuner_main_fi_types::T_e16_Tun_ParameterID getE16Parameter_ID () const;

    /**
     * Sets the value of the member "e16Parameter_ID".
     *
     * .
     *
     * @param e16Parameter_ID The value which will be set
     */
    inline void setE16Parameter_ID (::tuner_main_fi_types::T_e16_Tun_ParameterID e16Parameter_ID_);

    // API of field "s8ParameterValue"

    static const int kS8ParameterValue = 1;

    /**
     * Clears the field "s8ParameterValue".
     *
     * The field will be set to its default value. The hasS8ParameterValue()
     * method will return false.
     */
    inline void clearS8ParameterValue();

    /**
     * Checks whether the field "s8ParameterValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS8ParameterValue()). Otherwise it will return false.
     */
    inline bool hasS8ParameterValue () const;

    /**
     * Returns the value of the member "s8ParameterValue".
     *
     * .
     *
     * @return The value of the field "s8ParameterValue"
     */
    inline int8 getS8ParameterValue () const;

    /**
     * Sets the value of the member "s8ParameterValue".
     *
     * .
     *
     * @param s8ParameterValue The value which will be set
     */
    inline void setS8ParameterValue (int8 s8ParameterValue_);

    static const FID_TUN_G_HD_SECTION_PARAMETERStatus &getDefaultInstance();

private:

    inline void set_has_e16Parameter_ID ();

    inline void clear_has_e16Parameter_ID ();

    inline void set_has_s8ParameterValue ();

    inline void clear_has_s8ParameterValue ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::tuner_main_fi_types::T_e16_Tun_ParameterID _e16Parameter_ID;

    int8 _s8ParameterValue;

};

/**
 * The get message of the property "FID_TUN_G_HD_SECTION_PARAMETER"
 * Provides HD Section parameter status
 */
class FID_TUN_G_HD_SECTION_PARAMETERGet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_HD_SECTION_PARAMETERGet ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_HD_SECTION_PARAMETERGet (const FID_TUN_G_HD_SECTION_PARAMETERGet &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_HD_SECTION_PARAMETERGet (::tuner_main_fi_types::T_e16_Tun_ParameterID e16Parameter_ID_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_HD_SECTION_PARAMETERGet();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_HD_SECTION_PARAMETERGet& operator = (const FID_TUN_G_HD_SECTION_PARAMETERGet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_HD_SECTION_PARAMETERGet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_HD_SECTION_PARAMETERGet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_HD_SECTION_PARAMETERGet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_HD_SECTION_PARAMETERGet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e16Parameter_ID"

    static const int kE16Parameter_ID = 0;

    /**
     * Clears the field "e16Parameter_ID".
     *
     * The field will be set to its default value. The hasE16Parameter_ID()
     * method will return false.
     */
    inline void clearE16Parameter_ID();

    /**
     * Checks whether the field "e16Parameter_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE16Parameter_ID()). Otherwise it will return false.
     */
    inline bool hasE16Parameter_ID () const;

    /**
     * Returns the value of the member "e16Parameter_ID".
     *
     * Fetches the information pertaining to the particular parameter ID
     *
     * @return The value of the field "e16Parameter_ID"
     */
    inline ::tuner_main_fi_types::T_e16_Tun_ParameterID getE16Parameter_ID () const;

    /**
     * Sets the value of the member "e16Parameter_ID".
     *
     * Fetches the information pertaining to the particular parameter ID
     *
     * @param e16Parameter_ID The value which will be set
     */
    inline void setE16Parameter_ID (::tuner_main_fi_types::T_e16_Tun_ParameterID e16Parameter_ID_);

    static const FID_TUN_G_HD_SECTION_PARAMETERGet &getDefaultInstance();

private:

    inline void set_has_e16Parameter_ID ();

    inline void clear_has_e16Parameter_ID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_e16_Tun_ParameterID _e16Parameter_ID;

};

/**
 * The status message of the property "FID_TUN_G_DRM_TESTMODE"
 * With this property the DRM TestMode status is updated.
 */
class FID_TUN_G_DRM_TESTMODEStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_DRM_TESTMODEStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_DRM_TESTMODEStatus (const FID_TUN_G_DRM_TESTMODEStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_DRM_TESTMODEStatus (uint8 u8TunerInfo_, uint32 u32Frequency_, uint8 u8FieldStrength_, uint8 u8SyncStatus_, uint8 u8RobustnessMode_, uint32 u32ChannelParams_, const ::std::vector< uint8 >& tU8ListDRMService_, const ::std::string& sDRMServiceLabelData_, uint32 u32AudioConfig_, uint8 u8ProtectionLevels_, int32 s32MSC_BER_, uint8 u8AudioCRCFails_, uint8 u8AudioMute_, uint8 u8ServiceQuality_, uint16 u16FAC_ERRS_, uint8 u8FAC_CRC_Fails_, uint16 u16SDC_ERRS_, uint8 u8SDC_CRC_Fails_, uint16 u16MuteCounter_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_DRM_TESTMODEStatus();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_DRM_TESTMODEStatus& operator = (const FID_TUN_G_DRM_TESTMODEStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_DRM_TESTMODEStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_DRM_TESTMODEStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_DRM_TESTMODEStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_DRM_TESTMODEStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8TunerInfo"

    static const int kU8TunerInfo = 0;

    /**
     * Clears the field "u8TunerInfo".
     *
     * The field will be set to its default value. The hasU8TunerInfo()
     * method will return false.
     */
    inline void clearU8TunerInfo();

    /**
     * Checks whether the field "u8TunerInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8TunerInfo()). Otherwise it will return false.
     */
    inline bool hasU8TunerInfo () const;

    /**
     * Returns the value of the member "u8TunerInfo".
     *
     * Audio Tuner is ON or OFF.
     *
     * @return The value of the field "u8TunerInfo"
     */
    inline uint8 getU8TunerInfo () const;

    /**
     * Sets the value of the member "u8TunerInfo".
     *
     * Audio Tuner is ON or OFF.
     *
     * @param u8TunerInfo The value which will be set
     */
    inline void setU8TunerInfo (uint8 u8TunerInfo_);

    // API of field "u32Frequency"

    static const int kU32Frequency = 1;

    /**
     * Clears the field "u32Frequency".
     *
     * The field will be set to its default value. The hasU32Frequency()
     * method will return false.
     */
    inline void clearU32Frequency();

    /**
     * Checks whether the field "u32Frequency" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Frequency()). Otherwise it will return false.
     */
    inline bool hasU32Frequency () const;

    /**
     * Returns the value of the member "u32Frequency".
     *
     * DRM Frequency in the range 150 to 108000 Hz with 1kHZ step.
     *
     * @return The value of the field "u32Frequency"
     */
    inline uint32 getU32Frequency () const;

    /**
     * Sets the value of the member "u32Frequency".
     *
     * DRM Frequency in the range 150 to 108000 Hz with 1kHZ step.
     *
     * @param u32Frequency The value which will be set
     */
    inline void setU32Frequency (uint32 u32Frequency_);

    // API of field "u8FieldStrength"

    static const int kU8FieldStrength = 2;

    /**
     * Clears the field "u8FieldStrength".
     *
     * The field will be set to its default value. The hasU8FieldStrength()
     * method will return false.
     */
    inline void clearU8FieldStrength();

    /**
     * Checks whether the field "u8FieldStrength" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8FieldStrength()). Otherwise it will return false.
     */
    inline bool hasU8FieldStrength () const;

    /**
     * Returns the value of the member "u8FieldStrength".
     *
     * DRM Service Field Strength in dbuV Unit.
     *
     * @return The value of the field "u8FieldStrength"
     */
    inline uint8 getU8FieldStrength () const;

    /**
     * Sets the value of the member "u8FieldStrength".
     *
     * DRM Service Field Strength in dbuV Unit.
     *
     * @param u8FieldStrength The value which will be set
     */
    inline void setU8FieldStrength (uint8 u8FieldStrength_);

    // API of field "u8SyncStatus"

    static const int kU8SyncStatus = 3;

    /**
     * Clears the field "u8SyncStatus".
     *
     * The field will be set to its default value. The hasU8SyncStatus()
     * method will return false.
     */
    inline void clearU8SyncStatus();

    /**
     * Checks whether the field "u8SyncStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SyncStatus()). Otherwise it will return false.
     */
    inline bool hasU8SyncStatus () const;

    /**
     * Returns the value of the member "u8SyncStatus".
     *
     * DRM Service Sync Status.
     * Bit 0 - DRM signal not detected/detected.
     * Bit 1 - No/Physical sync.
     * Bit 2 - FAC sync, channel configuration not detected/detected.
     * Bit 3 - SDC sync, channel configuration not detected/detected.
     * Bit 4 - MSC output not active/active.
     * Bit 5..7 - Reserved.
     *
     * @return The value of the field "u8SyncStatus"
     */
    inline uint8 getU8SyncStatus () const;

    /**
     * Sets the value of the member "u8SyncStatus".
     *
     * DRM Service Sync Status.
     * Bit 0 - DRM signal not detected/detected.
     * Bit 1 - No/Physical sync.
     * Bit 2 - FAC sync, channel configuration not detected/detected.
     * Bit 3 - SDC sync, channel configuration not detected/detected.
     * Bit 4 - MSC output not active/active.
     * Bit 5..7 - Reserved.
     *
     * @param u8SyncStatus The value which will be set
     */
    inline void setU8SyncStatus (uint8 u8SyncStatus_);

    // API of field "u8RobustnessMode"

    static const int kU8RobustnessMode = 4;

    /**
     * Clears the field "u8RobustnessMode".
     *
     * The field will be set to its default value. The hasU8RobustnessMode()
     * method will return false.
     */
    inline void clearU8RobustnessMode();

    /**
     * Checks whether the field "u8RobustnessMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8RobustnessMode()). Otherwise it will return false.
     */
    inline bool hasU8RobustnessMode () const;

    /**
     * Returns the value of the member "u8RobustnessMode".
     *
     * DRM Service Robustness Mode.
     * Bit 0..2 - 0:A, 1:B, 2:C, 3:D, 4:E
     * Bit 3..7 - Reserved.
     *
     * @return The value of the field "u8RobustnessMode"
     */
    inline uint8 getU8RobustnessMode () const;

    /**
     * Sets the value of the member "u8RobustnessMode".
     *
     * DRM Service Robustness Mode.
     * Bit 0..2 - 0:A, 1:B, 2:C, 3:D, 4:E
     * Bit 3..7 - Reserved.
     *
     * @param u8RobustnessMode The value which will be set
     */
    inline void setU8RobustnessMode (uint8 u8RobustnessMode_);

    // API of field "u32ChannelParams"

    static const int kU32ChannelParams = 5;

    /**
     * Clears the field "u32ChannelParams".
     *
     * The field will be set to its default value. The hasU32ChannelParams()
     * method will return false.
     */
    inline void clearU32ChannelParams();

    /**
     * Checks whether the field "u32ChannelParams" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ChannelParams()). Otherwise it will return false.
     */
    inline bool hasU32ChannelParams () const;

    /**
     * Returns the value of the member "u32ChannelParams".
     *
     * Bit 0..19
     * Base/Enhancement flag 1 bit
     * Identity 2 bits
     * RM flag 1 bit
     * Spectrum occupancy 3 bits
     * Interleaver depth flag 1 bit
     * MSC mode 2 bits
     * SDC mode 1 bit
     * Number of services 4 bits
     * Reconfiguration index 3 bits
     * Toggle flag 1 bit
     * rfu 1 bit
     * Bit 20..23 - Reserved.
     *
     * @return The value of the field "u32ChannelParams"
     */
    inline uint32 getU32ChannelParams () const;

    /**
     * Sets the value of the member "u32ChannelParams".
     *
     * Bit 0..19
     * Base/Enhancement flag 1 bit
     * Identity 2 bits
     * RM flag 1 bit
     * Spectrum occupancy 3 bits
     * Interleaver depth flag 1 bit
     * MSC mode 2 bits
     * SDC mode 1 bit
     * Number of services 4 bits
     * Reconfiguration index 3 bits
     * Toggle flag 1 bit
     * rfu 1 bit
     * Bit 20..23 - Reserved.
     *
     * @param u32ChannelParams The value which will be set
     */
    inline void setU32ChannelParams (uint32 u32ChannelParams_);

    // API of field "tU8ListDRMService"

    static const int kTU8ListDRMService = 6;

    /**
     * Clears the field "tU8ListDRMService".
     *
     * The field will be set to its default value. The hasTU8ListDRMService()
     * method will return false.
     */
    inline void clearTU8ListDRMService();

    /**
     * Checks whether the field "tU8ListDRMService" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTU8ListDRMService()). Otherwise it will return false.
     */
    inline bool hasTU8ListDRMService () const;

    /**
     * Returns the value of the member "tU8ListDRMService".
     *
     * Service parameters
     * Bit 0..3 - Reserved
     * Bit 4..47
     * Service identifier 24 bits.
     * Short Id 2 bits.
     * Audio CA indication 1 bit.
     * Language 4 bits.
     * Audio/Data flag 1 bit.
     * Service descriptor 5 bits.
     * Data CA indication 1 bit.
     * rfa 6 bits.
     *
     * @return The value of the field "tU8ListDRMService"
     */
    inline const ::std::vector< uint8 >& getTU8ListDRMService () const;

    /**
     * Retrieves the value of the field "tU8ListDRMService" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tU8ListDRMService".
     */
    inline ::std::vector< uint8 >& getTU8ListDRMServiceMutable ();

    /**
     * Sets the value of the member "tU8ListDRMService".
     *
     * Service parameters
     * Bit 0..3 - Reserved
     * Bit 4..47
     * Service identifier 24 bits.
     * Short Id 2 bits.
     * Audio CA indication 1 bit.
     * Language 4 bits.
     * Audio/Data flag 1 bit.
     * Service descriptor 5 bits.
     * Data CA indication 1 bit.
     * rfa 6 bits.
     *
     * @param tU8ListDRMService The value which will be set
     */
    inline void setTU8ListDRMService (const ::std::vector< uint8 >& tU8ListDRMService_);

    // API of field "sDRMServiceLabelData"

    static const int kSDRMServiceLabelData = 7;

    /**
     * Clears the field "sDRMServiceLabelData".
     *
     * The field will be set to its default value. The hasSDRMServiceLabelData()
     * method will return false.
     */
    inline void clearSDRMServiceLabelData();

    /**
     * Checks whether the field "sDRMServiceLabelData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDRMServiceLabelData()). Otherwise it will return false.
     */
    inline bool hasSDRMServiceLabelData () const;

    /**
     * Returns the value of the member "sDRMServiceLabelData".
     *
     * Service Label Data String 0..64 bytes
     *
     * @return The value of the field "sDRMServiceLabelData"
     */
    inline const ::std::string& getSDRMServiceLabelData () const;

    /**
     * Retrieves the value of the field "sDRMServiceLabelData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDRMServiceLabelData".
     */
    inline ::std::string& getSDRMServiceLabelDataMutable ();

    /**
     * Sets the value of the member "sDRMServiceLabelData".
     *
     * Service Label Data String 0..64 bytes
     *
     * @param sDRMServiceLabelData The value which will be set
     */
    inline void setSDRMServiceLabelData (const ::std::string& sDRMServiceLabelData_);

    /**
     * Sets the value of the member "sDRMServiceLabelData".
     *
     * Service Label Data String 0..64 bytes
     *
     * @param sDRMServiceLabelData The value which will be set
     */
    inline void setSDRMServiceLabelData (const char* sDRMServiceLabelData_);

    /**
     * Sets the value of the member "sDRMServiceLabelData".
     *
     * Service Label Data String 0..64 bytes
     *
     * @param sDRMServiceLabelData The value which will be set
     */
    inline void setSDRMServiceLabelData (const char* value, size_t size);

    // API of field "u32AudioConfig"

    static const int kU32AudioConfig = 8;

    /**
     * Clears the field "u32AudioConfig".
     *
     * The field will be set to its default value. The hasU32AudioConfig()
     * method will return false.
     */
    inline void clearU32AudioConfig();

    /**
     * Checks whether the field "u32AudioConfig" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32AudioConfig()). Otherwise it will return false.
     */
    inline bool hasU32AudioConfig () const;

    /**
     * Returns the value of the member "u32AudioConfig".
     *
     * Audio Information
     * Bit 0..19
     * Short Id 2 bits.
     * Stream Id 2 bits.
     * audio coding 2 bits.
     * SBR flag 1 bit.
     * audio mode 2 bits.
     * audio sampling rate 3 bits.
     * text flag 1 bit.
     * enhancement flag 1 bit.
     * coder field 5 bits.
     * rfa 1 bit.
     * Bit 20..23 - Reserved
     *
     * @return The value of the field "u32AudioConfig"
     */
    inline uint32 getU32AudioConfig () const;

    /**
     * Sets the value of the member "u32AudioConfig".
     *
     * Audio Information
     * Bit 0..19
     * Short Id 2 bits.
     * Stream Id 2 bits.
     * audio coding 2 bits.
     * SBR flag 1 bit.
     * audio mode 2 bits.
     * audio sampling rate 3 bits.
     * text flag 1 bit.
     * enhancement flag 1 bit.
     * coder field 5 bits.
     * rfa 1 bit.
     * Bit 20..23 - Reserved
     *
     * @param u32AudioConfig The value which will be set
     */
    inline void setU32AudioConfig (uint32 u32AudioConfig_);

    // API of field "u8ProtectionLevels"

    static const int kU8ProtectionLevels = 9;

    /**
     * Clears the field "u8ProtectionLevels".
     *
     * The field will be set to its default value. The hasU8ProtectionLevels()
     * method will return false.
     */
    inline void clearU8ProtectionLevels();

    /**
     * Checks whether the field "u8ProtectionLevels" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8ProtectionLevels()). Otherwise it will return false.
     */
    inline bool hasU8ProtectionLevels () const;

    /**
     * Returns the value of the member "u8ProtectionLevels".
     *
     * Bit 0..1 Protection level for part A
     * Bit 2..3 Protection level for part B
     * Bit 4..7 r.f.u
     *
     * @return The value of the field "u8ProtectionLevels"
     */
    inline uint8 getU8ProtectionLevels () const;

    /**
     * Sets the value of the member "u8ProtectionLevels".
     *
     * Bit 0..1 Protection level for part A
     * Bit 2..3 Protection level for part B
     * Bit 4..7 r.f.u
     *
     * @param u8ProtectionLevels The value which will be set
     */
    inline void setU8ProtectionLevels (uint8 u8ProtectionLevels_);

    // API of field "s32MSC_BER"

    static const int kS32MSC_BER = 10;

    /**
     * Clears the field "s32MSC_BER".
     *
     * The field will be set to its default value. The hasS32MSC_BER()
     * method will return false.
     */
    inline void clearS32MSC_BER();

    /**
     * Checks whether the field "s32MSC_BER" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32MSC_BER()). Otherwise it will return false.
     */
    inline bool hasS32MSC_BER () const;

    /**
     * Returns the value of the member "s32MSC_BER".
     *
     * Channel Bit-Error-Rate
     * Coding: MSC_BER = BER * 1e6
     * -1 = 0xffffffff: BER not available
     * 0..999999: BER value
     *
     * @return The value of the field "s32MSC_BER"
     */
    inline int32 getS32MSC_BER () const;

    /**
     * Sets the value of the member "s32MSC_BER".
     *
     * Channel Bit-Error-Rate
     * Coding: MSC_BER = BER * 1e6
     * -1 = 0xffffffff: BER not available
     * 0..999999: BER value
     *
     * @param s32MSC_BER The value which will be set
     */
    inline void setS32MSC_BER (int32 s32MSC_BER_);

    // API of field "u8AudioCRCFails"

    static const int kU8AudioCRCFails = 11;

    /**
     * Clears the field "u8AudioCRCFails".
     *
     * The field will be set to its default value. The hasU8AudioCRCFails()
     * method will return false.
     */
    inline void clearU8AudioCRCFails();

    /**
     * Checks whether the field "u8AudioCRCFails" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8AudioCRCFails()). Otherwise it will return false.
     */
    inline bool hasU8AudioCRCFails () const;

    /**
     * Returns the value of the member "u8AudioCRCFails".
     *
     * Number of CRC fails in the latest audio superframe
     *
     * @return The value of the field "u8AudioCRCFails"
     */
    inline uint8 getU8AudioCRCFails () const;

    /**
     * Sets the value of the member "u8AudioCRCFails".
     *
     * Number of CRC fails in the latest audio superframe
     *
     * @param u8AudioCRCFails The value which will be set
     */
    inline void setU8AudioCRCFails (uint8 u8AudioCRCFails_);

    // API of field "u8AudioMute"

    static const int kU8AudioMute = 12;

    /**
     * Clears the field "u8AudioMute".
     *
     * The field will be set to its default value. The hasU8AudioMute()
     * method will return false.
     */
    inline void clearU8AudioMute();

    /**
     * Checks whether the field "u8AudioMute" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8AudioMute()). Otherwise it will return false.
     */
    inline bool hasU8AudioMute () const;

    /**
     * Returns the value of the member "u8AudioMute".
     *
     * Bit 0
     * 0 audio stream decoder demuted
     * 1 audio stream decoder muted
     * Bit 1..7 - Reserved
     *
     * @return The value of the field "u8AudioMute"
     */
    inline uint8 getU8AudioMute () const;

    /**
     * Sets the value of the member "u8AudioMute".
     *
     * Bit 0
     * 0 audio stream decoder demuted
     * 1 audio stream decoder muted
     * Bit 1..7 - Reserved
     *
     * @param u8AudioMute The value which will be set
     */
    inline void setU8AudioMute (uint8 u8AudioMute_);

    // API of field "u8ServiceQuality"

    static const int kU8ServiceQuality = 13;

    /**
     * Clears the field "u8ServiceQuality".
     *
     * The field will be set to its default value. The hasU8ServiceQuality()
     * method will return false.
     */
    inline void clearU8ServiceQuality();

    /**
     * Checks whether the field "u8ServiceQuality" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8ServiceQuality()). Otherwise it will return false.
     */
    inline bool hasU8ServiceQuality () const;

    /**
     * Returns the value of the member "u8ServiceQuality".
     *
     * Computed quality indicator for the current service (Range 0..100).
     *
     * @return The value of the field "u8ServiceQuality"
     */
    inline uint8 getU8ServiceQuality () const;

    /**
     * Sets the value of the member "u8ServiceQuality".
     *
     * Computed quality indicator for the current service (Range 0..100).
     *
     * @param u8ServiceQuality The value which will be set
     */
    inline void setU8ServiceQuality (uint8 u8ServiceQuality_);

    // API of field "u16FAC_ERRS"

    static const int kU16FAC_ERRS = 14;

    /**
     * Clears the field "u16FAC_ERRS".
     *
     * The field will be set to its default value. The hasU16FAC_ERRS()
     * method will return false.
     */
    inline void clearU16FAC_ERRS();

    /**
     * Checks whether the field "u16FAC_ERRS" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16FAC_ERRS()). Otherwise it will return false.
     */
    inline bool hasU16FAC_ERRS () const;

    /**
     * Returns the value of the member "u16FAC_ERRS".
     *
     * Number of Channel Bit Errors estimated while decoding the FAC associated with the latest 1200ms of logical frames.
     *
     * @return The value of the field "u16FAC_ERRS"
     */
    inline uint16 getU16FAC_ERRS () const;

    /**
     * Sets the value of the member "u16FAC_ERRS".
     *
     * Number of Channel Bit Errors estimated while decoding the FAC associated with the latest 1200ms of logical frames.
     *
     * @param u16FAC_ERRS The value which will be set
     */
    inline void setU16FAC_ERRS (uint16 u16FAC_ERRS_);

    // API of field "u8FAC_CRC_Fails"

    static const int kU8FAC_CRC_Fails = 15;

    /**
     * Clears the field "u8FAC_CRC_Fails".
     *
     * The field will be set to its default value. The hasU8FAC_CRC_Fails()
     * method will return false.
     */
    inline void clearU8FAC_CRC_Fails();

    /**
     * Checks whether the field "u8FAC_CRC_Fails" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8FAC_CRC_Fails()). Otherwise it will return false.
     */
    inline bool hasU8FAC_CRC_Fails () const;

    /**
     * Returns the value of the member "u8FAC_CRC_Fails".
     *
     * Number of CRC fails in the decoded FAC data associated to the latest 1200 ms of logical frames.
     *
     * @return The value of the field "u8FAC_CRC_Fails"
     */
    inline uint8 getU8FAC_CRC_Fails () const;

    /**
     * Sets the value of the member "u8FAC_CRC_Fails".
     *
     * Number of CRC fails in the decoded FAC data associated to the latest 1200 ms of logical frames.
     *
     * @param u8FAC_CRC_Fails The value which will be set
     */
    inline void setU8FAC_CRC_Fails (uint8 u8FAC_CRC_Fails_);

    // API of field "u16SDC_ERRS"

    static const int kU16SDC_ERRS = 16;

    /**
     * Clears the field "u16SDC_ERRS".
     *
     * The field will be set to its default value. The hasU16SDC_ERRS()
     * method will return false.
     */
    inline void clearU16SDC_ERRS();

    /**
     * Checks whether the field "u16SDC_ERRS" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16SDC_ERRS()). Otherwise it will return false.
     */
    inline bool hasU16SDC_ERRS () const;

    /**
     * Returns the value of the member "u16SDC_ERRS".
     *
     * Number of Channel Bit Errors estimated while decoding the SDC associated with the latest 1200ms of logical frames.
     *
     * @return The value of the field "u16SDC_ERRS"
     */
    inline uint16 getU16SDC_ERRS () const;

    /**
     * Sets the value of the member "u16SDC_ERRS".
     *
     * Number of Channel Bit Errors estimated while decoding the SDC associated with the latest 1200ms of logical frames.
     *
     * @param u16SDC_ERRS The value which will be set
     */
    inline void setU16SDC_ERRS (uint16 u16SDC_ERRS_);

    // API of field "u8SDC_CRC_Fails"

    static const int kU8SDC_CRC_Fails = 17;

    /**
     * Clears the field "u8SDC_CRC_Fails".
     *
     * The field will be set to its default value. The hasU8SDC_CRC_Fails()
     * method will return false.
     */
    inline void clearU8SDC_CRC_Fails();

    /**
     * Checks whether the field "u8SDC_CRC_Fails" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SDC_CRC_Fails()). Otherwise it will return false.
     */
    inline bool hasU8SDC_CRC_Fails () const;

    /**
     * Returns the value of the member "u8SDC_CRC_Fails".
     *
     * Number of CRC fails in the decoded SDC data associated to the latest 1200 ms of logical frames.
     *
     * @return The value of the field "u8SDC_CRC_Fails"
     */
    inline uint8 getU8SDC_CRC_Fails () const;

    /**
     * Sets the value of the member "u8SDC_CRC_Fails".
     *
     * Number of CRC fails in the decoded SDC data associated to the latest 1200 ms of logical frames.
     *
     * @param u8SDC_CRC_Fails The value which will be set
     */
    inline void setU8SDC_CRC_Fails (uint8 u8SDC_CRC_Fails_);

    // API of field "u16MuteCounter"

    static const int kU16MuteCounter = 18;

    /**
     * Clears the field "u16MuteCounter".
     *
     * The field will be set to its default value. The hasU16MuteCounter()
     * method will return false.
     */
    inline void clearU16MuteCounter();

    /**
     * Checks whether the field "u16MuteCounter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16MuteCounter()). Otherwise it will return false.
     */
    inline bool hasU16MuteCounter () const;

    /**
     * Returns the value of the member "u16MuteCounter".
     *
     * When the "Audio Mute (u8AudioMute)" changes from 0 (audio stream decoder demuted) to 1 (audio decoder muted), the DRM Mute Counter will be increased. A Change from 1 to 0 will be ignored.
     *
     * @return The value of the field "u16MuteCounter"
     */
    inline uint16 getU16MuteCounter () const;

    /**
     * Sets the value of the member "u16MuteCounter".
     *
     * When the "Audio Mute (u8AudioMute)" changes from 0 (audio stream decoder demuted) to 1 (audio decoder muted), the DRM Mute Counter will be increased. A Change from 1 to 0 will be ignored.
     *
     * @param u16MuteCounter The value which will be set
     */
    inline void setU16MuteCounter (uint16 u16MuteCounter_);

    static const FID_TUN_G_DRM_TESTMODEStatus &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_u8TunerInfo ();

    inline void clear_has_u8TunerInfo ();

    inline void set_has_u32Frequency ();

    inline void clear_has_u32Frequency ();

    inline void set_has_u8FieldStrength ();

    inline void clear_has_u8FieldStrength ();

    inline void set_has_u8SyncStatus ();

    inline void clear_has_u8SyncStatus ();

    inline void set_has_u8RobustnessMode ();

    inline void clear_has_u8RobustnessMode ();

    inline void set_has_u32ChannelParams ();

    inline void clear_has_u32ChannelParams ();

    inline void set_has_tU8ListDRMService ();

    inline void clear_has_tU8ListDRMService ();

    inline void set_has_sDRMServiceLabelData ();

    inline void clear_has_sDRMServiceLabelData ();

    inline void set_has_u32AudioConfig ();

    inline void clear_has_u32AudioConfig ();

    inline void set_has_u8ProtectionLevels ();

    inline void clear_has_u8ProtectionLevels ();

    inline void set_has_s32MSC_BER ();

    inline void clear_has_s32MSC_BER ();

    inline void set_has_u8AudioCRCFails ();

    inline void clear_has_u8AudioCRCFails ();

    inline void set_has_u8AudioMute ();

    inline void clear_has_u8AudioMute ();

    inline void set_has_u8ServiceQuality ();

    inline void clear_has_u8ServiceQuality ();

    inline void set_has_u16FAC_ERRS ();

    inline void clear_has_u16FAC_ERRS ();

    inline void set_has_u8FAC_CRC_Fails ();

    inline void clear_has_u8FAC_CRC_Fails ();

    inline void set_has_u16SDC_ERRS ();

    inline void clear_has_u16SDC_ERRS ();

    inline void set_has_u8SDC_CRC_Fails ();

    inline void clear_has_u8SDC_CRC_Fails ();

    inline void set_has_u16MuteCounter ();

    inline void clear_has_u16MuteCounter ();

    uint32 _has_bits_[ (19 + 31) / 32];

    uint8 _u8TunerInfo;

    uint32 _u32Frequency;

    uint8 _u8FieldStrength;

    uint8 _u8SyncStatus;

    uint8 _u8RobustnessMode;

    uint32 _u32ChannelParams;

    ::std::vector< uint8 > _tU8ListDRMService;

    ::std::string _sDRMServiceLabelData;

    uint32 _u32AudioConfig;

    uint8 _u8ProtectionLevels;

    int32 _s32MSC_BER;

    uint8 _u8AudioCRCFails;

    uint8 _u8AudioMute;

    uint8 _u8ServiceQuality;

    uint16 _u16FAC_ERRS;

    uint8 _u8FAC_CRC_Fails;

    uint16 _u16SDC_ERRS;

    uint8 _u8SDC_CRC_Fails;

    uint16 _u16MuteCounter;

};

/**
 * The status message of the property "FID_TUN_G_HD_LONGNAME"
 * this property provides the HD long Name of the station described by the parameters.
 */
class FID_TUN_G_HD_LONGNAMEStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_HD_LONGNAMEStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_HD_LONGNAMEStatus (const FID_TUN_G_HD_LONGNAMEStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_HD_LONGNAMEStatus (uint32 u32HDStationId_, ::tuner_main_fi_types::T_e8_Tun_HDAudioProgram e8HDAudioProgram_, const ::std::string& sHDLongName_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_HD_LONGNAMEStatus();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_HD_LONGNAMEStatus& operator = (const FID_TUN_G_HD_LONGNAMEStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_HD_LONGNAMEStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_HD_LONGNAMEStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_HD_LONGNAMEStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_HD_LONGNAMEStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32HDStationId"

    static const int kU32HDStationId = 0;

    /**
     * Clears the field "u32HDStationId".
     *
     * The field will be set to its default value. The hasU32HDStationId()
     * method will return false.
     */
    inline void clearU32HDStationId();

    /**
     * Checks whether the field "u32HDStationId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32HDStationId()). Otherwise it will return false.
     */
    inline bool hasU32HDStationId () const;

    /**
     * Returns the value of the member "u32HDStationId".
     *
     * Requested station ID.
     *
     * @return The value of the field "u32HDStationId"
     */
    inline uint32 getU32HDStationId () const;

    /**
     * Sets the value of the member "u32HDStationId".
     *
     * Requested station ID.
     *
     * @param u32HDStationId The value which will be set
     */
    inline void setU32HDStationId (uint32 u32HDStationId_);

    // API of field "e8HDAudioProgram"

    static const int kE8HDAudioProgram = 1;

    /**
     * Clears the field "e8HDAudioProgram".
     *
     * The field will be set to its default value. The hasE8HDAudioProgram()
     * method will return false.
     */
    inline void clearE8HDAudioProgram();

    /**
     * Checks whether the field "e8HDAudioProgram" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8HDAudioProgram()). Otherwise it will return false.
     */
    inline bool hasE8HDAudioProgram () const;

    /**
     * Returns the value of the member "e8HDAudioProgram".
     *
     *
     *
     * @return The value of the field "e8HDAudioProgram"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_HDAudioProgram getE8HDAudioProgram () const;

    /**
     * Sets the value of the member "e8HDAudioProgram".
     *
     *
     *
     * @param e8HDAudioProgram The value which will be set
     */
    inline void setE8HDAudioProgram (::tuner_main_fi_types::T_e8_Tun_HDAudioProgram e8HDAudioProgram_);

    // API of field "sHDLongName"

    static const int kSHDLongName = 2;

    /**
     * Clears the field "sHDLongName".
     *
     * The field will be set to its default value. The hasSHDLongName()
     * method will return false.
     */
    inline void clearSHDLongName();

    /**
     * Checks whether the field "sHDLongName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSHDLongName()). Otherwise it will return false.
     */
    inline bool hasSHDLongName () const;

    /**
     * Returns the value of the member "sHDLongName".
     *
     * Max length 128. Text encoding = FI_EN_ISO8859_1M
     *
     * @return The value of the field "sHDLongName"
     */
    inline const ::std::string& getSHDLongName () const;

    /**
     * Retrieves the value of the field "sHDLongName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sHDLongName".
     */
    inline ::std::string& getSHDLongNameMutable ();

    /**
     * Sets the value of the member "sHDLongName".
     *
     * Max length 128. Text encoding = FI_EN_ISO8859_1M
     *
     * @param sHDLongName The value which will be set
     */
    inline void setSHDLongName (const ::std::string& sHDLongName_);

    /**
     * Sets the value of the member "sHDLongName".
     *
     * Max length 128. Text encoding = FI_EN_ISO8859_1M
     *
     * @param sHDLongName The value which will be set
     */
    inline void setSHDLongName (const char* sHDLongName_);

    /**
     * Sets the value of the member "sHDLongName".
     *
     * Max length 128. Text encoding = FI_EN_ISO8859_1M
     *
     * @param sHDLongName The value which will be set
     */
    inline void setSHDLongName (const char* value, size_t size);

    static const FID_TUN_G_HD_LONGNAMEStatus &getDefaultInstance();

private:

    inline void set_has_u32HDStationId ();

    inline void clear_has_u32HDStationId ();

    inline void set_has_e8HDAudioProgram ();

    inline void clear_has_e8HDAudioProgram ();

    inline void set_has_sHDLongName ();

    inline void clear_has_sHDLongName ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _u32HDStationId;

    ::tuner_main_fi_types::T_e8_Tun_HDAudioProgram _e8HDAudioProgram;

    ::std::string _sHDLongName;

};

/**
 * The get message of the property "FID_TUN_G_HD_LONGNAME"
 * this property provides the HD long Name of the station described by the parameters.
 */
class FID_TUN_G_HD_LONGNAMEGet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_HD_LONGNAMEGet ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_HD_LONGNAMEGet (const FID_TUN_G_HD_LONGNAMEGet &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_HD_LONGNAMEGet (uint32 u32HDStationId_, ::tuner_main_fi_types::T_e8_Tun_HDAudioProgram e8HDAudioProgram_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_HD_LONGNAMEGet();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_HD_LONGNAMEGet& operator = (const FID_TUN_G_HD_LONGNAMEGet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_HD_LONGNAMEGet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_HD_LONGNAMEGet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_HD_LONGNAMEGet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_HD_LONGNAMEGet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32HDStationId"

    static const int kU32HDStationId = 0;

    /**
     * Clears the field "u32HDStationId".
     *
     * The field will be set to its default value. The hasU32HDStationId()
     * method will return false.
     */
    inline void clearU32HDStationId();

    /**
     * Checks whether the field "u32HDStationId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32HDStationId()). Otherwise it will return false.
     */
    inline bool hasU32HDStationId () const;

    /**
     * Returns the value of the member "u32HDStationId".
     *
     * StationId for which psd long name is required.
     *
     * @return The value of the field "u32HDStationId"
     */
    inline uint32 getU32HDStationId () const;

    /**
     * Sets the value of the member "u32HDStationId".
     *
     * StationId for which psd long name is required.
     *
     * @param u32HDStationId The value which will be set
     */
    inline void setU32HDStationId (uint32 u32HDStationId_);

    // API of field "e8HDAudioProgram"

    static const int kE8HDAudioProgram = 1;

    /**
     * Clears the field "e8HDAudioProgram".
     *
     * The field will be set to its default value. The hasE8HDAudioProgram()
     * method will return false.
     */
    inline void clearE8HDAudioProgram();

    /**
     * Checks whether the field "e8HDAudioProgram" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8HDAudioProgram()). Otherwise it will return false.
     */
    inline bool hasE8HDAudioProgram () const;

    /**
     * Returns the value of the member "e8HDAudioProgram".
     *
     *
     *
     * @return The value of the field "e8HDAudioProgram"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_HDAudioProgram getE8HDAudioProgram () const;

    /**
     * Sets the value of the member "e8HDAudioProgram".
     *
     *
     *
     * @param e8HDAudioProgram The value which will be set
     */
    inline void setE8HDAudioProgram (::tuner_main_fi_types::T_e8_Tun_HDAudioProgram e8HDAudioProgram_);

    static const FID_TUN_G_HD_LONGNAMEGet &getDefaultInstance();

private:

    inline void set_has_u32HDStationId ();

    inline void clear_has_u32HDStationId ();

    inline void set_has_e8HDAudioProgram ();

    inline void clear_has_e8HDAudioProgram ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _u32HDStationId;

    ::tuner_main_fi_types::T_e8_Tun_HDAudioProgram _e8HDAudioProgram;

};

/**
 * The status message of the property "FID_TUN_G_HD_IMAGEFILE_UPDATE"
 * this property provides the Cover Art / HD station logo for the current played audio program.
 */
class FID_TUN_G_HD_IMAGEFILE_UPDATEStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_HD_IMAGEFILE_UPDATEStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_HD_IMAGEFILE_UPDATEStatus (const FID_TUN_G_HD_IMAGEFILE_UPDATEStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_HD_IMAGEFILE_UPDATEStatus (bool bDisplayImage_, const ::tuner_main_fi_types::T_ImageFileInfo& ImageFileInfo_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_HD_IMAGEFILE_UPDATEStatus();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_HD_IMAGEFILE_UPDATEStatus& operator = (const FID_TUN_G_HD_IMAGEFILE_UPDATEStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_HD_IMAGEFILE_UPDATEStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_HD_IMAGEFILE_UPDATEStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_HD_IMAGEFILE_UPDATEStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_HD_IMAGEFILE_UPDATEStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bDisplayImage"

    static const int kBDisplayImage = 0;

    /**
     * Clears the field "bDisplayImage".
     *
     * The field will be set to its default value. The hasBDisplayImage()
     * method will return false.
     */
    inline void clearBDisplayImage();

    /**
     * Checks whether the field "bDisplayImage" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDisplayImage()). Otherwise it will return false.
     */
    inline bool hasBDisplayImage () const;

    /**
     * Returns the value of the member "bDisplayImage".
     *
     * Informs whether the image associated with audioProgram and stationId be displayed or no.
     * Audio Program and Station ID are packed in ImageFileInfo parameter.
     *
     * @return The value of the field "bDisplayImage"
     */
    inline bool getBDisplayImage () const;

    /**
     * Sets the value of the member "bDisplayImage".
     *
     * Informs whether the image associated with audioProgram and stationId be displayed or no.
     * Audio Program and Station ID are packed in ImageFileInfo parameter.
     *
     * @param bDisplayImage The value which will be set
     */
    inline void setBDisplayImage (bool bDisplayImage_);

    // API of field "ImageFileInfo"

    static const int kImageFileInfo = 1;

    /**
     * Clears the field "ImageFileInfo".
     *
     * The field will be set to its default value. The hasImageFileInfo()
     * method will return false.
     */
    inline void clearImageFileInfo();

    /**
     * Checks whether the field "ImageFileInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setImageFileInfo()). Otherwise it will return false.
     */
    inline bool hasImageFileInfo () const;

    /**
     * Returns the value of the member "ImageFileInfo".
     *
     * Info regarding covert art / station logo.
     *
     * @return The value of the field "ImageFileInfo"
     */
    inline const ::tuner_main_fi_types::T_ImageFileInfo& getImageFileInfo () const;

    /**
     * Retrieves the value of the field "ImageFileInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ImageFileInfo".
     */
    inline ::tuner_main_fi_types::T_ImageFileInfo& getImageFileInfoMutable ();

    /**
     * Sets the value of the member "ImageFileInfo".
     *
     * Info regarding covert art / station logo.
     *
     * @param ImageFileInfo The value which will be set
     */
    inline void setImageFileInfo (const ::tuner_main_fi_types::T_ImageFileInfo& ImageFileInfo_);

    static const FID_TUN_G_HD_IMAGEFILE_UPDATEStatus &getDefaultInstance();

private:

    inline void set_has_bDisplayImage ();

    inline void clear_has_bDisplayImage ();

    inline void set_has_ImageFileInfo ();

    inline void clear_has_ImageFileInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _bDisplayImage;

    ::tuner_main_fi_types::T_ImageFileInfo _ImageFileInfo;

};

/**
 * The status message of the property "FID_TUN_G_HD_SIGNALLOST_TIMER"
 * This property provides the status of hd signal lost timer.
 */
class FID_TUN_G_HD_SIGNALLOST_TIMERStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_HD_SIGNALLOST_TIMERStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_HD_SIGNALLOST_TIMERStatus (const FID_TUN_G_HD_SIGNALLOST_TIMERStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_HD_SIGNALLOST_TIMERStatus (bool bTimer_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_HD_SIGNALLOST_TIMERStatus();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_HD_SIGNALLOST_TIMERStatus& operator = (const FID_TUN_G_HD_SIGNALLOST_TIMERStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_HD_SIGNALLOST_TIMERStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_HD_SIGNALLOST_TIMERStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_HD_SIGNALLOST_TIMERStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_HD_SIGNALLOST_TIMERStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bTimer"

    static const int kBTimer = 0;

    /**
     * Clears the field "bTimer".
     *
     * The field will be set to its default value. The hasBTimer()
     * method will return false.
     */
    inline void clearBTimer();

    /**
     * Checks whether the field "bTimer" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBTimer()). Otherwise it will return false.
     */
    inline bool hasBTimer () const;

    /**
     * Returns the value of the member "bTimer".
     *
     * Informs whether timer is ON/OFF. ON = 1, OFF = 0
     *
     * @return The value of the field "bTimer"
     */
    inline bool getBTimer () const;

    /**
     * Sets the value of the member "bTimer".
     *
     * Informs whether timer is ON/OFF. ON = 1, OFF = 0
     *
     * @param bTimer The value which will be set
     */
    inline void setBTimer (bool bTimer_);

    static const FID_TUN_G_HD_SIGNALLOST_TIMERStatus &getDefaultInstance();

private:

    inline void set_has_bTimer ();

    inline void clear_has_bTimer ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bTimer;

};

/**
 * The status message of the property "FID_TUN_G_SURVIELLANCE_LISTUPDATE"
 * The number of config list elements is given by this property to SDS.
 */
class FID_TUN_G_SURVIELLANCE_LISTUPDATEStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_SURVIELLANCE_LISTUPDATEStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_SURVIELLANCE_LISTUPDATEStatus (const FID_TUN_G_SURVIELLANCE_LISTUPDATEStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_SURVIELLANCE_LISTUPDATEStatus (::tuner_main_fi_types::T_e8_Tun_ConfigListID e8ConfigListID_, const ::tuner_main_fi_types::T_TunerConfigListElementList& Tun_ConfigListElements_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_SURVIELLANCE_LISTUPDATEStatus();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_SURVIELLANCE_LISTUPDATEStatus& operator = (const FID_TUN_G_SURVIELLANCE_LISTUPDATEStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_SURVIELLANCE_LISTUPDATEStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_SURVIELLANCE_LISTUPDATEStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_SURVIELLANCE_LISTUPDATEStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_SURVIELLANCE_LISTUPDATEStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ConfigListID"

    static const int kE8ConfigListID = 0;

    /**
     * Clears the field "e8ConfigListID".
     *
     * The field will be set to its default value. The hasE8ConfigListID()
     * method will return false.
     */
    inline void clearE8ConfigListID();

    /**
     * Checks whether the field "e8ConfigListID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ConfigListID()). Otherwise it will return false.
     */
    inline bool hasE8ConfigListID () const;

    /**
     * Returns the value of the member "e8ConfigListID".
     *
     *
     *
     * @return The value of the field "e8ConfigListID"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_ConfigListID getE8ConfigListID () const;

    /**
     * Sets the value of the member "e8ConfigListID".
     *
     *
     *
     * @param e8ConfigListID The value which will be set
     */
    inline void setE8ConfigListID (::tuner_main_fi_types::T_e8_Tun_ConfigListID e8ConfigListID_);

    // API of field "Tun_ConfigListElements"

    static const int kTun_ConfigListElements = 1;

    /**
     * Clears the field "Tun_ConfigListElements".
     *
     * The field will be set to its default value. The hasTun_ConfigListElements()
     * method will return false.
     */
    inline void clearTun_ConfigListElements();

    /**
     * Checks whether the field "Tun_ConfigListElements" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTun_ConfigListElements()). Otherwise it will return false.
     */
    inline bool hasTun_ConfigListElements () const;

    /**
     * Returns the value of the member "Tun_ConfigListElements".
     *
     *
     *
     * @return The value of the field "Tun_ConfigListElements"
     */
    inline const ::tuner_main_fi_types::T_TunerConfigListElementList& getTun_ConfigListElements () const;

    /**
     * Retrieves the value of the field "Tun_ConfigListElements" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Tun_ConfigListElements".
     */
    inline ::tuner_main_fi_types::T_TunerConfigListElementList& getTun_ConfigListElementsMutable ();

    /**
     * Sets the value of the member "Tun_ConfigListElements".
     *
     *
     *
     * @param Tun_ConfigListElements The value which will be set
     */
    inline void setTun_ConfigListElements (const ::tuner_main_fi_types::T_TunerConfigListElementList& Tun_ConfigListElements_);

    static const FID_TUN_G_SURVIELLANCE_LISTUPDATEStatus &getDefaultInstance();

private:

    static const ::std::vector< ::tuner_main_fi_types::T_TunerConfigListElement >& getT_TunerConfigListElementList_DefaultInstance ();

    inline void set_has_e8ConfigListID ();

    inline void clear_has_e8ConfigListID ();

    inline void set_has_Tun_ConfigListElements ();

    inline void clear_has_Tun_ConfigListElements ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::tuner_main_fi_types::T_e8_Tun_ConfigListID _e8ConfigListID;

    ::tuner_main_fi_types::T_TunerConfigListElementList _Tun_ConfigListElements;

};

/**
 * The get message of the property "FID_TUN_G_SURVIELLANCE_LISTUPDATE"
 * The number of config list elements is given by this property to SDS.
 */
class FID_TUN_G_SURVIELLANCE_LISTUPDATEGet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_SURVIELLANCE_LISTUPDATEGet ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_SURVIELLANCE_LISTUPDATEGet (const FID_TUN_G_SURVIELLANCE_LISTUPDATEGet &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_SURVIELLANCE_LISTUPDATEGet (::tuner_main_fi_types::T_e8_Tun_ConfigListID e8ConfigListID_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_SURVIELLANCE_LISTUPDATEGet();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_SURVIELLANCE_LISTUPDATEGet& operator = (const FID_TUN_G_SURVIELLANCE_LISTUPDATEGet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_SURVIELLANCE_LISTUPDATEGet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_SURVIELLANCE_LISTUPDATEGet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_SURVIELLANCE_LISTUPDATEGet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_SURVIELLANCE_LISTUPDATEGet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ConfigListID"

    static const int kE8ConfigListID = 0;

    /**
     * Clears the field "e8ConfigListID".
     *
     * The field will be set to its default value. The hasE8ConfigListID()
     * method will return false.
     */
    inline void clearE8ConfigListID();

    /**
     * Checks whether the field "e8ConfigListID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ConfigListID()). Otherwise it will return false.
     */
    inline bool hasE8ConfigListID () const;

    /**
     * Returns the value of the member "e8ConfigListID".
     *
     *
     *
     * @return The value of the field "e8ConfigListID"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_ConfigListID getE8ConfigListID () const;

    /**
     * Sets the value of the member "e8ConfigListID".
     *
     *
     *
     * @param e8ConfigListID The value which will be set
     */
    inline void setE8ConfigListID (::tuner_main_fi_types::T_e8_Tun_ConfigListID e8ConfigListID_);

    static const FID_TUN_G_SURVIELLANCE_LISTUPDATEGet &getDefaultInstance();

private:

    inline void set_has_e8ConfigListID ();

    inline void clear_has_e8ConfigListID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tuner_main_fi_types::T_e8_Tun_ConfigListID _e8ConfigListID;

};

/**
 * The status message of the property "FID_TUN_G_LISTUPDATE_NOTIFICATION"
 * List update notification whenever there is a change in station list.
 */
class FID_TUN_G_LISTUPDATE_NOTIFICATIONStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_LISTUPDATE_NOTIFICATIONStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_LISTUPDATE_NOTIFICATIONStatus (const FID_TUN_G_LISTUPDATE_NOTIFICATIONStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_LISTUPDATE_NOTIFICATIONStatus (bool bListUpdate_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_LISTUPDATE_NOTIFICATIONStatus();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_LISTUPDATE_NOTIFICATIONStatus& operator = (const FID_TUN_G_LISTUPDATE_NOTIFICATIONStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_LISTUPDATE_NOTIFICATIONStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_LISTUPDATE_NOTIFICATIONStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_LISTUPDATE_NOTIFICATIONStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_LISTUPDATE_NOTIFICATIONStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bListUpdate"

    static const int kBListUpdate = 0;

    /**
     * Clears the field "bListUpdate".
     *
     * The field will be set to its default value. The hasBListUpdate()
     * method will return false.
     */
    inline void clearBListUpdate();

    /**
     * Checks whether the field "bListUpdate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBListUpdate()). Otherwise it will return false.
     */
    inline bool hasBListUpdate () const;

    /**
     * Returns the value of the member "bListUpdate".
     *
     * TRUE: Station List updated.
     *
     * @return The value of the field "bListUpdate"
     */
    inline bool getBListUpdate () const;

    /**
     * Sets the value of the member "bListUpdate".
     *
     * TRUE: Station List updated.
     *
     * @param bListUpdate The value which will be set
     */
    inline void setBListUpdate (bool bListUpdate_);

    static const FID_TUN_G_LISTUPDATE_NOTIFICATIONStatus &getDefaultInstance();

private:

    inline void set_has_bListUpdate ();

    inline void clear_has_bListUpdate ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bListUpdate;

};

/**
 * The status message of the property "FID_TUN_G_GET_DARC_DATA"
 * This provides the DARC data received for respective stations.
 */
class FID_TUN_G_GET_DARC_DATAStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_GET_DARC_DATAStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_GET_DARC_DATAStatus (const FID_TUN_G_GET_DARC_DATAStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_GET_DARC_DATAStatus (uint32 Frequency_, const ::tuner_main_fi_types::T_DARCDataBlockList& DARCData_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_GET_DARC_DATAStatus();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_GET_DARC_DATAStatus& operator = (const FID_TUN_G_GET_DARC_DATAStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_GET_DARC_DATAStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_GET_DARC_DATAStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_GET_DARC_DATAStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_GET_DARC_DATAStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Frequency"

    static const int kFrequency = 0;

    /**
     * Clears the field "Frequency".
     *
     * The field will be set to its default value. The hasFrequency()
     * method will return false.
     */
    inline void clearFrequency();

    /**
     * Checks whether the field "Frequency" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFrequency()). Otherwise it will return false.
     */
    inline bool hasFrequency () const;

    /**
     * Returns the value of the member "Frequency".
     *
     * Frequency from which the DARC data are received.
     *
     * @return The value of the field "Frequency"
     */
    inline uint32 getFrequency () const;

    /**
     * Sets the value of the member "Frequency".
     *
     * Frequency from which the DARC data are received.
     *
     * @param Frequency The value which will be set
     */
    inline void setFrequency (uint32 Frequency_);

    // API of field "DARCData"

    static const int kDARCData = 1;

    /**
     * Clears the field "DARCData".
     *
     * The field will be set to its default value. The hasDARCData()
     * method will return false.
     */
    inline void clearDARCData();

    /**
     * Checks whether the field "DARCData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDARCData()). Otherwise it will return false.
     */
    inline bool hasDARCData () const;

    /**
     * Returns the value of the member "DARCData".
     *
     * DARC data received for respective station. CRC and Parity bytes from each DARC data block is not sent (from 36 data bytes to 24 data bytes)
     *
     * @return The value of the field "DARCData"
     */
    inline const ::tuner_main_fi_types::T_DARCDataBlockList& getDARCData () const;

    /**
     * Retrieves the value of the field "DARCData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DARCData".
     */
    inline ::tuner_main_fi_types::T_DARCDataBlockList& getDARCDataMutable ();

    /**
     * Sets the value of the member "DARCData".
     *
     * DARC data received for respective station. CRC and Parity bytes from each DARC data block is not sent (from 36 data bytes to 24 data bytes)
     *
     * @param DARCData The value which will be set
     */
    inline void setDARCData (const ::tuner_main_fi_types::T_DARCDataBlockList& DARCData_);

    static const FID_TUN_G_GET_DARC_DATAStatus &getDefaultInstance();

private:

    static const ::std::vector< ::tuner_main_fi_types::T_DARCDataBlock >& getT_DARCDataBlockList_DefaultInstance ();

    inline void set_has_Frequency ();

    inline void clear_has_Frequency ();

    inline void set_has_DARCData ();

    inline void clear_has_DARCData ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _Frequency;

    ::tuner_main_fi_types::T_DARCDataBlockList _DARCData;

};

/**
 * The status message of the property "FID_TUN_G_JAPAN_AREA"
 * Provides the updated region of JAPAN and also the mode of update (if area is updated automatically by GPS data or manually by the user)
 */
class FID_TUN_G_JAPAN_AREAStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_JAPAN_AREAStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_JAPAN_AREAStatus (const FID_TUN_G_JAPAN_AREAStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_JAPAN_AREAStatus (::tuner_main_fi_types::T_e8_Tun_Japan_Region e8SelectedRegion_, bool bAreaSelectionMode_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_JAPAN_AREAStatus();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_JAPAN_AREAStatus& operator = (const FID_TUN_G_JAPAN_AREAStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_JAPAN_AREAStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_JAPAN_AREAStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_JAPAN_AREAStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_JAPAN_AREAStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8SelectedRegion"

    static const int kE8SelectedRegion = 0;

    /**
     * Clears the field "e8SelectedRegion".
     *
     * The field will be set to its default value. The hasE8SelectedRegion()
     * method will return false.
     */
    inline void clearE8SelectedRegion();

    /**
     * Checks whether the field "e8SelectedRegion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8SelectedRegion()). Otherwise it will return false.
     */
    inline bool hasE8SelectedRegion () const;

    /**
     * Returns the value of the member "e8SelectedRegion".
     *
     * gives the selected japan region
     *
     * @return The value of the field "e8SelectedRegion"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_Japan_Region getE8SelectedRegion () const;

    /**
     * Sets the value of the member "e8SelectedRegion".
     *
     * gives the selected japan region
     *
     * @param e8SelectedRegion The value which will be set
     */
    inline void setE8SelectedRegion (::tuner_main_fi_types::T_e8_Tun_Japan_Region e8SelectedRegion_);

    // API of field "bAreaSelectionMode"

    static const int kBAreaSelectionMode = 1;

    /**
     * Clears the field "bAreaSelectionMode".
     *
     * The field will be set to its default value. The hasBAreaSelectionMode()
     * method will return false.
     */
    inline void clearBAreaSelectionMode();

    /**
     * Checks whether the field "bAreaSelectionMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBAreaSelectionMode()). Otherwise it will return false.
     */
    inline bool hasBAreaSelectionMode () const;

    /**
     * Returns the value of the member "bAreaSelectionMode".
     *
     * true : Manual Update (From HMI)
     * false : Automatic Update (From GPS Data)
     *
     * @return The value of the field "bAreaSelectionMode"
     */
    inline bool getBAreaSelectionMode () const;

    /**
     * Sets the value of the member "bAreaSelectionMode".
     *
     * true : Manual Update (From HMI)
     * false : Automatic Update (From GPS Data)
     *
     * @param bAreaSelectionMode The value which will be set
     */
    inline void setBAreaSelectionMode (bool bAreaSelectionMode_);

    static const FID_TUN_G_JAPAN_AREAStatus &getDefaultInstance();

private:

    inline void set_has_e8SelectedRegion ();

    inline void clear_has_e8SelectedRegion ();

    inline void set_has_bAreaSelectionMode ();

    inline void clear_has_bAreaSelectionMode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::tuner_main_fi_types::T_e8_Tun_Japan_Region _e8SelectedRegion;

    bool _bAreaSelectionMode;

};

/**
 * The status message of the property "FID_TUN_G_GET_ACTIVE_PRESETLISTID"
 * This provides the active preset list ID of FM and AM.
 */
class FID_TUN_G_GET_ACTIVE_PRESETLISTIDStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_GET_ACTIVE_PRESETLISTIDStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_GET_ACTIVE_PRESETLISTIDStatus (const FID_TUN_G_GET_ACTIVE_PRESETLISTIDStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_GET_ACTIVE_PRESETLISTIDStatus (::tuner_main_fi_types::T_e8_Tun_ListID FMPresetListID_, ::tuner_main_fi_types::T_e8_Tun_ListID AMPresetListID_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_GET_ACTIVE_PRESETLISTIDStatus();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_GET_ACTIVE_PRESETLISTIDStatus& operator = (const FID_TUN_G_GET_ACTIVE_PRESETLISTIDStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_GET_ACTIVE_PRESETLISTIDStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_GET_ACTIVE_PRESETLISTIDStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_GET_ACTIVE_PRESETLISTIDStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_GET_ACTIVE_PRESETLISTIDStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "FMPresetListID"

    static const int kFMPresetListID = 0;

    /**
     * Clears the field "FMPresetListID".
     *
     * The field will be set to its default value. The hasFMPresetListID()
     * method will return false.
     */
    inline void clearFMPresetListID();

    /**
     * Checks whether the field "FMPresetListID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFMPresetListID()). Otherwise it will return false.
     */
    inline bool hasFMPresetListID () const;

    /**
     * Returns the value of the member "FMPresetListID".
     *
     * Active FM preset list ID
     *
     * @return The value of the field "FMPresetListID"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_ListID getFMPresetListID () const;

    /**
     * Sets the value of the member "FMPresetListID".
     *
     * Active FM preset list ID
     *
     * @param FMPresetListID The value which will be set
     */
    inline void setFMPresetListID (::tuner_main_fi_types::T_e8_Tun_ListID FMPresetListID_);

    // API of field "AMPresetListID"

    static const int kAMPresetListID = 1;

    /**
     * Clears the field "AMPresetListID".
     *
     * The field will be set to its default value. The hasAMPresetListID()
     * method will return false.
     */
    inline void clearAMPresetListID();

    /**
     * Checks whether the field "AMPresetListID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAMPresetListID()). Otherwise it will return false.
     */
    inline bool hasAMPresetListID () const;

    /**
     * Returns the value of the member "AMPresetListID".
     *
     * Active AM preset list ID
     *
     * @return The value of the field "AMPresetListID"
     */
    inline ::tuner_main_fi_types::T_e8_Tun_ListID getAMPresetListID () const;

    /**
     * Sets the value of the member "AMPresetListID".
     *
     * Active AM preset list ID
     *
     * @param AMPresetListID The value which will be set
     */
    inline void setAMPresetListID (::tuner_main_fi_types::T_e8_Tun_ListID AMPresetListID_);

    static const FID_TUN_G_GET_ACTIVE_PRESETLISTIDStatus &getDefaultInstance();

private:

    inline void set_has_FMPresetListID ();

    inline void clear_has_FMPresetListID ();

    inline void set_has_AMPresetListID ();

    inline void clear_has_AMPresetListID ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::tuner_main_fi_types::T_e8_Tun_ListID _FMPresetListID;

    ::tuner_main_fi_types::T_e8_Tun_ListID _AMPresetListID;

};

/**
 * The status message of the property "FID_TUN_G_JAPAN_STATION_NAME_LIST"
 * Provides the list of Japan station names available for selected area code and given frequency. Status update will be sent upon UpReg.
 * Until RelUpReg is triggered, status will be posted to clients whenever there is change in language, area code, frequency or station name selection. RelUpReg whenever update is not needed.
 */
class FID_TUN_G_JAPAN_STATION_NAME_LISTStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUN_G_JAPAN_STATION_NAME_LISTStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUN_G_JAPAN_STATION_NAME_LISTStatus (const FID_TUN_G_JAPAN_STATION_NAME_LISTStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUN_G_JAPAN_STATION_NAME_LISTStatus (uint8 u8JapanStationCount_, const ::tuner_main_fi_types::T_TunerJapanStationNameList& JapanStationNamesList_, uint16 u16SelectedElement_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUN_G_JAPAN_STATION_NAME_LISTStatus();

    /**
     * Assignment operator
     */
    inline FID_TUN_G_JAPAN_STATION_NAME_LISTStatus& operator = (const FID_TUN_G_JAPAN_STATION_NAME_LISTStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUN_G_JAPAN_STATION_NAME_LISTStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUN_G_JAPAN_STATION_NAME_LISTStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUN_G_JAPAN_STATION_NAME_LISTStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUN_G_JAPAN_STATION_NAME_LISTStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8JapanStationCount"

    static const int kU8JapanStationCount = 0;

    /**
     * Clears the field "u8JapanStationCount".
     *
     * The field will be set to its default value. The hasU8JapanStationCount()
     * method will return false.
     */
    inline void clearU8JapanStationCount();

    /**
     * Checks whether the field "u8JapanStationCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8JapanStationCount()). Otherwise it will return false.
     */
    inline bool hasU8JapanStationCount () const;

    /**
     * Returns the value of the member "u8JapanStationCount".
     *
     * Provides the total number of Japan station names available at current frequency and selected area code
     *
     * @return The value of the field "u8JapanStationCount"
     */
    inline uint8 getU8JapanStationCount () const;

    /**
     * Sets the value of the member "u8JapanStationCount".
     *
     * Provides the total number of Japan station names available at current frequency and selected area code
     *
     * @param u8JapanStationCount The value which will be set
     */
    inline void setU8JapanStationCount (uint8 u8JapanStationCount_);

    // API of field "JapanStationNamesList"

    static const int kJapanStationNamesList = 1;

    /**
     * Clears the field "JapanStationNamesList".
     *
     * The field will be set to its default value. The hasJapanStationNamesList()
     * method will return false.
     */
    inline void clearJapanStationNamesList();

    /**
     * Checks whether the field "JapanStationNamesList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJapanStationNamesList()). Otherwise it will return false.
     */
    inline bool hasJapanStationNamesList () const;

    /**
     * Returns the value of the member "JapanStationNamesList".
     *
     * list of Japan station names
     *
     * @return The value of the field "JapanStationNamesList"
     */
    inline const ::tuner_main_fi_types::T_TunerJapanStationNameList& getJapanStationNamesList () const;

    /**
     * Retrieves the value of the field "JapanStationNamesList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "JapanStationNamesList".
     */
    inline ::tuner_main_fi_types::T_TunerJapanStationNameList& getJapanStationNamesListMutable ();

    /**
     * Sets the value of the member "JapanStationNamesList".
     *
     * list of Japan station names
     *
     * @param JapanStationNamesList The value which will be set
     */
    inline void setJapanStationNamesList (const ::tuner_main_fi_types::T_TunerJapanStationNameList& JapanStationNamesList_);

    // API of field "u16SelectedElement"

    static const int kU16SelectedElement = 2;

    /**
     * Clears the field "u16SelectedElement".
     *
     * The field will be set to its default value. The hasU16SelectedElement()
     * method will return false.
     */
    inline void clearU16SelectedElement();

    /**
     * Checks whether the field "u16SelectedElement" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16SelectedElement()). Otherwise it will return false.
     */
    inline bool hasU16SelectedElement () const;

    /**
     * Returns the value of the member "u16SelectedElement".
     *
     * Provides the index of current selected station name (Index ID is mapped to the position of the station name in DB)
     *
     * @return The value of the field "u16SelectedElement"
     */
    inline uint16 getU16SelectedElement () const;

    /**
     * Sets the value of the member "u16SelectedElement".
     *
     * Provides the index of current selected station name (Index ID is mapped to the position of the station name in DB)
     *
     * @param u16SelectedElement The value which will be set
     */
    inline void setU16SelectedElement (uint16 u16SelectedElement_);

    static const FID_TUN_G_JAPAN_STATION_NAME_LISTStatus &getDefaultInstance();

private:

    static const ::std::vector< ::tuner_main_fi_types::T_TunerJapanStationName >& getT_TunerJapanStationNameList_DefaultInstance ();

    inline void set_has_u8JapanStationCount ();

    inline void clear_has_u8JapanStationCount ();

    inline void set_has_JapanStationNamesList ();

    inline void clear_has_JapanStationNamesList ();

    inline void set_has_u16SelectedElement ();

    inline void clear_has_u16SelectedElement ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _u8JapanStationCount;

    ::tuner_main_fi_types::T_TunerJapanStationNameList _JapanStationNamesList;

    uint16 _u16SelectedElement;

};

inline  FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERStart::FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERStart ()  :
    _ManualFreqAdjustment (::tuner_main_fi_types::T_e8_Tun_ManualFreqAdjustment__TUN_SEEK_DIRECTION_UP),
    _TunerHeader (::tuner_main_fi_types::T_e8_Tun_TunerHeader__TUN_FOREGROUND)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERStart::FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERStart (const FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERStart &rhs)  :
    ::asf::core::Payload(rhs),
    _ManualFreqAdjustment (::tuner_main_fi_types::T_e8_Tun_ManualFreqAdjustment__TUN_SEEK_DIRECTION_UP),
    _TunerHeader (::tuner_main_fi_types::T_e8_Tun_TunerHeader__TUN_FOREGROUND)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERStart::FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERStart (::tuner_main_fi_types::T_e8_Tun_ManualFreqAdjustment ManualFreqAdjustment_, ::tuner_main_fi_types::T_e8_Tun_TunerHeader TunerHeader_)  :
    _ManualFreqAdjustment (ManualFreqAdjustment_),
    _TunerHeader (TunerHeader_)
{
    #ifndef NDEBUG
    if (!(::tuner_main_fi_types::T_e8_Tun_ManualFreqAdjustment_IsValid(ManualFreqAdjustment_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ManualFreqAdjustment_, "T_e8_Tun_ManualFreqAdjustment", "ManualFreqAdjustment", "FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERStart");
    }
    #endif
    #ifndef NDEBUG
    if (!(::tuner_main_fi_types::T_e8_Tun_TunerHeader_IsValid(TunerHeader_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TunerHeader_, "T_e8_Tun_TunerHeader", "TunerHeader", "FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERStart::~FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERStart() {
}

inline FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERStart& FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERStart::operator = (const FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasManualFreqAdjustment()) {
            setManualFreqAdjustment(rhs.getManualFreqAdjustment());
        } else {
            clearManualFreqAdjustment();
        }
        if (rhs.hasTunerHeader()) {
            setTunerHeader(rhs.getTunerHeader());
        } else {
            clearTunerHeader();
        }
    }
    return *this;
}

inline bool FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERStart::operator == (const FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERStart& rhs) const {
    return (((!hasManualFreqAdjustment() && !rhs.hasManualFreqAdjustment()) || getManualFreqAdjustment() == rhs.getManualFreqAdjustment()) &&
        ((!hasTunerHeader() && !rhs.hasTunerHeader()) || getTunerHeader() == rhs.getTunerHeader()));
}

inline bool FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERStart::operator != (const FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERStart& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERStart::operator < (const FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERStart& rhs) const {
    if (hasManualFreqAdjustment() || rhs.hasManualFreqAdjustment()) {
        if ((uint32)getManualFreqAdjustment() < (uint32)rhs.getManualFreqAdjustment()) return true;
        if ((uint32)getManualFreqAdjustment() > (uint32)rhs.getManualFreqAdjustment()) return false;
    }
    if (hasTunerHeader() || rhs.hasTunerHeader()) {
        if ((uint32)getTunerHeader() < (uint32)rhs.getTunerHeader()) return true;
        if ((uint32)getTunerHeader() > (uint32)rhs.getTunerHeader()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERStart::clone() {
    return new FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERStart(*this);
}

inline bool FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERStart::operator > (const FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERStart::clear() {
    clearManualFreqAdjustment();
    clearTunerHeader();
}

inline void FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERStart::clearManualFreqAdjustment() {
    if (hasManualFreqAdjustment()) {
         clear_has_ManualFreqAdjustment();
        _ManualFreqAdjustment = ::tuner_main_fi_types::T_e8_Tun_ManualFreqAdjustment__TUN_SEEK_DIRECTION_UP;
     }
}

inline bool FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERStart::hasManualFreqAdjustment () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::tuner_main_fi_types::T_e8_Tun_ManualFreqAdjustment FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERStart::getManualFreqAdjustment () const {
    return _ManualFreqAdjustment;
}

inline void FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERStart::setManualFreqAdjustment (::tuner_main_fi_types::T_e8_Tun_ManualFreqAdjustment ManualFreqAdjustment_) {
    #ifndef NDEBUG
    if (!(::tuner_main_fi_types::T_e8_Tun_ManualFreqAdjustment_IsValid(ManualFreqAdjustment_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ManualFreqAdjustment_, "T_e8_Tun_ManualFreqAdjustment", "ManualFreqAdjustment", "FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERStart");
    }
    #endif
    set_has_ManualFreqAdjustment();
    this->_ManualFreqAdjustment = ManualFreqAdjustment_;
}

inline void FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERStart::clearTunerHeader() {
    if (hasTunerHeader()) {
         clear_has_TunerHeader();
        _TunerHeader = ::tuner_main_fi_types::T_e8_Tun_TunerHeader__TUN_FOREGROUND;
     }
}

inline bool FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERStart::hasTunerHeader () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::tuner_main_fi_types::T_e8_Tun_TunerHeader FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERStart::getTunerHeader () const {
    return _TunerHeader;
}

inline void FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERStart::setTunerHeader (::tuner_main_fi_types::T_e8_Tun_TunerHeader TunerHeader_) {
    #ifndef NDEBUG
    if (!(::tuner_main_fi_types::T_e8_Tun_TunerHeader_IsValid(TunerHeader_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TunerHeader_, "T_e8_Tun_TunerHeader", "TunerHeader", "FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERStart");
    }
    #endif
    set_has_TunerHeader();
    this->_TunerHeader = TunerHeader_;
}

inline void FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERStart::set_has_ManualFreqAdjustment () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERStart::clear_has_ManualFreqAdjustment () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERStart::set_has_TunerHeader () {
    _has_bits_[0] |= 1u << 1;
}

inline void FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERStart::clear_has_TunerHeader () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERResult::FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERResult ()  :
    _TunerServer_StatusResponse ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERResult::FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERResult (const FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERResult &rhs)  :
    ::asf::core::Payload(rhs),
    _TunerServer_StatusResponse ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERResult::FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_)  :
    _TunerServer_StatusResponse (TunerServer_StatusResponse_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERResult::~FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERResult() {
}

inline FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERResult& FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERResult::operator = (const FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTunerServer_StatusResponse()) {
            setTunerServer_StatusResponse(rhs.getTunerServer_StatusResponse());
        } else {
            clearTunerServer_StatusResponse();
        }
    }
    return *this;
}

inline bool FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERResult::operator == (const FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERResult& rhs) const {
    return (((!hasTunerServer_StatusResponse() && !rhs.hasTunerServer_StatusResponse()) || getTunerServer_StatusResponse() == rhs.getTunerServer_StatusResponse()));
}

inline bool FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERResult::operator != (const FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERResult& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERResult::operator < (const FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERResult& rhs) const {
    if (hasTunerServer_StatusResponse() || rhs.hasTunerServer_StatusResponse()) {
        if (getTunerServer_StatusResponse() < rhs.getTunerServer_StatusResponse()) return true;
        if (getTunerServer_StatusResponse() > rhs.getTunerServer_StatusResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERResult::clone() {
    return new FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERResult(*this);
}

inline bool FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERResult::operator > (const FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERResult::clear() {
    clearTunerServer_StatusResponse();
}

inline void FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERResult::clearTunerServer_StatusResponse() {
    if (hasTunerServer_StatusResponse()) {
         clear_has_TunerServer_StatusResponse();
        _TunerServer_StatusResponse.clear();
     }
}

inline bool FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERResult::hasTunerServer_StatusResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERResult::getTunerServer_StatusResponse () const {
    return _TunerServer_StatusResponse;
}

inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERResult::getTunerServer_StatusResponseMutable () {
    set_has_TunerServer_StatusResponse();
    return _TunerServer_StatusResponse;
}

inline void FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERResult::setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_) {
    set_has_TunerServer_StatusResponse();
    this->_TunerServer_StatusResponse = TunerServer_StatusResponse_;
}

inline void FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERResult::set_has_TunerServer_StatusResponse () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERResult::clear_has_TunerServer_StatusResponse () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FID_TUN_S_ATFREQUENCYStart::FID_TUN_S_ATFREQUENCYStart ()  :
    _TunerHeader (::tuner_main_fi_types::T_e8_Tun_TunerHeader__TUN_FOREGROUND),
    _TunerManualSingleStep (),
    _u8AcceptAF (::tuner_main_fi_types::T_e8_Tun_AcceptAF__TUN_NOT_ACCEPT_AF)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUN_S_ATFREQUENCYStart::FID_TUN_S_ATFREQUENCYStart (const FID_TUN_S_ATFREQUENCYStart &rhs)  :
    ::asf::core::Payload(rhs),
    _TunerHeader (::tuner_main_fi_types::T_e8_Tun_TunerHeader__TUN_FOREGROUND),
    _TunerManualSingleStep (),
    _u8AcceptAF (::tuner_main_fi_types::T_e8_Tun_AcceptAF__TUN_NOT_ACCEPT_AF)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUN_S_ATFREQUENCYStart::FID_TUN_S_ATFREQUENCYStart (::tuner_main_fi_types::T_e8_Tun_TunerHeader TunerHeader_, const ::tuner_main_fi_types::T_TunerManualSingleStep& TunerManualSingleStep_, ::tuner_main_fi_types::T_e8_Tun_AcceptAF u8AcceptAF_)  :
    _TunerHeader (TunerHeader_),
    _TunerManualSingleStep (TunerManualSingleStep_),
    _u8AcceptAF (u8AcceptAF_)
{
    #ifndef NDEBUG
    if (!(::tuner_main_fi_types::T_e8_Tun_TunerHeader_IsValid(TunerHeader_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TunerHeader_, "T_e8_Tun_TunerHeader", "TunerHeader", "FID_TUN_S_ATFREQUENCYStart");
    }
    #endif
    #ifndef NDEBUG
    if (!(::tuner_main_fi_types::T_e8_Tun_AcceptAF_IsValid(u8AcceptAF_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8AcceptAF_, "T_e8_Tun_AcceptAF", "u8AcceptAF", "FID_TUN_S_ATFREQUENCYStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUN_S_ATFREQUENCYStart::~FID_TUN_S_ATFREQUENCYStart() {
}

inline FID_TUN_S_ATFREQUENCYStart& FID_TUN_S_ATFREQUENCYStart::operator = (const FID_TUN_S_ATFREQUENCYStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTunerHeader()) {
            setTunerHeader(rhs.getTunerHeader());
        } else {
            clearTunerHeader();
        }
        if (rhs.hasTunerManualSingleStep()) {
            setTunerManualSingleStep(rhs.getTunerManualSingleStep());
        } else {
            clearTunerManualSingleStep();
        }
        if (rhs.hasU8AcceptAF()) {
            setU8AcceptAF(rhs.getU8AcceptAF());
        } else {
            clearU8AcceptAF();
        }
    }
    return *this;
}

inline bool FID_TUN_S_ATFREQUENCYStart::operator == (const FID_TUN_S_ATFREQUENCYStart& rhs) const {
    return (((!hasTunerHeader() && !rhs.hasTunerHeader()) || getTunerHeader() == rhs.getTunerHeader()) &&
        ((!hasTunerManualSingleStep() && !rhs.hasTunerManualSingleStep()) || getTunerManualSingleStep() == rhs.getTunerManualSingleStep()) &&
        ((!hasU8AcceptAF() && !rhs.hasU8AcceptAF()) || getU8AcceptAF() == rhs.getU8AcceptAF()));
}

inline bool FID_TUN_S_ATFREQUENCYStart::operator != (const FID_TUN_S_ATFREQUENCYStart& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUN_S_ATFREQUENCYStart::operator < (const FID_TUN_S_ATFREQUENCYStart& rhs) const {
    if (hasTunerHeader() || rhs.hasTunerHeader()) {
        if ((uint32)getTunerHeader() < (uint32)rhs.getTunerHeader()) return true;
        if ((uint32)getTunerHeader() > (uint32)rhs.getTunerHeader()) return false;
    }
    if (hasTunerManualSingleStep() || rhs.hasTunerManualSingleStep()) {
        if (getTunerManualSingleStep() < rhs.getTunerManualSingleStep()) return true;
        if (getTunerManualSingleStep() > rhs.getTunerManualSingleStep()) return false;
    }
    if (hasU8AcceptAF() || rhs.hasU8AcceptAF()) {
        if ((uint32)getU8AcceptAF() < (uint32)rhs.getU8AcceptAF()) return true;
        if ((uint32)getU8AcceptAF() > (uint32)rhs.getU8AcceptAF()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUN_S_ATFREQUENCYStart::clone() {
    return new FID_TUN_S_ATFREQUENCYStart(*this);
}

inline bool FID_TUN_S_ATFREQUENCYStart::operator > (const FID_TUN_S_ATFREQUENCYStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUN_S_ATFREQUENCYStart::clear() {
    clearTunerHeader();
    clearTunerManualSingleStep();
    clearU8AcceptAF();
}

inline void FID_TUN_S_ATFREQUENCYStart::clearTunerHeader() {
    if (hasTunerHeader()) {
         clear_has_TunerHeader();
        _TunerHeader = ::tuner_main_fi_types::T_e8_Tun_TunerHeader__TUN_FOREGROUND;
     }
}

inline bool FID_TUN_S_ATFREQUENCYStart::hasTunerHeader () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::tuner_main_fi_types::T_e8_Tun_TunerHeader FID_TUN_S_ATFREQUENCYStart::getTunerHeader () const {
    return _TunerHeader;
}

inline void FID_TUN_S_ATFREQUENCYStart::setTunerHeader (::tuner_main_fi_types::T_e8_Tun_TunerHeader TunerHeader_) {
    #ifndef NDEBUG
    if (!(::tuner_main_fi_types::T_e8_Tun_TunerHeader_IsValid(TunerHeader_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TunerHeader_, "T_e8_Tun_TunerHeader", "TunerHeader", "FID_TUN_S_ATFREQUENCYStart");
    }
    #endif
    set_has_TunerHeader();
    this->_TunerHeader = TunerHeader_;
}

inline void FID_TUN_S_ATFREQUENCYStart::clearTunerManualSingleStep() {
    if (hasTunerManualSingleStep()) {
         clear_has_TunerManualSingleStep();
        _TunerManualSingleStep.clear();
     }
}

inline bool FID_TUN_S_ATFREQUENCYStart::hasTunerManualSingleStep () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::tuner_main_fi_types::T_TunerManualSingleStep& FID_TUN_S_ATFREQUENCYStart::getTunerManualSingleStep () const {
    return _TunerManualSingleStep;
}

inline ::tuner_main_fi_types::T_TunerManualSingleStep& FID_TUN_S_ATFREQUENCYStart::getTunerManualSingleStepMutable () {
    set_has_TunerManualSingleStep();
    return _TunerManualSingleStep;
}

inline void FID_TUN_S_ATFREQUENCYStart::setTunerManualSingleStep (const ::tuner_main_fi_types::T_TunerManualSingleStep& TunerManualSingleStep_) {
    set_has_TunerManualSingleStep();
    this->_TunerManualSingleStep = TunerManualSingleStep_;
}

inline void FID_TUN_S_ATFREQUENCYStart::clearU8AcceptAF() {
    if (hasU8AcceptAF()) {
         clear_has_u8AcceptAF();
        _u8AcceptAF = ::tuner_main_fi_types::T_e8_Tun_AcceptAF__TUN_NOT_ACCEPT_AF;
     }
}

inline bool FID_TUN_S_ATFREQUENCYStart::hasU8AcceptAF () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline ::tuner_main_fi_types::T_e8_Tun_AcceptAF FID_TUN_S_ATFREQUENCYStart::getU8AcceptAF () const {
    return _u8AcceptAF;
}

inline void FID_TUN_S_ATFREQUENCYStart::setU8AcceptAF (::tuner_main_fi_types::T_e8_Tun_AcceptAF u8AcceptAF_) {
    #ifndef NDEBUG
    if (!(::tuner_main_fi_types::T_e8_Tun_AcceptAF_IsValid(u8AcceptAF_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8AcceptAF_, "T_e8_Tun_AcceptAF", "u8AcceptAF", "FID_TUN_S_ATFREQUENCYStart");
    }
    #endif
    set_has_u8AcceptAF();
    this->_u8AcceptAF = u8AcceptAF_;
}

inline void FID_TUN_S_ATFREQUENCYStart::set_has_TunerHeader () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUN_S_ATFREQUENCYStart::clear_has_TunerHeader () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void FID_TUN_S_ATFREQUENCYStart::set_has_TunerManualSingleStep () {
    _has_bits_[0] |= 1u << 1;
}

inline void FID_TUN_S_ATFREQUENCYStart::clear_has_TunerManualSingleStep () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void FID_TUN_S_ATFREQUENCYStart::set_has_u8AcceptAF () {
    _has_bits_[0] |= 1u << 2;
}

inline void FID_TUN_S_ATFREQUENCYStart::clear_has_u8AcceptAF () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  FID_TUN_S_ATFREQUENCYResult::FID_TUN_S_ATFREQUENCYResult ()  :
    _TunerServer_StatusResponse ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUN_S_ATFREQUENCYResult::FID_TUN_S_ATFREQUENCYResult (const FID_TUN_S_ATFREQUENCYResult &rhs)  :
    ::asf::core::Payload(rhs),
    _TunerServer_StatusResponse ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUN_S_ATFREQUENCYResult::FID_TUN_S_ATFREQUENCYResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_)  :
    _TunerServer_StatusResponse (TunerServer_StatusResponse_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUN_S_ATFREQUENCYResult::~FID_TUN_S_ATFREQUENCYResult() {
}

inline FID_TUN_S_ATFREQUENCYResult& FID_TUN_S_ATFREQUENCYResult::operator = (const FID_TUN_S_ATFREQUENCYResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTunerServer_StatusResponse()) {
            setTunerServer_StatusResponse(rhs.getTunerServer_StatusResponse());
        } else {
            clearTunerServer_StatusResponse();
        }
    }
    return *this;
}

inline bool FID_TUN_S_ATFREQUENCYResult::operator == (const FID_TUN_S_ATFREQUENCYResult& rhs) const {
    return (((!hasTunerServer_StatusResponse() && !rhs.hasTunerServer_StatusResponse()) || getTunerServer_StatusResponse() == rhs.getTunerServer_StatusResponse()));
}

inline bool FID_TUN_S_ATFREQUENCYResult::operator != (const FID_TUN_S_ATFREQUENCYResult& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUN_S_ATFREQUENCYResult::operator < (const FID_TUN_S_ATFREQUENCYResult& rhs) const {
    if (hasTunerServer_StatusResponse() || rhs.hasTunerServer_StatusResponse()) {
        if (getTunerServer_StatusResponse() < rhs.getTunerServer_StatusResponse()) return true;
        if (getTunerServer_StatusResponse() > rhs.getTunerServer_StatusResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUN_S_ATFREQUENCYResult::clone() {
    return new FID_TUN_S_ATFREQUENCYResult(*this);
}

inline bool FID_TUN_S_ATFREQUENCYResult::operator > (const FID_TUN_S_ATFREQUENCYResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUN_S_ATFREQUENCYResult::clear() {
    clearTunerServer_StatusResponse();
}

inline void FID_TUN_S_ATFREQUENCYResult::clearTunerServer_StatusResponse() {
    if (hasTunerServer_StatusResponse()) {
         clear_has_TunerServer_StatusResponse();
        _TunerServer_StatusResponse.clear();
     }
}

inline bool FID_TUN_S_ATFREQUENCYResult::hasTunerServer_StatusResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& FID_TUN_S_ATFREQUENCYResult::getTunerServer_StatusResponse () const {
    return _TunerServer_StatusResponse;
}

inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& FID_TUN_S_ATFREQUENCYResult::getTunerServer_StatusResponseMutable () {
    set_has_TunerServer_StatusResponse();
    return _TunerServer_StatusResponse;
}

inline void FID_TUN_S_ATFREQUENCYResult::setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_) {
    set_has_TunerServer_StatusResponse();
    this->_TunerServer_StatusResponse = TunerServer_StatusResponse_;
}

inline void FID_TUN_S_ATFREQUENCYResult::set_has_TunerServer_StatusResponse () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUN_S_ATFREQUENCYResult::clear_has_TunerServer_StatusResponse () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart::FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart ()  :
    _u8TunerSeek (::tuner_main_fi_types::T_e8_Tun_TunerSeek__TUN_SEEKTYPE_OFF),
    _u8TunerHeader (::tuner_main_fi_types::T_e8_Tun_TunerHeader__TUN_FOREGROUND),
    _u32Frequency (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart::FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart (const FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart &rhs)  :
    ::asf::core::Payload(rhs),
    _u8TunerSeek (::tuner_main_fi_types::T_e8_Tun_TunerSeek__TUN_SEEKTYPE_OFF),
    _u8TunerHeader (::tuner_main_fi_types::T_e8_Tun_TunerHeader__TUN_FOREGROUND),
    _u32Frequency (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart::FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart (::tuner_main_fi_types::T_e8_Tun_TunerSeek u8TunerSeek_, ::tuner_main_fi_types::T_e8_Tun_TunerHeader u8TunerHeader_, uint32 u32Frequency_)  :
    _u8TunerSeek (u8TunerSeek_),
    _u8TunerHeader (u8TunerHeader_),
    _u32Frequency (u32Frequency_)
{
    #ifndef NDEBUG
    if (!(::tuner_main_fi_types::T_e8_Tun_TunerSeek_IsValid(u8TunerSeek_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8TunerSeek_, "T_e8_Tun_TunerSeek", "u8TunerSeek", "FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart");
    }
    #endif
    #ifndef NDEBUG
    if (!(::tuner_main_fi_types::T_e8_Tun_TunerHeader_IsValid(u8TunerHeader_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8TunerHeader_, "T_e8_Tun_TunerHeader", "u8TunerHeader", "FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart::~FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart() {
}

inline FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart& FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart::operator = (const FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasU8TunerSeek()) {
            setU8TunerSeek(rhs.getU8TunerSeek());
        } else {
            clearU8TunerSeek();
        }
        if (rhs.hasU8TunerHeader()) {
            setU8TunerHeader(rhs.getU8TunerHeader());
        } else {
            clearU8TunerHeader();
        }
        if (rhs.hasU32Frequency()) {
            setU32Frequency(rhs.getU32Frequency());
        } else {
            clearU32Frequency();
        }
    }
    return *this;
}

inline bool FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart::operator == (const FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart& rhs) const {
    return (((!hasU8TunerSeek() && !rhs.hasU8TunerSeek()) || getU8TunerSeek() == rhs.getU8TunerSeek()) &&
        ((!hasU8TunerHeader() && !rhs.hasU8TunerHeader()) || getU8TunerHeader() == rhs.getU8TunerHeader()) &&
        ((!hasU32Frequency() && !rhs.hasU32Frequency()) || getU32Frequency() == rhs.getU32Frequency()));
}

inline bool FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart::operator != (const FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart::operator < (const FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart& rhs) const {
    if (hasU8TunerSeek() || rhs.hasU8TunerSeek()) {
        if ((uint32)getU8TunerSeek() < (uint32)rhs.getU8TunerSeek()) return true;
        if ((uint32)getU8TunerSeek() > (uint32)rhs.getU8TunerSeek()) return false;
    }
    if (hasU8TunerHeader() || rhs.hasU8TunerHeader()) {
        if ((uint32)getU8TunerHeader() < (uint32)rhs.getU8TunerHeader()) return true;
        if ((uint32)getU8TunerHeader() > (uint32)rhs.getU8TunerHeader()) return false;
    }
    if (hasU32Frequency() || rhs.hasU32Frequency()) {
        if (getU32Frequency() < rhs.getU32Frequency()) return true;
        if (getU32Frequency() > rhs.getU32Frequency()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart::clone() {
    return new FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart(*this);
}

inline bool FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart::operator > (const FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart::clear() {
    clearU8TunerSeek();
    clearU8TunerHeader();
    clearU32Frequency();
}

inline void FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart::clearU8TunerSeek() {
    if (hasU8TunerSeek()) {
         clear_has_u8TunerSeek();
        _u8TunerSeek = ::tuner_main_fi_types::T_e8_Tun_TunerSeek__TUN_SEEKTYPE_OFF;
     }
}

inline bool FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart::hasU8TunerSeek () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::tuner_main_fi_types::T_e8_Tun_TunerSeek FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart::getU8TunerSeek () const {
    return _u8TunerSeek;
}

inline void FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart::setU8TunerSeek (::tuner_main_fi_types::T_e8_Tun_TunerSeek u8TunerSeek_) {
    #ifndef NDEBUG
    if (!(::tuner_main_fi_types::T_e8_Tun_TunerSeek_IsValid(u8TunerSeek_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8TunerSeek_, "T_e8_Tun_TunerSeek", "u8TunerSeek", "FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart");
    }
    #endif
    set_has_u8TunerSeek();
    this->_u8TunerSeek = u8TunerSeek_;
}

inline void FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart::clearU8TunerHeader() {
    if (hasU8TunerHeader()) {
         clear_has_u8TunerHeader();
        _u8TunerHeader = ::tuner_main_fi_types::T_e8_Tun_TunerHeader__TUN_FOREGROUND;
     }
}

inline bool FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart::hasU8TunerHeader () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::tuner_main_fi_types::T_e8_Tun_TunerHeader FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart::getU8TunerHeader () const {
    return _u8TunerHeader;
}

inline void FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart::setU8TunerHeader (::tuner_main_fi_types::T_e8_Tun_TunerHeader u8TunerHeader_) {
    #ifndef NDEBUG
    if (!(::tuner_main_fi_types::T_e8_Tun_TunerHeader_IsValid(u8TunerHeader_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8TunerHeader_, "T_e8_Tun_TunerHeader", "u8TunerHeader", "FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart");
    }
    #endif
    set_has_u8TunerHeader();
    this->_u8TunerHeader = u8TunerHeader_;
}

inline void FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart::clearU32Frequency() {
    if (hasU32Frequency()) {
         clear_has_u32Frequency();
        _u32Frequency = 0u;
     }
}

inline bool FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart::hasU32Frequency () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart::getU32Frequency () const {
    return _u32Frequency;
}

inline void FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart::setU32Frequency (uint32 u32Frequency_) {
    set_has_u32Frequency();
    this->_u32Frequency = u32Frequency_;
}

inline void FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart::set_has_u8TunerSeek () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart::clear_has_u8TunerSeek () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart::set_has_u8TunerHeader () {
    _has_bits_[0] |= 1u << 1;
}

inline void FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart::clear_has_u8TunerHeader () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart::set_has_u32Frequency () {
    _has_bits_[0] |= 1u << 2;
}

inline void FID_TUN_S_ATSEEK_WITH_TUNERHEADERStart::clear_has_u32Frequency () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  FID_TUN_S_ATSEEK_WITH_TUNERHEADERResult::FID_TUN_S_ATSEEK_WITH_TUNERHEADERResult ()  :
    _TunerServer_StatusResponse ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUN_S_ATSEEK_WITH_TUNERHEADERResult::FID_TUN_S_ATSEEK_WITH_TUNERHEADERResult (const FID_TUN_S_ATSEEK_WITH_TUNERHEADERResult &rhs)  :
    ::asf::core::Payload(rhs),
    _TunerServer_StatusResponse ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUN_S_ATSEEK_WITH_TUNERHEADERResult::FID_TUN_S_ATSEEK_WITH_TUNERHEADERResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_)  :
    _TunerServer_StatusResponse (TunerServer_StatusResponse_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUN_S_ATSEEK_WITH_TUNERHEADERResult::~FID_TUN_S_ATSEEK_WITH_TUNERHEADERResult() {
}

inline FID_TUN_S_ATSEEK_WITH_TUNERHEADERResult& FID_TUN_S_ATSEEK_WITH_TUNERHEADERResult::operator = (const FID_TUN_S_ATSEEK_WITH_TUNERHEADERResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTunerServer_StatusResponse()) {
            setTunerServer_StatusResponse(rhs.getTunerServer_StatusResponse());
        } else {
            clearTunerServer_StatusResponse();
        }
    }
    return *this;
}

inline bool FID_TUN_S_ATSEEK_WITH_TUNERHEADERResult::operator == (const FID_TUN_S_ATSEEK_WITH_TUNERHEADERResult& rhs) const {
    return (((!hasTunerServer_StatusResponse() && !rhs.hasTunerServer_StatusResponse()) || getTunerServer_StatusResponse() == rhs.getTunerServer_StatusResponse()));
}

inline bool FID_TUN_S_ATSEEK_WITH_TUNERHEADERResult::operator != (const FID_TUN_S_ATSEEK_WITH_TUNERHEADERResult& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUN_S_ATSEEK_WITH_TUNERHEADERResult::operator < (const FID_TUN_S_ATSEEK_WITH_TUNERHEADERResult& rhs) const {
    if (hasTunerServer_StatusResponse() || rhs.hasTunerServer_StatusResponse()) {
        if (getTunerServer_StatusResponse() < rhs.getTunerServer_StatusResponse()) return true;
        if (getTunerServer_StatusResponse() > rhs.getTunerServer_StatusResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUN_S_ATSEEK_WITH_TUNERHEADERResult::clone() {
    return new FID_TUN_S_ATSEEK_WITH_TUNERHEADERResult(*this);
}

inline bool FID_TUN_S_ATSEEK_WITH_TUNERHEADERResult::operator > (const FID_TUN_S_ATSEEK_WITH_TUNERHEADERResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUN_S_ATSEEK_WITH_TUNERHEADERResult::clear() {
    clearTunerServer_StatusResponse();
}

inline void FID_TUN_S_ATSEEK_WITH_TUNERHEADERResult::clearTunerServer_StatusResponse() {
    if (hasTunerServer_StatusResponse()) {
         clear_has_TunerServer_StatusResponse();
        _TunerServer_StatusResponse.clear();
     }
}

inline bool FID_TUN_S_ATSEEK_WITH_TUNERHEADERResult::hasTunerServer_StatusResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& FID_TUN_S_ATSEEK_WITH_TUNERHEADERResult::getTunerServer_StatusResponse () const {
    return _TunerServer_StatusResponse;
}

inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& FID_TUN_S_ATSEEK_WITH_TUNERHEADERResult::getTunerServer_StatusResponseMutable () {
    set_has_TunerServer_StatusResponse();
    return _TunerServer_StatusResponse;
}

inline void FID_TUN_S_ATSEEK_WITH_TUNERHEADERResult::setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_) {
    set_has_TunerServer_StatusResponse();
    this->_TunerServer_StatusResponse = TunerServer_StatusResponse_;
}

inline void FID_TUN_S_ATSEEK_WITH_TUNERHEADERResult::set_has_TunerServer_StatusResponse () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUN_S_ATSEEK_WITH_TUNERHEADERResult::clear_has_TunerServer_StatusResponse () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FID_S_TUN_GET_FIELD_STRENGTHResult::FID_S_TUN_GET_FIELD_STRENGTHResult ()  :
    _Tuner_Field_Strength (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_S_TUN_GET_FIELD_STRENGTHResult::FID_S_TUN_GET_FIELD_STRENGTHResult (const FID_S_TUN_GET_FIELD_STRENGTHResult &rhs)  :
    ::asf::core::Payload(rhs),
    _Tuner_Field_Strength (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_S_TUN_GET_FIELD_STRENGTHResult::FID_S_TUN_GET_FIELD_STRENGTHResult (uint8 Tuner_Field_Strength_)  :
    _Tuner_Field_Strength (Tuner_Field_Strength_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_S_TUN_GET_FIELD_STRENGTHResult::~FID_S_TUN_GET_FIELD_STRENGTHResult() {
}

inline FID_S_TUN_GET_FIELD_STRENGTHResult& FID_S_TUN_GET_FIELD_STRENGTHResult::operator = (const FID_S_TUN_GET_FIELD_STRENGTHResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTuner_Field_Strength()) {
            setTuner_Field_Strength(rhs.getTuner_Field_Strength());
        } else {
            clearTuner_Field_Strength();
        }
    }
    return *this;
}

inline bool FID_S_TUN_GET_FIELD_STRENGTHResult::operator == (const FID_S_TUN_GET_FIELD_STRENGTHResult& rhs) const {
    return (((!hasTuner_Field_Strength() && !rhs.hasTuner_Field_Strength()) || getTuner_Field_Strength() == rhs.getTuner_Field_Strength()));
}

inline bool FID_S_TUN_GET_FIELD_STRENGTHResult::operator != (const FID_S_TUN_GET_FIELD_STRENGTHResult& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_S_TUN_GET_FIELD_STRENGTHResult::operator < (const FID_S_TUN_GET_FIELD_STRENGTHResult& rhs) const {
    if (hasTuner_Field_Strength() || rhs.hasTuner_Field_Strength()) {
        if (getTuner_Field_Strength() < rhs.getTuner_Field_Strength()) return true;
        if (getTuner_Field_Strength() > rhs.getTuner_Field_Strength()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_S_TUN_GET_FIELD_STRENGTHResult::clone() {
    return new FID_S_TUN_GET_FIELD_STRENGTHResult(*this);
}

inline bool FID_S_TUN_GET_FIELD_STRENGTHResult::operator > (const FID_S_TUN_GET_FIELD_STRENGTHResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_S_TUN_GET_FIELD_STRENGTHResult::clear() {
    clearTuner_Field_Strength();
}

inline void FID_S_TUN_GET_FIELD_STRENGTHResult::clearTuner_Field_Strength() {
    if (hasTuner_Field_Strength()) {
         clear_has_Tuner_Field_Strength();
        _Tuner_Field_Strength = 0u;
     }
}

inline bool FID_S_TUN_GET_FIELD_STRENGTHResult::hasTuner_Field_Strength () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 FID_S_TUN_GET_FIELD_STRENGTHResult::getTuner_Field_Strength () const {
    return _Tuner_Field_Strength;
}

inline void FID_S_TUN_GET_FIELD_STRENGTHResult::setTuner_Field_Strength (uint8 Tuner_Field_Strength_) {
    set_has_Tuner_Field_Strength();
    this->_Tuner_Field_Strength = Tuner_Field_Strength_;
}

inline void FID_S_TUN_GET_FIELD_STRENGTHResult::set_has_Tuner_Field_Strength () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_S_TUN_GET_FIELD_STRENGTHResult::clear_has_Tuner_Field_Strength () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FID_TUN_S_SET_ACTIVE_PRESETLISTStart::FID_TUN_S_SET_ACTIVE_PRESETLISTStart ()  :
    _e8ListID (::tuner_main_fi_types::T_e8_Tun_ListID__TUN_BANK_FM1)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUN_S_SET_ACTIVE_PRESETLISTStart::FID_TUN_S_SET_ACTIVE_PRESETLISTStart (const FID_TUN_S_SET_ACTIVE_PRESETLISTStart &rhs)  :
    ::asf::core::Payload(rhs),
    _e8ListID (::tuner_main_fi_types::T_e8_Tun_ListID__TUN_BANK_FM1)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUN_S_SET_ACTIVE_PRESETLISTStart::FID_TUN_S_SET_ACTIVE_PRESETLISTStart (::tuner_main_fi_types::T_e8_Tun_ListID e8ListID_)  :
    _e8ListID (e8ListID_)
{
    #ifndef NDEBUG
    if (!(::tuner_main_fi_types::T_e8_Tun_ListID_IsValid(e8ListID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8ListID_, "T_e8_Tun_ListID", "e8ListID", "FID_TUN_S_SET_ACTIVE_PRESETLISTStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUN_S_SET_ACTIVE_PRESETLISTStart::~FID_TUN_S_SET_ACTIVE_PRESETLISTStart() {
}

inline FID_TUN_S_SET_ACTIVE_PRESETLISTStart& FID_TUN_S_SET_ACTIVE_PRESETLISTStart::operator = (const FID_TUN_S_SET_ACTIVE_PRESETLISTStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasE8ListID()) {
            setE8ListID(rhs.getE8ListID());
        } else {
            clearE8ListID();
        }
    }
    return *this;
}

inline bool FID_TUN_S_SET_ACTIVE_PRESETLISTStart::operator == (const FID_TUN_S_SET_ACTIVE_PRESETLISTStart& rhs) const {
    return (((!hasE8ListID() && !rhs.hasE8ListID()) || getE8ListID() == rhs.getE8ListID()));
}

inline bool FID_TUN_S_SET_ACTIVE_PRESETLISTStart::operator != (const FID_TUN_S_SET_ACTIVE_PRESETLISTStart& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUN_S_SET_ACTIVE_PRESETLISTStart::operator < (const FID_TUN_S_SET_ACTIVE_PRESETLISTStart& rhs) const {
    if (hasE8ListID() || rhs.hasE8ListID()) {
        if ((uint32)getE8ListID() < (uint32)rhs.getE8ListID()) return true;
        if ((uint32)getE8ListID() > (uint32)rhs.getE8ListID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUN_S_SET_ACTIVE_PRESETLISTStart::clone() {
    return new FID_TUN_S_SET_ACTIVE_PRESETLISTStart(*this);
}

inline bool FID_TUN_S_SET_ACTIVE_PRESETLISTStart::operator > (const FID_TUN_S_SET_ACTIVE_PRESETLISTStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUN_S_SET_ACTIVE_PRESETLISTStart::clear() {
    clearE8ListID();
}

inline void FID_TUN_S_SET_ACTIVE_PRESETLISTStart::clearE8ListID() {
    if (hasE8ListID()) {
         clear_has_e8ListID();
        _e8ListID = ::tuner_main_fi_types::T_e8_Tun_ListID__TUN_BANK_FM1;
     }
}

inline bool FID_TUN_S_SET_ACTIVE_PRESETLISTStart::hasE8ListID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::tuner_main_fi_types::T_e8_Tun_ListID FID_TUN_S_SET_ACTIVE_PRESETLISTStart::getE8ListID () const {
    return _e8ListID;
}

inline void FID_TUN_S_SET_ACTIVE_PRESETLISTStart::setE8ListID (::tuner_main_fi_types::T_e8_Tun_ListID e8ListID_) {
    #ifndef NDEBUG
    if (!(::tuner_main_fi_types::T_e8_Tun_ListID_IsValid(e8ListID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8ListID_, "T_e8_Tun_ListID", "e8ListID", "FID_TUN_S_SET_ACTIVE_PRESETLISTStart");
    }
    #endif
    set_has_e8ListID();
    this->_e8ListID = e8ListID_;
}

inline void FID_TUN_S_SET_ACTIVE_PRESETLISTStart::set_has_e8ListID () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUN_S_SET_ACTIVE_PRESETLISTStart::clear_has_e8ListID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FID_TUN_S_SET_ACTIVE_PRESETLISTResult::FID_TUN_S_SET_ACTIVE_PRESETLISTResult ()  :
    _TunerServer_StatusResponse ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUN_S_SET_ACTIVE_PRESETLISTResult::FID_TUN_S_SET_ACTIVE_PRESETLISTResult (const FID_TUN_S_SET_ACTIVE_PRESETLISTResult &rhs)  :
    ::asf::core::Payload(rhs),
    _TunerServer_StatusResponse ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUN_S_SET_ACTIVE_PRESETLISTResult::FID_TUN_S_SET_ACTIVE_PRESETLISTResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_)  :
    _TunerServer_StatusResponse (TunerServer_StatusResponse_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUN_S_SET_ACTIVE_PRESETLISTResult::~FID_TUN_S_SET_ACTIVE_PRESETLISTResult() {
}

inline FID_TUN_S_SET_ACTIVE_PRESETLISTResult& FID_TUN_S_SET_ACTIVE_PRESETLISTResult::operator = (const FID_TUN_S_SET_ACTIVE_PRESETLISTResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTunerServer_StatusResponse()) {
            setTunerServer_StatusResponse(rhs.getTunerServer_StatusResponse());
        } else {
            clearTunerServer_StatusResponse();
        }
    }
    return *this;
}

inline bool FID_TUN_S_SET_ACTIVE_PRESETLISTResult::operator == (const FID_TUN_S_SET_ACTIVE_PRESETLISTResult& rhs) const {
    return (((!hasTunerServer_StatusResponse() && !rhs.hasTunerServer_StatusResponse()) || getTunerServer_StatusResponse() == rhs.getTunerServer_StatusResponse()));
}

inline bool FID_TUN_S_SET_ACTIVE_PRESETLISTResult::operator != (const FID_TUN_S_SET_ACTIVE_PRESETLISTResult& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUN_S_SET_ACTIVE_PRESETLISTResult::operator < (const FID_TUN_S_SET_ACTIVE_PRESETLISTResult& rhs) const {
    if (hasTunerServer_StatusResponse() || rhs.hasTunerServer_StatusResponse()) {
        if (getTunerServer_StatusResponse() < rhs.getTunerServer_StatusResponse()) return true;
        if (getTunerServer_StatusResponse() > rhs.getTunerServer_StatusResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUN_S_SET_ACTIVE_PRESETLISTResult::clone() {
    return new FID_TUN_S_SET_ACTIVE_PRESETLISTResult(*this);
}

inline bool FID_TUN_S_SET_ACTIVE_PRESETLISTResult::operator > (const FID_TUN_S_SET_ACTIVE_PRESETLISTResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUN_S_SET_ACTIVE_PRESETLISTResult::clear() {
    clearTunerServer_StatusResponse();
}

inline void FID_TUN_S_SET_ACTIVE_PRESETLISTResult::clearTunerServer_StatusResponse() {
    if (hasTunerServer_StatusResponse()) {
         clear_has_TunerServer_StatusResponse();
        _TunerServer_StatusResponse.clear();
     }
}

inline bool FID_TUN_S_SET_ACTIVE_PRESETLISTResult::hasTunerServer_StatusResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& FID_TUN_S_SET_ACTIVE_PRESETLISTResult::getTunerServer_StatusResponse () const {
    return _TunerServer_StatusResponse;
}

inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& FID_TUN_S_SET_ACTIVE_PRESETLISTResult::getTunerServer_StatusResponseMutable () {
    set_has_TunerServer_StatusResponse();
    return _TunerServer_StatusResponse;
}

inline void FID_TUN_S_SET_ACTIVE_PRESETLISTResult::setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_) {
    set_has_TunerServer_StatusResponse();
    this->_TunerServer_StatusResponse = TunerServer_StatusResponse_;
}

inline void FID_TUN_S_SET_ACTIVE_PRESETLISTResult::set_has_TunerServer_StatusResponse () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUN_S_SET_ACTIVE_PRESETLISTResult::clear_has_TunerServer_StatusResponse () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FID_TUN_S_SET_FEATUREStart::FID_TUN_S_SET_FEATUREStart ()  :
    _TunerFeature ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUN_S_SET_FEATUREStart::FID_TUN_S_SET_FEATUREStart (const FID_TUN_S_SET_FEATUREStart &rhs)  :
    ::asf::core::Payload(rhs),
    _TunerFeature ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUN_S_SET_FEATUREStart::FID_TUN_S_SET_FEATUREStart (const ::tuner_main_fi_types::T_TunerFeature& TunerFeature_)  :
    _TunerFeature (TunerFeature_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUN_S_SET_FEATUREStart::~FID_TUN_S_SET_FEATUREStart() {
}

inline FID_TUN_S_SET_FEATUREStart& FID_TUN_S_SET_FEATUREStart::operator = (const FID_TUN_S_SET_FEATUREStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTunerFeature()) {
            setTunerFeature(rhs.getTunerFeature());
        } else {
            clearTunerFeature();
        }
    }
    return *this;
}

inline bool FID_TUN_S_SET_FEATUREStart::operator == (const FID_TUN_S_SET_FEATUREStart& rhs) const {
    return (((!hasTunerFeature() && !rhs.hasTunerFeature()) || getTunerFeature() == rhs.getTunerFeature()));
}

inline bool FID_TUN_S_SET_FEATUREStart::operator != (const FID_TUN_S_SET_FEATUREStart& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUN_S_SET_FEATUREStart::operator < (const FID_TUN_S_SET_FEATUREStart& rhs) const {
    if (hasTunerFeature() || rhs.hasTunerFeature()) {
        if (getTunerFeature() < rhs.getTunerFeature()) return true;
        if (getTunerFeature() > rhs.getTunerFeature()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUN_S_SET_FEATUREStart::clone() {
    return new FID_TUN_S_SET_FEATUREStart(*this);
}

inline bool FID_TUN_S_SET_FEATUREStart::operator > (const FID_TUN_S_SET_FEATUREStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUN_S_SET_FEATUREStart::clear() {
    clearTunerFeature();
}

inline void FID_TUN_S_SET_FEATUREStart::clearTunerFeature() {
    if (hasTunerFeature()) {
         clear_has_TunerFeature();
        _TunerFeature.clear();
     }
}

inline bool FID_TUN_S_SET_FEATUREStart::hasTunerFeature () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::tuner_main_fi_types::T_TunerFeature& FID_TUN_S_SET_FEATUREStart::getTunerFeature () const {
    return _TunerFeature;
}

inline ::tuner_main_fi_types::T_TunerFeature& FID_TUN_S_SET_FEATUREStart::getTunerFeatureMutable () {
    set_has_TunerFeature();
    return _TunerFeature;
}

inline void FID_TUN_S_SET_FEATUREStart::setTunerFeature (const ::tuner_main_fi_types::T_TunerFeature& TunerFeature_) {
    set_has_TunerFeature();
    this->_TunerFeature = TunerFeature_;
}

inline void FID_TUN_S_SET_FEATUREStart::set_has_TunerFeature () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUN_S_SET_FEATUREStart::clear_has_TunerFeature () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FID_TUN_S_SET_FEATUREResult::FID_TUN_S_SET_FEATUREResult ()  :
    _TunerServer_StatusResponse ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUN_S_SET_FEATUREResult::FID_TUN_S_SET_FEATUREResult (const FID_TUN_S_SET_FEATUREResult &rhs)  :
    ::asf::core::Payload(rhs),
    _TunerServer_StatusResponse ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUN_S_SET_FEATUREResult::FID_TUN_S_SET_FEATUREResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_)  :
    _TunerServer_StatusResponse (TunerServer_StatusResponse_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUN_S_SET_FEATUREResult::~FID_TUN_S_SET_FEATUREResult() {
}

inline FID_TUN_S_SET_FEATUREResult& FID_TUN_S_SET_FEATUREResult::operator = (const FID_TUN_S_SET_FEATUREResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTunerServer_StatusResponse()) {
            setTunerServer_StatusResponse(rhs.getTunerServer_StatusResponse());
        } else {
            clearTunerServer_StatusResponse();
        }
    }
    return *this;
}

inline bool FID_TUN_S_SET_FEATUREResult::operator == (const FID_TUN_S_SET_FEATUREResult& rhs) const {
    return (((!hasTunerServer_StatusResponse() && !rhs.hasTunerServer_StatusResponse()) || getTunerServer_StatusResponse() == rhs.getTunerServer_StatusResponse()));
}

inline bool FID_TUN_S_SET_FEATUREResult::operator != (const FID_TUN_S_SET_FEATUREResult& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUN_S_SET_FEATUREResult::operator < (const FID_TUN_S_SET_FEATUREResult& rhs) const {
    if (hasTunerServer_StatusResponse() || rhs.hasTunerServer_StatusResponse()) {
        if (getTunerServer_StatusResponse() < rhs.getTunerServer_StatusResponse()) return true;
        if (getTunerServer_StatusResponse() > rhs.getTunerServer_StatusResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUN_S_SET_FEATUREResult::clone() {
    return new FID_TUN_S_SET_FEATUREResult(*this);
}

inline bool FID_TUN_S_SET_FEATUREResult::operator > (const FID_TUN_S_SET_FEATUREResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUN_S_SET_FEATUREResult::clear() {
    clearTunerServer_StatusResponse();
}

inline void FID_TUN_S_SET_FEATUREResult::clearTunerServer_StatusResponse() {
    if (hasTunerServer_StatusResponse()) {
         clear_has_TunerServer_StatusResponse();
        _TunerServer_StatusResponse.clear();
     }
}

inline bool FID_TUN_S_SET_FEATUREResult::hasTunerServer_StatusResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& FID_TUN_S_SET_FEATUREResult::getTunerServer_StatusResponse () const {
    return _TunerServer_StatusResponse;
}

inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& FID_TUN_S_SET_FEATUREResult::getTunerServer_StatusResponseMutable () {
    set_has_TunerServer_StatusResponse();
    return _TunerServer_StatusResponse;
}

inline void FID_TUN_S_SET_FEATUREResult::setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_) {
    set_has_TunerServer_StatusResponse();
    this->_TunerServer_StatusResponse = TunerServer_StatusResponse_;
}

inline void FID_TUN_S_SET_FEATUREResult::set_has_TunerServer_StatusResponse () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUN_S_SET_FEATUREResult::clear_has_TunerServer_StatusResponse () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FID_TUN_S_SET_HICUTStart::FID_TUN_S_SET_HICUTStart ()  :
    _u8AbsVal (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUN_S_SET_HICUTStart::FID_TUN_S_SET_HICUTStart (const FID_TUN_S_SET_HICUTStart &rhs)  :
    ::asf::core::Payload(rhs),
    _u8AbsVal (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUN_S_SET_HICUTStart::FID_TUN_S_SET_HICUTStart (uint8 u8AbsVal_)  :
    _u8AbsVal (u8AbsVal_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUN_S_SET_HICUTStart::~FID_TUN_S_SET_HICUTStart() {
}

inline FID_TUN_S_SET_HICUTStart& FID_TUN_S_SET_HICUTStart::operator = (const FID_TUN_S_SET_HICUTStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasU8AbsVal()) {
            setU8AbsVal(rhs.getU8AbsVal());
        } else {
            clearU8AbsVal();
        }
    }
    return *this;
}

inline bool FID_TUN_S_SET_HICUTStart::operator == (const FID_TUN_S_SET_HICUTStart& rhs) const {
    return (((!hasU8AbsVal() && !rhs.hasU8AbsVal()) || getU8AbsVal() == rhs.getU8AbsVal()));
}

inline bool FID_TUN_S_SET_HICUTStart::operator != (const FID_TUN_S_SET_HICUTStart& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUN_S_SET_HICUTStart::operator < (const FID_TUN_S_SET_HICUTStart& rhs) const {
    if (hasU8AbsVal() || rhs.hasU8AbsVal()) {
        if (getU8AbsVal() < rhs.getU8AbsVal()) return true;
        if (getU8AbsVal() > rhs.getU8AbsVal()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUN_S_SET_HICUTStart::clone() {
    return new FID_TUN_S_SET_HICUTStart(*this);
}

inline bool FID_TUN_S_SET_HICUTStart::operator > (const FID_TUN_S_SET_HICUTStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUN_S_SET_HICUTStart::clear() {
    clearU8AbsVal();
}

inline void FID_TUN_S_SET_HICUTStart::clearU8AbsVal() {
    if (hasU8AbsVal()) {
         clear_has_u8AbsVal();
        _u8AbsVal = 0u;
     }
}

inline bool FID_TUN_S_SET_HICUTStart::hasU8AbsVal () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 FID_TUN_S_SET_HICUTStart::getU8AbsVal () const {
    return _u8AbsVal;
}

inline void FID_TUN_S_SET_HICUTStart::setU8AbsVal (uint8 u8AbsVal_) {
    set_has_u8AbsVal();
    this->_u8AbsVal = u8AbsVal_;
}

inline void FID_TUN_S_SET_HICUTStart::set_has_u8AbsVal () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUN_S_SET_HICUTStart::clear_has_u8AbsVal () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FID_TUN_S_SET_HICUTResult::FID_TUN_S_SET_HICUTResult ()  :
    _TunerServer_StatusResponse ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUN_S_SET_HICUTResult::FID_TUN_S_SET_HICUTResult (const FID_TUN_S_SET_HICUTResult &rhs)  :
    ::asf::core::Payload(rhs),
    _TunerServer_StatusResponse ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUN_S_SET_HICUTResult::FID_TUN_S_SET_HICUTResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_)  :
    _TunerServer_StatusResponse (TunerServer_StatusResponse_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUN_S_SET_HICUTResult::~FID_TUN_S_SET_HICUTResult() {
}

inline FID_TUN_S_SET_HICUTResult& FID_TUN_S_SET_HICUTResult::operator = (const FID_TUN_S_SET_HICUTResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTunerServer_StatusResponse()) {
            setTunerServer_StatusResponse(rhs.getTunerServer_StatusResponse());
        } else {
            clearTunerServer_StatusResponse();
        }
    }
    return *this;
}

inline bool FID_TUN_S_SET_HICUTResult::operator == (const FID_TUN_S_SET_HICUTResult& rhs) const {
    return (((!hasTunerServer_StatusResponse() && !rhs.hasTunerServer_StatusResponse()) || getTunerServer_StatusResponse() == rhs.getTunerServer_StatusResponse()));
}

inline bool FID_TUN_S_SET_HICUTResult::operator != (const FID_TUN_S_SET_HICUTResult& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUN_S_SET_HICUTResult::operator < (const FID_TUN_S_SET_HICUTResult& rhs) const {
    if (hasTunerServer_StatusResponse() || rhs.hasTunerServer_StatusResponse()) {
        if (getTunerServer_StatusResponse() < rhs.getTunerServer_StatusResponse()) return true;
        if (getTunerServer_StatusResponse() > rhs.getTunerServer_StatusResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUN_S_SET_HICUTResult::clone() {
    return new FID_TUN_S_SET_HICUTResult(*this);
}

inline bool FID_TUN_S_SET_HICUTResult::operator > (const FID_TUN_S_SET_HICUTResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUN_S_SET_HICUTResult::clear() {
    clearTunerServer_StatusResponse();
}

inline void FID_TUN_S_SET_HICUTResult::clearTunerServer_StatusResponse() {
    if (hasTunerServer_StatusResponse()) {
         clear_has_TunerServer_StatusResponse();
        _TunerServer_StatusResponse.clear();
     }
}

inline bool FID_TUN_S_SET_HICUTResult::hasTunerServer_StatusResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& FID_TUN_S_SET_HICUTResult::getTunerServer_StatusResponse () const {
    return _TunerServer_StatusResponse;
}

inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& FID_TUN_S_SET_HICUTResult::getTunerServer_StatusResponseMutable () {
    set_has_TunerServer_StatusResponse();
    return _TunerServer_StatusResponse;
}

inline void FID_TUN_S_SET_HICUTResult::setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_) {
    set_has_TunerServer_StatusResponse();
    this->_TunerServer_StatusResponse = TunerServer_StatusResponse_;
}

inline void FID_TUN_S_SET_HICUTResult::set_has_TunerServer_StatusResponse () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUN_S_SET_HICUTResult::clear_has_TunerServer_StatusResponse () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FID_TUN_S_AFLIST_V2Start::FID_TUN_S_AFLIST_V2Start ()  :
    _u8Notification (::tuner_main_fi_types::T_e8_Tun_Notification__TUN_NOTIFICATION_OFF)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUN_S_AFLIST_V2Start::FID_TUN_S_AFLIST_V2Start (const FID_TUN_S_AFLIST_V2Start &rhs)  :
    ::asf::core::Payload(rhs),
    _u8Notification (::tuner_main_fi_types::T_e8_Tun_Notification__TUN_NOTIFICATION_OFF)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUN_S_AFLIST_V2Start::FID_TUN_S_AFLIST_V2Start (::tuner_main_fi_types::T_e8_Tun_Notification u8Notification_)  :
    _u8Notification (u8Notification_)
{
    #ifndef NDEBUG
    if (!(::tuner_main_fi_types::T_e8_Tun_Notification_IsValid(u8Notification_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8Notification_, "T_e8_Tun_Notification", "u8Notification", "FID_TUN_S_AFLIST_V2Start");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUN_S_AFLIST_V2Start::~FID_TUN_S_AFLIST_V2Start() {
}

inline FID_TUN_S_AFLIST_V2Start& FID_TUN_S_AFLIST_V2Start::operator = (const FID_TUN_S_AFLIST_V2Start& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasU8Notification()) {
            setU8Notification(rhs.getU8Notification());
        } else {
            clearU8Notification();
        }
    }
    return *this;
}

inline bool FID_TUN_S_AFLIST_V2Start::operator == (const FID_TUN_S_AFLIST_V2Start& rhs) const {
    return (((!hasU8Notification() && !rhs.hasU8Notification()) || getU8Notification() == rhs.getU8Notification()));
}

inline bool FID_TUN_S_AFLIST_V2Start::operator != (const FID_TUN_S_AFLIST_V2Start& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUN_S_AFLIST_V2Start::operator < (const FID_TUN_S_AFLIST_V2Start& rhs) const {
    if (hasU8Notification() || rhs.hasU8Notification()) {
        if ((uint32)getU8Notification() < (uint32)rhs.getU8Notification()) return true;
        if ((uint32)getU8Notification() > (uint32)rhs.getU8Notification()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUN_S_AFLIST_V2Start::clone() {
    return new FID_TUN_S_AFLIST_V2Start(*this);
}

inline bool FID_TUN_S_AFLIST_V2Start::operator > (const FID_TUN_S_AFLIST_V2Start& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUN_S_AFLIST_V2Start::clear() {
    clearU8Notification();
}

inline void FID_TUN_S_AFLIST_V2Start::clearU8Notification() {
    if (hasU8Notification()) {
         clear_has_u8Notification();
        _u8Notification = ::tuner_main_fi_types::T_e8_Tun_Notification__TUN_NOTIFICATION_OFF;
     }
}

inline bool FID_TUN_S_AFLIST_V2Start::hasU8Notification () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::tuner_main_fi_types::T_e8_Tun_Notification FID_TUN_S_AFLIST_V2Start::getU8Notification () const {
    return _u8Notification;
}

inline void FID_TUN_S_AFLIST_V2Start::setU8Notification (::tuner_main_fi_types::T_e8_Tun_Notification u8Notification_) {
    #ifndef NDEBUG
    if (!(::tuner_main_fi_types::T_e8_Tun_Notification_IsValid(u8Notification_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8Notification_, "T_e8_Tun_Notification", "u8Notification", "FID_TUN_S_AFLIST_V2Start");
    }
    #endif
    set_has_u8Notification();
    this->_u8Notification = u8Notification_;
}

inline void FID_TUN_S_AFLIST_V2Start::set_has_u8Notification () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUN_S_AFLIST_V2Start::clear_has_u8Notification () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FID_TUN_S_AFLIST_V2Result::FID_TUN_S_AFLIST_V2Result ()  :
    _TunerServer_StatusResponse ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUN_S_AFLIST_V2Result::FID_TUN_S_AFLIST_V2Result (const FID_TUN_S_AFLIST_V2Result &rhs)  :
    ::asf::core::Payload(rhs),
    _TunerServer_StatusResponse ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUN_S_AFLIST_V2Result::FID_TUN_S_AFLIST_V2Result (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_)  :
    _TunerServer_StatusResponse (TunerServer_StatusResponse_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUN_S_AFLIST_V2Result::~FID_TUN_S_AFLIST_V2Result() {
}

inline FID_TUN_S_AFLIST_V2Result& FID_TUN_S_AFLIST_V2Result::operator = (const FID_TUN_S_AFLIST_V2Result& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTunerServer_StatusResponse()) {
            setTunerServer_StatusResponse(rhs.getTunerServer_StatusResponse());
        } else {
            clearTunerServer_StatusResponse();
        }
    }
    return *this;
}

inline bool FID_TUN_S_AFLIST_V2Result::operator == (const FID_TUN_S_AFLIST_V2Result& rhs) const {
    return (((!hasTunerServer_StatusResponse() && !rhs.hasTunerServer_StatusResponse()) || getTunerServer_StatusResponse() == rhs.getTunerServer_StatusResponse()));
}

inline bool FID_TUN_S_AFLIST_V2Result::operator != (const FID_TUN_S_AFLIST_V2Result& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUN_S_AFLIST_V2Result::operator < (const FID_TUN_S_AFLIST_V2Result& rhs) const {
    if (hasTunerServer_StatusResponse() || rhs.hasTunerServer_StatusResponse()) {
        if (getTunerServer_StatusResponse() < rhs.getTunerServer_StatusResponse()) return true;
        if (getTunerServer_StatusResponse() > rhs.getTunerServer_StatusResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUN_S_AFLIST_V2Result::clone() {
    return new FID_TUN_S_AFLIST_V2Result(*this);
}

inline bool FID_TUN_S_AFLIST_V2Result::operator > (const FID_TUN_S_AFLIST_V2Result& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUN_S_AFLIST_V2Result::clear() {
    clearTunerServer_StatusResponse();
}

inline void FID_TUN_S_AFLIST_V2Result::clearTunerServer_StatusResponse() {
    if (hasTunerServer_StatusResponse()) {
         clear_has_TunerServer_StatusResponse();
        _TunerServer_StatusResponse.clear();
     }
}

inline bool FID_TUN_S_AFLIST_V2Result::hasTunerServer_StatusResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& FID_TUN_S_AFLIST_V2Result::getTunerServer_StatusResponse () const {
    return _TunerServer_StatusResponse;
}

inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& FID_TUN_S_AFLIST_V2Result::getTunerServer_StatusResponseMutable () {
    set_has_TunerServer_StatusResponse();
    return _TunerServer_StatusResponse;
}

inline void FID_TUN_S_AFLIST_V2Result::setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_) {
    set_has_TunerServer_StatusResponse();
    this->_TunerServer_StatusResponse = TunerServer_StatusResponse_;
}

inline void FID_TUN_S_AFLIST_V2Result::set_has_TunerServer_StatusResponse () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUN_S_AFLIST_V2Result::clear_has_TunerServer_StatusResponse () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start::FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start ()  :
    _u8PhysicalTunerId (::tuner_main_fi_types::T_e8_Tun_PhysicalTuner__TUNER_0),
    _u8Mode (::tuner_main_fi_types::T_e8_Tun_TestTuneFrequencyMode__AF_JUMP_ON),
    _u32Frequency (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start::FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start (const FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start &rhs)  :
    ::asf::core::Payload(rhs),
    _u8PhysicalTunerId (::tuner_main_fi_types::T_e8_Tun_PhysicalTuner__TUNER_0),
    _u8Mode (::tuner_main_fi_types::T_e8_Tun_TestTuneFrequencyMode__AF_JUMP_ON),
    _u32Frequency (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start::FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start (::tuner_main_fi_types::T_e8_Tun_PhysicalTuner u8PhysicalTunerId_, ::tuner_main_fi_types::T_e8_Tun_TestTuneFrequencyMode u8Mode_, uint32 u32Frequency_)  :
    _u8PhysicalTunerId (u8PhysicalTunerId_),
    _u8Mode (u8Mode_),
    _u32Frequency (u32Frequency_)
{
    #ifndef NDEBUG
    if (!(::tuner_main_fi_types::T_e8_Tun_PhysicalTuner_IsValid(u8PhysicalTunerId_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8PhysicalTunerId_, "T_e8_Tun_PhysicalTuner", "u8PhysicalTunerId", "FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start");
    }
    #endif
    #ifndef NDEBUG
    if (!(::tuner_main_fi_types::T_e8_Tun_TestTuneFrequencyMode_IsValid(u8Mode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8Mode_, "T_e8_Tun_TestTuneFrequencyMode", "u8Mode", "FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start::~FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start() {
}

inline FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start& FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start::operator = (const FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasU8PhysicalTunerId()) {
            setU8PhysicalTunerId(rhs.getU8PhysicalTunerId());
        } else {
            clearU8PhysicalTunerId();
        }
        if (rhs.hasU8Mode()) {
            setU8Mode(rhs.getU8Mode());
        } else {
            clearU8Mode();
        }
        if (rhs.hasU32Frequency()) {
            setU32Frequency(rhs.getU32Frequency());
        } else {
            clearU32Frequency();
        }
    }
    return *this;
}

inline bool FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start::operator == (const FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start& rhs) const {
    return (((!hasU8PhysicalTunerId() && !rhs.hasU8PhysicalTunerId()) || getU8PhysicalTunerId() == rhs.getU8PhysicalTunerId()) &&
        ((!hasU8Mode() && !rhs.hasU8Mode()) || getU8Mode() == rhs.getU8Mode()) &&
        ((!hasU32Frequency() && !rhs.hasU32Frequency()) || getU32Frequency() == rhs.getU32Frequency()));
}

inline bool FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start::operator != (const FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start::operator < (const FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start& rhs) const {
    if (hasU8PhysicalTunerId() || rhs.hasU8PhysicalTunerId()) {
        if ((uint32)getU8PhysicalTunerId() < (uint32)rhs.getU8PhysicalTunerId()) return true;
        if ((uint32)getU8PhysicalTunerId() > (uint32)rhs.getU8PhysicalTunerId()) return false;
    }
    if (hasU8Mode() || rhs.hasU8Mode()) {
        if ((uint32)getU8Mode() < (uint32)rhs.getU8Mode()) return true;
        if ((uint32)getU8Mode() > (uint32)rhs.getU8Mode()) return false;
    }
    if (hasU32Frequency() || rhs.hasU32Frequency()) {
        if (getU32Frequency() < rhs.getU32Frequency()) return true;
        if (getU32Frequency() > rhs.getU32Frequency()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start::clone() {
    return new FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start(*this);
}

inline bool FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start::operator > (const FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start::clear() {
    clearU8PhysicalTunerId();
    clearU8Mode();
    clearU32Frequency();
}

inline void FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start::clearU8PhysicalTunerId() {
    if (hasU8PhysicalTunerId()) {
         clear_has_u8PhysicalTunerId();
        _u8PhysicalTunerId = ::tuner_main_fi_types::T_e8_Tun_PhysicalTuner__TUNER_0;
     }
}

inline bool FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start::hasU8PhysicalTunerId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::tuner_main_fi_types::T_e8_Tun_PhysicalTuner FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start::getU8PhysicalTunerId () const {
    return _u8PhysicalTunerId;
}

inline void FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start::setU8PhysicalTunerId (::tuner_main_fi_types::T_e8_Tun_PhysicalTuner u8PhysicalTunerId_) {
    #ifndef NDEBUG
    if (!(::tuner_main_fi_types::T_e8_Tun_PhysicalTuner_IsValid(u8PhysicalTunerId_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8PhysicalTunerId_, "T_e8_Tun_PhysicalTuner", "u8PhysicalTunerId", "FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start");
    }
    #endif
    set_has_u8PhysicalTunerId();
    this->_u8PhysicalTunerId = u8PhysicalTunerId_;
}

inline void FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start::clearU8Mode() {
    if (hasU8Mode()) {
         clear_has_u8Mode();
        _u8Mode = ::tuner_main_fi_types::T_e8_Tun_TestTuneFrequencyMode__AF_JUMP_ON;
     }
}

inline bool FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start::hasU8Mode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::tuner_main_fi_types::T_e8_Tun_TestTuneFrequencyMode FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start::getU8Mode () const {
    return _u8Mode;
}

inline void FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start::setU8Mode (::tuner_main_fi_types::T_e8_Tun_TestTuneFrequencyMode u8Mode_) {
    #ifndef NDEBUG
    if (!(::tuner_main_fi_types::T_e8_Tun_TestTuneFrequencyMode_IsValid(u8Mode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8Mode_, "T_e8_Tun_TestTuneFrequencyMode", "u8Mode", "FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start");
    }
    #endif
    set_has_u8Mode();
    this->_u8Mode = u8Mode_;
}

inline void FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start::clearU32Frequency() {
    if (hasU32Frequency()) {
         clear_has_u32Frequency();
        _u32Frequency = 0u;
     }
}

inline bool FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start::hasU32Frequency () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start::getU32Frequency () const {
    return _u32Frequency;
}

inline void FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start::setU32Frequency (uint32 u32Frequency_) {
    set_has_u32Frequency();
    this->_u32Frequency = u32Frequency_;
}

inline void FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start::set_has_u8PhysicalTunerId () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start::clear_has_u8PhysicalTunerId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start::set_has_u8Mode () {
    _has_bits_[0] |= 1u << 1;
}

inline void FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start::clear_has_u8Mode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start::set_has_u32Frequency () {
    _has_bits_[0] |= 1u << 2;
}

inline void FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Start::clear_has_u32Frequency () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Result::FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Result ()  :
    _TunerServer_StatusResponse ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Result::FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Result (const FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Result &rhs)  :
    ::asf::core::Payload(rhs),
    _TunerServer_StatusResponse ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Result::FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Result (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_)  :
    _TunerServer_StatusResponse (TunerServer_StatusResponse_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Result::~FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Result() {
}

inline FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Result& FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Result::operator = (const FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Result& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTunerServer_StatusResponse()) {
            setTunerServer_StatusResponse(rhs.getTunerServer_StatusResponse());
        } else {
            clearTunerServer_StatusResponse();
        }
    }
    return *this;
}

inline bool FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Result::operator == (const FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Result& rhs) const {
    return (((!hasTunerServer_StatusResponse() && !rhs.hasTunerServer_StatusResponse()) || getTunerServer_StatusResponse() == rhs.getTunerServer_StatusResponse()));
}

inline bool FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Result::operator != (const FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Result& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Result::operator < (const FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Result& rhs) const {
    if (hasTunerServer_StatusResponse() || rhs.hasTunerServer_StatusResponse()) {
        if (getTunerServer_StatusResponse() < rhs.getTunerServer_StatusResponse()) return true;
        if (getTunerServer_StatusResponse() > rhs.getTunerServer_StatusResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Result::clone() {
    return new FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Result(*this);
}

inline bool FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Result::operator > (const FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Result& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Result::clear() {
    clearTunerServer_StatusResponse();
}

inline void FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Result::clearTunerServer_StatusResponse() {
    if (hasTunerServer_StatusResponse()) {
         clear_has_TunerServer_StatusResponse();
        _TunerServer_StatusResponse.clear();
     }
}

inline bool FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Result::hasTunerServer_StatusResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Result::getTunerServer_StatusResponse () const {
    return _TunerServer_StatusResponse;
}

inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Result::getTunerServer_StatusResponseMutable () {
    set_has_TunerServer_StatusResponse();
    return _TunerServer_StatusResponse;
}

inline void FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Result::setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_) {
    set_has_TunerServer_StatusResponse();
    this->_TunerServer_StatusResponse = TunerServer_StatusResponse_;
}

inline void FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Result::set_has_TunerServer_StatusResponse () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2Result::clear_has_TunerServer_StatusResponse () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FID_TUN_S_DIRECT_FREQUENCYStart::FID_TUN_S_DIRECT_FREQUENCYStart ()  :
    _u32Frequency (0u),
    _u8Band (::tuner_main_fi_types::T_e8_Tun_TunerBand__TUN_BAND_FM)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUN_S_DIRECT_FREQUENCYStart::FID_TUN_S_DIRECT_FREQUENCYStart (const FID_TUN_S_DIRECT_FREQUENCYStart &rhs)  :
    ::asf::core::Payload(rhs),
    _u32Frequency (0u),
    _u8Band (::tuner_main_fi_types::T_e8_Tun_TunerBand__TUN_BAND_FM)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUN_S_DIRECT_FREQUENCYStart::FID_TUN_S_DIRECT_FREQUENCYStart (uint32 u32Frequency_, ::tuner_main_fi_types::T_e8_Tun_TunerBand u8Band_)  :
    _u32Frequency (u32Frequency_),
    _u8Band (u8Band_)
{
    #ifndef NDEBUG
    if (!(::tuner_main_fi_types::T_e8_Tun_TunerBand_IsValid(u8Band_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8Band_, "T_e8_Tun_TunerBand", "u8Band", "FID_TUN_S_DIRECT_FREQUENCYStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUN_S_DIRECT_FREQUENCYStart::~FID_TUN_S_DIRECT_FREQUENCYStart() {
}

inline FID_TUN_S_DIRECT_FREQUENCYStart& FID_TUN_S_DIRECT_FREQUENCYStart::operator = (const FID_TUN_S_DIRECT_FREQUENCYStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasU32Frequency()) {
            setU32Frequency(rhs.getU32Frequency());
        } else {
            clearU32Frequency();
        }
        if (rhs.hasU8Band()) {
            setU8Band(rhs.getU8Band());
        } else {
            clearU8Band();
        }
    }
    return *this;
}

inline bool FID_TUN_S_DIRECT_FREQUENCYStart::operator == (const FID_TUN_S_DIRECT_FREQUENCYStart& rhs) const {
    return (((!hasU32Frequency() && !rhs.hasU32Frequency()) || getU32Frequency() == rhs.getU32Frequency()) &&
        ((!hasU8Band() && !rhs.hasU8Band()) || getU8Band() == rhs.getU8Band()));
}

inline bool FID_TUN_S_DIRECT_FREQUENCYStart::operator != (const FID_TUN_S_DIRECT_FREQUENCYStart& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUN_S_DIRECT_FREQUENCYStart::operator < (const FID_TUN_S_DIRECT_FREQUENCYStart& rhs) const {
    if (hasU32Frequency() || rhs.hasU32Frequency()) {
        if (getU32Frequency() < rhs.getU32Frequency()) return true;
        if (getU32Frequency() > rhs.getU32Frequency()) return false;
    }
    if (hasU8Band() || rhs.hasU8Band()) {
        if ((uint32)getU8Band() < (uint32)rhs.getU8Band()) return true;
        if ((uint32)getU8Band() > (uint32)rhs.getU8Band()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUN_S_DIRECT_FREQUENCYStart::clone() {
    return new FID_TUN_S_DIRECT_FREQUENCYStart(*this);
}

inline bool FID_TUN_S_DIRECT_FREQUENCYStart::operator > (const FID_TUN_S_DIRECT_FREQUENCYStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUN_S_DIRECT_FREQUENCYStart::clear() {
    clearU32Frequency();
    clearU8Band();
}

inline void FID_TUN_S_DIRECT_FREQUENCYStart::clearU32Frequency() {
    if (hasU32Frequency()) {
         clear_has_u32Frequency();
        _u32Frequency = 0u;
     }
}

inline bool FID_TUN_S_DIRECT_FREQUENCYStart::hasU32Frequency () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 FID_TUN_S_DIRECT_FREQUENCYStart::getU32Frequency () const {
    return _u32Frequency;
}

inline void FID_TUN_S_DIRECT_FREQUENCYStart::setU32Frequency (uint32 u32Frequency_) {
    set_has_u32Frequency();
    this->_u32Frequency = u32Frequency_;
}

inline void FID_TUN_S_DIRECT_FREQUENCYStart::clearU8Band() {
    if (hasU8Band()) {
         clear_has_u8Band();
        _u8Band = ::tuner_main_fi_types::T_e8_Tun_TunerBand__TUN_BAND_FM;
     }
}

inline bool FID_TUN_S_DIRECT_FREQUENCYStart::hasU8Band () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::tuner_main_fi_types::T_e8_Tun_TunerBand FID_TUN_S_DIRECT_FREQUENCYStart::getU8Band () const {
    return _u8Band;
}

inline void FID_TUN_S_DIRECT_FREQUENCYStart::setU8Band (::tuner_main_fi_types::T_e8_Tun_TunerBand u8Band_) {
    #ifndef NDEBUG
    if (!(::tuner_main_fi_types::T_e8_Tun_TunerBand_IsValid(u8Band_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8Band_, "T_e8_Tun_TunerBand", "u8Band", "FID_TUN_S_DIRECT_FREQUENCYStart");
    }
    #endif
    set_has_u8Band();
    this->_u8Band = u8Band_;
}

inline void FID_TUN_S_DIRECT_FREQUENCYStart::set_has_u32Frequency () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUN_S_DIRECT_FREQUENCYStart::clear_has_u32Frequency () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void FID_TUN_S_DIRECT_FREQUENCYStart::set_has_u8Band () {
    _has_bits_[0] |= 1u << 1;
}

inline void FID_TUN_S_DIRECT_FREQUENCYStart::clear_has_u8Band () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  FID_TUN_S_DIRECT_FREQUENCYResult::FID_TUN_S_DIRECT_FREQUENCYResult ()  :
    _TunerServer_StatusResponse ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUN_S_DIRECT_FREQUENCYResult::FID_TUN_S_DIRECT_FREQUENCYResult (const FID_TUN_S_DIRECT_FREQUENCYResult &rhs)  :
    ::asf::core::Payload(rhs),
    _TunerServer_StatusResponse ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUN_S_DIRECT_FREQUENCYResult::FID_TUN_S_DIRECT_FREQUENCYResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_)  :
    _TunerServer_StatusResponse (TunerServer_StatusResponse_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUN_S_DIRECT_FREQUENCYResult::~FID_TUN_S_DIRECT_FREQUENCYResult() {
}

inline FID_TUN_S_DIRECT_FREQUENCYResult& FID_TUN_S_DIRECT_FREQUENCYResult::operator = (const FID_TUN_S_DIRECT_FREQUENCYResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTunerServer_StatusResponse()) {
            setTunerServer_StatusResponse(rhs.getTunerServer_StatusResponse());
        } else {
            clearTunerServer_StatusResponse();
        }
    }
    return *this;
}

inline bool FID_TUN_S_DIRECT_FREQUENCYResult::operator == (const FID_TUN_S_DIRECT_FREQUENCYResult& rhs) const {
    return (((!hasTunerServer_StatusResponse() && !rhs.hasTunerServer_StatusResponse()) || getTunerServer_StatusResponse() == rhs.getTunerServer_StatusResponse()));
}

inline bool FID_TUN_S_DIRECT_FREQUENCYResult::operator != (const FID_TUN_S_DIRECT_FREQUENCYResult& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUN_S_DIRECT_FREQUENCYResult::operator < (const FID_TUN_S_DIRECT_FREQUENCYResult& rhs) const {
    if (hasTunerServer_StatusResponse() || rhs.hasTunerServer_StatusResponse()) {
        if (getTunerServer_StatusResponse() < rhs.getTunerServer_StatusResponse()) return true;
        if (getTunerServer_StatusResponse() > rhs.getTunerServer_StatusResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUN_S_DIRECT_FREQUENCYResult::clone() {
    return new FID_TUN_S_DIRECT_FREQUENCYResult(*this);
}

inline bool FID_TUN_S_DIRECT_FREQUENCYResult::operator > (const FID_TUN_S_DIRECT_FREQUENCYResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUN_S_DIRECT_FREQUENCYResult::clear() {
    clearTunerServer_StatusResponse();
}

inline void FID_TUN_S_DIRECT_FREQUENCYResult::clearTunerServer_StatusResponse() {
    if (hasTunerServer_StatusResponse()) {
         clear_has_TunerServer_StatusResponse();
        _TunerServer_StatusResponse.clear();
     }
}

inline bool FID_TUN_S_DIRECT_FREQUENCYResult::hasTunerServer_StatusResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& FID_TUN_S_DIRECT_FREQUENCYResult::getTunerServer_StatusResponse () const {
    return _TunerServer_StatusResponse;
}

inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& FID_TUN_S_DIRECT_FREQUENCYResult::getTunerServer_StatusResponseMutable () {
    set_has_TunerServer_StatusResponse();
    return _TunerServer_StatusResponse;
}

inline void FID_TUN_S_DIRECT_FREQUENCYResult::setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_) {
    set_has_TunerServer_StatusResponse();
    this->_TunerServer_StatusResponse = TunerServer_StatusResponse_;
}

inline void FID_TUN_S_DIRECT_FREQUENCYResult::set_has_TunerServer_StatusResponse () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUN_S_DIRECT_FREQUENCYResult::clear_has_TunerServer_StatusResponse () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FID_TUN_S_AUTOSTOREStart::FID_TUN_S_AUTOSTOREStart ()  :
    _bStatus (false),
    _e8ListID (::tuner_main_fi_types::T_e8_Tun_ListID__TUN_BANK_FM1)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUN_S_AUTOSTOREStart::FID_TUN_S_AUTOSTOREStart (const FID_TUN_S_AUTOSTOREStart &rhs)  :
    ::asf::core::Payload(rhs),
    _bStatus (false),
    _e8ListID (::tuner_main_fi_types::T_e8_Tun_ListID__TUN_BANK_FM1)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUN_S_AUTOSTOREStart::FID_TUN_S_AUTOSTOREStart (bool bStatus_, ::tuner_main_fi_types::T_e8_Tun_ListID e8ListID_)  :
    _bStatus (bStatus_),
    _e8ListID (e8ListID_)
{
    #ifndef NDEBUG
    if (!(::tuner_main_fi_types::T_e8_Tun_ListID_IsValid(e8ListID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8ListID_, "T_e8_Tun_ListID", "e8ListID", "FID_TUN_S_AUTOSTOREStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUN_S_AUTOSTOREStart::~FID_TUN_S_AUTOSTOREStart() {
}

inline FID_TUN_S_AUTOSTOREStart& FID_TUN_S_AUTOSTOREStart::operator = (const FID_TUN_S_AUTOSTOREStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBStatus()) {
            setBStatus(rhs.getBStatus());
        } else {
            clearBStatus();
        }
        if (rhs.hasE8ListID()) {
            setE8ListID(rhs.getE8ListID());
        } else {
            clearE8ListID();
        }
    }
    return *this;
}

inline bool FID_TUN_S_AUTOSTOREStart::operator == (const FID_TUN_S_AUTOSTOREStart& rhs) const {
    return (((!hasBStatus() && !rhs.hasBStatus()) || getBStatus() == rhs.getBStatus()) &&
        ((!hasE8ListID() && !rhs.hasE8ListID()) || getE8ListID() == rhs.getE8ListID()));
}

inline bool FID_TUN_S_AUTOSTOREStart::operator != (const FID_TUN_S_AUTOSTOREStart& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUN_S_AUTOSTOREStart::operator < (const FID_TUN_S_AUTOSTOREStart& rhs) const {
    if (hasBStatus() || rhs.hasBStatus()) {
        if (getBStatus() < rhs.getBStatus()) return true;
        if (getBStatus() > rhs.getBStatus()) return false;
    }
    if (hasE8ListID() || rhs.hasE8ListID()) {
        if ((uint32)getE8ListID() < (uint32)rhs.getE8ListID()) return true;
        if ((uint32)getE8ListID() > (uint32)rhs.getE8ListID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUN_S_AUTOSTOREStart::clone() {
    return new FID_TUN_S_AUTOSTOREStart(*this);
}

inline bool FID_TUN_S_AUTOSTOREStart::operator > (const FID_TUN_S_AUTOSTOREStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUN_S_AUTOSTOREStart::clear() {
    clearBStatus();
    clearE8ListID();
}

inline void FID_TUN_S_AUTOSTOREStart::clearBStatus() {
    if (hasBStatus()) {
         clear_has_bStatus();
        _bStatus = false;
     }
}

inline bool FID_TUN_S_AUTOSTOREStart::hasBStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool FID_TUN_S_AUTOSTOREStart::getBStatus () const {
    return _bStatus;
}

inline void FID_TUN_S_AUTOSTOREStart::setBStatus (bool bStatus_) {
    set_has_bStatus();
    this->_bStatus = bStatus_;
}

inline void FID_TUN_S_AUTOSTOREStart::clearE8ListID() {
    if (hasE8ListID()) {
         clear_has_e8ListID();
        _e8ListID = ::tuner_main_fi_types::T_e8_Tun_ListID__TUN_BANK_FM1;
     }
}

inline bool FID_TUN_S_AUTOSTOREStart::hasE8ListID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::tuner_main_fi_types::T_e8_Tun_ListID FID_TUN_S_AUTOSTOREStart::getE8ListID () const {
    return _e8ListID;
}

inline void FID_TUN_S_AUTOSTOREStart::setE8ListID (::tuner_main_fi_types::T_e8_Tun_ListID e8ListID_) {
    #ifndef NDEBUG
    if (!(::tuner_main_fi_types::T_e8_Tun_ListID_IsValid(e8ListID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8ListID_, "T_e8_Tun_ListID", "e8ListID", "FID_TUN_S_AUTOSTOREStart");
    }
    #endif
    set_has_e8ListID();
    this->_e8ListID = e8ListID_;
}

inline void FID_TUN_S_AUTOSTOREStart::set_has_bStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUN_S_AUTOSTOREStart::clear_has_bStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void FID_TUN_S_AUTOSTOREStart::set_has_e8ListID () {
    _has_bits_[0] |= 1u << 1;
}

inline void FID_TUN_S_AUTOSTOREStart::clear_has_e8ListID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  FID_TUN_S_AUTOSTOREResult::FID_TUN_S_AUTOSTOREResult ()  :
    _TunerServer_StatusResponse ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUN_S_AUTOSTOREResult::FID_TUN_S_AUTOSTOREResult (const FID_TUN_S_AUTOSTOREResult &rhs)  :
    ::asf::core::Payload(rhs),
    _TunerServer_StatusResponse ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUN_S_AUTOSTOREResult::FID_TUN_S_AUTOSTOREResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_)  :
    _TunerServer_StatusResponse (TunerServer_StatusResponse_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUN_S_AUTOSTOREResult::~FID_TUN_S_AUTOSTOREResult() {
}

inline FID_TUN_S_AUTOSTOREResult& FID_TUN_S_AUTOSTOREResult::operator = (const FID_TUN_S_AUTOSTOREResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTunerServer_StatusResponse()) {
            setTunerServer_StatusResponse(rhs.getTunerServer_StatusResponse());
        } else {
            clearTunerServer_StatusResponse();
        }
    }
    return *this;
}

inline bool FID_TUN_S_AUTOSTOREResult::operator == (const FID_TUN_S_AUTOSTOREResult& rhs) const {
    return (((!hasTunerServer_StatusResponse() && !rhs.hasTunerServer_StatusResponse()) || getTunerServer_StatusResponse() == rhs.getTunerServer_StatusResponse()));
}

inline bool FID_TUN_S_AUTOSTOREResult::operator != (const FID_TUN_S_AUTOSTOREResult& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUN_S_AUTOSTOREResult::operator < (const FID_TUN_S_AUTOSTOREResult& rhs) const {
    if (hasTunerServer_StatusResponse() || rhs.hasTunerServer_StatusResponse()) {
        if (getTunerServer_StatusResponse() < rhs.getTunerServer_StatusResponse()) return true;
        if (getTunerServer_StatusResponse() > rhs.getTunerServer_StatusResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUN_S_AUTOSTOREResult::clone() {
    return new FID_TUN_S_AUTOSTOREResult(*this);
}

inline bool FID_TUN_S_AUTOSTOREResult::operator > (const FID_TUN_S_AUTOSTOREResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUN_S_AUTOSTOREResult::clear() {
    clearTunerServer_StatusResponse();
}

inline void FID_TUN_S_AUTOSTOREResult::clearTunerServer_StatusResponse() {
    if (hasTunerServer_StatusResponse()) {
         clear_has_TunerServer_StatusResponse();
        _TunerServer_StatusResponse.clear();
     }
}

inline bool FID_TUN_S_AUTOSTOREResult::hasTunerServer_StatusResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::tuner_main_fi_types::T_TunerServer_StatusResponse& FID_TUN_S_AUTOSTOREResult::getTunerServer_StatusResponse () const {
    return _TunerServer_StatusResponse;
}

inline ::tuner_main_fi_types::T_TunerServer_StatusResponse& FID_TUN_S_AUTOSTOREResult::getTunerServer_StatusResponseMutable () {
    set_has_TunerServer_StatusResponse();
    return _TunerServer_StatusResponse;
}

inline void FID_TUN_S_AUTOSTOREResult::setTunerServer_StatusResponse (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_) {
    set_has_TunerServer_StatusResponse();
    this->_TunerServer_StatusResponse = TunerServer_StatusResponse_;
}

inline void FID_TUN_S_AUTOSTOREResult::set_has_TunerServer_StatusResponse () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUN_S_AUTOSTOREResult::clear_has_TunerServer_StatusResponse () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FID_TUN_S_SEL_LIST_ELEMStart::FID_TUN_S_SEL_LIST_ELEMStart ()  :
    _Sel_List_Elem ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUN_S_SEL_LIST_ELEMStart::FID_TUN_S_SEL_LIST_ELEMStart (const FID_TUN_S_SEL_LIST_ELEMStart &rhs)  :
    ::asf::core::Payload(rhs),
    _Sel_List_Elem ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUN_S_SEL_LIST_ELEMStart::FID_TUN_S_SEL_LIST_ELEMStart (const ::tuner_main_fi_types::T_Sel_List_Elem& Sel_List_Elem_)  :
    _Sel_List_Elem (Sel_List_Elem_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUN_S_SEL_LIST_ELEMStart::~FID_TUN_S_SEL_LIST_ELEMStart() {
}

inline FID_TUN_S_SEL_LIST_ELEMStart& FID_TUN_S_SEL_LIST_ELEMStart::operator = (const FID_TUN_S_SEL_LIST_ELEMStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSel_List_Elem()) {
            setSel_List_Elem(rhs.getSel_List_Elem());
        } else {
            clearSel_List_Elem();
        }
    }
    return *this;
}

inline bool FID_TUN_S_SEL_LIST_ELEMStart::operator == (const FID_TUN_S_SEL_LIST_ELEMStart& rhs) const {
    return (((!hasSel_List_Elem() && !rhs.hasSel_List_Elem()) || getSel_List_Elem() == rhs.getSel_List_Elem()));
}

inline bool FID_TUN_S_SEL_LIST_ELEMStart::operator != (const FID_TUN_S_SEL_LIST_ELEMStart& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUN_S_SEL_LIST_ELEMStart::operator < (const FID_TUN_S_SEL_LIST_ELEMStart& rhs) const {
    if (hasSel_List_Elem() || rhs.hasSel_List_Elem()) {
        if (getSel_List_Elem() < rhs.getSel_List_Elem()) return true;
        if (getSel_List_Elem() > rhs.getSel_List_Elem()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUN_S_SEL_LIST_ELEMStart::clone() {
    return new FID_TUN_S_SEL_LIST_ELEMStart(*this);
}

inline bool FID_TUN_S_SEL_LIST_ELEMStart::operator > (const FID_TUN_S_SEL_LIST_ELEMStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUN_S_SEL_LIST_ELEMStart::clear() {
    clearSel_List_Elem();
}

inline void FID_TUN_S_SEL_LIST_ELEMStart::clearSel_List_Elem() {
    if (hasSel_List_Elem()) {
         clear_has_Sel_List_Elem();
        _Sel_List_Elem.clear();
     }
}

inline bool FID_TUN_S_SEL_LIST_ELEMStart::hasSel_List_Elem () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::tuner_main_fi_types::T_Sel_List_Elem& FID_TUN_S_SEL_LIST_ELEMStart::getSel_List_Elem () const {
    return _Sel_List_Elem;
}

inline ::tuner_main_fi_types::T_Sel_List_Elem& FID_TUN_S_SEL_LIST_ELEMStart::getSel_List_ElemMutable () {
    set_has_Sel_List_Elem();
    return _Sel_List_Elem;
}

inline void FID_TUN_S_SEL_LIST_ELEMStart::setSel_List_Elem (const ::tuner_main_fi_types::T_Sel_List_Elem& Sel_List_Elem_) {
    set_has_Sel_List_Elem();
    this->_Sel_List_Elem = Sel_List_Elem_;
}

inline void FID_TUN_S_SEL_LIST_ELEMStart::set_has_Sel_List_Elem () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUN_S_SEL_LIST_ELEMStart::clear_has_Sel_List_Elem () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FID_TUN_S_SEL_LIST_ELEMResult::FID_TUN_S_SEL_LIST_ELEMResult ()  :
    _TunerServer_StatusResponse ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUN_S_SEL_LIST_ELEMResult::FID_TUN_S_SEL_LIST_ELEMResult (const FID_TUN_S_SEL_LIST_ELEMResult &rhs)  :
    ::asf::core::Payload(rhs),
    _TunerServer_StatusResponse ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUN_S_SEL_LIST_ELEMResult::FID_TUN_S_SEL_LIST_ELEMResult (const ::tuner_main_fi_types::T_TunerServer_StatusResponse& TunerServer_StatusResponse_)  :
    _TunerServer_StatusResponse (TunerServer_StatusResponse_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUN_S_SEL_LIST_ELEMResult::~FID_TUN_S_SEL_LIST_ELEMResult() {
}

inline FID_TUN_S_SEL_LIST_ELEMResult& FID_TUN_S_SEL_LIST_ELEMResult::operator = (const FID_TUN_S_SEL_LIST_ELEMResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTunerServer_StatusResponse()) {
            setTunerServer_StatusResponse(rhs.getTunerServer_StatusResponse());
        } else {
            clearTunerServer_StatusResponse();
        }
    }
    return *this;
}

inline bool FID_TUN_S_SEL_LIST_ELEMResult::operator == (const FID_TUN_S_SEL_LIST_ELEMResult& rhs) const {
    return (((!hasTunerServer_StatusResponse() && !rhs.hasTunerServer_StatusResponse()) || getTunerServer_StatusResponse() == rhs.getTunerServer_StatusResponse()));
}

inline bool FID_TUN_S_SEL_LIST_ELEMResult::operator != (const FID_TUN_S_SEL_LIST_ELEMResult& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUN_S_SEL_LIST_ELEMResult::operator < (const FID_TUN_S_SEL_LIST_ELEMResult& rhs) const {
    if (hasTunerServer_StatusResponse() || rhs.hasTunerServer_StatusResponse()) {
        if (getTunerServer_StatusResponse() < rhs.getTunerServer_StatusResponse()) return true;
        if (getTunerServer_StatusResponse() > rhs.getTunerServer_StatusResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUN_S_SEL_LIST_ELEMResult::clone() {
    return new FID_TUN_S_SEL_LIST_ELEMResult(*this);
}

inline bool FID_TUN_S_SEL_LIST_ELEMResult::operator > (const FID_TUN_S_SEL_LIST_ELEMResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUN_S_SEL_LIST_ELEMResult::clear() {
    clearTunerServer_StatusResponse();
}

inline voi