/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_CM_INCTIMESYNC_INCTIMESYNCPROXY_H
#define ORG_BOSCH_CM_INCTIMESYNC_INCTIMESYNCPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "org/bosch/cm/incTimeSync/IncTimeSync.h"
#include <dbus/dbus.h>

namespace org {
namespace bosch {
namespace cm {
namespace incTimeSync {
namespace IncTimeSync {

class IncTimeSyncProxy;

class ConfigDataCallbackIF {
public:
    virtual ~ConfigDataCallbackIF() {}

    virtual void onConfigDataError(const ::boost::shared_ptr< IncTimeSyncProxy >& proxy, const ::boost::shared_ptr< ConfigDataError >& error) = 0;

    virtual void onConfigDataUpdate(const ::boost::shared_ptr< IncTimeSyncProxy >& proxy, const ::boost::shared_ptr< ConfigDataUpdate >& update) = 0;
};

class IncSendStartDelaySecCallbackIF {
public:
    virtual ~IncSendStartDelaySecCallbackIF() {}

    virtual void onIncSendStartDelaySecError(const ::boost::shared_ptr< IncTimeSyncProxy >& proxy, const ::boost::shared_ptr< IncSendStartDelaySecError >& error) = 0;

    virtual void onIncSendStartDelaySecUpdate(const ::boost::shared_ptr< IncTimeSyncProxy >& proxy, const ::boost::shared_ptr< IncSendStartDelaySecUpdate >& update) = 0;
};

class TimesyncDataCallbackIF {
public:
    virtual ~TimesyncDataCallbackIF() {}

    virtual void onTimesyncDataError(const ::boost::shared_ptr< IncTimeSyncProxy >& proxy, const ::boost::shared_ptr< TimesyncDataError >& error) = 0;

    virtual void onTimesyncDataUpdate(const ::boost::shared_ptr< IncTimeSyncProxy >& proxy, const ::boost::shared_ptr< TimesyncDataUpdate >& update) = 0;
};


/**
 * IncTimeSyncProxy is the client side representation of the D-Bus service
 * interface 'org.bosch.cm.incTimeSync.IncTimeSync' (specified in file
 * TimeStampSync_.xml).
 *
 * If the meaning of "org.bosch.cm.incTimeSync.IncTimeSync" isn't clear, then there should be a description here.
 */
class IncTimeSyncProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of IncTimeSyncProxy.
     */
    static ::boost::shared_ptr< IncTimeSyncProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of IncTimeSyncProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< IncTimeSyncProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of IncTimeSyncProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< IncTimeSyncProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< IncTimeSyncProxy > proxyNew(new IncTimeSyncProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(true);
        return proxyNew;
    }

    virtual ~IncTimeSyncProxy ();



    // Property 'timesyncData'

    /**
     * Notify on the property 'timesyncData'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'timesyncData'</b>:
     *
     * If the meaning of "timesyncData" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTimesyncDataRegister(TimesyncDataCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'timesyncData'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'timesyncData'</b>:
     *
     * If the meaning of "timesyncData" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendTimesyncDataRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendTimesyncDataDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'timesyncData'.
     */
    void sendTimesyncDataDeregisterAll() const;

    /**
     * Request the value of the property 'timesyncData' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'timesyncData'</b>:
     *
     * If the meaning of "timesyncData" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTimesyncDataGet(TimesyncDataCallbackIF& cb);

    /**
     * Set the value of the property 'timesyncData'. This method sends a Set
     * message to the D-Bus server.
     *
     * @deprecated use the sendTimesyncDataSet(TimesyncDataCallbackIF& cb,
     * const IncTimeStampSyncStruct& timesyncData) method instead.
     *
     * <b>Documentation of 'timesyncData'</b>:
     *
     * If the meaning of "timesyncData" isn't clear, then there should be a description here.
     */
    void sendTimesyncDataSet(const IncTimeStampSyncStruct& timesyncData);

    /**
     * Set the value of the property 'timesyncData'. This method sends a Set
     * message to the D-Bus server.
     *
     * <b>Documentation of 'timesyncData'</b>:
     *
     * If the meaning of "timesyncData" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTimesyncDataSet(TimesyncDataCallbackIF& cb, const IncTimeStampSyncStruct& timesyncData);

    /**
     * Returns the current value of the property 'timesyncData' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasTimesyncData() returns true.
     *
     * @return the previously received value of the property 'timesyncData'.
     */
    const IncTimeStampSyncStruct& getTimesyncData() const;

    /**
     * Determines whether a status message for the property 'timesyncData' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasTimesyncData() const;

    // Property 'incSendStartDelaySec'

    /**
     * Notify on the property 'incSendStartDelaySec'. This method registers
     * for property changes by D-Bus service.
     *
     * <b>Documentation of 'incSendStartDelaySec'</b>:
     *
     * If the meaning of "incSendStartDelaySec" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendIncSendStartDelaySecRegister(IncSendStartDelaySecCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'incSendStartDelaySec'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'incSendStartDelaySec'</b>:
     *
     * If the meaning of "incSendStartDelaySec" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendIncSendStartDelaySecRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendIncSendStartDelaySecDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'incSendStartDelaySec'.
     */
    void sendIncSendStartDelaySecDeregisterAll() const;

    /**
     * Request the value of the property 'incSendStartDelaySec' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'incSendStartDelaySec'</b>:
     *
     * If the meaning of "incSendStartDelaySec" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendIncSendStartDelaySecGet(IncSendStartDelaySecCallbackIF& cb);

    /**
     * Set the value of the property 'incSendStartDelaySec'. This method sends
     * a Set message to the D-Bus server.
     *
     * @deprecated use the
     * sendIncSendStartDelaySecSet(IncSendStartDelaySecCallbackIF& cb, int32
     * incSendStartDelaySec) method instead.
     *
     * <b>Documentation of 'incSendStartDelaySec'</b>:
     *
     * If the meaning of "incSendStartDelaySec" isn't clear, then there should be a description here.
     */
    void sendIncSendStartDelaySecSet(int32 incSendStartDelaySec);

    /**
     * Set the value of the property 'incSendStartDelaySec'. This method sends
     * a Set message to the D-Bus server.
     *
     * <b>Documentation of 'incSendStartDelaySec'</b>:
     *
     * If the meaning of "incSendStartDelaySec" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendIncSendStartDelaySecSet(IncSendStartDelaySecCallbackIF& cb, int32 incSendStartDelaySec);

    /**
     * Returns the current value of the property 'incSendStartDelaySec' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasIncSendStartDelaySec() returns true.
     *
     * @return the previously received value of the property 'incSendStartDelaySec'.
     */
    int32 getIncSendStartDelaySec() const;

    /**
     * Determines whether a status message for the property
     * 'incSendStartDelaySec' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasIncSendStartDelaySec() const;

    // Property 'configData'

    /**
     * Notify on the property 'configData'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'configData'</b>:
     *
     * If the meaning of "configData" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConfigDataRegister(ConfigDataCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'configData'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'configData'</b>:
     *
     * If the meaning of "configData" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendConfigDataRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendConfigDataDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'configData'.
     */
    void sendConfigDataDeregisterAll() const;

    /**
     * Request the value of the property 'configData' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'configData'</b>:
     *
     * If the meaning of "configData" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConfigDataGet(ConfigDataCallbackIF& cb);

    /**
     * Set the value of the property 'configData'. This method sends a Set
     * message to the D-Bus server.
     *
     * @deprecated use the sendConfigDataSet(ConfigDataCallbackIF& cb, const
     * IncTimeStampSyncConfig& configData) method instead.
     *
     * <b>Documentation of 'configData'</b>:
     *
     * If the meaning of "configData" isn't clear, then there should be a description here.
     */
    void sendConfigDataSet(const IncTimeStampSyncConfig& configData);

    /**
     * Set the value of the property 'configData'. This method sends a Set
     * message to the D-Bus server.
     *
     * <b>Documentation of 'configData'</b>:
     *
     * If the meaning of "configData" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConfigDataSet(ConfigDataCallbackIF& cb, const IncTimeStampSyncConfig& configData);

    /**
     * Returns the current value of the property 'configData' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when
     * hasConfigData() returns true.
     *
     * @return the previously received value of the property 'configData'.
     */
    const IncTimeStampSyncConfig& getConfigData() const;

    /**
     * Determines whether a status message for the property 'configData' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasConfigData() const;


    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    IncTimeSyncProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;

    virtual void clearAllProperties ();

    // Property 'timesyncData'

    ::asf::core::nullable< TimesyncDataUpdate > _timesyncData;

    // Property 'incSendStartDelaySec'

    ::asf::core::nullable< IncSendStartDelaySecUpdate > _incSendStartDelaySec;

    // Property 'configData'

    ::asf::core::nullable< ConfigDataUpdate > _configData;

    DECLARE_CLASS_LOGGER();

    friend class IncTimeSyncProxyCallback;
};

} // namespace IncTimeSync
} // namespace incTimeSync
} // namespace cm
} // namespace bosch
} // namespace org

#endif // ORG_BOSCH_CM_INCTIMESYNC_INCTIMESYNCPROXY_H
