/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/cm/incTimeSync/IncTimeSync.h"
#include "org/bosch/cm/incTimeSync/IncTimeSyncDBus.h"
#include "org/bosch/cm/incTimeSync/IncTimeSyncJson.h"
#include "org/bosch/cm/incTimeSync/IncTimeSyncProxy.h"

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bosch {
namespace cm {
namespace incTimeSync {
namespace IncTimeSync {

DEFINE_CLASS_LOGGER("/org/bosch/cm/incTimeSync/org/bosch/cm/incTimeSync/IncTimeSync", IncTimeSyncProxy);

class IncTimeSyncProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    IncTimeSyncProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< IncTimeSyncProxy >& proxyShared = ::boost::static_pointer_cast< IncTimeSyncProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_timesyncData:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TimesyncDataError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "TimesyncData", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TimesyncDataError> payload = ::boost::static_pointer_cast<TimesyncDataError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((TimesyncDataCallbackIF*) _callback)->onTimesyncDataError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TimesyncDataUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "TimesyncData", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TimesyncDataUpdate> payload = ::boost::static_pointer_cast<TimesyncDataUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((TimesyncDataCallbackIF*) _callback)->onTimesyncDataUpdate(proxyShared, payload);
                        proxyShared->_timesyncData = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_incSendStartDelaySec:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), IncSendStartDelaySecError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "IncSendStartDelaySec", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<IncSendStartDelaySecError> payload = ::boost::static_pointer_cast<IncSendStartDelaySecError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((IncSendStartDelaySecCallbackIF*) _callback)->onIncSendStartDelaySecError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), IncSendStartDelaySecUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "IncSendStartDelaySec", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<IncSendStartDelaySecUpdate> payload = ::boost::static_pointer_cast<IncSendStartDelaySecUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((IncSendStartDelaySecCallbackIF*) _callback)->onIncSendStartDelaySecUpdate(proxyShared, payload);
                        proxyShared->_incSendStartDelaySec = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_configData:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ConfigDataError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ConfigData", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ConfigDataError> payload = ::boost::static_pointer_cast<ConfigDataError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ConfigDataCallbackIF*) _callback)->onConfigDataError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ConfigDataUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ConfigData", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ConfigDataUpdate> payload = ::boost::static_pointer_cast<ConfigDataUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ConfigDataCallbackIF*) _callback)->onConfigDataUpdate(proxyShared, payload);
                        proxyShared->_configData = *payload.get();
                        return true;
                    }
                }
                break;
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_timesyncData: {
                ::boost::shared_ptr< TimesyncDataError > payload = ::boost::shared_ptr< TimesyncDataError >
                (new TimesyncDataError(DBUS_ERROR_NO_SERVER, "The DBus service IncTimeSync is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "TimesyncData", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<IncTimeSyncProxy> proxyShared = ::boost::static_pointer_cast<IncTimeSyncProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((TimesyncDataCallbackIF*) _callback)->onTimesyncDataError (proxyShared,payload);
                return true;
            }
            break;
            case ID_incSendStartDelaySec: {
                ::boost::shared_ptr< IncSendStartDelaySecError > payload = ::boost::shared_ptr< IncSendStartDelaySecError >
                (new IncSendStartDelaySecError(DBUS_ERROR_NO_SERVER, "The DBus service IncTimeSync is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "IncSendStartDelaySec", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<IncTimeSyncProxy> proxyShared = ::boost::static_pointer_cast<IncTimeSyncProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((IncSendStartDelaySecCallbackIF*) _callback)->onIncSendStartDelaySecError (proxyShared,payload);
                return true;
            }
            break;
            case ID_configData: {
                ::boost::shared_ptr< ConfigDataError > payload = ::boost::shared_ptr< ConfigDataError >
                (new ConfigDataError(DBUS_ERROR_NO_SERVER, "The DBus service IncTimeSync is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ConfigData", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<IncTimeSyncProxy> proxyShared = ::boost::static_pointer_cast<IncTimeSyncProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ConfigDataCallbackIF*) _callback)->onConfigDataError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& IncTimeSyncProxyCallback::_logger (IncTimeSyncProxy::_logger);

IncTimeSyncProxy::IncTimeSyncProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.bosch.cm.incTimeSync.IncTimeSync", serviceAvailable, _logger) {
}

IncTimeSyncProxy::~IncTimeSyncProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< IncTimeSyncProxy > IncTimeSyncProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<IncTimeSyncProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< IncTimeSyncProxy > proxyNew(new IncTimeSyncProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t IncTimeSyncProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    IncTimeSyncProxyCallback* callback = new IncTimeSyncProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t IncTimeSyncProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    IncTimeSyncProxyCallback* callback = new IncTimeSyncProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void IncTimeSyncProxy::clearAllProperties ()
{
    _timesyncData = ::asf::core::nullable< TimesyncDataUpdate >();
    _incSendStartDelaySec = ::asf::core::nullable< IncSendStartDelaySecUpdate >();
    _configData = ::asf::core::nullable< ConfigDataUpdate >();
}

void IncTimeSyncProxy::sendDeregisterAll () const
{
    sendTimesyncDataDeregisterAll();
    sendIncSendStartDelaySecDeregisterAll();
    sendConfigDataDeregisterAll();
}

act_t IncTimeSyncProxy::sendTimesyncDataRegister(TimesyncDataCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_timesyncData, "timesyncData", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "TimesyncData", &cb, act);
    return act;
}

bool IncTimeSyncProxy::sendTimesyncDataDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("timesyncData", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "TimesyncData", act, static_cast<int>(rv));
    return rv;
}

act_t IncTimeSyncProxy::sendTimesyncDataGet(TimesyncDataCallbackIF& cb) {
    IncTimeSyncProxyCallback* callback = new IncTimeSyncProxyCallback(ID_timesyncData, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "TimesyncData", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("timesyncData", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void IncTimeSyncProxy::sendTimesyncDataSet(const IncTimeStampSyncStruct& timesyncData) {
    TimesyncDataSet parameter(timesyncData);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "TimesyncData");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "timesyncData", propertyContent);
}

act_t IncTimeSyncProxy::sendTimesyncDataSet(TimesyncDataCallbackIF& cb, const IncTimeStampSyncStruct& timesyncData) {
    IncTimeSyncProxyCallback* callback = new IncTimeSyncProxyCallback(ID_timesyncData, &cb);
    TimesyncDataSet parameter(timesyncData);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "TimesyncData", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "timesyncData", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

const IncTimeStampSyncStruct& IncTimeSyncProxy::getTimesyncData() const {
    return _timesyncData.get().getTimesyncData();
}

bool IncTimeSyncProxy::hasTimesyncData() const {
    return _timesyncData.hasValue();
}

void IncTimeSyncProxy::sendTimesyncDataDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "TimesyncData");
    _dbusProxyDelegate->deregisterSignalCallback("timesyncData", 0, _dbusDaemonProxy.get(), true);
}

act_t IncTimeSyncProxy::sendIncSendStartDelaySecRegister(IncSendStartDelaySecCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_incSendStartDelaySec, "incSendStartDelaySec", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "IncSendStartDelaySec", &cb, act);
    return act;
}

bool IncTimeSyncProxy::sendIncSendStartDelaySecDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("incSendStartDelaySec", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "IncSendStartDelaySec", act, static_cast<int>(rv));
    return rv;
}

act_t IncTimeSyncProxy::sendIncSendStartDelaySecGet(IncSendStartDelaySecCallbackIF& cb) {
    IncTimeSyncProxyCallback* callback = new IncTimeSyncProxyCallback(ID_incSendStartDelaySec, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "IncSendStartDelaySec", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("incSendStartDelaySec", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void IncTimeSyncProxy::sendIncSendStartDelaySecSet(int32 incSendStartDelaySec) {
    IncSendStartDelaySecSet parameter(incSendStartDelaySec);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "IncSendStartDelaySec");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "incSendStartDelaySec", propertyContent);
}

act_t IncTimeSyncProxy::sendIncSendStartDelaySecSet(IncSendStartDelaySecCallbackIF& cb, int32 incSendStartDelaySec) {
    IncTimeSyncProxyCallback* callback = new IncTimeSyncProxyCallback(ID_incSendStartDelaySec, &cb);
    IncSendStartDelaySecSet parameter(incSendStartDelaySec);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "IncSendStartDelaySec", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "incSendStartDelaySec", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

int32 IncTimeSyncProxy::getIncSendStartDelaySec() const {
    return _incSendStartDelaySec.get().getIncSendStartDelaySec();
}

bool IncTimeSyncProxy::hasIncSendStartDelaySec() const {
    return _incSendStartDelaySec.hasValue();
}

void IncTimeSyncProxy::sendIncSendStartDelaySecDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "IncSendStartDelaySec");
    _dbusProxyDelegate->deregisterSignalCallback("incSendStartDelaySec", 0, _dbusDaemonProxy.get(), true);
}

act_t IncTimeSyncProxy::sendConfigDataRegister(ConfigDataCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_configData, "configData", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ConfigData", &cb, act);
    return act;
}

bool IncTimeSyncProxy::sendConfigDataDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("configData", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ConfigData", act, static_cast<int>(rv));
    return rv;
}

act_t IncTimeSyncProxy::sendConfigDataGet(ConfigDataCallbackIF& cb) {
    IncTimeSyncProxyCallback* callback = new IncTimeSyncProxyCallback(ID_configData, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ConfigData", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("configData", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void IncTimeSyncProxy::sendConfigDataSet(const IncTimeStampSyncConfig& configData) {
    ConfigDataSet parameter(configData);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "ConfigData");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "configData", propertyContent);
}

act_t IncTimeSyncProxy::sendConfigDataSet(ConfigDataCallbackIF& cb, const IncTimeStampSyncConfig& configData) {
    IncTimeSyncProxyCallback* callback = new IncTimeSyncProxyCallback(ID_configData, &cb);
    ConfigDataSet parameter(configData);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "ConfigData", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "configData", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

const IncTimeStampSyncConfig& IncTimeSyncProxy::getConfigData() const {
    return _configData.get().getConfigData();
}

bool IncTimeSyncProxy::hasConfigData() const {
    return _configData.hasValue();
}

void IncTimeSyncProxy::sendConfigDataDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ConfigData");
    _dbusProxyDelegate->deregisterSignalCallback("configData", 0, _dbusDaemonProxy.get(), true);
}

} // namespace IncTimeSync
} // namespace incTimeSync
} // namespace cm
} // namespace bosch
} // namespace org
