#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef TIMESTAMPSYNC_MAIN_FI_H
#define TIMESTAMPSYNC_MAIN_FI_H

#include "asf/cca/CcaTypes.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/VersionCheck.h"
#include <cstring>

/**
 * CCA Functional Interface 'timestampsync_main_fi'
 *
 * Fullname: timestampsync_fi_for_echo
 *
 * Version: $Revision: 1.0$
 *
 * Author: CM-AI/ECO3 Rossner
 *
 * Date: $Date: 02.06.2015$
 *
 * Department:
 *
 * Title: timestampsync_fi
 *
 * <b>Description of 'timestampsync_main_fi':</b>
 *
 * Timestampsync Service
 */

namespace timestampsync_main_fi {

static const int SERVICE_ID = 116;

static const int FID_U8Echo = 1;


ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 1;

static const int VERSION_MINOR = 0;

static const int VERSION_PATCH = 0;

// forward declarations
class U8EchoStatus;

// type definitions
/**
 * The get message of the property "U8Echo"
 * just some property
 */
typedef ::asf::cca::CcaTypes::DefaultMessage U8EchoGet;

/**
 * The upreg message of the property "U8Echo"
 * just some property
 */
typedef ::asf::cca::CcaTypes::DefaultMessage U8EchoUpReg;

/**
 * The relUpReg message of the property "U8Echo"
 * just some property
 */
typedef ::asf::cca::CcaTypes::DefaultMessage U8EchoRelUpReg;

/**
 * The error message of 'U8Echo'
 */
typedef ::asf::cca::CcaTypes::DefaultError U8EchoError;


/**
 * The status message of the property "U8Echo"
 * just some property
 */
class U8EchoStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  U8EchoStatus ();

    /**
     * Copy constructor
     */
    inline  U8EchoStatus (const U8EchoStatus &rhs);

    /**
     * All fields constructor
     */
    inline  U8EchoStatus (uint8 u8Data_);

    /**
     * Destructor
     */
    inline virtual  ~U8EchoStatus();

    /**
     * Assignment operator
     */
    inline U8EchoStatus& operator = (const U8EchoStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const U8EchoStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const U8EchoStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const U8EchoStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const U8EchoStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8Data"

    static const int kU8Data = 0;

    /**
     * Clears the field "u8Data".
     *
     * The field will be set to its default value. The hasU8Data()
     * method will return false.
     */
    inline void clearU8Data();

    /**
     * Checks whether the field "u8Data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Data()). Otherwise it will return false.
     */
    inline bool hasU8Data () const;

    /**
     * Returns the value of the member "u8Data".
     *
     * <p>u8Data</p>
     *
     * @return The value of the field "u8Data"
     */
    inline uint8 getU8Data () const;

    /**
     * Sets the value of the member "u8Data".
     *
     * <p>u8Data</p>
     *
     * @param u8Data The value which will be set
     */
    inline void setU8Data (uint8 u8Data_);

    static const U8EchoStatus &getDefaultInstance();

private:

    inline void set_has_u8Data ();

    inline void clear_has_u8Data ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8Data;

};

inline  U8EchoStatus::U8EchoStatus ()  :
    _u8Data (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  U8EchoStatus::U8EchoStatus (const U8EchoStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _u8Data (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  U8EchoStatus::U8EchoStatus (uint8 u8Data_)  :
    _u8Data (u8Data_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  U8EchoStatus::~U8EchoStatus() {
}

inline U8EchoStatus& U8EchoStatus::operator = (const U8EchoStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasU8Data()) {
            setU8Data(rhs.getU8Data());
        } else {
            clearU8Data();
        }
    }
    return *this;
}

inline bool U8EchoStatus::operator == (const U8EchoStatus& rhs) const {
    return (((!hasU8Data() && !rhs.hasU8Data()) || getU8Data() == rhs.getU8Data()));
}

inline bool U8EchoStatus::operator != (const U8EchoStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool U8EchoStatus::operator < (const U8EchoStatus& rhs) const {
    if (hasU8Data() || rhs.hasU8Data()) {
        if (getU8Data() < rhs.getU8Data()) return true;
        if (getU8Data() > rhs.getU8Data()) return false;
    }
    return false;
}

inline ::asf::core::Payload* U8EchoStatus::clone() {
    return new U8EchoStatus(*this);
}

inline bool U8EchoStatus::operator > (const U8EchoStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void U8EchoStatus::clear() {
    clearU8Data();
}

inline void U8EchoStatus::clearU8Data() {
    if (hasU8Data()) {
         clear_has_u8Data();
        _u8Data = 0u;
     }
}

inline bool U8EchoStatus::hasU8Data () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 U8EchoStatus::getU8Data () const {
    return _u8Data;
}

inline void U8EchoStatus::setU8Data (uint8 u8Data_) {
    set_has_u8Data();
    this->_u8Data = u8Data_;
}

inline void U8EchoStatus::set_has_u8Data () {
    _has_bits_[0] |= 1u << 0;
}

inline void U8EchoStatus::clear_has_u8Data () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace timestampsync_main_fi

#endif // TIMESTAMPSYNC_MAIN_FI_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
