#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef TCU_USB_MAIN_FI_TYPES_H
#define TCU_USB_MAIN_FI_TYPES_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "tcu_usb_main_fi_typesConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * Types tcu_usb_main_fi_types
 */

namespace tcu_usb_main_fi_types {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class T_usb_tcu_Charging_Stations_Request_Info;

class T_usb_tcu_Vacancy_Stations_Request_Info;

class T_usb_tcu_Favorite_channel_info;

class T_tcu_Block_Data_List;

class T_tcu_Japan_Location;

class T_tcu_navigation_setting_information;

class T_tcu_VICS_Request_Data;

class T_json_file_path;

class T_usb_tcu_Channel_definition_information;

class T_usb_tcu_Channel_Info;

class T_usb_tcu_channel_master_data_header;

class T_usb_tcu_Folder_definition_information;

class T_usb_tcu_channel_master_data;

class T_usb_tcu_Location;

class T_usb_tcu_Data_Record;

class T_usb_tcu_connected_search_result;

class T_usb_tcu_Data_Header_Part;

class T_usb_tcu_GroupA_Authorization_Info;

class T_usb_tcu_GroupA_BasicServices_Info;

class T_usb_tcu_GroupA_Info;

class T_tcu_charging_spot_data;

class T_tcu_response_charging_spot_data_result;

class T_tcu_charging_stations_info;

class T_tcu_charging_stations_data;

class T_tcu_response_charging_stations_list_result;

class T_tcu_vacancy_stations_info;

class T_tcu_response_vacancy_stations_list_result;

class T_tcu_vacancy_spot_data;

class T_tcu_response_vacancy_spot_data_result;

class T_usb_tcu_Server_Info;

class T_usb_tcu_TCUDevice_Info;

class T_usb_tcu_UserAuthentication_DecodedToken_Info;

// type definitions
/**
 * If the meaning of "T_usb_tcu_POIID_List" isn't clear, then there should be a description here.
 */
typedef ::std::vector< uint32 > T_usb_tcu_POIID_List;

/**
 * If the meaning of "T_usb_tcu_Favorite_Feed_List" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_usb_tcu_Favorite_channel_info > T_usb_tcu_Favorite_Feed_List;

/**
 * If the meaning of "T_e8_tcu_VICS_Response_Data" isn't clear, then there should be a description here.
 */
typedef ::std::vector< uint8 > T_e8_tcu_VICS_Response_Data;

/**
 * If the meaning of "T_usb_tcu_Channel_Info_List" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_usb_tcu_Channel_Info > T_usb_tcu_Channel_Info_List;

/**
 * If the meaning of "T_tcu_vacancy_stations_data" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_tcu_vacancy_stations_info > T_tcu_vacancy_stations_data;

/**
 * If the meaning of "T_usb_tcu_Server_Info_List" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_usb_tcu_Server_Info > T_usb_tcu_Server_Info_List;


/**
 * If the meaning of "T_usb_tcu_Charging_Stations_Request_Info" isn't clear, then there should be a description here.
 */
class T_usb_tcu_Charging_Stations_Request_Info {
public:

    /**
     * Default constructor
     */
    inline  T_usb_tcu_Charging_Stations_Request_Info ();

    /**
     * Copy constructor
     */
    inline  T_usb_tcu_Charging_Stations_Request_Info (const T_usb_tcu_Charging_Stations_Request_Info &rhs);

    /**
     * All fields constructor
     */
    inline  T_usb_tcu_Charging_Stations_Request_Info (uint16 u16MaxNumberOfPOI_, uint16 u16SearchRange_, uint16 u16XCoordinate_, uint16 u16YCoordinate_, uint32 u32MeshID_);

    /**
     * Destructor
     */
    inline  ~T_usb_tcu_Charging_Stations_Request_Info();

    /**
     * Assignment operator
     */
    inline T_usb_tcu_Charging_Stations_Request_Info& operator = (const T_usb_tcu_Charging_Stations_Request_Info& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_usb_tcu_Charging_Stations_Request_Info& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_usb_tcu_Charging_Stations_Request_Info& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_usb_tcu_Charging_Stations_Request_Info& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_usb_tcu_Charging_Stations_Request_Info& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16MaxNumberOfPOI"

    static const int kU16MaxNumberOfPOI = 0;

    /**
     * Clears the field "u16MaxNumberOfPOI".
     *
     * The field will be set to its default value. The hasU16MaxNumberOfPOI()
     * method will return false.
     */
    inline void clearU16MaxNumberOfPOI();

    /**
     * Checks whether the field "u16MaxNumberOfPOI" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16MaxNumberOfPOI()). Otherwise it will return false.
     */
    inline bool hasU16MaxNumberOfPOI () const;

    /**
     * Returns the value of the member "u16MaxNumberOfPOI".
     *
     * Max number of POI
     *
     * @return The value of the field "u16MaxNumberOfPOI"
     */
    inline uint16 getU16MaxNumberOfPOI () const;

    /**
     * Sets the value of the member "u16MaxNumberOfPOI".
     *
     * Max number of POI
     *
     * @param u16MaxNumberOfPOI The value which will be set
     */
    inline void setU16MaxNumberOfPOI (uint16 u16MaxNumberOfPOI_);

    // API of field "u16SearchRange"

    static const int kU16SearchRange = 1;

    /**
     * Clears the field "u16SearchRange".
     *
     * The field will be set to its default value. The hasU16SearchRange()
     * method will return false.
     */
    inline void clearU16SearchRange();

    /**
     * Checks whether the field "u16SearchRange" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16SearchRange()). Otherwise it will return false.
     */
    inline bool hasU16SearchRange () const;

    /**
     * Returns the value of the member "u16SearchRange".
     *
     * Search Range
     *
     * @return The value of the field "u16SearchRange"
     */
    inline uint16 getU16SearchRange () const;

    /**
     * Sets the value of the member "u16SearchRange".
     *
     * Search Range
     *
     * @param u16SearchRange The value which will be set
     */
    inline void setU16SearchRange (uint16 u16SearchRange_);

    // API of field "u16XCoordinate"

    static const int kU16XCoordinate = 2;

    /**
     * Clears the field "u16XCoordinate".
     *
     * The field will be set to its default value. The hasU16XCoordinate()
     * method will return false.
     */
    inline void clearU16XCoordinate();

    /**
     * Checks whether the field "u16XCoordinate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16XCoordinate()). Otherwise it will return false.
     */
    inline bool hasU16XCoordinate () const;

    /**
     * Returns the value of the member "u16XCoordinate".
     *
     * X Coordinate
     *
     * @return The value of the field "u16XCoordinate"
     */
    inline uint16 getU16XCoordinate () const;

    /**
     * Sets the value of the member "u16XCoordinate".
     *
     * X Coordinate
     *
     * @param u16XCoordinate The value which will be set
     */
    inline void setU16XCoordinate (uint16 u16XCoordinate_);

    // API of field "u16YCoordinate"

    static const int kU16YCoordinate = 3;

    /**
     * Clears the field "u16YCoordinate".
     *
     * The field will be set to its default value. The hasU16YCoordinate()
     * method will return false.
     */
    inline void clearU16YCoordinate();

    /**
     * Checks whether the field "u16YCoordinate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16YCoordinate()). Otherwise it will return false.
     */
    inline bool hasU16YCoordinate () const;

    /**
     * Returns the value of the member "u16YCoordinate".
     *
     * Y Coordinate
     *
     * @return The value of the field "u16YCoordinate"
     */
    inline uint16 getU16YCoordinate () const;

    /**
     * Sets the value of the member "u16YCoordinate".
     *
     * Y Coordinate
     *
     * @param u16YCoordinate The value which will be set
     */
    inline void setU16YCoordinate (uint16 u16YCoordinate_);

    // API of field "u32MeshID"

    static const int kU32MeshID = 4;

    /**
     * Clears the field "u32MeshID".
     *
     * The field will be set to its default value. The hasU32MeshID()
     * method will return false.
     */
    inline void clearU32MeshID();

    /**
     * Checks whether the field "u32MeshID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32MeshID()). Otherwise it will return false.
     */
    inline bool hasU32MeshID () const;

    /**
     * Returns the value of the member "u32MeshID".
     *
     * Mesh ID
     *
     * @return The value of the field "u32MeshID"
     */
    inline uint32 getU32MeshID () const;

    /**
     * Sets the value of the member "u32MeshID".
     *
     * Mesh ID
     *
     * @param u32MeshID The value which will be set
     */
    inline void setU32MeshID (uint32 u32MeshID_);

    static const T_usb_tcu_Charging_Stations_Request_Info &getDefaultInstance();

private:

    inline void set_has_u16MaxNumberOfPOI ();

    inline void clear_has_u16MaxNumberOfPOI ();

    inline void set_has_u16SearchRange ();

    inline void clear_has_u16SearchRange ();

    inline void set_has_u16XCoordinate ();

    inline void clear_has_u16XCoordinate ();

    inline void set_has_u16YCoordinate ();

    inline void clear_has_u16YCoordinate ();

    inline void set_has_u32MeshID ();

    inline void clear_has_u32MeshID ();

    uint32 _has_bits_[ (5 + 31) / 32];

    uint16 _u16MaxNumberOfPOI;

    uint16 _u16SearchRange;

    uint16 _u16XCoordinate;

    uint16 _u16YCoordinate;

    uint32 _u32MeshID;

};

/**
 * If the meaning of "T_usb_tcu_Vacancy_Stations_Request_Info" isn't clear, then there should be a description here.
 */
class T_usb_tcu_Vacancy_Stations_Request_Info {
public:

    /**
     * Default constructor
     */
    inline  T_usb_tcu_Vacancy_Stations_Request_Info ();

    /**
     * Copy constructor
     */
    inline  T_usb_tcu_Vacancy_Stations_Request_Info (const T_usb_tcu_Vacancy_Stations_Request_Info &rhs);

    /**
     * All fields constructor
     */
    inline  T_usb_tcu_Vacancy_Stations_Request_Info (uint16 u16CruisingDistance_, uint16 u16Lat_second_, uint16 u16Long_second_, uint16 u16RemainingBatteryCapacity_, uint8 u8CoordinateSystem_, uint8 u8Lat_Degree_, uint8 u8Lat_minute_, uint8 u8Long_Degree_, uint8 u8Long_minute_);

    /**
     * Destructor
     */
    inline  ~T_usb_tcu_Vacancy_Stations_Request_Info();

    /**
     * Assignment operator
     */
    inline T_usb_tcu_Vacancy_Stations_Request_Info& operator = (const T_usb_tcu_Vacancy_Stations_Request_Info& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_usb_tcu_Vacancy_Stations_Request_Info& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_usb_tcu_Vacancy_Stations_Request_Info& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_usb_tcu_Vacancy_Stations_Request_Info& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_usb_tcu_Vacancy_Stations_Request_Info& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16CruisingDistance"

    static const int kU16CruisingDistance = 0;

    /**
     * Clears the field "u16CruisingDistance".
     *
     * The field will be set to its default value. The hasU16CruisingDistance()
     * method will return false.
     */
    inline void clearU16CruisingDistance();

    /**
     * Checks whether the field "u16CruisingDistance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16CruisingDistance()). Otherwise it will return false.
     */
    inline bool hasU16CruisingDistance () const;

    /**
     * Returns the value of the member "u16CruisingDistance".
     *
     * Cruising Distance
     *
     * @return The value of the field "u16CruisingDistance"
     */
    inline uint16 getU16CruisingDistance () const;

    /**
     * Sets the value of the member "u16CruisingDistance".
     *
     * Cruising Distance
     *
     * @param u16CruisingDistance The value which will be set
     */
    inline void setU16CruisingDistance (uint16 u16CruisingDistance_);

    // API of field "u16Lat_second"

    static const int kU16Lat_second = 1;

    /**
     * Clears the field "u16Lat_second".
     *
     * The field will be set to its default value. The hasU16Lat_second()
     * method will return false.
     */
    inline void clearU16Lat_second();

    /**
     * Checks whether the field "u16Lat_second" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16Lat_second()). Otherwise it will return false.
     */
    inline bool hasU16Lat_second () const;

    /**
     * Returns the value of the member "u16Lat_second".
     *
     * Latitude second
     *
     * @return The value of the field "u16Lat_second"
     */
    inline uint16 getU16Lat_second () const;

    /**
     * Sets the value of the member "u16Lat_second".
     *
     * Latitude second
     *
     * @param u16Lat_second The value which will be set
     */
    inline void setU16Lat_second (uint16 u16Lat_second_);

    // API of field "u16Long_second"

    static const int kU16Long_second = 2;

    /**
     * Clears the field "u16Long_second".
     *
     * The field will be set to its default value. The hasU16Long_second()
     * method will return false.
     */
    inline void clearU16Long_second();

    /**
     * Checks whether the field "u16Long_second" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16Long_second()). Otherwise it will return false.
     */
    inline bool hasU16Long_second () const;

    /**
     * Returns the value of the member "u16Long_second".
     *
     * Longitude second
     *
     * @return The value of the field "u16Long_second"
     */
    inline uint16 getU16Long_second () const;

    /**
     * Sets the value of the member "u16Long_second".
     *
     * Longitude second
     *
     * @param u16Long_second The value which will be set
     */
    inline void setU16Long_second (uint16 u16Long_second_);

    // API of field "u16RemainingBatteryCapacity"

    static const int kU16RemainingBatteryCapacity = 3;

    /**
     * Clears the field "u16RemainingBatteryCapacity".
     *
     * The field will be set to its default value. The hasU16RemainingBatteryCapacity()
     * method will return false.
     */
    inline void clearU16RemainingBatteryCapacity();

    /**
     * Checks whether the field "u16RemainingBatteryCapacity" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16RemainingBatteryCapacity()). Otherwise it will return false.
     */
    inline bool hasU16RemainingBatteryCapacity () const;

    /**
     * Returns the value of the member "u16RemainingBatteryCapacity".
     *
     * Remaining Battery Capacity
     *
     * @return The value of the field "u16RemainingBatteryCapacity"
     */
    inline uint16 getU16RemainingBatteryCapacity () const;

    /**
     * Sets the value of the member "u16RemainingBatteryCapacity".
     *
     * Remaining Battery Capacity
     *
     * @param u16RemainingBatteryCapacity The value which will be set
     */
    inline void setU16RemainingBatteryCapacity (uint16 u16RemainingBatteryCapacity_);

    // API of field "u8CoordinateSystem"

    static const int kU8CoordinateSystem = 4;

    /**
     * Clears the field "u8CoordinateSystem".
     *
     * The field will be set to its default value. The hasU8CoordinateSystem()
     * method will return false.
     */
    inline void clearU8CoordinateSystem();

    /**
     * Checks whether the field "u8CoordinateSystem" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8CoordinateSystem()). Otherwise it will return false.
     */
    inline bool hasU8CoordinateSystem () const;

    /**
     * Returns the value of the member "u8CoordinateSystem".
     *
     * Coordinate System
     *
     * @return The value of the field "u8CoordinateSystem"
     */
    inline uint8 getU8CoordinateSystem () const;

    /**
     * Sets the value of the member "u8CoordinateSystem".
     *
     * Coordinate System
     *
     * @param u8CoordinateSystem The value which will be set
     */
    inline void setU8CoordinateSystem (uint8 u8CoordinateSystem_);

    // API of field "u8Lat_Degree"

    static const int kU8Lat_Degree = 5;

    /**
     * Clears the field "u8Lat_Degree".
     *
     * The field will be set to its default value. The hasU8Lat_Degree()
     * method will return false.
     */
    inline void clearU8Lat_Degree();

    /**
     * Checks whether the field "u8Lat_Degree" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Lat_Degree()). Otherwise it will return false.
     */
    inline bool hasU8Lat_Degree () const;

    /**
     * Returns the value of the member "u8Lat_Degree".
     *
     * Latitude Degree
     *
     * @return The value of the field "u8Lat_Degree"
     */
    inline uint8 getU8Lat_Degree () const;

    /**
     * Sets the value of the member "u8Lat_Degree".
     *
     * Latitude Degree
     *
     * @param u8Lat_Degree The value which will be set
     */
    inline void setU8Lat_Degree (uint8 u8Lat_Degree_);

    // API of field "u8Lat_minute"

    static const int kU8Lat_minute = 6;

    /**
     * Clears the field "u8Lat_minute".
     *
     * The field will be set to its default value. The hasU8Lat_minute()
     * method will return false.
     */
    inline void clearU8Lat_minute();

    /**
     * Checks whether the field "u8Lat_minute" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Lat_minute()). Otherwise it will return false.
     */
    inline bool hasU8Lat_minute () const;

    /**
     * Returns the value of the member "u8Lat_minute".
     *
     * Latitude minute
     *
     * @return The value of the field "u8Lat_minute"
     */
    inline uint8 getU8Lat_minute () const;

    /**
     * Sets the value of the member "u8Lat_minute".
     *
     * Latitude minute
     *
     * @param u8Lat_minute The value which will be set
     */
    inline void setU8Lat_minute (uint8 u8Lat_minute_);

    // API of field "u8Long_Degree"

    static const int kU8Long_Degree = 7;

    /**
     * Clears the field "u8Long_Degree".
     *
     * The field will be set to its default value. The hasU8Long_Degree()
     * method will return false.
     */
    inline void clearU8Long_Degree();

    /**
     * Checks whether the field "u8Long_Degree" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Long_Degree()). Otherwise it will return false.
     */
    inline bool hasU8Long_Degree () const;

    /**
     * Returns the value of the member "u8Long_Degree".
     *
     * Longitude Degree
     *
     * @return The value of the field "u8Long_Degree"
     */
    inline uint8 getU8Long_Degree () const;

    /**
     * Sets the value of the member "u8Long_Degree".
     *
     * Longitude Degree
     *
     * @param u8Long_Degree The value which will be set
     */
    inline void setU8Long_Degree (uint8 u8Long_Degree_);

    // API of field "u8Long_minute"

    static const int kU8Long_minute = 8;

    /**
     * Clears the field "u8Long_minute".
     *
     * The field will be set to its default value. The hasU8Long_minute()
     * method will return false.
     */
    inline void clearU8Long_minute();

    /**
     * Checks whether the field "u8Long_minute" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Long_minute()). Otherwise it will return false.
     */
    inline bool hasU8Long_minute () const;

    /**
     * Returns the value of the member "u8Long_minute".
     *
     * Longitude minute
     *
     * @return The value of the field "u8Long_minute"
     */
    inline uint8 getU8Long_minute () const;

    /**
     * Sets the value of the member "u8Long_minute".
     *
     * Longitude minute
     *
     * @param u8Long_minute The value which will be set
     */
    inline void setU8Long_minute (uint8 u8Long_minute_);

    static const T_usb_tcu_Vacancy_Stations_Request_Info &getDefaultInstance();

private:

    inline void set_has_u16CruisingDistance ();

    inline void clear_has_u16CruisingDistance ();

    inline void set_has_u16Lat_second ();

    inline void clear_has_u16Lat_second ();

    inline void set_has_u16Long_second ();

    inline void clear_has_u16Long_second ();

    inline void set_has_u16RemainingBatteryCapacity ();

    inline void clear_has_u16RemainingBatteryCapacity ();

    inline void set_has_u8CoordinateSystem ();

    inline void clear_has_u8CoordinateSystem ();

    inline void set_has_u8Lat_Degree ();

    inline void clear_has_u8Lat_Degree ();

    inline void set_has_u8Lat_minute ();

    inline void clear_has_u8Lat_minute ();

    inline void set_has_u8Long_Degree ();

    inline void clear_has_u8Long_Degree ();

    inline void set_has_u8Long_minute ();

    inline void clear_has_u8Long_minute ();

    uint32 _has_bits_[ (9 + 31) / 32];

    uint16 _u16CruisingDistance;

    uint16 _u16Lat_second;

    uint16 _u16Long_second;

    uint16 _u16RemainingBatteryCapacity;

    uint8 _u8CoordinateSystem;

    uint8 _u8Lat_Degree;

    uint8 _u8Lat_minute;

    uint8 _u8Long_Degree;

    uint8 _u8Long_minute;

};

/**
 * If the meaning of "T_usb_tcu_Favorite_channel_info" isn't clear, then there should be a description here.
 */
class T_usb_tcu_Favorite_channel_info {
public:

    /**
     * Default constructor
     */
    inline  T_usb_tcu_Favorite_channel_info ();

    /**
     * Copy constructor
     */
    inline  T_usb_tcu_Favorite_channel_info (const T_usb_tcu_Favorite_channel_info &rhs);

    /**
     * All fields constructor
     */
    inline  T_usb_tcu_Favorite_channel_info (const ::std::string& strChannelName_, const ::std::string& strChannelNameForTTS_, uint16 u16ChannelID_, uint8 u8FavoriteChannelListID_);

    /**
     * Destructor
     */
    inline  ~T_usb_tcu_Favorite_channel_info();

    /**
     * Assignment operator
     */
    inline T_usb_tcu_Favorite_channel_info& operator = (const T_usb_tcu_Favorite_channel_info& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_usb_tcu_Favorite_channel_info& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_usb_tcu_Favorite_channel_info& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_usb_tcu_Favorite_channel_info& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_usb_tcu_Favorite_channel_info& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "strChannelName"

    static const int kStrChannelName = 0;

    /**
     * Clears the field "strChannelName".
     *
     * The field will be set to its default value. The hasStrChannelName()
     * method will return false.
     */
    inline void clearStrChannelName();

    /**
     * Checks whether the field "strChannelName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrChannelName()). Otherwise it will return false.
     */
    inline bool hasStrChannelName () const;

    /**
     * Returns the value of the member "strChannelName".
     *
     * Channel Name.
     *
     * @return The value of the field "strChannelName"
     */
    inline const ::std::string& getStrChannelName () const;

    /**
     * Retrieves the value of the field "strChannelName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strChannelName".
     */
    inline ::std::string& getStrChannelNameMutable ();

    /**
     * Sets the value of the member "strChannelName".
     *
     * Channel Name.
     *
     * @param strChannelName The value which will be set
     */
    inline void setStrChannelName (const ::std::string& strChannelName_);

    /**
     * Sets the value of the member "strChannelName".
     *
     * Channel Name.
     *
     * @param strChannelName The value which will be set
     */
    inline void setStrChannelName (const char* strChannelName_);

    /**
     * Sets the value of the member "strChannelName".
     *
     * Channel Name.
     *
     * @param strChannelName The value which will be set
     */
    inline void setStrChannelName (const char* value, size_t size);

    // API of field "strChannelNameForTTS"

    static const int kStrChannelNameForTTS = 1;

    /**
     * Clears the field "strChannelNameForTTS".
     *
     * The field will be set to its default value. The hasStrChannelNameForTTS()
     * method will return false.
     */
    inline void clearStrChannelNameForTTS();

    /**
     * Checks whether the field "strChannelNameForTTS" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrChannelNameForTTS()). Otherwise it will return false.
     */
    inline bool hasStrChannelNameForTTS () const;

    /**
     * Returns the value of the member "strChannelNameForTTS".
     *
     * Channel Name for TTS.
     *
     * @return The value of the field "strChannelNameForTTS"
     */
    inline const ::std::string& getStrChannelNameForTTS () const;

    /**
     * Retrieves the value of the field "strChannelNameForTTS" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strChannelNameForTTS".
     */
    inline ::std::string& getStrChannelNameForTTSMutable ();

    /**
     * Sets the value of the member "strChannelNameForTTS".
     *
     * Channel Name for TTS.
     *
     * @param strChannelNameForTTS The value which will be set
     */
    inline void setStrChannelNameForTTS (const ::std::string& strChannelNameForTTS_);

    /**
     * Sets the value of the member "strChannelNameForTTS".
     *
     * Channel Name for TTS.
     *
     * @param strChannelNameForTTS The value which will be set
     */
    inline void setStrChannelNameForTTS (const char* strChannelNameForTTS_);

    /**
     * Sets the value of the member "strChannelNameForTTS".
     *
     * Channel Name for TTS.
     *
     * @param strChannelNameForTTS The value which will be set
     */
    inline void setStrChannelNameForTTS (const char* value, size_t size);

    // API of field "u16ChannelID"

    static const int kU16ChannelID = 2;

    /**
     * Clears the field "u16ChannelID".
     *
     * The field will be set to its default value. The hasU16ChannelID()
     * method will return false.
     */
    inline void clearU16ChannelID();

    /**
     * Checks whether the field "u16ChannelID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ChannelID()). Otherwise it will return false.
     */
    inline bool hasU16ChannelID () const;

    /**
     * Returns the value of the member "u16ChannelID".
     *
     * Channel data ID
     *
     * @return The value of the field "u16ChannelID"
     */
    inline uint16 getU16ChannelID () const;

    /**
     * Sets the value of the member "u16ChannelID".
     *
     * Channel data ID
     *
     * @param u16ChannelID The value which will be set
     */
    inline void setU16ChannelID (uint16 u16ChannelID_);

    // API of field "u8FavoriteChannelListID"

    static const int kU8FavoriteChannelListID = 3;

    /**
     * Clears the field "u8FavoriteChannelListID".
     *
     * The field will be set to its default value. The hasU8FavoriteChannelListID()
     * method will return false.
     */
    inline void clearU8FavoriteChannelListID();

    /**
     * Checks whether the field "u8FavoriteChannelListID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8FavoriteChannelListID()). Otherwise it will return false.
     */
    inline bool hasU8FavoriteChannelListID () const;

    /**
     * Returns the value of the member "u8FavoriteChannelListID".
     *
     * Registerd order number of favorite channel list
     *
     * @return The value of the field "u8FavoriteChannelListID"
     */
    inline uint8 getU8FavoriteChannelListID () const;

    /**
     * Sets the value of the member "u8FavoriteChannelListID".
     *
     * Registerd order number of favorite channel list
     *
     * @param u8FavoriteChannelListID The value which will be set
     */
    inline void setU8FavoriteChannelListID (uint8 u8FavoriteChannelListID_);

    static const T_usb_tcu_Favorite_channel_info &getDefaultInstance();

private:

    inline void set_has_strChannelName ();

    inline void clear_has_strChannelName ();

    inline void set_has_strChannelNameForTTS ();

    inline void clear_has_strChannelNameForTTS ();

    inline void set_has_u16ChannelID ();

    inline void clear_has_u16ChannelID ();

    inline void set_has_u8FavoriteChannelListID ();

    inline void clear_has_u8FavoriteChannelListID ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::string _strChannelName;

    ::std::string _strChannelNameForTTS;

    uint16 _u16ChannelID;

    uint8 _u8FavoriteChannelListID;

};

/**
 * If the meaning of "T_tcu_Block_Data_List" isn't clear, then there should be a description here.
 */
class T_tcu_Block_Data_List {
public:

    /**
     * Default constructor
     */
    inline  T_tcu_Block_Data_List ();

    /**
     * Copy constructor
     */
    inline  T_tcu_Block_Data_List (const T_tcu_Block_Data_List &rhs);

    /**
     * All fields constructor
     */
    inline  T_tcu_Block_Data_List (uint16 u16NumberOfSecondLevelMesh_, uint8 u8PredectedDate_, uint16 u16PredectedDate_, uint16 u16RequestInformationType_, uint16 u16Reserved_, uint8 u8InformationSourceID_, const ::std::vector< uint16 >& SecondLevelMeshCoordinateList_);

    /**
     * Destructor
     */
    inline  ~T_tcu_Block_Data_List();

    /**
     * Assignment operator
     */
    inline T_tcu_Block_Data_List& operator = (const T_tcu_Block_Data_List& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_tcu_Block_Data_List& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_tcu_Block_Data_List& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_tcu_Block_Data_List& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_tcu_Block_Data_List& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16NumberOfSecondLevelMesh"

    static const int kU16NumberOfSecondLevelMesh = 0;

    /**
     * Clears the field "u16NumberOfSecondLevelMesh".
     *
     * The field will be set to its default value. The hasU16NumberOfSecondLevelMesh()
     * method will return false.
     */
    inline void clearU16NumberOfSecondLevelMesh();

    /**
     * Checks whether the field "u16NumberOfSecondLevelMesh" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16NumberOfSecondLevelMesh()). Otherwise it will return false.
     */
    inline bool hasU16NumberOfSecondLevelMesh () const;

    /**
     * Returns the value of the member "u16NumberOfSecondLevelMesh".
     *
     * If the meaning of "u16NumberOfSecondLevelMesh" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u16NumberOfSecondLevelMesh"
     */
    inline uint16 getU16NumberOfSecondLevelMesh () const;

    /**
     * Sets the value of the member "u16NumberOfSecondLevelMesh".
     *
     * If the meaning of "u16NumberOfSecondLevelMesh" isn't clear, then there should be a description here.
     *
     * @param u16NumberOfSecondLevelMesh The value which will be set
     */
    inline void setU16NumberOfSecondLevelMesh (uint16 u16NumberOfSecondLevelMesh_);

    // API of field "u8PredectedDate"

    static const int kU8PredectedDate = 1;

    /**
     * Clears the field "u8PredectedDate".
     *
     * The field will be set to its default value. The hasU8PredectedDate()
     * method will return false.
     */
    inline void clearU8PredectedDate();

    /**
     * Checks whether the field "u8PredectedDate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8PredectedDate()). Otherwise it will return false.
     */
    inline bool hasU8PredectedDate () const;

    /**
     * Returns the value of the member "u8PredectedDate".
     *
     * If the meaning of "u8PredectedDate" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8PredectedDate"
     */
    inline uint8 getU8PredectedDate () const;

    /**
     * Sets the value of the member "u8PredectedDate".
     *
     * If the meaning of "u8PredectedDate" isn't clear, then there should be a description here.
     *
     * @param u8PredectedDate The value which will be set
     */
    inline void setU8PredectedDate (uint8 u8PredectedDate_);

    // API of field "u16PredectedDate"

    static const int kU16PredectedDate = 2;

    /**
     * Clears the field "u16PredectedDate".
     *
     * The field will be set to its default value. The hasU16PredectedDate()
     * method will return false.
     */
    inline void clearU16PredectedDate();

    /**
     * Checks whether the field "u16PredectedDate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16PredectedDate()). Otherwise it will return false.
     */
    inline bool hasU16PredectedDate () const;

    /**
     * Returns the value of the member "u16PredectedDate".
     *
     * If the meaning of "u16PredectedDate" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u16PredectedDate"
     */
    inline uint16 getU16PredectedDate () const;

    /**
     * Sets the value of the member "u16PredectedDate".
     *
     * If the meaning of "u16PredectedDate" isn't clear, then there should be a description here.
     *
     * @param u16PredectedDate The value which will be set
     */
    inline void setU16PredectedDate (uint16 u16PredectedDate_);

    // API of field "u16RequestInformationType"

    static const int kU16RequestInformationType = 3;

    /**
     * Clears the field "u16RequestInformationType".
     *
     * The field will be set to its default value. The hasU16RequestInformationType()
     * method will return false.
     */
    inline void clearU16RequestInformationType();

    /**
     * Checks whether the field "u16RequestInformationType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16RequestInformationType()). Otherwise it will return false.
     */
    inline bool hasU16RequestInformationType () const;

    /**
     * Returns the value of the member "u16RequestInformationType".
     *
     * If the meaning of "u16RequestInformationType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u16RequestInformationType"
     */
    inline uint16 getU16RequestInformationType () const;

    /**
     * Sets the value of the member "u16RequestInformationType".
     *
     * If the meaning of "u16RequestInformationType" isn't clear, then there should be a description here.
     *
     * @param u16RequestInformationType The value which will be set
     */
    inline void setU16RequestInformationType (uint16 u16RequestInformationType_);

    // API of field "u16Reserved"

    static const int kU16Reserved = 4;

    /**
     * Clears the field "u16Reserved".
     *
     * The field will be set to its default value. The hasU16Reserved()
     * method will return false.
     */
    inline void clearU16Reserved();

    /**
     * Checks whether the field "u16Reserved" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16Reserved()). Otherwise it will return false.
     */
    inline bool hasU16Reserved () const;

    /**
     * Returns the value of the member "u16Reserved".
     *
     * If the meaning of "u16Reserved" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u16Reserved"
     */
    inline uint16 getU16Reserved () const;

    /**
     * Sets the value of the member "u16Reserved".
     *
     * If the meaning of "u16Reserved" isn't clear, then there should be a description here.
     *
     * @param u16Reserved The value which will be set
     */
    inline void setU16Reserved (uint16 u16Reserved_);

    // API of field "u8InformationSourceID"

    static const int kU8InformationSourceID = 5;

    /**
     * Clears the field "u8InformationSourceID".
     *
     * The field will be set to its default value. The hasU8InformationSourceID()
     * method will return false.
     */
    inline void clearU8InformationSourceID();

    /**
     * Checks whether the field "u8InformationSourceID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8InformationSourceID()). Otherwise it will return false.
     */
    inline bool hasU8InformationSourceID () const;

    /**
     * Returns the value of the member "u8InformationSourceID".
     *
     * If the meaning of "u8InformationSourceID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8InformationSourceID"
     */
    inline uint8 getU8InformationSourceID () const;

    /**
     * Sets the value of the member "u8InformationSourceID".
     *
     * If the meaning of "u8InformationSourceID" isn't clear, then there should be a description here.
     *
     * @param u8InformationSourceID The value which will be set
     */
    inline void setU8InformationSourceID (uint8 u8InformationSourceID_);

    // API of field "SecondLevelMeshCoordinateList"

    static const int kSecondLevelMeshCoordinateList = 6;

    /**
     * Clears the field "SecondLevelMeshCoordinateList".
     *
     * The field will be set to its default value. The hasSecondLevelMeshCoordinateList()
     * method will return false.
     */
    inline void clearSecondLevelMeshCoordinateList();

    /**
     * Checks whether the field "SecondLevelMeshCoordinateList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSecondLevelMeshCoordinateList()). Otherwise it will return false.
     */
    inline bool hasSecondLevelMeshCoordinateList () const;

    /**
     * Returns the value of the member "SecondLevelMeshCoordinateList".
     *
     * Second Level Mesh Coordinate List
     *
     * @return The value of the field "SecondLevelMeshCoordinateList"
     */
    inline const ::std::vector< uint16 >& getSecondLevelMeshCoordinateList () const;

    /**
     * Retrieves the value of the field "SecondLevelMeshCoordinateList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SecondLevelMeshCoordinateList".
     */
    inline ::std::vector< uint16 >& getSecondLevelMeshCoordinateListMutable ();

    /**
     * Sets the value of the member "SecondLevelMeshCoordinateList".
     *
     * Second Level Mesh Coordinate List
     *
     * @param SecondLevelMeshCoordinateList The value which will be set
     */
    inline void setSecondLevelMeshCoordinateList (const ::std::vector< uint16 >& SecondLevelMeshCoordinateList_);

    static const T_tcu_Block_Data_List &getDefaultInstance();

private:

    static const ::std::vector< uint16 >& getUint16List_DefaultInstance ();

    inline void set_has_u16NumberOfSecondLevelMesh ();

    inline void clear_has_u16NumberOfSecondLevelMesh ();

    inline void set_has_u8PredectedDate ();

    inline void clear_has_u8PredectedDate ();

    inline void set_has_u16PredectedDate ();

    inline void clear_has_u16PredectedDate ();

    inline void set_has_u16RequestInformationType ();

    inline void clear_has_u16RequestInformationType ();

    inline void set_has_u16Reserved ();

    inline void clear_has_u16Reserved ();

    inline void set_has_u8InformationSourceID ();

    inline void clear_has_u8InformationSourceID ();

    inline void set_has_SecondLevelMeshCoordinateList ();

    inline void clear_has_SecondLevelMeshCoordinateList ();

    uint32 _has_bits_[ (7 + 31) / 32];

    uint16 _u16NumberOfSecondLevelMesh;

    uint8 _u8PredectedDate;

    uint16 _u16PredectedDate;

    uint16 _u16RequestInformationType;

    uint16 _u16Reserved;

    uint8 _u8InformationSourceID;

    ::std::vector< uint16 > _SecondLevelMeshCoordinateList;

};

/**
 * This structure holds information about the location details
 */
class T_tcu_Japan_Location {
public:

    /**
     * Default constructor
     */
    inline  T_tcu_Japan_Location ();

    /**
     * Copy constructor
     */
    inline  T_tcu_Japan_Location (const T_tcu_Japan_Location &rhs);

    /**
     * All fields constructor
     */
    inline  T_tcu_Japan_Location (uint16 u16SecondLevelMesh_CoordinateId_, uint16 u16SecondLevelMesh_XCoordinate_, uint16 u16SecondLevelMesh_YCoordinate_);

    /**
     * Destructor
     */
    inline  ~T_tcu_Japan_Location();

    /**
     * Assignment operator
     */
    inline T_tcu_Japan_Location& operator = (const T_tcu_Japan_Location& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_tcu_Japan_Location& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_tcu_Japan_Location& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_tcu_Japan_Location& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_tcu_Japan_Location& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16SecondLevelMesh_CoordinateId"

    static const int kU16SecondLevelMesh_CoordinateId = 0;

    /**
     * Clears the field "u16SecondLevelMesh_CoordinateId".
     *
     * The field will be set to its default value. The hasU16SecondLevelMesh_CoordinateId()
     * method will return false.
     */
    inline void clearU16SecondLevelMesh_CoordinateId();

    /**
     * Checks whether the field "u16SecondLevelMesh_CoordinateId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16SecondLevelMesh_CoordinateId()). Otherwise it will return false.
     */
    inline bool hasU16SecondLevelMesh_CoordinateId () const;

    /**
     * Returns the value of the member "u16SecondLevelMesh_CoordinateId".
     *
     * If the meaning of "u16SecondLevelMesh_CoordinateId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u16SecondLevelMesh_CoordinateId"
     */
    inline uint16 getU16SecondLevelMesh_CoordinateId () const;

    /**
     * Sets the value of the member "u16SecondLevelMesh_CoordinateId".
     *
     * If the meaning of "u16SecondLevelMesh_CoordinateId" isn't clear, then there should be a description here.
     *
     * @param u16SecondLevelMesh_CoordinateId The value which will be set
     */
    inline void setU16SecondLevelMesh_CoordinateId (uint16 u16SecondLevelMesh_CoordinateId_);

    // API of field "u16SecondLevelMesh_XCoordinate"

    static const int kU16SecondLevelMesh_XCoordinate = 1;

    /**
     * Clears the field "u16SecondLevelMesh_XCoordinate".
     *
     * The field will be set to its default value. The hasU16SecondLevelMesh_XCoordinate()
     * method will return false.
     */
    inline void clearU16SecondLevelMesh_XCoordinate();

    /**
     * Checks whether the field "u16SecondLevelMesh_XCoordinate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16SecondLevelMesh_XCoordinate()). Otherwise it will return false.
     */
    inline bool hasU16SecondLevelMesh_XCoordinate () const;

    /**
     * Returns the value of the member "u16SecondLevelMesh_XCoordinate".
     *
     * If the meaning of "u16SecondLevelMesh_XCoordinate" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u16SecondLevelMesh_XCoordinate"
     */
    inline uint16 getU16SecondLevelMesh_XCoordinate () const;

    /**
     * Sets the value of the member "u16SecondLevelMesh_XCoordinate".
     *
     * If the meaning of "u16SecondLevelMesh_XCoordinate" isn't clear, then there should be a description here.
     *
     * @param u16SecondLevelMesh_XCoordinate The value which will be set
     */
    inline void setU16SecondLevelMesh_XCoordinate (uint16 u16SecondLevelMesh_XCoordinate_);

    // API of field "u16SecondLevelMesh_YCoordinate"

    static const int kU16SecondLevelMesh_YCoordinate = 2;

    /**
     * Clears the field "u16SecondLevelMesh_YCoordinate".
     *
     * The field will be set to its default value. The hasU16SecondLevelMesh_YCoordinate()
     * method will return false.
     */
    inline void clearU16SecondLevelMesh_YCoordinate();

    /**
     * Checks whether the field "u16SecondLevelMesh_YCoordinate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16SecondLevelMesh_YCoordinate()). Otherwise it will return false.
     */
    inline bool hasU16SecondLevelMesh_YCoordinate () const;

    /**
     * Returns the value of the member "u16SecondLevelMesh_YCoordinate".
     *
     * If the meaning of "u16SecondLevelMesh_YCoordinate" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u16SecondLevelMesh_YCoordinate"
     */
    inline uint16 getU16SecondLevelMesh_YCoordinate () const;

    /**
     * Sets the value of the member "u16SecondLevelMesh_YCoordinate".
     *
     * If the meaning of "u16SecondLevelMesh_YCoordinate" isn't clear, then there should be a description here.
     *
     * @param u16SecondLevelMesh_YCoordinate The value which will be set
     */
    inline void setU16SecondLevelMesh_YCoordinate (uint16 u16SecondLevelMesh_YCoordinate_);

    static const T_tcu_Japan_Location &getDefaultInstance();

private:

    inline void set_has_u16SecondLevelMesh_CoordinateId ();

    inline void clear_has_u16SecondLevelMesh_CoordinateId ();

    inline void set_has_u16SecondLevelMesh_XCoordinate ();

    inline void clear_has_u16SecondLevelMesh_XCoordinate ();

    inline void set_has_u16SecondLevelMesh_YCoordinate ();

    inline void clear_has_u16SecondLevelMesh_YCoordinate ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint16 _u16SecondLevelMesh_CoordinateId;

    uint16 _u16SecondLevelMesh_XCoordinate;

    uint16 _u16SecondLevelMesh_YCoordinate;

};

/**
 * If the meaning of "T_tcu_navigation_setting_information" isn't clear, then there should be a description here.
 */
class T_tcu_navigation_setting_information {
public:

    /**
     * Default constructor
     */
    inline  T_tcu_navigation_setting_information ();

    /**
     * Copy constructor
     */
    inline  T_tcu_navigation_setting_information (const T_tcu_navigation_setting_information &rhs);

    /**
     * All fields constructor
     */
    inline  T_tcu_navigation_setting_information (const T_tcu_Japan_Location& CurrentLocationInfo_, const T_tcu_Japan_Location& DepartureInfo_, const T_tcu_Japan_Location& DestinationInfo_, const T_tcu_Japan_Location& ScrollPointInfo_, uint16 u16SearchConditionInfo_, uint16 u16VehicleDirectionInfo_, uint8 u8InformationFlag_, uint8 u8WaypointNumber_, const ::std::vector< T_tcu_Japan_Location >& WaypointList_);

    /**
     * Destructor
     */
    inline  ~T_tcu_navigation_setting_information();

    /**
     * Assignment operator
     */
    inline T_tcu_navigation_setting_information& operator = (const T_tcu_navigation_setting_information& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_tcu_navigation_setting_information& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_tcu_navigation_setting_information& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_tcu_navigation_setting_information& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_tcu_navigation_setting_information& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CurrentLocationInfo"

    static const int kCurrentLocationInfo = 0;

    /**
     * Clears the field "CurrentLocationInfo".
     *
     * The field will be set to its default value. The hasCurrentLocationInfo()
     * method will return false.
     */
    inline void clearCurrentLocationInfo();

    /**
     * Checks whether the field "CurrentLocationInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCurrentLocationInfo()). Otherwise it will return false.
     */
    inline bool hasCurrentLocationInfo () const;

    /**
     * Returns the value of the member "CurrentLocationInfo".
     *
     * If the meaning of "CurrentLocationInfo" isn't clear, then there should be a description here.
     *
     * @return The value of the field "CurrentLocationInfo"
     */
    inline const T_tcu_Japan_Location& getCurrentLocationInfo () const;

    /**
     * Retrieves the value of the field "CurrentLocationInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CurrentLocationInfo".
     */
    inline T_tcu_Japan_Location& getCurrentLocationInfoMutable ();

    /**
     * Sets the value of the member "CurrentLocationInfo".
     *
     * If the meaning of "CurrentLocationInfo" isn't clear, then there should be a description here.
     *
     * @param CurrentLocationInfo The value which will be set
     */
    inline void setCurrentLocationInfo (const T_tcu_Japan_Location& CurrentLocationInfo_);

    // API of field "DepartureInfo"

    static const int kDepartureInfo = 1;

    /**
     * Clears the field "DepartureInfo".
     *
     * The field will be set to its default value. The hasDepartureInfo()
     * method will return false.
     */
    inline void clearDepartureInfo();

    /**
     * Checks whether the field "DepartureInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDepartureInfo()). Otherwise it will return false.
     */
    inline bool hasDepartureInfo () const;

    /**
     * Returns the value of the member "DepartureInfo".
     *
     * If the meaning of "DepartureInfo" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DepartureInfo"
     */
    inline const T_tcu_Japan_Location& getDepartureInfo () const;

    /**
     * Retrieves the value of the field "DepartureInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DepartureInfo".
     */
    inline T_tcu_Japan_Location& getDepartureInfoMutable ();

    /**
     * Sets the value of the member "DepartureInfo".
     *
     * If the meaning of "DepartureInfo" isn't clear, then there should be a description here.
     *
     * @param DepartureInfo The value which will be set
     */
    inline void setDepartureInfo (const T_tcu_Japan_Location& DepartureInfo_);

    // API of field "DestinationInfo"

    static const int kDestinationInfo = 2;

    /**
     * Clears the field "DestinationInfo".
     *
     * The field will be set to its default value. The hasDestinationInfo()
     * method will return false.
     */
    inline void clearDestinationInfo();

    /**
     * Checks whether the field "DestinationInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestinationInfo()). Otherwise it will return false.
     */
    inline bool hasDestinationInfo () const;

    /**
     * Returns the value of the member "DestinationInfo".
     *
     * If the meaning of "DestinationInfo" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DestinationInfo"
     */
    inline const T_tcu_Japan_Location& getDestinationInfo () const;

    /**
     * Retrieves the value of the field "DestinationInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DestinationInfo".
     */
    inline T_tcu_Japan_Location& getDestinationInfoMutable ();

    /**
     * Sets the value of the member "DestinationInfo".
     *
     * If the meaning of "DestinationInfo" isn't clear, then there should be a description here.
     *
     * @param DestinationInfo The value which will be set
     */
    inline void setDestinationInfo (const T_tcu_Japan_Location& DestinationInfo_);

    // API of field "ScrollPointInfo"

    static const int kScrollPointInfo = 3;

    /**
     * Clears the field "ScrollPointInfo".
     *
     * The field will be set to its default value. The hasScrollPointInfo()
     * method will return false.
     */
    inline void clearScrollPointInfo();

    /**
     * Checks whether the field "ScrollPointInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setScrollPointInfo()). Otherwise it will return false.
     */
    inline bool hasScrollPointInfo () const;

    /**
     * Returns the value of the member "ScrollPointInfo".
     *
     * If the meaning of "ScrollPointInfo" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ScrollPointInfo"
     */
    inline const T_tcu_Japan_Location& getScrollPointInfo () const;

    /**
     * Retrieves the value of the field "ScrollPointInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ScrollPointInfo".
     */
    inline T_tcu_Japan_Location& getScrollPointInfoMutable ();

    /**
     * Sets the value of the member "ScrollPointInfo".
     *
     * If the meaning of "ScrollPointInfo" isn't clear, then there should be a description here.
     *
     * @param ScrollPointInfo The value which will be set
     */
    inline void setScrollPointInfo (const T_tcu_Japan_Location& ScrollPointInfo_);

    // API of field "u16SearchConditionInfo"

    static const int kU16SearchConditionInfo = 4;

    /**
     * Clears the field "u16SearchConditionInfo".
     *
     * The field will be set to its default value. The hasU16SearchConditionInfo()
     * method will return false.
     */
    inline void clearU16SearchConditionInfo();

    /**
     * Checks whether the field "u16SearchConditionInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16SearchConditionInfo()). Otherwise it will return false.
     */
    inline bool hasU16SearchConditionInfo () const;

    /**
     * Returns the value of the member "u16SearchConditionInfo".
     *
     * If the meaning of "u16SearchConditionInfo" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u16SearchConditionInfo"
     */
    inline uint16 getU16SearchConditionInfo () const;

    /**
     * Sets the value of the member "u16SearchConditionInfo".
     *
     * If the meaning of "u16SearchConditionInfo" isn't clear, then there should be a description here.
     *
     * @param u16SearchConditionInfo The value which will be set
     */
    inline void setU16SearchConditionInfo (uint16 u16SearchConditionInfo_);

    // API of field "u16VehicleDirectionInfo"

    static const int kU16VehicleDirectionInfo = 5;

    /**
     * Clears the field "u16VehicleDirectionInfo".
     *
     * The field will be set to its default value. The hasU16VehicleDirectionInfo()
     * method will return false.
     */
    inline void clearU16VehicleDirectionInfo();

    /**
     * Checks whether the field "u16VehicleDirectionInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16VehicleDirectionInfo()). Otherwise it will return false.
     */
    inline bool hasU16VehicleDirectionInfo () const;

    /**
     * Returns the value of the member "u16VehicleDirectionInfo".
     *
     * If the meaning of "u16VehicleDirectionInfo" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u16VehicleDirectionInfo"
     */
    inline uint16 getU16VehicleDirectionInfo () const;

    /**
     * Sets the value of the member "u16VehicleDirectionInfo".
     *
     * If the meaning of "u16VehicleDirectionInfo" isn't clear, then there should be a description here.
     *
     * @param u16VehicleDirectionInfo The value which will be set
     */
    inline void setU16VehicleDirectionInfo (uint16 u16VehicleDirectionInfo_);

    // API of field "u8InformationFlag"

    static const int kU8InformationFlag = 6;

    /**
     * Clears the field "u8InformationFlag".
     *
     * The field will be set to its default value. The hasU8InformationFlag()
     * method will return false.
     */
    inline void clearU8InformationFlag();

    /**
     * Checks whether the field "u8InformationFlag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8InformationFlag()). Otherwise it will return false.
     */
    inline bool hasU8InformationFlag () const;

    /**
     * Returns the value of the member "u8InformationFlag".
     *
     * If the meaning of "u8InformationFlag" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8InformationFlag"
     */
    inline uint8 getU8InformationFlag () const;

    /**
     * Sets the value of the member "u8InformationFlag".
     *
     * If the meaning of "u8InformationFlag" isn't clear, then there should be a description here.
     *
     * @param u8InformationFlag The value which will be set
     */
    inline void setU8InformationFlag (uint8 u8InformationFlag_);

    // API of field "u8WaypointNumber"

    static const int kU8WaypointNumber = 7;

    /**
     * Clears the field "u8WaypointNumber".
     *
     * The field will be set to its default value. The hasU8WaypointNumber()
     * method will return false.
     */
    inline void clearU8WaypointNumber();

    /**
     * Checks whether the field "u8WaypointNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8WaypointNumber()). Otherwise it will return false.
     */
    inline bool hasU8WaypointNumber () const;

    /**
     * Returns the value of the member "u8WaypointNumber".
     *
     * If the meaning of "u8WaypointNumber" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8WaypointNumber"
     */
    inline uint8 getU8WaypointNumber () const;

    /**
     * Sets the value of the member "u8WaypointNumber".
     *
     * If the meaning of "u8WaypointNumber" isn't clear, then there should be a description here.
     *
     * @param u8WaypointNumber The value which will be set
     */
    inline void setU8WaypointNumber (uint8 u8WaypointNumber_);

    // API of field "WaypointList"

    static const int kWaypointList = 8;

    /**
     * Clears the field "WaypointList".
     *
     * The field will be set to its default value. The hasWaypointList()
     * method will return false.
     */
    inline void clearWaypointList();

    /**
     * Checks whether the field "WaypointList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWaypointList()). Otherwise it will return false.
     */
    inline bool hasWaypointList () const;

    /**
     * Returns the value of the member "WaypointList".
     *
     * Way point list
     *
     * @return The value of the field "WaypointList"
     */
    inline const ::std::vector< T_tcu_Japan_Location >& getWaypointList () const;

    /**
     * Retrieves the value of the field "WaypointList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "WaypointList".
     */
    inline ::std::vector< T_tcu_Japan_Location >& getWaypointListMutable ();

    /**
     * Sets the value of the member "WaypointList".
     *
     * Way point list
     *
     * @param WaypointList The value which will be set
     */
    inline void setWaypointList (const ::std::vector< T_tcu_Japan_Location >& WaypointList_);

    static const T_tcu_navigation_setting_information &getDefaultInstance();

private:

    static const ::std::vector< T_tcu_Japan_Location >& getT_tcu_Japan_LocationList_DefaultInstance ();

    inline void set_has_CurrentLocationInfo ();

    inline void clear_has_CurrentLocationInfo ();

    inline void set_has_DepartureInfo ();

    inline void clear_has_DepartureInfo ();

    inline void set_has_DestinationInfo ();

    inline void clear_has_DestinationInfo ();

    inline void set_has_ScrollPointInfo ();

    inline void clear_has_ScrollPointInfo ();

    inline void set_has_u16SearchConditionInfo ();

    inline void clear_has_u16SearchConditionInfo ();

    inline void set_has_u16VehicleDirectionInfo ();

    inline void clear_has_u16VehicleDirectionInfo ();

    inline void set_has_u8InformationFlag ();

    inline void clear_has_u8InformationFlag ();

    inline void set_has_u8WaypointNumber ();

    inline void clear_has_u8WaypointNumber ();

    inline void set_has_WaypointList ();

    inline void clear_has_WaypointList ();

    uint32 _has_bits_[ (9 + 31) / 32];

    T_tcu_Japan_Location _CurrentLocationInfo;

    T_tcu_Japan_Location _DepartureInfo;

    T_tcu_Japan_Location _DestinationInfo;

    T_tcu_Japan_Location _ScrollPointInfo;

    uint16 _u16SearchConditionInfo;

    uint16 _u16VehicleDirectionInfo;

    uint8 _u8InformationFlag;

    uint8 _u8WaypointNumber;

    ::std::vector< T_tcu_Japan_Location > _WaypointList;

};

/**
 * If the meaning of "T_tcu_VICS_Request_Data" isn't clear, then there should be a description here.
 */
class T_tcu_VICS_Request_Data {
public:

    /**
     * Default constructor
     */
    inline  T_tcu_VICS_Request_Data ();

    /**
     * Copy constructor
     */
    inline  T_tcu_VICS_Request_Data (const T_tcu_VICS_Request_Data &rhs);

    /**
     * All fields constructor
     */
    inline  T_tcu_VICS_Request_Data (const T_tcu_navigation_setting_information& NavigationSettingInformation_, const ::std::vector< T_tcu_Block_Data_List >& BlockDataList_);

    /**
     * Destructor
     */
    inline  ~T_tcu_VICS_Request_Data();

    /**
     * Assignment operator
     */
    inline T_tcu_VICS_Request_Data& operator = (const T_tcu_VICS_Request_Data& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_tcu_VICS_Request_Data& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_tcu_VICS_Request_Data& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_tcu_VICS_Request_Data& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_tcu_VICS_Request_Data& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "NavigationSettingInformation"

    static const int kNavigationSettingInformation = 0;

    /**
     * Clears the field "NavigationSettingInformation".
     *
     * The field will be set to its default value. The hasNavigationSettingInformation()
     * method will return false.
     */
    inline void clearNavigationSettingInformation();

    /**
     * Checks whether the field "NavigationSettingInformation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNavigationSettingInformation()). Otherwise it will return false.
     */
    inline bool hasNavigationSettingInformation () const;

    /**
     * Returns the value of the member "NavigationSettingInformation".
     *
     *
     *
     * @return The value of the field "NavigationSettingInformation"
     */
    inline const T_tcu_navigation_setting_information& getNavigationSettingInformation () const;

    /**
     * Retrieves the value of the field "NavigationSettingInformation" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "NavigationSettingInformation".
     */
    inline T_tcu_navigation_setting_information& getNavigationSettingInformationMutable ();

    /**
     * Sets the value of the member "NavigationSettingInformation".
     *
     *
     *
     * @param NavigationSettingInformation The value which will be set
     */
    inline void setNavigationSettingInformation (const T_tcu_navigation_setting_information& NavigationSettingInformation_);

    // API of field "BlockDataList"

    static const int kBlockDataList = 1;

    /**
     * Clears the field "BlockDataList".
     *
     * The field will be set to its default value. The hasBlockDataList()
     * method will return false.
     */
    inline void clearBlockDataList();

    /**
     * Checks whether the field "BlockDataList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBlockDataList()). Otherwise it will return false.
     */
    inline bool hasBlockDataList () const;

    /**
     * Returns the value of the member "BlockDataList".
     *
     * If the meaning of "BlockDataList" isn't clear, then there should be a description here.
     *
     * @return The value of the field "BlockDataList"
     */
    inline const ::std::vector< T_tcu_Block_Data_List >& getBlockDataList () const;

    /**
     * Retrieves the value of the field "BlockDataList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "BlockDataList".
     */
    inline ::std::vector< T_tcu_Block_Data_List >& getBlockDataListMutable ();

    /**
     * Sets the value of the member "BlockDataList".
     *
     * If the meaning of "BlockDataList" isn't clear, then there should be a description here.
     *
     * @param BlockDataList The value which will be set
     */
    inline void setBlockDataList (const ::std::vector< T_tcu_Block_Data_List >& BlockDataList_);

    static const T_tcu_VICS_Request_Data &getDefaultInstance();

private:

    static const ::std::vector< T_tcu_Block_Data_List >& getT_tcu_Block_Data_ListList_DefaultInstance ();

    inline void set_has_NavigationSettingInformation ();

    inline void clear_has_NavigationSettingInformation ();

    inline void set_has_BlockDataList ();

    inline void clear_has_BlockDataList ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_tcu_navigation_setting_information _NavigationSettingInformation;

    ::std::vector< T_tcu_Block_Data_List > _BlockDataList;

};

/**
 * If the meaning of "T_json_file_path" isn't clear, then there should be a description here.
 */
class T_json_file_path {
public:

    /**
     * Default constructor
     */
    inline  T_json_file_path ();

    /**
     * Copy constructor
     */
    inline  T_json_file_path (const T_json_file_path &rhs);

    /**
     * All fields constructor
     */
    inline  T_json_file_path (const ::std::string& strFilePath_);

    /**
     * Destructor
     */
    inline  ~T_json_file_path();

    /**
     * Assignment operator
     */
    inline T_json_file_path& operator = (const T_json_file_path& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_json_file_path& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_json_file_path& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_json_file_path& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_json_file_path& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "strFilePath"

    static const int kStrFilePath = 0;

    /**
     * Clears the field "strFilePath".
     *
     * The field will be set to its default value. The hasStrFilePath()
     * method will return false.
     */
    inline void clearStrFilePath();

    /**
     * Checks whether the field "strFilePath" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrFilePath()). Otherwise it will return false.
     */
    inline bool hasStrFilePath () const;

    /**
     * Returns the value of the member "strFilePath".
     *
     * Json file path.
     *
     * @return The value of the field "strFilePath"
     */
    inline const ::std::string& getStrFilePath () const;

    /**
     * Retrieves the value of the field "strFilePath" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strFilePath".
     */
    inline ::std::string& getStrFilePathMutable ();

    /**
     * Sets the value of the member "strFilePath".
     *
     * Json file path.
     *
     * @param strFilePath The value which will be set
     */
    inline void setStrFilePath (const ::std::string& strFilePath_);

    /**
     * Sets the value of the member "strFilePath".
     *
     * Json file path.
     *
     * @param strFilePath The value which will be set
     */
    inline void setStrFilePath (const char* strFilePath_);

    /**
     * Sets the value of the member "strFilePath".
     *
     * Json file path.
     *
     * @param strFilePath The value which will be set
     */
    inline void setStrFilePath (const char* value, size_t size);

    static const T_json_file_path &getDefaultInstance();

private:

    inline void set_has_strFilePath ();

    inline void clear_has_strFilePath ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _strFilePath;

};

/**
 * Channel definition information
 */
class T_usb_tcu_Channel_definition_information {
public:

    /**
     * Default constructor
     */
    inline  T_usb_tcu_Channel_definition_information ();

    /**
     * Copy constructor
     */
    inline  T_usb_tcu_Channel_definition_information (const T_usb_tcu_Channel_definition_information &rhs);

    /**
     * All fields constructor
     */
    inline  T_usb_tcu_Channel_definition_information (const ::std::string& strChannelName_, uint16 u16ChannelIconID_, uint16 u16ChannelID_, uint16 u16FolderID_, uint16 u16SizeOfChannelDefInfo_, uint8 u8FixedData1_, uint8 u8FixedData2_, uint8 u8FixedData3_, uint8 u8FixedData6_, uint8 u8FixedData7_, uint8 u8FixedData8_, uint8 u8FixedData9_, uint8 u8FlagOfChannelInfo_, uint8 u8SizeOfChannelName_, const ::std::vector< uint8 >& FixedData4_, const ::std::vector< uint8 >& FixedData5_);

    /**
     * Destructor
     */
    inline  ~T_usb_tcu_Channel_definition_information();

    /**
     * Assignment operator
     */
    inline T_usb_tcu_Channel_definition_information& operator = (const T_usb_tcu_Channel_definition_information& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_usb_tcu_Channel_definition_information& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_usb_tcu_Channel_definition_information& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_usb_tcu_Channel_definition_information& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_usb_tcu_Channel_definition_information& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "strChannelName"

    static const int kStrChannelName = 0;

    /**
     * Clears the field "strChannelName".
     *
     * The field will be set to its default value. The hasStrChannelName()
     * method will return false.
     */
    inline void clearStrChannelName();

    /**
     * Checks whether the field "strChannelName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrChannelName()). Otherwise it will return false.
     */
    inline bool hasStrChannelName () const;

    /**
     * Returns the value of the member "strChannelName".
     *
     * Name of channel for display
     *
     * @return The value of the field "strChannelName"
     */
    inline const ::std::string& getStrChannelName () const;

    /**
     * Retrieves the value of the field "strChannelName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strChannelName".
     */
    inline ::std::string& getStrChannelNameMutable ();

    /**
     * Sets the value of the member "strChannelName".
     *
     * Name of channel for display
     *
     * @param strChannelName The value which will be set
     */
    inline void setStrChannelName (const ::std::string& strChannelName_);

    /**
     * Sets the value of the member "strChannelName".
     *
     * Name of channel for display
     *
     * @param strChannelName The value which will be set
     */
    inline void setStrChannelName (const char* strChannelName_);

    /**
     * Sets the value of the member "strChannelName".
     *
     * Name of channel for display
     *
     * @param strChannelName The value which will be set
     */
    inline void setStrChannelName (const char* value, size_t size);

    // API of field "u16ChannelIconID"

    static const int kU16ChannelIconID = 1;

    /**
     * Clears the field "u16ChannelIconID".
     *
     * The field will be set to its default value. The hasU16ChannelIconID()
     * method will return false.
     */
    inline void clearU16ChannelIconID();

    /**
     * Checks whether the field "u16ChannelIconID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ChannelIconID()). Otherwise it will return false.
     */
    inline bool hasU16ChannelIconID () const;

    /**
     * Returns the value of the member "u16ChannelIconID".
     *
     * ID of icon for displaying channel menu
     *
     * @return The value of the field "u16ChannelIconID"
     */
    inline uint16 getU16ChannelIconID () const;

    /**
     * Sets the value of the member "u16ChannelIconID".
     *
     * ID of icon for displaying channel menu
     *
     * @param u16ChannelIconID The value which will be set
     */
    inline void setU16ChannelIconID (uint16 u16ChannelIconID_);

    // API of field "u16ChannelID"

    static const int kU16ChannelID = 2;

    /**
     * Clears the field "u16ChannelID".
     *
     * The field will be set to its default value. The hasU16ChannelID()
     * method will return false.
     */
    inline void clearU16ChannelID();

    /**
     * Checks whether the field "u16ChannelID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ChannelID()). Otherwise it will return false.
     */
    inline bool hasU16ChannelID () const;

    /**
     * Returns the value of the member "u16ChannelID".
     *
     * ID of channel
     *
     * @return The value of the field "u16ChannelID"
     */
    inline uint16 getU16ChannelID () const;

    /**
     * Sets the value of the member "u16ChannelID".
     *
     * ID of channel
     *
     * @param u16ChannelID The value which will be set
     */
    inline void setU16ChannelID (uint16 u16ChannelID_);

    // API of field "u16FolderID"

    static const int kU16FolderID = 3;

    /**
     * Clears the field "u16FolderID".
     *
     * The field will be set to its default value. The hasU16FolderID()
     * method will return false.
     */
    inline void clearU16FolderID();

    /**
     * Checks whether the field "u16FolderID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16FolderID()). Otherwise it will return false.
     */
    inline bool hasU16FolderID () const;

    /**
     * Returns the value of the member "u16FolderID".
     *
     * <p>ID of folder which this channel is included</p>
     * <p>Up to 100 channels can be included in one folder</p>
     *
     * @return The value of the field "u16FolderID"
     */
    inline uint16 getU16FolderID () const;

    /**
     * Sets the value of the member "u16FolderID".
     *
     * <p>ID of folder which this channel is included</p>
     * <p>Up to 100 channels can be included in one folder</p>
     *
     * @param u16FolderID The value which will be set
     */
    inline void setU16FolderID (uint16 u16FolderID_);

    // API of field "u16SizeOfChannelDefInfo"

    static const int kU16SizeOfChannelDefInfo = 4;

    /**
     * Clears the field "u16SizeOfChannelDefInfo".
     *
     * The field will be set to its default value. The hasU16SizeOfChannelDefInfo()
     * method will return false.
     */
    inline void clearU16SizeOfChannelDefInfo();

    /**
     * Checks whether the field "u16SizeOfChannelDefInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16SizeOfChannelDefInfo()). Otherwise it will return false.
     */
    inline bool hasU16SizeOfChannelDefInfo () const;

    /**
     * Returns the value of the member "u16SizeOfChannelDefInfo".
     *
     * Total size of following data
     *
     * @return The value of the field "u16SizeOfChannelDefInfo"
     */
    inline uint16 getU16SizeOfChannelDefInfo () const;

    /**
     * Sets the value of the member "u16SizeOfChannelDefInfo".
     *
     * Total size of following data
     *
     * @param u16SizeOfChannelDefInfo The value which will be set
     */
    inline void setU16SizeOfChannelDefInfo (uint16 u16SizeOfChannelDefInfo_);

    // API of field "u8FixedData1"

    static const int kU8FixedData1 = 5;

    /**
     * Clears the field "u8FixedData1".
     *
     * The field will be set to its default value. The hasU8FixedData1()
     * method will return false.
     */
    inline void clearU8FixedData1();

    /**
     * Checks whether the field "u8FixedData1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8FixedData1()). Otherwise it will return false.
     */
    inline bool hasU8FixedData1 () const;

    /**
     * Returns the value of the member "u8FixedData1".
     *
     * Fixed value of 0x00
     *
     * @return The value of the field "u8FixedData1"
     */
    inline uint8 getU8FixedData1 () const;

    /**
     * Sets the value of the member "u8FixedData1".
     *
     * Fixed value of 0x00
     *
     * @param u8FixedData1 The value which will be set
     */
    inline void setU8FixedData1 (uint8 u8FixedData1_);

    // API of field "u8FixedData2"

    static const int kU8FixedData2 = 6;

    /**
     * Clears the field "u8FixedData2".
     *
     * The field will be set to its default value. The hasU8FixedData2()
     * method will return false.
     */
    inline void clearU8FixedData2();

    /**
     * Checks whether the field "u8FixedData2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8FixedData2()). Otherwise it will return false.
     */
    inline bool hasU8FixedData2 () const;

    /**
     * Returns the value of the member "u8FixedData2".
     *
     * Fixed value of 0xFF
     *
     * @return The value of the field "u8FixedData2"
     */
    inline uint8 getU8FixedData2 () const;

    /**
     * Sets the value of the member "u8FixedData2".
     *
     * Fixed value of 0xFF
     *
     * @param u8FixedData2 The value which will be set
     */
    inline void setU8FixedData2 (uint8 u8FixedData2_);

    // API of field "u8FixedData3"

    static const int kU8FixedData3 = 7;

    /**
     * Clears the field "u8FixedData3".
     *
     * The field will be set to its default value. The hasU8FixedData3()
     * method will return false.
     */
    inline void clearU8FixedData3();

    /**
     * Checks whether the field "u8FixedData3" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8FixedData3()). Otherwise it will return false.
     */
    inline bool hasU8FixedData3 () const;

    /**
     * Returns the value of the member "u8FixedData3".
     *
     * Fixed value of 0x00
     *
     * @return The value of the field "u8FixedData3"
     */
    inline uint8 getU8FixedData3 () const;

    /**
     * Sets the value of the member "u8FixedData3".
     *
     * Fixed value of 0x00
     *
     * @param u8FixedData3 The value which will be set
     */
    inline void setU8FixedData3 (uint8 u8FixedData3_);

    // API of field "u8FixedData6"

    static const int kU8FixedData6 = 8;

    /**
     * Clears the field "u8FixedData6".
     *
     * The field will be set to its default value. The hasU8FixedData6()
     * method will return false.
     */
    inline void clearU8FixedData6();

    /**
     * Checks whether the field "u8FixedData6" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8FixedData6()). Otherwise it will return false.
     */
    inline bool hasU8FixedData6 () const;

    /**
     * Returns the value of the member "u8FixedData6".
     *
     * Fixed value of 0x00
     *
     * @return The value of the field "u8FixedData6"
     */
    inline uint8 getU8FixedData6 () const;

    /**
     * Sets the value of the member "u8FixedData6".
     *
     * Fixed value of 0x00
     *
     * @param u8FixedData6 The value which will be set
     */
    inline void setU8FixedData6 (uint8 u8FixedData6_);

    // API of field "u8FixedData7"

    static const int kU8FixedData7 = 9;

    /**
     * Clears the field "u8FixedData7".
     *
     * The field will be set to its default value. The hasU8FixedData7()
     * method will return false.
     */
    inline void clearU8FixedData7();

    /**
     * Checks whether the field "u8FixedData7" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8FixedData7()). Otherwise it will return false.
     */
    inline bool hasU8FixedData7 () const;

    /**
     * Returns the value of the member "u8FixedData7".
     *
     * Fixed value of 0x00
     *
     * @return The value of the field "u8FixedData7"
     */
    inline uint8 getU8FixedData7 () const;

    /**
     * Sets the value of the member "u8FixedData7".
     *
     * Fixed value of 0x00
     *
     * @param u8FixedData7 The value which will be set
     */
    inline void setU8FixedData7 (uint8 u8FixedData7_);

    // API of field "u8FixedData8"

    static const int kU8FixedData8 = 10;

    /**
     * Clears the field "u8FixedData8".
     *
     * The field will be set to its default value. The hasU8FixedData8()
     * method will return false.
     */
    inline void clearU8FixedData8();

    /**
     * Checks whether the field "u8FixedData8" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8FixedData8()). Otherwise it will return false.
     */
    inline bool hasU8FixedData8 () const;

    /**
     * Returns the value of the member "u8FixedData8".
     *
     * Fixed value of 0x00
     *
     * @return The value of the field "u8FixedData8"
     */
    inline uint8 getU8FixedData8 () const;

    /**
     * Sets the value of the member "u8FixedData8".
     *
     * Fixed value of 0x00
     *
     * @param u8FixedData8 The value which will be set
     */
    inline void setU8FixedData8 (uint8 u8FixedData8_);

    // API of field "u8FixedData9"

    static const int kU8FixedData9 = 11;

    /**
     * Clears the field "u8FixedData9".
     *
     * The field will be set to its default value. The hasU8FixedData9()
     * method will return false.
     */
    inline void clearU8FixedData9();

    /**
     * Checks whether the field "u8FixedData9" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8FixedData9()). Otherwise it will return false.
     */
    inline bool hasU8FixedData9 () const;

    /**
     * Returns the value of the member "u8FixedData9".
     *
     * Fixed value of 0x00
     *
     * @return The value of the field "u8FixedData9"
     */
    inline uint8 getU8FixedData9 () const;

    /**
     * Sets the value of the member "u8FixedData9".
     *
     * Fixed value of 0x00
     *
     * @param u8FixedData9 The value which will be set
     */
    inline void setU8FixedData9 (uint8 u8FixedData9_);

    // API of field "u8FlagOfChannelInfo"

    static const int kU8FlagOfChannelInfo = 12;

    /**
     * Clears the field "u8FlagOfChannelInfo".
     *
     * The field will be set to its default value. The hasU8FlagOfChannelInfo()
     * method will return false.
     */
    inline void clearU8FlagOfChannelInfo();

    /**
     * Checks whether the field "u8FlagOfChannelInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8FlagOfChannelInfo()). Otherwise it will return false.
     */
    inline bool hasU8FlagOfChannelInfo () const;

    /**
     * Returns the value of the member "u8FlagOfChannelInfo".
     *
     * <p>-> 0: All contents in this channel are downloaded in one or more packages</p>
     * <p>-> 1: All contents in this channel are downloaded in one package</p>
     * <p>Bit 0- Reserved</p>
     * <p>Bit 1- Reserved</p>
     * <p>Bit 2- Reserved</p>
     * <p>Bit 3- Reserved</p>
     * <p>Bit 4- Reserved</p>
     * <p>Bit 5- Reserved</p>
     * <p>Bit 6- Reserved</p>
     * <p>Bit 7- CommunicationSequenceType</p>
     * <p>Flag about channel information</p>
     *
     * @return The value of the field "u8FlagOfChannelInfo"
     */
    inline uint8 getU8FlagOfChannelInfo () const;

    /**
     * Sets the value of the member "u8FlagOfChannelInfo".
     *
     * <p>-> 0: All contents in this channel are downloaded in one or more packages</p>
     * <p>-> 1: All contents in this channel are downloaded in one package</p>
     * <p>Bit 0- Reserved</p>
     * <p>Bit 1- Reserved</p>
     * <p>Bit 2- Reserved</p>
     * <p>Bit 3- Reserved</p>
     * <p>Bit 4- Reserved</p>
     * <p>Bit 5- Reserved</p>
     * <p>Bit 6- Reserved</p>
     * <p>Bit 7- CommunicationSequenceType</p>
     * <p>Flag about channel information</p>
     *
     * @param u8FlagOfChannelInfo The value which will be set
     */
    inline void setU8FlagOfChannelInfo (uint8 u8FlagOfChannelInfo_);

    // API of field "u8SizeOfChannelName"

    static const int kU8SizeOfChannelName = 13;

    /**
     * Clears the field "u8SizeOfChannelName".
     *
     * The field will be set to its default value. The hasU8SizeOfChannelName()
     * method will return false.
     */
    inline void clearU8SizeOfChannelName();

    /**
     * Checks whether the field "u8SizeOfChannelName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SizeOfChannelName()). Otherwise it will return false.
     */
    inline bool hasU8SizeOfChannelName () const;

    /**
     * Returns the value of the member "u8SizeOfChannelName".
     *
     * Size of channel name
     *
     * @return The value of the field "u8SizeOfChannelName"
     */
    inline uint8 getU8SizeOfChannelName () const;

    /**
     * Sets the value of the member "u8SizeOfChannelName".
     *
     * Size of channel name
     *
     * @param u8SizeOfChannelName The value which will be set
     */
    inline void setU8SizeOfChannelName (uint8 u8SizeOfChannelName_);

    // API of field "FixedData4"

    static const int kFixedData4 = 14;

    /**
     * Clears the field "FixedData4".
     *
     * The field will be set to its default value. The hasFixedData4()
     * method will return false.
     */
    inline void clearFixedData4();

    /**
     * Checks whether the field "FixedData4" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFixedData4()). Otherwise it will return false.
     */
    inline bool hasFixedData4 () const;

    /**
     * Returns the value of the member "FixedData4".
     *
     * BYTE(6) Fixed value of 0xFFFFFFFFFFFF
     *
     * @return The value of the field "FixedData4"
     */
    inline const ::std::vector< uint8 >& getFixedData4 () const;

    /**
     * Retrieves the value of the field "FixedData4" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "FixedData4".
     */
    inline ::std::vector< uint8 >& getFixedData4Mutable ();

    /**
     * Sets the value of the member "FixedData4".
     *
     * BYTE(6) Fixed value of 0xFFFFFFFFFFFF
     *
     * @param FixedData4 The value which will be set
     */
    inline void setFixedData4 (const ::std::vector< uint8 >& FixedData4_);

    // API of field "FixedData5"

    static const int kFixedData5 = 15;

    /**
     * Clears the field "FixedData5".
     *
     * The field will be set to its default value. The hasFixedData5()
     * method will return false.
     */
    inline void clearFixedData5();

    /**
     * Checks whether the field "FixedData5" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFixedData5()). Otherwise it will return false.
     */
    inline bool hasFixedData5 () const;

    /**
     * Returns the value of the member "FixedData5".
     *
     * BYTE(6) Fixed value of 0xFFFFFFFFFFFF
     *
     * @return The value of the field "FixedData5"
     */
    inline const ::std::vector< uint8 >& getFixedData5 () const;

    /**
     * Retrieves the value of the field "FixedData5" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "FixedData5".
     */
    inline ::std::vector< uint8 >& getFixedData5Mutable ();

    /**
     * Sets the value of the member "FixedData5".
     *
     * BYTE(6) Fixed value of 0xFFFFFFFFFFFF
     *
     * @param FixedData5 The value which will be set
     */
    inline void setFixedData5 (const ::std::vector< uint8 >& FixedData5_);

    static const T_usb_tcu_Channel_definition_information &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_strChannelName ();

    inline void clear_has_strChannelName ();

    inline void set_has_u16ChannelIconID ();

    inline void clear_has_u16ChannelIconID ();

    inline void set_has_u16ChannelID ();

    inline void clear_has_u16ChannelID ();

    inline void set_has_u16FolderID ();

    inline void clear_has_u16FolderID ();

    inline void set_has_u16SizeOfChannelDefInfo ();

    inline void clear_has_u16SizeOfChannelDefInfo ();

    inline void set_has_u8FixedData1 ();

    inline void clear_has_u8FixedData1 ();

    inline void set_has_u8FixedData2 ();

    inline void clear_has_u8FixedData2 ();

    inline void set_has_u8FixedData3 ();

    inline void clear_has_u8FixedData3 ();

    inline void set_has_u8FixedData6 ();

    inline void clear_has_u8FixedData6 ();

    inline void set_has_u8FixedData7 ();

    inline void clear_has_u8FixedData7 ();

    inline void set_has_u8FixedData8 ();

    inline void clear_has_u8FixedData8 ();

    inline void set_has_u8FixedData9 ();

    inline void clear_has_u8FixedData9 ();

    inline void set_has_u8FlagOfChannelInfo ();

    inline void clear_has_u8FlagOfChannelInfo ();

    inline void set_has_u8SizeOfChannelName ();

    inline void clear_has_u8SizeOfChannelName ();

    inline void set_has_FixedData4 ();

    inline void clear_has_FixedData4 ();

    inline void set_has_FixedData5 ();

    inline void clear_has_FixedData5 ();

    uint32 _has_bits_[ (16 + 31) / 32];

    ::std::string _strChannelName;

    uint16 _u16ChannelIconID;

    uint16 _u16ChannelID;

    uint16 _u16FolderID;

    uint16 _u16SizeOfChannelDefInfo;

    uint8 _u8FixedData1;

    uint8 _u8FixedData2;

    uint8 _u8FixedData3;

    uint8 _u8FixedData6;

    uint8 _u8FixedData7;

    uint8 _u8FixedData8;

    uint8 _u8FixedData9;

    uint8 _u8FlagOfChannelInfo;

    uint8 _u8SizeOfChannelName;

    ::std::vector< uint8 > _FixedData4;

    ::std::vector< uint8 > _FixedData5;

};

/**
 * If the meaning of "T_usb_tcu_Channel_Info" isn't clear, then there should be a description here.
 */
class T_usb_tcu_Channel_Info {
public:

    /**
     * Default constructor
     */
    inline  T_usb_tcu_Channel_Info ();

    /**
     * Copy constructor
     */
    inline  T_usb_tcu_Channel_Info (const T_usb_tcu_Channel_Info &rhs);

    /**
     * All fields constructor
     */
    inline  T_usb_tcu_Channel_Info (bool u8ResumeDownload_, uint16 u16ChannelID_, uint8 u8ChannelContentID_);

    /**
     * Destructor
     */
    inline  ~T_usb_tcu_Channel_Info();

    /**
     * Assignment operator
     */
    inline T_usb_tcu_Channel_Info& operator = (const T_usb_tcu_Channel_Info& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_usb_tcu_Channel_Info& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_usb_tcu_Channel_Info& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_usb_tcu_Channel_Info& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_usb_tcu_Channel_Info& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8ResumeDownload"

    static const int kU8ResumeDownload = 0;

    /**
     * Clears the field "u8ResumeDownload".
     *
     * The field will be set to its default value. The hasU8ResumeDownload()
     * method will return false.
     */
    inline void clearU8ResumeDownload();

    /**
     * Checks whether the field "u8ResumeDownload" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8ResumeDownload()). Otherwise it will return false.
     */
    inline bool hasU8ResumeDownload () const;

    /**
     * Returns the value of the member "u8ResumeDownload".
     *
     * This is used for resuming download.
     *
     * @return The value of the field "u8ResumeDownload"
     */
    inline bool getU8ResumeDownload () const;

    /**
     * Sets the value of the member "u8ResumeDownload".
     *
     * This is used for resuming download.
     *
     * @param u8ResumeDownload The value which will be set
     */
    inline void setU8ResumeDownload (bool u8ResumeDownload_);

    // API of field "u16ChannelID"

    static const int kU16ChannelID = 1;

    /**
     * Clears the field "u16ChannelID".
     *
     * The field will be set to its default value. The hasU16ChannelID()
     * method will return false.
     */
    inline void clearU16ChannelID();

    /**
     * Checks whether the field "u16ChannelID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ChannelID()). Otherwise it will return false.
     */
    inline bool hasU16ChannelID () const;

    /**
     * Returns the value of the member "u16ChannelID".
     *
     * Channel ID.
     *
     * @return The value of the field "u16ChannelID"
     */
    inline uint16 getU16ChannelID () const;

    /**
     * Sets the value of the member "u16ChannelID".
     *
     * Channel ID.
     *
     * @param u16ChannelID The value which will be set
     */
    inline void setU16ChannelID (uint16 u16ChannelID_);

    // API of field "u8ChannelContentID"

    static const int kU8ChannelContentID = 2;

    /**
     * Clears the field "u8ChannelContentID".
     *
     * The field will be set to its default value. The hasU8ChannelContentID()
     * method will return false.
     */
    inline void clearU8ChannelContentID();

    /**
     * Checks whether the field "u8ChannelContentID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8ChannelContentID()). Otherwise it will return false.
     */
    inline bool hasU8ChannelContentID () const;

    /**
     * Returns the value of the member "u8ChannelContentID".
     *
     * Channel Content ID.
     *
     * @return The value of the field "u8ChannelContentID"
     */
    inline uint8 getU8ChannelContentID () const;

    /**
     * Sets the value of the member "u8ChannelContentID".
     *
     * Channel Content ID.
     *
     * @param u8ChannelContentID The value which will be set
     */
    inline void setU8ChannelContentID (uint8 u8ChannelContentID_);

    static const T_usb_tcu_Channel_Info &getDefaultInstance();

private:

    inline void set_has_u8ResumeDownload ();

    inline void clear_has_u8ResumeDownload ();

    inline void set_has_u16ChannelID ();

    inline void clear_has_u16ChannelID ();

    inline void set_has_u8ChannelContentID ();

    inline void clear_has_u8ChannelContentID ();

    uint32 _has_bits_[ (3 + 31) / 32];

    bool _u8ResumeDownload;

    uint16 _u16ChannelID;

    uint8 _u8ChannelContentID;

};

/**
 * Number of folder definition information and channel definition information
 */
class T_usb_tcu_channel_master_data_header {
public:

    /**
     * Default constructor
     */
    inline  T_usb_tcu_channel_master_data_header ();

    /**
     * Copy constructor
     */
    inline  T_usb_tcu_channel_master_data_header (const T_usb_tcu_channel_master_data_header &rhs);

    /**
     * All fields constructor
     */
    inline  T_usb_tcu_channel_master_data_header (uint16 u16NumOfChannelDefInfo_, uint8 u8NumOfFolderDefInfo_);

    /**
     * Destructor
     */
    inline  ~T_usb_tcu_channel_master_data_header();

    /**
     * Assignment operator
     */
    inline T_usb_tcu_channel_master_data_header& operator = (const T_usb_tcu_channel_master_data_header& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_usb_tcu_channel_master_data_header& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_usb_tcu_channel_master_data_header& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_usb_tcu_channel_master_data_header& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_usb_tcu_channel_master_data_header& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16NumOfChannelDefInfo"

    static const int kU16NumOfChannelDefInfo = 0;

    /**
     * Clears the field "u16NumOfChannelDefInfo".
     *
     * The field will be set to its default value. The hasU16NumOfChannelDefInfo()
     * method will return false.
     */
    inline void clearU16NumOfChannelDefInfo();

    /**
     * Checks whether the field "u16NumOfChannelDefInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16NumOfChannelDefInfo()). Otherwise it will return false.
     */
    inline bool hasU16NumOfChannelDefInfo () const;

    /**
     * Returns the value of the member "u16NumOfChannelDefInfo".
     *
     * Number of channel definition information included in data record part
     *
     * @return The value of the field "u16NumOfChannelDefInfo"
     */
    inline uint16 getU16NumOfChannelDefInfo () const;

    /**
     * Sets the value of the member "u16NumOfChannelDefInfo".
     *
     * Number of channel definition information included in data record part
     *
     * @param u16NumOfChannelDefInfo The value which will be set
     */
    inline void setU16NumOfChannelDefInfo (uint16 u16NumOfChannelDefInfo_);

    // API of field "u8NumOfFolderDefInfo"

    static const int kU8NumOfFolderDefInfo = 1;

    /**
     * Clears the field "u8NumOfFolderDefInfo".
     *
     * The field will be set to its default value. The hasU8NumOfFolderDefInfo()
     * method will return false.
     */
    inline void clearU8NumOfFolderDefInfo();

    /**
     * Checks whether the field "u8NumOfFolderDefInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8NumOfFolderDefInfo()). Otherwise it will return false.
     */
    inline bool hasU8NumOfFolderDefInfo () const;

    /**
     * Returns the value of the member "u8NumOfFolderDefInfo".
     *
     * Number of folder definition information included in data record part
     *
     * @return The value of the field "u8NumOfFolderDefInfo"
     */
    inline uint8 getU8NumOfFolderDefInfo () const;

    /**
     * Sets the value of the member "u8NumOfFolderDefInfo".
     *
     * Number of folder definition information included in data record part
     *
     * @param u8NumOfFolderDefInfo The value which will be set
     */
    inline void setU8NumOfFolderDefInfo (uint8 u8NumOfFolderDefInfo_);

    static const T_usb_tcu_channel_master_data_header &getDefaultInstance();

private:

    inline void set_has_u16NumOfChannelDefInfo ();

    inline void clear_has_u16NumOfChannelDefInfo ();

    inline void set_has_u8NumOfFolderDefInfo ();

    inline void clear_has_u8NumOfFolderDefInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _u16NumOfChannelDefInfo;

    uint8 _u8NumOfFolderDefInfo;

};

/**
 * Folder definition information
 */
class T_usb_tcu_Folder_definition_information {
public:

    /**
     * Default constructor
     */
    inline  T_usb_tcu_Folder_definition_information ();

    /**
     * Copy constructor
     */
    inline  T_usb_tcu_Folder_definition_information (const T_usb_tcu_Folder_definition_information &rhs);

    /**
     * All fields constructor
     */
    inline  T_usb_tcu_Folder_definition_information (const ::std::string& strFolderName_, uint16 u16FolderIconID_, uint16 u16FolderID_, uint16 u16SizeOfFolderDefInfo_, uint8 u8FixedData1_, uint8 u8FixedData2_, uint8 u8SizeOfFolderName_);

    /**
     * Destructor
     */
    inline  ~T_usb_tcu_Folder_definition_information();

    /**
     * Assignment operator
     */
    inline T_usb_tcu_Folder_definition_information& operator = (const T_usb_tcu_Folder_definition_information& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_usb_tcu_Folder_definition_information& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_usb_tcu_Folder_definition_information& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_usb_tcu_Folder_definition_information& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_usb_tcu_Folder_definition_information& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "strFolderName"

    static const int kStrFolderName = 0;

    /**
     * Clears the field "strFolderName".
     *
     * The field will be set to its default value. The hasStrFolderName()
     * method will return false.
     */
    inline void clearStrFolderName();

    /**
     * Checks whether the field "strFolderName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrFolderName()). Otherwise it will return false.
     */
    inline bool hasStrFolderName () const;

    /**
     * Returns the value of the member "strFolderName".
     *
     * Name of the folder for display
     *
     * @return The value of the field "strFolderName"
     */
    inline const ::std::string& getStrFolderName () const;

    /**
     * Retrieves the value of the field "strFolderName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strFolderName".
     */
    inline ::std::string& getStrFolderNameMutable ();

    /**
     * Sets the value of the member "strFolderName".
     *
     * Name of the folder for display
     *
     * @param strFolderName The value which will be set
     */
    inline void setStrFolderName (const ::std::string& strFolderName_);

    /**
     * Sets the value of the member "strFolderName".
     *
     * Name of the folder for display
     *
     * @param strFolderName The value which will be set
     */
    inline void setStrFolderName (const char* strFolderName_);

    /**
     * Sets the value of the member "strFolderName".
     *
     * Name of the folder for display
     *
     * @param strFolderName The value which will be set
     */
    inline void setStrFolderName (const char* value, size_t size);

    // API of field "u16FolderIconID"

    static const int kU16FolderIconID = 1;

    /**
     * Clears the field "u16FolderIconID".
     *
     * The field will be set to its default value. The hasU16FolderIconID()
     * method will return false.
     */
    inline void clearU16FolderIconID();

    /**
     * Checks whether the field "u16FolderIconID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16FolderIconID()). Otherwise it will return false.
     */
    inline bool hasU16FolderIconID () const;

    /**
     * Returns the value of the member "u16FolderIconID".
     *
     * ID of icon for displaying folder
     *
     * @return The value of the field "u16FolderIconID"
     */
    inline uint16 getU16FolderIconID () const;

    /**
     * Sets the value of the member "u16FolderIconID".
     *
     * ID of icon for displaying folder
     *
     * @param u16FolderIconID The value which will be set
     */
    inline void setU16FolderIconID (uint16 u16FolderIconID_);

    // API of field "u16FolderID"

    static const int kU16FolderID = 2;

    /**
     * Clears the field "u16FolderID".
     *
     * The field will be set to its default value. The hasU16FolderID()
     * method will return false.
     */
    inline void clearU16FolderID();

    /**
     * Checks whether the field "u16FolderID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16FolderID()). Otherwise it will return false.
     */
    inline bool hasU16FolderID () const;

    /**
     * Returns the value of the member "u16FolderID".
     *
     * ID of folder
     *
     * @return The value of the field "u16FolderID"
     */
    inline uint16 getU16FolderID () const;

    /**
     * Sets the value of the member "u16FolderID".
     *
     * ID of folder
     *
     * @param u16FolderID The value which will be set
     */
    inline void setU16FolderID (uint16 u16FolderID_);

    // API of field "u16SizeOfFolderDefInfo"

    static const int kU16SizeOfFolderDefInfo = 3;

    /**
     * Clears the field "u16SizeOfFolderDefInfo".
     *
     * The field will be set to its default value. The hasU16SizeOfFolderDefInfo()
     * method will return false.
     */
    inline void clearU16SizeOfFolderDefInfo();

    /**
     * Checks whether the field "u16SizeOfFolderDefInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16SizeOfFolderDefInfo()). Otherwise it will return false.
     */
    inline bool hasU16SizeOfFolderDefInfo () const;

    /**
     * Returns the value of the member "u16SizeOfFolderDefInfo".
     *
     * Total size of the following data
     *
     * @return The value of the field "u16SizeOfFolderDefInfo"
     */
    inline uint16 getU16SizeOfFolderDefInfo () const;

    /**
     * Sets the value of the member "u16SizeOfFolderDefInfo".
     *
     * Total size of the following data
     *
     * @param u16SizeOfFolderDefInfo The value which will be set
     */
    inline void setU16SizeOfFolderDefInfo (uint16 u16SizeOfFolderDefInfo_);

    // API of field "u8FixedData1"

    static const int kU8FixedData1 = 4;

    /**
     * Clears the field "u8FixedData1".
     *
     * The field will be set to its default value. The hasU8FixedData1()
     * method will return false.
     */
    inline void clearU8FixedData1();

    /**
     * Checks whether the field "u8FixedData1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8FixedData1()). Otherwise it will return false.
     */
    inline bool hasU8FixedData1 () const;

    /**
     * Returns the value of the member "u8FixedData1".
     *
     * Fixed value of 0x00
     *
     * @return The value of the field "u8FixedData1"
     */
    inline uint8 getU8FixedData1 () const;

    /**
     * Sets the value of the member "u8FixedData1".
     *
     * Fixed value of 0x00
     *
     * @param u8FixedData1 The value which will be set
     */
    inline void setU8FixedData1 (uint8 u8FixedData1_);

    // API of field "u8FixedData2"

    static const int kU8FixedData2 = 5;

    /**
     * Clears the field "u8FixedData2".
     *
     * The field will be set to its default value. The hasU8FixedData2()
     * method will return false.
     */
    inline void clearU8FixedData2();

    /**
     * Checks whether the field "u8FixedData2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8FixedData2()). Otherwise it will return false.
     */
    inline bool hasU8FixedData2 () const;

    /**
     * Returns the value of the member "u8FixedData2".
     *
     * Fixed value of 0x01
     *
     * @return The value of the field "u8FixedData2"
     */
    inline uint8 getU8FixedData2 () const;

    /**
     * Sets the value of the member "u8FixedData2".
     *
     * Fixed value of 0x01
     *
     * @param u8FixedData2 The value which will be set
     */
    inline void setU8FixedData2 (uint8 u8FixedData2_);

    // API of field "u8SizeOfFolderName"

    static const int kU8SizeOfFolderName = 6;

    /**
     * Clears the field "u8SizeOfFolderName".
     *
     * The field will be set to its default value. The hasU8SizeOfFolderName()
     * method will return false.
     */
    inline void clearU8SizeOfFolderName();

    /**
     * Checks whether the field "u8SizeOfFolderName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SizeOfFolderName()). Otherwise it will return false.
     */
    inline bool hasU8SizeOfFolderName () const;

    /**
     * Returns the value of the member "u8SizeOfFolderName".
     *
     * <p>Max value. 32</p>
     * <p>Size of Folder name</p>
     *
     * @return The value of the field "u8SizeOfFolderName"
     */
    inline uint8 getU8SizeOfFolderName () const;

    /**
     * Sets the value of the member "u8SizeOfFolderName".
     *
     * <p>Max value. 32</p>
     * <p>Size of Folder name</p>
     *
     * @param u8SizeOfFolderName The value which will be set
     */
    inline void setU8SizeOfFolderName (uint8 u8SizeOfFolderName_);

    static const T_usb_tcu_Folder_definition_information &getDefaultInstance();

private:

    inline void set_has_strFolderName ();

    inline void clear_has_strFolderName ();

    inline void set_has_u16FolderIconID ();

    inline void clear_has_u16FolderIconID ();

    inline void set_has_u16FolderID ();

    inline void clear_has_u16FolderID ();

    inline void set_has_u16SizeOfFolderDefInfo ();

    inline void clear_has_u16SizeOfFolderDefInfo ();

    inline void set_has_u8FixedData1 ();

    inline void clear_has_u8FixedData1 ();

    inline void set_has_u8FixedData2 ();

    inline void clear_has_u8FixedData2 ();

    inline void set_has_u8SizeOfFolderName ();

    inline void clear_has_u8SizeOfFolderName ();

    uint32 _has_bits_[ (7 + 31) / 32];

    ::std::string _strFolderName;

    uint16 _u16FolderIconID;

    uint16 _u16FolderID;

    uint16 _u16SizeOfFolderDefInfo;

    uint8 _u8FixedData1;

    uint8 _u8FixedData2;

    uint8 _u8SizeOfFolderName;

};

/**
 * Channel Master Data
 */
class T_usb_tcu_channel_master_data {
public:

    /**
     * Default constructor
     */
    inline  T_usb_tcu_channel_master_data ();

    /**
     * Copy constructor
     */
    inline  T_usb_tcu_channel_master_data (const T_usb_tcu_channel_master_data &rhs);

    /**
     * All fields constructor
     */
    inline  T_usb_tcu_channel_master_data (const T_usb_tcu_channel_master_data_header& ChannelMasterDataHeader_, const ::std::vector< T_usb_tcu_Channel_definition_information >& ChannelDefinitionInformation_, const ::std::vector< T_usb_tcu_Folder_definition_information >& FolderDefinitionInformation_);

    /**
     * Destructor
     */
    inline  ~T_usb_tcu_channel_master_data();

    /**
     * Assignment operator
     */
    inline T_usb_tcu_channel_master_data& operator = (const T_usb_tcu_channel_master_data& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_usb_tcu_channel_master_data& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_usb_tcu_channel_master_data& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_usb_tcu_channel_master_data& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_usb_tcu_channel_master_data& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ChannelMasterDataHeader"

    static const int kChannelMasterDataHeader = 0;

    /**
     * Clears the field "ChannelMasterDataHeader".
     *
     * The field will be set to its default value. The hasChannelMasterDataHeader()
     * method will return false.
     */
    inline void clearChannelMasterDataHeader();

    /**
     * Checks whether the field "ChannelMasterDataHeader" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelMasterDataHeader()). Otherwise it will return false.
     */
    inline bool hasChannelMasterDataHeader () const;

    /**
     * Returns the value of the member "ChannelMasterDataHeader".
     *
     * Number of folder definition information and channel definition information
     *
     * @return The value of the field "ChannelMasterDataHeader"
     */
    inline const T_usb_tcu_channel_master_data_header& getChannelMasterDataHeader () const;

    /**
     * Retrieves the value of the field "ChannelMasterDataHeader" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ChannelMasterDataHeader".
     */
    inline T_usb_tcu_channel_master_data_header& getChannelMasterDataHeaderMutable ();

    /**
     * Sets the value of the member "ChannelMasterDataHeader".
     *
     * Number of folder definition information and channel definition information
     *
     * @param ChannelMasterDataHeader The value which will be set
     */
    inline void setChannelMasterDataHeader (const T_usb_tcu_channel_master_data_header& ChannelMasterDataHeader_);

    // API of field "ChannelDefinitionInformation"

    static const int kChannelDefinitionInformation = 1;

    /**
     * Clears the field "ChannelDefinitionInformation".
     *
     * The field will be set to its default value. The hasChannelDefinitionInformation()
     * method will return false.
     */
    inline void clearChannelDefinitionInformation();

    /**
     * Checks whether the field "ChannelDefinitionInformation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelDefinitionInformation()). Otherwise it will return false.
     */
    inline bool hasChannelDefinitionInformation () const;

    /**
     * Returns the value of the member "ChannelDefinitionInformation".
     *
     * Channel definition information
     *
     * @return The value of the field "ChannelDefinitionInformation"
     */
    inline const ::std::vector< T_usb_tcu_Channel_definition_information >& getChannelDefinitionInformation () const;

    /**
     * Retrieves the value of the field "ChannelDefinitionInformation" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ChannelDefinitionInformation".
     */
    inline ::std::vector< T_usb_tcu_Channel_definition_information >& getChannelDefinitionInformationMutable ();

    /**
     * Sets the value of the member "ChannelDefinitionInformation".
     *
     * Channel definition information
     *
     * @param ChannelDefinitionInformation The value which will be set
     */
    inline void setChannelDefinitionInformation (const ::std::vector< T_usb_tcu_Channel_definition_information >& ChannelDefinitionInformation_);

    // API of field "FolderDefinitionInformation"

    static const int kFolderDefinitionInformation = 2;

    /**
     * Clears the field "FolderDefinitionInformation".
     *
     * The field will be set to its default value. The hasFolderDefinitionInformation()
     * method will return false.
     */
    inline void clearFolderDefinitionInformation();

    /**
     * Checks whether the field "FolderDefinitionInformation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFolderDefinitionInformation()). Otherwise it will return false.
     */
    inline bool hasFolderDefinitionInformation () const;

    /**
     * Returns the value of the member "FolderDefinitionInformation".
     *
     * Folder definition information
     *
     * @return The value of the field "FolderDefinitionInformation"
     */
    inline const ::std::vector< T_usb_tcu_Folder_definition_information >& getFolderDefinitionInformation () const;

    /**
     * Retrieves the value of the field "FolderDefinitionInformation" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "FolderDefinitionInformation".
     */
    inline ::std::vector< T_usb_tcu_Folder_definition_information >& getFolderDefinitionInformationMutable ();

    /**
     * Sets the value of the member "FolderDefinitionInformation".
     *
     * Folder definition information
     *
     * @param FolderDefinitionInformation The value which will be set
     */
    inline void setFolderDefinitionInformation (const ::std::vector< T_usb_tcu_Folder_definition_information >& FolderDefinitionInformation_);

    static const T_usb_tcu_channel_master_data &getDefaultInstance();

private:

    static const ::std::vector< T_usb_tcu_Channel_definition_information >& getT_usb_tcu_Channel_definition_informationList_DefaultInstance ();

    static const ::std::vector< T_usb_tcu_Folder_definition_information >& getT_usb_tcu_Folder_definition_informationList_DefaultInstance ();

    inline void set_has_ChannelMasterDataHeader ();

    inline void clear_has_ChannelMasterDataHeader ();

    inline void set_has_ChannelDefinitionInformation ();

    inline void clear_has_ChannelDefinitionInformation ();

    inline void set_has_FolderDefinitionInformation ();

    inline void clear_has_FolderDefinitionInformation ();

    uint32 _has_bits_[ (3 + 31) / 32];

    T_usb_tcu_channel_master_data_header _ChannelMasterDataHeader;

    ::std::vector< T_usb_tcu_Channel_definition_information > _ChannelDefinitionInformation;

    ::std::vector< T_usb_tcu_Folder_definition_information > _FolderDefinitionInformation;

};

/**
 * If the meaning of "T_usb_tcu_Location" isn't clear, then there should be a description here.
 */
class T_usb_tcu_Location {
public:

    /**
     * Default constructor
     */
    inline  T_usb_tcu_Location ();

    /**
     * Copy constructor
     */
    inline  T_usb_tcu_Location (const T_usb_tcu_Location &rhs);

    /**
     * All fields constructor
     */
    inline  T_usb_tcu_Location (uint16 u16Latitude_second_, uint16 u16Longitude_second_, uint8 u8Direction_, uint8 u8Latitude_degree_, uint8 u8Latitude_minute_, uint8 u8Longitude_Degree_, uint8 u8Longitude_minute_, uint8 u8Reserved_);

    /**
     * Destructor
     */
    inline  ~T_usb_tcu_Location();

    /**
     * Assignment operator
     */
    inline T_usb_tcu_Location& operator = (const T_usb_tcu_Location& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_usb_tcu_Location& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_usb_tcu_Location& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_usb_tcu_Location& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_usb_tcu_Location& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16Latitude_second"

    static const int kU16Latitude_second = 0;

    /**
     * Clears the field "u16Latitude_second".
     *
     * The field will be set to its default value. The hasU16Latitude_second()
     * method will return false.
     */
    inline void clearU16Latitude_second();

    /**
     * Checks whether the field "u16Latitude_second" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16Latitude_second()). Otherwise it will return false.
     */
    inline bool hasU16Latitude_second () const;

    /**
     * Returns the value of the member "u16Latitude_second".
     *
     * Latitude second (2nd and 1st Byte)
     *
     * @return The value of the field "u16Latitude_second"
     */
    inline uint16 getU16Latitude_second () const;

    /**
     * Sets the value of the member "u16Latitude_second".
     *
     * Latitude second (2nd and 1st Byte)
     *
     * @param u16Latitude_second The value which will be set
     */
    inline void setU16Latitude_second (uint16 u16Latitude_second_);

    // API of field "u16Longitude_second"

    static const int kU16Longitude_second = 1;

    /**
     * Clears the field "u16Longitude_second".
     *
     * The field will be set to its default value. The hasU16Longitude_second()
     * method will return false.
     */
    inline void clearU16Longitude_second();

    /**
     * Checks whether the field "u16Longitude_second" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16Longitude_second()). Otherwise it will return false.
     */
    inline bool hasU16Longitude_second () const;

    /**
     * Returns the value of the member "u16Longitude_second".
     *
     * Specifies the Longitude seconds( Second of longitude * 100 (0 - 6000) ) (6th and 5th Byte)
     *
     * @return The value of the field "u16Longitude_second"
     */
    inline uint16 getU16Longitude_second () const;

    /**
     * Sets the value of the member "u16Longitude_second".
     *
     * Specifies the Longitude seconds( Second of longitude * 100 (0 - 6000) ) (6th and 5th Byte)
     *
     * @param u16Longitude_second The value which will be set
     */
    inline void setU16Longitude_second (uint16 u16Longitude_second_);

    // API of field "u8Direction"

    static const int kU8Direction = 2;

    /**
     * Clears the field "u8Direction".
     *
     * The field will be set to its default value. The hasU8Direction()
     * method will return false.
     */
    inline void clearU8Direction();

    /**
     * Checks whether the field "u8Direction" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Direction()). Otherwise it will return false.
     */
    inline bool hasU8Direction () const;

    /**
     * Returns the value of the member "u8Direction".
     *
     * 10th Byte of the location which contains FixedData, LongitudeType, LatitudeType and reserved bits. (10th, 9th, 8th and 7th byte of 10 byte Location Data)
     *
     * @return The value of the field "u8Direction"
     */
    inline uint8 getU8Direction () const;

    /**
     * Sets the value of the member "u8Direction".
     *
     * 10th Byte of the location which contains FixedData, LongitudeType, LatitudeType and reserved bits. (10th, 9th, 8th and 7th byte of 10 byte Location Data)
     *
     * @param u8Direction The value which will be set
     */
    inline void setU8Direction (uint8 u8Direction_);

    // API of field "u8Latitude_degree"

    static const int kU8Latitude_degree = 3;

    /**
     * Clears the field "u8Latitude_degree".
     *
     * The field will be set to its default value. The hasU8Latitude_degree()
     * method will return false.
     */
    inline void clearU8Latitude_degree();

    /**
     * Checks whether the field "u8Latitude_degree" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Latitude_degree()). Otherwise it will return false.
     */
    inline bool hasU8Latitude_degree () const;

    /**
     * Returns the value of the member "u8Latitude_degree".
     *
     * Latitude degree (4th Byte)
     *
     * @return The value of the field "u8Latitude_degree"
     */
    inline uint8 getU8Latitude_degree () const;

    /**
     * Sets the value of the member "u8Latitude_degree".
     *
     * Latitude degree (4th Byte)
     *
     * @param u8Latitude_degree The value which will be set
     */
    inline void setU8Latitude_degree (uint8 u8Latitude_degree_);

    // API of field "u8Latitude_minute"

    static const int kU8Latitude_minute = 4;

    /**
     * Clears the field "u8Latitude_minute".
     *
     * The field will be set to its default value. The hasU8Latitude_minute()
     * method will return false.
     */
    inline void clearU8Latitude_minute();

    /**
     * Checks whether the field "u8Latitude_minute" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Latitude_minute()). Otherwise it will return false.
     */
    inline bool hasU8Latitude_minute () const;

    /**
     * Returns the value of the member "u8Latitude_minute".
     *
     * Latitude minute (3rd Byte)
     *
     * @return The value of the field "u8Latitude_minute"
     */
    inline uint8 getU8Latitude_minute () const;

    /**
     * Sets the value of the member "u8Latitude_minute".
     *
     * Latitude minute (3rd Byte)
     *
     * @param u8Latitude_minute The value which will be set
     */
    inline void setU8Latitude_minute (uint8 u8Latitude_minute_);

    // API of field "u8Longitude_Degree"

    static const int kU8Longitude_Degree = 5;

    /**
     * Clears the field "u8Longitude_Degree".
     *
     * The field will be set to its default value. The hasU8Longitude_Degree()
     * method will return false.
     */
    inline void clearU8Longitude_Degree();

    /**
     * Checks whether the field "u8Longitude_Degree" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Longitude_Degree()). Otherwise it will return false.
     */
    inline bool hasU8Longitude_Degree () const;

    /**
     * Returns the value of the member "u8Longitude_Degree".
     *
     * Longitude degree (8th Byte)
     *
     * @return The value of the field "u8Longitude_Degree"
     */
    inline uint8 getU8Longitude_Degree () const;

    /**
     * Sets the value of the member "u8Longitude_Degree".
     *
     * Longitude degree (8th Byte)
     *
     * @param u8Longitude_Degree The value which will be set
     */
    inline void setU8Longitude_Degree (uint8 u8Longitude_Degree_);

    // API of field "u8Longitude_minute"

    static const int kU8Longitude_minute = 6;

    /**
     * Clears the field "u8Longitude_minute".
     *
     * The field will be set to its default value. The hasU8Longitude_minute()
     * method will return false.
     */
    inline void clearU8Longitude_minute();

    /**
     * Checks whether the field "u8Longitude_minute" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Longitude_minute()). Otherwise it will return false.
     */
    inline bool hasU8Longitude_minute () const;

    /**
     * Returns the value of the member "u8Longitude_minute".
     *
     * Longitude minutes (7th Byte)
     *
     * @return The value of the field "u8Longitude_minute"
     */
    inline uint8 getU8Longitude_minute () const;

    /**
     * Sets the value of the member "u8Longitude_minute".
     *
     * Longitude minutes (7th Byte)
     *
     * @param u8Longitude_minute The value which will be set
     */
    inline void setU8Longitude_minute (uint8 u8Longitude_minute_);

    // API of field "u8Reserved"

    static const int kU8Reserved = 7;

    /**
     * Clears the field "u8Reserved".
     *
     * The field will be set to its default value. The hasU8Reserved()
     * method will return false.
     */
    inline void clearU8Reserved();

    /**
     * Checks whether the field "u8Reserved" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Reserved()). Otherwise it will return false.
     */
    inline bool hasU8Reserved () const;

    /**
     * Returns the value of the member "u8Reserved".
     *
     * Reserved (9th Byte)
     *
     * @return The value of the field "u8Reserved"
     */
    inline uint8 getU8Reserved () const;

    /**
     * Sets the value of the member "u8Reserved".
     *
     * Reserved (9th Byte)
     *
     * @param u8Reserved The value which will be set
     */
    inline void setU8Reserved (uint8 u8Reserved_);

    static const T_usb_tcu_Location &getDefaultInstance();

private:

    inline void set_has_u16Latitude_second ();

    inline void clear_has_u16Latitude_second ();

    inline void set_has_u16Longitude_second ();

    inline void clear_has_u16Longitude_second ();

    inline void set_has_u8Direction ();

    inline void clear_has_u8Direction ();

    inline void set_has_u8Latitude_degree ();

    inline void clear_has_u8Latitude_degree ();

    inline void set_has_u8Latitude_minute ();

    inline void clear_has_u8Latitude_minute ();

    inline void set_has_u8Longitude_Degree ();

    inline void clear_has_u8Longitude_Degree ();

    inline void set_has_u8Longitude_minute ();

    inline void clear_has_u8Longitude_minute ();

    inline void set_has_u8Reserved ();

    inline void clear_has_u8Reserved ();

    uint32 _has_bits_[ (8 + 31) / 32];

    uint16 _u16Latitude_second;

    uint16 _u16Longitude_second;

    uint8 _u8Direction;

    uint8 _u8Latitude_degree;

    uint8 _u8Latitude_minute;

    uint8 _u8Longitude_Degree;

    uint8 _u8Longitude_minute;

    uint8 _u8Reserved;

};

/**
 * If the meaning of "T_usb_tcu_Data_Record" isn't clear, then there should be a description here.
 */
class T_usb_tcu_Data_Record {
public:

    /**
     * Default constructor
     */
    inline  T_usb_tcu_Data_Record ();

    /**
     * Copy constructor
     */
    inline  T_usb_tcu_Data_Record (const T_usb_tcu_Data_Record &rhs);

    /**
     * All fields constructor
     */
    inline  T_usb_tcu_Data_Record (const T_usb_tcu_Location& Location_, const ::std::string& strAddress_, const ::std::string& strCategory_, const ::std::string& strPhoneNumber_, const ::std::string& strPhoneNumberForDisp_, const ::std::string& strPOIName_, uint8 u8SizeOfAddress_, uint8 u8SizeOfCategory_, uint8 u8SizeOfPhoneNumber_, uint8 u8SizeOfPhoneNumberForDisp_, uint8 u8SizeOfPOIName_);

    /**
     * Destructor
     */
    inline  ~T_usb_tcu_Data_Record();

    /**
     * Assignment operator
     */
    inline T_usb_tcu_Data_Record& operator = (const T_usb_tcu_Data_Record& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_usb_tcu_Data_Record& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_usb_tcu_Data_Record& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_usb_tcu_Data_Record& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_usb_tcu_Data_Record& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Location"

    static const int kLocation = 0;

    /**
     * Clears the field "Location".
     *
     * The field will be set to its default value. The hasLocation()
     * method will return false.
     */
    inline void clearLocation();

    /**
     * Checks whether the field "Location" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLocation()). Otherwise it will return false.
     */
    inline bool hasLocation () const;

    /**
     * Returns the value of the member "Location".
     *
     * The Location details consists of 10 byte data
     *
     * @return The value of the field "Location"
     */
    inline const T_usb_tcu_Location& getLocation () const;

    /**
     * Retrieves the value of the field "Location" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Location".
     */
    inline T_usb_tcu_Location& getLocationMutable ();

    /**
     * Sets the value of the member "Location".
     *
     * The Location details consists of 10 byte data
     *
     * @param Location The value which will be set
     */
    inline void setLocation (const T_usb_tcu_Location& Location_);

    // API of field "strAddress"

    static const int kStrAddress = 1;

    /**
     * Clears the field "strAddress".
     *
     * The field will be set to its default value. The hasStrAddress()
     * method will return false.
     */
    inline void clearStrAddress();

    /**
     * Checks whether the field "strAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrAddress()). Otherwise it will return false.
     */
    inline bool hasStrAddress () const;

    /**
     * Returns the value of the member "strAddress".
     *
     * Address information
     *
     * @return The value of the field "strAddress"
     */
    inline const ::std::string& getStrAddress () const;

    /**
     * Retrieves the value of the field "strAddress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strAddress".
     */
    inline ::std::string& getStrAddressMutable ();

    /**
     * Sets the value of the member "strAddress".
     *
     * Address information
     *
     * @param strAddress The value which will be set
     */
    inline void setStrAddress (const ::std::string& strAddress_);

    /**
     * Sets the value of the member "strAddress".
     *
     * Address information
     *
     * @param strAddress The value which will be set
     */
    inline void setStrAddress (const char* strAddress_);

    /**
     * Sets the value of the member "strAddress".
     *
     * Address information
     *
     * @param strAddress The value which will be set
     */
    inline void setStrAddress (const char* value, size_t size);

    // API of field "strCategory"

    static const int kStrCategory = 2;

    /**
     * Clears the field "strCategory".
     *
     * The field will be set to its default value. The hasStrCategory()
     * method will return false.
     */
    inline void clearStrCategory();

    /**
     * Checks whether the field "strCategory" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrCategory()). Otherwise it will return false.
     */
    inline bool hasStrCategory () const;

    /**
     * Returns the value of the member "strCategory".
     *
     * Category information
     *
     * @return The value of the field "strCategory"
     */
    inline const ::std::string& getStrCategory () const;

    /**
     * Retrieves the value of the field "strCategory" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strCategory".
     */
    inline ::std::string& getStrCategoryMutable ();

    /**
     * Sets the value of the member "strCategory".
     *
     * Category information
     *
     * @param strCategory The value which will be set
     */
    inline void setStrCategory (const ::std::string& strCategory_);

    /**
     * Sets the value of the member "strCategory".
     *
     * Category information
     *
     * @param strCategory The value which will be set
     */
    inline void setStrCategory (const char* strCategory_);

    /**
     * Sets the value of the member "strCategory".
     *
     * Category information
     *
     * @param strCategory The value which will be set
     */
    inline void setStrCategory (const char* value, size_t size);

    // API of field "strPhoneNumber"

    static const int kStrPhoneNumber = 3;

    /**
     * Clears the field "strPhoneNumber".
     *
     * The field will be set to its default value. The hasStrPhoneNumber()
     * method will return false.
     */
    inline void clearStrPhoneNumber();

    /**
     * Checks whether the field "strPhoneNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrPhoneNumber()). Otherwise it will return false.
     */
    inline bool hasStrPhoneNumber () const;

    /**
     * Returns the value of the member "strPhoneNumber".
     *
     * Phone number
     *
     * @return The value of the field "strPhoneNumber"
     */
    inline const ::std::string& getStrPhoneNumber () const;

    /**
     * Retrieves the value of the field "strPhoneNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strPhoneNumber".
     */
    inline ::std::string& getStrPhoneNumberMutable ();

    /**
     * Sets the value of the member "strPhoneNumber".
     *
     * Phone number
     *
     * @param strPhoneNumber The value which will be set
     */
    inline void setStrPhoneNumber (const ::std::string& strPhoneNumber_);

    /**
     * Sets the value of the member "strPhoneNumber".
     *
     * Phone number
     *
     * @param strPhoneNumber The value which will be set
     */
    inline void setStrPhoneNumber (const char* strPhoneNumber_);

    /**
     * Sets the value of the member "strPhoneNumber".
     *
     * Phone number
     *
     * @param strPhoneNumber The value which will be set
     */
    inline void setStrPhoneNumber (const char* value, size_t size);

    // API of field "strPhoneNumberForDisp"

    static const int kStrPhoneNumberForDisp = 4;

    /**
     * Clears the field "strPhoneNumberForDisp".
     *
     * The field will be set to its default value. The hasStrPhoneNumberForDisp()
     * method will return false.
     */
    inline void clearStrPhoneNumberForDisp();

    /**
     * Checks whether the field "strPhoneNumberForDisp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrPhoneNumberForDisp()). Otherwise it will return false.
     */
    inline bool hasStrPhoneNumberForDisp () const;

    /**
     * Returns the value of the member "strPhoneNumberForDisp".
     *
     * Phone number for display
     *
     * @return The value of the field "strPhoneNumberForDisp"
     */
    inline const ::std::string& getStrPhoneNumberForDisp () const;

    /**
     * Retrieves the value of the field "strPhoneNumberForDisp" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strPhoneNumberForDisp".
     */
    inline ::std::string& getStrPhoneNumberForDispMutable ();

    /**
     * Sets the value of the member "strPhoneNumberForDisp".
     *
     * Phone number for display
     *
     * @param strPhoneNumberForDisp The value which will be set
     */
    inline void setStrPhoneNumberForDisp (const ::std::string& strPhoneNumberForDisp_);

    /**
     * Sets the value of the member "strPhoneNumberForDisp".
     *
     * Phone number for display
     *
     * @param strPhoneNumberForDisp The value which will be set
     */
    inline void setStrPhoneNumberForDisp (const char* strPhoneNumberForDisp_);

    /**
     * Sets the value of the member "strPhoneNumberForDisp".
     *
     * Phone number for display
     *
     * @param strPhoneNumberForDisp The value which will be set
     */
    inline void setStrPhoneNumberForDisp (const char* value, size_t size);

    // API of field "strPOIName"

    static const int kStrPOIName = 5;

    /**
     * Clears the field "strPOIName".
     *
     * The field will be set to its default value. The hasStrPOIName()
     * method will return false.
     */
    inline void clearStrPOIName();

    /**
     * Checks whether the field "strPOIName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrPOIName()). Otherwise it will return false.
     */
    inline bool hasStrPOIName () const;

    /**
     * Returns the value of the member "strPOIName".
     *
     * POI Name
     *
     * @return The value of the field "strPOIName"
     */
    inline const ::std::string& getStrPOIName () const;

    /**
     * Retrieves the value of the field "strPOIName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strPOIName".
     */
    inline ::std::string& getStrPOINameMutable ();

    /**
     * Sets the value of the member "strPOIName".
     *
     * POI Name
     *
     * @param strPOIName The value which will be set
     */
    inline void setStrPOIName (const ::std::string& strPOIName_);

    /**
     * Sets the value of the member "strPOIName".
     *
     * POI Name
     *
     * @param strPOIName The value which will be set
     */
    inline void setStrPOIName (const char* strPOIName_);

    /**
     * Sets the value of the member "strPOIName".
     *
     * POI Name
     *
     * @param strPOIName The value which will be set
     */
    inline void setStrPOIName (const char* value, size_t size);

    // API of field "u8SizeOfAddress"

    static const int kU8SizeOfAddress = 6;

    /**
     * Clears the field "u8SizeOfAddress".
     *
     * The field will be set to its default value. The hasU8SizeOfAddress()
     * method will return false.
     */
    inline void clearU8SizeOfAddress();

    /**
     * Checks whether the field "u8SizeOfAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SizeOfAddress()). Otherwise it will return false.
     */
    inline bool hasU8SizeOfAddress () const;

    /**
     * Returns the value of the member "u8SizeOfAddress".
     *
     * Size of address
     *
     * @return The value of the field "u8SizeOfAddress"
     */
    inline uint8 getU8SizeOfAddress () const;

    /**
     * Sets the value of the member "u8SizeOfAddress".
     *
     * Size of address
     *
     * @param u8SizeOfAddress The value which will be set
     */
    inline void setU8SizeOfAddress (uint8 u8SizeOfAddress_);

    // API of field "u8SizeOfCategory"

    static const int kU8SizeOfCategory = 7;

    /**
     * Clears the field "u8SizeOfCategory".
     *
     * The field will be set to its default value. The hasU8SizeOfCategory()
     * method will return false.
     */
    inline void clearU8SizeOfCategory();

    /**
     * Checks whether the field "u8SizeOfCategory" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SizeOfCategory()). Otherwise it will return false.
     */
    inline bool hasU8SizeOfCategory () const;

    /**
     * Returns the value of the member "u8SizeOfCategory".
     *
     * Size of the category
     *
     * @return The value of the field "u8SizeOfCategory"
     */
    inline uint8 getU8SizeOfCategory () const;

    /**
     * Sets the value of the member "u8SizeOfCategory".
     *
     * Size of the category
     *
     * @param u8SizeOfCategory The value which will be set
     */
    inline void setU8SizeOfCategory (uint8 u8SizeOfCategory_);

    // API of field "u8SizeOfPhoneNumber"

    static const int kU8SizeOfPhoneNumber = 8;

    /**
     * Clears the field "u8SizeOfPhoneNumber".
     *
     * The field will be set to its default value. The hasU8SizeOfPhoneNumber()
     * method will return false.
     */
    inline void clearU8SizeOfPhoneNumber();

    /**
     * Checks whether the field "u8SizeOfPhoneNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SizeOfPhoneNumber()). Otherwise it will return false.
     */
    inline bool hasU8SizeOfPhoneNumber () const;

    /**
     * Returns the value of the member "u8SizeOfPhoneNumber".
     *
     * Size of the phone number
     *
     * @return The value of the field "u8SizeOfPhoneNumber"
     */
    inline uint8 getU8SizeOfPhoneNumber () const;

    /**
     * Sets the value of the member "u8SizeOfPhoneNumber".
     *
     * Size of the phone number
     *
     * @param u8SizeOfPhoneNumber The value which will be set
     */
    inline void setU8SizeOfPhoneNumber (uint8 u8SizeOfPhoneNumber_);

    // API of field "u8SizeOfPhoneNumberForDisp"

    static const int kU8SizeOfPhoneNumberForDisp = 9;

    /**
     * Clears the field "u8SizeOfPhoneNumberForDisp".
     *
     * The field will be set to its default value. The hasU8SizeOfPhoneNumberForDisp()
     * method will return false.
     */
    inline void clearU8SizeOfPhoneNumberForDisp();

    /**
     * Checks whether the field "u8SizeOfPhoneNumberForDisp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SizeOfPhoneNumberForDisp()). Otherwise it will return false.
     */
    inline bool hasU8SizeOfPhoneNumberForDisp () const;

    /**
     * Returns the value of the member "u8SizeOfPhoneNumberForDisp".
     *
     * Phone number for display
     *
     * @return The value of the field "u8SizeOfPhoneNumberForDisp"
     */
    inline uint8 getU8SizeOfPhoneNumberForDisp () const;

    /**
     * Sets the value of the member "u8SizeOfPhoneNumberForDisp".
     *
     * Phone number for display
     *
     * @param u8SizeOfPhoneNumberForDisp The value which will be set
     */
    inline void setU8SizeOfPhoneNumberForDisp (uint8 u8SizeOfPhoneNumberForDisp_);

    // API of field "u8SizeOfPOIName"

    static const int kU8SizeOfPOIName = 10;

    /**
     * Clears the field "u8SizeOfPOIName".
     *
     * The field will be set to its default value. The hasU8SizeOfPOIName()
     * method will return false.
     */
    inline void clearU8SizeOfPOIName();

    /**
     * Checks whether the field "u8SizeOfPOIName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SizeOfPOIName()). Otherwise it will return false.
     */
    inline bool hasU8SizeOfPOIName () const;

    /**
     * Returns the value of the member "u8SizeOfPOIName".
     *
     * Size of the POI name
     *
     * @return The value of the field "u8SizeOfPOIName"
     */
    inline uint8 getU8SizeOfPOIName () const;

    /**
     * Sets the value of the member "u8SizeOfPOIName".
     *
     * Size of the POI name
     *
     * @param u8SizeOfPOIName The value which will be set
     */
    inline void setU8SizeOfPOIName (uint8 u8SizeOfPOIName_);

    static const T_usb_tcu_Data_Record &getDefaultInstance();

private:

    inline void set_has_Location ();

    inline void clear_has_Location ();

    inline void set_has_strAddress ();

    inline void clear_has_strAddress ();

    inline void set_has_strCategory ();

    inline void clear_has_strCategory ();

    inline void set_has_strPhoneNumber ();

    inline void clear_has_strPhoneNumber ();

    inline void set_has_strPhoneNumberForDisp ();

    inline void clear_has_strPhoneNumberForDisp ();

    inline void set_has_strPOIName ();

    inline void clear_has_strPOIName ();

    inline void set_has_u8SizeOfAddress ();

    inline void clear_has_u8SizeOfAddress ();

    inline void set_has_u8SizeOfCategory ();

    inline void clear_has_u8SizeOfCategory ();

    inline void set_has_u8SizeOfPhoneNumber ();

    inline void clear_has_u8SizeOfPhoneNumber ();

    inline void set_has_u8SizeOfPhoneNumberForDisp ();

    inline void clear_has_u8SizeOfPhoneNumberForDisp ();

    inline void set_has_u8SizeOfPOIName ();

    inline void clear_has_u8SizeOfPOIName ();

    uint32 _has_bits_[ (11 + 31) / 32];

    T_usb_tcu_Location _Location;

    ::std::string _strAddress;

    ::std::string _strCategory;

    ::std::string _strPhoneNumber;

    ::std::string _strPhoneNumberForDisp;

    ::std::string _strPOIName;

    uint8 _u8SizeOfAddress;

    uint8 _u8SizeOfCategory;

    uint8 _u8SizeOfPhoneNumber;

    uint8 _u8SizeOfPhoneNumberForDisp;

    uint8 _u8SizeOfPOIName;

};

/**
 * If the meaning of "T_usb_tcu_connected_search_result" isn't clear, then there should be a description here.
 */
class T_usb_tcu_connected_search_result {
public:

    /**
     * Default constructor
     */
    inline  T_usb_tcu_connected_search_result ();

    /**
     * Copy constructor
     */
    inline  T_usb_tcu_connected_search_result (const T_usb_tcu_connected_search_result &rhs);

    /**
     * All fields constructor
     */
    inline  T_usb_tcu_connected_search_result (uint8 u8NumOfPOI_, const ::std::vector< T_usb_tcu_Data_Record >& DataRecord_);

    /**
     * Destructor
     */
    inline  ~T_usb_tcu_connected_search_result();

    /**
     * Assignment operator
     */
    inline T_usb_tcu_connected_search_result& operator = (const T_usb_tcu_connected_search_result& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_usb_tcu_connected_search_result& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_usb_tcu_connected_search_result& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_usb_tcu_connected_search_result& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_usb_tcu_connected_search_result& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8NumOfPOI"

    static const int kU8NumOfPOI = 0;

    /**
     * Clears the field "u8NumOfPOI".
     *
     * The field will be set to its default value. The hasU8NumOfPOI()
     * method will return false.
     */
    inline void clearU8NumOfPOI();

    /**
     * Checks whether the field "u8NumOfPOI" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8NumOfPOI()). Otherwise it will return false.
     */
    inline bool hasU8NumOfPOI () const;

    /**
     * Returns the value of the member "u8NumOfPOI".
     *
     * Number of POI
     *
     * @return The value of the field "u8NumOfPOI"
     */
    inline uint8 getU8NumOfPOI () const;

    /**
     * Sets the value of the member "u8NumOfPOI".
     *
     * Number of POI
     *
     * @param u8NumOfPOI The value which will be set
     */
    inline void setU8NumOfPOI (uint8 u8NumOfPOI_);

    // API of field "DataRecord"

    static const int kDataRecord = 1;

    /**
     * Clears the field "DataRecord".
     *
     * The field will be set to its default value. The hasDataRecord()
     * method will return false.
     */
    inline void clearDataRecord();

    /**
     * Checks whether the field "DataRecord" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDataRecord()). Otherwise it will return false.
     */
    inline bool hasDataRecord () const;

    /**
     * Returns the value of the member "DataRecord".
     *
     * Contains POI details
     *
     * @return The value of the field "DataRecord"
     */
    inline const ::std::vector< T_usb_tcu_Data_Record >& getDataRecord () const;

    /**
     * Retrieves the value of the field "DataRecord" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DataRecord".
     */
    inline ::std::vector< T_usb_tcu_Data_Record >& getDataRecordMutable ();

    /**
     * Sets the value of the member "DataRecord".
     *
     * Contains POI details
     *
     * @param DataRecord The value which will be set
     */
    inline void setDataRecord (const ::std::vector< T_usb_tcu_Data_Record >& DataRecord_);

    static const T_usb_tcu_connected_search_result &getDefaultInstance();

private:

    static const ::std::vector< T_usb_tcu_Data_Record >& getT_usb_tcu_Data_RecordList_DefaultInstance ();

    inline void set_has_u8NumOfPOI ();

    inline void clear_has_u8NumOfPOI ();

    inline void set_has_DataRecord ();

    inline void clear_has_DataRecord ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8NumOfPOI;

    ::std::vector< T_usb_tcu_Data_Record > _DataRecord;

};

/**
 * If the meaning of "T_usb_tcu_Data_Header_Part" isn't clear, then there should be a description here.
 */
class T_usb_tcu_Data_Header_Part {
public:

    /**
     * Default constructor
     */
    inline  T_usb_tcu_Data_Header_Part ();

    /**
     * Copy constructor
     */
    inline  T_usb_tcu_Data_Header_Part (const T_usb_tcu_Data_Header_Part &rhs);

    /**
     * All fields constructor
     */
    inline  T_usb_tcu_Data_Header_Part (uint8 u8NumOfPOI_);

    /**
     * Destructor
     */
    inline  ~T_usb_tcu_Data_Header_Part();

    /**
     * Assignment operator
     */
    inline T_usb_tcu_Data_Header_Part& operator = (const T_usb_tcu_Data_Header_Part& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_usb_tcu_Data_Header_Part& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_usb_tcu_Data_Header_Part& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_usb_tcu_Data_Header_Part& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_usb_tcu_Data_Header_Part& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8NumOfPOI"

    static const int kU8NumOfPOI = 0;

    /**
     * Clears the field "u8NumOfPOI".
     *
     * The field will be set to its default value. The hasU8NumOfPOI()
     * method will return false.
     */
    inline void clearU8NumOfPOI();

    /**
     * Checks whether the field "u8NumOfPOI" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8NumOfPOI()). Otherwise it will return false.
     */
    inline bool hasU8NumOfPOI () const;

    /**
     * Returns the value of the member "u8NumOfPOI".
     *
     * Number of POI
     *
     * @return The value of the field "u8NumOfPOI"
     */
    inline uint8 getU8NumOfPOI () const;

    /**
     * Sets the value of the member "u8NumOfPOI".
     *
     * Number of POI
     *
     * @param u8NumOfPOI The value which will be set
     */
    inline void setU8NumOfPOI (uint8 u8NumOfPOI_);

    static const T_usb_tcu_Data_Header_Part &getDefaultInstance();

private:

    inline void set_has_u8NumOfPOI ();

    inline void clear_has_u8NumOfPOI ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8NumOfPOI;

};

/**
 * If the meaning of "T_usb_tcu_GroupA_Authorization_Info" isn't clear, then there should be a description here.
 */
class T_usb_tcu_GroupA_Authorization_Info {
public:

    /**
     * Default constructor
     */
    inline  T_usb_tcu_GroupA_Authorization_Info ();

    /**
     * Copy constructor
     */
    inline  T_usb_tcu_GroupA_Authorization_Info (const T_usb_tcu_GroupA_Authorization_Info &rhs);

    /**
     * All fields constructor
     */
    inline  T_usb_tcu_GroupA_Authorization_Info (const ::std::string& strNaviID_, const ::std::string& strSimID_, const ::std::string& strVinID_);

    /**
     * Destructor
     */
    inline  ~T_usb_tcu_GroupA_Authorization_Info();

    /**
     * Assignment operator
     */
    inline T_usb_tcu_GroupA_Authorization_Info& operator = (const T_usb_tcu_GroupA_Authorization_Info& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_usb_tcu_GroupA_Authorization_Info& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_usb_tcu_GroupA_Authorization_Info& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_usb_tcu_GroupA_Authorization_Info& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_usb_tcu_GroupA_Authorization_Info& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "strNaviID"

    static const int kStrNaviID = 0;

    /**
     * Clears the field "strNaviID".
     *
     * The field will be set to its default value. The hasStrNaviID()
     * method will return false.
     */
    inline void clearStrNaviID();

    /**
     * Checks whether the field "strNaviID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrNaviID()). Otherwise it will return false.
     */
    inline bool hasStrNaviID () const;

    /**
     * Returns the value of the member "strNaviID".
     *
     * It is a unique number recorded in the IT Master
     *
     * @return The value of the field "strNaviID"
     */
    inline const ::std::string& getStrNaviID () const;

    /**
     * Retrieves the value of the field "strNaviID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strNaviID".
     */
    inline ::std::string& getStrNaviIDMutable ();

    /**
     * Sets the value of the member "strNaviID".
     *
     * It is a unique number recorded in the IT Master
     *
     * @param strNaviID The value which will be set
     */
    inline void setStrNaviID (const ::std::string& strNaviID_);

    /**
     * Sets the value of the member "strNaviID".
     *
     * It is a unique number recorded in the IT Master
     *
     * @param strNaviID The value which will be set
     */
    inline void setStrNaviID (const char* strNaviID_);

    /**
     * Sets the value of the member "strNaviID".
     *
     * It is a unique number recorded in the IT Master
     *
     * @param strNaviID The value which will be set
     */
    inline void setStrNaviID (const char* value, size_t size);

    // API of field "strSimID"

    static const int kStrSimID = 1;

    /**
     * Clears the field "strSimID".
     *
     * The field will be set to its default value. The hasStrSimID()
     * method will return false.
     */
    inline void clearStrSimID();

    /**
     * Checks whether the field "strSimID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrSimID()). Otherwise it will return false.
     */
    inline bool hasStrSimID () const;

    /**
     * Returns the value of the member "strSimID".
     *
     * TCU sim card ID
     *
     * @return The value of the field "strSimID"
     */
    inline const ::std::string& getStrSimID () const;

    /**
     * Retrieves the value of the field "strSimID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strSimID".
     */
    inline ::std::string& getStrSimIDMutable ();

    /**
     * Sets the value of the member "strSimID".
     *
     * TCU sim card ID
     *
     * @param strSimID The value which will be set
     */
    inline void setStrSimID (const ::std::string& strSimID_);

    /**
     * Sets the value of the member "strSimID".
     *
     * TCU sim card ID
     *
     * @param strSimID The value which will be set
     */
    inline void setStrSimID (const char* strSimID_);

    /**
     * Sets the value of the member "strSimID".
     *
     * TCU sim card ID
     *
     * @param strSimID The value which will be set
     */
    inline void setStrSimID (const char* value, size_t size);

    // API of field "strVinID"

    static const int kStrVinID = 2;

    /**
     * Clears the field "strVinID".
     *
     * The field will be set to its default value. The hasStrVinID()
     * method will return false.
     */
    inline void clearStrVinID();

    /**
     * Checks whether the field "strVinID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrVinID()). Otherwise it will return false.
     */
    inline bool hasStrVinID () const;

    /**
     * Returns the value of the member "strVinID".
     *
     * Vehicle Identification Number
     *
     * @return The value of the field "strVinID"
     */
    inline const ::std::string& getStrVinID () const;

    /**
     * Retrieves the value of the field "strVinID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strVinID".
     */
    inline ::std::string& getStrVinIDMutable ();

    /**
     * Sets the value of the member "strVinID".
     *
     * Vehicle Identification Number
     *
     * @param strVinID The value which will be set
     */
    inline void setStrVinID (const ::std::string& strVinID_);

    /**
     * Sets the value of the member "strVinID".
     *
     * Vehicle Identification Number
     *
     * @param strVinID The value which will be set
     */
    inline void setStrVinID (const char* strVinID_);

    /**
     * Sets the value of the member "strVinID".
     *
     * Vehicle Identification Number
     *
     * @param strVinID The value which will be set
     */
    inline void setStrVinID (const char* value, size_t size);

    static const T_usb_tcu_GroupA_Authorization_Info &getDefaultInstance();

private:

    inline void set_has_strNaviID ();

    inline void clear_has_strNaviID ();

    inline void set_has_strSimID ();

    inline void clear_has_strSimID ();

    inline void set_has_strVinID ();

    inline void clear_has_strVinID ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _strNaviID;

    ::std::string _strSimID;

    ::std::string _strVinID;

};

/**
 * If the meaning of "T_usb_tcu_GroupA_BasicServices_Info" isn't clear, then there should be a description here.
 */
class T_usb_tcu_GroupA_BasicServices_Info {
public:

    /**
     * Default constructor
     */
    inline  T_usb_tcu_GroupA_BasicServices_Info ();

    /**
     * Copy constructor
     */
    inline  T_usb_tcu_GroupA_BasicServices_Info (const T_usb_tcu_GroupA_BasicServices_Info &rhs);

    /**
     * All fields constructor
     */
    inline  T_usb_tcu_GroupA_BasicServices_Info (const ::std::string& strDatum_, const ::std::string& strDcmVersion_, const ::std::string& strLanguage_, const ::std::string& strLatitude_, const ::std::string& strLongitude_, const ::std::string& strMapVersion_, const ::std::string& strNaviSWVersion_);

    /**
     * Destructor
     */
    inline  ~T_usb_tcu_GroupA_BasicServices_Info();

    /**
     * Assignment operator
     */
    inline T_usb_tcu_GroupA_BasicServices_Info& operator = (const T_usb_tcu_GroupA_BasicServices_Info& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_usb_tcu_GroupA_BasicServices_Info& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_usb_tcu_GroupA_BasicServices_Info& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_usb_tcu_GroupA_BasicServices_Info& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_usb_tcu_GroupA_BasicServices_Info& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "strDatum"

    static const int kStrDatum = 0;

    /**
     * Clears the field "strDatum".
     *
     * The field will be set to its default value. The hasStrDatum()
     * method will return false.
     */
    inline void clearStrDatum();

    /**
     * Checks whether the field "strDatum" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrDatum()). Otherwise it will return false.
     */
    inline bool hasStrDatum () const;

    /**
     * Returns the value of the member "strDatum".
     *
     * Datum
     *
     * @return The value of the field "strDatum"
     */
    inline const ::std::string& getStrDatum () const;

    /**
     * Retrieves the value of the field "strDatum" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strDatum".
     */
    inline ::std::string& getStrDatumMutable ();

    /**
     * Sets the value of the member "strDatum".
     *
     * Datum
     *
     * @param strDatum The value which will be set
     */
    inline void setStrDatum (const ::std::string& strDatum_);

    /**
     * Sets the value of the member "strDatum".
     *
     * Datum
     *
     * @param strDatum The value which will be set
     */
    inline void setStrDatum (const char* strDatum_);

    /**
     * Sets the value of the member "strDatum".
     *
     * Datum
     *
     * @param strDatum The value which will be set
     */
    inline void setStrDatum (const char* value, size_t size);

    // API of field "strDcmVersion"

    static const int kStrDcmVersion = 1;

    /**
     * Clears the field "strDcmVersion".
     *
     * The field will be set to its default value. The hasStrDcmVersion()
     * method will return false.
     */
    inline void clearStrDcmVersion();

    /**
     * Checks whether the field "strDcmVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrDcmVersion()). Otherwise it will return false.
     */
    inline bool hasStrDcmVersion () const;

    /**
     * Returns the value of the member "strDcmVersion".
     *
     * DCM version
     *
     * @return The value of the field "strDcmVersion"
     */
    inline const ::std::string& getStrDcmVersion () const;

    /**
     * Retrieves the value of the field "strDcmVersion" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strDcmVersion".
     */
    inline ::std::string& getStrDcmVersionMutable ();

    /**
     * Sets the value of the member "strDcmVersion".
     *
     * DCM version
     *
     * @param strDcmVersion The value which will be set
     */
    inline void setStrDcmVersion (const ::std::string& strDcmVersion_);

    /**
     * Sets the value of the member "strDcmVersion".
     *
     * DCM version
     *
     * @param strDcmVersion The value which will be set
     */
    inline void setStrDcmVersion (const char* strDcmVersion_);

    /**
     * Sets the value of the member "strDcmVersion".
     *
     * DCM version
     *
     * @param strDcmVersion The value which will be set
     */
    inline void setStrDcmVersion (const char* value, size_t size);

    // API of field "strLanguage"

    static const int kStrLanguage = 2;

    /**
     * Clears the field "strLanguage".
     *
     * The field will be set to its default value. The hasStrLanguage()
     * method will return false.
     */
    inline void clearStrLanguage();

    /**
     * Checks whether the field "strLanguage" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrLanguage()). Otherwise it will return false.
     */
    inline bool hasStrLanguage () const;

    /**
     * Returns the value of the member "strLanguage".
     *
     * Language
     *
     * @return The value of the field "strLanguage"
     */
    inline const ::std::string& getStrLanguage () const;

    /**
     * Retrieves the value of the field "strLanguage" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strLanguage".
     */
    inline ::std::string& getStrLanguageMutable ();

    /**
     * Sets the value of the member "strLanguage".
     *
     * Language
     *
     * @param strLanguage The value which will be set
     */
    inline void setStrLanguage (const ::std::string& strLanguage_);

    /**
     * Sets the value of the member "strLanguage".
     *
     * Language
     *
     * @param strLanguage The value which will be set
     */
    inline void setStrLanguage (const char* strLanguage_);

    /**
     * Sets the value of the member "strLanguage".
     *
     * Language
     *
     * @param strLanguage The value which will be set
     */
    inline void setStrLanguage (const char* value, size_t size);

    // API of field "strLatitude"

    static const int kStrLatitude = 3;

    /**
     * Clears the field "strLatitude".
     *
     * The field will be set to its default value. The hasStrLatitude()
     * method will return false.
     */
    inline void clearStrLatitude();

    /**
     * Checks whether the field "strLatitude" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrLatitude()). Otherwise it will return false.
     */
    inline bool hasStrLatitude () const;

    /**
     * Returns the value of the member "strLatitude".
     *
     * Latitude information
     *
     * @return The value of the field "strLatitude"
     */
    inline const ::std::string& getStrLatitude () const;

    /**
     * Retrieves the value of the field "strLatitude" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strLatitude".
     */
    inline ::std::string& getStrLatitudeMutable ();

    /**
     * Sets the value of the member "strLatitude".
     *
     * Latitude information
     *
     * @param strLatitude The value which will be set
     */
    inline void setStrLatitude (const ::std::string& strLatitude_);

    /**
     * Sets the value of the member "strLatitude".
     *
     * Latitude information
     *
     * @param strLatitude The value which will be set
     */
    inline void setStrLatitude (const char* strLatitude_);

    /**
     * Sets the value of the member "strLatitude".
     *
     * Latitude information
     *
     * @param strLatitude The value which will be set
     */
    inline void setStrLatitude (const char* value, size_t size);

    // API of field "strLongitude"

    static const int kStrLongitude = 4;

    /**
     * Clears the field "strLongitude".
     *
     * The field will be set to its default value. The hasStrLongitude()
     * method will return false.
     */
    inline void clearStrLongitude();

    /**
     * Checks whether the field "strLongitude" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrLongitude()). Otherwise it will return false.
     */
    inline bool hasStrLongitude () const;

    /**
     * Returns the value of the member "strLongitude".
     *
     * Longitude information
     *
     * @return The value of the field "strLongitude"
     */
    inline const ::std::string& getStrLongitude () const;

    /**
     * Retrieves the value of the field "strLongitude" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strLongitude".
     */
    inline ::std::string& getStrLongitudeMutable ();

    /**
     * Sets the value of the member "strLongitude".
     *
     * Longitude information
     *
     * @param strLongitude The value which will be set
     */
    inline void setStrLongitude (const ::std::string& strLongitude_);

    /**
     * Sets the value of the member "strLongitude".
     *
     * Longitude information
     *
     * @param strLongitude The value which will be set
     */
    inline void setStrLongitude (const char* strLongitude_);

    /**
     * Sets the value of the member "strLongitude".
     *
     * Longitude information
     *
     * @param strLongitude The value which will be set
     */
    inline void setStrLongitude (const char* value, size_t size);

    // API of field "strMapVersion"

    static const int kStrMapVersion = 5;

    /**
     * Clears the field "strMapVersion".
     *
     * The field will be set to its default value. The hasStrMapVersion()
     * method will return false.
     */
    inline void clearStrMapVersion();

    /**
     * Checks whether the field "strMapVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrMapVersion()). Otherwise it will return false.
     */
    inline bool hasStrMapVersion () const;

    /**
     * Returns the value of the member "strMapVersion".
     *
     * Map version
     *
     * @return The value of the field "strMapVersion"
     */
    inline const ::std::string& getStrMapVersion () const;

    /**
     * Retrieves the value of the field "strMapVersion" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strMapVersion".
     */
    inline ::std::string& getStrMapVersionMutable ();

    /**
     * Sets the value of the member "strMapVersion".
     *
     * Map version
     *
     * @param strMapVersion The value which will be set
     */
    inline void setStrMapVersion (const ::std::string& strMapVersion_);

    /**
     * Sets the value of the member "strMapVersion".
     *
     * Map version
     *
     * @param strMapVersion The value which will be set
     */
    inline void setStrMapVersion (const char* strMapVersion_);

    /**
     * Sets the value of the member "strMapVersion".
     *
     * Map version
     *
     * @param strMapVersion The value which will be set
     */
    inline void setStrMapVersion (const char* value, size_t size);

    // API of field "strNaviSWVersion"

    static const int kStrNaviSWVersion = 6;

    /**
     * Clears the field "strNaviSWVersion".
     *
     * The field will be set to its default value. The hasStrNaviSWVersion()
     * method will return false.
     */
    inline void clearStrNaviSWVersion();

    /**
     * Checks whether the field "strNaviSWVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrNaviSWVersion()). Otherwise it will return false.
     */
    inline bool hasStrNaviSWVersion () const;

    /**
     * Returns the value of the member "strNaviSWVersion".
     *
     * Navigation Software version
     *
     * @return The value of the field "strNaviSWVersion"
     */
    inline const ::std::string& getStrNaviSWVersion () const;

    /**
     * Retrieves the value of the field "strNaviSWVersion" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strNaviSWVersion".
     */
    inline ::std::string& getStrNaviSWVersionMutable ();

    /**
     * Sets the value of the member "strNaviSWVersion".
     *
     * Navigation Software version
     *
     * @param strNaviSWVersion The value which will be set
     */
    inline void setStrNaviSWVersion (const ::std::string& strNaviSWVersion_);

    /**
     * Sets the value of the member "strNaviSWVersion".
     *
     * Navigation Software version
     *
     * @param strNaviSWVersion The value which will be set
     */
    inline void setStrNaviSWVersion (const char* strNaviSWVersion_);

    /**
     * Sets the value of the member "strNaviSWVersion".
     *
     * Navigation Software version
     *
     * @param strNaviSWVersion The value which will be set
     */
    inline void setStrNaviSWVersion (const char* value, size_t size);

    static const T_usb_tcu_GroupA_BasicServices_Info &getDefaultInstance();

private:

    inline void set_has_strDatum ();

    inline void clear_has_strDatum ();

    inline void set_has_strDcmVersion ();

    inline void clear_has_strDcmVersion ();

    inline void set_has_strLanguage ();

    inline void clear_has_strLanguage ();

    inline void set_has_strLatitude ();

    inline void clear_has_strLatitude ();

    inline void set_has_strLongitude ();

    inline void clear_has_strLongitude ();

    inline void set_has_strMapVersion ();

    inline void clear_has_strMapVersion ();

    inline void set_has_strNaviSWVersion ();

    inline void clear_has_strNaviSWVersion ();

    uint32 _has_bits_[ (7 + 31) / 32];

    ::std::string _strDatum;

    ::std::string _strDcmVersion;

    ::std::string _strLanguage;

    ::std::string _strLatitude;

    ::std::string _strLongitude;

    ::std::string _strMapVersion;

    ::std::string _strNaviSWVersion;

};

/**
 * If the meaning of "T_usb_tcu_GroupA_Info" isn't clear, then there should be a description here.
 */
class T_usb_tcu_GroupA_Info {
public:

    /**
     * Default constructor
     */
    inline  T_usb_tcu_GroupA_Info ();

    /**
     * Copy constructor
     */
    inline  T_usb_tcu_GroupA_Info (const T_usb_tcu_GroupA_Info &rhs);

    /**
     * All fields constructor
     */
    inline  T_usb_tcu_GroupA_Info (const T_usb_tcu_GroupA_Authorization_Info& GroupA_Authorization_Info_, const T_usb_tcu_GroupA_BasicServices_Info& GroupA_BasicServices_Info_);

    /**
     * Destructor
     */
    inline  ~T_usb_tcu_GroupA_Info();

    /**
     * Assignment operator
     */
    inline T_usb_tcu_GroupA_Info& operator = (const T_usb_tcu_GroupA_Info& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_usb_tcu_GroupA_Info& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_usb_tcu_GroupA_Info& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_usb_tcu_GroupA_Info& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_usb_tcu_GroupA_Info& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "GroupA_Authorization_Info"

    static const int kGroupA_Authorization_Info = 0;

    /**
     * Clears the field "GroupA_Authorization_Info".
     *
     * The field will be set to its default value. The hasGroupA_Authorization_Info()
     * method will return false.
     */
    inline void clearGroupA_Authorization_Info();

    /**
     * Checks whether the field "GroupA_Authorization_Info" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGroupA_Authorization_Info()). Otherwise it will return false.
     */
    inline bool hasGroupA_Authorization_Info () const;

    /**
     * Returns the value of the member "GroupA_Authorization_Info".
     *
     * Contains authorization information
     *
     * @return The value of the field "GroupA_Authorization_Info"
     */
    inline const T_usb_tcu_GroupA_Authorization_Info& getGroupA_Authorization_Info () const;

    /**
     * Retrieves the value of the field "GroupA_Authorization_Info" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "GroupA_Authorization_Info".
     */
    inline T_usb_tcu_GroupA_Authorization_Info& getGroupA_Authorization_InfoMutable ();

    /**
     * Sets the value of the member "GroupA_Authorization_Info".
     *
     * Contains authorization information
     *
     * @param GroupA_Authorization_Info The value which will be set
     */
    inline void setGroupA_Authorization_Info (const T_usb_tcu_GroupA_Authorization_Info& GroupA_Authorization_Info_);

    // API of field "GroupA_BasicServices_Info"

    static const int kGroupA_BasicServices_Info = 1;

    /**
     * Clears the field "GroupA_BasicServices_Info".
     *
     * The field will be set to its default value. The hasGroupA_BasicServices_Info()
     * method will return false.
     */
    inline void clearGroupA_BasicServices_Info();

    /**
     * Checks whether the field "GroupA_BasicServices_Info" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGroupA_BasicServices_Info()). Otherwise it will return false.
     */
    inline bool hasGroupA_BasicServices_Info () const;

    /**
     * Returns the value of the member "GroupA_BasicServices_Info".
     *
     * Contains basic services information
     *
     * @return The value of the field "GroupA_BasicServices_Info"
     */
    inline const T_usb_tcu_GroupA_BasicServices_Info& getGroupA_BasicServices_Info () const;

    /**
     * Retrieves the value of the field "GroupA_BasicServices_Info" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "GroupA_BasicServices_Info".
     */
    inline T_usb_tcu_GroupA_BasicServices_Info& getGroupA_BasicServices_InfoMutable ();

    /**
     * Sets the value of the member "GroupA_BasicServices_Info".
     *
     * Contains basic services information
     *
     * @param GroupA_BasicServices_Info The value which will be set
     */
    inline void setGroupA_BasicServices_Info (const T_usb_tcu_GroupA_BasicServices_Info& GroupA_BasicServices_Info_);

    static const T_usb_tcu_GroupA_Info &getDefaultInstance();

private:

    inline void set_has_GroupA_Authorization_Info ();

    inline void clear_has_GroupA_Authorization_Info ();

    inline void set_has_GroupA_BasicServices_Info ();

    inline void clear_has_GroupA_BasicServices_Info ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_usb_tcu_GroupA_Authorization_Info _GroupA_Authorization_Info;

    T_usb_tcu_GroupA_BasicServices_Info _GroupA_BasicServices_Info;

};

/**
 * If the meaning of "T_tcu_charging_spot_data" isn't clear, then there should be a description here.
 */
class T_tcu_charging_spot_data {
public:

    /**
     * Default constructor
     */
    inline  T_tcu_charging_spot_data ();

    /**
     * Copy constructor
     */
    inline  T_tcu_charging_spot_data (const T_tcu_charging_spot_data &rhs);

    /**
     * All fields constructor
     */
    inline  T_tcu_charging_spot_data (const T_usb_tcu_Location& Location_, const ::std::string& strAreaCode1_, const ::std::string& strAreaCode2_, const ::std::string& strAreaCode3_, const ::std::string& strAreaCode4_, const ::std::string& strAreaCode5_, const ::std::string& strAreaCode6_, const ::std::string& strAreaCode7_, const ::std::string& strAreaCode8_, const ::std::string& strPOIName_, const ::std::string& strStreetAndHouseNo_, const ::std::string& strTelephonenumber_, uint16 u16Categorycode_, uint16 u16ClosedhourInformation_, uint16 u16OpeninghourInformation_, uint16 u16Parkingnumber_, uint16 u16Paymenttypeinformation_, uint16 u16Sizeofdetailinformation_, uint16 u16Subcategorycode_, uint32 u32POIID_, uint32 u32UserrestrictionID_, uint8 u8_24hoursadayinformation_, uint8 u8Businessdayoftheweekinformation_, uint8 u8Chargingfeeinformation_, uint8 u8Chargingtype_, uint8 u8Detailsinformation_, uint8 u8Entranceinformation_, uint8 u8Expresswaygeneraltype_, uint8 u8Fixedvalue1_, uint8 u8Fixedvalue2_, uint8 u8Informationreliability_, uint8 u8Installationfacilityinformation_, uint8 u8Nearthefacilityinformation_, uint8 u8Officehoursunknowninformation_, uint8 u8Partnersfacilityinformation_, uint8 u8SizeOfPOIName_, uint8 u8SizeOfStreetAndHouseNo_, uint8 u8SizeOfTelephonenumber_, uint8 u8Thenumberofentranceinformation_, uint8 u8Thenumberofinstallationfacilityinformation_, uint8 u8Thenumberofpartnersfacilityinformation_, uint8 u8Thetotalnumberofchargingtype_, uint8 u8Userrestriction_);

    /**
     * Destructor
     */
    inline  ~T_tcu_charging_spot_data();

    /**
     * Assignment operator
     */
    inline T_tcu_charging_spot_data& operator = (const T_tcu_charging_spot_data& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_tcu_charging_spot_data& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_tcu_charging_spot_data& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_tcu_charging_spot_data& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_tcu_charging_spot_data& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Location"

    static const int kLocation = 0;

    /**
     * Clears the field "Location".
     *
     * The field will be set to its default value. The hasLocation()
     * method will return false.
     */
    inline void clearLocation();

    /**
     * Checks whether the field "Location" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLocation()). Otherwise it will return false.
     */
    inline bool hasLocation () const;

    /**
     * Returns the value of the member "Location".
     *
     * If the meaning of "Location" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Location"
     */
    inline const T_usb_tcu_Location& getLocation () const;

    /**
     * Retrieves the value of the field "Location" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Location".
     */
    inline T_usb_tcu_Location& getLocationMutable ();

    /**
     * Sets the value of the member "Location".
     *
     * If the meaning of "Location" isn't clear, then there should be a description here.
     *
     * @param Location The value which will be set
     */
    inline void setLocation (const T_usb_tcu_Location& Location_);

    // API of field "strAreaCode1"

    static const int kStrAreaCode1 = 1;

    /**
     * Clears the field "strAreaCode1".
     *
     * The field will be set to its default value. The hasStrAreaCode1()
     * method will return false.
     */
    inline void clearStrAreaCode1();

    /**
     * Checks whether the field "strAreaCode1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrAreaCode1()). Otherwise it will return false.
     */
    inline bool hasStrAreaCode1 () const;

    /**
     * Returns the value of the member "strAreaCode1".
     *
     * AreaCode1
     *
     * @return The value of the field "strAreaCode1"
     */
    inline const ::std::string& getStrAreaCode1 () const;

    /**
     * Retrieves the value of the field "strAreaCode1" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strAreaCode1".
     */
    inline ::std::string& getStrAreaCode1Mutable ();

    /**
     * Sets the value of the member "strAreaCode1".
     *
     * AreaCode1
     *
     * @param strAreaCode1 The value which will be set
     */
    inline void setStrAreaCode1 (const ::std::string& strAreaCode1_);

    /**
     * Sets the value of the member "strAreaCode1".
     *
     * AreaCode1
     *
     * @param strAreaCode1 The value which will be set
     */
    inline void setStrAreaCode1 (const char* strAreaCode1_);

    /**
     * Sets the value of the member "strAreaCode1".
     *
     * AreaCode1
     *
     * @param strAreaCode1 The value which will be set
     */
    inline void setStrAreaCode1 (const char* value, size_t size);

    // API of field "strAreaCode2"

    static const int kStrAreaCode2 = 2;

    /**
     * Clears the field "strAreaCode2".
     *
     * The field will be set to its default value. The hasStrAreaCode2()
     * method will return false.
     */
    inline void clearStrAreaCode2();

    /**
     * Checks whether the field "strAreaCode2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrAreaCode2()). Otherwise it will return false.
     */
    inline bool hasStrAreaCode2 () const;

    /**
     * Returns the value of the member "strAreaCode2".
     *
     * AreaCode2
     *
     * @return The value of the field "strAreaCode2"
     */
    inline const ::std::string& getStrAreaCode2 () const;

    /**
     * Retrieves the value of the field "strAreaCode2" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strAreaCode2".
     */
    inline ::std::string& getStrAreaCode2Mutable ();

    /**
     * Sets the value of the member "strAreaCode2".
     *
     * AreaCode2
     *
     * @param strAreaCode2 The value which will be set
     */
    inline void setStrAreaCode2 (const ::std::string& strAreaCode2_);

    /**
     * Sets the value of the member "strAreaCode2".
     *
     * AreaCode2
     *
     * @param strAreaCode2 The value which will be set
     */
    inline void setStrAreaCode2 (const char* strAreaCode2_);

    /**
     * Sets the value of the member "strAreaCode2".
     *
     * AreaCode2
     *
     * @param strAreaCode2 The value which will be set
     */
    inline void setStrAreaCode2 (const char* value, size_t size);

    // API of field "strAreaCode3"

    static const int kStrAreaCode3 = 3;

    /**
     * Clears the field "strAreaCode3".
     *
     * The field will be set to its default value. The hasStrAreaCode3()
     * method will return false.
     */
    inline void clearStrAreaCode3();

    /**
     * Checks whether the field "strAreaCode3" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrAreaCode3()). Otherwise it will return false.
     */
    inline bool hasStrAreaCode3 () const;

    /**
     * Returns the value of the member "strAreaCode3".
     *
     * AreaCode3
     *
     * @return The value of the field "strAreaCode3"
     */
    inline const ::std::string& getStrAreaCode3 () const;

    /**
     * Retrieves the value of the field "strAreaCode3" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strAreaCode3".
     */
    inline ::std::string& getStrAreaCode3Mutable ();

    /**
     * Sets the value of the member "strAreaCode3".
     *
     * AreaCode3
     *
     * @param strAreaCode3 The value which will be set
     */
    inline void setStrAreaCode3 (const ::std::string& strAreaCode3_);

    /**
     * Sets the value of the member "strAreaCode3".
     *
     * AreaCode3
     *
     * @param strAreaCode3 The value which will be set
     */
    inline void setStrAreaCode3 (const char* strAreaCode3_);

    /**
     * Sets the value of the member "strAreaCode3".
     *
     * AreaCode3
     *
     * @param strAreaCode3 The value which will be set
     */
    inline void setStrAreaCode3 (const char* value, size_t size);

    // API of field "strAreaCode4"

    static const int kStrAreaCode4 = 4;

    /**
     * Clears the field "strAreaCode4".
     *
     * The field will be set to its default value. The hasStrAreaCode4()
     * method will return false.
     */
    inline void clearStrAreaCode4();

    /**
     * Checks whether the field "strAreaCode4" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrAreaCode4()). Otherwise it will return false.
     */
    inline bool hasStrAreaCode4 () const;

    /**
     * Returns the value of the member "strAreaCode4".
     *
     * AreaCode4
     *
     * @return The value of the field "strAreaCode4"
     */
    inline const ::std::string& getStrAreaCode4 () const;

    /**
     * Retrieves the value of the field "strAreaCode4" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strAreaCode4".
     */
    inline ::std::string& getStrAreaCode4Mutable ();

    /**
     * Sets the value of the member "strAreaCode4".
     *
     * AreaCode4
     *
     * @param strAreaCode4 The value which will be set
     */
    inline void setStrAreaCode4 (const ::std::string& strAreaCode4_);

    /**
     * Sets the value of the member "strAreaCode4".
     *
     * AreaCode4
     *
     * @param strAreaCode4 The value which will be set
     */
    inline void setStrAreaCode4 (const char* strAreaCode4_);

    /**
     * Sets the value of the member "strAreaCode4".
     *
     * AreaCode4
     *
     * @param strAreaCode4 The value which will be set
     */
    inline void setStrAreaCode4 (const char* value, size_t size);

    // API of field "strAreaCode5"

    static const int kStrAreaCode5 = 5;

    /**
     * Clears the field "strAreaCode5".
     *
     * The field will be set to its default value. The hasStrAreaCode5()
     * method will return false.
     */
    inline void clearStrAreaCode5();

    /**
     * Checks whether the field "strAreaCode5" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrAreaCode5()). Otherwise it will return false.
     */
    inline bool hasStrAreaCode5 () const;

    /**
     * Returns the value of the member "strAreaCode5".
     *
     * AreaCode5
     *
     * @return The value of the field "strAreaCode5"
     */
    inline const ::std::string& getStrAreaCode5 () const;

    /**
     * Retrieves the value of the field "strAreaCode5" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strAreaCode5".
     */
    inline ::std::string& getStrAreaCode5Mutable ();

    /**
     * Sets the value of the member "strAreaCode5".
     *
     * AreaCode5
     *
     * @param strAreaCode5 The value which will be set
     */
    inline void setStrAreaCode5 (const ::std::string& strAreaCode5_);

    /**
     * Sets the value of the member "strAreaCode5".
     *
     * AreaCode5
     *
     * @param strAreaCode5 The value which will be set
     */
    inline void setStrAreaCode5 (const char* strAreaCode5_);

    /**
     * Sets the value of the member "strAreaCode5".
     *
     * AreaCode5
     *
     * @param strAreaCode5 The value which will be set
     */
    inline void setStrAreaCode5 (const char* value, size_t size);

    // API of field "strAreaCode6"

    static const int kStrAreaCode6 = 6;

    /**
     * Clears the field "strAreaCode6".
     *
     * The field will be set to its default value. The hasStrAreaCode6()
     * method will return false.
     */
    inline void clearStrAreaCode6();

    /**
     * Checks whether the field "strAreaCode6" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrAreaCode6()). Otherwise it will return false.
     */
    inline bool hasStrAreaCode6 () const;

    /**
     * Returns the value of the member "strAreaCode6".
     *
     * AreaCode6
     *
     * @return The value of the field "strAreaCode6"
     */
    inline const ::std::string& getStrAreaCode6 () const;

    /**
     * Retrieves the value of the field "strAreaCode6" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strAreaCode6".
     */
    inline ::std::string& getStrAreaCode6Mutable ();

    /**
     * Sets the value of the member "strAreaCode6".
     *
     * AreaCode6
     *
     * @param strAreaCode6 The value which will be set
     */
    inline void setStrAreaCode6 (const ::std::string& strAreaCode6_);

    /**
     * Sets the value of the member "strAreaCode6".
     *
     * AreaCode6
     *
     * @param strAreaCode6 The value which will be set
     */
    inline void setStrAreaCode6 (const char* strAreaCode6_);

    /**
     * Sets the value of the member "strAreaCode6".
     *
     * AreaCode6
     *
     * @param strAreaCode6 The value which will be set
     */
    inline void setStrAreaCode6 (const char* value, size_t size);

    // API of field "strAreaCode7"

    static const int kStrAreaCode7 = 7;

    /**
     * Clears the field "strAreaCode7".
     *
     * The field will be set to its default value. The hasStrAreaCode7()
     * method will return false.
     */
    inline void clearStrAreaCode7();

    /**
     * Checks whether the field "strAreaCode7" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrAreaCode7()). Otherwise it will return false.
     */
    inline bool hasStrAreaCode7 () const;

    /**
     * Returns the value of the member "strAreaCode7".
     *
     * AreaCode7
     *
     * @return The value of the field "strAreaCode7"
     */
    inline const ::std::string& getStrAreaCode7 () const;

    /**
     * Retrieves the value of the field "strAreaCode7" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strAreaCode7".
     */
    inline ::std::string& getStrAreaCode7Mutable ();

    /**
     * Sets the value of the member "strAreaCode7".
     *
     * AreaCode7
     *
     * @param strAreaCode7 The value which will be set
     */
    inline void setStrAreaCode7 (const ::std::string& strAreaCode7_);

    /**
     * Sets the value of the member "strAreaCode7".
     *
     * AreaCode7
     *
     * @param strAreaCode7 The value which will be set
     */
    inline void setStrAreaCode7 (const char* strAreaCode7_);

    /**
     * Sets the value of the member "strAreaCode7".
     *
     * AreaCode7
     *
     * @param strAreaCode7 The value which will be set
     */
    inline void setStrAreaCode7 (const char* value, size_t size);

    // API of field "strAreaCode8"

    static const int kStrAreaCode8 = 8;

    /**
     * Clears the field "strAreaCode8".
     *
     * The field will be set to its default value. The hasStrAreaCode8()
     * method will return false.
     */
    inline void clearStrAreaCode8();

    /**
     * Checks whether the field "strAreaCode8" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrAreaCode8()). Otherwise it will return false.
     */
    inline bool hasStrAreaCode8 () const;

    /**
     * Returns the value of the member "strAreaCode8".
     *
     * AreaCode8
     *
     * @return The value of the field "strAreaCode8"
     */
    inline const ::std::string& getStrAreaCode8 () const;

    /**
     * Retrieves the value of the field "strAreaCode8" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strAreaCode8".
     */
    inline ::std::string& getStrAreaCode8Mutable ();

    /**
     * Sets the value of the member "strAreaCode8".
     *
     * AreaCode8
     *
     * @param strAreaCode8 The value which will be set
     */
    inline void setStrAreaCode8 (const ::std::string& strAreaCode8_);

    /**
     * Sets the value of the member "strAreaCode8".
     *
     * AreaCode8
     *
     * @param strAreaCode8 The value which will be set
     */
    inline void setStrAreaCode8 (const char* strAreaCode8_);

    /**
     * Sets the value of the member "strAreaCode8".
     *
     * AreaCode8
     *
     * @param strAreaCode8 The value which will be set
     */
    inline void setStrAreaCode8 (const char* value, size_t size);

    // API of field "strPOIName"

    static const int kStrPOIName = 9;

    /**
     * Clears the field "strPOIName".
     *
     * The field will be set to its default value. The hasStrPOIName()
     * method will return false.
     */
    inline void clearStrPOIName();

    /**
     * Checks whether the field "strPOIName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrPOIName()). Otherwise it will return false.
     */
    inline bool hasStrPOIName () const;

    /**
     * Returns the value of the member "strPOIName".
     *
     * POI Name
     *
     * @return The value of the field "strPOIName"
     */
    inline const ::std::string& getStrPOIName () const;

    /**
     * Retrieves the value of the field "strPOIName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strPOIName".
     */
    inline ::std::string& getStrPOINameMutable ();

    /**
     * Sets the value of the member "strPOIName".
     *
     * POI Name
     *
     * @param strPOIName The value which will be set
     */
    inline void setStrPOIName (const ::std::string& strPOIName_);

    /**
     * Sets the value of the member "strPOIName".
     *
     * POI Name
     *
     * @param strPOIName The value which will be set
     */
    inline void setStrPOIName (const char* strPOIName_);

    /**
     * Sets the value of the member "strPOIName".
     *
     * POI Name
     *
     * @param strPOIName The value which will be set
     */
    inline void setStrPOIName (const char* value, size_t size);

    // API of field "strStreetAndHouseNo"

    static const int kStrStreetAndHouseNo = 10;

    /**
     * Clears the field "strStreetAndHouseNo".
     *
     * The field will be set to its default value. The hasStrStreetAndHouseNo()
     * method will return false.
     */
    inline void clearStrStreetAndHouseNo();

    /**
     * Checks whether the field "strStreetAndHouseNo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrStreetAndHouseNo()). Otherwise it will return false.
     */
    inline bool hasStrStreetAndHouseNo () const;

    /**
     * Returns the value of the member "strStreetAndHouseNo".
     *
     * Street and House number
     *
     * @return The value of the field "strStreetAndHouseNo"
     */
    inline const ::std::string& getStrStreetAndHouseNo () const;

    /**
     * Retrieves the value of the field "strStreetAndHouseNo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strStreetAndHouseNo".
     */
    inline ::std::string& getStrStreetAndHouseNoMutable ();

    /**
     * Sets the value of the member "strStreetAndHouseNo".
     *
     * Street and House number
     *
     * @param strStreetAndHouseNo The value which will be set
     */
    inline void setStrStreetAndHouseNo (const ::std::string& strStreetAndHouseNo_);

    /**
     * Sets the value of the member "strStreetAndHouseNo".
     *
     * Street and House number
     *
     * @param strStreetAndHouseNo The value which will be set
     */
    inline void setStrStreetAndHouseNo (const char* strStreetAndHouseNo_);

    /**
     * Sets the value of the member "strStreetAndHouseNo".
     *
     * Street and House number
     *
     * @param strStreetAndHouseNo The value which will be set
     */
    inline void setStrStreetAndHouseNo (const char* value, size_t size);

    // API of field "strTelephonenumber"

    static const int kStrTelephonenumber = 11;

    /**
     * Clears the field "strTelephonenumber".
     *
     * The field will be set to its default value. The hasStrTelephonenumber()
     * method will return false.
     */
    inline void clearStrTelephonenumber();

    /**
     * Checks whether the field "strTelephonenumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrTelephonenumber()). Otherwise it will return false.
     */
    inline bool hasStrTelephonenumber () const;

    /**
     * Returns the value of the member "strTelephonenumber".
     *
     * Telephonenumber
     *
     * @return The value of the field "strTelephonenumber"
     */
    inline const ::std::string& getStrTelephonenumber () const;

    /**
     * Retrieves the value of the field "strTelephonenumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strTelephonenumber".
     */
    inline ::std::string& getStrTelephonenumberMutable ();

    /**
     * Sets the value of the member "strTelephonenumber".
     *
     * Telephonenumber
     *
     * @param strTelephonenumber The value which will be set
     */
    inline void setStrTelephonenumber (const ::std::string& strTelephonenumber_);

    /**
     * Sets the value of the member "strTelephonenumber".
     *
     * Telephonenumber
     *
     * @param strTelephonenumber The value which will be set
     */
    inline void setStrTelephonenumber (const char* strTelephonenumber_);

    /**
     * Sets the value of the member "strTelephonenumber".
     *
     * Telephonenumber
     *
     * @param strTelephonenumber The value which will be set
     */
    inline void setStrTelephonenumber (const char* value, size_t size);

    // API of field "u16Categorycode"

    static const int kU16Categorycode = 12;

    /**
     * Clears the field "u16Categorycode".
     *
     * The field will be set to its default value. The hasU16Categorycode()
     * method will return false.
     */
    inline void clearU16Categorycode();

    /**
     * Checks whether the field "u16Categorycode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16Categorycode()). Otherwise it will return false.
     */
    inline bool hasU16Categorycode () const;

    /**
     * Returns the value of the member "u16Categorycode".
     *
     * If the meaning of "u16Categorycode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u16Categorycode"
     */
    inline uint16 getU16Categorycode () const;

    /**
     * Sets the value of the member "u16Categorycode".
     *
     * If the meaning of "u16Categorycode" isn't clear, then there should be a description here.
     *
     * @param u16Categorycode The value which will be set
     */
    inline void setU16Categorycode (uint16 u16Categorycode_);

    // API of field "u16ClosedhourInformation"

    static const int kU16ClosedhourInformation = 13;

    /**
     * Clears the field "u16ClosedhourInformation".
     *
     * The field will be set to its default value. The hasU16ClosedhourInformation()
     * method will return false.
     */
    inline void clearU16ClosedhourInformation();

    /**
     * Checks whether the field "u16ClosedhourInformation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ClosedhourInformation()). Otherwise it will return false.
     */
    inline bool hasU16ClosedhourInformation () const;

    /**
     * Returns the value of the member "u16ClosedhourInformation".
     *
     * If the meaning of "u16ClosedhourInformation" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u16ClosedhourInformation"
     */
    inline uint16 getU16ClosedhourInformation () const;

    /**
     * Sets the value of the member "u16ClosedhourInformation".
     *
     * If the meaning of "u16ClosedhourInformation" isn't clear, then there should be a description here.
     *
     * @param u16ClosedhourInformation The value which will be set
     */
    inline void setU16ClosedhourInformation (uint16 u16ClosedhourInformation_);

    // API of field "u16OpeninghourInformation"

    static const int kU16OpeninghourInformation = 14;

    /**
     * Clears the field "u16OpeninghourInformation".
     *
     * The field will be set to its default value. The hasU16OpeninghourInformation()
     * method will return false.
     */
    inline void clearU16OpeninghourInformation();

    /**
     * Checks whether the field "u16OpeninghourInformation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16OpeninghourInformation()). Otherwise it will return false.
     */
    inline bool hasU16OpeninghourInformation () const;

    /**
     * Returns the value of the member "u16OpeninghourInformation".
     *
     * If the meaning of "u16OpeninghourInformation" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u16OpeninghourInformation"
     */
    inline uint16 getU16OpeninghourInformation () const;

    /**
     * Sets the value of the member "u16OpeninghourInformation".
     *
     * If the meaning of "u16OpeninghourInformation" isn't clear, then there should be a description here.
     *
     * @param u16OpeninghourInformation The value which will be set
     */
    inline void setU16OpeninghourInformation (uint16 u16OpeninghourInformation_);

    // API of field "u16Parkingnumber"

    static const int kU16Parkingnumber = 15;

    /**
     * Clears the field "u16Parkingnumber".
     *
     * The field will be set to its default value. The hasU16Parkingnumber()
     * method will return false.
     */
    inline void clearU16Parkingnumber();

    /**
     * Checks whether the field "u16Parkingnumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16Parkingnumber()). Otherwise it will return false.
     */
    inline bool hasU16Parkingnumber () const;

    /**
     * Returns the value of the member "u16Parkingnumber".
     *
     * If the meaning of "u16Parkingnumber" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u16Parkingnumber"
     */
    inline uint16 getU16Parkingnumber () const;

    /**
     * Sets the value of the member "u16Parkingnumber".
     *
     * If the meaning of "u16Parkingnumber" isn't clear, then there should be a description here.
     *
     * @param u16Parkingnumber The value which will be set
     */
    inline void setU16Parkingnumber (uint16 u16Parkingnumber_);

    // API of field "u16Paymenttypeinformation"

    static const int kU16Paymenttypeinformation = 16;

    /**
     * Clears the field "u16Paymenttypeinformation".
     *
     * The field will be set to its default value. The hasU16Paymenttypeinformation()
     * method will return false.
     */
    inline void clearU16Paymenttypeinformation();

    /**
     * Checks whether the field "u16Paymenttypeinformation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16Paymenttypeinformation()). Otherwise it will return false.
     */
    inline bool hasU16Paymenttypeinformation () const;

    /**
     * Returns the value of the member "u16Paymenttypeinformation".
     *
     * If the meaning of "u16Paymenttypeinformation" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u16Paymenttypeinformation"
     */
    inline uint16 getU16Paymenttypeinformation () const;

    /**
     * Sets the value of the member "u16Paymenttypeinformation".
     *
     * If the meaning of "u16Paymenttypeinformation" isn't clear, then there should be a description here.
     *
     * @param u16Paymenttypeinformation The value which will be set
     */
    inline void setU16Paymenttypeinformation (uint16 u16Paymenttypeinformation_);

    // API of field "u16Sizeofdetailinformation"

    static const int kU16Sizeofdetailinformation = 17;

    /**
     * Clears the field "u16Sizeofdetailinformation".
     *
     * The field will be set to its default value. The hasU16Sizeofdetailinformation()
     * method will return false.
     */
    inline void clearU16Sizeofdetailinformation();

    /**
     * Checks whether the field "u16Sizeofdetailinformation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16Sizeofdetailinformation()). Otherwise it will return false.
     */
    inline bool hasU16Sizeofdetailinformation () const;

    /**
     * Returns the value of the member "u16Sizeofdetailinformation".
     *
     * If the meaning of "u16Sizeofdetailinformation" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u16Sizeofdetailinformation"
     */
    inline uint16 getU16Sizeofdetailinformation () const;

    /**
     * Sets the value of the member "u16Sizeofdetailinformation".
     *
     * If the meaning of "u16Sizeofdetailinformation" isn't clear, then there should be a description here.
     *
     * @param u16Sizeofdetailinformation The value which will be set
     */
    inline void setU16Sizeofdetailinformation (uint16 u16Sizeofdetailinformation_);

    // API of field "u16Subcategorycode"

    static const int kU16Subcategorycode = 18;

    /**
     * Clears the field "u16Subcategorycode".
     *
     * The field will be set to its default value. The hasU16Subcategorycode()
     * method will return false.
     */
    inline void clearU16Subcategorycode();

    /**
     * Checks whether the field "u16Subcategorycode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16Subcategorycode()). Otherwise it will return false.
     */
    inline bool hasU16Subcategorycode () const;

    /**
     * Returns the value of the member "u16Subcategorycode".
     *
     * If the meaning of "u16Subcategorycode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u16Subcategorycode"
     */
    inline uint16 getU16Subcategorycode () const;

    /**
     * Sets the value of the member "u16Subcategorycode".
     *
     * If the meaning of "u16Subcategorycode" isn't clear, then there should be a description here.
     *
     * @param u16Subcategorycode The value which will be set
     */
    inline void setU16Subcategorycode (uint16 u16Subcategorycode_);

    // API of field "u32POIID"

    static const int kU32POIID = 19;

    /**
     * Clears the field "u32POIID".
     *
     * The field will be set to its default value. The hasU32POIID()
     * method will return false.
     */
    inline void clearU32POIID();

    /**
     * Checks whether the field "u32POIID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32POIID()). Otherwise it will return false.
     */
    inline bool hasU32POIID () const;

    /**
     * Returns the value of the member "u32POIID".
     *
     * If the meaning of "u32POIID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32POIID"
     */
    inline uint32 getU32POIID () const;

    /**
     * Sets the value of the member "u32POIID".
     *
     * If the meaning of "u32POIID" isn't clear, then there should be a description here.
     *
     * @param u32POIID The value which will be set
     */
    inline void setU32POIID (uint32 u32POIID_);

    // API of field "u32UserrestrictionID"

    static const int kU32UserrestrictionID = 20;

    /**
     * Clears the field "u32UserrestrictionID".
     *
     * The field will be set to its default value. The hasU32UserrestrictionID()
     * method will return false.
     */
    inline void clearU32UserrestrictionID();

    /**
     * Checks whether the field "u32UserrestrictionID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32UserrestrictionID()). Otherwise it will return false.
     */
    inline bool hasU32UserrestrictionID () const;

    /**
     * Returns the value of the member "u32UserrestrictionID".
     *
     * If the meaning of "u32UserrestrictionID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32UserrestrictionID"
     */
    inline uint32 getU32UserrestrictionID () const;

    /**
     * Sets the value of the member "u32UserrestrictionID".
     *
     * If the meaning of "u32UserrestrictionID" isn't clear, then there should be a description here.
     *
     * @param u32UserrestrictionID The value which will be set
     */
    inline void setU32UserrestrictionID (uint32 u32UserrestrictionID_);

    // API of field "u8_24hoursadayinformation"

    static const int kU8_24hoursadayinformation = 21;

    /**
     * Clears the field "u8_24hoursadayinformation".
     *
     * The field will be set to its default value. The hasU8_24hoursadayinformation()
     * method will return false.
     */
    inline void clearU8_24hoursadayinformation();

    /**
     * Checks whether the field "u8_24hoursadayinformation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8_24hoursadayinformation()). Otherwise it will return false.
     */
    inline bool hasU8_24hoursadayinformation () const;

    /**
     * Returns the value of the member "u8_24hoursadayinformation".
     *
     * If the meaning of "u8_24hoursadayinformation" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8_24hoursadayinformation"
     */
    inline uint8 getU8_24hoursadayinformation () const;

    /**
     * Sets the value of the member "u8_24hoursadayinformation".
     *
     * If the meaning of "u8_24hoursadayinformation" isn't clear, then there should be a description here.
     *
     * @param u8_24hoursadayinformation The value which will be set
     */
    inline void setU8_24hoursadayinformation (uint8 u8_24hoursadayinformation_);

    // API of field "u8Businessdayoftheweekinformation"

    static const int kU8Businessdayoftheweekinformation = 22;

    /**
     * Clears the field "u8Businessdayoftheweekinformation".
     *
     * The field will be set to its default value. The hasU8Businessdayoftheweekinformation()
     * method will return false.
     */
    inline void clearU8Businessdayoftheweekinformation();

    /**
     * Checks whether the field "u8Businessdayoftheweekinformation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Businessdayoftheweekinformation()). Otherwise it will return false.
     */
    inline bool hasU8Businessdayoftheweekinformation () const;

    /**
     * Returns the value of the member "u8Businessdayoftheweekinformation".
     *
     * If the meaning of "u8Businessdayoftheweekinformation" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Businessdayoftheweekinformation"
     */
    inline uint8 getU8Businessdayoftheweekinformation () const;

    /**
     * Sets the value of the member "u8Businessdayoftheweekinformation".
     *
     * If the meaning of "u8Businessdayoftheweekinformation" isn't clear, then there should be a description here.
     *
     * @param u8Businessdayoftheweekinformation The value which will be set
     */
    inline void setU8Businessdayoftheweekinformation (uint8 u8Businessdayoftheweekinformation_);

    // API of field "u8Chargingfeeinformation"

    static const int kU8Chargingfeeinformation = 23;

    /**
     * Clears the field "u8Chargingfeeinformation".
     *
     * The field will be set to its default value. The hasU8Chargingfeeinformation()
     * method will return false.
     */
    inline void clearU8Chargingfeeinformation();

    /**
     * Checks whether the field "u8Chargingfeeinformation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Chargingfeeinformation()). Otherwise it will return false.
     */
    inline bool hasU8Chargingfeeinformation () const;

    /**
     * Returns the value of the member "u8Chargingfeeinformation".
     *
     * If the meaning of "u8Chargingfeeinformation" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Chargingfeeinformation"
     */
    inline uint8 getU8Chargingfeeinformation () const;

    /**
     * Sets the value of the member "u8Chargingfeeinformation".
     *
     * If the meaning of "u8Chargingfeeinformation" isn't clear, then there should be a description here.
     *
     * @param u8Chargingfeeinformation The value which will be set
     */
    inline void setU8Chargingfeeinformation (uint8 u8Chargingfeeinformation_);

    // API of field "u8Chargingtype"

    static const int kU8Chargingtype = 24;

    /**
     * Clears the field "u8Chargingtype".
     *
     * The field will be set to its default value. The hasU8Chargingtype()
     * method will return false.
     */
    inline void clearU8Chargingtype();

    /**
     * Checks whether the field "u8Chargingtype" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Chargingtype()). Otherwise it will return false.
     */
    inline bool hasU8Chargingtype () const;

    /**
     * Returns the value of the member "u8Chargingtype".
     *
     * If the meaning of "u8Chargingtype" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Chargingtype"
     */
    inline uint8 getU8Chargingtype () const;

    /**
     * Sets the value of the member "u8Chargingtype".
     *
     * If the meaning of "u8Chargingtype" isn't clear, then there should be a description here.
     *
     * @param u8Chargingtype The value which will be set
     */
    inline void setU8Chargingtype (uint8 u8Chargingtype_);

    // API of field "u8Detailsinformation"

    static const int kU8Detailsinformation = 25;

    /**
     * Clears the field "u8Detailsinformation".
     *
     * The field will be set to its default value. The hasU8Detailsinformation()
     * method will return false.
     */
    inline void clearU8Detailsinformation();

    /**
     * Checks whether the field "u8Detailsinformation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Detailsinformation()). Otherwise it will return false.
     */
    inline bool hasU8Detailsinformation () const;

    /**
     * Returns the value of the member "u8Detailsinformation".
     *
     * If the meaning of "u8Detailsinformation" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Detailsinformation"
     */
    inline uint8 getU8Detailsinformation () const;

    /**
     * Sets the value of the member "u8Detailsinformation".
     *
     * If the meaning of "u8Detailsinformation" isn't clear, then there should be a description here.
     *
     * @param u8Detailsinformation The value which will be set
     */
    inline void setU8Detailsinformation (uint8 u8Detailsinformation_);

    // API of field "u8Entranceinformation"

    static const int kU8Entranceinformation = 26;

    /**
     * Clears the field "u8Entranceinformation".
     *
     * The field will be set to its default value. The hasU8Entranceinformation()
     * method will return false.
     */
    inline void clearU8Entranceinformation();

    /**
     * Checks whether the field "u8Entranceinformation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Entranceinformation()). Otherwise it will return false.
     */
    inline bool hasU8Entranceinformation () const;

    /**
     * Returns the value of the member "u8Entranceinformation".
     *
     * If the meaning of "u8Entranceinformation" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Entranceinformation"
     */
    inline uint8 getU8Entranceinformation () const;

    /**
     * Sets the value of the member "u8Entranceinformation".
     *
     * If the meaning of "u8Entranceinformation" isn't clear, then there should be a description here.
     *
     * @param u8Entranceinformation The value which will be set
     */
    inline void setU8Entranceinformation (uint8 u8Entranceinformation_);

    // API of field "u8Expresswaygeneraltype"

    static const int kU8Expresswaygeneraltype = 27;

    /**
     * Clears the field "u8Expresswaygeneraltype".
     *
     * The field will be set to its default value. The hasU8Expresswaygeneraltype()
     * method will return false.
     */
    inline void clearU8Expresswaygeneraltype();

    /**
     * Checks whether the field "u8Expresswaygeneraltype" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Expresswaygeneraltype()). Otherwise it will return false.
     */
    inline bool hasU8Expresswaygeneraltype () const;

    /**
     * Returns the value of the member "u8Expresswaygeneraltype".
     *
     * If the meaning of "u8Expresswaygeneraltype" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Expresswaygeneraltype"
     */
    inline uint8 getU8Expresswaygeneraltype () const;

    /**
     * Sets the value of the member "u8Expresswaygeneraltype".
     *
     * If the meaning of "u8Expresswaygeneraltype" isn't clear, then there should be a description here.
     *
     * @param u8Expresswaygeneraltype The value which will be set
     */
    inline void setU8Expresswaygeneraltype (uint8 u8Expresswaygeneraltype_);

    // API of field "u8Fixedvalue1"

    static const int kU8Fixedvalue1 = 28;

    /**
     * Clears the field "u8Fixedvalue1".
     *
     * The field will be set to its default value. The hasU8Fixedvalue1()
     * method will return false.
     */
    inline void clearU8Fixedvalue1();

    /**
     * Checks whether the field "u8Fixedvalue1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Fixedvalue1()). Otherwise it will return false.
     */
    inline bool hasU8Fixedvalue1 () const;

    /**
     * Returns the value of the member "u8Fixedvalue1".
     *
     * If the meaning of "u8Fixedvalue1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Fixedvalue1"
     */
    inline uint8 getU8Fixedvalue1 () const;

    /**
     * Sets the value of the member "u8Fixedvalue1".
     *
     * If the meaning of "u8Fixedvalue1" isn't clear, then there should be a description here.
     *
     * @param u8Fixedvalue1 The value which will be set
     */
    inline void setU8Fixedvalue1 (uint8 u8Fixedvalue1_);

    // API of field "u8Fixedvalue2"

    static const int kU8Fixedvalue2 = 29;

    /**
     * Clears the field "u8Fixedvalue2".
     *
     * The field will be set to its default value. The hasU8Fixedvalue2()
     * method will return false.
     */
    inline void clearU8Fixedvalue2();

    /**
     * Checks whether the field "u8Fixedvalue2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Fixedvalue2()). Otherwise it will return false.
     */
    inline bool hasU8Fixedvalue2 () const;

    /**
     * Returns the value of the member "u8Fixedvalue2".
     *
     * If the meaning of "u8Fixedvalue2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Fixedvalue2"
     */
    inline uint8 getU8Fixedvalue2 () const;

    /**
     * Sets the value of the member "u8Fixedvalue2".
     *
     * If the meaning of "u8Fixedvalue2" isn't clear, then there should be a description here.
     *
     * @param u8Fixedvalue2 The value which will be set
     */
    inline void setU8Fixedvalue2 (uint8 u8Fixedvalue2_);

    // API of field "u8Informationreliability"

    static const int kU8Informationreliability = 30;

    /**
     * Clears the field "u8Informationreliability".
     *
     * The field will be set to its default value. The hasU8Informationreliability()
     * method will return false.
     */
    inline void clearU8Informationreliability();

    /**
     * Checks whether the field "u8Informationreliability" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Informationreliability()). Otherwise it will return false.
     */
    inline bool hasU8Informationreliability () const;

    /**
     * Returns the value of the member "u8Informationreliability".
     *
     * If the meaning of "u8Informationreliability" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Informationreliability"
     */
    inline uint8 getU8Informationreliability () const;

    /**
     * Sets the value of the member "u8Informationreliability".
     *
     * If the meaning of "u8Informationreliability" isn't clear, then there should be a description here.
     *
     * @param u8Informationreliability The value which will be set
     */
    inline void setU8Informationreliability (uint8 u8Informationreliability_);

    // API of field "u8Installationfacilityinformation"

    static const int kU8Installationfacilityinformation = 31;

    /**
     * Clears the field "u8Installationfacilityinformation".
     *
     * The field will be set to its default value. The hasU8Installationfacilityinformation()
     * method will return false.
     */
    inline void clearU8Installationfacilityinformation();

    /**
     * Checks whether the field "u8Installationfacilityinformation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Installationfacilityinformation()). Otherwise it will return false.
     */
    inline bool hasU8Installationfacilityinformation () const;

    /**
     * Returns the value of the member "u8Installationfacilityinformation".
     *
     * If the meaning of "u8Installationfacilityinformation" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Installationfacilityinformation"
     */
    inline uint8 getU8Installationfacilityinformation () const;

    /**
     * Sets the value of the member "u8Installationfacilityinformation".
     *
     * If the meaning of "u8Installationfacilityinformation" isn't clear, then there should be a description here.
     *
     * @param u8Installationfacilityinformation The value which will be set
     */
    inline void setU8Installationfacilityinformation (uint8 u8Installationfacilityinformation_);

    // API of field "u8Nearthefacilityinformation"

    static const int kU8Nearthefacilityinformation = 32;

    /**
     * Clears the field "u8Nearthefacilityinformation".
     *
     * The field will be set to its default value. The hasU8Nearthefacilityinformation()
     * method will return false.
     */
    inline void clearU8Nearthefacilityinformation();

    /**
     * Checks whether the field "u8Nearthefacilityinformation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Nearthefacilityinformation()). Otherwise it will return false.
     */
    inline bool hasU8Nearthefacilityinformation () const;

    /**
     * Returns the value of the member "u8Nearthefacilityinformation".
     *
     * If the meaning of "u8Nearthefacilityinformation" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Nearthefacilityinformation"
     */
    inline uint8 getU8Nearthefacilityinformation () const;

    /**
     * Sets the value of the member "u8Nearthefacilityinformation".
     *
     * If the meaning of "u8Nearthefacilityinformation" isn't clear, then there should be a description here.
     *
     * @param u8Nearthefacilityinformation The value which will be set
     */
    inline void setU8Nearthefacilityinformation (uint8 u8Nearthefacilityinformation_);

    // API of field "u8Officehoursunknowninformation"

    static const int kU8Officehoursunknowninformation = 33;

    /**
     * Clears the field "u8Officehoursunknowninformation".
     *
     * The field will be set to its default value. The hasU8Officehoursunknowninformation()
     * method will return false.
     */
    inline void clearU8Officehoursunknowninformation();

    /**
     * Checks whether the field "u8Officehoursunknowninformation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Officehoursunknowninformation()). Otherwise it will return false.
     */
    inline bool hasU8Officehoursunknowninformation () const;

    /**
     * Returns the value of the member "u8Officehoursunknowninformation".
     *
     * If the meaning of "u8Officehoursunknowninformation" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Officehoursunknowninformation"
     */
    inline uint8 getU8Officehoursunknowninformation () const;

    /**
     * Sets the value of the member "u8Officehoursunknowninformation".
     *
     * If the meaning of "u8Officehoursunknowninformation" isn't clear, then there should be a description here.
     *
     * @param u8Officehoursunknowninformation The value which will be set
     */
    inline void setU8Officehoursunknowninformation (uint8 u8Officehoursunknowninformation_);

    // API of field "u8Partnersfacilityinformation"

    static const int kU8Partnersfacilityinformation = 34;

    /**
     * Clears the field "u8Partnersfacilityinformation".
     *
     * The field will be set to its default value. The hasU8Partnersfacilityinformation()
     * method will return false.
     */
    inline void clearU8Partnersfacilityinformation();

    /**
     * Checks whether the field "u8Partnersfacilityinformation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Partnersfacilityinformation()). Otherwise it will return false.
     */
    inline bool hasU8Partnersfacilityinformation () const;

    /**
     * Returns the value of the member "u8Partnersfacilityinformation".
     *
     * If the meaning of "u8Partnersfacilityinformation" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Partnersfacilityinformation"
     */
    inline uint8 getU8Partnersfacilityinformation () const;

    /**
     * Sets the value of the member "u8Partnersfacilityinformation".
     *
     * If the meaning of "u8Partnersfacilityinformation" isn't clear, then there should be a description here.
     *
     * @param u8Partnersfacilityinformation The value which will be set
     */
    inline void setU8Partnersfacilityinformation (uint8 u8Partnersfacilityinformation_);

    // API of field "u8SizeOfPOIName"

    static const int kU8SizeOfPOIName = 35;

    /**
     * Clears the field "u8SizeOfPOIName".
     *
     * The field will be set to its default value. The hasU8SizeOfPOIName()
     * method will return false.
     */
    inline void clearU8SizeOfPOIName();

    /**
     * Checks whether the field "u8SizeOfPOIName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SizeOfPOIName()). Otherwise it will return false.
     */
    inline bool hasU8SizeOfPOIName () const;

    /**
     * Returns the value of the member "u8SizeOfPOIName".
     *
     * If the meaning of "u8SizeOfPOIName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8SizeOfPOIName"
     */
    inline uint8 getU8SizeOfPOIName () const;

    /**
     * Sets the value of the member "u8SizeOfPOIName".
     *
     * If the meaning of "u8SizeOfPOIName" isn't clear, then there should be a description here.
     *
     * @param u8SizeOfPOIName The value which will be set
     */
    inline void setU8SizeOfPOIName (uint8 u8SizeOfPOIName_);

    // API of field "u8SizeOfStreetAndHouseNo"

    static const int kU8SizeOfStreetAndHouseNo = 36;

    /**
     * Clears the field "u8SizeOfStreetAndHouseNo".
     *
     * The field will be set to its default value. The hasU8SizeOfStreetAndHouseNo()
     * method will return false.
     */
    inline void clearU8SizeOfStreetAndHouseNo();

    /**
     * Checks whether the field "u8SizeOfStreetAndHouseNo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SizeOfStreetAndHouseNo()). Otherwise it will return false.
     */
    inline bool hasU8SizeOfStreetAndHouseNo () const;

    /**
     * Returns the value of the member "u8SizeOfStreetAndHouseNo".
     *
     * If the meaning of "u8SizeOfStreetAndHouseNo" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8SizeOfStreetAndHouseNo"
     */
    inline uint8 getU8SizeOfStreetAndHouseNo () const;

    /**
     * Sets the value of the member "u8SizeOfStreetAndHouseNo".
     *
     * If the meaning of "u8SizeOfStreetAndHouseNo" isn't clear, then there should be a description here.
     *
     * @param u8SizeOfStreetAndHouseNo The value which will be set
     */
    inline void setU8SizeOfStreetAndHouseNo (uint8 u8SizeOfStreetAndHouseNo_);

    // API of field "u8SizeOfTelephonenumber"

    static const int kU8SizeOfTelephonenumber = 37;

    /**
     * Clears the field "u8SizeOfTelephonenumber".
     *
     * The field will be set to its default value. The hasU8SizeOfTelephonenumber()
     * method will return false.
     */
    inline void clearU8SizeOfTelephonenumber();

    /**
     * Checks whether the field "u8SizeOfTelephonenumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SizeOfTelephonenumber()). Otherwise it will return false.
     */
    inline bool hasU8SizeOfTelephonenumber () const;

    /**
     * Returns the value of the member "u8SizeOfTelephonenumber".
     *
     * If the meaning of "u8SizeOfTelephonenumber" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8SizeOfTelephonenumber"
     */
    inline uint8 getU8SizeOfTelephonenumber () const;

    /**
     * Sets the value of the member "u8SizeOfTelephonenumber".
     *
     * If the meaning of "u8SizeOfTelephonenumber" isn't clear, then there should be a description here.
     *
     * @param u8SizeOfTelephonenumber The value which will be set
     */
    inline void setU8SizeOfTelephonenumber (uint8 u8SizeOfTelephonenumber_);

    // API of field "u8Thenumberofentranceinformation"

    static const int kU8Thenumberofentranceinformation = 38;

    /**
     * Clears the field "u8Thenumberofentranceinformation".
     *
     * The field will be set to its default value. The hasU8Thenumberofentranceinformation()
     * method will return false.
     */
    inline void clearU8Thenumberofentranceinformation();

    /**
     * Checks whether the field "u8Thenumberofentranceinformation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Thenumberofentranceinformation()). Otherwise it will return false.
     */
    inline bool hasU8Thenumberofentranceinformation () const;

    /**
     * Returns the value of the member "u8Thenumberofentranceinformation".
     *
     * If the meaning of "u8Thenumberofentranceinformation" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Thenumberofentranceinformation"
     */
    inline uint8 getU8Thenumberofentranceinformation () const;

    /**
     * Sets the value of the member "u8Thenumberofentranceinformation".
     *
     * If the meaning of "u8Thenumberofentranceinformation" isn't clear, then there should be a description here.
     *
     * @param u8Thenumberofentranceinformation The value which will be set
     */
    inline void setU8Thenumberofentranceinformation (uint8 u8Thenumberofentranceinformation_);

    // API of field "u8Thenumberofinstallationfacilityinformation"

    static const int kU8Thenumberofinstallationfacilityinformation = 39;

    /**
     * Clears the field "u8Thenumberofinstallationfacilityinformation".
     *
     * The field will be set to its default value. The hasU8Thenumberofinstallationfacilityinformation()
     * method will return false.
     */
    inline void clearU8Thenumberofinstallationfacilityinformation();

    /**
     * Checks whether the field "u8Thenumberofinstallationfacilityinformation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Thenumberofinstallationfacilityinformation()). Otherwise it will return false.
     */
    inline bool hasU8Thenumberofinstallationfacilityinformation () const;

    /**
     * Returns the value of the member "u8Thenumberofinstallationfacilityinformation".
     *
     * If the meaning of "u8Thenumberofinstallationfacilityinformation" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Thenumberofinstallationfacilityinformation"
     */
    inline uint8 getU8Thenumberofinstallationfacilityinformation () const;

    /**
     * Sets the value of the member "u8Thenumberofinstallationfacilityinformation".
     *
     * If the meaning of "u8Thenumberofinstallationfacilityinformation" isn't clear, then there should be a description here.
     *
     * @param u8Thenumberofinstallationfacilityinformation The value which will be set
     */
    inline void setU8Thenumberofinstallationfacilityinformation (uint8 u8Thenumberofinstallationfacilityinformation_);

    // API of field "u8Thenumberofpartnersfacilityinformation"

    static const int kU8Thenumberofpartnersfacilityinformation = 40;

    /**
     * Clears the field "u8Thenumberofpartnersfacilityinformation".
     *
     * The field will be set to its default value. The hasU8Thenumberofpartnersfacilityinformation()
     * method will return false.
     */
    inline void clearU8Thenumberofpartnersfacilityinformation();

    /**
     * Checks whether the field "u8Thenumberofpartnersfacilityinformation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Thenumberofpartnersfacilityinformation()). Otherwise it will return false.
     */
    inline bool hasU8Thenumberofpartnersfacilityinformation () const;

    /**
     * Returns the value of the member "u8Thenumberofpartnersfacilityinformation".
     *
     * If the meaning of "u8Thenumberofpartnersfacilityinformation" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Thenumberofpartnersfacilityinformation"
     */
    inline uint8 getU8Thenumberofpartnersfacilityinformation () const;

    /**
     * Sets the value of the member "u8Thenumberofpartnersfacilityinformation".
     *
     * If the meaning of "u8Thenumberofpartnersfacilityinformation" isn't clear, then there should be a description here.
     *
     * @param u8Thenumberofpartnersfacilityinformation The value which will be set
     */
    inline void setU8Thenumberofpartnersfacilityinformation (uint8 u8Thenumberofpartnersfacilityinformation_);

    // API of field "u8Thetotalnumberofchargingtype"

    static const int kU8Thetotalnumberofchargingtype = 41;

    /**
     * Clears the field "u8Thetotalnumberofchargingtype".
     *
     * The field will be set to its default value. The hasU8Thetotalnumberofchargingtype()
     * method will return false.
     */
    inline void clearU8Thetotalnumberofchargingtype();

    /**
     * Checks whether the field "u8Thetotalnumberofchargingtype" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Thetotalnumberofchargingtype()). Otherwise it will return false.
     */
    inline bool hasU8Thetotalnumberofchargingtype () const;

    /**
     * Returns the value of the member "u8Thetotalnumberofchargingtype".
     *
     * If the meaning of "u8Thetotalnumberofchargingtype" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Thetotalnumberofchargingtype"
     */
    inline uint8 getU8Thetotalnumberofchargingtype () const;

    /**
     * Sets the value of the member "u8Thetotalnumberofchargingtype".
     *
     * If the meaning of "u8Thetotalnumberofchargingtype" isn't clear, then there should be a description here.
     *
     * @param u8Thetotalnumberofchargingtype The value which will be set
     */
    inline void setU8Thetotalnumberofchargingtype (uint8 u8Thetotalnumberofchargingtype_);

    // API of field "u8Userrestriction"

    static const int kU8Userrestriction = 42;

    /**
     * Clears the field "u8Userrestriction".
     *
     * The field will be set to its default value. The hasU8Userrestriction()
     * method will return false.
     */
    inline void clearU8Userrestriction();

    /**
     * Checks whether the field "u8Userrestriction" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Userrestriction()). Otherwise it will return false.
     */
    inline bool hasU8Userrestriction () const;

    /**
     * Returns the value of the member "u8Userrestriction".
     *
     * If the meaning of "u8Userrestriction" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Userrestriction"
     */
    inline uint8 getU8Userrestriction () const;

    /**
     * Sets the value of the member "u8Userrestriction".
     *
     * If the meaning of "u8Userrestriction" isn't clear, then there should be a description here.
     *
     * @param u8Userrestriction The value which will be set
     */
    inline void setU8Userrestriction (uint8 u8Userrestriction_);

    static const T_tcu_charging_spot_data &getDefaultInstance();

private:

    inline void set_has_Location ();

    inline void clear_has_Location ();

    inline void set_has_strAreaCode1 ();

    inline void clear_has_strAreaCode1 ();

    inline void set_has_strAreaCode2 ();

    inline void clear_has_strAreaCode2 ();

    inline void set_has_strAreaCode3 ();

    inline void clear_has_strAreaCode3 ();

    inline void set_has_strAreaCode4 ();

    inline void clear_has_strAreaCode4 ();

    inline void set_has_strAreaCode5 ();

    inline void clear_has_strAreaCode5 ();

    inline void set_has_strAreaCode6 ();

    inline void clear_has_strAreaCode6 ();

    inline void set_has_strAreaCode7 ();

    inline void clear_has_strAreaCode7 ();

    inline void set_has_strAreaCode8 ();

    inline void clear_has_strAreaCode8 ();

    inline void set_has_strPOIName ();

    inline void clear_has_strPOIName ();

    inline void set_has_strStreetAndHouseNo ();

    inline void clear_has_strStreetAndHouseNo ();

    inline void set_has_strTelephonenumber ();

    inline void clear_has_strTelephonenumber ();

    inline void set_has_u16Categorycode ();

    inline void clear_has_u16Categorycode ();

    inline void set_has_u16ClosedhourInformation ();

    inline void clear_has_u16ClosedhourInformation ();

    inline void set_has_u16OpeninghourInformation ();

    inline void clear_has_u16OpeninghourInformation ();

    inline void set_has_u16Parkingnumber ();

    inline void clear_has_u16Parkingnumber ();

    inline void set_has_u16Paymenttypeinformation ();

    inline void clear_has_u16Paymenttypeinformation ();

    inline void set_has_u16Sizeofdetailinformation ();

    inline void clear_has_u16Sizeofdetailinformation ();

    inline void set_has_u16Subcategorycode ();

    inline void clear_has_u16Subcategorycode ();

    inline void set_has_u32POIID ();

    inline void clear_has_u32POIID ();

    inline void set_has_u32UserrestrictionID ();

    inline void clear_has_u32UserrestrictionID ();

    inline void set_has_u8_24hoursadayinformation ();

    inline void clear_has_u8_24hoursadayinformation ();

    inline void set_has_u8Businessdayoftheweekinformation ();

    inline void clear_has_u8Businessdayoftheweekinformation ();

    inline void set_has_u8Chargingfeeinformation ();

    inline void clear_has_u8Chargingfeeinformation ();

    inline void set_has_u8Chargingtype ();

    inline void clear_has_u8Chargingtype ();

    inline void set_has_u8Detailsinformation ();

    inline void clear_has_u8Detailsinformation ();

    inline void set_has_u8Entranceinformation ();

    inline void clear_has_u8Entranceinformation ();

    inline void set_has_u8Expresswaygeneraltype ();

    inline void clear_has_u8Expresswaygeneraltype ();

    inline void set_has_u8Fixedvalue1 ();

    inline void clear_has_u8Fixedvalue1 ();

    inline void set_has_u8Fixedvalue2 ();

    inline void clear_has_u8Fixedvalue2 ();

    inline void set_has_u8Informationreliability ();

    inline void clear_has_u8Informationreliability ();

    inline void set_has_u8Installationfacilityinformation ();

    inline void clear_has_u8Installationfacilityinformation ();

    inline void set_has_u8Nearthefacilityinformation ();

    inline void clear_has_u8Nearthefacilityinformation ();

    inline void set_has_u8Officehoursunknowninformation ();

    inline void clear_has_u8Officehoursunknowninformation ();

    inline void set_has_u8Partnersfacilityinformation ();

    inline void clear_has_u8Partnersfacilityinformation ();

    inline void set_has_u8SizeOfPOIName ();

    inline void clear_has_u8SizeOfPOIName ();

    inline void set_has_u8SizeOfStreetAndHouseNo ();

    inline void clear_has_u8SizeOfStreetAndHouseNo ();

    inline void set_has_u8SizeOfTelephonenumber ();

    inline void clear_has_u8SizeOfTelephonenumber ();

    inline void set_has_u8Thenumberofentranceinformation ();

    inline void clear_has_u8Thenumberofentranceinformation ();

    inline void set_has_u8Thenumberofinstallationfacilityinformation ();

    inline void clear_has_u8Thenumberofinstallationfacilityinformation ();

    inline void set_has_u8Thenumberofpartnersfacilityinformation ();

    inline void clear_has_u8Thenumberofpartnersfacilityinformation ();

    inline void set_has_u8Thetotalnumberofchargingtype ();

    inline void clear_has_u8Thetotalnumberofchargingtype ();

    inline void set_has_u8Userrestriction ();

    inline void clear_has_u8Userrestriction ();

    uint32 _has_bits_[ (43 + 31) / 32];

    T_usb_tcu_Location _Location;

    ::std::string _strAreaCode1;

    ::std::string _strAreaCode2;

    ::std::string _strAreaCode3;

    ::std::string _strAreaCode4;

    ::std::string _strAreaCode5;

    ::std::string _strAreaCode6;

    ::std::string _strAreaCode7;

    ::std::string _strAreaCode8;

    ::std::string _strPOIName;

    ::std::string _strStreetAndHouseNo;

    ::std::string _strTelephonenumber;

    uint16 _u16Categorycode;

    uint16 _u16ClosedhourInformation;

    uint16 _u16OpeninghourInformation;

    uint16 _u16Parkingnumber;

    uint16 _u16Paymenttypeinformation;

    uint16 _u16Sizeofdetailinformation;

    uint16 _u16Subcategorycode;

    uint32 _u32POIID;

    uint32 _u32UserrestrictionID;

    uint8 _u8_24hoursadayinformation;

    uint8 _u8Businessdayoftheweekinformation;

    uint8 _u8Chargingfeeinformation;

    uint8 _u8Chargingtype;

    uint8 _u8Detailsinformation;

    uint8 _u8Entranceinformation;

    uint8 _u8Expresswaygeneraltype;

    uint8 _u8Fixedvalue1;

    uint8 _u8Fixedvalue2;

    uint8 _u8Informationreliability;

    uint8 _u8Installationfacilityinformation;

    uint8 _u8Nearthefacilityinformation;

    uint8 _u8Officehoursunknowninformation;

    uint8 _u8Partnersfacilityinformation;

    uint8 _u8SizeOfPOIName;

    uint8 _u8SizeOfStreetAndHouseNo;

    uint8 _u8SizeOfTelephonenumber;

    uint8 _u8Thenumberofentranceinformation;

    uint8 _u8Thenumberofinstallationfacilityinformation;

    uint8 _u8Thenumberofpartnersfacilityinformation;

    uint8 _u8Thetotalnumberofchargingtype;

    uint8 _u8Userrestriction;

};

/**
 * Charging spot data
 */
class T_tcu_response_charging_spot_data_result {
public:

    /**
     * Default constructor
     */
    inline  T_tcu_response_charging_spot_data_result ();

    /**
     * Copy constructor
     */
    inline  T_tcu_response_charging_spot_data_result (const T_tcu_response_charging_spot_data_result &rhs);

    /**
     * All fields constructor
     */
    inline  T_tcu_response_charging_spot_data_result (const T_tcu_charging_spot_data& ChargingSpotData_);

    /**
     * Destructor
     */
    inline  ~T_tcu_response_charging_spot_data_result();

    /**
     * Assignment operator
     */
    inline T_tcu_response_charging_spot_data_result& operator = (const T_tcu_response_charging_spot_data_result& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_tcu_response_charging_spot_data_result& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_tcu_response_charging_spot_data_result& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_tcu_response_charging_spot_data_result& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_tcu_response_charging_spot_data_result& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ChargingSpotData"

    static const int kChargingSpotData = 0;

    /**
     * Clears the field "ChargingSpotData".
     *
     * The field will be set to its default value. The hasChargingSpotData()
     * method will return false.
     */
    inline void clearChargingSpotData();

    /**
     * Checks whether the field "ChargingSpotData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChargingSpotData()). Otherwise it will return false.
     */
    inline bool hasChargingSpotData () const;

    /**
     * Returns the value of the member "ChargingSpotData".
     *
     * Charging Station data
     *
     * @return The value of the field "ChargingSpotData"
     */
    inline const T_tcu_charging_spot_data& getChargingSpotData () const;

    /**
     * Retrieves the value of the field "ChargingSpotData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ChargingSpotData".
     */
    inline T_tcu_charging_spot_data& getChargingSpotDataMutable ();

    /**
     * Sets the value of the member "ChargingSpotData".
     *
     * Charging Station data
     *
     * @param ChargingSpotData The value which will be set
     */
    inline void setChargingSpotData (const T_tcu_charging_spot_data& ChargingSpotData_);

    static const T_tcu_response_charging_spot_data_result &getDefaultInstance();

private:

    inline void set_has_ChargingSpotData ();

    inline void clear_has_ChargingSpotData ();

    uint32 _has_bits_[ (1 + 31) / 32];

    T_tcu_charging_spot_data _ChargingSpotData;

};

/**
 * If the meaning of "T_tcu_charging_stations_info" isn't clear, then there should be a description here.
 */
class T_tcu_charging_stations_info {
public:

    /**
     * Default constructor
     */
    inline  T_tcu_charging_stations_info ();

    /**
     * Copy constructor
     */
    inline  T_tcu_charging_stations_info (const T_tcu_charging_stations_info &rhs);

    /**
     * All fields constructor
     */
    inline  T_tcu_charging_stations_info (const T_usb_tcu_Location& Location_, uint32 u32POIID_, uint32 u32POIIDVersion_);

    /**
     * Destructor
     */
    inline  ~T_tcu_charging_stations_info();

    /**
     * Assignment operator
     */
    inline T_tcu_charging_stations_info& operator = (const T_tcu_charging_stations_info& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_tcu_charging_stations_info& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_tcu_charging_stations_info& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_tcu_charging_stations_info& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_tcu_charging_stations_info& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Location"

    static const int kLocation = 0;

    /**
     * Clears the field "Location".
     *
     * The field will be set to its default value. The hasLocation()
     * method will return false.
     */
    inline void clearLocation();

    /**
     * Checks whether the field "Location" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLocation()). Otherwise it will return false.
     */
    inline bool hasLocation () const;

    /**
     * Returns the value of the member "Location".
     *
     * If the meaning of "Location" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Location"
     */
    inline const T_usb_tcu_Location& getLocation () const;

    /**
     * Retrieves the value of the field "Location" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Location".
     */
    inline T_usb_tcu_Location& getLocationMutable ();

    /**
     * Sets the value of the member "Location".
     *
     * If the meaning of "Location" isn't clear, then there should be a description here.
     *
     * @param Location The value which will be set
     */
    inline void setLocation (const T_usb_tcu_Location& Location_);

    // API of field "u32POIID"

    static const int kU32POIID = 1;

    /**
     * Clears the field "u32POIID".
     *
     * The field will be set to its default value. The hasU32POIID()
     * method will return false.
     */
    inline void clearU32POIID();

    /**
     * Checks whether the field "u32POIID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32POIID()). Otherwise it will return false.
     */
    inline bool hasU32POIID () const;

    /**
     * Returns the value of the member "u32POIID".
     *
     * If the meaning of "u32POIID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32POIID"
     */
    inline uint32 getU32POIID () const;

    /**
     * Sets the value of the member "u32POIID".
     *
     * If the meaning of "u32POIID" isn't clear, then there should be a description here.
     *
     * @param u32POIID The value which will be set
     */
    inline void setU32POIID (uint32 u32POIID_);

    // API of field "u32POIIDVersion"

    static const int kU32POIIDVersion = 2;

    /**
     * Clears the field "u32POIIDVersion".
     *
     * The field will be set to its default value. The hasU32POIIDVersion()
     * method will return false.
     */
    inline void clearU32POIIDVersion();

    /**
     * Checks whether the field "u32POIIDVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32POIIDVersion()). Otherwise it will return false.
     */
    inline bool hasU32POIIDVersion () const;

    /**
     * Returns the value of the member "u32POIIDVersion".
     *
     * If the meaning of "u32POIIDVersion" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32POIIDVersion"
     */
    inline uint32 getU32POIIDVersion () const;

    /**
     * Sets the value of the member "u32POIIDVersion".
     *
     * If the meaning of "u32POIIDVersion" isn't clear, then there should be a description here.
     *
     * @param u32POIIDVersion The value which will be set
     */
    inline void setU32POIIDVersion (uint32 u32POIIDVersion_);

    static const T_tcu_charging_stations_info &getDefaultInstance();

private:

    inline void set_has_Location ();

    inline void clear_has_Location ();

    inline void set_has_u32POIID ();

    inline void clear_has_u32POIID ();

    inline void set_has_u32POIIDVersion ();

    inline void clear_has_u32POIIDVersion ();

    uint32 _has_bits_[ (3 + 31) / 32];

    T_usb_tcu_Location _Location;

    uint32 _u32POIID;

    uint32 _u32POIIDVersion;

};

/**
 * Charging Stations List
 */
class T_tcu_charging_stations_data {
public:

    /**
     * Default constructor
     */
    inline  T_tcu_charging_stations_data ();

    /**
     * Copy constructor
     */
    inline  T_tcu_charging_stations_data (const T_tcu_charging_stations_data &rhs);

    /**
     * All fields constructor
     */
    inline  T_tcu_charging_stations_data (uint32 u32NumberOfPOIID_, uint32 u32POIDataSetIdentificationID_, uint8 u8POIDataSetIdentificationIDType_, const ::std::vector< T_tcu_charging_stations_info >& ChargingStationsInfoList_);

    /**
     * Destructor
     */
    inline  ~T_tcu_charging_stations_data();

    /**
     * Assignment operator
     */
    inline T_tcu_charging_stations_data& operator = (const T_tcu_charging_stations_data& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_tcu_charging_stations_data& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_tcu_charging_stations_data& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_tcu_charging_stations_data& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_tcu_charging_stations_data& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32NumberOfPOIID"

    static const int kU32NumberOfPOIID = 0;

    /**
     * Clears the field "u32NumberOfPOIID".
     *
     * The field will be set to its default value. The hasU32NumberOfPOIID()
     * method will return false.
     */
    inline void clearU32NumberOfPOIID();

    /**
     * Checks whether the field "u32NumberOfPOIID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32NumberOfPOIID()). Otherwise it will return false.
     */
    inline bool hasU32NumberOfPOIID () const;

    /**
     * Returns the value of the member "u32NumberOfPOIID".
     *
     * Number of POI ID
     *
     * @return The value of the field "u32NumberOfPOIID"
     */
    inline uint32 getU32NumberOfPOIID () const;

    /**
     * Sets the value of the member "u32NumberOfPOIID".
     *
     * Number of POI ID
     *
     * @param u32NumberOfPOIID The value which will be set
     */
    inline void setU32NumberOfPOIID (uint32 u32NumberOfPOIID_);

    // API of field "u32POIDataSetIdentificationID"

    static const int kU32POIDataSetIdentificationID = 1;

    /**
     * Clears the field "u32POIDataSetIdentificationID".
     *
     * The field will be set to its default value. The hasU32POIDataSetIdentificationID()
     * method will return false.
     */
    inline void clearU32POIDataSetIdentificationID();

    /**
     * Checks whether the field "u32POIDataSetIdentificationID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32POIDataSetIdentificationID()). Otherwise it will return false.
     */
    inline bool hasU32POIDataSetIdentificationID () const;

    /**
     * Returns the value of the member "u32POIDataSetIdentificationID".
     *
     * ID for POI Dataset Identification
     *
     * @return The value of the field "u32POIDataSetIdentificationID"
     */
    inline uint32 getU32POIDataSetIdentificationID () const;

    /**
     * Sets the value of the member "u32POIDataSetIdentificationID".
     *
     * ID for POI Dataset Identification
     *
     * @param u32POIDataSetIdentificationID The value which will be set
     */
    inline void setU32POIDataSetIdentificationID (uint32 u32POIDataSetIdentificationID_);

    // API of field "u8POIDataSetIdentificationIDType"

    static const int kU8POIDataSetIdentificationIDType = 2;

    /**
     * Clears the field "u8POIDataSetIdentificationIDType".
     *
     * The field will be set to its default value. The hasU8POIDataSetIdentificationIDType()
     * method will return false.
     */
    inline void clearU8POIDataSetIdentificationIDType();

    /**
     * Checks whether the field "u8POIDataSetIdentificationIDType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8POIDataSetIdentificationIDType()). Otherwise it will return false.
     */
    inline bool hasU8POIDataSetIdentificationIDType () const;

    /**
     * Returns the value of the member "u8POIDataSetIdentificationIDType".
     *
     * ID type for POI Dataset Identification
     *
     * @return The value of the field "u8POIDataSetIdentificationIDType"
     */
    inline uint8 getU8POIDataSetIdentificationIDType () const;

    /**
     * Sets the value of the member "u8POIDataSetIdentificationIDType".
     *
     * ID type for POI Dataset Identification
     *
     * @param u8POIDataSetIdentificationIDType The value which will be set
     */
    inline void setU8POIDataSetIdentificationIDType (uint8 u8POIDataSetIdentificationIDType_);

    // API of field "ChargingStationsInfoList"

    static const int kChargingStationsInfoList = 3;

    /**
     * Clears the field "ChargingStationsInfoList".
     *
     * The field will be set to its default value. The hasChargingStationsInfoList()
     * method will return false.
     */
    inline void clearChargingStationsInfoList();

    /**
     * Checks whether the field "ChargingStationsInfoList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChargingStationsInfoList()). Otherwise it will return false.
     */
    inline bool hasChargingStationsInfoList () const;

    /**
     * Returns the value of the member "ChargingStationsInfoList".
     *
     * ChargingStationsInfoList
     *
     * @return The value of the field "ChargingStationsInfoList"
     */
    inline const ::std::vector< T_tcu_charging_stations_info >& getChargingStationsInfoList () const;

    /**
     * Retrieves the value of the field "ChargingStationsInfoList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ChargingStationsInfoList".
     */
    inline ::std::vector< T_tcu_charging_stations_info >& getChargingStationsInfoListMutable ();

    /**
     * Sets the value of the member "ChargingStationsInfoList".
     *
     * ChargingStationsInfoList
     *
     * @param ChargingStationsInfoList The value which will be set
     */
    inline void setChargingStationsInfoList (const ::std::vector< T_tcu_charging_stations_info >& ChargingStationsInfoList_);

    static const T_tcu_charging_stations_data &getDefaultInstance();

private:

    static const ::std::vector< T_tcu_charging_stations_info >& getT_tcu_charging_stations_infoList_DefaultInstance ();

    inline void set_has_u32NumberOfPOIID ();

    inline void clear_has_u32NumberOfPOIID ();

    inline void set_has_u32POIDataSetIdentificationID ();

    inline void clear_has_u32POIDataSetIdentificationID ();

    inline void set_has_u8POIDataSetIdentificationIDType ();

    inline void clear_has_u8POIDataSetIdentificationIDType ();

    inline void set_has_ChargingStationsInfoList ();

    inline void clear_has_ChargingStationsInfoList ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _u32NumberOfPOIID;

    uint32 _u32POIDataSetIdentificationID;

    uint8 _u8POIDataSetIdentificationIDType;

    ::std::vector< T_tcu_charging_stations_info > _ChargingStationsInfoList;

};

/**
 * Charging Stations List
 */
class T_tcu_response_charging_stations_list_result {
public:

    /**
     * Default constructor
     */
    inline  T_tcu_response_charging_stations_list_result ();

    /**
     * Copy constructor
     */
    inline  T_tcu_response_charging_stations_list_result (const T_tcu_response_charging_stations_list_result &rhs);

    /**
     * All fields constructor
     */
    inline  T_tcu_response_charging_stations_list_result (const T_tcu_charging_stations_data& ChargingStationsData_);

    /**
     * Destructor
     */
    inline  ~T_tcu_response_charging_stations_list_result();

    /**
     * Assignment operator
     */
    inline T_tcu_response_charging_stations_list_result& operator = (const T_tcu_response_charging_stations_list_result& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_tcu_response_charging_stations_list_result& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_tcu_response_charging_stations_list_result& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_tcu_response_charging_stations_list_result& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_tcu_response_charging_stations_list_result& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ChargingStationsData"

    static const int kChargingStationsData = 0;

    /**
     * Clears the field "ChargingStationsData".
     *
     * The field will be set to its default value. The hasChargingStationsData()
     * method will return false.
     */
    inline void clearChargingStationsData();

    /**
     * Checks whether the field "ChargingStationsData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChargingStationsData()). Otherwise it will return false.
     */
    inline bool hasChargingStationsData () const;

    /**
     * Returns the value of the member "ChargingStationsData".
     *
     * Charging Stations Data
     *
     * @return The value of the field "ChargingStationsData"
     */
    inline const T_tcu_charging_stations_data& getChargingStationsData () const;

    /**
     * Retrieves the value of the field "ChargingStationsData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ChargingStationsData".
     */
    inline T_tcu_charging_stations_data& getChargingStationsDataMutable ();

    /**
     * Sets the value of the member "ChargingStationsData".
     *
     * Charging Stations Data
     *
     * @param ChargingStationsData The value which will be set
     */
    inline void setChargingStationsData (const T_tcu_charging_stations_data& ChargingStationsData_);

    static const T_tcu_response_charging_stations_list_result &getDefaultInstance();

private:

    inline void set_has_ChargingStationsData ();

    inline void clear_has_ChargingStationsData ();

    uint32 _has_bits_[ (1 + 31) / 32];

    T_tcu_charging_stations_data _ChargingStationsData;

};

/**
 * If the meaning of "T_tcu_vacancy_stations_info" isn't clear, then there should be a description here.
 */
class T_tcu_vacancy_stations_info {
public:

    /**
     * Default constructor
     */
    inline  T_tcu_vacancy_stations_info ();

    /**
     * Copy constructor
     */
    inline  T_tcu_vacancy_stations_info (const T_tcu_vacancy_stations_info &rhs);

    /**
     * All fields constructor
     */
    inline  T_tcu_vacancy_stations_info (const T_usb_tcu_Location& Location_, uint32 u32POIID_);

    /**
     * Destructor
     */
    inline  ~T_tcu_vacancy_stations_info();

    /**
     * Assignment operator
     */
    inline T_tcu_vacancy_stations_info& operator = (const T_tcu_vacancy_stations_info& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_tcu_vacancy_stations_info& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_tcu_vacancy_stations_info& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_tcu_vacancy_stations_info& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_tcu_vacancy_stations_info& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Location"

    static const int kLocation = 0;

    /**
     * Clears the field "Location".
     *
     * The field will be set to its default value. The hasLocation()
     * method will return false.
     */
    inline void clearLocation();

    /**
     * Checks whether the field "Location" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLocation()). Otherwise it will return false.
     */
    inline bool hasLocation () const;

    /**
     * Returns the value of the member "Location".
     *
     * If the meaning of "Location" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Location"
     */
    inline const T_usb_tcu_Location& getLocation () const;

    /**
     * Retrieves the value of the field "Location" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Location".
     */
    inline T_usb_tcu_Location& getLocationMutable ();

    /**
     * Sets the value of the member "Location".
     *
     * If the meaning of "Location" isn't clear, then there should be a description here.
     *
     * @param Location The value which will be set
     */
    inline void setLocation (const T_usb_tcu_Location& Location_);

    // API of field "u32POIID"

    static const int kU32POIID = 1;

    /**
     * Clears the field "u32POIID".
     *
     * The field will be set to its default value. The hasU32POIID()
     * method will return false.
     */
    inline void clearU32POIID();

    /**
     * Checks whether the field "u32POIID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32POIID()). Otherwise it will return false.
     */
    inline bool hasU32POIID () const;

    /**
     * Returns the value of the member "u32POIID".
     *
     * If the meaning of "u32POIID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32POIID"
     */
    inline uint32 getU32POIID () const;

    /**
     * Sets the value of the member "u32POIID".
     *
     * If the meaning of "u32POIID" isn't clear, then there should be a description here.
     *
     * @param u32POIID The value which will be set
     */
    inline void setU32POIID (uint32 u32POIID_);

    static const T_tcu_vacancy_stations_info &getDefaultInstance();

private:

    inline void set_has_Location ();

    inline void clear_has_Location ();

    inline void set_has_u32POIID ();

    inline void clear_has_u32POIID ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_usb_tcu_Location _Location;

    uint32 _u32POIID;

};

/**
 * Vacancy Stations List
 */
class T_tcu_response_vacancy_stations_list_result {
public:

    /**
     * Default constructor
     */
    inline  T_tcu_response_vacancy_stations_list_result ();

    /**
     * Copy constructor
     */
    inline  T_tcu_response_vacancy_stations_list_result (const T_tcu_response_vacancy_stations_list_result &rhs);

    /**
     * All fields constructor
     */
    inline  T_tcu_response_vacancy_stations_list_result (const T_tcu_vacancy_stations_data& VacancyStationsData_);

    /**
     * Destructor
     */
    inline  ~T_tcu_response_vacancy_stations_list_result();

    /**
     * Assignment operator
     */
    inline T_tcu_response_vacancy_stations_list_result& operator = (const T_tcu_response_vacancy_stations_list_result& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_tcu_response_vacancy_stations_list_result& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_tcu_response_vacancy_stations_list_result& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_tcu_response_vacancy_stations_list_result& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_tcu_response_vacancy_stations_list_result& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "VacancyStationsData"

    static const int kVacancyStationsData = 0;

    /**
     * Clears the field "VacancyStationsData".
     *
     * The field will be set to its default value. The hasVacancyStationsData()
     * method will return false.
     */
    inline void clearVacancyStationsData();

    /**
     * Checks whether the field "VacancyStationsData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVacancyStationsData()). Otherwise it will return false.
     */
    inline bool hasVacancyStationsData () const;

    /**
     * Returns the value of the member "VacancyStationsData".
     *
     * Vacancy Stations Data
     *
     * @return The value of the field "VacancyStationsData"
     */
    inline const T_tcu_vacancy_stations_data& getVacancyStationsData () const;

    /**
     * Retrieves the value of the field "VacancyStationsData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "VacancyStationsData".
     */
    inline T_tcu_vacancy_stations_data& getVacancyStationsDataMutable ();

    /**
     * Sets the value of the member "VacancyStationsData".
     *
     * Vacancy Stations Data
     *
     * @param VacancyStationsData The value which will be set
     */
    inline void setVacancyStationsData (const T_tcu_vacancy_stations_data& VacancyStationsData_);

    static const T_tcu_response_vacancy_stations_list_result &getDefaultInstance();

private:

    static const ::std::vector< T_tcu_vacancy_stations_info >& getT_tcu_vacancy_stations_infoList_DefaultInstance ();

    inline void set_has_VacancyStationsData ();

    inline void clear_has_VacancyStationsData ();

    uint32 _has_bits_[ (1 + 31) / 32];

    T_tcu_vacancy_stations_data _VacancyStationsData;

};

/**
 * If the meaning of "T_tcu_vacancy_spot_data" isn't clear, then there should be a description here.
 */
class T_tcu_vacancy_spot_data {
public:

    /**
     * Default constructor
     */
    inline  T_tcu_vacancy_spot_data ();

    /**
     * Copy constructor
     */
    inline  T_tcu_vacancy_spot_data (const T_tcu_vacancy_spot_data &rhs);

    /**
     * All fields constructor
     */
    inline  T_tcu_vacancy_spot_data (const T_usb_tcu_Location& Location_, const ::std::string& strAreaCode1_, const ::std::string& strAreaCode2_, const ::std::string& strAreaCode3_, const ::std::string& strAreaCode4_, const ::std::string& strAreaCode5_, const ::std::string& strAreaCode6_, const ::std::string& strAreaCode7_, const ::std::string& strAreaCode8_, const ::std::string& strPOIName_, const ::std::string& strStreetAndHouseNo_, const ::std::string& strTelephonenumber_, uint16 u16Categorycode_, uint16 u16ClosedhourInformation_, uint16 u16OpeninghourInformation_, uint16 u16Parkingnumber_, uint16 u16Paymenttypeinformation_, uint16 u16Sizeofdetailinformation_, uint16 u16Subcategorycode_, uint32 u32POIID_, uint32 u32UserrestrictionID_, uint8 u8_24hoursadayinformation_, uint8 u8Businessdayoftheweekinformation_, uint8 u8Chargingfeeinformation_, uint8 u8Chargingtype_, uint8 u8Detailsinformation_, uint8 u8Entranceinformation_, uint8 u8Expresswaygeneraltype_, uint8 u8Fixedvalue1_, uint8 u8Fixedvalue2_, uint8 u8Informationreliability_, uint8 u8Installationfacilityinformation_, uint8 u8Nearthefacilityinformation_, uint8 u8Officehoursunknowninformation_, uint8 u8Partnersfacilityinformation_, uint8 u8SizeOfPOIName_, uint8 u8SizeOfStreetAndHouseNo_, uint8 u8SizeOfTelephonenumber_, uint8 u8Thenumberofentranceinformation_, uint8 u8Thenumberofinstallationfacilityinformation_, uint8 u8Thenumberofpartnersfacilityinformation_, uint8 u8Thetotalnumberofchargingtype_, uint8 u8Userrestriction_);

    /**
     * Destructor
     */
    inline  ~T_tcu_vacancy_spot_data();

    /**
     * Assignment operator
     */
    inline T_tcu_vacancy_spot_data& operator = (const T_tcu_vacancy_spot_data& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_tcu_vacancy_spot_data& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_tcu_vacancy_spot_data& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_tcu_vacancy_spot_data& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_tcu_vacancy_spot_data& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Location"

    static const int kLocation = 0;

    /**
     * Clears the field "Location".
     *
     * The field will be set to its default value. The hasLocation()
     * method will return false.
     */
    inline void clearLocation();

    /**
     * Checks whether the field "Location" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLocation()). Otherwise it will return false.
     */
    inline bool hasLocation () const;

    /**
     * Returns the value of the member "Location".
     *
     * If the meaning of "Location" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Location"
     */
    inline const T_usb_tcu_Location& getLocation () const;

    /**
     * Retrieves the value of the field "Location" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Location".
     */
    inline T_usb_tcu_Location& getLocationMutable ();

    /**
     * Sets the value of the member "Location".
     *
     * If the meaning of "Location" isn't clear, then there should be a description here.
     *
     * @param Location The value which will be set
     */
    inline void setLocation (const T_usb_tcu_Location& Location_);

    // API of field "strAreaCode1"

    static const int kStrAreaCode1 = 1;

    /**
     * Clears the field "strAreaCode1".
     *
     * The field will be set to its default value. The hasStrAreaCode1()
     * method will return false.
     */
    inline void clearStrAreaCode1();

    /**
     * Checks whether the field "strAreaCode1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrAreaCode1()). Otherwise it will return false.
     */
    inline bool hasStrAreaCode1 () const;

    /**
     * Returns the value of the member "strAreaCode1".
     *
     * AreaCode1
     *
     * @return The value of the field "strAreaCode1"
     */
    inline const ::std::string& getStrAreaCode1 () const;

    /**
     * Retrieves the value of the field "strAreaCode1" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strAreaCode1".
     */
    inline ::std::string& getStrAreaCode1Mutable ();

    /**
     * Sets the value of the member "strAreaCode1".
     *
     * AreaCode1
     *
     * @param strAreaCode1 The value which will be set
     */
    inline void setStrAreaCode1 (const ::std::string& strAreaCode1_);

    /**
     * Sets the value of the member "strAreaCode1".
     *
     * AreaCode1
     *
     * @param strAreaCode1 The value which will be set
     */
    inline void setStrAreaCode1 (const char* strAreaCode1_);

    /**
     * Sets the value of the member "strAreaCode1".
     *
     * AreaCode1
     *
     * @param strAreaCode1 The value which will be set
     */
    inline void setStrAreaCode1 (const char* value, size_t size);

    // API of field "strAreaCode2"

    static const int kStrAreaCode2 = 2;

    /**
     * Clears the field "strAreaCode2".
     *
     * The field will be set to its default value. The hasStrAreaCode2()
     * method will return false.
     */
    inline void clearStrAreaCode2();

    /**
     * Checks whether the field "strAreaCode2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrAreaCode2()). Otherwise it will return false.
     */
    inline bool hasStrAreaCode2 () const;

    /**
     * Returns the value of the member "strAreaCode2".
     *
     * AreaCode2
     *
     * @return The value of the field "strAreaCode2"
     */
    inline const ::std::string& getStrAreaCode2 () const;

    /**
     * Retrieves the value of the field "strAreaCode2" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strAreaCode2".
     */
    inline ::std::string& getStrAreaCode2Mutable ();

    /**
     * Sets the value of the member "strAreaCode2".
     *
     * AreaCode2
     *
     * @param strAreaCode2 The value which will be set
     */
    inline void setStrAreaCode2 (const ::std::string& strAreaCode2_);

    /**
     * Sets the value of the member "strAreaCode2".
     *
     * AreaCode2
     *
     * @param strAreaCode2 The value which will be set
     */
    inline void setStrAreaCode2 (const char* strAreaCode2_);

    /**
     * Sets the value of the member "strAreaCode2".
     *
     * AreaCode2
     *
     * @param strAreaCode2 The value which will be set
     */
    inline void setStrAreaCode2 (const char* value, size_t size);

    // API of field "strAreaCode3"

    static const int kStrAreaCode3 = 3;

    /**
     * Clears the field "strAreaCode3".
     *
     * The field will be set to its default value. The hasStrAreaCode3()
     * method will return false.
     */
    inline void clearStrAreaCode3();

    /**
     * Checks whether the field "strAreaCode3" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrAreaCode3()). Otherwise it will return false.
     */
    inline bool hasStrAreaCode3 () const;

    /**
     * Returns the value of the member "strAreaCode3".
     *
     * AreaCode3
     *
     * @return The value of the field "strAreaCode3"
     */
    inline const ::std::string& getStrAreaCode3 () const;

    /**
     * Retrieves the value of the field "strAreaCode3" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strAreaCode3".
     */
    inline ::std::string& getStrAreaCode3Mutable ();

    /**
     * Sets the value of the member "strAreaCode3".
     *
     * AreaCode3
     *
     * @param strAreaCode3 The value which will be set
     */
    inline void setStrAreaCode3 (const ::std::string& strAreaCode3_);

    /**
     * Sets the value of the member "strAreaCode3".
     *
     * AreaCode3
     *
     * @param strAreaCode3 The value which will be set
     */
    inline void setStrAreaCode3 (const char* strAreaCode3_);

    /**
     * Sets the value of the member "strAreaCode3".
     *
     * AreaCode3
     *
     * @param strAreaCode3 The value which will be set
     */
    inline void setStrAreaCode3 (const char* value, size_t size);

    // API of field "strAreaCode4"

    static const int kStrAreaCode4 = 4;

    /**
     * Clears the field "strAreaCode4".
     *
     * The field will be set to its default value. The hasStrAreaCode4()
     * method will return false.
     */
    inline void clearStrAreaCode4();

    /**
     * Checks whether the field "strAreaCode4" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrAreaCode4()). Otherwise it will return false.
     */
    inline bool hasStrAreaCode4 () const;

    /**
     * Returns the value of the member "strAreaCode4".
     *
     * AreaCode4
     *
     * @return The value of the field "strAreaCode4"
     */
    inline const ::std::string& getStrAreaCode4 () const;

    /**
     * Retrieves the value of the field "strAreaCode4" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strAreaCode4".
     */
    inline ::std::string& getStrAreaCode4Mutable ();

    /**
     * Sets the value of the member "strAreaCode4".
     *
     * AreaCode4
     *
     * @param strAreaCode4 The value which will be set
     */
    inline void setStrAreaCode4 (const ::std::string& strAreaCode4_);

    /**
     * Sets the value of the member "strAreaCode4".
     *
     * AreaCode4
     *
     * @param strAreaCode4 The value which will be set
     */
    inline void setStrAreaCode4 (const char* strAreaCode4_);

    /**
     * Sets the value of the member "strAreaCode4".
     *
     * AreaCode4
     *
     * @param strAreaCode4 The value which will be set
     */
    inline void setStrAreaCode4 (const char* value, size_t size);

    // API of field "strAreaCode5"

    static const int kStrAreaCode5 = 5;

    /**
     * Clears the field "strAreaCode5".
     *
     * The field will be set to its default value. The hasStrAreaCode5()
     * method will return false.
     */
    inline void clearStrAreaCode5();

    /**
     * Checks whether the field "strAreaCode5" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrAreaCode5()). Otherwise it will return false.
     */
    inline bool hasStrAreaCode5 () const;

    /**
     * Returns the value of the member "strAreaCode5".
     *
     * AreaCode5
     *
     * @return The value of the field "strAreaCode5"
     */
    inline const ::std::string& getStrAreaCode5 () const;

    /**
     * Retrieves the value of the field "strAreaCode5" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strAreaCode5".
     */
    inline ::std::string& getStrAreaCode5Mutable ();

    /**
     * Sets the value of the member "strAreaCode5".
     *
     * AreaCode5
     *
     * @param strAreaCode5 The value which will be set
     */
    inline void setStrAreaCode5 (const ::std::string& strAreaCode5_);

    /**
     * Sets the value of the member "strAreaCode5".
     *
     * AreaCode5
     *
     * @param strAreaCode5 The value which will be set
     */
    inline void setStrAreaCode5 (const char* strAreaCode5_);

    /**
     * Sets the value of the member "strAreaCode5".
     *
     * AreaCode5
     *
     * @param strAreaCode5 The value which will be set
     */
    inline void setStrAreaCode5 (const char* value, size_t size);

    // API of field "strAreaCode6"

    static const int kStrAreaCode6 = 6;

    /**
     * Clears the field "strAreaCode6".
     *
     * The field will be set to its default value. The hasStrAreaCode6()
     * method will return false.
     */
    inline void clearStrAreaCode6();

    /**
     * Checks whether the field "strAreaCode6" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrAreaCode6()). Otherwise it will return false.
     */
    inline bool hasStrAreaCode6 () const;

    /**
     * Returns the value of the member "strAreaCode6".
     *
     * AreaCode6
     *
     * @return The value of the field "strAreaCode6"
     */
    inline const ::std::string& getStrAreaCode6 () const;

    /**
     * Retrieves the value of the field "strAreaCode6" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strAreaCode6".
     */
    inline ::std::string& getStrAreaCode6Mutable ();

    /**
     * Sets the value of the member "strAreaCode6".
     *
     * AreaCode6
     *
     * @param strAreaCode6 The value which will be set
     */
    inline void setStrAreaCode6 (const ::std::string& strAreaCode6_);

    /**
     * Sets the value of the member "strAreaCode6".
     *
     * AreaCode6
     *
     * @param strAreaCode6 The value which will be set
     */
    inline void setStrAreaCode6 (const char* strAreaCode6_);

    /**
     * Sets the value of the member "strAreaCode6".
     *
     * AreaCode6
     *
     * @param strAreaCode6 The value which will be set
     */
    inline void setStrAreaCode6 (const char* value, size_t size);

    // API of field "strAreaCode7"

    static const int kStrAreaCode7 = 7;

    /**
     * Clears the field "strAreaCode7".
     *
     * The field will be set to its default value. The hasStrAreaCode7()
     * method will return false.
     */
    inline void clearStrAreaCode7();

    /**
     * Checks whether the field "strAreaCode7" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrAreaCode7()). Otherwise it will return false.
     */
    inline bool hasStrAreaCode7 () const;

    /**
     * Returns the value of the member "strAreaCode7".
     *
     * AreaCode7
     *
     * @return The value of the field "strAreaCode7"
     */
    inline const ::std::string& getStrAreaCode7 () const;

    /**
     * Retrieves the value of the field "strAreaCode7" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strAreaCode7".
     */
    inline ::std::string& getStrAreaCode7Mutable ();

    /**
     * Sets the value of the member "strAreaCode7".
     *
     * AreaCode7
     *
     * @param strAreaCode7 The value which will be set
     */
    inline void setStrAreaCode7 (const ::std::string& strAreaCode7_);

    /**
     * Sets the value of the member "strAreaCode7".
     *
     * AreaCode7
     *
     * @param strAreaCode7 The value which will be set
     */
    inline void setStrAreaCode7 (const char* strAreaCode7_);

    /**
     * Sets the value of the member "strAreaCode7".
     *
     * AreaCode7
     *
     * @param strAreaCode7 The value which will be set
     */
    inline void setStrAreaCode7 (const char* value, size_t size);

    // API of field "strAreaCode8"

    static const int kStrAreaCode8 = 8;

    /**
     * Clears the field "strAreaCode8".
     *
     * The field will be set to its default value. The hasStrAreaCode8()
     * method will return false.
     */
    inline void clearStrAreaCode8();

    /**
     * Checks whether the field "strAreaCode8" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrAreaCode8()). Otherwise it will return false.
     */
    inline bool hasStrAreaCode8 () const;

    /**
     * Returns the value of the member "strAreaCode8".
     *
     * AreaCode8
     *
     * @return The value of the field "strAreaCode8"
     */
    inline const ::std::string& getStrAreaCode8 () const;

    /**
     * Retrieves the value of the field "strAreaCode8" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strAreaCode8".
     */
    inline ::std::string& getStrAreaCode8Mutable ();

    /**
     * Sets the value of the member "strAreaCode8".
     *
     * AreaCode8
     *
     * @param strAreaCode8 The value which will be set
     */
    inline void setStrAreaCode8 (const ::std::string& strAreaCode8_);

    /**
     * Sets the value of the member "strAreaCode8".
     *
     * AreaCode8
     *
     * @param strAreaCode8 The value which will be set
     */
    inline void setStrAreaCode8 (const char* strAreaCode8_);

    /**
     * Sets the value of the member "strAreaCode8".
     *
     * AreaCode8
     *
     * @param strAreaCode8 The value which will be set
     */
    inline void setStrAreaCode8 (const char* value, size_t size);

    // API of field "strPOIName"

    static const int kStrPOIName = 9;

    /**
     * Clears the field "strPOIName".
     *
     * The field will be set to its default value. The hasStrPOIName()
     * method will return false.
     */
    inline void clearStrPOIName();

    /**
     * Checks whether the field "strPOIName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrPOIName()). Otherwise it will return false.
     */
    inline bool hasStrPOIName () const;

    /**
     * Returns the value of the member "strPOIName".
     *
     * POI Name
     *
     * @return The value of the field "strPOIName"
     */
    inline const ::std::string& getStrPOIName () const;

    /**
     * Retrieves the value of the field "strPOIName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strPOIName".
     */
    inline ::std::string& getStrPOINameMutable ();

    /**
     * Sets the value of the member "strPOIName".
     *
     * POI Name
     *
     * @param strPOIName The value which will be set
     */
    inline void setStrPOIName (const ::std::string& strPOIName_);

    /**
     * Sets the value of the member "strPOIName".
     *
     * POI Name
     *
     * @param strPOIName The value which will be set
     */
    inline void setStrPOIName (const char* strPOIName_);

    /**
     * Sets the value of the member "strPOIName".
     *
     * POI Name
     *
     * @param strPOIName The value which will be set
     */
    inline void setStrPOIName (const char* value, size_t size);

    // API of field "strStreetAndHouseNo"

    static const int kStrStreetAndHouseNo = 10;

    /**
     * Clears the field "strStreetAndHouseNo".
     *
     * The field will be set to its default value. The hasStrStreetAndHouseNo()
     * method will return false.
     */
    inline void clearStrStreetAndHouseNo();

    /**
     * Checks whether the field "strStreetAndHouseNo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrStreetAndHouseNo()). Otherwise it will return false.
     */
    inline bool hasStrStreetAndHouseNo () const;

    /**
     * Returns the value of the member "strStreetAndHouseNo".
     *
     * Street and House number
     *
     * @return The value of the field "strStreetAndHouseNo"
     */
    inline const ::std::string& getStrStreetAndHouseNo () const;

    /**
     * Retrieves the value of the field "strStreetAndHouseNo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strStreetAndHouseNo".
     */
    inline ::std::string& getStrStreetAndHouseNoMutable ();

    /**
     * Sets the value of the member "strStreetAndHouseNo".
     *
     * Street and House number
     *
     * @param strStreetAndHouseNo The value which will be set
     */
    inline void setStrStreetAndHouseNo (const ::std::string& strStreetAndHouseNo_);

    /**
     * Sets the value of the member "strStreetAndHouseNo".
     *
     * Street and House number
     *
     * @param strStreetAndHouseNo The value which will be set
     */
    inline void setStrStreetAndHouseNo (const char* strStreetAndHouseNo_);

    /**
     * Sets the value of the member "strStreetAndHouseNo".
     *
     * Street and House number
     *
     * @param strStreetAndHouseNo The value which will be set
     */
    inline void setStrStreetAndHouseNo (const char* value, size_t size);

    // API of field "strTelephonenumber"

    static const int kStrTelephonenumber = 11;

    /**
     * Clears the field "strTelephonenumber".
     *
     * The field will be set to its default value. The hasStrTelephonenumber()
     * method will return false.
     */
    inline void clearStrTelephonenumber();

    /**
     * Checks whether the field "strTelephonenumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrTelephonenumber()). Otherwise it will return false.
     */
    inline bool hasStrTelephonenumber () const;

    /**
     * Returns the value of the member "strTelephonenumber".
     *
     * Telephonenumber
     *
     * @return The value of the field "strTelephonenumber"
     */
    inline const ::std::string& getStrTelephonenumber () const;

    /**
     * Retrieves the value of the field "strTelephonenumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strTelephonenumber".
     */
    inline ::std::string& getStrTelephonenumberMutable ();

    /**
     * Sets the value of the member "strTelephonenumber".
     *
     * Telephonenumber
     *
     * @param strTelephonenumber The value which will be set
     */
    inline void setStrTelephonenumber (const ::std::string& strTelephonenumber_);

    /**
     * Sets the value of the member "strTelephonenumber".
     *
     * Telephonenumber
     *
     * @param strTelephonenumber The value which will be set
     */
    inline void setStrTelephonenumber (const char* strTelephonenumber_);

    /**
     * Sets the value of the member "strTelephonenumber".
     *
     * Telephonenumber
     *
     * @param strTelephonenumber The value which will be set
     */
    inline void setStrTelephonenumber (const char* value, size_t size);

    // API of field "u16Categorycode"

    static const int kU16Categorycode = 12;

    /**
     * Clears the field "u16Categorycode".
     *
     * The field will be set to its default value. The hasU16Categorycode()
     * method will return false.
     */
    inline void clearU16Categorycode();

    /**
     * Checks whether the field "u16Categorycode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16Categorycode()). Otherwise it will return false.
     */
    inline bool hasU16Categorycode () const;

    /**
     * Returns the value of the member "u16Categorycode".
     *
     * If the meaning of "u16Categorycode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u16Categorycode"
     */
    inline uint16 getU16Categorycode () const;

    /**
     * Sets the value of the member "u16Categorycode".
     *
     * If the meaning of "u16Categorycode" isn't clear, then there should be a description here.
     *
     * @param u16Categorycode The value which will be set
     */
    inline void setU16Categorycode (uint16 u16Categorycode_);

    // API of field "u16ClosedhourInformation"

    static const int kU16ClosedhourInformation = 13;

    /**
     * Clears the field "u16ClosedhourInformation".
     *
     * The field will be set to its default value. The hasU16ClosedhourInformation()
     * method will return false.
     */
    inline void clearU16ClosedhourInformation();

    /**
     * Checks whether the field "u16ClosedhourInformation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ClosedhourInformation()). Otherwise it will return false.
     */
    inline bool hasU16ClosedhourInformation () const;

    /**
     * Returns the value of the member "u16ClosedhourInformation".
     *
     * If the meaning of "u16ClosedhourInformation" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u16ClosedhourInformation"
     */
    inline uint16 getU16ClosedhourInformation () const;

    /**
     * Sets the value of the member "u16ClosedhourInformation".
     *
     * If the meaning of "u16ClosedhourInformation" isn't clear, then there should be a description here.
     *
     * @param u16ClosedhourInformation The value which will be set
     */
    inline void setU16ClosedhourInformation (uint16 u16ClosedhourInformation_);

    // API of field "u16OpeninghourInformation"

    static const int kU16OpeninghourInformation = 14;

    /**
     * Clears the field "u16OpeninghourInformation".
     *
     * The field will be set to its default value. The hasU16OpeninghourInformation()
     * method will return false.
     */
    inline void clearU16OpeninghourInformation();

    /**
     * Checks whether the field "u16OpeninghourInformation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16OpeninghourInformation()). Otherwise it will return false.
     */
    inline bool hasU16OpeninghourInformation () const;

    /**
     * Returns the value of the member "u16OpeninghourInformation".
     *
     * If the meaning of "u16OpeninghourInformation" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u16OpeninghourInformation"
     */
    inline uint16 getU16OpeninghourInformation () const;

    /**
     * Sets the value of the member "u16OpeninghourInformation".
     *
     * If the meaning of "u16OpeninghourInformation" isn't clear, then there should be a description here.
     *
     * @param u16OpeninghourInformation The value which will be set
     */
    inline void setU16OpeninghourInformation (uint16 u16OpeninghourInformation_);

    // API of field "u16Parkingnumber"

    static const int kU16Parkingnumber = 15;

    /**
     * Clears the field "u16Parkingnumber".
     *
     * The field will be set to its default value. The hasU16Parkingnumber()
     * method will return false.
     */
    inline void clearU16Parkingnumber();

    /**
     * Checks whether the field "u16Parkingnumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16Parkingnumber()). Otherwise it will return false.
     */
    inline bool hasU16Parkingnumber () const;

    /**
     * Returns the value of the member "u16Parkingnumber".
     *
     * If the meaning of "u16Parkingnumber" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u16Parkingnumber"
     */
    inline uint16 getU16Parkingnumber () const;

    /**
     * Sets the value of the member "u16Parkingnumber".
     *
     * If the meaning of "u16Parkingnumber" isn't clear, then there should be a description here.
     *
     * @param u16Parkingnumber The value which will be set
     */
    inline void setU16Parkingnumber (uint16 u16Parkingnumber_);

    // API of field "u16Paymenttypeinformation"

    static const int kU16Paymenttypeinformation = 16;

    /**
     * Clears the field "u16Paymenttypeinformation".
     *
     * The field will be set to its default value. The hasU16Paymenttypeinformation()
     * method will return false.
     */
    inline void clearU16Paymenttypeinformation();

    /**
     * Checks whether the field "u16Paymenttypeinformation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16Paymenttypeinformation()). Otherwise it will return false.
     */
    inline bool hasU16Paymenttypeinformation () const;

    /**
     * Returns the value of the member "u16Paymenttypeinformation".
     *
     * If the meaning of "u16Paymenttypeinformation" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u16Paymenttypeinformation"
     */
    inline uint16 getU16Paymenttypeinformation () const;

    /**
     * Sets the value of the member "u16Paymenttypeinformation".
     *
     * If the meaning of "u16Paymenttypeinformation" isn't clear, then there should be a description here.
     *
     * @param u16Paymenttypeinformation The value which will be set
     */
    inline void setU16Paymenttypeinformation (uint16 u16Paymenttypeinformation_);

    // API of field "u16Sizeofdetailinformation"

    static const int kU16Sizeofdetailinformation = 17;

    /**
     * Clears the field "u16Sizeofdetailinformation".
     *
     * The field will be set to its default value. The hasU16Sizeofdetailinformation()
     * method will return false.
     */
    inline void clearU16Sizeofdetailinformation();

    /**
     * Checks whether the field "u16Sizeofdetailinformation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16Sizeofdetailinformation()). Otherwise it will return false.
     */
    inline bool hasU16Sizeofdetailinformation () const;

    /**
     * Returns the value of the member "u16Sizeofdetailinformation".
     *
     * If the meaning of "u16Sizeofdetailinformation" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u16Sizeofdetailinformation"
     */
    inline uint16 getU16Sizeofdetailinformation () const;

    /**
     * Sets the value of the member "u16Sizeofdetailinformation".
     *
     * If the meaning of "u16Sizeofdetailinformation" isn't clear, then there should be a description here.
     *
     * @param u16Sizeofdetailinformation The value which will be set
     */
    inline void setU16Sizeofdetailinformation (uint16 u16Sizeofdetailinformation_);

    // API of field "u16Subcategorycode"

    static const int kU16Subcategorycode = 18;

    /**
     * Clears the field "u16Subcategorycode".
     *
     * The field will be set to its default value. The hasU16Subcategorycode()
     * method will return false.
     */
    inline void clearU16Subcategorycode();

    /**
     * Checks whether the field "u16Subcategorycode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16Subcategorycode()). Otherwise it will return false.
     */
    inline bool hasU16Subcategorycode () const;

    /**
     * Returns the value of the member "u16Subcategorycode".
     *
     * If the meaning of "u16Subcategorycode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u16Subcategorycode"
     */
    inline uint16 getU16Subcategorycode () const;

    /**
     * Sets the value of the member "u16Subcategorycode".
     *
     * If the meaning of "u16Subcategorycode" isn't clear, then there should be a description here.
     *
     * @param u16Subcategorycode The value which will be set
     */
    inline void setU16Subcategorycode (uint16 u16Subcategorycode_);

    // API of field "u32POIID"

    static const int kU32POIID = 19;

    /**
     * Clears the field "u32POIID".
     *
     * The field will be set to its default value. The hasU32POIID()
     * method will return false.
     */
    inline void clearU32POIID();

    /**
     * Checks whether the field "u32POIID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32POIID()). Otherwise it will return false.
     */
    inline bool hasU32POIID () const;

    /**
     * Returns the value of the member "u32POIID".
     *
     * If the meaning of "u32POIID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32POIID"
     */
    inline uint32 getU32POIID () const;

    /**
     * Sets the value of the member "u32POIID".
     *
     * If the meaning of "u32POIID" isn't clear, then there should be a description here.
     *
     * @param u32POIID The value which will be set
     */
    inline void setU32POIID (uint32 u32POIID_);

    // API of field "u32UserrestrictionID"

    static const int kU32UserrestrictionID = 20;

    /**
     * Clears the field "u32UserrestrictionID".
     *
     * The field will be set to its default value. The hasU32UserrestrictionID()
     * method will return false.
     */
    inline void clearU32UserrestrictionID();

    /**
     * Checks whether the field "u32UserrestrictionID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32UserrestrictionID()). Otherwise it will return false.
     */
    inline bool hasU32UserrestrictionID () const;

    /**
     * Returns the value of the member "u32UserrestrictionID".
     *
     * If the meaning of "u32UserrestrictionID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32UserrestrictionID"
     */
    inline uint32 getU32UserrestrictionID () const;

    /**
     * Sets the value of the member "u32UserrestrictionID".
     *
     * If the meaning of "u32UserrestrictionID" isn't clear, then there should be a description here.
     *
     * @param u32UserrestrictionID The value which will be set
     */
    inline void setU32UserrestrictionID (uint32 u32UserrestrictionID_);

    // API of field "u8_24hoursadayinformation"

    static const int kU8_24hoursadayinformation = 21;

    /**
     * Clears the field "u8_24hoursadayinformation".
     *
     * The field will be set to its default value. The hasU8_24hoursadayinformation()
     * method will return false.
     */
    inline void clearU8_24hoursadayinformation();

    /**
     * Checks whether the field "u8_24hoursadayinformation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8_24hoursadayinformation()). Otherwise it will return false.
     */
    inline bool hasU8_24hoursadayinformation () const;

    /**
     * Returns the value of the member "u8_24hoursadayinformation".
     *
     * If the meaning of "u8_24hoursadayinformation" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8_24hoursadayinformation"
     */
    inline uint8 getU8_24hoursadayinformation () const;

    /**
     * Sets the value of the member "u8_24hoursadayinformation".
     *
     * If the meaning of "u8_24hoursadayinformation" isn't clear, then there should be a description here.
     *
     * @param u8_24hoursadayinformation The value which will be set
     */
    inline void setU8_24hoursadayinformation (uint8 u8_24hoursadayinformation_);

    // API of field "u8Businessdayoftheweekinformation"

    static const int kU8Businessdayoftheweekinformation = 22;

    /**
     * Clears the field "u8Businessdayoftheweekinformation".
     *
     * The field will be set to its default value. The hasU8Businessdayoftheweekinformation()
     * method will return false.
     */
    inline void clearU8Businessdayoftheweekinformation();

    /**
     * Checks whether the field "u8Businessdayoftheweekinformation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Businessdayoftheweekinformation()). Otherwise it will return false.
     */
    inline bool hasU8Businessdayoftheweekinformation () const;

    /**
     * Returns the value of the member "u8Businessdayoftheweekinformation".
     *
     * If the meaning of "u8Businessdayoftheweekinformation" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Businessdayoftheweekinformation"
     */
    inline uint8 getU8Businessdayoftheweekinformation () const;

    /**
     * Sets the value of the member "u8Businessdayoftheweekinformation".
     *
     * If the meaning of "u8Businessdayoftheweekinformation" isn't clear, then there should be a description here.
     *
     * @param u8Businessdayoftheweekinformation The value which will be set
     */
    inline void setU8Businessdayoftheweekinformation (uint8 u8Businessdayoftheweekinformation_);

    // API of field "u8Chargingfeeinformation"

    static const int kU8Chargingfeeinformation = 23;

    /**
     * Clears the field "u8Chargingfeeinformation".
     *
     * The field will be set to its default value. The hasU8Chargingfeeinformation()
     * method will return false.
     */
    inline void clearU8Chargingfeeinformation();

    /**
     * Checks whether the field "u8Chargingfeeinformation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Chargingfeeinformation()). Otherwise it will return false.
     */
    inline bool hasU8Chargingfeeinformation () const;

    /**
     * Returns the value of the member "u8Chargingfeeinformation".
     *
     * If the meaning of "u8Chargingfeeinformation" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Chargingfeeinformation"
     */
    inline uint8 getU8Chargingfeeinformation () const;

    /**
     * Sets the value of the member "u8Chargingfeeinformation".
     *
     * If the meaning of "u8Chargingfeeinformation" isn't clear, then there should be a description here.
     *
     * @param u8Chargingfeeinformation The value which will be set
     */
    inline void setU8Chargingfeeinformation (uint8 u8Chargingfeeinformation_);

    // API of field "u8Chargingtype"

    static const int kU8Chargingtype = 24;

    /**
     * Clears the field "u8Chargingtype".
     *
     * The field will be set to its default value. The hasU8Chargingtype()
     * method will return false.
     */
    inline void clearU8Chargingtype();

    /**
     * Checks whether the field "u8Chargingtype" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Chargingtype()). Otherwise it will return false.
     */
    inline bool hasU8Chargingtype () const;

    /**
     * Returns the value of the member "u8Chargingtype".
     *
     * If the meaning of "u8Chargingtype" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Chargingtype"
     */
    inline uint8 getU8Chargingtype () const;

    /**
     * Sets the value of the member "u8Chargingtype".
     *
     * If the meaning of "u8Chargingtype" isn't clear, then there should be a description here.
     *
     * @param u8Chargingtype The value which will be set
     */
    inline void setU8Chargingtype (uint8 u8Chargingtype_);

    // API of field "u8Detailsinformation"

    static const int kU8Detailsinformation = 25;

    /**
     * Clears the field "u8Detailsinformation".
     *
     * The field will be set to its default value. The hasU8Detailsinformation()
     * method will return false.
     */
    inline void clearU8Detailsinformation();

    /**
     * Checks whether the field "u8Detailsinformation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Detailsinformation()). Otherwise it will return false.
     */
    inline bool hasU8Detailsinformation () const;

    /**
     * Returns the value of the member "u8Detailsinformation".
     *
     * If the meaning of "u8Detailsinformation" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Detailsinformation"
     */
    inline uint8 getU8Detailsinformation () const;

    /**
     * Sets the value of the member "u8Detailsinformation".
     *
     * If the meaning of "u8Detailsinformation" isn't clear, then there should be a description here.
     *
     * @param u8Detailsinformation The value which will be set
     */
    inline void setU8Detailsinformation (uint8 u8Detailsinformation_);

    // API of field "u8Entranceinformation"

    static const int kU8Entranceinformation = 26;

    /**
     * Clears the field "u8Entranceinformation".
     *
     * The field will be set to its default value. The hasU8Entranceinformation()
     * method will return false.
     */
    inline void clearU8Entranceinformation();

    /**
     * Checks whether the field "u8Entranceinformation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Entranceinformation()). Otherwise it will return false.
     */
    inline bool hasU8Entranceinformation () const;

    /**
     * Returns the value of the member "u8Entranceinformation".
     *
     * If the meaning of "u8Entranceinformation" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Entranceinformation"
     */
    inline uint8 getU8Entranceinformation () const;

    /**
     * Sets the value of the member "u8Entranceinformation".
     *
     * If the meaning of "u8Entranceinformation" isn't clear, then there should be a description here.
     *
     * @param u8Entranceinformation The value which will be set
     */
    inline void setU8Entranceinformation (uint8 u8Entranceinformation_);

    // API of field "u8Expresswaygeneraltype"

    static const int kU8Expresswaygeneraltype = 27;

    /**
     * Clears the field "u8Expresswaygeneraltype".
     *
     * The field will be set to its default value. The hasU8Expresswaygeneraltype()
     * method will return false.
     */
    inline void clearU8Expresswaygeneraltype();

    /**
     * Checks whether the field "u8Expresswaygeneraltype" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Expresswaygeneraltype()). Otherwise it will return false.
     */
    inline bool hasU8Expresswaygeneraltype () const;

    /**
     * Returns the value of the member "u8Expresswaygeneraltype".
     *
     * If the meaning of "u8Expresswaygeneraltype" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Expresswaygeneraltype"
     */
    inline uint8 getU8Expresswaygeneraltype () const;

    /**
     * Sets the value of the member "u8Expresswaygeneraltype".
     *
     * If the meaning of "u8Expresswaygeneraltype" isn't clear, then there should be a description here.
     *
     * @param u8Expresswaygeneraltype The value which will be set
     */
    inline void setU8Expresswaygeneraltype (uint8 u8Expresswaygeneraltype_);

    // API of field "u8Fixedvalue1"

    static const int kU8Fixedvalue1 = 28;

    /**
     * Clears the field "u8Fixedvalue1".
     *
     * The field will be set to its default value. The hasU8Fixedvalue1()
     * method will return false.
     */
    inline void clearU8Fixedvalue1();

    /**
     * Checks whether the field "u8Fixedvalue1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Fixedvalue1()). Otherwise it will return false.
     */
    inline bool hasU8Fixedvalue1 () const;

    /**
     * Returns the value of the member "u8Fixedvalue1".
     *
     * If the meaning of "u8Fixedvalue1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Fixedvalue1"
     */
    inline uint8 getU8Fixedvalue1 () const;

    /**
     * Sets the value of the member "u8Fixedvalue1".
     *
     * If the meaning of "u8Fixedvalue1" isn't clear, then there should be a description here.
     *
     * @param u8Fixedvalue1 The value which will be set
     */
    inline void setU8Fixedvalue1 (uint8 u8Fixedvalue1_);

    // API of field "u8Fixedvalue2"

    static const int kU8Fixedvalue2 = 29;

    /**
     * Clears the field "u8Fixedvalue2".
     *
     * The field will be set to its default value. The hasU8Fixedvalue2()
     * method will return false.
     */
    inline void clearU8Fixedvalue2();

    /**
     * Checks whether the field "u8Fixedvalue2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Fixedvalue2()). Otherwise it will return false.
     */
    inline bool hasU8Fixedvalue2 () const;

    /**
     * Returns the value of the member "u8Fixedvalue2".
     *
     * If the meaning of "u8Fixedvalue2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Fixedvalue2"
     */
    inline uint8 getU8Fixedvalue2 () const;

    /**
     * Sets the value of the member "u8Fixedvalue2".
     *
     * If the meaning of "u8Fixedvalue2" isn't clear, then there should be a description here.
     *
     * @param u8Fixedvalue2 The value which will be set
     */
    inline void setU8Fixedvalue2 (uint8 u8Fixedvalue2_);

    // API of field "u8Informationreliability"

    static const int kU8Informationreliability = 30;

    /**
     * Clears the field "u8Informationreliability".
     *
     * The field will be set to its default value. The hasU8Informationreliability()
     * method will return false.
     */
    inline void clearU8Informationreliability();

    /**
     * Checks whether the field "u8Informationreliability" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Informationreliability()). Otherwise it will return false.
     */
    inline bool hasU8Informationreliability () const;

    /**
     * Returns the value of the member "u8Informationreliability".
     *
     * If the meaning of "u8Informationreliability" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Informationreliability"
     */
    inline uint8 getU8Informationreliability () const;

    /**
     * Sets the value of the member "u8Informationreliability".
     *
     * If the meaning of "u8Informationreliability" isn't clear, then there should be a description here.
     *
     * @param u8Informationreliability The value which will be set
     */
    inline void setU8Informationreliability (uint8 u8Informationreliability_);

    // API of field "u8Installationfacilityinformation"

    static const int kU8Installationfacilityinformation = 31;

    /**
     * Clears the field "u8Installationfacilityinformation".
     *
     * The field will be set to its default value. The hasU8Installationfacilityinformation()
     * method will return false.
     */
    inline void clearU8Installationfacilityinformation();

    /**
     * Checks whether the field "u8Installationfacilityinformation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Installationfacilityinformation()). Otherwise it will return false.
     */
    inline bool hasU8Installationfacilityinformation () const;

    /**
     * Returns the value of the member "u8Installationfacilityinformation".
     *
     * If the meaning of "u8Installationfacilityinformation" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Installationfacilityinformation"
     */
    inline uint8 getU8Installationfacilityinformation () const;

    /**
     * Sets the value of the member "u8Installationfacilityinformation".
     *
     * If the meaning of "u8Installationfacilityinformation" isn't clear, then there should be a description here.
     *
     * @param u8Installationfacilityinformation The value which will be set
     */
    inline void setU8Installationfacilityinformation (uint8 u8Installationfacilityinformation_);

    // API of field "u8Nearthefacilityinformation"

    static const int kU8Nearthefacilityinformation = 32;

    /**
     * Clears the field "u8Nearthefacilityinformation".
     *
     * The field will be set to its default value. The hasU8Nearthefacilityinformation()
     * method will return false.
     */
    inline void clearU8Nearthefacilityinformation();

    /**
     * Checks whether the field "u8Nearthefacilityinformation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Nearthefacilityinformation()). Otherwise it will return false.
     */
    inline bool hasU8Nearthefacilityinformation () const;

    /**
     * Returns the value of the member "u8Nearthefacilityinformation".
     *
     * If the meaning of "u8Nearthefacilityinformation" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Nearthefacilityinformation"
     */
    inline uint8 getU8Nearthefacilityinformation () const;

    /**
     * Sets the value of the member "u8Nearthefacilityinformation".
     *
     * If the meaning of "u8Nearthefacilityinformation" isn't clear, then there should be a description here.
     *
     * @param u8Nearthefacilityinformation The value which will be set
     */
    inline void setU8Nearthefacilityinformation (uint8 u8Nearthefacilityinformation_);

    // API of field "u8Officehoursunknowninformation"

    static const int kU8Officehoursunknowninformation = 33;

    /**
     * Clears the field "u8Officehoursunknowninformation".
     *
     * The field will be set to its default value. The hasU8Officehoursunknowninformation()
     * method will return false.
     */
    inline void clearU8Officehoursunknowninformation();

    /**
     * Checks whether the field "u8Officehoursunknowninformation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Officehoursunknowninformation()). Otherwise it will return false.
     */
    inline bool hasU8Officehoursunknowninformation () const;

    /**
     * Returns the value of the member "u8Officehoursunknowninformation".
     *
     * If the meaning of "u8Officehoursunknowninformation" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Officehoursunknowninformation"
     */
    inline uint8 getU8Officehoursunknowninformation () const;

    /**
     * Sets the value of the member "u8Officehoursunknowninformation".
     *
     * If the meaning of "u8Officehoursunknowninformation" isn't clear, then there should be a description here.
     *
     * @param u8Officehoursunknowninformation The value which will be set
     */
    inline void setU8Officehoursunknowninformation (uint8 u8Officehoursunknowninformation_);

    // API of field "u8Partnersfacilityinformation"

    static const int kU8Partnersfacilityinformation = 34;

    /**
     * Clears the field "u8Partnersfacilityinformation".
     *
     * The field will be set to its default value. The hasU8Partnersfacilityinformation()
     * method will return false.
     */
    inline void clearU8Partnersfacilityinformation();

    /**
     * Checks whether the field "u8Partnersfacilityinformation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Partnersfacilityinformation()). Otherwise it will return false.
     */
    inline bool hasU8Partnersfacilityinformation () const;

    /**
     * Returns the value of the member "u8Partnersfacilityinformation".
     *
     * If the meaning of "u8Partnersfacilityinformation" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Partnersfacilityinformation"
     */
    inline uint8 getU8Partnersfacilityinformation () const;

    /**
     * Sets the value of the member "u8Partnersfacilityinformation".
     *
     * If the meaning of "u8Partnersfacilityinformation" isn't clear, then there should be a description here.
     *
     * @param u8Partnersfacilityinformation The value which will be set
     */
    inline void setU8Partnersfacilityinformation (uint8 u8Partnersfacilityinformation_);

    // API of field "u8SizeOfPOIName"

    static const int kU8SizeOfPOIName = 35;

    /**
     * Clears the field "u8SizeOfPOIName".
     *
     * The field will be set to its default value. The hasU8SizeOfPOIName()
     * method will return false.
     */
    inline void clearU8SizeOfPOIName();

    /**
     * Checks whether the field "u8SizeOfPOIName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SizeOfPOIName()). Otherwise it will return false.
     */
    inline bool hasU8SizeOfPOIName () const;

    /**
     * Returns the value of the member "u8SizeOfPOIName".
     *
     * If the meaning of "u8SizeOfPOIName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8SizeOfPOIName"
     */
    inline uint8 getU8SizeOfPOIName () const;

    /**
     * Sets the value of the member "u8SizeOfPOIName".
     *
     * If the meaning of "u8SizeOfPOIName" isn't clear, then there should be a description here.
     *
     * @param u8SizeOfPOIName The value which will be set
     */
    inline void setU8SizeOfPOIName (uint8 u8SizeOfPOIName_);

    // API of field "u8SizeOfStreetAndHouseNo"

    static const int kU8SizeOfStreetAndHouseNo = 36;

    /**
     * Clears the field "u8SizeOfStreetAndHouseNo".
     *
     * The field will be set to its default value. The hasU8SizeOfStreetAndHouseNo()
     * method will return false.
     */
    inline void clearU8SizeOfStreetAndHouseNo();

    /**
     * Checks whether the field "u8SizeOfStreetAndHouseNo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SizeOfStreetAndHouseNo()). Otherwise it will return false.
     */
    inline bool hasU8SizeOfStreetAndHouseNo () const;

    /**
     * Returns the value of the member "u8SizeOfStreetAndHouseNo".
     *
     * If the meaning of "u8SizeOfStreetAndHouseNo" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8SizeOfStreetAndHouseNo"
     */
    inline uint8 getU8SizeOfStreetAndHouseNo () const;

    /**
     * Sets the value of the member "u8SizeOfStreetAndHouseNo".
     *
     * If the meaning of "u8SizeOfStreetAndHouseNo" isn't clear, then there should be a description here.
     *
     * @param u8SizeOfStreetAndHouseNo The value which will be set
     */
    inline void setU8SizeOfStreetAndHouseNo (uint8 u8SizeOfStreetAndHouseNo_);

    // API of field "u8SizeOfTelephonenumber"

    static const int kU8SizeOfTelephonenumber = 37;

    /**
     * Clears the field "u8SizeOfTelephonenumber".
     *
     * The field will be set to its default value. The hasU8SizeOfTelephonenumber()
     * method will return false.
     */
    inline void clearU8SizeOfTelephonenumber();

    /**
     * Checks whether the field "u8SizeOfTelephonenumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SizeOfTelephonenumber()). Otherwise it will return false.
     */
    inline bool hasU8SizeOfTelephonenumber () const;

    /**
     * Returns the value of the member "u8SizeOfTelephonenumber".
     *
     * If the meaning of "u8SizeOfTelephonenumber" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8SizeOfTelephonenumber"
     */
    inline uint8 getU8SizeOfTelephonenumber () const;

    /**
     * Sets the value of the member "u8SizeOfTelephonenumber".
     *
     * If the meaning of "u8SizeOfTelephonenumber" isn't clear, then there should be a description here.
     *
     * @param u8SizeOfTelephonenumber The value which will be set
     */
    inline void setU8SizeOfTelephonenumber (uint8 u8SizeOfTelephonenumber_);

    // API of field "u8Thenumberofentranceinformation"

    static const int kU8Thenumberofentranceinformation = 38;

    /**
     * Clears the field "u8Thenumberofentranceinformation".
     *
     * The field will be set to its default value. The hasU8Thenumberofentranceinformation()
     * method will return false.
     */
    inline void clearU8Thenumberofentranceinformation();

    /**
     * Checks whether the field "u8Thenumberofentranceinformation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Thenumberofentranceinformation()). Otherwise it will return false.
     */
    inline bool hasU8Thenumberofentranceinformation () const;

    /**
     * Returns the value of the member "u8Thenumberofentranceinformation".
     *
     * If the meaning of "u8Thenumberofentranceinformation" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Thenumberofentranceinformation"
     */
    inline uint8 getU8Thenumberofentranceinformation () const;

    /**
     * Sets the value of the member "u8Thenumberofentranceinformation".
     *
     * If the meaning of "u8Thenumberofentranceinformation" isn't clear, then there should be a description here.
     *
     * @param u8Thenumberofentranceinformation The value which will be set
     */
    inline void setU8Thenumberofentranceinformation (uint8 u8Thenumberofentranceinformation_);

    // API of field "u8Thenumberofinstallationfacilityinformation"

    static const int kU8Thenumberofinstallationfacilityinformation = 39;

    /**
     * Clears the field "u8Thenumberofinstallationfacilityinformation".
     *
     * The field will be set to its default value. The hasU8Thenumberofinstallationfacilityinformation()
     * method will return false.
     */
    inline void clearU8Thenumberofinstallationfacilityinformation();

    /**
     * Checks whether the field "u8Thenumberofinstallationfacilityinformation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Thenumberofinstallationfacilityinformation()). Otherwise it will return false.
     */
    inline bool hasU8Thenumberofinstallationfacilityinformation () const;

    /**
     * Returns the value of the member "u8Thenumberofinstallationfacilityinformation".
     *
     * If the meaning of "u8Thenumberofinstallationfacilityinformation" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Thenumberofinstallationfacilityinformation"
     */
    inline uint8 getU8Thenumberofinstallationfacilityinformation () const;

    /**
     * Sets the value of the member "u8Thenumberofinstallationfacilityinformation".
     *
     * If the meaning of "u8Thenumberofinstallationfacilityinformation" isn't clear, then there should be a description here.
     *
     * @param u8Thenumberofinstallationfacilityinformation The value which will be set
     */
    inline void setU8Thenumberofinstallationfacilityinformation (uint8 u8Thenumberofinstallationfacilityinformation_);

    // API of field "u8Thenumberofpartnersfacilityinformation"

    static const int kU8Thenumberofpartnersfacilityinformation = 40;

    /**
     * Clears the field "u8Thenumberofpartnersfacilityinformation".
     *
     * The field will be set to its default value. The hasU8Thenumberofpartnersfacilityinformation()
     * method will return false.
     */
    inline void clearU8Thenumberofpartnersfacilityinformation();

    /**
     * Checks whether the field "u8Thenumberofpartnersfacilityinformation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Thenumberofpartnersfacilityinformation()). Otherwise it will return false.
     */
    inline bool hasU8Thenumberofpartnersfacilityinformation () const;

    /**
     * Returns the value of the member "u8Thenumberofpartnersfacilityinformation".
     *
     * If the meaning of "u8Thenumberofpartnersfacilityinformation" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Thenumberofpartnersfacilityinformation"
     */
    inline uint8 getU8Thenumberofpartnersfacilityinformation () const;

    /**
     * Sets the value of the member "u8Thenumberofpartnersfacilityinformation".
     *
     * If the meaning of "u8Thenumberofpartnersfacilityinformation" isn't clear, then there should be a description here.
     *
     * @param u8Thenumberofpartnersfacilityinformation The value which will be set
     */
    inline void setU8Thenumberofpartnersfacilityinformation (uint8 u8Thenumberofpartnersfacilityinformation_);

    // API of field "u8Thetotalnumberofchargingtype"

    static const int kU8Thetotalnumberofchargingtype = 41;

    /**
     * Clears the field "u8Thetotalnumberofchargingtype".
     *
     * The field will be set to its default value. The hasU8Thetotalnumberofchargingtype()
     * method will return false.
     */
    inline void clearU8Thetotalnumberofchargingtype();

    /**
     * Checks whether the field "u8Thetotalnumberofchargingtype" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Thetotalnumberofchargingtype()). Otherwise it will return false.
     */
    inline bool hasU8Thetotalnumberofchargingtype () const;

    /**
     * Returns the value of the member "u8Thetotalnumberofchargingtype".
     *
     * If the meaning of "u8Thetotalnumberofchargingtype" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Thetotalnumberofchargingtype"
     */
    inline uint8 getU8Thetotalnumberofchargingtype () const;

    /**
     * Sets the value of the member "u8Thetotalnumberofchargingtype".
     *
     * If the meaning of "u8Thetotalnumberofchargingtype" isn't clear, then there should be a description here.
     *
     * @param u8Thetotalnumberofchargingtype The value which will be set
     */
    inline void setU8Thetotalnumberofchargingtype (uint8 u8Thetotalnumberofchargingtype_);

    // API of field "u8Userrestriction"

    static const int kU8Userrestriction = 42;

    /**
     * Clears the field "u8Userrestriction".
     *
     * The field will be set to its default value. The hasU8Userrestriction()
     * method will return false.
     */
    inline void clearU8Userrestriction();

    /**
     * Checks whether the field "u8Userrestriction" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Userrestriction()). Otherwise it will return false.
     */
    inline bool hasU8Userrestriction () const;

    /**
     * Returns the value of the member "u8Userrestriction".
     *
     * If the meaning of "u8Userrestriction" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Userrestriction"
     */
    inline uint8 getU8Userrestriction () const;

    /**
     * Sets the value of the member "u8Userrestriction".
     *
     * If the meaning of "u8Userrestriction" isn't clear, then there should be a description here.
     *
     * @param u8Userrestriction The value which will be set
     */
    inline void setU8Userrestriction (uint8 u8Userrestriction_);

    static const T_tcu_vacancy_spot_data &getDefaultInstance();

private:

    inline void set_has_Location ();

    inline void clear_has_Location ();

    inline void set_has_strAreaCode1 ();

    inline void clear_has_strAreaCode1 ();

    inline void set_has_strAreaCode2 ();

    inline void clear_has_strAreaCode2 ();

    inline void set_has_strAreaCode3 ();

    inline void clear_has_strAreaCode3 ();

    inline void set_has_strAreaCode4 ();

    inline void clear_has_strAreaCode4 ();

    inline void set_has_strAreaCode5 ();

    inline void clear_has_strAreaCode5 ();

    inline void set_has_strAreaCode6 ();

    inline void clear_has_strAreaCode6 ();

    inline void set_has_strAreaCode7 ();

    inline void clear_has_strAreaCode7 ();

    inline void set_has_strAreaCode8 ();

    inline void clear_has_strAreaCode8 ();

    inline void set_has_strPOIName ();

    inline void clear_has_strPOIName ();

    inline void set_has_strStreetAndHouseNo ();

    inline void clear_has_strStreetAndHouseNo ();

    inline void set_has_strTelephonenumber ();

    inline void clear_has_strTelephonenumber ();

    inline void set_has_u16Categorycode ();

    inline void clear_has_u16Categorycode ();

    inline void set_has_u16ClosedhourInformation ();

    inline void clear_has_u16ClosedhourInformation ();

    inline void set_has_u16OpeninghourInformation ();

    inline void clear_has_u16OpeninghourInformation ();

    inline void set_has_u16Parkingnumber ();

    inline void clear_has_u16Parkingnumber ();

    inline void set_has_u16Paymenttypeinformation ();

    inline void clear_has_u16Paymenttypeinformation ();

    inline void set_has_u16Sizeofdetailinformation ();

    inline void clear_has_u16Sizeofdetailinformation ();

    inline void set_has_u16Subcategorycode ();

    inline void clear_has_u16Subcategorycode ();

    inline void set_has_u32POIID ();

    inline void clear_has_u32POIID ();

    inline void set_has_u32UserrestrictionID ();

    inline void clear_has_u32UserrestrictionID ();

    inline void set_has_u8_24hoursadayinformation ();

    inline void clear_has_u8_24hoursadayinformation ();

    inline void set_has_u8Businessdayoftheweekinformation ();

    inline void clear_has_u8Businessdayoftheweekinformation ();

    inline void set_has_u8Chargingfeeinformation ();

    inline void clear_has_u8Chargingfeeinformation ();

    inline void set_has_u8Chargingtype ();

    inline void clear_has_u8Chargingtype ();

    inline void set_has_u8Detailsinformation ();

    inline void clear_has_u8Detailsinformation ();

    inline void set_has_u8Entranceinformation ();

    inline void clear_has_u8Entranceinformation ();

    inline void set_has_u8Expresswaygeneraltype ();

    inline void clear_has_u8Expresswaygeneraltype ();

    inline void set_has_u8Fixedvalue1 ();

    inline void clear_has_u8Fixedvalue1 ();

    inline void set_has_u8Fixedvalue2 ();

    inline void clear_has_u8Fixedvalue2 ();

    inline void set_has_u8Informationreliability ();

    inline void clear_has_u8Informationreliability ();

    inline void set_has_u8Installationfacilityinformation ();

    inline void clear_has_u8Installationfacilityinformation ();

    inline void set_has_u8Nearthefacilityinformation ();

    inline void clear_has_u8Nearthefacilityinformation ();

    inline void set_has_u8Officehoursunknowninformation ();

    inline void clear_has_u8Officehoursunknowninformation ();

    inline void set_has_u8Partnersfacilityinformation ();

    inline void clear_has_u8Partnersfacilityinformation ();

    inline void set_has_u8SizeOfPOIName ();

    inline void clear_has_u8SizeOfPOIName ();

    inline void set_has_u8SizeOfStreetAndHouseNo ();

    inline void clear_has_u8SizeOfStreetAndHouseNo ();

    inline void set_has_u8SizeOfTelephonenumber ();

    inline void clear_has_u8SizeOfTelephonenumber ();

    inline void set_has_u8Thenumberofentranceinformation ();

    inline void clear_has_u8Thenumberofentranceinformation ();

    inline void set_has_u8Thenumberofinstallationfacilityinformation ();

    inline void clear_has_u8Thenumberofinstallationfacilityinformation ();

    inline void set_has_u8Thenumberofpartnersfacilityinformation ();

    inline void clear_has_u8Thenumberofpartnersfacilityinformation ();

    inline void set_has_u8Thetotalnumberofchargingtype ();

    inline void clear_has_u8Thetotalnumberofchargingtype ();

    inline void set_has_u8Userrestriction ();

    inline void clear_has_u8Userrestriction ();

    uint32 _has_bits_[ (43 + 31) / 32];

    T_usb_tcu_Location _Location;

    ::std::string _strAreaCode1;

    ::std::string _strAreaCode2;

    ::std::string _strAreaCode3;

    ::std::string _strAreaCode4;

    ::std::string _strAreaCode5;

    ::std::string _strAreaCode6;

    ::std::string _strAreaCode7;

    ::std::string _strAreaCode8;

    ::std::string _strPOIName;

    ::std::string _strStreetAndHouseNo;

    ::std::string _strTelephonenumber;

    uint16 _u16Categorycode;

    uint16 _u16ClosedhourInformation;

    uint16 _u16OpeninghourInformation;

    uint16 _u16Parkingnumber;

    uint16 _u16Paymenttypeinformation;

    uint16 _u16Sizeofdetailinformation;

    uint16 _u16Subcategorycode;

    uint32 _u32POIID;

    uint32 _u32UserrestrictionID;

    uint8 _u8_24hoursadayinformation;

    uint8 _u8Businessdayoftheweekinformation;

    uint8 _u8Chargingfeeinformation;

    uint8 _u8Chargingtype;

    uint8 _u8Detailsinformation;

    uint8 _u8Entranceinformation;

    uint8 _u8Expresswaygeneraltype;

    uint8 _u8Fixedvalue1;

    uint8 _u8Fixedvalue2;

    uint8 _u8Informationreliability;

    uint8 _u8Installationfacilityinformation;

    uint8 _u8Nearthefacilityinformation;

    uint8 _u8Officehoursunknowninformation;

    uint8 _u8Partnersfacilityinformation;

    uint8 _u8SizeOfPOIName;

    uint8 _u8SizeOfStreetAndHouseNo;

    uint8 _u8SizeOfTelephonenumber;

    uint8 _u8Thenumberofentranceinformation;

    uint8 _u8Thenumberofinstallationfacilityinformation;

    uint8 _u8Thenumberofpartnersfacilityinformation;

    uint8 _u8Thetotalnumberofchargingtype;

    uint8 _u8Userrestriction;

};

/**
 * Vacancy spot data
 */
class T_tcu_response_vacancy_spot_data_result {
public:

    /**
     * Default constructor
     */
    inline  T_tcu_response_vacancy_spot_data_result ();

    /**
     * Copy constructor
     */
    inline  T_tcu_response_vacancy_spot_data_result (const T_tcu_response_vacancy_spot_data_result &rhs);

    /**
     * All fields constructor
     */
    inline  T_tcu_response_vacancy_spot_data_result (const T_tcu_vacancy_spot_data& VacancySpotData_);

    /**
     * Destructor
     */
    inline  ~T_tcu_response_vacancy_spot_data_result();

    /**
     * Assignment operator
     */
    inline T_tcu_response_vacancy_spot_data_result& operator = (const T_tcu_response_vacancy_spot_data_result& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_tcu_response_vacancy_spot_data_result& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_tcu_response_vacancy_spot_data_result& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_tcu_response_vacancy_spot_data_result& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_tcu_response_vacancy_spot_data_result& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "VacancySpotData"

    static const int kVacancySpotData = 0;

    /**
     * Clears the field "VacancySpotData".
     *
     * The field will be set to its default value. The hasVacancySpotData()
     * method will return false.
     */
    inline void clearVacancySpotData();

    /**
     * Checks whether the field "VacancySpotData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVacancySpotData()). Otherwise it will return false.
     */
    inline bool hasVacancySpotData () const;

    /**
     * Returns the value of the member "VacancySpotData".
     *
     * Vacancy Station data
     *
     * @return The value of the field "VacancySpotData"
     */
    inline const T_tcu_vacancy_spot_data& getVacancySpotData () const;

    /**
     * Retrieves the value of the field "VacancySpotData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "VacancySpotData".
     */
    inline T_tcu_vacancy_spot_data& getVacancySpotDataMutable ();

    /**
     * Sets the value of the member "VacancySpotData".
     *
     * Vacancy Station data
     *
     * @param VacancySpotData The value which will be set
     */
    inline void setVacancySpotData (const T_tcu_vacancy_spot_data& VacancySpotData_);

    static const T_tcu_response_vacancy_spot_data_result &getDefaultInstance();

private:

    inline void set_has_VacancySpotData ();

    inline void clear_has_VacancySpotData ();

    uint32 _has_bits_[ (1 + 31) / 32];

    T_tcu_vacancy_spot_data _VacancySpotData;

};

/**
 * If the meaning of "T_usb_tcu_Server_Info" isn't clear, then there should be a description here.
 */
class T_usb_tcu_Server_Info {
public:

    /**
     * Default constructor
     */
    inline  T_usb_tcu_Server_Info ();

    /**
     * Copy constructor
     */
    inline  T_usb_tcu_Server_Info (const T_usb_tcu_Server_Info &rhs);

    /**
     * All fields constructor
     */
    inline  T_usb_tcu_Server_Info (const ::std::string& strServerAddress_, const ::std::string& strServerName_, uint8 u8ServerId_);

    /**
     * Destructor
     */
    inline  ~T_usb_tcu_Server_Info();

    /**
     * Assignment operator
     */
    inline T_usb_tcu_Server_Info& operator = (const T_usb_tcu_Server_Info& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_usb_tcu_Server_Info& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_usb_tcu_Server_Info& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_usb_tcu_Server_Info& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_usb_tcu_Server_Info& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "strServerAddress"

    static const int kStrServerAddress = 0;

    /**
     * Clears the field "strServerAddress".
     *
     * The field will be set to its default value. The hasStrServerAddress()
     * method will return false.
     */
    inline void clearStrServerAddress();

    /**
     * Checks whether the field "strServerAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrServerAddress()). Otherwise it will return false.
     */
    inline bool hasStrServerAddress () const;

    /**
     * Returns the value of the member "strServerAddress".
     *
     * Server URL.
     *
     * @return The value of the field "strServerAddress"
     */
    inline const ::std::string& getStrServerAddress () const;

    /**
     * Retrieves the value of the field "strServerAddress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strServerAddress".
     */
    inline ::std::string& getStrServerAddressMutable ();

    /**
     * Sets the value of the member "strServerAddress".
     *
     * Server URL.
     *
     * @param strServerAddress The value which will be set
     */
    inline void setStrServerAddress (const ::std::string& strServerAddress_);

    /**
     * Sets the value of the member "strServerAddress".
     *
     * Server URL.
     *
     * @param strServerAddress The value which will be set
     */
    inline void setStrServerAddress (const char* strServerAddress_);

    /**
     * Sets the value of the member "strServerAddress".
     *
     * Server URL.
     *
     * @param strServerAddress The value which will be set
     */
    inline void setStrServerAddress (const char* value, size_t size);

    // API of field "strServerName"

    static const int kStrServerName = 1;

    /**
     * Clears the field "strServerName".
     *
     * The field will be set to its default value. The hasStrServerName()
     * method will return false.
     */
    inline void clearStrServerName();

    /**
     * Checks whether the field "strServerName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrServerName()). Otherwise it will return false.
     */
    inline bool hasStrServerName () const;

    /**
     * Returns the value of the member "strServerName".
     *
     * Server name.
     *
     * @return The value of the field "strServerName"
     */
    inline const ::std::string& getStrServerName () const;

    /**
     * Retrieves the value of the field "strServerName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strServerName".
     */
    inline ::std::string& getStrServerNameMutable ();

    /**
     * Sets the value of the member "strServerName".
     *
     * Server name.
     *
     * @param strServerName The value which will be set
     */
    inline void setStrServerName (const ::std::string& strServerName_);

    /**
     * Sets the value of the member "strServerName".
     *
     * Server name.
     *
     * @param strServerName The value which will be set
     */
    inline void setStrServerName (const char* strServerName_);

    /**
     * Sets the value of the member "strServerName".
     *
     * Server name.
     *
     * @param strServerName The value which will be set
     */
    inline void setStrServerName (const char* value, size_t size);

    // API of field "u8ServerId"

    static const int kU8ServerId = 2;

    /**
     * Clears the field "u8ServerId".
     *
     * The field will be set to its default value. The hasU8ServerId()
     * method will return false.
     */
    inline void clearU8ServerId();

    /**
     * Checks whether the field "u8ServerId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8ServerId()). Otherwise it will return false.
     */
    inline bool hasU8ServerId () const;

    /**
     * Returns the value of the member "u8ServerId".
     *
     * Server ID.
     *
     * @return The value of the field "u8ServerId"
     */
    inline uint8 getU8ServerId () const;

    /**
     * Sets the value of the member "u8ServerId".
     *
     * Server ID.
     *
     * @param u8ServerId The value which will be set
     */
    inline void setU8ServerId (uint8 u8ServerId_);

    static const T_usb_tcu_Server_Info &getDefaultInstance();

private:

    inline void set_has_strServerAddress ();

    inline void clear_has_strServerAddress ();

    inline void set_has_strServerName ();

    inline void clear_has_strServerName ();

    inline void set_has_u8ServerId ();

    inline void clear_has_u8ServerId ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _strServerAddress;

    ::std::string _strServerName;

    uint8 _u8ServerId;

};

/**
 * If the meaning of "T_usb_tcu_TCUDevice_Info" isn't clear, then there should be a description here.
 */
class T_usb_tcu_TCUDevice_Info {
public:

    /**
     * Default constructor
     */
    inline  T_usb_tcu_TCUDevice_Info ();

    /**
     * Copy constructor
     */
    inline  T_usb_tcu_TCUDevice_Info (const T_usb_tcu_TCUDevice_Info &rhs);

    /**
     * All fields constructor
     */
    inline  T_usb_tcu_TCUDevice_Info (T_e8_ModemType eModemType_, bool bUSBConnectionStatus_);

    /**
     * Destructor
     */
    inline  ~T_usb_tcu_TCUDevice_Info();

    /**
     * Assignment operator
     */
    inline T_usb_tcu_TCUDevice_Info& operator = (const T_usb_tcu_TCUDevice_Info& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_usb_tcu_TCUDevice_Info& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_usb_tcu_TCUDevice_Info& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_usb_tcu_TCUDevice_Info& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_usb_tcu_TCUDevice_Info& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "eModemType"

    static const int kEModemType = 0;

    /**
     * Clears the field "eModemType".
     *
     * The field will be set to its default value. The hasEModemType()
     * method will return false.
     */
    inline void clearEModemType();

    /**
     * Checks whether the field "eModemType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEModemType()). Otherwise it will return false.
     */
    inline bool hasEModemType () const;

    /**
     * Returns the value of the member "eModemType".
     *
     * Modem type.
     *
     * @return The value of the field "eModemType"
     */
    inline T_e8_ModemType getEModemType () const;

    /**
     * Sets the value of the member "eModemType".
     *
     * Modem type.
     *
     * @param eModemType The value which will be set
     */
    inline void setEModemType (T_e8_ModemType eModemType_);

    // API of field "bUSBConnectionStatus"

    static const int kBUSBConnectionStatus = 1;

    /**
     * Clears the field "bUSBConnectionStatus".
     *
     * The field will be set to its default value. The hasBUSBConnectionStatus()
     * method will return false.
     */
    inline void clearBUSBConnectionStatus();

    /**
     * Checks whether the field "bUSBConnectionStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBUSBConnectionStatus()). Otherwise it will return false.
     */
    inline bool hasBUSBConnectionStatus () const;

    /**
     * Returns the value of the member "bUSBConnectionStatus".
     *
     * USB connection status.
     *
     * @return The value of the field "bUSBConnectionStatus"
     */
    inline bool getBUSBConnectionStatus () const;

    /**
     * Sets the value of the member "bUSBConnectionStatus".
     *
     * USB connection status.
     *
     * @param bUSBConnectionStatus The value which will be set
     */
    inline void setBUSBConnectionStatus (bool bUSBConnectionStatus_);

    static const T_usb_tcu_TCUDevice_Info &getDefaultInstance();

private:

    inline void set_has_eModemType ();

    inline void clear_has_eModemType ();

    inline void set_has_bUSBConnectionStatus ();

    inline void clear_has_bUSBConnectionStatus ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_ModemType _eModemType;

    bool _bUSBConnectionStatus;

};

/**
 * If the meaning of "T_usb_tcu_UserAuthentication_DecodedToken_Info" isn't clear, then there should be a description here.
 */
class T_usb_tcu_UserAuthentication_DecodedToken_Info {
public:

    /**
     * Default constructor
     */
    inline  T_usb_tcu_UserAuthentication_DecodedToken_Info ();

    /**
     * Copy constructor
     */
    inline  T_usb_tcu_UserAuthentication_DecodedToken_Info (const T_usb_tcu_UserAuthentication_DecodedToken_Info &rhs);

    /**
     * All fields constructor
     */
    inline  T_usb_tcu_UserAuthentication_DecodedToken_Info (const ::std::string& KID_);

    /**
     * Destructor
     */
    inline  ~T_usb_tcu_UserAuthentication_DecodedToken_Info();

    /**
     * Assignment operator
     */
    inline T_usb_tcu_UserAuthentication_DecodedToken_Info& operator = (const T_usb_tcu_UserAuthentication_DecodedToken_Info& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_usb_tcu_UserAuthentication_DecodedToken_Info& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_usb_tcu_UserAuthentication_DecodedToken_Info& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_usb_tcu_UserAuthentication_DecodedToken_Info& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_usb_tcu_UserAuthentication_DecodedToken_Info& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "KID"

    static const int kKID = 0;

    /**
     * Clears the field "KID".
     *
     * The field will be set to its default value. The hasKID()
     * method will return false.
     */
    inline void clearKID();

    /**
     * Checks whether the field "KID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setKID()). Otherwise it will return false.
     */
    inline bool hasKID () const;

    /**
     * Returns the value of the member "KID".
     *
     * KID extracted from IdToken
     *
     * @return The value of the field "KID"
     */
    inline const ::std::string& getKID () const;

    /**
     * Retrieves the value of the field "KID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "KID".
     */
    inline ::std::string& getKIDMutable ();

    /**
     * Sets the value of the member "KID".
     *
     * KID extracted from IdToken
     *
     * @param KID The value which will be set
     */
    inline void setKID (const ::std::string& KID_);

    /**
     * Sets the value of the member "KID".
     *
     * KID extracted from IdToken
     *
     * @param KID The value which will be set
     */
    inline void setKID (const char* KID_);

    /**
     * Sets the value of the member "KID".
     *
     * KID extracted from IdToken
     *
     * @param KID The value which will be set
     */
    inline void setKID (const char* value, size_t size);

    static const T_usb_tcu_UserAuthentication_DecodedToken_Info &getDefaultInstance();

private:

    inline void set_has_KID ();

    inline void clear_has_KID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _KID;

};

inline  T_usb_tcu_Charging_Stations_Request_Info::T_usb_tcu_Charging_Stations_Request_Info ()  :
    _u16MaxNumberOfPOI (0u),
    _u16SearchRange (0u),
    _u16XCoordinate (0u),
    _u16YCoordinate (0u),
    _u32MeshID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_usb_tcu_Charging_Stations_Request_Info::T_usb_tcu_Charging_Stations_Request_Info (const T_usb_tcu_Charging_Stations_Request_Info &rhs)  :
    _u16MaxNumberOfPOI (0u),
    _u16SearchRange (0u),
    _u16XCoordinate (0u),
    _u16YCoordinate (0u),
    _u32MeshID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_usb_tcu_Charging_Stations_Request_Info::T_usb_tcu_Charging_Stations_Request_Info (uint16 u16MaxNumberOfPOI_, uint16 u16SearchRange_, uint16 u16XCoordinate_, uint16 u16YCoordinate_, uint32 u32MeshID_)  :
    _u16MaxNumberOfPOI (u16MaxNumberOfPOI_),
    _u16SearchRange (u16SearchRange_),
    _u16XCoordinate (u16XCoordinate_),
    _u16YCoordinate (u16YCoordinate_),
    _u32MeshID (u32MeshID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_usb_tcu_Charging_Stations_Request_Info::~T_usb_tcu_Charging_Stations_Request_Info() {
}

inline T_usb_tcu_Charging_Stations_Request_Info& T_usb_tcu_Charging_Stations_Request_Info::operator = (const T_usb_tcu_Charging_Stations_Request_Info& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU16MaxNumberOfPOI()) {
            setU16MaxNumberOfPOI(rhs.getU16MaxNumberOfPOI());
        } else {
            clearU16MaxNumberOfPOI();
        }
        if (rhs.hasU16SearchRange()) {
            setU16SearchRange(rhs.getU16SearchRange());
        } else {
            clearU16SearchRange();
        }
        if (rhs.hasU16XCoordinate()) {
            setU16XCoordinate(rhs.getU16XCoordinate());
        } else {
            clearU16XCoordinate();
        }
        if (rhs.hasU16YCoordinate()) {
            setU16YCoordinate(rhs.getU16YCoordinate());
        } else {
            clearU16YCoordinate();
        }
        if (rhs.hasU32MeshID()) {
            setU32MeshID(rhs.getU32MeshID());
        } else {
            clearU32MeshID();
        }
    }
    return *this;
}

inline bool T_usb_tcu_Charging_Stations_Request_Info::operator == (const T_usb_tcu_Charging_Stations_Request_Info& rhs) const {
    return (((!hasU16MaxNumberOfPOI() && !rhs.hasU16MaxNumberOfPOI()) || getU16MaxNumberOfPOI() == rhs.getU16MaxNumberOfPOI()) &&
        ((!hasU16SearchRange() && !rhs.hasU16SearchRange()) || getU16SearchRange() == rhs.getU16SearchRange()) &&
        ((!hasU16XCoordinate() && !rhs.hasU16XCoordinate()) || getU16XCoordinate() == rhs.getU16XCoordinate()) &&
        ((!hasU16YCoordinate() && !rhs.hasU16YCoordinate()) || getU16YCoordinate() == rhs.getU16YCoordinate()) &&
        ((!hasU32MeshID() && !rhs.hasU32MeshID()) || getU32MeshID() == rhs.getU32MeshID()));
}

inline bool T_usb_tcu_Charging_Stations_Request_Info::operator != (const T_usb_tcu_Charging_Stations_Request_Info& rhs) const {
    return ! (*this == rhs);
}

inline bool T_usb_tcu_Charging_Stations_Request_Info::operator < (const T_usb_tcu_Charging_Stations_Request_Info& rhs) const {
    if (hasU16MaxNumberOfPOI() || rhs.hasU16MaxNumberOfPOI()) {
        if (getU16MaxNumberOfPOI() < rhs.getU16MaxNumberOfPOI()) return true;
        if (getU16MaxNumberOfPOI() > rhs.getU16MaxNumberOfPOI()) return false;
    }
    if (hasU16SearchRange() || rhs.hasU16SearchRange()) {
        if (getU16SearchRange() < rhs.getU16SearchRange()) return true;
        if (getU16SearchRange() > rhs.getU16SearchRange()) return false;
    }
    if (hasU16XCoordinate() || rhs.hasU16XCoordinate()) {
        if (getU16XCoordinate() < rhs.getU16XCoordinate()) return true;
        if (getU16XCoordinate() > rhs.getU16XCoordinate()) return false;
    }
    if (hasU16YCoordinate() || rhs.hasU16YCoordinate()) {
        if (getU16YCoordinate() < rhs.getU16YCoordinate()) return true;
        if (getU16YCoordinate() > rhs.getU16YCoordinate()) return false;
    }
    if (hasU32MeshID() || rhs.hasU32MeshID()) {
        if (getU32MeshID() < rhs.getU32MeshID()) return true;
        if (getU32MeshID() > rhs.getU32MeshID()) return false;
    }
    return false;
}

inline bool T_usb_tcu_Charging_Stations_Request_Info::operator > (const T_usb_tcu_Charging_Stations_Request_Info& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_usb_tcu_Charging_Stations_Request_Info::clear() {
    clearU16MaxNumberOfPOI();
    clearU16SearchRange();
    clearU16XCoordinate();
    clearU16YCoordinate();
    clearU32MeshID();
}

inline void T_usb_tcu_Charging_Stations_Request_Info::clearU16MaxNumberOfPOI() {
    if (hasU16MaxNumberOfPOI()) {
         clear_has_u16MaxNumberOfPOI();
        _u16MaxNumberOfPOI = 0u;
     }
}

inline bool T_usb_tcu_Charging_Stations_Request_Info::hasU16MaxNumberOfPOI () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 T_usb_tcu_Charging_Stations_Request_Info::getU16MaxNumberOfPOI () const {
    return _u16MaxNumberOfPOI;
}

inline void T_usb_tcu_Charging_Stations_Request_Info::setU16MaxNumberOfPOI (uint16 u16MaxNumberOfPOI_) {
    set_has_u16MaxNumberOfPOI();
    this->_u16MaxNumberOfPOI = u16MaxNumberOfPOI_;
}

inline void T_usb_tcu_Charging_Stations_Request_Info::clearU16SearchRange() {
    if (hasU16SearchRange()) {
         clear_has_u16SearchRange();
        _u16SearchRange = 0u;
     }
}

inline bool T_usb_tcu_Charging_Stations_Request_Info::hasU16SearchRange () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 T_usb_tcu_Charging_Stations_Request_Info::getU16SearchRange () const {
    return _u16SearchRange;
}

inline void T_usb_tcu_Charging_Stations_Request_Info::setU16SearchRange (uint16 u16SearchRange_) {
    set_has_u16SearchRange();
    this->_u16SearchRange = u16SearchRange_;
}

inline void T_usb_tcu_Charging_Stations_Request_Info::clearU16XCoordinate() {
    if (hasU16XCoordinate()) {
         clear_has_u16XCoordinate();
        _u16XCoordinate = 0u;
     }
}

inline bool T_usb_tcu_Charging_Stations_Request_Info::hasU16XCoordinate () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 T_usb_tcu_Charging_Stations_Request_Info::getU16XCoordinate () const {
    return _u16XCoordinate;
}

inline void T_usb_tcu_Charging_Stations_Request_Info::setU16XCoordinate (uint16 u16XCoordinate_) {
    set_has_u16XCoordinate();
    this->_u16XCoordinate = u16XCoordinate_;
}

inline void T_usb_tcu_Charging_Stations_Request_Info::clearU16YCoordinate() {
    if (hasU16YCoordinate()) {
         clear_has_u16YCoordinate();
        _u16YCoordinate = 0u;
     }
}

inline bool T_usb_tcu_Charging_Stations_Request_Info::hasU16YCoordinate () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 T_usb_tcu_Charging_Stations_Request_Info::getU16YCoordinate () const {
    return _u16YCoordinate;
}

inline void T_usb_tcu_Charging_Stations_Request_Info::setU16YCoordinate (uint16 u16YCoordinate_) {
    set_has_u16YCoordinate();
    this->_u16YCoordinate = u16YCoordinate_;
}

inline void T_usb_tcu_Charging_Stations_Request_Info::clearU32MeshID() {
    if (hasU32MeshID()) {
         clear_has_u32MeshID();
        _u32MeshID = 0u;
     }
}

inline bool T_usb_tcu_Charging_Stations_Request_Info::hasU32MeshID () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint32 T_usb_tcu_Charging_Stations_Request_Info::getU32MeshID () const {
    return _u32MeshID;
}

inline void T_usb_tcu_Charging_Stations_Request_Info::setU32MeshID (uint32 u32MeshID_) {
    set_has_u32MeshID();
    this->_u32MeshID = u32MeshID_;
}

inline void T_usb_tcu_Charging_Stations_Request_Info::set_has_u16MaxNumberOfPOI () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_usb_tcu_Charging_Stations_Request_Info::clear_has_u16MaxNumberOfPOI () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_usb_tcu_Charging_Stations_Request_Info::set_has_u16SearchRange () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_usb_tcu_Charging_Stations_Request_Info::clear_has_u16SearchRange () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_usb_tcu_Charging_Stations_Request_Info::set_has_u16XCoordinate () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_usb_tcu_Charging_Stations_Request_Info::clear_has_u16XCoordinate () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_usb_tcu_Charging_Stations_Request_Info::set_has_u16YCoordinate () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_usb_tcu_Charging_Stations_Request_Info::clear_has_u16YCoordinate () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_usb_tcu_Charging_Stations_Request_Info::set_has_u32MeshID () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_usb_tcu_Charging_Stations_Request_Info::clear_has_u32MeshID () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  T_usb_tcu_Vacancy_Stations_Request_Info::T_usb_tcu_Vacancy_Stations_Request_Info ()  :
    _u16CruisingDistance (0u),
    _u16Lat_second (0u),
    _u16Long_second (0u),
    _u16RemainingBatteryCapacity (0u),
    _u8CoordinateSystem (0u),
    _u8Lat_Degree (0u),
    _u8Lat_minute (0u),
    _u8Long_Degree (0u),
    _u8Long_minute (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_usb_tcu_Vacancy_Stations_Request_Info::T_usb_tcu_Vacancy_Stations_Request_Info (const T_usb_tcu_Vacancy_Stations_Request_Info &rhs)  :
    _u16CruisingDistance (0u),
    _u16Lat_second (0u),
    _u16Long_second (0u),
    _u16RemainingBatteryCapacity (0u),
    _u8CoordinateSystem (0u),
    _u8Lat_Degree (0u),
    _u8Lat_minute (0u),
    _u8Long_Degree (0u),
    _u8Long_minute (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_usb_tcu_Vacancy_Stations_Request_Info::T_usb_tcu_Vacancy_Stations_Request_Info (uint16 u16CruisingDistance_, uint16 u16Lat_second_, uint16 u16Long_second_, uint16 u16RemainingBatteryCapacity_, uint8 u8CoordinateSystem_, uint8 u8Lat_Degree_, uint8 u8Lat_minute_, uint8 u8Long_Degree_, uint8 u8Long_minute_)  :
    _u16CruisingDistance (u16CruisingDistance_),
    _u16Lat_second (u16Lat_second_),
    _u16Long_second (u16Long_second_),
    _u16RemainingBatteryCapacity (u16RemainingBatteryCapacity_),
    _u8CoordinateSystem (u8CoordinateSystem_),
    _u8Lat_Degree (u8Lat_Degree_),
    _u8Lat_minute (u8Lat_minute_),
    _u8Long_Degree (u8Long_Degree_),
    _u8Long_minute (u8Long_minute_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_usb_tcu_Vacancy_Stations_Request_Info::~T_usb_tcu_Vacancy_Stations_Request_Info() {
}

inline T_usb_tcu_Vacancy_Stations_Request_Info& T_usb_tcu_Vacancy_Stations_Request_Info::operator = (const T_usb_tcu_Vacancy_Stations_Request_Info& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU16CruisingDistance()) {
            setU16CruisingDistance(rhs.getU16CruisingDistance());
        } else {
            clearU16CruisingDistance();
        }
        if (rhs.hasU16Lat_second()) {
            setU16Lat_second(rhs.getU16Lat_second());
        } else {
            clearU16Lat_second();
        }
        if (rhs.hasU16Long_second()) {
            setU16Long_second(rhs.getU16Long_second());
        } else {
            clearU16Long_second();
        }
        if (rhs.hasU16RemainingBatteryCapacity()) {
            setU16RemainingBatteryCapacity(rhs.getU16RemainingBatteryCapacity());
        } else {
            clearU16RemainingBatteryCapacity();
        }
        if (rhs.hasU8CoordinateSystem()) {
            setU8CoordinateSystem(rhs.getU8CoordinateSystem());
        } else {
            clearU8CoordinateSystem();
        }
        if (rhs.hasU8Lat_Degree()) {
            setU8Lat_Degree(rhs.getU8Lat_Degree());
        } else {
            clearU8Lat_Degree();
        }
        if (rhs.hasU8Lat_minute()) {
            setU8Lat_minute(rhs.getU8Lat_minute());
        } else {
            clearU8Lat_minute();
        }
        if (rhs.hasU8Long_Degree()) {
            setU8Long_Degree(rhs.getU8Long_Degree());
        } else {
            clearU8Long_Degree();
        }
        if (rhs.hasU8Long_minute()) {
            setU8Long_minute(rhs.getU8Long_minute());
        } else {
            clearU8Long_minute();
        }
    }
    return *this;
}

inline bool T_usb_tcu_Vacancy_Stations_Request_Info::operator == (const T_usb_tcu_Vacancy_Stations_Request_Info& rhs) const {
    return (((!hasU16CruisingDistance() && !rhs.hasU16CruisingDistance()) || getU16CruisingDistance() == rhs.getU16CruisingDistance()) &&
        ((!hasU16Lat_second() && !rhs.hasU16Lat_second()) || getU16Lat_second() == rhs.getU16Lat_second()) &&
        ((!hasU16Long_second() && !rhs.hasU16Long_second()) || getU16Long_second() == rhs.getU16Long_second()) &&
        ((!hasU16RemainingBatteryCapacity() && !rhs.hasU16RemainingBatteryCapacity()) || getU16RemainingBatteryCapacity() == rhs.getU16RemainingBatteryCapacity()) &&
        ((!hasU8CoordinateSystem() && !rhs.hasU8CoordinateSystem()) || getU8CoordinateSystem() == rhs.getU8CoordinateSystem()) &&
        ((!hasU8Lat_Degree() && !rhs.hasU8Lat_Degree()) || getU8Lat_Degree() == rhs.getU8Lat_Degree()) &&
        ((!hasU8Lat_minute() && !rhs.hasU8Lat_minute()) || getU8Lat_minute() == rhs.getU8Lat_minute()) &&
        ((!hasU8Long_Degree() && !rhs.hasU8Long_Degree()) || getU8Long_Degree() == rhs.getU8Long_Degree()) &&
        ((!hasU8Long_minute() && !rhs.hasU8Long_minute()) || getU8Long_minute() == rhs.getU8Long_minute()));
}

inline bool T_usb_tcu_Vacancy_Stations_Request_Info::operator != (const T_usb_tcu_Vacancy_Stations_Request_Info& rhs) const {
    return ! (*this == rhs);
}

inline bool T_usb_tcu_Vacancy_Stations_Request_Info::operator < (const T_usb_tcu_Vacancy_Stations_Request_Info& rhs) const {
    if (hasU16CruisingDistance() || rhs.hasU16CruisingDistance()) {
        if (getU16CruisingDistance() < rhs.getU16CruisingDistance()) return true;
        if (getU16CruisingDistance() > rhs.getU16CruisingDistance()) return false;
    }
    if (hasU16Lat_second() || rhs.hasU16Lat_second()) {
        if (getU16Lat_second() < rhs.getU16Lat_second()) return true;
        if (getU16Lat_second() > rhs.getU16Lat_second()) return false;
    }
    if (hasU16Long_second() || rhs.hasU16Long_second()) {
        if (getU16Long_second() < rhs.getU16Long_second()) return true;
        if (getU16Long_second() > rhs.getU16Long_second()) return false;
    }
    if (hasU16RemainingBatteryCapacity() || rhs.hasU16RemainingBatteryCapacity()) {
        if (getU16RemainingBatteryCapacity() < rhs.getU16RemainingBatteryCapacity()) return true;
        if (getU16RemainingBatteryCapacity() > rhs.getU16RemainingBatteryCapacity()) return false;
    }
    if (hasU8CoordinateSystem() || rhs.hasU8CoordinateSystem()) {
        if (getU8CoordinateSystem() < rhs.getU8CoordinateSystem()) return true;
        if (getU8CoordinateSystem() > rhs.getU8CoordinateSystem()) return false;
    }
    if (hasU8Lat_Degree() || rhs.hasU8Lat_Degree()) {
        if (getU8Lat_Degree() < rhs.getU8Lat_Degree()) return true;
        if (getU8Lat_Degree() > rhs.getU8Lat_Degree()) return false;
    }
    if (hasU8Lat_minute() || rhs.hasU8Lat_minute()) {
        if (getU8Lat_minute() < rhs.getU8Lat_minute()) return true;
        if (getU8Lat_minute() > rhs.getU8Lat_minute()) return false;
    }
    if (hasU8Long_Degree() || rhs.hasU8Long_Degree()) {
        if (getU8Long_Degree() < rhs.getU8Long_Degree()) return true;
        if (getU8Long_Degree() > rhs.getU8Long_Degree()) return false;
    }
    if (hasU8Long_minute() || rhs.hasU8Long_minute()) {
        if (getU8Long_minute() < rhs.getU8Long_minute()) return true;
        if (getU8Long_minute() > rhs.getU8Long_minute()) return false;
    }
    return false;
}

inline bool T_usb_tcu_Vacancy_Stations_Request_Info::operator > (const T_usb_tcu_Vacancy_Stations_Request_Info& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_usb_tcu_Vacancy_Stations_Request_Info::clear() {
    clearU16CruisingDistance();
    clearU16Lat_second();
    clearU16Long_second();
    clearU16RemainingBatteryCapacity();
    clearU8CoordinateSystem();
    clearU8Lat_Degree();
    clearU8Lat_minute();
    clearU8Long_Degree();
    clearU8Long_minute();
}

inline void T_usb_tcu_Vacancy_Stations_Request_Info::clearU16CruisingDistance() {
    if (hasU16CruisingDistance()) {
         clear_has_u16CruisingDistance();
        _u16CruisingDistance = 0u;
     }
}

inline bool T_usb_tcu_Vacancy_Stations_Request_Info::hasU16CruisingDistance () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 T_usb_tcu_Vacancy_Stations_Request_Info::getU16CruisingDistance () const {
    return _u16CruisingDistance;
}

inline void T_usb_tcu_Vacancy_Stations_Request_Info::setU16CruisingDistance (uint16 u16CruisingDistance_) {
    set_has_u16CruisingDistance();
    this->_u16CruisingDistance = u16CruisingDistance_;
}

inline void T_usb_tcu_Vacancy_Stations_Request_Info::clearU16Lat_second() {
    if (hasU16Lat_second()) {
         clear_has_u16Lat_second();
        _u16Lat_second = 0u;
     }
}

inline bool T_usb_tcu_Vacancy_Stations_Request_Info::hasU16Lat_second () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 T_usb_tcu_Vacancy_Stations_Request_Info::getU16Lat_second () const {
    return _u16Lat_second;
}

inline void T_usb_tcu_Vacancy_Stations_Request_Info::setU16Lat_second (uint16 u16Lat_second_) {
    set_has_u16Lat_second();
    this->_u16Lat_second = u16Lat_second_;
}

inline void T_usb_tcu_Vacancy_Stations_Request_Info::clearU16Long_second() {
    if (hasU16Long_second()) {
         clear_has_u16Long_second();
        _u16Long_second = 0u;
     }
}

inline bool T_usb_tcu_Vacancy_Stations_Request_Info::hasU16Long_second () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 T_usb_tcu_Vacancy_Stations_Request_Info::getU16Long_second () const {
    return _u16Long_second;
}

inline void T_usb_tcu_Vacancy_Stations_Request_Info::setU16Long_second (uint16 u16Long_second_) {
    set_has_u16Long_second();
    this->_u16Long_second = u16Long_second_;
}

inline void T_usb_tcu_Vacancy_Stations_Request_Info::clearU16RemainingBatteryCapacity() {
    if (hasU16RemainingBatteryCapacity()) {
         clear_has_u16RemainingBatteryCapacity();
        _u16RemainingBatteryCapacity = 0u;
     }
}

inline bool T_usb_tcu_Vacancy_Stations_Request_Info::hasU16RemainingBatteryCapacity () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 T_usb_tcu_Vacancy_Stations_Request_Info::getU16RemainingBatteryCapacity () const {
    return _u16RemainingBatteryCapacity;
}

inline void T_usb_tcu_Vacancy_Stations_Request_Info::setU16RemainingBatteryCapacity (uint16 u16RemainingBatteryCapacity_) {
    set_has_u16RemainingBatteryCapacity();
    this->_u16RemainingBatteryCapacity = u16RemainingBatteryCapacity_;
}

inline void T_usb_tcu_Vacancy_Stations_Request_Info::clearU8CoordinateSystem() {
    if (hasU8CoordinateSystem()) {
         clear_has_u8CoordinateSystem();
        _u8CoordinateSystem = 0u;
     }
}

inline bool T_usb_tcu_Vacancy_Stations_Request_Info::hasU8CoordinateSystem () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 T_usb_tcu_Vacancy_Stations_Request_Info::getU8CoordinateSystem () const {
    return _u8CoordinateSystem;
}

inline void T_usb_tcu_Vacancy_Stations_Request_Info::setU8CoordinateSystem (uint8 u8CoordinateSystem_) {
    set_has_u8CoordinateSystem();
    this->_u8CoordinateSystem = u8CoordinateSystem_;
}

inline void T_usb_tcu_Vacancy_Stations_Request_Info::clearU8Lat_Degree() {
    if (hasU8Lat_Degree()) {
         clear_has_u8Lat_Degree();
        _u8Lat_Degree = 0u;
     }
}

inline bool T_usb_tcu_Vacancy_Stations_Request_Info::hasU8Lat_Degree () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint8 T_usb_tcu_Vacancy_Stations_Request_Info::getU8Lat_Degree () const {
    return _u8Lat_Degree;
}

inline void T_usb_tcu_Vacancy_Stations_Request_Info::setU8Lat_Degree (uint8 u8Lat_Degree_) {
    set_has_u8Lat_Degree();
    this->_u8Lat_Degree = u8Lat_Degree_;
}

inline void T_usb_tcu_Vacancy_Stations_Request_Info::clearU8Lat_minute() {
    if (hasU8Lat_minute()) {
         clear_has_u8Lat_minute();
        _u8Lat_minute = 0u;
     }
}

inline bool T_usb_tcu_Vacancy_Stations_Request_Info::hasU8Lat_minute () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint8 T_usb_tcu_Vacancy_Stations_Request_Info::getU8Lat_minute () const {
    return _u8Lat_minute;
}

inline void T_usb_tcu_Vacancy_Stations_Request_Info::setU8Lat_minute (uint8 u8Lat_minute_) {
    set_has_u8Lat_minute();
    this->_u8Lat_minute = u8Lat_minute_;
}

inline void T_usb_tcu_Vacancy_Stations_Request_Info::clearU8Long_Degree() {
    if (hasU8Long_Degree()) {
         clear_has_u8Long_Degree();
        _u8Long_Degree = 0u;
     }
}

inline bool T_usb_tcu_Vacancy_Stations_Request_Info::hasU8Long_Degree () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline uint8 T_usb_tcu_Vacancy_Stations_Request_Info::getU8Long_Degree () const {
    return _u8Long_Degree;
}

inline void T_usb_tcu_Vacancy_Stations_Request_Info::setU8Long_Degree (uint8 u8Long_Degree_) {
    set_has_u8Long_Degree();
    this->_u8Long_Degree = u8Long_Degree_;
}

inline void T_usb_tcu_Vacancy_Stations_Request_Info::clearU8Long_minute() {
    if (hasU8Long_minute()) {
         clear_has_u8Long_minute();
        _u8Long_minute = 0u;
     }
}

inline bool T_usb_tcu_Vacancy_Stations_Request_Info::hasU8Long_minute () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline uint8 T_usb_tcu_Vacancy_Stations_Request_Info::getU8Long_minute () const {
    return _u8Long_minute;
}

inline void T_usb_tcu_Vacancy_Stations_Request_Info::setU8Long_minute (uint8 u8Long_minute_) {
    set_has_u8Long_minute();
    this->_u8Long_minute = u8Long_minute_;
}

inline void T_usb_tcu_Vacancy_Stations_Request_Info::set_has_u16CruisingDistance () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_usb_tcu_Vacancy_Stations_Request_Info::clear_has_u16CruisingDistance () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_usb_tcu_Vacancy_Stations_Request_Info::set_has_u16Lat_second () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_usb_tcu_Vacancy_Stations_Request_Info::clear_has_u16Lat_second () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_usb_tcu_Vacancy_Stations_Request_Info::set_has_u16Long_second () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_usb_tcu_Vacancy_Stations_Request_Info::clear_has_u16Long_second () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_usb_tcu_Vacancy_Stations_Request_Info::set_has_u16RemainingBatteryCapacity () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_usb_tcu_Vacancy_Stations_Request_Info::clear_has_u16RemainingBatteryCapacity () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_usb_tcu_Vacancy_Stations_Request_Info::set_has_u8CoordinateSystem () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_usb_tcu_Vacancy_Stations_Request_Info::clear_has_u8CoordinateSystem () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_usb_tcu_Vacancy_Stations_Request_Info::set_has_u8Lat_Degree () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_usb_tcu_Vacancy_Stations_Request_Info::clear_has_u8Lat_Degree () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_usb_tcu_Vacancy_Stations_Request_Info::set_has_u8Lat_minute () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_usb_tcu_Vacancy_Stations_Request_Info::clear_has_u8Lat_minute () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_usb_tcu_Vacancy_Stations_Request_Info::set_has_u8Long_Degree () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_usb_tcu_Vacancy_Stations_Request_Info::clear_has_u8Long_Degree () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_usb_tcu_Vacancy_Stations_Request_Info::set_has_u8Long_minute () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_usb_tcu_Vacancy_Stations_Request_Info::clear_has_u8Long_minute () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline  T_usb_tcu_Favorite_channel_info::T_usb_tcu_Favorite_channel_info ()  :
    _strChannelName (),
    _strChannelNameForTTS (),
    _u16ChannelID (0u),
    _u8FavoriteChannelListID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_usb_tcu_Favorite_channel_info::T_usb_tcu_Favorite_channel_info (const T_usb_tcu_Favorite_channel_info &rhs)  :
    _strChannelName (),
    _strChannelNameForTTS (),
    _u16ChannelID (0u),
    _u8FavoriteChannelListID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_usb_tcu_Favorite_channel_info::T_usb_tcu_Favorite_channel_info (const ::std::string& strChannelName_, const ::std::string& strChannelNameForTTS_, uint16 u16ChannelID_, uint8 u8FavoriteChannelListID_)  :
    _strChannelName (strChannelName_),
    _strChannelNameForTTS (strChannelNameForTTS_),
    _u16ChannelID (u16ChannelID_),
    _u8FavoriteChannelListID (u8FavoriteChannelListID_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strChannelName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strChannelNameForTTS_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_usb_tcu_Favorite_channel_info::~T_usb_tcu_Favorite_channel_info() {
}

inline T_usb_tcu_Favorite_channel_info& T_usb_tcu_Favorite_channel_info::operator = (const T_usb_tcu_Favorite_channel_info& rhs) {
    if( this != &rhs ) {
        if (rhs.hasStrChannelName()) {
            setStrChannelName(rhs.getStrChannelName());
        } else {
            clearStrChannelName();
        }
        if (rhs.hasStrChannelNameForTTS()) {
            setStrChannelNameForTTS(rhs.getStrChannelNameForTTS());
        } else {
            clearStrChannelNameForTTS();
        }
        if (rhs.hasU16ChannelID()) {
            setU16ChannelID(rhs.getU16ChannelID());
        } else {
            clearU16ChannelID();
        }
        if (rhs.hasU8FavoriteChannelListID()) {
            setU8FavoriteChannelListID(rhs.getU8FavoriteChannelListID());
        } else {
            clearU8FavoriteChannelListID();
        }
    }
    return *this;
}

inline bool T_usb_tcu_Favorite_channel_info::operator == (const T_usb_tcu_Favorite_channel_info& rhs) const {
    return (((!hasStrChannelName() && !rhs.hasStrChannelName()) || getStrChannelName() == rhs.getStrChannelName()) &&
        ((!hasStrChannelNameForTTS() && !rhs.hasStrChannelNameForTTS()) || getStrChannelNameForTTS() == rhs.getStrChannelNameForTTS()) &&
        ((!hasU16ChannelID() && !rhs.hasU16ChannelID()) || getU16ChannelID() == rhs.getU16ChannelID()) &&
        ((!hasU8FavoriteChannelListID() && !rhs.hasU8FavoriteChannelListID()) || getU8FavoriteChannelListID() == rhs.getU8FavoriteChannelListID()));
}

inline bool T_usb_tcu_Favorite_channel_info::operator != (const T_usb_tcu_Favorite_channel_info& rhs) const {
    return ! (*this == rhs);
}

inline bool T_usb_tcu_Favorite_channel_info::operator < (const T_usb_tcu_Favorite_channel_info& rhs) const {
    if (hasStrChannelName() || rhs.hasStrChannelName()) {
        if (getStrChannelName() < rhs.getStrChannelName()) return true;
        if (getStrChannelName() > rhs.getStrChannelName()) return false;
    }
    if (hasStrChannelNameForTTS() || rhs.hasStrChannelNameForTTS()) {
        if (getStrChannelNameForTTS() < rhs.getStrChannelNameForTTS()) return true;
        if (getStrChannelNameForTTS() > rhs.getStrChannelNameForTTS()) return false;
    }
    if (hasU16ChannelID() || rhs.hasU16ChannelID()) {
        if (getU16ChannelID() < rhs.getU16ChannelID()) return true;
        if (getU16ChannelID() > rhs.getU16ChannelID()) return false;
    }
    if (hasU8FavoriteChannelListID() || rhs.hasU8FavoriteChannelListID()) {
        if (getU8FavoriteChannelListID() < rhs.getU8FavoriteChannelListID()) return true;
        if (getU8FavoriteChannelListID() > rhs.getU8FavoriteChannelListID()) return false;
    }
    return false;
}

inline bool T_usb_tcu_Favorite_channel_info::operator > (const T_usb_tcu_Favorite_channel_info& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_usb_tcu_Favorite_channel_info::clear() {
    clearStrChannelName();
    clearStrChannelNameForTTS();
    clearU16ChannelID();
    clearU8FavoriteChannelListID();
}

inline void T_usb_tcu_Favorite_channel_info::clearStrChannelName() {
    if (hasStrChannelName()) {
         clear_has_strChannelName();
        _strChannelName.clear();
     }
}

inline bool T_usb_tcu_Favorite_channel_info::hasStrChannelName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_usb_tcu_Favorite_channel_info::getStrChannelName () const {
    return _strChannelName;
}

inline ::std::string& T_usb_tcu_Favorite_channel_info::getStrChannelNameMutable () {
    set_has_strChannelName();
    return _strChannelName;
}

inline void T_usb_tcu_Favorite_channel_info::setStrChannelName (const ::std::string& strChannelName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strChannelName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strChannelName();
    this->_strChannelName = strChannelName_;
}

inline void T_usb_tcu_Favorite_channel_info::setStrChannelName (const char* strChannelName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strChannelName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strChannelName();
    this->_strChannelName.assign(strChannelName_);
}

inline void T_usb_tcu_Favorite_channel_info::setStrChannelName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strChannelName();
    this->_strChannelName.assign(value, size);
}

inline void T_usb_tcu_Favorite_channel_info::clearStrChannelNameForTTS() {
    if (hasStrChannelNameForTTS()) {
         clear_has_strChannelNameForTTS();
        _strChannelNameForTTS.clear();
     }
}

inline bool T_usb_tcu_Favorite_channel_info::hasStrChannelNameForTTS () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_usb_tcu_Favorite_channel_info::getStrChannelNameForTTS () const {
    return _strChannelNameForTTS;
}

inline ::std::string& T_usb_tcu_Favorite_channel_info::getStrChannelNameForTTSMutable () {
    set_has_strChannelNameForTTS();
    return _strChannelNameForTTS;
}

inline void T_usb_tcu_Favorite_channel_info::setStrChannelNameForTTS (const ::std::string& strChannelNameForTTS_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strChannelNameForTTS_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strChannelNameForTTS();
    this->_strChannelNameForTTS = strChannelNameForTTS_;
}

inline void T_usb_tcu_Favorite_channel_info::setStrChannelNameForTTS (const char* strChannelNameForTTS_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strChannelNameForTTS_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strChannelNameForTTS();
    this->_strChannelNameForTTS.assign(strChannelNameForTTS_);
}

inline void T_usb_tcu_Favorite_channel_info::setStrChannelNameForTTS (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strChannelNameForTTS();
    this->_strChannelNameForTTS.assign(value, size);
}

inline void T_usb_tcu_Favorite_channel_info::clearU16ChannelID() {
    if (hasU16ChannelID()) {
         clear_has_u16ChannelID();
        _u16ChannelID = 0u;
     }
}

inline bool T_usb_tcu_Favorite_channel_info::hasU16ChannelID () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 T_usb_tcu_Favorite_channel_info::getU16ChannelID () const {
    return _u16ChannelID;
}

inline void T_usb_tcu_Favorite_channel_info::setU16ChannelID (uint16 u16ChannelID_) {
    set_has_u16ChannelID();
    this->_u16ChannelID = u16ChannelID_;
}

inline void T_usb_tcu_Favorite_channel_info::clearU8FavoriteChannelListID() {
    if (hasU8FavoriteChannelListID()) {
         clear_has_u8FavoriteChannelListID();
        _u8FavoriteChannelListID = 0u;
     }
}

inline bool T_usb_tcu_Favorite_channel_info::hasU8FavoriteChannelListID () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 T_usb_tcu_Favorite_channel_info::getU8FavoriteChannelListID () const {
    return _u8FavoriteChannelListID;
}

inline void T_usb_tcu_Favorite_channel_info::setU8FavoriteChannelListID (uint8 u8FavoriteChannelListID_) {
    set_has_u8FavoriteChannelListID();
    this->_u8FavoriteChannelListID = u8FavoriteChannelListID_;
}

inline void T_usb_tcu_Favorite_channel_info::set_has_strChannelName () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_usb_tcu_Favorite_channel_info::clear_has_strChannelName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_usb_tcu_Favorite_channel_info::set_has_strChannelNameForTTS () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_usb_tcu_Favorite_channel_info::clear_has_strChannelNameForTTS () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_usb_tcu_Favorite_channel_info::set_has_u16ChannelID () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_usb_tcu_Favorite_channel_info::clear_has_u16ChannelID () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_usb_tcu_Favorite_channel_info::set_has_u8FavoriteChannelListID () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_usb_tcu_Favorite_channel_info::clear_has_u8FavoriteChannelListID () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  T_tcu_Block_Data_List::T_tcu_Block_Data_List ()  :
    _u16NumberOfSecondLevelMesh (0u),
    _u8PredectedDate (0u),
    _u16PredectedDate (0u),
    _u16RequestInformationType (0u),
    _u16Reserved (0u),
    _u8InformationSourceID (0u),
    _SecondLevelMeshCoordinateList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_tcu_Block_Data_List::T_tcu_Block_Data_List (const T_tcu_Block_Data_List &rhs)  :
    _u16NumberOfSecondLevelMesh (0u),
    _u8PredectedDate (0u),
    _u16PredectedDate (0u),
    _u16RequestInformationType (0u),
    _u16Reserved (0u),
    _u8InformationSourceID (0u),
    _SecondLevelMeshCoordinateList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_tcu_Block_Data_List::T_tcu_Block_Data_List (uint16 u16NumberOfSecondLevelMesh_, uint8 u8PredectedDate_, uint16 u16PredectedDate_, uint16 u16RequestInformationType_, uint16 u16Reserved_, uint8 u8InformationSourceID_, const ::std::vector< uint16 >& SecondLevelMeshCoordinateList_)  :
    _u16NumberOfSecondLevelMesh (u16NumberOfSecondLevelMesh_),
    _u8PredectedDate (u8PredectedDate_),
    _u16PredectedDate (u16PredectedDate_),
    _u16RequestInformationType (u16RequestInformationType_),
    _u16Reserved (u16Reserved_),
    _u8InformationSourceID (u8InformationSourceID_),
    _SecondLevelMeshCoordinateList (SecondLevelMeshCoordinateList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_tcu_Block_Data_List::~T_tcu_Block_Data_List() {
}

inline T_tcu_Block_Data_List& T_tcu_Block_Data_List::operator = (const T_tcu_Block_Data_List& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU16NumberOfSecondLevelMesh()) {
            setU16NumberOfSecondLevelMesh(rhs.getU16NumberOfSecondLevelMesh());
        } else {
            clearU16NumberOfSecondLevelMesh();
        }
        if (rhs.hasU8PredectedDate()) {
            setU8PredectedDate(rhs.getU8PredectedDate());
        } else {
            clearU8PredectedDate();
        }
        if (rhs.hasU16PredectedDate()) {
            setU16PredectedDate(rhs.getU16PredectedDate());
        } else {
            clearU16PredectedDate();
        }
        if (rhs.hasU16RequestInformationType()) {
            setU16RequestInformationType(rhs.getU16RequestInformationType());
        } else {
            clearU16RequestInformationType();
        }
        if (rhs.hasU16Reserved()) {
            setU16Reserved(rhs.getU16Reserved());
        } else {
            clearU16Reserved();
        }
        if (rhs.hasU8InformationSourceID()) {
            setU8InformationSourceID(rhs.getU8InformationSourceID());
        } else {
            clearU8InformationSourceID();
        }
        if (rhs.hasSecondLevelMeshCoordinateList()) {
            setSecondLevelMeshCoordinateList(rhs.getSecondLevelMeshCoordinateList());
        } else {
            clearSecondLevelMeshCoordinateList();
        }
    }
    return *this;
}

inline bool T_tcu_Block_Data_List::operator == (const T_tcu_Block_Data_List& rhs) const {
    return (((!hasU16NumberOfSecondLevelMesh() && !rhs.hasU16NumberOfSecondLevelMesh()) || getU16NumberOfSecondLevelMesh() == rhs.getU16NumberOfSecondLevelMesh()) &&
        ((!hasU8PredectedDate() && !rhs.hasU8PredectedDate()) || getU8PredectedDate() == rhs.getU8PredectedDate()) &&
        ((!hasU16PredectedDate() && !rhs.hasU16PredectedDate()) || getU16PredectedDate() == rhs.getU16PredectedDate()) &&
        ((!hasU16RequestInformationType() && !rhs.hasU16RequestInformationType()) || getU16RequestInformationType() == rhs.getU16RequestInformationType()) &&
        ((!hasU16Reserved() && !rhs.hasU16Reserved()) || getU16Reserved() == rhs.getU16Reserved()) &&
        ((!hasU8InformationSourceID() && !rhs.hasU8InformationSourceID()) || getU8InformationSourceID() == rhs.getU8InformationSourceID()) &&
        ((!hasSecondLevelMeshCoordinateList() && !rhs.hasSecondLevelMeshCoordinateList()) || getSecondLevelMeshCoordinateList() == rhs.getSecondLevelMeshCoordinateList()));
}

inline bool T_tcu_Block_Data_List::operator != (const T_tcu_Block_Data_List& rhs) const {
    return ! (*this == rhs);
}

inline bool T_tcu_Block_Data_List::operator < (const T_tcu_Block_Data_List& rhs) const {
    if (hasU16NumberOfSecondLevelMesh() || rhs.hasU16NumberOfSecondLevelMesh()) {
        if (getU16NumberOfSecondLevelMesh() < rhs.getU16NumberOfSecondLevelMesh()) return true;
        if (getU16NumberOfSecondLevelMesh() > rhs.getU16NumberOfSecondLevelMesh()) return false;
    }
    if (hasU8PredectedDate() || rhs.hasU8PredectedDate()) {
        if (getU8PredectedDate() < rhs.getU8PredectedDate()) return true;
        if (getU8PredectedDate() > rhs.getU8PredectedDate()) return false;
    }
    if (hasU16PredectedDate() || rhs.hasU16PredectedDate()) {
        if (getU16PredectedDate() < rhs.getU16PredectedDate()) return true;
        if (getU16PredectedDate() > rhs.getU16PredectedDate()) return false;
    }
    if (hasU16RequestInformationType() || rhs.hasU16RequestInformationType()) {
        if (getU16RequestInformationType() < rhs.getU16RequestInformationType()) return true;
        if (getU16RequestInformationType() > rhs.getU16RequestInformationType()) return false;
    }
    if (hasU16Reserved() || rhs.hasU16Reserved()) {
        if (getU16Reserved() < rhs.getU16Reserved()) return true;
        if (getU16Reserved() > rhs.getU16Reserved()) return false;
    }
    if (hasU8InformationSourceID() || rhs.hasU8InformationSourceID()) {
        if (getU8InformationSourceID() < rhs.getU8InformationSourceID()) return true;
        if (getU8InformationSourceID() > rhs.getU8InformationSourceID()) return false;
    }
    if (hasSecondLevelMeshCoordinateList() || rhs.hasSecondLevelMeshCoordinateList()) {
        if (getSecondLevelMeshCoordinateList() < rhs.getSecondLevelMeshCoordinateList()) return true;
        if (getSecondLevelMeshCoordinateList() > rhs.getSecondLevelMeshCoordinateList()) return false;
    }
    return false;
}

inline bool T_tcu_Block_Data_List::operator > (const T_tcu_Block_Data_List& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_tcu_Block_Data_List::clear() {
    clearU16NumberOfSecondLevelMesh();
    clearU8PredectedDate();
    clearU16PredectedDate();
    clearU16RequestInformationType();
    clearU16Reserved();
    clearU8InformationSourceID();
    clearSecondLevelMeshCoordinateList();
}

inline void T_tcu_Block_Data_List::clearU16NumberOfSecondLevelMesh() {
    if (hasU16NumberOfSecondLevelMesh()) {
         clear_has_u16NumberOfSecondLevelMesh();
        _u16NumberOfSecondLevelMesh = 0u;
     }
}

inline bool T_tcu_Block_Data_List::hasU16NumberOfSecondLevelMesh () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 T_tcu_Block_Data_List::getU16NumberOfSecondLevelMesh () const {
    return _u16NumberOfSecondLevelMesh;
}

inline void T_tcu_Block_Data_List::setU16NumberOfSecondLevelMesh (uint16 u16NumberOfSecondLevelMesh_) {
    set_has_u16NumberOfSecondLevelMesh();
    this->_u16NumberOfSecondLevelMesh = u16NumberOfSecondLevelMesh_;
}

inline void T_tcu_Block_Data_List::clearU8PredectedDate() {
    if (hasU8PredectedDate()) {
         clear_has_u8PredectedDate();
        _u8PredectedDate = 0u;
     }
}

inline bool T_tcu_Block_Data_List::hasU8PredectedDate () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_tcu_Block_Data_List::getU8PredectedDate () const {
    return _u8PredectedDate;
}

inline void T_tcu_Block_Data_List::setU8PredectedDate (uint8 u8PredectedDate_) {
    set_has_u8PredectedDate();
    this->_u8PredectedDate = u8PredectedDate_;
}

inline void T_tcu_Block_Data_List::clearU16PredectedDate() {
    if (hasU16PredectedDate()) {
         clear_has_u16PredectedDate();
        _u16PredectedDate = 0u;
     }
}

inline bool T_tcu_Block_Data_List::hasU16PredectedDate () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 T_tcu_Block_Data_List::getU16PredectedDate () const {
    return _u16PredectedDate;
}

inline void T_tcu_Block_Data_List::setU16PredectedDate (uint16 u16PredectedDate_) {
    set_has_u16PredectedDate();
    this->_u16PredectedDate = u16PredectedDate_;
}

inline void T_tcu_Block_Data_List::clearU16RequestInformationType() {
    if (hasU16RequestInformationType()) {
         clear_has_u16RequestInformationType();
        _u16RequestInformationType = 0u;
     }
}

inline bool T_tcu_Block_Data_List::hasU16RequestInformationType () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 T_tcu_Block_Data_List::getU16RequestInformationType () const {
    return _u16RequestInformationType;
}

inline void T_tcu_Block_Data_List::setU16RequestInformationType (uint16 u16RequestInformationType_) {
    set_has_u16RequestInformationType();
    this->_u16RequestInformationType = u16RequestInformationType_;
}

inline void T_tcu_Block_Data_List::clearU16Reserved() {
    if (hasU16Reserved()) {
         clear_has_u16Reserved();
        _u16Reserved = 0u;
     }
}

inline bool T_tcu_Block_Data_List::hasU16Reserved () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint16 T_tcu_Block_Data_List::getU16Reserved () const {
    return _u16Reserved;
}

inline void T_tcu_Block_Data_List::setU16Reserved (uint16 u16Reserved_) {
    set_has_u16Reserved();
    this->_u16Reserved = u16Reserved_;
}

inline void T_tcu_Block_Data_List::clearU8InformationSourceID() {
    if (hasU8InformationSourceID()) {
         clear_has_u8InformationSourceID();
        _u8InformationSourceID = 0u;
     }
}

inline bool T_tcu_Block_Data_List::hasU8InformationSourceID () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint8 T_tcu_Block_Data_List::getU8InformationSourceID () const {
    return _u8InformationSourceID;
}

inline void T_tcu_Block_Data_List::setU8InformationSourceID (uint8 u8InformationSourceID_) {
    set_has_u8InformationSourceID();
    this->_u8InformationSourceID = u8InformationSourceID_;
}

inline void T_tcu_Block_Data_List::clearSecondLevelMeshCoordinateList() {
    if (hasSecondLevelMeshCoordinateList()) {
         clear_has_SecondLevelMeshCoordinateList();
        _SecondLevelMeshCoordinateList.clear();
     }
}

inline bool T_tcu_Block_Data_List::hasSecondLevelMeshCoordinateList () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline const ::std::vector< uint16 >& T_tcu_Block_Data_List::getSecondLevelMeshCoordinateList () const {
    return _SecondLevelMeshCoordinateList;
}

inline ::std::vector< uint16 >& T_tcu_Block_Data_List::getSecondLevelMeshCoordinateListMutable () {
    set_has_SecondLevelMeshCoordinateList();
    return _SecondLevelMeshCoordinateList;
}

inline void T_tcu_Block_Data_List::setSecondLevelMeshCoordinateList (const ::std::vector< uint16 >& SecondLevelMeshCoordinateList_) {
    set_has_SecondLevelMeshCoordinateList();
    this->_SecondLevelMeshCoordinateList = SecondLevelMeshCoordinateList_;
}

inline void T_tcu_Block_Data_List::set_has_u16NumberOfSecondLevelMesh () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_tcu_Block_Data_List::clear_has_u16NumberOfSecondLevelMesh () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_tcu_Block_Data_List::set_has_u8PredectedDate () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_tcu_Block_Data_List::clear_has_u8PredectedDate () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_tcu_Block_Data_List::set_has_u16PredectedDate () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_tcu_Block_Data_List::clear_has_u16PredectedDate () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_tcu_Block_Data_List::set_has_u16RequestInformationType () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_tcu_Block_Data_List::clear_has_u16RequestInformationType () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_tcu_Block_Data_List::set_has_u16Reserved () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_tcu_Block_Data_List::clear_has_u16Reserved () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_tcu_Block_Data_List::set_has_u8InformationSourceID () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_tcu_Block_Data_List::clear_has_u8InformationSourceID () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_tcu_Block_Data_List::set_has_SecondLevelMeshCoordinateList () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_tcu_Block_Data_List::clear_has_SecondLevelMeshCoordinateList () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline  T_tcu_Japan_Location::T_tcu_Japan_Location ()  :
    _u16SecondLevelMesh_CoordinateId (0u),
    _u16SecondLevelMesh_XCoordinate (0u),
    _u16SecondLevelMesh_YCoordinate (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_tcu_Japan_Location::T_tcu_Japan_Location (const T_tcu_Japan_Location &rhs)  :
    _u16SecondLevelMesh_CoordinateId (0u),
    _u16SecondLevelMesh_XCoordinate (0u),
    _u16SecondLevelMesh_YCoordinate (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_tcu_Japan_Location::T_tcu_Japan_Location (uint16 u16SecondLevelMesh_CoordinateId_, uint16 u16SecondLevelMesh_XCoordinate_, uint16 u16SecondLevelMesh_YCoordinate_)  :
    _u16SecondLevelMesh_CoordinateId (u16SecondLevelMesh_CoordinateId_),
    _u16SecondLevelMesh_XCoordinate (u16SecondLevelMesh_XCoordinate_),
    _u16SecondLevelMesh_YCoordinate (u16SecondLevelMesh_YCoordinate_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_tcu_Japan_Location::~T_tcu_Japan_Location() {
}

inline T_tcu_Japan_Location& T_tcu_Japan_Location::operator = (const T_tcu_Japan_Location& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU16SecondLevelMesh_CoordinateId()) {
            setU16SecondLevelMesh_CoordinateId(rhs.getU16SecondLevelMesh_CoordinateId());
        } else {
            clearU16SecondLevelMesh_CoordinateId();
        }
        if (rhs.hasU16SecondLevelMesh_XCoordinate()) {
            setU16SecondLevelMesh_XCoordinate(rhs.getU16SecondLevelMesh_XCoordinate());
        } else {
            clearU16SecondLevelMesh_XCoordinate();
        }
        if (rhs.hasU16SecondLevelMesh_YCoordinate()) {
            setU16SecondLevelMesh_YCoordinate(rhs.getU16SecondLevelMesh_YCoordinate());
        } else {
            clearU16SecondLevelMesh_YCoordinate();
        }
    }
    return *this;
}

inline bool T_tcu_Japan_Location::operator == (const T_tcu_Japan_Location& rhs) const {
    return (((!hasU16SecondLevelMesh_CoordinateId() && !rhs.hasU16SecondLevelMesh_CoordinateId()) || getU16SecondLevelMesh_CoordinateId() == rhs.getU16SecondLevelMesh_CoordinateId()) &&
        ((!hasU16SecondLevelMesh_XCoordinate() && !rhs.hasU16SecondLevelMesh_XCoordinate()) || getU16SecondLevelMesh_XCoordinate() == rhs.getU16SecondLevelMesh_XCoordinate()) &&
        ((!hasU16SecondLevelMesh_YCoordinate() && !rhs.hasU16SecondLevelMesh_YCoordinate()) || getU16SecondLevelMesh_YCoordinate() == rhs.getU16SecondLevelMesh_YCoordinate()));
}

inline bool T_tcu_Japan_Location::operator != (const T_tcu_Japan_Location& rhs) const {
    return ! (*this == rhs);
}

inline bool T_tcu_Japan_Location::operator < (const T_tcu_Japan_Location& rhs) const {
    if (hasU16SecondLevelMesh_CoordinateId() || rhs.hasU16SecondLevelMesh_CoordinateId()) {
        if (getU16SecondLevelMesh_CoordinateId() < rhs.getU16SecondLevelMesh_CoordinateId()) return true;
        if (getU16SecondLevelMesh_CoordinateId() > rhs.getU16SecondLevelMesh_CoordinateId()) return false;
    }
    if (hasU16SecondLevelMesh_XCoordinate() || rhs.hasU16SecondLevelMesh_XCoordinate()) {
        if (getU16SecondLevelMesh_XCoordinate() < rhs.getU16SecondLevelMesh_XCoordinate()) return true;
        if (getU16SecondLevelMesh_XCoordinate() > rhs.getU16SecondLevelMesh_XCoordinate()) return false;
    }
    if (hasU16SecondLevelMesh_YCoordinate() || rhs.hasU16SecondLevelMesh_YCoordinate()) {
        if (getU16SecondLevelMesh_YCoordinate() < rhs.getU16SecondLevelMesh_YCoordinate()) return true;
        if (getU16SecondLevelMesh_YCoordinate() > rhs.getU16SecondLevelMesh_YCoordinate()) return false;
    }
    return false;
}

inline bool T_tcu_Japan_Location::operator > (const T_tcu_Japan_Location& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_tcu_Japan_Location::clear() {
    clearU16SecondLevelMesh_CoordinateId();
    clearU16SecondLevelMesh_XCoordinate();
    clearU16SecondLevelMesh_YCoordinate();
}

inline void T_tcu_Japan_Location::clearU16SecondLevelMesh_CoordinateId() {
    if (hasU16SecondLevelMesh_CoordinateId()) {
         clear_has_u16SecondLevelMesh_CoordinateId();
        _u16SecondLevelMesh_CoordinateId = 0u;
     }
}

inline bool T_tcu_Japan_Location::hasU16SecondLevelMesh_CoordinateId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 T_tcu_Japan_Location::getU16SecondLevelMesh_CoordinateId () const {
    return _u16SecondLevelMesh_CoordinateId;
}

inline void T_tcu_Japan_Location::setU16SecondLevelMesh_CoordinateId (uint16 u16SecondLevelMesh_CoordinateId_) {
    set_has_u16SecondLevelMesh_CoordinateId();
    this->_u16SecondLevelMesh_CoordinateId = u16SecondLevelMesh_CoordinateId_;
}

inline void T_tcu_Japan_Location::clearU16SecondLevelMesh_XCoordinate() {
    if (hasU16SecondLevelMesh_XCoordinate()) {
         clear_has_u16SecondLevelMesh_XCoordinate();
        _u16SecondLevelMesh_XCoordinate = 0u;
     }
}

inline bool T_tcu_Japan_Location::hasU16SecondLevelMesh_XCoordinate () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 T_tcu_Japan_Location::getU16SecondLevelMesh_XCoordinate () const {
    return _u16SecondLevelMesh_XCoordinate;
}

inline void T_tcu_Japan_Location::setU16SecondLevelMesh_XCoordinate (uint16 u16SecondLevelMesh_XCoordinate_) {
    set_has_u16SecondLevelMesh_XCoordinate();
    this->_u16SecondLevelMesh_XCoordinate = u16SecondLevelMesh_XCoordinate_;
}

inline void T_tcu_Japan_Location::clearU16SecondLevelMesh_YCoordinate() {
    if (hasU16SecondLevelMesh_YCoordinate()) {
         clear_has_u16SecondLevelMesh_YCoordinate();
        _u16SecondLevelMesh_YCoordinate = 0u;
     }
}

inline bool T_tcu_Japan_Location::hasU16SecondLevelMesh_YCoordinate () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 T_tcu_Japan_Location::getU16SecondLevelMesh_YCoordinate () const {
    return _u16SecondLevelMesh_YCoordinate;
}

inline void T_tcu_Japan_Location::setU16SecondLevelMesh_YCoordinate (uint16 u16SecondLevelMesh_YCoordinate_) {
    set_has_u16SecondLevelMesh_YCoordinate();
    this->_u16SecondLevelMesh_YCoordinate = u16SecondLevelMesh_YCoordinate_;
}

inline void T_tcu_Japan_Location::set_has_u16SecondLevelMesh_CoordinateId () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_tcu_Japan_Location::clear_has_u16SecondLevelMesh_CoordinateId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_tcu_Japan_Location::set_has_u16SecondLevelMesh_XCoordinate () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_tcu_Japan_Location::clear_has_u16SecondLevelMesh_XCoordinate () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_tcu_Japan_Location::set_has_u16SecondLevelMesh_YCoordinate () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_tcu_Japan_Location::clear_has_u16SecondLevelMesh_YCoordinate () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_tcu_navigation_setting_information::T_tcu_navigation_setting_information ()  :
    _CurrentLocationInfo (),
    _DepartureInfo (),
    _DestinationInfo (),
    _ScrollPointInfo (),
    _u16SearchConditionInfo (0u),
    _u16VehicleDirectionInfo (0u),
    _u8InformationFlag (0u),
    _u8WaypointNumber (0u),
    _WaypointList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_tcu_navigation_setting_information::T_tcu_navigation_setting_information (const T_tcu_navigation_setting_information &rhs)  :
    _CurrentLocationInfo (),
    _DepartureInfo (),
    _DestinationInfo (),
    _ScrollPointInfo (),
    _u16SearchConditionInfo (0u),
    _u16VehicleDirectionInfo (0u),
    _u8InformationFlag (0u),
    _u8WaypointNumber (0u),
    _WaypointList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_tcu_navigation_setting_information::T_tcu_navigation_setting_information (const T_tcu_Japan_Location& CurrentLocationInfo_, const T_tcu_Japan_Location& DepartureInfo_, const T_tcu_Japan_Location& DestinationInfo_, const T_tcu_Japan_Location& ScrollPointInfo_, uint16 u16SearchConditionInfo_, uint16 u16VehicleDirectionInfo_, uint8 u8InformationFlag_, uint8 u8WaypointNumber_, const ::std::vector< T_tcu_Japan_Location >& WaypointList_)  :
    _CurrentLocationInfo (CurrentLocationInfo_),
    _DepartureInfo (DepartureInfo_),
    _DestinationInfo (DestinationInfo_),
    _ScrollPointInfo (ScrollPointInfo_),
    _u16SearchConditionInfo (u16SearchConditionInfo_),
    _u16VehicleDirectionInfo (u16VehicleDirectionInfo_),
    _u8InformationFlag (u8InformationFlag_),
    _u8WaypointNumber (u8WaypointNumber_),
    _WaypointList (WaypointList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_tcu_navigation_setting_information::~T_tcu_navigation_setting_information() {
}

inline T_tcu_navigation_setting_information& T_tcu_navigation_setting_information::operator = (const T_tcu_navigation_setting_information& rhs) {
    if( this != &rhs ) {
        if (rhs.hasCurrentLocationInfo()) {
            setCurrentLocationInfo(rhs.getCurrentLocationInfo());
        } else {
            clearCurrentLocationInfo();
        }
        if (rhs.hasDepartureInfo()) {
            setDepartureInfo(rhs.getDepartureInfo());
        } else {
            clearDepartureInfo();
        }
        if (rhs.hasDestinationInfo()) {
            setDestinationInfo(rhs.getDestinationInfo());
        } else {
            clearDestinationInfo();
        }
        if (rhs.hasScrollPointInfo()) {
            setScrollPointInfo(rhs.getScrollPointInfo());
        } else {
            clearScrollPointInfo();
        }
        if (rhs.hasU16SearchConditionInfo()) {
            setU16SearchConditionInfo(rhs.getU16SearchConditionInfo());
        } else {
            clearU16SearchConditionInfo();
        }
        if (rhs.hasU16VehicleDirectionInfo()) {
            setU16VehicleDirectionInfo(rhs.getU16VehicleDirectionInfo());
        } else {
            clearU16VehicleDirectionInfo();
        }
        if (rhs.hasU8InformationFlag()) {
            setU8InformationFlag(rhs.getU8InformationFlag());
        } else {
            clearU8InformationFlag();
        }
        if (rhs.hasU8WaypointNumber()) {
            setU8WaypointNumber(rhs.getU8WaypointNumber());
        } else {
            clearU8WaypointNumber();
        }
        if (rhs.hasWaypointList()) {
            setWaypointList(rhs.getWaypointList());
        } else {
            clearWaypointList();
        }
    }
    return *this;
}

inline bool T_tcu_navigation_setting_information::operator == (const T_tcu_navigation_setting_information& rhs) const {
    return (((!hasCurrentLocationInfo() && !rhs.hasCurrentLocationInfo()) || getCurrentLocationInfo() == rhs.getCurrentLocationInfo()) &&
        ((!hasDepartureInfo() && !rhs.hasDepartureInfo()) || getDepartureInfo() == rhs.getDepartureInfo()) &&
        ((!hasDestinationInfo() && !rhs.hasDestinationInfo()) || getDestinationInfo() == rhs.getDestinationInfo()) &&
        ((!hasScrollPointInfo() && !rhs.hasScrollPointInfo()) || getScrollPointInfo() == rhs.getScrollPointInfo()) &&
        ((!hasU16SearchConditionInfo() && !rhs.hasU16SearchConditionInfo()) || getU16SearchConditionInfo() == rhs.getU16SearchConditionInfo()) &&
        ((!hasU16VehicleDirectionInfo() && !rhs.hasU16VehicleDirectionInfo()) || getU16VehicleDirectionInfo() == rhs.getU16VehicleDirectionInfo()) &&
        ((!hasU8InformationFlag() && !rhs.hasU8InformationFlag()) || getU8InformationFlag() == rhs.getU8InformationFlag()) &&
        ((!hasU8WaypointNumber() && !rhs.hasU8WaypointNumber()) || getU8WaypointNumber() == rhs.getU8WaypointNumber()) &&
        ((!hasWaypointList() && !rhs.hasWaypointList()) || getWaypointList() == rhs.getWaypointList()));
}

inline bool T_tcu_navigation_setting_information::operator != (const T_tcu_navigation_setting_information& rhs) const {
    return ! (*this == rhs);
}

inline bool T_tcu_navigation_setting_information::operator < (const T_tcu_navigation_setting_information& rhs) const {
    if (hasCurrentLocationInfo() || rhs.hasCurrentLocationInfo()) {
        if (getCurrentLocationInfo() < rhs.getCurrentLocationInfo()) return true;
        if (getCurrentLocationInfo() > rhs.getCurrentLocationInfo()) return false;
    }
    if (hasDepartureInfo() || rhs.hasDepartureInfo()) {
        if (getDepartureInfo() < rhs.getDepartureInfo()) return true;
        if (getDepartureInfo() > rhs.getDepartureInfo()) return false;
    }
    if (hasDestinationInfo() || rhs.hasDestinationInfo()) {
        if (getDestinationInfo() < rhs.getDestinationInfo()) return true;
        if (getDestinationInfo() > rhs.getDestinationInfo()) return false;
    }
    if (hasScrollPointInfo() || rhs.hasScrollPointInfo()) {
        if (getScrollPointInfo() < rhs.getScrollPointInfo()) return true;
        if (getScrollPointInfo() > rhs.getScrollPointInfo()) return false;
    }
    if (hasU16SearchConditionInfo() || rhs.hasU16SearchConditionInfo()) {
        if (getU16SearchConditionInfo() < rhs.getU16SearchConditionInfo()) return true;
        if (getU16SearchConditionInfo() > rhs.getU16SearchConditionInfo()) return false;
    }
    if (hasU16VehicleDirectionInfo() || rhs.hasU16VehicleDirectionInfo()) {
        if (getU16VehicleDirectionInfo() < rhs.getU16VehicleDirectionInfo()) return true;
        if (getU16VehicleDirectionInfo() > rhs.getU16VehicleDirectionInfo()) return false;
    }
    if (hasU8InformationFlag() || rhs.hasU8InformationFlag()) {
        if (getU8InformationFlag() < rhs.getU8InformationFlag()) return true;
        if (getU8InformationFlag() > rhs.getU8InformationFlag()) return false;
    }
    if (hasU8WaypointNumber() || rhs.hasU8WaypointNumber()) {
        if (getU8WaypointNumber() < rhs.getU8WaypointNumber()) return true;
        if (getU8WaypointNumber() > rhs.getU8WaypointNumber()) return false;
    }
    if (hasWaypointList() || rhs.hasWaypointList()) {
        if (getWaypointList() < rhs.getWaypointList()) return true;
        if (getWaypointList() > rhs.getWaypointList()) return false;
    }
    return false;
}

inline bool T_tcu_navigation_setting_information::operator > (const T_tcu_navigation_setting_information& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_tcu_navigation_setting_information::clear() {
    clearCurrentLocationInfo();
    clearDepartureInfo();
    clearDestinationInfo();
    clearScrollPointInfo();
    clearU16SearchConditionInfo();
    clearU16VehicleDirectionInfo();
    clearU8InformationFlag();
    clearU8WaypointNumber();
    clearWaypointList();
}

inline void T_tcu_navigation_setting_information::clearCurrentLocationInfo() {
    if (hasCurrentLocationInfo()) {
         clear_has_CurrentLocationInfo();
        _CurrentLocationInfo.clear();
     }
}

inline bool T_tcu_navigation_setting_information::hasCurrentLocationInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const T_tcu_Japan_Location& T_tcu_navigation_setting_information::getCurrentLocationInfo () const {
    return _CurrentLocationInfo;
}

inline T_tcu_Japan_Location& T_tcu_navigation_setting_information::getCurrentLocationInfoMutable () {
    set_has_CurrentLocationInfo();
    return _CurrentLocationInfo;
}

inline void T_tcu_navigation_setting_information::setCurrentLocationInfo (const T_tcu_Japan_Location& CurrentLocationInfo_) {
    set_has_CurrentLocationInfo();
    this->_CurrentLocationInfo = CurrentLocationInfo_;
}

inline void T_tcu_navigation_setting_information::clearDepartureInfo() {
    if (hasDepartureInfo()) {
         clear_has_DepartureInfo();
        _DepartureInfo.clear();
     }
}

inline bool T_tcu_navigation_setting_information::hasDepartureInfo () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const T_tcu_Japan_Location& T_tcu_navigation_setting_information::getDepartureInfo () const {
    return _DepartureInfo;
}

inline T_tcu_Japan_Location& T_tcu_navigation_setting_information::getDepartureInfoMutable () {
    set_has_DepartureInfo();
    return _DepartureInfo;
}

inline void T_tcu_navigation_setting_information::setDepartureInfo (const T_tcu_Japan_Location& DepartureInfo_) {
    set_has_DepartureInfo();
    this->_DepartureInfo = DepartureInfo_;
}

inline void T_tcu_navigation_setting_information::clearDestinationInfo() {
    if (hasDestinationInfo()) {
         clear_has_DestinationInfo();
        _DestinationInfo.clear();
     }
}

inline bool T_tcu_navigation_setting_information::hasDestinationInfo () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const T_tcu_Japan_Location& T_tcu_navigation_setting_information::getDestinationInfo () const {
    return _DestinationInfo;
}

inline T_tcu_Japan_Location& T_tcu_navigation_setting_information::getDestinationInfoMutable () {
    set_has_DestinationInfo();
    return _DestinationInfo;
}

inline void T_tcu_navigation_setting_information::setDestinationInfo (const T_tcu_Japan_Location& DestinationInfo_) {
    set_has_DestinationInfo();
    this->_DestinationInfo = DestinationInfo_;
}

inline void T_tcu_navigation_setting_information::clearScrollPointInfo() {
    if (hasScrollPointInfo()) {
         clear_has_ScrollPointInfo();
        _ScrollPointInfo.clear();
     }
}

inline bool T_tcu_navigation_setting_information::hasScrollPointInfo () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const T_tcu_Japan_Location& T_tcu_navigation_setting_information::getScrollPointInfo () const {
    return _ScrollPointInfo;
}

inline T_tcu_Japan_Location& T_tcu_navigation_setting_information::getScrollPointInfoMutable () {
    set_has_ScrollPointInfo();
    return _ScrollPointInfo;
}

inline void T_tcu_navigation_setting_information::setScrollPointInfo (const T_tcu_Japan_Location& ScrollPointInfo_) {
    set_has_ScrollPointInfo();
    this->_ScrollPointInfo = ScrollPointInfo_;
}

inline void T_tcu_navigation_setting_information::clearU16SearchConditionInfo() {
    if (hasU16SearchConditionInfo()) {
         clear_has_u16SearchConditionInfo();
        _u16SearchConditionInfo = 0u;
     }
}

inline bool T_tcu_navigation_setting_information::hasU16SearchConditionInfo () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint16 T_tcu_navigation_setting_information::getU16SearchConditionInfo () const {
    return _u16SearchConditionInfo;
}

inline void T_tcu_navigation_setting_information::setU16SearchConditionInfo (uint16 u16SearchConditionInfo_) {
    set_has_u16SearchConditionInfo();
    this->_u16SearchConditionInfo = u16SearchConditionInfo_;
}

inline void T_tcu_navigation_setting_information::clearU16VehicleDirectionInfo() {
    if (hasU16VehicleDirectionInfo()) {
         clear_has_u16VehicleDirectionInfo();
        _u16VehicleDirectionInfo = 0u;
     }
}

inline bool T_tcu_navigation_setting_information::hasU16VehicleDirectionInfo () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint16 T_tcu_navigation_setting_information::getU16VehicleDirectionInfo () const {
    return _u16VehicleDirectionInfo;
}

inline void T_tcu_navigation_setting_information::setU16VehicleDirectionInfo (uint16 u16VehicleDirectionInfo_) {
    set_has_u16VehicleDirectionInfo();
    this->_u16VehicleDirectionInfo = u16VehicleDirectionInfo_;
}

inline void T_tcu_navigation_setting_information::clearU8InformationFlag() {
    if (hasU8InformationFlag()) {
         clear_has_u8InformationFlag();
        _u8InformationFlag = 0u;
     }
}

inline bool T_tcu_navigation_setting_information::hasU8InformationFlag () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint8 T_tcu_navigation_setting_information::getU8InformationFlag () const {
    return _u8InformationFlag;
}

inline void T_tcu_navigation_setting_information::setU8InformationFlag (uint8 u8InformationFlag_) {
    set_has_u8InformationFlag();
    this->_u8InformationFlag = u8InformationFlag_;
}

inline void T_tcu_navigation_setting_information::clearU8WaypointNumber() {
    if (hasU8WaypointNumber()) {
         clear_has_u8WaypointNumber();
        _u8WaypointNumber = 0u;
     }
}

inline bool T_tcu_navigation_setting_information::hasU8WaypointNumber () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline uint8 T_tcu_navigation_setting_information::getU8WaypointNumber () const {
    return _u8WaypointNumber;
}

inline void T_tcu_navigation_setting_information::setU8WaypointNumber (uint8 u8WaypointNumber_) {
    set_has_u8WaypointNumber();
    this->_u8WaypointNumber = u8WaypointNumber_;
}

inline void T_tcu_navigation_setting_information::clearWaypointList() {
    if (hasWaypointList()) {
         clear_has_WaypointList();
        _WaypointList.clear();
     }
}

inline bool T_tcu_navigation_setting_information::hasWaypointList () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline const ::std::vector< T_tcu_Japan_Location >& T_tcu_navigation_setting_information::getWaypointList () const {
    return _WaypointList;
}

inline ::std::vector< T_tcu_Japan_Location >& T_tcu_navigation_setting_information::getWaypointListMutable () {
    set_has_WaypointList();
    return _WaypointList;
}

inline void T_tcu_navigation_setting_information::setWaypointList (const ::std::vector< T_tcu_Japan_Location >& WaypointList_) {
    set_has_WaypointList();
    this->_WaypointList = WaypointList_;
}

inline void T_tcu_navigation_setting_information::set_has_CurrentLocationInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_tcu_navigation_setting_information::clear_has_CurrentLocationInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_tcu_navigation_setting_information::set_has_DepartureInfo () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_tcu_navigation_setting_information::clear_has_DepartureInfo () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_tcu_navigation_setting_information::set_has_DestinationInfo () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_tcu_navigation_setting_information::clear_has_DestinationInfo () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_tcu_navigation_setting_information::set_has_ScrollPointInfo () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_tcu_navigation_setting_information::clear_has_ScrollPointInfo () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_tcu_navigation_setting_information::set_has_u16SearchConditionInfo () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_tcu_navigation_setting_information::clear_has_u16SearchConditionInfo () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_tcu_navigation_setting_information::set_has_u16VehicleDirectionInfo () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_tcu_navigation_setting_information::clear_has_u16VehicleDirectionInfo () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_tcu_navigation_setting_information::set_has_u8InformationFlag () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_tcu_navigation_setting_information::clear_has_u8InformationFlag () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_tcu_navigation_setting_information::set_has_u8WaypointNumber () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_tcu_navigation_setting_information::clear_has_u8WaypointNumber () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_tcu_navigation_setting_information::set_has_WaypointList () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_tcu_navigation_setting_information::clear_has_WaypointList () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline  T_tcu_VICS_Request_Data::T_tcu_VICS_Request_Data ()  :
    _NavigationSettingInformation (),
    _BlockDataList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_tcu_VICS_Request_Data::T_tcu_VICS_Request_Data (const T_tcu_VICS_Request_Data &rhs)  :
    _NavigationSettingInformation (),
    _BlockDataList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_tcu_VICS_Request_Data::T_tcu_VICS_Request_Data (const T_tcu_navigation_setting_information& NavigationSettingInformation_, const ::std::vector< T_tcu_Block_Data_List >& BlockDataList_)  :
    _NavigationSettingInformation (NavigationSettingInformation_),
    _BlockDataList (BlockDataList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_tcu_VICS_Request_Data::~T_tcu_VICS_Request_Data() {
}

inline T_tcu_VICS_Request_Data& T_tcu_VICS_Request_Data::operator = (const T_tcu_VICS_Request_Data& rhs) {
    if( this != &rhs ) {
        if (rhs.hasNavigationSettingInformation()) {
            setNavigationSettingInformation(rhs.getNavigationSettingInformation());
        } else {
            clearNavigationSettingInformation();
        }
        if (rhs.hasBlockDataList()) {
            setBlockDataList(rhs.getBlockDataList());
        } else {
            clearBlockDataList();
        }
    }
    return *this;
}

inline bool T_tcu_VICS_Request_Data::operator == (const T_tcu_VICS_Request_Data& rhs) const {
    return (((!hasNavigationSettingInformation() && !rhs.hasNavigationSettingInformation()) || getNavigationSettingInformation() == rhs.getNavigationSettingInformation()) &&
        ((!hasBlockDataList() && !rhs.hasBlockDataList()) || getBlockDataList() == rhs.getBlockDataList()));
}

inline bool T_tcu_VICS_Request_Data::operator != (const T_tcu_VICS_Request_Data& rhs) const {
    return ! (*this == rhs);
}

inline bool T_tcu_VICS_Request_Data::operator < (const T_tcu_VICS_Request_Data& rhs) const {
    if (hasNavigationSettingInformation() || rhs.hasNavigationSettingInformation()) {
        if (getNavigationSettingInformation() < rhs.getNavigationSettingInformation()) return true;
        if (getNavigationSettingInformation() > rhs.getNavigationSettingInformation()) return false;
    }
    if (hasBlockDataList() || rhs.hasBlockDataList()) {
        if (getBlockDataList() < rhs.getBlockDataList()) return true;
        if (getBlockDataList() > rhs.getBlockDataList()) return false;
    }
    return false;
}

inline bool T_tcu_VICS_Request_Data::operator > (const T_tcu_VICS_Request_Data& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_tcu_VICS_Request_Data::clear() {
    clearNavigationSettingInformation();
    clearBlockDataList();
}

inline void T_tcu_VICS_Request_Data::clearNavigationSettingInformation() {
    if (hasNavigationSettingInformation()) {
         clear_has_NavigationSettingInformation();
        _NavigationSettingInformation.clear();
     }
}

inline bool T_tcu_VICS_Request_Data::hasNavigationSettingInformation () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const T_tcu_navigation_setting_information& T_tcu_VICS_Request_Data::getNavigationSettingInformation () const {
    return _NavigationSettingInformation;
}

inline T_tcu_navigation_setting_information& T_tcu_VICS_Request_Data::getNavigationSettingInformationMutable () {
    set_has_NavigationSettingInformation();
    return _NavigationSettingInformation;
}

inline void T_tcu_VICS_Request_Data::setNavigationSettingInformation (const T_tcu_navigation_setting_information& NavigationSettingInformation_) {
    set_has_NavigationSettingInformation();
    this->_NavigationSettingInformation = NavigationSettingInformation_;
}

inline void T_tcu_VICS_Request_Data::clearBlockDataList() {
    if (hasBlockDataList()) {
         clear_has_BlockDataList();
        _BlockDataList.clear();
     }
}

inline bool T_tcu_VICS_Request_Data::hasBlockDataList () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< T_tcu_Block_Data_List >& T_tcu_VICS_Request_Data::getBlockDataList () const {
    return _BlockDataList;
}

inline ::std::vector< T_tcu_Block_Data_List >& T_tcu_VICS_Request_Data::getBlockDataListMutable () {
    set_has_BlockDataList();
    return _BlockDataList;
}

inline void T_tcu_VICS_Request_Data::setBlockDataList (const ::std::vector< T_tcu_Block_Data_List >& BlockDataList_) {
    set_has_BlockDataList();
    this->_BlockDataList = BlockDataList_;
}

inline void T_tcu_VICS_Request_Data::set_has_NavigationSettingInformation () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_tcu_VICS_Request_Data::clear_has_NavigationSettingInformation () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_tcu_VICS_Request_Data::set_has_BlockDataList () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_tcu_VICS_Request_Data::clear_has_BlockDataList () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_json_file_path::T_json_file_path ()  :
    _strFilePath ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_json_file_path::T_json_file_path (const T_json_file_path &rhs)  :
    _strFilePath ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_json_file_path::T_json_file_path (const ::std::string& strFilePath_)  :
    _strFilePath (strFilePath_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strFilePath_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_json_file_path::~T_json_file_path() {
}

inline T_json_file_path& T_json_file_path::operator = (const T_json_file_path& rhs) {
    if( this != &rhs ) {
        if (rhs.hasStrFilePath()) {
            setStrFilePath(rhs.getStrFilePath());
        } else {
            clearStrFilePath();
        }
    }
    return *this;
}

inline bool T_json_file_path::operator == (const T_json_file_path& rhs) const {
    return (((!hasStrFilePath() && !rhs.hasStrFilePath()) || getStrFilePath() == rhs.getStrFilePath()));
}

inline bool T_json_file_path::operator != (const T_json_file_path& rhs) const {
    return ! (*this == rhs);
}

inline bool T_json_file_path::operator < (const T_json_file_path& rhs) const {
    if (hasStrFilePath() || rhs.hasStrFilePath()) {
        if (getStrFilePath() < rhs.getStrFilePath()) return true;
        if (getStrFilePath() > rhs.getStrFilePath()) return false;
    }
    return false;
}

inline bool T_json_file_path::operator > (const T_json_file_path& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_json_file_path::clear() {
    clearStrFilePath();
}

inline void T_json_file_path::clearStrFilePath() {
    if (hasStrFilePath()) {
         clear_has_strFilePath();
        _strFilePath.clear();
     }
}

inline bool T_json_file_path::hasStrFilePath () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_json_file_path::getStrFilePath () const {
    return _strFilePath;
}

inline ::std::string& T_json_file_path::getStrFilePathMutable () {
    set_has_strFilePath();
    return _strFilePath;
}

inline void T_json_file_path::setStrFilePath (const ::std::string& strFilePath_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strFilePath_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strFilePath();
    this->_strFilePath = strFilePath_;
}

inline void T_json_file_path::setStrFilePath (const char* strFilePath_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strFilePath_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strFilePath();
    this->_strFilePath.assign(strFilePath_);
}

inline void T_json_file_path::setStrFilePath (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strFilePath();
    this->_strFilePath.assign(value, size);
}

inline void T_json_file_path::set_has_strFilePath () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_json_file_path::clear_has_strFilePath () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  T_usb_tcu_Channel_definition_information::T_usb_tcu_Channel_definition_information ()  :
    _strChannelName (),
    _u16ChannelIconID (0u),
    _u16ChannelID (0u),
    _u16FolderID (0u),
    _u16SizeOfChannelDefInfo (0u),
    _u8FixedData1 (0u),
    _u8FixedData2 (0u),
    _u8FixedData3 (0u),
    _u8FixedData6 (0u),
    _u8FixedData7 (0u),
    _u8FixedData8 (0u),
    _u8FixedData9 (0u),
    _u8FlagOfChannelInfo (0u),
    _u8SizeOfChannelName (0u),
    _FixedData4 (),
    _FixedData5 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_usb_tcu_Channel_definition_information::T_usb_tcu_Channel_definition_information (const T_usb_tcu_Channel_definition_information &rhs)  :
    _strChannelName (),
    _u16ChannelIconID (0u),
    _u16ChannelID (0u),
    _u16FolderID (0u),
    _u16SizeOfChannelDefInfo (0u),
    _u8FixedData1 (0u),
    _u8FixedData2 (0u),
    _u8FixedData3 (0u),
    _u8FixedData6 (0u),
    _u8FixedData7 (0u),
    _u8FixedData8 (0u),
    _u8FixedData9 (0u),
    _u8FlagOfChannelInfo (0u),
    _u8SizeOfChannelName (0u),
    _FixedData4 (),
    _FixedData5 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_usb_tcu_Channel_definition_information::T_usb_tcu_Channel_definition_information (const ::std::string& strChannelName_, uint16 u16ChannelIconID_, uint16 u16ChannelID_, uint16 u16FolderID_, uint16 u16SizeOfChannelDefInfo_, uint8 u8FixedData1_, uint8 u8FixedData2_, uint8 u8FixedData3_, uint8 u8FixedData6_, uint8 u8FixedData7_, uint8 u8FixedData8_, uint8 u8FixedData9_, uint8 u8FlagOfChannelInfo_, uint8 u8SizeOfChannelName_, const ::std::vector< uint8 >& FixedData4_, const ::std::vector< uint8 >& FixedData5_)  :
    _strChannelName (strChannelName_),
    _u16ChannelIconID (u16ChannelIconID_),
    _u16ChannelID (u16ChannelID_),
    _u16FolderID (u16FolderID_),
    _u16SizeOfChannelDefInfo (u16SizeOfChannelDefInfo_),
    _u8FixedData1 (u8FixedData1_),
    _u8FixedData2 (u8FixedData2_),
    _u8FixedData3 (u8FixedData3_),
    _u8FixedData6 (u8FixedData6_),
    _u8FixedData7 (u8FixedData7_),
    _u8FixedData8 (u8FixedData8_),
    _u8FixedData9 (u8FixedData9_),
    _u8FlagOfChannelInfo (u8FlagOfChannelInfo_),
    _u8SizeOfChannelName (u8SizeOfChannelName_),
    _FixedData4 (FixedData4_),
    _FixedData5 (FixedData5_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strChannelName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_usb_tcu_Channel_definition_information::~T_usb_tcu_Channel_definition_information() {
}

inline T_usb_tcu_Channel_definition_information& T_usb_tcu_Channel_definition_information::operator = (const T_usb_tcu_Channel_definition_information& rhs) {
    if( this != &rhs ) {
        if (rhs.hasStrChannelName()) {
            setStrChannelName(rhs.getStrChannelName());
        } else {
            clearStrChannelName();
        }
        if (rhs.hasU16ChannelIconID()) {
            setU16ChannelIconID(rhs.getU16ChannelIconID());
        } else {
            clearU16ChannelIconID();
        }
        if (rhs.hasU16ChannelID()) {
            setU16ChannelID(rhs.getU16ChannelID());
        } else {
            clearU16ChannelID();
        }
        if (rhs.hasU16FolderID()) {
            setU16FolderID(rhs.getU16FolderID());
        } else {
            clearU16FolderID();
        }
        if (rhs.hasU16SizeOfChannelDefInfo()) {
            setU16SizeOfChannelDefInfo(rhs.getU16SizeOfChannelDefInfo());
        } else {
            clearU16SizeOfChannelDefInfo();
        }
        if (rhs.hasU8FixedData1()) {
            setU8FixedData1(rhs.getU8FixedData1());
        } else {
            clearU8FixedData1();
        }
        if (rhs.hasU8FixedData2()) {
            setU8FixedData2(rhs.getU8FixedData2());
        } else {
            clearU8FixedData2();
        }
        if (rhs.hasU8FixedData3()) {
            setU8FixedData3(rhs.getU8FixedData3());
        } else {
            clearU8FixedData3();
        }
        if (rhs.hasU8FixedData6()) {
            setU8FixedData6(rhs.getU8FixedData6());
        } else {
            clearU8FixedData6();
        }
        if (rhs.hasU8FixedData7()) {
            setU8FixedData7(rhs.getU8FixedData7());
        } else {
            clearU8FixedData7();
        }
        if (rhs.hasU8FixedData8()) {
            setU8FixedData8(rhs.getU8FixedData8());
        } else {
            clearU8FixedData8();
        }
        if (rhs.hasU8FixedData9()) {
            setU8FixedData9(rhs.getU8FixedData9());
        } else {
            clearU8FixedData9();
        }
        if (rhs.hasU8FlagOfChannelInfo()) {
            setU8FlagOfChannelInfo(rhs.getU8FlagOfChannelInfo());
        } else {
            clearU8FlagOfChannelInfo();
        }
        if (rhs.hasU8SizeOfChannelName()) {
            setU8SizeOfChannelName(rhs.getU8SizeOfChannelName());
        } else {
            clearU8SizeOfChannelName();
        }
        if (rhs.hasFixedData4()) {
            setFixedData4(rhs.getFixedData4());
        } else {
            clearFixedData4();
        }
        if (rhs.hasFixedData5()) {
            setFixedData5(rhs.getFixedData5());
        } else {
            clearFixedData5();
        }
    }
    return *this;
}

inline bool T_usb_tcu_Channel_definition_information::operator == (const T_usb_tcu_Channel_definition_information& rhs) const {
    return (((!hasStrChannelName() && !rhs.hasStrChannelName()) || getStrChannelName() == rhs.getStrChannelName()) &&
        ((!hasU16ChannelIconID() && !rhs.hasU16ChannelIconID()) || getU16ChannelIconID() == rhs.getU16ChannelIconID()) &&
        ((!hasU16ChannelID() && !rhs.hasU16ChannelID()) || getU16ChannelID() == rhs.getU16ChannelID()) &&
        ((!hasU16FolderID() && !rhs.hasU16FolderID()) || getU16FolderID() == rhs.getU16FolderID()) &&
        ((!hasU16SizeOfChannelDefInfo() && !rhs.hasU16SizeOfChannelDefInfo()) || getU16SizeOfChannelDefInfo() == rhs.getU16SizeOfChannelDefInfo()) &&
        ((!hasU8FixedData1() && !rhs.hasU8FixedData1()) || getU8FixedData1() == rhs.getU8FixedData1()) &&
        ((!hasU8FixedData2() && !rhs.hasU8FixedData2()) || getU8FixedData2() == rhs.getU8FixedData2()) &&
        ((!hasU8FixedData3() && !rhs.hasU8FixedData3()) || getU8FixedData3() == rhs.getU8FixedData3()) &&
        ((!hasU8FixedData6() && !rhs.hasU8FixedData6()) || getU8FixedData6() == rhs.getU8FixedData6()) &&
        ((!hasU8FixedData7() && !rhs.hasU8FixedData7()) || getU8FixedData7() == rhs.getU8FixedData7()) &&
        ((!hasU8FixedData8() && !rhs.hasU8FixedData8()) || getU8FixedData8() == rhs.getU8FixedData8()) &&
        ((!hasU8FixedData9() && !rhs.hasU8FixedData9()) || getU8FixedData9() == rhs.getU8FixedData9()) &&
        ((!hasU8FlagOfChannelInfo() && !rhs.hasU8FlagOfChannelInfo()) || getU8FlagOfChannelInfo() == rhs.getU8FlagOfChannelInfo()) &&
        ((!hasU8SizeOfChannelName() && !rhs.hasU8SizeOfChannelName()) || getU8SizeOfChannelName() == rhs.getU8SizeOfChannelName()) &&
        ((!hasFixedData4() && !rhs.hasFixedData4()) || getFixedData4() == rhs.getFixedData4()) &&
        ((!hasFixedData5() && !rhs.hasFixedData5()) || getFixedData5() == rhs.getFixedData5()));
}

inline bool T_usb_tcu_Channel_definition_information::operator != (const T_usb_tcu_Channel_definition_information& rhs) const {
    return ! (*this == rhs);
}

inline bool T_usb_tcu_Channel_definition_information::operator < (const T_usb_tcu_Channel_definition_information& rhs) const {
    if (hasStrChannelName() || rhs.hasStrChannelName()) {
        if (getStrChannelName() < rhs.getStrChannelName()) return true;
        if (getStrChannelName() > rhs.getStrChannelName()) return false;
    }
    if (hasU16ChannelIconID() || rhs.hasU16ChannelIconID()) {
        if (getU16ChannelIconID() < rhs.getU16ChannelIconID()) return true;
        if (getU16ChannelIconID() > rhs.getU16ChannelIconID()) return false;
    }
    if (hasU16ChannelID() || rhs.hasU16ChannelID()) {
        if (getU16ChannelID() < rhs.getU16ChannelID()) return true;
        if (getU16ChannelID() > rhs.getU16ChannelID()) return false;
    }
    if (hasU16FolderID() || rhs.hasU16FolderID()) {
        if (getU16FolderID() < rhs.getU16FolderID()) return true;
        if (getU16FolderID() > rhs.getU16FolderID()) return false;
    }
    if (hasU16SizeOfChannelDefInfo() || rhs.hasU16SizeOfChannelDefInfo()) {
        if (getU16SizeOfChannelDefInfo() < rhs.getU16SizeOfChannelDefInfo()) return true;
        if (getU16SizeOfChannelDefInfo() > rhs.getU16SizeOfChannelDefInfo()) return false;
    }
    if (hasU8FixedData1() || rhs.hasU8FixedData1()) {
        if (getU8FixedData1() < rhs.getU8FixedData1()) return true;
        if (getU8FixedData1() > rhs.getU8FixedData1()) return false;
    }
    if (hasU8FixedData2() || rhs.hasU8FixedData2()) {
        if (getU8FixedData2() < rhs.getU8FixedData2()) return true;
        if (getU8FixedData2() > rhs.getU8FixedData2()) return false;
    }
    if (hasU8FixedData3() || rhs.hasU8FixedData3()) {
        if (getU8FixedData3() < rhs.getU8FixedData3()) return true;
        if (getU8FixedData3() > rhs.getU8FixedData3()) return false;
    }
    if (hasU8FixedData6() || rhs.hasU8FixedData6()) {
        if (getU8FixedData6() < rhs.getU8FixedData6()) return true;
        if (getU8FixedData6() > rhs.getU8FixedData6()) return false;
    }
    if (hasU8FixedData7() || rhs.hasU8FixedData7()) {
        if (getU8FixedData7() < rhs.getU8FixedData7()) return true;
        if (getU8FixedData7() > rhs.getU8FixedData7()) return false;
    }
    if (hasU8FixedData8() || rhs.hasU8FixedData8()) {
        if (getU8FixedData8() < rhs.getU8FixedData8()) return true;
        if (getU8FixedData8() > rhs.getU8FixedData8()) return false;
    }
    if (hasU8FixedData9() || rhs.hasU8FixedData9()) {
        if (getU8FixedData9() < rhs.getU8FixedData9()) return true;
        if (getU8FixedData9() > rhs.getU8FixedData9()) return false;
    }
    if (hasU8FlagOfChannelInfo() || rhs.hasU8FlagOfChannelInfo()) {
        if (getU8FlagOfChannelInfo() < rhs.getU8FlagOfChannelInfo()) return true;
        if (getU8FlagOfChannelInfo() > rhs.getU8FlagOfChannelInfo()) return false;
    }
    if (hasU8SizeOfChannelName() || rhs.hasU8SizeOfChannelName()) {
        if (getU8SizeOfChannelName() < rhs.getU8SizeOfChannelName()) return true;
        if (getU8SizeOfChannelName() > rhs.getU8SizeOfChannelName()) return false;
    }
    if (hasFixedData4() || rhs.hasFixedData4()) {
        if (getFixedData4() < rhs.getFixedData4()) return true;
        if (getFixedData4() > rhs.getFixedData4()) return false;
    }
    if (hasFixedData5() || rhs.hasFixedData5()) {
        if (getFixedData5() < rhs.getFixedData5()) return true;
        if (getFixedData5() > rhs.getFixedData5()) return false;
    }
    return false;
}

inline bool T_usb_tcu_Channel_definition_information::operator > (const T_usb_tcu_Channel_definition_information& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_usb_tcu_Channel_definition_information::clear() {
    clearStrChannelName();
    clearU16ChannelIconID();
    clearU16ChannelID();
    clearU16FolderID();
    clearU16SizeOfChannelDefInfo();
    clearU8FixedData1();
    clearU8FixedData2();
    clearU8FixedData3();
    clearU8FixedData6();
    clearU8FixedData7();
    clearU8FixedData8();
    clearU8FixedData9();
    clearU8FlagOfChannelInfo();
    clearU8SizeOfChannelName();
    clearFixedData4();
    clearFixedData5();
}

inline void T_usb_tcu_Channel_definition_information::clearStrChannelName() {
    if (hasStrChannelName()) {
         clear_has_strChannelName();
        _strChannelName.clear();
     }
}

inline bool T_usb_tcu_Channel_definition_information::hasStrChannelName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_usb_tcu_Channel_definition_information::getStrChannelName () const {
    return _strChannelName;
}

inline ::std::string& T_usb_tcu_Channel_definition_information::getStrChannelNameMutable () {
    set_has_strChannelName();
    return _strChannelName;
}

inline void T_usb_tcu_Channel_definition_information::setStrChannelName (const ::std::string& strChannelName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strChannelName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strChannelName();
    this->_strChannelName = strChannelName_;
}

inline void T_usb_tcu_Channel_definition_information::setStrChannelName (const char* strChannelName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strChannelName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strChannelName();
    this->_strChannelName.assign(strChannelName_);
}

inline void T_usb_tcu_Channel_definition_information::setStrChannelName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strChannelName();
    this->_strChannelName.assign(value, size);
}

inline void T_usb_tcu_Channel_definition_information::clearU16ChannelIconID() {
    if (hasU16ChannelIconID()) {
         clear_has_u16ChannelIconID();
        _u16ChannelIconID = 0u;
     }
}

inline bool T_usb_tcu_Channel_definition_information::hasU16ChannelIconID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 T_usb_tcu_Channel_definition_information::getU16ChannelIconID () const {
    return _u16ChannelIconID;
}

inline void T_usb_tcu_Channel_definition_information::setU16ChannelIconID (uint16 u16ChannelIconID_) {
    set_has_u16ChannelIconID();
    this->_u16ChannelIconID = u16ChannelIconID_;
}

inline void T_usb_tcu_Channel_definition_information::clearU16ChannelID() {
    if (hasU16ChannelID()) {
         clear_has_u16ChannelID();
        _u16ChannelID = 0u;
     }
}

inline bool T_usb_tcu_Channel_definition_information::hasU16ChannelID () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 T_usb_tcu_Channel_definition_information::getU16ChannelID () const {
    return _u16ChannelID;
}

inline void T_usb_tcu_Channel_definition_information::setU16ChannelID (uint16 u16ChannelID_) {
    set_has_u16ChannelID();
    this->_u16ChannelID = u16ChannelID_;
}

inline void T_usb_tcu_Channel_definition_information::clearU16FolderID() {
    if (hasU16FolderID()) {
         clear_has_u16FolderID();
        _u16FolderID = 0u;
     }
}

inline bool T_usb_tcu_Channel_definition_information::hasU16FolderID () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 T_usb_tcu_Channel_definition_information::getU16FolderID () const {
    return _u16FolderID;
}

inline void T_usb_tcu_Channel_definition_information::setU16FolderID (uint16 u16FolderID_) {
    set_has_u16FolderID();
    this->_u16FolderID = u16FolderID_;
}

inline void T_usb_tcu_Channel_definition_information::clearU16SizeOfChannelDefInfo() {
    if (hasU16SizeOfChannelDefInfo()) {
         clear_has_u16SizeOfChannelDefInfo();
        _u16SizeOfChannelDefInfo = 0u;
     }
}

inline bool T_usb_tcu_Channel_definition_information::hasU16SizeOfChannelDefInfo () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint16 T_usb_tcu_Channel_definition_information::getU16SizeOfChannelDefInfo () const {
    return _u16SizeOfChannelDefInfo;
}

inline void T_usb_tcu_Channel_definition_information::setU16SizeOfChannelDefInfo (uint16 u16SizeOfChannelDefInfo_) {
    set_has_u16SizeOfChannelDefInfo();
    this->_u16SizeOfChannelDefInfo = u16SizeOfChannelDefInfo_;
}

inline void T_usb_tcu_Channel_definition_information::clearU8FixedData1() {
    if (hasU8FixedData1()) {
         clear_has_u8FixedData1();
        _u8FixedData1 = 0u;
     }
}

inline bool T_usb_tcu_Channel_definition_information::hasU8FixedData1 () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint8 T_usb_tcu_Channel_definition_information::getU8FixedData1 () const {
    return _u8FixedData1;
}

inline void T_usb_tcu_Channel_definition_information::setU8FixedData1 (uint8 u8FixedData1_) {
    set_has_u8FixedData1();
    this->_u8FixedData1 = u8FixedData1_;
}

inline void T_usb_tcu_Channel_definition_information::clearU8FixedData2() {
    if (hasU8FixedData2()) {
         clear_has_u8FixedData2();
        _u8FixedData2 = 0u;
     }
}

inline bool T_usb_tcu_Channel_definition_information::hasU8FixedData2 () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint8 T_usb_tcu_Channel_definition_information::getU8FixedData2 () const {
    return _u8FixedData2;
}

inline void T_usb_tcu_Channel_definition_information::setU8FixedData2 (uint8 u8FixedData2_) {
    set_has_u8FixedData2();
    this->_u8FixedData2 = u8FixedData2_;
}

inline void T_usb_tcu_Channel_definition_information::clearU8FixedData3() {
    if (hasU8FixedData3()) {
         clear_has_u8FixedData3();
        _u8FixedData3 = 0u;
     }
}

inline bool T_usb_tcu_Channel_definition_information::hasU8FixedData3 () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline uint8 T_usb_tcu_Channel_definition_information::getU8FixedData3 () const {
    return _u8FixedData3;
}

inline void T_usb_tcu_Channel_definition_information::setU8FixedData3 (uint8 u8FixedData3_) {
    set_has_u8FixedData3();
    this->_u8FixedData3 = u8FixedData3_;
}

inline void T_usb_tcu_Channel_definition_information::clearU8FixedData6() {
    if (hasU8FixedData6()) {
         clear_has_u8FixedData6();
        _u8FixedData6 = 0u;
     }
}

inline bool T_usb_tcu_Channel_definition_information::hasU8FixedData6 () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline uint8 T_usb_tcu_Channel_definition_information::getU8FixedData6 () const {
    return _u8FixedData6;
}

inline void T_usb_tcu_Channel_definition_information::setU8FixedData6 (uint8 u8FixedData6_) {
    set_has_u8FixedData6();
    this->_u8FixedData6 = u8FixedData6_;
}

inline void T_usb_tcu_Channel_definition_information::clearU8FixedData7() {
    if (hasU8FixedData7()) {
         clear_has_u8FixedData7();
        _u8FixedData7 = 0u;
     }
}

inline bool T_usb_tcu_Channel_definition_information::hasU8FixedData7 () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline uint8 T_usb_tcu_Channel_definition_information::getU8FixedData7 () const {
    return _u8FixedData7;
}

inline void T_usb_tcu_Channel_definition_information::setU8FixedData7 (uint8 u8FixedData7_) {
    set_has_u8FixedData7();
    this->_u8FixedData7 = u8FixedData7_;
}

inline void T_usb_tcu_Channel_definition_information::clearU8FixedData8() {
    if (hasU8FixedData8()) {
         clear_has_u8FixedData8();
        _u8FixedData8 = 0u;
     }
}

inline bool T_usb_tcu_Channel_definition_information::hasU8FixedData8 () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline uint8 T_usb_tcu_Channel_definition_information::getU8FixedData8 () const {
    return _u8FixedData8;
}

inline void T_usb_tcu_Channel_definition_information::setU8FixedData8 (uint8 u8FixedData8_) {
    set_has_u8FixedData8();
    this->_u8FixedData8 = u8FixedData8_;
}

inline void T_usb_tcu_Channel_definition_information::clearU8FixedData9() {
    if (hasU8FixedData9()) {
         clear_has_u8FixedData9();
        _u8FixedData9 = 0u;
     }
}

inline bool T_usb_tcu_Channel_definition_information::hasU8FixedData9 () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline uint8 T_usb_tcu_Channel_definition_information::getU8FixedData9 () const {
    return _u8FixedData9;
}

inline void T_usb_tcu_Channel_definition_information::setU8FixedData9 (uint8 u8FixedData9_) {
    set_has_u8FixedData9();
    this->_u8FixedData9 = u8FixedData9_;
}

inline void T_usb_tcu_Channel_definition_information::clearU8FlagOfChannelInfo() {
    if (hasU8FlagOfChannelInfo()) {
         clear_has_u8FlagOfChannelInfo();
        _u8FlagOfChannelInfo = 0u;
     }
}

inline bool T_usb_tcu_Channel_definition_information::hasU8FlagOfChannelInfo () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline uint8 T_usb_tcu_Channel_definition_information::getU8FlagOfChannelInfo () const {
    return _u8FlagOfChannelInfo;
}

inline void T_usb_tcu_Channel_definition_information::setU8FlagOfChannelInfo (uint8 u8FlagOfChannelInfo_) {
    set_has_u8FlagOfChannelInfo();
    this->_u8FlagOfChannelInfo = u8FlagOfChannelInfo_;
}

inline void T_usb_tcu_Channel_definition_information::clearU8SizeOfChannelName() {
    if (hasU8SizeOfChannelName()) {
         clear_has_u8SizeOfChannelName();
        _u8SizeOfChannelName = 0u;
     }
}

inline bool T_usb_tcu_Channel_definition_information::hasU8SizeOfChannelName () const {
    return (_has_bits_[0] & (1u << 13)) > 0;
}

inline uint8 T_usb_tcu_Channel_definition_information::getU8SizeOfChannelName () const {
    return _u8SizeOfChannelName;
}

inline void T_usb_tcu_Channel_definition_information::setU8SizeOfChannelName (uint8 u8SizeOfChannelName_) {
    set_has_u8SizeOfChannelName();
    this->_u8SizeOfChannelName = u8SizeOfChannelName_;
}

inline void T_usb_tcu_Channel_definition_information::clearFixedData4() {
    if (hasFixedData4()) {
         clear_has_FixedData4();
        _FixedData4.clear();
     }
}

inline bool T_usb_tcu_Channel_definition_information::hasFixedData4 () const {
    return (_has_bits_[0] & (1u << 14)) > 0;
}

inline const ::std::vector< uint8 >& T_usb_tcu_Channel_definition_information::getFixedData4 () const {
    return _FixedData4;
}

inline ::std::vector< uint8 >& T_usb_tcu_Channel_definition_information::getFixedData4Mutable () {
    set_has_FixedData4();
    return _FixedData4;
}

inline void T_usb_tcu_Channel_definition_information::setFixedData4 (const ::std::vector< uint8 >& FixedData4_) {
    set_has_FixedData4();
    this->_FixedData4 = FixedData4_;
}

inline void T_usb_tcu_Channel_definition_information::clearFixedData5() {
    if (hasFixedData5()) {
         clear_has_FixedData5();
        _FixedData5.clear();
     }
}

inline bool T_usb_tcu_Channel_definition_information::hasFixedData5 () const {
    return (_has_bits_[0] & (1u << 15)) > 0;
}

inline const ::std::vector< uint8 >& T_usb_tcu_Channel_definition_information::getFixedData5 () const {
    return _FixedData5;
}

inline ::std::vector< uint8 >& T_usb_tcu_Channel_definition_information::getFixedData5Mutable () {
    set_has_FixedData5();
    return _FixedData5;
}

inline void T_usb_tcu_Channel_definition_information::setFixedData5 (const ::std::vector< uint8 >& FixedData5_) {
    set_has_FixedData5();
    this->_FixedData5 = FixedData5_;
}

inline void T_usb_tcu_Channel_definition_information::set_has_strChannelName () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_usb_tcu_Channel_definition_information::clear_has_strChannelName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_usb_tcu_Channel_definition_information::set_has_u16ChannelIconID () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_usb_tcu_Channel_definition_information::clear_has_u16ChannelIconID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_usb_tcu_Channel_definition_information::set_has_u16ChannelID () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_usb_tcu_Channel_definition_information::clear_has_u16ChannelID () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_usb_tcu_Channel_definition_information::set_has_u16FolderID () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_usb_tcu_Channel_definition_information::clear_has_u16FolderID () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_usb_tcu_Channel_definition_information::set_has_u16SizeOfChannelDefInfo () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_usb_tcu_Channel_definition_information::clear_has_u16SizeOfChannelDefInfo () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_usb_tcu_Channel_definition_information::set_has_u8FixedData1 () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_usb_tcu_Channel_definition_information::clear_has_u8FixedData1 () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_usb_tcu_Channel_definition_information::set_has_u8FixedData2 () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_usb_tcu_Channel_definition_information::clear_has_u8FixedData2 () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_usb_tcu_Channel_definition_information::set_has_u8FixedData3 () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_usb_tcu_Channel_definition_information::clear_has_u8FixedData3 () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_usb_tcu_Channel_definition_information::set_has_u8FixedData6 () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_usb_tcu_Channel_definition_information::clear_has_u8FixedData6 () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_usb_tcu_Channel_definition_information::set_has_u8FixedData7 () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_usb_tcu_Channel_definition_information::clear_has_u8FixedData7 () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_usb_tcu_Channel_definition_information::set_has_u8FixedData8 () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_usb_tcu_Channel_definition_information::clear_has_u8FixedData8 () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void T_usb_tcu_Channel_definition_information::set_has_u8FixedData9 () {
    _has_bits_[0] |= 1u << 11;
}

inline void T_usb_tcu_Channel_definition_information::clear_has_u8FixedData9 () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void T_usb_tcu_Channel_definition_information::set_has_u8FlagOfChannelInfo () {
    _has_bits_[0] |= 1u << 12;
}

inline void T_usb_tcu_Channel_definition_information::clear_has_u8FlagOfChannelInfo () {
    _has_bits_[0] &= ~ (1u << 12);
}

inline void T_usb_tcu_Channel_definition_information::set_has_u8SizeOfChannelName () {
    _has_bits_[0] |= 1u << 13;
}

inline void T_usb_tcu_Channel_definition_information::clear_has_u8SizeOfChannelName () {
    _has_bits_[0] &= ~ (1u << 13);
}

inline void T_usb_tcu_Channel_definition_information::set_has_FixedData4 () {
    _has_bits_[0] |= 1u << 14;
}

inline void T_usb_tcu_Channel_definition_information::clear_has_FixedData4 () {
    _has_bits_[0] &= ~ (1u << 14);
}

inline void T_usb_tcu_Channel_definition_information::set_has_FixedData5 () {
    _has_bits_[0] |= 1u << 15;
}

inline void T_usb_tcu_Channel_definition_information::clear_has_FixedData5 () {
    _has_bits_[0] &= ~ (1u << 15);
}

inline  T_usb_tcu_Channel_Info::T_usb_tcu_Channel_Info ()  :
    _u8ResumeDownload (false),
    _u16ChannelID (0u),
    _u8ChannelContentID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_usb_tcu_Channel_Info::T_usb_tcu_Channel_Info (const T_usb_tcu_Channel_Info &rhs)  :
    _u8ResumeDownload (false),
    _u16ChannelID (0u),
    _u8ChannelContentID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_usb_tcu_Channel_Info::T_usb_tcu_Channel_Info (bool u8ResumeDownload_, uint16 u16ChannelID_, uint8 u8ChannelContentID_)  :
    _u8ResumeDownload (u8ResumeDownload_),
    _u16ChannelID (u16ChannelID_),
    _u8ChannelContentID (u8ChannelContentID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_usb_tcu_Channel_Info::~T_usb_tcu_Channel_Info() {
}

inline T_usb_tcu_Channel_Info& T_usb_tcu_Channel_Info::operator = (const T_usb_tcu_Channel_Info& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8ResumeDownload()) {
            setU8ResumeDownload(rhs.getU8ResumeDownload());
        } else {
            clearU8ResumeDownload();
        }
        if (rhs.hasU16ChannelID()) {
            setU16ChannelID(rhs.getU16ChannelID());
        } else {
            clearU16ChannelID();
        }
        if (rhs.hasU8ChannelContentID()) {
            setU8ChannelContentID(rhs.getU8ChannelContentID());
        } else {
            clearU8ChannelContentID();
        }
    }
    return *this;
}

inline bool T_usb_tcu_Channel_Info::operator == (const T_usb_tcu_Channel_Info& rhs) const {
    return (((!hasU8ResumeDownload() && !rhs.hasU8ResumeDownload()) || getU8ResumeDownload() == rhs.getU8ResumeDownload()) &&
        ((!hasU16ChannelID() && !rhs.hasU16ChannelID()) || getU16ChannelID() == rhs.getU16ChannelID()) &&
        ((!hasU8ChannelContentID() && !rhs.hasU8ChannelContentID()) || getU8ChannelContentID() == rhs.getU8ChannelContentID()));
}

inline bool T_usb_tcu_Channel_Info::operator != (const T_usb_tcu_Channel_Info& rhs) const {
    return ! (*this == rhs);
}

inline bool T_usb_tcu_Channel_Info::operator < (const T_usb_tcu_Channel_Info& rhs) const {
    if (hasU8ResumeDownload() || rhs.hasU8ResumeDownload()) {
        if (getU8ResumeDownload() < rhs.getU8ResumeDownload()) return true;
        if (getU8ResumeDownload() > rhs.getU8ResumeDownload()) return false;
    }
    if (hasU16ChannelID() || rhs.hasU16ChannelID()) {
        if (getU16ChannelID() < rhs.getU16ChannelID()) return true;
        if (getU16ChannelID() > rhs.getU16ChannelID()) return false;
    }
    if (hasU8ChannelContentID() || rhs.hasU8ChannelContentID()) {
        if (getU8ChannelContentID() < rhs.getU8ChannelContentID()) return true;
        if (getU8ChannelContentID() > rhs.getU8ChannelContentID()) return false;
    }
    return false;
}

inline bool T_usb_tcu_Channel_Info::operator > (const T_usb_tcu_Channel_Info& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_usb_tcu_Channel_Info::clear() {
    clearU8ResumeDownload();
    clearU16ChannelID();
    clearU8ChannelContentID();
}

inline void T_usb_tcu_Channel_Info::clearU8ResumeDownload() {
    if (hasU8ResumeDownload()) {
         clear_has_u8ResumeDownload();
        _u8ResumeDownload = false;
     }
}

inline bool T_usb_tcu_Channel_Info::hasU8ResumeDownload () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool T_usb_tcu_Channel_Info::getU8ResumeDownload () const {
    return _u8ResumeDownload;
}

inline void T_usb_tcu_Channel_Info::setU8ResumeDownload (bool u8ResumeDownload_) {
    set_has_u8ResumeDownload();
    this->_u8ResumeDownload = u8ResumeDownload_;
}

inline void T_usb_tcu_Channel_Info::clearU16ChannelID() {
    if (hasU16ChannelID()) {
         clear_has_u16ChannelID();
        _u16ChannelID = 0u;
     }
}

inline bool T_usb_tcu_Channel_Info::hasU16ChannelID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 T_usb_tcu_Channel_Info::getU16ChannelID () const {
    return _u16ChannelID;
}

inline void T_usb_tcu_Channel_Info::setU16ChannelID (uint16 u16ChannelID_) {
    set_has_u16ChannelID();
    this->_u16ChannelID = u16ChannelID_;
}

inline void T_usb_tcu_Channel_Info::clearU8ChannelContentID() {
    if (hasU8ChannelContentID()) {
         clear_has_u8ChannelContentID();
        _u8ChannelContentID = 0u;
     }
}

inline bool T_usb_tcu_Channel_Info::hasU8ChannelContentID () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 T_usb_tcu_Channel_Info::getU8ChannelContentID () const {
    return _u8ChannelContentID;
}

inline void T_usb_tcu_Channel_Info::setU8ChannelContentID (uint8 u8ChannelContentID_) {
    set_has_u8ChannelContentID();
    this->_u8ChannelContentID = u8ChannelContentID_;
}

inline void T_usb_tcu_Channel_Info::set_has_u8ResumeDownload () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_usb_tcu_Channel_Info::clear_has_u8ResumeDownload () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_usb_tcu_Channel_Info::set_has_u16ChannelID () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_usb_tcu_Channel_Info::clear_has_u16ChannelID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_usb_tcu_Channel_Info::set_has_u8ChannelContentID () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_usb_tcu_Channel_Info::clear_has_u8ChannelContentID () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_usb_tcu_channel_master_data_header::T_usb_tcu_channel_master_data_header ()  :
    _u16NumOfChannelDefInfo (0u),
    _u8NumOfFolderDefInfo (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_usb_tcu_channel_master_data_header::T_usb_tcu_channel_master_data_header (const T_usb_tcu_channel_master_data_header &rhs)  :
    _u16NumOfChannelDefInfo (0u),
    _u8NumOfFolderDefInfo (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_usb_tcu_channel_master_data_header::T_usb_tcu_channel_master_data_header (uint16 u16NumOfChannelDefInfo_, uint8 u8NumOfFolderDefInfo_)  :
    _u16NumOfChannelDefInfo (u16NumOfChannelDefInfo_),
    _u8NumOfFolderDefInfo (u8NumOfFolderDefInfo_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_usb_tcu_channel_master_data_header::~T_usb_tcu_channel_master_data_header() {
}

inline T_usb_tcu_channel_master_data_header& T_usb_tcu_channel_master_data_header::operator = (const T_usb_tcu_channel_master_data_header& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU16NumOfChannelDefInfo()) {
            setU16NumOfChannelDefInfo(rhs.getU16NumOfChannelDefInfo());
        } else {
            clearU16NumOfChannelDefInfo();
        }
        if (rhs.hasU8NumOfFolderDefInfo()) {
            setU8NumOfFolderDefInfo(rhs.getU8NumOfFolderDefInfo());
        } else {
            clearU8NumOfFolderDefInfo();
        }
    }
    return *this;
}

inline bool T_usb_tcu_channel_master_data_header::operator == (const T_usb_tcu_channel_master_data_header& rhs) const {
    return (((!hasU16NumOfChannelDefInfo() && !rhs.hasU16NumOfChannelDefInfo()) || getU16NumOfChannelDefInfo() == rhs.getU16NumOfChannelDefInfo()) &&
        ((!hasU8NumOfFolderDefInfo() && !rhs.hasU8NumOfFolderDefInfo()) || getU8NumOfFolderDefInfo() == rhs.getU8NumOfFolderDefInfo()));
}

inline bool T_usb_tcu_channel_master_data_header::operator != (const T_usb_tcu_channel_master_data_header& rhs) const {
    return ! (*this == rhs);
}

inline bool T_usb_tcu_channel_master_data_header::operator < (const T_usb_tcu_channel_master_data_header& rhs) const {
    if (hasU16NumOfChannelDefInfo() || rhs.hasU16NumOfChannelDefInfo()) {
        if (getU16NumOfChannelDefInfo() < rhs.getU16NumOfChannelDefInfo()) return true;
        if (getU16NumOfChannelDefInfo() > rhs.getU16NumOfChannelDefInfo()) return false;
    }
    if (hasU8NumOfFolderDefInfo() || rhs.hasU8NumOfFolderDefInfo()) {
        if (getU8NumOfFolderDefInfo() < rhs.getU8NumOfFolderDefInfo()) return true;
        if (getU8NumOfFolderDefInfo() > rhs.getU8NumOfFolderDefInfo()) return false;
    }
    return false;
}

inline bool T_usb_tcu_channel_master_data_header::operator > (const T_usb_tcu_channel_master_data_header& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_usb_tcu_channel_master_data_header::clear() {
    clearU16NumOfChannelDefInfo();
    clearU8NumOfFolderDefInfo();
}

inline void T_usb_tcu_channel_master_data_header::clearU16NumOfChannelDefInfo() {
    if (hasU16NumOfChannelDefInfo()) {
         clear_has_u16NumOfChannelDefInfo();
        _u16NumOfChannelDefInfo = 0u;
     }
}

inline bool T_usb_tcu_channel_master_data_header::hasU16NumOfChannelDefInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 T_usb_tcu_channel_master_data_header::getU16NumOfChannelDefInfo () const {
    return _u16NumOfChannelDefInfo;
}

inline void T_usb_tcu_channel_master_data_header::setU16NumOfChannelDefInfo (uint16 u16NumOfChannelDefInfo_) {
    set_has_u16NumOfChannelDefInfo();
    this->_u16NumOfChannelDefInfo = u16NumOfChannelDefInfo_;
}

inline void T_usb_tcu_channel_master_data_header::clearU8NumOfFolderDefInfo() {
    if (hasU8NumOfFolderDefInfo()) {
         clear_has_u8NumOfFolderDefInfo();
        _u8NumOfFolderDefInfo = 0u;
     }
}

inline bool T_usb_tcu_channel_master_data_header::hasU8NumOfFolderDefInfo () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_usb_tcu_channel_master_data_header::getU8NumOfFolderDefInfo () const {
    return _u8NumOfFolderDefInfo;
}

inline void T_usb_tcu_channel_master_data_header::setU8NumOfFolderDefInfo (uint8 u8NumOfFolderDefInfo_) {
    set_has_u8NumOfFolderDefInfo();
    this->_u8NumOfFolderDefInfo = u8NumOfFolderDefInfo_;
}

inline void T_usb_tcu_channel_master_data_header::set_has_u16NumOfChannelDefInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_usb_tcu_channel_master_data_header::clear_has_u16NumOfChannelDefInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_usb_tcu_channel_master_data_header::set_has_u8NumOfFolderDefInfo () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_usb_tcu_channel_master_data_header::clear_has_u8NumOfFolderDefInfo () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_usb_tcu_Folder_definition_information::T_usb_tcu_Folder_definition_information ()  :
    _strFolderName (),
    _u16FolderIconID (0u),
    _u16FolderID (0u),
    _u16SizeOfFolderDefInfo (0u),
    _u8FixedData1 (0u),
    _u8FixedData2 (0u),
    _u8SizeOfFolderName (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_usb_tcu_Folder_definition_information::T_usb_tcu_Folder_definition_information (const T_usb_tcu_Folder_definition_information &rhs)  :
    _strFolderName (),
    _u16FolderIconID (0u),
    _u16FolderID (0u),
    _u16SizeOfFolderDefInfo (0u),
    _u8FixedData1 (0u),
    _u8FixedData2 (0u),
    _u8SizeOfFolderName (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_usb_tcu_Folder_definition_information::T_usb_tcu_Folder_definition_information (const ::std::string& strFolderName_, uint16 u16FolderIconID_, uint16 u16FolderID_, uint16 u16SizeOfFolderDefInfo_, uint8 u8FixedData1_, uint8 u8FixedData2_, uint8 u8SizeOfFolderName_)  :
    _strFolderName (strFolderName_),
    _u16FolderIconID (u16FolderIconID_),
    _u16FolderID (u16FolderID_),
    _u16SizeOfFolderDefInfo (u16SizeOfFolderDefInfo_),
    _u8FixedData1 (u8FixedData1_),
    _u8FixedData2 (u8FixedData2_),
    _u8SizeOfFolderName (u8SizeOfFolderName_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strFolderName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_usb_tcu_Folder_definition_information::~T_usb_tcu_Folder_definition_information() {
}

inline T_usb_tcu_Folder_definition_information& T_usb_tcu_Folder_definition_information::operator = (const T_usb_tcu_Folder_definition_information& rhs) {
    if( this != &rhs ) {
        if (rhs.hasStrFolderName()) {
            setStrFolderName(rhs.getStrFolderName());
        } else {
            clearStrFolderName();
        }
        if (rhs.hasU16FolderIconID()) {
            setU16FolderIconID(rhs.getU16FolderIconID());
        } else {
            clearU16FolderIconID();
        }
        if (rhs.hasU16FolderID()) {
            setU16FolderID(rhs.getU16FolderID());
        } else {
            clearU16FolderID();
        }
        if (rhs.hasU16SizeOfFolderDefInfo()) {
            setU16SizeOfFolderDefInfo(rhs.getU16SizeOfFolderDefInfo());
        } else {
            clearU16SizeOfFolderDefInfo();
        }
        if (rhs.hasU8FixedData1()) {
            setU8FixedData1(rhs.getU8FixedData1());
        } else {
            clearU8FixedData1();
        }
        if (rhs.hasU8FixedData2()) {
            setU8FixedData2(rhs.getU8FixedData2());
        } else {
            clearU8FixedData2();
        }
        if (rhs.hasU8SizeOfFolderName()) {
            setU8SizeOfFolderName(rhs.getU8SizeOfFolderName());
        } else {
            clearU8SizeOfFolderName();
        }
    }
    return *this;
}

inline bool T_usb_tcu_Folder_definition_information::operator == (const T_usb_tcu_Folder_definition_information& rhs) const {
    return (((!hasStrFolderName() && !rhs.hasStrFolderName()) || getStrFolderName() == rhs.getStrFolderName()) &&
        ((!hasU16FolderIconID() && !rhs.hasU16FolderIconID()) || getU16FolderIconID() == rhs.getU16FolderIconID()) &&
        ((!hasU16FolderID() && !rhs.hasU16FolderID()) || getU16FolderID() == rhs.getU16FolderID()) &&
        ((!hasU16SizeOfFolderDefInfo() && !rhs.hasU16SizeOfFolderDefInfo()) || getU16SizeOfFolderDefInfo() == rhs.getU16SizeOfFolderDefInfo()) &&
        ((!hasU8FixedData1() && !rhs.hasU8FixedData1()) || getU8FixedData1() == rhs.getU8FixedData1()) &&
        ((!hasU8FixedData2() && !rhs.hasU8FixedData2()) || getU8FixedData2() == rhs.getU8FixedData2()) &&
        ((!hasU8SizeOfFolderName() && !rhs.hasU8SizeOfFolderName()) || getU8SizeOfFolderName() == rhs.getU8SizeOfFolderName()));
}

inline bool T_usb_tcu_Folder_definition_information::operator != (const T_usb_tcu_Folder_definition_information& rhs) const {
    return ! (*this == rhs);
}

inline bool T_usb_tcu_Folder_definition_information::operator < (const T_usb_tcu_Folder_definition_information& rhs) const {
    if (hasStrFolderName() || rhs.hasStrFolderName()) {
        if (getStrFolderName() < rhs.getStrFolderName()) return true;
        if (getStrFolderName() > rhs.getStrFolderName()) return false;
    }
    if (hasU16FolderIconID() || rhs.hasU16FolderIconID()) {
        if (getU16FolderIconID() < rhs.getU16FolderIconID()) return true;
        if (getU16FolderIconID() > rhs.getU16FolderIconID()) return false;
    }
    if (hasU16FolderID() || rhs.hasU16FolderID()) {
        if (getU16FolderID() < rhs.getU16FolderID()) return true;
        if (getU16FolderID() > rhs.getU16FolderID()) return false;
    }
    if (hasU16SizeOfFolderDefInfo() || rhs.hasU16SizeOfFolderDefInfo()) {
        if (getU16SizeOfFolderDefInfo() < rhs.getU16SizeOfFolderDefInfo()) return true;
        if (getU16SizeOfFolderDefInfo() > rhs.getU16SizeOfFolderDefInfo()) return false;
    }
    if (hasU8FixedData1() || rhs.hasU8FixedData1()) {
        if (getU8FixedData1() < rhs.getU8FixedData1()) return true;
        if (getU8FixedData1() > rhs.getU8FixedData1()) return false;
    }
    if (hasU8FixedData2() || rhs.hasU8FixedData2()) {
        if (getU8FixedData2() < rhs.getU8FixedData2()) return true;
        if (getU8FixedData2() > rhs.getU8FixedData2()) return false;
    }
    if (hasU8SizeOfFolderName() || rhs.hasU8SizeOfFolderName()) {
        if (getU8SizeOfFolderName() < rhs.getU8SizeOfFolderName()) return true;
        if (getU8SizeOfFolderName() > rhs.getU8SizeOfFolderName()) return false;
    }
    return false;
}

inline bool T_usb_tcu_Folder_definition_information::operator > (const T_usb_tcu_Folder_definition_information& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_usb_tcu_Folder_definition_information::clear() {
    clearStrFolderName();
    clearU16FolderIconID();
    clearU16FolderID();
    clearU16SizeOfFolderDefInfo();
    clearU8FixedData1();
    clearU8FixedData2();
    clearU8SizeOfFolderName();
}

inline void T_usb_tcu_Folder_definition_information::clearStrFolderName() {
    if (hasStrFolderName()) {
         clear_has_strFolderName();
        _strFolderName.clear();
     }
}

inline bool T_usb_tcu_Folder_definition_information::hasStrFolderName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_usb_tcu_Folder_definition_information::getStrFolderName () const {
    return _strFolderName;
}

inline ::std::string& T_usb_tcu_Folder_definition_information::getStrFolderNameMutable () {
    set_has_strFolderName();
    return _strFolderName;
}

inline void T_usb_tcu_Folder_definition_information::setStrFolderName (const ::std::string& strFolderName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strFolderName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strFolderName();
    this->_strFolderName = strFolderName_;
}

inline void T_usb_tcu_Folder_definition_information::setStrFolderName (const char* strFolderName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strFolderName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strFolderName();
    this->_strFolderName.assign(strFolderName_);
}

inline void T_usb_tcu_Folder_definition_information::setStrFolderName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strFolderName();
    this->_strFolderName.assign(value, size);
}

inline void T_usb_tcu_Folder_definition_information::clearU16FolderIconID() {
    if (hasU16FolderIconID()) {
         clear_has_u16FolderIconID();
        _u16FolderIconID = 0u;
     }
}

inline bool T_usb_tcu_Folder_definition_information::hasU16FolderIconID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 T_usb_tcu_Folder_definition_information::getU16FolderIconID () const {
    return _u16FolderIconID;
}

inline void T_usb_tcu_Folder_definition_information::setU16FolderIconID (uint16 u16FolderIconID_) {
    set_has_u16FolderIconID();
    this->_u16FolderIconID = u16FolderIconID_;
}

inline void T_usb_tcu_Folder_definition_information::clearU16FolderID() {
    if (hasU16FolderID()) {
         clear_has_u16FolderID();
        _u16FolderID = 0u;
     }
}

inline bool T_usb_tcu_Folder_definition_information::hasU16FolderID () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 T_usb_tcu_Folder_definition_information::getU16FolderID () const {
    return _u16FolderID;
}

inline void T_usb_tcu_Folder_definition_information::setU16FolderID (uint16 u16FolderID_) {
    set_has_u16FolderID();
    this->_u16FolderID = u16FolderID_;
}

inline void T_usb_tcu_Folder_definition_information::clearU16SizeOfFolderDefInfo() {
    if (hasU16SizeOfFolderDefInfo()) {
         clear_has_u16SizeOfFolderDefInfo();
        _u16SizeOfFolderDefInfo = 0u;
     }
}

inline bool T_usb_tcu_Folder_definition_information::hasU16SizeOfFolderDefInfo () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 T_usb_tcu_Folder_definition_information::getU16SizeOfFolderDefInfo () const {
    return _u16SizeOfFolderDefInfo;
}

inline void T_usb_tcu_Folder_definition_information::setU16SizeOfFolderDefInfo (uint16 u16SizeOfFolderDefInfo_) {
    set_has_u16SizeOfFolderDefInfo();
    this->_u16SizeOfFolderDefInfo = u16SizeOfFolderDefInfo_;
}

inline void T_usb_tcu_Folder_definition_information::clearU8FixedData1() {
    if (hasU8FixedData1()) {
         clear_has_u8FixedData1();
        _u8FixedData1 = 0u;
     }
}

inline bool T_usb_tcu_Folder_definition_information::hasU8FixedData1 () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 T_usb_tcu_Folder_definition_information::getU8FixedData1 () const {
    return _u8FixedData1;
}

inline void T_usb_tcu_Folder_definition_information::setU8FixedData1 (uint8 u8FixedData1_) {
    set_has_u8FixedData1();
    this->_u8FixedData1 = u8FixedData1_;
}

inline void T_usb_tcu_Folder_definition_information::clearU8FixedData2() {
    if (hasU8FixedData2()) {
         clear_has_u8FixedData2();
        _u8FixedData2 = 0u;
     }
}

inline bool T_usb_tcu_Folder_definition_information::hasU8FixedData2 () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint8 T_usb_tcu_Folder_definition_information::getU8FixedData2 () const {
    return _u8FixedData2;
}

inline void T_usb_tcu_Folder_definition_information::setU8FixedData2 (uint8 u8FixedData2_) {
    set_has_u8FixedData2();
    this->_u8FixedData2 = u8FixedData2_;
}

inline void T_usb_tcu_Folder_definition_information::clearU8SizeOfFolderName() {
    if (hasU8SizeOfFolderName()) {
         clear_has_u8SizeOfFolderName();
        _u8SizeOfFolderName = 0u;
     }
}

inline bool T_usb_tcu_Folder_definition_information::hasU8SizeOfFolderName () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint8 T_usb_tcu_Folder_definition_information::getU8SizeOfFolderName () const {
    return _u8SizeOfFolderName;
}

inline void T_usb_tcu_Folder_definition_information::setU8SizeOfFolderName (uint8 u8SizeOfFolderName_) {
    set_has_u8SizeOfFolderName();
    this->_u8SizeOfFolderName = u8SizeOfFolderName_;
}

inline void T_usb_tcu_Folder_definition_information::set_has_strFolderName () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_usb_tcu_Folder_definition_information::clear_has_strFolderName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_usb_tcu_Folder_definition_information::set_has_u16FolderIconID () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_usb_tcu_Folder_definition_information::clear_has_u16FolderIconID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_usb_tcu_Folder_definition_information::set_has_u16FolderID () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_usb_tcu_Folder_definition_information::clear_has_u16FolderID () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_usb_tcu_Folder_definition_information::set_has_u16SizeOfFolderDefInfo () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_usb_tcu_Folder_definition_information::clear_has_u16SizeOfFolderDefInfo () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_usb_tcu_Folder_definition_information::set_has_u8FixedData1 () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_usb_tcu_Folder_definition_information::clear_has_u8FixedData1 () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_usb_tcu_Folder_definition_information::set_has_u8FixedData2 () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_usb_tcu_Folder_definition_information::clear_has_u8FixedData2 () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_usb_tcu_Folder_definition_information::set_has_u8SizeOfFolderName () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_usb_tcu_Folder_definition_information::clear_has_u8SizeOfFolderName () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline  T_usb_tcu_channel_master_data::T_usb_tcu_channel_master_data ()  :
    _ChannelMasterDataHeader (),
    _ChannelDefinitionInformation (),
    _FolderDefinitionInformation ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_usb_tcu_channel_master_data::T_usb_tcu_channel_master_data (const T_usb_tcu_channel_master_data &rhs)  :
    _ChannelMasterDataHeader (),
    _ChannelDefinitionInformation (),
    _FolderDefinitionInformation ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_usb_tcu_channel_master_data::T_usb_tcu_channel_master_data (const T_usb_tcu_channel_master_data_header& ChannelMasterDataHeader_, const ::std::vector< T_usb_tcu_Channel_definition_information >& ChannelDefinitionInformation_, const ::std::vector< T_usb_tcu_Folder_definition_information >& FolderDefinitionInformation_)  :
    _ChannelMasterDataHeader (ChannelMasterDataHeader_),
    _ChannelDefinitionInformation (ChannelDefinitionInformation_),
    _FolderDefinitionInformation (FolderDefinitionInformation_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_usb_tcu_channel_master_data::~T_usb_tcu_channel_master_data() {
}

inline T_usb_tcu_channel_master_data& T_usb_tcu_channel_master_data::operator = (const T_usb_tcu_channel_master_data& rhs) {
    if( this != &rhs ) {
        if (rhs.hasChannelMasterDataHeader()) {
            setChannelMasterDataHeader(rhs.getChannelMasterDataHeader());
        } else {
            clearChannelMasterDataHeader();
        }
        if (rhs.hasChannelDefinitionInformation()) {
            setChannelDefinitionInformation(rhs.getChannelDefinitionInformation());
        } else {
            clearChannelDefinitionInformation();
        }
        if (rhs.hasFolderDefinitionInformation()) {
            setFolderDefinitionInformation(rhs.getFolderDefinitionInformation());
        } else {
            clearFolderDefinitionInformation();
        }
    }
    return *this;
}

inline bool T_usb_tcu_channel_master_data::operator == (const T_usb_tcu_channel_master_data& rhs) const {
    return (((!hasChannelMasterDataHeader() && !rhs.hasChannelMasterDataHeader()) || getChannelMasterDataHeader() == rhs.getChannelMasterDataHeader()) &&
        ((!hasChannelDefinitionInformation() && !rhs.hasChannelDefinitionInformation()) || getChannelDefinitionInformation() == rhs.getChannelDefinitionInformation()) &&
        ((!hasFolderDefinitionInformation() && !rhs.hasFolderDefinitionInformation()) || getFolderDefinitionInformation() == rhs.getFolderDefinitionInformation()));
}

inline bool T_usb_tcu_channel_master_data::operator != (const T_usb_tcu_channel_master_data& rhs) const {
    return ! (*this == rhs);
}

inline bool T_usb_tcu_channel_master_data::operator < (const T_usb_tcu_channel_master_data& rhs) const {
    if (hasChannelMasterDataHeader() || rhs.hasChannelMasterDataHeader()) {
        if (getChannelMasterDataHeader() < rhs.getChannelMasterDataHeader()) return true;
        if (getChannelMasterDataHeader() > rhs.getChannelMasterDataHeader()) return false;
    }
    if (hasChannelDefinitionInformation() || rhs.hasChannelDefinitionInformation()) {
        if (getChannelDefinitionInformation() < rhs.getChannelDefinitionInformation()) return true;
        if (getChannelDefinitionInformation() > rhs.getChannelDefinitionInformation()) return false;
    }
    if (hasFolderDefinitionInformation() || rhs.hasFolderDefinitionInformation()) {
        if (getFolderDefinitionInformation() < rhs.getFolderDefinitionInformation()) return true;
        if (getFolderDefinitionInformation() > rhs.getFolderDefinitionInformation()) return false;
    }
    return false;
}

inline bool T_usb_tcu_channel_master_data::operator > (const T_usb_tcu_channel_master_data& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_usb_tcu_channel_master_data::clear() {
    clearChannelMasterDataHeader();
    clearChannelDefinitionInformation();
    clearFolderDefinitionInformation();
}

inline void T_usb_tcu_channel_master_data::clearChannelMasterDataHeader() {
    if (hasChannelMasterDataHeader()) {
         clear_has_ChannelMasterDataHeader();
        _ChannelMasterDataHeader.clear();
     }
}

inline bool T_usb_tcu_channel_master_data::hasChannelMasterDataHeader () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const T_usb_tcu_channel_master_data_header& T_usb_tcu_channel_master_data::getChannelMasterDataHeader () const {
    return _ChannelMasterDataHeader;
}

inline T_usb_tcu_channel_master_data_header& T_usb_tcu_channel_master_data::getChannelMasterDataHeaderMutable () {
    set_has_ChannelMasterDataHeader();
    return _ChannelMasterDataHeader;
}

inline void T_usb_tcu_channel_master_data::setChannelMasterDataHeader (const T_usb_tcu_channel_master_data_header& ChannelMasterDataHeader_) {
    set_has_ChannelMasterDataHeader();
    this->_ChannelMasterDataHeader = ChannelMasterDataHeader_;
}

inline void T_usb_tcu_channel_master_data::clearChannelDefinitionInformation() {
    if (hasChannelDefinitionInformation()) {
         clear_has_ChannelDefinitionInformation();
        _ChannelDefinitionInformation.clear();
     }
}

inline bool T_usb_tcu_channel_master_data::hasChannelDefinitionInformation () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< T_usb_tcu_Channel_definition_information >& T_usb_tcu_channel_master_data::getChannelDefinitionInformation () const {
    return _ChannelDefinitionInformation;
}

inline ::std::vector< T_usb_tcu_Channel_definition_information >& T_usb_tcu_channel_master_data::getChannelDefinitionInformationMutable () {
    set_has_ChannelDefinitionInformation();
    return _ChannelDefinitionInformation;
}

inline void T_usb_tcu_channel_master_data::setChannelDefinitionInformation (const ::std::vector< T_usb_tcu_Channel_definition_information >& ChannelDefinitionInformation_) {
    set_has_ChannelDefinitionInformation();
    this->_ChannelDefinitionInformation = ChannelDefinitionInformation_;
}

inline void T_usb_tcu_channel_master_data::clearFolderDefinitionInformation() {
    if (hasFolderDefinitionInformation()) {
         clear_has_FolderDefinitionInformation();
        _FolderDefinitionInformation.clear();
     }
}

inline bool T_usb_tcu_channel_master_data::hasFolderDefinitionInformation () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::vector< T_usb_tcu_Folder_definition_information >& T_usb_tcu_channel_master_data::getFolderDefinitionInformation () const {
    return _FolderDefinitionInformation;
}

inline ::std::vector< T_usb_tcu_Folder_definition_information >& T_usb_tcu_channel_master_data::getFolderDefinitionInformationMutable () {
    set_has_FolderDefinitionInformation();
    return _FolderDefinitionInformation;
}

inline void T_usb_tcu_channel_master_data::setFolderDefinitionInformation (const ::std::vector< T_usb_tcu_Folder_definition_information >& FolderDefinitionInformation_) {
    set_has_FolderDefinitionInformation();
    this->_FolderDefinitionInformation = FolderDefinitionInformation_;
}

inline void T_usb_tcu_channel_master_data::set_has_ChannelMasterDataHeader () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_usb_tcu_channel_master_data::clear_has_ChannelMasterDataHeader () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_usb_tcu_channel_master_data::set_has_ChannelDefinitionInformation () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_usb_tcu_channel_master_data::clear_has_ChannelDefinitionInformation () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_usb_tcu_channel_master_data::set_has_FolderDefinitionInformation () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_usb_tcu_channel_master_data::clear_has_FolderDefinitionInformation () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_usb_tcu_Location::T_usb_tcu_Location ()  :
    _u16Latitude_second (0u),
    _u16Longitude_second (0u),
    _u8Direction (0u),
    _u8Latitude_degree (0u),
    _u8Latitude_minute (0u),
    _u8Longitude_Degree (0u),
    _u8Longitude_minute (0u),
    _u8Reserved (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_usb_tcu_Location::T_usb_tcu_Location (const T_usb_tcu_Location &rhs)  :
    _u16Latitude_second (0u),
    _u16Longitude_second (0u),
    _u8Direction (0u),
    _u8Latitude_degree (0u),
    _u8Latitude_minute (0u),
    _u8Longitude_Degree (0u),
    _u8Longitude_minute (0u),
    _u8Reserved (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_usb_tcu_Location::T_usb_tcu_Location (uint16 u16Latitude_second_, uint16 u16Longitude_second_, uint8 u8Direction_, uint8 u8Latitude_degree_, uint8 u8Latitude_minute_, uint8 u8Longitude_Degree_, uint8 u8Longitude_minute_, uint8 u8Reserved_)  :
    _u16Latitude_second (u16Latitude_second_),
    _u16Longitude_second (u16Longitude_second_),
    _u8Direction (u8Direction_),
    _u8Latitude_degree (u8Latitude_degree_),
    _u8Latitude_minute (u8Latitude_minute_),
    _u8Longitude_Degree (u8Longitude_Degree_),
    _u8Longitude_minute (u8Longitude_minute_),
    _u8Reserved (u8Reserved_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_usb_tcu_Location::~T_usb_tcu_Location() {
}

inline T_usb_tcu_Location& T_usb_tcu_Location::operator = (const T_usb_tcu_Location& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU16Latitude_second()) {
            setU16Latitude_second(rhs.getU16Latitude_second());
        } else {
            clearU16Latitude_second();
        }
        if (rhs.hasU16Longitude_second()) {
            setU16Longitude_second(rhs.getU16Longitude_second());
        } else {
            clearU16Longitude_second();
        }
        if (rhs.hasU8Direction()) {
            setU8Direction(rhs.getU8Direction());
        } else {
            clearU8Direction();
        }
        if (rhs.hasU8Latitude_degree()) {
            setU8Latitude_degree(rhs.getU8Latitude_degree());
        } else {
            clearU8Latitude_degree();
        }
        if (rhs.hasU8Latitude_minute()) {
            setU8Latitude_minute(rhs.getU8Latitude_minute());
        } else {
            clearU8Latitude_minute();
        }
        if (rhs.hasU8Longitude_Degree()) {
            setU8Longitude_Degree(rhs.getU8Longitude_Degree());
        } else {
            clearU8Longitude_Degree();
        }
        if (rhs.hasU8Longitude_minute()) {
            setU8Longitude_minute(rhs.getU8Longitude_minute());
        } else {
            clearU8Longitude_minute();
        }
        if (rhs.hasU8Reserved()) {
            setU8Reserved(rhs.getU8Reserved());
        } else {
            clearU8Reserved();
        }
    }
    return *this;
}

inline bool T_usb_tcu_Location::operator == (const T_usb_tcu_Location& rhs) const {
    return (((!hasU16Latitude_second() && !rhs.hasU16Latitude_second()) || getU16Latitude_second() == rhs.getU16Latitude_second()) &&
        ((!hasU16Longitude_second() && !rhs.hasU16Longitude_second()) || getU16Longitude_second() == rhs.getU16Longitude_second()) &&
        ((!hasU8Direction() && !rhs.hasU8Direction()) || getU8Direction() == rhs.getU8Direction()) &&
        ((!hasU8Latitude_degree() && !rhs.hasU8Latitude_degree()) || getU8Latitude_degree() == rhs.getU8Latitude_degree()) &&
        ((!hasU8Latitude_minute() && !rhs.hasU8Latitude_minute()) || getU8Latitude_minute() == rhs.getU8Latitude_minute()) &&
        ((!hasU8Longitude_Degree() && !rhs.hasU8Longitude_Degree()) || getU8Longitude_Degree() == rhs.getU8Longitude_Degree()) &&
        ((!hasU8Longitude_minute() && !rhs.hasU8Longitude_minute()) || getU8Longitude_minute() == rhs.getU8Longitude_minute()) &&
        ((!hasU8Reserved() && !rhs.hasU8Reserved()) || getU8Reserved() == rhs.getU8Reserved()));
}

inline bool T_usb_tcu_Location::operator != (const T_usb_tcu_Location& rhs) const {
    return ! (*this == rhs);
}

inline bool T_usb_tcu_Location::operator < (const T_usb_tcu_Location& rhs) const {
    if (hasU16Latitude_second() || rhs.hasU16Latitude_second()) {
        if (getU16Latitude_second() < rhs.getU16Latitude_second()) return true;
        if (getU16Latitude_second() > rhs.getU16Latitude_second()) return false;
    }
    if (hasU16Longitude_second() || rhs.hasU16Longitude_second()) {
        if (getU16Longitude_second() < rhs.getU16Longitude_second()) return true;
        if (getU16Longitude_second() > rhs.getU16Longitude_second()) return false;
    }
    if (hasU8Direction() || rhs.hasU8Direction()) {
        if (getU8Direction() < rhs.getU8Direction()) return true;
        if (getU8Direction() > rhs.getU8Direction()) return false;
    }
    if (hasU8Latitude_degree() || rhs.hasU8Latitude_degree()) {
        if (getU8Latitude_degree() < rhs.getU8Latitude_degree()) return true;
        if (getU8Latitude_degree() > rhs.getU8Latitude_degree()) return false;
    }
    if (hasU8Latitude_minute() || rhs.hasU8Latitude_minute()) {
        if (getU8Latitude_minute() < rhs.getU8Latitude_minute()) return true;
        if (getU8Latitude_minute() > rhs.getU8Latitude_minute()) return false;
    }
    if (hasU8Longitude_Degree() || rhs.hasU8Longitude_Degree()) {
        if (getU8Longitude_Degree() < rhs.getU8Longitude_Degree()) return true;
        if (getU8Longitude_Degree() > rhs.getU8Longitude_Degree()) return false;
    }
    if (hasU8Longitude_minute() || rhs.hasU8Longitude_minute()) {
        if (getU8Longitude_minute() < rhs.getU8Longitude_minute()) return true;
        if (getU8Longitude_minute() > rhs.getU8Longitude_minute()) return false;
    }
    if (hasU8Reserved() || rhs.hasU8Reserved()) {
        if (getU8Reserved() < rhs.getU8Reserved()) return true;
        if (getU8Reserved() > rhs.getU8Reserved()) return false;
    }
    return false;
}

inline bool T_usb_tcu_Location::operator > (const T_usb_tcu_Location& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_usb_tcu_Location::clear() {
    clearU16Latitude_second();
    clearU16Longitude_second();
    clearU8Direction();
    clearU8Latitude_degree();
    clearU8Latitude_minute();
    clearU8Longitude_Degree();
    clearU8Longitude_minute();
    clearU8Reserved();
}

inline void T_usb_tcu_Location::clearU16Latitude_second() {
    if (hasU16Latitude_second()) {
         clear_has_u16Latitude_second();
        _u16Latitude_second = 0u;
     }
}

inline bool T_usb_tcu_Location::hasU16Latitude_second () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 T_usb_tcu_Location::getU16Latitude_second () const {
    return _u16Latitude_second;
}

inline void T_usb_tcu_Location::setU16Latitude_second (uint16 u16Latitude_second_) {
    set_has_u16Latitude_second();
    this->_u16Latitude_second = u16Latitude_second_;
}

inline void T_usb_tcu_Location::clearU16Longitude_second() {
    if (hasU16Longitude_second()) {
         clear_has_u16Longitude_second();
        _u16Longitude_second = 0u;
     }
}

inline bool T_usb_tcu_Location::hasU16Longitude_second () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 T_usb_tcu_Location::getU16Longitude_second () const {
    return _u16Longitude_second;
}

inline void T_usb_tcu_Location::setU16Longitude_second (uint16 u16Longitude_second_) {
    set_has_u16Longitude_second();
    this->_u16Longitude_second = u16Longitude_second_;
}

inline void T_usb_tcu_Location::clearU8Direction() {
    if (hasU8Direction()) {
         clear_has_u8Direction();
        _u8Direction = 0u;
     }
}

inline bool T_usb_tcu_Location::hasU8Direction () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 T_usb_tcu_Location::getU8Direction () const {
    return _u8Direction;
}

inline void T_usb_tcu_Location::setU8Direction (uint8 u8Direction_) {
    set_has_u8Direction();
    this->_u8Direction = u8Direction_;
}

inline void T_usb_tcu_Location::clearU8Latitude_degree() {
    if (hasU8Latitude_degree()) {
         clear_has_u8Latitude_degree();
        _u8Latitude_degree = 0u;
     }
}

inline bool T_usb_tcu_Location::hasU8Latitude_degree () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 T_usb_tcu_Location::getU8Latitude_degree () const {
    return _u8Latitude_degree;
}

inline void T_usb_tcu_Location::setU8Latitude_degree (uint8 u8Latitude_degree_) {
    set_has_u8Latitude_degree();
    this->_u8Latitude_degree = u8Latitude_degree_;
}

inline void T_usb_tcu_Location::clearU8Latitude_minute() {
    if (hasU8Latitude_minute()) {
         clear_has_u8Latitude_minute();
        _u8Latitude_minute = 0u;
     }
}

inline bool T_usb_tcu_Location::hasU8Latitude_minute () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 T_usb_tcu_Location::getU8Latitude_minute () const {
    return _u8Latitude_minute;
}

inline void T_usb_tcu_Location::setU8Latitude_minute (uint8 u8Latitude_minute_) {
    set_has_u8Latitude_minute();
    this->_u8Latitude_minute = u8Latitude_minute_;
}

inline void T_usb_tcu_Location::clearU8Longitude_Degree() {
    if (hasU8Longitude_Degree()) {
         clear_has_u8Longitude_Degree();
        _u8Longitude_Degree = 0u;
     }
}

inline bool T_usb_tcu_Location::hasU8Longitude_Degree () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint8 T_usb_tcu_Location::getU8Longitude_Degree () const {
    return _u8Longitude_Degree;
}

inline void T_usb_tcu_Location::setU8Longitude_Degree (uint8 u8Longitude_Degree_) {
    set_has_u8Longitude_Degree();
    this->_u8Longitude_Degree = u8Longitude_Degree_;
}

inline void T_usb_tcu_Location::clearU8Longitude_minute() {
    if (hasU8Longitude_minute()) {
         clear_has_u8Longitude_minute();
        _u8Longitude_minute = 0u;
     }
}

inline bool T_usb_tcu_Location::hasU8Longitude_minute () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint8 T_usb_tcu_Location::getU8Longitude_minute () const {
    return _u8Longitude_minute;
}

inline void T_usb_tcu_Location::setU8Longitude_minute (uint8 u8Longitude_minute_) {
    set_has_u8Longitude_minute();
    this->_u8Longitude_minute = u8Longitude_minute_;
}

inline void T_usb_tcu_Location::clearU8Reserved() {
    if (hasU8Reserved()) {
         clear_has_u8Reserved();
        _u8Reserved = 0u;
     }
}

inline bool T_usb_tcu_Location::hasU8Reserved () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline uint8 T_usb_tcu_Location::getU8Reserved () const {
    return _u8Reserved;
}

inline void T_usb_tcu_Location::setU8Reserved (uint8 u8Reserved_) {
    set_has_u8Reserved();
    this->_u8Reserved = u8Reserved_;
}

inline void T_usb_tcu_Location::set_has_u16Latitude_second () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_usb_tcu_Location::clear_has_u16Latitude_second () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_usb_tcu_Location::set_has_u16Longitude_second () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_usb_tcu_Location::clear_has_u16Longitude_second () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_usb_tcu_Location::set_has_u8Direction () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_usb_tcu_Location::clear_has_u8Direction () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_usb_tcu_Location::set_has_u8Latitude_degree () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_usb_tcu_Location::clear_has_u8Latitude_degree () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_usb_tcu_Location::set_has_u8Latitude_minute () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_usb_tcu_Location::clear_has_u8Latitude_minute () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_usb_tcu_Location::set_has_u8Longitude_Degree () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_usb_tcu_Location::clear_has_u8Longitude_Degree () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_usb_tcu_Location::set_has_u8Longitude_minute () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_usb_tcu_Location::clear_has_u8Longitude_minute () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_usb_tcu_Location::set_has_u8Reserved () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_usb_tcu_Location::clear_has_u8Reserved () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline  T_usb_tcu_Data_Record::T_usb_tcu_Data_Record ()  :
    _Location (),
    _strAddress (),
    _strCategory (),
    _strPhoneNumber (),
    _strPhoneNumberForDisp (),
    _strPOIName (),
    _u8SizeOfAddress (0u),
    _u8SizeOfCategory (0u),
    _u8SizeOfPhoneNumber (0u),
    _u8SizeOfPhoneNumberForDisp (0u),
    _u8SizeOfPOIName (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_usb_tcu_Data_Record::T_usb_tcu_Data_Record (const T_usb_tcu_Data_Record &rhs)  :
    _Location (),
    _strAddress (),
    _strCategory (),
    _strPhoneNumber (),
    _strPhoneNumberForDisp (),
    _strPOIName (),
    _u8SizeOfAddress (0u),
    _u8SizeOfCategory (0u),
    _u8SizeOfPhoneNumber (0u),
    _u8SizeOfPhoneNumberForDisp (0u),
    _u8SizeOfPOIName (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_usb_tcu_Data_Record::T_usb_tcu_Data_Record (const T_usb_tcu_Location& Location_, const ::std::string& strAddress_, const ::std::string& strCategory_, const ::std::string& strPhoneNumber_, const ::std::string& strPhoneNumberForDisp_, const ::std::string& strPOIName_, uint8 u8SizeOfAddress_, uint8 u8SizeOfCategory_, uint8 u8SizeOfPhoneNumber_, uint8 u8SizeOfPhoneNumberForDisp_, uint8 u8SizeOfPOIName_)  :
    _Location (Location_),
    _strAddress (strAddress_),
    _strCategory (strCategory_),
    _strPhoneNumber (strPhoneNumber_),
    _strPhoneNumberForDisp (strPhoneNumberForDisp_),
    _strPOIName (strPOIName_),
    _u8SizeOfAddress (u8SizeOfAddress_),
    _u8SizeOfCategory (u8SizeOfCategory_),
    _u8SizeOfPhoneNumber (u8SizeOfPhoneNumber_),
    _u8SizeOfPhoneNumberForDisp (u8SizeOfPhoneNumberForDisp_),
    _u8SizeOfPOIName (u8SizeOfPOIName_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strCategory_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strPhoneNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strPhoneNumberForDisp_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strPOIName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_usb_tcu_Data_Record::~T_usb_tcu_Data_Record() {
}

inline T_usb_tcu_Data_Record& T_usb_tcu_Data_Record::operator = (const T_usb_tcu_Data_Record& rhs) {
    if( this != &rhs ) {
        if (rhs.hasLocation()) {
            setLocation(rhs.getLocation());
        } else {
            clearLocation();
        }
        if (rhs.hasStrAddress()) {
            setStrAddress(rhs.getStrAddress());
        } else {
            clearStrAddress();
        }
        if (rhs.hasStrCategory()) {
            setStrCategory(rhs.getStrCategory());
        } else {
            clearStrCategory();
        }
        if (rhs.hasStrPhoneNumber()) {
            setStrPhoneNumber(rhs.getStrPhoneNumber());
        } else {
            clearStrPhoneNumber();
        }
        if (rhs.hasStrPhoneNumberForDisp()) {
            setStrPhoneNumberForDisp(rhs.getStrPhoneNumberForDisp());
        } else {
            clearStrPhoneNumberForDisp();
        }
        if (rhs.hasStrPOIName()) {
            setStrPOIName(rhs.getStrPOIName());
        } else {
            clearStrPOIName();
        }
        if (rhs.hasU8SizeOfAddress()) {
            setU8SizeOfAddress(rhs.getU8SizeOfAddress());
        } else {
            clearU8SizeOfAddress();
        }
        if (rhs.hasU8SizeOfCategory()) {
            setU8SizeOfCategory(rhs.getU8SizeOfCategory());
        } else {
            clearU8SizeOfCategory();
        }
        if (rhs.hasU8SizeOfPhoneNumber()) {
            setU8SizeOfPhoneNumber(rhs.getU8SizeOfPhoneNumber());
        } else {
            clearU8SizeOfPhoneNumber();
        }
        if (rhs.hasU8SizeOfPhoneNumberForDisp()) {
            setU8SizeOfPhoneNumberForDisp(rhs.getU8SizeOfPhoneNumberForDisp());
        } else {
            clearU8SizeOfPhoneNumberForDisp();
        }
        if (rhs.hasU8SizeOfPOIName()) {
            setU8SizeOfPOIName(rhs.getU8SizeOfPOIName());
        } else {
            clearU8SizeOfPOIName();
        }
    }
    return *this;
}

inline bool T_usb_tcu_Data_Record::operator == (const T_usb_tcu_Data_Record& rhs) const {
    return (((!hasLocation() && !rhs.hasLocation()) || getLocation() == rhs.getLocation()) &&
        ((!hasStrAddress() && !rhs.hasStrAddress()) || getStrAddress() == rhs.getStrAddress()) &&
        ((!hasStrCategory() && !rhs.hasStrCategory()) || getStrCategory() == rhs.getStrCategory()) &&
        ((!hasStrPhoneNumber() && !rhs.hasStrPhoneNumber()) || getStrPhoneNumber() == rhs.getStrPhoneNumber()) &&
        ((!hasStrPhoneNumberForDisp() && !rhs.hasStrPhoneNumberForDisp()) || getStrPhoneNumberForDisp() == rhs.getStrPhoneNumberForDisp()) &&
        ((!hasStrPOIName() && !rhs.hasStrPOIName()) || getStrPOIName() == rhs.getStrPOIName()) &&
        ((!hasU8SizeOfAddress() && !rhs.hasU8SizeOfAddress()) || getU8SizeOfAddress() == rhs.getU8SizeOfAddress()) &&
        ((!hasU8SizeOfCategory() && !rhs.hasU8SizeOfCategory()) || getU8SizeOfCategory() == rhs.getU8SizeOfCategory()) &&
        ((!hasU8SizeOfPhoneNumber() && !rhs.hasU8SizeOfPhoneNumber()) || getU8SizeOfPhoneNumber() == rhs.getU8SizeOfPhoneNumber()) &&
        ((!hasU8SizeOfPhoneNumberForDisp() && !rhs.hasU8SizeOfPhoneNumberForDisp()) || getU8SizeOfPhoneNumberForDisp() == rhs.getU8SizeOfPhoneNumberForDisp()) &&
        ((!hasU8SizeOfPOIName() && !rhs.hasU8SizeOfPOIName()) || getU8SizeOfPOIName() == rhs.getU8SizeOfPOIName()));
}

inline bool T_usb_tcu_Data_Record::operator != (const T_usb_tcu_Data_Record& rhs) const {
    return ! (*this == rhs);
}

inline bool T_usb_tcu_Data_Record::operator < (const T_usb_tcu_Data_Record& rhs) const {
    if (hasLocation() || rhs.hasLocation()) {
        if (getLocation() < rhs.getLocation()) return true;
        if (getLocation() > rhs.getLocation()) return false;
    }
    if (hasStrAddress() || rhs.hasStrAddress()) {
        if (getStrAddress() < rhs.getStrAddress()) return true;
        if (getStrAddress() > rhs.getStrAddress()) return false;
    }
    if (hasStrCategory() || rhs.hasStrCategory()) {
        if (getStrCategory() < rhs.getStrCategory()) return true;
        if (getStrCategory() > rhs.getStrCategory()) return false;
    }
    if (hasStrPhoneNumber() || rhs.hasStrPhoneNumber()) {
        if (getStrPhoneNumber() < rhs.getStrPhoneNumber()) return true;
        if (getStrPhoneNumber() > rhs.getStrPhoneNumber()) return false;
    }
    if (hasStrPhoneNumberForDisp() || rhs.hasStrPhoneNumberForDisp()) {
        if (getStrPhoneNumberForDisp() < rhs.getStrPhoneNumberForDisp()) return true;
        if (getStrPhoneNumberForDisp() > rhs.getStrPhoneNumberForDisp()) return false;
    }
    if (hasStrPOIName() || rhs.hasStrPOIName()) {
        if (getStrPOIName() < rhs.getStrPOIName()) return true;
        if (getStrPOIName() > rhs.getStrPOIName()) return false;
    }
    if (hasU8SizeOfAddress() || rhs.hasU8SizeOfAddress()) {
        if (getU8SizeOfAddress() < rhs.getU8SizeOfAddress()) return true;
        if (getU8SizeOfAddress() > rhs.getU8SizeOfAddress()) return false;
    }
    if (hasU8SizeOfCategory() || rhs.hasU8SizeOfCategory()) {
        if (getU8SizeOfCategory() < rhs.getU8SizeOfCategory()) return true;
        if (getU8SizeOfCategory() > rhs.getU8SizeOfCategory()) return false;
    }
    if (hasU8SizeOfPhoneNumber() || rhs.hasU8SizeOfPhoneNumber()) {
        if (getU8SizeOfPhoneNumber() < rhs.getU8SizeOfPhoneNumber()) return true;
        if (getU8SizeOfPhoneNumber() > rhs.getU8SizeOfPhoneNumber()) return false;
    }
    if (hasU8SizeOfPhoneNumberForDisp() || rhs.hasU8SizeOfPhoneNumberForDisp()) {
        if (getU8SizeOfPhoneNumberForDisp() < rhs.getU8SizeOfPhoneNumberForDisp()) return true;
        if (getU8SizeOfPhoneNumberForDisp() > rhs.getU8SizeOfPhoneNumberForDisp()) return false;
    }
    if (hasU8SizeOfPOIName() || rhs.hasU8SizeOfPOIName()) {
        if (getU8SizeOfPOIName() < rhs.getU8SizeOfPOIName()) return true;
        if (getU8SizeOfPOIName() > rhs.getU8SizeOfPOIName()) return false;
    }
    return false;
}

inline bool T_usb_tcu_Data_Record::operator > (const T_usb_tcu_Data_Record& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_usb_tcu_Data_Record::clear() {
    clearLocation();
    clearStrAddress();
    clearStrCategory();
    clearStrPhoneNumber();
    clearStrPhoneNumberForDisp();
    clearStrPOIName();
    clearU8SizeOfAddress();
    clearU8SizeOfCategory();
    clearU8SizeOfPhoneNumber();
    clearU8SizeOfPhoneNumberForDisp();
    clearU8SizeOfPOIName();
}

inline void T_usb_tcu_Data_Record::clearLocation() {
    if (hasLocation()) {
         clear_has_Location();
        _Location.clear();
     }
}

inline bool T_usb_tcu_Data_Record::hasLocation () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const T_usb_tcu_Location& T_usb_tcu_Data_Record::getLocation () const {
    return _Location;
}

inline T_usb_tcu_Location& T_usb_tcu_Data_Record::getLocationMutable () {
    set_has_Location();
    return _Location;
}

inline void T_usb_tcu_Data_Record::setLocation (const T_usb_tcu_Location& Location_) {
    set_has_Location();
    this->_Location = Location_;
}

inline void T_usb_tcu_Data_Record::clearStrAddress() {
    if (hasStrAddress()) {
         clear_has_strAddress();
        _strAddress.clear();
     }
}

inline bool T_usb_tcu_Data_Record::hasStrAddress () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_usb_tcu_Data_Record::getStrAddress () const {
    return _strAddress;
}

inline ::std::string& T_usb_tcu_Data_Record::getStrAddressMutable () {
    set_has_strAddress();
    return _strAddress;
}

inline void T_usb_tcu_Data_Record::setStrAddress (const ::std::string& strAddress_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strAddress();
    this->_strAddress = strAddress_;
}

inline void T_usb_tcu_Data_Record::setStrAddress (const char* strAddress_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strAddress();
    this->_strAddress.assign(strAddress_);
}

inline void T_usb_tcu_Data_Record::setStrAddress (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strAddress();
    this->_strAddress.assign(value, size);
}

inline void T_usb_tcu_Data_Record::clearStrCategory() {
    if (hasStrCategory()) {
         clear_has_strCategory();
        _strCategory.clear();
     }
}

inline bool T_usb_tcu_Data_Record::hasStrCategory () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& T_usb_tcu_Data_Record::getStrCategory () const {
    return _strCategory;
}

inline ::std::string& T_usb_tcu_Data_Record::getStrCategoryMutable () {
    set_has_strCategory();
    return _strCategory;
}

inline void T_usb_tcu_Data_Record::setStrCategory (const ::std::string& strCategory_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strCategory_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strCategory();
    this->_strCategory = strCategory_;
}

inline void T_usb_tcu_Data_Record::setStrCategory (const char* strCategory_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strCategory_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strCategory();
    this->_strCategory.assign(strCategory_);
}

inline void T_usb_tcu_Data_Record::setStrCategory (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strCategory();
    this->_strCategory.assign(value, size);
}

inline void T_usb_tcu_Data_Record::clearStrPhoneNumber() {
    if (hasStrPhoneNumber()) {
         clear_has_strPhoneNumber();
        _strPhoneNumber.clear();
     }
}

inline bool T_usb_tcu_Data_Record::hasStrPhoneNumber () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& T_usb_tcu_Data_Record::getStrPhoneNumber () const {
    return _strPhoneNumber;
}

inline ::std::string& T_usb_tcu_Data_Record::getStrPhoneNumberMutable () {
    set_has_strPhoneNumber();
    return _strPhoneNumber;
}

inline void T_usb_tcu_Data_Record::setStrPhoneNumber (const ::std::string& strPhoneNumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strPhoneNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strPhoneNumber();
    this->_strPhoneNumber = strPhoneNumber_;
}

inline void T_usb_tcu_Data_Record::setStrPhoneNumber (const char* strPhoneNumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strPhoneNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strPhoneNumber();
    this->_strPhoneNumber.assign(strPhoneNumber_);
}

inline void T_usb_tcu_Data_Record::setStrPhoneNumber (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strPhoneNumber();
    this->_strPhoneNumber.assign(value, size);
}

inline void T_usb_tcu_Data_Record::clearStrPhoneNumberForDisp() {
    if (hasStrPhoneNumberForDisp()) {
         clear_has_strPhoneNumberForDisp();
        _strPhoneNumberForDisp.clear();
     }
}

inline bool T_usb_tcu_Data_Record::hasStrPhoneNumberForDisp () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& T_usb_tcu_Data_Record::getStrPhoneNumberForDisp () const {
    return _strPhoneNumberForDisp;
}

inline ::std::string& T_usb_tcu_Data_Record::getStrPhoneNumberForDispMutable () {
    set_has_strPhoneNumberForDisp();
    return _strPhoneNumberForDisp;
}

inline void T_usb_tcu_Data_Record::setStrPhoneNumberForDisp (const ::std::string& strPhoneNumberForDisp_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strPhoneNumberForDisp_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strPhoneNumberForDisp();
    this->_strPhoneNumberForDisp = strPhoneNumberForDisp_;
}

inline void T_usb_tcu_Data_Record::setStrPhoneNumberForDisp (const char* strPhoneNumberForDisp_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strPhoneNumberForDisp_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strPhoneNumberForDisp();
    this->_strPhoneNumberForDisp.assign(strPhoneNumberForDisp_);
}

inline void T_usb_tcu_Data_Record::setStrPhoneNumberForDisp (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strPhoneNumberForDisp();
    this->_strPhoneNumberForDisp.assign(value, size);
}

inline void T_usb_tcu_Data_Record::clearStrPOIName() {
    if (hasStrPOIName()) {
         clear_has_strPOIName();
        _strPOIName.clear();
     }
}

inline bool T_usb_tcu_Data_Record::hasStrPOIName () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::std::string& T_usb_tcu_Data_Record::getStrPOIName () const {
    return _strPOIName;
}

inline ::std::string& T_usb_tcu_Data_Record::getStrPOINameMutable () {
    set_has_strPOIName();
    return _strPOIName;
}

inline void T_usb_tcu_Data_Record::setStrPOIName (const ::std::string& strPOIName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strPOIName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strPOIName();
    this->_strPOIName = strPOIName_;
}

inline void T_usb_tcu_Data_Record::setStrPOIName (const char* strPOIName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strPOIName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strPOIName();
    this->_strPOIName.assign(strPOIName_);
}

inline void T_usb_tcu_Data_Record::setStrPOIName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strPOIName();
    this->_strPOIName.assign(value, size);
}

inline void T_usb_tcu_Data_Record::clearU8SizeOfAddress() {
    if (hasU8SizeOfAddress()) {
         clear_has_u8SizeOfAddress();
        _u8SizeOfAddress = 0u;
     }
}

inline bool T_usb_tcu_Data_Record::hasU8SizeOfAddress () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint8 T_usb_tcu_Data_Record::getU8SizeOfAddress () const {
    return _u8SizeOfAddress;
}

inline void T_usb_tcu_Data_Record::setU8SizeOfAddress (uint8 u8SizeOfAddress_) {
    set_has_u8SizeOfAddress();
    this->_u8SizeOfAddress = u8SizeOfAddress_;
}

inline void T_usb_tcu_Data_Record::clearU8SizeOfCategory() {
    if (hasU8SizeOfCategory()) {
         clear_has_u8SizeOfCategory();
        _u8SizeOfCategory = 0u;
     }
}

inline bool T_usb_tcu_Data_Record::hasU8SizeOfCategory () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline uint8 T_usb_tcu_Data_Record::getU8SizeOfCategory () const {
    return _u8SizeOfCategory;
}

inline void T_usb_tcu_Data_Record::setU8SizeOfCategory (uint8 u8SizeOfCategory_) {
    set_has_u8SizeOfCategory();
    this->_u8SizeOfCategory = u8SizeOfCategory_;
}

inline void T_usb_tcu_Data_Record::clearU8SizeOfPhoneNumber() {
    if (hasU8SizeOfPhoneNumber()) {
         clear_has_u8SizeOfPhoneNumber();
        _u8SizeOfPhoneNumber = 0u;
     }
}

inline bool T_usb_tcu_Data_Record::hasU8SizeOfPhoneNumber () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline uint8 T_usb_tcu_Data_Record::getU8SizeOfPhoneNumber () const {
    return _u8SizeOfPhoneNumber;
}

inline void T_usb_tcu_Data_Record::setU8SizeOfPhoneNumber (uint8 u8SizeOfPhoneNumber_) {
    set_has_u8SizeOfPhoneNumber();
    this->_u8SizeOfPhoneNumber = u8SizeOfPhoneNumber_;
}

inline void T_usb_tcu_Data_Record::clearU8SizeOfPhoneNumberForDisp() {
    if (hasU8SizeOfPhoneNumberForDisp()) {
         clear_has_u8SizeOfPhoneNumberForDisp();
        _u8SizeOfPhoneNumberForDisp = 0u;
     }
}

inline bool T_usb_tcu_Data_Record::hasU8SizeOfPhoneNumberForDisp () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline uint8 T_usb_tcu_Data_Record::getU8SizeOfPhoneNumberForDisp () const {
    return _u8SizeOfPhoneNumberForDisp;
}

inline void T_usb_tcu_Data_Record::setU8SizeOfPhoneNumberForDisp (uint8 u8SizeOfPhoneNumberForDisp_) {
    set_has_u8SizeOfPhoneNumberForDisp();
    this->_u8SizeOfPhoneNumberForDisp = u8SizeOfPhoneNumberForDisp_;
}

inline void T_usb_tcu_Data_Record::clearU8SizeOfPOIName() {
    if (hasU8SizeOfPOIName()) {
         clear_has_u8SizeOfPOIName();
        _u8SizeOfPOIName = 0u;
     }
}

inline bool T_usb_tcu_Data_Record::hasU8SizeOfPOIName () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline uint8 T_usb_tcu_Data_Record::getU8SizeOfPOIName () const {
    return _u8SizeOfPOIName;
}

inline void T_usb_tcu_Data_Record::setU8SizeOfPOIName (uint8 u8SizeOfPOIName_) {
    set_has_u8SizeOfPOIName();
    this->_u8SizeOfPOIName = u8SizeOfPOIName_;
}

inline void T_usb_tcu_Data_Record::set_has_Location () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_usb_tcu_Data_Record::clear_has_Location () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_usb_tcu_Data_Record::set_has_strAddress () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_usb_tcu_Data_Record::clear_has_strAddress () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_usb_tcu_Data_Record::set_has_strCategory () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_usb_tcu_Data_Record::clear_has_strCategory () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_usb_tcu_Data_Record::set_has_strPhoneNumber () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_usb_tcu_Data_Record::clear_has_strPhoneNumber () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_usb_tcu_Data_Record::set_has_strPhoneNumberForDisp () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_usb_tcu_Data_Record::clear_has_strPhoneNumberForDisp () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_usb_tcu_Data_Record::set_has_strPOIName () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_usb_tcu_Data_Record::clear_has_strPOIName () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_usb_tcu_Data_Record::set_has_u8SizeOfAddress () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_usb_tcu_Data_Record::clear_has_u8SizeOfAddress () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_usb_tcu_Data_Record::set_has_u8SizeOfCategory () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_usb_tcu_Data_Record::clear_has_u8SizeOfCategory () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_usb_tcu_Data_Record::set_has_u8SizeOfPhoneNumber () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_usb_tcu_Data_Record::clear_has_u8SizeOfPhoneNumber () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_usb_tcu_Data_Record::set_has_u8SizeOfPhoneNumberForDisp () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_usb_tcu_Data_Record::clear_has_u8SizeOfPhoneNumberForDisp () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_usb_tcu_Data_Record::set_has_u8SizeOfPOIName () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_usb_tcu_Data_Record::clear_has_u8SizeOfPOIName () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline  T_usb_tcu_connected_search_result::T_usb_tcu_connected_search_result ()  :
    _u8NumOfPOI (0u),
    _DataRecord ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_usb_tcu_connected_search_result::T_usb_tcu_connected_search_result (const T_usb_tcu_connected_search_result &rhs)  :
    _u8NumOfPOI (0u),
    _DataRecord ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_usb_tcu_connected_search_result::T_usb_tcu_connected_search_result (uint8 u8NumOfPOI_, const ::std::vector< T_usb_tcu_Data_Record >& DataRecord_)  :
    _u8NumOfPOI (u8NumOfPOI_),
    _DataRecord (DataRecord_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_usb_tcu_connected_search_result::~T_usb_tcu_connected_search_result() {
}

inline T_usb_tcu_connected_search_result& T_usb_tcu_connected_search_result::operator = (const T_usb_tcu_connected_search_result& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8NumOfPOI()) {
            setU8NumOfPOI(rhs.getU8NumOfPOI());
        } else {
            clearU8NumOfPOI();
        }
        if (rhs.hasDataRecord()) {
            setDataRecord(rhs.getDataRecord());
        } else {
            clearDataRecord();
        }
    }
    return *this;
}

inline bool T_usb_tcu_connected_search_result::operator == (const T_usb_tcu_connected_search_result& rhs) const {
    return (((!hasU8NumOfPOI() && !rhs.hasU8NumOfPOI()) || getU8NumOfPOI() == rhs.getU8NumOfPOI()) &&
        ((!hasDataRecord() && !rhs.hasDataRecord()) || getDataRecord() == rhs.getDataRecord()));
}

inline bool T_usb_tcu_connected_search_result::operator != (const T_usb_tcu_connected_search_result& rhs) const {
    return ! (*this == rhs);
}

inline bool T_usb_tcu_connected_search_result::operator < (const T_usb_tcu_connected_search_result& rhs) const {
    if (hasU8NumOfPOI() || rhs.hasU8NumOfPOI()) {
        if (getU8NumOfPOI() < rhs.getU8NumOfPOI()) return true;
        if (getU8NumOfPOI() > rhs.getU8NumOfPOI()) return false;
    }
    if (hasDataRecord() || rhs.hasDataRecord()) {
        if (getDataRecord() < rhs.getDataRecord()) return true;
        if (getDataRecord() > rhs.getDataRecord()) return false;
    }
    return false;
}

inline bool T_usb_tcu_connected_search_result::operator > (const T_usb_tcu_connected_search_result& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_usb_tcu_connected_search_result::clear() {
    clearU8NumOfPOI();
    clearDataRecord();
}

inline void T_usb_tcu_connected_search_result::clearU8NumOfPOI() {
    if (hasU8NumOfPOI()) {
         clear_has_u8NumOfPOI();
        _u8NumOfPOI = 0u;
     }
}

inline bool T_usb_tcu_connected_search_result::hasU8NumOfPOI () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_usb_tcu_connected_search_result::getU8NumOfPOI () const {
    return _u8NumOfPOI;
}

inline void T_usb_tcu_connected_search_result::setU8NumOfPOI (uint8 u8NumOfPOI_) {
    set_has_u8NumOfPOI();
    this->_u8NumOfPOI = u8NumOfPOI_;
}

inline void T_usb_tcu_connected_search_result::clearDataRecord() {
    if (hasDataRecord()) {
         clear_has_DataRecord();
        _DataRecord.clear();
     }
}

inline bool T_usb_tcu_connected_search_result::hasDataRecord () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< T_usb_tcu_Data_Record >& T_usb_tcu_connected_search_result::getDataRecord () const {
    return _DataRecord;
}

inline ::std::vector< T_usb_tcu_Data_Record >& T_usb_tcu_connected_search_result::getDataRecordMutable () {
    set_has_DataRecord();
    return _DataRecord;
}

inline void T_usb_tcu_connected_search_result::setDataRecord (const ::std::vector< T_usb_tcu_Data_Record >& DataRecord_) {
    set_has_DataRecord();
    this->_DataRecord = DataRecord_;
}

inline void T_usb_tcu_connected_search_result::set_has_u8NumOfPOI () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_usb_tcu_connected_search_result::clear_has_u8NumOfPOI () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_usb_tcu_connected_search_result::set_has_DataRecord () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_usb_tcu_connected_search_result::clear_has_DataRecord () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_usb_tcu_Data_Header_Part::T_usb_tcu_Data_Header_Part ()  :
    _u8NumOfPOI (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_usb_tcu_Data_Header_Part::T_usb_tcu_Data_Header_Part (const T_usb_tcu_Data_Header_Part &rhs)  :
    _u8NumOfPOI (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_usb_tcu_Data_Header_Part::T_usb_tcu_Data_Header_Part (uint8 u8NumOfPOI_)  :
    _u8NumOfPOI (u8NumOfPOI_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_usb_tcu_Data_Header_Part::~T_usb_tcu_Data_Header_Part() {
}

inline T_usb_tcu_Data_Header_Part& T_usb_tcu_Data_Header_Part::operator = (const T_usb_tcu_Data_Header_Part& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8NumOfPOI()) {
            setU8NumOfPOI(rhs.getU8NumOfPOI());
        } else {
            clearU8NumOfPOI();
        }
    }
    return *this;
}

inline bool T_usb_tcu_Data_Header_Part::operator == (const T_usb_tcu_Data_Header_Part& rhs) const {
    return (((!hasU8NumOfPOI() && !rhs.hasU8NumOfPOI()) || getU8NumOfPOI() == rhs.getU8NumOfPOI()));
}

inline bool T_usb_tcu_Data_Header_Part::operator != (const T_usb_tcu_Data_Header_Part& rhs) const {
    return ! (*this == rhs);
}

inline bool T_usb_tcu_Data_Header_Part::operator < (const T_usb_tcu_Data_Header_Part& rhs) const {
    if (hasU8NumOfPOI() || rhs.hasU8NumOfPOI()) {
        if (getU8NumOfPOI() < rhs.getU8NumOfPOI()) return true;
        if (getU8NumOfPOI() > rhs.getU8NumOfPOI()) return false;
    }
    return false;
}

inline bool T_usb_tcu_Data_Header_Part::operator > (const T_usb_tcu_Data_Header_Part& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_usb_tcu_Data_Header_Part::clear() {
    clearU8NumOfPOI();
}

inline void T_usb_tcu_Data_Header_Part::clearU8NumOfPOI() {
    if (hasU8NumOfPOI()) {
         clear_has_u8NumOfPOI();
        _u8NumOfPOI = 0u;
     }
}

inline bool T_usb_tcu_Data_Header_Part::hasU8NumOfPOI () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_usb_tcu_Data_Header_Part::getU8NumOfPOI () const {
    return _u8NumOfPOI;
}

inline void T_usb_tcu_Data_Header_Part::setU8NumOfPOI (uint8 u8NumOfPOI_) {
    set_has_u8NumOfPOI();
    this->_u8NumOfPOI = u8NumOfPOI_;
}

inline void T_usb_tcu_Data_Header_Part::set_has_u8NumOfPOI () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_usb_tcu_Data_Header_Part::clear_has_u8NumOfPOI () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  T_usb_tcu_GroupA_Authorization_Info::T_usb_tcu_GroupA_Authorization_Info ()  :
    _strNaviID (),
    _strSimID (),
    _strVinID ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_usb_tcu_GroupA_Authorization_Info::T_usb_tcu_GroupA_Authorization_Info (const T_usb_tcu_GroupA_Authorization_Info &rhs)  :
    _strNaviID (),
    _strSimID (),
    _strVinID ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_usb_tcu_GroupA_Authorization_Info::T_usb_tcu_GroupA_Authorization_Info (const ::std::string& strNaviID_, const ::std::string& strSimID_, const ::std::string& strVinID_)  :
    _strNaviID (strNaviID_),
    _strSimID (strSimID_),
    _strVinID (strVinID_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strNaviID_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strSimID_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strVinID_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_usb_tcu_GroupA_Authorization_Info::~T_usb_tcu_GroupA_Authorization_Info() {
}

inline T_usb_tcu_GroupA_Authorization_Info& T_usb_tcu_GroupA_Authorization_Info::operator = (const T_usb_tcu_GroupA_Authorization_Info& rhs) {
    if( this != &rhs ) {
        if (rhs.hasStrNaviID()) {
            setStrNaviID(rhs.getStrNaviID());
        } else {
            clearStrNaviID();
        }
        if (rhs.hasStrSimID()) {
            setStrSimID(rhs.getStrSimID());
        } else {
            clearStrSimID();
        }
        if (rhs.hasStrVinID()) {
            setStrVinID(rhs.getStrVinID());
        } else {
            clearStrVinID();
        }
    }
    return *this;
}

inline bool T_usb_tcu_GroupA_Authorization_Info::operator == (const T_usb_tcu_GroupA_Authorization_Info& rhs) const {
    return (((!hasStrNaviID() && !rhs.hasStrNaviID()) || getStrNaviID() == rhs.getStrNaviID()) &&
        ((!hasStrSimID() && !rhs.hasStrSimID()) || getStrSimID() == rhs.getStrSimID()) &&
        ((!hasStrVinID() && !rhs.hasStrVinID()) || getStrVinID() == rhs.getStrVinID()));
}

inline bool T_usb_tcu_GroupA_Authorization_Info::operator != (const T_usb_tcu_GroupA_Authorization_Info& rhs) const {
    return ! (*this == rhs);
}

inline bool T_usb_tcu_GroupA_Authorization_Info::operator < (const T_usb_tcu_GroupA_Authorization_Info& rhs) const {
    if (hasStrNaviID() || rhs.hasStrNaviID()) {
        if (getStrNaviID() < rhs.getStrNaviID()) return true;
        if (getStrNaviID() > rhs.getStrNaviID()) return false;
    }
    if (hasStrSimID() || rhs.hasStrSimID()) {
        if (getStrSimID() < rhs.getStrSimID()) return true;
        if (getStrSimID() > rhs.getStrSimID()) return false;
    }
    if (hasStrVinID() || rhs.hasStrVinID()) {
        if (getStrVinID() < rhs.getStrVinID()) return true;
        if (getStrVinID() > rhs.getStrVinID()) return false;
    }
    return false;
}

inline bool T_usb_tcu_GroupA_Authorization_Info::operator > (const T_usb_tcu_GroupA_Authorization_Info& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_usb_tcu_GroupA_Authorization_Info::clear() {
    clearStrNaviID();
    clearStrSimID();
    clearStrVinID();
}

inline void T_usb_tcu_GroupA_Authorization_Info::clearStrNaviID() {
    if (hasStrNaviID()) {
         clear_has_strNaviID();
        _strNaviID.clear();
     }
}

inline bool T_usb_tcu_GroupA_Authorization_Info::hasStrNaviID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_usb_tcu_GroupA_Authorization_Info::getStrNaviID () const {
    return _strNaviID;
}

inline ::std::string& T_usb_tcu_GroupA_Authorization_Info::getStrNaviIDMutable () {
    set_has_strNaviID();
    return _strNaviID;
}

inline void T_usb_tcu_GroupA_Authorization_Info::setStrNaviID (const ::std::string& strNaviID_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strNaviID_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strNaviID();
    this->_strNaviID = strNaviID_;
}

inline void T_usb_tcu_GroupA_Authorization_Info::setStrNaviID (const char* strNaviID_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strNaviID_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strNaviID();
    this->_strNaviID.assign(strNaviID_);
}

inline void T_usb_tcu_GroupA_Authorization_Info::setStrNaviID (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strNaviID();
    this->_strNaviID.assign(value, size);
}

inline void T_usb_tcu_GroupA_Authorization_Info::clearStrSimID() {
    if (hasStrSimID()) {
         clear_has_strSimID();
        _strSimID.clear();
     }
}

inline bool T_usb_tcu_GroupA_Authorization_Info::hasStrSimID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_usb_tcu_GroupA_Authorization_Info::getStrSimID () const {
    return _strSimID;
}

inline ::std::string& T_usb_tcu_GroupA_Authorization_Info::getStrSimIDMutable () {
    set_has_strSimID();
    return _strSimID;
}

inline void T_usb_tcu_GroupA_Authorization_Info::setStrSimID (const ::std::string& strSimID_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strSimID_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strSimID();
    this->_strSimID = strSimID_;
}

inline void T_usb_tcu_GroupA_Authorization_Info::setStrSimID (const char* strSimID_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strSimID_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strSimID();
    this->_strSimID.assign(strSimID_);
}

inline void T_usb_tcu_GroupA_Authorization_Info::setStrSimID (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strSimID();
    this->_strSimID.assign(value, size);
}

inline void T_usb_tcu_GroupA_Authorization_Info::clearStrVinID() {
    if (hasStrVinID()) {
         clear_has_strVinID();
        _strVinID.clear();
     }
}

inline bool T_usb_tcu_GroupA_Authorization_Info::hasStrVinID () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& T_usb_tcu_GroupA_Authorization_Info::getStrVinID () const {
    return _strVinID;
}

inline ::std::string& T_usb_tcu_GroupA_Authorization_Info::getStrVinIDMutable () {
    set_has_strVinID();
    return _strVinID;
}

inline void T_usb_tcu_GroupA_Authorization_Info::setStrVinID (const ::std::string& strVinID_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strVinID_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strVinID();
    this->_strVinID = strVinID_;
}

inline void T_usb_tcu_GroupA_Authorization_Info::setStrVinID (const char* strVinID_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strVinID_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strVinID();
    this->_strVinID.assign(strVinID_);
}

inline void T_usb_tcu_GroupA_Authorization_Info::setStrVinID (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strVinID();
    this->_strVinID.assign(value, size);
}

inline void T_usb_tcu_GroupA_Authorization_Info::set_has_strNaviID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_usb_tcu_GroupA_Authorization_Info::clear_has_strNaviID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_usb_tcu_GroupA_Authorization_Info::set_has_strSimID () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_usb_tcu_GroupA_Authorization_Info::clear_has_strSimID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_usb_tcu_GroupA_Authorization_Info::set_has_strVinID () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_usb_tcu_GroupA_Authorization_Info::clear_has_strVinID () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_usb_tcu_GroupA_BasicServices_Info::T_usb_tcu_GroupA_BasicServices_Info ()  :
    _strDatum (),
    _strDcmVersion (),
    _strLanguage (),
    _strLatitude (),
    _strLongitude (),
    _strMapVersion (),
    _strNaviSWVersion ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_usb_tcu_GroupA_BasicServices_Info::T_usb_tcu_GroupA_BasicServices_Info (const T_usb_tcu_GroupA_BasicServices_Info &rhs)  :
    _strDatum (),
    _strDcmVersion (),
    _strLanguage (),
    _strLatitude (),
    _strLongitude (),
    _strMapVersion (),
    _strNaviSWVersion ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_usb_tcu_GroupA_BasicServices_Info::T_usb_tcu_GroupA_BasicServices_Info (const ::std::string& strDatum_, const ::std::string& strDcmVersion_, const ::std::string& strLanguage_, const ::std::string& strLatitude_, const ::std::string& strLongitude_, const ::std::string& strMapVersion_, const ::std::string& strNaviSWVersion_)  :
    _strDatum (strDatum_),
    _strDcmVersion (strDcmVersion_),
    _strLanguage (strLanguage_),
    _strLatitude (strLatitude_),
    _strLongitude (strLongitude_),
    _strMapVersion (strMapVersion_),
    _strNaviSWVersion (strNaviSWVersion_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strDatum_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strDcmVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strLanguage_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strLatitude_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strLongitude_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strMapVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strNaviSWVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_usb_tcu_GroupA_BasicServices_Info::~T_usb_tcu_GroupA_BasicServices_Info() {
}

inline T_usb_tcu_GroupA_BasicServices_Info& T_usb_tcu_GroupA_BasicServices_Info::operator = (const T_usb_tcu_GroupA_BasicServices_Info& rhs) {
    if( this != &rhs ) {
        if (rhs.hasStrDatum()) {
            setStrDatum(rhs.getStrDatum());
        } else {
            clearStrDatum();
        }
        if (rhs.hasStrDcmVersion()) {
            setStrDcmVersion(rhs.getStrDcmVersion());
        } else {
            clearStrDcmVersion();
        }
        if (rhs.hasStrLanguage()) {
            setStrLanguage(rhs.getStrLanguage());
        } else {
            clearStrLanguage();
        }
        if (rhs.hasStrLatitude()) {
            setStrLatitude(rhs.getStrLatitude());
        } else {
            clearStrLatitude();
        }
        if (rhs.hasStrLongitude()) {
            setStrLongitude(rhs.getStrLongitude());
        } else {
            clearStrLongitude();
        }
        if (rhs.hasStrMapVersion()) {
            setStrMapVersion(rhs.getStrMapVersion());
        } else {
            clearStrMapVersion();
        }
        if (rhs.hasStrNaviSWVersion()) {
            setStrNaviSWVersion(rhs.getStrNaviSWVersion());
        } else {
            clearStrNaviSWVersion();
        }
    }
    return *this;
}

inline bool T_usb_tcu_GroupA_BasicServices_Info::operator == (const T_usb_tcu_GroupA_BasicServices_Info& rhs) const {
    return (((!hasStrDatum() && !rhs.hasStrDatum()) || getStrDatum() == rhs.getStrDatum()) &&
        ((!hasStrDcmVersion() && !rhs.hasStrDcmVersion()) || getStrDcmVersion() == rhs.getStrDcmVersion()) &&
        ((!hasStrLanguage() && !rhs.hasStrLanguage()) || getStrLanguage() == rhs.getStrLanguage()) &&
        ((!hasStrLatitude() && !rhs.hasStrLatitude()) || getStrLatitude() == rhs.getStrLatitude()) &&
        ((!hasStrLongitude() && !rhs.hasStrLongitude()) || getStrLongitude() == rhs.getStrLongitude()) &&
        ((!hasStrMapVersion() && !rhs.hasStrMapVersion()) || getStrMapVersion() == rhs.getStrMapVersion()) &&
        ((!hasStrNaviSWVersion() && !rhs.hasStrNaviSWVersion()) || getStrNaviSWVersion() == rhs.getStrNaviSWVersion()));
}

inline bool T_usb_tcu_GroupA_BasicServices_Info::operator != (const T_usb_tcu_GroupA_BasicServices_Info& rhs) const {
    return ! (*this == rhs);
}

inline bool T_usb_tcu_GroupA_BasicServices_Info::operator < (const T_usb_tcu_GroupA_BasicServices_Info& rhs) const {
    if (hasStrDatum() || rhs.hasStrDatum()) {
        if (getStrDatum() < rhs.getStrDatum()) return true;
        if (getStrDatum() > rhs.getStrDatum()) return false;
    }
    if (hasStrDcmVersion() || rhs.hasStrDcmVersion()) {
        if (getStrDcmVersion() < rhs.getStrDcmVersion()) return true;
        if (getStrDcmVersion() > rhs.getStrDcmVersion()) return false;
    }
    if (hasStrLanguage() || rhs.hasStrLanguage()) {
        if (getStrLanguage() < rhs.getStrLanguage()) return true;
        if (getStrLanguage() > rhs.getStrLanguage()) return false;
    }
    if (hasStrLatitude() || rhs.hasStrLatitude()) {
        if (getStrLatitude() < rhs.getStrLatitude()) return true;
        if (getStrLatitude() > rhs.getStrLatitude()) return false;
    }
    if (hasStrLongitude() || rhs.hasStrLongitude()) {
        if (getStrLongitude() < rhs.getStrLongitude()) return true;
        if (getStrLongitude() > rhs.getStrLongitude()) return false;
    }
    if (hasStrMapVersion() || rhs.hasStrMapVersion()) {
        if (getStrMapVersion() < rhs.getStrMapVersion()) return true;
        if (getStrMapVersion() > rhs.getStrMapVersion()) return false;
    }
    if (hasStrNaviSWVersion() || rhs.hasStrNaviSWVersion()) {
        if (getStrNaviSWVersion() < rhs.getStrNaviSWVersion()) return true;
        if (getStrNaviSWVersion() > rhs.getStrNaviSWVersion()) return false;
    }
    return false;
}

inline bool T_usb_tcu_GroupA_BasicServices_Info::operator > (const T_usb_tcu_GroupA_BasicServices_Info& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_usb_tcu_GroupA_BasicServices_Info::clear() {
    clearStrDatum();
    clearStrDcmVersion();
    clearStrLanguage();
    clearStrLatitude();
    clearStrLongitude();
    clearStrMapVersion();
    clearStrNaviSWVersion();
}

inline void T_usb_tcu_GroupA_BasicServices_Info::clearStrDatum() {
    if (hasStrDatum()) {
         clear_has_strDatum();
        _strDatum.clear();
     }
}

inline bool T_usb_tcu_GroupA_BasicServices_Info::hasStrDatum () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_usb_tcu_GroupA_BasicServices_Info::getStrDatum () const {
    return _strDatum;
}

inline ::std::string& T_usb_tcu_GroupA_BasicServices_Info::getStrDatumMutable () {
    set_has_strDatum();
    return _strDatum;
}

inline void T_usb_tcu_GroupA_BasicServices_Info::setStrDatum (const ::std::string& strDatum_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strDatum_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strDatum();
    this->_strDatum = strDatum_;
}

inline void T_usb_tcu_GroupA_BasicServices_Info::setStrDatum (const char* strDatum_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strDatum_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strDatum();
    this->_strDatum.assign(strDatum_);
}

inline void T_usb_tcu_GroupA_BasicServices_Info::setStrDatum (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strDatum();
    this->_strDatum.assign(value, size);
}

inline void T_usb_tcu_GroupA_BasicServices_Info::clearStrDcmVersion() {
    if (hasStrDcmVersion()) {
         clear_has_strDcmVersion();
        _strDcmVersion.clear();
     }
}

inline bool T_usb_tcu_GroupA_BasicServices_Info::hasStrDcmVersion () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_usb_tcu_GroupA_BasicServices_Info::getStrDcmVersion () const {
    return _strDcmVersion;
}

inline ::std::string& T_usb_tcu_GroupA_BasicServices_Info::getStrDcmVersionMutable () {
    set_has_strDcmVersion();
    return _strDcmVersion;
}

inline void T_usb_tcu_GroupA_BasicServices_Info::setStrDcmVersion (const ::std::string& strDcmVersion_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strDcmVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strDcmVersion();
    this->_strDcmVersion = strDcmVersion_;
}

inline void T_usb_tcu_GroupA_BasicServices_Info::setStrDcmVersion (const char* strDcmVersion_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strDcmVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strDcmVersion();
    this->_strDcmVersion.assign(strDcmVersion_);
}

inline void T_usb_tcu_GroupA_BasicServices_Info::setStrDcmVersion (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strDcmVersion();
    this->_strDcmVersion.assign(value, size);
}

inline void T_usb_tcu_GroupA_BasicServices_Info::clearStrLanguage() {
    if (hasStrLanguage()) {
         clear_has_strLanguage();
        _strLanguage.clear();
     }
}

inline bool T_usb_tcu_GroupA_BasicServices_Info::hasStrLanguage () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& T_usb_tcu_GroupA_BasicServices_Info::getStrLanguage () const {
    return _strLanguage;
}

inline ::std::string& T_usb_tcu_GroupA_BasicServices_Info::getStrLanguageMutable () {
    set_has_strLanguage();
    return _strLanguage;
}

inline void T_usb_tcu_GroupA_BasicServices_Info::setStrLanguage (const ::std::string& strLanguage_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strLanguage_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strLanguage();
    this->_strLanguage = strLanguage_;
}

inline void T_usb_tcu_GroupA_BasicServices_Info::setStrLanguage (const char* strLanguage_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strLanguage_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strLanguage();
    this->_strLanguage.assign(strLanguage_);
}

inline void T_usb_tcu_GroupA_BasicServices_Info::setStrLanguage (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strLanguage();
    this->_strLanguage.assign(value, size);
}

inline void T_usb_tcu_GroupA_BasicServices_Info::clearStrLatitude() {
    if (hasStrLatitude()) {
         clear_has_strLatitude();
        _strLatitude.clear();
     }
}

inline bool T_usb_tcu_GroupA_BasicServices_Info::hasStrLatitude () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& T_usb_tcu_GroupA_BasicServices_Info::getStrLatitude () const {
    return _strLatitude;
}

inline ::std::string& T_usb_tcu_GroupA_BasicServices_Info::getStrLatitudeMutable () {
    set_has_strLatitude();
    return _strLatitude;
}

inline void T_usb_tcu_GroupA_BasicServices_Info::setStrLatitude (const ::std::string& strLatitude_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strLatitude_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strLatitude();
    this->_strLatitude = strLatitude_;
}

inline void T_usb_tcu_GroupA_BasicServices_Info::setStrLatitude (const char* strLatitude_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strLatitude_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strLatitude();
    this->_strLatitude.assign(strLatitude_);
}

inline void T_usb_tcu_GroupA_BasicServices_Info::setStrLatitude (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strLatitude();
    this->_strLatitude.assign(value, size);
}

inline void T_usb_tcu_GroupA_BasicServices_Info::clearStrLongitude() {
    if (hasStrLongitude()) {
         clear_has_strLongitude();
        _strLongitude.clear();
     }
}

inline bool T_usb_tcu_GroupA_BasicServices_Info::hasStrLongitude () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& T_usb_tcu_GroupA_BasicServices_Info::getStrLongitude () const {
    return _strLongitude;
}

inline ::std::string& T_usb_tcu_GroupA_BasicServices_Info::getStrLongitudeMutable () {
    set_has_strLongitude();
    return _strLongitude;
}

inline void T_usb_tcu_GroupA_BasicServices_Info::setStrLongitude (const ::std::string& strLongitude_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strLongitude_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strLongitude();
    this->_strLongitude = strLongitude_;
}

inline void T_usb_tcu_GroupA_BasicServices_Info::setStrLongitude (const char* strLongitude_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strLongitude_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strLongitude();
    this->_strLongitude.assign(strLongitude_);
}

inline void T_usb_tcu_GroupA_BasicServices_Info::setStrLongitude (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strLongitude();
    this->_strLongitude.assign(value, size);
}

inline void T_usb_tcu_GroupA_BasicServices_Info::clearStrMapVersion() {
    if (hasStrMapVersion()) {
         clear_has_strMapVersion();
        _strMapVersion.clear();
     }
}

inline bool T_usb_tcu_GroupA_BasicServices_Info::hasStrMapVersion () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::std::string& T_usb_tcu_GroupA_BasicServices_Info::getStrMapVersion () const {
    return _strMapVersion;
}

inline ::std::string& T_usb_tcu_GroupA_BasicServices_Info::getStrMapVersionMutable () {
    set_has_strMapVersion();
    return _strMapVersion;
}

inline void T_usb_tcu_GroupA_BasicServices_Info::setStrMapVersion (const ::std::string& strMapVersion_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strMapVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strMapVersion();
    this->_strMapVersion = strMapVersion_;
}

inline void T_usb_tcu_GroupA_BasicServices_Info::setStrMapVersion (const char* strMapVersion_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strMapVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strMapVersion();
    this->_strMapVersion.assign(strMapVersion_);
}

inline void T_usb_tcu_GroupA_BasicServices_Info::setStrMapVersion (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strMapVersion();
    this->_strMapVersion.assign(value, size);
}

inline void T_usb_tcu_GroupA_BasicServices_Info::clearStrNaviSWVersion() {
    if (hasStrNaviSWVersion()) {
         clear_has_strNaviSWVersion();
        _strNaviSWVersion.clear();
     }
}

inline bool T_usb_tcu_GroupA_BasicServices_Info::hasStrNaviSWVersion () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline const ::std::string& T_usb_tcu_GroupA_BasicServices_Info::getStrNaviSWVersion () const {
    return _strNaviSWVersion;
}

inline ::std::string& T_usb_tcu_GroupA_BasicServices_Info::getStrNaviSWVersionMutable () {
    set_has_strNaviSWVersion();
    return _strNaviSWVersion;
}

inline void T_usb_tcu_GroupA_BasicServices_Info::setStrNaviSWVersion (const ::std::string& strNaviSWVersion_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strNaviSWVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strNaviSWVersion();
    this->_strNaviSWVersion = strNaviSWVersion_;
}

inline void T_usb_tcu_GroupA_BasicServices_Info::setStrNaviSWVersion (const char* strNaviSWVersion_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strNaviSWVersion_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strNaviSWVersion();
    this->_strNaviSWVersion.assign(strNaviSWVersion_);
}

inline void T_usb_tcu_GroupA_BasicServices_Info::setStrNaviSWVersion (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strNaviSWVersion();
    this->_strNaviSWVersion.assign(value, size);
}

inline void T_usb_tcu_GroupA_BasicServices_Info::set_has_strDatum () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_usb_tcu_GroupA_BasicServices_Info::clear_has_strDatum () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_usb_tcu_GroupA_BasicServices_Info::set_has_strDcmVersion () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_usb_tcu_GroupA_BasicServices_Info::clear_has_strDcmVersion () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_usb_tcu_GroupA_BasicServices_Info::set_has_strLanguage () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_usb_tcu_GroupA_BasicServices_Info::clear_has_strLanguage () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_usb_tcu_GroupA_BasicServices_Info::set_has_strLatitude () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_usb_tcu_GroupA_BasicServices_Info::clear_has_strLatitude () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_usb_tcu_GroupA_BasicServices_Info::set_has_strLongitude () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_usb_tcu_GroupA_BasicServices_Info::clear_has_strLongitude () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_usb_tcu_GroupA_BasicServices_Info::set_has_strMapVersion () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_usb_tcu_GroupA_BasicServices_Info::clear_has_strMapVersion () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_usb_tcu_GroupA_BasicServices_Info::set_has_strNaviSWVersion () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_usb_tcu_GroupA_BasicServices_Info::clear_has_strNaviSWVersion () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline  T_usb_tcu_GroupA_Info::T_usb_tcu_GroupA_Info ()  :
    _GroupA_Authorization_Info (),
    _GroupA_BasicServices_Info ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_usb_tcu_GroupA_Info::T_usb_tcu_GroupA_Info (const T_usb_tcu_GroupA_Info &rhs)  :
    _GroupA_Authorization_Info (),
    _GroupA_BasicServices_Info ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_usb_tcu_GroupA_Info::T_usb_tcu_GroupA_Info (const T_usb_tcu_GroupA_Authorization_Info& GroupA_Authorization_Info_, const T_usb_tcu_GroupA_BasicServices_Info& GroupA_BasicServices_Info_)  :
    _GroupA_Authorization_Info (GroupA_Authorization_Info_),
    _GroupA_BasicServices_Info (GroupA_BasicServices_Info_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_usb_tcu_GroupA_Info::~T_usb_tcu_GroupA_Info() {
}

inline T_usb_tcu_GroupA_Info& T_usb_tcu_GroupA_Info::operator = (const T_usb_tcu_GroupA_Info& rhs) {
    if( this != &rhs ) {
        if (rhs.hasGroupA_Authorization_Info()) {
            setGroupA_Authorization_Info(rhs.getGroupA_Authorization_Info());
        } else {
            clearGroupA_Authorization_Info();
        }
        if (rhs.hasGroupA_BasicServices_Info()) {
            setGroupA_BasicServices_Info(rhs.getGroupA_BasicServices_Info());
        } else {
            clearGroupA_BasicServices_Info();
        }
    }
    return *this;
}

inline bool T_usb_tcu_GroupA_Info::operator == (const T_usb_tcu_GroupA_Info& rhs) const {
    return (((!hasGroupA_Authorization_Info() && !rhs.hasGroupA_Authorization_Info()) || getGroupA_Authorization_Info() == rhs.getGroupA_Authorization_Info()) &&
        ((!hasGroupA_BasicServices_Info() && !rhs.hasGroupA_BasicServices_Info()) || getGroupA_BasicServices_Info() == rhs.getGroupA_BasicServices_Info()));
}

inline bool T_usb_tcu_GroupA_Info::operator != (const T_usb_tcu_GroupA_Info& rhs) const {
    return ! (*this == rhs);
}

inline bool T_usb_tcu_GroupA_Info::operator < (const T_usb_tcu_GroupA_Info& rhs) const {
    if (hasGroupA_Authorization_Info() || rhs.hasGroupA_Authorization_Info()) {
        if (getGroupA_Authorization_Info() < rhs.getGroupA_Authorization_Info()) return true;
        if (getGroupA_Authorization_Info() > rhs.getGroupA_Authorization_Info()) return false;
    }
    if (hasGroupA_BasicServices_Info() || rhs.hasGroupA_BasicServices_Info()) {
        if (getGroupA_BasicServices_Info() < rhs.getGroupA_BasicServices_Info()) return true;
        if (getGroupA_BasicServices_Info() > rhs.getGroupA_BasicServices_Info()) return false;
    }
    return false;
}

inline bool T_usb_tcu_GroupA_Info::operator > (const T_usb_tcu_GroupA_Info& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_usb_tcu_GroupA_Info::clear() {
    clearGroupA_Authorization_Info();
    clearGroupA_BasicServices_Info();
}

inline void T_usb_tcu_GroupA_Info::clearGroupA_Authorization_Info() {
    if (hasGroupA_Authorization_Info()) {
         clear_has_GroupA_Authorization_Info();
        _GroupA_Authorization_Info.clear();
     }
}

inline bool T_usb_tcu_GroupA_Info::hasGroupA_Authorization_Info () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const T_usb_tcu_GroupA_Authorization_Info& T_usb_tcu_GroupA_Info::getGroupA_Authorization_Info () const {
    return _GroupA_Authorization_Info;
}

inline T_usb_tcu_GroupA_Authorization_Info& T_usb_tcu_GroupA_Info::getGroupA_Authorization_InfoMutable () {
    set_has_GroupA_Authorization_Info();
    return _GroupA_Authorization_Info;
}

inline void T_usb_tcu_GroupA_Info::setGroupA_Authorization_Info (const T_usb_tcu_GroupA_Authorization_Info& GroupA_Authorization_Info_) {
    set_has_GroupA_Authorization_Info();
    this->_GroupA_Authorization_Info = GroupA_Authorization_Info_;
}

inline void T_usb_tcu_GroupA_Info::clearGroupA_BasicServices_Info() {
    if (hasGroupA_BasicServices_Info()) {
         clear_has_GroupA_BasicServices_Info();
        _GroupA_BasicServices_Info.clear();
     }
}

inline bool T_usb_tcu_GroupA_Info::hasGroupA_BasicServices_Info () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const T_usb_tcu_GroupA_BasicServices_Info& T_usb_tcu_GroupA_Info::getGroupA_BasicServices_Info () const {
    return _GroupA_BasicServices_Info;
}

inline T_usb_tcu_GroupA_BasicServices_Info& T_usb_tcu_GroupA_Info::getGroupA_BasicServices_InfoMutable () {
    set_has_GroupA_BasicServices_Info();
    return _GroupA_BasicServices_Info;
}

inline void T_usb_tcu_GroupA_Info::setGroupA_BasicServices_Info (const T_usb_tcu_GroupA_BasicServices_Info& GroupA_BasicServices_Info_) {
    set_has_GroupA_BasicServices_Info();
    this->_GroupA_BasicServices_Info = GroupA_BasicServices_Info_;
}

inline void T_usb_tcu_GroupA_Info::set_has_GroupA_Authorization_Info () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_usb_tcu_GroupA_Info::clear_has_GroupA_Authorization_Info () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_usb_tcu_GroupA_Info::set_has_GroupA_BasicServices_Info () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_usb_tcu_GroupA_Info::clear_has_GroupA_BasicServices_Info () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_tcu_charging_spot_data::T_tcu_charging_spot_data ()  :
    _Location (),
    _strAreaCode1 (),
    _strAreaCode2 (),
    _strAreaCode3 (),
    _strAreaCode4 (),
    _strAreaCode5 (),
    _strAreaCode6 (),
    _strAreaCode7 (),
    _strAreaCode8 (),
    _strPOIName (),
    _strStreetAndHouseNo (),
    _strTelephonenumber (),
    _u16Categorycode (0u),
    _u16ClosedhourInformation (0u),
    _u16OpeninghourInformation (0u),
    _u16Parkingnumber (0u),
    _u16Paymenttypeinformation (0u),
    _u16Sizeofdetailinformation (0u),
    _u16Subcategorycode (0u),
    _u32POIID (0u),
    _u32UserrestrictionID (0u),
    _u8_24hoursadayinformation (0u),
    _u8Businessdayoftheweekinformation (0u),
    _u8Chargingfeeinformation (0u),
    _u8Chargingtype (0u),
    _u8Detailsinformation (0u),
    _u8Entranceinformation (0u),
    _u8Expresswaygeneraltype (0u),
    _u8Fixedvalue1 (0u),
    _u8Fixedvalue2 (0u),
    _u8Informationreliability (0u),
    _u8Installationfacilityinformation (0u),
    _u8Nearthefacilityinformation (0u),
    _u8Officehoursunknowninformation (0u),
    _u8Partnersfacilityinformation (0u),
    _u8SizeOfPOIName (0u),
    _u8SizeOfStreetAndHouseNo (0u),
    _u8SizeOfTelephonenumber (0u),
    _u8Thenumberofentranceinformation (0u),
    _u8Thenumberofinstallationfacilityinformation (0u),
    _u8Thenumberofpartnersfacilityinformation (0u),
    _u8Thetotalnumberofchargingtype (0u),
    _u8Userrestriction (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_tcu_charging_spot_data::T_tcu_charging_spot_data (const T_tcu_charging_spot_data &rhs)  :
    _Location (),
    _strAreaCode1 (),
    _strAreaCode2 (),
    _strAreaCode3 (),
    _strAreaCode4 (),
    _strAreaCode5 (),
    _strAreaCode6 (),
    _strAreaCode7 (),
    _strAreaCode8 (),
    _strPOIName (),
    _strStreetAndHouseNo (),
    _strTelephonenumber (),
    _u16Categorycode (0u),
    _u16ClosedhourInformation (0u),
    _u16OpeninghourInformation (0u),
    _u16Parkingnumber (0u),
    _u16Paymenttypeinformation (0u),
    _u16Sizeofdetailinformation (0u),
    _u16Subcategorycode (0u),
    _u32POIID (0u),
    _u32UserrestrictionID (0u),
    _u8_24hoursadayinformation (0u),
    _u8Businessdayoftheweekinformation (0u),
    _u8Chargingfeeinformation (0u),
    _u8Chargingtype (0u),
    _u8Detailsinformation (0u),
    _u8Entranceinformation (0u),
    _u8Expresswaygeneraltype (0u),
    _u8Fixedvalue1 (0u),
    _u8Fixedvalue2 (0u),
    _u8Informationreliability (0u),
    _u8Installationfacilityinformation (0u),
    _u8Nearthefacilityinformation (0u),
    _u8Officehoursunknowninformation (0u),
    _u8Partnersfacilityinformation (0u),
    _u8SizeOfPOIName (0u),
    _u8SizeOfStreetAndHouseNo (0u),
    _u8SizeOfTelephonenumber (0u),
    _u8Thenumberofentranceinformation (0u),
    _u8Thenumberofinstallationfacilityinformation (0u),
    _u8Thenumberofpartnersfacilityinformation (0u),
    _u8Thetotalnumberofchargingtype (0u),
    _u8Userrestriction (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_tcu_charging_spot_data::T_tcu_charging_spot_data (const T_usb_tcu_Location& Location_, const ::std::string& strAreaCode1_, const ::std::string& strAreaCode2_, const ::std::string& strAreaCode3_, const ::std::string& strAreaCode4_, const ::std::string& strAreaCode5_, const ::std::string& strAreaCode6_, const ::std::string& strAreaCode7_, const ::std::string& strAreaCode8_, const ::std::string& strPOIName_, const ::std::string& strStreetAndHouseNo_, const ::std::string& strTelephonenumber_, uint16 u16Categorycode_, uint16 u16ClosedhourInformation_, uint16 u16OpeninghourInformation_, uint16 u16Parkingnumber_, uint16 u16Paymenttypeinformation_, uint16 u16Sizeofdetailinformation_, uint16 u16Subcategorycode_, uint32 u32POIID_, uint32 u32UserrestrictionID_, uint8 u8_24hoursadayinformation_, uint8 u8Businessdayoftheweekinformation_, uint8 u8Chargingfeeinformation_, uint8 u8Chargingtype_, uint8 u8Detailsinformation_, uint8 u8Entranceinformation_, uint8 u8Expresswaygeneraltype_, uint8 u8Fixedvalue1_, uint8 u8Fixedvalue2_, uint8 u8Informationreliability_, uint8 u8Installationfacilityinformation_, uint8 u8Nearthefacilityinformation_, uint8 u8Officehoursunknowninformation_, uint8 u8Partnersfacilityinformation_, uint8 u8SizeOfPOIName_, uint8 u8SizeOfStreetAndHouseNo_, uint8 u8SizeOfTelephonenumber_, uint8 u8Thenumberofentranceinformation_, uint8 u8Thenumberofinstallationfacilityinformation_, uint8 u8Thenumberofpartnersfacilityinformation_, uint8 u8Thetotalnumberofchargingtype_, uint8 u8Userrestriction_)  :
    _Location (Location_),
    _strAreaCode1 (strAreaCode1_),
    _strAreaCode2 (strAreaCode2_),
    _strAreaCode3 (strAreaCode3_),
    _strAreaCode4 (strAreaCode4_),
    _strAreaCode5 (strAreaCode5_),
    _strAreaCode6 (strAreaCode6_),
    _strAreaCode7 (strAreaCode7_),
    _strAreaCode8 (strAreaCode8_),
    _strPOIName (strPOIName_),
    _strStreetAndHouseNo (strStreetAndHouseNo_),
    _strTelephonenumber (strTelephonenumber_),
    _u16Categorycode (u16Categorycode_),
    _u16ClosedhourInformation (u16ClosedhourInformation_),
    _u16OpeninghourInformation (u16OpeninghourInformation_),
    _u16Parkingnumber (u16Parkingnumber_),
    _u16Paymenttypeinformation (u16Paymenttypeinformation_),
    _u16Sizeofdetailinformation (u16Sizeofdetailinformation_),
    _u16Subcategorycode (u16Subcategorycode_),
    _u32POIID (u32POIID_),
    _u32UserrestrictionID (u32UserrestrictionID_),
    _u8_24hoursadayinformation (u8_24hoursadayinformation_),
    _u8Businessdayoftheweekinformation (u8Businessdayoftheweekinformation_),
    _u8Chargingfeeinformation (u8Chargingfeeinformation_),
    _u8Chargingtype (u8Chargingtype_),
    _u8Detailsinformation (u8Detailsinformation_),
    _u8Entranceinformation (u8Entranceinformation_),
    _u8Expresswaygeneraltype (u8Expresswaygeneraltype_),
    _u8Fixedvalue1 (u8Fixedvalue1_),
    _u8Fixedvalue2 (u8Fixedvalue2_),
    _u8Informationreliability (u8Informationreliability_),
    _u8Installationfacilityinformation (u8Installationfacilityinformation_),
    _u8Nearthefacilityinformation (u8Nearthefacilityinformation_),
    _u8Officehoursunknowninformation (u8Officehoursunknowninformation_),
    _u8Partnersfacilityinformation (u8Partnersfacilityinformation_),
    _u8SizeOfPOIName (u8SizeOfPOIName_),
    _u8SizeOfStreetAndHouseNo (u8SizeOfStreetAndHouseNo_),
    _u8SizeOfTelephonenumber (u8SizeOfTelephonenumber_),
    _u8Thenumberofentranceinformation (u8Thenumberofentranceinformation_),
    _u8Thenumberofinstallationfacilityinformation (u8Thenumberofinstallationfacilityinformation_),
    _u8Thenumberofpartnersfacilityinformation (u8Thenumberofpartnersfacilityinformation_),
    _u8Thetotalnumberofchargingtype (u8Thetotalnumberofchargingtype_),
    _u8Userrestriction (u8Userrestriction_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strAreaCode1_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strAreaCode2_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strAreaCode3_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strAreaCode4_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strAreaCode5_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strAreaCode6_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strAreaCode7_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strAreaCode8_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strPOIName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strStreetAndHouseNo_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strTelephonenumber_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_tcu_charging_spot_data::~T_tcu_charging_spot_data() {
}

inline T_tcu_charging_spot_data& T_tcu_charging_spot_data::operator = (const T_tcu_charging_spot_data& rhs) {
    if( this != &rhs ) {
        if (rhs.hasLocation()) {
            setLocation(rhs.getLocation());
        } else {
            clearLocation();
        }
        if (rhs.hasStrAreaCode1()) {
            setStrAreaCode1(rhs.getStrAreaCode1());
        } else {
            clearStrAreaCode1();
        }
        if (rhs.hasStrAreaCode2()) {
            setStrAreaCode2(rhs.getStrAreaCode2());
        } else {
            clearStrAreaCode2();
        }
        if (rhs.hasStrAreaCode3()) {
            setStrAreaCode3(rhs.getStrAreaCode3());
        } else {
            clearStrAreaCode3();
        }
        if (rhs.hasStrAreaCode4()) {
            setStrAreaCode4(rhs.getStrAreaCode4());
        } else {
            clearStrAreaCode4();
        }
        if (rhs.hasStrAreaCode5()) {
            setStrAreaCode5(rhs.getStrAreaCode5());
        } else {
            clearStrAreaCode5();
        }
        if (rhs.hasStrAreaCode6()) {
            setStrAreaCode6(rhs.getStrAreaCode6());
        } else {
            clearStrAreaCode6();
        }
        if (rhs.hasStrAreaCode7()) {
            setStrAreaCode7(rhs.getStrAreaCode7());
        } else {
            clearStrAreaCode7();
        }
        if (rhs.hasStrAreaCode8()) {
            setStrAreaCode8(rhs.getStrAreaCode8());
        } else {
            clearStrAreaCode8();
        }
        if (rhs.hasStrPOIName()) {
            setStrPOIName(rhs.getStrPOIName());
        } else {
            clearStrPOIName();
        }
        if (rhs.hasStrStreetAndHouseNo()) {
            setStrStreetAndHouseNo(rhs.getStrStreetAndHouseNo());
        } else {
            clearStrStreetAndHouseNo();
        }
        if (rhs.hasStrTelephonenumber()) {
            setStrTelephonenumber(rhs.getStrTelephonenumber());
        } else {
            clearStrTelephonenumber();
        }
        if (rhs.hasU16Categorycode()) {
            setU16Categorycode(rhs.getU16Categorycode());
        } else {
            clearU16Categorycode();
        }
        if (rhs.hasU16ClosedhourInformation()) {
            setU16ClosedhourInformation(rhs.getU16ClosedhourInformation());
        } else {
            clearU16ClosedhourInformation();
        }
        if (rhs.hasU16OpeninghourInformation()) {
            setU16OpeninghourInformation(rhs.getU16OpeninghourInformation());
        } else {
            clearU16OpeninghourInformation();
        }
        if (rhs.hasU16Parkingnumber()) {
            setU16Parkingnumber(rhs.getU16Parkingnumber());
        } else {
            clearU16Parkingnumber();
        }
        if (rhs.hasU16Paymenttypeinformation()) {
            setU16Paymenttypeinformation(rhs.getU16Paymenttypeinformation());
        } else {
            clearU16Paymenttypeinformation();
        }
        if (rhs.hasU16Sizeofdetailinformation()) {
            setU16Sizeofdetailinformation(rhs.getU16Sizeofdetailinformation());
        } else {
            clearU16Sizeofdetailinformation();
        }
        if (rhs.hasU16Subcategorycode()) {
            setU16Subcategorycode(rhs.getU16Subcategorycode());
        } else {
            clearU16Subcategorycode();
        }
        if (rhs.hasU32POIID()) {
            setU32POIID(rhs.getU32POIID());
        } else {
            clearU32POIID();
        }
        if (rhs.hasU32UserrestrictionID()) {
            setU32UserrestrictionID(rhs.getU32UserrestrictionID());
        } else {
            clearU32UserrestrictionID();
        }
        if (rhs.hasU8_24hoursadayinformation()) {
            setU8_24hoursadayinformation(rhs.getU8_24hoursadayinformation());
        } else {
            clearU8_24hoursadayinformation();
        }
        if (rhs.hasU8Businessdayoftheweekinformation()) {
            setU8Businessdayoftheweekinformation(rhs.getU8Businessdayoftheweekinformation());
        } else {
            clearU8Businessdayoftheweekinformation();
        }
        if (rhs.hasU8Chargingfeeinformation()) {
            setU8Chargingfeeinformation(rhs.getU8Chargingfeeinformation());
        } else {
            clearU8Chargingfeeinformation();
        }
        if (rhs.hasU8Chargingtype()) {
            setU8Chargingtype(rhs.getU8Chargingtype());
        } else {
            clearU8Chargingtype();
        }
        if (rhs.hasU8Detailsinformation()) {
            setU8Detailsinformation(rhs.getU8Detailsinformation());
        } else {
            clearU8Detailsinformation();
        }
        if (rhs.hasU8Entranceinformation()) {
            setU8Entranceinformation(rhs.getU8Entranceinformation());
        } else {
            clearU8Entranceinformation();
        }
        if (rhs.hasU8Expresswaygeneraltype()) {
            setU8Expresswaygeneraltype(rhs.getU8Expresswaygeneraltype());
        } else {
            clearU8Expresswaygeneraltype();
        }
        if (rhs.hasU8Fixedvalue1()) {
            setU8Fixedvalue1(rhs.getU8Fixedvalue1());
        } else {
            clearU8Fixedvalue1();
        }
        if (rhs.hasU8Fixedvalue2()) {
            setU8Fixedvalue2(rhs.getU8Fixedvalue2());
        } else {
            clearU8Fixedvalue2();
        }
        if (rhs.hasU8Informationreliability()) {
            setU8Informationreliability(rhs.getU8Informationreliability());
        } else {
            clearU8Informationreliability();
        }
        if (rhs.hasU8Installationfacilityinformation()) {
            setU8Installationfacilityinformation(rhs.getU8Installationfacilityinformation());
        } else {
            clearU8Installationfacilityinformation();
        }
        if (rhs.hasU8Nearthefacilityinformation()) {
            setU8Nearthefacilityinformation(rhs.getU8Nearthefacilityinformation());
        } else {
            clearU8Nearthefacilityinformation();
        }
        if (rhs.hasU8Officehoursunknowninformation()) {
            setU8Officehoursunknowninformation(rhs.getU8Officehoursunknowninformation());
        } else {
            clearU8Officehoursunknowninformation();
        }
        if (rhs.hasU8Partnersfacilityinformation()) {
            setU8Partnersfacilityinformation(rhs.getU8Partnersfacilityinformation());
        } else {
            clearU8Partnersfacilityinformation();
        }
        if (rhs.hasU8SizeOfPOIName()) {
            setU8SizeOfPOIName(rhs.getU8SizeOfPOIName());
        } else {
            clearU8SizeOfPOIName();
        }
        if (rhs.hasU8SizeOfStreetAndHouseNo()) {
            setU8SizeOfStreetAndHouseNo(rhs.getU8SizeOfStreetAndHouseNo());
        } else {
            clearU8SizeOfStreetAndHouseNo();
        }
        if (rhs.hasU8SizeOfTelephonenumber()) {
            setU8SizeOfTelephonenumber(rhs.getU8SizeOfTelephonenumber());
        } else {
            clearU8SizeOfTelephonenumber();
        }
        if (rhs.hasU8Thenumberofentranceinformation()) {
            setU8Thenumberofentranceinformation(rhs.getU8Thenumberofentranceinformation());
        } else {
            clearU8Thenumberofentranceinformation();
        }
        if (rhs.hasU8Thenumberofinstallationfacilityinformation()) {
            setU8Thenumberofinstallationfacilityinformation(rhs.getU8Thenumberofinstallationfacilityinformation());
        } else {
            clearU8Thenumberofinstallationfacilityinformation();
        }
        if (rhs.hasU8Thenumberofpartnersfacilityinformation()) {
            setU8Thenumberofpartnersfacilityinformation(rhs.getU8Thenumberofpartnersfacilityinformation());
        } else {
            clearU8Thenumberofpartnersfacilityinformation();
        }
        if (rhs.hasU8Thetotalnumberofchargingtype()) {
            setU8Thetotalnumberofchargingtype(rhs.getU8Thetotalnumberofchargingtype());
        } else {
            clearU8Thetotalnumberofchargingtype();
        }
        if (rhs.hasU8Userrestriction()) {
            setU8Userrestriction(rhs.getU8Userrestriction());
        } else {
            clearU8Userrestriction();
        }
    }
    return *this;
}

inline bool T_tcu_charging_spot_data::operator == (const T_tcu_charging_spot_data& rhs) const {
    return (((!hasLocation() && !rhs.hasLocation()) || getLocation() == rhs.getLocation()) &&
        ((!hasStrAreaCode1() && !rhs.hasStrAreaCode1()) || getStrAreaCode1() == rhs.getStrAreaCode1()) &&
        ((!hasStrAreaCode2() && !rhs.hasStrAreaCode2()) || getStrAreaCode2() == rhs.getStrAreaCode2()) &&
        ((!hasStrAreaCode3() && !rhs.hasStrAreaCode3()) || getStrAreaCode3() == rhs.getStrAreaCode3()) &&
        ((!hasStrAreaCode4() && !rhs.hasStrAreaCode4()) || getStrAreaCode4() == rhs.getStrAreaCode4()) &&
        ((!hasStrAreaCode5() && !rhs.hasStrAreaCode5()) || getStrAreaCode5() == rhs.getStrAreaCode5()) &&
        ((!hasStrAreaCode6() && !rhs.hasStrAreaCode6()) || getStrAreaCode6() == rhs.getStrAreaCode6()) &&
        ((!hasStrAreaCode7() && !rhs.hasStrAreaCode7()) || getStrAreaCode7() == rhs.getStrAreaCode7()) &&
        ((!hasStrAreaCode8() && !rhs.hasStrAreaCode8()) || getStrAreaCode8() == rhs.getStrAreaCode8()) &&
        ((!hasStrPOIName() && !rhs.hasStrPOIName()) || getStrPOIName() == rhs.getStrPOIName()) &&
        ((!hasStrStreetAndHouseNo() && !rhs.hasStrStreetAndHouseNo()) || getStrStreetAndHouseNo() == rhs.getStrStreetAndHouseNo()) &&
        ((!hasStrTelephonenumber() && !rhs.hasStrTelephonenumber()) || getStrTelephonenumber() == rhs.getStrTelephonenumber()) &&
        ((!hasU16Categorycode() && !rhs.hasU16Categorycode()) || getU16Categorycode() == rhs.getU16Categorycode()) &&
        ((!hasU16ClosedhourInformation() && !rhs.hasU16ClosedhourInformation()) || getU16ClosedhourInformation() == rhs.getU16ClosedhourInformation()) &&
        ((!hasU16OpeninghourInformation() && !rhs.hasU16OpeninghourInformation()) || getU16OpeninghourInformation() == rhs.getU16OpeninghourInformation()) &&
        ((!hasU16Parkingnumber() && !rhs.hasU16Parkingnumber()) || getU16Parkingnumber() == rhs.getU16Parkingnumber()) &&
        ((!hasU16Paymenttypeinformation() && !rhs.hasU16Paymenttypeinformation()) || getU16Paymenttypeinformation() == rhs.getU16Paymenttypeinformation()) &&
        ((!hasU16Sizeofdetailinformation() && !rhs.hasU16Sizeofdetailinformation()) || getU16Sizeofdetailinformation() == rhs.getU16Sizeofdetailinformation()) &&
        ((!hasU16Subcategorycode() && !rhs.hasU16Subcategorycode()) || getU16Subcategorycode() == rhs.getU16Subcategorycode()) &&
        ((!hasU32POIID() && !rhs.hasU32POIID()) || getU32POIID() == rhs.getU32POIID()) &&
        ((!hasU32UserrestrictionID() && !rhs.hasU32UserrestrictionID()) || getU32UserrestrictionID() == rhs.getU32UserrestrictionID()) &&
        ((!hasU8_24hoursadayinformation() && !rhs.hasU8_24hoursadayinformation()) || getU8_24hoursadayinformation() == rhs.getU8_24hoursadayinformation()) &&
        ((!hasU8Businessdayoftheweekinformation() && !rhs.hasU8Businessdayoftheweekinformation()) || getU8Businessdayoftheweekinformation() == rhs.getU8Businessdayoftheweekinformation()) &&
        ((!hasU8Chargingfeeinformation() && !rhs.hasU8Chargingfeeinformation()) || getU8Chargingfeeinformation() == rhs.getU8Chargingfeeinformation()) &&
        ((!hasU8Chargingtype() && !rhs.hasU8Chargingtype()) || getU8Chargingtype() == rhs.getU8Chargingtype()) &&
        ((!hasU8Detailsinformation() && !rhs.hasU8Detailsinformation()) || getU8Detailsinformation() == rhs.getU8Detailsinformation()) &&
        ((!hasU8Entranceinformation() && !rhs.hasU8Entranceinformation()) || getU8Entranceinformation() == rhs.getU8Entranceinformation()) &&
        ((!hasU8Expresswaygeneraltype() && !rhs.hasU8Expresswaygeneraltype()) || getU8Expresswaygeneraltype() == rhs.getU8Expresswaygeneraltype()) &&
        ((!hasU8Fixedvalue1() && !rhs.hasU8Fixedvalue1()) || getU8Fixedvalue1() == rhs.getU8Fixedvalue1()) &&
        ((!hasU8Fixedvalue2() && !rhs.hasU8Fixedvalue2()) || getU8Fixedvalue2() == rhs.getU8Fixedvalue2()) &&
        ((!hasU8Informationreliability() && !rhs.hasU8Informationreliability()) || getU8Informationreliability() == rhs.getU8Informationreliability()) &&
        ((!hasU8Installationfacilityinformation() && !rhs.hasU8Installationfacilityinformation()) || getU8Installationfacilityinformation() == rhs.getU8Installationfacilityinformation()) &&
        ((!hasU8Nearthefacilityinformation() && !rhs.hasU8Nearthefacilityinformation()) || getU8Nearthefacilityinformation() == rhs.getU8Nearthefacilityinformation()) &&
        ((!hasU8Officehoursunknowninformation() && !rhs.hasU8Officehoursunknowninformation()) || getU8Officehoursunknowninformation() == rhs.getU8Officehoursunknowninformation()) &&
        ((!hasU8Partnersfacilityinformation() && !rhs.hasU8Partnersfacilityinformation()) || getU8Partnersfacilityinformation() == rhs.getU8Partnersfacilityinformation()) &&
        ((!hasU8SizeOfPOIName() && !rhs.hasU8SizeOfPOIName()) || getU8SizeOfPOIName() == rhs.getU8SizeOfPOIName()) &&
        ((!hasU8SizeOfStreetAndHouseNo() && !rhs.hasU8SizeOfStreetAndHouseNo()) || getU8SizeOfStreetAndHouseNo() == rhs.getU8SizeOfStreetAndHouseNo()) &&
        ((!hasU8SizeOfTelephonenumber() && !rhs.hasU8SizeOfTelephonenumber()) || getU8SizeOfTelephonenumber() == rhs.getU8SizeOfTelephonenumber()) &&
        ((!hasU8Thenumberofentranceinformation() && !rhs.hasU8Thenumberofentranceinformation()) || getU8Thenumberofentranceinformation() == rhs.getU8Thenumberofentranceinformation()) &&
        ((!hasU8Thenumberofinstallationfacilityinformation() && !rhs.hasU8Thenumberofinstallationfacilityinformation()) || getU8Thenumberofinstallationfacilityinformation() == rhs.getU8Thenumberofinstallationfacilityinformation()) &&
        ((!hasU8Thenumberofpartnersfacilityinformation() && !rhs.hasU8Thenumberofpartnersfacilityinformation()) || getU8Thenumberofpartnersfacilityinformation() == rhs.getU8Thenumberofpartnersfacilityinformation()) &&
        ((!hasU8Thetotalnumberofchargingtype() && !rhs.hasU8Thetotalnumberofchargingtype()) || getU8Thetotalnumberofchargingtype() == rhs.getU8Thetotalnumberofchargingtype()) &&
        ((!hasU8Userrestriction() && !rhs.hasU8Userrestriction()) || getU8Userrestriction() == rhs.getU8Userrestriction()));
}

inline bool T_tcu_charging_spot_data::operator != (const T_tcu_charging_spot_data& rhs) const {
    return ! (*this == rhs);
}

inline bool T_tcu_charging_spot_data::operator < (const T_tcu_charging_spot_data& rhs) const {
    if (hasLocation() || rhs.hasLocation()) {
        if (getLocation() < rhs.getLocation()) return true;
        if (getLocation() > rhs.getLocation()) return false;
    }
    if (hasStrAreaCode1() || rhs.hasStrAreaCode1()) {
        if (getStrAreaCode1() < rhs.getStrAreaCode1()) return true;
        if (getStrAreaCode1() > rhs.getStrAreaCode1()) return false;
    }
    if (hasStrAreaCode2() || rhs.hasStrAreaCode2()) {
        if (getStrAreaCode2() < rhs.getStrAreaCode2()) return true;
        if (getStrAreaCode2() > rhs.getStrAreaCode2()) return false;
    }
    if (hasStrAreaCode3() || rhs.hasStrAreaCode3()) {
        if (getStrAreaCode3() < rhs.getStrAreaCode3()) return true;
        if (getStrAreaCode3() > rhs.getStrAreaCode3()) return false;
    }
    if (hasStrAreaCode4() || rhs.hasStrAreaCode4()) {
        if (getStrAreaCode4() < rhs.getStrAreaCode4()) return true;
        if (getStrAreaCode4() > rhs.getStrAreaCode4()) return false;
    }
    if (hasStrAreaCode5() || rhs.hasStrAreaCode5()) {
        if (getStrAreaCode5() < rhs.getStrAreaCode5()) return true;
        if (getStrAreaCode5() > rhs.getStrAreaCode5()) return false;
    }
    if (hasStrAreaCode6() || rhs.hasStrAreaCode6()) {
        if (getStrAreaCode6() < rhs.getStrAreaCode6()) return true;
        if (getStrAreaCode6() > rhs.getStrAreaCode6()) return false;
    }
    if (hasStrAreaCode7() || rhs.hasStrAreaCode7()) {
        if (getStrAreaCode7() < rhs.getStrAreaCode7()) return true;
        if (getStrAreaCode7() > rhs.getStrAreaCode7()) return false;
    }
    if (hasStrAreaCode8() || rhs.hasStrAreaCode8()) {
        if (getStrAreaCode8() < rhs.getStrAreaCode8()) return true;
        if (getStrAreaCode8() > rhs.getStrAreaCode8()) return false;
    }
    if (hasStrPOIName() || rhs.hasStrPOIName()) {
        if (getStrPOIName() < rhs.getStrPOIName()) return true;
        if (getStrPOIName() > rhs.getStrPOIName()) return false;
    }
    if (hasStrStreetAndHouseNo() || rhs.hasStrStreetAndHouseNo()) {
        if (getStrStreetAndHouseNo() < rhs.getStrStreetAndHouseNo()) return true;
        if (getStrStreetAndHouseNo() > rhs.getStrStreetAndHouseNo()) return false;
    }
    if (hasStrTelephonenumber() || rhs.hasStrTelephonenumber()) {
        if (getStrTelephonenumber() < rhs.getStrTelephonenumber()) return true;
        if (getStrTelephonenumber() > rhs.getStrTelephonenumber()) return false;
    }
    if (hasU16Categorycode() || rhs.hasU16Categorycode()) {
        if (getU16Categorycode() < rhs.getU16Categorycode()) return true;
        if (getU16Categorycode() > rhs.getU16Categorycode()) return false;
    }
    if (hasU16ClosedhourInformation() || rhs.hasU16ClosedhourInformation()) {
        if (getU16ClosedhourInformation() < rhs.getU16ClosedhourInformation()) return true;
        if (getU16ClosedhourInformation() > rhs.getU16ClosedhourInformation()) return false;
    }
    if (hasU16OpeninghourInformation() || rhs.hasU16OpeninghourInformation()) {
        if (getU16OpeninghourInformation() < rhs.getU16OpeninghourInformation()) return true;
        if (getU16OpeninghourInformation() > rhs.getU16OpeninghourInformation()) return false;
    }
    if (hasU16Parkingnumber() || rhs.hasU16Parkingnumber()) {
        if (getU16Parkingnumber() < rhs.getU16Parkingnumber()) return true;
        if (getU16Parkingnumber() > rhs.getU16Parkingnumber()) return false;
    }
    if (hasU16Paymenttypeinformation() || rhs.hasU16Paymenttypeinformation()) {
        if (getU16Paymenttypeinformation() < rhs.getU16Paymenttypeinformation()) return true;
        if (getU16Paymenttypeinformation() > rhs.getU16Paymenttypeinformation()) return false;
    }
    if (hasU16Sizeofdetailinformation() || rhs.hasU16Sizeofdetailinformation()) {
        if (getU16Sizeofdetailinformation() < rhs.getU16Sizeofdetailinformation()) return true;
        if (getU16Sizeofdetailinformation() > rhs.getU16Sizeofdetailinformation()) return false;
    }
    if (hasU16Subcategorycode() || rhs.hasU16Subcategorycode()) {
        if (getU16Subcategorycode() < rhs.getU16Subcategorycode()) return true;
        if (getU16Subcategorycode() > rhs.getU16Subcategorycode()) return false;
    }
    if (hasU32POIID() || rhs.hasU32POIID()) {
        if (getU32POIID() < rhs.getU32POIID()) return true;
        if (getU32POIID() > rhs.getU32POIID()) return false;
    }
    if (hasU32UserrestrictionID() || rhs.hasU32UserrestrictionID()) {
        if (getU32UserrestrictionID() < rhs.getU32UserrestrictionID()) return true;
        if (getU32UserrestrictionID() > rhs.getU32UserrestrictionID()) return false;
    }
    if (hasU8_24hoursadayinformation() || rhs.hasU8_24hoursadayinformation()) {
        if (getU8_24hoursadayinformation() < rhs.getU8_24hoursadayinformation()) return true;
        if (getU8_24hoursadayinformation() > rhs.getU8_24hoursadayinformation()) return false;
    }
    if (hasU8Businessdayoftheweekinformation() || rhs.hasU8Businessdayoftheweekinformation()) {
        if (getU8Businessdayoftheweekinformation() < rhs.getU8Businessdayoftheweekinformation()) return true;
        if (getU8Businessdayoftheweekinformation() > rhs.getU8Businessdayoftheweekinformation()) return false;
    }
    if (hasU8Chargingfeeinformation() || rhs.hasU8Chargingfeeinformation()) {
        if (getU8Chargingfeeinformation() < rhs.getU8Chargingfeeinformation()) return true;
        if (getU8Chargingfeeinformation() > rhs.getU8Chargingfeeinformation()) return false;
    }
    if (hasU8Chargingtype() || rhs.hasU8Chargingtype()) {
        if (getU8Chargingtype() < rhs.getU8Chargingtype()) return true;
        if (getU8Chargingtype() > rhs.getU8Chargingtype()) return false;
    }
    if (hasU8Detailsinformation() || rhs.hasU8Detailsinformation()) {
        if (getU8Detailsinformation() < rhs.getU8Detailsinformation()) return true;
        if (getU8Detailsinformation() > rhs.getU8Detailsinformation()) return false;
    }
    if (hasU8Entranceinformation() || rhs.hasU8Entranceinformation()) {
        if (getU8Entranceinformation() < rhs.getU8Entranceinformation()) return true;
        if (getU8Entranceinformation() > rhs.getU8Entranceinformation()) return false;
    }
    if (hasU8Expresswaygeneraltype() || rhs.hasU8Expresswaygeneraltype()) {
        if (getU8Expresswaygeneraltype() < rhs.getU8Expresswaygeneraltype()) return true;
        if (getU8Expresswaygeneraltype() > rhs.getU8Expresswaygeneraltype()) return false;
    }
    if (hasU8Fixedvalue1() || rhs.hasU8Fixedvalue1()) {
        if (getU8Fixedvalue1() < rhs.getU8Fixedvalue1()) return true;
        if (getU8Fixedvalue1() > rhs.getU8Fixedvalue1()) return false;
    }
    if (hasU8Fixedvalue2() || rhs.hasU8Fixedvalue2()) {
        if (getU8Fixedvalue2() < rhs.getU8Fixedvalue2()) return true;
        if (getU8Fixedvalue2() > rhs.getU8Fixedvalue2()) return false;
    }
    if (hasU8Informationreliability() || rhs.hasU8Informationreliability()) {
        if (getU8Informationreliability() < rhs.getU8Informationreliability()) return true;
        if (getU8Informationreliability() > rhs.getU8Informationreliability()) return false;
    }
    if (hasU8Installationfacilityinformation() || rhs.hasU8Installationfacilityinformation()) {
        if (getU8Installationfacilityinformation() < rhs.getU8Installationfacilityinformation()) return true;
        if (getU8Installationfacilityinformation() > rhs.getU8Installationfacilityinformation()) return false;
    }
    if (hasU8Nearthefacilityinformation() || rhs.hasU8Nearthefacilityinformation()) {
        if (getU8Nearthefacilityinformation() < rhs.getU8Nearthefacilityinformation()) return true;
        if (getU8Nearthefacilityinformation() > rhs.getU8Nearthefacilityinformation()) return false;
    }
    if (hasU8Officehoursunknowninformation() || rhs.hasU8Officehoursunknowninformation()) {
        if (getU8Officehoursunknowninformation() < rhs.getU8Officehoursunknowninformation()) return true;
        if (getU8Officehoursunknowninformation() > rhs.getU8Officehoursunknowninformation()) return false;
    }
    if (hasU8Partnersfacilityinformation() || rhs.hasU8Partnersfacilityinformation()) {
        if (getU8Partnersfacilityinformation() < rhs.getU8Partnersfacilityinformation()) return true;
        if (getU8Partnersfacilityinformation() > rhs.getU8Partnersfacilityinformation()) return false;
    }
    if (hasU8SizeOfPOIName() || rhs.hasU8SizeOfPOIName()) {
        if (getU8SizeOfPOIName() < rhs.getU8SizeOfPOIName()) return true;
        if (getU8SizeOfPOIName() > rhs.getU8SizeOfPOIName()) return false;
    }
    if (hasU8SizeOfStreetAndHouseNo() || rhs.hasU8SizeOfStreetAndHouseNo()) {
        if (getU8SizeOfStreetAndHouseNo() < rhs.getU8SizeOfStreetAndHouseNo()) return true;
        if (getU8SizeOfStreetAndHouseNo() > rhs.getU8SizeOfStreetAndHouseNo()) return false;
    }
    if (hasU8SizeOfTelephonenumber() || rhs.hasU8SizeOfTelephonenumber()) {
        if (getU8SizeOfTelephonenumber() < rhs.getU8SizeOfTelephonenumber()) return true;
        if (getU8SizeOfTelephonenumber() > rhs.getU8SizeOfTelephonenumber()) return false;
    }
    if (hasU8Thenumberofentranceinformation() || rhs.hasU8Thenumberofentranceinformation()) {
        if (getU8Thenumberofentranceinformation() < rhs.getU8Thenumberofentranceinformation()) return true;
        if (getU8Thenumberofentranceinformation() > rhs.getU8Thenumberofentranceinformation()) return false;
    }
    if (hasU8Thenumberofinstallationfacilityinformation() || rhs.hasU8Thenumberofinstallationfacilityinformation()) {
        if (getU8Thenumberofinstallationfacilityinformation() < rhs.getU8Thenumberofinstallationfacilityinformation()) return true;
        if (getU8Thenumberofinstallationfacilityinformation() > rhs.getU8Thenumberofinstallationfacilityinformation()) return false;
    }
    if (hasU8Thenumberofpartnersfacilityinformation() || rhs.hasU8Thenumberofpartnersfacilityinformation()) {
        if (getU8Thenumberofpartnersfacilityinformation() < rhs.getU8Thenumberofpartnersfacilityinformation()) return true;
        if (getU8Thenumberofpartnersfacilityinformation() > rhs.getU8Thenumberofpartnersfacilityinformation()) return false;
    }
    if (hasU8Thetotalnumberofchargingtype() || rhs.hasU8Thetotalnumberofchargingtype()) {
        if (getU8Thetotalnumberofchargingtype() < rhs.getU8Thetotalnumberofchargingtype()) return true;
        if (getU8Thetotalnumberofchargingtype() > rhs.getU8Thetotalnumberofchargingtype()) return false;
    }
    if (hasU8Userrestriction() || rhs.hasU8Userrestriction()) {
        if (getU8Userrestriction() < rhs.getU8Userrestriction()) return true;
        if (getU8Userrestriction() > rhs.getU8Userrestriction()) return false;
    }
    return false;
}

inline bool T_tcu_charging_spot_data::operator > (const T_tcu_charging_spot_data& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_tcu_charging_spot_data::clear() {
    clearLocation();
    clearStrAreaCode1();
    clearStrAreaCode2();
    clearStrAreaCode3();
    clearStrAreaCode4();
    clearStrAreaCode5();
    clearStrAreaCode6();
    clearStrAreaCode7();
    clearStrAreaCode8();
    clearStrPOIName();
    clearStrStreetAndHouseNo();
    clearStrTelephonenumber();
    clearU16Categorycode();
    clearU16ClosedhourInformation();
    clearU16OpeninghourInformation();
    clearU16Parkingnumber();
    clearU16Paymenttypeinformation();
    clearU16Sizeofdetailinformation();
    clearU16Subcategorycode();
    clearU32POIID();
    clearU32UserrestrictionID();
    clearU8_24hoursadayinformation();
    clearU8Businessdayoftheweekinformation();
    clearU8Chargingfeeinformation();
    clearU8Chargingtype();
    clearU8Detailsinformation();
    clearU8Entranceinformation();
    clearU8Expresswaygeneraltype();
    clearU8Fixedvalue1();
    clearU8Fixedvalue2();
    clearU8Informationreliability();
    clearU8Installationfacilityinformation();
    clearU8Nearthefacilityinformation();
    clearU8Officehoursunknowninformation();
    clearU8Partnersfacilityinformation();
    clearU8SizeOfPOIName();
    clearU8SizeOfStreetAndHouseNo();
    clearU8SizeOfTelephonenumber();
    clearU8Thenumberofentranceinformation();
    clearU8Thenumberofinstallationfacilityinformation();
    clearU8Thenumberofpartnersfacilityinformation();
    clearU8Thetotalnumberofchargingtype();
    clearU8Userrestriction();
}

inline void T_tcu_charging_spot_data::clearLocation() {
    if (hasLocation()) {
         clear_has_Location();
        _Location.clear();
     }
}

inline bool T_tcu_charging_spot_data::hasLocation () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const T_usb_tcu_Location& T_tcu_charging_spot_data::getLocation () const {
    return _Location;
}

inline T_usb_tcu_Location& T_tcu_charging_spot_data::getLocationMutable () {
    set_has_Location();
    return _Location;
}

inline void T_tcu_charging_spot_data::setLocation (const T_usb_tcu_Location& Location_) {
    set_has_Location();
    this->_Location = Location_;
}

inline void T_tcu_charging_spot_data::clearStrAreaCode1() {
    if (hasStrAreaCode1()) {
         clear_has_strAreaCode1();
        _strAreaCode1.clear();
     }
}

inline bool T_tcu_charging_spot_data::hasStrAreaCode1 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_tcu_charging_spot_data::getStrAreaCode1 () const {
    return _strAreaCode1;
}

inline ::std::string& T_tcu_charging_spot_data::getStrAreaCode1Mutable () {
    set_has_strAreaCode1();
    return _strAreaCode1;
}

inline void T_tcu_charging_spot_data::setStrAreaCode1 (const ::std::string& strAreaCode1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strAreaCode1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strAreaCode1();
    this->_strAreaCode1 = strAreaCode1_;
}

inline void T_tcu_charging_spot_data::setStrAreaCode1 (const char* strAreaCode1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strAreaCode1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strAreaCode1();
    this->_strAreaCode1.assign(strAreaCode1_);
}

inline void T_tcu_charging_spot_data::setStrAreaCode1 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strAreaCode1();
    this->_strAreaCode1.assign(value, size);
}

inline void T_tcu_charging_spot_data::clearStrAreaCode2() {
    if (hasStrAreaCode2()) {
         clear_has_strAreaCode2();
        _strAreaCode2.clear();
     }
}

inline bool T_tcu_charging_spot_data::hasStrAreaCode2 () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& T_tcu_charging_spot_data::getStrAreaCode2 () const {
    return _strAreaCode2;
}

inline ::std::string& T_tcu_charging_spot_data::getStrAreaCode2Mutable () {
    set_has_strAreaCode2();
    return _strAreaCode2;
}

inline void T_tcu_charging_spot_data::setStrAreaCode2 (const ::std::string& strAreaCode2_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strAreaCode2_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strAreaCode2();
    this->_strAreaCode2 = strAreaCode2_;
}

inline void T_tcu_charging_spot_data::setStrAreaCode2 (const char* strAreaCode2_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strAreaCode2_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strAreaCode2();
    this->_strAreaCode2.assign(strAreaCode2_);
}

inline void T_tcu_charging_spot_data::setStrAreaCode2 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strAreaCode2();
    this->_strAreaCode2.assign(value, size);
}

inline void T_tcu_charging_spot_data::clearStrAreaCode3() {
    if (hasStrAreaCode3()) {
         clear_has_strAreaCode3();
        _strAreaCode3.clear();
     }
}

inline bool T_tcu_charging_spot_data::hasStrAreaCode3 () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& T_tcu_charging_spot_data::getStrAreaCode3 () const {
    return _strAreaCode3;
}

inline ::std::string& T_tcu_charging_spot_data::getStrAreaCode3Mutable () {
    set_has_strAreaCode3();
    return _strAreaCode3;
}

inline void T_tcu_charging_spot_data::setStrAreaCode3 (const ::std::string& strAreaCode3_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strAreaCode3_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strAreaCode3();
    this->_strAreaCode3 = strAreaCode3_;
}

inline void T_tcu_charging_spot_data::setStrAreaCode3 (const char* strAreaCode3_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strAreaCode3_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strAreaCode3();
    this->_strAreaCode3.assign(strAreaCode3_);
}

inline void T_tcu_charging_spot_data::setStrAreaCode3 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strAreaCode3();
    this->_strAreaCode3.assign(value, size);
}

inline void T_tcu_charging_spot_data::clearStrAreaCode4() {
    if (hasStrAreaCode4()) {
         clear_has_strAreaCode4();
        _strAreaCode4.clear();
     }
}

inline bool T_tcu_charging_spot_data::hasStrAreaCode4 () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& T_tcu_charging_spot_data::getStrAreaCode4 () const {
    return _strAreaCode4;
}

inline ::std::string& T_tcu_charging_spot_data::getStrAreaCode4Mutable () {
    set_has_strAreaCode4();
    return _strAreaCode4;
}

inline void T_tcu_charging_spot_data::setStrAreaCode4 (const ::std::string& strAreaCode4_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strAreaCode4_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strAreaCode4();
    this->_strAreaCode4 = strAreaCode4_;
}

inline void T_tcu_charging_spot_data::setStrAreaCode4 (const char* strAreaCode4_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strAreaCode4_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strAreaCode4();
    this->_strAreaCode4.assign(strAreaCode4_);
}

inline void T_tcu_charging_spot_data::setStrAreaCode4 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strAreaCode4();
    this->_strAreaCode4.assign(value, size);
}

inline void T_tcu_charging_spot_data::clearStrAreaCode5() {
    if (hasStrAreaCode5()) {
         clear_has_strAreaCode5();
        _strAreaCode5.clear();
     }
}

inline bool T_tcu_charging_spot_data::hasStrAreaCode5 () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::std::string& T_tcu_charging_spot_data::getStrAreaCode5 () const {
    return _strAreaCode5;
}

inline ::std::string& T_tcu_charging_spot_data::getStrAreaCode5Mutable () {
    set_has_strAreaCode5();
    return _strAreaCode5;
}

inline void T_tcu_charging_spot_data::setStrAreaCode5 (const ::std::string& strAreaCode5_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strAreaCode5_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strAreaCode5();
    this->_strAreaCode5 = strAreaCode5_;
}

inline void T_tcu_charging_spot_data::setStrAreaCode5 (const char* strAreaCode5_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strAreaCode5_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strAreaCode5();
    this->_strAreaCode5.assign(strAreaCode5_);
}

inline void T_tcu_charging_spot_data::setStrAreaCode5 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strAreaCode5();
    this->_strAreaCode5.assign(value, size);
}

inline void T_tcu_charging_spot_data::clearStrAreaCode6() {
    if (hasStrAreaCode6()) {
         clear_has_strAreaCode6();
        _strAreaCode6.clear();
     }
}

inline bool T_tcu_charging_spot_data::hasStrAreaCode6 () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline const ::std::string& T_tcu_charging_spot_data::getStrAreaCode6 () const {
    return _strAreaCode6;
}

inline ::std::string& T_tcu_charging_spot_data::getStrAreaCode6Mutable () {
    set_has_strAreaCode6();
    return _strAreaCode6;
}

inline void T_tcu_charging_spot_data::setStrAreaCode6 (const ::std::string& strAreaCode6_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strAreaCode6_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strAreaCode6();
    this->_strAreaCode6 = strAreaCode6_;
}

inline void T_tcu_charging_spot_data::setStrAreaCode6 (const char* strAreaCode6_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strAreaCode6_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strAreaCode6();
    this->_strAreaCode6.assign(strAreaCode6_);
}

inline void T_tcu_charging_spot_data::setStrAreaCode6 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strAreaCode6();
    this->_strAreaCode6.assign(value, size);
}

inline void T_tcu_charging_spot_data::clearStrAreaCode7() {
    if (hasStrAreaCode7()) {
         clear_has_strAreaCode7();
        _strAreaCode7.clear();
     }
}

inline bool T_tcu_charging_spot_data::hasStrAreaCode7 () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline const ::std::string& T_tcu_charging_spot_data::getStrAreaCode7 () const {
    return _strAreaCode7;
}

inline ::std::string& T_tcu_charging_spot_data::getStrAreaCode7Mutable () {
    set_has_strAreaCode7();
    return _strAreaCode7;
}

inline void T_tcu_charging_spot_data::setStrAreaCode7 (const ::std::string& strAreaCode7_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strAreaCode7_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strAreaCode7();
    this->_strAreaCode7 = strAreaCode7_;
}

inline void T_tcu_charging_spot_data::setStrAreaCode7 (const char* strAreaCode7_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strAreaCode7_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strAreaCode7();
    this->_strAreaCode7.assign(strAreaCode7_);
}

inline void T_tcu_charging_spot_data::setStrAreaCode7 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strAreaCode7();
    this->_strAreaCode7.assign(value, size);
}

inline void T_tcu_charging_spot_data::clearStrAreaCode8() {
    if (hasStrAreaCode8()) {
         clear_has_strAreaCode8();
        _strAreaCode8.clear();
     }
}

inline bool T_tcu_charging_spot_data::hasStrAreaCode8 () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline const ::std::string& T_tcu_charging_spot_data::getStrAreaCode8 () const {
    return _strAreaCode8;
}

inline ::std::string& T_tcu_charging_spot_data::getStrAreaCode8Mutable () {
    set_has_strAreaCode8();
    return _strAreaCode8;
}

inline void T_tcu_charging_spot_data::setStrAreaCode8 (const ::std::string& strAreaCode8_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strAreaCode8_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strAreaCode8();
    this->_strAreaCode8 = strAreaCode8_;
}

inline void T_tcu_charging_spot_data::setStrAreaCode8 (const char* strAreaCode8_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strAreaCode8_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strAreaCode8();
    this->_strAreaCode8.assign(strAreaCode8_);
}

inline void T_tcu_charging_spot_data::setStrAreaCode8 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strAreaCode8();
    this->_strAreaCode8.assign(value, size);
}

inline void T_tcu_charging_spot_data::clearStrPOIName() {
    if (hasStrPOIName()) {
         clear_has_strPOIName();
        _strPOIName.clear();
     }
}

inline bool T_tcu_charging_spot_data::hasStrPOIName () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline const ::std::string& T_tcu_charging_spot_data::getStrPOIName () const {
    return _strPOIName;
}

inline ::std::string& T_tcu_charging_spot_data::getStrPOINameMutable () {
    set_has_strPOIName();
    return _strPOIName;
}

inline void T_tcu_charging_spot_data::setStrPOIName (const ::std::string& strPOIName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strPOIName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strPOIName();
    this->_strPOIName = strPOIName_;
}

inline void T_tcu_charging_spot_data::setStrPOIName (const char* strPOIName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strPOIName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strPOIName();
    this->_strPOIName.assign(strPOIName_);
}

inline void T_tcu_charging_spot_data::setStrPOIName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strPOIName();
    this->_strPOIName.assign(value, size);
}

inline void T_tcu_charging_spot_data::clearStrStreetAndHouseNo() {
    if (hasStrStreetAndHouseNo()) {
         clear_has_strStreetAndHouseNo();
        _strStreetAndHouseNo.clear();
     }
}

inline bool T_tcu_charging_spot_data::hasStrStreetAndHouseNo () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline const ::std::string& T_tcu_charging_spot_data::getStrStreetAndHouseNo () const {
    return _strStreetAndHouseNo;
}

inline ::std::string& T_tcu_charging_spot_data::getStrStreetAndHouseNoMutable () {
    set_has_strStreetAndHouseNo();
    return _strStreetAndHouseNo;
}

inline void T_tcu_charging_spot_data::setStrStreetAndHouseNo (const ::std::string& strStreetAndHouseNo_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strStreetAndHouseNo_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strStreetAndHouseNo();
    this->_strStreetAndHouseNo = strStreetAndHouseNo_;
}

inline void T_tcu_charging_spot_data::setStrStreetAndHouseNo (const char* strStreetAndHouseNo_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strStreetAndHouseNo_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strStreetAndHouseNo();
    this->_strStreetAndHouseNo.assign(strStreetAndHouseNo_);
}

inline void T_tcu_charging_spot_data::setStrStreetAndHouseNo (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strStreetAndHouseNo();
    this->_strStreetAndHouseNo.assign(value, size);
}

inline void T_tcu_charging_spot_data::clearStrTelephonenumber() {
    if (hasStrTelephonenumber()) {
         clear_has_strTelephonenumber();
        _strTelephonenumber.clear();
     }
}

inline bool T_tcu_charging_spot_data::hasStrTelephonenumber () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline const ::std::string& T_tcu_charging_spot_data::getStrTelephonenumber () const {
    return _strTelephonenumber;
}

inline ::std::string& T_tcu_charging_spot_data::getStrTelephonenumberMutable () {
    set_has_strTelephonenumber();
    return _strTelephonenumber;
}

inline void T_tcu_charging_spot_data::setStrTelephonenumber (const ::std::string& strTelephonenumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strTelephonenumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strTelephonenumber();
    this->_strTelephonenumber = strTelephonenumber_;
}

inline void T_tcu_charging_spot_data::setStrTelephonenumber (const char* strTelephonenumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strTelephonenumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strTelephonenumber();
    this->_strTelephonenumber.assign(strTelephonenumber_);
}

inline void T_tcu_charging_spot_data::setStrTelephonenumber (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strTelephonenumber();
    this->_strTelephonenumber.assign(value, size);
}

inline void T_tcu_charging_spot_data::clearU16Categorycode() {
    if (hasU16Categorycode()) {
         clear_has_u16Categorycode();
        _u16Categorycode = 0u;
     }
}

inline bool T_tcu_charging_spot_data::hasU16Categorycode () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline uint16 T_tcu_charging_spot_data::getU16Categorycode () const {
    return _u16Categorycode;
}

inline void T_tcu_charging_spot_data::setU16Categorycode (uint16 u16Categorycode_) {
    set_has_u16Categorycode();
    this->_u16Categorycode = u16Categorycode_;
}

inline void T_tcu_charging_spot_data::clearU16ClosedhourInformation() {
    if (hasU16ClosedhourInformation()) {
         clear_has_u16ClosedhourInformation();
        _u16ClosedhourInformation = 0u;
     }
}

inline bool T_tcu_charging_spot_data::hasU16ClosedhourInformation () const {
    return (_has_bits_[0] & (1u << 13)) > 0;
}

inline uint16 T_tcu_charging_spot_data::getU16ClosedhourInformation () const {
    return _u16ClosedhourInformation;
}

inline void T_tcu_charging_spot_data::setU16ClosedhourInformation (uint16 u16ClosedhourInformation_) {
    set_has_u16ClosedhourInformation();
    this->_u16ClosedhourInformation = u16ClosedhourInformation_;
}

inline void T_tcu_charging_spot_data::clearU16OpeninghourInformation() {
    if (hasU16OpeninghourInformation()) {
         clear_has_u16OpeninghourInformation();
        _u16OpeninghourInformation = 0u;
     }
}

inline bool T_tcu_charging_spot_data::hasU16OpeninghourInformation () const {
    return (_has_bits_[0] & (1u << 14)) > 0;
}

inline uint16 T_tcu_charging_spot_data::getU16OpeninghourInformation () const {
    return _u16OpeninghourInformation;
}

inline void T_tcu_charging_spot_data::setU16OpeninghourInformation (uint16 u16OpeninghourInformation_) {
    set_has_u16OpeninghourInformation();
    this->_u16OpeninghourInformation = u16OpeninghourInformation_;
}

inline void T_tcu_charging_spot_data::clearU16Parkingnumber() {
    if (hasU16Parkingnumber()) {
         clear_has_u16Parkingnumber();
        _u16Parkingnumber = 0u;
     }
}

inline bool T_tcu_charging_spot_data::hasU16Parkingnumber () const {
    return (_has_bits_[0] & (1u << 15)) > 0;
}

inline uint16 T_tcu_charging_spot_data::getU16Parkingnumber () const {
    return _u16Parkingnumber;
}

inline void T_tcu_charging_spot_data::setU16Parkingnumber (uint16 u16Parkingnumber_) {
    set_has_u16Parkingnumber();
    this->_u16Parkingnumber = u16Parkingnumber_;
}

inline void T_tcu_charging_spot_data::clearU16Paymenttypeinformation() {
    if (hasU16Paymenttypeinformation()) {
         clear_has_u16Paymenttypeinformation();
        _u16Paymenttypeinformation = 0u;
     }
}

inline bool T_tcu_charging_spot_data::hasU16Paymenttypeinformation () const {
    return (_has_bits_[0] & (1u << 16)) > 0;
}

inline uint16 T_tcu_charging_spot_data::getU16Paymenttypeinformation () const {
    return _u16Paymenttypeinformation;
}

inline void T_tcu_charging_spot_data::setU16Paymenttypeinformation (uint16 u16Paymenttypeinformation_) {
    set_has_u16Paymenttypeinformation();
    this->_u16Paymenttypeinformation = u16Paymenttypeinformation_;
}

inline void T_tcu_charging_spot_data::clearU16Sizeofdetailinformation() {
    if (hasU16Sizeofdetailinformation()) {
         clear_has_u16Sizeofdetailinformation();
        _u16Sizeofdetailinformation = 0u;
     }
}

inline bool T_tcu_charging_spot_data::hasU16Sizeofdetailinformation () const {
    return (_has_bits_[0] & (1u << 17)) > 0;
}

inline uint16 T_tcu_charging_spot_data::getU16Sizeofdetailinformation () const {
    return _u16Sizeofdetailinformation;
}

inline void T_tcu_charging_spot_data::setU16Sizeofdetailinformation (uint16 u16Sizeofdetailinformation_) {
    set_has_u16Sizeofdetailinformation();
    this->_u16Sizeofdetailinformation = u16Sizeofdetailinformation_;
}

inline void T_tcu_charging_spot_data::clearU16Subcategorycode() {
    if (hasU16Subcategorycode()) {
         clear_has_u16Subcategorycode();
        _u16Subcategorycode = 0u;
     }
}

inline bool T_tcu_charging_spot_data::hasU16Subcategorycode () const {
    return (_has_bits_[0] & (1u << 18)) > 0;
}

inline uint16 T_tcu_charging_spot_data::getU16Subcategorycode () const {
    return _u16Subcategorycode;
}

inline void T_tcu_charging_spot_data::setU16Subcategorycode (uint16 u16Subcategorycode_) {
    set_has_u16Subcategorycode();
    this->_u16Subcategorycode = u16Subcategorycode_;
}

inline void T_tcu_charging_spot_data::clearU32POIID() {
    if (hasU32POIID()) {
         clear_has_u32POIID();
        _u32POIID = 0u;
     }
}

inline bool T_tcu_charging_spot_data::hasU32POIID () const {
    return (_has_bits_[0] & (1u << 19)) > 0;
}

inline uint32 T_tcu_charging_spot_data::getU32POIID () const {
    return _u32POIID;
}

inline void T_tcu_charging_spot_data::setU32POIID (uint32 u32POIID_) {
    set_has_u32POIID();
    this->_u32POIID = u32POIID_;
}

inline void T_tcu_charging_spot_data::clearU32UserrestrictionID() {
    if (hasU32UserrestrictionID()) {
         clear_has_u32UserrestrictionID();
        _u32UserrestrictionID = 0u;
     }
}

inline bool T_tcu_charging_spot_data::hasU32UserrestrictionID () const {
    return (_has_bits_[0] & (1u << 20)) > 0;
}

inline uint32 T_tcu_charging_spot_data::getU32UserrestrictionID () const {
    return _u32UserrestrictionID;
}

inline void T_tcu_charging_spot_data::setU32UserrestrictionID (uint32 u32UserrestrictionID_) {
    set_has_u32UserrestrictionID();
    this->_u32UserrestrictionID = u32UserrestrictionID_;
}

inline void T_tcu_charging_spot_data::clearU8_24hoursadayinformation() {
    if (hasU8_24hoursadayinformation()) {
         clear_has_u8_24hoursadayinformation();
        _u8_24hoursadayinformation = 0u;
     }
}

inline bool T_tcu_charging_spot_data::hasU8_24hoursadayinformation () const {
    return (_has_bits_[0] & (1u << 21)) > 0;
}

inline uint8 T_tcu_charging_spot_data::getU8_24hoursadayinformation () const {
    return _u8_24hoursadayinformation;
}

inline void T_tcu_charging_spot_data::setU8_24hoursadayinformation (uint8 u8_24hoursadayinformation_) {
    set_has_u8_24hoursadayinformation();
    this->_u8_24hoursadayinformation = u8_24hoursadayinformation_;
}

inline void T_tcu_charging_spot_data::clearU8Businessdayoftheweekinformation() {
    if (hasU8Businessdayoftheweekinformation()) {
         clear_has_u8Businessdayoftheweekinformation();
        _u8Businessdayoftheweekinformation = 0u;
     }
}

inline bool T_tcu_charging_spot_data::hasU8Businessdayoftheweekinformation () const {
    return (_has_bits_[0] & (1u << 22)) > 0;
}

inline uint8 T_tcu_charging_spot_data::getU8Businessdayoftheweekinformation () const {
    return _u8Businessdayoftheweekinformation;
}

inline void T_tcu_charging_spot_data::setU8Businessdayoftheweekinformation (uint8 u8Businessdayoftheweekinformation_) {
    set_has_u8Businessdayoftheweekinformation();
    this->_u8Businessdayoftheweekinformation = u8Businessdayoftheweekinformation_;
}

inline void T_tcu_charging_spot_data::clearU8Chargingfeeinformation() {
    if (hasU8Chargingfeeinformation()) {
         clear_has_u8Chargingfeeinformation();
        _u8Chargingfeeinformation = 0u;
     }
}

inline bool T_tcu_charging_spot_data::hasU8Chargingfeeinformation () const {
    return (_has_bits_[0] & (1u << 23)) > 0;
}

inline uint8 T_tcu_charging_spot_data::getU8Chargingfeeinformation () const {
    return _u8Chargingfeeinformation;
}

inline void T_tcu_charging_spot_data::setU8Chargingfeeinformation (uint8 u8Chargingfeeinformation_) {
    set_has_u8Chargingfeeinformation();
    this->_u8Chargingfeeinformation = u8Chargingfeeinformation_;
}

inline void T_tcu_charging_spot_data::clearU8Chargingtype() {
    if (hasU8Chargingtype()) {
         clear_has_u8Chargingtype();
        _u8Chargingtype = 0u;
     }
}

inline bool T_tcu_charging_spot_data::hasU8Chargingtype () const {
    return (_has_bits_[0] & (1u << 24)) > 0;
}

inline uint8 T_tcu_charging_spot_data::getU8Chargingtype () const {
    return _u8Chargingtype;
}

inline void T_tcu_charging_spot_data::setU8Chargingtype (uint8 u8Chargingtype_) {
    set_has_u8Chargingtype();
    this->_u8Chargingtype = u8Chargingtype_;
}

inline void T_tcu_charging_spot_data::clearU8Detailsinformation() {
    if (hasU8Detailsinformation()) {
         clear_has_u8Detailsinformation();
        _u8Detailsinformation = 0u;
     }
}

inline bool T_tcu_charging_spot_data::hasU8Detailsinformation () const {
    return (_has_bits_[0] & (1u << 25)) > 0;
}

inline uint8 T_tcu_charging_spot_data::getU8Detailsinformation () const {
    return _u8Detailsinformation;
}

inline void T_tcu_charging_spot_data::setU8Detailsinformation (uint8 u8Detailsinformation_) {
    set_has_u8Detailsinformation();
    this->_u8Detailsinformation = u8Detailsinformation_;
}

inline void T_tcu_charging_spot_data::clearU8Entranceinformation() {
    if (hasU8Entranceinformation()) {
         clear_has_u8Entranceinformation();
        _u8Entranceinformation = 0u;
     }
}

inline bool T_tcu_charging_spot_data::hasU8Entranceinformation () const {
    return (_has_bits_[0] & (1u << 26)) > 0;
}

inline uint8 T_tcu_charging_spot_data::getU8Entranceinformation () const {
    return _u8Entranceinformation;
}

inline void T_tcu_charging_spot_data::setU8Entranceinformation (uint8 u8Entranceinformation_) {
    set_has_u8Entranceinformation();
    this->_u8Entranceinformation = u8Entranceinformation_;
}

inline void T_tcu_charging_spot_data::clearU8Expresswaygeneraltype() {
    if (hasU8Expresswaygeneraltype()) {
         clear_has_u8Expresswaygeneraltype();
        _u8Expresswaygeneraltype = 0u;
     }
}

inline bool T_tcu_charging_spot_data::hasU8Expresswaygeneraltype () const {
    return (_has_bits_[0] & (1u << 27)) > 0;
}

inline uint8 T_tcu_charging_spot_data::getU8Expresswaygeneraltype () const {
    return _u8Expresswaygeneraltype;
}

inline void T_tcu_charging_spot_data::setU8Expresswaygeneraltype (uint8 u8Expresswaygeneraltype_) {
    set_has_u8Expresswaygeneraltype();
    this->_u8Expresswaygeneraltype = u8Expresswaygeneraltype_;
}

inline void T_tcu_charging_spot_data::clearU8Fixedvalue1() {
    if (hasU8Fixedvalue1()) {
         clear_has_u8Fixedvalue1();
        _u8Fixedvalue1 = 0u;
     }
}

inline bool T_tcu_charging_spot_data::hasU8Fixedvalue1 () const {
    return (_has_bits_[0] & (1u << 28)) > 0;
}

inline uint8 T_tcu_charging_spot_data::getU8Fixedvalue1 () const {
    return _u8Fixedvalue1;
}

inline void T_tcu_charging_spot_data::setU8Fixedvalue1 (uint8 u8Fixedvalue1_) {
    set_has_u8Fixedvalue1();
    this->_u8Fixedvalue1 = u8Fixedvalue1_;
}

inline void T_tcu_charging_spot_data::clearU8Fixedvalue2() {
    if (hasU8Fixedvalue2()) {
         clear_has_u8Fixedvalue2();
        _u8Fixedvalue2 = 0u;
     }
}

inline bool T_tcu_charging_spot_data::hasU8Fixedvalue2 () const {
    return (_has_bits_[0] & (1u << 29)) > 0;
}

inline uint8 T_tcu_charging_spot_data::getU8Fixedvalue2 () const {
    return _u8Fixedvalue2;
}

inline void T_tcu_charging_spot_data::setU8Fixedvalue2 (uint8 u8Fixedvalue2_) {
    set_has_u8Fixedvalue2();
    this->_u8Fixedvalue2 = u8Fixedvalue2_;
}

inline void T_tcu_charging_spot_data::clearU8Informationreliability() {
    if (hasU8Informationreliability()) {
         clear_has_u8Informationreliability();
        _u8Informationreliability = 0u;
     }
}

inline bool T_tcu_charging_spot_data::hasU8Informationreliability () const {
    return (_has_bits_[0] & (1u << 30)) > 0;
}

inline uint8 T_tcu_charging_spot_data::getU8Informationreliability () const {
    return _u8Informationreliability;
}

inline void T_tcu_charging_spot_data::setU8Informationreliability (uint8 u8Informationreliability_) {
    set_has_u8Informationreliability();
    this->_u8Informationreliability = u8Informationreliability_;
}

inline void T_tcu_charging_spot_data::clearU8Installationfacilityinformation() {
    if (hasU8Installationfacilityinformation()) {
         clear_has_u8Installationfacilityinformation();
        _u8Installationfacilityinformation = 0u;
     }
}

inline bool T_tcu_charging_spot_data::hasU8Installationfacilityinformation () const {
    return (_has_bits_[0] & (1u << 31)) > 0;
}

inline uint8 T_tcu_charging_spot_data::getU8Installationfacilityinformation () const {
    return _u8Installationfacilityinformation;
}

inline void T_tcu_charging_spot_data::setU8Installationfacilityinformation (uint8 u8Installationfacilityinformation_) {
    set_has_u8Installationfacilityinformation();
    this->_u8Installationfacilityinformation = u8Installationfacilityinformation_;
}

inline void T_tcu_charging_spot_data::clearU8Nearthefacilityinformation() {
    if (hasU8Nearthefacilityinformation()) {
         clear_has_u8Nearthefacilityinformation();
        _u8Nearthefacilityinformation = 0u;
     }
}

inline bool T_tcu_charging_spot_data::hasU8Nearthefacilityinformation () const {
    return (_has_bits_[1] & (1u << 0)) > 0;
}

inline uint8 T_tcu_charging_spot_data::getU8Nearthefacilityinformation () const {
    return _u8Nearthefacilityinformation;
}

inline void T_tcu_charging_spot_data::setU8Nearthefacilityinformation (uint8 u8Nearthefacilityinformation_) {
    set_has_u8Nearthefacilityinformation();
    this->_u8Nearthefacilityinformation = u8Nearthefacilityinformation_;
}

inline void T_tcu_charging_spot_data::clearU8Officehoursunknowninformation() {
    if (hasU8Officehoursunknowninformation()) {
         clear_has_u8Officehoursunknowninformation();
        _u8Officehoursunknowninformation = 0u;
     }
}

inline bool T_tcu_charging_spot_data::hasU8Officehoursunknowninformation () const {
    return (_has_bits_[1] & (1u << 1)) > 0;
}

inline uint8 T_tcu_charging_spot_data::getU8Officehoursunknowninformation () const {
    return _u8Officehoursunknowninformation;
}

inline void T_tcu_charging_spot_data::setU8Officehoursunknowninformation (uint8 u8Officehoursunknowninformation_) {
    set_has_u8Officehoursunknowninformation();
    this->_u8Officehoursunknowninformation = u8Officehoursunknowninformation_;
}

inline void T_tcu_charging_spot_data::clearU8Partnersfacilityinformation() {
    if (hasU8Partnersfacilityinformation()) {
         clear_has_u8Partnersfacilityinformation();
        _u8Partnersfacilityinformation = 0u;
     }
}

inline bool T_tcu_charging_spot_data::hasU8Partnersfacilityinformation () const {
    return (_has_bits_[1] & (1u << 2)) > 0;
}

inline uint8 T_tcu_charging_spot_data::getU8Partnersfacilityinformation () const {
    return _u8Partnersfacilityinformation;
}

inline void T_tcu_charging_spot_data::setU8Partnersfacilityinformation (uint8 u8Partnersfacilityinformation_) {
    set_has_u8Partnersfacilityinformation();
    this->_u8Partnersfacilityinformation = u8Partnersfacilityinformation_;
}

inline void T_tcu_charging_spot_data::clearU8SizeOfPOIName() {
    if (hasU8SizeOfPOIName()) {
         clear_has_u8SizeOfPOIName();
        _u8SizeOfPOIName = 0u;
     }
}

inline bool T_tcu_charging_spot_data::hasU8SizeOfPOIName () const {
    return (_has_bits_[1] & (1u << 3)) > 0;
}

inline uint8 T_tcu_charging_spot_data::getU8SizeOfPOIName () const {
    return _u8SizeOfPOIName;
}

inline void T_tcu_charging_spot_data::setU8SizeOfPOIName (uint8 u8SizeOfPOIName_) {
    set_has_u8SizeOfPOIName();
    this->_u8SizeOfPOIName = u8SizeOfPOIName_;
}

inline void T_tcu_charging_spot_data::clearU8SizeOfStreetAndHouseNo() {
    if (hasU8SizeOfStreetAndHouseNo()) {
         clear_has_u8SizeOfStreetAndHouseNo();
        _u8SizeOfStreetAndHouseNo = 0u;
     }
}

inline bool T_tcu_charging_spot_data::hasU8SizeOfStreetAndHouseNo () const {
    return (_has_bits_[1] & (1u << 4)) > 0;
}

inline uint8 T_tcu_charging_spot_data::getU8SizeOfStreetAndHouseNo () const {
    return _u8SizeOfStreetAndHouseNo;
}

inline void T_tcu_charging_spot_data::setU8SizeOfStreetAndHouseNo (uint8 u8SizeOfStreetAndHouseNo_) {
    set_has_u8SizeOfStreetAndHouseNo();
    this->_u8SizeOfStreetAndHouseNo = u8SizeOfStreetAndHouseNo_;
}

inline void T_tcu_charging_spot_data::clearU8SizeOfTelephonenumber() {
    if (hasU8SizeOfTelephonenumber()) {
         clear_has_u8SizeOfTelephonenumber();
        _u8SizeOfTelephonenumber = 0u;
     }
}

inline bool T_tcu_charging_spot_data::hasU8SizeOfTelephonenumber () const {
    return (_has_bits_[1] & (1u << 5)) > 0;
}

inline uint8 T_tcu_charging_spot_data::getU8SizeOfTelephonenumber () const {
    return _u8SizeOfTelephonenumber;
}

inline void T_tcu_charging_spot_data::setU8SizeOfTelephonenumber (uint8 u8SizeOfTelephonenumber_) {
    set_has_u8SizeOfTelephonenumber();
    this->_u8SizeOfTelephonenumber = u8SizeOfTelephonenumber_;
}

inline void T_tcu_charging_spot_data::clearU8Thenumberofentranceinformation() {
    if (hasU8Thenumberofentranceinformation()) {
         clear_has_u8Thenumberofentranceinformation();
        _u8Thenumberofentranceinformation = 0u;
     }
}

inline bool T_tcu_charging_spot_data::hasU8Thenumberofentranceinformation () const {
    return (_has_bits_[1] & (1u << 6)) > 0;
}

inline uint8 T_tcu_charging_spot_data::getU8Thenumberofentranceinformation () const {
    return _u8Thenumberofentranceinformation;
}

inline void T_tcu_charging_spot_data::setU8Thenumberofentranceinformation (uint8 u8Thenumberofentranceinformation_) {
    set_has_u8Thenumberofentranceinformation();
    this->_u8Thenumberofentranceinformation = u8Thenumberofentranceinformation_;
}

inline void T_tcu_charging_spot_data::clearU8Thenumberofinstallationfacilityinformation() {
    if (hasU8Thenumberofinstallationfacilityinformation()) {
         clear_has_u8Thenumberofinstallationfacilityinformation();
        _u8Thenumberofinstallationfacilityinformation = 0u;
     }
}

inline bool T_tcu_charging_spot_data::hasU8Thenumberofinstallationfacilityinformation () const {
    return (_has_bits_[1] & (1u << 7)) > 0;
}

inline uint8 T_tcu_charging_spot_data::getU8Thenumberofinstallationfacilityinformation () const {
    return _u8Thenumberofinstallationfacilityinformation;
}

inline void T_tcu_charging_spot_data::setU8Thenumberofinstallationfacilityinformation (uint8 u8Thenumberofinstallationfacilityinformation_) {
    set_has_u8Thenumberofinstallationfacilityinformation();
    this->_u8Thenumberofinstallationfacilityinformation = u8Thenumberofinstallationfacilityinformation_;
}

inline void T_tcu_charging_spot_data::clearU8Thenumberofpartnersfacilityinformation() {
    if (hasU8Thenumberofpartnersfacilityinformation()) {
         clear_has_u8Thenumberofpartnersfacilityinformation();
        _u8Thenumberofpartnersfacilityinformation = 0u;
     }
}

inline bool T_tcu_charging_spot_data::hasU8Thenumberofpartnersfacilityinformation () const {
    return (_has_bits_[1] & (1u << 8)) > 0;
}

inline uint8 T_tcu_charging_spot_data::getU8Thenumberofpartnersfacilityinformation () const {
    return _u8Thenumberofpartnersfacilityinformation;
}

inline void T_tcu_charging_spot_data::setU8Thenumberofpartnersfacilityinformation (uint8 u8Thenumberofpartnersfacilityinformation_) {
    set_has_u8Thenumberofpartnersfacilityinformation();
    this->_u8Thenumberofpartnersfacilityinformation = u8Thenumberofpartnersfacilityinformation_;
}

inline void T_tcu_charging_spot_data::clearU8Thetotalnumberofchargingtype() {
    if (hasU8Thetotalnumberofchargingtype()) {
         clear_has_u8Thetotalnumberofchargingtype();
        _u8Thetotalnumberofchargingtype = 0u;
     }
}

inline bool T_tcu_charging_spot_data::hasU8Thetotalnumberofchargingtype () const {
    return (_has_bits_[1] & (1u << 9)) > 0;
}

inline uint8 T_tcu_charging_spot_data::getU8Thetotalnumberofchargingtype () const {
    return _u8Thetotalnumberofchargingtype;
}

inline void T_tcu_charging_spot_data::setU8Thetotalnumberofchargingtype (uint8 u8Thetotalnumberofchargingtype_) {
    set_has_u8Thetotalnumberofchargingtype();
    this->_u8Thetotalnumberofchargingtype = u8Thetotalnumberofchargingtype_;
}

inline void T_tcu_charging_spot_data::clearU8Userrestriction() {
    if (hasU8Userrestriction()) {
         clear_has_u8Userrestriction();
        _u8Userrestriction = 0u;
     }
}

inline bool T_tcu_charging_spot_data::hasU8Userrestriction () const {
    return (_has_bits_[1] & (1u << 10)) > 0;
}

inline uint8 T_tcu_charging_spot_data::getU8Userrestriction () const {
    return _u8Userrestriction;
}

inline void T_tcu_charging_spot_data::setU8Userrestriction (uint8 u8Userrestriction_) {
    set_has_u8Userrestriction();
    this->_u8Userrestriction = u8Userrestriction_;
}

inline void T_tcu_charging_spot_data::set_has_Location () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_tcu_charging_spot_data::clear_has_Location () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_tcu_charging_spot_data::set_has_strAreaCode1 () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_tcu_charging_spot_data::clear_has_strAreaCode1 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_tcu_charging_spot_data::set_has_strAreaCode2 () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_tcu_charging_spot_data::clear_has_strAreaCode2 () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_tcu_charging_spot_data::set_has_strAreaCode3 () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_tcu_charging_spot_data::clear_has_strAreaCode3 () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_tcu_charging_spot_data::set_has_strAreaCode4 () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_tcu_charging_spot_data::clear_has_strAreaCode4 () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_tcu_charging_spot_data::set_has_strAreaCode5 () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_tcu_charging_spot_data::clear_has_strAreaCode5 () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_tcu_charging_spot_data::set_has_strAreaCode6 () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_tcu_charging_spot_data::clear_has_strAreaCode6 () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_tcu_charging_spot_data::set_has_strAreaCode7 () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_tcu_charging_spot_data::clear_has_strAreaCode7 () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_tcu_charging_spot_data::set_has_strAreaCode8 () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_tcu_charging_spot_data::clear_has_strAreaCode8 () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_tcu_charging_spot_data::set_has_strPOIName () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_tcu_charging_spot_data::clear_has_strPOIName () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_tcu_charging_spot_data::set_has_strStreetAndHouseNo () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_tcu_charging_spot_data::clear_has_strStreetAndHouseNo () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void T_tcu_charging_spot_data::set_has_strTelephonenumber () {
    _has_bits_[0] |= 1u << 11;
}

inline void T_tcu_charging_spot_data::clear_has_strTelephonenumber () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void T_tcu_charging_spot_data::set_has_u16Categorycode () {
    _has_bits_[0] |= 1u << 12;
}

inline void T_tcu_charging_spot_data::clear_has_u16Categorycode () {
    _has_bits_[0] &= ~ (1u << 12);
}

inline void T_tcu_charging_spot_data::set_has_u16ClosedhourInformation () {
    _has_bits_[0] |= 1u << 13;
}

inline void T_tcu_charging_spot_data::clear_has_u16ClosedhourInformation () {
    _has_bits_[0] &= ~ (1u << 13);
}

inline void T_tcu_charging_spot_data::set_has_u16OpeninghourInformation () {
    _has_bits_[0] |= 1u << 14;
}

inline void T_tcu_charging_spot_data::clear_has_u16OpeninghourInformation () {
    _has_bits_[0] &= ~ (1u << 14);
}

inline void T_tcu_charging_spot_data::set_has_u16Parkingnumber () {
    _has_bits_[0] |= 1u << 15;
}

inline void T_tcu_charging_spot_data::clear_has_u16Parkingnumber () {
    _has_bits_[0] &= ~ (1u << 15);
}

inline void T_tcu_charging_spot_data::set_has_u16Paymenttypeinformation () {
    _has_bits_[0] |= 1u << 16;
}

inline void T_tcu_charging_spot_data::clear_has_u16Paymenttypeinformation () {
    _has_bits_[0] &= ~ (1u << 16);
}

inline void T_tcu_charging_spot_data::set_has_u16Sizeofdetailinformation () {
    _has_bits_[0] |= 1u << 17;
}

inline void T_tcu_charging_spot_data::clear_has_u16Sizeofdetailinformation () {
    _has_bits_[0] &= ~ (1u << 17);
}

inline void T_tcu_charging_spot_data::set_has_u16Subcategorycode () {
    _has_bits_[0] |= 1u << 18;
}

inline void T_tcu_charging_spot_data::clear_has_u16Subcategorycode () {
    _has_bits_[0] &= ~ (1u << 18);
}

inline void T_tcu_charging_spot_data::set_has_u32POIID () {
    _has_bits_[0] |= 1u << 19;
}

inline void T_tcu_charging_spot_data::clear_has_u32POIID () {
    _has_bits_[0] &= ~ (1u << 19);
}

inline void T_tcu_charging_spot_data::set_has_u32UserrestrictionID () {
    _has_bits_[0] |= 1u << 20;
}

inline void T_tcu_charging_spot_data::clear_has_u32UserrestrictionID () {
    _has_bits_[0] &= ~ (1u << 20);
}

inline void T_tcu_charging_spot_data::set_has_u8_24hoursadayinformation () {
    _has_bits_[0] |= 1u << 21;
}

inline void T_tcu_charging_spot_data::clear_has_u8_24hoursadayinformation () {
    _has_bits_[0] &= ~ (1u << 21);
}

inline void T_tcu_charging_spot_data::set_has_u8Businessdayoftheweekinformation () {
    _has_bits_[0] |= 1u << 22;
}

inline void T_tcu_charging_spot_data::clear_has_u8Businessdayoftheweekinformation () {
    _has_bits_[0] &= ~ (1u << 22);
}

inline void T_tcu_charging_spot_data::set_has_u8Chargingfeeinformation () {
    _has_bits_[0] |= 1u << 23;
}

inline void T_tcu_charging_spot_data::clear_has_u8Chargingfeeinformation () {
    _has_bits_[0] &= ~ (1u << 23);
}

inline void T_tcu_charging_spot_data::set_has_u8Chargingtype () {
    _has_bits_[0] |= 1u << 24;
}

inline void T_tcu_charging_spot_data::clear_has_u8Chargingtype () {
    _has_bits_[0] &= ~ (1u << 24);
}

inline void T_tcu_charging_spot_data::set_has_u8Detailsinformation () {
    _has_bits_[0] |= 1u << 25;
}

inline void T_tcu_charging_spot_data::clear_has_u8Detailsinformation () {
    _has_bits_[0] &= ~ (1u << 25);
}

inline void T_tcu_charging_spot_data::set_has_u8Entranceinformation () {
    _has_bits_[0] |= 1u << 26;
}

inline void T_tcu_charging_spot_data::clear_has_u8Entranceinformation () {
    _has_bits_[0] &= ~ (1u << 26);
}

inline void T_tcu_charging_spot_data::set_has_u8Expresswaygeneraltype () {
    _has_bits_[0] |= 1u << 27;
}

inline void T_tcu_charging_spot_data::clear_has_u8Expresswaygeneraltype () {
    _has_bits_[0] &= ~ (1u << 27);
}

inline void T_tcu_charging_spot_data::set_has_u8Fixedvalue1 () {
    _has_bits_[0] |= 1u << 28;
}

inline void T_tcu_charging_spot_data::clear_has_u8Fixedvalue1 () {
    _has_bits_[0] &= ~ (1u << 28);
}

inline void T_tcu_charging_spot_data::set_has_u8Fixedvalue2 () {
    _has_bits_[0] |= 1u << 29;
}

inline void T_tcu_charging_spot_data::clear_has_u8Fixedvalue2 () {
    _has_bits_[0] &= ~ (1u << 29);
}

inline void T_tcu_charging_spot_data::set_has_u8Informationreliability () {
    _has_bits_[0] |= 1u << 30;
}

inline void T_tcu_charging_spot_data::clear_has_u8Informationreliability () {
    _has_bits_[0] &= ~ (1u << 30);
}

inline void T_tcu_charging_spot_data::set_has_u8Installationfacilityinformation () {
    _has_bits_[0] |= 1u << 31;
}

inline void T_tcu_charging_spot_data::clear_has_u8Installationfacilityinformation () {
    _has_bits_[0] &= ~ (1u << 31);
}

inline void T_tcu_charging_spot_data::set_has_u8Nearthefacilityinformation () {
    _has_bits_[1] |= 1u << 0;
}

inline void T_tcu_charging_spot_data::clear_has_u8Nearthefacilityinformation () {
    _has_bits_[1] &= ~ (1u << 0);
}

inline void T_tcu_charging_spot_data::set_has_u8Officehoursunknowninformation () {
    _has_bits_[1] |= 1u << 1;
}

inline void T_tcu_charging_spot_data::clear_has_u8Officehoursunknowninformation () {
    _has_bits_[1] &= ~ (1u << 1);
}

inline void T_tcu_charging_spot_data::set_has_u8Partnersfacilityinformation () {
    _has_bits_[1] |= 1u << 2;
}

inline void T_tcu_charging_spot_data::clear_has_u8Partnersfacilityinformation () {
    _has_bits_[1] &= ~ (1u << 2);
}

inline void T_tcu_charging_spot_data::set_has_u8SizeOfPOIName () {
    _has_bits_[1] |= 1u << 3;
}

inline void T_tcu_charging_spot_data::clear_has_u8SizeOfPOIName () {
    _has_bits_[1] &= ~ (1u << 3);
}

inline void T_tcu_charging_spot_data::set_has_u8SizeOfStreetAndHouseNo () {
    _has_bits_[1] |= 1u << 4;
}

inline void T_tcu_charging_spot_data::clear_has_u8SizeOfStreetAndHouseNo () {
    _has_bits_[1] &= ~ (1u << 4);
}

inline void T_tcu_charging_spot_data::set_has_u8SizeOfTelephonenumber () {
    _has_bits_[1] |= 1u << 5;
}

inline void T_tcu_charging_spot_data::clear_has_u8SizeOfTelephonenumber () {
    _has_bits_[1] &= ~ (1u << 5);
}

inline void T_tcu_charging_spot_data::set_has_u8Thenumberofentranceinformation () {
    _has_bits_[1] |= 1u << 6;
}

inline void T_tcu_charging_spot_data::clear_has_u8Thenumberofentranceinformation () {
    _has_bits_[1] &= ~ (1u << 6);
}

inline void T_tcu_charging_spot_data::set_has_u8Thenumberofinstallationfacilityinformation () {
    _has_bits_[1] |= 1u << 7;
}

inline void T_tcu_charging_spot_data::clear_has_u8Thenumberofinstallationfacilityinformation () {
    _has_bits_[1] &= ~ (1u << 7);
}

inline void T_tcu_charging_spot_data::set_has_u8Thenumberofpartnersfacilityinformation () {
    _has_bits_[1] |= 1u << 8;
}

inline void T_tcu_charging_spot_data::clear_has_u8Thenumberofpartnersfacilityinformation () {
    _has_bits_[1] &= ~ (1u << 8);
}

inline void T_tcu_charging_spot_data::set_has_u8Thetotalnumberofchargingtype () {
    _has_bits_[1] |= 1u << 9;
}

inline void T_tcu_charging_spot_data::clear_has_u8Thetotalnumberofchargingtype () {
    _has_bits_[1] &= ~ (1u << 9);
}

inline void T_tcu_charging_spot_data::set_has_u8Userrestriction () {
    _has_bits_[1] |= 1u << 10;
}

inline void T_tcu_charging_spot_data::clear_has_u8Userrestriction () {
    _has_bits_[1] &= ~ (1u << 10);
}

inline  T_tcu_response_charging_spot_data_result::T_tcu_response_charging_spot_data_result ()  :
    _ChargingSpotData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_tcu_response_charging_spot_data_result::T_tcu_response_charging_spot_data_result (const T_tcu_response_charging_spot_data_result &rhs)  :
    _ChargingSpotData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_tcu_response_charging_spot_data_result::T_tcu_response_charging_spot_data_result (const T_tcu_charging_spot_data& ChargingSpotData_)  :
    _ChargingSpotData (ChargingSpotData_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_tcu_response_charging_spot_data_result::~T_tcu_response_charging_spot_data_result() {
}

inline T_tcu_response_charging_spot_data_result& T_tcu_response_charging_spot_data_result::operator = (const T_tcu_response_charging_spot_data_result& rhs) {
    if( this != &rhs ) {
        if (rhs.hasChargingSpotData()) {
            setChargingSpotData(rhs.getChargingSpotData());
        } else {
            clearChargingSpotData();
        }
    }
    return *this;
}

inline bool T_tcu_response_charging_spot_data_result::operator == (const T_tcu_response_charging_spot_data_result& rhs) const {
    return (((!hasChargingSpotData() && !rhs.hasChargingSpotData()) || getChargingSpotData() == rhs.getChargingSpotData()));
}

inline bool T_tcu_response_charging_spot_data_result::operator != (const T_tcu_response_charging_spot_data_result& rhs) const {
    return ! (*this == rhs);
}

inline bool T_tcu_response_charging_spot_data_result::operator < (const T_tcu_response_charging_spot_data_result& rhs) const {
    if (hasChargingSpotData() || rhs.hasChargingSpotData()) {
        if (getChargingSpotData() < rhs.getChargingSpotData()) return true;
        if (getChargingSpotData() > rhs.getChargingSpotData()) return false;
    }
    return false;
}

inline bool T_tcu_response_charging_spot_data_result::operator > (const T_tcu_response_charging_spot_data_result& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_tcu_response_charging_spot_data_result::clear() {
    clearChargingSpotData();
}

inline void T_tcu_response_charging_spot_data_result::clearChargingSpotData() {
    if (hasChargingSpotData()) {
         clear_has_ChargingSpotData();
        _ChargingSpotData.clear();
     }
}

inline bool T_tcu_response_charging_spot_data_result::hasChargingSpotData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const T_tcu_charging_spot_data& T_tcu_response_charging_spot_data_result::getChargingSpotData () const {
    return _ChargingSpotData;
}

inline T_tcu_charging_spot_data& T_tcu_response_charging_spot_data_result::getChargingSpotDataMutable () {
    set_has_ChargingSpotData();
    return _ChargingSpotData;
}

inline void T_tcu_response_charging_spot_data_result::setChargingSpotData (const T_tcu_charging_spot_data& ChargingSpotData_) {
    set_has_ChargingSpotData();
    this->_ChargingSpotData = ChargingSpotData_;
}

inline void T_tcu_response_charging_spot_data_result::set_has_ChargingSpotData () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_tcu_response_charging_spot_data_result::clear_has_ChargingSpotData () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  T_tcu_charging_stations_info::T_tcu_charging_stations_info ()  :
    _Location (),
    _u32POIID (0u),
    _u32POIIDVersion (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_tcu_charging_stations_info::T_tcu_charging_stations_info (const T_tcu_charging_stations_info &rhs)  :
    _Location (),
    _u32POIID (0u),
    _u32POIIDVersion (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_tcu_charging_stations_info::T_tcu_charging_stations_info (const T_usb_tcu_Location& Location_, uint32 u32POIID_, uint32 u32POIIDVersion_)  :
    _Location (Location_),
    _u32POIID (u32POIID_),
    _u32POIIDVersion (u32POIIDVersion_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_tcu_charging_stations_info::~T_tcu_charging_stations_info() {
}

inline T_tcu_charging_stations_info& T_tcu_charging_stations_info::operator = (const T_tcu_charging_stations_info& rhs) {
    if( this != &rhs ) {
        if (rhs.hasLocation()) {
            setLocation(rhs.getLocation());
        } else {
            clearLocation();
        }
        if (rhs.hasU32POIID()) {
            setU32POIID(rhs.getU32POIID());
        } else {
            clearU32POIID();
        }
        if (rhs.hasU32POIIDVersion()) {
            setU32POIIDVersion(rhs.getU32POIIDVersion());
        } else {
            clearU32POIIDVersion();
        }
    }
    return *this;
}

inline bool T_tcu_charging_stations_info::operator == (const T_tcu_charging_stations_info& rhs) const {
    return (((!hasLocation() && !rhs.hasLocation()) || getLocation() == rhs.getLocation()) &&
        ((!hasU32POIID() && !rhs.hasU32POIID()) || getU32POIID() == rhs.getU32POIID()) &&
        ((!hasU32POIIDVersion() && !rhs.hasU32POIIDVersion()) || getU32POIIDVersion() == rhs.getU32POIIDVersion()));
}

inline bool T_tcu_charging_stations_info::operator != (const T_tcu_charging_stations_info& rhs) const {
    return ! (*this == rhs);
}

inline bool T_tcu_charging_stations_info::operator < (const T_tcu_charging_stations_info& rhs) const {
    if (hasLocation() || rhs.hasLocation()) {
        if (getLocation() < rhs.getLocation()) return true;
        if (getLocation() > rhs.getLocation()) return false;
    }
    if (hasU32POIID() || rhs.hasU32POIID()) {
        if (getU32POIID() < rhs.getU32POIID()) return true;
        if (getU32POIID() > rhs.getU32POIID()) return false;
    }
    if (hasU32POIIDVersion() || rhs.hasU32POIIDVersion()) {
        if (getU32POIIDVersion() < rhs.getU32POIIDVersion()) return true;
        if (getU32POIIDVersion() > rhs.getU32POIIDVersion()) return false;
    }
    return false;
}

inline bool T_tcu_charging_stations_info::operator > (const T_tcu_charging_stations_info& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_tcu_charging_stations_info::clear() {
    clearLocation();
    clearU32POIID();
    clearU32POIIDVersion();
}

inline void T_tcu_charging_stations_info::clearLocation() {
    if (hasLocation()) {
         clear_has_Location();
        _Location.clear();
     }
}

inline bool T_tcu_charging_stations_info::hasLocation () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const T_usb_tcu_Location& T_tcu_charging_stations_info::getLocation () const {
    return _Location;
}

inline T_usb_tcu_Location& T_tcu_charging_stations_info::getLocationMutable () {
    set_has_Location();
    return _Location;
}

inline void T_tcu_charging_stations_info::setLocation (const T_usb_tcu_Location& Location_) {
    set_has_Location();
    this->_Location = Location_;
}

inline void T_tcu_charging_stations_info::clearU32POIID() {
    if (hasU32POIID()) {
         clear_has_u32POIID();
        _u32POIID = 0u;
     }
}

inline bool T_tcu_charging_stations_info::hasU32POIID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 T_tcu_charging_stations_info::getU32POIID () const {
    return _u32POIID;
}

inline void T_tcu_charging_stations_info::setU32POIID (uint32 u32POIID_) {
    set_has_u32POIID();
    this->_u32POIID = u32POIID_;
}

inline void T_tcu_charging_stations_info::clearU32POIIDVersion() {
    if (hasU32POIIDVersion()) {
         clear_has_u32POIIDVersion();
        _u32POIIDVersion = 0u;
     }
}

inline bool T_tcu_charging_stations_info::hasU32POIIDVersion () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 T_tcu_charging_stations_info::getU32POIIDVersion () const {
    return _u32POIIDVersion;
}

inline void T_tcu_charging_stations_info::setU32POIIDVersion (uint32 u32POIIDVersion_) {
    set_has_u32POIIDVersion();
    this->_u32POIIDVersion = u32POIIDVersion_;
}

inline void T_tcu_charging_stations_info::set_has_Location () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_tcu_charging_stations_info::clear_has_Location () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_tcu_charging_stations_info::set_has_u32POIID () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_tcu_charging_stations_info::clear_has_u32POIID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_tcu_charging_stations_info::set_has_u32POIIDVersion () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_tcu_charging_stations_info::clear_has_u32POIIDVersion () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_tcu_charging_stations_data::T_tcu_charging_stations_data ()  :
    _u32NumberOfPOIID (0u),
    _u32POIDataSetIdentificationID (0u),
    _u8POIDataSetIdentificationIDType (0u),
    _ChargingStationsInfoList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_tcu_charging_stations_data::T_tcu_charging_stations_data (const T_tcu_charging_stations_data &rhs)  :
    _u32NumberOfPOIID (0u),
    _u32POIDataSetIdentificationID (0u),
    _u8POIDataSetIdentificationIDType (0u),
    _ChargingStationsInfoList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_tcu_charging_stations_data::T_tcu_charging_stations_data (uint32 u32NumberOfPOIID_, uint32 u32POIDataSetIdentificationID_, uint8 u8POIDataSetIdentificationIDType_, const ::std::vector< T_tcu_charging_stations_info >& ChargingStationsInfoList_)  :
    _u32NumberOfPOIID (u32NumberOfPOIID_),
    _u32POIDataSetIdentificationID (u32POIDataSetIdentificationID_),
    _u8POIDataSetIdentificationIDType (u8POIDataSetIdentificationIDType_),
    _ChargingStationsInfoList (ChargingStationsInfoList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_tcu_charging_stations_data::~T_tcu_charging_stations_data() {
}

inline T_tcu_charging_stations_data& T_tcu_charging_stations_data::operator = (const T_tcu_charging_stations_data& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU32NumberOfPOIID()) {
            setU32NumberOfPOIID(rhs.getU32NumberOfPOIID());
        } else {
            clearU32NumberOfPOIID();
        }
        if (rhs.hasU32POIDataSetIdentificationID()) {
            setU32POIDataSetIdentificationID(rhs.getU32POIDataSetIdentificationID());
        } else {
            clearU32POIDataSetIdentificationID();
        }
        if (rhs.hasU8POIDataSetIdentificationIDType()) {
            setU8POIDataSetIdentificationIDType(rhs.getU8POIDataSetIdentificationIDType());
        } else {
            clearU8POIDataSetIdentificationIDType();
        }
        if (rhs.hasChargingStationsInfoList()) {
            setChargingStationsInfoList(rhs.getChargingStationsInfoList());
        } else {
            clearChargingStationsInfoList();
        }
    }
    return *this;
}

inline bool T_tcu_charging_stations_data::operator == (const T_tcu_charging_stations_data& rhs) const {
    return (((!hasU32NumberOfPOIID() && !rhs.hasU32NumberOfPOIID()) || getU32NumberOfPOIID() == rhs.getU32NumberOfPOIID()) &&
        ((!hasU32POIDataSetIdentificationID() && !rhs.hasU32POIDataSetIdentificationID()) || getU32POIDataSetIdentificationID() == rhs.getU32POIDataSetIdentificationID()) &&
        ((!hasU8POIDataSetIdentificationIDType() && !rhs.hasU8POIDataSetIdentificationIDType()) || getU8POIDataSetIdentificationIDType() == rhs.getU8POIDataSetIdentificationIDType()) &&
        ((!hasChargingStationsInfoList() && !rhs.hasChargingStationsInfoList()) || getChargingStationsInfoList() == rhs.getChargingStationsInfoList()));
}

inline bool T_tcu_charging_stations_data::operator != (const T_tcu_charging_stations_data& rhs) const {
    return ! (*this == rhs);
}

inline bool T_tcu_charging_stations_data::operator < (const T_tcu_charging_stations_data& rhs) const {
    if (hasU32NumberOfPOIID() || rhs.hasU32NumberOfPOIID()) {
        if (getU32NumberOfPOIID() < rhs.getU32NumberOfPOIID()) return true;
        if (getU32NumberOfPOIID() > rhs.getU32NumberOfPOIID()) return false;
    }
    if (hasU32POIDataSetIdentificationID() || rhs.hasU32POIDataSetIdentificationID()) {
        if (getU32POIDataSetIdentificationID() < rhs.getU32POIDataSetIdentificationID()) return true;
        if (getU32POIDataSetIdentificationID() > rhs.getU32POIDataSetIdentificationID()) return false;
    }
    if (hasU8POIDataSetIdentificationIDType() || rhs.hasU8POIDataSetIdentificationIDType()) {
        if (getU8POIDataSetIdentificationIDType() < rhs.getU8POIDataSetIdentificationIDType()) return true;
        if (getU8POIDataSetIdentificationIDType() > rhs.getU8POIDataSetIdentificationIDType()) return false;
    }
    if (hasChargingStationsInfoList() || rhs.hasChargingStationsInfoList()) {
        if (getChargingStationsInfoList() < rhs.getChargingStationsInfoList()) return true;
        if (getChargingStationsInfoList() > rhs.getChargingStationsInfoList()) return false;
    }
    return false;
}

inline bool T_tcu_charging_stations_data::operator > (const T_tcu_charging_stations_data& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_tcu_charging_stations_data::clear() {
    clearU32NumberOfPOIID();
    clearU32POIDataSetIdentificationID();
    clearU8POIDataSetIdentificationIDType();
    clearChargingStationsInfoList();
}

inline void T_tcu_charging_stations_data::clearU32NumberOfPOIID() {
    if (hasU32NumberOfPOIID()) {
         clear_has_u32NumberOfPOIID();
        _u32NumberOfPOIID = 0u;
     }
}

inline bool T_tcu_charging_stations_data::hasU32NumberOfPOIID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_tcu_charging_stations_data::getU32NumberOfPOIID () const {
    return _u32NumberOfPOIID;
}

inline void T_tcu_charging_stations_data::setU32NumberOfPOIID (uint32 u32NumberOfPOIID_) {
    set_has_u32NumberOfPOIID();
    this->_u32NumberOfPOIID = u32NumberOfPOIID_;
}

inline void T_tcu_charging_stations_data::clearU32POIDataSetIdentificationID() {
    if (hasU32POIDataSetIdentificationID()) {
         clear_has_u32POIDataSetIdentificationID();
        _u32POIDataSetIdentificationID = 0u;
     }
}

inline bool T_tcu_charging_stations_data::hasU32POIDataSetIdentificationID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 T_tcu_charging_stations_data::getU32POIDataSetIdentificationID () const {
    return _u32POIDataSetIdentificationID;
}

inline void T_tcu_charging_stations_data::setU32POIDataSetIdentificationID (uint32 u32POIDataSetIdentificationID_) {
    set_has_u32POIDataSetIdentificationID();
    this->_u32POIDataSetIdentificationID = u32POIDataSetIdentificationID_;
}

inline void T_tcu_charging_stations_data::clearU8POIDataSetIdentificationIDType() {
    if (hasU8POIDataSetIdentificationIDType()) {
         clear_has_u8POIDataSetIdentificationIDType();
        _u8POIDataSetIdentificationIDType = 0u;
     }
}

inline bool T_tcu_charging_stations_data::hasU8POIDataSetIdentificationIDType () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 T_tcu_charging_stations_data::getU8POIDataSetIdentificationIDType () const {
    return _u8POIDataSetIdentificationIDType;
}

inline void T_tcu_charging_stations_data::setU8POIDataSetIdentificationIDType (uint8 u8POIDataSetIdentificationIDType_) {
    set_has_u8POIDataSetIdentificationIDType();
    this->_u8POIDataSetIdentificationIDType = u8POIDataSetIdentificationIDType_;
}

inline void T_tcu_charging_stations_data::clearChargingStationsInfoList() {
    if (hasChargingStationsInfoList()) {
         clear_has_ChargingStationsInfoList();
        _ChargingStationsInfoList.clear();
     }
}

inline bool T_tcu_charging_stations_data::hasChargingStationsInfoList () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::vector< T_tcu_charging_stations_info >& T_tcu_charging_stations_data::getChargingStationsInfoList () const {
    return _ChargingStationsInfoList;
}

inline ::std::vector< T_tcu_charging_stations_info >& T_tcu_charging_stations_data::getChargingStationsInfoListMutable () {
    set_has_ChargingStationsInfoList();
    return _ChargingStationsInfoList;
}

inline void T_tcu_charging_stations_data::setChargingStationsInfoList (const ::std::vector< T_tcu_charging_stations_info >& ChargingStationsInfoList_) {
    set_has_ChargingStationsInfoList();
    this->_ChargingStationsInfoList = ChargingStationsInfoList_;
}

inline void T_tcu_charging_stations_data::set_has_u32NumberOfPOIID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_tcu_charging_stations_data::clear_has_u32NumberOfPOIID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_tcu_charging_stations_data::set_has_u32POIDataSetIdentificationID () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_tcu_charging_stations_data::clear_has_u32POIDataSetIdentificationID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_tcu_charging_stations_data::set_has_u8POIDataSetIdentificationIDType () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_tcu_charging_stations_data::clear_has_u8POIDataSetIdentificationIDType () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_tcu_charging_stations_data::set_has_ChargingStationsInfoList () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_tcu_charging_stations_data::clear_has_ChargingStationsInfoList () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  T_tcu_response_charging_stations_list_result::T_tcu_response_charging_stations_list_result ()  :
    _ChargingStationsData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_tcu_response_charging_stations_list_result::T_tcu_response_charging_stations_list_result (const T_tcu_response_charging_stations_list_result &rhs)  :
    _ChargingStationsData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_tcu_response_charging_stations_list_result::T_tcu_response_charging_stations_list_result (const T_tcu_charging_stations_data& ChargingStationsData_)  :
    _ChargingStationsData (ChargingStationsData_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_tcu_response_charging_stations_list_result::~T_tcu_response_charging_stations_list_result() {
}

inline T_tcu_response_charging_stations_list_result& T_tcu_response_charging_stations_list_result::operator = (const T_tcu_response_charging_stations_list_result& rhs) {
    if( this != &rhs ) {
        if (rhs.hasChargingStationsData()) {
            setChargingStationsData(rhs.getChargingStationsData());
        } else {
            clearChargingStationsData();
        }
    }
    return *this;
}

inline bool T_tcu_response_charging_stations_list_result::operator == (const T_tcu_response_charging_stations_list_result& rhs) const {
    return (((!hasChargingStationsData() && !rhs.hasChargingStationsData()) || getChargingStationsData() == rhs.getChargingStationsData()));
}

inline bool T_tcu_response_charging_stations_list_result::operator != (const T_tcu_response_charging_stations_list_result& rhs) const {
    return ! (*this == rhs);
}

inline bool T_tcu_response_charging_stations_list_result::operator < (const T_tcu_response_charging_stations_list_result& rhs) const {
    if (hasChargingStationsData() || rhs.hasChargingStationsData()) {
        if (getChargingStationsData() < rhs.getChargingStationsData()) return true;
        if (getChargingStationsData() > rhs.getChargingStationsData()) return false;
    }
    return false;
}

inline bool T_tcu_response_charging_stations_list_result::operator > (const T_tcu_response_charging_stations_list_result& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_tcu_response_charging_stations_list_result::clear() {
    clearChargingStationsData();
}

inline void T_tcu_response_charging_stations_list_result::clearChargingStationsData() {
    if (hasChargingStationsData()) {
         clear_has_ChargingStationsData();
        _ChargingStationsData.clear();
     }
}

inline bool T_tcu_response_charging_stations_list_result::hasChargingStationsData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const T_tcu_charging_stations_data& T_tcu_response_charging_stations_list_result::getChargingStationsData () const {
    return _ChargingStationsData;
}

inline T_tcu_charging_stations_data& T_tcu_response_charging_stations_list_result::getChargingStationsDataMutable () {
    set_has_ChargingStationsData();
    return _ChargingStationsData;
}

inline void T_tcu_response_charging_stations_list_result::setChargingStationsData (const T_tcu_charging_stations_data& ChargingStationsData_) {
    set_has_ChargingStationsData();
    this->_ChargingStationsData = ChargingStationsData_;
}

inline void T_tcu_response_charging_stations_list_result::set_has_ChargingStationsData () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_tcu_response_charging_stations_list_result::clear_has_ChargingStationsData () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  T_tcu_vacancy_stations_info::T_tcu_vacancy_stations_info ()  :
    _Location (),
    _u32POIID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_tcu_vacancy_stations_info::T_tcu_vacancy_stations_info (const T_tcu_vacancy_stations_info &rhs)  :
    _Location (),
    _u32POIID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_tcu_vacancy_stations_info::T_tcu_vacancy_stations_info (const T_usb_tcu_Location& Location_, uint32 u32POIID_)  :
    _Location (Location_),
    _u32POIID (u32POIID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_tcu_vacancy_stations_info::~T_tcu_vacancy_stations_info() {
}

inline T_tcu_vacancy_stations_info& T_tcu_vacancy_stations_info::operator = (const T_tcu_vacancy_stations_info& rhs) {
    if( this != &rhs ) {
        if (rhs.hasLocation()) {
            setLocation(rhs.getLocation());
        } else {
            clearLocation();
        }
        if (rhs.hasU32POIID()) {
            setU32POIID(rhs.getU32POIID());
        } else {
            clearU32POIID();
        }
    }
    return *this;
}

inline bool T_tcu_vacancy_stations_info::operator == (const T_tcu_vacancy_stations_info& rhs) const {
    return (((!hasLocation() && !rhs.hasLocation()) || getLocation() == rhs.getLocation()) &&
        ((!hasU32POIID() && !rhs.hasU32POIID()) || getU32POIID() == rhs.getU32POIID()));
}

inline bool T_tcu_vacancy_stations_info::operator != (const T_tcu_vacancy_stations_info& rhs) const {
    return ! (*this == rhs);
}

inline bool T_tcu_vacancy_stations_info::operator < (const T_tcu_vacancy_stations_info& rhs) const {
    if (hasLocation() || rhs.hasLocation()) {
        if (getLocation() < rhs.getLocation()) return true;
        if (getLocation() > rhs.getLocation()) return false;
    }
    if (hasU32POIID() || rhs.hasU32POIID()) {
        if (getU32POIID() < rhs.getU32POIID()) return true;
        if (getU32POIID() > rhs.getU32POIID()) return false;
    }
    return false;
}

inline bool T_tcu_vacancy_stations_info::operator > (const T_tcu_vacancy_stations_info& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_tcu_vacancy_stations_info::clear() {
    clearLocation();
    clearU32POIID();
}

inline void T_tcu_vacancy_stations_info::clearLocation() {
    if (hasLocation()) {
         clear_has_Location();
        _Location.clear();
     }
}

inline bool T_tcu_vacancy_stations_info::hasLocation () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const T_usb_tcu_Location& T_tcu_vacancy_stations_info::getLocation () const {
    return _Location;
}

inline T_usb_tcu_Location& T_tcu_vacancy_stations_info::getLocationMutable () {
    set_has_Location();
    return _Location;
}

inline void T_tcu_vacancy_stations_info::setLocation (const T_usb_tcu_Location& Location_) {
    set_has_Location();
    this->_Location = Location_;
}

inline void T_tcu_vacancy_stations_info::clearU32POIID() {
    if (hasU32POIID()) {
         clear_has_u32POIID();
        _u32POIID = 0u;
     }
}

inline bool T_tcu_vacancy_stations_info::hasU32POIID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 T_tcu_vacancy_stations_info::getU32POIID () const {
    return _u32POIID;
}

inline void T_tcu_vacancy_stations_info::setU32POIID (uint32 u32POIID_) {
    set_has_u32POIID();
    this->_u32POIID = u32POIID_;
}

inline void T_tcu_vacancy_stations_info::set_has_Location () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_tcu_vacancy_stations_info::clear_has_Location () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_tcu_vacancy_stations_info::set_has_u32POIID () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_tcu_vacancy_stations_info::clear_has_u32POIID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_tcu_response_vacancy_stations_list_result::T_tcu_response_vacancy_stations_list_result ()  :
    _VacancyStationsData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_tcu_response_vacancy_stations_list_result::T_tcu_response_vacancy_stations_list_result (const T_tcu_response_vacancy_stations_list_result &rhs)  :
    _VacancyStationsData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_tcu_response_vacancy_stations_list_result::T_tcu_response_vacancy_stations_list_result (const T_tcu_vacancy_stations_data& VacancyStationsData_)  :
    _VacancyStationsData (VacancyStationsData_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_tcu_response_vacancy_stations_list_result::~T_tcu_response_vacancy_stations_list_result() {
}

inline T_tcu_response_vacancy_stations_list_result& T_tcu_response_vacancy_stations_list_result::operator = (const T_tcu_response_vacancy_stations_list_result& rhs) {
    if( this != &rhs ) {
        if (rhs.hasVacancyStationsData()) {
            setVacancyStationsData(rhs.getVacancyStationsData());
        } else {
            clearVacancyStationsData();
        }
    }
    return *this;
}

inline bool T_tcu_response_vacancy_stations_list_result::operator == (const T_tcu_response_vacancy_stations_list_result& rhs) const {
    return (((!hasVacancyStationsData() && !rhs.hasVacancyStationsData()) || getVacancyStationsData() == rhs.getVacancyStationsData()));
}

inline bool T_tcu_response_vacancy_stations_list_result::operator != (const T_tcu_response_vacancy_stations_list_result& rhs) const {
    return ! (*this == rhs);
}

inline bool T_tcu_response_vacancy_stations_list_result::operator < (const T_tcu_response_vacancy_stations_list_result& rhs) const {
    if (hasVacancyStationsData() || rhs.hasVacancyStationsData()) {
        if (getVacancyStationsData() < rhs.getVacancyStationsData()) return true;
        if (getVacancyStationsData() > rhs.getVacancyStationsData()) return false;
    }
    return false;
}

inline bool T_tcu_response_vacancy_stations_list_result::operator > (const T_tcu_response_vacancy_stations_list_result& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_tcu_response_vacancy_stations_list_result::clear() {
    clearVacancyStationsData();
}

inline void T_tcu_response_vacancy_stations_list_result::clearVacancyStationsData() {
    if (hasVacancyStationsData()) {
         clear_has_VacancyStationsData();
        _VacancyStationsData.clear();
     }
}

inline bool T_tcu_response_vacancy_stations_list_result::hasVacancyStationsData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const T_tcu_vacancy_stations_data& T_tcu_response_vacancy_stations_list_result::getVacancyStationsData () const {
    return _VacancyStationsData;
}

inline T_tcu_vacancy_stations_data& T_tcu_response_vacancy_stations_list_result::getVacancyStationsDataMutable () {
    set_has_VacancyStationsData();
    return _VacancyStationsData;
}

inline void T_tcu_response_vacancy_stations_list_result::setVacancyStationsData (const T_tcu_vacancy_stations_data& VacancyStationsData_) {
    set_has_VacancyStationsData();
    this->_VacancyStationsData = VacancyStationsData_;
}

inline void T_tcu_response_vacancy_stations_list_result::set_has_VacancyStationsData () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_tcu_response_vacancy_stations_list_result::clear_has_VacancyStationsData () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  T_tcu_vacancy_spot_data::T_tcu_vacancy_spot_data ()  :
    _Location (),
    _strAreaCode1 (),
    _strAreaCode2 (),
    _strAreaCode3 (),
    _strAreaCode4 (),
    _strAreaCode5 (),
    _strAreaCode6 (),
    _strAreaCode7 (),
    _strAreaCode8 (),
    _strPOIName (),
    _strStreetAndHouseNo (),
    _strTelephonenumber (),
    _u16Categorycode (0u),
    _u16ClosedhourInformation (0u),
    _u16OpeninghourInformation (0u),
    _u16Parkingnumber (0u),
    _u16Paymenttypeinformation (0u),
    _u16Sizeofdetailinformation (0u),
    _u16Subcategorycode (0u),
    _u32POIID (0u),
    _u32UserrestrictionID (0u),
    _u8_24hoursadayinformation (0u),
    _u8Businessdayoftheweekinformation (0u),
    _u8Chargingfeeinformation (0u),
    _u8Chargingtype (0u),
    _u8Detailsinformation (0u),
    _u8Entranceinformation (0u),
    _u8Expresswaygeneraltype (0u),
    _u8Fixedvalue1 (0u),
    _u8Fixedvalue2 (0u),
    _u8Informationreliability (0u),
    _u8Installationfacilityinformation (0u),
    _u8Nearthefacilityinformation (0u),
    _u8Officehoursunknowninformation (0u),
    _u8Partnersfacilityinformation (0u),
    _u8SizeOfPOIName (0u),
    _u8SizeOfStreetAndHouseNo (0u),
    _u8SizeOfTelephonenumber (0u),
    _u8Thenumberofentranceinformation (0u),
    _u8Thenumberofinstallationfacilityinformation (0u),
    _u8Thenumberofpartnersfacilityinformation (0u),
    _u8Thetotalnumberofchargingtype (0u),
    _u8Userrestriction (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_tcu_vacancy_spot_data::T_tcu_vacancy_spot_data (const T_tcu_vacancy_spot_data &rhs)  :
    _Location (),
    _strAreaCode1 (),
    _strAreaCode2 (),
    _strAreaCode3 (),
    _strAreaCode4 (),
    _strAreaCode5 (),
    _strAreaCode6 (),
    _strAreaCode7 (),
    _strAreaCode8 (),
    _strPOIName (),
    _strStreetAndHouseNo (),
    _strTelephonenumber (),
    _u16Categorycode (0u),
    _u16ClosedhourInformation (0u),
    _u16OpeninghourInformation (0u),
    _u16Parkingnumber (0u),
    _u16Paymenttypeinformation (0u),
    _u16Sizeofdetailinformation (0u),
    _u16Subcategorycode (0u),
    _u32POIID (0u),
    _u32UserrestrictionID (0u),
    _u8_24hoursadayinformation (0u),
    _u8Businessdayoftheweekinformation (0u),
    _u8Chargingfeeinformation (0u),
    _u8Chargingtype (0u),
    _u8Detailsinformation (0u),
    _u8Entranceinformation (0u),
    _u8Expresswaygeneraltype (0u),
    _u8Fixedvalue1 (0u),
    _u8Fixedvalue2 (0u),
    _u8Informationreliability (0u),
    _u8Installationfacilityinformation (0u),
    _u8Nearthefacilityinformation (0u),
    _u8Officehoursunknowninformation (0u),
    _u8Partnersfacilityinformation (0u),
    _u8SizeOfPOIName (0u),
    _u8SizeOfStreetAndHouseNo (0u),
    _u8SizeOfTelephonenumber (0u),
    _u8Thenumberofentranceinformation (0u),
    _u8Thenumberofinstallationfacilityinformation (0u),
    _u8Thenumberofpartnersfacilityinformation (0u),
    _u8Thetotalnumberofchargingtype (0u),
    _u8Userrestriction (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_tcu_vacancy_spot_data::T_tcu_vacancy_spot_data (const T_usb_tcu_Location& Location_, const ::std::string& strAreaCode1_, const ::std::string& strAreaCode2_, const ::std::string& strAreaCode3_, const ::std::string& strAreaCode4_, const ::std::string& strAreaCode5_, const ::std::string& strAreaCode6_, const ::std::string& strAreaCode7_, const ::std::string& strAreaCode8_, const ::std::string& strPOIName_, const ::std::string& strStreetAndHouseNo_, const ::std::string& strTelephonenumber_, uint16 u16Categorycode_, uint16 u16ClosedhourInformation_, uint16 u16OpeninghourInformation_, uint16 u16Parkingnumber_, uint16 u16Paymenttypeinformation_, uint16 u16Sizeofdetailinformation_, uint16 u16Subcategorycode_, uint32 u32POIID_, uint32 u32UserrestrictionID_, uint8 u8_24hoursadayinformation_, uint8 u8Businessdayoftheweekinformation_, uint8 u8Chargingfeeinformation_, uint8 u8Chargingtype_, uint8 u8Detailsinformation_, uint8 u8Entranceinformation_, uint8 u8Expresswaygeneraltype_, uint8 u8Fixedvalue1_, uint8 u8Fixedvalue2_, uint8 u8Informationreliability_, uint8 u8Installationfacilityinformation_, uint8 u8Nearthefacilityinformation_, uint8 u8Officehoursunknowninformation_, uint8 u8Partnersfacilityinformation_, uint8 u8SizeOfPOIName_, uint8 u8SizeOfStreetAndHouseNo_, uint8 u8SizeOfTelephonenumber_, uint8 u8Thenumberofentranceinformation_, uint8 u8Thenumberofinstallationfacilityinformation_, uint8 u8Thenumberofpartnersfacilityinformation_, uint8 u8Thetotalnumberofchargingtype_, uint8 u8Userrestriction_)  :
    _Location (Location_),
    _strAreaCode1 (strAreaCode1_),
    _strAreaCode2 (strAreaCode2_),
    _strAreaCode3 (strAreaCode3_),
    _strAreaCode4 (strAreaCode4_),
    _strAreaCode5 (strAreaCode5_),
    _strAreaCode6 (strAreaCode6_),
    _strAreaCode7 (strAreaCode7_),
    _strAreaCode8 (strAreaCode8_),
    _strPOIName (strPOIName_),
    _strStreetAndHouseNo (strStreetAndHouseNo_),
    _strTelephonenumber (strTelephonenumber_),
    _u16Categorycode (u16Categorycode_),
    _u16ClosedhourInformation (u16ClosedhourInformation_),
    _u16OpeninghourInformation (u16OpeninghourInformation_),
    _u16Parkingnumber (u16Parkingnumber_),
    _u16Paymenttypeinformation (u16Paymenttypeinformation_),
    _u16Sizeofdetailinformation (u16Sizeofdetailinformation_),
    _u16Subcategorycode (u16Subcategorycode_),
    _u32POIID (u32POIID_),
    _u32UserrestrictionID (u32UserrestrictionID_),
    _u8_24hoursadayinformation (u8_24hoursadayinformation_),
    _u8Businessdayoftheweekinformation (u8Businessdayoftheweekinformation_),
    _u8Chargingfeeinformation (u8Chargingfeeinformation_),
    _u8Chargingtype (u8Chargingtype_),
    _u8Detailsinformation (u8Detailsinformation_),
    _u8Entranceinformation (u8Entranceinformation_),
    _u8Expresswaygeneraltype (u8Expresswaygeneraltype_),
    _u8Fixedvalue1 (u8Fixedvalue1_),
    _u8Fixedvalue2 (u8Fixedvalue2_),
    _u8Informationreliability (u8Informationreliability_),
    _u8Installationfacilityinformation (u8Installationfacilityinformation_),
    _u8Nearthefacilityinformation (u8Nearthefacilityinformation_),
    _u8Officehoursunknowninformation (u8Officehoursunknowninformation_),
    _u8Partnersfacilityinformation (u8Partnersfacilityinformation_),
    _u8SizeOfPOIName (u8SizeOfPOIName_),
    _u8SizeOfStreetAndHouseNo (u8SizeOfStreetAndHouseNo_),
    _u8SizeOfTelephonenumber (u8SizeOfTelephonenumber_),
    _u8Thenumberofentranceinformation (u8Thenumberofentranceinformation_),
    _u8Thenumberofinstallationfacilityinformation (u8Thenumberofinstallationfacilityinformation_),
    _u8Thenumberofpartnersfacilityinformation (u8Thenumberofpartnersfacilityinformation_),
    _u8Thetotalnumberofchargingtype (u8Thetotalnumberofchargingtype_),
    _u8Userrestriction (u8Userrestriction_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strAreaCode1_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strAreaCode2_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strAreaCode3_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strAreaCode4_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strAreaCode5_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strAreaCode6_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strAreaCode7_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strAreaCode8_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strPOIName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strStreetAndHouseNo_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strTelephonenumber_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_tcu_vacancy_spot_data::~T_tcu_vacancy_spot_data() {
}

inline T_tcu_vacancy_spot_data& T_tcu_vacancy_spot_data::operator = (const T_tcu_vacancy_spot_data& rhs) {
    if( this != &rhs ) {
        if (rhs.hasLocation()) {
            setLocation(rhs.getLocation());
        } else {
            clearLocation();
        }
        if (rhs.hasStrAreaCode1()) {
            setStrAreaCode1(rhs.getStrAreaCode1());
        } else {
            clearStrAreaCode1();
        }
        if (rhs.hasStrAreaCode2()) {
            setStrAreaCode2(rhs.getStrAreaCode2());
        } else {
            clearStrAreaCode2();
        }
        if (rhs.hasStrAreaCode3()) {
            setStrAreaCode3(rhs.getStrAreaCode3());
        } else {
            clearStrAreaCode3();
        }
        if (rhs.hasStrAreaCode4()) {
            setStrAreaCode4(rhs.getStrAreaCode4());
        } else {
            clearStrAreaCode4();
        }
        if (rhs.hasStrAreaCode5()) {
            setStrAreaCode5(rhs.getStrAreaCode5());
        } else {
            clearStrAreaCode5();
        }
        if (rhs.hasStrAreaCode6()) {
            setStrAreaCode6(rhs.getStrAreaCode6());
        } else {
            clearStrAreaCode6();
        }
        if (rhs.hasStrAreaCode7()) {
            setStrAreaCode7(rhs.getStrAreaCode7());
        } else {
            clearStrAreaCode7();
        }
        if (rhs.hasStrAreaCode8()) {
            setStrAreaCode8(rhs.getStrAreaCode8());
        } else {
            clearStrAreaCode8();
        }
        if (rhs.hasStrPOIName()) {
            setStrPOIName(rhs.getStrPOIName());
        } else {
            clearStrPOIName();
        }
        if (rhs.hasStrStreetAndHouseNo()) {
            setStrStreetAndHouseNo(rhs.getStrStreetAndHouseNo());
        } else {
            clearStrStreetAndHouseNo();
        }
        if (rhs.hasStrTelephonenumber()) {
            setStrTelephonenumber(rhs.getStrTelephonenumber());
        } else {
            clearStrTelephonenumber();
        }
        if (rhs.hasU16Categorycode()) {
            setU16Categorycode(rhs.getU16Categorycode());
        } else {
            clearU16Categorycode();
        }
        if (rhs.hasU16ClosedhourInformation()) {
            setU16ClosedhourInformation(rhs.getU16ClosedhourInformation());
        } else {
            clearU16ClosedhourInformation();
        }
        if (rhs.hasU16OpeninghourInformation()) {
            setU16OpeninghourInformation(rhs.getU16OpeninghourInformation());
        } else {
            clearU16OpeninghourInformation();
        }
        if (rhs.hasU16Parkingnumber()) {
            setU16Parkingnumber(rhs.getU16Parkingnumber());
        } else {
            clearU16Parkingnumber();
        }
        if (rhs.hasU16Paymenttypeinformation()) {
            setU16Paymenttypeinformation(rhs.getU16Paymenttypeinformation());
        } else {
            clearU16Paymenttypeinformation();
        }
        if (rhs.hasU16Sizeofdetailinformation()) {
            setU16Sizeofdetailinformation(rhs.getU16Sizeofdetailinformation());
        } else {
            clearU16Sizeofdetailinformation();
        }
        if (rhs.hasU16Subcategorycode()) {
            setU16Subcategorycode(rhs.getU16Subcategorycode());
        } else {
            clearU16Subcategorycode();
        }
        if (rhs.hasU32POIID()) {
            setU32POIID(rhs.getU32POIID());
        } else {
            clearU32POIID();
        }
        if (rhs.hasU32UserrestrictionID()) {
            setU32UserrestrictionID(rhs.getU32UserrestrictionID());
        } else {
            clearU32UserrestrictionID();
        }
        if (rhs.hasU8_24hoursadayinformation()) {
            setU8_24hoursadayinformation(rhs.getU8_24hoursadayinformation());
        } else {
            clearU8_24hoursadayinformation();
        }
        if (rhs.hasU8Businessdayoftheweekinformation()) {
            setU8Businessdayoftheweekinformation(rhs.getU8Businessdayoftheweekinformation());
        } else {
            clearU8Businessdayoftheweekinformation();
        }
        if (rhs.hasU8Chargingfeeinformation()) {
            setU8Chargingfeeinformation(rhs.getU8Chargingfeeinformation());
        } else {
            clearU8Chargingfeeinformation();
        }
        if (rhs.hasU8Chargingtype()) {
            setU8Chargingtype(rhs.getU8Chargingtype());
        } else {
            clearU8Chargingtype();
        }
        if (rhs.hasU8Detailsinformation()) {
            setU8Detailsinformation(rhs.getU8Detailsinformation());
        } else {
            clearU8Detailsinformation();
        }
        if (rhs.hasU8Entranceinformation()) {
            setU8Entranceinformation(rhs.getU8Entranceinformation());
        } else {
            clearU8Entranceinformation();
        }
        if (rhs.hasU8Expresswaygeneraltype()) {
            setU8Expresswaygeneraltype(rhs.getU8Expresswaygeneraltype());
        } else {
            clearU8Expresswaygeneraltype();
        }
        if (rhs.hasU8Fixedvalue1()) {
            setU8Fixedvalue1(rhs.getU8Fixedvalue1());
        } else {
            clearU8Fixedvalue1();
        }
        if (rhs.hasU8Fixedvalue2()) {
            setU8Fixedvalue2(rhs.getU8Fixedvalue2());
        } else {
            clearU8Fixedvalue2();
        }
        if (rhs.hasU8Informationreliability()) {
            setU8Informationreliability(rhs.getU8Informationreliability());
        } else {
            clearU8Informationreliability();
        }
        if (rhs.hasU8Installationfacilityinformation()) {
            setU8Installationfacilityinformation(rhs.getU8Installationfacilityinformation());
        } else {
            clearU8Installationfacilityinformation();
        }
        if (rhs.hasU8Nearthefacilityinformation()) {
            setU8Nearthefacilityinformation(rhs.getU8Nearthefacilityinformation());
        } else {
            clearU8Nearthefacilityinformation();
        }
        if (rhs.hasU8Officehoursunknowninformation()) {
            setU8Officehoursunknowninformation(rhs.getU8Officehoursunknowninformation());
        } else {
            clearU8Officehoursunknowninformation();
        }
        if (rhs.hasU8Partnersfacilityinformation()) {
            setU8Partnersfacilityinformation(rhs.getU8Partnersfacilityinformation());
        } else {
            clearU8Partnersfacilityinformation();
        }
        if (rhs.hasU8SizeOfPOIName()) {
            setU8SizeOfPOIName(rhs.getU8SizeOfPOIName());
        } else {
            clearU8SizeOfPOIName();
        }
        if (rhs.hasU8SizeOfStreetAndHouseNo()) {
            setU8SizeOfStreetAndHouseNo(rhs.getU8SizeOfStreetAndHouseNo());
        } else {
            clearU8SizeOfStreetAndHouseNo();
        }
        if (rhs.hasU8SizeOfTelephonenumber()) {
            setU8SizeOfTelephonenumber(rhs.getU8SizeOfTelephonenumber());
        } else {
            clearU8SizeOfTelephonenumber();
        }
        if (rhs.hasU8Thenumberofentranceinformation()) {
            setU8Thenumberofentranceinformation(rhs.getU8Thenumberofentranceinformation());
        } else {
            clearU8Thenumberofentranceinformation();
        }
        if (rhs.hasU8Thenumberofinstallationfacilityinformation()) {
            setU8Thenumberofinstallationfacilityinformation(rhs.getU8Thenumberofinstallationfacilityinformation());
        } else {
            clearU8Thenumberofinstallationfacilityinformation();
        }
        if (rhs.hasU8Thenumberofpartnersfacilityinformation()) {
            setU8Thenumberofpartnersfacilityinformation(rhs.getU8Thenumberofpartnersfacilityinformation());
        } else {
            clearU8Thenumberofpartnersfacilityinformation();
        }
        if (rhs.hasU8Thetotalnumberofchargingtype()) {
            setU8Thetotalnumberofchargingtype(rhs.getU8Thetotalnumberofchargingtype());
        } else {
            clearU8Thetotalnumberofchargingtype();
        }
        if (rhs.hasU8Userrestriction()) {
            setU8Userrestriction(rhs.getU8Userrestriction());
        } else {
            clearU8Userrestriction();
        }
    }
    return *this;
}

inline bool T_tcu_vacancy_spot_data::operator == (const T_tcu_vacancy_spot_data& rhs) const {
    return (((!hasLocation() && !rhs.hasLocation()) || getLocation() == rhs.getLocation()) &&
        ((!hasStrAreaCode1() && !rhs.hasStrAreaCode1()) || getStrAreaCode1() == rhs.getStrAreaCode1()) &&
        ((!hasStrAreaCode2() && !rhs.hasStrAreaCode2()) || getStrAreaCode2() == rhs.getStrAreaCode2()) &&
        ((!hasStrAreaCode3() && !rhs.hasStrAreaCode3()) || getStrAreaCode3() == rhs.getStrAreaCode3()) &&
        ((!hasStrAreaCode4() && !rhs.hasStrAreaCode4()) || getStrAreaCode4() == rhs.getStrAreaCode4()) &&
        ((!hasStrAreaCode5() && !rhs.hasStrAreaCode5()) || getStrAreaCode5() == rhs.getStrAreaCode5()) &&
        ((!hasStrAreaCode6() && !rhs.hasStrAreaCode6()) || getStrAreaCode6() == rhs.getStrAreaCode6()) &&
        ((!hasStrAreaCode7() && !rhs.hasStrAreaCode7()) || getStrAreaCode7() == rhs.getStrAreaCode7()) &&
        ((!hasStrAreaCode8() && !rhs.hasStrAreaCode8()) || getStrAreaCode8() == rhs.getStrAreaCode8()) &&
        ((!hasStrPOIName() && !rhs.hasStrPOIName()) || getStrPOIName() == rhs.getStrPOIName()) &&
        ((!hasStrStreetAndHouseNo() && !rhs.hasStrStreetAndHouseNo()) || getStrStreetAndHouseNo() == rhs.getStrStreetAndHouseNo()) &&
        ((!hasStrTelephonenumber() && !rhs.hasStrTelephonenumber()) || getStrTelephonenumber() == rhs.getStrTelephonenumber()) &&
        ((!hasU16Categorycode() && !rhs.hasU16Categorycode()) || getU16Categorycode() == rhs.getU16Categorycode()) &&
        ((!hasU16ClosedhourInformation() && !rhs.hasU16ClosedhourInformation()) || getU16ClosedhourInformation() == rhs.getU16ClosedhourInformation()) &&
        ((!hasU16OpeninghourInformation() && !rhs.hasU16OpeninghourInformation()) || getU16OpeninghourInformation() == rhs.getU16OpeninghourInformation()) &&
        ((!hasU16Parkingnumber() && !rhs.hasU16Parkingnumber()) || getU16Parkingnumber() == rhs.getU16Parkingnumber()) &&
        ((!hasU16Paymenttypeinformation() && !rhs.hasU16Paymenttypeinformation()) || getU16Paymenttypeinformation() == rhs.getU16Paymenttypeinformation()) &&
        ((!hasU16Sizeofdetailinformation() && !rhs.hasU16Sizeofdetailinformation()) || getU16Sizeofdetailinformation() == rhs.getU16Sizeofdetailinformation()) &&
        ((!hasU16Subcategorycode() && !rhs.hasU16Subcategorycode()) || getU16Subcategorycode() == rhs.getU16Subcategorycode()) &&
        ((!hasU32POIID() && !rhs.hasU32POIID()) || getU32POIID() == rhs.getU32POIID()) &&
        ((!hasU32UserrestrictionID() && !rhs.hasU32UserrestrictionID()) || getU32UserrestrictionID() == rhs.getU32UserrestrictionID()) &&
        ((!hasU8_24hoursadayinformation() && !rhs.hasU8_24hoursadayinformation()) || getU8_24hoursadayinformation() == rhs.getU8_24hoursadayinformation()) &&
        ((!hasU8Businessdayoftheweekinformation() && !rhs.hasU8Businessdayoftheweekinformation()) || getU8Businessdayoftheweekinformation() == rhs.getU8Businessdayoftheweekinformation()) &&
        ((!hasU8Chargingfeeinformation() && !rhs.hasU8Chargingfeeinformation()) || getU8Chargingfeeinformation() == rhs.getU8Chargingfeeinformation()) &&
        ((!hasU8Chargingtype() && !rhs.hasU8Chargingtype()) || getU8Chargingtype() == rhs.getU8Chargingtype()) &&
        ((!hasU8Detailsinformation() && !rhs.hasU8Detailsinformation()) || getU8Detailsinformation() == rhs.getU8Detailsinformation()) &&
        ((!hasU8Entranceinformation() && !rhs.hasU8Entranceinformation()) || getU8Entranceinformation() == rhs.getU8Entranceinformation()) &&
        ((!hasU8Expresswaygeneraltype() && !rhs.hasU8Expresswaygeneraltype()) || getU8Expresswaygeneraltype() == rhs.getU8Expresswaygeneraltype()) &&
        ((!hasU8Fixedvalue1() && !rhs.hasU8Fixedvalue1()) || getU8Fixedvalue1() == rhs.getU8Fixedvalue1()) &&
        ((!hasU8Fixedvalue2() && !rhs.hasU8Fixedvalue2()) || getU8Fixedvalue2() == rhs.getU8Fixedvalue2()) &&
        ((!hasU8Informationreliability() && !rhs.hasU8Informationreliability()) || getU8Informationreliability() == rhs.getU8Informationreliability()) &&
        ((!hasU8Installationfacilityinformation() && !rhs.hasU8Installationfacilityinformation()) || getU8Installationfacilityinformation() == rhs.getU8Installationfacilityinformation()) &&
        ((!hasU8Nearthefacilityinformation() && !rhs.hasU8Nearthefacilityinformation()) || getU8Nearthefacilityinformation() == rhs.getU8Nearthefacilityinformation()) &&
        ((!hasU8Officehoursunknowninformation() && !rhs.hasU8Officehoursunknowninformation()) || getU8Officehoursunknowninformation() == rhs.getU8Officehoursunknowninformation()) &&
        ((!hasU8Partnersfacilityinformation() && !rhs.hasU8Partnersfacilityinformation()) || getU8Partnersfacilityinformation() == rhs.getU8Partnersfacilityinformation()) &&
        ((!hasU8SizeOfPOIName() && !rhs.hasU8SizeOfPOIName()) || getU8SizeOfPOIName() == rhs.getU8SizeOfPOIName()) &&
        ((!hasU8SizeOfStreetAndHouseNo() && !rhs.hasU8SizeOfStreetAndHouseNo()) || getU8SizeOfStreetAndHouseNo() == rhs.getU8SizeOfStreetAndHouseNo()) &&
        ((!hasU8SizeOfTelephonenumber() && !rhs.hasU8SizeOfTelephonenumber()) || getU8SizeOfTelephonenumber() == rhs.getU8SizeOfTelephonenumber()) &&
        ((!hasU8Thenumberofentranceinformation() && !rhs.hasU8Thenumberofentranceinformation()) || getU8Thenumberofentranceinformation() == rhs.getU8Thenumberofentranceinformation()) &&
        ((!hasU8Thenumberofinstallationfacilityinformation() && !rhs.hasU8Thenumberofinstallationfacilityinformation()) || getU8Thenumberofinstallationfacilityinformation() == rhs.getU8Thenumberofinstallationfacilityinformation()) &&
        ((!hasU8Thenumberofpartnersfacilityinformation() && !rhs.hasU8Thenumberofpartnersfacilityinformation()) || getU8Thenumberofpartnersfacilityinformation() == rhs.getU8Thenumberofpartnersfacilityinformation()) &&
        ((!hasU8Thetotalnumberofchargingtype() && !rhs.hasU8Thetotalnumberofchargingtype()) || getU8Thetotalnumberofchargingtype() == rhs.getU8Thetotalnumberofchargingtype()) &&
        ((!hasU8Userrestriction() && !rhs.hasU8Userrestriction()) || getU8Userrestriction() == rhs.getU8Userrestriction()));
}

inline bool T_tcu_vacancy_spot_data::operator != (const T_tcu_vacancy_spot_data& rhs) const {
    return ! (*this == rhs);
}

inline bool T_tcu_vacancy_spot_data::operator < (const T_tcu_vacancy_spot_data& rhs) const {
    if (hasLocation() || rhs.hasLocation()) {
        if (getLocation() < rhs.getLocation()) return true;
        if (getLocation() > rhs.getLocation()) return false;
    }
    if (hasStrAreaCode1() || rhs.hasStrAreaCode1()) {
        if (getStrAreaCode1() < rhs.getStrAreaCode1()) return true;
        if (getStrAreaCode1() > rhs.getStrAreaCode1()) return false;
    }
    if (hasStrAreaCode2() || rhs.hasStrAreaCode2()) {
        if (getStrAreaCode2() < rhs.getStrAreaCode2()) return true;
        if (getStrAreaCode2() > rhs.getStrAreaCode2()) return false;
    }
    if (hasStrAreaCode3() || rhs.hasStrAreaCode3()) {
        if (getStrAreaCode3() < rhs.getStrAreaCode3()) return true;
        if (getStrAreaCode3() > rhs.getStrAreaCode3()) return false;
    }
    if (hasStrAreaCode4() || rhs.hasStrAreaCode4()) {
        if (getStrAreaCode4() < rhs.getStrAreaCode4()) return true;
        if (getStrAreaCode4() > rhs.getStrAreaCode4()) return false;
    }
    if (hasStrAreaCode5() || rhs.hasStrAreaCode5()) {
        if (getStrAreaCode5() < rhs.getStrAreaCode5()) return true;
        if (getStrAreaCode5() > rhs.getStrAreaCode5()) return false;
    }
    if (hasStrAreaCode6() || rhs.hasStrAreaCode6()) {
        if (getStrAreaCode6() < rhs.getStrAreaCode6()) return true;
        if (getStrAreaCode6() > rhs.getStrAreaCode6()) return false;
    }
    if (hasStrAreaCode7() || rhs.hasStrAreaCode7()) {
        if (getStrAreaCode7() < rhs.getStrAreaCode7()) return true;
        if (getStrAreaCode7() > rhs.getStrAreaCode7()) return false;
    }
    if (hasStrAreaCode8() || rhs.hasStrAreaCode8()) {
        if (getStrAreaCode8() < rhs.getStrAreaCode8()) return true;
        if (getStrAreaCode8() > rhs.getStrAreaCode8()) return false;
    }
    if (hasStrPOIName() || rhs.hasStrPOIName()) {
        if (getStrPOIName() < rhs.getStrPOIName()) return true;
        if (getStrPOIName() > rhs.getStrPOIName()) return false;
    }
    if (hasStrStreetAndHouseNo() || rhs.hasStrStreetAndHouseNo()) {
        if (getStrStreetAndHouseNo() < rhs.getStrStreetAndHouseNo()) return true;
        if (getStrStreetAndHouseNo() > rhs.getStrStreetAndHouseNo()) return false;
    }
    if (hasStrTelephonenumber() || rhs.hasStrTelephonenumber()) {
        if (getStrTelephonenumber() < rhs.getStrTelephonenumber()) return true;
        if (getStrTelephonenumber() > rhs.getStrTelephonenumber()) return false;
    }
    if (hasU16Categorycode() || rhs.hasU16Categorycode()) {
        if (getU16Categorycode() < rhs.getU16Categorycode()) return true;
        if (getU16Categorycode() > rhs.getU16Categorycode()) return false;
    }
    if (hasU16ClosedhourInformation() || rhs.hasU16ClosedhourInformation()) {
        if (getU16ClosedhourInformation() < rhs.getU16ClosedhourInformation()) return true;
        if (getU16ClosedhourInformation() > rhs.getU16ClosedhourInformation()) return false;
    }
    if (hasU16OpeninghourInformation() || rhs.hasU16OpeninghourInformation()) {
        if (getU16OpeninghourInformation() < rhs.getU16OpeninghourInformation()) return true;
        if (getU16OpeninghourInformation() > rhs.getU16OpeninghourInformation()) return false;
    }
    if (hasU16Parkingnumber() || rhs.hasU16Parkingnumber()) {
        if (getU16Parkingnumber() < rhs.getU16Parkingnumber()) return true;
        if (getU16Parkingnumber() > rhs.getU16Parkingnumber()) return false;
    }
    if (hasU16Paymenttypeinformation() || rhs.hasU16Paymenttypeinformation()) {
        if (getU16Paymenttypeinformation() < rhs.getU16Paymenttypeinformation()) return true;
        if (getU16Paymenttypeinformation() > rhs.getU16Paymenttypeinformation()) return false;
    }
    if (hasU16Sizeofdetailinformation() || rhs.hasU16Sizeofdetailinformation()) {
        if (getU16Sizeofdetailinformation() < rhs.getU16Sizeofdetailinformation()) return true;
        if (getU16Sizeofdetailinformation() > rhs.getU16Sizeofdetailinformation()) return false;
    }
    if (hasU16Subcategorycode() || rhs.hasU16Subcategorycode()) {
        if (getU16Subcategorycode() < rhs.getU16Subcategorycode()) return true;
        if (getU16Subcategorycode() > rhs.getU16Subcategorycode()) return false;
    }
    if (hasU32POIID() || rhs.hasU32POIID()) {
        if (getU32POIID() < rhs.getU32POIID()) return true;
        if (getU32POIID() > rhs.getU32POIID()) return false;
    }
    if (hasU32UserrestrictionID() || rhs.hasU32UserrestrictionID()) {
        if (getU32UserrestrictionID() < rhs.getU32UserrestrictionID()) return true;
        if (getU32UserrestrictionID() > rhs.getU32UserrestrictionID()) return false;
    }
    if (hasU8_24hoursadayinformation() || rhs.hasU8_24hoursadayinformation()) {
        if (getU8_24hoursadayinformation() < rhs.getU8_24hoursadayinformation()) return true;
        if (getU8_24hoursadayinformation() > rhs.getU8_24hoursadayinformation()) return false;
    }
    if (hasU8Businessdayoftheweekinformation() || rhs.hasU8Businessdayoftheweekinformation()) {
        if (getU8Businessdayoftheweekinformation() < rhs.getU8Businessdayoftheweekinformation()) return true;
        if (getU8Businessdayoftheweekinformation() > rhs.getU8Businessdayoftheweekinformation()) return false;
    }
    if (hasU8Chargingfeeinformation() || rhs.hasU8Chargingfeeinformation()) {
        if (getU8Chargingfeeinformation() < rhs.getU8Chargingfeeinformation()) return true;
        if (getU8Chargingfeeinformation() > rhs.getU8Chargingfeeinformation()) return false;
    }
    if (hasU8Chargingtype() || rhs.hasU8Chargingtype()) {
        if (getU8Chargingtype() < rhs.getU8Chargingtype()) return true;
        if (getU8Chargingtype() > rhs.getU8Chargingtype()) return false;
    }
    if (hasU8Detailsinformation() || rhs.hasU8Detailsinformation()) {
        if (getU8Detailsinformation() < rhs.getU8Detailsinformation()) return true;
        if (getU8Detailsinformation() > rhs.getU8Detailsinformation()) return false;
    }
    if (hasU8Entranceinformation() || rhs.hasU8Entranceinformation()) {
        if (getU8Entranceinformation() < rhs.getU8Entranceinformation()) return true;
        if (getU8Entranceinformation() > rhs.getU8Entranceinformation()) return false;
    }
    if (hasU8Expresswaygeneraltype() || rhs.hasU8Expresswaygeneraltype()) {
        if (getU8Expresswaygeneraltype() < rhs.getU8Expresswaygeneraltype()) return true;
        if (getU8Expresswaygeneraltype() > rhs.getU8Expresswaygeneraltype()) return false;
    }
    if (hasU8Fixedvalue1() || rhs.hasU8Fixedvalue1()) {
        if (getU8Fixedvalue1() < rhs.getU8Fixedvalue1()) return true;
        if (getU8Fixedvalue1() > rhs.getU8Fixedvalue1()) return false;
    }
    if (hasU8Fixedvalue2() || rhs.hasU8Fixedvalue2()) {
        if (getU8Fixedvalue2() < rhs.getU8Fixedvalue2()) return true;
        if (getU8Fixedvalue2() > rhs.getU8Fixedvalue2()) return false;
    }
    if (hasU8Informationreliability() || rhs.hasU8Informationreliability()) {
        if (getU8Informationreliability() < rhs.getU8Informationreliability()) return true;
        if (getU8Informationreliability() > rhs.getU8Informationreliability()) return false;
    }
    if (hasU8Installationfacilityinformation() || rhs.hasU8Installationfacilityinformation()) {
        if (getU8Installationfacilityinformation() < rhs.getU8Installationfacilityinformation()) return true;
        if (getU8Installationfacilityinformation() > rhs.getU8Installationfacilityinformation()) return false;
    }
    if (hasU8Nearthefacilityinformation() || rhs.hasU8Nearthefacilityinformation()) {
        if (getU8Nearthefacilityinformation() < rhs.getU8Nearthefacilityinformation()) return true;
        if (getU8Nearthefacilityinformation() > rhs.getU8Nearthefacilityinformation()) return false;
    }
    if (hasU8Officehoursunknowninformation() || rhs.hasU8Officehoursunknowninformation()) {
        if (getU8Officehoursunknowninformation() < rhs.getU8Officehoursunknowninformation()) return true;
        if (getU8Officehoursunknowninformation() > rhs.getU8Officehoursunknowninformation()) return false;
    }
    if (hasU8Partnersfacilityinformation() || rhs.hasU8Partnersfacilityinformation()) {
        if (getU8Partnersfacilityinformation() < rhs.getU8Partnersfacilityinformation()) return true;
        if (getU8Partnersfacilityinformation() > rhs.getU8Partnersfacilityinformation()) return false;
    }
    if (hasU8SizeOfPOIName() || rhs.hasU8SizeOfPOIName()) {
        if (getU8SizeOfPOIName() < rhs.getU8SizeOfPOIName()) return true;
        if (getU8SizeOfPOIName() > rhs.getU8SizeOfPOIName()) return false;
    }
    if (hasU8SizeOfStreetAndHouseNo() || rhs.hasU8SizeOfStreetAndHouseNo()) {
        if (getU8SizeOfStreetAndHouseNo() < rhs.getU8SizeOfStreetAndHouseNo()) return true;
        if (getU8SizeOfStreetAndHouseNo() > rhs.getU8SizeOfStreetAndHouseNo()) return false;
    }
    if (hasU8SizeOfTelephonenumber() || rhs.hasU8SizeOfTelephonenumber()) {
        if (getU8SizeOfTelephonenumber() < rhs.getU8SizeOfTelephonenumber()) return true;
        if (getU8SizeOfTelephonenumber() > rhs.getU8SizeOfTelephonenumber()) return false;
    }
    if (hasU8Thenumberofentranceinformation() || rhs.hasU8Thenumberofentranceinformation()) {
        if (getU8Thenumberofentranceinformation() < rhs.getU8Thenumberofentranceinformation()) return true;
        if (getU8Thenumberofentranceinformation() > rhs.getU8Thenumberofentranceinformation()) return false;
    }
    if (hasU8Thenumberofinstallationfacilityinformation() || rhs.hasU8Thenumberofinstallationfacilityinformation()) {
        if (getU8Thenumberofinstallationfacilityinformation() < rhs.getU8Thenumberofinstallationfacilityinformation()) return true;
        if (getU8Thenumberofinstallationfacilityinformation() > rhs.getU8Thenumberofinstallationfacilityinformation()) return false;
    }
    if (hasU8Thenumberofpartnersfacilityinformation() || rhs.hasU8Thenumberofpartnersfacilityinformation()) {
        if (getU8Thenumberofpartnersfacilityinformation() < rhs.getU8Thenumberofpartnersfacilityinformation()) return true;
        if (getU8Thenumberofpartnersfacilityinformation() > rhs.getU8Thenumberofpartnersfacilityinformation()) return false;
    }
    if (hasU8Thetotalnumberofchargingtype() || rhs.hasU8Thetotalnumberofchargingtype()) {
        if (getU8Thetotalnumberofchargingtype() < rhs.getU8Thetotalnumberofchargingtype()) return true;
        if (getU8Thetotalnumberofchargingtype() > rhs.getU8Thetotalnumberofchargingtype()) return false;
    }
    if (hasU8Userrestriction() || rhs.hasU8Userrestriction()) {
        if (getU8Userrestriction() < rhs.getU8Userrestriction()) return true;
        if (getU8Userrestriction() > rhs.getU8Userrestriction()) return false;
    }
    return false;
}

inline bool T_tcu_vacancy_spot_data::operator > (const T_tcu_vacancy_spot_data& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_tcu_vacancy_spot_data::clear() {
    clearLocation();
    clearStrAreaCode1();
    clearStrAreaCode2();
    clearStrAreaCode3();
    clearStrAreaCode4();
    clearStrAreaCode5();
    clearStrAreaCode6();
    clearStrAreaCode7();
    clearStrAreaCode8();
    clearStrPOIName();
    clearStrStreetAndHouseNo();
    clearStrTelephonenumber();
    clearU16Categorycode();
    clearU16ClosedhourInformation();
    clearU16OpeninghourInformation();
    clearU16Parkingnumber();
    clearU16Paymenttypeinformation();
    clearU16Sizeofdetailinformation();
    clearU16Subcategorycode();
    clearU32POIID();
    clearU32UserrestrictionID();
    clearU8_24hoursadayinformation();
    clearU8Businessdayoftheweekinformation();
    clearU8Chargingfeeinformation();
    clearU8Chargingtype();
    clearU8Detailsinformation();
    clearU8Entranceinformation();
    clearU8Expresswaygeneraltype();
    clearU8Fixedvalue1();
    clearU8Fixedvalue2();
    clearU8Informationreliability();
    clearU8Installationfacilityinformation();
    clearU8Nearthefacilityinformation();
    clearU8Officehoursunknowninformation();
    clearU8Partnersfacilityinformation();
    clearU8SizeOfPOIName();
    clearU8SizeOfStreetAndHouseNo();
    clearU8SizeOfTelephonenumber();
    clearU8Thenumberofentranceinformation();
    clearU8Thenumberofinstallationfacilityinformation();
    clearU8Thenumberofpartnersfacilityinformation();
    clearU8Thetotalnumberofchargingtype();
    clearU8Userrestriction();
}

inline void T_tcu_vacancy_spot_data::clearLocation() {
    if (hasLocation()) {
         clear_has_Location();
        _Location.clear();
     }
}

inline bool T_tcu_vacancy_spot_data::hasLocation () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const T_usb_tcu_Location& T_tcu_vacancy_spot_data::getLocation () const {
    return _Location;
}

inline T_usb_tcu_Location& T_tcu_vacancy_spot_data::getLocationMutable () {
    set_has_Location();
    return _Location;
}

inline void T_tcu_vacancy_spot_data::setLocation (const T_usb_tcu_Location& Location_) {
    set_has_Location();
    this->_Location = Location_;
}

inline void T_tcu_vacancy_spot_data::clearStrAreaCode1() {
    if (hasStrAreaCode1()) {
         clear_has_strAreaCode1();
        _strAreaCode1.clear();
     }
}

inline bool T_tcu_vacancy_spot_data::hasStrAreaCode1 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_tcu_vacancy_spot_data::getStrAreaCode1 () const {
    return _strAreaCode1;
}

inline ::std::string& T_tcu_vacancy_spot_data::getStrAreaCode1Mutable () {
    set_has_strAreaCode1();
    return _strAreaCode1;
}

inline void T_tcu_vacancy_spot_data::setStrAreaCode1 (const ::std::string& strAreaCode1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strAreaCode1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strAreaCode1();
    this->_strAreaCode1 = strAreaCode1_;
}

inline void T_tcu_vacancy_spot_data::setStrAreaCode1 (const char* strAreaCode1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strAreaCode1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strAreaCode1();
    this->_strAreaCode1.assign(strAreaCode1_);
}

inline void T_tcu_vacancy_spot_data::setStrAreaCode1 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strAreaCode1();
    this->_strAreaCode1.assign(value, size);
}

inline void T_tcu_vacancy_spot_data::clearStrAreaCode2() {
    if (hasStrAreaCode2()) {
         clear_has_strAreaCode2();
        _strAreaCode2.clear();
     }
}

inline bool T_tcu_vacancy_spot_data::hasStrAreaCode2 () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& T_tcu_vacancy_spot_data::getStrAreaCode2 () const {
    return _strAreaCode2;
}

inline ::std::string& T_tcu_vacancy_spot_data::getStrAreaCode2Mutable () {
    set_has_strAreaCode2();
    return _strAreaCode2;
}

inline void T_tcu_vacancy_spot_data::setStrAreaCode2 (const ::std::string& strAreaCode2_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strAreaCode2_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strAreaCode2();
    this->_strAreaCode2 = strAreaCode2_;
}

inline void T_tcu_vacancy_spot_data::setStrAreaCode2 (const char* strAreaCode2_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strAreaCode2_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strAreaCode2();
    this->_strAreaCode2.assign(strAreaCode2_);
}

inline void T_tcu_vacancy_spot_data::setStrAreaCode2 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strAreaCode2();
    this->_strAreaCode2.assign(value, size);
}

inline void T_tcu_vacancy_spot_data::clearStrAreaCode3() {
    if (hasStrAreaCode3()) {
         clear_has_strAreaCode3();
        _strAreaCode3.clear();
     }
}

inline bool T_tcu_vacancy_spot_data::hasStrAreaCode3 () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& T_tcu_vacancy_spot_data::getStrAreaCode3 () const {
    return _strAreaCode3;
}

inline ::std::string& T_tcu_vacancy_spot_data::getStrAreaCode3Mutable () {
    set_has_strAreaCode3();
    return _strAreaCode3;
}

inline void T_tcu_vacancy_spot_data::setStrAreaCode3 (const ::std::string& strAreaCode3_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strAreaCode3_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strAreaCode3();
    this->_strAreaCode3 = strAreaCode3_;
}

inline void T_tcu_vacancy_spot_data::setStrAreaCode3 (const char* strAreaCode3_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strAreaCode3_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strAreaCode3();
    this->_strAreaCode3.assign(strAreaCode3_);
}

inline void T_tcu_vacancy_spot_data::setStrAreaCode3 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strAreaCode3();
    this->_strAreaCode3.assign(value, size);
}

inline void T_tcu_vacancy_spot_data::clearStrAreaCode4() {
    if (hasStrAreaCode4()) {
         clear_has_strAreaCode4();
        _strAreaCode4.clear();
     }
}

inline bool T_tcu_vacancy_spot_data::hasStrAreaCode4 () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& T_tcu_vacancy_spot_data::getStrAreaCode4 () const {
    return _strAreaCode4;
}

inline ::std::string& T_tcu_vacancy_spot_data::getStrAreaCode4Mutable () {
    set_has_strAreaCode4();
    return _strAreaCode4;
}

inline void T_tcu_vacancy_spot_data::setStrAreaCode4 (const ::std::string& strAreaCode4_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strAreaCode4_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strAreaCode4();
    this->_strAreaCode4 = strAreaCode4_;
}

inline void T_tcu_vacancy_spot_data::setStrAreaCode4 (const char* strAreaCode4_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strAreaCode4_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strAreaCode4();
    this->_strAreaCode4.assign(strAreaCode4_);
}

inline void T_tcu_vacancy_spot_data::setStrAreaCode4 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strAreaCode4();
    this->_strAreaCode4.assign(value, size);
}

inline void T_tcu_vacancy_spot_data::clearStrAreaCode5() {
    if (hasStrAreaCode5()) {
         clear_has_strAreaCode5();
        _strAreaCode5.clear();
     }
}

inline bool T_tcu_vacancy_spot_data::hasStrAreaCode5 () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::std::string& T_tcu_vacancy_spot_data::getStrAreaCode5 () const {
    return _strAreaCode5;
}

inline ::std::string& T_tcu_vacancy_spot_data::getStrAreaCode5Mutable () {
    set_has_strAreaCode5();
    return _strAreaCode5;
}

inline void T_tcu_vacancy_spot_data::setStrAreaCode5 (const ::std::string& strAreaCode5_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strAreaCode5_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strAreaCode5();
    this->_strAreaCode5 = strAreaCode5_;
}

inline void T_tcu_vacancy_spot_data::setStrAreaCode5 (const char* strAreaCode5_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strAreaCode5_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strAreaCode5();
    this->_strAreaCode5.assign(strAreaCode5_);
}

inline void T_tcu_vacancy_spot_data::setStrAreaCode5 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strAreaCode5();
    this->_strAreaCode5.assign(value, size);
}

inline void T_tcu_vacancy_spot_data::clearStrAreaCode6() {
    if (hasStrAreaCode6()) {
         clear_has_strAreaCode6();
        _strAreaCode6.clear();
     }
}

inline bool T_tcu_vacancy_spot_data::hasStrAreaCode6 () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline const ::std::string& T_tcu_vacancy_spot_data::getStrAreaCode6 () const {
    return _strAreaCode6;
}

inline ::std::string& T_tcu_vacancy_spot_data::getStrAreaCode6Mutable () {
    set_has_strAreaCode6();
    return _strAreaCode6;
}

inline void T_tcu_vacancy_spot_data::setStrAreaCode6 (const ::std::string& strAreaCode6_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strAreaCode6_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strAreaCode6();
    this->_strAreaCode6 = strAreaCode6_;
}

inline void T_tcu_vacancy_spot_data::setStrAreaCode6 (const char* strAreaCode6_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strAreaCode6_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strAreaCode6();
    this->_strAreaCode6.assign(strAreaCode6_);
}

inline void T_tcu_vacancy_spot_data::setStrAreaCode6 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strAreaCode6();
    this->_strAreaCode6.assign(value, size);
}

inline void T_tcu_vacancy_spot_data::clearStrAreaCode7() {
    if (hasStrAreaCode7()) {
         clear_has_strAreaCode7();
        _strAreaCode7.clear();
     }
}

inline bool T_tcu_vacancy_spot_data::hasStrAreaCode7 () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline const ::std::string& T_tcu_vacancy_spot_data::getStrAreaCode7 () const {
    return _strAreaCode7;
}

inline ::std::string& T_tcu_vacancy_spot_data::getStrAreaCode7Mutable () {
    set_has_strAreaCode7();
    return _strAreaCode7;
}

inline void T_tcu_vacancy_spot_data::setStrAreaCode7 (const ::std::string& strAreaCode7_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strAreaCode7_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strAreaCode7();
    this->_strAreaCode7 = strAreaCode7_;
}

inline void T_tcu_vacancy_spot_data::setStrAreaCode7 (const char* strAreaCode7_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strAreaCode7_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strAreaCode7();
    this->_strAreaCode7.assign(strAreaCode7_);
}

inline void T_tcu_vacancy_spot_data::setStrAreaCode7 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strAreaCode7();
    this->_strAreaCode7.assign(value, size);
}

inline void T_tcu_vacancy_spot_data::clearStrAreaCode8() {
    if (hasStrAreaCode8()) {
         clear_has_strAreaCode8();
        _strAreaCode8.clear();
     }
}

inline bool T_tcu_vacancy_spot_data::hasStrAreaCode8 () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline const ::std::string& T_tcu_vacancy_spot_data::getStrAreaCode8 () const {
    return _strAreaCode8;
}

inline ::std::string& T_tcu_vacancy_spot_data::getStrAreaCode8Mutable () {
    set_has_strAreaCode8();
    return _strAreaCode8;
}

inline void T_tcu_vacancy_spot_data::setStrAreaCode8 (const ::std::string& strAreaCode8_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strAreaCode8_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strAreaCode8();
    this->_strAreaCode8 = strAreaCode8_;
}

inline void T_tcu_vacancy_spot_data::setStrAreaCode8 (const char* strAreaCode8_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strAreaCode8_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strAreaCode8();
    this->_strAreaCode8.assign(strAreaCode8_);
}

inline void T_tcu_vacancy_spot_data::setStrAreaCode8 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strAreaCode8();
    this->_strAreaCode8.assign(value, size);
}

inline void T_tcu_vacancy_spot_data::clearStrPOIName() {
    if (hasStrPOIName()) {
         clear_has_strPOIName();
        _strPOIName.clear();
     }
}

inline bool T_tcu_vacancy_spot_data::hasStrPOIName () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline const ::std::string& T_tcu_vacancy_spot_data::getStrPOIName () const {
    return _strPOIName;
}

inline ::std::string& T_tcu_vacancy_spot_data::getStrPOINameMutable () {
    set_has_strPOIName();
    return _strPOIName;
}

inline void T_tcu_vacancy_spot_data::setStrPOIName (const ::std::string& strPOIName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strPOIName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strPOIName();
    this->_strPOIName = strPOIName_;
}

inline void T_tcu_vacancy_spot_data::setStrPOIName (const char* strPOIName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strPOIName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strPOIName();
    this->_strPOIName.assign(strPOIName_);
}

inline void T_tcu_vacancy_spot_data::setStrPOIName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strPOIName();
    this->_strPOIName.assign(value, size);
}

inline void T_tcu_vacancy_spot_data::clearStrStreetAndHouseNo() {
    if (hasStrStreetAndHouseNo()) {
         clear_has_strStreetAndHouseNo();
        _strStreetAndHouseNo.clear();
     }
}

inline bool T_tcu_vacancy_spot_data::hasStrStreetAndHouseNo () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline const ::std::string& T_tcu_vacancy_spot_data::getStrStreetAndHouseNo () const {
    return _strStreetAndHouseNo;
}

inline ::std::string& T_tcu_vacancy_spot_data::getStrStreetAndHouseNoMutable () {
    set_has_strStreetAndHouseNo();
    return _strStreetAndHouseNo;
}

inline void T_tcu_vacancy_spot_data::setStrStreetAndHouseNo (const ::std::string& strStreetAndHouseNo_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strStreetAndHouseNo_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strStreetAndHouseNo();
    this->_strStreetAndHouseNo = strStreetAndHouseNo_;
}

inline void T_tcu_vacancy_spot_data::setStrStreetAndHouseNo (const char* strStreetAndHouseNo_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strStreetAndHouseNo_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strStreetAndHouseNo();
    this->_strStreetAndHouseNo.assign(strStreetAndHouseNo_);
}

inline void T_tcu_vacancy_spot_data::setStrStreetAndHouseNo (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strStreetAndHouseNo();
    this->_strStreetAndHouseNo.assign(value, size);
}

inline void T_tcu_vacancy_spot_data::clearStrTelephonenumber() {
    if (hasStrTelephonenumber()) {
         clear_has_strTelephonenumber();
        _strTelephonenumber.clear();
     }
}

inline bool T_tcu_vacancy_spot_data::hasStrTelephonenumber () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline const ::std::string& T_tcu_vacancy_spot_data::getStrTelephonenumber () const {
    return _strTelephonenumber;
}

inline ::std::string& T_tcu_vacancy_spot_data::getStrTelephonenumberMutable () {
    set_has_strTelephonenumber();
    return _strTelephonenumber;
}

inline void T_tcu_vacancy_spot_data::setStrTelephonenumber (const ::std::string& strTelephonenumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strTelephonenumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strTelephonenumber();
    this->_strTelephonenumber = strTelephonenumber_;
}

inline void T_tcu_vacancy_spot_data::setStrTelephonenumber (const char* strTelephonenumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strTelephonenumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strTelephonenumber();
    this->_strTelephonenumber.assign(strTelephonenumber_);
}

inline void T_tcu_vacancy_spot_data::setStrTelephonenumber (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strTelephonenumber();
    this->_strTelephonenumber.assign(value, size);
}

inline void T_tcu_vacancy_spot_data::clearU16Categorycode() {
    if (hasU16Categorycode()) {
         clear_has_u16Categorycode();
        _u16Categorycode = 0u;
     }
}

inline bool T_tcu_vacancy_spot_data::hasU16Categorycode () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline uint16 T_tcu_vacancy_spot_data::getU16Categorycode () const {
    return _u16Categorycode;
}

inline void T_tcu_vacancy_spot_data::setU16Categorycode (uint16 u16Categorycode_) {
    set_has_u16Categorycode();
    this->_u16Categorycode = u16Categorycode_;
}

inline void T_tcu_vacancy_spot_data::clearU16ClosedhourInformation() {
    if (hasU16ClosedhourInformation()) {
         clear_has_u16ClosedhourInformation();
        _u16ClosedhourInformation = 0u;
     }
}

inline bool T_tcu_vacancy_spot_data::hasU16ClosedhourInformation () const {
    return (_has_bits_[0] & (1u << 13)) > 0;
}

inline uint16 T_tcu_vacancy_spot_data::getU16ClosedhourInformation () const {
    return _u16ClosedhourInformation;
}

inline void T_tcu_vacancy_spot_data::setU16ClosedhourInformation (uint16 u16ClosedhourInformation_) {
    set_has_u16ClosedhourInformation();
    this->_u16ClosedhourInformation = u16ClosedhourInformation_;
}

inline void T_tcu_vacancy_spot_data::clearU16OpeninghourInformation() {
    if (hasU16OpeninghourInformation()) {
         clear_has_u16OpeninghourInformation();
        _u16OpeninghourInformation = 0u;
     }
}

inline bool T_tcu_vacancy_spot_data::hasU16OpeninghourInformation () const {
    return (_has_bits_[0] & (1u << 14)) > 0;
}

inline uint16 T_tcu_vacancy_spot_data::getU16OpeninghourInformation () const {
    return _u16OpeninghourInformation;
}

inline void T_tcu_vacancy_spot_data::setU16OpeninghourInformation (uint16 u16OpeninghourInformation_) {
    set_has_u16OpeninghourInformation();
    this->_u16OpeninghourInformation = u16OpeninghourInformation_;
}

inline void T_tcu_vacancy_spot_data::clearU16Parkingnumber() {
    if (hasU16Parkingnumber()) {
         clear_has_u16Parkingnumber();
        _u16Parkingnumber = 0u;
     }
}

inline bool T_tcu_vacancy_spot_data::hasU16Parkingnumber () const {
    return (_has_bits_[0] & (1u << 15)) > 0;
}

inline uint16 T_tcu_vacancy_spot_data::getU16Parkingnumber () const {
    return _u16Parkingnumber;
}

inline void T_tcu_vacancy_spot_data::setU16Parkingnumber (uint16 u16Parkingnumber_) {
    set_has_u16Parkingnumber();
    this->_u16Parkingnumber = u16Parkingnumber_;
}

inline void T_tcu_vacancy_spot_data::clearU16Paymenttypeinformation() {
    if (hasU16Paymenttypeinformation()) {
         clear_has_u16Paymenttypeinformation();
        _u16Paymenttypeinformation = 0u;
     }
}

inline bool T_tcu_vacancy_spot_data::hasU16Paymenttypeinformation () const {
    return (_has_bits_[0] & (1u << 16)) > 0;
}

inline uint16 T_tcu_vacancy_spot_data::getU16Paymenttypeinformation () const {
    return _u16Paymenttypeinformation;
}

inline void T_tcu_vacancy_spot_data::setU16Paymenttypeinformation (uint16 u16Paymenttypeinformation_) {
    set_has_u16Paymenttypeinformation();
    this->_u16Paymenttypeinformation = u16Paymenttypeinformation_;
}

inline void T_tcu_vacancy_spot_data::clearU16Sizeofdetailinformation() {
    if (hasU16Sizeofdetailinformation()) {
         clear_has_u16Sizeofdetailinformation();
        _u16Sizeofdetailinformation = 0u;
     }
}

inline bool T_tcu_vacancy_spot_data::hasU16Sizeofdetailinformation () const {
    return (_has_bits_[0] & (1u << 17)) > 0;
}

inline uint16 T_tcu_vacancy_spot_data::getU16Sizeofdetailinformation () const {
    return _u16Sizeofdetailinformation;
}

inline void T_tcu_vacancy_spot_data::setU16Sizeofdetailinformation (uint16 u16Sizeofdetailinformation_) {
    set_has_u16Sizeofdetailinformation();
    this->_u16Sizeofdetailinformation = u16Sizeofdetailinformation_;
}

inline void T_tcu_vacancy_spot_data::clearU16Subcategorycode() {
    if (hasU16Subcategorycode()) {
         clear_has_u16Subcategorycode();
        _u16Subcategorycode = 0u;
     }
}

inline bool T_tcu_vacancy_spot_data::hasU16Subcategorycode () const {
    return (_has_bits_[0] & (1u << 18)) > 0;
}

inline uint16 T_tcu_vacancy_spot_data::getU16Subcategorycode () const {
    return _u16Subcategorycode;
}

inline void T_tcu_vacancy_spot_data::setU16Subcategorycode (uint16 u16Subcategorycode_) {
    set_has_u16Subcategorycode();
    this->_u16Subcategorycode = u16Subcategorycode_;
}

inline void T_tcu_vacancy_spot_data::clearU32POIID() {
    if (hasU32POIID()) {
         clear_has_u32POIID();
        _u32POIID = 0u;
     }
}

inline bool T_tcu_vacancy_spot_data::hasU32POIID () const {
    return (_has_bits_[0] & (1u << 19)) > 0;
}

inline uint32 T_tcu_vacancy_spot_data::getU32POIID () const {
    return _u32POIID;
}

inline void T_tcu_vacancy_spot_data::setU32POIID (uint32 u32POIID_) {
    set_has_u32POIID();
    this->_u32POIID = u32POIID_;
}

inline void T_tcu_vacancy_spot_data::clearU32UserrestrictionID() {
    if (hasU32UserrestrictionID()) {
         clear_has_u32UserrestrictionID();
        _u32UserrestrictionID = 0u;
     }
}

inline bool T_tcu_vacancy_spot_data::hasU32UserrestrictionID () const {
    return (_has_bits_[0] & (1u << 20)) > 0;
}

inline uint32 T_tcu_vacancy_spot_data::getU32UserrestrictionID () const {
    return _u32UserrestrictionID;
}

inline void T_tcu_vacancy_spot_data::setU32UserrestrictionID (uint32 u32UserrestrictionID_) {
    set_has_u32UserrestrictionID();
    this->_u32UserrestrictionID = u32UserrestrictionID_;
}

inline void T_tcu_vacancy_spot_data::clearU8_24hoursadayinformation() {
    if (hasU8_24hoursadayinformation()) {
         clear_has_u8_24hoursadayinformation();
        _u8_24hoursadayinformation = 0u;
     }
}

inline bool T_tcu_vacancy_spot_data::hasU8_24hoursadayinformation () const {
    return (_has_bits_[0] & (1u << 21)) > 0;
}

inline uint8 T_tcu_vacancy_spot_data::getU8_24hoursadayinformation () const {
    return _u8_24hoursadayinformation;
}

inline void T_tcu_vacancy_spot_data::setU8_24hoursadayinformation (uint8 u8_24hoursadayinformation_) {
    set_has_u8_24hoursadayinformation();
    this->_u8_24hoursadayinformation = u8_24hoursadayinformation_;
}

inline void T_tcu_vacancy_spot_data::clearU8Businessdayoftheweekinformation() {
    if (hasU8Businessdayoftheweekinformation()) {
         clear_has_u8Businessdayoftheweekinformation();
        _u8Businessdayoftheweekinformation = 0u;
     }
}

inline bool T_tcu_vacancy_spot_data::hasU8Businessdayoftheweekinformation () const {
    return (_has_bits_[0] & (1u << 22)) > 0;
}

inline uint8 T_tcu_vacancy_spot_data::getU8Businessdayoftheweekinformation () const {
    return _u8Businessdayoftheweekinformation;
}

inline void T_tcu_vacancy_spot_data::setU8Businessdayoftheweekinformation (uint8 u8Businessdayoftheweekinformation_) {
    set_has_u8Businessdayoftheweekinformation();
    this->_u8Businessdayoftheweekinformation = u8Businessdayoftheweekinformation_;
}

inline void T_tcu_vacancy_spot_data::clearU8Chargingfeeinformation() {
    if (hasU8Chargingfeeinformation()) {
         clear_has_u8Chargingfeeinformation();
        _u8Chargingfeeinformation = 0u;
     }
}

inline bool T_tcu_vacancy_spot_data::hasU8Chargingfeeinformation () const {
    return (_has_bits_[0] & (1u << 23)) > 0;
}

inline uint8 T_tcu_vacancy_spot_data::getU8Chargingfeeinformation () const {
    return _u8Chargingfeeinformation;
}

inline void T_tcu_vacancy_spot_data::setU8Chargingfeeinformation (uint8 u8Chargingfeeinformation_) {
    set_has_u8Chargingfeeinformation();
    this->_u8Chargingfeeinformation = u8Chargingfeeinformation_;
}

inline void T_tcu_vacancy_spot_data::clearU8Chargingtype() {
    if (hasU8Chargingtype()) {
         clear_has_u8Chargingtype();
        _u8Chargingtype = 0u;
     }
}

inline bool T_tcu_vacancy_spot_data::hasU8Chargingtype () const {
    return (_has_bits_[0] & (1u << 24)) > 0;
}

inline uint8 T_tcu_vacancy_spot_data::getU8Chargingtype () const {
    return _u8Chargingtype;
}

inline void T_tcu_vacancy_spot_data::setU8Chargingtype (uint8 u8Chargingtype_) {
    set_has_u8Chargingtype();
    this->_u8Chargingtype = u8Chargingtype_;
}

inline void T_tcu_vacancy_spot_data::clearU8Detailsinformation() {
    if (hasU8Detailsinformation()) {
         clear_has_u8Detailsinformation();
        _u8Detailsinformation = 0u;
     }
}

inline bool T_tcu_vacancy_spot_data::hasU8Detailsinformation () const {
    return (_has_bits_[0] & (1u << 25)) > 0;
}

inline uint8 T_tcu_vacancy_spot_data::getU8Detailsinformation () const {
    return _u8Detailsinformation;
}

inline void T_tcu_vacancy_spot_data::setU8Detailsinformation (uint8 u8Detailsinformation_) {
    set_has_u8Detailsinformation();
    this->_u8Detailsinformation = u8Detailsinformation_;
}

inline void T_tcu_vacancy_spot_data::clearU8Entranceinformation() {
    if (hasU8Entranceinformation()) {
         clear_has_u8Entranceinformation();
        _u8Entranceinformation = 0u;
     }
}

inline bool T_tcu_vacancy_spot_data::hasU8Entranceinformation () const {
    return (_has_bits_[0] & (1u << 26)) > 0;
}

inline uint8 T_tcu_vacancy_spot_data::getU8Entranceinformation () const {
    return _u8Entranceinformation;
}

inline void T_tcu_vacancy_spot_data::setU8Entranceinformation (uint8 u8Entranceinformation_) {
    set_has_u8Entranceinformation();
    this->_u8Entranceinformation = u8Entranceinformation_;
}

inline void T_tcu_vacancy_spot_data::clearU8Expresswaygeneraltype() {
    if (hasU8Expresswaygeneraltype()) {
         clear_has_u8Expresswaygeneraltype();
        _u8Expresswaygeneraltype = 0u;
     }
}

inline bool T_tcu_vacancy_spot_data::hasU8Expresswaygeneraltype () const {
    return (_has_bits_[0] & (1u << 27)) > 0;
}

inline uint8 T_tcu_vacancy_spot_data::getU8Expresswaygeneraltype () const {
    return _u8Expresswaygeneraltype;
}

inline void T_tcu_vacancy_spot_data::setU8Expresswaygeneraltype (uint8 u8Expresswaygeneraltype_) {
    set_has_u8Expresswaygeneraltype();
    this->_u8Expresswaygeneraltype = u8Expresswaygeneraltype_;
}

inline void T_tcu_vacancy_spot_data::clearU8Fixedvalue1() {
    if (hasU8Fixedvalue1()) {
         clear_has_u8Fixedvalue1();
        _u8Fixedvalue1 = 0u;
     }
}

inline bool T_tcu_vacancy_spot_data::hasU8Fixedvalue1 () const {
    return (_has_bits_[0] & (1u << 28)) > 0;
}

inline uint8 T_tcu_vacancy_spot_data::getU8Fixedvalue1 () const {
    return _u8Fixedvalue1;
}

inline void T_tcu_vacancy_spot_data::setU8Fixedvalue1 (uint8 u8Fixedvalue1_) {
    set_has_u8Fixedvalue1();
    this->_u8Fixedvalue1 = u8Fixedvalue1_;
}

inline void T_tcu_vacancy_spot_data::clearU8Fixedvalue2() {
    if (hasU8Fixedvalue2()) {
         clear_has_u8Fixedvalue2();
        _u8Fixedvalue2 = 0u;
     }
}

inline bool T_tcu_vacancy_spot_data::hasU8Fixedvalue2 () const {
    return (_has_bits_[0] & (1u << 29)) > 0;
}

inline uint8 T_tcu_vacancy_spot_data::getU8Fixedvalue2 () const {
    return _u8Fixedvalue2;
}

inline void T_tcu_vacancy_spot_data::setU8Fixedvalue2 (uint8 u8Fixedvalue2_) {
    set_has_u8Fixedvalue2();
    this->_u8Fixedvalue2 = u8Fixedvalue2_;
}

inline void T_tcu_vacancy_spot_data::clearU8Informationreliability() {
    if (hasU8Informationreliability()) {
         clear_has_u8Informationreliability();
        _u8Informationreliability = 0u;
     }
}

inline bool T_tcu_vacancy_spot_data::hasU8Informationreliability () const {
    return (_has_bits_[0] & (1u << 30)) > 0;
}

inline uint8 T_tcu_vacancy_spot_data::getU8Informationreliability () const {
    return _u8Informationreliability;
}

inline void T_tcu_vacancy_spot_data::setU8Informationreliability (uint8 u8Informationreliability_) {
    set_has_u8Informationreliability();
    this->_u8Informationreliability = u8Informationreliability_;
}

inline void T_tcu_vacancy_spot_data::clearU8Installationfacilityinformation() {
    if (hasU8Installationfacilityinformation()) {
         clear_has_u8Installationfacilityinformation();
        _u8Installationfacilityinformation = 0u;
     }
}

inline bool T_tcu_vacancy_spot_data::hasU8Installationfacilityinformation () const {
    return (_has_bits_[0] & (1u << 31)) > 0;
}

inline uint8 T_tcu_vacancy_spot_data::getU8Installationfacilityinformation () const {
    return _u8Installationfacilityinformation;
}

inline void T_tcu_vacancy_spot_data::setU8Installationfacilityinformation (uint8 u8Installationfacilityinformation_) {
    set_has_u8Installationfacilityinformation();
    this->_u8Installationfacilityinformation = u8Installationfacilityinformation_;
}

inline void T_tcu_vacancy_spot_data::clearU8Nearthefacilityinformation() {
    if (hasU8Nearthefacilityinformation()) {
         clear_has_u8Nearthefacilityinformation();
        _u8Nearthefacilityinformation = 0u;
     }
}

inline bool T_tcu_vacancy_spot_data::hasU8Nearthefacilityinformation () const {
    return (_has_bits_[1] & (1u << 0)) > 0;
}

inline uint8 T_tcu_vacancy_spot_data::getU8Nearthefacilityinformation () const {
    return _u8Nearthefacilityinformation;
}

inline void T_tcu_vacancy_spot_data::setU8Nearthefacilityinformation (uint8 u8Nearthefacilityinformation_) {
    set_has_u8Nearthefacilityinformation();
    this->_u8Nearthefacilityinformation = u8Nearthefacilityinformation_;
}

inline void T_tcu_vacancy_spot_data::clearU8Officehoursunknowninformation() {
    if (hasU8Officehoursunknowninformation()) {
         clear_has_u8Officehoursunknowninformation();
        _u8Officehoursunknowninformation = 0u;
     }
}

inline bool T_tcu_vacancy_spot_data::hasU8Officehoursunknowninformation () const {
    return (_has_bits_[1] & (1u << 1)) > 0;
}

inline uint8 T_tcu_vacancy_spot_data::getU8Officehoursunknowninformation () const {
    return _u8Officehoursunknowninformation;
}

inline void T_tcu_vacancy_spot_data::setU8Officehoursunknowninformation (uint8 u8Officehoursunknowninformation_) {
    set_has_u8Officehoursunknowninformation();
    this->_u8Officehoursunknowninformation = u8Officehoursunknowninformation_;
}

inline void T_tcu_vacancy_spot_data::clearU8Partnersfacilityinformation() {
    if (hasU8Partnersfacilityinformation()) {
         clear_has_u8Partnersfacilityinformation();
        _u8Partnersfacilityinformation = 0u;
     }
}

inline bool T_tcu_vacancy_spot_data::hasU8Partnersfacilityinformation () const {
    return (_has_bits_[1] & (1u << 2)) > 0;
}

inline uint8 T_tcu_vacancy_spot_data::getU8Partnersfacilityinformation () const {
    return _u8Partnersfacilityinformation;
}

inline void T_tcu_vacancy_spot_data::setU8Partnersfacilityinformation (uint8 u8Partnersfacilityinformation_) {
    set_has_u8Partnersfacilityinformation();
    this->_u8Partnersfacilityinformation = u8Partnersfacilityinformation_;
}

inline void T_tcu_vacancy_spot_data::clearU8SizeOfPOIName() {
    if (hasU8SizeOfPOIName()) {
         clear_has_u8SizeOfPOIName();
        _u8SizeOfPOIName = 0u;
     }
}

inline bool T_tcu_vacancy_spot_data::hasU8SizeOfPOIName () const {
    return (_has_bits_[1] & (1u << 3)) > 0;
}

inline uint8 T_tcu_vacancy_spot_data::getU8SizeOfPOIName () const {
    return _u8SizeOfPOIName;
}

inline void T_tcu_vacancy_spot_data::setU8SizeOfPOIName (uint8 u8SizeOfPOIName_) {
    set_has_u8SizeOfPOIName();
    this->_u8SizeOfPOIName = u8SizeOfPOIName_;
}

inline void T_tcu_vacancy_spot_data::clearU8SizeOfStreetAndHouseNo() {
    if (hasU8SizeOfStreetAndHouseNo()) {
         clear_has_u8SizeOfStreetAndHouseNo();
        _u8SizeOfStreetAndHouseNo = 0u;
     }
}

inline bool T_tcu_vacancy_spot_data::hasU8SizeOfStreetAndHouseNo () const {
    return (_has_bits_[1] & (1u << 4)) > 0;
}

inline uint8 T_tcu_vacancy_spot_data::getU8SizeOfStreetAndHouseNo () const {
    return _u8SizeOfStreetAndHouseNo;
}

inline void T_tcu_vacancy_spot_data::setU8SizeOfStreetAndHouseNo (uint8 u8SizeOfStreetAndHouseNo_) {
    set_has_u8SizeOfStreetAndHouseNo();
    this->_u8SizeOfStreetAndHouseNo = u8SizeOfStreetAndHouseNo_;
}

inline void T_tcu_vacancy_spot_data::clearU8SizeOfTelephonenumber() {
    if (hasU8SizeOfTelephonenumber()) {
         clear_has_u8SizeOfTelephonenumber();
        _u8SizeOfTelephonenumber = 0u;
     }
}

inline bool T_tcu_vacancy_spot_data::hasU8SizeOfTelephonenumber () const {
    return (_has_bits_[1] & (1u << 5)) > 0;
}

inline uint8 T_tcu_vacancy_spot_data::getU8SizeOfTelephonenumber () const {
    return _u8SizeOfTelephonenumber;
}

inline void T_tcu_vacancy_spot_data::setU8SizeOfTelephonenumber (uint8 u8SizeOfTelephonenumber_) {
    set_has_u8SizeOfTelephonenumber();
    this->_u8SizeOfTelephonenumber = u8SizeOfTelephonenumber_;
}

inline void T_tcu_vacancy_spot_data::clearU8Thenumberofentranceinformation() {
    if (hasU8Thenumberofentranceinformation()) {
         clear_has_u8Thenumberofentranceinformation();
        _u8Thenumberofentranceinformation = 0u;
     }
}

inline bool T_tcu_vacancy_spot_data::hasU8Thenumberofentranceinformation () const {
    return (_has_bits_[1] & (1u << 6)) > 0;
}

inline uint8 T_tcu_vacancy_spot_data::getU8Thenumberofentranceinformation () const {
    return _u8Thenumberofentranceinformation;
}

inline void T_tcu_vacancy_spot_data::setU8Thenumberofentranceinformation (uint8 u8Thenumberofentranceinformation_) {
    set_has_u8Thenumberofentranceinformation();
    this->_u8Thenumberofentranceinformation = u8Thenumberofentranceinformation_;
}

inline void T_tcu_vacancy_spot_data::clearU8Thenumberofinstallationfacilityinformation() {
    if (hasU8Thenumberofinstallationfacilityinformation()) {
         clear_has_u8Thenumberofinstallationfacilityinformation();
        _u8Thenumberofinstallationfacilityinformation = 0u;
     }
}

inline bool T_tcu_vacancy_spot_data::hasU8Thenumberofinstallationfacilityinformation () const {
    return (_has_bits_[1] & (1u << 7)) > 0;
}

inline uint8 T_tcu_vacancy_spot_data::getU8Thenumberofinstallationfacilityinformation () const {
    return _u8Thenumberofinstallationfacilityinformation;
}

inline void T_tcu_vacancy_spot_data::setU8Thenumberofinstallationfacilityinformation (uint8 u8Thenumberofinstallationfacilityinformation_) {
    set_has_u8Thenumberofinstallationfacilityinformation();
    this->_u8Thenumberofinstallationfacilityinformation = u8Thenumberofinstallationfacilityinformation_;
}

inline void T_tcu_vacancy_spot_data::clearU8Thenumberofpartnersfacilityinformation() {
    if (hasU8Thenumberofpartnersfacilityinformation()) {
         clear_has_u8Thenumberofpartnersfacilityinformation();
        _u8Thenumberofpartnersfacilityinformation = 0u;
     }
}

inline bool T_tcu_vacancy_spot_data::hasU8Thenumberofpartnersfacilityinformation () const {
    return (_has_bits_[1] & (1u << 8)) > 0;
}

inline uint8 T_tcu_vacancy_spot_data::getU8Thenumberofpartnersfacilityinformation () const {
    return _u8Thenumberofpartnersfacilityinformation;
}

inline void T_tcu_vacancy_spot_data::setU8Thenumberofpartnersfacilityinformation (uint8 u8Thenumberofpartnersfacilityinformation_) {
    set_has_u8Thenumberofpartnersfacilityinformation();
    this->_u8Thenumberofpartnersfacilityinformation = u8Thenumberofpartnersfacilityinformation_;
}

inline void T_tcu_vacancy_spot_data::clearU8Thetotalnumberofchargingtype() {
    if (hasU8Thetotalnumberofchargingtype()) {
         clear_has_u8Thetotalnumberofchargingtype();
        _u8Thetotalnumberofchargingtype = 0u;
     }
}

inline bool T_tcu_vacancy_spot_data::hasU8Thetotalnumberofchargingtype () const {
    return (_has_bits_[1] & (1u << 9)) > 0;
}

inline uint8 T_tcu_vacancy_spot_data::getU8Thetotalnumberofchargingtype () const {
    return _u8Thetotalnumberofchargingtype;
}

inline void T_tcu_vacancy_spot_data::setU8Thetotalnumberofchargingtype (uint8 u8Thetotalnumberofchargingtype_) {
    set_has_u8Thetotalnumberofchargingtype();
    this->_u8Thetotalnumberofchargingtype = u8Thetotalnumberofchargingtype_;
}

inline void T_tcu_vacancy_spot_data::clearU8Userrestriction() {
    if (hasU8Userrestriction()) {
         clear_has_u8Userrestriction();
        _u8Userrestriction = 0u;
     }
}

inline bool T_tcu_vacancy_spot_data::hasU8Userrestriction () const {
    return (_has_bits_[1] & (1u << 10)) > 0;
}

inline uint8 T_tcu_vacancy_spot_data::getU8Userrestriction () const {
    return _u8Userrestriction;
}

inline void T_tcu_vacancy_spot_data::setU8Userrestriction (uint8 u8Userrestriction_) {
    set_has_u8Userrestriction();
    this->_u8Userrestriction = u8Userrestriction_;
}

inline void T_tcu_vacancy_spot_data::set_has_Location () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_tcu_vacancy_spot_data::clear_has_Location () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_tcu_vacancy_spot_data::set_has_strAreaCode1 () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_tcu_vacancy_spot_data::clear_has_strAreaCode1 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_tcu_vacancy_spot_data::set_has_strAreaCode2 () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_tcu_vacancy_spot_data::clear_has_strAreaCode2 () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_tcu_vacancy_spot_data::set_has_strAreaCode3 () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_tcu_vacancy_spot_data::clear_has_strAreaCode3 () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_tcu_vacancy_spot_data::set_has_strAreaCode4 () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_tcu_vacancy_spot_data::clear_has_strAreaCode4 () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_tcu_vacancy_spot_data::set_has_strAreaCode5 () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_tcu_vacancy_spot_data::clear_has_strAreaCode5 () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_tcu_vacancy_spot_data::set_has_strAreaCode6 () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_tcu_vacancy_spot_data::clear_has_strAreaCode6 () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_tcu_vacancy_spot_data::set_has_strAreaCode7 () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_tcu_vacancy_spot_data::clear_has_strAreaCode7 () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_tcu_vacancy_spot_data::set_has_strAreaCode8 () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_tcu_vacancy_spot_data::clear_has_strAreaCode8 () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_tcu_vacancy_spot_data::set_has_strPOIName () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_tcu_vacancy_spot_data::clear_has_strPOIName () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_tcu_vacancy_spot_data::set_has_strStreetAndHouseNo () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_tcu_vacancy_spot_data::clear_has_strStreetAndHouseNo () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void T_tcu_vacancy_spot_data::set_has_strTelephonenumber () {
    _has_bits_[0] |= 1u << 11;
}

inline void T_tcu_vacancy_spot_data::clear_has_strTelephonenumber () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void T_tcu_vacancy_spot_data::set_has_u16Categorycode () {
    _has_bits_[0] |= 1u << 12;
}

inline void T_tcu_vacancy_spot_data::clear_has_u16Categorycode () {
    _has_bits_[0] &= ~ (1u << 12);
}

inline void T_tcu_vacancy_spot_data::set_has_u16ClosedhourInformation () {
    _has_bits_[0] |= 1u << 13;
}

inline void T_tcu_vacancy_spot_data::clear_has_u16ClosedhourInformation () {
    _has_bits_[0] &= ~ (1u << 13);
}

inline void T_tcu_vacancy_spot_data::set_has_u16OpeninghourInformation () {
    _has_bits_[0] |= 1u << 14;
}

inline void T_tcu_vacancy_spot_data::clear_has_u16OpeninghourInformation () {
    _has_bits_[0] &= ~ (1u << 14);
}

inline void T_tcu_vacancy_spot_data::set_has_u16Parkingnumber () {
    _has_bits_[0] |= 1u << 15;
}

inline void T_tcu_vacancy_spot_data::clear_has_u16Parkingnumber () {
    _has_bits_[0] &= ~ (1u << 15);
}

inline void T_tcu_vacancy_spot_data::set_has_u16Paymenttypeinformation () {
    _has_bits_[0] |= 1u << 16;
}

inline void T_tcu_vacancy_spot_data::clear_has_u16Paymenttypeinformation () {
    _has_bits_[0] &= ~ (1u << 16);
}

inline void T_tcu_vacancy_spot_data::set_has_u16Sizeofdetailinformation () {
    _has_bits_[0] |= 1u << 17;
}

inline void T_tcu_vacancy_spot_data::clear_has_u16Sizeofdetailinformation () {
    _has_bits_[0] &= ~ (1u << 17);
}

inline void T_tcu_vacancy_spot_data::set_has_u16Subcategorycode () {
    _has_bits_[0] |= 1u << 18;
}

inline void T_tcu_vacancy_spot_data::clear_has_u16Subcategorycode () {
    _has_bits_[0] &= ~ (1u << 18);
}

inline void T_tcu_vacancy_spot_data::set_has_u32POIID () {
    _has_bits_[0] |= 1u << 19;
}

inline void T_tcu_vacancy_spot_data::clear_has_u32POIID () {
    _has_bits_[0] &= ~ (1u << 19);
}

inline void T_tcu_vacancy_spot_data::set_has_u32UserrestrictionID () {
    _has_bits_[0] |= 1u << 20;
}

inline void T_tcu_vacancy_spot_data::clear_has_u32UserrestrictionID () {
    _has_bits_[0] &= ~ (1u << 20);
}

inline void T_tcu_vacancy_spot_data::set_has_u8_24hoursadayinformation () {
    _has_bits_[0] |= 1u << 21;
}

inline void T_tcu_vacancy_spot_data::clear_has_u8_24hoursadayinformation () {
    _has_bits_[0] &= ~ (1u << 21);
}

inline void T_tcu_vacancy_spot_data::set_has_u8Businessdayoftheweekinformation () {
    _has_bits_[0] |= 1u << 22;
}

inline void T_tcu_vacancy_spot_data::clear_has_u8Businessdayoftheweekinformation () {
    _has_bits_[0] &= ~ (1u << 22);
}

inline void T_tcu_vacancy_spot_data::set_has_u8Chargingfeeinformation () {
    _has_bits_[0] |= 1u << 23;
}

inline void T_tcu_vacancy_spot_data::clear_has_u8Chargingfeeinformation () {
    _has_bits_[0] &= ~ (1u << 23);
}

inline void T_tcu_vacancy_spot_data::set_has_u8Chargingtype () {
    _has_bits_[0] |= 1u << 24;
}

inline void T_tcu_vacancy_spot_data::clear_has_u8Chargingtype () {
    _has_bits_[0] &= ~ (1u << 24);
}

inline void T_tcu_vacancy_spot_data::set_has_u8Detailsinformation () {
    _has_bits_[0] |= 1u << 25;
}

inline void T_tcu_vacancy_spot_data::clear_has_u8Detailsinformation () {
    _has_bits_[0] &= ~ (1u << 25);
}

inline void T_tcu_vacancy_spot_data::set_has_u8Entranceinformation () {
    _has_bits_[0] |= 1u << 26;
}

inline void T_tcu_vacancy_spot_data::clear_has_u8Entranceinformation () {
    _has_bits_[0] &= ~ (1u << 26);
}

inline void T_tcu_vacancy_spot_data::set_has_u8Expresswaygeneraltype () {
    _has_bits_[0] |= 1u << 27;
}

inline void T_tcu_vacancy_spot_data::clear_has_u8Expresswaygeneraltype () {
    _has_bits_[0] &= ~ (1u << 27);
}

inline void T_tcu_vacancy_spot_data::set_has_u8Fixedvalue1 () {
    _has_bits_[0] |= 1u << 28;
}

inline void T_tcu_vacancy_spot_data::clear_has_u8Fixedvalue1 () {
    _has_bits_[0] &= ~ (1u << 28);
}

inline void T_tcu_vacancy_spot_data::set_has_u8Fixedvalue2 () {
    _has_bits_[0] |= 1u << 29;
}

inline void T_tcu_vacancy_spot_data::clear_has_u8Fixedvalue2 () {
    _has_bits_[0] &= ~ (1u << 29);
}

inline void T_tcu_vacancy_spot_data::set_has_u8Informationreliability () {
    _has_bits_[0] |= 1u << 30;
}

inline void T_tcu_vacancy_spot_data::clear_has_u8Informationreliability () {
    _has_bits_[0] &= ~ (1u << 30);
}

inline void T_tcu_vacancy_spot_data::set_has_u8Installationfacilityinformation () {
    _has_bits_[0] |= 1u << 31;
}

inline void T_tcu_vacancy_spot_data::clear_has_u8Installationfacilityinformation () {
    _has_bits_[0] &= ~ (1u << 31);
}

inline void T_tcu_vacancy_spot_data::set_has_u8Nearthefacilityinformation () {
    _has_bits_[1] |= 1u << 0;
}

inline void T_tcu_vacancy_spot_data::clear_has_u8Nearthefacilityinformation () {
    _has_bits_[1] &= ~ (1u << 0);
}

inline void T_tcu_vacancy_spot_data::set_has_u8Officehoursunknowninformation () {
    _has_bits_[1] |= 1u << 1;
}

inline void T_tcu_vacancy_spot_data::clear_has_u8Officehoursunknowninformation () {
    _has_bits_[1] &= ~ (1u << 1);
}

inline void T_tcu_vacancy_spot_data::set_has_u8Partnersfacilityinformation () {
    _has_bits_[1] |= 1u << 2;
}

inline void T_tcu_vacancy_spot_data::clear_has_u8Partnersfacilityinformation () {
    _has_bits_[1] &= ~ (1u << 2);
}

inline void T_tcu_vacancy_spot_data::set_has_u8SizeOfPOIName () {
    _has_bits_[1] |= 1u << 3;
}

inline void T_tcu_vacancy_spot_data::clear_has_u8SizeOfPOIName () {
    _has_bits_[1] &= ~ (1u << 3);
}

inline void T_tcu_vacancy_spot_data::set_has_u8SizeOfStreetAndHouseNo () {
    _has_bits_[1] |= 1u << 4;
}

inline void T_tcu_vacancy_spot_data::clear_has_u8SizeOfStreetAndHouseNo () {
    _has_bits_[1] &= ~ (1u << 4);
}

inline void T_tcu_vacancy_spot_data::set_has_u8SizeOfTelephonenumber () {
    _has_bits_[1] |= 1u << 5;
}

inline void T_tcu_vacancy_spot_data::clear_has_u8SizeOfTelephonenumber () {
    _has_bits_[1] &= ~ (1u << 5);
}

inline void T_tcu_vacancy_spot_data::set_has_u8Thenumberofentranceinformation () {
    _has_bits_[1] |= 1u << 6;
}

inline void T_tcu_vacancy_spot_data::clear_has_u8Thenumberofentranceinformation () {
    _has_bits_[1] &= ~ (1u << 6);
}

inline void T_tcu_vacancy_spot_data::set_has_u8Thenumberofinstallationfacilityinformation () {
    _has_bits_[1] |= 1u << 7;
}

inline void T_tcu_vacancy_spot_data::clear_has_u8Thenumberofinstallationfacilityinformation () {
    _has_bits_[1] &= ~ (1u << 7);
}

inline void T_tcu_vacancy_spot_data::set_has_u8Thenumberofpartnersfacilityinformation () {
    _has_bits_[1] |= 1u << 8;
}

inline void T_tcu_vacancy_spot_data::clear_has_u8Thenumberofpartnersfacilityinformation () {
    _has_bits_[1] &= ~ (1u << 8);
}

inline void T_tcu_vacancy_spot_data::set_has_u8Thetotalnumberofchargingtype () {
    _has_bits_[1] |= 1u << 9;
}

inline void T_tcu_vacancy_spot_data::clear_has_u8Thetotalnumberofchargingtype () {
    _has_bits_[1] &= ~ (1u << 9);
}

inline void T_tcu_vacancy_spot_data::set_has_u8Userrestriction () {
    _has_bits_[1] |= 1u << 10;
}

inline void T_tcu_vacancy_spot_data::clear_has_u8Userrestriction () {
    _has_bits_[1] &= ~ (1u << 10);
}

inline  T_tcu_response_vacancy_spot_data_result::T_tcu_response_vacancy_spot_data_result ()  :
    _VacancySpotData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_tcu_response_vacancy_spot_data_result::T_tcu_response_vacancy_spot_data_result (const T_tcu_response_vacancy_spot_data_result &rhs)  :
    _VacancySpotData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_tcu_response_vacancy_spot_data_result::T_tcu_response_vacancy_spot_data_result (const T_tcu_vacancy_spot_data& VacancySpotData_)  :
    _VacancySpotData (VacancySpotData_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_tcu_response_vacancy_spot_data_result::~T_tcu_response_vacancy_spot_data_result() {
}

inline T_tcu_response_vacancy_spot_data_result& T_tcu_response_vacancy_spot_data_result::operator = (const T_tcu_response_vacancy_spot_data_result& rhs) {
    if( this != &rhs ) {
        if (rhs.hasVacancySpotData()) {
            setVacancySpotData(rhs.getVacancySpotData());
        } else {
            clearVacancySpotData();
        }
    }
    return *this;
}

inline bool T_tcu_response_vacancy_spot_data_result::operator == (const T_tcu_response_vacancy_spot_data_result& rhs) const {
    return (((!hasVacancySpotData() && !rhs.hasVacancySpotData()) || getVacancySpotData() == rhs.getVacancySpotData()));
}

inline bool T_tcu_response_vacancy_spot_data_result::operator != (const T_tcu_response_vacancy_spot_data_result& rhs) const {
    return ! (*this == rhs);
}

inline bool T_tcu_response_vacancy_spot_data_result::operator < (const T_tcu_response_vacancy_spot_data_result& rhs) const {
    if (hasVacancySpotData() || rhs.hasVacancySpotData()) {
        if (getVacancySpotData() < rhs.getVacancySpotData()) return true;
        if (getVacancySpotData() > rhs.getVacancySpotData()) return false;
    }
    return false;
}

inline bool T_tcu_response_vacancy_spot_data_result::operator > (const T_tcu_response_vacancy_spot_data_result& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_tcu_response_vacancy_spot_data_result::clear() {
    clearVacancySpotData();
}

inline void T_tcu_response_vacancy_spot_data_result::clearVacancySpotData() {
    if (hasVacancySpotData()) {
         clear_has_VacancySpotData();
        _VacancySpotData.clear();
     }
}

inline bool T_tcu_response_vacancy_spot_data_result::hasVacancySpotData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const T_tcu_vacancy_spot_data& T_tcu_response_vacancy_spot_data_result::getVacancySpotData () const {
    return _VacancySpotData;
}

inline T_tcu_vacancy_spot_data& T_tcu_response_vacancy_spot_data_result::getVacancySpotDataMutable () {
    set_has_VacancySpotData();
    return _VacancySpotData;
}

inline void T_tcu_response_vacancy_spot_data_result::setVacancySpotData (const T_tcu_vacancy_spot_data& VacancySpotData_) {
    set_has_VacancySpotData();
    this->_VacancySpotData = VacancySpotData_;
}

inline void T_tcu_response_vacancy_spot_data_result::set_has_VacancySpotData () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_tcu_response_vacancy_spot_data_result::clear_has_VacancySpotData () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  T_usb_tcu_Server_Info::T_usb_tcu_Server_Info ()  :
    _strServerAddress (),
    _strServerName (),
    _u8ServerId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_usb_tcu_Server_Info::T_usb_tcu_Server_Info (const T_usb_tcu_Server_Info &rhs)  :
    _strServerAddress (),
    _strServerName (),
    _u8ServerId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_usb_tcu_Server_Info::T_usb_tcu_Server_Info (const ::std::string& strServerAddress_, const ::std::string& strServerName_, uint8 u8ServerId_)  :
    _strServerAddress (strServerAddress_),
    _strServerName (strServerName_),
    _u8ServerId (u8ServerId_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strServerAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strServerName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_usb_tcu_Server_Info::~T_usb_tcu_Server_Info() {
}

inline T_usb_tcu_Server_Info& T_usb_tcu_Server_Info::operator = (const T_usb_tcu_Server_Info& rhs) {
    if( this != &rhs ) {
        if (rhs.hasStrServerAddress()) {
            setStrServerAddress(rhs.getStrServerAddress());
        } else {
            clearStrServerAddress();
        }
        if (rhs.hasStrServerName()) {
            setStrServerName(rhs.getStrServerName());
        } else {
            clearStrServerName();
        }
        if (rhs.hasU8ServerId()) {
            setU8ServerId(rhs.getU8ServerId());
        } else {
            clearU8ServerId();
        }
    }
    return *this;
}

inline bool T_usb_tcu_Server_Info::operator == (const T_usb_tcu_Server_Info& rhs) const {
    return (((!hasStrServerAddress() && !rhs.hasStrServerAddress()) || getStrServerAddress() == rhs.getStrServerAddress()) &&
        ((!hasStrServerName() && !rhs.hasStrServerName()) || getStrServerName() == rhs.getStrServerName()) &&
        ((!hasU8ServerId() && !rhs.hasU8ServerId()) || getU8ServerId() == rhs.getU8ServerId()));
}

inline bool T_usb_tcu_Server_Info::operator != (const T_usb_tcu_Server_Info& rhs) const {
    return ! (*this == rhs);
}

inline bool T_usb_tcu_Server_Info::operator < (const T_usb_tcu_Server_Info& rhs) const {
    if (hasStrServerAddress() || rhs.hasStrServerAddress()) {
        if (getStrServerAddress() < rhs.getStrServerAddress()) return true;
        if (getStrServerAddress() > rhs.getStrServerAddress()) return false;
    }
    if (hasStrServerName() || rhs.hasStrServerName()) {
        if (getStrServerName() < rhs.getStrServerName()) return true;
        if (getStrServerName() > rhs.getStrServerName()) return false;
    }
    if (hasU8ServerId() || rhs.hasU8ServerId()) {
        if (getU8ServerId() < rhs.getU8ServerId()) return true;
        if (getU8ServerId() > rhs.getU8ServerId()) return false;
    }
    return false;
}

inline bool T_usb_tcu_Server_Info::operator > (const T_usb_tcu_Server_Info& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_usb_tcu_Server_Info::clear() {
    clearStrServerAddress();
    clearStrServerName();
    clearU8ServerId();
}

inline void T_usb_tcu_Server_Info::clearStrServerAddress() {
    if (hasStrServerAddress()) {
         clear_has_strServerAddress();
        _strServerAddress.clear();
     }
}

inline bool T_usb_tcu_Server_Info::hasStrServerAddress () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_usb_tcu_Server_Info::getStrServerAddress () const {
    return _strServerAddress;
}

inline ::std::string& T_usb_tcu_Server_Info::getStrServerAddressMutable () {
    set_has_strServerAddress();
    return _strServerAddress;
}

inline void T_usb_tcu_Server_Info::setStrServerAddress (const ::std::string& strServerAddress_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strServerAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strServerAddress();
    this->_strServerAddress = strServerAddress_;
}

inline void T_usb_tcu_Server_Info::setStrServerAddress (const char* strServerAddress_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strServerAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strServerAddress();
    this->_strServerAddress.assign(strServerAddress_);
}

inline void T_usb_tcu_Server_Info::setStrServerAddress (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strServerAddress();
    this->_strServerAddress.assign(value, size);
}

inline void T_usb_tcu_Server_Info::clearStrServerName() {
    if (hasStrServerName()) {
         clear_has_strServerName();
        _strServerName.clear();
     }
}

inline bool T_usb_tcu_Server_Info::hasStrServerName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_usb_tcu_Server_Info::getStrServerName () const {
    return _strServerName;
}

inline ::std::string& T_usb_tcu_Server_Info::getStrServerNameMutable () {
    set_has_strServerName();
    return _strServerName;
}

inline void T_usb_tcu_Server_Info::setStrServerName (const ::std::string& strServerName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strServerName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strServerName();
    this->_strServerName = strServerName_;
}

inline void T_usb_tcu_Server_Info::setStrServerName (const char* strServerName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strServerName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strServerName();
    this->_strServerName.assign(strServerName_);
}

inline void T_usb_tcu_Server_Info::setStrServerName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strServerName();
    this->_strServerName.assign(value, size);
}

inline void T_usb_tcu_Server_Info::clearU8ServerId() {
    if (hasU8ServerId()) {
         clear_has_u8ServerId();
        _u8ServerId = 0u;
     }
}

inline bool T_usb_tcu_Server_Info::hasU8ServerId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 T_usb_tcu_Server_Info::getU8ServerId () const {
    return _u8ServerId;
}

inline void T_usb_tcu_Server_Info::setU8ServerId (uint8 u8ServerId_) {
    set_has_u8ServerId();
    this->_u8ServerId = u8ServerId_;
}

inline void T_usb_tcu_Server_Info::set_has_strServerAddress () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_usb_tcu_Server_Info::clear_has_strServerAddress () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_usb_tcu_Server_Info::set_has_strServerName () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_usb_tcu_Server_Info::clear_has_strServerName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_usb_tcu_Server_Info::set_has_u8ServerId () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_usb_tcu_Server_Info::clear_has_u8ServerId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_usb_tcu_TCUDevice_Info::T_usb_tcu_TCUDevice_Info ()  :
    _eModemType (::tcu_usb_main_fi_types::T_e8_ModemType__2_9G),
    _bUSBConnectionStatus (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_usb_tcu_TCUDevice_Info::T_usb_tcu_TCUDevice_Info (const T_usb_tcu_TCUDevice_Info &rhs)  :
    _eModemType (::tcu_usb_main_fi_types::T_e8_ModemType__2_9G),
    _bUSBConnectionStatus (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_usb_tcu_TCUDevice_Info::T_usb_tcu_TCUDevice_Info (T_e8_ModemType eModemType_, bool bUSBConnectionStatus_)  :
    _eModemType (eModemType_),
    _bUSBConnectionStatus (bUSBConnectionStatus_)
{
    #ifndef NDEBUG
    if (!(T_e8_ModemType_IsValid(eModemType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eModemType_, "T_e8_ModemType", "eModemType", "T_usb_tcu_TCUDevice_Info");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_usb_tcu_TCUDevice_Info::~T_usb_tcu_TCUDevice_Info() {
}

inline T_usb_tcu_TCUDevice_Info& T_usb_tcu_TCUDevice_Info::operator = (const T_usb_tcu_TCUDevice_Info& rhs) {
    if( this != &rhs ) {
        if (rhs.hasEModemType()) {
            setEModemType(rhs.getEModemType());
        } else {
            clearEModemType();
        }
        if (rhs.hasBUSBConnectionStatus()) {
            setBUSBConnectionStatus(rhs.getBUSBConnectionStatus());
        } else {
            clearBUSBConnectionStatus();
        }
    }
    return *this;
}

inline bool T_usb_tcu_TCUDevice_Info::operator == (const T_usb_tcu_TCUDevice_Info& rhs) const {
    return (((!hasEModemType() && !rhs.hasEModemType()) || getEModemType() == rhs.getEModemType()) &&
        ((!hasBUSBConnectionStatus() && !rhs.hasBUSBConnectionStatus()) || getBUSBConnectionStatus() == rhs.getBUSBConnectionStatus()));
}

inline bool T_usb_tcu_TCUDevice_Info::operator != (const T_usb_tcu_TCUDevice_Info& rhs) const {
    return ! (*this == rhs);
}

inline bool T_usb_tcu_TCUDevice_Info::operator < (const T_usb_tcu_TCUDevice_Info& rhs) const {
    if (hasEModemType() || rhs.hasEModemType()) {
        if ((uint32)getEModemType() < (uint32)rhs.getEModemType()) return true;
        if ((uint32)getEModemType() > (uint32)rhs.getEModemType()) return false;
    }
    if (hasBUSBConnectionStatus() || rhs.hasBUSBConnectionStatus()) {
        if (getBUSBConnectionStatus() < rhs.getBUSBConnectionStatus()) return true;
        if (getBUSBConnectionStatus() > rhs.getBUSBConnectionStatus()) return false;
    }
    return false;
}

inline bool T_usb_tcu_TCUDevice_Info::operator > (const T_usb_tcu_TCUDevice_Info& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_usb_tcu_TCUDevice_Info::clear() {
    clearEModemType();
    clearBUSBConnectionStatus();
}

inline void T_usb_tcu_TCUDevice_Info::clearEModemType() {
    if (hasEModemType()) {
         clear_has_eModemType();
        _eModemType = ::tcu_usb_main_fi_types::T_e8_ModemType__2_9G;
     }
}

inline bool T_usb_tcu_TCUDevice_Info::hasEModemType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_ModemType T_usb_tcu_TCUDevice_Info::getEModemType () const {
    return _eModemType;
}

inline void T_usb_tcu_TCUDevice_Info::setEModemType (T_e8_ModemType eModemType_) {
    #ifndef NDEBUG
    if (!(T_e8_ModemType_IsValid(eModemType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eModemType_, "T_e8_ModemType", "eModemType", "T_usb_tcu_TCUDevice_Info");
    }
    #endif
    set_has_eModemType();
    this->_eModemType = eModemType_;
}

inline void T_usb_tcu_TCUDevice_Info::clearBUSBConnectionStatus() {
    if (hasBUSBConnectionStatus()) {
         clear_has_bUSBConnectionStatus();
        _bUSBConnectionStatus = false;
     }
}

inline bool T_usb_tcu_TCUDevice_Info::hasBUSBConnectionStatus () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool T_usb_tcu_TCUDevice_Info::getBUSBConnectionStatus () const {
    return _bUSBConnectionStatus;
}

inline void T_usb_tcu_TCUDevice_Info::setBUSBConnectionStatus (bool bUSBConnectionStatus_) {
    set_has_bUSBConnectionStatus();
    this->_bUSBConnectionStatus = bUSBConnectionStatus_;
}

inline void T_usb_tcu_TCUDevice_Info::set_has_eModemType () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_usb_tcu_TCUDevice_Info::clear_has_eModemType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_usb_tcu_TCUDevice_Info::set_has_bUSBConnectionStatus () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_usb_tcu_TCUDevice_Info::clear_has_bUSBConnectionStatus () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_usb_tcu_UserAuthentication_DecodedToken_Info::T_usb_tcu_UserAuthentication_DecodedToken_Info ()  :
    _KID ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_usb_tcu_UserAuthentication_DecodedToken_Info::T_usb_tcu_UserAuthentication_DecodedToken_Info (const T_usb_tcu_UserAuthentication_DecodedToken_Info &rhs)  :
    _KID ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_usb_tcu_UserAuthentication_DecodedToken_Info::T_usb_tcu_UserAuthentication_DecodedToken_Info (const ::std::string& KID_)  :
    _KID (KID_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (KID_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_usb_tcu_UserAuthentication_DecodedToken_Info::~T_usb_tcu_UserAuthentication_DecodedToken_Info() {
}

inline T_usb_tcu_UserAuthentication_DecodedToken_Info& T_usb_tcu_UserAuthentication_DecodedToken_Info::operator = (const T_usb_tcu_UserAuthentication_DecodedToken_Info& rhs) {
    if( this != &rhs ) {
        if (rhs.hasKID()) {
            setKID(rhs.getKID());
        } else {
            clearKID();
        }
    }
    return *this;
}

inline bool T_usb_tcu_UserAuthentication_DecodedToken_Info::operator == (const T_usb_tcu_UserAuthentication_DecodedToken_Info& rhs) const {
    return (((!hasKID() && !rhs.hasKID()) || getKID() == rhs.getKID()));
}

inline bool T_usb_tcu_UserAuthentication_DecodedToken_Info::operator != (const T_usb_tcu_UserAuthentication_DecodedToken_Info& rhs) const {
    return ! (*this == rhs);
}

inline bool T_usb_tcu_UserAuthentication_DecodedToken_Info::operator < (const T_usb_tcu_UserAuthentication_DecodedToken_Info& rhs) const {
    if (hasKID() || rhs.hasKID()) {
        if (getKID() < rhs.getKID()) return true;
        if (getKID() > rhs.getKID()) return false;
    }
    return false;
}

inline bool T_usb_tcu_UserAuthentication_DecodedToken_Info::operator > (const T_usb_tcu_UserAuthentication_DecodedToken_Info& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_usb_tcu_UserAuthentication_DecodedToken_Info::clear() {
    clearKID();
}

inline void T_usb_tcu_UserAuthentication_DecodedToken_Info::clearKID() {
    if (hasKID()) {
         clear_has_KID();
        _KID.clear();
     }
}

inline bool T_usb_tcu_UserAuthentication_DecodedToken_Info::hasKID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_usb_tcu_UserAuthentication_DecodedToken_Info::getKID () const {
    return _KID;
}

inline ::std::string& T_usb_tcu_UserAuthentication_DecodedToken_Info::getKIDMutable () {
    set_has_KID();
    return _KID;
}

inline void T_usb_tcu_UserAuthentication_DecodedToken_Info::setKID (const ::std::string& KID_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (KID_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_KID();
    this->_KID = KID_;
}

inline void T_usb_tcu_UserAuthentication_DecodedToken_Info::setKID (const char* KID_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (KID_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_KID();
    this->_KID.assign(KID_);
}

inline void T_usb_tcu_UserAuthentication_DecodedToken_Info::setKID (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_KID();
    this->_KID.assign(value, size);
}

inline void T_usb_tcu_UserAuthentication_DecodedToken_Info::set_has_KID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_usb_tcu_UserAuthentication_DecodedToken_Info::clear_has_KID () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace tcu_usb_main_fi_types

#endif // TCU_USB_MAIN_FI_TYPES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
