/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef TCU_USB_MAIN_FIPROXY_H
#define TCU_USB_MAIN_FIPROXY_H

#include "asf/cca/CcaProxy.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "tcu_usb_main_fi.h"
#include "tcu_usb_main_fi_types.h"
#include "tcu_usb_main_fi_typesConst.h"
#include <string>

namespace tcu_usb_main_fi {

class Tcu_usb_main_fiProxy;

class AbortPromptCallbackIF {
public:
    virtual ~AbortPromptCallbackIF() {}

    virtual void onAbortPromptError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< AbortPromptError >& error) = 0;

    virtual void onAbortPromptResult(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< AbortPromptResult >& result) = 0;
};

class AuthenticationResultDataCallbackIF {
public:
    virtual ~AuthenticationResultDataCallbackIF() {}

    virtual void onAuthenticationResultDataError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< AuthenticationResultDataError >& error) = 0;

    virtual void onAuthenticationResultDataStatus(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< AuthenticationResultDataStatus >& status) = 0;
};

class CancelRequestCallbackIF {
public:
    virtual ~CancelRequestCallbackIF() {}

    virtual void onCancelRequestError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< CancelRequestError >& error) = 0;

    virtual void onCancelRequestResult(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< CancelRequestResult >& result) = 0;
};

class CancelUserValidationRenewTokenCallbackIF {
public:
    virtual ~CancelUserValidationRenewTokenCallbackIF() {}

    virtual void onCancelUserValidationRenewTokenError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< CancelUserValidationRenewTokenError >& error) = 0;

    virtual void onCancelUserValidationRenewTokenResult(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< CancelUserValidationRenewTokenResult >& result) = 0;
};

class ChannelMasterDataCallbackIF {
public:
    virtual ~ChannelMasterDataCallbackIF() {}

    virtual void onChannelMasterDataError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< ChannelMasterDataError >& error) = 0;

    virtual void onChannelMasterDataStatus(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< ChannelMasterDataStatus >& status) = 0;
};

class ChargingSpotDataCallbackIF {
public:
    virtual ~ChargingSpotDataCallbackIF() {}

    virtual void onChargingSpotDataError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< ChargingSpotDataError >& error) = 0;

    virtual void onChargingSpotDataStatus(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< ChargingSpotDataStatus >& status) = 0;
};

class ChargingStationsListCallbackIF {
public:
    virtual ~ChargingStationsListCallbackIF() {}

    virtual void onChargingStationsListError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< ChargingStationsListError >& error) = 0;

    virtual void onChargingStationsListStatus(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< ChargingStationsListStatus >& status) = 0;
};

class ConnectedSearchResultCallbackIF {
public:
    virtual ~ConnectedSearchResultCallbackIF() {}

    virtual void onConnectedSearchResultError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< ConnectedSearchResultError >& error) = 0;

    virtual void onConnectedSearchResultStatus(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< ConnectedSearchResultStatus >& status) = 0;
};

class ContinuePromptCallbackIF {
public:
    virtual ~ContinuePromptCallbackIF() {}

    virtual void onContinuePromptError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< ContinuePromptError >& error) = 0;

    virtual void onContinuePromptResult(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< ContinuePromptResult >& result) = 0;
};

class DataConnectionErrorCallbackIF {
public:
    virtual ~DataConnectionErrorCallbackIF() {}

    virtual void onDataConnectionErrorError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< DataConnectionErrorError >& error) = 0;

    virtual void onDataConnectionErrorStatus(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< DataConnectionErrorStatus >& status) = 0;
};

class DataConnectionStatusCallbackIF {
public:
    virtual ~DataConnectionStatusCallbackIF() {}

    virtual void onDataConnectionStatusError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< DataConnectionStatusError >& error) = 0;

    virtual void onDataConnectionStatusStatus(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< DataConnectionStatusStatus >& status) = 0;
};

class DatabaseStatusCallbackIF {
public:
    virtual ~DatabaseStatusCallbackIF() {}

    virtual void onDatabaseStatusError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< DatabaseStatusError >& error) = 0;

    virtual void onDatabaseStatusStatus(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< DatabaseStatusStatus >& status) = 0;
};

class DecodeIdTokenCallbackIF {
public:
    virtual ~DecodeIdTokenCallbackIF() {}

    virtual void onDecodeIdTokenError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< DecodeIdTokenError >& error) = 0;

    virtual void onDecodeIdTokenResult(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< DecodeIdTokenResult >& result) = 0;
};

class DeleteChannelInformationCallbackIF {
public:
    virtual ~DeleteChannelInformationCallbackIF() {}

    virtual void onDeleteChannelInformationError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< DeleteChannelInformationError >& error) = 0;

    virtual void onDeleteChannelInformationResult(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< DeleteChannelInformationResult >& result) = 0;
};

class DeleteInVehicleMessageCallbackIF {
public:
    virtual ~DeleteInVehicleMessageCallbackIF() {}

    virtual void onDeleteInVehicleMessageError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< DeleteInVehicleMessageError >& error) = 0;

    virtual void onDeleteInVehicleMessageResult(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< DeleteInVehicleMessageResult >& result) = 0;
};

class DeleteInfoHistoryCallbackIF {
public:
    virtual ~DeleteInfoHistoryCallbackIF() {}

    virtual void onDeleteInfoHistoryError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< DeleteInfoHistoryError >& error) = 0;

    virtual void onDeleteInfoHistoryResult(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< DeleteInfoHistoryResult >& result) = 0;
};

class DeleteMessageBoxCallbackIF {
public:
    virtual ~DeleteMessageBoxCallbackIF() {}

    virtual void onDeleteMessageBoxError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< DeleteMessageBoxError >& error) = 0;

    virtual void onDeleteMessageBoxResult(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< DeleteMessageBoxResult >& result) = 0;
};

class DownloadPartAuthDataCallbackIF {
public:
    virtual ~DownloadPartAuthDataCallbackIF() {}

    virtual void onDownloadPartAuthDataError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< DownloadPartAuthDataError >& error) = 0;

    virtual void onDownloadPartAuthDataResult(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< DownloadPartAuthDataResult >& result) = 0;
};

class GeneralNotificationMessageCallbackIF {
public:
    virtual ~GeneralNotificationMessageCallbackIF() {}

    virtual void onGeneralNotificationMessageError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< GeneralNotificationMessageError >& error) = 0;

    virtual void onGeneralNotificationMessageStatus(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< GeneralNotificationMessageStatus >& status) = 0;
};

class GeneralResponseErrorCallbackIF {
public:
    virtual ~GeneralResponseErrorCallbackIF() {}

    virtual void onGeneralResponseErrorError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< GeneralResponseErrorError >& error) = 0;

    virtual void onGeneralResponseErrorStatus(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< GeneralResponseErrorStatus >& status) = 0;
};

class GetAccessTokenCallbackIF {
public:
    virtual ~GetAccessTokenCallbackIF() {}

    virtual void onGetAccessTokenError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< GetAccessTokenError >& error) = 0;

    virtual void onGetAccessTokenResult(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< GetAccessTokenResult >& result) = 0;
};

class GetAutoDownloadIntervalCallbackIF {
public:
    virtual ~GetAutoDownloadIntervalCallbackIF() {}

    virtual void onGetAutoDownloadIntervalError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< GetAutoDownloadIntervalError >& error) = 0;

    virtual void onGetAutoDownloadIntervalResult(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< GetAutoDownloadIntervalResult >& result) = 0;
};

class GetChannelDataCallbackIF {
public:
    virtual ~GetChannelDataCallbackIF() {}

    virtual void onGetChannelDataError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< GetChannelDataError >& error) = 0;

    virtual void onGetChannelDataResult(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< GetChannelDataResult >& result) = 0;
};

class GetChannelMasterDataCallbackIF {
public:
    virtual ~GetChannelMasterDataCallbackIF() {}

    virtual void onGetChannelMasterDataError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< GetChannelMasterDataError >& error) = 0;

    virtual void onGetChannelMasterDataResult(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< GetChannelMasterDataResult >& result) = 0;
};

class GetChargingSpotDataCallbackIF {
public:
    virtual ~GetChargingSpotDataCallbackIF() {}

    virtual void onGetChargingSpotDataError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< GetChargingSpotDataError >& error) = 0;

    virtual void onGetChargingSpotDataResult(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< GetChargingSpotDataResult >& result) = 0;
};

class GetChargingStationsListCallbackIF {
public:
    virtual ~GetChargingStationsListCallbackIF() {}

    virtual void onGetChargingStationsListError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< GetChargingStationsListError >& error) = 0;

    virtual void onGetChargingStationsListResult(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< GetChargingStationsListResult >& result) = 0;
};

class GetConnectedSearchResultCallbackIF {
public:
    virtual ~GetConnectedSearchResultCallbackIF() {}

    virtual void onGetConnectedSearchResultError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< GetConnectedSearchResultError >& error) = 0;

    virtual void onGetConnectedSearchResultResult(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< GetConnectedSearchResultResult >& result) = 0;
};

class GetFavoriteChannelListCallbackIF {
public:
    virtual ~GetFavoriteChannelListCallbackIF() {}

    virtual void onGetFavoriteChannelListError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< GetFavoriteChannelListError >& error) = 0;

    virtual void onGetFavoriteChannelListResult(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< GetFavoriteChannelListResult >& result) = 0;
};

class GetProbeUploadPermitCallbackIF {
public:
    virtual ~GetProbeUploadPermitCallbackIF() {}

    virtual void onGetProbeUploadPermitError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< GetProbeUploadPermitError >& error) = 0;

    virtual void onGetProbeUploadPermitResult(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< GetProbeUploadPermitResult >& result) = 0;
};

class GetServerListCallbackIF {
public:
    virtual ~GetServerListCallbackIF() {}

    virtual void onGetServerListError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< GetServerListError >& error) = 0;

    virtual void onGetServerListResult(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< GetServerListResult >& result) = 0;
};

class GetTCUDeviceInfoCallbackIF {
public:
    virtual ~GetTCUDeviceInfoCallbackIF() {}

    virtual void onGetTCUDeviceInfoError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< GetTCUDeviceInfoError >& error) = 0;

    virtual void onGetTCUDeviceInfoResult(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< GetTCUDeviceInfoResult >& result) = 0;
};

class GetVICSTrafficDataCallbackIF {
public:
    virtual ~GetVICSTrafficDataCallbackIF() {}

    virtual void onGetVICSTrafficDataError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< GetVICSTrafficDataError >& error) = 0;

    virtual void onGetVICSTrafficDataResult(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< GetVICSTrafficDataResult >& result) = 0;
};

class GetVacancySpotDataCallbackIF {
public:
    virtual ~GetVacancySpotDataCallbackIF() {}

    virtual void onGetVacancySpotDataError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< GetVacancySpotDataError >& error) = 0;

    virtual void onGetVacancySpotDataResult(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< GetVacancySpotDataResult >& result) = 0;
};

class GetVacancyStationsListCallbackIF {
public:
    virtual ~GetVacancyStationsListCallbackIF() {}

    virtual void onGetVacancyStationsListError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< GetVacancyStationsListError >& error) = 0;

    virtual void onGetVacancyStationsListResult(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< GetVacancyStationsListResult >& result) = 0;
};

class InitializeFeedListCallbackIF {
public:
    virtual ~InitializeFeedListCallbackIF() {}

    virtual void onInitializeFeedListError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< InitializeFeedListError >& error) = 0;

    virtual void onInitializeFeedListResult(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< InitializeFeedListResult >& result) = 0;
};

class NotifyAutoDownloadIntervalCallbackIF {
public:
    virtual ~NotifyAutoDownloadIntervalCallbackIF() {}

    virtual void onNotifyAutoDownloadIntervalError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< NotifyAutoDownloadIntervalError >& error) = 0;

    virtual void onNotifyAutoDownloadIntervalStatus(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< NotifyAutoDownloadIntervalStatus >& status) = 0;
};

class NotifyTokenRenewalErrorCallbackIF {
public:
    virtual ~NotifyTokenRenewalErrorCallbackIF() {}

    virtual void onNotifyTokenRenewalErrorError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< NotifyTokenRenewalErrorError >& error) = 0;

    virtual void onNotifyTokenRenewalErrorStatus(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< NotifyTokenRenewalErrorStatus >& status) = 0;
};

class OverwriteIVMTotalContentsCallbackIF {
public:
    virtual ~OverwriteIVMTotalContentsCallbackIF() {}

    virtual void onOverwriteIVMTotalContentsError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< OverwriteIVMTotalContentsError >& error) = 0;

    virtual void onOverwriteIVMTotalContentsResult(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< OverwriteIVMTotalContentsResult >& result) = 0;
};

class PausePromptCallbackIF {
public:
    virtual ~PausePromptCallbackIF() {}

    virtual void onPausePromptError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< PausePromptError >& error) = 0;

    virtual void onPausePromptResult(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< PausePromptResult >& result) = 0;
};

class ReadFavoriteFeedsCallbackIF {
public:
    virtual ~ReadFavoriteFeedsCallbackIF() {}

    virtual void onReadFavoriteFeedsError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< ReadFavoriteFeedsError >& error) = 0;

    virtual void onReadFavoriteFeedsResult(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< ReadFavoriteFeedsResult >& result) = 0;
};

class RenewAccessTokenCallbackIF {
public:
    virtual ~RenewAccessTokenCallbackIF() {}

    virtual void onRenewAccessTokenError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< RenewAccessTokenError >& error) = 0;

    virtual void onRenewAccessTokenResult(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< RenewAccessTokenResult >& result) = 0;
};

class ResetDatabaseCallbackIF {
public:
    virtual ~ResetDatabaseCallbackIF() {}

    virtual void onResetDatabaseError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< ResetDatabaseError >& error) = 0;

    virtual void onResetDatabaseResult(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< ResetDatabaseResult >& result) = 0;
};

class ResetNCSSettingsCallbackIF {
public:
    virtual ~ResetNCSSettingsCallbackIF() {}

    virtual void onResetNCSSettingsError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< ResetNCSSettingsError >& error) = 0;

    virtual void onResetNCSSettingsResult(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< ResetNCSSettingsResult >& result) = 0;
};

class RestoreFactorySettingsCallbackIF {
public:
    virtual ~RestoreFactorySettingsCallbackIF() {}

    virtual void onRestoreFactorySettingsError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< RestoreFactorySettingsError >& error) = 0;

    virtual void onRestoreFactorySettingsResult(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< RestoreFactorySettingsResult >& result) = 0;
};

class RetryGetChannelDataCallbackIF {
public:
    virtual ~RetryGetChannelDataCallbackIF() {}

    virtual void onRetryGetChannelDataError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< RetryGetChannelDataError >& error) = 0;

    virtual void onRetryGetChannelDataResult(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< RetryGetChannelDataResult >& result) = 0;
};

class SelectFavoriteFeedsCallbackIF {
public:
    virtual ~SelectFavoriteFeedsCallbackIF() {}

    virtual void onSelectFavoriteFeedsError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< SelectFavoriteFeedsError >& error) = 0;

    virtual void onSelectFavoriteFeedsResult(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< SelectFavoriteFeedsResult >& result) = 0;
};

class SelectServerCallbackIF {
public:
    virtual ~SelectServerCallbackIF() {}

    virtual void onSelectServerError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< SelectServerError >& error) = 0;

    virtual void onSelectServerResult(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< SelectServerResult >& result) = 0;
};

class SendGroupADataCallbackIF {
public:
    virtual ~SendGroupADataCallbackIF() {}

    virtual void onSendGroupADataError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< SendGroupADataError >& error) = 0;

    virtual void onSendGroupADataResult(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< SendGroupADataResult >& result) = 0;
};

class SendUserCredentialsCallbackIF {
public:
    virtual ~SendUserCredentialsCallbackIF() {}

    virtual void onSendUserCredentialsError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< SendUserCredentialsError >& error) = 0;

    virtual void onSendUserCredentialsResult(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< SendUserCredentialsResult >& result) = 0;
};

class ServerListCallbackIF {
public:
    virtual ~ServerListCallbackIF() {}

    virtual void onServerListError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< ServerListError >& error) = 0;

    virtual void onServerListStatus(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< ServerListStatus >& status) = 0;
};

class SetAutoDownloadChannelCallbackIF {
public:
    virtual ~SetAutoDownloadChannelCallbackIF() {}

    virtual void onSetAutoDownloadChannelError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< SetAutoDownloadChannelError >& error) = 0;

    virtual void onSetAutoDownloadChannelResult(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< SetAutoDownloadChannelResult >& result) = 0;
};

class SetAutoDownloadIntervalCallbackIF {
public:
    virtual ~SetAutoDownloadIntervalCallbackIF() {}

    virtual void onSetAutoDownloadIntervalError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< SetAutoDownloadIntervalError >& error) = 0;

    virtual void onSetAutoDownloadIntervalResult(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< SetAutoDownloadIntervalResult >& result) = 0;
};

class SetFavoriteChannelCallbackIF {
public:
    virtual ~SetFavoriteChannelCallbackIF() {}

    virtual void onSetFavoriteChannelError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< SetFavoriteChannelError >& error) = 0;

    virtual void onSetFavoriteChannelResult(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< SetFavoriteChannelResult >& result) = 0;
};

class SetLogLevelCallbackIF {
public:
    virtual ~SetLogLevelCallbackIF() {}

    virtual void onSetLogLevelError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< SetLogLevelError >& error) = 0;

    virtual void onSetLogLevelResult(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< SetLogLevelResult >& result) = 0;
};

class SetProbeInfoDeleteCallbackIF {
public:
    virtual ~SetProbeInfoDeleteCallbackIF() {}

    virtual void onSetProbeInfoDeleteError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< SetProbeInfoDeleteError >& error) = 0;

    virtual void onSetProbeInfoDeleteResult(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< SetProbeInfoDeleteResult >& result) = 0;
};

class SetProbeUploadPermitCallbackIF {
public:
    virtual ~SetProbeUploadPermitCallbackIF() {}

    virtual void onSetProbeUploadPermitError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< SetProbeUploadPermitError >& error) = 0;

    virtual void onSetProbeUploadPermitResult(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< SetProbeUploadPermitResult >& result) = 0;
};

class StoreCSHistoryCallbackIF {
public:
    virtual ~StoreCSHistoryCallbackIF() {}

    virtual void onStoreCSHistoryError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< StoreCSHistoryError >& error) = 0;

    virtual void onStoreCSHistoryResult(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< StoreCSHistoryResult >& result) = 0;
};

class SynthesizeSpeakCallbackIF {
public:
    virtual ~SynthesizeSpeakCallbackIF() {}

    virtual void onSynthesizeSpeakError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< SynthesizeSpeakError >& error) = 0;

    virtual void onSynthesizeSpeakResultFirst(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< SynthesizeSpeakResultFirst >& result) = 0;

    virtual void onSynthesizeSpeakResultLast(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< SynthesizeSpeakResultLast >& result) = 0;

    virtual void onSynthesizeSpeakResultMiddle(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< SynthesizeSpeakResultMiddle >& result) = 0;
};

class TCUDeviceInfoCallbackIF {
public:
    virtual ~TCUDeviceInfoCallbackIF() {}

    virtual void onTCUDeviceInfoError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< TCUDeviceInfoError >& error) = 0;

    virtual void onTCUDeviceInfoStatus(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< TCUDeviceInfoStatus >& status) = 0;
};

class TtsAudioStateRequestCallbackIF {
public:
    virtual ~TtsAudioStateRequestCallbackIF() {}

    virtual void onTtsAudioStateRequestError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< TtsAudioStateRequestError >& error) = 0;

    virtual void onTtsAudioStateRequestStatus(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< TtsAudioStateRequestStatus >& status) = 0;
};

class UserCredentialStatusCallbackIF {
public:
    virtual ~UserCredentialStatusCallbackIF() {}

    virtual void onUserCredentialStatusError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< UserCredentialStatusError >& error) = 0;

    virtual void onUserCredentialStatusStatus(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< UserCredentialStatusStatus >& status) = 0;
};

class VICSTrafficDataCallbackIF {
public:
    virtual ~VICSTrafficDataCallbackIF() {}

    virtual void onVICSTrafficDataError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< VICSTrafficDataError >& error) = 0;

    virtual void onVICSTrafficDataStatus(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< VICSTrafficDataStatus >& status) = 0;
};

class VacancySpotDataCallbackIF {
public:
    virtual ~VacancySpotDataCallbackIF() {}

    virtual void onVacancySpotDataError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< VacancySpotDataError >& error) = 0;

    virtual void onVacancySpotDataStatus(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< VacancySpotDataStatus >& status) = 0;
};

class VacancyStationsListCallbackIF {
public:
    virtual ~VacancyStationsListCallbackIF() {}

    virtual void onVacancyStationsListError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< VacancyStationsListError >& error) = 0;

    virtual void onVacancyStationsListStatus(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< VacancyStationsListStatus >& status) = 0;
};

class ValidateUserCredentialsCallbackIF {
public:
    virtual ~ValidateUserCredentialsCallbackIF() {}

    virtual void onValidateUserCredentialsError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< ValidateUserCredentialsError >& error) = 0;

    virtual void onValidateUserCredentialsResult(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< ValidateUserCredentialsResult >& result) = 0;
};

class ValidateUserCredentialsOnTokenRenewalErrorCallbackIF {
public:
    virtual ~ValidateUserCredentialsOnTokenRenewalErrorCallbackIF() {}

    virtual void onValidateUserCredentialsOnTokenRenewalErrorError(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< ValidateUserCredentialsOnTokenRenewalErrorError >& error) = 0;

    virtual void onValidateUserCredentialsOnTokenRenewalErrorResult(const ::boost::shared_ptr< Tcu_usb_main_fiProxy >& proxy, const ::boost::shared_ptr< ValidateUserCredentialsOnTokenRenewalErrorResult >& result) = 0;
};

class Tcu_usb_main_fiProxyCallback;

/**
 * Tcu_usb_main_fiProxy is the client side representation of the CCA
 * Functional Interface 'tcu_usb_main_fi' (specified in file
 * tcu_usb_main_fi.xml).
 *
 * CCA Functional Interface 'tcu_usb_main_fi'
 *
 * Fullname: Middleware FC USB TCU Server Functional Interface
 *
 * Version: $Revision:0.1	$
 *
 * Author: Praveen Badsheshi
 *
 * Date: $Date:	Oct 24 2013 10:00:00	$
 *
 * Department:
 *
 * Title: tcu_usb_main_fi
 *
 * <b>Description of 'tcu_usb_main_fi':</b>
 *
 * This is the interface document for FC USB TCU service.
 */
class Tcu_usb_main_fiProxy : public ::asf::cca::CcaProxy
{
public:

    /**
     * Create a new instance of Tcu_usb_main_fiProxy. The caller has to pass
     * the port name and the service information. It is only possible to use
     * this function if the port is defined in the CMC model as "wired at
     * runtime"-port. The application id of the CCA Server will be determined
     * with help of the CCA SrvSupplier messages. It's guranteed that the
     * corresponding CCA server will have the specified major version and at
     * least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Tcu_usb_main_fiProxy > createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Tcu_usb_main_fiProxy. The caller has to pass
     * the port name and the service information. It is only possible to use
     * this function if the port is defined in the CMC model as "wired at
     * runtime"-port. The proxy will connect to the CCA application specified
     * by appId. The CCA SrvSupplier messages will be used to determine the
     * availability of this application and the service. It's guranteed that
     * the corresponding CCA server will have the specified major version and
     * at least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Tcu_usb_main_fiProxy > createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Tcu_usb_main_fiProxy. The caller has to pass
     * the port name. The port name is defined in the "Car Multimedia
     * Component" model. With the help of the port name it is possible to
     * address the concrete proxy, which is defined in the CMC model
     * description.
     */
    static ::boost::shared_ptr< Tcu_usb_main_fiProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Destructor of Tcu_usb_main_fiProxy. The destructor will send RelUpReg
     * messages for all property notifications and call the error callback of
     * all pending method invocations.
     */
    ~Tcu_usb_main_fiProxy();

    // Method 'GetChannelData'

    /**
     * Call the method 'GetChannelData'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'GetChannelData'</b>:
     *
     * This method is called whenever HMI sends any request to the TCU.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param Channel_Info_List List of Channel ID and Channel Content ID
     *
     * @param bBackgroundDownloadType Describe this channel data belong to BackgroundDownload type or not.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetChannelDataStart(GetChannelDataCallbackIF& cb, const ::tcu_usb_main_fi_types::T_usb_tcu_Channel_Info_List& channel_Info_List, bool bBackgroundDownloadType);

    // Method 'GetConnectedSearchResult'

    /**
     * Call the method 'GetConnectedSearchResult'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'GetConnectedSearchResult'</b>:
     *
     * This method is called whenever any Connected Search is requested from HMI.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8SizeOfKeyWord Size of the keyword to be searched.
     *
     * @param strKeyWord The keyword to be searched.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetConnectedSearchResultStart(GetConnectedSearchResultCallbackIF& cb, uint8 u8SizeOfKeyWord, const ::std::string& strKeyWord);

    // Method 'GetChannelMasterData'

    /**
     * Call the method 'GetChannelMasterData'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'GetChannelMasterData'</b>:
     *
     * This method is called whenever channel master data is requested by HMI.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param bBackgroundDownloadType Describe this channel data belong to BackgroundDownload type or not.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetChannelMasterDataStart(GetChannelMasterDataCallbackIF& cb, bool bBackgroundDownloadType);

    // Method 'SynthesizeSpeak'

    /**
     * Call the method 'SynthesizeSpeak'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SynthesizeSpeak'</b>:
     *
     * <p>This method will synthesize the text. The data is synthesised via TCU_TTS source.
     * If there is a on going synthesize then the current synthesize will be aborted and then new text will be synthesized.</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param TextAndTags <p>The string contains the text to be synthesized. Additionaly,
     * tags can be used within the string to give some extra
     * information. The possible tags for this method are:
     * <p>the tag <rate=>specifies the rate of the synthesis to be used,</p>
     * <p>the tag <vol=> specifies the volume of the synthesis to be used.</p>
     * <p>The tag <ttsdom=> specifies the domain for which tuning files are to be loaded.
     * Possible values are: 0:none, 1:navi, 2:sds</p>
     * <p>Example: <ttsdom=navi></p>
     * <p>The tag <dict> specifies information about the dictionary to be used for the included string.
     * It will look like "<dict destcat=... dest=... countryvoice=... lang=...countrydest=...countrydestname=...>String</dict>".</p>
     * <p>The parameter destcat is used to define, which type of the
     * dest-parameter is (destcat:dest => 1:SelectionCriterionType, 2:SpeechAppDictType, 3:T_e8_Slot, 4:T_e8_SDSDestinationType).</p>
     * <p>Destination contains - as described above - the ID of the
     * dictionary-type according to the definition in the li_fi
     * (SelectionCriterionType), sp_speechdp_fi (SpeechAppDictType) or  respectively.</p>
     * <p>The parameters countrydest and lang must be used according to ISO 3166 ALPHA 3 and ISO 639-1.
     * The whole string will only be parsed for this tag, if the parameter "TextStyle" is set to "Dicts".</p>
     * <p>The parameter countrydestname is used to optionally define the countryname if countrydest is not available.</p></p>
     *
     * @param u16ChannelID <p>ChannelID to fetch title and text for TTS from database.</p>
     *
     * @param u8ChannelContentsID <p>ChannelContentsID to fetch title and text for TTS from database.</p>
     *
     * @param bHoldAudioChannel <p>if bHoldAudioChannel == true -> then audio source (TCU_TTS) will NOT be released after the text synthesis is complete.</p>
     * <p>bHoldAudioChannel == false -> then audio source (TCU_TTS) will be released after the text synthesis is complete.</p>
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSynthesizeSpeakStart(SynthesizeSpeakCallbackIF& cb, const ::std::string& textAndTags, uint16 u16ChannelID, uint8 u8ChannelContentsID, bool bHoldAudioChannel);

    // Method 'AbortPrompt'

    /**
     * Call the method 'AbortPrompt'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'AbortPrompt'</b>:
     *
     * <p>This method will abort the synthesize. The job will be aborted and not continued at any time.
     * If Client want the synthesis to be done again, Client has to send SynthesizeSpeak() once again.</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param bHoldAudioChannel <p>if bHoldAudioChannel == true -> then audio source (TCU_TTS) will NOT be released after the Abort.</p>
     * <p>bHoldAudioChannel == false -> then audio source (TCU_TTS) will be released after the Abort.</p>
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAbortPromptStart(AbortPromptCallbackIF& cb, bool bHoldAudioChannel);

    // Method 'PausePrompt'

    /**
     * Call the method 'PausePrompt'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'PausePrompt'</b>:
     *
     * <p>This Method provides an opportunity for the client to pause the synthesis at a given point.
     * The job will be continued from the same point it has stopped, when the Method "ContinuePrompt" is send by Client.</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPausePromptStart(PausePromptCallbackIF& cb);

    // Method 'ContinuePrompt'

    /**
     * Call the method 'ContinuePrompt'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'ContinuePrompt'</b>:
     *
     * <p>This Method is used to continue synthesize.
     * "ContinuePrompt" has to be send only after "PausePrompt".</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendContinuePromptStart(ContinuePromptCallbackIF& cb);

    // Method 'CancelRequest'

    /**
     * Call the method 'CancelRequest'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'CancelRequest'</b>:
     *
     * <p>This Method is called when a user cancels an already placed request.</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param eCancelRequestType Describes the request type
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCancelRequestStart(CancelRequestCallbackIF& cb, ::tcu_usb_main_fi_types::T_e8_CancelRequestType eCancelRequestType);

    // Method 'SendGroupAData'

    /**
     * Call the method 'SendGroupAData'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SendGroupAData'</b>:
     *
     * <p>This Method is called when GroupA to be sent to the backend.</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param GroupA_Info Describes the GroupA data
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSendGroupADataStart(SendGroupADataCallbackIF& cb, const ::tcu_usb_main_fi_types::T_usb_tcu_GroupA_Info& groupA_Info);

    // Method 'DeleteInVehicleMessage'

    /**
     * Call the method 'DeleteInVehicleMessage'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'DeleteInVehicleMessage'</b>:
     *
     * This Method is called by HMI to delete a particular IVM.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param s64IndexInternal IndexInternal to delete a particular channel in IVM database.
     *
     * @param u8ChannelContentsID ChannelContentsID to delete a particular content of a channel in IVM database.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDeleteInVehicleMessageStart(DeleteInVehicleMessageCallbackIF& cb, int64 s64IndexInternal, uint8 u8ChannelContentsID);

    // Method 'ResetDatabase'

    /**
     * Call the method 'ResetDatabase'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'ResetDatabase'</b>:
     *
     * This Method is called by HMI to reset database.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendResetDatabaseStart(ResetDatabaseCallbackIF& cb);

    // Method 'GetServerList'

    /**
     * Call the method 'GetServerList'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'GetServerList'</b>:
     *
     * This Method is called by HMI to get list of Servers supported.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetServerListStart(GetServerListCallbackIF& cb);

    // Method 'SelectServer'

    /**
     * Call the method 'SelectServer'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'SelectServer'</b>:
     *
     * This Method is called by HMI to select server for use.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8ServerId Selected server ID .
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSelectServerStart(SelectServerCallbackIF& cb, uint8 u8ServerId);

    // Method 'RetryGetChannelData'

    /**
     * Call the method 'RetryGetChannelData'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'RetryGetChannelData'</b>:
     *
     * This Method is called by HMI to retry channel data download for IVM/MIS/MS.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u16ChannelID Channel ID.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRetryGetChannelDataStart(RetryGetChannelDataCallbackIF& cb, uint16 u16ChannelID);

    // Method 'OverwriteIVMTotalContents'

    /**
     * Call the method 'OverwriteIVMTotalContents'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'OverwriteIVMTotalContents'</b>:
     *
     * This Method is called by HMI to overwrite the TotalNumOfContents value of a IVM channel with StoredNumOfContents. This method is called when the user doesn't want to download pending contents.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u16ChannelID Channel ID.
     *
     * @param s64IndexInternal IndexInternal to update a particular channel in IVM database.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendOverwriteIVMTotalContentsStart(OverwriteIVMTotalContentsCallbackIF& cb, uint16 u16ChannelID, int64 s64IndexInternal);

    // Method 'StoreCSHistory'

    /**
     * Call the method 'StoreCSHistory'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'StoreCSHistory'</b>:
     *
     * This Method is called by HMI to write CS keyword to DB.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param strKeyWord The searched keyword.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStoreCSHistoryStart(StoreCSHistoryCallbackIF& cb, const ::std::string& strKeyWord);

    // Method 'GetTCUDeviceInfo'

    /**
     * Call the method 'GetTCUDeviceInfo'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'GetTCUDeviceInfo'</b>:
     *
     * This Method is called by HMI to get info of TCU device.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetTCUDeviceInfoStart(GetTCUDeviceInfoCallbackIF& cb);

    // Method 'SetLogLevel'

    /**
     * Call the method 'SetLogLevel'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'SetLogLevel'</b>:
     *
     * This Method is called by HMI to set Log level.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8LogLevel Log level.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetLogLevelStart(SetLogLevelCallbackIF& cb, ::tcu_usb_main_fi_types::T_e8_tcu_LogLevel u8LogLevel);

    // Method 'RestoreFactorySettings'

    /**
     * Call the method 'RestoreFactorySettings'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'RestoreFactorySettings'</b>:
     *
     * This Method is called by HMI to restore factory settings.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRestoreFactorySettingsStart(RestoreFactorySettingsCallbackIF& cb);

    // Method 'DeleteMessageBox'

    /**
     * Call the method 'DeleteMessageBox'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'DeleteMessageBox'</b>:
     *
     * This Method is called by HMI to delete Message Box table in database.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDeleteMessageBoxStart(DeleteMessageBoxCallbackIF& cb);

    // Method 'InitializeFeedList'

    /**
     * Call the method 'InitializeFeedList'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'InitializeFeedList'</b>:
     *
     * This Method is called by HMI to Initialize Feed List in database.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendInitializeFeedListStart(InitializeFeedListCallbackIF& cb);

    // Method 'SetAutoDownloadInterval'

    /**
     * Call the method 'SetAutoDownloadInterval'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'SetAutoDownloadInterval'</b>:
     *
     * This Method is called by HMI to Set AutoDownload Interval.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param AutoDownloadInterval AutoDownload Interval options
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetAutoDownloadIntervalStart(SetAutoDownloadIntervalCallbackIF& cb, ::tcu_usb_main_fi_types::T_e8_AutoDownloadInterval autoDownloadInterval);

    // Method 'GetAutoDownloadInterval'

    /**
     * Call the method 'GetAutoDownloadInterval'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'GetAutoDownloadInterval'</b>:
     *
     * This Method is called by HMI to get AutoDownload Interval.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetAutoDownloadIntervalStart(GetAutoDownloadIntervalCallbackIF& cb);

    // Method 'SetAutoDownloadChannel'

    /**
     * Call the method 'SetAutoDownloadChannel'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'SetAutoDownloadChannel'</b>:
     *
     * This Method is called by HMI to Set AutoDownload Channel.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param Channel_Info_List Fill Channel IDs in the list for AutoDownload
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetAutoDownloadChannelStart(SetAutoDownloadChannelCallbackIF& cb, const ::tcu_usb_main_fi_types::T_usb_tcu_Channel_Info_List& channel_Info_List);

    // Method 'GetFavoriteChannelList'

    /**
     * Call the method 'GetFavoriteChannelList'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'GetFavoriteChannelList'</b>:
     *
     * This Method is called by HMI to download favorite channel list.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetFavoriteChannelListStart(GetFavoriteChannelListCallbackIF& cb);

    // Method 'SetFavoriteChannel'

    /**
     * Call the method 'SetFavoriteChannel'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SetFavoriteChannel'</b>:
     *
     * This Method is called by HMI to Set favorite Channel.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param Channel_Info_List Fill Channel IDs in the list for favorite
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetFavoriteChannelStart(SetFavoriteChannelCallbackIF& cb, const ::tcu_usb_main_fi_types::T_usb_tcu_Channel_Info_List& channel_Info_List);

    // Method 'ReadFavoriteFeeds'

    /**
     * Call the method 'ReadFavoriteFeeds'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'ReadFavoriteFeeds'</b>:
     *
     * This Method is called by SDS (or any other module) to read favorite feeds that are stored in database.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReadFavoriteFeedsStart(ReadFavoriteFeedsCallbackIF& cb);

    // Method 'SelectFavoriteFeeds'

    /**
     * Call the method 'SelectFavoriteFeeds'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SelectFavoriteFeeds'</b>:
     *
     * This Method is called by SDS (or any other module) to inform the favorite feed selected by user for download.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u16ChannelID ChannelID of selected feed.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSelectFavoriteFeedsStart(SelectFavoriteFeedsCallbackIF& cb, uint16 u16ChannelID);

    // Method 'DeleteInfoHistory'

    /**
     * Call the method 'DeleteInfoHistory'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'DeleteInfoHistory'</b>:
     *
     * This Method is called by HMI to delete Info History table in database.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDeleteInfoHistoryStart(DeleteInfoHistoryCallbackIF& cb);

    // Method 'GetVICSTrafficData'

    /**
     * Call the method 'GetVICSTrafficData'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'GetVICSTrafficData'</b>:
     *
     * This Method is called by HMI to Get the VICS Traffic data.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param VICSRequestData Json file path along with file name.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetVICSTrafficDataStart(GetVICSTrafficDataCallbackIF& cb, const ::tcu_usb_main_fi_types::T_tcu_VICS_Request_Data& vICSRequestData);

    // Method 'GetChargingStationsList'

    /**
     * Call the method 'GetChargingStationsList'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'GetChargingStationsList'</b>:
     *
     * This Method is called by HMI to Get Charging Stations List.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param ChargingStationsRequestInfo Charging Stations Request Info
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetChargingStationsListStart(GetChargingStationsListCallbackIF& cb, const ::tcu_usb_main_fi_types::T_usb_tcu_Charging_Stations_Request_Info& chargingStationsRequestInfo);

    // Method 'GetChargingSpotData'

    /**
     * Call the method 'GetChargingSpotData'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'GetChargingSpotData'</b>:
     *
     * This Method is called by HMI to Get Charging Spot Data.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param POIIDList POI ID.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetChargingSpotDataStart(GetChargingSpotDataCallbackIF& cb, const ::tcu_usb_main_fi_types::T_usb_tcu_POIID_List& pOIIDList);

    // Method 'GetVacancySpotData'

    /**
     * Call the method 'GetVacancySpotData'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'GetVacancySpotData'</b>:
     *
     * This Method is called by HMI to Get Vacancy Spot Data.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param POIIDList POI ID.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetVacancySpotDataStart(GetVacancySpotDataCallbackIF& cb, const ::tcu_usb_main_fi_types::T_usb_tcu_POIID_List& pOIIDList);

    // Method 'GetVacancyStationsList'

    /**
     * Call the method 'GetVacancyStationsList'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'GetVacancyStationsList'</b>:
     *
     * This Method is called by HMI to Get Vacancy Stations List.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param VacancyStationsRequestInfo Vacancy Stations Request Info
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetVacancyStationsListStart(GetVacancyStationsListCallbackIF& cb, const ::tcu_usb_main_fi_types::T_usb_tcu_Vacancy_Stations_Request_Info& vacancyStationsRequestInfo);

    // Method 'SendUserCredentials'

    /**
     * Call the method 'SendUserCredentials'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SendUserCredentials'</b>:
     *
     * If the meaning of "SendUserCredentials" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param sUserId If the meaning of "sUserId" isn't clear, then there should be a description here.
     *
     * @param sPassword If the meaning of "sPassword" isn't clear, then there should be a description here.
     *
     * @param bClearData If the meaning of "bClearData" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSendUserCredentialsStart(SendUserCredentialsCallbackIF& cb, const ::std::string& sUserId, const ::std::string& sPassword, bool bClearData);

    // Method 'DeleteChannelInformation'

    /**
     * Call the method 'DeleteChannelInformation'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'DeleteChannelInformation'</b>:
     *
     * This Method is called by HMI to delete a particular Channel from database completely, everything.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u16ChannelID ChannelID to be delete from database.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDeleteChannelInformationStart(DeleteChannelInformationCallbackIF& cb, uint16 u16ChannelID);

    // Method 'DownloadPartAuthData'

    /**
     * Call the method 'DownloadPartAuthData'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'DownloadPartAuthData'</b>:
     *
     * This Method is called by some other component to download the Part Authentication Data.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDownloadPartAuthDataStart(DownloadPartAuthDataCallbackIF& cb);

    // Method 'ValidateUserCredentials'

    /**
     * Call the method 'ValidateUserCredentials'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'ValidateUserCredentials'</b>:
     *
     * This Method is called by some other component to ValidateUserCredentials
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param sUserId If the meaning of "sUserId" isn't clear, then there should be a description here.
     *
     * @param sPassword If the meaning of "sPassword" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendValidateUserCredentialsStart(ValidateUserCredentialsCallbackIF& cb, const ::std::string& sUserId, const ::std::string& sPassword);

    // Method 'RenewAccessToken'

    /**
     * Call the method 'RenewAccessToken'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'RenewAccessToken'</b>:
     *
     * This Method is called by some other component for renewing token
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRenewAccessTokenStart(RenewAccessTokenCallbackIF& cb);

    // Method 'GetAccessToken'

    /**
     * Call the method 'GetAccessToken'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'GetAccessToken'</b>:
     *
     * This Method is called by some other component to GetAccessToken
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetAccessTokenStart(GetAccessTokenCallbackIF& cb);

    // Method 'ValidateUserCredentialsOnTokenRenewalError'

    /**
     * Call the method 'ValidateUserCredentialsOnTokenRenewalError'. This
     * method sends a MethodStart message to the CCA server.
     *
     * <b>Documentation of 'ValidateUserCredentialsOnTokenRenewalError'</b>:
     *
     * This Method is called by User Auth HMI to ValidateUserCredentials.
     * In case the user cancels, this method should be called with empty strings in parameter.
     * In case the user does not enter credentials and presses ok, this method should not be called.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param sUserId If the meaning of "sUserId" isn't clear, then there should be a description here.
     *
     * @param sPassword If the meaning of "sPassword" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendValidateUserCredentialsOnTokenRenewalErrorStart(ValidateUserCredentialsOnTokenRenewalErrorCallbackIF& cb, const ::std::string& sUserId, const ::std::string& sPassword);

    // Method 'CancelUserValidationRenewToken'

    /**
     * Call the method 'CancelUserValidationRenewToken'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'CancelUserValidationRenewToken'</b>:
     *
     * This Method is called by some other component to Cancel an already placed user authentication request.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCancelUserValidationRenewTokenStart(CancelUserValidationRenewTokenCallbackIF& cb);

    // Method 'DecodeIdToken'

    /**
     * Call the method 'DecodeIdToken'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'DecodeIdToken'</b>:
     *
     * This Method is called by some other component to get the decoded Id_token in json format.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param Token Token that needs to be decoded.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDecodeIdTokenStart(DecodeIdTokenCallbackIF& cb, const ::std::string& token);

    // Method 'ResetNCSSettings'

    /**
     * Call the method 'ResetNCSSettings'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'ResetNCSSettings'</b>:
     *
     * This Method is called by HMI to Reset NCS Settings.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendResetNCSSettingsStart(ResetNCSSettingsCallbackIF& cb);

    // Method 'GetProbeUploadPermit'

    /**
     * Call the method 'GetProbeUploadPermit'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'GetProbeUploadPermit'</b>:
     *
     * This method is called by ITM when the probe upload permit is chnaged from ITM side(MCAN Fct Id:244h).
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetProbeUploadPermitStart(GetProbeUploadPermitCallbackIF& cb);

    // Method 'SetProbeUploadPermit'

    /**
     * Call the method 'SetProbeUploadPermit'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SetProbeUploadPermit'</b>:
     *
     * This method is called by ITM when there is change in Probe Upload permit from ITM side(MCAN Fct Id:244h).
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param e8ProbePermitSetting Probe Permit setting.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetProbeUploadPermitStart(SetProbeUploadPermitCallbackIF& cb, ::tcu_usb_main_fi_types::T_e8_TCU_ProbePermitSetting e8ProbePermitSetting);

    // Method 'SetProbeInfoDelete'

    /**
     * Call the method 'SetProbeInfoDelete'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SetProbeInfoDelete'</b>:
     *
     * This method is called by ITM to delete the Probe info(MCAN Fct Id:245h).
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetProbeInfoDeleteStart(SetProbeInfoDeleteCallbackIF& cb);

    // Property 'UserCredentialStatus'

    /**
     * Notify on the property 'UserCredentialStatus'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'UserCredentialStatus'</b>:
     *
     * Property update status of user credentials updated
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUserCredentialStatusUpReg(UserCredentialStatusCallbackIF& cb);

    /**
     * Remove the notifcation on property 'UserCredentialStatus'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'UserCredentialStatus'</b>:
     *
     * Property update status of user credentials updated
     *
     * @param act The act which was previously returned by the
     * sendUserCredentialStatusUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendUserCredentialStatusRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'UserCredentialStatus'.
     */
    void sendUserCredentialStatusRelUpRegAll ();

    /**
     * Returns the current value of the property 'UserCredentialStatus' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasUserCredentialStatus() returns true.
     *
     * @return the previously received value of the property 'UserCredentialStatus'.
     */
    const UserCredentialStatusStatus& getUserCredentialStatus() const;

    /**
     * Determines whether a status message for the property 'UserCredentialStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasUserCredentialStatus() const;

    // Property 'NotifyTokenRenewalError'

    /**
     * Notify on the property 'NotifyTokenRenewalError'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'NotifyTokenRenewalError'</b>:
     *
     * This property is sent to HMI to Display User Credentials screen to get the credentials from user and call validation by credentials method.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNotifyTokenRenewalErrorUpReg(NotifyTokenRenewalErrorCallbackIF& cb);

    /**
     * Remove the notifcation on property 'NotifyTokenRenewalError'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'NotifyTokenRenewalError'</b>:
     *
     * This property is sent to HMI to Display User Credentials screen to get the credentials from user and call validation by credentials method.
     *
     * @param act The act which was previously returned by the
     * sendNotifyTokenRenewalErrorUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendNotifyTokenRenewalErrorRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'NotifyTokenRenewalError'.
     */
    void sendNotifyTokenRenewalErrorRelUpRegAll ();

    /**
     * Returns the current value of the property 'NotifyTokenRenewalError' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasNotifyTokenRenewalError() returns true.
     *
     * @return the previously received value of the property 'NotifyTokenRenewalError'.
     */
    const NotifyTokenRenewalErrorStatus& getNotifyTokenRenewalError() const;

    /**
     * Determines whether a status message for the property 'NotifyTokenRenewalError' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasNotifyTokenRenewalError() const;

    // Property 'ConnectedSearchResult'

    /**
     * Notify on the property 'ConnectedSearchResult'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'ConnectedSearchResult'</b>:
     *
     * Property update for connected search results
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConnectedSearchResultUpReg(ConnectedSearchResultCallbackIF& cb);

    /**
     * Remove the notifcation on property 'ConnectedSearchResult'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'ConnectedSearchResult'</b>:
     *
     * Property update for connected search results
     *
     * @param act The act which was previously returned by the
     * sendConnectedSearchResultUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendConnectedSearchResultRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'ConnectedSearchResult'.
     */
    void sendConnectedSearchResultRelUpRegAll ();

    /**
     * Returns the current value of the property 'ConnectedSearchResult' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasConnectedSearchResult() returns true.
     *
     * @return the previously received value of the property 'ConnectedSearchResult'.
     */
    const ConnectedSearchResultStatus& getConnectedSearchResult() const;

    /**
     * Determines whether a status message for the property 'ConnectedSearchResult' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasConnectedSearchResult() const;

    // Property 'ChannelMasterData'

    /**
     * Notify on the property 'ChannelMasterData'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'ChannelMasterData'</b>:
     *
     * Set Channel Master Data
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendChannelMasterDataUpReg(ChannelMasterDataCallbackIF& cb);

    /**
     * Remove the notifcation on property 'ChannelMasterData'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'ChannelMasterData'</b>:
     *
     * Set Channel Master Data
     *
     * @param act The act which was previously returned by the
     * sendChannelMasterDataUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendChannelMasterDataRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'ChannelMasterData'.
     */
    void sendChannelMasterDataRelUpRegAll ();

    /**
     * Returns the current value of the property 'ChannelMasterData' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasChannelMasterData() returns true.
     *
     * @return the previously received value of the property 'ChannelMasterData'.
     */
    const ChannelMasterDataStatus& getChannelMasterData() const;

    /**
     * Determines whether a status message for the property 'ChannelMasterData' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasChannelMasterData() const;

    // Property 'TtsAudioStateRequest'

    /**
     * Notify on the property 'TtsAudioStateRequest'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'TtsAudioStateRequest'</b>:
     *
     * Request TtsAudio channel state
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTtsAudioStateRequestUpReg(TtsAudioStateRequestCallbackIF& cb);

    /**
     * Remove the notifcation on property 'TtsAudioStateRequest'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'TtsAudioStateRequest'</b>:
     *
     * Request TtsAudio channel state
     *
     * @param act The act which was previously returned by the
     * sendTtsAudioStateRequestUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendTtsAudioStateRequestRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'TtsAudioStateRequest'.
     */
    void sendTtsAudioStateRequestRelUpRegAll ();

    /**
     * Returns the current value of the property 'TtsAudioStateRequest' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasTtsAudioStateRequest() returns true.
     *
     * @return the previously received value of the property 'TtsAudioStateRequest'.
     */
    const TtsAudioStateRequestStatus& getTtsAudioStateRequest() const;

    /**
     * Determines whether a status message for the property 'TtsAudioStateRequest' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasTtsAudioStateRequest() const;

    // Property 'DatabaseStatus'

    /**
     * Notify on the property 'DatabaseStatus'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'DatabaseStatus'</b>:
     *
     * This property gives the information about the availability of USB TCU database.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDatabaseStatusUpReg(DatabaseStatusCallbackIF& cb);

    /**
     * Remove the notifcation on property 'DatabaseStatus'. This method sends
     * a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DatabaseStatus'</b>:
     *
     * This property gives the information about the availability of USB TCU database.
     *
     * @param act The act which was previously returned by the
     * sendDatabaseStatusUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDatabaseStatusRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DatabaseStatus'.
     */
    void sendDatabaseStatusRelUpRegAll ();

    /**
     * Returns the current value of the property 'DatabaseStatus' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasDatabaseStatus() returns true.
     *
     * @return the previously received value of the property 'DatabaseStatus'.
     */
    const DatabaseStatusStatus& getDatabaseStatus() const;

    /**
     * Determines whether a status message for the property 'DatabaseStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDatabaseStatus() const;

    /**
     * Set the value of the property 'DatabaseStatus'. This method sends a Set
     * message to the CCA server.
     *
     * <b>Documentation of 'DatabaseStatus'</b>:
     *
     * This property gives the information about the availability of USB TCU database.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDatabaseStatusSet(DatabaseStatusCallbackIF& cb);

    // Property 'DataConnectionStatus'

    /**
     * Notify on the property 'DataConnectionStatus'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'DataConnectionStatus'</b>:
     *
     * This property gives the information about the data connection to backend status (active or inactive).
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDataConnectionStatusUpReg(DataConnectionStatusCallbackIF& cb);

    /**
     * Remove the notifcation on property 'DataConnectionStatus'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DataConnectionStatus'</b>:
     *
     * This property gives the information about the data connection to backend status (active or inactive).
     *
     * @param act The act which was previously returned by the
     * sendDataConnectionStatusUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDataConnectionStatusRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DataConnectionStatus'.
     */
    void sendDataConnectionStatusRelUpRegAll ();

    /**
     * Returns the current value of the property 'DataConnectionStatus' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasDataConnectionStatus() returns true.
     *
     * @return the previously received value of the property 'DataConnectionStatus'.
     */
    const DataConnectionStatusStatus& getDataConnectionStatus() const;

    /**
     * Determines whether a status message for the property 'DataConnectionStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDataConnectionStatus() const;

    // Property 'DataConnectionError'

    /**
     * Notify on the property 'DataConnectionError'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'DataConnectionError'</b>:
     *
     * This property gives the information about the data connection error type.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDataConnectionErrorUpReg(DataConnectionErrorCallbackIF& cb);

    /**
     * Remove the notifcation on property 'DataConnectionError'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DataConnectionError'</b>:
     *
     * This property gives the information about the data connection error type.
     *
     * @param act The act which was previously returned by the
     * sendDataConnectionErrorUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDataConnectionErrorRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DataConnectionError'.
     */
    void sendDataConnectionErrorRelUpRegAll ();

    /**
     * Returns the current value of the property 'DataConnectionError' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasDataConnectionError() returns true.
     *
     * @return the previously received value of the property 'DataConnectionError'.
     */
    const DataConnectionErrorStatus& getDataConnectionError() const;

    /**
     * Determines whether a status message for the property 'DataConnectionError' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDataConnectionError() const;

    // Property 'ServerList'

    /**
     * Notify on the property 'ServerList'. This method sends a UpReg message
     * to the CCA server.
     *
     * <b>Documentation of 'ServerList'</b>:
     *
     * This property gives the information about the server list.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendServerListUpReg(ServerListCallbackIF& cb);

    /**
     * Remove the notifcation on property 'ServerList'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'ServerList'</b>:
     *
     * This property gives the information about the server list.
     *
     * @param act The act which was previously returned by the
     * sendServerListUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendServerListRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'ServerList'.
     */
    void sendServerListRelUpRegAll ();

    /**
     * Returns the current value of the property 'ServerList' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when
     * hasServerList() returns true.
     *
     * @return the previously received value of the property 'ServerList'.
     */
    const ServerListStatus& getServerList() const;

    /**
     * Determines whether a status message for the property 'ServerList' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasServerList() const;

    // Property 'TCUDeviceInfo'

    /**
     * Notify on the property 'TCUDeviceInfo'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'TCUDeviceInfo'</b>:
     *
     * This property gives the information about TCU Device.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTCUDeviceInfoUpReg(TCUDeviceInfoCallbackIF& cb);

    /**
     * Remove the notifcation on property 'TCUDeviceInfo'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'TCUDeviceInfo'</b>:
     *
     * This property gives the information about TCU Device.
     *
     * @param act The act which was previously returned by the
     * sendTCUDeviceInfoUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendTCUDeviceInfoRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'TCUDeviceInfo'.
     */
    void sendTCUDeviceInfoRelUpRegAll ();

    /**
     * Returns the current value of the property 'TCUDeviceInfo' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasTCUDeviceInfo() returns true.
     *
     * @return the previously received value of the property 'TCUDeviceInfo'.
     */
    const TCUDeviceInfoStatus& getTCUDeviceInfo() const;

    /**
     * Determines whether a status message for the property 'TCUDeviceInfo' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasTCUDeviceInfo() const;

    // Property 'NotifyAutoDownloadInterval'

    /**
     * Notify on the property 'NotifyAutoDownloadInterval'. This method sends
     * a UpReg message to the CCA server.
     *
     * <b>Documentation of 'NotifyAutoDownloadInterval'</b>:
     *
     * This property gives the information about AutoDownload Interval.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNotifyAutoDownloadIntervalUpReg(NotifyAutoDownloadIntervalCallbackIF& cb);

    /**
     * Remove the notifcation on property 'NotifyAutoDownloadInterval'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'NotifyAutoDownloadInterval'</b>:
     *
     * This property gives the information about AutoDownload Interval.
     *
     * @param act The act which was previously returned by the
     * sendNotifyAutoDownloadIntervalUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendNotifyAutoDownloadIntervalRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'NotifyAutoDownloadInterval'.
     */
    void sendNotifyAutoDownloadIntervalRelUpRegAll ();

    /**
     * Returns the current value of the property 'NotifyAutoDownloadInterval'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasNotifyAutoDownloadInterval() returns true.
     *
     * @return the previously received value of the property 'NotifyAutoDownloadInterval'.
     */
    const NotifyAutoDownloadIntervalStatus& getNotifyAutoDownloadInterval() const;

    /**
     * Determines whether a status message for the property 'NotifyAutoDownloadInterval' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasNotifyAutoDownloadInterval() const;

    // Property 'GeneralNotificationMessage'

    /**
     * Notify on the property 'GeneralNotificationMessage'. This method sends
     * a UpReg message to the CCA server.
     *
     * <b>Documentation of 'GeneralNotificationMessage'</b>:
     *
     * This property gives the information about the General Notification Message.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGeneralNotificationMessageUpReg(GeneralNotificationMessageCallbackIF& cb);

    /**
     * Remove the notifcation on property 'GeneralNotificationMessage'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'GeneralNotificationMessage'</b>:
     *
     * This property gives the information about the General Notification Message.
     *
     * @param act The act which was previously returned by the
     * sendGeneralNotificationMessageUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendGeneralNotificationMessageRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'GeneralNotificationMessage'.
     */
    void sendGeneralNotificationMessageRelUpRegAll ();

    /**
     * Returns the current value of the property 'GeneralNotificationMessage'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasGeneralNotificationMessage() returns true.
     *
     * @return the previously received value of the property 'GeneralNotificationMessage'.
     */
    const GeneralNotificationMessageStatus& getGeneralNotificationMessage() const;

    /**
     * Determines whether a status message for the property 'GeneralNotificationMessage' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasGeneralNotificationMessage() const;

    // Property 'AuthenticationResultData'

    /**
     * Notify on the property 'AuthenticationResultData'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'AuthenticationResultData'</b>:
     *
     * This property gives the information about the Authentication Result Data.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAuthenticationResultDataUpReg(AuthenticationResultDataCallbackIF& cb);

    /**
     * Remove the notifcation on property 'AuthenticationResultData'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'AuthenticationResultData'</b>:
     *
     * This property gives the information about the Authentication Result Data.
     *
     * @param act The act which was previously returned by the
     * sendAuthenticationResultDataUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendAuthenticationResultDataRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'AuthenticationResultData'.
     */
    void sendAuthenticationResultDataRelUpRegAll ();

    /**
     * Returns the current value of the property 'AuthenticationResultData'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasAuthenticationResultData() returns true.
     *
     * @return the previously received value of the property 'AuthenticationResultData'.
     */
    const AuthenticationResultDataStatus& getAuthenticationResultData() const;

    /**
     * Determines whether a status message for the property 'AuthenticationResultData' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAuthenticationResultData() const;

    // Property 'VICSTrafficData'

    /**
     * Notify on the property 'VICSTrafficData'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'VICSTrafficData'</b>:
     *
     * This property gives the information about the VICS Traffic Data.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendVICSTrafficDataUpReg(VICSTrafficDataCallbackIF& cb);

    /**
     * Remove the notifcation on property 'VICSTrafficData'. This method sends
     * a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'VICSTrafficData'</b>:
     *
     * This property gives the information about the VICS Traffic Data.
     *
     * @param act The act which was previously returned by the
     * sendVICSTrafficDataUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendVICSTrafficDataRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'VICSTrafficData'.
     */
    void sendVICSTrafficDataRelUpRegAll ();

    /**
     * Returns the current value of the property 'VICSTrafficData' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasVICSTrafficData() returns true.
     *
     * @return the previously received value of the property 'VICSTrafficData'.
     */
    const VICSTrafficDataStatus& getVICSTrafficData() const;

    /**
     * Determines whether a status message for the property 'VICSTrafficData' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasVICSTrafficData() const;

    // Property 'ChargingStationsList'

    /**
     * Notify on the property 'ChargingStationsList'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'ChargingStationsList'</b>:
     *
     * This property gives information about the charging stations list.
     * This is the response for the methodstart getChargingStationsList
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendChargingStationsListUpReg(ChargingStationsListCallbackIF& cb);

    /**
     * Remove the notifcation on property 'ChargingStationsList'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'ChargingStationsList'</b>:
     *
     * This property gives information about the charging stations list.
     * This is the response for the methodstart getChargingStationsList
     *
     * @param act The act which was previously returned by the
     * sendChargingStationsListUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendChargingStationsListRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'ChargingStationsList'.
     */
    void sendChargingStationsListRelUpRegAll ();

    /**
     * Returns the current value of the property 'ChargingStationsList' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasChargingStationsList() returns true.
     *
     * @return the previously received value of the property 'ChargingStationsList'.
     */
    const ChargingStationsListStatus& getChargingStationsList() const;

    /**
     * Determines whether a status message for the property 'ChargingStationsList' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasChargingStationsList() const;

    // Property 'ChargingSpotData'

    /**
     * Notify on the property 'ChargingSpotData'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'ChargingSpotData'</b>:
     *
     * This property gives information about the charging spot data.
     * This is the response for the methodstart getChargingSpotData
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendChargingSpotDataUpReg(ChargingSpotDataCallbackIF& cb);

    /**
     * Remove the notifcation on property 'ChargingSpotData'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'ChargingSpotData'</b>:
     *
     * This property gives information about the charging spot data.
     * This is the response for the methodstart getChargingSpotData
     *
     * @param act The act which was previously returned by the
     * sendChargingSpotDataUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendChargingSpotDataRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'ChargingSpotData'.
     */
    void sendChargingSpotDataRelUpRegAll ();

    /**
     * Returns the current value of the property 'ChargingSpotData' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasChargingSpotData() returns true.
     *
     * @return the previously received value of the property 'ChargingSpotData'.
     */
    const ChargingSpotDataStatus& getChargingSpotData() const;

    /**
     * Determines whether a status message for the property 'ChargingSpotData' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasChargingSpotData() const;

    // Property 'VacancyStationsList'

    /**
     * Notify on the property 'VacancyStationsList'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'VacancyStationsList'</b>:
     *
     * This property gives information about the vacancy stations list.
     * This is the response for the methodstart getVacancyStationsList
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendVacancyStationsListUpReg(VacancyStationsListCallbackIF& cb);

    /**
     * Remove the notifcation on property 'VacancyStationsList'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'VacancyStationsList'</b>:
     *
     * This property gives information about the vacancy stations list.
     * This is the response for the methodstart getVacancyStationsList
     *
     * @param act The act which was previously returned by the
     * sendVacancyStationsListUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendVacancyStationsListRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'VacancyStationsList'.
     */
    void sendVacancyStationsListRelUpRegAll ();

    /**
     * Returns the current value of the property 'VacancyStationsList' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasVacancyStationsList() returns true.
     *
     * @return the previously received value of the property 'VacancyStationsList'.
     */
    const VacancyStationsListStatus& getVacancyStationsList() const;

    /**
     * Determines whether a status message for the property 'VacancyStationsList' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasVacancyStationsList() const;

    // Property 'VacancySpotData'

    /**
     * Notify on the property 'VacancySpotData'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'VacancySpotData'</b>:
     *
     * This property gives information about the vacancy spot data.
     * This is the response for the methodstart getVacancySpotData
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendVacancySpotDataUpReg(VacancySpotDataCallbackIF& cb);

    /**
     * Remove the notifcation on property 'VacancySpotData'. This method sends
     * a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'VacancySpotData'</b>:
     *
     * This property gives information about the vacancy spot data.
     * This is the response for the methodstart getVacancySpotData
     *
     * @param act The act which was previously returned by the
     * sendVacancySpotDataUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendVacancySpotDataRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'VacancySpotData'.
     */
    void sendVacancySpotDataRelUpRegAll ();

    /**
     * Returns the current value of the property 'VacancySpotData' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasVacancySpotData() returns true.
     *
     * @return the previously received value of the property 'VacancySpotData'.
     */
    const VacancySpotDataStatus& getVacancySpotData() const;

    /**
     * Determines whether a status message for the property 'VacancySpotData' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasVacancySpotData() const;

    // Property 'GeneralResponseError'

    /**
     * Notify on the property 'GeneralResponseError'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'GeneralResponseError'</b>:
     *
     * This property informs the HMI about error occured in GeneralResponse received.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGeneralResponseErrorUpReg(GeneralResponseErrorCallbackIF& cb);

    /**
     * Remove the notifcation on property 'GeneralResponseError'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'GeneralResponseError'</b>:
     *
     * This property informs the HMI about error occured in GeneralResponse received.
     *
     * @param act The act which was previously returned by the
     * sendGeneralResponseErrorUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendGeneralResponseErrorRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'GeneralResponseError'.
     */
    void sendGeneralResponseErrorRelUpRegAll ();

    /**
     * Returns the current value of the property 'GeneralResponseError' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasGeneralResponseError() returns true.
     *
     * @return the previously received value of the property 'GeneralResponseError'.
     */
    const GeneralResponseErrorStatus& getGeneralResponseError() const;

    /**
     * Determines whether a status message for the property 'GeneralResponseError' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasGeneralResponseError() const;

    /**
     * Release all property notifications (on all properties).
     */
    void sendRelUpRegAll ();

private:

    Tcu_usb_main_fiProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags);

    virtual void clearAllProperties ();

    ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > createCallback (uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb);

    // Property 'UserCredentialStatus'

    ::asf::core::nullable< UserCredentialStatusStatus > _userCredentialStatus;

    // Property 'NotifyTokenRenewalError'

    ::asf::core::nullable< NotifyTokenRenewalErrorStatus > _notifyTokenRenewalError;

    // Property 'ConnectedSearchResult'

    ::asf::core::nullable< ConnectedSearchResultStatus > _connectedSearchResult;

    // Property 'ChannelMasterData'

    ::asf::core::nullable< ChannelMasterDataStatus > _channelMasterData;

    // Property 'TtsAudioStateRequest'

    ::asf::core::nullable< TtsAudioStateRequestStatus > _ttsAudioStateRequest;

    // Property 'DatabaseStatus'

    ::asf::core::nullable< DatabaseStatusStatus > _databaseStatus;

    // Property 'DataConnectionStatus'

    ::asf::core::nullable< DataConnectionStatusStatus > _dataConnectionStatus;

    // Property 'DataConnectionError'

    ::asf::core::nullable< DataConnectionErrorStatus > _dataConnectionError;

    // Property 'ServerList'

    ::asf::core::nullable< ServerListStatus > _serverList;

    // Property 'TCUDeviceInfo'

    ::asf::core::nullable< TCUDeviceInfoStatus > _tCUDeviceInfo;

    // Property 'NotifyAutoDownloadInterval'

    ::asf::core::nullable< NotifyAutoDownloadIntervalStatus > _notifyAutoDownloadInterval;

    // Property 'GeneralNotificationMessage'

    ::asf::core::nullable< GeneralNotificationMessageStatus > _generalNotificationMessage;

    // Property 'AuthenticationResultData'

    ::asf::core::nullable< AuthenticationResultDataStatus > _authenticationResultData;

    // Property 'VICSTrafficData'

    ::asf::core::nullable< VICSTrafficDataStatus > _vICSTrafficData;

    // Property 'ChargingStationsList'

    ::asf::core::nullable< ChargingStationsListStatus > _chargingStationsList;

    // Property 'ChargingSpotData'

    ::asf::core::nullable< ChargingSpotDataStatus > _chargingSpotData;

    // Property 'VacancyStationsList'

    ::asf::core::nullable< VacancyStationsListStatus > _vacancyStationsList;

    // Property 'VacancySpotData'

    ::asf::core::nullable< VacancySpotDataStatus > _vacancySpotData;

    // Property 'GeneralResponseError'

    ::asf::core::nullable< GeneralResponseErrorStatus > _generalResponseError;

    DECLARE_CLASS_LOGGER();

    friend class Tcu_usb_main_fiProxyCallback;
};

} // namespace tcu_usb_main_fi

#endif // TCU_USB_MAIN_FIPROXY_H
