#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef TCU_MAIN_FI_TYPES_H
#define TCU_MAIN_FI_TYPES_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "tcu_main_fi_typesConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * Types tcu_main_fi_types
 */

namespace tcu_main_fi_types {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class T_TCU_VersionInfo;

class T_TCU_Date_Time;

class T_TCU_Altitude;

class T_TCU_LocationInfo;

class T_TCU_Navi_Info;

class T_TCU_Score_Info;

class T_TCU_Navi_Road_classification;

class T_TCU_Probe_Vehicle_Info;

class T_TCU_Distance_Value;

class T_TCU_Maintenance_Info;

class T_TCU_Provision_List;

class T_TCU_ReminderInfo;

class T_TCU_GPS_Position;

class T_TCU_Time_Stamp;

class T_TCU_Opening_Hour_Day;

class T_TCU_Opening_Hour;

class T_TCU_Full_Address;

class T_TCU_Bookable_Free_Text;

class T_TCU_Receptacle;

class T_TCU_Spot_List;

class T_TCU_Charge_Spot_List;

class T_TCU_Time;

class T_TCU_Navigation_Language;

class T_TCU_Charge_Days;

class T_TCU_Spot_Receptacle_Type;

class PIN_Data;

class T_TCU_PIN;

class T_TCU_Wifi_SSID_Name;

class T_TCU_Wifi_PassKey;

class T_TCU_Time_Slot;

class T_TCU_Coordinates;

class T_TCU_Area_Coordinate;

class T_TCU_Area_Limit_Coordinates;

class T_TCU_Speed_Limit_Restriction;

class T_TCU_Area_Limit_Restriction;

// type definitions
/**
 * If the meaning of "T_TCU_Time_Limit_Restriction" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_TCU_Time_Slot > T_TCU_Time_Limit_Restriction;

/**
 * If the meaning of "T_TCU_Response_Time_Out" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_e8_TCU_Response_Time_Out > T_TCU_Response_Time_Out;


/**
 * Record type containing version information.
 */
class T_TCU_VersionInfo {
public:

    /**
     * Default constructor
     */
    inline  T_TCU_VersionInfo ();

    /**
     * Copy constructor
     */
    inline  T_TCU_VersionInfo (const T_TCU_VersionInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_TCU_VersionInfo (uint8 u8Upper_, uint8 u8Mid_, uint8 u8Lower_);

    /**
     * Destructor
     */
    inline  ~T_TCU_VersionInfo();

    /**
     * Assignment operator
     */
    inline T_TCU_VersionInfo& operator = (const T_TCU_VersionInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TCU_VersionInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TCU_VersionInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TCU_VersionInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TCU_VersionInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8Upper"

    static const int kU8Upper = 0;

    /**
     * Clears the field "u8Upper".
     *
     * The field will be set to its default value. The hasU8Upper()
     * method will return false.
     */
    inline void clearU8Upper();

    /**
     * Checks whether the field "u8Upper" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Upper()). Otherwise it will return false.
     */
    inline bool hasU8Upper () const;

    /**
     * Returns the value of the member "u8Upper".
     *
     * Upper (= Major) version number.
     *
     * @return The value of the field "u8Upper"
     */
    inline uint8 getU8Upper () const;

    /**
     * Sets the value of the member "u8Upper".
     *
     * Upper (= Major) version number.
     *
     * @param u8Upper The value which will be set
     */
    inline void setU8Upper (uint8 u8Upper_);

    // API of field "u8Mid"

    static const int kU8Mid = 1;

    /**
     * Clears the field "u8Mid".
     *
     * The field will be set to its default value. The hasU8Mid()
     * method will return false.
     */
    inline void clearU8Mid();

    /**
     * Checks whether the field "u8Mid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Mid()). Otherwise it will return false.
     */
    inline bool hasU8Mid () const;

    /**
     * Returns the value of the member "u8Mid".
     *
     * Mid (= Minor) version number.
     *
     * @return The value of the field "u8Mid"
     */
    inline uint8 getU8Mid () const;

    /**
     * Sets the value of the member "u8Mid".
     *
     * Mid (= Minor) version number.
     *
     * @param u8Mid The value which will be set
     */
    inline void setU8Mid (uint8 u8Mid_);

    // API of field "u8Lower"

    static const int kU8Lower = 2;

    /**
     * Clears the field "u8Lower".
     *
     * The field will be set to its default value. The hasU8Lower()
     * method will return false.
     */
    inline void clearU8Lower();

    /**
     * Checks whether the field "u8Lower" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Lower()). Otherwise it will return false.
     */
    inline bool hasU8Lower () const;

    /**
     * Returns the value of the member "u8Lower".
     *
     * Lower (= Patch) version number.
     *
     * @return The value of the field "u8Lower"
     */
    inline uint8 getU8Lower () const;

    /**
     * Sets the value of the member "u8Lower".
     *
     * Lower (= Patch) version number.
     *
     * @param u8Lower The value which will be set
     */
    inline void setU8Lower (uint8 u8Lower_);

    static const T_TCU_VersionInfo &getDefaultInstance();

private:

    inline void set_has_u8Upper ();

    inline void clear_has_u8Upper ();

    inline void set_has_u8Mid ();

    inline void clear_has_u8Mid ();

    inline void set_has_u8Lower ();

    inline void clear_has_u8Lower ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _u8Upper;

    uint8 _u8Mid;

    uint8 _u8Lower;

};

/**
 * Record type containing date time information.
 */
class T_TCU_Date_Time {
public:

    /**
     * Default constructor
     */
    inline  T_TCU_Date_Time ();

    /**
     * Copy constructor
     */
    inline  T_TCU_Date_Time (const T_TCU_Date_Time &rhs);

    /**
     * All fields constructor
     */
    inline  T_TCU_Date_Time (uint16 u16Year_, uint8 u8Month_, uint8 u8Day_, uint8 u8Hour_, uint8 u8Minute_, uint8 u8Second_, uint8 u8Reserve_);

    /**
     * Destructor
     */
    inline  ~T_TCU_Date_Time();

    /**
     * Assignment operator
     */
    inline T_TCU_Date_Time& operator = (const T_TCU_Date_Time& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TCU_Date_Time& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TCU_Date_Time& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TCU_Date_Time& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TCU_Date_Time& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16Year"

    static const int kU16Year = 0;

    /**
     * Clears the field "u16Year".
     *
     * The field will be set to its default value. The hasU16Year()
     * method will return false.
     */
    inline void clearU16Year();

    /**
     * Checks whether the field "u16Year" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16Year()). Otherwise it will return false.
     */
    inline bool hasU16Year () const;

    /**
     * Returns the value of the member "u16Year".
     *
     * Year
     *
     * @return The value of the field "u16Year"
     */
    inline uint16 getU16Year () const;

    /**
     * Sets the value of the member "u16Year".
     *
     * Year
     *
     * @param u16Year The value which will be set
     */
    inline void setU16Year (uint16 u16Year_);

    // API of field "u8Month"

    static const int kU8Month = 1;

    /**
     * Clears the field "u8Month".
     *
     * The field will be set to its default value. The hasU8Month()
     * method will return false.
     */
    inline void clearU8Month();

    /**
     * Checks whether the field "u8Month" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Month()). Otherwise it will return false.
     */
    inline bool hasU8Month () const;

    /**
     * Returns the value of the member "u8Month".
     *
     * Month
     *
     * @return The value of the field "u8Month"
     */
    inline uint8 getU8Month () const;

    /**
     * Sets the value of the member "u8Month".
     *
     * Month
     *
     * @param u8Month The value which will be set
     */
    inline void setU8Month (uint8 u8Month_);

    // API of field "u8Day"

    static const int kU8Day = 2;

    /**
     * Clears the field "u8Day".
     *
     * The field will be set to its default value. The hasU8Day()
     * method will return false.
     */
    inline void clearU8Day();

    /**
     * Checks whether the field "u8Day" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Day()). Otherwise it will return false.
     */
    inline bool hasU8Day () const;

    /**
     * Returns the value of the member "u8Day".
     *
     * Day
     *
     * @return The value of the field "u8Day"
     */
    inline uint8 getU8Day () const;

    /**
     * Sets the value of the member "u8Day".
     *
     * Day
     *
     * @param u8Day The value which will be set
     */
    inline void setU8Day (uint8 u8Day_);

    // API of field "u8Hour"

    static const int kU8Hour = 3;

    /**
     * Clears the field "u8Hour".
     *
     * The field will be set to its default value. The hasU8Hour()
     * method will return false.
     */
    inline void clearU8Hour();

    /**
     * Checks whether the field "u8Hour" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Hour()). Otherwise it will return false.
     */
    inline bool hasU8Hour () const;

    /**
     * Returns the value of the member "u8Hour".
     *
     * Hour
     *
     * @return The value of the field "u8Hour"
     */
    inline uint8 getU8Hour () const;

    /**
     * Sets the value of the member "u8Hour".
     *
     * Hour
     *
     * @param u8Hour The value which will be set
     */
    inline void setU8Hour (uint8 u8Hour_);

    // API of field "u8Minute"

    static const int kU8Minute = 4;

    /**
     * Clears the field "u8Minute".
     *
     * The field will be set to its default value. The hasU8Minute()
     * method will return false.
     */
    inline void clearU8Minute();

    /**
     * Checks whether the field "u8Minute" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Minute()). Otherwise it will return false.
     */
    inline bool hasU8Minute () const;

    /**
     * Returns the value of the member "u8Minute".
     *
     * Minute
     *
     * @return The value of the field "u8Minute"
     */
    inline uint8 getU8Minute () const;

    /**
     * Sets the value of the member "u8Minute".
     *
     * Minute
     *
     * @param u8Minute The value which will be set
     */
    inline void setU8Minute (uint8 u8Minute_);

    // API of field "u8Second"

    static const int kU8Second = 5;

    /**
     * Clears the field "u8Second".
     *
     * The field will be set to its default value. The hasU8Second()
     * method will return false.
     */
    inline void clearU8Second();

    /**
     * Checks whether the field "u8Second" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Second()). Otherwise it will return false.
     */
    inline bool hasU8Second () const;

    /**
     * Returns the value of the member "u8Second".
     *
     * Second
     *
     * @return The value of the field "u8Second"
     */
    inline uint8 getU8Second () const;

    /**
     * Sets the value of the member "u8Second".
     *
     * Second
     *
     * @param u8Second The value which will be set
     */
    inline void setU8Second (uint8 u8Second_);

    // API of field "u8Reserve"

    static const int kU8Reserve = 6;

    /**
     * Clears the field "u8Reserve".
     *
     * The field will be set to its default value. The hasU8Reserve()
     * method will return false.
     */
    inline void clearU8Reserve();

    /**
     * Checks whether the field "u8Reserve" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Reserve()). Otherwise it will return false.
     */
    inline bool hasU8Reserve () const;

    /**
     * Returns the value of the member "u8Reserve".
     *
     * Reserve
     *
     * @return The value of the field "u8Reserve"
     */
    inline uint8 getU8Reserve () const;

    /**
     * Sets the value of the member "u8Reserve".
     *
     * Reserve
     *
     * @param u8Reserve The value which will be set
     */
    inline void setU8Reserve (uint8 u8Reserve_);

    static const T_TCU_Date_Time &getDefaultInstance();

private:

    inline void set_has_u16Year ();

    inline void clear_has_u16Year ();

    inline void set_has_u8Month ();

    inline void clear_has_u8Month ();

    inline void set_has_u8Day ();

    inline void clear_has_u8Day ();

    inline void set_has_u8Hour ();

    inline void clear_has_u8Hour ();

    inline void set_has_u8Minute ();

    inline void clear_has_u8Minute ();

    inline void set_has_u8Second ();

    inline void clear_has_u8Second ();

    inline void set_has_u8Reserve ();

    inline void clear_has_u8Reserve ();

    uint32 _has_bits_[ (7 + 31) / 32];

    uint16 _u16Year;

    uint8 _u8Month;

    uint8 _u8Day;

    uint8 _u8Hour;

    uint8 _u8Minute;

    uint8 _u8Second;

    uint8 _u8Reserve;

};

/**
 * Enumeration type defining the Distance Unit
 */
class T_TCU_Altitude {
public:

    /**
     * Default constructor
     */
    inline  T_TCU_Altitude ();

    /**
     * Copy constructor
     */
    inline  T_TCU_Altitude (const T_TCU_Altitude &rhs);

    /**
     * All fields constructor
     */
    inline  T_TCU_Altitude (T_e8_TCU_Sign e8Sign_, uint16 u16Value_);

    /**
     * Destructor
     */
    inline  ~T_TCU_Altitude();

    /**
     * Assignment operator
     */
    inline T_TCU_Altitude& operator = (const T_TCU_Altitude& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TCU_Altitude& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TCU_Altitude& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TCU_Altitude& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TCU_Altitude& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Sign"

    static const int kE8Sign = 0;

    /**
     * Clears the field "e8Sign".
     *
     * The field will be set to its default value. The hasE8Sign()
     * method will return false.
     */
    inline void clearE8Sign();

    /**
     * Checks whether the field "e8Sign" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Sign()). Otherwise it will return false.
     */
    inline bool hasE8Sign () const;

    /**
     * Returns the value of the member "e8Sign".
     *
     * 0(false)->Plus 1(true)->Minus
     *
     * @return The value of the field "e8Sign"
     */
    inline T_e8_TCU_Sign getE8Sign () const;

    /**
     * Sets the value of the member "e8Sign".
     *
     * 0(false)->Plus 1(true)->Minus
     *
     * @param e8Sign The value which will be set
     */
    inline void setE8Sign (T_e8_TCU_Sign e8Sign_);

    // API of field "u16Value"

    static const int kU16Value = 1;

    /**
     * Clears the field "u16Value".
     *
     * The field will be set to its default value. The hasU16Value()
     * method will return false.
     */
    inline void clearU16Value();

    /**
     * Checks whether the field "u16Value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16Value()). Otherwise it will return false.
     */
    inline bool hasU16Value () const;

    /**
     * Returns the value of the member "u16Value".
     *
     * Altitude value
     *
     * @return The value of the field "u16Value"
     */
    inline uint16 getU16Value () const;

    /**
     * Sets the value of the member "u16Value".
     *
     * Altitude value
     *
     * @param u16Value The value which will be set
     */
    inline void setU16Value (uint16 u16Value_);

    static const T_TCU_Altitude &getDefaultInstance();

private:

    inline void set_has_e8Sign ();

    inline void clear_has_e8Sign ();

    inline void set_has_u16Value ();

    inline void clear_has_u16Value ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_TCU_Sign _e8Sign;

    uint16 _u16Value;

};

/**
 * Location Info
 */
class T_TCU_LocationInfo {
public:

    /**
     * Default constructor
     */
    inline  T_TCU_LocationInfo ();

    /**
     * Copy constructor
     */
    inline  T_TCU_LocationInfo (const T_TCU_LocationInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_TCU_LocationInfo (T_e8_TCU_LocationType e8LocationType_, T_e8_TCU_LatitudeMode e8Latitudemode_, T_e8_TCU_LongitudeMode e8LongitudeMode_, uint8 u8LatitudeDEG_, uint8 u8LatitudeMIN_, uint16 u16LatitudeSEC_, uint8 u8LongitudeDEG_, uint8 u8LongitudeMIN_, uint16 u16LongitudeSEC_, const T_TCU_Altitude& Altitude_, uint8 u8SatelliteNumber_, T_e8_TCU_Home e8Home_, uint8 u8Reserve_);

    /**
     * Destructor
     */
    inline  ~T_TCU_LocationInfo();

    /**
     * Assignment operator
     */
    inline T_TCU_LocationInfo& operator = (const T_TCU_LocationInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TCU_LocationInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TCU_LocationInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TCU_LocationInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TCU_LocationInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8LocationType"

    static const int kE8LocationType = 0;

    /**
     * Clears the field "e8LocationType".
     *
     * The field will be set to its default value. The hasE8LocationType()
     * method will return false.
     */
    inline void clearE8LocationType();

    /**
     * Checks whether the field "e8LocationType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8LocationType()). Otherwise it will return false.
     */
    inline bool hasE8LocationType () const;

    /**
     * Returns the value of the member "e8LocationType".
     *
     * Location Type
     *
     * @return The value of the field "e8LocationType"
     */
    inline T_e8_TCU_LocationType getE8LocationType () const;

    /**
     * Sets the value of the member "e8LocationType".
     *
     * Location Type
     *
     * @param e8LocationType The value which will be set
     */
    inline void setE8LocationType (T_e8_TCU_LocationType e8LocationType_);

    // API of field "e8Latitudemode"

    static const int kE8Latitudemode = 1;

    /**
     * Clears the field "e8Latitudemode".
     *
     * The field will be set to its default value. The hasE8Latitudemode()
     * method will return false.
     */
    inline void clearE8Latitudemode();

    /**
     * Checks whether the field "e8Latitudemode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Latitudemode()). Otherwise it will return false.
     */
    inline bool hasE8Latitudemode () const;

    /**
     * Returns the value of the member "e8Latitudemode".
     *
     * Latitude mode
     *
     * @return The value of the field "e8Latitudemode"
     */
    inline T_e8_TCU_LatitudeMode getE8Latitudemode () const;

    /**
     * Sets the value of the member "e8Latitudemode".
     *
     * Latitude mode
     *
     * @param e8Latitudemode The value which will be set
     */
    inline void setE8Latitudemode (T_e8_TCU_LatitudeMode e8Latitudemode_);

    // API of field "e8LongitudeMode"

    static const int kE8LongitudeMode = 2;

    /**
     * Clears the field "e8LongitudeMode".
     *
     * The field will be set to its default value. The hasE8LongitudeMode()
     * method will return false.
     */
    inline void clearE8LongitudeMode();

    /**
     * Checks whether the field "e8LongitudeMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8LongitudeMode()). Otherwise it will return false.
     */
    inline bool hasE8LongitudeMode () const;

    /**
     * Returns the value of the member "e8LongitudeMode".
     *
     * Logitude mode
     *
     * @return The value of the field "e8LongitudeMode"
     */
    inline T_e8_TCU_LongitudeMode getE8LongitudeMode () const;

    /**
     * Sets the value of the member "e8LongitudeMode".
     *
     * Logitude mode
     *
     * @param e8LongitudeMode The value which will be set
     */
    inline void setE8LongitudeMode (T_e8_TCU_LongitudeMode e8LongitudeMode_);

    // API of field "u8LatitudeDEG"

    static const int kU8LatitudeDEG = 3;

    /**
     * Clears the field "u8LatitudeDEG".
     *
     * The field will be set to its default value. The hasU8LatitudeDEG()
     * method will return false.
     */
    inline void clearU8LatitudeDEG();

    /**
     * Checks whether the field "u8LatitudeDEG" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8LatitudeDEG()). Otherwise it will return false.
     */
    inline bool hasU8LatitudeDEG () const;

    /**
     * Returns the value of the member "u8LatitudeDEG".
     *
     * Latitude degree
     *
     * @return The value of the field "u8LatitudeDEG"
     */
    inline uint8 getU8LatitudeDEG () const;

    /**
     * Sets the value of the member "u8LatitudeDEG".
     *
     * Latitude degree
     *
     * @param u8LatitudeDEG The value which will be set
     */
    inline void setU8LatitudeDEG (uint8 u8LatitudeDEG_);

    // API of field "u8LatitudeMIN"

    static const int kU8LatitudeMIN = 4;

    /**
     * Clears the field "u8LatitudeMIN".
     *
     * The field will be set to its default value. The hasU8LatitudeMIN()
     * method will return false.
     */
    inline void clearU8LatitudeMIN();

    /**
     * Checks whether the field "u8LatitudeMIN" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8LatitudeMIN()). Otherwise it will return false.
     */
    inline bool hasU8LatitudeMIN () const;

    /**
     * Returns the value of the member "u8LatitudeMIN".
     *
     * Latitude Minute
     *
     * @return The value of the field "u8LatitudeMIN"
     */
    inline uint8 getU8LatitudeMIN () const;

    /**
     * Sets the value of the member "u8LatitudeMIN".
     *
     * Latitude Minute
     *
     * @param u8LatitudeMIN The value which will be set
     */
    inline void setU8LatitudeMIN (uint8 u8LatitudeMIN_);

    // API of field "u16LatitudeSEC"

    static const int kU16LatitudeSEC = 5;

    /**
     * Clears the field "u16LatitudeSEC".
     *
     * The field will be set to its default value. The hasU16LatitudeSEC()
     * method will return false.
     */
    inline void clearU16LatitudeSEC();

    /**
     * Checks whether the field "u16LatitudeSEC" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16LatitudeSEC()). Otherwise it will return false.
     */
    inline bool hasU16LatitudeSEC () const;

    /**
     * Returns the value of the member "u16LatitudeSEC".
     *
     * Latitude Seconds
     *
     * @return The value of the field "u16LatitudeSEC"
     */
    inline uint16 getU16LatitudeSEC () const;

    /**
     * Sets the value of the member "u16LatitudeSEC".
     *
     * Latitude Seconds
     *
     * @param u16LatitudeSEC The value which will be set
     */
    inline void setU16LatitudeSEC (uint16 u16LatitudeSEC_);

    // API of field "u8LongitudeDEG"

    static const int kU8LongitudeDEG = 6;

    /**
     * Clears the field "u8LongitudeDEG".
     *
     * The field will be set to its default value. The hasU8LongitudeDEG()
     * method will return false.
     */
    inline void clearU8LongitudeDEG();

    /**
     * Checks whether the field "u8LongitudeDEG" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8LongitudeDEG()). Otherwise it will return false.
     */
    inline bool hasU8LongitudeDEG () const;

    /**
     * Returns the value of the member "u8LongitudeDEG".
     *
     * Longitude degree
     *
     * @return The value of the field "u8LongitudeDEG"
     */
    inline uint8 getU8LongitudeDEG () const;

    /**
     * Sets the value of the member "u8LongitudeDEG".
     *
     * Longitude degree
     *
     * @param u8LongitudeDEG The value which will be set
     */
    inline void setU8LongitudeDEG (uint8 u8LongitudeDEG_);

    // API of field "u8LongitudeMIN"

    static const int kU8LongitudeMIN = 7;

    /**
     * Clears the field "u8LongitudeMIN".
     *
     * The field will be set to its default value. The hasU8LongitudeMIN()
     * method will return false.
     */
    inline void clearU8LongitudeMIN();

    /**
     * Checks whether the field "u8LongitudeMIN" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8LongitudeMIN()). Otherwise it will return false.
     */
    inline bool hasU8LongitudeMIN () const;

    /**
     * Returns the value of the member "u8LongitudeMIN".
     *
     * Longitude Minute
     *
     * @return The value of the field "u8LongitudeMIN"
     */
    inline uint8 getU8LongitudeMIN () const;

    /**
     * Sets the value of the member "u8LongitudeMIN".
     *
     * Longitude Minute
     *
     * @param u8LongitudeMIN The value which will be set
     */
    inline void setU8LongitudeMIN (uint8 u8LongitudeMIN_);

    // API of field "u16LongitudeSEC"

    static const int kU16LongitudeSEC = 8;

    /**
     * Clears the field "u16LongitudeSEC".
     *
     * The field will be set to its default value. The hasU16LongitudeSEC()
     * method will return false.
     */
    inline void clearU16LongitudeSEC();

    /**
     * Checks whether the field "u16LongitudeSEC" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16LongitudeSEC()). Otherwise it will return false.
     */
    inline bool hasU16LongitudeSEC () const;

    /**
     * Returns the value of the member "u16LongitudeSEC".
     *
     * Longitude Seconds
     *
     * @return The value of the field "u16LongitudeSEC"
     */
    inline uint16 getU16LongitudeSEC () const;

    /**
     * Sets the value of the member "u16LongitudeSEC".
     *
     * Longitude Seconds
     *
     * @param u16LongitudeSEC The value which will be set
     */
    inline void setU16LongitudeSEC (uint16 u16LongitudeSEC_);

    // API of field "Altitude"

    static const int kAltitude = 9;

    /**
     * Clears the field "Altitude".
     *
     * The field will be set to its default value. The hasAltitude()
     * method will return false.
     */
    inline void clearAltitude();

    /**
     * Checks whether the field "Altitude" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAltitude()). Otherwise it will return false.
     */
    inline bool hasAltitude () const;

    /**
     * Returns the value of the member "Altitude".
     *
     * Altitude
     *
     * @return The value of the field "Altitude"
     */
    inline const T_TCU_Altitude& getAltitude () const;

    /**
     * Retrieves the value of the field "Altitude" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Altitude".
     */
    inline T_TCU_Altitude& getAltitudeMutable ();

    /**
     * Sets the value of the member "Altitude".
     *
     * Altitude
     *
     * @param Altitude The value which will be set
     */
    inline void setAltitude (const T_TCU_Altitude& Altitude_);

    // API of field "u8SatelliteNumber"

    static const int kU8SatelliteNumber = 10;

    /**
     * Clears the field "u8SatelliteNumber".
     *
     * The field will be set to its default value. The hasU8SatelliteNumber()
     * method will return false.
     */
    inline void clearU8SatelliteNumber();

    /**
     * Checks whether the field "u8SatelliteNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SatelliteNumber()). Otherwise it will return false.
     */
    inline bool hasU8SatelliteNumber () const;

    /**
     * Returns the value of the member "u8SatelliteNumber".
     *
     * Satellite Number
     *
     * @return The value of the field "u8SatelliteNumber"
     */
    inline uint8 getU8SatelliteNumber () const;

    /**
     * Sets the value of the member "u8SatelliteNumber".
     *
     * Satellite Number
     *
     * @param u8SatelliteNumber The value which will be set
     */
    inline void setU8SatelliteNumber (uint8 u8SatelliteNumber_);

    // API of field "e8Home"

    static const int kE8Home = 11;

    /**
     * Clears the field "e8Home".
     *
     * The field will be set to its default value. The hasE8Home()
     * method will return false.
     */
    inline void clearE8Home();

    /**
     * Checks whether the field "e8Home" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Home()). Otherwise it will return false.
     */
    inline bool hasE8Home () const;

    /**
     * Returns the value of the member "e8Home".
     *
     * Home
     *
     * @return The value of the field "e8Home"
     */
    inline T_e8_TCU_Home getE8Home () const;

    /**
     * Sets the value of the member "e8Home".
     *
     * Home
     *
     * @param e8Home The value which will be set
     */
    inline void setE8Home (T_e8_TCU_Home e8Home_);

    // API of field "u8Reserve"

    static const int kU8Reserve = 12;

    /**
     * Clears the field "u8Reserve".
     *
     * The field will be set to its default value. The hasU8Reserve()
     * method will return false.
     */
    inline void clearU8Reserve();

    /**
     * Checks whether the field "u8Reserve" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Reserve()). Otherwise it will return false.
     */
    inline bool hasU8Reserve () const;

    /**
     * Returns the value of the member "u8Reserve".
     *
     * Reserve
     *
     * @return The value of the field "u8Reserve"
     */
    inline uint8 getU8Reserve () const;

    /**
     * Sets the value of the member "u8Reserve".
     *
     * Reserve
     *
     * @param u8Reserve The value which will be set
     */
    inline void setU8Reserve (uint8 u8Reserve_);

    static const T_TCU_LocationInfo &getDefaultInstance();

private:

    inline void set_has_e8LocationType ();

    inline void clear_has_e8LocationType ();

    inline void set_has_e8Latitudemode ();

    inline void clear_has_e8Latitudemode ();

    inline void set_has_e8LongitudeMode ();

    inline void clear_has_e8LongitudeMode ();

    inline void set_has_u8LatitudeDEG ();

    inline void clear_has_u8LatitudeDEG ();

    inline void set_has_u8LatitudeMIN ();

    inline void clear_has_u8LatitudeMIN ();

    inline void set_has_u16LatitudeSEC ();

    inline void clear_has_u16LatitudeSEC ();

    inline void set_has_u8LongitudeDEG ();

    inline void clear_has_u8LongitudeDEG ();

    inline void set_has_u8LongitudeMIN ();

    inline void clear_has_u8LongitudeMIN ();

    inline void set_has_u16LongitudeSEC ();

    inline void clear_has_u16LongitudeSEC ();

    inline void set_has_Altitude ();

    inline void clear_has_Altitude ();

    inline void set_has_u8SatelliteNumber ();

    inline void clear_has_u8SatelliteNumber ();

    inline void set_has_e8Home ();

    inline void clear_has_e8Home ();

    inline void set_has_u8Reserve ();

    inline void clear_has_u8Reserve ();

    uint32 _has_bits_[ (13 + 31) / 32];

    T_e8_TCU_LocationType _e8LocationType;

    T_e8_TCU_LatitudeMode _e8Latitudemode;

    T_e8_TCU_LongitudeMode _e8LongitudeMode;

    uint8 _u8LatitudeDEG;

    uint8 _u8LatitudeMIN;

    uint16 _u16LatitudeSEC;

    uint8 _u8LongitudeDEG;

    uint8 _u8LongitudeMIN;

    uint16 _u16LongitudeSEC;

    T_TCU_Altitude _Altitude;

    uint8 _u8SatelliteNumber;

    T_e8_TCU_Home _e8Home;

    uint8 _u8Reserve;

};

/**
 * Record type containing Navi information.
 */
class T_TCU_Navi_Info {
public:

    /**
     * Default constructor
     */
    inline  T_TCU_Navi_Info ();

    /**
     * Copy constructor
     */
    inline  T_TCU_Navi_Info (const T_TCU_Navi_Info &rhs);

    /**
     * All fields constructor
     */
    inline  T_TCU_Navi_Info (const T_TCU_LocationInfo& LocationInfo_, const T_TCU_Date_Time& rDateTime_, uint16 u16VehicleHeading_, uint8 u8TimeZone_);

    /**
     * Destructor
     */
    inline  ~T_TCU_Navi_Info();

    /**
     * Assignment operator
     */
    inline T_TCU_Navi_Info& operator = (const T_TCU_Navi_Info& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TCU_Navi_Info& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TCU_Navi_Info& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TCU_Navi_Info& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TCU_Navi_Info& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "LocationInfo"

    static const int kLocationInfo = 0;

    /**
     * Clears the field "LocationInfo".
     *
     * The field will be set to its default value. The hasLocationInfo()
     * method will return false.
     */
    inline void clearLocationInfo();

    /**
     * Checks whether the field "LocationInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLocationInfo()). Otherwise it will return false.
     */
    inline bool hasLocationInfo () const;

    /**
     * Returns the value of the member "LocationInfo".
     *
     * Location information of Navi
     *
     * @return The value of the field "LocationInfo"
     */
    inline const T_TCU_LocationInfo& getLocationInfo () const;

    /**
     * Retrieves the value of the field "LocationInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "LocationInfo".
     */
    inline T_TCU_LocationInfo& getLocationInfoMutable ();

    /**
     * Sets the value of the member "LocationInfo".
     *
     * Location information of Navi
     *
     * @param LocationInfo The value which will be set
     */
    inline void setLocationInfo (const T_TCU_LocationInfo& LocationInfo_);

    // API of field "rDateTime"

    static const int kRDateTime = 1;

    /**
     * Clears the field "rDateTime".
     *
     * The field will be set to its default value. The hasRDateTime()
     * method will return false.
     */
    inline void clearRDateTime();

    /**
     * Checks whether the field "rDateTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRDateTime()). Otherwise it will return false.
     */
    inline bool hasRDateTime () const;

    /**
     * Returns the value of the member "rDateTime".
     *
     * Date and Time information
     *
     * @return The value of the field "rDateTime"
     */
    inline const T_TCU_Date_Time& getRDateTime () const;

    /**
     * Retrieves the value of the field "rDateTime" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rDateTime".
     */
    inline T_TCU_Date_Time& getRDateTimeMutable ();

    /**
     * Sets the value of the member "rDateTime".
     *
     * Date and Time information
     *
     * @param rDateTime The value which will be set
     */
    inline void setRDateTime (const T_TCU_Date_Time& rDateTime_);

    // API of field "u16VehicleHeading"

    static const int kU16VehicleHeading = 2;

    /**
     * Clears the field "u16VehicleHeading".
     *
     * The field will be set to its default value. The hasU16VehicleHeading()
     * method will return false.
     */
    inline void clearU16VehicleHeading();

    /**
     * Checks whether the field "u16VehicleHeading" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16VehicleHeading()). Otherwise it will return false.
     */
    inline bool hasU16VehicleHeading () const;

    /**
     * Returns the value of the member "u16VehicleHeading".
     *
     * Vehicle Heading information
     *
     * @return The value of the field "u16VehicleHeading"
     */
    inline uint16 getU16VehicleHeading () const;

    /**
     * Sets the value of the member "u16VehicleHeading".
     *
     * Vehicle Heading information
     *
     * @param u16VehicleHeading The value which will be set
     */
    inline void setU16VehicleHeading (uint16 u16VehicleHeading_);

    // API of field "u8TimeZone"

    static const int kU8TimeZone = 3;

    /**
     * Clears the field "u8TimeZone".
     *
     * The field will be set to its default value. The hasU8TimeZone()
     * method will return false.
     */
    inline void clearU8TimeZone();

    /**
     * Checks whether the field "u8TimeZone" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8TimeZone()). Otherwise it will return false.
     */
    inline bool hasU8TimeZone () const;

    /**
     * Returns the value of the member "u8TimeZone".
     *
     * Time Zone information
     *
     * @return The value of the field "u8TimeZone"
     */
    inline uint8 getU8TimeZone () const;

    /**
     * Sets the value of the member "u8TimeZone".
     *
     * Time Zone information
     *
     * @param u8TimeZone The value which will be set
     */
    inline void setU8TimeZone (uint8 u8TimeZone_);

    static const T_TCU_Navi_Info &getDefaultInstance();

private:

    inline void set_has_LocationInfo ();

    inline void clear_has_LocationInfo ();

    inline void set_has_rDateTime ();

    inline void clear_has_rDateTime ();

    inline void set_has_u16VehicleHeading ();

    inline void clear_has_u16VehicleHeading ();

    inline void set_has_u8TimeZone ();

    inline void clear_has_u8TimeZone ();

    uint32 _has_bits_[ (4 + 31) / 32];

    T_TCU_LocationInfo _LocationInfo;

    T_TCU_Date_Time _rDateTime;

    uint16 _u16VehicleHeading;

    uint8 _u8TimeZone;

};

/**
 * Record type containing ECO score information.
 */
class T_TCU_Score_Info {
public:

    /**
     * Default constructor
     */
    inline  T_TCU_Score_Info ();

    /**
     * Copy constructor
     */
    inline  T_TCU_Score_Info (const T_TCU_Score_Info &rhs);

    /**
     * All fields constructor
     */
    inline  T_TCU_Score_Info (uint8 u8ECOScore_, uint8 u8StartScore_, uint8 u8CruiseScore_, uint8 u8SlowdownScore_);

    /**
     * Destructor
     */
    inline  ~T_TCU_Score_Info();

    /**
     * Assignment operator
     */
    inline T_TCU_Score_Info& operator = (const T_TCU_Score_Info& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TCU_Score_Info& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TCU_Score_Info& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TCU_Score_Info& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TCU_Score_Info& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8ECOScore"

    static const int kU8ECOScore = 0;

    /**
     * Clears the field "u8ECOScore".
     *
     * The field will be set to its default value. The hasU8ECOScore()
     * method will return false.
     */
    inline void clearU8ECOScore();

    /**
     * Checks whether the field "u8ECOScore" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8ECOScore()). Otherwise it will return false.
     */
    inline bool hasU8ECOScore () const;

    /**
     * Returns the value of the member "u8ECOScore".
     *
     * ECO Score
     *
     * @return The value of the field "u8ECOScore"
     */
    inline uint8 getU8ECOScore () const;

    /**
     * Sets the value of the member "u8ECOScore".
     *
     * ECO Score
     *
     * @param u8ECOScore The value which will be set
     */
    inline void setU8ECOScore (uint8 u8ECOScore_);

    // API of field "u8StartScore"

    static const int kU8StartScore = 1;

    /**
     * Clears the field "u8StartScore".
     *
     * The field will be set to its default value. The hasU8StartScore()
     * method will return false.
     */
    inline void clearU8StartScore();

    /**
     * Checks whether the field "u8StartScore" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8StartScore()). Otherwise it will return false.
     */
    inline bool hasU8StartScore () const;

    /**
     * Returns the value of the member "u8StartScore".
     *
     * Start Score
     *
     * @return The value of the field "u8StartScore"
     */
    inline uint8 getU8StartScore () const;

    /**
     * Sets the value of the member "u8StartScore".
     *
     * Start Score
     *
     * @param u8StartScore The value which will be set
     */
    inline void setU8StartScore (uint8 u8StartScore_);

    // API of field "u8CruiseScore"

    static const int kU8CruiseScore = 2;

    /**
     * Clears the field "u8CruiseScore".
     *
     * The field will be set to its default value. The hasU8CruiseScore()
     * method will return false.
     */
    inline void clearU8CruiseScore();

    /**
     * Checks whether the field "u8CruiseScore" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8CruiseScore()). Otherwise it will return false.
     */
    inline bool hasU8CruiseScore () const;

    /**
     * Returns the value of the member "u8CruiseScore".
     *
     * Cruise Score
     *
     * @return The value of the field "u8CruiseScore"
     */
    inline uint8 getU8CruiseScore () const;

    /**
     * Sets the value of the member "u8CruiseScore".
     *
     * Cruise Score
     *
     * @param u8CruiseScore The value which will be set
     */
    inline void setU8CruiseScore (uint8 u8CruiseScore_);

    // API of field "u8SlowdownScore"

    static const int kU8SlowdownScore = 3;

    /**
     * Clears the field "u8SlowdownScore".
     *
     * The field will be set to its default value. The hasU8SlowdownScore()
     * method will return false.
     */
    inline void clearU8SlowdownScore();

    /**
     * Checks whether the field "u8SlowdownScore" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SlowdownScore()). Otherwise it will return false.
     */
    inline bool hasU8SlowdownScore () const;

    /**
     * Returns the value of the member "u8SlowdownScore".
     *
     * Slowdown Score
     *
     * @return The value of the field "u8SlowdownScore"
     */
    inline uint8 getU8SlowdownScore () const;

    /**
     * Sets the value of the member "u8SlowdownScore".
     *
     * Slowdown Score
     *
     * @param u8SlowdownScore The value which will be set
     */
    inline void setU8SlowdownScore (uint8 u8SlowdownScore_);

    static const T_TCU_Score_Info &getDefaultInstance();

private:

    inline void set_has_u8ECOScore ();

    inline void clear_has_u8ECOScore ();

    inline void set_has_u8StartScore ();

    inline void clear_has_u8StartScore ();

    inline void set_has_u8CruiseScore ();

    inline void clear_has_u8CruiseScore ();

    inline void set_has_u8SlowdownScore ();

    inline void clear_has_u8SlowdownScore ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint8 _u8ECOScore;

    uint8 _u8StartScore;

    uint8 _u8CruiseScore;

    uint8 _u8SlowdownScore;

};

/**
 * Information to classify road type..
 */
class T_TCU_Navi_Road_classification {
public:

    /**
     * Default constructor
     */
    inline  T_TCU_Navi_Road_classification ();

    /**
     * Copy constructor
     */
    inline  T_TCU_Navi_Road_classification (const T_TCU_Navi_Road_classification &rhs);

    /**
     * All fields constructor
     */
    inline  T_TCU_Navi_Road_classification (uint8 u8TableType_, uint8 u8RoadType_);

    /**
     * Destructor
     */
    inline  ~T_TCU_Navi_Road_classification();

    /**
     * Assignment operator
     */
    inline T_TCU_Navi_Road_classification& operator = (const T_TCU_Navi_Road_classification& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TCU_Navi_Road_classification& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TCU_Navi_Road_classification& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TCU_Navi_Road_classification& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TCU_Navi_Road_classification& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8TableType"

    static const int kU8TableType = 0;

    /**
     * Clears the field "u8TableType".
     *
     * The field will be set to its default value. The hasU8TableType()
     * method will return false.
     */
    inline void clearU8TableType();

    /**
     * Checks whether the field "u8TableType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8TableType()). Otherwise it will return false.
     */
    inline bool hasU8TableType () const;

    /**
     * Returns the value of the member "u8TableType".
     *
     * Table Type Information
     *
     * @return The value of the field "u8TableType"
     */
    inline uint8 getU8TableType () const;

    /**
     * Sets the value of the member "u8TableType".
     *
     * Table Type Information
     *
     * @param u8TableType The value which will be set
     */
    inline void setU8TableType (uint8 u8TableType_);

    // API of field "u8RoadType"

    static const int kU8RoadType = 1;

    /**
     * Clears the field "u8RoadType".
     *
     * The field will be set to its default value. The hasU8RoadType()
     * method will return false.
     */
    inline void clearU8RoadType();

    /**
     * Checks whether the field "u8RoadType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8RoadType()). Otherwise it will return false.
     */
    inline bool hasU8RoadType () const;

    /**
     * Returns the value of the member "u8RoadType".
     *
     * Road type information
     *
     * @return The value of the field "u8RoadType"
     */
    inline uint8 getU8RoadType () const;

    /**
     * Sets the value of the member "u8RoadType".
     *
     * Road type information
     *
     * @param u8RoadType The value which will be set
     */
    inline void setU8RoadType (uint8 u8RoadType_);

    static const T_TCU_Navi_Road_classification &getDefaultInstance();

private:

    inline void set_has_u8TableType ();

    inline void clear_has_u8TableType ();

    inline void set_has_u8RoadType ();

    inline void clear_has_u8RoadType ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8TableType;

    uint8 _u8RoadType;

};

/**
 * Record type containing Probe Vehicle information.
 */
class T_TCU_Probe_Vehicle_Info {
public:

    /**
     * Default constructor
     */
    inline  T_TCU_Probe_Vehicle_Info ();

    /**
     * Copy constructor
     */
    inline  T_TCU_Probe_Vehicle_Info (const T_TCU_Probe_Vehicle_Info &rhs);

    /**
     * All fields constructor
     */
    inline  T_TCU_Probe_Vehicle_Info (uint16 u16NaviVehicleSpeed_, uint32 u32NaviDrivingDistance_, const T_TCU_Navi_Road_classification& NaviRoadClassification_);

    /**
     * Destructor
     */
    inline  ~T_TCU_Probe_Vehicle_Info();

    /**
     * Assignment operator
     */
    inline T_TCU_Probe_Vehicle_Info& operator = (const T_TCU_Probe_Vehicle_Info& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TCU_Probe_Vehicle_Info& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TCU_Probe_Vehicle_Info& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TCU_Probe_Vehicle_Info& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TCU_Probe_Vehicle_Info& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16NaviVehicleSpeed"

    static const int kU16NaviVehicleSpeed = 0;

    /**
     * Clears the field "u16NaviVehicleSpeed".
     *
     * The field will be set to its default value. The hasU16NaviVehicleSpeed()
     * method will return false.
     */
    inline void clearU16NaviVehicleSpeed();

    /**
     * Checks whether the field "u16NaviVehicleSpeed" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16NaviVehicleSpeed()). Otherwise it will return false.
     */
    inline bool hasU16NaviVehicleSpeed () const;

    /**
     * Returns the value of the member "u16NaviVehicleSpeed".
     *
     * Navi Vehicle Speed
     *
     * @return The value of the field "u16NaviVehicleSpeed"
     */
    inline uint16 getU16NaviVehicleSpeed () const;

    /**
     * Sets the value of the member "u16NaviVehicleSpeed".
     *
     * Navi Vehicle Speed
     *
     * @param u16NaviVehicleSpeed The value which will be set
     */
    inline void setU16NaviVehicleSpeed (uint16 u16NaviVehicleSpeed_);

    // API of field "u32NaviDrivingDistance"

    static const int kU32NaviDrivingDistance = 1;

    /**
     * Clears the field "u32NaviDrivingDistance".
     *
     * The field will be set to its default value. The hasU32NaviDrivingDistance()
     * method will return false.
     */
    inline void clearU32NaviDrivingDistance();

    /**
     * Checks whether the field "u32NaviDrivingDistance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32NaviDrivingDistance()). Otherwise it will return false.
     */
    inline bool hasU32NaviDrivingDistance () const;

    /**
     * Returns the value of the member "u32NaviDrivingDistance".
     *
     * Navi Driving Distance
     *
     * @return The value of the field "u32NaviDrivingDistance"
     */
    inline uint32 getU32NaviDrivingDistance () const;

    /**
     * Sets the value of the member "u32NaviDrivingDistance".
     *
     * Navi Driving Distance
     *
     * @param u32NaviDrivingDistance The value which will be set
     */
    inline void setU32NaviDrivingDistance (uint32 u32NaviDrivingDistance_);

    // API of field "NaviRoadClassification"

    static const int kNaviRoadClassification = 2;

    /**
     * Clears the field "NaviRoadClassification".
     *
     * The field will be set to its default value. The hasNaviRoadClassification()
     * method will return false.
     */
    inline void clearNaviRoadClassification();

    /**
     * Checks whether the field "NaviRoadClassification" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNaviRoadClassification()). Otherwise it will return false.
     */
    inline bool hasNaviRoadClassification () const;

    /**
     * Returns the value of the member "NaviRoadClassification".
     *
     * Navi Road Classification
     *
     * @return The value of the field "NaviRoadClassification"
     */
    inline const T_TCU_Navi_Road_classification& getNaviRoadClassification () const;

    /**
     * Retrieves the value of the field "NaviRoadClassification" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "NaviRoadClassification".
     */
    inline T_TCU_Navi_Road_classification& getNaviRoadClassificationMutable ();

    /**
     * Sets the value of the member "NaviRoadClassification".
     *
     * Navi Road Classification
     *
     * @param NaviRoadClassification The value which will be set
     */
    inline void setNaviRoadClassification (const T_TCU_Navi_Road_classification& NaviRoadClassification_);

    static const T_TCU_Probe_Vehicle_Info &getDefaultInstance();

private:

    inline void set_has_u16NaviVehicleSpeed ();

    inline void clear_has_u16NaviVehicleSpeed ();

    inline void set_has_u32NaviDrivingDistance ();

    inline void clear_has_u32NaviDrivingDistance ();

    inline void set_has_NaviRoadClassification ();

    inline void clear_has_NaviRoadClassification ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint16 _u16NaviVehicleSpeed;

    uint32 _u32NaviDrivingDistance;

    T_TCU_Navi_Road_classification _NaviRoadClassification;

};

/**
 * Record type containing Distance values.
 */
class T_TCU_Distance_Value {
public:

    /**
     * Default constructor
     */
    inline  T_TCU_Distance_Value ();

    /**
     * Copy constructor
     */
    inline  T_TCU_Distance_Value (const T_TCU_Distance_Value &rhs);

    /**
     * All fields constructor
     */
    inline  T_TCU_Distance_Value (uint16 u16OilFilter_, uint16 u16Oil_, uint16 u16Tire_, uint16 u16User_, uint16 u16Battery_, uint16 u16ACFilter_, uint16 u16Reserve_);

    /**
     * Destructor
     */
    inline  ~T_TCU_Distance_Value();

    /**
     * Assignment operator
     */
    inline T_TCU_Distance_Value& operator = (const T_TCU_Distance_Value& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TCU_Distance_Value& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TCU_Distance_Value& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TCU_Distance_Value& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TCU_Distance_Value& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16OilFilter"

    static const int kU16OilFilter = 0;

    /**
     * Clears the field "u16OilFilter".
     *
     * The field will be set to its default value. The hasU16OilFilter()
     * method will return false.
     */
    inline void clearU16OilFilter();

    /**
     * Checks whether the field "u16OilFilter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16OilFilter()). Otherwise it will return false.
     */
    inline bool hasU16OilFilter () const;

    /**
     * Returns the value of the member "u16OilFilter".
     *
     * Oil Filter
     *
     * @return The value of the field "u16OilFilter"
     */
    inline uint16 getU16OilFilter () const;

    /**
     * Sets the value of the member "u16OilFilter".
     *
     * Oil Filter
     *
     * @param u16OilFilter The value which will be set
     */
    inline void setU16OilFilter (uint16 u16OilFilter_);

    // API of field "u16Oil"

    static const int kU16Oil = 1;

    /**
     * Clears the field "u16Oil".
     *
     * The field will be set to its default value. The hasU16Oil()
     * method will return false.
     */
    inline void clearU16Oil();

    /**
     * Checks whether the field "u16Oil" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16Oil()). Otherwise it will return false.
     */
    inline bool hasU16Oil () const;

    /**
     * Returns the value of the member "u16Oil".
     *
     * Oil
     *
     * @return The value of the field "u16Oil"
     */
    inline uint16 getU16Oil () const;

    /**
     * Sets the value of the member "u16Oil".
     *
     * Oil
     *
     * @param u16Oil The value which will be set
     */
    inline void setU16Oil (uint16 u16Oil_);

    // API of field "u16Tire"

    static const int kU16Tire = 2;

    /**
     * Clears the field "u16Tire".
     *
     * The field will be set to its default value. The hasU16Tire()
     * method will return false.
     */
    inline void clearU16Tire();

    /**
     * Checks whether the field "u16Tire" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16Tire()). Otherwise it will return false.
     */
    inline bool hasU16Tire () const;

    /**
     * Returns the value of the member "u16Tire".
     *
     * Tire
     *
     * @return The value of the field "u16Tire"
     */
    inline uint16 getU16Tire () const;

    /**
     * Sets the value of the member "u16Tire".
     *
     * Tire
     *
     * @param u16Tire The value which will be set
     */
    inline void setU16Tire (uint16 u16Tire_);

    // API of field "u16User"

    static const int kU16User = 3;

    /**
     * Clears the field "u16User".
     *
     * The field will be set to its default value. The hasU16User()
     * method will return false.
     */
    inline void clearU16User();

    /**
     * Checks whether the field "u16User" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16User()). Otherwise it will return false.
     */
    inline bool hasU16User () const;

    /**
     * Returns the value of the member "u16User".
     *
     * User
     *
     * @return The value of the field "u16User"
     */
    inline uint16 getU16User () const;

    /**
     * Sets the value of the member "u16User".
     *
     * User
     *
     * @param u16User The value which will be set
     */
    inline void setU16User (uint16 u16User_);

    // API of field "u16Battery"

    static const int kU16Battery = 4;

    /**
     * Clears the field "u16Battery".
     *
     * The field will be set to its default value. The hasU16Battery()
     * method will return false.
     */
    inline void clearU16Battery();

    /**
     * Checks whether the field "u16Battery" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16Battery()). Otherwise it will return false.
     */
    inline bool hasU16Battery () const;

    /**
     * Returns the value of the member "u16Battery".
     *
     * Battery
     *
     * @return The value of the field "u16Battery"
     */
    inline uint16 getU16Battery () const;

    /**
     * Sets the value of the member "u16Battery".
     *
     * Battery
     *
     * @param u16Battery The value which will be set
     */
    inline void setU16Battery (uint16 u16Battery_);

    // API of field "u16ACFilter"

    static const int kU16ACFilter = 5;

    /**
     * Clears the field "u16ACFilter".
     *
     * The field will be set to its default value. The hasU16ACFilter()
     * method will return false.
     */
    inline void clearU16ACFilter();

    /**
     * Checks whether the field "u16ACFilter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ACFilter()). Otherwise it will return false.
     */
    inline bool hasU16ACFilter () const;

    /**
     * Returns the value of the member "u16ACFilter".
     *
     * Air Conditioner filter
     *
     * @return The value of the field "u16ACFilter"
     */
    inline uint16 getU16ACFilter () const;

    /**
     * Sets the value of the member "u16ACFilter".
     *
     * Air Conditioner filter
     *
     * @param u16ACFilter The value which will be set
     */
    inline void setU16ACFilter (uint16 u16ACFilter_);

    // API of field "u16Reserve"

    static const int kU16Reserve = 6;

    /**
     * Clears the field "u16Reserve".
     *
     * The field will be set to its default value. The hasU16Reserve()
     * method will return false.
     */
    inline void clearU16Reserve();

    /**
     * Checks whether the field "u16Reserve" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16Reserve()). Otherwise it will return false.
     */
    inline bool hasU16Reserve () const;

    /**
     * Returns the value of the member "u16Reserve".
     *
     * Reserve
     *
     * @return The value of the field "u16Reserve"
     */
    inline uint16 getU16Reserve () const;

    /**
     * Sets the value of the member "u16Reserve".
     *
     * Reserve
     *
     * @param u16Reserve The value which will be set
     */
    inline void setU16Reserve (uint16 u16Reserve_);

    static const T_TCU_Distance_Value &getDefaultInstance();

private:

    inline void set_has_u16OilFilter ();

    inline void clear_has_u16OilFilter ();

    inline void set_has_u16Oil ();

    inline void clear_has_u16Oil ();

    inline void set_has_u16Tire ();

    inline void clear_has_u16Tire ();

    inline void set_has_u16User ();

    inline void clear_has_u16User ();

    inline void set_has_u16Battery ();

    inline void clear_has_u16Battery ();

    inline void set_has_u16ACFilter ();

    inline void clear_has_u16ACFilter ();

    inline void set_has_u16Reserve ();

    inline void clear_has_u16Reserve ();

    uint32 _has_bits_[ (7 + 31) / 32];

    uint16 _u16OilFilter;

    uint16 _u16Oil;

    uint16 _u16Tire;

    uint16 _u16User;

    uint16 _u16Battery;

    uint16 _u16ACFilter;

    uint16 _u16Reserve;

};

/**
 * Record type containing Maintenance information.
 */
class T_TCU_Maintenance_Info {
public:

    /**
     * Default constructor
     */
    inline  T_TCU_Maintenance_Info ();

    /**
     * Copy constructor
     */
    inline  T_TCU_Maintenance_Info (const T_TCU_Maintenance_Info &rhs);

    /**
     * All fields constructor
     */
    inline  T_TCU_Maintenance_Info (T_e8_TCU_Distance_Unit e8DistanceUnit_, const T_TCU_Distance_Value& rDistanceValue_);

    /**
     * Destructor
     */
    inline  ~T_TCU_Maintenance_Info();

    /**
     * Assignment operator
     */
    inline T_TCU_Maintenance_Info& operator = (const T_TCU_Maintenance_Info& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TCU_Maintenance_Info& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TCU_Maintenance_Info& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TCU_Maintenance_Info& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TCU_Maintenance_Info& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8DistanceUnit"

    static const int kE8DistanceUnit = 0;

    /**
     * Clears the field "e8DistanceUnit".
     *
     * The field will be set to its default value. The hasE8DistanceUnit()
     * method will return false.
     */
    inline void clearE8DistanceUnit();

    /**
     * Checks whether the field "e8DistanceUnit" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DistanceUnit()). Otherwise it will return false.
     */
    inline bool hasE8DistanceUnit () const;

    /**
     * Returns the value of the member "e8DistanceUnit".
     *
     * Distance Unit.(01h - km and 02h - mile)
     *
     * @return The value of the field "e8DistanceUnit"
     */
    inline T_e8_TCU_Distance_Unit getE8DistanceUnit () const;

    /**
     * Sets the value of the member "e8DistanceUnit".
     *
     * Distance Unit.(01h - km and 02h - mile)
     *
     * @param e8DistanceUnit The value which will be set
     */
    inline void setE8DistanceUnit (T_e8_TCU_Distance_Unit e8DistanceUnit_);

    // API of field "rDistanceValue"

    static const int kRDistanceValue = 1;

    /**
     * Clears the field "rDistanceValue".
     *
     * The field will be set to its default value. The hasRDistanceValue()
     * method will return false.
     */
    inline void clearRDistanceValue();

    /**
     * Checks whether the field "rDistanceValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRDistanceValue()). Otherwise it will return false.
     */
    inline bool hasRDistanceValue () const;

    /**
     * Returns the value of the member "rDistanceValue".
     *
     * Distance Value
     *
     * @return The value of the field "rDistanceValue"
     */
    inline const T_TCU_Distance_Value& getRDistanceValue () const;

    /**
     * Retrieves the value of the field "rDistanceValue" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rDistanceValue".
     */
    inline T_TCU_Distance_Value& getRDistanceValueMutable ();

    /**
     * Sets the value of the member "rDistanceValue".
     *
     * Distance Value
     *
     * @param rDistanceValue The value which will be set
     */
    inline void setRDistanceValue (const T_TCU_Distance_Value& rDistanceValue_);

    static const T_TCU_Maintenance_Info &getDefaultInstance();

private:

    inline void set_has_e8DistanceUnit ();

    inline void clear_has_e8DistanceUnit ();

    inline void set_has_rDistanceValue ();

    inline void clear_has_rDistanceValue ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_TCU_Distance_Unit _e8DistanceUnit;

    T_TCU_Distance_Value _rDistanceValue;

};

/**
 * This structure holds information provision Service Available state of TCU.
 */
class T_TCU_Provision_List {
public:

    /**
     * Default constructor
     */
    inline  T_TCU_Provision_List ();

    /**
     * Copy constructor
     */
    inline  T_TCU_Provision_List (const T_TCU_Provision_List &rhs);

    /**
     * All fields constructor
     */
    inline  T_TCU_Provision_List (bool bOperatorService_, bool bConnectedSearch_, bool bMobileInformation_, uint16 u16ReserveNissan_, bool bInternetWidget_, bool bFuelPrice_, bool bLocalSearch_, bool bWebPreTrip_, bool bHDTraffic_, bool bSpeedTrap_, bool bPreventNav_, bool bWeather_, bool bLiveServices_, bool bChargingSpotFinder_, bool bChargingSchedule_, uint16 u16ReserveRenault_);

    /**
     * Destructor
     */
    inline  ~T_TCU_Provision_List();

    /**
     * Assignment operator
     */
    inline T_TCU_Provision_List& operator = (const T_TCU_Provision_List& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TCU_Provision_List& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TCU_Provision_List& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TCU_Provision_List& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TCU_Provision_List& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bOperatorService"

    static const int kBOperatorService = 0;

    /**
     * Clears the field "bOperatorService".
     *
     * The field will be set to its default value. The hasBOperatorService()
     * method will return false.
     */
    inline void clearBOperatorService();

    /**
     * Checks whether the field "bOperatorService" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBOperatorService()). Otherwise it will return false.
     */
    inline bool hasBOperatorService () const;

    /**
     * Returns the value of the member "bOperatorService".
     *
     * True-Available;False-Disabled
     *
     * @return The value of the field "bOperatorService"
     */
    inline bool getBOperatorService () const;

    /**
     * Sets the value of the member "bOperatorService".
     *
     * True-Available;False-Disabled
     *
     * @param bOperatorService The value which will be set
     */
    inline void setBOperatorService (bool bOperatorService_);

    // API of field "bConnectedSearch"

    static const int kBConnectedSearch = 1;

    /**
     * Clears the field "bConnectedSearch".
     *
     * The field will be set to its default value. The hasBConnectedSearch()
     * method will return false.
     */
    inline void clearBConnectedSearch();

    /**
     * Checks whether the field "bConnectedSearch" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBConnectedSearch()). Otherwise it will return false.
     */
    inline bool hasBConnectedSearch () const;

    /**
     * Returns the value of the member "bConnectedSearch".
     *
     * True-Available;False-Disabled
     *
     * @return The value of the field "bConnectedSearch"
     */
    inline bool getBConnectedSearch () const;

    /**
     * Sets the value of the member "bConnectedSearch".
     *
     * True-Available;False-Disabled
     *
     * @param bConnectedSearch The value which will be set
     */
    inline void setBConnectedSearch (bool bConnectedSearch_);

    // API of field "bMobileInformation"

    static const int kBMobileInformation = 2;

    /**
     * Clears the field "bMobileInformation".
     *
     * The field will be set to its default value. The hasBMobileInformation()
     * method will return false.
     */
    inline void clearBMobileInformation();

    /**
     * Checks whether the field "bMobileInformation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBMobileInformation()). Otherwise it will return false.
     */
    inline bool hasBMobileInformation () const;

    /**
     * Returns the value of the member "bMobileInformation".
     *
     * True-Available;False-Disabled
     *
     * @return The value of the field "bMobileInformation"
     */
    inline bool getBMobileInformation () const;

    /**
     * Sets the value of the member "bMobileInformation".
     *
     * True-Available;False-Disabled
     *
     * @param bMobileInformation The value which will be set
     */
    inline void setBMobileInformation (bool bMobileInformation_);

    // API of field "u16ReserveNissan"

    static const int kU16ReserveNissan = 3;

    /**
     * Clears the field "u16ReserveNissan".
     *
     * The field will be set to its default value. The hasU16ReserveNissan()
     * method will return false.
     */
    inline void clearU16ReserveNissan();

    /**
     * Checks whether the field "u16ReserveNissan" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ReserveNissan()). Otherwise it will return false.
     */
    inline bool hasU16ReserveNissan () const;

    /**
     * Returns the value of the member "u16ReserveNissan".
     *
     * Reserve
     *
     * @return The value of the field "u16ReserveNissan"
     */
    inline uint16 getU16ReserveNissan () const;

    /**
     * Sets the value of the member "u16ReserveNissan".
     *
     * Reserve
     *
     * @param u16ReserveNissan The value which will be set
     */
    inline void setU16ReserveNissan (uint16 u16ReserveNissan_);

    // API of field "bInternetWidget"

    static const int kBInternetWidget = 4;

    /**
     * Clears the field "bInternetWidget".
     *
     * The field will be set to its default value. The hasBInternetWidget()
     * method will return false.
     */
    inline void clearBInternetWidget();

    /**
     * Checks whether the field "bInternetWidget" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBInternetWidget()). Otherwise it will return false.
     */
    inline bool hasBInternetWidget () const;

    /**
     * Returns the value of the member "bInternetWidget".
     *
     * True-Available;False-Disabled
     *
     * @return The value of the field "bInternetWidget"
     */
    inline bool getBInternetWidget () const;

    /**
     * Sets the value of the member "bInternetWidget".
     *
     * True-Available;False-Disabled
     *
     * @param bInternetWidget The value which will be set
     */
    inline void setBInternetWidget (bool bInternetWidget_);

    // API of field "bFuelPrice"

    static const int kBFuelPrice = 5;

    /**
     * Clears the field "bFuelPrice".
     *
     * The field will be set to its default value. The hasBFuelPrice()
     * method will return false.
     */
    inline void clearBFuelPrice();

    /**
     * Checks whether the field "bFuelPrice" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBFuelPrice()). Otherwise it will return false.
     */
    inline bool hasBFuelPrice () const;

    /**
     * Returns the value of the member "bFuelPrice".
     *
     * True-Available;False-Disabled
     *
     * @return The value of the field "bFuelPrice"
     */
    inline bool getBFuelPrice () const;

    /**
     * Sets the value of the member "bFuelPrice".
     *
     * True-Available;False-Disabled
     *
     * @param bFuelPrice The value which will be set
     */
    inline void setBFuelPrice (bool bFuelPrice_);

    // API of field "bLocalSearch"

    static const int kBLocalSearch = 6;

    /**
     * Clears the field "bLocalSearch".
     *
     * The field will be set to its default value. The hasBLocalSearch()
     * method will return false.
     */
    inline void clearBLocalSearch();

    /**
     * Checks whether the field "bLocalSearch" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBLocalSearch()). Otherwise it will return false.
     */
    inline bool hasBLocalSearch () const;

    /**
     * Returns the value of the member "bLocalSearch".
     *
     * True-Available;False-Disabled
     *
     * @return The value of the field "bLocalSearch"
     */
    inline bool getBLocalSearch () const;

    /**
     * Sets the value of the member "bLocalSearch".
     *
     * True-Available;False-Disabled
     *
     * @param bLocalSearch The value which will be set
     */
    inline void setBLocalSearch (bool bLocalSearch_);

    // API of field "bWebPreTrip"

    static const int kBWebPreTrip = 7;

    /**
     * Clears the field "bWebPreTrip".
     *
     * The field will be set to its default value. The hasBWebPreTrip()
     * method will return false.
     */
    inline void clearBWebPreTrip();

    /**
     * Checks whether the field "bWebPreTrip" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBWebPreTrip()). Otherwise it will return false.
     */
    inline bool hasBWebPreTrip () const;

    /**
     * Returns the value of the member "bWebPreTrip".
     *
     * True-Available;False-Disabled
     *
     * @return The value of the field "bWebPreTrip"
     */
    inline bool getBWebPreTrip () const;

    /**
     * Sets the value of the member "bWebPreTrip".
     *
     * True-Available;False-Disabled
     *
     * @param bWebPreTrip The value which will be set
     */
    inline void setBWebPreTrip (bool bWebPreTrip_);

    // API of field "bHDTraffic"

    static const int kBHDTraffic = 8;

    /**
     * Clears the field "bHDTraffic".
     *
     * The field will be set to its default value. The hasBHDTraffic()
     * method will return false.
     */
    inline void clearBHDTraffic();

    /**
     * Checks whether the field "bHDTraffic" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBHDTraffic()). Otherwise it will return false.
     */
    inline bool hasBHDTraffic () const;

    /**
     * Returns the value of the member "bHDTraffic".
     *
     * True-Available;False-Disabled
     *
     * @return The value of the field "bHDTraffic"
     */
    inline bool getBHDTraffic () const;

    /**
     * Sets the value of the member "bHDTraffic".
     *
     * True-Available;False-Disabled
     *
     * @param bHDTraffic The value which will be set
     */
    inline void setBHDTraffic (bool bHDTraffic_);

    // API of field "bSpeedTrap"

    static const int kBSpeedTrap = 9;

    /**
     * Clears the field "bSpeedTrap".
     *
     * The field will be set to its default value. The hasBSpeedTrap()
     * method will return false.
     */
    inline void clearBSpeedTrap();

    /**
     * Checks whether the field "bSpeedTrap" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBSpeedTrap()). Otherwise it will return false.
     */
    inline bool hasBSpeedTrap () const;

    /**
     * Returns the value of the member "bSpeedTrap".
     *
     * True-Available;False-Disabled
     *
     * @return The value of the field "bSpeedTrap"
     */
    inline bool getBSpeedTrap () const;

    /**
     * Sets the value of the member "bSpeedTrap".
     *
     * True-Available;False-Disabled
     *
     * @param bSpeedTrap The value which will be set
     */
    inline void setBSpeedTrap (bool bSpeedTrap_);

    // API of field "bPreventNav"

    static const int kBPreventNav = 10;

    /**
     * Clears the field "bPreventNav".
     *
     * The field will be set to its default value. The hasBPreventNav()
     * method will return false.
     */
    inline void clearBPreventNav();

    /**
     * Checks whether the field "bPreventNav" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBPreventNav()). Otherwise it will return false.
     */
    inline bool hasBPreventNav () const;

    /**
     * Returns the value of the member "bPreventNav".
     *
     * True-Available;False-Disabled
     *
     * @return The value of the field "bPreventNav"
     */
    inline bool getBPreventNav () const;

    /**
     * Sets the value of the member "bPreventNav".
     *
     * True-Available;False-Disabled
     *
     * @param bPreventNav The value which will be set
     */
    inline void setBPreventNav (bool bPreventNav_);

    // API of field "bWeather"

    static const int kBWeather = 11;

    /**
     * Clears the field "bWeather".
     *
     * The field will be set to its default value. The hasBWeather()
     * method will return false.
     */
    inline void clearBWeather();

    /**
     * Checks whether the field "bWeather" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBWeather()). Otherwise it will return false.
     */
    inline bool hasBWeather () const;

    /**
     * Returns the value of the member "bWeather".
     *
     * True-Available;False-Disabled
     *
     * @return The value of the field "bWeather"
     */
    inline bool getBWeather () const;

    /**
     * Sets the value of the member "bWeather".
     *
     * True-Available;False-Disabled
     *
     * @param bWeather The value which will be set
     */
    inline void setBWeather (bool bWeather_);

    // API of field "bLiveServices"

    static const int kBLiveServices = 12;

    /**
     * Clears the field "bLiveServices".
     *
     * The field will be set to its default value. The hasBLiveServices()
     * method will return false.
     */
    inline void clearBLiveServices();

    /**
     * Checks whether the field "bLiveServices" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBLiveServices()). Otherwise it will return false.
     */
    inline bool hasBLiveServices () const;

    /**
     * Returns the value of the member "bLiveServices".
     *
     * True-Available;False-Disabled
     *
     * @return The value of the field "bLiveServices"
     */
    inline bool getBLiveServices () const;

    /**
     * Sets the value of the member "bLiveServices".
     *
     * True-Available;False-Disabled
     *
     * @param bLiveServices The value which will be set
     */
    inline void setBLiveServices (bool bLiveServices_);

    // API of field "bChargingSpotFinder"

    static const int kBChargingSpotFinder = 13;

    /**
     * Clears the field "bChargingSpotFinder".
     *
     * The field will be set to its default value. The hasBChargingSpotFinder()
     * method will return false.
     */
    inline void clearBChargingSpotFinder();

    /**
     * Checks whether the field "bChargingSpotFinder" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBChargingSpotFinder()). Otherwise it will return false.
     */
    inline bool hasBChargingSpotFinder () const;

    /**
     * Returns the value of the member "bChargingSpotFinder".
     *
     * True-Available;False-Disabled
     *
     * @return The value of the field "bChargingSpotFinder"
     */
    inline bool getBChargingSpotFinder () const;

    /**
     * Sets the value of the member "bChargingSpotFinder".
     *
     * True-Available;False-Disabled
     *
     * @param bChargingSpotFinder The value which will be set
     */
    inline void setBChargingSpotFinder (bool bChargingSpotFinder_);

    // API of field "bChargingSchedule"

    static const int kBChargingSchedule = 14;

    /**
     * Clears the field "bChargingSchedule".
     *
     * The field will be set to its default value. The hasBChargingSchedule()
     * method will return false.
     */
    inline void clearBChargingSchedule();

    /**
     * Checks whether the field "bChargingSchedule" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBChargingSchedule()). Otherwise it will return false.
     */
    inline bool hasBChargingSchedule () const;

    /**
     * Returns the value of the member "bChargingSchedule".
     *
     * True-Available;False-Disabled
     *
     * @return The value of the field "bChargingSchedule"
     */
    inline bool getBChargingSchedule () const;

    /**
     * Sets the value of the member "bChargingSchedule".
     *
     * True-Available;False-Disabled
     *
     * @param bChargingSchedule The value which will be set
     */
    inline void setBChargingSchedule (bool bChargingSchedule_);

    // API of field "u16ReserveRenault"

    static const int kU16ReserveRenault = 15;

    /**
     * Clears the field "u16ReserveRenault".
     *
     * The field will be set to its default value. The hasU16ReserveRenault()
     * method will return false.
     */
    inline void clearU16ReserveRenault();

    /**
     * Checks whether the field "u16ReserveRenault" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ReserveRenault()). Otherwise it will return false.
     */
    inline bool hasU16ReserveRenault () const;

    /**
     * Returns the value of the member "u16ReserveRenault".
     *
     * Reserve
     *
     * @return The value of the field "u16ReserveRenault"
     */
    inline uint16 getU16ReserveRenault () const;

    /**
     * Sets the value of the member "u16ReserveRenault".
     *
     * Reserve
     *
     * @param u16ReserveRenault The value which will be set
     */
    inline void setU16ReserveRenault (uint16 u16ReserveRenault_);

    static const T_TCU_Provision_List &getDefaultInstance();

private:

    inline void set_has_bOperatorService ();

    inline void clear_has_bOperatorService ();

    inline void set_has_bConnectedSearch ();

    inline void clear_has_bConnectedSearch ();

    inline void set_has_bMobileInformation ();

    inline void clear_has_bMobileInformation ();

    inline void set_has_u16ReserveNissan ();

    inline void clear_has_u16ReserveNissan ();

    inline void set_has_bInternetWidget ();

    inline void clear_has_bInternetWidget ();

    inline void set_has_bFuelPrice ();

    inline void clear_has_bFuelPrice ();

    inline void set_has_bLocalSearch ();

    inline void clear_has_bLocalSearch ();

    inline void set_has_bWebPreTrip ();

    inline void clear_has_bWebPreTrip ();

    inline void set_has_bHDTraffic ();

    inline void clear_has_bHDTraffic ();

    inline void set_has_bSpeedTrap ();

    inline void clear_has_bSpeedTrap ();

    inline void set_has_bPreventNav ();

    inline void clear_has_bPreventNav ();

    inline void set_has_bWeather ();

    inline void clear_has_bWeather ();

    inline void set_has_bLiveServices ();

    inline void clear_has_bLiveServices ();

    inline void set_has_bChargingSpotFinder ();

    inline void clear_has_bChargingSpotFinder ();

    inline void set_has_bChargingSchedule ();

    inline void clear_has_bChargingSchedule ();

    inline void set_has_u16ReserveRenault ();

    inline void clear_has_u16ReserveRenault ();

    uint32 _has_bits_[ (16 + 31) / 32];

    bool _bOperatorService;

    bool _bConnectedSearch;

    bool _bMobileInformation;

    uint16 _u16ReserveNissan;

    bool _bInternetWidget;

    bool _bFuelPrice;

    bool _bLocalSearch;

    bool _bWebPreTrip;

    bool _bHDTraffic;

    bool _bSpeedTrap;

    bool _bPreventNav;

    bool _bWeather;

    bool _bLiveServices;

    bool _bChargingSpotFinder;

    bool _bChargingSchedule;

    uint16 _u16ReserveRenault;

};

/**
 * EV charge reminder information
 */
class T_TCU_ReminderInfo {
public:

    /**
     * Default constructor
     */
    inline  T_TCU_ReminderInfo ();

    /**
     * Copy constructor
     */
    inline  T_TCU_ReminderInfo (const T_TCU_ReminderInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_TCU_ReminderInfo (T_e8_TCU_Mode e8Plugin_Mode_, T_e8_TCU_Mode e8Stop_Mode_, uint16 u16RemainTime_);

    /**
     * Destructor
     */
    inline  ~T_TCU_ReminderInfo();

    /**
     * Assignment operator
     */
    inline T_TCU_ReminderInfo& operator = (const T_TCU_ReminderInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TCU_ReminderInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TCU_ReminderInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TCU_ReminderInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TCU_ReminderInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Plugin_Mode"

    static const int kE8Plugin_Mode = 0;

    /**
     * Clears the field "e8Plugin_Mode".
     *
     * The field will be set to its default value. The hasE8Plugin_Mode()
     * method will return false.
     */
    inline void clearE8Plugin_Mode();

    /**
     * Checks whether the field "e8Plugin_Mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Plugin_Mode()). Otherwise it will return false.
     */
    inline bool hasE8Plugin_Mode () const;

    /**
     * Returns the value of the member "e8Plugin_Mode".
     *
     * If the meaning of "e8Plugin_Mode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Plugin_Mode"
     */
    inline T_e8_TCU_Mode getE8Plugin_Mode () const;

    /**
     * Sets the value of the member "e8Plugin_Mode".
     *
     * If the meaning of "e8Plugin_Mode" isn't clear, then there should be a description here.
     *
     * @param e8Plugin_Mode The value which will be set
     */
    inline void setE8Plugin_Mode (T_e8_TCU_Mode e8Plugin_Mode_);

    // API of field "e8Stop_Mode"

    static const int kE8Stop_Mode = 1;

    /**
     * Clears the field "e8Stop_Mode".
     *
     * The field will be set to its default value. The hasE8Stop_Mode()
     * method will return false.
     */
    inline void clearE8Stop_Mode();

    /**
     * Checks whether the field "e8Stop_Mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Stop_Mode()). Otherwise it will return false.
     */
    inline bool hasE8Stop_Mode () const;

    /**
     * Returns the value of the member "e8Stop_Mode".
     *
     * If the meaning of "e8Stop_Mode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Stop_Mode"
     */
    inline T_e8_TCU_Mode getE8Stop_Mode () const;

    /**
     * Sets the value of the member "e8Stop_Mode".
     *
     * If the meaning of "e8Stop_Mode" isn't clear, then there should be a description here.
     *
     * @param e8Stop_Mode The value which will be set
     */
    inline void setE8Stop_Mode (T_e8_TCU_Mode e8Stop_Mode_);

    // API of field "u16RemainTime"

    static const int kU16RemainTime = 2;

    /**
     * Clears the field "u16RemainTime".
     *
     * The field will be set to its default value. The hasU16RemainTime()
     * method will return false.
     */
    inline void clearU16RemainTime();

    /**
     * Checks whether the field "u16RemainTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16RemainTime()). Otherwise it will return false.
     */
    inline bool hasU16RemainTime () const;

    /**
     * Returns the value of the member "u16RemainTime".
     *
     * If the meaning of "u16RemainTime" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u16RemainTime"
     */
    inline uint16 getU16RemainTime () const;

    /**
     * Sets the value of the member "u16RemainTime".
     *
     * If the meaning of "u16RemainTime" isn't clear, then there should be a description here.
     *
     * @param u16RemainTime The value which will be set
     */
    inline void setU16RemainTime (uint16 u16RemainTime_);

    static const T_TCU_ReminderInfo &getDefaultInstance();

private:

    inline void set_has_e8Plugin_Mode ();

    inline void clear_has_e8Plugin_Mode ();

    inline void set_has_e8Stop_Mode ();

    inline void clear_has_e8Stop_Mode ();

    inline void set_has_u16RemainTime ();

    inline void clear_has_u16RemainTime ();

    uint32 _has_bits_[ (3 + 31) / 32];

    T_e8_TCU_Mode _e8Plugin_Mode;

    T_e8_TCU_Mode _e8Stop_Mode;

    uint16 _u16RemainTime;

};

/**
 * If the meaning of "T_TCU_GPS_Position" isn't clear, then there should be a description here.
 */
class T_TCU_GPS_Position {
public:

    /**
     * Default constructor
     */
    inline  T_TCU_GPS_Position ();

    /**
     * Copy constructor
     */
    inline  T_TCU_GPS_Position (const T_TCU_GPS_Position &rhs);

    /**
     * All fields constructor
     */
    inline  T_TCU_GPS_Position (uint8 u8Reserved_, T_e8_TCU_LocationType e8LocationType_, T_e8_TCU_LatitudeMode e8Latitudemode_, T_e8_TCU_LongitudeMode e8LongitudeMode_, uint8 u8LatitudeDEG_, uint8 u8LatitudeMIN_, uint16 u16LatitudeSEC_, uint8 u8LongitudeDEG_, uint8 u8LongitudeMIN_, uint16 u16LongitudeSEC_);

    /**
     * Destructor
     */
    inline  ~T_TCU_GPS_Position();

    /**
     * Assignment operator
     */
    inline T_TCU_GPS_Position& operator = (const T_TCU_GPS_Position& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TCU_GPS_Position& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TCU_GPS_Position& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TCU_GPS_Position& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TCU_GPS_Position& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8Reserved"

    static const int kU8Reserved = 0;

    /**
     * Clears the field "u8Reserved".
     *
     * The field will be set to its default value. The hasU8Reserved()
     * method will return false.
     */
    inline void clearU8Reserved();

    /**
     * Checks whether the field "u8Reserved" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Reserved()). Otherwise it will return false.
     */
    inline bool hasU8Reserved () const;

    /**
     * Returns the value of the member "u8Reserved".
     *
     * Reserved
     *
     * @return The value of the field "u8Reserved"
     */
    inline uint8 getU8Reserved () const;

    /**
     * Sets the value of the member "u8Reserved".
     *
     * Reserved
     *
     * @param u8Reserved The value which will be set
     */
    inline void setU8Reserved (uint8 u8Reserved_);

    // API of field "e8LocationType"

    static const int kE8LocationType = 1;

    /**
     * Clears the field "e8LocationType".
     *
     * The field will be set to its default value. The hasE8LocationType()
     * method will return false.
     */
    inline void clearE8LocationType();

    /**
     * Checks whether the field "e8LocationType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8LocationType()). Otherwise it will return false.
     */
    inline bool hasE8LocationType () const;

    /**
     * Returns the value of the member "e8LocationType".
     *
     * Location Type
     *
     * @return The value of the field "e8LocationType"
     */
    inline T_e8_TCU_LocationType getE8LocationType () const;

    /**
     * Sets the value of the member "e8LocationType".
     *
     * Location Type
     *
     * @param e8LocationType The value which will be set
     */
    inline void setE8LocationType (T_e8_TCU_LocationType e8LocationType_);

    // API of field "e8Latitudemode"

    static const int kE8Latitudemode = 2;

    /**
     * Clears the field "e8Latitudemode".
     *
     * The field will be set to its default value. The hasE8Latitudemode()
     * method will return false.
     */
    inline void clearE8Latitudemode();

    /**
     * Checks whether the field "e8Latitudemode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Latitudemode()). Otherwise it will return false.
     */
    inline bool hasE8Latitudemode () const;

    /**
     * Returns the value of the member "e8Latitudemode".
     *
     * Latitude mode
     *
     * @return The value of the field "e8Latitudemode"
     */
    inline T_e8_TCU_LatitudeMode getE8Latitudemode () const;

    /**
     * Sets the value of the member "e8Latitudemode".
     *
     * Latitude mode
     *
     * @param e8Latitudemode The value which will be set
     */
    inline void setE8Latitudemode (T_e8_TCU_LatitudeMode e8Latitudemode_);

    // API of field "e8LongitudeMode"

    static const int kE8LongitudeMode = 3;

    /**
     * Clears the field "e8LongitudeMode".
     *
     * The field will be set to its default value. The hasE8LongitudeMode()
     * method will return false.
     */
    inline void clearE8LongitudeMode();

    /**
     * Checks whether the field "e8LongitudeMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8LongitudeMode()). Otherwise it will return false.
     */
    inline bool hasE8LongitudeMode () const;

    /**
     * Returns the value of the member "e8LongitudeMode".
     *
     * Logitude mode
     *
     * @return The value of the field "e8LongitudeMode"
     */
    inline T_e8_TCU_LongitudeMode getE8LongitudeMode () const;

    /**
     * Sets the value of the member "e8LongitudeMode".
     *
     * Logitude mode
     *
     * @param e8LongitudeMode The value which will be set
     */
    inline void setE8LongitudeMode (T_e8_TCU_LongitudeMode e8LongitudeMode_);

    // API of field "u8LatitudeDEG"

    static const int kU8LatitudeDEG = 4;

    /**
     * Clears the field "u8LatitudeDEG".
     *
     * The field will be set to its default value. The hasU8LatitudeDEG()
     * method will return false.
     */
    inline void clearU8LatitudeDEG();

    /**
     * Checks whether the field "u8LatitudeDEG" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8LatitudeDEG()). Otherwise it will return false.
     */
    inline bool hasU8LatitudeDEG () const;

    /**
     * Returns the value of the member "u8LatitudeDEG".
     *
     * Latitude degree
     *
     * @return The value of the field "u8LatitudeDEG"
     */
    inline uint8 getU8LatitudeDEG () const;

    /**
     * Sets the value of the member "u8LatitudeDEG".
     *
     * Latitude degree
     *
     * @param u8LatitudeDEG The value which will be set
     */
    inline void setU8LatitudeDEG (uint8 u8LatitudeDEG_);

    // API of field "u8LatitudeMIN"

    static const int kU8LatitudeMIN = 5;

    /**
     * Clears the field "u8LatitudeMIN".
     *
     * The field will be set to its default value. The hasU8LatitudeMIN()
     * method will return false.
     */
    inline void clearU8LatitudeMIN();

    /**
     * Checks whether the field "u8LatitudeMIN" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8LatitudeMIN()). Otherwise it will return false.
     */
    inline bool hasU8LatitudeMIN () const;

    /**
     * Returns the value of the member "u8LatitudeMIN".
     *
     * Latitude Minute
     *
     * @return The value of the field "u8LatitudeMIN"
     */
    inline uint8 getU8LatitudeMIN () const;

    /**
     * Sets the value of the member "u8LatitudeMIN".
     *
     * Latitude Minute
     *
     * @param u8LatitudeMIN The value which will be set
     */
    inline void setU8LatitudeMIN (uint8 u8LatitudeMIN_);

    // API of field "u16LatitudeSEC"

    static const int kU16LatitudeSEC = 6;

    /**
     * Clears the field "u16LatitudeSEC".
     *
     * The field will be set to its default value. The hasU16LatitudeSEC()
     * method will return false.
     */
    inline void clearU16LatitudeSEC();

    /**
     * Checks whether the field "u16LatitudeSEC" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16LatitudeSEC()). Otherwise it will return false.
     */
    inline bool hasU16LatitudeSEC () const;

    /**
     * Returns the value of the member "u16LatitudeSEC".
     *
     * Latitude Seconds
     *
     * @return The value of the field "u16LatitudeSEC"
     */
    inline uint16 getU16LatitudeSEC () const;

    /**
     * Sets the value of the member "u16LatitudeSEC".
     *
     * Latitude Seconds
     *
     * @param u16LatitudeSEC The value which will be set
     */
    inline void setU16LatitudeSEC (uint16 u16LatitudeSEC_);

    // API of field "u8LongitudeDEG"

    static const int kU8LongitudeDEG = 7;

    /**
     * Clears the field "u8LongitudeDEG".
     *
     * The field will be set to its default value. The hasU8LongitudeDEG()
     * method will return false.
     */
    inline void clearU8LongitudeDEG();

    /**
     * Checks whether the field "u8LongitudeDEG" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8LongitudeDEG()). Otherwise it will return false.
     */
    inline bool hasU8LongitudeDEG () const;

    /**
     * Returns the value of the member "u8LongitudeDEG".
     *
     * Longitude degree
     *
     * @return The value of the field "u8LongitudeDEG"
     */
    inline uint8 getU8LongitudeDEG () const;

    /**
     * Sets the value of the member "u8LongitudeDEG".
     *
     * Longitude degree
     *
     * @param u8LongitudeDEG The value which will be set
     */
    inline void setU8LongitudeDEG (uint8 u8LongitudeDEG_);

    // API of field "u8LongitudeMIN"

    static const int kU8LongitudeMIN = 8;

    /**
     * Clears the field "u8LongitudeMIN".
     *
     * The field will be set to its default value. The hasU8LongitudeMIN()
     * method will return false.
     */
    inline void clearU8LongitudeMIN();

    /**
     * Checks whether the field "u8LongitudeMIN" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8LongitudeMIN()). Otherwise it will return false.
     */
    inline bool hasU8LongitudeMIN () const;

    /**
     * Returns the value of the member "u8LongitudeMIN".
     *
     * Longitude Minute
     *
     * @return The value of the field "u8LongitudeMIN"
     */
    inline uint8 getU8LongitudeMIN () const;

    /**
     * Sets the value of the member "u8LongitudeMIN".
     *
     * Longitude Minute
     *
     * @param u8LongitudeMIN The value which will be set
     */
    inline void setU8LongitudeMIN (uint8 u8LongitudeMIN_);

    // API of field "u16LongitudeSEC"

    static const int kU16LongitudeSEC = 9;

    /**
     * Clears the field "u16LongitudeSEC".
     *
     * The field will be set to its default value. The hasU16LongitudeSEC()
     * method will return false.
     */
    inline void clearU16LongitudeSEC();

    /**
     * Checks whether the field "u16LongitudeSEC" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16LongitudeSEC()). Otherwise it will return false.
     */
    inline bool hasU16LongitudeSEC () const;

    /**
     * Returns the value of the member "u16LongitudeSEC".
     *
     * Longitude Seconds
     *
     * @return The value of the field "u16LongitudeSEC"
     */
    inline uint16 getU16LongitudeSEC () const;

    /**
     * Sets the value of the member "u16LongitudeSEC".
     *
     * Longitude Seconds
     *
     * @param u16LongitudeSEC The value which will be set
     */
    inline void setU16LongitudeSEC (uint16 u16LongitudeSEC_);

    static const T_TCU_GPS_Position &getDefaultInstance();

private:

    inline void set_has_u8Reserved ();

    inline void clear_has_u8Reserved ();

    inline void set_has_e8LocationType ();

    inline void clear_has_e8LocationType ();

    inline void set_has_e8Latitudemode ();

    inline void clear_has_e8Latitudemode ();

    inline void set_has_e8LongitudeMode ();

    inline void clear_has_e8LongitudeMode ();

    inline void set_has_u8LatitudeDEG ();

    inline void clear_has_u8LatitudeDEG ();

    inline void set_has_u8LatitudeMIN ();

    inline void clear_has_u8LatitudeMIN ();

    inline void set_has_u16LatitudeSEC ();

    inline void clear_has_u16LatitudeSEC ();

    inline void set_has_u8LongitudeDEG ();

    inline void clear_has_u8LongitudeDEG ();

    inline void set_has_u8LongitudeMIN ();

    inline void clear_has_u8LongitudeMIN ();

    inline void set_has_u16LongitudeSEC ();

    inline void clear_has_u16LongitudeSEC ();

    uint32 _has_bits_[ (10 + 31) / 32];

    uint8 _u8Reserved;

    T_e8_TCU_LocationType _e8LocationType;

    T_e8_TCU_LatitudeMode _e8Latitudemode;

    T_e8_TCU_LongitudeMode _e8LongitudeMode;

    uint8 _u8LatitudeDEG;

    uint8 _u8LatitudeMIN;

    uint16 _u16LatitudeSEC;

    uint8 _u8LongitudeDEG;

    uint8 _u8LongitudeMIN;

    uint16 _u16LongitudeSEC;

};

/**
 * If the meaning of "T_TCU_Time_Stamp" isn't clear, then there should be a description here.
 */
class T_TCU_Time_Stamp {
public:

    /**
     * Default constructor
     */
    inline  T_TCU_Time_Stamp ();

    /**
     * Copy constructor
     */
    inline  T_TCU_Time_Stamp (const T_TCU_Time_Stamp &rhs);

    /**
     * All fields constructor
     */
    inline  T_TCU_Time_Stamp (uint8 u8Year_, uint8 u8Month_, uint8 u8Day_, uint8 u8Hour_, uint8 u8Minute_, uint8 u8Second_);

    /**
     * Destructor
     */
    inline  ~T_TCU_Time_Stamp();

    /**
     * Assignment operator
     */
    inline T_TCU_Time_Stamp& operator = (const T_TCU_Time_Stamp& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TCU_Time_Stamp& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TCU_Time_Stamp& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TCU_Time_Stamp& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TCU_Time_Stamp& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8Year"

    static const int kU8Year = 0;

    /**
     * Clears the field "u8Year".
     *
     * The field will be set to its default value. The hasU8Year()
     * method will return false.
     */
    inline void clearU8Year();

    /**
     * Checks whether the field "u8Year" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Year()). Otherwise it will return false.
     */
    inline bool hasU8Year () const;

    /**
     * Returns the value of the member "u8Year".
     *
     * Year(from 2000 to 2099) :: Physical range : 0 to 99 ::Step : 1 Year
     *
     * @return The value of the field "u8Year"
     */
    inline uint8 getU8Year () const;

    /**
     * Sets the value of the member "u8Year".
     *
     * Year(from 2000 to 2099) :: Physical range : 0 to 99 ::Step : 1 Year
     *
     * @param u8Year The value which will be set
     */
    inline void setU8Year (uint8 u8Year_);

    // API of field "u8Month"

    static const int kU8Month = 1;

    /**
     * Clears the field "u8Month".
     *
     * The field will be set to its default value. The hasU8Month()
     * method will return false.
     */
    inline void clearU8Month();

    /**
     * Checks whether the field "u8Month" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Month()). Otherwise it will return false.
     */
    inline bool hasU8Month () const;

    /**
     * Returns the value of the member "u8Month".
     *
     * Month
     *
     * @return The value of the field "u8Month"
     */
    inline uint8 getU8Month () const;

    /**
     * Sets the value of the member "u8Month".
     *
     * Month
     *
     * @param u8Month The value which will be set
     */
    inline void setU8Month (uint8 u8Month_);

    // API of field "u8Day"

    static const int kU8Day = 2;

    /**
     * Clears the field "u8Day".
     *
     * The field will be set to its default value. The hasU8Day()
     * method will return false.
     */
    inline void clearU8Day();

    /**
     * Checks whether the field "u8Day" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Day()). Otherwise it will return false.
     */
    inline bool hasU8Day () const;

    /**
     * Returns the value of the member "u8Day".
     *
     * Day
     *
     * @return The value of the field "u8Day"
     */
    inline uint8 getU8Day () const;

    /**
     * Sets the value of the member "u8Day".
     *
     * Day
     *
     * @param u8Day The value which will be set
     */
    inline void setU8Day (uint8 u8Day_);

    // API of field "u8Hour"

    static const int kU8Hour = 3;

    /**
     * Clears the field "u8Hour".
     *
     * The field will be set to its default value. The hasU8Hour()
     * method will return false.
     */
    inline void clearU8Hour();

    /**
     * Checks whether the field "u8Hour" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Hour()). Otherwise it will return false.
     */
    inline bool hasU8Hour () const;

    /**
     * Returns the value of the member "u8Hour".
     *
     * Hour
     *
     * @return The value of the field "u8Hour"
     */
    inline uint8 getU8Hour () const;

    /**
     * Sets the value of the member "u8Hour".
     *
     * Hour
     *
     * @param u8Hour The value which will be set
     */
    inline void setU8Hour (uint8 u8Hour_);

    // API of field "u8Minute"

    static const int kU8Minute = 4;

    /**
     * Clears the field "u8Minute".
     *
     * The field will be set to its default value. The hasU8Minute()
     * method will return false.
     */
    inline void clearU8Minute();

    /**
     * Checks whether the field "u8Minute" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Minute()). Otherwise it will return false.
     */
    inline bool hasU8Minute () const;

    /**
     * Returns the value of the member "u8Minute".
     *
     * Minute
     *
     * @return The value of the field "u8Minute"
     */
    inline uint8 getU8Minute () const;

    /**
     * Sets the value of the member "u8Minute".
     *
     * Minute
     *
     * @param u8Minute The value which will be set
     */
    inline void setU8Minute (uint8 u8Minute_);

    // API of field "u8Second"

    static const int kU8Second = 5;

    /**
     * Clears the field "u8Second".
     *
     * The field will be set to its default value. The hasU8Second()
     * method will return false.
     */
    inline void clearU8Second();

    /**
     * Checks whether the field "u8Second" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Second()). Otherwise it will return false.
     */
    inline bool hasU8Second () const;

    /**
     * Returns the value of the member "u8Second".
     *
     * Second
     *
     * @return The value of the field "u8Second"
     */
    inline uint8 getU8Second () const;

    /**
     * Sets the value of the member "u8Second".
     *
     * Second
     *
     * @param u8Second The value which will be set
     */
    inline void setU8Second (uint8 u8Second_);

    static const T_TCU_Time_Stamp &getDefaultInstance();

private:

    inline void set_has_u8Year ();

    inline void clear_has_u8Year ();

    inline void set_has_u8Month ();

    inline void clear_has_u8Month ();

    inline void set_has_u8Day ();

    inline void clear_has_u8Day ();

    inline void set_has_u8Hour ();

    inline void clear_has_u8Hour ();

    inline void set_has_u8Minute ();

    inline void clear_has_u8Minute ();

    inline void set_has_u8Second ();

    inline void clear_has_u8Second ();

    uint32 _has_bits_[ (6 + 31) / 32];

    uint8 _u8Year;

    uint8 _u8Month;

    uint8 _u8Day;

    uint8 _u8Hour;

    uint8 _u8Minute;

    uint8 _u8Second;

};

/**
 * If the meaning of "T_TCU_Opening_Hour_Day" isn't clear, then there should be a description here.
 */
class T_TCU_Opening_Hour_Day {
public:

    /**
     * Default constructor
     */
    inline  T_TCU_Opening_Hour_Day ();

    /**
     * Copy constructor
     */
    inline  T_TCU_Opening_Hour_Day (const T_TCU_Opening_Hour_Day &rhs);

    /**
     * All fields constructor
     */
    inline  T_TCU_Opening_Hour_Day (uint8 u8StartTime_1_, uint8 u8StartTime_2_, uint8 u8EndTime_1_, uint8 u8EndTime_2_);

    /**
     * Destructor
     */
    inline  ~T_TCU_Opening_Hour_Day();

    /**
     * Assignment operator
     */
    inline T_TCU_Opening_Hour_Day& operator = (const T_TCU_Opening_Hour_Day& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TCU_Opening_Hour_Day& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TCU_Opening_Hour_Day& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TCU_Opening_Hour_Day& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TCU_Opening_Hour_Day& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8StartTime_1"

    static const int kU8StartTime_1 = 0;

    /**
     * Clears the field "u8StartTime_1".
     *
     * The field will be set to its default value. The hasU8StartTime_1()
     * method will return false.
     */
    inline void clearU8StartTime_1();

    /**
     * Checks whether the field "u8StartTime_1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8StartTime_1()). Otherwise it will return false.
     */
    inline bool hasU8StartTime_1 () const;

    /**
     * Returns the value of the member "u8StartTime_1".
     *
     * If the meaning of "u8StartTime_1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8StartTime_1"
     */
    inline uint8 getU8StartTime_1 () const;

    /**
     * Sets the value of the member "u8StartTime_1".
     *
     * If the meaning of "u8StartTime_1" isn't clear, then there should be a description here.
     *
     * @param u8StartTime_1 The value which will be set
     */
    inline void setU8StartTime_1 (uint8 u8StartTime_1_);

    // API of field "u8StartTime_2"

    static const int kU8StartTime_2 = 1;

    /**
     * Clears the field "u8StartTime_2".
     *
     * The field will be set to its default value. The hasU8StartTime_2()
     * method will return false.
     */
    inline void clearU8StartTime_2();

    /**
     * Checks whether the field "u8StartTime_2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8StartTime_2()). Otherwise it will return false.
     */
    inline bool hasU8StartTime_2 () const;

    /**
     * Returns the value of the member "u8StartTime_2".
     *
     * If the meaning of "u8StartTime_2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8StartTime_2"
     */
    inline uint8 getU8StartTime_2 () const;

    /**
     * Sets the value of the member "u8StartTime_2".
     *
     * If the meaning of "u8StartTime_2" isn't clear, then there should be a description here.
     *
     * @param u8StartTime_2 The value which will be set
     */
    inline void setU8StartTime_2 (uint8 u8StartTime_2_);

    // API of field "u8EndTime_1"

    static const int kU8EndTime_1 = 2;

    /**
     * Clears the field "u8EndTime_1".
     *
     * The field will be set to its default value. The hasU8EndTime_1()
     * method will return false.
     */
    inline void clearU8EndTime_1();

    /**
     * Checks whether the field "u8EndTime_1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8EndTime_1()). Otherwise it will return false.
     */
    inline bool hasU8EndTime_1 () const;

    /**
     * Returns the value of the member "u8EndTime_1".
     *
     * If the meaning of "u8EndTime_1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8EndTime_1"
     */
    inline uint8 getU8EndTime_1 () const;

    /**
     * Sets the value of the member "u8EndTime_1".
     *
     * If the meaning of "u8EndTime_1" isn't clear, then there should be a description here.
     *
     * @param u8EndTime_1 The value which will be set
     */
    inline void setU8EndTime_1 (uint8 u8EndTime_1_);

    // API of field "u8EndTime_2"

    static const int kU8EndTime_2 = 3;

    /**
     * Clears the field "u8EndTime_2".
     *
     * The field will be set to its default value. The hasU8EndTime_2()
     * method will return false.
     */
    inline void clearU8EndTime_2();

    /**
     * Checks whether the field "u8EndTime_2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8EndTime_2()). Otherwise it will return false.
     */
    inline bool hasU8EndTime_2 () const;

    /**
     * Returns the value of the member "u8EndTime_2".
     *
     * If the meaning of "u8EndTime_2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8EndTime_2"
     */
    inline uint8 getU8EndTime_2 () const;

    /**
     * Sets the value of the member "u8EndTime_2".
     *
     * If the meaning of "u8EndTime_2" isn't clear, then there should be a description here.
     *
     * @param u8EndTime_2 The value which will be set
     */
    inline void setU8EndTime_2 (uint8 u8EndTime_2_);

    static const T_TCU_Opening_Hour_Day &getDefaultInstance();

private:

    inline void set_has_u8StartTime_1 ();

    inline void clear_has_u8StartTime_1 ();

    inline void set_has_u8StartTime_2 ();

    inline void clear_has_u8StartTime_2 ();

    inline void set_has_u8EndTime_1 ();

    inline void clear_has_u8EndTime_1 ();

    inline void set_has_u8EndTime_2 ();

    inline void clear_has_u8EndTime_2 ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint8 _u8StartTime_1;

    uint8 _u8StartTime_2;

    uint8 _u8EndTime_1;

    uint8 _u8EndTime_2;

};

/**
 * If the meaning of "T_TCU_Opening_Hour" isn't clear, then there should be a description here.
 */
class T_TCU_Opening_Hour {
public:

    /**
     * Default constructor
     */
    inline  T_TCU_Opening_Hour ();

    /**
     * Copy constructor
     */
    inline  T_TCU_Opening_Hour (const T_TCU_Opening_Hour &rhs);

    /**
     * All fields constructor
     */
    inline  T_TCU_Opening_Hour (const T_TCU_Opening_Hour_Day& rSunday_, const T_TCU_Opening_Hour_Day& rMonday_, const T_TCU_Opening_Hour_Day& rTuesday_, const T_TCU_Opening_Hour_Day& rWednesday_, const T_TCU_Opening_Hour_Day& rThursday_, const T_TCU_Opening_Hour_Day& rFriday_, const T_TCU_Opening_Hour_Day& rSaturday_);

    /**
     * Destructor
     */
    inline  ~T_TCU_Opening_Hour();

    /**
     * Assignment operator
     */
    inline T_TCU_Opening_Hour& operator = (const T_TCU_Opening_Hour& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TCU_Opening_Hour& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TCU_Opening_Hour& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TCU_Opening_Hour& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TCU_Opening_Hour& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "rSunday"

    static const int kRSunday = 0;

    /**
     * Clears the field "rSunday".
     *
     * The field will be set to its default value. The hasRSunday()
     * method will return false.
     */
    inline void clearRSunday();

    /**
     * Checks whether the field "rSunday" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRSunday()). Otherwise it will return false.
     */
    inline bool hasRSunday () const;

    /**
     * Returns the value of the member "rSunday".
     *
     * Sunday
     *
     * @return The value of the field "rSunday"
     */
    inline const T_TCU_Opening_Hour_Day& getRSunday () const;

    /**
     * Retrieves the value of the field "rSunday" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rSunday".
     */
    inline T_TCU_Opening_Hour_Day& getRSundayMutable ();

    /**
     * Sets the value of the member "rSunday".
     *
     * Sunday
     *
     * @param rSunday The value which will be set
     */
    inline void setRSunday (const T_TCU_Opening_Hour_Day& rSunday_);

    // API of field "rMonday"

    static const int kRMonday = 1;

    /**
     * Clears the field "rMonday".
     *
     * The field will be set to its default value. The hasRMonday()
     * method will return false.
     */
    inline void clearRMonday();

    /**
     * Checks whether the field "rMonday" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRMonday()). Otherwise it will return false.
     */
    inline bool hasRMonday () const;

    /**
     * Returns the value of the member "rMonday".
     *
     * Monday
     *
     * @return The value of the field "rMonday"
     */
    inline const T_TCU_Opening_Hour_Day& getRMonday () const;

    /**
     * Retrieves the value of the field "rMonday" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rMonday".
     */
    inline T_TCU_Opening_Hour_Day& getRMondayMutable ();

    /**
     * Sets the value of the member "rMonday".
     *
     * Monday
     *
     * @param rMonday The value which will be set
     */
    inline void setRMonday (const T_TCU_Opening_Hour_Day& rMonday_);

    // API of field "rTuesday"

    static const int kRTuesday = 2;

    /**
     * Clears the field "rTuesday".
     *
     * The field will be set to its default value. The hasRTuesday()
     * method will return false.
     */
    inline void clearRTuesday();

    /**
     * Checks whether the field "rTuesday" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRTuesday()). Otherwise it will return false.
     */
    inline bool hasRTuesday () const;

    /**
     * Returns the value of the member "rTuesday".
     *
     * Tuesday
     *
     * @return The value of the field "rTuesday"
     */
    inline const T_TCU_Opening_Hour_Day& getRTuesday () const;

    /**
     * Retrieves the value of the field "rTuesday" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rTuesday".
     */
    inline T_TCU_Opening_Hour_Day& getRTuesdayMutable ();

    /**
     * Sets the value of the member "rTuesday".
     *
     * Tuesday
     *
     * @param rTuesday The value which will be set
     */
    inline void setRTuesday (const T_TCU_Opening_Hour_Day& rTuesday_);

    // API of field "rWednesday"

    static const int kRWednesday = 3;

    /**
     * Clears the field "rWednesday".
     *
     * The field will be set to its default value. The hasRWednesday()
     * method will return false.
     */
    inline void clearRWednesday();

    /**
     * Checks whether the field "rWednesday" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRWednesday()). Otherwise it will return false.
     */
    inline bool hasRWednesday () const;

    /**
     * Returns the value of the member "rWednesday".
     *
     * Wednesday
     *
     * @return The value of the field "rWednesday"
     */
    inline const T_TCU_Opening_Hour_Day& getRWednesday () const;

    /**
     * Retrieves the value of the field "rWednesday" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rWednesday".
     */
    inline T_TCU_Opening_Hour_Day& getRWednesdayMutable ();

    /**
     * Sets the value of the member "rWednesday".
     *
     * Wednesday
     *
     * @param rWednesday The value which will be set
     */
    inline void setRWednesday (const T_TCU_Opening_Hour_Day& rWednesday_);

    // API of field "rThursday"

    static const int kRThursday = 4;

    /**
     * Clears the field "rThursday".
     *
     * The field will be set to its default value. The hasRThursday()
     * method will return false.
     */
    inline void clearRThursday();

    /**
     * Checks whether the field "rThursday" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRThursday()). Otherwise it will return false.
     */
    inline bool hasRThursday () const;

    /**
     * Returns the value of the member "rThursday".
     *
     * Thursday
     *
     * @return The value of the field "rThursday"
     */
    inline const T_TCU_Opening_Hour_Day& getRThursday () const;

    /**
     * Retrieves the value of the field "rThursday" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rThursday".
     */
    inline T_TCU_Opening_Hour_Day& getRThursdayMutable ();

    /**
     * Sets the value of the member "rThursday".
     *
     * Thursday
     *
     * @param rThursday The value which will be set
     */
    inline void setRThursday (const T_TCU_Opening_Hour_Day& rThursday_);

    // API of field "rFriday"

    static const int kRFriday = 5;

    /**
     * Clears the field "rFriday".
     *
     * The field will be set to its default value. The hasRFriday()
     * method will return false.
     */
    inline void clearRFriday();

    /**
     * Checks whether the field "rFriday" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRFriday()). Otherwise it will return false.
     */
    inline bool hasRFriday () const;

    /**
     * Returns the value of the member "rFriday".
     *
     * Friday
     *
     * @return The value of the field "rFriday"
     */
    inline const T_TCU_Opening_Hour_Day& getRFriday () const;

    /**
     * Retrieves the value of the field "rFriday" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rFriday".
     */
    inline T_TCU_Opening_Hour_Day& getRFridayMutable ();

    /**
     * Sets the value of the member "rFriday".
     *
     * Friday
     *
     * @param rFriday The value which will be set
     */
    inline void setRFriday (const T_TCU_Opening_Hour_Day& rFriday_);

    // API of field "rSaturday"

    static const int kRSaturday = 6;

    /**
     * Clears the field "rSaturday".
     *
     * The field will be set to its default value. The hasRSaturday()
     * method will return false.
     */
    inline void clearRSaturday();

    /**
     * Checks whether the field "rSaturday" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRSaturday()). Otherwise it will return false.
     */
    inline bool hasRSaturday () const;

    /**
     * Returns the value of the member "rSaturday".
     *
     * Saturday
     *
     * @return The value of the field "rSaturday"
     */
    inline const T_TCU_Opening_Hour_Day& getRSaturday () const;

    /**
     * Retrieves the value of the field "rSaturday" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rSaturday".
     */
    inline T_TCU_Opening_Hour_Day& getRSaturdayMutable ();

    /**
     * Sets the value of the member "rSaturday".
     *
     * Saturday
     *
     * @param rSaturday The value which will be set
     */
    inline void setRSaturday (const T_TCU_Opening_Hour_Day& rSaturday_);

    static const T_TCU_Opening_Hour &getDefaultInstance();

private:

    inline void set_has_rSunday ();

    inline void clear_has_rSunday ();

    inline void set_has_rMonday ();

    inline void clear_has_rMonday ();

    inline void set_has_rTuesday ();

    inline void clear_has_rTuesday ();

    inline void set_has_rWednesday ();

    inline void clear_has_rWednesday ();

    inline void set_has_rThursday ();

    inline void clear_has_rThursday ();

    inline void set_has_rFriday ();

    inline void clear_has_rFriday ();

    inline void set_has_rSaturday ();

    inline void clear_has_rSaturday ();

    uint32 _has_bits_[ (7 + 31) / 32];

    T_TCU_Opening_Hour_Day _rSunday;

    T_TCU_Opening_Hour_Day _rMonday;

    T_TCU_Opening_Hour_Day _rTuesday;

    T_TCU_Opening_Hour_Day _rWednesday;

    T_TCU_Opening_Hour_Day _rThursday;

    T_TCU_Opening_Hour_Day _rFriday;

    T_TCU_Opening_Hour_Day _rSaturday;

};

/**
 * If the meaning of "T_TCU_Full_Address" isn't clear, then there should be a description here.
 */
class T_TCU_Full_Address {
public:

    /**
     * Default constructor
     */
    inline  T_TCU_Full_Address ();

    /**
     * Copy constructor
     */
    inline  T_TCU_Full_Address (const T_TCU_Full_Address &rhs);

    /**
     * All fields constructor
     */
    inline  T_TCU_Full_Address (uint8 u8Length_of_Text_, const ::std::string& sText_Info_);

    /**
     * Destructor
     */
    inline  ~T_TCU_Full_Address();

    /**
     * Assignment operator
     */
    inline T_TCU_Full_Address& operator = (const T_TCU_Full_Address& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TCU_Full_Address& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TCU_Full_Address& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TCU_Full_Address& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TCU_Full_Address& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8Length_of_Text"

    static const int kU8Length_of_Text = 0;

    /**
     * Clears the field "u8Length_of_Text".
     *
     * The field will be set to its default value. The hasU8Length_of_Text()
     * method will return false.
     */
    inline void clearU8Length_of_Text();

    /**
     * Checks whether the field "u8Length_of_Text" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Length_of_Text()). Otherwise it will return false.
     */
    inline bool hasU8Length_of_Text () const;

    /**
     * Returns the value of the member "u8Length_of_Text".
     *
     * If the meaning of "u8Length_of_Text" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Length_of_Text"
     */
    inline uint8 getU8Length_of_Text () const;

    /**
     * Sets the value of the member "u8Length_of_Text".
     *
     * If the meaning of "u8Length_of_Text" isn't clear, then there should be a description here.
     *
     * @param u8Length_of_Text The value which will be set
     */
    inline void setU8Length_of_Text (uint8 u8Length_of_Text_);

    // API of field "sText_Info"

    static const int kSText_Info = 1;

    /**
     * Clears the field "sText_Info".
     *
     * The field will be set to its default value. The hasSText_Info()
     * method will return false.
     */
    inline void clearSText_Info();

    /**
     * Checks whether the field "sText_Info" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSText_Info()). Otherwise it will return false.
     */
    inline bool hasSText_Info () const;

    /**
     * Returns the value of the member "sText_Info".
     *
     * If the meaning of "sText_Info" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sText_Info"
     */
    inline const ::std::string& getSText_Info () const;

    /**
     * Retrieves the value of the field "sText_Info" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sText_Info".
     */
    inline ::std::string& getSText_InfoMutable ();

    /**
     * Sets the value of the member "sText_Info".
     *
     * If the meaning of "sText_Info" isn't clear, then there should be a description here.
     *
     * @param sText_Info The value which will be set
     */
    inline void setSText_Info (const ::std::string& sText_Info_);

    /**
     * Sets the value of the member "sText_Info".
     *
     * If the meaning of "sText_Info" isn't clear, then there should be a description here.
     *
     * @param sText_Info The value which will be set
     */
    inline void setSText_Info (const char* sText_Info_);

    /**
     * Sets the value of the member "sText_Info".
     *
     * If the meaning of "sText_Info" isn't clear, then there should be a description here.
     *
     * @param sText_Info The value which will be set
     */
    inline void setSText_Info (const char* value, size_t size);

    static const T_TCU_Full_Address &getDefaultInstance();

private:

    inline void set_has_u8Length_of_Text ();

    inline void clear_has_u8Length_of_Text ();

    inline void set_has_sText_Info ();

    inline void clear_has_sText_Info ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8Length_of_Text;

    ::std::string _sText_Info;

};

/**
 * If the meaning of "T_TCU_Bookable_Free_Text" isn't clear, then there should be a description here.
 */
class T_TCU_Bookable_Free_Text {
public:

    /**
     * Default constructor
     */
    inline  T_TCU_Bookable_Free_Text ();

    /**
     * Copy constructor
     */
    inline  T_TCU_Bookable_Free_Text (const T_TCU_Bookable_Free_Text &rhs);

    /**
     * All fields constructor
     */
    inline  T_TCU_Bookable_Free_Text (uint8 u8Length_of_Text_, const ::std::string& sText_Info_);

    /**
     * Destructor
     */
    inline  ~T_TCU_Bookable_Free_Text();

    /**
     * Assignment operator
     */
    inline T_TCU_Bookable_Free_Text& operator = (const T_TCU_Bookable_Free_Text& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TCU_Bookable_Free_Text& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TCU_Bookable_Free_Text& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TCU_Bookable_Free_Text& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TCU_Bookable_Free_Text& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8Length_of_Text"

    static const int kU8Length_of_Text = 0;

    /**
     * Clears the field "u8Length_of_Text".
     *
     * The field will be set to its default value. The hasU8Length_of_Text()
     * method will return false.
     */
    inline void clearU8Length_of_Text();

    /**
     * Checks whether the field "u8Length_of_Text" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Length_of_Text()). Otherwise it will return false.
     */
    inline bool hasU8Length_of_Text () const;

    /**
     * Returns the value of the member "u8Length_of_Text".
     *
     * If the meaning of "u8Length_of_Text" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Length_of_Text"
     */
    inline uint8 getU8Length_of_Text () const;

    /**
     * Sets the value of the member "u8Length_of_Text".
     *
     * If the meaning of "u8Length_of_Text" isn't clear, then there should be a description here.
     *
     * @param u8Length_of_Text The value which will be set
     */
    inline void setU8Length_of_Text (uint8 u8Length_of_Text_);

    // API of field "sText_Info"

    static const int kSText_Info = 1;

    /**
     * Clears the field "sText_Info".
     *
     * The field will be set to its default value. The hasSText_Info()
     * method will return false.
     */
    inline void clearSText_Info();

    /**
     * Checks whether the field "sText_Info" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSText_Info()). Otherwise it will return false.
     */
    inline bool hasSText_Info () const;

    /**
     * Returns the value of the member "sText_Info".
     *
     * If the meaning of "sText_Info" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sText_Info"
     */
    inline const ::std::string& getSText_Info () const;

    /**
     * Retrieves the value of the field "sText_Info" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sText_Info".
     */
    inline ::std::string& getSText_InfoMutable ();

    /**
     * Sets the value of the member "sText_Info".
     *
     * If the meaning of "sText_Info" isn't clear, then there should be a description here.
     *
     * @param sText_Info The value which will be set
     */
    inline void setSText_Info (const ::std::string& sText_Info_);

    /**
     * Sets the value of the member "sText_Info".
     *
     * If the meaning of "sText_Info" isn't clear, then there should be a description here.
     *
     * @param sText_Info The value which will be set
     */
    inline void setSText_Info (const char* sText_Info_);

    /**
     * Sets the value of the member "sText_Info".
     *
     * If the meaning of "sText_Info" isn't clear, then there should be a description here.
     *
     * @param sText_Info The value which will be set
     */
    inline void setSText_Info (const char* value, size_t size);

    static const T_TCU_Bookable_Free_Text &getDefaultInstance();

private:

    inline void set_has_u8Length_of_Text ();

    inline void clear_has_u8Length_of_Text ();

    inline void set_has_sText_Info ();

    inline void clear_has_sText_Info ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8Length_of_Text;

    ::std::string _sText_Info;

};

/**
 * If the meaning of "T_TCU_Receptacle" isn't clear, then there should be a description here.
 */
class T_TCU_Receptacle {
public:

    /**
     * Default constructor
     */
    inline  T_TCU_Receptacle ();

    /**
     * Copy constructor
     */
    inline  T_TCU_Receptacle (const T_TCU_Receptacle &rhs);

    /**
     * All fields constructor
     */
    inline  T_TCU_Receptacle (T_e8_TCU_Charge_Receptacle_Type e8Charge_Receptacle_Type_, uint16 u16Available_Power_, T_e8_TCU_Charge_Receptacle_Facility e8Charge_Receptacle_Facility_);

    /**
     * Destructor
     */
    inline  ~T_TCU_Receptacle();

    /**
     * Assignment operator
     */
    inline T_TCU_Receptacle& operator = (const T_TCU_Receptacle& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TCU_Receptacle& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TCU_Receptacle& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TCU_Receptacle& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TCU_Receptacle& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Charge_Receptacle_Type"

    static const int kE8Charge_Receptacle_Type = 0;

    /**
     * Clears the field "e8Charge_Receptacle_Type".
     *
     * The field will be set to its default value. The hasE8Charge_Receptacle_Type()
     * method will return false.
     */
    inline void clearE8Charge_Receptacle_Type();

    /**
     * Checks whether the field "e8Charge_Receptacle_Type" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Charge_Receptacle_Type()). Otherwise it will return false.
     */
    inline bool hasE8Charge_Receptacle_Type () const;

    /**
     * Returns the value of the member "e8Charge_Receptacle_Type".
     *
     * If the meaning of "e8Charge_Receptacle_Type" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Charge_Receptacle_Type"
     */
    inline T_e8_TCU_Charge_Receptacle_Type getE8Charge_Receptacle_Type () const;

    /**
     * Sets the value of the member "e8Charge_Receptacle_Type".
     *
     * If the meaning of "e8Charge_Receptacle_Type" isn't clear, then there should be a description here.
     *
     * @param e8Charge_Receptacle_Type The value which will be set
     */
    inline void setE8Charge_Receptacle_Type (T_e8_TCU_Charge_Receptacle_Type e8Charge_Receptacle_Type_);

    // API of field "u16Available_Power"

    static const int kU16Available_Power = 1;

    /**
     * Clears the field "u16Available_Power".
     *
     * The field will be set to its default value. The hasU16Available_Power()
     * method will return false.
     */
    inline void clearU16Available_Power();

    /**
     * Checks whether the field "u16Available_Power" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16Available_Power()). Otherwise it will return false.
     */
    inline bool hasU16Available_Power () const;

    /**
     * Returns the value of the member "u16Available_Power".
     *
     * If the meaning of "u16Available_Power" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u16Available_Power"
     */
    inline uint16 getU16Available_Power () const;

    /**
     * Sets the value of the member "u16Available_Power".
     *
     * If the meaning of "u16Available_Power" isn't clear, then there should be a description here.
     *
     * @param u16Available_Power The value which will be set
     */
    inline void setU16Available_Power (uint16 u16Available_Power_);

    // API of field "e8Charge_Receptacle_Facility"

    static const int kE8Charge_Receptacle_Facility = 2;

    /**
     * Clears the field "e8Charge_Receptacle_Facility".
     *
     * The field will be set to its default value. The hasE8Charge_Receptacle_Facility()
     * method will return false.
     */
    inline void clearE8Charge_Receptacle_Facility();

    /**
     * Checks whether the field "e8Charge_Receptacle_Facility" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Charge_Receptacle_Facility()). Otherwise it will return false.
     */
    inline bool hasE8Charge_Receptacle_Facility () const;

    /**
     * Returns the value of the member "e8Charge_Receptacle_Facility".
     *
     * If the meaning of "e8Charge_Receptacle_Facility" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Charge_Receptacle_Facility"
     */
    inline T_e8_TCU_Charge_Receptacle_Facility getE8Charge_Receptacle_Facility () const;

    /**
     * Sets the value of the member "e8Charge_Receptacle_Facility".
     *
     * If the meaning of "e8Charge_Receptacle_Facility" isn't clear, then there should be a description here.
     *
     * @param e8Charge_Receptacle_Facility The value which will be set
     */
    inline void setE8Charge_Receptacle_Facility (T_e8_TCU_Charge_Receptacle_Facility e8Charge_Receptacle_Facility_);

    static const T_TCU_Receptacle &getDefaultInstance();

private:

    inline void set_has_e8Charge_Receptacle_Type ();

    inline void clear_has_e8Charge_Receptacle_Type ();

    inline void set_has_u16Available_Power ();

    inline void clear_has_u16Available_Power ();

    inline void set_has_e8Charge_Receptacle_Facility ();

    inline void clear_has_e8Charge_Receptacle_Facility ();

    uint32 _has_bits_[ (3 + 31) / 32];

    T_e8_TCU_Charge_Receptacle_Type _e8Charge_Receptacle_Type;

    uint16 _u16Available_Power;

    T_e8_TCU_Charge_Receptacle_Facility _e8Charge_Receptacle_Facility;

};

/**
 * If the meaning of "T_TCU_Spot_List" isn't clear, then there should be a description here.
 */
class T_TCU_Spot_List {
public:

    /**
     * Default constructor
     */
    inline  T_TCU_Spot_List ();

    /**
     * Copy constructor
     */
    inline  T_TCU_Spot_List (const T_TCU_Spot_List &rhs);

    /**
     * All fields constructor
     */
    inline  T_TCU_Spot_List (const ::std::string& sCharge_Spot_ID_, T_e8_TCU_Bookable_Information e8Bookable_Information_, T_e8_TCU_Spot_Availability e8Spot_Availability_, const T_TCU_Bookable_Free_Text& rBookable_Free_Text_, uint8 u8Total_Number_Receptacles_, const T_TCU_Receptacle& rReceptacle1_, const T_TCU_Receptacle& rReceptacle2_, const T_TCU_Receptacle& rReceptacle3_, const T_TCU_Receptacle& rReceptacle4_, const T_TCU_Receptacle& rReceptacle5_, const T_TCU_Receptacle& rReceptacle6_, const T_TCU_Receptacle& rReceptacle7_, const T_TCU_Receptacle& rReceptacle8_, const T_TCU_Receptacle& rReceptacle9_, const T_TCU_Receptacle& rReceptacle10_);

    /**
     * Destructor
     */
    inline  ~T_TCU_Spot_List();

    /**
     * Assignment operator
     */
    inline T_TCU_Spot_List& operator = (const T_TCU_Spot_List& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TCU_Spot_List& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TCU_Spot_List& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TCU_Spot_List& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TCU_Spot_List& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sCharge_Spot_ID"

    static const int kSCharge_Spot_ID = 0;

    /**
     * Clears the field "sCharge_Spot_ID".
     *
     * The field will be set to its default value. The hasSCharge_Spot_ID()
     * method will return false.
     */
    inline void clearSCharge_Spot_ID();

    /**
     * Checks whether the field "sCharge_Spot_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSCharge_Spot_ID()). Otherwise it will return false.
     */
    inline bool hasSCharge_Spot_ID () const;

    /**
     * Returns the value of the member "sCharge_Spot_ID".
     *
     * If the meaning of "sCharge_Spot_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sCharge_Spot_ID"
     */
    inline const ::std::string& getSCharge_Spot_ID () const;

    /**
     * Retrieves the value of the field "sCharge_Spot_ID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sCharge_Spot_ID".
     */
    inline ::std::string& getSCharge_Spot_IDMutable ();

    /**
     * Sets the value of the member "sCharge_Spot_ID".
     *
     * If the meaning of "sCharge_Spot_ID" isn't clear, then there should be a description here.
     *
     * @param sCharge_Spot_ID The value which will be set
     */
    inline void setSCharge_Spot_ID (const ::std::string& sCharge_Spot_ID_);

    /**
     * Sets the value of the member "sCharge_Spot_ID".
     *
     * If the meaning of "sCharge_Spot_ID" isn't clear, then there should be a description here.
     *
     * @param sCharge_Spot_ID The value which will be set
     */
    inline void setSCharge_Spot_ID (const char* sCharge_Spot_ID_);

    /**
     * Sets the value of the member "sCharge_Spot_ID".
     *
     * If the meaning of "sCharge_Spot_ID" isn't clear, then there should be a description here.
     *
     * @param sCharge_Spot_ID The value which will be set
     */
    inline void setSCharge_Spot_ID (const char* value, size_t size);

    // API of field "e8Bookable_Information"

    static const int kE8Bookable_Information = 1;

    /**
     * Clears the field "e8Bookable_Information".
     *
     * The field will be set to its default value. The hasE8Bookable_Information()
     * method will return false.
     */
    inline void clearE8Bookable_Information();

    /**
     * Checks whether the field "e8Bookable_Information" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Bookable_Information()). Otherwise it will return false.
     */
    inline bool hasE8Bookable_Information () const;

    /**
     * Returns the value of the member "e8Bookable_Information".
     *
     * If the meaning of "e8Bookable_Information" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Bookable_Information"
     */
    inline T_e8_TCU_Bookable_Information getE8Bookable_Information () const;

    /**
     * Sets the value of the member "e8Bookable_Information".
     *
     * If the meaning of "e8Bookable_Information" isn't clear, then there should be a description here.
     *
     * @param e8Bookable_Information The value which will be set
     */
    inline void setE8Bookable_Information (T_e8_TCU_Bookable_Information e8Bookable_Information_);

    // API of field "e8Spot_Availability"

    static const int kE8Spot_Availability = 2;

    /**
     * Clears the field "e8Spot_Availability".
     *
     * The field will be set to its default value. The hasE8Spot_Availability()
     * method will return false.
     */
    inline void clearE8Spot_Availability();

    /**
     * Checks whether the field "e8Spot_Availability" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Spot_Availability()). Otherwise it will return false.
     */
    inline bool hasE8Spot_Availability () const;

    /**
     * Returns the value of the member "e8Spot_Availability".
     *
     * If the meaning of "e8Spot_Availability" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Spot_Availability"
     */
    inline T_e8_TCU_Spot_Availability getE8Spot_Availability () const;

    /**
     * Sets the value of the member "e8Spot_Availability".
     *
     * If the meaning of "e8Spot_Availability" isn't clear, then there should be a description here.
     *
     * @param e8Spot_Availability The value which will be set
     */
    inline void setE8Spot_Availability (T_e8_TCU_Spot_Availability e8Spot_Availability_);

    // API of field "rBookable_Free_Text"

    static const int kRBookable_Free_Text = 3;

    /**
     * Clears the field "rBookable_Free_Text".
     *
     * The field will be set to its default value. The hasRBookable_Free_Text()
     * method will return false.
     */
    inline void clearRBookable_Free_Text();

    /**
     * Checks whether the field "rBookable_Free_Text" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRBookable_Free_Text()). Otherwise it will return false.
     */
    inline bool hasRBookable_Free_Text () const;

    /**
     * Returns the value of the member "rBookable_Free_Text".
     *
     * If the meaning of "rBookable_Free_Text" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rBookable_Free_Text"
     */
    inline const T_TCU_Bookable_Free_Text& getRBookable_Free_Text () const;

    /**
     * Retrieves the value of the field "rBookable_Free_Text" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rBookable_Free_Text".
     */
    inline T_TCU_Bookable_Free_Text& getRBookable_Free_TextMutable ();

    /**
     * Sets the value of the member "rBookable_Free_Text".
     *
     * If the meaning of "rBookable_Free_Text" isn't clear, then there should be a description here.
     *
     * @param rBookable_Free_Text The value which will be set
     */
    inline void setRBookable_Free_Text (const T_TCU_Bookable_Free_Text& rBookable_Free_Text_);

    // API of field "u8Total_Number_Receptacles"

    static const int kU8Total_Number_Receptacles = 4;

    /**
     * Clears the field "u8Total_Number_Receptacles".
     *
     * The field will be set to its default value. The hasU8Total_Number_Receptacles()
     * method will return false.
     */
    inline void clearU8Total_Number_Receptacles();

    /**
     * Checks whether the field "u8Total_Number_Receptacles" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Total_Number_Receptacles()). Otherwise it will return false.
     */
    inline bool hasU8Total_Number_Receptacles () const;

    /**
     * Returns the value of the member "u8Total_Number_Receptacles".
     *
     * If the meaning of "u8Total_Number_Receptacles" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Total_Number_Receptacles"
     */
    inline uint8 getU8Total_Number_Receptacles () const;

    /**
     * Sets the value of the member "u8Total_Number_Receptacles".
     *
     * If the meaning of "u8Total_Number_Receptacles" isn't clear, then there should be a description here.
     *
     * @param u8Total_Number_Receptacles The value which will be set
     */
    inline void setU8Total_Number_Receptacles (uint8 u8Total_Number_Receptacles_);

    // API of field "rReceptacle1"

    static const int kRReceptacle1 = 5;

    /**
     * Clears the field "rReceptacle1".
     *
     * The field will be set to its default value. The hasRReceptacle1()
     * method will return false.
     */
    inline void clearRReceptacle1();

    /**
     * Checks whether the field "rReceptacle1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRReceptacle1()). Otherwise it will return false.
     */
    inline bool hasRReceptacle1 () const;

    /**
     * Returns the value of the member "rReceptacle1".
     *
     * If the meaning of "rReceptacle1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rReceptacle1"
     */
    inline const T_TCU_Receptacle& getRReceptacle1 () const;

    /**
     * Retrieves the value of the field "rReceptacle1" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rReceptacle1".
     */
    inline T_TCU_Receptacle& getRReceptacle1Mutable ();

    /**
     * Sets the value of the member "rReceptacle1".
     *
     * If the meaning of "rReceptacle1" isn't clear, then there should be a description here.
     *
     * @param rReceptacle1 The value which will be set
     */
    inline void setRReceptacle1 (const T_TCU_Receptacle& rReceptacle1_);

    // API of field "rReceptacle2"

    static const int kRReceptacle2 = 6;

    /**
     * Clears the field "rReceptacle2".
     *
     * The field will be set to its default value. The hasRReceptacle2()
     * method will return false.
     */
    inline void clearRReceptacle2();

    /**
     * Checks whether the field "rReceptacle2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRReceptacle2()). Otherwise it will return false.
     */
    inline bool hasRReceptacle2 () const;

    /**
     * Returns the value of the member "rReceptacle2".
     *
     * If the meaning of "rReceptacle2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rReceptacle2"
     */
    inline const T_TCU_Receptacle& getRReceptacle2 () const;

    /**
     * Retrieves the value of the field "rReceptacle2" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rReceptacle2".
     */
    inline T_TCU_Receptacle& getRReceptacle2Mutable ();

    /**
     * Sets the value of the member "rReceptacle2".
     *
     * If the meaning of "rReceptacle2" isn't clear, then there should be a description here.
     *
     * @param rReceptacle2 The value which will be set
     */
    inline void setRReceptacle2 (const T_TCU_Receptacle& rReceptacle2_);

    // API of field "rReceptacle3"

    static const int kRReceptacle3 = 7;

    /**
     * Clears the field "rReceptacle3".
     *
     * The field will be set to its default value. The hasRReceptacle3()
     * method will return false.
     */
    inline void clearRReceptacle3();

    /**
     * Checks whether the field "rReceptacle3" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRReceptacle3()). Otherwise it will return false.
     */
    inline bool hasRReceptacle3 () const;

    /**
     * Returns the value of the member "rReceptacle3".
     *
     * If the meaning of "rReceptacle3" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rReceptacle3"
     */
    inline const T_TCU_Receptacle& getRReceptacle3 () const;

    /**
     * Retrieves the value of the field "rReceptacle3" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rReceptacle3".
     */
    inline T_TCU_Receptacle& getRReceptacle3Mutable ();

    /**
     * Sets the value of the member "rReceptacle3".
     *
     * If the meaning of "rReceptacle3" isn't clear, then there should be a description here.
     *
     * @param rReceptacle3 The value which will be set
     */
    inline void setRReceptacle3 (const T_TCU_Receptacle& rReceptacle3_);

    // API of field "rReceptacle4"

    static const int kRReceptacle4 = 8;

    /**
     * Clears the field "rReceptacle4".
     *
     * The field will be set to its default value. The hasRReceptacle4()
     * method will return false.
     */
    inline void clearRReceptacle4();

    /**
     * Checks whether the field "rReceptacle4" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRReceptacle4()). Otherwise it will return false.
     */
    inline bool hasRReceptacle4 () const;

    /**
     * Returns the value of the member "rReceptacle4".
     *
     * If the meaning of "rReceptacle4" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rReceptacle4"
     */
    inline const T_TCU_Receptacle& getRReceptacle4 () const;

    /**
     * Retrieves the value of the field "rReceptacle4" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rReceptacle4".
     */
    inline T_TCU_Receptacle& getRReceptacle4Mutable ();

    /**
     * Sets the value of the member "rReceptacle4".
     *
     * If the meaning of "rReceptacle4" isn't clear, then there should be a description here.
     *
     * @param rReceptacle4 The value which will be set
     */
    inline void setRReceptacle4 (const T_TCU_Receptacle& rReceptacle4_);

    // API of field "rReceptacle5"

    static const int kRReceptacle5 = 9;

    /**
     * Clears the field "rReceptacle5".
     *
     * The field will be set to its default value. The hasRReceptacle5()
     * method will return false.
     */
    inline void clearRReceptacle5();

    /**
     * Checks whether the field "rReceptacle5" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRReceptacle5()). Otherwise it will return false.
     */
    inline bool hasRReceptacle5 () const;

    /**
     * Returns the value of the member "rReceptacle5".
     *
     * If the meaning of "rReceptacle5" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rReceptacle5"
     */
    inline const T_TCU_Receptacle& getRReceptacle5 () const;

    /**
     * Retrieves the value of the field "rReceptacle5" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rReceptacle5".
     */
    inline T_TCU_Receptacle& getRReceptacle5Mutable ();

    /**
     * Sets the value of the member "rReceptacle5".
     *
     * If the meaning of "rReceptacle5" isn't clear, then there should be a description here.
     *
     * @param rReceptacle5 The value which will be set
     */
    inline void setRReceptacle5 (const T_TCU_Receptacle& rReceptacle5_);

    // API of field "rReceptacle6"

    static const int kRReceptacle6 = 10;

    /**
     * Clears the field "rReceptacle6".
     *
     * The field will be set to its default value. The hasRReceptacle6()
     * method will return false.
     */
    inline void clearRReceptacle6();

    /**
     * Checks whether the field "rReceptacle6" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRReceptacle6()). Otherwise it will return false.
     */
    inline bool hasRReceptacle6 () const;

    /**
     * Returns the value of the member "rReceptacle6".
     *
     * If the meaning of "rReceptacle6" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rReceptacle6"
     */
    inline const T_TCU_Receptacle& getRReceptacle6 () const;

    /**
     * Retrieves the value of the field "rReceptacle6" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rReceptacle6".
     */
    inline T_TCU_Receptacle& getRReceptacle6Mutable ();

    /**
     * Sets the value of the member "rReceptacle6".
     *
     * If the meaning of "rReceptacle6" isn't clear, then there should be a description here.
     *
     * @param rReceptacle6 The value which will be set
     */
    inline void setRReceptacle6 (const T_TCU_Receptacle& rReceptacle6_);

    // API of field "rReceptacle7"

    static const int kRReceptacle7 = 11;

    /**
     * Clears the field "rReceptacle7".
     *
     * The field will be set to its default value. The hasRReceptacle7()
     * method will return false.
     */
    inline void clearRReceptacle7();

    /**
     * Checks whether the field "rReceptacle7" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRReceptacle7()). Otherwise it will return false.
     */
    inline bool hasRReceptacle7 () const;

    /**
     * Returns the value of the member "rReceptacle7".
     *
     * If the meaning of "rReceptacle7" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rReceptacle7"
     */
    inline const T_TCU_Receptacle& getRReceptacle7 () const;

    /**
     * Retrieves the value of the field "rReceptacle7" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rReceptacle7".
     */
    inline T_TCU_Receptacle& getRReceptacle7Mutable ();

    /**
     * Sets the value of the member "rReceptacle7".
     *
     * If the meaning of "rReceptacle7" isn't clear, then there should be a description here.
     *
     * @param rReceptacle7 The value which will be set
     */
    inline void setRReceptacle7 (const T_TCU_Receptacle& rReceptacle7_);

    // API of field "rReceptacle8"

    static const int kRReceptacle8 = 12;

    /**
     * Clears the field "rReceptacle8".
     *
     * The field will be set to its default value. The hasRReceptacle8()
     * method will return false.
     */
    inline void clearRReceptacle8();

    /**
     * Checks whether the field "rReceptacle8" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRReceptacle8()). Otherwise it will return false.
     */
    inline bool hasRReceptacle8 () const;

    /**
     * Returns the value of the member "rReceptacle8".
     *
     * If the meaning of "rReceptacle8" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rReceptacle8"
     */
    inline const T_TCU_Receptacle& getRReceptacle8 () const;

    /**
     * Retrieves the value of the field "rReceptacle8" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rReceptacle8".
     */
    inline T_TCU_Receptacle& getRReceptacle8Mutable ();

    /**
     * Sets the value of the member "rReceptacle8".
     *
     * If the meaning of "rReceptacle8" isn't clear, then there should be a description here.
     *
     * @param rReceptacle8 The value which will be set
     */
    inline void setRReceptacle8 (const T_TCU_Receptacle& rReceptacle8_);

    // API of field "rReceptacle9"

    static const int kRReceptacle9 = 13;

    /**
     * Clears the field "rReceptacle9".
     *
     * The field will be set to its default value. The hasRReceptacle9()
     * method will return false.
     */
    inline void clearRReceptacle9();

    /**
     * Checks whether the field "rReceptacle9" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRReceptacle9()). Otherwise it will return false.
     */
    inline bool hasRReceptacle9 () const;

    /**
     * Returns the value of the member "rReceptacle9".
     *
     * If the meaning of "rReceptacle9" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rReceptacle9"
     */
    inline const T_TCU_Receptacle& getRReceptacle9 () const;

    /**
     * Retrieves the value of the field "rReceptacle9" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rReceptacle9".
     */
    inline T_TCU_Receptacle& getRReceptacle9Mutable ();

    /**
     * Sets the value of the member "rReceptacle9".
     *
     * If the meaning of "rReceptacle9" isn't clear, then there should be a description here.
     *
     * @param rReceptacle9 The value which will be set
     */
    inline void setRReceptacle9 (const T_TCU_Receptacle& rReceptacle9_);

    // API of field "rReceptacle10"

    static const int kRReceptacle10 = 14;

    /**
     * Clears the field "rReceptacle10".
     *
     * The field will be set to its default value. The hasRReceptacle10()
     * method will return false.
     */
    inline void clearRReceptacle10();

    /**
     * Checks whether the field "rReceptacle10" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRReceptacle10()). Otherwise it will return false.
     */
    inline bool hasRReceptacle10 () const;

    /**
     * Returns the value of the member "rReceptacle10".
     *
     * If the meaning of "rReceptacle10" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rReceptacle10"
     */
    inline const T_TCU_Receptacle& getRReceptacle10 () const;

    /**
     * Retrieves the value of the field "rReceptacle10" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rReceptacle10".
     */
    inline T_TCU_Receptacle& getRReceptacle10Mutable ();

    /**
     * Sets the value of the member "rReceptacle10".
     *
     * If the meaning of "rReceptacle10" isn't clear, then there should be a description here.
     *
     * @param rReceptacle10 The value which will be set
     */
    inline void setRReceptacle10 (const T_TCU_Receptacle& rReceptacle10_);

    static const T_TCU_Spot_List &getDefaultInstance();

private:

    inline void set_has_sCharge_Spot_ID ();

    inline void clear_has_sCharge_Spot_ID ();

    inline void set_has_e8Bookable_Information ();

    inline void clear_has_e8Bookable_Information ();

    inline void set_has_e8Spot_Availability ();

    inline void clear_has_e8Spot_Availability ();

    inline void set_has_rBookable_Free_Text ();

    inline void clear_has_rBookable_Free_Text ();

    inline void set_has_u8Total_Number_Receptacles ();

    inline void clear_has_u8Total_Number_Receptacles ();

    inline void set_has_rReceptacle1 ();

    inline void clear_has_rReceptacle1 ();

    inline void set_has_rReceptacle2 ();

    inline void clear_has_rReceptacle2 ();

    inline void set_has_rReceptacle3 ();

    inline void clear_has_rReceptacle3 ();

    inline void set_has_rReceptacle4 ();

    inline void clear_has_rReceptacle4 ();

    inline void set_has_rReceptacle5 ();

    inline void clear_has_rReceptacle5 ();

    inline void set_has_rReceptacle6 ();

    inline void clear_has_rReceptacle6 ();

    inline void set_has_rReceptacle7 ();

    inline void clear_has_rReceptacle7 ();

    inline void set_has_rReceptacle8 ();

    inline void clear_has_rReceptacle8 ();

    inline void set_has_rReceptacle9 ();

    inline void clear_has_rReceptacle9 ();

    inline void set_has_rReceptacle10 ();

    inline void clear_has_rReceptacle10 ();

    uint32 _has_bits_[ (15 + 31) / 32];

    ::std::string _sCharge_Spot_ID;

    T_e8_TCU_Bookable_Information _e8Bookable_Information;

    T_e8_TCU_Spot_Availability _e8Spot_Availability;

    T_TCU_Bookable_Free_Text _rBookable_Free_Text;

    uint8 _u8Total_Number_Receptacles;

    T_TCU_Receptacle _rReceptacle1;

    T_TCU_Receptacle _rReceptacle2;

    T_TCU_Receptacle _rReceptacle3;

    T_TCU_Receptacle _rReceptacle4;

    T_TCU_Receptacle _rReceptacle5;

    T_TCU_Receptacle _rReceptacle6;

    T_TCU_Receptacle _rReceptacle7;

    T_TCU_Receptacle _rReceptacle8;

    T_TCU_Receptacle _rReceptacle9;

    T_TCU_Receptacle _rReceptacle10;

};

/**
 * If the meaning of "T_TCU_Charge_Spot_List" isn't clear, then there should be a description here.
 */
class T_TCU_Charge_Spot_List {
public:

    /**
     * Default constructor
     */
    inline  T_TCU_Charge_Spot_List ();

    /**
     * Copy constructor
     */
    inline  T_TCU_Charge_Spot_List (const T_TCU_Charge_Spot_List &rhs);

    /**
     * All fields constructor
     */
    inline  T_TCU_Charge_Spot_List (uint8 u8Total_pages_of_lists_, uint8 u8Pages_of_list_, uint8 u8Station_List_Number_, const T_TCU_Spot_List& rSpot_List1_, const T_TCU_Spot_List& rSpot_List2_, const T_TCU_Spot_List& rSpot_List3_, const T_TCU_Spot_List& rSpot_List4_);

    /**
     * Destructor
     */
    inline  ~T_TCU_Charge_Spot_List();

    /**
     * Assignment operator
     */
    inline T_TCU_Charge_Spot_List& operator = (const T_TCU_Charge_Spot_List& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TCU_Charge_Spot_List& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TCU_Charge_Spot_List& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TCU_Charge_Spot_List& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TCU_Charge_Spot_List& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8Total_pages_of_lists"

    static const int kU8Total_pages_of_lists = 0;

    /**
     * Clears the field "u8Total_pages_of_lists".
     *
     * The field will be set to its default value. The hasU8Total_pages_of_lists()
     * method will return false.
     */
    inline void clearU8Total_pages_of_lists();

    /**
     * Checks whether the field "u8Total_pages_of_lists" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Total_pages_of_lists()). Otherwise it will return false.
     */
    inline bool hasU8Total_pages_of_lists () const;

    /**
     * Returns the value of the member "u8Total_pages_of_lists".
     *
     * If the meaning of "u8Total_pages_of_lists" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Total_pages_of_lists"
     */
    inline uint8 getU8Total_pages_of_lists () const;

    /**
     * Sets the value of the member "u8Total_pages_of_lists".
     *
     * If the meaning of "u8Total_pages_of_lists" isn't clear, then there should be a description here.
     *
     * @param u8Total_pages_of_lists The value which will be set
     */
    inline void setU8Total_pages_of_lists (uint8 u8Total_pages_of_lists_);

    // API of field "u8Pages_of_list"

    static const int kU8Pages_of_list = 1;

    /**
     * Clears the field "u8Pages_of_list".
     *
     * The field will be set to its default value. The hasU8Pages_of_list()
     * method will return false.
     */
    inline void clearU8Pages_of_list();

    /**
     * Checks whether the field "u8Pages_of_list" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Pages_of_list()). Otherwise it will return false.
     */
    inline bool hasU8Pages_of_list () const;

    /**
     * Returns the value of the member "u8Pages_of_list".
     *
     * If the meaning of "u8Pages_of_list" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Pages_of_list"
     */
    inline uint8 getU8Pages_of_list () const;

    /**
     * Sets the value of the member "u8Pages_of_list".
     *
     * If the meaning of "u8Pages_of_list" isn't clear, then there should be a description here.
     *
     * @param u8Pages_of_list The value which will be set
     */
    inline void setU8Pages_of_list (uint8 u8Pages_of_list_);

    // API of field "u8Station_List_Number"

    static const int kU8Station_List_Number = 2;

    /**
     * Clears the field "u8Station_List_Number".
     *
     * The field will be set to its default value. The hasU8Station_List_Number()
     * method will return false.
     */
    inline void clearU8Station_List_Number();

    /**
     * Checks whether the field "u8Station_List_Number" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Station_List_Number()). Otherwise it will return false.
     */
    inline bool hasU8Station_List_Number () const;

    /**
     * Returns the value of the member "u8Station_List_Number".
     *
     * If the meaning of "u8Station_List_Number" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Station_List_Number"
     */
    inline uint8 getU8Station_List_Number () const;

    /**
     * Sets the value of the member "u8Station_List_Number".
     *
     * If the meaning of "u8Station_List_Number" isn't clear, then there should be a description here.
     *
     * @param u8Station_List_Number The value which will be set
     */
    inline void setU8Station_List_Number (uint8 u8Station_List_Number_);

    // API of field "rSpot_List1"

    static const int kRSpot_List1 = 3;

    /**
     * Clears the field "rSpot_List1".
     *
     * The field will be set to its default value. The hasRSpot_List1()
     * method will return false.
     */
    inline void clearRSpot_List1();

    /**
     * Checks whether the field "rSpot_List1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRSpot_List1()). Otherwise it will return false.
     */
    inline bool hasRSpot_List1 () const;

    /**
     * Returns the value of the member "rSpot_List1".
     *
     * If the meaning of "rSpot_List1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rSpot_List1"
     */
    inline const T_TCU_Spot_List& getRSpot_List1 () const;

    /**
     * Retrieves the value of the field "rSpot_List1" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rSpot_List1".
     */
    inline T_TCU_Spot_List& getRSpot_List1Mutable ();

    /**
     * Sets the value of the member "rSpot_List1".
     *
     * If the meaning of "rSpot_List1" isn't clear, then there should be a description here.
     *
     * @param rSpot_List1 The value which will be set
     */
    inline void setRSpot_List1 (const T_TCU_Spot_List& rSpot_List1_);

    // API of field "rSpot_List2"

    static const int kRSpot_List2 = 4;

    /**
     * Clears the field "rSpot_List2".
     *
     * The field will be set to its default value. The hasRSpot_List2()
     * method will return false.
     */
    inline void clearRSpot_List2();

    /**
     * Checks whether the field "rSpot_List2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRSpot_List2()). Otherwise it will return false.
     */
    inline bool hasRSpot_List2 () const;

    /**
     * Returns the value of the member "rSpot_List2".
     *
     * If the meaning of "rSpot_List2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rSpot_List2"
     */
    inline const T_TCU_Spot_List& getRSpot_List2 () const;

    /**
     * Retrieves the value of the field "rSpot_List2" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rSpot_List2".
     */
    inline T_TCU_Spot_List& getRSpot_List2Mutable ();

    /**
     * Sets the value of the member "rSpot_List2".
     *
     * If the meaning of "rSpot_List2" isn't clear, then there should be a description here.
     *
     * @param rSpot_List2 The value which will be set
     */
    inline void setRSpot_List2 (const T_TCU_Spot_List& rSpot_List2_);

    // API of field "rSpot_List3"

    static const int kRSpot_List3 = 5;

    /**
     * Clears the field "rSpot_List3".
     *
     * The field will be set to its default value. The hasRSpot_List3()
     * method will return false.
     */
    inline void clearRSpot_List3();

    /**
     * Checks whether the field "rSpot_List3" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRSpot_List3()). Otherwise it will return false.
     */
    inline bool hasRSpot_List3 () const;

    /**
     * Returns the value of the member "rSpot_List3".
     *
     * If the meaning of "rSpot_List3" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rSpot_List3"
     */
    inline const T_TCU_Spot_List& getRSpot_List3 () const;

    /**
     * Retrieves the value of the field "rSpot_List3" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rSpot_List3".
     */
    inline T_TCU_Spot_List& getRSpot_List3Mutable ();

    /**
     * Sets the value of the member "rSpot_List3".
     *
     * If the meaning of "rSpot_List3" isn't clear, then there should be a description here.
     *
     * @param rSpot_List3 The value which will be set
     */
    inline void setRSpot_List3 (const T_TCU_Spot_List& rSpot_List3_);

    // API of field "rSpot_List4"

    static const int kRSpot_List4 = 6;

    /**
     * Clears the field "rSpot_List4".
     *
     * The field will be set to its default value. The hasRSpot_List4()
     * method will return false.
     */
    inline void clearRSpot_List4();

    /**
     * Checks whether the field "rSpot_List4" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRSpot_List4()). Otherwise it will return false.
     */
    inline bool hasRSpot_List4 () const;

    /**
     * Returns the value of the member "rSpot_List4".
     *
     * If the meaning of "rSpot_List4" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rSpot_List4"
     */
    inline const T_TCU_Spot_List& getRSpot_List4 () const;

    /**
     * Retrieves the value of the field "rSpot_List4" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rSpot_List4".
     */
    inline T_TCU_Spot_List& getRSpot_List4Mutable ();

    /**
     * Sets the value of the member "rSpot_List4".
     *
     * If the meaning of "rSpot_List4" isn't clear, then there should be a description here.
     *
     * @param rSpot_List4 The value which will be set
     */
    inline void setRSpot_List4 (const T_TCU_Spot_List& rSpot_List4_);

    static const T_TCU_Charge_Spot_List &getDefaultInstance();

private:

    inline void set_has_u8Total_pages_of_lists ();

    inline void clear_has_u8Total_pages_of_lists ();

    inline void set_has_u8Pages_of_list ();

    inline void clear_has_u8Pages_of_list ();

    inline void set_has_u8Station_List_Number ();

    inline void clear_has_u8Station_List_Number ();

    inline void set_has_rSpot_List1 ();

    inline void clear_has_rSpot_List1 ();

    inline void set_has_rSpot_List2 ();

    inline void clear_has_rSpot_List2 ();

    inline void set_has_rSpot_List3 ();

    inline void clear_has_rSpot_List3 ();

    inline void set_has_rSpot_List4 ();

    inline void clear_has_rSpot_List4 ();

    uint32 _has_bits_[ (7 + 31) / 32];

    uint8 _u8Total_pages_of_lists;

    uint8 _u8Pages_of_list;

    uint8 _u8Station_List_Number;

    T_TCU_Spot_List _rSpot_List1;

    T_TCU_Spot_List _rSpot_List2;

    T_TCU_Spot_List _rSpot_List3;

    T_TCU_Spot_List _rSpot_List4;

};

/**
 * If the meaning of "T_TCU_Time" isn't clear, then there should be a description here.
 */
class T_TCU_Time {
public:

    /**
     * Default constructor
     */
    inline  T_TCU_Time ();

    /**
     * Copy constructor
     */
    inline  T_TCU_Time (const T_TCU_Time &rhs);

    /**
     * All fields constructor
     */
    inline  T_TCU_Time (uint8 u8Hour_, uint8 u8Minute_, uint8 u8Seconds_);

    /**
     * Destructor
     */
    inline  ~T_TCU_Time();

    /**
     * Assignment operator
     */
    inline T_TCU_Time& operator = (const T_TCU_Time& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TCU_Time& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TCU_Time& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TCU_Time& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TCU_Time& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8Hour"

    static const int kU8Hour = 0;

    /**
     * Clears the field "u8Hour".
     *
     * The field will be set to its default value. The hasU8Hour()
     * method will return false.
     */
    inline void clearU8Hour();

    /**
     * Checks whether the field "u8Hour" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Hour()). Otherwise it will return false.
     */
    inline bool hasU8Hour () const;

    /**
     * Returns the value of the member "u8Hour".
     *
     * If the meaning of "u8Hour" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Hour"
     */
    inline uint8 getU8Hour () const;

    /**
     * Sets the value of the member "u8Hour".
     *
     * If the meaning of "u8Hour" isn't clear, then there should be a description here.
     *
     * @param u8Hour The value which will be set
     */
    inline void setU8Hour (uint8 u8Hour_);

    // API of field "u8Minute"

    static const int kU8Minute = 1;

    /**
     * Clears the field "u8Minute".
     *
     * The field will be set to its default value. The hasU8Minute()
     * method will return false.
     */
    inline void clearU8Minute();

    /**
     * Checks whether the field "u8Minute" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Minute()). Otherwise it will return false.
     */
    inline bool hasU8Minute () const;

    /**
     * Returns the value of the member "u8Minute".
     *
     * If the meaning of "u8Minute" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Minute"
     */
    inline uint8 getU8Minute () const;

    /**
     * Sets the value of the member "u8Minute".
     *
     * If the meaning of "u8Minute" isn't clear, then there should be a description here.
     *
     * @param u8Minute The value which will be set
     */
    inline void setU8Minute (uint8 u8Minute_);

    // API of field "u8Seconds"

    static const int kU8Seconds = 2;

    /**
     * Clears the field "u8Seconds".
     *
     * The field will be set to its default value. The hasU8Seconds()
     * method will return false.
     */
    inline void clearU8Seconds();

    /**
     * Checks whether the field "u8Seconds" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Seconds()). Otherwise it will return false.
     */
    inline bool hasU8Seconds () const;

    /**
     * Returns the value of the member "u8Seconds".
     *
     * If the meaning of "u8Seconds" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Seconds"
     */
    inline uint8 getU8Seconds () const;

    /**
     * Sets the value of the member "u8Seconds".
     *
     * If the meaning of "u8Seconds" isn't clear, then there should be a description here.
     *
     * @param u8Seconds The value which will be set
     */
    inline void setU8Seconds (uint8 u8Seconds_);

    static const T_TCU_Time &getDefaultInstance();

private:

    inline void set_has_u8Hour ();

    inline void clear_has_u8Hour ();

    inline void set_has_u8Minute ();

    inline void clear_has_u8Minute ();

    inline void set_has_u8Seconds ();

    inline void clear_has_u8Seconds ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _u8Hour;

    uint8 _u8Minute;

    uint8 _u8Seconds;

};

/**
 * If the meaning of "T_TCU_Navigation_Language" isn't clear, then there should be a description here.
 */
class T_TCU_Navigation_Language {
public:

    /**
     * Default constructor
     */
    inline  T_TCU_Navigation_Language ();

    /**
     * Copy constructor
     */
    inline  T_TCU_Navigation_Language (const T_TCU_Navigation_Language &rhs);

    /**
     * All fields constructor
     */
    inline  T_TCU_Navigation_Language (uint8 u8Reserved_, T_e8_Language_Family_Type e8Language_Family_Type_, T_e8_Language_Type e8Language_Type_);

    /**
     * Destructor
     */
    inline  ~T_TCU_Navigation_Language();

    /**
     * Assignment operator
     */
    inline T_TCU_Navigation_Language& operator = (const T_TCU_Navigation_Language& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TCU_Navigation_Language& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TCU_Navigation_Language& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TCU_Navigation_Language& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TCU_Navigation_Language& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8Reserved"

    static const int kU8Reserved = 0;

    /**
     * Clears the field "u8Reserved".
     *
     * The field will be set to its default value. The hasU8Reserved()
     * method will return false.
     */
    inline void clearU8Reserved();

    /**
     * Checks whether the field "u8Reserved" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Reserved()). Otherwise it will return false.
     */
    inline bool hasU8Reserved () const;

    /**
     * Returns the value of the member "u8Reserved".
     *
     * If the meaning of "u8Reserved" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Reserved"
     */
    inline uint8 getU8Reserved () const;

    /**
     * Sets the value of the member "u8Reserved".
     *
     * If the meaning of "u8Reserved" isn't clear, then there should be a description here.
     *
     * @param u8Reserved The value which will be set
     */
    inline void setU8Reserved (uint8 u8Reserved_);

    // API of field "e8Language_Family_Type"

    static const int kE8Language_Family_Type = 1;

    /**
     * Clears the field "e8Language_Family_Type".
     *
     * The field will be set to its default value. The hasE8Language_Family_Type()
     * method will return false.
     */
    inline void clearE8Language_Family_Type();

    /**
     * Checks whether the field "e8Language_Family_Type" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Language_Family_Type()). Otherwise it will return false.
     */
    inline bool hasE8Language_Family_Type () const;

    /**
     * Returns the value of the member "e8Language_Family_Type".
     *
     * If the meaning of "e8Language_Family_Type" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Language_Family_Type"
     */
    inline T_e8_Language_Family_Type getE8Language_Family_Type () const;

    /**
     * Sets the value of the member "e8Language_Family_Type".
     *
     * If the meaning of "e8Language_Family_Type" isn't clear, then there should be a description here.
     *
     * @param e8Language_Family_Type The value which will be set
     */
    inline void setE8Language_Family_Type (T_e8_Language_Family_Type e8Language_Family_Type_);

    // API of field "e8Language_Type"

    static const int kE8Language_Type = 2;

    /**
     * Clears the field "e8Language_Type".
     *
     * The field will be set to its default value. The hasE8Language_Type()
     * method will return false.
     */
    inline void clearE8Language_Type();

    /**
     * Checks whether the field "e8Language_Type" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Language_Type()). Otherwise it will return false.
     */
    inline bool hasE8Language_Type () const;

    /**
     * Returns the value of the member "e8Language_Type".
     *
     * If the meaning of "e8Language_Type" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Language_Type"
     */
    inline T_e8_Language_Type getE8Language_Type () const;

    /**
     * Sets the value of the member "e8Language_Type".
     *
     * If the meaning of "e8Language_Type" isn't clear, then there should be a description here.
     *
     * @param e8Language_Type The value which will be set
     */
    inline void setE8Language_Type (T_e8_Language_Type e8Language_Type_);

    static const T_TCU_Navigation_Language &getDefaultInstance();

private:

    inline void set_has_u8Reserved ();

    inline void clear_has_u8Reserved ();

    inline void set_has_e8Language_Family_Type ();

    inline void clear_has_e8Language_Family_Type ();

    inline void set_has_e8Language_Type ();

    inline void clear_has_e8Language_Type ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _u8Reserved;

    T_e8_Language_Family_Type _e8Language_Family_Type;

    T_e8_Language_Type _e8Language_Type;

};

/**
 * If the meaning of "T_TCU_Charge_Days" isn't clear, then there should be a description here.
 */
class T_TCU_Charge_Days {
public:

    /**
     * Default constructor
     */
    inline  T_TCU_Charge_Days ();

    /**
     * Copy constructor
     */
    inline  T_TCU_Charge_Days (const T_TCU_Charge_Days &rhs);

    /**
     * All fields constructor
     */
    inline  T_TCU_Charge_Days (uint8 Day1_, uint8 Day2_, uint8 Day3_, uint8 Day4_, uint8 Day5_, uint8 Day6_, uint8 Day7_);

    /**
     * Destructor
     */
    inline  ~T_TCU_Charge_Days();

    /**
     * Assignment operator
     */
    inline T_TCU_Charge_Days& operator = (const T_TCU_Charge_Days& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TCU_Charge_Days& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TCU_Charge_Days& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TCU_Charge_Days& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TCU_Charge_Days& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Day1"

    static const int kDay1 = 0;

    /**
     * Clears the field "Day1".
     *
     * The field will be set to its default value. The hasDay1()
     * method will return false.
     */
    inline void clearDay1();

    /**
     * Checks whether the field "Day1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDay1()). Otherwise it will return false.
     */
    inline bool hasDay1 () const;

    /**
     * Returns the value of the member "Day1".
     *
     * Day 1
     *
     * @return The value of the field "Day1"
     */
    inline uint8 getDay1 () const;

    /**
     * Sets the value of the member "Day1".
     *
     * Day 1
     *
     * @param Day1 The value which will be set
     */
    inline void setDay1 (uint8 Day1_);

    // API of field "Day2"

    static const int kDay2 = 1;

    /**
     * Clears the field "Day2".
     *
     * The field will be set to its default value. The hasDay2()
     * method will return false.
     */
    inline void clearDay2();

    /**
     * Checks whether the field "Day2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDay2()). Otherwise it will return false.
     */
    inline bool hasDay2 () const;

    /**
     * Returns the value of the member "Day2".
     *
     * Day 2
     *
     * @return The value of the field "Day2"
     */
    inline uint8 getDay2 () const;

    /**
     * Sets the value of the member "Day2".
     *
     * Day 2
     *
     * @param Day2 The value which will be set
     */
    inline void setDay2 (uint8 Day2_);

    // API of field "Day3"

    static const int kDay3 = 2;

    /**
     * Clears the field "Day3".
     *
     * The field will be set to its default value. The hasDay3()
     * method will return false.
     */
    inline void clearDay3();

    /**
     * Checks whether the field "Day3" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDay3()). Otherwise it will return false.
     */
    inline bool hasDay3 () const;

    /**
     * Returns the value of the member "Day3".
     *
     * Day 3
     *
     * @return The value of the field "Day3"
     */
    inline uint8 getDay3 () const;

    /**
     * Sets the value of the member "Day3".
     *
     * Day 3
     *
     * @param Day3 The value which will be set
     */
    inline void setDay3 (uint8 Day3_);

    // API of field "Day4"

    static const int kDay4 = 3;

    /**
     * Clears the field "Day4".
     *
     * The field will be set to its default value. The hasDay4()
     * method will return false.
     */
    inline void clearDay4();

    /**
     * Checks whether the field "Day4" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDay4()). Otherwise it will return false.
     */
    inline bool hasDay4 () const;

    /**
     * Returns the value of the member "Day4".
     *
     * Day 4
     *
     * @return The value of the field "Day4"
     */
    inline uint8 getDay4 () const;

    /**
     * Sets the value of the member "Day4".
     *
     * Day 4
     *
     * @param Day4 The value which will be set
     */
    inline void setDay4 (uint8 Day4_);

    // API of field "Day5"

    static const int kDay5 = 4;

    /**
     * Clears the field "Day5".
     *
     * The field will be set to its default value. The hasDay5()
     * method will return false.
     */
    inline void clearDay5();

    /**
     * Checks whether the field "Day5" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDay5()). Otherwise it will return false.
     */
    inline bool hasDay5 () const;

    /**
     * Returns the value of the member "Day5".
     *
     * Day 5
     *
     * @return The value of the field "Day5"
     */
    inline uint8 getDay5 () const;

    /**
     * Sets the value of the member "Day5".
     *
     * Day 5
     *
     * @param Day5 The value which will be set
     */
    inline void setDay5 (uint8 Day5_);

    // API of field "Day6"

    static const int kDay6 = 5;

    /**
     * Clears the field "Day6".
     *
     * The field will be set to its default value. The hasDay6()
     * method will return false.
     */
    inline void clearDay6();

    /**
     * Checks whether the field "Day6" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDay6()). Otherwise it will return false.
     */
    inline bool hasDay6 () const;

    /**
     * Returns the value of the member "Day6".
     *
     * Day 6
     *
     * @return The value of the field "Day6"
     */
    inline uint8 getDay6 () const;

    /**
     * Sets the value of the member "Day6".
     *
     * Day 6
     *
     * @param Day6 The value which will be set
     */
    inline void setDay6 (uint8 Day6_);

    // API of field "Day7"

    static const int kDay7 = 6;

    /**
     * Clears the field "Day7".
     *
     * The field will be set to its default value. The hasDay7()
     * method will return false.
     */
    inline void clearDay7();

    /**
     * Checks whether the field "Day7" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDay7()). Otherwise it will return false.
     */
    inline bool hasDay7 () const;

    /**
     * Returns the value of the member "Day7".
     *
     * Day 7
     *
     * @return The value of the field "Day7"
     */
    inline uint8 getDay7 () const;

    /**
     * Sets the value of the member "Day7".
     *
     * Day 7
     *
     * @param Day7 The value which will be set
     */
    inline void setDay7 (uint8 Day7_);

    static const T_TCU_Charge_Days &getDefaultInstance();

private:

    inline void set_has_Day1 ();

    inline void clear_has_Day1 ();

    inline void set_has_Day2 ();

    inline void clear_has_Day2 ();

    inline void set_has_Day3 ();

    inline void clear_has_Day3 ();

    inline void set_has_Day4 ();

    inline void clear_has_Day4 ();

    inline void set_has_Day5 ();

    inline void clear_has_Day5 ();

    inline void set_has_Day6 ();

    inline void clear_has_Day6 ();

    inline void set_has_Day7 ();

    inline void clear_has_Day7 ();

    uint32 _has_bits_[ (7 + 31) / 32];

    uint8 _Day1;

    uint8 _Day2;

    uint8 _Day3;

    uint8 _Day4;

    uint8 _Day5;

    uint8 _Day6;

    uint8 _Day7;

};

/**
 * If the meaning of "T_TCU_Spot_Receptacle_Type" isn't clear, then there should be a description here.
 */
class T_TCU_Spot_Receptacle_Type {
public:

    /**
     * Default constructor
     */
    inline  T_TCU_Spot_Receptacle_Type ();

    /**
     * Copy constructor
     */
    inline  T_TCU_Spot_Receptacle_Type (const T_TCU_Spot_Receptacle_Type &rhs);

    /**
     * All fields constructor
     */
    inline  T_TCU_Spot_Receptacle_Type (T_e8_TCU_Charge_Receptacle_Type rDefault_receptacle_type_, T_e8_TCU_Charge_Receptacle_Type rUser_receptacle_type_1_, T_e8_TCU_Charge_Receptacle_Type rUser_receptacle_type_2_, T_e8_TCU_Charge_Receptacle_Type rUser_receptacle_type_3_, uint8 u8Reserved1_, uint8 u8Reserved2_, uint8 u8Reserved3_, uint8 u8Reserved4_);

    /**
     * Destructor
     */
    inline  ~T_TCU_Spot_Receptacle_Type();

    /**
     * Assignment operator
     */
    inline T_TCU_Spot_Receptacle_Type& operator = (const T_TCU_Spot_Receptacle_Type& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TCU_Spot_Receptacle_Type& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TCU_Spot_Receptacle_Type& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TCU_Spot_Receptacle_Type& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TCU_Spot_Receptacle_Type& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "rDefault_receptacle_type"

    static const int kRDefault_receptacle_type = 0;

    /**
     * Clears the field "rDefault_receptacle_type".
     *
     * The field will be set to its default value. The hasRDefault_receptacle_type()
     * method will return false.
     */
    inline void clearRDefault_receptacle_type();

    /**
     * Checks whether the field "rDefault_receptacle_type" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRDefault_receptacle_type()). Otherwise it will return false.
     */
    inline bool hasRDefault_receptacle_type () const;

    /**
     * Returns the value of the member "rDefault_receptacle_type".
     *
     * Default receptacle type
     *
     * @return The value of the field "rDefault_receptacle_type"
     */
    inline T_e8_TCU_Charge_Receptacle_Type getRDefault_receptacle_type () const;

    /**
     * Sets the value of the member "rDefault_receptacle_type".
     *
     * Default receptacle type
     *
     * @param rDefault_receptacle_type The value which will be set
     */
    inline void setRDefault_receptacle_type (T_e8_TCU_Charge_Receptacle_Type rDefault_receptacle_type_);

    // API of field "rUser_receptacle_type_1"

    static const int kRUser_receptacle_type_1 = 1;

    /**
     * Clears the field "rUser_receptacle_type_1".
     *
     * The field will be set to its default value. The hasRUser_receptacle_type_1()
     * method will return false.
     */
    inline void clearRUser_receptacle_type_1();

    /**
     * Checks whether the field "rUser_receptacle_type_1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRUser_receptacle_type_1()). Otherwise it will return false.
     */
    inline bool hasRUser_receptacle_type_1 () const;

    /**
     * Returns the value of the member "rUser_receptacle_type_1".
     *
     * Default receptacle type 1
     *
     * @return The value of the field "rUser_receptacle_type_1"
     */
    inline T_e8_TCU_Charge_Receptacle_Type getRUser_receptacle_type_1 () const;

    /**
     * Sets the value of the member "rUser_receptacle_type_1".
     *
     * Default receptacle type 1
     *
     * @param rUser_receptacle_type_1 The value which will be set
     */
    inline void setRUser_receptacle_type_1 (T_e8_TCU_Charge_Receptacle_Type rUser_receptacle_type_1_);

    // API of field "rUser_receptacle_type_2"

    static const int kRUser_receptacle_type_2 = 2;

    /**
     * Clears the field "rUser_receptacle_type_2".
     *
     * The field will be set to its default value. The hasRUser_receptacle_type_2()
     * method will return false.
     */
    inline void clearRUser_receptacle_type_2();

    /**
     * Checks whether the field "rUser_receptacle_type_2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRUser_receptacle_type_2()). Otherwise it will return false.
     */
    inline bool hasRUser_receptacle_type_2 () const;

    /**
     * Returns the value of the member "rUser_receptacle_type_2".
     *
     * Default receptacle type 2
     *
     * @return The value of the field "rUser_receptacle_type_2"
     */
    inline T_e8_TCU_Charge_Receptacle_Type getRUser_receptacle_type_2 () const;

    /**
     * Sets the value of the member "rUser_receptacle_type_2".
     *
     * Default receptacle type 2
     *
     * @param rUser_receptacle_type_2 The value which will be set
     */
    inline void setRUser_receptacle_type_2 (T_e8_TCU_Charge_Receptacle_Type rUser_receptacle_type_2_);

    // API of field "rUser_receptacle_type_3"

    static const int kRUser_receptacle_type_3 = 3;

    /**
     * Clears the field "rUser_receptacle_type_3".
     *
     * The field will be set to its default value. The hasRUser_receptacle_type_3()
     * method will return false.
     */
    inline void clearRUser_receptacle_type_3();

    /**
     * Checks whether the field "rUser_receptacle_type_3" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRUser_receptacle_type_3()). Otherwise it will return false.
     */
    inline bool hasRUser_receptacle_type_3 () const;

    /**
     * Returns the value of the member "rUser_receptacle_type_3".
     *
     * Default receptacle type 3
     *
     * @return The value of the field "rUser_receptacle_type_3"
     */
    inline T_e8_TCU_Charge_Receptacle_Type getRUser_receptacle_type_3 () const;

    /**
     * Sets the value of the member "rUser_receptacle_type_3".
     *
     * Default receptacle type 3
     *
     * @param rUser_receptacle_type_3 The value which will be set
     */
    inline void setRUser_receptacle_type_3 (T_e8_TCU_Charge_Receptacle_Type rUser_receptacle_type_3_);

    // API of field "u8Reserved1"

    static const int kU8Reserved1 = 4;

    /**
     * Clears the field "u8Reserved1".
     *
     * The field will be set to its default value. The hasU8Reserved1()
     * method will return false.
     */
    inline void clearU8Reserved1();

    /**
     * Checks whether the field "u8Reserved1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Reserved1()). Otherwise it will return false.
     */
    inline bool hasU8Reserved1 () const;

    /**
     * Returns the value of the member "u8Reserved1".
     *
     * Reserved for future use
     *
     * @return The value of the field "u8Reserved1"
     */
    inline uint8 getU8Reserved1 () const;

    /**
     * Sets the value of the member "u8Reserved1".
     *
     * Reserved for future use
     *
     * @param u8Reserved1 The value which will be set
     */
    inline void setU8Reserved1 (uint8 u8Reserved1_);

    // API of field "u8Reserved2"

    static const int kU8Reserved2 = 5;

    /**
     * Clears the field "u8Reserved2".
     *
     * The field will be set to its default value. The hasU8Reserved2()
     * method will return false.
     */
    inline void clearU8Reserved2();

    /**
     * Checks whether the field "u8Reserved2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Reserved2()). Otherwise it will return false.
     */
    inline bool hasU8Reserved2 () const;

    /**
     * Returns the value of the member "u8Reserved2".
     *
     * Reserved for future use
     *
     * @return The value of the field "u8Reserved2"
     */
    inline uint8 getU8Reserved2 () const;

    /**
     * Sets the value of the member "u8Reserved2".
     *
     * Reserved for future use
     *
     * @param u8Reserved2 The value which will be set
     */
    inline void setU8Reserved2 (uint8 u8Reserved2_);

    // API of field "u8Reserved3"

    static const int kU8Reserved3 = 6;

    /**
     * Clears the field "u8Reserved3".
     *
     * The field will be set to its default value. The hasU8Reserved3()
     * method will return false.
     */
    inline void clearU8Reserved3();

    /**
     * Checks whether the field "u8Reserved3" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Reserved3()). Otherwise it will return false.
     */
    inline bool hasU8Reserved3 () const;

    /**
     * Returns the value of the member "u8Reserved3".
     *
     * Reserved for future use
     *
     * @return The value of the field "u8Reserved3"
     */
    inline uint8 getU8Reserved3 () const;

    /**
     * Sets the value of the member "u8Reserved3".
     *
     * Reserved for future use
     *
     * @param u8Reserved3 The value which will be set
     */
    inline void setU8Reserved3 (uint8 u8Reserved3_);

    // API of field "u8Reserved4"

    static const int kU8Reserved4 = 7;

    /**
     * Clears the field "u8Reserved4".
     *
     * The field will be set to its default value. The hasU8Reserved4()
     * method will return false.
     */
    inline void clearU8Reserved4();

    /**
     * Checks whether the field "u8Reserved4" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Reserved4()). Otherwise it will return false.
     */
    inline bool hasU8Reserved4 () const;

    /**
     * Returns the value of the member "u8Reserved4".
     *
     * Reserved for future use
     *
     * @return The value of the field "u8Reserved4"
     */
    inline uint8 getU8Reserved4 () const;

    /**
     * Sets the value of the member "u8Reserved4".
     *
     * Reserved for future use
     *
     * @param u8Reserved4 The value which will be set
     */
    inline void setU8Reserved4 (uint8 u8Reserved4_);

    static const T_TCU_Spot_Receptacle_Type &getDefaultInstance();

private:

    inline void set_has_rDefault_receptacle_type ();

    inline void clear_has_rDefault_receptacle_type ();

    inline void set_has_rUser_receptacle_type_1 ();

    inline void clear_has_rUser_receptacle_type_1 ();

    inline void set_has_rUser_receptacle_type_2 ();

    inline void clear_has_rUser_receptacle_type_2 ();

    inline void set_has_rUser_receptacle_type_3 ();

    inline void clear_has_rUser_receptacle_type_3 ();

    inline void set_has_u8Reserved1 ();

    inline void clear_has_u8Reserved1 ();

    inline void set_has_u8Reserved2 ();

    inline void clear_has_u8Reserved2 ();

    inline void set_has_u8Reserved3 ();

    inline void clear_has_u8Reserved3 ();

    inline void set_has_u8Reserved4 ();

    inline void clear_has_u8Reserved4 ();

    uint32 _has_bits_[ (8 + 31) / 32];

    T_e8_TCU_Charge_Receptacle_Type _rDefault_receptacle_type;

    T_e8_TCU_Charge_Receptacle_Type _rUser_receptacle_type_1;

    T_e8_TCU_Charge_Receptacle_Type _rUser_receptacle_type_2;

    T_e8_TCU_Charge_Receptacle_Type _rUser_receptacle_type_3;

    uint8 _u8Reserved1;

    uint8 _u8Reserved2;

    uint8 _u8Reserved3;

    uint8 _u8Reserved4;

};

/**
 * If the meaning of "PIN_Data" isn't clear, then there should be a description here.
 */
class PIN_Data {
public:

    /**
     * Default constructor
     */
    inline  PIN_Data ();

    /**
     * Copy constructor
     */
    inline  PIN_Data (const PIN_Data &rhs);

    /**
     * All fields constructor
     */
    inline  PIN_Data (uint8 u8Length_, const ::std::string& sText_);

    /**
     * Destructor
     */
    inline  ~PIN_Data();

    /**
     * Assignment operator
     */
    inline PIN_Data& operator = (const PIN_Data& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PIN_Data& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PIN_Data& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PIN_Data& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PIN_Data& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8Length"

    static const int kU8Length = 0;

    /**
     * Clears the field "u8Length".
     *
     * The field will be set to its default value. The hasU8Length()
     * method will return false.
     */
    inline void clearU8Length();

    /**
     * Checks whether the field "u8Length" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Length()). Otherwise it will return false.
     */
    inline bool hasU8Length () const;

    /**
     * Returns the value of the member "u8Length".
     *
     * If the meaning of "u8Length" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Length"
     */
    inline uint8 getU8Length () const;

    /**
     * Sets the value of the member "u8Length".
     *
     * If the meaning of "u8Length" isn't clear, then there should be a description here.
     *
     * @param u8Length The value which will be set
     */
    inline void setU8Length (uint8 u8Length_);

    // API of field "sText"

    static const int kSText = 1;

    /**
     * Clears the field "sText".
     *
     * The field will be set to its default value. The hasSText()
     * method will return false.
     */
    inline void clearSText();

    /**
     * Checks whether the field "sText" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSText()). Otherwise it will return false.
     */
    inline bool hasSText () const;

    /**
     * Returns the value of the member "sText".
     *
     * If the meaning of "sText" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sText"
     */
    inline const ::std::string& getSText () const;

    /**
     * Retrieves the value of the field "sText" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sText".
     */
    inline ::std::string& getSTextMutable ();

    /**
     * Sets the value of the member "sText".
     *
     * If the meaning of "sText" isn't clear, then there should be a description here.
     *
     * @param sText The value which will be set
     */
    inline void setSText (const ::std::string& sText_);

    /**
     * Sets the value of the member "sText".
     *
     * If the meaning of "sText" isn't clear, then there should be a description here.
     *
     * @param sText The value which will be set
     */
    inline void setSText (const char* sText_);

    /**
     * Sets the value of the member "sText".
     *
     * If the meaning of "sText" isn't clear, then there should be a description here.
     *
     * @param sText The value which will be set
     */
    inline void setSText (const char* value, size_t size);

    static const PIN_Data &getDefaultInstance();

private:

    inline void set_has_u8Length ();

    inline void clear_has_u8Length ();

    inline void set_has_sText ();

    inline void clear_has_sText ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8Length;

    ::std::string _sText;

};

/**
 * If the meaning of "T_TCU_PIN" isn't clear, then there should be a description here.
 */
class T_TCU_PIN {
public:

    /**
     * Default constructor
     */
    inline  T_TCU_PIN ();

    /**
     * Copy constructor
     */
    inline  T_TCU_PIN (const T_TCU_PIN &rhs);

    /**
     * All fields constructor
     */
    inline  T_TCU_PIN (const PIN_Data& rPIN_ID_, const PIN_Data& rPIN_Password_);

    /**
     * Destructor
     */
    inline  ~T_TCU_PIN();

    /**
     * Assignment operator
     */
    inline T_TCU_PIN& operator = (const T_TCU_PIN& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TCU_PIN& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TCU_PIN& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TCU_PIN& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TCU_PIN& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "rPIN_ID"

    static const int kRPIN_ID = 0;

    /**
     * Clears the field "rPIN_ID".
     *
     * The field will be set to its default value. The hasRPIN_ID()
     * method will return false.
     */
    inline void clearRPIN_ID();

    /**
     * Checks whether the field "rPIN_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRPIN_ID()). Otherwise it will return false.
     */
    inline bool hasRPIN_ID () const;

    /**
     * Returns the value of the member "rPIN_ID".
     *
     * If the meaning of "rPIN_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rPIN_ID"
     */
    inline const PIN_Data& getRPIN_ID () const;

    /**
     * Retrieves the value of the field "rPIN_ID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rPIN_ID".
     */
    inline PIN_Data& getRPIN_IDMutable ();

    /**
     * Sets the value of the member "rPIN_ID".
     *
     * If the meaning of "rPIN_ID" isn't clear, then there should be a description here.
     *
     * @param rPIN_ID The value which will be set
     */
    inline void setRPIN_ID (const PIN_Data& rPIN_ID_);

    // API of field "rPIN_Password"

    static const int kRPIN_Password = 1;

    /**
     * Clears the field "rPIN_Password".
     *
     * The field will be set to its default value. The hasRPIN_Password()
     * method will return false.
     */
    inline void clearRPIN_Password();

    /**
     * Checks whether the field "rPIN_Password" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRPIN_Password()). Otherwise it will return false.
     */
    inline bool hasRPIN_Password () const;

    /**
     * Returns the value of the member "rPIN_Password".
     *
     * If the meaning of "rPIN_Password" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rPIN_Password"
     */
    inline const PIN_Data& getRPIN_Password () const;

    /**
     * Retrieves the value of the field "rPIN_Password" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rPIN_Password".
     */
    inline PIN_Data& getRPIN_PasswordMutable ();

    /**
     * Sets the value of the member "rPIN_Password".
     *
     * If the meaning of "rPIN_Password" isn't clear, then there should be a description here.
     *
     * @param rPIN_Password The value which will be set
     */
    inline void setRPIN_Password (const PIN_Data& rPIN_Password_);

    static const T_TCU_PIN &getDefaultInstance();

private:

    inline void set_has_rPIN_ID ();

    inline void clear_has_rPIN_ID ();

    inline void set_has_rPIN_Password ();

    inline void clear_has_rPIN_Password ();

    uint32 _has_bits_[ (2 + 31) / 32];

    PIN_Data _rPIN_ID;

    PIN_Data _rPIN_Password;

};

/**
 * If the meaning of "T_TCU_Wifi_SSID_Name" isn't clear, then there should be a description here.
 */
class T_TCU_Wifi_SSID_Name {
public:

    /**
     * Default constructor
     */
    inline  T_TCU_Wifi_SSID_Name ();

    /**
     * Copy constructor
     */
    inline  T_TCU_Wifi_SSID_Name (const T_TCU_Wifi_SSID_Name &rhs);

    /**
     * All fields constructor
     */
    inline  T_TCU_Wifi_SSID_Name (uint8 u8CharcterSet_, uint8 u8LentghOfText_, const ::std::string& sText_);

    /**
     * Destructor
     */
    inline  ~T_TCU_Wifi_SSID_Name();

    /**
     * Assignment operator
     */
    inline T_TCU_Wifi_SSID_Name& operator = (const T_TCU_Wifi_SSID_Name& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TCU_Wifi_SSID_Name& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TCU_Wifi_SSID_Name& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TCU_Wifi_SSID_Name& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TCU_Wifi_SSID_Name& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8CharcterSet"

    static const int kU8CharcterSet = 0;

    /**
     * Clears the field "u8CharcterSet".
     *
     * The field will be set to its default value. The hasU8CharcterSet()
     * method will return false.
     */
    inline void clearU8CharcterSet();

    /**
     * Checks whether the field "u8CharcterSet" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8CharcterSet()). Otherwise it will return false.
     */
    inline bool hasU8CharcterSet () const;

    /**
     * Returns the value of the member "u8CharcterSet".
     *
     * If the meaning of "u8CharcterSet" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8CharcterSet"
     */
    inline uint8 getU8CharcterSet () const;

    /**
     * Sets the value of the member "u8CharcterSet".
     *
     * If the meaning of "u8CharcterSet" isn't clear, then there should be a description here.
     *
     * @param u8CharcterSet The value which will be set
     */
    inline void setU8CharcterSet (uint8 u8CharcterSet_);

    // API of field "u8LentghOfText"

    static const int kU8LentghOfText = 1;

    /**
     * Clears the field "u8LentghOfText".
     *
     * The field will be set to its default value. The hasU8LentghOfText()
     * method will return false.
     */
    inline void clearU8LentghOfText();

    /**
     * Checks whether the field "u8LentghOfText" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8LentghOfText()). Otherwise it will return false.
     */
    inline bool hasU8LentghOfText () const;

    /**
     * Returns the value of the member "u8LentghOfText".
     *
     * If the meaning of "u8LentghOfText" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8LentghOfText"
     */
    inline uint8 getU8LentghOfText () const;

    /**
     * Sets the value of the member "u8LentghOfText".
     *
     * If the meaning of "u8LentghOfText" isn't clear, then there should be a description here.
     *
     * @param u8LentghOfText The value which will be set
     */
    inline void setU8LentghOfText (uint8 u8LentghOfText_);

    // API of field "sText"

    static const int kSText = 2;

    /**
     * Clears the field "sText".
     *
     * The field will be set to its default value. The hasSText()
     * method will return false.
     */
    inline void clearSText();

    /**
     * Checks whether the field "sText" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSText()). Otherwise it will return false.
     */
    inline bool hasSText () const;

    /**
     * Returns the value of the member "sText".
     *
     * If the meaning of "sText" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sText"
     */
    inline const ::std::string& getSText () const;

    /**
     * Retrieves the value of the field "sText" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sText".
     */
    inline ::std::string& getSTextMutable ();

    /**
     * Sets the value of the member "sText".
     *
     * If the meaning of "sText" isn't clear, then there should be a description here.
     *
     * @param sText The value which will be set
     */
    inline void setSText (const ::std::string& sText_);

    /**
     * Sets the value of the member "sText".
     *
     * If the meaning of "sText" isn't clear, then there should be a description here.
     *
     * @param sText The value which will be set
     */
    inline void setSText (const char* sText_);

    /**
     * Sets the value of the member "sText".
     *
     * If the meaning of "sText" isn't clear, then there should be a description here.
     *
     * @param sText The value which will be set
     */
    inline void setSText (const char* value, size_t size);

    static const T_TCU_Wifi_SSID_Name &getDefaultInstance();

private:

    inline void set_has_u8CharcterSet ();

    inline void clear_has_u8CharcterSet ();

    inline void set_has_u8LentghOfText ();

    inline void clear_has_u8LentghOfText ();

    inline void set_has_sText ();

    inline void clear_has_sText ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _u8CharcterSet;

    uint8 _u8LentghOfText;

    ::std::string _sText;

};

/**
 * If the meaning of "T_TCU_Wifi_PassKey" isn't clear, then there should be a description here.
 */
class T_TCU_Wifi_PassKey {
public:

    /**
     * Default constructor
     */
    inline  T_TCU_Wifi_PassKey ();

    /**
     * Copy constructor
     */
    inline  T_TCU_Wifi_PassKey (const T_TCU_Wifi_PassKey &rhs);

    /**
     * All fields constructor
     */
    inline  T_TCU_Wifi_PassKey (uint8 u8CharcterSet_, uint8 u8LentghOfText_, const ::std::string& sText_);

    /**
     * Destructor
     */
    inline  ~T_TCU_Wifi_PassKey();

    /**
     * Assignment operator
     */
    inline T_TCU_Wifi_PassKey& operator = (const T_TCU_Wifi_PassKey& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TCU_Wifi_PassKey& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TCU_Wifi_PassKey& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TCU_Wifi_PassKey& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TCU_Wifi_PassKey& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8CharcterSet"

    static const int kU8CharcterSet = 0;

    /**
     * Clears the field "u8CharcterSet".
     *
     * The field will be set to its default value. The hasU8CharcterSet()
     * method will return false.
     */
    inline void clearU8CharcterSet();

    /**
     * Checks whether the field "u8CharcterSet" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8CharcterSet()). Otherwise it will return false.
     */
    inline bool hasU8CharcterSet () const;

    /**
     * Returns the value of the member "u8CharcterSet".
     *
     * If the meaning of "u8CharcterSet" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8CharcterSet"
     */
    inline uint8 getU8CharcterSet () const;

    /**
     * Sets the value of the member "u8CharcterSet".
     *
     * If the meaning of "u8CharcterSet" isn't clear, then there should be a description here.
     *
     * @param u8CharcterSet The value which will be set
     */
    inline void setU8CharcterSet (uint8 u8CharcterSet_);

    // API of field "u8LentghOfText"

    static const int kU8LentghOfText = 1;

    /**
     * Clears the field "u8LentghOfText".
     *
     * The field will be set to its default value. The hasU8LentghOfText()
     * method will return false.
     */
    inline void clearU8LentghOfText();

    /**
     * Checks whether the field "u8LentghOfText" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8LentghOfText()). Otherwise it will return false.
     */
    inline bool hasU8LentghOfText () const;

    /**
     * Returns the value of the member "u8LentghOfText".
     *
     * If the meaning of "u8LentghOfText" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8LentghOfText"
     */
    inline uint8 getU8LentghOfText () const;

    /**
     * Sets the value of the member "u8LentghOfText".
     *
     * If the meaning of "u8LentghOfText" isn't clear, then there should be a description here.
     *
     * @param u8LentghOfText The value which will be set
     */
    inline void setU8LentghOfText (uint8 u8LentghOfText_);

    // API of field "sText"

    static const int kSText = 2;

    /**
     * Clears the field "sText".
     *
     * The field will be set to its default value. The hasSText()
     * method will return false.
     */
    inline void clearSText();

    /**
     * Checks whether the field "sText" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSText()). Otherwise it will return false.
     */
    inline bool hasSText () const;

    /**
     * Returns the value of the member "sText".
     *
     * If the meaning of "sText" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sText"
     */
    inline const ::std::string& getSText () const;

    /**
     * Retrieves the value of the field "sText" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sText".
     */
    inline ::std::string& getSTextMutable ();

    /**
     * Sets the value of the member "sText".
     *
     * If the meaning of "sText" isn't clear, then there should be a description here.
     *
     * @param sText The value which will be set
     */
    inline void setSText (const ::std::string& sText_);

    /**
     * Sets the value of the member "sText".
     *
     * If the meaning of "sText" isn't clear, then there should be a description here.
     *
     * @param sText The value which will be set
     */
    inline void setSText (const char* sText_);

    /**
     * Sets the value of the member "sText".
     *
     * If the meaning of "sText" isn't clear, then there should be a description here.
     *
     * @param sText The value which will be set
     */
    inline void setSText (const char* value, size_t size);

    static const T_TCU_Wifi_PassKey &getDefaultInstance();

private:

    inline void set_has_u8CharcterSet ();

    inline void clear_has_u8CharcterSet ();

    inline void set_has_u8LentghOfText ();

    inline void clear_has_u8LentghOfText ();

    inline void set_has_sText ();

    inline void clear_has_sText ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _u8CharcterSet;

    uint8 _u8LentghOfText;

    ::std::string _sText;

};

/**
 * If the meaning of "T_TCU_Time_Slot" isn't clear, then there should be a description here.
 */
class T_TCU_Time_Slot {
public:

    /**
     * Default constructor
     */
    inline  T_TCU_Time_Slot ();

    /**
     * Copy constructor
     */
    inline  T_TCU_Time_Slot (const T_TCU_Time_Slot &rhs);

    /**
     * All fields constructor
     */
    inline  T_TCU_Time_Slot (const T_TCU_Date_Time& rStart_timeStamp_, const T_TCU_Date_Time& rStop_timeStamp_, T_e8_TCU_Cycle e8Cycle_);

    /**
     * Destructor
     */
    inline  ~T_TCU_Time_Slot();

    /**
     * Assignment operator
     */
    inline T_TCU_Time_Slot& operator = (const T_TCU_Time_Slot& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TCU_Time_Slot& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TCU_Time_Slot& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TCU_Time_Slot& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TCU_Time_Slot& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "rStart_timeStamp"

    static const int kRStart_timeStamp = 0;

    /**
     * Clears the field "rStart_timeStamp".
     *
     * The field will be set to its default value. The hasRStart_timeStamp()
     * method will return false.
     */
    inline void clearRStart_timeStamp();

    /**
     * Checks whether the field "rStart_timeStamp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRStart_timeStamp()). Otherwise it will return false.
     */
    inline bool hasRStart_timeStamp () const;

    /**
     * Returns the value of the member "rStart_timeStamp".
     *
     * If the meaning of "rStart_timeStamp" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rStart_timeStamp"
     */
    inline const T_TCU_Date_Time& getRStart_timeStamp () const;

    /**
     * Retrieves the value of the field "rStart_timeStamp" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rStart_timeStamp".
     */
    inline T_TCU_Date_Time& getRStart_timeStampMutable ();

    /**
     * Sets the value of the member "rStart_timeStamp".
     *
     * If the meaning of "rStart_timeStamp" isn't clear, then there should be a description here.
     *
     * @param rStart_timeStamp The value which will be set
     */
    inline void setRStart_timeStamp (const T_TCU_Date_Time& rStart_timeStamp_);

    // API of field "rStop_timeStamp"

    static const int kRStop_timeStamp = 1;

    /**
     * Clears the field "rStop_timeStamp".
     *
     * The field will be set to its default value. The hasRStop_timeStamp()
     * method will return false.
     */
    inline void clearRStop_timeStamp();

    /**
     * Checks whether the field "rStop_timeStamp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRStop_timeStamp()). Otherwise it will return false.
     */
    inline bool hasRStop_timeStamp () const;

    /**
     * Returns the value of the member "rStop_timeStamp".
     *
     * If the meaning of "rStop_timeStamp" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rStop_timeStamp"
     */
    inline const T_TCU_Date_Time& getRStop_timeStamp () const;

    /**
     * Retrieves the value of the field "rStop_timeStamp" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rStop_timeStamp".
     */
    inline T_TCU_Date_Time& getRStop_timeStampMutable ();

    /**
     * Sets the value of the member "rStop_timeStamp".
     *
     * If the meaning of "rStop_timeStamp" isn't clear, then there should be a description here.
     *
     * @param rStop_timeStamp The value which will be set
     */
    inline void setRStop_timeStamp (const T_TCU_Date_Time& rStop_timeStamp_);

    // API of field "e8Cycle"

    static const int kE8Cycle = 2;

    /**
     * Clears the field "e8Cycle".
     *
     * The field will be set to its default value. The hasE8Cycle()
     * method will return false.
     */
    inline void clearE8Cycle();

    /**
     * Checks whether the field "e8Cycle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Cycle()). Otherwise it will return false.
     */
    inline bool hasE8Cycle () const;

    /**
     * Returns the value of the member "e8Cycle".
     *
     * If the meaning of "e8Cycle" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Cycle"
     */
    inline T_e8_TCU_Cycle getE8Cycle () const;

    /**
     * Sets the value of the member "e8Cycle".
     *
     * If the meaning of "e8Cycle" isn't clear, then there should be a description here.
     *
     * @param e8Cycle The value which will be set
     */
    inline void setE8Cycle (T_e8_TCU_Cycle e8Cycle_);

    static const T_TCU_Time_Slot &getDefaultInstance();

private:

    inline void set_has_rStart_timeStamp ();

    inline void clear_has_rStart_timeStamp ();

    inline void set_has_rStop_timeStamp ();

    inline void clear_has_rStop_timeStamp ();

    inline void set_has_e8Cycle ();

    inline void clear_has_e8Cycle ();

    uint32 _has_bits_[ (3 + 31) / 32];

    T_TCU_Date_Time _rStart_timeStamp;

    T_TCU_Date_Time _rStop_timeStamp;

    T_e8_TCU_Cycle _e8Cycle;

};

/**
 * If the meaning of "T_TCU_Coordinates" isn't clear, then there should be a description here.
 */
class T_TCU_Coordinates {
public:

    /**
     * Default constructor
     */
    inline  T_TCU_Coordinates ();

    /**
     * Copy constructor
     */
    inline  T_TCU_Coordinates (const T_TCU_Coordinates &rhs);

    /**
     * All fields constructor
     */
    inline  T_TCU_Coordinates (T_e8_TCU_LatitudeMode e8Latitudemode_, T_e8_TCU_LongitudeMode e8LongitudeMode_, uint8 u8LatitudeDEG_, uint8 u8LatitudeMIN_, uint16 u16LatitudeSEC_, uint8 u8LongitudeDEG_, uint8 u8LongitudeMIN_, uint16 u16LongitudeSEC_, uint8 u8Reserve_);

    /**
     * Destructor
     */
    inline  ~T_TCU_Coordinates();

    /**
     * Assignment operator
     */
    inline T_TCU_Coordinates& operator = (const T_TCU_Coordinates& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TCU_Coordinates& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TCU_Coordinates& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TCU_Coordinates& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TCU_Coordinates& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Latitudemode"

    static const int kE8Latitudemode = 0;

    /**
     * Clears the field "e8Latitudemode".
     *
     * The field will be set to its default value. The hasE8Latitudemode()
     * method will return false.
     */
    inline void clearE8Latitudemode();

    /**
     * Checks whether the field "e8Latitudemode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Latitudemode()). Otherwise it will return false.
     */
    inline bool hasE8Latitudemode () const;

    /**
     * Returns the value of the member "e8Latitudemode".
     *
     * If the meaning of "e8Latitudemode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Latitudemode"
     */
    inline T_e8_TCU_LatitudeMode getE8Latitudemode () const;

    /**
     * Sets the value of the member "e8Latitudemode".
     *
     * If the meaning of "e8Latitudemode" isn't clear, then there should be a description here.
     *
     * @param e8Latitudemode The value which will be set
     */
    inline void setE8Latitudemode (T_e8_TCU_LatitudeMode e8Latitudemode_);

    // API of field "e8LongitudeMode"

    static const int kE8LongitudeMode = 1;

    /**
     * Clears the field "e8LongitudeMode".
     *
     * The field will be set to its default value. The hasE8LongitudeMode()
     * method will return false.
     */
    inline void clearE8LongitudeMode();

    /**
     * Checks whether the field "e8LongitudeMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8LongitudeMode()). Otherwise it will return false.
     */
    inline bool hasE8LongitudeMode () const;

    /**
     * Returns the value of the member "e8LongitudeMode".
     *
     * If the meaning of "e8LongitudeMode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8LongitudeMode"
     */
    inline T_e8_TCU_LongitudeMode getE8LongitudeMode () const;

    /**
     * Sets the value of the member "e8LongitudeMode".
     *
     * If the meaning of "e8LongitudeMode" isn't clear, then there should be a description here.
     *
     * @param e8LongitudeMode The value which will be set
     */
    inline void setE8LongitudeMode (T_e8_TCU_LongitudeMode e8LongitudeMode_);

    // API of field "u8LatitudeDEG"

    static const int kU8LatitudeDEG = 2;

    /**
     * Clears the field "u8LatitudeDEG".
     *
     * The field will be set to its default value. The hasU8LatitudeDEG()
     * method will return false.
     */
    inline void clearU8LatitudeDEG();

    /**
     * Checks whether the field "u8LatitudeDEG" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8LatitudeDEG()). Otherwise it will return false.
     */
    inline bool hasU8LatitudeDEG () const;

    /**
     * Returns the value of the member "u8LatitudeDEG".
     *
     * If the meaning of "u8LatitudeDEG" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8LatitudeDEG"
     */
    inline uint8 getU8LatitudeDEG () const;

    /**
     * Sets the value of the member "u8LatitudeDEG".
     *
     * If the meaning of "u8LatitudeDEG" isn't clear, then there should be a description here.
     *
     * @param u8LatitudeDEG The value which will be set
     */
    inline void setU8LatitudeDEG (uint8 u8LatitudeDEG_);

    // API of field "u8LatitudeMIN"

    static const int kU8LatitudeMIN = 3;

    /**
     * Clears the field "u8LatitudeMIN".
     *
     * The field will be set to its default value. The hasU8LatitudeMIN()
     * method will return false.
     */
    inline void clearU8LatitudeMIN();

    /**
     * Checks whether the field "u8LatitudeMIN" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8LatitudeMIN()). Otherwise it will return false.
     */
    inline bool hasU8LatitudeMIN () const;

    /**
     * Returns the value of the member "u8LatitudeMIN".
     *
     * If the meaning of "u8LatitudeMIN" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8LatitudeMIN"
     */
    inline uint8 getU8LatitudeMIN () const;

    /**
     * Sets the value of the member "u8LatitudeMIN".
     *
     * If the meaning of "u8LatitudeMIN" isn't clear, then there should be a description here.
     *
     * @param u8LatitudeMIN The value which will be set
     */
    inline void setU8LatitudeMIN (uint8 u8LatitudeMIN_);

    // API of field "u16LatitudeSEC"

    static const int kU16LatitudeSEC = 4;

    /**
     * Clears the field "u16LatitudeSEC".
     *
     * The field will be set to its default value. The hasU16LatitudeSEC()
     * method will return false.
     */
    inline void clearU16LatitudeSEC();

    /**
     * Checks whether the field "u16LatitudeSEC" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16LatitudeSEC()). Otherwise it will return false.
     */
    inline bool hasU16LatitudeSEC () const;

    /**
     * Returns the value of the member "u16LatitudeSEC".
     *
     * If the meaning of "u16LatitudeSEC" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u16LatitudeSEC"
     */
    inline uint16 getU16LatitudeSEC () const;

    /**
     * Sets the value of the member "u16LatitudeSEC".
     *
     * If the meaning of "u16LatitudeSEC" isn't clear, then there should be a description here.
     *
     * @param u16LatitudeSEC The value which will be set
     */
    inline void setU16LatitudeSEC (uint16 u16LatitudeSEC_);

    // API of field "u8LongitudeDEG"

    static const int kU8LongitudeDEG = 5;

    /**
     * Clears the field "u8LongitudeDEG".
     *
     * The field will be set to its default value. The hasU8LongitudeDEG()
     * method will return false.
     */
    inline void clearU8LongitudeDEG();

    /**
     * Checks whether the field "u8LongitudeDEG" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8LongitudeDEG()). Otherwise it will return false.
     */
    inline bool hasU8LongitudeDEG () const;

    /**
     * Returns the value of the member "u8LongitudeDEG".
     *
     * If the meaning of "u8LongitudeDEG" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8LongitudeDEG"
     */
    inline uint8 getU8LongitudeDEG () const;

    /**
     * Sets the value of the member "u8LongitudeDEG".
     *
     * If the meaning of "u8LongitudeDEG" isn't clear, then there should be a description here.
     *
     * @param u8LongitudeDEG The value which will be set
     */
    inline void setU8LongitudeDEG (uint8 u8LongitudeDEG_);

    // API of field "u8LongitudeMIN"

    static const int kU8LongitudeMIN = 6;

    /**
     * Clears the field "u8LongitudeMIN".
     *
     * The field will be set to its default value. The hasU8LongitudeMIN()
     * method will return false.
     */
    inline void clearU8LongitudeMIN();

    /**
     * Checks whether the field "u8LongitudeMIN" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8LongitudeMIN()). Otherwise it will return false.
     */
    inline bool hasU8LongitudeMIN () const;

    /**
     * Returns the value of the member "u8LongitudeMIN".
     *
     * If the meaning of "u8LongitudeMIN" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8LongitudeMIN"
     */
    inline uint8 getU8LongitudeMIN () const;

    /**
     * Sets the value of the member "u8LongitudeMIN".
     *
     * If the meaning of "u8LongitudeMIN" isn't clear, then there should be a description here.
     *
     * @param u8LongitudeMIN The value which will be set
     */
    inline void setU8LongitudeMIN (uint8 u8LongitudeMIN_);

    // API of field "u16LongitudeSEC"

    static const int kU16LongitudeSEC = 7;

    /**
     * Clears the field "u16LongitudeSEC".
     *
     * The field will be set to its default value. The hasU16LongitudeSEC()
     * method will return false.
     */
    inline void clearU16LongitudeSEC();

    /**
     * Checks whether the field "u16LongitudeSEC" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16LongitudeSEC()). Otherwise it will return false.
     */
    inline bool hasU16LongitudeSEC () const;

    /**
     * Returns the value of the member "u16LongitudeSEC".
     *
     * If the meaning of "u16LongitudeSEC" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u16LongitudeSEC"
     */
    inline uint16 getU16LongitudeSEC () const;

    /**
     * Sets the value of the member "u16LongitudeSEC".
     *
     * If the meaning of "u16LongitudeSEC" isn't clear, then there should be a description here.
     *
     * @param u16LongitudeSEC The value which will be set
     */
    inline void setU16LongitudeSEC (uint16 u16LongitudeSEC_);

    // API of field "u8Reserve"

    static const int kU8Reserve = 8;

    /**
     * Clears the field "u8Reserve".
     *
     * The field will be set to its default value. The hasU8Reserve()
     * method will return false.
     */
    inline void clearU8Reserve();

    /**
     * Checks whether the field "u8Reserve" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Reserve()). Otherwise it will return false.
     */
    inline bool hasU8Reserve () const;

    /**
     * Returns the value of the member "u8Reserve".
     *
     * If the meaning of "u8Reserve" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Reserve"
     */
    inline uint8 getU8Reserve () const;

    /**
     * Sets the value of the member "u8Reserve".
     *
     * If the meaning of "u8Reserve" isn't clear, then there should be a description here.
     *
     * @param u8Reserve The value which will be set
     */
    inline void setU8Reserve (uint8 u8Reserve_);

    static const T_TCU_Coordinates &getDefaultInstance();

private:

    inline void set_has_e8Latitudemode ();

    inline void clear_has_e8Latitudemode ();

    inline void set_has_e8LongitudeMode ();

    inline void clear_has_e8LongitudeMode ();

    inline void set_has_u8LatitudeDEG ();

    inline void clear_has_u8LatitudeDEG ();

    inline void set_has_u8LatitudeMIN ();

    inline void clear_has_u8LatitudeMIN ();

    inline void set_has_u16LatitudeSEC ();

    inline void clear_has_u16LatitudeSEC ();

    inline void set_has_u8LongitudeDEG ();

    inline void clear_has_u8LongitudeDEG ();

    inline void set_has_u8LongitudeMIN ();

    inline void clear_has_u8LongitudeMIN ();

    inline void set_has_u16LongitudeSEC ();

    inline void clear_has_u16LongitudeSEC ();

    inline void set_has_u8Reserve ();

    inline void clear_has_u8Reserve ();

    uint32 _has_bits_[ (9 + 31) / 32];

    T_e8_TCU_LatitudeMode _e8Latitudemode;

    T_e8_TCU_LongitudeMode _e8LongitudeMode;

    uint8 _u8LatitudeDEG;

    uint8 _u8LatitudeMIN;

    uint16 _u16LatitudeSEC;

    uint8 _u8LongitudeDEG;

    uint8 _u8LongitudeMIN;

    uint16 _u16LongitudeSEC;

    uint8 _u8Reserve;

};

/**
 * If the meaning of "T_TCU_Area_Coordinate" isn't clear, then there should be a description here.
 */
class T_TCU_Area_Coordinate {
public:

    /**
     * Default constructor
     */
    inline  T_TCU_Area_Coordinate ();

    /**
     * Copy constructor
     */
    inline  T_TCU_Area_Coordinate (const T_TCU_Area_Coordinate &rhs);

    /**
     * All fields constructor
     */
    inline  T_TCU_Area_Coordinate (const T_TCU_Coordinates& rCoordinates1_, const T_TCU_Coordinates& rCoordinates2_);

    /**
     * Destructor
     */
    inline  ~T_TCU_Area_Coordinate();

    /**
     * Assignment operator
     */
    inline T_TCU_Area_Coordinate& operator = (const T_TCU_Area_Coordinate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TCU_Area_Coordinate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TCU_Area_Coordinate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TCU_Area_Coordinate& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TCU_Area_Coordinate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "rCoordinates1"

    static const int kRCoordinates1 = 0;

    /**
     * Clears the field "rCoordinates1".
     *
     * The field will be set to its default value. The hasRCoordinates1()
     * method will return false.
     */
    inline void clearRCoordinates1();

    /**
     * Checks whether the field "rCoordinates1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRCoordinates1()). Otherwise it will return false.
     */
    inline bool hasRCoordinates1 () const;

    /**
     * Returns the value of the member "rCoordinates1".
     *
     * If the meaning of "rCoordinates1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rCoordinates1"
     */
    inline const T_TCU_Coordinates& getRCoordinates1 () const;

    /**
     * Retrieves the value of the field "rCoordinates1" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rCoordinates1".
     */
    inline T_TCU_Coordinates& getRCoordinates1Mutable ();

    /**
     * Sets the value of the member "rCoordinates1".
     *
     * If the meaning of "rCoordinates1" isn't clear, then there should be a description here.
     *
     * @param rCoordinates1 The value which will be set
     */
    inline void setRCoordinates1 (const T_TCU_Coordinates& rCoordinates1_);

    // API of field "rCoordinates2"

    static const int kRCoordinates2 = 1;

    /**
     * Clears the field "rCoordinates2".
     *
     * The field will be set to its default value. The hasRCoordinates2()
     * method will return false.
     */
    inline void clearRCoordinates2();

    /**
     * Checks whether the field "rCoordinates2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRCoordinates2()). Otherwise it will return false.
     */
    inline bool hasRCoordinates2 () const;

    /**
     * Returns the value of the member "rCoordinates2".
     *
     * If the meaning of "rCoordinates2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rCoordinates2"
     */
    inline const T_TCU_Coordinates& getRCoordinates2 () const;

    /**
     * Retrieves the value of the field "rCoordinates2" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rCoordinates2".
     */
    inline T_TCU_Coordinates& getRCoordinates2Mutable ();

    /**
     * Sets the value of the member "rCoordinates2".
     *
     * If the meaning of "rCoordinates2" isn't clear, then there should be a description here.
     *
     * @param rCoordinates2 The value which will be set
     */
    inline void setRCoordinates2 (const T_TCU_Coordinates& rCoordinates2_);

    static const T_TCU_Area_Coordinate &getDefaultInstance();

private:

    inline void set_has_rCoordinates1 ();

    inline void clear_has_rCoordinates1 ();

    inline void set_has_rCoordinates2 ();

    inline void clear_has_rCoordinates2 ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_TCU_Coordinates _rCoordinates1;

    T_TCU_Coordinates _rCoordinates2;

};

/**
 * If the meaning of "T_TCU_Area_Limit_Coordinates" isn't clear, then there should be a description here.
 */
class T_TCU_Area_Limit_Coordinates {
public:

    /**
     * Default constructor
     */
    inline  T_TCU_Area_Limit_Coordinates ();

    /**
     * Copy constructor
     */
    inline  T_TCU_Area_Limit_Coordinates (const T_TCU_Area_Limit_Coordinates &rhs);

    /**
     * All fields constructor
     */
    inline  T_TCU_Area_Limit_Coordinates (T_e8_TCU_Restriction_Area_Type e8Restriction_Area_Type_, T_e8_TCU_Area_Form e8Area_Form_, T_e8_TCU_LocationType e8LocationType_, const T_TCU_Area_Coordinate& rArea_Coordinates_, uint16 u16Radius_);

    /**
     * Destructor
     */
    inline  ~T_TCU_Area_Limit_Coordinates();

    /**
     * Assignment operator
     */
    inline T_TCU_Area_Limit_Coordinates& operator = (const T_TCU_Area_Limit_Coordinates& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TCU_Area_Limit_Coordinates& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TCU_Area_Limit_Coordinates& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TCU_Area_Limit_Coordinates& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TCU_Area_Limit_Coordinates& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Restriction_Area_Type"

    static const int kE8Restriction_Area_Type = 0;

    /**
     * Clears the field "e8Restriction_Area_Type".
     *
     * The field will be set to its default value. The hasE8Restriction_Area_Type()
     * method will return false.
     */
    inline void clearE8Restriction_Area_Type();

    /**
     * Checks whether the field "e8Restriction_Area_Type" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Restriction_Area_Type()). Otherwise it will return false.
     */
    inline bool hasE8Restriction_Area_Type () const;

    /**
     * Returns the value of the member "e8Restriction_Area_Type".
     *
     * If the meaning of "e8Restriction_Area_Type" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Restriction_Area_Type"
     */
    inline T_e8_TCU_Restriction_Area_Type getE8Restriction_Area_Type () const;

    /**
     * Sets the value of the member "e8Restriction_Area_Type".
     *
     * If the meaning of "e8Restriction_Area_Type" isn't clear, then there should be a description here.
     *
     * @param e8Restriction_Area_Type The value which will be set
     */
    inline void setE8Restriction_Area_Type (T_e8_TCU_Restriction_Area_Type e8Restriction_Area_Type_);

    // API of field "e8Area_Form"

    static const int kE8Area_Form = 1;

    /**
     * Clears the field "e8Area_Form".
     *
     * The field will be set to its default value. The hasE8Area_Form()
     * method will return false.
     */
    inline void clearE8Area_Form();

    /**
     * Checks whether the field "e8Area_Form" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Area_Form()). Otherwise it will return false.
     */
    inline bool hasE8Area_Form () const;

    /**
     * Returns the value of the member "e8Area_Form".
     *
     * If the meaning of "e8Area_Form" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Area_Form"
     */
    inline T_e8_TCU_Area_Form getE8Area_Form () const;

    /**
     * Sets the value of the member "e8Area_Form".
     *
     * If the meaning of "e8Area_Form" isn't clear, then there should be a description here.
     *
     * @param e8Area_Form The value which will be set
     */
    inline void setE8Area_Form (T_e8_TCU_Area_Form e8Area_Form_);

    // API of field "e8LocationType"

    static const int kE8LocationType = 2;

    /**
     * Clears the field "e8LocationType".
     *
     * The field will be set to its default value. The hasE8LocationType()
     * method will return false.
     */
    inline void clearE8LocationType();

    /**
     * Checks whether the field "e8LocationType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8LocationType()). Otherwise it will return false.
     */
    inline bool hasE8LocationType () const;

    /**
     * Returns the value of the member "e8LocationType".
     *
     * If the meaning of "e8LocationType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8LocationType"
     */
    inline T_e8_TCU_LocationType getE8LocationType () const;

    /**
     * Sets the value of the member "e8LocationType".
     *
     * If the meaning of "e8LocationType" isn't clear, then there should be a description here.
     *
     * @param e8LocationType The value which will be set
     */
    inline void setE8LocationType (T_e8_TCU_LocationType e8LocationType_);

    // API of field "rArea_Coordinates"

    static const int kRArea_Coordinates = 3;

    /**
     * Clears the field "rArea_Coordinates".
     *
     * The field will be set to its default value. The hasRArea_Coordinates()
     * method will return false.
     */
    inline void clearRArea_Coordinates();

    /**
     * Checks whether the field "rArea_Coordinates" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRArea_Coordinates()). Otherwise it will return false.
     */
    inline bool hasRArea_Coordinates () const;

    /**
     * Returns the value of the member "rArea_Coordinates".
     *
     * If the meaning of "rArea_Coordinates" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rArea_Coordinates"
     */
    inline const T_TCU_Area_Coordinate& getRArea_Coordinates () const;

    /**
     * Retrieves the value of the field "rArea_Coordinates" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rArea_Coordinates".
     */
    inline T_TCU_Area_Coordinate& getRArea_CoordinatesMutable ();

    /**
     * Sets the value of the member "rArea_Coordinates".
     *
     * If the meaning of "rArea_Coordinates" isn't clear, then there should be a description here.
     *
     * @param rArea_Coordinates The value which will be set
     */
    inline void setRArea_Coordinates (const T_TCU_Area_Coordinate& rArea_Coordinates_);

    // API of field "u16Radius"

    static const int kU16Radius = 4;

    /**
     * Clears the field "u16Radius".
     *
     * The field will be set to its default value. The hasU16Radius()
     * method will return false.
     */
    inline void clearU16Radius();

    /**
     * Checks whether the field "u16Radius" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16Radius()). Otherwise it will return false.
     */
    inline bool hasU16Radius () const;

    /**
     * Returns the value of the member "u16Radius".
     *
     * If the meaning of "u16Radius" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u16Radius"
     */
    inline uint16 getU16Radius () const;

    /**
     * Sets the value of the member "u16Radius".
     *
     * If the meaning of "u16Radius" isn't clear, then there should be a description here.
     *
     * @param u16Radius The value which will be set
     */
    inline void setU16Radius (uint16 u16Radius_);

    static const T_TCU_Area_Limit_Coordinates &getDefaultInstance();

private:

    inline void set_has_e8Restriction_Area_Type ();

    inline void clear_has_e8Restriction_Area_Type ();

    inline void set_has_e8Area_Form ();

    inline void clear_has_e8Area_Form ();

    inline void set_has_e8LocationType ();

    inline void clear_has_e8LocationType ();

    inline void set_has_rArea_Coordinates ();

    inline void clear_has_rArea_Coordinates ();

    inline void set_has_u16Radius ();

    inline void clear_has_u16Radius ();

    uint32 _has_bits_[ (5 + 31) / 32];

    T_e8_TCU_Restriction_Area_Type _e8Restriction_Area_Type;

    T_e8_TCU_Area_Form _e8Area_Form;

    T_e8_TCU_LocationType _e8LocationType;

    T_TCU_Area_Coordinate _rArea_Coordinates;

    uint16 _u16Radius;

};

/**
 * If the meaning of "T_TCU_Speed_Limit_Restriction" isn't clear, then there should be a description here.
 */
class T_TCU_Speed_Limit_Restriction {
public:

    /**
     * Default constructor
     */
    inline  T_TCU_Speed_Limit_Restriction ();

    /**
     * Copy constructor
     */
    inline  T_TCU_Speed_Limit_Restriction (const T_TCU_Speed_Limit_Restriction &rhs);

    /**
     * All fields constructor
     */
    inline  T_TCU_Speed_Limit_Restriction (const ::std::vector< uint16 >& rLimited_Vehicle_Speed_, const ::std::vector< T_TCU_Time_Slot >& rTime_Slot_);

    /**
     * Destructor
     */
    inline  ~T_TCU_Speed_Limit_Restriction();

    /**
     * Assignment operator
     */
    inline T_TCU_Speed_Limit_Restriction& operator = (const T_TCU_Speed_Limit_Restriction& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TCU_Speed_Limit_Restriction& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TCU_Speed_Limit_Restriction& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TCU_Speed_Limit_Restriction& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TCU_Speed_Limit_Restriction& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "rLimited_Vehicle_Speed"

    static const int kRLimited_Vehicle_Speed = 0;

    /**
     * Clears the field "rLimited_Vehicle_Speed".
     *
     * The field will be set to its default value. The hasRLimited_Vehicle_Speed()
     * method will return false.
     */
    inline void clearRLimited_Vehicle_Speed();

    /**
     * Checks whether the field "rLimited_Vehicle_Speed" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRLimited_Vehicle_Speed()). Otherwise it will return false.
     */
    inline bool hasRLimited_Vehicle_Speed () const;

    /**
     * Returns the value of the member "rLimited_Vehicle_Speed".
     *
     * If the meaning of "rLimited_Vehicle_Speed" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rLimited_Vehicle_Speed"
     */
    inline const ::std::vector< uint16 >& getRLimited_Vehicle_Speed () const;

    /**
     * Retrieves the value of the field "rLimited_Vehicle_Speed" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rLimited_Vehicle_Speed".
     */
    inline ::std::vector< uint16 >& getRLimited_Vehicle_SpeedMutable ();

    /**
     * Sets the value of the member "rLimited_Vehicle_Speed".
     *
     * If the meaning of "rLimited_Vehicle_Speed" isn't clear, then there should be a description here.
     *
     * @param rLimited_Vehicle_Speed The value which will be set
     */
    inline void setRLimited_Vehicle_Speed (const ::std::vector< uint16 >& rLimited_Vehicle_Speed_);

    // API of field "rTime_Slot"

    static const int kRTime_Slot = 1;

    /**
     * Clears the field "rTime_Slot".
     *
     * The field will be set to its default value. The hasRTime_Slot()
     * method will return false.
     */
    inline void clearRTime_Slot();

    /**
     * Checks whether the field "rTime_Slot" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRTime_Slot()). Otherwise it will return false.
     */
    inline bool hasRTime_Slot () const;

    /**
     * Returns the value of the member "rTime_Slot".
     *
     * If the meaning of "rTime_Slot" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rTime_Slot"
     */
    inline const ::std::vector< T_TCU_Time_Slot >& getRTime_Slot () const;

    /**
     * Retrieves the value of the field "rTime_Slot" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rTime_Slot".
     */
    inline ::std::vector< T_TCU_Time_Slot >& getRTime_SlotMutable ();

    /**
     * Sets the value of the member "rTime_Slot".
     *
     * If the meaning of "rTime_Slot" isn't clear, then there should be a description here.
     *
     * @param rTime_Slot The value which will be set
     */
    inline void setRTime_Slot (const ::std::vector< T_TCU_Time_Slot >& rTime_Slot_);

    static const T_TCU_Speed_Limit_Restriction &getDefaultInstance();

private:

    static const ::std::vector< uint16 >& getUint16List_DefaultInstance ();

    static const ::std::vector< T_TCU_Time_Slot >& getT_TCU_Time_SlotList_DefaultInstance ();

    inline void set_has_rLimited_Vehicle_Speed ();

    inline void clear_has_rLimited_Vehicle_Speed ();

    inline void set_has_rTime_Slot ();

    inline void clear_has_rTime_Slot ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::vector< uint16 > _rLimited_Vehicle_Speed;

    ::std::vector< T_TCU_Time_Slot > _rTime_Slot;

};

/**
 * If the meaning of "T_TCU_Area_Limit_Restriction" isn't clear, then there should be a description here.
 */
class T_TCU_Area_Limit_Restriction {
public:

    /**
     * Default constructor
     */
    inline  T_TCU_Area_Limit_Restriction ();

    /**
     * Copy constructor
     */
    inline  T_TCU_Area_Limit_Restriction (const T_TCU_Area_Limit_Restriction &rhs);

    /**
     * All fields constructor
     */
    inline  T_TCU_Area_Limit_Restriction (const ::std::vector< T_TCU_Area_Limit_Coordinates >& rArea_Limit_Coordinates_, const ::std::vector< T_TCU_Time_Slot >& rTime_Slot_);

    /**
     * Destructor
     */
    inline  ~T_TCU_Area_Limit_Restriction();

    /**
     * Assignment operator
     */
    inline T_TCU_Area_Limit_Restriction& operator = (const T_TCU_Area_Limit_Restriction& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TCU_Area_Limit_Restriction& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TCU_Area_Limit_Restriction& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TCU_Area_Limit_Restriction& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TCU_Area_Limit_Restriction& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "rArea_Limit_Coordinates"

    static const int kRArea_Limit_Coordinates = 0;

    /**
     * Clears the field "rArea_Limit_Coordinates".
     *
     * The field will be set to its default value. The hasRArea_Limit_Coordinates()
     * method will return false.
     */
    inline void clearRArea_Limit_Coordinates();

    /**
     * Checks whether the field "rArea_Limit_Coordinates" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRArea_Limit_Coordinates()). Otherwise it will return false.
     */
    inline bool hasRArea_Limit_Coordinates () const;

    /**
     * Returns the value of the member "rArea_Limit_Coordinates".
     *
     * If the meaning of "rArea_Limit_Coordinates" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rArea_Limit_Coordinates"
     */
    inline const ::std::vector< T_TCU_Area_Limit_Coordinates >& getRArea_Limit_Coordinates () const;

    /**
     * Retrieves the value of the field "rArea_Limit_Coordinates" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rArea_Limit_Coordinates".
     */
    inline ::std::vector< T_TCU_Area_Limit_Coordinates >& getRArea_Limit_CoordinatesMutable ();

    /**
     * Sets the value of the member "rArea_Limit_Coordinates".
     *
     * If the meaning of "rArea_Limit_Coordinates" isn't clear, then there should be a description here.
     *
     * @param rArea_Limit_Coordinates The value which will be set
     */
    inline void setRArea_Limit_Coordinates (const ::std::vector< T_TCU_Area_Limit_Coordinates >& rArea_Limit_Coordinates_);

    // API of field "rTime_Slot"

    static const int kRTime_Slot = 1;

    /**
     * Clears the field "rTime_Slot".
     *
     * The field will be set to its default value. The hasRTime_Slot()
     * method will return false.
     */
    inline void clearRTime_Slot();

    /**
     * Checks whether the field "rTime_Slot" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRTime_Slot()). Otherwise it will return false.
     */
    inline bool hasRTime_Slot () const;

    /**
     * Returns the value of the member "rTime_Slot".
     *
     * If the meaning of "rTime_Slot" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rTime_Slot"
     */
    inline const ::std::vector< T_TCU_Time_Slot >& getRTime_Slot () const;

    /**
     * Retrieves the value of the field "rTime_Slot" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rTime_Slot".
     */
    inline ::std::vector< T_TCU_Time_Slot >& getRTime_SlotMutable ();

    /**
     * Sets the value of the member "rTime_Slot".
     *
     * If the meaning of "rTime_Slot" isn't clear, then there should be a description here.
     *
     * @param rTime_Slot The value which will be set
     */
    inline void setRTime_Slot (const ::std::vector< T_TCU_Time_Slot >& rTime_Slot_);

    static const T_TCU_Area_Limit_Restriction &getDefaultInstance();

private:

    static const ::std::vector< T_TCU_Area_Limit_Coordinates >& getT_TCU_Area_Limit_CoordinatesList_DefaultInstance ();

    static const ::std::vector< T_TCU_Time_Slot >& getT_TCU_Time_SlotList_DefaultInstance ();

    inline void set_has_rArea_Limit_Coordinates ();

    inline void clear_has_rArea_Limit_Coordinates ();

    inline void set_has_rTime_Slot ();

    inline void clear_has_rTime_Slot ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::vector< T_TCU_Area_Limit_Coordinates > _rArea_Limit_Coordinates;

    ::std::vector< T_TCU_Time_Slot > _rTime_Slot;

};

inline  T_TCU_VersionInfo::T_TCU_VersionInfo ()  :
    _u8Upper (0u),
    _u8Mid (0u),
    _u8Lower (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TCU_VersionInfo::T_TCU_VersionInfo (const T_TCU_VersionInfo &rhs)  :
    _u8Upper (0u),
    _u8Mid (0u),
    _u8Lower (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TCU_VersionInfo::T_TCU_VersionInfo (uint8 u8Upper_, uint8 u8Mid_, uint8 u8Lower_)  :
    _u8Upper (u8Upper_),
    _u8Mid (u8Mid_),
    _u8Lower (u8Lower_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TCU_VersionInfo::~T_TCU_VersionInfo() {
}

inline T_TCU_VersionInfo& T_TCU_VersionInfo::operator = (const T_TCU_VersionInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8Upper()) {
            setU8Upper(rhs.getU8Upper());
        } else {
            clearU8Upper();
        }
        if (rhs.hasU8Mid()) {
            setU8Mid(rhs.getU8Mid());
        } else {
            clearU8Mid();
        }
        if (rhs.hasU8Lower()) {
            setU8Lower(rhs.getU8Lower());
        } else {
            clearU8Lower();
        }
    }
    return *this;
}

inline bool T_TCU_VersionInfo::operator == (const T_TCU_VersionInfo& rhs) const {
    return (((!hasU8Upper() && !rhs.hasU8Upper()) || getU8Upper() == rhs.getU8Upper()) &&
        ((!hasU8Mid() && !rhs.hasU8Mid()) || getU8Mid() == rhs.getU8Mid()) &&
        ((!hasU8Lower() && !rhs.hasU8Lower()) || getU8Lower() == rhs.getU8Lower()));
}

inline bool T_TCU_VersionInfo::operator != (const T_TCU_VersionInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TCU_VersionInfo::operator < (const T_TCU_VersionInfo& rhs) const {
    if (hasU8Upper() || rhs.hasU8Upper()) {
        if (getU8Upper() < rhs.getU8Upper()) return true;
        if (getU8Upper() > rhs.getU8Upper()) return false;
    }
    if (hasU8Mid() || rhs.hasU8Mid()) {
        if (getU8Mid() < rhs.getU8Mid()) return true;
        if (getU8Mid() > rhs.getU8Mid()) return false;
    }
    if (hasU8Lower() || rhs.hasU8Lower()) {
        if (getU8Lower() < rhs.getU8Lower()) return true;
        if (getU8Lower() > rhs.getU8Lower()) return false;
    }
    return false;
}

inline bool T_TCU_VersionInfo::operator > (const T_TCU_VersionInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TCU_VersionInfo::clear() {
    clearU8Upper();
    clearU8Mid();
    clearU8Lower();
}

inline void T_TCU_VersionInfo::clearU8Upper() {
    if (hasU8Upper()) {
         clear_has_u8Upper();
        _u8Upper = 0u;
     }
}

inline bool T_TCU_VersionInfo::hasU8Upper () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_TCU_VersionInfo::getU8Upper () const {
    return _u8Upper;
}

inline void T_TCU_VersionInfo::setU8Upper (uint8 u8Upper_) {
    set_has_u8Upper();
    this->_u8Upper = u8Upper_;
}

inline void T_TCU_VersionInfo::clearU8Mid() {
    if (hasU8Mid()) {
         clear_has_u8Mid();
        _u8Mid = 0u;
     }
}

inline bool T_TCU_VersionInfo::hasU8Mid () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_TCU_VersionInfo::getU8Mid () const {
    return _u8Mid;
}

inline void T_TCU_VersionInfo::setU8Mid (uint8 u8Mid_) {
    set_has_u8Mid();
    this->_u8Mid = u8Mid_;
}

inline void T_TCU_VersionInfo::clearU8Lower() {
    if (hasU8Lower()) {
         clear_has_u8Lower();
        _u8Lower = 0u;
     }
}

inline bool T_TCU_VersionInfo::hasU8Lower () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 T_TCU_VersionInfo::getU8Lower () const {
    return _u8Lower;
}

inline void T_TCU_VersionInfo::setU8Lower (uint8 u8Lower_) {
    set_has_u8Lower();
    this->_u8Lower = u8Lower_;
}

inline void T_TCU_VersionInfo::set_has_u8Upper () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TCU_VersionInfo::clear_has_u8Upper () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TCU_VersionInfo::set_has_u8Mid () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TCU_VersionInfo::clear_has_u8Mid () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_TCU_VersionInfo::set_has_u8Lower () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_TCU_VersionInfo::clear_has_u8Lower () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_TCU_Date_Time::T_TCU_Date_Time ()  :
    _u16Year (0u),
    _u8Month (0u),
    _u8Day (0u),
    _u8Hour (0u),
    _u8Minute (0u),
    _u8Second (0u),
    _u8Reserve (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TCU_Date_Time::T_TCU_Date_Time (const T_TCU_Date_Time &rhs)  :
    _u16Year (0u),
    _u8Month (0u),
    _u8Day (0u),
    _u8Hour (0u),
    _u8Minute (0u),
    _u8Second (0u),
    _u8Reserve (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TCU_Date_Time::T_TCU_Date_Time (uint16 u16Year_, uint8 u8Month_, uint8 u8Day_, uint8 u8Hour_, uint8 u8Minute_, uint8 u8Second_, uint8 u8Reserve_)  :
    _u16Year (u16Year_),
    _u8Month (u8Month_),
    _u8Day (u8Day_),
    _u8Hour (u8Hour_),
    _u8Minute (u8Minute_),
    _u8Second (u8Second_),
    _u8Reserve (u8Reserve_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TCU_Date_Time::~T_TCU_Date_Time() {
}

inline T_TCU_Date_Time& T_TCU_Date_Time::operator = (const T_TCU_Date_Time& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU16Year()) {
            setU16Year(rhs.getU16Year());
        } else {
            clearU16Year();
        }
        if (rhs.hasU8Month()) {
            setU8Month(rhs.getU8Month());
        } else {
            clearU8Month();
        }
        if (rhs.hasU8Day()) {
            setU8Day(rhs.getU8Day());
        } else {
            clearU8Day();
        }
        if (rhs.hasU8Hour()) {
            setU8Hour(rhs.getU8Hour());
        } else {
            clearU8Hour();
        }
        if (rhs.hasU8Minute()) {
            setU8Minute(rhs.getU8Minute());
        } else {
            clearU8Minute();
        }
        if (rhs.hasU8Second()) {
            setU8Second(rhs.getU8Second());
        } else {
            clearU8Second();
        }
        if (rhs.hasU8Reserve()) {
            setU8Reserve(rhs.getU8Reserve());
        } else {
            clearU8Reserve();
        }
    }
    return *this;
}

inline bool T_TCU_Date_Time::operator == (const T_TCU_Date_Time& rhs) const {
    return (((!hasU16Year() && !rhs.hasU16Year()) || getU16Year() == rhs.getU16Year()) &&
        ((!hasU8Month() && !rhs.hasU8Month()) || getU8Month() == rhs.getU8Month()) &&
        ((!hasU8Day() && !rhs.hasU8Day()) || getU8Day() == rhs.getU8Day()) &&
        ((!hasU8Hour() && !rhs.hasU8Hour()) || getU8Hour() == rhs.getU8Hour()) &&
        ((!hasU8Minute() && !rhs.hasU8Minute()) || getU8Minute() == rhs.getU8Minute()) &&
        ((!hasU8Second() && !rhs.hasU8Second()) || getU8Second() == rhs.getU8Second()) &&
        ((!hasU8Reserve() && !rhs.hasU8Reserve()) || getU8Reserve() == rhs.getU8Reserve()));
}

inline bool T_TCU_Date_Time::operator != (const T_TCU_Date_Time& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TCU_Date_Time::operator < (const T_TCU_Date_Time& rhs) const {
    if (hasU16Year() || rhs.hasU16Year()) {
        if (getU16Year() < rhs.getU16Year()) return true;
        if (getU16Year() > rhs.getU16Year()) return false;
    }
    if (hasU8Month() || rhs.hasU8Month()) {
        if (getU8Month() < rhs.getU8Month()) return true;
        if (getU8Month() > rhs.getU8Month()) return false;
    }
    if (hasU8Day() || rhs.hasU8Day()) {
        if (getU8Day() < rhs.getU8Day()) return true;
        if (getU8Day() > rhs.getU8Day()) return false;
    }
    if (hasU8Hour() || rhs.hasU8Hour()) {
        if (getU8Hour() < rhs.getU8Hour()) return true;
        if (getU8Hour() > rhs.getU8Hour()) return false;
    }
    if (hasU8Minute() || rhs.hasU8Minute()) {
        if (getU8Minute() < rhs.getU8Minute()) return true;
        if (getU8Minute() > rhs.getU8Minute()) return false;
    }
    if (hasU8Second() || rhs.hasU8Second()) {
        if (getU8Second() < rhs.getU8Second()) return true;
        if (getU8Second() > rhs.getU8Second()) return false;
    }
    if (hasU8Reserve() || rhs.hasU8Reserve()) {
        if (getU8Reserve() < rhs.getU8Reserve()) return true;
        if (getU8Reserve() > rhs.getU8Reserve()) return false;
    }
    return false;
}

inline bool T_TCU_Date_Time::operator > (const T_TCU_Date_Time& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TCU_Date_Time::clear() {
    clearU16Year();
    clearU8Month();
    clearU8Day();
    clearU8Hour();
    clearU8Minute();
    clearU8Second();
    clearU8Reserve();
}

inline void T_TCU_Date_Time::clearU16Year() {
    if (hasU16Year()) {
         clear_has_u16Year();
        _u16Year = 0u;
     }
}

inline bool T_TCU_Date_Time::hasU16Year () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 T_TCU_Date_Time::getU16Year () const {
    return _u16Year;
}

inline void T_TCU_Date_Time::setU16Year (uint16 u16Year_) {
    set_has_u16Year();
    this->_u16Year = u16Year_;
}

inline void T_TCU_Date_Time::clearU8Month() {
    if (hasU8Month()) {
         clear_has_u8Month();
        _u8Month = 0u;
     }
}

inline bool T_TCU_Date_Time::hasU8Month () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_TCU_Date_Time::getU8Month () const {
    return _u8Month;
}

inline void T_TCU_Date_Time::setU8Month (uint8 u8Month_) {
    set_has_u8Month();
    this->_u8Month = u8Month_;
}

inline void T_TCU_Date_Time::clearU8Day() {
    if (hasU8Day()) {
         clear_has_u8Day();
        _u8Day = 0u;
     }
}

inline bool T_TCU_Date_Time::hasU8Day () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 T_TCU_Date_Time::getU8Day () const {
    return _u8Day;
}

inline void T_TCU_Date_Time::setU8Day (uint8 u8Day_) {
    set_has_u8Day();
    this->_u8Day = u8Day_;
}

inline void T_TCU_Date_Time::clearU8Hour() {
    if (hasU8Hour()) {
         clear_has_u8Hour();
        _u8Hour = 0u;
     }
}

inline bool T_TCU_Date_Time::hasU8Hour () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 T_TCU_Date_Time::getU8Hour () const {
    return _u8Hour;
}

inline void T_TCU_Date_Time::setU8Hour (uint8 u8Hour_) {
    set_has_u8Hour();
    this->_u8Hour = u8Hour_;
}

inline void T_TCU_Date_Time::clearU8Minute() {
    if (hasU8Minute()) {
         clear_has_u8Minute();
        _u8Minute = 0u;
     }
}

inline bool T_TCU_Date_Time::hasU8Minute () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 T_TCU_Date_Time::getU8Minute () const {
    return _u8Minute;
}

inline void T_TCU_Date_Time::setU8Minute (uint8 u8Minute_) {
    set_has_u8Minute();
    this->_u8Minute = u8Minute_;
}

inline void T_TCU_Date_Time::clearU8Second() {
    if (hasU8Second()) {
         clear_has_u8Second();
        _u8Second = 0u;
     }
}

inline bool T_TCU_Date_Time::hasU8Second () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint8 T_TCU_Date_Time::getU8Second () const {
    return _u8Second;
}

inline void T_TCU_Date_Time::setU8Second (uint8 u8Second_) {
    set_has_u8Second();
    this->_u8Second = u8Second_;
}

inline void T_TCU_Date_Time::clearU8Reserve() {
    if (hasU8Reserve()) {
         clear_has_u8Reserve();
        _u8Reserve = 0u;
     }
}

inline bool T_TCU_Date_Time::hasU8Reserve () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint8 T_TCU_Date_Time::getU8Reserve () const {
    return _u8Reserve;
}

inline void T_TCU_Date_Time::setU8Reserve (uint8 u8Reserve_) {
    set_has_u8Reserve();
    this->_u8Reserve = u8Reserve_;
}

inline void T_TCU_Date_Time::set_has_u16Year () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TCU_Date_Time::clear_has_u16Year () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TCU_Date_Time::set_has_u8Month () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TCU_Date_Time::clear_has_u8Month () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_TCU_Date_Time::set_has_u8Day () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_TCU_Date_Time::clear_has_u8Day () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_TCU_Date_Time::set_has_u8Hour () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_TCU_Date_Time::clear_has_u8Hour () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_TCU_Date_Time::set_has_u8Minute () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_TCU_Date_Time::clear_has_u8Minute () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_TCU_Date_Time::set_has_u8Second () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_TCU_Date_Time::clear_has_u8Second () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_TCU_Date_Time::set_has_u8Reserve () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_TCU_Date_Time::clear_has_u8Reserve () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline  T_TCU_Altitude::T_TCU_Altitude ()  :
    _e8Sign (::tcu_main_fi_types::T_e8_TCU_Sign__Minus),
    _u16Value (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TCU_Altitude::T_TCU_Altitude (const T_TCU_Altitude &rhs)  :
    _e8Sign (::tcu_main_fi_types::T_e8_TCU_Sign__Minus),
    _u16Value (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TCU_Altitude::T_TCU_Altitude (T_e8_TCU_Sign e8Sign_, uint16 u16Value_)  :
    _e8Sign (e8Sign_),
    _u16Value (u16Value_)
{
    #ifndef NDEBUG
    if (!(T_e8_TCU_Sign_IsValid(e8Sign_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Sign_, "T_e8_TCU_Sign", "e8Sign", "T_TCU_Altitude");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TCU_Altitude::~T_TCU_Altitude() {
}

inline T_TCU_Altitude& T_TCU_Altitude::operator = (const T_TCU_Altitude& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE8Sign()) {
            setE8Sign(rhs.getE8Sign());
        } else {
            clearE8Sign();
        }
        if (rhs.hasU16Value()) {
            setU16Value(rhs.getU16Value());
        } else {
            clearU16Value();
        }
    }
    return *this;
}

inline bool T_TCU_Altitude::operator == (const T_TCU_Altitude& rhs) const {
    return (((!hasE8Sign() && !rhs.hasE8Sign()) || getE8Sign() == rhs.getE8Sign()) &&
        ((!hasU16Value() && !rhs.hasU16Value()) || getU16Value() == rhs.getU16Value()));
}

inline bool T_TCU_Altitude::operator != (const T_TCU_Altitude& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TCU_Altitude::operator < (const T_TCU_Altitude& rhs) const {
    if (hasE8Sign() || rhs.hasE8Sign()) {
        if ((uint32)getE8Sign() < (uint32)rhs.getE8Sign()) return true;
        if ((uint32)getE8Sign() > (uint32)rhs.getE8Sign()) return false;
    }
    if (hasU16Value() || rhs.hasU16Value()) {
        if (getU16Value() < rhs.getU16Value()) return true;
        if (getU16Value() > rhs.getU16Value()) return false;
    }
    return false;
}

inline bool T_TCU_Altitude::operator > (const T_TCU_Altitude& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TCU_Altitude::clear() {
    clearE8Sign();
    clearU16Value();
}

inline void T_TCU_Altitude::clearE8Sign() {
    if (hasE8Sign()) {
         clear_has_e8Sign();
        _e8Sign = ::tcu_main_fi_types::T_e8_TCU_Sign__Minus;
     }
}

inline bool T_TCU_Altitude::hasE8Sign () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_TCU_Sign T_TCU_Altitude::getE8Sign () const {
    return _e8Sign;
}

inline void T_TCU_Altitude::setE8Sign (T_e8_TCU_Sign e8Sign_) {
    #ifndef NDEBUG
    if (!(T_e8_TCU_Sign_IsValid(e8Sign_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Sign_, "T_e8_TCU_Sign", "e8Sign", "T_TCU_Altitude");
    }
    #endif
    set_has_e8Sign();
    this->_e8Sign = e8Sign_;
}

inline void T_TCU_Altitude::clearU16Value() {
    if (hasU16Value()) {
         clear_has_u16Value();
        _u16Value = 0u;
     }
}

inline bool T_TCU_Altitude::hasU16Value () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 T_TCU_Altitude::getU16Value () const {
    return _u16Value;
}

inline void T_TCU_Altitude::setU16Value (uint16 u16Value_) {
    set_has_u16Value();
    this->_u16Value = u16Value_;
}

inline void T_TCU_Altitude::set_has_e8Sign () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TCU_Altitude::clear_has_e8Sign () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TCU_Altitude::set_has_u16Value () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TCU_Altitude::clear_has_u16Value () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_TCU_LocationInfo::T_TCU_LocationInfo ()  :
    _e8LocationType (::tcu_main_fi_types::T_e8_TCU_LocationType__Tokyo),
    _e8Latitudemode (::tcu_main_fi_types::T_e8_TCU_LatitudeMode__North),
    _e8LongitudeMode (::tcu_main_fi_types::T_e8_TCU_LongitudeMode__East),
    _u8LatitudeDEG (0u),
    _u8LatitudeMIN (0u),
    _u16LatitudeSEC (0u),
    _u8LongitudeDEG (0u),
    _u8LongitudeMIN (0u),
    _u16LongitudeSEC (0u),
    _Altitude (),
    _u8SatelliteNumber (0u),
    _e8Home (::tcu_main_fi_types::T_e8_TCU_Home__Inside),
    _u8Reserve (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TCU_LocationInfo::T_TCU_LocationInfo (const T_TCU_LocationInfo &rhs)  :
    _e8LocationType (::tcu_main_fi_types::T_e8_TCU_LocationType__Tokyo),
    _e8Latitudemode (::tcu_main_fi_types::T_e8_TCU_LatitudeMode__North),
    _e8LongitudeMode (::tcu_main_fi_types::T_e8_TCU_LongitudeMode__East),
    _u8LatitudeDEG (0u),
    _u8LatitudeMIN (0u),
    _u16LatitudeSEC (0u),
    _u8LongitudeDEG (0u),
    _u8LongitudeMIN (0u),
    _u16LongitudeSEC (0u),
    _Altitude (),
    _u8SatelliteNumber (0u),
    _e8Home (::tcu_main_fi_types::T_e8_TCU_Home__Inside),
    _u8Reserve (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TCU_LocationInfo::T_TCU_LocationInfo (T_e8_TCU_LocationType e8LocationType_, T_e8_TCU_LatitudeMode e8Latitudemode_, T_e8_TCU_LongitudeMode e8LongitudeMode_, uint8 u8LatitudeDEG_, uint8 u8LatitudeMIN_, uint16 u16LatitudeSEC_, uint8 u8LongitudeDEG_, uint8 u8LongitudeMIN_, uint16 u16LongitudeSEC_, const T_TCU_Altitude& Altitude_, uint8 u8SatelliteNumber_, T_e8_TCU_Home e8Home_, uint8 u8Reserve_)  :
    _e8LocationType (e8LocationType_),
    _e8Latitudemode (e8Latitudemode_),
    _e8LongitudeMode (e8LongitudeMode_),
    _u8LatitudeDEG (u8LatitudeDEG_),
    _u8LatitudeMIN (u8LatitudeMIN_),
    _u16LatitudeSEC (u16LatitudeSEC_),
    _u8LongitudeDEG (u8LongitudeDEG_),
    _u8LongitudeMIN (u8LongitudeMIN_),
    _u16LongitudeSEC (u16LongitudeSEC_),
    _Altitude (Altitude_),
    _u8SatelliteNumber (u8SatelliteNumber_),
    _e8Home (e8Home_),
    _u8Reserve (u8Reserve_)
{
    #ifndef NDEBUG
    if (!(T_e8_TCU_LocationType_IsValid(e8LocationType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8LocationType_, "T_e8_TCU_LocationType", "e8LocationType", "T_TCU_LocationInfo");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_TCU_LatitudeMode_IsValid(e8Latitudemode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Latitudemode_, "T_e8_TCU_LatitudeMode", "e8Latitudemode", "T_TCU_LocationInfo");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_TCU_LongitudeMode_IsValid(e8LongitudeMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8LongitudeMode_, "T_e8_TCU_LongitudeMode", "e8LongitudeMode", "T_TCU_LocationInfo");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_TCU_Home_IsValid(e8Home_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Home_, "T_e8_TCU_Home", "e8Home", "T_TCU_LocationInfo");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TCU_LocationInfo::~T_TCU_LocationInfo() {
}

inline T_TCU_LocationInfo& T_TCU_LocationInfo::operator = (const T_TCU_LocationInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE8LocationType()) {
            setE8LocationType(rhs.getE8LocationType());
        } else {
            clearE8LocationType();
        }
        if (rhs.hasE8Latitudemode()) {
            setE8Latitudemode(rhs.getE8Latitudemode());
        } else {
            clearE8Latitudemode();
        }
        if (rhs.hasE8LongitudeMode()) {
            setE8LongitudeMode(rhs.getE8LongitudeMode());
        } else {
            clearE8LongitudeMode();
        }
        if (rhs.hasU8LatitudeDEG()) {
            setU8LatitudeDEG(rhs.getU8LatitudeDEG());
        } else {
            clearU8LatitudeDEG();
        }
        if (rhs.hasU8LatitudeMIN()) {
            setU8LatitudeMIN(rhs.getU8LatitudeMIN());
        } else {
            clearU8LatitudeMIN();
        }
        if (rhs.hasU16LatitudeSEC()) {
            setU16LatitudeSEC(rhs.getU16LatitudeSEC());
        } else {
            clearU16LatitudeSEC();
        }
        if (rhs.hasU8LongitudeDEG()) {
            setU8LongitudeDEG(rhs.getU8LongitudeDEG());
        } else {
            clearU8LongitudeDEG();
        }
        if (rhs.hasU8LongitudeMIN()) {
            setU8LongitudeMIN(rhs.getU8LongitudeMIN());
        } else {
            clearU8LongitudeMIN();
        }
        if (rhs.hasU16LongitudeSEC()) {
            setU16LongitudeSEC(rhs.getU16LongitudeSEC());
        } else {
            clearU16LongitudeSEC();
        }
        if (rhs.hasAltitude()) {
            setAltitude(rhs.getAltitude());
        } else {
            clearAltitude();
        }
        if (rhs.hasU8SatelliteNumber()) {
            setU8SatelliteNumber(rhs.getU8SatelliteNumber());
        } else {
            clearU8SatelliteNumber();
        }
        if (rhs.hasE8Home()) {
            setE8Home(rhs.getE8Home());
        } else {
            clearE8Home();
        }
        if (rhs.hasU8Reserve()) {
            setU8Reserve(rhs.getU8Reserve());
        } else {
            clearU8Reserve();
        }
    }
    return *this;
}

inline bool T_TCU_LocationInfo::operator == (const T_TCU_LocationInfo& rhs) const {
    return (((!hasE8LocationType() && !rhs.hasE8LocationType()) || getE8LocationType() == rhs.getE8LocationType()) &&
        ((!hasE8Latitudemode() && !rhs.hasE8Latitudemode()) || getE8Latitudemode() == rhs.getE8Latitudemode()) &&
        ((!hasE8LongitudeMode() && !rhs.hasE8LongitudeMode()) || getE8LongitudeMode() == rhs.getE8LongitudeMode()) &&
        ((!hasU8LatitudeDEG() && !rhs.hasU8LatitudeDEG()) || getU8LatitudeDEG() == rhs.getU8LatitudeDEG()) &&
        ((!hasU8LatitudeMIN() && !rhs.hasU8LatitudeMIN()) || getU8LatitudeMIN() == rhs.getU8LatitudeMIN()) &&
        ((!hasU16LatitudeSEC() && !rhs.hasU16LatitudeSEC()) || getU16LatitudeSEC() == rhs.getU16LatitudeSEC()) &&
        ((!hasU8LongitudeDEG() && !rhs.hasU8LongitudeDEG()) || getU8LongitudeDEG() == rhs.getU8LongitudeDEG()) &&
        ((!hasU8LongitudeMIN() && !rhs.hasU8LongitudeMIN()) || getU8LongitudeMIN() == rhs.getU8LongitudeMIN()) &&
        ((!hasU16LongitudeSEC() && !rhs.hasU16LongitudeSEC()) || getU16LongitudeSEC() == rhs.getU16LongitudeSEC()) &&
        ((!hasAltitude() && !rhs.hasAltitude()) || getAltitude() == rhs.getAltitude()) &&
        ((!hasU8SatelliteNumber() && !rhs.hasU8SatelliteNumber()) || getU8SatelliteNumber() == rhs.getU8SatelliteNumber()) &&
        ((!hasE8Home() && !rhs.hasE8Home()) || getE8Home() == rhs.getE8Home()) &&
        ((!hasU8Reserve() && !rhs.hasU8Reserve()) || getU8Reserve() == rhs.getU8Reserve()));
}

inline bool T_TCU_LocationInfo::operator != (const T_TCU_LocationInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TCU_LocationInfo::operator < (const T_TCU_LocationInfo& rhs) const {
    if (hasE8LocationType() || rhs.hasE8LocationType()) {
        if ((uint32)getE8LocationType() < (uint32)rhs.getE8LocationType()) return true;
        if ((uint32)getE8LocationType() > (uint32)rhs.getE8LocationType()) return false;
    }
    if (hasE8Latitudemode() || rhs.hasE8Latitudemode()) {
        if ((uint32)getE8Latitudemode() < (uint32)rhs.getE8Latitudemode()) return true;
        if ((uint32)getE8Latitudemode() > (uint32)rhs.getE8Latitudemode()) return false;
    }
    if (hasE8LongitudeMode() || rhs.hasE8LongitudeMode()) {
        if ((uint32)getE8LongitudeMode() < (uint32)rhs.getE8LongitudeMode()) return true;
        if ((uint32)getE8LongitudeMode() > (uint32)rhs.getE8LongitudeMode()) return false;
    }
    if (hasU8LatitudeDEG() || rhs.hasU8LatitudeDEG()) {
        if (getU8LatitudeDEG() < rhs.getU8LatitudeDEG()) return true;
        if (getU8LatitudeDEG() > rhs.getU8LatitudeDEG()) return false;
    }
    if (hasU8LatitudeMIN() || rhs.hasU8LatitudeMIN()) {
        if (getU8LatitudeMIN() < rhs.getU8LatitudeMIN()) return true;
        if (getU8LatitudeMIN() > rhs.getU8LatitudeMIN()) return false;
    }
    if (hasU16LatitudeSEC() || rhs.hasU16LatitudeSEC()) {
        if (getU16LatitudeSEC() < rhs.getU16LatitudeSEC()) return true;
        if (getU16LatitudeSEC() > rhs.getU16LatitudeSEC()) return false;
    }
    if (hasU8LongitudeDEG() || rhs.hasU8LongitudeDEG()) {
        if (getU8LongitudeDEG() < rhs.getU8LongitudeDEG()) return true;
        if (getU8LongitudeDEG() > rhs.getU8LongitudeDEG()) return false;
    }
    if (hasU8LongitudeMIN() || rhs.hasU8LongitudeMIN()) {
        if (getU8LongitudeMIN() < rhs.getU8LongitudeMIN()) return true;
        if (getU8LongitudeMIN() > rhs.getU8LongitudeMIN()) return false;
    }
    if (hasU16LongitudeSEC() || rhs.hasU16LongitudeSEC()) {
        if (getU16LongitudeSEC() < rhs.getU16LongitudeSEC()) return true;
        if (getU16LongitudeSEC() > rhs.getU16LongitudeSEC()) return false;
    }
    if (hasAltitude() || rhs.hasAltitude()) {
        if (getAltitude() < rhs.getAltitude()) return true;
        if (getAltitude() > rhs.getAltitude()) return false;
    }
    if (hasU8SatelliteNumber() || rhs.hasU8SatelliteNumber()) {
        if (getU8SatelliteNumber() < rhs.getU8SatelliteNumber()) return true;
        if (getU8SatelliteNumber() > rhs.getU8SatelliteNumber()) return false;
    }
    if (hasE8Home() || rhs.hasE8Home()) {
        if ((uint32)getE8Home() < (uint32)rhs.getE8Home()) return true;
        if ((uint32)getE8Home() > (uint32)rhs.getE8Home()) return false;
    }
    if (hasU8Reserve() || rhs.hasU8Reserve()) {
        if (getU8Reserve() < rhs.getU8Reserve()) return true;
        if (getU8Reserve() > rhs.getU8Reserve()) return false;
    }
    return false;
}

inline bool T_TCU_LocationInfo::operator > (const T_TCU_LocationInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TCU_LocationInfo::clear() {
    clearE8LocationType();
    clearE8Latitudemode();
    clearE8LongitudeMode();
    clearU8LatitudeDEG();
    clearU8LatitudeMIN();
    clearU16LatitudeSEC();
    clearU8LongitudeDEG();
    clearU8LongitudeMIN();
    clearU16LongitudeSEC();
    clearAltitude();
    clearU8SatelliteNumber();
    clearE8Home();
    clearU8Reserve();
}

inline void T_TCU_LocationInfo::clearE8LocationType() {
    if (hasE8LocationType()) {
         clear_has_e8LocationType();
        _e8LocationType = ::tcu_main_fi_types::T_e8_TCU_LocationType__Tokyo;
     }
}

inline bool T_TCU_LocationInfo::hasE8LocationType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_TCU_LocationType T_TCU_LocationInfo::getE8LocationType () const {
    return _e8LocationType;
}

inline void T_TCU_LocationInfo::setE8LocationType (T_e8_TCU_LocationType e8LocationType_) {
    #ifndef NDEBUG
    if (!(T_e8_TCU_LocationType_IsValid(e8LocationType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8LocationType_, "T_e8_TCU_LocationType", "e8LocationType", "T_TCU_LocationInfo");
    }
    #endif
    set_has_e8LocationType();
    this->_e8LocationType = e8LocationType_;
}

inline void T_TCU_LocationInfo::clearE8Latitudemode() {
    if (hasE8Latitudemode()) {
         clear_has_e8Latitudemode();
        _e8Latitudemode = ::tcu_main_fi_types::T_e8_TCU_LatitudeMode__North;
     }
}

inline bool T_TCU_LocationInfo::hasE8Latitudemode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_TCU_LatitudeMode T_TCU_LocationInfo::getE8Latitudemode () const {
    return _e8Latitudemode;
}

inline void T_TCU_LocationInfo::setE8Latitudemode (T_e8_TCU_LatitudeMode e8Latitudemode_) {
    #ifndef NDEBUG
    if (!(T_e8_TCU_LatitudeMode_IsValid(e8Latitudemode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Latitudemode_, "T_e8_TCU_LatitudeMode", "e8Latitudemode", "T_TCU_LocationInfo");
    }
    #endif
    set_has_e8Latitudemode();
    this->_e8Latitudemode = e8Latitudemode_;
}

inline void T_TCU_LocationInfo::clearE8LongitudeMode() {
    if (hasE8LongitudeMode()) {
         clear_has_e8LongitudeMode();
        _e8LongitudeMode = ::tcu_main_fi_types::T_e8_TCU_LongitudeMode__East;
     }
}

inline bool T_TCU_LocationInfo::hasE8LongitudeMode () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_TCU_LongitudeMode T_TCU_LocationInfo::getE8LongitudeMode () const {
    return _e8LongitudeMode;
}

inline void T_TCU_LocationInfo::setE8LongitudeMode (T_e8_TCU_LongitudeMode e8LongitudeMode_) {
    #ifndef NDEBUG
    if (!(T_e8_TCU_LongitudeMode_IsValid(e8LongitudeMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8LongitudeMode_, "T_e8_TCU_LongitudeMode", "e8LongitudeMode", "T_TCU_LocationInfo");
    }
    #endif
    set_has_e8LongitudeMode();
    this->_e8LongitudeMode = e8LongitudeMode_;
}

inline void T_TCU_LocationInfo::clearU8LatitudeDEG() {
    if (hasU8LatitudeDEG()) {
         clear_has_u8LatitudeDEG();
        _u8LatitudeDEG = 0u;
     }
}

inline bool T_TCU_LocationInfo::hasU8LatitudeDEG () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 T_TCU_LocationInfo::getU8LatitudeDEG () const {
    return _u8LatitudeDEG;
}

inline void T_TCU_LocationInfo::setU8LatitudeDEG (uint8 u8LatitudeDEG_) {
    set_has_u8LatitudeDEG();
    this->_u8LatitudeDEG = u8LatitudeDEG_;
}

inline void T_TCU_LocationInfo::clearU8LatitudeMIN() {
    if (hasU8LatitudeMIN()) {
         clear_has_u8LatitudeMIN();
        _u8LatitudeMIN = 0u;
     }
}

inline bool T_TCU_LocationInfo::hasU8LatitudeMIN () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 T_TCU_LocationInfo::getU8LatitudeMIN () const {
    return _u8LatitudeMIN;
}

inline void T_TCU_LocationInfo::setU8LatitudeMIN (uint8 u8LatitudeMIN_) {
    set_has_u8LatitudeMIN();
    this->_u8LatitudeMIN = u8LatitudeMIN_;
}

inline void T_TCU_LocationInfo::clearU16LatitudeSEC() {
    if (hasU16LatitudeSEC()) {
         clear_has_u16LatitudeSEC();
        _u16LatitudeSEC = 0u;
     }
}

inline bool T_TCU_LocationInfo::hasU16LatitudeSEC () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint16 T_TCU_LocationInfo::getU16LatitudeSEC () const {
    return _u16LatitudeSEC;
}

inline void T_TCU_LocationInfo::setU16LatitudeSEC (uint16 u16LatitudeSEC_) {
    set_has_u16LatitudeSEC();
    this->_u16LatitudeSEC = u16LatitudeSEC_;
}

inline void T_TCU_LocationInfo::clearU8LongitudeDEG() {
    if (hasU8LongitudeDEG()) {
         clear_has_u8LongitudeDEG();
        _u8LongitudeDEG = 0u;
     }
}

inline bool T_TCU_LocationInfo::hasU8LongitudeDEG () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint8 T_TCU_LocationInfo::getU8LongitudeDEG () const {
    return _u8LongitudeDEG;
}

inline void T_TCU_LocationInfo::setU8LongitudeDEG (uint8 u8LongitudeDEG_) {
    set_has_u8LongitudeDEG();
    this->_u8LongitudeDEG = u8LongitudeDEG_;
}

inline void T_TCU_LocationInfo::clearU8LongitudeMIN() {
    if (hasU8LongitudeMIN()) {
         clear_has_u8LongitudeMIN();
        _u8LongitudeMIN = 0u;
     }
}

inline bool T_TCU_LocationInfo::hasU8LongitudeMIN () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline uint8 T_TCU_LocationInfo::getU8LongitudeMIN () const {
    return _u8LongitudeMIN;
}

inline void T_TCU_LocationInfo::setU8LongitudeMIN (uint8 u8LongitudeMIN_) {
    set_has_u8LongitudeMIN();
    this->_u8LongitudeMIN = u8LongitudeMIN_;
}

inline void T_TCU_LocationInfo::clearU16LongitudeSEC() {
    if (hasU16LongitudeSEC()) {
         clear_has_u16LongitudeSEC();
        _u16LongitudeSEC = 0u;
     }
}

inline bool T_TCU_LocationInfo::hasU16LongitudeSEC () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline uint16 T_TCU_LocationInfo::getU16LongitudeSEC () const {
    return _u16LongitudeSEC;
}

inline void T_TCU_LocationInfo::setU16LongitudeSEC (uint16 u16LongitudeSEC_) {
    set_has_u16LongitudeSEC();
    this->_u16LongitudeSEC = u16LongitudeSEC_;
}

inline void T_TCU_LocationInfo::clearAltitude() {
    if (hasAltitude()) {
         clear_has_Altitude();
        _Altitude.clear();
     }
}

inline bool T_TCU_LocationInfo::hasAltitude () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline const T_TCU_Altitude& T_TCU_LocationInfo::getAltitude () const {
    return _Altitude;
}

inline T_TCU_Altitude& T_TCU_LocationInfo::getAltitudeMutable () {
    set_has_Altitude();
    return _Altitude;
}

inline void T_TCU_LocationInfo::setAltitude (const T_TCU_Altitude& Altitude_) {
    set_has_Altitude();
    this->_Altitude = Altitude_;
}

inline void T_TCU_LocationInfo::clearU8SatelliteNumber() {
    if (hasU8SatelliteNumber()) {
         clear_has_u8SatelliteNumber();
        _u8SatelliteNumber = 0u;
     }
}

inline bool T_TCU_LocationInfo::hasU8SatelliteNumber () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline uint8 T_TCU_LocationInfo::getU8SatelliteNumber () const {
    return _u8SatelliteNumber;
}

inline void T_TCU_LocationInfo::setU8SatelliteNumber (uint8 u8SatelliteNumber_) {
    set_has_u8SatelliteNumber();
    this->_u8SatelliteNumber = u8SatelliteNumber_;
}

inline void T_TCU_LocationInfo::clearE8Home() {
    if (hasE8Home()) {
         clear_has_e8Home();
        _e8Home = ::tcu_main_fi_types::T_e8_TCU_Home__Inside;
     }
}

inline bool T_TCU_LocationInfo::hasE8Home () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline T_e8_TCU_Home T_TCU_LocationInfo::getE8Home () const {
    return _e8Home;
}

inline void T_TCU_LocationInfo::setE8Home (T_e8_TCU_Home e8Home_) {
    #ifndef NDEBUG
    if (!(T_e8_TCU_Home_IsValid(e8Home_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Home_, "T_e8_TCU_Home", "e8Home", "T_TCU_LocationInfo");
    }
    #endif
    set_has_e8Home();
    this->_e8Home = e8Home_;
}

inline void T_TCU_LocationInfo::clearU8Reserve() {
    if (hasU8Reserve()) {
         clear_has_u8Reserve();
        _u8Reserve = 0u;
     }
}

inline bool T_TCU_LocationInfo::hasU8Reserve () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline uint8 T_TCU_LocationInfo::getU8Reserve () const {
    return _u8Reserve;
}

inline void T_TCU_LocationInfo::setU8Reserve (uint8 u8Reserve_) {
    set_has_u8Reserve();
    this->_u8Reserve = u8Reserve_;
}

inline void T_TCU_LocationInfo::set_has_e8LocationType () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TCU_LocationInfo::clear_has_e8LocationType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TCU_LocationInfo::set_has_e8Latitudemode () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TCU_LocationInfo::clear_has_e8Latitudemode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_TCU_LocationInfo::set_has_e8LongitudeMode () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_TCU_LocationInfo::clear_has_e8LongitudeMode () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_TCU_LocationInfo::set_has_u8LatitudeDEG () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_TCU_LocationInfo::clear_has_u8LatitudeDEG () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_TCU_LocationInfo::set_has_u8LatitudeMIN () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_TCU_LocationInfo::clear_has_u8LatitudeMIN () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_TCU_LocationInfo::set_has_u16LatitudeSEC () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_TCU_LocationInfo::clear_has_u16LatitudeSEC () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_TCU_LocationInfo::set_has_u8LongitudeDEG () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_TCU_LocationInfo::clear_has_u8LongitudeDEG () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_TCU_LocationInfo::set_has_u8LongitudeMIN () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_TCU_LocationInfo::clear_has_u8LongitudeMIN () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_TCU_LocationInfo::set_has_u16LongitudeSEC () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_TCU_LocationInfo::clear_has_u16LongitudeSEC () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_TCU_LocationInfo::set_has_Altitude () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_TCU_LocationInfo::clear_has_Altitude () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_TCU_LocationInfo::set_has_u8SatelliteNumber () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_TCU_LocationInfo::clear_has_u8SatelliteNumber () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void T_TCU_LocationInfo::set_has_e8Home () {
    _has_bits_[0] |= 1u << 11;
}

inline void T_TCU_LocationInfo::clear_has_e8Home () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void T_TCU_LocationInfo::set_has_u8Reserve () {
    _has_bits_[0] |= 1u << 12;
}

inline void T_TCU_LocationInfo::clear_has_u8Reserve () {
    _has_bits_[0] &= ~ (1u << 12);
}

inline  T_TCU_Navi_Info::T_TCU_Navi_Info ()  :
    _LocationInfo (),
    _rDateTime (),
    _u16VehicleHeading (0u),
    _u8TimeZone (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TCU_Navi_Info::T_TCU_Navi_Info (const T_TCU_Navi_Info &rhs)  :
    _LocationInfo (),
    _rDateTime (),
    _u16VehicleHeading (0u),
    _u8TimeZone (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TCU_Navi_Info::T_TCU_Navi_Info (const T_TCU_LocationInfo& LocationInfo_, const T_TCU_Date_Time& rDateTime_, uint16 u16VehicleHeading_, uint8 u8TimeZone_)  :
    _LocationInfo (LocationInfo_),
    _rDateTime (rDateTime_),
    _u16VehicleHeading (u16VehicleHeading_),
    _u8TimeZone (u8TimeZone_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TCU_Navi_Info::~T_TCU_Navi_Info() {
}

inline T_TCU_Navi_Info& T_TCU_Navi_Info::operator = (const T_TCU_Navi_Info& rhs) {
    if( this != &rhs ) {
        if (rhs.hasLocationInfo()) {
            setLocationInfo(rhs.getLocationInfo());
        } else {
            clearLocationInfo();
        }
        if (rhs.hasRDateTime()) {
            setRDateTime(rhs.getRDateTime());
        } else {
            clearRDateTime();
        }
        if (rhs.hasU16VehicleHeading()) {
            setU16VehicleHeading(rhs.getU16VehicleHeading());
        } else {
            clearU16VehicleHeading();
        }
        if (rhs.hasU8TimeZone()) {
            setU8TimeZone(rhs.getU8TimeZone());
        } else {
            clearU8TimeZone();
        }
    }
    return *this;
}

inline bool T_TCU_Navi_Info::operator == (const T_TCU_Navi_Info& rhs) const {
    return (((!hasLocationInfo() && !rhs.hasLocationInfo()) || getLocationInfo() == rhs.getLocationInfo()) &&
        ((!hasRDateTime() && !rhs.hasRDateTime()) || getRDateTime() == rhs.getRDateTime()) &&
        ((!hasU16VehicleHeading() && !rhs.hasU16VehicleHeading()) || getU16VehicleHeading() == rhs.getU16VehicleHeading()) &&
        ((!hasU8TimeZone() && !rhs.hasU8TimeZone()) || getU8TimeZone() == rhs.getU8TimeZone()));
}

inline bool T_TCU_Navi_Info::operator != (const T_TCU_Navi_Info& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TCU_Navi_Info::operator < (const T_TCU_Navi_Info& rhs) const {
    if (hasLocationInfo() || rhs.hasLocationInfo()) {
        if (getLocationInfo() < rhs.getLocationInfo()) return true;
        if (getLocationInfo() > rhs.getLocationInfo()) return false;
    }
    if (hasRDateTime() || rhs.hasRDateTime()) {
        if (getRDateTime() < rhs.getRDateTime()) return true;
        if (getRDateTime() > rhs.getRDateTime()) return false;
    }
    if (hasU16VehicleHeading() || rhs.hasU16VehicleHeading()) {
        if (getU16VehicleHeading() < rhs.getU16VehicleHeading()) return true;
        if (getU16VehicleHeading() > rhs.getU16VehicleHeading()) return false;
    }
    if (hasU8TimeZone() || rhs.hasU8TimeZone()) {
        if (getU8TimeZone() < rhs.getU8TimeZone()) return true;
        if (getU8TimeZone() > rhs.getU8TimeZone()) return false;
    }
    return false;
}

inline bool T_TCU_Navi_Info::operator > (const T_TCU_Navi_Info& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TCU_Navi_Info::clear() {
    clearLocationInfo();
    clearRDateTime();
    clearU16VehicleHeading();
    clearU8TimeZone();
}

inline void T_TCU_Navi_Info::clearLocationInfo() {
    if (hasLocationInfo()) {
         clear_has_LocationInfo();
        _LocationInfo.clear();
     }
}

inline bool T_TCU_Navi_Info::hasLocationInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const T_TCU_LocationInfo& T_TCU_Navi_Info::getLocationInfo () const {
    return _LocationInfo;
}

inline T_TCU_LocationInfo& T_TCU_Navi_Info::getLocationInfoMutable () {
    set_has_LocationInfo();
    return _LocationInfo;
}

inline void T_TCU_Navi_Info::setLocationInfo (const T_TCU_LocationInfo& LocationInfo_) {
    set_has_LocationInfo();
    this->_LocationInfo = LocationInfo_;
}

inline void T_TCU_Navi_Info::clearRDateTime() {
    if (hasRDateTime()) {
         clear_has_rDateTime();
        _rDateTime.clear();
     }
}

inline bool T_TCU_Navi_Info::hasRDateTime () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const T_TCU_Date_Time& T_TCU_Navi_Info::getRDateTime () const {
    return _rDateTime;
}

inline T_TCU_Date_Time& T_TCU_Navi_Info::getRDateTimeMutable () {
    set_has_rDateTime();
    return _rDateTime;
}

inline void T_TCU_Navi_Info::setRDateTime (const T_TCU_Date_Time& rDateTime_) {
    set_has_rDateTime();
    this->_rDateTime = rDateTime_;
}

inline void T_TCU_Navi_Info::clearU16VehicleHeading() {
    if (hasU16VehicleHeading()) {
         clear_has_u16VehicleHeading();
        _u16VehicleHeading = 0u;
     }
}

inline bool T_TCU_Navi_Info::hasU16VehicleHeading () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 T_TCU_Navi_Info::getU16VehicleHeading () const {
    return _u16VehicleHeading;
}

inline void T_TCU_Navi_Info::setU16VehicleHeading (uint16 u16VehicleHeading_) {
    set_has_u16VehicleHeading();
    this->_u16VehicleHeading = u16VehicleHeading_;
}

inline void T_TCU_Navi_Info::clearU8TimeZone() {
    if (hasU8TimeZone()) {
         clear_has_u8TimeZone();
        _u8TimeZone = 0u;
     }
}

inline bool T_TCU_Navi_Info::hasU8TimeZone () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 T_TCU_Navi_Info::getU8TimeZone () const {
    return _u8TimeZone;
}

inline void T_TCU_Navi_Info::setU8TimeZone (uint8 u8TimeZone_) {
    set_has_u8TimeZone();
    this->_u8TimeZone = u8TimeZone_;
}

inline void T_TCU_Navi_Info::set_has_LocationInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TCU_Navi_Info::clear_has_LocationInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TCU_Navi_Info::set_has_rDateTime () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TCU_Navi_Info::clear_has_rDateTime () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_TCU_Navi_Info::set_has_u16VehicleHeading () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_TCU_Navi_Info::clear_has_u16VehicleHeading () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_TCU_Navi_Info::set_has_u8TimeZone () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_TCU_Navi_Info::clear_has_u8TimeZone () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  T_TCU_Score_Info::T_TCU_Score_Info ()  :
    _u8ECOScore (0u),
    _u8StartScore (0u),
    _u8CruiseScore (0u),
    _u8SlowdownScore (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TCU_Score_Info::T_TCU_Score_Info (const T_TCU_Score_Info &rhs)  :
    _u8ECOScore (0u),
    _u8StartScore (0u),
    _u8CruiseScore (0u),
    _u8SlowdownScore (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TCU_Score_Info::T_TCU_Score_Info (uint8 u8ECOScore_, uint8 u8StartScore_, uint8 u8CruiseScore_, uint8 u8SlowdownScore_)  :
    _u8ECOScore (u8ECOScore_),
    _u8StartScore (u8StartScore_),
    _u8CruiseScore (u8CruiseScore_),
    _u8SlowdownScore (u8SlowdownScore_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TCU_Score_Info::~T_TCU_Score_Info() {
}

inline T_TCU_Score_Info& T_TCU_Score_Info::operator = (const T_TCU_Score_Info& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8ECOScore()) {
            setU8ECOScore(rhs.getU8ECOScore());
        } else {
            clearU8ECOScore();
        }
        if (rhs.hasU8StartScore()) {
            setU8StartScore(rhs.getU8StartScore());
        } else {
            clearU8StartScore();
        }
        if (rhs.hasU8CruiseScore()) {
            setU8CruiseScore(rhs.getU8CruiseScore());
        } else {
            clearU8CruiseScore();
        }
        if (rhs.hasU8SlowdownScore()) {
            setU8SlowdownScore(rhs.getU8SlowdownScore());
        } else {
            clearU8SlowdownScore();
        }
    }
    return *this;
}

inline bool T_TCU_Score_Info::operator == (const T_TCU_Score_Info& rhs) const {
    return (((!hasU8ECOScore() && !rhs.hasU8ECOScore()) || getU8ECOScore() == rhs.getU8ECOScore()) &&
        ((!hasU8StartScore() && !rhs.hasU8StartScore()) || getU8StartScore() == rhs.getU8StartScore()) &&
        ((!hasU8CruiseScore() && !rhs.hasU8CruiseScore()) || getU8CruiseScore() == rhs.getU8CruiseScore()) &&
        ((!hasU8SlowdownScore() && !rhs.hasU8SlowdownScore()) || getU8SlowdownScore() == rhs.getU8SlowdownScore()));
}

inline bool T_TCU_Score_Info::operator != (const T_TCU_Score_Info& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TCU_Score_Info::operator < (const T_TCU_Score_Info& rhs) const {
    if (hasU8ECOScore() || rhs.hasU8ECOScore()) {
        if (getU8ECOScore() < rhs.getU8ECOScore()) return true;
        if (getU8ECOScore() > rhs.getU8ECOScore()) return false;
    }
    if (hasU8StartScore() || rhs.hasU8StartScore()) {
        if (getU8StartScore() < rhs.getU8StartScore()) return true;
        if (getU8StartScore() > rhs.getU8StartScore()) return false;
    }
    if (hasU8CruiseScore() || rhs.hasU8CruiseScore()) {
        if (getU8CruiseScore() < rhs.getU8CruiseScore()) return true;
        if (getU8CruiseScore() > rhs.getU8CruiseScore()) return false;
    }
    if (hasU8SlowdownScore() || rhs.hasU8SlowdownScore()) {
        if (getU8SlowdownScore() < rhs.getU8SlowdownScore()) return true;
        if (getU8SlowdownScore() > rhs.getU8SlowdownScore()) return false;
    }
    return false;
}

inline bool T_TCU_Score_Info::operator > (const T_TCU_Score_Info& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TCU_Score_Info::clear() {
    clearU8ECOScore();
    clearU8StartScore();
    clearU8CruiseScore();
    clearU8SlowdownScore();
}

inline void T_TCU_Score_Info::clearU8ECOScore() {
    if (hasU8ECOScore()) {
         clear_has_u8ECOScore();
        _u8ECOScore = 0u;
     }
}

inline bool T_TCU_Score_Info::hasU8ECOScore () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_TCU_Score_Info::getU8ECOScore () const {
    return _u8ECOScore;
}

inline void T_TCU_Score_Info::setU8ECOScore (uint8 u8ECOScore_) {
    set_has_u8ECOScore();
    this->_u8ECOScore = u8ECOScore_;
}

inline void T_TCU_Score_Info::clearU8StartScore() {
    if (hasU8StartScore()) {
         clear_has_u8StartScore();
        _u8StartScore = 0u;
     }
}

inline bool T_TCU_Score_Info::hasU8StartScore () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_TCU_Score_Info::getU8StartScore () const {
    return _u8StartScore;
}

inline void T_TCU_Score_Info::setU8StartScore (uint8 u8StartScore_) {
    set_has_u8StartScore();
    this->_u8StartScore = u8StartScore_;
}

inline void T_TCU_Score_Info::clearU8CruiseScore() {
    if (hasU8CruiseScore()) {
         clear_has_u8CruiseScore();
        _u8CruiseScore = 0u;
     }
}

inline bool T_TCU_Score_Info::hasU8CruiseScore () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 T_TCU_Score_Info::getU8CruiseScore () const {
    return _u8CruiseScore;
}

inline void T_TCU_Score_Info::setU8CruiseScore (uint8 u8CruiseScore_) {
    set_has_u8CruiseScore();
    this->_u8CruiseScore = u8CruiseScore_;
}

inline void T_TCU_Score_Info::clearU8SlowdownScore() {
    if (hasU8SlowdownScore()) {
         clear_has_u8SlowdownScore();
        _u8SlowdownScore = 0u;
     }
}

inline bool T_TCU_Score_Info::hasU8SlowdownScore () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 T_TCU_Score_Info::getU8SlowdownScore () const {
    return _u8SlowdownScore;
}

inline void T_TCU_Score_Info::setU8SlowdownScore (uint8 u8SlowdownScore_) {
    set_has_u8SlowdownScore();
    this->_u8SlowdownScore = u8SlowdownScore_;
}

inline void T_TCU_Score_Info::set_has_u8ECOScore () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TCU_Score_Info::clear_has_u8ECOScore () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TCU_Score_Info::set_has_u8StartScore () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TCU_Score_Info::clear_has_u8StartScore () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_TCU_Score_Info::set_has_u8CruiseScore () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_TCU_Score_Info::clear_has_u8CruiseScore () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_TCU_Score_Info::set_has_u8SlowdownScore () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_TCU_Score_Info::clear_has_u8SlowdownScore () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  T_TCU_Navi_Road_classification::T_TCU_Navi_Road_classification ()  :
    _u8TableType (0u),
    _u8RoadType (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TCU_Navi_Road_classification::T_TCU_Navi_Road_classification (const T_TCU_Navi_Road_classification &rhs)  :
    _u8TableType (0u),
    _u8RoadType (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TCU_Navi_Road_classification::T_TCU_Navi_Road_classification (uint8 u8TableType_, uint8 u8RoadType_)  :
    _u8TableType (u8TableType_),
    _u8RoadType (u8RoadType_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TCU_Navi_Road_classification::~T_TCU_Navi_Road_classification() {
}

inline T_TCU_Navi_Road_classification& T_TCU_Navi_Road_classification::operator = (const T_TCU_Navi_Road_classification& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8TableType()) {
            setU8TableType(rhs.getU8TableType());
        } else {
            clearU8TableType();
        }
        if (rhs.hasU8RoadType()) {
            setU8RoadType(rhs.getU8RoadType());
        } else {
            clearU8RoadType();
        }
    }
    return *this;
}

inline bool T_TCU_Navi_Road_classification::operator == (const T_TCU_Navi_Road_classification& rhs) const {
    return (((!hasU8TableType() && !rhs.hasU8TableType()) || getU8TableType() == rhs.getU8TableType()) &&
        ((!hasU8RoadType() && !rhs.hasU8RoadType()) || getU8RoadType() == rhs.getU8RoadType()));
}

inline bool T_TCU_Navi_Road_classification::operator != (const T_TCU_Navi_Road_classification& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TCU_Navi_Road_classification::operator < (const T_TCU_Navi_Road_classification& rhs) const {
    if (hasU8TableType() || rhs.hasU8TableType()) {
        if (getU8TableType() < rhs.getU8TableType()) return true;
        if (getU8TableType() > rhs.getU8TableType()) return false;
    }
    if (hasU8RoadType() || rhs.hasU8RoadType()) {
        if (getU8RoadType() < rhs.getU8RoadType()) return true;
        if (getU8RoadType() > rhs.getU8RoadType()) return false;
    }
    return false;
}

inline bool T_TCU_Navi_Road_classification::operator > (const T_TCU_Navi_Road_classification& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TCU_Navi_Road_classification::clear() {
    clearU8TableType();
    clearU8RoadType();
}

inline void T_TCU_Navi_Road_classification::clearU8TableType() {
    if (hasU8TableType()) {
         clear_has_u8TableType();
        _u8TableType = 0u;
     }
}

inline bool T_TCU_Navi_Road_classification::hasU8TableType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_TCU_Navi_Road_classification::getU8TableType () const {
    return _u8TableType;
}

inline void T_TCU_Navi_Road_classification::setU8TableType (uint8 u8TableType_) {
    set_has_u8TableType();
    this->_u8TableType = u8TableType_;
}

inline void T_TCU_Navi_Road_classification::clearU8RoadType() {
    if (hasU8RoadType()) {
         clear_has_u8RoadType();
        _u8RoadType = 0u;
     }
}

inline bool T_TCU_Navi_Road_classification::hasU8RoadType () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_TCU_Navi_Road_classification::getU8RoadType () const {
    return _u8RoadType;
}

inline void T_TCU_Navi_Road_classification::setU8RoadType (uint8 u8RoadType_) {
    set_has_u8RoadType();
    this->_u8RoadType = u8RoadType_;
}

inline void T_TCU_Navi_Road_classification::set_has_u8TableType () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TCU_Navi_Road_classification::clear_has_u8TableType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TCU_Navi_Road_classification::set_has_u8RoadType () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TCU_Navi_Road_classification::clear_has_u8RoadType () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_TCU_Probe_Vehicle_Info::T_TCU_Probe_Vehicle_Info ()  :
    _u16NaviVehicleSpeed (0u),
    _u32NaviDrivingDistance (0u),
    _NaviRoadClassification ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TCU_Probe_Vehicle_Info::T_TCU_Probe_Vehicle_Info (const T_TCU_Probe_Vehicle_Info &rhs)  :
    _u16NaviVehicleSpeed (0u),
    _u32NaviDrivingDistance (0u),
    _NaviRoadClassification ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TCU_Probe_Vehicle_Info::T_TCU_Probe_Vehicle_Info (uint16 u16NaviVehicleSpeed_, uint32 u32NaviDrivingDistance_, const T_TCU_Navi_Road_classification& NaviRoadClassification_)  :
    _u16NaviVehicleSpeed (u16NaviVehicleSpeed_),
    _u32NaviDrivingDistance (u32NaviDrivingDistance_),
    _NaviRoadClassification (NaviRoadClassification_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TCU_Probe_Vehicle_Info::~T_TCU_Probe_Vehicle_Info() {
}

inline T_TCU_Probe_Vehicle_Info& T_TCU_Probe_Vehicle_Info::operator = (const T_TCU_Probe_Vehicle_Info& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU16NaviVehicleSpeed()) {
            setU16NaviVehicleSpeed(rhs.getU16NaviVehicleSpeed());
        } else {
            clearU16NaviVehicleSpeed();
        }
        if (rhs.hasU32NaviDrivingDistance()) {
            setU32NaviDrivingDistance(rhs.getU32NaviDrivingDistance());
        } else {
            clearU32NaviDrivingDistance();
        }
        if (rhs.hasNaviRoadClassification()) {
            setNaviRoadClassification(rhs.getNaviRoadClassification());
        } else {
            clearNaviRoadClassification();
        }
    }
    return *this;
}

inline bool T_TCU_Probe_Vehicle_Info::operator == (const T_TCU_Probe_Vehicle_Info& rhs) const {
    return (((!hasU16NaviVehicleSpeed() && !rhs.hasU16NaviVehicleSpeed()) || getU16NaviVehicleSpeed() == rhs.getU16NaviVehicleSpeed()) &&
        ((!hasU32NaviDrivingDistance() && !rhs.hasU32NaviDrivingDistance()) || getU32NaviDrivingDistance() == rhs.getU32NaviDrivingDistance()) &&
        ((!hasNaviRoadClassification() && !rhs.hasNaviRoadClassification()) || getNaviRoadClassification() == rhs.getNaviRoadClassification()));
}

inline bool T_TCU_Probe_Vehicle_Info::operator != (const T_TCU_Probe_Vehicle_Info& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TCU_Probe_Vehicle_Info::operator < (const T_TCU_Probe_Vehicle_Info& rhs) const {
    if (hasU16NaviVehicleSpeed() || rhs.hasU16NaviVehicleSpeed()) {
        if (getU16NaviVehicleSpeed() < rhs.getU16NaviVehicleSpeed()) return true;
        if (getU16NaviVehicleSpeed() > rhs.getU16NaviVehicleSpeed()) return false;
    }
    if (hasU32NaviDrivingDistance() || rhs.hasU32NaviDrivingDistance()) {
        if (getU32NaviDrivingDistance() < rhs.getU32NaviDrivingDistance()) return true;
        if (getU32NaviDrivingDistance() > rhs.getU32NaviDrivingDistance()) return false;
    }
    if (hasNaviRoadClassification() || rhs.hasNaviRoadClassification()) {
        if (getNaviRoadClassification() < rhs.getNaviRoadClassification()) return true;
        if (getNaviRoadClassification() > rhs.getNaviRoadClassification()) return false;
    }
    return false;
}

inline bool T_TCU_Probe_Vehicle_Info::operator > (const T_TCU_Probe_Vehicle_Info& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TCU_Probe_Vehicle_Info::clear() {
    clearU16NaviVehicleSpeed();
    clearU32NaviDrivingDistance();
    clearNaviRoadClassification();
}

inline void T_TCU_Probe_Vehicle_Info::clearU16NaviVehicleSpeed() {
    if (hasU16NaviVehicleSpeed()) {
         clear_has_u16NaviVehicleSpeed();
        _u16NaviVehicleSpeed = 0u;
     }
}

inline bool T_TCU_Probe_Vehicle_Info::hasU16NaviVehicleSpeed () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 T_TCU_Probe_Vehicle_Info::getU16NaviVehicleSpeed () const {
    return _u16NaviVehicleSpeed;
}

inline void T_TCU_Probe_Vehicle_Info::setU16NaviVehicleSpeed (uint16 u16NaviVehicleSpeed_) {
    set_has_u16NaviVehicleSpeed();
    this->_u16NaviVehicleSpeed = u16NaviVehicleSpeed_;
}

inline void T_TCU_Probe_Vehicle_Info::clearU32NaviDrivingDistance() {
    if (hasU32NaviDrivingDistance()) {
         clear_has_u32NaviDrivingDistance();
        _u32NaviDrivingDistance = 0u;
     }
}

inline bool T_TCU_Probe_Vehicle_Info::hasU32NaviDrivingDistance () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 T_TCU_Probe_Vehicle_Info::getU32NaviDrivingDistance () const {
    return _u32NaviDrivingDistance;
}

inline void T_TCU_Probe_Vehicle_Info::setU32NaviDrivingDistance (uint32 u32NaviDrivingDistance_) {
    set_has_u32NaviDrivingDistance();
    this->_u32NaviDrivingDistance = u32NaviDrivingDistance_;
}

inline void T_TCU_Probe_Vehicle_Info::clearNaviRoadClassification() {
    if (hasNaviRoadClassification()) {
         clear_has_NaviRoadClassification();
        _NaviRoadClassification.clear();
     }
}

inline bool T_TCU_Probe_Vehicle_Info::hasNaviRoadClassification () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const T_TCU_Navi_Road_classification& T_TCU_Probe_Vehicle_Info::getNaviRoadClassification () const {
    return _NaviRoadClassification;
}

inline T_TCU_Navi_Road_classification& T_TCU_Probe_Vehicle_Info::getNaviRoadClassificationMutable () {
    set_has_NaviRoadClassification();
    return _NaviRoadClassification;
}

inline void T_TCU_Probe_Vehicle_Info::setNaviRoadClassification (const T_TCU_Navi_Road_classification& NaviRoadClassification_) {
    set_has_NaviRoadClassification();
    this->_NaviRoadClassification = NaviRoadClassification_;
}

inline void T_TCU_Probe_Vehicle_Info::set_has_u16NaviVehicleSpeed () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TCU_Probe_Vehicle_Info::clear_has_u16NaviVehicleSpeed () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TCU_Probe_Vehicle_Info::set_has_u32NaviDrivingDistance () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TCU_Probe_Vehicle_Info::clear_has_u32NaviDrivingDistance () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_TCU_Probe_Vehicle_Info::set_has_NaviRoadClassification () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_TCU_Probe_Vehicle_Info::clear_has_NaviRoadClassification () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_TCU_Distance_Value::T_TCU_Distance_Value ()  :
    _u16OilFilter (0u),
    _u16Oil (0u),
    _u16Tire (0u),
    _u16User (0u),
    _u16Battery (0u),
    _u16ACFilter (0u),
    _u16Reserve (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TCU_Distance_Value::T_TCU_Distance_Value (const T_TCU_Distance_Value &rhs)  :
    _u16OilFilter (0u),
    _u16Oil (0u),
    _u16Tire (0u),
    _u16User (0u),
    _u16Battery (0u),
    _u16ACFilter (0u),
    _u16Reserve (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TCU_Distance_Value::T_TCU_Distance_Value (uint16 u16OilFilter_, uint16 u16Oil_, uint16 u16Tire_, uint16 u16User_, uint16 u16Battery_, uint16 u16ACFilter_, uint16 u16Reserve_)  :
    _u16OilFilter (u16OilFilter_),
    _u16Oil (u16Oil_),
    _u16Tire (u16Tire_),
    _u16User (u16User_),
    _u16Battery (u16Battery_),
    _u16ACFilter (u16ACFilter_),
    _u16Reserve (u16Reserve_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TCU_Distance_Value::~T_TCU_Distance_Value() {
}

inline T_TCU_Distance_Value& T_TCU_Distance_Value::operator = (const T_TCU_Distance_Value& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU16OilFilter()) {
            setU16OilFilter(rhs.getU16OilFilter());
        } else {
            clearU16OilFilter();
        }
        if (rhs.hasU16Oil()) {
            setU16Oil(rhs.getU16Oil());
        } else {
            clearU16Oil();
        }
        if (rhs.hasU16Tire()) {
            setU16Tire(rhs.getU16Tire());
        } else {
            clearU16Tire();
        }
        if (rhs.hasU16User()) {
            setU16User(rhs.getU16User());
        } else {
            clearU16User();
        }
        if (rhs.hasU16Battery()) {
            setU16Battery(rhs.getU16Battery());
        } else {
            clearU16Battery();
        }
        if (rhs.hasU16ACFilter()) {
            setU16ACFilter(rhs.getU16ACFilter());
        } else {
            clearU16ACFilter();
        }
        if (rhs.hasU16Reserve()) {
            setU16Reserve(rhs.getU16Reserve());
        } else {
            clearU16Reserve();
        }
    }
    return *this;
}

inline bool T_TCU_Distance_Value::operator == (const T_TCU_Distance_Value& rhs) const {
    return (((!hasU16OilFilter() && !rhs.hasU16OilFilter()) || getU16OilFilter() == rhs.getU16OilFilter()) &&
        ((!hasU16Oil() && !rhs.hasU16Oil()) || getU16Oil() == rhs.getU16Oil()) &&
        ((!hasU16Tire() && !rhs.hasU16Tire()) || getU16Tire() == rhs.getU16Tire()) &&
        ((!hasU16User() && !rhs.hasU16User()) || getU16User() == rhs.getU16User()) &&
        ((!hasU16Battery() && !rhs.hasU16Battery()) || getU16Battery() == rhs.getU16Battery()) &&
        ((!hasU16ACFilter() && !rhs.hasU16ACFilter()) || getU16ACFilter() == rhs.getU16ACFilter()) &&
        ((!hasU16Reserve() && !rhs.hasU16Reserve()) || getU16Reserve() == rhs.getU16Reserve()));
}

inline bool T_TCU_Distance_Value::operator != (const T_TCU_Distance_Value& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TCU_Distance_Value::operator < (const T_TCU_Distance_Value& rhs) const {
    if (hasU16OilFilter() || rhs.hasU16OilFilter()) {
        if (getU16OilFilter() < rhs.getU16OilFilter()) return true;
        if (getU16OilFilter() > rhs.getU16OilFilter()) return false;
    }
    if (hasU16Oil() || rhs.hasU16Oil()) {
        if (getU16Oil() < rhs.getU16Oil()) return true;
        if (getU16Oil() > rhs.getU16Oil()) return false;
    }
    if (hasU16Tire() || rhs.hasU16Tire()) {
        if (getU16Tire() < rhs.getU16Tire()) return true;
        if (getU16Tire() > rhs.getU16Tire()) return false;
    }
    if (hasU16User() || rhs.hasU16User()) {
        if (getU16User() < rhs.getU16User()) return true;
        if (getU16User() > rhs.getU16User()) return false;
    }
    if (hasU16Battery() || rhs.hasU16Battery()) {
        if (getU16Battery() < rhs.getU16Battery()) return true;
        if (getU16Battery() > rhs.getU16Battery()) return false;
    }
    if (hasU16ACFilter() || rhs.hasU16ACFilter()) {
        if (getU16ACFilter() < rhs.getU16ACFilter()) return true;
        if (getU16ACFilter() > rhs.getU16ACFilter()) return false;
    }
    if (hasU16Reserve() || rhs.hasU16Reserve()) {
        if (getU16Reserve() < rhs.getU16Reserve()) return true;
        if (getU16Reserve() > rhs.getU16Reserve()) return false;
    }
    return false;
}

inline bool T_TCU_Distance_Value::operator > (const T_TCU_Distance_Value& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TCU_Distance_Value::clear() {
    clearU16OilFilter();
    clearU16Oil();
    clearU16Tire();
    clearU16User();
    clearU16Battery();
    clearU16ACFilter();
    clearU16Reserve();
}

inline void T_TCU_Distance_Value::clearU16OilFilter() {
    if (hasU16OilFilter()) {
         clear_has_u16OilFilter();
        _u16OilFilter = 0u;
     }
}

inline bool T_TCU_Distance_Value::hasU16OilFilter () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 T_TCU_Distance_Value::getU16OilFilter () const {
    return _u16OilFilter;
}

inline void T_TCU_Distance_Value::setU16OilFilter (uint16 u16OilFilter_) {
    set_has_u16OilFilter();
    this->_u16OilFilter = u16OilFilter_;
}

inline void T_TCU_Distance_Value::clearU16Oil() {
    if (hasU16Oil()) {
         clear_has_u16Oil();
        _u16Oil = 0u;
     }
}

inline bool T_TCU_Distance_Value::hasU16Oil () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 T_TCU_Distance_Value::getU16Oil () const {
    return _u16Oil;
}

inline void T_TCU_Distance_Value::setU16Oil (uint16 u16Oil_) {
    set_has_u16Oil();
    this->_u16Oil = u16Oil_;
}

inline void T_TCU_Distance_Value::clearU16Tire() {
    if (hasU16Tire()) {
         clear_has_u16Tire();
        _u16Tire = 0u;
     }
}

inline bool T_TCU_Distance_Value::hasU16Tire () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 T_TCU_Distance_Value::getU16Tire () const {
    return _u16Tire;
}

inline void T_TCU_Distance_Value::setU16Tire (uint16 u16Tire_) {
    set_has_u16Tire();
    this->_u16Tire = u16Tire_;
}

inline void T_TCU_Distance_Value::clearU16User() {
    if (hasU16User()) {
         clear_has_u16User();
        _u16User = 0u;
     }
}

inline bool T_TCU_Distance_Value::hasU16User () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 T_TCU_Distance_Value::getU16User () const {
    return _u16User;
}

inline void T_TCU_Distance_Value::setU16User (uint16 u16User_) {
    set_has_u16User();
    this->_u16User = u16User_;
}

inline void T_TCU_Distance_Value::clearU16Battery() {
    if (hasU16Battery()) {
         clear_has_u16Battery();
        _u16Battery = 0u;
     }
}

inline bool T_TCU_Distance_Value::hasU16Battery () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint16 T_TCU_Distance_Value::getU16Battery () const {
    return _u16Battery;
}

inline void T_TCU_Distance_Value::setU16Battery (uint16 u16Battery_) {
    set_has_u16Battery();
    this->_u16Battery = u16Battery_;
}

inline void T_TCU_Distance_Value::clearU16ACFilter() {
    if (hasU16ACFilter()) {
         clear_has_u16ACFilter();
        _u16ACFilter = 0u;
     }
}

inline bool T_TCU_Distance_Value::hasU16ACFilter () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint16 T_TCU_Distance_Value::getU16ACFilter () const {
    return _u16ACFilter;
}

inline void T_TCU_Distance_Value::setU16ACFilter (uint16 u16ACFilter_) {
    set_has_u16ACFilter();
    this->_u16ACFilter = u16ACFilter_;
}

inline void T_TCU_Distance_Value::clearU16Reserve() {
    if (hasU16Reserve()) {
         clear_has_u16Reserve();
        _u16Reserve = 0u;
     }
}

inline bool T_TCU_Distance_Value::hasU16Reserve () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint16 T_TCU_Distance_Value::getU16Reserve () const {
    return _u16Reserve;
}

inline void T_TCU_Distance_Value::setU16Reserve (uint16 u16Reserve_) {
    set_has_u16Reserve();
    this->_u16Reserve = u16Reserve_;
}

inline void T_TCU_Distance_Value::set_has_u16OilFilter () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TCU_Distance_Value::clear_has_u16OilFilter () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TCU_Distance_Value::set_has_u16Oil () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TCU_Distance_Value::clear_has_u16Oil () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_TCU_Distance_Value::set_has_u16Tire () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_TCU_Distance_Value::clear_has_u16Tire () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_TCU_Distance_Value::set_has_u16User () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_TCU_Distance_Value::clear_has_u16User () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_TCU_Distance_Value::set_has_u16Battery () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_TCU_Distance_Value::clear_has_u16Battery () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_TCU_Distance_Value::set_has_u16ACFilter () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_TCU_Distance_Value::clear_has_u16ACFilter () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_TCU_Distance_Value::set_has_u16Reserve () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_TCU_Distance_Value::clear_has_u16Reserve () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline  T_TCU_Maintenance_Info::T_TCU_Maintenance_Info ()  :
    _e8DistanceUnit (::tcu_main_fi_types::T_e8_TCU_Distance_Unit__mile),
    _rDistanceValue ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TCU_Maintenance_Info::T_TCU_Maintenance_Info (const T_TCU_Maintenance_Info &rhs)  :
    _e8DistanceUnit (::tcu_main_fi_types::T_e8_TCU_Distance_Unit__mile),
    _rDistanceValue ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TCU_Maintenance_Info::T_TCU_Maintenance_Info (T_e8_TCU_Distance_Unit e8DistanceUnit_, const T_TCU_Distance_Value& rDistanceValue_)  :
    _e8DistanceUnit (e8DistanceUnit_),
    _rDistanceValue (rDistanceValue_)
{
    #ifndef NDEBUG
    if (!(T_e8_TCU_Distance_Unit_IsValid(e8DistanceUnit_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DistanceUnit_, "T_e8_TCU_Distance_Unit", "e8DistanceUnit", "T_TCU_Maintenance_Info");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TCU_Maintenance_Info::~T_TCU_Maintenance_Info() {
}

inline T_TCU_Maintenance_Info& T_TCU_Maintenance_Info::operator = (const T_TCU_Maintenance_Info& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE8DistanceUnit()) {
            setE8DistanceUnit(rhs.getE8DistanceUnit());
        } else {
            clearE8DistanceUnit();
        }
        if (rhs.hasRDistanceValue()) {
            setRDistanceValue(rhs.getRDistanceValue());
        } else {
            clearRDistanceValue();
        }
    }
    return *this;
}

inline bool T_TCU_Maintenance_Info::operator == (const T_TCU_Maintenance_Info& rhs) const {
    return (((!hasE8DistanceUnit() && !rhs.hasE8DistanceUnit()) || getE8DistanceUnit() == rhs.getE8DistanceUnit()) &&
        ((!hasRDistanceValue() && !rhs.hasRDistanceValue()) || getRDistanceValue() == rhs.getRDistanceValue()));
}

inline bool T_TCU_Maintenance_Info::operator != (const T_TCU_Maintenance_Info& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TCU_Maintenance_Info::operator < (const T_TCU_Maintenance_Info& rhs) const {
    if (hasE8DistanceUnit() || rhs.hasE8DistanceUnit()) {
        if ((uint32)getE8DistanceUnit() < (uint32)rhs.getE8DistanceUnit()) return true;
        if ((uint32)getE8DistanceUnit() > (uint32)rhs.getE8DistanceUnit()) return false;
    }
    if (hasRDistanceValue() || rhs.hasRDistanceValue()) {
        if (getRDistanceValue() < rhs.getRDistanceValue()) return true;
        if (getRDistanceValue() > rhs.getRDistanceValue()) return false;
    }
    return false;
}

inline bool T_TCU_Maintenance_Info::operator > (const T_TCU_Maintenance_Info& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TCU_Maintenance_Info::clear() {
    clearE8DistanceUnit();
    clearRDistanceValue();
}

inline void T_TCU_Maintenance_Info::clearE8DistanceUnit() {
    if (hasE8DistanceUnit()) {
         clear_has_e8DistanceUnit();
        _e8DistanceUnit = ::tcu_main_fi_types::T_e8_TCU_Distance_Unit__mile;
     }
}

inline bool T_TCU_Maintenance_Info::hasE8DistanceUnit () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_TCU_Distance_Unit T_TCU_Maintenance_Info::getE8DistanceUnit () const {
    return _e8DistanceUnit;
}

inline void T_TCU_Maintenance_Info::setE8DistanceUnit (T_e8_TCU_Distance_Unit e8DistanceUnit_) {
    #ifndef NDEBUG
    if (!(T_e8_TCU_Distance_Unit_IsValid(e8DistanceUnit_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DistanceUnit_, "T_e8_TCU_Distance_Unit", "e8DistanceUnit", "T_TCU_Maintenance_Info");
    }
    #endif
    set_has_e8DistanceUnit();
    this->_e8DistanceUnit = e8DistanceUnit_;
}

inline void T_TCU_Maintenance_Info::clearRDistanceValue() {
    if (hasRDistanceValue()) {
         clear_has_rDistanceValue();
        _rDistanceValue.clear();
     }
}

inline bool T_TCU_Maintenance_Info::hasRDistanceValue () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const T_TCU_Distance_Value& T_TCU_Maintenance_Info::getRDistanceValue () const {
    return _rDistanceValue;
}

inline T_TCU_Distance_Value& T_TCU_Maintenance_Info::getRDistanceValueMutable () {
    set_has_rDistanceValue();
    return _rDistanceValue;
}

inline void T_TCU_Maintenance_Info::setRDistanceValue (const T_TCU_Distance_Value& rDistanceValue_) {
    set_has_rDistanceValue();
    this->_rDistanceValue = rDistanceValue_;
}

inline void T_TCU_Maintenance_Info::set_has_e8DistanceUnit () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TCU_Maintenance_Info::clear_has_e8DistanceUnit () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TCU_Maintenance_Info::set_has_rDistanceValue () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TCU_Maintenance_Info::clear_has_rDistanceValue () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_TCU_Provision_List::T_TCU_Provision_List ()  :
    _bOperatorService (false),
    _bConnectedSearch (false),
    _bMobileInformation (false),
    _u16ReserveNissan (0u),
    _bInternetWidget (false),
    _bFuelPrice (false),
    _bLocalSearch (false),
    _bWebPreTrip (false),
    _bHDTraffic (false),
    _bSpeedTrap (false),
    _bPreventNav (false),
    _bWeather (false),
    _bLiveServices (false),
    _bChargingSpotFinder (false),
    _bChargingSchedule (false),
    _u16ReserveRenault (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TCU_Provision_List::T_TCU_Provision_List (const T_TCU_Provision_List &rhs)  :
    _bOperatorService (false),
    _bConnectedSearch (false),
    _bMobileInformation (false),
    _u16ReserveNissan (0u),
    _bInternetWidget (false),
    _bFuelPrice (false),
    _bLocalSearch (false),
    _bWebPreTrip (false),
    _bHDTraffic (false),
    _bSpeedTrap (false),
    _bPreventNav (false),
    _bWeather (false),
    _bLiveServices (false),
    _bChargingSpotFinder (false),
    _bChargingSchedule (false),
    _u16ReserveRenault (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TCU_Provision_List::T_TCU_Provision_List (bool bOperatorService_, bool bConnectedSearch_, bool bMobileInformation_, uint16 u16ReserveNissan_, bool bInternetWidget_, bool bFuelPrice_, bool bLocalSearch_, bool bWebPreTrip_, bool bHDTraffic_, bool bSpeedTrap_, bool bPreventNav_, bool bWeather_, bool bLiveServices_, bool bChargingSpotFinder_, bool bChargingSchedule_, uint16 u16ReserveRenault_)  :
    _bOperatorService (bOperatorService_),
    _bConnectedSearch (bConnectedSearch_),
    _bMobileInformation (bMobileInformation_),
    _u16ReserveNissan (u16ReserveNissan_),
    _bInternetWidget (bInternetWidget_),
    _bFuelPrice (bFuelPrice_),
    _bLocalSearch (bLocalSearch_),
    _bWebPreTrip (bWebPreTrip_),
    _bHDTraffic (bHDTraffic_),
    _bSpeedTrap (bSpeedTrap_),
    _bPreventNav (bPreventNav_),
    _bWeather (bWeather_),
    _bLiveServices (bLiveServices_),
    _bChargingSpotFinder (bChargingSpotFinder_),
    _bChargingSchedule (bChargingSchedule_),
    _u16ReserveRenault (u16ReserveRenault_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TCU_Provision_List::~T_TCU_Provision_List() {
}

inline T_TCU_Provision_List& T_TCU_Provision_List::operator = (const T_TCU_Provision_List& rhs) {
    if( this != &rhs ) {
        if (rhs.hasBOperatorService()) {
            setBOperatorService(rhs.getBOperatorService());
        } else {
            clearBOperatorService();
        }
        if (rhs.hasBConnectedSearch()) {
            setBConnectedSearch(rhs.getBConnectedSearch());
        } else {
            clearBConnectedSearch();
        }
        if (rhs.hasBMobileInformation()) {
            setBMobileInformation(rhs.getBMobileInformation());
        } else {
            clearBMobileInformation();
        }
        if (rhs.hasU16ReserveNissan()) {
            setU16ReserveNissan(rhs.getU16ReserveNissan());
        } else {
            clearU16ReserveNissan();
        }
        if (rhs.hasBInternetWidget()) {
            setBInternetWidget(rhs.getBInternetWidget());
        } else {
            clearBInternetWidget();
        }
        if (rhs.hasBFuelPrice()) {
            setBFuelPrice(rhs.getBFuelPrice());
        } else {
            clearBFuelPrice();
        }
        if (rhs.hasBLocalSearch()) {
            setBLocalSearch(rhs.getBLocalSearch());
        } else {
            clearBLocalSearch();
        }
        if (rhs.hasBWebPreTrip()) {
            setBWebPreTrip(rhs.getBWebPreTrip());
        } else {
            clearBWebPreTrip();
        }
        if (rhs.hasBHDTraffic()) {
            setBHDTraffic(rhs.getBHDTraffic());
        } else {
            clearBHDTraffic();
        }
        if (rhs.hasBSpeedTrap()) {
            setBSpeedTrap(rhs.getBSpeedTrap());
        } else {
            clearBSpeedTrap();
        }
        if (rhs.hasBPreventNav()) {
            setBPreventNav(rhs.getBPreventNav());
        } else {
            clearBPreventNav();
        }
        if (rhs.hasBWeather()) {
            setBWeather(rhs.getBWeather());
        } else {
            clearBWeather();
        }
        if (rhs.hasBLiveServices()) {
            setBLiveServices(rhs.getBLiveServices());
        } else {
            clearBLiveServices();
        }
        if (rhs.hasBChargingSpotFinder()) {
            setBChargingSpotFinder(rhs.getBChargingSpotFinder());
        } else {
            clearBChargingSpotFinder();
        }
        if (rhs.hasBChargingSchedule()) {
            setBChargingSchedule(rhs.getBChargingSchedule());
        } else {
            clearBChargingSchedule();
        }
        if (rhs.hasU16ReserveRenault()) {
            setU16ReserveRenault(rhs.getU16ReserveRenault());
        } else {
            clearU16ReserveRenault();
        }
    }
    return *this;
}

inline bool T_TCU_Provision_List::operator == (const T_TCU_Provision_List& rhs) const {
    return (((!hasBOperatorService() && !rhs.hasBOperatorService()) || getBOperatorService() == rhs.getBOperatorService()) &&
        ((!hasBConnectedSearch() && !rhs.hasBConnectedSearch()) || getBConnectedSearch() == rhs.getBConnectedSearch()) &&
        ((!hasBMobileInformation() && !rhs.hasBMobileInformation()) || getBMobileInformation() == rhs.getBMobileInformation()) &&
        ((!hasU16ReserveNissan() && !rhs.hasU16ReserveNissan()) || getU16ReserveNissan() == rhs.getU16ReserveNissan()) &&
        ((!hasBInternetWidget() && !rhs.hasBInternetWidget()) || getBInternetWidget() == rhs.getBInternetWidget()) &&
        ((!hasBFuelPrice() && !rhs.hasBFuelPrice()) || getBFuelPrice() == rhs.getBFuelPrice()) &&
        ((!hasBLocalSearch() && !rhs.hasBLocalSearch()) || getBLocalSearch() == rhs.getBLocalSearch()) &&
        ((!hasBWebPreTrip() && !rhs.hasBWebPreTrip()) || getBWebPreTrip() == rhs.getBWebPreTrip()) &&
        ((!hasBHDTraffic() && !rhs.hasBHDTraffic()) || getBHDTraffic() == rhs.getBHDTraffic()) &&
        ((!hasBSpeedTrap() && !rhs.hasBSpeedTrap()) || getBSpeedTrap() == rhs.getBSpeedTrap()) &&
        ((!hasBPreventNav() && !rhs.hasBPreventNav()) || getBPreventNav() == rhs.getBPreventNav()) &&
        ((!hasBWeather() && !rhs.hasBWeather()) || getBWeather() == rhs.getBWeather()) &&
        ((!hasBLiveServices() && !rhs.hasBLiveServices()) || getBLiveServices() == rhs.getBLiveServices()) &&
        ((!hasBChargingSpotFinder() && !rhs.hasBChargingSpotFinder()) || getBChargingSpotFinder() == rhs.getBChargingSpotFinder()) &&
        ((!hasBChargingSchedule() && !rhs.hasBChargingSchedule()) || getBChargingSchedule() == rhs.getBChargingSchedule()) &&
        ((!hasU16ReserveRenault() && !rhs.hasU16ReserveRenault()) || getU16ReserveRenault() == rhs.getU16ReserveRenault()));
}

inline bool T_TCU_Provision_List::operator != (const T_TCU_Provision_List& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TCU_Provision_List::operator < (const T_TCU_Provision_List& rhs) const {
    if (hasBOperatorService() || rhs.hasBOperatorService()) {
        if (getBOperatorService() < rhs.getBOperatorService()) return true;
        if (getBOperatorService() > rhs.getBOperatorService()) return false;
    }
    if (hasBConnectedSearch() || rhs.hasBConnectedSearch()) {
        if (getBConnectedSearch() < rhs.getBConnectedSearch()) return true;
        if (getBConnectedSearch() > rhs.getBConnectedSearch()) return false;
    }
    if (hasBMobileInformation() || rhs.hasBMobileInformation()) {
        if (getBMobileInformation() < rhs.getBMobileInformation()) return true;
        if (getBMobileInformation() > rhs.getBMobileInformation()) return false;
    }
    if (hasU16ReserveNissan() || rhs.hasU16ReserveNissan()) {
        if (getU16ReserveNissan() < rhs.getU16ReserveNissan()) return true;
        if (getU16ReserveNissan() > rhs.getU16ReserveNissan()) return false;
    }
    if (hasBInternetWidget() || rhs.hasBInternetWidget()) {
        if (getBInternetWidget() < rhs.getBInternetWidget()) return true;
        if (getBInternetWidget() > rhs.getBInternetWidget()) return false;
    }
    if (hasBFuelPrice() || rhs.hasBFuelPrice()) {
        if (getBFuelPrice() < rhs.getBFuelPrice()) return true;
        if (getBFuelPrice() > rhs.getBFuelPrice()) return false;
    }
    if (hasBLocalSearch() || rhs.hasBLocalSearch()) {
        if (getBLocalSearch() < rhs.getBLocalSearch()) return true;
        if (getBLocalSearch() > rhs.getBLocalSearch()) return false;
    }
    if (hasBWebPreTrip() || rhs.hasBWebPreTrip()) {
        if (getBWebPreTrip() < rhs.getBWebPreTrip()) return true;
        if (getBWebPreTrip() > rhs.getBWebPreTrip()) return false;
    }
    if (hasBHDTraffic() || rhs.hasBHDTraffic()) {
        if (getBHDTraffic() < rhs.getBHDTraffic()) return true;
        if (getBHDTraffic() > rhs.getBHDTraffic()) return false;
    }
    if (hasBSpeedTrap() || rhs.hasBSpeedTrap()) {
        if (getBSpeedTrap() < rhs.getBSpeedTrap()) return true;
        if (getBSpeedTrap() > rhs.getBSpeedTrap()) return false;
    }
    if (hasBPreventNav() || rhs.hasBPreventNav()) {
        if (getBPreventNav() < rhs.getBPreventNav()) return true;
        if (getBPreventNav() > rhs.getBPreventNav()) return false;
    }
    if (hasBWeather() || rhs.hasBWeather()) {
        if (getBWeather() < rhs.getBWeather()) return true;
        if (getBWeather() > rhs.getBWeather()) return false;
    }
    if (hasBLiveServices() || rhs.hasBLiveServices()) {
        if (getBLiveServices() < rhs.getBLiveServices()) return true;
        if (getBLiveServices() > rhs.getBLiveServices()) return false;
    }
    if (hasBChargingSpotFinder() || rhs.hasBChargingSpotFinder()) {
        if (getBChargingSpotFinder() < rhs.getBChargingSpotFinder()) return true;
        if (getBChargingSpotFinder() > rhs.getBChargingSpotFinder()) return false;
    }
    if (hasBChargingSchedule() || rhs.hasBChargingSchedule()) {
        if (getBChargingSchedule() < rhs.getBChargingSchedule()) return true;
        if (getBChargingSchedule() > rhs.getBChargingSchedule()) return false;
    }
    if (hasU16ReserveRenault() || rhs.hasU16ReserveRenault()) {
        if (getU16ReserveRenault() < rhs.getU16ReserveRenault()) return true;
        if (getU16ReserveRenault() > rhs.getU16ReserveRenault()) return false;
    }
    return false;
}

inline bool T_TCU_Provision_List::operator > (const T_TCU_Provision_List& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TCU_Provision_List::clear() {
    clearBOperatorService();
    clearBConnectedSearch();
    clearBMobileInformation();
    clearU16ReserveNissan();
    clearBInternetWidget();
    clearBFuelPrice();
    clearBLocalSearch();
    clearBWebPreTrip();
    clearBHDTraffic();
    clearBSpeedTrap();
    clearBPreventNav();
    clearBWeather();
    clearBLiveServices();
    clearBChargingSpotFinder();
    clearBChargingSchedule();
    clearU16ReserveRenault();
}

inline void T_TCU_Provision_List::clearBOperatorService() {
    if (hasBOperatorService()) {
         clear_has_bOperatorService();
        _bOperatorService = false;
     }
}

inline bool T_TCU_Provision_List::hasBOperatorService () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool T_TCU_Provision_List::getBOperatorService () const {
    return _bOperatorService;
}

inline void T_TCU_Provision_List::setBOperatorService (bool bOperatorService_) {
    set_has_bOperatorService();
    this->_bOperatorService = bOperatorService_;
}

inline void T_TCU_Provision_List::clearBConnectedSearch() {
    if (hasBConnectedSearch()) {
         clear_has_bConnectedSearch();
        _bConnectedSearch = false;
     }
}

inline bool T_TCU_Provision_List::hasBConnectedSearch () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool T_TCU_Provision_List::getBConnectedSearch () const {
    return _bConnectedSearch;
}

inline void T_TCU_Provision_List::setBConnectedSearch (bool bConnectedSearch_) {
    set_has_bConnectedSearch();
    this->_bConnectedSearch = bConnectedSearch_;
}

inline void T_TCU_Provision_List::clearBMobileInformation() {
    if (hasBMobileInformation()) {
         clear_has_bMobileInformation();
        _bMobileInformation = false;
     }
}

inline bool T_TCU_Provision_List::hasBMobileInformation () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline bool T_TCU_Provision_List::getBMobileInformation () const {
    return _bMobileInformation;
}

inline void T_TCU_Provision_List::setBMobileInformation (bool bMobileInformation_) {
    set_has_bMobileInformation();
    this->_bMobileInformation = bMobileInformation_;
}

inline void T_TCU_Provision_List::clearU16ReserveNissan() {
    if (hasU16ReserveNissan()) {
         clear_has_u16ReserveNissan();
        _u16ReserveNissan = 0u;
     }
}

inline bool T_TCU_Provision_List::hasU16ReserveNissan () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 T_TCU_Provision_List::getU16ReserveNissan () const {
    return _u16ReserveNissan;
}

inline void T_TCU_Provision_List::setU16ReserveNissan (uint16 u16ReserveNissan_) {
    set_has_u16ReserveNissan();
    this->_u16ReserveNissan = u16ReserveNissan_;
}

inline void T_TCU_Provision_List::clearBInternetWidget() {
    if (hasBInternetWidget()) {
         clear_has_bInternetWidget();
        _bInternetWidget = false;
     }
}

inline bool T_TCU_Provision_List::hasBInternetWidget () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline bool T_TCU_Provision_List::getBInternetWidget () const {
    return _bInternetWidget;
}

inline void T_TCU_Provision_List::setBInternetWidget (bool bInternetWidget_) {
    set_has_bInternetWidget();
    this->_bInternetWidget = bInternetWidget_;
}

inline void T_TCU_Provision_List::clearBFuelPrice() {
    if (hasBFuelPrice()) {
         clear_has_bFuelPrice();
        _bFuelPrice = false;
     }
}

inline bool T_TCU_Provision_List::hasBFuelPrice () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline bool T_TCU_Provision_List::getBFuelPrice () const {
    return _bFuelPrice;
}

inline void T_TCU_Provision_List::setBFuelPrice (bool bFuelPrice_) {
    set_has_bFuelPrice();
    this->_bFuelPrice = bFuelPrice_;
}

inline void T_TCU_Provision_List::clearBLocalSearch() {
    if (hasBLocalSearch()) {
         clear_has_bLocalSearch();
        _bLocalSearch = false;
     }
}

inline bool T_TCU_Provision_List::hasBLocalSearch () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline bool T_TCU_Provision_List::getBLocalSearch () const {
    return _bLocalSearch;
}

inline void T_TCU_Provision_List::setBLocalSearch (bool bLocalSearch_) {
    set_has_bLocalSearch();
    this->_bLocalSearch = bLocalSearch_;
}

inline void T_TCU_Provision_List::clearBWebPreTrip() {
    if (hasBWebPreTrip()) {
         clear_has_bWebPreTrip();
        _bWebPreTrip = false;
     }
}

inline bool T_TCU_Provision_List::hasBWebPreTrip () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline bool T_TCU_Provision_List::getBWebPreTrip () const {
    return _bWebPreTrip;
}

inline void T_TCU_Provision_List::setBWebPreTrip (bool bWebPreTrip_) {
    set_has_bWebPreTrip();
    this->_bWebPreTrip = bWebPreTrip_;
}

inline void T_TCU_Provision_List::clearBHDTraffic() {
    if (hasBHDTraffic()) {
         clear_has_bHDTraffic();
        _bHDTraffic = false;
     }
}

inline bool T_TCU_Provision_List::hasBHDTraffic () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline bool T_TCU_Provision_List::getBHDTraffic () const {
    return _bHDTraffic;
}

inline void T_TCU_Provision_List::setBHDTraffic (bool bHDTraffic_) {
    set_has_bHDTraffic();
    this->_bHDTraffic = bHDTraffic_;
}

inline void T_TCU_Provision_List::clearBSpeedTrap() {
    if (hasBSpeedTrap()) {
         clear_has_bSpeedTrap();
        _bSpeedTrap = false;
     }
}

inline bool T_TCU_Provision_List::hasBSpeedTrap () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline bool T_TCU_Provision_List::getBSpeedTrap () const {
    return _bSpeedTrap;
}

inline void T_TCU_Provision_List::setBSpeedTrap (bool bSpeedTrap_) {
    set_has_bSpeedTrap();
    this->_bSpeedTrap = bSpeedTrap_;
}

inline void T_TCU_Provision_List::clearBPreventNav() {
    if (hasBPreventNav()) {
         clear_has_bPreventNav();
        _bPreventNav = false;
     }
}

inline bool T_TCU_Provision_List::hasBPreventNav () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline bool T_TCU_Provision_List::getBPreventNav () const {
    return _bPreventNav;
}

inline void T_TCU_Provision_List::setBPreventNav (bool bPreventNav_) {
    set_has_bPreventNav();
    this->_bPreventNav = bPreventNav_;
}

inline void T_TCU_Provision_List::clearBWeather() {
    if (hasBWeather()) {
         clear_has_bWeather();
        _bWeather = false;
     }
}

inline bool T_TCU_Provision_List::hasBWeather () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline bool T_TCU_Provision_List::getBWeather () const {
    return _bWeather;
}

inline void T_TCU_Provision_List::setBWeather (bool bWeather_) {
    set_has_bWeather();
    this->_bWeather = bWeather_;
}

inline void T_TCU_Provision_List::clearBLiveServices() {
    if (hasBLiveServices()) {
         clear_has_bLiveServices();
        _bLiveServices = false;
     }
}

inline bool T_TCU_Provision_List::hasBLiveServices () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline bool T_TCU_Provision_List::getBLiveServices () const {
    return _bLiveServices;
}

inline void T_TCU_Provision_List::setBLiveServices (bool bLiveServices_) {
    set_has_bLiveServices();
    this->_bLiveServices = bLiveServices_;
}

inline void T_TCU_Provision_List::clearBChargingSpotFinder() {
    if (hasBChargingSpotFinder()) {
         clear_has_bChargingSpotFinder();
        _bChargingSpotFinder = false;
     }
}

inline bool T_TCU_Provision_List::hasBChargingSpotFinder () const {
    return (_has_bits_[0] & (1u << 13)) > 0;
}

inline bool T_TCU_Provision_List::getBChargingSpotFinder () const {
    return _bChargingSpotFinder;
}

inline void T_TCU_Provision_List::setBChargingSpotFinder (bool bChargingSpotFinder_) {
    set_has_bChargingSpotFinder();
    this->_bChargingSpotFinder = bChargingSpotFinder_;
}

inline void T_TCU_Provision_List::clearBChargingSchedule() {
    if (hasBChargingSchedule()) {
         clear_has_bChargingSchedule();
        _bChargingSchedule = false;
     }
}

inline bool T_TCU_Provision_List::hasBChargingSchedule () const {
    return (_has_bits_[0] & (1u << 14)) > 0;
}

inline bool T_TCU_Provision_List::getBChargingSchedule () const {
    return _bChargingSchedule;
}

inline void T_TCU_Provision_List::setBChargingSchedule (bool bChargingSchedule_) {
    set_has_bChargingSchedule();
    this->_bChargingSchedule = bChargingSchedule_;
}

inline void T_TCU_Provision_List::clearU16ReserveRenault() {
    if (hasU16ReserveRenault()) {
         clear_has_u16ReserveRenault();
        _u16ReserveRenault = 0u;
     }
}

inline bool T_TCU_Provision_List::hasU16ReserveRenault () const {
    return (_has_bits_[0] & (1u << 15)) > 0;
}

inline uint16 T_TCU_Provision_List::getU16ReserveRenault () const {
    return _u16ReserveRenault;
}

inline void T_TCU_Provision_List::setU16ReserveRenault (uint16 u16ReserveRenault_) {
    set_has_u16ReserveRenault();
    this->_u16ReserveRenault = u16ReserveRenault_;
}

inline void T_TCU_Provision_List::set_has_bOperatorService () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TCU_Provision_List::clear_has_bOperatorService () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TCU_Provision_List::set_has_bConnectedSearch () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TCU_Provision_List::clear_has_bConnectedSearch () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_TCU_Provision_List::set_has_bMobileInformation () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_TCU_Provision_List::clear_has_bMobileInformation () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_TCU_Provision_List::set_has_u16ReserveNissan () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_TCU_Provision_List::clear_has_u16ReserveNissan () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_TCU_Provision_List::set_has_bInternetWidget () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_TCU_Provision_List::clear_has_bInternetWidget () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_TCU_Provision_List::set_has_bFuelPrice () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_TCU_Provision_List::clear_has_bFuelPrice () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_TCU_Provision_List::set_has_bLocalSearch () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_TCU_Provision_List::clear_has_bLocalSearch () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_TCU_Provision_List::set_has_bWebPreTrip () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_TCU_Provision_List::clear_has_bWebPreTrip () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_TCU_Provision_List::set_has_bHDTraffic () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_TCU_Provision_List::clear_has_bHDTraffic () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_TCU_Provision_List::set_has_bSpeedTrap () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_TCU_Provision_List::clear_has_bSpeedTrap () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_TCU_Provision_List::set_has_bPreventNav () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_TCU_Provision_List::clear_has_bPreventNav () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void T_TCU_Provision_List::set_has_bWeather () {
    _has_bits_[0] |= 1u << 11;
}

inline void T_TCU_Provision_List::clear_has_bWeather () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void T_TCU_Provision_List::set_has_bLiveServices () {
    _has_bits_[0] |= 1u << 12;
}

inline void T_TCU_Provision_List::clear_has_bLiveServices () {
    _has_bits_[0] &= ~ (1u << 12);
}

inline void T_TCU_Provision_List::set_has_bChargingSpotFinder () {
    _has_bits_[0] |= 1u << 13;
}

inline void T_TCU_Provision_List::clear_has_bChargingSpotFinder () {
    _has_bits_[0] &= ~ (1u << 13);
}

inline void T_TCU_Provision_List::set_has_bChargingSchedule () {
    _has_bits_[0] |= 1u << 14;
}

inline void T_TCU_Provision_List::clear_has_bChargingSchedule () {
    _has_bits_[0] &= ~ (1u << 14);
}

inline void T_TCU_Provision_List::set_has_u16ReserveRenault () {
    _has_bits_[0] |= 1u << 15;
}

inline void T_TCU_Provision_List::clear_has_u16ReserveRenault () {
    _has_bits_[0] &= ~ (1u << 15);
}

inline  T_TCU_ReminderInfo::T_TCU_ReminderInfo ()  :
    _e8Plugin_Mode (::tcu_main_fi_types::T_e8_TCU_Mode__OFF),
    _e8Stop_Mode (::tcu_main_fi_types::T_e8_TCU_Mode__OFF),
    _u16RemainTime (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TCU_ReminderInfo::T_TCU_ReminderInfo (const T_TCU_ReminderInfo &rhs)  :
    _e8Plugin_Mode (::tcu_main_fi_types::T_e8_TCU_Mode__OFF),
    _e8Stop_Mode (::tcu_main_fi_types::T_e8_TCU_Mode__OFF),
    _u16RemainTime (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TCU_ReminderInfo::T_TCU_ReminderInfo (T_e8_TCU_Mode e8Plugin_Mode_, T_e8_TCU_Mode e8Stop_Mode_, uint16 u16RemainTime_)  :
    _e8Plugin_Mode (e8Plugin_Mode_),
    _e8Stop_Mode (e8Stop_Mode_),
    _u16RemainTime (u16RemainTime_)
{
    #ifndef NDEBUG
    if (!(T_e8_TCU_Mode_IsValid(e8Plugin_Mode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Plugin_Mode_, "T_e8_TCU_Mode", "e8Plugin_Mode", "T_TCU_ReminderInfo");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_TCU_Mode_IsValid(e8Stop_Mode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Stop_Mode_, "T_e8_TCU_Mode", "e8Stop_Mode", "T_TCU_ReminderInfo");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TCU_ReminderInfo::~T_TCU_ReminderInfo() {
}

inline T_TCU_ReminderInfo& T_TCU_ReminderInfo::operator = (const T_TCU_ReminderInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE8Plugin_Mode()) {
            setE8Plugin_Mode(rhs.getE8Plugin_Mode());
        } else {
            clearE8Plugin_Mode();
        }
        if (rhs.hasE8Stop_Mode()) {
            setE8Stop_Mode(rhs.getE8Stop_Mode());
        } else {
            clearE8Stop_Mode();
        }
        if (rhs.hasU16RemainTime()) {
            setU16RemainTime(rhs.getU16RemainTime());
        } else {
            clearU16RemainTime();
        }
    }
    return *this;
}

inline bool T_TCU_ReminderInfo::operator == (const T_TCU_ReminderInfo& rhs) const {
    return (((!hasE8Plugin_Mode() && !rhs.hasE8Plugin_Mode()) || getE8Plugin_Mode() == rhs.getE8Plugin_Mode()) &&
        ((!hasE8Stop_Mode() && !rhs.hasE8Stop_Mode()) || getE8Stop_Mode() == rhs.getE8Stop_Mode()) &&
        ((!hasU16RemainTime() && !rhs.hasU16RemainTime()) || getU16RemainTime() == rhs.getU16RemainTime()));
}

inline bool T_TCU_ReminderInfo::operator != (const T_TCU_ReminderInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TCU_ReminderInfo::operator < (const T_TCU_ReminderInfo& rhs) const {
    if (hasE8Plugin_Mode() || rhs.hasE8Plugin_Mode()) {
        if ((uint32)getE8Plugin_Mode() < (uint32)rhs.getE8Plugin_Mode()) return true;
        if ((uint32)getE8Plugin_Mode() > (uint32)rhs.getE8Plugin_Mode()) return false;
    }
    if (hasE8Stop_Mode() || rhs.hasE8Stop_Mode()) {
        if ((uint32)getE8Stop_Mode() < (uint32)rhs.getE8Stop_Mode()) return true;
        if ((uint32)getE8Stop_Mode() > (uint32)rhs.getE8Stop_Mode()) return false;
    }
    if (hasU16RemainTime() || rhs.hasU16RemainTime()) {
        if (getU16RemainTime() < rhs.getU16RemainTime()) return true;
        if (getU16RemainTime() > rhs.getU16RemainTime()) return false;
    }
    return false;
}

inline bool T_TCU_ReminderInfo::operator > (const T_TCU_ReminderInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TCU_ReminderInfo::clear() {
    clearE8Plugin_Mode();
    clearE8Stop_Mode();
    clearU16RemainTime();
}

inline void T_TCU_ReminderInfo::clearE8Plugin_Mode() {
    if (hasE8Plugin_Mode()) {
         clear_has_e8Plugin_Mode();
        _e8Plugin_Mode = ::tcu_main_fi_types::T_e8_TCU_Mode__OFF;
     }
}

inline bool T_TCU_ReminderInfo::hasE8Plugin_Mode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_TCU_Mode T_TCU_ReminderInfo::getE8Plugin_Mode () const {
    return _e8Plugin_Mode;
}

inline void T_TCU_ReminderInfo::setE8Plugin_Mode (T_e8_TCU_Mode e8Plugin_Mode_) {
    #ifndef NDEBUG
    if (!(T_e8_TCU_Mode_IsValid(e8Plugin_Mode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Plugin_Mode_, "T_e8_TCU_Mode", "e8Plugin_Mode", "T_TCU_ReminderInfo");
    }
    #endif
    set_has_e8Plugin_Mode();
    this->_e8Plugin_Mode = e8Plugin_Mode_;
}

inline void T_TCU_ReminderInfo::clearE8Stop_Mode() {
    if (hasE8Stop_Mode()) {
         clear_has_e8Stop_Mode();
        _e8Stop_Mode = ::tcu_main_fi_types::T_e8_TCU_Mode__OFF;
     }
}

inline bool T_TCU_ReminderInfo::hasE8Stop_Mode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_TCU_Mode T_TCU_ReminderInfo::getE8Stop_Mode () const {
    return _e8Stop_Mode;
}

inline void T_TCU_ReminderInfo::setE8Stop_Mode (T_e8_TCU_Mode e8Stop_Mode_) {
    #ifndef NDEBUG
    if (!(T_e8_TCU_Mode_IsValid(e8Stop_Mode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Stop_Mode_, "T_e8_TCU_Mode", "e8Stop_Mode", "T_TCU_ReminderInfo");
    }
    #endif
    set_has_e8Stop_Mode();
    this->_e8Stop_Mode = e8Stop_Mode_;
}

inline void T_TCU_ReminderInfo::clearU16RemainTime() {
    if (hasU16RemainTime()) {
         clear_has_u16RemainTime();
        _u16RemainTime = 0u;
     }
}

inline bool T_TCU_ReminderInfo::hasU16RemainTime () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 T_TCU_ReminderInfo::getU16RemainTime () const {
    return _u16RemainTime;
}

inline void T_TCU_ReminderInfo::setU16RemainTime (uint16 u16RemainTime_) {
    set_has_u16RemainTime();
    this->_u16RemainTime = u16RemainTime_;
}

inline void T_TCU_ReminderInfo::set_has_e8Plugin_Mode () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TCU_ReminderInfo::clear_has_e8Plugin_Mode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TCU_ReminderInfo::set_has_e8Stop_Mode () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TCU_ReminderInfo::clear_has_e8Stop_Mode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_TCU_ReminderInfo::set_has_u16RemainTime () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_TCU_ReminderInfo::clear_has_u16RemainTime () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_TCU_GPS_Position::T_TCU_GPS_Position ()  :
    _u8Reserved (0u),
    _e8LocationType (::tcu_main_fi_types::T_e8_TCU_LocationType__Tokyo),
    _e8Latitudemode (::tcu_main_fi_types::T_e8_TCU_LatitudeMode__North),
    _e8LongitudeMode (::tcu_main_fi_types::T_e8_TCU_LongitudeMode__East),
    _u8LatitudeDEG (0u),
    _u8LatitudeMIN (0u),
    _u16LatitudeSEC (0u),
    _u8LongitudeDEG (0u),
    _u8LongitudeMIN (0u),
    _u16LongitudeSEC (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TCU_GPS_Position::T_TCU_GPS_Position (const T_TCU_GPS_Position &rhs)  :
    _u8Reserved (0u),
    _e8LocationType (::tcu_main_fi_types::T_e8_TCU_LocationType__Tokyo),
    _e8Latitudemode (::tcu_main_fi_types::T_e8_TCU_LatitudeMode__North),
    _e8LongitudeMode (::tcu_main_fi_types::T_e8_TCU_LongitudeMode__East),
    _u8LatitudeDEG (0u),
    _u8LatitudeMIN (0u),
    _u16LatitudeSEC (0u),
    _u8LongitudeDEG (0u),
    _u8LongitudeMIN (0u),
    _u16LongitudeSEC (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TCU_GPS_Position::T_TCU_GPS_Position (uint8 u8Reserved_, T_e8_TCU_LocationType e8LocationType_, T_e8_TCU_LatitudeMode e8Latitudemode_, T_e8_TCU_LongitudeMode e8LongitudeMode_, uint8 u8LatitudeDEG_, uint8 u8LatitudeMIN_, uint16 u16LatitudeSEC_, uint8 u8LongitudeDEG_, uint8 u8LongitudeMIN_, uint16 u16LongitudeSEC_)  :
    _u8Reserved (u8Reserved_),
    _e8LocationType (e8LocationType_),
    _e8Latitudemode (e8Latitudemode_),
    _e8LongitudeMode (e8LongitudeMode_),
    _u8LatitudeDEG (u8LatitudeDEG_),
    _u8LatitudeMIN (u8LatitudeMIN_),
    _u16LatitudeSEC (u16LatitudeSEC_),
    _u8LongitudeDEG (u8LongitudeDEG_),
    _u8LongitudeMIN (u8LongitudeMIN_),
    _u16LongitudeSEC (u16LongitudeSEC_)
{
    #ifndef NDEBUG
    if (!(T_e8_TCU_LocationType_IsValid(e8LocationType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8LocationType_, "T_e8_TCU_LocationType", "e8LocationType", "T_TCU_GPS_Position");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_TCU_LatitudeMode_IsValid(e8Latitudemode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Latitudemode_, "T_e8_TCU_LatitudeMode", "e8Latitudemode", "T_TCU_GPS_Position");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_TCU_LongitudeMode_IsValid(e8LongitudeMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8LongitudeMode_, "T_e8_TCU_LongitudeMode", "e8LongitudeMode", "T_TCU_GPS_Position");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TCU_GPS_Position::~T_TCU_GPS_Position() {
}

inline T_TCU_GPS_Position& T_TCU_GPS_Position::operator = (const T_TCU_GPS_Position& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8Reserved()) {
            setU8Reserved(rhs.getU8Reserved());
        } else {
            clearU8Reserved();
        }
        if (rhs.hasE8LocationType()) {
            setE8LocationType(rhs.getE8LocationType());
        } else {
            clearE8LocationType();
        }
        if (rhs.hasE8Latitudemode()) {
            setE8Latitudemode(rhs.getE8Latitudemode());
        } else {
            clearE8Latitudemode();
        }
        if (rhs.hasE8LongitudeMode()) {
            setE8LongitudeMode(rhs.getE8LongitudeMode());
        } else {
            clearE8LongitudeMode();
        }
        if (rhs.hasU8LatitudeDEG()) {
            setU8LatitudeDEG(rhs.getU8LatitudeDEG());
        } else {
            clearU8LatitudeDEG();
        }
        if (rhs.hasU8LatitudeMIN()) {
            setU8LatitudeMIN(rhs.getU8LatitudeMIN());
        } else {
            clearU8LatitudeMIN();
        }
        if (rhs.hasU16LatitudeSEC()) {
            setU16LatitudeSEC(rhs.getU16LatitudeSEC());
        } else {
            clearU16LatitudeSEC();
        }
        if (rhs.hasU8LongitudeDEG()) {
            setU8LongitudeDEG(rhs.getU8LongitudeDEG());
        } else {
            clearU8LongitudeDEG();
        }
        if (rhs.hasU8LongitudeMIN()) {
            setU8LongitudeMIN(rhs.getU8LongitudeMIN());
        } else {
            clearU8LongitudeMIN();
        }
        if (rhs.hasU16LongitudeSEC()) {
            setU16LongitudeSEC(rhs.getU16LongitudeSEC());
        } else {
            clearU16LongitudeSEC();
        }
    }
    return *this;
}

inline bool T_TCU_GPS_Position::operator == (const T_TCU_GPS_Position& rhs) const {
    return (((!hasU8Reserved() && !rhs.hasU8Reserved()) || getU8Reserved() == rhs.getU8Reserved()) &&
        ((!hasE8LocationType() && !rhs.hasE8LocationType()) || getE8LocationType() == rhs.getE8LocationType()) &&
        ((!hasE8Latitudemode() && !rhs.hasE8Latitudemode()) || getE8Latitudemode() == rhs.getE8Latitudemode()) &&
        ((!hasE8LongitudeMode() && !rhs.hasE8LongitudeMode()) || getE8LongitudeMode() == rhs.getE8LongitudeMode()) &&
        ((!hasU8LatitudeDEG() && !rhs.hasU8LatitudeDEG()) || getU8LatitudeDEG() == rhs.getU8LatitudeDEG()) &&
        ((!hasU8LatitudeMIN() && !rhs.hasU8LatitudeMIN()) || getU8LatitudeMIN() == rhs.getU8LatitudeMIN()) &&
        ((!hasU16LatitudeSEC() && !rhs.hasU16LatitudeSEC()) || getU16LatitudeSEC() == rhs.getU16LatitudeSEC()) &&
        ((!hasU8LongitudeDEG() && !rhs.hasU8LongitudeDEG()) || getU8LongitudeDEG() == rhs.getU8LongitudeDEG()) &&
        ((!hasU8LongitudeMIN() && !rhs.hasU8LongitudeMIN()) || getU8LongitudeMIN() == rhs.getU8LongitudeMIN()) &&
        ((!hasU16LongitudeSEC() && !rhs.hasU16LongitudeSEC()) || getU16LongitudeSEC() == rhs.getU16LongitudeSEC()));
}

inline bool T_TCU_GPS_Position::operator != (const T_TCU_GPS_Position& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TCU_GPS_Position::operator < (const T_TCU_GPS_Position& rhs) const {
    if (hasU8Reserved() || rhs.hasU8Reserved()) {
        if (getU8Reserved() < rhs.getU8Reserved()) return true;
        if (getU8Reserved() > rhs.getU8Reserved()) return false;
    }
    if (hasE8LocationType() || rhs.hasE8LocationType()) {
        if ((uint32)getE8LocationType() < (uint32)rhs.getE8LocationType()) return true;
        if ((uint32)getE8LocationType() > (uint32)rhs.getE8LocationType()) return false;
    }
    if (hasE8Latitudemode() || rhs.hasE8Latitudemode()) {
        if ((uint32)getE8Latitudemode() < (uint32)rhs.getE8Latitudemode()) return true;
        if ((uint32)getE8Latitudemode() > (uint32)rhs.getE8Latitudemode()) return false;
    }
    if (hasE8LongitudeMode() || rhs.hasE8LongitudeMode()) {
        if ((uint32)getE8LongitudeMode() < (uint32)rhs.getE8LongitudeMode()) return true;
        if ((uint32)getE8LongitudeMode() > (uint32)rhs.getE8LongitudeMode()) return false;
    }
    if (hasU8LatitudeDEG() || rhs.hasU8LatitudeDEG()) {
        if (getU8LatitudeDEG() < rhs.getU8LatitudeDEG()) return true;
        if (getU8LatitudeDEG() > rhs.getU8LatitudeDEG()) return false;
    }
    if (hasU8LatitudeMIN() || rhs.hasU8LatitudeMIN()) {
        if (getU8LatitudeMIN() < rhs.getU8LatitudeMIN()) return true;
        if (getU8LatitudeMIN() > rhs.getU8LatitudeMIN()) return false;
    }
    if (hasU16LatitudeSEC() || rhs.hasU16LatitudeSEC()) {
        if (getU16LatitudeSEC() < rhs.getU16LatitudeSEC()) return true;
        if (getU16LatitudeSEC() > rhs.getU16LatitudeSEC()) return false;
    }
    if (hasU8LongitudeDEG() || rhs.hasU8LongitudeDEG()) {
        if (getU8LongitudeDEG() < rhs.getU8LongitudeDEG()) return true;
        if (getU8LongitudeDEG() > rhs.getU8LongitudeDEG()) return false;
    }
    if (hasU8LongitudeMIN() || rhs.hasU8LongitudeMIN()) {
        if (getU8LongitudeMIN() < rhs.getU8LongitudeMIN()) return true;
        if (getU8LongitudeMIN() > rhs.getU8LongitudeMIN()) return false;
    }
    if (hasU16LongitudeSEC() || rhs.hasU16LongitudeSEC()) {
        if (getU16LongitudeSEC() < rhs.getU16LongitudeSEC()) return true;
        if (getU16LongitudeSEC() > rhs.getU16LongitudeSEC()) return false;
    }
    return false;
}

inline bool T_TCU_GPS_Position::operator > (const T_TCU_GPS_Position& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TCU_GPS_Position::clear() {
    clearU8Reserved();
    clearE8LocationType();
    clearE8Latitudemode();
    clearE8LongitudeMode();
    clearU8LatitudeDEG();
    clearU8LatitudeMIN();
    clearU16LatitudeSEC();
    clearU8LongitudeDEG();
    clearU8LongitudeMIN();
    clearU16LongitudeSEC();
}

inline void T_TCU_GPS_Position::clearU8Reserved() {
    if (hasU8Reserved()) {
         clear_has_u8Reserved();
        _u8Reserved = 0u;
     }
}

inline bool T_TCU_GPS_Position::hasU8Reserved () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_TCU_GPS_Position::getU8Reserved () const {
    return _u8Reserved;
}

inline void T_TCU_GPS_Position::setU8Reserved (uint8 u8Reserved_) {
    set_has_u8Reserved();
    this->_u8Reserved = u8Reserved_;
}

inline void T_TCU_GPS_Position::clearE8LocationType() {
    if (hasE8LocationType()) {
         clear_has_e8LocationType();
        _e8LocationType = ::tcu_main_fi_types::T_e8_TCU_LocationType__Tokyo;
     }
}

inline bool T_TCU_GPS_Position::hasE8LocationType () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_TCU_LocationType T_TCU_GPS_Position::getE8LocationType () const {
    return _e8LocationType;
}

inline void T_TCU_GPS_Position::setE8LocationType (T_e8_TCU_LocationType e8LocationType_) {
    #ifndef NDEBUG
    if (!(T_e8_TCU_LocationType_IsValid(e8LocationType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8LocationType_, "T_e8_TCU_LocationType", "e8LocationType", "T_TCU_GPS_Position");
    }
    #endif
    set_has_e8LocationType();
    this->_e8LocationType = e8LocationType_;
}

inline void T_TCU_GPS_Position::clearE8Latitudemode() {
    if (hasE8Latitudemode()) {
         clear_has_e8Latitudemode();
        _e8Latitudemode = ::tcu_main_fi_types::T_e8_TCU_LatitudeMode__North;
     }
}

inline bool T_TCU_GPS_Position::hasE8Latitudemode () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_TCU_LatitudeMode T_TCU_GPS_Position::getE8Latitudemode () const {
    return _e8Latitudemode;
}

inline void T_TCU_GPS_Position::setE8Latitudemode (T_e8_TCU_LatitudeMode e8Latitudemode_) {
    #ifndef NDEBUG
    if (!(T_e8_TCU_LatitudeMode_IsValid(e8Latitudemode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Latitudemode_, "T_e8_TCU_LatitudeMode", "e8Latitudemode", "T_TCU_GPS_Position");
    }
    #endif
    set_has_e8Latitudemode();
    this->_e8Latitudemode = e8Latitudemode_;
}

inline void T_TCU_GPS_Position::clearE8LongitudeMode() {
    if (hasE8LongitudeMode()) {
         clear_has_e8LongitudeMode();
        _e8LongitudeMode = ::tcu_main_fi_types::T_e8_TCU_LongitudeMode__East;
     }
}

inline bool T_TCU_GPS_Position::hasE8LongitudeMode () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline T_e8_TCU_LongitudeMode T_TCU_GPS_Position::getE8LongitudeMode () const {
    return _e8LongitudeMode;
}

inline void T_TCU_GPS_Position::setE8LongitudeMode (T_e8_TCU_LongitudeMode e8LongitudeMode_) {
    #ifndef NDEBUG
    if (!(T_e8_TCU_LongitudeMode_IsValid(e8LongitudeMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8LongitudeMode_, "T_e8_TCU_LongitudeMode", "e8LongitudeMode", "T_TCU_GPS_Position");
    }
    #endif
    set_has_e8LongitudeMode();
    this->_e8LongitudeMode = e8LongitudeMode_;
}

inline void T_TCU_GPS_Position::clearU8LatitudeDEG() {
    if (hasU8LatitudeDEG()) {
         clear_has_u8LatitudeDEG();
        _u8LatitudeDEG = 0u;
     }
}

inline bool T_TCU_GPS_Position::hasU8LatitudeDEG () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 T_TCU_GPS_Position::getU8LatitudeDEG () const {
    return _u8LatitudeDEG;
}

inline void T_TCU_GPS_Position::setU8LatitudeDEG (uint8 u8LatitudeDEG_) {
    set_has_u8LatitudeDEG();
    this->_u8LatitudeDEG = u8LatitudeDEG_;
}

inline void T_TCU_GPS_Position::clearU8LatitudeMIN() {
    if (hasU8LatitudeMIN()) {
         clear_has_u8LatitudeMIN();
        _u8LatitudeMIN = 0u;
     }
}

inline bool T_TCU_GPS_Position::hasU8LatitudeMIN () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint8 T_TCU_GPS_Position::getU8LatitudeMIN () const {
    return _u8LatitudeMIN;
}

inline void T_TCU_GPS_Position::setU8LatitudeMIN (uint8 u8LatitudeMIN_) {
    set_has_u8LatitudeMIN();
    this->_u8LatitudeMIN = u8LatitudeMIN_;
}

inline void T_TCU_GPS_Position::clearU16LatitudeSEC() {
    if (hasU16LatitudeSEC()) {
         clear_has_u16LatitudeSEC();
        _u16LatitudeSEC = 0u;
     }
}

inline bool T_TCU_GPS_Position::hasU16LatitudeSEC () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint16 T_TCU_GPS_Position::getU16LatitudeSEC () const {
    return _u16LatitudeSEC;
}

inline void T_TCU_GPS_Position::setU16LatitudeSEC (uint16 u16LatitudeSEC_) {
    set_has_u16LatitudeSEC();
    this->_u16LatitudeSEC = u16LatitudeSEC_;
}

inline void T_TCU_GPS_Position::clearU8LongitudeDEG() {
    if (hasU8LongitudeDEG()) {
         clear_has_u8LongitudeDEG();
        _u8LongitudeDEG = 0u;
     }
}

inline bool T_TCU_GPS_Position::hasU8LongitudeDEG () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline uint8 T_TCU_GPS_Position::getU8LongitudeDEG () const {
    return _u8LongitudeDEG;
}

inline void T_TCU_GPS_Position::setU8LongitudeDEG (uint8 u8LongitudeDEG_) {
    set_has_u8LongitudeDEG();
    this->_u8LongitudeDEG = u8LongitudeDEG_;
}

inline void T_TCU_GPS_Position::clearU8LongitudeMIN() {
    if (hasU8LongitudeMIN()) {
         clear_has_u8LongitudeMIN();
        _u8LongitudeMIN = 0u;
     }
}

inline bool T_TCU_GPS_Position::hasU8LongitudeMIN () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline uint8 T_TCU_GPS_Position::getU8LongitudeMIN () const {
    return _u8LongitudeMIN;
}

inline void T_TCU_GPS_Position::setU8LongitudeMIN (uint8 u8LongitudeMIN_) {
    set_has_u8LongitudeMIN();
    this->_u8LongitudeMIN = u8LongitudeMIN_;
}

inline void T_TCU_GPS_Position::clearU16LongitudeSEC() {
    if (hasU16LongitudeSEC()) {
         clear_has_u16LongitudeSEC();
        _u16LongitudeSEC = 0u;
     }
}

inline bool T_TCU_GPS_Position::hasU16LongitudeSEC () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline uint16 T_TCU_GPS_Position::getU16LongitudeSEC () const {
    return _u16LongitudeSEC;
}

inline void T_TCU_GPS_Position::setU16LongitudeSEC (uint16 u16LongitudeSEC_) {
    set_has_u16LongitudeSEC();
    this->_u16LongitudeSEC = u16LongitudeSEC_;
}

inline void T_TCU_GPS_Position::set_has_u8Reserved () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TCU_GPS_Position::clear_has_u8Reserved () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TCU_GPS_Position::set_has_e8LocationType () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TCU_GPS_Position::clear_has_e8LocationType () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_TCU_GPS_Position::set_has_e8Latitudemode () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_TCU_GPS_Position::clear_has_e8Latitudemode () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_TCU_GPS_Position::set_has_e8LongitudeMode () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_TCU_GPS_Position::clear_has_e8LongitudeMode () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_TCU_GPS_Position::set_has_u8LatitudeDEG () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_TCU_GPS_Position::clear_has_u8LatitudeDEG () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_TCU_GPS_Position::set_has_u8LatitudeMIN () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_TCU_GPS_Position::clear_has_u8LatitudeMIN () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_TCU_GPS_Position::set_has_u16LatitudeSEC () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_TCU_GPS_Position::clear_has_u16LatitudeSEC () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_TCU_GPS_Position::set_has_u8LongitudeDEG () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_TCU_GPS_Position::clear_has_u8LongitudeDEG () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_TCU_GPS_Position::set_has_u8LongitudeMIN () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_TCU_GPS_Position::clear_has_u8LongitudeMIN () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_TCU_GPS_Position::set_has_u16LongitudeSEC () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_TCU_GPS_Position::clear_has_u16LongitudeSEC () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline  T_TCU_Time_Stamp::T_TCU_Time_Stamp ()  :
    _u8Year (0u),
    _u8Month (0u),
    _u8Day (0u),
    _u8Hour (0u),
    _u8Minute (0u),
    _u8Second (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TCU_Time_Stamp::T_TCU_Time_Stamp (const T_TCU_Time_Stamp &rhs)  :
    _u8Year (0u),
    _u8Month (0u),
    _u8Day (0u),
    _u8Hour (0u),
    _u8Minute (0u),
    _u8Second (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TCU_Time_Stamp::T_TCU_Time_Stamp (uint8 u8Year_, uint8 u8Month_, uint8 u8Day_, uint8 u8Hour_, uint8 u8Minute_, uint8 u8Second_)  :
    _u8Year (u8Year_),
    _u8Month (u8Month_),
    _u8Day (u8Day_),
    _u8Hour (u8Hour_),
    _u8Minute (u8Minute_),
    _u8Second (u8Second_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TCU_Time_Stamp::~T_TCU_Time_Stamp() {
}

inline T_TCU_Time_Stamp& T_TCU_Time_Stamp::operator = (const T_TCU_Time_Stamp& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8Year()) {
            setU8Year(rhs.getU8Year());
        } else {
            clearU8Year();
        }
        if (rhs.hasU8Month()) {
            setU8Month(rhs.getU8Month());
        } else {
            clearU8Month();
        }
        if (rhs.hasU8Day()) {
            setU8Day(rhs.getU8Day());
        } else {
            clearU8Day();
        }
        if (rhs.hasU8Hour()) {
            setU8Hour(rhs.getU8Hour());
        } else {
            clearU8Hour();
        }
        if (rhs.hasU8Minute()) {
            setU8Minute(rhs.getU8Minute());
        } else {
            clearU8Minute();
        }
        if (rhs.hasU8Second()) {
            setU8Second(rhs.getU8Second());
        } else {
            clearU8Second();
        }
    }
    return *this;
}

inline bool T_TCU_Time_Stamp::operator == (const T_TCU_Time_Stamp& rhs) const {
    return (((!hasU8Year() && !rhs.hasU8Year()) || getU8Year() == rhs.getU8Year()) &&
        ((!hasU8Month() && !rhs.hasU8Month()) || getU8Month() == rhs.getU8Month()) &&
        ((!hasU8Day() && !rhs.hasU8Day()) || getU8Day() == rhs.getU8Day()) &&
        ((!hasU8Hour() && !rhs.hasU8Hour()) || getU8Hour() == rhs.getU8Hour()) &&
        ((!hasU8Minute() && !rhs.hasU8Minute()) || getU8Minute() == rhs.getU8Minute()) &&
        ((!hasU8Second() && !rhs.hasU8Second()) || getU8Second() == rhs.getU8Second()));
}

inline bool T_TCU_Time_Stamp::operator != (const T_TCU_Time_Stamp& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TCU_Time_Stamp::operator < (const T_TCU_Time_Stamp& rhs) const {
    if (hasU8Year() || rhs.hasU8Year()) {
        if (getU8Year() < rhs.getU8Year()) return true;
        if (getU8Year() > rhs.getU8Year()) return false;
    }
    if (hasU8Month() || rhs.hasU8Month()) {
        if (getU8Month() < rhs.getU8Month()) return true;
        if (getU8Month() > rhs.getU8Month()) return false;
    }
    if (hasU8Day() || rhs.hasU8Day()) {
        if (getU8Day() < rhs.getU8Day()) return true;
        if (getU8Day() > rhs.getU8Day()) return false;
    }
    if (hasU8Hour() || rhs.hasU8Hour()) {
        if (getU8Hour() < rhs.getU8Hour()) return true;
        if (getU8Hour() > rhs.getU8Hour()) return false;
    }
    if (hasU8Minute() || rhs.hasU8Minute()) {
        if (getU8Minute() < rhs.getU8Minute()) return true;
        if (getU8Minute() > rhs.getU8Minute()) return false;
    }
    if (hasU8Second() || rhs.hasU8Second()) {
        if (getU8Second() < rhs.getU8Second()) return true;
        if (getU8Second() > rhs.getU8Second()) return false;
    }
    return false;
}

inline bool T_TCU_Time_Stamp::operator > (const T_TCU_Time_Stamp& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TCU_Time_Stamp::clear() {
    clearU8Year();
    clearU8Month();
    clearU8Day();
    clearU8Hour();
    clearU8Minute();
    clearU8Second();
}

inline void T_TCU_Time_Stamp::clearU8Year() {
    if (hasU8Year()) {
         clear_has_u8Year();
        _u8Year = 0u;
     }
}

inline bool T_TCU_Time_Stamp::hasU8Year () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_TCU_Time_Stamp::getU8Year () const {
    return _u8Year;
}

inline void T_TCU_Time_Stamp::setU8Year (uint8 u8Year_) {
    set_has_u8Year();
    this->_u8Year = u8Year_;
}

inline void T_TCU_Time_Stamp::clearU8Month() {
    if (hasU8Month()) {
         clear_has_u8Month();
        _u8Month = 0u;
     }
}

inline bool T_TCU_Time_Stamp::hasU8Month () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_TCU_Time_Stamp::getU8Month () const {
    return _u8Month;
}

inline void T_TCU_Time_Stamp::setU8Month (uint8 u8Month_) {
    set_has_u8Month();
    this->_u8Month = u8Month_;
}

inline void T_TCU_Time_Stamp::clearU8Day() {
    if (hasU8Day()) {
         clear_has_u8Day();
        _u8Day = 0u;
     }
}

inline bool T_TCU_Time_Stamp::hasU8Day () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 T_TCU_Time_Stamp::getU8Day () const {
    return _u8Day;
}

inline void T_TCU_Time_Stamp::setU8Day (uint8 u8Day_) {
    set_has_u8Day();
    this->_u8Day = u8Day_;
}

inline void T_TCU_Time_Stamp::clearU8Hour() {
    if (hasU8Hour()) {
         clear_has_u8Hour();
        _u8Hour = 0u;
     }
}

inline bool T_TCU_Time_Stamp::hasU8Hour () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 T_TCU_Time_Stamp::getU8Hour () const {
    return _u8Hour;
}

inline void T_TCU_Time_Stamp::setU8Hour (uint8 u8Hour_) {
    set_has_u8Hour();
    this->_u8Hour = u8Hour_;
}

inline void T_TCU_Time_Stamp::clearU8Minute() {
    if (hasU8Minute()) {
         clear_has_u8Minute();
        _u8Minute = 0u;
     }
}

inline bool T_TCU_Time_Stamp::hasU8Minute () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 T_TCU_Time_Stamp::getU8Minute () const {
    return _u8Minute;
}

inline void T_TCU_Time_Stamp::setU8Minute (uint8 u8Minute_) {
    set_has_u8Minute();
    this->_u8Minute = u8Minute_;
}

inline void T_TCU_Time_Stamp::clearU8Second() {
    if (hasU8Second()) {
         clear_has_u8Second();
        _u8Second = 0u;
     }
}

inline bool T_TCU_Time_Stamp::hasU8Second () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint8 T_TCU_Time_Stamp::getU8Second () const {
    return _u8Second;
}

inline void T_TCU_Time_Stamp::setU8Second (uint8 u8Second_) {
    set_has_u8Second();
    this->_u8Second = u8Second_;
}

inline void T_TCU_Time_Stamp::set_has_u8Year () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TCU_Time_Stamp::clear_has_u8Year () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TCU_Time_Stamp::set_has_u8Month () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TCU_Time_Stamp::clear_has_u8Month () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_TCU_Time_Stamp::set_has_u8Day () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_TCU_Time_Stamp::clear_has_u8Day () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_TCU_Time_Stamp::set_has_u8Hour () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_TCU_Time_Stamp::clear_has_u8Hour () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_TCU_Time_Stamp::set_has_u8Minute () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_TCU_Time_Stamp::clear_has_u8Minute () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_TCU_Time_Stamp::set_has_u8Second () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_TCU_Time_Stamp::clear_has_u8Second () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline  T_TCU_Opening_Hour_Day::T_TCU_Opening_Hour_Day ()  :
    _u8StartTime_1 (0u),
    _u8StartTime_2 (0u),
    _u8EndTime_1 (0u),
    _u8EndTime_2 (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TCU_Opening_Hour_Day::T_TCU_Opening_Hour_Day (const T_TCU_Opening_Hour_Day &rhs)  :
    _u8StartTime_1 (0u),
    _u8StartTime_2 (0u),
    _u8EndTime_1 (0u),
    _u8EndTime_2 (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TCU_Opening_Hour_Day::T_TCU_Opening_Hour_Day (uint8 u8StartTime_1_, uint8 u8StartTime_2_, uint8 u8EndTime_1_, uint8 u8EndTime_2_)  :
    _u8StartTime_1 (u8StartTime_1_),
    _u8StartTime_2 (u8StartTime_2_),
    _u8EndTime_1 (u8EndTime_1_),
    _u8EndTime_2 (u8EndTime_2_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TCU_Opening_Hour_Day::~T_TCU_Opening_Hour_Day() {
}

inline T_TCU_Opening_Hour_Day& T_TCU_Opening_Hour_Day::operator = (const T_TCU_Opening_Hour_Day& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8StartTime_1()) {
            setU8StartTime_1(rhs.getU8StartTime_1());
        } else {
            clearU8StartTime_1();
        }
        if (rhs.hasU8StartTime_2()) {
            setU8StartTime_2(rhs.getU8StartTime_2());
        } else {
            clearU8StartTime_2();
        }
        if (rhs.hasU8EndTime_1()) {
            setU8EndTime_1(rhs.getU8EndTime_1());
        } else {
            clearU8EndTime_1();
        }
        if (rhs.hasU8EndTime_2()) {
            setU8EndTime_2(rhs.getU8EndTime_2());
        } else {
            clearU8EndTime_2();
        }
    }
    return *this;
}

inline bool T_TCU_Opening_Hour_Day::operator == (const T_TCU_Opening_Hour_Day& rhs) const {
    return (((!hasU8StartTime_1() && !rhs.hasU8StartTime_1()) || getU8StartTime_1() == rhs.getU8StartTime_1()) &&
        ((!hasU8StartTime_2() && !rhs.hasU8StartTime_2()) || getU8StartTime_2() == rhs.getU8StartTime_2()) &&
        ((!hasU8EndTime_1() && !rhs.hasU8EndTime_1()) || getU8EndTime_1() == rhs.getU8EndTime_1()) &&
        ((!hasU8EndTime_2() && !rhs.hasU8EndTime_2()) || getU8EndTime_2() == rhs.getU8EndTime_2()));
}

inline bool T_TCU_Opening_Hour_Day::operator != (const T_TCU_Opening_Hour_Day& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TCU_Opening_Hour_Day::operator < (const T_TCU_Opening_Hour_Day& rhs) const {
    if (hasU8StartTime_1() || rhs.hasU8StartTime_1()) {
        if (getU8StartTime_1() < rhs.getU8StartTime_1()) return true;
        if (getU8StartTime_1() > rhs.getU8StartTime_1()) return false;
    }
    if (hasU8StartTime_2() || rhs.hasU8StartTime_2()) {
        if (getU8StartTime_2() < rhs.getU8StartTime_2()) return true;
        if (getU8StartTime_2() > rhs.getU8StartTime_2()) return false;
    }
    if (hasU8EndTime_1() || rhs.hasU8EndTime_1()) {
        if (getU8EndTime_1() < rhs.getU8EndTime_1()) return true;
        if (getU8EndTime_1() > rhs.getU8EndTime_1()) return false;
    }
    if (hasU8EndTime_2() || rhs.hasU8EndTime_2()) {
        if (getU8EndTime_2() < rhs.getU8EndTime_2()) return true;
        if (getU8EndTime_2() > rhs.getU8EndTime_2()) return false;
    }
    return false;
}

inline bool T_TCU_Opening_Hour_Day::operator > (const T_TCU_Opening_Hour_Day& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TCU_Opening_Hour_Day::clear() {
    clearU8StartTime_1();
    clearU8StartTime_2();
    clearU8EndTime_1();
    clearU8EndTime_2();
}

inline void T_TCU_Opening_Hour_Day::clearU8StartTime_1() {
    if (hasU8StartTime_1()) {
         clear_has_u8StartTime_1();
        _u8StartTime_1 = 0u;
     }
}

inline bool T_TCU_Opening_Hour_Day::hasU8StartTime_1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_TCU_Opening_Hour_Day::getU8StartTime_1 () const {
    return _u8StartTime_1;
}

inline void T_TCU_Opening_Hour_Day::setU8StartTime_1 (uint8 u8StartTime_1_) {
    set_has_u8StartTime_1();
    this->_u8StartTime_1 = u8StartTime_1_;
}

inline void T_TCU_Opening_Hour_Day::clearU8StartTime_2() {
    if (hasU8StartTime_2()) {
         clear_has_u8StartTime_2();
        _u8StartTime_2 = 0u;
     }
}

inline bool T_TCU_Opening_Hour_Day::hasU8StartTime_2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_TCU_Opening_Hour_Day::getU8StartTime_2 () const {
    return _u8StartTime_2;
}

inline void T_TCU_Opening_Hour_Day::setU8StartTime_2 (uint8 u8StartTime_2_) {
    set_has_u8StartTime_2();
    this->_u8StartTime_2 = u8StartTime_2_;
}

inline void T_TCU_Opening_Hour_Day::clearU8EndTime_1() {
    if (hasU8EndTime_1()) {
         clear_has_u8EndTime_1();
        _u8EndTime_1 = 0u;
     }
}

inline bool T_TCU_Opening_Hour_Day::hasU8EndTime_1 () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 T_TCU_Opening_Hour_Day::getU8EndTime_1 () const {
    return _u8EndTime_1;
}

inline void T_TCU_Opening_Hour_Day::setU8EndTime_1 (uint8 u8EndTime_1_) {
    set_has_u8EndTime_1();
    this->_u8EndTime_1 = u8EndTime_1_;
}

inline void T_TCU_Opening_Hour_Day::clearU8EndTime_2() {
    if (hasU8EndTime_2()) {
         clear_has_u8EndTime_2();
        _u8EndTime_2 = 0u;
     }
}

inline bool T_TCU_Opening_Hour_Day::hasU8EndTime_2 () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 T_TCU_Opening_Hour_Day::getU8EndTime_2 () const {
    return _u8EndTime_2;
}

inline void T_TCU_Opening_Hour_Day::setU8EndTime_2 (uint8 u8EndTime_2_) {
    set_has_u8EndTime_2();
    this->_u8EndTime_2 = u8EndTime_2_;
}

inline void T_TCU_Opening_Hour_Day::set_has_u8StartTime_1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TCU_Opening_Hour_Day::clear_has_u8StartTime_1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TCU_Opening_Hour_Day::set_has_u8StartTime_2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TCU_Opening_Hour_Day::clear_has_u8StartTime_2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_TCU_Opening_Hour_Day::set_has_u8EndTime_1 () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_TCU_Opening_Hour_Day::clear_has_u8EndTime_1 () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_TCU_Opening_Hour_Day::set_has_u8EndTime_2 () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_TCU_Opening_Hour_Day::clear_has_u8EndTime_2 () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  T_TCU_Opening_Hour::T_TCU_Opening_Hour ()  :
    _rSunday (),
    _rMonday (),
    _rTuesday (),
    _rWednesday (),
    _rThursday (),
    _rFriday (),
    _rSaturday ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TCU_Opening_Hour::T_TCU_Opening_Hour (const T_TCU_Opening_Hour &rhs)  :
    _rSunday (),
    _rMonday (),
    _rTuesday (),
    _rWednesday (),
    _rThursday (),
    _rFriday (),
    _rSaturday ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TCU_Opening_Hour::T_TCU_Opening_Hour (const T_TCU_Opening_Hour_Day& rSunday_, const T_TCU_Opening_Hour_Day& rMonday_, const T_TCU_Opening_Hour_Day& rTuesday_, const T_TCU_Opening_Hour_Day& rWednesday_, const T_TCU_Opening_Hour_Day& rThursday_, const T_TCU_Opening_Hour_Day& rFriday_, const T_TCU_Opening_Hour_Day& rSaturday_)  :
    _rSunday (rSunday_),
    _rMonday (rMonday_),
    _rTuesday (rTuesday_),
    _rWednesday (rWednesday_),
    _rThursday (rThursday_),
    _rFriday (rFriday_),
    _rSaturday (rSaturday_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TCU_Opening_Hour::~T_TCU_Opening_Hour() {
}

inline T_TCU_Opening_Hour& T_TCU_Opening_Hour::operator = (const T_TCU_Opening_Hour& rhs) {
    if( this != &rhs ) {
        if (rhs.hasRSunday()) {
            setRSunday(rhs.getRSunday());
        } else {
            clearRSunday();
        }
        if (rhs.hasRMonday()) {
            setRMonday(rhs.getRMonday());
        } else {
            clearRMonday();
        }
        if (rhs.hasRTuesday()) {
            setRTuesday(rhs.getRTuesday());
        } else {
            clearRTuesday();
        }
        if (rhs.hasRWednesday()) {
            setRWednesday(rhs.getRWednesday());
        } else {
            clearRWednesday();
        }
        if (rhs.hasRThursday()) {
            setRThursday(rhs.getRThursday());
        } else {
            clearRThursday();
        }
        if (rhs.hasRFriday()) {
            setRFriday(rhs.getRFriday());
        } else {
            clearRFriday();
        }
        if (rhs.hasRSaturday()) {
            setRSaturday(rhs.getRSaturday());
        } else {
            clearRSaturday();
        }
    }
    return *this;
}

inline bool T_TCU_Opening_Hour::operator == (const T_TCU_Opening_Hour& rhs) const {
    return (((!hasRSunday() && !rhs.hasRSunday()) || getRSunday() == rhs.getRSunday()) &&
        ((!hasRMonday() && !rhs.hasRMonday()) || getRMonday() == rhs.getRMonday()) &&
        ((!hasRTuesday() && !rhs.hasRTuesday()) || getRTuesday() == rhs.getRTuesday()) &&
        ((!hasRWednesday() && !rhs.hasRWednesday()) || getRWednesday() == rhs.getRWednesday()) &&
        ((!hasRThursday() && !rhs.hasRThursday()) || getRThursday() == rhs.getRThursday()) &&
        ((!hasRFriday() && !rhs.hasRFriday()) || getRFriday() == rhs.getRFriday()) &&
        ((!hasRSaturday() && !rhs.hasRSaturday()) || getRSaturday() == rhs.getRSaturday()));
}

inline bool T_TCU_Opening_Hour::operator != (const T_TCU_Opening_Hour& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TCU_Opening_Hour::operator < (const T_TCU_Opening_Hour& rhs) const {
    if (hasRSunday() || rhs.hasRSunday()) {
        if (getRSunday() < rhs.getRSunday()) return true;
        if (getRSunday() > rhs.getRSunday()) return false;
    }
    if (hasRMonday() || rhs.hasRMonday()) {
        if (getRMonday() < rhs.getRMonday()) return true;
        if (getRMonday() > rhs.getRMonday()) return false;
    }
    if (hasRTuesday() || rhs.hasRTuesday()) {
        if (getRTuesday() < rhs.getRTuesday()) return true;
        if (getRTuesday() > rhs.getRTuesday()) return false;
    }
    if (hasRWednesday() || rhs.hasRWednesday()) {
        if (getRWednesday() < rhs.getRWednesday()) return true;
        if (getRWednesday() > rhs.getRWednesday()) return false;
    }
    if (hasRThursday() || rhs.hasRThursday()) {
        if (getRThursday() < rhs.getRThursday()) return true;
        if (getRThursday() > rhs.getRThursday()) return false;
    }
    if (hasRFriday() || rhs.hasRFriday()) {
        if (getRFriday() < rhs.getRFriday()) return true;
        if (getRFriday() > rhs.getRFriday()) return false;
    }
    if (hasRSaturday() || rhs.hasRSaturday()) {
        if (getRSaturday() < rhs.getRSaturday()) return true;
        if (getRSaturday() > rhs.getRSaturday()) return false;
    }
    return false;
}

inline bool T_TCU_Opening_Hour::operator > (const T_TCU_Opening_Hour& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TCU_Opening_Hour::clear() {
    clearRSunday();
    clearRMonday();
    clearRTuesday();
    clearRWednesday();
    clearRThursday();
    clearRFriday();
    clearRSaturday();
}

inline void T_TCU_Opening_Hour::clearRSunday() {
    if (hasRSunday()) {
         clear_has_rSunday();
        _rSunday.clear();
     }
}

inline bool T_TCU_Opening_Hour::hasRSunday () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const T_TCU_Opening_Hour_Day& T_TCU_Opening_Hour::getRSunday () const {
    return _rSunday;
}

inline T_TCU_Opening_Hour_Day& T_TCU_Opening_Hour::getRSundayMutable () {
    set_has_rSunday();
    return _rSunday;
}

inline void T_TCU_Opening_Hour::setRSunday (const T_TCU_Opening_Hour_Day& rSunday_) {
    set_has_rSunday();
    this->_rSunday = rSunday_;
}

inline void T_TCU_Opening_Hour::clearRMonday() {
    if (hasRMonday()) {
         clear_has_rMonday();
        _rMonday.clear();
     }
}

inline bool T_TCU_Opening_Hour::hasRMonday () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const T_TCU_Opening_Hour_Day& T_TCU_Opening_Hour::getRMonday () const {
    return _rMonday;
}

inline T_TCU_Opening_Hour_Day& T_TCU_Opening_Hour::getRMondayMutable () {
    set_has_rMonday();
    return _rMonday;
}

inline void T_TCU_Opening_Hour::setRMonday (const T_TCU_Opening_Hour_Day& rMonday_) {
    set_has_rMonday();
    this->_rMonday = rMonday_;
}

inline void T_TCU_Opening_Hour::clearRTuesday() {
    if (hasRTuesday()) {
         clear_has_rTuesday();
        _rTuesday.clear();
     }
}

inline bool T_TCU_Opening_Hour::hasRTuesday () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const T_TCU_Opening_Hour_Day& T_TCU_Opening_Hour::getRTuesday () const {
    return _rTuesday;
}

inline T_TCU_Opening_Hour_Day& T_TCU_Opening_Hour::getRTuesdayMutable () {
    set_has_rTuesday();
    return _rTuesday;
}

inline void T_TCU_Opening_Hour::setRTuesday (const T_TCU_Opening_Hour_Day& rTuesday_) {
    set_has_rTuesday();
    this->_rTuesday = rTuesday_;
}

inline void T_TCU_Opening_Hour::clearRWednesday() {
    if (hasRWednesday()) {
         clear_has_rWednesday();
        _rWednesday.clear();
     }
}

inline bool T_TCU_Opening_Hour::hasRWednesday () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const T_TCU_Opening_Hour_Day& T_TCU_Opening_Hour::getRWednesday () const {
    return _rWednesday;
}

inline T_TCU_Opening_Hour_Day& T_TCU_Opening_Hour::getRWednesdayMutable () {
    set_has_rWednesday();
    return _rWednesday;
}

inline void T_TCU_Opening_Hour::setRWednesday (const T_TCU_Opening_Hour_Day& rWednesday_) {
    set_has_rWednesday();
    this->_rWednesday = rWednesday_;
}

inline void T_TCU_Opening_Hour::clearRThursday() {
    if (hasRThursday()) {
         clear_has_rThursday();
        _rThursday.clear();
     }
}

inline bool T_TCU_Opening_Hour::hasRThursday () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const T_TCU_Opening_Hour_Day& T_TCU_Opening_Hour::getRThursday () const {
    return _rThursday;
}

inline T_TCU_Opening_Hour_Day& T_TCU_Opening_Hour::getRThursdayMutable () {
    set_has_rThursday();
    return _rThursday;
}

inline void T_TCU_Opening_Hour::setRThursday (const T_TCU_Opening_Hour_Day& rThursday_) {
    set_has_rThursday();
    this->_rThursday = rThursday_;
}

inline void T_TCU_Opening_Hour::clearRFriday() {
    if (hasRFriday()) {
         clear_has_rFriday();
        _rFriday.clear();
     }
}

inline bool T_TCU_Opening_Hour::hasRFriday () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const T_TCU_Opening_Hour_Day& T_TCU_Opening_Hour::getRFriday () const {
    return _rFriday;
}

inline T_TCU_Opening_Hour_Day& T_TCU_Opening_Hour::getRFridayMutable () {
    set_has_rFriday();
    return _rFriday;
}

inline void T_TCU_Opening_Hour::setRFriday (const T_TCU_Opening_Hour_Day& rFriday_) {
    set_has_rFriday();
    this->_rFriday = rFriday_;
}

inline void T_TCU_Opening_Hour::clearRSaturday() {
    if (hasRSaturday()) {
         clear_has_rSaturday();
        _rSaturday.clear();
     }
}

inline bool T_TCU_Opening_Hour::hasRSaturday () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline const T_TCU_Opening_Hour_Day& T_TCU_Opening_Hour::getRSaturday () const {
    return _rSaturday;
}

inline T_TCU_Opening_Hour_Day& T_TCU_Opening_Hour::getRSaturdayMutable () {
    set_has_rSaturday();
    return _rSaturday;
}

inline void T_TCU_Opening_Hour::setRSaturday (const T_TCU_Opening_Hour_Day& rSaturday_) {
    set_has_rSaturday();
    this->_rSaturday = rSaturday_;
}

inline void T_TCU_Opening_Hour::set_has_rSunday () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TCU_Opening_Hour::clear_has_rSunday () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TCU_Opening_Hour::set_has_rMonday () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TCU_Opening_Hour::clear_has_rMonday () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_TCU_Opening_Hour::set_has_rTuesday () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_TCU_Opening_Hour::clear_has_rTuesday () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_TCU_Opening_Hour::set_has_rWednesday () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_TCU_Opening_Hour::clear_has_rWednesday () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_TCU_Opening_Hour::set_has_rThursday () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_TCU_Opening_Hour::clear_has_rThursday () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_TCU_Opening_Hour::set_has_rFriday () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_TCU_Opening_Hour::clear_has_rFriday () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_TCU_Opening_Hour::set_has_rSaturday () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_TCU_Opening_Hour::clear_has_rSaturday () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline  T_TCU_Full_Address::T_TCU_Full_Address ()  :
    _u8Length_of_Text (0u),
    _sText_Info ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TCU_Full_Address::T_TCU_Full_Address (const T_TCU_Full_Address &rhs)  :
    _u8Length_of_Text (0u),
    _sText_Info ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TCU_Full_Address::T_TCU_Full_Address (uint8 u8Length_of_Text_, const ::std::string& sText_Info_)  :
    _u8Length_of_Text (u8Length_of_Text_),
    _sText_Info (sText_Info_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sText_Info_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TCU_Full_Address::~T_TCU_Full_Address() {
}

inline T_TCU_Full_Address& T_TCU_Full_Address::operator = (const T_TCU_Full_Address& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8Length_of_Text()) {
            setU8Length_of_Text(rhs.getU8Length_of_Text());
        } else {
            clearU8Length_of_Text();
        }
        if (rhs.hasSText_Info()) {
            setSText_Info(rhs.getSText_Info());
        } else {
            clearSText_Info();
        }
    }
    return *this;
}

inline bool T_TCU_Full_Address::operator == (const T_TCU_Full_Address& rhs) const {
    return (((!hasU8Length_of_Text() && !rhs.hasU8Length_of_Text()) || getU8Length_of_Text() == rhs.getU8Length_of_Text()) &&
        ((!hasSText_Info() && !rhs.hasSText_Info()) || getSText_Info() == rhs.getSText_Info()));
}

inline bool T_TCU_Full_Address::operator != (const T_TCU_Full_Address& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TCU_Full_Address::operator < (const T_TCU_Full_Address& rhs) const {
    if (hasU8Length_of_Text() || rhs.hasU8Length_of_Text()) {
        if (getU8Length_of_Text() < rhs.getU8Length_of_Text()) return true;
        if (getU8Length_of_Text() > rhs.getU8Length_of_Text()) return false;
    }
    if (hasSText_Info() || rhs.hasSText_Info()) {
        if (getSText_Info() < rhs.getSText_Info()) return true;
        if (getSText_Info() > rhs.getSText_Info()) return false;
    }
    return false;
}

inline bool T_TCU_Full_Address::operator > (const T_TCU_Full_Address& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TCU_Full_Address::clear() {
    clearU8Length_of_Text();
    clearSText_Info();
}

inline void T_TCU_Full_Address::clearU8Length_of_Text() {
    if (hasU8Length_of_Text()) {
         clear_has_u8Length_of_Text();
        _u8Length_of_Text = 0u;
     }
}

inline bool T_TCU_Full_Address::hasU8Length_of_Text () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_TCU_Full_Address::getU8Length_of_Text () const {
    return _u8Length_of_Text;
}

inline void T_TCU_Full_Address::setU8Length_of_Text (uint8 u8Length_of_Text_) {
    set_has_u8Length_of_Text();
    this->_u8Length_of_Text = u8Length_of_Text_;
}

inline void T_TCU_Full_Address::clearSText_Info() {
    if (hasSText_Info()) {
         clear_has_sText_Info();
        _sText_Info.clear();
     }
}

inline bool T_TCU_Full_Address::hasSText_Info () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_TCU_Full_Address::getSText_Info () const {
    return _sText_Info;
}

inline ::std::string& T_TCU_Full_Address::getSText_InfoMutable () {
    set_has_sText_Info();
    return _sText_Info;
}

inline void T_TCU_Full_Address::setSText_Info (const ::std::string& sText_Info_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sText_Info_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sText_Info();
    this->_sText_Info = sText_Info_;
}

inline void T_TCU_Full_Address::setSText_Info (const char* sText_Info_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sText_Info_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sText_Info();
    this->_sText_Info.assign(sText_Info_);
}

inline void T_TCU_Full_Address::setSText_Info (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sText_Info();
    this->_sText_Info.assign(value, size);
}

inline void T_TCU_Full_Address::set_has_u8Length_of_Text () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TCU_Full_Address::clear_has_u8Length_of_Text () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TCU_Full_Address::set_has_sText_Info () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TCU_Full_Address::clear_has_sText_Info () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_TCU_Bookable_Free_Text::T_TCU_Bookable_Free_Text ()  :
    _u8Length_of_Text (0u),
    _sText_Info ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TCU_Bookable_Free_Text::T_TCU_Bookable_Free_Text (const T_TCU_Bookable_Free_Text &rhs)  :
    _u8Length_of_Text (0u),
    _sText_Info ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TCU_Bookable_Free_Text::T_TCU_Bookable_Free_Text (uint8 u8Length_of_Text_, const ::std::string& sText_Info_)  :
    _u8Length_of_Text (u8Length_of_Text_),
    _sText_Info (sText_Info_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sText_Info_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TCU_Bookable_Free_Text::~T_TCU_Bookable_Free_Text() {
}

inline T_TCU_Bookable_Free_Text& T_TCU_Bookable_Free_Text::operator = (const T_TCU_Bookable_Free_Text& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8Length_of_Text()) {
            setU8Length_of_Text(rhs.getU8Length_of_Text());
        } else {
            clearU8Length_of_Text();
        }
        if (rhs.hasSText_Info()) {
            setSText_Info(rhs.getSText_Info());
        } else {
            clearSText_Info();
        }
    }
    return *this;
}

inline bool T_TCU_Bookable_Free_Text::operator == (const T_TCU_Bookable_Free_Text& rhs) const {
    return (((!hasU8Length_of_Text() && !rhs.hasU8Length_of_Text()) || getU8Length_of_Text() == rhs.getU8Length_of_Text()) &&
        ((!hasSText_Info() && !rhs.hasSText_Info()) || getSText_Info() == rhs.getSText_Info()));
}

inline bool T_TCU_Bookable_Free_Text::operator != (const T_TCU_Bookable_Free_Text& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TCU_Bookable_Free_Text::operator < (const T_TCU_Bookable_Free_Text& rhs) const {
    if (hasU8Length_of_Text() || rhs.hasU8Length_of_Text()) {
        if (getU8Length_of_Text() < rhs.getU8Length_of_Text()) return true;
        if (getU8Length_of_Text() > rhs.getU8Length_of_Text()) return false;
    }
    if (hasSText_Info() || rhs.hasSText_Info()) {
        if (getSText_Info() < rhs.getSText_Info()) return true;
        if (getSText_Info() > rhs.getSText_Info()) return false;
    }
    return false;
}

inline bool T_TCU_Bookable_Free_Text::operator > (const T_TCU_Bookable_Free_Text& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TCU_Bookable_Free_Text::clear() {
    clearU8Length_of_Text();
    clearSText_Info();
}

inline void T_TCU_Bookable_Free_Text::clearU8Length_of_Text() {
    if (hasU8Length_of_Text()) {
         clear_has_u8Length_of_Text();
        _u8Length_of_Text = 0u;
     }
}

inline bool T_TCU_Bookable_Free_Text::hasU8Length_of_Text () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_TCU_Bookable_Free_Text::getU8Length_of_Text () const {
    return _u8Length_of_Text;
}

inline void T_TCU_Bookable_Free_Text::setU8Length_of_Text (uint8 u8Length_of_Text_) {
    set_has_u8Length_of_Text();
    this->_u8Length_of_Text = u8Length_of_Text_;
}

inline void T_TCU_Bookable_Free_Text::clearSText_Info() {
    if (hasSText_Info()) {
         clear_has_sText_Info();
        _sText_Info.clear();
     }
}

inline bool T_TCU_Bookable_Free_Text::hasSText_Info () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_TCU_Bookable_Free_Text::getSText_Info () const {
    return _sText_Info;
}

inline ::std::string& T_TCU_Bookable_Free_Text::getSText_InfoMutable () {
    set_has_sText_Info();
    return _sText_Info;
}

inline void T_TCU_Bookable_Free_Text::setSText_Info (const ::std::string& sText_Info_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sText_Info_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sText_Info();
    this->_sText_Info = sText_Info_;
}

inline void T_TCU_Bookable_Free_Text::setSText_Info (const char* sText_Info_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sText_Info_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sText_Info();
    this->_sText_Info.assign(sText_Info_);
}

inline void T_TCU_Bookable_Free_Text::setSText_Info (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sText_Info();
    this->_sText_Info.assign(value, size);
}

inline void T_TCU_Bookable_Free_Text::set_has_u8Length_of_Text () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TCU_Bookable_Free_Text::clear_has_u8Length_of_Text () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TCU_Bookable_Free_Text::set_has_sText_Info () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TCU_Bookable_Free_Text::clear_has_sText_Info () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_TCU_Receptacle::T_TCU_Receptacle ()  :
    _e8Charge_Receptacle_Type (::tcu_main_fi_types::T_e8_TCU_Charge_Receptacle_Type__Small_Paddle),
    _u16Available_Power (0u),
    _e8Charge_Receptacle_Facility (::tcu_main_fi_types::T_e8_TCU_Charge_Receptacle_Facility__200_240v_1_Phase_10A)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TCU_Receptacle::T_TCU_Receptacle (const T_TCU_Receptacle &rhs)  :
    _e8Charge_Receptacle_Type (::tcu_main_fi_types::T_e8_TCU_Charge_Receptacle_Type__Small_Paddle),
    _u16Available_Power (0u),
    _e8Charge_Receptacle_Facility (::tcu_main_fi_types::T_e8_TCU_Charge_Receptacle_Facility__200_240v_1_Phase_10A)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TCU_Receptacle::T_TCU_Receptacle (T_e8_TCU_Charge_Receptacle_Type e8Charge_Receptacle_Type_, uint16 u16Available_Power_, T_e8_TCU_Charge_Receptacle_Facility e8Charge_Receptacle_Facility_)  :
    _e8Charge_Receptacle_Type (e8Charge_Receptacle_Type_),
    _u16Available_Power (u16Available_Power_),
    _e8Charge_Receptacle_Facility (e8Charge_Receptacle_Facility_)
{
    #ifndef NDEBUG
    if (!(T_e8_TCU_Charge_Receptacle_Type_IsValid(e8Charge_Receptacle_Type_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Charge_Receptacle_Type_, "T_e8_TCU_Charge_Receptacle_Type", "e8Charge_Receptacle_Type", "T_TCU_Receptacle");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_TCU_Charge_Receptacle_Facility_IsValid(e8Charge_Receptacle_Facility_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Charge_Receptacle_Facility_, "T_e8_TCU_Charge_Receptacle_Facility", "e8Charge_Receptacle_Facility", "T_TCU_Receptacle");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TCU_Receptacle::~T_TCU_Receptacle() {
}

inline T_TCU_Receptacle& T_TCU_Receptacle::operator = (const T_TCU_Receptacle& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE8Charge_Receptacle_Type()) {
            setE8Charge_Receptacle_Type(rhs.getE8Charge_Receptacle_Type());
        } else {
            clearE8Charge_Receptacle_Type();
        }
        if (rhs.hasU16Available_Power()) {
            setU16Available_Power(rhs.getU16Available_Power());
        } else {
            clearU16Available_Power();
        }
        if (rhs.hasE8Charge_Receptacle_Facility()) {
            setE8Charge_Receptacle_Facility(rhs.getE8Charge_Receptacle_Facility());
        } else {
            clearE8Charge_Receptacle_Facility();
        }
    }
    return *this;
}

inline bool T_TCU_Receptacle::operator == (const T_TCU_Receptacle& rhs) const {
    return (((!hasE8Charge_Receptacle_Type() && !rhs.hasE8Charge_Receptacle_Type()) || getE8Charge_Receptacle_Type() == rhs.getE8Charge_Receptacle_Type()) &&
        ((!hasU16Available_Power() && !rhs.hasU16Available_Power()) || getU16Available_Power() == rhs.getU16Available_Power()) &&
        ((!hasE8Charge_Receptacle_Facility() && !rhs.hasE8Charge_Receptacle_Facility()) || getE8Charge_Receptacle_Facility() == rhs.getE8Charge_Receptacle_Facility()));
}

inline bool T_TCU_Receptacle::operator != (const T_TCU_Receptacle& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TCU_Receptacle::operator < (const T_TCU_Receptacle& rhs) const {
    if (hasE8Charge_Receptacle_Type() || rhs.hasE8Charge_Receptacle_Type()) {
        if ((uint32)getE8Charge_Receptacle_Type() < (uint32)rhs.getE8Charge_Receptacle_Type()) return true;
        if ((uint32)getE8Charge_Receptacle_Type() > (uint32)rhs.getE8Charge_Receptacle_Type()) return false;
    }
    if (hasU16Available_Power() || rhs.hasU16Available_Power()) {
        if (getU16Available_Power() < rhs.getU16Available_Power()) return true;
        if (getU16Available_Power() > rhs.getU16Available_Power()) return false;
    }
    if (hasE8Charge_Receptacle_Facility() || rhs.hasE8Charge_Receptacle_Facility()) {
        if ((uint32)getE8Charge_Receptacle_Facility() < (uint32)rhs.getE8Charge_Receptacle_Facility()) return true;
        if ((uint32)getE8Charge_Receptacle_Facility() > (uint32)rhs.getE8Charge_Receptacle_Facility()) return false;
    }
    return false;
}

inline bool T_TCU_Receptacle::operator > (const T_TCU_Receptacle& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TCU_Receptacle::clear() {
    clearE8Charge_Receptacle_Type();
    clearU16Available_Power();
    clearE8Charge_Receptacle_Facility();
}

inline void T_TCU_Receptacle::clearE8Charge_Receptacle_Type() {
    if (hasE8Charge_Receptacle_Type()) {
         clear_has_e8Charge_Receptacle_Type();
        _e8Charge_Receptacle_Type = ::tcu_main_fi_types::T_e8_TCU_Charge_Receptacle_Type__Small_Paddle;
     }
}

inline bool T_TCU_Receptacle::hasE8Charge_Receptacle_Type () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_TCU_Charge_Receptacle_Type T_TCU_Receptacle::getE8Charge_Receptacle_Type () const {
    return _e8Charge_Receptacle_Type;
}

inline void T_TCU_Receptacle::setE8Charge_Receptacle_Type (T_e8_TCU_Charge_Receptacle_Type e8Charge_Receptacle_Type_) {
    #ifndef NDEBUG
    if (!(T_e8_TCU_Charge_Receptacle_Type_IsValid(e8Charge_Receptacle_Type_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Charge_Receptacle_Type_, "T_e8_TCU_Charge_Receptacle_Type", "e8Charge_Receptacle_Type", "T_TCU_Receptacle");
    }
    #endif
    set_has_e8Charge_Receptacle_Type();
    this->_e8Charge_Receptacle_Type = e8Charge_Receptacle_Type_;
}

inline void T_TCU_Receptacle::clearU16Available_Power() {
    if (hasU16Available_Power()) {
         clear_has_u16Available_Power();
        _u16Available_Power = 0u;
     }
}

inline bool T_TCU_Receptacle::hasU16Available_Power () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 T_TCU_Receptacle::getU16Available_Power () const {
    return _u16Available_Power;
}

inline void T_TCU_Receptacle::setU16Available_Power (uint16 u16Available_Power_) {
    set_has_u16Available_Power();
    this->_u16Available_Power = u16Available_Power_;
}

inline void T_TCU_Receptacle::clearE8Charge_Receptacle_Facility() {
    if (hasE8Charge_Receptacle_Facility()) {
         clear_has_e8Charge_Receptacle_Facility();
        _e8Charge_Receptacle_Facility = ::tcu_main_fi_types::T_e8_TCU_Charge_Receptacle_Facility__200_240v_1_Phase_10A;
     }
}

inline bool T_TCU_Receptacle::hasE8Charge_Receptacle_Facility () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_TCU_Charge_Receptacle_Facility T_TCU_Receptacle::getE8Charge_Receptacle_Facility () const {
    return _e8Charge_Receptacle_Facility;
}

inline void T_TCU_Receptacle::setE8Charge_Receptacle_Facility (T_e8_TCU_Charge_Receptacle_Facility e8Charge_Receptacle_Facility_) {
    #ifndef NDEBUG
    if (!(T_e8_TCU_Charge_Receptacle_Facility_IsValid(e8Charge_Receptacle_Facility_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Charge_Receptacle_Facility_, "T_e8_TCU_Charge_Receptacle_Facility", "e8Charge_Receptacle_Facility", "T_TCU_Receptacle");
    }
    #endif
    set_has_e8Charge_Receptacle_Facility();
    this->_e8Charge_Receptacle_Facility = e8Charge_Receptacle_Facility_;
}

inline void T_TCU_Receptacle::set_has_e8Charge_Receptacle_Type () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TCU_Receptacle::clear_has_e8Charge_Receptacle_Type () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TCU_Receptacle::set_has_u16Available_Power () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TCU_Receptacle::clear_has_u16Available_Power () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_TCU_Receptacle::set_has_e8Charge_Receptacle_Facility () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_TCU_Receptacle::clear_has_e8Charge_Receptacle_Facility () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_TCU_Spot_List::T_TCU_Spot_List ()  :
    _sCharge_Spot_ID (),
    _e8Bookable_Information (::tcu_main_fi_types::T_e8_TCU_Bookable_Information__Unspecified),
    _e8Spot_Availability (::tcu_main_fi_types::T_e8_TCU_Spot_Availability__Unspecified),
    _rBookable_Free_Text (),
    _u8Total_Number_Receptacles (0u),
    _rReceptacle1 (),
    _rReceptacle2 (),
    _rReceptacle3 (),
    _rReceptacle4 (),
    _rReceptacle5 (),
    _rReceptacle6 (),
    _rReceptacle7 (),
    _rReceptacle8 (),
    _rReceptacle9 (),
    _rReceptacle10 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TCU_Spot_List::T_TCU_Spot_List (const T_TCU_Spot_List &rhs)  :
    _sCharge_Spot_ID (),
    _e8Bookable_Information (::tcu_main_fi_types::T_e8_TCU_Bookable_Information__Unspecified),
    _e8Spot_Availability (::tcu_main_fi_types::T_e8_TCU_Spot_Availability__Unspecified),
    _rBookable_Free_Text (),
    _u8Total_Number_Receptacles (0u),
    _rReceptacle1 (),
    _rReceptacle2 (),
    _rReceptacle3 (),
    _rReceptacle4 (),
    _rReceptacle5 (),
    _rReceptacle6 (),
    _rReceptacle7 (),
    _rReceptacle8 (),
    _rReceptacle9 (),
    _rReceptacle10 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TCU_Spot_List::T_TCU_Spot_List (const ::std::string& sCharge_Spot_ID_, T_e8_TCU_Bookable_Information e8Bookable_Information_, T_e8_TCU_Spot_Availability e8Spot_Availability_, const T_TCU_Bookable_Free_Text& rBookable_Free_Text_, uint8 u8Total_Number_Receptacles_, const T_TCU_Receptacle& rReceptacle1_, const T_TCU_Receptacle& rReceptacle2_, const T_TCU_Receptacle& rReceptacle3_, const T_TCU_Receptacle& rReceptacle4_, const T_TCU_Receptacle& rReceptacle5_, const T_TCU_Receptacle& rReceptacle6_, const T_TCU_Receptacle& rReceptacle7_, const T_TCU_Receptacle& rReceptacle8_, const T_TCU_Receptacle& rReceptacle9_, const T_TCU_Receptacle& rReceptacle10_)  :
    _sCharge_Spot_ID (sCharge_Spot_ID_),
    _e8Bookable_Information (e8Bookable_Information_),
    _e8Spot_Availability (e8Spot_Availability_),
    _rBookable_Free_Text (rBookable_Free_Text_),
    _u8Total_Number_Receptacles (u8Total_Number_Receptacles_),
    _rReceptacle1 (rReceptacle1_),
    _rReceptacle2 (rReceptacle2_),
    _rReceptacle3 (rReceptacle3_),
    _rReceptacle4 (rReceptacle4_),
    _rReceptacle5 (rReceptacle5_),
    _rReceptacle6 (rReceptacle6_),
    _rReceptacle7 (rReceptacle7_),
    _rReceptacle8 (rReceptacle8_),
    _rReceptacle9 (rReceptacle9_),
    _rReceptacle10 (rReceptacle10_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sCharge_Spot_ID_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e8_TCU_Bookable_Information_IsValid(e8Bookable_Information_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Bookable_Information_, "T_e8_TCU_Bookable_Information", "e8Bookable_Information", "T_TCU_Spot_List");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_TCU_Spot_Availability_IsValid(e8Spot_Availability_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Spot_Availability_, "T_e8_TCU_Spot_Availability", "e8Spot_Availability", "T_TCU_Spot_List");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TCU_Spot_List::~T_TCU_Spot_List() {
}

inline T_TCU_Spot_List& T_TCU_Spot_List::operator = (const T_TCU_Spot_List& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSCharge_Spot_ID()) {
            setSCharge_Spot_ID(rhs.getSCharge_Spot_ID());
        } else {
            clearSCharge_Spot_ID();
        }
        if (rhs.hasE8Bookable_Information()) {
            setE8Bookable_Information(rhs.getE8Bookable_Information());
        } else {
            clearE8Bookable_Information();
        }
        if (rhs.hasE8Spot_Availability()) {
            setE8Spot_Availability(rhs.getE8Spot_Availability());
        } else {
            clearE8Spot_Availability();
        }
        if (rhs.hasRBookable_Free_Text()) {
            setRBookable_Free_Text(rhs.getRBookable_Free_Text());
        } else {
            clearRBookable_Free_Text();
        }
        if (rhs.hasU8Total_Number_Receptacles()) {
            setU8Total_Number_Receptacles(rhs.getU8Total_Number_Receptacles());
        } else {
            clearU8Total_Number_Receptacles();
        }
        if (rhs.hasRReceptacle1()) {
            setRReceptacle1(rhs.getRReceptacle1());
        } else {
            clearRReceptacle1();
        }
        if (rhs.hasRReceptacle2()) {
            setRReceptacle2(rhs.getRReceptacle2());
        } else {
            clearRReceptacle2();
        }
        if (rhs.hasRReceptacle3()) {
            setRReceptacle3(rhs.getRReceptacle3());
        } else {
            clearRReceptacle3();
        }
        if (rhs.hasRReceptacle4()) {
            setRReceptacle4(rhs.getRReceptacle4());
        } else {
            clearRReceptacle4();
        }
        if (rhs.hasRReceptacle5()) {
            setRReceptacle5(rhs.getRReceptacle5());
        } else {
            clearRReceptacle5();
        }
        if (rhs.hasRReceptacle6()) {
            setRReceptacle6(rhs.getRReceptacle6());
        } else {
            clearRReceptacle6();
        }
        if (rhs.hasRReceptacle7()) {
            setRReceptacle7(rhs.getRReceptacle7());
        } else {
            clearRReceptacle7();
        }
        if (rhs.hasRReceptacle8()) {
            setRReceptacle8(rhs.getRReceptacle8());
        } else {
            clearRReceptacle8();
        }
        if (rhs.hasRReceptacle9()) {
            setRReceptacle9(rhs.getRReceptacle9());
        } else {
            clearRReceptacle9();
        }
        if (rhs.hasRReceptacle10()) {
            setRReceptacle10(rhs.getRReceptacle10());
        } else {
            clearRReceptacle10();
        }
    }
    return *this;
}

inline bool T_TCU_Spot_List::operator == (const T_TCU_Spot_List& rhs) const {
    return (((!hasSCharge_Spot_ID() && !rhs.hasSCharge_Spot_ID()) || getSCharge_Spot_ID() == rhs.getSCharge_Spot_ID()) &&
        ((!hasE8Bookable_Information() && !rhs.hasE8Bookable_Information()) || getE8Bookable_Information() == rhs.getE8Bookable_Information()) &&
        ((!hasE8Spot_Availability() && !rhs.hasE8Spot_Availability()) || getE8Spot_Availability() == rhs.getE8Spot_Availability()) &&
        ((!hasRBookable_Free_Text() && !rhs.hasRBookable_Free_Text()) || getRBookable_Free_Text() == rhs.getRBookable_Free_Text()) &&
        ((!hasU8Total_Number_Receptacles() && !rhs.hasU8Total_Number_Receptacles()) || getU8Total_Number_Receptacles() == rhs.getU8Total_Number_Receptacles()) &&
        ((!hasRReceptacle1() && !rhs.hasRReceptacle1()) || getRReceptacle1() == rhs.getRReceptacle1()) &&
        ((!hasRReceptacle2() && !rhs.hasRReceptacle2()) || getRReceptacle2() == rhs.getRReceptacle2()) &&
        ((!hasRReceptacle3() && !rhs.hasRReceptacle3()) || getRReceptacle3() == rhs.getRReceptacle3()) &&
        ((!hasRReceptacle4() && !rhs.hasRReceptacle4()) || getRReceptacle4() == rhs.getRReceptacle4()) &&
        ((!hasRReceptacle5() && !rhs.hasRReceptacle5()) || getRReceptacle5() == rhs.getRReceptacle5()) &&
        ((!hasRReceptacle6() && !rhs.hasRReceptacle6()) || getRReceptacle6() == rhs.getRReceptacle6()) &&
        ((!hasRReceptacle7() && !rhs.hasRReceptacle7()) || getRReceptacle7() == rhs.getRReceptacle7()) &&
        ((!hasRReceptacle8() && !rhs.hasRReceptacle8()) || getRReceptacle8() == rhs.getRReceptacle8()) &&
        ((!hasRReceptacle9() && !rhs.hasRReceptacle9()) || getRReceptacle9() == rhs.getRReceptacle9()) &&
        ((!hasRReceptacle10() && !rhs.hasRReceptacle10()) || getRReceptacle10() == rhs.getRReceptacle10()));
}

inline bool T_TCU_Spot_List::operator != (const T_TCU_Spot_List& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TCU_Spot_List::operator < (const T_TCU_Spot_List& rhs) const {
    if (hasSCharge_Spot_ID() || rhs.hasSCharge_Spot_ID()) {
        if (getSCharge_Spot_ID() < rhs.getSCharge_Spot_ID()) return true;
        if (getSCharge_Spot_ID() > rhs.getSCharge_Spot_ID()) return false;
    }
    if (hasE8Bookable_Information() || rhs.hasE8Bookable_Information()) {
        if ((uint32)getE8Bookable_Information() < (uint32)rhs.getE8Bookable_Information()) return true;
        if ((uint32)getE8Bookable_Information() > (uint32)rhs.getE8Bookable_Information()) return false;
    }
    if (hasE8Spot_Availability() || rhs.hasE8Spot_Availability()) {
        if ((uint32)getE8Spot_Availability() < (uint32)rhs.getE8Spot_Availability()) return true;
        if ((uint32)getE8Spot_Availability() > (uint32)rhs.getE8Spot_Availability()) return false;
    }
    if (hasRBookable_Free_Text() || rhs.hasRBookable_Free_Text()) {
        if (getRBookable_Free_Text() < rhs.getRBookable_Free_Text()) return true;
        if (getRBookable_Free_Text() > rhs.getRBookable_Free_Text()) return false;
    }
    if (hasU8Total_Number_Receptacles() || rhs.hasU8Total_Number_Receptacles()) {
        if (getU8Total_Number_Receptacles() < rhs.getU8Total_Number_Receptacles()) return true;
        if (getU8Total_Number_Receptacles() > rhs.getU8Total_Number_Receptacles()) return false;
    }
    if (hasRReceptacle1() || rhs.hasRReceptacle1()) {
        if (getRReceptacle1() < rhs.getRReceptacle1()) return true;
        if (getRReceptacle1() > rhs.getRReceptacle1()) return false;
    }
    if (hasRReceptacle2() || rhs.hasRReceptacle2()) {
        if (getRReceptacle2() < rhs.getRReceptacle2()) return true;
        if (getRReceptacle2() > rhs.getRReceptacle2()) return false;
    }
    if (hasRReceptacle3() || rhs.hasRReceptacle3()) {
        if (getRReceptacle3() < rhs.getRReceptacle3()) return true;
        if (getRReceptacle3() > rhs.getRReceptacle3()) return false;
    }
    if (hasRReceptacle4() || rhs.hasRReceptacle4()) {
        if (getRReceptacle4() < rhs.getRReceptacle4()) return true;
        if (getRReceptacle4() > rhs.getRReceptacle4()) return false;
    }
    if (hasRReceptacle5() || rhs.hasRReceptacle5()) {
        if (getRReceptacle5() < rhs.getRReceptacle5()) return true;
        if (getRReceptacle5() > rhs.getRReceptacle5()) return false;
    }
    if (hasRReceptacle6() || rhs.hasRReceptacle6()) {
        if (getRReceptacle6() < rhs.getRReceptacle6()) return true;
        if (getRReceptacle6() > rhs.getRReceptacle6()) return false;
    }
    if (hasRReceptacle7() || rhs.hasRReceptacle7()) {
        if (getRReceptacle7() < rhs.getRReceptacle7()) return true;
        if (getRReceptacle7() > rhs.getRReceptacle7()) return false;
    }
    if (hasRReceptacle8() || rhs.hasRReceptacle8()) {
        if (getRReceptacle8() < rhs.getRReceptacle8()) return true;
        if (getRReceptacle8() > rhs.getRReceptacle8()) return false;
    }
    if (hasRReceptacle9() || rhs.hasRReceptacle9()) {
        if (getRReceptacle9() < rhs.getRReceptacle9()) return true;
        if (getRReceptacle9() > rhs.getRReceptacle9()) return false;
    }
    if (hasRReceptacle10() || rhs.hasRReceptacle10()) {
        if (getRReceptacle10() < rhs.getRReceptacle10()) return true;
        if (getRReceptacle10() > rhs.getRReceptacle10()) return false;
    }
    return false;
}

inline bool T_TCU_Spot_List::operator > (const T_TCU_Spot_List& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TCU_Spot_List::clear() {
    clearSCharge_Spot_ID();
    clearE8Bookable_Information();
    clearE8Spot_Availability();
    clearRBookable_Free_Text();
    clearU8Total_Number_Receptacles();
    clearRReceptacle1();
    clearRReceptacle2();
    clearRReceptacle3();
    clearRReceptacle4();
    clearRReceptacle5();
    clearRReceptacle6();
    clearRReceptacle7();
    clearRReceptacle8();
    clearRReceptacle9();
    clearRReceptacle10();
}

inline void T_TCU_Spot_List::clearSCharge_Spot_ID() {
    if (hasSCharge_Spot_ID()) {
         clear_has_sCharge_Spot_ID();
        _sCharge_Spot_ID.clear();
     }
}

inline bool T_TCU_Spot_List::hasSCharge_Spot_ID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_TCU_Spot_List::getSCharge_Spot_ID () const {
    return _sCharge_Spot_ID;
}

inline ::std::string& T_TCU_Spot_List::getSCharge_Spot_IDMutable () {
    set_has_sCharge_Spot_ID();
    return _sCharge_Spot_ID;
}

inline void T_TCU_Spot_List::setSCharge_Spot_ID (const ::std::string& sCharge_Spot_ID_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sCharge_Spot_ID_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sCharge_Spot_ID();
    this->_sCharge_Spot_ID = sCharge_Spot_ID_;
}

inline void T_TCU_Spot_List::setSCharge_Spot_ID (const char* sCharge_Spot_ID_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sCharge_Spot_ID_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sCharge_Spot_ID();
    this->_sCharge_Spot_ID.assign(sCharge_Spot_ID_);
}

inline void T_TCU_Spot_List::setSCharge_Spot_ID (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sCharge_Spot_ID();
    this->_sCharge_Spot_ID.assign(value, size);
}

inline void T_TCU_Spot_List::clearE8Bookable_Information() {
    if (hasE8Bookable_Information()) {
         clear_has_e8Bookable_Information();
        _e8Bookable_Information = ::tcu_main_fi_types::T_e8_TCU_Bookable_Information__Unspecified;
     }
}

inline bool T_TCU_Spot_List::hasE8Bookable_Information () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_TCU_Bookable_Information T_TCU_Spot_List::getE8Bookable_Information () const {
    return _e8Bookable_Information;
}

inline void T_TCU_Spot_List::setE8Bookable_Information (T_e8_TCU_Bookable_Information e8Bookable_Information_) {
    #ifndef NDEBUG
    if (!(T_e8_TCU_Bookable_Information_IsValid(e8Bookable_Information_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Bookable_Information_, "T_e8_TCU_Bookable_Information", "e8Bookable_Information", "T_TCU_Spot_List");
    }
    #endif
    set_has_e8Bookable_Information();
    this->_e8Bookable_Information = e8Bookable_Information_;
}

inline void T_TCU_Spot_List::clearE8Spot_Availability() {
    if (hasE8Spot_Availability()) {
         clear_has_e8Spot_Availability();
        _e8Spot_Availability = ::tcu_main_fi_types::T_e8_TCU_Spot_Availability__Unspecified;
     }
}

inline bool T_TCU_Spot_List::hasE8Spot_Availability () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_TCU_Spot_Availability T_TCU_Spot_List::getE8Spot_Availability () const {
    return _e8Spot_Availability;
}

inline void T_TCU_Spot_List::setE8Spot_Availability (T_e8_TCU_Spot_Availability e8Spot_Availability_) {
    #ifndef NDEBUG
    if (!(T_e8_TCU_Spot_Availability_IsValid(e8Spot_Availability_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Spot_Availability_, "T_e8_TCU_Spot_Availability", "e8Spot_Availability", "T_TCU_Spot_List");
    }
    #endif
    set_has_e8Spot_Availability();
    this->_e8Spot_Availability = e8Spot_Availability_;
}

inline void T_TCU_Spot_List::clearRBookable_Free_Text() {
    if (hasRBookable_Free_Text()) {
         clear_has_rBookable_Free_Text();
        _rBookable_Free_Text.clear();
     }
}

inline bool T_TCU_Spot_List::hasRBookable_Free_Text () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const T_TCU_Bookable_Free_Text& T_TCU_Spot_List::getRBookable_Free_Text () const {
    return _rBookable_Free_Text;
}

inline T_TCU_Bookable_Free_Text& T_TCU_Spot_List::getRBookable_Free_TextMutable () {
    set_has_rBookable_Free_Text();
    return _rBookable_Free_Text;
}

inline void T_TCU_Spot_List::setRBookable_Free_Text (const T_TCU_Bookable_Free_Text& rBookable_Free_Text_) {
    set_has_rBookable_Free_Text();
    this->_rBookable_Free_Text = rBookable_Free_Text_;
}

inline void T_TCU_Spot_List::clearU8Total_Number_Receptacles() {
    if (hasU8Total_Number_Receptacles()) {
         clear_has_u8Total_Number_Receptacles();
        _u8Total_Number_Receptacles = 0u;
     }
}

inline bool T_TCU_Spot_List::hasU8Total_Number_Receptacles () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 T_TCU_Spot_List::getU8Total_Number_Receptacles () const {
    return _u8Total_Number_Receptacles;
}

inline void T_TCU_Spot_List::setU8Total_Number_Receptacles (uint8 u8Total_Number_Receptacles_) {
    set_has_u8Total_Number_Receptacles();
    this->_u8Total_Number_Receptacles = u8Total_Number_Receptacles_;
}

inline void T_TCU_Spot_List::clearRReceptacle1() {
    if (hasRReceptacle1()) {
         clear_has_rReceptacle1();
        _rReceptacle1.clear();
     }
}

inline bool T_TCU_Spot_List::hasRReceptacle1 () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const T_TCU_Receptacle& T_TCU_Spot_List::getRReceptacle1 () const {
    return _rReceptacle1;
}

inline T_TCU_Receptacle& T_TCU_Spot_List::getRReceptacle1Mutable () {
    set_has_rReceptacle1();
    return _rReceptacle1;
}

inline void T_TCU_Spot_List::setRReceptacle1 (const T_TCU_Receptacle& rReceptacle1_) {
    set_has_rReceptacle1();
    this->_rReceptacle1 = rReceptacle1_;
}

inline void T_TCU_Spot_List::clearRReceptacle2() {
    if (hasRReceptacle2()) {
         clear_has_rReceptacle2();
        _rReceptacle2.clear();
     }
}

inline bool T_TCU_Spot_List::hasRReceptacle2 () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline const T_TCU_Receptacle& T_TCU_Spot_List::getRReceptacle2 () const {
    return _rReceptacle2;
}

inline T_TCU_Receptacle& T_TCU_Spot_List::getRReceptacle2Mutable () {
    set_has_rReceptacle2();
    return _rReceptacle2;
}

inline void T_TCU_Spot_List::setRReceptacle2 (const T_TCU_Receptacle& rReceptacle2_) {
    set_has_rReceptacle2();
    this->_rReceptacle2 = rReceptacle2_;
}

inline void T_TCU_Spot_List::clearRReceptacle3() {
    if (hasRReceptacle3()) {
         clear_has_rReceptacle3();
        _rReceptacle3.clear();
     }
}

inline bool T_TCU_Spot_List::hasRReceptacle3 () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline const T_TCU_Receptacle& T_TCU_Spot_List::getRReceptacle3 () const {
    return _rReceptacle3;
}

inline T_TCU_Receptacle& T_TCU_Spot_List::getRReceptacle3Mutable () {
    set_has_rReceptacle3();
    return _rReceptacle3;
}

inline void T_TCU_Spot_List::setRReceptacle3 (const T_TCU_Receptacle& rReceptacle3_) {
    set_has_rReceptacle3();
    this->_rReceptacle3 = rReceptacle3_;
}

inline void T_TCU_Spot_List::clearRReceptacle4() {
    if (hasRReceptacle4()) {
         clear_has_rReceptacle4();
        _rReceptacle4.clear();
     }
}

inline bool T_TCU_Spot_List::hasRReceptacle4 () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline const T_TCU_Receptacle& T_TCU_Spot_List::getRReceptacle4 () const {
    return _rReceptacle4;
}

inline T_TCU_Receptacle& T_TCU_Spot_List::getRReceptacle4Mutable () {
    set_has_rReceptacle4();
    return _rReceptacle4;
}

inline void T_TCU_Spot_List::setRReceptacle4 (const T_TCU_Receptacle& rReceptacle4_) {
    set_has_rReceptacle4();
    this->_rReceptacle4 = rReceptacle4_;
}

inline void T_TCU_Spot_List::clearRReceptacle5() {
    if (hasRReceptacle5()) {
         clear_has_rReceptacle5();
        _rReceptacle5.clear();
     }
}

inline bool T_TCU_Spot_List::hasRReceptacle5 () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline const T_TCU_Receptacle& T_TCU_Spot_List::getRReceptacle5 () const {
    return _rReceptacle5;
}

inline T_TCU_Receptacle& T_TCU_Spot_List::getRReceptacle5Mutable () {
    set_has_rReceptacle5();
    return _rReceptacle5;
}

inline void T_TCU_Spot_List::setRReceptacle5 (const T_TCU_Receptacle& rReceptacle5_) {
    set_has_rReceptacle5();
    this->_rReceptacle5 = rReceptacle5_;
}

inline void T_TCU_Spot_List::clearRReceptacle6() {
    if (hasRReceptacle6()) {
         clear_has_rReceptacle6();
        _rReceptacle6.clear();
     }
}

inline bool T_TCU_Spot_List::hasRReceptacle6 () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline const T_TCU_Receptacle& T_TCU_Spot_List::getRReceptacle6 () const {
    return _rReceptacle6;
}

inline T_TCU_Receptacle& T_TCU_Spot_List::getRReceptacle6Mutable () {
    set_has_rReceptacle6();
    return _rReceptacle6;
}

inline void T_TCU_Spot_List::setRReceptacle6 (const T_TCU_Receptacle& rReceptacle6_) {
    set_has_rReceptacle6();
    this->_rReceptacle6 = rReceptacle6_;
}

inline void T_TCU_Spot_List::clearRReceptacle7() {
    if (hasRReceptacle7()) {
         clear_has_rReceptacle7();
        _rReceptacle7.clear();
     }
}

inline bool T_TCU_Spot_List::hasRReceptacle7 () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline const T_TCU_Receptacle& T_TCU_Spot_List::getRReceptacle7 () const {
    return _rReceptacle7;
}

inline T_TCU_Receptacle& T_TCU_Spot_List::getRReceptacle7Mutable () {
    set_has_rReceptacle7();
    return _rReceptacle7;
}

inline void T_TCU_Spot_List::setRReceptacle7 (const T_TCU_Receptacle& rReceptacle7_) {
    set_has_rReceptacle7();
    this->_rReceptacle7 = rReceptacle7_;
}

inline void T_TCU_Spot_List::clearRReceptacle8() {
    if (hasRReceptacle8()) {
         clear_has_rReceptacle8();
        _rReceptacle8.clear();
     }
}

inline bool T_TCU_Spot_List::hasRReceptacle8 () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline const T_TCU_Receptacle& T_TCU_Spot_List::getRReceptacle8 () const {
    return _rReceptacle8;
}

inline T_TCU_Receptacle& T_TCU_Spot_List::getRReceptacle8Mutable () {
    set_has_rReceptacle8();
    return _rReceptacle8;
}

inline void T_TCU_Spot_List::setRReceptacle8 (const T_TCU_Receptacle& rReceptacle8_) {
    set_has_rReceptacle8();
    this->_rReceptacle8 = rReceptacle8_;
}

inline void T_TCU_Spot_List::clearRReceptacle9() {
    if (hasRReceptacle9()) {
         clear_has_rReceptacle9();
        _rReceptacle9.clear();
     }
}

inline bool T_TCU_Spot_List::hasRReceptacle9 () const {
    return (_has_bits_[0] & (1u << 13)) > 0;
}

inline const T_TCU_Receptacle& T_TCU_Spot_List::getRReceptacle9 () const {
    return _rReceptacle9;
}

inline T_TCU_Receptacle& T_TCU_Spot_List::getRReceptacle9Mutable () {
    set_has_rReceptacle9();
    return _rReceptacle9;
}

inline void T_TCU_Spot_List::setRReceptacle9 (const T_TCU_Receptacle& rReceptacle9_) {
    set_has_rReceptacle9();
    this->_rReceptacle9 = rReceptacle9_;
}

inline void T_TCU_Spot_List::clearRReceptacle10() {
    if (hasRReceptacle10()) {
         clear_has_rReceptacle10();
        _rReceptacle10.clear();
     }
}

inline bool T_TCU_Spot_List::hasRReceptacle10 () const {
    return (_has_bits_[0] & (1u << 14)) > 0;
}

inline const T_TCU_Receptacle& T_TCU_Spot_List::getRReceptacle10 () const {
    return _rReceptacle10;
}

inline T_TCU_Receptacle& T_TCU_Spot_List::getRReceptacle10Mutable () {
    set_has_rReceptacle10();
    return _rReceptacle10;
}

inline void T_TCU_Spot_List::setRReceptacle10 (const T_TCU_Receptacle& rReceptacle10_) {
    set_has_rReceptacle10();
    this->_rReceptacle10 = rReceptacle10_;
}

inline void T_TCU_Spot_List::set_has_sCharge_Spot_ID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TCU_Spot_List::clear_has_sCharge_Spot_ID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TCU_Spot_List::set_has_e8Bookable_Information () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TCU_Spot_List::clear_has_e8Bookable_Information () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_TCU_Spot_List::set_has_e8Spot_Availability () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_TCU_Spot_List::clear_has_e8Spot_Availability () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_TCU_Spot_List::set_has_rBookable_Free_Text () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_TCU_Spot_List::clear_has_rBookable_Free_Text () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_TCU_Spot_List::set_has_u8Total_Number_Receptacles () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_TCU_Spot_List::clear_has_u8Total_Number_Receptacles () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_TCU_Spot_List::set_has_rReceptacle1 () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_TCU_Spot_List::clear_has_rReceptacle1 () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_TCU_Spot_List::set_has_rReceptacle2 () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_TCU_Spot_List::clear_has_rReceptacle2 () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_TCU_Spot_List::set_has_rReceptacle3 () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_TCU_Spot_List::clear_has_rReceptacle3 () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_TCU_Spot_List::set_has_rReceptacle4 () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_TCU_Spot_List::clear_has_rReceptacle4 () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_TCU_Spot_List::set_has_rReceptacle5 () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_TCU_Spot_List::clear_has_rReceptacle5 () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_TCU_Spot_List::set_has_rReceptacle6 () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_TCU_Spot_List::clear_has_rReceptacle6 () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void T_TCU_Spot_List::set_has_rReceptacle7 () {
    _has_bits_[0] |= 1u << 11;
}

inline void T_TCU_Spot_List::clear_has_rReceptacle7 () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void T_TCU_Spot_List::set_has_rReceptacle8 () {
    _has_bits_[0] |= 1u << 12;
}

inline void T_TCU_Spot_List::clear_has_rReceptacle8 () {
    _has_bits_[0] &= ~ (1u << 12);
}

inline void T_TCU_Spot_List::set_has_rReceptacle9 () {
    _has_bits_[0] |= 1u << 13;
}

inline void T_TCU_Spot_List::clear_has_rReceptacle9 () {
    _has_bits_[0] &= ~ (1u << 13);
}

inline void T_TCU_Spot_List::set_has_rReceptacle10 () {
    _has_bits_[0] |= 1u << 14;
}

inline void T_TCU_Spot_List::clear_has_rReceptacle10 () {
    _has_bits_[0] &= ~ (1u << 14);
}

inline  T_TCU_Charge_Spot_List::T_TCU_Charge_Spot_List ()  :
    _u8Total_pages_of_lists (0u),
    _u8Pages_of_list (0u),
    _u8Station_List_Number (0u),
    _rSpot_List1 (),
    _rSpot_List2 (),
    _rSpot_List3 (),
    _rSpot_List4 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TCU_Charge_Spot_List::T_TCU_Charge_Spot_List (const T_TCU_Charge_Spot_List &rhs)  :
    _u8Total_pages_of_lists (0u),
    _u8Pages_of_list (0u),
    _u8Station_List_Number (0u),
    _rSpot_List1 (),
    _rSpot_List2 (),
    _rSpot_List3 (),
    _rSpot_List4 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TCU_Charge_Spot_List::T_TCU_Charge_Spot_List (uint8 u8Total_pages_of_lists_, uint8 u8Pages_of_list_, uint8 u8Station_List_Number_, const T_TCU_Spot_List& rSpot_List1_, const T_TCU_Spot_List& rSpot_List2_, const T_TCU_Spot_List& rSpot_List3_, const T_TCU_Spot_List& rSpot_List4_)  :
    _u8Total_pages_of_lists (u8Total_pages_of_lists_),
    _u8Pages_of_list (u8Pages_of_list_),
    _u8Station_List_Number (u8Station_List_Number_),
    _rSpot_List1 (rSpot_List1_),
    _rSpot_List2 (rSpot_List2_),
    _rSpot_List3 (rSpot_List3_),
    _rSpot_List4 (rSpot_List4_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TCU_Charge_Spot_List::~T_TCU_Charge_Spot_List() {
}

inline T_TCU_Charge_Spot_List& T_TCU_Charge_Spot_List::operator = (const T_TCU_Charge_Spot_List& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8Total_pages_of_lists()) {
            setU8Total_pages_of_lists(rhs.getU8Total_pages_of_lists());
        } else {
            clearU8Total_pages_of_lists();
        }
        if (rhs.hasU8Pages_of_list()) {
            setU8Pages_of_list(rhs.getU8Pages_of_list());
        } else {
            clearU8Pages_of_list();
        }
        if (rhs.hasU8Station_List_Number()) {
            setU8Station_List_Number(rhs.getU8Station_List_Number());
        } else {
            clearU8Station_List_Number();
        }
        if (rhs.hasRSpot_List1()) {
            setRSpot_List1(rhs.getRSpot_List1());
        } else {
            clearRSpot_List1();
        }
        if (rhs.hasRSpot_List2()) {
            setRSpot_List2(rhs.getRSpot_List2());
        } else {
            clearRSpot_List2();
        }
        if (rhs.hasRSpot_List3()) {
            setRSpot_List3(rhs.getRSpot_List3());
        } else {
            clearRSpot_List3();
        }
        if (rhs.hasRSpot_List4()) {
            setRSpot_List4(rhs.getRSpot_List4());
        } else {
            clearRSpot_List4();
        }
    }
    return *this;
}

inline bool T_TCU_Charge_Spot_List::operator == (const T_TCU_Charge_Spot_List& rhs) const {
    return (((!hasU8Total_pages_of_lists() && !rhs.hasU8Total_pages_of_lists()) || getU8Total_pages_of_lists() == rhs.getU8Total_pages_of_lists()) &&
        ((!hasU8Pages_of_list() && !rhs.hasU8Pages_of_list()) || getU8Pages_of_list() == rhs.getU8Pages_of_list()) &&
        ((!hasU8Station_List_Number() && !rhs.hasU8Station_List_Number()) || getU8Station_List_Number() == rhs.getU8Station_List_Number()) &&
        ((!hasRSpot_List1() && !rhs.hasRSpot_List1()) || getRSpot_List1() == rhs.getRSpot_List1()) &&
        ((!hasRSpot_List2() && !rhs.hasRSpot_List2()) || getRSpot_List2() == rhs.getRSpot_List2()) &&
        ((!hasRSpot_List3() && !rhs.hasRSpot_List3()) || getRSpot_List3() == rhs.getRSpot_List3()) &&
        ((!hasRSpot_List4() && !rhs.hasRSpot_List4()) || getRSpot_List4() == rhs.getRSpot_List4()));
}

inline bool T_TCU_Charge_Spot_List::operator != (const T_TCU_Charge_Spot_List& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TCU_Charge_Spot_List::operator < (const T_TCU_Charge_Spot_List& rhs) const {
    if (hasU8Total_pages_of_lists() || rhs.hasU8Total_pages_of_lists()) {
        if (getU8Total_pages_of_lists() < rhs.getU8Total_pages_of_lists()) return true;
        if (getU8Total_pages_of_lists() > rhs.getU8Total_pages_of_lists()) return false;
    }
    if (hasU8Pages_of_list() || rhs.hasU8Pages_of_list()) {
        if (getU8Pages_of_list() < rhs.getU8Pages_of_list()) return true;
        if (getU8Pages_of_list() > rhs.getU8Pages_of_list()) return false;
    }
    if (hasU8Station_List_Number() || rhs.hasU8Station_List_Number()) {
        if (getU8Station_List_Number() < rhs.getU8Station_List_Number()) return true;
        if (getU8Station_List_Number() > rhs.getU8Station_List_Number()) return false;
    }
    if (hasRSpot_List1() || rhs.hasRSpot_List1()) {
        if (getRSpot_List1() < rhs.getRSpot_List1()) return true;
        if (getRSpot_List1() > rhs.getRSpot_List1()) return false;
    }
    if (hasRSpot_List2() || rhs.hasRSpot_List2()) {
        if (getRSpot_List2() < rhs.getRSpot_List2()) return true;
        if (getRSpot_List2() > rhs.getRSpot_List2()) return false;
    }
    if (hasRSpot_List3() || rhs.hasRSpot_List3()) {
        if (getRSpot_List3() < rhs.getRSpot_List3()) return true;
        if (getRSpot_List3() > rhs.getRSpot_List3()) return false;
    }
    if (hasRSpot_List4() || rhs.hasRSpot_List4()) {
        if (getRSpot_List4() < rhs.getRSpot_List4()) return true;
        if (getRSpot_List4() > rhs.getRSpot_List4()) return false;
    }
    return false;
}

inline bool T_TCU_Charge_Spot_List::operator > (const T_TCU_Charge_Spot_List& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TCU_Charge_Spot_List::clear() {
    clearU8Total_pages_of_lists();
    clearU8Pages_of_list();
    clearU8Station_List_Number();
    clearRSpot_List1();
    clearRSpot_List2();
    clearRSpot_List3();
    clearRSpot_List4();
}

inline void T_TCU_Charge_Spot_List::clearU8Total_pages_of_lists() {
    if (hasU8Total_pages_of_lists()) {
         clear_has_u8Total_pages_of_lists();
        _u8Total_pages_of_lists = 0u;
     }
}

inline bool T_TCU_Charge_Spot_List::hasU8Total_pages_of_lists () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_TCU_Charge_Spot_List::getU8Total_pages_of_lists () const {
    return _u8Total_pages_of_lists;
}

inline void T_TCU_Charge_Spot_List::setU8Total_pages_of_lists (uint8 u8Total_pages_of_lists_) {
    set_has_u8Total_pages_of_lists();
    this->_u8Total_pages_of_lists = u8Total_pages_of_lists_;
}

inline void T_TCU_Charge_Spot_List::clearU8Pages_of_list() {
    if (hasU8Pages_of_list()) {
         clear_has_u8Pages_of_list();
        _u8Pages_of_list = 0u;
     }
}

inline bool T_TCU_Charge_Spot_List::hasU8Pages_of_list () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_TCU_Charge_Spot_List::getU8Pages_of_list () const {
    return _u8Pages_of_list;
}

inline void T_TCU_Charge_Spot_List::setU8Pages_of_list (uint8 u8Pages_of_list_) {
    set_has_u8Pages_of_list();
    this->_u8Pages_of_list = u8Pages_of_list_;
}

inline void T_TCU_Charge_Spot_List::clearU8Station_List_Number() {
    if (hasU8Station_List_Number()) {
         clear_has_u8Station_List_Number();
        _u8Station_List_Number = 0u;
     }
}

inline bool T_TCU_Charge_Spot_List::hasU8Station_List_Number () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 T_TCU_Charge_Spot_List::getU8Station_List_Number () const {
    return _u8Station_List_Number;
}

inline void T_TCU_Charge_Spot_List::setU8Station_List_Number (uint8 u8Station_List_Number_) {
    set_has_u8Station_List_Number();
    this->_u8Station_List_Number = u8Station_List_Number_;
}

inline void T_TCU_Charge_Spot_List::clearRSpot_List1() {
    if (hasRSpot_List1()) {
         clear_has_rSpot_List1();
        _rSpot_List1.clear();
     }
}

inline bool T_TCU_Charge_Spot_List::hasRSpot_List1 () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const T_TCU_Spot_List& T_TCU_Charge_Spot_List::getRSpot_List1 () const {
    return _rSpot_List1;
}

inline T_TCU_Spot_List& T_TCU_Charge_Spot_List::getRSpot_List1Mutable () {
    set_has_rSpot_List1();
    return _rSpot_List1;
}

inline void T_TCU_Charge_Spot_List::setRSpot_List1 (const T_TCU_Spot_List& rSpot_List1_) {
    set_has_rSpot_List1();
    this->_rSpot_List1 = rSpot_List1_;
}

inline void T_TCU_Charge_Spot_List::clearRSpot_List2() {
    if (hasRSpot_List2()) {
         clear_has_rSpot_List2();
        _rSpot_List2.clear();
     }
}

inline bool T_TCU_Charge_Spot_List::hasRSpot_List2 () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const T_TCU_Spot_List& T_TCU_Charge_Spot_List::getRSpot_List2 () const {
    return _rSpot_List2;
}

inline T_TCU_Spot_List& T_TCU_Charge_Spot_List::getRSpot_List2Mutable () {
    set_has_rSpot_List2();
    return _rSpot_List2;
}

inline void T_TCU_Charge_Spot_List::setRSpot_List2 (const T_TCU_Spot_List& rSpot_List2_) {
    set_has_rSpot_List2();
    this->_rSpot_List2 = rSpot_List2_;
}

inline void T_TCU_Charge_Spot_List::clearRSpot_List3() {
    if (hasRSpot_List3()) {
         clear_has_rSpot_List3();
        _rSpot_List3.clear();
     }
}

inline bool T_TCU_Charge_Spot_List::hasRSpot_List3 () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const T_TCU_Spot_List& T_TCU_Charge_Spot_List::getRSpot_List3 () const {
    return _rSpot_List3;
}

inline T_TCU_Spot_List& T_TCU_Charge_Spot_List::getRSpot_List3Mutable () {
    set_has_rSpot_List3();
    return _rSpot_List3;
}

inline void T_TCU_Charge_Spot_List::setRSpot_List3 (const T_TCU_Spot_List& rSpot_List3_) {
    set_has_rSpot_List3();
    this->_rSpot_List3 = rSpot_List3_;
}

inline void T_TCU_Charge_Spot_List::clearRSpot_List4() {
    if (hasRSpot_List4()) {
         clear_has_rSpot_List4();
        _rSpot_List4.clear();
     }
}

inline bool T_TCU_Charge_Spot_List::hasRSpot_List4 () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline const T_TCU_Spot_List& T_TCU_Charge_Spot_List::getRSpot_List4 () const {
    return _rSpot_List4;
}

inline T_TCU_Spot_List& T_TCU_Charge_Spot_List::getRSpot_List4Mutable () {
    set_has_rSpot_List4();
    return _rSpot_List4;
}

inline void T_TCU_Charge_Spot_List::setRSpot_List4 (const T_TCU_Spot_List& rSpot_List4_) {
    set_has_rSpot_List4();
    this->_rSpot_List4 = rSpot_List4_;
}

inline void T_TCU_Charge_Spot_List::set_has_u8Total_pages_of_lists () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TCU_Charge_Spot_List::clear_has_u8Total_pages_of_lists () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TCU_Charge_Spot_List::set_has_u8Pages_of_list () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TCU_Charge_Spot_List::clear_has_u8Pages_of_list () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_TCU_Charge_Spot_List::set_has_u8Station_List_Number () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_TCU_Charge_Spot_List::clear_has_u8Station_List_Number () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_TCU_Charge_Spot_List::set_has_rSpot_List1 () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_TCU_Charge_Spot_List::clear_has_rSpot_List1 () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_TCU_Charge_Spot_List::set_has_rSpot_List2 () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_TCU_Charge_Spot_List::clear_has_rSpot_List2 () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_TCU_Charge_Spot_List::set_has_rSpot_List3 () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_TCU_Charge_Spot_List::clear_has_rSpot_List3 () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_TCU_Charge_Spot_List::set_has_rSpot_List4 () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_TCU_Charge_Spot_List::clear_has_rSpot_List4 () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline  T_TCU_Time::T_TCU_Time ()  :
    _u8Hour (0u),
    _u8Minute (0u),
    _u8Seconds (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TCU_Time::T_TCU_Time (const T_TCU_Time &rhs)  :
    _u8Hour (0u),
    _u8Minute (0u),
    _u8Seconds (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TCU_Time::T_TCU_Time (uint8 u8Hour_, uint8 u8Minute_, uint8 u8Seconds_)  :
    _u8Hour (u8Hour_),
    _u8Minute (u8Minute_),
    _u8Seconds (u8Seconds_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TCU_Time::~T_TCU_Time() {
}

inline T_TCU_Time& T_TCU_Time::operator = (const T_TCU_Time& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8Hour()) {
            setU8Hour(rhs.getU8Hour());
        } else {
            clearU8Hour();
        }
        if (rhs.hasU8Minute()) {
            setU8Minute(rhs.getU8Minute());
        } else {
            clearU8Minute();
        }
        if (rhs.hasU8Seconds()) {
            setU8Seconds(rhs.getU8Seconds());
        } else {
            clearU8Seconds();
        }
    }
    return *this;
}

inline bool T_TCU_Time::operator == (const T_TCU_Time& rhs) const {
    return (((!hasU8Hour() && !rhs.hasU8Hour()) || getU8Hour() == rhs.getU8Hour()) &&
        ((!hasU8Minute() && !rhs.hasU8Minute()) || getU8Minute() == rhs.getU8Minute()) &&
        ((!hasU8Seconds() && !rhs.hasU8Seconds()) || getU8Seconds() == rhs.getU8Seconds()));
}

inline bool T_TCU_Time::operator != (const T_TCU_Time& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TCU_Time::operator < (const T_TCU_Time& rhs) const {
    if (hasU8Hour() || rhs.hasU8Hour()) {
        if (getU8Hour() < rhs.getU8Hour()) return true;
        if (getU8Hour() > rhs.getU8Hour()) return false;
    }
    if (hasU8Minute() || rhs.hasU8Minute()) {
        if (getU8Minute() < rhs.getU8Minute()) return true;
        if (getU8Minute() > rhs.getU8Minute()) return false;
    }
    if (hasU8Seconds() || rhs.hasU8Seconds()) {
        if (getU8Seconds() < rhs.getU8Seconds()) return true;
        if (getU8Seconds() > rhs.getU8Seconds()) return false;
    }
    return false;
}

inline bool T_TCU_Time::operator > (const T_TCU_Time& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TCU_Time::clear() {
    clearU8Hour();
    clearU8Minute();
    clearU8Seconds();
}

inline void T_TCU_Time::clearU8Hour() {
    if (hasU8Hour()) {
         clear_has_u8Hour();
        _u8Hour = 0u;
     }
}

inline bool T_TCU_Time::hasU8Hour () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_TCU_Time::getU8Hour () const {
    return _u8Hour;
}

inline void T_TCU_Time::setU8Hour (uint8 u8Hour_) {
    set_has_u8Hour();
    this->_u8Hour = u8Hour_;
}

inline void T_TCU_Time::clearU8Minute() {
    if (hasU8Minute()) {
         clear_has_u8Minute();
        _u8Minute = 0u;
     }
}

inline bool T_TCU_Time::hasU8Minute () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_TCU_Time::getU8Minute () const {
    return _u8Minute;
}

inline void T_TCU_Time::setU8Minute (uint8 u8Minute_) {
    set_has_u8Minute();
    this->_u8Minute = u8Minute_;
}

inline void T_TCU_Time::clearU8Seconds() {
    if (hasU8Seconds()) {
         clear_has_u8Seconds();
        _u8Seconds = 0u;
     }
}

inline bool T_TCU_Time::hasU8Seconds () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 T_TCU_Time::getU8Seconds () const {
    return _u8Seconds;
}

inline void T_TCU_Time::setU8Seconds (uint8 u8Seconds_) {
    set_has_u8Seconds();
    this->_u8Seconds = u8Seconds_;
}

inline void T_TCU_Time::set_has_u8Hour () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TCU_Time::clear_has_u8Hour () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TCU_Time::set_has_u8Minute () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TCU_Time::clear_has_u8Minute () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_TCU_Time::set_has_u8Seconds () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_TCU_Time::clear_has_u8Seconds () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_TCU_Navigation_Language::T_TCU_Navigation_Language ()  :
    _u8Reserved (0u),
    _e8Language_Family_Type (::tcu_main_fi_types::T_e8_Language_Family_Type__Family_type_1),
    _e8Language_Type (::tcu_main_fi_types::T_e8_Language_Type__Default)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TCU_Navigation_Language::T_TCU_Navigation_Language (const T_TCU_Navigation_Language &rhs)  :
    _u8Reserved (0u),
    _e8Language_Family_Type (::tcu_main_fi_types::T_e8_Language_Family_Type__Family_type_1),
    _e8Language_Type (::tcu_main_fi_types::T_e8_Language_Type__Default)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TCU_Navigation_Language::T_TCU_Navigation_Language (uint8 u8Reserved_, T_e8_Language_Family_Type e8Language_Family_Type_, T_e8_Language_Type e8Language_Type_)  :
    _u8Reserved (u8Reserved_),
    _e8Language_Family_Type (e8Language_Family_Type_),
    _e8Language_Type (e8Language_Type_)
{
    #ifndef NDEBUG
    if (!(T_e8_Language_Family_Type_IsValid(e8Language_Family_Type_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Language_Family_Type_, "T_e8_Language_Family_Type", "e8Language_Family_Type", "T_TCU_Navigation_Language");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_Language_Type_IsValid(e8Language_Type_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Language_Type_, "T_e8_Language_Type", "e8Language_Type", "T_TCU_Navigation_Language");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TCU_Navigation_Language::~T_TCU_Navigation_Language() {
}

inline T_TCU_Navigation_Language& T_TCU_Navigation_Language::operator = (const T_TCU_Navigation_Language& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8Reserved()) {
            setU8Reserved(rhs.getU8Reserved());
        } else {
            clearU8Reserved();
        }
        if (rhs.hasE8Language_Family_Type()) {
            setE8Language_Family_Type(rhs.getE8Language_Family_Type());
        } else {
            clearE8Language_Family_Type();
        }
        if (rhs.hasE8Language_Type()) {
            setE8Language_Type(rhs.getE8Language_Type());
        } else {
            clearE8Language_Type();
        }
    }
    return *this;
}

inline bool T_TCU_Navigation_Language::operator == (const T_TCU_Navigation_Language& rhs) const {
    return (((!hasU8Reserved() && !rhs.hasU8Reserved()) || getU8Reserved() == rhs.getU8Reserved()) &&
        ((!hasE8Language_Family_Type() && !rhs.hasE8Language_Family_Type()) || getE8Language_Family_Type() == rhs.getE8Language_Family_Type()) &&
        ((!hasE8Language_Type() && !rhs.hasE8Language_Type()) || getE8Language_Type() == rhs.getE8Language_Type()));
}

inline bool T_TCU_Navigation_Language::operator != (const T_TCU_Navigation_Language& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TCU_Navigation_Language::operator < (const T_TCU_Navigation_Language& rhs) const {
    if (hasU8Reserved() || rhs.hasU8Reserved()) {
        if (getU8Reserved() < rhs.getU8Reserved()) return true;
        if (getU8Reserved() > rhs.getU8Reserved()) return false;
    }
    if (hasE8Language_Family_Type() || rhs.hasE8Language_Family_Type()) {
        if ((uint32)getE8Language_Family_Type() < (uint32)rhs.getE8Language_Family_Type()) return true;
        if ((uint32)getE8Language_Family_Type() > (uint32)rhs.getE8Language_Family_Type()) return false;
    }
    if (hasE8Language_Type() || rhs.hasE8Language_Type()) {
        if ((uint32)getE8Language_Type() < (uint32)rhs.getE8Language_Type()) return true;
        if ((uint32)getE8Language_Type() > (uint32)rhs.getE8Language_Type()) return false;
    }
    return false;
}

inline bool T_TCU_Navigation_Language::operator > (const T_TCU_Navigation_Language& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TCU_Navigation_Language::clear() {
    clearU8Reserved();
    clearE8Language_Family_Type();
    clearE8Language_Type();
}

inline void T_TCU_Navigation_Language::clearU8Reserved() {
    if (hasU8Reserved()) {
         clear_has_u8Reserved();
        _u8Reserved = 0u;
     }
}

inline bool T_TCU_Navigation_Language::hasU8Reserved () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_TCU_Navigation_Language::getU8Reserved () const {
    return _u8Reserved;
}

inline void T_TCU_Navigation_Language::setU8Reserved (uint8 u8Reserved_) {
    set_has_u8Reserved();
    this->_u8Reserved = u8Reserved_;
}

inline void T_TCU_Navigation_Language::clearE8Language_Family_Type() {
    if (hasE8Language_Family_Type()) {
         clear_has_e8Language_Family_Type();
        _e8Language_Family_Type = ::tcu_main_fi_types::T_e8_Language_Family_Type__Family_type_1;
     }
}

inline bool T_TCU_Navigation_Language::hasE8Language_Family_Type () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_Language_Family_Type T_TCU_Navigation_Language::getE8Language_Family_Type () const {
    return _e8Language_Family_Type;
}

inline void T_TCU_Navigation_Language::setE8Language_Family_Type (T_e8_Language_Family_Type e8Language_Family_Type_) {
    #ifndef NDEBUG
    if (!(T_e8_Language_Family_Type_IsValid(e8Language_Family_Type_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Language_Family_Type_, "T_e8_Language_Family_Type", "e8Language_Family_Type", "T_TCU_Navigation_Language");
    }
    #endif
    set_has_e8Language_Family_Type();
    this->_e8Language_Family_Type = e8Language_Family_Type_;
}

inline void T_TCU_Navigation_Language::clearE8Language_Type() {
    if (hasE8Language_Type()) {
         clear_has_e8Language_Type();
        _e8Language_Type = ::tcu_main_fi_types::T_e8_Language_Type__Default;
     }
}

inline bool T_TCU_Navigation_Language::hasE8Language_Type () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_Language_Type T_TCU_Navigation_Language::getE8Language_Type () const {
    return _e8Language_Type;
}

inline void T_TCU_Navigation_Language::setE8Language_Type (T_e8_Language_Type e8Language_Type_) {
    #ifndef NDEBUG
    if (!(T_e8_Language_Type_IsValid(e8Language_Type_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Language_Type_, "T_e8_Language_Type", "e8Language_Type", "T_TCU_Navigation_Language");
    }
    #endif
    set_has_e8Language_Type();
    this->_e8Language_Type = e8Language_Type_;
}

inline void T_TCU_Navigation_Language::set_has_u8Reserved () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TCU_Navigation_Language::clear_has_u8Reserved () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TCU_Navigation_Language::set_has_e8Language_Family_Type () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TCU_Navigation_Language::clear_has_e8Language_Family_Type () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_TCU_Navigation_Language::set_has_e8Language_Type () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_TCU_Navigation_Language::clear_has_e8Language_Type () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_TCU_Charge_Days::T_TCU_Charge_Days ()  :
    _Day1 (0u),
    _Day2 (0u),
    _Day3 (0u),
    _Day4 (0u),
    _Day5 (0u),
    _Day6 (0u),
    _Day7 (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TCU_Charge_Days::T_TCU_Charge_Days (const T_TCU_Charge_Days &rhs)  :
    _Day1 (0u),
    _Day2 (0u),
    _Day3 (0u),
    _Day4 (0u),
    _Day5 (0u),
    _Day6 (0u),
    _Day7 (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TCU_Charge_Days::T_TCU_Charge_Days (uint8 Day1_, uint8 Day2_, uint8 Day3_, uint8 Day4_, uint8 Day5_, uint8 Day6_, uint8 Day7_)  :
    _Day1 (Day1_),
    _Day2 (Day2_),
    _Day3 (Day3_),
    _Day4 (Day4_),
    _Day5 (Day5_),
    _Day6 (Day6_),
    _Day7 (Day7_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TCU_Charge_Days::~T_TCU_Charge_Days() {
}

inline T_TCU_Charge_Days& T_TCU_Charge_Days::operator = (const T_TCU_Charge_Days& rhs) {
    if( this != &rhs ) {
        if (rhs.hasDay1()) {
            setDay1(rhs.getDay1());
        } else {
            clearDay1();
        }
        if (rhs.hasDay2()) {
            setDay2(rhs.getDay2());
        } else {
            clearDay2();
        }
        if (rhs.hasDay3()) {
            setDay3(rhs.getDay3());
        } else {
            clearDay3();
        }
        if (rhs.hasDay4()) {
            setDay4(rhs.getDay4());
        } else {
            clearDay4();
        }
        if (rhs.hasDay5()) {
            setDay5(rhs.getDay5());
        } else {
            clearDay5();
        }
        if (rhs.hasDay6()) {
            setDay6(rhs.getDay6());
        } else {
            clearDay6();
        }
        if (rhs.hasDay7()) {
            setDay7(rhs.getDay7());
        } else {
            clearDay7();
        }
    }
    return *this;
}

inline bool T_TCU_Charge_Days::operator == (const T_TCU_Charge_Days& rhs) const {
    return (((!hasDay1() && !rhs.hasDay1()) || getDay1() == rhs.getDay1()) &&
        ((!hasDay2() && !rhs.hasDay2()) || getDay2() == rhs.getDay2()) &&
        ((!hasDay3() && !rhs.hasDay3()) || getDay3() == rhs.getDay3()) &&
        ((!hasDay4() && !rhs.hasDay4()) || getDay4() == rhs.getDay4()) &&
        ((!hasDay5() && !rhs.hasDay5()) || getDay5() == rhs.getDay5()) &&
        ((!hasDay6() && !rhs.hasDay6()) || getDay6() == rhs.getDay6()) &&
        ((!hasDay7() && !rhs.hasDay7()) || getDay7() == rhs.getDay7()));
}

inline bool T_TCU_Charge_Days::operator != (const T_TCU_Charge_Days& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TCU_Charge_Days::operator < (const T_TCU_Charge_Days& rhs) const {
    if (hasDay1() || rhs.hasDay1()) {
        if (getDay1() < rhs.getDay1()) return true;
        if (getDay1() > rhs.getDay1()) return false;
    }
    if (hasDay2() || rhs.hasDay2()) {
        if (getDay2() < rhs.getDay2()) return true;
        if (getDay2() > rhs.getDay2()) return false;
    }
    if (hasDay3() || rhs.hasDay3()) {
        if (getDay3() < rhs.getDay3()) return true;
        if (getDay3() > rhs.getDay3()) return false;
    }
    if (hasDay4() || rhs.hasDay4()) {
        if (getDay4() < rhs.getDay4()) return true;
        if (getDay4() > rhs.getDay4()) return false;
    }
    if (hasDay5() || rhs.hasDay5()) {
        if (getDay5() < rhs.getDay5()) return true;
        if (getDay5() > rhs.getDay5()) return false;
    }
    if (hasDay6() || rhs.hasDay6()) {
        if (getDay6() < rhs.getDay6()) return true;
        if (getDay6() > rhs.getDay6()) return false;
    }
    if (hasDay7() || rhs.hasDay7()) {
        if (getDay7() < rhs.getDay7()) return true;
        if (getDay7() > rhs.getDay7()) return false;
    }
    return false;
}

inline bool T_TCU_Charge_Days::operator > (const T_TCU_Charge_Days& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TCU_Charge_Days::clear() {
    clearDay1();
    clearDay2();
    clearDay3();
    clearDay4();
    clearDay5();
    clearDay6();
    clearDay7();
}

inline void T_TCU_Charge_Days::clearDay1() {
    if (hasDay1()) {
         clear_has_Day1();
        _Day1 = 0u;
     }
}

inline bool T_TCU_Charge_Days::hasDay1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_TCU_Charge_Days::getDay1 () const {
    return _Day1;
}

inline void T_TCU_Charge_Days::setDay1 (uint8 Day1_) {
    set_has_Day1();
    this->_Day1 = Day1_;
}

inline void T_TCU_Charge_Days::clearDay2() {
    if (hasDay2()) {
         clear_has_Day2();
        _Day2 = 0u;
     }
}

inline bool T_TCU_Charge_Days::hasDay2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_TCU_Charge_Days::getDay2 () const {
    return _Day2;
}

inline void T_TCU_Charge_Days::setDay2 (uint8 Day2_) {
    set_has_Day2();
    this->_Day2 = Day2_;
}

inline void T_TCU_Charge_Days::clearDay3() {
    if (hasDay3()) {
         clear_has_Day3();
        _Day3 = 0u;
     }
}

inline bool T_TCU_Charge_Days::hasDay3 () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 T_TCU_Charge_Days::getDay3 () const {
    return _Day3;
}

inline void T_TCU_Charge_Days::setDay3 (uint8 Day3_) {
    set_has_Day3();
    this->_Day3 = Day3_;
}

inline void T_TCU_Charge_Days::clearDay4() {
    if (hasDay4()) {
         clear_has_Day4();
        _Day4 = 0u;
     }
}

inline bool T_TCU_Charge_Days::hasDay4 () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 T_TCU_Charge_Days::getDay4 () const {
    return _Day4;
}

inline void T_TCU_Charge_Days::setDay4 (uint8 Day4_) {
    set_has_Day4();
    this->_Day4 = Day4_;
}

inline void T_TCU_Charge_Days::clearDay5() {
    if (hasDay5()) {
         clear_has_Day5();
        _Day5 = 0u;
     }
}

inline bool T_TCU_Charge_Days::hasDay5 () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 T_TCU_Charge_Days::getDay5 () const {
    return _Day5;
}

inline void T_TCU_Charge_Days::setDay5 (uint8 Day5_) {
    set_has_Day5();
    this->_Day5 = Day5_;
}

inline void T_TCU_Charge_Days::clearDay6() {
    if (hasDay6()) {
         clear_has_Day6();
        _Day6 = 0u;
     }
}

inline bool T_TCU_Charge_Days::hasDay6 () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint8 T_TCU_Charge_Days::getDay6 () const {
    return _Day6;
}

inline void T_TCU_Charge_Days::setDay6 (uint8 Day6_) {
    set_has_Day6();
    this->_Day6 = Day6_;
}

inline void T_TCU_Charge_Days::clearDay7() {
    if (hasDay7()) {
         clear_has_Day7();
        _Day7 = 0u;
     }
}

inline bool T_TCU_Charge_Days::hasDay7 () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint8 T_TCU_Charge_Days::getDay7 () const {
    return _Day7;
}

inline void T_TCU_Charge_Days::setDay7 (uint8 Day7_) {
    set_has_Day7();
    this->_Day7 = Day7_;
}

inline void T_TCU_Charge_Days::set_has_Day1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TCU_Charge_Days::clear_has_Day1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TCU_Charge_Days::set_has_Day2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TCU_Charge_Days::clear_has_Day2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_TCU_Charge_Days::set_has_Day3 () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_TCU_Charge_Days::clear_has_Day3 () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_TCU_Charge_Days::set_has_Day4 () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_TCU_Charge_Days::clear_has_Day4 () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_TCU_Charge_Days::set_has_Day5 () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_TCU_Charge_Days::clear_has_Day5 () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_TCU_Charge_Days::set_has_Day6 () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_TCU_Charge_Days::clear_has_Day6 () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_TCU_Charge_Days::set_has_Day7 () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_TCU_Charge_Days::clear_has_Day7 () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline  T_TCU_Spot_Receptacle_Type::T_TCU_Spot_Receptacle_Type ()  :
    _rDefault_receptacle_type (::tcu_main_fi_types::T_e8_TCU_Charge_Receptacle_Type__Small_Paddle),
    _rUser_receptacle_type_1 (::tcu_main_fi_types::T_e8_TCU_Charge_Receptacle_Type__Small_Paddle),
    _rUser_receptacle_type_2 (::tcu_main_fi_types::T_e8_TCU_Charge_Receptacle_Type__Small_Paddle),
    _rUser_receptacle_type_3 (::tcu_main_fi_types::T_e8_TCU_Charge_Receptacle_Type__Small_Paddle),
    _u8Reserved1 (0u),
    _u8Reserved2 (0u),
    _u8Reserved3 (0u),
    _u8Reserved4 (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TCU_Spot_Receptacle_Type::T_TCU_Spot_Receptacle_Type (const T_TCU_Spot_Receptacle_Type &rhs)  :
    _rDefault_receptacle_type (::tcu_main_fi_types::T_e8_TCU_Charge_Receptacle_Type__Small_Paddle),
    _rUser_receptacle_type_1 (::tcu_main_fi_types::T_e8_TCU_Charge_Receptacle_Type__Small_Paddle),
    _rUser_receptacle_type_2 (::tcu_main_fi_types::T_e8_TCU_Charge_Receptacle_Type__Small_Paddle),
    _rUser_receptacle_type_3 (::tcu_main_fi_types::T_e8_TCU_Charge_Receptacle_Type__Small_Paddle),
    _u8Reserved1 (0u),
    _u8Reserved2 (0u),
    _u8Reserved3 (0u),
    _u8Reserved4 (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TCU_Spot_Receptacle_Type::T_TCU_Spot_Receptacle_Type (T_e8_TCU_Charge_Receptacle_Type rDefault_receptacle_type_, T_e8_TCU_Charge_Receptacle_Type rUser_receptacle_type_1_, T_e8_TCU_Charge_Receptacle_Type rUser_receptacle_type_2_, T_e8_TCU_Charge_Receptacle_Type rUser_receptacle_type_3_, uint8 u8Reserved1_, uint8 u8Reserved2_, uint8 u8Reserved3_, uint8 u8Reserved4_)  :
    _rDefault_receptacle_type (rDefault_receptacle_type_),
    _rUser_receptacle_type_1 (rUser_receptacle_type_1_),
    _rUser_receptacle_type_2 (rUser_receptacle_type_2_),
    _rUser_receptacle_type_3 (rUser_receptacle_type_3_),
    _u8Reserved1 (u8Reserved1_),
    _u8Reserved2 (u8Reserved2_),
    _u8Reserved3 (u8Reserved3_),
    _u8Reserved4 (u8Reserved4_)
{
    #ifndef NDEBUG
    if (!(T_e8_TCU_Charge_Receptacle_Type_IsValid(rDefault_receptacle_type_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", rDefault_receptacle_type_, "T_e8_TCU_Charge_Receptacle_Type", "rDefault_receptacle_type", "T_TCU_Spot_Receptacle_Type");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_TCU_Charge_Receptacle_Type_IsValid(rUser_receptacle_type_1_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", rUser_receptacle_type_1_, "T_e8_TCU_Charge_Receptacle_Type", "rUser_receptacle_type_1", "T_TCU_Spot_Receptacle_Type");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_TCU_Charge_Receptacle_Type_IsValid(rUser_receptacle_type_2_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", rUser_receptacle_type_2_, "T_e8_TCU_Charge_Receptacle_Type", "rUser_receptacle_type_2", "T_TCU_Spot_Receptacle_Type");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_TCU_Charge_Receptacle_Type_IsValid(rUser_receptacle_type_3_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", rUser_receptacle_type_3_, "T_e8_TCU_Charge_Receptacle_Type", "rUser_receptacle_type_3", "T_TCU_Spot_Receptacle_Type");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TCU_Spot_Receptacle_Type::~T_TCU_Spot_Receptacle_Type() {
}

inline T_TCU_Spot_Receptacle_Type& T_TCU_Spot_Receptacle_Type::operator = (const T_TCU_Spot_Receptacle_Type& rhs) {
    if( this != &rhs ) {
        if (rhs.hasRDefault_receptacle_type()) {
            setRDefault_receptacle_type(rhs.getRDefault_receptacle_type());
        } else {
            clearRDefault_receptacle_type();
        }
        if (rhs.hasRUser_receptacle_type_1()) {
            setRUser_receptacle_type_1(rhs.getRUser_receptacle_type_1());
        } else {
            clearRUser_receptacle_type_1();
        }
        if (rhs.hasRUser_receptacle_type_2()) {
            setRUser_receptacle_type_2(rhs.getRUser_receptacle_type_2());
        } else {
            clearRUser_receptacle_type_2();
        }
        if (rhs.hasRUser_receptacle_type_3()) {
            setRUser_receptacle_type_3(rhs.getRUser_receptacle_type_3());
        } else {
            clearRUser_receptacle_type_3();
        }
        if (rhs.hasU8Reserved1()) {
            setU8Reserved1(rhs.getU8Reserved1());
        } else {
            clearU8Reserved1();
        }
        if (rhs.hasU8Reserved2()) {
            setU8Reserved2(rhs.getU8Reserved2());
        } else {
            clearU8Reserved2();
        }
        if (rhs.hasU8Reserved3()) {
            setU8Reserved3(rhs.getU8Reserved3());
        } else {
            clearU8Reserved3();
        }
        if (rhs.hasU8Reserved4()) {
            setU8Reserved4(rhs.getU8Reserved4());
        } else {
            clearU8Reserved4();
        }
    }
    return *this;
}

inline bool T_TCU_Spot_Receptacle_Type::operator == (const T_TCU_Spot_Receptacle_Type& rhs) const {
    return (((!hasRDefault_receptacle_type() && !rhs.hasRDefault_receptacle_type()) || getRDefault_receptacle_type() == rhs.getRDefault_receptacle_type()) &&
        ((!hasRUser_receptacle_type_1() && !rhs.hasRUser_receptacle_type_1()) || getRUser_receptacle_type_1() == rhs.getRUser_receptacle_type_1()) &&
        ((!hasRUser_receptacle_type_2() && !rhs.hasRUser_receptacle_type_2()) || getRUser_receptacle_type_2() == rhs.getRUser_receptacle_type_2()) &&
        ((!hasRUser_receptacle_type_3() && !rhs.hasRUser_receptacle_type_3()) || getRUser_receptacle_type_3() == rhs.getRUser_receptacle_type_3()) &&
        ((!hasU8Reserved1() && !rhs.hasU8Reserved1()) || getU8Reserved1() == rhs.getU8Reserved1()) &&
        ((!hasU8Reserved2() && !rhs.hasU8Reserved2()) || getU8Reserved2() == rhs.getU8Reserved2()) &&
        ((!hasU8Reserved3() && !rhs.hasU8Reserved3()) || getU8Reserved3() == rhs.getU8Reserved3()) &&
        ((!hasU8Reserved4() && !rhs.hasU8Reserved4()) || getU8Reserved4() == rhs.getU8Reserved4()));
}

inline bool T_TCU_Spot_Receptacle_Type::operator != (const T_TCU_Spot_Receptacle_Type& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TCU_Spot_Receptacle_Type::operator < (const T_TCU_Spot_Receptacle_Type& rhs) const {
    if (hasRDefault_receptacle_type() || rhs.hasRDefault_receptacle_type()) {
        if ((uint32)getRDefault_receptacle_type() < (uint32)rhs.getRDefault_receptacle_type()) return true;
        if ((uint32)getRDefault_receptacle_type() > (uint32)rhs.getRDefault_receptacle_type()) return false;
    }
    if (hasRUser_receptacle_type_1() || rhs.hasRUser_receptacle_type_1()) {
        if ((uint32)getRUser_receptacle_type_1() < (uint32)rhs.getRUser_receptacle_type_1()) return true;
        if ((uint32)getRUser_receptacle_type_1() > (uint32)rhs.getRUser_receptacle_type_1()) return false;
    }
    if (hasRUser_receptacle_type_2() || rhs.hasRUser_receptacle_type_2()) {
        if ((uint32)getRUser_receptacle_type_2() < (uint32)rhs.getRUser_receptacle_type_2()) return true;
        if ((uint32)getRUser_receptacle_type_2() > (uint32)rhs.getRUser_receptacle_type_2()) return false;
    }
    if (hasRUser_receptacle_type_3() || rhs.hasRUser_receptacle_type_3()) {
        if ((uint32)getRUser_receptacle_type_3() < (uint32)rhs.getRUser_receptacle_type_3()) return true;
        if ((uint32)getRUser_receptacle_type_3() > (uint32)rhs.getRUser_receptacle_type_3()) return false;
    }
    if (hasU8Reserved1() || rhs.hasU8Reserved1()) {
        if (getU8Reserved1() < rhs.getU8Reserved1()) return true;
        if (getU8Reserved1() > rhs.getU8Reserved1()) return false;
    }
    if (hasU8Reserved2() || rhs.hasU8Reserved2()) {
        if (getU8Reserved2() < rhs.getU8Reserved2()) return true;
        if (getU8Reserved2() > rhs.getU8Reserved2()) return false;
    }
    if (hasU8Reserved3() || rhs.hasU8Reserved3()) {
        if (getU8Reserved3() < rhs.getU8Reserved3()) return true;
        if (getU8Reserved3() > rhs.getU8Reserved3()) return false;
    }
    if (hasU8Reserved4() || rhs.hasU8Reserved4()) {
        if (getU8Reserved4() < rhs.getU8Reserved4()) return true;
        if (getU8Reserved4() > rhs.getU8Reserved4()) return false;
    }
    return false;
}

inline bool T_TCU_Spot_Receptacle_Type::operator > (const T_TCU_Spot_Receptacle_Type& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TCU_Spot_Receptacle_Type::clear() {
    clearRDefault_receptacle_type();
    clearRUser_receptacle_type_1();
    clearRUser_receptacle_type_2();
    clearRUser_receptacle_type_3();
    clearU8Reserved1();
    clearU8Reserved2();
    clearU8Reserved3();
    clearU8Reserved4();
}

inline void T_TCU_Spot_Receptacle_Type::clearRDefault_receptacle_type() {
    if (hasRDefault_receptacle_type()) {
         clear_has_rDefault_receptacle_type();
        _rDefault_receptacle_type = ::tcu_main_fi_types::T_e8_TCU_Charge_Receptacle_Type__Small_Paddle;
     }
}

inline bool T_TCU_Spot_Receptacle_Type::hasRDefault_receptacle_type () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_TCU_Charge_Receptacle_Type T_TCU_Spot_Receptacle_Type::getRDefault_receptacle_type () const {
    return _rDefault_receptacle_type;
}

inline void T_TCU_Spot_Receptacle_Type::setRDefault_receptacle_type (T_e8_TCU_Charge_Receptacle_Type rDefault_receptacle_type_) {
    #ifndef NDEBUG
    if (!(T_e8_TCU_Charge_Receptacle_Type_IsValid(rDefault_receptacle_type_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", rDefault_receptacle_type_, "T_e8_TCU_Charge_Receptacle_Type", "rDefault_receptacle_type", "T_TCU_Spot_Receptacle_Type");
    }
    #endif
    set_has_rDefault_receptacle_type();
    this->_rDefault_receptacle_type = rDefault_receptacle_type_;
}

inline void T_TCU_Spot_Receptacle_Type::clearRUser_receptacle_type_1() {
    if (hasRUser_receptacle_type_1()) {
         clear_has_rUser_receptacle_type_1();
        _rUser_receptacle_type_1 = ::tcu_main_fi_types::T_e8_TCU_Charge_Receptacle_Type__Small_Paddle;
     }
}

inline bool T_TCU_Spot_Receptacle_Type::hasRUser_receptacle_type_1 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_TCU_Charge_Receptacle_Type T_TCU_Spot_Receptacle_Type::getRUser_receptacle_type_1 () const {
    return _rUser_receptacle_type_1;
}

inline void T_TCU_Spot_Receptacle_Type::setRUser_receptacle_type_1 (T_e8_TCU_Charge_Receptacle_Type rUser_receptacle_type_1_) {
    #ifndef NDEBUG
    if (!(T_e8_TCU_Charge_Receptacle_Type_IsValid(rUser_receptacle_type_1_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", rUser_receptacle_type_1_, "T_e8_TCU_Charge_Receptacle_Type", "rUser_receptacle_type_1", "T_TCU_Spot_Receptacle_Type");
    }
    #endif
    set_has_rUser_receptacle_type_1();
    this->_rUser_receptacle_type_1 = rUser_receptacle_type_1_;
}

inline void T_TCU_Spot_Receptacle_Type::clearRUser_receptacle_type_2() {
    if (hasRUser_receptacle_type_2()) {
         clear_has_rUser_receptacle_type_2();
        _rUser_receptacle_type_2 = ::tcu_main_fi_types::T_e8_TCU_Charge_Receptacle_Type__Small_Paddle;
     }
}

inline bool T_TCU_Spot_Receptacle_Type::hasRUser_receptacle_type_2 () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_TCU_Charge_Receptacle_Type T_TCU_Spot_Receptacle_Type::getRUser_receptacle_type_2 () const {
    return _rUser_receptacle_type_2;
}

inline void T_TCU_Spot_Receptacle_Type::setRUser_receptacle_type_2 (T_e8_TCU_Charge_Receptacle_Type rUser_receptacle_type_2_) {
    #ifndef NDEBUG
    if (!(T_e8_TCU_Charge_Receptacle_Type_IsValid(rUser_receptacle_type_2_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", rUser_receptacle_type_2_, "T_e8_TCU_Charge_Receptacle_Type", "rUser_receptacle_type_2", "T_TCU_Spot_Receptacle_Type");
    }
    #endif
    set_has_rUser_receptacle_type_2();
    this->_rUser_receptacle_type_2 = rUser_receptacle_type_2_;
}

inline void T_TCU_Spot_Receptacle_Type::clearRUser_receptacle_type_3() {
    if (hasRUser_receptacle_type_3()) {
         clear_has_rUser_receptacle_type_3();
        _rUser_receptacle_type_3 = ::tcu_main_fi_types::T_e8_TCU_Charge_Receptacle_Type__Small_Paddle;
     }
}

inline bool T_TCU_Spot_Receptacle_Type::hasRUser_receptacle_type_3 () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline T_e8_TCU_Charge_Receptacle_Type T_TCU_Spot_Receptacle_Type::getRUser_receptacle_type_3 () const {
    return _rUser_receptacle_type_3;
}

inline void T_TCU_Spot_Receptacle_Type::setRUser_receptacle_type_3 (T_e8_TCU_Charge_Receptacle_Type rUser_receptacle_type_3_) {
    #ifndef NDEBUG
    if (!(T_e8_TCU_Charge_Receptacle_Type_IsValid(rUser_receptacle_type_3_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", rUser_receptacle_type_3_, "T_e8_TCU_Charge_Receptacle_Type", "rUser_receptacle_type_3", "T_TCU_Spot_Receptacle_Type");
    }
    #endif
    set_has_rUser_receptacle_type_3();
    this->_rUser_receptacle_type_3 = rUser_receptacle_type_3_;
}

inline void T_TCU_Spot_Receptacle_Type::clearU8Reserved1() {
    if (hasU8Reserved1()) {
         clear_has_u8Reserved1();
        _u8Reserved1 = 0u;
     }
}

inline bool T_TCU_Spot_Receptacle_Type::hasU8Reserved1 () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 T_TCU_Spot_Receptacle_Type::getU8Reserved1 () const {
    return _u8Reserved1;
}

inline void T_TCU_Spot_Receptacle_Type::setU8Reserved1 (uint8 u8Reserved1_) {
    set_has_u8Reserved1();
    this->_u8Reserved1 = u8Reserved1_;
}

inline void T_TCU_Spot_Receptacle_Type::clearU8Reserved2() {
    if (hasU8Reserved2()) {
         clear_has_u8Reserved2();
        _u8Reserved2 = 0u;
     }
}

inline bool T_TCU_Spot_Receptacle_Type::hasU8Reserved2 () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint8 T_TCU_Spot_Receptacle_Type::getU8Reserved2 () const {
    return _u8Reserved2;
}

inline void T_TCU_Spot_Receptacle_Type::setU8Reserved2 (uint8 u8Reserved2_) {
    set_has_u8Reserved2();
    this->_u8Reserved2 = u8Reserved2_;
}

inline void T_TCU_Spot_Receptacle_Type::clearU8Reserved3() {
    if (hasU8Reserved3()) {
         clear_has_u8Reserved3();
        _u8Reserved3 = 0u;
     }
}

inline bool T_TCU_Spot_Receptacle_Type::hasU8Reserved3 () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint8 T_TCU_Spot_Receptacle_Type::getU8Reserved3 () const {
    return _u8Reserved3;
}

inline void T_TCU_Spot_Receptacle_Type::setU8Reserved3 (uint8 u8Reserved3_) {
    set_has_u8Reserved3();
    this->_u8Reserved3 = u8Reserved3_;
}

inline void T_TCU_Spot_Receptacle_Type::clearU8Reserved4() {
    if (hasU8Reserved4()) {
         clear_has_u8Reserved4();
        _u8Reserved4 = 0u;
     }
}

inline bool T_TCU_Spot_Receptacle_Type::hasU8Reserved4 () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline uint8 T_TCU_Spot_Receptacle_Type::getU8Reserved4 () const {
    return _u8Reserved4;
}

inline void T_TCU_Spot_Receptacle_Type::setU8Reserved4 (uint8 u8Reserved4_) {
    set_has_u8Reserved4();
    this->_u8Reserved4 = u8Reserved4_;
}

inline void T_TCU_Spot_Receptacle_Type::set_has_rDefault_receptacle_type () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TCU_Spot_Receptacle_Type::clear_has_rDefault_receptacle_type () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TCU_Spot_Receptacle_Type::set_has_rUser_receptacle_type_1 () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TCU_Spot_Receptacle_Type::clear_has_rUser_receptacle_type_1 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_TCU_Spot_Receptacle_Type::set_has_rUser_receptacle_type_2 () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_TCU_Spot_Receptacle_Type::clear_has_rUser_receptacle_type_2 () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_TCU_Spot_Receptacle_Type::set_has_rUser_receptacle_type_3 () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_TCU_Spot_Receptacle_Type::clear_has_rUser_receptacle_type_3 () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_TCU_Spot_Receptacle_Type::set_has_u8Reserved1 () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_TCU_Spot_Receptacle_Type::clear_has_u8Reserved1 () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_TCU_Spot_Receptacle_Type::set_has_u8Reserved2 () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_TCU_Spot_Receptacle_Type::clear_has_u8Reserved2 () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_TCU_Spot_Receptacle_Type::set_has_u8Reserved3 () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_TCU_Spot_Receptacle_Type::clear_has_u8Reserved3 () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_TCU_Spot_Receptacle_Type::set_has_u8Reserved4 () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_TCU_Spot_Receptacle_Type::clear_has_u8Reserved4 () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline  PIN_Data::PIN_Data ()  :
    _u8Length (0u),
    _sText ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PIN_Data::PIN_Data (const PIN_Data &rhs)  :
    _u8Length (0u),
    _sText ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PIN_Data::PIN_Data (uint8 u8Length_, const ::std::string& sText_)  :
    _u8Length (u8Length_),
    _sText (sText_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sText_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PIN_Data::~PIN_Data() {
}

inline PIN_Data& PIN_Data::operator = (const PIN_Data& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8Length()) {
            setU8Length(rhs.getU8Length());
        } else {
            clearU8Length();
        }
        if (rhs.hasSText()) {
            setSText(rhs.getSText());
        } else {
            clearSText();
        }
    }
    return *this;
}

inline bool PIN_Data::operator == (const PIN_Data& rhs) const {
    return (((!hasU8Length() && !rhs.hasU8Length()) || getU8Length() == rhs.getU8Length()) &&
        ((!hasSText() && !rhs.hasSText()) || getSText() == rhs.getSText()));
}

inline bool PIN_Data::operator != (const PIN_Data& rhs) const {
    return ! (*this == rhs);
}

inline bool PIN_Data::operator < (const PIN_Data& rhs) const {
    if (hasU8Length() || rhs.hasU8Length()) {
        if (getU8Length() < rhs.getU8Length()) return true;
        if (getU8Length() > rhs.getU8Length()) return false;
    }
    if (hasSText() || rhs.hasSText()) {
        if (getSText() < rhs.getSText()) return true;
        if (getSText() > rhs.getSText()) return false;
    }
    return false;
}

inline bool PIN_Data::operator > (const PIN_Data& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PIN_Data::clear() {
    clearU8Length();
    clearSText();
}

inline void PIN_Data::clearU8Length() {
    if (hasU8Length()) {
         clear_has_u8Length();
        _u8Length = 0u;
     }
}

inline bool PIN_Data::hasU8Length () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 PIN_Data::getU8Length () const {
    return _u8Length;
}

inline void PIN_Data::setU8Length (uint8 u8Length_) {
    set_has_u8Length();
    this->_u8Length = u8Length_;
}

inline void PIN_Data::clearSText() {
    if (hasSText()) {
         clear_has_sText();
        _sText.clear();
     }
}

inline bool PIN_Data::hasSText () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& PIN_Data::getSText () const {
    return _sText;
}

inline ::std::string& PIN_Data::getSTextMutable () {
    set_has_sText();
    return _sText;
}

inline void PIN_Data::setSText (const ::std::string& sText_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sText_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sText();
    this->_sText = sText_;
}

inline void PIN_Data::setSText (const char* sText_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sText_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sText();
    this->_sText.assign(sText_);
}

inline void PIN_Data::setSText (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sText();
    this->_sText.assign(value, size);
}

inline void PIN_Data::set_has_u8Length () {
    _has_bits_[0] |= 1u << 0;
}

inline void PIN_Data::clear_has_u8Length () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void PIN_Data::set_has_sText () {
    _has_bits_[0] |= 1u << 1;
}

inline void PIN_Data::clear_has_sText () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_TCU_PIN::T_TCU_PIN ()  :
    _rPIN_ID (),
    _rPIN_Password ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TCU_PIN::T_TCU_PIN (const T_TCU_PIN &rhs)  :
    _rPIN_ID (),
    _rPIN_Password ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TCU_PIN::T_TCU_PIN (const PIN_Data& rPIN_ID_, const PIN_Data& rPIN_Password_)  :
    _rPIN_ID (rPIN_ID_),
    _rPIN_Password (rPIN_Password_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TCU_PIN::~T_TCU_PIN() {
}

inline T_TCU_PIN& T_TCU_PIN::operator = (const T_TCU_PIN& rhs) {
    if( this != &rhs ) {
        if (rhs.hasRPIN_ID()) {
            setRPIN_ID(rhs.getRPIN_ID());
        } else {
            clearRPIN_ID();
        }
        if (rhs.hasRPIN_Password()) {
            setRPIN_Password(rhs.getRPIN_Password());
        } else {
            clearRPIN_Password();
        }
    }
    return *this;
}

inline bool T_TCU_PIN::operator == (const T_TCU_PIN& rhs) const {
    return (((!hasRPIN_ID() && !rhs.hasRPIN_ID()) || getRPIN_ID() == rhs.getRPIN_ID()) &&
        ((!hasRPIN_Password() && !rhs.hasRPIN_Password()) || getRPIN_Password() == rhs.getRPIN_Password()));
}

inline bool T_TCU_PIN::operator != (const T_TCU_PIN& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TCU_PIN::operator < (const T_TCU_PIN& rhs) const {
    if (hasRPIN_ID() || rhs.hasRPIN_ID()) {
        if (getRPIN_ID() < rhs.getRPIN_ID()) return true;
        if (getRPIN_ID() > rhs.getRPIN_ID()) return false;
    }
    if (hasRPIN_Password() || rhs.hasRPIN_Password()) {
        if (getRPIN_Password() < rhs.getRPIN_Password()) return true;
        if (getRPIN_Password() > rhs.getRPIN_Password()) return false;
    }
    return false;
}

inline bool T_TCU_PIN::operator > (const T_TCU_PIN& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TCU_PIN::clear() {
    clearRPIN_ID();
    clearRPIN_Password();
}

inline void T_TCU_PIN::clearRPIN_ID() {
    if (hasRPIN_ID()) {
         clear_has_rPIN_ID();
        _rPIN_ID.clear();
     }
}

inline bool T_TCU_PIN::hasRPIN_ID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const PIN_Data& T_TCU_PIN::getRPIN_ID () const {
    return _rPIN_ID;
}

inline PIN_Data& T_TCU_PIN::getRPIN_IDMutable () {
    set_has_rPIN_ID();
    return _rPIN_ID;
}

inline void T_TCU_PIN::setRPIN_ID (const PIN_Data& rPIN_ID_) {
    set_has_rPIN_ID();
    this->_rPIN_ID = rPIN_ID_;
}

inline void T_TCU_PIN::clearRPIN_Password() {
    if (hasRPIN_Password()) {
         clear_has_rPIN_Password();
        _rPIN_Password.clear();
     }
}

inline bool T_TCU_PIN::hasRPIN_Password () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const PIN_Data& T_TCU_PIN::getRPIN_Password () const {
    return _rPIN_Password;
}

inline PIN_Data& T_TCU_PIN::getRPIN_PasswordMutable () {
    set_has_rPIN_Password();
    return _rPIN_Password;
}

inline void T_TCU_PIN::setRPIN_Password (const PIN_Data& rPIN_Password_) {
    set_has_rPIN_Password();
    this->_rPIN_Password = rPIN_Password_;
}

inline void T_TCU_PIN::set_has_rPIN_ID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TCU_PIN::clear_has_rPIN_ID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TCU_PIN::set_has_rPIN_Password () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TCU_PIN::clear_has_rPIN_Password () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_TCU_Wifi_SSID_Name::T_TCU_Wifi_SSID_Name ()  :
    _u8CharcterSet (0u),
    _u8LentghOfText (0u),
    _sText ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TCU_Wifi_SSID_Name::T_TCU_Wifi_SSID_Name (const T_TCU_Wifi_SSID_Name &rhs)  :
    _u8CharcterSet (0u),
    _u8LentghOfText (0u),
    _sText ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TCU_Wifi_SSID_Name::T_TCU_Wifi_SSID_Name (uint8 u8CharcterSet_, uint8 u8LentghOfText_, const ::std::string& sText_)  :
    _u8CharcterSet (u8CharcterSet_),
    _u8LentghOfText (u8LentghOfText_),
    _sText (sText_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sText_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TCU_Wifi_SSID_Name::~T_TCU_Wifi_SSID_Name() {
}

inline T_TCU_Wifi_SSID_Name& T_TCU_Wifi_SSID_Name::operator = (const T_TCU_Wifi_SSID_Name& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8CharcterSet()) {
            setU8CharcterSet(rhs.getU8CharcterSet());
        } else {
            clearU8CharcterSet();
        }
        if (rhs.hasU8LentghOfText()) {
            setU8LentghOfText(rhs.getU8LentghOfText());
        } else {
            clearU8LentghOfText();
        }
        if (rhs.hasSText()) {
            setSText(rhs.getSText());
        } else {
            clearSText();
        }
    }
    return *this;
}

inline bool T_TCU_Wifi_SSID_Name::operator == (const T_TCU_Wifi_SSID_Name& rhs) const {
    return (((!hasU8CharcterSet() && !rhs.hasU8CharcterSet()) || getU8CharcterSet() == rhs.getU8CharcterSet()) &&
        ((!hasU8LentghOfText() && !rhs.hasU8LentghOfText()) || getU8LentghOfText() == rhs.getU8LentghOfText()) &&
        ((!hasSText() && !rhs.hasSText()) || getSText() == rhs.getSText()));
}

inline bool T_TCU_Wifi_SSID_Name::operator != (const T_TCU_Wifi_SSID_Name& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TCU_Wifi_SSID_Name::operator < (const T_TCU_Wifi_SSID_Name& rhs) const {
    if (hasU8CharcterSet() || rhs.hasU8CharcterSet()) {
        if (getU8CharcterSet() < rhs.getU8CharcterSet()) return true;
        if (getU8CharcterSet() > rhs.getU8CharcterSet()) return false;
    }
    if (hasU8LentghOfText() || rhs.hasU8LentghOfText()) {
        if (getU8LentghOfText() < rhs.getU8LentghOfText()) return true;
        if (getU8LentghOfText() > rhs.getU8LentghOfText()) return false;
    }
    if (hasSText() || rhs.hasSText()) {
        if (getSText() < rhs.getSText()) return true;
        if (getSText() > rhs.getSText()) return false;
    }
    return false;
}

inline bool T_TCU_Wifi_SSID_Name::operator > (const T_TCU_Wifi_SSID_Name& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TCU_Wifi_SSID_Name::clear() {
    clearU8CharcterSet();
    clearU8LentghOfText();
    clearSText();
}

inline void T_TCU_Wifi_SSID_Name::clearU8CharcterSet() {
    if (hasU8CharcterSet()) {
         clear_has_u8CharcterSet();
        _u8CharcterSet = 0u;
     }
}

inline bool T_TCU_Wifi_SSID_Name::hasU8CharcterSet () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_TCU_Wifi_SSID_Name::getU8CharcterSet () const {
    return _u8CharcterSet;
}

inline void T_TCU_Wifi_SSID_Name::setU8CharcterSet (uint8 u8CharcterSet_) {
    set_has_u8CharcterSet();
    this->_u8CharcterSet = u8CharcterSet_;
}

inline void T_TCU_Wifi_SSID_Name::clearU8LentghOfText() {
    if (hasU8LentghOfText()) {
         clear_has_u8LentghOfText();
        _u8LentghOfText = 0u;
     }
}

inline bool T_TCU_Wifi_SSID_Name::hasU8LentghOfText () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_TCU_Wifi_SSID_Name::getU8LentghOfText () const {
    return _u8LentghOfText;
}

inline void T_TCU_Wifi_SSID_Name::setU8LentghOfText (uint8 u8LentghOfText_) {
    set_has_u8LentghOfText();
    this->_u8LentghOfText = u8LentghOfText_;
}

inline void T_TCU_Wifi_SSID_Name::clearSText() {
    if (hasSText()) {
         clear_has_sText();
        _sText.clear();
     }
}

inline bool T_TCU_Wifi_SSID_Name::hasSText () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& T_TCU_Wifi_SSID_Name::getSText () const {
    return _sText;
}

inline ::std::string& T_TCU_Wifi_SSID_Name::getSTextMutable () {
    set_has_sText();
    return _sText;
}

inline void T_TCU_Wifi_SSID_Name::setSText (const ::std::string& sText_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sText_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sText();
    this->_sText = sText_;
}

inline void T_TCU_Wifi_SSID_Name::setSText (const char* sText_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sText_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sText();
    this->_sText.assign(sText_);
}

inline void T_TCU_Wifi_SSID_Name::setSText (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sText();
    this->_sText.assign(value, size);
}

inline void T_TCU_Wifi_SSID_Name::set_has_u8CharcterSet () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TCU_Wifi_SSID_Name::clear_has_u8CharcterSet () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TCU_Wifi_SSID_Name::set_has_u8LentghOfText () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TCU_Wifi_SSID_Name::clear_has_u8LentghOfText () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_TCU_Wifi_SSID_Name::set_has_sText () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_TCU_Wifi_SSID_Name::clear_has_sText () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_TCU_Wifi_PassKey::T_TCU_Wifi_PassKey ()  :
    _u8CharcterSet (0u),
    _u8LentghOfText (0u),
    _sText ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TCU_Wifi_PassKey::T_TCU_Wifi_PassKey (const T_TCU_Wifi_PassKey &rhs)  :
    _u8CharcterSet (0u),
    _u8LentghOfText (0u),
    _sText ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TCU_Wifi_PassKey::T_TCU_Wifi_PassKey (uint8 u8CharcterSet_, uint8 u8LentghOfText_, const ::std::string& sText_)  :
    _u8CharcterSet (u8CharcterSet_),
    _u8LentghOfText (u8LentghOfText_),
    _sText (sText_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sText_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TCU_Wifi_PassKey::~T_TCU_Wifi_PassKey() {
}

inline T_TCU_Wifi_PassKey& T_TCU_Wifi_PassKey::operator = (const T_TCU_Wifi_PassKey& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8CharcterSet()) {
            setU8CharcterSet(rhs.getU8CharcterSet());
        } else {
            clearU8CharcterSet();
        }
        if (rhs.hasU8LentghOfText()) {
            setU8LentghOfText(rhs.getU8LentghOfText());
        } else {
            clearU8LentghOfText();
        }
        if (rhs.hasSText()) {
            setSText(rhs.getSText());
        } else {
            clearSText();
        }
    }
    return *this;
}

inline bool T_TCU_Wifi_PassKey::operator == (const T_TCU_Wifi_PassKey& rhs) const {
    return (((!hasU8CharcterSet() && !rhs.hasU8CharcterSet()) || getU8CharcterSet() == rhs.getU8CharcterSet()) &&
        ((!hasU8LentghOfText() && !rhs.hasU8LentghOfText()) || getU8LentghOfText() == rhs.getU8LentghOfText()) &&
        ((!hasSText() && !rhs.hasSText()) || getSText() == rhs.getSText()));
}

inline bool T_TCU_Wifi_PassKey::operator != (const T_TCU_Wifi_PassKey& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TCU_Wifi_PassKey::operator < (const T_TCU_Wifi_PassKey& rhs) const {
    if (hasU8CharcterSet() || rhs.hasU8CharcterSet()) {
        if (getU8CharcterSet() < rhs.getU8CharcterSet()) return true;
        if (getU8CharcterSet() > rhs.getU8CharcterSet()) return false;
    }
    if (hasU8LentghOfText() || rhs.hasU8LentghOfText()) {
        if (getU8LentghOfText() < rhs.getU8LentghOfText()) return true;
        if (getU8LentghOfText() > rhs.getU8LentghOfText()) return false;
    }
    if (hasSText() || rhs.hasSText()) {
        if (getSText() < rhs.getSText()) return true;
        if (getSText() > rhs.getSText()) return false;
    }
    return false;
}

inline bool T_TCU_Wifi_PassKey::operator > (const T_TCU_Wifi_PassKey& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TCU_Wifi_PassKey::clear() {
    clearU8CharcterSet();
    clearU8LentghOfText();
    clearSText();
}

inline void T_TCU_Wifi_PassKey::clearU8CharcterSet() {
    if (hasU8CharcterSet()) {
         clear_has_u8CharcterSet();
        _u8CharcterSet = 0u;
     }
}

inline bool T_TCU_Wifi_PassKey::hasU8CharcterSet () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_TCU_Wifi_PassKey::getU8CharcterSet () const {
    return _u8CharcterSet;
}

inline void T_TCU_Wifi_PassKey::setU8CharcterSet (uint8 u8CharcterSet_) {
    set_has_u8CharcterSet();
    this->_u8CharcterSet = u8CharcterSet_;
}

inline void T_TCU_Wifi_PassKey::clearU8LentghOfText() {
    if (hasU8LentghOfText()) {
         clear_has_u8LentghOfText();
        _u8LentghOfText = 0u;
     }
}

inline bool T_TCU_Wifi_PassKey::hasU8LentghOfText () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_TCU_Wifi_PassKey::getU8LentghOfText () const {
    return _u8LentghOfText;
}

inline void T_TCU_Wifi_PassKey::setU8LentghOfText (uint8 u8LentghOfText_) {
    set_has_u8LentghOfText();
    this->_u8LentghOfText = u8LentghOfText_;
}

inline void T_TCU_Wifi_PassKey::clearSText() {
    if (hasSText()) {
         clear_has_sText();
        _sText.clear();
     }
}

inline bool T_TCU_Wifi_PassKey::hasSText () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& T_TCU_Wifi_PassKey::getSText () const {
    return _sText;
}

inline ::std::string& T_TCU_Wifi_PassKey::getSTextMutable () {
    set_has_sText();
    return _sText;
}

inline void T_TCU_Wifi_PassKey::setSText (const ::std::string& sText_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sText_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sText();
    this->_sText = sText_;
}

inline void T_TCU_Wifi_PassKey::setSText (const char* sText_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sText_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sText();
    this->_sText.assign(sText_);
}

inline void T_TCU_Wifi_PassKey::setSText (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sText();
    this->_sText.assign(value, size);
}

inline void T_TCU_Wifi_PassKey::set_has_u8CharcterSet () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TCU_Wifi_PassKey::clear_has_u8CharcterSet () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TCU_Wifi_PassKey::set_has_u8LentghOfText () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TCU_Wifi_PassKey::clear_has_u8LentghOfText () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_TCU_Wifi_PassKey::set_has_sText () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_TCU_Wifi_PassKey::clear_has_sText () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_TCU_Time_Slot::T_TCU_Time_Slot ()  :
    _rStart_timeStamp (),
    _rStop_timeStamp (),
    _e8Cycle (::tcu_main_fi_types::T_e8_TCU_Cycle__Every_Day)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TCU_Time_Slot::T_TCU_Time_Slot (const T_TCU_Time_Slot &rhs)  :
    _rStart_timeStamp (),
    _rStop_timeStamp (),
    _e8Cycle (::tcu_main_fi_types::T_e8_TCU_Cycle__Every_Day)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TCU_Time_Slot::T_TCU_Time_Slot (const T_TCU_Date_Time& rStart_timeStamp_, const T_TCU_Date_Time& rStop_timeStamp_, T_e8_TCU_Cycle e8Cycle_)  :
    _rStart_timeStamp (rStart_timeStamp_),
    _rStop_timeStamp (rStop_timeStamp_),
    _e8Cycle (e8Cycle_)
{
    #ifndef NDEBUG
    if (!(T_e8_TCU_Cycle_IsValid(e8Cycle_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Cycle_, "T_e8_TCU_Cycle", "e8Cycle", "T_TCU_Time_Slot");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TCU_Time_Slot::~T_TCU_Time_Slot() {
}

inline T_TCU_Time_Slot& T_TCU_Time_Slot::operator = (const T_TCU_Time_Slot& rhs) {
    if( this != &rhs ) {
        if (rhs.hasRStart_timeStamp()) {
            setRStart_timeStamp(rhs.getRStart_timeStamp());
        } else {
            clearRStart_timeStamp();
        }
        if (rhs.hasRStop_timeStamp()) {
            setRStop_timeStamp(rhs.getRStop_timeStamp());
        } else {
            clearRStop_timeStamp();
        }
        if (rhs.hasE8Cycle()) {
            setE8Cycle(rhs.getE8Cycle());
        } else {
            clearE8Cycle();
        }
    }
    return *this;
}

inline bool T_TCU_Time_Slot::operator == (const T_TCU_Time_Slot& rhs) const {
    return (((!hasRStart_timeStamp() && !rhs.hasRStart_timeStamp()) || getRStart_timeStamp() == rhs.getRStart_timeStamp()) &&
        ((!hasRStop_timeStamp() && !rhs.hasRStop_timeStamp()) || getRStop_timeStamp() == rhs.getRStop_timeStamp()) &&
        ((!hasE8Cycle() && !rhs.hasE8Cycle()) || getE8Cycle() == rhs.getE8Cycle()));
}

inline bool T_TCU_Time_Slot::operator != (const T_TCU_Time_Slot& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TCU_Time_Slot::operator < (const T_TCU_Time_Slot& rhs) const {
    if (hasRStart_timeStamp() || rhs.hasRStart_timeStamp()) {
        if (getRStart_timeStamp() < rhs.getRStart_timeStamp()) return true;
        if (getRStart_timeStamp() > rhs.getRStart_timeStamp()) return false;
    }
    if (hasRStop_timeStamp() || rhs.hasRStop_timeStamp()) {
        if (getRStop_timeStamp() < rhs.getRStop_timeStamp()) return true;
        if (getRStop_timeStamp() > rhs.getRStop_timeStamp()) return false;
    }
    if (hasE8Cycle() || rhs.hasE8Cycle()) {
        if ((uint32)getE8Cycle() < (uint32)rhs.getE8Cycle()) return true;
        if ((uint32)getE8Cycle() > (uint32)rhs.getE8Cycle()) return false;
    }
    return false;
}

inline bool T_TCU_Time_Slot::operator > (const T_TCU_Time_Slot& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TCU_Time_Slot::clear() {
    clearRStart_timeStamp();
    clearRStop_timeStamp();
    clearE8Cycle();
}

inline void T_TCU_Time_Slot::clearRStart_timeStamp() {
    if (hasRStart_timeStamp()) {
         clear_has_rStart_timeStamp();
        _rStart_timeStamp.clear();
     }
}

inline bool T_TCU_Time_Slot::hasRStart_timeStamp () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const T_TCU_Date_Time& T_TCU_Time_Slot::getRStart_timeStamp () const {
    return _rStart_timeStamp;
}

inline T_TCU_Date_Time& T_TCU_Time_Slot::getRStart_timeStampMutable () {
    set_has_rStart_timeStamp();
    return _rStart_timeStamp;
}

inline void T_TCU_Time_Slot::setRStart_timeStamp (const T_TCU_Date_Time& rStart_timeStamp_) {
    set_has_rStart_timeStamp();
    this->_rStart_timeStamp = rStart_timeStamp_;
}

inline void T_TCU_Time_Slot::clearRStop_timeStamp() {
    if (hasRStop_timeStamp()) {
         clear_has_rStop_timeStamp();
        _rStop_timeStamp.clear();
     }
}

inline bool T_TCU_Time_Slot::hasRStop_timeStamp () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const T_TCU_Date_Time& T_TCU_Time_Slot::getRStop_timeStamp () const {
    return _rStop_timeStamp;
}

inline T_TCU_Date_Time& T_TCU_Time_Slot::getRStop_timeStampMutable () {
    set_has_rStop_timeStamp();
    return _rStop_timeStamp;
}

inline void T_TCU_Time_Slot::setRStop_timeStamp (const T_TCU_Date_Time& rStop_timeStamp_) {
    set_has_rStop_timeStamp();
    this->_rStop_timeStamp = rStop_timeStamp_;
}

inline void T_TCU_Time_Slot::clearE8Cycle() {
    if (hasE8Cycle()) {
         clear_has_e8Cycle();
        _e8Cycle = ::tcu_main_fi_types::T_e8_TCU_Cycle__Every_Day;
     }
}

inline bool T_TCU_Time_Slot::hasE8Cycle () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_TCU_Cycle T_TCU_Time_Slot::getE8Cycle () const {
    return _e8Cycle;
}

inline void T_TCU_Time_Slot::setE8Cycle (T_e8_TCU_Cycle e8Cycle_) {
    #ifndef NDEBUG
    if (!(T_e8_TCU_Cycle_IsValid(e8Cycle_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Cycle_, "T_e8_TCU_Cycle", "e8Cycle", "T_TCU_Time_Slot");
    }
    #endif
    set_has_e8Cycle();
    this->_e8Cycle = e8Cycle_;
}

inline void T_TCU_Time_Slot::set_has_rStart_timeStamp () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TCU_Time_Slot::clear_has_rStart_timeStamp () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TCU_Time_Slot::set_has_rStop_timeStamp () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TCU_Time_Slot::clear_has_rStop_timeStamp () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_TCU_Time_Slot::set_has_e8Cycle () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_TCU_Time_Slot::clear_has_e8Cycle () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_TCU_Coordinates::T_TCU_Coordinates ()  :
    _e8Latitudemode (::tcu_main_fi_types::T_e8_TCU_LatitudeMode__North),
    _e8LongitudeMode (::tcu_main_fi_types::T_e8_TCU_LongitudeMode__East),
    _u8LatitudeDEG (0u),
    _u8LatitudeMIN (0u),
    _u16LatitudeSEC (0u),
    _u8LongitudeDEG (0u),
    _u8LongitudeMIN (0u),
    _u16LongitudeSEC (0u),
    _u8Reserve (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TCU_Coordinates::T_TCU_Coordinates (const T_TCU_Coordinates &rhs)  :
    _e8Latitudemode (::tcu_main_fi_types::T_e8_TCU_LatitudeMode__North),
    _e8LongitudeMode (::tcu_main_fi_types::T_e8_TCU_LongitudeMode__East),
    _u8LatitudeDEG (0u),
    _u8LatitudeMIN (0u),
    _u16LatitudeSEC (0u),
    _u8LongitudeDEG (0u),
    _u8LongitudeMIN (0u),
    _u16LongitudeSEC (0u),
    _u8Reserve (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TCU_Coordinates::T_TCU_Coordinates (T_e8_TCU_LatitudeMode e8Latitudemode_, T_e8_TCU_LongitudeMode e8LongitudeMode_, uint8 u8LatitudeDEG_, uint8 u8LatitudeMIN_, uint16 u16LatitudeSEC_, uint8 u8LongitudeDEG_, uint8 u8LongitudeMIN_, uint16 u16LongitudeSEC_, uint8 u8Reserve_)  :
    _e8Latitudemode (e8Latitudemode_),
    _e8LongitudeMode (e8LongitudeMode_),
    _u8LatitudeDEG (u8LatitudeDEG_),
    _u8LatitudeMIN (u8LatitudeMIN_),
    _u16LatitudeSEC (u16LatitudeSEC_),
    _u8LongitudeDEG (u8LongitudeDEG_),
    _u8LongitudeMIN (u8LongitudeMIN_),
    _u16LongitudeSEC (u16LongitudeSEC_),
    _u8Reserve (u8Reserve_)
{
    #ifndef NDEBUG
    if (!(T_e8_TCU_LatitudeMode_IsValid(e8Latitudemode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Latitudemode_, "T_e8_TCU_LatitudeMode", "e8Latitudemode", "T_TCU_Coordinates");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_TCU_LongitudeMode_IsValid(e8LongitudeMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8LongitudeMode_, "T_e8_TCU_LongitudeMode", "e8LongitudeMode", "T_TCU_Coordinates");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TCU_Coordinates::~T_TCU_Coordinates() {
}

inline T_TCU_Coordinates& T_TCU_Coordinates::operator = (const T_TCU_Coordinates& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE8Latitudemode()) {
            setE8Latitudemode(rhs.getE8Latitudemode());
        } else {
            clearE8Latitudemode();
        }
        if (rhs.hasE8LongitudeMode()) {
            setE8LongitudeMode(rhs.getE8LongitudeMode());
        } else {
            clearE8LongitudeMode();
        }
        if (rhs.hasU8LatitudeDEG()) {
            setU8LatitudeDEG(rhs.getU8LatitudeDEG());
        } else {
            clearU8LatitudeDEG();
        }
        if (rhs.hasU8LatitudeMIN()) {
            setU8LatitudeMIN(rhs.getU8LatitudeMIN());
        } else {
            clearU8LatitudeMIN();
        }
        if (rhs.hasU16LatitudeSEC()) {
            setU16LatitudeSEC(rhs.getU16LatitudeSEC());
        } else {
            clearU16LatitudeSEC();
        }
        if (rhs.hasU8LongitudeDEG()) {
            setU8LongitudeDEG(rhs.getU8LongitudeDEG());
        } else {
            clearU8LongitudeDEG();
        }
        if (rhs.hasU8LongitudeMIN()) {
            setU8LongitudeMIN(rhs.getU8LongitudeMIN());
        } else {
            clearU8LongitudeMIN();
        }
        if (rhs.hasU16LongitudeSEC()) {
            setU16LongitudeSEC(rhs.getU16LongitudeSEC());
        } else {
            clearU16LongitudeSEC();
        }
        if (rhs.hasU8Reserve()) {
            setU8Reserve(rhs.getU8Reserve());
        } else {
            clearU8Reserve();
        }
    }
    return *this;
}

inline bool T_TCU_Coordinates::operator == (const T_TCU_Coordinates& rhs) const {
    return (((!hasE8Latitudemode() && !rhs.hasE8Latitudemode()) || getE8Latitudemode() == rhs.getE8Latitudemode()) &&
        ((!hasE8LongitudeMode() && !rhs.hasE8LongitudeMode()) || getE8LongitudeMode() == rhs.getE8LongitudeMode()) &&
        ((!hasU8LatitudeDEG() && !rhs.hasU8LatitudeDEG()) || getU8LatitudeDEG() == rhs.getU8LatitudeDEG()) &&
        ((!hasU8LatitudeMIN() && !rhs.hasU8LatitudeMIN()) || getU8LatitudeMIN() == rhs.getU8LatitudeMIN()) &&
        ((!hasU16LatitudeSEC() && !rhs.hasU16LatitudeSEC()) || getU16LatitudeSEC() == rhs.getU16LatitudeSEC()) &&
        ((!hasU8LongitudeDEG() && !rhs.hasU8LongitudeDEG()) || getU8LongitudeDEG() == rhs.getU8LongitudeDEG()) &&
        ((!hasU8LongitudeMIN() && !rhs.hasU8LongitudeMIN()) || getU8LongitudeMIN() == rhs.getU8LongitudeMIN()) &&
        ((!hasU16LongitudeSEC() && !rhs.hasU16LongitudeSEC()) || getU16LongitudeSEC() == rhs.getU16LongitudeSEC()) &&
        ((!hasU8Reserve() && !rhs.hasU8Reserve()) || getU8Reserve() == rhs.getU8Reserve()));
}

inline bool T_TCU_Coordinates::operator != (const T_TCU_Coordinates& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TCU_Coordinates::operator < (const T_TCU_Coordinates& rhs) const {
    if (hasE8Latitudemode() || rhs.hasE8Latitudemode()) {
        if ((uint32)getE8Latitudemode() < (uint32)rhs.getE8Latitudemode()) return true;
        if ((uint32)getE8Latitudemode() > (uint32)rhs.getE8Latitudemode()) return false;
    }
    if (hasE8LongitudeMode() || rhs.hasE8LongitudeMode()) {
        if ((uint32)getE8LongitudeMode() < (uint32)rhs.getE8LongitudeMode()) return true;
        if ((uint32)getE8LongitudeMode() > (uint32)rhs.getE8LongitudeMode()) return false;
    }
    if (hasU8LatitudeDEG() || rhs.hasU8LatitudeDEG()) {
        if (getU8LatitudeDEG() < rhs.getU8LatitudeDEG()) return true;
        if (getU8LatitudeDEG() > rhs.getU8LatitudeDEG()) return false;
    }
    if (hasU8LatitudeMIN() || rhs.hasU8LatitudeMIN()) {
        if (getU8LatitudeMIN() < rhs.getU8LatitudeMIN()) return true;
        if (getU8LatitudeMIN() > rhs.getU8LatitudeMIN()) return false;
    }
    if (hasU16LatitudeSEC() || rhs.hasU16LatitudeSEC()) {
        if (getU16LatitudeSEC() < rhs.getU16LatitudeSEC()) return true;
        if (getU16LatitudeSEC() > rhs.getU16LatitudeSEC()) return false;
    }
    if (hasU8LongitudeDEG() || rhs.hasU8LongitudeDEG()) {
        if (getU8LongitudeDEG() < rhs.getU8LongitudeDEG()) return true;
        if (getU8LongitudeDEG() > rhs.getU8LongitudeDEG()) return false;
    }
    if (hasU8LongitudeMIN() || rhs.hasU8LongitudeMIN()) {
        if (getU8LongitudeMIN() < rhs.getU8LongitudeMIN()) return true;
        if (getU8LongitudeMIN() > rhs.getU8LongitudeMIN()) return false;
    }
    if (hasU16LongitudeSEC() || rhs.hasU16LongitudeSEC()) {
        if (getU16LongitudeSEC() < rhs.getU16LongitudeSEC()) return true;
        if (getU16LongitudeSEC() > rhs.getU16LongitudeSEC()) return false;
    }
    if (hasU8Reserve() || rhs.hasU8Reserve()) {
        if (getU8Reserve() < rhs.getU8Reserve()) return true;
        if (getU8Reserve() > rhs.getU8Reserve()) return false;
    }
    return false;
}

inline bool T_TCU_Coordinates::operator > (const T_TCU_Coordinates& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TCU_Coordinates::clear() {
    clearE8Latitudemode();
    clearE8LongitudeMode();
    clearU8LatitudeDEG();
    clearU8LatitudeMIN();
    clearU16LatitudeSEC();
    clearU8LongitudeDEG();
    clearU8LongitudeMIN();
    clearU16LongitudeSEC();
    clearU8Reserve();
}

inline void T_TCU_Coordinates::clearE8Latitudemode() {
    if (hasE8Latitudemode()) {
         clear_has_e8Latitudemode();
        _e8Latitudemode = ::tcu_main_fi_types::T_e8_TCU_LatitudeMode__North;
     }
}

inline bool T_TCU_Coordinates::hasE8Latitudemode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_TCU_LatitudeMode T_TCU_Coordinates::getE8Latitudemode () const {
    return _e8Latitudemode;
}

inline void T_TCU_Coordinates::setE8Latitudemode (T_e8_TCU_LatitudeMode e8Latitudemode_) {
    #ifndef NDEBUG
    if (!(T_e8_TCU_LatitudeMode_IsValid(e8Latitudemode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Latitudemode_, "T_e8_TCU_LatitudeMode", "e8Latitudemode", "T_TCU_Coordinates");
    }
    #endif
    set_has_e8Latitudemode();
    this->_e8Latitudemode = e8Latitudemode_;
}

inline void T_TCU_Coordinates::clearE8LongitudeMode() {
    if (hasE8LongitudeMode()) {
         clear_has_e8LongitudeMode();
        _e8LongitudeMode = ::tcu_main_fi_types::T_e8_TCU_LongitudeMode__East;
     }
}

inline bool T_TCU_Coordinates::hasE8LongitudeMode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_TCU_LongitudeMode T_TCU_Coordinates::getE8LongitudeMode () const {
    return _e8LongitudeMode;
}

inline void T_TCU_Coordinates::setE8LongitudeMode (T_e8_TCU_LongitudeMode e8LongitudeMode_) {
    #ifndef NDEBUG
    if (!(T_e8_TCU_LongitudeMode_IsValid(e8LongitudeMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8LongitudeMode_, "T_e8_TCU_LongitudeMode", "e8LongitudeMode", "T_TCU_Coordinates");
    }
    #endif
    set_has_e8LongitudeMode();
    this->_e8LongitudeMode = e8LongitudeMode_;
}

inline void T_TCU_Coordinates::clearU8LatitudeDEG() {
    if (hasU8LatitudeDEG()) {
         clear_has_u8LatitudeDEG();
        _u8LatitudeDEG = 0u;
     }
}

inline bool T_TCU_Coordinates::hasU8LatitudeDEG () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 T_TCU_Coordinates::getU8LatitudeDEG () const {
    return _u8LatitudeDEG;
}

inline void T_TCU_Coordinates::setU8LatitudeDEG (uint8 u8LatitudeDEG_) {
    set_has_u8LatitudeDEG();
    this->_u8LatitudeDEG = u8LatitudeDEG_;
}

inline void T_TCU_Coordinates::clearU8LatitudeMIN() {
    if (hasU8LatitudeMIN()) {
         clear_has_u8LatitudeMIN();
        _u8LatitudeMIN = 0u;
     }
}

inline bool T_TCU_Coordinates::hasU8LatitudeMIN () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 T_TCU_Coordinates::getU8LatitudeMIN () const {
    return _u8LatitudeMIN;
}

inline void T_TCU_Coordinates::setU8LatitudeMIN (uint8 u8LatitudeMIN_) {
    set_has_u8LatitudeMIN();
    this->_u8LatitudeMIN = u8LatitudeMIN_;
}

inline void T_TCU_Coordinates::clearU16LatitudeSEC() {
    if (hasU16LatitudeSEC()) {
         clear_has_u16LatitudeSEC();
        _u16LatitudeSEC = 0u;
     }
}

inline bool T_TCU_Coordinates::hasU16LatitudeSEC () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint16 T_TCU_Coordinates::getU16LatitudeSEC () const {
    return _u16LatitudeSEC;
}

inline void T_TCU_Coordinates::setU16LatitudeSEC (uint16 u16LatitudeSEC_) {
    set_has_u16LatitudeSEC();
    this->_u16LatitudeSEC = u16LatitudeSEC_;
}

inline void T_TCU_Coordinates::clearU8LongitudeDEG() {
    if (hasU8LongitudeDEG()) {
         clear_has_u8LongitudeDEG();
        _u8LongitudeDEG = 0u;
     }
}

inline bool T_TCU_Coordinates::hasU8LongitudeDEG () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint8 T_TCU_Coordinates::getU8LongitudeDEG () const {
    return _u8LongitudeDEG;
}

inline void T_TCU_Coordinates::setU8LongitudeDEG (uint8 u8LongitudeDEG_) {
    set_has_u8LongitudeDEG();
    this->_u8LongitudeDEG = u8LongitudeDEG_;
}

inline void T_TCU_Coordinates::clearU8LongitudeMIN() {
    if (hasU8LongitudeMIN()) {
         clear_has_u8LongitudeMIN();
        _u8LongitudeMIN = 0u;
     }
}

inline bool T_TCU_Coordinates::hasU8LongitudeMIN () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint8 T_TCU_Coordinates::getU8LongitudeMIN () const {
    return _u8LongitudeMIN;
}

inline void T_TCU_Coordinates::setU8LongitudeMIN (uint8 u8LongitudeMIN_) {
    set_has_u8LongitudeMIN();
    this->_u8LongitudeMIN = u8LongitudeMIN_;
}

inline void T_TCU_Coordinates::clearU16LongitudeSEC() {
    if (hasU16LongitudeSEC()) {
         clear_has_u16LongitudeSEC();
        _u16LongitudeSEC = 0u;
     }
}

inline bool T_TCU_Coordinates::hasU16LongitudeSEC () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline uint16 T_TCU_Coordinates::getU16LongitudeSEC () const {
    return _u16LongitudeSEC;
}

inline void T_TCU_Coordinates::setU16LongitudeSEC (uint16 u16LongitudeSEC_) {
    set_has_u16LongitudeSEC();
    this->_u16LongitudeSEC = u16LongitudeSEC_;
}

inline void T_TCU_Coordinates::clearU8Reserve() {
    if (hasU8Reserve()) {
         clear_has_u8Reserve();
        _u8Reserve = 0u;
     }
}

inline bool T_TCU_Coordinates::hasU8Reserve () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline uint8 T_TCU_Coordinates::getU8Reserve () const {
    return _u8Reserve;
}

inline void T_TCU_Coordinates::setU8Reserve (uint8 u8Reserve_) {
    set_has_u8Reserve();
    this->_u8Reserve = u8Reserve_;
}

inline void T_TCU_Coordinates::set_has_e8Latitudemode () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TCU_Coordinates::clear_has_e8Latitudemode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TCU_Coordinates::set_has_e8LongitudeMode () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TCU_Coordinates::clear_has_e8LongitudeMode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_TCU_Coordinates::set_has_u8LatitudeDEG () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_TCU_Coordinates::clear_has_u8LatitudeDEG () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_TCU_Coordinates::set_has_u8LatitudeMIN () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_TCU_Coordinates::clear_has_u8LatitudeMIN () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_TCU_Coordinates::set_has_u16LatitudeSEC () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_TCU_Coordinates::clear_has_u16LatitudeSEC () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_TCU_Coordinates::set_has_u8LongitudeDEG () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_TCU_Coordinates::clear_has_u8LongitudeDEG () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_TCU_Coordinates::set_has_u8LongitudeMIN () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_TCU_Coordinates::clear_has_u8LongitudeMIN () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_TCU_Coordinates::set_has_u16LongitudeSEC () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_TCU_Coordinates::clear_has_u16LongitudeSEC () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_TCU_Coordinates::set_has_u8Reserve () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_TCU_Coordinates::clear_has_u8Reserve () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline  T_TCU_Area_Coordinate::T_TCU_Area_Coordinate ()  :
    _rCoordinates1 (),
    _rCoordinates2 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TCU_Area_Coordinate::T_TCU_Area_Coordinate (const T_TCU_Area_Coordinate &rhs)  :
    _rCoordinates1 (),
    _rCoordinates2 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TCU_Area_Coordinate::T_TCU_Area_Coordinate (const T_TCU_Coordinates& rCoordinates1_, const T_TCU_Coordinates& rCoordinates2_)  :
    _rCoordinates1 (rCoordinates1_),
    _rCoordinates2 (rCoordinates2_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TCU_Area_Coordinate::~T_TCU_Area_Coordinate() {
}

inline T_TCU_Area_Coordinate& T_TCU_Area_Coordinate::operator = (const T_TCU_Area_Coordinate& rhs) {
    if( this != &rhs ) {
        if (rhs.hasRCoordinates1()) {
            setRCoordinates1(rhs.getRCoordinates1());
        } else {
            clearRCoordinates1();
        }
        if (rhs.hasRCoordinates2()) {
            setRCoordinates2(rhs.getRCoordinates2());
        } else {
            clearRCoordinates2();
        }
    }
    return *this;
}

inline bool T_TCU_Area_Coordinate::operator == (const T_TCU_Area_Coordinate& rhs) const {
    return (((!hasRCoordinates1() && !rhs.hasRCoordinates1()) || getRCoordinates1() == rhs.getRCoordinates1()) &&
        ((!hasRCoordinates2() && !rhs.hasRCoordinates2()) || getRCoordinates2() == rhs.getRCoordinates2()));
}

inline bool T_TCU_Area_Coordinate::operator != (const T_TCU_Area_Coordinate& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TCU_Area_Coordinate::operator < (const T_TCU_Area_Coordinate& rhs) const {
    if (hasRCoordinates1() || rhs.hasRCoordinates1()) {
        if (getRCoordinates1() < rhs.getRCoordinates1()) return true;
        if (getRCoordinates1() > rhs.getRCoordinates1()) return false;
    }
    if (hasRCoordinates2() || rhs.hasRCoordinates2()) {
        if (getRCoordinates2() < rhs.getRCoordinates2()) return true;
        if (getRCoordinates2() > rhs.getRCoordinates2()) return false;
    }
    return false;
}

inline bool T_TCU_Area_Coordinate::operator > (const T_TCU_Area_Coordinate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TCU_Area_Coordinate::clear() {
    clearRCoordinates1();
    clearRCoordinates2();
}

inline void T_TCU_Area_Coordinate::clearRCoordinates1() {
    if (hasRCoordinates1()) {
         clear_has_rCoordinates1();
        _rCoordinates1.clear();
     }
}

inline bool T_TCU_Area_Coordinate::hasRCoordinates1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const T_TCU_Coordinates& T_TCU_Area_Coordinate::getRCoordinates1 () const {
    return _rCoordinates1;
}

inline T_TCU_Coordinates& T_TCU_Area_Coordinate::getRCoordinates1Mutable () {
    set_has_rCoordinates1();
    return _rCoordinates1;
}

inline void T_TCU_Area_Coordinate::setRCoordinates1 (const T_TCU_Coordinates& rCoordinates1_) {
    set_has_rCoordinates1();
    this->_rCoordinates1 = rCoordinates1_;
}

inline void T_TCU_Area_Coordinate::clearRCoordinates2() {
    if (hasRCoordinates2()) {
         clear_has_rCoordinates2();
        _rCoordinates2.clear();
     }
}

inline bool T_TCU_Area_Coordinate::hasRCoordinates2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const T_TCU_Coordinates& T_TCU_Area_Coordinate::getRCoordinates2 () const {
    return _rCoordinates2;
}

inline T_TCU_Coordinates& T_TCU_Area_Coordinate::getRCoordinates2Mutable () {
    set_has_rCoordinates2();
    return _rCoordinates2;
}

inline void T_TCU_Area_Coordinate::setRCoordinates2 (const T_TCU_Coordinates& rCoordinates2_) {
    set_has_rCoordinates2();
    this->_rCoordinates2 = rCoordinates2_;
}

inline void T_TCU_Area_Coordinate::set_has_rCoordinates1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TCU_Area_Coordinate::clear_has_rCoordinates1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TCU_Area_Coordinate::set_has_rCoordinates2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TCU_Area_Coordinate::clear_has_rCoordinates2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_TCU_Area_Limit_Coordinates::T_TCU_Area_Limit_Coordinates ()  :
    _e8Restriction_Area_Type (::tcu_main_fi_types::T_e8_TCU_Restriction_Area_Type__Inclusion),
    _e8Area_Form (::tcu_main_fi_types::T_e8_TCU_Area_Form__Square_Area),
    _e8LocationType (::tcu_main_fi_types::T_e8_TCU_LocationType__Tokyo),
    _rArea_Coordinates (),
    _u16Radius (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TCU_Area_Limit_Coordinates::T_TCU_Area_Limit_Coordinates (const T_TCU_Area_Limit_Coordinates &rhs)  :
    _e8Restriction_Area_Type (::tcu_main_fi_types::T_e8_TCU_Restriction_Area_Type__Inclusion),
    _e8Area_Form (::tcu_main_fi_types::T_e8_TCU_Area_Form__Square_Area),
    _e8LocationType (::tcu_main_fi_types::T_e8_TCU_LocationType__Tokyo),
    _rArea_Coordinates (),
    _u16Radius (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TCU_Area_Limit_Coordinates::T_TCU_Area_Limit_Coordinates (T_e8_TCU_Restriction_Area_Type e8Restriction_Area_Type_, T_e8_TCU_Area_Form e8Area_Form_, T_e8_TCU_LocationType e8LocationType_, const T_TCU_Area_Coordinate& rArea_Coordinates_, uint16 u16Radius_)  :
    _e8Restriction_Area_Type (e8Restriction_Area_Type_),
    _e8Area_Form (e8Area_Form_),
    _e8LocationType (e8LocationType_),
    _rArea_Coordinates (rArea_Coordinates_),
    _u16Radius (u16Radius_)
{
    #ifndef NDEBUG
    if (!(T_e8_TCU_Restriction_Area_Type_IsValid(e8Restriction_Area_Type_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Restriction_Area_Type_, "T_e8_TCU_Restriction_Area_Type", "e8Restriction_Area_Type", "T_TCU_Area_Limit_Coordinates");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_TCU_Area_Form_IsValid(e8Area_Form_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Area_Form_, "T_e8_TCU_Area_Form", "e8Area_Form", "T_TCU_Area_Limit_Coordinates");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_TCU_LocationType_IsValid(e8LocationType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8LocationType_, "T_e8_TCU_LocationType", "e8LocationType", "T_TCU_Area_Limit_Coordinates");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TCU_Area_Limit_Coordinates::~T_TCU_Area_Limit_Coordinates() {
}

inline T_TCU_Area_Limit_Coordinates& T_TCU_Area_Limit_Coordinates::operator = (const T_TCU_Area_Limit_Coordinates& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE8Restriction_Area_Type()) {
            setE8Restriction_Area_Type(rhs.getE8Restriction_Area_Type());
        } else {
            clearE8Restriction_Area_Type();
        }
        if (rhs.hasE8Area_Form()) {
            setE8Area_Form(rhs.getE8Area_Form());
        } else {
            clearE8Area_Form();
        }
        if (rhs.hasE8LocationType()) {
            setE8LocationType(rhs.getE8LocationType());
        } else {
            clearE8LocationType();
        }
        if (rhs.hasRArea_Coordinates()) {
            setRArea_Coordinates(rhs.getRArea_Coordinates());
        } else {
            clearRArea_Coordinates();
        }
        if (rhs.hasU16Radius()) {
            setU16Radius(rhs.getU16Radius());
        } else {
            clearU16Radius();
        }
    }
    return *this;
}

inline bool T_TCU_Area_Limit_Coordinates::operator == (const T_TCU_Area_Limit_Coordinates& rhs) const {
    return (((!hasE8Restriction_Area_Type() && !rhs.hasE8Restriction_Area_Type()) || getE8Restriction_Area_Type() == rhs.getE8Restriction_Area_Type()) &&
        ((!hasE8Area_Form() && !rhs.hasE8Area_Form()) || getE8Area_Form() == rhs.getE8Area_Form()) &&
        ((!hasE8LocationType() && !rhs.hasE8LocationType()) || getE8LocationType() == rhs.getE8LocationType()) &&
        ((!hasRArea_Coordinates() && !rhs.hasRArea_Coordinates()) || getRArea_Coordinates() == rhs.getRArea_Coordinates()) &&
        ((!hasU16Radius() && !rhs.hasU16Radius()) || getU16Radius() == rhs.getU16Radius()));
}

inline bool T_TCU_Area_Limit_Coordinates::operator != (const T_TCU_Area_Limit_Coordinates& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TCU_Area_Limit_Coordinates::operator < (const T_TCU_Area_Limit_Coordinates& rhs) const {
    if (hasE8Restriction_Area_Type() || rhs.hasE8Restriction_Area_Type()) {
        if ((uint32)getE8Restriction_Area_Type() < (uint32)rhs.getE8Restriction_Area_Type()) return true;
        if ((uint32)getE8Restriction_Area_Type() > (uint32)rhs.getE8Restriction_Area_Type()) return false;
    }
    if (hasE8Area_Form() || rhs.hasE8Area_Form()) {
        if ((uint32)getE8Area_Form() < (uint32)rhs.getE8Area_Form()) return true;
        if ((uint32)getE8Area_Form() > (uint32)rhs.getE8Area_Form()) return false;
    }
    if (hasE8LocationType() || rhs.hasE8LocationType()) {
        if ((uint32)getE8LocationType() < (uint32)rhs.getE8LocationType()) return true;
        if ((uint32)getE8LocationType() > (uint32)rhs.getE8LocationType()) return false;
    }
    if (hasRArea_Coordinates() || rhs.hasRArea_Coordinates()) {
        if (getRArea_Coordinates() < rhs.getRArea_Coordinates()) return true;
        if (getRArea_Coordinates() > rhs.getRArea_Coordinates()) return false;
    }
    if (hasU16Radius() || rhs.hasU16Radius()) {
        if (getU16Radius() < rhs.getU16Radius()) return true;
        if (getU16Radius() > rhs.getU16Radius()) return false;
    }
    return false;
}

inline bool T_TCU_Area_Limit_Coordinates::operator > (const T_TCU_Area_Limit_Coordinates& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TCU_Area_Limit_Coordinates::clear() {
    clearE8Restriction_Area_Type();
    clearE8Area_Form();
    clearE8LocationType();
    clearRArea_Coordinates();
    clearU16Radius();
}

inline void T_TCU_Area_Limit_Coordinates::clearE8Restriction_Area_Type() {
    if (hasE8Restriction_Area_Type()) {
         clear_has_e8Restriction_Area_Type();
        _e8Restriction_Area_Type = ::tcu_main_fi_types::T_e8_TCU_Restriction_Area_Type__Inclusion;
     }
}

inline bool T_TCU_Area_Limit_Coordinates::hasE8Restriction_Area_Type () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_TCU_Restriction_Area_Type T_TCU_Area_Limit_Coordinates::getE8Restriction_Area_Type () const {
    return _e8Restriction_Area_Type;
}

inline void T_TCU_Area_Limit_Coordinates::setE8Restriction_Area_Type (T_e8_TCU_Restriction_Area_Type e8Restriction_Area_Type_) {
    #ifndef NDEBUG
    if (!(T_e8_TCU_Restriction_Area_Type_IsValid(e8Restriction_Area_Type_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Restriction_Area_Type_, "T_e8_TCU_Restriction_Area_Type", "e8Restriction_Area_Type", "T_TCU_Area_Limit_Coordinates");
    }
    #endif
    set_has_e8Restriction_Area_Type();
    this->_e8Restriction_Area_Type = e8Restriction_Area_Type_;
}

inline void T_TCU_Area_Limit_Coordinates::clearE8Area_Form() {
    if (hasE8Area_Form()) {
         clear_has_e8Area_Form();
        _e8Area_Form = ::tcu_main_fi_types::T_e8_TCU_Area_Form__Square_Area;
     }
}

inline bool T_TCU_Area_Limit_Coordinates::hasE8Area_Form () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_TCU_Area_Form T_TCU_Area_Limit_Coordinates::getE8Area_Form () const {
    return _e8Area_Form;
}

inline void T_TCU_Area_Limit_Coordinates::setE8Area_Form (T_e8_TCU_Area_Form e8Area_Form_) {
    #ifndef NDEBUG
    if (!(T_e8_TCU_Area_Form_IsValid(e8Area_Form_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Area_Form_, "T_e8_TCU_Area_Form", "e8Area_Form", "T_TCU_Area_Limit_Coordinates");
    }
    #endif
    set_has_e8Area_Form();
    this->_e8Area_Form = e8Area_Form_;
}

inline void T_TCU_Area_Limit_Coordinates::clearE8LocationType() {
    if (hasE8LocationType()) {
         clear_has_e8LocationType();
        _e8LocationType = ::tcu_main_fi_types::T_e8_TCU_LocationType__Tokyo;
     }
}

inline bool T_TCU_Area_Limit_Coordinates::hasE8LocationType () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_TCU_LocationType T_TCU_Area_Limit_Coordinates::getE8LocationType () const {
    return _e8LocationType;
}

inline void T_TCU_Area_Limit_Coordinates::setE8LocationType (T_e8_TCU_LocationType e8LocationType_) {
    #ifndef NDEBUG
    if (!(T_e8_TCU_LocationType_IsValid(e8LocationType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8LocationType_, "T_e8_TCU_LocationType", "e8LocationType", "T_TCU_Area_Limit_Coordinates");
    }
    #endif
    set_has_e8LocationType();
    this->_e8LocationType = e8LocationType_;
}

inline void T_TCU_Area_Limit_Coordinates::clearRArea_Coordinates() {
    if (hasRArea_Coordinates()) {
         clear_has_rArea_Coordinates();
        _rArea_Coordinates.clear();
     }
}

inline bool T_TCU_Area_Limit_Coordinates::hasRArea_Coordinates () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const T_TCU_Area_Coordinate& T_TCU_Area_Limit_Coordinates::getRArea_Coordinates () const {
    return _rArea_Coordinates;
}

inline T_TCU_Area_Coordinate& T_TCU_Area_Limit_Coordinates::getRArea_CoordinatesMutable () {
    set_has_rArea_Coordinates();
    return _rArea_Coordinates;
}

inline void T_TCU_Area_Limit_Coordinates::setRArea_Coordinates (const T_TCU_Area_Coordinate& rArea_Coordinates_) {
    set_has_rArea_Coordinates();
    this->_rArea_Coordinates = rArea_Coordinates_;
}

inline void T_TCU_Area_Limit_Coordinates::clearU16Radius() {
    if (hasU16Radius()) {
         clear_has_u16Radius();
        _u16Radius = 0u;
     }
}

inline bool T_TCU_Area_Limit_Coordinates::hasU16Radius () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint16 T_TCU_Area_Limit_Coordinates::getU16Radius () const {
    return _u16Radius;
}

inline void T_TCU_Area_Limit_Coordinates::setU16Radius (uint16 u16Radius_) {
    set_has_u16Radius();
    this->_u16Radius = u16Radius_;
}

inline void T_TCU_Area_Limit_Coordinates::set_has_e8Restriction_Area_Type () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TCU_Area_Limit_Coordinates::clear_has_e8Restriction_Area_Type () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TCU_Area_Limit_Coordinates::set_has_e8Area_Form () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TCU_Area_Limit_Coordinates::clear_has_e8Area_Form () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_TCU_Area_Limit_Coordinates::set_has_e8LocationType () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_TCU_Area_Limit_Coordinates::clear_has_e8LocationType () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_TCU_Area_Limit_Coordinates::set_has_rArea_Coordinates () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_TCU_Area_Limit_Coordinates::clear_has_rArea_Coordinates () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_TCU_Area_Limit_Coordinates::set_has_u16Radius () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_TCU_Area_Limit_Coordinates::clear_has_u16Radius () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  T_TCU_Speed_Limit_Restriction::T_TCU_Speed_Limit_Restriction ()  :
    _rLimited_Vehicle_Speed (),
    _rTime_Slot ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TCU_Speed_Limit_Restriction::T_TCU_Speed_Limit_Restriction (const T_TCU_Speed_Limit_Restriction &rhs)  :
    _rLimited_Vehicle_Speed (),
    _rTime_Slot ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TCU_Speed_Limit_Restriction::T_TCU_Speed_Limit_Restriction (const ::std::vector< uint16 >& rLimited_Vehicle_Speed_, const ::std::vector< T_TCU_Time_Slot >& rTime_Slot_)  :
    _rLimited_Vehicle_Speed (rLimited_Vehicle_Speed_),
    _rTime_Slot (rTime_Slot_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TCU_Speed_Limit_Restriction::~T_TCU_Speed_Limit_Restriction() {
}

inline T_TCU_Speed_Limit_Restriction& T_TCU_Speed_Limit_Restriction::operator = (const T_TCU_Speed_Limit_Restriction& rhs) {
    if( this != &rhs ) {
        if (rhs.hasRLimited_Vehicle_Speed()) {
            setRLimited_Vehicle_Speed(rhs.getRLimited_Vehicle_Speed());
        } else {
            clearRLimited_Vehicle_Speed();
        }
        if (rhs.hasRTime_Slot()) {
            setRTime_Slot(rhs.getRTime_Slot());
        } else {
            clearRTime_Slot();
        }
    }
    return *this;
}

inline bool T_TCU_Speed_Limit_Restriction::operator == (const T_TCU_Speed_Limit_Restriction& rhs) const {
    return (((!hasRLimited_Vehicle_Speed() && !rhs.hasRLimited_Vehicle_Speed()) || getRLimited_Vehicle_Speed() == rhs.getRLimited_Vehicle_Speed()) &&
        ((!hasRTime_Slot() && !rhs.hasRTime_Slot()) || getRTime_Slot() == rhs.getRTime_Slot()));
}

inline bool T_TCU_Speed_Limit_Restriction::operator != (const T_TCU_Speed_Limit_Restriction& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TCU_Speed_Limit_Restriction::operator < (const T_TCU_Speed_Limit_Restriction& rhs) const {
    if (hasRLimited_Vehicle_Speed() || rhs.hasRLimited_Vehicle_Speed()) {
        if (getRLimited_Vehicle_Speed() < rhs.getRLimited_Vehicle_Speed()) return true;
        if (getRLimited_Vehicle_Speed() > rhs.getRLimited_Vehicle_Speed()) return false;
    }
    if (hasRTime_Slot() || rhs.hasRTime_Slot()) {
        if (getRTime_Slot() < rhs.getRTime_Slot()) return true;
        if (getRTime_Slot() > rhs.getRTime_Slot()) return false;
    }
    return false;
}

inline bool T_TCU_Speed_Limit_Restriction::operator > (const T_TCU_Speed_Limit_Restriction& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TCU_Speed_Limit_Restriction::clear() {
    clearRLimited_Vehicle_Speed();
    clearRTime_Slot();
}

inline void T_TCU_Speed_Limit_Restriction::clearRLimited_Vehicle_Speed() {
    if (hasRLimited_Vehicle_Speed()) {
         clear_has_rLimited_Vehicle_Speed();
        _rLimited_Vehicle_Speed.clear();
     }
}

inline bool T_TCU_Speed_Limit_Restriction::hasRLimited_Vehicle_Speed () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< uint16 >& T_TCU_Speed_Limit_Restriction::getRLimited_Vehicle_Speed () const {
    return _rLimited_Vehicle_Speed;
}

inline ::std::vector< uint16 >& T_TCU_Speed_Limit_Restriction::getRLimited_Vehicle_SpeedMutable () {
    set_has_rLimited_Vehicle_Speed();
    return _rLimited_Vehicle_Speed;
}

inline void T_TCU_Speed_Limit_Restriction::setRLimited_Vehicle_Speed (const ::std::vector< uint16 >& rLimited_Vehicle_Speed_) {
    set_has_rLimited_Vehicle_Speed();
    this->_rLimited_Vehicle_Speed = rLimited_Vehicle_Speed_;
}

inline void T_TCU_Speed_Limit_Restriction::clearRTime_Slot() {
    if (hasRTime_Slot()) {
         clear_has_rTime_Slot();
        _rTime_Slot.clear();
     }
}

inline bool T_TCU_Speed_Limit_Restriction::hasRTime_Slot () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< T_TCU_Time_Slot >& T_TCU_Speed_Limit_Restriction::getRTime_Slot () const {
    return _rTime_Slot;
}

inline ::std::vector< T_TCU_Time_Slot >& T_TCU_Speed_Limit_Restriction::getRTime_SlotMutable () {
    set_has_rTime_Slot();
    return _rTime_Slot;
}

inline void T_TCU_Speed_Limit_Restriction::setRTime_Slot (const ::std::vector< T_TCU_Time_Slot >& rTime_Slot_) {
    set_has_rTime_Slot();
    this->_rTime_Slot = rTime_Slot_;
}

inline void T_TCU_Speed_Limit_Restriction::set_has_rLimited_Vehicle_Speed () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TCU_Speed_Limit_Restriction::clear_has_rLimited_Vehicle_Speed () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TCU_Speed_Limit_Restriction::set_has_rTime_Slot () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TCU_Speed_Limit_Restriction::clear_has_rTime_Slot () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_TCU_Area_Limit_Restriction::T_TCU_Area_Limit_Restriction ()  :
    _rArea_Limit_Coordinates (),
    _rTime_Slot ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TCU_Area_Limit_Restriction::T_TCU_Area_Limit_Restriction (const T_TCU_Area_Limit_Restriction &rhs)  :
    _rArea_Limit_Coordinates (),
    _rTime_Slot ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TCU_Area_Limit_Restriction::T_TCU_Area_Limit_Restriction (const ::std::vector< T_TCU_Area_Limit_Coordinates >& rArea_Limit_Coordinates_, const ::std::vector< T_TCU_Time_Slot >& rTime_Slot_)  :
    _rArea_Limit_Coordinates (rArea_Limit_Coordinates_),
    _rTime_Slot (rTime_Slot_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TCU_Area_Limit_Restriction::~T_TCU_Area_Limit_Restriction() {
}

inline T_TCU_Area_Limit_Restriction& T_TCU_Area_Limit_Restriction::operator = (const T_TCU_Area_Limit_Restriction& rhs) {
    if( this != &rhs ) {
        if (rhs.hasRArea_Limit_Coordinates()) {
            setRArea_Limit_Coordinates(rhs.getRArea_Limit_Coordinates());
        } else {
            clearRArea_Limit_Coordinates();
        }
        if (rhs.hasRTime_Slot()) {
            setRTime_Slot(rhs.getRTime_Slot());
        } else {
            clearRTime_Slot();
        }
    }
    return *this;
}

inline bool T_TCU_Area_Limit_Restriction::operator == (const T_TCU_Area_Limit_Restriction& rhs) const {
    return (((!hasRArea_Limit_Coordinates() && !rhs.hasRArea_Limit_Coordinates()) || getRArea_Limit_Coordinates() == rhs.getRArea_Limit_Coordinates()) &&
        ((!hasRTime_Slot() && !rhs.hasRTime_Slot()) || getRTime_Slot() == rhs.getRTime_Slot()));
}

inline bool T_TCU_Area_Limit_Restriction::operator != (const T_TCU_Area_Limit_Restriction& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TCU_Area_Limit_Restriction::operator < (const T_TCU_Area_Limit_Restriction& rhs) const {
    if (hasRArea_Limit_Coordinates() || rhs.hasRArea_Limit_Coordinates()) {
        if (getRArea_Limit_Coordinates() < rhs.getRArea_Limit_Coordinates()) return true;
        if (getRArea_Limit_Coordinates() > rhs.getRArea_Limit_Coordinates()) return false;
    }
    if (hasRTime_Slot() || rhs.hasRTime_Slot()) {
        if (getRTime_Slot() < rhs.getRTime_Slot()) return true;
        if (getRTime_Slot() > rhs.getRTime_Slot()) return false;
    }
    return false;
}

inline bool T_TCU_Area_Limit_Restriction::operator > (const T_TCU_Area_Limit_Restriction& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TCU_Area_Limit_Restriction::clear() {
    clearRArea_Limit_Coordinates();
    clearRTime_Slot();
}

inline void T_TCU_Area_Limit_Restriction::clearRArea_Limit_Coordinates() {
    if (hasRArea_Limit_Coordinates()) {
         clear_has_rArea_Limit_Coordinates();
        _rArea_Limit_Coordinates.clear();
     }
}

inline bool T_TCU_Area_Limit_Restriction::hasRArea_Limit_Coordinates () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< T_TCU_Area_Limit_Coordinates >& T_TCU_Area_Limit_Restriction::getRArea_Limit_Coordinates () const {
    return _rArea_Limit_Coordinates;
}

inline ::std::vector< T_TCU_Area_Limit_Coordinates >& T_TCU_Area_Limit_Restriction::getRArea_Limit_CoordinatesMutable () {
    set_has_rArea_Limit_Coordinates();
    return _rArea_Limit_Coordinates;
}

inline void T_TCU_Area_Limit_Restriction::setRArea_Limit_Coordinates (const ::std::vector< T_TCU_Area_Limit_Coordinates >& rArea_Limit_Coordinates_) {
    set_has_rArea_Limit_Coordinates();
    this->_rArea_Limit_Coordinates = rArea_Limit_Coordinates_;
}

inline void T_TCU_Area_Limit_Restriction::clearRTime_Slot() {
    if (hasRTime_Slot()) {
         clear_has_rTime_Slot();
        _rTime_Slot.clear();
     }
}

inline bool T_TCU_Area_Limit_Restriction::hasRTime_Slot () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< T_TCU_Time_Slot >& T_TCU_Area_Limit_Restriction::getRTime_Slot () const {
    return _rTime_Slot;
}

inline ::std::vector< T_TCU_Time_Slot >& T_TCU_Area_Limit_Restriction::getRTime_SlotMutable () {
    set_has_rTime_Slot();
    return _rTime_Slot;
}

inline void T_TCU_Area_Limit_Restriction::setRTime_Slot (const ::std::vector< T_TCU_Time_Slot >& rTime_Slot_) {
    set_has_rTime_Slot();
    this->_rTime_Slot = rTime_Slot_;
}

inline void T_TCU_Area_Limit_Restriction::set_has_rArea_Limit_Coordinates () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TCU_Area_Limit_Restriction::clear_has_rArea_Limit_Coordinates () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TCU_Area_Limit_Restriction::set_has_rTime_Slot () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TCU_Area_Limit_Restriction::clear_has_rTime_Slot () {
    _has_bits_[0] &= ~ (1u << 1);
}

} // namespace tcu_main_fi_types

#endif // TCU_MAIN_FI_TYPES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
