/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/stream/MemoryStream.h"
#include "tcu_main_fi.h"
#include "tcu_main_fiCca.h"
#include "tcu_main_fi_types.h"
#include "tcu_main_fi_typesCca.h"
#include "tcu_main_fi_typesConst.h"
#include <string>
#include <vector>


void serializeCca(const ::tcu_main_fi::ConnectionStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getBConnected();
    out << in.getU8AbsenceState();
    out << in.getU8MuteState();
    out << (uint8) in.getE8CommunicationStatus();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::ConnectionStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    bool o0;
    in >> o0;
    out.setBConnected(o0);
    uint8 o1;
    in >> o1;
    out.setU8AbsenceState(o1);
    uint8 o2;
    in >> o2;
    out.setU8MuteState(o2);
    uint8 o3;
    in >> o3;
    out.setE8CommunicationStatus((::tcu_main_fi_types::T_e8_TCU_CommunicationStatus)o3);
}

void serializeCca(const ::tcu_main_fi::ConfigurationStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8ConfigurationStatus();
    out << in.getU8UnitId();
    serializeCca(in.getRMessageVersion(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::ConfigurationStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o4;
    in >> o4;
    out.setE8ConfigurationStatus((::tcu_main_fi_types::T_e8_TCU_ConfigurationStatus)o4);
    uint8 o5;
    in >> o5;
    out.setU8UnitId(o5);
    deserializeCca(in, out.getRMessageVersionMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::DataTransmissionStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU8MPDTMuteState();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::DataTransmissionStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o6;
    in >> o6;
    out.setU8MPDTMuteState(o6);
}

void serializeCca(const ::tcu_main_fi::ECallRequestStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getBECallActive();
    out << (uint8) in.getBValid();
    out << (uint8) in.getBIsECallCallBackRequest();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::ECallRequestStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    bool o7;
    in >> o7;
    out.setBECallActive(o7);
    bool o8;
    in >> o8;
    out.setBValid(o8);
    bool o9;
    in >> o9;
    out.setBIsECallCallBackRequest(o9);
}

void serializeCca(const ::tcu_main_fi::ECallServiceStateStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8ECallServiceState();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::ECallServiceStateStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o10;
    in >> o10;
    out.setE8ECallServiceState((::tcu_main_fi_types::T_e8_TCU_ServiceState)o10);
}

void serializeCca(const ::tcu_main_fi::AcceptECallRequestStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getBECallAccepted();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::AcceptECallRequestStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    bool o11;
    in >> o11;
    out.setBECallAccepted(o11);
}

void serializeCca(const ::tcu_main_fi::ACNRequestStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getBACNActive();
    out << (uint8) in.getBValid();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::ACNRequestStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    bool o12;
    in >> o12;
    out.setBACNActive(o12);
    bool o13;
    in >> o13;
    out.setBValid(o13);
}

void serializeCca(const ::tcu_main_fi::ACNServiceStateStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8ACNServiceState();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::ACNServiceStateStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o14;
    in >> o14;
    out.setE8ACNServiceState((::tcu_main_fi_types::T_e8_TCU_ServiceState)o14);
}

void serializeCca(const ::tcu_main_fi::CurfewAlertStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8CurfewAlertWarning();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::CurfewAlertStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o15;
    in >> o15;
    out.setE8CurfewAlertWarning((::tcu_main_fi_types::T_e8_TCU_CurfewWarning)o15);
}

void serializeCca(const ::tcu_main_fi::GeoFenceStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getBStatusFromTCU();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::GeoFenceStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    bool o16;
    in >> o16;
    out.setBStatusFromTCU(o16);
}

void serializeCca(const ::tcu_main_fi::SpeedAlertStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getBStatusFromTCU();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SpeedAlertStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    bool o17;
    in >> o17;
    out.setBStatusFromTCU(o17);
}

void serializeCca(const ::tcu_main_fi::GetTCUStateErrorStructure& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getError();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::GetTCUStateErrorStructure& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o18;
    in >> o18;
    out.setError(o18);
}

void serializeCca(const ::tcu_main_fi::GetTCUStateError& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion)
{
    serializeCca (in.getCcaErrorCode(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::GetTCUStateError &out, unsigned int majorVersion)
{
    deserializeCca(in, out.getCcaErrorCodeMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::TCUStateStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8ModemStatus();
    out << (uint8) in.getE8TcuStatus();
    out << (uint8) in.getE8GSMStatus();
    out << in.getU8GSMRSSILevel();
    out << (uint8) in.getE8WifiStatus();
    out << (uint8) in.getE8WifiMode();
    out << (uint8) in.getE8WifiHotSpotStatus();
    out << (uint8) in.getE8WifiClientStatus();
    out << (uint8) in.getE8GSMDataMode();
    out << in.getU8WifiClientSSID();
    out << in.getU8WifiClientPower();
    out << (uint8) in.getE8Opcode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::TCUStateStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o19;
    in >> o19;
    out.setE8ModemStatus((::tcu_main_fi_types::T_e8_TCU_ModemStatus)o19);
    uint8 o20;
    in >> o20;
    out.setE8TcuStatus((::tcu_main_fi_types::T_e8_TCU_TCUStatus)o20);
    uint8 o21;
    in >> o21;
    out.setE8GSMStatus((::tcu_main_fi_types::T_e8_TCU_GSMStatus)o21);
    uint8 o22;
    in >> o22;
    out.setU8GSMRSSILevel(o22);
    uint8 o23;
    in >> o23;
    out.setE8WifiStatus((::tcu_main_fi_types::T_e8_TCU_WifiStatus)o23);
    uint8 o24;
    in >> o24;
    out.setE8WifiMode((::tcu_main_fi_types::T_e8_TCU_WifiMode)o24);
    uint8 o25;
    in >> o25;
    out.setE8WifiHotSpotStatus((::tcu_main_fi_types::T_e8_TCU_WifiHotSpotStatus)o25);
    uint8 o26;
    in >> o26;
    out.setE8WifiClientStatus((::tcu_main_fi_types::T_e8_TCU_WifiClientStatus)o26);
    uint8 o27;
    in >> o27;
    out.setE8GSMDataMode((::tcu_main_fi_types::T_e8_TCU_GSMDataMode)o27);
    uint8 o28;
    in >> o28;
    out.setU8WifiClientSSID(o28);
    uint8 o29;
    in >> o29;
    out.setU8WifiClientPower(o29);
    uint8 o30;
    in >> o30;
    out.setE8Opcode((::tcu_main_fi_types::T_e8_TCU_Opcode)o30);
}

void serializeCca(const ::tcu_main_fi::GetIDInfoStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getNaviId();
    out << in.getMapVersion();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::GetIDInfoStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o31;
    in >> o31;
    out.setNaviId(o31);
    ::std::string o32;
    in >> o32;
    out.setMapVersion(o32);
}

void serializeCca(const ::tcu_main_fi::GetIDInfoErrorStructure& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getError();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::GetIDInfoErrorStructure& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o33;
    in >> o33;
    out.setError(o33);
}

void serializeCca(const ::tcu_main_fi::GetIDInfoError& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion)
{
    serializeCca (in.getCcaErrorCode(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::GetIDInfoError &out, unsigned int majorVersion)
{
    deserializeCca(in, out.getCcaErrorCodeMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::IDInfoStatusStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8InvalidParameter();
    out << in.getSTCUID();
    out << in.getSICCID();
    out << in.getSVIN();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::IDInfoStatusStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o34;
    in >> o34;
    out.setE8InvalidParameter((::tcu_main_fi_types::T_e8_TCU_InvalidParameter)o34);
    ::std::string o35;
    in >> o35;
    out.setSTCUID(o35);
    ::std::string o36;
    in >> o36;
    out.setSICCID(o36);
    ::std::string o37;
    in >> o37;
    out.setSVIN(o37);
}

void serializeCca(const ::tcu_main_fi::SetDriverInfoUploadPermitStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8PermitSetting();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SetDriverInfoUploadPermitStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o38;
    in >> o38;
    out.setE8PermitSetting((::tcu_main_fi_types::T_e8_TCU_PermitSetting)o38);
}

void serializeCca(const ::tcu_main_fi::SetDriverInfoUploadPermitErrorStructure& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getError();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SetDriverInfoUploadPermitErrorStructure& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o39;
    in >> o39;
    out.setError(o39);
}

void serializeCca(const ::tcu_main_fi::SetDriverInfoUploadPermitError& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion)
{
    serializeCca (in.getCcaErrorCode(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SetDriverInfoUploadPermitError &out, unsigned int majorVersion)
{
    deserializeCca(in, out.getCcaErrorCodeMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::DriverInfoUploadPermitStatusStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8InvalidParameter();
    out << (uint8) in.getE8PermitSetting();
    out << (uint8) in.getBValid();
    out << (uint8) in.getE8AppContext();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::DriverInfoUploadPermitStatusStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o40;
    in >> o40;
    out.setE8InvalidParameter((::tcu_main_fi_types::T_e8_TCU_InvalidParameter)o40);
    uint8 o41;
    in >> o41;
    out.setE8PermitSetting((::tcu_main_fi_types::T_e8_TCU_PermitSetting)o41);
    bool o42;
    in >> o42;
    out.setBValid(o42);
    uint8 o43;
    in >> o43;
    out.setE8AppContext((::tcu_main_fi_types::T_e8_TCU_APP_Context)o43);
}

void serializeCca(const ::tcu_main_fi::SMSNotificationStatusStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8PopUpFlag();
    out << in.getU8ConnectingPoint();
    out << in.getU16InformationChannel();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SMSNotificationStatusStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o44;
    in >> o44;
    out.setE8PopUpFlag((::tcu_main_fi_types::T_e8_TCU_PopUpFlag)o44);
    uint8 o45;
    in >> o45;
    out.setU8ConnectingPoint(o45);
    uint16 o46;
    in >> o46;
    out.setU16InformationChannel(o46);
}

void serializeCca(const ::tcu_main_fi::GetProbeUploadPermitErrorStructure& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getError();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::GetProbeUploadPermitErrorStructure& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o47;
    in >> o47;
    out.setError(o47);
}

void serializeCca(const ::tcu_main_fi::GetProbeUploadPermitError& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion)
{
    serializeCca (in.getCcaErrorCode(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::GetProbeUploadPermitError &out, unsigned int majorVersion)
{
    deserializeCca(in, out.getCcaErrorCodeMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::SetProbeUploadPermitStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8ProbePermitSetting();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SetProbeUploadPermitStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o48;
    in >> o48;
    out.setE8ProbePermitSetting((::tcu_main_fi_types::T_e8_TCU_ProbePermitSetting)o48);
}

void serializeCca(const ::tcu_main_fi::SetProbeUploadPermitErrorStructure& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getError();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SetProbeUploadPermitErrorStructure& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o49;
    in >> o49;
    out.setError(o49);
}

void serializeCca(const ::tcu_main_fi::SetProbeUploadPermitError& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion)
{
    serializeCca (in.getCcaErrorCode(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SetProbeUploadPermitError &out, unsigned int majorVersion)
{
    deserializeCca(in, out.getCcaErrorCodeMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::ProbeUploadPermitStatusStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8InvalidParameter();
    out << (uint8) in.getE8ProbePermitSetting();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::ProbeUploadPermitStatusStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o50;
    in >> o50;
    out.setE8InvalidParameter((::tcu_main_fi_types::T_e8_TCU_InvalidParameter)o50);
    uint8 o51;
    in >> o51;
    out.setE8ProbePermitSetting((::tcu_main_fi_types::T_e8_TCU_ProbePermitSetting)o51);
}

void serializeCca(const ::tcu_main_fi::SetProbeInfoDeleteErrorStructure& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getError();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SetProbeInfoDeleteErrorStructure& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o52;
    in >> o52;
    out.setError(o52);
}

void serializeCca(const ::tcu_main_fi::SetProbeInfoDeleteError& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion)
{
    serializeCca (in.getCcaErrorCode(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SetProbeInfoDeleteError &out, unsigned int majorVersion)
{
    deserializeCca(in, out.getCcaErrorCodeMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::ProbeInfoDeleteStatusStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getBStatusFromTCU();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::ProbeInfoDeleteStatusStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    bool o53;
    in >> o53;
    out.setBStatusFromTCU(o53);
}

void serializeCca(const ::tcu_main_fi::ServiceCallStateStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8ServiceState();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::ServiceCallStateStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o54;
    in >> o54;
    out.setE8ServiceState((::tcu_main_fi_types::T_e8_TCU_ServiceState)o54);
}

void serializeCca(const ::tcu_main_fi::ServiceCallRequestStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getBServiceCallActive();
    out << (uint8) in.getBValid();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::ServiceCallRequestStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    bool o55;
    in >> o55;
    out.setBServiceCallActive(o55);
    bool o56;
    in >> o56;
    out.setBValid(o56);
}

void serializeCca(const ::tcu_main_fi::SetServiceCallOperationStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8OperationRequest();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SetServiceCallOperationStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o57;
    in >> o57;
    out.setE8OperationRequest((::tcu_main_fi_types::T_e8_TCU_OperationRequest)o57);
}

void serializeCca(const ::tcu_main_fi::SetServiceCallOperationErrorStructure& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getError();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SetServiceCallOperationErrorStructure& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o58;
    in >> o58;
    out.setError(o58);
}

void serializeCca(const ::tcu_main_fi::SetServiceCallOperationError& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion)
{
    serializeCca (in.getCcaErrorCode(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SetServiceCallOperationError &out, unsigned int majorVersion)
{
    deserializeCca(in, out.getCcaErrorCodeMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::TcuCallServiceStateStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8ACNCallServiceState();
    out << (uint8) in.getE8EmergencyCallServiceState();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::TcuCallServiceStateStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o59;
    in >> o59;
    out.setE8ACNCallServiceState((::tcu_main_fi_types::T_e8_TCU_ServiceState)o59);
    uint8 o60;
    in >> o60;
    out.setE8EmergencyCallServiceState((::tcu_main_fi_types::T_e8_TCU_ServiceState)o60);
}

void serializeCca(const ::tcu_main_fi::SetNaviInfoStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getRNaviData(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SetNaviInfoStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getRNaviDataMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::SetNaviInfoErrorStructure& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getError();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SetNaviInfoErrorStructure& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o61;
    in >> o61;
    out.setError(o61);
}

void serializeCca(const ::tcu_main_fi::SetNaviInfoError& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion)
{
    serializeCca (in.getCcaErrorCode(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SetNaviInfoError &out, unsigned int majorVersion)
{
    deserializeCca(in, out.getCcaErrorCodeMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::SetTripScoreInfoStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getRTripEcoScoreInfo(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SetTripScoreInfoStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getRTripEcoScoreInfoMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::SetTripScoreInfoErrorStructure& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getError();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SetTripScoreInfoErrorStructure& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o62;
    in >> o62;
    out.setError(o62);
}

void serializeCca(const ::tcu_main_fi::SetTripScoreInfoError& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion)
{
    serializeCca (in.getCcaErrorCode(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SetTripScoreInfoError &out, unsigned int majorVersion)
{
    deserializeCca(in, out.getCcaErrorCodeMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::SetProbeVehicleInfoStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getRProbeVehicleInfo(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SetProbeVehicleInfoStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getRProbeVehicleInfoMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::SetProbeVehicleInfoErrorStructure& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getError();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SetProbeVehicleInfoErrorStructure& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o63;
    in >> o63;
    out.setError(o63);
}

void serializeCca(const ::tcu_main_fi::SetProbeVehicleInfoError& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion)
{
    serializeCca (in.getCcaErrorCode(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SetProbeVehicleInfoError &out, unsigned int majorVersion)
{
    deserializeCca(in, out.getCcaErrorCodeMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::MaintenanceInfoStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getMaintenanceInfo(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::MaintenanceInfoStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getMaintenanceInfoMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::MaintenanceInfoErrorStructure& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getError();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::MaintenanceInfoErrorStructure& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o64;
    in >> o64;
    out.setError(o64);
}

void serializeCca(const ::tcu_main_fi::MaintenanceInfoError& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion)
{
    serializeCca (in.getCcaErrorCode(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::MaintenanceInfoError &out, unsigned int majorVersion)
{
    deserializeCca(in, out.getCcaErrorCodeMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::ProvisionServiceStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getProvisionService(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::ProvisionServiceStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getProvisionServiceMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::COMEcallStateStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8EcallStateDisplay();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::COMEcallStateStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o65;
    in >> o65;
    out.setE8EcallStateDisplay((::tcu_main_fi_types::T_e8_TCU_EcallStateDisplay)o65);
}

void serializeCca(const ::tcu_main_fi::COMEcallStartStatusErrorStructure& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getError();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::COMEcallStartStatusErrorStructure& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o66;
    in >> o66;
    out.setError(o66);
}

void serializeCca(const ::tcu_main_fi::COMEcallStartStatusError& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion)
{
    serializeCca (in.getCcaErrorCode(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::COMEcallStartStatusError &out, unsigned int majorVersion)
{
    deserializeCca(in, out.getCcaErrorCodeMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::SetTCUResetErrorStructure& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getError();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SetTCUResetErrorStructure& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o67;
    in >> o67;
    out.setError(o67);
}

void serializeCca(const ::tcu_main_fi::SetTCUResetError& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion)
{
    serializeCca (in.getCcaErrorCode(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SetTCUResetError &out, unsigned int majorVersion)
{
    deserializeCca(in, out.getCcaErrorCodeMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::TCUResetStatusStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getBStatusFromTCU();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::TCUResetStatusStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    bool o68;
    in >> o68;
    out.setBStatusFromTCU(o68);
}

void serializeCca(const ::tcu_main_fi::EmergencyStateStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getBEmergencyStateFromTCU();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::EmergencyStateStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    bool o69;
    in >> o69;
    out.setBEmergencyStateFromTCU(o69);
}

void serializeCca(const ::tcu_main_fi::TCUResponseTimeOutStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU8TcuResponseTimeOut();
    {
        uint32 o70 = static_cast<uint32>(in.getTcuResponseTimeOut().size());
        out << o70;
        ::std::vector< ::tcu_main_fi_types::T_e8_TCU_Response_Time_Out >::const_iterator o71;
        for (o71 = in.getTcuResponseTimeOut().begin(); o71 != in.getTcuResponseTimeOut().end(); ++o71) {
            out << (uint8) (*o71);
        }
    }
    out << (uint8) in.getBTcuServiceCallOperationSetTimeOut();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::TCUResponseTimeOutStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o72;
    in >> o72;
    out.setU8TcuResponseTimeOut(o72);
    {
        uint32 o73;
        in >> o73;
        out.getTcuResponseTimeOutMutable().clear ();
        out.getTcuResponseTimeOutMutable().reserve (o73);
        for (uint32 o74 = 0; o74 < o73; o74++) {
            uint8 o75;
            in >> o75;
            out.getTcuResponseTimeOutMutable().push_back((::tcu_main_fi_types::T_e8_TCU_Response_Time_Out) o75);
        }
    }
    bool o76;
    in >> o76;
    out.setBTcuServiceCallOperationSetTimeOut(o76);
}

void serializeCca(const ::tcu_main_fi::GetTCUExtendedStateErrorStructure& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getError();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::GetTCUExtendedStateErrorStructure& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o77;
    in >> o77;
    out.setError(o77);
}

void serializeCca(const ::tcu_main_fi::GetTCUExtendedStateError& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion)
{
    serializeCca (in.getCcaErrorCode(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::GetTCUExtendedStateError &out, unsigned int majorVersion)
{
    deserializeCca(in, out.getCcaErrorCodeMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::TCUExtendedStateStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8Invalid_Parameter();
    out << in.getSIMEINumber();
    out << in.getSICC_ID();
    out << in.getU16MCC();
    out << in.getU8MNC();
    out << in.getSMobile_Network_Name();
    out << (uint8) in.getE8RoamingStatus();
    out << (uint8) in.getE8PPP_Connection_Status();
    out << (uint8) in.getE8Opcode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::TCUExtendedStateStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o78;
    in >> o78;
    out.setE8Invalid_Parameter((::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter)o78);
    ::std::string o79;
    in >> o79;
    out.setSIMEINumber(o79);
    ::std::string o80;
    in >> o80;
    out.setSICC_ID(o80);
    uint16 o81;
    in >> o81;
    out.setU16MCC(o81);
    uint8 o82;
    in >> o82;
    out.setU8MNC(o82);
    ::std::string o83;
    in >> o83;
    out.setSMobile_Network_Name(o83);
    uint8 o84;
    in >> o84;
    out.setE8RoamingStatus((::tcu_main_fi_types::T_e8_TCU_RoamingStatus)o84);
    uint8 o85;
    in >> o85;
    out.setE8PPP_Connection_Status((::tcu_main_fi_types::T_e8_TCU_PPPConnectionStatus)o85);
    uint8 o86;
    in >> o86;
    out.setE8Opcode((::tcu_main_fi_types::T_e8_TCU_Opcode)o86);
}

void serializeCca(const ::tcu_main_fi::SetPINSettingStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getRPIN(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SetPINSettingStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getRPINMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::SetPINSettingErrorStructure& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getError();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SetPINSettingErrorStructure& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o87;
    in >> o87;
    out.setError(o87);
}

void serializeCca(const ::tcu_main_fi::SetPINSettingError& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion)
{
    serializeCca (in.getCcaErrorCode(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SetPINSettingError &out, unsigned int majorVersion)
{
    deserializeCca(in, out.getCcaErrorCodeMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::PINSettingStatusStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8Invalid_Parameter();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::PINSettingStatusStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o88;
    in >> o88;
    out.setE8Invalid_Parameter((::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter)o88);
}

void serializeCca(const ::tcu_main_fi::GetChargeReminderErrorStructure& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getError();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::GetChargeReminderErrorStructure& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o89;
    in >> o89;
    out.setError(o89);
}

void serializeCca(const ::tcu_main_fi::GetChargeReminderError& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion)
{
    serializeCca (in.getCcaErrorCode(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::GetChargeReminderError &out, unsigned int majorVersion)
{
    deserializeCca(in, out.getCcaErrorCodeMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::SetChargeReminderStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getRReminderInfo(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SetChargeReminderStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getRReminderInfoMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::SetChargeReminderErrorStructure& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getError();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SetChargeReminderErrorStructure& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o90;
    in >> o90;
    out.setError(o90);
}

void serializeCca(const ::tcu_main_fi::SetChargeReminderError& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion)
{
    serializeCca (in.getCcaErrorCode(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SetChargeReminderError &out, unsigned int majorVersion)
{
    deserializeCca(in, out.getCcaErrorCodeMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::ChargeReminderStatusStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getRReminderInfo(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::ChargeReminderStatusStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getRReminderInfoMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::ChargeRecordDeleteStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getRReminderInfo(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::ChargeRecordDeleteStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getRReminderInfoMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::GetStationFinderStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8ServiceType();
    out << in.getSCurrentCountry();
    serializeCca(in.getRSearch_GPS_Position(), out, majorVersion);
    out << (uint8) in.getE8ePOI_Type();
    serializeCca(in.getRSpot_Receptacle_Type(), out, majorVersion);
    out << in.getU16Vehicle_Autonomy();
    out << in.getU32BatteryIdentificationNumber();
    serializeCca(in.getRNavigation_Language(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::GetStationFinderStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o91;
    in >> o91;
    out.setE8ServiceType((::tcu_main_fi_types::T_e8_TCU_Service_Type)o91);
    ::std::string o92;
    in >> o92;
    out.setSCurrentCountry(o92);
    deserializeCca(in, out.getRSearch_GPS_PositionMutable(), majorVersion);
    uint8 o93;
    in >> o93;
    out.setE8ePOI_Type((::tcu_main_fi_types::T_e8_TCU_ePOI_Type)o93);
    deserializeCca(in, out.getRSpot_Receptacle_TypeMutable(), majorVersion);
    uint16 o94;
    in >> o94;
    out.setU16Vehicle_Autonomy(o94);
    uint32 o95;
    in >> o95;
    out.setU32BatteryIdentificationNumber(o95);
    deserializeCca(in, out.getRNavigation_LanguageMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::GetStationFinderErrorStructure& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getError();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::GetStationFinderErrorStructure& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o96;
    in >> o96;
    out.setError(o96);
}

void serializeCca(const ::tcu_main_fi::GetStationFinderError& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion)
{
    serializeCca (in.getCcaErrorCode(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::GetStationFinderError &out, unsigned int majorVersion)
{
    deserializeCca(in, out.getCcaErrorCodeMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::StationFinderStatusStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8Invalid_Parameter();
    out << (uint8) in.getE8FinderStatus();
    out << in.getU8Total_Station_Number();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::StationFinderStatusStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o97;
    in >> o97;
    out.setE8Invalid_Parameter((::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter)o97);
    uint8 o98;
    in >> o98;
    out.setE8FinderStatus((::tcu_main_fi_types::T_e8_TCU_Finder_Status)o98);
    uint8 o99;
    in >> o99;
    out.setU8Total_Station_Number(o99);
}

void serializeCca(const ::tcu_main_fi::GetChargeStationStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU8Station_List_Number();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::GetChargeStationStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o100;
    in >> o100;
    out.setU8Station_List_Number(o100);
}

void serializeCca(const ::tcu_main_fi::GetChargeStationErrorStructure& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getError();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::GetChargeStationErrorStructure& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o101;
    in >> o101;
    out.setError(o101);
}

void serializeCca(const ::tcu_main_fi::GetChargeStationError& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion)
{
    serializeCca (in.getCcaErrorCode(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::GetChargeStationError &out, unsigned int majorVersion)
{
    deserializeCca(in, out.getCcaErrorCodeMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::ChargeStationStatusStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU8Station_List_Number();
    out << in.getSCharge_Station_ID();
    serializeCca(in.getREPOI_GPS_Position(), out, majorVersion);
    out << in.getSEnergy_Provider_Name();
    out << in.getSUtility_Aggregator_ID();
    serializeCca(in.getRTime_Stamp(), out, majorVersion);
    out << in.getSPhone_Number();
    serializeCca(in.getROpening_Hour(), out, majorVersion);
    out << (uint8) in.getE8Charge_Station_Accessibility();
    out << (uint8) in.getE8Payment_Method_Type();
    out << in.getU8Spot_Total_Number();
    out << in.getU8Number_Available_Batteries();
    serializeCca(in.getRFull_Address(), out, majorVersion);
    out << in.getU8Charge_Staion_Ranking();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::ChargeStationStatusStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o102;
    in >> o102;
    out.setU8Station_List_Number(o102);
    ::std::string o103;
    in >> o103;
    out.setSCharge_Station_ID(o103);
    deserializeCca(in, out.getREPOI_GPS_PositionMutable(), majorVersion);
    ::std::string o104;
    in >> o104;
    out.setSEnergy_Provider_Name(o104);
    ::std::string o105;
    in >> o105;
    out.setSUtility_Aggregator_ID(o105);
    deserializeCca(in, out.getRTime_StampMutable(), majorVersion);
    ::std::string o106;
    in >> o106;
    out.setSPhone_Number(o106);
    deserializeCca(in, out.getROpening_HourMutable(), majorVersion);
    uint8 o107;
    in >> o107;
    out.setE8Charge_Station_Accessibility((::tcu_main_fi_types::T_TCU_Charge_Station_Accessibility)o107);
    uint8 o108;
    in >> o108;
    out.setE8Payment_Method_Type((::tcu_main_fi_types::T_TCU_Payment_Method_Type)o108);
    uint8 o109;
    in >> o109;
    out.setU8Spot_Total_Number(o109);
    uint8 o110;
    in >> o110;
    out.setU8Number_Available_Batteries(o110);
    deserializeCca(in, out.getRFull_AddressMutable(), majorVersion);
    uint8 o111;
    in >> o111;
    out.setU8Charge_Staion_Ranking(o111);
}

void serializeCca(const ::tcu_main_fi::GetChargeSpotListStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU8Station_List_Number();
    out << in.getU8Pages_Of_List();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::GetChargeSpotListStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o112;
    in >> o112;
    out.setU8Station_List_Number(o112);
    uint8 o113;
    in >> o113;
    out.setU8Pages_Of_List(o113);
}

void serializeCca(const ::tcu_main_fi::GetChargeSpotListErrorStructure& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getError();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::GetChargeSpotListErrorStructure& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o114;
    in >> o114;
    out.setError(o114);
}

void serializeCca(const ::tcu_main_fi::GetChargeSpotListError& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion)
{
    serializeCca (in.getCcaErrorCode(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::GetChargeSpotListError &out, unsigned int majorVersion)
{
    deserializeCca(in, out.getCcaErrorCodeMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::GetShortBookingStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getSCharge_Station_ID();
    out << in.getSCustomer_Contract_ID();
    out << (uint8) in.getE8ePOI_Type();
    out << (uint8) in.getE8Charge_Receptacle_Type();
    out << in.getSUtility_Aggregator_ID();
    out << in.getSCurrent_Country();
    out << in.getSCharge_Spot_ID();
    out << in.getU32Battery_Identification_Number();
    serializeCca(in.getRService_Time_Request(), out, majorVersion);
    serializeCca(in.getRNavigation_Language(), out, majorVersion);
    serializeCca(in.getRTime_Stamp(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::GetShortBookingStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o115;
    in >> o115;
    out.setSCharge_Station_ID(o115);
    ::std::string o116;
    in >> o116;
    out.setSCustomer_Contract_ID(o116);
    uint8 o117;
    in >> o117;
    out.setE8ePOI_Type((::tcu_main_fi_types::T_e8_TCU_ePOI_Type)o117);
    uint8 o118;
    in >> o118;
    out.setE8Charge_Receptacle_Type((::tcu_main_fi_types::T_e8_TCU_Charge_Receptacle_Type)o118);
    ::std::string o119;
    in >> o119;
    out.setSUtility_Aggregator_ID(o119);
    ::std::string o120;
    in >> o120;
    out.setSCurrent_Country(o120);
    ::std::string o121;
    in >> o121;
    out.setSCharge_Spot_ID(o121);
    uint32 o122;
    in >> o122;
    out.setU32Battery_Identification_Number(o122);
    deserializeCca(in, out.getRService_Time_RequestMutable(), majorVersion);
    deserializeCca(in, out.getRNavigation_LanguageMutable(), majorVersion);
    deserializeCca(in, out.getRTime_StampMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::GetShortBookingErrorStructure& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getError();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::GetShortBookingErrorStructure& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o123;
    in >> o123;
    out.setError(o123);
}

void serializeCca(const ::tcu_main_fi::GetShortBookingError& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion)
{
    serializeCca (in.getCcaErrorCode(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::GetShortBookingError &out, unsigned int majorVersion)
{
    deserializeCca(in, out.getCcaErrorCodeMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::Short_BookingStatusStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8InvalidParameter();
    out << (uint8) in.getE8Booking_Status();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::Short_BookingStatusStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o124;
    in >> o124;
    out.setE8InvalidParameter((::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter)o124);
    uint8 o125;
    in >> o125;
    out.setE8Booking_Status((::tcu_main_fi_types::T_e8_TCU_Booking_Status)o125);
}

void serializeCca(const ::tcu_main_fi::Short_BookingIndicationStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8Booking_Status();
    out << in.getSCharge_Station_ID();
    out << in.getSCharge_Spot_ID();
    out << (uint8) in.getE8Charge_Receptacle_Type();
    out << (uint8) in.getE8Charge_Receptacle_Facility_Byte();
    serializeCca(in.getRMax_Time_To_Arrive(), out, majorVersion);
    serializeCca(in.getRMax_Time_To_Unbook(), out, majorVersion);
    out << in.getSBooking_ID();
    serializeCca(in.getRBookable_Free_Text(), out, majorVersion);
    serializeCca(in.getRTime_Stamp(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::Short_BookingIndicationStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o126;
    in >> o126;
    out.setE8Booking_Status((::tcu_main_fi_types::T_e8_TCU_Booking_Status)o126);
    ::std::string o127;
    in >> o127;
    out.setSCharge_Station_ID(o127);
    ::std::string o128;
    in >> o128;
    out.setSCharge_Spot_ID(o128);
    uint8 o129;
    in >> o129;
    out.setE8Charge_Receptacle_Type((::tcu_main_fi_types::T_e8_TCU_Charge_Receptacle_Type)o129);
    uint8 o130;
    in >> o130;
    out.setE8Charge_Receptacle_Facility_Byte((::tcu_main_fi_types::T_e8_TCU_Charge_Receptacle_Facility)o130);
    deserializeCca(in, out.getRMax_Time_To_ArriveMutable(), majorVersion);
    deserializeCca(in, out.getRMax_Time_To_UnbookMutable(), majorVersion);
    ::std::string o131;
    in >> o131;
    out.setSBooking_ID(o131);
    deserializeCca(in, out.getRBookable_Free_TextMutable(), majorVersion);
    deserializeCca(in, out.getRTime_StampMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::GetShortUnbookingStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getSCustomer_Contract_ID();
    out << in.getSUtility_Aggregator_ID();
    out << in.getSCurrent_Country();
    out << in.getSCharge_Spot_ID();
    out << in.getSCharge_Station_ID();
    out << in.getSBooking_ID();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::GetShortUnbookingStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o132;
    in >> o132;
    out.setSCustomer_Contract_ID(o132);
    ::std::string o133;
    in >> o133;
    out.setSUtility_Aggregator_ID(o133);
    ::std::string o134;
    in >> o134;
    out.setSCurrent_Country(o134);
    ::std::string o135;
    in >> o135;
    out.setSCharge_Spot_ID(o135);
    ::std::string o136;
    in >> o136;
    out.setSCharge_Station_ID(o136);
    ::std::string o137;
    in >> o137;
    out.setSBooking_ID(o137);
}

void serializeCca(const ::tcu_main_fi::GetShortUnbookingErrorStructure& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getError();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::GetShortUnbookingErrorStructure& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o138;
    in >> o138;
    out.setError(o138);
}

void serializeCca(const ::tcu_main_fi::GetShortUnbookingError& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion)
{
    serializeCca (in.getCcaErrorCode(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::GetShortUnbookingError &out, unsigned int majorVersion)
{
    deserializeCca(in, out.getCcaErrorCodeMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::Short_UnbookingStatusStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8InvalidParameter();
    out << (uint8) in.getE8Unbooking_Status();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::Short_UnbookingStatusStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o139;
    in >> o139;
    out.setE8InvalidParameter((::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter)o139);
    uint8 o140;
    in >> o140;
    out.setE8Unbooking_Status((::tcu_main_fi_types::T_e8_TCU_Unbooking_Status)o140);
}

void serializeCca(const ::tcu_main_fi::Short_UnbookingIndicationStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getSCharge_Station_ID();
    out << in.getSCharge_Spot_ID();
    out << in.getSBooking_ID();
    out << (uint8) in.getE8Unbooking_Status();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::Short_UnbookingIndicationStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o141;
    in >> o141;
    out.setSCharge_Station_ID(o141);
    ::std::string o142;
    in >> o142;
    out.setSCharge_Spot_ID(o142);
    ::std::string o143;
    in >> o143;
    out.setSBooking_ID(o143);
    uint8 o144;
    in >> o144;
    out.setE8Unbooking_Status((::tcu_main_fi_types::T_e8_TCU_Unbooking_Status)o144);
}

void serializeCca(const ::tcu_main_fi::GetUpdateEnergyPointStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getSCurrent_Country();
    serializeCca(in.getREPOI_GPS_Position(), out, majorVersion);
    out << in.getSCharge_Station_ID();
    out << in.getSUtility_Aggregator_ID();
    out << in.getU32Battery_Identification_Number();
    serializeCca(in.getRNavigation_Language(), out, majorVersion);
    out << in.getSBooking_ID();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::GetUpdateEnergyPointStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o145;
    in >> o145;
    out.setSCurrent_Country(o145);
    deserializeCca(in, out.getREPOI_GPS_PositionMutable(), majorVersion);
    ::std::string o146;
    in >> o146;
    out.setSCharge_Station_ID(o146);
    ::std::string o147;
    in >> o147;
    out.setSUtility_Aggregator_ID(o147);
    uint32 o148;
    in >> o148;
    out.setU32Battery_Identification_Number(o148);
    deserializeCca(in, out.getRNavigation_LanguageMutable(), majorVersion);
    ::std::string o149;
    in >> o149;
    out.setSBooking_ID(o149);
}

void serializeCca(const ::tcu_main_fi::GetUpdateEnergyPointErrorStructure& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getError();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::GetUpdateEnergyPointErrorStructure& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o150;
    in >> o150;
    out.setError(o150);
}

void serializeCca(const ::tcu_main_fi::GetUpdateEnergyPointError& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion)
{
    serializeCca (in.getCcaErrorCode(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::GetUpdateEnergyPointError &out, unsigned int majorVersion)
{
    deserializeCca(in, out.getCcaErrorCodeMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::UpdateEnergyPointStatusStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8Invalid_Parameter();
    out << (uint8) in.getE8Update_Status();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::UpdateEnergyPointStatusStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o151;
    in >> o151;
    out.setE8Invalid_Parameter((::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter)o151);
    uint8 o152;
    in >> o152;
    out.setE8Update_Status((::tcu_main_fi_types::T_e8_TCU_Update_Status)o152);
}

void serializeCca(const ::tcu_main_fi::UpdateEnergyPointIndicationStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8Update_Status();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::UpdateEnergyPointIndicationStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o153;
    in >> o153;
    out.setE8Update_Status((::tcu_main_fi_types::T_e8_TCU_Update_Status)o153);
}

void serializeCca(const ::tcu_main_fi::SetSCH_ActivationStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8Sch_Activation_State();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SetSCH_ActivationStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o154;
    in >> o154;
    out.setE8Sch_Activation_State((::tcu_main_fi_types::T_e8_TCU_Sch_Activation_State)o154);
}

void serializeCca(const ::tcu_main_fi::SetSCH_ActivationErrorStructure& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getError();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SetSCH_ActivationErrorStructure& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o155;
    in >> o155;
    out.setError(o155);
}

void serializeCca(const ::tcu_main_fi::SetSCH_ActivationError& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion)
{
    serializeCca (in.getCcaErrorCode(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SetSCH_ActivationError &out, unsigned int majorVersion)
{
    deserializeCca(in, out.getCcaErrorCodeMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::SCH_ActivationStatusStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8Invalid_Parameter();
    out << (uint8) in.getE8Sch_Activation_State();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SCH_ActivationStatusStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o156;
    in >> o156;
    out.setE8Invalid_Parameter((::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter)o156);
    uint8 o157;
    in >> o157;
    out.setE8Sch_Activation_State((::tcu_main_fi_types::T_e8_TCU_Sch_Activation_State)o157);
}

void serializeCca(const ::tcu_main_fi::SetSCH_Update_ONBOARDStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getRCharge_Day1_7_Start(), out, majorVersion);
    serializeCca(in.getRCharge_Day1_7_End(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SetSCH_Update_ONBOARDStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getRCharge_Day1_7_StartMutable(), majorVersion);
    deserializeCca(in, out.getRCharge_Day1_7_EndMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::SetSCH_Update_ONBOARDErrorStructure& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getError();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SetSCH_Update_ONBOARDErrorStructure& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o158;
    in >> o158;
    out.setError(o158);
}

void serializeCca(const ::tcu_main_fi::SetSCH_Update_ONBOARDError& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion)
{
    serializeCca (in.getCcaErrorCode(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SetSCH_Update_ONBOARDError &out, unsigned int majorVersion)
{
    deserializeCca(in, out.getCcaErrorCodeMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::SCH_Update_ONBOARDStatusStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8Invalid_Parameter();
    serializeCca(in.getRCharge_Day1_7_Start(), out, majorVersion);
    serializeCca(in.getRCharge_Day1_7_End(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SCH_Update_ONBOARDStatusStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o159;
    in >> o159;
    out.setE8Invalid_Parameter((::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter)o159);
    deserializeCca(in, out.getRCharge_Day1_7_StartMutable(), majorVersion);
    deserializeCca(in, out.getRCharge_Day1_7_EndMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::Charge_BlockedIndicationStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8Charge_Blocked_Status();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::Charge_BlockedIndicationStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o160;
    in >> o160;
    out.setE8Charge_Blocked_Status((::tcu_main_fi_types::T_e8_TCU_Charge_Blocked_Status)o160);
}

void serializeCca(const ::tcu_main_fi::GetSCH_StateErrorStructure& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getError();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::GetSCH_StateErrorStructure& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o161;
    in >> o161;
    out.setError(o161);
}

void serializeCca(const ::tcu_main_fi::GetSCH_StateError& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion)
{
    serializeCca (in.getCcaErrorCode(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::GetSCH_StateError &out, unsigned int majorVersion)
{
    deserializeCca(in, out.getCcaErrorCodeMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::SCH_StateStatusStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8Invalid_Parameter();
    out << (uint8) in.getE8Sch_Activation_State();
    serializeCca(in.getRCharge_Day1_7_Start(), out, majorVersion);
    serializeCca(in.getRCharge_Day1_7_End(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SCH_StateStatusStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o162;
    in >> o162;
    out.setE8Invalid_Parameter((::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter)o162);
    uint8 o163;
    in >> o163;
    out.setE8Sch_Activation_State((::tcu_main_fi_types::T_e8_TCU_Sch_Activation_State)o163);
    deserializeCca(in, out.getRCharge_Day1_7_StartMutable(), majorVersion);
    deserializeCca(in, out.getRCharge_Day1_7_EndMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::SCH_StateIndicationStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8Sch_Activation_State();
    serializeCca(in.getRCharge_Day1_7_Start(), out, majorVersion);
    serializeCca(in.getRCharge_Day1_7_End(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SCH_StateIndicationStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o164;
    in >> o164;
    out.setE8Sch_Activation_State((::tcu_main_fi_types::T_e8_TCU_Sch_Activation_State)o164);
    deserializeCca(in, out.getRCharge_Day1_7_StartMutable(), majorVersion);
    deserializeCca(in, out.getRCharge_Day1_7_EndMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::StationFinderIndicationStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8FinderStatus();
    out << in.getU8Total_Station_Number();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::StationFinderIndicationStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o165;
    in >> o165;
    out.setE8FinderStatus((::tcu_main_fi_types::T_e8_TCU_Finder_Status)o165);
    uint8 o166;
    in >> o166;
    out.setU8Total_Station_Number(o166);
}

void serializeCca(const ::tcu_main_fi::ChargeSpotListStatusStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8InvalidParameter();
    serializeCca(in.getRChargeSpotList(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::ChargeSpotListStatusStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o167;
    in >> o167;
    out.setE8InvalidParameter((::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter)o167);
    deserializeCca(in, out.getRChargeSpotListMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::SetWifiHotSpotRequestStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getRWifi_SSID_Name(), out, majorVersion);
    serializeCca(in.getRWifi_PassKey(), out, majorVersion);
    out << (uint8) in.getE8Wifi_Security_Mode();
    out << in.getU8Wifi_Channel_Number();
    out << (uint8) in.getE8Wifi_Visibility();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SetWifiHotSpotRequestStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getRWifi_SSID_NameMutable(), majorVersion);
    deserializeCca(in, out.getRWifi_PassKeyMutable(), majorVersion);
    uint8 o168;
    in >> o168;
    out.setE8Wifi_Security_Mode((::tcu_main_fi_types::T_e8_TCU_Wifi_Security_Mode)o168);
    uint8 o169;
    in >> o169;
    out.setU8Wifi_Channel_Number(o169);
    uint8 o170;
    in >> o170;
    out.setE8Wifi_Visibility((::tcu_main_fi_types::T_e8_TCU_Wifi_Visibility)o170);
}

void serializeCca(const ::tcu_main_fi::SetWifiHotSpotRequestErrorStructure& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getError();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SetWifiHotSpotRequestErrorStructure& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o171;
    in >> o171;
    out.setError(o171);
}

void serializeCca(const ::tcu_main_fi::SetWifiHotSpotRequestError& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion)
{
    serializeCca (in.getCcaErrorCode(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SetWifiHotSpotRequestError &out, unsigned int majorVersion)
{
    deserializeCca(in, out.getCcaErrorCodeMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::WifiHotSpotRequestIndicationStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getRWifi_SSID_Name(), out, majorVersion);
    serializeCca(in.getRWifi_PassKey(), out, majorVersion);
    out << (uint8) in.getE8Wifi_Security_Mode();
    out << in.getU8Wifi_Channel_Number();
    out << (uint8) in.getE8Wifi_Visibility();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::WifiHotSpotRequestIndicationStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getRWifi_SSID_NameMutable(), majorVersion);
    deserializeCca(in, out.getRWifi_PassKeyMutable(), majorVersion);
    uint8 o172;
    in >> o172;
    out.setE8Wifi_Security_Mode((::tcu_main_fi_types::T_e8_TCU_Wifi_Security_Mode)o172);
    uint8 o173;
    in >> o173;
    out.setU8Wifi_Channel_Number(o173);
    uint8 o174;
    in >> o174;
    out.setE8Wifi_Visibility((::tcu_main_fi_types::T_e8_TCU_Wifi_Visibility)o174);
}

void serializeCca(const ::tcu_main_fi::WifiHotSpotRequestStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8Invalid_Parameter();
    serializeCca(in.getRWifi_SSID_Name(), out, majorVersion);
    serializeCca(in.getRWifi_PassKey(), out, majorVersion);
    out << (uint8) in.getE8Wifi_Security_Mode();
    out << in.getU8Wifi_Channel_Number();
    out << (uint8) in.getE8Wifi_Visibility();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::WifiHotSpotRequestStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o175;
    in >> o175;
    out.setE8Invalid_Parameter((::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter)o175);
    deserializeCca(in, out.getRWifi_SSID_NameMutable(), majorVersion);
    deserializeCca(in, out.getRWifi_PassKeyMutable(), majorVersion);
    uint8 o176;
    in >> o176;
    out.setE8Wifi_Security_Mode((::tcu_main_fi_types::T_e8_TCU_Wifi_Security_Mode)o176);
    uint8 o177;
    in >> o177;
    out.setU8Wifi_Channel_Number(o177);
    uint8 o178;
    in >> o178;
    out.setE8Wifi_Visibility((::tcu_main_fi_types::T_e8_TCU_Wifi_Visibility)o178);
}

void serializeCca(const ::tcu_main_fi::SetWifiActivationRequestStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8Wifi_Status();
    out << (uint8) in.getE8Wifi_Mode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SetWifiActivationRequestStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o179;
    in >> o179;
    out.setE8Wifi_Status((::tcu_main_fi_types::T_e8_TCU_Wifi_Status)o179);
    uint8 o180;
    in >> o180;
    out.setE8Wifi_Mode((::tcu_main_fi_types::T_e8_TCU_Wifi_Mode)o180);
}

void serializeCca(const ::tcu_main_fi::SetWifiActivationRequestErrorStructure& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getError();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SetWifiActivationRequestErrorStructure& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o181;
    in >> o181;
    out.setError(o181);
}

void serializeCca(const ::tcu_main_fi::SetWifiActivationRequestError& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion)
{
    serializeCca (in.getCcaErrorCode(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SetWifiActivationRequestError &out, unsigned int majorVersion)
{
    deserializeCca(in, out.getCcaErrorCodeMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::WifiActivationRequestStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8Invalid_Parameter();
    out << (uint8) in.getE8Wifi_Status();
    out << (uint8) in.getE8Wifi_Mode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::WifiActivationRequestStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o182;
    in >> o182;
    out.setE8Invalid_Parameter((::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter)o182);
    uint8 o183;
    in >> o183;
    out.setE8Wifi_Status((::tcu_main_fi_types::T_e8_TCU_Wifi_Status)o183);
    uint8 o184;
    in >> o184;
    out.setE8Wifi_Mode((::tcu_main_fi_types::T_e8_TCU_Wifi_Mode)o184);
}

void serializeCca(const ::tcu_main_fi::SetWifiDataResetErrorStructure& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getError();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SetWifiDataResetErrorStructure& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o185;
    in >> o185;
    out.setError(o185);
}

void serializeCca(const ::tcu_main_fi::SetWifiDataResetError& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion)
{
    serializeCca (in.getCcaErrorCode(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SetWifiDataResetError &out, unsigned int majorVersion)
{
    deserializeCca(in, out.getCcaErrorCodeMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::WifiDataResetStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getRWifi_SSID_Name(), out, majorVersion);
    serializeCca(in.getRWifi_PassKey(), out, majorVersion);
    out << (uint8) in.getE8Wifi_Security_Mode();
    out << in.getU8Wifi_Channel_Number();
    out << (uint8) in.getE8Wifi_Visibility();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::WifiDataResetStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getRWifi_SSID_NameMutable(), majorVersion);
    deserializeCca(in, out.getRWifi_PassKeyMutable(), majorVersion);
    uint8 o186;
    in >> o186;
    out.setE8Wifi_Security_Mode((::tcu_main_fi_types::T_e8_TCU_Wifi_Security_Mode)o186);
    uint8 o187;
    in >> o187;
    out.setU8Wifi_Channel_Number(o187);
    uint8 o188;
    in >> o188;
    out.setE8Wifi_Visibility((::tcu_main_fi_types::T_e8_TCU_Wifi_Visibility)o188);
}

void serializeCca(const ::tcu_main_fi::SetWifiClientScanErrorStructure& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getError();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SetWifiClientScanErrorStructure& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o189;
    in >> o189;
    out.setError(o189);
}

void serializeCca(const ::tcu_main_fi::SetWifiClientScanError& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion)
{
    serializeCca (in.getCcaErrorCode(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SetWifiClientScanError &out, unsigned int majorVersion)
{
    deserializeCca(in, out.getCcaErrorCodeMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::SetWifiClientConnectionStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getRWifi_Scan_SSID_Name(), out, majorVersion);
    serializeCca(in.getRWifi_PassKey(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SetWifiClientConnectionStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getRWifi_Scan_SSID_NameMutable(), majorVersion);
    deserializeCca(in, out.getRWifi_PassKeyMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::SetWifiClientConnectionErrorStructure& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getError();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SetWifiClientConnectionErrorStructure& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o190;
    in >> o190;
    out.setError(o190);
}

void serializeCca(const ::tcu_main_fi::SetWifiClientConnectionError& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion)
{
    serializeCca (in.getCcaErrorCode(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SetWifiClientConnectionError &out, unsigned int majorVersion)
{
    deserializeCca(in, out.getCcaErrorCodeMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::WifiClientConnectionStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8Invalid_Parameter();
    serializeCca(in.getRWifi_Scan_SSID_Name(), out, majorVersion);
    out << (uint8) in.getE8Wifi_Connection_Status();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::WifiClientConnectionStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o191;
    in >> o191;
    out.setE8Invalid_Parameter((::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter)o191);
    deserializeCca(in, out.getRWifi_Scan_SSID_NameMutable(), majorVersion);
    uint8 o192;
    in >> o192;
    out.setE8Wifi_Connection_Status((::tcu_main_fi_types::T_e8_TCU_Wifi_Connection_Status)o192);
}

void serializeCca(const ::tcu_main_fi::WifiClientConnectionIndicationStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getRWifi_Scan_SSID_Name(), out, majorVersion);
    out << (uint8) in.getE8Wifi_Connection_Status();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::WifiClientConnectionIndicationStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getRWifi_Scan_SSID_NameMutable(), majorVersion);
    uint8 o193;
    in >> o193;
    out.setE8Wifi_Connection_Status((::tcu_main_fi_types::T_e8_TCU_Wifi_Connection_Status)o193);
}

void serializeCca(const ::tcu_main_fi::SetWifiClientDisconnectionErrorStructure& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getError();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SetWifiClientDisconnectionErrorStructure& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o194;
    in >> o194;
    out.setError(o194);
}

void serializeCca(const ::tcu_main_fi::SetWifiClientDisconnectionError& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion)
{
    serializeCca (in.getCcaErrorCode(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SetWifiClientDisconnectionError &out, unsigned int majorVersion)
{
    deserializeCca(in, out.getCcaErrorCodeMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::WifiClientScanResultIndicationStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getRWifi_Scan_SSID_Name(), out, majorVersion);
    out << in.getU8Wifi_Scan_Power();
    out << (uint8) in.getE8Wifi_Scan_Security();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::WifiClientScanResultIndicationStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getRWifi_Scan_SSID_NameMutable(), majorVersion);
    uint8 o195;
    in >> o195;
    out.setU8Wifi_Scan_Power(o195);
    uint8 o196;
    in >> o196;
    out.setE8Wifi_Scan_Security((::tcu_main_fi_types::T_e8_TCU_Wifi_Wifi_Scan_Security)o196);
}

void serializeCca(const ::tcu_main_fi::GetWifiConnectedDevicesRequestErrorStructure& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getError();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::GetWifiConnectedDevicesRequestErrorStructure& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o197;
    in >> o197;
    out.setError(o197);
}

void serializeCca(const ::tcu_main_fi::GetWifiConnectedDevicesRequestError& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion)
{
    serializeCca (in.getCcaErrorCode(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::GetWifiConnectedDevicesRequestError &out, unsigned int majorVersion)
{
    deserializeCca(in, out.getCcaErrorCodeMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::WifiConnectedDevicesRequestStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU8Wifi_Connected_Devices();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::WifiConnectedDevicesRequestStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o198;
    in >> o198;
    out.setU8Wifi_Connected_Devices(o198);
}

void serializeCca(const ::tcu_main_fi::GetWifiClientStateErrorStructure& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getError();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::GetWifiClientStateErrorStructure& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o199;
    in >> o199;
    out.setError(o199);
}

void serializeCca(const ::tcu_main_fi::GetWifiClientStateError& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion)
{
    serializeCca (in.getCcaErrorCode(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::GetWifiClientStateError &out, unsigned int majorVersion)
{
    deserializeCca(in, out.getCcaErrorCodeMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::WifiClientStateStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8Wifi_Client_Status();
    serializeCca(in.getRWifi_SSID(), out, majorVersion);
    out << in.getU8Wifi_Client_Power();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::WifiClientStateStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o200;
    in >> o200;
    out.setE8Wifi_Client_Status((::tcu_main_fi_types::T_e8_TCU_Wifi_Wifi_Client_Status)o200);
    deserializeCca(in, out.getRWifi_SSIDMutable(), majorVersion);
    uint8 o201;
    in >> o201;
    out.setU8Wifi_Client_Power(o201);
}

void serializeCca(const ::tcu_main_fi::WifiClientStateIndicationStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8Wifi_Client_Status();
    serializeCca(in.getRWifi_SSID(), out, majorVersion);
    out << in.getU8Wifi_Client_Power();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::WifiClientStateIndicationStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o202;
    in >> o202;
    out.setE8Wifi_Client_Status((::tcu_main_fi_types::T_e8_TCU_Wifi_Wifi_Client_Status)o202);
    deserializeCca(in, out.getRWifi_SSIDMutable(), majorVersion);
    uint8 o203;
    in >> o203;
    out.setU8Wifi_Client_Power(o203);
}

void serializeCca(const ::tcu_main_fi::DTMEcallStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8SourceActivity();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::DTMEcallStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o204;
    in >> o204;
    out.setE8SourceActivity((::tcu_main_fi_types::T_e8_TCU_Audio_SourceActivity)o204);
}

void serializeCca(const ::tcu_main_fi::DTMEcallErrorStructure& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getError();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::DTMEcallErrorStructure& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o205;
    in >> o205;
    out.setError(o205);
}

void serializeCca(const ::tcu_main_fi::DTMEcallError& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion)
{
    serializeCca (in.getCcaErrorCode(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::DTMEcallError &out, unsigned int majorVersion)
{
    deserializeCca(in, out.getCcaErrorCodeMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::HardwareVersionStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getRHardwareVersion(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::HardwareVersionStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getRHardwareVersionMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::SoftwareVersionStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getRSoftwareVersion(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SoftwareVersionStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getRSoftwareVersionMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::Push_POIStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getBValid();
    out << in.getU32POI_ID();
    serializeCca(in.getRPOI_GPS_Position(), out, majorVersion);
    out << in.getSPOI_Name();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::Push_POIStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    bool o206;
    in >> o206;
    out.setBValid(o206);
    uint32 o207;
    in >> o207;
    out.setU32POI_ID(o207);
    deserializeCca(in, out.getRPOI_GPS_PositionMutable(), majorVersion);
    ::std::string o208;
    in >> o208;
    out.setSPOI_Name(o208);
}

void serializeCca(const ::tcu_main_fi::SetPush_POIStatusStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8InvalidParmeter();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SetPush_POIStatusStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o209;
    in >> o209;
    out.setE8InvalidParmeter((::tcu_main_fi_types::T_e8_TCU_InvalidParameter)o209);
}

void serializeCca(const ::tcu_main_fi::Time_LimitStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getBValid();
    serializeCca(in.getRTime_Slot(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::Time_LimitStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    bool o210;
    in >> o210;
    out.setBValid(o210);
    deserializeCca(in, out.getRTime_SlotMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::Speed_LimitStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getBValid();
    out << in.getU16Limited_Vehicle_Speed();
    serializeCca(in.getRTime_Slot(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::Speed_LimitStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    bool o211;
    in >> o211;
    out.setBValid(o211);
    uint16 o212;
    in >> o212;
    out.setU16Limited_Vehicle_Speed(o212);
    deserializeCca(in, out.getRTime_SlotMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::Area_LimitStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getBValid();
    serializeCca(in.getRArea_Limit_Coordinates(), out, majorVersion);
    serializeCca(in.getRTime_Slot(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::Area_LimitStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    bool o213;
    in >> o213;
    out.setBValid(o213);
    deserializeCca(in, out.getRArea_Limit_CoordinatesMutable(), majorVersion);
    deserializeCca(in, out.getRTime_SlotMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::Geofencing_ActivationStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getBValid();
    out << in.getU8Geofencing_Activation_State();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::Geofencing_ActivationStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    bool o214;
    in >> o214;
    out.setBValid(o214);
    uint8 o215;
    in >> o215;
    out.setU8Geofencing_Activation_State(o215);
}

void serializeCca(const ::tcu_main_fi::SetGeofencing_ActivationStatusStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8InvalidParmeter();
    out << in.getU8Geofencing_Activation_State();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SetGeofencing_ActivationStatusStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o216;
    in >> o216;
    out.setE8InvalidParmeter((::tcu_main_fi_types::T_e8_TCU_InvalidParameter)o216);
    uint8 o217;
    in >> o217;
    out.setU8Geofencing_Activation_State(o217);
}

void serializeCca(const ::tcu_main_fi::GetRestriction_SettingsErrorStructure& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getError();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::GetRestriction_SettingsErrorStructure& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o218;
    in >> o218;
    out.setError(o218);
}

void serializeCca(const ::tcu_main_fi::GetRestriction_SettingsError& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion)
{
    serializeCca (in.getCcaErrorCode(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::GetRestriction_SettingsError &out, unsigned int majorVersion)
{
    deserializeCca(in, out.getCcaErrorCodeMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::Restriction_SettingsStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getBValid();
    {
        uint32 o219 = static_cast<uint32>(in.getRTime_Limit_Restriction().size());
        out << o219;
        ::std::vector< ::tcu_main_fi_types::T_TCU_Time_Slot >::const_iterator o220;
        for (o220 = in.getRTime_Limit_Restriction().begin(); o220 != in.getRTime_Limit_Restriction().end(); ++o220) {
            serializeCca((*o220), out, majorVersion);
        }
    }
    serializeCca(in.getRSpeed_Limit_Restriction(), out, majorVersion);
    serializeCca(in.getRArea_Limit_Restriction(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::Restriction_SettingsStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    bool o221;
    in >> o221;
    out.setBValid(o221);
    {
        uint32 o222;
        in >> o222;
        out.getRTime_Limit_RestrictionMutable().clear ();
        out.getRTime_Limit_RestrictionMutable().reserve (o222);
        for (uint32 o223 = 0; o223 < o222; o223++) {
            ::tcu_main_fi_types::T_TCU_Time_Slot o224;
            deserializeCca(in, o224, majorVersion);
            out.getRTime_Limit_RestrictionMutable().push_back (o224);
        }
    }
    deserializeCca(in, out.getRSpeed_Limit_RestrictionMutable(), majorVersion);
    deserializeCca(in, out.getRArea_Limit_RestrictionMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::Connection_Setup_StatusStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8ConnectionType();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::Connection_Setup_StatusStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o225;
    in >> o225;
    out.setE8ConnectionType((::tcu_main_fi_types::T_e8_TCU_ConnectionType)o225);
}

void serializeCca(const ::tcu_main_fi::XCallStartStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8XCallType();
    out << (uint8) in.getE8XCallLanguage();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::XCallStartStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o226;
    in >> o226;
    out.setE8XCallType((::tcu_main_fi_types::T_e8_TCU_XCALL_Type)o226);
    uint8 o227;
    in >> o227;
    out.setE8XCallLanguage((::tcu_main_fi_types::T_e8_TCU_XCALL_Language)o227);
}

void serializeCca(const ::tcu_main_fi::XCallStartErrorStructure& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getError();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::XCallStartErrorStructure& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o228;
    in >> o228;
    out.setError(o228);
}

void serializeCca(const ::tcu_main_fi::XCallStartError& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion)
{
    serializeCca (in.getCcaErrorCode(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::XCallStartError &out, unsigned int majorVersion)
{
    deserializeCca(in, out.getCcaErrorCodeMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::XCallStatusStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8InvalidParameter();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::XCallStatusStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o229;
    in >> o229;
    out.setE8InvalidParameter((::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter)o229);
}

void serializeCca(const ::tcu_main_fi::XCallStateStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8XCallState();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::XCallStateStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o230;
    in >> o230;
    out.setE8XCallState((::tcu_main_fi_types::T_e8_TCU_ServiceState)o230);
}

void serializeCca(const ::tcu_main_fi::CallDuartionStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getBIsValid();
    out << (uint8) in.getRCallType();
    serializeCca(in.getRCallDuartion(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::CallDuartionStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    bool o231;
    in >> o231;
    out.setBIsValid(o231);
    uint8 o232;
    in >> o232;
    out.setRCallType((::tcu_main_fi_types::T_e8_TCU_CallType)o232);
    deserializeCca(in, out.getRCallDuartionMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi::PrivacyModeActivationStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getBIsValid();
    out << (uint8) in.getE8InvalidParameter();
    out << (uint8) in.getE8PrivacyMode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::PrivacyModeActivationStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    bool o233;
    in >> o233;
    out.setBIsValid(o233);
    uint8 o234;
    in >> o234;
    out.setE8InvalidParameter((::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter)o234);
    uint8 o235;
    in >> o235;
    out.setE8PrivacyMode((::tcu_main_fi_types::T_e8_TCU_PrivacyModes)o235);
}

void serializeCca(const ::tcu_main_fi::SetPrivicyModeStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8PrivacyMode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::SetPrivicyModeStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o236;
    in >> o236;
    out.setE8PrivacyMode((::tcu_main_fi_types::T_e8_TCU_PrivacyModes)o236);
}

void serializeCca(const ::tcu_main_fi::GetTCUConfigurationStatusResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getRTCU_CurrentAvailabilityConfiguration();
    out << (uint8) in.getBAutoConfigured();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::GetTCUConfigurationStatusResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o237;
    in >> o237;
    out.setRTCU_CurrentAvailabilityConfiguration((::tcu_main_fi_types::T_e8_TCU_Availability)o237);
    bool o238;
    in >> o238;
    out.setBAutoConfigured(o238);
}

void serializeCca(const ::tcu_main_fi::TCUConfigurationStatusStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getRTCU_CurrentAvailabilityConfiguration();
    out << (uint8) in.getBAutoConfigured();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi::TCUConfigurationStatusStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o239;
    in >> o239;
    out.setRTCU_CurrentAvailabilityConfiguration((::tcu_main_fi_types::T_e8_TCU_Availability)o239);
    bool o240;
    in >> o240;
    out.setBAutoConfigured(o240);
}

