#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef TCU_MAIN_FI_H
#define TCU_MAIN_FI_H

#include "asf/cca/CcaTypes.h"
#include "asf/cca/CcaTypesConst.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "tcu_main_fi_types.h"
#include "tcu_main_fi_typesConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * CCA Functional Interface 'tcu_main_fi'
 *
 * Fullname: MCAN TCU Application Functional Interface
 *
 * Version: $Revision:   1.0.0 $
 *
 * Author:  Telmatics MCAN Midw Team
 *
 * Date: $Date:  13.03.2017  $
 *
 * Department:
 *
 * Title: tcu_main_fi
 *
 * <b>Description of 'tcu_main_fi':</b>
 *
 * ..
 */

namespace tcu_main_fi {

static const int SERVICE_ID = 163;

static const int FID_Connection = 1;

static const int FID_Configuration = 2;

static const int FID_DataTransmission = 5;

static const int FID_ECallRequest = 6;

static const int FID_ECallServiceState = 7;

static const int FID_AcceptECallRequest = 8193;

static const int FID_ECallCancellationOrder = 8245;

static const int FID_ACNRequest = 8;

static const int FID_ACNServiceState = 9;

static const int FID_CurfewAlert = 10;

static const int FID_GeoFence = 11;

static const int FID_SpeedAlert = 12;

static const int FID_GetTCUState = 8194;

static const int FID_TCUState = 13;

static const int FID_GetIDInfo = 8195;

static const int FID_IDInfoStatus = 14;

static const int FID_SetDriverInfoUploadPermit = 8196;

static const int FID_DriverInfoUploadPermitStatus = 15;

static const int FID_SMSNotificationStatus = 26;

static const int FID_GetProbeUploadPermit = 8197;

static const int FID_SetProbeUploadPermit = 8198;

static const int FID_ProbeUploadPermitStatus = 27;

static const int FID_SetProbeInfoDelete = 8199;

static const int FID_ProbeInfoDeleteStatus = 28;

static const int FID_ServiceCallState = 29;

static const int FID_ServiceCallRequest = 30;

static const int FID_SetServiceCallOperation = 8200;

static const int FID_ServiceCallOperationStatus = 31;

static const int FID_TcuCallServiceState = 46;

static const int FID_SetNaviInfo = 8209;

static const int FID_SetTripScoreInfo = 8210;

static const int FID_SetProbeVehicleInfo = 8211;

static const int FID_MaintenanceInfo = 8212;

static const int FID_ProvisionService = 42;

static const int FID_COMEcallState = 43;

static const int FID_COMEcallStart = 44;

static const int FID_COMEcallStartStatus = 8213;

static const int FID_COMEcallEnd = 45;

static const int FID_SetTCUReset = 8214;

static const int FID_TCUResetStatus = 47;

static const int FID_EmergencyState = 48;

static const int FID_TCUResponseTimeOut = 49;

static const int FID_GetTCUExtendedState = 8215;

static const int FID_TCUExtendedState = 50;

static const int FID_SetPINSetting = 8216;

static const int FID_PINSettingStatus = 51;

static const int FID_GetChargeReminder = 8217;

static const int FID_SetChargeReminder = 8218;

static const int FID_ChargeReminderStatus = 52;

static const int FID_ChargeRecordDelete = 53;

static const int FID_GetStationFinder = 8219;

static const int FID_StationFinderStatus = 54;

static const int FID_GetChargeStation = 8220;

static const int FID_ChargeStationStatus = 55;

static const int FID_GetChargeSpotList = 8221;

static const int FID_GetShortBooking = 8222;

static const int FID_Short_BookingStatus = 56;

static const int FID_Short_BookingIndication = 57;

static const int FID_GetShortUnbooking = 8223;

static const int FID_Short_UnbookingStatus = 58;

static const int FID_Short_UnbookingIndication = 59;

static const int FID_GetUpdateEnergyPoint = 8224;

static const int FID_UpdateEnergyPointStatus = 60;

static const int FID_UpdateEnergyPointIndication = 61;

static const int FID_SetSCH_Activation = 8225;

static const int FID_SCH_ActivationStatus = 62;

static const int FID_SetSCH_Update_ONBOARD = 8226;

static const int FID_SCH_Update_ONBOARDStatus = 63;

static const int FID_Charge_BlockedIndication = 64;

static const int FID_GetSCH_State = 8227;

static const int FID_SCH_StateStatus = 65;

static const int FID_SCH_StateIndication = 66;

static const int FID_StationFinderIndication = 67;

static const int FID_ChargeSpotListStatus = 68;

static const int FID_SetWifiHotSpotRequest = 8228;

static const int FID_WifiHotSpotRequestIndication = 70;

static const int FID_WifiHotSpotRequest = 71;

static const int FID_SetWifiActivationRequest = 8229;

static const int FID_WifiActivationRequest = 72;

static const int FID_SetWifiDataReset = 8230;

static const int FID_WifiDataReset = 73;

static const int FID_SetWifiClientScan = 8231;

static const int FID_WifiClientScan = 74;

static const int FID_WifiClientScanIndication = 75;

static const int FID_SetWifiClientConnection = 8232;

static const int FID_WifiClientConnection = 76;

static const int FID_WifiClientConnectionIndication = 77;

static const int FID_SetWifiClientDisconnection = 8233;

static const int FID_WifiClientDisconnection = 78;

static const int FID_WifiClientScanResultIndication = 79;

static const int FID_GetWifiConnectedDevicesRequest = 8234;

static const int FID_WifiConnectedDevicesRequest = 80;

static const int FID_GetWifiClientState = 8235;

static const int FID_WifiClientState = 81;

static const int FID_WifiClientStateIndication = 82;

static const int FID_WifiConnectionDeviceRejectedIndication = 83;

static const int FID_DTMEcall = 8236;

static const int FID_HardwareVersion = 3;

static const int FID_SoftwareVersion = 4;

static const int FID_ResetHistory = 8237;

static const int FID_GetHardwareVersion = 8242;

static const int FID_GetSoftwareVersion = 8243;

static const int FID_Push_POI = 84;

static const int FID_SetPush_POIStatus = 8238;

static const int FID_Time_Limit = 85;

static const int FID_Speed_Limit = 86;

static const int FID_Area_Limit = 87;

static const int FID_Geofencing_Activation = 88;

static const int FID_SetGeofencing_ActivationStatus = 8239;

static const int FID_GetRestriction_Settings = 8240;

static const int FID_Restriction_Settings = 89;

static const int FID_Connection_Setup_Status = 97;

static const int FID_XCallStart = 8246;

static const int FID_XCallStatus = 90;

static const int FID_XCallState = 91;

static const int FID_XCallEnd = 92;

static const int FID_CallDuartion = 93;

static const int FID_PrivacyModeActivation = 94;

static const int FID_SetPrivicyMode = 8244;

static const int FID_GetTCUConfigurationStatus = 8241;

static const int FID_TCUConfigurationStatus = 96;


ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 1;

static const int VERSION_MINOR = 0;

static const int VERSION_PATCH = 0;

// forward declarations
class ConnectionStatus;

class ConfigurationStatus;

class DataTransmissionStatus;

class ECallRequestStatus;

class ECallServiceStateStatus;

class AcceptECallRequestStart;

class ACNRequestStatus;

class ACNServiceStateStatus;

class CurfewAlertStatus;

class GeoFenceStatus;

class SpeedAlertStatus;

class GetTCUStateErrorStructure;

class GetTCUStateError;

class TCUStateStatus;

class GetIDInfoStart;

class GetIDInfoErrorStructure;

class GetIDInfoError;

class IDInfoStatusStatus;

class SetDriverInfoUploadPermitStart;

class SetDriverInfoUploadPermitErrorStructure;

class SetDriverInfoUploadPermitError;

class DriverInfoUploadPermitStatusStatus;

class SMSNotificationStatusStatus;

class GetProbeUploadPermitErrorStructure;

class GetProbeUploadPermitError;

class SetProbeUploadPermitStart;

class SetProbeUploadPermitErrorStructure;

class SetProbeUploadPermitError;

class ProbeUploadPermitStatusStatus;

class SetProbeInfoDeleteErrorStructure;

class SetProbeInfoDeleteError;

class ProbeInfoDeleteStatusStatus;

class ServiceCallStateStatus;

class ServiceCallRequestStatus;

class SetServiceCallOperationStart;

class SetServiceCallOperationErrorStructure;

class SetServiceCallOperationError;

class TcuCallServiceStateStatus;

class SetNaviInfoStart;

class SetNaviInfoErrorStructure;

class SetNaviInfoError;

class SetTripScoreInfoStart;

class SetTripScoreInfoErrorStructure;

class SetTripScoreInfoError;

class SetProbeVehicleInfoStart;

class SetProbeVehicleInfoErrorStructure;

class SetProbeVehicleInfoError;

class MaintenanceInfoStart;

class MaintenanceInfoErrorStructure;

class MaintenanceInfoError;

class ProvisionServiceStatus;

class COMEcallStateStatus;

class COMEcallStartStatusErrorStructure;

class COMEcallStartStatusError;

class SetTCUResetErrorStructure;

class SetTCUResetError;

class TCUResetStatusStatus;

class EmergencyStateStatus;

class TCUResponseTimeOutStatus;

class GetTCUExtendedStateErrorStructure;

class GetTCUExtendedStateError;

class TCUExtendedStateStatus;

class SetPINSettingStart;

class SetPINSettingErrorStructure;

class SetPINSettingError;

class PINSettingStatusStatus;

class GetChargeReminderErrorStructure;

class GetChargeReminderError;

class SetChargeReminderStart;

class SetChargeReminderErrorStructure;

class SetChargeReminderError;

class ChargeReminderStatusStatus;

class ChargeRecordDeleteStatus;

class GetStationFinderStart;

class GetStationFinderErrorStructure;

class GetStationFinderError;

class StationFinderStatusStatus;

class GetChargeStationStart;

class GetChargeStationErrorStructure;

class GetChargeStationError;

class ChargeStationStatusStatus;

class GetChargeSpotListStart;

class GetChargeSpotListErrorStructure;

class GetChargeSpotListError;

class GetShortBookingStart;

class GetShortBookingErrorStructure;

class GetShortBookingError;

class Short_BookingStatusStatus;

class Short_BookingIndicationStatus;

class GetShortUnbookingStart;

class GetShortUnbookingErrorStructure;

class GetShortUnbookingError;

class Short_UnbookingStatusStatus;

class Short_UnbookingIndicationStatus;

class GetUpdateEnergyPointStart;

class GetUpdateEnergyPointErrorStructure;

class GetUpdateEnergyPointError;

class UpdateEnergyPointStatusStatus;

class UpdateEnergyPointIndicationStatus;

class SetSCH_ActivationStart;

class SetSCH_ActivationErrorStructure;

class SetSCH_ActivationError;

class SCH_ActivationStatusStatus;

class SetSCH_Update_ONBOARDStart;

class SetSCH_Update_ONBOARDErrorStructure;

class SetSCH_Update_ONBOARDError;

class SCH_Update_ONBOARDStatusStatus;

class Charge_BlockedIndicationStatus;

class GetSCH_StateErrorStructure;

class GetSCH_StateError;

class SCH_StateStatusStatus;

class SCH_StateIndicationStatus;

class StationFinderIndicationStatus;

class ChargeSpotListStatusStatus;

class SetWifiHotSpotRequestStart;

class SetWifiHotSpotRequestErrorStructure;

class SetWifiHotSpotRequestError;

class WifiHotSpotRequestIndicationStatus;

class WifiHotSpotRequestStatus;

class SetWifiActivationRequestStart;

class SetWifiActivationRequestErrorStructure;

class SetWifiActivationRequestError;

class WifiActivationRequestStatus;

class SetWifiDataResetErrorStructure;

class SetWifiDataResetError;

class WifiDataResetStatus;

class SetWifiClientScanErrorStructure;

class SetWifiClientScanError;

class SetWifiClientConnectionStart;

class SetWifiClientConnectionErrorStructure;

class SetWifiClientConnectionError;

class WifiClientConnectionStatus;

class WifiClientConnectionIndicationStatus;

class SetWifiClientDisconnectionErrorStructure;

class SetWifiClientDisconnectionError;

class WifiClientScanResultIndicationStatus;

class GetWifiConnectedDevicesRequestErrorStructure;

class GetWifiConnectedDevicesRequestError;

class WifiConnectedDevicesRequestStatus;

class GetWifiClientStateErrorStructure;

class GetWifiClientStateError;

class WifiClientStateStatus;

class WifiClientStateIndicationStatus;

class DTMEcallStart;

class DTMEcallErrorStructure;

class DTMEcallError;

class HardwareVersionStatus;

class SoftwareVersionStatus;

class Push_POIStatus;

class SetPush_POIStatusStart;

class Time_LimitStatus;

class Speed_LimitStatus;

class Area_LimitStatus;

class Geofencing_ActivationStatus;

class SetGeofencing_ActivationStatusStart;

class GetRestriction_SettingsErrorStructure;

class GetRestriction_SettingsError;

class Restriction_SettingsStatus;

class Connection_Setup_StatusStatus;

class XCallStartStart;

class XCallStartErrorStructure;

class XCallStartError;

class XCallStatusStatus;

class XCallStateStatus;

class CallDuartionStatus;

class PrivacyModeActivationStatus;

class SetPrivicyModeStart;

class GetTCUConfigurationStatusResult;

class TCUConfigurationStatusStatus;

// type definitions
/**
 * The get message of the property "Connection"
 * This property gives information about the status of the connection to the TCU.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ConnectionGet;

/**
 * The upreg message of the property "Connection"
 * This property gives information about the status of the connection to the TCU.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ConnectionUpReg;

/**
 * The relUpReg message of the property "Connection"
 * This property gives information about the status of the connection to the TCU.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ConnectionRelUpReg;

/**
 * The error message of 'Connection'
 */
typedef ::asf::cca::CcaTypes::DefaultError ConnectionError;

/**
 * The get message of the property "Configuration"
 * <p>This property gives information whether the configuration of the TCU is valid for us.</p>
 * <p>We can only communicate with the TCU when the configuration is valid.</p>
 * <p>The additional information about the unit ID and the used message version is not really
 * relevant for the communication, but it can be used for debug purposes e.g. in a service menu(MCAN Fct Id:001h).</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ConfigurationGet;

/**
 * The upreg message of the property "Configuration"
 * <p>This property gives information whether the configuration of the TCU is valid for us.</p>
 * <p>We can only communicate with the TCU when the configuration is valid.</p>
 * <p>The additional information about the unit ID and the used message version is not really
 * relevant for the communication, but it can be used for debug purposes e.g. in a service menu(MCAN Fct Id:001h).</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ConfigurationUpReg;

/**
 * The relUpReg message of the property "Configuration"
 * <p>This property gives information whether the configuration of the TCU is valid for us.</p>
 * <p>We can only communicate with the TCU when the configuration is valid.</p>
 * <p>The additional information about the unit ID and the used message version is not really
 * relevant for the communication, but it can be used for debug purposes e.g. in a service menu(MCAN Fct Id:001h).</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ConfigurationRelUpReg;

/**
 * The error message of 'Configuration'
 */
typedef ::asf::cca::CcaTypes::DefaultError ConfigurationError;

/**
 * The get message of the property "DataTransmission"
 * This property gives information about the data transmission status used to indicate transmission errors of MPDT messages.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DataTransmissionGet;

/**
 * The upreg message of the property "DataTransmission"
 * This property gives information about the data transmission status used to indicate transmission errors of MPDT messages.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DataTransmissionUpReg;

/**
 * The relUpReg message of the property "DataTransmission"
 * This property gives information about the data transmission status used to indicate transmission errors of MPDT messages.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DataTransmissionRelUpReg;

/**
 * The error message of 'DataTransmission'
 */
typedef ::asf::cca::CcaTypes::DefaultError DataTransmissionError;

/**
 * The get message of the property "ECallRequest"
 * This property gives information whether an E-Call function is currently active in the TCU(MCAN Fct Id:201h/203h).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ECallRequestGet;

/**
 * The upreg message of the property "ECallRequest"
 * This property gives information whether an E-Call function is currently active in the TCU(MCAN Fct Id:201h/203h).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ECallRequestUpReg;

/**
 * The relUpReg message of the property "ECallRequest"
 * This property gives information whether an E-Call function is currently active in the TCU(MCAN Fct Id:201h/203h).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ECallRequestRelUpReg;

/**
 * The error message of 'ECallRequest'
 */
typedef ::asf::cca::CcaTypes::DefaultError ECallRequestError;

/**
 * The get message of the property "ECallServiceState"
 * This property gives information about the current state of an active E-Call service(MCAN Fct Id:201h).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ECallServiceStateGet;

/**
 * The upreg message of the property "ECallServiceState"
 * This property gives information about the current state of an active E-Call service(MCAN Fct Id:201h).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ECallServiceStateUpReg;

/**
 * The relUpReg message of the property "ECallServiceState"
 * This property gives information about the current state of an active E-Call service(MCAN Fct Id:201h).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ECallServiceStateRelUpReg;

/**
 * The error message of 'ECallServiceState'
 */
typedef ::asf::cca::CcaTypes::DefaultError ECallServiceStateError;

/**
 * The result message of the method "AcceptECallRequest"
 * This method is used to accept an E-Call request indicatedby message ECallRequest.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AcceptECallRequestResult;

/**
 * The abort error message of the method "AcceptECallRequest"
 * This method is used to accept an E-Call request indicatedby message ECallRequest.
 */
typedef ::asf::cca::CcaTypes::DefaultError AcceptECallRequestAbortError;

/**
 * The error message of 'AcceptECallRequest'
 */
typedef ::asf::cca::CcaTypes::DefaultError AcceptECallRequestError;

/**
 * The start message of the method "ECallCancellationOrder"
 * This method is used to Send Ecall Cancel to TCU. [Applicabble only for 2.1 Renault].
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ECallCancellationOrderStart;

/**
 * The result message of the method "ECallCancellationOrder"
 * This method is used to Send Ecall Cancel to TCU. [Applicabble only for 2.1 Renault].
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ECallCancellationOrderResult;

/**
 * The abort error message of the method "ECallCancellationOrder"
 * This method is used to Send Ecall Cancel to TCU. [Applicabble only for 2.1 Renault].
 */
typedef ::asf::cca::CcaTypes::DefaultError ECallCancellationOrderAbortError;

/**
 * The error message of 'ECallCancellationOrder'
 */
typedef ::asf::cca::CcaTypes::DefaultError ECallCancellationOrderError;

/**
 * The get message of the property "ACNRequest"
 * This property gives information that ACN is active and the Audio path should be given to TCU(MCAN Fct Id:210h/212h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ACNRequestGet;

/**
 * The upreg message of the property "ACNRequest"
 * This property gives information that ACN is active and the Audio path should be given to TCU(MCAN Fct Id:210h/212h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ACNRequestUpReg;

/**
 * The relUpReg message of the property "ACNRequest"
 * This property gives information that ACN is active and the Audio path should be given to TCU(MCAN Fct Id:210h/212h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ACNRequestRelUpReg;

/**
 * The error message of 'ACNRequest'
 */
typedef ::asf::cca::CcaTypes::DefaultError ACNRequestError;

/**
 * The get message of the property "ACNServiceState"
 * This property gives update about the current state information of an active ACN service(MCAN Fct Id:211h).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ACNServiceStateGet;

/**
 * The upreg message of the property "ACNServiceState"
 * This property gives update about the current state information of an active ACN service(MCAN Fct Id:211h).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ACNServiceStateUpReg;

/**
 * The relUpReg message of the property "ACNServiceState"
 * This property gives update about the current state information of an active ACN service(MCAN Fct Id:211h).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ACNServiceStateRelUpReg;

/**
 * The error message of 'ACNServiceState'
 */
typedef ::asf::cca::CcaTypes::DefaultError ACNServiceStateError;

/**
 * The get message of the property "CurfewAlert"
 * This property gives update about the curfew Alert warning information from TCU(MCAN Fct Id:236h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CurfewAlertGet;

/**
 * The upreg message of the property "CurfewAlert"
 * This property gives update about the curfew Alert warning information from TCU(MCAN Fct Id:236h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CurfewAlertUpReg;

/**
 * The relUpReg message of the property "CurfewAlert"
 * This property gives update about the curfew Alert warning information from TCU(MCAN Fct Id:236h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CurfewAlertRelUpReg;

/**
 * The error message of 'CurfewAlert'
 */
typedef ::asf::cca::CcaTypes::DefaultError CurfewAlertError;

/**
 * The get message of the property "GeoFence"
 * This property gives update when the Vehicle detects that Geo Fence has been broken(MCAN Fct Id:235h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GeoFenceGet;

/**
 * The upreg message of the property "GeoFence"
 * This property gives update when the Vehicle detects that Geo Fence has been broken(MCAN Fct Id:235h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GeoFenceUpReg;

/**
 * The relUpReg message of the property "GeoFence"
 * This property gives update when the Vehicle detects that Geo Fence has been broken(MCAN Fct Id:235h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GeoFenceRelUpReg;

/**
 * The error message of 'GeoFence'
 */
typedef ::asf::cca::CcaTypes::DefaultError GeoFenceError;

/**
 * The get message of the property "SpeedAlert"
 * This property gives update when Speed Alert Warning is obtained from TCU(MCAN Fct Id:234h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SpeedAlertGet;

/**
 * The upreg message of the property "SpeedAlert"
 * This property gives update when Speed Alert Warning is obtained from TCU(MCAN Fct Id:234h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SpeedAlertUpReg;

/**
 * The relUpReg message of the property "SpeedAlert"
 * This property gives update when Speed Alert Warning is obtained from TCU(MCAN Fct Id:234h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SpeedAlertRelUpReg;

/**
 * The error message of 'SpeedAlert'
 */
typedef ::asf::cca::CcaTypes::DefaultError SpeedAlertError;

/**
 * The start message of the method "GetTCUState"
 * This method is called by ITM to know the TCU state(MCAN Fct Id:103h).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetTCUStateStart;

/**
 * The result message of the method "GetTCUState"
 * This method is called by ITM to know the TCU state(MCAN Fct Id:103h).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetTCUStateResult;

/**
 * The abort error message of the method "GetTCUState"
 * This method is called by ITM to know the TCU state(MCAN Fct Id:103h).
 */
typedef ::asf::cca::CcaTypes::DefaultError GetTCUStateAbortError;

/**
 * The get message of the property "TCUState"
 * This property gives update about the TCU status on request from ITM or when there is any indication by TCU(MCAN Fct Id:103h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TCUStateGet;

/**
 * The upreg message of the property "TCUState"
 * This property gives update about the TCU status on request from ITM or when there is any indication by TCU(MCAN Fct Id:103h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TCUStateUpReg;

/**
 * The relUpReg message of the property "TCUState"
 * This property gives update about the TCU status on request from ITM or when there is any indication by TCU(MCAN Fct Id:103h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TCUStateRelUpReg;

/**
 * The error message of 'TCUState'
 */
typedef ::asf::cca::CcaTypes::DefaultError TCUStateError;

/**
 * The result message of the method "GetIDInfo"
 * This method is called by ITM to TCU to recieve TCU_ID, ICC_ID, VIN, PIN(MCAN Fct Id:233h).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetIDInfoResult;

/**
 * The abort error message of the method "GetIDInfo"
 * This method is called by ITM to TCU to recieve TCU_ID, ICC_ID, VIN, PIN(MCAN Fct Id:233h).
 */
typedef ::asf::cca::CcaTypes::DefaultError GetIDInfoAbortError;

/**
 * The get message of the property "IDInfoStatus"
 * This property gives update about the TCU_ID, ICC_ID, VIN from TCU (MCAN Fct Id:233h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage IDInfoStatusGet;

/**
 * The upreg message of the property "IDInfoStatus"
 * This property gives update about the TCU_ID, ICC_ID, VIN from TCU (MCAN Fct Id:233h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage IDInfoStatusUpReg;

/**
 * The relUpReg message of the property "IDInfoStatus"
 * This property gives update about the TCU_ID, ICC_ID, VIN from TCU (MCAN Fct Id:233h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage IDInfoStatusRelUpReg;

/**
 * The error message of 'IDInfoStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError IDInfoStatusError;

/**
 * The result message of the method "SetDriverInfoUploadPermit"
 * This method is called by ITM requesting for user info upload permit(MCAN Fct Id:240h).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetDriverInfoUploadPermitResult;

/**
 * The abort error message of the method "SetDriverInfoUploadPermit"
 * This method is called by ITM requesting for user info upload permit(MCAN Fct Id:240h).
 */
typedef ::asf::cca::CcaTypes::DefaultError SetDriverInfoUploadPermitAbortError;

/**
 * The get message of the property "DriverInfoUploadPermitStatus"
 * This property gives update about the driver info upload permit (MCAN Fct Id:240h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DriverInfoUploadPermitStatusGet;

/**
 * The upreg message of the property "DriverInfoUploadPermitStatus"
 * This property gives update about the driver info upload permit (MCAN Fct Id:240h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DriverInfoUploadPermitStatusUpReg;

/**
 * The relUpReg message of the property "DriverInfoUploadPermitStatus"
 * This property gives update about the driver info upload permit (MCAN Fct Id:240h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DriverInfoUploadPermitStatusRelUpReg;

/**
 * The error message of 'DriverInfoUploadPermitStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError DriverInfoUploadPermitStatusError;

/**
 * The get message of the property "SMSNotificationStatus"
 * This property gives the SMS notification from TCU to download the content from the center (MCAN Fct Id:241h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SMSNotificationStatusGet;

/**
 * The upreg message of the property "SMSNotificationStatus"
 * This property gives the SMS notification from TCU to download the content from the center (MCAN Fct Id:241h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SMSNotificationStatusUpReg;

/**
 * The relUpReg message of the property "SMSNotificationStatus"
 * This property gives the SMS notification from TCU to download the content from the center (MCAN Fct Id:241h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SMSNotificationStatusRelUpReg;

/**
 * The error message of 'SMSNotificationStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError SMSNotificationStatusError;

/**
 * The start message of the method "GetProbeUploadPermit"
 * This method is called by ITM when the probe upload permit is chnaged from ITM side(MCAN Fct Id:244h).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetProbeUploadPermitStart;

/**
 * The result message of the method "GetProbeUploadPermit"
 * This method is called by ITM when the probe upload permit is chnaged from ITM side(MCAN Fct Id:244h).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetProbeUploadPermitResult;

/**
 * The abort error message of the method "GetProbeUploadPermit"
 * This method is called by ITM when the probe upload permit is chnaged from ITM side(MCAN Fct Id:244h).
 */
typedef ::asf::cca::CcaTypes::DefaultError GetProbeUploadPermitAbortError;

/**
 * The result message of the method "SetProbeUploadPermit"
 * This method is called by ITM when there is change in Probe Upload permit from ITM side(MCAN Fct Id:244h).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetProbeUploadPermitResult;

/**
 * The abort error message of the method "SetProbeUploadPermit"
 * This method is called by ITM when there is change in Probe Upload permit from ITM side(MCAN Fct Id:244h).
 */
typedef ::asf::cca::CcaTypes::DefaultError SetProbeUploadPermitAbortError;

/**
 * The get message of the property "ProbeUploadPermitStatus"
 * This property gives update about probe setting both while SET and GET from ITM (MCAN Fct Id:244h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ProbeUploadPermitStatusGet;

/**
 * The upreg message of the property "ProbeUploadPermitStatus"
 * This property gives update about probe setting both while SET and GET from ITM (MCAN Fct Id:244h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ProbeUploadPermitStatusUpReg;

/**
 * The relUpReg message of the property "ProbeUploadPermitStatus"
 * This property gives update about probe setting both while SET and GET from ITM (MCAN Fct Id:244h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ProbeUploadPermitStatusRelUpReg;

/**
 * The error message of 'ProbeUploadPermitStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError ProbeUploadPermitStatusError;

/**
 * The start message of the method "SetProbeInfoDelete"
 * This method is called by ITM to delete the Probe info(MCAN Fct Id:245h).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetProbeInfoDeleteStart;

/**
 * The result message of the method "SetProbeInfoDelete"
 * This method is called by ITM to delete the Probe info(MCAN Fct Id:245h).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetProbeInfoDeleteResult;

/**
 * The abort error message of the method "SetProbeInfoDelete"
 * This method is called by ITM to delete the Probe info(MCAN Fct Id:245h).
 */
typedef ::asf::cca::CcaTypes::DefaultError SetProbeInfoDeleteAbortError;

/**
 * The get message of the property "ProbeInfoDeleteStatus"
 * This property gives update about whether the the probe info is deleted or not (MCAN Fct Id:245h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ProbeInfoDeleteStatusGet;

/**
 * The upreg message of the property "ProbeInfoDeleteStatus"
 * This property gives update about whether the the probe info is deleted or not (MCAN Fct Id:245h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ProbeInfoDeleteStatusUpReg;

/**
 * The relUpReg message of the property "ProbeInfoDeleteStatus"
 * This property gives update about whether the the probe info is deleted or not (MCAN Fct Id:245h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ProbeInfoDeleteStatusRelUpReg;

/**
 * The error message of 'ProbeInfoDeleteStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError ProbeInfoDeleteStatusError;

/**
 * The get message of the property "ServiceCallState"
 * This property gives update about whether the the probe info is deleted or not (MCAN Fct Id:245h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ServiceCallStateGet;

/**
 * The upreg message of the property "ServiceCallState"
 * This property gives update about whether the the probe info is deleted or not (MCAN Fct Id:245h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ServiceCallStateUpReg;

/**
 * The relUpReg message of the property "ServiceCallState"
 * This property gives update about whether the the probe info is deleted or not (MCAN Fct Id:245h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ServiceCallStateRelUpReg;

/**
 * The error message of 'ServiceCallState'
 */
typedef ::asf::cca::CcaTypes::DefaultError ServiceCallStateError;

/**
 * The get message of the property "ServiceCallRequest"
 * This property gives information whether a service call is active or not in TCU.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ServiceCallRequestGet;

/**
 * The upreg message of the property "ServiceCallRequest"
 * This property gives information whether a service call is active or not in TCU.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ServiceCallRequestUpReg;

/**
 * The relUpReg message of the property "ServiceCallRequest"
 * This property gives information whether a service call is active or not in TCU.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ServiceCallRequestRelUpReg;

/**
 * The error message of 'ServiceCallRequest'
 */
typedef ::asf::cca::CcaTypes::DefaultError ServiceCallRequestError;

/**
 * The result message of the method "SetServiceCallOperation"
 * This method is called by ITM to TCU to indicate user call operation(MCAN Fct Id:223h).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetServiceCallOperationResult;

/**
 * The abort error message of the method "SetServiceCallOperation"
 * This method is called by ITM to TCU to indicate user call operation(MCAN Fct Id:223h).
 */
typedef ::asf::cca::CcaTypes::DefaultError SetServiceCallOperationAbortError;

/**
 * The status message of the property "ServiceCallOperationStatus"
 * This property gives update about Service call operation status  (MCAN Fct Id:223h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ServiceCallOperationStatusStatus;

/**
 * The get message of the property "ServiceCallOperationStatus"
 * This property gives update about Service call operation status  (MCAN Fct Id:223h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ServiceCallOperationStatusGet;

/**
 * The upreg message of the property "ServiceCallOperationStatus"
 * This property gives update about Service call operation status  (MCAN Fct Id:223h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ServiceCallOperationStatusUpReg;

/**
 * The relUpReg message of the property "ServiceCallOperationStatus"
 * This property gives update about Service call operation status  (MCAN Fct Id:223h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ServiceCallOperationStatusRelUpReg;

/**
 * The error message of 'ServiceCallOperationStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError ServiceCallOperationStatusError;

/**
 * The get message of the property "TcuCallServiceState"
 * TCU sends the current call service sate to ITM and ITM adjust self state by reception..
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TcuCallServiceStateGet;

/**
 * The upreg message of the property "TcuCallServiceState"
 * TCU sends the current call service sate to ITM and ITM adjust self state by reception..
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TcuCallServiceStateUpReg;

/**
 * The relUpReg message of the property "TcuCallServiceState"
 * TCU sends the current call service sate to ITM and ITM adjust self state by reception..
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TcuCallServiceStateRelUpReg;

/**
 * The error message of 'TcuCallServiceState'
 */
typedef ::asf::cca::CcaTypes::DefaultError TcuCallServiceStateError;

/**
 * The result message of the method "SetNaviInfo"
 * This method is called by TCU HMI when there is change in NaviData(MCAN Fct Id:100h).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetNaviInfoResult;

/**
 * The abort error message of the method "SetNaviInfo"
 * This method is called by TCU HMI when there is change in NaviData(MCAN Fct Id:100h).
 */
typedef ::asf::cca::CcaTypes::DefaultError SetNaviInfoAbortError;

/**
 * The result message of the method "SetTripScoreInfo"
 * This method is called by TCU HMI when there is change in Trip Score Info (MCAN Fct Id:232h).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetTripScoreInfoResult;

/**
 * The abort error message of the method "SetTripScoreInfo"
 * This method is called by TCU HMI when there is change in Trip Score Info (MCAN Fct Id:232h).
 */
typedef ::asf::cca::CcaTypes::DefaultError SetTripScoreInfoAbortError;

/**
 * The result message of the method "SetProbeVehicleInfo"
 * This method is called by TCU HMI when there is change in Probe vehicle Info.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetProbeVehicleInfoResult;

/**
 * The abort error message of the method "SetProbeVehicleInfo"
 * This method is called by TCU HMI when there is change in Probe vehicle Info.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetProbeVehicleInfoAbortError;

/**
 * The result message of the method "MaintenanceInfo"
 * This method is called by TCU HMI when there is change in Maintenance Info.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MaintenanceInfoResult;

/**
 * The abort error message of the method "MaintenanceInfo"
 * This method is called by TCU HMI when there is change in Maintenance Info.
 */
typedef ::asf::cca::CcaTypes::DefaultError MaintenanceInfoAbortError;

/**
 * The get message of the property "ProvisionService"
 * This property gives TCU Provisioning Service list  from TCU to change self TCU Function setting(MCAN Fct Id:104h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ProvisionServiceGet;

/**
 * The upreg message of the property "ProvisionService"
 * This property gives TCU Provisioning Service list  from TCU to change self TCU Function setting(MCAN Fct Id:104h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ProvisionServiceUpReg;

/**
 * The relUpReg message of the property "ProvisionService"
 * This property gives TCU Provisioning Service list  from TCU to change self TCU Function setting(MCAN Fct Id:104h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ProvisionServiceRelUpReg;

/**
 * The error message of 'ProvisionService'
 */
typedef ::asf::cca::CcaTypes::DefaultError ProvisionServiceError;

/**
 * The get message of the property "COMEcallState"
 * This property gives update about COM Ecall State (MCAN Fct Id:110h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage COMEcallStateGet;

/**
 * The upreg message of the property "COMEcallState"
 * This property gives update about COM Ecall State (MCAN Fct Id:110h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage COMEcallStateUpReg;

/**
 * The relUpReg message of the property "COMEcallState"
 * This property gives update about COM Ecall State (MCAN Fct Id:110h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage COMEcallStateRelUpReg;

/**
 * The error message of 'COMEcallState'
 */
typedef ::asf::cca::CcaTypes::DefaultError COMEcallStateError;

/**
 * The status message of the property "COMEcallStart"
 * This property gives COM Eall start request to ITM(MCAN Fct Id:111h).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage COMEcallStartStatus;

/**
 * The get message of the property "COMEcallStart"
 * This property gives COM Eall start request to ITM(MCAN Fct Id:111h).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage COMEcallStartGet;

/**
 * The upreg message of the property "COMEcallStart"
 * This property gives COM Eall start request to ITM(MCAN Fct Id:111h).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage COMEcallStartUpReg;

/**
 * The relUpReg message of the property "COMEcallStart"
 * This property gives COM Eall start request to ITM(MCAN Fct Id:111h).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage COMEcallStartRelUpReg;

/**
 * The error message of 'COMEcallStart'
 */
typedef ::asf::cca::CcaTypes::DefaultError COMEcallStartError;

/**
 * The start message of the method "COMEcallStartStatus"
 * This method is called by ITM to TCU to indicate  call operation(MCAN Fct Id:111h).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage COMEcallStartStatusStart;

/**
 * The result message of the method "COMEcallStartStatus"
 * This method is called by ITM to TCU to indicate  call operation(MCAN Fct Id:111h).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage COMEcallStartStatusResult;

/**
 * The abort error message of the method "COMEcallStartStatus"
 * This method is called by ITM to TCU to indicate  call operation(MCAN Fct Id:111h).
 */
typedef ::asf::cca::CcaTypes::DefaultError COMEcallStartStatusAbortError;

/**
 * The status message of the property "COMEcallEnd"
 * This property gives update to end the COM Ecall to ITM(MCAN Fct Id:112h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage COMEcallEndStatus;

/**
 * The get message of the property "COMEcallEnd"
 * This property gives update to end the COM Ecall to ITM(MCAN Fct Id:112h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage COMEcallEndGet;

/**
 * The upreg message of the property "COMEcallEnd"
 * This property gives update to end the COM Ecall to ITM(MCAN Fct Id:112h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage COMEcallEndUpReg;

/**
 * The relUpReg message of the property "COMEcallEnd"
 * This property gives update to end the COM Ecall to ITM(MCAN Fct Id:112h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage COMEcallEndRelUpReg;

/**
 * The error message of 'COMEcallEnd'
 */
typedef ::asf::cca::CcaTypes::DefaultError COMEcallEndError;

/**
 * The start message of the method "SetTCUReset"
 * ITM send the trigger to TCU for re-registration to data communication.EV Navi only(MCAN Fct Id:252h).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetTCUResetStart;

/**
 * The result message of the method "SetTCUReset"
 * ITM send the trigger to TCU for re-registration to data communication.EV Navi only(MCAN Fct Id:252h).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetTCUResetResult;

/**
 * The abort error message of the method "SetTCUReset"
 * ITM send the trigger to TCU for re-registration to data communication.EV Navi only(MCAN Fct Id:252h).
 */
typedef ::asf::cca::CcaTypes::DefaultError SetTCUResetAbortError;

/**
 * The get message of the property "TCUResetStatus"
 * This property gives update about TCU reset status (MCAN Fct Id:252h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TCUResetStatusGet;

/**
 * The upreg message of the property "TCUResetStatus"
 * This property gives update about TCU reset status (MCAN Fct Id:252h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TCUResetStatusUpReg;

/**
 * The relUpReg message of the property "TCUResetStatus"
 * This property gives update about TCU reset status (MCAN Fct Id:252h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TCUResetStatusRelUpReg;

/**
 * The error message of 'TCUResetStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError TCUResetStatusError;

/**
 * The get message of the property "EmergencyState"
 * This property gives indication to the SPM to change the power state to TEMPO_ON if the current state is  TEMPO_OFF/STATIC_OFF
 */
typedef ::asf::cca::CcaTypes::DefaultMessage EmergencyStateGet;

/**
 * The upreg message of the property "EmergencyState"
 * This property gives indication to the SPM to change the power state to TEMPO_ON if the current state is  TEMPO_OFF/STATIC_OFF
 */
typedef ::asf::cca::CcaTypes::DefaultMessage EmergencyStateUpReg;

/**
 * The relUpReg message of the property "EmergencyState"
 * This property gives indication to the SPM to change the power state to TEMPO_ON if the current state is  TEMPO_OFF/STATIC_OFF
 */
typedef ::asf::cca::CcaTypes::DefaultMessage EmergencyStateRelUpReg;

/**
 * The error message of 'EmergencyState'
 */
typedef ::asf::cca::CcaTypes::DefaultError EmergencyStateError;

/**
 * The get message of the property "TCUResponseTimeOut"
 * This property gives info about the response time out the request to the TCU
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TCUResponseTimeOutGet;

/**
 * The upreg message of the property "TCUResponseTimeOut"
 * This property gives info about the response time out the request to the TCU
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TCUResponseTimeOutUpReg;

/**
 * The relUpReg message of the property "TCUResponseTimeOut"
 * This property gives info about the response time out the request to the TCU
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TCUResponseTimeOutRelUpReg;

/**
 * The error message of 'TCUResponseTimeOut'
 */
typedef ::asf::cca::CcaTypes::DefaultError TCUResponseTimeOutError;

/**
 * The start message of the method "GetTCUExtendedState"
 * This method is called by ITM to know the TCU Extended State (MCAN Fct *41Ah*).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetTCUExtendedStateStart;

/**
 * The result message of the method "GetTCUExtendedState"
 * This method is called by ITM to know the TCU Extended State (MCAN Fct *41Ah*).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetTCUExtendedStateResult;

/**
 * The abort error message of the method "GetTCUExtendedState"
 * This method is called by ITM to know the TCU Extended State (MCAN Fct *41Ah*).
 */
typedef ::asf::cca::CcaTypes::DefaultError GetTCUExtendedStateAbortError;

/**
 * The get message of the property "TCUExtendedState"
 * This property gives update about the TCU Extended status on request from ITM or when there is any indication by TCU(MCAN Fct **)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TCUExtendedStateGet;

/**
 * The upreg message of the property "TCUExtendedState"
 * This property gives update about the TCU Extended status on request from ITM or when there is any indication by TCU(MCAN Fct **)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TCUExtendedStateUpReg;

/**
 * The relUpReg message of the property "TCUExtendedState"
 * This property gives update about the TCU Extended status on request from ITM or when there is any indication by TCU(MCAN Fct **)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TCUExtendedStateRelUpReg;

/**
 * The error message of 'TCUExtendedState'
 */
typedef ::asf::cca::CcaTypes::DefaultError TCUExtendedStateError;

/**
 * The result message of the method "SetPINSetting"
 * User set PIN ID and Password and send to TCU  to certify with Center(Fctn ID : 250h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetPINSettingResult;

/**
 * The abort error message of the method "SetPINSetting"
 * User set PIN ID and Password and send to TCU  to certify with Center(Fctn ID : 250h)
 */
typedef ::asf::cca::CcaTypes::DefaultError SetPINSettingAbortError;

/**
 * The get message of the property "PINSettingStatus"
 * Property Gives update about the PIN Setting Status
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PINSettingStatusGet;

/**
 * The upreg message of the property "PINSettingStatus"
 * Property Gives update about the PIN Setting Status
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PINSettingStatusUpReg;

/**
 * The relUpReg message of the property "PINSettingStatus"
 * Property Gives update about the PIN Setting Status
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PINSettingStatusRelUpReg;

/**
 * The error message of 'PINSettingStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError PINSettingStatusError;

/**
 * The start message of the method "GetChargeReminder"
 * ITMaster request EV Charge reminder information to TCU. (Fctn ID : 251h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetChargeReminderStart;

/**
 * The result message of the method "GetChargeReminder"
 * ITMaster request EV Charge reminder information to TCU. (Fctn ID : 251h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetChargeReminderResult;

/**
 * The abort error message of the method "GetChargeReminder"
 * ITMaster request EV Charge reminder information to TCU. (Fctn ID : 251h)
 */
typedef ::asf::cca::CcaTypes::DefaultError GetChargeReminderAbortError;

/**
 * The result message of the method "SetChargeReminder"
 * ITMaster request EV Charge reminder information to TCU (Fctn ID : 251h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetChargeReminderResult;

/**
 * The abort error message of the method "SetChargeReminder"
 * ITMaster request EV Charge reminder information to TCU (Fctn ID : 251h)
 */
typedef ::asf::cca::CcaTypes::DefaultError SetChargeReminderAbortError;

/**
 * The get message of the property "ChargeReminderStatus"
 * ITMaster receive EV Charge reminder information from TCU  (Fctn ID : 251h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ChargeReminderStatusGet;

/**
 * The upreg message of the property "ChargeReminderStatus"
 * ITMaster receive EV Charge reminder information from TCU  (Fctn ID : 251h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ChargeReminderStatusUpReg;

/**
 * The relUpReg message of the property "ChargeReminderStatus"
 * ITMaster receive EV Charge reminder information from TCU  (Fctn ID : 251h)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ChargeReminderStatusRelUpReg;

/**
 * The error message of 'ChargeReminderStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError ChargeReminderStatusError;

/**
 * The get message of the property "ChargeRecordDelete"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ChargeRecordDeleteGet;

/**
 * The upreg message of the property "ChargeRecordDelete"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ChargeRecordDeleteUpReg;

/**
 * The relUpReg message of the property "ChargeRecordDelete"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ChargeRecordDeleteRelUpReg;

/**
 * The error message of 'ChargeRecordDelete'
 */
typedef ::asf::cca::CcaTypes::DefaultError ChargeRecordDeleteError;

/**
 * The result message of the method "GetStationFinder"
 * Helps to find compatible charging spot by providing Current location
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetStationFinderResult;

/**
 * The abort error message of the method "GetStationFinder"
 * Helps to find compatible charging spot by providing Current location
 */
typedef ::asf::cca::CcaTypes::DefaultError GetStationFinderAbortError;

/**
 * The get message of the property "StationFinderStatus"
 * Provides the info about charging spot
 */
typedef ::asf::cca::CcaTypes::DefaultMessage StationFinderStatusGet;

/**
 * The upreg message of the property "StationFinderStatus"
 * Provides the info about charging spot
 */
typedef ::asf::cca::CcaTypes::DefaultMessage StationFinderStatusUpReg;

/**
 * The relUpReg message of the property "StationFinderStatus"
 * Provides the info about charging spot
 */
typedef ::asf::cca::CcaTypes::DefaultMessage StationFinderStatusRelUpReg;

/**
 * The error message of 'StationFinderStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError StationFinderStatusError;

/**
 * The result message of the method "GetChargeStation"
 * Message used to Request the information on each found charge station.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetChargeStationResult;

/**
 * The abort error message of the method "GetChargeStation"
 * Message used to Request the information on each found charge station.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetChargeStationAbortError;

/**
 * The get message of the property "ChargeStationStatus"
 * Message used to Receive the information on each found charge station.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ChargeStationStatusGet;

/**
 * The upreg message of the property "ChargeStationStatus"
 * Message used to Receive the information on each found charge station.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ChargeStationStatusUpReg;

/**
 * The relUpReg message of the property "ChargeStationStatus"
 * Message used to Receive the information on each found charge station.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ChargeStationStatusRelUpReg;

/**
 * The error message of 'ChargeStationStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError ChargeStationStatusError;

/**
 * The result message of the method "GetChargeSpotList"
 * Requests the spot list of a station
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetChargeSpotListResult;

/**
 * The abort error message of the method "GetChargeSpotList"
 * Requests the spot list of a station
 */
typedef ::asf::cca::CcaTypes::DefaultError GetChargeSpotListAbortError;

/**
 * The result message of the method "GetShortBooking"
 * Receive the spot list of a station.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetShortBookingResult;

/**
 * The abort error message of the method "GetShortBooking"
 * Receive the spot list of a station.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetShortBookingAbortError;

/**
 * The get message of the property "Short_BookingStatus"
 * Method Helps to book Charge spot
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Short_BookingStatusGet;

/**
 * The upreg message of the property "Short_BookingStatus"
 * Method Helps to book Charge spot
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Short_BookingStatusUpReg;

/**
 * The relUpReg message of the property "Short_BookingStatus"
 * Method Helps to book Charge spot
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Short_BookingStatusRelUpReg;

/**
 * The error message of 'Short_BookingStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError Short_BookingStatusError;

/**
 * The get message of the property "Short_BookingIndication"
 * Property updates about Booking status of charge spot
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Short_BookingIndicationGet;

/**
 * The upreg message of the property "Short_BookingIndication"
 * Property updates about Booking status of charge spot
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Short_BookingIndicationUpReg;

/**
 * The relUpReg message of the property "Short_BookingIndication"
 * Property updates about Booking status of charge spot
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Short_BookingIndicationRelUpReg;

/**
 * The error message of 'Short_BookingIndication'
 */
typedef ::asf::cca::CcaTypes::DefaultError Short_BookingIndicationError;

/**
 * The result message of the method "GetShortUnbooking"
 * Method Helps to Cancel the booked Charge spot
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetShortUnbookingResult;

/**
 * The abort error message of the method "GetShortUnbooking"
 * Method Helps to Cancel the booked Charge spot
 */
typedef ::asf::cca::CcaTypes::DefaultError GetShortUnbookingAbortError;

/**
 * The get message of the property "Short_UnbookingStatus"
 * Property updates about cancellation status of booked charge spot
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Short_UnbookingStatusGet;

/**
 * The upreg message of the property "Short_UnbookingStatus"
 * Property updates about cancellation status of booked charge spot
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Short_UnbookingStatusUpReg;

/**
 * The relUpReg message of the property "Short_UnbookingStatus"
 * Property updates about cancellation status of booked charge spot
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Short_UnbookingStatusRelUpReg;

/**
 * The error message of 'Short_UnbookingStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError Short_UnbookingStatusError;

/**
 * The get message of the property "Short_UnbookingIndication"
 * Property updates about cancellation of booked charge spot
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Short_UnbookingIndicationGet;

/**
 * The upreg message of the property "Short_UnbookingIndication"
 * Property updates about cancellation of booked charge spot
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Short_UnbookingIndicationUpReg;

/**
 * The relUpReg message of the property "Short_UnbookingIndication"
 * Property updates about cancellation of booked charge spot
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Short_UnbookingIndicationRelUpReg;

/**
 * The error message of 'Short_UnbookingIndication'
 */
typedef ::asf::cca::CcaTypes::DefaultError Short_UnbookingIndicationError;

/**
 * The result message of the method "GetUpdateEnergyPoint"
 * Requests Update of the Energy Points
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetUpdateEnergyPointResult;

/**
 * The abort error message of the method "GetUpdateEnergyPoint"
 * Requests Update of the Energy Points
 */
typedef ::asf::cca::CcaTypes::DefaultError GetUpdateEnergyPointAbortError;

/**
 * The get message of the property "UpdateEnergyPointStatus"
 * Property updates about the status of update of energy points
 */
typedef ::asf::cca::CcaTypes::DefaultMessage UpdateEnergyPointStatusGet;

/**
 * The upreg message of the property "UpdateEnergyPointStatus"
 * Property updates about the status of update of energy points
 */
typedef ::asf::cca::CcaTypes::DefaultMessage UpdateEnergyPointStatusUpReg;

/**
 * The relUpReg message of the property "UpdateEnergyPointStatus"
 * Property updates about the status of update of energy points
 */
typedef ::asf::cca::CcaTypes::DefaultMessage UpdateEnergyPointStatusRelUpReg;

/**
 * The error message of 'UpdateEnergyPointStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError UpdateEnergyPointStatusError;

/**
 * The get message of the property "UpdateEnergyPointIndication"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage UpdateEnergyPointIndicationGet;

/**
 * The upreg message of the property "UpdateEnergyPointIndication"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage UpdateEnergyPointIndicationUpReg;

/**
 * The relUpReg message of the property "UpdateEnergyPointIndication"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage UpdateEnergyPointIndicationRelUpReg;

/**
 * The error message of 'UpdateEnergyPointIndication'
 */
typedef ::asf::cca::CcaTypes::DefaultError UpdateEnergyPointIndicationError;

/**
 * The result message of the method "SetSCH_Activation"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetSCH_ActivationResult;

/**
 * The abort error message of the method "SetSCH_Activation"
 */
typedef ::asf::cca::CcaTypes::DefaultError SetSCH_ActivationAbortError;

/**
 * The get message of the property "SCH_ActivationStatus"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SCH_ActivationStatusGet;

/**
 * The upreg message of the property "SCH_ActivationStatus"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SCH_ActivationStatusUpReg;

/**
 * The relUpReg message of the property "SCH_ActivationStatus"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SCH_ActivationStatusRelUpReg;

/**
 * The error message of 'SCH_ActivationStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError SCH_ActivationStatusError;

/**
 * The result message of the method "SetSCH_Update_ONBOARD"
 * TCU updates the scheduler at startup or during a mission
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetSCH_Update_ONBOARDResult;

/**
 * The abort error message of the method "SetSCH_Update_ONBOARD"
 * TCU updates the scheduler at startup or during a mission
 */
typedef ::asf::cca::CcaTypes::DefaultError SetSCH_Update_ONBOARDAbortError;

/**
 * The get message of the property "SCH_Update_ONBOARDStatus"
 * TCU updates the scheduler at startup or during a mission
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SCH_Update_ONBOARDStatusGet;

/**
 * The upreg message of the property "SCH_Update_ONBOARDStatus"
 * TCU updates the scheduler at startup or during a mission
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SCH_Update_ONBOARDStatusUpReg;

/**
 * The relUpReg message of the property "SCH_Update_ONBOARDStatus"
 * TCU updates the scheduler at startup or during a mission
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SCH_Update_ONBOARDStatusRelUpReg;

/**
 * The error message of 'SCH_Update_ONBOARDStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError SCH_Update_ONBOARDStatusError;

/**
 * The get message of the property "Charge_BlockedIndication"
 * Property Indicate that the charge is blocked by the TCU
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Charge_BlockedIndicationGet;

/**
 * The upreg message of the property "Charge_BlockedIndication"
 * Property Indicate that the charge is blocked by the TCU
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Charge_BlockedIndicationUpReg;

/**
 * The relUpReg message of the property "Charge_BlockedIndication"
 * Property Indicate that the charge is blocked by the TCU
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Charge_BlockedIndicationRelUpReg;

/**
 * The error message of 'Charge_BlockedIndication'
 */
typedef ::asf::cca::CcaTypes::DefaultError Charge_BlockedIndicationError;

/**
 * The start message of the method "GetSCH_State"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetSCH_StateStart;

/**
 * The result message of the method "GetSCH_State"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetSCH_StateResult;

/**
 * The abort error message of the method "GetSCH_State"
 */
typedef ::asf::cca::CcaTypes::DefaultError GetSCH_StateAbortError;

/**
 * The get message of the property "SCH_StateStatus"
 * TCU updates the scheduler at startup or during a mission
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SCH_StateStatusGet;

/**
 * The upreg message of the property "SCH_StateStatus"
 * TCU updates the scheduler at startup or during a mission
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SCH_StateStatusUpReg;

/**
 * The relUpReg message of the property "SCH_StateStatus"
 * TCU updates the scheduler at startup or during a mission
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SCH_StateStatusRelUpReg;

/**
 * The error message of 'SCH_StateStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError SCH_StateStatusError;

/**
 * The get message of the property "SCH_StateIndication"
 * TCU updates the scheduler at startup or during a mission
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SCH_StateIndicationGet;

/**
 * The upreg message of the property "SCH_StateIndication"
 * TCU updates the scheduler at startup or during a mission
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SCH_StateIndicationUpReg;

/**
 * The relUpReg message of the property "SCH_StateIndication"
 * TCU updates the scheduler at startup or during a mission
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SCH_StateIndicationRelUpReg;

/**
 * The error message of 'SCH_StateIndication'
 */
typedef ::asf::cca::CcaTypes::DefaultError SCH_StateIndicationError;

/**
 * The get message of the property "StationFinderIndication"
 * Provides the info about charging spot
 */
typedef ::asf::cca::CcaTypes::DefaultMessage StationFinderIndicationGet;

/**
 * The upreg message of the property "StationFinderIndication"
 * Provides the info about charging spot
 */
typedef ::asf::cca::CcaTypes::DefaultMessage StationFinderIndicationUpReg;

/**
 * The relUpReg message of the property "StationFinderIndication"
 * Provides the info about charging spot
 */
typedef ::asf::cca::CcaTypes::DefaultMessage StationFinderIndicationRelUpReg;

/**
 * The error message of 'StationFinderIndication'
 */
typedef ::asf::cca::CcaTypes::DefaultError StationFinderIndicationError;

/**
 * The get message of the property "ChargeSpotListStatus"
 * Used to receive the spot list of a station
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ChargeSpotListStatusGet;

/**
 * The upreg message of the property "ChargeSpotListStatus"
 * Used to receive the spot list of a station
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ChargeSpotListStatusUpReg;

/**
 * The relUpReg message of the property "ChargeSpotListStatus"
 * Used to receive the spot list of a station
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ChargeSpotListStatusRelUpReg;

/**
 * The error message of 'ChargeSpotListStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError ChargeSpotListStatusError;

/**
 * The result message of the method "SetWifiHotSpotRequest"
 * Usefull to know parameters shared by TCU to establish Wifi connection (internet)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetWifiHotSpotRequestResult;

/**
 * The abort error message of the method "SetWifiHotSpotRequest"
 * Usefull to know parameters shared by TCU to establish Wifi connection (internet)
 */
typedef ::asf::cca::CcaTypes::DefaultError SetWifiHotSpotRequestAbortError;

/**
 * The get message of the property "WifiHotSpotRequestIndication"
 * Usefull to know parameters shared by TCU to establish Wifi connection (internet)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WifiHotSpotRequestIndicationGet;

/**
 * The upreg message of the property "WifiHotSpotRequestIndication"
 * Usefull to know parameters shared by TCU to establish Wifi connection (internet)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WifiHotSpotRequestIndicationUpReg;

/**
 * The relUpReg message of the property "WifiHotSpotRequestIndication"
 * Usefull to know parameters shared by TCU to establish Wifi connection (internet)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WifiHotSpotRequestIndicationRelUpReg;

/**
 * The error message of 'WifiHotSpotRequestIndication'
 */
typedef ::asf::cca::CcaTypes::DefaultError WifiHotSpotRequestIndicationError;

/**
 * The get message of the property "WifiHotSpotRequest"
 * Usefull to know parameters shared by TCU to establish Wifi connection (internet)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WifiHotSpotRequestGet;

/**
 * The upreg message of the property "WifiHotSpotRequest"
 * Usefull to know parameters shared by TCU to establish Wifi connection (internet)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WifiHotSpotRequestUpReg;

/**
 * The relUpReg message of the property "WifiHotSpotRequest"
 * Usefull to know parameters shared by TCU to establish Wifi connection (internet)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WifiHotSpotRequestRelUpReg;

/**
 * The error message of 'WifiHotSpotRequest'
 */
typedef ::asf::cca::CcaTypes::DefaultError WifiHotSpotRequestError;

/**
 * The result message of the method "SetWifiActivationRequest"
 * Usefull to request the activation or the deactivation of Wifi feature
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetWifiActivationRequestResult;

/**
 * The abort error message of the method "SetWifiActivationRequest"
 * Usefull to request the activation or the deactivation of Wifi feature
 */
typedef ::asf::cca::CcaTypes::DefaultError SetWifiActivationRequestAbortError;

/**
 * The get message of the property "WifiActivationRequest"
 * Usefull to know parameters shared by TCU to establish Wifi connection (internet)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WifiActivationRequestGet;

/**
 * The upreg message of the property "WifiActivationRequest"
 * Usefull to know parameters shared by TCU to establish Wifi connection (internet)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WifiActivationRequestUpReg;

/**
 * The relUpReg message of the property "WifiActivationRequest"
 * Usefull to know parameters shared by TCU to establish Wifi connection (internet)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WifiActivationRequestRelUpReg;

/**
 * The error message of 'WifiActivationRequest'
 */
typedef ::asf::cca::CcaTypes::DefaultError WifiActivationRequestError;

/**
 * The start message of the method "SetWifiDataReset"
 * Message is used to remove the passwords
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetWifiDataResetStart;

/**
 * The result message of the method "SetWifiDataReset"
 * Message is used to remove the passwords
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetWifiDataResetResult;

/**
 * The abort error message of the method "SetWifiDataReset"
 * Message is used to remove the passwords
 */
typedef ::asf::cca::CcaTypes::DefaultError SetWifiDataResetAbortError;

/**
 * The get message of the property "WifiDataReset"
 * Message is used to remove the passwords
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WifiDataResetGet;

/**
 * The upreg message of the property "WifiDataReset"
 * Message is used to remove the passwords
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WifiDataResetUpReg;

/**
 * The relUpReg message of the property "WifiDataReset"
 * Message is used to remove the passwords
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WifiDataResetRelUpReg;

/**
 * The error message of 'WifiDataReset'
 */
typedef ::asf::cca::CcaTypes::DefaultError WifiDataResetError;

/**
 * The start message of the method "SetWifiClientScan"
 * used to request the scan and the selection of the network
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetWifiClientScanStart;

/**
 * The result message of the method "SetWifiClientScan"
 * used to request the scan and the selection of the network
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetWifiClientScanResult;

/**
 * The abort error message of the method "SetWifiClientScan"
 * used to request the scan and the selection of the network
 */
typedef ::asf::cca::CcaTypes::DefaultError SetWifiClientScanAbortError;

/**
 * The status message of the property "WifiClientScan"
 * used to request the scan and the selection of the network
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WifiClientScanStatus;

/**
 * The get message of the property "WifiClientScan"
 * used to request the scan and the selection of the network
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WifiClientScanGet;

/**
 * The upreg message of the property "WifiClientScan"
 * used to request the scan and the selection of the network
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WifiClientScanUpReg;

/**
 * The relUpReg message of the property "WifiClientScan"
 * used to request the scan and the selection of the network
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WifiClientScanRelUpReg;

/**
 * The error message of 'WifiClientScan'
 */
typedef ::asf::cca::CcaTypes::DefaultError WifiClientScanError;

/**
 * The status message of the property "WifiClientScanIndication"
 * used to request the scan and the selection of the network
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WifiClientScanIndicationStatus;

/**
 * The get message of the property "WifiClientScanIndication"
 * used to request the scan and the selection of the network
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WifiClientScanIndicationGet;

/**
 * The upreg message of the property "WifiClientScanIndication"
 * used to request the scan and the selection of the network
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WifiClientScanIndicationUpReg;

/**
 * The relUpReg message of the property "WifiClientScanIndication"
 * used to request the scan and the selection of the network
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WifiClientScanIndicationRelUpReg;

/**
 * The error message of 'WifiClientScanIndication'
 */
typedef ::asf::cca::CcaTypes::DefaultError WifiClientScanIndicationError;

/**
 * The result message of the method "SetWifiClientConnection"
 * used to request the scan and the selection of the network
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetWifiClientConnectionResult;

/**
 * The abort error message of the method "SetWifiClientConnection"
 * used to request the scan and the selection of the network
 */
typedef ::asf::cca::CcaTypes::DefaultError SetWifiClientConnectionAbortError;

/**
 * The get message of the property "WifiClientConnection"
 * used to request the scan and the selection of the network
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WifiClientConnectionGet;

/**
 * The upreg message of the property "WifiClientConnection"
 * used to request the scan and the selection of the network
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WifiClientConnectionUpReg;

/**
 * The relUpReg message of the property "WifiClientConnection"
 * used to request the scan and the selection of the network
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WifiClientConnectionRelUpReg;

/**
 * The error message of 'WifiClientConnection'
 */
typedef ::asf::cca::CcaTypes::DefaultError WifiClientConnectionError;

/**
 * The get message of the property "WifiClientConnectionIndication"
 * used to request the scan and the selection of the network
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WifiClientConnectionIndicationGet;

/**
 * The upreg message of the property "WifiClientConnectionIndication"
 * used to request the scan and the selection of the network
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WifiClientConnectionIndicationUpReg;

/**
 * The relUpReg message of the property "WifiClientConnectionIndication"
 * used to request the scan and the selection of the network
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WifiClientConnectionIndicationRelUpReg;

/**
 * The error message of 'WifiClientConnectionIndication'
 */
typedef ::asf::cca::CcaTypes::DefaultError WifiClientConnectionIndicationError;

/**
 * The start message of the method "SetWifiClientDisconnection"
 * used to request the scan and the selection of the network
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetWifiClientDisconnectionStart;

/**
 * The result message of the method "SetWifiClientDisconnection"
 * used to request the scan and the selection of the network
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetWifiClientDisconnectionResult;

/**
 * The abort error message of the method "SetWifiClientDisconnection"
 * used to request the scan and the selection of the network
 */
typedef ::asf::cca::CcaTypes::DefaultError SetWifiClientDisconnectionAbortError;

/**
 * The status message of the property "WifiClientDisconnection"
 * used to request the scan and the selection of the network
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WifiClientDisconnectionStatus;

/**
 * The get message of the property "WifiClientDisconnection"
 * used to request the scan and the selection of the network
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WifiClientDisconnectionGet;

/**
 * The upreg message of the property "WifiClientDisconnection"
 * used to request the scan and the selection of the network
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WifiClientDisconnectionUpReg;

/**
 * The relUpReg message of the property "WifiClientDisconnection"
 * used to request the scan and the selection of the network
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WifiClientDisconnectionRelUpReg;

/**
 * The error message of 'WifiClientDisconnection'
 */
typedef ::asf::cca::CcaTypes::DefaultError WifiClientDisconnectionError;

/**
 * The get message of the property "WifiClientScanResultIndication"
 * used to request the scan and the selection of the network
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WifiClientScanResultIndicationGet;

/**
 * The upreg message of the property "WifiClientScanResultIndication"
 * used to request the scan and the selection of the network
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WifiClientScanResultIndicationUpReg;

/**
 * The relUpReg message of the property "WifiClientScanResultIndication"
 * used to request the scan and the selection of the network
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WifiClientScanResultIndicationRelUpReg;

/**
 * The error message of 'WifiClientScanResultIndication'
 */
typedef ::asf::cca::CcaTypes::DefaultError WifiClientScanResultIndicationError;

/**
 * The start message of the method "GetWifiConnectedDevicesRequest"
 * Lists Connected devices
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetWifiConnectedDevicesRequestStart;

/**
 * The result message of the method "GetWifiConnectedDevicesRequest"
 * Lists Connected devices
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetWifiConnectedDevicesRequestResult;

/**
 * The abort error message of the method "GetWifiConnectedDevicesRequest"
 * Lists Connected devices
 */
typedef ::asf::cca::CcaTypes::DefaultError GetWifiConnectedDevicesRequestAbortError;

/**
 * The get message of the property "WifiConnectedDevicesRequest"
 * Lists Connected devices
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WifiConnectedDevicesRequestGet;

/**
 * The upreg message of the property "WifiConnectedDevicesRequest"
 * Lists Connected devices
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WifiConnectedDevicesRequestUpReg;

/**
 * The relUpReg message of the property "WifiConnectedDevicesRequest"
 * Lists Connected devices
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WifiConnectedDevicesRequestRelUpReg;

/**
 * The error message of 'WifiConnectedDevicesRequest'
 */
typedef ::asf::cca::CcaTypes::DefaultError WifiConnectedDevicesRequestError;

/**
 * The start message of the method "GetWifiClientState"
 * Used to know the wifi client state
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetWifiClientStateStart;

/**
 * The result message of the method "GetWifiClientState"
 * Used to know the wifi client state
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetWifiClientStateResult;

/**
 * The abort error message of the method "GetWifiClientState"
 * Used to know the wifi client state
 */
typedef ::asf::cca::CcaTypes::DefaultError GetWifiClientStateAbortError;

/**
 * The get message of the property "WifiClientState"
 * Lists Connected devices
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WifiClientStateGet;

/**
 * The upreg message of the property "WifiClientState"
 * Lists Connected devices
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WifiClientStateUpReg;

/**
 * The relUpReg message of the property "WifiClientState"
 * Lists Connected devices
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WifiClientStateRelUpReg;

/**
 * The error message of 'WifiClientState'
 */
typedef ::asf::cca::CcaTypes::DefaultError WifiClientStateError;

/**
 * The get message of the property "WifiClientStateIndication"
 * Lists Connected devices
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WifiClientStateIndicationGet;

/**
 * The upreg message of the property "WifiClientStateIndication"
 * Lists Connected devices
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WifiClientStateIndicationUpReg;

/**
 * The relUpReg message of the property "WifiClientStateIndication"
 * Lists Connected devices
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WifiClientStateIndicationRelUpReg;

/**
 * The error message of 'WifiClientStateIndication'
 */
typedef ::asf::cca::CcaTypes::DefaultError WifiClientStateIndicationError;

/**
 * The status message of the property "WifiConnectionDeviceRejectedIndication"
 * Lists Connected devices
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WifiConnectionDeviceRejectedIndicationStatus;

/**
 * The get message of the property "WifiConnectionDeviceRejectedIndication"
 * Lists Connected devices
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WifiConnectionDeviceRejectedIndicationGet;

/**
 * The upreg message of the property "WifiConnectionDeviceRejectedIndication"
 * Lists Connected devices
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WifiConnectionDeviceRejectedIndicationUpReg;

/**
 * The relUpReg message of the property "WifiConnectionDeviceRejectedIndication"
 * Lists Connected devices
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WifiConnectionDeviceRejectedIndicationRelUpReg;

/**
 * The error message of 'WifiConnectionDeviceRejectedIndication'
 */
typedef ::asf::cca::CcaTypes::DefaultError WifiConnectionDeviceRejectedIndicationError;

/**
 * The result message of the method "DTMEcall"
 * Used to Test the Ecall Audio Route
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DTMEcallResult;

/**
 * The abort error message of the method "DTMEcall"
 * Used to Test the Ecall Audio Route
 */
typedef ::asf::cca::CcaTypes::DefaultError DTMEcallAbortError;

/**
 * The get message of the property "HardwareVersion"
 * This property gives information about the hardware version of the TCU(MCAN Fct Id:010h).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage HardwareVersionGet;

/**
 * The upreg message of the property "HardwareVersion"
 * This property gives information about the hardware version of the TCU(MCAN Fct Id:010h).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage HardwareVersionUpReg;

/**
 * The relUpReg message of the property "HardwareVersion"
 * This property gives information about the hardware version of the TCU(MCAN Fct Id:010h).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage HardwareVersionRelUpReg;

/**
 * The error message of 'HardwareVersion'
 */
typedef ::asf::cca::CcaTypes::DefaultError HardwareVersionError;

/**
 * The get message of the property "SoftwareVersion"
 * This property gives information about the software version of the TCU(MCAN Fct Id:011h).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SoftwareVersionGet;

/**
 * The upreg message of the property "SoftwareVersion"
 * This property gives information about the software version of the TCU(MCAN Fct Id:011h).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SoftwareVersionUpReg;

/**
 * The relUpReg message of the property "SoftwareVersion"
 * This property gives information about the software version of the TCU(MCAN Fct Id:011h).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SoftwareVersionRelUpReg;

/**
 * The error message of 'SoftwareVersion'
 */
typedef ::asf::cca::CcaTypes::DefaultError SoftwareVersionError;

/**
 * The start message of the method "ResetHistory"
 * This method is used to Clear History in Meter
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ResetHistoryStart;

/**
 * The result message of the method "ResetHistory"
 * This method is used to Clear History in Meter
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ResetHistoryResult;

/**
 * The abort error message of the method "ResetHistory"
 * This method is used to Clear History in Meter
 */
typedef ::asf::cca::CcaTypes::DefaultError ResetHistoryAbortError;

/**
 * The error message of 'ResetHistory'
 */
typedef ::asf::cca::CcaTypes::DefaultError ResetHistoryError;

/**
 * The start message of the method "GetHardwareVersion"
 * Methoid Helps to get the HardwareVersion from the TCU
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetHardwareVersionStart;

/**
 * The result message of the method "GetHardwareVersion"
 * Methoid Helps to get the HardwareVersion from the TCU
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetHardwareVersionResult;

/**
 * The abort error message of the method "GetHardwareVersion"
 * Methoid Helps to get the HardwareVersion from the TCU
 */
typedef ::asf::cca::CcaTypes::DefaultError GetHardwareVersionAbortError;

/**
 * The error message of 'GetHardwareVersion'
 */
typedef ::asf::cca::CcaTypes::DefaultError GetHardwareVersionError;

/**
 * The start message of the method "GetSoftwareVersion"
 * Methoid Helps to get the Softwareversion from the TCU
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetSoftwareVersionStart;

/**
 * The result message of the method "GetSoftwareVersion"
 * Methoid Helps to get the Softwareversion from the TCU
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetSoftwareVersionResult;

/**
 * The abort error message of the method "GetSoftwareVersion"
 * Methoid Helps to get the Softwareversion from the TCU
 */
typedef ::asf::cca::CcaTypes::DefaultError GetSoftwareVersionAbortError;

/**
 * The error message of 'GetSoftwareVersion'
 */
typedef ::asf::cca::CcaTypes::DefaultError GetSoftwareVersionError;

/**
 * The get message of the property "Push_POI"
 * Transfer a destination from TCU  to navi system
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Push_POIGet;

/**
 * The upreg message of the property "Push_POI"
 * Transfer a destination from TCU  to navi system
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Push_POIUpReg;

/**
 * The relUpReg message of the property "Push_POI"
 * Transfer a destination from TCU  to navi system
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Push_POIRelUpReg;

/**
 * The error message of 'Push_POI'
 */
typedef ::asf::cca::CcaTypes::DefaultError Push_POIError;

/**
 * The result message of the method "SetPush_POIStatus"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetPush_POIStatusResult;

/**
 * The abort error message of the method "SetPush_POIStatus"
 */
typedef ::asf::cca::CcaTypes::DefaultError SetPush_POIStatusAbortError;

/**
 * The error message of 'SetPush_POIStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError SetPush_POIStatusError;

/**
 * The get message of the property "Time_Limit"
 * Transfer a destination from TCU  to navi system
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Time_LimitGet;

/**
 * The upreg message of the property "Time_Limit"
 * Transfer a destination from TCU  to navi system
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Time_LimitUpReg;

/**
 * The relUpReg message of the property "Time_Limit"
 * Transfer a destination from TCU  to navi system
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Time_LimitRelUpReg;

/**
 * The error message of 'Time_Limit'
 */
typedef ::asf::cca::CcaTypes::DefaultError Time_LimitError;

/**
 * The get message of the property "Speed_Limit"
 * Transfer a destination from TCU  to navi system
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Speed_LimitGet;

/**
 * The upreg message of the property "Speed_Limit"
 * Transfer a destination from TCU  to navi system
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Speed_LimitUpReg;

/**
 * The relUpReg message of the property "Speed_Limit"
 * Transfer a destination from TCU  to navi system
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Speed_LimitRelUpReg;

/**
 * The error message of 'Speed_Limit'
 */
typedef ::asf::cca::CcaTypes::DefaultError Speed_LimitError;

/**
 * The get message of the property "Area_Limit"
 * Transfer a destination from TCU  to navi system
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Area_LimitGet;

/**
 * The upreg message of the property "Area_Limit"
 * Transfer a destination from TCU  to navi system
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Area_LimitUpReg;

/**
 * The relUpReg message of the property "Area_Limit"
 * Transfer a destination from TCU  to navi system
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Area_LimitRelUpReg;

/**
 * The error message of 'Area_Limit'
 */
typedef ::asf::cca::CcaTypes::DefaultError Area_LimitError;

/**
 * The get message of the property "Geofencing_Activation"
 * Transfer a destination from TCU  to navi system
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Geofencing_ActivationGet;

/**
 * The upreg message of the property "Geofencing_Activation"
 * Transfer a destination from TCU  to navi system
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Geofencing_ActivationUpReg;

/**
 * The relUpReg message of the property "Geofencing_Activation"
 * Transfer a destination from TCU  to navi system
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Geofencing_ActivationRelUpReg;

/**
 * The error message of 'Geofencing_Activation'
 */
typedef ::asf::cca::CcaTypes::DefaultError Geofencing_ActivationError;

/**
 * The result message of the method "SetGeofencing_ActivationStatus"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetGeofencing_ActivationStatusResult;

/**
 * The abort error message of the method "SetGeofencing_ActivationStatus"
 */
typedef ::asf::cca::CcaTypes::DefaultError SetGeofencing_ActivationStatusAbortError;

/**
 * The error message of 'SetGeofencing_ActivationStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError SetGeofencing_ActivationStatusError;

/**
 * The start message of the method "GetRestriction_Settings"
 * This method is called by ITM to know the TCU state(MCAN Fct Id:103h).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetRestriction_SettingsStart;

/**
 * The result message of the method "GetRestriction_Settings"
 * This method is called by ITM to know the TCU state(MCAN Fct Id:103h).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetRestriction_SettingsResult;

/**
 * The abort error message of the method "GetRestriction_Settings"
 * This method is called by ITM to know the TCU state(MCAN Fct Id:103h).
 */
typedef ::asf::cca::CcaTypes::DefaultError GetRestriction_SettingsAbortError;

/**
 * The get message of the property "Restriction_Settings"
 * Transfer a destination from TCU  to navi system
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Restriction_SettingsGet;

/**
 * The upreg message of the property "Restriction_Settings"
 * Transfer a destination from TCU  to navi system
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Restriction_SettingsUpReg;

/**
 * The relUpReg message of the property "Restriction_Settings"
 * Transfer a destination from TCU  to navi system
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Restriction_SettingsRelUpReg;

/**
 * The error message of 'Restriction_Settings'
 */
typedef ::asf::cca::CcaTypes::DefaultError Restriction_SettingsError;

/**
 * The get message of the property "Connection_Setup_Status"
 * Transfer a destination from TCU  to navi system
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Connection_Setup_StatusGet;

/**
 * The upreg message of the property "Connection_Setup_Status"
 * Transfer a destination from TCU  to navi system
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Connection_Setup_StatusUpReg;

/**
 * The relUpReg message of the property "Connection_Setup_Status"
 * Transfer a destination from TCU  to navi system
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Connection_Setup_StatusRelUpReg;

/**
 * The error message of 'Connection_Setup_Status'
 */
typedef ::asf::cca::CcaTypes::DefaultError Connection_Setup_StatusError;

/**
 * The result message of the method "XCallStart"
 * Triggers XCallStart.Set Message to TCU with Language and Call Type.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage XCallStartResult;

/**
 * The abort error message of the method "XCallStart"
 * Triggers XCallStart.Set Message to TCU with Language and Call Type.
 */
typedef ::asf::cca::CcaTypes::DefaultError XCallStartAbortError;

/**
 * The get message of the property "XCallStatus"
 * XCall Status to Clients
 */
typedef ::asf::cca::CcaTypes::DefaultMessage XCallStatusGet;

/**
 * The upreg message of the property "XCallStatus"
 * XCall Status to Clients
 */
typedef ::asf::cca::CcaTypes::DefaultMessage XCallStatusUpReg;

/**
 * The relUpReg message of the property "XCallStatus"
 * XCall Status to Clients
 */
typedef ::asf::cca::CcaTypes::DefaultMessage XCallStatusRelUpReg;

/**
 * The error message of 'XCallStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError XCallStatusError;

/**
 * The get message of the property "XCallState"
 * XCall Status to Clients
 */
typedef ::asf::cca::CcaTypes::DefaultMessage XCallStateGet;

/**
 * The upreg message of the property "XCallState"
 * XCall Status to Clients
 */
typedef ::asf::cca::CcaTypes::DefaultMessage XCallStateUpReg;

/**
 * The relUpReg message of the property "XCallState"
 * XCall Status to Clients
 */
typedef ::asf::cca::CcaTypes::DefaultMessage XCallStateRelUpReg;

/**
 * The error message of 'XCallState'
 */
typedef ::asf::cca::CcaTypes::DefaultError XCallStateError;

/**
 * The status message of the property "XCallEnd"
 * XCall End InficationRecieved from TCU.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage XCallEndStatus;

/**
 * The get message of the property "XCallEnd"
 * XCall End InficationRecieved from TCU.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage XCallEndGet;

/**
 * The upreg message of the property "XCallEnd"
 * XCall End InficationRecieved from TCU.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage XCallEndUpReg;

/**
 * The relUpReg message of the property "XCallEnd"
 * XCall End InficationRecieved from TCU.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage XCallEndRelUpReg;

/**
 * The error message of 'XCallEnd'
 */
typedef ::asf::cca::CcaTypes::DefaultError XCallEndError;

/**
 * The get message of the property "CallDuartion"
 * Updates X-Call,E-Call and ACN-Call Duration
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CallDuartionGet;

/**
 * The upreg message of the property "CallDuartion"
 * Updates X-Call,E-Call and ACN-Call Duration
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CallDuartionUpReg;

/**
 * The relUpReg message of the property "CallDuartion"
 * Updates X-Call,E-Call and ACN-Call Duration
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CallDuartionRelUpReg;

/**
 * The error message of 'CallDuartion'
 */
typedef ::asf::cca::CcaTypes::DefaultError CallDuartionError;

/**
 * The get message of the property "PrivacyModeActivation"
 * Updates X-Call,E-Call and ACN-Call Duration
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PrivacyModeActivationGet;

/**
 * The upreg message of the property "PrivacyModeActivation"
 * Updates X-Call,E-Call and ACN-Call Duration
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PrivacyModeActivationUpReg;

/**
 * The relUpReg message of the property "PrivacyModeActivation"
 * Updates X-Call,E-Call and ACN-Call Duration
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PrivacyModeActivationRelUpReg;

/**
 * The error message of 'PrivacyModeActivation'
 */
typedef ::asf::cca::CcaTypes::DefaultError PrivacyModeActivationError;

/**
 * The result message of the method "SetPrivicyMode"
 * This Method Provides the Clients to Detect the TCU Availability.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetPrivicyModeResult;

/**
 * The abort error message of the method "SetPrivicyMode"
 * This Method Provides the Clients to Detect the TCU Availability.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetPrivicyModeAbortError;

/**
 * The error message of 'SetPrivicyMode'
 */
typedef ::asf::cca::CcaTypes::DefaultError SetPrivicyModeError;

/**
 * The start message of the method "GetTCUConfigurationStatus"
 * This Method Provides the Clients to Detect the TCU Availability.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetTCUConfigurationStatusStart;

/**
 * The abort error message of the method "GetTCUConfigurationStatus"
 * This Method Provides the Clients to Detect the TCU Availability.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetTCUConfigurationStatusAbortError;

/**
 * The error message of 'GetTCUConfigurationStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError GetTCUConfigurationStatusError;

/**
 * The get message of the property "TCUConfigurationStatus"
 * Transfer a destination from TCU  to navi system
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TCUConfigurationStatusGet;

/**
 * The upreg message of the property "TCUConfigurationStatus"
 * Transfer a destination from TCU  to navi system
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TCUConfigurationStatusUpReg;

/**
 * The relUpReg message of the property "TCUConfigurationStatus"
 * Transfer a destination from TCU  to navi system
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TCUConfigurationStatusRelUpReg;

/**
 * The error message of 'TCUConfigurationStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError TCUConfigurationStatusError;


/**
 * The status message of the property "Connection"
 * This property gives information about the status of the connection to the TCU.
 */
class ConnectionStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConnectionStatus ();

    /**
     * Copy constructor
     */
    inline  ConnectionStatus (const ConnectionStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ConnectionStatus (bool bConnected_, uint8 u8AbsenceState_, uint8 u8MuteState_, ::tcu_main_fi_types::T_e8_TCU_CommunicationStatus e8CommunicationStatus_);

    /**
     * Destructor
     */
    inline virtual  ~ConnectionStatus();

    /**
     * Assignment operator
     */
    inline ConnectionStatus& operator = (const ConnectionStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConnectionStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConnectionStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConnectionStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConnectionStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bConnected"

    static const int kBConnected = 0;

    /**
     * Clears the field "bConnected".
     *
     * The field will be set to its default value. The hasBConnected()
     * method will return false.
     */
    inline void clearBConnected();

    /**
     * Checks whether the field "bConnected" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBConnected()). Otherwise it will return false.
     */
    inline bool hasBConnected () const;

    /**
     * Returns the value of the member "bConnected".
     *
     * <p>FALSE: This MCAN unit is not connected.</p>
     * <p>TRUE: This MCAN unit is connected.</p>
     *
     * @return The value of the field "bConnected"
     */
    inline bool getBConnected () const;

    /**
     * Sets the value of the member "bConnected".
     *
     * <p>FALSE: This MCAN unit is not connected.</p>
     * <p>TRUE: This MCAN unit is connected.</p>
     *
     * @param bConnected The value which will be set
     */
    inline void setBConnected (bool bConnected_);

    // API of field "u8AbsenceState"

    static const int kU8AbsenceState = 1;

    /**
     * Clears the field "u8AbsenceState".
     *
     * The field will be set to its default value. The hasU8AbsenceState()
     * method will return false.
     */
    inline void clearU8AbsenceState();

    /**
     * Checks whether the field "u8AbsenceState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8AbsenceState()). Otherwise it will return false.
     */
    inline bool hasU8AbsenceState () const;

    /**
     * Returns the value of the member "u8AbsenceState".
     *
     * Indicates the absence of CMF (Channel Management Frames), i.e. CMFs were not received.
     * <p>0x00 = CMF not absent, i.e. connection is OK</p>
     * <p>0x80 = CMF currently absent, i.e. connection currently NOK</p>
     * <p>0xC0 = CMF confirmed absent, i.e. connection confirmed NOK</p>
     * <p>0xFF = Absence detection is masked, i.e. diagnosis not active</p>
     *
     * @return The value of the field "u8AbsenceState"
     */
    inline uint8 getU8AbsenceState () const;

    /**
     * Sets the value of the member "u8AbsenceState".
     *
     * Indicates the absence of CMF (Channel Management Frames), i.e. CMFs were not received.
     * <p>0x00 = CMF not absent, i.e. connection is OK</p>
     * <p>0x80 = CMF currently absent, i.e. connection currently NOK</p>
     * <p>0xC0 = CMF confirmed absent, i.e. connection confirmed NOK</p>
     * <p>0xFF = Absence detection is masked, i.e. diagnosis not active</p>
     *
     * @param u8AbsenceState The value which will be set
     */
    inline void setU8AbsenceState (uint8 u8AbsenceState_);

    // API of field "u8MuteState"

    static const int kU8MuteState = 2;

    /**
     * Clears the field "u8MuteState".
     *
     * The field will be set to its default value. The hasU8MuteState()
     * method will return false.
     */
    inline void clearU8MuteState();

    /**
     * Checks whether the field "u8MuteState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8MuteState()). Otherwise it will return false.
     */
    inline bool hasU8MuteState () const;

    /**
     * Returns the value of the member "u8MuteState".
     *
     * Indicates a sending error (mute) of CMF, i.e. CMFs could not be sent.
     * <p>0x00 = CMF not muted, i.e. connection is OK</p>
     * <p>0x80 = CMF currently muted, i.e. connection currently NOK</p>
     * <p>0xC0 = CMF confirmed muted, i.e. connection confirmed NOK</p>
     * <p>0xFF = Mute detection is masked, i.e. diagnosis not active</p>
     *
     * @return The value of the field "u8MuteState"
     */
    inline uint8 getU8MuteState () const;

    /**
     * Sets the value of the member "u8MuteState".
     *
     * Indicates a sending error (mute) of CMF, i.e. CMFs could not be sent.
     * <p>0x00 = CMF not muted, i.e. connection is OK</p>
     * <p>0x80 = CMF currently muted, i.e. connection currently NOK</p>
     * <p>0xC0 = CMF confirmed muted, i.e. connection confirmed NOK</p>
     * <p>0xFF = Mute detection is masked, i.e. diagnosis not active</p>
     *
     * @param u8MuteState The value which will be set
     */
    inline void setU8MuteState (uint8 u8MuteState_);

    // API of field "e8CommunicationStatus"

    static const int kE8CommunicationStatus = 3;

    /**
     * Clears the field "e8CommunicationStatus".
     *
     * The field will be set to its default value. The hasE8CommunicationStatus()
     * method will return false.
     */
    inline void clearE8CommunicationStatus();

    /**
     * Checks whether the field "e8CommunicationStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8CommunicationStatus()). Otherwise it will return false.
     */
    inline bool hasE8CommunicationStatus () const;

    /**
     * Returns the value of the member "e8CommunicationStatus".
     *
     * Indicates Communication status between TCU - ITM.
     *
     * @return The value of the field "e8CommunicationStatus"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_CommunicationStatus getE8CommunicationStatus () const;

    /**
     * Sets the value of the member "e8CommunicationStatus".
     *
     * Indicates Communication status between TCU - ITM.
     *
     * @param e8CommunicationStatus The value which will be set
     */
    inline void setE8CommunicationStatus (::tcu_main_fi_types::T_e8_TCU_CommunicationStatus e8CommunicationStatus_);

    static const ConnectionStatus &getDefaultInstance();

private:

    inline void set_has_bConnected ();

    inline void clear_has_bConnected ();

    inline void set_has_u8AbsenceState ();

    inline void clear_has_u8AbsenceState ();

    inline void set_has_u8MuteState ();

    inline void clear_has_u8MuteState ();

    inline void set_has_e8CommunicationStatus ();

    inline void clear_has_e8CommunicationStatus ();

    uint32 _has_bits_[ (4 + 31) / 32];

    bool _bConnected;

    uint8 _u8AbsenceState;

    uint8 _u8MuteState;

    ::tcu_main_fi_types::T_e8_TCU_CommunicationStatus _e8CommunicationStatus;

};

/**
 * The status message of the property "Configuration"
 * <p>This property gives information whether the configuration of the TCU is valid for us.</p>
 * <p>We can only communicate with the TCU when the configuration is valid.</p>
 * <p>The additional information about the unit ID and the used message version is not really
 * relevant for the communication, but it can be used for debug purposes e.g. in a service menu(MCAN Fct Id:001h).</p>
 */
class ConfigurationStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConfigurationStatus ();

    /**
     * Copy constructor
     */
    inline  ConfigurationStatus (const ConfigurationStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ConfigurationStatus (::tcu_main_fi_types::T_e8_TCU_ConfigurationStatus e8ConfigurationStatus_, uint8 u8UnitId_, const ::tcu_main_fi_types::T_TCU_VersionInfo& rMessageVersion_);

    /**
     * Destructor
     */
    inline virtual  ~ConfigurationStatus();

    /**
     * Assignment operator
     */
    inline ConfigurationStatus& operator = (const ConfigurationStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConfigurationStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConfigurationStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConfigurationStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConfigurationStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ConfigurationStatus"

    static const int kE8ConfigurationStatus = 0;

    /**
     * Clears the field "e8ConfigurationStatus".
     *
     * The field will be set to its default value. The hasE8ConfigurationStatus()
     * method will return false.
     */
    inline void clearE8ConfigurationStatus();

    /**
     * Checks whether the field "e8ConfigurationStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ConfigurationStatus()). Otherwise it will return false.
     */
    inline bool hasE8ConfigurationStatus () const;

    /**
     * Returns the value of the member "e8ConfigurationStatus".
     *
     * Status of the configuration (undefined, valid, invalid).
     *
     * @return The value of the field "e8ConfigurationStatus"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_ConfigurationStatus getE8ConfigurationStatus () const;

    /**
     * Sets the value of the member "e8ConfigurationStatus".
     *
     * Status of the configuration (undefined, valid, invalid).
     *
     * @param e8ConfigurationStatus The value which will be set
     */
    inline void setE8ConfigurationStatus (::tcu_main_fi_types::T_e8_TCU_ConfigurationStatus e8ConfigurationStatus_);

    // API of field "u8UnitId"

    static const int kU8UnitId = 1;

    /**
     * Clears the field "u8UnitId".
     *
     * The field will be set to its default value. The hasU8UnitId()
     * method will return false.
     */
    inline void clearU8UnitId();

    /**
     * Checks whether the field "u8UnitId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8UnitId()). Otherwise it will return false.
     */
    inline bool hasU8UnitId () const;

    /**
     * Returns the value of the member "u8UnitId".
     *
     * Identifier defining which kind of TCU is connected.
     *
     * @return The value of the field "u8UnitId"
     */
    inline uint8 getU8UnitId () const;

    /**
     * Sets the value of the member "u8UnitId".
     *
     * Identifier defining which kind of TCU is connected.
     *
     * @param u8UnitId The value which will be set
     */
    inline void setU8UnitId (uint8 u8UnitId_);

    // API of field "rMessageVersion"

    static const int kRMessageVersion = 2;

    /**
     * Clears the field "rMessageVersion".
     *
     * The field will be set to its default value. The hasRMessageVersion()
     * method will return false.
     */
    inline void clearRMessageVersion();

    /**
     * Checks whether the field "rMessageVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRMessageVersion()). Otherwise it will return false.
     */
    inline bool hasRMessageVersion () const;

    /**
     * Returns the value of the member "rMessageVersion".
     *
     * Record with information about the version number of message set specfication.
     *
     * @return The value of the field "rMessageVersion"
     */
    inline const ::tcu_main_fi_types::T_TCU_VersionInfo& getRMessageVersion () const;

    /**
     * Retrieves the value of the field "rMessageVersion" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rMessageVersion".
     */
    inline ::tcu_main_fi_types::T_TCU_VersionInfo& getRMessageVersionMutable ();

    /**
     * Sets the value of the member "rMessageVersion".
     *
     * Record with information about the version number of message set specfication.
     *
     * @param rMessageVersion The value which will be set
     */
    inline void setRMessageVersion (const ::tcu_main_fi_types::T_TCU_VersionInfo& rMessageVersion_);

    static const ConfigurationStatus &getDefaultInstance();

private:

    inline void set_has_e8ConfigurationStatus ();

    inline void clear_has_e8ConfigurationStatus ();

    inline void set_has_u8UnitId ();

    inline void clear_has_u8UnitId ();

    inline void set_has_rMessageVersion ();

    inline void clear_has_rMessageVersion ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::tcu_main_fi_types::T_e8_TCU_ConfigurationStatus _e8ConfigurationStatus;

    uint8 _u8UnitId;

    ::tcu_main_fi_types::T_TCU_VersionInfo _rMessageVersion;

};

/**
 * The status message of the property "DataTransmission"
 * This property gives information about the data transmission status used to indicate transmission errors of MPDT messages.
 */
class DataTransmissionStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DataTransmissionStatus ();

    /**
     * Copy constructor
     */
    inline  DataTransmissionStatus (const DataTransmissionStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DataTransmissionStatus (uint8 u8MPDTMuteState_);

    /**
     * Destructor
     */
    inline virtual  ~DataTransmissionStatus();

    /**
     * Assignment operator
     */
    inline DataTransmissionStatus& operator = (const DataTransmissionStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DataTransmissionStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DataTransmissionStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DataTransmissionStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DataTransmissionStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8MPDTMuteState"

    static const int kU8MPDTMuteState = 0;

    /**
     * Clears the field "u8MPDTMuteState".
     *
     * The field will be set to its default value. The hasU8MPDTMuteState()
     * method will return false.
     */
    inline void clearU8MPDTMuteState();

    /**
     * Checks whether the field "u8MPDTMuteState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8MPDTMuteState()). Otherwise it will return false.
     */
    inline bool hasU8MPDTMuteState () const;

    /**
     * Returns the value of the member "u8MPDTMuteState".
     *
     * Indicates a sending error (mute) of an MPDT message, i.e. sending was not successful.
     * <p>0x00 = MPDT not muted, i.e. sending of MPDT message were successful</p>
     * <p>0x80 = MPDT currently muted, i.e. sending of MPDT message were currently not successful</p>
     * <p>0xC0 = MPDT confirmed muted, i.e. sending of MPDT message were confirmed not successful</p>
     * <p>0xFF = Mute detection is masked, i.e. diagnosis not active</p>
     *
     * @return The value of the field "u8MPDTMuteState"
     */
    inline uint8 getU8MPDTMuteState () const;

    /**
     * Sets the value of the member "u8MPDTMuteState".
     *
     * Indicates a sending error (mute) of an MPDT message, i.e. sending was not successful.
     * <p>0x00 = MPDT not muted, i.e. sending of MPDT message were successful</p>
     * <p>0x80 = MPDT currently muted, i.e. sending of MPDT message were currently not successful</p>
     * <p>0xC0 = MPDT confirmed muted, i.e. sending of MPDT message were confirmed not successful</p>
     * <p>0xFF = Mute detection is masked, i.e. diagnosis not active</p>
     *
     * @param u8MPDTMuteState The value which will be set
     */
    inline void setU8MPDTMuteState (uint8 u8MPDTMuteState_);

    static const DataTransmissionStatus &getDefaultInstance();

private:

    inline void set_has_u8MPDTMuteState ();

    inline void clear_has_u8MPDTMuteState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8MPDTMuteState;

};

/**
 * The status message of the property "ECallRequest"
 * This property gives information whether an E-Call function is currently active in the TCU(MCAN Fct Id:201h/203h).
 */
class ECallRequestStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ECallRequestStatus ();

    /**
     * Copy constructor
     */
    inline  ECallRequestStatus (const ECallRequestStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ECallRequestStatus (bool bECallActive_, bool bValid_, bool bIsECallCallBackRequest_);

    /**
     * Destructor
     */
    inline virtual  ~ECallRequestStatus();

    /**
     * Assignment operator
     */
    inline ECallRequestStatus& operator = (const ECallRequestStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ECallRequestStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ECallRequestStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ECallRequestStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ECallRequestStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bECallActive"

    static const int kBECallActive = 0;

    /**
     * Clears the field "bECallActive".
     *
     * The field will be set to its default value. The hasBECallActive()
     * method will return false.
     */
    inline void clearBECallActive();

    /**
     * Checks whether the field "bECallActive" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBECallActive()). Otherwise it will return false.
     */
    inline bool hasBECallActive () const;

    /**
     * Returns the value of the member "bECallActive".
     *
     * If TRUE the TCU requests for  E-Call START.If FALSE TCU request for Ecall END
     *
     * @return The value of the field "bECallActive"
     */
    inline bool getBECallActive () const;

    /**
     * Sets the value of the member "bECallActive".
     *
     * If TRUE the TCU requests for  E-Call START.If FALSE TCU request for Ecall END
     *
     * @param bECallActive The value which will be set
     */
    inline void setBECallActive (bool bECallActive_);

    // API of field "bValid"

    static const int kBValid = 1;

    /**
     * Clears the field "bValid".
     *
     * The field will be set to its default value. The hasBValid()
     * method will return false.
     */
    inline void clearBValid();

    /**
     * Checks whether the field "bValid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBValid()). Otherwise it will return false.
     */
    inline bool hasBValid () const;

    /**
     * Returns the value of the member "bValid".
     *
     * Value will be set to FALSE on STATUS update for UPREG otherwise value will set to TRUE
     *
     * @return The value of the field "bValid"
     */
    inline bool getBValid () const;

    /**
     * Sets the value of the member "bValid".
     *
     * Value will be set to FALSE on STATUS update for UPREG otherwise value will set to TRUE
     *
     * @param bValid The value which will be set
     */
    inline void setBValid (bool bValid_);

    // API of field "bIsECallCallBackRequest"

    static const int kBIsECallCallBackRequest = 2;

    /**
     * Clears the field "bIsECallCallBackRequest".
     *
     * The field will be set to its default value. The hasBIsECallCallBackRequest()
     * method will return false.
     */
    inline void clearBIsECallCallBackRequest();

    /**
     * Checks whether the field "bIsECallCallBackRequest" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBIsECallCallBackRequest()). Otherwise it will return false.
     */
    inline bool hasBIsECallCallBackRequest () const;

    /**
     * Returns the value of the member "bIsECallCallBackRequest".
     *
     * Informs Ecall Triggered  by User or PSAP
     * TRUE - CALL is triggered by PSAP
     * FALSE - CAll is triggered by User
     *
     * @return The value of the field "bIsECallCallBackRequest"
     */
    inline bool getBIsECallCallBackRequest () const;

    /**
     * Sets the value of the member "bIsECallCallBackRequest".
     *
     * Informs Ecall Triggered  by User or PSAP
     * TRUE - CALL is triggered by PSAP
     * FALSE - CAll is triggered by User
     *
     * @param bIsECallCallBackRequest The value which will be set
     */
    inline void setBIsECallCallBackRequest (bool bIsECallCallBackRequest_);

    static const ECallRequestStatus &getDefaultInstance();

private:

    inline void set_has_bECallActive ();

    inline void clear_has_bECallActive ();

    inline void set_has_bValid ();

    inline void clear_has_bValid ();

    inline void set_has_bIsECallCallBackRequest ();

    inline void clear_has_bIsECallCallBackRequest ();

    uint32 _has_bits_[ (3 + 31) / 32];

    bool _bECallActive;

    bool _bValid;

    bool _bIsECallCallBackRequest;

};

/**
 * The status message of the property "ECallServiceState"
 * This property gives information about the current state of an active E-Call service(MCAN Fct Id:201h).
 */
class ECallServiceStateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ECallServiceStateStatus ();

    /**
     * Copy constructor
     */
    inline  ECallServiceStateStatus (const ECallServiceStateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ECallServiceStateStatus (::tcu_main_fi_types::T_e8_TCU_ServiceState e8ECallServiceState_);

    /**
     * Destructor
     */
    inline virtual  ~ECallServiceStateStatus();

    /**
     * Assignment operator
     */
    inline ECallServiceStateStatus& operator = (const ECallServiceStateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ECallServiceStateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ECallServiceStateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ECallServiceStateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ECallServiceStateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ECallServiceState"

    static const int kE8ECallServiceState = 0;

    /**
     * Clears the field "e8ECallServiceState".
     *
     * The field will be set to its default value. The hasE8ECallServiceState()
     * method will return false.
     */
    inline void clearE8ECallServiceState();

    /**
     * Checks whether the field "e8ECallServiceState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ECallServiceState()). Otherwise it will return false.
     */
    inline bool hasE8ECallServiceState () const;

    /**
     * Returns the value of the member "e8ECallServiceState".
     *
     * If the meaning of "e8ECallServiceState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8ECallServiceState"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_ServiceState getE8ECallServiceState () const;

    /**
     * Sets the value of the member "e8ECallServiceState".
     *
     * If the meaning of "e8ECallServiceState" isn't clear, then there should be a description here.
     *
     * @param e8ECallServiceState The value which will be set
     */
    inline void setE8ECallServiceState (::tcu_main_fi_types::T_e8_TCU_ServiceState e8ECallServiceState_);

    static const ECallServiceStateStatus &getDefaultInstance();

private:

    inline void set_has_e8ECallServiceState ();

    inline void clear_has_e8ECallServiceState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tcu_main_fi_types::T_e8_TCU_ServiceState _e8ECallServiceState;

};

/**
 * The start message of the method "AcceptECallRequest"
 * This method is used to accept an E-Call request indicatedby message ECallRequest.
 */
class AcceptECallRequestStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AcceptECallRequestStart ();

    /**
     * Copy constructor
     */
    inline  AcceptECallRequestStart (const AcceptECallRequestStart &rhs);

    /**
     * All fields constructor
     */
    inline  AcceptECallRequestStart (bool bECallAccepted_);

    /**
     * Destructor
     */
    inline virtual  ~AcceptECallRequestStart();

    /**
     * Assignment operator
     */
    inline AcceptECallRequestStart& operator = (const AcceptECallRequestStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AcceptECallRequestStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AcceptECallRequestStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AcceptECallRequestStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AcceptECallRequestStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bECallAccepted"

    static const int kBECallAccepted = 0;

    /**
     * Clears the field "bECallAccepted".
     *
     * The field will be set to its default value. The hasBECallAccepted()
     * method will return false.
     */
    inline void clearBECallAccepted();

    /**
     * Checks whether the field "bECallAccepted" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBECallAccepted()). Otherwise it will return false.
     */
    inline bool hasBECallAccepted () const;

    /**
     * Returns the value of the member "bECallAccepted".
     *
     * If TRUE the preperation for the E-Call is successfully finished and the TCU can start to connect to the service center.
     *
     * @return The value of the field "bECallAccepted"
     */
    inline bool getBECallAccepted () const;

    /**
     * Sets the value of the member "bECallAccepted".
     *
     * If TRUE the preperation for the E-Call is successfully finished and the TCU can start to connect to the service center.
     *
     * @param bECallAccepted The value which will be set
     */
    inline void setBECallAccepted (bool bECallAccepted_);

    static const AcceptECallRequestStart &getDefaultInstance();

private:

    inline void set_has_bECallAccepted ();

    inline void clear_has_bECallAccepted ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bECallAccepted;

};

/**
 * The status message of the property "ACNRequest"
 * This property gives information that ACN is active and the Audio path should be given to TCU(MCAN Fct Id:210h/212h)
 */
class ACNRequestStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ACNRequestStatus ();

    /**
     * Copy constructor
     */
    inline  ACNRequestStatus (const ACNRequestStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ACNRequestStatus (bool bACNActive_, bool bValid_);

    /**
     * Destructor
     */
    inline virtual  ~ACNRequestStatus();

    /**
     * Assignment operator
     */
    inline ACNRequestStatus& operator = (const ACNRequestStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ACNRequestStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ACNRequestStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ACNRequestStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ACNRequestStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bACNActive"

    static const int kBACNActive = 0;

    /**
     * Clears the field "bACNActive".
     *
     * The field will be set to its default value. The hasBACNActive()
     * method will return false.
     */
    inline void clearBACNActive();

    /**
     * Checks whether the field "bACNActive" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBACNActive()). Otherwise it will return false.
     */
    inline bool hasBACNActive () const;

    /**
     * Returns the value of the member "bACNActive".
     *
     * If TRUE the TCU requests for the ACN service. If False TCU requests for ACN end
     *
     * @return The value of the field "bACNActive"
     */
    inline bool getBACNActive () const;

    /**
     * Sets the value of the member "bACNActive".
     *
     * If TRUE the TCU requests for the ACN service. If False TCU requests for ACN end
     *
     * @param bACNActive The value which will be set
     */
    inline void setBACNActive (bool bACNActive_);

    // API of field "bValid"

    static const int kBValid = 1;

    /**
     * Clears the field "bValid".
     *
     * The field will be set to its default value. The hasBValid()
     * method will return false.
     */
    inline void clearBValid();

    /**
     * Checks whether the field "bValid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBValid()). Otherwise it will return false.
     */
    inline bool hasBValid () const;

    /**
     * Returns the value of the member "bValid".
     *
     * Value will be set to FALSE on STATUS update for UPREG otherwise value will set to TRUE
     *
     * @return The value of the field "bValid"
     */
    inline bool getBValid () const;

    /**
     * Sets the value of the member "bValid".
     *
     * Value will be set to FALSE on STATUS update for UPREG otherwise value will set to TRUE
     *
     * @param bValid The value which will be set
     */
    inline void setBValid (bool bValid_);

    static const ACNRequestStatus &getDefaultInstance();

private:

    inline void set_has_bACNActive ();

    inline void clear_has_bACNActive ();

    inline void set_has_bValid ();

    inline void clear_has_bValid ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _bACNActive;

    bool _bValid;

};

/**
 * The status message of the property "ACNServiceState"
 * This property gives update about the current state information of an active ACN service(MCAN Fct Id:211h).
 */
class ACNServiceStateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ACNServiceStateStatus ();

    /**
     * Copy constructor
     */
    inline  ACNServiceStateStatus (const ACNServiceStateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ACNServiceStateStatus (::tcu_main_fi_types::T_e8_TCU_ServiceState e8ACNServiceState_);

    /**
     * Destructor
     */
    inline virtual  ~ACNServiceStateStatus();

    /**
     * Assignment operator
     */
    inline ACNServiceStateStatus& operator = (const ACNServiceStateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ACNServiceStateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ACNServiceStateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ACNServiceStateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ACNServiceStateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ACNServiceState"

    static const int kE8ACNServiceState = 0;

    /**
     * Clears the field "e8ACNServiceState".
     *
     * The field will be set to its default value. The hasE8ACNServiceState()
     * method will return false.
     */
    inline void clearE8ACNServiceState();

    /**
     * Checks whether the field "e8ACNServiceState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ACNServiceState()). Otherwise it will return false.
     */
    inline bool hasE8ACNServiceState () const;

    /**
     * Returns the value of the member "e8ACNServiceState".
     *
     * This is an enumeration of the different states of the ACN (Eg: States:Voice calling,Voice call connected,DTMF CLI Start etc).
     *
     * @return The value of the field "e8ACNServiceState"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_ServiceState getE8ACNServiceState () const;

    /**
     * Sets the value of the member "e8ACNServiceState".
     *
     * This is an enumeration of the different states of the ACN (Eg: States:Voice calling,Voice call connected,DTMF CLI Start etc).
     *
     * @param e8ACNServiceState The value which will be set
     */
    inline void setE8ACNServiceState (::tcu_main_fi_types::T_e8_TCU_ServiceState e8ACNServiceState_);

    static const ACNServiceStateStatus &getDefaultInstance();

private:

    inline void set_has_e8ACNServiceState ();

    inline void clear_has_e8ACNServiceState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tcu_main_fi_types::T_e8_TCU_ServiceState _e8ACNServiceState;

};

/**
 * The status message of the property "CurfewAlert"
 * This property gives update about the curfew Alert warning information from TCU(MCAN Fct Id:236h)
 */
class CurfewAlertStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CurfewAlertStatus ();

    /**
     * Copy constructor
     */
    inline  CurfewAlertStatus (const CurfewAlertStatus &rhs);

    /**
     * All fields constructor
     */
    inline  CurfewAlertStatus (::tcu_main_fi_types::T_e8_TCU_CurfewWarning e8CurfewAlertWarning_);

    /**
     * Destructor
     */
    inline virtual  ~CurfewAlertStatus();

    /**
     * Assignment operator
     */
    inline CurfewAlertStatus& operator = (const CurfewAlertStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CurfewAlertStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CurfewAlertStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CurfewAlertStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CurfewAlertStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8CurfewAlertWarning"

    static const int kE8CurfewAlertWarning = 0;

    /**
     * Clears the field "e8CurfewAlertWarning".
     *
     * The field will be set to its default value. The hasE8CurfewAlertWarning()
     * method will return false.
     */
    inline void clearE8CurfewAlertWarning();

    /**
     * Checks whether the field "e8CurfewAlertWarning" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8CurfewAlertWarning()). Otherwise it will return false.
     */
    inline bool hasE8CurfewAlertWarning () const;

    /**
     * Returns the value of the member "e8CurfewAlertWarning".
     *
     * This is an enumeration which gives information about the Curfew alert warning.
     *
     * @return The value of the field "e8CurfewAlertWarning"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_CurfewWarning getE8CurfewAlertWarning () const;

    /**
     * Sets the value of the member "e8CurfewAlertWarning".
     *
     * This is an enumeration which gives information about the Curfew alert warning.
     *
     * @param e8CurfewAlertWarning The value which will be set
     */
    inline void setE8CurfewAlertWarning (::tcu_main_fi_types::T_e8_TCU_CurfewWarning e8CurfewAlertWarning_);

    static const CurfewAlertStatus &getDefaultInstance();

private:

    inline void set_has_e8CurfewAlertWarning ();

    inline void clear_has_e8CurfewAlertWarning ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tcu_main_fi_types::T_e8_TCU_CurfewWarning _e8CurfewAlertWarning;

};

/**
 * The status message of the property "GeoFence"
 * This property gives update when the Vehicle detects that Geo Fence has been broken(MCAN Fct Id:235h)
 */
class GeoFenceStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GeoFenceStatus ();

    /**
     * Copy constructor
     */
    inline  GeoFenceStatus (const GeoFenceStatus &rhs);

    /**
     * All fields constructor
     */
    inline  GeoFenceStatus (bool bStatusFromTCU_);

    /**
     * Destructor
     */
    inline virtual  ~GeoFenceStatus();

    /**
     * Assignment operator
     */
    inline GeoFenceStatus& operator = (const GeoFenceStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GeoFenceStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GeoFenceStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GeoFenceStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GeoFenceStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bStatusFromTCU"

    static const int kBStatusFromTCU = 0;

    /**
     * Clears the field "bStatusFromTCU".
     *
     * The field will be set to its default value. The hasBStatusFromTCU()
     * method will return false.
     */
    inline void clearBStatusFromTCU();

    /**
     * Checks whether the field "bStatusFromTCU" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBStatusFromTCU()). Otherwise it will return false.
     */
    inline bool hasBStatusFromTCU () const;

    /**
     * Returns the value of the member "bStatusFromTCU".
     *
     * bStatusFromTCU = true indicates status update from TCU. bStatusFromTCU = false update not from TCU
     *
     * @return The value of the field "bStatusFromTCU"
     */
    inline bool getBStatusFromTCU () const;

    /**
     * Sets the value of the member "bStatusFromTCU".
     *
     * bStatusFromTCU = true indicates status update from TCU. bStatusFromTCU = false update not from TCU
     *
     * @param bStatusFromTCU The value which will be set
     */
    inline void setBStatusFromTCU (bool bStatusFromTCU_);

    static const GeoFenceStatus &getDefaultInstance();

private:

    inline void set_has_bStatusFromTCU ();

    inline void clear_has_bStatusFromTCU ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bStatusFromTCU;

};

/**
 * The status message of the property "SpeedAlert"
 * This property gives update when Speed Alert Warning is obtained from TCU(MCAN Fct Id:234h)
 */
class SpeedAlertStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SpeedAlertStatus ();

    /**
     * Copy constructor
     */
    inline  SpeedAlertStatus (const SpeedAlertStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SpeedAlertStatus (bool bStatusFromTCU_);

    /**
     * Destructor
     */
    inline virtual  ~SpeedAlertStatus();

    /**
     * Assignment operator
     */
    inline SpeedAlertStatus& operator = (const SpeedAlertStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SpeedAlertStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SpeedAlertStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SpeedAlertStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SpeedAlertStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bStatusFromTCU"

    static const int kBStatusFromTCU = 0;

    /**
     * Clears the field "bStatusFromTCU".
     *
     * The field will be set to its default value. The hasBStatusFromTCU()
     * method will return false.
     */
    inline void clearBStatusFromTCU();

    /**
     * Checks whether the field "bStatusFromTCU" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBStatusFromTCU()). Otherwise it will return false.
     */
    inline bool hasBStatusFromTCU () const;

    /**
     * Returns the value of the member "bStatusFromTCU".
     *
     * bStatusFromTCU = true indicates status update from TCU. bStatusFromTCU = false update not from TCU
     *
     * @return The value of the field "bStatusFromTCU"
     */
    inline bool getBStatusFromTCU () const;

    /**
     * Sets the value of the member "bStatusFromTCU".
     *
     * bStatusFromTCU = true indicates status update from TCU. bStatusFromTCU = false update not from TCU
     *
     * @param bStatusFromTCU The value which will be set
     */
    inline void setBStatusFromTCU (bool bStatusFromTCU_);

    static const SpeedAlertStatus &getDefaultInstance();

private:

    inline void set_has_bStatusFromTCU ();

    inline void clear_has_bStatusFromTCU ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bStatusFromTCU;

};

/**
 * The error message of 'GetTCUState'
 * Error Message
 */
class GetTCUStateErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetTCUStateErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetTCUStateErrorStructure (const GetTCUStateErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetTCUStateErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~GetTCUStateErrorStructure();

    /**
     * Assignment operator
     */
    inline GetTCUStateErrorStructure& operator = (const GetTCUStateErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetTCUStateErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetTCUStateErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetTCUStateErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetTCUStateErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const GetTCUStateErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'GetTCUState'
 * Error Message
 */
class GetTCUStateError  : public ::asf::core::Payload {
public:

    enum GetTCUStateErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetTCUStateError ();

   /**
     * Copy constructor
     */
    inline  GetTCUStateError (const GetTCUStateError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetTCUStateError();

    /**
     * Assigns a new value to this object.
     */
    inline GetTCUStateError& operator = (const GetTCUStateError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetTCUStateError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetTCUStateError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetTCUStateError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetTCUStateError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetTCUStateError::GetTCUStateErrorField getField () const;

    inline void setField(GetTCUStateError::GetTCUStateErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetTCUStateErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetTCUStateErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetTCUStateErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetTCUStateErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetTCUStateErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetTCUStateErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetTCUStateErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetTCUStateErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetTCUStateError &getDefaultInstance();

private:

    inline void cloneData (const GetTCUStateError& rhs);

    inline void deleteData ();

    GetTCUStateErrorField __field;

    union {
        GetTCUStateErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "TCUState"
 * This property gives update about the TCU status on request from ITM or when there is any indication by TCU(MCAN Fct Id:103h)
 */
class TCUStateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TCUStateStatus ();

    /**
     * Copy constructor
     */
    inline  TCUStateStatus (const TCUStateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  TCUStateStatus (::tcu_main_fi_types::T_e8_TCU_ModemStatus e8ModemStatus_, ::tcu_main_fi_types::T_e8_TCU_TCUStatus e8TcuStatus_, ::tcu_main_fi_types::T_e8_TCU_GSMStatus e8GSMStatus_, uint8 u8GSMRSSILevel_, ::tcu_main_fi_types::T_e8_TCU_WifiStatus e8WifiStatus_, ::tcu_main_fi_types::T_e8_TCU_WifiMode e8WifiMode_, ::tcu_main_fi_types::T_e8_TCU_WifiHotSpotStatus e8WifiHotSpotStatus_, ::tcu_main_fi_types::T_e8_TCU_WifiClientStatus e8WifiClientStatus_, ::tcu_main_fi_types::T_e8_TCU_GSMDataMode e8GSMDataMode_, uint8 u8WifiClientSSID_, uint8 u8WifiClientPower_, ::tcu_main_fi_types::T_e8_TCU_Opcode e8Opcode_);

    /**
     * Destructor
     */
    inline virtual  ~TCUStateStatus();

    /**
     * Assignment operator
     */
    inline TCUStateStatus& operator = (const TCUStateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TCUStateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TCUStateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TCUStateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TCUStateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ModemStatus"

    static const int kE8ModemStatus = 0;

    /**
     * Clears the field "e8ModemStatus".
     *
     * The field will be set to its default value. The hasE8ModemStatus()
     * method will return false.
     */
    inline void clearE8ModemStatus();

    /**
     * Checks whether the field "e8ModemStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ModemStatus()). Otherwise it will return false.
     */
    inline bool hasE8ModemStatus () const;

    /**
     * Returns the value of the member "e8ModemStatus".
     *
     * Modem state information of TCU.
     *
     * @return The value of the field "e8ModemStatus"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_ModemStatus getE8ModemStatus () const;

    /**
     * Sets the value of the member "e8ModemStatus".
     *
     * Modem state information of TCU.
     *
     * @param e8ModemStatus The value which will be set
     */
    inline void setE8ModemStatus (::tcu_main_fi_types::T_e8_TCU_ModemStatus e8ModemStatus_);

    // API of field "e8TcuStatus"

    static const int kE8TcuStatus = 1;

    /**
     * Clears the field "e8TcuStatus".
     *
     * The field will be set to its default value. The hasE8TcuStatus()
     * method will return false.
     */
    inline void clearE8TcuStatus();

    /**
     * Checks whether the field "e8TcuStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8TcuStatus()). Otherwise it will return false.
     */
    inline bool hasE8TcuStatus () const;

    /**
     * Returns the value of the member "e8TcuStatus".
     *
     * Activation status of  TCU.
     *
     * @return The value of the field "e8TcuStatus"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_TCUStatus getE8TcuStatus () const;

    /**
     * Sets the value of the member "e8TcuStatus".
     *
     * Activation status of  TCU.
     *
     * @param e8TcuStatus The value which will be set
     */
    inline void setE8TcuStatus (::tcu_main_fi_types::T_e8_TCU_TCUStatus e8TcuStatus_);

    // API of field "e8GSMStatus"

    static const int kE8GSMStatus = 2;

    /**
     * Clears the field "e8GSMStatus".
     *
     * The field will be set to its default value. The hasE8GSMStatus()
     * method will return false.
     */
    inline void clearE8GSMStatus();

    /**
     * Checks whether the field "e8GSMStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8GSMStatus()). Otherwise it will return false.
     */
    inline bool hasE8GSMStatus () const;

    /**
     * Returns the value of the member "e8GSMStatus".
     *
     * GSM Status.
     *
     * @return The value of the field "e8GSMStatus"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_GSMStatus getE8GSMStatus () const;

    /**
     * Sets the value of the member "e8GSMStatus".
     *
     * GSM Status.
     *
     * @param e8GSMStatus The value which will be set
     */
    inline void setE8GSMStatus (::tcu_main_fi_types::T_e8_TCU_GSMStatus e8GSMStatus_);

    // API of field "u8GSMRSSILevel"

    static const int kU8GSMRSSILevel = 3;

    /**
     * Clears the field "u8GSMRSSILevel".
     *
     * The field will be set to its default value. The hasU8GSMRSSILevel()
     * method will return false.
     */
    inline void clearU8GSMRSSILevel();

    /**
     * Checks whether the field "u8GSMRSSILevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8GSMRSSILevel()). Otherwise it will return false.
     */
    inline bool hasU8GSMRSSILevel () const;

    /**
     * Returns the value of the member "u8GSMRSSILevel".
     *
     * GSM RSSI Level
     *
     * @return The value of the field "u8GSMRSSILevel"
     */
    inline uint8 getU8GSMRSSILevel () const;

    /**
     * Sets the value of the member "u8GSMRSSILevel".
     *
     * GSM RSSI Level
     *
     * @param u8GSMRSSILevel The value which will be set
     */
    inline void setU8GSMRSSILevel (uint8 u8GSMRSSILevel_);

    // API of field "e8WifiStatus"

    static const int kE8WifiStatus = 4;

    /**
     * Clears the field "e8WifiStatus".
     *
     * The field will be set to its default value. The hasE8WifiStatus()
     * method will return false.
     */
    inline void clearE8WifiStatus();

    /**
     * Checks whether the field "e8WifiStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8WifiStatus()). Otherwise it will return false.
     */
    inline bool hasE8WifiStatus () const;

    /**
     * Returns the value of the member "e8WifiStatus".
     *
     * Wifi Status
     *
     * @return The value of the field "e8WifiStatus"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_WifiStatus getE8WifiStatus () const;

    /**
     * Sets the value of the member "e8WifiStatus".
     *
     * Wifi Status
     *
     * @param e8WifiStatus The value which will be set
     */
    inline void setE8WifiStatus (::tcu_main_fi_types::T_e8_TCU_WifiStatus e8WifiStatus_);

    // API of field "e8WifiMode"

    static const int kE8WifiMode = 5;

    /**
     * Clears the field "e8WifiMode".
     *
     * The field will be set to its default value. The hasE8WifiMode()
     * method will return false.
     */
    inline void clearE8WifiMode();

    /**
     * Checks whether the field "e8WifiMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8WifiMode()). Otherwise it will return false.
     */
    inline bool hasE8WifiMode () const;

    /**
     * Returns the value of the member "e8WifiMode".
     *
     * Wifi Mode.
     *
     * @return The value of the field "e8WifiMode"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_WifiMode getE8WifiMode () const;

    /**
     * Sets the value of the member "e8WifiMode".
     *
     * Wifi Mode.
     *
     * @param e8WifiMode The value which will be set
     */
    inline void setE8WifiMode (::tcu_main_fi_types::T_e8_TCU_WifiMode e8WifiMode_);

    // API of field "e8WifiHotSpotStatus"

    static const int kE8WifiHotSpotStatus = 6;

    /**
     * Clears the field "e8WifiHotSpotStatus".
     *
     * The field will be set to its default value. The hasE8WifiHotSpotStatus()
     * method will return false.
     */
    inline void clearE8WifiHotSpotStatus();

    /**
     * Checks whether the field "e8WifiHotSpotStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8WifiHotSpotStatus()). Otherwise it will return false.
     */
    inline bool hasE8WifiHotSpotStatus () const;

    /**
     * Returns the value of the member "e8WifiHotSpotStatus".
     *
     * Wifi Hot spot.
     *
     * @return The value of the field "e8WifiHotSpotStatus"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_WifiHotSpotStatus getE8WifiHotSpotStatus () const;

    /**
     * Sets the value of the member "e8WifiHotSpotStatus".
     *
     * Wifi Hot spot.
     *
     * @param e8WifiHotSpotStatus The value which will be set
     */
    inline void setE8WifiHotSpotStatus (::tcu_main_fi_types::T_e8_TCU_WifiHotSpotStatus e8WifiHotSpotStatus_);

    // API of field "e8WifiClientStatus"

    static const int kE8WifiClientStatus = 7;

    /**
     * Clears the field "e8WifiClientStatus".
     *
     * The field will be set to its default value. The hasE8WifiClientStatus()
     * method will return false.
     */
    inline void clearE8WifiClientStatus();

    /**
     * Checks whether the field "e8WifiClientStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8WifiClientStatus()). Otherwise it will return false.
     */
    inline bool hasE8WifiClientStatus () const;

    /**
     * Returns the value of the member "e8WifiClientStatus".
     *
     * Wifi Client Status.
     *
     * @return The value of the field "e8WifiClientStatus"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_WifiClientStatus getE8WifiClientStatus () const;

    /**
     * Sets the value of the member "e8WifiClientStatus".
     *
     * Wifi Client Status.
     *
     * @param e8WifiClientStatus The value which will be set
     */
    inline void setE8WifiClientStatus (::tcu_main_fi_types::T_e8_TCU_WifiClientStatus e8WifiClientStatus_);

    // API of field "e8GSMDataMode"

    static const int kE8GSMDataMode = 8;

    /**
     * Clears the field "e8GSMDataMode".
     *
     * The field will be set to its default value. The hasE8GSMDataMode()
     * method will return false.
     */
    inline void clearE8GSMDataMode();

    /**
     * Checks whether the field "e8GSMDataMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8GSMDataMode()). Otherwise it will return false.
     */
    inline bool hasE8GSMDataMode () const;

    /**
     * Returns the value of the member "e8GSMDataMode".
     *
     * GSM Data Mode.
     *
     * @return The value of the field "e8GSMDataMode"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_GSMDataMode getE8GSMDataMode () const;

    /**
     * Sets the value of the member "e8GSMDataMode".
     *
     * GSM Data Mode.
     *
     * @param e8GSMDataMode The value which will be set
     */
    inline void setE8GSMDataMode (::tcu_main_fi_types::T_e8_TCU_GSMDataMode e8GSMDataMode_);

    // API of field "u8WifiClientSSID"

    static const int kU8WifiClientSSID = 9;

    /**
     * Clears the field "u8WifiClientSSID".
     *
     * The field will be set to its default value. The hasU8WifiClientSSID()
     * method will return false.
     */
    inline void clearU8WifiClientSSID();

    /**
     * Checks whether the field "u8WifiClientSSID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8WifiClientSSID()). Otherwise it will return false.
     */
    inline bool hasU8WifiClientSSID () const;

    /**
     * Returns the value of the member "u8WifiClientSSID".
     *
     * Wifi Client SSID.
     *
     * @return The value of the field "u8WifiClientSSID"
     */
    inline uint8 getU8WifiClientSSID () const;

    /**
     * Sets the value of the member "u8WifiClientSSID".
     *
     * Wifi Client SSID.
     *
     * @param u8WifiClientSSID The value which will be set
     */
    inline void setU8WifiClientSSID (uint8 u8WifiClientSSID_);

    // API of field "u8WifiClientPower"

    static const int kU8WifiClientPower = 10;

    /**
     * Clears the field "u8WifiClientPower".
     *
     * The field will be set to its default value. The hasU8WifiClientPower()
     * method will return false.
     */
    inline void clearU8WifiClientPower();

    /**
     * Checks whether the field "u8WifiClientPower" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8WifiClientPower()). Otherwise it will return false.
     */
    inline bool hasU8WifiClientPower () const;

    /**
     * Returns the value of the member "u8WifiClientPower".
     *
     * Wifi Client Power.
     *
     * @return The value of the field "u8WifiClientPower"
     */
    inline uint8 getU8WifiClientPower () const;

    /**
     * Sets the value of the member "u8WifiClientPower".
     *
     * Wifi Client Power.
     *
     * @param u8WifiClientPower The value which will be set
     */
    inline void setU8WifiClientPower (uint8 u8WifiClientPower_);

    // API of field "e8Opcode"

    static const int kE8Opcode = 11;

    /**
     * Clears the field "e8Opcode".
     *
     * The field will be set to its default value. The hasE8Opcode()
     * method will return false.
     */
    inline void clearE8Opcode();

    /**
     * Checks whether the field "e8Opcode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Opcode()). Otherwise it will return false.
     */
    inline bool hasE8Opcode () const;

    /**
     * Returns the value of the member "e8Opcode".
     *
     * Opcode Information
     *
     * @return The value of the field "e8Opcode"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_Opcode getE8Opcode () const;

    /**
     * Sets the value of the member "e8Opcode".
     *
     * Opcode Information
     *
     * @param e8Opcode The value which will be set
     */
    inline void setE8Opcode (::tcu_main_fi_types::T_e8_TCU_Opcode e8Opcode_);

    static const TCUStateStatus &getDefaultInstance();

private:

    inline void set_has_e8ModemStatus ();

    inline void clear_has_e8ModemStatus ();

    inline void set_has_e8TcuStatus ();

    inline void clear_has_e8TcuStatus ();

    inline void set_has_e8GSMStatus ();

    inline void clear_has_e8GSMStatus ();

    inline void set_has_u8GSMRSSILevel ();

    inline void clear_has_u8GSMRSSILevel ();

    inline void set_has_e8WifiStatus ();

    inline void clear_has_e8WifiStatus ();

    inline void set_has_e8WifiMode ();

    inline void clear_has_e8WifiMode ();

    inline void set_has_e8WifiHotSpotStatus ();

    inline void clear_has_e8WifiHotSpotStatus ();

    inline void set_has_e8WifiClientStatus ();

    inline void clear_has_e8WifiClientStatus ();

    inline void set_has_e8GSMDataMode ();

    inline void clear_has_e8GSMDataMode ();

    inline void set_has_u8WifiClientSSID ();

    inline void clear_has_u8WifiClientSSID ();

    inline void set_has_u8WifiClientPower ();

    inline void clear_has_u8WifiClientPower ();

    inline void set_has_e8Opcode ();

    inline void clear_has_e8Opcode ();

    uint32 _has_bits_[ (12 + 31) / 32];

    ::tcu_main_fi_types::T_e8_TCU_ModemStatus _e8ModemStatus;

    ::tcu_main_fi_types::T_e8_TCU_TCUStatus _e8TcuStatus;

    ::tcu_main_fi_types::T_e8_TCU_GSMStatus _e8GSMStatus;

    uint8 _u8GSMRSSILevel;

    ::tcu_main_fi_types::T_e8_TCU_WifiStatus _e8WifiStatus;

    ::tcu_main_fi_types::T_e8_TCU_WifiMode _e8WifiMode;

    ::tcu_main_fi_types::T_e8_TCU_WifiHotSpotStatus _e8WifiHotSpotStatus;

    ::tcu_main_fi_types::T_e8_TCU_WifiClientStatus _e8WifiClientStatus;

    ::tcu_main_fi_types::T_e8_TCU_GSMDataMode _e8GSMDataMode;

    uint8 _u8WifiClientSSID;

    uint8 _u8WifiClientPower;

    ::tcu_main_fi_types::T_e8_TCU_Opcode _e8Opcode;

};

/**
 * The start message of the method "GetIDInfo"
 * This method is called by ITM to TCU to recieve TCU_ID, ICC_ID, VIN, PIN(MCAN Fct Id:233h).
 */
class GetIDInfoStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetIDInfoStart ();

    /**
     * Copy constructor
     */
    inline  GetIDInfoStart (const GetIDInfoStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetIDInfoStart (const ::std::string& NaviId_, const ::std::string& MapVersion_);

    /**
     * Destructor
     */
    inline virtual  ~GetIDInfoStart();

    /**
     * Assignment operator
     */
    inline GetIDInfoStart& operator = (const GetIDInfoStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetIDInfoStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetIDInfoStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetIDInfoStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetIDInfoStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "NaviId"

    static const int kNaviId = 0;

    /**
     * Clears the field "NaviId".
     *
     * The field will be set to its default value. The hasNaviId()
     * method will return false.
     */
    inline void clearNaviId();

    /**
     * Checks whether the field "NaviId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNaviId()). Otherwise it will return false.
     */
    inline bool hasNaviId () const;

    /**
     * Returns the value of the member "NaviId".
     *
     * Navi Id.
     *
     * @return The value of the field "NaviId"
     */
    inline const ::std::string& getNaviId () const;

    /**
     * Retrieves the value of the field "NaviId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "NaviId".
     */
    inline ::std::string& getNaviIdMutable ();

    /**
     * Sets the value of the member "NaviId".
     *
     * Navi Id.
     *
     * @param NaviId The value which will be set
     */
    inline void setNaviId (const ::std::string& NaviId_);

    /**
     * Sets the value of the member "NaviId".
     *
     * Navi Id.
     *
     * @param NaviId The value which will be set
     */
    inline void setNaviId (const char* NaviId_);

    /**
     * Sets the value of the member "NaviId".
     *
     * Navi Id.
     *
     * @param NaviId The value which will be set
     */
    inline void setNaviId (const char* value, size_t size);

    // API of field "MapVersion"

    static const int kMapVersion = 1;

    /**
     * Clears the field "MapVersion".
     *
     * The field will be set to its default value. The hasMapVersion()
     * method will return false.
     */
    inline void clearMapVersion();

    /**
     * Checks whether the field "MapVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMapVersion()). Otherwise it will return false.
     */
    inline bool hasMapVersion () const;

    /**
     * Returns the value of the member "MapVersion".
     *
     * Map Version.
     *
     * @return The value of the field "MapVersion"
     */
    inline const ::std::string& getMapVersion () const;

    /**
     * Retrieves the value of the field "MapVersion" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "MapVersion".
     */
    inline ::std::string& getMapVersionMutable ();

    /**
     * Sets the value of the member "MapVersion".
     *
     * Map Version.
     *
     * @param MapVersion The value which will be set
     */
    inline void setMapVersion (const ::std::string& MapVersion_);

    /**
     * Sets the value of the member "MapVersion".
     *
     * Map Version.
     *
     * @param MapVersion The value which will be set
     */
    inline void setMapVersion (const char* MapVersion_);

    /**
     * Sets the value of the member "MapVersion".
     *
     * Map Version.
     *
     * @param MapVersion The value which will be set
     */
    inline void setMapVersion (const char* value, size_t size);

    static const GetIDInfoStart &getDefaultInstance();

private:

    inline void set_has_NaviId ();

    inline void clear_has_NaviId ();

    inline void set_has_MapVersion ();

    inline void clear_has_MapVersion ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _NaviId;

    ::std::string _MapVersion;

};

/**
 * The error message of 'GetIDInfo'
 * Error Message
 */
class GetIDInfoErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetIDInfoErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetIDInfoErrorStructure (const GetIDInfoErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetIDInfoErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~GetIDInfoErrorStructure();

    /**
     * Assignment operator
     */
    inline GetIDInfoErrorStructure& operator = (const GetIDInfoErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetIDInfoErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetIDInfoErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetIDInfoErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetIDInfoErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const GetIDInfoErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'GetIDInfo'
 * Error Message
 */
class GetIDInfoError  : public ::asf::core::Payload {
public:

    enum GetIDInfoErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetIDInfoError ();

   /**
     * Copy constructor
     */
    inline  GetIDInfoError (const GetIDInfoError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetIDInfoError();

    /**
     * Assigns a new value to this object.
     */
    inline GetIDInfoError& operator = (const GetIDInfoError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetIDInfoError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetIDInfoError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetIDInfoError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetIDInfoError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetIDInfoError::GetIDInfoErrorField getField () const;

    inline void setField(GetIDInfoError::GetIDInfoErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetIDInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetIDInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetIDInfoErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetIDInfoErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetIDInfoErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetIDInfoErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetIDInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetIDInfoErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetIDInfoError &getDefaultInstance();

private:

    inline void cloneData (const GetIDInfoError& rhs);

    inline void deleteData ();

    GetIDInfoErrorField __field;

    union {
        GetIDInfoErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "IDInfoStatus"
 * This property gives update about the TCU_ID, ICC_ID, VIN from TCU (MCAN Fct Id:233h)
 */
class IDInfoStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IDInfoStatusStatus ();

    /**
     * Copy constructor
     */
    inline  IDInfoStatusStatus (const IDInfoStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  IDInfoStatusStatus (::tcu_main_fi_types::T_e8_TCU_InvalidParameter e8InvalidParameter_, const ::std::string& sTCUID_, const ::std::string& sICCID_, const ::std::string& sVIN_);

    /**
     * Destructor
     */
    inline virtual  ~IDInfoStatusStatus();

    /**
     * Assignment operator
     */
    inline IDInfoStatusStatus& operator = (const IDInfoStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IDInfoStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IDInfoStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IDInfoStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IDInfoStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8InvalidParameter"

    static const int kE8InvalidParameter = 0;

    /**
     * Clears the field "e8InvalidParameter".
     *
     * The field will be set to its default value. The hasE8InvalidParameter()
     * method will return false.
     */
    inline void clearE8InvalidParameter();

    /**
     * Checks whether the field "e8InvalidParameter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8InvalidParameter()). Otherwise it will return false.
     */
    inline bool hasE8InvalidParameter () const;

    /**
     * Returns the value of the member "e8InvalidParameter".
     *
     *
     *
     * @return The value of the field "e8InvalidParameter"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_InvalidParameter getE8InvalidParameter () const;

    /**
     * Sets the value of the member "e8InvalidParameter".
     *
     *
     *
     * @param e8InvalidParameter The value which will be set
     */
    inline void setE8InvalidParameter (::tcu_main_fi_types::T_e8_TCU_InvalidParameter e8InvalidParameter_);

    // API of field "sTCUID"

    static const int kSTCUID = 1;

    /**
     * Clears the field "sTCUID".
     *
     * The field will be set to its default value. The hasSTCUID()
     * method will return false.
     */
    inline void clearSTCUID();

    /**
     * Checks whether the field "sTCUID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSTCUID()). Otherwise it will return false.
     */
    inline bool hasSTCUID () const;

    /**
     * Returns the value of the member "sTCUID".
     *
     * TCU ID.
     *
     * @return The value of the field "sTCUID"
     */
    inline const ::std::string& getSTCUID () const;

    /**
     * Retrieves the value of the field "sTCUID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sTCUID".
     */
    inline ::std::string& getSTCUIDMutable ();

    /**
     * Sets the value of the member "sTCUID".
     *
     * TCU ID.
     *
     * @param sTCUID The value which will be set
     */
    inline void setSTCUID (const ::std::string& sTCUID_);

    /**
     * Sets the value of the member "sTCUID".
     *
     * TCU ID.
     *
     * @param sTCUID The value which will be set
     */
    inline void setSTCUID (const char* sTCUID_);

    /**
     * Sets the value of the member "sTCUID".
     *
     * TCU ID.
     *
     * @param sTCUID The value which will be set
     */
    inline void setSTCUID (const char* value, size_t size);

    // API of field "sICCID"

    static const int kSICCID = 2;

    /**
     * Clears the field "sICCID".
     *
     * The field will be set to its default value. The hasSICCID()
     * method will return false.
     */
    inline void clearSICCID();

    /**
     * Checks whether the field "sICCID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSICCID()). Otherwise it will return false.
     */
    inline bool hasSICCID () const;

    /**
     * Returns the value of the member "sICCID".
     *
     * ICC ID
     *
     * @return The value of the field "sICCID"
     */
    inline const ::std::string& getSICCID () const;

    /**
     * Retrieves the value of the field "sICCID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sICCID".
     */
    inline ::std::string& getSICCIDMutable ();

    /**
     * Sets the value of the member "sICCID".
     *
     * ICC ID
     *
     * @param sICCID The value which will be set
     */
    inline void setSICCID (const ::std::string& sICCID_);

    /**
     * Sets the value of the member "sICCID".
     *
     * ICC ID
     *
     * @param sICCID The value which will be set
     */
    inline void setSICCID (const char* sICCID_);

    /**
     * Sets the value of the member "sICCID".
     *
     * ICC ID
     *
     * @param sICCID The value which will be set
     */
    inline void setSICCID (const char* value, size_t size);

    // API of field "sVIN"

    static const int kSVIN = 3;

    /**
     * Clears the field "sVIN".
     *
     * The field will be set to its default value. The hasSVIN()
     * method will return false.
     */
    inline void clearSVIN();

    /**
     * Checks whether the field "sVIN" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSVIN()). Otherwise it will return false.
     */
    inline bool hasSVIN () const;

    /**
     * Returns the value of the member "sVIN".
     *
     * Vehicle Identification Number.
     *
     * @return The value of the field "sVIN"
     */
    inline const ::std::string& getSVIN () const;

    /**
     * Retrieves the value of the field "sVIN" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sVIN".
     */
    inline ::std::string& getSVINMutable ();

    /**
     * Sets the value of the member "sVIN".
     *
     * Vehicle Identification Number.
     *
     * @param sVIN The value which will be set
     */
    inline void setSVIN (const ::std::string& sVIN_);

    /**
     * Sets the value of the member "sVIN".
     *
     * Vehicle Identification Number.
     *
     * @param sVIN The value which will be set
     */
    inline void setSVIN (const char* sVIN_);

    /**
     * Sets the value of the member "sVIN".
     *
     * Vehicle Identification Number.
     *
     * @param sVIN The value which will be set
     */
    inline void setSVIN (const char* value, size_t size);

    static const IDInfoStatusStatus &getDefaultInstance();

private:

    inline void set_has_e8InvalidParameter ();

    inline void clear_has_e8InvalidParameter ();

    inline void set_has_sTCUID ();

    inline void clear_has_sTCUID ();

    inline void set_has_sICCID ();

    inline void clear_has_sICCID ();

    inline void set_has_sVIN ();

    inline void clear_has_sVIN ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::tcu_main_fi_types::T_e8_TCU_InvalidParameter _e8InvalidParameter;

    ::std::string _sTCUID;

    ::std::string _sICCID;

    ::std::string _sVIN;

};

/**
 * The start message of the method "SetDriverInfoUploadPermit"
 * This method is called by ITM requesting for user info upload permit(MCAN Fct Id:240h).
 */
class SetDriverInfoUploadPermitStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetDriverInfoUploadPermitStart ();

    /**
     * Copy constructor
     */
    inline  SetDriverInfoUploadPermitStart (const SetDriverInfoUploadPermitStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetDriverInfoUploadPermitStart (::tcu_main_fi_types::T_e8_TCU_PermitSetting e8PermitSetting_);

    /**
     * Destructor
     */
    inline virtual  ~SetDriverInfoUploadPermitStart();

    /**
     * Assignment operator
     */
    inline SetDriverInfoUploadPermitStart& operator = (const SetDriverInfoUploadPermitStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetDriverInfoUploadPermitStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetDriverInfoUploadPermitStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetDriverInfoUploadPermitStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetDriverInfoUploadPermitStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8PermitSetting"

    static const int kE8PermitSetting = 0;

    /**
     * Clears the field "e8PermitSetting".
     *
     * The field will be set to its default value. The hasE8PermitSetting()
     * method will return false.
     */
    inline void clearE8PermitSetting();

    /**
     * Checks whether the field "e8PermitSetting" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8PermitSetting()). Otherwise it will return false.
     */
    inline bool hasE8PermitSetting () const;

    /**
     * Returns the value of the member "e8PermitSetting".
     *
     * Permit Setting
     *
     * @return The value of the field "e8PermitSetting"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_PermitSetting getE8PermitSetting () const;

    /**
     * Sets the value of the member "e8PermitSetting".
     *
     * Permit Setting
     *
     * @param e8PermitSetting The value which will be set
     */
    inline void setE8PermitSetting (::tcu_main_fi_types::T_e8_TCU_PermitSetting e8PermitSetting_);

    static const SetDriverInfoUploadPermitStart &getDefaultInstance();

private:

    inline void set_has_e8PermitSetting ();

    inline void clear_has_e8PermitSetting ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tcu_main_fi_types::T_e8_TCU_PermitSetting _e8PermitSetting;

};

/**
 * The error message of 'SetDriverInfoUploadPermit'
 * Error Message
 */
class SetDriverInfoUploadPermitErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SetDriverInfoUploadPermitErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SetDriverInfoUploadPermitErrorStructure (const SetDriverInfoUploadPermitErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SetDriverInfoUploadPermitErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~SetDriverInfoUploadPermitErrorStructure();

    /**
     * Assignment operator
     */
    inline SetDriverInfoUploadPermitErrorStructure& operator = (const SetDriverInfoUploadPermitErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetDriverInfoUploadPermitErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetDriverInfoUploadPermitErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetDriverInfoUploadPermitErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetDriverInfoUploadPermitErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const SetDriverInfoUploadPermitErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'SetDriverInfoUploadPermit'
 * Error Message
 */
class SetDriverInfoUploadPermitError  : public ::asf::core::Payload {
public:

    enum SetDriverInfoUploadPermitErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SetDriverInfoUploadPermitError ();

   /**
     * Copy constructor
     */
    inline  SetDriverInfoUploadPermitError (const SetDriverInfoUploadPermitError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SetDriverInfoUploadPermitError();

    /**
     * Assigns a new value to this object.
     */
    inline SetDriverInfoUploadPermitError& operator = (const SetDriverInfoUploadPermitError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetDriverInfoUploadPermitError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetDriverInfoUploadPermitError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetDriverInfoUploadPermitError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetDriverInfoUploadPermitError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SetDriverInfoUploadPermitError::SetDriverInfoUploadPermitErrorField getField () const;

    inline void setField(SetDriverInfoUploadPermitError::SetDriverInfoUploadPermitErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SetDriverInfoUploadPermitErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SetDriverInfoUploadPermitErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SetDriverInfoUploadPermitErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SetDriverInfoUploadPermitErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SetDriverInfoUploadPermitErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SetDriverInfoUploadPermitErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SetDriverInfoUploadPermitErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SetDriverInfoUploadPermitErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SetDriverInfoUploadPermitError &getDefaultInstance();

private:

    inline void cloneData (const SetDriverInfoUploadPermitError& rhs);

    inline void deleteData ();

    SetDriverInfoUploadPermitErrorField __field;

    union {
        SetDriverInfoUploadPermitErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "DriverInfoUploadPermitStatus"
 * This property gives update about the driver info upload permit (MCAN Fct Id:240h)
 */
class DriverInfoUploadPermitStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DriverInfoUploadPermitStatusStatus ();

    /**
     * Copy constructor
     */
    inline  DriverInfoUploadPermitStatusStatus (const DriverInfoUploadPermitStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DriverInfoUploadPermitStatusStatus (::tcu_main_fi_types::T_e8_TCU_InvalidParameter e8InvalidParameter_, ::tcu_main_fi_types::T_e8_TCU_PermitSetting e8PermitSetting_, bool bValid_, ::tcu_main_fi_types::T_e8_TCU_APP_Context e8AppContext_);

    /**
     * Destructor
     */
    inline virtual  ~DriverInfoUploadPermitStatusStatus();

    /**
     * Assignment operator
     */
    inline DriverInfoUploadPermitStatusStatus& operator = (const DriverInfoUploadPermitStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DriverInfoUploadPermitStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DriverInfoUploadPermitStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DriverInfoUploadPermitStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DriverInfoUploadPermitStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8InvalidParameter"

    static const int kE8InvalidParameter = 0;

    /**
     * Clears the field "e8InvalidParameter".
     *
     * The field will be set to its default value. The hasE8InvalidParameter()
     * method will return false.
     */
    inline void clearE8InvalidParameter();

    /**
     * Checks whether the field "e8InvalidParameter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8InvalidParameter()). Otherwise it will return false.
     */
    inline bool hasE8InvalidParameter () const;

    /**
     * Returns the value of the member "e8InvalidParameter".
     *
     *
     *
     * @return The value of the field "e8InvalidParameter"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_InvalidParameter getE8InvalidParameter () const;

    /**
     * Sets the value of the member "e8InvalidParameter".
     *
     *
     *
     * @param e8InvalidParameter The value which will be set
     */
    inline void setE8InvalidParameter (::tcu_main_fi_types::T_e8_TCU_InvalidParameter e8InvalidParameter_);

    // API of field "e8PermitSetting"

    static const int kE8PermitSetting = 1;

    /**
     * Clears the field "e8PermitSetting".
     *
     * The field will be set to its default value. The hasE8PermitSetting()
     * method will return false.
     */
    inline void clearE8PermitSetting();

    /**
     * Checks whether the field "e8PermitSetting" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8PermitSetting()). Otherwise it will return false.
     */
    inline bool hasE8PermitSetting () const;

    /**
     * Returns the value of the member "e8PermitSetting".
     *
     * Permit Setting.
     *
     * @return The value of the field "e8PermitSetting"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_PermitSetting getE8PermitSetting () const;

    /**
     * Sets the value of the member "e8PermitSetting".
     *
     * Permit Setting.
     *
     * @param e8PermitSetting The value which will be set
     */
    inline void setE8PermitSetting (::tcu_main_fi_types::T_e8_TCU_PermitSetting e8PermitSetting_);

    // API of field "bValid"

    static const int kBValid = 2;

    /**
     * Clears the field "bValid".
     *
     * The field will be set to its default value. The hasBValid()
     * method will return false.
     */
    inline void clearBValid();

    /**
     * Checks whether the field "bValid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBValid()). Otherwise it will return false.
     */
    inline bool hasBValid () const;

    /**
     * Returns the value of the member "bValid".
     *
     * Value will be set to FALSE on STATUS update for UPREG otherwise value will set to TRUE
     *
     * @return The value of the field "bValid"
     */
    inline bool getBValid () const;

    /**
     * Sets the value of the member "bValid".
     *
     * Value will be set to FALSE on STATUS update for UPREG otherwise value will set to TRUE
     *
     * @param bValid The value which will be set
     */
    inline void setBValid (bool bValid_);

    // API of field "e8AppContext"

    static const int kE8AppContext = 3;

    /**
     * Clears the field "e8AppContext".
     *
     * The field will be set to its default value. The hasE8AppContext()
     * method will return false.
     */
    inline void clearE8AppContext();

    /**
     * Checks whether the field "e8AppContext" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8AppContext()). Otherwise it will return false.
     */
    inline bool hasE8AppContext () const;

    /**
     * Returns the value of the member "e8AppContext".
     *
     * APP Context.
     *
     * @return The value of the field "e8AppContext"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_APP_Context getE8AppContext () const;

    /**
     * Sets the value of the member "e8AppContext".
     *
     * APP Context.
     *
     * @param e8AppContext The value which will be set
     */
    inline void setE8AppContext (::tcu_main_fi_types::T_e8_TCU_APP_Context e8AppContext_);

    static const DriverInfoUploadPermitStatusStatus &getDefaultInstance();

private:

    inline void set_has_e8InvalidParameter ();

    inline void clear_has_e8InvalidParameter ();

    inline void set_has_e8PermitSetting ();

    inline void clear_has_e8PermitSetting ();

    inline void set_has_bValid ();

    inline void clear_has_bValid ();

    inline void set_has_e8AppContext ();

    inline void clear_has_e8AppContext ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::tcu_main_fi_types::T_e8_TCU_InvalidParameter _e8InvalidParameter;

    ::tcu_main_fi_types::T_e8_TCU_PermitSetting _e8PermitSetting;

    bool _bValid;

    ::tcu_main_fi_types::T_e8_TCU_APP_Context _e8AppContext;

};

/**
 * The status message of the property "SMSNotificationStatus"
 * This property gives the SMS notification from TCU to download the content from the center (MCAN Fct Id:241h)
 */
class SMSNotificationStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SMSNotificationStatusStatus ();

    /**
     * Copy constructor
     */
    inline  SMSNotificationStatusStatus (const SMSNotificationStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SMSNotificationStatusStatus (::tcu_main_fi_types::T_e8_TCU_PopUpFlag e8PopUpFlag_, uint8 u8ConnectingPoint_, uint16 u16InformationChannel_);

    /**
     * Destructor
     */
    inline virtual  ~SMSNotificationStatusStatus();

    /**
     * Assignment operator
     */
    inline SMSNotificationStatusStatus& operator = (const SMSNotificationStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SMSNotificationStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SMSNotificationStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SMSNotificationStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SMSNotificationStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8PopUpFlag"

    static const int kE8PopUpFlag = 0;

    /**
     * Clears the field "e8PopUpFlag".
     *
     * The field will be set to its default value. The hasE8PopUpFlag()
     * method will return false.
     */
    inline void clearE8PopUpFlag();

    /**
     * Checks whether the field "e8PopUpFlag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8PopUpFlag()). Otherwise it will return false.
     */
    inline bool hasE8PopUpFlag () const;

    /**
     * Returns the value of the member "e8PopUpFlag".
     *
     * Info to display/Not display the SMS notification.
     *
     * @return The value of the field "e8PopUpFlag"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_PopUpFlag getE8PopUpFlag () const;

    /**
     * Sets the value of the member "e8PopUpFlag".
     *
     * Info to display/Not display the SMS notification.
     *
     * @param e8PopUpFlag The value which will be set
     */
    inline void setE8PopUpFlag (::tcu_main_fi_types::T_e8_TCU_PopUpFlag e8PopUpFlag_);

    // API of field "u8ConnectingPoint"

    static const int kU8ConnectingPoint = 1;

    /**
     * Clears the field "u8ConnectingPoint".
     *
     * The field will be set to its default value. The hasU8ConnectingPoint()
     * method will return false.
     */
    inline void clearU8ConnectingPoint();

    /**
     * Checks whether the field "u8ConnectingPoint" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8ConnectingPoint()). Otherwise it will return false.
     */
    inline bool hasU8ConnectingPoint () const;

    /**
     * Returns the value of the member "u8ConnectingPoint".
     *
     * The ID number of Information channel connecting point.
     *
     * @return The value of the field "u8ConnectingPoint"
     */
    inline uint8 getU8ConnectingPoint () const;

    /**
     * Sets the value of the member "u8ConnectingPoint".
     *
     * The ID number of Information channel connecting point.
     *
     * @param u8ConnectingPoint The value which will be set
     */
    inline void setU8ConnectingPoint (uint8 u8ConnectingPoint_);

    // API of field "u16InformationChannel"

    static const int kU16InformationChannel = 2;

    /**
     * Clears the field "u16InformationChannel".
     *
     * The field will be set to its default value. The hasU16InformationChannel()
     * method will return false.
     */
    inline void clearU16InformationChannel();

    /**
     * Checks whether the field "u16InformationChannel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16InformationChannel()). Otherwise it will return false.
     */
    inline bool hasU16InformationChannel () const;

    /**
     * Returns the value of the member "u16InformationChannel".
     *
     * Information channel ID number.
     *
     * @return The value of the field "u16InformationChannel"
     */
    inline uint16 getU16InformationChannel () const;

    /**
     * Sets the value of the member "u16InformationChannel".
     *
     * Information channel ID number.
     *
     * @param u16InformationChannel The value which will be set
     */
    inline void setU16InformationChannel (uint16 u16InformationChannel_);

    static const SMSNotificationStatusStatus &getDefaultInstance();

private:

    inline void set_has_e8PopUpFlag ();

    inline void clear_has_e8PopUpFlag ();

    inline void set_has_u8ConnectingPoint ();

    inline void clear_has_u8ConnectingPoint ();

    inline void set_has_u16InformationChannel ();

    inline void clear_has_u16InformationChannel ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::tcu_main_fi_types::T_e8_TCU_PopUpFlag _e8PopUpFlag;

    uint8 _u8ConnectingPoint;

    uint16 _u16InformationChannel;

};

/**
 * The error message of 'GetProbeUploadPermit'
 * Error Message
 */
class GetProbeUploadPermitErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetProbeUploadPermitErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetProbeUploadPermitErrorStructure (const GetProbeUploadPermitErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetProbeUploadPermitErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~GetProbeUploadPermitErrorStructure();

    /**
     * Assignment operator
     */
    inline GetProbeUploadPermitErrorStructure& operator = (const GetProbeUploadPermitErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetProbeUploadPermitErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetProbeUploadPermitErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetProbeUploadPermitErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetProbeUploadPermitErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const GetProbeUploadPermitErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'GetProbeUploadPermit'
 * Error Message
 */
class GetProbeUploadPermitError  : public ::asf::core::Payload {
public:

    enum GetProbeUploadPermitErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetProbeUploadPermitError ();

   /**
     * Copy constructor
     */
    inline  GetProbeUploadPermitError (const GetProbeUploadPermitError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetProbeUploadPermitError();

    /**
     * Assigns a new value to this object.
     */
    inline GetProbeUploadPermitError& operator = (const GetProbeUploadPermitError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetProbeUploadPermitError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetProbeUploadPermitError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetProbeUploadPermitError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetProbeUploadPermitError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetProbeUploadPermitError::GetProbeUploadPermitErrorField getField () const;

    inline void setField(GetProbeUploadPermitError::GetProbeUploadPermitErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetProbeUploadPermitErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetProbeUploadPermitErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetProbeUploadPermitErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetProbeUploadPermitErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetProbeUploadPermitErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetProbeUploadPermitErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetProbeUploadPermitErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetProbeUploadPermitErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetProbeUploadPermitError &getDefaultInstance();

private:

    inline void cloneData (const GetProbeUploadPermitError& rhs);

    inline void deleteData ();

    GetProbeUploadPermitErrorField __field;

    union {
        GetProbeUploadPermitErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SetProbeUploadPermit"
 * This method is called by ITM when there is change in Probe Upload permit from ITM side(MCAN Fct Id:244h).
 */
class SetProbeUploadPermitStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetProbeUploadPermitStart ();

    /**
     * Copy constructor
     */
    inline  SetProbeUploadPermitStart (const SetProbeUploadPermitStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetProbeUploadPermitStart (::tcu_main_fi_types::T_e8_TCU_ProbePermitSetting e8ProbePermitSetting_);

    /**
     * Destructor
     */
    inline virtual  ~SetProbeUploadPermitStart();

    /**
     * Assignment operator
     */
    inline SetProbeUploadPermitStart& operator = (const SetProbeUploadPermitStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetProbeUploadPermitStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetProbeUploadPermitStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetProbeUploadPermitStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetProbeUploadPermitStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ProbePermitSetting"

    static const int kE8ProbePermitSetting = 0;

    /**
     * Clears the field "e8ProbePermitSetting".
     *
     * The field will be set to its default value. The hasE8ProbePermitSetting()
     * method will return false.
     */
    inline void clearE8ProbePermitSetting();

    /**
     * Checks whether the field "e8ProbePermitSetting" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ProbePermitSetting()). Otherwise it will return false.
     */
    inline bool hasE8ProbePermitSetting () const;

    /**
     * Returns the value of the member "e8ProbePermitSetting".
     *
     * Probe Permit setting.
     *
     * @return The value of the field "e8ProbePermitSetting"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_ProbePermitSetting getE8ProbePermitSetting () const;

    /**
     * Sets the value of the member "e8ProbePermitSetting".
     *
     * Probe Permit setting.
     *
     * @param e8ProbePermitSetting The value which will be set
     */
    inline void setE8ProbePermitSetting (::tcu_main_fi_types::T_e8_TCU_ProbePermitSetting e8ProbePermitSetting_);

    static const SetProbeUploadPermitStart &getDefaultInstance();

private:

    inline void set_has_e8ProbePermitSetting ();

    inline void clear_has_e8ProbePermitSetting ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tcu_main_fi_types::T_e8_TCU_ProbePermitSetting _e8ProbePermitSetting;

};

/**
 * The error message of 'SetProbeUploadPermit'
 * Error Message
 */
class SetProbeUploadPermitErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SetProbeUploadPermitErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SetProbeUploadPermitErrorStructure (const SetProbeUploadPermitErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SetProbeUploadPermitErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~SetProbeUploadPermitErrorStructure();

    /**
     * Assignment operator
     */
    inline SetProbeUploadPermitErrorStructure& operator = (const SetProbeUploadPermitErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetProbeUploadPermitErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetProbeUploadPermitErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetProbeUploadPermitErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetProbeUploadPermitErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const SetProbeUploadPermitErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'SetProbeUploadPermit'
 * Error Message
 */
class SetProbeUploadPermitError  : public ::asf::core::Payload {
public:

    enum SetProbeUploadPermitErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SetProbeUploadPermitError ();

   /**
     * Copy constructor
     */
    inline  SetProbeUploadPermitError (const SetProbeUploadPermitError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SetProbeUploadPermitError();

    /**
     * Assigns a new value to this object.
     */
    inline SetProbeUploadPermitError& operator = (const SetProbeUploadPermitError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetProbeUploadPermitError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetProbeUploadPermitError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetProbeUploadPermitError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetProbeUploadPermitError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SetProbeUploadPermitError::SetProbeUploadPermitErrorField getField () const;

    inline void setField(SetProbeUploadPermitError::SetProbeUploadPermitErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SetProbeUploadPermitErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SetProbeUploadPermitErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SetProbeUploadPermitErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SetProbeUploadPermitErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SetProbeUploadPermitErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SetProbeUploadPermitErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SetProbeUploadPermitErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SetProbeUploadPermitErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SetProbeUploadPermitError &getDefaultInstance();

private:

    inline void cloneData (const SetProbeUploadPermitError& rhs);

    inline void deleteData ();

    SetProbeUploadPermitErrorField __field;

    union {
        SetProbeUploadPermitErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "ProbeUploadPermitStatus"
 * This property gives update about probe setting both while SET and GET from ITM (MCAN Fct Id:244h)
 */
class ProbeUploadPermitStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ProbeUploadPermitStatusStatus ();

    /**
     * Copy constructor
     */
    inline  ProbeUploadPermitStatusStatus (const ProbeUploadPermitStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ProbeUploadPermitStatusStatus (::tcu_main_fi_types::T_e8_TCU_InvalidParameter e8InvalidParameter_, ::tcu_main_fi_types::T_e8_TCU_ProbePermitSetting e8ProbePermitSetting_);

    /**
     * Destructor
     */
    inline virtual  ~ProbeUploadPermitStatusStatus();

    /**
     * Assignment operator
     */
    inline ProbeUploadPermitStatusStatus& operator = (const ProbeUploadPermitStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ProbeUploadPermitStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ProbeUploadPermitStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ProbeUploadPermitStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ProbeUploadPermitStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8InvalidParameter"

    static const int kE8InvalidParameter = 0;

    /**
     * Clears the field "e8InvalidParameter".
     *
     * The field will be set to its default value. The hasE8InvalidParameter()
     * method will return false.
     */
    inline void clearE8InvalidParameter();

    /**
     * Checks whether the field "e8InvalidParameter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8InvalidParameter()). Otherwise it will return false.
     */
    inline bool hasE8InvalidParameter () const;

    /**
     * Returns the value of the member "e8InvalidParameter".
     *
     *
     *
     * @return The value of the field "e8InvalidParameter"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_InvalidParameter getE8InvalidParameter () const;

    /**
     * Sets the value of the member "e8InvalidParameter".
     *
     *
     *
     * @param e8InvalidParameter The value which will be set
     */
    inline void setE8InvalidParameter (::tcu_main_fi_types::T_e8_TCU_InvalidParameter e8InvalidParameter_);

    // API of field "e8ProbePermitSetting"

    static const int kE8ProbePermitSetting = 1;

    /**
     * Clears the field "e8ProbePermitSetting".
     *
     * The field will be set to its default value. The hasE8ProbePermitSetting()
     * method will return false.
     */
    inline void clearE8ProbePermitSetting();

    /**
     * Checks whether the field "e8ProbePermitSetting" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ProbePermitSetting()). Otherwise it will return false.
     */
    inline bool hasE8ProbePermitSetting () const;

    /**
     * Returns the value of the member "e8ProbePermitSetting".
     *
     * Probe Permit Setting.
     *
     * @return The value of the field "e8ProbePermitSetting"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_ProbePermitSetting getE8ProbePermitSetting () const;

    /**
     * Sets the value of the member "e8ProbePermitSetting".
     *
     * Probe Permit Setting.
     *
     * @param e8ProbePermitSetting The value which will be set
     */
    inline void setE8ProbePermitSetting (::tcu_main_fi_types::T_e8_TCU_ProbePermitSetting e8ProbePermitSetting_);

    static const ProbeUploadPermitStatusStatus &getDefaultInstance();

private:

    inline void set_has_e8InvalidParameter ();

    inline void clear_has_e8InvalidParameter ();

    inline void set_has_e8ProbePermitSetting ();

    inline void clear_has_e8ProbePermitSetting ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::tcu_main_fi_types::T_e8_TCU_InvalidParameter _e8InvalidParameter;

    ::tcu_main_fi_types::T_e8_TCU_ProbePermitSetting _e8ProbePermitSetting;

};

/**
 * The error message of 'SetProbeInfoDelete'
 * Error Message
 */
class SetProbeInfoDeleteErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SetProbeInfoDeleteErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SetProbeInfoDeleteErrorStructure (const SetProbeInfoDeleteErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SetProbeInfoDeleteErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~SetProbeInfoDeleteErrorStructure();

    /**
     * Assignment operator
     */
    inline SetProbeInfoDeleteErrorStructure& operator = (const SetProbeInfoDeleteErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetProbeInfoDeleteErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetProbeInfoDeleteErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetProbeInfoDeleteErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetProbeInfoDeleteErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const SetProbeInfoDeleteErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'SetProbeInfoDelete'
 * Error Message
 */
class SetProbeInfoDeleteError  : public ::asf::core::Payload {
public:

    enum SetProbeInfoDeleteErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SetProbeInfoDeleteError ();

   /**
     * Copy constructor
     */
    inline  SetProbeInfoDeleteError (const SetProbeInfoDeleteError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SetProbeInfoDeleteError();

    /**
     * Assigns a new value to this object.
     */
    inline SetProbeInfoDeleteError& operator = (const SetProbeInfoDeleteError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetProbeInfoDeleteError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetProbeInfoDeleteError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetProbeInfoDeleteError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetProbeInfoDeleteError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SetProbeInfoDeleteError::SetProbeInfoDeleteErrorField getField () const;

    inline void setField(SetProbeInfoDeleteError::SetProbeInfoDeleteErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SetProbeInfoDeleteErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SetProbeInfoDeleteErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SetProbeInfoDeleteErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SetProbeInfoDeleteErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SetProbeInfoDeleteErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SetProbeInfoDeleteErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SetProbeInfoDeleteErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SetProbeInfoDeleteErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SetProbeInfoDeleteError &getDefaultInstance();

private:

    inline void cloneData (const SetProbeInfoDeleteError& rhs);

    inline void deleteData ();

    SetProbeInfoDeleteErrorField __field;

    union {
        SetProbeInfoDeleteErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "ProbeInfoDeleteStatus"
 * This property gives update about whether the the probe info is deleted or not (MCAN Fct Id:245h)
 */
class ProbeInfoDeleteStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ProbeInfoDeleteStatusStatus ();

    /**
     * Copy constructor
     */
    inline  ProbeInfoDeleteStatusStatus (const ProbeInfoDeleteStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ProbeInfoDeleteStatusStatus (bool bStatusFromTCU_);

    /**
     * Destructor
     */
    inline virtual  ~ProbeInfoDeleteStatusStatus();

    /**
     * Assignment operator
     */
    inline ProbeInfoDeleteStatusStatus& operator = (const ProbeInfoDeleteStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ProbeInfoDeleteStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ProbeInfoDeleteStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ProbeInfoDeleteStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ProbeInfoDeleteStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bStatusFromTCU"

    static const int kBStatusFromTCU = 0;

    /**
     * Clears the field "bStatusFromTCU".
     *
     * The field will be set to its default value. The hasBStatusFromTCU()
     * method will return false.
     */
    inline void clearBStatusFromTCU();

    /**
     * Checks whether the field "bStatusFromTCU" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBStatusFromTCU()). Otherwise it will return false.
     */
    inline bool hasBStatusFromTCU () const;

    /**
     * Returns the value of the member "bStatusFromTCU".
     *
     * bStatusFromTCU = true indicates status update from TCU. bStatusFromTCU = false update not from TCU
     *
     * @return The value of the field "bStatusFromTCU"
     */
    inline bool getBStatusFromTCU () const;

    /**
     * Sets the value of the member "bStatusFromTCU".
     *
     * bStatusFromTCU = true indicates status update from TCU. bStatusFromTCU = false update not from TCU
     *
     * @param bStatusFromTCU The value which will be set
     */
    inline void setBStatusFromTCU (bool bStatusFromTCU_);

    static const ProbeInfoDeleteStatusStatus &getDefaultInstance();

private:

    inline void set_has_bStatusFromTCU ();

    inline void clear_has_bStatusFromTCU ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bStatusFromTCU;

};

/**
 * The status message of the property "ServiceCallState"
 * This property gives update about whether the the probe info is deleted or not (MCAN Fct Id:245h)
 */
class ServiceCallStateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ServiceCallStateStatus ();

    /**
     * Copy constructor
     */
    inline  ServiceCallStateStatus (const ServiceCallStateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ServiceCallStateStatus (::tcu_main_fi_types::T_e8_TCU_ServiceState e8ServiceState_);

    /**
     * Destructor
     */
    inline virtual  ~ServiceCallStateStatus();

    /**
     * Assignment operator
     */
    inline ServiceCallStateStatus& operator = (const ServiceCallStateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ServiceCallStateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ServiceCallStateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ServiceCallStateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ServiceCallStateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ServiceState"

    static const int kE8ServiceState = 0;

    /**
     * Clears the field "e8ServiceState".
     *
     * The field will be set to its default value. The hasE8ServiceState()
     * method will return false.
     */
    inline void clearE8ServiceState();

    /**
     * Checks whether the field "e8ServiceState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ServiceState()). Otherwise it will return false.
     */
    inline bool hasE8ServiceState () const;

    /**
     * Returns the value of the member "e8ServiceState".
     *
     * TCU call service state.
     *
     * @return The value of the field "e8ServiceState"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_ServiceState getE8ServiceState () const;

    /**
     * Sets the value of the member "e8ServiceState".
     *
     * TCU call service state.
     *
     * @param e8ServiceState The value which will be set
     */
    inline void setE8ServiceState (::tcu_main_fi_types::T_e8_TCU_ServiceState e8ServiceState_);

    static const ServiceCallStateStatus &getDefaultInstance();

private:

    inline void set_has_e8ServiceState ();

    inline void clear_has_e8ServiceState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tcu_main_fi_types::T_e8_TCU_ServiceState _e8ServiceState;

};

/**
 * The status message of the property "ServiceCallRequest"
 * This property gives information whether a service call is active or not in TCU.
 */
class ServiceCallRequestStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ServiceCallRequestStatus ();

    /**
     * Copy constructor
     */
    inline  ServiceCallRequestStatus (const ServiceCallRequestStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ServiceCallRequestStatus (bool bServiceCallActive_, bool bValid_);

    /**
     * Destructor
     */
    inline virtual  ~ServiceCallRequestStatus();

    /**
     * Assignment operator
     */
    inline ServiceCallRequestStatus& operator = (const ServiceCallRequestStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ServiceCallRequestStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ServiceCallRequestStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ServiceCallRequestStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ServiceCallRequestStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bServiceCallActive"

    static const int kBServiceCallActive = 0;

    /**
     * Clears the field "bServiceCallActive".
     *
     * The field will be set to its default value. The hasBServiceCallActive()
     * method will return false.
     */
    inline void clearBServiceCallActive();

    /**
     * Checks whether the field "bServiceCallActive" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBServiceCallActive()). Otherwise it will return false.
     */
    inline bool hasBServiceCallActive () const;

    /**
     * Returns the value of the member "bServiceCallActive".
     *
     * If TRUE the TCU requests for the E-Call service.
     *
     * @return The value of the field "bServiceCallActive"
     */
    inline bool getBServiceCallActive () const;

    /**
     * Sets the value of the member "bServiceCallActive".
     *
     * If TRUE the TCU requests for the E-Call service.
     *
     * @param bServiceCallActive The value which will be set
     */
    inline void setBServiceCallActive (bool bServiceCallActive_);

    // API of field "bValid"

    static const int kBValid = 1;

    /**
     * Clears the field "bValid".
     *
     * The field will be set to its default value. The hasBValid()
     * method will return false.
     */
    inline void clearBValid();

    /**
     * Checks whether the field "bValid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBValid()). Otherwise it will return false.
     */
    inline bool hasBValid () const;

    /**
     * Returns the value of the member "bValid".
     *
     * Value will be set to FALSE on STATUS update for UPREG otherwise value will set to TRUE
     *
     * @return The value of the field "bValid"
     */
    inline bool getBValid () const;

    /**
     * Sets the value of the member "bValid".
     *
     * Value will be set to FALSE on STATUS update for UPREG otherwise value will set to TRUE
     *
     * @param bValid The value which will be set
     */
    inline void setBValid (bool bValid_);

    static const ServiceCallRequestStatus &getDefaultInstance();

private:

    inline void set_has_bServiceCallActive ();

    inline void clear_has_bServiceCallActive ();

    inline void set_has_bValid ();

    inline void clear_has_bValid ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _bServiceCallActive;

    bool _bValid;

};

/**
 * The start message of the method "SetServiceCallOperation"
 * This method is called by ITM to TCU to indicate user call operation(MCAN Fct Id:223h).
 */
class SetServiceCallOperationStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetServiceCallOperationStart ();

    /**
     * Copy constructor
     */
    inline  SetServiceCallOperationStart (const SetServiceCallOperationStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetServiceCallOperationStart (::tcu_main_fi_types::T_e8_TCU_OperationRequest e8OperationRequest_);

    /**
     * Destructor
     */
    inline virtual  ~SetServiceCallOperationStart();

    /**
     * Assignment operator
     */
    inline SetServiceCallOperationStart& operator = (const SetServiceCallOperationStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetServiceCallOperationStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetServiceCallOperationStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetServiceCallOperationStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetServiceCallOperationStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8OperationRequest"

    static const int kE8OperationRequest = 0;

    /**
     * Clears the field "e8OperationRequest".
     *
     * The field will be set to its default value. The hasE8OperationRequest()
     * method will return false.
     */
    inline void clearE8OperationRequest();

    /**
     * Checks whether the field "e8OperationRequest" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8OperationRequest()). Otherwise it will return false.
     */
    inline bool hasE8OperationRequest () const;

    /**
     * Returns the value of the member "e8OperationRequest".
     *
     * This method requests TCU for Service call operation(Connect/Cancel).
     *
     * @return The value of the field "e8OperationRequest"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_OperationRequest getE8OperationRequest () const;

    /**
     * Sets the value of the member "e8OperationRequest".
     *
     * This method requests TCU for Service call operation(Connect/Cancel).
     *
     * @param e8OperationRequest The value which will be set
     */
    inline void setE8OperationRequest (::tcu_main_fi_types::T_e8_TCU_OperationRequest e8OperationRequest_);

    static const SetServiceCallOperationStart &getDefaultInstance();

private:

    inline void set_has_e8OperationRequest ();

    inline void clear_has_e8OperationRequest ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tcu_main_fi_types::T_e8_TCU_OperationRequest _e8OperationRequest;

};

/**
 * The error message of 'SetServiceCallOperation'
 * Error Message
 */
class SetServiceCallOperationErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SetServiceCallOperationErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SetServiceCallOperationErrorStructure (const SetServiceCallOperationErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SetServiceCallOperationErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~SetServiceCallOperationErrorStructure();

    /**
     * Assignment operator
     */
    inline SetServiceCallOperationErrorStructure& operator = (const SetServiceCallOperationErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetServiceCallOperationErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetServiceCallOperationErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetServiceCallOperationErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetServiceCallOperationErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const SetServiceCallOperationErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'SetServiceCallOperation'
 * Error Message
 */
class SetServiceCallOperationError  : public ::asf::core::Payload {
public:

    enum SetServiceCallOperationErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SetServiceCallOperationError ();

   /**
     * Copy constructor
     */
    inline  SetServiceCallOperationError (const SetServiceCallOperationError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SetServiceCallOperationError();

    /**
     * Assigns a new value to this object.
     */
    inline SetServiceCallOperationError& operator = (const SetServiceCallOperationError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetServiceCallOperationError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetServiceCallOperationError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetServiceCallOperationError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetServiceCallOperationError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SetServiceCallOperationError::SetServiceCallOperationErrorField getField () const;

    inline void setField(SetServiceCallOperationError::SetServiceCallOperationErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SetServiceCallOperationErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SetServiceCallOperationErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SetServiceCallOperationErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SetServiceCallOperationErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SetServiceCallOperationErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SetServiceCallOperationErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SetServiceCallOperationErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SetServiceCallOperationErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SetServiceCallOperationError &getDefaultInstance();

private:

    inline void cloneData (const SetServiceCallOperationError& rhs);

    inline void deleteData ();

    SetServiceCallOperationErrorField __field;

    union {
        SetServiceCallOperationErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "TcuCallServiceState"
 * TCU sends the current call service sate to ITM and ITM adjust self state by reception..
 */
class TcuCallServiceStateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TcuCallServiceStateStatus ();

    /**
     * Copy constructor
     */
    inline  TcuCallServiceStateStatus (const TcuCallServiceStateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  TcuCallServiceStateStatus (::tcu_main_fi_types::T_e8_TCU_ServiceState e8ACNCallServiceState_, ::tcu_main_fi_types::T_e8_TCU_ServiceState e8EmergencyCallServiceState_);

    /**
     * Destructor
     */
    inline virtual  ~TcuCallServiceStateStatus();

    /**
     * Assignment operator
     */
    inline TcuCallServiceStateStatus& operator = (const TcuCallServiceStateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TcuCallServiceStateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TcuCallServiceStateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TcuCallServiceStateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TcuCallServiceStateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ACNCallServiceState"

    static const int kE8ACNCallServiceState = 0;

    /**
     * Clears the field "e8ACNCallServiceState".
     *
     * The field will be set to its default value. The hasE8ACNCallServiceState()
     * method will return false.
     */
    inline void clearE8ACNCallServiceState();

    /**
     * Checks whether the field "e8ACNCallServiceState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ACNCallServiceState()). Otherwise it will return false.
     */
    inline bool hasE8ACNCallServiceState () const;

    /**
     * Returns the value of the member "e8ACNCallServiceState".
     *
     * ACN call service state.
     *
     * @return The value of the field "e8ACNCallServiceState"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_ServiceState getE8ACNCallServiceState () const;

    /**
     * Sets the value of the member "e8ACNCallServiceState".
     *
     * ACN call service state.
     *
     * @param e8ACNCallServiceState The value which will be set
     */
    inline void setE8ACNCallServiceState (::tcu_main_fi_types::T_e8_TCU_ServiceState e8ACNCallServiceState_);

    // API of field "e8EmergencyCallServiceState"

    static const int kE8EmergencyCallServiceState = 1;

    /**
     * Clears the field "e8EmergencyCallServiceState".
     *
     * The field will be set to its default value. The hasE8EmergencyCallServiceState()
     * method will return false.
     */
    inline void clearE8EmergencyCallServiceState();

    /**
     * Checks whether the field "e8EmergencyCallServiceState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8EmergencyCallServiceState()). Otherwise it will return false.
     */
    inline bool hasE8EmergencyCallServiceState () const;

    /**
     * Returns the value of the member "e8EmergencyCallServiceState".
     *
     * Ecall Service State
     *
     * @return The value of the field "e8EmergencyCallServiceState"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_ServiceState getE8EmergencyCallServiceState () const;

    /**
     * Sets the value of the member "e8EmergencyCallServiceState".
     *
     * Ecall Service State
     *
     * @param e8EmergencyCallServiceState The value which will be set
     */
    inline void setE8EmergencyCallServiceState (::tcu_main_fi_types::T_e8_TCU_ServiceState e8EmergencyCallServiceState_);

    static const TcuCallServiceStateStatus &getDefaultInstance();

private:

    inline void set_has_e8ACNCallServiceState ();

    inline void clear_has_e8ACNCallServiceState ();

    inline void set_has_e8EmergencyCallServiceState ();

    inline void clear_has_e8EmergencyCallServiceState ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::tcu_main_fi_types::T_e8_TCU_ServiceState _e8ACNCallServiceState;

    ::tcu_main_fi_types::T_e8_TCU_ServiceState _e8EmergencyCallServiceState;

};

/**
 * The start message of the method "SetNaviInfo"
 * This method is called by TCU HMI when there is change in NaviData(MCAN Fct Id:100h).
 */
class SetNaviInfoStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetNaviInfoStart ();

    /**
     * Copy constructor
     */
    inline  SetNaviInfoStart (const SetNaviInfoStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetNaviInfoStart (const ::tcu_main_fi_types::T_TCU_Navi_Info& rNaviData_);

    /**
     * Destructor
     */
    inline virtual  ~SetNaviInfoStart();

    /**
     * Assignment operator
     */
    inline SetNaviInfoStart& operator = (const SetNaviInfoStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetNaviInfoStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetNaviInfoStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetNaviInfoStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetNaviInfoStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "rNaviData"

    static const int kRNaviData = 0;

    /**
     * Clears the field "rNaviData".
     *
     * The field will be set to its default value. The hasRNaviData()
     * method will return false.
     */
    inline void clearRNaviData();

    /**
     * Checks whether the field "rNaviData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRNaviData()). Otherwise it will return false.
     */
    inline bool hasRNaviData () const;

    /**
     * Returns the value of the member "rNaviData".
     *
     * Navi Data.
     *
     * @return The value of the field "rNaviData"
     */
    inline const ::tcu_main_fi_types::T_TCU_Navi_Info& getRNaviData () const;

    /**
     * Retrieves the value of the field "rNaviData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rNaviData".
     */
    inline ::tcu_main_fi_types::T_TCU_Navi_Info& getRNaviDataMutable ();

    /**
     * Sets the value of the member "rNaviData".
     *
     * Navi Data.
     *
     * @param rNaviData The value which will be set
     */
    inline void setRNaviData (const ::tcu_main_fi_types::T_TCU_Navi_Info& rNaviData_);

    static const SetNaviInfoStart &getDefaultInstance();

private:

    inline void set_has_rNaviData ();

    inline void clear_has_rNaviData ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tcu_main_fi_types::T_TCU_Navi_Info _rNaviData;

};

/**
 * The error message of 'SetNaviInfo'
 * Error Message
 */
class SetNaviInfoErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SetNaviInfoErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SetNaviInfoErrorStructure (const SetNaviInfoErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SetNaviInfoErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~SetNaviInfoErrorStructure();

    /**
     * Assignment operator
     */
    inline SetNaviInfoErrorStructure& operator = (const SetNaviInfoErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetNaviInfoErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetNaviInfoErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetNaviInfoErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetNaviInfoErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const SetNaviInfoErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'SetNaviInfo'
 * Error Message
 */
class SetNaviInfoError  : public ::asf::core::Payload {
public:

    enum SetNaviInfoErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SetNaviInfoError ();

   /**
     * Copy constructor
     */
    inline  SetNaviInfoError (const SetNaviInfoError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SetNaviInfoError();

    /**
     * Assigns a new value to this object.
     */
    inline SetNaviInfoError& operator = (const SetNaviInfoError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetNaviInfoError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetNaviInfoError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetNaviInfoError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetNaviInfoError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SetNaviInfoError::SetNaviInfoErrorField getField () const;

    inline void setField(SetNaviInfoError::SetNaviInfoErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SetNaviInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SetNaviInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SetNaviInfoErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SetNaviInfoErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SetNaviInfoErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SetNaviInfoErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SetNaviInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SetNaviInfoErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SetNaviInfoError &getDefaultInstance();

private:

    inline void cloneData (const SetNaviInfoError& rhs);

    inline void deleteData ();

    SetNaviInfoErrorField __field;

    union {
        SetNaviInfoErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SetTripScoreInfo"
 * This method is called by TCU HMI when there is change in Trip Score Info (MCAN Fct Id:232h).
 */
class SetTripScoreInfoStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetTripScoreInfoStart ();

    /**
     * Copy constructor
     */
    inline  SetTripScoreInfoStart (const SetTripScoreInfoStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetTripScoreInfoStart (const ::tcu_main_fi_types::T_TCU_Score_Info& rTripEcoScoreInfo_);

    /**
     * Destructor
     */
    inline virtual  ~SetTripScoreInfoStart();

    /**
     * Assignment operator
     */
    inline SetTripScoreInfoStart& operator = (const SetTripScoreInfoStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetTripScoreInfoStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetTripScoreInfoStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetTripScoreInfoStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetTripScoreInfoStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "rTripEcoScoreInfo"

    static const int kRTripEcoScoreInfo = 0;

    /**
     * Clears the field "rTripEcoScoreInfo".
     *
     * The field will be set to its default value. The hasRTripEcoScoreInfo()
     * method will return false.
     */
    inline void clearRTripEcoScoreInfo();

    /**
     * Checks whether the field "rTripEcoScoreInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRTripEcoScoreInfo()). Otherwise it will return false.
     */
    inline bool hasRTripEcoScoreInfo () const;

    /**
     * Returns the value of the member "rTripEcoScoreInfo".
     *
     * Trip Score Info.
     *
     * @return The value of the field "rTripEcoScoreInfo"
     */
    inline const ::tcu_main_fi_types::T_TCU_Score_Info& getRTripEcoScoreInfo () const;

    /**
     * Retrieves the value of the field "rTripEcoScoreInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rTripEcoScoreInfo".
     */
    inline ::tcu_main_fi_types::T_TCU_Score_Info& getRTripEcoScoreInfoMutable ();

    /**
     * Sets the value of the member "rTripEcoScoreInfo".
     *
     * Trip Score Info.
     *
     * @param rTripEcoScoreInfo The value which will be set
     */
    inline void setRTripEcoScoreInfo (const ::tcu_main_fi_types::T_TCU_Score_Info& rTripEcoScoreInfo_);

    static const SetTripScoreInfoStart &getDefaultInstance();

private:

    inline void set_has_rTripEcoScoreInfo ();

    inline void clear_has_rTripEcoScoreInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tcu_main_fi_types::T_TCU_Score_Info _rTripEcoScoreInfo;

};

/**
 * The error message of 'SetTripScoreInfo'
 * Error Message
 */
class SetTripScoreInfoErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SetTripScoreInfoErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SetTripScoreInfoErrorStructure (const SetTripScoreInfoErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SetTripScoreInfoErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~SetTripScoreInfoErrorStructure();

    /**
     * Assignment operator
     */
    inline SetTripScoreInfoErrorStructure& operator = (const SetTripScoreInfoErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetTripScoreInfoErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetTripScoreInfoErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetTripScoreInfoErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetTripScoreInfoErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const SetTripScoreInfoErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'SetTripScoreInfo'
 * Error Message
 */
class SetTripScoreInfoError  : public ::asf::core::Payload {
public:

    enum SetTripScoreInfoErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SetTripScoreInfoError ();

   /**
     * Copy constructor
     */
    inline  SetTripScoreInfoError (const SetTripScoreInfoError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SetTripScoreInfoError();

    /**
     * Assigns a new value to this object.
     */
    inline SetTripScoreInfoError& operator = (const SetTripScoreInfoError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetTripScoreInfoError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetTripScoreInfoError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetTripScoreInfoError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetTripScoreInfoError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SetTripScoreInfoError::SetTripScoreInfoErrorField getField () const;

    inline void setField(SetTripScoreInfoError::SetTripScoreInfoErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SetTripScoreInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SetTripScoreInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SetTripScoreInfoErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SetTripScoreInfoErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SetTripScoreInfoErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SetTripScoreInfoErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SetTripScoreInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SetTripScoreInfoErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SetTripScoreInfoError &getDefaultInstance();

private:

    inline void cloneData (const SetTripScoreInfoError& rhs);

    inline void deleteData ();

    SetTripScoreInfoErrorField __field;

    union {
        SetTripScoreInfoErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SetProbeVehicleInfo"
 * This method is called by TCU HMI when there is change in Probe vehicle Info.
 */
class SetProbeVehicleInfoStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetProbeVehicleInfoStart ();

    /**
     * Copy constructor
     */
    inline  SetProbeVehicleInfoStart (const SetProbeVehicleInfoStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetProbeVehicleInfoStart (const ::tcu_main_fi_types::T_TCU_Probe_Vehicle_Info& rProbeVehicleInfo_);

    /**
     * Destructor
     */
    inline virtual  ~SetProbeVehicleInfoStart();

    /**
     * Assignment operator
     */
    inline SetProbeVehicleInfoStart& operator = (const SetProbeVehicleInfoStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetProbeVehicleInfoStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetProbeVehicleInfoStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetProbeVehicleInfoStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetProbeVehicleInfoStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "rProbeVehicleInfo"

    static const int kRProbeVehicleInfo = 0;

    /**
     * Clears the field "rProbeVehicleInfo".
     *
     * The field will be set to its default value. The hasRProbeVehicleInfo()
     * method will return false.
     */
    inline void clearRProbeVehicleInfo();

    /**
     * Checks whether the field "rProbeVehicleInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRProbeVehicleInfo()). Otherwise it will return false.
     */
    inline bool hasRProbeVehicleInfo () const;

    /**
     * Returns the value of the member "rProbeVehicleInfo".
     *
     * Probe Vehicle Info.
     *
     * @return The value of the field "rProbeVehicleInfo"
     */
    inline const ::tcu_main_fi_types::T_TCU_Probe_Vehicle_Info& getRProbeVehicleInfo () const;

    /**
     * Retrieves the value of the field "rProbeVehicleInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rProbeVehicleInfo".
     */
    inline ::tcu_main_fi_types::T_TCU_Probe_Vehicle_Info& getRProbeVehicleInfoMutable ();

    /**
     * Sets the value of the member "rProbeVehicleInfo".
     *
     * Probe Vehicle Info.
     *
     * @param rProbeVehicleInfo The value which will be set
     */
    inline void setRProbeVehicleInfo (const ::tcu_main_fi_types::T_TCU_Probe_Vehicle_Info& rProbeVehicleInfo_);

    static const SetProbeVehicleInfoStart &getDefaultInstance();

private:

    inline void set_has_rProbeVehicleInfo ();

    inline void clear_has_rProbeVehicleInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tcu_main_fi_types::T_TCU_Probe_Vehicle_Info _rProbeVehicleInfo;

};

/**
 * The error message of 'SetProbeVehicleInfo'
 * Error Message
 */
class SetProbeVehicleInfoErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SetProbeVehicleInfoErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SetProbeVehicleInfoErrorStructure (const SetProbeVehicleInfoErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SetProbeVehicleInfoErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~SetProbeVehicleInfoErrorStructure();

    /**
     * Assignment operator
     */
    inline SetProbeVehicleInfoErrorStructure& operator = (const SetProbeVehicleInfoErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetProbeVehicleInfoErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetProbeVehicleInfoErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetProbeVehicleInfoErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetProbeVehicleInfoErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const SetProbeVehicleInfoErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'SetProbeVehicleInfo'
 * Error Message
 */
class SetProbeVehicleInfoError  : public ::asf::core::Payload {
public:

    enum SetProbeVehicleInfoErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SetProbeVehicleInfoError ();

   /**
     * Copy constructor
     */
    inline  SetProbeVehicleInfoError (const SetProbeVehicleInfoError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SetProbeVehicleInfoError();

    /**
     * Assigns a new value to this object.
     */
    inline SetProbeVehicleInfoError& operator = (const SetProbeVehicleInfoError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetProbeVehicleInfoError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetProbeVehicleInfoError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetProbeVehicleInfoError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetProbeVehicleInfoError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SetProbeVehicleInfoError::SetProbeVehicleInfoErrorField getField () const;

    inline void setField(SetProbeVehicleInfoError::SetProbeVehicleInfoErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SetProbeVehicleInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SetProbeVehicleInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SetProbeVehicleInfoErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SetProbeVehicleInfoErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SetProbeVehicleInfoErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SetProbeVehicleInfoErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SetProbeVehicleInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SetProbeVehicleInfoErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SetProbeVehicleInfoError &getDefaultInstance();

private:

    inline void cloneData (const SetProbeVehicleInfoError& rhs);

    inline void deleteData ();

    SetProbeVehicleInfoErrorField __field;

    union {
        SetProbeVehicleInfoErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "MaintenanceInfo"
 * This method is called by TCU HMI when there is change in Maintenance Info.
 */
class MaintenanceInfoStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MaintenanceInfoStart ();

    /**
     * Copy constructor
     */
    inline  MaintenanceInfoStart (const MaintenanceInfoStart &rhs);

    /**
     * All fields constructor
     */
    inline  MaintenanceInfoStart (const ::tcu_main_fi_types::T_TCU_Maintenance_Info& MaintenanceInfo_);

    /**
     * Destructor
     */
    inline virtual  ~MaintenanceInfoStart();

    /**
     * Assignment operator
     */
    inline MaintenanceInfoStart& operator = (const MaintenanceInfoStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MaintenanceInfoStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MaintenanceInfoStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MaintenanceInfoStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MaintenanceInfoStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MaintenanceInfo"

    static const int kMaintenanceInfo = 0;

    /**
     * Clears the field "MaintenanceInfo".
     *
     * The field will be set to its default value. The hasMaintenanceInfo()
     * method will return false.
     */
    inline void clearMaintenanceInfo();

    /**
     * Checks whether the field "MaintenanceInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMaintenanceInfo()). Otherwise it will return false.
     */
    inline bool hasMaintenanceInfo () const;

    /**
     * Returns the value of the member "MaintenanceInfo".
     *
     * Maintenance Info.
     *
     * @return The value of the field "MaintenanceInfo"
     */
    inline const ::tcu_main_fi_types::T_TCU_Maintenance_Info& getMaintenanceInfo () const;

    /**
     * Retrieves the value of the field "MaintenanceInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "MaintenanceInfo".
     */
    inline ::tcu_main_fi_types::T_TCU_Maintenance_Info& getMaintenanceInfoMutable ();

    /**
     * Sets the value of the member "MaintenanceInfo".
     *
     * Maintenance Info.
     *
     * @param MaintenanceInfo The value which will be set
     */
    inline void setMaintenanceInfo (const ::tcu_main_fi_types::T_TCU_Maintenance_Info& MaintenanceInfo_);

    static const MaintenanceInfoStart &getDefaultInstance();

private:

    inline void set_has_MaintenanceInfo ();

    inline void clear_has_MaintenanceInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tcu_main_fi_types::T_TCU_Maintenance_Info _MaintenanceInfo;

};

/**
 * The error message of 'MaintenanceInfo'
 * Error Message
 */
class MaintenanceInfoErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  MaintenanceInfoErrorStructure ();

    /**
     * Copy constructor
     */
    inline  MaintenanceInfoErrorStructure (const MaintenanceInfoErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  MaintenanceInfoErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~MaintenanceInfoErrorStructure();

    /**
     * Assignment operator
     */
    inline MaintenanceInfoErrorStructure& operator = (const MaintenanceInfoErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MaintenanceInfoErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MaintenanceInfoErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MaintenanceInfoErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MaintenanceInfoErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const MaintenanceInfoErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'MaintenanceInfo'
 * Error Message
 */
class MaintenanceInfoError  : public ::asf::core::Payload {
public:

    enum MaintenanceInfoErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  MaintenanceInfoError ();

   /**
     * Copy constructor
     */
    inline  MaintenanceInfoError (const MaintenanceInfoError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~MaintenanceInfoError();

    /**
     * Assigns a new value to this object.
     */
    inline MaintenanceInfoError& operator = (const MaintenanceInfoError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MaintenanceInfoError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MaintenanceInfoError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MaintenanceInfoError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MaintenanceInfoError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline MaintenanceInfoError::MaintenanceInfoErrorField getField () const;

    inline void setField(MaintenanceInfoError::MaintenanceInfoErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "MaintenanceInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "MaintenanceInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const MaintenanceInfoErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline MaintenanceInfoErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline MaintenanceInfoErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (MaintenanceInfoErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "MaintenanceInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const MaintenanceInfoErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const MaintenanceInfoError &getDefaultInstance();

private:

    inline void cloneData (const MaintenanceInfoError& rhs);

    inline void deleteData ();

    MaintenanceInfoErrorField __field;

    union {
        MaintenanceInfoErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "ProvisionService"
 * This property gives TCU Provisioning Service list  from TCU to change self TCU Function setting(MCAN Fct Id:104h)
 */
class ProvisionServiceStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ProvisionServiceStatus ();

    /**
     * Copy constructor
     */
    inline  ProvisionServiceStatus (const ProvisionServiceStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ProvisionServiceStatus (const ::tcu_main_fi_types::T_TCU_Provision_List& ProvisionService_);

    /**
     * Destructor
     */
    inline virtual  ~ProvisionServiceStatus();

    /**
     * Assignment operator
     */
    inline ProvisionServiceStatus& operator = (const ProvisionServiceStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ProvisionServiceStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ProvisionServiceStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ProvisionServiceStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ProvisionServiceStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ProvisionService"

    static const int kProvisionService = 0;

    /**
     * Clears the field "ProvisionService".
     *
     * The field will be set to its default value. The hasProvisionService()
     * method will return false.
     */
    inline void clearProvisionService();

    /**
     * Checks whether the field "ProvisionService" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProvisionService()). Otherwise it will return false.
     */
    inline bool hasProvisionService () const;

    /**
     * Returns the value of the member "ProvisionService".
     *
     * Provision Service Available state of TCU
     *
     * @return The value of the field "ProvisionService"
     */
    inline const ::tcu_main_fi_types::T_TCU_Provision_List& getProvisionService () const;

    /**
     * Retrieves the value of the field "ProvisionService" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ProvisionService".
     */
    inline ::tcu_main_fi_types::T_TCU_Provision_List& getProvisionServiceMutable ();

    /**
     * Sets the value of the member "ProvisionService".
     *
     * Provision Service Available state of TCU
     *
     * @param ProvisionService The value which will be set
     */
    inline void setProvisionService (const ::tcu_main_fi_types::T_TCU_Provision_List& ProvisionService_);

    static const ProvisionServiceStatus &getDefaultInstance();

private:

    inline void set_has_ProvisionService ();

    inline void clear_has_ProvisionService ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tcu_main_fi_types::T_TCU_Provision_List _ProvisionService;

};

/**
 * The status message of the property "COMEcallState"
 * This property gives update about COM Ecall State (MCAN Fct Id:110h)
 */
class COMEcallStateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  COMEcallStateStatus ();

    /**
     * Copy constructor
     */
    inline  COMEcallStateStatus (const COMEcallStateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  COMEcallStateStatus (::tcu_main_fi_types::T_e8_TCU_EcallStateDisplay e8EcallStateDisplay_);

    /**
     * Destructor
     */
    inline virtual  ~COMEcallStateStatus();

    /**
     * Assignment operator
     */
    inline COMEcallStateStatus& operator = (const COMEcallStateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const COMEcallStateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const COMEcallStateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const COMEcallStateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const COMEcallStateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8EcallStateDisplay"

    static const int kE8EcallStateDisplay = 0;

    /**
     * Clears the field "e8EcallStateDisplay".
     *
     * The field will be set to its default value. The hasE8EcallStateDisplay()
     * method will return false.
     */
    inline void clearE8EcallStateDisplay();

    /**
     * Checks whether the field "e8EcallStateDisplay" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8EcallStateDisplay()). Otherwise it will return false.
     */
    inline bool hasE8EcallStateDisplay () const;

    /**
     * Returns the value of the member "e8EcallStateDisplay".
     *
     * COM Ecall State
     *
     * @return The value of the field "e8EcallStateDisplay"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_EcallStateDisplay getE8EcallStateDisplay () const;

    /**
     * Sets the value of the member "e8EcallStateDisplay".
     *
     * COM Ecall State
     *
     * @param e8EcallStateDisplay The value which will be set
     */
    inline void setE8EcallStateDisplay (::tcu_main_fi_types::T_e8_TCU_EcallStateDisplay e8EcallStateDisplay_);

    static const COMEcallStateStatus &getDefaultInstance();

private:

    inline void set_has_e8EcallStateDisplay ();

    inline void clear_has_e8EcallStateDisplay ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tcu_main_fi_types::T_e8_TCU_EcallStateDisplay _e8EcallStateDisplay;

};

/**
 * The error message of 'COMEcallStartStatus'
 * Error Message
 */
class COMEcallStartStatusErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  COMEcallStartStatusErrorStructure ();

    /**
     * Copy constructor
     */
    inline  COMEcallStartStatusErrorStructure (const COMEcallStartStatusErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  COMEcallStartStatusErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~COMEcallStartStatusErrorStructure();

    /**
     * Assignment operator
     */
    inline COMEcallStartStatusErrorStructure& operator = (const COMEcallStartStatusErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const COMEcallStartStatusErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const COMEcallStartStatusErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const COMEcallStartStatusErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const COMEcallStartStatusErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const COMEcallStartStatusErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'COMEcallStartStatus'
 * Error Message
 */
class COMEcallStartStatusError  : public ::asf::core::Payload {
public:

    enum COMEcallStartStatusErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  COMEcallStartStatusError ();

   /**
     * Copy constructor
     */
    inline  COMEcallStartStatusError (const COMEcallStartStatusError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~COMEcallStartStatusError();

    /**
     * Assigns a new value to this object.
     */
    inline COMEcallStartStatusError& operator = (const COMEcallStartStatusError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const COMEcallStartStatusError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const COMEcallStartStatusError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const COMEcallStartStatusError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const COMEcallStartStatusError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline COMEcallStartStatusError::COMEcallStartStatusErrorField getField () const;

    inline void setField(COMEcallStartStatusError::COMEcallStartStatusErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "COMEcallStartStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "COMEcallStartStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const COMEcallStartStatusErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline COMEcallStartStatusErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline COMEcallStartStatusErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (COMEcallStartStatusErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "COMEcallStartStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const COMEcallStartStatusErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const COMEcallStartStatusError &getDefaultInstance();

private:

    inline void cloneData (const COMEcallStartStatusError& rhs);

    inline void deleteData ();

    COMEcallStartStatusErrorField __field;

    union {
        COMEcallStartStatusErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The error message of 'SetTCUReset'
 * Error Message
 */
class SetTCUResetErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SetTCUResetErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SetTCUResetErrorStructure (const SetTCUResetErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SetTCUResetErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~SetTCUResetErrorStructure();

    /**
     * Assignment operator
     */
    inline SetTCUResetErrorStructure& operator = (const SetTCUResetErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetTCUResetErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetTCUResetErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetTCUResetErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetTCUResetErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const SetTCUResetErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'SetTCUReset'
 * Error Message
 */
class SetTCUResetError  : public ::asf::core::Payload {
public:

    enum SetTCUResetErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SetTCUResetError ();

   /**
     * Copy constructor
     */
    inline  SetTCUResetError (const SetTCUResetError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SetTCUResetError();

    /**
     * Assigns a new value to this object.
     */
    inline SetTCUResetError& operator = (const SetTCUResetError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetTCUResetError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetTCUResetError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetTCUResetError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetTCUResetError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SetTCUResetError::SetTCUResetErrorField getField () const;

    inline void setField(SetTCUResetError::SetTCUResetErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SetTCUResetErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SetTCUResetErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SetTCUResetErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SetTCUResetErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SetTCUResetErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SetTCUResetErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SetTCUResetErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SetTCUResetErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SetTCUResetError &getDefaultInstance();

private:

    inline void cloneData (const SetTCUResetError& rhs);

    inline void deleteData ();

    SetTCUResetErrorField __field;

    union {
        SetTCUResetErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "TCUResetStatus"
 * This property gives update about TCU reset status (MCAN Fct Id:252h)
 */
class TCUResetStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TCUResetStatusStatus ();

    /**
     * Copy constructor
     */
    inline  TCUResetStatusStatus (const TCUResetStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  TCUResetStatusStatus (bool bStatusFromTCU_);

    /**
     * Destructor
     */
    inline virtual  ~TCUResetStatusStatus();

    /**
     * Assignment operator
     */
    inline TCUResetStatusStatus& operator = (const TCUResetStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TCUResetStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TCUResetStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TCUResetStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TCUResetStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bStatusFromTCU"

    static const int kBStatusFromTCU = 0;

    /**
     * Clears the field "bStatusFromTCU".
     *
     * The field will be set to its default value. The hasBStatusFromTCU()
     * method will return false.
     */
    inline void clearBStatusFromTCU();

    /**
     * Checks whether the field "bStatusFromTCU" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBStatusFromTCU()). Otherwise it will return false.
     */
    inline bool hasBStatusFromTCU () const;

    /**
     * Returns the value of the member "bStatusFromTCU".
     *
     * bStatusFromTCU = true indicates status update from TCU. bStatusFromTCU = false update not from TCU
     *
     * @return The value of the field "bStatusFromTCU"
     */
    inline bool getBStatusFromTCU () const;

    /**
     * Sets the value of the member "bStatusFromTCU".
     *
     * bStatusFromTCU = true indicates status update from TCU. bStatusFromTCU = false update not from TCU
     *
     * @param bStatusFromTCU The value which will be set
     */
    inline void setBStatusFromTCU (bool bStatusFromTCU_);

    static const TCUResetStatusStatus &getDefaultInstance();

private:

    inline void set_has_bStatusFromTCU ();

    inline void clear_has_bStatusFromTCU ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bStatusFromTCU;

};

/**
 * The status message of the property "EmergencyState"
 * This property gives indication to the SPM to change the power state to TEMPO_ON if the current state is  TEMPO_OFF/STATIC_OFF
 */
class EmergencyStateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EmergencyStateStatus ();

    /**
     * Copy constructor
     */
    inline  EmergencyStateStatus (const EmergencyStateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  EmergencyStateStatus (bool bEmergencyStateFromTCU_);

    /**
     * Destructor
     */
    inline virtual  ~EmergencyStateStatus();

    /**
     * Assignment operator
     */
    inline EmergencyStateStatus& operator = (const EmergencyStateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EmergencyStateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EmergencyStateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EmergencyStateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EmergencyStateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bEmergencyStateFromTCU"

    static const int kBEmergencyStateFromTCU = 0;

    /**
     * Clears the field "bEmergencyStateFromTCU".
     *
     * The field will be set to its default value. The hasBEmergencyStateFromTCU()
     * method will return false.
     */
    inline void clearBEmergencyStateFromTCU();

    /**
     * Checks whether the field "bEmergencyStateFromTCU" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBEmergencyStateFromTCU()). Otherwise it will return false.
     */
    inline bool hasBEmergencyStateFromTCU () const;

    /**
     * Returns the value of the member "bEmergencyStateFromTCU".
     *
     * bStateFromTCU = true indicates Emergency state is ACTIVE. bStateFromTCU = false indicates Emergency state is INACTIVE
     *
     * @return The value of the field "bEmergencyStateFromTCU"
     */
    inline bool getBEmergencyStateFromTCU () const;

    /**
     * Sets the value of the member "bEmergencyStateFromTCU".
     *
     * bStateFromTCU = true indicates Emergency state is ACTIVE. bStateFromTCU = false indicates Emergency state is INACTIVE
     *
     * @param bEmergencyStateFromTCU The value which will be set
     */
    inline void setBEmergencyStateFromTCU (bool bEmergencyStateFromTCU_);

    static const EmergencyStateStatus &getDefaultInstance();

private:

    inline void set_has_bEmergencyStateFromTCU ();

    inline void clear_has_bEmergencyStateFromTCU ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bEmergencyStateFromTCU;

};

/**
 * The status message of the property "TCUResponseTimeOut"
 * This property gives info about the response time out the request to the TCU
 */
class TCUResponseTimeOutStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TCUResponseTimeOutStatus ();

    /**
     * Copy constructor
     */
    inline  TCUResponseTimeOutStatus (const TCUResponseTimeOutStatus &rhs);

    /**
     * All fields constructor
     */
    inline  TCUResponseTimeOutStatus (uint8 u8TcuResponseTimeOut_, const ::tcu_main_fi_types::T_TCU_Response_Time_Out& TcuResponseTimeOut_, bool bTcuServiceCallOperationSetTimeOut_);

    /**
     * Destructor
     */
    inline virtual  ~TCUResponseTimeOutStatus();

    /**
     * Assignment operator
     */
    inline TCUResponseTimeOutStatus& operator = (const TCUResponseTimeOutStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TCUResponseTimeOutStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TCUResponseTimeOutStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TCUResponseTimeOutStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TCUResponseTimeOutStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8TcuResponseTimeOut"

    static const int kU8TcuResponseTimeOut = 0;

    /**
     * Clears the field "u8TcuResponseTimeOut".
     *
     * The field will be set to its default value. The hasU8TcuResponseTimeOut()
     * method will return false.
     */
    inline void clearU8TcuResponseTimeOut();

    /**
     * Checks whether the field "u8TcuResponseTimeOut" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8TcuResponseTimeOut()). Otherwise it will return false.
     */
    inline bool hasU8TcuResponseTimeOut () const;

    /**
     * Returns the value of the member "u8TcuResponseTimeOut".
     *
     * List of properties where TCU response timer is handled
     * Bit    : corresponding IDS
     * 0     :TCU_MAINFI_C_U16_DRIVERINFOUPLOADPERMITSTATUS
     * 1     :TCU_MAINFI_C_U16_IDINFOSTATUS
     * 2     :TCU_MAINFI_C_U16_PROBEUPLOADPERMITGETSTATUS
     * 3     :TCU_MAINFI_C_U16_PROBEUPLOADPERMITSETSTATUS
     * 4     :TCU_MAINFI_C_U16_SERVICECALLOPERATIONSTATUS
     * 5     :TCU_MAINFI_C_U16_TCUSTATE
     * 6     :TCU_MAINFI_C_U16_TCURESETSTATUS
     * 7     :TCU_MAINFI_C_U16_PROBEINFODELETESTATUS
     *
     * @return The value of the field "u8TcuResponseTimeOut"
     */
    inline uint8 getU8TcuResponseTimeOut () const;

    /**
     * Sets the value of the member "u8TcuResponseTimeOut".
     *
     * List of properties where TCU response timer is handled
     * Bit    : corresponding IDS
     * 0     :TCU_MAINFI_C_U16_DRIVERINFOUPLOADPERMITSTATUS
     * 1     :TCU_MAINFI_C_U16_IDINFOSTATUS
     * 2     :TCU_MAINFI_C_U16_PROBEUPLOADPERMITGETSTATUS
     * 3     :TCU_MAINFI_C_U16_PROBEUPLOADPERMITSETSTATUS
     * 4     :TCU_MAINFI_C_U16_SERVICECALLOPERATIONSTATUS
     * 5     :TCU_MAINFI_C_U16_TCUSTATE
     * 6     :TCU_MAINFI_C_U16_TCURESETSTATUS
     * 7     :TCU_MAINFI_C_U16_PROBEINFODELETESTATUS
     *
     * @param u8TcuResponseTimeOut The value which will be set
     */
    inline void setU8TcuResponseTimeOut (uint8 u8TcuResponseTimeOut_);

    // API of field "TcuResponseTimeOut"

    static const int kTcuResponseTimeOut = 1;

    /**
     * Clears the field "TcuResponseTimeOut".
     *
     * The field will be set to its default value. The hasTcuResponseTimeOut()
     * method will return false.
     */
    inline void clearTcuResponseTimeOut();

    /**
     * Checks whether the field "TcuResponseTimeOut" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTcuResponseTimeOut()). Otherwise it will return false.
     */
    inline bool hasTcuResponseTimeOut () const;

    /**
     * Returns the value of the member "TcuResponseTimeOut".
     *
     * If the meaning of "TcuResponseTimeOut" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TcuResponseTimeOut"
     */
    inline const ::tcu_main_fi_types::T_TCU_Response_Time_Out& getTcuResponseTimeOut () const;

    /**
     * Retrieves the value of the field "TcuResponseTimeOut" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TcuResponseTimeOut".
     */
    inline ::tcu_main_fi_types::T_TCU_Response_Time_Out& getTcuResponseTimeOutMutable ();

    /**
     * Sets the value of the member "TcuResponseTimeOut".
     *
     * If the meaning of "TcuResponseTimeOut" isn't clear, then there should be a description here.
     *
     * @param TcuResponseTimeOut The value which will be set
     */
    inline void setTcuResponseTimeOut (const ::tcu_main_fi_types::T_TCU_Response_Time_Out& TcuResponseTimeOut_);

    // API of field "bTcuServiceCallOperationSetTimeOut"

    static const int kBTcuServiceCallOperationSetTimeOut = 2;

    /**
     * Clears the field "bTcuServiceCallOperationSetTimeOut".
     *
     * The field will be set to its default value. The hasBTcuServiceCallOperationSetTimeOut()
     * method will return false.
     */
    inline void clearBTcuServiceCallOperationSetTimeOut();

    /**
     * Checks whether the field "bTcuServiceCallOperationSetTimeOut" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBTcuServiceCallOperationSetTimeOut()). Otherwise it will return false.
     */
    inline bool hasBTcuServiceCallOperationSetTimeOut () const;

    /**
     * Returns the value of the member "bTcuServiceCallOperationSetTimeOut".
     *
     * False: Service Call Timer is Not expired
     * True:  Service Call Timer is Expired
     *
     * @return The value of the field "bTcuServiceCallOperationSetTimeOut"
     */
    inline bool getBTcuServiceCallOperationSetTimeOut () const;

    /**
     * Sets the value of the member "bTcuServiceCallOperationSetTimeOut".
     *
     * False: Service Call Timer is Not expired
     * True:  Service Call Timer is Expired
     *
     * @param bTcuServiceCallOperationSetTimeOut The value which will be set
     */
    inline void setBTcuServiceCallOperationSetTimeOut (bool bTcuServiceCallOperationSetTimeOut_);

    static const TCUResponseTimeOutStatus &getDefaultInstance();

private:

    static const ::std::vector< ::tcu_main_fi_types::T_e8_TCU_Response_Time_Out >& getT_e8_TCU_Response_Time_OutList_DefaultInstance ();

    inline void set_has_u8TcuResponseTimeOut ();

    inline void clear_has_u8TcuResponseTimeOut ();

    inline void set_has_TcuResponseTimeOut ();

    inline void clear_has_TcuResponseTimeOut ();

    inline void set_has_bTcuServiceCallOperationSetTimeOut ();

    inline void clear_has_bTcuServiceCallOperationSetTimeOut ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _u8TcuResponseTimeOut;

    ::tcu_main_fi_types::T_TCU_Response_Time_Out _TcuResponseTimeOut;

    bool _bTcuServiceCallOperationSetTimeOut;

};

/**
 * The error message of 'GetTCUExtendedState'
 * Error Message
 */
class GetTCUExtendedStateErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetTCUExtendedStateErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetTCUExtendedStateErrorStructure (const GetTCUExtendedStateErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetTCUExtendedStateErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~GetTCUExtendedStateErrorStructure();

    /**
     * Assignment operator
     */
    inline GetTCUExtendedStateErrorStructure& operator = (const GetTCUExtendedStateErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetTCUExtendedStateErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetTCUExtendedStateErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetTCUExtendedStateErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetTCUExtendedStateErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const GetTCUExtendedStateErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'GetTCUExtendedState'
 * Error Message
 */
class GetTCUExtendedStateError  : public ::asf::core::Payload {
public:

    enum GetTCUExtendedStateErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetTCUExtendedStateError ();

   /**
     * Copy constructor
     */
    inline  GetTCUExtendedStateError (const GetTCUExtendedStateError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetTCUExtendedStateError();

    /**
     * Assigns a new value to this object.
     */
    inline GetTCUExtendedStateError& operator = (const GetTCUExtendedStateError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetTCUExtendedStateError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetTCUExtendedStateError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetTCUExtendedStateError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetTCUExtendedStateError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetTCUExtendedStateError::GetTCUExtendedStateErrorField getField () const;

    inline void setField(GetTCUExtendedStateError::GetTCUExtendedStateErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetTCUExtendedStateErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetTCUExtendedStateErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetTCUExtendedStateErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetTCUExtendedStateErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetTCUExtendedStateErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetTCUExtendedStateErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetTCUExtendedStateErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetTCUExtendedStateErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetTCUExtendedStateError &getDefaultInstance();

private:

    inline void cloneData (const GetTCUExtendedStateError& rhs);

    inline void deleteData ();

    GetTCUExtendedStateErrorField __field;

    union {
        GetTCUExtendedStateErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "TCUExtendedState"
 * This property gives update about the TCU Extended status on request from ITM or when there is any indication by TCU(MCAN Fct **)
 */
class TCUExtendedStateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TCUExtendedStateStatus ();

    /**
     * Copy constructor
     */
    inline  TCUExtendedStateStatus (const TCUExtendedStateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  TCUExtendedStateStatus (::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter e8Invalid_Parameter_, const ::std::string& sIMEINumber_, const ::std::string& sICC_ID_, uint16 u16MCC_, uint8 u8MNC_, const ::std::string& sMobile_Network_Name_, ::tcu_main_fi_types::T_e8_TCU_RoamingStatus e8RoamingStatus_, ::tcu_main_fi_types::T_e8_TCU_PPPConnectionStatus e8PPP_Connection_Status_, ::tcu_main_fi_types::T_e8_TCU_Opcode e8Opcode_);

    /**
     * Destructor
     */
    inline virtual  ~TCUExtendedStateStatus();

    /**
     * Assignment operator
     */
    inline TCUExtendedStateStatus& operator = (const TCUExtendedStateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TCUExtendedStateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TCUExtendedStateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TCUExtendedStateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TCUExtendedStateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Invalid_Parameter"

    static const int kE8Invalid_Parameter = 0;

    /**
     * Clears the field "e8Invalid_Parameter".
     *
     * The field will be set to its default value. The hasE8Invalid_Parameter()
     * method will return false.
     */
    inline void clearE8Invalid_Parameter();

    /**
     * Checks whether the field "e8Invalid_Parameter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Invalid_Parameter()). Otherwise it will return false.
     */
    inline bool hasE8Invalid_Parameter () const;

    /**
     * Returns the value of the member "e8Invalid_Parameter".
     *
     *
     *
     * @return The value of the field "e8Invalid_Parameter"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter getE8Invalid_Parameter () const;

    /**
     * Sets the value of the member "e8Invalid_Parameter".
     *
     *
     *
     * @param e8Invalid_Parameter The value which will be set
     */
    inline void setE8Invalid_Parameter (::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter e8Invalid_Parameter_);

    // API of field "sIMEINumber"

    static const int kSIMEINumber = 1;

    /**
     * Clears the field "sIMEINumber".
     *
     * The field will be set to its default value. The hasSIMEINumber()
     * method will return false.
     */
    inline void clearSIMEINumber();

    /**
     * Checks whether the field "sIMEINumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSIMEINumber()). Otherwise it will return false.
     */
    inline bool hasSIMEINumber () const;

    /**
     * Returns the value of the member "sIMEINumber".
     *
     * IMEI Number of TCU
     *
     * @return The value of the field "sIMEINumber"
     */
    inline const ::std::string& getSIMEINumber () const;

    /**
     * Retrieves the value of the field "sIMEINumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sIMEINumber".
     */
    inline ::std::string& getSIMEINumberMutable ();

    /**
     * Sets the value of the member "sIMEINumber".
     *
     * IMEI Number of TCU
     *
     * @param sIMEINumber The value which will be set
     */
    inline void setSIMEINumber (const ::std::string& sIMEINumber_);

    /**
     * Sets the value of the member "sIMEINumber".
     *
     * IMEI Number of TCU
     *
     * @param sIMEINumber The value which will be set
     */
    inline void setSIMEINumber (const char* sIMEINumber_);

    /**
     * Sets the value of the member "sIMEINumber".
     *
     * IMEI Number of TCU
     *
     * @param sIMEINumber The value which will be set
     */
    inline void setSIMEINumber (const char* value, size_t size);

    // API of field "sICC_ID"

    static const int kSICC_ID = 2;

    /**
     * Clears the field "sICC_ID".
     *
     * The field will be set to its default value. The hasSICC_ID()
     * method will return false.
     */
    inline void clearSICC_ID();

    /**
     * Checks whether the field "sICC_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSICC_ID()). Otherwise it will return false.
     */
    inline bool hasSICC_ID () const;

    /**
     * Returns the value of the member "sICC_ID".
     *
     * ICC_ID of TCU
     *
     * @return The value of the field "sICC_ID"
     */
    inline const ::std::string& getSICC_ID () const;

    /**
     * Retrieves the value of the field "sICC_ID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sICC_ID".
     */
    inline ::std::string& getSICC_IDMutable ();

    /**
     * Sets the value of the member "sICC_ID".
     *
     * ICC_ID of TCU
     *
     * @param sICC_ID The value which will be set
     */
    inline void setSICC_ID (const ::std::string& sICC_ID_);

    /**
     * Sets the value of the member "sICC_ID".
     *
     * ICC_ID of TCU
     *
     * @param sICC_ID The value which will be set
     */
    inline void setSICC_ID (const char* sICC_ID_);

    /**
     * Sets the value of the member "sICC_ID".
     *
     * ICC_ID of TCU
     *
     * @param sICC_ID The value which will be set
     */
    inline void setSICC_ID (const char* value, size_t size);

    // API of field "u16MCC"

    static const int kU16MCC = 3;

    /**
     * Clears the field "u16MCC".
     *
     * The field will be set to its default value. The hasU16MCC()
     * method will return false.
     */
    inline void clearU16MCC();

    /**
     * Checks whether the field "u16MCC" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16MCC()). Otherwise it will return false.
     */
    inline bool hasU16MCC () const;

    /**
     * Returns the value of the member "u16MCC".
     *
     * Mobile Country code of TCU
     *
     * @return The value of the field "u16MCC"
     */
    inline uint16 getU16MCC () const;

    /**
     * Sets the value of the member "u16MCC".
     *
     * Mobile Country code of TCU
     *
     * @param u16MCC The value which will be set
     */
    inline void setU16MCC (uint16 u16MCC_);

    // API of field "u8MNC"

    static const int kU8MNC = 4;

    /**
     * Clears the field "u8MNC".
     *
     * The field will be set to its default value. The hasU8MNC()
     * method will return false.
     */
    inline void clearU8MNC();

    /**
     * Checks whether the field "u8MNC" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8MNC()). Otherwise it will return false.
     */
    inline bool hasU8MNC () const;

    /**
     * Returns the value of the member "u8MNC".
     *
     * Mobile Network Code of TCU
     *
     * @return The value of the field "u8MNC"
     */
    inline uint8 getU8MNC () const;

    /**
     * Sets the value of the member "u8MNC".
     *
     * Mobile Network Code of TCU
     *
     * @param u8MNC The value which will be set
     */
    inline void setU8MNC (uint8 u8MNC_);

    // API of field "sMobile_Network_Name"

    static const int kSMobile_Network_Name = 5;

    /**
     * Clears the field "sMobile_Network_Name".
     *
     * The field will be set to its default value. The hasSMobile_Network_Name()
     * method will return false.
     */
    inline void clearSMobile_Network_Name();

    /**
     * Checks whether the field "sMobile_Network_Name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSMobile_Network_Name()). Otherwise it will return false.
     */
    inline bool hasSMobile_Network_Name () const;

    /**
     * Returns the value of the member "sMobile_Network_Name".
     *
     * Mobile Network Name
     *
     * @return The value of the field "sMobile_Network_Name"
     */
    inline const ::std::string& getSMobile_Network_Name () const;

    /**
     * Retrieves the value of the field "sMobile_Network_Name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sMobile_Network_Name".
     */
    inline ::std::string& getSMobile_Network_NameMutable ();

    /**
     * Sets the value of the member "sMobile_Network_Name".
     *
     * Mobile Network Name
     *
     * @param sMobile_Network_Name The value which will be set
     */
    inline void setSMobile_Network_Name (const ::std::string& sMobile_Network_Name_);

    /**
     * Sets the value of the member "sMobile_Network_Name".
     *
     * Mobile Network Name
     *
     * @param sMobile_Network_Name The value which will be set
     */
    inline void setSMobile_Network_Name (const char* sMobile_Network_Name_);

    /**
     * Sets the value of the member "sMobile_Network_Name".
     *
     * Mobile Network Name
     *
     * @param sMobile_Network_Name The value which will be set
     */
    inline void setSMobile_Network_Name (const char* value, size_t size);

    // API of field "e8RoamingStatus"

    static const int kE8RoamingStatus = 6;

    /**
     * Clears the field "e8RoamingStatus".
     *
     * The field will be set to its default value. The hasE8RoamingStatus()
     * method will return false.
     */
    inline void clearE8RoamingStatus();

    /**
     * Checks whether the field "e8RoamingStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8RoamingStatus()). Otherwise it will return false.
     */
    inline bool hasE8RoamingStatus () const;

    /**
     * Returns the value of the member "e8RoamingStatus".
     *
     * Roaming Status of TCU
     *
     * @return The value of the field "e8RoamingStatus"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_RoamingStatus getE8RoamingStatus () const;

    /**
     * Sets the value of the member "e8RoamingStatus".
     *
     * Roaming Status of TCU
     *
     * @param e8RoamingStatus The value which will be set
     */
    inline void setE8RoamingStatus (::tcu_main_fi_types::T_e8_TCU_RoamingStatus e8RoamingStatus_);

    // API of field "e8PPP_Connection_Status"

    static const int kE8PPP_Connection_Status = 7;

    /**
     * Clears the field "e8PPP_Connection_Status".
     *
     * The field will be set to its default value. The hasE8PPP_Connection_Status()
     * method will return false.
     */
    inline void clearE8PPP_Connection_Status();

    /**
     * Checks whether the field "e8PPP_Connection_Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8PPP_Connection_Status()). Otherwise it will return false.
     */
    inline bool hasE8PPP_Connection_Status () const;

    /**
     * Returns the value of the member "e8PPP_Connection_Status".
     *
     * PPP Connection Status of TCU
     *
     * @return The value of the field "e8PPP_Connection_Status"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_PPPConnectionStatus getE8PPP_Connection_Status () const;

    /**
     * Sets the value of the member "e8PPP_Connection_Status".
     *
     * PPP Connection Status of TCU
     *
     * @param e8PPP_Connection_Status The value which will be set
     */
    inline void setE8PPP_Connection_Status (::tcu_main_fi_types::T_e8_TCU_PPPConnectionStatus e8PPP_Connection_Status_);

    // API of field "e8Opcode"

    static const int kE8Opcode = 8;

    /**
     * Clears the field "e8Opcode".
     *
     * The field will be set to its default value. The hasE8Opcode()
     * method will return false.
     */
    inline void clearE8Opcode();

    /**
     * Checks whether the field "e8Opcode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Opcode()). Otherwise it will return false.
     */
    inline bool hasE8Opcode () const;

    /**
     * Returns the value of the member "e8Opcode".
     *
     * Opcode Information
     *
     * @return The value of the field "e8Opcode"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_Opcode getE8Opcode () const;

    /**
     * Sets the value of the member "e8Opcode".
     *
     * Opcode Information
     *
     * @param e8Opcode The value which will be set
     */
    inline void setE8Opcode (::tcu_main_fi_types::T_e8_TCU_Opcode e8Opcode_);

    static const TCUExtendedStateStatus &getDefaultInstance();

private:

    inline void set_has_e8Invalid_Parameter ();

    inline void clear_has_e8Invalid_Parameter ();

    inline void set_has_sIMEINumber ();

    inline void clear_has_sIMEINumber ();

    inline void set_has_sICC_ID ();

    inline void clear_has_sICC_ID ();

    inline void set_has_u16MCC ();

    inline void clear_has_u16MCC ();

    inline void set_has_u8MNC ();

    inline void clear_has_u8MNC ();

    inline void set_has_sMobile_Network_Name ();

    inline void clear_has_sMobile_Network_Name ();

    inline void set_has_e8RoamingStatus ();

    inline void clear_has_e8RoamingStatus ();

    inline void set_has_e8PPP_Connection_Status ();

    inline void clear_has_e8PPP_Connection_Status ();

    inline void set_has_e8Opcode ();

    inline void clear_has_e8Opcode ();

    uint32 _has_bits_[ (9 + 31) / 32];

    ::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter _e8Invalid_Parameter;

    ::std::string _sIMEINumber;

    ::std::string _sICC_ID;

    uint16 _u16MCC;

    uint8 _u8MNC;

    ::std::string _sMobile_Network_Name;

    ::tcu_main_fi_types::T_e8_TCU_RoamingStatus _e8RoamingStatus;

    ::tcu_main_fi_types::T_e8_TCU_PPPConnectionStatus _e8PPP_Connection_Status;

    ::tcu_main_fi_types::T_e8_TCU_Opcode _e8Opcode;

};

/**
 * The start message of the method "SetPINSetting"
 * User set PIN ID and Password and send to TCU  to certify with Center(Fctn ID : 250h)
 */
class SetPINSettingStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetPINSettingStart ();

    /**
     * Copy constructor
     */
    inline  SetPINSettingStart (const SetPINSettingStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetPINSettingStart (const ::tcu_main_fi_types::T_TCU_PIN& rPIN_);

    /**
     * Destructor
     */
    inline virtual  ~SetPINSettingStart();

    /**
     * Assignment operator
     */
    inline SetPINSettingStart& operator = (const SetPINSettingStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetPINSettingStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetPINSettingStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetPINSettingStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetPINSettingStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "rPIN"

    static const int kRPIN = 0;

    /**
     * Clears the field "rPIN".
     *
     * The field will be set to its default value. The hasRPIN()
     * method will return false.
     */
    inline void clearRPIN();

    /**
     * Checks whether the field "rPIN" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRPIN()). Otherwise it will return false.
     */
    inline bool hasRPIN () const;

    /**
     * Returns the value of the member "rPIN".
     *
     * If the meaning of "rPIN" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rPIN"
     */
    inline const ::tcu_main_fi_types::T_TCU_PIN& getRPIN () const;

    /**
     * Retrieves the value of the field "rPIN" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rPIN".
     */
    inline ::tcu_main_fi_types::T_TCU_PIN& getRPINMutable ();

    /**
     * Sets the value of the member "rPIN".
     *
     * If the meaning of "rPIN" isn't clear, then there should be a description here.
     *
     * @param rPIN The value which will be set
     */
    inline void setRPIN (const ::tcu_main_fi_types::T_TCU_PIN& rPIN_);

    static const SetPINSettingStart &getDefaultInstance();

private:

    inline void set_has_rPIN ();

    inline void clear_has_rPIN ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tcu_main_fi_types::T_TCU_PIN _rPIN;

};

/**
 * The error message of 'SetPINSetting'
 * Error Message
 */
class SetPINSettingErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SetPINSettingErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SetPINSettingErrorStructure (const SetPINSettingErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SetPINSettingErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~SetPINSettingErrorStructure();

    /**
     * Assignment operator
     */
    inline SetPINSettingErrorStructure& operator = (const SetPINSettingErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetPINSettingErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetPINSettingErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetPINSettingErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetPINSettingErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const SetPINSettingErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'SetPINSetting'
 * Error Message
 */
class SetPINSettingError  : public ::asf::core::Payload {
public:

    enum SetPINSettingErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SetPINSettingError ();

   /**
     * Copy constructor
     */
    inline  SetPINSettingError (const SetPINSettingError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SetPINSettingError();

    /**
     * Assigns a new value to this object.
     */
    inline SetPINSettingError& operator = (const SetPINSettingError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetPINSettingError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetPINSettingError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetPINSettingError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetPINSettingError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SetPINSettingError::SetPINSettingErrorField getField () const;

    inline void setField(SetPINSettingError::SetPINSettingErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SetPINSettingErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SetPINSettingErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SetPINSettingErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SetPINSettingErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SetPINSettingErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SetPINSettingErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SetPINSettingErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SetPINSettingErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SetPINSettingError &getDefaultInstance();

private:

    inline void cloneData (const SetPINSettingError& rhs);

    inline void deleteData ();

    SetPINSettingErrorField __field;

    union {
        SetPINSettingErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "PINSettingStatus"
 * Property Gives update about the PIN Setting Status
 */
class PINSettingStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PINSettingStatusStatus ();

    /**
     * Copy constructor
     */
    inline  PINSettingStatusStatus (const PINSettingStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  PINSettingStatusStatus (::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter e8Invalid_Parameter_);

    /**
     * Destructor
     */
    inline virtual  ~PINSettingStatusStatus();

    /**
     * Assignment operator
     */
    inline PINSettingStatusStatus& operator = (const PINSettingStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PINSettingStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PINSettingStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PINSettingStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PINSettingStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Invalid_Parameter"

    static const int kE8Invalid_Parameter = 0;

    /**
     * Clears the field "e8Invalid_Parameter".
     *
     * The field will be set to its default value. The hasE8Invalid_Parameter()
     * method will return false.
     */
    inline void clearE8Invalid_Parameter();

    /**
     * Checks whether the field "e8Invalid_Parameter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Invalid_Parameter()). Otherwise it will return false.
     */
    inline bool hasE8Invalid_Parameter () const;

    /**
     * Returns the value of the member "e8Invalid_Parameter".
     *
     * If the meaning of "e8Invalid_Parameter" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Invalid_Parameter"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter getE8Invalid_Parameter () const;

    /**
     * Sets the value of the member "e8Invalid_Parameter".
     *
     * If the meaning of "e8Invalid_Parameter" isn't clear, then there should be a description here.
     *
     * @param e8Invalid_Parameter The value which will be set
     */
    inline void setE8Invalid_Parameter (::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter e8Invalid_Parameter_);

    static const PINSettingStatusStatus &getDefaultInstance();

private:

    inline void set_has_e8Invalid_Parameter ();

    inline void clear_has_e8Invalid_Parameter ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter _e8Invalid_Parameter;

};

/**
 * The error message of 'GetChargeReminder'
 * Error Message
 */
class GetChargeReminderErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetChargeReminderErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetChargeReminderErrorStructure (const GetChargeReminderErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetChargeReminderErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~GetChargeReminderErrorStructure();

    /**
     * Assignment operator
     */
    inline GetChargeReminderErrorStructure& operator = (const GetChargeReminderErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetChargeReminderErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetChargeReminderErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetChargeReminderErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetChargeReminderErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const GetChargeReminderErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'GetChargeReminder'
 * Error Message
 */
class GetChargeReminderError  : public ::asf::core::Payload {
public:

    enum GetChargeReminderErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetChargeReminderError ();

   /**
     * Copy constructor
     */
    inline  GetChargeReminderError (const GetChargeReminderError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetChargeReminderError();

    /**
     * Assigns a new value to this object.
     */
    inline GetChargeReminderError& operator = (const GetChargeReminderError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetChargeReminderError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetChargeReminderError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetChargeReminderError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetChargeReminderError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetChargeReminderError::GetChargeReminderErrorField getField () const;

    inline void setField(GetChargeReminderError::GetChargeReminderErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetChargeReminderErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetChargeReminderErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetChargeReminderErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetChargeReminderErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetChargeReminderErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetChargeReminderErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetChargeReminderErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetChargeReminderErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetChargeReminderError &getDefaultInstance();

private:

    inline void cloneData (const GetChargeReminderError& rhs);

    inline void deleteData ();

    GetChargeReminderErrorField __field;

    union {
        GetChargeReminderErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SetChargeReminder"
 * ITMaster request EV Charge reminder information to TCU (Fctn ID : 251h)
 */
class SetChargeReminderStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetChargeReminderStart ();

    /**
     * Copy constructor
     */
    inline  SetChargeReminderStart (const SetChargeReminderStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetChargeReminderStart (const ::tcu_main_fi_types::T_TCU_ReminderInfo& rReminderInfo_);

    /**
     * Destructor
     */
    inline virtual  ~SetChargeReminderStart();

    /**
     * Assignment operator
     */
    inline SetChargeReminderStart& operator = (const SetChargeReminderStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetChargeReminderStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetChargeReminderStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetChargeReminderStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetChargeReminderStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "rReminderInfo"

    static const int kRReminderInfo = 0;

    /**
     * Clears the field "rReminderInfo".
     *
     * The field will be set to its default value. The hasRReminderInfo()
     * method will return false.
     */
    inline void clearRReminderInfo();

    /**
     * Checks whether the field "rReminderInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRReminderInfo()). Otherwise it will return false.
     */
    inline bool hasRReminderInfo () const;

    /**
     * Returns the value of the member "rReminderInfo".
     *
     * If the meaning of "rReminderInfo" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rReminderInfo"
     */
    inline const ::tcu_main_fi_types::T_TCU_ReminderInfo& getRReminderInfo () const;

    /**
     * Retrieves the value of the field "rReminderInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rReminderInfo".
     */
    inline ::tcu_main_fi_types::T_TCU_ReminderInfo& getRReminderInfoMutable ();

    /**
     * Sets the value of the member "rReminderInfo".
     *
     * If the meaning of "rReminderInfo" isn't clear, then there should be a description here.
     *
     * @param rReminderInfo The value which will be set
     */
    inline void setRReminderInfo (const ::tcu_main_fi_types::T_TCU_ReminderInfo& rReminderInfo_);

    static const SetChargeReminderStart &getDefaultInstance();

private:

    inline void set_has_rReminderInfo ();

    inline void clear_has_rReminderInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tcu_main_fi_types::T_TCU_ReminderInfo _rReminderInfo;

};

/**
 * The error message of 'SetChargeReminder'
 * Error Message
 */
class SetChargeReminderErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SetChargeReminderErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SetChargeReminderErrorStructure (const SetChargeReminderErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SetChargeReminderErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~SetChargeReminderErrorStructure();

    /**
     * Assignment operator
     */
    inline SetChargeReminderErrorStructure& operator = (const SetChargeReminderErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetChargeReminderErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetChargeReminderErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetChargeReminderErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetChargeReminderErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const SetChargeReminderErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'SetChargeReminder'
 * Error Message
 */
class SetChargeReminderError  : public ::asf::core::Payload {
public:

    enum SetChargeReminderErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SetChargeReminderError ();

   /**
     * Copy constructor
     */
    inline  SetChargeReminderError (const SetChargeReminderError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SetChargeReminderError();

    /**
     * Assigns a new value to this object.
     */
    inline SetChargeReminderError& operator = (const SetChargeReminderError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetChargeReminderError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetChargeReminderError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetChargeReminderError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetChargeReminderError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SetChargeReminderError::SetChargeReminderErrorField getField () const;

    inline void setField(SetChargeReminderError::SetChargeReminderErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SetChargeReminderErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SetChargeReminderErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SetChargeReminderErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SetChargeReminderErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SetChargeReminderErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SetChargeReminderErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SetChargeReminderErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SetChargeReminderErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SetChargeReminderError &getDefaultInstance();

private:

    inline void cloneData (const SetChargeReminderError& rhs);

    inline void deleteData ();

    SetChargeReminderErrorField __field;

    union {
        SetChargeReminderErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "ChargeReminderStatus"
 * ITMaster receive EV Charge reminder information from TCU  (Fctn ID : 251h)
 */
class ChargeReminderStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ChargeReminderStatusStatus ();

    /**
     * Copy constructor
     */
    inline  ChargeReminderStatusStatus (const ChargeReminderStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ChargeReminderStatusStatus (const ::tcu_main_fi_types::T_TCU_ReminderInfo& rReminderInfo_);

    /**
     * Destructor
     */
    inline virtual  ~ChargeReminderStatusStatus();

    /**
     * Assignment operator
     */
    inline ChargeReminderStatusStatus& operator = (const ChargeReminderStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChargeReminderStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChargeReminderStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChargeReminderStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChargeReminderStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "rReminderInfo"

    static const int kRReminderInfo = 0;

    /**
     * Clears the field "rReminderInfo".
     *
     * The field will be set to its default value. The hasRReminderInfo()
     * method will return false.
     */
    inline void clearRReminderInfo();

    /**
     * Checks whether the field "rReminderInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRReminderInfo()). Otherwise it will return false.
     */
    inline bool hasRReminderInfo () const;

    /**
     * Returns the value of the member "rReminderInfo".
     *
     * If the meaning of "rReminderInfo" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rReminderInfo"
     */
    inline const ::tcu_main_fi_types::T_TCU_ReminderInfo& getRReminderInfo () const;

    /**
     * Retrieves the value of the field "rReminderInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rReminderInfo".
     */
    inline ::tcu_main_fi_types::T_TCU_ReminderInfo& getRReminderInfoMutable ();

    /**
     * Sets the value of the member "rReminderInfo".
     *
     * If the meaning of "rReminderInfo" isn't clear, then there should be a description here.
     *
     * @param rReminderInfo The value which will be set
     */
    inline void setRReminderInfo (const ::tcu_main_fi_types::T_TCU_ReminderInfo& rReminderInfo_);

    static const ChargeReminderStatusStatus &getDefaultInstance();

private:

    inline void set_has_rReminderInfo ();

    inline void clear_has_rReminderInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tcu_main_fi_types::T_TCU_ReminderInfo _rReminderInfo;

};

/**
 * The status message of the property "ChargeRecordDelete"
 */
class ChargeRecordDeleteStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ChargeRecordDeleteStatus ();

    /**
     * Copy constructor
     */
    inline  ChargeRecordDeleteStatus (const ChargeRecordDeleteStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ChargeRecordDeleteStatus (const ::tcu_main_fi_types::T_TCU_ReminderInfo& rReminderInfo_);

    /**
     * Destructor
     */
    inline virtual  ~ChargeRecordDeleteStatus();

    /**
     * Assignment operator
     */
    inline ChargeRecordDeleteStatus& operator = (const ChargeRecordDeleteStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChargeRecordDeleteStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChargeRecordDeleteStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChargeRecordDeleteStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChargeRecordDeleteStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "rReminderInfo"

    static const int kRReminderInfo = 0;

    /**
     * Clears the field "rReminderInfo".
     *
     * The field will be set to its default value. The hasRReminderInfo()
     * method will return false.
     */
    inline void clearRReminderInfo();

    /**
     * Checks whether the field "rReminderInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRReminderInfo()). Otherwise it will return false.
     */
    inline bool hasRReminderInfo () const;

    /**
     * Returns the value of the member "rReminderInfo".
     *
     * If the meaning of "rReminderInfo" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rReminderInfo"
     */
    inline const ::tcu_main_fi_types::T_TCU_ReminderInfo& getRReminderInfo () const;

    /**
     * Retrieves the value of the field "rReminderInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rReminderInfo".
     */
    inline ::tcu_main_fi_types::T_TCU_ReminderInfo& getRReminderInfoMutable ();

    /**
     * Sets the value of the member "rReminderInfo".
     *
     * If the meaning of "rReminderInfo" isn't clear, then there should be a description here.
     *
     * @param rReminderInfo The value which will be set
     */
    inline void setRReminderInfo (const ::tcu_main_fi_types::T_TCU_ReminderInfo& rReminderInfo_);

    static const ChargeRecordDeleteStatus &getDefaultInstance();

private:

    inline void set_has_rReminderInfo ();

    inline void clear_has_rReminderInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tcu_main_fi_types::T_TCU_ReminderInfo _rReminderInfo;

};

/**
 * The start message of the method "GetStationFinder"
 * Helps to find compatible charging spot by providing Current location
 */
class GetStationFinderStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetStationFinderStart ();

    /**
     * Copy constructor
     */
    inline  GetStationFinderStart (const GetStationFinderStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetStationFinderStart (::tcu_main_fi_types::T_e8_TCU_Service_Type e8ServiceType_, const ::std::string& sCurrentCountry_, const ::tcu_main_fi_types::T_TCU_GPS_Position& rSearch_GPS_Position_, ::tcu_main_fi_types::T_e8_TCU_ePOI_Type e8ePOI_Type_, const ::tcu_main_fi_types::T_TCU_Spot_Receptacle_Type& rSpot_Receptacle_Type_, uint16 u16Vehicle_Autonomy_, uint32 u32BatteryIdentificationNumber_, const ::tcu_main_fi_types::T_TCU_Navigation_Language& rNavigation_Language_);

    /**
     * Destructor
     */
    inline virtual  ~GetStationFinderStart();

    /**
     * Assignment operator
     */
    inline GetStationFinderStart& operator = (const GetStationFinderStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetStationFinderStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetStationFinderStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetStationFinderStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetStationFinderStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ServiceType"

    static const int kE8ServiceType = 0;

    /**
     * Clears the field "e8ServiceType".
     *
     * The field will be set to its default value. The hasE8ServiceType()
     * method will return false.
     */
    inline void clearE8ServiceType();

    /**
     * Checks whether the field "e8ServiceType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ServiceType()). Otherwise it will return false.
     */
    inline bool hasE8ServiceType () const;

    /**
     * Returns the value of the member "e8ServiceType".
     *
     * Service Type
     *
     * @return The value of the field "e8ServiceType"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_Service_Type getE8ServiceType () const;

    /**
     * Sets the value of the member "e8ServiceType".
     *
     * Service Type
     *
     * @param e8ServiceType The value which will be set
     */
    inline void setE8ServiceType (::tcu_main_fi_types::T_e8_TCU_Service_Type e8ServiceType_);

    // API of field "sCurrentCountry"

    static const int kSCurrentCountry = 1;

    /**
     * Clears the field "sCurrentCountry".
     *
     * The field will be set to its default value. The hasSCurrentCountry()
     * method will return false.
     */
    inline void clearSCurrentCountry();

    /**
     * Checks whether the field "sCurrentCountry" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSCurrentCountry()). Otherwise it will return false.
     */
    inline bool hasSCurrentCountry () const;

    /**
     * Returns the value of the member "sCurrentCountry".
     *
     * If the meaning of "sCurrentCountry" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sCurrentCountry"
     */
    inline const ::std::string& getSCurrentCountry () const;

    /**
     * Retrieves the value of the field "sCurrentCountry" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sCurrentCountry".
     */
    inline ::std::string& getSCurrentCountryMutable ();

    /**
     * Sets the value of the member "sCurrentCountry".
     *
     * If the meaning of "sCurrentCountry" isn't clear, then there should be a description here.
     *
     * @param sCurrentCountry The value which will be set
     */
    inline void setSCurrentCountry (const ::std::string& sCurrentCountry_);

    /**
     * Sets the value of the member "sCurrentCountry".
     *
     * If the meaning of "sCurrentCountry" isn't clear, then there should be a description here.
     *
     * @param sCurrentCountry The value which will be set
     */
    inline void setSCurrentCountry (const char* sCurrentCountry_);

    /**
     * Sets the value of the member "sCurrentCountry".
     *
     * If the meaning of "sCurrentCountry" isn't clear, then there should be a description here.
     *
     * @param sCurrentCountry The value which will be set
     */
    inline void setSCurrentCountry (const char* value, size_t size);

    // API of field "rSearch_GPS_Position"

    static const int kRSearch_GPS_Position = 2;

    /**
     * Clears the field "rSearch_GPS_Position".
     *
     * The field will be set to its default value. The hasRSearch_GPS_Position()
     * method will return false.
     */
    inline void clearRSearch_GPS_Position();

    /**
     * Checks whether the field "rSearch_GPS_Position" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRSearch_GPS_Position()). Otherwise it will return false.
     */
    inline bool hasRSearch_GPS_Position () const;

    /**
     * Returns the value of the member "rSearch_GPS_Position".
     *
     * If the meaning of "rSearch_GPS_Position" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rSearch_GPS_Position"
     */
    inline const ::tcu_main_fi_types::T_TCU_GPS_Position& getRSearch_GPS_Position () const;

    /**
     * Retrieves the value of the field "rSearch_GPS_Position" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rSearch_GPS_Position".
     */
    inline ::tcu_main_fi_types::T_TCU_GPS_Position& getRSearch_GPS_PositionMutable ();

    /**
     * Sets the value of the member "rSearch_GPS_Position".
     *
     * If the meaning of "rSearch_GPS_Position" isn't clear, then there should be a description here.
     *
     * @param rSearch_GPS_Position The value which will be set
     */
    inline void setRSearch_GPS_Position (const ::tcu_main_fi_types::T_TCU_GPS_Position& rSearch_GPS_Position_);

    // API of field "e8ePOI_Type"

    static const int kE8ePOI_Type = 3;

    /**
     * Clears the field "e8ePOI_Type".
     *
     * The field will be set to its default value. The hasE8ePOI_Type()
     * method will return false.
     */
    inline void clearE8ePOI_Type();

    /**
     * Checks whether the field "e8ePOI_Type" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ePOI_Type()). Otherwise it will return false.
     */
    inline bool hasE8ePOI_Type () const;

    /**
     * Returns the value of the member "e8ePOI_Type".
     *
     * If the meaning of "e8ePOI_Type" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8ePOI_Type"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_ePOI_Type getE8ePOI_Type () const;

    /**
     * Sets the value of the member "e8ePOI_Type".
     *
     * If the meaning of "e8ePOI_Type" isn't clear, then there should be a description here.
     *
     * @param e8ePOI_Type The value which will be set
     */
    inline void setE8ePOI_Type (::tcu_main_fi_types::T_e8_TCU_ePOI_Type e8ePOI_Type_);

    // API of field "rSpot_Receptacle_Type"

    static const int kRSpot_Receptacle_Type = 4;

    /**
     * Clears the field "rSpot_Receptacle_Type".
     *
     * The field will be set to its default value. The hasRSpot_Receptacle_Type()
     * method will return false.
     */
    inline void clearRSpot_Receptacle_Type();

    /**
     * Checks whether the field "rSpot_Receptacle_Type" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRSpot_Receptacle_Type()). Otherwise it will return false.
     */
    inline bool hasRSpot_Receptacle_Type () const;

    /**
     * Returns the value of the member "rSpot_Receptacle_Type".
     *
     * If the meaning of "rSpot_Receptacle_Type" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rSpot_Receptacle_Type"
     */
    inline const ::tcu_main_fi_types::T_TCU_Spot_Receptacle_Type& getRSpot_Receptacle_Type () const;

    /**
     * Retrieves the value of the field "rSpot_Receptacle_Type" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rSpot_Receptacle_Type".
     */
    inline ::tcu_main_fi_types::T_TCU_Spot_Receptacle_Type& getRSpot_Receptacle_TypeMutable ();

    /**
     * Sets the value of the member "rSpot_Receptacle_Type".
     *
     * If the meaning of "rSpot_Receptacle_Type" isn't clear, then there should be a description here.
     *
     * @param rSpot_Receptacle_Type The value which will be set
     */
    inline void setRSpot_Receptacle_Type (const ::tcu_main_fi_types::T_TCU_Spot_Receptacle_Type& rSpot_Receptacle_Type_);

    // API of field "u16Vehicle_Autonomy"

    static const int kU16Vehicle_Autonomy = 5;

    /**
     * Clears the field "u16Vehicle_Autonomy".
     *
     * The field will be set to its default value. The hasU16Vehicle_Autonomy()
     * method will return false.
     */
    inline void clearU16Vehicle_Autonomy();

    /**
     * Checks whether the field "u16Vehicle_Autonomy" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16Vehicle_Autonomy()). Otherwise it will return false.
     */
    inline bool hasU16Vehicle_Autonomy () const;

    /**
     * Returns the value of the member "u16Vehicle_Autonomy".
     *
     * If the meaning of "u16Vehicle_Autonomy" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u16Vehicle_Autonomy"
     */
    inline uint16 getU16Vehicle_Autonomy () const;

    /**
     * Sets the value of the member "u16Vehicle_Autonomy".
     *
     * If the meaning of "u16Vehicle_Autonomy" isn't clear, then there should be a description here.
     *
     * @param u16Vehicle_Autonomy The value which will be set
     */
    inline void setU16Vehicle_Autonomy (uint16 u16Vehicle_Autonomy_);

    // API of field "u32BatteryIdentificationNumber"

    static const int kU32BatteryIdentificationNumber = 6;

    /**
     * Clears the field "u32BatteryIdentificationNumber".
     *
     * The field will be set to its default value. The hasU32BatteryIdentificationNumber()
     * method will return false.
     */
    inline void clearU32BatteryIdentificationNumber();

    /**
     * Checks whether the field "u32BatteryIdentificationNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32BatteryIdentificationNumber()). Otherwise it will return false.
     */
    inline bool hasU32BatteryIdentificationNumber () const;

    /**
     * Returns the value of the member "u32BatteryIdentificationNumber".
     *
     * If the meaning of "u32BatteryIdentificationNumber" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32BatteryIdentificationNumber"
     */
    inline uint32 getU32BatteryIdentificationNumber () const;

    /**
     * Sets the value of the member "u32BatteryIdentificationNumber".
     *
     * If the meaning of "u32BatteryIdentificationNumber" isn't clear, then there should be a description here.
     *
     * @param u32BatteryIdentificationNumber The value which will be set
     */
    inline void setU32BatteryIdentificationNumber (uint32 u32BatteryIdentificationNumber_);

    // API of field "rNavigation_Language"

    static const int kRNavigation_Language = 7;

    /**
     * Clears the field "rNavigation_Language".
     *
     * The field will be set to its default value. The hasRNavigation_Language()
     * method will return false.
     */
    inline void clearRNavigation_Language();

    /**
     * Checks whether the field "rNavigation_Language" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRNavigation_Language()). Otherwise it will return false.
     */
    inline bool hasRNavigation_Language () const;

    /**
     * Returns the value of the member "rNavigation_Language".
     *
     * If the meaning of "rNavigation_Language" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rNavigation_Language"
     */
    inline const ::tcu_main_fi_types::T_TCU_Navigation_Language& getRNavigation_Language () const;

    /**
     * Retrieves the value of the field "rNavigation_Language" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rNavigation_Language".
     */
    inline ::tcu_main_fi_types::T_TCU_Navigation_Language& getRNavigation_LanguageMutable ();

    /**
     * Sets the value of the member "rNavigation_Language".
     *
     * If the meaning of "rNavigation_Language" isn't clear, then there should be a description here.
     *
     * @param rNavigation_Language The value which will be set
     */
    inline void setRNavigation_Language (const ::tcu_main_fi_types::T_TCU_Navigation_Language& rNavigation_Language_);

    static const GetStationFinderStart &getDefaultInstance();

private:

    inline void set_has_e8ServiceType ();

    inline void clear_has_e8ServiceType ();

    inline void set_has_sCurrentCountry ();

    inline void clear_has_sCurrentCountry ();

    inline void set_has_rSearch_GPS_Position ();

    inline void clear_has_rSearch_GPS_Position ();

    inline void set_has_e8ePOI_Type ();

    inline void clear_has_e8ePOI_Type ();

    inline void set_has_rSpot_Receptacle_Type ();

    inline void clear_has_rSpot_Receptacle_Type ();

    inline void set_has_u16Vehicle_Autonomy ();

    inline void clear_has_u16Vehicle_Autonomy ();

    inline void set_has_u32BatteryIdentificationNumber ();

    inline void clear_has_u32BatteryIdentificationNumber ();

    inline void set_has_rNavigation_Language ();

    inline void clear_has_rNavigation_Language ();

    uint32 _has_bits_[ (8 + 31) / 32];

    ::tcu_main_fi_types::T_e8_TCU_Service_Type _e8ServiceType;

    ::std::string _sCurrentCountry;

    ::tcu_main_fi_types::T_TCU_GPS_Position _rSearch_GPS_Position;

    ::tcu_main_fi_types::T_e8_TCU_ePOI_Type _e8ePOI_Type;

    ::tcu_main_fi_types::T_TCU_Spot_Receptacle_Type _rSpot_Receptacle_Type;

    uint16 _u16Vehicle_Autonomy;

    uint32 _u32BatteryIdentificationNumber;

    ::tcu_main_fi_types::T_TCU_Navigation_Language _rNavigation_Language;

};

/**
 * The error message of 'GetStationFinder'
 * Error Message
 */
class GetStationFinderErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetStationFinderErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetStationFinderErrorStructure (const GetStationFinderErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetStationFinderErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~GetStationFinderErrorStructure();

    /**
     * Assignment operator
     */
    inline GetStationFinderErrorStructure& operator = (const GetStationFinderErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetStationFinderErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetStationFinderErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetStationFinderErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetStationFinderErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const GetStationFinderErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'GetStationFinder'
 * Error Message
 */
class GetStationFinderError  : public ::asf::core::Payload {
public:

    enum GetStationFinderErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetStationFinderError ();

   /**
     * Copy constructor
     */
    inline  GetStationFinderError (const GetStationFinderError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetStationFinderError();

    /**
     * Assigns a new value to this object.
     */
    inline GetStationFinderError& operator = (const GetStationFinderError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetStationFinderError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetStationFinderError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetStationFinderError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetStationFinderError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetStationFinderError::GetStationFinderErrorField getField () const;

    inline void setField(GetStationFinderError::GetStationFinderErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetStationFinderErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetStationFinderErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetStationFinderErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetStationFinderErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetStationFinderErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetStationFinderErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetStationFinderErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetStationFinderErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetStationFinderError &getDefaultInstance();

private:

    inline void cloneData (const GetStationFinderError& rhs);

    inline void deleteData ();

    GetStationFinderErrorField __field;

    union {
        GetStationFinderErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "StationFinderStatus"
 * Provides the info about charging spot
 */
class StationFinderStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StationFinderStatusStatus ();

    /**
     * Copy constructor
     */
    inline  StationFinderStatusStatus (const StationFinderStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  StationFinderStatusStatus (::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter e8Invalid_Parameter_, ::tcu_main_fi_types::T_e8_TCU_Finder_Status e8FinderStatus_, uint8 u8Total_Station_Number_);

    /**
     * Destructor
     */
    inline virtual  ~StationFinderStatusStatus();

    /**
     * Assignment operator
     */
    inline StationFinderStatusStatus& operator = (const StationFinderStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StationFinderStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StationFinderStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StationFinderStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StationFinderStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Invalid_Parameter"

    static const int kE8Invalid_Parameter = 0;

    /**
     * Clears the field "e8Invalid_Parameter".
     *
     * The field will be set to its default value. The hasE8Invalid_Parameter()
     * method will return false.
     */
    inline void clearE8Invalid_Parameter();

    /**
     * Checks whether the field "e8Invalid_Parameter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Invalid_Parameter()). Otherwise it will return false.
     */
    inline bool hasE8Invalid_Parameter () const;

    /**
     * Returns the value of the member "e8Invalid_Parameter".
     *
     * If the meaning of "e8Invalid_Parameter" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Invalid_Parameter"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter getE8Invalid_Parameter () const;

    /**
     * Sets the value of the member "e8Invalid_Parameter".
     *
     * If the meaning of "e8Invalid_Parameter" isn't clear, then there should be a description here.
     *
     * @param e8Invalid_Parameter The value which will be set
     */
    inline void setE8Invalid_Parameter (::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter e8Invalid_Parameter_);

    // API of field "e8FinderStatus"

    static const int kE8FinderStatus = 1;

    /**
     * Clears the field "e8FinderStatus".
     *
     * The field will be set to its default value. The hasE8FinderStatus()
     * method will return false.
     */
    inline void clearE8FinderStatus();

    /**
     * Checks whether the field "e8FinderStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8FinderStatus()). Otherwise it will return false.
     */
    inline bool hasE8FinderStatus () const;

    /**
     * Returns the value of the member "e8FinderStatus".
     *
     * If the meaning of "e8FinderStatus" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8FinderStatus"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_Finder_Status getE8FinderStatus () const;

    /**
     * Sets the value of the member "e8FinderStatus".
     *
     * If the meaning of "e8FinderStatus" isn't clear, then there should be a description here.
     *
     * @param e8FinderStatus The value which will be set
     */
    inline void setE8FinderStatus (::tcu_main_fi_types::T_e8_TCU_Finder_Status e8FinderStatus_);

    // API of field "u8Total_Station_Number"

    static const int kU8Total_Station_Number = 2;

    /**
     * Clears the field "u8Total_Station_Number".
     *
     * The field will be set to its default value. The hasU8Total_Station_Number()
     * method will return false.
     */
    inline void clearU8Total_Station_Number();

    /**
     * Checks whether the field "u8Total_Station_Number" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Total_Station_Number()). Otherwise it will return false.
     */
    inline bool hasU8Total_Station_Number () const;

    /**
     * Returns the value of the member "u8Total_Station_Number".
     *
     * If the meaning of "u8Total_Station_Number" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Total_Station_Number"
     */
    inline uint8 getU8Total_Station_Number () const;

    /**
     * Sets the value of the member "u8Total_Station_Number".
     *
     * If the meaning of "u8Total_Station_Number" isn't clear, then there should be a description here.
     *
     * @param u8Total_Station_Number The value which will be set
     */
    inline void setU8Total_Station_Number (uint8 u8Total_Station_Number_);

    static const StationFinderStatusStatus &getDefaultInstance();

private:

    inline void set_has_e8Invalid_Parameter ();

    inline void clear_has_e8Invalid_Parameter ();

    inline void set_has_e8FinderStatus ();

    inline void clear_has_e8FinderStatus ();

    inline void set_has_u8Total_Station_Number ();

    inline void clear_has_u8Total_Station_Number ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter _e8Invalid_Parameter;

    ::tcu_main_fi_types::T_e8_TCU_Finder_Status _e8FinderStatus;

    uint8 _u8Total_Station_Number;

};

/**
 * The start message of the method "GetChargeStation"
 * Message used to Request the information on each found charge station.
 */
class GetChargeStationStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetChargeStationStart ();

    /**
     * Copy constructor
     */
    inline  GetChargeStationStart (const GetChargeStationStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetChargeStationStart (uint8 u8Station_List_Number_);

    /**
     * Destructor
     */
    inline virtual  ~GetChargeStationStart();

    /**
     * Assignment operator
     */
    inline GetChargeStationStart& operator = (const GetChargeStationStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetChargeStationStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetChargeStationStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetChargeStationStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetChargeStationStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8Station_List_Number"

    static const int kU8Station_List_Number = 0;

    /**
     * Clears the field "u8Station_List_Number".
     *
     * The field will be set to its default value. The hasU8Station_List_Number()
     * method will return false.
     */
    inline void clearU8Station_List_Number();

    /**
     * Checks whether the field "u8Station_List_Number" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Station_List_Number()). Otherwise it will return false.
     */
    inline bool hasU8Station_List_Number () const;

    /**
     * Returns the value of the member "u8Station_List_Number".
     *
     * If the meaning of "u8Station_List_Number" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Station_List_Number"
     */
    inline uint8 getU8Station_List_Number () const;

    /**
     * Sets the value of the member "u8Station_List_Number".
     *
     * If the meaning of "u8Station_List_Number" isn't clear, then there should be a description here.
     *
     * @param u8Station_List_Number The value which will be set
     */
    inline void setU8Station_List_Number (uint8 u8Station_List_Number_);

    static const GetChargeStationStart &getDefaultInstance();

private:

    inline void set_has_u8Station_List_Number ();

    inline void clear_has_u8Station_List_Number ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8Station_List_Number;

};

/**
 * The error message of 'GetChargeStation'
 * Error Message
 */
class GetChargeStationErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetChargeStationErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetChargeStationErrorStructure (const GetChargeStationErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetChargeStationErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~GetChargeStationErrorStructure();

    /**
     * Assignment operator
     */
    inline GetChargeStationErrorStructure& operator = (const GetChargeStationErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetChargeStationErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetChargeStationErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetChargeStationErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetChargeStationErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const GetChargeStationErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'GetChargeStation'
 * Error Message
 */
class GetChargeStationError  : public ::asf::core::Payload {
public:

    enum GetChargeStationErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetChargeStationError ();

   /**
     * Copy constructor
     */
    inline  GetChargeStationError (const GetChargeStationError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetChargeStationError();

    /**
     * Assigns a new value to this object.
     */
    inline GetChargeStationError& operator = (const GetChargeStationError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetChargeStationError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetChargeStationError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetChargeStationError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetChargeStationError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetChargeStationError::GetChargeStationErrorField getField () const;

    inline void setField(GetChargeStationError::GetChargeStationErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetChargeStationErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetChargeStationErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetChargeStationErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetChargeStationErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetChargeStationErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetChargeStationErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetChargeStationErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetChargeStationErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetChargeStationError &getDefaultInstance();

private:

    inline void cloneData (const GetChargeStationError& rhs);

    inline void deleteData ();

    GetChargeStationErrorField __field;

    union {
        GetChargeStationErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "ChargeStationStatus"
 * Message used to Receive the information on each found charge station.
 */
class ChargeStationStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ChargeStationStatusStatus ();

    /**
     * Copy constructor
     */
    inline  ChargeStationStatusStatus (const ChargeStationStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ChargeStationStatusStatus (uint8 u8Station_List_Number_, const ::std::string& sCharge_Station_ID_, const ::tcu_main_fi_types::T_TCU_GPS_Position& rEPOI_GPS_Position_, const ::std::string& sEnergy_Provider_Name_, const ::std::string& sUtility_Aggregator_ID_, const ::tcu_main_fi_types::T_TCU_Time_Stamp& rTime_Stamp_, const ::std::string& sPhone_Number_, const ::tcu_main_fi_types::T_TCU_Opening_Hour& rOpening_Hour_, ::tcu_main_fi_types::T_TCU_Charge_Station_Accessibility e8Charge_Station_Accessibility_, ::tcu_main_fi_types::T_TCU_Payment_Method_Type e8Payment_Method_Type_, uint8 u8Spot_Total_Number_, uint8 u8Number_Available_Batteries_, const ::tcu_main_fi_types::T_TCU_Full_Address& rFull_Address_, uint8 u8Charge_Staion_Ranking_);

    /**
     * Destructor
     */
    inline virtual  ~ChargeStationStatusStatus();

    /**
     * Assignment operator
     */
    inline ChargeStationStatusStatus& operator = (const ChargeStationStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChargeStationStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChargeStationStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChargeStationStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChargeStationStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8Station_List_Number"

    static const int kU8Station_List_Number = 0;

    /**
     * Clears the field "u8Station_List_Number".
     *
     * The field will be set to its default value. The hasU8Station_List_Number()
     * method will return false.
     */
    inline void clearU8Station_List_Number();

    /**
     * Checks whether the field "u8Station_List_Number" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Station_List_Number()). Otherwise it will return false.
     */
    inline bool hasU8Station_List_Number () const;

    /**
     * Returns the value of the member "u8Station_List_Number".
     *
     * If the meaning of "u8Station_List_Number" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Station_List_Number"
     */
    inline uint8 getU8Station_List_Number () const;

    /**
     * Sets the value of the member "u8Station_List_Number".
     *
     * If the meaning of "u8Station_List_Number" isn't clear, then there should be a description here.
     *
     * @param u8Station_List_Number The value which will be set
     */
    inline void setU8Station_List_Number (uint8 u8Station_List_Number_);

    // API of field "sCharge_Station_ID"

    static const int kSCharge_Station_ID = 1;

    /**
     * Clears the field "sCharge_Station_ID".
     *
     * The field will be set to its default value. The hasSCharge_Station_ID()
     * method will return false.
     */
    inline void clearSCharge_Station_ID();

    /**
     * Checks whether the field "sCharge_Station_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSCharge_Station_ID()). Otherwise it will return false.
     */
    inline bool hasSCharge_Station_ID () const;

    /**
     * Returns the value of the member "sCharge_Station_ID".
     *
     * If the meaning of "sCharge_Station_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sCharge_Station_ID"
     */
    inline const ::std::string& getSCharge_Station_ID () const;

    /**
     * Retrieves the value of the field "sCharge_Station_ID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sCharge_Station_ID".
     */
    inline ::std::string& getSCharge_Station_IDMutable ();

    /**
     * Sets the value of the member "sCharge_Station_ID".
     *
     * If the meaning of "sCharge_Station_ID" isn't clear, then there should be a description here.
     *
     * @param sCharge_Station_ID The value which will be set
     */
    inline void setSCharge_Station_ID (const ::std::string& sCharge_Station_ID_);

    /**
     * Sets the value of the member "sCharge_Station_ID".
     *
     * If the meaning of "sCharge_Station_ID" isn't clear, then there should be a description here.
     *
     * @param sCharge_Station_ID The value which will be set
     */
    inline void setSCharge_Station_ID (const char* sCharge_Station_ID_);

    /**
     * Sets the value of the member "sCharge_Station_ID".
     *
     * If the meaning of "sCharge_Station_ID" isn't clear, then there should be a description here.
     *
     * @param sCharge_Station_ID The value which will be set
     */
    inline void setSCharge_Station_ID (const char* value, size_t size);

    // API of field "rEPOI_GPS_Position"

    static const int kREPOI_GPS_Position = 2;

    /**
     * Clears the field "rEPOI_GPS_Position".
     *
     * The field will be set to its default value. The hasREPOI_GPS_Position()
     * method will return false.
     */
    inline void clearREPOI_GPS_Position();

    /**
     * Checks whether the field "rEPOI_GPS_Position" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setREPOI_GPS_Position()). Otherwise it will return false.
     */
    inline bool hasREPOI_GPS_Position () const;

    /**
     * Returns the value of the member "rEPOI_GPS_Position".
     *
     * If the meaning of "rEPOI_GPS_Position" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rEPOI_GPS_Position"
     */
    inline const ::tcu_main_fi_types::T_TCU_GPS_Position& getREPOI_GPS_Position () const;

    /**
     * Retrieves the value of the field "rEPOI_GPS_Position" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rEPOI_GPS_Position".
     */
    inline ::tcu_main_fi_types::T_TCU_GPS_Position& getREPOI_GPS_PositionMutable ();

    /**
     * Sets the value of the member "rEPOI_GPS_Position".
     *
     * If the meaning of "rEPOI_GPS_Position" isn't clear, then there should be a description here.
     *
     * @param rEPOI_GPS_Position The value which will be set
     */
    inline void setREPOI_GPS_Position (const ::tcu_main_fi_types::T_TCU_GPS_Position& rEPOI_GPS_Position_);

    // API of field "sEnergy_Provider_Name"

    static const int kSEnergy_Provider_Name = 3;

    /**
     * Clears the field "sEnergy_Provider_Name".
     *
     * The field will be set to its default value. The hasSEnergy_Provider_Name()
     * method will return false.
     */
    inline void clearSEnergy_Provider_Name();

    /**
     * Checks whether the field "sEnergy_Provider_Name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSEnergy_Provider_Name()). Otherwise it will return false.
     */
    inline bool hasSEnergy_Provider_Name () const;

    /**
     * Returns the value of the member "sEnergy_Provider_Name".
     *
     * If the meaning of "sEnergy_Provider_Name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sEnergy_Provider_Name"
     */
    inline const ::std::string& getSEnergy_Provider_Name () const;

    /**
     * Retrieves the value of the field "sEnergy_Provider_Name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sEnergy_Provider_Name".
     */
    inline ::std::string& getSEnergy_Provider_NameMutable ();

    /**
     * Sets the value of the member "sEnergy_Provider_Name".
     *
     * If the meaning of "sEnergy_Provider_Name" isn't clear, then there should be a description here.
     *
     * @param sEnergy_Provider_Name The value which will be set
     */
    inline void setSEnergy_Provider_Name (const ::std::string& sEnergy_Provider_Name_);

    /**
     * Sets the value of the member "sEnergy_Provider_Name".
     *
     * If the meaning of "sEnergy_Provider_Name" isn't clear, then there should be a description here.
     *
     * @param sEnergy_Provider_Name The value which will be set
     */
    inline void setSEnergy_Provider_Name (const char* sEnergy_Provider_Name_);

    /**
     * Sets the value of the member "sEnergy_Provider_Name".
     *
     * If the meaning of "sEnergy_Provider_Name" isn't clear, then there should be a description here.
     *
     * @param sEnergy_Provider_Name The value which will be set
     */
    inline void setSEnergy_Provider_Name (const char* value, size_t size);

    // API of field "sUtility_Aggregator_ID"

    static const int kSUtility_Aggregator_ID = 4;

    /**
     * Clears the field "sUtility_Aggregator_ID".
     *
     * The field will be set to its default value. The hasSUtility_Aggregator_ID()
     * method will return false.
     */
    inline void clearSUtility_Aggregator_ID();

    /**
     * Checks whether the field "sUtility_Aggregator_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSUtility_Aggregator_ID()). Otherwise it will return false.
     */
    inline bool hasSUtility_Aggregator_ID () const;

    /**
     * Returns the value of the member "sUtility_Aggregator_ID".
     *
     * If the meaning of "sUtility_Aggregator_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sUtility_Aggregator_ID"
     */
    inline const ::std::string& getSUtility_Aggregator_ID () const;

    /**
     * Retrieves the value of the field "sUtility_Aggregator_ID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sUtility_Aggregator_ID".
     */
    inline ::std::string& getSUtility_Aggregator_IDMutable ();

    /**
     * Sets the value of the member "sUtility_Aggregator_ID".
     *
     * If the meaning of "sUtility_Aggregator_ID" isn't clear, then there should be a description here.
     *
     * @param sUtility_Aggregator_ID The value which will be set
     */
    inline void setSUtility_Aggregator_ID (const ::std::string& sUtility_Aggregator_ID_);

    /**
     * Sets the value of the member "sUtility_Aggregator_ID".
     *
     * If the meaning of "sUtility_Aggregator_ID" isn't clear, then there should be a description here.
     *
     * @param sUtility_Aggregator_ID The value which will be set
     */
    inline void setSUtility_Aggregator_ID (const char* sUtility_Aggregator_ID_);

    /**
     * Sets the value of the member "sUtility_Aggregator_ID".
     *
     * If the meaning of "sUtility_Aggregator_ID" isn't clear, then there should be a description here.
     *
     * @param sUtility_Aggregator_ID The value which will be set
     */
    inline void setSUtility_Aggregator_ID (const char* value, size_t size);

    // API of field "rTime_Stamp"

    static const int kRTime_Stamp = 5;

    /**
     * Clears the field "rTime_Stamp".
     *
     * The field will be set to its default value. The hasRTime_Stamp()
     * method will return false.
     */
    inline void clearRTime_Stamp();

    /**
     * Checks whether the field "rTime_Stamp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRTime_Stamp()). Otherwise it will return false.
     */
    inline bool hasRTime_Stamp () const;

    /**
     * Returns the value of the member "rTime_Stamp".
     *
     * If the meaning of "rTime_Stamp" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rTime_Stamp"
     */
    inline const ::tcu_main_fi_types::T_TCU_Time_Stamp& getRTime_Stamp () const;

    /**
     * Retrieves the value of the field "rTime_Stamp" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rTime_Stamp".
     */
    inline ::tcu_main_fi_types::T_TCU_Time_Stamp& getRTime_StampMutable ();

    /**
     * Sets the value of the member "rTime_Stamp".
     *
     * If the meaning of "rTime_Stamp" isn't clear, then there should be a description here.
     *
     * @param rTime_Stamp The value which will be set
     */
    inline void setRTime_Stamp (const ::tcu_main_fi_types::T_TCU_Time_Stamp& rTime_Stamp_);

    // API of field "sPhone_Number"

    static const int kSPhone_Number = 6;

    /**
     * Clears the field "sPhone_Number".
     *
     * The field will be set to its default value. The hasSPhone_Number()
     * method will return false.
     */
    inline void clearSPhone_Number();

    /**
     * Checks whether the field "sPhone_Number" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSPhone_Number()). Otherwise it will return false.
     */
    inline bool hasSPhone_Number () const;

    /**
     * Returns the value of the member "sPhone_Number".
     *
     * If the meaning of "sPhone_Number" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sPhone_Number"
     */
    inline const ::std::string& getSPhone_Number () const;

    /**
     * Retrieves the value of the field "sPhone_Number" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sPhone_Number".
     */
    inline ::std::string& getSPhone_NumberMutable ();

    /**
     * Sets the value of the member "sPhone_Number".
     *
     * If the meaning of "sPhone_Number" isn't clear, then there should be a description here.
     *
     * @param sPhone_Number The value which will be set
     */
    inline void setSPhone_Number (const ::std::string& sPhone_Number_);

    /**
     * Sets the value of the member "sPhone_Number".
     *
     * If the meaning of "sPhone_Number" isn't clear, then there should be a description here.
     *
     * @param sPhone_Number The value which will be set
     */
    inline void setSPhone_Number (const char* sPhone_Number_);

    /**
     * Sets the value of the member "sPhone_Number".
     *
     * If the meaning of "sPhone_Number" isn't clear, then there should be a description here.
     *
     * @param sPhone_Number The value which will be set
     */
    inline void setSPhone_Number (const char* value, size_t size);

    // API of field "rOpening_Hour"

    static const int kROpening_Hour = 7;

    /**
     * Clears the field "rOpening_Hour".
     *
     * The field will be set to its default value. The hasROpening_Hour()
     * method will return false.
     */
    inline void clearROpening_Hour();

    /**
     * Checks whether the field "rOpening_Hour" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setROpening_Hour()). Otherwise it will return false.
     */
    inline bool hasROpening_Hour () const;

    /**
     * Returns the value of the member "rOpening_Hour".
     *
     * If the meaning of "rOpening_Hour" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rOpening_Hour"
     */
    inline const ::tcu_main_fi_types::T_TCU_Opening_Hour& getROpening_Hour () const;

    /**
     * Retrieves the value of the field "rOpening_Hour" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rOpening_Hour".
     */
    inline ::tcu_main_fi_types::T_TCU_Opening_Hour& getROpening_HourMutable ();

    /**
     * Sets the value of the member "rOpening_Hour".
     *
     * If the meaning of "rOpening_Hour" isn't clear, then there should be a description here.
     *
     * @param rOpening_Hour The value which will be set
     */
    inline void setROpening_Hour (const ::tcu_main_fi_types::T_TCU_Opening_Hour& rOpening_Hour_);

    // API of field "e8Charge_Station_Accessibility"

    static const int kE8Charge_Station_Accessibility = 8;

    /**
     * Clears the field "e8Charge_Station_Accessibility".
     *
     * The field will be set to its default value. The hasE8Charge_Station_Accessibility()
     * method will return false.
     */
    inline void clearE8Charge_Station_Accessibility();

    /**
     * Checks whether the field "e8Charge_Station_Accessibility" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Charge_Station_Accessibility()). Otherwise it will return false.
     */
    inline bool hasE8Charge_Station_Accessibility () const;

    /**
     * Returns the value of the member "e8Charge_Station_Accessibility".
     *
     * If the meaning of "e8Charge_Station_Accessibility" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Charge_Station_Accessibility"
     */
    inline ::tcu_main_fi_types::T_TCU_Charge_Station_Accessibility getE8Charge_Station_Accessibility () const;

    /**
     * Sets the value of the member "e8Charge_Station_Accessibility".
     *
     * If the meaning of "e8Charge_Station_Accessibility" isn't clear, then there should be a description here.
     *
     * @param e8Charge_Station_Accessibility The value which will be set
     */
    inline void setE8Charge_Station_Accessibility (::tcu_main_fi_types::T_TCU_Charge_Station_Accessibility e8Charge_Station_Accessibility_);

    // API of field "e8Payment_Method_Type"

    static const int kE8Payment_Method_Type = 9;

    /**
     * Clears the field "e8Payment_Method_Type".
     *
     * The field will be set to its default value. The hasE8Payment_Method_Type()
     * method will return false.
     */
    inline void clearE8Payment_Method_Type();

    /**
     * Checks whether the field "e8Payment_Method_Type" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Payment_Method_Type()). Otherwise it will return false.
     */
    inline bool hasE8Payment_Method_Type () const;

    /**
     * Returns the value of the member "e8Payment_Method_Type".
     *
     * If the meaning of "e8Payment_Method_Type" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Payment_Method_Type"
     */
    inline ::tcu_main_fi_types::T_TCU_Payment_Method_Type getE8Payment_Method_Type () const;

    /**
     * Sets the value of the member "e8Payment_Method_Type".
     *
     * If the meaning of "e8Payment_Method_Type" isn't clear, then there should be a description here.
     *
     * @param e8Payment_Method_Type The value which will be set
     */
    inline void setE8Payment_Method_Type (::tcu_main_fi_types::T_TCU_Payment_Method_Type e8Payment_Method_Type_);

    // API of field "u8Spot_Total_Number"

    static const int kU8Spot_Total_Number = 10;

    /**
     * Clears the field "u8Spot_Total_Number".
     *
     * The field will be set to its default value. The hasU8Spot_Total_Number()
     * method will return false.
     */
    inline void clearU8Spot_Total_Number();

    /**
     * Checks whether the field "u8Spot_Total_Number" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Spot_Total_Number()). Otherwise it will return false.
     */
    inline bool hasU8Spot_Total_Number () const;

    /**
     * Returns the value of the member "u8Spot_Total_Number".
     *
     * If the meaning of "u8Spot_Total_Number" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Spot_Total_Number"
     */
    inline uint8 getU8Spot_Total_Number () const;

    /**
     * Sets the value of the member "u8Spot_Total_Number".
     *
     * If the meaning of "u8Spot_Total_Number" isn't clear, then there should be a description here.
     *
     * @param u8Spot_Total_Number The value which will be set
     */
    inline void setU8Spot_Total_Number (uint8 u8Spot_Total_Number_);

    // API of field "u8Number_Available_Batteries"

    static const int kU8Number_Available_Batteries = 11;

    /**
     * Clears the field "u8Number_Available_Batteries".
     *
     * The field will be set to its default value. The hasU8Number_Available_Batteries()
     * method will return false.
     */
    inline void clearU8Number_Available_Batteries();

    /**
     * Checks whether the field "u8Number_Available_Batteries" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Number_Available_Batteries()). Otherwise it will return false.
     */
    inline bool hasU8Number_Available_Batteries () const;

    /**
     * Returns the value of the member "u8Number_Available_Batteries".
     *
     * If the meaning of "u8Number_Available_Batteries" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Number_Available_Batteries"
     */
    inline uint8 getU8Number_Available_Batteries () const;

    /**
     * Sets the value of the member "u8Number_Available_Batteries".
     *
     * If the meaning of "u8Number_Available_Batteries" isn't clear, then there should be a description here.
     *
     * @param u8Number_Available_Batteries The value which will be set
     */
    inline void setU8Number_Available_Batteries (uint8 u8Number_Available_Batteries_);

    // API of field "rFull_Address"

    static const int kRFull_Address = 12;

    /**
     * Clears the field "rFull_Address".
     *
     * The field will be set to its default value. The hasRFull_Address()
     * method will return false.
     */
    inline void clearRFull_Address();

    /**
     * Checks whether the field "rFull_Address" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRFull_Address()). Otherwise it will return false.
     */
    inline bool hasRFull_Address () const;

    /**
     * Returns the value of the member "rFull_Address".
     *
     * If the meaning of "rFull_Address" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rFull_Address"
     */
    inline const ::tcu_main_fi_types::T_TCU_Full_Address& getRFull_Address () const;

    /**
     * Retrieves the value of the field "rFull_Address" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rFull_Address".
     */
    inline ::tcu_main_fi_types::T_TCU_Full_Address& getRFull_AddressMutable ();

    /**
     * Sets the value of the member "rFull_Address".
     *
     * If the meaning of "rFull_Address" isn't clear, then there should be a description here.
     *
     * @param rFull_Address The value which will be set
     */
    inline void setRFull_Address (const ::tcu_main_fi_types::T_TCU_Full_Address& rFull_Address_);

    // API of field "u8Charge_Staion_Ranking"

    static const int kU8Charge_Staion_Ranking = 13;

    /**
     * Clears the field "u8Charge_Staion_Ranking".
     *
     * The field will be set to its default value. The hasU8Charge_Staion_Ranking()
     * method will return false.
     */
    inline void clearU8Charge_Staion_Ranking();

    /**
     * Checks whether the field "u8Charge_Staion_Ranking" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Charge_Staion_Ranking()). Otherwise it will return false.
     */
    inline bool hasU8Charge_Staion_Ranking () const;

    /**
     * Returns the value of the member "u8Charge_Staion_Ranking".
     *
     * If the meaning of "u8Charge_Staion_Ranking" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Charge_Staion_Ranking"
     */
    inline uint8 getU8Charge_Staion_Ranking () const;

    /**
     * Sets the value of the member "u8Charge_Staion_Ranking".
     *
     * If the meaning of "u8Charge_Staion_Ranking" isn't clear, then there should be a description here.
     *
     * @param u8Charge_Staion_Ranking The value which will be set
     */
    inline void setU8Charge_Staion_Ranking (uint8 u8Charge_Staion_Ranking_);

    static const ChargeStationStatusStatus &getDefaultInstance();

private:

    inline void set_has_u8Station_List_Number ();

    inline void clear_has_u8Station_List_Number ();

    inline void set_has_sCharge_Station_ID ();

    inline void clear_has_sCharge_Station_ID ();

    inline void set_has_rEPOI_GPS_Position ();

    inline void clear_has_rEPOI_GPS_Position ();

    inline void set_has_sEnergy_Provider_Name ();

    inline void clear_has_sEnergy_Provider_Name ();

    inline void set_has_sUtility_Aggregator_ID ();

    inline void clear_has_sUtility_Aggregator_ID ();

    inline void set_has_rTime_Stamp ();

    inline void clear_has_rTime_Stamp ();

    inline void set_has_sPhone_Number ();

    inline void clear_has_sPhone_Number ();

    inline void set_has_rOpening_Hour ();

    inline void clear_has_rOpening_Hour ();

    inline void set_has_e8Charge_Station_Accessibility ();

    inline void clear_has_e8Charge_Station_Accessibility ();

    inline void set_has_e8Payment_Method_Type ();

    inline void clear_has_e8Payment_Method_Type ();

    inline void set_has_u8Spot_Total_Number ();

    inline void clear_has_u8Spot_Total_Number ();

    inline void set_has_u8Number_Available_Batteries ();

    inline void clear_has_u8Number_Available_Batteries ();

    inline void set_has_rFull_Address ();

    inline void clear_has_rFull_Address ();

    inline void set_has_u8Charge_Staion_Ranking ();

    inline void clear_has_u8Charge_Staion_Ranking ();

    uint32 _has_bits_[ (14 + 31) / 32];

    uint8 _u8Station_List_Number;

    ::std::string _sCharge_Station_ID;

    ::tcu_main_fi_types::T_TCU_GPS_Position _rEPOI_GPS_Position;

    ::std::string _sEnergy_Provider_Name;

    ::std::string _sUtility_Aggregator_ID;

    ::tcu_main_fi_types::T_TCU_Time_Stamp _rTime_Stamp;

    ::std::string _sPhone_Number;

    ::tcu_main_fi_types::T_TCU_Opening_Hour _rOpening_Hour;

    ::tcu_main_fi_types::T_TCU_Charge_Station_Accessibility _e8Charge_Station_Accessibility;

    ::tcu_main_fi_types::T_TCU_Payment_Method_Type _e8Payment_Method_Type;

    uint8 _u8Spot_Total_Number;

    uint8 _u8Number_Available_Batteries;

    ::tcu_main_fi_types::T_TCU_Full_Address _rFull_Address;

    uint8 _u8Charge_Staion_Ranking;

};

/**
 * The start message of the method "GetChargeSpotList"
 * Requests the spot list of a station
 */
class GetChargeSpotListStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetChargeSpotListStart ();

    /**
     * Copy constructor
     */
    inline  GetChargeSpotListStart (const GetChargeSpotListStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetChargeSpotListStart (uint8 u8Station_List_Number_, uint8 u8Pages_Of_List_);

    /**
     * Destructor
     */
    inline virtual  ~GetChargeSpotListStart();

    /**
     * Assignment operator
     */
    inline GetChargeSpotListStart& operator = (const GetChargeSpotListStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetChargeSpotListStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetChargeSpotListStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetChargeSpotListStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetChargeSpotListStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8Station_List_Number"

    static const int kU8Station_List_Number = 0;

    /**
     * Clears the field "u8Station_List_Number".
     *
     * The field will be set to its default value. The hasU8Station_List_Number()
     * method will return false.
     */
    inline void clearU8Station_List_Number();

    /**
     * Checks whether the field "u8Station_List_Number" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Station_List_Number()). Otherwise it will return false.
     */
    inline bool hasU8Station_List_Number () const;

    /**
     * Returns the value of the member "u8Station_List_Number".
     *
     * If the meaning of "u8Station_List_Number" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Station_List_Number"
     */
    inline uint8 getU8Station_List_Number () const;

    /**
     * Sets the value of the member "u8Station_List_Number".
     *
     * If the meaning of "u8Station_List_Number" isn't clear, then there should be a description here.
     *
     * @param u8Station_List_Number The value which will be set
     */
    inline void setU8Station_List_Number (uint8 u8Station_List_Number_);

    // API of field "u8Pages_Of_List"

    static const int kU8Pages_Of_List = 1;

    /**
     * Clears the field "u8Pages_Of_List".
     *
     * The field will be set to its default value. The hasU8Pages_Of_List()
     * method will return false.
     */
    inline void clearU8Pages_Of_List();

    /**
     * Checks whether the field "u8Pages_Of_List" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Pages_Of_List()). Otherwise it will return false.
     */
    inline bool hasU8Pages_Of_List () const;

    /**
     * Returns the value of the member "u8Pages_Of_List".
     *
     * If the meaning of "u8Pages_Of_List" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Pages_Of_List"
     */
    inline uint8 getU8Pages_Of_List () const;

    /**
     * Sets the value of the member "u8Pages_Of_List".
     *
     * If the meaning of "u8Pages_Of_List" isn't clear, then there should be a description here.
     *
     * @param u8Pages_Of_List The value which will be set
     */
    inline void setU8Pages_Of_List (uint8 u8Pages_Of_List_);

    static const GetChargeSpotListStart &getDefaultInstance();

private:

    inline void set_has_u8Station_List_Number ();

    inline void clear_has_u8Station_List_Number ();

    inline void set_has_u8Pages_Of_List ();

    inline void clear_has_u8Pages_Of_List ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8Station_List_Number;

    uint8 _u8Pages_Of_List;

};

/**
 * The error message of 'GetChargeSpotList'
 * Error Message
 */
class GetChargeSpotListErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetChargeSpotListErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetChargeSpotListErrorStructure (const GetChargeSpotListErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetChargeSpotListErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~GetChargeSpotListErrorStructure();

    /**
     * Assignment operator
     */
    inline GetChargeSpotListErrorStructure& operator = (const GetChargeSpotListErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetChargeSpotListErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetChargeSpotListErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetChargeSpotListErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetChargeSpotListErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const GetChargeSpotListErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'GetChargeSpotList'
 * Error Message
 */
class GetChargeSpotListError  : public ::asf::core::Payload {
public:

    enum GetChargeSpotListErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetChargeSpotListError ();

   /**
     * Copy constructor
     */
    inline  GetChargeSpotListError (const GetChargeSpotListError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetChargeSpotListError();

    /**
     * Assigns a new value to this object.
     */
    inline GetChargeSpotListError& operator = (const GetChargeSpotListError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetChargeSpotListError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetChargeSpotListError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetChargeSpotListError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetChargeSpotListError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetChargeSpotListError::GetChargeSpotListErrorField getField () const;

    inline void setField(GetChargeSpotListError::GetChargeSpotListErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetChargeSpotListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetChargeSpotListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetChargeSpotListErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetChargeSpotListErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetChargeSpotListErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetChargeSpotListErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetChargeSpotListErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetChargeSpotListErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetChargeSpotListError &getDefaultInstance();

private:

    inline void cloneData (const GetChargeSpotListError& rhs);

    inline void deleteData ();

    GetChargeSpotListErrorField __field;

    union {
        GetChargeSpotListErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "GetShortBooking"
 * Receive the spot list of a station.
 */
class GetShortBookingStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetShortBookingStart ();

    /**
     * Copy constructor
     */
    inline  GetShortBookingStart (const GetShortBookingStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetShortBookingStart (const ::std::string& sCharge_Station_ID_, const ::std::string& sCustomer_Contract_ID_, ::tcu_main_fi_types::T_e8_TCU_ePOI_Type e8ePOI_Type_, ::tcu_main_fi_types::T_e8_TCU_Charge_Receptacle_Type e8Charge_Receptacle_Type_, const ::std::string& sUtility_Aggregator_ID_, const ::std::string& sCurrent_Country_, const ::std::string& sCharge_Spot_ID_, uint32 u32Battery_Identification_Number_, const ::tcu_main_fi_types::T_TCU_Time& rService_Time_Request_, const ::tcu_main_fi_types::T_TCU_Navigation_Language& rNavigation_Language_, const ::tcu_main_fi_types::T_TCU_Time_Stamp& rTime_Stamp_);

    /**
     * Destructor
     */
    inline virtual  ~GetShortBookingStart();

    /**
     * Assignment operator
     */
    inline GetShortBookingStart& operator = (const GetShortBookingStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetShortBookingStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetShortBookingStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetShortBookingStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetShortBookingStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sCharge_Station_ID"

    static const int kSCharge_Station_ID = 0;

    /**
     * Clears the field "sCharge_Station_ID".
     *
     * The field will be set to its default value. The hasSCharge_Station_ID()
     * method will return false.
     */
    inline void clearSCharge_Station_ID();

    /**
     * Checks whether the field "sCharge_Station_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSCharge_Station_ID()). Otherwise it will return false.
     */
    inline bool hasSCharge_Station_ID () const;

    /**
     * Returns the value of the member "sCharge_Station_ID".
     *
     * If the meaning of "sCharge_Station_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sCharge_Station_ID"
     */
    inline const ::std::string& getSCharge_Station_ID () const;

    /**
     * Retrieves the value of the field "sCharge_Station_ID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sCharge_Station_ID".
     */
    inline ::std::string& getSCharge_Station_IDMutable ();

    /**
     * Sets the value of the member "sCharge_Station_ID".
     *
     * If the meaning of "sCharge_Station_ID" isn't clear, then there should be a description here.
     *
     * @param sCharge_Station_ID The value which will be set
     */
    inline void setSCharge_Station_ID (const ::std::string& sCharge_Station_ID_);

    /**
     * Sets the value of the member "sCharge_Station_ID".
     *
     * If the meaning of "sCharge_Station_ID" isn't clear, then there should be a description here.
     *
     * @param sCharge_Station_ID The value which will be set
     */
    inline void setSCharge_Station_ID (const char* sCharge_Station_ID_);

    /**
     * Sets the value of the member "sCharge_Station_ID".
     *
     * If the meaning of "sCharge_Station_ID" isn't clear, then there should be a description here.
     *
     * @param sCharge_Station_ID The value which will be set
     */
    inline void setSCharge_Station_ID (const char* value, size_t size);

    // API of field "sCustomer_Contract_ID"

    static const int kSCustomer_Contract_ID = 1;

    /**
     * Clears the field "sCustomer_Contract_ID".
     *
     * The field will be set to its default value. The hasSCustomer_Contract_ID()
     * method will return false.
     */
    inline void clearSCustomer_Contract_ID();

    /**
     * Checks whether the field "sCustomer_Contract_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSCustomer_Contract_ID()). Otherwise it will return false.
     */
    inline bool hasSCustomer_Contract_ID () const;

    /**
     * Returns the value of the member "sCustomer_Contract_ID".
     *
     * If the meaning of "sCustomer_Contract_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sCustomer_Contract_ID"
     */
    inline const ::std::string& getSCustomer_Contract_ID () const;

    /**
     * Retrieves the value of the field "sCustomer_Contract_ID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sCustomer_Contract_ID".
     */
    inline ::std::string& getSCustomer_Contract_IDMutable ();

    /**
     * Sets the value of the member "sCustomer_Contract_ID".
     *
     * If the meaning of "sCustomer_Contract_ID" isn't clear, then there should be a description here.
     *
     * @param sCustomer_Contract_ID The value which will be set
     */
    inline void setSCustomer_Contract_ID (const ::std::string& sCustomer_Contract_ID_);

    /**
     * Sets the value of the member "sCustomer_Contract_ID".
     *
     * If the meaning of "sCustomer_Contract_ID" isn't clear, then there should be a description here.
     *
     * @param sCustomer_Contract_ID The value which will be set
     */
    inline void setSCustomer_Contract_ID (const char* sCustomer_Contract_ID_);

    /**
     * Sets the value of the member "sCustomer_Contract_ID".
     *
     * If the meaning of "sCustomer_Contract_ID" isn't clear, then there should be a description here.
     *
     * @param sCustomer_Contract_ID The value which will be set
     */
    inline void setSCustomer_Contract_ID (const char* value, size_t size);

    // API of field "e8ePOI_Type"

    static const int kE8ePOI_Type = 2;

    /**
     * Clears the field "e8ePOI_Type".
     *
     * The field will be set to its default value. The hasE8ePOI_Type()
     * method will return false.
     */
    inline void clearE8ePOI_Type();

    /**
     * Checks whether the field "e8ePOI_Type" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ePOI_Type()). Otherwise it will return false.
     */
    inline bool hasE8ePOI_Type () const;

    /**
     * Returns the value of the member "e8ePOI_Type".
     *
     * If the meaning of "e8ePOI_Type" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8ePOI_Type"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_ePOI_Type getE8ePOI_Type () const;

    /**
     * Sets the value of the member "e8ePOI_Type".
     *
     * If the meaning of "e8ePOI_Type" isn't clear, then there should be a description here.
     *
     * @param e8ePOI_Type The value which will be set
     */
    inline void setE8ePOI_Type (::tcu_main_fi_types::T_e8_TCU_ePOI_Type e8ePOI_Type_);

    // API of field "e8Charge_Receptacle_Type"

    static const int kE8Charge_Receptacle_Type = 3;

    /**
     * Clears the field "e8Charge_Receptacle_Type".
     *
     * The field will be set to its default value. The hasE8Charge_Receptacle_Type()
     * method will return false.
     */
    inline void clearE8Charge_Receptacle_Type();

    /**
     * Checks whether the field "e8Charge_Receptacle_Type" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Charge_Receptacle_Type()). Otherwise it will return false.
     */
    inline bool hasE8Charge_Receptacle_Type () const;

    /**
     * Returns the value of the member "e8Charge_Receptacle_Type".
     *
     * If the meaning of "e8Charge_Receptacle_Type" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Charge_Receptacle_Type"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_Charge_Receptacle_Type getE8Charge_Receptacle_Type () const;

    /**
     * Sets the value of the member "e8Charge_Receptacle_Type".
     *
     * If the meaning of "e8Charge_Receptacle_Type" isn't clear, then there should be a description here.
     *
     * @param e8Charge_Receptacle_Type The value which will be set
     */
    inline void setE8Charge_Receptacle_Type (::tcu_main_fi_types::T_e8_TCU_Charge_Receptacle_Type e8Charge_Receptacle_Type_);

    // API of field "sUtility_Aggregator_ID"

    static const int kSUtility_Aggregator_ID = 4;

    /**
     * Clears the field "sUtility_Aggregator_ID".
     *
     * The field will be set to its default value. The hasSUtility_Aggregator_ID()
     * method will return false.
     */
    inline void clearSUtility_Aggregator_ID();

    /**
     * Checks whether the field "sUtility_Aggregator_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSUtility_Aggregator_ID()). Otherwise it will return false.
     */
    inline bool hasSUtility_Aggregator_ID () const;

    /**
     * Returns the value of the member "sUtility_Aggregator_ID".
     *
     * If the meaning of "sUtility_Aggregator_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sUtility_Aggregator_ID"
     */
    inline const ::std::string& getSUtility_Aggregator_ID () const;

    /**
     * Retrieves the value of the field "sUtility_Aggregator_ID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sUtility_Aggregator_ID".
     */
    inline ::std::string& getSUtility_Aggregator_IDMutable ();

    /**
     * Sets the value of the member "sUtility_Aggregator_ID".
     *
     * If the meaning of "sUtility_Aggregator_ID" isn't clear, then there should be a description here.
     *
     * @param sUtility_Aggregator_ID The value which will be set
     */
    inline void setSUtility_Aggregator_ID (const ::std::string& sUtility_Aggregator_ID_);

    /**
     * Sets the value of the member "sUtility_Aggregator_ID".
     *
     * If the meaning of "sUtility_Aggregator_ID" isn't clear, then there should be a description here.
     *
     * @param sUtility_Aggregator_ID The value which will be set
     */
    inline void setSUtility_Aggregator_ID (const char* sUtility_Aggregator_ID_);

    /**
     * Sets the value of the member "sUtility_Aggregator_ID".
     *
     * If the meaning of "sUtility_Aggregator_ID" isn't clear, then there should be a description here.
     *
     * @param sUtility_Aggregator_ID The value which will be set
     */
    inline void setSUtility_Aggregator_ID (const char* value, size_t size);

    // API of field "sCurrent_Country"

    static const int kSCurrent_Country = 5;

    /**
     * Clears the field "sCurrent_Country".
     *
     * The field will be set to its default value. The hasSCurrent_Country()
     * method will return false.
     */
    inline void clearSCurrent_Country();

    /**
     * Checks whether the field "sCurrent_Country" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSCurrent_Country()). Otherwise it will return false.
     */
    inline bool hasSCurrent_Country () const;

    /**
     * Returns the value of the member "sCurrent_Country".
     *
     * If the meaning of "sCurrent_Country" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sCurrent_Country"
     */
    inline const ::std::string& getSCurrent_Country () const;

    /**
     * Retrieves the value of the field "sCurrent_Country" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sCurrent_Country".
     */
    inline ::std::string& getSCurrent_CountryMutable ();

    /**
     * Sets the value of the member "sCurrent_Country".
     *
     * If the meaning of "sCurrent_Country" isn't clear, then there should be a description here.
     *
     * @param sCurrent_Country The value which will be set
     */
    inline void setSCurrent_Country (const ::std::string& sCurrent_Country_);

    /**
     * Sets the value of the member "sCurrent_Country".
     *
     * If the meaning of "sCurrent_Country" isn't clear, then there should be a description here.
     *
     * @param sCurrent_Country The value which will be set
     */
    inline void setSCurrent_Country (const char* sCurrent_Country_);

    /**
     * Sets the value of the member "sCurrent_Country".
     *
     * If the meaning of "sCurrent_Country" isn't clear, then there should be a description here.
     *
     * @param sCurrent_Country The value which will be set
     */
    inline void setSCurrent_Country (const char* value, size_t size);

    // API of field "sCharge_Spot_ID"

    static const int kSCharge_Spot_ID = 6;

    /**
     * Clears the field "sCharge_Spot_ID".
     *
     * The field will be set to its default value. The hasSCharge_Spot_ID()
     * method will return false.
     */
    inline void clearSCharge_Spot_ID();

    /**
     * Checks whether the field "sCharge_Spot_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSCharge_Spot_ID()). Otherwise it will return false.
     */
    inline bool hasSCharge_Spot_ID () const;

    /**
     * Returns the value of the member "sCharge_Spot_ID".
     *
     * If the meaning of "sCharge_Spot_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sCharge_Spot_ID"
     */
    inline const ::std::string& getSCharge_Spot_ID () const;

    /**
     * Retrieves the value of the field "sCharge_Spot_ID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sCharge_Spot_ID".
     */
    inline ::std::string& getSCharge_Spot_IDMutable ();

    /**
     * Sets the value of the member "sCharge_Spot_ID".
     *
     * If the meaning of "sCharge_Spot_ID" isn't clear, then there should be a description here.
     *
     * @param sCharge_Spot_ID The value which will be set
     */
    inline void setSCharge_Spot_ID (const ::std::string& sCharge_Spot_ID_);

    /**
     * Sets the value of the member "sCharge_Spot_ID".
     *
     * If the meaning of "sCharge_Spot_ID" isn't clear, then there should be a description here.
     *
     * @param sCharge_Spot_ID The value which will be set
     */
    inline void setSCharge_Spot_ID (const char* sCharge_Spot_ID_);

    /**
     * Sets the value of the member "sCharge_Spot_ID".
     *
     * If the meaning of "sCharge_Spot_ID" isn't clear, then there should be a description here.
     *
     * @param sCharge_Spot_ID The value which will be set
     */
    inline void setSCharge_Spot_ID (const char* value, size_t size);

    // API of field "u32Battery_Identification_Number"

    static const int kU32Battery_Identification_Number = 7;

    /**
     * Clears the field "u32Battery_Identification_Number".
     *
     * The field will be set to its default value. The hasU32Battery_Identification_Number()
     * method will return false.
     */
    inline void clearU32Battery_Identification_Number();

    /**
     * Checks whether the field "u32Battery_Identification_Number" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Battery_Identification_Number()). Otherwise it will return false.
     */
    inline bool hasU32Battery_Identification_Number () const;

    /**
     * Returns the value of the member "u32Battery_Identification_Number".
     *
     * If the meaning of "u32Battery_Identification_Number" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32Battery_Identification_Number"
     */
    inline uint32 getU32Battery_Identification_Number () const;

    /**
     * Sets the value of the member "u32Battery_Identification_Number".
     *
     * If the meaning of "u32Battery_Identification_Number" isn't clear, then there should be a description here.
     *
     * @param u32Battery_Identification_Number The value which will be set
     */
    inline void setU32Battery_Identification_Number (uint32 u32Battery_Identification_Number_);

    // API of field "rService_Time_Request"

    static const int kRService_Time_Request = 8;

    /**
     * Clears the field "rService_Time_Request".
     *
     * The field will be set to its default value. The hasRService_Time_Request()
     * method will return false.
     */
    inline void clearRService_Time_Request();

    /**
     * Checks whether the field "rService_Time_Request" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRService_Time_Request()). Otherwise it will return false.
     */
    inline bool hasRService_Time_Request () const;

    /**
     * Returns the value of the member "rService_Time_Request".
     *
     * If the meaning of "rService_Time_Request" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rService_Time_Request"
     */
    inline const ::tcu_main_fi_types::T_TCU_Time& getRService_Time_Request () const;

    /**
     * Retrieves the value of the field "rService_Time_Request" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rService_Time_Request".
     */
    inline ::tcu_main_fi_types::T_TCU_Time& getRService_Time_RequestMutable ();

    /**
     * Sets the value of the member "rService_Time_Request".
     *
     * If the meaning of "rService_Time_Request" isn't clear, then there should be a description here.
     *
     * @param rService_Time_Request The value which will be set
     */
    inline void setRService_Time_Request (const ::tcu_main_fi_types::T_TCU_Time& rService_Time_Request_);

    // API of field "rNavigation_Language"

    static const int kRNavigation_Language = 9;

    /**
     * Clears the field "rNavigation_Language".
     *
     * The field will be set to its default value. The hasRNavigation_Language()
     * method will return false.
     */
    inline void clearRNavigation_Language();

    /**
     * Checks whether the field "rNavigation_Language" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRNavigation_Language()). Otherwise it will return false.
     */
    inline bool hasRNavigation_Language () const;

    /**
     * Returns the value of the member "rNavigation_Language".
     *
     * If the meaning of "rNavigation_Language" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rNavigation_Language"
     */
    inline const ::tcu_main_fi_types::T_TCU_Navigation_Language& getRNavigation_Language () const;

    /**
     * Retrieves the value of the field "rNavigation_Language" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rNavigation_Language".
     */
    inline ::tcu_main_fi_types::T_TCU_Navigation_Language& getRNavigation_LanguageMutable ();

    /**
     * Sets the value of the member "rNavigation_Language".
     *
     * If the meaning of "rNavigation_Language" isn't clear, then there should be a description here.
     *
     * @param rNavigation_Language The value which will be set
     */
    inline void setRNavigation_Language (const ::tcu_main_fi_types::T_TCU_Navigation_Language& rNavigation_Language_);

    // API of field "rTime_Stamp"

    static const int kRTime_Stamp = 10;

    /**
     * Clears the field "rTime_Stamp".
     *
     * The field will be set to its default value. The hasRTime_Stamp()
     * method will return false.
     */
    inline void clearRTime_Stamp();

    /**
     * Checks whether the field "rTime_Stamp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRTime_Stamp()). Otherwise it will return false.
     */
    inline bool hasRTime_Stamp () const;

    /**
     * Returns the value of the member "rTime_Stamp".
     *
     * If the meaning of "rTime_Stamp" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rTime_Stamp"
     */
    inline const ::tcu_main_fi_types::T_TCU_Time_Stamp& getRTime_Stamp () const;

    /**
     * Retrieves the value of the field "rTime_Stamp" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rTime_Stamp".
     */
    inline ::tcu_main_fi_types::T_TCU_Time_Stamp& getRTime_StampMutable ();

    /**
     * Sets the value of the member "rTime_Stamp".
     *
     * If the meaning of "rTime_Stamp" isn't clear, then there should be a description here.
     *
     * @param rTime_Stamp The value which will be set
     */
    inline void setRTime_Stamp (const ::tcu_main_fi_types::T_TCU_Time_Stamp& rTime_Stamp_);

    static const GetShortBookingStart &getDefaultInstance();

private:

    inline void set_has_sCharge_Station_ID ();

    inline void clear_has_sCharge_Station_ID ();

    inline void set_has_sCustomer_Contract_ID ();

    inline void clear_has_sCustomer_Contract_ID ();

    inline void set_has_e8ePOI_Type ();

    inline void clear_has_e8ePOI_Type ();

    inline void set_has_e8Charge_Receptacle_Type ();

    inline void clear_has_e8Charge_Receptacle_Type ();

    inline void set_has_sUtility_Aggregator_ID ();

    inline void clear_has_sUtility_Aggregator_ID ();

    inline void set_has_sCurrent_Country ();

    inline void clear_has_sCurrent_Country ();

    inline void set_has_sCharge_Spot_ID ();

    inline void clear_has_sCharge_Spot_ID ();

    inline void set_has_u32Battery_Identification_Number ();

    inline void clear_has_u32Battery_Identification_Number ();

    inline void set_has_rService_Time_Request ();

    inline void clear_has_rService_Time_Request ();

    inline void set_has_rNavigation_Language ();

    inline void clear_has_rNavigation_Language ();

    inline void set_has_rTime_Stamp ();

    inline void clear_has_rTime_Stamp ();

    uint32 _has_bits_[ (11 + 31) / 32];

    ::std::string _sCharge_Station_ID;

    ::std::string _sCustomer_Contract_ID;

    ::tcu_main_fi_types::T_e8_TCU_ePOI_Type _e8ePOI_Type;

    ::tcu_main_fi_types::T_e8_TCU_Charge_Receptacle_Type _e8Charge_Receptacle_Type;

    ::std::string _sUtility_Aggregator_ID;

    ::std::string _sCurrent_Country;

    ::std::string _sCharge_Spot_ID;

    uint32 _u32Battery_Identification_Number;

    ::tcu_main_fi_types::T_TCU_Time _rService_Time_Request;

    ::tcu_main_fi_types::T_TCU_Navigation_Language _rNavigation_Language;

    ::tcu_main_fi_types::T_TCU_Time_Stamp _rTime_Stamp;

};

/**
 * The error message of 'GetShortBooking'
 * Error Message
 */
class GetShortBookingErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetShortBookingErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetShortBookingErrorStructure (const GetShortBookingErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetShortBookingErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~GetShortBookingErrorStructure();

    /**
     * Assignment operator
     */
    inline GetShortBookingErrorStructure& operator = (const GetShortBookingErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetShortBookingErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetShortBookingErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetShortBookingErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetShortBookingErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const GetShortBookingErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'GetShortBooking'
 * Error Message
 */
class GetShortBookingError  : public ::asf::core::Payload {
public:

    enum GetShortBookingErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetShortBookingError ();

   /**
     * Copy constructor
     */
    inline  GetShortBookingError (const GetShortBookingError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetShortBookingError();

    /**
     * Assigns a new value to this object.
     */
    inline GetShortBookingError& operator = (const GetShortBookingError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetShortBookingError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetShortBookingError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetShortBookingError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetShortBookingError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetShortBookingError::GetShortBookingErrorField getField () const;

    inline void setField(GetShortBookingError::GetShortBookingErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetShortBookingErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetShortBookingErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetShortBookingErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetShortBookingErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetShortBookingErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetShortBookingErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetShortBookingErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetShortBookingErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetShortBookingError &getDefaultInstance();

private:

    inline void cloneData (const GetShortBookingError& rhs);

    inline void deleteData ();

    GetShortBookingErrorField __field;

    union {
        GetShortBookingErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "Short_BookingStatus"
 * Method Helps to book Charge spot
 */
class Short_BookingStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Short_BookingStatusStatus ();

    /**
     * Copy constructor
     */
    inline  Short_BookingStatusStatus (const Short_BookingStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  Short_BookingStatusStatus (::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter e8InvalidParameter_, ::tcu_main_fi_types::T_e8_TCU_Booking_Status e8Booking_Status_);

    /**
     * Destructor
     */
    inline virtual  ~Short_BookingStatusStatus();

    /**
     * Assignment operator
     */
    inline Short_BookingStatusStatus& operator = (const Short_BookingStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Short_BookingStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Short_BookingStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Short_BookingStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Short_BookingStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8InvalidParameter"

    static const int kE8InvalidParameter = 0;

    /**
     * Clears the field "e8InvalidParameter".
     *
     * The field will be set to its default value. The hasE8InvalidParameter()
     * method will return false.
     */
    inline void clearE8InvalidParameter();

    /**
     * Checks whether the field "e8InvalidParameter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8InvalidParameter()). Otherwise it will return false.
     */
    inline bool hasE8InvalidParameter () const;

    /**
     * Returns the value of the member "e8InvalidParameter".
     *
     * If the meaning of "e8InvalidParameter" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8InvalidParameter"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter getE8InvalidParameter () const;

    /**
     * Sets the value of the member "e8InvalidParameter".
     *
     * If the meaning of "e8InvalidParameter" isn't clear, then there should be a description here.
     *
     * @param e8InvalidParameter The value which will be set
     */
    inline void setE8InvalidParameter (::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter e8InvalidParameter_);

    // API of field "e8Booking_Status"

    static const int kE8Booking_Status = 1;

    /**
     * Clears the field "e8Booking_Status".
     *
     * The field will be set to its default value. The hasE8Booking_Status()
     * method will return false.
     */
    inline void clearE8Booking_Status();

    /**
     * Checks whether the field "e8Booking_Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Booking_Status()). Otherwise it will return false.
     */
    inline bool hasE8Booking_Status () const;

    /**
     * Returns the value of the member "e8Booking_Status".
     *
     * If the meaning of "e8Booking_Status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Booking_Status"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_Booking_Status getE8Booking_Status () const;

    /**
     * Sets the value of the member "e8Booking_Status".
     *
     * If the meaning of "e8Booking_Status" isn't clear, then there should be a description here.
     *
     * @param e8Booking_Status The value which will be set
     */
    inline void setE8Booking_Status (::tcu_main_fi_types::T_e8_TCU_Booking_Status e8Booking_Status_);

    static const Short_BookingStatusStatus &getDefaultInstance();

private:

    inline void set_has_e8InvalidParameter ();

    inline void clear_has_e8InvalidParameter ();

    inline void set_has_e8Booking_Status ();

    inline void clear_has_e8Booking_Status ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter _e8InvalidParameter;

    ::tcu_main_fi_types::T_e8_TCU_Booking_Status _e8Booking_Status;

};

/**
 * The status message of the property "Short_BookingIndication"
 * Property updates about Booking status of charge spot
 */
class Short_BookingIndicationStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Short_BookingIndicationStatus ();

    /**
     * Copy constructor
     */
    inline  Short_BookingIndicationStatus (const Short_BookingIndicationStatus &rhs);

    /**
     * All fields constructor
     */
    inline  Short_BookingIndicationStatus (::tcu_main_fi_types::T_e8_TCU_Booking_Status e8Booking_Status_, const ::std::string& sCharge_Station_ID_, const ::std::string& sCharge_Spot_ID_, ::tcu_main_fi_types::T_e8_TCU_Charge_Receptacle_Type e8Charge_Receptacle_Type_, ::tcu_main_fi_types::T_e8_TCU_Charge_Receptacle_Facility e8Charge_Receptacle_Facility_Byte_, const ::tcu_main_fi_types::T_TCU_Time& rMax_Time_To_Arrive_, const ::tcu_main_fi_types::T_TCU_Time& rMax_Time_To_Unbook_, const ::std::string& sBooking_ID_, const ::tcu_main_fi_types::T_TCU_Bookable_Free_Text& rBookable_Free_Text_, const ::tcu_main_fi_types::T_TCU_Time_Stamp& rTime_Stamp_);

    /**
     * Destructor
     */
    inline virtual  ~Short_BookingIndicationStatus();

    /**
     * Assignment operator
     */
    inline Short_BookingIndicationStatus& operator = (const Short_BookingIndicationStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Short_BookingIndicationStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Short_BookingIndicationStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Short_BookingIndicationStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Short_BookingIndicationStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Booking_Status"

    static const int kE8Booking_Status = 0;

    /**
     * Clears the field "e8Booking_Status".
     *
     * The field will be set to its default value. The hasE8Booking_Status()
     * method will return false.
     */
    inline void clearE8Booking_Status();

    /**
     * Checks whether the field "e8Booking_Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Booking_Status()). Otherwise it will return false.
     */
    inline bool hasE8Booking_Status () const;

    /**
     * Returns the value of the member "e8Booking_Status".
     *
     * If the meaning of "e8Booking_Status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Booking_Status"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_Booking_Status getE8Booking_Status () const;

    /**
     * Sets the value of the member "e8Booking_Status".
     *
     * If the meaning of "e8Booking_Status" isn't clear, then there should be a description here.
     *
     * @param e8Booking_Status The value which will be set
     */
    inline void setE8Booking_Status (::tcu_main_fi_types::T_e8_TCU_Booking_Status e8Booking_Status_);

    // API of field "sCharge_Station_ID"

    static const int kSCharge_Station_ID = 1;

    /**
     * Clears the field "sCharge_Station_ID".
     *
     * The field will be set to its default value. The hasSCharge_Station_ID()
     * method will return false.
     */
    inline void clearSCharge_Station_ID();

    /**
     * Checks whether the field "sCharge_Station_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSCharge_Station_ID()). Otherwise it will return false.
     */
    inline bool hasSCharge_Station_ID () const;

    /**
     * Returns the value of the member "sCharge_Station_ID".
     *
     * If the meaning of "sCharge_Station_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sCharge_Station_ID"
     */
    inline const ::std::string& getSCharge_Station_ID () const;

    /**
     * Retrieves the value of the field "sCharge_Station_ID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sCharge_Station_ID".
     */
    inline ::std::string& getSCharge_Station_IDMutable ();

    /**
     * Sets the value of the member "sCharge_Station_ID".
     *
     * If the meaning of "sCharge_Station_ID" isn't clear, then there should be a description here.
     *
     * @param sCharge_Station_ID The value which will be set
     */
    inline void setSCharge_Station_ID (const ::std::string& sCharge_Station_ID_);

    /**
     * Sets the value of the member "sCharge_Station_ID".
     *
     * If the meaning of "sCharge_Station_ID" isn't clear, then there should be a description here.
     *
     * @param sCharge_Station_ID The value which will be set
     */
    inline void setSCharge_Station_ID (const char* sCharge_Station_ID_);

    /**
     * Sets the value of the member "sCharge_Station_ID".
     *
     * If the meaning of "sCharge_Station_ID" isn't clear, then there should be a description here.
     *
     * @param sCharge_Station_ID The value which will be set
     */
    inline void setSCharge_Station_ID (const char* value, size_t size);

    // API of field "sCharge_Spot_ID"

    static const int kSCharge_Spot_ID = 2;

    /**
     * Clears the field "sCharge_Spot_ID".
     *
     * The field will be set to its default value. The hasSCharge_Spot_ID()
     * method will return false.
     */
    inline void clearSCharge_Spot_ID();

    /**
     * Checks whether the field "sCharge_Spot_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSCharge_Spot_ID()). Otherwise it will return false.
     */
    inline bool hasSCharge_Spot_ID () const;

    /**
     * Returns the value of the member "sCharge_Spot_ID".
     *
     * If the meaning of "sCharge_Spot_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sCharge_Spot_ID"
     */
    inline const ::std::string& getSCharge_Spot_ID () const;

    /**
     * Retrieves the value of the field "sCharge_Spot_ID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sCharge_Spot_ID".
     */
    inline ::std::string& getSCharge_Spot_IDMutable ();

    /**
     * Sets the value of the member "sCharge_Spot_ID".
     *
     * If the meaning of "sCharge_Spot_ID" isn't clear, then there should be a description here.
     *
     * @param sCharge_Spot_ID The value which will be set
     */
    inline void setSCharge_Spot_ID (const ::std::string& sCharge_Spot_ID_);

    /**
     * Sets the value of the member "sCharge_Spot_ID".
     *
     * If the meaning of "sCharge_Spot_ID" isn't clear, then there should be a description here.
     *
     * @param sCharge_Spot_ID The value which will be set
     */
    inline void setSCharge_Spot_ID (const char* sCharge_Spot_ID_);

    /**
     * Sets the value of the member "sCharge_Spot_ID".
     *
     * If the meaning of "sCharge_Spot_ID" isn't clear, then there should be a description here.
     *
     * @param sCharge_Spot_ID The value which will be set
     */
    inline void setSCharge_Spot_ID (const char* value, size_t size);

    // API of field "e8Charge_Receptacle_Type"

    static const int kE8Charge_Receptacle_Type = 3;

    /**
     * Clears the field "e8Charge_Receptacle_Type".
     *
     * The field will be set to its default value. The hasE8Charge_Receptacle_Type()
     * method will return false.
     */
    inline void clearE8Charge_Receptacle_Type();

    /**
     * Checks whether the field "e8Charge_Receptacle_Type" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Charge_Receptacle_Type()). Otherwise it will return false.
     */
    inline bool hasE8Charge_Receptacle_Type () const;

    /**
     * Returns the value of the member "e8Charge_Receptacle_Type".
     *
     * If the meaning of "e8Charge_Receptacle_Type" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Charge_Receptacle_Type"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_Charge_Receptacle_Type getE8Charge_Receptacle_Type () const;

    /**
     * Sets the value of the member "e8Charge_Receptacle_Type".
     *
     * If the meaning of "e8Charge_Receptacle_Type" isn't clear, then there should be a description here.
     *
     * @param e8Charge_Receptacle_Type The value which will be set
     */
    inline void setE8Charge_Receptacle_Type (::tcu_main_fi_types::T_e8_TCU_Charge_Receptacle_Type e8Charge_Receptacle_Type_);

    // API of field "e8Charge_Receptacle_Facility_Byte"

    static const int kE8Charge_Receptacle_Facility_Byte = 4;

    /**
     * Clears the field "e8Charge_Receptacle_Facility_Byte".
     *
     * The field will be set to its default value. The hasE8Charge_Receptacle_Facility_Byte()
     * method will return false.
     */
    inline void clearE8Charge_Receptacle_Facility_Byte();

    /**
     * Checks whether the field "e8Charge_Receptacle_Facility_Byte" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Charge_Receptacle_Facility_Byte()). Otherwise it will return false.
     */
    inline bool hasE8Charge_Receptacle_Facility_Byte () const;

    /**
     * Returns the value of the member "e8Charge_Receptacle_Facility_Byte".
     *
     * If the meaning of "e8Charge_Receptacle_Facility_Byte" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Charge_Receptacle_Facility_Byte"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_Charge_Receptacle_Facility getE8Charge_Receptacle_Facility_Byte () const;

    /**
     * Sets the value of the member "e8Charge_Receptacle_Facility_Byte".
     *
     * If the meaning of "e8Charge_Receptacle_Facility_Byte" isn't clear, then there should be a description here.
     *
     * @param e8Charge_Receptacle_Facility_Byte The value which will be set
     */
    inline void setE8Charge_Receptacle_Facility_Byte (::tcu_main_fi_types::T_e8_TCU_Charge_Receptacle_Facility e8Charge_Receptacle_Facility_Byte_);

    // API of field "rMax_Time_To_Arrive"

    static const int kRMax_Time_To_Arrive = 5;

    /**
     * Clears the field "rMax_Time_To_Arrive".
     *
     * The field will be set to its default value. The hasRMax_Time_To_Arrive()
     * method will return false.
     */
    inline void clearRMax_Time_To_Arrive();

    /**
     * Checks whether the field "rMax_Time_To_Arrive" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRMax_Time_To_Arrive()). Otherwise it will return false.
     */
    inline bool hasRMax_Time_To_Arrive () const;

    /**
     * Returns the value of the member "rMax_Time_To_Arrive".
     *
     * If the meaning of "rMax_Time_To_Arrive" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rMax_Time_To_Arrive"
     */
    inline const ::tcu_main_fi_types::T_TCU_Time& getRMax_Time_To_Arrive () const;

    /**
     * Retrieves the value of the field "rMax_Time_To_Arrive" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rMax_Time_To_Arrive".
     */
    inline ::tcu_main_fi_types::T_TCU_Time& getRMax_Time_To_ArriveMutable ();

    /**
     * Sets the value of the member "rMax_Time_To_Arrive".
     *
     * If the meaning of "rMax_Time_To_Arrive" isn't clear, then there should be a description here.
     *
     * @param rMax_Time_To_Arrive The value which will be set
     */
    inline void setRMax_Time_To_Arrive (const ::tcu_main_fi_types::T_TCU_Time& rMax_Time_To_Arrive_);

    // API of field "rMax_Time_To_Unbook"

    static const int kRMax_Time_To_Unbook = 6;

    /**
     * Clears the field "rMax_Time_To_Unbook".
     *
     * The field will be set to its default value. The hasRMax_Time_To_Unbook()
     * method will return false.
     */
    inline void clearRMax_Time_To_Unbook();

    /**
     * Checks whether the field "rMax_Time_To_Unbook" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRMax_Time_To_Unbook()). Otherwise it will return false.
     */
    inline bool hasRMax_Time_To_Unbook () const;

    /**
     * Returns the value of the member "rMax_Time_To_Unbook".
     *
     * If the meaning of "rMax_Time_To_Unbook" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rMax_Time_To_Unbook"
     */
    inline const ::tcu_main_fi_types::T_TCU_Time& getRMax_Time_To_Unbook () const;

    /**
     * Retrieves the value of the field "rMax_Time_To_Unbook" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rMax_Time_To_Unbook".
     */
    inline ::tcu_main_fi_types::T_TCU_Time& getRMax_Time_To_UnbookMutable ();

    /**
     * Sets the value of the member "rMax_Time_To_Unbook".
     *
     * If the meaning of "rMax_Time_To_Unbook" isn't clear, then there should be a description here.
     *
     * @param rMax_Time_To_Unbook The value which will be set
     */
    inline void setRMax_Time_To_Unbook (const ::tcu_main_fi_types::T_TCU_Time& rMax_Time_To_Unbook_);

    // API of field "sBooking_ID"

    static const int kSBooking_ID = 7;

    /**
     * Clears the field "sBooking_ID".
     *
     * The field will be set to its default value. The hasSBooking_ID()
     * method will return false.
     */
    inline void clearSBooking_ID();

    /**
     * Checks whether the field "sBooking_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSBooking_ID()). Otherwise it will return false.
     */
    inline bool hasSBooking_ID () const;

    /**
     * Returns the value of the member "sBooking_ID".
     *
     * If the meaning of "sBooking_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sBooking_ID"
     */
    inline const ::std::string& getSBooking_ID () const;

    /**
     * Retrieves the value of the field "sBooking_ID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sBooking_ID".
     */
    inline ::std::string& getSBooking_IDMutable ();

    /**
     * Sets the value of the member "sBooking_ID".
     *
     * If the meaning of "sBooking_ID" isn't clear, then there should be a description here.
     *
     * @param sBooking_ID The value which will be set
     */
    inline void setSBooking_ID (const ::std::string& sBooking_ID_);

    /**
     * Sets the value of the member "sBooking_ID".
     *
     * If the meaning of "sBooking_ID" isn't clear, then there should be a description here.
     *
     * @param sBooking_ID The value which will be set
     */
    inline void setSBooking_ID (const char* sBooking_ID_);

    /**
     * Sets the value of the member "sBooking_ID".
     *
     * If the meaning of "sBooking_ID" isn't clear, then there should be a description here.
     *
     * @param sBooking_ID The value which will be set
     */
    inline void setSBooking_ID (const char* value, size_t size);

    // API of field "rBookable_Free_Text"

    static const int kRBookable_Free_Text = 8;

    /**
     * Clears the field "rBookable_Free_Text".
     *
     * The field will be set to its default value. The hasRBookable_Free_Text()
     * method will return false.
     */
    inline void clearRBookable_Free_Text();

    /**
     * Checks whether the field "rBookable_Free_Text" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRBookable_Free_Text()). Otherwise it will return false.
     */
    inline bool hasRBookable_Free_Text () const;

    /**
     * Returns the value of the member "rBookable_Free_Text".
     *
     * If the meaning of "rBookable_Free_Text" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rBookable_Free_Text"
     */
    inline const ::tcu_main_fi_types::T_TCU_Bookable_Free_Text& getRBookable_Free_Text () const;

    /**
     * Retrieves the value of the field "rBookable_Free_Text" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rBookable_Free_Text".
     */
    inline ::tcu_main_fi_types::T_TCU_Bookable_Free_Text& getRBookable_Free_TextMutable ();

    /**
     * Sets the value of the member "rBookable_Free_Text".
     *
     * If the meaning of "rBookable_Free_Text" isn't clear, then there should be a description here.
     *
     * @param rBookable_Free_Text The value which will be set
     */
    inline void setRBookable_Free_Text (const ::tcu_main_fi_types::T_TCU_Bookable_Free_Text& rBookable_Free_Text_);

    // API of field "rTime_Stamp"

    static const int kRTime_Stamp = 9;

    /**
     * Clears the field "rTime_Stamp".
     *
     * The field will be set to its default value. The hasRTime_Stamp()
     * method will return false.
     */
    inline void clearRTime_Stamp();

    /**
     * Checks whether the field "rTime_Stamp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRTime_Stamp()). Otherwise it will return false.
     */
    inline bool hasRTime_Stamp () const;

    /**
     * Returns the value of the member "rTime_Stamp".
     *
     * If the meaning of "rTime_Stamp" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rTime_Stamp"
     */
    inline const ::tcu_main_fi_types::T_TCU_Time_Stamp& getRTime_Stamp () const;

    /**
     * Retrieves the value of the field "rTime_Stamp" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rTime_Stamp".
     */
    inline ::tcu_main_fi_types::T_TCU_Time_Stamp& getRTime_StampMutable ();

    /**
     * Sets the value of the member "rTime_Stamp".
     *
     * If the meaning of "rTime_Stamp" isn't clear, then there should be a description here.
     *
     * @param rTime_Stamp The value which will be set
     */
    inline void setRTime_Stamp (const ::tcu_main_fi_types::T_TCU_Time_Stamp& rTime_Stamp_);

    static const Short_BookingIndicationStatus &getDefaultInstance();

private:

    inline void set_has_e8Booking_Status ();

    inline void clear_has_e8Booking_Status ();

    inline void set_has_sCharge_Station_ID ();

    inline void clear_has_sCharge_Station_ID ();

    inline void set_has_sCharge_Spot_ID ();

    inline void clear_has_sCharge_Spot_ID ();

    inline void set_has_e8Charge_Receptacle_Type ();

    inline void clear_has_e8Charge_Receptacle_Type ();

    inline void set_has_e8Charge_Receptacle_Facility_Byte ();

    inline void clear_has_e8Charge_Receptacle_Facility_Byte ();

    inline void set_has_rMax_Time_To_Arrive ();

    inline void clear_has_rMax_Time_To_Arrive ();

    inline void set_has_rMax_Time_To_Unbook ();

    inline void clear_has_rMax_Time_To_Unbook ();

    inline void set_has_sBooking_ID ();

    inline void clear_has_sBooking_ID ();

    inline void set_has_rBookable_Free_Text ();

    inline void clear_has_rBookable_Free_Text ();

    inline void set_has_rTime_Stamp ();

    inline void clear_has_rTime_Stamp ();

    uint32 _has_bits_[ (10 + 31) / 32];

    ::tcu_main_fi_types::T_e8_TCU_Booking_Status _e8Booking_Status;

    ::std::string _sCharge_Station_ID;

    ::std::string _sCharge_Spot_ID;

    ::tcu_main_fi_types::T_e8_TCU_Charge_Receptacle_Type _e8Charge_Receptacle_Type;

    ::tcu_main_fi_types::T_e8_TCU_Charge_Receptacle_Facility _e8Charge_Receptacle_Facility_Byte;

    ::tcu_main_fi_types::T_TCU_Time _rMax_Time_To_Arrive;

    ::tcu_main_fi_types::T_TCU_Time _rMax_Time_To_Unbook;

    ::std::string _sBooking_ID;

    ::tcu_main_fi_types::T_TCU_Bookable_Free_Text _rBookable_Free_Text;

    ::tcu_main_fi_types::T_TCU_Time_Stamp _rTime_Stamp;

};

/**
 * The start message of the method "GetShortUnbooking"
 * Method Helps to Cancel the booked Charge spot
 */
class GetShortUnbookingStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetShortUnbookingStart ();

    /**
     * Copy constructor
     */
    inline  GetShortUnbookingStart (const GetShortUnbookingStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetShortUnbookingStart (const ::std::string& sCustomer_Contract_ID_, const ::std::string& sUtility_Aggregator_ID_, const ::std::string& sCurrent_Country_, const ::std::string& sCharge_Spot_ID_, const ::std::string& sCharge_Station_ID_, const ::std::string& sBooking_ID_);

    /**
     * Destructor
     */
    inline virtual  ~GetShortUnbookingStart();

    /**
     * Assignment operator
     */
    inline GetShortUnbookingStart& operator = (const GetShortUnbookingStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetShortUnbookingStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetShortUnbookingStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetShortUnbookingStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetShortUnbookingStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sCustomer_Contract_ID"

    static const int kSCustomer_Contract_ID = 0;

    /**
     * Clears the field "sCustomer_Contract_ID".
     *
     * The field will be set to its default value. The hasSCustomer_Contract_ID()
     * method will return false.
     */
    inline void clearSCustomer_Contract_ID();

    /**
     * Checks whether the field "sCustomer_Contract_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSCustomer_Contract_ID()). Otherwise it will return false.
     */
    inline bool hasSCustomer_Contract_ID () const;

    /**
     * Returns the value of the member "sCustomer_Contract_ID".
     *
     * If the meaning of "sCustomer_Contract_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sCustomer_Contract_ID"
     */
    inline const ::std::string& getSCustomer_Contract_ID () const;

    /**
     * Retrieves the value of the field "sCustomer_Contract_ID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sCustomer_Contract_ID".
     */
    inline ::std::string& getSCustomer_Contract_IDMutable ();

    /**
     * Sets the value of the member "sCustomer_Contract_ID".
     *
     * If the meaning of "sCustomer_Contract_ID" isn't clear, then there should be a description here.
     *
     * @param sCustomer_Contract_ID The value which will be set
     */
    inline void setSCustomer_Contract_ID (const ::std::string& sCustomer_Contract_ID_);

    /**
     * Sets the value of the member "sCustomer_Contract_ID".
     *
     * If the meaning of "sCustomer_Contract_ID" isn't clear, then there should be a description here.
     *
     * @param sCustomer_Contract_ID The value which will be set
     */
    inline void setSCustomer_Contract_ID (const char* sCustomer_Contract_ID_);

    /**
     * Sets the value of the member "sCustomer_Contract_ID".
     *
     * If the meaning of "sCustomer_Contract_ID" isn't clear, then there should be a description here.
     *
     * @param sCustomer_Contract_ID The value which will be set
     */
    inline void setSCustomer_Contract_ID (const char* value, size_t size);

    // API of field "sUtility_Aggregator_ID"

    static const int kSUtility_Aggregator_ID = 1;

    /**
     * Clears the field "sUtility_Aggregator_ID".
     *
     * The field will be set to its default value. The hasSUtility_Aggregator_ID()
     * method will return false.
     */
    inline void clearSUtility_Aggregator_ID();

    /**
     * Checks whether the field "sUtility_Aggregator_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSUtility_Aggregator_ID()). Otherwise it will return false.
     */
    inline bool hasSUtility_Aggregator_ID () const;

    /**
     * Returns the value of the member "sUtility_Aggregator_ID".
     *
     * If the meaning of "sUtility_Aggregator_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sUtility_Aggregator_ID"
     */
    inline const ::std::string& getSUtility_Aggregator_ID () const;

    /**
     * Retrieves the value of the field "sUtility_Aggregator_ID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sUtility_Aggregator_ID".
     */
    inline ::std::string& getSUtility_Aggregator_IDMutable ();

    /**
     * Sets the value of the member "sUtility_Aggregator_ID".
     *
     * If the meaning of "sUtility_Aggregator_ID" isn't clear, then there should be a description here.
     *
     * @param sUtility_Aggregator_ID The value which will be set
     */
    inline void setSUtility_Aggregator_ID (const ::std::string& sUtility_Aggregator_ID_);

    /**
     * Sets the value of the member "sUtility_Aggregator_ID".
     *
     * If the meaning of "sUtility_Aggregator_ID" isn't clear, then there should be a description here.
     *
     * @param sUtility_Aggregator_ID The value which will be set
     */
    inline void setSUtility_Aggregator_ID (const char* sUtility_Aggregator_ID_);

    /**
     * Sets the value of the member "sUtility_Aggregator_ID".
     *
     * If the meaning of "sUtility_Aggregator_ID" isn't clear, then there should be a description here.
     *
     * @param sUtility_Aggregator_ID The value which will be set
     */
    inline void setSUtility_Aggregator_ID (const char* value, size_t size);

    // API of field "sCurrent_Country"

    static const int kSCurrent_Country = 2;

    /**
     * Clears the field "sCurrent_Country".
     *
     * The field will be set to its default value. The hasSCurrent_Country()
     * method will return false.
     */
    inline void clearSCurrent_Country();

    /**
     * Checks whether the field "sCurrent_Country" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSCurrent_Country()). Otherwise it will return false.
     */
    inline bool hasSCurrent_Country () const;

    /**
     * Returns the value of the member "sCurrent_Country".
     *
     * If the meaning of "sCurrent_Country" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sCurrent_Country"
     */
    inline const ::std::string& getSCurrent_Country () const;

    /**
     * Retrieves the value of the field "sCurrent_Country" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sCurrent_Country".
     */
    inline ::std::string& getSCurrent_CountryMutable ();

    /**
     * Sets the value of the member "sCurrent_Country".
     *
     * If the meaning of "sCurrent_Country" isn't clear, then there should be a description here.
     *
     * @param sCurrent_Country The value which will be set
     */
    inline void setSCurrent_Country (const ::std::string& sCurrent_Country_);

    /**
     * Sets the value of the member "sCurrent_Country".
     *
     * If the meaning of "sCurrent_Country" isn't clear, then there should be a description here.
     *
     * @param sCurrent_Country The value which will be set
     */
    inline void setSCurrent_Country (const char* sCurrent_Country_);

    /**
     * Sets the value of the member "sCurrent_Country".
     *
     * If the meaning of "sCurrent_Country" isn't clear, then there should be a description here.
     *
     * @param sCurrent_Country The value which will be set
     */
    inline void setSCurrent_Country (const char* value, size_t size);

    // API of field "sCharge_Spot_ID"

    static const int kSCharge_Spot_ID = 3;

    /**
     * Clears the field "sCharge_Spot_ID".
     *
     * The field will be set to its default value. The hasSCharge_Spot_ID()
     * method will return false.
     */
    inline void clearSCharge_Spot_ID();

    /**
     * Checks whether the field "sCharge_Spot_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSCharge_Spot_ID()). Otherwise it will return false.
     */
    inline bool hasSCharge_Spot_ID () const;

    /**
     * Returns the value of the member "sCharge_Spot_ID".
     *
     * If the meaning of "sCharge_Spot_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sCharge_Spot_ID"
     */
    inline const ::std::string& getSCharge_Spot_ID () const;

    /**
     * Retrieves the value of the field "sCharge_Spot_ID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sCharge_Spot_ID".
     */
    inline ::std::string& getSCharge_Spot_IDMutable ();

    /**
     * Sets the value of the member "sCharge_Spot_ID".
     *
     * If the meaning of "sCharge_Spot_ID" isn't clear, then there should be a description here.
     *
     * @param sCharge_Spot_ID The value which will be set
     */
    inline void setSCharge_Spot_ID (const ::std::string& sCharge_Spot_ID_);

    /**
     * Sets the value of the member "sCharge_Spot_ID".
     *
     * If the meaning of "sCharge_Spot_ID" isn't clear, then there should be a description here.
     *
     * @param sCharge_Spot_ID The value which will be set
     */
    inline void setSCharge_Spot_ID (const char* sCharge_Spot_ID_);

    /**
     * Sets the value of the member "sCharge_Spot_ID".
     *
     * If the meaning of "sCharge_Spot_ID" isn't clear, then there should be a description here.
     *
     * @param sCharge_Spot_ID The value which will be set
     */
    inline void setSCharge_Spot_ID (const char* value, size_t size);

    // API of field "sCharge_Station_ID"

    static const int kSCharge_Station_ID = 4;

    /**
     * Clears the field "sCharge_Station_ID".
     *
     * The field will be set to its default value. The hasSCharge_Station_ID()
     * method will return false.
     */
    inline void clearSCharge_Station_ID();

    /**
     * Checks whether the field "sCharge_Station_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSCharge_Station_ID()). Otherwise it will return false.
     */
    inline bool hasSCharge_Station_ID () const;

    /**
     * Returns the value of the member "sCharge_Station_ID".
     *
     * If the meaning of "sCharge_Station_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sCharge_Station_ID"
     */
    inline const ::std::string& getSCharge_Station_ID () const;

    /**
     * Retrieves the value of the field "sCharge_Station_ID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sCharge_Station_ID".
     */
    inline ::std::string& getSCharge_Station_IDMutable ();

    /**
     * Sets the value of the member "sCharge_Station_ID".
     *
     * If the meaning of "sCharge_Station_ID" isn't clear, then there should be a description here.
     *
     * @param sCharge_Station_ID The value which will be set
     */
    inline void setSCharge_Station_ID (const ::std::string& sCharge_Station_ID_);

    /**
     * Sets the value of the member "sCharge_Station_ID".
     *
     * If the meaning of "sCharge_Station_ID" isn't clear, then there should be a description here.
     *
     * @param sCharge_Station_ID The value which will be set
     */
    inline void setSCharge_Station_ID (const char* sCharge_Station_ID_);

    /**
     * Sets the value of the member "sCharge_Station_ID".
     *
     * If the meaning of "sCharge_Station_ID" isn't clear, then there should be a description here.
     *
     * @param sCharge_Station_ID The value which will be set
     */
    inline void setSCharge_Station_ID (const char* value, size_t size);

    // API of field "sBooking_ID"

    static const int kSBooking_ID = 5;

    /**
     * Clears the field "sBooking_ID".
     *
     * The field will be set to its default value. The hasSBooking_ID()
     * method will return false.
     */
    inline void clearSBooking_ID();

    /**
     * Checks whether the field "sBooking_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSBooking_ID()). Otherwise it will return false.
     */
    inline bool hasSBooking_ID () const;

    /**
     * Returns the value of the member "sBooking_ID".
     *
     * If the meaning of "sBooking_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sBooking_ID"
     */
    inline const ::std::string& getSBooking_ID () const;

    /**
     * Retrieves the value of the field "sBooking_ID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sBooking_ID".
     */
    inline ::std::string& getSBooking_IDMutable ();

    /**
     * Sets the value of the member "sBooking_ID".
     *
     * If the meaning of "sBooking_ID" isn't clear, then there should be a description here.
     *
     * @param sBooking_ID The value which will be set
     */
    inline void setSBooking_ID (const ::std::string& sBooking_ID_);

    /**
     * Sets the value of the member "sBooking_ID".
     *
     * If the meaning of "sBooking_ID" isn't clear, then there should be a description here.
     *
     * @param sBooking_ID The value which will be set
     */
    inline void setSBooking_ID (const char* sBooking_ID_);

    /**
     * Sets the value of the member "sBooking_ID".
     *
     * If the meaning of "sBooking_ID" isn't clear, then there should be a description here.
     *
     * @param sBooking_ID The value which will be set
     */
    inline void setSBooking_ID (const char* value, size_t size);

    static const GetShortUnbookingStart &getDefaultInstance();

private:

    inline void set_has_sCustomer_Contract_ID ();

    inline void clear_has_sCustomer_Contract_ID ();

    inline void set_has_sUtility_Aggregator_ID ();

    inline void clear_has_sUtility_Aggregator_ID ();

    inline void set_has_sCurrent_Country ();

    inline void clear_has_sCurrent_Country ();

    inline void set_has_sCharge_Spot_ID ();

    inline void clear_has_sCharge_Spot_ID ();

    inline void set_has_sCharge_Station_ID ();

    inline void clear_has_sCharge_Station_ID ();

    inline void set_has_sBooking_ID ();

    inline void clear_has_sBooking_ID ();

    uint32 _has_bits_[ (6 + 31) / 32];

    ::std::string _sCustomer_Contract_ID;

    ::std::string _sUtility_Aggregator_ID;

    ::std::string _sCurrent_Country;

    ::std::string _sCharge_Spot_ID;

    ::std::string _sCharge_Station_ID;

    ::std::string _sBooking_ID;

};

/**
 * The error message of 'GetShortUnbooking'
 * Error Message
 */
class GetShortUnbookingErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetShortUnbookingErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetShortUnbookingErrorStructure (const GetShortUnbookingErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetShortUnbookingErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~GetShortUnbookingErrorStructure();

    /**
     * Assignment operator
     */
    inline GetShortUnbookingErrorStructure& operator = (const GetShortUnbookingErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetShortUnbookingErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetShortUnbookingErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetShortUnbookingErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetShortUnbookingErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const GetShortUnbookingErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'GetShortUnbooking'
 * Error Message
 */
class GetShortUnbookingError  : public ::asf::core::Payload {
public:

    enum GetShortUnbookingErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetShortUnbookingError ();

   /**
     * Copy constructor
     */
    inline  GetShortUnbookingError (const GetShortUnbookingError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetShortUnbookingError();

    /**
     * Assigns a new value to this object.
     */
    inline GetShortUnbookingError& operator = (const GetShortUnbookingError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetShortUnbookingError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetShortUnbookingError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetShortUnbookingError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetShortUnbookingError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetShortUnbookingError::GetShortUnbookingErrorField getField () const;

    inline void setField(GetShortUnbookingError::GetShortUnbookingErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetShortUnbookingErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetShortUnbookingErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetShortUnbookingErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetShortUnbookingErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetShortUnbookingErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetShortUnbookingErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetShortUnbookingErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetShortUnbookingErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetShortUnbookingError &getDefaultInstance();

private:

    inline void cloneData (const GetShortUnbookingError& rhs);

    inline void deleteData ();

    GetShortUnbookingErrorField __field;

    union {
        GetShortUnbookingErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "Short_UnbookingStatus"
 * Property updates about cancellation status of booked charge spot
 */
class Short_UnbookingStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Short_UnbookingStatusStatus ();

    /**
     * Copy constructor
     */
    inline  Short_UnbookingStatusStatus (const Short_UnbookingStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  Short_UnbookingStatusStatus (::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter e8InvalidParameter_, ::tcu_main_fi_types::T_e8_TCU_Unbooking_Status e8Unbooking_Status_);

    /**
     * Destructor
     */
    inline virtual  ~Short_UnbookingStatusStatus();

    /**
     * Assignment operator
     */
    inline Short_UnbookingStatusStatus& operator = (const Short_UnbookingStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Short_UnbookingStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Short_UnbookingStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Short_UnbookingStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Short_UnbookingStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8InvalidParameter"

    static const int kE8InvalidParameter = 0;

    /**
     * Clears the field "e8InvalidParameter".
     *
     * The field will be set to its default value. The hasE8InvalidParameter()
     * method will return false.
     */
    inline void clearE8InvalidParameter();

    /**
     * Checks whether the field "e8InvalidParameter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8InvalidParameter()). Otherwise it will return false.
     */
    inline bool hasE8InvalidParameter () const;

    /**
     * Returns the value of the member "e8InvalidParameter".
     *
     * If the meaning of "e8InvalidParameter" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8InvalidParameter"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter getE8InvalidParameter () const;

    /**
     * Sets the value of the member "e8InvalidParameter".
     *
     * If the meaning of "e8InvalidParameter" isn't clear, then there should be a description here.
     *
     * @param e8InvalidParameter The value which will be set
     */
    inline void setE8InvalidParameter (::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter e8InvalidParameter_);

    // API of field "e8Unbooking_Status"

    static const int kE8Unbooking_Status = 1;

    /**
     * Clears the field "e8Unbooking_Status".
     *
     * The field will be set to its default value. The hasE8Unbooking_Status()
     * method will return false.
     */
    inline void clearE8Unbooking_Status();

    /**
     * Checks whether the field "e8Unbooking_Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Unbooking_Status()). Otherwise it will return false.
     */
    inline bool hasE8Unbooking_Status () const;

    /**
     * Returns the value of the member "e8Unbooking_Status".
     *
     * If the meaning of "e8Unbooking_Status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Unbooking_Status"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_Unbooking_Status getE8Unbooking_Status () const;

    /**
     * Sets the value of the member "e8Unbooking_Status".
     *
     * If the meaning of "e8Unbooking_Status" isn't clear, then there should be a description here.
     *
     * @param e8Unbooking_Status The value which will be set
     */
    inline void setE8Unbooking_Status (::tcu_main_fi_types::T_e8_TCU_Unbooking_Status e8Unbooking_Status_);

    static const Short_UnbookingStatusStatus &getDefaultInstance();

private:

    inline void set_has_e8InvalidParameter ();

    inline void clear_has_e8InvalidParameter ();

    inline void set_has_e8Unbooking_Status ();

    inline void clear_has_e8Unbooking_Status ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter _e8InvalidParameter;

    ::tcu_main_fi_types::T_e8_TCU_Unbooking_Status _e8Unbooking_Status;

};

/**
 * The status message of the property "Short_UnbookingIndication"
 * Property updates about cancellation of booked charge spot
 */
class Short_UnbookingIndicationStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Short_UnbookingIndicationStatus ();

    /**
     * Copy constructor
     */
    inline  Short_UnbookingIndicationStatus (const Short_UnbookingIndicationStatus &rhs);

    /**
     * All fields constructor
     */
    inline  Short_UnbookingIndicationStatus (const ::std::string& sCharge_Station_ID_, const ::std::string& sCharge_Spot_ID_, const ::std::string& sBooking_ID_, ::tcu_main_fi_types::T_e8_TCU_Unbooking_Status e8Unbooking_Status_);

    /**
     * Destructor
     */
    inline virtual  ~Short_UnbookingIndicationStatus();

    /**
     * Assignment operator
     */
    inline Short_UnbookingIndicationStatus& operator = (const Short_UnbookingIndicationStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Short_UnbookingIndicationStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Short_UnbookingIndicationStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Short_UnbookingIndicationStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Short_UnbookingIndicationStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sCharge_Station_ID"

    static const int kSCharge_Station_ID = 0;

    /**
     * Clears the field "sCharge_Station_ID".
     *
     * The field will be set to its default value. The hasSCharge_Station_ID()
     * method will return false.
     */
    inline void clearSCharge_Station_ID();

    /**
     * Checks whether the field "sCharge_Station_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSCharge_Station_ID()). Otherwise it will return false.
     */
    inline bool hasSCharge_Station_ID () const;

    /**
     * Returns the value of the member "sCharge_Station_ID".
     *
     * If the meaning of "sCharge_Station_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sCharge_Station_ID"
     */
    inline const ::std::string& getSCharge_Station_ID () const;

    /**
     * Retrieves the value of the field "sCharge_Station_ID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sCharge_Station_ID".
     */
    inline ::std::string& getSCharge_Station_IDMutable ();

    /**
     * Sets the value of the member "sCharge_Station_ID".
     *
     * If the meaning of "sCharge_Station_ID" isn't clear, then there should be a description here.
     *
     * @param sCharge_Station_ID The value which will be set
     */
    inline void setSCharge_Station_ID (const ::std::string& sCharge_Station_ID_);

    /**
     * Sets the value of the member "sCharge_Station_ID".
     *
     * If the meaning of "sCharge_Station_ID" isn't clear, then there should be a description here.
     *
     * @param sCharge_Station_ID The value which will be set
     */
    inline void setSCharge_Station_ID (const char* sCharge_Station_ID_);

    /**
     * Sets the value of the member "sCharge_Station_ID".
     *
     * If the meaning of "sCharge_Station_ID" isn't clear, then there should be a description here.
     *
     * @param sCharge_Station_ID The value which will be set
     */
    inline void setSCharge_Station_ID (const char* value, size_t size);

    // API of field "sCharge_Spot_ID"

    static const int kSCharge_Spot_ID = 1;

    /**
     * Clears the field "sCharge_Spot_ID".
     *
     * The field will be set to its default value. The hasSCharge_Spot_ID()
     * method will return false.
     */
    inline void clearSCharge_Spot_ID();

    /**
     * Checks whether the field "sCharge_Spot_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSCharge_Spot_ID()). Otherwise it will return false.
     */
    inline bool hasSCharge_Spot_ID () const;

    /**
     * Returns the value of the member "sCharge_Spot_ID".
     *
     * If the meaning of "sCharge_Spot_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sCharge_Spot_ID"
     */
    inline const ::std::string& getSCharge_Spot_ID () const;

    /**
     * Retrieves the value of the field "sCharge_Spot_ID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sCharge_Spot_ID".
     */
    inline ::std::string& getSCharge_Spot_IDMutable ();

    /**
     * Sets the value of the member "sCharge_Spot_ID".
     *
     * If the meaning of "sCharge_Spot_ID" isn't clear, then there should be a description here.
     *
     * @param sCharge_Spot_ID The value which will be set
     */
    inline void setSCharge_Spot_ID (const ::std::string& sCharge_Spot_ID_);

    /**
     * Sets the value of the member "sCharge_Spot_ID".
     *
     * If the meaning of "sCharge_Spot_ID" isn't clear, then there should be a description here.
     *
     * @param sCharge_Spot_ID The value which will be set
     */
    inline void setSCharge_Spot_ID (const char* sCharge_Spot_ID_);

    /**
     * Sets the value of the member "sCharge_Spot_ID".
     *
     * If the meaning of "sCharge_Spot_ID" isn't clear, then there should be a description here.
     *
     * @param sCharge_Spot_ID The value which will be set
     */
    inline void setSCharge_Spot_ID (const char* value, size_t size);

    // API of field "sBooking_ID"

    static const int kSBooking_ID = 2;

    /**
     * Clears the field "sBooking_ID".
     *
     * The field will be set to its default value. The hasSBooking_ID()
     * method will return false.
     */
    inline void clearSBooking_ID();

    /**
     * Checks whether the field "sBooking_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSBooking_ID()). Otherwise it will return false.
     */
    inline bool hasSBooking_ID () const;

    /**
     * Returns the value of the member "sBooking_ID".
     *
     * If the meaning of "sBooking_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sBooking_ID"
     */
    inline const ::std::string& getSBooking_ID () const;

    /**
     * Retrieves the value of the field "sBooking_ID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sBooking_ID".
     */
    inline ::std::string& getSBooking_IDMutable ();

    /**
     * Sets the value of the member "sBooking_ID".
     *
     * If the meaning of "sBooking_ID" isn't clear, then there should be a description here.
     *
     * @param sBooking_ID The value which will be set
     */
    inline void setSBooking_ID (const ::std::string& sBooking_ID_);

    /**
     * Sets the value of the member "sBooking_ID".
     *
     * If the meaning of "sBooking_ID" isn't clear, then there should be a description here.
     *
     * @param sBooking_ID The value which will be set
     */
    inline void setSBooking_ID (const char* sBooking_ID_);

    /**
     * Sets the value of the member "sBooking_ID".
     *
     * If the meaning of "sBooking_ID" isn't clear, then there should be a description here.
     *
     * @param sBooking_ID The value which will be set
     */
    inline void setSBooking_ID (const char* value, size_t size);

    // API of field "e8Unbooking_Status"

    static const int kE8Unbooking_Status = 3;

    /**
     * Clears the field "e8Unbooking_Status".
     *
     * The field will be set to its default value. The hasE8Unbooking_Status()
     * method will return false.
     */
    inline void clearE8Unbooking_Status();

    /**
     * Checks whether the field "e8Unbooking_Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Unbooking_Status()). Otherwise it will return false.
     */
    inline bool hasE8Unbooking_Status () const;

    /**
     * Returns the value of the member "e8Unbooking_Status".
     *
     * If the meaning of "e8Unbooking_Status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Unbooking_Status"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_Unbooking_Status getE8Unbooking_Status () const;

    /**
     * Sets the value of the member "e8Unbooking_Status".
     *
     * If the meaning of "e8Unbooking_Status" isn't clear, then there should be a description here.
     *
     * @param e8Unbooking_Status The value which will be set
     */
    inline void setE8Unbooking_Status (::tcu_main_fi_types::T_e8_TCU_Unbooking_Status e8Unbooking_Status_);

    static const Short_UnbookingIndicationStatus &getDefaultInstance();

private:

    inline void set_has_sCharge_Station_ID ();

    inline void clear_has_sCharge_Station_ID ();

    inline void set_has_sCharge_Spot_ID ();

    inline void clear_has_sCharge_Spot_ID ();

    inline void set_has_sBooking_ID ();

    inline void clear_has_sBooking_ID ();

    inline void set_has_e8Unbooking_Status ();

    inline void clear_has_e8Unbooking_Status ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::string _sCharge_Station_ID;

    ::std::string _sCharge_Spot_ID;

    ::std::string _sBooking_ID;

    ::tcu_main_fi_types::T_e8_TCU_Unbooking_Status _e8Unbooking_Status;

};

/**
 * The start message of the method "GetUpdateEnergyPoint"
 * Requests Update of the Energy Points
 */
class GetUpdateEnergyPointStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetUpdateEnergyPointStart ();

    /**
     * Copy constructor
     */
    inline  GetUpdateEnergyPointStart (const GetUpdateEnergyPointStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetUpdateEnergyPointStart (const ::std::string& sCurrent_Country_, const ::tcu_main_fi_types::T_TCU_GPS_Position& rEPOI_GPS_Position_, const ::std::string& sCharge_Station_ID_, const ::std::string& sUtility_Aggregator_ID_, uint32 u32Battery_Identification_Number_, const ::tcu_main_fi_types::T_TCU_Navigation_Language& rNavigation_Language_, const ::std::string& sBooking_ID_);

    /**
     * Destructor
     */
    inline virtual  ~GetUpdateEnergyPointStart();

    /**
     * Assignment operator
     */
    inline GetUpdateEnergyPointStart& operator = (const GetUpdateEnergyPointStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetUpdateEnergyPointStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetUpdateEnergyPointStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetUpdateEnergyPointStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetUpdateEnergyPointStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sCurrent_Country"

    static const int kSCurrent_Country = 0;

    /**
     * Clears the field "sCurrent_Country".
     *
     * The field will be set to its default value. The hasSCurrent_Country()
     * method will return false.
     */
    inline void clearSCurrent_Country();

    /**
     * Checks whether the field "sCurrent_Country" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSCurrent_Country()). Otherwise it will return false.
     */
    inline bool hasSCurrent_Country () const;

    /**
     * Returns the value of the member "sCurrent_Country".
     *
     * If the meaning of "sCurrent_Country" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sCurrent_Country"
     */
    inline const ::std::string& getSCurrent_Country () const;

    /**
     * Retrieves the value of the field "sCurrent_Country" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sCurrent_Country".
     */
    inline ::std::string& getSCurrent_CountryMutable ();

    /**
     * Sets the value of the member "sCurrent_Country".
     *
     * If the meaning of "sCurrent_Country" isn't clear, then there should be a description here.
     *
     * @param sCurrent_Country The value which will be set
     */
    inline void setSCurrent_Country (const ::std::string& sCurrent_Country_);

    /**
     * Sets the value of the member "sCurrent_Country".
     *
     * If the meaning of "sCurrent_Country" isn't clear, then there should be a description here.
     *
     * @param sCurrent_Country The value which will be set
     */
    inline void setSCurrent_Country (const char* sCurrent_Country_);

    /**
     * Sets the value of the member "sCurrent_Country".
     *
     * If the meaning of "sCurrent_Country" isn't clear, then there should be a description here.
     *
     * @param sCurrent_Country The value which will be set
     */
    inline void setSCurrent_Country (const char* value, size_t size);

    // API of field "rEPOI_GPS_Position"

    static const int kREPOI_GPS_Position = 1;

    /**
     * Clears the field "rEPOI_GPS_Position".
     *
     * The field will be set to its default value. The hasREPOI_GPS_Position()
     * method will return false.
     */
    inline void clearREPOI_GPS_Position();

    /**
     * Checks whether the field "rEPOI_GPS_Position" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setREPOI_GPS_Position()). Otherwise it will return false.
     */
    inline bool hasREPOI_GPS_Position () const;

    /**
     * Returns the value of the member "rEPOI_GPS_Position".
     *
     * If the meaning of "rEPOI_GPS_Position" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rEPOI_GPS_Position"
     */
    inline const ::tcu_main_fi_types::T_TCU_GPS_Position& getREPOI_GPS_Position () const;

    /**
     * Retrieves the value of the field "rEPOI_GPS_Position" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rEPOI_GPS_Position".
     */
    inline ::tcu_main_fi_types::T_TCU_GPS_Position& getREPOI_GPS_PositionMutable ();

    /**
     * Sets the value of the member "rEPOI_GPS_Position".
     *
     * If the meaning of "rEPOI_GPS_Position" isn't clear, then there should be a description here.
     *
     * @param rEPOI_GPS_Position The value which will be set
     */
    inline void setREPOI_GPS_Position (const ::tcu_main_fi_types::T_TCU_GPS_Position& rEPOI_GPS_Position_);

    // API of field "sCharge_Station_ID"

    static const int kSCharge_Station_ID = 2;

    /**
     * Clears the field "sCharge_Station_ID".
     *
     * The field will be set to its default value. The hasSCharge_Station_ID()
     * method will return false.
     */
    inline void clearSCharge_Station_ID();

    /**
     * Checks whether the field "sCharge_Station_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSCharge_Station_ID()). Otherwise it will return false.
     */
    inline bool hasSCharge_Station_ID () const;

    /**
     * Returns the value of the member "sCharge_Station_ID".
     *
     * If the meaning of "sCharge_Station_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sCharge_Station_ID"
     */
    inline const ::std::string& getSCharge_Station_ID () const;

    /**
     * Retrieves the value of the field "sCharge_Station_ID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sCharge_Station_ID".
     */
    inline ::std::string& getSCharge_Station_IDMutable ();

    /**
     * Sets the value of the member "sCharge_Station_ID".
     *
     * If the meaning of "sCharge_Station_ID" isn't clear, then there should be a description here.
     *
     * @param sCharge_Station_ID The value which will be set
     */
    inline void setSCharge_Station_ID (const ::std::string& sCharge_Station_ID_);

    /**
     * Sets the value of the member "sCharge_Station_ID".
     *
     * If the meaning of "sCharge_Station_ID" isn't clear, then there should be a description here.
     *
     * @param sCharge_Station_ID The value which will be set
     */
    inline void setSCharge_Station_ID (const char* sCharge_Station_ID_);

    /**
     * Sets the value of the member "sCharge_Station_ID".
     *
     * If the meaning of "sCharge_Station_ID" isn't clear, then there should be a description here.
     *
     * @param sCharge_Station_ID The value which will be set
     */
    inline void setSCharge_Station_ID (const char* value, size_t size);

    // API of field "sUtility_Aggregator_ID"

    static const int kSUtility_Aggregator_ID = 3;

    /**
     * Clears the field "sUtility_Aggregator_ID".
     *
     * The field will be set to its default value. The hasSUtility_Aggregator_ID()
     * method will return false.
     */
    inline void clearSUtility_Aggregator_ID();

    /**
     * Checks whether the field "sUtility_Aggregator_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSUtility_Aggregator_ID()). Otherwise it will return false.
     */
    inline bool hasSUtility_Aggregator_ID () const;

    /**
     * Returns the value of the member "sUtility_Aggregator_ID".
     *
     * If the meaning of "sUtility_Aggregator_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sUtility_Aggregator_ID"
     */
    inline const ::std::string& getSUtility_Aggregator_ID () const;

    /**
     * Retrieves the value of the field "sUtility_Aggregator_ID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sUtility_Aggregator_ID".
     */
    inline ::std::string& getSUtility_Aggregator_IDMutable ();

    /**
     * Sets the value of the member "sUtility_Aggregator_ID".
     *
     * If the meaning of "sUtility_Aggregator_ID" isn't clear, then there should be a description here.
     *
     * @param sUtility_Aggregator_ID The value which will be set
     */
    inline void setSUtility_Aggregator_ID (const ::std::string& sUtility_Aggregator_ID_);

    /**
     * Sets the value of the member "sUtility_Aggregator_ID".
     *
     * If the meaning of "sUtility_Aggregator_ID" isn't clear, then there should be a description here.
     *
     * @param sUtility_Aggregator_ID The value which will be set
     */
    inline void setSUtility_Aggregator_ID (const char* sUtility_Aggregator_ID_);

    /**
     * Sets the value of the member "sUtility_Aggregator_ID".
     *
     * If the meaning of "sUtility_Aggregator_ID" isn't clear, then there should be a description here.
     *
     * @param sUtility_Aggregator_ID The value which will be set
     */
    inline void setSUtility_Aggregator_ID (const char* value, size_t size);

    // API of field "u32Battery_Identification_Number"

    static const int kU32Battery_Identification_Number = 4;

    /**
     * Clears the field "u32Battery_Identification_Number".
     *
     * The field will be set to its default value. The hasU32Battery_Identification_Number()
     * method will return false.
     */
    inline void clearU32Battery_Identification_Number();

    /**
     * Checks whether the field "u32Battery_Identification_Number" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Battery_Identification_Number()). Otherwise it will return false.
     */
    inline bool hasU32Battery_Identification_Number () const;

    /**
     * Returns the value of the member "u32Battery_Identification_Number".
     *
     * If the meaning of "u32Battery_Identification_Number" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32Battery_Identification_Number"
     */
    inline uint32 getU32Battery_Identification_Number () const;

    /**
     * Sets the value of the member "u32Battery_Identification_Number".
     *
     * If the meaning of "u32Battery_Identification_Number" isn't clear, then there should be a description here.
     *
     * @param u32Battery_Identification_Number The value which will be set
     */
    inline void setU32Battery_Identification_Number (uint32 u32Battery_Identification_Number_);

    // API of field "rNavigation_Language"

    static const int kRNavigation_Language = 5;

    /**
     * Clears the field "rNavigation_Language".
     *
     * The field will be set to its default value. The hasRNavigation_Language()
     * method will return false.
     */
    inline void clearRNavigation_Language();

    /**
     * Checks whether the field "rNavigation_Language" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRNavigation_Language()). Otherwise it will return false.
     */
    inline bool hasRNavigation_Language () const;

    /**
     * Returns the value of the member "rNavigation_Language".
     *
     * If the meaning of "rNavigation_Language" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rNavigation_Language"
     */
    inline const ::tcu_main_fi_types::T_TCU_Navigation_Language& getRNavigation_Language () const;

    /**
     * Retrieves the value of the field "rNavigation_Language" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rNavigation_Language".
     */
    inline ::tcu_main_fi_types::T_TCU_Navigation_Language& getRNavigation_LanguageMutable ();

    /**
     * Sets the value of the member "rNavigation_Language".
     *
     * If the meaning of "rNavigation_Language" isn't clear, then there should be a description here.
     *
     * @param rNavigation_Language The value which will be set
     */
    inline void setRNavigation_Language (const ::tcu_main_fi_types::T_TCU_Navigation_Language& rNavigation_Language_);

    // API of field "sBooking_ID"

    static const int kSBooking_ID = 6;

    /**
     * Clears the field "sBooking_ID".
     *
     * The field will be set to its default value. The hasSBooking_ID()
     * method will return false.
     */
    inline void clearSBooking_ID();

    /**
     * Checks whether the field "sBooking_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSBooking_ID()). Otherwise it will return false.
     */
    inline bool hasSBooking_ID () const;

    /**
     * Returns the value of the member "sBooking_ID".
     *
     * If the meaning of "sBooking_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sBooking_ID"
     */
    inline const ::std::string& getSBooking_ID () const;

    /**
     * Retrieves the value of the field "sBooking_ID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sBooking_ID".
     */
    inline ::std::string& getSBooking_IDMutable ();

    /**
     * Sets the value of the member "sBooking_ID".
     *
     * If the meaning of "sBooking_ID" isn't clear, then there should be a description here.
     *
     * @param sBooking_ID The value which will be set
     */
    inline void setSBooking_ID (const ::std::string& sBooking_ID_);

    /**
     * Sets the value of the member "sBooking_ID".
     *
     * If the meaning of "sBooking_ID" isn't clear, then there should be a description here.
     *
     * @param sBooking_ID The value which will be set
     */
    inline void setSBooking_ID (const char* sBooking_ID_);

    /**
     * Sets the value of the member "sBooking_ID".
     *
     * If the meaning of "sBooking_ID" isn't clear, then there should be a description here.
     *
     * @param sBooking_ID The value which will be set
     */
    inline void setSBooking_ID (const char* value, size_t size);

    static const GetUpdateEnergyPointStart &getDefaultInstance();

private:

    inline void set_has_sCurrent_Country ();

    inline void clear_has_sCurrent_Country ();

    inline void set_has_rEPOI_GPS_Position ();

    inline void clear_has_rEPOI_GPS_Position ();

    inline void set_has_sCharge_Station_ID ();

    inline void clear_has_sCharge_Station_ID ();

    inline void set_has_sUtility_Aggregator_ID ();

    inline void clear_has_sUtility_Aggregator_ID ();

    inline void set_has_u32Battery_Identification_Number ();

    inline void clear_has_u32Battery_Identification_Number ();

    inline void set_has_rNavigation_Language ();

    inline void clear_has_rNavigation_Language ();

    inline void set_has_sBooking_ID ();

    inline void clear_has_sBooking_ID ();

    uint32 _has_bits_[ (7 + 31) / 32];

    ::std::string _sCurrent_Country;

    ::tcu_main_fi_types::T_TCU_GPS_Position _rEPOI_GPS_Position;

    ::std::string _sCharge_Station_ID;

    ::std::string _sUtility_Aggregator_ID;

    uint32 _u32Battery_Identification_Number;

    ::tcu_main_fi_types::T_TCU_Navigation_Language _rNavigation_Language;

    ::std::string _sBooking_ID;

};

/**
 * The error message of 'GetUpdateEnergyPoint'
 * Error Message
 */
class GetUpdateEnergyPointErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetUpdateEnergyPointErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetUpdateEnergyPointErrorStructure (const GetUpdateEnergyPointErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetUpdateEnergyPointErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~GetUpdateEnergyPointErrorStructure();

    /**
     * Assignment operator
     */
    inline GetUpdateEnergyPointErrorStructure& operator = (const GetUpdateEnergyPointErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetUpdateEnergyPointErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetUpdateEnergyPointErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetUpdateEnergyPointErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetUpdateEnergyPointErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const GetUpdateEnergyPointErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'GetUpdateEnergyPoint'
 * Error Message
 */
class GetUpdateEnergyPointError  : public ::asf::core::Payload {
public:

    enum GetUpdateEnergyPointErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetUpdateEnergyPointError ();

   /**
     * Copy constructor
     */
    inline  GetUpdateEnergyPointError (const GetUpdateEnergyPointError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetUpdateEnergyPointError();

    /**
     * Assigns a new value to this object.
     */
    inline GetUpdateEnergyPointError& operator = (const GetUpdateEnergyPointError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetUpdateEnergyPointError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetUpdateEnergyPointError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetUpdateEnergyPointError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetUpdateEnergyPointError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetUpdateEnergyPointError::GetUpdateEnergyPointErrorField getField () const;

    inline void setField(GetUpdateEnergyPointError::GetUpdateEnergyPointErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetUpdateEnergyPointErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetUpdateEnergyPointErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetUpdateEnergyPointErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetUpdateEnergyPointErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetUpdateEnergyPointErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetUpdateEnergyPointErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetUpdateEnergyPointErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetUpdateEnergyPointErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetUpdateEnergyPointError &getDefaultInstance();

private:

    inline void cloneData (const GetUpdateEnergyPointError& rhs);

    inline void deleteData ();

    GetUpdateEnergyPointErrorField __field;

    union {
        GetUpdateEnergyPointErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "UpdateEnergyPointStatus"
 * Property updates about the status of update of energy points
 */
class UpdateEnergyPointStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UpdateEnergyPointStatusStatus ();

    /**
     * Copy constructor
     */
    inline  UpdateEnergyPointStatusStatus (const UpdateEnergyPointStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  UpdateEnergyPointStatusStatus (::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter e8Invalid_Parameter_, ::tcu_main_fi_types::T_e8_TCU_Update_Status e8Update_Status_);

    /**
     * Destructor
     */
    inline virtual  ~UpdateEnergyPointStatusStatus();

    /**
     * Assignment operator
     */
    inline UpdateEnergyPointStatusStatus& operator = (const UpdateEnergyPointStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateEnergyPointStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateEnergyPointStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateEnergyPointStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateEnergyPointStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Invalid_Parameter"

    static const int kE8Invalid_Parameter = 0;

    /**
     * Clears the field "e8Invalid_Parameter".
     *
     * The field will be set to its default value. The hasE8Invalid_Parameter()
     * method will return false.
     */
    inline void clearE8Invalid_Parameter();

    /**
     * Checks whether the field "e8Invalid_Parameter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Invalid_Parameter()). Otherwise it will return false.
     */
    inline bool hasE8Invalid_Parameter () const;

    /**
     * Returns the value of the member "e8Invalid_Parameter".
     *
     * If the meaning of "e8Invalid_Parameter" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Invalid_Parameter"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter getE8Invalid_Parameter () const;

    /**
     * Sets the value of the member "e8Invalid_Parameter".
     *
     * If the meaning of "e8Invalid_Parameter" isn't clear, then there should be a description here.
     *
     * @param e8Invalid_Parameter The value which will be set
     */
    inline void setE8Invalid_Parameter (::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter e8Invalid_Parameter_);

    // API of field "e8Update_Status"

    static const int kE8Update_Status = 1;

    /**
     * Clears the field "e8Update_Status".
     *
     * The field will be set to its default value. The hasE8Update_Status()
     * method will return false.
     */
    inline void clearE8Update_Status();

    /**
     * Checks whether the field "e8Update_Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Update_Status()). Otherwise it will return false.
     */
    inline bool hasE8Update_Status () const;

    /**
     * Returns the value of the member "e8Update_Status".
     *
     * If the meaning of "e8Update_Status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Update_Status"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_Update_Status getE8Update_Status () const;

    /**
     * Sets the value of the member "e8Update_Status".
     *
     * If the meaning of "e8Update_Status" isn't clear, then there should be a description here.
     *
     * @param e8Update_Status The value which will be set
     */
    inline void setE8Update_Status (::tcu_main_fi_types::T_e8_TCU_Update_Status e8Update_Status_);

    static const UpdateEnergyPointStatusStatus &getDefaultInstance();

private:

    inline void set_has_e8Invalid_Parameter ();

    inline void clear_has_e8Invalid_Parameter ();

    inline void set_has_e8Update_Status ();

    inline void clear_has_e8Update_Status ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter _e8Invalid_Parameter;

    ::tcu_main_fi_types::T_e8_TCU_Update_Status _e8Update_Status;

};

/**
 * The status message of the property "UpdateEnergyPointIndication"
 */
class UpdateEnergyPointIndicationStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UpdateEnergyPointIndicationStatus ();

    /**
     * Copy constructor
     */
    inline  UpdateEnergyPointIndicationStatus (const UpdateEnergyPointIndicationStatus &rhs);

    /**
     * All fields constructor
     */
    inline  UpdateEnergyPointIndicationStatus (::tcu_main_fi_types::T_e8_TCU_Update_Status e8Update_Status_);

    /**
     * Destructor
     */
    inline virtual  ~UpdateEnergyPointIndicationStatus();

    /**
     * Assignment operator
     */
    inline UpdateEnergyPointIndicationStatus& operator = (const UpdateEnergyPointIndicationStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateEnergyPointIndicationStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateEnergyPointIndicationStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateEnergyPointIndicationStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateEnergyPointIndicationStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Update_Status"

    static const int kE8Update_Status = 0;

    /**
     * Clears the field "e8Update_Status".
     *
     * The field will be set to its default value. The hasE8Update_Status()
     * method will return false.
     */
    inline void clearE8Update_Status();

    /**
     * Checks whether the field "e8Update_Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Update_Status()). Otherwise it will return false.
     */
    inline bool hasE8Update_Status () const;

    /**
     * Returns the value of the member "e8Update_Status".
     *
     * If the meaning of "e8Update_Status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Update_Status"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_Update_Status getE8Update_Status () const;

    /**
     * Sets the value of the member "e8Update_Status".
     *
     * If the meaning of "e8Update_Status" isn't clear, then there should be a description here.
     *
     * @param e8Update_Status The value which will be set
     */
    inline void setE8Update_Status (::tcu_main_fi_types::T_e8_TCU_Update_Status e8Update_Status_);

    static const UpdateEnergyPointIndicationStatus &getDefaultInstance();

private:

    inline void set_has_e8Update_Status ();

    inline void clear_has_e8Update_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tcu_main_fi_types::T_e8_TCU_Update_Status _e8Update_Status;

};

/**
 * The start message of the method "SetSCH_Activation"
 */
class SetSCH_ActivationStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetSCH_ActivationStart ();

    /**
     * Copy constructor
     */
    inline  SetSCH_ActivationStart (const SetSCH_ActivationStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetSCH_ActivationStart (::tcu_main_fi_types::T_e8_TCU_Sch_Activation_State e8Sch_Activation_State_);

    /**
     * Destructor
     */
    inline virtual  ~SetSCH_ActivationStart();

    /**
     * Assignment operator
     */
    inline SetSCH_ActivationStart& operator = (const SetSCH_ActivationStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetSCH_ActivationStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetSCH_ActivationStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetSCH_ActivationStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetSCH_ActivationStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Sch_Activation_State"

    static const int kE8Sch_Activation_State = 0;

    /**
     * Clears the field "e8Sch_Activation_State".
     *
     * The field will be set to its default value. The hasE8Sch_Activation_State()
     * method will return false.
     */
    inline void clearE8Sch_Activation_State();

    /**
     * Checks whether the field "e8Sch_Activation_State" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Sch_Activation_State()). Otherwise it will return false.
     */
    inline bool hasE8Sch_Activation_State () const;

    /**
     * Returns the value of the member "e8Sch_Activation_State".
     *
     * If the meaning of "e8Sch_Activation_State" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Sch_Activation_State"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_Sch_Activation_State getE8Sch_Activation_State () const;

    /**
     * Sets the value of the member "e8Sch_Activation_State".
     *
     * If the meaning of "e8Sch_Activation_State" isn't clear, then there should be a description here.
     *
     * @param e8Sch_Activation_State The value which will be set
     */
    inline void setE8Sch_Activation_State (::tcu_main_fi_types::T_e8_TCU_Sch_Activation_State e8Sch_Activation_State_);

    static const SetSCH_ActivationStart &getDefaultInstance();

private:

    inline void set_has_e8Sch_Activation_State ();

    inline void clear_has_e8Sch_Activation_State ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tcu_main_fi_types::T_e8_TCU_Sch_Activation_State _e8Sch_Activation_State;

};

/**
 * The error message of 'SetSCH_Activation'
 * Error Message
 */
class SetSCH_ActivationErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SetSCH_ActivationErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SetSCH_ActivationErrorStructure (const SetSCH_ActivationErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SetSCH_ActivationErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~SetSCH_ActivationErrorStructure();

    /**
     * Assignment operator
     */
    inline SetSCH_ActivationErrorStructure& operator = (const SetSCH_ActivationErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetSCH_ActivationErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetSCH_ActivationErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetSCH_ActivationErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetSCH_ActivationErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const SetSCH_ActivationErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'SetSCH_Activation'
 * Error Message
 */
class SetSCH_ActivationError  : public ::asf::core::Payload {
public:

    enum SetSCH_ActivationErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SetSCH_ActivationError ();

   /**
     * Copy constructor
     */
    inline  SetSCH_ActivationError (const SetSCH_ActivationError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SetSCH_ActivationError();

    /**
     * Assigns a new value to this object.
     */
    inline SetSCH_ActivationError& operator = (const SetSCH_ActivationError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetSCH_ActivationError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetSCH_ActivationError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetSCH_ActivationError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetSCH_ActivationError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SetSCH_ActivationError::SetSCH_ActivationErrorField getField () const;

    inline void setField(SetSCH_ActivationError::SetSCH_ActivationErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SetSCH_ActivationErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SetSCH_ActivationErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SetSCH_ActivationErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SetSCH_ActivationErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SetSCH_ActivationErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SetSCH_ActivationErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SetSCH_ActivationErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SetSCH_ActivationErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SetSCH_ActivationError &getDefaultInstance();

private:

    inline void cloneData (const SetSCH_ActivationError& rhs);

    inline void deleteData ();

    SetSCH_ActivationErrorField __field;

    union {
        SetSCH_ActivationErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "SCH_ActivationStatus"
 */
class SCH_ActivationStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SCH_ActivationStatusStatus ();

    /**
     * Copy constructor
     */
    inline  SCH_ActivationStatusStatus (const SCH_ActivationStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SCH_ActivationStatusStatus (::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter e8Invalid_Parameter_, ::tcu_main_fi_types::T_e8_TCU_Sch_Activation_State e8Sch_Activation_State_);

    /**
     * Destructor
     */
    inline virtual  ~SCH_ActivationStatusStatus();

    /**
     * Assignment operator
     */
    inline SCH_ActivationStatusStatus& operator = (const SCH_ActivationStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SCH_ActivationStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SCH_ActivationStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SCH_ActivationStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SCH_ActivationStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Invalid_Parameter"

    static const int kE8Invalid_Parameter = 0;

    /**
     * Clears the field "e8Invalid_Parameter".
     *
     * The field will be set to its default value. The hasE8Invalid_Parameter()
     * method will return false.
     */
    inline void clearE8Invalid_Parameter();

    /**
     * Checks whether the field "e8Invalid_Parameter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Invalid_Parameter()). Otherwise it will return false.
     */
    inline bool hasE8Invalid_Parameter () const;

    /**
     * Returns the value of the member "e8Invalid_Parameter".
     *
     * If the meaning of "e8Invalid_Parameter" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Invalid_Parameter"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter getE8Invalid_Parameter () const;

    /**
     * Sets the value of the member "e8Invalid_Parameter".
     *
     * If the meaning of "e8Invalid_Parameter" isn't clear, then there should be a description here.
     *
     * @param e8Invalid_Parameter The value which will be set
     */
    inline void setE8Invalid_Parameter (::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter e8Invalid_Parameter_);

    // API of field "e8Sch_Activation_State"

    static const int kE8Sch_Activation_State = 1;

    /**
     * Clears the field "e8Sch_Activation_State".
     *
     * The field will be set to its default value. The hasE8Sch_Activation_State()
     * method will return false.
     */
    inline void clearE8Sch_Activation_State();

    /**
     * Checks whether the field "e8Sch_Activation_State" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Sch_Activation_State()). Otherwise it will return false.
     */
    inline bool hasE8Sch_Activation_State () const;

    /**
     * Returns the value of the member "e8Sch_Activation_State".
     *
     * If the meaning of "e8Sch_Activation_State" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Sch_Activation_State"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_Sch_Activation_State getE8Sch_Activation_State () const;

    /**
     * Sets the value of the member "e8Sch_Activation_State".
     *
     * If the meaning of "e8Sch_Activation_State" isn't clear, then there should be a description here.
     *
     * @param e8Sch_Activation_State The value which will be set
     */
    inline void setE8Sch_Activation_State (::tcu_main_fi_types::T_e8_TCU_Sch_Activation_State e8Sch_Activation_State_);

    static const SCH_ActivationStatusStatus &getDefaultInstance();

private:

    inline void set_has_e8Invalid_Parameter ();

    inline void clear_has_e8Invalid_Parameter ();

    inline void set_has_e8Sch_Activation_State ();

    inline void clear_has_e8Sch_Activation_State ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter _e8Invalid_Parameter;

    ::tcu_main_fi_types::T_e8_TCU_Sch_Activation_State _e8Sch_Activation_State;

};

/**
 * The start message of the method "SetSCH_Update_ONBOARD"
 * TCU updates the scheduler at startup or during a mission
 */
class SetSCH_Update_ONBOARDStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetSCH_Update_ONBOARDStart ();

    /**
     * Copy constructor
     */
    inline  SetSCH_Update_ONBOARDStart (const SetSCH_Update_ONBOARDStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetSCH_Update_ONBOARDStart (const ::tcu_main_fi_types::T_TCU_Charge_Days& rCharge_Day1_7_Start_, const ::tcu_main_fi_types::T_TCU_Charge_Days& rCharge_Day1_7_End_);

    /**
     * Destructor
     */
    inline virtual  ~SetSCH_Update_ONBOARDStart();

    /**
     * Assignment operator
     */
    inline SetSCH_Update_ONBOARDStart& operator = (const SetSCH_Update_ONBOARDStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetSCH_Update_ONBOARDStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetSCH_Update_ONBOARDStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetSCH_Update_ONBOARDStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetSCH_Update_ONBOARDStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "rCharge_Day1_7_Start"

    static const int kRCharge_Day1_7_Start = 0;

    /**
     * Clears the field "rCharge_Day1_7_Start".
     *
     * The field will be set to its default value. The hasRCharge_Day1_7_Start()
     * method will return false.
     */
    inline void clearRCharge_Day1_7_Start();

    /**
     * Checks whether the field "rCharge_Day1_7_Start" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRCharge_Day1_7_Start()). Otherwise it will return false.
     */
    inline bool hasRCharge_Day1_7_Start () const;

    /**
     * Returns the value of the member "rCharge_Day1_7_Start".
     *
     * Indicates the start of the Day Charge
     *
     * @return The value of the field "rCharge_Day1_7_Start"
     */
    inline const ::tcu_main_fi_types::T_TCU_Charge_Days& getRCharge_Day1_7_Start () const;

    /**
     * Retrieves the value of the field "rCharge_Day1_7_Start" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rCharge_Day1_7_Start".
     */
    inline ::tcu_main_fi_types::T_TCU_Charge_Days& getRCharge_Day1_7_StartMutable ();

    /**
     * Sets the value of the member "rCharge_Day1_7_Start".
     *
     * Indicates the start of the Day Charge
     *
     * @param rCharge_Day1_7_Start The value which will be set
     */
    inline void setRCharge_Day1_7_Start (const ::tcu_main_fi_types::T_TCU_Charge_Days& rCharge_Day1_7_Start_);

    // API of field "rCharge_Day1_7_End"

    static const int kRCharge_Day1_7_End = 1;

    /**
     * Clears the field "rCharge_Day1_7_End".
     *
     * The field will be set to its default value. The hasRCharge_Day1_7_End()
     * method will return false.
     */
    inline void clearRCharge_Day1_7_End();

    /**
     * Checks whether the field "rCharge_Day1_7_End" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRCharge_Day1_7_End()). Otherwise it will return false.
     */
    inline bool hasRCharge_Day1_7_End () const;

    /**
     * Returns the value of the member "rCharge_Day1_7_End".
     *
     * Indicates the end of the Day Charge
     *
     * @return The value of the field "rCharge_Day1_7_End"
     */
    inline const ::tcu_main_fi_types::T_TCU_Charge_Days& getRCharge_Day1_7_End () const;

    /**
     * Retrieves the value of the field "rCharge_Day1_7_End" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rCharge_Day1_7_End".
     */
    inline ::tcu_main_fi_types::T_TCU_Charge_Days& getRCharge_Day1_7_EndMutable ();

    /**
     * Sets the value of the member "rCharge_Day1_7_End".
     *
     * Indicates the end of the Day Charge
     *
     * @param rCharge_Day1_7_End The value which will be set
     */
    inline void setRCharge_Day1_7_End (const ::tcu_main_fi_types::T_TCU_Charge_Days& rCharge_Day1_7_End_);

    static const SetSCH_Update_ONBOARDStart &getDefaultInstance();

private:

    inline void set_has_rCharge_Day1_7_Start ();

    inline void clear_has_rCharge_Day1_7_Start ();

    inline void set_has_rCharge_Day1_7_End ();

    inline void clear_has_rCharge_Day1_7_End ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::tcu_main_fi_types::T_TCU_Charge_Days _rCharge_Day1_7_Start;

    ::tcu_main_fi_types::T_TCU_Charge_Days _rCharge_Day1_7_End;

};

/**
 * The error message of 'SetSCH_Update_ONBOARD'
 * Error Message
 */
class SetSCH_Update_ONBOARDErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SetSCH_Update_ONBOARDErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SetSCH_Update_ONBOARDErrorStructure (const SetSCH_Update_ONBOARDErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SetSCH_Update_ONBOARDErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~SetSCH_Update_ONBOARDErrorStructure();

    /**
     * Assignment operator
     */
    inline SetSCH_Update_ONBOARDErrorStructure& operator = (const SetSCH_Update_ONBOARDErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetSCH_Update_ONBOARDErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetSCH_Update_ONBOARDErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetSCH_Update_ONBOARDErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetSCH_Update_ONBOARDErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const SetSCH_Update_ONBOARDErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'SetSCH_Update_ONBOARD'
 * Error Message
 */
class SetSCH_Update_ONBOARDError  : public ::asf::core::Payload {
public:

    enum SetSCH_Update_ONBOARDErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SetSCH_Update_ONBOARDError ();

   /**
     * Copy constructor
     */
    inline  SetSCH_Update_ONBOARDError (const SetSCH_Update_ONBOARDError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SetSCH_Update_ONBOARDError();

    /**
     * Assigns a new value to this object.
     */
    inline SetSCH_Update_ONBOARDError& operator = (const SetSCH_Update_ONBOARDError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetSCH_Update_ONBOARDError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetSCH_Update_ONBOARDError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetSCH_Update_ONBOARDError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetSCH_Update_ONBOARDError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SetSCH_Update_ONBOARDError::SetSCH_Update_ONBOARDErrorField getField () const;

    inline void setField(SetSCH_Update_ONBOARDError::SetSCH_Update_ONBOARDErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SetSCH_Update_ONBOARDErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SetSCH_Update_ONBOARDErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SetSCH_Update_ONBOARDErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SetSCH_Update_ONBOARDErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SetSCH_Update_ONBOARDErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SetSCH_Update_ONBOARDErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SetSCH_Update_ONBOARDErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SetSCH_Update_ONBOARDErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SetSCH_Update_ONBOARDError &getDefaultInstance();

private:

    inline void cloneData (const SetSCH_Update_ONBOARDError& rhs);

    inline void deleteData ();

    SetSCH_Update_ONBOARDErrorField __field;

    union {
        SetSCH_Update_ONBOARDErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "SCH_Update_ONBOARDStatus"
 * TCU updates the scheduler at startup or during a mission
 */
class SCH_Update_ONBOARDStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SCH_Update_ONBOARDStatusStatus ();

    /**
     * Copy constructor
     */
    inline  SCH_Update_ONBOARDStatusStatus (const SCH_Update_ONBOARDStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SCH_Update_ONBOARDStatusStatus (::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter e8Invalid_Parameter_, const ::tcu_main_fi_types::T_TCU_Charge_Days& rCharge_Day1_7_Start_, const ::tcu_main_fi_types::T_TCU_Charge_Days& rCharge_Day1_7_End_);

    /**
     * Destructor
     */
    inline virtual  ~SCH_Update_ONBOARDStatusStatus();

    /**
     * Assignment operator
     */
    inline SCH_Update_ONBOARDStatusStatus& operator = (const SCH_Update_ONBOARDStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SCH_Update_ONBOARDStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SCH_Update_ONBOARDStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SCH_Update_ONBOARDStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SCH_Update_ONBOARDStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Invalid_Parameter"

    static const int kE8Invalid_Parameter = 0;

    /**
     * Clears the field "e8Invalid_Parameter".
     *
     * The field will be set to its default value. The hasE8Invalid_Parameter()
     * method will return false.
     */
    inline void clearE8Invalid_Parameter();

    /**
     * Checks whether the field "e8Invalid_Parameter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Invalid_Parameter()). Otherwise it will return false.
     */
    inline bool hasE8Invalid_Parameter () const;

    /**
     * Returns the value of the member "e8Invalid_Parameter".
     *
     * If the meaning of "e8Invalid_Parameter" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Invalid_Parameter"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter getE8Invalid_Parameter () const;

    /**
     * Sets the value of the member "e8Invalid_Parameter".
     *
     * If the meaning of "e8Invalid_Parameter" isn't clear, then there should be a description here.
     *
     * @param e8Invalid_Parameter The value which will be set
     */
    inline void setE8Invalid_Parameter (::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter e8Invalid_Parameter_);

    // API of field "rCharge_Day1_7_Start"

    static const int kRCharge_Day1_7_Start = 1;

    /**
     * Clears the field "rCharge_Day1_7_Start".
     *
     * The field will be set to its default value. The hasRCharge_Day1_7_Start()
     * method will return false.
     */
    inline void clearRCharge_Day1_7_Start();

    /**
     * Checks whether the field "rCharge_Day1_7_Start" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRCharge_Day1_7_Start()). Otherwise it will return false.
     */
    inline bool hasRCharge_Day1_7_Start () const;

    /**
     * Returns the value of the member "rCharge_Day1_7_Start".
     *
     * Indicates the start of the Day Charge
     *
     * @return The value of the field "rCharge_Day1_7_Start"
     */
    inline const ::tcu_main_fi_types::T_TCU_Charge_Days& getRCharge_Day1_7_Start () const;

    /**
     * Retrieves the value of the field "rCharge_Day1_7_Start" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rCharge_Day1_7_Start".
     */
    inline ::tcu_main_fi_types::T_TCU_Charge_Days& getRCharge_Day1_7_StartMutable ();

    /**
     * Sets the value of the member "rCharge_Day1_7_Start".
     *
     * Indicates the start of the Day Charge
     *
     * @param rCharge_Day1_7_Start The value which will be set
     */
    inline void setRCharge_Day1_7_Start (const ::tcu_main_fi_types::T_TCU_Charge_Days& rCharge_Day1_7_Start_);

    // API of field "rCharge_Day1_7_End"

    static const int kRCharge_Day1_7_End = 2;

    /**
     * Clears the field "rCharge_Day1_7_End".
     *
     * The field will be set to its default value. The hasRCharge_Day1_7_End()
     * method will return false.
     */
    inline void clearRCharge_Day1_7_End();

    /**
     * Checks whether the field "rCharge_Day1_7_End" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRCharge_Day1_7_End()). Otherwise it will return false.
     */
    inline bool hasRCharge_Day1_7_End () const;

    /**
     * Returns the value of the member "rCharge_Day1_7_End".
     *
     * Indicates the start of the Day Charge
     *
     * @return The value of the field "rCharge_Day1_7_End"
     */
    inline const ::tcu_main_fi_types::T_TCU_Charge_Days& getRCharge_Day1_7_End () const;

    /**
     * Retrieves the value of the field "rCharge_Day1_7_End" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rCharge_Day1_7_End".
     */
    inline ::tcu_main_fi_types::T_TCU_Charge_Days& getRCharge_Day1_7_EndMutable ();

    /**
     * Sets the value of the member "rCharge_Day1_7_End".
     *
     * Indicates the start of the Day Charge
     *
     * @param rCharge_Day1_7_End The value which will be set
     */
    inline void setRCharge_Day1_7_End (const ::tcu_main_fi_types::T_TCU_Charge_Days& rCharge_Day1_7_End_);

    static const SCH_Update_ONBOARDStatusStatus &getDefaultInstance();

private:

    inline void set_has_e8Invalid_Parameter ();

    inline void clear_has_e8Invalid_Parameter ();

    inline void set_has_rCharge_Day1_7_Start ();

    inline void clear_has_rCharge_Day1_7_Start ();

    inline void set_has_rCharge_Day1_7_End ();

    inline void clear_has_rCharge_Day1_7_End ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter _e8Invalid_Parameter;

    ::tcu_main_fi_types::T_TCU_Charge_Days _rCharge_Day1_7_Start;

    ::tcu_main_fi_types::T_TCU_Charge_Days _rCharge_Day1_7_End;

};

/**
 * The status message of the property "Charge_BlockedIndication"
 * Property Indicate that the charge is blocked by the TCU
 */
class Charge_BlockedIndicationStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Charge_BlockedIndicationStatus ();

    /**
     * Copy constructor
     */
    inline  Charge_BlockedIndicationStatus (const Charge_BlockedIndicationStatus &rhs);

    /**
     * All fields constructor
     */
    inline  Charge_BlockedIndicationStatus (::tcu_main_fi_types::T_e8_TCU_Charge_Blocked_Status e8Charge_Blocked_Status_);

    /**
     * Destructor
     */
    inline virtual  ~Charge_BlockedIndicationStatus();

    /**
     * Assignment operator
     */
    inline Charge_BlockedIndicationStatus& operator = (const Charge_BlockedIndicationStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Charge_BlockedIndicationStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Charge_BlockedIndicationStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Charge_BlockedIndicationStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Charge_BlockedIndicationStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Charge_Blocked_Status"

    static const int kE8Charge_Blocked_Status = 0;

    /**
     * Clears the field "e8Charge_Blocked_Status".
     *
     * The field will be set to its default value. The hasE8Charge_Blocked_Status()
     * method will return false.
     */
    inline void clearE8Charge_Blocked_Status();

    /**
     * Checks whether the field "e8Charge_Blocked_Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Charge_Blocked_Status()). Otherwise it will return false.
     */
    inline bool hasE8Charge_Blocked_Status () const;

    /**
     * Returns the value of the member "e8Charge_Blocked_Status".
     *
     * If the meaning of "e8Charge_Blocked_Status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Charge_Blocked_Status"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_Charge_Blocked_Status getE8Charge_Blocked_Status () const;

    /**
     * Sets the value of the member "e8Charge_Blocked_Status".
     *
     * If the meaning of "e8Charge_Blocked_Status" isn't clear, then there should be a description here.
     *
     * @param e8Charge_Blocked_Status The value which will be set
     */
    inline void setE8Charge_Blocked_Status (::tcu_main_fi_types::T_e8_TCU_Charge_Blocked_Status e8Charge_Blocked_Status_);

    static const Charge_BlockedIndicationStatus &getDefaultInstance();

private:

    inline void set_has_e8Charge_Blocked_Status ();

    inline void clear_has_e8Charge_Blocked_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tcu_main_fi_types::T_e8_TCU_Charge_Blocked_Status _e8Charge_Blocked_Status;

};

/**
 * The error message of 'GetSCH_State'
 * Error Message
 */
class GetSCH_StateErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetSCH_StateErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetSCH_StateErrorStructure (const GetSCH_StateErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetSCH_StateErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~GetSCH_StateErrorStructure();

    /**
     * Assignment operator
     */
    inline GetSCH_StateErrorStructure& operator = (const GetSCH_StateErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetSCH_StateErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetSCH_StateErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetSCH_StateErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetSCH_StateErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const GetSCH_StateErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'GetSCH_State'
 * Error Message
 */
class GetSCH_StateError  : public ::asf::core::Payload {
public:

    enum GetSCH_StateErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetSCH_StateError ();

   /**
     * Copy constructor
     */
    inline  GetSCH_StateError (const GetSCH_StateError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetSCH_StateError();

    /**
     * Assigns a new value to this object.
     */
    inline GetSCH_StateError& operator = (const GetSCH_StateError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetSCH_StateError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetSCH_StateError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetSCH_StateError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetSCH_StateError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetSCH_StateError::GetSCH_StateErrorField getField () const;

    inline void setField(GetSCH_StateError::GetSCH_StateErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetSCH_StateErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetSCH_StateErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetSCH_StateErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetSCH_StateErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetSCH_StateErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetSCH_StateErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetSCH_StateErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetSCH_StateErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetSCH_StateError &getDefaultInstance();

private:

    inline void cloneData (const GetSCH_StateError& rhs);

    inline void deleteData ();

    GetSCH_StateErrorField __field;

    union {
        GetSCH_StateErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "SCH_StateStatus"
 * TCU updates the scheduler at startup or during a mission
 */
class SCH_StateStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SCH_StateStatusStatus ();

    /**
     * Copy constructor
     */
    inline  SCH_StateStatusStatus (const SCH_StateStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SCH_StateStatusStatus (::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter e8Invalid_Parameter_, ::tcu_main_fi_types::T_e8_TCU_Sch_Activation_State e8Sch_Activation_State_, const ::tcu_main_fi_types::T_TCU_Charge_Days& rCharge_Day1_7_Start_, const ::tcu_main_fi_types::T_TCU_Charge_Days& rCharge_Day1_7_End_);

    /**
     * Destructor
     */
    inline virtual  ~SCH_StateStatusStatus();

    /**
     * Assignment operator
     */
    inline SCH_StateStatusStatus& operator = (const SCH_StateStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SCH_StateStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SCH_StateStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SCH_StateStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SCH_StateStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Invalid_Parameter"

    static const int kE8Invalid_Parameter = 0;

    /**
     * Clears the field "e8Invalid_Parameter".
     *
     * The field will be set to its default value. The hasE8Invalid_Parameter()
     * method will return false.
     */
    inline void clearE8Invalid_Parameter();

    /**
     * Checks whether the field "e8Invalid_Parameter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Invalid_Parameter()). Otherwise it will return false.
     */
    inline bool hasE8Invalid_Parameter () const;

    /**
     * Returns the value of the member "e8Invalid_Parameter".
     *
     * If the meaning of "e8Invalid_Parameter" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Invalid_Parameter"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter getE8Invalid_Parameter () const;

    /**
     * Sets the value of the member "e8Invalid_Parameter".
     *
     * If the meaning of "e8Invalid_Parameter" isn't clear, then there should be a description here.
     *
     * @param e8Invalid_Parameter The value which will be set
     */
    inline void setE8Invalid_Parameter (::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter e8Invalid_Parameter_);

    // API of field "e8Sch_Activation_State"

    static const int kE8Sch_Activation_State = 1;

    /**
     * Clears the field "e8Sch_Activation_State".
     *
     * The field will be set to its default value. The hasE8Sch_Activation_State()
     * method will return false.
     */
    inline void clearE8Sch_Activation_State();

    /**
     * Checks whether the field "e8Sch_Activation_State" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Sch_Activation_State()). Otherwise it will return false.
     */
    inline bool hasE8Sch_Activation_State () const;

    /**
     * Returns the value of the member "e8Sch_Activation_State".
     *
     * If the meaning of "e8Sch_Activation_State" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Sch_Activation_State"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_Sch_Activation_State getE8Sch_Activation_State () const;

    /**
     * Sets the value of the member "e8Sch_Activation_State".
     *
     * If the meaning of "e8Sch_Activation_State" isn't clear, then there should be a description here.
     *
     * @param e8Sch_Activation_State The value which will be set
     */
    inline void setE8Sch_Activation_State (::tcu_main_fi_types::T_e8_TCU_Sch_Activation_State e8Sch_Activation_State_);

    // API of field "rCharge_Day1_7_Start"

    static const int kRCharge_Day1_7_Start = 2;

    /**
     * Clears the field "rCharge_Day1_7_Start".
     *
     * The field will be set to its default value. The hasRCharge_Day1_7_Start()
     * method will return false.
     */
    inline void clearRCharge_Day1_7_Start();

    /**
     * Checks whether the field "rCharge_Day1_7_Start" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRCharge_Day1_7_Start()). Otherwise it will return false.
     */
    inline bool hasRCharge_Day1_7_Start () const;

    /**
     * Returns the value of the member "rCharge_Day1_7_Start".
     *
     * Indicates the Start time (GMT) of charge for Days.
     *
     * @return The value of the field "rCharge_Day1_7_Start"
     */
    inline const ::tcu_main_fi_types::T_TCU_Charge_Days& getRCharge_Day1_7_Start () const;

    /**
     * Retrieves the value of the field "rCharge_Day1_7_Start" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rCharge_Day1_7_Start".
     */
    inline ::tcu_main_fi_types::T_TCU_Charge_Days& getRCharge_Day1_7_StartMutable ();

    /**
     * Sets the value of the member "rCharge_Day1_7_Start".
     *
     * Indicates the Start time (GMT) of charge for Days.
     *
     * @param rCharge_Day1_7_Start The value which will be set
     */
    inline void setRCharge_Day1_7_Start (const ::tcu_main_fi_types::T_TCU_Charge_Days& rCharge_Day1_7_Start_);

    // API of field "rCharge_Day1_7_End"

    static const int kRCharge_Day1_7_End = 3;

    /**
     * Clears the field "rCharge_Day1_7_End".
     *
     * The field will be set to its default value. The hasRCharge_Day1_7_End()
     * method will return false.
     */
    inline void clearRCharge_Day1_7_End();

    /**
     * Checks whether the field "rCharge_Day1_7_End" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRCharge_Day1_7_End()). Otherwise it will return false.
     */
    inline bool hasRCharge_Day1_7_End () const;

    /**
     * Returns the value of the member "rCharge_Day1_7_End".
     *
     * Indicates the End time (GMT) of charge for Days.
     *
     * @return The value of the field "rCharge_Day1_7_End"
     */
    inline const ::tcu_main_fi_types::T_TCU_Charge_Days& getRCharge_Day1_7_End () const;

    /**
     * Retrieves the value of the field "rCharge_Day1_7_End" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rCharge_Day1_7_End".
     */
    inline ::tcu_main_fi_types::T_TCU_Charge_Days& getRCharge_Day1_7_EndMutable ();

    /**
     * Sets the value of the member "rCharge_Day1_7_End".
     *
     * Indicates the End time (GMT) of charge for Days.
     *
     * @param rCharge_Day1_7_End The value which will be set
     */
    inline void setRCharge_Day1_7_End (const ::tcu_main_fi_types::T_TCU_Charge_Days& rCharge_Day1_7_End_);

    static const SCH_StateStatusStatus &getDefaultInstance();

private:

    inline void set_has_e8Invalid_Parameter ();

    inline void clear_has_e8Invalid_Parameter ();

    inline void set_has_e8Sch_Activation_State ();

    inline void clear_has_e8Sch_Activation_State ();

    inline void set_has_rCharge_Day1_7_Start ();

    inline void clear_has_rCharge_Day1_7_Start ();

    inline void set_has_rCharge_Day1_7_End ();

    inline void clear_has_rCharge_Day1_7_End ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter _e8Invalid_Parameter;

    ::tcu_main_fi_types::T_e8_TCU_Sch_Activation_State _e8Sch_Activation_State;

    ::tcu_main_fi_types::T_TCU_Charge_Days _rCharge_Day1_7_Start;

    ::tcu_main_fi_types::T_TCU_Charge_Days _rCharge_Day1_7_End;

};

/**
 * The status message of the property "SCH_StateIndication"
 * TCU updates the scheduler at startup or during a mission
 */
class SCH_StateIndicationStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SCH_StateIndicationStatus ();

    /**
     * Copy constructor
     */
    inline  SCH_StateIndicationStatus (const SCH_StateIndicationStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SCH_StateIndicationStatus (::tcu_main_fi_types::T_e8_TCU_Sch_Activation_State e8Sch_Activation_State_, const ::tcu_main_fi_types::T_TCU_Charge_Days& rCharge_Day1_7_Start_, const ::tcu_main_fi_types::T_TCU_Charge_Days& rCharge_Day1_7_End_);

    /**
     * Destructor
     */
    inline virtual  ~SCH_StateIndicationStatus();

    /**
     * Assignment operator
     */
    inline SCH_StateIndicationStatus& operator = (const SCH_StateIndicationStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SCH_StateIndicationStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SCH_StateIndicationStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SCH_StateIndicationStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SCH_StateIndicationStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Sch_Activation_State"

    static const int kE8Sch_Activation_State = 0;

    /**
     * Clears the field "e8Sch_Activation_State".
     *
     * The field will be set to its default value. The hasE8Sch_Activation_State()
     * method will return false.
     */
    inline void clearE8Sch_Activation_State();

    /**
     * Checks whether the field "e8Sch_Activation_State" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Sch_Activation_State()). Otherwise it will return false.
     */
    inline bool hasE8Sch_Activation_State () const;

    /**
     * Returns the value of the member "e8Sch_Activation_State".
     *
     * If the meaning of "e8Sch_Activation_State" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Sch_Activation_State"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_Sch_Activation_State getE8Sch_Activation_State () const;

    /**
     * Sets the value of the member "e8Sch_Activation_State".
     *
     * If the meaning of "e8Sch_Activation_State" isn't clear, then there should be a description here.
     *
     * @param e8Sch_Activation_State The value which will be set
     */
    inline void setE8Sch_Activation_State (::tcu_main_fi_types::T_e8_TCU_Sch_Activation_State e8Sch_Activation_State_);

    // API of field "rCharge_Day1_7_Start"

    static const int kRCharge_Day1_7_Start = 1;

    /**
     * Clears the field "rCharge_Day1_7_Start".
     *
     * The field will be set to its default value. The hasRCharge_Day1_7_Start()
     * method will return false.
     */
    inline void clearRCharge_Day1_7_Start();

    /**
     * Checks whether the field "rCharge_Day1_7_Start" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRCharge_Day1_7_Start()). Otherwise it will return false.
     */
    inline bool hasRCharge_Day1_7_Start () const;

    /**
     * Returns the value of the member "rCharge_Day1_7_Start".
     *
     * If the meaning of "rCharge_Day1_7_Start" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rCharge_Day1_7_Start"
     */
    inline const ::tcu_main_fi_types::T_TCU_Charge_Days& getRCharge_Day1_7_Start () const;

    /**
     * Retrieves the value of the field "rCharge_Day1_7_Start" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rCharge_Day1_7_Start".
     */
    inline ::tcu_main_fi_types::T_TCU_Charge_Days& getRCharge_Day1_7_StartMutable ();

    /**
     * Sets the value of the member "rCharge_Day1_7_Start".
     *
     * If the meaning of "rCharge_Day1_7_Start" isn't clear, then there should be a description here.
     *
     * @param rCharge_Day1_7_Start The value which will be set
     */
    inline void setRCharge_Day1_7_Start (const ::tcu_main_fi_types::T_TCU_Charge_Days& rCharge_Day1_7_Start_);

    // API of field "rCharge_Day1_7_End"

    static const int kRCharge_Day1_7_End = 2;

    /**
     * Clears the field "rCharge_Day1_7_End".
     *
     * The field will be set to its default value. The hasRCharge_Day1_7_End()
     * method will return false.
     */
    inline void clearRCharge_Day1_7_End();

    /**
     * Checks whether the field "rCharge_Day1_7_End" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRCharge_Day1_7_End()). Otherwise it will return false.
     */
    inline bool hasRCharge_Day1_7_End () const;

    /**
     * Returns the value of the member "rCharge_Day1_7_End".
     *
     * If the meaning of "rCharge_Day1_7_End" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rCharge_Day1_7_End"
     */
    inline const ::tcu_main_fi_types::T_TCU_Charge_Days& getRCharge_Day1_7_End () const;

    /**
     * Retrieves the value of the field "rCharge_Day1_7_End" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rCharge_Day1_7_End".
     */
    inline ::tcu_main_fi_types::T_TCU_Charge_Days& getRCharge_Day1_7_EndMutable ();

    /**
     * Sets the value of the member "rCharge_Day1_7_End".
     *
     * If the meaning of "rCharge_Day1_7_End" isn't clear, then there should be a description here.
     *
     * @param rCharge_Day1_7_End The value which will be set
     */
    inline void setRCharge_Day1_7_End (const ::tcu_main_fi_types::T_TCU_Charge_Days& rCharge_Day1_7_End_);

    static const SCH_StateIndicationStatus &getDefaultInstance();

private:

    inline void set_has_e8Sch_Activation_State ();

    inline void clear_has_e8Sch_Activation_State ();

    inline void set_has_rCharge_Day1_7_Start ();

    inline void clear_has_rCharge_Day1_7_Start ();

    inline void set_has_rCharge_Day1_7_End ();

    inline void clear_has_rCharge_Day1_7_End ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::tcu_main_fi_types::T_e8_TCU_Sch_Activation_State _e8Sch_Activation_State;

    ::tcu_main_fi_types::T_TCU_Charge_Days _rCharge_Day1_7_Start;

    ::tcu_main_fi_types::T_TCU_Charge_Days _rCharge_Day1_7_End;

};

/**
 * The status message of the property "StationFinderIndication"
 * Provides the info about charging spot
 */
class StationFinderIndicationStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StationFinderIndicationStatus ();

    /**
     * Copy constructor
     */
    inline  StationFinderIndicationStatus (const StationFinderIndicationStatus &rhs);

    /**
     * All fields constructor
     */
    inline  StationFinderIndicationStatus (::tcu_main_fi_types::T_e8_TCU_Finder_Status e8FinderStatus_, uint8 u8Total_Station_Number_);

    /**
     * Destructor
     */
    inline virtual  ~StationFinderIndicationStatus();

    /**
     * Assignment operator
     */
    inline StationFinderIndicationStatus& operator = (const StationFinderIndicationStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StationFinderIndicationStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StationFinderIndicationStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StationFinderIndicationStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StationFinderIndicationStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8FinderStatus"

    static const int kE8FinderStatus = 0;

    /**
     * Clears the field "e8FinderStatus".
     *
     * The field will be set to its default value. The hasE8FinderStatus()
     * method will return false.
     */
    inline void clearE8FinderStatus();

    /**
     * Checks whether the field "e8FinderStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8FinderStatus()). Otherwise it will return false.
     */
    inline bool hasE8FinderStatus () const;

    /**
     * Returns the value of the member "e8FinderStatus".
     *
     * If the meaning of "e8FinderStatus" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8FinderStatus"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_Finder_Status getE8FinderStatus () const;

    /**
     * Sets the value of the member "e8FinderStatus".
     *
     * If the meaning of "e8FinderStatus" isn't clear, then there should be a description here.
     *
     * @param e8FinderStatus The value which will be set
     */
    inline void setE8FinderStatus (::tcu_main_fi_types::T_e8_TCU_Finder_Status e8FinderStatus_);

    // API of field "u8Total_Station_Number"

    static const int kU8Total_Station_Number = 1;

    /**
     * Clears the field "u8Total_Station_Number".
     *
     * The field will be set to its default value. The hasU8Total_Station_Number()
     * method will return false.
     */
    inline void clearU8Total_Station_Number();

    /**
     * Checks whether the field "u8Total_Station_Number" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Total_Station_Number()). Otherwise it will return false.
     */
    inline bool hasU8Total_Station_Number () const;

    /**
     * Returns the value of the member "u8Total_Station_Number".
     *
     * If the meaning of "u8Total_Station_Number" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Total_Station_Number"
     */
    inline uint8 getU8Total_Station_Number () const;

    /**
     * Sets the value of the member "u8Total_Station_Number".
     *
     * If the meaning of "u8Total_Station_Number" isn't clear, then there should be a description here.
     *
     * @param u8Total_Station_Number The value which will be set
     */
    inline void setU8Total_Station_Number (uint8 u8Total_Station_Number_);

    static const StationFinderIndicationStatus &getDefaultInstance();

private:

    inline void set_has_e8FinderStatus ();

    inline void clear_has_e8FinderStatus ();

    inline void set_has_u8Total_Station_Number ();

    inline void clear_has_u8Total_Station_Number ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::tcu_main_fi_types::T_e8_TCU_Finder_Status _e8FinderStatus;

    uint8 _u8Total_Station_Number;

};

/**
 * The status message of the property "ChargeSpotListStatus"
 * Used to receive the spot list of a station
 */
class ChargeSpotListStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ChargeSpotListStatusStatus ();

    /**
     * Copy constructor
     */
    inline  ChargeSpotListStatusStatus (const ChargeSpotListStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ChargeSpotListStatusStatus (::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter e8InvalidParameter_, const ::tcu_main_fi_types::T_TCU_Charge_Spot_List& rChargeSpotList_);

    /**
     * Destructor
     */
    inline virtual  ~ChargeSpotListStatusStatus();

    /**
     * Assignment operator
     */
    inline ChargeSpotListStatusStatus& operator = (const ChargeSpotListStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChargeSpotListStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChargeSpotListStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChargeSpotListStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChargeSpotListStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8InvalidParameter"

    static const int kE8InvalidParameter = 0;

    /**
     * Clears the field "e8InvalidParameter".
     *
     * The field will be set to its default value. The hasE8InvalidParameter()
     * method will return false.
     */
    inline void clearE8InvalidParameter();

    /**
     * Checks whether the field "e8InvalidParameter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8InvalidParameter()). Otherwise it will return false.
     */
    inline bool hasE8InvalidParameter () const;

    /**
     * Returns the value of the member "e8InvalidParameter".
     *
     * If the meaning of "e8InvalidParameter" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8InvalidParameter"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter getE8InvalidParameter () const;

    /**
     * Sets the value of the member "e8InvalidParameter".
     *
     * If the meaning of "e8InvalidParameter" isn't clear, then there should be a description here.
     *
     * @param e8InvalidParameter The value which will be set
     */
    inline void setE8InvalidParameter (::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter e8InvalidParameter_);

    // API of field "rChargeSpotList"

    static const int kRChargeSpotList = 1;

    /**
     * Clears the field "rChargeSpotList".
     *
     * The field will be set to its default value. The hasRChargeSpotList()
     * method will return false.
     */
    inline void clearRChargeSpotList();

    /**
     * Checks whether the field "rChargeSpotList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRChargeSpotList()). Otherwise it will return false.
     */
    inline bool hasRChargeSpotList () const;

    /**
     * Returns the value of the member "rChargeSpotList".
     *
     * If the meaning of "rChargeSpotList" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rChargeSpotList"
     */
    inline const ::tcu_main_fi_types::T_TCU_Charge_Spot_List& getRChargeSpotList () const;

    /**
     * Retrieves the value of the field "rChargeSpotList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rChargeSpotList".
     */
    inline ::tcu_main_fi_types::T_TCU_Charge_Spot_List& getRChargeSpotListMutable ();

    /**
     * Sets the value of the member "rChargeSpotList".
     *
     * If the meaning of "rChargeSpotList" isn't clear, then there should be a description here.
     *
     * @param rChargeSpotList The value which will be set
     */
    inline void setRChargeSpotList (const ::tcu_main_fi_types::T_TCU_Charge_Spot_List& rChargeSpotList_);

    static const ChargeSpotListStatusStatus &getDefaultInstance();

private:

    inline void set_has_e8InvalidParameter ();

    inline void clear_has_e8InvalidParameter ();

    inline void set_has_rChargeSpotList ();

    inline void clear_has_rChargeSpotList ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter _e8InvalidParameter;

    ::tcu_main_fi_types::T_TCU_Charge_Spot_List _rChargeSpotList;

};

/**
 * The start message of the method "SetWifiHotSpotRequest"
 * Usefull to know parameters shared by TCU to establish Wifi connection (internet)
 */
class SetWifiHotSpotRequestStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetWifiHotSpotRequestStart ();

    /**
     * Copy constructor
     */
    inline  SetWifiHotSpotRequestStart (const SetWifiHotSpotRequestStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetWifiHotSpotRequestStart (const ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name& rWifi_SSID_Name_, const ::tcu_main_fi_types::T_TCU_Wifi_PassKey& rWifi_PassKey_, ::tcu_main_fi_types::T_e8_TCU_Wifi_Security_Mode e8Wifi_Security_Mode_, uint8 u8Wifi_Channel_Number_, ::tcu_main_fi_types::T_e8_TCU_Wifi_Visibility e8Wifi_Visibility_);

    /**
     * Destructor
     */
    inline virtual  ~SetWifiHotSpotRequestStart();

    /**
     * Assignment operator
     */
    inline SetWifiHotSpotRequestStart& operator = (const SetWifiHotSpotRequestStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetWifiHotSpotRequestStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetWifiHotSpotRequestStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetWifiHotSpotRequestStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetWifiHotSpotRequestStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "rWifi_SSID_Name"

    static const int kRWifi_SSID_Name = 0;

    /**
     * Clears the field "rWifi_SSID_Name".
     *
     * The field will be set to its default value. The hasRWifi_SSID_Name()
     * method will return false.
     */
    inline void clearRWifi_SSID_Name();

    /**
     * Checks whether the field "rWifi_SSID_Name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRWifi_SSID_Name()). Otherwise it will return false.
     */
    inline bool hasRWifi_SSID_Name () const;

    /**
     * Returns the value of the member "rWifi_SSID_Name".
     *
     * If the meaning of "rWifi_SSID_Name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rWifi_SSID_Name"
     */
    inline const ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name& getRWifi_SSID_Name () const;

    /**
     * Retrieves the value of the field "rWifi_SSID_Name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rWifi_SSID_Name".
     */
    inline ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name& getRWifi_SSID_NameMutable ();

    /**
     * Sets the value of the member "rWifi_SSID_Name".
     *
     * If the meaning of "rWifi_SSID_Name" isn't clear, then there should be a description here.
     *
     * @param rWifi_SSID_Name The value which will be set
     */
    inline void setRWifi_SSID_Name (const ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name& rWifi_SSID_Name_);

    // API of field "rWifi_PassKey"

    static const int kRWifi_PassKey = 1;

    /**
     * Clears the field "rWifi_PassKey".
     *
     * The field will be set to its default value. The hasRWifi_PassKey()
     * method will return false.
     */
    inline void clearRWifi_PassKey();

    /**
     * Checks whether the field "rWifi_PassKey" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRWifi_PassKey()). Otherwise it will return false.
     */
    inline bool hasRWifi_PassKey () const;

    /**
     * Returns the value of the member "rWifi_PassKey".
     *
     * If the meaning of "rWifi_PassKey" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rWifi_PassKey"
     */
    inline const ::tcu_main_fi_types::T_TCU_Wifi_PassKey& getRWifi_PassKey () const;

    /**
     * Retrieves the value of the field "rWifi_PassKey" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rWifi_PassKey".
     */
    inline ::tcu_main_fi_types::T_TCU_Wifi_PassKey& getRWifi_PassKeyMutable ();

    /**
     * Sets the value of the member "rWifi_PassKey".
     *
     * If the meaning of "rWifi_PassKey" isn't clear, then there should be a description here.
     *
     * @param rWifi_PassKey The value which will be set
     */
    inline void setRWifi_PassKey (const ::tcu_main_fi_types::T_TCU_Wifi_PassKey& rWifi_PassKey_);

    // API of field "e8Wifi_Security_Mode"

    static const int kE8Wifi_Security_Mode = 2;

    /**
     * Clears the field "e8Wifi_Security_Mode".
     *
     * The field will be set to its default value. The hasE8Wifi_Security_Mode()
     * method will return false.
     */
    inline void clearE8Wifi_Security_Mode();

    /**
     * Checks whether the field "e8Wifi_Security_Mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Wifi_Security_Mode()). Otherwise it will return false.
     */
    inline bool hasE8Wifi_Security_Mode () const;

    /**
     * Returns the value of the member "e8Wifi_Security_Mode".
     *
     * If the meaning of "e8Wifi_Security_Mode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Wifi_Security_Mode"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_Wifi_Security_Mode getE8Wifi_Security_Mode () const;

    /**
     * Sets the value of the member "e8Wifi_Security_Mode".
     *
     * If the meaning of "e8Wifi_Security_Mode" isn't clear, then there should be a description here.
     *
     * @param e8Wifi_Security_Mode The value which will be set
     */
    inline void setE8Wifi_Security_Mode (::tcu_main_fi_types::T_e8_TCU_Wifi_Security_Mode e8Wifi_Security_Mode_);

    // API of field "u8Wifi_Channel_Number"

    static const int kU8Wifi_Channel_Number = 3;

    /**
     * Clears the field "u8Wifi_Channel_Number".
     *
     * The field will be set to its default value. The hasU8Wifi_Channel_Number()
     * method will return false.
     */
    inline void clearU8Wifi_Channel_Number();

    /**
     * Checks whether the field "u8Wifi_Channel_Number" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Wifi_Channel_Number()). Otherwise it will return false.
     */
    inline bool hasU8Wifi_Channel_Number () const;

    /**
     * Returns the value of the member "u8Wifi_Channel_Number".
     *
     * If the meaning of "u8Wifi_Channel_Number" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Wifi_Channel_Number"
     */
    inline uint8 getU8Wifi_Channel_Number () const;

    /**
     * Sets the value of the member "u8Wifi_Channel_Number".
     *
     * If the meaning of "u8Wifi_Channel_Number" isn't clear, then there should be a description here.
     *
     * @param u8Wifi_Channel_Number The value which will be set
     */
    inline void setU8Wifi_Channel_Number (uint8 u8Wifi_Channel_Number_);

    // API of field "e8Wifi_Visibility"

    static const int kE8Wifi_Visibility = 4;

    /**
     * Clears the field "e8Wifi_Visibility".
     *
     * The field will be set to its default value. The hasE8Wifi_Visibility()
     * method will return false.
     */
    inline void clearE8Wifi_Visibility();

    /**
     * Checks whether the field "e8Wifi_Visibility" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Wifi_Visibility()). Otherwise it will return false.
     */
    inline bool hasE8Wifi_Visibility () const;

    /**
     * Returns the value of the member "e8Wifi_Visibility".
     *
     * If the meaning of "e8Wifi_Visibility" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Wifi_Visibility"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_Wifi_Visibility getE8Wifi_Visibility () const;

    /**
     * Sets the value of the member "e8Wifi_Visibility".
     *
     * If the meaning of "e8Wifi_Visibility" isn't clear, then there should be a description here.
     *
     * @param e8Wifi_Visibility The value which will be set
     */
    inline void setE8Wifi_Visibility (::tcu_main_fi_types::T_e8_TCU_Wifi_Visibility e8Wifi_Visibility_);

    static const SetWifiHotSpotRequestStart &getDefaultInstance();

private:

    inline void set_has_rWifi_SSID_Name ();

    inline void clear_has_rWifi_SSID_Name ();

    inline void set_has_rWifi_PassKey ();

    inline void clear_has_rWifi_PassKey ();

    inline void set_has_e8Wifi_Security_Mode ();

    inline void clear_has_e8Wifi_Security_Mode ();

    inline void set_has_u8Wifi_Channel_Number ();

    inline void clear_has_u8Wifi_Channel_Number ();

    inline void set_has_e8Wifi_Visibility ();

    inline void clear_has_e8Wifi_Visibility ();

    uint32 _has_bits_[ (5 + 31) / 32];

    ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name _rWifi_SSID_Name;

    ::tcu_main_fi_types::T_TCU_Wifi_PassKey _rWifi_PassKey;

    ::tcu_main_fi_types::T_e8_TCU_Wifi_Security_Mode _e8Wifi_Security_Mode;

    uint8 _u8Wifi_Channel_Number;

    ::tcu_main_fi_types::T_e8_TCU_Wifi_Visibility _e8Wifi_Visibility;

};

/**
 * The error message of 'SetWifiHotSpotRequest'
 * Error Message
 */
class SetWifiHotSpotRequestErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SetWifiHotSpotRequestErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SetWifiHotSpotRequestErrorStructure (const SetWifiHotSpotRequestErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SetWifiHotSpotRequestErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~SetWifiHotSpotRequestErrorStructure();

    /**
     * Assignment operator
     */
    inline SetWifiHotSpotRequestErrorStructure& operator = (const SetWifiHotSpotRequestErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetWifiHotSpotRequestErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetWifiHotSpotRequestErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetWifiHotSpotRequestErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetWifiHotSpotRequestErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const SetWifiHotSpotRequestErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'SetWifiHotSpotRequest'
 * Error Message
 */
class SetWifiHotSpotRequestError  : public ::asf::core::Payload {
public:

    enum SetWifiHotSpotRequestErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SetWifiHotSpotRequestError ();

   /**
     * Copy constructor
     */
    inline  SetWifiHotSpotRequestError (const SetWifiHotSpotRequestError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SetWifiHotSpotRequestError();

    /**
     * Assigns a new value to this object.
     */
    inline SetWifiHotSpotRequestError& operator = (const SetWifiHotSpotRequestError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetWifiHotSpotRequestError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetWifiHotSpotRequestError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetWifiHotSpotRequestError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetWifiHotSpotRequestError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SetWifiHotSpotRequestError::SetWifiHotSpotRequestErrorField getField () const;

    inline void setField(SetWifiHotSpotRequestError::SetWifiHotSpotRequestErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SetWifiHotSpotRequestErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SetWifiHotSpotRequestErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SetWifiHotSpotRequestErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SetWifiHotSpotRequestErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SetWifiHotSpotRequestErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SetWifiHotSpotRequestErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SetWifiHotSpotRequestErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SetWifiHotSpotRequestErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SetWifiHotSpotRequestError &getDefaultInstance();

private:

    inline void cloneData (const SetWifiHotSpotRequestError& rhs);

    inline void deleteData ();

    SetWifiHotSpotRequestErrorField __field;

    union {
        SetWifiHotSpotRequestErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "WifiHotSpotRequestIndication"
 * Usefull to know parameters shared by TCU to establish Wifi connection (internet)
 */
class WifiHotSpotRequestIndicationStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WifiHotSpotRequestIndicationStatus ();

    /**
     * Copy constructor
     */
    inline  WifiHotSpotRequestIndicationStatus (const WifiHotSpotRequestIndicationStatus &rhs);

    /**
     * All fields constructor
     */
    inline  WifiHotSpotRequestIndicationStatus (const ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name& rWifi_SSID_Name_, const ::tcu_main_fi_types::T_TCU_Wifi_PassKey& rWifi_PassKey_, ::tcu_main_fi_types::T_e8_TCU_Wifi_Security_Mode e8Wifi_Security_Mode_, uint8 u8Wifi_Channel_Number_, ::tcu_main_fi_types::T_e8_TCU_Wifi_Visibility e8Wifi_Visibility_);

    /**
     * Destructor
     */
    inline virtual  ~WifiHotSpotRequestIndicationStatus();

    /**
     * Assignment operator
     */
    inline WifiHotSpotRequestIndicationStatus& operator = (const WifiHotSpotRequestIndicationStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WifiHotSpotRequestIndicationStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WifiHotSpotRequestIndicationStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WifiHotSpotRequestIndicationStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WifiHotSpotRequestIndicationStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "rWifi_SSID_Name"

    static const int kRWifi_SSID_Name = 0;

    /**
     * Clears the field "rWifi_SSID_Name".
     *
     * The field will be set to its default value. The hasRWifi_SSID_Name()
     * method will return false.
     */
    inline void clearRWifi_SSID_Name();

    /**
     * Checks whether the field "rWifi_SSID_Name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRWifi_SSID_Name()). Otherwise it will return false.
     */
    inline bool hasRWifi_SSID_Name () const;

    /**
     * Returns the value of the member "rWifi_SSID_Name".
     *
     * If the meaning of "rWifi_SSID_Name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rWifi_SSID_Name"
     */
    inline const ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name& getRWifi_SSID_Name () const;

    /**
     * Retrieves the value of the field "rWifi_SSID_Name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rWifi_SSID_Name".
     */
    inline ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name& getRWifi_SSID_NameMutable ();

    /**
     * Sets the value of the member "rWifi_SSID_Name".
     *
     * If the meaning of "rWifi_SSID_Name" isn't clear, then there should be a description here.
     *
     * @param rWifi_SSID_Name The value which will be set
     */
    inline void setRWifi_SSID_Name (const ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name& rWifi_SSID_Name_);

    // API of field "rWifi_PassKey"

    static const int kRWifi_PassKey = 1;

    /**
     * Clears the field "rWifi_PassKey".
     *
     * The field will be set to its default value. The hasRWifi_PassKey()
     * method will return false.
     */
    inline void clearRWifi_PassKey();

    /**
     * Checks whether the field "rWifi_PassKey" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRWifi_PassKey()). Otherwise it will return false.
     */
    inline bool hasRWifi_PassKey () const;

    /**
     * Returns the value of the member "rWifi_PassKey".
     *
     * If the meaning of "rWifi_PassKey" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rWifi_PassKey"
     */
    inline const ::tcu_main_fi_types::T_TCU_Wifi_PassKey& getRWifi_PassKey () const;

    /**
     * Retrieves the value of the field "rWifi_PassKey" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rWifi_PassKey".
     */
    inline ::tcu_main_fi_types::T_TCU_Wifi_PassKey& getRWifi_PassKeyMutable ();

    /**
     * Sets the value of the member "rWifi_PassKey".
     *
     * If the meaning of "rWifi_PassKey" isn't clear, then there should be a description here.
     *
     * @param rWifi_PassKey The value which will be set
     */
    inline void setRWifi_PassKey (const ::tcu_main_fi_types::T_TCU_Wifi_PassKey& rWifi_PassKey_);

    // API of field "e8Wifi_Security_Mode"

    static const int kE8Wifi_Security_Mode = 2;

    /**
     * Clears the field "e8Wifi_Security_Mode".
     *
     * The field will be set to its default value. The hasE8Wifi_Security_Mode()
     * method will return false.
     */
    inline void clearE8Wifi_Security_Mode();

    /**
     * Checks whether the field "e8Wifi_Security_Mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Wifi_Security_Mode()). Otherwise it will return false.
     */
    inline bool hasE8Wifi_Security_Mode () const;

    /**
     * Returns the value of the member "e8Wifi_Security_Mode".
     *
     * If the meaning of "e8Wifi_Security_Mode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Wifi_Security_Mode"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_Wifi_Security_Mode getE8Wifi_Security_Mode () const;

    /**
     * Sets the value of the member "e8Wifi_Security_Mode".
     *
     * If the meaning of "e8Wifi_Security_Mode" isn't clear, then there should be a description here.
     *
     * @param e8Wifi_Security_Mode The value which will be set
     */
    inline void setE8Wifi_Security_Mode (::tcu_main_fi_types::T_e8_TCU_Wifi_Security_Mode e8Wifi_Security_Mode_);

    // API of field "u8Wifi_Channel_Number"

    static const int kU8Wifi_Channel_Number = 3;

    /**
     * Clears the field "u8Wifi_Channel_Number".
     *
     * The field will be set to its default value. The hasU8Wifi_Channel_Number()
     * method will return false.
     */
    inline void clearU8Wifi_Channel_Number();

    /**
     * Checks whether the field "u8Wifi_Channel_Number" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Wifi_Channel_Number()). Otherwise it will return false.
     */
    inline bool hasU8Wifi_Channel_Number () const;

    /**
     * Returns the value of the member "u8Wifi_Channel_Number".
     *
     * If the meaning of "u8Wifi_Channel_Number" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Wifi_Channel_Number"
     */
    inline uint8 getU8Wifi_Channel_Number () const;

    /**
     * Sets the value of the member "u8Wifi_Channel_Number".
     *
     * If the meaning of "u8Wifi_Channel_Number" isn't clear, then there should be a description here.
     *
     * @param u8Wifi_Channel_Number The value which will be set
     */
    inline void setU8Wifi_Channel_Number (uint8 u8Wifi_Channel_Number_);

    // API of field "e8Wifi_Visibility"

    static const int kE8Wifi_Visibility = 4;

    /**
     * Clears the field "e8Wifi_Visibility".
     *
     * The field will be set to its default value. The hasE8Wifi_Visibility()
     * method will return false.
     */
    inline void clearE8Wifi_Visibility();

    /**
     * Checks whether the field "e8Wifi_Visibility" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Wifi_Visibility()). Otherwise it will return false.
     */
    inline bool hasE8Wifi_Visibility () const;

    /**
     * Returns the value of the member "e8Wifi_Visibility".
     *
     * If the meaning of "e8Wifi_Visibility" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Wifi_Visibility"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_Wifi_Visibility getE8Wifi_Visibility () const;

    /**
     * Sets the value of the member "e8Wifi_Visibility".
     *
     * If the meaning of "e8Wifi_Visibility" isn't clear, then there should be a description here.
     *
     * @param e8Wifi_Visibility The value which will be set
     */
    inline void setE8Wifi_Visibility (::tcu_main_fi_types::T_e8_TCU_Wifi_Visibility e8Wifi_Visibility_);

    static const WifiHotSpotRequestIndicationStatus &getDefaultInstance();

private:

    inline void set_has_rWifi_SSID_Name ();

    inline void clear_has_rWifi_SSID_Name ();

    inline void set_has_rWifi_PassKey ();

    inline void clear_has_rWifi_PassKey ();

    inline void set_has_e8Wifi_Security_Mode ();

    inline void clear_has_e8Wifi_Security_Mode ();

    inline void set_has_u8Wifi_Channel_Number ();

    inline void clear_has_u8Wifi_Channel_Number ();

    inline void set_has_e8Wifi_Visibility ();

    inline void clear_has_e8Wifi_Visibility ();

    uint32 _has_bits_[ (5 + 31) / 32];

    ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name _rWifi_SSID_Name;

    ::tcu_main_fi_types::T_TCU_Wifi_PassKey _rWifi_PassKey;

    ::tcu_main_fi_types::T_e8_TCU_Wifi_Security_Mode _e8Wifi_Security_Mode;

    uint8 _u8Wifi_Channel_Number;

    ::tcu_main_fi_types::T_e8_TCU_Wifi_Visibility _e8Wifi_Visibility;

};

/**
 * The status message of the property "WifiHotSpotRequest"
 * Usefull to know parameters shared by TCU to establish Wifi connection (internet)
 */
class WifiHotSpotRequestStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WifiHotSpotRequestStatus ();

    /**
     * Copy constructor
     */
    inline  WifiHotSpotRequestStatus (const WifiHotSpotRequestStatus &rhs);

    /**
     * All fields constructor
     */
    inline  WifiHotSpotRequestStatus (::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter e8Invalid_Parameter_, const ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name& rWifi_SSID_Name_, const ::tcu_main_fi_types::T_TCU_Wifi_PassKey& rWifi_PassKey_, ::tcu_main_fi_types::T_e8_TCU_Wifi_Security_Mode e8Wifi_Security_Mode_, uint8 u8Wifi_Channel_Number_, ::tcu_main_fi_types::T_e8_TCU_Wifi_Visibility e8Wifi_Visibility_);

    /**
     * Destructor
     */
    inline virtual  ~WifiHotSpotRequestStatus();

    /**
     * Assignment operator
     */
    inline WifiHotSpotRequestStatus& operator = (const WifiHotSpotRequestStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WifiHotSpotRequestStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WifiHotSpotRequestStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WifiHotSpotRequestStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WifiHotSpotRequestStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Invalid_Parameter"

    static const int kE8Invalid_Parameter = 0;

    /**
     * Clears the field "e8Invalid_Parameter".
     *
     * The field will be set to its default value. The hasE8Invalid_Parameter()
     * method will return false.
     */
    inline void clearE8Invalid_Parameter();

    /**
     * Checks whether the field "e8Invalid_Parameter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Invalid_Parameter()). Otherwise it will return false.
     */
    inline bool hasE8Invalid_Parameter () const;

    /**
     * Returns the value of the member "e8Invalid_Parameter".
     *
     * If the meaning of "e8Invalid_Parameter" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Invalid_Parameter"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter getE8Invalid_Parameter () const;

    /**
     * Sets the value of the member "e8Invalid_Parameter".
     *
     * If the meaning of "e8Invalid_Parameter" isn't clear, then there should be a description here.
     *
     * @param e8Invalid_Parameter The value which will be set
     */
    inline void setE8Invalid_Parameter (::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter e8Invalid_Parameter_);

    // API of field "rWifi_SSID_Name"

    static const int kRWifi_SSID_Name = 1;

    /**
     * Clears the field "rWifi_SSID_Name".
     *
     * The field will be set to its default value. The hasRWifi_SSID_Name()
     * method will return false.
     */
    inline void clearRWifi_SSID_Name();

    /**
     * Checks whether the field "rWifi_SSID_Name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRWifi_SSID_Name()). Otherwise it will return false.
     */
    inline bool hasRWifi_SSID_Name () const;

    /**
     * Returns the value of the member "rWifi_SSID_Name".
     *
     * If the meaning of "rWifi_SSID_Name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rWifi_SSID_Name"
     */
    inline const ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name& getRWifi_SSID_Name () const;

    /**
     * Retrieves the value of the field "rWifi_SSID_Name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rWifi_SSID_Name".
     */
    inline ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name& getRWifi_SSID_NameMutable ();

    /**
     * Sets the value of the member "rWifi_SSID_Name".
     *
     * If the meaning of "rWifi_SSID_Name" isn't clear, then there should be a description here.
     *
     * @param rWifi_SSID_Name The value which will be set
     */
    inline void setRWifi_SSID_Name (const ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name& rWifi_SSID_Name_);

    // API of field "rWifi_PassKey"

    static const int kRWifi_PassKey = 2;

    /**
     * Clears the field "rWifi_PassKey".
     *
     * The field will be set to its default value. The hasRWifi_PassKey()
     * method will return false.
     */
    inline void clearRWifi_PassKey();

    /**
     * Checks whether the field "rWifi_PassKey" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRWifi_PassKey()). Otherwise it will return false.
     */
    inline bool hasRWifi_PassKey () const;

    /**
     * Returns the value of the member "rWifi_PassKey".
     *
     * If the meaning of "rWifi_PassKey" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rWifi_PassKey"
     */
    inline const ::tcu_main_fi_types::T_TCU_Wifi_PassKey& getRWifi_PassKey () const;

    /**
     * Retrieves the value of the field "rWifi_PassKey" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rWifi_PassKey".
     */
    inline ::tcu_main_fi_types::T_TCU_Wifi_PassKey& getRWifi_PassKeyMutable ();

    /**
     * Sets the value of the member "rWifi_PassKey".
     *
     * If the meaning of "rWifi_PassKey" isn't clear, then there should be a description here.
     *
     * @param rWifi_PassKey The value which will be set
     */
    inline void setRWifi_PassKey (const ::tcu_main_fi_types::T_TCU_Wifi_PassKey& rWifi_PassKey_);

    // API of field "e8Wifi_Security_Mode"

    static const int kE8Wifi_Security_Mode = 3;

    /**
     * Clears the field "e8Wifi_Security_Mode".
     *
     * The field will be set to its default value. The hasE8Wifi_Security_Mode()
     * method will return false.
     */
    inline void clearE8Wifi_Security_Mode();

    /**
     * Checks whether the field "e8Wifi_Security_Mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Wifi_Security_Mode()). Otherwise it will return false.
     */
    inline bool hasE8Wifi_Security_Mode () const;

    /**
     * Returns the value of the member "e8Wifi_Security_Mode".
     *
     * If the meaning of "e8Wifi_Security_Mode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Wifi_Security_Mode"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_Wifi_Security_Mode getE8Wifi_Security_Mode () const;

    /**
     * Sets the value of the member "e8Wifi_Security_Mode".
     *
     * If the meaning of "e8Wifi_Security_Mode" isn't clear, then there should be a description here.
     *
     * @param e8Wifi_Security_Mode The value which will be set
     */
    inline void setE8Wifi_Security_Mode (::tcu_main_fi_types::T_e8_TCU_Wifi_Security_Mode e8Wifi_Security_Mode_);

    // API of field "u8Wifi_Channel_Number"

    static const int kU8Wifi_Channel_Number = 4;

    /**
     * Clears the field "u8Wifi_Channel_Number".
     *
     * The field will be set to its default value. The hasU8Wifi_Channel_Number()
     * method will return false.
     */
    inline void clearU8Wifi_Channel_Number();

    /**
     * Checks whether the field "u8Wifi_Channel_Number" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Wifi_Channel_Number()). Otherwise it will return false.
     */
    inline bool hasU8Wifi_Channel_Number () const;

    /**
     * Returns the value of the member "u8Wifi_Channel_Number".
     *
     * If the meaning of "u8Wifi_Channel_Number" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Wifi_Channel_Number"
     */
    inline uint8 getU8Wifi_Channel_Number () const;

    /**
     * Sets the value of the member "u8Wifi_Channel_Number".
     *
     * If the meaning of "u8Wifi_Channel_Number" isn't clear, then there should be a description here.
     *
     * @param u8Wifi_Channel_Number The value which will be set
     */
    inline void setU8Wifi_Channel_Number (uint8 u8Wifi_Channel_Number_);

    // API of field "e8Wifi_Visibility"

    static const int kE8Wifi_Visibility = 5;

    /**
     * Clears the field "e8Wifi_Visibility".
     *
     * The field will be set to its default value. The hasE8Wifi_Visibility()
     * method will return false.
     */
    inline void clearE8Wifi_Visibility();

    /**
     * Checks whether the field "e8Wifi_Visibility" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Wifi_Visibility()). Otherwise it will return false.
     */
    inline bool hasE8Wifi_Visibility () const;

    /**
     * Returns the value of the member "e8Wifi_Visibility".
     *
     * If the meaning of "e8Wifi_Visibility" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Wifi_Visibility"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_Wifi_Visibility getE8Wifi_Visibility () const;

    /**
     * Sets the value of the member "e8Wifi_Visibility".
     *
     * If the meaning of "e8Wifi_Visibility" isn't clear, then there should be a description here.
     *
     * @param e8Wifi_Visibility The value which will be set
     */
    inline void setE8Wifi_Visibility (::tcu_main_fi_types::T_e8_TCU_Wifi_Visibility e8Wifi_Visibility_);

    static const WifiHotSpotRequestStatus &getDefaultInstance();

private:

    inline void set_has_e8Invalid_Parameter ();

    inline void clear_has_e8Invalid_Parameter ();

    inline void set_has_rWifi_SSID_Name ();

    inline void clear_has_rWifi_SSID_Name ();

    inline void set_has_rWifi_PassKey ();

    inline void clear_has_rWifi_PassKey ();

    inline void set_has_e8Wifi_Security_Mode ();

    inline void clear_has_e8Wifi_Security_Mode ();

    inline void set_has_u8Wifi_Channel_Number ();

    inline void clear_has_u8Wifi_Channel_Number ();

    inline void set_has_e8Wifi_Visibility ();

    inline void clear_has_e8Wifi_Visibility ();

    uint32 _has_bits_[ (6 + 31) / 32];

    ::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter _e8Invalid_Parameter;

    ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name _rWifi_SSID_Name;

    ::tcu_main_fi_types::T_TCU_Wifi_PassKey _rWifi_PassKey;

    ::tcu_main_fi_types::T_e8_TCU_Wifi_Security_Mode _e8Wifi_Security_Mode;

    uint8 _u8Wifi_Channel_Number;

    ::tcu_main_fi_types::T_e8_TCU_Wifi_Visibility _e8Wifi_Visibility;

};

/**
 * The start message of the method "SetWifiActivationRequest"
 * Usefull to request the activation or the deactivation of Wifi feature
 */
class SetWifiActivationRequestStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetWifiActivationRequestStart ();

    /**
     * Copy constructor
     */
    inline  SetWifiActivationRequestStart (const SetWifiActivationRequestStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetWifiActivationRequestStart (::tcu_main_fi_types::T_e8_TCU_Wifi_Status e8Wifi_Status_, ::tcu_main_fi_types::T_e8_TCU_Wifi_Mode e8Wifi_Mode_);

    /**
     * Destructor
     */
    inline virtual  ~SetWifiActivationRequestStart();

    /**
     * Assignment operator
     */
    inline SetWifiActivationRequestStart& operator = (const SetWifiActivationRequestStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetWifiActivationRequestStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetWifiActivationRequestStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetWifiActivationRequestStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetWifiActivationRequestStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Wifi_Status"

    static const int kE8Wifi_Status = 0;

    /**
     * Clears the field "e8Wifi_Status".
     *
     * The field will be set to its default value. The hasE8Wifi_Status()
     * method will return false.
     */
    inline void clearE8Wifi_Status();

    /**
     * Checks whether the field "e8Wifi_Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Wifi_Status()). Otherwise it will return false.
     */
    inline bool hasE8Wifi_Status () const;

    /**
     * Returns the value of the member "e8Wifi_Status".
     *
     * If the meaning of "e8Wifi_Status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Wifi_Status"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_Wifi_Status getE8Wifi_Status () const;

    /**
     * Sets the value of the member "e8Wifi_Status".
     *
     * If the meaning of "e8Wifi_Status" isn't clear, then there should be a description here.
     *
     * @param e8Wifi_Status The value which will be set
     */
    inline void setE8Wifi_Status (::tcu_main_fi_types::T_e8_TCU_Wifi_Status e8Wifi_Status_);

    // API of field "e8Wifi_Mode"

    static const int kE8Wifi_Mode = 1;

    /**
     * Clears the field "e8Wifi_Mode".
     *
     * The field will be set to its default value. The hasE8Wifi_Mode()
     * method will return false.
     */
    inline void clearE8Wifi_Mode();

    /**
     * Checks whether the field "e8Wifi_Mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Wifi_Mode()). Otherwise it will return false.
     */
    inline bool hasE8Wifi_Mode () const;

    /**
     * Returns the value of the member "e8Wifi_Mode".
     *
     * If the meaning of "e8Wifi_Mode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Wifi_Mode"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_Wifi_Mode getE8Wifi_Mode () const;

    /**
     * Sets the value of the member "e8Wifi_Mode".
     *
     * If the meaning of "e8Wifi_Mode" isn't clear, then there should be a description here.
     *
     * @param e8Wifi_Mode The value which will be set
     */
    inline void setE8Wifi_Mode (::tcu_main_fi_types::T_e8_TCU_Wifi_Mode e8Wifi_Mode_);

    static const SetWifiActivationRequestStart &getDefaultInstance();

private:

    inline void set_has_e8Wifi_Status ();

    inline void clear_has_e8Wifi_Status ();

    inline void set_has_e8Wifi_Mode ();

    inline void clear_has_e8Wifi_Mode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::tcu_main_fi_types::T_e8_TCU_Wifi_Status _e8Wifi_Status;

    ::tcu_main_fi_types::T_e8_TCU_Wifi_Mode _e8Wifi_Mode;

};

/**
 * The error message of 'SetWifiActivationRequest'
 * Error Message
 */
class SetWifiActivationRequestErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SetWifiActivationRequestErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SetWifiActivationRequestErrorStructure (const SetWifiActivationRequestErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SetWifiActivationRequestErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~SetWifiActivationRequestErrorStructure();

    /**
     * Assignment operator
     */
    inline SetWifiActivationRequestErrorStructure& operator = (const SetWifiActivationRequestErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetWifiActivationRequestErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetWifiActivationRequestErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetWifiActivationRequestErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetWifiActivationRequestErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const SetWifiActivationRequestErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'SetWifiActivationRequest'
 * Error Message
 */
class SetWifiActivationRequestError  : public ::asf::core::Payload {
public:

    enum SetWifiActivationRequestErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SetWifiActivationRequestError ();

   /**
     * Copy constructor
     */
    inline  SetWifiActivationRequestError (const SetWifiActivationRequestError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SetWifiActivationRequestError();

    /**
     * Assigns a new value to this object.
     */
    inline SetWifiActivationRequestError& operator = (const SetWifiActivationRequestError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetWifiActivationRequestError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetWifiActivationRequestError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetWifiActivationRequestError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetWifiActivationRequestError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SetWifiActivationRequestError::SetWifiActivationRequestErrorField getField () const;

    inline void setField(SetWifiActivationRequestError::SetWifiActivationRequestErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SetWifiActivationRequestErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SetWifiActivationRequestErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SetWifiActivationRequestErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SetWifiActivationRequestErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SetWifiActivationRequestErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SetWifiActivationRequestErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SetWifiActivationRequestErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SetWifiActivationRequestErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SetWifiActivationRequestError &getDefaultInstance();

private:

    inline void cloneData (const SetWifiActivationRequestError& rhs);

    inline void deleteData ();

    SetWifiActivationRequestErrorField __field;

    union {
        SetWifiActivationRequestErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "WifiActivationRequest"
 * Usefull to know parameters shared by TCU to establish Wifi connection (internet)
 */
class WifiActivationRequestStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WifiActivationRequestStatus ();

    /**
     * Copy constructor
     */
    inline  WifiActivationRequestStatus (const WifiActivationRequestStatus &rhs);

    /**
     * All fields constructor
     */
    inline  WifiActivationRequestStatus (::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter e8Invalid_Parameter_, ::tcu_main_fi_types::T_e8_TCU_Wifi_Status e8Wifi_Status_, ::tcu_main_fi_types::T_e8_TCU_Wifi_Mode e8Wifi_Mode_);

    /**
     * Destructor
     */
    inline virtual  ~WifiActivationRequestStatus();

    /**
     * Assignment operator
     */
    inline WifiActivationRequestStatus& operator = (const WifiActivationRequestStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WifiActivationRequestStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WifiActivationRequestStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WifiActivationRequestStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WifiActivationRequestStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Invalid_Parameter"

    static const int kE8Invalid_Parameter = 0;

    /**
     * Clears the field "e8Invalid_Parameter".
     *
     * The field will be set to its default value. The hasE8Invalid_Parameter()
     * method will return false.
     */
    inline void clearE8Invalid_Parameter();

    /**
     * Checks whether the field "e8Invalid_Parameter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Invalid_Parameter()). Otherwise it will return false.
     */
    inline bool hasE8Invalid_Parameter () const;

    /**
     * Returns the value of the member "e8Invalid_Parameter".
     *
     * If the meaning of "e8Invalid_Parameter" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Invalid_Parameter"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter getE8Invalid_Parameter () const;

    /**
     * Sets the value of the member "e8Invalid_Parameter".
     *
     * If the meaning of "e8Invalid_Parameter" isn't clear, then there should be a description here.
     *
     * @param e8Invalid_Parameter The value which will be set
     */
    inline void setE8Invalid_Parameter (::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter e8Invalid_Parameter_);

    // API of field "e8Wifi_Status"

    static const int kE8Wifi_Status = 1;

    /**
     * Clears the field "e8Wifi_Status".
     *
     * The field will be set to its default value. The hasE8Wifi_Status()
     * method will return false.
     */
    inline void clearE8Wifi_Status();

    /**
     * Checks whether the field "e8Wifi_Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Wifi_Status()). Otherwise it will return false.
     */
    inline bool hasE8Wifi_Status () const;

    /**
     * Returns the value of the member "e8Wifi_Status".
     *
     * If the meaning of "e8Wifi_Status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Wifi_Status"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_Wifi_Status getE8Wifi_Status () const;

    /**
     * Sets the value of the member "e8Wifi_Status".
     *
     * If the meaning of "e8Wifi_Status" isn't clear, then there should be a description here.
     *
     * @param e8Wifi_Status The value which will be set
     */
    inline void setE8Wifi_Status (::tcu_main_fi_types::T_e8_TCU_Wifi_Status e8Wifi_Status_);

    // API of field "e8Wifi_Mode"

    static const int kE8Wifi_Mode = 2;

    /**
     * Clears the field "e8Wifi_Mode".
     *
     * The field will be set to its default value. The hasE8Wifi_Mode()
     * method will return false.
     */
    inline void clearE8Wifi_Mode();

    /**
     * Checks whether the field "e8Wifi_Mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Wifi_Mode()). Otherwise it will return false.
     */
    inline bool hasE8Wifi_Mode () const;

    /**
     * Returns the value of the member "e8Wifi_Mode".
     *
     * If the meaning of "e8Wifi_Mode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Wifi_Mode"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_Wifi_Mode getE8Wifi_Mode () const;

    /**
     * Sets the value of the member "e8Wifi_Mode".
     *
     * If the meaning of "e8Wifi_Mode" isn't clear, then there should be a description here.
     *
     * @param e8Wifi_Mode The value which will be set
     */
    inline void setE8Wifi_Mode (::tcu_main_fi_types::T_e8_TCU_Wifi_Mode e8Wifi_Mode_);

    static const WifiActivationRequestStatus &getDefaultInstance();

private:

    inline void set_has_e8Invalid_Parameter ();

    inline void clear_has_e8Invalid_Parameter ();

    inline void set_has_e8Wifi_Status ();

    inline void clear_has_e8Wifi_Status ();

    inline void set_has_e8Wifi_Mode ();

    inline void clear_has_e8Wifi_Mode ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter _e8Invalid_Parameter;

    ::tcu_main_fi_types::T_e8_TCU_Wifi_Status _e8Wifi_Status;

    ::tcu_main_fi_types::T_e8_TCU_Wifi_Mode _e8Wifi_Mode;

};

/**
 * The error message of 'SetWifiDataReset'
 * Error Message
 */
class SetWifiDataResetErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SetWifiDataResetErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SetWifiDataResetErrorStructure (const SetWifiDataResetErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SetWifiDataResetErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~SetWifiDataResetErrorStructure();

    /**
     * Assignment operator
     */
    inline SetWifiDataResetErrorStructure& operator = (const SetWifiDataResetErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetWifiDataResetErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetWifiDataResetErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetWifiDataResetErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetWifiDataResetErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const SetWifiDataResetErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'SetWifiDataReset'
 * Error Message
 */
class SetWifiDataResetError  : public ::asf::core::Payload {
public:

    enum SetWifiDataResetErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SetWifiDataResetError ();

   /**
     * Copy constructor
     */
    inline  SetWifiDataResetError (const SetWifiDataResetError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SetWifiDataResetError();

    /**
     * Assigns a new value to this object.
     */
    inline SetWifiDataResetError& operator = (const SetWifiDataResetError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetWifiDataResetError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetWifiDataResetError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetWifiDataResetError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetWifiDataResetError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SetWifiDataResetError::SetWifiDataResetErrorField getField () const;

    inline void setField(SetWifiDataResetError::SetWifiDataResetErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SetWifiDataResetErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SetWifiDataResetErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SetWifiDataResetErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SetWifiDataResetErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SetWifiDataResetErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SetWifiDataResetErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SetWifiDataResetErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SetWifiDataResetErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SetWifiDataResetError &getDefaultInstance();

private:

    inline void cloneData (const SetWifiDataResetError& rhs);

    inline void deleteData ();

    SetWifiDataResetErrorField __field;

    union {
        SetWifiDataResetErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "WifiDataReset"
 * Message is used to remove the passwords
 */
class WifiDataResetStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WifiDataResetStatus ();

    /**
     * Copy constructor
     */
    inline  WifiDataResetStatus (const WifiDataResetStatus &rhs);

    /**
     * All fields constructor
     */
    inline  WifiDataResetStatus (const ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name& rWifi_SSID_Name_, const ::tcu_main_fi_types::T_TCU_Wifi_PassKey& rWifi_PassKey_, ::tcu_main_fi_types::T_e8_TCU_Wifi_Security_Mode e8Wifi_Security_Mode_, uint8 u8Wifi_Channel_Number_, ::tcu_main_fi_types::T_e8_TCU_Wifi_Visibility e8Wifi_Visibility_);

    /**
     * Destructor
     */
    inline virtual  ~WifiDataResetStatus();

    /**
     * Assignment operator
     */
    inline WifiDataResetStatus& operator = (const WifiDataResetStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WifiDataResetStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WifiDataResetStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WifiDataResetStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WifiDataResetStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "rWifi_SSID_Name"

    static const int kRWifi_SSID_Name = 0;

    /**
     * Clears the field "rWifi_SSID_Name".
     *
     * The field will be set to its default value. The hasRWifi_SSID_Name()
     * method will return false.
     */
    inline void clearRWifi_SSID_Name();

    /**
     * Checks whether the field "rWifi_SSID_Name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRWifi_SSID_Name()). Otherwise it will return false.
     */
    inline bool hasRWifi_SSID_Name () const;

    /**
     * Returns the value of the member "rWifi_SSID_Name".
     *
     * If the meaning of "rWifi_SSID_Name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rWifi_SSID_Name"
     */
    inline const ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name& getRWifi_SSID_Name () const;

    /**
     * Retrieves the value of the field "rWifi_SSID_Name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rWifi_SSID_Name".
     */
    inline ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name& getRWifi_SSID_NameMutable ();

    /**
     * Sets the value of the member "rWifi_SSID_Name".
     *
     * If the meaning of "rWifi_SSID_Name" isn't clear, then there should be a description here.
     *
     * @param rWifi_SSID_Name The value which will be set
     */
    inline void setRWifi_SSID_Name (const ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name& rWifi_SSID_Name_);

    // API of field "rWifi_PassKey"

    static const int kRWifi_PassKey = 1;

    /**
     * Clears the field "rWifi_PassKey".
     *
     * The field will be set to its default value. The hasRWifi_PassKey()
     * method will return false.
     */
    inline void clearRWifi_PassKey();

    /**
     * Checks whether the field "rWifi_PassKey" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRWifi_PassKey()). Otherwise it will return false.
     */
    inline bool hasRWifi_PassKey () const;

    /**
     * Returns the value of the member "rWifi_PassKey".
     *
     * If the meaning of "rWifi_PassKey" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rWifi_PassKey"
     */
    inline const ::tcu_main_fi_types::T_TCU_Wifi_PassKey& getRWifi_PassKey () const;

    /**
     * Retrieves the value of the field "rWifi_PassKey" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rWifi_PassKey".
     */
    inline ::tcu_main_fi_types::T_TCU_Wifi_PassKey& getRWifi_PassKeyMutable ();

    /**
     * Sets the value of the member "rWifi_PassKey".
     *
     * If the meaning of "rWifi_PassKey" isn't clear, then there should be a description here.
     *
     * @param rWifi_PassKey The value which will be set
     */
    inline void setRWifi_PassKey (const ::tcu_main_fi_types::T_TCU_Wifi_PassKey& rWifi_PassKey_);

    // API of field "e8Wifi_Security_Mode"

    static const int kE8Wifi_Security_Mode = 2;

    /**
     * Clears the field "e8Wifi_Security_Mode".
     *
     * The field will be set to its default value. The hasE8Wifi_Security_Mode()
     * method will return false.
     */
    inline void clearE8Wifi_Security_Mode();

    /**
     * Checks whether the field "e8Wifi_Security_Mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Wifi_Security_Mode()). Otherwise it will return false.
     */
    inline bool hasE8Wifi_Security_Mode () const;

    /**
     * Returns the value of the member "e8Wifi_Security_Mode".
     *
     * If the meaning of "e8Wifi_Security_Mode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Wifi_Security_Mode"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_Wifi_Security_Mode getE8Wifi_Security_Mode () const;

    /**
     * Sets the value of the member "e8Wifi_Security_Mode".
     *
     * If the meaning of "e8Wifi_Security_Mode" isn't clear, then there should be a description here.
     *
     * @param e8Wifi_Security_Mode The value which will be set
     */
    inline void setE8Wifi_Security_Mode (::tcu_main_fi_types::T_e8_TCU_Wifi_Security_Mode e8Wifi_Security_Mode_);

    // API of field "u8Wifi_Channel_Number"

    static const int kU8Wifi_Channel_Number = 3;

    /**
     * Clears the field "u8Wifi_Channel_Number".
     *
     * The field will be set to its default value. The hasU8Wifi_Channel_Number()
     * method will return false.
     */
    inline void clearU8Wifi_Channel_Number();

    /**
     * Checks whether the field "u8Wifi_Channel_Number" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Wifi_Channel_Number()). Otherwise it will return false.
     */
    inline bool hasU8Wifi_Channel_Number () const;

    /**
     * Returns the value of the member "u8Wifi_Channel_Number".
     *
     * If the meaning of "u8Wifi_Channel_Number" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Wifi_Channel_Number"
     */
    inline uint8 getU8Wifi_Channel_Number () const;

    /**
     * Sets the value of the member "u8Wifi_Channel_Number".
     *
     * If the meaning of "u8Wifi_Channel_Number" isn't clear, then there should be a description here.
     *
     * @param u8Wifi_Channel_Number The value which will be set
     */
    inline void setU8Wifi_Channel_Number (uint8 u8Wifi_Channel_Number_);

    // API of field "e8Wifi_Visibility"

    static const int kE8Wifi_Visibility = 4;

    /**
     * Clears the field "e8Wifi_Visibility".
     *
     * The field will be set to its default value. The hasE8Wifi_Visibility()
     * method will return false.
     */
    inline void clearE8Wifi_Visibility();

    /**
     * Checks whether the field "e8Wifi_Visibility" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Wifi_Visibility()). Otherwise it will return false.
     */
    inline bool hasE8Wifi_Visibility () const;

    /**
     * Returns the value of the member "e8Wifi_Visibility".
     *
     * If the meaning of "e8Wifi_Visibility" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Wifi_Visibility"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_Wifi_Visibility getE8Wifi_Visibility () const;

    /**
     * Sets the value of the member "e8Wifi_Visibility".
     *
     * If the meaning of "e8Wifi_Visibility" isn't clear, then there should be a description here.
     *
     * @param e8Wifi_Visibility The value which will be set
     */
    inline void setE8Wifi_Visibility (::tcu_main_fi_types::T_e8_TCU_Wifi_Visibility e8Wifi_Visibility_);

    static const WifiDataResetStatus &getDefaultInstance();

private:

    inline void set_has_rWifi_SSID_Name ();

    inline void clear_has_rWifi_SSID_Name ();

    inline void set_has_rWifi_PassKey ();

    inline void clear_has_rWifi_PassKey ();

    inline void set_has_e8Wifi_Security_Mode ();

    inline void clear_has_e8Wifi_Security_Mode ();

    inline void set_has_u8Wifi_Channel_Number ();

    inline void clear_has_u8Wifi_Channel_Number ();

    inline void set_has_e8Wifi_Visibility ();

    inline void clear_has_e8Wifi_Visibility ();

    uint32 _has_bits_[ (5 + 31) / 32];

    ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name _rWifi_SSID_Name;

    ::tcu_main_fi_types::T_TCU_Wifi_PassKey _rWifi_PassKey;

    ::tcu_main_fi_types::T_e8_TCU_Wifi_Security_Mode _e8Wifi_Security_Mode;

    uint8 _u8Wifi_Channel_Number;

    ::tcu_main_fi_types::T_e8_TCU_Wifi_Visibility _e8Wifi_Visibility;

};

/**
 * The error message of 'SetWifiClientScan'
 * Error Message
 */
class SetWifiClientScanErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SetWifiClientScanErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SetWifiClientScanErrorStructure (const SetWifiClientScanErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SetWifiClientScanErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~SetWifiClientScanErrorStructure();

    /**
     * Assignment operator
     */
    inline SetWifiClientScanErrorStructure& operator = (const SetWifiClientScanErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetWifiClientScanErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetWifiClientScanErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetWifiClientScanErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetWifiClientScanErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const SetWifiClientScanErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'SetWifiClientScan'
 * Error Message
 */
class SetWifiClientScanError  : public ::asf::core::Payload {
public:

    enum SetWifiClientScanErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SetWifiClientScanError ();

   /**
     * Copy constructor
     */
    inline  SetWifiClientScanError (const SetWifiClientScanError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SetWifiClientScanError();

    /**
     * Assigns a new value to this object.
     */
    inline SetWifiClientScanError& operator = (const SetWifiClientScanError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetWifiClientScanError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetWifiClientScanError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetWifiClientScanError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetWifiClientScanError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SetWifiClientScanError::SetWifiClientScanErrorField getField () const;

    inline void setField(SetWifiClientScanError::SetWifiClientScanErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SetWifiClientScanErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SetWifiClientScanErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SetWifiClientScanErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SetWifiClientScanErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SetWifiClientScanErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SetWifiClientScanErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SetWifiClientScanErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SetWifiClientScanErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SetWifiClientScanError &getDefaultInstance();

private:

    inline void cloneData (const SetWifiClientScanError& rhs);

    inline void deleteData ();

    SetWifiClientScanErrorField __field;

    union {
        SetWifiClientScanErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SetWifiClientConnection"
 * used to request the scan and the selection of the network
 */
class SetWifiClientConnectionStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetWifiClientConnectionStart ();

    /**
     * Copy constructor
     */
    inline  SetWifiClientConnectionStart (const SetWifiClientConnectionStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetWifiClientConnectionStart (const ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name& rWifi_Scan_SSID_Name_, const ::tcu_main_fi_types::T_TCU_Wifi_PassKey& rWifi_PassKey_);

    /**
     * Destructor
     */
    inline virtual  ~SetWifiClientConnectionStart();

    /**
     * Assignment operator
     */
    inline SetWifiClientConnectionStart& operator = (const SetWifiClientConnectionStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetWifiClientConnectionStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetWifiClientConnectionStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetWifiClientConnectionStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetWifiClientConnectionStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "rWifi_Scan_SSID_Name"

    static const int kRWifi_Scan_SSID_Name = 0;

    /**
     * Clears the field "rWifi_Scan_SSID_Name".
     *
     * The field will be set to its default value. The hasRWifi_Scan_SSID_Name()
     * method will return false.
     */
    inline void clearRWifi_Scan_SSID_Name();

    /**
     * Checks whether the field "rWifi_Scan_SSID_Name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRWifi_Scan_SSID_Name()). Otherwise it will return false.
     */
    inline bool hasRWifi_Scan_SSID_Name () const;

    /**
     * Returns the value of the member "rWifi_Scan_SSID_Name".
     *
     * If the meaning of "rWifi_Scan_SSID_Name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rWifi_Scan_SSID_Name"
     */
    inline const ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name& getRWifi_Scan_SSID_Name () const;

    /**
     * Retrieves the value of the field "rWifi_Scan_SSID_Name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rWifi_Scan_SSID_Name".
     */
    inline ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name& getRWifi_Scan_SSID_NameMutable ();

    /**
     * Sets the value of the member "rWifi_Scan_SSID_Name".
     *
     * If the meaning of "rWifi_Scan_SSID_Name" isn't clear, then there should be a description here.
     *
     * @param rWifi_Scan_SSID_Name The value which will be set
     */
    inline void setRWifi_Scan_SSID_Name (const ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name& rWifi_Scan_SSID_Name_);

    // API of field "rWifi_PassKey"

    static const int kRWifi_PassKey = 1;

    /**
     * Clears the field "rWifi_PassKey".
     *
     * The field will be set to its default value. The hasRWifi_PassKey()
     * method will return false.
     */
    inline void clearRWifi_PassKey();

    /**
     * Checks whether the field "rWifi_PassKey" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRWifi_PassKey()). Otherwise it will return false.
     */
    inline bool hasRWifi_PassKey () const;

    /**
     * Returns the value of the member "rWifi_PassKey".
     *
     * If the meaning of "rWifi_PassKey" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rWifi_PassKey"
     */
    inline const ::tcu_main_fi_types::T_TCU_Wifi_PassKey& getRWifi_PassKey () const;

    /**
     * Retrieves the value of the field "rWifi_PassKey" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rWifi_PassKey".
     */
    inline ::tcu_main_fi_types::T_TCU_Wifi_PassKey& getRWifi_PassKeyMutable ();

    /**
     * Sets the value of the member "rWifi_PassKey".
     *
     * If the meaning of "rWifi_PassKey" isn't clear, then there should be a description here.
     *
     * @param rWifi_PassKey The value which will be set
     */
    inline void setRWifi_PassKey (const ::tcu_main_fi_types::T_TCU_Wifi_PassKey& rWifi_PassKey_);

    static const SetWifiClientConnectionStart &getDefaultInstance();

private:

    inline void set_has_rWifi_Scan_SSID_Name ();

    inline void clear_has_rWifi_Scan_SSID_Name ();

    inline void set_has_rWifi_PassKey ();

    inline void clear_has_rWifi_PassKey ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name _rWifi_Scan_SSID_Name;

    ::tcu_main_fi_types::T_TCU_Wifi_PassKey _rWifi_PassKey;

};

/**
 * The error message of 'SetWifiClientConnection'
 * Error Message
 */
class SetWifiClientConnectionErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SetWifiClientConnectionErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SetWifiClientConnectionErrorStructure (const SetWifiClientConnectionErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SetWifiClientConnectionErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~SetWifiClientConnectionErrorStructure();

    /**
     * Assignment operator
     */
    inline SetWifiClientConnectionErrorStructure& operator = (const SetWifiClientConnectionErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetWifiClientConnectionErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetWifiClientConnectionErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetWifiClientConnectionErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetWifiClientConnectionErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const SetWifiClientConnectionErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'SetWifiClientConnection'
 * Error Message
 */
class SetWifiClientConnectionError  : public ::asf::core::Payload {
public:

    enum SetWifiClientConnectionErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SetWifiClientConnectionError ();

   /**
     * Copy constructor
     */
    inline  SetWifiClientConnectionError (const SetWifiClientConnectionError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SetWifiClientConnectionError();

    /**
     * Assigns a new value to this object.
     */
    inline SetWifiClientConnectionError& operator = (const SetWifiClientConnectionError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetWifiClientConnectionError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetWifiClientConnectionError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetWifiClientConnectionError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetWifiClientConnectionError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SetWifiClientConnectionError::SetWifiClientConnectionErrorField getField () const;

    inline void setField(SetWifiClientConnectionError::SetWifiClientConnectionErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SetWifiClientConnectionErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SetWifiClientConnectionErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SetWifiClientConnectionErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SetWifiClientConnectionErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SetWifiClientConnectionErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SetWifiClientConnectionErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SetWifiClientConnectionErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SetWifiClientConnectionErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SetWifiClientConnectionError &getDefaultInstance();

private:

    inline void cloneData (const SetWifiClientConnectionError& rhs);

    inline void deleteData ();

    SetWifiClientConnectionErrorField __field;

    union {
        SetWifiClientConnectionErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "WifiClientConnection"
 * used to request the scan and the selection of the network
 */
class WifiClientConnectionStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WifiClientConnectionStatus ();

    /**
     * Copy constructor
     */
    inline  WifiClientConnectionStatus (const WifiClientConnectionStatus &rhs);

    /**
     * All fields constructor
     */
    inline  WifiClientConnectionStatus (::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter e8Invalid_Parameter_, const ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name& rWifi_Scan_SSID_Name_, ::tcu_main_fi_types::T_e8_TCU_Wifi_Connection_Status e8Wifi_Connection_Status_);

    /**
     * Destructor
     */
    inline virtual  ~WifiClientConnectionStatus();

    /**
     * Assignment operator
     */
    inline WifiClientConnectionStatus& operator = (const WifiClientConnectionStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WifiClientConnectionStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WifiClientConnectionStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WifiClientConnectionStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WifiClientConnectionStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Invalid_Parameter"

    static const int kE8Invalid_Parameter = 0;

    /**
     * Clears the field "e8Invalid_Parameter".
     *
     * The field will be set to its default value. The hasE8Invalid_Parameter()
     * method will return false.
     */
    inline void clearE8Invalid_Parameter();

    /**
     * Checks whether the field "e8Invalid_Parameter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Invalid_Parameter()). Otherwise it will return false.
     */
    inline bool hasE8Invalid_Parameter () const;

    /**
     * Returns the value of the member "e8Invalid_Parameter".
     *
     * If the meaning of "e8Invalid_Parameter" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Invalid_Parameter"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter getE8Invalid_Parameter () const;

    /**
     * Sets the value of the member "e8Invalid_Parameter".
     *
     * If the meaning of "e8Invalid_Parameter" isn't clear, then there should be a description here.
     *
     * @param e8Invalid_Parameter The value which will be set
     */
    inline void setE8Invalid_Parameter (::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter e8Invalid_Parameter_);

    // API of field "rWifi_Scan_SSID_Name"

    static const int kRWifi_Scan_SSID_Name = 1;

    /**
     * Clears the field "rWifi_Scan_SSID_Name".
     *
     * The field will be set to its default value. The hasRWifi_Scan_SSID_Name()
     * method will return false.
     */
    inline void clearRWifi_Scan_SSID_Name();

    /**
     * Checks whether the field "rWifi_Scan_SSID_Name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRWifi_Scan_SSID_Name()). Otherwise it will return false.
     */
    inline bool hasRWifi_Scan_SSID_Name () const;

    /**
     * Returns the value of the member "rWifi_Scan_SSID_Name".
     *
     * If the meaning of "rWifi_Scan_SSID_Name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rWifi_Scan_SSID_Name"
     */
    inline const ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name& getRWifi_Scan_SSID_Name () const;

    /**
     * Retrieves the value of the field "rWifi_Scan_SSID_Name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rWifi_Scan_SSID_Name".
     */
    inline ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name& getRWifi_Scan_SSID_NameMutable ();

    /**
     * Sets the value of the member "rWifi_Scan_SSID_Name".
     *
     * If the meaning of "rWifi_Scan_SSID_Name" isn't clear, then there should be a description here.
     *
     * @param rWifi_Scan_SSID_Name The value which will be set
     */
    inline void setRWifi_Scan_SSID_Name (const ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name& rWifi_Scan_SSID_Name_);

    // API of field "e8Wifi_Connection_Status"

    static const int kE8Wifi_Connection_Status = 2;

    /**
     * Clears the field "e8Wifi_Connection_Status".
     *
     * The field will be set to its default value. The hasE8Wifi_Connection_Status()
     * method will return false.
     */
    inline void clearE8Wifi_Connection_Status();

    /**
     * Checks whether the field "e8Wifi_Connection_Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Wifi_Connection_Status()). Otherwise it will return false.
     */
    inline bool hasE8Wifi_Connection_Status () const;

    /**
     * Returns the value of the member "e8Wifi_Connection_Status".
     *
     * If the meaning of "e8Wifi_Connection_Status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Wifi_Connection_Status"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_Wifi_Connection_Status getE8Wifi_Connection_Status () const;

    /**
     * Sets the value of the member "e8Wifi_Connection_Status".
     *
     * If the meaning of "e8Wifi_Connection_Status" isn't clear, then there should be a description here.
     *
     * @param e8Wifi_Connection_Status The value which will be set
     */
    inline void setE8Wifi_Connection_Status (::tcu_main_fi_types::T_e8_TCU_Wifi_Connection_Status e8Wifi_Connection_Status_);

    static const WifiClientConnectionStatus &getDefaultInstance();

private:

    inline void set_has_e8Invalid_Parameter ();

    inline void clear_has_e8Invalid_Parameter ();

    inline void set_has_rWifi_Scan_SSID_Name ();

    inline void clear_has_rWifi_Scan_SSID_Name ();

    inline void set_has_e8Wifi_Connection_Status ();

    inline void clear_has_e8Wifi_Connection_Status ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter _e8Invalid_Parameter;

    ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name _rWifi_Scan_SSID_Name;

    ::tcu_main_fi_types::T_e8_TCU_Wifi_Connection_Status _e8Wifi_Connection_Status;

};

/**
 * The status message of the property "WifiClientConnectionIndication"
 * used to request the scan and the selection of the network
 */
class WifiClientConnectionIndicationStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WifiClientConnectionIndicationStatus ();

    /**
     * Copy constructor
     */
    inline  WifiClientConnectionIndicationStatus (const WifiClientConnectionIndicationStatus &rhs);

    /**
     * All fields constructor
     */
    inline  WifiClientConnectionIndicationStatus (const ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name& rWifi_Scan_SSID_Name_, ::tcu_main_fi_types::T_e8_TCU_Wifi_Connection_Status e8Wifi_Connection_Status_);

    /**
     * Destructor
     */
    inline virtual  ~WifiClientConnectionIndicationStatus();

    /**
     * Assignment operator
     */
    inline WifiClientConnectionIndicationStatus& operator = (const WifiClientConnectionIndicationStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WifiClientConnectionIndicationStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WifiClientConnectionIndicationStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WifiClientConnectionIndicationStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WifiClientConnectionIndicationStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "rWifi_Scan_SSID_Name"

    static const int kRWifi_Scan_SSID_Name = 0;

    /**
     * Clears the field "rWifi_Scan_SSID_Name".
     *
     * The field will be set to its default value. The hasRWifi_Scan_SSID_Name()
     * method will return false.
     */
    inline void clearRWifi_Scan_SSID_Name();

    /**
     * Checks whether the field "rWifi_Scan_SSID_Name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRWifi_Scan_SSID_Name()). Otherwise it will return false.
     */
    inline bool hasRWifi_Scan_SSID_Name () const;

    /**
     * Returns the value of the member "rWifi_Scan_SSID_Name".
     *
     * If the meaning of "rWifi_Scan_SSID_Name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rWifi_Scan_SSID_Name"
     */
    inline const ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name& getRWifi_Scan_SSID_Name () const;

    /**
     * Retrieves the value of the field "rWifi_Scan_SSID_Name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rWifi_Scan_SSID_Name".
     */
    inline ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name& getRWifi_Scan_SSID_NameMutable ();

    /**
     * Sets the value of the member "rWifi_Scan_SSID_Name".
     *
     * If the meaning of "rWifi_Scan_SSID_Name" isn't clear, then there should be a description here.
     *
     * @param rWifi_Scan_SSID_Name The value which will be set
     */
    inline void setRWifi_Scan_SSID_Name (const ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name& rWifi_Scan_SSID_Name_);

    // API of field "e8Wifi_Connection_Status"

    static const int kE8Wifi_Connection_Status = 1;

    /**
     * Clears the field "e8Wifi_Connection_Status".
     *
     * The field will be set to its default value. The hasE8Wifi_Connection_Status()
     * method will return false.
     */
    inline void clearE8Wifi_Connection_Status();

    /**
     * Checks whether the field "e8Wifi_Connection_Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Wifi_Connection_Status()). Otherwise it will return false.
     */
    inline bool hasE8Wifi_Connection_Status () const;

    /**
     * Returns the value of the member "e8Wifi_Connection_Status".
     *
     * If the meaning of "e8Wifi_Connection_Status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Wifi_Connection_Status"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_Wifi_Connection_Status getE8Wifi_Connection_Status () const;

    /**
     * Sets the value of the member "e8Wifi_Connection_Status".
     *
     * If the meaning of "e8Wifi_Connection_Status" isn't clear, then there should be a description here.
     *
     * @param e8Wifi_Connection_Status The value which will be set
     */
    inline void setE8Wifi_Connection_Status (::tcu_main_fi_types::T_e8_TCU_Wifi_Connection_Status e8Wifi_Connection_Status_);

    static const WifiClientConnectionIndicationStatus &getDefaultInstance();

private:

    inline void set_has_rWifi_Scan_SSID_Name ();

    inline void clear_has_rWifi_Scan_SSID_Name ();

    inline void set_has_e8Wifi_Connection_Status ();

    inline void clear_has_e8Wifi_Connection_Status ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name _rWifi_Scan_SSID_Name;

    ::tcu_main_fi_types::T_e8_TCU_Wifi_Connection_Status _e8Wifi_Connection_Status;

};

/**
 * The error message of 'SetWifiClientDisconnection'
 * Error Message
 */
class SetWifiClientDisconnectionErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SetWifiClientDisconnectionErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SetWifiClientDisconnectionErrorStructure (const SetWifiClientDisconnectionErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SetWifiClientDisconnectionErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~SetWifiClientDisconnectionErrorStructure();

    /**
     * Assignment operator
     */
    inline SetWifiClientDisconnectionErrorStructure& operator = (const SetWifiClientDisconnectionErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetWifiClientDisconnectionErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetWifiClientDisconnectionErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetWifiClientDisconnectionErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetWifiClientDisconnectionErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const SetWifiClientDisconnectionErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'SetWifiClientDisconnection'
 * Error Message
 */
class SetWifiClientDisconnectionError  : public ::asf::core::Payload {
public:

    enum SetWifiClientDisconnectionErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SetWifiClientDisconnectionError ();

   /**
     * Copy constructor
     */
    inline  SetWifiClientDisconnectionError (const SetWifiClientDisconnectionError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SetWifiClientDisconnectionError();

    /**
     * Assigns a new value to this object.
     */
    inline SetWifiClientDisconnectionError& operator = (const SetWifiClientDisconnectionError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetWifiClientDisconnectionError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetWifiClientDisconnectionError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetWifiClientDisconnectionError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetWifiClientDisconnectionError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SetWifiClientDisconnectionError::SetWifiClientDisconnectionErrorField getField () const;

    inline void setField(SetWifiClientDisconnectionError::SetWifiClientDisconnectionErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SetWifiClientDisconnectionErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SetWifiClientDisconnectionErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SetWifiClientDisconnectionErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SetWifiClientDisconnectionErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SetWifiClientDisconnectionErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SetWifiClientDisconnectionErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SetWifiClientDisconnectionErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SetWifiClientDisconnectionErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SetWifiClientDisconnectionError &getDefaultInstance();

private:

    inline void cloneData (const SetWifiClientDisconnectionError& rhs);

    inline void deleteData ();

    SetWifiClientDisconnectionErrorField __field;

    union {
        SetWifiClientDisconnectionErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "WifiClientScanResultIndication"
 * used to request the scan and the selection of the network
 */
class WifiClientScanResultIndicationStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WifiClientScanResultIndicationStatus ();

    /**
     * Copy constructor
     */
    inline  WifiClientScanResultIndicationStatus (const WifiClientScanResultIndicationStatus &rhs);

    /**
     * All fields constructor
     */
    inline  WifiClientScanResultIndicationStatus (const ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name& rWifi_Scan_SSID_Name_, uint8 u8Wifi_Scan_Power_, ::tcu_main_fi_types::T_e8_TCU_Wifi_Wifi_Scan_Security e8Wifi_Scan_Security_);

    /**
     * Destructor
     */
    inline virtual  ~WifiClientScanResultIndicationStatus();

    /**
     * Assignment operator
     */
    inline WifiClientScanResultIndicationStatus& operator = (const WifiClientScanResultIndicationStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WifiClientScanResultIndicationStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WifiClientScanResultIndicationStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WifiClientScanResultIndicationStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WifiClientScanResultIndicationStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "rWifi_Scan_SSID_Name"

    static const int kRWifi_Scan_SSID_Name = 0;

    /**
     * Clears the field "rWifi_Scan_SSID_Name".
     *
     * The field will be set to its default value. The hasRWifi_Scan_SSID_Name()
     * method will return false.
     */
    inline void clearRWifi_Scan_SSID_Name();

    /**
     * Checks whether the field "rWifi_Scan_SSID_Name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRWifi_Scan_SSID_Name()). Otherwise it will return false.
     */
    inline bool hasRWifi_Scan_SSID_Name () const;

    /**
     * Returns the value of the member "rWifi_Scan_SSID_Name".
     *
     * If the meaning of "rWifi_Scan_SSID_Name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rWifi_Scan_SSID_Name"
     */
    inline const ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name& getRWifi_Scan_SSID_Name () const;

    /**
     * Retrieves the value of the field "rWifi_Scan_SSID_Name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rWifi_Scan_SSID_Name".
     */
    inline ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name& getRWifi_Scan_SSID_NameMutable ();

    /**
     * Sets the value of the member "rWifi_Scan_SSID_Name".
     *
     * If the meaning of "rWifi_Scan_SSID_Name" isn't clear, then there should be a description here.
     *
     * @param rWifi_Scan_SSID_Name The value which will be set
     */
    inline void setRWifi_Scan_SSID_Name (const ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name& rWifi_Scan_SSID_Name_);

    // API of field "u8Wifi_Scan_Power"

    static const int kU8Wifi_Scan_Power = 1;

    /**
     * Clears the field "u8Wifi_Scan_Power".
     *
     * The field will be set to its default value. The hasU8Wifi_Scan_Power()
     * method will return false.
     */
    inline void clearU8Wifi_Scan_Power();

    /**
     * Checks whether the field "u8Wifi_Scan_Power" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Wifi_Scan_Power()). Otherwise it will return false.
     */
    inline bool hasU8Wifi_Scan_Power () const;

    /**
     * Returns the value of the member "u8Wifi_Scan_Power".
     *
     * If the meaning of "u8Wifi_Scan_Power" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Wifi_Scan_Power"
     */
    inline uint8 getU8Wifi_Scan_Power () const;

    /**
     * Sets the value of the member "u8Wifi_Scan_Power".
     *
     * If the meaning of "u8Wifi_Scan_Power" isn't clear, then there should be a description here.
     *
     * @param u8Wifi_Scan_Power The value which will be set
     */
    inline void setU8Wifi_Scan_Power (uint8 u8Wifi_Scan_Power_);

    // API of field "e8Wifi_Scan_Security"

    static const int kE8Wifi_Scan_Security = 2;

    /**
     * Clears the field "e8Wifi_Scan_Security".
     *
     * The field will be set to its default value. The hasE8Wifi_Scan_Security()
     * method will return false.
     */
    inline void clearE8Wifi_Scan_Security();

    /**
     * Checks whether the field "e8Wifi_Scan_Security" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Wifi_Scan_Security()). Otherwise it will return false.
     */
    inline bool hasE8Wifi_Scan_Security () const;

    /**
     * Returns the value of the member "e8Wifi_Scan_Security".
     *
     * If the meaning of "e8Wifi_Scan_Security" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Wifi_Scan_Security"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_Wifi_Wifi_Scan_Security getE8Wifi_Scan_Security () const;

    /**
     * Sets the value of the member "e8Wifi_Scan_Security".
     *
     * If the meaning of "e8Wifi_Scan_Security" isn't clear, then there should be a description here.
     *
     * @param e8Wifi_Scan_Security The value which will be set
     */
    inline void setE8Wifi_Scan_Security (::tcu_main_fi_types::T_e8_TCU_Wifi_Wifi_Scan_Security e8Wifi_Scan_Security_);

    static const WifiClientScanResultIndicationStatus &getDefaultInstance();

private:

    inline void set_has_rWifi_Scan_SSID_Name ();

    inline void clear_has_rWifi_Scan_SSID_Name ();

    inline void set_has_u8Wifi_Scan_Power ();

    inline void clear_has_u8Wifi_Scan_Power ();

    inline void set_has_e8Wifi_Scan_Security ();

    inline void clear_has_e8Wifi_Scan_Security ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name _rWifi_Scan_SSID_Name;

    uint8 _u8Wifi_Scan_Power;

    ::tcu_main_fi_types::T_e8_TCU_Wifi_Wifi_Scan_Security _e8Wifi_Scan_Security;

};

/**
 * The error message of 'GetWifiConnectedDevicesRequest'
 * Error Message
 */
class GetWifiConnectedDevicesRequestErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetWifiConnectedDevicesRequestErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetWifiConnectedDevicesRequestErrorStructure (const GetWifiConnectedDevicesRequestErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetWifiConnectedDevicesRequestErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~GetWifiConnectedDevicesRequestErrorStructure();

    /**
     * Assignment operator
     */
    inline GetWifiConnectedDevicesRequestErrorStructure& operator = (const GetWifiConnectedDevicesRequestErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetWifiConnectedDevicesRequestErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetWifiConnectedDevicesRequestErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetWifiConnectedDevicesRequestErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetWifiConnectedDevicesRequestErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const GetWifiConnectedDevicesRequestErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'GetWifiConnectedDevicesRequest'
 * Error Message
 */
class GetWifiConnectedDevicesRequestError  : public ::asf::core::Payload {
public:

    enum GetWifiConnectedDevicesRequestErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetWifiConnectedDevicesRequestError ();

   /**
     * Copy constructor
     */
    inline  GetWifiConnectedDevicesRequestError (const GetWifiConnectedDevicesRequestError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetWifiConnectedDevicesRequestError();

    /**
     * Assigns a new value to this object.
     */
    inline GetWifiConnectedDevicesRequestError& operator = (const GetWifiConnectedDevicesRequestError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetWifiConnectedDevicesRequestError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetWifiConnectedDevicesRequestError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetWifiConnectedDevicesRequestError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetWifiConnectedDevicesRequestError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetWifiConnectedDevicesRequestError::GetWifiConnectedDevicesRequestErrorField getField () const;

    inline void setField(GetWifiConnectedDevicesRequestError::GetWifiConnectedDevicesRequestErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetWifiConnectedDevicesRequestErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetWifiConnectedDevicesRequestErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetWifiConnectedDevicesRequestErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetWifiConnectedDevicesRequestErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetWifiConnectedDevicesRequestErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetWifiConnectedDevicesRequestErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetWifiConnectedDevicesRequestErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetWifiConnectedDevicesRequestErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetWifiConnectedDevicesRequestError &getDefaultInstance();

private:

    inline void cloneData (const GetWifiConnectedDevicesRequestError& rhs);

    inline void deleteData ();

    GetWifiConnectedDevicesRequestErrorField __field;

    union {
        GetWifiConnectedDevicesRequestErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "WifiConnectedDevicesRequest"
 * Lists Connected devices
 */
class WifiConnectedDevicesRequestStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WifiConnectedDevicesRequestStatus ();

    /**
     * Copy constructor
     */
    inline  WifiConnectedDevicesRequestStatus (const WifiConnectedDevicesRequestStatus &rhs);

    /**
     * All fields constructor
     */
    inline  WifiConnectedDevicesRequestStatus (uint8 u8Wifi_Connected_Devices_);

    /**
     * Destructor
     */
    inline virtual  ~WifiConnectedDevicesRequestStatus();

    /**
     * Assignment operator
     */
    inline WifiConnectedDevicesRequestStatus& operator = (const WifiConnectedDevicesRequestStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WifiConnectedDevicesRequestStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WifiConnectedDevicesRequestStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WifiConnectedDevicesRequestStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WifiConnectedDevicesRequestStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8Wifi_Connected_Devices"

    static const int kU8Wifi_Connected_Devices = 0;

    /**
     * Clears the field "u8Wifi_Connected_Devices".
     *
     * The field will be set to its default value. The hasU8Wifi_Connected_Devices()
     * method will return false.
     */
    inline void clearU8Wifi_Connected_Devices();

    /**
     * Checks whether the field "u8Wifi_Connected_Devices" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Wifi_Connected_Devices()). Otherwise it will return false.
     */
    inline bool hasU8Wifi_Connected_Devices () const;

    /**
     * Returns the value of the member "u8Wifi_Connected_Devices".
     *
     * If the meaning of "u8Wifi_Connected_Devices" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Wifi_Connected_Devices"
     */
    inline uint8 getU8Wifi_Connected_Devices () const;

    /**
     * Sets the value of the member "u8Wifi_Connected_Devices".
     *
     * If the meaning of "u8Wifi_Connected_Devices" isn't clear, then there should be a description here.
     *
     * @param u8Wifi_Connected_Devices The value which will be set
     */
    inline void setU8Wifi_Connected_Devices (uint8 u8Wifi_Connected_Devices_);

    static const WifiConnectedDevicesRequestStatus &getDefaultInstance();

private:

    inline void set_has_u8Wifi_Connected_Devices ();

    inline void clear_has_u8Wifi_Connected_Devices ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8Wifi_Connected_Devices;

};

/**
 * The error message of 'GetWifiClientState'
 * Error Message
 */
class GetWifiClientStateErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetWifiClientStateErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetWifiClientStateErrorStructure (const GetWifiClientStateErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetWifiClientStateErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~GetWifiClientStateErrorStructure();

    /**
     * Assignment operator
     */
    inline GetWifiClientStateErrorStructure& operator = (const GetWifiClientStateErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetWifiClientStateErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetWifiClientStateErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetWifiClientStateErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetWifiClientStateErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const GetWifiClientStateErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'GetWifiClientState'
 * Error Message
 */
class GetWifiClientStateError  : public ::asf::core::Payload {
public:

    enum GetWifiClientStateErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetWifiClientStateError ();

   /**
     * Copy constructor
     */
    inline  GetWifiClientStateError (const GetWifiClientStateError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetWifiClientStateError();

    /**
     * Assigns a new value to this object.
     */
    inline GetWifiClientStateError& operator = (const GetWifiClientStateError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetWifiClientStateError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetWifiClientStateError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetWifiClientStateError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetWifiClientStateError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetWifiClientStateError::GetWifiClientStateErrorField getField () const;

    inline void setField(GetWifiClientStateError::GetWifiClientStateErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetWifiClientStateErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetWifiClientStateErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetWifiClientStateErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetWifiClientStateErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetWifiClientStateErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetWifiClientStateErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetWifiClientStateErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetWifiClientStateErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetWifiClientStateError &getDefaultInstance();

private:

    inline void cloneData (const GetWifiClientStateError& rhs);

    inline void deleteData ();

    GetWifiClientStateErrorField __field;

    union {
        GetWifiClientStateErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "WifiClientState"
 * Lists Connected devices
 */
class WifiClientStateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WifiClientStateStatus ();

    /**
     * Copy constructor
     */
    inline  WifiClientStateStatus (const WifiClientStateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  WifiClientStateStatus (::tcu_main_fi_types::T_e8_TCU_Wifi_Wifi_Client_Status e8Wifi_Client_Status_, const ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name& rWifi_SSID_, uint8 u8Wifi_Client_Power_);

    /**
     * Destructor
     */
    inline virtual  ~WifiClientStateStatus();

    /**
     * Assignment operator
     */
    inline WifiClientStateStatus& operator = (const WifiClientStateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WifiClientStateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WifiClientStateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WifiClientStateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WifiClientStateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Wifi_Client_Status"

    static const int kE8Wifi_Client_Status = 0;

    /**
     * Clears the field "e8Wifi_Client_Status".
     *
     * The field will be set to its default value. The hasE8Wifi_Client_Status()
     * method will return false.
     */
    inline void clearE8Wifi_Client_Status();

    /**
     * Checks whether the field "e8Wifi_Client_Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Wifi_Client_Status()). Otherwise it will return false.
     */
    inline bool hasE8Wifi_Client_Status () const;

    /**
     * Returns the value of the member "e8Wifi_Client_Status".
     *
     * If the meaning of "e8Wifi_Client_Status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Wifi_Client_Status"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_Wifi_Wifi_Client_Status getE8Wifi_Client_Status () const;

    /**
     * Sets the value of the member "e8Wifi_Client_Status".
     *
     * If the meaning of "e8Wifi_Client_Status" isn't clear, then there should be a description here.
     *
     * @param e8Wifi_Client_Status The value which will be set
     */
    inline void setE8Wifi_Client_Status (::tcu_main_fi_types::T_e8_TCU_Wifi_Wifi_Client_Status e8Wifi_Client_Status_);

    // API of field "rWifi_SSID"

    static const int kRWifi_SSID = 1;

    /**
     * Clears the field "rWifi_SSID".
     *
     * The field will be set to its default value. The hasRWifi_SSID()
     * method will return false.
     */
    inline void clearRWifi_SSID();

    /**
     * Checks whether the field "rWifi_SSID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRWifi_SSID()). Otherwise it will return false.
     */
    inline bool hasRWifi_SSID () const;

    /**
     * Returns the value of the member "rWifi_SSID".
     *
     * If the meaning of "rWifi_SSID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rWifi_SSID"
     */
    inline const ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name& getRWifi_SSID () const;

    /**
     * Retrieves the value of the field "rWifi_SSID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rWifi_SSID".
     */
    inline ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name& getRWifi_SSIDMutable ();

    /**
     * Sets the value of the member "rWifi_SSID".
     *
     * If the meaning of "rWifi_SSID" isn't clear, then there should be a description here.
     *
     * @param rWifi_SSID The value which will be set
     */
    inline void setRWifi_SSID (const ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name& rWifi_SSID_);

    // API of field "u8Wifi_Client_Power"

    static const int kU8Wifi_Client_Power = 2;

    /**
     * Clears the field "u8Wifi_Client_Power".
     *
     * The field will be set to its default value. The hasU8Wifi_Client_Power()
     * method will return false.
     */
    inline void clearU8Wifi_Client_Power();

    /**
     * Checks whether the field "u8Wifi_Client_Power" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Wifi_Client_Power()). Otherwise it will return false.
     */
    inline bool hasU8Wifi_Client_Power () const;

    /**
     * Returns the value of the member "u8Wifi_Client_Power".
     *
     * If the meaning of "u8Wifi_Client_Power" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Wifi_Client_Power"
     */
    inline uint8 getU8Wifi_Client_Power () const;

    /**
     * Sets the value of the member "u8Wifi_Client_Power".
     *
     * If the meaning of "u8Wifi_Client_Power" isn't clear, then there should be a description here.
     *
     * @param u8Wifi_Client_Power The value which will be set
     */
    inline void setU8Wifi_Client_Power (uint8 u8Wifi_Client_Power_);

    static const WifiClientStateStatus &getDefaultInstance();

private:

    inline void set_has_e8Wifi_Client_Status ();

    inline void clear_has_e8Wifi_Client_Status ();

    inline void set_has_rWifi_SSID ();

    inline void clear_has_rWifi_SSID ();

    inline void set_has_u8Wifi_Client_Power ();

    inline void clear_has_u8Wifi_Client_Power ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::tcu_main_fi_types::T_e8_TCU_Wifi_Wifi_Client_Status _e8Wifi_Client_Status;

    ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name _rWifi_SSID;

    uint8 _u8Wifi_Client_Power;

};

/**
 * The status message of the property "WifiClientStateIndication"
 * Lists Connected devices
 */
class WifiClientStateIndicationStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WifiClientStateIndicationStatus ();

    /**
     * Copy constructor
     */
    inline  WifiClientStateIndicationStatus (const WifiClientStateIndicationStatus &rhs);

    /**
     * All fields constructor
     */
    inline  WifiClientStateIndicationStatus (::tcu_main_fi_types::T_e8_TCU_Wifi_Wifi_Client_Status e8Wifi_Client_Status_, const ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name& rWifi_SSID_, uint8 u8Wifi_Client_Power_);

    /**
     * Destructor
     */
    inline virtual  ~WifiClientStateIndicationStatus();

    /**
     * Assignment operator
     */
    inline WifiClientStateIndicationStatus& operator = (const WifiClientStateIndicationStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WifiClientStateIndicationStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WifiClientStateIndicationStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WifiClientStateIndicationStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WifiClientStateIndicationStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Wifi_Client_Status"

    static const int kE8Wifi_Client_Status = 0;

    /**
     * Clears the field "e8Wifi_Client_Status".
     *
     * The field will be set to its default value. The hasE8Wifi_Client_Status()
     * method will return false.
     */
    inline void clearE8Wifi_Client_Status();

    /**
     * Checks whether the field "e8Wifi_Client_Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Wifi_Client_Status()). Otherwise it will return false.
     */
    inline bool hasE8Wifi_Client_Status () const;

    /**
     * Returns the value of the member "e8Wifi_Client_Status".
     *
     * If the meaning of "e8Wifi_Client_Status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Wifi_Client_Status"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_Wifi_Wifi_Client_Status getE8Wifi_Client_Status () const;

    /**
     * Sets the value of the member "e8Wifi_Client_Status".
     *
     * If the meaning of "e8Wifi_Client_Status" isn't clear, then there should be a description here.
     *
     * @param e8Wifi_Client_Status The value which will be set
     */
    inline void setE8Wifi_Client_Status (::tcu_main_fi_types::T_e8_TCU_Wifi_Wifi_Client_Status e8Wifi_Client_Status_);

    // API of field "rWifi_SSID"

    static const int kRWifi_SSID = 1;

    /**
     * Clears the field "rWifi_SSID".
     *
     * The field will be set to its default value. The hasRWifi_SSID()
     * method will return false.
     */
    inline void clearRWifi_SSID();

    /**
     * Checks whether the field "rWifi_SSID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRWifi_SSID()). Otherwise it will return false.
     */
    inline bool hasRWifi_SSID () const;

    /**
     * Returns the value of the member "rWifi_SSID".
     *
     * If the meaning of "rWifi_SSID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rWifi_SSID"
     */
    inline const ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name& getRWifi_SSID () const;

    /**
     * Retrieves the value of the field "rWifi_SSID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rWifi_SSID".
     */
    inline ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name& getRWifi_SSIDMutable ();

    /**
     * Sets the value of the member "rWifi_SSID".
     *
     * If the meaning of "rWifi_SSID" isn't clear, then there should be a description here.
     *
     * @param rWifi_SSID The value which will be set
     */
    inline void setRWifi_SSID (const ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name& rWifi_SSID_);

    // API of field "u8Wifi_Client_Power"

    static const int kU8Wifi_Client_Power = 2;

    /**
     * Clears the field "u8Wifi_Client_Power".
     *
     * The field will be set to its default value. The hasU8Wifi_Client_Power()
     * method will return false.
     */
    inline void clearU8Wifi_Client_Power();

    /**
     * Checks whether the field "u8Wifi_Client_Power" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Wifi_Client_Power()). Otherwise it will return false.
     */
    inline bool hasU8Wifi_Client_Power () const;

    /**
     * Returns the value of the member "u8Wifi_Client_Power".
     *
     * If the meaning of "u8Wifi_Client_Power" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Wifi_Client_Power"
     */
    inline uint8 getU8Wifi_Client_Power () const;

    /**
     * Sets the value of the member "u8Wifi_Client_Power".
     *
     * If the meaning of "u8Wifi_Client_Power" isn't clear, then there should be a description here.
     *
     * @param u8Wifi_Client_Power The value which will be set
     */
    inline void setU8Wifi_Client_Power (uint8 u8Wifi_Client_Power_);

    static const WifiClientStateIndicationStatus &getDefaultInstance();

private:

    inline void set_has_e8Wifi_Client_Status ();

    inline void clear_has_e8Wifi_Client_Status ();

    inline void set_has_rWifi_SSID ();

    inline void clear_has_rWifi_SSID ();

    inline void set_has_u8Wifi_Client_Power ();

    inline void clear_has_u8Wifi_Client_Power ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::tcu_main_fi_types::T_e8_TCU_Wifi_Wifi_Client_Status _e8Wifi_Client_Status;

    ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name _rWifi_SSID;

    uint8 _u8Wifi_Client_Power;

};

/**
 * The start message of the method "DTMEcall"
 * Used to Test the Ecall Audio Route
 */
class DTMEcallStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DTMEcallStart ();

    /**
     * Copy constructor
     */
    inline  DTMEcallStart (const DTMEcallStart &rhs);

    /**
     * All fields constructor
     */
    inline  DTMEcallStart (::tcu_main_fi_types::T_e8_TCU_Audio_SourceActivity e8SourceActivity_);

    /**
     * Destructor
     */
    inline virtual  ~DTMEcallStart();

    /**
     * Assignment operator
     */
    inline DTMEcallStart& operator = (const DTMEcallStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DTMEcallStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DTMEcallStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DTMEcallStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DTMEcallStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8SourceActivity"

    static const int kE8SourceActivity = 0;

    /**
     * Clears the field "e8SourceActivity".
     *
     * The field will be set to its default value. The hasE8SourceActivity()
     * method will return false.
     */
    inline void clearE8SourceActivity();

    /**
     * Checks whether the field "e8SourceActivity" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8SourceActivity()). Otherwise it will return false.
     */
    inline bool hasE8SourceActivity () const;

    /**
     * Returns the value of the member "e8SourceActivity".
     *
     * If the meaning of "e8SourceActivity" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8SourceActivity"
     */
    inline ::tcu_main_fi_types::T_e8_TCU_Audio_SourceActivity getE8SourceActivity () const;

    /**
     * Sets the value of the member "e8SourceActivity".
     *
     * If the meaning of "e8SourceActivity" isn't clear, then there should be a description here.
     *
     * @param e8SourceActivity The value which will be set
     */
    inline void setE8SourceActivity (::tcu_main_fi_types::T_e8_TCU_Audio_SourceActivity e8SourceActivity_);

    static const DTMEcallStart &getDefaultInstance();

private:

    inline void set_has_e8SourceActivity ();

    inline void clear_has_e8SourceActivity ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tcu_main_fi_types::T_e8_TCU_Audio_SourceActivity _e8SourceActivity;

};

/**
 * The error message of 'DTMEcall'
 * Error Message
 */
class DTMEcallErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DTMEcallErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DTMEcallErrorStructure (const DTMEcallErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DTMEcallErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~DTMEcallErrorStructure();

    /**
     * Assignment operator
     */
    inline DTMEcallErrorStructure& operator = (const DTMEcallErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DTMEcallErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DTMEcallErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DTMEcallErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DTMEcallErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const DTMEcallErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'DTMEcall'
 * Error Message
 */
class DTMEcallError  : public ::asf::core::Payload {
public:

    enum DTMEcallErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DTMEcallError ();

   /**
     * Copy constructor
     */
    inline  DTMEcallError (const DTMEcallError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DTMEcallError();

    /**
     * Assigns a new value to this object.
     */
    inline DTMEcallError& operator = (const DTMEcallError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DTMEcallError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DTMEcallError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DTMEcallError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DTMEcallError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DTMEcallError::DTMEcallErrorField getField () const;

    inline void setField(DTMEcallError::DTMEcallErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DTMEcallErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DTMEcallErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DTMEcallErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DTMEcallErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DTMEcallErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DTMEcallErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DTMEcallErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DTMEcallErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DTMEcallError &getDefaultInstance();

private:

    inline void cloneData (const DTMEcallError& rhs);

    inline void deleteData ();

    DTMEcallErrorField __field;

    union {
        DTMEcallErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "HardwareVersion"
 * This property gives information about the hardware version of the TCU(MCAN Fct Id:010h).
 */
class HardwareVersionStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  HardwareVersionStatus ();

    /**
     * Copy constructor
     */
    inline  HardwareVersionStatus (const HardwareVersionStatus &rhs);

    /**
     * All fields constructor
     */
    inline  HardwareVersionStatus (const ::tcu_main_fi_types::T_TCU_VersionInfo& rHardwareVersion_);

    /**
     * Destructor
     */
    inline virtual  ~HardwareVersionStatus();

    /**
     * Assignment operator
     */
    inline HardwareVersionStatus& operator = (const HardwareVersionStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HardwareVersionStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HardwareVersionStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HardwareVersionStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HardwareVersionStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "rHardwareVersion"

    static const int kRHardwareVersion = 0;

    /**
     * Clears the field "rHardwareVersion".
     *
     * The field will be set to its default value. The hasRHardwareVersion()
     * method will return false.
     */
    inline void clearRHardwareVersion();

    /**
     * Checks whether the field "rHardwareVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRHardwareVersion()). Otherwise it will return false.
     */
    inline bool hasRHardwareVersion () const;

    /**
     * Returns the value of the member "rHardwareVersion".
     *
     * If the meaning of "rHardwareVersion" isn't clear, then there should be a description here.
     *
     * @return The value of the field "rHardwareVersion"
     */
    inline const ::tcu_main_fi_types::T_TCU_VersionInfo& getRHardwareVersion () const;

    /**
     * Retrieves the value of the field "rHardwareVersion" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rHardwareVersion".
     */
    inline ::tcu_main_fi_types::T_TCU_VersionInfo& getRHardwareVersionMutable ();

    /**
     * Sets the value of the member "rHardwareVersion".
     *
     * If the meaning of "rHardwareVersion" isn't clear, then there should be a description here.
     *
     * @param rHardwareVersion The value which will be set
     */
    inline void setRHardwareVersion (const ::tcu_main_fi_types::T_TCU_VersionInfo& rHardwareVersion_);

    static const HardwareVersionStatus &getDefaultInstance();

private:

    inline void set_has_rHardwareVersion ();

    inline void clear_has_rHardwareVersion ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tcu_main_fi_types::T_TCU_VersionInfo _rHardwareVersion;

};

/**
 * The status message of the property "SoftwareVersion"
 * This property gives information about the software version of the TCU(MCAN Fct Id:011h).
 */
class SoftwareVersionStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SoftwareVersionStatus ();

    /**
     * Copy constructor
     */
    inline  SoftwareVersionStatus (const SoftwareVersionStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SoftwareVersionStatus (const ::tcu_main_fi_types::T_TCU_VersionInfo& rSoftwareVersion_);

    /**
     * Destructor
     */
    inline virtual  ~SoftwareVersionStatus();

    /**
     * Assignment operator
     */
    inline SoftwareVersionStatus& operator = (const SoftwareVersionStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SoftwareVersionStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SoftwareVersionStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SoftwareVersionStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the typ