/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_FREEDESKTOP_SYSTEMD1_UNITPROXY_H
#define ORG_FREEDESKTOP_SYSTEMD1_UNITPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "org/freedesktop/systemd1/Unit.h"
#include <dbus/dbus.h>
#include <string>
#include <vector>

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

class UnitProxy;

class ActiveEnterTimestampCallbackIF {
public:
    virtual ~ActiveEnterTimestampCallbackIF() {}

    virtual void onActiveEnterTimestampError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< ActiveEnterTimestampError >& error) = 0;

    virtual void onActiveEnterTimestampUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< ActiveEnterTimestampUpdate >& update) = 0;
};

class ActiveEnterTimestampMonotonicCallbackIF {
public:
    virtual ~ActiveEnterTimestampMonotonicCallbackIF() {}

    virtual void onActiveEnterTimestampMonotonicError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< ActiveEnterTimestampMonotonicError >& error) = 0;

    virtual void onActiveEnterTimestampMonotonicUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< ActiveEnterTimestampMonotonicUpdate >& update) = 0;
};

class ActiveExitTimestampCallbackIF {
public:
    virtual ~ActiveExitTimestampCallbackIF() {}

    virtual void onActiveExitTimestampError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< ActiveExitTimestampError >& error) = 0;

    virtual void onActiveExitTimestampUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< ActiveExitTimestampUpdate >& update) = 0;
};

class ActiveExitTimestampMonotonicCallbackIF {
public:
    virtual ~ActiveExitTimestampMonotonicCallbackIF() {}

    virtual void onActiveExitTimestampMonotonicError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< ActiveExitTimestampMonotonicError >& error) = 0;

    virtual void onActiveExitTimestampMonotonicUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< ActiveExitTimestampMonotonicUpdate >& update) = 0;
};

class ActiveStateCallbackIF {
public:
    virtual ~ActiveStateCallbackIF() {}

    virtual void onActiveStateError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< ActiveStateError >& error) = 0;

    virtual void onActiveStateUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< ActiveStateUpdate >& update) = 0;
};

class AfterCallbackIF {
public:
    virtual ~AfterCallbackIF() {}

    virtual void onAfterError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< AfterError >& error) = 0;

    virtual void onAfterUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< AfterUpdate >& update) = 0;
};

class AllowIsolateCallbackIF {
public:
    virtual ~AllowIsolateCallbackIF() {}

    virtual void onAllowIsolateError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< AllowIsolateError >& error) = 0;

    virtual void onAllowIsolateUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< AllowIsolateUpdate >& update) = 0;
};

class AssertResultCallbackIF {
public:
    virtual ~AssertResultCallbackIF() {}

    virtual void onAssertResultError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< AssertResultError >& error) = 0;

    virtual void onAssertResultUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< AssertResultUpdate >& update) = 0;
};

class AssertTimestampCallbackIF {
public:
    virtual ~AssertTimestampCallbackIF() {}

    virtual void onAssertTimestampError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< AssertTimestampError >& error) = 0;

    virtual void onAssertTimestampUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< AssertTimestampUpdate >& update) = 0;
};

class AssertTimestampMonotonicCallbackIF {
public:
    virtual ~AssertTimestampMonotonicCallbackIF() {}

    virtual void onAssertTimestampMonotonicError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< AssertTimestampMonotonicError >& error) = 0;

    virtual void onAssertTimestampMonotonicUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< AssertTimestampMonotonicUpdate >& update) = 0;
};

class AssertsCallbackIF {
public:
    virtual ~AssertsCallbackIF() {}

    virtual void onAssertsError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< AssertsError >& error) = 0;

    virtual void onAssertsUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< AssertsUpdate >& update) = 0;
};

class BeforeCallbackIF {
public:
    virtual ~BeforeCallbackIF() {}

    virtual void onBeforeError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< BeforeError >& error) = 0;

    virtual void onBeforeUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< BeforeUpdate >& update) = 0;
};

class BindsToCallbackIF {
public:
    virtual ~BindsToCallbackIF() {}

    virtual void onBindsToError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< BindsToError >& error) = 0;

    virtual void onBindsToUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< BindsToUpdate >& update) = 0;
};

class BoundByCallbackIF {
public:
    virtual ~BoundByCallbackIF() {}

    virtual void onBoundByError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< BoundByError >& error) = 0;

    virtual void onBoundByUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< BoundByUpdate >& update) = 0;
};

class CanIsolateCallbackIF {
public:
    virtual ~CanIsolateCallbackIF() {}

    virtual void onCanIsolateError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< CanIsolateError >& error) = 0;

    virtual void onCanIsolateUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< CanIsolateUpdate >& update) = 0;
};

class CanReloadCallbackIF {
public:
    virtual ~CanReloadCallbackIF() {}

    virtual void onCanReloadError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< CanReloadError >& error) = 0;

    virtual void onCanReloadUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< CanReloadUpdate >& update) = 0;
};

class CanStartCallbackIF {
public:
    virtual ~CanStartCallbackIF() {}

    virtual void onCanStartError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< CanStartError >& error) = 0;

    virtual void onCanStartUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< CanStartUpdate >& update) = 0;
};

class CanStopCallbackIF {
public:
    virtual ~CanStopCallbackIF() {}

    virtual void onCanStopError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< CanStopError >& error) = 0;

    virtual void onCanStopUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< CanStopUpdate >& update) = 0;
};

class ConditionResultCallbackIF {
public:
    virtual ~ConditionResultCallbackIF() {}

    virtual void onConditionResultError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< ConditionResultError >& error) = 0;

    virtual void onConditionResultUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< ConditionResultUpdate >& update) = 0;
};

class ConditionTimestampCallbackIF {
public:
    virtual ~ConditionTimestampCallbackIF() {}

    virtual void onConditionTimestampError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< ConditionTimestampError >& error) = 0;

    virtual void onConditionTimestampUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< ConditionTimestampUpdate >& update) = 0;
};

class ConditionTimestampMonotonicCallbackIF {
public:
    virtual ~ConditionTimestampMonotonicCallbackIF() {}

    virtual void onConditionTimestampMonotonicError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< ConditionTimestampMonotonicError >& error) = 0;

    virtual void onConditionTimestampMonotonicUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< ConditionTimestampMonotonicUpdate >& update) = 0;
};

class ConditionsCallbackIF {
public:
    virtual ~ConditionsCallbackIF() {}

    virtual void onConditionsError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< ConditionsError >& error) = 0;

    virtual void onConditionsUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< ConditionsUpdate >& update) = 0;
};

class ConflictedByCallbackIF {
public:
    virtual ~ConflictedByCallbackIF() {}

    virtual void onConflictedByError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< ConflictedByError >& error) = 0;

    virtual void onConflictedByUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< ConflictedByUpdate >& update) = 0;
};

class ConflictsCallbackIF {
public:
    virtual ~ConflictsCallbackIF() {}

    virtual void onConflictsError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< ConflictsError >& error) = 0;

    virtual void onConflictsUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< ConflictsUpdate >& update) = 0;
};

class ConsistsOfCallbackIF {
public:
    virtual ~ConsistsOfCallbackIF() {}

    virtual void onConsistsOfError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< ConsistsOfError >& error) = 0;

    virtual void onConsistsOfUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< ConsistsOfUpdate >& update) = 0;
};

class DefaultDependenciesCallbackIF {
public:
    virtual ~DefaultDependenciesCallbackIF() {}

    virtual void onDefaultDependenciesError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< DefaultDependenciesError >& error) = 0;

    virtual void onDefaultDependenciesUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< DefaultDependenciesUpdate >& update) = 0;
};

class DescriptionCallbackIF {
public:
    virtual ~DescriptionCallbackIF() {}

    virtual void onDescriptionError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< DescriptionError >& error) = 0;

    virtual void onDescriptionUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< DescriptionUpdate >& update) = 0;
};

class DocumentationCallbackIF {
public:
    virtual ~DocumentationCallbackIF() {}

    virtual void onDocumentationError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< DocumentationError >& error) = 0;

    virtual void onDocumentationUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< DocumentationUpdate >& update) = 0;
};

class DropInPathsCallbackIF {
public:
    virtual ~DropInPathsCallbackIF() {}

    virtual void onDropInPathsError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< DropInPathsError >& error) = 0;

    virtual void onDropInPathsUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< DropInPathsUpdate >& update) = 0;
};

class FollowingCallbackIF {
public:
    virtual ~FollowingCallbackIF() {}

    virtual void onFollowingError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< FollowingError >& error) = 0;

    virtual void onFollowingUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< FollowingUpdate >& update) = 0;
};

class FragmentPathCallbackIF {
public:
    virtual ~FragmentPathCallbackIF() {}

    virtual void onFragmentPathError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< FragmentPathError >& error) = 0;

    virtual void onFragmentPathUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< FragmentPathUpdate >& update) = 0;
};

class IdCallbackIF {
public:
    virtual ~IdCallbackIF() {}

    virtual void onIdError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< IdError >& error) = 0;

    virtual void onIdUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< IdUpdate >& update) = 0;
};

class IgnoreOnIsolateCallbackIF {
public:
    virtual ~IgnoreOnIsolateCallbackIF() {}

    virtual void onIgnoreOnIsolateError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< IgnoreOnIsolateError >& error) = 0;

    virtual void onIgnoreOnIsolateUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< IgnoreOnIsolateUpdate >& update) = 0;
};

class IgnoreOnSnapshotCallbackIF {
public:
    virtual ~IgnoreOnSnapshotCallbackIF() {}

    virtual void onIgnoreOnSnapshotError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< IgnoreOnSnapshotError >& error) = 0;

    virtual void onIgnoreOnSnapshotUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< IgnoreOnSnapshotUpdate >& update) = 0;
};

class InactiveEnterTimestampCallbackIF {
public:
    virtual ~InactiveEnterTimestampCallbackIF() {}

    virtual void onInactiveEnterTimestampError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< InactiveEnterTimestampError >& error) = 0;

    virtual void onInactiveEnterTimestampUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< InactiveEnterTimestampUpdate >& update) = 0;
};

class InactiveEnterTimestampMonotonicCallbackIF {
public:
    virtual ~InactiveEnterTimestampMonotonicCallbackIF() {}

    virtual void onInactiveEnterTimestampMonotonicError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< InactiveEnterTimestampMonotonicError >& error) = 0;

    virtual void onInactiveEnterTimestampMonotonicUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< InactiveEnterTimestampMonotonicUpdate >& update) = 0;
};

class InactiveExitTimestampCallbackIF {
public:
    virtual ~InactiveExitTimestampCallbackIF() {}

    virtual void onInactiveExitTimestampError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< InactiveExitTimestampError >& error) = 0;

    virtual void onInactiveExitTimestampUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< InactiveExitTimestampUpdate >& update) = 0;
};

class InactiveExitTimestampMonotonicCallbackIF {
public:
    virtual ~InactiveExitTimestampMonotonicCallbackIF() {}

    virtual void onInactiveExitTimestampMonotonicError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< InactiveExitTimestampMonotonicError >& error) = 0;

    virtual void onInactiveExitTimestampMonotonicUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< InactiveExitTimestampMonotonicUpdate >& update) = 0;
};

class JobCallbackIF {
public:
    virtual ~JobCallbackIF() {}

    virtual void onJobError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< JobError >& error) = 0;

    virtual void onJobUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< JobUpdate >& update) = 0;
};

class JobTimeoutActionCallbackIF {
public:
    virtual ~JobTimeoutActionCallbackIF() {}

    virtual void onJobTimeoutActionError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< JobTimeoutActionError >& error) = 0;

    virtual void onJobTimeoutActionUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< JobTimeoutActionUpdate >& update) = 0;
};

class JobTimeoutRebootArgumentCallbackIF {
public:
    virtual ~JobTimeoutRebootArgumentCallbackIF() {}

    virtual void onJobTimeoutRebootArgumentError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< JobTimeoutRebootArgumentError >& error) = 0;

    virtual void onJobTimeoutRebootArgumentUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< JobTimeoutRebootArgumentUpdate >& update) = 0;
};

class JobTimeoutUSecCallbackIF {
public:
    virtual ~JobTimeoutUSecCallbackIF() {}

    virtual void onJobTimeoutUSecError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< JobTimeoutUSecError >& error) = 0;

    virtual void onJobTimeoutUSecUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< JobTimeoutUSecUpdate >& update) = 0;
};

class JoinsNamespaceOfCallbackIF {
public:
    virtual ~JoinsNamespaceOfCallbackIF() {}

    virtual void onJoinsNamespaceOfError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< JoinsNamespaceOfError >& error) = 0;

    virtual void onJoinsNamespaceOfUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< JoinsNamespaceOfUpdate >& update) = 0;
};

class KillCallbackIF {
public:
    virtual ~KillCallbackIF() {}

    virtual void onKillError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< KillError >& error) = 0;

    virtual void onKillResponse(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< KillResponse >& response) = 0;
};

class LoadErrorCallbackIF {
public:
    virtual ~LoadErrorCallbackIF() {}

    virtual void onLoadErrorError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< LoadErrorError >& error) = 0;

    virtual void onLoadErrorUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< LoadErrorUpdate >& update) = 0;
};

class LoadStateCallbackIF {
public:
    virtual ~LoadStateCallbackIF() {}

    virtual void onLoadStateError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< LoadStateError >& error) = 0;

    virtual void onLoadStateUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< LoadStateUpdate >& update) = 0;
};

class NamesCallbackIF {
public:
    virtual ~NamesCallbackIF() {}

    virtual void onNamesError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< NamesError >& error) = 0;

    virtual void onNamesUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< NamesUpdate >& update) = 0;
};

class NeedDaemonReloadCallbackIF {
public:
    virtual ~NeedDaemonReloadCallbackIF() {}

    virtual void onNeedDaemonReloadError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< NeedDaemonReloadError >& error) = 0;

    virtual void onNeedDaemonReloadUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< NeedDaemonReloadUpdate >& update) = 0;
};

class OnFailureCallbackIF {
public:
    virtual ~OnFailureCallbackIF() {}

    virtual void onOnFailureError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< OnFailureError >& error) = 0;

    virtual void onOnFailureUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< OnFailureUpdate >& update) = 0;
};

class OnFailureJobModeCallbackIF {
public:
    virtual ~OnFailureJobModeCallbackIF() {}

    virtual void onOnFailureJobModeError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< OnFailureJobModeError >& error) = 0;

    virtual void onOnFailureJobModeUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< OnFailureJobModeUpdate >& update) = 0;
};

class PartOfCallbackIF {
public:
    virtual ~PartOfCallbackIF() {}

    virtual void onPartOfError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< PartOfError >& error) = 0;

    virtual void onPartOfUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< PartOfUpdate >& update) = 0;
};

class PropagatesReloadToCallbackIF {
public:
    virtual ~PropagatesReloadToCallbackIF() {}

    virtual void onPropagatesReloadToError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< PropagatesReloadToError >& error) = 0;

    virtual void onPropagatesReloadToUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< PropagatesReloadToUpdate >& update) = 0;
};

class RefuseManualStartCallbackIF {
public:
    virtual ~RefuseManualStartCallbackIF() {}

    virtual void onRefuseManualStartError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< RefuseManualStartError >& error) = 0;

    virtual void onRefuseManualStartUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< RefuseManualStartUpdate >& update) = 0;
};

class RefuseManualStopCallbackIF {
public:
    virtual ~RefuseManualStopCallbackIF() {}

    virtual void onRefuseManualStopError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< RefuseManualStopError >& error) = 0;

    virtual void onRefuseManualStopUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< RefuseManualStopUpdate >& update) = 0;
};

class ReloadCallbackIF {
public:
    virtual ~ReloadCallbackIF() {}

    virtual void onReloadError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< ReloadError >& error) = 0;

    virtual void onReloadResponse(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< ReloadResponse >& response) = 0;
};

class ReloadOrRestartCallbackIF {
public:
    virtual ~ReloadOrRestartCallbackIF() {}

    virtual void onReloadOrRestartError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< ReloadOrRestartError >& error) = 0;

    virtual void onReloadOrRestartResponse(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< ReloadOrRestartResponse >& response) = 0;
};

class ReloadOrTryRestartCallbackIF {
public:
    virtual ~ReloadOrTryRestartCallbackIF() {}

    virtual void onReloadOrTryRestartError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< ReloadOrTryRestartError >& error) = 0;

    virtual void onReloadOrTryRestartResponse(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< ReloadOrTryRestartResponse >& response) = 0;
};

class ReloadPropagatedFromCallbackIF {
public:
    virtual ~ReloadPropagatedFromCallbackIF() {}

    virtual void onReloadPropagatedFromError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< ReloadPropagatedFromError >& error) = 0;

    virtual void onReloadPropagatedFromUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< ReloadPropagatedFromUpdate >& update) = 0;
};

class RequiredByCallbackIF {
public:
    virtual ~RequiredByCallbackIF() {}

    virtual void onRequiredByError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< RequiredByError >& error) = 0;

    virtual void onRequiredByUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< RequiredByUpdate >& update) = 0;
};

class RequiredByOverridableCallbackIF {
public:
    virtual ~RequiredByOverridableCallbackIF() {}

    virtual void onRequiredByOverridableError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< RequiredByOverridableError >& error) = 0;

    virtual void onRequiredByOverridableUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< RequiredByOverridableUpdate >& update) = 0;
};

class RequiresCallbackIF {
public:
    virtual ~RequiresCallbackIF() {}

    virtual void onRequiresError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< RequiresError >& error) = 0;

    virtual void onRequiresUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< RequiresUpdate >& update) = 0;
};

class RequiresMountsForCallbackIF {
public:
    virtual ~RequiresMountsForCallbackIF() {}

    virtual void onRequiresMountsForError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< RequiresMountsForError >& error) = 0;

    virtual void onRequiresMountsForUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< RequiresMountsForUpdate >& update) = 0;
};

class RequiresOverridableCallbackIF {
public:
    virtual ~RequiresOverridableCallbackIF() {}

    virtual void onRequiresOverridableError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< RequiresOverridableError >& error) = 0;

    virtual void onRequiresOverridableUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< RequiresOverridableUpdate >& update) = 0;
};

class RequisiteCallbackIF {
public:
    virtual ~RequisiteCallbackIF() {}

    virtual void onRequisiteError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< RequisiteError >& error) = 0;

    virtual void onRequisiteUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< RequisiteUpdate >& update) = 0;
};

class RequisiteOfCallbackIF {
public:
    virtual ~RequisiteOfCallbackIF() {}

    virtual void onRequisiteOfError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< RequisiteOfError >& error) = 0;

    virtual void onRequisiteOfUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< RequisiteOfUpdate >& update) = 0;
};

class RequisiteOfOverridableCallbackIF {
public:
    virtual ~RequisiteOfOverridableCallbackIF() {}

    virtual void onRequisiteOfOverridableError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< RequisiteOfOverridableError >& error) = 0;

    virtual void onRequisiteOfOverridableUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< RequisiteOfOverridableUpdate >& update) = 0;
};

class RequisiteOverridableCallbackIF {
public:
    virtual ~RequisiteOverridableCallbackIF() {}

    virtual void onRequisiteOverridableError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< RequisiteOverridableError >& error) = 0;

    virtual void onRequisiteOverridableUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< RequisiteOverridableUpdate >& update) = 0;
};

class ResetFailedCallbackIF {
public:
    virtual ~ResetFailedCallbackIF() {}

    virtual void onResetFailedError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< ResetFailedError >& error) = 0;

    virtual void onResetFailedResponse(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< ResetFailedResponse >& response) = 0;
};

class RestartCallbackIF {
public:
    virtual ~RestartCallbackIF() {}

    virtual void onRestartError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< RestartError >& error) = 0;

    virtual void onRestartResponse(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< RestartResponse >& response) = 0;
};

class SetPropertiesCallbackIF {
public:
    virtual ~SetPropertiesCallbackIF() {}

    virtual void onSetPropertiesError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< SetPropertiesError >& error) = 0;

    virtual void onSetPropertiesResponse(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< SetPropertiesResponse >& response) = 0;
};

class SourcePathCallbackIF {
public:
    virtual ~SourcePathCallbackIF() {}

    virtual void onSourcePathError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< SourcePathError >& error) = 0;

    virtual void onSourcePathUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< SourcePathUpdate >& update) = 0;
};

class StartCallbackIF {
public:
    virtual ~StartCallbackIF() {}

    virtual void onStartError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< StartError >& error) = 0;

    virtual void onStartResponse(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< StartResponse >& response) = 0;
};

class StopCallbackIF {
public:
    virtual ~StopCallbackIF() {}

    virtual void onStopError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< StopError >& error) = 0;

    virtual void onStopResponse(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< StopResponse >& response) = 0;
};

class StopWhenUnneededCallbackIF {
public:
    virtual ~StopWhenUnneededCallbackIF() {}

    virtual void onStopWhenUnneededError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< StopWhenUnneededError >& error) = 0;

    virtual void onStopWhenUnneededUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< StopWhenUnneededUpdate >& update) = 0;
};

class SubStateCallbackIF {
public:
    virtual ~SubStateCallbackIF() {}

    virtual void onSubStateError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< SubStateError >& error) = 0;

    virtual void onSubStateUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< SubStateUpdate >& update) = 0;
};

class TransientCallbackIF {
public:
    virtual ~TransientCallbackIF() {}

    virtual void onTransientError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< TransientError >& error) = 0;

    virtual void onTransientUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< TransientUpdate >& update) = 0;
};

class TriggeredByCallbackIF {
public:
    virtual ~TriggeredByCallbackIF() {}

    virtual void onTriggeredByError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< TriggeredByError >& error) = 0;

    virtual void onTriggeredByUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< TriggeredByUpdate >& update) = 0;
};

class TriggersCallbackIF {
public:
    virtual ~TriggersCallbackIF() {}

    virtual void onTriggersError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< TriggersError >& error) = 0;

    virtual void onTriggersUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< TriggersUpdate >& update) = 0;
};

class TryRestartCallbackIF {
public:
    virtual ~TryRestartCallbackIF() {}

    virtual void onTryRestartError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< TryRestartError >& error) = 0;

    virtual void onTryRestartResponse(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< TryRestartResponse >& response) = 0;
};

class UnitFilePresetCallbackIF {
public:
    virtual ~UnitFilePresetCallbackIF() {}

    virtual void onUnitFilePresetError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< UnitFilePresetError >& error) = 0;

    virtual void onUnitFilePresetUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< UnitFilePresetUpdate >& update) = 0;
};

class UnitFileStateCallbackIF {
public:
    virtual ~UnitFileStateCallbackIF() {}

    virtual void onUnitFileStateError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< UnitFileStateError >& error) = 0;

    virtual void onUnitFileStateUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< UnitFileStateUpdate >& update) = 0;
};

class WantedByCallbackIF {
public:
    virtual ~WantedByCallbackIF() {}

    virtual void onWantedByError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< WantedByError >& error) = 0;

    virtual void onWantedByUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< WantedByUpdate >& update) = 0;
};

class WantsCallbackIF {
public:
    virtual ~WantsCallbackIF() {}

    virtual void onWantsError(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< WantsError >& error) = 0;

    virtual void onWantsUpdate(const ::boost::shared_ptr< UnitProxy >& proxy, const ::boost::shared_ptr< WantsUpdate >& update) = 0;
};


/**
 * UnitProxy is the client side representation of the D-Bus service
 * interface 'org.freedesktop.systemd1.Unit' (specified in file
 * DBusUnit_.xml).
 *
 * org.freedesktop.systemd1.Unit:
 *     short_description: All Unit objects implement the generic org.freedesktop.systemd1.Unit interface.
 *     Depending on the unit type they also implement one unit-type-specific interface.
 */
class UnitProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of UnitProxy.
     */
    static ::boost::shared_ptr< UnitProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of UnitProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< UnitProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of UnitProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< UnitProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< UnitProxy > proxyNew(new UnitProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(true);
        return proxyNew;
    }

    virtual ~UnitProxy ();



    // Property 'Id'

    /**
     * Notify on the property 'Id'. This method registers for property changes
     * by D-Bus service.
     *
     * <b>Documentation of 'Id'</b>:
     *
     * Id contains the primary name of the unit
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendIdRegister(IdCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Id'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Id'</b>:
     *
     * Id contains the primary name of the unit
     *
     * @param act The act which was previously returned by the
     * sendIdRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendIdDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Id'.
     */
    void sendIdDeregisterAll() const;

    /**
     * Request the value of the property 'Id' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Id'</b>:
     *
     * Id contains the primary name of the unit
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendIdGet(IdCallbackIF& cb);


    /**
     * Returns the current value of the property 'Id' (as known by the proxy).
     * This method is only allowed to be called when a status message for this
     * property was received before. Otherwise the behavior of this method is
     * undefined. It is safe to call this method when hasId() returns true.
     *
     * @return the previously received value of the property 'Id'.
     */
    const ::std::string& getId() const;

    /**
     * Determines whether a status message for the property 'Id' was received
     * before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasId() const;

    // Property 'Names'

    /**
     * Notify on the property 'Names'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Names'</b>:
     *
     * Names contains all names of the unit, including the primary name that is also exposed in Id.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNamesRegister(NamesCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Names'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Names'</b>:
     *
     * Names contains all names of the unit, including the primary name that is also exposed in Id.
     *
     * @param act The act which was previously returned by the
     * sendNamesRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendNamesDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Names'.
     */
    void sendNamesDeregisterAll() const;

    /**
     * Request the value of the property 'Names' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Names'</b>:
     *
     * Names contains all names of the unit, including the primary name that is also exposed in Id.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNamesGet(NamesCallbackIF& cb);


    /**
     * Returns the current value of the property 'Names' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasNames()
     * returns true.
     *
     * @return the previously received value of the property 'Names'.
     */
    const ::std::vector< ::std::string >& getNames() const;

    /**
     * Determines whether a status message for the property 'Names' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasNames() const;

    // Property 'Following'

    /**
     * Notify on the property 'Following'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Following'</b>:
     *
     * Following either contains the empty string or contains the name of another unit that this
     * 		unit follows in state. This is used for some device units which reflect the unit state machine of another
     * 		unit, and which other unit this is might possibly change.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFollowingRegister(FollowingCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Following'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Following'</b>:
     *
     * Following either contains the empty string or contains the name of another unit that this
     * 		unit follows in state. This is used for some device units which reflect the unit state machine of another
     * 		unit, and which other unit this is might possibly change.
     *
     * @param act The act which was previously returned by the
     * sendFollowingRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendFollowingDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Following'.
     */
    void sendFollowingDeregisterAll() const;

    /**
     * Request the value of the property 'Following' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Following'</b>:
     *
     * Following either contains the empty string or contains the name of another unit that this
     * 		unit follows in state. This is used for some device units which reflect the unit state machine of another
     * 		unit, and which other unit this is might possibly change.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFollowingGet(FollowingCallbackIF& cb);


    /**
     * Returns the current value of the property 'Following' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasFollowing()
     * returns true.
     *
     * @return the previously received value of the property 'Following'.
     */
    const ::std::string& getFollowing() const;

    /**
     * Determines whether a status message for the property 'Following' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasFollowing() const;

    // Property 'Requires'

    /**
     * Notify on the property 'Requires'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Requires'</b>:
     *
     * Requires contain arrays which encode the dependencies and their inverse dependencies
     * 		(where this applies), as configured in the unit file or determined automatically.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRequiresRegister(RequiresCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Requires'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Requires'</b>:
     *
     * Requires contain arrays which encode the dependencies and their inverse dependencies
     * 		(where this applies), as configured in the unit file or determined automatically.
     *
     * @param act The act which was previously returned by the
     * sendRequiresRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendRequiresDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Requires'.
     */
    void sendRequiresDeregisterAll() const;

    /**
     * Request the value of the property 'Requires' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Requires'</b>:
     *
     * Requires contain arrays which encode the dependencies and their inverse dependencies
     * 		(where this applies), as configured in the unit file or determined automatically.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRequiresGet(RequiresCallbackIF& cb);


    /**
     * Returns the current value of the property 'Requires' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasRequires()
     * returns true.
     *
     * @return the previously received value of the property 'Requires'.
     */
    const ::std::vector< ::std::string >& getRequires() const;

    /**
     * Determines whether a status message for the property 'Requires' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasRequires() const;

    // Property 'RequiresOverridable'

    /**
     * Notify on the property 'RequiresOverridable'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'RequiresOverridable'</b>:
     *
     * RequiresOverridable
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRequiresOverridableRegister(RequiresOverridableCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'RequiresOverridable'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'RequiresOverridable'</b>:
     *
     * RequiresOverridable
     *
     * @param act The act which was previously returned by the
     * sendRequiresOverridableRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendRequiresOverridableDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'RequiresOverridable'.
     */
    void sendRequiresOverridableDeregisterAll() const;

    /**
     * Request the value of the property 'RequiresOverridable' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'RequiresOverridable'</b>:
     *
     * RequiresOverridable
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRequiresOverridableGet(RequiresOverridableCallbackIF& cb);


    /**
     * Returns the current value of the property 'RequiresOverridable' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasRequiresOverridable() returns true.
     *
     * @return the previously received value of the property 'RequiresOverridable'.
     */
    const ::std::vector< ::std::string >& getRequiresOverridable() const;

    /**
     * Determines whether a status message for the property
     * 'RequiresOverridable' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasRequiresOverridable() const;

    // Property 'Requisite'

    /**
     * Notify on the property 'Requisite'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Requisite'</b>:
     *
     * Requisite
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRequisiteRegister(RequisiteCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Requisite'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Requisite'</b>:
     *
     * Requisite
     *
     * @param act The act which was previously returned by the
     * sendRequisiteRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendRequisiteDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Requisite'.
     */
    void sendRequisiteDeregisterAll() const;

    /**
     * Request the value of the property 'Requisite' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Requisite'</b>:
     *
     * Requisite
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRequisiteGet(RequisiteCallbackIF& cb);


    /**
     * Returns the current value of the property 'Requisite' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasRequisite()
     * returns true.
     *
     * @return the previously received value of the property 'Requisite'.
     */
    const ::std::vector< ::std::string >& getRequisite() const;

    /**
     * Determines whether a status message for the property 'Requisite' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasRequisite() const;

    // Property 'RequisiteOverridable'

    /**
     * Notify on the property 'RequisiteOverridable'. This method registers
     * for property changes by D-Bus service.
     *
     * <b>Documentation of 'RequisiteOverridable'</b>:
     *
     * RequisiteOverridable
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRequisiteOverridableRegister(RequisiteOverridableCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'RequisiteOverridable'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'RequisiteOverridable'</b>:
     *
     * RequisiteOverridable
     *
     * @param act The act which was previously returned by the
     * sendRequisiteOverridableRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendRequisiteOverridableDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'RequisiteOverridable'.
     */
    void sendRequisiteOverridableDeregisterAll() const;

    /**
     * Request the value of the property 'RequisiteOverridable' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'RequisiteOverridable'</b>:
     *
     * RequisiteOverridable
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRequisiteOverridableGet(RequisiteOverridableCallbackIF& cb);


    /**
     * Returns the current value of the property 'RequisiteOverridable' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasRequisiteOverridable() returns true.
     *
     * @return the previously received value of the property 'RequisiteOverridable'.
     */
    const ::std::vector< ::std::string >& getRequisiteOverridable() const;

    /**
     * Determines whether a status message for the property
     * 'RequisiteOverridable' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasRequisiteOverridable() const;

    // Property 'Wants'

    /**
     * Notify on the property 'Wants'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Wants'</b>:
     *
     * Wants
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendWantsRegister(WantsCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Wants'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Wants'</b>:
     *
     * Wants
     *
     * @param act The act which was previously returned by the
     * sendWantsRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendWantsDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Wants'.
     */
    void sendWantsDeregisterAll() const;

    /**
     * Request the value of the property 'Wants' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Wants'</b>:
     *
     * Wants
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendWantsGet(WantsCallbackIF& cb);


    /**
     * Returns the current value of the property 'Wants' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasWants()
     * returns true.
     *
     * @return the previously received value of the property 'Wants'.
     */
    const ::std::vector< ::std::string >& getWants() const;

    /**
     * Determines whether a status message for the property 'Wants' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasWants() const;

    // Property 'BindsTo'

    /**
     * Notify on the property 'BindsTo'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'BindsTo'</b>:
     *
     * BindsTo
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBindsToRegister(BindsToCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'BindsTo'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'BindsTo'</b>:
     *
     * BindsTo
     *
     * @param act The act which was previously returned by the
     * sendBindsToRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendBindsToDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'BindsTo'.
     */
    void sendBindsToDeregisterAll() const;

    /**
     * Request the value of the property 'BindsTo' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'BindsTo'</b>:
     *
     * BindsTo
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBindsToGet(BindsToCallbackIF& cb);


    /**
     * Returns the current value of the property 'BindsTo' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasBindsTo()
     * returns true.
     *
     * @return the previously received value of the property 'BindsTo'.
     */
    const ::std::vector< ::std::string >& getBindsTo() const;

    /**
     * Determines whether a status message for the property 'BindsTo' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasBindsTo() const;

    // Property 'PartOf'

    /**
     * Notify on the property 'PartOf'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'PartOf'</b>:
     *
     * PartOf
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPartOfRegister(PartOfCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'PartOf'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'PartOf'</b>:
     *
     * PartOf
     *
     * @param act The act which was previously returned by the
     * sendPartOfRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendPartOfDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'PartOf'.
     */
    void sendPartOfDeregisterAll() const;

    /**
     * Request the value of the property 'PartOf' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'PartOf'</b>:
     *
     * PartOf
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPartOfGet(PartOfCallbackIF& cb);


    /**
     * Returns the current value of the property 'PartOf' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasPartOf()
     * returns true.
     *
     * @return the previously received value of the property 'PartOf'.
     */
    const ::std::vector< ::std::string >& getPartOf() const;

    /**
     * Determines whether a status message for the property 'PartOf' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasPartOf() const;

    // Property 'RequiredBy'

    /**
     * Notify on the property 'RequiredBy'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'RequiredBy'</b>:
     *
     * RequiredBy
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRequiredByRegister(RequiredByCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'RequiredBy'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'RequiredBy'</b>:
     *
     * RequiredBy
     *
     * @param act The act which was previously returned by the
     * sendRequiredByRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendRequiredByDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'RequiredBy'.
     */
    void sendRequiredByDeregisterAll() const;

    /**
     * Request the value of the property 'RequiredBy' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'RequiredBy'</b>:
     *
     * RequiredBy
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRequiredByGet(RequiredByCallbackIF& cb);


    /**
     * Returns the current value of the property 'RequiredBy' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when
     * hasRequiredBy() returns true.
     *
     * @return the previously received value of the property 'RequiredBy'.
     */
    const ::std::vector< ::std::string >& getRequiredBy() const;

    /**
     * Determines whether a status message for the property 'RequiredBy' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasRequiredBy() const;

    // Property 'RequiredByOverridable'

    /**
     * Notify on the property 'RequiredByOverridable'. This method registers
     * for property changes by D-Bus service.
     *
     * <b>Documentation of 'RequiredByOverridable'</b>:
     *
     * RequiredByOverridable
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRequiredByOverridableRegister(RequiredByOverridableCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'RequiredByOverridable'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'RequiredByOverridable'</b>:
     *
     * RequiredByOverridable
     *
     * @param act The act which was previously returned by the
     * sendRequiredByOverridableRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendRequiredByOverridableDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'RequiredByOverridable'.
     */
    void sendRequiredByOverridableDeregisterAll() const;

    /**
     * Request the value of the property 'RequiredByOverridable' from the
     * D-Bus server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'RequiredByOverridable'</b>:
     *
     * RequiredByOverridable
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRequiredByOverridableGet(RequiredByOverridableCallbackIF& cb);


    /**
     * Returns the current value of the property 'RequiredByOverridable' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasRequiredByOverridable() returns true.
     *
     * @return the previously received value of the property 'RequiredByOverridable'.
     */
    const ::std::vector< ::std::string >& getRequiredByOverridable() const;

    /**
     * Determines whether a status message for the property
     * 'RequiredByOverridable' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasRequiredByOverridable() const;

    // Property 'RequisiteOf'

    /**
     * Notify on the property 'RequisiteOf'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'RequisiteOf'</b>:
     *
     * RequisiteOf
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRequisiteOfRegister(RequisiteOfCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'RequisiteOf'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'RequisiteOf'</b>:
     *
     * RequisiteOf
     *
     * @param act The act which was previously returned by the
     * sendRequisiteOfRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendRequisiteOfDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'RequisiteOf'.
     */
    void sendRequisiteOfDeregisterAll() const;

    /**
     * Request the value of the property 'RequisiteOf' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'RequisiteOf'</b>:
     *
     * RequisiteOf
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRequisiteOfGet(RequisiteOfCallbackIF& cb);


    /**
     * Returns the current value of the property 'RequisiteOf' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasRequisiteOf() returns true.
     *
     * @return the previously received value of the property 'RequisiteOf'.
     */
    const ::std::vector< ::std::string >& getRequisiteOf() const;

    /**
     * Determines whether a status message for the property 'RequisiteOf' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasRequisiteOf() const;

    // Property 'RequisiteOfOverridable'

    /**
     * Notify on the property 'RequisiteOfOverridable'. This method registers
     * for property changes by D-Bus service.
     *
     * <b>Documentation of 'RequisiteOfOverridable'</b>:
     *
     * RequisiteOfOverridable
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRequisiteOfOverridableRegister(RequisiteOfOverridableCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'RequisiteOfOverridable'. This
     * method deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'RequisiteOfOverridable'</b>:
     *
     * RequisiteOfOverridable
     *
     * @param act The act which was previously returned by the
     * sendRequisiteOfOverridableRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendRequisiteOfOverridableDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'RequisiteOfOverridable'.
     */
    void sendRequisiteOfOverridableDeregisterAll() const;

    /**
     * Request the value of the property 'RequisiteOfOverridable' from the
     * D-Bus server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'RequisiteOfOverridable'</b>:
     *
     * RequisiteOfOverridable
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRequisiteOfOverridableGet(RequisiteOfOverridableCallbackIF& cb);


    /**
     * Returns the current value of the property 'RequisiteOfOverridable' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasRequisiteOfOverridable() returns true.
     *
     * @return the previously received value of the property 'RequisiteOfOverridable'.
     */
    const ::std::vector< ::std::string >& getRequisiteOfOverridable() const;

    /**
     * Determines whether a status message for the property
     * 'RequisiteOfOverridable' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasRequisiteOfOverridable() const;

    // Property 'WantedBy'

    /**
     * Notify on the property 'WantedBy'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'WantedBy'</b>:
     *
     * WantedBy
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendWantedByRegister(WantedByCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'WantedBy'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'WantedBy'</b>:
     *
     * WantedBy
     *
     * @param act The act which was previously returned by the
     * sendWantedByRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendWantedByDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'WantedBy'.
     */
    void sendWantedByDeregisterAll() const;

    /**
     * Request the value of the property 'WantedBy' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'WantedBy'</b>:
     *
     * WantedBy
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendWantedByGet(WantedByCallbackIF& cb);


    /**
     * Returns the current value of the property 'WantedBy' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasWantedBy()
     * returns true.
     *
     * @return the previously received value of the property 'WantedBy'.
     */
    const ::std::vector< ::std::string >& getWantedBy() const;

    /**
     * Determines whether a status message for the property 'WantedBy' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasWantedBy() const;

    // Property 'BoundBy'

    /**
     * Notify on the property 'BoundBy'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'BoundBy'</b>:
     *
     * BoundBy
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBoundByRegister(BoundByCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'BoundBy'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'BoundBy'</b>:
     *
     * BoundBy
     *
     * @param act The act which was previously returned by the
     * sendBoundByRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendBoundByDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'BoundBy'.
     */
    void sendBoundByDeregisterAll() const;

    /**
     * Request the value of the property 'BoundBy' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'BoundBy'</b>:
     *
     * BoundBy
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBoundByGet(BoundByCallbackIF& cb);


    /**
     * Returns the current value of the property 'BoundBy' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasBoundBy()
     * returns true.
     *
     * @return the previously received value of the property 'BoundBy'.
     */
    const ::std::vector< ::std::string >& getBoundBy() const;

    /**
     * Determines whether a status message for the property 'BoundBy' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasBoundBy() const;

    // Property 'ConsistsOf'

    /**
     * Notify on the property 'ConsistsOf'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'ConsistsOf'</b>:
     *
     * ConsistsOf
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConsistsOfRegister(ConsistsOfCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'ConsistsOf'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'ConsistsOf'</b>:
     *
     * ConsistsOf
     *
     * @param act The act which was previously returned by the
     * sendConsistsOfRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendConsistsOfDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'ConsistsOf'.
     */
    void sendConsistsOfDeregisterAll() const;

    /**
     * Request the value of the property 'ConsistsOf' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'ConsistsOf'</b>:
     *
     * ConsistsOf
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConsistsOfGet(ConsistsOfCallbackIF& cb);


    /**
     * Returns the current value of the property 'ConsistsOf' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when
     * hasConsistsOf() returns true.
     *
     * @return the previously received value of the property 'ConsistsOf'.
     */
    const ::std::vector< ::std::string >& getConsistsOf() const;

    /**
     * Determines whether a status message for the property 'ConsistsOf' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasConsistsOf() const;

    // Property 'Conflicts'

    /**
     * Notify on the property 'Conflicts'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Conflicts'</b>:
     *
     * Conflicts
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConflictsRegister(ConflictsCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Conflicts'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Conflicts'</b>:
     *
     * Conflicts
     *
     * @param act The act which was previously returned by the
     * sendConflictsRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendConflictsDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Conflicts'.
     */
    void sendConflictsDeregisterAll() const;

    /**
     * Request the value of the property 'Conflicts' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Conflicts'</b>:
     *
     * Conflicts
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConflictsGet(ConflictsCallbackIF& cb);


    /**
     * Returns the current value of the property 'Conflicts' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasConflicts()
     * returns true.
     *
     * @return the previously received value of the property 'Conflicts'.
     */
    const ::std::vector< ::std::string >& getConflicts() const;

    /**
     * Determines whether a status message for the property 'Conflicts' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasConflicts() const;

    // Property 'ConflictedBy'

    /**
     * Notify on the property 'ConflictedBy'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'ConflictedBy'</b>:
     *
     * ConflictedBy
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConflictedByRegister(ConflictedByCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'ConflictedBy'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'ConflictedBy'</b>:
     *
     * ConflictedBy
     *
     * @param act The act which was previously returned by the
     * sendConflictedByRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendConflictedByDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'ConflictedBy'.
     */
    void sendConflictedByDeregisterAll() const;

    /**
     * Request the value of the property 'ConflictedBy' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'ConflictedBy'</b>:
     *
     * ConflictedBy
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConflictedByGet(ConflictedByCallbackIF& cb);


    /**
     * Returns the current value of the property 'ConflictedBy' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasConflictedBy() returns true.
     *
     * @return the previously received value of the property 'ConflictedBy'.
     */
    const ::std::vector< ::std::string >& getConflictedBy() const;

    /**
     * Determines whether a status message for the property 'ConflictedBy' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasConflictedBy() const;

    // Property 'Before'

    /**
     * Notify on the property 'Before'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Before'</b>:
     *
     * Before
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBeforeRegister(BeforeCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Before'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Before'</b>:
     *
     * Before
     *
     * @param act The act which was previously returned by the
     * sendBeforeRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendBeforeDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Before'.
     */
    void sendBeforeDeregisterAll() const;

    /**
     * Request the value of the property 'Before' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Before'</b>:
     *
     * Before
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBeforeGet(BeforeCallbackIF& cb);


    /**
     * Returns the current value of the property 'Before' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasBefore()
     * returns true.
     *
     * @return the previously received value of the property 'Before'.
     */
    const ::std::vector< ::std::string >& getBefore() const;

    /**
     * Determines whether a status message for the property 'Before' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasBefore() const;

    // Property 'After'

    /**
     * Notify on the property 'After'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'After'</b>:
     *
     * After
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAfterRegister(AfterCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'After'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'After'</b>:
     *
     * After
     *
     * @param act The act which was previously returned by the
     * sendAfterRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendAfterDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'After'.
     */
    void sendAfterDeregisterAll() const;

    /**
     * Request the value of the property 'After' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'After'</b>:
     *
     * After
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAfterGet(AfterCallbackIF& cb);


    /**
     * Returns the current value of the property 'After' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasAfter()
     * returns true.
     *
     * @return the previously received value of the property 'After'.
     */
    const ::std::vector< ::std::string >& getAfter() const;

    /**
     * Determines whether a status message for the property 'After' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAfter() const;

    // Property 'OnFailure'

    /**
     * Notify on the property 'OnFailure'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'OnFailure'</b>:
     *
     * OnFailure
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendOnFailureRegister(OnFailureCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'OnFailure'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'OnFailure'</b>:
     *
     * OnFailure
     *
     * @param act The act which was previously returned by the
     * sendOnFailureRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendOnFailureDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'OnFailure'.
     */
    void sendOnFailureDeregisterAll() const;

    /**
     * Request the value of the property 'OnFailure' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'OnFailure'</b>:
     *
     * OnFailure
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendOnFailureGet(OnFailureCallbackIF& cb);


    /**
     * Returns the current value of the property 'OnFailure' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasOnFailure()
     * returns true.
     *
     * @return the previously received value of the property 'OnFailure'.
     */
    const ::std::vector< ::std::string >& getOnFailure() const;

    /**
     * Determines whether a status message for the property 'OnFailure' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasOnFailure() const;

    // Property 'Triggers'

    /**
     * Notify on the property 'Triggers'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Triggers'</b>:
     *
     * Triggers
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTriggersRegister(TriggersCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Triggers'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Triggers'</b>:
     *
     * Triggers
     *
     * @param act The act which was previously returned by the
     * sendTriggersRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendTriggersDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Triggers'.
     */
    void sendTriggersDeregisterAll() const;

    /**
     * Request the value of the property 'Triggers' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Triggers'</b>:
     *
     * Triggers
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTriggersGet(TriggersCallbackIF& cb);


    /**
     * Returns the current value of the property 'Triggers' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasTriggers()
     * returns true.
     *
     * @return the previously received value of the property 'Triggers'.
     */
    const ::std::vector< ::std::string >& getTriggers() const;

    /**
     * Determines whether a status message for the property 'Triggers' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasTriggers() const;

    // Property 'TriggeredBy'

    /**
     * Notify on the property 'TriggeredBy'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'TriggeredBy'</b>:
     *
     * TriggeredBy
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTriggeredByRegister(TriggeredByCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'TriggeredBy'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'TriggeredBy'</b>:
     *
     * TriggeredBy
     *
     * @param act The act which was previously returned by the
     * sendTriggeredByRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendTriggeredByDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'TriggeredBy'.
     */
    void sendTriggeredByDeregisterAll() const;

    /**
     * Request the value of the property 'TriggeredBy' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'TriggeredBy'</b>:
     *
     * TriggeredBy
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTriggeredByGet(TriggeredByCallbackIF& cb);


    /**
     * Returns the current value of the property 'TriggeredBy' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasTriggeredBy() returns true.
     *
     * @return the previously received value of the property 'TriggeredBy'.
     */
    const ::std::vector< ::std::string >& getTriggeredBy() const;

    /**
     * Determines whether a status message for the property 'TriggeredBy' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasTriggeredBy() const;

    // Property 'PropagatesReloadTo'

    /**
     * Notify on the property 'PropagatesReloadTo'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'PropagatesReloadTo'</b>:
     *
     * PropagatesReloadTo
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPropagatesReloadToRegister(PropagatesReloadToCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'PropagatesReloadTo'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'PropagatesReloadTo'</b>:
     *
     * PropagatesReloadTo
     *
     * @param act The act which was previously returned by the
     * sendPropagatesReloadToRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendPropagatesReloadToDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'PropagatesReloadTo'.
     */
    void sendPropagatesReloadToDeregisterAll() const;

    /**
     * Request the value of the property 'PropagatesReloadTo' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'PropagatesReloadTo'</b>:
     *
     * PropagatesReloadTo
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPropagatesReloadToGet(PropagatesReloadToCallbackIF& cb);


    /**
     * Returns the current value of the property 'PropagatesReloadTo' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasPropagatesReloadTo() returns true.
     *
     * @return the previously received value of the property 'PropagatesReloadTo'.
     */
    const ::std::vector< ::std::string >& getPropagatesReloadTo() const;

    /**
     * Determines whether a status message for the property
     * 'PropagatesReloadTo' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasPropagatesReloadTo() const;

    // Property 'ReloadPropagatedFrom'

    /**
     * Notify on the property 'ReloadPropagatedFrom'. This method registers
     * for property changes by D-Bus service.
     *
     * <b>Documentation of 'ReloadPropagatedFrom'</b>:
     *
     * ReloadPropagatedFrom
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReloadPropagatedFromRegister(ReloadPropagatedFromCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'ReloadPropagatedFrom'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'ReloadPropagatedFrom'</b>:
     *
     * ReloadPropagatedFrom
     *
     * @param act The act which was previously returned by the
     * sendReloadPropagatedFromRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendReloadPropagatedFromDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'ReloadPropagatedFrom'.
     */
    void sendReloadPropagatedFromDeregisterAll() const;

    /**
     * Request the value of the property 'ReloadPropagatedFrom' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'ReloadPropagatedFrom'</b>:
     *
     * ReloadPropagatedFrom
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReloadPropagatedFromGet(ReloadPropagatedFromCallbackIF& cb);


    /**
     * Returns the current value of the property 'ReloadPropagatedFrom' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasReloadPropagatedFrom() returns true.
     *
     * @return the previously received value of the property 'ReloadPropagatedFrom'.
     */
    const ::std::vector< ::std::string >& getReloadPropagatedFrom() const;

    /**
     * Determines whether a status message for the property
     * 'ReloadPropagatedFrom' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasReloadPropagatedFrom() const;

    // Property 'JoinsNamespaceOf'

    /**
     * Notify on the property 'JoinsNamespaceOf'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'JoinsNamespaceOf'</b>:
     *
     * JoinsNamespaceOf
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendJoinsNamespaceOfRegister(JoinsNamespaceOfCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'JoinsNamespaceOf'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'JoinsNamespaceOf'</b>:
     *
     * JoinsNamespaceOf
     *
     * @param act The act which was previously returned by the
     * sendJoinsNamespaceOfRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendJoinsNamespaceOfDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'JoinsNamespaceOf'.
     */
    void sendJoinsNamespaceOfDeregisterAll() const;

    /**
     * Request the value of the property 'JoinsNamespaceOf' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'JoinsNamespaceOf'</b>:
     *
     * JoinsNamespaceOf
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendJoinsNamespaceOfGet(JoinsNamespaceOfCallbackIF& cb);


    /**
     * Returns the current value of the property 'JoinsNamespaceOf' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasJoinsNamespaceOf() returns true.
     *
     * @return the previously received value of the property 'JoinsNamespaceOf'.
     */
    const ::std::vector< ::std::string >& getJoinsNamespaceOf() const;

    /**
     * Determines whether a status message for the property 'JoinsNamespaceOf'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasJoinsNamespaceOf() const;

    // Property 'RequiresMountsFor'

    /**
     * Notify on the property 'RequiresMountsFor'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'RequiresMountsFor'</b>:
     *
     * RequiresMountsFor
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRequiresMountsForRegister(RequiresMountsForCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'RequiresMountsFor'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'RequiresMountsFor'</b>:
     *
     * RequiresMountsFor
     *
     * @param act The act which was previously returned by the
     * sendRequiresMountsForRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendRequiresMountsForDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'RequiresMountsFor'.
     */
    void sendRequiresMountsForDeregisterAll() const;

    /**
     * Request the value of the property 'RequiresMountsFor' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'RequiresMountsFor'</b>:
     *
     * RequiresMountsFor
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRequiresMountsForGet(RequiresMountsForCallbackIF& cb);


    /**
     * Returns the current value of the property 'RequiresMountsFor' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasRequiresMountsFor() returns true.
     *
     * @return the previously received value of the property 'RequiresMountsFor'.
     */
    const ::std::vector< ::std::string >& getRequiresMountsFor() const;

    /**
     * Determines whether a status message for the property
     * 'RequiresMountsFor' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasRequiresMountsFor() const;

    // Property 'Documentation'

    /**
     * Notify on the property 'Documentation'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'Documentation'</b>:
     *
     * Documentation
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDocumentationRegister(DocumentationCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Documentation'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'Documentation'</b>:
     *
     * Documentation
     *
     * @param act The act which was previously returned by the
     * sendDocumentationRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendDocumentationDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Documentation'.
     */
    void sendDocumentationDeregisterAll() const;

    /**
     * Request the value of the property 'Documentation' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Documentation'</b>:
     *
     * Documentation
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDocumentationGet(DocumentationCallbackIF& cb);


    /**
     * Returns the current value of the property 'Documentation' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasDocumentation() returns true.
     *
     * @return the previously received value of the property 'Documentation'.
     */
    const ::std::vector< ::std::string >& getDocumentation() const;

    /**
     * Determines whether a status message for the property 'Documentation'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDocumentation() const;

    // Property 'Description'

    /**
     * Notify on the property 'Description'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'Description'</b>:
     *
     * Description contains the human readable description string for the unit.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDescriptionRegister(DescriptionCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Description'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'Description'</b>:
     *
     * Description contains the human readable description string for the unit.
     *
     * @param act The act which was previously returned by the
     * sendDescriptionRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendDescriptionDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Description'.
     */
    void sendDescriptionDeregisterAll() const;

    /**
     * Request the value of the property 'Description' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Description'</b>:
     *
     * Description contains the human readable description string for the unit.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDescriptionGet(DescriptionCallbackIF& cb);


    /**
     * Returns the current value of the property 'Description' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasDescription() returns true.
     *
     * @return the previously received value of the property 'Description'.
     */
    const ::std::string& getDescription() const;

    /**
     * Determines whether a status message for the property 'Description' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDescription() const;

    // Property 'LoadState'

    /**
     * Notify on the property 'LoadState'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'LoadState'</b>:
     *
     * LoadState contains a state value that reflects whether the configuration file of this unit has been loaded.
     * 		The following states are currently defined: loaded, error, masked. loaded indicates that the configuration was successfully loaded.
     * 		error indicates that the configuration failed to load, the LoadError field (see below) contains information about the cause of this failure.
     * 		masked indicates that the unit is currently masked out (i.e. symlinked to /dev/null or suchlike). Note that the LoadState is fully orthogonal
     * 		to the ActiveState (see below) as units without valid loaded configuration might be active (because configuration might have been reloaded at
     * 		a time where a unit was already active).
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendLoadStateRegister(LoadStateCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'LoadState'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'LoadState'</b>:
     *
     * LoadState contains a state value that reflects whether the configuration file of this unit has been loaded.
     * 		The following states are currently defined: loaded, error, masked. loaded indicates that the configuration was successfully loaded.
     * 		error indicates that the configuration failed to load, the LoadError field (see below) contains information about the cause of this failure.
     * 		masked indicates that the unit is currently masked out (i.e. symlinked to /dev/null or suchlike). Note that the LoadState is fully orthogonal
     * 		to the ActiveState (see below) as units without valid loaded configuration might be active (because configuration might have been reloaded at
     * 		a time where a unit was already active).
     *
     * @param act The act which was previously returned by the
     * sendLoadStateRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendLoadStateDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'LoadState'.
     */
    void sendLoadStateDeregisterAll() const;

    /**
     * Request the value of the property 'LoadState' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'LoadState'</b>:
     *
     * LoadState contains a state value that reflects whether the configuration file of this unit has been loaded.
     * 		The following states are currently defined: loaded, error, masked. loaded indicates that the configuration was successfully loaded.
     * 		error indicates that the configuration failed to load, the LoadError field (see below) contains information about the cause of this failure.
     * 		masked indicates that the unit is currently masked out (i.e. symlinked to /dev/null or suchlike). Note that the LoadState is fully orthogonal
     * 		to the ActiveState (see below) as units without valid loaded configuration might be active (because configuration might have been reloaded at
     * 		a time where a unit was already active).
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendLoadStateGet(LoadStateCallbackIF& cb);


    /**
     * Returns the current value of the property 'LoadState' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasLoadState()
     * returns true.
     *
     * @return the previously received value of the property 'LoadState'.
     */
    const ::std::string& getLoadState() const;

    /**
     * Determines whether a status message for the property 'LoadState' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasLoadState() const;

    // Property 'ActiveState'

    /**
     * Notify on the property 'ActiveState'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'ActiveState'</b>:
     *
     * ActiveState contains a state value that reflects whether the unit is currently active or not.
     * 		The following states are currently defined: active, reloading, inactive, failed, activating, deactivating. active indicates
     * 		that unit is active (obviously...). reloading indicates that the unit is active and currently reloading its configuration.
     * 		inactive indicates that it is inactive and the previous run was successful or no previous run has taken place yet.
     * 		failed indicates that it is inactive and the previous run was not successful.
     * 		activating indicates that the unit has previously been inactive but is currently in the process of entering an active state.
     * 		 Conversely deactivating indicates that the unit is currently in the process of deactivation
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendActiveStateRegister(ActiveStateCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'ActiveState'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'ActiveState'</b>:
     *
     * ActiveState contains a state value that reflects whether the unit is currently active or not.
     * 		The following states are currently defined: active, reloading, inactive, failed, activating, deactivating. active indicates
     * 		that unit is active (obviously...). reloading indicates that the unit is active and currently reloading its configuration.
     * 		inactive indicates that it is inactive and the previous run was successful or no previous run has taken place yet.
     * 		failed indicates that it is inactive and the previous run was not successful.
     * 		activating indicates that the unit has previously been inactive but is currently in the process of entering an active state.
     * 		 Conversely deactivating indicates that the unit is currently in the process of deactivation
     *
     * @param act The act which was previously returned by the
     * sendActiveStateRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendActiveStateDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'ActiveState'.
     */
    void sendActiveStateDeregisterAll() const;

    /**
     * Request the value of the property 'ActiveState' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'ActiveState'</b>:
     *
     * ActiveState contains a state value that reflects whether the unit is currently active or not.
     * 		The following states are currently defined: active, reloading, inactive, failed, activating, deactivating. active indicates
     * 		that unit is active (obviously...). reloading indicates that the unit is active and currently reloading its configuration.
     * 		inactive indicates that it is inactive and the previous run was successful or no previous run has taken place yet.
     * 		failed indicates that it is inactive and the previous run was not successful.
     * 		activating indicates that the unit has previously been inactive but is currently in the process of entering an active state.
     * 		 Conversely deactivating indicates that the unit is currently in the process of deactivation
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendActiveStateGet(ActiveStateCallbackIF& cb);


    /**
     * Returns the current value of the property 'ActiveState' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasActiveState() returns true.
     *
     * @return the previously received value of the property 'ActiveState'.
     */
    const ::std::string& getActiveState() const;

    /**
     * Determines whether a status message for the property 'ActiveState' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasActiveState() const;

    // Property 'SubState'

    /**
     * Notify on the property 'SubState'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'SubState'</b>:
     *
     * SubState encodes states of the same state machine that ActiveState covers, but knows more fine-grained states
     * 		that are unit-type-specific. Where ActiveState only covers six high-level states, SubState covers possibly many more low-level
     * 		unit-type-specific states that are mapped to the six high-level states. Note that multiple low-level states might map to the same
     * 		high-level state, but not vice versa. Not all high-level states have low-level counterparts on all unit types. At this point the
     * 		low-level states are not documented here, and are more likely to be extended later on than the common high-level states explained above.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSubStateRegister(SubStateCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'SubState'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'SubState'</b>:
     *
     * SubState encodes states of the same state machine that ActiveState covers, but knows more fine-grained states
     * 		that are unit-type-specific. Where ActiveState only covers six high-level states, SubState covers possibly many more low-level
     * 		unit-type-specific states that are mapped to the six high-level states. Note that multiple low-level states might map to the same
     * 		high-level state, but not vice versa. Not all high-level states have low-level counterparts on all unit types. At this point the
     * 		low-level states are not documented here, and are more likely to be extended later on than the common high-level states explained above.
     *
     * @param act The act which was previously returned by the
     * sendSubStateRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSubStateDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'SubState'.
     */
    void sendSubStateDeregisterAll() const;

    /**
     * Request the value of the property 'SubState' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'SubState'</b>:
     *
     * SubState encodes states of the same state machine that ActiveState covers, but knows more fine-grained states
     * 		that are unit-type-specific. Where ActiveState only covers six high-level states, SubState covers possibly many more low-level
     * 		unit-type-specific states that are mapped to the six high-level states. Note that multiple low-level states might map to the same
     * 		high-level state, but not vice versa. Not all high-level states have low-level counterparts on all unit types. At this point the
     * 		low-level states are not documented here, and are more likely to be extended later on than the common high-level states explained above.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSubStateGet(SubStateCallbackIF& cb);


    /**
     * Returns the current value of the property 'SubState' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasSubState()
     * returns true.
     *
     * @return the previously received value of the property 'SubState'.
     */
    const ::std::string& getSubState() const;

    /**
     * Determines whether a status message for the property 'SubState' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSubState() const;

    // Property 'FragmentPath'

    /**
     * Notify on the property 'FragmentPath'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'FragmentPath'</b>:
     *
     * FragmentPath contains the unit file path this unit was read from, if there is any (if not this contains the empty string).
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFragmentPathRegister(FragmentPathCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'FragmentPath'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'FragmentPath'</b>:
     *
     * FragmentPath contains the unit file path this unit was read from, if there is any (if not this contains the empty string).
     *
     * @param act The act which was previously returned by the
     * sendFragmentPathRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendFragmentPathDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'FragmentPath'.
     */
    void sendFragmentPathDeregisterAll() const;

    /**
     * Request the value of the property 'FragmentPath' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'FragmentPath'</b>:
     *
     * FragmentPath contains the unit file path this unit was read from, if there is any (if not this contains the empty string).
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFragmentPathGet(FragmentPathCallbackIF& cb);


    /**
     * Returns the current value of the property 'FragmentPath' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasFragmentPath() returns true.
     *
     * @return the previously received value of the property 'FragmentPath'.
     */
    const ::std::string& getFragmentPath() const;

    /**
     * Determines whether a status message for the property 'FragmentPath' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasFragmentPath() const;

    // Property 'SourcePath'

    /**
     * Notify on the property 'SourcePath'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'SourcePath'</b>:
     *
     * SourcePath  contains the path to a configuration file this unit is automatically generated from in case it is not a native
     * 		unit (in which case it contains the empty string). For example, all mount units generated from /etc/fstab have this field set to this value.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSourcePathRegister(SourcePathCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'SourcePath'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'SourcePath'</b>:
     *
     * SourcePath  contains the path to a configuration file this unit is automatically generated from in case it is not a native
     * 		unit (in which case it contains the empty string). For example, all mount units generated from /etc/fstab have this field set to this value.
     *
     * @param act The act which was previously returned by the
     * sendSourcePathRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSourcePathDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'SourcePath'.
     */
    void sendSourcePathDeregisterAll() const;

    /**
     * Request the value of the property 'SourcePath' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'SourcePath'</b>:
     *
     * SourcePath  contains the path to a configuration file this unit is automatically generated from in case it is not a native
     * 		unit (in which case it contains the empty string). For example, all mount units generated from /etc/fstab have this field set to this value.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSourcePathGet(SourcePathCallbackIF& cb);


    /**
     * Returns the current value of the property 'SourcePath' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when
     * hasSourcePath() returns true.
     *
     * @return the previously received value of the property 'SourcePath'.
     */
    const ::std::string& getSourcePath() const;

    /**
     * Determines whether a status message for the property 'SourcePath' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSourcePath() const;

    // Property 'DropInPaths'

    /**
     * Notify on the property 'DropInPaths'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'DropInPaths'</b>:
     *
     * DropInPaths
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDropInPathsRegister(DropInPathsCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'DropInPaths'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'DropInPaths'</b>:
     *
     * DropInPaths
     *
     * @param act The act which was previously returned by the
     * sendDropInPathsRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendDropInPathsDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'DropInPaths'.
     */
    void sendDropInPathsDeregisterAll() const;

    /**
     * Request the value of the property 'DropInPaths' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'DropInPaths'</b>:
     *
     * DropInPaths
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDropInPathsGet(DropInPathsCallbackIF& cb);


    /**
     * Returns the current value of the property 'DropInPaths' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasDropInPaths() returns true.
     *
     * @return the previously received value of the property 'DropInPaths'.
     */
    const ::std::vector< ::std::string >& getDropInPaths() const;

    /**
     * Determines whether a status message for the property 'DropInPaths' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDropInPaths() const;

    // Property 'UnitFileState'

    /**
     * Notify on the property 'UnitFileState'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'UnitFileState'</b>:
     *
     * UnitFileState encodes the install state of the unit file of FragmentPath. It currently knows the following states: enabled,
     * 		enabled-runtime, linked, linked-runtime, masked, masked-runtime, static, disabled, invalid. enabled indicates that a unit file is permanently enabled.
     * 		enable-runtime indicates the unit file is only temporarily enabled, and will no longer be enabled after a reboot (that means, it is enabled via /run symlinks,
     * 		rather than /etc). linked indicates that a unit is linked into /etc permanently, linked indicates that a unit is linked into /run temporarily (until the next reboot).
     * 		masked indicates that the unit file is masked permanently, masked-runtime indicates that it is only temporarily masked in /run, until the next reboot.
     * 		static indicates that the unit is statically enabled, i.e. always enabled and doesn't need to be enabled explicitly. invalid indicates that it could not be
     * 		determined whether the unit file is enabled.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUnitFileStateRegister(UnitFileStateCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'UnitFileState'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'UnitFileState'</b>:
     *
     * UnitFileState encodes the install state of the unit file of FragmentPath. It currently knows the following states: enabled,
     * 		enabled-runtime, linked, linked-runtime, masked, masked-runtime, static, disabled, invalid. enabled indicates that a unit file is permanently enabled.
     * 		enable-runtime indicates the unit file is only temporarily enabled, and will no longer be enabled after a reboot (that means, it is enabled via /run symlinks,
     * 		rather than /etc). linked indicates that a unit is linked into /etc permanently, linked indicates that a unit is linked into /run temporarily (until the next reboot).
     * 		masked indicates that the unit file is masked permanently, masked-runtime indicates that it is only temporarily masked in /run, until the next reboot.
     * 		static indicates that the unit is statically enabled, i.e. always enabled and doesn't need to be enabled explicitly. invalid indicates that it could not be
     * 		determined whether the unit file is enabled.
     *
     * @param act The act which was previously returned by the
     * sendUnitFileStateRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendUnitFileStateDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'UnitFileState'.
     */
    void sendUnitFileStateDeregisterAll() const;

    /**
     * Request the value of the property 'UnitFileState' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'UnitFileState'</b>:
     *
     * UnitFileState encodes the install state of the unit file of FragmentPath. It currently knows the following states: enabled,
     * 		enabled-runtime, linked, linked-runtime, masked, masked-runtime, static, disabled, invalid. enabled indicates that a unit file is permanently enabled.
     * 		enable-runtime indicates the unit file is only temporarily enabled, and will no longer be enabled after a reboot (that means, it is enabled via /run symlinks,
     * 		rather than /etc). linked indicates that a unit is linked into /etc permanently, linked indicates that a unit is linked into /run temporarily (until the next reboot).
     * 		masked indicates that the unit file is masked permanently, masked-runtime indicates that it is only temporarily masked in /run, until the next reboot.
     * 		static indicates that the unit is statically enabled, i.e. always enabled and doesn't need to be enabled explicitly. invalid indicates that it could not be
     * 		determined whether the unit file is enabled.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUnitFileStateGet(UnitFileStateCallbackIF& cb);


    /**
     * Returns the current value of the property 'UnitFileState' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasUnitFileState() returns true.
     *
     * @return the previously received value of the property 'UnitFileState'.
     */
    const ::std::string& getUnitFileState() const;

    /**
     * Determines whether a status message for the property 'UnitFileState'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasUnitFileState() const;

    // Property 'UnitFilePreset'

    /**
     * Notify on the property 'UnitFilePreset'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'UnitFilePreset'</b>:
     *
     * UnitFilePreset
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUnitFilePresetRegister(UnitFilePresetCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'UnitFilePreset'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'UnitFilePreset'</b>:
     *
     * UnitFilePreset
     *
     * @param act The act which was previously returned by the
     * sendUnitFilePresetRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendUnitFilePresetDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'UnitFilePreset'.
     */
    void sendUnitFilePresetDeregisterAll() const;

    /**
     * Request the value of the property 'UnitFilePreset' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'UnitFilePreset'</b>:
     *
     * UnitFilePreset
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUnitFilePresetGet(UnitFilePresetCallbackIF& cb);


    /**
     * Returns the current value of the property 'UnitFilePreset' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasUnitFilePreset() returns true.
     *
     * @return the previously received value of the property 'UnitFilePreset'.
     */
    const ::std::string& getUnitFilePreset() const;

    /**
     * Determines whether a status message for the property 'UnitFilePreset'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasUnitFilePreset() const;

    // Property 'InactiveExitTimestamp'

    /**
     * Notify on the property 'InactiveExitTimestamp'. This method registers
     * for property changes by D-Bus service.
     *
     * <b>Documentation of 'InactiveExitTimestamp'</b>:
     *
     * InactiveExitTimestamp contain CLOCK_REALTIME and CLOCK_MONOTONIC 64bit usec timestamps of the last time a unit left the inactive state, entered
     * 		the active state, exited the active state, or entered an inactive state. These are the points in time where the unit transitioned inactive/failed → activating,
     * 		activating → active, active → deactivating, and finally deactivating → inactive/failed. The fields are 0 in case such a transition has not been recording on this boot yet.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendInactiveExitTimestampRegister(InactiveExitTimestampCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'InactiveExitTimestamp'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'InactiveExitTimestamp'</b>:
     *
     * InactiveExitTimestamp contain CLOCK_REALTIME and CLOCK_MONOTONIC 64bit usec timestamps of the last time a unit left the inactive state, entered
     * 		the active state, exited the active state, or entered an inactive state. These are the points in time where the unit transitioned inactive/failed → activating,
     * 		activating → active, active → deactivating, and finally deactivating → inactive/failed. The fields are 0 in case such a transition has not been recording on this boot yet.
     *
     * @param act The act which was previously returned by the
     * sendInactiveExitTimestampRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendInactiveExitTimestampDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'InactiveExitTimestamp'.
     */
    void sendInactiveExitTimestampDeregisterAll() const;

    /**
     * Request the value of the property 'InactiveExitTimestamp' from the
     * D-Bus server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'InactiveExitTimestamp'</b>:
     *
     * InactiveExitTimestamp contain CLOCK_REALTIME and CLOCK_MONOTONIC 64bit usec timestamps of the last time a unit left the inactive state, entered
     * 		the active state, exited the active state, or entered an inactive state. These are the points in time where the unit transitioned inactive/failed → activating,
     * 		activating → active, active → deactivating, and finally deactivating → inactive/failed. The fields are 0 in case such a transition has not been recording on this boot yet.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendInactiveExitTimestampGet(InactiveExitTimestampCallbackIF& cb);


    /**
     * Returns the current value of the property 'InactiveExitTimestamp' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasInactiveExitTimestamp() returns true.
     *
     * @return the previously received value of the property 'InactiveExitTimestamp'.
     */
    uint64 getInactiveExitTimestamp() const;

    /**
     * Determines whether a status message for the property
     * 'InactiveExitTimestamp' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasInactiveExitTimestamp() const;

    // Property 'InactiveExitTimestampMonotonic'

    /**
     * Notify on the property 'InactiveExitTimestampMonotonic'. This method
     * registers for property changes by D-Bus service.
     *
     * <b>Documentation of 'InactiveExitTimestampMonotonic'</b>:
     *
     * InactiveExitTimestampMonotonic
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendInactiveExitTimestampMonotonicRegister(InactiveExitTimestampMonotonicCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'InactiveExitTimestampMonotonic'.
     * This method deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'InactiveExitTimestampMonotonic'</b>:
     *
     * InactiveExitTimestampMonotonic
     *
     * @param act The act which was previously returned by the
     * sendInactiveExitTimestampMonotonicRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendInactiveExitTimestampMonotonicDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property
     * 'InactiveExitTimestampMonotonic'.
     */
    void sendInactiveExitTimestampMonotonicDeregisterAll() const;

    /**
     * Request the value of the property 'InactiveExitTimestampMonotonic' from
     * the D-Bus server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'InactiveExitTimestampMonotonic'</b>:
     *
     * InactiveExitTimestampMonotonic
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendInactiveExitTimestampMonotonicGet(InactiveExitTimestampMonotonicCallbackIF& cb);


    /**
     * Returns the current value of the property
     * 'InactiveExitTimestampMonotonic' (as known by the proxy). This method
     * is only allowed to be called when a status message for this property
     * was received before. Otherwise the behavior of this method is
     * undefined. It is safe to call this method when
     * hasInactiveExitTimestampMonotonic() returns true.
     *
     * @return the previously received value of the property 'InactiveExitTimestampMonotonic'.
     */
    uint64 getInactiveExitTimestampMonotonic() const;

    /**
     * Determines whether a status message for the property
     * 'InactiveExitTimestampMonotonic' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasInactiveExitTimestampMonotonic() const;

    // Property 'ActiveEnterTimestamp'

    /**
     * Notify on the property 'ActiveEnterTimestamp'. This method registers
     * for property changes by D-Bus service.
     *
     * <b>Documentation of 'ActiveEnterTimestamp'</b>:
     *
     * ActiveEnterTimestamp
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendActiveEnterTimestampRegister(ActiveEnterTimestampCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'ActiveEnterTimestamp'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'ActiveEnterTimestamp'</b>:
     *
     * ActiveEnterTimestamp
     *
     * @param act The act which was previously returned by the
     * sendActiveEnterTimestampRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendActiveEnterTimestampDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'ActiveEnterTimestamp'.
     */
    void sendActiveEnterTimestampDeregisterAll() const;

    /**
     * Request the value of the property 'ActiveEnterTimestamp' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'ActiveEnterTimestamp'</b>:
     *
     * ActiveEnterTimestamp
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendActiveEnterTimestampGet(ActiveEnterTimestampCallbackIF& cb);


    /**
     * Returns the current value of the property 'ActiveEnterTimestamp' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasActiveEnterTimestamp() returns true.
     *
     * @return the previously received value of the property 'ActiveEnterTimestamp'.
     */
    uint64 getActiveEnterTimestamp() const;

    /**
     * Determines whether a status message for the property
     * 'ActiveEnterTimestamp' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasActiveEnterTimestamp() const;

    // Property 'ActiveEnterTimestampMonotonic'

    /**
     * Notify on the property 'ActiveEnterTimestampMonotonic'. This method
     * registers for property changes by D-Bus service.
     *
     * <b>Documentation of 'ActiveEnterTimestampMonotonic'</b>:
     *
     * ActiveEnterTimestampMonotonic
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendActiveEnterTimestampMonotonicRegister(ActiveEnterTimestampMonotonicCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'ActiveEnterTimestampMonotonic'.
     * This method deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'ActiveEnterTimestampMonotonic'</b>:
     *
     * ActiveEnterTimestampMonotonic
     *
     * @param act The act which was previously returned by the
     * sendActiveEnterTimestampMonotonicRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendActiveEnterTimestampMonotonicDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property
     * 'ActiveEnterTimestampMonotonic'.
     */
    void sendActiveEnterTimestampMonotonicDeregisterAll() const;

    /**
     * Request the value of the property 'ActiveEnterTimestampMonotonic' from
     * the D-Bus server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'ActiveEnterTimestampMonotonic'</b>:
     *
     * ActiveEnterTimestampMonotonic
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendActiveEnterTimestampMonotonicGet(ActiveEnterTimestampMonotonicCallbackIF& cb);


    /**
     * Returns the current value of the property
     * 'ActiveEnterTimestampMonotonic' (as known by the proxy). This method is
     * only allowed to be called when a status message for this property was
     * received before. Otherwise the behavior of this method is undefined. It
     * is safe to call this method when hasActiveEnterTimestampMonotonic()
     * returns true.
     *
     * @return the previously received value of the property 'ActiveEnterTimestampMonotonic'.
     */
    uint64 getActiveEnterTimestampMonotonic() const;

    /**
     * Determines whether a status message for the property
     * 'ActiveEnterTimestampMonotonic' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasActiveEnterTimestampMonotonic() const;

    // Property 'ActiveExitTimestamp'

    /**
     * Notify on the property 'ActiveExitTimestamp'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'ActiveExitTimestamp'</b>:
     *
     * ActiveExitTimestamp
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendActiveExitTimestampRegister(ActiveExitTimestampCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'ActiveExitTimestamp'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'ActiveExitTimestamp'</b>:
     *
     * ActiveExitTimestamp
     *
     * @param act The act which was previously returned by the
     * sendActiveExitTimestampRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendActiveExitTimestampDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'ActiveExitTimestamp'.
     */
    void sendActiveExitTimestampDeregisterAll() const;

    /**
     * Request the value of the property 'ActiveExitTimestamp' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'ActiveExitTimestamp'</b>:
     *
     * ActiveExitTimestamp
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendActiveExitTimestampGet(ActiveExitTimestampCallbackIF& cb);


    /**
     * Returns the current value of the property 'ActiveExitTimestamp' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasActiveExitTimestamp() returns true.
     *
     * @return the previously received value of the property 'ActiveExitTimestamp'.
     */
    uint64 getActiveExitTimestamp() const;

    /**
     * Determines whether a status message for the property
     * 'ActiveExitTimestamp' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasActiveExitTimestamp() const;

    // Property 'ActiveExitTimestampMonotonic'

    /**
     * Notify on the property 'ActiveExitTimestampMonotonic'. This method
     * registers for property changes by D-Bus service.
     *
     * <b>Documentation of 'ActiveExitTimestampMonotonic'</b>:
     *
     * ActiveExitTimestampMonotonic
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendActiveExitTimestampMonotonicRegister(ActiveExitTimestampMonotonicCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'ActiveExitTimestampMonotonic'. This
     * method deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'ActiveExitTimestampMonotonic'</b>:
     *
     * ActiveExitTimestampMonotonic
     *
     * @param act The act which was previously returned by the
     * sendActiveExitTimestampMonotonicRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendActiveExitTimestampMonotonicDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property
     * 'ActiveExitTimestampMonotonic'.
     */
    void sendActiveExitTimestampMonotonicDeregisterAll() const;

    /**
     * Request the value of the property 'ActiveExitTimestampMonotonic' from
     * the D-Bus server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'ActiveExitTimestampMonotonic'</b>:
     *
     * ActiveExitTimestampMonotonic
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendActiveExitTimestampMonotonicGet(ActiveExitTimestampMonotonicCallbackIF& cb);


    /**
     * Returns the current value of the property
     * 'ActiveExitTimestampMonotonic' (as known by the proxy). This method is
     * only allowed to be called when a status message for this property was
     * received before. Otherwise the behavior of this method is undefined. It
     * is safe to call this method when hasActiveExitTimestampMonotonic()
     * returns true.
     *
     * @return the previously received value of the property 'ActiveExitTimestampMonotonic'.
     */
    uint64 getActiveExitTimestampMonotonic() const;

    /**
     * Determines whether a status message for the property
     * 'ActiveExitTimestampMonotonic' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasActiveExitTimestampMonotonic() const;

    // Property 'InactiveEnterTimestamp'

    /**
     * Notify on the property 'InactiveEnterTimestamp'. This method registers
     * for property changes by D-Bus service.
     *
     * <b>Documentation of 'InactiveEnterTimestamp'</b>:
     *
     * InactiveEnterTimestamp
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendInactiveEnterTimestampRegister(InactiveEnterTimestampCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'InactiveEnterTimestamp'. This
     * method deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'InactiveEnterTimestamp'</b>:
     *
     * InactiveEnterTimestamp
     *
     * @param act The act which was previously returned by the
     * sendInactiveEnterTimestampRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendInactiveEnterTimestampDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'InactiveEnterTimestamp'.
     */
    void sendInactiveEnterTimestampDeregisterAll() const;

    /**
     * Request the value of the property 'InactiveEnterTimestamp' from the
     * D-Bus server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'InactiveEnterTimestamp'</b>:
     *
     * InactiveEnterTimestamp
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendInactiveEnterTimestampGet(InactiveEnterTimestampCallbackIF& cb);


    /**
     * Returns the current value of the property 'InactiveEnterTimestamp' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasInactiveEnterTimestamp() returns true.
     *
     * @return the previously received value of the property 'InactiveEnterTimestamp'.
     */
    uint64 getInactiveEnterTimestamp() const;

    /**
     * Determines whether a status message for the property
     * 'InactiveEnterTimestamp' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasInactiveEnterTimestamp() const;

    // Property 'InactiveEnterTimestampMonotonic'

    /**
     * Notify on the property 'InactiveEnterTimestampMonotonic'. This method
     * registers for property changes by D-Bus service.
     *
     * <b>Documentation of 'InactiveEnterTimestampMonotonic'</b>:
     *
     * InactiveEnterTimestampMonotonic
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendInactiveEnterTimestampMonotonicRegister(InactiveEnterTimestampMonotonicCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'InactiveEnterTimestampMonotonic'.
     * This method deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'InactiveEnterTimestampMonotonic'</b>:
     *
     * InactiveEnterTimestampMonotonic
     *
     * @param act The act which was previously returned by the
     * sendInactiveEnterTimestampMonotonicRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendInactiveEnterTimestampMonotonicDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property
     * 'InactiveEnterTimestampMonotonic'.
     */
    void sendInactiveEnterTimestampMonotonicDeregisterAll() const;

    /**
     * Request the value of the property 'InactiveEnterTimestampMonotonic'
     * from the D-Bus server. This method sends a Get message to the D-Bus
     * server.
     *
     * <b>Documentation of 'InactiveEnterTimestampMonotonic'</b>:
     *
     * InactiveEnterTimestampMonotonic
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendInactiveEnterTimestampMonotonicGet(InactiveEnterTimestampMonotonicCallbackIF& cb);


    /**
     * Returns the current value of the property
     * 'InactiveEnterTimestampMonotonic' (as known by the proxy). This method
     * is only allowed to be called when a status message for this property
     * was received before. Otherwise the behavior of this method is
     * undefined. It is safe to call this method when
     * hasInactiveEnterTimestampMonotonic() returns true.
     *
     * @return the previously received value of the property 'InactiveEnterTimestampMonotonic'.
     */
    uint64 getInactiveEnterTimestampMonotonic() const;

    /**
     * Determines whether a status message for the property
     * 'InactiveEnterTimestampMonotonic' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasInactiveEnterTimestampMonotonic() const;

    // Property 'CanStart'

    /**
     * Notify on the property 'CanStart'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'CanStart'</b>:
     *
     * CanStart encodes as booleans whether the unit supports the start operation. Even if a unit supports such an operation
     * 		the client might not necessary have the right privileges to execute them.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCanStartRegister(CanStartCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'CanStart'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'CanStart'</b>:
     *
     * CanStart encodes as booleans whether the unit supports the start operation. Even if a unit supports such an operation
     * 		the client might not necessary have the right privileges to execute them.
     *
     * @param act The act which was previously returned by the
     * sendCanStartRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendCanStartDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'CanStart'.
     */
    void sendCanStartDeregisterAll() const;

    /**
     * Request the value of the property 'CanStart' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'CanStart'</b>:
     *
     * CanStart encodes as booleans whether the unit supports the start operation. Even if a unit supports such an operation
     * 		the client might not necessary have the right privileges to execute them.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCanStartGet(CanStartCallbackIF& cb);


    /**
     * Returns the current value of the property 'CanStart' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasCanStart()
     * returns true.
     *
     * @return the previously received value of the property 'CanStart'.
     */
    bool getCanStart() const;

    /**
     * Determines whether a status message for the property 'CanStart' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasCanStart() const;

    // Property 'CanStop'

    /**
     * Notify on the property 'CanStop'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'CanStop'</b>:
     *
     * CanStop encodes as booleans whether the unit supports the stop operation. Even if a unit supports such an operation
     * 		the client might not necessary have the right privileges to execute them.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCanStopRegister(CanStopCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'CanStop'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'CanStop'</b>:
     *
     * CanStop encodes as booleans whether the unit supports the stop operation. Even if a unit supports such an operation
     * 		the client might not necessary have the right privileges to execute them.
     *
     * @param act The act which was previously returned by the
     * sendCanStopRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendCanStopDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'CanStop'.
     */
    void sendCanStopDeregisterAll() const;

    /**
     * Request the value of the property 'CanStop' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'CanStop'</b>:
     *
     * CanStop encodes as booleans whether the unit supports the stop operation. Even if a unit supports such an operation
     * 		the client might not necessary have the right privileges to execute them.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCanStopGet(CanStopCallbackIF& cb);


    /**
     * Returns the current value of the property 'CanStop' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasCanStop()
     * returns true.
     *
     * @return the previously received value of the property 'CanStop'.
     */
    bool getCanStop() const;

    /**
     * Determines whether a status message for the property 'CanStop' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasCanStop() const;

    // Property 'CanReload'

    /**
     * Notify on the property 'CanReload'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'CanReload'</b>:
     *
     * CanReload encodes as booleans whether the unit supports the reload operation. Even if a unit supports such an operation
     * 		the client might not necessary have the right privileges to execute them.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCanReloadRegister(CanReloadCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'CanReload'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'CanReload'</b>:
     *
     * CanReload encodes as booleans whether the unit supports the reload operation. Even if a unit supports such an operation
     * 		the client might not necessary have the right privileges to execute them.
     *
     * @param act The act which was previously returned by the
     * sendCanReloadRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendCanReloadDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'CanReload'.
     */
    void sendCanReloadDeregisterAll() const;

    /**
     * Request the value of the property 'CanReload' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'CanReload'</b>:
     *
     * CanReload encodes as booleans whether the unit supports the reload operation. Even if a unit supports such an operation
     * 		the client might not necessary have the right privileges to execute them.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCanReloadGet(CanReloadCallbackIF& cb);


    /**
     * Returns the current value of the property 'CanReload' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasCanReload()
     * returns true.
     *
     * @return the previously received value of the property 'CanReload'.
     */
    bool getCanReload() const;

    /**
     * Determines whether a status message for the property 'CanReload' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasCanReload() const;

    // Property 'CanIsolate'

    /**
     * Notify on the property 'CanIsolate'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'CanIsolate'</b>:
     *
     * CanIsolate encodes as boolean whether the unit may be started in isolation mode.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCanIsolateRegister(CanIsolateCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'CanIsolate'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'CanIsolate'</b>:
     *
     * CanIsolate encodes as boolean whether the unit may be started in isolation mode.
     *
     * @param act The act which was previously returned by the
     * sendCanIsolateRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendCanIsolateDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'CanIsolate'.
     */
    void sendCanIsolateDeregisterAll() const;

    /**
     * Request the value of the property 'CanIsolate' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'CanIsolate'</b>:
     *
     * CanIsolate encodes as boolean whether the unit may be started in isolation mode.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCanIsolateGet(CanIsolateCallbackIF& cb);


    /**
     * Returns the current value of the property 'CanIsolate' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when
     * hasCanIsolate() returns true.
     *
     * @return the previously received value of the property 'CanIsolate'.
     */
    bool getCanIsolate() const;

    /**
     * Determines whether a status message for the property 'CanIsolate' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasCanIsolate() const;

    // Property 'Job'

    /**
     * Notify on the property 'Job'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Job'</b>:
     *
     * Job encodes the job ID and job object path of the job currently scheduled or executed for this unit, if there is any.
     * 		If no job is scheduled or executed the job id field will be 0.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendJobRegister(JobCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Job'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Job'</b>:
     *
     * Job encodes the job ID and job object path of the job currently scheduled or executed for this unit, if there is any.
     * 		If no job is scheduled or executed the job id field will be 0.
     *
     * @param act The act which was previously returned by the
     * sendJobRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendJobDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Job'.
     */
    void sendJobDeregisterAll() const;

    /**
     * Request the value of the property 'Job' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Job'</b>:
     *
     * Job encodes the job ID and job object path of the job currently scheduled or executed for this unit, if there is any.
     * 		If no job is scheduled or executed the job id field will be 0.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendJobGet(JobCallbackIF& cb);


    /**
     * Returns the current value of the property 'Job' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasJob()
     * returns true.
     *
     * @return the previously received value of the property 'Job'.
     */
    const job& getJob() const;

    /**
     * Determines whether a status message for the property 'Job' was received
     * before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasJob() const;

    // Property 'StopWhenUnneeded'

    /**
     * Notify on the property 'StopWhenUnneeded'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'StopWhenUnneeded'</b>:
     *
     * StopWhenUnneeded map directly to the corresponding configuration booleans in the unit file.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStopWhenUnneededRegister(StopWhenUnneededCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'StopWhenUnneeded'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'StopWhenUnneeded'</b>:
     *
     * StopWhenUnneeded map directly to the corresponding configuration booleans in the unit file.
     *
     * @param act The act which was previously returned by the
     * sendStopWhenUnneededRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendStopWhenUnneededDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'StopWhenUnneeded'.
     */
    void sendStopWhenUnneededDeregisterAll() const;

    /**
     * Request the value of the property 'StopWhenUnneeded' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'StopWhenUnneeded'</b>:
     *
     * StopWhenUnneeded map directly to the corresponding configuration booleans in the unit file.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStopWhenUnneededGet(StopWhenUnneededCallbackIF& cb);


    /**
     * Returns the current value of the property 'StopWhenUnneeded' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasStopWhenUnneeded() returns true.
     *
     * @return the previously received value of the property 'StopWhenUnneeded'.
     */
    bool getStopWhenUnneeded() const;

    /**
     * Determines whether a status message for the property 'StopWhenUnneeded'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasStopWhenUnneeded() const;

    // Property 'RefuseManualStart'

    /**
     * Notify on the property 'RefuseManualStart'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'RefuseManualStart'</b>:
     *
     * RefuseManualStart map directly to the corresponding configuration booleans in the unit file.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRefuseManualStartRegister(RefuseManualStartCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'RefuseManualStart'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'RefuseManualStart'</b>:
     *
     * RefuseManualStart map directly to the corresponding configuration booleans in the unit file.
     *
     * @param act The act which was previously returned by the
     * sendRefuseManualStartRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendRefuseManualStartDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'RefuseManualStart'.
     */
    void sendRefuseManualStartDeregisterAll() const;

    /**
     * Request the value of the property 'RefuseManualStart' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'RefuseManualStart'</b>:
     *
     * RefuseManualStart map directly to the corresponding configuration booleans in the unit file.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRefuseManualStartGet(RefuseManualStartCallbackIF& cb);


    /**
     * Returns the current value of the property 'RefuseManualStart' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasRefuseManualStart() returns true.
     *
     * @return the previously received value of the property 'RefuseManualStart'.
     */
    bool getRefuseManualStart() const;

    /**
     * Determines whether a status message for the property
     * 'RefuseManualStart' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasRefuseManualStart() const;

    // Property 'RefuseManualStop'

    /**
     * Notify on the property 'RefuseManualStop'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'RefuseManualStop'</b>:
     *
     * RefuseManualStop map directly to the corresponding configuration booleans in the unit file.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRefuseManualStopRegister(RefuseManualStopCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'RefuseManualStop'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'RefuseManualStop'</b>:
     *
     * RefuseManualStop map directly to the corresponding configuration booleans in the unit file.
     *
     * @param act The act which was previously returned by the
     * sendRefuseManualStopRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendRefuseManualStopDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'RefuseManualStop'.
     */
    void sendRefuseManualStopDeregisterAll() const;

    /**
     * Request the value of the property 'RefuseManualStop' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'RefuseManualStop'</b>:
     *
     * RefuseManualStop map directly to the corresponding configuration booleans in the unit file.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRefuseManualStopGet(RefuseManualStopCallbackIF& cb);


    /**
     * Returns the current value of the property 'RefuseManualStop' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasRefuseManualStop() returns true.
     *
     * @return the previously received value of the property 'RefuseManualStop'.
     */
    bool getRefuseManualStop() const;

    /**
     * Determines whether a status message for the property 'RefuseManualStop'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasRefuseManualStop() const;

    // Property 'AllowIsolate'

    /**
     * Notify on the property 'AllowIsolate'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'AllowIsolate'</b>:
     *
     * AllowIsolate map directly to the corresponding configuration booleans in the unit file.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAllowIsolateRegister(AllowIsolateCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'AllowIsolate'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'AllowIsolate'</b>:
     *
     * AllowIsolate map directly to the corresponding configuration booleans in the unit file.
     *
     * @param act The act which was previously returned by the
     * sendAllowIsolateRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendAllowIsolateDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'AllowIsolate'.
     */
    void sendAllowIsolateDeregisterAll() const;

    /**
     * Request the value of the property 'AllowIsolate' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'AllowIsolate'</b>:
     *
     * AllowIsolate map directly to the corresponding configuration booleans in the unit file.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAllowIsolateGet(AllowIsolateCallbackIF& cb);


    /**
     * Returns the current value of the property 'AllowIsolate' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasAllowIsolate() returns true.
     *
     * @return the previously received value of the property 'AllowIsolate'.
     */
    bool getAllowIsolate() const;

    /**
     * Determines whether a status message for the property 'AllowIsolate' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAllowIsolate() const;

    // Property 'DefaultDependencies'

    /**
     * Notify on the property 'DefaultDependencies'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'DefaultDependencies'</b>:
     *
     * DefaultDependencies map directly to the corresponding configuration booleans in the unit file.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDefaultDependenciesRegister(DefaultDependenciesCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'DefaultDependencies'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'DefaultDependencies'</b>:
     *
     * DefaultDependencies map directly to the corresponding configuration booleans in the unit file.
     *
     * @param act The act which was previously returned by the
     * sendDefaultDependenciesRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendDefaultDependenciesDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'DefaultDependencies'.
     */
    void sendDefaultDependenciesDeregisterAll() const;

    /**
     * Request the value of the property 'DefaultDependencies' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'DefaultDependencies'</b>:
     *
     * DefaultDependencies map directly to the corresponding configuration booleans in the unit file.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDefaultDependenciesGet(DefaultDependenciesCallbackIF& cb);


    /**
     * Returns the current value of the property 'DefaultDependencies' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasDefaultDependencies() returns true.
     *
     * @return the previously received value of the property 'DefaultDependencies'.
     */
    bool getDefaultDependencies() const;

    /**
     * Determines whether a status message for the property
     * 'DefaultDependencies' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDefaultDependencies() const;

    // Property 'OnFailureJobMode'

    /**
     * Notify on the property 'OnFailureJobMode'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'OnFailureJobMode'</b>:
     *
     * OnFailureJobMode
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendOnFailureJobModeRegister(OnFailureJobModeCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'OnFailureJobMode'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'OnFailureJobMode'</b>:
     *
     * OnFailureJobMode
     *
     * @param act The act which was previously returned by the
     * sendOnFailureJobModeRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendOnFailureJobModeDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'OnFailureJobMode'.
     */
    void sendOnFailureJobModeDeregisterAll() const;

    /**
     * Request the value of the property 'OnFailureJobMode' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'OnFailureJobMode'</b>:
     *
     * OnFailureJobMode
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendOnFailureJobModeGet(OnFailureJobModeCallbackIF& cb);


    /**
     * Returns the current value of the property 'OnFailureJobMode' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasOnFailureJobMode() returns true.
     *
     * @return the previously received value of the property 'OnFailureJobMode'.
     */
    const ::std::string& getOnFailureJobMode() const;

    /**
     * Determines whether a status message for the property 'OnFailureJobMode'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasOnFailureJobMode() const;

    // Property 'IgnoreOnIsolate'

    /**
     * Notify on the property 'IgnoreOnIsolate'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'IgnoreOnIsolate'</b>:
     *
     * IgnoreOnIsolate map directly to the corresponding configuration booleans in the unit file.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendIgnoreOnIsolateRegister(IgnoreOnIsolateCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'IgnoreOnIsolate'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'IgnoreOnIsolate'</b>:
     *
     * IgnoreOnIsolate map directly to the corresponding configuration booleans in the unit file.
     *
     * @param act The act which was previously returned by the
     * sendIgnoreOnIsolateRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendIgnoreOnIsolateDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'IgnoreOnIsolate'.
     */
    void sendIgnoreOnIsolateDeregisterAll() const;

    /**
     * Request the value of the property 'IgnoreOnIsolate' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'IgnoreOnIsolate'</b>:
     *
     * IgnoreOnIsolate map directly to the corresponding configuration booleans in the unit file.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendIgnoreOnIsolateGet(IgnoreOnIsolateCallbackIF& cb);


    /**
     * Returns the current value of the property 'IgnoreOnIsolate' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasIgnoreOnIsolate() returns true.
     *
     * @return the previously received value of the property 'IgnoreOnIsolate'.
     */
    bool getIgnoreOnIsolate() const;

    /**
     * Determines whether a status message for the property 'IgnoreOnIsolate'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasIgnoreOnIsolate() const;

    // Property 'IgnoreOnSnapshot'

    /**
     * Notify on the property 'IgnoreOnSnapshot'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'IgnoreOnSnapshot'</b>:
     *
     * IgnoreOnSnapshot map directly to the corresponding configuration booleans in the unit file.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendIgnoreOnSnapshotRegister(IgnoreOnSnapshotCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'IgnoreOnSnapshot'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'IgnoreOnSnapshot'</b>:
     *
     * IgnoreOnSnapshot map directly to the corresponding configuration booleans in the unit file.
     *
     * @param act The act which was previously returned by the
     * sendIgnoreOnSnapshotRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendIgnoreOnSnapshotDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'IgnoreOnSnapshot'.
     */
    void sendIgnoreOnSnapshotDeregisterAll() const;

    /**
     * Request the value of the property 'IgnoreOnSnapshot' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'IgnoreOnSnapshot'</b>:
     *
     * IgnoreOnSnapshot map directly to the corresponding configuration booleans in the unit file.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendIgnoreOnSnapshotGet(IgnoreOnSnapshotCallbackIF& cb);


    /**
     * Returns the current value of the property 'IgnoreOnSnapshot' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasIgnoreOnSnapshot() returns true.
     *
     * @return the previously received value of the property 'IgnoreOnSnapshot'.
     */
    bool getIgnoreOnSnapshot() const;

    /**
     * Determines whether a status message for the property 'IgnoreOnSnapshot'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasIgnoreOnSnapshot() const;

    // Property 'NeedDaemonReload'

    /**
     * Notify on the property 'NeedDaemonReload'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'NeedDaemonReload'</b>:
     *
     * NeedDaemonReload is a boolean that indicates whether the configuration file this unit is loaded from (i.e. FragmentPath or SourcePath)
     * 		has changed since the configuration was read and hence whether a configuration reload is recommended.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNeedDaemonReloadRegister(NeedDaemonReloadCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'NeedDaemonReload'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'NeedDaemonReload'</b>:
     *
     * NeedDaemonReload is a boolean that indicates whether the configuration file this unit is loaded from (i.e. FragmentPath or SourcePath)
     * 		has changed since the configuration was read and hence whether a configuration reload is recommended.
     *
     * @param act The act which was previously returned by the
     * sendNeedDaemonReloadRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendNeedDaemonReloadDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'NeedDaemonReload'.
     */
    void sendNeedDaemonReloadDeregisterAll() const;

    /**
     * Request the value of the property 'NeedDaemonReload' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'NeedDaemonReload'</b>:
     *
     * NeedDaemonReload is a boolean that indicates whether the configuration file this unit is loaded from (i.e. FragmentPath or SourcePath)
     * 		has changed since the configuration was read and hence whether a configuration reload is recommended.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNeedDaemonReloadGet(NeedDaemonReloadCallbackIF& cb);


    /**
     * Returns the current value of the property 'NeedDaemonReload' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasNeedDaemonReload() returns true.
     *
     * @return the previously received value of the property 'NeedDaemonReload'.
     */
    bool getNeedDaemonReload() const;

    /**
     * Determines whether a status message for the property 'NeedDaemonReload'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasNeedDaemonReload() const;

    // Property 'JobTimeoutUSec'

    /**
     * Notify on the property 'JobTimeoutUSec'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'JobTimeoutUSec'</b>:
     *
     * JobTimeoutUSec maps directly to the corresponding configuration setting in the unit file.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendJobTimeoutUSecRegister(JobTimeoutUSecCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'JobTimeoutUSec'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'JobTimeoutUSec'</b>:
     *
     * JobTimeoutUSec maps directly to the corresponding configuration setting in the unit file.
     *
     * @param act The act which was previously returned by the
     * sendJobTimeoutUSecRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendJobTimeoutUSecDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'JobTimeoutUSec'.
     */
    void sendJobTimeoutUSecDeregisterAll() const;

    /**
     * Request the value of the property 'JobTimeoutUSec' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'JobTimeoutUSec'</b>:
     *
     * JobTimeoutUSec maps directly to the corresponding configuration setting in the unit file.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendJobTimeoutUSecGet(JobTimeoutUSecCallbackIF& cb);


    /**
     * Returns the current value of the property 'JobTimeoutUSec' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasJobTimeoutUSec() returns true.
     *
     * @return the previously received value of the property 'JobTimeoutUSec'.
     */
    uint64 getJobTimeoutUSec() const;

    /**
     * Determines whether a status message for the property 'JobTimeoutUSec'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasJobTimeoutUSec() const;

    // Property 'JobTimeoutAction'

    /**
     * Notify on the property 'JobTimeoutAction'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'JobTimeoutAction'</b>:
     *
     * JobTimeoutAction
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendJobTimeoutActionRegister(JobTimeoutActionCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'JobTimeoutAction'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'JobTimeoutAction'</b>:
     *
     * JobTimeoutAction
     *
     * @param act The act which was previously returned by the
     * sendJobTimeoutActionRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendJobTimeoutActionDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'JobTimeoutAction'.
     */
    void sendJobTimeoutActionDeregisterAll() const;

    /**
     * Request the value of the property 'JobTimeoutAction' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'JobTimeoutAction'</b>:
     *
     * JobTimeoutAction
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendJobTimeoutActionGet(JobTimeoutActionCallbackIF& cb);


    /**
     * Returns the current value of the property 'JobTimeoutAction' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasJobTimeoutAction() returns true.
     *
     * @return the previously received value of the property 'JobTimeoutAction'.
     */
    const ::std::string& getJobTimeoutAction() const;

    /**
     * Determines whether a status message for the property 'JobTimeoutAction'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasJobTimeoutAction() const;

    // Property 'JobTimeoutRebootArgument'

    /**
     * Notify on the property 'JobTimeoutRebootArgument'. This method
     * registers for property changes by D-Bus service.
     *
     * <b>Documentation of 'JobTimeoutRebootArgument'</b>:
     *
     * JobTimeoutRebootArgument
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendJobTimeoutRebootArgumentRegister(JobTimeoutRebootArgumentCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'JobTimeoutRebootArgument'. This
     * method deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'JobTimeoutRebootArgument'</b>:
     *
     * JobTimeoutRebootArgument
     *
     * @param act The act which was previously returned by the
     * sendJobTimeoutRebootArgumentRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendJobTimeoutRebootArgumentDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property
     * 'JobTimeoutRebootArgument'.
     */
    void sendJobTimeoutRebootArgumentDeregisterAll() const;

    /**
     * Request the value of the property 'JobTimeoutRebootArgument' from the
     * D-Bus server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'JobTimeoutRebootArgument'</b>:
     *
     * JobTimeoutRebootArgument
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendJobTimeoutRebootArgumentGet(JobTimeoutRebootArgumentCallbackIF& cb);


    /**
     * Returns the current value of the property 'JobTimeoutRebootArgument'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasJobTimeoutRebootArgument() returns true.
     *
     * @return the previously received value of the property 'JobTimeoutRebootArgument'.
     */
    const ::std::string& getJobTimeoutRebootArgument() const;

    /**
     * Determines whether a status message for the property
     * 'JobTimeoutRebootArgument' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasJobTimeoutRebootArgument() const;

    // Property 'ConditionResult'

    /**
     * Notify on the property 'ConditionResult'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'ConditionResult'</b>:
     *
     * ConditionResult contains the condition result of the last time the configured
     * 		conditions of this unit were checked.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConditionResultRegister(ConditionResultCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'ConditionResult'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'ConditionResult'</b>:
     *
     * ConditionResult contains the condition result of the last time the configured
     * 		conditions of this unit were checked.
     *
     * @param act The act which was previously returned by the
     * sendConditionResultRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendConditionResultDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'ConditionResult'.
     */
    void sendConditionResultDeregisterAll() const;

    /**
     * Request the value of the property 'ConditionResult' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'ConditionResult'</b>:
     *
     * ConditionResult contains the condition result of the last time the configured
     * 		conditions of this unit were checked.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConditionResultGet(ConditionResultCallbackIF& cb);


    /**
     * Returns the current value of the property 'ConditionResult' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasConditionResult() returns true.
     *
     * @return the previously received value of the property 'ConditionResult'.
     */
    bool getConditionResult() const;

    /**
     * Determines whether a status message for the property 'ConditionResult'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasConditionResult() const;

    // Property 'AssertResult'

    /**
     * Notify on the property 'AssertResult'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'AssertResult'</b>:
     *
     * AssertResult
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAssertResultRegister(AssertResultCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'AssertResult'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'AssertResult'</b>:
     *
     * AssertResult
     *
     * @param act The act which was previously returned by the
     * sendAssertResultRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendAssertResultDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'AssertResult'.
     */
    void sendAssertResultDeregisterAll() const;

    /**
     * Request the value of the property 'AssertResult' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'AssertResult'</b>:
     *
     * AssertResult
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAssertResultGet(AssertResultCallbackIF& cb);


    /**
     * Returns the current value of the property 'AssertResult' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasAssertResult() returns true.
     *
     * @return the previously received value of the property 'AssertResult'.
     */
    bool getAssertResult() const;

    /**
     * Determines whether a status message for the property 'AssertResult' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAssertResult() const;

    // Property 'ConditionTimestamp'

    /**
     * Notify on the property 'ConditionTimestamp'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'ConditionTimestamp'</b>:
     *
     * ConditionTimestamp contain the CLOCK_REALTIME/CLOCK_MONOTONIC usec timestamps of the last time the configured conditions of the unit have been checked,
     * 		or 0 if they have never been checked. Conditions are checked when a unit is requested to start.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConditionTimestampRegister(ConditionTimestampCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'ConditionTimestamp'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'ConditionTimestamp'</b>:
     *
     * ConditionTimestamp contain the CLOCK_REALTIME/CLOCK_MONOTONIC usec timestamps of the last time the configured conditions of the unit have been checked,
     * 		or 0 if they have never been checked. Conditions are checked when a unit is requested to start.
     *
     * @param act The act which was previously returned by the
     * sendConditionTimestampRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendConditionTimestampDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'ConditionTimestamp'.
     */
    void sendConditionTimestampDeregisterAll() const;

    /**
     * Request the value of the property 'ConditionTimestamp' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'ConditionTimestamp'</b>:
     *
     * ConditionTimestamp contain the CLOCK_REALTIME/CLOCK_MONOTONIC usec timestamps of the last time the configured conditions of the unit have been checked,
     * 		or 0 if they have never been checked. Conditions are checked when a unit is requested to start.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConditionTimestampGet(ConditionTimestampCallbackIF& cb);


    /**
     * Returns the current value of the property 'ConditionTimestamp' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasConditionTimestamp() returns true.
     *
     * @return the previously received value of the property 'ConditionTimestamp'.
     */
    uint64 getConditionTimestamp() const;

    /**
     * Determines whether a status message for the property
     * 'ConditionTimestamp' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasConditionTimestamp() const;

    // Property 'ConditionTimestampMonotonic'

    /**
     * Notify on the property 'ConditionTimestampMonotonic'. This method
     * registers for property changes by D-Bus service.
     *
     * <b>Documentation of 'ConditionTimestampMonotonic'</b>:
     *
     * ConditionTimestampMonotonic contain the CLOCK_REALTIME/CLOCK_MONOTONIC usec timestamps of the last time the configured conditions of the unit have been checked,
     * 		or 0 if they have never been checked. Conditions are checked when a unit is requested to start.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConditionTimestampMonotonicRegister(ConditionTimestampMonotonicCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'ConditionTimestampMonotonic'. This
     * method deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'ConditionTimestampMonotonic'</b>:
     *
     * ConditionTimestampMonotonic contain the CLOCK_REALTIME/CLOCK_MONOTONIC usec timestamps of the last time the configured conditions of the unit have been checked,
     * 		or 0 if they have never been checked. Conditions are checked when a unit is requested to start.
     *
     * @param act The act which was previously returned by the
     * sendConditionTimestampMonotonicRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendConditionTimestampMonotonicDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property
     * 'ConditionTimestampMonotonic'.
     */
    void sendConditionTimestampMonotonicDeregisterAll() const;

    /**
     * Request the value of the property 'ConditionTimestampMonotonic' from
     * the D-Bus server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'ConditionTimestampMonotonic'</b>:
     *
     * ConditionTimestampMonotonic contain the CLOCK_REALTIME/CLOCK_MONOTONIC usec timestamps of the last time the configured conditions of the unit have been checked,
     * 		or 0 if they have never been checked. Conditions are checked when a unit is requested to start.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConditionTimestampMonotonicGet(ConditionTimestampMonotonicCallbackIF& cb);


    /**
     * Returns the current value of the property 'ConditionTimestampMonotonic'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasConditionTimestampMonotonic() returns true.
     *
     * @return the previously received value of the property 'ConditionTimestampMonotonic'.
     */
    uint64 getConditionTimestampMonotonic() const;

    /**
     * Determines whether a status message for the property
     * 'ConditionTimestampMonotonic' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasConditionTimestampMonotonic() const;

    // Property 'AssertTimestamp'

    /**
     * Notify on the property 'AssertTimestamp'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'AssertTimestamp'</b>:
     *
     * AssertTimestamp
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAssertTimestampRegister(AssertTimestampCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'AssertTimestamp'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'AssertTimestamp'</b>:
     *
     * AssertTimestamp
     *
     * @param act The act which was previously returned by the
     * sendAssertTimestampRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendAssertTimestampDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'AssertTimestamp'.
     */
    void sendAssertTimestampDeregisterAll() const;

    /**
     * Request the value of the property 'AssertTimestamp' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'AssertTimestamp'</b>:
     *
     * AssertTimestamp
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAssertTimestampGet(AssertTimestampCallbackIF& cb);


    /**
     * Returns the current value of the property 'AssertTimestamp' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasAssertTimestamp() returns true.
     *
     * @return the previously received value of the property 'AssertTimestamp'.
     */
    uint64 getAssertTimestamp() const;

    /**
     * Determines whether a status message for the property 'AssertTimestamp'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAssertTimestamp() const;

    // Property 'AssertTimestampMonotonic'

    /**
     * Notify on the property 'AssertTimestampMonotonic'. This method
     * registers for property changes by D-Bus service.
     *
     * <b>Documentation of 'AssertTimestampMonotonic'</b>:
     *
     * AssertTimestampMonotonic
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAssertTimestampMonotonicRegister(AssertTimestampMonotonicCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'AssertTimestampMonotonic'. This
     * method deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'AssertTimestampMonotonic'</b>:
     *
     * AssertTimestampMonotonic
     *
     * @param act The act which was previously returned by the
     * sendAssertTimestampMonotonicRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendAssertTimestampMonotonicDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property
     * 'AssertTimestampMonotonic'.
     */
    void sendAssertTimestampMonotonicDeregisterAll() const;

    /**
     * Request the value of the property 'AssertTimestampMonotonic' from the
     * D-Bus server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'AssertTimestampMonotonic'</b>:
     *
     * AssertTimestampMonotonic
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAssertTimestampMonotonicGet(AssertTimestampMonotonicCallbackIF& cb);


    /**
     * Returns the current value of the property 'AssertTimestampMonotonic'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasAssertTimestampMonotonic() returns true.
     *
     * @return the previously received value of the property 'AssertTimestampMonotonic'.
     */
    uint64 getAssertTimestampMonotonic() const;

    /**
     * Determines whether a status message for the property
     * 'AssertTimestampMonotonic' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAssertTimestampMonotonic() const;

    // Property 'Conditions'

    /**
     * Notify on the property 'Conditions'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Conditions'</b>:
     *
     * Conditions contains all configured conditions of the unit. For each condition five fields are given: condition type (e.g. ConditionPathExists),
     * 		whether the condition is a trigger condition, whether the condition is reversed, the right hand side of the condtion (e.g. the path in case of ConditionPathExists),
     * 		and the status. The status can be 0, in which case the condition hasn't been checked yet, a positive value, in which case the condition passed, or a negative value,
     * 		in which case the condition failed. Currently only 0, +1, and -1 are used, but additional values may be used in the future, retaining the meaning of zero/positive/negative values.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConditionsRegister(ConditionsCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Conditions'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'Conditions'</b>:
     *
     * Conditions contains all configured conditions of the unit. For each condition five fields are given: condition type (e.g. ConditionPathExists),
     * 		whether the condition is a trigger condition, whether the condition is reversed, the right hand side of the condtion (e.g. the path in case of ConditionPathExists),
     * 		and the status. The status can be 0, in which case the condition hasn't been checked yet, a positive value, in which case the condition passed, or a negative value,
     * 		in which case the condition failed. Currently only 0, +1, and -1 are used, but additional values may be used in the future, retaining the meaning of zero/positive/negative values.
     *
     * @param act The act which was previously returned by the
     * sendConditionsRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendConditionsDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Conditions'.
     */
    void sendConditionsDeregisterAll() const;

    /**
     * Request the value of the property 'Conditions' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Conditions'</b>:
     *
     * Conditions contains all configured conditions of the unit. For each condition five fields are given: condition type (e.g. ConditionPathExists),
     * 		whether the condition is a trigger condition, whether the condition is reversed, the right hand side of the condtion (e.g. the path in case of ConditionPathExists),
     * 		and the status. The status can be 0, in which case the condition hasn't been checked yet, a positive value, in which case the condition passed, or a negative value,
     * 		in which case the condition failed. Currently only 0, +1, and -1 are used, but additional values may be used in the future, retaining the meaning of zero/positive/negative values.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConditionsGet(ConditionsCallbackIF& cb);


    /**
     * Returns the current value of the property 'Conditions' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when
     * hasConditions() returns true.
     *
     * @return the previously received value of the property 'Conditions'.
     */
    const ::std::vector< condition >& getConditions() const;

    /**
     * Determines whether a status message for the property 'Conditions' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasConditions() const;

    // Property 'Asserts'

    /**
     * Notify on the property 'Asserts'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Asserts'</b>:
     *
     * Asserts
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAssertsRegister(AssertsCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Asserts'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Asserts'</b>:
     *
     * Asserts
     *
     * @param act The act which was previously returned by the
     * sendAssertsRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendAssertsDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Asserts'.
     */
    void sendAssertsDeregisterAll() const;

    /**
     * Request the value of the property 'Asserts' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Asserts'</b>:
     *
     * Asserts
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAssertsGet(AssertsCallbackIF& cb);


    /**
     * Returns the current value of the property 'Asserts' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasAsserts()
     * returns true.
     *
     * @return the previously received value of the property 'Asserts'.
     */
    const ::std::vector< condition >& getAsserts() const;

    /**
     * Determines whether a status message for the property 'Asserts' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAsserts() const;

    // Property 'LoadError'

    /**
     * Notify on the property 'LoadError'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'LoadError'</b>:
     *
     * LoadError contains a pair of strings. If the unit failed to load (as encoded in LoadState, see above),
     * 		then this will include a D-Bus error pair consisting of the error ID and an explanatory human readable string of what happened.
     * 		If it succeeded to load this will be a pair of empty strings.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendLoadErrorRegister(LoadErrorCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'LoadError'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'LoadError'</b>:
     *
     * LoadError contains a pair of strings. If the unit failed to load (as encoded in LoadState, see above),
     * 		then this will include a D-Bus error pair consisting of the error ID and an explanatory human readable string of what happened.
     * 		If it succeeded to load this will be a pair of empty strings.
     *
     * @param act The act which was previously returned by the
     * sendLoadErrorRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendLoadErrorDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'LoadError'.
     */
    void sendLoadErrorDeregisterAll() const;

    /**
     * Request the value of the property 'LoadError' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'LoadError'</b>:
     *
     * LoadError contains a pair of strings. If the unit failed to load (as encoded in LoadState, see above),
     * 		then this will include a D-Bus error pair consisting of the error ID and an explanatory human readable string of what happened.
     * 		If it succeeded to load this will be a pair of empty strings.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendLoadErrorGet(LoadErrorCallbackIF& cb);


    /**
     * Returns the current value of the property 'LoadError' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasLoadError()
     * returns true.
     *
     * @return the previously received value of the property 'LoadError'.
     */
    const loadError& getLoadError() const;

    /**
     * Determines whether a status message for the property 'LoadError' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasLoadError() const;

    // Property 'Transient'

    /**
     * Notify on the property 'Transient'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Transient'</b>:
     *
     * Transient contains a boolean that indicates whether the unit was created as transient unit
     * 		(i.e. via CreateTransientUnit() on the manager object).
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTransientRegister(TransientCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Transient'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Transient'</b>:
     *
     * Transient contains a boolean that indicates whether the unit was created as transient unit
     * 		(i.e. via CreateTransientUnit() on the manager object).
     *
     * @param act The act which was previously returned by the
     * sendTransientRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendTransientDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Transient'.
     */
    void sendTransientDeregisterAll() const;

    /**
     * Request the value of the property 'Transient' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Transient'</b>:
     *
     * Transient contains a boolean that indicates whether the unit was created as transient unit
     * 		(i.e. via CreateTransientUnit() on the manager object).
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTransientGet(TransientCallbackIF& cb);


    /**
     * Returns the current value of the property 'Transient' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasTransient()
     * returns true.
     *
     * @return the previously received value of the property 'Transient'.
     */
    bool getTransient() const;

    /**
     * Determines whether a status message for the property 'Transient' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasTransient() const;


    // Method 'Start'

    /**
     * Call the method 'Start'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'Start'</b>:
     *
     * Start(), Stop(), Reload(), Restart(), TryRestart(), ReloadOrRestart(), ReloadOrTryRestart(),
     * 		Kill(), ResetFailed() and SetProperties() implement the same operation as the respective method calls on the Manager
     * 		object (see above), however operate on the unit object and hence do not take a unit name parameter. Invoking the methods
     * 		directly on the Manager object has the advantage of not requiring a GetUnit() call to get the unit object for a specific
     * 		unit name. Calling the methods on the Manager object is hence a round trip optimization.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param mode If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStartRequest(StartCallbackIF& cb, const ::std::string& mode) const;

    // Method 'Stop'

    /**
     * Call the method 'Stop'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'Stop'</b>:
     *
     * Stop.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param mode If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStopRequest(StopCallbackIF& cb, const ::std::string& mode) const;

    // Method 'Reload'

    /**
     * Call the method 'Reload'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'Reload'</b>:
     *
     * Reload.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param mode If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReloadRequest(ReloadCallbackIF& cb, const ::std::string& mode) const;

    // Method 'Restart'

    /**
     * Call the method 'Restart'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'Restart'</b>:
     *
     * Restart.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param mode If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRestartRequest(RestartCallbackIF& cb, const ::std::string& mode) const;

    // Method 'TryRestart'

    /**
     * Call the method 'TryRestart'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'TryRestart'</b>:
     *
     * TryRestart.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param mode If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTryRestartRequest(TryRestartCallbackIF& cb, const ::std::string& mode) const;

    // Method 'ReloadOrRestart'

    /**
     * Call the method 'ReloadOrRestart'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'ReloadOrRestart'</b>:
     *
     * ReloadOrRestart.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param mode If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReloadOrRestartRequest(ReloadOrRestartCallbackIF& cb, const ::std::string& mode) const;

    // Method 'ReloadOrTryRestart'

    /**
     * Call the method 'ReloadOrTryRestart'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'ReloadOrTryRestart'</b>:
     *
     * ReloadOrTryRestart.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param mode If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReloadOrTryRestartRequest(ReloadOrTryRestartCallbackIF& cb, const ::std::string& mode) const;

    // Method 'Kill'

    /**
     * Call the method 'Kill'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'Kill'</b>:
     *
     * Kill.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param mode If the meaning of "mode" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendKillRequest(KillCallbackIF& cb, const ::std::string& mode) const;

    // Method 'ResetFailed'

    /**
     * Call the method 'ResetFailed'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'ResetFailed'</b>:
     *
     * ResetFailed.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendResetFailedRequest(ResetFailedCallbackIF& cb) const;

    // Method 'SetProperties'

    /**
     * Call the method 'SetProperties'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'SetProperties'</b>:
     *
     * SetProperties.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param runtime If the meaning of "runtime" isn't clear, then there should be a description here.
     *
     * @param properties If the meaning of "properties" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetPropertiesRequest(SetPropertiesCallbackIF& cb, bool runtime, const ::std::vector< property >& properties) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    UnitProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;

    virtual void clearAllProperties ();

    // Property 'Id'

    ::asf::core::nullable< IdUpdate > _id;

    // Property 'Names'

    ::asf::core::nullable< NamesUpdate > _names;

    // Property 'Following'

    ::asf::core::nullable< FollowingUpdate > _following;

    // Property 'Requires'

    ::asf::core::nullable< RequiresUpdate > _requires;

    // Property 'RequiresOverridable'

    ::asf::core::nullable< RequiresOverridableUpdate > _requiresOverridable;

    // Property 'Requisite'

    ::asf::core::nullable< RequisiteUpdate > _requisite;

    // Property 'RequisiteOverridable'

    ::asf::core::nullable< RequisiteOverridableUpdate > _requisiteOverridable;

    // Property 'Wants'

    ::asf::core::nullable< WantsUpdate > _wants;

    // Property 'BindsTo'

    ::asf::core::nullable< BindsToUpdate > _bindsTo;

    // Property 'PartOf'

    ::asf::core::nullable< PartOfUpdate > _partOf;

    // Property 'RequiredBy'

    ::asf::core::nullable< RequiredByUpdate > _requiredBy;

    // Property 'RequiredByOverridable'

    ::asf::core::nullable< RequiredByOverridableUpdate > _requiredByOverridable;

    // Property 'RequisiteOf'

    ::asf::core::nullable< RequisiteOfUpdate > _requisiteOf;

    // Property 'RequisiteOfOverridable'

    ::asf::core::nullable< RequisiteOfOverridableUpdate > _requisiteOfOverridable;

    // Property 'WantedBy'

    ::asf::core::nullable< WantedByUpdate > _wantedBy;

    // Property 'BoundBy'

    ::asf::core::nullable< BoundByUpdate > _boundBy;

    // Property 'ConsistsOf'

    ::asf::core::nullable< ConsistsOfUpdate > _consistsOf;

    // Property 'Conflicts'

    ::asf::core::nullable< ConflictsUpdate > _conflicts;

    // Property 'ConflictedBy'

    ::asf::core::nullable< ConflictedByUpdate > _conflictedBy;

    // Property 'Before'

    ::asf::core::nullable< BeforeUpdate > _before;

    // Property 'After'

    ::asf::core::nullable< AfterUpdate > _after;

    // Property 'OnFailure'

    ::asf::core::nullable< OnFailureUpdate > _onFailure;

    // Property 'Triggers'

    ::asf::core::nullable< TriggersUpdate > _triggers;

    // Property 'TriggeredBy'

    ::asf::core::nullable< TriggeredByUpdate > _triggeredBy;

    // Property 'PropagatesReloadTo'

    ::asf::core::nullable< PropagatesReloadToUpdate > _propagatesReloadTo;

    // Property 'ReloadPropagatedFrom'

    ::asf::core::nullable< ReloadPropagatedFromUpdate > _reloadPropagatedFrom;

    // Property 'JoinsNamespaceOf'

    ::asf::core::nullable< JoinsNamespaceOfUpdate > _joinsNamespaceOf;

    // Property 'RequiresMountsFor'

    ::asf::core::nullable< RequiresMountsForUpdate > _requiresMountsFor;

    // Property 'Documentation'

    ::asf::core::nullable< DocumentationUpdate > _documentation;

    // Property 'Description'

    ::asf::core::nullable< DescriptionUpdate > _description;

    // Property 'LoadState'

    ::asf::core::nullable< LoadStateUpdate > _loadState;

    // Property 'ActiveState'

    ::asf::core::nullable< ActiveStateUpdate > _activeState;

    // Property 'SubState'

    ::asf::core::nullable< SubStateUpdate > _subState;

    // Property 'FragmentPath'

    ::asf::core::nullable< FragmentPathUpdate > _fragmentPath;

    // Property 'SourcePath'

    ::asf::core::nullable< SourcePathUpdate > _sourcePath;

    // Property 'DropInPaths'

    ::asf::core::nullable< DropInPathsUpdate > _dropInPaths;

    // Property 'UnitFileState'

    ::asf::core::nullable< UnitFileStateUpdate > _unitFileState;

    // Property 'UnitFilePreset'

    ::asf::core::nullable< UnitFilePresetUpdate > _unitFilePreset;

    // Property 'InactiveExitTimestamp'

    ::asf::core::nullable< InactiveExitTimestampUpdate > _inactiveExitTimestamp;

    // Property 'InactiveExitTimestampMonotonic'

    ::asf::core::nullable< InactiveExitTimestampMonotonicUpdate > _inactiveExitTimestampMonotonic;

    // Property 'ActiveEnterTimestamp'

    ::asf::core::nullable< ActiveEnterTimestampUpdate > _activeEnterTimestamp;

    // Property 'ActiveEnterTimestampMonotonic'

    ::asf::core::nullable< ActiveEnterTimestampMonotonicUpdate > _activeEnterTimestampMonotonic;

    // Property 'ActiveExitTimestamp'

    ::asf::core::nullable< ActiveExitTimestampUpdate > _activeExitTimestamp;

    // Property 'ActiveExitTimestampMonotonic'

    ::asf::core::nullable< ActiveExitTimestampMonotonicUpdate > _activeExitTimestampMonotonic;

    // Property 'InactiveEnterTimestamp'

    ::asf::core::nullable< InactiveEnterTimestampUpdate > _inactiveEnterTimestamp;

    // Property 'InactiveEnterTimestampMonotonic'

    ::asf::core::nullable< InactiveEnterTimestampMonotonicUpdate > _inactiveEnterTimestampMonotonic;

    // Property 'CanStart'

    ::asf::core::nullable< CanStartUpdate > _canStart;

    // Property 'CanStop'

    ::asf::core::nullable< CanStopUpdate > _canStop;

    // Property 'CanReload'

    ::asf::core::nullable< CanReloadUpdate > _canReload;

    // Property 'CanIsolate'

    ::asf::core::nullable< CanIsolateUpdate > _canIsolate;

    // Property 'Job'

    ::asf::core::nullable< JobUpdate > _job;

    // Property 'StopWhenUnneeded'

    ::asf::core::nullable< StopWhenUnneededUpdate > _stopWhenUnneeded;

    // Property 'RefuseManualStart'

    ::asf::core::nullable< RefuseManualStartUpdate > _refuseManualStart;

    // Property 'RefuseManualStop'

    ::asf::core::nullable< RefuseManualStopUpdate > _refuseManualStop;

    // Property 'AllowIsolate'

    ::asf::core::nullable< AllowIsolateUpdate > _allowIsolate;

    // Property 'DefaultDependencies'

    ::asf::core::nullable< DefaultDependenciesUpdate > _defaultDependencies;

    // Property 'OnFailureJobMode'

    ::asf::core::nullable< OnFailureJobModeUpdate > _onFailureJobMode;

    // Property 'IgnoreOnIsolate'

    ::asf::core::nullable< IgnoreOnIsolateUpdate > _ignoreOnIsolate;

    // Property 'IgnoreOnSnapshot'

    ::asf::core::nullable< IgnoreOnSnapshotUpdate > _ignoreOnSnapshot;

    // Property 'NeedDaemonReload'

    ::asf::core::nullable< NeedDaemonReloadUpdate > _needDaemonReload;

    // Property 'JobTimeoutUSec'

    ::asf::core::nullable< JobTimeoutUSecUpdate > _jobTimeoutUSec;

    // Property 'JobTimeoutAction'

    ::asf::core::nullable< JobTimeoutActionUpdate > _jobTimeoutAction;

    // Property 'JobTimeoutRebootArgument'

    ::asf::core::nullable< JobTimeoutRebootArgumentUpdate > _jobTimeoutRebootArgument;

    // Property 'ConditionResult'

    ::asf::core::nullable< ConditionResultUpdate > _conditionResult;

    // Property 'AssertResult'

    ::asf::core::nullable< AssertResultUpdate > _assertResult;

    // Property 'ConditionTimestamp'

    ::asf::core::nullable< ConditionTimestampUpdate > _conditionTimestamp;

    // Property 'ConditionTimestampMonotonic'

    ::asf::core::nullable< ConditionTimestampMonotonicUpdate > _conditionTimestampMonotonic;

    // Property 'AssertTimestamp'

    ::asf::core::nullable< AssertTimestampUpdate > _assertTimestamp;

    // Property 'AssertTimestampMonotonic'

    ::asf::core::nullable< AssertTimestampMonotonicUpdate > _assertTimestampMonotonic;

    // Property 'Conditions'

    ::asf::core::nullable< ConditionsUpdate > _conditions;

    // Property 'Asserts'

    ::asf::core::nullable< AssertsUpdate > _asserts;

    // Property 'LoadError'

    ::asf::core::nullable< LoadErrorUpdate > _loadError;

    // Property 'Transient'

    ::asf::core::nullable< TransientUpdate > _transient;

    DECLARE_CLASS_LOGGER();

    friend class UnitProxyCallback;
};

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org

#endif // ORG_FREEDESKTOP_SYSTEMD1_UNITPROXY_H
